// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import './base_page.js';
import './shimless_rma_shared.css.js';
import 'chrome://resources/ash/common/cr_elements/cr_dialog/cr_dialog.js';
import 'chrome://resources/ash/common/cr_elements/cr_button/cr_button.js';
import { I18nMixin } from 'chrome://resources/ash/common/cr_elements/i18n_mixin.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { getTemplate } from './hardware_error_page.html.js';
import { getShimlessRmaService } from './mojo_interface_provider.js';
import { disableAllButtons, focusPageTitle } from './shimless_rma_util.js';
/**
 * @fileoverview
 * 'hardware-error-page' is displayed when an unexpected error blocks RMA from
 * continuing.
 */
const HardwareErrorPageBase = I18nMixin(PolymerElement);
export class HardwareErrorPage extends HardwareErrorPageBase {
    constructor() {
        super(...arguments);
        this.shimlessRmaService = getShimlessRmaService();
    }
    static get is() {
        return 'hardware-error-page';
    }
    static get template() {
        return getTemplate();
    }
    static get properties() {
        return {
            /**
             * Set by shimless_rma.js.
             */
            allButtonsDisabled: Boolean,
            /**
             * Set by shimless_rma.js.
             */
            errorCode: Number,
        };
    }
    ready() {
        super.ready();
        focusPageTitle(this);
    }
    onShutDownButtonClicked() {
        this.shimlessRmaService.shutDownAfterHardwareError();
        disableAllButtons(this, /* showBusyStateOverlay= */ true);
    }
    getErrorCodeString() {
        return this.i18n('hardwareErrorCode', this.errorCode);
    }
}
customElements.define(HardwareErrorPage.is, HardwareErrorPage);
