import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-shared-style shimless-rma-shared shimless-fonts">#dialogBody{overflow-wrap:anywhere}cr-input{font-family:var(--shimless-hint-font-family);--cr-input-error-display:none}#inputValidationLabel{color:var(--shimless-hint-text-color);font-family:var(--shimless-hint-font-family);font-size:var(--shimless-hint-font-size);font-weight:var(--shimless-medium-font-weight);line-height:var(--shimless-hint-line-height)}:host([rsu-code-invalid]) #inputValidationLabel{color:red}#inputContainer{width:275px}#rsuCode{padding-bottom:8px;width:320px}#rsuCodeDialogLink{color:var(--cros-link-color)}#qrCodeImg{width:180px}#qrCodeWrapper{align-items:center;display:flex;height:100%;justify-content:center;width:100%}</style>

<base-page>
  <div slot="left-pane">
    <h1 tabindex="-1">[[i18n('rsuCodePageTitleText')]]</h1>
    <div class="instructions">
      <span inner-h-t-m-l="[[rsuInstructionsText]]"></span>
    </div>
    <div id="inputContainer">
      <cr-input
          id="rsuCode"
          value="{{rsuCode}}"
          on-keydown="onKeyDown"
          maxlength="[[rsuCodeExpectedLength]]"
          invalid="[[rsuCodeInvalid]]"
          disabled="[[allButtonsDisabled]]"
          error-message="[[i18n('rsuCodeErrorLabelText')]]"
          aria-label="[[i18n('rsuCodePageTitleText')]]"
          aria-description="[[getRsuAriaDescription(rsuCodeInvalid)]]">
      </cr-input>
      <div id="inputValidationLabel">
        [[getRsuCodeLabelText(rsuCodeInvalid)]]
      </div>
    </div>
  </div>
  <div slot="right-pane">
    <div id="qrCodeWrapper">
      <img id="qrCodeImg" src="[[qrCodeUrl]]">
    </div>
    </canvas>
  </div>
</base-page>

<cr-dialog id="rsuChallengeDialog" on-cancel="closeDialog" ignore-popstate>
  <div slot="title">[[i18n('rsuChallengeDialogTitleText')]]</div>
  <div slot="body" id="dialogBody">[[rsuChallengeLinkText]]</div>
  <div class="dialog-footer" slot="button-container">
    <cr-button class="action-button" on-click="closeDialog">
      [[i18n('rsuChallengeDialogDoneButtonLabel')]]
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
