import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-shared-style shimless-rma-shared">#reworkFlowLink{color:var(--cros-link-color)}</style>

<base-page>
  <div slot="left-pane">
    <h1 tabindex="-1">[[i18n('selectComponentsTitleText')]]</h1>
    <div class="instructions">
      <span inner-h-t-m-l="[[reworkFlowLinkText]]"></span>
    </div>
  </div>
  <div slot="right-pane">
    <div class="scroll-container">
      <div id="componentList" class="component-grid repair">
        <template is="dom-repeat" items="{{componentCheckboxes}}"
            as="component">
          <repair-component-chip id="[[component.id]]"
            unique-id="[[component.uniqueId]]"
            checked="{{component.checked}}"
            disabled$="[[isComponentDisabled(component.disabled,
                allButtonsDisabled)]]"
            component-name="[[component.name]]"
            component-identifier="[[component.identifier]]"
            is-first-clickable-component=
                "[[component.isFirstClickableComponent]]">
          </repair-component-chip>
        </template>
      </div>
      <div class="gradient unequal-panes"></div>
    </div>
  </div>
</base-page>
<!--_html_template_end_-->`;
}
