import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-shared-style shimless-rma-shared shimless-fonts">:host{padding:2px}:host([checked]) #componentButton{background-color:var(--google-blue-50)}:host([disabled]) #componentButton{opacity:0.38}:host([disabled]) #componentName{color:var(--cros-text-color-disabled)}:host([disabled]) #componentIdentifier{color:var(--cros-text-color-disabled)}:focus{outline:rgba(var(--google-blue-600-rgb),.4) solid 2px}#componentButton{--vertical-padding:24px;border:none;border-radius:8px;box-shadow:var(--cros-elevation-2-shadow);height:calc((2 * var(--vertical-padding)) + var(--shimless-component-line-height) + var(--shimless-component-description-line-height));padding:0;width:100%}#labelDiv{flex-basis:155px;inset-inline-start:0;padding-inline-start:24px;position:absolute}:host([checked]) #componentName,:host([checked]) #componentIdentifier{color:var(--google-blue-700)}#componentName{color:var(--shimless-component-text-color);font-family:var(--shimless-component-font-family);font-size:var(--shimless-component-font-size);font-weight:var(--shimless-medium-font-weight);line-height:var(--shimless-component-line-height)}#componentIdentifier{color:var(--shimless-component-description-text-color);font-family:var(--shimless-component-description-font-family);font-size:var(--shimless-component-description-font-size);font-weight:var(--shimless-regular-font-weight);line-height:var(--shimless-component-description-line-height)}iron-icon{margin-top:6px}.chip-icon{height:20px;inset-inline-end:16px;position:absolute;width:20px}:host([checked]) #checkIcon{color:var(--google-blue-700)}</style>

<div id="componentButtonWrapper">
  <cr-button id="componentButton" disabled="[[disabled]]"
      on-click="onComponentButtonClicked"
      aria-labelledby="componentName componentIdentifier"
      aria-pressed$="[[isAriaPressed(checked)]]">
    <div id="labelDiv" aria-hidden="true">
      <span id="componentName">[[componentName]]</span>
      <div id="componentIdentifier">[[componentIdentifier]]</div>
    </div>
    <iron-icon id="checkIcon" class="chip-icon"
        icon="shimless-icon24:check-circle" hidden="[[!checked]]">
    </iron-icon>
    <iron-icon id="infoIcon" class="chip-icon" icon="shimless-icon:info"
        hidden="[[!disabled]]">
    </iron-icon>
  </cr-button>
</div>
<paper-tooltip for="componentButtonWrapper" hidden="[[!disabled]]"
    aria-hidden="true">
  [[i18n('undetectedComponentText')]]
</paper-tooltip>
<!--_html_template_end_-->`;
}
