// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import 'chrome://resources/ash/common/cr_elements/icons.html.js';
import 'chrome://resources/polymer/v3_0/iron-icon/iron-icon.js';
import 'chrome://resources/ash/common/cr_elements/cr_button/cr_button.js';
import './shimless_rma_shared.css.js';
import './base_page.js';
import './icons.html.js';
import { I18nMixin } from 'chrome://resources/ash/common/cr_elements/i18n_mixin.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { getShimlessRmaService } from './mojo_interface_provider.js';
import { executeThenTransitionState, focusPageTitle } from './shimless_rma_util.js';
import { getTemplate } from './wrapup_restock_page.html.js';
/**
 * @fileoverview
 * 'wrapup-restock-page' is the page that informs the repair technician they
 * can shut down the device and restock the mainboard or continue to finalize
 * the repair if the board is being used to repair another device.
 */
const WrapupRestockPageBase = I18nMixin(PolymerElement);
export class WrapupRestockPage extends WrapupRestockPageBase {
    static get is() {
        return 'wrapup-restock-page';
    }
    static get template() {
        return getTemplate();
    }
    static get properties() {
        return {
            /**
             * Set by shimless_rma.ts.
             */
            allButtonsDisabled: Boolean,
        };
    }
    constructor() {
        super();
        this.shimlessRmaService = getShimlessRmaService();
        this.shimlessRmaService = getShimlessRmaService();
    }
    ready() {
        super.ready();
        focusPageTitle(this);
    }
    onShutdownButtonClicked() {
        executeThenTransitionState(this, () => this.shimlessRmaService.shutdownForRestock());
    }
    onRestockContinueButtonClicked() {
        executeThenTransitionState(this, () => this.shimlessRmaService.continueFinalizationAfterRestock());
    }
}
customElements.define(WrapupRestockPage.is, WrapupRestockPage);
