import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><style include="shortcut-customization-shared">:host-context(body.jelly-enabled) #addIcon,:host-context(body.jelly-enabled) #restoreDefault{background:var(--cros-sys-primary_container);color:var(--cros-sys-on_primary_container);font:var(--cros-button-2-font)}:host-context(body.jelly-enabled) #doneButton{background:var(--cros-sys-primary);color:var(--cros-sys-on_primary);font:var(--cros-button-2-font)}#acceleratorViewList{display:grid}#acceleratorViewList accelerator-edit-view:not(:last-of-type){border-bottom:var(--cr-separator-line)}#addIcon{padding-top:11px}#addAcceleratorContainer{padding-top:16px}#emptyStateContainer{padding-block-start:8px}[slot='button-container']{--cr-dialog-button-container-padding-bottom:28px;--cr-dialog-button-container-padding-horizontal:32px;display:flex;justify-content:space-between;padding-top:32px}cr-button{border-radius:999px}[slot='body']{background-color:var(--cros-sys-app_base_shaded);border-radius:16px;display:flex;flex-direction:column;justify-content:space-between;margin-left:32px;margin-right:32px;min-height:280px;overflow:auto;padding:0 8px 8px 8px}#dialogTitle{--cr-dialog-title-slot-padding-bottom:16px;--cr-dialog-title-slot-padding-end:32px;--cr-dialog-title-slot-padding-start:32px;--cr-dialog-title-slot-padding-top:32px}#shortcutEditTitle{color:var(--cros-text-color-primary);font:var(--cros-display-7-font);padding-block-end:8px}#shortcutDescription,#noShortcutAssigned{font:var(--cros-body-2-font);color:var(--cros-text-color-secondary)}#noShortcutAssigned{padding-block:16px;padding-inline-start:8px}[slot='button-container']{display:flex;justify-content:space-between}#maxAcceleratorsReached{padding-block-start:8px;padding-block-end:4px}</style>

<cr-dialog id="editDialog" on-close="onDialogClose">
  <div id="dialogTitle" slot="title">
    <div id="shortcutEditTitle">
      [[i18n('editShortcut')]]
    </div>
    <div id="shortcutDescription">
      [[description]]
    </div>
  </div>
  <div slot="body">
    <div id="acceleratorViewList">
      <template id="viewList" is="dom-repeat"
          items="[[getSortedFilteredAccelerators(acceleratorInfos)]]">
        <accelerator-edit-view class="acceleratorItem"
            accelerator-info=[[item]]
            action="[[action]]"
            source="[[source]]"
            on-edit-action-completed="onEditActionCompleted">
        </accelerator-edit-view>
      </template>
      <!-- Using 'restamp' ensures the correct display of the separator line,
           as it can remove 'pendingAccelerator' from the DOM rather than just
           hiding it, preventing it from affecting the separator line
           placement. -->
      <template id="newAccelerator" is="dom-if"
          if="[[showNewAccelerator(pendingNewAcceleratorState,
                                   acceleratorInfos)]]" restamp>
        <accelerator-edit-view id="pendingAccelerator"
            view-state="{{pendingNewAcceleratorState}}"
            action="[[action]]"
            source="[[source]]"
            on-edit-action-completed="onEditActionCompleted">
        </accelerator-edit-view>
      </template>
      <template id="emptyState" is="dom-if"
          if="[[isEmptyState(pendingNewAcceleratorState, acceleratorInfos)]]"
          restamp>
        <div id="emptyStateContainer">
          <div id="noShortcutAssigned">
            [[i18n('noShortcutAssigned')]]
          </div>
        </div>
      </template>
    </div>
    <div id="addAcceleratorContainer"
        hidden="[[!showAddButton(pendingNewAcceleratorState, acceleratorInfos,
          isAcceleratorCapturing, observableDefaultAcceleratorsWithConflict.*)]]">
      <cr-button id="addAcceleratorButton" on-click="onAddAcceleratorClicked">
        <iron-icon id="addIcon" icon="shortcut-customization:add">
        </iron-icon>
        [[i18n('addShortcut')]]
      </cr-button>
    </div>
    <div id="maxAcceleratorsReached"
        hidden="[[acceleratorLimitNotReached(acceleratorInfos)]]">
      [[i18n('maxAcceleratorsReachedHint')]]
    </div>
  </div>
  <div slot="button-container">
    <div>
      <cr-button id="restoreDefault" on-click="onRestoreDefaultButtonClicked"
          hidden="[[shouldHideRestoreButton]]">
        [[i18n('restoreDefaults')]]
      </cr-button>
    </div>
    <div>
      <cr-button id="doneButton" on-click="onDoneButtonClicked"
          disabled="[[isAcceleratorCapturing]]">
        [[i18n('editDialogDone')]]
      </cr-button>
    </div>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}