// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./accelerator_edit_view.js";import"../css/shortcut_customization_shared.css.js";import"chrome://resources/ash/common/cr_elements/cr_button/cr_button.js";import"chrome://resources/ash/common/cr_elements/cr_dialog/cr_dialog.js";import"chrome://resources/ash/common/cr_elements/cr_input/cr_input.js";import{getInstance as getAnnouncerInstance}from"chrome://resources/ash/common/cr_elements/cr_a11y_announcer/cr_a11y_announcer.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{assert}from"chrome://resources/js/assert.js";import{EventTracker}from"chrome://resources/js/event_tracker.js";import{flush,PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{EditDialogCompletedActions,UserAction}from"../mojom-webui/shortcut_customization.mojom-webui.js";import{getTemplate}from"./accelerator_edit_dialog.html.js";import{ViewState}from"./accelerator_view.js";import{getShortcutProvider}from"./mojo_interface_provider.js";import{AcceleratorConfigResult,AcceleratorState,EditAction}from"./shortcut_types.js";import{compareAcceleratorInfos,getAccelerator,isStandardAcceleratorInfo}from"./shortcut_utils.js";const MAX_NUM_ACCELERATORS=5;const AcceleratorEditDialogElementBase=I18nMixin(PolymerElement);export class AcceleratorEditDialogElement extends AcceleratorEditDialogElementBase{constructor(){super(...arguments);this.defaultAcceleratorsWithConflict=new Set;this.eventTracker=new EventTracker;this.completedActions=EditDialogCompletedActions.kNoAction}static get is(){return"accelerator-edit-dialog"}static get template(){return getTemplate()}static get properties(){return{description:{type:String,value:""},acceleratorInfos:{type:Array,value:()=>[],observer:AcceleratorEditDialogElement.prototype.onAcceleratorInfosChanged},pendingNewAcceleratorState:{type:Number,value:ViewState.VIEW},action:{type:Number,value:0},source:{type:Number,value:0},isAcceleratorCapturing:{type:Boolean,value:false},observableDefaultAcceleratorsWithConflict:{type:Array,value:()=>[]},shouldHideRestoreButton:{type:Boolean,value:true}}}connectedCallback(){super.connectedCallback();this.$.editDialog.showModal();this.$.editDialog.shadowRoot.querySelector("#dialog").removeAttribute("aria-describedby");this.$.editDialog.setTitleAriaLabel(this.i18n("editDialogAriaLabel",this.description));this.eventTracker.add(window,"accelerator-capturing-started",(()=>this.onAcceleratorCapturingStarted()));this.eventTracker.add(window,"accelerator-capturing-ended",(()=>this.onAcceleratorCapturingEnded()));this.eventTracker.add(this,"default-conflict-resolved",(e=>this.onDefaultConflictResolved(e)));getShortcutProvider().recordUserAction(UserAction.kOpenEditDialog)}disconnectedCallback(){super.disconnectedCallback();this.completedActions=0;this.eventTracker.removeAll();this.set("acceleratorInfos",[]);this.shouldSnapshotConflictDefaults=false;this.defaultAcceleratorsWithConflict.clear();this.updateObservableAcceleratorsWithConflict()}getViewList(){const viewList=this.shadowRoot.querySelector("#viewList");assert(viewList);return viewList}updateDialogAccelerators(updatedAccelerators){if(this.shouldSnapshotConflictDefaults){this.shouldSnapshotConflictDefaults=false;for(const acceleratorInfo of updatedAccelerators){if(acceleratorInfo.state===AcceleratorState.kDisabledByUser&&isStandardAcceleratorInfo(acceleratorInfo)){this.defaultAcceleratorsWithConflict.add(JSON.stringify(getAccelerator(acceleratorInfo)));this.updateObservableAcceleratorsWithConflict()}}}this.set("acceleratorInfos",[]);this.getViewList().render();this.acceleratorInfos=updatedAccelerators.filter((accel=>accel.state!==AcceleratorState.kDisabledByUnavailableKeys))}onDoneButtonClicked(){this.$.editDialog.close()}onDialogClose(){getShortcutProvider().recordEditDialogCompletedActions(this.completedActions);this.dispatchEvent(new CustomEvent("edit-dialog-closed",{bubbles:true,composed:true}))}onAcceleratorCapturingStarted(){this.isAcceleratorCapturing=true}onAcceleratorCapturingEnded(){this.isAcceleratorCapturing=false;this.focusAddOrDone()}onDefaultConflictResolved(e){assert(this.defaultAcceleratorsWithConflict.delete(e.detail.stringifiedAccelerator));this.updateObservableAcceleratorsWithConflict()}onEditActionCompleted(e){this.updateCompletedActions(e.detail.editAction)}updateCompletedActions(editAction){this.announceCompleteActions(editAction);this.completedActions|=editAction}focusAcceleratorItemContainer(){const editView=this.$.editDialog.querySelector("#pendingAccelerator");assert(editView);const accelItem=editView.shadowRoot.querySelector("#acceleratorItem");assert(accelItem);const container=accelItem.shadowRoot.querySelector("#container");assert(container);container.focus()}focusAddOrDone(){const selector=this.acceleratorLimitNotReached()?"#addAcceleratorButton":"#doneButton";const buttonToFocus=this.$.editDialog.querySelector(selector);assert(buttonToFocus);buttonToFocus.focus()}onAddAcceleratorClicked(){this.pendingNewAcceleratorState=ViewState.ADD;flush();this.focusAcceleratorItemContainer();getShortcutProvider().recordUserAction(UserAction.kStartAddAccelerator)}showNewAccelerator(){return this.pendingNewAcceleratorState===ViewState.ADD&&this.acceleratorLimitNotReached()}showAddButton(){return this.pendingNewAcceleratorState!==ViewState.ADD&&this.acceleratorLimitNotReached()&&this.defaultAcceleratorsWithConflict.size===0}isEmptyState(){return this.pendingNewAcceleratorState===ViewState.VIEW&&this.getSortedFilteredAccelerators(this.acceleratorInfos).length===0}acceleratorLimitNotReached(){let originalAcceleratorsCount=0;for(const acceleratorInfo of this.acceleratorInfos){if(isStandardAcceleratorInfo(acceleratorInfo)){if(acceleratorInfo.layoutProperties.standardAccelerator?.originalAccelerator!==undefined||acceleratorInfo.state!==AcceleratorState.kEnabled){continue}++originalAcceleratorsCount}}return originalAcceleratorsCount<MAX_NUM_ACCELERATORS}onRestoreDefaultButtonClicked(){getShortcutProvider().restoreDefault(this.source,this.action).then((({result:result})=>{getShortcutProvider().recordUserAction(UserAction.kResetAction);if(result.result===AcceleratorConfigResult.kSuccess){this.requestUpdateAccelerator(this.source,this.action);this.updateCompletedActions(EditAction.RESET)}else if(result.result===AcceleratorConfigResult.kRestoreSuccessWithConflicts){this.shouldSnapshotConflictDefaults=true;this.requestUpdateAccelerator(this.source,this.action)}}))}getSortedFilteredAccelerators(accelerators){const filteredAccelerators=accelerators.filter((accel=>{const hasDefaultConflicts=this.defaultAcceleratorsWithConflict.size!==0;if(hasDefaultConflicts&&isStandardAcceleratorInfo(accel)){return this.defaultAcceleratorsWithConflict.has(JSON.stringify(getAccelerator(accel)))&&accel.state!==AcceleratorState.kDisabledByUnavailableKeys}return accel.state!==AcceleratorState.kDisabledByUser&&accel.state!==AcceleratorState.kDisabledByUnavailableKeys}));return filteredAccelerators.sort(compareAcceleratorInfos)}requestUpdateAccelerator(source,action){this.dispatchEvent(new CustomEvent("request-update-accelerator",{bubbles:true,composed:true,detail:{source:source,action:action}}))}updateObservableAcceleratorsWithConflict(){this.set("observableDefaultAcceleratorsWithConflict",Array.from(this.defaultAcceleratorsWithConflict))}async onAcceleratorInfosChanged(){this.shouldHideRestoreButton=await this.areAcceleratorsDefault()}async areAcceleratorsDefault(){const currentAccelerators=this.getSortedFilteredAccelerators(this.acceleratorInfos);const defaultAccelerators=await getShortcutProvider().getDefaultAcceleratorsForId(this.action);if(currentAccelerators.length!=defaultAccelerators.accelerators.length){return false}return currentAccelerators.every((acceleratorInfo=>isStandardAcceleratorInfo(acceleratorInfo)&&defaultAccelerators.accelerators.some((defaultAccelerator=>JSON.stringify(defaultAccelerator)===JSON.stringify(getAccelerator(acceleratorInfo))))))}announceCompleteActions(editAction){let message="";switch(editAction){case EditAction.ADD:message=this.i18n("shortcutAdded");break;case EditAction.EDIT:message=this.i18n("shortcutEdited");break;case EditAction.REMOVE:message=this.i18n("shortcutDeleted");break;case EditAction.RESET:message=this.i18n("shortcutRestored");break;default:return}getAnnouncerInstance(this.$.editDialog.getNative()).announce(message)}}customElements.define(AcceleratorEditDialogElement.is,AcceleratorEditDialogElement);