import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><style include="shortcut-customization-shared">:host{--error-info-text-color:var(--cros-color-alert);--edit-border-error-color:var(--cros-color-alert);--button-fill-color:var(--cros-button-icon-color-secondary)}:host-context(body.jelly-enabled){--error-info-text-color:var(--cros-sys-error);--edit-border-error-color:var(--cros-sys-error);--button-fill-color:var(--cros-sys-on_surface)}#container{padding-block:8px}hr{background:var(--cros-separator-color);border:none;height:16px;margin-inline:8px;width:1px}#container{display:flex;flex-direction:row;height:52px;justify-content:space-between}#acceleratorView{align-items:center;display:flex;flex:1;margin-block:10px;margin-inline-end:0;margin-inline-start:10px}#editButtonsContainer{align-items:center;display:flex;margin-block:10px}.lock-icon-container{margin:10px}#editButtonsContainer[hidden]{display:none}#cancelButtonContainer{align-self:center;margin-inline-start:10px}#editButton,#deleteButton,#cancelButton{margin:0}#acceleratorView accelerator-view{flex:1}:host([has-error]:not([has-warning])) #acceleratorInfoText{color:var(--error-info-text-color)}.clickable-button{--cr-icon-button-fill-color:var(--button-fill-color);--cr-icon-button-size:40px;border-radius:12px}:host-context(body.jelly-enabled) .clickable-button{background-color:var(--cros-sys-surface_variant)}:host-context(body.jelly-enabled) .clickable-button:hover{background-color:var(--cros-sys-ripple_neutral_on_subtle)}#cancelButton,#deleteButton{--cr-icon-button-icon-start-offset:0.5px}:host([is-edit-view]) #acceleratorView{background-color:var(--cros-sys-input_field_on_base);border-color:var(--cros-sys-focus_ring);border-radius:10px;border-style:solid;border-width:2px;height:52px;margin:0;padding-inline:10px}:host([is-edit-view][has-error]:not([has-warning])) #acceleratorView{border-color:var(--edit-border-error-color)}</style>

<div id="container">
  <div id="acceleratorView">
    <accelerator-view id="acceleratorItem"
        accelerator-info="[[acceleratorInfo]]" view-state="{{viewState}}"
        status-message="{{statusMessage}}" has-error="{{hasError}}"
        recorded-error="{{recordedError}}"
        action="[[action]]" source="[[source]]">
    </accelerator-view>
  </div>
  <template id="buttonContainer" is="dom-if"
      if="[[!acceleratorInfo.acceleratorLocked]]">
    <div id="editButtonsContainer" hidden="[[showEditView(viewState)]]">
      <cr-icon-button id="editButton"
          aria-label="[[getEditAriaLabel(acceleratorInfo)]]"
          class="clickable-button"
          iron-icon="shortcut-customization:edit"
          on-click="onEditButtonClicked">
      </cr-icon-button>
      <hr aria-hidden="true">
      <cr-icon-button id="deleteButton"
          aria-label="[[getDeleteAriaLabel(acceleratorInfo)]]"
          class="clickable-button"
          iron-icon="shortcut-customization:delete"
          on-click="onDeleteButtonClicked">
      </cr-icon-button>
    </div>
    <div id="cancelButtonContainer" hidden="[[!showEditView(viewState)]]">
      <cr-icon-button id="cancelButton" class="clickable-button"
          aria-label="[[i18n('cancelButtonAriaLabel')]]"
          iron-icon="shortcut-customization:cancel" aria-hidden="true"
          on-click="onCancelButtonClicked">
      </cr-icon-button>
    </div>
  </template>
  <template is="dom-if" if="[[acceleratorInfo.acceleratorLocked]]">
    <div class="lock-icon-container" hidden="[[showEditView(viewState)]]">
      <iron-icon icon="shortcut-customization:lock"></iron-icon>
    </div>
  </template>
</div>

<div id="acceleratorInfoText"
    hidden="[[!showStatusMessage(viewState, acceleratorInfo)]]">
    <localized-link id="status" localized-string="[[statusMessage]]"
        link-url="[[i18n('shortcutCustomizationLearnMoreUrl')]]">
    </localized-link>
</div><!--_html_template_end_-->`}