// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"../common/icons.html.js";import"../css/shortcut_customization_shared.css.js";import"chrome://resources/ash/common/cr_elements/cr_icon_button/cr_icon_button.js";import"chrome://resources/ash/common/cr_elements/cr_icons.css.js";import"chrome://resources/ash/common/cr_elements/icons.html.js";import"chrome://resources/ash/common/cr_elements/localized_link/localized_link.js";import"chrome://resources/polymer/v3_0/iron-icon/iron-icon.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{strictQuery}from"chrome://resources/ash/common/typescript_utils/strict_query.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{Subactions,UserAction}from"../mojom-webui/shortcut_customization.mojom-webui.js";import{getTemplate}from"./accelerator_edit_view.html.js";import{AcceleratorLookupManager}from"./accelerator_lookup_manager.js";import{AcceleratorViewElement,ViewState}from"./accelerator_view.js";import{getShortcutProvider}from"./mojo_interface_provider.js";import{AcceleratorConfigResult,AcceleratorKeyState,AcceleratorState,AcceleratorType,EditAction,MetaKey}from"./shortcut_types.js";import{getAccelerator,getAriaLabelForStandardAcceleratorInfo}from"./shortcut_utils.js";const accelerator={modifiers:0,keyCode:0,keyState:AcceleratorKeyState.PRESSED};const standardAcceleratorInfoState={acceleratorLocked:false,locked:false,state:AcceleratorState.kEnabled,type:AcceleratorType.kDefault,layoutProperties:{standardAccelerator:{accelerator:accelerator,keyDisplay:""}}};const AcceleratorEditViewElementBase=I18nMixin(PolymerElement);export class AcceleratorEditViewElement extends AcceleratorEditViewElementBase{static get is(){return"accelerator-edit-view"}static get template(){return getTemplate()}static get properties(){return{acceleratorInfo:{type:Object,value:standardAcceleratorInfoState},isEditView:{type:Boolean,computed:"showEditView(viewState)",reflectToAttribute:true},viewState:{type:Number,value:ViewState.VIEW,notify:true},statusMessage:{type:String,value:"",observer:AcceleratorEditViewElement.prototype.onStatusMessageChanged},hasError:{type:Boolean,value:false,reflectToAttribute:true},hasWarning:{type:Boolean,value:false,reflectToAttribute:true},recordedError:{type:Boolean,value:false},action:{type:Number,value:0},source:{type:Number,value:0}}}constructor(){super();this.cancelButtonClicked=false;this.shortcutProvider=getShortcutProvider();this.lookupManager=AcceleratorLookupManager.getInstance()}connectedCallback(){super.connectedCallback();this.addEventListener("blur",this.onBlur)}disconnectedCallback(){super.disconnectedCallback();this.removeEventListener("blur",this.onBlur)}async onStatusMessageChanged(){if(this.statusMessage===""){if(this.acceleratorInfo.state===AcceleratorState.kDisabledByUser&&this.viewState!==ViewState.EDIT){this.hasError=true;const configResult=await this.shortcutProvider.getConflictAccelerator(this.source,this.action,getAccelerator(this.acceleratorInfo));if(configResult.result.result===AcceleratorConfigResult.kConflict){this.statusMessage=this.i18n("restoreDefaultConflictMessage",configResult.result.shortcutName)}return}else{this.statusMessage=this.i18n("editViewStatusMessage")}}this.hasWarning=this.statusMessage===this.i18n("warningSearchNotIncluded",this.getMetaKeyDisplay())}onEditButtonClicked(){this.viewState=ViewState.EDIT;this.statusMessage="";this.hasError=false;getShortcutProvider().recordUserAction(UserAction.kStartReplaceAccelerator)}async onDeleteButtonClicked(){const accelerator=getAccelerator(this.acceleratorInfo);if(this.acceleratorInfo.state===AcceleratorState.kDisabledByUser){this.dispatchEvent(new CustomEvent("default-conflict-resolved",{bubbles:true,composed:true,detail:{stringifiedAccelerator:JSON.stringify(accelerator)}}));this.dispatchEvent(new CustomEvent("request-update-accelerator",{bubbles:true,composed:true,detail:{source:this.source,action:this.action}}));return}const originalAccelerator=this.acceleratorInfo.layoutProperties.standardAccelerator?.originalAccelerator;const configResult=await this.shortcutProvider.removeAccelerator(this.source,this.action,originalAccelerator||accelerator);if(configResult.result.result===AcceleratorConfigResult.kSuccess){this.dispatchEvent(new CustomEvent("request-update-accelerator",{bubbles:true,composed:true,detail:{source:this.source,action:this.action}}));this.dispatchEvent(new CustomEvent("edit-action-completed",{bubbles:true,composed:true,detail:{editAction:EditAction.REMOVE}}));getShortcutProvider().recordUserAction(UserAction.kRemoveAccelerator)}}onCancelButtonClicked(){this.shortcutProvider.recordAddOrEditSubactions(this.viewState===ViewState.ADD,this.recordedError?Subactions.kErrorCancel:Subactions.kNoErrorCancel);this.cancelButtonClicked=true;this.endCapture()}onBlur(){if(this.cancelButtonClicked){this.cancelButtonClicked=false;return}this.endCapture()}showEditView(){return this.viewState!==ViewState.VIEW}showStatusMessage(){return this.showEditView()||this.acceleratorInfo.state===AcceleratorState.kDisabledByUser}endCapture(){const viewElement=strictQuery("accelerator-view",this.shadowRoot,AcceleratorViewElement);viewElement.endCapture(false)}getMetaKeyDisplay(){const metaKey=this.lookupManager.getMetaKeyToDisplay();switch(metaKey){case MetaKey.kLauncherRefresh:return this.i18n("iconLabelOpenLauncher");case MetaKey.kSearch:return this.i18n("iconLabelOpenSearch");case MetaKey.kLauncher:default:return this.i18n("iconLabelOpenLauncher")}}getStatusMessageForTesting(){return this.statusMessage}getEditAriaLabel(){return this.i18n("editButtonForAction",getAriaLabelForStandardAcceleratorInfo(this.acceleratorInfo))}getDeleteAriaLabel(){return this.i18n("deleteButtonForAction",getAriaLabelForStandardAcceleratorInfo(this.acceleratorInfo))}getLearnMoreUrl(){return this.i18n("shortcutCustomizationLearnMoreUrl")}}customElements.define(AcceleratorEditViewElement.is,AcceleratorEditViewElement);