// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"chrome://resources/js/assert.js";import{AcceleratorCategory,AcceleratorSource,LayoutStyle,MetaKey}from"./shortcut_types.js";import{getAcceleratorId,getSourceAndActionFromAcceleratorId,isStandardAcceleratorInfo,isTextAcceleratorInfo}from"./shortcut_utils.js";function createSanitizedAccelInfo(info){assert(isStandardAcceleratorInfo(info));const{acceleratorLocked:acceleratorLocked,locked:locked,state:state,type:type,layoutProperties:layoutProperties}=info;const sanitizedAccelerator={keyCode:layoutProperties.standardAccelerator.accelerator.keyCode,modifiers:layoutProperties.standardAccelerator.accelerator.modifiers,keyState:layoutProperties.standardAccelerator.accelerator.keyState};const originalAccelerator=layoutProperties.standardAccelerator?.originalAccelerator;let sanitizedOriginalAccelerator=undefined;if(originalAccelerator){sanitizedOriginalAccelerator={keyCode:originalAccelerator.keyCode,modifiers:originalAccelerator.modifiers,keyState:layoutProperties.standardAccelerator.accelerator.keyState}}return{acceleratorLocked:acceleratorLocked,locked:locked,state:state,type:type,layoutProperties:{standardAccelerator:{accelerator:sanitizedAccelerator,keyDisplay:layoutProperties.standardAccelerator.keyDisplay,originalAccelerator:sanitizedOriginalAccelerator}}}}export class AcceleratorLookupManager{constructor(){this.layoutInfoProvider=new LayoutInfoProvider;this.standardAcceleratorLookup=new Map;this.textAcceleratorLookup=new Map;this.reverseAcceleratorLookup=new Map;this.metaKey=MetaKey.kSearch;this.searchResultRowFocused=false}getKeyForLookup(accelerator){return JSON.stringify({keyCode:accelerator.keyCode,modifiers:accelerator.modifiers})}getStandardAcceleratorInfos(source,action){const uuid=getAcceleratorId(source,action);const acceleratorInfos=this.standardAcceleratorLookup.get(uuid);assert(acceleratorInfos);return acceleratorInfos}getTextAcceleratorInfos(source,action){const uuid=getAcceleratorId(source,action);const acceleratorInfos=this.textAcceleratorLookup.get(uuid);assert(acceleratorInfos);return acceleratorInfos}isStandardAccelerator(style){return style===LayoutStyle.kDefault}isStandardAcceleratorById(id){return this.standardAcceleratorLookup.has(id)}getAcceleratorLayout(category,subCategory){return this.layoutInfoProvider.getAcceleratorLayout(category,subCategory)}getSubcategories(category){return this.layoutInfoProvider.getSubcategories(category)}getAcceleratorName(source,action){return this.layoutInfoProvider.getAcceleratorName(source,action)}getAcceleratorSubcategory(source,action){return this.layoutInfoProvider.getAcceleratorSubcategory(source,action)}initializeLookupIdForStandardAccelerator(source,actionId){const id=getAcceleratorId(source,actionId);if(!this.standardAcceleratorLookup.has(id)){this.standardAcceleratorLookup.set(id,[])}}initializeLookupIdForTextAccelerator(source,actionId){const id=getAcceleratorId(source,actionId);if(!this.textAcceleratorLookup.has(id)){this.textAcceleratorLookup.set(id,[])}}setAcceleratorLookup(acceleratorConfig){this.reverseAcceleratorLookup.clear();this.standardAcceleratorLookup.clear();this.textAcceleratorLookup.clear();for(const[source,accelInfoMap]of Object.entries(acceleratorConfig)){if(!accelInfoMap){continue}for(const[actionId,accelInfos]of Object.entries(accelInfoMap)){accelInfos.forEach((info=>{if(isTextAcceleratorInfo(info)){this.initializeLookupIdForTextAccelerator(source,actionId);this.getTextAcceleratorInfos(source,actionId).push({...info})}else{assert(isStandardAcceleratorInfo(info));this.initializeLookupIdForStandardAccelerator(source,actionId);const sanitizedAccelInfo=createSanitizedAccelInfo(info);this.reverseAcceleratorLookup.set(this.getKeyForLookup(sanitizedAccelInfo.layoutProperties.standardAccelerator.accelerator),getAcceleratorId(source,actionId));this.getStandardAcceleratorInfos(source,actionId).push({...sanitizedAccelInfo})}}))}}}setAcceleratorLayoutLookup(layoutInfoList){this.layoutInfoProvider.initializeLayoutInfo(layoutInfoList)}setMetaKeyToDisplay(metaKey){this.metaKey=metaKey}getMetaKeyToDisplay(){return this.metaKey}setSearchResultRowFocused(searchResultRowFocused){this.searchResultRowFocused=searchResultRowFocused}getSearchResultRowFocused(){return this.searchResultRowFocused}isSubcategoryLocked(subcategory){const acceleratorIds=this.layoutInfoProvider.getAcceleratorIdsBySubcategory(subcategory);for(const acceleratorId of acceleratorIds){if(!this.isStandardAcceleratorById(acceleratorId)){continue}const{source:source,action:action}=getSourceAndActionFromAcceleratorId(acceleratorId);const acceleratorInfos=this.getStandardAcceleratorInfos(source,action);for(const acceleratorInfo of acceleratorInfos){if(!acceleratorInfo.locked&&source===AcceleratorSource.kAsh){return false}}}return true}reset(){this.standardAcceleratorLookup.clear();this.textAcceleratorLookup.clear();this.layoutInfoProvider.resetLookupMaps();this.reverseAcceleratorLookup.clear()}static getInstance(){return managerInstance||(managerInstance=new AcceleratorLookupManager)}static setInstance(obj){managerInstance=obj}}let managerInstance=null;function createSanitizedLayoutInfo(entry){return{...entry,description:entry.description}}class LayoutInfoProvider{constructor(){this.acceleratorLayoutLookup=new Map;this.acceleratorNameLookup=new Map;this.acceleratorSubcategoryLookup=new Map;this.acceleratorIdsBySubcategoryLookup=new Map}getAcceleratorLayout(category,subCategory){const categoryMap=this.acceleratorLayoutLookup.get(category);assert(categoryMap);const subCategoryMap=categoryMap.get(subCategory);assert(subCategoryMap);return subCategoryMap}getSubcategories(category){return this.acceleratorLayoutLookup.get(category)}getAcceleratorName(source,action){const uuid=getAcceleratorId(source,action);const acceleratorName=this.acceleratorNameLookup.get(uuid);assert(acceleratorName);return acceleratorName}getAcceleratorSubcategory(source,action){const uuid=getAcceleratorId(source,action);const acceleratorSubcategory=this.acceleratorSubcategoryLookup.get(uuid);assert(acceleratorSubcategory!==undefined);return acceleratorSubcategory}getAcceleratorIdsBySubcategory(subcategory){const acceleratorIds=this.acceleratorIdsBySubcategoryLookup.get(subcategory);assert(acceleratorIds);return acceleratorIds}initializeLayoutInfo(layoutInfoList){this.initializeCategoryMaps(layoutInfoList);for(const entry of layoutInfoList){assert(entry.category!==AcceleratorCategory.kDebug&&entry.category!==AcceleratorCategory.kDeveloper);const layoutInfo=createSanitizedLayoutInfo(entry);this.getAcceleratorLayout(entry.category,entry.subCategory).push(layoutInfo);const acceleratorId=getAcceleratorId(entry.source,entry.action);this.addEntryToAcceleratorNameLookup(acceleratorId,layoutInfo.description);this.addEntryToAcceleratorSubcategoryLookup(acceleratorId,entry.subCategory);this.addEntryToAcceleratorsBySubcategoryLookup(acceleratorId,entry.subCategory)}}initializeCategoryMaps(layoutInfoList){for(const entry of layoutInfoList){if(!this.acceleratorLayoutLookup.has(entry.category)){this.acceleratorLayoutLookup.set(entry.category,new Map)}const subcatMap=this.acceleratorLayoutLookup.get(entry.category);if(!subcatMap.has(entry.subCategory)){subcatMap.set(entry.subCategory,[])}}}addEntryToAcceleratorNameLookup(uuid,description){this.acceleratorNameLookup.set(uuid,description)}addEntryToAcceleratorSubcategoryLookup(uuid,subcategory){this.acceleratorSubcategoryLookup.set(uuid,subcategory)}addEntryToAcceleratorsBySubcategoryLookup(uuid,subcategory){const acceleratorIds=this.acceleratorIdsBySubcategoryLookup.get(subcategory)||[];acceleratorIds.push(uuid);this.acceleratorIdsBySubcategoryLookup.set(subcategory,acceleratorIds)}resetLookupMaps(){this.acceleratorLayoutLookup.clear();this.acceleratorNameLookup.clear();this.acceleratorSubcategoryLookup.clear();this.acceleratorIdsBySubcategoryLookup.clear()}}