// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./accelerator_row.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{assert}from"chrome://resources/js/assert.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{AcceleratorLookupManager}from"./accelerator_lookup_manager.js";import{getTemplate}from"./accelerator_subsection.html.js";import{AcceleratorState,AcceleratorType}from"./shortcut_types.js";import{compareAcceleratorInfos,getSubcategoryNameStringId,isCustomizationAllowed}from"./shortcut_utils.js";const AcceleratorSubsectionElementBase=I18nMixin(PolymerElement);export class AcceleratorSubsectionElement extends AcceleratorSubsectionElementBase{constructor(){super(...arguments);this.lookupManager=AcceleratorLookupManager.getInstance()}static get is(){return"accelerator-subsection"}static get properties(){return{title:{type:String,value:""},category:{type:Number,value:""},subcategory:{type:Number,value:null,observer:AcceleratorSubsectionElement.prototype.onCategoryUpdated},accelRowDataArray:{type:Array,value:()=>[]}}}updateSubsection(){this.onCategoryUpdated()}onCategoryUpdated(){if(this.subcategory===null){return}const layoutInfos=this.lookupManager.getAcceleratorLayout(this.category,this.subcategory);this.title=this.i18n(getSubcategoryNameStringId(this.subcategory));const tempAccelRowData=[];layoutInfos.forEach((layoutInfo=>{if(this.lookupManager.isStandardAccelerator(layoutInfo.style)){const acceleratorInfos=this.lookupManager.getStandardAcceleratorInfos(layoutInfo.source,layoutInfo.action).filter((accel=>!(accel.type===AcceleratorType.kDefault&&(accel.state===AcceleratorState.kDisabledByUser||accel.state===AcceleratorState.kDisabledByUnavailableKeys))));if(!isCustomizationAllowed()){if(acceleratorInfos.length===0){return}}const accelRowData={layoutInfo:layoutInfo,acceleratorInfos:acceleratorInfos};tempAccelRowData.push(accelRowData)}else{tempAccelRowData.push({layoutInfo:layoutInfo,acceleratorInfos:this.lookupManager.getTextAcceleratorInfos(layoutInfo.source,layoutInfo.action)})}}));this.accelRowDataArray=tempAccelRowData}getSortedAccelerators(accelerators){return accelerators.sort(compareAcceleratorInfos)}static get template(){return getTemplate()}shouldShowLockIcon(){if(!isCustomizationAllowed()){return false}return this.lookupManager.isSubcategoryLocked(this.subcategory)}accelDescriptionToId(description){assert(description.trim()!=="");const normalizedDescription=description.toLowerCase().replace(/[^a-z0-9 /]/g,"").replace(/\//g,"-");const tokens=normalizedDescription.split(" ");const id=tokens.join("-");return id}}customElements.define(AcceleratorSubsectionElement.is,AcceleratorSubsectionElement);