import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><style include="shortcut-customization-shared">.flex-row{display:flex;flex-direction:row;justify-content:space-between}#accelerator-keys{display:flex;flex-direction:row}#container:focus{outline:none}#acceleratorSeparator{align-items:center;display:flex;padding-inline-end:8px}iron-icon[icon='shortcut-customization:lock']{--iron-icon-height:16px;--iron-icon-width:16px}.edit-button:focus-visible{opacity:1}
</style>

<div id="container" class="flex-row" tabindex="-1"
  aria-label="[[getAriaLabel(acceleratorInfo, viewState)]]">
  <template is="dom-if" if="[[!showEditView(viewState)]]">
    <div id="accelerator-keys">
      <template is="dom-repeat" items="[[modifiers]]">
        <shortcut-input-key key="[[item]]" key-state="modifier-selected"
            meta-key="[[metaKey]]">
        </shortcut-input-key>
      </template>
      <shortcut-input-key
          key="[[acceleratorInfo.layoutProperties.standardAccelerator.keyDisplay]]"
          key-state="alpha-numeric-selected"
          meta-key="[[metaKey]]">
      </shortcut-input-key>
    </div>
    <div class="lock-icon-container"
        hidden="[[!shouldShowLockIcon(acceleratorInfo.locked, sourceIsLocked)]]"
        aria-label="[[i18n('lock')]]" role="img">
      <iron-icon icon="shortcut-customization:lock"></iron-icon>
    </div>
    <div class="edit-icon-container"
        hidden="[[!shouldShowEditIcon(acceleratorInfo.locked, sourceIsLocked)]]">
      <cr-icon-button class="edit-button" class="clickable-button" part="edit-icon"
          iron-icon="shortcut-customization:edit"
          aria-label="[[getEditButtonAriaLabel(description)]]"
          on-click="onEditIconClicked">
      </cr-icon-button>
    </div>
  </template>
  <template is="dom-if" if="[[showEditView(viewState)]]"
      on-dom-change="onShortcutInputDomChange" restamp>
    <shortcut-input id="shortcutInput"
        pending-prerewritten-key-event="{{pendingKeyEvent}}"
        meta-key="[[metaKey]]"
        shortcut-input-provider="[[getShortcutInputProvider()]]"
        should-ignore-key-release="[[hasError]]"
        update-on-key-press
        display-prerewritten-key-events
        has-function-key="[[hasFunctionKey]]"
        ignore-blur>
    </shortcut-input>
  </template>
</div><!--_html_template_end_-->`}