// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{FakeMethodResolver}from"chrome://resources/ash/common/fake_method_resolver.js";import{FakeObservables}from"chrome://resources/ash/common/fake_observables.js";import{assert}from"chrome://resources/js/assert.js";import{AcceleratorConfigResult,AcceleratorSource}from"./shortcut_types.js";const ON_ACCELERATORS_UPDATED_METHOD_NAME="AcceleratorsUpdatedObserver_OnAcceleratorsUpdated";const ON_POLICY_UPDATED_METHOD_NAME="PolicyUpdatedObserver_OnCustomizationPolicyUpdated";export class FakeShortcutProvider{constructor(){this.observables=new FakeObservables;this.acceleratorsUpdatedRemote=null;this.acceleratorsUpdatedPromise=null;this.policyUpdateRemote=null;this.policyUpdatedPromise=null;this.restoreDefaultCallCount=0;this.preventProcessingAcceleratorsCallCount=0;this.addAcceleratorCallCount=0;this.removeAcceleratorCallCount=0;this.lastRecordedIsAdd=false;this.methods=new FakeMethodResolver;this.methods.register("getAccelerators");this.methods.register("getAcceleratorLayoutInfos");this.methods.register("isMutable");this.methods.register("hasCustomAccelerators");this.methods.register("isCustomizationAllowedByPolicy");this.methods.register("getMetaKeyToDisplay");this.methods.register("addAccelerator");this.methods.register("replaceAccelerator");this.methods.register("removeAccelerator");this.methods.register("restoreDefault");this.methods.register("restoreAllDefaults");this.methods.register("addObserver");this.methods.register("addPolicyObserver");this.methods.register("preventProcessingAccelerators");this.methods.register("getConflictAccelerator");this.methods.register("getDefaultAcceleratorsForId");this.methods.register("recordUserAction");this.methods.register("recordMainCategoryNavigation");this.methods.register("recordEditDialogCompetedActions");this.methods.register("recordAddOrEditSubactions");this.registerObservables()}registerObservables(){this.observables.register(ON_ACCELERATORS_UPDATED_METHOD_NAME);this.observables.register(ON_POLICY_UPDATED_METHOD_NAME)}reset(){this.restoreDefaultCallCount=0;this.preventProcessingAcceleratorsCallCount=0;this.addAcceleratorCallCount=0;this.removeAcceleratorCallCount=0;this.observables=new FakeObservables;this.registerObservables()}triggerOnAcceleratorUpdated(){this.observables.trigger(ON_ACCELERATORS_UPDATED_METHOD_NAME)}getAcceleratorLayoutInfos(){return this.methods.resolveMethod("getAcceleratorLayoutInfos")}getAccelerators(){return this.methods.resolveMethod("getAccelerators")}hasCustomAccelerators(){return this.methods.resolveMethod("hasCustomAccelerators")}isMutable(source){this.methods.setResult("isMutable",{isMutable:source!==AcceleratorSource.kBrowser});return this.methods.resolveMethod("isMutable")}isCustomizationAllowedByPolicy(){return this.methods.resolveMethod("isCustomizationAllowedByPolicy")}getMetaKeyToDisplay(){return this.methods.resolveMethod("getMetaKeyToDisplay")}addObserver(observer){this.acceleratorsUpdatedPromise=this.observe(ON_ACCELERATORS_UPDATED_METHOD_NAME,(config=>{observer.onAcceleratorsUpdated(config)}))}addPolicyObserver(observer){this.policyUpdatedPromise=this.observe(ON_POLICY_UPDATED_METHOD_NAME,(()=>{observer.onCustomizationPolicyUpdated()}))}getAcceleratorsUpdatedPromiseForTesting(){assert(this.acceleratorsUpdatedPromise);return this.acceleratorsUpdatedPromise}getPolicyUpdatedPromiseForTesting(){assert(this.policyUpdatedPromise);return this.policyUpdatedPromise}setFakeAcceleratorsUpdated(config){this.observables.setObservableData(ON_ACCELERATORS_UPDATED_METHOD_NAME,config)}setFakePolicyUpdated(){this.observables.setObservableData(ON_POLICY_UPDATED_METHOD_NAME,[true])}addAccelerator(_source,_actionId,_accelerator){++this.addAcceleratorCallCount;return this.methods.resolveMethod("addAccelerator")}replaceAccelerator(_source,_actionId,_old_accelerator,_new_accelerator){return this.methods.resolveMethod("replaceAccelerator")}removeAccelerator(){++this.removeAcceleratorCallCount;return this.methods.resolveMethod("removeAccelerator")}restoreDefault(_source,_actionId){++this.restoreDefaultCallCount;return this.methods.resolveMethod("restoreDefault")}restoreAllDefaults(){const result={result:AcceleratorConfigResult.kSuccess,shortcutName:null};this.methods.setResult("restoreAllDefaults",{result:result});return this.methods.resolveMethod("restoreAllDefaults")}recordUserAction(userAction){this.lastRecordedUserAction=userAction}recordEditDialogCompletedActions(completed_actions){this.lastRecoredEditDialogActions=completed_actions}getLastEditDialogCompletedActions(){return this.lastRecoredEditDialogActions}getLatestRecordedAction(){return this.lastRecordedUserAction}recordMainCategoryNavigation(category){this.lastRecordedMainCategory=category}getLatestMainCategoryNavigated(){return this.lastRecordedMainCategory}recordAddOrEditSubactions(isAdd,subactions){this.lastRecordedIsAdd=isAdd;this.lastRecorededSubactions=subactions}getLastRecordedIsAdd(){return this.lastRecordedIsAdd}getLastRecordedSubactions(){return this.lastRecorededSubactions}preventProcessingAccelerators(_preventProcessingAccelerators){++this.preventProcessingAcceleratorsCallCount;return this.methods.resolveMethod("preventProcessingAccelerators")}getConflictAccelerator(_source,_actionId,_accelerator){return this.methods.resolveMethod("getConflictAccelerator")}getDefaultAcceleratorsForId(_actionId){return this.methods.resolveMethod("getDefaultAcceleratorsForId")}setFakeGetConflictAccelerator(result){this.methods.setResult("getConflictAccelerator",{result:result})}setFakeGetDefaultAcceleratorsForId(accelerators){this.methods.setResult("getDefaultAcceleratorsForId",{accelerators:accelerators})}setFakeAcceleratorConfig(config){this.methods.setResult("getAccelerators",{config:config})}setFakeAcceleratorLayoutInfos(layoutInfos){this.methods.setResult("getAcceleratorLayoutInfos",{layoutInfos:layoutInfos})}setHasCustomAccelerators(enabled){this.methods.setResult("hasCustomAccelerators",{hasCustomAccelerators:enabled})}getRestoreDefaultCallCount(){return this.restoreDefaultCallCount}getPreventProcessingAcceleratorsCallCount(){return this.preventProcessingAcceleratorsCallCount}getAddAcceleratorCallCount(){return this.addAcceleratorCallCount}getRemoveAcceleratorCallCount(){return this.removeAcceleratorCallCount}setFakeMetaKeyToDisplay(metaKey){this.methods.setResult("getMetaKeyToDisplay",{metaKey:metaKey})}setFakeAddAcceleratorResult(result){this.methods.setResult("addAccelerator",{result:result})}setFakeReplaceAcceleratorResult(result){this.methods.setResult("replaceAccelerator",{result:result})}setFakeRestoreDefaultResult(result){this.methods.setResult("restoreDefault",{result:result})}setFakeRemoveAcceleratorResult(result){this.methods.setResult("removeAccelerator",{result:result})}setFakeIsCustomizationAllowedByPolicy(isCustomizationAllowedByPolicy){this.methods.setResult("isCustomizationAllowedByPolicy",{isCustomizationAllowedByPolicy:isCustomizationAllowedByPolicy})}observe(methodName,callback){return new Promise((resolve=>{this.observables.observe(methodName,callback);resolve()}))}}