// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"chrome://resources/js/assert.js";import{SHORTCUTS_APP_URL}from"./shortcut_utils.js";let routerInstance=null;export class Router{static getInstance(){assert(routerInstance,"Router instance has not been set yet.");return routerInstance}static setInstance(instance){assert(routerInstance===null,"Router instance has already been set.");routerInstance=instance}static resetInstanceForTesting(newInstance){routerInstance=newInstance}constructor(){this.routeObservers=new Set}addObserver(observer){assert(!this.routeObservers.has(observer));this.routeObservers.add(observer)}removeObserver(observer){assert(this.routeObservers.delete(observer))}navigateTo(url){window.history.pushState({},"",url);this.routeObservers.forEach((observer=>{observer.onRouteChanged(url)}))}resetRoute(){window.history.pushState({},"",SHORTCUTS_APP_URL)}}Router.setInstance(new Router);