// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr_elements/cros_color_overrides.css.js";import"chrome://resources/ash/common/cr_elements/cr_toolbar/cr_toolbar_search_field.js";import"./search_result_row.js";import"chrome://resources/polymer/v3_0/iron-dropdown/iron-dropdown.js";import"chrome://resources/polymer/v3_0/iron-list/iron-list.js";import{getInstance as getAnnouncerInstance}from"chrome://resources/ash/common/cr_elements/cr_a11y_announcer/cr_a11y_announcer.js";import{CrToolbarSearchFieldElement}from"chrome://resources/ash/common/cr_elements/cr_toolbar/cr_toolbar_search_field.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{strictQuery}from"chrome://resources/ash/common/typescript_utils/strict_query.js";import{assert}from"chrome://resources/js/assert.js";import{afterNextRender,PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{SearchResultsAvailabilityObserverReceiver}from"../../mojom-webui/search.mojom-webui.js";import{AcceleratorState}from"../shortcut_types.js";import{isCustomizationAllowed}from"../shortcut_utils.js";import{getTemplate}from"./search_box.html.js";import{SearchResultRowElement}from"./search_result_row.js";import{getShortcutSearchHandler}from"./shortcut_search_handler.js";const MAX_NUM_RESULTS=5;const MAX_QUERY_LENGTH_CHARACTERS=200;const SearchBoxElementBase=I18nMixin(PolymerElement);export class SearchBoxElement extends SearchBoxElementBase{static get is(){return"search-box"}static get template(){return getTemplate()}static get properties(){return{searchResults:{type:Array,value:[],observer:SearchBoxElement.prototype.onSearchResultsChanged},shouldShowDropdown:{type:Boolean,value:false,reflectToAttribute:true},searchResultsExist:{type:Boolean,value:false,computed:"computeSearchResultsExist(searchResults)"},hasSearchQuery:{type:Boolean,value:false,reflectToAttribute:true},selectedItem:{type:Object},lastFocused:Object,listBlurred:Boolean,spinnerActive:Boolean}}constructor(){super();this.shortcutSearchHandler=getShortcutSearchHandler();const receiver=new SearchResultsAvailabilityObserverReceiver(this);this.shortcutSearchHandler.addSearchResultsAvailabilityObserver(receiver.$.bindNewPipeAndPassRemote())}onSearchResultsAvailabilityChanged(){this.onSearchChanged()}ready(){super.ready();this.addEventListener("blur",this.onBlur);this.addEventListener("keydown",this.onKeyDown);this.addEventListener("search-changed",this.onSearchChanged)}connectedCallback(){super.connectedCallback();const searchFieldElement=strictQuery("#search",this.shadowRoot,CrToolbarSearchFieldElement);searchFieldElement.addEventListener("transitionend",this.onSearchFieldTransitionEnd.bind(this));this.searchInputElement=searchFieldElement.getSearchInput();afterNextRender(this,(()=>{this.searchInputElement.focus()}));this.searchInputElement.addEventListener("focus",this.onSearchInputFocused.bind(this));this.searchInputElement.addEventListener("mousedown",this.onSearchInputMousedown.bind(this));this.searchInputElement.maxLength=MAX_QUERY_LENGTH_CHARACTERS;this.resizeObserver=new ResizeObserver((()=>{const ironListElement=this.shadowRoot?.querySelector("iron-list");if(ironListElement){ironListElement.notifyResize()}}));this.resizeObserver.observe(strictQuery("iron-dropdown",this.shadowRoot,HTMLElement))}disconnectedCallback(){super.disconnectedCallback();this.resizeObserver.disconnect()}onBlur(event){event.stopPropagation();this.shouldShowDropdown=false}computeSearchResultsExist(){return this.searchResults.length!==0}getListLength(){return this.searchResults.length}getCurrentQuery(){return this.searchInputElement.value}onSearchChanged(){this.hasSearchQuery=!!this.getCurrentQuery();if(!this.hasSearchQuery){this.spinnerActive=false}this.fetchSearchResults(this.getCurrentQuery())}getRowTabIndex(item){return this.isItemSelected(item)&&this.shouldShowDropdown?0:-1}onSearchIconClicked(){this.searchInputElement.select();if(this.getCurrentQuery()){this.shouldShowDropdown=true}}onSearchInputFocused(){if(this.searchResultsExist){this.shouldShowDropdown=true;return}this.fetchSearchResults(this.getCurrentQuery())}onSearchInputMousedown(){if(!this.shouldShowDropdown){afterNextRender(this,(()=>this.searchInputElement.select()))}}onSearchFieldTransitionEnd(){const ironDropdown=strictQuery("iron-dropdown",this.shadowRoot,HTMLElement);ironDropdown.notifyResize()}onKeyDown(e){const isSearchFocused=strictQuery("#search",this.shadowRoot,CrToolbarSearchFieldElement).isSearchFocused();if(!this.searchResultsExist||!(isSearchFocused||this.lastFocused)){return}if(e.key==="Enter"&&this.hasSelectedSearchResultRow()){this.getSelectedSearchResultRow().onSearchResultSelected();return}if(e.key==="ArrowUp"||e.key==="ArrowDown"){e.preventDefault();this.selectRowViaKeys(e.key);return}}onSearchResultsChanged(){if(this.searchResultsExist){this.selectedItem=this.searchResults[0]}this.shouldShowDropdown=strictQuery("#search",this.shadowRoot,CrToolbarSearchFieldElement).isSearchFocused()&&!!this.getCurrentQuery();if(this.shouldShowDropdown&&!this.searchResultsExist){getAnnouncerInstance().announce(this.i18n("searchNoResults"))}}onNavigatedToResultRowRoute(){strictQuery("#search",this.shadowRoot,CrToolbarSearchFieldElement).blur();this.shouldShowDropdown=false}isItemSelected(item){return this.searchResults.indexOf(item)===this.searchResults.indexOf(this.selectedItem)}hasSelectedSearchResultRow(){return!!this.shadowRoot?.querySelector("search-result-row[selected]")}getSelectedSearchResultRow(){return strictQuery("search-result-row[selected]",strictQuery("#searchResultList",this.shadowRoot,HTMLElement),SearchResultRowElement)}selectRowViaKeys(key){assert(key==="ArrowDown"||key==="ArrowUp","Only arrow keys.");assert(!!this.selectedItem,"There should be a selected item already.");const selectedRowIndex=this.searchResults.indexOf(this.selectedItem);const numRows=this.searchResults.length;const delta=key==="ArrowUp"?-1:1;const indexOfNewRow=(numRows+selectedRowIndex+delta)%numRows;this.selectedItem=this.searchResults[indexOfNewRow];if(this.lastFocused){this.getSelectedSearchResultRow().focus()}}fetchSearchResults(query){if(query===""){this.searchResults=[];return}this.spinnerActive=true;const maxNumberOfSearchResults=MAX_NUM_RESULTS*3;this.shortcutSearchHandler.search(query,maxNumberOfSearchResults).then((response=>{this.onSearchResultsReceived(query,response.results);this.dispatchEvent(new CustomEvent("search-results-fetched",{bubbles:true,composed:true}))}))}onSearchResultsReceived(query,results){if(query!==this.getCurrentQuery()){return}this.spinnerActive=false;this.searchResults=this.filterSearchResults(results);this.searchResults=this.searchResults.slice(0,MAX_NUM_RESULTS);this.lastFocused=null}filterSearchResults(searchResults){const enabledSearchResults=searchResults.map((result=>({...result,acceleratorInfos:result.acceleratorInfos.filter((a=>a.state!==AcceleratorState.kDisabledByUnavailableKeys&&a.state!==AcceleratorState.kDisabledByUser))})));if(!isCustomizationAllowed()){return enabledSearchResults.filter((result=>result.acceleratorInfos.length>0))}return enabledSearchResults}}customElements.define(SearchBoxElement.is,SearchBoxElement);