// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{sanitizeInnerHtml}from"chrome://resources/js/parse_html_subset.js";export function getBoldedDescription(description,query){if(description.match(/\s/)||description.toLocaleLowerCase()!==description.toLocaleUpperCase()){return getTokenizeMatchedBoldTagged(description,query)}return getMatchingIndividualCharsBolded(description,query)}function getTokenizeMatchedBoldTagged(description,query){const normalizedQuery=normalizeString(query);const queryTokens=generateQueryTokens(description,normalizedQuery);const innerHtmlTokensWithBoldTags=description.split(/\s/).map((innerHtmlToken=>getModifiedInnerHtmlToken(innerHtmlToken,normalizedQuery,queryTokens)));const blankspaces=description.match(/\s/g);if(!blankspaces){return sanitizeInnerHtml(innerHtmlTokensWithBoldTags.join(""))}return sanitizeInnerHtml(innerHtmlTokensWithBoldTags.map(((token,idx)=>idx!==blankspaces.length?token+blankspaces[idx]:token)).join(""))}function getMatchingIndividualCharsBolded(description,query){return sanitizeInnerHtml(boldSubStrings(description,query.split("")))}function getModifiedInnerHtmlToken(innerHtmlToken,normalizedQuery,queryTokens){const normalizedToken=normalizeString(innerHtmlToken);if(normalizedQuery.includes(normalizedToken)){return normalizedToken?innerHtmlToken.bold():innerHtmlToken}const queryTokenFilter=queryToken=>!!queryToken&&normalizedToken.includes(queryToken);const queryTokenToSegment=queryToken=>{const regExpStr=queryToken.split("").join(`${HYPHENS_REGEX_STR}*`);const innerHtmlTokenNoAccents=removeAccents(innerHtmlToken);const matchesNoAccents=innerHtmlTokenNoAccents.match(new RegExp(regExpStr,"g"))||[];return matchesNoAccents.map((match=>innerHtmlToken.toLocaleLowerCase().substr(innerHtmlTokenNoAccents.indexOf(match),match.length)))};const matches=queryTokens.filter(queryTokenFilter).map(queryTokenToSegment).flat();if(!matches.length){return innerHtmlToken}const maxStrLen=matches.reduce(((a,b)=>a.length>b.length?a:b)).length;const bolded=matches.filter((sourceString=>sourceString.length===maxStrLen));return boldSubStrings(innerHtmlToken,bolded)}function generateQueryTokens(description,normalizedQuery){const normalizedResultText=normalizeString(description);const segmentToTokenMap=new Map;normalizedQuery.split(/\s/).forEach((querySegment=>{const queryTokens=longestCommonSubstrings(querySegment,normalizedResultText);if(segmentToTokenMap.has(querySegment)){const segmentTokens=segmentToTokenMap.get(querySegment).concat(queryTokens);segmentToTokenMap.set(querySegment,segmentTokens);return}segmentToTokenMap.set(querySegment,queryTokens)}));const getLongestTokensPerSegment=([querySegment,queryTokens])=>{if(!queryTokens.length){return[]}const maxLengthQueryToken=Math.max(...queryTokens.map((queryToken=>queryToken.length)));if(maxLengthQueryToken===1&&querySegment.length>1){return[]}return queryTokens.filter((queryToken=>queryToken.length===maxLengthQueryToken))};const inOrderTokenGroups=Array.from(segmentToTokenMap).map(getLongestTokensPerSegment);const inOrderTokens=[...new Set(inOrderTokenGroups.flat())];return mergeValidTokensToCompounded(description,inOrderTokens)}function mergeValidTokensToCompounded(description,inOrderQueryTokens){const longestCompoundWordTokens=[];const hyphenatedResultText=removeAccents(description).replace(HYPHENS_REGEX,DELOCALIZED_HYPHEN);let i=0;while(i<inOrderQueryTokens.length){let prefixToken=inOrderQueryTokens[i];i++;while(i<inOrderQueryTokens.length){const compoundToken=prefixToken+DELOCALIZED_HYPHEN+inOrderQueryTokens[i];if(!hyphenatedResultText.includes(compoundToken)){break}prefixToken=compoundToken;i++}longestCompoundWordTokens.push(prefixToken)}return longestCompoundWordTokens.map((token=>normalizeString(token)))}function boldSubStrings(sourceString,substringsToBold){if(!substringsToBold||!substringsToBold.length){return sourceString}const subStrRegex=new RegExp("()("+substringsToBold.join("|")+")()","ig");return sourceString.replace(subStrRegex,(match=>match.bold()))}const DELOCALIZED_HYPHEN="-";const HYPHENS=["-","~","֊","־","᠆","‐","‑","‒","–","—","―","⁓","⁻","₋","−","⸺","⸻","〜","〰","゠","﹘","﹣","－"];const HYPHENS_REGEX_STR=`[${HYPHENS.join("")}]`;const HYPHENS_REGEX=new RegExp(HYPHENS_REGEX_STR,"g");function removeAccents(sourceString){return sourceString.toLocaleLowerCase().normalize("NFD").replace(/[\u0300-\u036f]/g,"")}function normalizeString(sourceString){return removeAccents(sourceString).replace(HYPHENS_REGEX,"")}function longestCommonSubstrings(string1,string2){let maxLength=0;let string1StartingIndices=[];const dp=Array(string1.length+1).fill([]).map((()=>Array(string2.length+1).fill(0)));for(let i=string1.length-1;i>=0;i--){for(let j=string2.length-1;j>=0;j--){if(string1[i]!==string2[j]){continue}dp[i][j]=dp[i+1][j+1]+1;if(maxLength===dp[i][j]){string1StartingIndices.unshift(i)}if(maxLength<dp[i][j]){maxLength=dp[i][j];string1StartingIndices=[i]}}}return string1StartingIndices.map((idx=>string1.substr(idx,maxLength)))}