// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr_elements/cros_color_overrides.css.js";import"chrome://resources/ash/common/cr_elements/cr_shared_style.css.js";import"../text_accelerator.js";import"chrome://resources/ash/common/shortcut_input_ui/shortcut_input_key.js";import{getInstance as getAnnouncerInstance}from"chrome://resources/ash/common/cr_elements/cr_a11y_announcer/cr_a11y_announcer.js";import{FocusRowMixin}from"chrome://resources/ash/common/cr_elements/focus_row_mixin.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{assert}from"chrome://resources/js/assert.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{AcceleratorLookupManager}from"../accelerator_lookup_manager.js";import{Router}from"../router.js";import{LayoutStyle,MetaKey}from"../shortcut_types.js";import{getAriaLabelForStandardAccelerators,getAriaLabelForTextAccelerators,getModifiersForAcceleratorInfo,getTextAcceleratorParts,getURLForSearchResult,isStandardAcceleratorInfo,isTextAcceleratorInfo}from"../shortcut_utils.js";import{getBoldedDescription}from"./search_result_bolding.js";import{getTemplate}from"./search_result_row.html.js";const SearchResultRowElementBase=FocusRowMixin(I18nMixin(PolymerElement));export class SearchResultRowElement extends SearchResultRowElementBase{constructor(){super(...arguments);this.metaKey=MetaKey.kSearch;this.lookupManager=AcceleratorLookupManager.getInstance()}static get is(){return"search-result-row"}static get properties(){return{searchResult:{type:Object},searchQuery:{type:String},selected:{type:Boolean,reflectToAttribute:true,observer:"makeA11yAnnouncementIfSelectedAndUnfocused"},ariaLabel:{type:String,computed:"computeAriaLabel(searchResult)",reflectToAttribute:true},listLength:Number,metaKey:Object}}static get template(){return getTemplate()}connectedCallback(){super.connectedCallback();this.metaKey=this.lookupManager.getMetaKeyToDisplay()}isNoShortcutAssigned(){return this.searchResult.acceleratorInfos.length===0}isStandardLayout(){return!this.isNoShortcutAssigned()&&this.searchResult.acceleratorLayoutInfo.style===LayoutStyle.kDefault}isTextLayout(){return!this.isNoShortcutAssigned()&&!this.isStandardLayout()}getTextAcceleratorParts(){assert(isTextAcceleratorInfo(this.searchResult.acceleratorInfos[0]));return getTextAcceleratorParts(this.searchResult.acceleratorInfos)}getStandardAcceleratorInfos(){assert(this.isStandardLayout());return this.searchResult.acceleratorInfos.map((acceleratorInfo=>{assert(isStandardAcceleratorInfo(acceleratorInfo));return{...acceleratorInfo,layoutProperties:{...acceleratorInfo.layoutProperties,standardAccelerator:{...acceleratorInfo.layoutProperties.standardAccelerator,keyDisplay:acceleratorInfo.layoutProperties.standardAccelerator.keyDisplay}}}}))}getStandardAcceleratorModifiers(acceleratorInfo){return getModifiersForAcceleratorInfo(acceleratorInfo)}getStandardAcceleratorKey(acceleratorInfo){return acceleratorInfo.layoutProperties.standardAccelerator.keyDisplay}shouldShowTextDivider(indexOfAcceleratorInfo){return indexOfAcceleratorInfo!==this.searchResult.acceleratorInfos.length-1}onKeyPress(e){if(e.key==="Enter"){e.stopPropagation();this.onSearchResultSelected()}}onSearchResultSelected(){Router.getInstance().navigateTo(getURLForSearchResult(this.searchResult));this.dispatchEvent(new CustomEvent("navigated-to-result-route",{bubbles:true,composed:true}))}getSearchResultDescriptionInnerHtml(){return getBoldedDescription(this.searchResult.acceleratorLayoutInfo.description,this.searchQuery)}computeAriaLabel(){const description=this.searchResult.acceleratorLayoutInfo.description;let searchResultText;if(this.isNoShortcutAssigned()){searchResultText=`${description}, ${this.i18n("noShortcutAssigned")}`}else if(this.isStandardLayout()){searchResultText=`${description}, ${getAriaLabelForStandardAccelerators(this.getStandardAcceleratorInfos(),this.i18n("acceleratorTextDivider"))}`}else{searchResultText=`${description}, ${getAriaLabelForTextAccelerators(this.searchResult.acceleratorInfos)}`}return this.i18n("searchResultSelectedAriaLabel",this.focusRowIndex+1,this.listLength,searchResultText)}makeA11yAnnouncementIfSelectedAndUnfocused(){if(!this.selected||this.lastFocused){return}getAnnouncerInstance().announce(this.ariaLabel)}}customElements.define(SearchResultRowElement.is,SearchResultRowElement);