import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><style include="shortcut-customization-shared">:host{--cr-toolbar-field-width:620px;font-family:var(--shortcuts-font-family-default);font-size:var(--shortcuts-font-size-default);font-weight:var(--shortcuts-font-weight-regular);height:100%}:host-context(body.jelly-enabled) navigation-view-panel{--navigation-view-panel-bg-color:var(--cros-sys-app_base_shaded)}@media (max-width:960px){:host{--cr-toolbar-field-width:480px}}@media (max-width:768px){:host{--cr-toolbar-field-width:80vw}}#navigationPanel::part(title){color:var(--cros-text-color-secondary);padding-inline-start:8px}#navigationPanel::part(navigation-item){padding-inline-start:28px}#navigationPanel::part(nav-spacer){height:20px}#navigationPanel::part(side-nav){min-width:216px}#navigationPanel::part(top-nav){height:72px}#navigationPanel::part(nav-body){overflow:hidden}#bottomNavContentDrawer,#bottomNavContentPanel{margin-inline-start:12px}#searchBoxWrapper{display:flex;font-size:var(--shortcuts-font-size-default);justify-content:center;padding-inline:var(--container-padding-nav)}#policyIndicator{align-items:center;display:flex;height:32px;justify-content:center;padding-bottom:16px;width:100%}#policyIcon{padding-inline-end:8px}#restoreDialog::part(dialog){width:320px}#restoreTitle{--cr-dialog-title-slot-padding-top:32px;color:var(--cros-text-color-secondary);display:flex;font:var(--cros-body-1-font);padding-inline:32px}#buttonContainer{margin-block-end:28px;margin-inline-end:32px;padding:0}#cancelButton,#confirmButton{border-radius:999px}#cancelButton{margin-inline-end:8px}</style>
<navigation-view-panel id="navigationPanel" title="[[i18n('appTitle')]]"
    show-tool-bar has-search>
  <div slot="toolbar-main" id="searchBoxWrapper">
    <search-box></search-box>
  </div>
  <div slot="top-navigation-body" id="topNavigationBody">
    <template is="dom-if" if="[[!isCustomizationAllowedByPolicy]]">
      <div id="policyIndicator">
        <cr-policy-indicator id="policyIcon" indicator-type="userPolicy">
        </cr-policy-indicator>
        <div>[[i18n('customizationDisabledByPolicyMessage')]]</div>
      </div>
    </template>
  </div>
  <div slot="bottom-nav-content-panel" id="bottomNavContentPanel">
    <shortcuts-bottom-nav-content
        keyboard-settings-link="[[keyboardSettingsLink]]"
        restore-all-button-hidden="[[restoreAllButtonHidden]]"
        on-restore-all-default="onRestoreAllDefaultClicked">
    </shortcuts-bottom-nav-content>
  </div>
  <div slot="bottom-nav-content-drawer" id="bottomNavContentDrawer">
    <shortcuts-bottom-nav-content
      keyboard-settings-link="[[keyboardSettingsLink]]"
      restore-all-button-hidden="[[restoreAllButtonHidden]]"
      on-restore-all-default="onRestoreAllDefaultClicked">
    </shortcuts-bottom-nav-content>
  </div>
</navigation-view-panel>

<template is="dom-if" if="[[showEditDialog]]" restamp>
  <accelerator-edit-dialog id="editDialog"
      description="[[dialogShortcutTitle]]"
      accelerator-infos="[[dialogAccelerators]]"
      action="[[dialogAction]]"
      source="[[dialogSource]]">
  </accelerator-edit-dialog>
</template>

<template is="dom-if" if="[[showRestoreAllDialog]]" restamp>
  <cr-dialog id="restoreDialog" show-on-attach
      on-close="closeRestoreAllDialog">
    <div id="restoreTitle" slot="title">
      [[i18n('confirmResetAllShortcutsTitle')]]
    </div>
    <div id="buttonContainer" slot="button-container">
      <cr-button id="cancelButton" on-click="onCancelRestoreButtonClicked">
        [[i18n('cancel')]]
      </cr-button>
      <cr-button id="confirmButton" class="action-button"
          on-click="onConfirmRestoreButtonClicked">
        [[i18n('confirmResetAllShortcutsButton')]]
      </cr-button>
    </div>
  </cr-dialog>
</template><!--_html_template_end_-->`}