// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./accelerator_edit_dialog.js";import"./bottom_nav_content.js";import"./shortcuts_page.js";import"/strings.m.js";import"./search/search_box.js";import"../css/shortcut_customization_shared.css.js";import"chrome://resources/ash/common/navigation_view_panel.js";import"chrome://resources/ash/common/page_toolbar.js";import"chrome://resources/polymer/v3_0/iron-icon/iron-icon.js";import"chrome://resources/ash/common/cr_elements/policy/cr_policy_indicator.js";import{CrDialogElement}from"chrome://resources/ash/common/cr_elements/cr_dialog/cr_dialog.js";import{CrToolbarSearchFieldElement}from"chrome://resources/ash/common/cr_elements/cr_toolbar/cr_toolbar_search_field.js";import{FindShortcutMixin}from"chrome://resources/ash/common/cr_elements/find_shortcut_mixin.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{loadTimeData}from"chrome://resources/ash/common/load_time_data.m.js";import{strictQuery}from"chrome://resources/ash/common/typescript_utils/strict_query.js";import{ColorChangeUpdater}from"chrome://resources/cr_components/color_change_listener/colors_css_updater.js";import{assert}from"chrome://resources/js/assert.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{AcceleratorsUpdatedObserverReceiver,PolicyUpdatedObserverReceiver,UserAction}from"../mojom-webui/shortcut_customization.mojom-webui.js";import{AcceleratorLookupManager}from"./accelerator_lookup_manager.js";import{getShortcutProvider}from"./mojo_interface_provider.js";import{Router}from"./router.js";import{SearchBoxElement}from"./search/search_box.js";import{getTemplate}from"./shortcut_customization_app.html.js";import{AcceleratorConfigResult}from"./shortcut_types.js";import{getAcceleratorId,getCategoryNameStringId,isCustomizationAllowed}from"./shortcut_utils.js";const keyboardSettingsLink="chrome://os-settings/per-device-keyboard";const ShortcutCustomizationAppElementBase=I18nMixin(FindShortcutMixin(PolymerElement));export class ShortcutCustomizationAppElement extends ShortcutCustomizationAppElementBase{constructor(){super(...arguments);this.keyboardSettingsLink=keyboardSettingsLink;this.acceleratorUpdateInProgress=false;this.shortcutProvider=getShortcutProvider();this.acceleratorlookupManager=AcceleratorLookupManager.getInstance()}static get is(){return"shortcut-customization-app"}static get properties(){return{dialogShortcutTitle:{type:String,value:""},dialogAccelerators:{type:Array,value:()=>[]},dialogAction:{type:Number,value:0},dialogSource:{type:Number,value:0},showEditDialog:{type:Boolean,value:false},showRestoreAllDialog:{type:Boolean,value:false},isCustomizationAllowedByPolicy:{type:Boolean,value:true},restoreAllButtonHidden:{type:Boolean,value:false}}}connectedCallback(){super.connectedCallback();if(loadTimeData.getBoolean("isJellyEnabledForShortcutCustomization")){document.querySelector("link[href*='cros_styles.css']")?.setAttribute("href","chrome://theme/colors.css?sets=legacy,sys");const typographyLink=document.createElement("link");typographyLink.href="chrome://theme/typography.css";typographyLink.rel="stylesheet";document.head.appendChild(typographyLink);document.body.classList.add("jelly-enabled");ColorChangeUpdater.forDocument().start()}this.policyUpdatedReceiver=new PolicyUpdatedObserverReceiver(this);this.shortcutProvider.addPolicyObserver(this.policyUpdatedReceiver.$.bindNewPipeAndPassRemote());this.shortcutProvider.isCustomizationAllowedByPolicy().then((({isCustomizationAllowedByPolicy:isCustomizationAllowedByPolicy})=>{this.isCustomizationAllowedByPolicy=isCustomizationAllowedByPolicy}));this.fetchAccelerators();this.updateHideRestoreAllButtonState();this.addEventListener("show-edit-dialog",this.showDialog);this.addEventListener("edit-dialog-closed",this.onDialogClosed);this.addEventListener("accelerator-update-in-progress",this.acceleratorUpdating);this.addEventListener("request-update-accelerator",this.onRequestUpdateAccelerators);this.addEventListener("scroll-to-top",this.onScollToTop);Router.getInstance().addObserver(this)}disconnectedCallback(){super.disconnectedCallback();this.policyUpdatedReceiver.$.close();this.acceleratorsUpdatedReceiver.$.close();this.removeEventListener("show-edit-dialog",this.showDialog);this.removeEventListener("edit-dialog-closed",this.onDialogClosed);this.removeEventListener("request-update-accelerator",this.onRequestUpdateAccelerators);this.removeEventListener("scroll-to-top",this.onScollToTop);Router.getInstance().removeObserver(this)}fetchAccelerators(){this.shortcutProvider.getAccelerators().then((({config:config})=>this.onAcceleratorConfigFetched(config)));this.shortcutProvider.getMetaKeyToDisplay().then((({metaKey:metaKey})=>{this.acceleratorlookupManager.setMetaKeyToDisplay(metaKey)}))}onAcceleratorConfigFetched(config){this.acceleratorlookupManager.setAcceleratorLookup(config);this.shortcutProvider.getAcceleratorLayoutInfos().then((({layoutInfos:layoutInfos})=>this.onLayoutInfosFetched(layoutInfos)))}onLayoutInfosFetched(layoutInfos){this.addNavigationSelectors(layoutInfos);this.acceleratorlookupManager.setAcceleratorLayoutLookup(layoutInfos);this.$.navigationPanel.notifyEvent("updateAccelerators");this.acceleratorsUpdatedReceiver=new AcceleratorsUpdatedObserverReceiver(this);this.shortcutProvider.addObserver(this.acceleratorsUpdatedReceiver.$.bindNewPipeAndPassRemote());this.onRouteChanged(new URL(window.location.href))}onAcceleratorsUpdated(config){this.acceleratorlookupManager.setAcceleratorLookup(config);this.updateHideRestoreAllButtonState();this.$.navigationPanel.notifyEvent("updateSubsections");if(!this.acceleratorUpdateInProgress&&this.showEditDialog){this.updateDialogAccelerators(this.dialogSource,this.dialogAction)}this.shortcutProvider.getMetaKeyToDisplay().then((({metaKey:metaKey})=>{this.acceleratorlookupManager.setMetaKeyToDisplay(metaKey)}))}onCustomizationPolicyUpdated(){window.location.reload()}addNavigationSelectors(layoutInfos){const uniqueCategoriesInOrder=new Set(layoutInfos.map((layoutInfo=>layoutInfo.category)));const pages=Array.from(uniqueCategoriesInOrder).map((category=>{const categoryNameStringId=getCategoryNameStringId(category);const categoryName=this.i18n(categoryNameStringId);return this.$.navigationPanel.createSelectorItem(categoryName,"shortcuts-page","",`category-${category}`,{category:category})}));this.$.navigationPanel.addSelectors(pages)}showDialog(e){this.dialogShortcutTitle=e.detail.description;this.dialogAccelerators=e.detail.accelerators;this.dialogAction=e.detail.action;this.dialogSource=e.detail.source;this.showEditDialog=true}onDialogClosed(){this.showEditDialog=false;this.dialogShortcutTitle="";this.dialogAccelerators=[]}onScollToTop(){strictQuery("#topNavigationBody",this.shadowRoot,HTMLDivElement).scrollIntoView()}acceleratorUpdating(){this.acceleratorUpdateInProgress=true}onRouteChanged(url){const action=url.searchParams.get("action");const category=url.searchParams.get("category");if(!action||!category){return}this.$.navigationPanel.selectPageById(`category-${category}`)}onRequestUpdateAccelerators(e){this.$.navigationPanel.notifyEvent("updateSubsections");if(this.showEditDialog){this.updateDialogAccelerators(e.detail.source,e.detail.action)}this.acceleratorUpdateInProgress=false}onRestoreAllDefaultClicked(){this.showRestoreAllDialog=true}onCancelRestoreButtonClicked(){strictQuery("#restoreDialog",this.shadowRoot,CrDialogElement).close()}onConfirmRestoreButtonClicked(){this.shortcutProvider.restoreAllDefaults().then((({result:result})=>{if(result.result===AcceleratorConfigResult.kSuccess){this.shortcutProvider.recordUserAction(UserAction.kResetAll);strictQuery("#restoreDialog",this.shadowRoot,CrDialogElement).close()}}))}closeRestoreAllDialog(){this.showRestoreAllDialog=false}updateHideRestoreAllButtonState(){if(!isCustomizationAllowed()){this.restoreAllButtonHidden=true;return}this.shortcutProvider.hasCustomAccelerators().then((result=>{this.restoreAllButtonHidden=!result.hasCustomAccelerators}))}updateDialogAccelerators(source,action){assert(this.acceleratorlookupManager.isStandardAcceleratorById(getAcceleratorId(source,action)));const updatedAccels=this.acceleratorlookupManager.getStandardAcceleratorInfos(source,action);this.shadowRoot.querySelector("#editDialog").updateDialogAccelerators(updatedAccels)}handleFindShortcut(modalContextOpen){if(modalContextOpen){return false}this.getSearchFieldElement().getSearchInput().focus();return true}searchInputHasFocus(){return this.getSearchFieldElement().isSearchFocused()}getSearchFieldElement(){const searchBox=strictQuery("search-box",this.shadowRoot,SearchBoxElement);const searchField=strictQuery("#search",searchBox.shadowRoot,CrToolbarSearchFieldElement);return searchField}setAcceleratorUpdateInProgressForTesting(acceleratorUpdateInProgress){this.acceleratorUpdateInProgress=acceleratorUpdateInProgress}static get template(){return getTemplate()}}customElements.define(ShortcutCustomizationAppElement.is,ShortcutCustomizationAppElement);