// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"/strings.m.js";import{loadTimeData}from"chrome://resources/ash/common/load_time_data.m.js";import{VKey as ash_mojom_VKey}from"chrome://resources/ash/common/shortcut_input_ui/accelerator_keys.mojom-webui.js";import{ModifierKeyCodes}from"chrome://resources/ash/common/shortcut_input_ui/shortcut_utils.js";import{assert,assertNotReached}from"chrome://resources/js/assert.js";import{AcceleratorCategory,AcceleratorConfigResult,AcceleratorKeyState,AcceleratorState,AcceleratorSubcategory,AcceleratorType,Modifier}from"./shortcut_types.js";const kF11=112;const kF24=135;const kMeta=91;const modifiers=[Modifier.SHIFT,Modifier.CONTROL,Modifier.ALT,Modifier.COMMAND,Modifier.FN_KEY];export const unidentifiedKeyCodeToKey={159:"MicrophoneMuteToggle",192:"`",218:"KeyboardBrightnessUp",232:"KeyboardBrightnessDown",237:"EmojiPicker",238:"EnableOrToggleDictation",239:"ViewAllApps"};export const keyToIconNameMap={Accessibility:"accessibility",ArrowDown:"arrow-down",ArrowLeft:"arrow-left",ArrowRight:"arrow-right",ArrowUp:"arrow-up",AudioVolumeDown:"volume-down",AudioVolumeMute:"volume-mute",AudioVolumeUp:"volume-up",BrightnessDown:"display-brightness-down",BrightnessUp:"display-brightness-up",BrowserBack:"back",BrowserForward:"forward",BrowserHome:"browser-home",BrowserRefresh:"refresh",BrowserSearch:"browser-search",CameraAccessToggle:"camera-access-toggle",ContextMenu:"menu",DoNotDisturb:"do-not-disturb",EmojiPicker:"emoji-picker",EnableOrToggleDictation:"dictation-toggle",KeyboardBacklightToggle:"keyboard-brightness-toggle",KeyboardBrightnessUp:"keyboard-brightness-up",KeyboardBrightnessDown:"keyboard-brightness-down",LaunchApplication1:"overview",LaunchApplication2:"calculator",LaunchAssistant:"assistant",LaunchMail:"launch-mail",MediaFastForward:"fast-forward",MediaPause:"pause",MediaPlay:"play",MediaPlayPause:"play-pause",MediaTrackNext:"next-track",MediaTrackPrevious:"last-track",MicrophoneMuteToggle:"microphone-mute",ModeChange:"globe",ViewAllApps:"view-all-apps",Power:"power",PrintScreen:"screenshot",PrivacyScreenToggle:"electronic-privacy-screen",Settings:"settings",Standby:"lock",ZoomToggle:"fullscreen"};export const isCustomizationAllowed=()=>loadTimeData.getBoolean("isCustomizationAllowed");export const isTextAcceleratorInfo=accelInfo=>!!accelInfo.layoutProperties.textAccelerator;export const isStandardAcceleratorInfo=accelInfo=>!!accelInfo.layoutProperties.standardAccelerator;export const createEmptyAccelInfoFromAccel=accel=>({layoutProperties:{standardAccelerator:{accelerator:accel,keyDisplay:""}},acceleratorLocked:false,locked:false,state:AcceleratorState.kEnabled,type:AcceleratorType.kUser});export const createEmptyAcceleratorInfo=()=>createEmptyAccelInfoFromAccel({modifiers:0,keyCode:0,keyState:AcceleratorKeyState.PRESSED});export const resetKeyEvent=()=>({vkey:ash_mojom_VKey.MIN_VALUE,domCode:0,domKey:0,modifiers:0,keyDisplay:""});export const getAcceleratorId=(source,actionId)=>`${source}-${actionId}`;const categoryPrefix="category";export const getCategoryNameStringId=category=>{switch(category){case AcceleratorCategory.kGeneral:return`${categoryPrefix}General`;case AcceleratorCategory.kDevice:return`${categoryPrefix}Device`;case AcceleratorCategory.kBrowser:return`${categoryPrefix}Browser`;case AcceleratorCategory.kText:return`${categoryPrefix}Text`;case AcceleratorCategory.kWindowsAndDesks:return`${categoryPrefix}WindowsAndDesks`;case AcceleratorCategory.kDebug:return`${categoryPrefix}Debug`;case AcceleratorCategory.kAccessibility:return`${categoryPrefix}Accessibility`;case AcceleratorCategory.kDebug:return`${categoryPrefix}Debug`;case AcceleratorCategory.kDeveloper:return`${categoryPrefix}Developer`;default:{assertNotReached()}}};const subcategoryPrefix="subcategory";export const getSubcategoryNameStringId=subcategory=>{switch(subcategory){case AcceleratorSubcategory.kGeneralControls:return`${subcategoryPrefix}GeneralControls`;case AcceleratorSubcategory.kApps:return`${subcategoryPrefix}Apps`;case AcceleratorSubcategory.kMedia:return`${subcategoryPrefix}Media`;case AcceleratorSubcategory.kInputs:return`${subcategoryPrefix}Inputs`;case AcceleratorSubcategory.kDisplay:return`${subcategoryPrefix}Display`;case AcceleratorSubcategory.kGeneral:return`${subcategoryPrefix}General`;case AcceleratorSubcategory.kBrowserNavigation:return`${subcategoryPrefix}BrowserNavigation`;case AcceleratorSubcategory.kPages:return`${subcategoryPrefix}Pages`;case AcceleratorSubcategory.kTabs:return`${subcategoryPrefix}Tabs`;case AcceleratorSubcategory.kBookmarks:return`${subcategoryPrefix}Bookmarks`;case AcceleratorSubcategory.kDeveloperTools:return`${subcategoryPrefix}DeveloperTools`;case AcceleratorSubcategory.kTextNavigation:return`${subcategoryPrefix}TextNavigation`;case AcceleratorSubcategory.kTextEditing:return`${subcategoryPrefix}TextEditing`;case AcceleratorSubcategory.kWindows:return`${subcategoryPrefix}Windows`;case AcceleratorSubcategory.kDesks:return`${subcategoryPrefix}Desks`;case AcceleratorSubcategory.kChromeVox:return`${subcategoryPrefix}ChromeVox`;case AcceleratorSubcategory.kMouseKeys:return`${subcategoryPrefix}MouseKeys`;case AcceleratorSubcategory.kVisibility:return`${subcategoryPrefix}Visibility`;case AcceleratorSubcategory.kAccessibilityNavigation:return`${subcategoryPrefix}AccessibilityNavigation`;default:{assertNotReached()}}};export const getAccelerator=acceleratorInfo=>acceleratorInfo.layoutProperties.standardAccelerator.accelerator;export const areAcceleratorsEqual=(first,second)=>first.keyCode===second.keyCode&&first.modifiers===second.modifiers&&first.keyState===second.keyState;export const canBypassErrorWithRetry=result=>result===AcceleratorConfigResult.kConflictCanOverride||result===AcceleratorConfigResult.kNonSearchAcceleratorWarning;export const getSortedModifiers=modifierStrings=>{const sortOrder=["meta","ctrl","alt","shift","fn"];if(modifierStrings.length<=1){return modifierStrings}return modifierStrings.sort(((a,b)=>sortOrder.indexOf(a)-sortOrder.indexOf(b)))};function getModifierCount(accelerator){let count=0;for(const modifier of modifiers){if(accelerator.modifiers&modifier){++count}}return count}function isSearchOnlyAccelerator(accelerator){return accelerator.keyCode===kMeta&&accelerator.modifiers===Modifier.NONE}export function compareAcceleratorInfos(first,second){if(!isStandardAcceleratorInfo(first)||!isStandardAcceleratorInfo(second)){return 0}if(isSearchOnlyAccelerator(first.layoutProperties.standardAccelerator.accelerator)){return-1}if(isSearchOnlyAccelerator(second.layoutProperties.standardAccelerator.accelerator)){return 1}const firstModifierCount=getModifierCount(first.layoutProperties.standardAccelerator.accelerator);const secondModifierCount=getModifierCount(second.layoutProperties.standardAccelerator.accelerator);return firstModifierCount-secondModifierCount}export function getModifierString(modifier){switch(modifier){case Modifier.SHIFT:return"shift";case Modifier.CONTROL:return"ctrl";case Modifier.ALT:return"alt";case Modifier.FN_KEY:return"fn";case Modifier.COMMAND:return"meta";default:assertNotReached()}}export function getModifiersForAcceleratorInfo(acceleratorInfo){const modifierStrings=[];for(const modifier of modifiers){if(getAccelerator(acceleratorInfo).modifiers&modifier){modifierStrings.push(getModifierString(modifier))}}return getSortedModifiers(modifierStrings)}export const SHORTCUTS_APP_URL="chrome://shortcut-customization";export const META_KEY="meta";export const LWIN_KEY="Meta";export const getURLForSearchResult=searchResult=>{const url=new URL(SHORTCUTS_APP_URL);const{action:action,category:category}=searchResult.acceleratorLayoutInfo;url.searchParams.append("action",action.toString());url.searchParams.append("category",category.toString());return url};export const isFunctionKey=keycode=>keycode>=kF11&&keycode<=kF24;export const isModifierKey=keycode=>ModifierKeyCodes.includes(keycode);export const isValidAccelerator=accelerator=>accelerator.modifiers>0&&accelerator.keyCode>0||isFunctionKey(accelerator.keyCode);export const containsAccelerator=(accelerators,accelerator)=>accelerators.some((accel=>areAcceleratorsEqual(accel,accelerator)));export const getSourceAndActionFromAcceleratorId=uuid=>{const uuidSplit=uuid.split("-");const source=parseInt(uuidSplit[0],10);const action=parseInt(uuidSplit[1],10);return{source:source,action:action}};export const getKeyDisplay=keyOrIcon=>{const iconName=keyToIconNameMap[keyOrIcon];return iconName?loadTimeData.getString(`iconLabel${keyOrIcon}`):keyOrIcon};export const getNumpadKeyDisplay=code=>{if(code==="NumpadEnter"){return"enter"}const numpadKeyMap={NumpadAdd:"+",NumpadDecimal:".",NumpadDivide:"/",NumpadMultiply:"*",NumpadSubtract:"-"};const numpadKey=numpadKeyMap[code]||code.replace("Numpad","");return`numpad ${numpadKey}`.toLowerCase()};export const getUnidentifiedKeyDisplay=e=>{if(e.code==="Backquote"){if(e.ctrlKey){return unidentifiedKeyCodeToKey[e.keyCode]}return e.key}if(e.code===""){return unidentifiedKeyCodeToKey[e.keyCode]||e.key}return`Key ${e.keyCode}`};export const getAriaLabelForStandardAccelerators=(acceleratorInfos,dividerString)=>acceleratorInfos.map((acceleratorInfo=>getAriaLabelForStandardAcceleratorInfo(acceleratorInfo))).join(` ${dividerString} `);export const getAriaLabelForTextAccelerators=acceleratorInfos=>getTextAcceleratorParts(acceleratorInfos).map((part=>getKeyDisplay(part.text))).join("");export const getAriaLabelForStandardAcceleratorInfo=acceleratorInfo=>{const keyOrIcon=acceleratorInfo.layoutProperties.standardAccelerator.keyDisplay;return getModifiersForAcceleratorInfo(acceleratorInfo).join(" ").concat(` ${getKeyDisplay(keyOrIcon)}`)};export const getTextAcceleratorParts=infos=>{assert(infos.length===1);const textAcceleratorInfo=infos[0];assert(isTextAcceleratorInfo(textAcceleratorInfo));return textAcceleratorInfo.layoutProperties.textAccelerator.parts};export const getModifiersFromKeyboardEvent=e=>{let modifiers=0;if(e.metaKey){modifiers|=Modifier.COMMAND}if(e.ctrlKey){modifiers|=Modifier.CONTROL}if(e.altKey){modifiers|=Modifier.ALT}if(e.key=="Shift"||e.shiftKey){modifiers|=Modifier.SHIFT}return modifiers};export const getKeyDisplayFromKeyboardEvent=e=>{if(e.code.startsWith("Numpad")){return getNumpadKeyDisplay(e.code)}if(e.key==="Unidentified"||e.code===""){return getUnidentifiedKeyDisplay(e)}switch(e.code){case"Space":return"space";case"ShowAllWindows":return"LaunchApplication1";default:return e.key}};export const keyEventToAccelerator=keyEvent=>{const output={modifiers:0,keyCode:0,keyState:AcceleratorKeyState.PRESSED};output.modifiers=keyEvent.modifiers;if(!isModifierKey(keyEvent.vkey)||isFunctionKey(keyEvent.vkey)){output.keyCode=keyEvent.vkey}return output};