// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./accelerator_subsection.js";import"../css/shortcut_customization_shared.css.js";import{strictQuery}from"chrome://resources/ash/common/typescript_utils/strict_query.js";import{assert}from"chrome://resources/js/assert.js";import{afterNextRender,microTask,PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{AcceleratorLookupManager}from"./accelerator_lookup_manager.js";import{getShortcutProvider}from"./mojo_interface_provider.js";import{Router}from"./router.js";import{getTemplate}from"./shortcuts_page.html.js";const kDefaultScrollTimeout=150;export class ShortcutsPageElement extends PolymerElement{constructor(){super(...arguments);this.scrollTimeout=kDefaultScrollTimeout;this.lookupManager=AcceleratorLookupManager.getInstance()}static get is(){return"shortcuts-page"}static get properties(){return{initialData:{type:Object},subcategories:{type:Array,value:[]}}}connectedCallback(){super.connectedCallback();this.updateAccelerators();Router.getInstance().addObserver(this)}disconnectedCallback(){super.disconnectedCallback();Router.getInstance().removeObserver(this)}updateAccelerators(){if(!this.initialData){return}const subcatMap=this.lookupManager.getSubcategories(this.initialData.category);if(subcatMap===undefined){return}const subcategories=[];for(const key of subcatMap.keys()){subcategories.push(key)}this.subcategories=subcategories}getAllSubsections(){const subsections=this.shadowRoot.querySelectorAll("accelerator-subsection");assert(subsections);return subsections}updateSubsections(){for(const subsection of this.getAllSubsections()){subsection.updateSubsection()}}onNavigationPageChanged({isActive:isActive}){if(isActive){afterNextRender(this,(()=>{if(this.initialData){getShortcutProvider().recordMainCategoryNavigation(this.initialData.category)}this.dispatchEvent(new CustomEvent("scroll-to-top",{bubbles:true,composed:true}));const didScroll=this.maybeScrollToAcceleratorRowBasedOnUrl(new URL(window.location.href));if(didScroll){Router.getInstance().resetRoute()}}))}}onRouteChanged(url){const didScroll=this.maybeScrollToAcceleratorRowBasedOnUrl(url);if(didScroll){Router.getInstance().resetRoute()}}maybeScrollToAcceleratorRowBasedOnUrl(url){const action=url.searchParams.get("action");const category=url.searchParams.get("category");if(!action||!category){return false}if(this.initialData?.category.toString()!==category){return false}const acceleratorSubsections=this.shadowRoot?.querySelectorAll("accelerator-subsection");assert(acceleratorSubsections,"Expected this element to contain accelerator-subsection elements.");for(let i=0;i<acceleratorSubsections.length;i++){const matchingAcceleratorRow=acceleratorSubsections[i].shadowRoot?.querySelector(`accelerator-row[action="${action}"]`);if(matchingAcceleratorRow){microTask.run((()=>{if(this.scrollTimeout===0){matchingAcceleratorRow.scrollIntoView({behavior:"smooth"})}else{setTimeout((()=>{matchingAcceleratorRow.scrollIntoView({behavior:"smooth"})}),this.scrollTimeout)}}));strictQuery("#container",matchingAcceleratorRow.shadowRoot,HTMLTableRowElement).focus();this.lookupManager.setSearchResultRowFocused(true);return true}}return false}setScrollTimeoutForTesting(timeout){this.scrollTimeout=timeout}static get template(){return getTemplate()}}customElements.define(ShortcutsPageElement.is,ShortcutsPageElement);