// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/polymer/v3_0/iron-icon/iron-icon.js";import{KeyInputState}from"chrome://resources/ash/common/shortcut_input_ui/shortcut_utils.js";import{assert}from"chrome://resources/js/assert.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{AcceleratorLookupManager}from"./accelerator_lookup_manager.js";import{TextAcceleratorPartType}from"./shortcut_types.js";import{isCustomizationAllowed}from"./shortcut_utils.js";import{getTemplate}from"./text_accelerator.html.js";export class TextAcceleratorElement extends PolymerElement{constructor(){super(...arguments);this.lookupManager=AcceleratorLookupManager.getInstance()}static get is(){return"text-accelerator"}static get properties(){return{parts:{type:Array,observer:TextAcceleratorElement.prototype.parseAndDisplayTextParts},isOnlyText:{type:Boolean,value:false,computed:"areAllPartsTextParts(parts)",reflectToAttribute:true},narrow:{type:Boolean,value:false,reflectToAttribute:true},highlighted:{type:Boolean,value:false,observer:TextAcceleratorElement.prototype.parseAndDisplayTextParts},displayLockIcon:{type:Boolean,value:false},action:{type:Number,value:0},source:{type:Number,value:0}}}parseAndDisplayTextParts(){const container=this.shadowRoot.querySelector(".parts-container");assert(container);assert(window.trustedTypes);container.innerHTML=window.trustedTypes.emptyHTML;const textParts=[];for(const part of this.parts){const text=part.text;if(part.type===TextAcceleratorPartType.kPlainText){textParts.push(this.createPlainTextPart(text))}else if(part.type===TextAcceleratorPartType.kDelimiter){textParts.push(this.createDelimiterIconPart())}else{textParts.push(this.createInputKeyPart(text,part.type))}}container.append(...textParts)}createDelimiterIconPart(){const icon=document.createElement("iron-icon");icon.classList.add("spacing");icon.icon=this.getIconForDelimiter();icon.id="delimiter-icon";return icon}createInputKeyPart(keyText,type){const keyState=type===TextAcceleratorPartType.kModifier?KeyInputState.MODIFIER_SELECTED:KeyInputState.ALPHANUMERIC_SELECTED;const key=document.createElement("shortcut-input-key");key.key=keyText;key.keyState=keyState;key.narrow=this.narrow;key.highlighted=this.highlighted;key.metaKey=this.lookupManager.getMetaKeyToDisplay();return key}getIconForDelimiter(){return"shortcut-customization-keys:plus"}createPlainTextPart(text){const span=document.createElement("span");span.classList.add("spacing");span.innerText=text;return span}shouldShowLockIcon(){if(!isCustomizationAllowed()){return false}return!this.displayLockIcon&&!this.lookupManager.isSubcategoryLocked(this.lookupManager.getAcceleratorSubcategory(this.source,this.action))}areAllPartsTextParts(){return this.parts.every((part=>part.type===TextAcceleratorPartType.kPlainText))}static get template(){return getTemplate()}}customElements.define(TextAcceleratorElement.is,TextAcceleratorElement);