// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{mojo}from"//resources/mojo/mojo/public/js/bindings.js";import{AcceleratorConfigResultSpec as ash_mojom_AcceleratorConfigResultSpec}from"./accelerator_configuration.mojom-webui.js";import{AcceleratorCategorySpec as ash_mojom_AcceleratorCategorySpec,AcceleratorSourceSpec as ash_mojom_AcceleratorSourceSpec,AcceleratorInfoSpec as ash_mojom_AcceleratorInfoSpec,AcceleratorLayoutInfoSpec as ash_mojom_AcceleratorLayoutInfoSpec}from"./accelerator_info.mojom-webui.js";import{VKeySpec as ash_mojom_VKeySpec}from"./accelerator_keys.mojom-webui.js";import{MetaKeySpec as ui_mojom_MetaKeySpec}from"./meta_key.mojom-webui.js";import{String16Spec as mojoBase_mojom_String16Spec}from"//resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js";import{AcceleratorKeyStateSpec as ui_mojom_AcceleratorKeyStateSpec}from"//resources/mojo/ui/base/accelerators/mojom/accelerator.mojom-webui.js";export const UserActionSpec={$:mojo.internal.Enum()};export var UserAction;(function(UserAction){UserAction[UserAction["MIN_VALUE"]=0]="MIN_VALUE";UserAction[UserAction["MAX_VALUE"]=6]="MAX_VALUE";UserAction[UserAction["kOpenEditDialog"]=0]="kOpenEditDialog";UserAction[UserAction["kStartAddAccelerator"]=1]="kStartAddAccelerator";UserAction[UserAction["kStartReplaceAccelerator"]=2]="kStartReplaceAccelerator";UserAction[UserAction["kRemoveAccelerator"]=3]="kRemoveAccelerator";UserAction[UserAction["kSuccessfulModification"]=4]="kSuccessfulModification";UserAction[UserAction["kResetAction"]=5]="kResetAction";UserAction[UserAction["kResetAll"]=6]="kResetAll"})(UserAction||(UserAction={}));export const EditDialogCompletedActionsSpec={$:mojo.internal.Enum()};export var EditDialogCompletedActions;(function(EditDialogCompletedActions){EditDialogCompletedActions[EditDialogCompletedActions["MIN_VALUE"]=0]="MIN_VALUE";EditDialogCompletedActions[EditDialogCompletedActions["MAX_VALUE"]=15]="MAX_VALUE";EditDialogCompletedActions[EditDialogCompletedActions["kNoAction"]=0]="kNoAction";EditDialogCompletedActions[EditDialogCompletedActions["kAdd"]=1]="kAdd";EditDialogCompletedActions[EditDialogCompletedActions["kEdit"]=2]="kEdit";EditDialogCompletedActions[EditDialogCompletedActions["kEditAdd"]=3]="kEditAdd";EditDialogCompletedActions[EditDialogCompletedActions["kRemove"]=4]="kRemove";EditDialogCompletedActions[EditDialogCompletedActions["kRemoveAdd"]=5]="kRemoveAdd";EditDialogCompletedActions[EditDialogCompletedActions["kRemoveEdit"]=6]="kRemoveEdit";EditDialogCompletedActions[EditDialogCompletedActions["kRemoveEditAdd"]=7]="kRemoveEditAdd";EditDialogCompletedActions[EditDialogCompletedActions["kReset"]=8]="kReset";EditDialogCompletedActions[EditDialogCompletedActions["kResetAdd"]=9]="kResetAdd";EditDialogCompletedActions[EditDialogCompletedActions["kResetEdit"]=10]="kResetEdit";EditDialogCompletedActions[EditDialogCompletedActions["kResetEditAdd"]=11]="kResetEditAdd";EditDialogCompletedActions[EditDialogCompletedActions["kResetRemove"]=12]="kResetRemove";EditDialogCompletedActions[EditDialogCompletedActions["kResetRemoveAdd"]=13]="kResetRemoveAdd";EditDialogCompletedActions[EditDialogCompletedActions["kResetRemoveEdit"]=14]="kResetRemoveEdit";EditDialogCompletedActions[EditDialogCompletedActions["kResetRemoveEditAdd"]=15]="kResetRemoveEditAdd"})(EditDialogCompletedActions||(EditDialogCompletedActions={}));export const SubactionsSpec={$:mojo.internal.Enum()};export var Subactions;(function(Subactions){Subactions[Subactions["MIN_VALUE"]=0]="MIN_VALUE";Subactions[Subactions["MAX_VALUE"]=3]="MAX_VALUE";Subactions[Subactions["kNoErrorCancel"]=0]="kNoErrorCancel";Subactions[Subactions["kNoErrorSuccess"]=1]="kNoErrorSuccess";Subactions[Subactions["kErrorCancel"]=2]="kErrorCancel";Subactions[Subactions["kErrorSuccess"]=3]="kErrorSuccess"})(Subactions||(Subactions={}));export class AcceleratorsUpdatedObserverPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.shortcut_customization.mojom.AcceleratorsUpdatedObserver",scope)}}export class AcceleratorsUpdatedObserverRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(AcceleratorsUpdatedObserverPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onAcceleratorsUpdated(config){this.proxy.sendMessage(0,AcceleratorsUpdatedObserver_OnAcceleratorsUpdated_ParamsSpec.$,null,[config],false)}}export class AcceleratorsUpdatedObserverReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AcceleratorsUpdatedObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,AcceleratorsUpdatedObserver_OnAcceleratorsUpdated_ParamsSpec.$,null,impl.onAcceleratorsUpdated.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class AcceleratorsUpdatedObserver{static get $interfaceName(){return"ash.shortcut_customization.mojom.AcceleratorsUpdatedObserver"}static getRemote(){let remote=new AcceleratorsUpdatedObserverRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class AcceleratorsUpdatedObserverCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AcceleratorsUpdatedObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onAcceleratorsUpdated=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,AcceleratorsUpdatedObserver_OnAcceleratorsUpdated_ParamsSpec.$,null,this.onAcceleratorsUpdated.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class PolicyUpdatedObserverPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.shortcut_customization.mojom.PolicyUpdatedObserver",scope)}}export class PolicyUpdatedObserverRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PolicyUpdatedObserverPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onCustomizationPolicyUpdated(){this.proxy.sendMessage(0,PolicyUpdatedObserver_OnCustomizationPolicyUpdated_ParamsSpec.$,null,[],false)}}export class PolicyUpdatedObserverReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PolicyUpdatedObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,PolicyUpdatedObserver_OnCustomizationPolicyUpdated_ParamsSpec.$,null,impl.onCustomizationPolicyUpdated.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class PolicyUpdatedObserver{static get $interfaceName(){return"ash.shortcut_customization.mojom.PolicyUpdatedObserver"}static getRemote(){let remote=new PolicyUpdatedObserverRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class PolicyUpdatedObserverCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PolicyUpdatedObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onCustomizationPolicyUpdated=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,PolicyUpdatedObserver_OnCustomizationPolicyUpdated_ParamsSpec.$,null,this.onCustomizationPolicyUpdated.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class AcceleratorConfigurationProviderPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.shortcut_customization.mojom.AcceleratorConfigurationProvider",scope)}}export class AcceleratorConfigurationProviderRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(AcceleratorConfigurationProviderPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}isMutable(source){return this.proxy.sendMessage(0,AcceleratorConfigurationProvider_IsMutable_ParamsSpec.$,AcceleratorConfigurationProvider_IsMutable_ResponseParamsSpec.$,[source],false)}isCustomizationAllowedByPolicy(){return this.proxy.sendMessage(1,AcceleratorConfigurationProvider_IsCustomizationAllowedByPolicy_ParamsSpec.$,AcceleratorConfigurationProvider_IsCustomizationAllowedByPolicy_ResponseParamsSpec.$,[],false)}getMetaKeyToDisplay(){return this.proxy.sendMessage(2,AcceleratorConfigurationProvider_GetMetaKeyToDisplay_ParamsSpec.$,AcceleratorConfigurationProvider_GetMetaKeyToDisplay_ResponseParamsSpec.$,[],false)}getConflictAccelerator(source,actionId,accelerator){return this.proxy.sendMessage(3,AcceleratorConfigurationProvider_GetConflictAccelerator_ParamsSpec.$,AcceleratorConfigurationProvider_GetConflictAccelerator_ResponseParamsSpec.$,[source,actionId,accelerator],false)}getDefaultAcceleratorsForId(actionId){return this.proxy.sendMessage(4,AcceleratorConfigurationProvider_GetDefaultAcceleratorsForId_ParamsSpec.$,AcceleratorConfigurationProvider_GetDefaultAcceleratorsForId_ResponseParamsSpec.$,[actionId],false)}getAccelerators(){return this.proxy.sendMessage(5,AcceleratorConfigurationProvider_GetAccelerators_ParamsSpec.$,AcceleratorConfigurationProvider_GetAccelerators_ResponseParamsSpec.$,[],false)}addObserver(observer){this.proxy.sendMessage(6,AcceleratorConfigurationProvider_AddObserver_ParamsSpec.$,null,[observer],false)}addPolicyObserver(observer){this.proxy.sendMessage(7,AcceleratorConfigurationProvider_AddPolicyObserver_ParamsSpec.$,null,[observer],false)}getAcceleratorLayoutInfos(){return this.proxy.sendMessage(8,AcceleratorConfigurationProvider_GetAcceleratorLayoutInfos_ParamsSpec.$,AcceleratorConfigurationProvider_GetAcceleratorLayoutInfos_ResponseParamsSpec.$,[],false)}preventProcessingAccelerators(preventProcessingAccelerators){return this.proxy.sendMessage(9,AcceleratorConfigurationProvider_PreventProcessingAccelerators_ParamsSpec.$,AcceleratorConfigurationProvider_PreventProcessingAccelerators_ResponseParamsSpec.$,[preventProcessingAccelerators],false)}addAccelerator(source,actionId,accelerator){return this.proxy.sendMessage(10,AcceleratorConfigurationProvider_AddAccelerator_ParamsSpec.$,AcceleratorConfigurationProvider_AddAccelerator_ResponseParamsSpec.$,[source,actionId,accelerator],false)}removeAccelerator(source,actionId,accelerator){return this.proxy.sendMessage(11,AcceleratorConfigurationProvider_RemoveAccelerator_ParamsSpec.$,AcceleratorConfigurationProvider_RemoveAccelerator_ResponseParamsSpec.$,[source,actionId,accelerator],false)}replaceAccelerator(source,actionId,oldAccelerator,newAccelerator){return this.proxy.sendMessage(12,AcceleratorConfigurationProvider_ReplaceAccelerator_ParamsSpec.$,AcceleratorConfigurationProvider_ReplaceAccelerator_ResponseParamsSpec.$,[source,actionId,oldAccelerator,newAccelerator],false)}restoreDefault(source,actionId){return this.proxy.sendMessage(13,AcceleratorConfigurationProvider_RestoreDefault_ParamsSpec.$,AcceleratorConfigurationProvider_RestoreDefault_ResponseParamsSpec.$,[source,actionId],false)}restoreAllDefaults(){return this.proxy.sendMessage(14,AcceleratorConfigurationProvider_RestoreAllDefaults_ParamsSpec.$,AcceleratorConfigurationProvider_RestoreAllDefaults_ResponseParamsSpec.$,[],false)}recordUserAction(userAction){this.proxy.sendMessage(15,AcceleratorConfigurationProvider_RecordUserAction_ParamsSpec.$,null,[userAction],false)}recordMainCategoryNavigation(category){this.proxy.sendMessage(16,AcceleratorConfigurationProvider_RecordMainCategoryNavigation_ParamsSpec.$,null,[category],false)}recordEditDialogCompletedActions(completedActions){this.proxy.sendMessage(17,AcceleratorConfigurationProvider_RecordEditDialogCompletedActions_ParamsSpec.$,null,[completedActions],false)}recordAddOrEditSubactions(isAdd,subactions){this.proxy.sendMessage(18,AcceleratorConfigurationProvider_RecordAddOrEditSubactions_ParamsSpec.$,null,[isAdd,subactions],false)}hasCustomAccelerators(){return this.proxy.sendMessage(19,AcceleratorConfigurationProvider_HasCustomAccelerators_ParamsSpec.$,AcceleratorConfigurationProvider_HasCustomAccelerators_ResponseParamsSpec.$,[],false)}}export class AcceleratorConfigurationProviderReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AcceleratorConfigurationProviderRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,AcceleratorConfigurationProvider_IsMutable_ParamsSpec.$,AcceleratorConfigurationProvider_IsMutable_ResponseParamsSpec.$,impl.isMutable.bind(impl),false);this.helper_internal_.registerHandler(1,AcceleratorConfigurationProvider_IsCustomizationAllowedByPolicy_ParamsSpec.$,AcceleratorConfigurationProvider_IsCustomizationAllowedByPolicy_ResponseParamsSpec.$,impl.isCustomizationAllowedByPolicy.bind(impl),false);this.helper_internal_.registerHandler(2,AcceleratorConfigurationProvider_GetMetaKeyToDisplay_ParamsSpec.$,AcceleratorConfigurationProvider_GetMetaKeyToDisplay_ResponseParamsSpec.$,impl.getMetaKeyToDisplay.bind(impl),false);this.helper_internal_.registerHandler(3,AcceleratorConfigurationProvider_GetConflictAccelerator_ParamsSpec.$,AcceleratorConfigurationProvider_GetConflictAccelerator_ResponseParamsSpec.$,impl.getConflictAccelerator.bind(impl),false);this.helper_internal_.registerHandler(4,AcceleratorConfigurationProvider_GetDefaultAcceleratorsForId_ParamsSpec.$,AcceleratorConfigurationProvider_GetDefaultAcceleratorsForId_ResponseParamsSpec.$,impl.getDefaultAcceleratorsForId.bind(impl),false);this.helper_internal_.registerHandler(5,AcceleratorConfigurationProvider_GetAccelerators_ParamsSpec.$,AcceleratorConfigurationProvider_GetAccelerators_ResponseParamsSpec.$,impl.getAccelerators.bind(impl),false);this.helper_internal_.registerHandler(6,AcceleratorConfigurationProvider_AddObserver_ParamsSpec.$,null,impl.addObserver.bind(impl),false);this.helper_internal_.registerHandler(7,AcceleratorConfigurationProvider_AddPolicyObserver_ParamsSpec.$,null,impl.addPolicyObserver.bind(impl),false);this.helper_internal_.registerHandler(8,AcceleratorConfigurationProvider_GetAcceleratorLayoutInfos_ParamsSpec.$,AcceleratorConfigurationProvider_GetAcceleratorLayoutInfos_ResponseParamsSpec.$,impl.getAcceleratorLayoutInfos.bind(impl),false);this.helper_internal_.registerHandler(9,AcceleratorConfigurationProvider_PreventProcessingAccelerators_ParamsSpec.$,AcceleratorConfigurationProvider_PreventProcessingAccelerators_ResponseParamsSpec.$,impl.preventProcessingAccelerators.bind(impl),false);this.helper_internal_.registerHandler(10,AcceleratorConfigurationProvider_AddAccelerator_ParamsSpec.$,AcceleratorConfigurationProvider_AddAccelerator_ResponseParamsSpec.$,impl.addAccelerator.bind(impl),false);this.helper_internal_.registerHandler(11,AcceleratorConfigurationProvider_RemoveAccelerator_ParamsSpec.$,AcceleratorConfigurationProvider_RemoveAccelerator_ResponseParamsSpec.$,impl.removeAccelerator.bind(impl),false);this.helper_internal_.registerHandler(12,AcceleratorConfigurationProvider_ReplaceAccelerator_ParamsSpec.$,AcceleratorConfigurationProvider_ReplaceAccelerator_ResponseParamsSpec.$,impl.replaceAccelerator.bind(impl),false);this.helper_internal_.registerHandler(13,AcceleratorConfigurationProvider_RestoreDefault_ParamsSpec.$,AcceleratorConfigurationProvider_RestoreDefault_ResponseParamsSpec.$,impl.restoreDefault.bind(impl),false);this.helper_internal_.registerHandler(14,AcceleratorConfigurationProvider_RestoreAllDefaults_ParamsSpec.$,AcceleratorConfigurationProvider_RestoreAllDefaults_ResponseParamsSpec.$,impl.restoreAllDefaults.bind(impl),false);this.helper_internal_.registerHandler(15,AcceleratorConfigurationProvider_RecordUserAction_ParamsSpec.$,null,impl.recordUserAction.bind(impl),false);this.helper_internal_.registerHandler(16,AcceleratorConfigurationProvider_RecordMainCategoryNavigation_ParamsSpec.$,null,impl.recordMainCategoryNavigation.bind(impl),false);this.helper_internal_.registerHandler(17,AcceleratorConfigurationProvider_RecordEditDialogCompletedActions_ParamsSpec.$,null,impl.recordEditDialogCompletedActions.bind(impl),false);this.helper_internal_.registerHandler(18,AcceleratorConfigurationProvider_RecordAddOrEditSubactions_ParamsSpec.$,null,impl.recordAddOrEditSubactions.bind(impl),false);this.helper_internal_.registerHandler(19,AcceleratorConfigurationProvider_HasCustomAccelerators_ParamsSpec.$,AcceleratorConfigurationProvider_HasCustomAccelerators_ResponseParamsSpec.$,impl.hasCustomAccelerators.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class AcceleratorConfigurationProvider{static get $interfaceName(){return"ash.shortcut_customization.mojom.AcceleratorConfigurationProvider"}static getRemote(){let remote=new AcceleratorConfigurationProviderRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class AcceleratorConfigurationProviderCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AcceleratorConfigurationProviderRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.isMutable=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,AcceleratorConfigurationProvider_IsMutable_ParamsSpec.$,AcceleratorConfigurationProvider_IsMutable_ResponseParamsSpec.$,this.isMutable.createReceiverHandler(true),false);this.isCustomizationAllowedByPolicy=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,AcceleratorConfigurationProvider_IsCustomizationAllowedByPolicy_ParamsSpec.$,AcceleratorConfigurationProvider_IsCustomizationAllowedByPolicy_ResponseParamsSpec.$,this.isCustomizationAllowedByPolicy.createReceiverHandler(true),false);this.getMetaKeyToDisplay=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,AcceleratorConfigurationProvider_GetMetaKeyToDisplay_ParamsSpec.$,AcceleratorConfigurationProvider_GetMetaKeyToDisplay_ResponseParamsSpec.$,this.getMetaKeyToDisplay.createReceiverHandler(true),false);this.getConflictAccelerator=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,AcceleratorConfigurationProvider_GetConflictAccelerator_ParamsSpec.$,AcceleratorConfigurationProvider_GetConflictAccelerator_ResponseParamsSpec.$,this.getConflictAccelerator.createReceiverHandler(true),false);this.getDefaultAcceleratorsForId=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(4,AcceleratorConfigurationProvider_GetDefaultAcceleratorsForId_ParamsSpec.$,AcceleratorConfigurationProvider_GetDefaultAcceleratorsForId_ResponseParamsSpec.$,this.getDefaultAcceleratorsForId.createReceiverHandler(true),false);this.getAccelerators=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(5,AcceleratorConfigurationProvider_GetAccelerators_ParamsSpec.$,AcceleratorConfigurationProvider_GetAccelerators_ResponseParamsSpec.$,this.getAccelerators.createReceiverHandler(true),false);this.addObserver=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(6,AcceleratorConfigurationProvider_AddObserver_ParamsSpec.$,null,this.addObserver.createReceiverHandler(false),false);this.addPolicyObserver=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(7,AcceleratorConfigurationProvider_AddPolicyObserver_ParamsSpec.$,null,this.addPolicyObserver.createReceiverHandler(false),false);this.getAcceleratorLayoutInfos=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(8,AcceleratorConfigurationProvider_GetAcceleratorLayoutInfos_ParamsSpec.$,AcceleratorConfigurationProvider_GetAcceleratorLayoutInfos_ResponseParamsSpec.$,this.getAcceleratorLayoutInfos.createReceiverHandler(true),false);this.preventProcessingAccelerators=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(9,AcceleratorConfigurationProvider_PreventProcessingAccelerators_ParamsSpec.$,AcceleratorConfigurationProvider_PreventProcessingAccelerators_ResponseParamsSpec.$,this.preventProcessingAccelerators.createReceiverHandler(true),false);this.addAccelerator=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(10,AcceleratorConfigurationProvider_AddAccelerator_ParamsSpec.$,AcceleratorConfigurationProvider_AddAccelerator_ResponseParamsSpec.$,this.addAccelerator.createReceiverHandler(true),false);this.removeAccelerator=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(11,AcceleratorConfigurationProvider_RemoveAccelerator_ParamsSpec.$,AcceleratorConfigurationProvider_RemoveAccelerator_ResponseParamsSpec.$,this.removeAccelerator.createReceiverHandler(true),false);this.replaceAccelerator=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(12,AcceleratorConfigurationProvider_ReplaceAccelerator_ParamsSpec.$,AcceleratorConfigurationProvider_ReplaceAccelerator_ResponseParamsSpec.$,this.replaceAccelerator.createReceiverHandler(true),false);this.restoreDefault=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(13,AcceleratorConfigurationProvider_RestoreDefault_ParamsSpec.$,AcceleratorConfigurationProvider_RestoreDefault_ResponseParamsSpec.$,this.restoreDefault.createReceiverHandler(true),false);this.restoreAllDefaults=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(14,AcceleratorConfigurationProvider_RestoreAllDefaults_ParamsSpec.$,AcceleratorConfigurationProvider_RestoreAllDefaults_ResponseParamsSpec.$,this.restoreAllDefaults.createReceiverHandler(true),false);this.recordUserAction=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(15,AcceleratorConfigurationProvider_RecordUserAction_ParamsSpec.$,null,this.recordUserAction.createReceiverHandler(false),false);this.recordMainCategoryNavigation=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(16,AcceleratorConfigurationProvider_RecordMainCategoryNavigation_ParamsSpec.$,null,this.recordMainCategoryNavigation.createReceiverHandler(false),false);this.recordEditDialogCompletedActions=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(17,AcceleratorConfigurationProvider_RecordEditDialogCompletedActions_ParamsSpec.$,null,this.recordEditDialogCompletedActions.createReceiverHandler(false),false);this.recordAddOrEditSubactions=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(18,AcceleratorConfigurationProvider_RecordAddOrEditSubactions_ParamsSpec.$,null,this.recordAddOrEditSubactions.createReceiverHandler(false),false);this.hasCustomAccelerators=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(19,AcceleratorConfigurationProvider_HasCustomAccelerators_ParamsSpec.$,AcceleratorConfigurationProvider_HasCustomAccelerators_ResponseParamsSpec.$,this.hasCustomAccelerators.createReceiverHandler(true),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export const AcceleratorResultDataSpec={$:{}};export const SimpleAcceleratorSpec={$:{}};export const AcceleratorsUpdatedObserver_OnAcceleratorsUpdated_ParamsSpec={$:{}};export const PolicyUpdatedObserver_OnCustomizationPolicyUpdated_ParamsSpec={$:{}};export const AcceleratorConfigurationProvider_IsMutable_ParamsSpec={$:{}};export const AcceleratorConfigurationProvider_IsMutable_ResponseParamsSpec={$:{}};export const AcceleratorConfigurationProvider_IsCustomizationAllowedByPolicy_ParamsSpec={$:{}};export const AcceleratorConfigurationProvider_IsCustomizationAllowedByPolicy_ResponseParamsSpec={$:{}};export const AcceleratorConfigurationProvider_GetMetaKeyToDisplay_ParamsSpec={$:{}};export const AcceleratorConfigurationProvider_GetMetaKeyToDisplay_ResponseParamsSpec={$:{}};export const AcceleratorConfigurationProvider_GetConflictAccelerator_ParamsSpec={$:{}};export const AcceleratorConfigurationProvider_GetConflictAccelerator_ResponseParamsSpec={$:{}};export const AcceleratorConfigurationProvider_GetDefaultAcceleratorsForId_ParamsSpec={$:{}};export const AcceleratorConfigurationProvider_GetDefaultAcceleratorsForId_ResponseParamsSpec={$:{}};export const AcceleratorConfigurationProvider_GetAccelerators_ParamsSpec={$:{}};export const AcceleratorConfigurationProvider_GetAccelerators_ResponseParamsSpec={$:{}};export const AcceleratorConfigurationProvider_AddObserver_ParamsSpec={$:{}};export const AcceleratorConfigurationProvider_AddPolicyObserver_ParamsSpec={$:{}};export const AcceleratorConfigurationProvider_GetAcceleratorLayoutInfos_ParamsSpec={$:{}};export const AcceleratorConfigurationProvider_GetAcceleratorLayoutInfos_ResponseParamsSpec={$:{}};export const AcceleratorConfigurationProvider_PreventProcessingAccelerators_ParamsSpec={$:{}};export const AcceleratorConfigurationProvider_PreventProcessingAccelerators_ResponseParamsSpec={$:{}};export const AcceleratorConfigurationProvider_AddAccelerator_ParamsSpec={$:{}};export const AcceleratorConfigurationProvider_AddAccelerator_ResponseParamsSpec={$:{}};export const AcceleratorConfigurationProvider_RemoveAccelerator_ParamsSpec={$:{}};export const AcceleratorConfigurationProvider_RemoveAccelerator_ResponseParamsSpec={$:{}};export const AcceleratorConfigurationProvider_ReplaceAccelerator_ParamsSpec={$:{}};export const AcceleratorConfigurationProvider_ReplaceAccelerator_ResponseParamsSpec={$:{}};export const AcceleratorConfigurationProvider_RestoreDefault_ParamsSpec={$:{}};export const AcceleratorConfigurationProvider_RestoreDefault_ResponseParamsSpec={$:{}};export const AcceleratorConfigurationProvider_RestoreAllDefaults_ParamsSpec={$:{}};export const AcceleratorConfigurationProvider_RestoreAllDefaults_ResponseParamsSpec={$:{}};export const AcceleratorConfigurationProvider_RecordUserAction_ParamsSpec={$:{}};export const AcceleratorConfigurationProvider_RecordMainCategoryNavigation_ParamsSpec={$:{}};export const AcceleratorConfigurationProvider_RecordEditDialogCompletedActions_ParamsSpec={$:{}};export const AcceleratorConfigurationProvider_RecordAddOrEditSubactions_ParamsSpec={$:{}};export const AcceleratorConfigurationProvider_HasCustomAccelerators_ParamsSpec={$:{}};export const AcceleratorConfigurationProvider_HasCustomAccelerators_ResponseParamsSpec={$:{}};mojo.internal.Struct(AcceleratorResultDataSpec.$,"AcceleratorResultData",[mojo.internal.StructField("shortcutName",0,0,mojoBase_mojom_String16Spec.$,null,true,0,undefined,undefined),mojo.internal.StructField("result",8,0,ash_mojom_AcceleratorConfigResultSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(SimpleAcceleratorSpec.$,"SimpleAccelerator",[mojo.internal.StructField("keyCode",0,0,ash_mojom_VKeySpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("modifiers",4,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("keyState",8,0,ui_mojom_AcceleratorKeyStateSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(AcceleratorsUpdatedObserver_OnAcceleratorsUpdated_ParamsSpec.$,"AcceleratorsUpdatedObserver_OnAcceleratorsUpdated_Params",[mojo.internal.StructField("config",0,0,mojo.internal.Map(ash_mojom_AcceleratorSourceSpec.$,mojo.internal.Map(mojo.internal.Uint32,mojo.internal.Array(ash_mojom_AcceleratorInfoSpec.$,false),false),false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PolicyUpdatedObserver_OnCustomizationPolicyUpdated_ParamsSpec.$,"PolicyUpdatedObserver_OnCustomizationPolicyUpdated_Params",[],[[0,8]]);mojo.internal.Struct(AcceleratorConfigurationProvider_IsMutable_ParamsSpec.$,"AcceleratorConfigurationProvider_IsMutable_Params",[mojo.internal.StructField("source",0,0,ash_mojom_AcceleratorSourceSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(AcceleratorConfigurationProvider_IsMutable_ResponseParamsSpec.$,"AcceleratorConfigurationProvider_IsMutable_ResponseParams",[mojo.internal.StructField("isMutable",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(AcceleratorConfigurationProvider_IsCustomizationAllowedByPolicy_ParamsSpec.$,"AcceleratorConfigurationProvider_IsCustomizationAllowedByPolicy_Params",[],[[0,8]]);mojo.internal.Struct(AcceleratorConfigurationProvider_IsCustomizationAllowedByPolicy_ResponseParamsSpec.$,"AcceleratorConfigurationProvider_IsCustomizationAllowedByPolicy_ResponseParams",[mojo.internal.StructField("isCustomizationAllowedByPolicy",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(AcceleratorConfigurationProvider_GetMetaKeyToDisplay_ParamsSpec.$,"AcceleratorConfigurationProvider_GetMetaKeyToDisplay_Params",[],[[0,8]]);mojo.internal.Struct(AcceleratorConfigurationProvider_GetMetaKeyToDisplay_ResponseParamsSpec.$,"AcceleratorConfigurationProvider_GetMetaKeyToDisplay_ResponseParams",[mojo.internal.StructField("metaKey",0,0,ui_mojom_MetaKeySpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(AcceleratorConfigurationProvider_GetConflictAccelerator_ParamsSpec.$,"AcceleratorConfigurationProvider_GetConflictAccelerator_Params",[mojo.internal.StructField("source",0,0,ash_mojom_AcceleratorSourceSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("actionId",4,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("accelerator",8,0,SimpleAcceleratorSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(AcceleratorConfigurationProvider_GetConflictAccelerator_ResponseParamsSpec.$,"AcceleratorConfigurationProvider_GetConflictAccelerator_ResponseParams",[mojo.internal.StructField("result",0,0,AcceleratorResultDataSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(AcceleratorConfigurationProvider_GetDefaultAcceleratorsForId_ParamsSpec.$,"AcceleratorConfigurationProvider_GetDefaultAcceleratorsForId_Params",[mojo.internal.StructField("actionId",0,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(AcceleratorConfigurationProvider_GetDefaultAcceleratorsForId_ResponseParamsSpec.$,"AcceleratorConfigurationProvider_GetDefaultAcceleratorsForId_ResponseParams",[mojo.internal.StructField("accelerators",0,0,mojo.internal.Array(SimpleAcceleratorSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(AcceleratorConfigurationProvider_GetAccelerators_ParamsSpec.$,"AcceleratorConfigurationProvider_GetAccelerators_Params",[],[[0,8]]);mojo.internal.Struct(AcceleratorConfigurationProvider_GetAccelerators_ResponseParamsSpec.$,"AcceleratorConfigurationProvider_GetAccelerators_ResponseParams",[mojo.internal.StructField("config",0,0,mojo.internal.Map(ash_mojom_AcceleratorSourceSpec.$,mojo.internal.Map(mojo.internal.Uint32,mojo.internal.Array(ash_mojom_AcceleratorInfoSpec.$,false),false),false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(AcceleratorConfigurationProvider_AddObserver_ParamsSpec.$,"AcceleratorConfigurationProvider_AddObserver_Params",[mojo.internal.StructField("observer",0,0,mojo.internal.InterfaceProxy(AcceleratorsUpdatedObserverRemote),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(AcceleratorConfigurationProvider_AddPolicyObserver_ParamsSpec.$,"AcceleratorConfigurationProvider_AddPolicyObserver_Params",[mojo.internal.StructField("observer",0,0,mojo.internal.InterfaceProxy(PolicyUpdatedObserverRemote),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(AcceleratorConfigurationProvider_GetAcceleratorLayoutInfos_ParamsSpec.$,"AcceleratorConfigurationProvider_GetAcceleratorLayoutInfos_Params",[],[[0,8]]);mojo.internal.Struct(AcceleratorConfigurationProvider_GetAcceleratorLayoutInfos_ResponseParamsSpec.$,"AcceleratorConfigurationProvider_GetAcceleratorLayoutInfos_ResponseParams",[mojo.internal.StructField("layoutInfos",0,0,mojo.internal.Array(ash_mojom_AcceleratorLayoutInfoSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(AcceleratorConfigurationProvider_PreventProcessingAccelerators_ParamsSpec.$,"AcceleratorConfigurationProvider_PreventProcessingAccelerators_Params",[mojo.internal.StructField("preventProcessingAccelerators",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(AcceleratorConfigurationProvider_PreventProcessingAccelerators_ResponseParamsSpec.$,"AcceleratorConfigurationProvider_PreventProcessingAccelerators_ResponseParams",[],[[0,8]]);mojo.internal.Struct(AcceleratorConfigurationProvider_AddAccelerator_ParamsSpec.$,"AcceleratorConfigurationProvider_AddAccelerator_Params",[mojo.internal.StructField("source",0,0,ash_mojom_AcceleratorSourceSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("actionId",4,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("accelerator",8,0,SimpleAcceleratorSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(AcceleratorConfigurationProvider_AddAccelerator_ResponseParamsSpec.$,"AcceleratorConfigurationProvider_AddAccelerator_ResponseParams",[mojo.internal.StructField("result",0,0,AcceleratorResultDataSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(AcceleratorConfigurationProvider_RemoveAccelerator_ParamsSpec.$,"AcceleratorConfigurationProvider_RemoveAccelerator_Params",[mojo.internal.StructField("source",0,0,ash_mojom_AcceleratorSourceSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("actionId",4,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("accelerator",8,0,SimpleAcceleratorSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(AcceleratorConfigurationProvider_RemoveAccelerator_ResponseParamsSpec.$,"AcceleratorConfigurationProvider_RemoveAccelerator_ResponseParams",[mojo.internal.StructField("result",0,0,AcceleratorResultDataSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(AcceleratorConfigurationProvider_ReplaceAccelerator_ParamsSpec.$,"AcceleratorConfigurationProvider_ReplaceAccelerator_Params",[mojo.internal.StructField("source",0,0,ash_mojom_AcceleratorSourceSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("actionId",4,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("oldAccelerator",8,0,SimpleAcceleratorSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("newAccelerator",16,0,SimpleAcceleratorSpec.$,null,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(AcceleratorConfigurationProvider_ReplaceAccelerator_ResponseParamsSpec.$,"AcceleratorConfigurationProvider_ReplaceAccelerator_ResponseParams",[mojo.internal.StructField("result",0,0,AcceleratorResultDataSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(AcceleratorConfigurationProvider_RestoreDefault_ParamsSpec.$,"AcceleratorConfigurationProvider_RestoreDefault_Params",[mojo.internal.StructField("source",0,0,ash_mojom_AcceleratorSourceSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("actionId",4,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(AcceleratorConfigurationProvider_RestoreDefault_ResponseParamsSpec.$,"AcceleratorConfigurationProvider_RestoreDefault_ResponseParams",[mojo.internal.StructField("result",0,0,AcceleratorResultDataSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(AcceleratorConfigurationProvider_RestoreAllDefaults_ParamsSpec.$,"AcceleratorConfigurationProvider_RestoreAllDefaults_Params",[],[[0,8]]);mojo.internal.Struct(AcceleratorConfigurationProvider_RestoreAllDefaults_ResponseParamsSpec.$,"AcceleratorConfigurationProvider_RestoreAllDefaults_ResponseParams",[mojo.internal.StructField("result",0,0,AcceleratorResultDataSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(AcceleratorConfigurationProvider_RecordUserAction_ParamsSpec.$,"AcceleratorConfigurationProvider_RecordUserAction_Params",[mojo.internal.StructField("userAction",0,0,UserActionSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(AcceleratorConfigurationProvider_RecordMainCategoryNavigation_ParamsSpec.$,"AcceleratorConfigurationProvider_RecordMainCategoryNavigation_Params",[mojo.internal.StructField("category",0,0,ash_mojom_AcceleratorCategorySpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(AcceleratorConfigurationProvider_RecordEditDialogCompletedActions_ParamsSpec.$,"AcceleratorConfigurationProvider_RecordEditDialogCompletedActions_Params",[mojo.internal.StructField("completedActions",0,0,EditDialogCompletedActionsSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(AcceleratorConfigurationProvider_RecordAddOrEditSubactions_ParamsSpec.$,"AcceleratorConfigurationProvider_RecordAddOrEditSubactions_Params",[mojo.internal.StructField("isAdd",0,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("subactions",4,0,SubactionsSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(AcceleratorConfigurationProvider_HasCustomAccelerators_ParamsSpec.$,"AcceleratorConfigurationProvider_HasCustomAccelerators_Params",[],[[0,8]]);mojo.internal.Struct(AcceleratorConfigurationProvider_HasCustomAccelerators_ResponseParamsSpec.$,"AcceleratorConfigurationProvider_HasCustomAccelerators_ResponseParams",[mojo.internal.StructField("hasCustomAccelerators",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);