import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="shortcut-customization-shared cr-shared-style">
  #container {
    align-items: flex-start;
    column-gap: 24px;
    display: grid;
    grid-auto-rows: minmax(52px, auto);
    grid-template-columns: minmax(min-content, 286px) 50%;
    padding-inline-end: 10px;
  }

  /* Show edit-button when user hover on the row container. */
  #container:hover accelerator-view::part(edit-icon),
  #container:hover .edit-button {
    opacity: 1;
  }

  /* Show edit-button when user tab on the row container. */
  #container:focus-visible accelerator-view::part(edit-icon),
  #container:focus-visible .edit-button {
    opacity: 1;
  }

  /* Show edit-button when tab on the edit-button itself. */
  .edit-button:focus-visible {
    opacity: 1;
  }

  #container:focus {
    background-color: var(--cros-sys-highlight_shape);
    box-shadow: -20px 0 var(--cros-sys-highlight_shape),
                10px 0 var(--cros-sys-highlight_shape);
    outline: none;
  }

  accelerator-view,
  text-accelerator {
    line-height: 3.2;
    padding-bottom: 10px;
    padding-top: 10px;
  }

  text-accelerator[is-only-text] {
    line-height: initial;
  }

  accelerator-view:not(:first-of-type) {
    border-top: var(--cr-separator-line);
  }

  #descriptionText {
    align-content: center;
    -webkit-box-orient: vertical;
    -webkit-line-clamp: 3;
    color: var(--cros-text-color-primary);
    display: -webkit-box;
    font: var(--cros-body-2-font);
    height: 62px;
    overflow: hidden;
    padding: 0; /* Remove padding coming from <th> tag. */
    text-align: initial;
  }

  #container:has(text-accelerator) #descriptionText {
    /* For text accelerator descriptions, adjust height so that the description
     * is centered in the container. */
    height: 100%;
  }

  td {
    display: flex;
    flex-direction: column;
    height: 100%;
    justify-content: center;
    padding: 0;
  }

  #noShortcutAssignedContainer {
    align-items: center;
    display: flex;
    flex-direction: row;
    justify-content: space-between;
  }

  #noShortcutAssignedContainer[hidden] {
    display: none;
  }

  paper-tooltip {
    --paper-tooltip-min-width: 0;
  }
</style>

<tr id="container" tabindex="-1" role="row"
    on-focus="onFocusOrMouseEnter" on-blur="onBlur"
    on-mouseenter="onFocusOrMouseEnter"
    aria-label$="[[getAriaLabel(description, acceleratorInfos)]]">
  <th id="descriptionText" on-mouseenter="onMouseEnterDescriptionText_" scope="row">[[description]]</th>
  <paper-tooltip
      hidden="[[!isEllipsisActive_]]"
      fit-to-visible-bounds
      offset="0"
      for="descriptionText">
    [[description]]
  </paper-tooltip>
  <td>
    <template is="dom-if" if="[[isDefaultLayout(layoutStyle)]]">
      <template is="dom-repeat" items="[[acceleratorInfos]]" as="item"
          index-as="index">
        <accelerator-view class="accelerator-item" accelerator-info="[[item]]"
            description="[[description]]" action="[[action]]" source="[[source]]"
            source-is-locked="[[isLocked]]" show-edit-icon="true"
            is-first-accelerator="[[isFirstAccelerator(index)]]">
        </accelerator-view>
      </template>
      <div id="noShortcutAssignedContainer" hidden="[[!isEmptyList(acceleratorInfos)]]">
        <div id="noShortcutAssignedMessage">
          [[i18n('noShortcutAssigned')]]
        </div>
        <template is="dom-if" if="[[!isLocked]]">
          <div class="edit-icon-container">
            <cr-icon-button class="edit-button" class="clickable-button"
                iron-icon="shortcut-customization:edit"
                aria-label="[[getEditButtonAriaLabel(description)]]"
                on-click="onEditIconClicked">
            </cr-icon-button>
          </div>
        </template>
      </div>
    </template>
    <template is="dom-if" if="[[isTextLayout(layoutStyle)]]">
      <text-accelerator parts="[[getTextAcceleratorParts(acceleratorInfos)]]"
          action="[[action]]" source="[[source]]" highlighted="[[selected]]">
      </text-accelerator>
    </template>
  </td>
</tr><!--_html_template_end_-->`;
}
