import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-shared-style cros-color-overrides">:host{width:100%;--result-bg-color-selected:var(--cros-highlight-color);--result-bg-color-not-selected-hover:var(--cros-highlight-color-hover)}:host-context(body.jelly-enabled){--result-bg-color-selected:var(--cros-sys-highlight_shape);--result-bg-color-not-selected-hover:var(--cros-sys-hover_on_subtle)}:host-context(body.jelly-enabled) #description{color:var(--cros-sys-on_surface)}:host([selected]) [focus-row-container]{background-color:var(--result-bg-color-selected)}:host(:not([selected])) [focus-row-container]:hover{background-color:var(--result-bg-color-not-selected-hover)}#searchResultRowInner{align-items:center;cursor:pointer;display:flex;flex-direction:row;height:48px;justify-content:center;width:100%}#description{flex:1;margin-inline-end:16px;overflow:hidden;padding-inline-start:16px;text-overflow:ellipsis;white-space:nowrap}#accelerators{-webkit-mask-image:linear-gradient(to left,transparent,white 32px);align-items:center;display:flex;flex:1;height:100%;overflow:hidden}:host-context([dir=rtl]) #accelerators{-webkit-mask-image:linear-gradient(to right,transparent,white 32px)}.accelerator-keys{align-items:center;display:flex;flex-direction:row}.accelerator-text-divider{color:var(--cros-text-color-secondary);margin-inline:4px 8px}#actionIcon{margin:var(--cr-toolbar-icon-margin);width:var(--cr-toolbar-icon-container-size)}:host-context([dir=rtl]) #actionIcon{transform:scaleX(-1)}b{color:var(--cros-text-color-primary)}</style>

<div id="searchResultRow" focus-row-container>
  <div focus-row-control
      aria-disabled="true"
      focus-type="rowWrapper"
      id="searchResultRowInner"
      on-click="onSearchResultSelected"
      on-keypress="onKeyPress"
      selectable>
      <div id="description" aria-hidden="true"
          inner-h-t-m-l="[[getSearchResultDescriptionInnerHtml(searchResult)]]">
      </div>
      <div id="accelerators">
        <template is="dom-if" if="[[isStandardLayout(searchResult)]]">
          <template is="dom-repeat"
              items="[[getStandardAcceleratorInfos(searchResult)]]"
              as="acceleratorInfo" indexAs="index">
            <div class="accelerator-keys">
              <template is="dom-repeat"
                  items="[[getStandardAcceleratorModifiers(acceleratorInfo)]]"
                  as="modifierKey">
                <shortcut-input-key key="[[modifierKey]]" key-state="modifier-selected"
                    narrow highlighted="[[selected]]"
                    meta-key="[[metaKey]]">
                </shortcut-input-key>
              </template>
              <shortcut-input-key
                  key="[[getStandardAcceleratorKey(acceleratorInfo)]]"
                  key-state="alpha-numeric-selected" narrow
                  highlighted="[[selected]]"
                  meta-key="[[metaKey]]">
              </shortcut-input-key>
              <template is="dom-if"
                  if="[[shouldShowTextDivider(index, searchResult)]]">
                <div class="accelerator-text-divider">
                  [[i18n('acceleratorTextDivider')]]
                </div>
              </template>
            </div>
          </template>
        </template>
        <template is="dom-if" if="[[isTextLayout(searchResult)]]">
          <text-accelerator parts="[[getTextAcceleratorParts(searchResult)]]"
              highlighted="[[selected]]" narrow display-lock-icon>
          </text-accelerator>
        </template>
        <template is="dom-if" if="[[isNoShortcutAssigned(searchResult)]]">
          <div id="noShortcutAssignedMessage">
            [[i18n('noShortcutAssigned')]]
          </div>
        </template>
      </div>
      <iron-icon id="actionIcon" icon="cr:arrow-forward"></iron-icon>
    </div>
</div>
<!--_html_template_end_-->`;
}
