// ash/webui/common/mojom/shortcut_input_provider.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { KeyEventSpec as ash_mojom_KeyEventSpec } from './input_device_settings.mojom-webui.js';
export class ShortcutInputObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.common.mojom.ShortcutInputObserver', scope);
    }
}
export class ShortcutInputObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ShortcutInputObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onShortcutInputEventPressed(prerewrittenKeyEvent, keyEvent) {
        this.proxy.sendMessage(0, ShortcutInputObserver_OnShortcutInputEventPressed_ParamsSpec.$, null, [
            prerewrittenKeyEvent,
            keyEvent
        ], false);
    }
    onShortcutInputEventReleased(prerewrittenKeyEvent, keyEvent) {
        this.proxy.sendMessage(1, ShortcutInputObserver_OnShortcutInputEventReleased_ParamsSpec.$, null, [
            prerewrittenKeyEvent,
            keyEvent
        ], false);
    }
}
;
/**
 * An object which receives request messages for the ShortcutInputObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ShortcutInputObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ShortcutInputObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ShortcutInputObserver_OnShortcutInputEventPressed_ParamsSpec.$, null, impl.onShortcutInputEventPressed.bind(impl), false);
        this.helper_internal_.registerHandler(1, ShortcutInputObserver_OnShortcutInputEventReleased_ParamsSpec.$, null, impl.onShortcutInputEventReleased.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class ShortcutInputObserver {
    static get $interfaceName() {
        return "ash.common.mojom.ShortcutInputObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new ShortcutInputObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the ShortcutInputObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ShortcutInputObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ShortcutInputObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onShortcutInputEventPressed =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, ShortcutInputObserver_OnShortcutInputEventPressed_ParamsSpec.$, null, this.onShortcutInputEventPressed.createReceiverHandler(false /* expectsResponse */), false);
        this.onShortcutInputEventReleased =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, ShortcutInputObserver_OnShortcutInputEventReleased_ParamsSpec.$, null, this.onShortcutInputEventReleased.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class ShortcutInputProviderPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.common.mojom.ShortcutInputProvider', scope);
    }
}
export class ShortcutInputProviderRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ShortcutInputProviderPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    startObservingShortcutInput(observer) {
        this.proxy.sendMessage(0, ShortcutInputProvider_StartObservingShortcutInput_ParamsSpec.$, null, [
            observer
        ], false);
    }
    stopObservingShortcutInput() {
        this.proxy.sendMessage(1, ShortcutInputProvider_StopObservingShortcutInput_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the ShortcutInputProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ShortcutInputProviderReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ShortcutInputProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ShortcutInputProvider_StartObservingShortcutInput_ParamsSpec.$, null, impl.startObservingShortcutInput.bind(impl), false);
        this.helper_internal_.registerHandler(1, ShortcutInputProvider_StopObservingShortcutInput_ParamsSpec.$, null, impl.stopObservingShortcutInput.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class ShortcutInputProvider {
    static get $interfaceName() {
        return "ash.common.mojom.ShortcutInputProvider";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new ShortcutInputProviderRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the ShortcutInputProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ShortcutInputProviderCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ShortcutInputProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.startObservingShortcutInput =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, ShortcutInputProvider_StartObservingShortcutInput_ParamsSpec.$, null, this.startObservingShortcutInput.createReceiverHandler(false /* expectsResponse */), false);
        this.stopObservingShortcutInput =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, ShortcutInputProvider_StopObservingShortcutInput_ParamsSpec.$, null, this.stopObservingShortcutInput.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const ShortcutInputObserver_OnShortcutInputEventPressed_ParamsSpec = { $: {} };
export const ShortcutInputObserver_OnShortcutInputEventReleased_ParamsSpec = { $: {} };
export const ShortcutInputProvider_StartObservingShortcutInput_ParamsSpec = { $: {} };
export const ShortcutInputProvider_StopObservingShortcutInput_ParamsSpec = { $: {} };
mojo.internal.Struct(ShortcutInputObserver_OnShortcutInputEventPressed_ParamsSpec.$, 'ShortcutInputObserver_OnShortcutInputEventPressed_Params', [
    mojo.internal.StructField('prerewrittenKeyEvent', 0, 0, ash_mojom_KeyEventSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('keyEvent', 8, 0, ash_mojom_KeyEventSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ShortcutInputObserver_OnShortcutInputEventReleased_ParamsSpec.$, 'ShortcutInputObserver_OnShortcutInputEventReleased_Params', [
    mojo.internal.StructField('prerewrittenKeyEvent', 0, 0, ash_mojom_KeyEventSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('keyEvent', 8, 0, ash_mojom_KeyEventSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ShortcutInputProvider_StartObservingShortcutInput_ParamsSpec.$, 'ShortcutInputProvider_StartObservingShortcutInput_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(ShortcutInputObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ShortcutInputProvider_StopObservingShortcutInput_ParamsSpec.$, 'ShortcutInputProvider_StopObservingShortcutInput_Params', [], [[0, 8],]);
