import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><!-- Copyright 2023 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file. -->

<style>:host{display:flex;flex-direction:column;justify-content:center;height:100%}app-header{background-color:royalblue;color:white;font-size:200%;padding:8px;text-align:center}.input-field{margin:2.5% 5%;display:flex}.input-field-column{flex:1;margin-right:16px}.input-field ol{margin:0 0 8px 0;padding:0 16px}.input-field ol>li{align-items:center;border-bottom:none;display:flex;padding:0 0 8px 0}.padded-text{margin-inline-start:5px}.row{display:flex;flex:0 1 100%}.radio-group{margin-left:16px}.radio-group h2{margin-bottom:8px}.radio-group label{display:block;margin-bottom:8px}</style>

<app-header>
  <app-toolbar>ChromeOS Status Area Tester</app-toolbar>
</app-header>

<div class="input-field">
  <div class=""input-field-column>
    <ol>
      <h2>Shelf Pod</h2>
      <p>Toggle to show or hide the pod in the shelf</p>
      <li>
        <div class="row">
          <cr-toggle aria-label="ime-tray" on-change="onImeToggled"></cr-toggle>
          <span aria-hidden="true" class="padded-text">
            IME Tray
          </span>
        </div>
      </li>
      <li>
        <div class="row">
          <cr-toggle aria-label="palette-tray" on-change="onPaletteToggled">
          </cr-toggle>
          <span aria-hidden="true" class="padded-text">
            Palette Tray
          </span>
        </div>
      </li>
      <li>
        <div class="row">
          <cr-toggle aria-label="logout-button" on-change="onLogoutToggled">
          </cr-toggle>
          <span aria-hidden="true" class="padded-text">
            Logout Button
          </span>
        </div>
      </li>
      <li>
        <div class="row">
          <cr-toggle aria-label="logout-button" on-change="onVirtualKeyboardToggled">
          </cr-toggle>
          <span aria-hidden="true" class="padded-text">
            Virtual Keyboard Tray
          </span>
        </div>
      </li>
      <li>
        <div class="row">
          <cr-toggle aria-label="logout-button" on-change="onDictationToggled">
          </cr-toggle>
          <span aria-hidden="true" class="padded-text">
            Dictation Tray
          </span>
        </div>
      </li>
      <li>
        <div class="row">
          <cr-toggle aria-label="logout-button" on-change="onVideoConferenceToggled">
          </cr-toggle>
          <span aria-hidden="true" class="padded-text">
            Video Conference Tray
          </span>
        </div>
      </li>
      <li>
        <div class="row">
          <cr-toggle aria-label="annotation-tray" on-change="onAnnotatorToggled">
          </cr-toggle>
          <span aria-hidden="true" class="padded-text">
            Annotation Tray
          </span>
        </div>
      </li>
    </ol>
    <ol>
      <h2>Quick Settings</h2>
      <h3>Supervised User UI</h3>
      <li>
        <div class="row">
          <cr-toggle aria-label="child-user" on-change="onChildUserToggled">
          </cr-toggle>
          <span aria-hidden="true" class="padded-text">
            Child User
          </span>
        </div>
      </li>
    </ol>
    <ol>
      <h2>Privacy Indicators</h2>
      <privacy-indicator-app-manager></privacy-indicator-app-manager>
    </ol>
    <ol>
      <h2>Help Me Write</h2>
      <li>
        <div class="row">
          <cr-button on-click="onHmrConsentStatusReset">
            <span class="emphasize">Reset Help Me Write consent status</span>
          </cr-button>
        </div>
      </li>
    </ol>
  </div>
  <div class="input-field-column">
    <div class="radio-group" aria-label="icon-settings" on-change="onBatteryIconChanged">
      <h2>Battery Settings</h2>
      <p class="note">Note: Power settings cannot be accessed when this page is open.</p>
        <label>
          <input type="radio" aria-label="x-icon" name="battery-icon" value="x-icon">
          X-icon
        </label>
        <label>
          <input type="radio" aria-label="unreliable-icon" name="battery-icon" value="unreliable-icon">
          Unreliable Icon
        </label>
        <label>
          <input type="radio" aria-label="bolt-icon" name="battery-icon" value="bolt-icon">
          Bolt Icon
        </label>
        <label>
          <input type="radio" aria-label="battery-saver-plus-icon" name="battery-icon" value="battery-saver-plus-icon">
          Battery Saver Plus Icon
        </label>
        <label>
          <input type="radio" aria-label="default" name="battery-icon" value="default" checked>
          Default (no-icon)
        </label>
    </div>
    <div class="row">
      <label>
        Battery Percentage:
        <input type="range" id="battery-percent-slider" aria-label="battery-percentage-slider" name="battery-percent" min="0" max="100" value="{{batteryPercent::input}}" on-change="onBatteryPercentChanged">
      </label>
      <span id="battery-percent-value">{{batteryPercent}}%</span>
    </div>
  </div>
</div>
<!--_html_template_end_-->`}