// ash/webui/status_area_internals/mojom/status_area_internals.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
export class PageHandlerPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.mojom.status_area_internals.PageHandler', scope);
    }
}
export class PageHandlerRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    toggleImeTray(visible) {
        this.proxy.sendMessage(0, PageHandler_ToggleImeTray_ParamsSpec.$, null, [
            visible
        ], false);
    }
    togglePaletteTray(visible) {
        this.proxy.sendMessage(1, PageHandler_TogglePaletteTray_ParamsSpec.$, null, [
            visible
        ], false);
    }
    toggleLogoutTray(visible) {
        this.proxy.sendMessage(2, PageHandler_ToggleLogoutTray_ParamsSpec.$, null, [
            visible
        ], false);
    }
    toggleVirtualKeyboardTray(visible) {
        this.proxy.sendMessage(3, PageHandler_ToggleVirtualKeyboardTray_ParamsSpec.$, null, [
            visible
        ], false);
    }
    toggleDictationTray(visible) {
        this.proxy.sendMessage(4, PageHandler_ToggleDictationTray_ParamsSpec.$, null, [
            visible
        ], false);
    }
    toggleVideoConferenceTray(visible) {
        this.proxy.sendMessage(5, PageHandler_ToggleVideoConferenceTray_ParamsSpec.$, null, [
            visible
        ], false);
    }
    toggleAnnotationTray(visible) {
        this.proxy.sendMessage(6, PageHandler_ToggleAnnotationTray_ParamsSpec.$, null, [
            visible
        ], false);
    }
    setIsInUserChildSession(inChildSession) {
        this.proxy.sendMessage(7, PageHandler_SetIsInUserChildSession_ParamsSpec.$, null, [
            inChildSession
        ], false);
    }
    triggerPrivacyIndicators(appId, appName, isCameraUsed, isMicrophoneUsed) {
        this.proxy.sendMessage(8, PageHandler_TriggerPrivacyIndicators_ParamsSpec.$, null, [
            appId,
            appName,
            isCameraUsed,
            isMicrophoneUsed
        ], false);
    }
    resetHmrConsentStatus() {
        this.proxy.sendMessage(9, PageHandler_ResetHmrConsentStatus_ParamsSpec.$, null, [], false);
    }
    setBatteryIcon(icon) {
        this.proxy.sendMessage(10, PageHandler_SetBatteryIcon_ParamsSpec.$, null, [
            icon
        ], false);
    }
    setBatteryPercent(percent) {
        this.proxy.sendMessage(11, PageHandler_SetBatteryPercent_ParamsSpec.$, null, [
            percent
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandler_ToggleImeTray_ParamsSpec.$, null, impl.toggleImeTray.bind(impl), false);
        this.helper_internal_.registerHandler(1, PageHandler_TogglePaletteTray_ParamsSpec.$, null, impl.togglePaletteTray.bind(impl), false);
        this.helper_internal_.registerHandler(2, PageHandler_ToggleLogoutTray_ParamsSpec.$, null, impl.toggleLogoutTray.bind(impl), false);
        this.helper_internal_.registerHandler(3, PageHandler_ToggleVirtualKeyboardTray_ParamsSpec.$, null, impl.toggleVirtualKeyboardTray.bind(impl), false);
        this.helper_internal_.registerHandler(4, PageHandler_ToggleDictationTray_ParamsSpec.$, null, impl.toggleDictationTray.bind(impl), false);
        this.helper_internal_.registerHandler(5, PageHandler_ToggleVideoConferenceTray_ParamsSpec.$, null, impl.toggleVideoConferenceTray.bind(impl), false);
        this.helper_internal_.registerHandler(6, PageHandler_ToggleAnnotationTray_ParamsSpec.$, null, impl.toggleAnnotationTray.bind(impl), false);
        this.helper_internal_.registerHandler(7, PageHandler_SetIsInUserChildSession_ParamsSpec.$, null, impl.setIsInUserChildSession.bind(impl), false);
        this.helper_internal_.registerHandler(8, PageHandler_TriggerPrivacyIndicators_ParamsSpec.$, null, impl.triggerPrivacyIndicators.bind(impl), false);
        this.helper_internal_.registerHandler(9, PageHandler_ResetHmrConsentStatus_ParamsSpec.$, null, impl.resetHmrConsentStatus.bind(impl), false);
        this.helper_internal_.registerHandler(10, PageHandler_SetBatteryIcon_ParamsSpec.$, null, impl.setBatteryIcon.bind(impl), false);
        this.helper_internal_.registerHandler(11, PageHandler_SetBatteryPercent_ParamsSpec.$, null, impl.setBatteryPercent.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandler {
    static get $interfaceName() {
        return "ash.mojom.status_area_internals.PageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
export const PageHandler_BatteryIconSpec = { $: mojo.internal.Enum() };
export var PageHandler_BatteryIcon;
(function (PageHandler_BatteryIcon) {
    PageHandler_BatteryIcon[PageHandler_BatteryIcon["MIN_VALUE"] = 0] = "MIN_VALUE";
    PageHandler_BatteryIcon[PageHandler_BatteryIcon["MAX_VALUE"] = 4] = "MAX_VALUE";
    PageHandler_BatteryIcon[PageHandler_BatteryIcon["kDefault"] = 0] = "kDefault";
    PageHandler_BatteryIcon[PageHandler_BatteryIcon["kXIcon"] = 1] = "kXIcon";
    PageHandler_BatteryIcon[PageHandler_BatteryIcon["kUnreliableIcon"] = 2] = "kUnreliableIcon";
    PageHandler_BatteryIcon[PageHandler_BatteryIcon["kBoltIcon"] = 3] = "kBoltIcon";
    PageHandler_BatteryIcon[PageHandler_BatteryIcon["kBatterySaverPlusIcon"] = 4] = "kBatterySaverPlusIcon";
})(PageHandler_BatteryIcon || (PageHandler_BatteryIcon = {}));
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.toggleImeTray =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandler_ToggleImeTray_ParamsSpec.$, null, this.toggleImeTray.createReceiverHandler(false /* expectsResponse */), false);
        this.togglePaletteTray =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageHandler_TogglePaletteTray_ParamsSpec.$, null, this.togglePaletteTray.createReceiverHandler(false /* expectsResponse */), false);
        this.toggleLogoutTray =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, PageHandler_ToggleLogoutTray_ParamsSpec.$, null, this.toggleLogoutTray.createReceiverHandler(false /* expectsResponse */), false);
        this.toggleVirtualKeyboardTray =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, PageHandler_ToggleVirtualKeyboardTray_ParamsSpec.$, null, this.toggleVirtualKeyboardTray.createReceiverHandler(false /* expectsResponse */), false);
        this.toggleDictationTray =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, PageHandler_ToggleDictationTray_ParamsSpec.$, null, this.toggleDictationTray.createReceiverHandler(false /* expectsResponse */), false);
        this.toggleVideoConferenceTray =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, PageHandler_ToggleVideoConferenceTray_ParamsSpec.$, null, this.toggleVideoConferenceTray.createReceiverHandler(false /* expectsResponse */), false);
        this.toggleAnnotationTray =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, PageHandler_ToggleAnnotationTray_ParamsSpec.$, null, this.toggleAnnotationTray.createReceiverHandler(false /* expectsResponse */), false);
        this.setIsInUserChildSession =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, PageHandler_SetIsInUserChildSession_ParamsSpec.$, null, this.setIsInUserChildSession.createReceiverHandler(false /* expectsResponse */), false);
        this.triggerPrivacyIndicators =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, PageHandler_TriggerPrivacyIndicators_ParamsSpec.$, null, this.triggerPrivacyIndicators.createReceiverHandler(false /* expectsResponse */), false);
        this.resetHmrConsentStatus =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, PageHandler_ResetHmrConsentStatus_ParamsSpec.$, null, this.resetHmrConsentStatus.createReceiverHandler(false /* expectsResponse */), false);
        this.setBatteryIcon =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, PageHandler_SetBatteryIcon_ParamsSpec.$, null, this.setBatteryIcon.createReceiverHandler(false /* expectsResponse */), false);
        this.setBatteryPercent =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, PageHandler_SetBatteryPercent_ParamsSpec.$, null, this.setBatteryPercent.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const PageHandler_ToggleImeTray_ParamsSpec = { $: {} };
export const PageHandler_TogglePaletteTray_ParamsSpec = { $: {} };
export const PageHandler_ToggleLogoutTray_ParamsSpec = { $: {} };
export const PageHandler_ToggleVirtualKeyboardTray_ParamsSpec = { $: {} };
export const PageHandler_ToggleDictationTray_ParamsSpec = { $: {} };
export const PageHandler_ToggleVideoConferenceTray_ParamsSpec = { $: {} };
export const PageHandler_ToggleAnnotationTray_ParamsSpec = { $: {} };
export const PageHandler_SetIsInUserChildSession_ParamsSpec = { $: {} };
export const PageHandler_TriggerPrivacyIndicators_ParamsSpec = { $: {} };
export const PageHandler_ResetHmrConsentStatus_ParamsSpec = { $: {} };
export const PageHandler_SetBatteryIcon_ParamsSpec = { $: {} };
export const PageHandler_SetBatteryPercent_ParamsSpec = { $: {} };
mojo.internal.Struct(PageHandler_ToggleImeTray_ParamsSpec.$, 'PageHandler_ToggleImeTray_Params', [
    mojo.internal.StructField('visible', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_TogglePaletteTray_ParamsSpec.$, 'PageHandler_TogglePaletteTray_Params', [
    mojo.internal.StructField('visible', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_ToggleLogoutTray_ParamsSpec.$, 'PageHandler_ToggleLogoutTray_Params', [
    mojo.internal.StructField('visible', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_ToggleVirtualKeyboardTray_ParamsSpec.$, 'PageHandler_ToggleVirtualKeyboardTray_Params', [
    mojo.internal.StructField('visible', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_ToggleDictationTray_ParamsSpec.$, 'PageHandler_ToggleDictationTray_Params', [
    mojo.internal.StructField('visible', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_ToggleVideoConferenceTray_ParamsSpec.$, 'PageHandler_ToggleVideoConferenceTray_Params', [
    mojo.internal.StructField('visible', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_ToggleAnnotationTray_ParamsSpec.$, 'PageHandler_ToggleAnnotationTray_Params', [
    mojo.internal.StructField('visible', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_SetIsInUserChildSession_ParamsSpec.$, 'PageHandler_SetIsInUserChildSession_Params', [
    mojo.internal.StructField('inChildSession', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_TriggerPrivacyIndicators_ParamsSpec.$, 'PageHandler_TriggerPrivacyIndicators_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('appName', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isCameraUsed', 16, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isMicrophoneUsed', 16, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(PageHandler_ResetHmrConsentStatus_ParamsSpec.$, 'PageHandler_ResetHmrConsentStatus_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_SetBatteryIcon_ParamsSpec.$, 'PageHandler_SetBatteryIcon_Params', [
    mojo.internal.StructField('icon', 0, 0, PageHandler_BatteryIconSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_SetBatteryPercent_ParamsSpec.$, 'PageHandler_SetBatteryPercent_Params', [
    mojo.internal.StructField('percent', 0, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
