// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { ActorOverlayPageCallbackRouter, ActorOverlayPageHandlerFactory, ActorOverlayPageHandlerRemote } from './actor_overlay.mojom-webui.js';
export class ActorOverlayBrowserProxy {
    callbackRouter;
    handler;
    constructor() {
        this.callbackRouter = new ActorOverlayPageCallbackRouter();
        this.handler = new ActorOverlayPageHandlerRemote();
        ActorOverlayPageHandlerFactory.getRemote().createPageHandler(this.callbackRouter.$.bindNewPipeAndPassRemote(), this.handler
            .$.bindNewPipeAndPassReceiver());
    }
    static setInstance(proxy) {
        instance = proxy;
    }
    static getInstance() {
        return instance || (instance = new ActorOverlayBrowserProxy());
    }
}
let instance = null;
