// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import '/strings.m.js';
import { I18nMixin } from 'chrome://resources/ash/common/cr_elements/i18n_mixin.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { getTemplate } from './android_apps_list.html.js';
const AndroidAppsListElementBase = I18nMixin(PolymerElement);
export class AndroidAppsListElement extends AndroidAppsListElementBase {
    static get is() {
        return 'android-apps-list';
    }
    static get template() {
        return getTemplate();
    }
    static get properties() {
        return {
            apps: {
                type: (Array),
                value: [],
            },
        };
    }
    iconUrlFromId(app) {
        return `chrome://app-icon/${app.id}/64`;
    }
    hasApps(apps) {
        return apps.length > 0;
    }
    getDescription() {
        if (this.apps.length === 1) {
            return this.i18n('androidAppsListDescriptionSingular');
        }
        return this.i18n('androidAppsListDescriptionPlural', this.apps.length);
    }
}
customElements.define(AndroidAppsListElement.is, AndroidAppsListElement);
