// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/polymer/v3_0/paper-spinner/paper-spinner-lite.js";import"chrome://resources/ash/common/cr_elements/cr_button/cr_button.js";import"chrome://resources/ash/common/cr_elements/icons.html.js";import"chrome://resources/polymer/v3_0/iron-icon/iron-icon.js";import"chrome://resources/ash/common/cr_elements/cr_view_manager/cr_view_manager.js";import"chrome://chrome-signin/gaia_action_buttons/gaia_action_buttons.js";import"./signin_blocked_by_policy_page.js";import"./signin_error_page.js";import"./welcome_page_app.js";import"/strings.m.js";import{Authenticator}from"chrome://chrome-signin/gaia_auth_host/authenticator.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{WebUiListenerMixin}from"chrome://resources/ash/common/cr_elements/web_ui_listener_mixin.js";import{assert}from"chrome://resources/js/assert.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{isRTL}from"chrome://resources/js/util.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./inline_login_app.html.js";import{InlineLoginBrowserProxyImpl}from"./inline_login_browser_proxy.js";export var View;(function(View){View["ADD_ACCOUNT"]="addAccount";View["SIGNIN_BLOCKED_BY_POLICY"]="signinBlockedByPolicy";View["SIGNIN_ERROR"]="signinError";View["WELCOME"]="welcome"})(View||(View={}));const InlineLoginAppElementBase=WebUiListenerMixin(I18nMixin(PolymerElement));export class InlineLoginAppElement extends InlineLoginAppElementBase{constructor(){super(...arguments);this.isLoginPrimaryAccount_=false;this.browserProxy_=InlineLoginBrowserProxyImpl.getInstance()}static get is(){return"inline-login-app"}static get template(){return getTemplate()}static get properties(){return{viewEnum_:{type:Object,value:View},loading_:{type:Boolean,value:true},verifyingAccount_:{type:Boolean,value:false},authenticator_:{type:Object,value:null},shouldSkipWelcomePage_:{type:Boolean,value(){return loadTimeData.getBoolean("shouldSkipWelcomePage")},readOnly:true},isReauthentication_:{type:Boolean,value:false},email_:{type:String,value:""},hostedDomain_:{type:String,value:""},isSecondaryGoogleAccountSigninAllowed_:{type:Boolean,value(){return loadTimeData.getBoolean("secondaryGoogleAccountSigninAllowed")}},currentView_:{type:String,value:""}}}ready(){super.ready();if(!this.isSecondaryGoogleAccountSigninAllowed_){console.warn("SecondaryGoogleAccountSigninAllowed is set to false - aborting.");return}this.authenticator_=new Authenticator(this.$.signinFrame);this.addAuthenticatorListeners_();this.browserProxy_.initialize()}connectedCallback(){super.connectedCallback();this.addWebUiListener("load-authenticator",(data=>this.loadAuthenticator_(data)));this.addWebUiListener("close-dialog",(()=>this.closeDialog_()));this.addWebUiListener("show-signin-error-page",(data=>this.signinErrorShowView_(data)))}addAuthenticatorListeners_(){assert(this.authenticator_);this.authenticator_.addEventListener("dropLink",(e=>this.onDropLink_(e)));this.authenticator_.addEventListener("newWindow",(e=>this.onNewWindow_(e)));this.authenticator_.addEventListener("ready",(()=>this.onAuthReady_()));this.authenticator_.addEventListener("resize",(e=>this.onResize_(e)));this.authenticator_.addEventListener("authCompleted",(e=>this.onAuthCompleted_(e)));this.authenticator_.addEventListener("showIncognito",(()=>this.onShowIncognito_()));this.authenticator_.addEventListener("getAccounts",(()=>this.onGetAccounts_()));this.authenticator_.addEventListener("getDeviceId",(()=>this.onGetDeviceId_()))}onDropLink_(e){window.location.href=e.detail}onNewWindow_(e){window.open(e.detail.targetUrl,"_blank");e.detail.window.discard();this.closeDialog_()}onAuthReady_(){this.loading_=false;if(this.isLoginPrimaryAccount_){this.browserProxy_.recordAction("Signin_SigninPage_Shown")}this.browserProxy_.authenticatorReady()}onResize_(e){this.browserProxy_.switchToFullTab(e.detail)}onAuthCompleted_(e){this.verifyingAccount_=true;const credentials=e.detail;this.browserProxy_.completeLogin(credentials)}onShowIncognito_(){this.browserProxy_.showIncognito()}onGetAccounts_(){this.browserProxy_.getAccounts().then((result=>{assert(this.authenticator_);this.authenticator_.getAccountsResponse(result)}))}onGetDeviceId_(){this.browserProxy_.getDeviceId().then((deviceId=>{assert(this.authenticator_);this.authenticator_.getDeviceIdResponse(deviceId)}))}loadAuthenticator_(data){assert(this.authenticator_);this.authenticator_.load(data.authMode,data);this.loading_=true;this.isLoginPrimaryAccount_=data.isLoginPrimaryAccount;if(data.email){this.isReauthentication_=true}this.switchToDefaultView_()}isSpinnerActive_(loading,verifyingAccount){return loading||verifyingAccount}closeDialog_(){this.browserProxy_.dialogClose()}handleGoBack_(){if(this.$.signinFrame.canGoBack()){this.$.signinFrame.back();this.$.signinFrame.focus()}else if(this.isWelcomePageEnabled_()){this.switchView_(View.WELCOME)}else{this.closeDialog_()}}getBackButtonIcon_(){return isRTL()?"cr:chevron-right":"cr:chevron-left"}shouldShowBackButton_(currentView,verifyingAccount){return currentView===View.ADD_ACCOUNT&&!verifyingAccount}shouldShowOkButton_(){return this.currentView_===View.WELCOME||this.currentView_===View.SIGNIN_BLOCKED_BY_POLICY||this.currentView_===View.SIGNIN_ERROR}shouldShowGaiaButtons_(){return this.currentView_===View.ADD_ACCOUNT}switchToDefaultView_(){const view=this.getDefaultView_();this.switchView_(view)}getDefaultView_(){if(this.isReauthentication_){return View.ADD_ACCOUNT}return this.shouldSkipWelcomePage_?View.ADD_ACCOUNT:View.WELCOME}switchView_(id,enterAnimation="fade-in",exitAnimation="fade-out"){this.currentView_=id;this.$.viewManager.switchView(id,enterAnimation,exitAnimation);this.dispatchEvent(new CustomEvent("switch-view-notify-for-testing"))}isWelcomePageEnabled_(){return!this.shouldSkipWelcomePage_&&!this.isReauthentication_}signinErrorShowView_(data){this.verifyingAccount_=false;if(data.signinBlockedByPolicy){this.set("email_",data.email);this.set("hostedDomain_",data.hostedDomain);this.set("deviceType_",data.deviceType);this.switchView_(View.SIGNIN_BLOCKED_BY_POLICY,"no-animation","no-animation")}else{this.switchView_(View.SIGNIN_ERROR,"no-animation","no-animation")}this.setFocusToWebview_()}onOkButtonClick_(){switch(this.currentView_){case View.WELCOME:this.switchView_(View.ADD_ACCOUNT);const welcomePageApp=this.shadowRoot.querySelector("welcome-page-app");assert(welcomePageApp);const skipChecked=welcomePageApp.isSkipCheckboxChecked();this.browserProxy_.skipWelcomePage(skipChecked);this.setFocusToWebview_();break;case View.SIGNIN_BLOCKED_BY_POLICY:case View.SIGNIN_ERROR:this.closeDialog_();break}}setFocusToWebview_(){this.$.signinFrame.focus()}setAuthenticatorForTest(authenticator){this.authenticator_=authenticator;this.addAuthenticatorListeners_()}}customElements.define(InlineLoginAppElement.is,InlineLoginAppElement);