// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import 'chrome://resources/ash/common/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/ash/common/cr_elements/cr_checkbox/cr_checkbox.js';
import 'chrome://resources/ash/common/cr_elements/cr_toggle/cr_toggle.js';
import 'chrome://chrome-signin/account_manager_shared.css.js';
import { loadTimeData } from 'chrome://resources/js/load_time_data.js';
import { sanitizeInnerHtml } from 'chrome://resources/js/parse_html_subset.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { InlineLoginBrowserProxyImpl } from './inline_login_browser_proxy.js';
import { getTemplate } from './welcome_page_app.html.js';
export class WelcomePageAppElement extends PolymerElement {
    static get is() {
        return 'welcome-page-app';
    }
    static get template() {
        return getTemplate();
    }
    ready() {
        super.ready();
        this.setUpLinkCallbacks_();
    }
    isSkipCheckboxChecked() {
        return !!this.$.checkbox && this.$.checkbox.checked;
    }
    setUpLinkCallbacks_() {
        [this.shadowRoot.querySelector('#osSettingsLink'),
            this.shadowRoot.querySelector('#appsSettingsLink'),
            this.shadowRoot.querySelector('#newPersonLink')]
            .filter(link => !!link)
            .forEach(link => {
            const handleClick = () => this.dispatchEvent(new CustomEvent('opened-new-window'));
            link.addEventListener('click', handleClick);
            link.addEventListener('auxclick', 
            // For middle-click, do the same things as Ctrl+click
            ((event) => {
                if (event.button === 1) {
                    handleClick();
                }
            }));
        });
        const incognitoLink = this.shadowRoot.querySelector('#incognitoLink');
        if (incognitoLink) {
            const handleClick = (event) => {
                event.preventDefault();
                this.openIncognitoLink_();
            };
            incognitoLink.addEventListener('click', handleClick);
            incognitoLink.addEventListener('auxclick', 
            // For middle-click, do the same things as Ctrl+click
            ((event) => {
                if (event.button === 1) {
                    handleClick(event);
                }
            }));
        }
    }
    getWelcomeTitle_() {
        return loadTimeData.getStringF('accountManagerDialogWelcomeTitle', loadTimeData.getString('userName'));
    }
    getWelcomeBody_() {
        const welcomeBodyKey = 'accountManagerDialogWelcomeBody';
        return sanitizeInnerHtml(loadTimeData.getString(welcomeBodyKey), {
            attrs: ['id'],
        });
    }
    openIncognitoLink_() {
        InlineLoginBrowserProxyImpl.getInstance().showIncognito();
        // `showIncognito` will close the dialog.
    }
    openGuestLink_() {
        InlineLoginBrowserProxyImpl.getInstance().openGuestWindow();
        // `openGuestWindow` will close the dialog.
    }
}
customElements.define(WelcomePageAppElement.is, WelcomePageAppElement);
