import{css,CrLitElement,html,nothing}from"chrome://resources/lit/v3_0/lit.rollup.js";import{sendWithPromise,addWebUiListener,removeWebUiListener}from"chrome://resources/js/cr.js";import"chrome://print/strings.m.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{PolymerElement,dedupingMixin,html as html$1,Debouncer,timeOut,templatize,useShadow,dom,Polymer,Templatizer,OptionalMutableDataBehavior,animationFrame,microTask,idlePeriod,flush,enqueueDebouncer,matches as matches$1,translate,calculateSplices,gestures,beforeNextRender}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{pdfCreateOutOfProcessPlugin}from"chrome://print/pdf/pdf_scripting_api.js";
// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CLASS_NAME="focus-outline-visible";const docsToManager=new Map;class FocusOutlineManager{focusByKeyboard_=true;classList_;constructor(doc){this.classList_=doc.documentElement.classList;doc.addEventListener("keydown",(e=>this.onEvent_(true,e)),true);doc.addEventListener("mousedown",(e=>this.onEvent_(false,e)),true);this.updateVisibility()}onEvent_(focusByKeyboard,e){if(this.focusByKeyboard_===focusByKeyboard){return}if(e instanceof KeyboardEvent&&e.repeat){return}this.focusByKeyboard_=focusByKeyboard;this.updateVisibility()}updateVisibility(){this.visible=this.focusByKeyboard_}set visible(visible){this.classList_.toggle(CLASS_NAME,visible)}get visible(){return this.classList_.contains(CLASS_NAME)}static forDocument(doc){let manager=docsToManager.get(doc);if(!manager){manager=new FocusOutlineManager(doc);docsToManager.set(doc,manager)}return manager}}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function assert(value,message){if(value){return}throw new Error("Assertion failed"+(message?`: ${message}`:""))}function assertNotReached(message="Unreachable code hit"){assert(false,message)}
// Copyright 2011 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class EventTracker{listeners_=[];add(target,eventType,listener,capture=false){const h={target:target,eventType:eventType,listener:listener,capture:capture};this.listeners_.push(h);target.addEventListener(eventType,listener,capture)}remove(target,eventType){this.listeners_=this.listeners_.filter((listener=>{if(listener.target===target&&(!eventType||listener.eventType===eventType)){EventTracker.removeEventListener(listener);return false}return true}))}removeAll(){this.listeners_.forEach((listener=>EventTracker.removeEventListener(listener)));this.listeners_=[]}static removeEventListener(entry){entry.target.removeEventListener(entry.eventType,entry.listener,entry.capture)}}let instance$k=null;function getCss$f(){return instance$k||(instance$k=[...[],css`:host{bottom:0;display:block;left:0;overflow:hidden;pointer-events:none;position:absolute;right:0;top:0;transform:translate3d(0,0,0)}.ripple{background-color:currentcolor;left:0;opacity:var(--paper-ripple-opacity,0.25);pointer-events:none;position:absolute;will-change:height,transform,width}.ripple,:host(.circle){border-radius:50%}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const MAX_RADIUS_PX=300;const MIN_DURATION_MS=800;function distance(x1,y1,x2,y2){const xDelta=x1-x2;const yDelta=y1-y2;return Math.sqrt(xDelta*xDelta+yDelta*yDelta)}class CrRippleElement extends CrLitElement{static get is(){return"cr-ripple"}static get styles(){return getCss$f()}static get properties(){return{holdDown:{type:Boolean},recenters:{type:Boolean},noink:{type:Boolean}}}#holdDown_accessor_storage=false;get holdDown(){return this.#holdDown_accessor_storage}set holdDown(value){this.#holdDown_accessor_storage=value}#recenters_accessor_storage=false;get recenters(){return this.#recenters_accessor_storage}set recenters(value){this.#recenters_accessor_storage=value}#noink_accessor_storage=false;get noink(){return this.#noink_accessor_storage}set noink(value){this.#noink_accessor_storage=value}ripples_=[];eventTracker_=new EventTracker;connectedCallback(){super.connectedCallback();assert(this.parentNode);const keyEventTarget=this.parentNode.nodeType===Node.DOCUMENT_FRAGMENT_NODE?this.parentNode.host:this.parentElement;this.eventTracker_.add(keyEventTarget,"pointerdown",(e=>this.uiDownAction(e)));this.eventTracker_.add(keyEventTarget,"pointerup",(()=>this.uiUpAction()));this.eventTracker_.add(keyEventTarget,"pointerout",(()=>this.uiUpAction()));this.eventTracker_.add(keyEventTarget,"keydown",(e=>{if(e.defaultPrevented){return}if(e.key==="Enter"){this.onEnterKeydown_();return}if(e.key===" "){this.onSpaceKeydown_()}}));this.eventTracker_.add(keyEventTarget,"keyup",(e=>{if(e.defaultPrevented){return}if(e.key===" "){this.onSpaceKeyup_()}}))}disconnectedCallback(){super.disconnectedCallback();this.eventTracker_.removeAll()}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("holdDown")){this.holdDownChanged_(this.holdDown,changedProperties.get("holdDown"))}}uiDownAction(e){if(e!==undefined&&e.button!==0){return}if(!this.noink){this.downAction_(e)}}downAction_(e){if(this.ripples_.length&&this.holdDown){return}this.showRipple_(e)}clear(){this.hideRipple_();this.holdDown=false}showAndHoldDown(){this.ripples_.forEach((ripple=>{ripple.remove()}));this.ripples_=[];this.holdDown=true}showRipple_(e){const rect=this.getBoundingClientRect();const roundedCenterX=function(){return Math.round(rect.width/2)};const roundedCenterY=function(){return Math.round(rect.height/2)};let x=0;let y=0;const centered=!e;if(centered){x=roundedCenterX();y=roundedCenterY()}else{x=Math.round(e.clientX-rect.left);y=Math.round(e.clientY-rect.top)}const corners=[{x:0,y:0},{x:rect.width,y:0},{x:0,y:rect.height},{x:rect.width,y:rect.height}];const cornerDistances=corners.map((function(corner){return Math.round(distance(x,y,corner.x,corner.y))}));const radius=Math.min(MAX_RADIUS_PX,Math.max.apply(Math,cornerDistances));const startTranslate=`${x-radius}px, ${y-radius}px`;let endTranslate=startTranslate;if(this.recenters&&!centered){endTranslate=`${roundedCenterX()-radius}px, ${roundedCenterY()-radius}px`}const ripple=document.createElement("div");ripple.classList.add("ripple");ripple.style.height=ripple.style.width=2*radius+"px";this.ripples_.push(ripple);this.shadowRoot.appendChild(ripple);ripple.animate({transform:[`translate(${startTranslate}) scale(0)`,`translate(${endTranslate}) scale(1)`]},{duration:Math.max(MIN_DURATION_MS,Math.log(radius)*radius)||0,easing:"cubic-bezier(.2, .9, .1, .9)",fill:"forwards"})}uiUpAction(){if(!this.noink){this.upAction_()}}upAction_(){if(!this.holdDown){this.hideRipple_()}}hideRipple_(){if(this.ripples_.length===0){return}this.ripples_.forEach((function(ripple){const opacity=ripple.computedStyleMap().get("opacity");if(opacity===null){ripple.remove();return}const animation=ripple.animate({opacity:[opacity.value,0]},{duration:150,fill:"forwards"});animation.finished.then((()=>{ripple.remove()}))}));this.ripples_=[]}onEnterKeydown_(){this.uiDownAction();window.setTimeout((()=>{this.uiUpAction()}),1)}onSpaceKeydown_(){this.uiDownAction()}onSpaceKeyup_(){this.uiUpAction()}holdDownChanged_(newHoldDown,oldHoldDown){if(oldHoldDown===undefined){return}if(newHoldDown){this.downAction_()}else{this.upAction_()}}}customElements.define(CrRippleElement.is,CrRippleElement);
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CrRippleMixin=superClass=>{class CrRippleMixin extends superClass{static get properties(){return{noink:{type:Boolean}}}#noink_accessor_storage=false;get noink(){return this.#noink_accessor_storage}set noink(value){this.#noink_accessor_storage=value}rippleContainer=null;ripple_=null;updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("noink")&&this.hasRipple()){assert(this.ripple_);this.ripple_.noink=this.noink}}ensureRippleOnPointerdown(){this.addEventListener("pointerdown",(()=>this.ensureRipple()),{capture:true})}ensureRipple(){if(this.hasRipple()){return}this.ripple_=this.createRipple();this.ripple_.noink=this.noink;const rippleContainer=this.rippleContainer||this.shadowRoot;assert(rippleContainer);rippleContainer.appendChild(this.ripple_)}getRipple(){this.ensureRipple();assert(this.ripple_);return this.ripple_}hasRipple(){return Boolean(this.ripple_)}createRipple(){const ripple=document.createElement("cr-ripple");ripple.id="ink";return ripple}}return CrRippleMixin};let instance$j=null;function getCss$e(){return instance$j||(instance$j=[...[],css`[hidden],:host([hidden]){display:none !important}`])}const sheet$1=new CSSStyleSheet;sheet$1.replaceSync(`html{--google-blue-50-rgb:232,240,254;--google-blue-50:rgb(var(--google-blue-50-rgb));--google-blue-100-rgb:210,227,252;--google-blue-100:rgb(var(--google-blue-100-rgb));--google-blue-200-rgb:174,203,250;--google-blue-200:rgb(var(--google-blue-200-rgb));--google-blue-300-rgb:138,180,248;--google-blue-300:rgb(var(--google-blue-300-rgb));--google-blue-400-rgb:102,157,246;--google-blue-400:rgb(var(--google-blue-400-rgb));--google-blue-500-rgb:66,133,244;--google-blue-500:rgb(var(--google-blue-500-rgb));--google-blue-600-rgb:26,115,232;--google-blue-600:rgb(var(--google-blue-600-rgb));--google-blue-700-rgb:25,103,210;--google-blue-700:rgb(var(--google-blue-700-rgb));--google-blue-800-rgb:24,90,188;--google-blue-800:rgb(var(--google-blue-800-rgb));--google-blue-900-rgb:23,78,166;--google-blue-900:rgb(var(--google-blue-900-rgb));--google-green-50-rgb:230,244,234;--google-green-50:rgb(var(--google-green-50-rgb));--google-green-200-rgb:168,218,181;--google-green-200:rgb(var(--google-green-200-rgb));--google-green-300-rgb:129,201,149;--google-green-300:rgb(var(--google-green-300-rgb));--google-green-400-rgb:91,185,116;--google-green-400:rgb(var(--google-green-400-rgb));--google-green-500-rgb:52,168,83;--google-green-500:rgb(var(--google-green-500-rgb));--google-green-600-rgb:30,142,62;--google-green-600:rgb(var(--google-green-600-rgb));--google-green-700-rgb:24,128,56;--google-green-700:rgb(var(--google-green-700-rgb));--google-green-800-rgb:19,115,51;--google-green-800:rgb(var(--google-green-800-rgb));--google-green-900-rgb:13,101,45;--google-green-900:rgb(var(--google-green-900-rgb));--google-grey-50-rgb:248,249,250;--google-grey-50:rgb(var(--google-grey-50-rgb));--google-grey-100-rgb:241,243,244;--google-grey-100:rgb(var(--google-grey-100-rgb));--google-grey-200-rgb:232,234,237;--google-grey-200:rgb(var(--google-grey-200-rgb));--google-grey-300-rgb:218,220,224;--google-grey-300:rgb(var(--google-grey-300-rgb));--google-grey-400-rgb:189,193,198;--google-grey-400:rgb(var(--google-grey-400-rgb));--google-grey-500-rgb:154,160,166;--google-grey-500:rgb(var(--google-grey-500-rgb));--google-grey-600-rgb:128,134,139;--google-grey-600:rgb(var(--google-grey-600-rgb));--google-grey-700-rgb:95,99,104;--google-grey-700:rgb(var(--google-grey-700-rgb));--google-grey-800-rgb:60,64,67;--google-grey-800:rgb(var(--google-grey-800-rgb));--google-grey-900-rgb:32,33,36;--google-grey-900:rgb(var(--google-grey-900-rgb));--google-grey-900-white-4-percent:#292a2d;--google-purple-200-rgb:215,174,251;--google-purple-200:rgb(var(--google-purple-200-rgb));--google-purple-900-rgb:104,29,168;--google-purple-900:rgb(var(--google-purple-900-rgb));--google-red-100-rgb:244,199,195;--google-red-100:rgb(var(--google-red-100-rgb));--google-red-300-rgb:242,139,130;--google-red-300:rgb(var(--google-red-300-rgb));--google-red-500-rgb:234,67,53;--google-red-500:rgb(var(--google-red-500-rgb));--google-red-600-rgb:217,48,37;--google-red-600:rgb(var(--google-red-600-rgb));--google-red-700-rgb:197,57,41;--google-red-700:rgb(var(--google-red-700-rgb));--google-yellow-50-rgb:254,247,224;--google-yellow-50:rgb(var(--google-yellow-50-rgb));--google-yellow-100-rgb:254,239,195;--google-yellow-100:rgb(var(--google-yellow-100-rgb));--google-yellow-200-rgb:253,226,147;--google-yellow-200:rgb(var(--google-yellow-200-rgb));--google-yellow-300-rgb:253,214,51;--google-yellow-300:rgb(var(--google-yellow-300-rgb));--google-yellow-400-rgb:252,201,52;--google-yellow-400:rgb(var(--google-yellow-400-rgb));--google-yellow-500-rgb:251,188,4;--google-yellow-500:rgb(var(--google-yellow-500-rgb));--google-yellow-700-rgb:240,147,0;--google-yellow-700:rgb(var(--google-yellow-700-rgb));--cr-card-background-color:white;--cr-shadow-key-color_:color-mix(in srgb,var(--cr-shadow-color) 30%,transparent);--cr-shadow-ambient-color_:color-mix(in srgb,var(--cr-shadow-color) 15%,transparent);--cr-elevation-1:var(--cr-shadow-key-color_) 0 1px 2px 0,var(--cr-shadow-ambient-color_) 0 1px 3px 1px;--cr-elevation-2:var(--cr-shadow-key-color_) 0 1px 2px 0,var(--cr-shadow-ambient-color_) 0 2px 6px 2px;--cr-elevation-3:var(--cr-shadow-key-color_) 0 1px 3px 0,var(--cr-shadow-ambient-color_) 0 4px 8px 3px;--cr-elevation-4:var(--cr-shadow-key-color_) 0 2px 3px 0,var(--cr-shadow-ambient-color_) 0 6px 10px 4px;--cr-elevation-5:var(--cr-shadow-key-color_) 0 4px 4px 0,var(--cr-shadow-ambient-color_) 0 8px 12px 6px;--cr-card-shadow:var(--cr-elevation-2);--cr-focused-item-color:var(--google-grey-300);--cr-form-field-label-color:var(--google-grey-700);--cr-hairline-rgb:0,0,0;--cr-iph-anchor-highlight-color:rgba(var(--google-blue-600-rgb),0.1);--cr-menu-background-color:white;--cr-menu-background-focus-color:var(--google-grey-400);--cr-menu-shadow:var(--cr-elevation-2);--cr-separator-color:rgba(0,0,0,.06);--cr-title-text-color:rgb(90,90,90);--cr-scrollable-border-color:var(--google-grey-300)}@media (prefers-color-scheme:dark){html{--cr-card-background-color:var(--google-grey-900-white-4-percent);--cr-focused-item-color:var(--google-grey-800);--cr-form-field-label-color:var(--dark-secondary-color);--cr-hairline-rgb:255,255,255;--cr-iph-anchor-highlight-color:rgba(var(--google-grey-100-rgb),0.1);--cr-menu-background-color:var(--google-grey-900);--cr-menu-background-focus-color:var(--google-grey-700);--cr-menu-background-sheen:rgba(255,255,255,.06);--cr-menu-shadow:rgba(0,0,0,.3) 0 1px 2px 0,rgba(0,0,0,.15) 0 3px 6px 2px;--cr-separator-color:rgba(255,255,255,.1);--cr-title-text-color:var(--cr-primary-text-color);--cr-scrollable-border-color:var(--google-grey-700)}}@media (forced-colors:active){html{--cr-focus-outline-hcm:2px solid transparent;--cr-border-hcm:2px solid transparent}}html{--cr-button-edge-spacing:12px;--cr-controlled-by-spacing:24px;--cr-default-input-max-width:264px;--cr-icon-ripple-size:36px;--cr-icon-ripple-padding:8px;--cr-icon-size:20px;--cr-icon-button-margin-start:16px;--cr-icon-ripple-margin:calc(var(--cr-icon-ripple-padding) * -1);--cr-section-min-height:48px;--cr-section-two-line-min-height:64px;--cr-section-padding:20px;--cr-section-vertical-padding:12px;--cr-section-indent-width:40px;--cr-section-indent-padding:calc(var(--cr-section-padding) + var(--cr-section-indent-width));--cr-section-vertical-margin:21px;--cr-centered-card-max-width:680px;--cr-centered-card-width-percentage:0.96;--cr-hairline:1px solid rgba(var(--cr-hairline-rgb),.14);--cr-separator-height:1px;--cr-separator-line:var(--cr-separator-height) solid var(--cr-separator-color);--cr-toolbar-overlay-animation-duration:150ms;--cr-toolbar-height:56px;--cr-container-shadow-height:6px;--cr-container-shadow-margin:calc(-1 * var(--cr-container-shadow-height));--cr-container-shadow-max-opacity:1;--cr-card-border-radius:8px;--cr-disabled-opacity:.38;--cr-form-field-bottom-spacing:16px;--cr-form-field-label-font-size:.625rem;--cr-form-field-label-height:1em;--cr-form-field-label-line-height:1}html{--cr-fallback-color-outline:rgb(116,119,117);--cr-fallback-color-primary:rgb(11,87,208);--cr-fallback-color-on-primary:rgb(255,255,255);--cr-fallback-color-primary-container:rgb(211,227,253);--cr-fallback-color-on-primary-container:rgb(4,30,73);--cr-fallback-color-secondary-container:rgb(194,231,255);--cr-fallback-color-on-secondary-container:rgb(0,29,53);--cr-fallback-color-neutral-container:rgb(242,242,242);--cr-fallback-color-neutral-outline:rgb(199,199,199);--cr-fallback-color-surface:rgb(255,255,255);--cr-fallback-color-surface1:rgb(248,250,253);--cr-fallback-color-surface2:rgb(243,246,252);--cr-fallback-color-surface3:rgb(239,243,250);--cr-fallback-color-on-surface-rgb:31,31,31;--cr-fallback-color-on-surface:rgb(var(--cr-fallback-color-on-surface-rgb));--cr-fallback-color-surface-variant:rgb(225,227,225);--cr-fallback-color-on-surface-variant:rgb(68,71,70);--cr-fallback-color-on-surface-subtle:rgb(71,71,71);--cr-fallback-color-inverse-primary:rgb(168,199,250);--cr-fallback-color-inverse-surface:rgb(48,48,48);--cr-fallback-color-inverse-on-surface:rgb(242,242,242);--cr-fallback-color-tonal-container:rgb(211,227,253);--cr-fallback-color-on-tonal-container:rgb(4,30,73);--cr-fallback-color-tonal-outline:rgb(168,199,250);--cr-fallback-color-error:rgb(179,38,30);--cr-fallback-color-divider:rgb(211,227,253);--cr-fallback-color-state-hover-on-prominent_:rgba(253,252,251,.1);--cr-fallback-color-state-on-subtle-rgb_:31,31,31;--cr-fallback-color-state-hover-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.06);--cr-fallback-color-state-ripple-neutral-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.08);--cr-fallback-color-state-ripple-primary-rgb_:124,172,248;--cr-fallback-color-state-ripple-primary_:rgba(var(--cr-fallback-color-state-ripple-primary-rgb_),0.32);--cr-fallback-color-base-container:rgb(236,239,247);--cr-fallback-color-disabled-background:rgba(var(--cr-fallback-color-on-surface-rgb),.12);--cr-fallback-color-disabled-foreground:rgba(var(--cr-fallback-color-on-surface-rgb),var(--cr-disabled-opacity));--cr-hover-background-color:var(--color-sys-state-hover,rgba(var(--cr-fallback-color-on-surface-rgb),.08));--cr-hover-on-prominent-background-color:var(--color-sys-state-hover-on-prominent,var(--cr-fallback-color-state-hover-on-prominent_));--cr-hover-on-subtle-background-color:var(--color-sys-state-hover-on-subtle,var(--cr-fallback-color-state-hover-on-subtle_));--cr-active-background-color:var(--color-sys-state-pressed,rgba(var(--cr-fallback-color-on-surface-rgb),.12));--cr-active-on-primary-background-color:var(--color-sys-state-ripple-primary,var(--cr-fallback-color-state-ripple-primary_));--cr-active-neutral-on-subtle-background-color:var(--color-sys-state-ripple-neutral-on-subtle,var(--cr-fallback-color-state-ripple-neutral-on-subtle_));--cr-focus-outline-color:var(--color-sys-state-focus-ring,var(--cr-fallback-color-primary));--cr-focus-outline-inverse-color:var(--color-sys-state-focus-ring-inverse,var(--cr-fallback-color-inverse-primary));--cr-primary-text-color:var(--color-primary-foreground,var(--cr-fallback-color-on-surface));--cr-secondary-text-color:var(--color-secondary-foreground,var(--cr-fallback-color-on-surface-variant));--cr-link-color:var(--color-link-foreground-default,var(--cr-fallback-color-primary));--cr-button-height:36px;--cr-shadow-color:var(--color-sys-shadow,rgb(0,0,0));--cr-checked-color:var(--color-checkbox-foreground-checked,var(--cr-fallback-color-primary))}@media (prefers-color-scheme:dark){html{--cr-fallback-color-outline:rgb(142,145,143);--cr-fallback-color-primary:rgb(168,199,250);--cr-fallback-color-on-primary:rgb(6,46,111);--cr-fallback-color-primary-container:rgb(8,66,160);--cr-fallback-color-on-primary-container:rgb(211,227,253);--cr-fallback-color-secondary-container:rgb(0,74,119);--cr-fallback-color-on-secondary-container:rgb(194,231,255);--cr-fallback-color-neutral-container:rgb(40,40,40);--cr-fallback-color-neutral-outline:rgb(117,117,117);--cr-fallback-color-surface:rgb(31,31,31);--cr-fallback-color-surface1:rgb(39,40,42);--cr-fallback-color-surface2:rgb(45,47,49);--cr-fallback-color-surface3:rgb(51,52,56);--cr-fallback-color-on-surface-rgb:227,227,227;--cr-fallback-color-surface-variant:rgb(68,71,70);--cr-fallback-color-on-surface-variant:rgb(196,199,197);--cr-fallback-color-on-surface-subtle:rgb(199,199,199);--cr-fallback-color-inverse-primary:rgb(11,87,208);--cr-fallback-color-inverse-surface:rgb(227,227,227);--cr-fallback-color-inverse-on-surface:rgb(31,31,31);--cr-fallback-color-tonal-container:rgb(0,74,119);--cr-fallback-color-on-tonal-container:rgb(194,231,255);--cr-fallback-color-tonal-outline:rgb(4,125,183);--cr-fallback-color-error:rgb(242,184,181);--cr-fallback-color-divider:rgb(94,94,94);--cr-fallback-color-state-hover-on-prominent_:rgba(31,31,31,.06);--cr-fallback-color-state-on-subtle-rgb_:253,252,251;--cr-fallback-color-state-hover-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.10);--cr-fallback-color-state-ripple-neutral-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.16);--cr-fallback-color-state-ripple-primary-rgb_:76,141,246;--cr-fallback-color-base-container:rgba(40,40,40,1)}}@media (forced-colors:active){html{--cr-fallback-color-disabled-background:Canvas;--cr-fallback-color-disabled-foreground:GrayText}}`);document.adoptedStyleSheets=[...document.adoptedStyleSheets,sheet$1];let instance$i=null;function getCss$d(){return instance$i||(instance$i=[...[getCss$e()],css`:host{--cr-button-background-color:transparent;--cr-button-border-color:var(--color-button-border,var(--cr-fallback-color-tonal-outline));--cr-button-text-color:var(--color-button-foreground,var(--cr-fallback-color-primary));--cr-button-ripple-opacity:1;--cr-button-ripple-color:var(--cr-active-background-color);--cr-button-disabled-background-color:transparent;--cr-button-disabled-border-color:var(--color-button-border-disabled,var(--cr-fallback-color-disabled-background));--cr-button-disabled-text-color:var(--color-button-foreground-disabled,var(--cr-fallback-color-disabled-foreground))}:host(.action-button){--cr-button-background-color:var(--color-button-background-prominent,var(--cr-fallback-color-primary));--cr-button-text-color:var(--color-button-foreground-prominent,var(--cr-fallback-color-on-primary));--cr-button-ripple-color:var(--cr-active-on-primary-background-color);--cr-button-border:none;--cr-button-disabled-background-color:var(--color-button-background-prominent-disabled,var(--cr-fallback-color-disabled-background));--cr-button-disabled-text-color:var(--color-button-foreground-disabled,var(--cr-fallback-color-disabled-foreground));--cr-button-disabled-border:none}:host(.tonal-button),:host(.floating-button){--cr-button-background-color:var(--color-button-background-tonal,var(--cr-fallback-color-secondary-container));--cr-button-text-color:var(--color-button-foreground-tonal,var(--cr-fallback-color-on-tonal-container));--cr-button-border:none;--cr-button-disabled-background-color:var(--color-button-background-tonal-disabled,var(--cr-fallback-color-disabled-background));--cr-button-disabled-text-color:var(--color-button-foreground-disabled,var(--cr-fallback-color-disabled-foreground));--cr-button-disabled-border:none}:host{flex-shrink:0;display:inline-flex;align-items:center;justify-content:center;box-sizing:border-box;min-width:5.14em;height:var(--cr-button-height);padding:8px 16px;outline-width:0;overflow:hidden;position:relative;cursor:pointer;user-select:none;-webkit-tap-highlight-color:transparent;border:var(--cr-button-border,1px solid var(--cr-button-border-color));border-radius:100px;background:var(--cr-button-background-color);color:var(--cr-button-text-color);font-weight:500;line-height:20px;isolation:isolate}@media (forced-colors:active){:host{forced-color-adjust:none}}:host(.floating-button){border-radius:8px;height:40px;transition:box-shadow 80ms linear}:host(.floating-button:hover){box-shadow:var(--cr-elevation-3)}:host([has-prefix-icon_]),:host([has-suffix-icon_]){--iron-icon-height:20px;--iron-icon-width:20px;--icon-block-padding-large:16px;--icon-block-padding-small:12px;gap:8px;padding-block-end:8px;padding-block-start:8px}:host([has-prefix-icon_]){padding-inline-end:var(--icon-block-padding-large);padding-inline-start:var(--icon-block-padding-small)}:host([has-suffix-icon_]){padding-inline-end:var(--icon-block-padding-small);padding-inline-start:var(--icon-block-padding-large)}:host-context(.focus-outline-visible):host(:focus){box-shadow:none;outline:2px solid var(--cr-focus-outline-color);outline-offset:2px}#background{border-radius:inherit;inset:0;pointer-events:none;position:absolute}#content{display:inline}#hoverBackground{content:'';display:none;inset:0;pointer-events:none;position:absolute;z-index:1}:host(:hover) #hoverBackground{background:var(--cr-hover-background-color);display:block}:host(.action-button:hover) #hoverBackground{background:var(--cr-hover-on-prominent-background-color)}:host([disabled]){background:var(--cr-button-disabled-background-color);border:var(--cr-button-disabled-border,1px solid var(--cr-button-disabled-border-color));color:var(--cr-button-disabled-text-color);cursor:auto;pointer-events:none}:host(.cancel-button){margin-inline-end:8px}:host(.action-button),:host(.cancel-button){line-height:154%}#ink{color:var(--cr-button-ripple-color);--paper-ripple-opacity:var(--cr-button-ripple-opacity)}#background{z-index:0}#hoverBackground,cr-ripple{z-index:1}#content,::slotted(*){z-index:2}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$7(){return html`
<div id="background"></div>
<slot id="prefixIcon" name="prefix-icon"
    @slotchange="${this.onPrefixIconSlotChanged_}">
</slot>
<span id="content"><slot></slot></span>
<slot id="suffixIcon" name="suffix-icon"
    @slotchange="${this.onSuffixIconSlotChanged_}">
</slot>
<div id="hoverBackground" part="hoverBackground"></div>`}
// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CrButtonElementBase=CrRippleMixin(CrLitElement);class CrButtonElement extends CrButtonElementBase{static get is(){return"cr-button"}static get styles(){return getCss$d()}render(){return getHtml$7.bind(this)()}static get properties(){return{disabled:{type:Boolean,reflect:true},hasPrefixIcon_:{type:Boolean,reflect:true},hasSuffixIcon_:{type:Boolean,reflect:true}}}#disabled_accessor_storage=false;get disabled(){return this.#disabled_accessor_storage}set disabled(value){this.#disabled_accessor_storage=value}#hasPrefixIcon__accessor_storage=false;get hasPrefixIcon_(){return this.#hasPrefixIcon__accessor_storage}set hasPrefixIcon_(value){this.#hasPrefixIcon__accessor_storage=value}#hasSuffixIcon__accessor_storage=false;get hasSuffixIcon_(){return this.#hasSuffixIcon__accessor_storage}set hasSuffixIcon_(value){this.#hasSuffixIcon__accessor_storage=value}spaceKeyDown_=false;timeoutIds_=new Set;constructor(){super();this.addEventListener("blur",this.onBlur_.bind(this));this.addEventListener("click",this.onClick_.bind(this));this.addEventListener("keydown",this.onKeyDown_.bind(this));this.addEventListener("keyup",this.onKeyUp_.bind(this));this.ensureRippleOnPointerdown()}firstUpdated(){if(!this.hasAttribute("role")){this.setAttribute("role","button")}if(!this.hasAttribute("tabindex")){this.setAttribute("tabindex","0")}FocusOutlineManager.forDocument(document)}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("disabled")){this.setAttribute("aria-disabled",this.disabled?"true":"false");this.disabledChanged_(this.disabled,changedProperties.get("disabled"))}}disconnectedCallback(){super.disconnectedCallback();this.timeoutIds_.forEach(clearTimeout);this.timeoutIds_.clear()}setTimeout_(fn,delay){if(!this.isConnected){return}const id=setTimeout((()=>{this.timeoutIds_.delete(id);fn()}),delay);this.timeoutIds_.add(id)}disabledChanged_(newValue,oldValue){if(!newValue&&oldValue===undefined){return}if(this.disabled){this.blur()}this.setAttribute("tabindex",String(this.disabled?-1:0))}onBlur_(){this.spaceKeyDown_=false;this.setTimeout_((()=>this.getRipple().uiUpAction()),100)}onClick_(e){if(this.disabled){e.stopImmediatePropagation()}}onPrefixIconSlotChanged_(){this.hasPrefixIcon_=this.$.prefixIcon.assignedElements().length>0}onSuffixIconSlotChanged_(){this.hasSuffixIcon_=this.$.suffixIcon.assignedElements().length>0}onKeyDown_(e){if(e.key!==" "&&e.key!=="Enter"){return}e.preventDefault();e.stopPropagation();if(e.repeat){return}this.getRipple().uiDownAction();if(e.key==="Enter"){this.click();this.setTimeout_((()=>this.getRipple().uiUpAction()),100)}else if(e.key===" "){this.spaceKeyDown_=true}}onKeyUp_(e){if(e.key!==" "&&e.key!=="Enter"){return}e.preventDefault();e.stopPropagation();if(this.spaceKeyDown_&&e.key===" "){this.spaceKeyDown_=false;this.click();this.getRipple().uiUpAction()}}}customElements.define(CrButtonElement.is,CrButtonElement);let instance$h=null;function getCss$c(){return instance$h||(instance$h=[...[],css`:host{-webkit-tap-highlight-color:transparent;align-items:center;cursor:pointer;display:flex;outline:none;user-select:none;--cr-checkbox-border-size:2px;--cr-checkbox-size:16px;--cr-checkbox-ripple-size:32px;--cr-checkbox-ripple-offset:50%;--cr-checkbox-checked-box-color:var(--cr-checked-color);--cr-checkbox-ripple-checked-color:var(--cr-active-background-color);--cr-checkbox-ripple-opacity:1;--cr-checkbox-mark-color:var(--color-checkbox-check,var(--cr-fallback-color-on-primary));--cr-checkbox-ripple-unchecked-color:var(--cr-active-background-color);--cr-checkbox-unchecked-box-color:var(--color-checkbox-foreground-unchecked,var(--cr-fallback-color-outline));--cr-checkbox-checked-ripple-opacity:.2;--cr-checkbox-unchecked-ripple-opacity:.15}@media (prefers-color-scheme:dark){:host{--cr-checkbox-checked-ripple-opacity:.4;--cr-checkbox-unchecked-ripple-opacity:.4}}:host([disabled]){cursor:initial;opacity:1;pointer-events:none;--cr-checkbox-checked-box-color:var(--color-checkbox-container-disabled,var(--cr-fallback-color-disabled-background));--cr-checkbox-unchecked-box-color:var(--color-checkbox-outline-disabled,var(--cr-fallback-color-disabled-background));--cr-checkbox-mark-color:var(--color-checkbox-check-disabled,var(--cr-fallback-color-disabled-foreground))}#checkbox{background:none;border:var(--cr-checkbox-border-size) solid var(--cr-checkbox-unchecked-box-color);border-radius:2px;box-sizing:border-box;cursor:pointer;display:block;flex-shrink:0;height:var(--cr-checkbox-size);isolation:isolate;margin:0;outline:none;padding:0;position:relative;transform:none;width:var(--cr-checkbox-size)}:host([disabled][checked]) #checkbox{border-color:transparent}#hover-layer{display:none}#checkbox:hover #hover-layer{background-color:var(--cr-hover-background-color);border-radius:50%;display:block;height:32px;left:50%;overflow:hidden;pointer-events:none;position:absolute;top:50%;transform:translate(-50%,-50%);width:32px}@media (forced-colors:active){:host(:focus) #checkbox{outline:var(--cr-focus-outline-hcm)}}#checkbox:focus-visible{outline:var(--cr-checkbox-focus-outline,2px solid var(--cr-focus-outline-color));outline-offset:2px}#checkmark{display:block;forced-color-adjust:auto;position:relative;transform:scale(0);z-index:1}#checkmark path{fill:var(--cr-checkbox-mark-color)}:host([checked]) #checkmark{transform:scale(1);transition:transform 140ms ease-out}:host([checked]) #checkbox{background:var(--cr-checkbox-checked-box-background-color,var(--cr-checkbox-checked-box-color));border-color:var(--cr-checkbox-checked-box-color)}#ink{--paper-ripple-opacity:var(--cr-checkbox-ripple-opacity,var(--cr-checkbox-unchecked-ripple-opacity));color:var(--cr-checkbox-ripple-unchecked-color);height:var(--cr-checkbox-ripple-size);left:var(--cr-checkbox-ripple-offset);outline:var(--cr-checkbox-ripple-ring,none);pointer-events:none;top:var(--cr-checkbox-ripple-offset);transform:translate(-50%,-50%);transition:color linear 80ms;width:var(--cr-checkbox-ripple-size)}:host([checked]) #ink{--paper-ripple-opacity:var(--cr-checkbox-ripple-opacity,var(--cr-checkbox-checked-ripple-opacity));color:var(--cr-checkbox-ripple-checked-color)}:host-context([dir=rtl]) #ink{left:auto;right:var(--cr-checkbox-ripple-offset);transform:translate(50%,-50%)}#labelContainer{color:var(--cr-checkbox-label-color,var(--cr-primary-text-color));padding-inline-start:var(--cr-checkbox-label-padding-start,20px);white-space:normal}:host(.label-first) #labelContainer{order:-1;padding-inline-end:var(--cr-checkbox-label-padding-end,20px);padding-inline-start:0}:host(.no-label) #labelContainer{display:none}#ariaDescription{height:0;overflow:hidden;width:0}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$6(){return html`
<div id="checkbox" tabindex="${this.tabIndex}" role="checkbox"
    @keydown="${this.onKeyDown_}" @keyup="${this.onKeyUp_}"

    aria-disabled="${this.getAriaDisabled_()}"
    aria-checked="${this.getAriaChecked_()}"
    aria-label="${this.ariaLabelOverride||nothing}"
    aria-labelledby="${this.ariaLabelOverride?nothing:"labelContainer"}"
    aria-describedby="ariaDescription">
  <!-- Inline SVG paints faster than loading it from a separate file. -->
  <svg id="checkmark" width="12" height="12" viewBox="0 0 12 12"
      fill="none" xmlns="http://www.w3.org/2000/svg">
    <path fill-rule="evenodd" clip-rule="evenodd"
        d="m10.192 2.121-6.01 6.01-2.121-2.12L1 7.07l2.121 2.121.707.707.354.354 7.071-7.071-1.06-1.06Z">
  </svg>
  <div id="hover-layer"></div>
</div>
<div id="labelContainer" part="label-container">
  <slot></slot>
</div>
<div id="ariaDescription" aria-hidden="true">${this.ariaDescription}</div>`}
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CrCheckboxElementBase=CrRippleMixin(CrLitElement);class CrCheckboxElement extends CrCheckboxElementBase{static get is(){return"cr-checkbox"}static get styles(){return getCss$c()}render(){return getHtml$6.bind(this)()}static get properties(){return{checked:{type:Boolean,reflect:true,notify:true},disabled:{type:Boolean,reflect:true},ariaDescription:{type:String},ariaLabelOverride:{type:String},tabIndex:{type:Number}}}#checked_accessor_storage=false;get checked(){return this.#checked_accessor_storage}set checked(value){this.#checked_accessor_storage=value}#disabled_accessor_storage=false;get disabled(){return this.#disabled_accessor_storage}set disabled(value){this.#disabled_accessor_storage=value}#ariaDescription_accessor_storage=null;get ariaDescription(){return this.#ariaDescription_accessor_storage}set ariaDescription(value){this.#ariaDescription_accessor_storage=value}#ariaLabelOverride_accessor_storage;get ariaLabelOverride(){return this.#ariaLabelOverride_accessor_storage}set ariaLabelOverride(value){this.#ariaLabelOverride_accessor_storage=value}#tabIndex_accessor_storage=0;get tabIndex(){return this.#tabIndex_accessor_storage}set tabIndex(value){this.#tabIndex_accessor_storage=value}firstUpdated(){this.addEventListener("click",this.onClick_.bind(this));this.addEventListener("pointerup",this.hideRipple_.bind(this));this.$.labelContainer.addEventListener("pointerdown",this.showRipple_.bind(this));this.$.labelContainer.addEventListener("pointerleave",this.hideRipple_.bind(this))}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("disabled")){const previousTabIndex=changedProperties.get("disabled");if(previousTabIndex!==undefined||this.disabled){this.tabIndex=this.disabled?-1:0}}}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("tabIndex")){this.removeAttribute("tabindex")}}focus(){this.$.checkbox.focus()}getFocusableElement(){return this.$.checkbox}getAriaDisabled_(){return this.disabled?"true":"false"}getAriaChecked_(){return this.checked?"true":"false"}showRipple_(){if(this.noink){return}this.getRipple().showAndHoldDown()}hideRipple_(){this.getRipple().clear()}async onClick_(e){if(this.disabled||e.target.tagName==="A"){return}e.stopPropagation();e.preventDefault();this.checked=!this.checked;await this.updateComplete;this.fire("change",this.checked)}onKeyDown_(e){if(e.key!==" "&&e.key!=="Enter"){return}e.preventDefault();e.stopPropagation();if(e.repeat){return}if(e.key==="Enter"){this.click()}}onKeyUp_(e){if(e.key===" "||e.key==="Enter"){e.preventDefault();e.stopPropagation()}if(e.key===" "){this.click()}}createRipple(){this.rippleContainer=this.$.checkbox;const ripple=super.createRipple();ripple.setAttribute("recenters","");ripple.classList.add("circle");return ripple}}customElements.define(CrCheckboxElement.is,CrCheckboxElement);
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
let iconsetMap=null;class IconsetMap extends EventTarget{iconsets_=new Map;static getInstance(){return iconsetMap||(iconsetMap=new IconsetMap)}static resetInstanceForTesting(instance){iconsetMap=instance}get(id){return this.iconsets_.get(id)||null}set(id,iconset){assert(!this.iconsets_.has(id),`Tried to add a second iconset with id '${id}'`);this.iconsets_.set(id,iconset);this.dispatchEvent(new CustomEvent("cr-iconset-added",{detail:id}))}}let instance$g=null;function getCss$b(){return instance$g||(instance$g=[...[getCss$e()],css`:host{align-items:center;display:inline-flex;justify-content:center;position:relative;vertical-align:middle;fill:var(--iron-icon-fill-color,currentcolor);stroke:var(--iron-icon-stroke-color,none);width:var(--iron-icon-width,24px);height:var(--iron-icon-height,24px)}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class CrIconElement extends CrLitElement{static get is(){return"cr-icon"}static get styles(){return getCss$b()}static get properties(){return{icon:{type:String}}}#icon_accessor_storage="";get icon(){return this.#icon_accessor_storage}set icon(value){this.#icon_accessor_storage=value}iconsetName_="";iconName_="";iconset_=null;updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("icon")){const[iconsetName,iconName]=this.icon.split(":");this.iconName_=iconName||"";this.iconsetName_=iconsetName||"";this.updateIcon_()}}updateIcon_(){if(this.iconName_===""&&this.iconset_){this.iconset_.removeIcon(this)}else if(this.iconsetName_){const iconsetMap=IconsetMap.getInstance();this.iconset_=iconsetMap.get(this.iconsetName_);assert(this.iconset_,`Could not find iconset for: '${this.iconsetName_}:${this.iconName_}'`);this.iconset_.applyIcon(this,this.iconName_)}}}customElements.define(CrIconElement.is,CrIconElement);let instance$f=null;function getCss$a(){return instance$f||(instance$f=[...[],css`:host{--cr-icon-button-fill-color:currentColor;--cr-icon-button-icon-start-offset:0;--cr-icon-button-icon-size:20px;--cr-icon-button-size:32px;--cr-icon-button-height:var(--cr-icon-button-size);--cr-icon-button-transition:150ms ease-in-out;--cr-icon-button-width:var(--cr-icon-button-size);-webkit-tap-highlight-color:transparent;border-radius:50%;color:var(--cr-icon-button-stroke-color,var(--cr-icon-button-fill-color));cursor:pointer;display:inline-flex;flex-shrink:0;height:var(--cr-icon-button-height);margin-inline-end:var(--cr-icon-button-margin-end,var(--cr-icon-ripple-margin));margin-inline-start:var(--cr-icon-button-margin-start);outline:none;overflow:hidden;position:relative;user-select:none;vertical-align:middle;width:var(--cr-icon-button-width)}:host(:hover){background-color:var(--cr-icon-button-hover-background-color,var(--cr-hover-background-color))}:host(:focus-visible:focus){box-shadow:inset 0 0 0 2px var(--cr-icon-button-focus-outline-color,var(--cr-focus-outline-color))}@media (forced-colors:active){:host(:focus-visible:focus){outline:var(--cr-focus-outline-hcm)}}#ink{--paper-ripple-opacity:1;color:var(--cr-icon-button-active-background-color,var(--cr-active-background-color))}:host([disabled]){cursor:initial;opacity:var(--cr-disabled-opacity);pointer-events:none}:host(.no-overlap){--cr-icon-button-margin-end:0;--cr-icon-button-margin-start:0}:host-context([dir=rtl]):host(:not([suppress-rtl-flip]):not([multiple-icons_])){transform:scaleX(-1)}:host-context([dir=rtl]):host(:not([suppress-rtl-flip])[multiple-icons_]) cr-icon{transform:scaleX(-1)}:host(:not([iron-icon])) #maskedImage{-webkit-mask-image:var(--cr-icon-image);-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:var(--cr-icon-button-icon-size);-webkit-transform:var(--cr-icon-image-transform,none);background-color:var(--cr-icon-button-fill-color);height:100%;transition:background-color var(--cr-icon-button-transition);width:100%}@media (forced-colors:active){:host(:not([iron-icon])) #maskedImage{background-color:ButtonText}}#icon{align-items:center;border-radius:4px;display:flex;height:100%;justify-content:center;padding-inline-start:var(--cr-icon-button-icon-start-offset);position:relative;width:100%}cr-icon{--iron-icon-fill-color:var(--cr-icon-button-fill-color);--iron-icon-stroke-color:var(--cr-icon-button-stroke-color,none);--iron-icon-height:var(--cr-icon-button-icon-size);--iron-icon-width:var(--cr-icon-button-icon-size);transition:fill var(--cr-icon-button-transition),stroke var(--cr-icon-button-transition)}@media (prefers-color-scheme:dark){:host{--cr-icon-button-fill-color:var(--google-grey-500)}}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$5(){return html`
<div id="icon">
  <div id="maskedImage"></div>
</div>`}
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CrIconbuttonElementBase=CrRippleMixin(CrLitElement);class CrIconButtonElement extends CrIconbuttonElementBase{static get is(){return"cr-icon-button"}static get styles(){return getCss$a()}render(){return getHtml$5.bind(this)()}static get properties(){return{disabled:{type:Boolean,reflect:true},ironIcon:{type:String,reflect:true},suppressRtlFlip:{type:Boolean,value:false,reflect:true},multipleIcons_:{type:Boolean,reflect:true}}}#disabled_accessor_storage=false;get disabled(){return this.#disabled_accessor_storage}set disabled(value){this.#disabled_accessor_storage=value}#ironIcon_accessor_storage;get ironIcon(){return this.#ironIcon_accessor_storage}set ironIcon(value){this.#ironIcon_accessor_storage=value}#multipleIcons__accessor_storage=false;get multipleIcons_(){return this.#multipleIcons__accessor_storage}set multipleIcons_(value){this.#multipleIcons__accessor_storage=value}spaceKeyDown_=false;constructor(){super();this.addEventListener("blur",this.onBlur_.bind(this));this.addEventListener("click",this.onClick_.bind(this));this.addEventListener("keydown",this.onKeyDown_.bind(this));this.addEventListener("keyup",this.onKeyUp_.bind(this));this.ensureRippleOnPointerdown()}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("ironIcon")){const icons=(this.ironIcon||"").split(",");this.multipleIcons_=icons.length>1}}firstUpdated(){if(!this.hasAttribute("role")){this.setAttribute("role","button")}if(!this.hasAttribute("tabindex")){this.setAttribute("tabindex","0")}}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("disabled")){this.setAttribute("aria-disabled",this.disabled?"true":"false");this.disabledChanged_(this.disabled,changedProperties.get("disabled"))}if(changedProperties.has("ironIcon")){this.onIronIconChanged_()}}disabledChanged_(newValue,oldValue){if(!newValue&&oldValue===undefined){return}if(this.disabled){this.blur()}this.setAttribute("tabindex",String(this.disabled?-1:0))}onBlur_(){this.spaceKeyDown_=false}onClick_(e){if(this.disabled){e.stopImmediatePropagation()}}onIronIconChanged_(){this.shadowRoot.querySelectorAll("cr-icon").forEach((el=>el.remove()));if(!this.ironIcon){return}const icons=(this.ironIcon||"").split(",");icons.forEach((async icon=>{const crIcon=document.createElement("cr-icon");crIcon.icon=icon;this.$.icon.appendChild(crIcon);await crIcon.updateComplete;crIcon.shadowRoot.querySelectorAll("svg, img").forEach((child=>child.setAttribute("role","none")))}))}onKeyDown_(e){if(e.key!==" "&&e.key!=="Enter"){return}e.preventDefault();e.stopPropagation();if(e.repeat){return}if(e.key==="Enter"){this.click()}else if(e.key===" "){this.spaceKeyDown_=true}}onKeyUp_(e){if(e.key===" "||e.key==="Enter"){e.preventDefault();e.stopPropagation()}if(this.spaceKeyDown_&&e.key===" "){this.spaceKeyDown_=false;this.click()}}}customElements.define(CrIconButtonElement.is,CrIconButtonElement);let instance$e=null;function getCss$9(){return instance$e||(instance$e=[...[],css`.icon-arrow-back{--cr-icon-image:url(//resources/images/icon_arrow_back.svg)}.icon-arrow-dropdown{--cr-icon-image:url(//resources/images/icon_arrow_dropdown.svg)}.icon-arrow-drop-down-cr23{--cr-icon-image:url(//resources/images/icon_arrow_drop_down_cr23.svg)}.icon-arrow-drop-up-cr23{--cr-icon-image:url(//resources/images/icon_arrow_drop_up_cr23.svg)}.icon-arrow-upward{--cr-icon-image:url(//resources/images/icon_arrow_upward.svg)}.icon-cancel{--cr-icon-image:url(//resources/images/icon_cancel.svg)}.icon-clear{--cr-icon-image:url(//resources/images/icon_clear.svg)}.icon-copy-content{--cr-icon-image:url(//resources/images/icon_copy_content.svg)}.icon-delete-gray{--cr-icon-image:url(//resources/images/icon_delete_gray.svg)}.icon-edit{--cr-icon-image:url(//resources/images/icon_edit.svg)}.icon-file{--cr-icon-image:url(//resources/images/icon_filetype_generic.svg)}.icon-folder-open{--cr-icon-image:url(//resources/images/icon_folder_open.svg)}.icon-picture-delete{--cr-icon-image:url(//resources/images/icon_picture_delete.svg)}.icon-expand-less{--cr-icon-image:url(//resources/images/icon_expand_less.svg)}.icon-expand-more{--cr-icon-image:url(//resources/images/icon_expand_more.svg)}.icon-external{--cr-icon-image:url(//resources/images/open_in_new.svg)}.icon-more-vert{--cr-icon-image:url(//resources/images/icon_more_vert.svg)}.icon-refresh{--cr-icon-image:url(//resources/images/icon_refresh.svg)}.icon-search{--cr-icon-image:url(//resources/images/icon_search.svg)}.icon-settings{--cr-icon-image:url(//resources/images/icon_settings.svg)}.icon-visibility{--cr-icon-image:url(//resources/images/icon_visibility.svg)}.icon-visibility-off{--cr-icon-image:url(//resources/images/icon_visibility_off.svg)}.subpage-arrow{--cr-icon-image:url(//resources/images/arrow_right.svg)}.cr-icon{-webkit-mask-image:var(--cr-icon-image);-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:var(--cr-icon-size);background-color:var(--cr-icon-color,var(--google-grey-700));flex-shrink:0;height:var(--cr-icon-ripple-size);margin-inline-end:var(--cr-icon-ripple-margin);margin-inline-start:var(--cr-icon-button-margin-start);user-select:none;width:var(--cr-icon-ripple-size)}:host-context([dir=rtl]) .cr-icon{transform:scaleX(-1)}.cr-icon.no-overlap{margin-inline-end:0;margin-inline-start:0}@media (prefers-color-scheme:dark){.cr-icon{background-color:var(--cr-icon-color,var(--google-grey-500))}}`])}let instance$d=null;function getCss$8(){return instance$d||(instance$d=[...[getCss$e(),getCss$9()],css`[actionable]{cursor:pointer}.hr{border-top:var(--cr-separator-line)}iron-list.cr-separators>*:not([first]){border-top:var(--cr-separator-line)}[scrollable]{border-color:transparent;border-style:solid;border-width:1px 0;overflow-y:auto}[scrollable].is-scrolled{border-top-color:var(--cr-scrollable-border-color)}[scrollable].can-scroll:not(.scrolled-to-bottom){border-bottom-color:var(--cr-scrollable-border-color)}[scrollable] iron-list>:not(.no-outline):focus-visible,[selectable]:focus-visible,[selectable]>:focus-visible{outline:solid 2px var(--cr-focus-outline-color);outline-offset:-2px}.scroll-container{display:flex;flex-direction:column;min-height:1px}[selectable]>*{cursor:pointer}.cr-centered-card-container{box-sizing:border-box;display:block;height:inherit;margin:0 auto;max-width:var(--cr-centered-card-max-width);min-width:550px;position:relative;width:calc(100% * var(--cr-centered-card-width-percentage))}.cr-container-shadow{box-shadow:inset 0 5px 6px -3px rgba(0,0,0,.4);height:var(--cr-container-shadow-height);left:0;margin:0 0 var(--cr-container-shadow-margin);opacity:0;pointer-events:none;position:relative;right:0;top:0;transition:opacity 500ms;z-index:1}#cr-container-shadow-bottom{margin-bottom:0;margin-top:var(--cr-container-shadow-margin);transform:scaleY(-1)}#cr-container-shadow-top:has(+#container.can-scroll:not(.scrolled-to-top)),#container.can-scroll:not(.scrolled-to-bottom)+#cr-container-shadow-bottom,#cr-container-shadow-bottom.force-shadow,#cr-container-shadow-top.force-shadow{opacity:var(--cr-container-shadow-max-opacity)}.cr-row{align-items:center;border-top:var(--cr-separator-line);display:flex;min-height:var(--cr-section-min-height);padding:0 var(--cr-section-padding)}.cr-row.first,.cr-row.continuation{border-top:none}.cr-row-gap{padding-inline-start:16px}.cr-button-gap{margin-inline-start:8px}paper-tooltip::part(tooltip),cr-tooltip::part(tooltip){border-radius:var(--paper-tooltip-border-radius,2px);font-size:92.31%;font-weight:500;max-width:330px;min-width:var(--paper-tooltip-min-width,200px);padding:var(--paper-tooltip-padding,10px 8px)}.cr-padded-text{padding-block-end:var(--cr-section-vertical-padding);padding-block-start:var(--cr-section-vertical-padding)}.cr-title-text{color:var(--cr-title-text-color);font-size:107.6923%;font-weight:500}.cr-secondary-text{color:var(--cr-secondary-text-color);font-weight:400}.cr-form-field-label{color:var(--cr-form-field-label-color);display:block;font-size:var(--cr-form-field-label-font-size);font-weight:500;letter-spacing:.4px;line-height:var(--cr-form-field-label-line-height);margin-bottom:8px}.cr-vertical-tab{align-items:center;display:flex}.cr-vertical-tab::before{border-radius:0 3px 3px 0;content:'';display:block;flex-shrink:0;height:var(--cr-vertical-tab-height,100%);width:4px}.cr-vertical-tab.selected::before{background:var(--cr-vertical-tab-selected-color,var(--cr-checked-color))}:host-context([dir=rtl]) .cr-vertical-tab::before{transform:scaleX(-1)}.iph-anchor-highlight{background-color:var(--cr-iph-anchor-highlight-color)}`])}let instance$c=null;function getCss$7(){return instance$c||(instance$c=[...[],css`:host{--cr-input-background-color:var(--color-textfield-filled-background,var(--cr-fallback-color-surface-variant));--cr-input-border-bottom:1px solid var(--color-textfield-filled-underline,var(--cr-fallback-color-outline));--cr-input-border-radius:8px 8px 0 0;--cr-input-color:var(--cr-primary-text-color);--cr-input-error-color:var(--color-textfield-filled-error,var(--cr-fallback-color-error));--cr-input-focus-color:var(--color-textfield-filled-underline-focused,var(--cr-fallback-color-primary));--cr-input-hover-background-color:var(--cr-hover-background-color);--cr-input-label-color:var(--color-textfield-foreground-label,var(--cr-fallback-color-on-surface-subtle));--cr-input-padding-bottom:10px;--cr-input-padding-end:10px;--cr-input-padding-start:10px;--cr-input-padding-top:10px;--cr-input-placeholder-color:var(--color-textfield-foreground-placeholder,var(--cr-fallback-on-surface-subtle));display:block;isolation:isolate;outline:none}:host([readonly]){--cr-input-border-radius:8px 8px}#label{color:var(--cr-input-label-color);font-size:11px;line-height:16px}:host([focused_]:not([readonly]):not([invalid])) #label{color:var(--cr-input-focus-label-color,var(--cr-input-label-color))}#input-container{border-radius:var(--cr-input-border-radius,4px);overflow:hidden;position:relative;width:var(--cr-input-width,100%)}:host([focused_]) #input-container{outline:var(--cr-input-focus-outline,none)}#inner-input-container{background-color:var(--cr-input-background-color);box-sizing:border-box;padding:0}#inner-input-content ::slotted(*){--cr-icon-button-fill-color:var(--color-textfield-foreground-icon,var(--cr-fallback-color-on-surface-subtle));--cr-icon-button-icon-size:16px;--cr-icon-button-size:24px;--cr-icon-button-margin-start:0;--cr-icon-color:var(--color-textfield-foreground-icon,var(--cr-fallback-color-on-surface-subtle))}#inner-input-content ::slotted([slot='inline-prefix']){--cr-icon-button-margin-start:-8px}#inner-input-content ::slotted([slot='inline-suffix']){--cr-icon-button-margin-end:-4px}:host([invalid]) #inner-input-content ::slotted(*){--cr-icon-color:var(--cr-input-error-color);--cr-icon-button-fill-color:var(--cr-input-error-color)}#hover-layer{background-color:var(--cr-input-hover-background-color);display:none;inset:0;pointer-events:none;position:absolute;z-index:0}:host(:not([readonly]):not([disabled])) #input-container:hover #hover-layer{display:block}#input{-webkit-appearance:none;background-color:transparent;border:none;box-sizing:border-box;caret-color:var(--cr-input-focus-color);color:var(--cr-input-color);font-family:inherit;font-size:var(--cr-input-font-size,12px);font-weight:inherit;line-height:16px;min-height:var(--cr-input-min-height,auto);outline:none;padding:0;text-align:inherit;text-overflow:ellipsis;width:100%}#inner-input-content{padding-bottom:var(--cr-input-padding-bottom);padding-inline-end:var(--cr-input-padding-end);padding-inline-start:var(--cr-input-padding-start);padding-top:var(--cr-input-padding-top)}#underline{border-bottom:2px solid var(--cr-input-focus-color);border-radius:var(--cr-input-underline-border-radius,0);bottom:0;box-sizing:border-box;display:var(--cr-input-underline-display);height:var(--cr-input-underline-height,0);left:0;margin:auto;opacity:0;position:absolute;right:0;transition:opacity 120ms ease-out,width 0s linear 180ms;width:0}:host([invalid]) #underline,:host([force-underline]) #underline,:host([focused_]) #underline{opacity:1;transition:opacity 120ms ease-in,width 180ms ease-out;width:100%}#underline-base{display:none}:host([readonly]) #underline{display:none}:host(:not([readonly])) #underline-base{border-bottom:var(--cr-input-border-bottom);bottom:0;display:block;left:0;position:absolute;right:0}:host([disabled]){color:var(--color-textfield-foreground-disabled,var(--cr-fallback-color-disabled-foreground));--cr-input-border-bottom:1px solid currentColor;--cr-input-placeholder-color:currentColor;--cr-input-color:currentColor;--cr-input-background-color:var(--color-textfield-background-disabled,var(--cr-fallback-color-disabled-background))}:host([disabled]) #inner-input-content ::slotted(*){--cr-icon-color:currentColor;--cr-icon-button-fill-color:currentColor}:host(.stroked){--cr-input-background-color:transparent;--cr-input-border:1px solid var(--color-side-panel-textfield-border,var(--cr-fallback-color-neutral-outline));--cr-input-border-bottom:none;--cr-input-border-radius:8px;--cr-input-padding-bottom:9px;--cr-input-padding-end:9px;--cr-input-padding-start:9px;--cr-input-padding-top:9px;--cr-input-underline-display:none;--cr-input-min-height:36px;line-height:16px}:host(.stroked[focused_]){--cr-input-border:2px solid var(--cr-focus-outline-color);--cr-input-padding-bottom:8px;--cr-input-padding-end:8px;--cr-input-padding-start:8px;--cr-input-padding-top:8px}:host(.stroked[invalid]){--cr-input-border:1px solid var(--cr-input-error-color)}:host(.stroked[focused_][invalid]){--cr-input-border:2px solid var(--cr-input-error-color)}`])}let instance$b=null;function getCss$6(){return instance$b||(instance$b=[...[getCss$e(),getCss$7(),getCss$8()],css`:host([disabled]) :-webkit-any(#label,#error,#input-container){opacity:var(--cr-disabled-opacity);pointer-events:none}:host([disabled]) :is(#label,#error,#input-container){opacity:1}:host ::slotted(cr-button[slot=suffix]){margin-inline-start:var(--cr-button-edge-spacing) !important}:host([invalid]) #label{color:var(--cr-input-error-color)}#input{border-bottom:none;letter-spacing:var(--cr-input-letter-spacing)}#input-container{border:var(--cr-input-border,none)}#input::placeholder{color:var(--cr-input-placeholder-color,var(--cr-secondary-text-color));letter-spacing:var(--cr-input-placeholder-letter-spacing)}:host([invalid]) #input{caret-color:var(--cr-input-error-color)}:host([readonly]) #input{opacity:var(--cr-input-readonly-opacity,0.6)}:host([invalid]) #underline{border-color:var(--cr-input-error-color)}#error{color:var(--cr-input-error-color);display:var(--cr-input-error-display,block);font-size:11px;min-height:var(--cr-form-field-label-height);line-height:16px;margin:4px 10px;visibility:hidden;white-space:var(--cr-input-error-white-space);height:auto;overflow:hidden;text-overflow:ellipsis}:host([invalid]) #error{visibility:visible}#row-container,#inner-input-content{align-items:center;display:flex;justify-content:space-between;position:relative}#inner-input-content{gap:4px;height:16px;z-index:1}#input[type='search']::-webkit-search-cancel-button{display:none}:host-context([dir=rtl]) #input[type=url]{text-align:right}#input[type=url]{direction:ltr}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$4(){return html`
<div id="label" class="cr-form-field-label" ?hidden="${!this.label}"
    aria-hidden="true">
  ${this.label}
</div>
<div id="row-container" part="row-container">
  <div id="input-container">
    <div id="inner-input-container">
      <div id="hover-layer"></div>
      <div id="inner-input-content">
        <slot name="inline-prefix"></slot>
        <input id="input" ?disabled="${this.disabled}"
            ?autofocus="${this.autofocus}"
            .value="${this.internalValue_}" tabindex="${this.inputTabindex}"
            .type="${this.type}"
            ?readonly="${this.readonly}" maxlength="${this.maxlength}"
            pattern="${this.pattern||nothing}" ?required="${this.required}"
            minlength="${this.minlength}" inputmode="${this.inputmode}"
            aria-description="${this.ariaDescription||nothing}"
            aria-errormessage="${this.getAriaErrorMessage_()||nothing}"
            aria-label="${this.getAriaLabel_()}"
            aria-invalid="${this.getAriaInvalid_()}"
            .max="${this.max||nothing}" .min="${this.min||nothing}"
            @focus="${this.onInputFocus_}"
            @blur="${this.onInputBlur_}" @change="${this.onInputChange_}"
            @input="${this.onInput_}"
            part="input"
            autocomplete="off">
        <slot name="inline-suffix"></slot>
      </div>
    </div>
    <div id="underline-base"></div>
    <div id="underline"></div>
  </div>
  <slot name="suffix"></slot>
</div>
<div id="error" role="${this.getErrorRole_()||nothing}"
    aria-live="assertive">${this.getErrorMessage_()}</div>`}
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SUPPORTED_INPUT_TYPES=new Set(["number","password","search","text","url"]);class CrInputElement extends CrLitElement{static get is(){return"cr-input"}static get styles(){return getCss$6()}render(){return getHtml$4.bind(this)()}static get properties(){return{ariaDescription:{type:String},ariaLabel:{type:String},autofocus:{type:Boolean,reflect:true},autoValidate:{type:Boolean},disabled:{type:Boolean,reflect:true},errorMessage:{type:String},errorRole_:{type:String},focused_:{type:Boolean,reflect:true},invalid:{type:Boolean,notify:true,reflect:true},max:{type:Number,reflect:true},min:{type:Number,reflect:true},maxlength:{type:Number,reflect:true},minlength:{type:Number,reflect:true},pattern:{type:String,reflect:true},inputmode:{type:String},label:{type:String},placeholder:{type:String},readonly:{type:Boolean,reflect:true},required:{type:Boolean,reflect:true},inputTabindex:{type:Number},type:{type:String},value:{type:String,notify:true},internalValue_:{type:String,state:true}}}#ariaDescription_accessor_storage=null;get ariaDescription(){return this.#ariaDescription_accessor_storage}set ariaDescription(value){this.#ariaDescription_accessor_storage=value}#ariaLabel_accessor_storage="";get ariaLabel(){return this.#ariaLabel_accessor_storage}set ariaLabel(value){this.#ariaLabel_accessor_storage=value}#autofocus_accessor_storage=false;get autofocus(){return this.#autofocus_accessor_storage}set autofocus(value){this.#autofocus_accessor_storage=value}#autoValidate_accessor_storage=false;get autoValidate(){return this.#autoValidate_accessor_storage}set autoValidate(value){this.#autoValidate_accessor_storage=value}#disabled_accessor_storage=false;get disabled(){return this.#disabled_accessor_storage}set disabled(value){this.#disabled_accessor_storage=value}#errorMessage_accessor_storage="";get errorMessage(){return this.#errorMessage_accessor_storage}set errorMessage(value){this.#errorMessage_accessor_storage=value}#inputmode_accessor_storage;get inputmode(){return this.#inputmode_accessor_storage}set inputmode(value){this.#inputmode_accessor_storage=value}#inputTabindex_accessor_storage=0;get inputTabindex(){return this.#inputTabindex_accessor_storage}set inputTabindex(value){this.#inputTabindex_accessor_storage=value}#invalid_accessor_storage=false;get invalid(){return this.#invalid_accessor_storage}set invalid(value){this.#invalid_accessor_storage=value}#label_accessor_storage="";get label(){return this.#label_accessor_storage}set label(value){this.#label_accessor_storage=value}#max_accessor_storage;get max(){return this.#max_accessor_storage}set max(value){this.#max_accessor_storage=value}#min_accessor_storage;get min(){return this.#min_accessor_storage}set min(value){this.#min_accessor_storage=value}#maxlength_accessor_storage;get maxlength(){return this.#maxlength_accessor_storage}set maxlength(value){this.#maxlength_accessor_storage=value}#minlength_accessor_storage;get minlength(){return this.#minlength_accessor_storage}set minlength(value){this.#minlength_accessor_storage=value}#pattern_accessor_storage;get pattern(){return this.#pattern_accessor_storage}set pattern(value){this.#pattern_accessor_storage=value}#placeholder_accessor_storage=null;get placeholder(){return this.#placeholder_accessor_storage}set placeholder(value){this.#placeholder_accessor_storage=value}#readonly_accessor_storage=false;get readonly(){return this.#readonly_accessor_storage}set readonly(value){this.#readonly_accessor_storage=value}#required_accessor_storage=false;get required(){return this.#required_accessor_storage}set required(value){this.#required_accessor_storage=value}#type_accessor_storage="text";get type(){return this.#type_accessor_storage}set type(value){this.#type_accessor_storage=value}#value_accessor_storage="";get value(){return this.#value_accessor_storage}set value(value){this.#value_accessor_storage=value}#internalValue__accessor_storage="";get internalValue_(){return this.#internalValue__accessor_storage}set internalValue_(value){this.#internalValue__accessor_storage=value}#focused__accessor_storage=false;get focused_(){return this.#focused__accessor_storage}set focused_(value){this.#focused__accessor_storage=value}firstUpdated(){assert(!this.hasAttribute("tabindex"))}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("value")){this.internalValue_=this.value===undefined||this.value===null?"":this.value}if(changedProperties.has("inputTabindex")){assert(this.inputTabindex===0||this.inputTabindex===-1)}if(changedProperties.has("type")){assert(SUPPORTED_INPUT_TYPES.has(this.type))}}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("value")){const previous=changedProperties.get("value");if((!!this.value||!!previous)&&this.autoValidate){this.invalid=!this.inputElement.checkValidity()}}if(changedProperties.has("placeholder")){if(this.placeholder===null||this.placeholder===undefined){this.inputElement.removeAttribute("placeholder")}else{this.inputElement.setAttribute("placeholder",this.placeholder)}}}get inputElement(){return this.$.input}focus(){this.focusInput()}focusInput(){if(this.shadowRoot.activeElement===this.inputElement){return false}this.inputElement.focus();return true}async onInputChange_(e){await this.updateComplete;this.fire("change",{sourceEvent:e})}onInput_(e){this.internalValue_=e.target.value;this.value=this.internalValue_}onInputFocus_(){this.focused_=true}onInputBlur_(){this.focused_=false}getAriaLabel_(){return this.ariaLabel||this.label||this.placeholder}getAriaInvalid_(){return this.invalid?"true":"false"}getErrorMessage_(){return this.invalid?this.errorMessage:""}getErrorRole_(){return this.invalid?"alert":""}getAriaErrorMessage_(){return this.invalid?"error":""}select(start,end){this.inputElement.focus();if(start!==undefined&&end!==undefined){this.inputElement.setSelectionRange(start,end)}else{assert(start===undefined&&end===undefined);this.inputElement.select()}}validate(){this.performUpdate();this.invalid=!this.inputElement.checkValidity();this.performUpdate();return!this.invalid}}customElements.define(CrInputElement.is,CrInputElement);
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class PluralStringProxyImpl{getPluralString(messageName,itemCount){return sendWithPromise("getPluralString",messageName,itemCount)}getPluralStringTupleWithComma(messageName1,itemCount1,messageName2,itemCount2){return sendWithPromise("getPluralStringTupleWithComma",messageName1,itemCount1,messageName2,itemCount2)}getPluralStringTupleWithPeriods(messageName1,itemCount1,messageName2,itemCount2){return sendWithPromise("getPluralStringTupleWithPeriods",messageName1,itemCount1,messageName2,itemCount2)}static getInstance(){return instance$a||(instance$a=new PluralStringProxyImpl)}static setInstance(obj){instance$a=obj}}let instance$a=null;
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function isValidArray(arr){if(arr instanceof Array&&Object.isFrozen(arr)){return true}return false}function getStaticString(literal){const isStaticString=isValidArray(literal)&&!!literal.raw&&isValidArray(literal.raw)&&literal.length===literal.raw.length&&literal.length===1;assert(isStaticString,"static_types.js only allows static strings");return literal.join("")}function createTypes(_ignore,literal){return getStaticString(literal)}const rules={createHTML:createTypes,createScript:createTypes,createScriptURL:createTypes};let staticPolicy;if(window.trustedTypes){staticPolicy=window.trustedTypes.createPolicy("static-types",rules)}else{staticPolicy=rules}function getTrustedHTML(literal){return staticPolicy.createHTML("",literal)}
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var VendorCapabilityValueType;(function(VendorCapabilityValueType){VendorCapabilityValueType["BOOLEAN"]="BOOLEAN";VendorCapabilityValueType["FLOAT"]="FLOAT";VendorCapabilityValueType["INTEGER"]="INTEGER";VendorCapabilityValueType["STRING"]="STRING"})(VendorCapabilityValueType||(VendorCapabilityValueType={}));var DuplexType;(function(DuplexType){DuplexType["NO_DUPLEX"]="NO_DUPLEX";DuplexType["LONG_EDGE"]="LONG_EDGE";DuplexType["SHORT_EDGE"]="SHORT_EDGE"})(DuplexType||(DuplexType={}));var QualityIppValue;(function(QualityIppValue){QualityIppValue["DRAFT"]="3";QualityIppValue["NORMAL"]="4";QualityIppValue["HIGH"]="5"})(QualityIppValue||(QualityIppValue={}));
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class NativeLayerCrosImpl{getEulaUrl(destinationId){return sendWithPromise("getEulaUrl",destinationId)}grantExtensionPrinterAccess(provisionalDestinationId){return sendWithPromise("grantExtensionPrinterAccess",provisionalDestinationId)}setupPrinter(printerId){return sendWithPromise("setupPrinter",printerId)}requestPrinterStatusUpdate(printerId){return sendWithPromise("requestPrinterStatus",printerId)}choosePrintServers(printServerIds){chrome.send("choosePrintServers",[printServerIds])}getPrintServersConfig(){return sendWithPromise("getPrintServersConfig")}recordPrintAttemptOutcome(printAttemptOutcome){chrome.send("recordPrintAttemptOutcome",[printAttemptOutcome])}getShowManagePrinters(){return sendWithPromise("getShowManagePrinters")}observeLocalPrinters(){return sendWithPromise("observeLocalPrinters")}static getInstance(){return instance$9||(instance$9=new NativeLayerCrosImpl)}static setInstance(obj){instance$9=obj}}let instance$9=null;
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var ManagedPrintOptionsDuplexType;(function(ManagedPrintOptionsDuplexType){ManagedPrintOptionsDuplexType[ManagedPrintOptionsDuplexType["UNKNOWN_DUPLEX"]=0]="UNKNOWN_DUPLEX";ManagedPrintOptionsDuplexType[ManagedPrintOptionsDuplexType["ONE_SIDED"]=1]="ONE_SIDED";ManagedPrintOptionsDuplexType[ManagedPrintOptionsDuplexType["SHORT_EDGE"]=2]="SHORT_EDGE";ManagedPrintOptionsDuplexType[ManagedPrintOptionsDuplexType["LONG_EDGE"]=3]="LONG_EDGE"})(ManagedPrintOptionsDuplexType||(ManagedPrintOptionsDuplexType={}));var ManagedPrintOptionsQualityType;(function(ManagedPrintOptionsQualityType){ManagedPrintOptionsQualityType[ManagedPrintOptionsQualityType["UNKNOWN_QUALITY"]=0]="UNKNOWN_QUALITY";ManagedPrintOptionsQualityType[ManagedPrintOptionsQualityType["DRAFT"]=1]="DRAFT";ManagedPrintOptionsQualityType[ManagedPrintOptionsQualityType["NORMAL"]=2]="NORMAL";ManagedPrintOptionsQualityType[ManagedPrintOptionsQualityType["HIGH"]=3]="HIGH"})(ManagedPrintOptionsQualityType||(ManagedPrintOptionsQualityType={}));const IPP_PRINT_QUALITY="print-quality";function managedPrintOptionsDuplexToCdd(managedPrintOptionsDuplex){switch(managedPrintOptionsDuplex){case ManagedPrintOptionsDuplexType.ONE_SIDED:return DuplexType.NO_DUPLEX;case ManagedPrintOptionsDuplexType.LONG_EDGE:return DuplexType.LONG_EDGE;case ManagedPrintOptionsDuplexType.SHORT_EDGE:return DuplexType.SHORT_EDGE;default:return null}}function managedPrintOptionsQualityToIpp(managedPrintOptionsQuality){switch(managedPrintOptionsQuality){case ManagedPrintOptionsQualityType.DRAFT:return QualityIppValue.DRAFT;case ManagedPrintOptionsQualityType.NORMAL:return QualityIppValue.NORMAL;case ManagedPrintOptionsQualityType.HIGH:return QualityIppValue.HIGH;default:return null}}
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var PrinterStatusReason;(function(PrinterStatusReason){PrinterStatusReason[PrinterStatusReason["UNKNOWN_REASON"]=0]="UNKNOWN_REASON";PrinterStatusReason[PrinterStatusReason["DEVICE_ERROR"]=1]="DEVICE_ERROR";PrinterStatusReason[PrinterStatusReason["DOOR_OPEN"]=2]="DOOR_OPEN";PrinterStatusReason[PrinterStatusReason["LOW_ON_INK"]=3]="LOW_ON_INK";PrinterStatusReason[PrinterStatusReason["LOW_ON_PAPER"]=4]="LOW_ON_PAPER";PrinterStatusReason[PrinterStatusReason["NO_ERROR"]=5]="NO_ERROR";PrinterStatusReason[PrinterStatusReason["OUT_OF_INK"]=6]="OUT_OF_INK";PrinterStatusReason[PrinterStatusReason["OUT_OF_PAPER"]=7]="OUT_OF_PAPER";PrinterStatusReason[PrinterStatusReason["OUTPUT_ALMOST_FULL"]=8]="OUTPUT_ALMOST_FULL";PrinterStatusReason[PrinterStatusReason["OUTPUT_FULL"]=9]="OUTPUT_FULL";PrinterStatusReason[PrinterStatusReason["PAPER_JAM"]=10]="PAPER_JAM";PrinterStatusReason[PrinterStatusReason["PAUSED"]=11]="PAUSED";PrinterStatusReason[PrinterStatusReason["PRINTER_QUEUE_FULL"]=12]="PRINTER_QUEUE_FULL";PrinterStatusReason[PrinterStatusReason["PRINTER_UNREACHABLE"]=13]="PRINTER_UNREACHABLE";PrinterStatusReason[PrinterStatusReason["STOPPED"]=14]="STOPPED";PrinterStatusReason[PrinterStatusReason["TRAY_MISSING"]=15]="TRAY_MISSING"})(PrinterStatusReason||(PrinterStatusReason={}));var PrinterStatusSeverity;(function(PrinterStatusSeverity){PrinterStatusSeverity[PrinterStatusSeverity["UNKNOWN_SEVERITY"]=0]="UNKNOWN_SEVERITY";PrinterStatusSeverity[PrinterStatusSeverity["REPORT"]=1]="REPORT";PrinterStatusSeverity[PrinterStatusSeverity["WARNING"]=2]="WARNING";PrinterStatusSeverity[PrinterStatusSeverity["ERROR"]=3]="ERROR"})(PrinterStatusSeverity||(PrinterStatusSeverity={}));var PrinterState;(function(PrinterState){PrinterState[PrinterState["GOOD"]=0]="GOOD";PrinterState[PrinterState["ERROR"]=1]="ERROR";PrinterState[PrinterState["UNKNOWN"]=2]="UNKNOWN"})(PrinterState||(PrinterState={}));var PrintAttemptOutcome;(function(PrintAttemptOutcome){PrintAttemptOutcome[PrintAttemptOutcome["CANCELLED_PRINT_BUTTON_DISABLED"]=0]="CANCELLED_PRINT_BUTTON_DISABLED";PrintAttemptOutcome[PrintAttemptOutcome["CANCELLED_NO_PRINTERS_AVAILABLE"]=1]="CANCELLED_NO_PRINTERS_AVAILABLE";PrintAttemptOutcome[PrintAttemptOutcome["CANCELLED_OTHER_PRINTERS_AVAILABLE"]=2]="CANCELLED_OTHER_PRINTERS_AVAILABLE";PrintAttemptOutcome[PrintAttemptOutcome["CANCELLED_PRINTER_ERROR_STATUS"]=3]="CANCELLED_PRINTER_ERROR_STATUS";PrintAttemptOutcome[PrintAttemptOutcome["CANCELLED_PRINTER_GOOD_STATUS"]=4]="CANCELLED_PRINTER_GOOD_STATUS";PrintAttemptOutcome[PrintAttemptOutcome["CANCELLED_PRINTER_UNKNOWN_STATUS"]=5]="CANCELLED_PRINTER_UNKNOWN_STATUS";PrintAttemptOutcome[PrintAttemptOutcome["PDF_PRINT_ATTEMPTED"]=6]="PDF_PRINT_ATTEMPTED";PrintAttemptOutcome[PrintAttemptOutcome["PRINT_JOB_SUCCESS_INITIAL_PRINTER"]=7]="PRINT_JOB_SUCCESS_INITIAL_PRINTER";PrintAttemptOutcome[PrintAttemptOutcome["PRINT_JOB_SUCCESS_MANUALLY_SELECTED_PRINTER"]=8]="PRINT_JOB_SUCCESS_MANUALLY_SELECTED_PRINTER";PrintAttemptOutcome[PrintAttemptOutcome["PRINT_JOB_FAIL_INITIAL_PRINTER"]=9]="PRINT_JOB_FAIL_INITIAL_PRINTER";PrintAttemptOutcome[PrintAttemptOutcome["PRINT_JOB_FAIL_MANUALLY_SELECTED_PRINTER"]=10]="PRINT_JOB_FAIL_MANUALLY_SELECTED_PRINTER"})(PrintAttemptOutcome||(PrintAttemptOutcome={}));const ERROR_STRING_KEY_MAP=new Map([[PrinterStatusReason.DEVICE_ERROR,"printerStatusDeviceError"],[PrinterStatusReason.DOOR_OPEN,"printerStatusDoorOpen"],[PrinterStatusReason.LOW_ON_INK,"printerStatusLowOnInk"],[PrinterStatusReason.LOW_ON_PAPER,"printerStatusLowOnPaper"],[PrinterStatusReason.OUT_OF_INK,"printerStatusOutOfInk"],[PrinterStatusReason.OUT_OF_PAPER,"printerStatusOutOfPaper"],[PrinterStatusReason.OUTPUT_ALMOST_FULL,"printerStatusOutputAlmostFull"],[PrinterStatusReason.OUTPUT_FULL,"printerStatusOutputFull"],[PrinterStatusReason.PAPER_JAM,"printerStatusPaperJam"],[PrinterStatusReason.PAUSED,"printerStatusPaused"],[PrinterStatusReason.PRINTER_QUEUE_FULL,"printerStatusPrinterQueueFull"],[PrinterStatusReason.PRINTER_UNREACHABLE,"printerStatusPrinterUnreachable"],[PrinterStatusReason.STOPPED,"printerStatusStopped"],[PrinterStatusReason.TRAY_MISSING,"printerStatusTrayMissing"]]);function getStatusReasonFromPrinterStatus(printerStatus){if(!printerStatus.printerId){console.warn("Received printer status missing printer id");return PrinterStatusReason.UNKNOWN_REASON}let statusReason=PrinterStatusReason.NO_ERROR;for(const printerStatusReason of printerStatus.statusReasons){const reason=printerStatusReason.reason;const severity=printerStatusReason.severity;if(severity!==PrinterStatusSeverity.ERROR&&severity!==PrinterStatusSeverity.WARNING){continue}if(reason!==PrinterStatusReason.UNKNOWN_REASON&&severity===PrinterStatusSeverity.ERROR){return reason}if(reason!==PrinterStatusReason.UNKNOWN_REASON||statusReason===PrinterStatusReason.NO_ERROR){statusReason=reason}}return statusReason}function computePrinterState(printerStatusReason){if(printerStatusReason===null||printerStatusReason===PrinterStatusReason.UNKNOWN_REASON){return PrinterState.UNKNOWN}if(printerStatusReason===PrinterStatusReason.NO_ERROR){return PrinterState.GOOD}return PrinterState.ERROR}const PRINTER_STATUS_REASON_COLOR_MAP=new Map([[PrinterStatusReason.UNKNOWN_REASON,"green"],[PrinterStatusReason.DEVICE_ERROR,"orange"],[PrinterStatusReason.DOOR_OPEN,"orange"],[PrinterStatusReason.LOW_ON_INK,"orange"],[PrinterStatusReason.LOW_ON_PAPER,"orange"],[PrinterStatusReason.NO_ERROR,"green"],[PrinterStatusReason.OUT_OF_INK,"orange"],[PrinterStatusReason.OUT_OF_PAPER,"orange"],[PrinterStatusReason.OUTPUT_ALMOST_FULL,"orange"],[PrinterStatusReason.OUTPUT_FULL,"orange"],[PrinterStatusReason.PAPER_JAM,"orange"],[PrinterStatusReason.PAUSED,"orange"],[PrinterStatusReason.PRINTER_QUEUE_FULL,"orange"],[PrinterStatusReason.PRINTER_UNREACHABLE,"red"],[PrinterStatusReason.STOPPED,"orange"],[PrinterStatusReason.TRAY_MISSING,"orange"]]);function getPrinterStatusIcon(printerStatusReason,isEnterprisePrinter,prefersDarkColorScheme){const printerTypePrefix=isEnterprisePrinter?"print-preview:business-printer-status-":"print-preview:printer-status-";const darkModeSuffix=prefersDarkColorScheme?"-dark":"";const iconColor=printerStatusReason===null?"grey":PRINTER_STATUS_REASON_COLOR_MAP.get(printerStatusReason);assert(iconColor);return`${printerTypePrefix}${iconColor}${darkModeSuffix}`}function getStatusTextColorClass(printerStatusReason){if(printerStatusReason===null){return""}const color=PRINTER_STATUS_REASON_COLOR_MAP.get(printerStatusReason);assert(color);return`status-${color}`}
// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var DestinationOrigin;(function(DestinationOrigin){DestinationOrigin["LOCAL"]="local";DestinationOrigin["COOKIES"]="cookies";DestinationOrigin["DEVICE"]="device";DestinationOrigin["PRIVET"]="privet";DestinationOrigin["EXTENSION"]="extension";DestinationOrigin["CROS"]="chrome_os"})(DestinationOrigin||(DestinationOrigin={}));var PrinterType;(function(PrinterType){PrinterType[PrinterType["EXTENSION_PRINTER"]=0]="EXTENSION_PRINTER";PrinterType[PrinterType["PDF_PRINTER"]=1]="PDF_PRINTER";PrinterType[PrinterType["LOCAL_PRINTER"]=2]="LOCAL_PRINTER"})(PrinterType||(PrinterType={}));var DestinationProvisionalType;(function(DestinationProvisionalType){DestinationProvisionalType["NONE"]="NONE";DestinationProvisionalType["NEEDS_USB_PERMISSION"]="NEEDS_USB_PERMISSION"})(DestinationProvisionalType||(DestinationProvisionalType={}));var ColorMode;(function(ColorMode){ColorMode[ColorMode["GRAY"]=1]="GRAY";ColorMode[ColorMode["COLOR"]=2]="COLOR"})(ColorMode||(ColorMode={}));function isPdfPrinter(id){if(id===GooglePromotedDestinationId.SAVE_TO_DRIVE_CROS){return true}return id===GooglePromotedDestinationId.SAVE_AS_PDF}function makeRecentDestination(destination){return{id:destination.id,origin:destination.origin,capabilities:destination.capabilities,displayName:destination.displayName||"",extensionId:destination.extensionId||"",extensionName:destination.extensionName||"",icon:destination.icon||""}}function createDestinationKey(id,origin){return`${id}/${origin}/`}function createRecentDestinationKey(recentDestination){return createDestinationKey(recentDestination.id,recentDestination.origin)}function createDefaultAllowedManagedPrintOptionsApplied(){return{mediaSize:false,mediaType:false,duplex:false,color:false,dpi:false,quality:false,printAsImage:false}}const COLOR_TYPES=["STANDARD_COLOR","CUSTOM_COLOR"];const MONOCHROME_TYPES=["STANDARD_MONOCHROME","CUSTOM_MONOCHROME"];class Destination{constructor(id,origin,displayName,params){this.capabilities_=null;this.location_="";this.eulaUrl_="";this.printerManuallySelected_=false;this.printerStatusReason_=null;this.printerStatusRequestedPromise_=null;this.printerStatusRetrySent_=false;this.printerStatusRetryTimerMs_=3e3;this.managedPrintOptions_=null;this.id_=id;this.origin_=origin;this.displayName_=displayName||"";this.isEnterprisePrinter_=params&&params.isEnterprisePrinter||false;this.description_=params&&params.description||"";this.extensionId_=params&&params.extensionId||"";this.extensionName_=params&&params.extensionName||"";this.location_=params&&params.location||"";this.type_=this.computeType_(id,origin);this.provisionalType_=params&&params.provisionalType||DestinationProvisionalType.NONE;assert(this.provisionalType_!==DestinationProvisionalType.NEEDS_USB_PERMISSION||this.isExtension,"Provisional USB destination only supported with extension origin.");this.managedPrintOptions_=params&&params.managedPrintOptions||null;this.allowedManagedPrintOptionsApplied=createDefaultAllowedManagedPrintOptionsApplied()}computeType_(id,origin){if(isPdfPrinter(id)){return PrinterType.PDF_PRINTER}return origin===DestinationOrigin.EXTENSION?PrinterType.EXTENSION_PRINTER:PrinterType.LOCAL_PRINTER}get type(){return this.type_}get id(){return this.id_}get origin(){return this.origin_}get displayName(){return this.displayName_}get isExtension(){return this.origin_===DestinationOrigin.EXTENSION}get hint(){return this.location_||this.extensionName||this.description_}get extensionId(){return this.extensionId_}get extensionName(){return this.extensionName_}get capabilities(){return this.capabilities_}set capabilities(capabilities){if(capabilities){this.capabilities_=capabilities}}get eulaUrl(){return this.eulaUrl_}set eulaUrl(eulaUrl){this.eulaUrl_=eulaUrl}get printerManuallySelected(){return this.printerManuallySelected_}set printerManuallySelected(printerManuallySelected){this.printerManuallySelected_=printerManuallySelected}get printerStatusReason(){return this.printerStatusReason_}set printerStatusReason(printerStatusReason){this.printerStatusReason_=printerStatusReason}setPrinterStatusRetryTimeoutForTesting(timeoutMs){this.printerStatusRetryTimerMs_=timeoutMs}requestPrinterStatus(){if(this.origin_!==DestinationOrigin.CROS){return Promise.reject()}if(this.printerStatusReason_){return Promise.resolve(this.key)}if(this.printerStatusRequestedPromise_){return this.printerStatusRequestedPromise_}this.printerStatusRequestedPromise_=this.requestPrinterStatusPromise_();return this.printerStatusRequestedPromise_}requestPrinterStatusPromise_(){return NativeLayerCrosImpl.getInstance().requestPrinterStatusUpdate(this.id_).then((status=>{if(status){const statusReason=getStatusReasonFromPrinterStatus(status);const isPrinterUnreachable=statusReason===PrinterStatusReason.PRINTER_UNREACHABLE;if(isPrinterUnreachable&&!this.printerStatusRetrySent_){this.printerStatusRetrySent_=true;return this.printerStatusWaitForTimerPromise_()}this.printerStatusReason_=statusReason}return Promise.resolve(this.key)}))}printerStatusWaitForTimerPromise_(){return new Promise(((resolve,_reject)=>{setTimeout((()=>{resolve()}),this.printerStatusRetryTimerMs_)})).then((()=>this.requestPrinterStatusPromise_()))}get readyForSelection(){return(this.origin_!==DestinationOrigin.CROS||this.capabilities_!==null)&&!this.isProvisional}get provisionalType(){return this.provisionalType_}get isProvisional(){return this.provisionalType_!==DestinationProvisionalType.NONE}get managedPrintOptions(){return this.managedPrintOptions_}allowedManagedPrintOptionsAppliedForAnySetting(){return this.allowedManagedPrintOptionsApplied.mediaSize||this.allowedManagedPrintOptionsApplied.mediaType||this.allowedManagedPrintOptionsApplied.duplex||this.allowedManagedPrintOptionsApplied.color||this.allowedManagedPrintOptionsApplied.dpi||this.allowedManagedPrintOptionsApplied.quality||this.allowedManagedPrintOptionsApplied.printAsImage}applyAllowedManagedPrintOptions(){this.allowedManagedPrintOptionsApplied=createDefaultAllowedManagedPrintOptionsApplied();if(!this.managedPrintOptions_){return}assert(this.capabilities_);if(this.capabilities_.printer.media_size&&this.managedPrintOptions_.mediaSize?.allowedValues&&this.managedPrintOptions_.mediaSize.allowedValues.length>0){const allowedMediaSizeValues=this.managedPrintOptions_.mediaSize.allowedValues;const allowedSupportedValues=this.capabilities_.printer.media_size.option.filter((supportedValue=>allowedMediaSizeValues.some((allowedValue=>supportedValue.width_microns===allowedValue.width&&supportedValue.height_microns===allowedValue.height))));if(allowedSupportedValues.length>0&&allowedSupportedValues.length<this.capabilities_.printer.media_size.option.length){this.capabilities_.printer.media_size.option=allowedSupportedValues;this.allowedManagedPrintOptionsApplied.mediaSize=true}}if(this.capabilities_.printer.media_type&&this.managedPrintOptions_.mediaType?.allowedValues&&this.managedPrintOptions_.mediaType.allowedValues.length>0){const allowedMediaTypeValues=this.managedPrintOptions_.mediaType.allowedValues;const allowedSupportedValues=this.capabilities_.printer.media_type.option.filter((supportedValue=>allowedMediaTypeValues.some((allowedValue=>supportedValue.vendor_id===allowedValue))));if(allowedSupportedValues.length>0&&allowedSupportedValues.length<this.capabilities_.printer.media_type.option.length){this.capabilities_.printer.media_type.option=allowedSupportedValues;this.allowedManagedPrintOptionsApplied.mediaType=true}}if(this.capabilities_.printer.duplex&&this.managedPrintOptions_.duplex?.allowedValues&&this.managedPrintOptions_.duplex.allowedValues.length>0){const allowedDuplexValues=this.managedPrintOptions_.duplex.allowedValues;const allowedSupportedValues=this.capabilities_.printer.duplex.option.filter((supportedValue=>allowedDuplexValues.some((allowedValue=>supportedValue.type===managedPrintOptionsDuplexToCdd(allowedValue)))));if(allowedSupportedValues.length>0&&allowedSupportedValues.length<this.capabilities_.printer.duplex.option.length){this.capabilities_.printer.duplex.option=allowedSupportedValues;this.allowedManagedPrintOptionsApplied.duplex=true}}if(this.hasColorCapability&&this.managedPrintOptions_.color?.allowedValues&&this.managedPrintOptions_.color.allowedValues.length>0){const allowedColorValues=this.managedPrintOptions_.color.allowedValues;const allowedSupportedValues=this.capabilities_.printer.color.option.filter((supportedValue=>allowedColorValues.some((allowedValue=>{const typesToLookFor=allowedValue?COLOR_TYPES:MONOCHROME_TYPES;return typesToLookFor.includes(supportedValue.type)}))));if(allowedSupportedValues.length>0&&allowedSupportedValues.length<this.capabilities_.printer.color.option.length){this.capabilities_.printer.color.option=allowedSupportedValues;this.allowedManagedPrintOptionsApplied.color=true}}if(this.capabilities_.printer.dpi&&this.managedPrintOptions_.dpi?.allowedValues&&this.managedPrintOptions_.dpi.allowedValues.length>0){const allowedDpiValues=this.managedPrintOptions_.dpi.allowedValues;const allowedSupportedValues=this.capabilities_.printer.dpi.option.filter((supportedValue=>allowedDpiValues.some((allowedValue=>supportedValue.horizontal_dpi===allowedValue.horizontal&&supportedValue.vertical_dpi===allowedValue.vertical))));if(allowedSupportedValues.length>0&&allowedSupportedValues.length<this.capabilities_.printer.dpi.option.length){this.capabilities_.printer.dpi.option=allowedSupportedValues;this.allowedManagedPrintOptionsApplied.dpi=true}}if(this.capabilities_.printer.vendor_capability&&this.managedPrintOptions_.quality?.allowedValues&&this.managedPrintOptions_.quality.allowedValues.length>0){const allowedQualityValues=this.managedPrintOptions_.quality.allowedValues;const printQualityCapability=this.capabilities_.printer.vendor_capability.find((o=>o.id===IPP_PRINT_QUALITY));if(printQualityCapability?.select_cap?.option){const allowedSupportedValues=printQualityCapability.select_cap.option.filter((supportedValue=>allowedQualityValues.some((allowedValue=>supportedValue.value===managedPrintOptionsQualityToIpp(allowedValue)))));if(allowedSupportedValues.length>0&&allowedSupportedValues.length<printQualityCapability.select_cap.option.length){printQualityCapability.select_cap.option=allowedSupportedValues;this.allowedManagedPrintOptionsApplied.quality=true}}}}get icon(){if(this.id_===GooglePromotedDestinationId.SAVE_TO_DRIVE_CROS){return"print-preview:save-to-drive"}if(this.id_===GooglePromotedDestinationId.SAVE_AS_PDF){return"cr:insert-drive-file"}if(this.isEnterprisePrinter){return"print-preview:business"}return"print-preview:print"}get extraPropertiesToMatch(){return[this.location_,this.description_]}matches(query){return!!this.displayName_.match(query)||!!this.extensionName_.match(query)||!!this.location_.match(query)||!!this.description_.match(query)}get isEnterprisePrinter(){return this.isEnterprisePrinter_}copiesCapability_(){return this.capabilities&&this.capabilities.printer&&this.capabilities.printer.copies?this.capabilities.printer.copies:null}colorCapability_(){return this.capabilities&&this.capabilities.printer&&this.capabilities.printer.color?this.capabilities.printer.color:null}get hasCopiesCapability(){const capability=this.copiesCapability_();if(!capability){return false}return capability.max?capability.max>1:true}get hasColorCapability(){const capability=this.colorCapability_();if(!capability||!capability.option){return false}let hasColor=false;let hasMonochrome=false;capability.option.forEach((option=>{assert(option.type);hasColor=hasColor||COLOR_TYPES.includes(option.type);hasMonochrome=hasMonochrome||MONOCHROME_TYPES.includes(option.type)}));return hasColor&&hasMonochrome}getNativeColorModel(isColor){const capability=this.colorCapability_();if(!capability||!capability.option){return isColor?ColorMode.COLOR:ColorMode.GRAY}const selected=this.getColor(isColor);const mode=parseInt(selected?selected.vendor_id:"",10);if(isNaN(mode)){return isColor?ColorMode.COLOR:ColorMode.GRAY}return mode}get defaultColorOption(){const capability=this.colorCapability_();if(!capability||!capability.option){return null}const defaultOptions=capability.option.filter((option=>option.is_default));return defaultOptions.length!==0?defaultOptions[0]:null}getColor(isColor){const typesToLookFor=isColor?COLOR_TYPES:MONOCHROME_TYPES;const capability=this.colorCapability_();if(!capability||!capability.option){return null}for(let i=0;i<typesToLookFor.length;i++){const matchingOptions=capability.option.filter((option=>option.type===typesToLookFor[i]));if(matchingOptions.length>0){return matchingOptions[0]}}return null}getMediaSize(width,height){return this.capabilities?.printer.media_size?.option.find((o=>o.width_microns===width&&o.height_microns===height))}getMediaType(vendorId){return this.capabilities?.printer.media_type?.option.find((o=>o.vendor_id===vendorId))}getDpi(horizontal,vertical){return this.capabilities?.printer.dpi?.option.find((o=>o.horizontal_dpi===horizontal&&o.vertical_dpi===vertical))}supportsDuplex(duplex){const availableDuplexOptions=this.capabilities?.printer.duplex?.option;if(!availableDuplexOptions){return false}return availableDuplexOptions.some((o=>o.type===duplex))}get key(){return`${this.id_}/${this.origin_}/`}}var GooglePromotedDestinationId;(function(GooglePromotedDestinationId){GooglePromotedDestinationId["SAVE_AS_PDF"]="Save as PDF";GooglePromotedDestinationId["SAVE_TO_DRIVE_CROS"]="Save to Drive CrOS"})(GooglePromotedDestinationId||(GooglePromotedDestinationId={}));const PDF_DESTINATION_KEY=`${GooglePromotedDestinationId.SAVE_AS_PDF}/${DestinationOrigin.LOCAL}/`;const SAVE_TO_DRIVE_CROS_DESTINATION_KEY=`${GooglePromotedDestinationId.SAVE_TO_DRIVE_CROS}/${DestinationOrigin.LOCAL}/`;
// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var BackgroundGraphicsModeRestriction;(function(BackgroundGraphicsModeRestriction){BackgroundGraphicsModeRestriction[BackgroundGraphicsModeRestriction["UNSET"]=0]="UNSET";BackgroundGraphicsModeRestriction[BackgroundGraphicsModeRestriction["ENABLED"]=1]="ENABLED";BackgroundGraphicsModeRestriction[BackgroundGraphicsModeRestriction["DISABLED"]=2]="DISABLED"})(BackgroundGraphicsModeRestriction||(BackgroundGraphicsModeRestriction={}));var ColorModeRestriction;(function(ColorModeRestriction){ColorModeRestriction[ColorModeRestriction["UNSET"]=0]="UNSET";ColorModeRestriction[ColorModeRestriction["MONOCHROME"]=1]="MONOCHROME";ColorModeRestriction[ColorModeRestriction["COLOR"]=2]="COLOR"})(ColorModeRestriction||(ColorModeRestriction={}));var DuplexModeRestriction;(function(DuplexModeRestriction){DuplexModeRestriction[DuplexModeRestriction["UNSET"]=0]="UNSET";DuplexModeRestriction[DuplexModeRestriction["SIMPLEX"]=1]="SIMPLEX";DuplexModeRestriction[DuplexModeRestriction["LONG_EDGE"]=2]="LONG_EDGE";DuplexModeRestriction[DuplexModeRestriction["SHORT_EDGE"]=4]="SHORT_EDGE";DuplexModeRestriction[DuplexModeRestriction["DUPLEX"]=6]="DUPLEX"})(DuplexModeRestriction||(DuplexModeRestriction={}));var PinModeRestriction;(function(PinModeRestriction){PinModeRestriction[PinModeRestriction["UNSET"]=0]="UNSET";PinModeRestriction[PinModeRestriction["PIN"]=1]="PIN";PinModeRestriction[PinModeRestriction["NO_PIN"]=2]="NO_PIN"})(PinModeRestriction||(PinModeRestriction={}));class NativeLayerImpl{getInitialSettings(){return sendWithPromise("getInitialSettings")}getPrinters(type){return sendWithPromise("getPrinters",type)}getPrinterCapabilities(destinationId,type){return sendWithPromise("getPrinterCapabilities",destinationId,type)}getPreview(printTicket){return sendWithPromise("getPreview",printTicket)}managePrinters(){chrome.send("managePrinters")}doPrint(printTicket){return sendWithPromise("doPrint",printTicket)}cancelPendingPrintRequest(){chrome.send("cancelPendingPrintRequest")}saveAppState(appStateStr){chrome.send("saveAppState",[appStateStr])}dialogClose(isCancel){if(isCancel){chrome.send("closePrintPreviewDialog")}chrome.send("dialogClose")}hidePreview(){chrome.send("hidePreview")}recordInHistogram(histogram,bucket,maxBucket){chrome.send("metricsHandler:recordInHistogram",[histogram,bucket,maxBucket])}recordBooleanHistogram(histogram,value){chrome.send("metricsHandler:recordBooleanHistogram",[histogram,value])}static getInstance(){return instance$8||(instance$8=new NativeLayerImpl)}static setInstance(obj){instance$8=obj}}let instance$8=null;
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class DestinationMatch{constructor(idRegExp,displayNameRegExp){this.idRegExp_=idRegExp;this.displayNameRegExp_=displayNameRegExp}match(destination){if(this.idRegExp_&&!this.idRegExp_.test(destination.id)){return false}if(this.displayNameRegExp_&&!this.displayNameRegExp_.test(destination.displayName)){return false}if(destination.type===PrinterType.PDF_PRINTER){return false}return true}}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const isMac=/Mac/.test(navigator.platform);const isChromeOS=(()=>{let returnValue=false;returnValue=true;return returnValue})();
// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function parseDestination(type,printer){if(type===PrinterType.LOCAL_PRINTER||type===PrinterType.PDF_PRINTER){return parseLocalDestination(printer)}if(type===PrinterType.EXTENSION_PRINTER){return parseExtensionDestination(printer)}assertNotReached("Unknown printer type "+type)}function parseLocalDestination(destinationInfo){const options={description:destinationInfo.printerDescription,isEnterprisePrinter:destinationInfo.cupsEnterprisePrinter,location:""};const locationOptions=new Set(["location","printer-location"]);if(destinationInfo.printerOptions){for(const printerOption of Object.keys(destinationInfo.printerOptions)){if(locationOptions.has(printerOption)){options.location=destinationInfo.printerOptions[printerOption]||""}}}if(destinationInfo.managedPrintOptions){options.managedPrintOptions=destinationInfo.managedPrintOptions}return new Destination(destinationInfo.deviceName,isChromeOS?DestinationOrigin.CROS:DestinationOrigin.LOCAL,destinationInfo.printerName,options)}function parseExtensionDestination(destinationInfo){const provisionalType=destinationInfo.provisional?DestinationProvisionalType.NEEDS_USB_PERMISSION:DestinationProvisionalType.NONE;return new Destination(destinationInfo.id,DestinationOrigin.EXTENSION,destinationInfo.name,{description:destinationInfo.description||"",extensionId:destinationInfo.extensionId,extensionName:destinationInfo.extensionName||"",provisionalType:provisionalType})}
// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var DestinationStorePrinterSearchStatus;(function(DestinationStorePrinterSearchStatus){DestinationStorePrinterSearchStatus["START"]="start";DestinationStorePrinterSearchStatus["SEARCHING"]="searching";DestinationStorePrinterSearchStatus["DONE"]="done"})(DestinationStorePrinterSearchStatus||(DestinationStorePrinterSearchStatus={}));var DestinationErrorType;(function(DestinationErrorType){DestinationErrorType[DestinationErrorType["INVALID"]=0]="INVALID";DestinationErrorType[DestinationErrorType["NO_DESTINATIONS"]=1]="NO_DESTINATIONS"})(DestinationErrorType||(DestinationErrorType={}));function localizeCapabilities(capabilities){if(!capabilities.printer){return capabilities}const mediaSize=capabilities.printer.media_size;if(!mediaSize){return capabilities}for(let i=0,media;media=mediaSize.option[i];i++){if(!media.custom_display_name_localized){media.custom_display_name=media.custom_display_name||MEDIA_DISPLAY_NAMES_[media.name]||media.name}}return capabilities}function compareMediaNames(a,b){const nameA=a.custom_display_name_localized||a.custom_display_name||"";const nameB=b.custom_display_name_localized||b.custom_display_name||"";return nameA===nameB?0:nameA>nameB?1:-1}function sortMediaSizes(capabilities){if(!capabilities.printer){return capabilities}const mediaSize=capabilities.printer.media_size;if(!mediaSize){return capabilities}const categoryStandardNA=[];const categoryStandardCN=[];const categoryStandardISO=[];const categoryStandardJP=[];const categoryStandardMisc=[];const categoryCustom=[];for(let i=0,media;media=mediaSize.option[i];i++){const name=media.name||"CUSTOM";let category;if(name.startsWith("NA_")){category=categoryStandardNA}else if(name.startsWith("PRC_")||name.startsWith("ROC_")||name==="OM_DAI_PA_KAI"||name==="OM_JUURO_KU_KAI"||name==="OM_PA_KAI"){category=categoryStandardCN}else if(name.startsWith("ISO_")){category=categoryStandardISO}else if(name.startsWith("JIS_")||name.startsWith("JPN_")){category=categoryStandardJP}else if(name.startsWith("OM_")){category=categoryStandardMisc}else{assert(name==="CUSTOM","Unknown media size. Assuming custom");category=categoryCustom}category.push(media)}categoryStandardNA.sort(compareMediaNames);categoryStandardCN.sort(compareMediaNames);categoryStandardISO.sort(compareMediaNames);categoryStandardJP.sort(compareMediaNames);categoryStandardMisc.sort(compareMediaNames);categoryCustom.sort(compareMediaNames);mediaSize.option=categoryStandardNA;mediaSize.option.push(...categoryStandardCN,...categoryStandardISO,...categoryStandardJP,...categoryStandardMisc,...categoryCustom);return capabilities}var DestinationStoreEventType;(function(DestinationStoreEventType){DestinationStoreEventType["DESTINATION_SEARCH_DONE"]="DestinationStore.DESTINATION_SEARCH_DONE";DestinationStoreEventType["DESTINATION_SELECT"]="DestinationStore.DESTINATION_SELECT";DestinationStoreEventType["DESTINATIONS_INSERTED"]="DestinationStore.DESTINATIONS_INSERTED";DestinationStoreEventType["ERROR"]="DestinationStore.ERROR";DestinationStoreEventType["SELECTED_DESTINATION_CAPABILITIES_READY"]="DestinationStore.SELECTED_DESTINATION_CAPABILITIES_READY";DestinationStoreEventType["DESTINATION_EULA_READY"]="DestinationStore.DESTINATION_EULA_READY";DestinationStoreEventType["DESTINATION_PRINTER_STATUS_UPDATE"]="DestinationStore.DESTINATION_PRINTER_STATUS_UPDATE"})(DestinationStoreEventType||(DestinationStoreEventType={}));class DestinationStore extends EventTarget{constructor(addListenerCallback){super();this.autoSelectMatchingDestination_=null;this.destinationMap_=new Map;this.destinations_=[];this.initialDestinationSelected_=false;this.nativeLayer_=NativeLayerImpl.getInstance();this.nativeLayerCros_=NativeLayerCrosImpl.getInstance();this.pdfPrinterEnabled_=false;this.recentDestinationKeys_=[];this.selectedDestination_=null;this.systemDefaultDestinationKey_="";this.tracker_=new EventTracker;this.typesToSearch_=new Set;this.destinationSearchStatus_=new Map([[PrinterType.EXTENSION_PRINTER,DestinationStorePrinterSearchStatus.START],[PrinterType.LOCAL_PRINTER,DestinationStorePrinterSearchStatus.START]]);this.useSystemDefaultAsDefault_=loadTimeData.getBoolean("useSystemDefaultPrinter");addListenerCallback("printers-added",((type,printers)=>this.onPrintersAdded_(type,printers)));addListenerCallback("local-printers-updated",(printers=>this.onLocalPrintersUpdated_(printers)))}destinations(){return this.destinations_.slice()}get isPrintDestinationSearchInProgress(){return Array.from(this.destinationSearchStatus_.values()).some((el=>el===DestinationStorePrinterSearchStatus.SEARCHING))}get selectedDestination(){return this.selectedDestination_}getPrinterTypeForRecentDestination_(destination){if(isPdfPrinter(destination.id)){return PrinterType.PDF_PRINTER}if(destination.origin===DestinationOrigin.LOCAL||destination.origin===DestinationOrigin.CROS){return PrinterType.LOCAL_PRINTER}assert(destination.origin===DestinationOrigin.EXTENSION);return PrinterType.EXTENSION_PRINTER}init(pdfPrinterDisabled,saveToDriveDisabled,systemDefaultDestinationId,serializedDefaultDestinationSelectionRulesStr,recentDestinations){if(systemDefaultDestinationId){const systemDefaultVirtual=isPdfPrinter(systemDefaultDestinationId);const systemDefaultType=systemDefaultVirtual?PrinterType.PDF_PRINTER:PrinterType.LOCAL_PRINTER;const systemDefaultOrigin=systemDefaultVirtual?DestinationOrigin.LOCAL:DestinationOrigin.CROS;this.systemDefaultDestinationKey_=createDestinationKey(systemDefaultDestinationId,systemDefaultOrigin);this.typesToSearch_.add(systemDefaultType)}this.recentDestinationKeys_=recentDestinations.map((destination=>createRecentDestinationKey(destination)));for(const recent of recentDestinations){this.typesToSearch_.add(this.getPrinterTypeForRecentDestination_(recent))}this.autoSelectMatchingDestination_=this.convertToDestinationMatch_(serializedDefaultDestinationSelectionRulesStr);if(this.autoSelectMatchingDestination_){this.typesToSearch_.add(PrinterType.EXTENSION_PRINTER);this.typesToSearch_.add(PrinterType.LOCAL_PRINTER)}this.pdfPrinterEnabled_=!pdfPrinterDisabled;this.createLocalPdfPrintDestination_();if(!saveToDriveDisabled){this.createLocalDrivePrintDestination_()}if(this.typesToSearch_.size===0){this.tryToSelectInitialDestination_();this.observeLocalPrinters_();return}for(const printerType of this.typesToSearch_){this.startLoadDestinations_(printerType)}window.setTimeout((()=>{this.tryToSelectInitialDestination_(true)}),1e4)}tryToSelectInitialDestination_(timeoutExpired=false){if(this.initialDestinationSelected_){return}const success=this.selectInitialDestination_(timeoutExpired);if(!success&&!this.isPrintDestinationSearchInProgress&&this.typesToSearch_.size===0){this.dispatchEvent(new CustomEvent(DestinationStoreEventType.ERROR,{detail:DestinationErrorType.NO_DESTINATIONS}))}this.initialDestinationSelected_=success}selectDefaultDestination(){if(this.tryToSelectDestinationByKey_(this.systemDefaultDestinationKey_)){return}this.selectFinalFallbackDestination_()}selectInitialDestination_(timeoutExpired){const searchInProgress=this.typesToSearch_.size!==0&&!timeoutExpired;if(this.useSystemDefaultAsDefault_){if(this.tryToSelectDestinationByKey_(this.systemDefaultDestinationKey_)){return true}if(searchInProgress){return false}}for(const key of this.recentDestinationKeys_){if(this.tryToSelectDestinationByKey_(key)){return true}else if(searchInProgress){return false}}if(this.autoSelectMatchingDestination_){for(const destination of this.destinations_){if(this.autoSelectMatchingDestination_.match(destination)){this.selectDestination(destination);return true}}if(searchInProgress){return false}}if(this.tryToSelectDestinationByKey_(this.systemDefaultDestinationKey_)){return true}if(searchInProgress){return false}if(this.selectFinalFallbackDestination_()){return true}return false}tryToSelectDestinationByKey_(key){const candidate=this.destinationMap_.get(key);if(candidate){this.selectDestination(candidate);return true}return false}resetTracker(){this.tracker_.removeAll()}fetchEulaUrl(destinationId){this.nativeLayerCros_.getEulaUrl(destinationId).then((response=>{if(this.selectedDestination_&&destinationId===this.selectedDestination_.id){this.dispatchEvent(new CustomEvent(DestinationStoreEventType.DESTINATION_EULA_READY,{detail:response}))}}))}reloadLocalPrinters(){return this.nativeLayer_.getPrinters(PrinterType.LOCAL_PRINTER)}convertToDestinationMatch_(serializedDefaultDestinationSelectionRulesStr){let matchRules=null;try{if(serializedDefaultDestinationSelectionRulesStr){matchRules=JSON.parse(serializedDefaultDestinationSelectionRulesStr)}}catch(e){console.warn("Failed to parse defaultDestinationSelectionRules: "+e)}if(!matchRules){return null}const isLocal=!matchRules.kind||matchRules.kind==="local";if(!isLocal){console.warn('Unsupported type: "'+matchRules.kind+'"');return null}let idRegExp=null;try{if(matchRules.idPattern){idRegExp=new RegExp(matchRules.idPattern||".*")}}catch(e){console.warn('Failed to parse regexp for "id": '+e)}let displayNameRegExp=null;try{if(matchRules.namePattern){displayNameRegExp=new RegExp(matchRules.namePattern||".*")}}catch(e){console.warn('Failed to parse regexp for "name": '+e)}return new DestinationMatch(idRegExp,displayNameRegExp)}selectDestinationByKey(key){const success=this.tryToSelectDestinationByKey_(key);assert(success);if(success&&this.selectedDestination_&&this.selectedDestination_.type!==PrinterType.PDF_PRINTER){this.selectedDestination_.printerManuallySelected=true}}selectDestination(destination,refreshDestination=false){if(destination===this.selectedDestination_&&!refreshDestination){return}if(destination===null){this.selectedDestination_=null;this.dispatchEvent(new CustomEvent(DestinationStoreEventType.DESTINATION_SELECT));return}assert(!destination.isProvisional,"Unable to select provisonal destinations");this.selectedDestination_=destination;this.dispatchEvent(new CustomEvent(DestinationStoreEventType.DESTINATION_SELECT));if(destination.capabilities===null){this.nativeLayer_.getPrinterCapabilities(destination.id,destination.type).then((caps=>this.onCapabilitiesSet_(destination.origin,destination.id,caps)),(()=>this.onGetCapabilitiesFail_(destination.origin,destination.id)))}else{this.sendSelectedDestinationUpdateEvent_()}}resolveCrosDestination(destination){assert(destination.origin===DestinationOrigin.CROS);return this.nativeLayerCros_.setupPrinter(destination.id)}resolveProvisionalDestination(destination){assert(destination.provisionalType===DestinationProvisionalType.NEEDS_USB_PERMISSION,"Provisional type cannot be resolved.");return this.nativeLayerCros_.grantExtensionPrinterAccess(destination.id).then((destinationInfo=>{this.removeProvisionalDestination_(destination.id);const parsedDestination=parseExtensionDestination(destinationInfo);this.insertIntoStore_(parsedDestination);return parsedDestination}),(()=>{this.removeProvisionalDestination_(destination.id);return null}))}selectFinalFallbackDestination_(){if(this.pdfPrinterEnabled_){const destination=this.destinationMap_.get(PDF_DESTINATION_KEY);assert(destination);this.selectDestination(destination);return true}if(this.destinations_.length>0){this.selectDestination(this.destinations_[0]);return true}this.startLoadAllDestinations();return false}startLoadDestinations_(type){if(this.destinationSearchStatus_.get(type)===DestinationStorePrinterSearchStatus.DONE){return}this.destinationSearchStatus_.set(type,DestinationStorePrinterSearchStatus.SEARCHING);this.nativeLayer_.getPrinters(type).then((()=>this.onDestinationSearchDone_(type)))}startLoadAllDestinations(){const types=[PrinterType.EXTENSION_PRINTER,PrinterType.LOCAL_PRINTER];for(const printerType of types){this.startLoadDestinations_(printerType)}}getDestinationByKey(key){return this.destinationMap_.get(key)}removeProvisionalDestination_(provisionalId){this.destinations_=this.destinations_.filter((el=>{if(el.id===provisionalId){this.destinationMap_.delete(el.key);return false}return true}))}insertDestination_(destination){if(this.insertIntoStore_(destination)){this.destinationsInserted_()}}insertDestinations_(destinations){let inserted=false;destinations.forEach((destination=>{if(destination){inserted=this.insertIntoStore_(destination)||inserted}}));if(inserted){this.destinationsInserted_()}}destinationsInserted_(){this.dispatchEvent(new CustomEvent(DestinationStoreEventType.DESTINATIONS_INSERTED));this.tryToSelectInitialDestination_()}sendSelectedDestinationUpdateEvent_(){this.dispatchEvent(new CustomEvent(DestinationStoreEventType.SELECTED_DESTINATION_CAPABILITIES_READY))}updateDestination_(destination){assert(destination.constructor!==Array,"Single printer expected");assert(destination.capabilities);if(loadTimeData.getBoolean("isUseManagedPrintJobOptionsInPrintPreviewEnabled")){destination.applyAllowedManagedPrintOptions()}destination.capabilities=localizeCapabilities(destination.capabilities);if(destination.type!==PrinterType.LOCAL_PRINTER){destination.capabilities=sortMediaSizes(destination.capabilities)}const existingDestination=this.destinationMap_.get(destination.key);if(existingDestination!==undefined){existingDestination.capabilities=destination.capabilities}else{this.insertDestination_(destination)}if(this.selectedDestination_&&(existingDestination===this.selectedDestination_||destination===this.selectedDestination_)){this.sendSelectedDestinationUpdateEvent_()}}insertIntoStore_(destination){const key=destination.key;const existingDestination=this.destinationMap_.get(key);if(existingDestination===undefined){this.destinations_.push(destination);this.destinationMap_.set(key,destination);return true}return false}createLocalPdfPrintDestination_(){if(this.pdfPrinterEnabled_){this.insertDestination_(new Destination(GooglePromotedDestinationId.SAVE_AS_PDF,DestinationOrigin.LOCAL,loadTimeData.getString("printToPDF")))}if(this.typesToSearch_.has(PrinterType.PDF_PRINTER)){this.typesToSearch_.delete(PrinterType.PDF_PRINTER)}}createLocalDrivePrintDestination_(){this.insertDestination_(new Destination(GooglePromotedDestinationId.SAVE_TO_DRIVE_CROS,DestinationOrigin.LOCAL,loadTimeData.getString("printToGoogleDrive")))}onDestinationSearchDone_(type){this.destinationSearchStatus_.set(type,DestinationStorePrinterSearchStatus.DONE);this.dispatchEvent(new CustomEvent(DestinationStoreEventType.DESTINATION_SEARCH_DONE));if(this.typesToSearch_.has(type)){this.typesToSearch_.delete(type);this.tryToSelectInitialDestination_()}else if(this.typesToSearch_.size===0){this.tryToSelectInitialDestination_()}this.observeLocalPrinters_()}onCapabilitiesSet_(origin,id,settingsInfo){let dest=null;const key=createDestinationKey(id,origin);dest=this.destinationMap_.get(key);if(!dest){if(!settingsInfo.printer){assert(origin===DestinationOrigin.EXTENSION);return}assert(settingsInfo.printer);const typeToParse=origin===DestinationOrigin.EXTENSION?PrinterType.EXTENSION_PRINTER:PrinterType.LOCAL_PRINTER;dest=parseDestination(typeToParse,settingsInfo.printer)}if(dest){if(dest.type!==PrinterType.EXTENSION_PRINTER&&dest.capabilities){return}dest.capabilities=settingsInfo.capabilities;this.updateDestination_(dest);this.fetchEulaUrl(dest.id)}}onGetCapabilitiesFail_(_origin,destinationId){console.warn("Failed to get print capabilities for printer "+destinationId);if(this.selectedDestination_&&this.selectedDestination_.id===destinationId){this.dispatchEvent(new CustomEvent(DestinationStoreEventType.ERROR,{detail:DestinationErrorType.INVALID}))}}onPrintersAdded_(type,printers){this.insertDestinations_(printers.map((printer=>parseDestination(type,printer))))}observeLocalPrinters_(){this.nativeLayerCros_.observeLocalPrinters().then((printers=>this.onLocalPrintersUpdated_(printers)))}onLocalPrintersUpdated_(printers){if(!printers){return}this.insertDestinations_(printers.map((printer=>parseDestination(PrinterType.LOCAL_PRINTER,printer))));for(const printer of printers){this.parsePrinterStatus(printer)}}parsePrinterStatus(destinationInfo){const printerStatus=destinationInfo.printerStatus;if(!printerStatus||!printerStatus.printerId){return}const destinationKey=createDestinationKey(destinationInfo.deviceName,DestinationOrigin.CROS);const existingDestination=this.destinationMap_.get(destinationKey);if(existingDestination===undefined){return}const previousStatusReason=existingDestination.printerStatusReason;const nextStatusReason=getStatusReasonFromPrinterStatus(printerStatus);const nowOnline=previousStatusReason===PrinterStatusReason.PRINTER_UNREACHABLE&&(nextStatusReason!==PrinterStatusReason.PRINTER_UNREACHABLE&&nextStatusReason!==PrinterStatusReason.UNKNOWN_REASON);existingDestination.printerStatusReason=nextStatusReason;this.dispatchEvent(new CustomEvent(DestinationStoreEventType.DESTINATION_PRINTER_STATUS_UPDATE,{detail:{destinationKey:destinationKey,nowOnline:nowOnline}}))}}const MEDIA_DISPLAY_NAMES_={ISO_2A0:"2A0",ISO_A0:"A0",ISO_A0X3:"A0x3",ISO_A1:"A1",ISO_A10:"A10",ISO_A1X3:"A1x3",ISO_A1X4:"A1x4",ISO_A2:"A2",ISO_A2X3:"A2x3",ISO_A2X4:"A2x4",ISO_A2X5:"A2x5",ISO_A3:"A3",ISO_A3X3:"A3x3",ISO_A3X4:"A3x4",ISO_A3X5:"A3x5",ISO_A3X6:"A3x6",ISO_A3X7:"A3x7",ISO_A3_EXTRA:"A3 Extra",ISO_A4:"A4",ISO_A4X3:"A4x3",ISO_A4X4:"A4x4",ISO_A4X5:"A4x5",ISO_A4X6:"A4x6",ISO_A4X7:"A4x7",ISO_A4X8:"A4x8",ISO_A4X9:"A4x9",ISO_A4_EXTRA:"A4 Extra",ISO_A4_TAB:"A4 Tab",ISO_A5:"A5",ISO_A5_EXTRA:"A5 Extra",ISO_A6:"A6",ISO_A7:"A7",ISO_A8:"A8",ISO_A9:"A9",ISO_B0:"B0",ISO_B1:"B1",ISO_B10:"B10",ISO_B2:"B2",ISO_B3:"B3",ISO_B4:"B4",ISO_B5:"B5",ISO_B5_EXTRA:"B5 Extra",ISO_B6:"B6",ISO_B6C4:"B6C4",ISO_B7:"B7",ISO_B8:"B8",ISO_B9:"B9",ISO_C0:"C0",ISO_C1:"C1",ISO_C10:"C10",ISO_C2:"C2",ISO_C3:"C3",ISO_C4:"C4",ISO_C5:"C5",ISO_C6:"C6",ISO_C6C5:"C6C5",ISO_C7:"C7",ISO_C7C6:"C7C6",ISO_C8:"C8",ISO_C9:"C9",ISO_DL:"Envelope DL",ISO_RA0:"RA0",ISO_RA1:"RA1",ISO_RA2:"RA2",ISO_SRA0:"SRA0",ISO_SRA1:"SRA1",ISO_SRA2:"SRA2",JIS_B0:"B0 (JIS)",JIS_B1:"B1 (JIS)",JIS_B10:"B10 (JIS)",JIS_B2:"B2 (JIS)",JIS_B3:"B3 (JIS)",JIS_B4:"B4 (JIS)",JIS_B5:"B5 (JIS)",JIS_B6:"B6 (JIS)",JIS_B7:"B7 (JIS)",JIS_B8:"B8 (JIS)",JIS_B9:"B9 (JIS)",JIS_EXEC:"Executive (JIS)",JPN_CHOU2:"Choukei 2",JPN_CHOU3:"Choukei 3",JPN_CHOU4:"Choukei 4",JPN_HAGAKI:"Hagaki",JPN_KAHU:"Kahu Envelope",JPN_KAKU2:"Kaku 2",JPN_OUFUKU:"Oufuku Hagaki",JPN_YOU4:"You 4",NA_10X11:"10x11",NA_10X13:"10x13",NA_10X14:"10x14",NA_10X15:"10x15",NA_11X12:"11x12",NA_11X15:"11x15",NA_12X19:"12x19",NA_5X7:"5x7",NA_6X9:"6x9",NA_7X9:"7x9",NA_9X11:"9x11",NA_A2:"A2",NA_ARCH_A:"Arch A",NA_ARCH_B:"Arch B",NA_ARCH_C:"Arch C",NA_ARCH_D:"Arch D",NA_ARCH_E:"Arch E",NA_ASME_F:"ASME F",NA_B_PLUS:"B-plus",NA_C:"C",NA_C5:"C5",NA_D:"D",NA_E:"E",NA_EDP:"EDP",NA_EUR_EDP:"European EDP",NA_EXECUTIVE:"Executive",NA_F:"F",NA_FANFOLD_EUR:"FanFold European",NA_FANFOLD_US:"FanFold US",NA_FOOLSCAP:"FanFold German Legal",NA_GOVT_LEGAL:"8x13",NA_GOVT_LETTER:"8x10",NA_INDEX_3X5:"Index 3x5",NA_INDEX_4X6:"Index 4x6",NA_INDEX_4X6_EXT:"Index 4x6 ext",NA_INDEX_5X8:"5x8",NA_INVOICE:"Invoice",NA_LEDGER:"Tabloid",NA_LEGAL:"Legal",NA_LEGAL_EXTRA:"Legal extra",NA_LETTER:"Letter",NA_LETTER_EXTRA:"Letter extra",NA_LETTER_PLUS:"Letter plus",NA_MONARCH:"Monarch",NA_NUMBER_10:"Envelope #10",NA_NUMBER_11:"Envelope #11",NA_NUMBER_12:"Envelope #12",NA_NUMBER_14:"Envelope #14",NA_NUMBER_9:"Envelope #9",NA_PERSONAL:"Personal",NA_QUARTO:"Quarto",NA_SUPER_A:"Super A",NA_SUPER_B:"Super B",NA_WIDE_FORMAT:"Wide format",OM_DAI_PA_KAI:"Dai-pa-kai",OM_FOLIO:"Folio",OM_FOLIO_SP:"Folio SP",OM_INVITE:"Invite Envelope",OM_ITALIAN:"Italian Envelope",OM_JUURO_KU_KAI:"Juuro-ku-kai",OM_LARGE_PHOTO:"Large photo",OM_OFICIO:"Oficio",OM_PA_KAI:"Pa-kai",OM_POSTFIX:"Postfix Envelope",OM_SMALL_PHOTO:"Small photo",PRC_1:"prc1 Envelope",PRC_10:"prc10 Envelope",PRC_16K:"prc 16k",PRC_2:"prc2 Envelope",PRC_3:"prc3 Envelope",PRC_32K:"prc 32k",PRC_4:"prc4 Envelope",PRC_5:"prc5 Envelope",PRC_6:"prc6 Envelope",PRC_7:"prc7 Envelope",PRC_8:"prc8 Envelope",ROC_16K:"ROC 16K",ROC_8K:"ROC 8k"};
// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var CustomMarginsOrientation;(function(CustomMarginsOrientation){CustomMarginsOrientation["TOP"]="top";CustomMarginsOrientation["RIGHT"]="right";CustomMarginsOrientation["BOTTOM"]="bottom";CustomMarginsOrientation["LEFT"]="left"})(CustomMarginsOrientation||(CustomMarginsOrientation={}));var MarginsType;(function(MarginsType){MarginsType[MarginsType["DEFAULT"]=0]="DEFAULT";MarginsType[MarginsType["NO_MARGINS"]=1]="NO_MARGINS";MarginsType[MarginsType["MINIMUM"]=2]="MINIMUM";MarginsType[MarginsType["CUSTOM"]=3]="CUSTOM"})(MarginsType||(MarginsType={}));class Margins{constructor(top,right,bottom,left){this.value_={top:0,bottom:0,left:0,right:0};this.value_={top:Math.round(top),right:Math.round(right),bottom:Math.round(bottom),left:Math.round(left)}}get(orientation){return this.value_[orientation]}set(orientation,value){const newValue=this.clone_();newValue[orientation]=value;return new Margins(newValue[CustomMarginsOrientation.TOP],newValue[CustomMarginsOrientation.RIGHT],newValue[CustomMarginsOrientation.BOTTOM],newValue[CustomMarginsOrientation.LEFT])}equals(other){if(other===null){return false}for(const key in this.value_){const orientation=key;if(this.value_[orientation]!==other.value_[orientation]){return false}}return true}serialize(){return this.clone_()}clone_(){const clone={top:0,bottom:0,left:0,right:0};for(const o in this.value_){const orientation=o;clone[orientation]=this.value_[orientation]}return clone}}
// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var MeasurementSystemUnitType;(function(MeasurementSystemUnitType){MeasurementSystemUnitType[MeasurementSystemUnitType["METRIC"]=0]="METRIC";MeasurementSystemUnitType[MeasurementSystemUnitType["IMPERIAL"]=1]="IMPERIAL"})(MeasurementSystemUnitType||(MeasurementSystemUnitType={}));class MeasurementSystem{constructor(thousandsDelimiter,decimalDelimiter,unitType){this.thousandsDelimiter_=thousandsDelimiter||",";this.decimalDelimiter_=decimalDelimiter||".";assert(measurementSystemPrefs.has(unitType));this.measurementSystemPrefs_=measurementSystemPrefs.get(unitType)}get unitSymbol(){return this.measurementSystemPrefs_.unitSymbol}get thousandsDelimiter(){return this.thousandsDelimiter_}get decimalDelimiter(){return this.decimalDelimiter_}roundValue(value){const precision=this.measurementSystemPrefs_.precision;const roundedValue=Math.round(value/precision)*precision;return+roundedValue.toFixed(this.measurementSystemPrefs_.decimalPlaces)}convertFromPoints(pts){return pts/this.measurementSystemPrefs_.ptsPerUnit}convertToPoints(localUnits){return localUnits*this.measurementSystemPrefs_.ptsPerUnit}}const measurementSystemPrefs=new Map([[MeasurementSystemUnitType.METRIC,{precision:.5,decimalPlaces:1,ptsPerUnit:72/25.4,unitSymbol:"mm"}],[MeasurementSystemUnitType.IMPERIAL,{precision:.01,decimalPlaces:2,ptsPerUnit:72,unitSymbol:'"'}]]);
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class PromiseResolver{resolve_=()=>{};reject_=()=>{};isFulfilled_=false;promise_;constructor(){this.promise_=new Promise(((resolve,reject)=>{this.resolve_=resolution=>{resolve(resolution);this.isFulfilled_=true};this.reject_=reason=>{reject(reason);this.isFulfilled_=true}}))}get isFulfilled(){return this.isFulfilled_}get promise(){return this.promise_}get resolve(){return this.resolve_}get reject(){return this.reject_}}
// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var ScalingType;(function(ScalingType){ScalingType[ScalingType["DEFAULT"]=0]="DEFAULT";ScalingType[ScalingType["FIT_TO_PAGE"]=1]="FIT_TO_PAGE";ScalingType[ScalingType["FIT_TO_PAPER"]=2]="FIT_TO_PAPER";ScalingType[ScalingType["CUSTOM"]=3]="CUSTOM"})(ScalingType||(ScalingType={}));
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var DuplexMode;(function(DuplexMode){DuplexMode[DuplexMode["SIMPLEX"]=0]="SIMPLEX";DuplexMode[DuplexMode["LONG_EDGE"]=1]="LONG_EDGE";DuplexMode[DuplexMode["SHORT_EDGE"]=2]="SHORT_EDGE";DuplexMode[DuplexMode["UNKNOWN_DUPLEX_MODE"]=-1]="UNKNOWN_DUPLEX_MODE"})(DuplexMode||(DuplexMode={}));let instance$7=null;let whenReadyResolver=new PromiseResolver;function getInstance$1(){assert(instance$7);return instance$7}function whenReady(){return whenReadyResolver.promise}const STICKY_SETTING_NAMES=["recentDestinations","borderless","collate","color","cssBackground","customMargins","dpi","duplex","duplexShortEdge","headerFooter","layout","margins","mediaSize","mediaType","scaling","scalingType","scalingTypePdf","vendorItems"];STICKY_SETTING_NAMES.push("pin","pinValue");const MINIMUM_HEIGHT_MICRONS=25400;function getDuplexDefaultValue(allowedMode,defaultMode){if(allowedMode!==DuplexModeRestriction.DUPLEX){return allowedMode===undefined||allowedMode===DuplexModeRestriction.UNSET?defaultMode:allowedMode}if(defaultMode===DuplexModeRestriction.SHORT_EDGE||defaultMode===DuplexModeRestriction.LONG_EDGE){return defaultMode}return DuplexModeRestriction.DUPLEX}function createSettings(){return{pages:{value:[1],unavailableValue:[],valid:true,available:true,setByGlobalPolicy:false,setByDestinationPolicy:false,setFromUi:false,key:"",updatesPreview:false},copies:{value:1,unavailableValue:1,valid:true,available:true,setByGlobalPolicy:false,setByDestinationPolicy:false,setFromUi:false,key:"",updatesPreview:false},collate:{value:true,unavailableValue:false,valid:true,available:true,setByGlobalPolicy:false,setByDestinationPolicy:false,setFromUi:false,key:"isCollateEnabled",updatesPreview:false},layout:{value:false,unavailableValue:false,valid:true,available:true,setByGlobalPolicy:false,setByDestinationPolicy:false,setFromUi:false,key:"isLandscapeEnabled",updatesPreview:true},color:{value:true,unavailableValue:false,valid:true,available:true,setByGlobalPolicy:false,setByDestinationPolicy:false,setFromUi:false,key:"isColorEnabled",updatesPreview:true},mediaSize:{value:{},unavailableValue:{width_microns:215900,height_microns:279400,imageable_area_left_microns:0,imageable_area_bottom_microns:0,imageable_area_right_microns:215900,imageable_area_top_microns:279400},valid:true,available:true,setByGlobalPolicy:false,setByDestinationPolicy:false,setFromUi:false,key:"mediaSize",updatesPreview:true},borderless:{value:false,unavailableValue:false,valid:true,available:false,setByGlobalPolicy:false,setByDestinationPolicy:false,setFromUi:false,key:"borderless",updatesPreview:true},mediaType:{value:"",unavailableValue:"",valid:true,available:false,setByGlobalPolicy:false,setByDestinationPolicy:false,setFromUi:false,key:"mediaType",updatesPreview:false},margins:{value:MarginsType.DEFAULT,unavailableValue:MarginsType.DEFAULT,valid:true,available:true,setByGlobalPolicy:false,setByDestinationPolicy:false,setFromUi:false,key:"marginsType",updatesPreview:true},customMargins:{value:{},unavailableValue:{},valid:true,available:true,setByGlobalPolicy:false,setByDestinationPolicy:false,setFromUi:false,key:"customMargins",updatesPreview:true},dpi:{value:{},unavailableValue:{},valid:true,available:true,setByGlobalPolicy:false,setByDestinationPolicy:false,setFromUi:false,key:"dpi",updatesPreview:false},scaling:{value:"100",unavailableValue:"100",valid:true,available:true,setByGlobalPolicy:false,setByDestinationPolicy:false,setFromUi:false,key:"scaling",updatesPreview:true},scalingType:{value:ScalingType.DEFAULT,unavailableValue:ScalingType.DEFAULT,valid:true,available:true,setByGlobalPolicy:false,setByDestinationPolicy:false,setFromUi:false,key:"scalingType",updatesPreview:true},scalingTypePdf:{value:ScalingType.DEFAULT,unavailableValue:ScalingType.DEFAULT,valid:true,available:true,setByGlobalPolicy:false,setByDestinationPolicy:false,setFromUi:false,key:"scalingTypePdf",updatesPreview:true},duplex:{value:true,unavailableValue:false,valid:true,available:true,setByGlobalPolicy:false,setByDestinationPolicy:false,setFromUi:false,key:"isDuplexEnabled",updatesPreview:false},duplexShortEdge:{value:false,unavailableValue:false,valid:true,available:true,setByGlobalPolicy:false,setByDestinationPolicy:false,setFromUi:false,key:"isDuplexShortEdge",updatesPreview:false},cssBackground:{value:false,unavailableValue:false,valid:true,available:true,setByGlobalPolicy:false,setByDestinationPolicy:false,setFromUi:false,key:"isCssBackgroundEnabled",updatesPreview:true},selectionOnly:{value:false,unavailableValue:false,valid:true,available:true,setByGlobalPolicy:false,setByDestinationPolicy:false,setFromUi:false,key:"",updatesPreview:true},headerFooter:{value:true,unavailableValue:false,valid:true,available:true,setByGlobalPolicy:false,setByDestinationPolicy:false,setFromUi:false,key:"isHeaderFooterEnabled",updatesPreview:true},rasterize:{value:false,unavailableValue:false,valid:true,available:true,setByGlobalPolicy:false,setByDestinationPolicy:false,setFromUi:false,key:"",updatesPreview:true},vendorItems:{value:{},unavailableValue:{},valid:true,available:true,setByGlobalPolicy:false,setByDestinationPolicy:false,setFromUi:false,key:"vendorOptions",updatesPreview:false},pagesPerSheet:{value:1,unavailableValue:1,valid:true,available:true,setByGlobalPolicy:false,setByDestinationPolicy:false,setFromUi:false,key:"",updatesPreview:true},otherOptions:{value:null,unavailableValue:null,valid:true,available:true,setByGlobalPolicy:false,setByDestinationPolicy:false,setFromUi:false,key:"",updatesPreview:false},ranges:{value:[],unavailableValue:[],valid:true,available:true,setByGlobalPolicy:false,setByDestinationPolicy:false,setFromUi:false,key:"",updatesPreview:true},recentDestinations:{value:[],unavailableValue:[],valid:true,available:true,setByGlobalPolicy:false,setByDestinationPolicy:false,setFromUi:false,key:"recentDestinations",updatesPreview:false},pin:{value:false,unavailableValue:false,valid:true,available:true,setByGlobalPolicy:false,setByDestinationPolicy:false,setFromUi:false,key:"isPinEnabled",updatesPreview:false},pinValue:{value:"",unavailableValue:"",valid:true,available:true,setByGlobalPolicy:false,setByDestinationPolicy:false,setFromUi:false,key:"pinValue",updatesPreview:false}}}class PrintPreviewModelElement extends PolymerElement{constructor(){super(...arguments);this.initialized_=false;this.stickySettings_=null;this.policySettings_=null;this.lastDestinationCapabilities_=null}static get is(){return"print-preview-model"}static get template(){return null}static get properties(){return{settings:{type:Object,notify:true,value:()=>createSettings()},settingsManaged:{type:Boolean,notify:true,value:false},destination:Object,documentSettings:Object,margins:Object,pageSize:Object,maxSheets:{type:Number,value:0,notify:true}}}static get observers(){return["updateSettingsFromDestination_(destination.capabilities)","updateSettingsAvailabilityFromDocumentSettings_("+"documentSettings.isModifiable, documentSettings.isFromArc,"+"documentSettings.allPagesHaveCustomSize,"+"documentSettings.allPagesHaveCustomOrientation,"+"documentSettings.hasSelection)","updateHeaderFooterAvailable_("+"margins, settings.margins.value, settings.mediaSize.value)"]}connectedCallback(){super.connectedCallback();assert(!instance$7);instance$7=this;whenReadyResolver.resolve()}disconnectedCallback(){super.disconnectedCallback();instance$7=null;whenReadyResolver=new PromiseResolver}fire_(eventName,detail){this.dispatchEvent(new CustomEvent(eventName,{bubbles:true,composed:true,detail:detail}))}getSetting(settingName){const setting=this.get(settingName,this.settings);assert(setting,"Setting is missing: "+settingName);return setting}getSettingValue(settingName){const setting=this.getSetting(settingName);return setting.available?setting.value:setting.unavailableValue}setSettingPath_(settingPath,value){const settingName=settingPath.split(".")[0];const setting=this.getSetting(settingName);const oldValue=this.getSettingValue(settingName);this.set(`settings.${settingPath}`,value);const newValue=this.getSettingValue(settingName);if(newValue!==oldValue&&setting.updatesPreview){this.fire_("preview-setting-changed")}}setSetting(settingName,value,noSticky){const setting=this.getSetting(settingName);if(setting.setByGlobalPolicy){return}const fireStickyEvent=!noSticky&&setting.value!==value&&setting.key;this.setSettingPath_(`${settingName}.value`,value);if(!noSticky){this.setSettingPath_(`${settingName}.setFromUi`,true)}if(fireStickyEvent&&this.initialized_){this.fire_("sticky-setting-changed",this.getStickySettings_())}}setSettingSplice(settingName,start,end,newValue,noSticky){const setting=this.getSetting(settingName);if(setting.setByGlobalPolicy){return}if(newValue){this.splice(`settings.${settingName}.value`,start,end,newValue)}else{this.splice(`settings.${settingName}.value`,start,end)}if(!noSticky){this.setSettingPath_(`${settingName}.setFromUi`,true)}if(!noSticky&&setting.key&&this.initialized_){this.fire_("sticky-setting-changed",this.getStickySettings_())}}setSettingValid(settingName,valid){const setting=this.getSetting(settingName);if(!valid){assert(setting.available,"Setting is not available: "+settingName)}const shouldFireEvent=valid!==setting.valid;this.set(`settings.${settingName}.valid`,valid);if(shouldFireEvent){this.fire_("setting-valid-changed",valid)}}getDuplexPolicyDefaultValueAvailable_(duplexPolicyDefault,duplexShortEdgePolicyDefault){if(duplexPolicyDefault===undefined){return false}let defaultPolicyDuplexType=null;if(duplexPolicyDefault===false){defaultPolicyDuplexType=DuplexType.NO_DUPLEX}else if(duplexShortEdgePolicyDefault===true){defaultPolicyDuplexType=DuplexType.SHORT_EDGE}else{defaultPolicyDuplexType=DuplexType.LONG_EDGE}return this.destination.supportsDuplex(defaultPolicyDuplexType)}updateSettingsFromDestination_(){if(!this.destination||!this.settings){return}if(this.destination.capabilities===this.lastDestinationCapabilities_){return}this.lastDestinationCapabilities_=this.destination.capabilities;this.updateSettingsAvailabilityFromDestination_();if(!this.destination.capabilities?.printer){return}this.updateSettingsValues_();this.applyPersistentCddDefaults_()}updateSettingsAvailabilityFromDestination_(){const caps=this.destination.capabilities?this.destination.capabilities.printer:null;this.setSettingPath_("copies.available",this.destination.hasCopiesCapability);this.setSettingPath_("collate.available",!!caps&&!!caps.collate);this.setSettingPath_("color.available",this.destination.hasColorCapability);const capsHasDuplex=!!caps&&!!caps.duplex&&!!caps.duplex.option;const capsHasLongEdge=capsHasDuplex&&caps.duplex.option.some((o=>o.type===DuplexType.LONG_EDGE));const capsHasShortEdge=capsHasDuplex&&caps.duplex.option.some((o=>o.type===DuplexType.SHORT_EDGE));this.setSettingPath_("duplexShortEdge.available",capsHasLongEdge&&capsHasShortEdge);this.setSettingPath_("duplex.available",(capsHasLongEdge||capsHasShortEdge)&&caps.duplex.option.some((o=>o.type===DuplexType.NO_DUPLEX)));this.setSettingPath_("vendorItems.available",!!caps&&!!caps.vendor_capability);const pinSupported=!!caps&&!!caps.pin&&!!caps.pin.supported&&loadTimeData.getBoolean("isEnterpriseManaged");this.set("settings.pin.available",pinSupported);this.set("settings.pinValue.available",pinSupported);if(this.documentSettings){this.updateSettingsAvailabilityFromDestinationAndDocumentSettings_()}}updateSettingsAvailabilityFromDestinationAndDocumentSettings_(){const isSaveAsPDF=this.destination.type===PrinterType.PDF_PRINTER;const knownSizeToSaveAsPdf=isSaveAsPDF&&(!this.documentSettings.isModifiable||this.documentSettings.allPagesHaveCustomSize);const scalingAvailable=!knownSizeToSaveAsPdf&&!this.documentSettings.isFromArc;this.setSettingPath_("scaling.available",scalingAvailable);this.setSettingPath_("scalingType.available",scalingAvailable&&this.documentSettings.isModifiable);this.setSettingPath_("scalingTypePdf.available",scalingAvailable&&!this.documentSettings.isModifiable);const caps=this.destination&&this.destination.capabilities?this.destination.capabilities.printer:null;this.setSettingPath_("mediaSize.available",!!caps&&!!caps.media_size&&!knownSizeToSaveAsPdf);this.setSettingPath_("borderless.available",this.isBorderlessAvailable_(caps));this.setSettingPath_("mediaType.available",loadTimeData.getBoolean("isBorderlessPrintingEnabled")&&!!caps&&!!caps.media_type&&!!caps.media_type.option&&caps.media_type.option.length>1);this.setSettingPath_("dpi.available",!this.documentSettings.isFromArc&&!!caps&&!!caps.dpi&&!!caps.dpi.option&&caps.dpi.option.length>1);this.setSettingPath_("layout.available",this.isLayoutAvailable_(caps))}updateSettingsAvailabilityFromDocumentSettings_(){if(!this.settings){return}this.setSettingPath_("pagesPerSheet.available",!this.documentSettings.isFromArc);this.setSettingPath_("margins.available",!this.documentSettings.isFromArc&&this.documentSettings.isModifiable);this.setSettingPath_("customMargins.available",!this.documentSettings.isFromArc&&this.documentSettings.isModifiable);this.setSettingPath_("cssBackground.available",!this.documentSettings.isFromArc&&this.documentSettings.isModifiable);this.setSettingPath_("selectionOnly.available",!this.documentSettings.isFromArc&&this.documentSettings.isModifiable&&this.documentSettings.hasSelection);this.setSettingPath_("headerFooter.available",!this.documentSettings.isFromArc&&this.isHeaderFooterAvailable_());this.setSettingPath_("rasterize.available",!this.documentSettings.isFromArc&&this.isRasterizeAvailable_());this.setSettingPath_("otherOptions.available",this.settings.cssBackground.available||this.settings.selectionOnly.available||this.settings.headerFooter.available||this.settings.rasterize.available);if(this.destination){this.updateSettingsAvailabilityFromDestinationAndDocumentSettings_()}}updateHeaderFooterAvailable_(){if(this.documentSettings===undefined){return}this.setSettingPath_("headerFooter.available",this.isHeaderFooterAvailable_())}isHeaderFooterAvailable_(){if(!this.documentSettings.isModifiable){return false}const microns=this.getSettingValue("layout")?this.getSettingValue("mediaSize").width_microns:this.getSettingValue("mediaSize").height_microns;if(microns<MINIMUM_HEIGHT_MICRONS){return false}const marginsType=this.getSettingValue("margins");if(marginsType===MarginsType.NO_MARGINS){return false}if(marginsType===MarginsType.MINIMUM){return true}return!this.margins||this.margins.get(CustomMarginsOrientation.TOP)>0||this.margins.get(CustomMarginsOrientation.BOTTOM)>0}updateRasterizeAvailable_(){if(this.documentSettings===undefined){return}this.setSettingPath_("rasterize.available",this.isRasterizeAvailable_())}isRasterizeAvailable_(){let available=!!this.documentSettings&&!this.documentSettings.isModifiable;return available}isLayoutAvailable_(caps){if(!caps||!caps.page_orientation||!caps.page_orientation.option||!this.documentSettings.isModifiable&&!this.documentSettings.isFromArc||this.documentSettings.allPagesHaveCustomOrientation){return false}let hasAutoOrPortraitOption=false;let hasLandscapeOption=false;caps.page_orientation.option.forEach((option=>{hasAutoOrPortraitOption=hasAutoOrPortraitOption||option.type==="AUTO"||option.type==="PORTRAIT";hasLandscapeOption=hasLandscapeOption||option.type==="LANDSCAPE"}));return hasLandscapeOption&&hasAutoOrPortraitOption}isBorderlessAvailable_(caps){return loadTimeData.getBoolean("isBorderlessPrintingEnabled")&&!!caps&&!!caps.media_size?.option?.find((o=>o.has_borderless_variant))}updateSettingsValues_(){const caps=this.destination.capabilities?this.destination.capabilities.printer:null;if(!caps){return}if(this.settings.mediaSize.available){const defaultOption=caps.media_size.option.find((o=>!!o.is_default))||caps.media_size.option[0];let matchingOption=null;if(this.settings.mediaSize.setFromUi){const currentMediaSize=this.getSettingValue("mediaSize");matchingOption=this.destination.getMediaSize(currentMediaSize.width_microns,currentMediaSize.height_microns)}this.setSetting("mediaSize",matchingOption||defaultOption,true)}if(this.settings.borderless.available){this.setSetting("borderless",this.settings.borderless.setFromUi&&this.getSettingValue("borderless"),true)}if(this.settings.mediaType.available){const defaultOption=caps.media_type.option.find((o=>!!o.is_default))||caps.media_type.option[0];let matchingOption=null;if(this.settings.mediaType.setFromUi){matchingOption=this.destination.getMediaType(this.getSettingValue("mediaType").vendor_id)}this.setSetting("mediaType",matchingOption||defaultOption,true)}else if(caps.media_type&&caps.media_type.option&&caps.media_type.option.length>0){const unavailableValue=caps.media_type.option.find((o=>!!o.is_default))||caps.media_type.option[0];this.setSettingPath_("mediaType.unavailableValue",unavailableValue)}if(this.settings.dpi.available){const defaultOption=caps.dpi.option.find((o=>!!o.is_default))||caps.dpi.option[0];let matchingOption=null;if(this.settings.dpi.setFromUi){const currentDpi=this.getSettingValue("dpi");matchingOption=this.destination.getDpi(currentDpi.horizontal_dpi,currentDpi.vertical_dpi)}this.setSetting("dpi",matchingOption||defaultOption,true)}else if(caps.dpi&&caps.dpi.option&&caps.dpi.option.length>0){const unavailableValue=caps.dpi.option.find((o=>!!o.is_default))||caps.dpi.option[0];this.setSettingPath_("dpi.unavailableValue",unavailableValue)}if(!this.settings.color.setFromUi&&this.settings.color.available){const defaultOption=this.destination.defaultColorOption;if(defaultOption){this.setSetting("color",!["STANDARD_MONOCHROME","CUSTOM_MONOCHROME"].includes(defaultOption.type),true)}}else if(!this.settings.color.available&&caps.color&&caps.color.option&&caps.color.option.length>0){this.setSettingPath_("color.unavailableValue",!["STANDARD_MONOCHROME","CUSTOM_MONOCHROME"].includes(caps.color.option[0].type))}else if(!this.settings.color.available){this.setSettingPath_("color.unavailableValue",false)}const duplexPolicyDefaultValueAvailable=this.getDuplexPolicyDefaultValueAvailable_(this.getSetting("duplex").policyDefaultValue,this.getSetting("duplexShortEdge").policyDefaultValue);if(!this.settings.duplex.setFromUi&&this.settings.duplex.available&&!duplexPolicyDefaultValueAvailable){const defaultOption=caps.duplex.option.find((o=>!!o.is_default));if(defaultOption!==undefined){const defaultOptionIsDuplex=defaultOption.type===DuplexType.SHORT_EDGE||defaultOption.type===DuplexType.LONG_EDGE;this.setSetting("duplex",defaultOptionIsDuplex,true);if(defaultOptionIsDuplex){this.setSetting("duplexShortEdge",defaultOption.type===DuplexType.SHORT_EDGE,true)}if(!this.settings.duplexShortEdge.available){this.setSettingPath_("duplexShortEdge.unavailableValue",caps.duplex.option.some((o=>o.type===DuplexType.SHORT_EDGE)))}}}else if(!this.settings.duplex.available&&caps&&caps.duplex&&caps.duplex.option){const hasLongEdge=caps.duplex.option.some((o=>o.type===DuplexType.LONG_EDGE));const hasShortEdge=caps.duplex.option.some((o=>o.type===DuplexType.SHORT_EDGE));this.setSettingPath_("duplex.unavailableValue",hasLongEdge||hasShortEdge);this.setSettingPath_("duplexShortEdge.unavailableValue",hasShortEdge)}else if(!this.settings.duplex.available){this.setSettingPath_("duplex.unavailableValue",false);this.setSettingPath_("duplexShortEdge.unavailableValue",false)}if(this.settings.vendorItems.available){const vendorSettings={};for(const item of caps.vendor_capability){let defaultValue=null;if(item.type==="SELECT"&&item.select_cap&&item.select_cap.option){const defaultOption=item.select_cap.option.find((o=>!!o.is_default));defaultValue=defaultOption?defaultOption.value:null}else if(item.type==="RANGE"){if(item.range_cap){defaultValue=item.range_cap.default||null}}else if(item.type==="TYPED_VALUE"){if(item.typed_value_cap){defaultValue=item.typed_value_cap.default||null}}if(defaultValue!==null){vendorSettings[item.id]=defaultValue}}this.setSetting("vendorItems",vendorSettings,true)}}setStickySettings(savedSettingsStr){assert(!this.stickySettings_);if(!savedSettingsStr){return}let savedSettings;try{savedSettings=JSON.parse(savedSettingsStr)}catch(e){console.warn("Unable to parse state "+e);return}if(savedSettings.version!==2){return}if(savedSettings.marginsType===MarginsType.CUSTOM){let valid=false;if(savedSettings.customMargins){savedSettings.customMargins.marginTop=Math.round(savedSettings.customMargins.marginTop);savedSettings.customMargins.marginRight=Math.round(savedSettings.customMargins.marginRight);savedSettings.customMargins.marginBottom=Math.round(savedSettings.customMargins.marginBottom);savedSettings.customMargins.marginLeft=Math.round(savedSettings.customMargins.marginLeft);const isValidCustomMarginValue=value=>value>=0;valid=isValidCustomMarginValue(savedSettings.customMargins.marginTop)&&isValidCustomMarginValue(savedSettings.customMargins.marginRight)&&isValidCustomMarginValue(savedSettings.customMargins.marginBottom)&&isValidCustomMarginValue(savedSettings.customMargins.marginLeft)}if(!valid){savedSettings.marginsType=MarginsType.DEFAULT;delete savedSettings.customMargins}}let recentDestinations=savedSettings.recentDestinations||[];if(!Array.isArray(recentDestinations)){recentDestinations=[recentDestinations]}const unsupportedOrigins=[DestinationOrigin.COOKIES,DestinationOrigin.DEVICE,DestinationOrigin.PRIVET];recentDestinations=recentDestinations.filter((d=>!unsupportedOrigins.includes(d.origin)));this.setSetting("recentDestinations",recentDestinations);savedSettings.recentDestinations=recentDestinations;this.stickySettings_=savedSettings}setPolicySetting_(settingName,value,managed,applyOnDestinationUpdate){if(!this.policySettings_){this.policySettings_={}}this.policySettings_[settingName]={value:value,managed:managed,applyOnDestinationUpdate:applyOnDestinationUpdate}}configurePolicySetting_(settingName,allowedMode,defaultMode){switch(settingName){case"headerFooter":{const value=allowedMode!==undefined?allowedMode:defaultMode;if(value!==undefined){this.setPolicySetting_(settingName,value,allowedMode!==undefined,false)}break}case"cssBackground":{const value=allowedMode?allowedMode:defaultMode;if(value!==undefined){this.setPolicySetting_(settingName,value===BackgroundGraphicsModeRestriction.ENABLED,!!allowedMode,false)}break}case"mediaSize":{if(defaultMode!==undefined){this.setPolicySetting_(settingName,defaultMode,false,true)}break}case"color":{const value=allowedMode?allowedMode:defaultMode;if(value!==undefined){this.setPolicySetting_(settingName,value,!!allowedMode,false)}break}case"duplex":{const value=getDuplexDefaultValue(allowedMode,defaultMode);if(value!==undefined){this.setPolicySetting_(settingName,value,!!allowedMode,false)}break}case"pin":{const value=allowedMode?allowedMode:defaultMode;if(value!==undefined){this.setPolicySetting_(settingName,value,!!allowedMode,false)}break}case"printPdfAsImage":{if(defaultMode!==undefined){this.setPolicySetting_(settingName,defaultMode,false,false)}break}}}setPolicySettings(policies){if(policies===undefined){return}const policiesObject=policies;["headerFooter","cssBackground","mediaSize"].forEach((settingName=>{if(!policiesObject[settingName]){return}const defaultMode=policiesObject[settingName].defaultMode;const allowedMode=policiesObject[settingName].allowedMode;this.configurePolicySetting_(settingName,allowedMode,defaultMode)}));if(policiesObject["sheets"]){if(!this.policySettings_){this.policySettings_={}}this.policySettings_["sheets"]={value:policiesObject["sheets"].value,applyOnDestinationUpdate:false,managed:true}}["color","duplex","pin"].forEach((settingName=>{if(!policiesObject[settingName]){return}const defaultMode=policiesObject[settingName].defaultMode;const allowedMode=policiesObject[settingName].allowedMode;this.configurePolicySetting_(settingName,allowedMode,defaultMode)}));if(policies["printPdfAsImage"]){if(!this.policySettings_){this.policySettings_={}}const defaultMode=policies["printPdfAsImage"].defaultMode;this.configurePolicySetting_("printPdfAsImage",undefined,defaultMode)}}applyStickySettings(){if(this.stickySettings_){STICKY_SETTING_NAMES.forEach((settingName=>{const setting=this.get(settingName,this.settings);const value=this.stickySettings_[setting.key];if(value!==undefined){this.setSetting(settingName,value)}else{this.applyScalingStickySettings_(settingName)}}))}this.applyPersistentCddDefaults_();this.applyPolicySettings_();this.initialized_=true;this.updateManaged_();this.stickySettings_=null;this.fire_("sticky-setting-changed",this.getStickySettings_())}applyScalingStickySettings_(settingName){if(settingName==="scalingType"&&"customScaling"in this.stickySettings_){const isCustom=this.stickySettings_["customScaling"];const scalingType=isCustom?ScalingType.CUSTOM:ScalingType.DEFAULT;this.setSetting(settingName,scalingType)}else if(settingName==="scalingTypePdf"){if("isFitToPageEnabled"in this.stickySettings_){const isFitToPage=this.stickySettings_["isFitToPageEnabled"];const scalingTypePdf=isFitToPage?ScalingType.FIT_TO_PAGE:this.getSetting("scalingType").value;this.setSetting(settingName,scalingTypePdf)}else if(this.getSetting("scalingType").value===ScalingType.CUSTOM){this.setSetting(settingName,ScalingType.CUSTOM)}}}applyPolicySettings_(){if(this.policySettings_){for(const[settingName,policy]of Object.entries(this.policySettings_)){const policyEntry=policy;if(settingName==="sheets"){this.maxSheets=policyEntry.value;continue}if(settingName==="color"){this.set("settings.color.value",policyEntry.value===ColorModeRestriction.COLOR);this.set("settings.color.setByGlobalPolicy",policyEntry.managed);continue}if(settingName==="duplex"){const isDuplex=policyEntry.value===DuplexModeRestriction.SHORT_EDGE||policyEntry.value===DuplexModeRestriction.LONG_EDGE||policyEntry.value===DuplexModeRestriction.DUPLEX;this.set("settings.duplex.value",isDuplex);this.set("settings.duplex.policyDefaultValue",isDuplex);if(policyEntry.value===DuplexModeRestriction.SHORT_EDGE||policyEntry.value===DuplexModeRestriction.LONG_EDGE){this.set("settings.duplexShortEdge.value",policyEntry.value===DuplexModeRestriction.SHORT_EDGE);this.set("settings.duplexShortEdge.policyDefaultValue",policyEntry.value===DuplexModeRestriction.SHORT_EDGE)}this.set("settings.duplex.setByGlobalPolicy",policyEntry.managed);this.set("settings.duplexShortEdge.setByGlobalPolicy",false);continue}if(settingName==="pin"){if(policyEntry.value===PinModeRestriction.NO_PIN&&policyEntry.managed){this.set("settings.pin.available",false);this.set("settings.pinValue.available",false)}else{this.set("settings.pin.value",policyEntry.value===PinModeRestriction.PIN)}this.set("settings.pin.setByGlobalPolicy",policyEntry.managed);continue}if(settingName==="printPdfAsImage"){if(policyEntry.value){this.setSetting("rasterize",policyEntry.value,true)}continue}if(policyEntry.value!==undefined&&!policyEntry.applyOnDestinationUpdate){this.setSetting(settingName,policyEntry.value,true);if(policyEntry.managed){this.set(`settings.${settingName}.setByGlobalPolicy`,true)}}}}}getResetValue_(capability){if(!capability.reset_to_default){return null}const cddDefault=capability.option.find((o=>!!o.is_default));if(!cddDefault){return null}return cddDefault}applyPersistentCddDefaults_(){if(!this.destination||!this.destination.isExtension){return}const caps=this.destination&&this.destination.capabilities?this.destination.capabilities.printer:null;if(!caps){return}if(this.settings.mediaSize.available){const cddDefault=this.getResetValue_(caps["media_size"]);if(cddDefault){this.set("settings.mediaSize.value",cddDefault)}}if(this.settings.mediaType.available){assert(loadTimeData.getBoolean("isBorderlessPrintingEnabled"));const cddDefault=this.getResetValue_(caps["media_type"]);if(cddDefault){this.set("settings.mediaType.value",cddDefault)}}if(this.settings.color.available){const cddDefault=this.getResetValue_(caps["color"]);if(cddDefault){this.set("settings.color.value",!["STANDARD_MONOCHROME","CUSTOM_MONOCHROME"].includes(cddDefault.type))}}if(this.settings.duplex.available){const cddDefault=this.getResetValue_(caps["duplex"]);if(cddDefault){this.set("settings.duplex.value",cddDefault.type===DuplexType.LONG_EDGE||cddDefault.type===DuplexType.SHORT_EDGE);if(!this.settings.duplexShortEdge.available){this.set("settings.duplexShortEdge.value",cddDefault.type===DuplexType.SHORT_EDGE)}}}if(this.settings.dpi.available){const cddDefault=this.getResetValue_(caps["dpi"]);if(cddDefault){this.set("settings.dpi.value",cddDefault)}}}applyDestinationManagedJobOptionsDefaults_(){const managedPrintOptions=this.destination.managedPrintOptions;if(!managedPrintOptions){return}if(!this.settings.mediaSize.setFromUi&&managedPrintOptions.mediaSize?.defaultValue){const mediaSize=this.destination.getMediaSize(managedPrintOptions.mediaSize.defaultValue.width,managedPrintOptions.mediaSize.defaultValue.height);if(mediaSize){this.setSetting("mediaSize",mediaSize,true)}}if(!this.settings.mediaType.setFromUi&&managedPrintOptions.mediaType?.defaultValue){const mediaType=this.destination.getMediaType(managedPrintOptions.mediaType.defaultValue);if(mediaType){this.setSetting("mediaType",mediaType,true)}}if(!this.settings.duplex.setFromUi&&!this.settings.duplexShortEdge.setFromUi&&managedPrintOptions.duplex?.defaultValue){const cddDuplex=managedPrintOptionsDuplexToCdd(managedPrintOptions.duplex.defaultValue);if(cddDuplex&&this.destination.supportsDuplex(cddDuplex)){switch(cddDuplex){case DuplexType.NO_DUPLEX:{this.setSetting("duplex",false,true);break}case DuplexType.LONG_EDGE:{this.setSetting("duplex",true,true);this.setSetting("duplexShortEdge",false,true);break}case DuplexType.SHORT_EDGE:{this.setSetting("duplex",true,true);this.setSetting("duplexShortEdge",true,true);break}}}}if(!this.settings.color.setFromUi&&managedPrintOptions.color?.defaultValue!==undefined&&this.destination.getColor(managedPrintOptions.color.defaultValue)){this.setSetting("color",managedPrintOptions.color.defaultValue,true)}if(!this.settings.dpi.setFromUi&&managedPrintOptions.dpi?.defaultValue){const dpi=this.destination.getDpi(managedPrintOptions.dpi.defaultValue.horizontal,managedPrintOptions.dpi.defaultValue.vertical);if(dpi){this.setSetting("dpi",dpi,true)}}if(!this.settings.vendorItems.setFromUi&&managedPrintOptions.quality?.defaultValue&&this.destination.capabilities?.printer.vendor_capability){const qualityIppValue=managedPrintOptionsQualityToIpp(managedPrintOptions.quality.defaultValue);const printQualityCapability=this.destination.capabilities.printer.vendor_capability.find((o=>o.id===IPP_PRINT_QUALITY));const hasCorrespondingQualityOption=printQualityCapability?.select_cap?.option?.find((o=>o.value===qualityIppValue));if(hasCorrespondingQualityOption){const advancedSettings=this.getSettingValue("vendorItems");advancedSettings[IPP_PRINT_QUALITY]=qualityIppValue;this.setSetting("vendorItems",advancedSettings,true)}}if(this.settings.rasterize.available&&managedPrintOptions.printAsImage?.defaultValue!==undefined){this.setSetting("rasterize",managedPrintOptions.printAsImage.defaultValue,true)}}updateSetByDestinationPolicyProperties_(){const allowedManagedPrintOptionsApplied=this.destination.allowedManagedPrintOptionsApplied;const capabilities=this.destination.capabilities;this.set("settings.mediaSize.setByDestinationPolicy",allowedManagedPrintOptionsApplied?.mediaSize&&capabilities?.printer.media_size?.option.length===1);this.set("settings.mediaType.setByDestinationPolicy",allowedManagedPrintOptionsApplied?.mediaType&&capabilities?.printer.media_type?.option.length===1);if(allowedManagedPrintOptionsApplied?.duplex){const oneSidedModeSupported=this.destination.supportsDuplex(DuplexType.NO_DUPLEX);const atLeastOneDuplexModeSupported=this.destination.supportsDuplex(DuplexType.LONG_EDGE)||this.destination.supportsDuplex(DuplexType.SHORT_EDGE);const bothDuplexModesSupported=this.destination.supportsDuplex(DuplexType.LONG_EDGE)&&this.destination.supportsDuplex(DuplexType.SHORT_EDGE);this.set("settings.duplex.setByDestinationPolicy",!oneSidedModeSupported||!atLeastOneDuplexModeSupported);this.set("settings.duplexShortEdge.setByDestinationPolicy",!bothDuplexModesSupported)}else{this.set("settings.duplex.setByDestinationPolicy",false);this.set("settings.duplexShortEdge.setByDestinationPolicy",false)}this.set("settings.color.setByDestinationPolicy",allowedManagedPrintOptionsApplied?.color&&capabilities?.printer.color?.option.length===1);this.set("settings.dpi.setByDestinationPolicy",allowedManagedPrintOptionsApplied?.dpi&&capabilities?.printer.dpi?.option.length===1)}applyDestinationSpecificPolicies(){if(this.settings.mediaSize.available&&this.policySettings_){const mediaSizePolicy=this.policySettings_["mediaSize"]&&this.policySettings_["mediaSize"].value;if(mediaSizePolicy!==undefined){const matchingOption=this.destination.getMediaSize(mediaSizePolicy.width,mediaSizePolicy.height);if(matchingOption!==undefined){this.set("settings.mediaSize.value",matchingOption)}}}if(loadTimeData.getBoolean("isUseManagedPrintJobOptionsInPrintPreviewEnabled")){this.applyDestinationManagedJobOptionsDefaults_();this.updateSetByDestinationPolicyProperties_()}this.updateManaged_()}updateManaged_(){let managedSettings=["cssBackground","headerFooter"];managedSettings=managedSettings.concat(["color","duplex","duplexShortEdge","pin"]);this.settingsManaged=managedSettings.some((settingName=>{const setting=this.getSetting(settingName);return setting.available&&setting.setByGlobalPolicy}));if(this.destination){this.settingsManaged=this.settingsManaged||this.destination.allowedManagedPrintOptionsAppliedForAnySetting()}}initialized(){return this.initialized_}getStickySettings_(){const serialization={};serialization["version"]=2;STICKY_SETTING_NAMES.forEach((settingName=>{const setting=this.get(settingName,this.settings);if(setting.setFromUi){serialization[setting.key]=setting.value}}));return JSON.stringify(serialization)}getDuplexMode_(){if(!this.getSettingValue("duplex")){return DuplexMode.SIMPLEX}return this.getSettingValue("duplexShortEdge")?DuplexMode.SHORT_EDGE:DuplexMode.LONG_EDGE}getCddDuplexType_(){if(!this.getSettingValue("duplex")){return DuplexType.NO_DUPLEX}return this.getSettingValue("duplexShortEdge")?DuplexType.SHORT_EDGE:DuplexType.LONG_EDGE}createPrintTicket(destination,openPdfInPreview,showSystemDialog){const dpi=this.getSettingValue("dpi");const scalingSettingKey=this.getSetting("scalingTypePdf").available?"scalingTypePdf":"scalingType";const ticket={mediaSize:this.getSettingValue("mediaSize"),borderless:loadTimeData.getBoolean("isBorderlessPrintingEnabled")&&this.getSettingValue("mediaSize")?.has_borderless_variant&&this.getSettingValue("borderless"),mediaType:this.getSettingValue("mediaType")?.vendor_id,pageCount:this.getSettingValue("pages").length,landscape:this.getSettingValue("layout"),color:destination.getNativeColorModel(this.getSettingValue("color")),headerFooterEnabled:false,marginsType:this.getSettingValue("margins"),duplex:this.getDuplexMode_(),copies:this.getSettingValue("copies"),collate:this.getSettingValue("collate"),shouldPrintBackgrounds:this.getSettingValue("cssBackground"),shouldPrintSelectionOnly:false,previewModifiable:this.documentSettings.isModifiable,printerType:destination.type,rasterizePDF:this.getSettingValue("rasterize"),scaleFactor:this.getSettingValue(scalingSettingKey)===ScalingType.CUSTOM?parseInt(this.getSettingValue("scaling"),10):100,scalingType:this.getSettingValue(scalingSettingKey),pagesPerSheet:this.getSettingValue("pagesPerSheet"),dpiHorizontal:dpi&&"horizontal_dpi"in dpi?dpi.horizontal_dpi:0,dpiVertical:dpi&&"vertical_dpi"in dpi?dpi.vertical_dpi:0,dpiDefault:dpi&&"is_default"in dpi?dpi.is_default:false,deviceName:destination.id,pageWidth:this.pageSize.width,pageHeight:this.pageSize.height,showSystemDialog:showSystemDialog,printToGoogleDrive:destination.id===GooglePromotedDestinationId.SAVE_TO_DRIVE_CROS,printerManuallySelected:destination.printerManuallySelected};if(openPdfInPreview){ticket["openPDFInPreview"]=openPdfInPreview}if(this.getSettingValue("margins")===MarginsType.CUSTOM){ticket["marginsCustom"]=this.getSettingValue("customMargins")}if(destination.isExtension){ticket["ticket"]=this.createCloudJobTicket(destination);ticket["capabilities"]=JSON.stringify(destination.capabilities)}if(this.getSettingValue("pin")){ticket["pinValue"]=this.getSettingValue("pinValue")}if(destination.origin===DestinationOrigin.CROS){ticket["advancedSettings"]=this.getSettingValue("vendorItems");ticket["printerStatusReason"]=destination.printerStatusReason||PrinterStatusReason.UNKNOWN_REASON}return JSON.stringify(ticket)}createCloudJobTicket(destination){assert(destination.isExtension,"Trying to create a Google Cloud Print print ticket for a local "+" non-extension destination");assert(destination.capabilities,"Trying to create a Google Cloud Print print ticket for a "+"destination with no print capabilities");const cjt={version:"1.0",print:{}};if(this.settings.collate.available){cjt.print.collate={collate:this.settings.collate.value}}if(this.settings.color.available){const selectedOption=destination.getColor(this.settings.color.value);if(!selectedOption){console.warn("Could not find correct color option")}else{cjt.print.color={type:selectedOption.type};if(selectedOption.hasOwnProperty("vendor_id")){cjt.print.color.vendor_id=selectedOption.vendor_id}}}else{const defaultOption=destination.defaultColorOption;if(defaultOption){cjt.print.color={type:defaultOption.type};if(defaultOption.hasOwnProperty("vendor_id")){cjt.print.color.vendor_id=defaultOption.vendor_id}}}if(this.settings.copies.available){cjt.print.copies={copies:this.getSettingValue("copies")}}if(this.settings.duplex.available){cjt.print.duplex={type:this.getCddDuplexType_()}}if(this.settings.mediaSize.available){const mediaValue=this.settings.mediaSize.value;cjt.print.media_size={width_microns:mediaValue.width_microns,height_microns:mediaValue.height_microns,is_continuous_feed:mediaValue.is_continuous_feed,vendor_id:mediaValue.vendor_id}}if(!this.settings.layout.available){const capability=destination.capabilities.printer?destination.capabilities.printer.page_orientation:null;if(capability&&capability.option&&capability.option.some((option=>option.type==="AUTO"))){cjt.print.page_orientation={type:"AUTO"}}}else{cjt.print.page_orientation={type:this.settings.layout.value?"LANDSCAPE":"PORTRAIT"}}if(this.settings.dpi.available){const dpiValue=this.settings.dpi.value;cjt.print.dpi={horizontal_dpi:dpiValue.horizontal_dpi,vertical_dpi:dpiValue.vertical_dpi,vendor_id:dpiValue.vendor_id}}if(this.settings.vendorItems.available){const items=this.settings.vendorItems.value;cjt.print.vendor_ticket_item=[];for(const itemId in items){if(items.hasOwnProperty(itemId)){cjt.print.vendor_ticket_item.push({id:itemId,value:items[itemId]})}}}return JSON.stringify(cjt)}}customElements.define(PrintPreviewModelElement.is,PrintPreviewModelElement);
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class PrintServerStore extends EventTarget{constructor(addListenerCallback){super();this.nativeLayerCros_=NativeLayerCrosImpl.getInstance();this.printServersByName_=new Map;this.isSingleServerFetchingMode_=false;this.destinationStore_=null;addListenerCallback("print-servers-config-changed",(printServersConfig=>this.onPrintServersConfigChanged_(printServersConfig)));addListenerCallback("server-printers-loading",(isLoading=>this.onServerPrintersLoading_(isLoading)))}choosePrintServers(printServerName){const printServers=this.printServersByName_.get(printServerName);this.nativeLayerCros_.choosePrintServers(printServers?printServers.map((printServer=>printServer.id)):[])}async getPrintServersConfig(){const printServersConfig=await this.nativeLayerCros_.getPrintServersConfig();this.updatePrintServersConfig_(printServersConfig);return printServersConfig}setDestinationStore(destinationStore){this.destinationStore_=destinationStore}onPrintServersConfigChanged_(printServersConfig){this.updatePrintServersConfig_(printServersConfig);const eventData={printServerNames:Array.from(this.printServersByName_.keys()),isSingleServerFetchingMode:this.isSingleServerFetchingMode_};this.dispatchEvent(new CustomEvent(PrintServerStoreEventType.PRINT_SERVERS_CHANGED,{detail:eventData}))}updatePrintServersConfig_(printServersConfig){this.isSingleServerFetchingMode_=printServersConfig.isSingleServerFetchingMode;this.printServersByName_=new Map;for(const printServer of printServersConfig.printServers){if(this.printServersByName_.has(printServer.name)){this.printServersByName_.get(printServer.name).push(printServer)}else{this.printServersByName_.set(printServer.name,[printServer])}}}async onServerPrintersLoading_(isLoading){if(!isLoading&&this.destinationStore_){await this.destinationStore_.reloadLocalPrinters()}this.dispatchEvent(new CustomEvent(PrintServerStoreEventType.SERVER_PRINTERS_LOADING,{detail:isLoading}))}}var PrintServerStoreEventType;(function(PrintServerStoreEventType){PrintServerStoreEventType["PRINT_SERVERS_CHANGED"]="PrintServerStore.PRINT_SERVERS_CHANGED";PrintServerStoreEventType["SERVER_PRINTERS_LOADING"]="PrintServerStore.SERVER_PRINTERS_LOADING"})(PrintServerStoreEventType||(PrintServerStoreEventType={}));
// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class Size{constructor(width,height){this.width_=width;this.height_=height}get width(){return this.width_}get height(){return this.height_}equals(other){return other!==null&&this.width_===other.width_&&this.height_===other.height_}}
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var State;(function(State){State[State["NOT_READY"]=0]="NOT_READY";State[State["READY"]=1]="READY";State[State["PRINT_PENDING"]=2]="PRINT_PENDING";State[State["HIDDEN"]=3]="HIDDEN";State[State["PRINTING"]=4]="PRINTING";State[State["SYSTEM_DIALOG"]=5]="SYSTEM_DIALOG";State[State["ERROR"]=6]="ERROR";State[State["FATAL_ERROR"]=7]="FATAL_ERROR";State[State["CLOSING"]=8]="CLOSING"})(State||(State={}));var Error$1;(function(Error){Error[Error["NONE"]=0]="NONE";Error[Error["INVALID_TICKET"]=1]="INVALID_TICKET";Error[Error["INVALID_PRINTER"]=2]="INVALID_PRINTER";Error[Error["NO_DESTINATIONS"]=3]="NO_DESTINATIONS";Error[Error["PREVIEW_FAILED"]=4]="PREVIEW_FAILED";Error[Error["PRINT_FAILED"]=5]="PRINT_FAILED";Error[Error["MAX_BUCKET"]=6]="MAX_BUCKET"})(Error$1||(Error$1={}));class PrintPreviewStateElement extends PolymerElement{static get is(){return"print-preview-state"}static get properties(){return{state:{type:Number,notify:true,value:State.NOT_READY},error:{type:Number,notify:true,value:Error$1.NONE}}}transitTo(newState){switch(newState){case State.NOT_READY:assert(this.state===State.NOT_READY||this.state===State.READY||this.state===State.ERROR);break;case State.READY:assert(this.state===State.ERROR||this.state===State.NOT_READY||this.state===State.PRINTING);break;case State.PRINT_PENDING:assert(this.state===State.READY);break;case State.HIDDEN:assert(this.state===State.PRINT_PENDING);break;case State.PRINTING:assert(this.state===State.READY||this.state===State.HIDDEN||this.state===State.PRINT_PENDING);break;case State.SYSTEM_DIALOG:assert(this.state!==State.HIDDEN&&this.state!==State.PRINTING&&this.state!==State.CLOSING);break;case State.ERROR:assert(this.state===State.ERROR||this.state===State.NOT_READY||this.state===State.READY);break;case State.CLOSING:assert(this.state!==State.HIDDEN);break}this.state=newState;if(newState!==State.ERROR&&newState!==State.FATAL_ERROR){this.error=Error$1.NONE}}}customElements.define(PrintPreviewStateElement.is,PrintPreviewStateElement);const prefersDark=window.matchMedia("(prefers-color-scheme: dark)");const DarkModeMixin=dedupingMixin((superClass=>{class DarkModeMixin extends superClass{constructor(){super(...arguments);this.boundOnChange_=null}static get properties(){return{inDarkMode:{type:Boolean,value:prefersDark.matches}}}connectedCallback(){super.connectedCallback();if(!this.boundOnChange_){this.boundOnChange_=()=>this.onChange_()}prefersDark.addListener(this.boundOnChange_)}disconnectedCallback(){super.disconnectedCallback();prefersDark.removeListener(this.boundOnChange_);this.boundOnChange_=null}onChange_(){this.inDarkMode=prefersDark.matches}}return DarkModeMixin}));function inDarkMode(){return prefersDark.matches}
// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function areRangesEqual(array1,array2){if(array1.length!==array2.length){return false}for(let i=0;i<array1.length;i++){if(array1[i].from!==array2[i].from||array1[i].to!==array2[i].to){return false}}return true}function getStringForLocale(localizedStrings,locale){locale=locale.toLowerCase();for(let i=0;i<localizedStrings.length;i++){if(localizedStrings[i].locale.toLowerCase()===locale){return localizedStrings[i].value}}return""}function getStringForCurrentLocale(localizedStrings){return getStringForLocale(localizedStrings,navigator.language)||getStringForLocale(localizedStrings,navigator.language.split("-")[0])}function observerDepsDefined(args){return args.every((arg=>arg!==undefined))}function getSelectDropdownBackground(iconset,iconName,el){const serializer=new XMLSerializer;const iconElement=iconset.createIcon(iconName);assert(iconElement);const dark=inDarkMode();const fillColor=getComputedStyle(el).getPropertyValue(dark?"--google-grey-500":"--google-grey-600");iconElement.style.fill=fillColor;const serializedIcon=serializer.serializeToString(iconElement);const uri=encodeURIComponent(serializedIcon);const arrowDownPath=dark?"chrome://resources/images/dark/arrow_down.svg":"chrome://resources/images/arrow_down.svg";return`url("data:image/svg+xml;charset=utf-8,${uri}"),`+`url("${arrowDownPath}")`}let instance$6=null;function getCss$5(){return instance$6||(instance$6=[...[],css`.cr-scrollable{anchor-name:--cr-scrollable;anchor-scope:--cr-scrollable;container-type:scroll-state;overflow:auto}.cr-scrollable-top,.cr-scrollable-top-shadow,.cr-scrollable-bottom{display:none;position:fixed;position-anchor:--cr-scrollable;left:anchor(left);width:anchor-size(width);pointer-events:none;&:where(.force-on){display:block}}.cr-scrollable-top{top:anchor(top);border-top:1px solid var(--cr-scrollable-border-color);@container scroll-state(scrollable:top){display:block}}.cr-scrollable-bottom{bottom:anchor(bottom);border-bottom:1px solid var(--cr-scrollable-border-color);@container scroll-state(scrollable:bottom){display:block}}.cr-scrollable-top-shadow{box-shadow:inset 0 5px 6px -3px rgba(0,0,0,.4);display:block;height:8px;opacity:0;top:anchor(top);transition:opacity 500ms;z-index:1;&:where(.force-on){opacity:1}@container scroll-state(scrollable:top){opacity:1}}`])}let instance$5=null;function getCss$4(){return instance$5||(instance$5=[...[getCss$e(),getCss$9(),getCss$5()],css`dialog{background-color:var(--cr-dialog-background-color,white);border:0;border-radius:var(--cr-dialog-border-radius,8px);bottom:50%;box-shadow:0 0 16px rgba(0,0,0,0.12),0 16px 16px rgba(0,0,0,0.24);color:inherit;line-height:20px;max-height:initial;max-width:initial;overflow-y:hidden;padding:0;position:absolute;top:50%;width:var(--cr-dialog-width,512px)}@media (prefers-color-scheme:dark){dialog{background-color:var(--cr-dialog-background-color,var(--google-grey-900));background-image:linear-gradient(rgba(255,255,255,.04),rgba(255,255,255,.04))}}@media (forced-colors:active){dialog{border:var(--cr-border-hcm)}}dialog[open] #content-wrapper{display:flex;flex-direction:column;max-height:100vh;overflow:auto}.top-container,:host ::slotted([slot=button-container]),:host ::slotted([slot=footer]){flex-shrink:0}dialog::backdrop{background-color:rgba(0,0,0,0.6);bottom:0;left:0;position:fixed;right:0;top:0}:host ::slotted([slot=body]){color:var(--cr-secondary-text-color);padding:0 var(--cr-dialog-body-padding-horizontal,20px)}:host ::slotted([slot=title]){color:var(--cr-primary-text-color);flex:1;font-family:var(--cr-dialog-font-family,inherit);font-size:var(--cr-dialog-title-font-size,calc(15 / 13 * 100%));line-height:1;padding-bottom:var(--cr-dialog-title-slot-padding-bottom,16px);padding-inline-end:var(--cr-dialog-title-slot-padding-end,20px);padding-inline-start:var(--cr-dialog-title-slot-padding-start,20px);padding-top:var(--cr-dialog-title-slot-padding-top,20px)}:host ::slotted([slot=button-container]){display:flex;justify-content:flex-end;padding-bottom:var(--cr-dialog-button-container-padding-bottom,16px);padding-inline-end:var(--cr-dialog-button-container-padding-horizontal,16px);padding-inline-start:var(--cr-dialog-button-container-padding-horizontal,16px);padding-top:var(--cr-dialog-button-container-padding-top,16px)}:host ::slotted([slot=footer]){border-bottom-left-radius:inherit;border-bottom-right-radius:inherit;border-top:1px solid #dbdbdb;margin:0;padding:16px 20px}:host([hide-backdrop]) dialog::backdrop{opacity:0}@media (prefers-color-scheme:dark){:host ::slotted([slot=footer]){border-top-color:var(--cr-separator-color)}}.body-container{box-sizing:border-box;display:flex;flex-direction:column;min-height:1.375rem;overflow:auto}.top-container{align-items:flex-start;display:flex;min-height:var(--cr-dialog-top-container-min-height,31px)}.title-container{display:flex;flex:1;font-size:inherit;font-weight:inherit;margin:0;outline:none}#close{align-self:flex-start;margin-inline-end:4px;margin-top:4px}@container style(--cr-dialog-body-border-top){.cr-scrollable-top{display:block;border-top:var(--cr-dialog-body-border-top)}}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$3(){return html`
<dialog id="dialog" @close="${this.onNativeDialogClose_}"
    @cancel="${this.onNativeDialogCancel_}" part="dialog"
    aria-labelledby="title"
    aria-description="${this.ariaDescriptionText||nothing}">
<!-- This wrapper is necessary, such that the "pulse" animation is not
    erroneously played when the user clicks on the outer-most scrollbar. -->
  <div id="content-wrapper" part="wrapper">
    <div class="top-container">
      <h2 id="title" class="title-container" tabindex="-1">
        <slot name="title"></slot>
      </h2>
      ${this.showCloseButton?html`
        <cr-icon-button id="close" class="icon-clear"
            aria-label="${this.closeText||nothing}"
            title="${this.closeText||nothing}"
            @click="${this.cancel}" @keypress="${this.onCloseKeypress_}">
        </cr-icon-button>
       `:""}
    </div>
    <slot name="header"></slot>
    <div class="body-container cr-scrollable" id="container"
        part="body-container">
      <div class="cr-scrollable-top"></div>
      <slot name="body"></slot>
      <div class="cr-scrollable-bottom"></div>
    </div>
    <slot name="button-container"></slot>
    <slot name="footer"></slot>
  </div>
</dialog>`}
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class CrDialogElement extends CrLitElement{static get is(){return"cr-dialog"}static get styles(){return getCss$4()}render(){return getHtml$3.bind(this)()}static get properties(){return{open:{type:Boolean,reflect:true},closeText:{type:String},ignorePopstate:{type:Boolean},ignoreEnterKey:{type:Boolean},consumeKeydownEvent:{type:Boolean},noCancel:{type:Boolean},showCloseButton:{type:Boolean},showOnAttach:{type:Boolean},ariaDescriptionText:{type:String}}}#closeText_accessor_storage;get closeText(){return this.#closeText_accessor_storage}set closeText(value){this.#closeText_accessor_storage=value}#consumeKeydownEvent_accessor_storage=false;get consumeKeydownEvent(){return this.#consumeKeydownEvent_accessor_storage}set consumeKeydownEvent(value){this.#consumeKeydownEvent_accessor_storage=value}#ignoreEnterKey_accessor_storage=false;get ignoreEnterKey(){return this.#ignoreEnterKey_accessor_storage}set ignoreEnterKey(value){this.#ignoreEnterKey_accessor_storage=value}#ignorePopstate_accessor_storage=false;get ignorePopstate(){return this.#ignorePopstate_accessor_storage}set ignorePopstate(value){this.#ignorePopstate_accessor_storage=value}#noCancel_accessor_storage=false;get noCancel(){return this.#noCancel_accessor_storage}set noCancel(value){this.#noCancel_accessor_storage=value}#open_accessor_storage=false;get open(){return this.#open_accessor_storage}set open(value){this.#open_accessor_storage=value}#showCloseButton_accessor_storage=false;get showCloseButton(){return this.#showCloseButton_accessor_storage}set showCloseButton(value){this.#showCloseButton_accessor_storage=value}#showOnAttach_accessor_storage=false;get showOnAttach(){return this.#showOnAttach_accessor_storage}set showOnAttach(value){this.#showOnAttach_accessor_storage=value}#ariaDescriptionText_accessor_storage;get ariaDescriptionText(){return this.#ariaDescriptionText_accessor_storage}set ariaDescriptionText(value){this.#ariaDescriptionText_accessor_storage=value}mutationObserver_=null;boundKeydown_=null;firstUpdated(){window.addEventListener("popstate",(()=>{if(!this.ignorePopstate&&this.$.dialog.open){this.cancel()}}));if(!this.ignoreEnterKey){this.addEventListener("keypress",this.onKeypress_.bind(this))}this.addEventListener("pointerdown",(e=>this.onPointerdown_(e)))}connectedCallback(){super.connectedCallback();const mutationObserverCallback=()=>{if(this.$.dialog.open){this.addKeydownListener_()}else{this.removeKeydownListener_()}};this.mutationObserver_=new MutationObserver(mutationObserverCallback);this.mutationObserver_.observe(this.$.dialog,{attributes:true,attributeFilter:["open"]});mutationObserverCallback();if(this.showOnAttach){this.showModal()}}disconnectedCallback(){super.disconnectedCallback();this.removeKeydownListener_();if(this.mutationObserver_){this.mutationObserver_.disconnect();this.mutationObserver_=null}}addKeydownListener_(){if(!this.consumeKeydownEvent){return}this.boundKeydown_=this.boundKeydown_||this.onKeydown_.bind(this);this.addEventListener("keydown",this.boundKeydown_);document.body.addEventListener("keydown",this.boundKeydown_)}removeKeydownListener_(){if(!this.boundKeydown_){return}this.removeEventListener("keydown",this.boundKeydown_);document.body.removeEventListener("keydown",this.boundKeydown_);this.boundKeydown_=null}async showModal(){if(this.showOnAttach){const element=this.querySelector("[autofocus]");if(element&&element instanceof CrLitElement&&!element.shadowRoot){element.ensureInitialRender()}}this.$.dialog.showModal();assert(this.$.dialog.open);this.open=true;await this.updateComplete;this.fire("cr-dialog-open")}cancel(){this.fire("cancel");this.$.dialog.close();assert(!this.$.dialog.open);this.open=false}close(){this.$.dialog.close("success");assert(!this.$.dialog.open);this.open=false}setTitleAriaLabel(title){this.$.dialog.removeAttribute("aria-labelledby");this.$.dialog.setAttribute("aria-label",title)}onCloseKeypress_(e){e.stopPropagation()}onNativeDialogClose_(e){if(e.target!==this.getNative()){return}this.fire("close")}async onNativeDialogCancel_(e){if(e.target!==this.getNative()){return}if(this.noCancel){e.preventDefault();return}this.open=false;await this.updateComplete;this.fire("cancel")}getNative(){return this.$.dialog}onKeypress_(e){if(e.key!=="Enter"){return}const accept=e.target===this||e.composedPath().some((el=>el.tagName==="CR-INPUT"&&el.type!=="search"));if(!accept){return}const actionButton=this.querySelector(".action-button:not([disabled]):not([hidden])");if(actionButton){actionButton.click();e.preventDefault()}}onKeydown_(e){assert(this.consumeKeydownEvent);if(!this.getNative().open){return}if(this.ignoreEnterKey&&e.key==="Enter"){return}e.stopPropagation()}onPointerdown_(e){if(e.button!==0||e.composedPath()[0].tagName!=="DIALOG"){return}this.$.dialog.animate([{transform:"scale(1)",offset:0},{transform:"scale(1.02)",offset:.4},{transform:"scale(1.02)",offset:.6},{transform:"scale(1)",offset:1}],{duration:180,easing:"ease-in-out",iterations:1});e.preventDefault()}focus(){const titleContainer=this.shadowRoot.querySelector(".title-container");assert(titleContainer);titleContainer.focus()}}customElements.define(CrDialogElement.is,CrDialogElement);const styleMod$a=document.createElement("dom-module");styleMod$a.appendChild(html$1`
  <template>
    <style>
[hidden],:host([hidden]){display:none !important}
    </style>
  </template>
`.content);styleMod$a.register("cr-hidden-style");const styleMod$9=document.createElement("dom-module");styleMod$9.appendChild(html$1`
  <template>
    <style>
.search-bubble{--search-bubble-color:#ffeb3b;position:absolute;z-index:1}.search-bubble-innards{align-items:center;background-color:var(--search-bubble-color);border-radius:2px;color:var(--google-grey-900);max-width:100px;min-width:64px;overflow:hidden;padding:4px 10px;text-align:center;text-overflow:ellipsis;white-space:nowrap}.search-bubble-innards::after{background-color:var(--search-bubble-color);content:'';height:10px;left:calc(50% - 5px);position:absolute;top:-5px;transform:rotate(-45deg);width:10px;z-index:-1}.search-bubble-innards.above::after{bottom:-5px;top:auto;transform:rotate(-135deg)}
    </style>
  </template>
`.content);styleMod$9.register("search-highlight-style");const styleMod$8=document.createElement("dom-module");styleMod$8.appendChild(html$1`
  <template>
    <style>
.md-select{--md-arrow-width:7px;--md-select-bg-color:transparent;--md-select-option-bg-color:white;--md-select-side-padding:10px;--md-select-text-color:inherit;-webkit-appearance:none;background:url(//resources/images/arrow_down.svg) calc(100% - var(--md-select-side-padding)) center no-repeat;background-color:var(--md-select-bg-color);background-size:var(--md-arrow-width);border:solid 1px var(--color-combobox-container-outline,var(--cr-fallback-color-neutral-outline));border-radius:8px;box-sizing:border-box;color:var(--md-select-text-color);cursor:pointer;font-family:inherit;font-size:12px;height:36px;max-width:100%;outline:none;padding-block-end:0;padding-block-start:0;padding-inline-end:calc(var(--md-select-side-padding) + var(--md-arrow-width) + 3px);padding-inline-start:var(--md-select-side-padding);width:var(--md-select-width,200px)}@media (prefers-color-scheme:dark){.md-select{--md-select-option-bg-color:var(--google-grey-900-white-4-percent);background-image:url(//resources/images/dark/arrow_down.svg)}}.md-select:hover{background-color:var(--color-comboxbox-ink-drop-hovered,var(--cr-hover-on-subtle-background-color))}.md-select :-webkit-any(option,optgroup){background-color:var(--md-select-option-bg-color)}.md-select[disabled]{background-color:var(--color-combobox-background-disabled,var(--cr-fallback-color-disabled-background));border-color:transparent;color:var(--color-textfield-foreground-disabled,var(--cr-fallback-color-disabled-foreground));opacity:1;pointer-events:none}.md-select:focus{outline:solid 2px var(--cr-focus-outline-color);outline-offset:-1px}:host-context([dir=rtl]) .md-select{background-position-x:var(--md-select-side-padding)}
    </style>
  </template>
`.content);styleMod$8.register("md-select");const styleMod$7=document.createElement("dom-module");styleMod$7.appendChild(html$1`
  <template>
    <style>
.icon-arrow-back{--cr-icon-image:url(//resources/images/icon_arrow_back.svg)}.icon-arrow-dropdown{--cr-icon-image:url(//resources/images/icon_arrow_dropdown.svg)}.icon-arrow-drop-down-cr23{--cr-icon-image:url(//resources/images/icon_arrow_drop_down_cr23.svg)}.icon-arrow-drop-up-cr23{--cr-icon-image:url(//resources/images/icon_arrow_drop_up_cr23.svg)}.icon-arrow-upward{--cr-icon-image:url(//resources/images/icon_arrow_upward.svg)}.icon-cancel{--cr-icon-image:url(//resources/images/icon_cancel.svg)}.icon-clear{--cr-icon-image:url(//resources/images/icon_clear.svg)}.icon-copy-content{--cr-icon-image:url(//resources/images/icon_copy_content.svg)}.icon-delete-gray{--cr-icon-image:url(//resources/images/icon_delete_gray.svg)}.icon-edit{--cr-icon-image:url(//resources/images/icon_edit.svg)}.icon-file{--cr-icon-image:url(//resources/images/icon_filetype_generic.svg)}.icon-folder-open{--cr-icon-image:url(//resources/images/icon_folder_open.svg)}.icon-picture-delete{--cr-icon-image:url(//resources/images/icon_picture_delete.svg)}.icon-expand-less{--cr-icon-image:url(//resources/images/icon_expand_less.svg)}.icon-expand-more{--cr-icon-image:url(//resources/images/icon_expand_more.svg)}.icon-external{--cr-icon-image:url(//resources/images/open_in_new.svg)}.icon-more-vert{--cr-icon-image:url(//resources/images/icon_more_vert.svg)}.icon-refresh{--cr-icon-image:url(//resources/images/icon_refresh.svg)}.icon-search{--cr-icon-image:url(//resources/images/icon_search.svg)}.icon-settings{--cr-icon-image:url(//resources/images/icon_settings.svg)}.icon-visibility{--cr-icon-image:url(//resources/images/icon_visibility.svg)}.icon-visibility-off{--cr-icon-image:url(//resources/images/icon_visibility_off.svg)}.subpage-arrow{--cr-icon-image:url(//resources/images/arrow_right.svg)}.cr-icon{-webkit-mask-image:var(--cr-icon-image);-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:var(--cr-icon-size);background-color:var(--cr-icon-color,var(--google-grey-700));flex-shrink:0;height:var(--cr-icon-ripple-size);margin-inline-end:var(--cr-icon-ripple-margin);margin-inline-start:var(--cr-icon-button-margin-start);user-select:none;width:var(--cr-icon-ripple-size)}:host-context([dir=rtl]) .cr-icon{transform:scaleX(-1)}.cr-icon.no-overlap{margin-inline-end:0;margin-inline-start:0}@media (prefers-color-scheme:dark){.cr-icon{background-color:var(--cr-icon-color,var(--google-grey-500))}}
    </style>
  </template>
`.content);styleMod$7.register("cr-icons");const styleMod$6=document.createElement("dom-module");styleMod$6.appendChild(html$1`
  <template>
    <style include="cr-hidden-style cr-icons">
[actionable]{cursor:pointer}.hr{border-top:var(--cr-separator-line)}iron-list.cr-separators>*:not([first]){border-top:var(--cr-separator-line)}[scrollable]{border-color:transparent;border-style:solid;border-width:1px 0;overflow-y:auto}[scrollable].is-scrolled{border-top-color:var(--cr-scrollable-border-color)}[scrollable].can-scroll:not(.scrolled-to-bottom){border-bottom-color:var(--cr-scrollable-border-color)}[scrollable] iron-list>:not(.no-outline):focus-visible,[selectable]:focus-visible,[selectable]>:focus-visible{outline:solid 2px var(--cr-focus-outline-color);outline-offset:-2px}.scroll-container{display:flex;flex-direction:column;min-height:1px}[selectable]>*{cursor:pointer}.cr-centered-card-container{box-sizing:border-box;display:block;height:inherit;margin:0 auto;max-width:var(--cr-centered-card-max-width);min-width:550px;position:relative;width:calc(100% * var(--cr-centered-card-width-percentage))}.cr-container-shadow{box-shadow:inset 0 5px 6px -3px rgba(0,0,0,.4);height:var(--cr-container-shadow-height);left:0;margin:0 0 var(--cr-container-shadow-margin);opacity:0;pointer-events:none;position:relative;right:0;top:0;transition:opacity 500ms;z-index:1}#cr-container-shadow-bottom{margin-bottom:0;margin-top:var(--cr-container-shadow-margin);transform:scaleY(-1)}#cr-container-shadow-top:has(+#container.can-scroll:not(.scrolled-to-top)),#container.can-scroll:not(.scrolled-to-bottom)+#cr-container-shadow-bottom,#cr-container-shadow-bottom.force-shadow,#cr-container-shadow-top.force-shadow{opacity:var(--cr-container-shadow-max-opacity)}.cr-row{align-items:center;border-top:var(--cr-separator-line);display:flex;min-height:var(--cr-section-min-height);padding:0 var(--cr-section-padding)}.cr-row.first,.cr-row.continuation{border-top:none}.cr-row-gap{padding-inline-start:16px}.cr-button-gap{margin-inline-start:8px}paper-tooltip::part(tooltip),cr-tooltip::part(tooltip){border-radius:var(--paper-tooltip-border-radius,2px);font-size:92.31%;font-weight:500;max-width:330px;min-width:var(--paper-tooltip-min-width,200px);padding:var(--paper-tooltip-padding,10px 8px)}.cr-padded-text{padding-block-end:var(--cr-section-vertical-padding);padding-block-start:var(--cr-section-vertical-padding)}.cr-title-text{color:var(--cr-title-text-color);font-size:107.6923%;font-weight:500}.cr-secondary-text{color:var(--cr-secondary-text-color);font-weight:400}.cr-form-field-label{color:var(--cr-form-field-label-color);display:block;font-size:var(--cr-form-field-label-font-size);font-weight:500;letter-spacing:.4px;line-height:var(--cr-form-field-label-line-height);margin-bottom:8px}.cr-vertical-tab{align-items:center;display:flex}.cr-vertical-tab::before{border-radius:0 3px 3px 0;content:'';display:block;flex-shrink:0;height:var(--cr-vertical-tab-height,100%);width:4px}.cr-vertical-tab.selected::before{background:var(--cr-vertical-tab-selected-color,var(--cr-checked-color))}:host-context([dir=rtl]) .cr-vertical-tab::before{transform:scaleX(-1)}.iph-anchor-highlight{background-color:var(--cr-iph-anchor-highlight-color)}
    </style>
  </template>
`.content);styleMod$6.register("cr-shared-style");const sheet=new CSSStyleSheet;sheet.replaceSync(`html{--print-preview-row-height:38px;--print-preview-sidebar-width:384px;--print-preview-title-width:120px;--print-preview-sidebar-margin:24px;--print-preview-dropdown-width:calc(var(--print-preview-sidebar-width) - var(--print-preview-title-width) - 3 * var(--print-preview-sidebar-margin));--print-preview-settings-border:1px solid var(--google-grey-200);--print-preview-dialog-margin:34px;--cr-form-field-label-height:initial;--cr-form-field-label-line-height:.75rem;--destination-item-height:32px;--preview-area-background-color:var(--google-grey-300);--iron-icon-fill-color:var(--google-grey-700);--iron-icon-height:var(--cr-icon-size);--iron-icon-width:var(--cr-icon-size);--search-icon-size:32px;--throbber-size:16px;--error-status-alert:var(--google-red-600);--error-status-warning:#e37400}@media (prefers-color-scheme:dark){html{--preview-area-background-color:var(--google-grey-700);--print-preview-settings-border:var(--cr-separator-line);--iron-icon-fill-color:var(--google-grey-500);--error-status-alert:var(--google-red-300);--error-status-warning:#fdd663}}`);document.adoptedStyleSheets=[...document.adoptedStyleSheets,sheet];const styleMod$5=document.createElement("dom-module");styleMod$5.appendChild(html$1`
  <template>
    <style include="cr-shared-style">
select.md-select{margin-bottom:2px;margin-top:2px;min-height:32px;padding-inline-end:32px;user-select:none;--md-select-width:calc(100% - 2 * var(--print-preview-sidebar-margin))}.checkbox cr-checkbox{min-height:var(--print-preview-row-height)}.checkbox cr-checkbox::part(label-container){overflow:hidden;padding-inline-start:16px}cr-input{line-height:20px}cr-input::part(row-container){min-height:var(--print-preview-row-height)}print-preview-settings-section [slot=controls]>*{margin:0 var(--print-preview-sidebar-margin)}cr-dialog::part(wrapper){max-height:calc(100vh - 68px);max-width:100%;width:calc(100vw - 68px)}cr-dialog [slot=body]{box-sizing:border-box}#dialog div[slot='title']{padding-bottom:8px}#dialog div[slot='button-container']{align-items:center;box-shadow:0 -1px 1px 0 var(--cr-separator-color);min-height:64px;padding-bottom:0;padding-top:0}
    </style>
  </template>
`.content);styleMod$5.register("print-preview-shared");
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const WRAPPER_CSS_CLASS="search-highlight-wrapper";const ORIGINAL_CONTENT_CSS_CLASS="search-highlight-original-content";const HIT_CSS_CLASS="search-highlight-hit";const SEARCH_BUBBLE_CSS_CLASS="search-bubble";function removeHighlights(wrappers){for(const wrapper of wrappers){if(!wrapper.parentElement){continue}const originalContent=wrapper.querySelector(`.${ORIGINAL_CONTENT_CSS_CLASS}`);assert(originalContent);const textNode=originalContent.firstChild;assert(textNode);wrapper.parentElement.replaceChild(textNode,wrapper)}}function highlight(node,ranges){assert(ranges.length>0);const wrapper=document.createElement("span");wrapper.classList.add(WRAPPER_CSS_CLASS);assert(node.parentNode);node.parentNode.replaceChild(wrapper,node);const span=document.createElement("span");span.classList.add(ORIGINAL_CONTENT_CSS_CLASS);span.style.display="none";span.appendChild(node);wrapper.appendChild(span);const text=node.textContent;const tokens=[];for(let i=0;i<ranges.length;++i){const range=ranges[i];const prev=ranges[i-1]||{start:0,length:0};const start=prev.start+prev.length;const length=range.start-start;tokens.push(text.substr(start,length));tokens.push(text.substr(range.start,range.length))}const last=ranges.slice(-1)[0];tokens.push(text.substr(last.start+last.length));for(let i=0;i<tokens.length;++i){if(i%2===0){wrapper.appendChild(document.createTextNode(tokens[i]))}else{const hitSpan=document.createElement("span");hitSpan.classList.add(HIT_CSS_CLASS);hitSpan.style.backgroundColor="var(--search-highlight-hit-background-color, #ffeb3b)";hitSpan.style.color="var(--search-highlight-hit-color, #202124)";hitSpan.textContent=tokens[i];wrapper.appendChild(hitSpan)}}return wrapper}function createEmptySearchBubble(node,horizontallyCenter){let anchor=node;if(node.nodeName==="SELECT"){anchor=node.parentNode}if(anchor instanceof ShadowRoot){anchor=anchor.host.parentNode}let searchBubble=anchor.querySelector(`.${SEARCH_BUBBLE_CSS_CLASS}`);if(searchBubble){return searchBubble}searchBubble=document.createElement("div");searchBubble.classList.add(SEARCH_BUBBLE_CSS_CLASS);const innards=document.createElement("div");innards.classList.add("search-bubble-innards");innards.textContent=" ";searchBubble.appendChild(innards);anchor.appendChild(searchBubble);const updatePosition=function(){const nodeEl=node;assert(searchBubble);assert(typeof nodeEl.offsetTop==="number");searchBubble.style.top=nodeEl.offsetTop+(innards.classList.contains("above")?-searchBubble.offsetHeight:nodeEl.offsetHeight)+"px"};updatePosition();searchBubble.addEventListener("mouseover",(function(){innards.classList.toggle("above");updatePosition()}));return searchBubble}function stripDiacritics(text){return text.normalize("NFD").replace(/[\u0300-\u036f]/g,"")}function getTemplate$B(){return html$1`<!--_html_template_start_--><style include="print-preview-shared md-select search-highlight-style
    cr-hidden-style">:host{display:flex;min-height:54px;position:relative}:host>*{overflow:hidden;text-overflow:ellipsis;vertical-align:middle}.label,.value{align-self:center;color:var(--cr-primary-text-color);overflow:hidden}.label{flex:1;min-width:96px;opacity:0.87}.value{flex:0;min-width:239px;text-overflow:ellipsis;white-space:nowrap}.value>*{display:flex;margin-inline-start:10px}cr-input{width:239px;--cr-input-error-display:none}select.md-select{font-size:1em}</style>
<label class="label searchable">[[getDisplayName_(capability)]]</label>
<div class="value">
  <template is="dom-if" if="[[isCapabilityTypeSelect_(capability)]]"
      restamp>
    <div>
      <select class="md-select" on-change="onUserInput_">
        <template is="dom-repeat" items="[[capability.select_cap.option]]">
          <option class="searchable" text="[[getDisplayName_(item)]]"
              value="[[item.value]]"
              selected="[[isOptionSelected_(item, currentValue_)]]">
          </option>
        </template>
      </select>
    </div>
  </template>
  <span hidden$="[[!isCapabilityTypeInput_(capability)]]">
    <cr-input type="text" on-input="onUserInput_" spellcheck="false"
        placeholder="[[getCapabilityPlaceholder_(capability)]]">
    </cr-input>
  </span>
  <span hidden$="[[!isCapabilityTypeCheckbox_(capability)]]">
    <cr-checkbox on-change="onCheckboxInput_"
        checked="[[isChecked_(currentValue_)]]">
    </cr-checkbox>
  </span>
</div>
<!--_html_template_end_-->`}
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function updateHighlights(element,query,bubbles){const highlights=[];if(!query){return highlights}assert(query.global);element.shadowRoot.querySelectorAll(".searchable").forEach((childElement=>{childElement.childNodes.forEach((node=>{if(node.nodeType!==Node.TEXT_NODE){return}const textContent=node.nodeValue;if(textContent.trim().length===0){return}const strippedText=stripDiacritics(textContent);const ranges=[];for(let match;match=query.exec(strippedText);){ranges.push({start:match.index,length:match[0].length})}if(ranges.length>0){if(node.parentNode.nodeName==="OPTION"){assert(node.parentNode);assert(node.parentNode.parentNode);const bubble=createEmptySearchBubble(node.parentNode.parentNode);const numHits=ranges.length+(bubbles.get(bubble)||0);bubbles.set(bubble,numHits);const msgName=numHits===1?"searchResultBubbleText":"searchResultsBubbleText";bubble.firstChild.textContent=loadTimeData.getStringF(msgName,numHits)}else{highlights.push(highlight(node,ranges))}}}))}));return highlights}const SettingsMixin=dedupingMixin((superClass=>{class SettingsMixin extends superClass{static get properties(){return{settings:Object}}getSetting(settingName){return getInstance$1().getSetting(settingName)}getSettingValue(settingName){return getInstance$1().getSettingValue(settingName)}setSetting(settingName,value,noSticky){getInstance$1().setSetting(settingName,value,noSticky)}setSettingSplice(settingName,start,end,newValue,noSticky){getInstance$1().setSettingSplice(settingName,start,end,newValue,noSticky)}setSettingValid(settingName,valid){getInstance$1().setSettingValid(settingName,valid)}}return SettingsMixin}));
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PrintPreviewAdvancedSettingsItemElementBase=SettingsMixin(PolymerElement);class PrintPreviewAdvancedSettingsItemElement extends PrintPreviewAdvancedSettingsItemElementBase{static get is(){return"print-preview-advanced-settings-item"}static get template(){return getTemplate$B()}static get properties(){return{capability:Object,currentValue_:String}}static get observers(){return["updateFromSettings_(capability, settings.vendorItems.value)"]}updateFromSettings_(){const settings=this.getSetting("vendorItems").value;if(!settings.hasOwnProperty(this.capability.id)){return}const value=settings[this.capability.id];if(this.isCapabilityTypeSelect_()){if(this.hasOptionWithValue_(value)){this.currentValue_=value}}else{this.currentValue_=value;this.shadowRoot.querySelector("cr-input").value=this.currentValue_}}getDisplayName_(item){let displayName=item.display_name;if(!displayName&&item.display_name_localized){displayName=getStringForCurrentLocale(item.display_name_localized)}return displayName||""}isCapabilityTypeSelect_(){return this.capability.type==="SELECT"}isCapabilityTypeCheckbox_(){return this.capability.type==="TYPED_VALUE"&&this.capability.typed_value_cap.value_type==="BOOLEAN"}isCapabilityTypeInput_(){return!this.isCapabilityTypeSelect_()&&!this.isCapabilityTypeCheckbox_()}isChecked_(){return this.currentValue_==="true"}isOptionSelected_(option){return this.currentValue_===undefined?!!option.is_default:option.value===this.currentValue_}getCapabilityPlaceholder_(){if(this.capability.type==="TYPED_VALUE"&&this.capability.typed_value_cap&&this.capability.typed_value_cap.default!==undefined){return this.capability.typed_value_cap.default.toString()||""}if(this.capability.type==="RANGE"&&this.capability.range_cap&&this.capability.range_cap.default!==undefined){return this.capability.range_cap.default.toString()||""}return""}hasOptionWithValue_(value){return!!this.capability.select_cap&&!!this.capability.select_cap.option&&this.capability.select_cap.option.some((option=>option.value===value))}hasMatch(query){if(!query){return true}const strippedCapabilityName=stripDiacritics(this.getDisplayName_(this.capability));if(strippedCapabilityName.match(query)){return true}if(!this.isCapabilityTypeSelect_()){return false}for(const option of this.capability.select_cap.option){const strippedOptionName=stripDiacritics(this.getDisplayName_(option));if(strippedOptionName.match(query)){return true}}return false}onUserInput_(e){this.currentValue_=e.target.value}onCheckboxInput_(e){this.currentValue_=e.target.checked?"true":"false"}getCurrentValue(){return this.currentValue_||""}setCurrentValueForTest(value){this.currentValue_=value}updateHighlighting(query,bubbles){return updateHighlights(this,query,bubbles)}}customElements.define(PrintPreviewAdvancedSettingsItemElement.is,PrintPreviewAdvancedSettingsItemElement);
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CrSearchFieldMixin=dedupingMixin((superClass=>{class CrSearchFieldMixin extends superClass{static get properties(){return{label:{type:String,value:""},clearLabel:{type:String,value:""},hasSearchText:{type:Boolean,reflectToAttribute:true}}}effectiveValue_="";searchDelayTimer_=-1;getSearchInput(){assertNotReached()}getValue(){return this.getSearchInput().value}fire_(eventName,detail){this.dispatchEvent(new CustomEvent(eventName,{bubbles:true,composed:true,detail:detail}))}setValue(value,noEvent){const updated=this.updateEffectiveValue_(value);this.getSearchInput().value=this.effectiveValue_;if(!updated){if(value===""&&this.hasSearchText){this.hasSearchText=false}return}this.onSearchTermInput();if(!noEvent){this.fire_("search-changed",this.effectiveValue_)}}scheduleSearch_(){if(this.searchDelayTimer_>=0){clearTimeout(this.searchDelayTimer_)}const length=this.getValue().length;const timeoutMs=length>0?500-100*(Math.min(length,4)-1):0;this.searchDelayTimer_=setTimeout((()=>{this.getSearchInput().dispatchEvent(new CustomEvent("search",{composed:true,detail:this.getValue()}));this.searchDelayTimer_=-1}),timeoutMs)}onSearchTermSearch(){this.onValueChanged_(this.getValue(),false)}onSearchTermInput(){this.hasSearchText=this.getSearchInput().value!=="";this.scheduleSearch_()}onValueChanged_(newValue,noEvent){const updated=this.updateEffectiveValue_(newValue);if(updated&&!noEvent){this.fire_("search-changed",this.effectiveValue_)}}updateEffectiveValue_(value){const effectiveValue=value.replace(/\s+/g," ").replace(/^\s/,"");if(effectiveValue===this.effectiveValue_){return false}this.effectiveValue_=effectiveValue;return true}}return CrSearchFieldMixin}));
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const WebUiListenerMixin=dedupingMixin((superClass=>{class WebUiListenerMixin extends superClass{webUiListeners_=[];addWebUiListener(eventName,callback){this.webUiListeners_.push(addWebUiListener(eventName,callback))}disconnectedCallback(){super.disconnectedCallback();while(this.webUiListeners_.length>0){removeWebUiListener(this.webUiListeners_.pop())}}}return WebUiListenerMixin}));function getTemplate$A(){return html$1`<!--_html_template_start_--><style include="print-preview-shared cr-input-style">:host{display:flex;--cr-input-error-display:none}cr-input::part(row-container){min-height:32px}#icon,#clearSearch{margin-inline-end:0;margin-inline-start:0}#icon{height:var(--search-icon-size);width:var(--search-icon-size)}#clearSearch{--clear-icon-size:28px;--cr-icon-button-size:var(--clear-icon-size);--cr-icon-button-icon-size:20px;height:var(--clear-icon-size);position:absolute;right:0;width:var(--clear-icon-size);z-index:1}:host-context([dir=rtl]) #clearSearch{left:0;right:auto}:host([has-search-text]) cr-input{--cr-input-padding-end:24px}.search-box-input{width:100%}.search-box-input::-webkit-search-cancel-button{-webkit-appearance:none}</style>
<cr-input type="search" id="searchInput" class="search-box-input"
    on-search="onSearchTermSearch" on-input="onSearchTermInput"
    aria-label$="[[label]]" placeholder="[[label]]"
    autofocus="[[autofocus]]" spellcheck="false">
  <div slot="inline-prefix" id="icon" class="cr-icon icon-search" alt=""></div>
  <cr-icon-button id="clearSearch" class="icon-cancel"
      hidden$="[[!hasSearchText]]" slot="suffix" on-click="onClearClick_"
      title="$i18n{clearSearch}">
  </cr-icon-button>
</cr-input>
<!--_html_template_end_-->`}
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SANITIZE_REGEX=/[-[\]{}()*+?.,\\^$|#\s]/g;const PrintPreviewSearchBoxElementBase=CrSearchFieldMixin(WebUiListenerMixin(PolymerElement));class PrintPreviewSearchBoxElement extends PrintPreviewSearchBoxElementBase{constructor(){super(...arguments);this.lastQuery_=""}static get is(){return"print-preview-search-box"}static get template(){return getTemplate$A()}static get properties(){return{autofocus:Boolean,searchQuery:{type:Object,notify:true}}}ready(){super.ready();this.addEventListener("search-changed",(e=>this.onSearchChanged_(e)))}getSearchInput(){return this.$.searchInput}focus(){this.$.searchInput.focus()}onSearchChanged_(e){const strippedQuery=stripDiacritics(e.detail.trim());const safeQuery=strippedQuery.replace(SANITIZE_REGEX,"\\$&");if(safeQuery===this.lastQuery_){return}this.lastQuery_=safeQuery;this.searchQuery=safeQuery.length>0?new RegExp(`(${safeQuery})`,"ig"):null}onClearClick_(){this.setValue("");this.$.searchInput.focus()}}customElements.define(PrintPreviewSearchBoxElement.is,PrintPreviewSearchBoxElement);
// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function sanitizeInnerHtmlInternal(rawString,opts){opts=opts||{};const html=parseHtmlSubset(`<b>${rawString}</b>`,opts.tags,opts.attrs).firstElementChild;return html.innerHTML}let sanitizedPolicy=null;function sanitizeInnerHtml(rawString,opts){assert(window.trustedTypes);if(sanitizedPolicy===null){sanitizedPolicy=window.trustedTypes.createPolicy("sanitize-inner-html",{createHTML:sanitizeInnerHtmlInternal,createScript:()=>assertNotReached(),createScriptURL:()=>assertNotReached()})}return sanitizedPolicy.createHTML(rawString,opts)}const allowAttribute=(_node,_value)=>true;const allowedAttributes=new Map([["href",(node,value)=>node.tagName==="A"&&(value.startsWith("chrome://")||value.startsWith("https://")||value==="#")],["target",(node,value)=>node.tagName==="A"&&value==="_blank"]]);const allowedOptionalAttributes=new Map([["class",allowAttribute],["id",allowAttribute],["is",(_node,value)=>value==="action-link"||value===""],["role",(_node,value)=>value==="link"],["src",(node,value)=>node.tagName==="IMG"&&value.startsWith("chrome://")],["tabindex",allowAttribute],["aria-description",allowAttribute],["aria-hidden",allowAttribute],["aria-label",allowAttribute],["aria-labelledby",allowAttribute]]);const allowedTags=new Set(["A","B","I","BR","DIV","EM","KBD","P","PRE","SPAN","STRONG"]);const allowedOptionalTags=new Set(["IMG","LI","UL"]);let unsanitizedPolicy;function mergeTags(optTags){const clone=new Set(allowedTags);optTags.forEach((str=>{const tag=str.toUpperCase();if(allowedOptionalTags.has(tag)){clone.add(tag)}}));return clone}function mergeAttrs(optAttrs){const clone=new Map(allowedAttributes);optAttrs.forEach((key=>{if(allowedOptionalAttributes.has(key)){clone.set(key,allowedOptionalAttributes.get(key))}}));return clone}function walk(n,f){f(n);for(let i=0;i<n.childNodes.length;i++){walk(n.childNodes[i],f)}}function assertElement(tags,node){if(!tags.has(node.tagName)){throw Error(node.tagName+" is not supported")}}function assertAttribute(attrs,attrNode,node){const n=attrNode.nodeName;const v=attrNode.nodeValue||"";if(!attrs.has(n)||!attrs.get(n)(node,v)){throw Error(node.tagName+"["+n+'="'+v+'"] is not supported')}}function parseHtmlSubset(s,extraTags,extraAttrs){const tags=extraTags?mergeTags(extraTags):allowedTags;const attrs=extraAttrs?mergeAttrs(extraAttrs):allowedAttributes;const doc=document.implementation.createHTMLDocument("");const r=doc.createRange();r.selectNode(doc.body);if(window.trustedTypes){if(!unsanitizedPolicy){unsanitizedPolicy=window.trustedTypes.createPolicy("parse-html-subset",{createHTML:untrustedHTML=>untrustedHTML,createScript:()=>assertNotReached(),createScriptURL:()=>assertNotReached()})}s=unsanitizedPolicy.createHTML(s)}const df=r.createContextualFragment(s);walk(df,(function(node){switch(node.nodeType){case Node.ELEMENT_NODE:assertElement(tags,node);const nodeAttrs=node.attributes;for(let i=0;i<nodeAttrs.length;++i){assertAttribute(attrs,nodeAttrs[i],node)}break;case Node.COMMENT_NODE:case Node.DOCUMENT_FRAGMENT_NODE:case Node.TEXT_NODE:break;default:throw Error("Node type "+node.nodeType+" is not supported")}}));return df}
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const I18nMixin=dedupingMixin((superClass=>{class I18nMixin extends superClass{i18nRaw_(id,...varArgs){return varArgs.length===0?loadTimeData.getString(id):loadTimeData.getStringF(id,...varArgs)}i18n(id,...varArgs){const rawString=this.i18nRaw_(id,...varArgs);return parseHtmlSubset(`<b>${rawString}</b>`).firstChild.textContent}i18nAdvanced(id,opts){opts=opts||{};const rawString=this.i18nRaw_(id,...opts.substitutions||[]);return sanitizeInnerHtml(rawString,opts)}i18nDynamic(_locale,id,...varArgs){return this.i18n(id,...varArgs)}i18nRecursive(locale,id,...varArgs){let args=varArgs;if(args.length>0){args=args.map((str=>this.i18nExists(str)?loadTimeData.getString(str):str))}return this.i18nDynamic(locale,id,...args)}i18nExists(id){return loadTimeData.valueExists(id)}}return I18nMixin}));
// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var DestinationSearchBucket;(function(DestinationSearchBucket){DestinationSearchBucket[DestinationSearchBucket["DESTINATION_SHOWN"]=0]="DESTINATION_SHOWN";DestinationSearchBucket[DestinationSearchBucket["DESTINATION_CLOSED_CHANGED"]=1]="DESTINATION_CLOSED_CHANGED";DestinationSearchBucket[DestinationSearchBucket["DESTINATION_CLOSED_UNCHANGED"]=2]="DESTINATION_CLOSED_UNCHANGED";DestinationSearchBucket[DestinationSearchBucket["MANAGE_BUTTON_CLICKED"]=14]="MANAGE_BUTTON_CLICKED";DestinationSearchBucket[DestinationSearchBucket["DESTINATION_SEARCH_MAX_BUCKET"]=15]="DESTINATION_SEARCH_MAX_BUCKET"})(DestinationSearchBucket||(DestinationSearchBucket={}));var PrintSettingsUiBucket;(function(PrintSettingsUiBucket){PrintSettingsUiBucket[PrintSettingsUiBucket["ADVANCED_SETTINGS_DIALOG_SHOWN"]=0]="ADVANCED_SETTINGS_DIALOG_SHOWN";PrintSettingsUiBucket[PrintSettingsUiBucket["ADVANCED_SETTINGS_DIALOG_CANCELED"]=1]="ADVANCED_SETTINGS_DIALOG_CANCELED";PrintSettingsUiBucket[PrintSettingsUiBucket["MORE_SETTINGS_CLICKED"]=2]="MORE_SETTINGS_CLICKED";PrintSettingsUiBucket[PrintSettingsUiBucket["LESS_SETTINGS_CLICKED"]=3]="LESS_SETTINGS_CLICKED";PrintSettingsUiBucket[PrintSettingsUiBucket["PRINT_WITH_SETTINGS_EXPANDED"]=4]="PRINT_WITH_SETTINGS_EXPANDED";PrintSettingsUiBucket[PrintSettingsUiBucket["PRINT_WITH_SETTINGS_COLLAPSED"]=5]="PRINT_WITH_SETTINGS_COLLAPSED";PrintSettingsUiBucket[PrintSettingsUiBucket["PRINT_SETTINGS_UI_MAX_BUCKET"]=6]="PRINT_SETTINGS_UI_MAX_BUCKET"})(PrintSettingsUiBucket||(PrintSettingsUiBucket={}));var PrintPreviewLaunchSourceBucket;(function(PrintPreviewLaunchSourceBucket){PrintPreviewLaunchSourceBucket[PrintPreviewLaunchSourceBucket["PREVIEW_AREA_CONNECTION_ERROR"]=0]="PREVIEW_AREA_CONNECTION_ERROR";PrintPreviewLaunchSourceBucket[PrintPreviewLaunchSourceBucket["DESTINATION_DIALOG_CROS_NO_PRINTERS"]=1]="DESTINATION_DIALOG_CROS_NO_PRINTERS";PrintPreviewLaunchSourceBucket[PrintPreviewLaunchSourceBucket["DESTINATION_DIALOG_CROS_HAS_PRINTERS"]=2]="DESTINATION_DIALOG_CROS_HAS_PRINTERS";PrintPreviewLaunchSourceBucket[PrintPreviewLaunchSourceBucket["PRINT_PREVIEW_LAUNCH_SOURCE_MAX_BUCKET"]=3]="PRINT_PREVIEW_LAUNCH_SOURCE_MAX_BUCKET"})(PrintPreviewLaunchSourceBucket||(PrintPreviewLaunchSourceBucket={}));class MetricsContext{constructor(histogram,maxBucket){this.nativeLayer_=NativeLayerImpl.getInstance();this.histogram_=histogram;this.maxBucket_=maxBucket}record(bucket){this.nativeLayer_.recordInHistogram(this.histogram_,bucket>this.maxBucket_?this.maxBucket_:bucket,this.maxBucket_)}static printSettingsUi(){return new MetricsContext("PrintPreview.PrintSettingsUi",PrintSettingsUiBucket.PRINT_SETTINGS_UI_MAX_BUCKET)}static getLaunchPrinterSettingsMetricsContextCros(){return new MetricsContext("PrintPreview.PrinterSettingsLaunchSource",PrintPreviewLaunchSourceBucket.PRINT_PREVIEW_LAUNCH_SOURCE_MAX_BUCKET)}}function getTemplate$z(){return html$1`<!--_html_template_start_--><style include="print-preview-shared cr-hidden-style">#dialog::part(dialog){height:-webkit-fit-content;max-height:calc(100vh - 2 * var(--print-preview-dialog-margin));max-width:calc(100vw - 2 * var(--print-preview-dialog-margin))}#dialog::part(wrapper){height:calc(100vh - 2 * var(--print-preview-dialog-margin))}#dialog::part(body-container){flex:1}print-preview-search-box{margin-bottom:8px;margin-top:16px}cr-dialog [slot=body]{display:flex;flex-direction:column;height:100%}#itemList{flex:1;overflow-x:hidden;overflow-y:overlay}#itemList.searching{padding-bottom:20px;padding-top:20px}</style>
<cr-dialog id="dialog" on-close="onCloseOrCancel_">
  <div slot="title">
    [[i18n('advancedSettingsDialogTitle', destination.displayName)]]
  </div>
  <div slot="body">
    <print-preview-search-box id="searchBox"
        hidden$="[[!hasMultipleItems_(
            destination.capabilities.printer.vendor_capability)]]"
        label="$i18n{advancedSettingsSearchBoxPlaceholder}"
        search-query="{{searchQuery_}}" autofocus>
    </print-preview-search-box>
    <div id="itemList" class$="[[isSearching_(searchQuery_)]]">
      <template is="dom-repeat"
          items="[[destination.capabilities.printer.vendor_capability]]">
        <print-preview-advanced-settings-item capability="[[item]]"
            settings="[[settings]]">
        </print-preview-advanced-settings-item>
      </template>
    </div>
    <div class="no-settings-match-hint"
        hidden$="[[!shouldShowHint_(hasMatching_)]]">
      $i18n{noAdvancedSettingsMatchSearchHint}
    </div>
  </div>
  <div slot="button-container">
    <cr-button class="cancel-button" on-click="onCancelButtonClick_">
      $i18n{cancel}
    </cr-button>
    <cr-button class="action-button" on-click="onApplyButtonClick_">
      $i18n{advancedSettingsDialogConfirm}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PrintPreviewAdvancedSettingsDialogElementBase=I18nMixin(SettingsMixin(PolymerElement));class PrintPreviewAdvancedSettingsDialogElement extends PrintPreviewAdvancedSettingsDialogElementBase{constructor(){super(...arguments);this.highlights_=[];this.bubbles_=new Map;this.metrics_=MetricsContext.printSettingsUi()}static get is(){return"print-preview-advanced-settings-dialog"}static get template(){return getTemplate$z()}static get properties(){return{destination:Object,searchQuery_:{type:Object,value:null},hasMatching_:{type:Boolean,notify:true,computed:"computeHasMatching_(searchQuery_)"}}}ready(){super.ready();this.addEventListener("keydown",(e=>this.onKeydown_(e)))}connectedCallback(){super.connectedCallback();this.metrics_.record(PrintSettingsUiBucket.ADVANCED_SETTINGS_DIALOG_SHOWN);this.$.dialog.showModal()}onKeydown_(e){e.stopPropagation();const searchInput=this.$.searchBox.getSearchInput();const eventInSearchBox=e.composedPath().includes(searchInput);if(e.key==="Escape"&&(!eventInSearchBox||!searchInput.value.trim())){this.$.dialog.cancel();e.preventDefault();return}if(e.key==="Enter"&&!eventInSearchBox){const activeElementTag=e.composedPath()[0].tagName;if(["CR-BUTTON","SELECT"].includes(activeElementTag)){return}this.onApplyButtonClick_();e.preventDefault();return}}hasMultipleItems_(){return this.destination.capabilities.printer.vendor_capability.length>1}computeHasMatching_(){if(!this.shadowRoot){return true}removeHighlights(this.highlights_);this.bubbles_.forEach(((_number,bubble)=>bubble.remove()));this.highlights_=[];this.bubbles_.clear();const listItems=this.shadowRoot.querySelectorAll("print-preview-advanced-settings-item");let hasMatch=false;listItems.forEach((item=>{const matches=item.hasMatch(this.searchQuery_);item.hidden=!matches;hasMatch=hasMatch||matches;this.highlights_.push(...item.updateHighlighting(this.searchQuery_,this.bubbles_))}));return hasMatch}shouldShowHint_(){return!!this.searchQuery_&&!this.hasMatching_}onCloseOrCancel_(){if(this.searchQuery_){this.$.searchBox.setValue("")}if(this.$.dialog.getNative().returnValue==="success"){this.metrics_.record(PrintSettingsUiBucket.ADVANCED_SETTINGS_DIALOG_CANCELED)}}onCancelButtonClick_(){this.$.dialog.cancel()}onApplyButtonClick_(){const settingsValues={};const itemList=this.shadowRoot.querySelectorAll("print-preview-advanced-settings-item");itemList.forEach((item=>{settingsValues[item.capability.id]=item.getCurrentValue()}));this.setSetting("vendorItems",settingsValues);this.$.dialog.close()}close(){this.$.dialog.close()}isSearching_(){return this.searchQuery_?"searching":""}}customElements.define(PrintPreviewAdvancedSettingsDialogElement.is,PrintPreviewAdvancedSettingsDialogElement);
// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class Coordinate2d{constructor(x,y){this.x_=x;this.y_=y}get x(){return this.x_}get y(){return this.y_}equals(other){return other!==null&&this.x_===other.x_&&this.y_===other.y_}}
// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class PrintableArea{constructor(origin,size){this.origin_=origin;this.size_=size}get origin(){return this.origin_}get size(){return this.size_}equals(other){return other!==null&&this.origin_.equals(other.origin_)&&this.size_.equals(other.size_)}}
// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PrintPreviewDocumentInfoElementBase=WebUiListenerMixin(PolymerElement);class PrintPreviewDocumentInfoElement extends PrintPreviewDocumentInfoElementBase{constructor(){super(...arguments);this.isInitialized_=false}static get is(){return"print-preview-document-info"}static get properties(){return{documentSettings:{type:Object,notify:true,value(){return{allPagesHaveCustomSize:false,allPagesHaveCustomOrientation:false,hasSelection:false,isModifiable:true,isFromArc:false,isScalingDisabled:false,fitToPageScaling:100,pageCount:0,title:""}}},inFlightRequestId:{type:Number,value:-1},margins:{type:Object,notify:true},pageSize:{type:Object,notify:true,value(){return new Size(612,792)}},printableArea:{type:Object,notify:true,value(){return new PrintableArea(new Coordinate2d(0,0),new Size(612,792))}}}}connectedCallback(){super.connectedCallback();this.addWebUiListener("page-count-ready",((pageCount,previewResponseId,scaling)=>this.onPageCountReady_(pageCount,previewResponseId,scaling)));this.addWebUiListener("page-layout-ready",((pageLayout,allPagesHaveCustomSize,allPagesHaveCustomOrientation)=>this.onPageLayoutReady_(pageLayout,allPagesHaveCustomSize,allPagesHaveCustomOrientation)))}init(isModifiable,isFromArc,title,hasSelection){this.isInitialized_=true;this.set("documentSettings.isModifiable",isModifiable);this.set("documentSettings.isFromArc",isFromArc);this.set("documentSettings.title",title);this.set("documentSettings.hasSelection",hasSelection)}updateIsScalingDisabled(isScalingDisabled){if(this.isInitialized_){this.set("documentSettings.isScalingDisabled",isScalingDisabled)}}onPageLayoutReady_(pageLayout,allPagesHaveCustomSize,allPagesHaveCustomOrientation){const origin=new Coordinate2d(pageLayout.printableAreaX,pageLayout.printableAreaY);const size=new Size(pageLayout.printableAreaWidth,pageLayout.printableAreaHeight);const pageSize=new Size(Math.round(pageLayout.contentWidth+pageLayout.marginLeft+pageLayout.marginRight),Math.round(pageLayout.contentHeight+pageLayout.marginTop+pageLayout.marginBottom));const margins=new Margins(pageLayout.marginTop,pageLayout.marginRight,pageLayout.marginBottom,pageLayout.marginLeft);if(this.isInitialized_){this.printableArea=new PrintableArea(origin,size);this.pageSize=pageSize;this.set("documentSettings.allPagesHaveCustomSize",allPagesHaveCustomSize);this.set("documentSettings.allPagesHaveCustomOrientation",allPagesHaveCustomOrientation);this.margins=margins}}onPageCountReady_(pageCount,previewResponseId,fitToPageScaling){if(this.inFlightRequestId!==previewResponseId||!this.isInitialized_){return}this.set("documentSettings.pageCount",pageCount);this.set("documentSettings.fitToPageScaling",fitToPageScaling)}}customElements.define(PrintPreviewDocumentInfoElement.is,PrintPreviewDocumentInfoElement);let instance$4=null;function getCss$3(){return instance$4||(instance$4=[...[],css`:host{--collapse-duration:var(--iron-collapse-transition-duration,300ms);display:block;transition:max-height var(--collapse-duration) ease-out;overflow:visible}:host([no-animation]){transition:none}:host(.collapse-closed){display:none}:host(:not(.collapse-opened)){overflow:hidden}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$2(){return html`<slot></slot>`}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class CrCollapseElement extends CrLitElement{static get is(){return"cr-collapse"}static get styles(){return getCss$3()}render(){return getHtml$2.bind(this)()}static get properties(){return{opened:{type:Boolean,notify:true},noAnimation:{type:Boolean,reflect:true}}}#opened_accessor_storage=false;get opened(){return this.#opened_accessor_storage}set opened(value){this.#opened_accessor_storage=value}#noAnimation_accessor_storage=false;get noAnimation(){return this.#noAnimation_accessor_storage}set noAnimation(value){this.#noAnimation_accessor_storage=value}toggle(){this.opened=!this.opened}show(){this.opened=true}hide(){this.opened=false}firstUpdated(){if(!this.hasAttribute("role")){this.setAttribute("role","group")}this.setAttribute("aria-hidden","true");this.addEventListener("transitionend",(e=>this.onTransitionEnd_(e)))}updated(changedProperties){super.updated(changedProperties);if(!changedProperties.has("opened")){return}this.setAttribute("aria-hidden",this.opened?"false":"true");this.classList.toggle("collapse-closed",false);this.classList.toggle("collapse-opened",false);this.updateHeight_(this.opened,changedProperties.get("opened"));if(this.opened){this.focus()}}updateHeight_(opening,lastOpened){const finalMaxHeight=opening?"":"0px";const animationStartSize=`${this.getBoundingClientRect().height}px`;const animationEndSize=opening?`${this.scrollHeight}px`:"0px";const willAnimate=lastOpened!==undefined&&!this.noAnimation&&this.style.maxHeight!==finalMaxHeight&&animationStartSize!==animationEndSize;if(willAnimate&&!opening){this.style.maxHeight=animationStartSize;this.scrollTop=this.scrollTop}this.style.maxHeight=animationEndSize;if(!willAnimate){this.updateStyles_()}}onTransitionEnd_(e){if(e.composedPath()[0]===this){this.updateStyles_()}}updateStyles_(){this.style.maxHeight=this.opened?"":"0px";this.classList.toggle("collapse-closed",!this.opened);this.classList.toggle("collapse-opened",this.opened)}}customElements.define(CrCollapseElement.is,CrCollapseElement);function getTemplate$y(){return html$1`<!--_html_template_start_--><style include="print-preview-shared">:host{display:flex;padding-inline-start:var(--print-preview-sidebar-margin)}::slotted([slot=controls]),::slotted([slot=title]){display:flex;flex-direction:column;justify-content:center;min-height:var(--print-preview-row-height);word-break:break-word}::slotted([slot=controls]){flex:1;overflow:hidden}::slotted([slot=title]){color:var(--cr-primary-text-color);flex:none;font-size:1em;line-height:calc(20/13 * 1em);width:var(--print-preview-title-width)}</style>
<slot name="title"></slot>
<slot name="controls"></slot>
<!--_html_template_end_-->`}
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class PrintPreviewSettingsSectionElement extends PolymerElement{static get is(){return"print-preview-settings-section"}static get template(){return getTemplate$y()}}customElements.define(PrintPreviewSettingsSectionElement.is,PrintPreviewSettingsSectionElement);function getTemplate$x(){return html$1`<!--_html_template_start_--><style include="print-preview-shared">cr-button{height:fit-content;min-height:32px;text-align:center;width:calc(100% - 2 * var(--print-preview-sidebar-margin))}</style>
<print-preview-settings-section>
  <span slot="title"></span>
  <div slot="controls">
    <cr-button id="button" disabled$="[[disabled]]"
        on-click="onButtonClick_">
      $i18n{newShowAdvancedOptions}
    </cr-button>
  </div>
</print-preview-settings-section>
<template is="dom-if" if="[[showAdvancedDialog_]]" restamp>
  <print-preview-advanced-settings-dialog
      settings="[[settings]]" destination="[[destination]]"
      on-close="onDialogClose_">
  </print-preview-advanced-settings-dialog>
</template>
<!--_html_template_end_-->`}
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class PrintPreviewAdvancedOptionsSettingsElement extends PolymerElement{static get is(){return"print-preview-advanced-options-settings"}static get template(){return getTemplate$x()}static get properties(){return{disabled:Boolean,destination:Object,settings:Object,showAdvancedDialog_:{type:Boolean,value:false}}}onButtonClick_(){this.showAdvancedDialog_=true}onDialogClose_(){this.showAdvancedDialog_=false;this.$.button.focus()}}customElements.define(PrintPreviewAdvancedOptionsSettingsElement.is,PrintPreviewAdvancedOptionsSettingsElement);
// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function emptyHTML(){return window.trustedTypes?window.trustedTypes.emptyHTML:""}class CustomElement extends HTMLElement{static get template(){return emptyHTML()}constructor(){super();this.attachShadow({mode:"open"});const template=document.createElement("template");template.innerHTML=this.constructor.template||emptyHTML();this.shadowRoot.appendChild(template.content.cloneNode(true))}$(query){return this.shadowRoot.querySelector(query)}$all(query){return this.shadowRoot.querySelectorAll(query)}getRequiredElement(query){const el=this.shadowRoot.querySelector(query);assert(el);assert(el instanceof HTMLElement);return el}}function getTemplate$w(){return getTrustedHTML`<!--_html_template_start_--><style>:host{clip:rect(0 0 0 0);height:1px;overflow:hidden;position:fixed;width:1px}</style>

<div id="messages" role="alert" aria-live="polite" aria-relevant="additions">
</div>
<!--_html_template_end_-->`}
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const TIMEOUT_MS=150;const instances=new Map;function getInstance(container=document.body){if(instances.has(container)){return instances.get(container)}assert(container.isConnected);const instance=new CrA11yAnnouncerElement;container.appendChild(instance);instances.set(container,instance);return instance}class CrA11yAnnouncerElement extends CustomElement{static get is(){return"cr-a11y-announcer"}static get template(){return getTemplate$w()}currentTimeout_=null;messages_=[];disconnectedCallback(){if(this.currentTimeout_!==null){clearTimeout(this.currentTimeout_);this.currentTimeout_=null}for(const[parent,instance]of instances){if(instance===this){instances.delete(parent);break}}}announce(message,timeout=TIMEOUT_MS){if(this.currentTimeout_!==null){clearTimeout(this.currentTimeout_);this.currentTimeout_=null}this.messages_.push(message);this.currentTimeout_=setTimeout((()=>{const messagesDiv=this.shadowRoot.querySelector("#messages");messagesDiv.innerHTML=window.trustedTypes.emptyHTML;for(const message of this.messages_){const div=document.createElement("div");div.textContent=message;messagesDiv.appendChild(div)}this.dispatchEvent(new CustomEvent("cr-a11y-announcer-messages-sent",{bubbles:true,detail:{messages:this.messages_.slice()}}));this.messages_.length=0;this.currentTimeout_=null}),timeout)}}customElements.define(CrA11yAnnouncerElement.is,CrA11yAnnouncerElement);function getTemplate$v(){return html$1`<!--_html_template_start_--><style include="cr-hidden-style">:host .controls{align-items:center;display:flex;flex-direction:row;justify-content:flex-end;padding-bottom:var(--print-preview-sidebar-margin);padding-inline-end:var(--print-preview-sidebar-margin);padding-top:16px}@media (prefers-color-scheme:light){:host{background-color:white}}:host cr-button:not(:last-child){margin-inline-end:8px}:host cr-button:last-child{margin-inline-end:0}.error-message{color:red;margin:16px 16px 0;text-align:start}
</style>

<div class="error-message"
    hidden="[[!showSheetsError_(destination.id, maxSheets, sheetCount)]]">
  [[errorMessage_]]
</div>

<div class="controls">

  <cr-button class="cancel-button" on-click="onCancelClick_">
    $i18n{cancel}
  </cr-button>

  <cr-button class="action-button" on-click="onPrintClick_"
      disabled$="[[!printButtonEnabled_]]">
    [[printButtonLabel_]]
  </cr-button>

</div>
<!--_html_template_end_-->`}
// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class PrintPreviewButtonStripElement extends PolymerElement{constructor(){super(...arguments);this.lastState_=State.NOT_READY}static get is(){return"print-preview-button-strip"}static get template(){return getTemplate$v()}static get properties(){return{destination:Object,firstLoad:Boolean,maxSheets:Number,sheetCount:Number,state:Number,printButtonEnabled_:{type:Boolean,value:false},printButtonLabel_:{type:String,value(){return loadTimeData.getString("printButton")}},errorMessage_:{type:String,observer:"errorMessageChanged_"},isPinValid:Boolean}}static get observers(){return["updatePrintButtonLabel_(destination.id)","updatePrintButtonEnabled_(state, destination.id, maxSheets, sheetCount)","updatePrintButtonEnabled_(isPinValid)","updateErrorMessage_(state, destination.id, maxSheets, sheetCount)"]}fire_(eventName,detail){this.dispatchEvent(new CustomEvent(eventName,{bubbles:true,composed:true,detail:detail}))}onPrintClick_(){this.fire_("print-requested")}onCancelClick_(){this.fire_("cancel-requested")}isPdf_(){return this.destination&&this.destination.type===PrinterType.PDF_PRINTER}updatePrintButtonLabel_(){this.printButtonLabel_=loadTimeData.getString(this.isPdf_()?"saveButton":"printButton")}updatePrintButtonEnabled_(){switch(this.state){case State.PRINTING:this.printButtonEnabled_=false;break;case State.READY:this.printButtonEnabled_=!this.printButtonDisabled_();if(this.firstLoad||this.lastState_===State.PRINTING){this.shadowRoot.querySelector("cr-button.action-button").focus();this.fire_("print-button-focused")}break;default:this.printButtonEnabled_=false;break}this.lastState_=this.state}printButtonDisabled_(){return this.isSheetsLimitPolicyViolated_()||!this.isPinValid}isSheetsLimitPolicyViolated_(){return!this.isPdf_()&&this.maxSheets>0&&(this.sheetCount===0||this.sheetCount>this.maxSheets)}showSheetsError_(){return this.sheetCount>0&&this.isSheetsLimitPolicyViolated_()}updateErrorMessage_(){if(!this.showSheetsError_()){this.errorMessage_="";return}PluralStringProxyImpl.getInstance().getPluralString("sheetsLimitErrorMessage",this.maxSheets).then((label=>{this.errorMessage_=label}))}errorMessageChanged_(){if(this.errorMessage_!==""){getInstance().announce(this.errorMessage_)}}}customElements.define(PrintPreviewButtonStripElement.is,PrintPreviewButtonStripElement);function getTemplate$u(){return html$1`<!--_html_template_start_--><style include="print-preview-shared md-select"></style>
<print-preview-settings-section>
  <span id="color-label" slot="title">$i18n{optionColor}</span>
  <div slot="controls">
    <select class="md-select" aria-labelledby="color-label"
        disabled$="[[disabled_]]" value="[[selectedValue]]"
        on-change="onSelectChange">
      <option value="bw" selected>$i18n{optionBw}</option>
      <option value="color">$i18n{optionColor}</option>
    </select>
  </div>
</print-preview-settings-section>
<!--_html_template_end_-->`}const SelectMixin=dedupingMixin((superClass=>{class SelectMixin extends superClass{constructor(){super(...arguments);this.debouncer_=null}static get properties(){return{selectedValue:{type:String}}}onSelectChange(e){const newValue=e.target.value;this.debouncer_=Debouncer.debounce(this.debouncer_,timeOut.after(100),(()=>this.callProcessSelectChange_(newValue)))}callProcessSelectChange_(newValue){if(!this.isConnected||newValue===this.selectedValue){return}this.selectedValue=newValue;this.onProcessSelectChange(newValue);this.dispatchEvent(new CustomEvent("process-select-change",{bubbles:true,composed:true}))}onProcessSelectChange(_value){}}return SelectMixin}));
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PrintPreviewColorSettingsElementBase=SettingsMixin(SelectMixin(PolymerElement));class PrintPreviewColorSettingsElement extends PrintPreviewColorSettingsElementBase{static get is(){return"print-preview-color-settings"}static get template(){return getTemplate$u()}static get properties(){return{disabled:Boolean,disabled_:{type:Boolean,computed:"computeDisabled_(disabled, "+"settings.color.setByGlobalPolicy, "+"settings.color.setByDestinationPolicy)"}}}static get observers(){return["onColorSettingChange_(settings.color.*)"]}onColorSettingChange_(){this.selectedValue=this.getSettingValue("color")?"color":"bw"}computeDisabled_(disabled,managedByGlobalPolicy,managedByDestinationPolicy){return disabled||managedByGlobalPolicy||managedByDestinationPolicy}onProcessSelectChange(value){this.setSetting("color",value==="color")}}customElements.define(PrintPreviewColorSettingsElement.is,PrintPreviewColorSettingsElement);
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const InputMixin=dedupingMixin((superClass=>{class InputMixin extends superClass{constructor(){super(...arguments);this.timeout_=null}static get properties(){return{lastValue_:{type:String,value:""}}}connectedCallback(){super.connectedCallback();this.getInput().addEventListener("input",(()=>this.resetTimeout_()));this.getInput().addEventListener("keydown",(e=>this.onKeyDown_(e)))}getInput(){assertNotReached()}getTimeoutDelayMs_(){const delay=parseInt(this.getInput().dataset["timeoutDelay"],10);assert(!Number.isNaN(delay));return delay}onKeyDown_(event){if(event.key!=="Enter"&&event.key!=="Tab"){return}this.resetAndUpdate()}resetTimeout_(){if(this.timeout_){clearTimeout(this.timeout_)}this.timeout_=setTimeout((()=>this.onTimeout_()),this.getTimeoutDelayMs_())}onTimeout_(){this.timeout_=null;const value=this.getInput().value||"";if(this.lastValue_!==value){this.lastValue_=value;this.dispatchEvent(new CustomEvent("input-change",{bubbles:true,composed:true,detail:value}))}}resetString(){this.lastValue_=null}resetAndUpdate(){if(this.timeout_){clearTimeout(this.timeout_)}this.onTimeout_()}}return InputMixin}));function getTemplate$t(){return html$1`<!--_html_template_start_--><style include="print-preview-shared">:host{--cr-input-width:calc(4em + 16px)}#sectionTitle{align-self:baseline}cr-input{margin-inline-end:16px;min-height:var(--print-preview-row-height);overflow:hidden}.input-wrapper{align-items:center;display:flex}:host([input-valid]) cr-input{--cr-input-error-display:none}span[slot=suffix]{max-width:calc(100% - 5em);min-height:var(--print-preview-row-height);overflow:hidden;word-wrap:break-word}</style>
<print-preview-settings-section>
  <span slot="title" id="sectionTitle">[[inputLabel]]</span>
  <div slot="controls" id="controls">
    <span class="input-wrapper">
      <cr-input id="userValue" type="number" class="stroked"
          max="[[maxValue]]" min="[[minValue]]" data-timeout-delay="250"
          disabled$="[[getDisabled_(disabled)]]" on-keydown="onKeydown_"
          on-blur="onBlur_" aria-label="[[inputAriaLabel]]"
          error-message="[[errorMessage_]]" auto-validate>
        <span slot="suffix">
          <slot name="opt-inside-content"></slot>
        </span>
      </cr-input>
    </span>
  </div>
</print-preview-settings-section>
<!--_html_template_end_-->`}
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PrintPreviewNumberSettingsSectionElementBase=WebUiListenerMixin(InputMixin(PolymerElement));class PrintPreviewNumberSettingsSectionElement extends PrintPreviewNumberSettingsSectionElementBase{static get is(){return"print-preview-number-settings-section"}static get template(){return getTemplate$t()}static get properties(){return{inputValid:{type:Boolean,notify:true,reflectToAttribute:true,value:true},currentValue:{type:String,notify:true,observer:"onCurrentValueChanged_"},defaultValue:String,maxValue:Number,minValue:Number,inputLabel:String,inputAriaLabel:String,hintMessage:String,disabled:Boolean,errorMessage_:{type:String,computed:"computeErrorMessage_(hintMessage, inputValid)"}}}ready(){super.ready();this.addEventListener("input-change",(e=>this.onInputChangeEvent_(e)))}getInput(){return this.$.userValue}onInputChangeEvent_(e){if(e.detail===""){this.currentValue=""}this.inputValid=this.$.userValue.validate();this.currentValue=e.detail}getDisabled_(){return this.disabled&&this.inputValid}onKeydown_(e){if([".","e","E","-","+"].includes(e.key)){e.preventDefault();return}if(e.key==="Enter"){this.onBlur_()}}onBlur_(){if(this.currentValue===""){this.currentValue=this.defaultValue;this.inputValid=this.$.userValue.validate()}if(this.$.userValue.value===""){this.$.userValue.value=this.defaultValue}}onCurrentValueChanged_(){if(this.currentValue!==this.$.userValue.value){this.$.userValue.value=this.currentValue;this.inputValid=this.$.userValue.validate()}this.resetString()}computeErrorMessage_(){return this.inputValid?"":this.hintMessage}}customElements.define(PrintPreviewNumberSettingsSectionElement.is,PrintPreviewNumberSettingsSectionElement);function getTemplate$s(){return html$1`<!--_html_template_start_--><style include="print-preview-shared">#collate{margin-inline-start:16px}</style>
<print-preview-number-settings-section max-value="[[copiesMax_]]" min-value="1"
    default-value="1" input-label="$i18n{copiesLabel}"
    input-aria-label="$i18n{copiesLabel}"
    disabled="[[disabled]]" current-value="{{currentValue_}}"
    input-valid="{{inputValid_}}"
    hint-message="[[getHintMessage_(copiesMax_)]]">
  <div slot="opt-inside-content" class="checkbox" aria-live="polite"
      hidden$="[[collateHidden_(
        currentValue_, settings.collate.available, inputValid_)]]">
    <cr-checkbox id="collate" on-change="onCollateChange_"
        disabled="[[disabled]]" aria-labelledby="copies-collate-label">
      <span id="copies-collate-label">$i18n{optionCollate}</span>
    </cr-checkbox>
  </div>
</print-preview-number-settings-section>
<!--_html_template_end_-->`}
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const DEFAULT_MAX_COPIES=999;const PrintPreviewCopiesSettingsElementBase=SettingsMixin(PolymerElement);class PrintPreviewCopiesSettingsElement extends PrintPreviewCopiesSettingsElementBase{static get is(){return"print-preview-copies-settings"}static get template(){return getTemplate$s()}static get properties(){return{capability:Object,copiesMax_:{type:Number,computed:"computeCopiesMax_(capability)"},currentValue_:{type:String,observer:"onInputChanged_"},inputValid_:Boolean,disabled:Boolean}}static get observers(){return["onSettingsChanged_(settings.copies.value, settings.collate.*)"]}computeCopiesMax_(){return this.capability&&this.capability.max?this.capability.max:DEFAULT_MAX_COPIES}getHintMessage_(){return loadTimeData.getStringF("copiesInstruction",this.copiesMax_)}onSettingsChanged_(){const copies=this.getSetting("copies");if(this.inputValid_){this.currentValue_=copies.value.toString()}const collate=this.getSetting("collate");this.$.collate.checked=collate.value}onInputChanged_(){if(this.currentValue_!==""&&this.currentValue_!==this.getSettingValue("copies").toString()){this.setSetting("copies",this.inputValid_?parseInt(this.currentValue_,10):1)}this.setSettingValid("copies",this.inputValid_)}collateHidden_(){return!this.getSetting("collate").available||!this.inputValid_||this.currentValue_===""||parseInt(this.currentValue_,10)===1}onCollateChange_(){this.setSetting("collate",this.$.collate.checked)}}customElements.define(PrintPreviewCopiesSettingsElement.is,PrintPreviewCopiesSettingsElement);function getTemplate$r(){return html$1`<!--_html_template_start_--><style include="print-preview-shared md-select">select.md-select{margin:2px;--md-select-width:calc(100% - 4px)}</style>
<select class="md-select" disabled$="[[disabled]]"
    aria-label$="[[ariaLabel]]" value="[[selectedValue]]"
    on-change="onSelectChange">
  <template is="dom-repeat" items="[[capability.option]]">
    <option selected="[[isSelected_(item, selectedValue)]]"
        value="[[getValue_(item)]]">
      [[getDisplayName_(item)]]
    </option>
  </template>
</select>
<!--_html_template_end_-->`}
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PrintPreviewSettingsSelectElementBase=SettingsMixin(SelectMixin(PolymerElement));class PrintPreviewSettingsSelectElement extends PrintPreviewSettingsSelectElementBase{static get is(){return"print-preview-settings-select"}static get template(){return getTemplate$r()}static get properties(){return{ariaLabel:String,capability:Object,settingName:String,disabled:Boolean}}isSelected_(option){return this.getValue_(option)===this.selectedValue||!!option.is_default&&this.selectedValue===""}selectValue(value){this.selectedValue=value}getValue_(option){return JSON.stringify(option)}getDisplayName_(option){let displayName=option.custom_display_name;if(!displayName&&option.custom_display_name_localized){displayName=getStringForCurrentLocale(option.custom_display_name_localized)}return displayName||option.name||""}onProcessSelectChange(value){let newValue=null;try{newValue=JSON.parse(value)}catch(e){assertNotReached()}if(value!==JSON.stringify(this.getSettingValue(this.settingName))){this.setSetting(this.settingName,newValue)}}}customElements.define(PrintPreviewSettingsSelectElement.is,PrintPreviewSettingsSelectElement);function getTemplate$q(){return html$1`<!--_html_template_start_--><style include="print-preview-shared">:host print-preview-settings-select{margin:0 calc(var(--print-preview-sidebar-margin) - 2px)}</style>
<print-preview-settings-section>
  <span id="dpi-label" slot="title">$i18n{dpiLabel}</span>
  <div slot="controls">
    <print-preview-settings-select aria-label="$i18n{dpiLabel}"
        capability="[[capabilityWithLabels_]]" setting-name="dpi"
        disabled="[[isSelectionBoxDisabled_(
          disabled, settings.dpi.setByDestinationPolicy)]]"
        settings="{{settings}}">
    </print-preview-settings-select>
  </div>
</print-preview-settings-section>
<!--_html_template_end_-->`}
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PrintPreviewDpiSettingsElementBase=SettingsMixin(PolymerElement);class PrintPreviewDpiSettingsElement extends PrintPreviewDpiSettingsElementBase{static get is(){return"print-preview-dpi-settings"}static get template(){return getTemplate$q()}static get properties(){return{capability:Object,capabilityWithLabels_:{type:Object,computed:"computeCapabilityWithLabels_(capability)"},disabled:Boolean}}static get observers(){return["onDpiSettingChange_(settings.dpi.*, capabilityWithLabels_.option)"]}computeCapabilityWithLabels_(){if(this.capability===undefined){return null}const result=structuredClone(this.capability);this.capability.option.forEach(((dpiOption,index)=>{const hDpi=dpiOption.horizontal_dpi||0;const vDpi=dpiOption.vertical_dpi||0;if(hDpi>0&&vDpi>0&&hDpi!==vDpi){result.option[index].name=loadTimeData.getStringF("nonIsotropicDpiItemLabel",hDpi.toLocaleString(),vDpi.toLocaleString())}else{result.option[index].name=loadTimeData.getStringF("dpiItemLabel",(hDpi||vDpi).toLocaleString())}}));return result}onDpiSettingChange_(){if(this.capabilityWithLabels_===null||this.capabilityWithLabels_===undefined){return}const dpiValue=this.getSettingValue("dpi");for(const option of this.capabilityWithLabels_.option){const dpiOption=option;if(dpiValue.horizontal_dpi===dpiOption.horizontal_dpi&&dpiValue.vertical_dpi===dpiOption.vertical_dpi&&dpiValue.vendor_id===dpiOption.vendor_id){this.shadowRoot.querySelector("print-preview-settings-select").selectValue(JSON.stringify(option));this.lastSelectedValue_=dpiValue;return}}if(dpiValue!==this.lastSelectedValue_){const defaultOption=this.capabilityWithLabels_.option.find((o=>!!o.is_default))||this.capabilityWithLabels_.option[0];this.setSetting("dpi",defaultOption,true)}}isSelectionBoxDisabled_(){return this.disabled||this.getSetting("dpi").setByDestinationPolicy}}customElements.define(PrintPreviewDpiSettingsElement.is,PrintPreviewDpiSettingsElement);let instance$3=null;function getCss$2(){return instance$3||(instance$3=[...[],css`:host{display:none}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$1(){return html`
<svg id="baseSvg" xmlns="http://www.w3.org/2000/svg"
     viewBox="0 0 ${this.size} ${this.size}"
     preserveAspectRatio="xMidYMid meet" focusable="false"
     style="pointer-events: none; display: block; width: 100%; height: 100%;">
 </svg>
<slot></slot>
`}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const APPLIED_ICON_CLASS="cr-iconset-svg-icon_";class CrIconsetElement extends CrLitElement{static get is(){return"cr-iconset"}static get styles(){return getCss$2()}render(){return getHtml$1.bind(this)()}static get properties(){return{name:{type:String},size:{type:Number}}}#name_accessor_storage="";get name(){return this.#name_accessor_storage}set name(value){this.#name_accessor_storage=value}#size_accessor_storage=24;get size(){return this.#size_accessor_storage}set size(value){this.#size_accessor_storage=value}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("name")){assert(changedProperties.get("name")===undefined);IconsetMap.getInstance().set(this.name,this)}}applyIcon(element,iconName){this.removeIcon(element);const svg=this.cloneIcon_(iconName);if(svg){svg.classList.add(APPLIED_ICON_CLASS);element.shadowRoot.insertBefore(svg,element.shadowRoot.childNodes[0]);return svg}return null}createIcon(iconName){return this.cloneIcon_(iconName)}removeIcon(element){const oldSvg=element.shadowRoot.querySelector(`.${APPLIED_ICON_CLASS}`);if(oldSvg){oldSvg.remove()}}cloneIcon_(id){const sourceSvg=this.querySelector(`g[id="${id}"]`);if(!sourceSvg){return null}const svgClone=this.$.baseSvg.cloneNode(true);const content=sourceSvg.cloneNode(true);content.removeAttribute("id");const contentViewBox=content.getAttribute("viewBox");if(contentViewBox){svgClone.setAttribute("viewBox",contentViewBox)}svgClone.appendChild(content);return svgClone}}customElements.define(CrIconsetElement.is,CrIconsetElement);const div$1=document.createElement("div");div$1.innerHTML=getTrustedHTML`<cr-iconset name="print-preview" size="24">
  <svg>
    <defs>
      <!-- Custom SVGs (namratakannan) -->
      <g id="short-edge" viewBox="0 0 26 20" fill-rule="evenodd">
        <path d="M2 14v2h2v-2H2zm12 4v2h2v-2h-2zm4 0v2h2v-2h-2zm3.556-18H4.444C3.1 0 2 1.35 2 3v6h2V2h18v7h2V3c0-1.65-1.1-3-2.444-3zM24 18h-2v2c1.1 0 2-.9 2-2zM0 10v2h26v-2H0zm6 8v2h2v-2H6zm16-4v2h2v-2h-2zm-12 4v2h2v-2h-2zm-8 0c0 1.1.9 2 2 2v-2H2z">
        <path d="M29-6v32H-3V-6z">
      </g>
      <g id="long-edge" viewBox="0 0 23 22" fill-rule="evenodd">
        <path d="M17 20h2v-2h-2v2zm4-12h2V6h-2v2zM0 4v14c0 1.1 1.35 2 3 2h6v-2H2V4h7V2H3c-1.65 0-3 .9-3 2zm21-2v2h2c0-1.1-.9-2-2-2zM10 22h2V0h-2v22zm11-6h2v-2h-2v2zM17 4h2V2h-2v2zm-4 16h2v-2h-2v2zm0-16h2V2h-2v2zm8 8h2v-2h-2v2zm0 8c1.1 0 2-.9 2-2h-2v2z">
        <path d="M-5-5h32v32H-5z">
      </g>

    
      <!-- Icon from http://icons/ -->
      <g id="save-to-drive">
        <path fill="none" d="M0 0h24v24H0z"></path>
        <path d="M20 6h-8l-2-2H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2zm-8.5 11l-1.1-2.14 2.84-4.96 1.5 2.66L12.25 17h-.75zm6.8 0h-5.55l1.4-2.5h5.11l.26.46L18.3 17zm-4.55-8h2.39l2.84 5h-2.93l-2.56-4.54.26-.46z"></path>
      </g>

      <!-- Color scheme "light" Variants. -->
      <g id="printer-status-green">
        <path d="M19,8 C20.66,8 22,9.34 22,11 L22,11 L22.0008411,12.1834702 C20.9260374,10.5660653 19.0875152,9.5 17,9.5 C14.2041481,9.5 11.8549346,11.412286 11.1889599,14.0002575 L8,14 L8,19 L12.1267078,19.0009178 C12.7530956,19.8713157 13.6069102,20.5670952 14.6011413,21.0012461 L6,21 L6,17 L2,17 L2,11 C2,9.34 3.34,8 5,8 L5,8 Z M18,3 L18,7 L6,7 L6,3 L18,3 Z"></path>
        <circle fill="#1e8e3e" cx="17" cy="15.5" r="3.5"></circle>
      </g>
      <g id="printer-status-grey">
        <path d="M19,8 C20.66,8 22,9.34 22,11 L22,11 L22.0008411,12.1834702 C20.9260374,10.5660653 19.0875152,9.5 17,9.5 C14.2041481,9.5 11.8549346,11.412286 11.1889599,14.0002575 L8,14 L8,19 L12.1267078,19.0009178 C12.7530956,19.8713157 13.6069102,20.5670952 14.6011413,21.0012461 L6,21 L6,17 L2,17 L2,11 C2,9.34 3.34,8 5,8 L5,8 Z M18,3 L18,7 L6,7 L6,3 L18,3 Z"></path>
        <circle fill="#dadce0" cx="17" cy="15.5" r="3.5"></circle>
      </g>
      <g id="printer-status-orange">
        <path d="M19,8 C20.66,8 22,9.34 22,11 L22,11 L22.0008411,12.1834702 C20.9260374,10.5660653 19.0875152,9.5 17,9.5 C14.2041481,9.5 11.8549346,11.412286 11.1889599,14.0002575 L8,14 L8,19 L12.1267078,19.0009178 C12.7530956,19.8713157 13.6069102,20.5670952 14.6011413,21.0012461 L6,21 L6,17 L2,17 L2,11 C2,9.34 3.34,8 5,8 L5,8 Z M18,3 L18,7 L6,7 L6,3 L18,3 Z"></path>
        <circle fill="#e37400" cx="17" cy="15.5" r="3.5"></circle>
      </g>
      <g id="printer-status-red">
        <path d="M19,8 C20.66,8 22,9.34 22,11 L22,11 L22.0008411,12.1834702 C20.9260374,10.5660653 19.0875152,9.5 17,9.5 C14.2041481,9.5 11.8549346,11.412286 11.1889599,14.0002575 L8,14 L8,19 L12.1267078,19.0009178 C12.7530956,19.8713157 13.6069102,20.5670952 14.6011413,21.0012461 L6,21 L6,17 L2,17 L2,11 C2,9.34 3.34,8 5,8 L5,8 Z M18,3 L18,7 L6,7 L6,3 L18,3 Z"></path>
        <circle fill="#d93025" cx="17" cy="15.5" r="3.5"></circle>
      </g>
      <g id="business-printer-status-green">
        <path d="M12,3 L12,7 L22,7 L22.0008411,12.1834702 C21.4889261,11.4131214 20.8037622,10.7678435 20.000963,10.3032504 L20,9 L12,9 L12,11 L13.0312427,11.0000183 C11.7856236,12.0994345 11,13.7079712 11,15.5 C11,16.7266262 11.3680857,17.8672813 11.9998276,18.8175358 L12,19 L12.1267078,19.0009178 C12.7530956,19.8713157 13.6069102,20.5670952 14.6011413,21.0012461 L2,21 L2,3 L12,3 Z M6,17 L4,17 L4,19 L6,19 L6,17 Z M10,17 L8,17 L8,19 L10,19 L10,17 Z M6,13 L4,13 L4,15 L6,15 L6,13 Z M10,13 L8,13 L8,15 L10,15 L10,13 Z M6,9 L4,9 L4,11 L6,11 L6,9 Z M10,9 L8,9 L8,11 L10,11 L10,9 Z M6,5 L4,5 L4,7 L6,7 L6,5 Z M10,5 L8,5 L8,7 L10,7 L10,5 Z"></path>
        <circle fill="#1e8e3e" cx="17" cy="15.5" r="3.5"></circle>
      </g>
      <g id="business-printer-status-grey">
        <path d="M12,3 L12,7 L22,7 L22.0008411,12.1834702 C21.4889261,11.4131214 20.8037622,10.7678435 20.000963,10.3032504 L20,9 L12,9 L12,11 L13.0312427,11.0000183 C11.7856236,12.0994345 11,13.7079712 11,15.5 C11,16.7266262 11.3680857,17.8672813 11.9998276,18.8175358 L12,19 L12.1267078,19.0009178 C12.7530956,19.8713157 13.6069102,20.5670952 14.6011413,21.0012461 L2,21 L2,3 L12,3 Z M6,17 L4,17 L4,19 L6,19 L6,17 Z M10,17 L8,17 L8,19 L10,19 L10,17 Z M6,13 L4,13 L4,15 L6,15 L6,13 Z M10,13 L8,13 L8,15 L10,15 L10,13 Z M6,9 L4,9 L4,11 L6,11 L6,9 Z M10,9 L8,9 L8,11 L10,11 L10,9 Z M6,5 L4,5 L4,7 L6,7 L6,5 Z M10,5 L8,5 L8,7 L10,7 L10,5 Z"></path>
        <circle fill="#dadce0" cx="17" cy="15.5" r="3.5"></circle>
      </g>
      <g id="business-printer-status-orange">
        <path d="M12,3 L12,7 L22,7 L22.0008411,12.1834702 C21.4889261,11.4131214 20.8037622,10.7678435 20.000963,10.3032504 L20,9 L12,9 L12,11 L13.0312427,11.0000183 C11.7856236,12.0994345 11,13.7079712 11,15.5 C11,16.7266262 11.3680857,17.8672813 11.9998276,18.8175358 L12,19 L12.1267078,19.0009178 C12.7530956,19.8713157 13.6069102,20.5670952 14.6011413,21.0012461 L2,21 L2,3 L12,3 Z M6,17 L4,17 L4,19 L6,19 L6,17 Z M10,17 L8,17 L8,19 L10,19 L10,17 Z M6,13 L4,13 L4,15 L6,15 L6,13 Z M10,13 L8,13 L8,15 L10,15 L10,13 Z M6,9 L4,9 L4,11 L6,11 L6,9 Z M10,9 L8,9 L8,11 L10,11 L10,9 Z M6,5 L4,5 L4,7 L6,7 L6,5 Z M10,5 L8,5 L8,7 L10,7 L10,5 Z"></path>
        <circle fill="#e37400" cx="17" cy="15.5" r="3.5"></circle>
      </g>
      <g id="business-printer-status-red">
        <path d="M12,3 L12,7 L22,7 L22.0008411,12.1834702 C21.4889261,11.4131214 20.8037622,10.7678435 20.000963,10.3032504 L20,9 L12,9 L12,11 L13.0312427,11.0000183 C11.7856236,12.0994345 11,13.7079712 11,15.5 C11,16.7266262 11.3680857,17.8672813 11.9998276,18.8175358 L12,19 L12.1267078,19.0009178 C12.7530956,19.8713157 13.6069102,20.5670952 14.6011413,21.0012461 L2,21 L2,3 L12,3 Z M6,17 L4,17 L4,19 L6,19 L6,17 Z M10,17 L8,17 L8,19 L10,19 L10,17 Z M6,13 L4,13 L4,15 L6,15 L6,13 Z M10,13 L8,13 L8,15 L10,15 L10,13 Z M6,9 L4,9 L4,11 L6,11 L6,9 Z M10,9 L8,9 L8,11 L10,11 L10,9 Z M6,5 L4,5 L4,7 L6,7 L6,5 Z M10,5 L8,5 L8,7 L10,7 L10,5 Z"></path>
        <circle fill="#d93025" cx="17" cy="15.5" r="3.5"></circle>
      </g>

      <!-- Color scheme "dark" Variants. -->
      <g id="printer-status-green-dark">
        <path d="M19,8 C20.66,8 22,9.34 22,11 L22,11 L22.0008411,12.1834702 C20.9260374,10.5660653 19.0875152,9.5 17,9.5 C14.2041481,9.5 11.8549346,11.412286 11.1889599,14.0002575 L8,14 L8,19 L12.1267078,19.0009178 C12.7530956,19.8713157 13.6069102,20.5670952 14.6011413,21.0012461 L6,21 L6,17 L2,17 L2,11 C2,9.34 3.34,8 5,8 L5,8 Z M18,3 L18,7 L6,7 L6,3 L18,3 Z"></path>
        <circle fill="#81c995" cx="17" cy="15.5" r="3.5"></circle>
      </g>
      <g id="printer-status-grey-dark">
        <path d="M19,8 C20.66,8 22,9.34 22,11 L22,11 L22.0008411,12.1834702 C20.9260374,10.5660653 19.0875152,9.5 17,9.5 C14.2041481,9.5 11.8549346,11.412286 11.1889599,14.0002575 L8,14 L8,19 L12.1267078,19.0009178 C12.7530956,19.8713157 13.6069102,20.5670952 14.6011413,21.0012461 L6,21 L6,17 L2,17 L2,11 C2,9.34 3.34,8 5,8 L5,8 Z M18,3 L18,7 L6,7 L6,3 L18,3 Z"></path>
        <circle fill="#80868b" cx="17" cy="15.5" r="3.5"></circle>
      </g>
      <g id="printer-status-orange-dark">
        <path d="M19,8 C20.66,8 22,9.34 22,11 L22,11 L22.0008411,12.1834702 C20.9260374,10.5660653 19.0875152,9.5 17,9.5 C14.2041481,9.5 11.8549346,11.412286 11.1889599,14.0002575 L8,14 L8,19 L12.1267078,19.0009178 C12.7530956,19.8713157 13.6069102,20.5670952 14.6011413,21.0012461 L6,21 L6,17 L2,17 L2,11 C2,9.34 3.34,8 5,8 L5,8 Z M18,3 L18,7 L6,7 L6,3 L18,3 Z"></path>
        <circle fill="#fdd663" cx="17" cy="15.5" r="3.5"></circle>
      </g>
      <g id="printer-status-red-dark">
        <path d="M19,8 C20.66,8 22,9.34 22,11 L22,11 L22.0008411,12.1834702 C20.9260374,10.5660653 19.0875152,9.5 17,9.5 C14.2041481,9.5 11.8549346,11.412286 11.1889599,14.0002575 L8,14 L8,19 L12.1267078,19.0009178 C12.7530956,19.8713157 13.6069102,20.5670952 14.6011413,21.0012461 L6,21 L6,17 L2,17 L2,11 C2,9.34 3.34,8 5,8 L5,8 Z M18,3 L18,7 L6,7 L6,3 L18,3 Z"></path>
        <circle fill="#f28b82" cx="17" cy="15.5" r="3.5"></circle>
      </g>
      <g id="business-printer-status-green-dark">
        <path d="M12,3 L12,7 L22,7 L22.0008411,12.1834702 C21.4889261,11.4131214 20.8037622,10.7678435 20.000963,10.3032504 L20,9 L12,9 L12,11 L13.0312427,11.0000183 C11.7856236,12.0994345 11,13.7079712 11,15.5 C11,16.7266262 11.3680857,17.8672813 11.9998276,18.8175358 L12,19 L12.1267078,19.0009178 C12.7530956,19.8713157 13.6069102,20.5670952 14.6011413,21.0012461 L2,21 L2,3 L12,3 Z M6,17 L4,17 L4,19 L6,19 L6,17 Z M10,17 L8,17 L8,19 L10,19 L10,17 Z M6,13 L4,13 L4,15 L6,15 L6,13 Z M10,13 L8,13 L8,15 L10,15 L10,13 Z M6,9 L4,9 L4,11 L6,11 L6,9 Z M10,9 L8,9 L8,11 L10,11 L10,9 Z M6,5 L4,5 L4,7 L6,7 L6,5 Z M10,5 L8,5 L8,7 L10,7 L10,5 Z"></path>
        <circle fill="#81c995" cx="17" cy="15.5" r="3.5"></circle>
      </g>
      <g id="business-printer-status-grey-dark">
        <path d="M12,3 L12,7 L22,7 L22.0008411,12.1834702 C21.4889261,11.4131214 20.8037622,10.7678435 20.000963,10.3032504 L20,9 L12,9 L12,11 L13.0312427,11.0000183 C11.7856236,12.0994345 11,13.7079712 11,15.5 C11,16.7266262 11.3680857,17.8672813 11.9998276,18.8175358 L12,19 L12.1267078,19.0009178 C12.7530956,19.8713157 13.6069102,20.5670952 14.6011413,21.0012461 L2,21 L2,3 L12,3 Z M6,17 L4,17 L4,19 L6,19 L6,17 Z M10,17 L8,17 L8,19 L10,19 L10,17 Z M6,13 L4,13 L4,15 L6,15 L6,13 Z M10,13 L8,13 L8,15 L10,15 L10,13 Z M6,9 L4,9 L4,11 L6,11 L6,9 Z M10,9 L8,9 L8,11 L10,11 L10,9 Z M6,5 L4,5 L4,7 L6,7 L6,5 Z M10,5 L8,5 L8,7 L10,7 L10,5 Z"></path>
        <circle fill="#80868b" cx="17" cy="15.5" r="3.5"></circle>
      </g>
      <g id="business-printer-status-orange-dark">
        <path d="M12,3 L12,7 L22,7 L22.0008411,12.1834702 C21.4889261,11.4131214 20.8037622,10.7678435 20.000963,10.3032504 L20,9 L12,9 L12,11 L13.0312427,11.0000183 C11.7856236,12.0994345 11,13.7079712 11,15.5 C11,16.7266262 11.3680857,17.8672813 11.9998276,18.8175358 L12,19 L12.1267078,19.0009178 C12.7530956,19.8713157 13.6069102,20.5670952 14.6011413,21.0012461 L2,21 L2,3 L12,3 Z M6,17 L4,17 L4,19 L6,19 L6,17 Z M10,17 L8,17 L8,19 L10,19 L10,17 Z M6,13 L4,13 L4,15 L6,15 L6,13 Z M10,13 L8,13 L8,15 L10,15 L10,13 Z M6,9 L4,9 L4,11 L6,11 L6,9 Z M10,9 L8,9 L8,11 L10,11 L10,9 Z M6,5 L4,5 L4,7 L6,7 L6,5 Z M10,5 L8,5 L8,7 L10,7 L10,5 Z"></path>
        <circle fill="#fdd663" cx="17" cy="15.5" r="3.5"></circle>
      </g>
      <g id="business-printer-status-red-dark">
        <path d="M12,3 L12,7 L22,7 L22.0008411,12.1834702 C21.4889261,11.4131214 20.8037622,10.7678435 20.000963,10.3032504 L20,9 L12,9 L12,11 L13.0312427,11.0000183 C11.7856236,12.0994345 11,13.7079712 11,15.5 C11,16.7266262 11.3680857,17.8672813 11.9998276,18.8175358 L12,19 L12.1267078,19.0009178 C12.7530956,19.8713157 13.6069102,20.5670952 14.6011413,21.0012461 L2,21 L2,3 L12,3 Z M6,17 L4,17 L4,19 L6,19 L6,17 Z M10,17 L8,17 L8,19 L10,19 L10,17 Z M6,13 L4,13 L4,15 L6,15 L6,13 Z M10,13 L8,13 L8,15 L10,15 L10,13 Z M6,9 L4,9 L4,11 L6,11 L6,9 Z M10,9 L8,9 L8,11 L10,11 L10,9 Z M6,5 L4,5 L4,7 L6,7 L6,5 Z M10,5 L8,5 L8,7 L10,7 L10,5 Z"></path>
        <circle fill="#f28b82" cx="17" cy="15.5" r="3.5"></circle>
      </g>
      <svg id="no-printer-available" xmlns="http://www.w3.org/2000/svg" width="322" height="237" viewBox="0 0 322 237" fill="none">
        <path d="M236.777 90.584L209.208 68.9842C205.778 66.3608 203.517 62.4502 202.924 58.1118C202.331 53.7735 203.453 49.3625 206.044 45.8485V45.8485C207.327 44.1076 208.932 42.6395 210.768 41.528C212.604 40.4166 214.635 39.6835 216.744 39.3707C218.853 39.0579 221 39.1715 223.062 39.705C225.123 40.2386 227.059 41.1816 228.758 42.4802L256.319 64.0787C259.751 66.7009 262.013 70.6112 262.608 74.9499C263.203 79.2886 262.082 83.7005 259.491 87.2157V87.2157C256.899 90.7296 253.05 93.0584 248.791 93.69C244.531 94.3216 240.21 93.2044 236.777 90.584V90.584Z" fill="var(--cros-sys-illo-color3)" />
        <path d="M85.1662 84.2372L72.8191 98.9518C71.2617 100.808 71.5038 103.575 73.3599 105.132L87.9005 117.333C89.7565 118.891 92.5237 118.649 94.0811 116.793L106.428 102.078C107.986 100.222 107.743 97.4549 105.887 95.8975L91.3468 83.6965C89.4908 82.1391 86.7236 82.3811 85.1662 84.2372Z" fill="var(--cros-sys-illo-color5)" />
        <path d="M78.7032 188.115C84.1071 186.925 89.4438 185.445 94.689 183.681C101.986 181.501 109.83 182.242 116.498 185.74C120.141 187.833 123.896 189.732 127.749 191.43C141.472 196.798 157.382 189.517 160.959 174.989C164.101 162.228 155.512 148.399 142.122 146.423C135.936 145.481 129.647 146.652 123.428 146.255C116.808 145.902 110.548 143.297 105.721 138.888C101.595 135.075 97.8122 130.889 93.1593 127.592C88.65 124.363 83.3803 122.294 77.8232 121.57C69.0434 120.448 60.1179 122.691 52.8967 127.833C45.6755 132.975 40.7124 140.622 39.0361 149.189C37.3598 157.757 39.0988 166.587 43.8928 173.85C48.6867 181.114 56.1678 186.253 64.7856 188.203C69.3679 189.128 74.109 189.098 78.7032 188.115V188.115Z" fill="var(--cros-sys-illo-color1-2)" />
        <path d="M257.605 175.866C257.354 176.426 256.987 176.925 256.527 177.331C256.068 177.737 255.527 178.041 254.941 178.222C254.354 178.403 253.734 178.457 253.122 178.381C252.511 178.305 251.921 178.101 251.391 177.781C242.089 172.217 235.131 163.435 231.848 153.117C228.564 142.798 229.186 131.667 233.594 121.854C238.002 112.04 245.887 104.233 255.74 99.9269C265.593 95.6204 276.722 95.1167 286.998 98.5122C287.585 98.7057 288.126 99.0202 288.585 99.4355C289.045 99.8507 289.413 100.357 289.665 100.922C289.918 101.487 290.049 102.098 290.051 102.714C290.052 103.331 289.924 103.94 289.675 104.501L257.605 175.866Z" stroke="var(--cros-sys-illo-secondary)" stroke-width="3" stroke-miterlimit="10" />
        <path d="M204.704 187.052C215.197 187.052 223.704 178.545 223.704 168.052C223.704 157.558 215.197 149.052 204.704 149.052C194.21 149.052 185.704 157.558 185.704 168.052C185.704 178.545 194.21 187.052 204.704 187.052Z" stroke="var(--cros-sys-illo-color4)" stroke-width="3" stroke-miterlimit="10" />
        <circle cx="159" cy="96.0518" r="46" fill="var(--cros-sys-illo-secondary)" />
        <path d="M152.325 106.303L153.411 103.123C153.938 101.577 154.568 100.313 155.298 99.3294C156.088 98.317 157.075 97.4462 158.261 96.717C159.507 95.9588 161.032 95.1731 162.839 94.36C164.112 93.8086 165.26 93.2637 166.282 92.7252C167.304 92.1867 168.165 91.5437 168.864 90.7962C169.623 90.0196 170.198 89.0572 170.59 87.909C171.299 85.8334 171.195 83.8994 170.279 82.1069C169.406 80.3296 167.733 79.0186 165.26 78.1739C163.671 77.6309 162.211 77.5021 160.88 77.7875C159.55 78.0728 158.38 78.6102 157.371 79.3997C156.361 80.1892 155.507 81.0314 154.806 81.9265L150.386 77.9757C151.339 76.7726 152.625 75.6089 154.241 74.4844C155.858 73.36 157.753 72.5771 159.926 72.1356C162.098 71.6941 164.487 71.9183 167.093 72.8083C169.787 73.7283 171.939 75.0798 173.549 76.8626C175.219 78.6163 176.281 80.6312 176.737 82.9072C177.251 85.1542 177.101 87.47 176.287 89.8548C175.653 91.7096 174.69 93.2299 173.398 94.4157C172.149 95.6167 170.836 96.5736 169.458 97.2866C168.096 97.9554 166.918 98.5149 165.926 98.965C164.712 99.4874 163.66 100.04 162.771 100.624C161.881 101.208 161.131 101.889 160.52 102.666C159.909 103.444 159.415 104.385 159.038 105.489L158.088 108.271L152.325 106.303ZM150.33 121.673C149.137 121.266 148.257 120.521 147.69 119.44C147.181 118.329 147.131 117.178 147.538 115.985C147.93 114.837 148.66 114.001 149.726 113.478C150.852 112.925 152.011 112.853 153.203 113.26C154.351 113.652 155.179 114.404 155.688 115.514C156.255 116.596 156.343 117.71 155.951 118.859C155.544 120.051 154.777 120.923 153.652 121.476C152.585 121.999 151.478 122.065 150.33 121.673Z" fill="var(--cros-sys-illo-base)" />
      </svg>
    

      <!--
      These icons are copied from Polymer's iron-icons and kept in sorted order.
      See http://goo.gl/Y1OdAq for instructions on adding additional icons.
      -->
      <g id="business"><path d="M12 7V3H2v18h20V7H12zM6 19H4v-2h2v2zm0-4H4v-2h2v2zm0-4H4V9h2v2zm0-4H4V5h2v2zm4 12H8v-2h2v2zm0-4H8v-2h2v2zm0-4H8V9h2v2zm0-4H8V5h2v2zm10 12h-8v-2h2v-2h-2v-2h2v-2h-2V9h8v10zm-2-8h-2v2h2v-2zm0 4h-2v2h2v-2z"></path></g>
      <g id="print"><path d="M19 8H5c-1.66 0-3 1.34-3 3v6h4v4h12v-4h4v-6c0-1.66-1.34-3-3-3zm-3 11H8v-5h8v5zm3-7c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm-1-9H6v4h12V3z"></path></g>
    </defs>
  </svg>
</cr-iconset>
`;const iconsets$1=div$1.querySelectorAll("cr-iconset");for(const iconset of iconsets$1){document.head.appendChild(iconset)}function getTemplate$p(){return html$1`<!--_html_template_start_--><style include="print-preview-shared cr-hidden-style md-select">:host{--duplex-icon-side-padding:8px;--duplex-icon-size:16px}.md-select{background-position:var(--duplex-icon-side-padding) center,calc(100% - var(--md-select-side-padding)) center;background-size:var(--duplex-icon-size),var(--md-arrow-width);padding-inline-start:32px}:host-context([dir=rtl]) .md-select{background-position-x:calc(100% - var(--duplex-icon-side-padding)),var(--md-select-side-padding)}</style>
<print-preview-settings-section>
  <div slot="title">
    <label id="label">$i18n{optionTwoSided}</label>
  </div>
  <div slot="controls" class="checkbox">
    <cr-checkbox id="duplex" aria-labelledby="label"
        disabled$="[[getDisabled_(
          disabled,
          settings.duplex.setByGlobalPolicy,
          settings.duplex.setByDestinationPolicy)]]"
        on-change="onCheckboxChange_">
      $i18n{printOnBothSidesLabel}
    </cr-checkbox>
  </div>
</print-preview-settings-section>
<cr-collapse opened="[[getOpenCollapse_(
    settings.duplex.*,
    settings.duplexShortEdge.available,
    allowedValuesApplied)]]">
  <print-preview-settings-section>
    <div slot="title"></div>
    <div slot="controls">
      <select class="md-select" aria-labelledby="duplex"
          style="background-image: [[getBackgroundImages_(
            settings.duplexShortEdge.value, dark)]];"
          disabled$="[[getDisabled_(
              disabled,
              settings.duplexShortEdge.setByGlobalPolicy,
              settings.duplexShortEdge.setByDestinationPolicy)]]"
          value="[[selectedValue]]" on-change="onSelectChange">
        <option value="[[duplexValueEnum_.LONG_EDGE]]">
          $i18n{optionLongEdge}
        </option>
        <option value="[[duplexValueEnum_.SHORT_EDGE]]">
          $i18n{optionShortEdge}
        </option>
      </select>
    </div>
  </print-preview-settings-section>
</cr-collapse>
<!--_html_template_end_-->`}
// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PrintPreviewDuplexSettingsElementBase=SettingsMixin(SelectMixin(PolymerElement));class PrintPreviewDuplexSettingsElement extends PrintPreviewDuplexSettingsElementBase{static get is(){return"print-preview-duplex-settings"}static get template(){return getTemplate$p()}static get properties(){return{allowedValuesApplied:Boolean,dark:Boolean,disabled:Boolean,duplexValueEnum_:{type:Object,value:DuplexMode}}}static get observers(){return["onDuplexSettingChange_(settings.duplex.*)","onDuplexTypeChange_(settings.duplexShortEdge.*)"]}onDuplexSettingChange_(){this.$.duplex.checked=this.getSettingValue("duplex")}onDuplexTypeChange_(){this.selectedValue=this.getSettingValue("duplexShortEdge")?DuplexMode.SHORT_EDGE.toString():DuplexMode.LONG_EDGE.toString()}onCheckboxChange_(){this.setSetting("duplex",this.$.duplex.checked)}onProcessSelectChange(value){this.setSetting("duplexShortEdge",value===DuplexMode.SHORT_EDGE.toString())}getOpenCollapse_(){if(this.getSettingValue("duplex")){return this.allowedValuesApplied||this.getSetting("duplexShortEdge").available}return false}getDisabled_(disabled,managedByGlobalPolicy,managedByDestinationPolicy){return disabled||managedByGlobalPolicy||managedByDestinationPolicy}getBackgroundImages_(){const icon=this.getSettingValue("duplexShortEdge")?"short-edge":"long-edge";const iconset=IconsetMap.getInstance().get("print-preview");assert(iconset);return getSelectDropdownBackground(iconset,icon,this)}}customElements.define(PrintPreviewDuplexSettingsElement.is,PrintPreviewDuplexSettingsElement);function getTemplate$o(){return html$1`<!--_html_template_start_--><style>:host{align-items:center;display:flex;justify-content:space-between;padding:var(--print-preview-sidebar-margin) var(--print-preview-sidebar-margin) 12px}@media (prefers-color-scheme:light){:host{background-color:white}}#headerContainer{align-items:center;display:flex}.summary,.title{color:var(--cr-primary-text-color);line-height:calc(20/13 * 1em);margin:0}.title{font-size:calc(16/13 * 1em);font-weight:400}.summary{font-weight:500}cr-icon{align-self:center;fill:var(--cr-secondary-text-color);height:16px;margin-inline-start:8px;width:16px}</style>
<div id="headerContainer">
  <h1 class="title">$i18n{title}</h1>
  <cr-icon hidden$="[[!managed]]" icon="print-preview:business"
       alt="" title="$i18n{managedSettings}">
  </cr-icon>
</div>
<span class="summary">[[summary_]]</span>
<!--_html_template_end_-->`}
// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PrintPreviewHeaderElementBase=SettingsMixin(PolymerElement);class PrintPreviewHeaderElement extends PrintPreviewHeaderElementBase{static get is(){return"print-preview-header"}static get template(){return getTemplate$o()}static get properties(){return{destination:Object,error:Number,state:Number,managed:Boolean,sheetCount:Number,summary_:String}}static get observers(){return["updateSummary_(sheetCount, state, destination.id)"]}isPdf_(){return this.destination&&this.destination.type===PrinterType.PDF_PRINTER}updateSummary_(){switch(this.state){case State.PRINTING:this.summary_=loadTimeData.getString(this.isPdf_()?"saving":"printing");break;case State.READY:this.updateSheetsSummary_();break;case State.FATAL_ERROR:this.summary_=this.getErrorMessage_();break;default:this.summary_=null;break}}getErrorMessage_(){switch(this.error){case Error$1.PRINT_FAILED:return loadTimeData.getString("couldNotPrint");default:return""}}updateSheetsSummary_(){if(this.sheetCount===0){this.summary_="";return}const pageOrSheet=this.isPdf_()?"Page":"Sheet";PluralStringProxyImpl.getInstance().getPluralString(`printPreview${pageOrSheet}SummaryLabel`,this.sheetCount).then((label=>{this.summary_=label}))}}customElements.define(PrintPreviewHeaderElement.is,PrintPreviewHeaderElement);function getTemplate$n(){return html$1`<!--_html_template_start_--><style include="print-preview-shared md-select"></style>
<print-preview-settings-section>
  <span id="layout-label" slot="title">$i18n{layoutLabel}</span>
  <div slot="controls">
    <select class="md-select" aria-labelledby="layout-label"
        disabled$="[[disabled]]" value="[[selectedValue]]"
        on-change="onSelectChange">
      <option value="portrait" selected>$i18n{optionPortrait}</option>
      <option value="landscape">$i18n{optionLandscape}</option>
    </select>
  </div>
</print-preview-settings-section>
<!--_html_template_end_-->`}
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PrintPreviewLayoutSettingsElementBase=SettingsMixin(SelectMixin(PolymerElement));class PrintPreviewLayoutSettingsElement extends PrintPreviewLayoutSettingsElementBase{static get is(){return"print-preview-layout-settings"}static get template(){return getTemplate$n()}static get properties(){return{disabled:Boolean}}static get observers(){return["onLayoutSettingChange_(settings.layout.value)"]}onLayoutSettingChange_(newValue){this.selectedValue=newValue?"landscape":"portrait"}onProcessSelectChange(value){this.setSetting("layout",value==="landscape")}}customElements.define(PrintPreviewLayoutSettingsElement.is,PrintPreviewLayoutSettingsElement);function getTemplate$m(){return html$1`<!--_html_template_start_--><style include="print-preview-shared">:host print-preview-settings-select{margin:0 calc(var(--print-preview-sidebar-margin) - 2px)}</style>
<print-preview-settings-section>
  <span id="media-size-label" slot="title">$i18n{mediaSizeLabel}</span>
  <div slot="controls">
    <print-preview-settings-select aria-label="$i18n{mediaSizeLabel}"
        capability="[[capability]]" setting-name="mediaSize"
        disabled="[[disableSelectionBox_]]"
        settings="{{settings}}">
    </print-preview-settings-select>
  </div>
</print-preview-settings-section>

<cr-collapse opened="[[settings.borderless.available]]">
  <print-preview-settings-section>
    <div slot="title"></div>
    <div slot="controls" class="checkbox">
      <cr-checkbox id="borderless" aria-labelledby="borderless-label"
          disabled$="[[disableBorderlessCheckbox_]]"
          on-change="onBorderlessCheckboxChange_">
        <span id="borderless-label">$i18n{borderlessLabel}</span>
      </cr-checkbox>
    </div>
  </print-preview-settings-section>
</cr-collapse>
<!--_html_template_end_-->`}
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PrintPreviewMediaSizeSettingsElementBase=SettingsMixin(PolymerElement);class PrintPreviewMediaSizeSettingsElement extends PrintPreviewMediaSizeSettingsElementBase{constructor(){super(...arguments);this.lastSelectedValue_=""}static get is(){return"print-preview-media-size-settings"}static get template(){return getTemplate$m()}static get properties(){return{capability:Object,disableBorderlessCheckbox_:{type:Boolean,computed:"computeDisableBorderlessCheckbox_(disabled, "+"settings.mediaSize.value.has_borderless_variant)"},disabled:Boolean,disableSelectionBox_:{type:Boolean,computed:"computeDisableSelectionBox_(disabled, "+"settings.mediaSize.setByDestinationPolicy)"}}}static get observers(){return["onMediaSizeSettingChange_(settings.mediaSize.*, capability.option)","updateBorderlessAvailabilityForSize_("+"settings.mediaSize.*, settings.borderless.*)"]}onMediaSizeSettingChange_(){if(!this.capability){return}const valueToSet=JSON.stringify(this.getSettingValue("mediaSize"));for(const option of this.capability.option){if(JSON.stringify(option)===valueToSet){this.shadowRoot.querySelector("print-preview-settings-select").selectValue(valueToSet);this.lastSelectedValue_=valueToSet;return}}if(valueToSet!==this.lastSelectedValue_){const defaultOption=this.capability.option.find((o=>!!o.is_default))||this.capability.option[0];this.setSetting("mediaSize",defaultOption,true)}}computeDisableBorderlessCheckbox_(disabled,hasBorderlessVariant){return disabled||!hasBorderlessVariant}updateBorderlessAvailabilityForSize_(){if(!loadTimeData.getBoolean("isBorderlessPrintingEnabled")){return}const size=this.getSettingValue("mediaSize");if(size.has_borderless_variant){this.$.borderless.checked=this.getSettingValue("borderless")}else{this.$.borderless.checked=size?.imageable_area_left_microns===0&&size?.imageable_area_bottom_microns===0&&size?.imageable_area_right_microns===size.width_microns&&size?.imageable_area_top_microns===size.height_microns}}onBorderlessCheckboxChange_(){this.setSetting("borderless",this.$.borderless.checked)}computeDisableSelectionBox_(disabled,managedByDestinationPolicy){return disabled||managedByDestinationPolicy}}customElements.define(PrintPreviewMediaSizeSettingsElement.is,PrintPreviewMediaSizeSettingsElement);function getTemplate$l(){return html$1`<!--_html_template_start_--><style include="print-preview-shared">:host print-preview-settings-select{margin:0 calc(var(--print-preview-sidebar-margin) - 2px)}</style>
<print-preview-settings-section>
  <span id="media-type-label" slot="title">$i18n{mediaTypeLabel}</span>
  <div slot="controls">
    <print-preview-settings-select aria-label="$i18n{mediaTypeLabel}"
        capability="[[capability]]" setting-name="mediaType"
        disabled="[[isSelectionBoxDisabled_(
          disabled, settings.mediaType.setByDestinationPolicy)]]"
        settings="{{settings}}">
    </print-preview-settings-select>
  </div>
</print-preview-settings-section>
<!--_html_template_end_-->`}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PrintPreviewMediaTypeSettingsElementBase=SettingsMixin(PolymerElement);class PrintPreviewMediaTypeSettingsElement extends PrintPreviewMediaTypeSettingsElementBase{constructor(){super(...arguments);this.lastSelectedValue_=""}static get is(){return"print-preview-media-type-settings"}static get template(){return getTemplate$l()}static get properties(){return{capability:Object,disabled:Boolean}}static get observers(){return["onMediaTypeSettingChange_(settings.mediaType.*, capability.option)"]}onMediaTypeSettingChange_(){if(!this.capability){return}const valueToSet=JSON.stringify(this.getSettingValue("mediaType"));for(const option of this.capability.option){if(JSON.stringify(option)===valueToSet){this.shadowRoot.querySelector("print-preview-settings-select").selectValue(valueToSet);this.lastSelectedValue_=valueToSet;return}}if(valueToSet!==this.lastSelectedValue_){const defaultOption=this.capability.option.find((o=>!!o.is_default))||this.capability.option[0];this.setSetting("mediaType",defaultOption,true)}}isSelectionBoxDisabled_(){return this.disabled||this.getSetting("mediaType").setByDestinationPolicy}}customElements.define(PrintPreviewMediaTypeSettingsElement.is,PrintPreviewMediaTypeSettingsElement);function getTemplate$k(){return html$1`<!--_html_template_start_--><style include="print-preview-shared md-select"></style>
<print-preview-settings-section>
  <span id="margins-label" slot="title">$i18n{marginsLabel}</span>
  <div slot="controls">
    <select class="md-select" aria-labelledby="margins-label"
        disabled$="[[marginsDisabled_]]"
        value="[[selectedValue]]" on-change="onSelectChange">
      <!-- The order of these options must match the natural order of their
      values, which come from MarginsType. -->
      <option value="[[marginsTypeEnum_.DEFAULT]]" selected>
        $i18n{defaultMargins}
      </option>
      <option value="[[marginsTypeEnum_.NO_MARGINS]]">
        $i18n{noMargins}
      </option>
      <option value="[[marginsTypeEnum_.MINIMUM]]">
        $i18n{minimumMargins}
      </option>
      <option value="[[marginsTypeEnum_.CUSTOM]]">
        $i18n{customMargins}
      </option>
    </select>
  </div>
</print-preview-settings-section>
<!--_html_template_end_-->`}
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PrintPreviewMarginsSettingsElementBase=SettingsMixin(SelectMixin(PolymerElement));class PrintPreviewMarginsSettingsElement extends PrintPreviewMarginsSettingsElementBase{constructor(){super(...arguments);this.loaded_=false}static get is(){return"print-preview-margins-settings"}static get template(){return getTemplate$k()}static get properties(){return{disabled:{type:Boolean,observer:"updateMarginsDisabled_"},state:{type:Number,observer:"onStateChange_"},marginsDisabled_:Boolean,marginsTypeEnum_:{type:Object,value:MarginsType}}}static get observers(){return["onMarginsSettingChange_(settings.margins.value)","onMediaSizeOrLayoutChange_("+"settings.mediaSize.value, settings.layout.value)","onPagesPerSheetSettingChange_(settings.pagesPerSheet.value)"]}onStateChange_(){if(this.state===State.READY){this.loaded_=true}}onMediaSizeOrLayoutChange_(){if(this.loaded_&&this.getSetting("margins").value===MarginsType.CUSTOM){this.setSetting("margins",MarginsType.DEFAULT)}}onPagesPerSheetSettingChange_(newValue){if(newValue>1){this.setSetting("margins",MarginsType.DEFAULT)}this.updateMarginsDisabled_()}onMarginsSettingChange_(newValue){this.selectedValue=newValue.toString()}onProcessSelectChange(value){this.setSetting("margins",parseInt(value,10))}updateMarginsDisabled_(){this.marginsDisabled_=this.getSettingValue("pagesPerSheet")>1||this.disabled}}customElements.define(PrintPreviewMarginsSettingsElement.is,PrintPreviewMarginsSettingsElement);
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const div=document.createElement("div");div.innerHTML=getTrustedHTML`
<cr-iconset name="cr20" size="20">
  <svg>
    <defs>
      <!--
      Keep these in sorted order by id="".
      -->
      <g id="block">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M10 0C4.48 0 0 4.48 0 10C0 15.52 4.48 20 10 20C15.52 20 20 15.52 20 10C20 4.48 15.52 0 10 0ZM2 10C2 5.58 5.58 2 10 2C11.85 2 13.55 2.63 14.9 3.69L3.69 14.9C2.63 13.55 2 11.85 2 10ZM5.1 16.31C6.45 17.37 8.15 18 10 18C14.42 18 18 14.42 18 10C18 8.15 17.37 6.45 16.31 5.1L5.1 16.31Z">
        </path>
      </g>
      <g id="cloud-off">
        <path
          d="M16 18.125L13.875 16H5C3.88889 16 2.94444 15.6111 2.16667 14.8333C1.38889 14.0556 1 13.1111 1 12C1 10.9444 1.36111 10.0347 2.08333 9.27083C2.80556 8.50694 3.6875 8.09028 4.72917 8.02083C4.77083 7.86805 4.8125 7.72222 4.85417 7.58333C4.90972 7.44444 4.97222 7.30555 5.04167 7.16667L1.875 4L2.9375 2.9375L17.0625 17.0625L16 18.125ZM5 14.5H12.375L6.20833 8.33333C6.15278 8.51389 6.09722 8.70139 6.04167 8.89583C6 9.07639 5.95139 9.25694 5.89583 9.4375L4.83333 9.52083C4.16667 9.57639 3.61111 9.84028 3.16667 10.3125C2.72222 10.7708 2.5 11.3333 2.5 12C2.5 12.6944 2.74306 13.2847 3.22917 13.7708C3.71528 14.2569 4.30556 14.5 5 14.5ZM17.5 15.375L16.3958 14.2917C16.7153 14.125 16.9792 13.8819 17.1875 13.5625C17.3958 13.2431 17.5 12.8889 17.5 12.5C17.5 11.9444 17.3056 11.4722 16.9167 11.0833C16.5278 10.6944 16.0556 10.5 15.5 10.5H14.125L14 9.14583C13.9028 8.11806 13.4722 7.25694 12.7083 6.5625C11.9444 5.85417 11.0417 5.5 10 5.5C9.65278 5.5 9.31944 5.54167 9 5.625C8.69444 5.70833 8.39583 5.82639 8.10417 5.97917L7.02083 4.89583C7.46528 4.61806 7.93056 4.40278 8.41667 4.25C8.91667 4.08333 9.44444 4 10 4C11.4306 4 12.6736 4.48611 13.7292 5.45833C14.7847 6.41667 15.375 7.59722 15.5 9C16.4722 9 17.2986 9.34028 17.9792 10.0208C18.6597 10.7014 19 11.5278 19 12.5C19 13.0972 18.8611 13.6458 18.5833 14.1458C18.3194 14.6458 17.9583 15.0556 17.5 15.375Z">
        </path>
      </g>
      <g id="delete">
        <path
          d="M 5.832031 17.5 C 5.375 17.5 4.984375 17.335938 4.65625 17.011719 C 4.328125 16.683594 4.167969 16.292969 4.167969 15.832031 L 4.167969 5 L 3.332031 5 L 3.332031 3.332031 L 7.5 3.332031 L 7.5 2.5 L 12.5 2.5 L 12.5 3.332031 L 16.667969 3.332031 L 16.667969 5 L 15.832031 5 L 15.832031 15.832031 C 15.832031 16.292969 15.671875 16.683594 15.34375 17.011719 C 15.015625 17.335938 14.625 17.5 14.167969 17.5 Z M 14.167969 5 L 5.832031 5 L 5.832031 15.832031 L 14.167969 15.832031 Z M 7.5 14.167969 L 9.167969 14.167969 L 9.167969 6.667969 L 7.5 6.667969 Z M 10.832031 14.167969 L 12.5 14.167969 L 12.5 6.667969 L 10.832031 6.667969 Z M 5.832031 5 L 5.832031 15.832031 Z M 5.832031 5 ">
        </path>
      </g>
      <g id="domain" viewBox="0 -960 960 960">
        <path d="M96-144v-672h384v144h384v528H96Zm72-72h72v-72h-72v72Zm0-152h72v-72h-72v72Zm0-152h72v-72h-72v72Zm0-152h72v-72h-72v72Zm168 456h72v-72h-72v72Zm0-152h72v-72h-72v72Zm0-152h72v-72h-72v72Zm0-152h72v-72h-72v72Zm144 456h312v-384H480v80h72v72h-72v80h72v72h-72v80Zm168-232v-72h72v72h-72Zm0 152v-72h72v72h-72Z"></path>
      </g>
      <g id="kite">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M4.6327 8.00094L10.3199 2L16 8.00094L10.1848 16.8673C10.0995 16.9873 10.0071 17.1074 9.90047 17.2199C9.42417 17.7225 8.79147 18 8.11611 18C7.44076 18 6.80806 17.7225 6.33175 17.2199C5.85545 16.7173 5.59242 16.0497 5.59242 15.3371C5.59242 14.977 5.46445 14.647 5.22275 14.3919C4.98104 14.1369 4.66825 14.0019 4.32701 14.0019H4V12.6667H4.32701C5.00237 12.6667 5.63507 12.9442 6.11137 13.4468C6.58768 13.9494 6.85071 14.617 6.85071 15.3296C6.85071 15.6896 6.97867 16.0197 7.22038 16.2747C7.46209 16.5298 7.77488 16.6648 8.11611 16.6648C8.45735 16.6648 8.77014 16.5223 9.01185 16.2747C9.02396 16.2601 9.03607 16.246 9.04808 16.2319C9.08541 16.1883 9.12176 16.1458 9.15403 16.0947L9.55213 15.4946L4.6327 8.00094ZM10.3199 13.9371L6.53802 8.17116L10.3199 4.1814L14.0963 8.17103L10.3199 13.9371Z">
        </path>
      </g>
      <g id="menu">
        <path d="M2 4h16v2H2zM2 9h16v2H2zM2 14h16v2H2z"></path>
      </g>
      <g id="password">
        <path d="M5.833 11.667c.458 0 .847-.16 1.167-.479.333-.333.5-.729.5-1.188s-.167-.847-.5-1.167a1.555 1.555 0 0 0-1.167-.5c-.458 0-.854.167-1.188.5A1.588 1.588 0 0 0 4.166 10c0 .458.16.854.479 1.188.333.319.729.479 1.188.479Zm0 3.333c-1.389 0-2.569-.486-3.542-1.458C1.319 12.569.833 11.389.833 10c0-1.389.486-2.569 1.458-3.542C3.264 5.486 4.444 5 5.833 5c.944 0 1.813.243 2.604.729a4.752 4.752 0 0 1 1.833 1.979h7.23c.458 0 .847.167 1.167.5.333.319.5.708.5 1.167v3.958c0 .458-.167.854-.5 1.188A1.588 1.588 0 0 1 17.5 15h-3.75a1.658 1.658 0 0 1-1.188-.479 1.658 1.658 0 0 1-.479-1.188v-1.042H10.27a4.59 4.59 0 0 1-1.813 2A5.1 5.1 0 0 1 5.833 15Zm3.292-4.375h4.625v2.708H15v-1.042a.592.592 0 0 1 .167-.438.623.623 0 0 1 .458-.188c.181 0 .327.063.438.188a.558.558 0 0 1 .188.438v1.042H17.5V9.375H9.125a3.312 3.312 0 0 0-1.167-1.938 3.203 3.203 0 0 0-2.125-.77 3.21 3.21 0 0 0-2.354.979C2.827 8.298 2.5 9.083 2.5 10s.327 1.702.979 2.354a3.21 3.21 0 0 0 2.354.979c.806 0 1.514-.25 2.125-.75.611-.514 1-1.167 1.167-1.958Z"></path>
      </g>
      
        <g id="banner-warning">
          <path fill-rule="evenodd" clip-rule="evenodd"
            d="M9.13177 1.50386C9.51566 0.832046 10.4844 0.832046 10.8683 1.50386L18.8683 15.5039C19.2492 16.1705 18.7678 17 18 17H2.00001C1.23219 17 0.750823 16.1705 1.13177 15.5039L9.13177 1.50386ZM10 4.01556L3.72321 15H16.2768L10 4.01556ZM9 11H11V7H9V11ZM11 14H9V12H11V14Z">
          </path>
        </g>
      
  </svg>
</cr-iconset>

<!-- NOTE: In the common case that the final icon will be 20x20, export the SVG
     at 20px and place it in the section above. -->
<cr-iconset name="cr" size="24">
  <svg>
    <defs>
      <!--
      These icons are copied from Polymer's iron-icons and kept in sorted order.
      -->
      <g id="add">
        <path d="M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z" />
      </g>
      <g id="arrow-back">
        <path
          d="m7.824 13 5.602 5.602L12 20l-8-8 8-8 1.426 1.398L7.824 11H20v2Zm0 0">
        </path>
      </g>
      <g id="arrow-drop-up">
        <path d="M7 14l5-5 5 5z"></path>
      </g>
      <g id="arrow-drop-down">
        <path d="M7 10l5 5 5-5z"></path>
      </g>
      <g id="arrow-forward">
        <path
          d="M12 4l-1.41 1.41L16.17 11H4v2h12.17l-5.58 5.59L12 20l8-8z">
        </path>
      </g>
      <g id="arrow-right">
        <path d="M10 7l5 5-5 5z"></path>
      </g>
      <g id="cancel">
        <path
          d="M12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.47 10-10S17.53 2 12 2zm5 13.59L15.59 17 12 13.41 8.41 17 7 15.59 10.59 12 7 8.41 8.41 7 12 10.59 15.59 7 17 8.41 13.41 12 17 15.59z">
        </path>
      </g>
      <g id="check">
        <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"></path>
      </g>
      <g id="check-circle" viewBox="0 -960 960 960">
        <path d="m424-296 282-282-56-56-226 226-114-114-56 56 170 170Zm56 216q-83 0-156-31.5T197-197q-54-54-85.5-127T80-480q0-83 31.5-156T197-763q54-54 127-85.5T480-880q83 0 156 31.5T763-763q54 54 85.5 127T880-480q0 83-31.5 156T763-197q-54 54-127 85.5T480-80Zm0-80q134 0 227-93t93-227q0-134-93-227t-227-93q-134 0-227 93t-93 227q0 134 93 227t227 93Zm0-320Z"></path>
      </g>
      <g id="chevron-left">
        <path d="M15.41 7.41L14 6l-6 6 6 6 1.41-1.41L10.83 12z"></path>
      </g>
      <g id="chevron-right">
        <path d="M10 6L8.59 7.41 13.17 12l-4.58 4.59L10 18l6-6z"></path>
      </g>
      <g id="clear">
        <path
          d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z">
        </path>
      </g>
      <g id="chrome-product" viewBox="0 -960 960 960">
        <path d="M336-479q0 60 42 102t102 42q60 0 102-42t42-102q0-60-42-102t-102-42q-60 0-102 42t-42 102Zm144 216q11 0 22.5-.5T525-267L427-99q-144-16-237.5-125T96-479q0-43 9.5-84.5T134-645l160 274q28 51 78 79.5T480-263Zm0-432q-71 0-126.5 42T276-545l-98-170q53-71 132.5-109.5T480-863q95 0 179 45t138 123H480Zm356 72q15 35 21.5 71t6.5 73q0 155-100 260.5T509-96l157-275q14-25 22-52t8-56q0-40-15-77t-41-67h196Z">
        </path>
      </g>
      <g id="close">
        <path
          d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z">
        </path>
      </g>
      <g id="computer">
        <path
          d="M20 18c1.1 0 1.99-.9 1.99-2L22 6c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2H0v2h24v-2h-4zM4 6h16v10H4V6z">
        </path>
      </g>
      <g id="create">
        <path
          d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04c.39-.39.39-1.02 0-1.41l-2.34-2.34c-.39-.39-1.02-.39-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z">
        </path>
      </g>
      <g id="delete" viewBox="0 -960 960 960">
        <path
          d="M309.37-135.87q-34.48 0-58.74-24.26-24.26-24.26-24.26-58.74v-474.5h-53.5v-83H378.5v-53.5h202.52v53.5h206.11v83h-53.5v474.07q0 35.21-24.26 59.32t-58.74 24.11H309.37Zm341.26-557.5H309.37v474.5h341.26v-474.5ZM379.7-288.24h77.5v-336h-77.5v336Zm123.1 0h77.5v-336h-77.5v336ZM309.37-693.37v474.5-474.5Z">
        </path>
      </g>
      <g id="domain">
        <path
          d="M12 7V3H2v18h20V7H12zM6 19H4v-2h2v2zm0-4H4v-2h2v2zm0-4H4V9h2v2zm0-4H4V5h2v2zm4 12H8v-2h2v2zm0-4H8v-2h2v2zm0-4H8V9h2v2zm0-4H8V5h2v2zm10 12h-8v-2h2v-2h-2v-2h2v-2h-2V9h8v10zm-2-8h-2v2h2v-2zm0 4h-2v2h2v-2z">
        </path>
      </g>
      <!-- source: https://fonts.google.com/icons?selected=Material+Symbols+Outlined:family_link:FILL@0;wght@0;GRAD@0;opsz@24&icon.size=24&icon.color=%23e8eaed -->
      <g id="kite" viewBox="0 -960 960 960">
        <path
          d="M390-40q-51 0-90.5-30.5T246-149q-6-23-25-37t-43-14q-16 0-30 6.5T124-175l-61-51q21-26 51.5-40t63.5-14q51 0 91 30t54 79q6 23 25 37t42 14q19 0 34-10t26-25l1-2-276-381q-8-11-11.5-23t-3.5-24q0-16 6-30.5t18-26.5l260-255q11-11 26-17t30-6q15 0 30 6t26 17l260 255q12 12 18 26.5t6 30.5q0 12-3.5 24T825-538L500-88q-18 25-48 36.5T390-40Zm110-185 260-360-260-255-259 256 259 359Zm1-308Z"/>
        </path>
      </g>
      <g id="error">
        <path
          d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z">
        </path>
      </g>
      <g id="error-outline">
        <path
          d="M11 15h2v2h-2zm0-8h2v6h-2zm.99-5C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z">
        </path>
      </g>
      <g id="expand-less">
        <path d="M12 8l-6 6 1.41 1.41L12 10.83l4.59 4.58L18 14z"></path>
      </g>
      <g id="expand-more">
        <path d="M16.59 8.59L12 13.17 7.41 8.59 6 10l6 6 6-6z"></path>
      </g>
      <g id="extension">
        <path
          d="M20.5 11H19V7c0-1.1-.9-2-2-2h-4V3.5C13 2.12 11.88 1 10.5 1S8 2.12 8 3.5V5H4c-1.1 0-1.99.9-1.99 2v3.8H3.5c1.49 0 2.7 1.21 2.7 2.7s-1.21 2.7-2.7 2.7H2V20c0 1.1.9 2 2 2h3.8v-1.5c0-1.49 1.21-2.7 2.7-2.7 1.49 0 2.7 1.21 2.7 2.7V22H17c1.1 0 2-.9 2-2v-4h1.5c1.38 0 2.5-1.12 2.5-2.5S21.88 11 20.5 11z">
        </path>
      </g>
      <g id="file-download" viewBox="0 -960 960 960">
        <path d="M480-336 288-528l51-51 105 105v-342h72v342l105-105 51 51-192 192ZM263.72-192Q234-192 213-213.15T192-264v-72h72v72h432v-72h72v72q0 29.7-21.16 50.85Q725.68-192 695.96-192H263.72Z"></path>
      </g>
      <g id="fullscreen">
        <path
          d="M7 14H5v5h5v-2H7v-3zm-2-4h2V7h3V5H5v5zm12 7h-3v2h5v-5h-2v3zM14 5v2h3v3h2V5h-5z">
        </path>
      </g>
      <g id="group">
        <path
          d="M16 11c1.66 0 2.99-1.34 2.99-3S17.66 5 16 5c-1.66 0-3 1.34-3 3s1.34 3 3 3zm-8 0c1.66 0 2.99-1.34 2.99-3S9.66 5 8 5C6.34 5 5 6.34 5 8s1.34 3 3 3zm0 2c-2.33 0-7 1.17-7 3.5V19h14v-2.5c0-2.33-4.67-3.5-7-3.5zm8 0c-.29 0-.62.02-.97.05 1.16.84 1.97 1.97 1.97 3.45V19h6v-2.5c0-2.33-4.67-3.5-7-3.5z">
        </path>
      </g>
      <g id="help-outline">
        <path
          d="M11 18h2v-2h-2v2zm1-16C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm0-14c-2.21 0-4 1.79-4 4h2c0-1.1.9-2 2-2s2 .9 2 2c0 2-3 1.75-3 5h2c0-2.25 3-2.5 3-5 0-2.21-1.79-4-4-4z">
        </path>
      </g>
      <g id="history">
        <path
          d="M12.945312 22.75 C 10.320312 22.75 8.074219 21.839844 6.207031 20.019531 C 4.335938 18.199219 3.359375 15.972656 3.269531 13.34375 L 5.089844 13.34375 C 5.175781 15.472656 5.972656 17.273438 7.480469 18.742188 C 8.988281 20.210938 10.808594 20.945312 12.945312 20.945312 C 15.179688 20.945312 17.070312 20.164062 18.621094 18.601562 C 20.167969 17.039062 20.945312 15.144531 20.945312 12.910156 C 20.945312 10.714844 20.164062 8.855469 18.601562 7.335938 C 17.039062 5.816406 15.15625 5.054688 12.945312 5.054688 C 11.710938 5.054688 10.554688 5.339844 9.480469 5.902344 C 8.402344 6.46875 7.476562 7.226562 6.699219 8.179688 L 9.585938 8.179688 L 9.585938 9.984375 L 3.648438 9.984375 L 3.648438 4.0625 L 5.453125 4.0625 L 5.453125 6.824219 C 6.386719 5.707031 7.503906 4.828125 8.804688 4.199219 C 10.109375 3.566406 11.488281 3.25 12.945312 3.25 C 14.300781 3.25 15.570312 3.503906 16.761719 4.011719 C 17.949219 4.519531 18.988281 5.214844 19.875 6.089844 C 20.761719 6.964844 21.464844 7.992188 21.976562 9.167969 C 22.492188 10.34375 22.75 11.609375 22.75 12.964844 C 22.75 14.316406 22.492188 15.589844 21.976562 16.777344 C 21.464844 17.964844 20.761719 19.003906 19.875 19.882812 C 18.988281 20.765625 17.949219 21.464844 16.761719 21.976562 C 15.570312 22.492188 14.300781 22.75 12.945312 22.75 Z M 16.269531 17.460938 L 12.117188 13.34375 L 12.117188 7.527344 L 13.921875 7.527344 L 13.921875 12.601562 L 17.550781 16.179688 Z M 16.269531 17.460938">
        </path>
      </g>
      <g id="info">
        <path
          d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-6h2v6zm0-8h-2V7h2v2z">
        </path>
      </g>
      <g id="info-outline">
        <path
          d="M11 17h2v-6h-2v6zm1-15C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zM11 9h2V7h-2v2z">
        </path>
      </g>
      <g id="insert-drive-file">
        <path
          d="M6 2c-1.1 0-1.99.9-1.99 2L4 20c0 1.1.89 2 1.99 2H18c1.1 0 2-.9 2-2V8l-6-6H6zm7 7V3.5L18.5 9H13z">
        </path>
      </g>
      <g id="location-on">
        <path
          d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z">
        </path>
      </g>
      <g id="mic">
        <path
          d="M12 14c1.66 0 2.99-1.34 2.99-3L15 5c0-1.66-1.34-3-3-3S9 3.34 9 5v6c0 1.66 1.34 3 3 3zm5.3-3c0 3-2.54 5.1-5.3 5.1S6.7 14 6.7 11H5c0 3.41 2.72 6.23 6 6.72V21h2v-3.28c3.28-.48 6-3.3 6-6.72h-1.7z">
        </path>
      </g>
      <g id="more-vert">
        <path
          d="M12 8c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm0 2c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0 6c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z">
        </path>
      </g>
      <g id="open-in-new" viewBox="0 -960 960 960">
        <path
          d="M216-144q-29.7 0-50.85-21.15Q144-186.3 144-216v-528q0-29.7 21.15-50.85Q186.3-816 216-816h264v72H216v528h528v-264h72v264q0 29.7-21.15 50.85Q773.7-144 744-144H216Zm171-192-51-51 357-357H576v-72h240v240h-72v-117L387-336Z">
        </path>
      </g>
      <g id="person">
        <path
          d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z">
        </path>
      </g>
      <g id="phonelink">
        <path
          d="M4 6h18V4H4c-1.1 0-2 .9-2 2v11H0v3h14v-3H4V6zm19 2h-6c-.55 0-1 .45-1 1v10c0 .55.45 1 1 1h6c.55 0 1-.45 1-1V9c0-.55-.45-1-1-1zm-1 9h-4v-7h4v7z">
        </path>
      </g>
      <g id="print">
        <path
          d="M19 8H5c-1.66 0-3 1.34-3 3v6h4v4h12v-4h4v-6c0-1.66-1.34-3-3-3zm-3 11H8v-5h8v5zm3-7c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm-1-9H6v4h12V3z">
        </path>
      </g>
      <g id="schedule">
        <path
          d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm.5-13H11v6l5.25 3.15.75-1.23-4.5-2.67z">
        </path>
      </g>
      <g id="search">
        <path
          d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z">
        </path>
      </g>
      <g id="security">
        <path
          d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4zm0 10.99h7c-.53 4.12-3.28 7.79-7 8.94V12H5V6.3l7-3.11v8.8z">
        </path>
      </g>
      <!-- The <g> IDs are exposed as global variables in Vulcanized mode, which
        conflicts with the "settings" namespace of MD Settings. Using an "_icon"
        suffix prevents the naming conflict. -->
      <g id="settings_icon">
        <path
          d="M19.43 12.98c.04-.32.07-.64.07-.98s-.03-.66-.07-.98l2.11-1.65c.19-.15.24-.42.12-.64l-2-3.46c-.12-.22-.39-.3-.61-.22l-2.49 1c-.52-.4-1.08-.73-1.69-.98l-.38-2.65C14.46 2.18 14.25 2 14 2h-4c-.25 0-.46.18-.49.42l-.38 2.65c-.61.25-1.17.59-1.69.98l-2.49-1c-.23-.09-.49 0-.61.22l-2 3.46c-.13.22-.07.49.12.64l2.11 1.65c-.04.32-.07.65-.07.98s.03.66.07.98l-2.11 1.65c-.19.15-.24.42-.12.64l2 3.46c.12.22.39.3.61.22l2.49-1c.52.4 1.08.73 1.69.98l.38 2.65c.03.24.24.42.49.42h4c.25 0 .46-.18.49-.42l.38-2.65c.61-.25 1.17-.59 1.69-.98l2.49 1c.23.09.49 0 .61-.22l2-3.46c.12-.22.07-.49-.12-.64l-2.11-1.65zM12 15.5c-1.93 0-3.5-1.57-3.5-3.5s1.57-3.5 3.5-3.5 3.5 1.57 3.5 3.5-1.57 3.5-3.5 3.5z">
        </path>
      </g>
      <g id="star">
        <path
          d="M12 17.27L18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21z">
        </path>
      </g>
      <g id="sync" viewBox="0 -960 960 960">
        <path
          d="M216-192v-72h74q-45-40-71.5-95.5T192-480q0-101 61-177.5T408-758v75q-63 23-103.5 77.5T264-480q0 48 19.5 89t52.5 70v-63h72v192H216Zm336-10v-75q63-23 103.5-77.5T696-480q0-48-19.5-89T624-639v63h-72v-192h192v72h-74q45 40 71.5 95.5T768-480q0 101-61 177.5T552-202Z">
        </path>
      </g>
      <g id="thumbs-down">
        <path
            d="M6 3h11v13l-7 7-1.25-1.25a1.454 1.454 0 0 1-.3-.475c-.067-.2-.1-.392-.1-.575v-.35L9.45 16H3c-.533 0-1-.2-1.4-.6-.4-.4-.6-.867-.6-1.4v-2c0-.117.017-.242.05-.375s.067-.258.1-.375l3-7.05c.15-.333.4-.617.75-.85C5.25 3.117 5.617 3 6 3Zm9 2H6l-3 7v2h9l-1.35 5.5L15 15.15V5Zm0 10.15V5v10.15Zm2 .85v-2h3V5h-3V3h5v13h-5Z">
        </path>
      </g>
      <g id="thumbs-down-filled">
        <path
            d="M6 3h10v13l-7 7-1.25-1.25a1.336 1.336 0 0 1-.29-.477 1.66 1.66 0 0 1-.108-.574v-.347L8.449 16H3c-.535 0-1-.2-1.398-.602C1.199 15 1 14.535 1 14v-2c0-.117.012-.242.04-.375.022-.133.062-.258.108-.375l3-7.05c.153-.333.403-.618.75-.848A1.957 1.957 0 0 1 6 3Zm12 13V3h4v13Zm0 0">
        </path>
      </g>
      <g id="thumbs-up">
        <path
            d="M18 21H7V8l7-7 1.25 1.25c.117.117.208.275.275.475.083.2.125.392.125.575v.35L14.55 8H21c.533 0 1 .2 1.4.6.4.4.6.867.6 1.4v2c0 .117-.017.242-.05.375s-.067.258-.1.375l-3 7.05c-.15.333-.4.617-.75.85-.35.233-.717.35-1.1.35Zm-9-2h9l3-7v-2h-9l1.35-5.5L9 8.85V19ZM9 8.85V19 8.85ZM7 8v2H4v9h3v2H2V8h5Z">
        </path>
      </g>
      <g id="thumbs-up-filled">
        <path
            d="M18 21H8V8l7-7 1.25 1.25c.117.117.21.273.29.477.073.199.108.39.108.574v.347L15.551 8H21c.535 0 1 .2 1.398.602C22.801 9 23 9.465 23 10v2c0 .117-.012.242-.04.375a1.897 1.897 0 0 1-.108.375l-3 7.05a2.037 2.037 0 0 1-.75.848A1.957 1.957 0 0 1 18 21ZM6 8v13H2V8Zm0 0">
      </g>
      <g id="videocam" viewBox="0 -960 960 960">
        <path
          d="M216-192q-29 0-50.5-21.5T144-264v-432q0-29.7 21.5-50.85Q187-768 216-768h432q29.7 0 50.85 21.15Q720-725.7 720-696v168l144-144v384L720-432v168q0 29-21.15 50.5T648-192H216Zm0-72h432v-432H216v432Zm0 0v-432 432Z">
        </path>
      </g>
      <g id="warning">
        <path d="M1 21h22L12 2 1 21zm12-3h-2v-2h2v2zm0-4h-2v-4h2v4z"></path>
      </g>
    </defs>
  </svg>
</cr-iconset>`;const iconsets=div.querySelectorAll("cr-iconset");for(const iconset of iconsets){document.head.appendChild(iconset)}
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
let hideInk=false;document.addEventListener("pointerdown",(function(){hideInk=true}),true);document.addEventListener("keydown",(function(){hideInk=false}),true);function focusWithoutInk(toFocus){if(!("noink"in toFocus)||!hideInk){toFocus.focus();return}const toFocusWithNoInk=toFocus;assert(document===toFocusWithNoInk.ownerDocument);const{noink:noink}=toFocusWithNoInk;toFocusWithNoInk.noink=true;toFocusWithNoInk.focus();toFocusWithNoInk.noink=noink}let instance$2=null;function getCss$1(){return instance$2||(instance$2=[...[],css`:host{align-items:center;align-self:stretch;display:flex;margin:0;outline:none}:host(:not([effectively-disabled_])){cursor:pointer}:host(:not([no-hover],[effectively-disabled_]):hover){background-color:var(--cr-hover-background-color)}:host(:not([no-hover],[effectively-disabled_]):active){background-color:var(--cr-active-background-color)}:host(:not([no-hover],[effectively-disabled_])) cr-icon-button{--cr-icon-button-hover-background-color:transparent;--cr-icon-button-active-background-color:transparent}`])}let instance$1=null;function getCss(){return instance$1||(instance$1=[...[getCss$1()],css`:host([disabled]){opacity:0.65;pointer-events:none}:host([disabled]) cr-icon-button{display:var(--cr-expand-button-disabled-display,initial)}#label{flex:1;padding:var(--cr-section-vertical-padding) 0}cr-icon-button{--cr-icon-button-icon-size:var(--cr-expand-button-icon-size,20px);--cr-icon-button-size:var(--cr-expand-button-size,36px)}`])}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml(){return html`
<div id="label" aria-hidden="true"><slot></slot></div>
<cr-icon-button id="icon" aria-labelledby="label" ?disabled="${this.disabled}"
    aria-expanded="${this.getAriaExpanded_()}"
    tabindex="${this.tabIndex}" part="icon" iron-icon="${this.getIcon_()}">
</cr-icon-button>`}
// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class CrExpandButtonElement extends CrLitElement{static get is(){return"cr-expand-button"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{expanded:{type:Boolean,notify:true},disabled:{type:Boolean,reflect:true},ariaLabel:{type:String},tabIndex:{type:Number},expandIcon:{type:String},collapseIcon:{type:String},expandTitle:{type:String},collapseTitle:{type:String}}}#expanded_accessor_storage=false;get expanded(){return this.#expanded_accessor_storage}set expanded(value){this.#expanded_accessor_storage=value}#disabled_accessor_storage=false;get disabled(){return this.#disabled_accessor_storage}set disabled(value){this.#disabled_accessor_storage=value}#expandIcon_accessor_storage="cr:expand-more";get expandIcon(){return this.#expandIcon_accessor_storage}set expandIcon(value){this.#expandIcon_accessor_storage=value}#collapseIcon_accessor_storage="cr:expand-less";get collapseIcon(){return this.#collapseIcon_accessor_storage}set collapseIcon(value){this.#collapseIcon_accessor_storage=value}#expandTitle_accessor_storage;get expandTitle(){return this.#expandTitle_accessor_storage}set expandTitle(value){this.#expandTitle_accessor_storage=value}#collapseTitle_accessor_storage;get collapseTitle(){return this.#collapseTitle_accessor_storage}set collapseTitle(value){this.#collapseTitle_accessor_storage=value}#tabIndex_accessor_storage=0;get tabIndex(){return this.#tabIndex_accessor_storage}set tabIndex(value){this.#tabIndex_accessor_storage=value}firstUpdated(){this.addEventListener("click",this.toggleExpand_)}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("expanded")||changedProperties.has("collapseTitle")||changedProperties.has("expandTitle")){this.title=(this.expanded?this.collapseTitle:this.expandTitle)||""}}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("ariaLabel")){this.onAriaLabelChange_()}}focus(){this.$.icon.focus()}getIcon_(){return this.expanded?this.collapseIcon:this.expandIcon}getAriaExpanded_(){return this.expanded?"true":"false"}onAriaLabelChange_(){if(this.ariaLabel){this.$.icon.removeAttribute("aria-labelledby");this.$.icon.setAttribute("aria-label",this.ariaLabel)}else{this.$.icon.removeAttribute("aria-label");this.$.icon.setAttribute("aria-labelledby","label")}}toggleExpand_(event){event.stopPropagation();event.preventDefault();this.scrollIntoViewIfNeeded();this.expanded=!this.expanded;focusWithoutInk(this.$.icon)}}customElements.define(CrExpandButtonElement.is,CrExpandButtonElement);function getTemplate$j(){return html$1`<!--_html_template_start_--><style include="cr-hidden-style print-preview-shared">:host{border-top:var(--print-preview-settings-border);display:block}:host([disabled]){pointer-events:none}div{align-items:center;display:flex;font:inherit;margin:0;min-height:48px}:host cr-expand-button{flex:1;padding-inline-end:calc(var(--print-preview-sidebar-margin) + 6px);padding-inline-start:var(--print-preview-sidebar-margin);--cr-expand-button-size:28px}:host([hidden]){display:none}:host([disabled]) #label{opacity:var(--cr-disabled-opacity)}</style>
<div on-click="toggleExpandButton_" actionable>
  <cr-expand-button aria-label="$i18n{moreOptionsLabel}"
      expanded="{{settingsExpandedByUser}}" disabled="[[disabled]]">
    <div id="label">$i18n{moreOptionsLabel}</div>
  </cr-expand-button>
</div>
<!--_html_template_end_-->`}
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class PrintPreviewMoreSettingsElement extends PolymerElement{constructor(){super(...arguments);this.metrics_=MetricsContext.printSettingsUi()}static get is(){return"print-preview-more-settings"}static get template(){return getTemplate$j()}static get properties(){return{settingsExpandedByUser:{type:Boolean,notify:true},disabled:{type:Boolean,reflectToAttribute:true}}}toggleExpandButton_(e){const expandButtonTag="CR-EXPAND-BUTTON";if(e.target.tagName===expandButtonTag){return}if(!e.currentTarget.hasAttribute("actionable")){return}const expandButton=e.currentTarget.querySelector(expandButtonTag);assert(expandButton);expandButton.expanded=!expandButton.expanded;this.metrics_.record(this.settingsExpandedByUser?PrintSettingsUiBucket.MORE_SETTINGS_CLICKED:PrintSettingsUiBucket.LESS_SETTINGS_CLICKED)}}customElements.define(PrintPreviewMoreSettingsElement.is,PrintPreviewMoreSettingsElement);function getTemplate$i(){return html$1`<!--_html_template_start_--><style include="print-preview-shared cr-hidden-style">print-preview-settings-section:not(.first-visible) .title{display:none}</style>
<template is="dom-repeat" items="[[options_]]">
  <print-preview-settings-section hidden$="[[!item.available]]"
      class$="[[getClass_(index, firstIndex_)]]">
    <div slot="title">
      <span class="title">$i18n{optionsLabel}</span>
    </div>
    <div slot="controls" class="checkbox">
      <cr-checkbox id$="[[item.name]]"
          disabled$="[[getDisabled_(item.managed, disabled)]]"
          on-change="onChange_" checked$="[[item.value]]">
        <span>[[i18n(item.label)]]</span>
      </cr-checkbox>
    </div>
  </print-preview-settings-section>
</template>
<!--_html_template_end_-->`}
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PrintPreviewOtherOptionsSettingsElementBase=SettingsMixin(I18nMixin(PolymerElement));class PrintPreviewOtherOptionsSettingsElement extends PrintPreviewOtherOptionsSettingsElementBase{constructor(){super(...arguments);this.timeouts_=new Map;this.previousValues_=new Map}static get is(){return"print-preview-other-options-settings"}static get template(){return getTemplate$i()}static get properties(){return{disabled:Boolean,options_:{type:Array,value(){return[{name:"headerFooter",label:"optionHeaderFooter"},{name:"cssBackground",label:"optionBackgroundColorsAndImages"},{name:"rasterize",label:"optionRasterize"},{name:"selectionOnly",label:"optionSelectionOnly"}]}},firstIndex_:{type:Number,value:0}}}static get observers(){return["onHeaderFooterSettingChange_(settings.headerFooter.*)","onCssBackgroundSettingChange_(settings.cssBackground.*)","onRasterizeSettingChange_(settings.rasterize.*)","onSelectionOnlySettingChange_(settings.selectionOnly.*)"]}updateSettingWithTimeout_(settingName,newValue){const timeout=this.timeouts_.get(settingName);if(timeout!==null){clearTimeout(timeout)}this.timeouts_.set(settingName,setTimeout((()=>{this.timeouts_.delete(settingName);if(this.previousValues_.get(settingName)===newValue){return}this.previousValues_.set(settingName,newValue);this.setSetting(settingName,newValue);this.dispatchEvent(new CustomEvent("update-checkbox-setting",{bubbles:true,composed:true,detail:settingName}))}),200))}updateOptionFromSetting_(index){const setting=this.getSetting(this.options_[index].name);this.set(`options_.${index}.available`,setting.available);this.set(`options_.${index}.value`,setting.value);this.set(`options_.${index}.managed`,setting.setByGlobalPolicy);const availableOptions=this.options_.filter((option=>!!option.available));if(availableOptions.length>0){this.firstIndex_=this.options_.indexOf(availableOptions[0])}}getDisabled_(managed,disabled){return managed||disabled}onHeaderFooterSettingChange_(){this.updateOptionFromSetting_(0)}onCssBackgroundSettingChange_(){this.updateOptionFromSetting_(1)}onRasterizeSettingChange_(){this.updateOptionFromSetting_(2)}onSelectionOnlySettingChange_(){this.updateOptionFromSetting_(3)}onChange_(e){const name=e.model.item.name;this.updateSettingWithTimeout_(name,this.shadowRoot.querySelector(`#${name}`).checked)}getClass_(index){return index===this.firstIndex_?"first-visible":""}}customElements.define(PrintPreviewOtherOptionsSettingsElement.is,PrintPreviewOtherOptionsSettingsElement);function getTemplate$h(){return html$1`<!--_html_template_start_--><style include="print-preview-shared md-select"></style>
<print-preview-settings-section>
  <span id="pages-per-sheet-label" slot="title">$i18n{pagesPerSheetLabel}
  </span>
  <div slot="controls">
    <select class="md-select" aria-labelledby="pages-per-sheet-label"
        disabled$="[[disabled]]" value="[[selectedValue]]"
        on-change="onSelectChange">
      <option value="1" selected>1</option>
      <option value="2">2</option>
      <option value="4">4</option>
      <option value="6">6</option>
      <option value="9">9</option>
      <option value="16">16</option>
    </select>
  </div>
</print-preview-settings-section>
<!--_html_template_end_-->`}
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PrintPreviewPagesPerSheetSettingsElementBase=SettingsMixin(SelectMixin(PolymerElement));class PrintPreviewPagesPerSheetSettingsElement extends PrintPreviewPagesPerSheetSettingsElementBase{static get is(){return"print-preview-pages-per-sheet-settings"}static get template(){return getTemplate$h()}static get properties(){return{disabled:Boolean}}static get observers(){return["onPagesPerSheetSettingChange_(settings.pagesPerSheet.value)"]}onPagesPerSheetSettingChange_(newValue){this.selectedValue=newValue.toString()}onProcessSelectChange(value){this.setSetting("pagesPerSheet",parseInt(value,10))}}customElements.define(PrintPreviewPagesPerSheetSettingsElement.is,PrintPreviewPagesPerSheetSettingsElement);function getTemplate$g(){return html$1`<!--_html_template_start_--><style include="print-preview-shared md-select">:host([error-state_='0']) #pageSettingsCustomInput,:host([error-state_='3']) #pageSettingsCustomInput{--cr-input-error-display:none}:host([error-state_='1']) #customInputWrapper,:host([error-state_='2']) #customInputWrapper{margin-bottom:8px}#pageSettingsCustomInput{cursor:default;--cr-form-field-label-height:100%}:host #title{align-self:baseline}</style>
<print-preview-settings-section>
  <span slot="title" id="pages-label">$i18n{pagesLabel}</span>
  <div slot="controls">
    <select class="md-select" aria-labelledby="pages-label"
        disabled$="[[controlsDisabled_]]" value="[[selectedValue]]"
        on-change="onSelectChange" on-blur="onSelectBlur_">
      <option value="[[pagesValueEnum_.ALL]]" selected>
        $i18n{optionAllPages}
      </option>
      <option value="[[pagesValueEnum_.ODDS]]"
          hidden$="[[isSinglePage_(pageCount)]]">
        $i18n{optionOddPages}
      </option>
      <option value="[[pagesValueEnum_.EVENS]]"
          hidden$="[[isSinglePage_(pageCount)]]">
        $i18n{optionEvenPages}
      </option>
      <option value="[[pagesValueEnum_.CUSTOM]]">
        $i18n{optionCustomPages}
      </option>
    </select>
  </div>
</print-preview-settings-section>
<cr-collapse opened="[[shouldShowInput_(selection_)]]"
  on-transitionend="onCollapseChanged_">
  <print-preview-settings-section id="customInputWrapper">
    <div slot="title"></div>
    <div slot="controls">
      <cr-input id="pageSettingsCustomInput" class="stroked" type="text"
          data-timeout-delay="500" invalid="[[hasError_]]"
          disabled$="[[inputDisabled_(controlsDisabled_, selection_)]]"
          spellcheck="false" placeholder="$i18n{examplePageRangeText}"
          error-message="[[getHintMessage_(errorState_, pageCount)]]"
          on-blur="onCustomInputBlur_">
      </cr-input>
    </div>
  </print-preview-settings-section>
</cr-collapse>
<!--_html_template_end_-->`}
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var PagesInputErrorState;(function(PagesInputErrorState){PagesInputErrorState[PagesInputErrorState["NO_ERROR"]=0]="NO_ERROR";PagesInputErrorState[PagesInputErrorState["INVALID_SYNTAX"]=1]="INVALID_SYNTAX";PagesInputErrorState[PagesInputErrorState["OUT_OF_BOUNDS"]=2]="OUT_OF_BOUNDS";PagesInputErrorState[PagesInputErrorState["EMPTY"]=3]="EMPTY"})(PagesInputErrorState||(PagesInputErrorState={}));var PagesValue;(function(PagesValue){PagesValue[PagesValue["ALL"]=0]="ALL";PagesValue[PagesValue["ODDS"]=1]="ODDS";PagesValue[PagesValue["EVENS"]=2]="EVENS";PagesValue[PagesValue["CUSTOM"]=3]="CUSTOM"})(PagesValue||(PagesValue={}));function parseIntStrict(value){if(/^\d+$/.test(value.trim())){return Number(value)}return NaN}const PrintPreviewPagesSettingsElementBase=WebUiListenerMixin(InputMixin(SettingsMixin(SelectMixin(PolymerElement))));class PrintPreviewPagesSettingsElement extends PrintPreviewPagesSettingsElementBase{constructor(){super(...arguments);this.restoreLastInput_=true;this.restorationValue_=PagesValue.ALL}static get is(){return"print-preview-pages-settings"}static get template(){return getTemplate$g()}static get properties(){return{disabled:Boolean,pageCount:{type:Number,observer:"onPageCountChange_"},controlsDisabled_:{type:Boolean,computed:"computeControlsDisabled_(disabled, hasError_)"},errorState_:{type:Number,reflectToAttribute:true,value:PagesInputErrorState.NO_ERROR},hasError_:{type:Boolean,value:false},inputString_:{type:String,value:""},pagesToPrint_:{type:Array,value(){return[]}},rangesToPrint_:{type:Array,computed:"computeRangesToPrint_(pagesToPrint_)"},selection_:{type:Number,value:PagesValue.ALL,observer:"onSelectionChange_"},pagesValueEnum_:{type:Object,value:PagesValue}}}static get observers(){return["updatePagesToPrint_(inputString_)","onRangeChange_(errorState_, rangesToPrint_, settings.pages, "+"settings.pagesPerSheet.value)"]}ready(){super.ready();this.addEventListener("input-change",(e=>this.onInputChange_(e)))}connectedCallback(){super.connectedCallback();this.selectedValue=PagesValue.ALL.toString()}getInput(){return this.$.pageSettingsCustomInput}setSelectedValue_(value){this.selectedValue=value.toString();this.shadowRoot.querySelector("select").dispatchEvent(new CustomEvent("change",{bubbles:true,composed:true}))}onInputChange_(e){if(this.inputString_!==e.detail){this.restoreLastInput_=true}this.inputString_=e.detail}onProcessSelectChange(value){this.selection_=parseInt(value,10)}onCollapseChanged_(){if(this.selection_===PagesValue.CUSTOM){this.$.pageSettingsCustomInput.inputElement.focus()}}computeControlsDisabled_(){return!this.hasError_&&this.disabled}updatePagesToPrint_(){if(this.selection_!==PagesValue.CUSTOM){this.errorState_=PagesInputErrorState.NO_ERROR;if(!this.pageCount){this.pagesToPrint_=[];return}const first=this.selection_===PagesValue.EVENS?2:1;const step=this.selection_===PagesValue.ALL?1:2;assert(first===1||this.pageCount!==1);const length=Math.floor(1+(this.pageCount-first)/step);this.pagesToPrint_=Array.from({length:length},((_,i)=>step*i+first));return}else if(this.inputString_===""){this.errorState_=PagesInputErrorState.EMPTY;return}const pages=[];const added={};const ranges=this.inputString_.split(/,|\u3001/);const maxPage=this.pageCount;for(const range of ranges){if(range===""){this.errorState_=PagesInputErrorState.INVALID_SYNTAX;this.onRangeChange_();return}const limits=range.split("-");if(limits.length>2){this.errorState_=PagesInputErrorState.INVALID_SYNTAX;this.onRangeChange_();return}let min=parseIntStrict(limits[0]);if(limits[0].length>0&&Number.isNaN(min)||min<1){this.errorState_=PagesInputErrorState.INVALID_SYNTAX;this.onRangeChange_();return}if(limits.length===1){if(min>maxPage){this.errorState_=PagesInputErrorState.OUT_OF_BOUNDS;this.onRangeChange_();return}if(!added.hasOwnProperty(min)){pages.push(min);added[min]=true}continue}let max=parseIntStrict(limits[1]);if(Number.isNaN(max)&&limits[1].length>0){this.errorState_=PagesInputErrorState.INVALID_SYNTAX;this.onRangeChange_();return}if(Number.isNaN(min)){min=1}if(Number.isNaN(max)){max=maxPage}if(min>max){this.errorState_=PagesInputErrorState.INVALID_SYNTAX;this.onRangeChange_();return}if(max>maxPage){this.errorState_=PagesInputErrorState.OUT_OF_BOUNDS;this.onRangeChange_();return}for(let i=min;i<=max;i++){if(!added.hasOwnProperty(i)){pages.push(i);added[i]=true}}}pages.sort(((left,right)=>left-right));this.errorState_=PagesInputErrorState.NO_ERROR;this.pagesToPrint_=pages}computeRangesToPrint_(){if(!this.pagesToPrint_||this.pagesToPrint_.length===0||this.pagesToPrint_[0]===-1||this.pagesToPrint_.length===this.pageCount){return[]}let from=this.pagesToPrint_[0];let to=this.pagesToPrint_[0];const ranges=[];for(const page of this.pagesToPrint_.slice(1)){if(page===to+1){to=page;continue}ranges.push({from:from,to:to});from=page;to=page}ranges.push({from:from,to:to});return ranges}getNupPages_(){const pagesPerSheet=this.getSettingValue("pagesPerSheet");if(pagesPerSheet<=1||this.pagesToPrint_.length===0){return this.pagesToPrint_}const numPages=Math.ceil(this.pagesToPrint_.length/pagesPerSheet);const nupPages=new Array(numPages);for(let i=0;i<nupPages.length;i++){nupPages[i]=i+1}return nupPages}onRangeChange_(){if(this.settings===undefined||this.pagesToPrint_===undefined){return}if(this.errorState_===PagesInputErrorState.EMPTY){this.setSettingValid("pages",true);this.hasError_=false;return}if(this.errorState_!==PagesInputErrorState.NO_ERROR){this.hasError_=true;this.setSettingValid("pages",false);return}const nupPages=this.getNupPages_();const rangesChanged=!areRangesEqual(this.rangesToPrint_,this.getSettingValue("ranges"));if(rangesChanged||nupPages.length!==this.getSettingValue("pages").length){this.setSetting("pages",nupPages)}if(rangesChanged){this.setSetting("ranges",this.rangesToPrint_)}this.setSettingValid("pages",true);this.hasError_=false}onSelectBlur_(event){if(this.selection_!==PagesValue.CUSTOM||event.relatedTarget===this.$.pageSettingsCustomInput){return}this.onCustomInputBlur_()}async onCustomInputBlur_(){this.resetAndUpdate();await this.shadowRoot.querySelector("cr-input").updateComplete;if(this.errorState_===PagesInputErrorState.EMPTY){this.shadowRoot.querySelector("cr-input").value=this.getAllPagesString_();this.inputString_=this.getAllPagesString_();this.resetString();this.restoreLastInput_=false}this.dispatchEvent(new CustomEvent("custom-input-blurred-for-test",{bubbles:true,composed:true}))}getHintMessage_(){if(this.errorState_===PagesInputErrorState.NO_ERROR||this.errorState_===PagesInputErrorState.EMPTY){return""}let formattedMessage="";if(this.errorState_===PagesInputErrorState.INVALID_SYNTAX){formattedMessage=loadTimeData.getStringF("pageRangeSyntaxInstruction",loadTimeData.getString("examplePageRangeText"))}else{formattedMessage=loadTimeData.getStringF("pageRangeLimitInstructionWithValue",this.pageCount)}return formattedMessage.replace(/<\/b>|<b>/g,"")}isSinglePage_(){return this.pageCount===1}hintHidden_(){return this.errorState_===PagesInputErrorState.NO_ERROR||this.errorState_===PagesInputErrorState.EMPTY}inputDisabled_(){return this.selection_!==PagesValue.CUSTOM||this.controlsDisabled_}shouldShowInput_(){return this.selection_===PagesValue.CUSTOM}getAllPagesString_(){if(this.pageCount===0){return""}return this.pageCount===1?"1":`1-${this.pageCount}`}onSelectionChange_(){const customSelected=this.selection_===PagesValue.CUSTOM;if(customSelected&&!this.restoreLastInput_||this.errorState_!==PagesInputErrorState.NO_ERROR){this.restoreLastInput_=true;this.inputString_="";this.shadowRoot.querySelector("cr-input").value="";this.resetString()}this.updatePagesToPrint_()}onPageCountChange_(current,previous){if(this.selection_!==PagesValue.CUSTOM){if(current===1){this.restorationValue_=this.selection_;this.setSelectedValue_(PagesValue.ALL)}else if(previous===1){assert(this.restorationValue_!==PagesValue.CUSTOM);this.setSelectedValue_(this.restorationValue_)}}const resetCustom=this.selection_===PagesValue.CUSTOM&&!!this.pagesToPrint_&&this.pagesToPrint_.length===previous&&(current<previous||!this.restoreLastInput_);if(resetCustom){this.shadowRoot.querySelector("cr-input").value=this.getAllPagesString_();this.inputString_=this.getAllPagesString_();this.resetString()}else{this.updatePagesToPrint_()}}}customElements.define(PrintPreviewPagesSettingsElement.is,PrintPreviewPagesSettingsElement);function getTemplate$f(){return html$1`<!--_html_template_start_--><style include="print-preview-shared">:host{margin-top:0 !important}:host([is-pin-valid]) #pinValue{--cr-input-error-display:none}:host(:not([is-pin-valid])) #customInputWrapper{margin-bottom:8px}#pinValue{--cr-form-field-label-height:100%;cursor:default}:host #title{align-self:baseline}</style>
<print-preview-settings-section>
  <div slot="title"></div>
  <div slot="controls" class="checkbox">
    <cr-checkbox id="pin" on-change="onPinChange_"
      disabled="[[checkboxDisabled_]]" aria-labelledby="pin-label">
      <span id="pin-label">$i18n{optionPin}</span>
    </cr-checkbox>
  </div>
</print-preview-settings-section>
<cr-collapse opened="[[pinEnabled_]]"
    on-transitionend="onCollapseChanged_">
  <print-preview-settings-section id="customInputWrapper">
    <div slot="title"></div>
    <div slot="controls">
      <cr-input id="pinValue" type="text" pattern="[0-9]{4}" minlength="4"
          maxlength="4" data-timeout-delay="250" aria-labelledby="pin"
          placeholder="$i18n{pinPlaceholder}" spellcheck="false"
          disabled$="[[inputDisabled_(pinEnabled_, isPinValid, disabled)]]"
          error-message="[[getPinErrorMessage_(isPinValid)]]" required
          auto-validate>
      </cr-input>
    </div>
  </print-preview-settings-section>
</cr-collapse>
<!--_html_template_end_-->`}
// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PrintPreviewPinSettingsElementBase=WebUiListenerMixin(InputMixin(SettingsMixin(I18nMixin(PolymerElement))));class PrintPreviewPinSettingsElement extends PrintPreviewPinSettingsElementBase{static get is(){return"print-preview-pin-settings"}static get template(){return getTemplate$f()}static get properties(){return{state:Number,disabled:Boolean,checkboxDisabled_:{type:Boolean,computed:"computeCheckboxDisabled_(inputValid_, disabled, "+"settings.pin.setByGlobalPolicy)"},pinEnabled_:{type:Boolean,value:false},inputString_:{type:String,value:"",observer:"onInputChanged_"},isPinValid:{type:Boolean,reflectToAttribute:true,notify:true}}}static get observers(){return["onSettingsChanged_(settings.pin.value, settings.pinValue.value)","changePinValueSetting_(state)"]}ready(){super.ready();this.addEventListener("input-change",(e=>this.onInputChange_(e)))}getInput(){return this.$.pinValue}onInputChange_(e){this.inputString_=e.detail}onCollapseChanged_(){if(this.pinEnabled_){this.$.pinValue.focusInput()}}computeCheckboxDisabled_(inputValid,disabled,managed){return managed||inputValid&&disabled}inputDisabled_(){return!this.pinEnabled_||this.isPinValid&&this.disabled}onSettingsChanged_(){const pinEnabled=this.getSetting("pin").value;this.$.pin.checked=pinEnabled;this.pinEnabled_=pinEnabled;const pinValue=this.getSetting("pinValue");this.inputString_=pinValue.value;this.resetString()}onPinChange_(){this.setSetting("pin",this.$.pin.checked);if(!this.$.pin.checked){this.isPinValid=true}else{this.changePinValueSetting_()}}onInputChanged_(){this.changePinValueSetting_()}changePinValueSetting_(){if(this.settings===undefined){return}if(!this.settings.pinValue.available){return}if(this.state!==State.READY&&this.settings.pinValue.valid){return}this.isPinValid=this.computeValid_();if((this.isPinValid||this.inputString_==="")&&this.inputString_!==this.getSettingValue("pinValue")){this.setSetting("pinValue",this.inputString_)}}computeValid_(){this.$.pinValue.value=this.inputString_;return this.$.pinValue.validate()}getPinErrorMessage_(){return this.isPinValid?"":this.i18n("pinErrorMessage")}}customElements.define(PrintPreviewPinSettingsElement.is,PrintPreviewPinSettingsElement);function getTemplate$e(){return html$1`<!--_html_template_start_--><style include="print-preview-shared md-select"></style>
<print-preview-settings-section>
  <span slot="title" id="scaling-label">$i18n{scalingLabel}</span>
  <div slot="controls">
    <select class="md-select" aria-labelledby="scaling-label"
        disabled$="[[dropdownDisabled_]]" value="[[selectedValue]]"
        on-change="onSelectChange">
      <option value="[[scalingTypeEnum_.DEFAULT]]">
        $i18n{optionDefaultScaling}
      </option>
      <option value="[[scalingTypeEnum_.FIT_TO_PAGE]]" hidden$="[[!isPdf]]"
          disabled$="[[!isPdf]]">
        $i18n{optionFitToPage}
      </option>
      <option value="[[scalingTypeEnum_.FIT_TO_PAPER]]" hidden$="[[!isPdf]]"
          disabled$="[[!isPdf]]">
        $i18n{optionFitToPaper}
      </option>
      <option value="[[scalingTypeEnum_.CUSTOM]]">
        $i18n{optionCustomScaling}
      </option>
    </select>
  </div>
</print-preview-settings-section>
<cr-collapse opened="[[customSelected_]]"
    on-transitionend="onCollapseChanged_">
  <print-preview-number-settings-section
      max-value="200" min-value="10" default-value="100"
      disabled$="[[inputDisabled_(dropdownDisabled_, customSelected_)]]"
      current-value="{{currentValue_}}" input-valid="{{inputValid_}}"
      hint-message="$i18n{scalingInstruction}">
  </print-preview-number-settings-section>
</cr-collapse>
<!--_html_template_end_-->`}
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PrintPreviewScalingSettingsElementBase=SettingsMixin(SelectMixin(PolymerElement));class PrintPreviewScalingSettingsElement extends PrintPreviewScalingSettingsElementBase{constructor(){super(...arguments);this.lastValidScaling_="";this.customScalingSettingSet_=false;this.userSelectedCustomScaling_=false}static get is(){return"print-preview-scaling-settings"}static get template(){return getTemplate$e()}static get properties(){return{disabled:{type:Boolean,observer:"onDisabledChanged_"},isPdf:Boolean,currentValue_:{type:String},customSelected_:{type:Boolean,computed:"computeCustomSelected_(settingKey_, "+"settings.scalingType.*, settings.scalingTypePdf.*)"},inputValid_:Boolean,dropdownDisabled_:{type:Boolean,value:false},settingKey_:{type:String,computed:"computeSettingKey_(isPdf)"},scalingTypeEnum_:{type:Object,value:ScalingType}}}static get observers(){return["onScalingTypeSettingChanged_(settingKey_, settings.scalingType.value, "+"settings.scalingTypePdf.value)","onScalingSettingChanged_(settings.scaling.value)","onInputFieldChanged_(inputValid_, currentValue_)"]}onProcessSelectChange(value){const isCustom=value===ScalingType.CUSTOM.toString();if(isCustom&&!this.customScalingSettingSet_){this.userSelectedCustomScaling_=true}else{this.customScalingSettingSet_=false}const valueAsNumber=parseInt(value,10);if(isCustom||value===ScalingType.DEFAULT.toString()){this.setSetting("scalingType",valueAsNumber)}if(this.isPdf||this.getSetting("scalingTypePdf").value===ScalingType.DEFAULT||this.getSetting("scalingTypePdf").value===ScalingType.CUSTOM){this.setSetting("scalingTypePdf",valueAsNumber)}if(isCustom){this.setSetting("scaling",this.currentValue_)}}updateScalingToValid_(){if(!this.getSetting("scaling").valid){this.currentValue_=this.lastValidScaling_}else{this.lastValidScaling_=this.currentValue_}}onScalingSettingChanged_(){const value=this.getSetting("scaling").value;this.lastValidScaling_=value;this.currentValue_=value}onScalingTypeSettingChanged_(){if(!this.settingKey_){return}const value=this.getSettingValue(this.settingKey_);if(value!==ScalingType.CUSTOM){this.updateScalingToValid_()}else{this.customScalingSettingSet_=true}this.selectedValue=value.toString()}onInputFieldChanged_(){this.setSettingValid("scaling",this.inputValid_);if(this.currentValue_!==undefined&&this.currentValue_!==""&&this.inputValid_&&this.currentValue_!==this.getSettingValue("scaling")){this.setSetting("scaling",this.currentValue_)}}onDisabledChanged_(){this.dropdownDisabled_=this.disabled&&this.inputValid_}inputDisabled_(){return!this.customSelected_||this.dropdownDisabled_}computeCustomSelected_(){return!!this.settingKey_&&this.getSettingValue(this.settingKey_)===ScalingType.CUSTOM}computeSettingKey_(){return this.isPdf?"scalingTypePdf":"scalingType"}onCollapseChanged_(){if(this.customSelected_&&this.userSelectedCustomScaling_){this.shadowRoot.querySelector("print-preview-number-settings-section").getInput().focus()}this.customScalingSettingSet_=false;this.userSelectedCustomScaling_=false}}customElements.define(PrintPreviewScalingSettingsElement.is,PrintPreviewScalingSettingsElement);
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CrScrollObserverMixin=dedupingMixin((superClass=>{class CrScrollObserverMixin extends superClass{intersectionObserver_=null;topProbe_=null;bottomProbe_=null;connectedCallback(){super.connectedCallback();const container=this.getContainer();this.topProbe_=document.createElement("div");this.bottomProbe_=document.createElement("div");container.prepend(this.topProbe_);container.append(this.bottomProbe_);this.enableScrollObservation(true)}disconnectedCallback(){super.disconnectedCallback();this.enableScrollObservation(false)}getContainer(){const container=this.shadowRoot.querySelector("#container");assert(container);return container}getIntersectionObserver_(){const callback=entries=>{const container=this.getContainer();for(const entry of entries){const target=entry.target;if(target===this.topProbe_){container.classList.toggle("scrolled-to-top",entry.intersectionRatio!==0);const canScroll=entry.intersectionRatio===0||!container.classList.contains("scrolled-to-bottom");container.classList.toggle("can-scroll",canScroll)}if(target===this.bottomProbe_){container.classList.toggle("scrolled-to-bottom",entry.intersectionRatio!==0);const canScroll=entry.intersectionRatio===0||!container.classList.contains("scrolled-to-top");container.classList.toggle("can-scroll",canScroll)}}};return new IntersectionObserver(callback,{root:this.getContainer(),threshold:0})}enableScrollObservation(enable){if(enable===!!this.intersectionObserver_){return}if(!enable){this.intersectionObserver_.disconnect();this.intersectionObserver_=null;return}this.intersectionObserver_=this.getIntersectionObserver_();window.setTimeout((()=>{if(!this.isConnected){return}if(this.intersectionObserver_){assert(this.topProbe_);assert(this.bottomProbe_);this.intersectionObserver_.observe(this.topProbe_);this.intersectionObserver_.observe(this.bottomProbe_)}}))}}return CrScrollObserverMixin}));
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var CrContainerShadowSide;(function(CrContainerShadowSide){CrContainerShadowSide["TOP"]="top";CrContainerShadowSide["BOTTOM"]="bottom"})(CrContainerShadowSide||(CrContainerShadowSide={}));const CrContainerShadowMixin=dedupingMixin((superClass=>{const superClassBase=CrScrollObserverMixin(superClass);class CrContainerShadowMixin extends superClassBase{dropShadows_=new Map;sides_=[];connectedCallback(){super.connectedCallback();const container=this.shadowRoot.querySelector("#container");assert(container);const hasBottomShadow=container.hasAttribute("show-bottom-shadow");this.sides_=hasBottomShadow?[CrContainerShadowSide.TOP,CrContainerShadowSide.BOTTOM]:[CrContainerShadowSide.TOP];this.sides_.forEach((side=>{const shadow=document.createElement("div");shadow.id=`cr-container-shadow-${side}`;shadow.classList.add("cr-container-shadow");this.dropShadows_.set(side,shadow)}));container.parentNode.insertBefore(this.dropShadows_.get(CrContainerShadowSide.TOP),container);if(hasBottomShadow){container.parentNode.insertBefore(this.dropShadows_.get(CrContainerShadowSide.BOTTOM),container.nextSibling)}}setForceDropShadows(enabled){assert(this.sides_.length>0);for(const side of this.sides_){this.dropShadows_.get(side).classList.toggle("force-shadow",enabled)}}}return CrContainerShadowMixin}));function getTemplate$d(){return html$1`<!--_html_template_start_--><style include="cr-hidden-style cr-shared-style">:host{background-color:white;border-inline-start:var(--print-preview-settings-border);display:flex;flex-direction:column}@media (prefers-color-scheme:dark){:host{background-color:rgba(255,255,255,.04)}}#container{color:var(--cr-primary-text-color);flex:1;overflow:overlay}:host #destinationSettings{margin-top:12px}:host #cr-container-shadow-top,:host #cr-container-shadow-bottom{box-shadow:inset 0 5px 3px -3px rgba(0,0,0,.2)}.settings-section{display:block;margin-bottom:16px;margin-top:16px}</style>
<print-preview-header id="header" destination="[[destination]]"
    error="[[error]]" sheet-count="[[sheetCount_]]" state="[[state]]"
    settings="[[settings]]" managed="[[controlsManaged]]">
</print-preview-header>
<div id="container" show-bottom-shadow>
  <print-preview-destination-settings id="destinationSettings"
      dark="[[inDarkMode]]" destination="{{destination}}"
      destination-state="{{destinationState}}"
      error="{{error}}" first-load="[[firstLoad_]]" settings="[[settings]]"
      state="[[state]]" app-kiosk-mode="[[isInAppKioskMode_]]"
      disabled="[[controlsDisabled_]]"
      available class="settings-section">
  </print-preview-destination-settings>

  <print-preview-pin-settings state="[[state]]" settings="[[settings]]"
      disabled="[[controlsDisabled_]]" is-pin-valid="{{isPinValid_}}"
      hidden$="[[!settings.pin.available]]" class="settings-section">
  </print-preview-pin-settings>

  <print-preview-pages-settings settings="[[settings]]"
      page-count="[[pageCount]]" disabled="[[controlsDisabled_]]"
      hidden$="[[!settings.pages.available]]" class="settings-section">
  </print-preview-pages-settings>
  <print-preview-copies-settings settings="[[settings]]"
      capability="[[destination.capabilities.printer.copies]]"
      disabled="[[controlsDisabled_]]"
      hidden$="[[!settings.copies.available]]" class="settings-section">
  </print-preview-copies-settings>
  <print-preview-layout-settings settings="[[settings]]"
      disabled="[[controlsDisabled_]]"
      hidden$="[[!settings.layout.available]]" class="settings-section">
  </print-preview-layout-settings>
  <print-preview-color-settings settings="[[settings]]"
      disabled="[[controlsDisabled_]]"
      hidden$="[[hideSetting_(
          settings.color.available,
          destination.allowedManagedPrintOptionsApplied.color)]]"
      class="settings-section">
  </print-preview-color-settings>
  <print-preview-more-settings
      settings-expanded-by-user="{{settingsExpandedByUser_}}"
      disabled="[[controlsDisabled_]]"
      hidden$="[[!shouldShowMoreSettings_]]">
  </print-preview-more-settings>
  <cr-collapse id="moreSettings"
      opened="[[shouldExpandSettings_(
          settingsExpandedByUser_, shouldShowMoreSettings_)]]">
    <print-preview-media-size-settings settings="[[settings]]"
        capability="[[destination.capabilities.printer.media_size]]"
        disabled="[[controlsDisabled_]]"
        hidden$="[[hideSetting_(
            settings.mediaSize.available,
            destination.allowedManagedPrintOptionsApplied.mediaSize)]]"
        class="settings-section">
    </print-preview-media-size-settings>
    <print-preview-media-type-settings settings="[[settings]]" state="[[state]]"
        capability="[[destination.capabilities.printer.media_type]]"
        disabled="[[controlsDisabled_]]"
        hidden$="[[hideSetting_(
            settings.mediaType.available,
            destination.allowedManagedPrintOptionsApplied.mediaType)]]"
        class="settings-section">
    </print-preview-media-type-settings>
    <print-preview-pages-per-sheet-settings settings="[[settings]]"
        disabled="[[controlsDisabled_]]"
        hidden$="[[!settings.pagesPerSheet.available]]"
        class="settings-section">
    </print-preview-pages-per-sheet-settings>
    <print-preview-margins-settings settings="[[settings]]" state="[[state]]"
        disabled="[[controlsDisabled_]]"
        hidden$="[[!settings.margins.available]]"
        class="settings-section">
    </print-preview-margins-settings>
    <print-preview-dpi-settings settings="[[settings]]"
        capability="[[destination.capabilities.printer.dpi]]"
        disabled="[[controlsDisabled_]]"
        hidden$="[[hideSetting_(
            settings.dpi.available,
            destination.allowedManagedPrintOptionsApplied.dpi)]]"
        class="settings-section">
    </print-preview-dpi-settings>
    <print-preview-scaling-settings settings="[[settings]]"
        disabled="[[controlsDisabled_]]" is-pdf="[[isPdf]]"
        hidden$="[[!settings.scaling.available]]"
        class="settings-section">
    </print-preview-scaling-settings>
    <print-preview-duplex-settings settings="[[settings]]"
        disabled="[[controlsDisabled_]]" dark="[[inDarkMode]]"
        allowed-values-applied="[[
            destination.allowedManagedPrintOptionsApplied.duplex]]"
        hidden$="[[hideSetting_(
            settings.duplex.available,
            destination.allowedManagedPrintOptionsApplied.duplex)]]"
        class="settings-section">
    </print-preview-duplex-settings>
    <print-preview-other-options-settings settings="[[settings]]"
        disabled="[[controlsDisabled_]]"
        hidden$="[[!settings.otherOptions.available]]"
        class="settings-section">
    </print-preview-other-options-settings>
    <print-preview-advanced-options-settings
        settings="[[settings]]" destination="[[destination]]"
        disabled="[[controlsDisabled_]]"
        hidden$="[[!settings.vendorItems.available]]"
        class="settings-section">
    </print-preview-advanced-options-settings>

  </cr-collapse>
</div>
<print-preview-button-strip destination="[[destination]]"
    state="[[state]]" first-load="[[firstLoad_]]" is-pin-valid="[[isPinValid_]]"
    sheet-count="[[sheetCount_]]" max-sheets="[[maxSheets]]"
    on-print-button-focused="onPrintButtonFocused_">
</print-preview-button-strip>
<!--_html_template_end_-->`}
// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const MAX_SECTIONS_TO_SHOW=6;const PrintPreviewSidebarElementBase=CrContainerShadowMixin(WebUiListenerMixin(SettingsMixin(DarkModeMixin(PolymerElement))));class PrintPreviewSidebarElement extends PrintPreviewSidebarElementBase{static get is(){return"print-preview-sidebar"}static get template(){return getTemplate$d()}static get properties(){return{controlsManaged:Boolean,destination:{type:Object,notify:true},destinationState:{type:Number,notify:true},error:{type:Number,notify:true},isPdf:Boolean,pageCount:Number,state:{type:Number,observer:"onStateChanged_"},controlsDisabled_:{type:Boolean,computed:"computeControlsDisabled_(state)"},maxSheets:Number,sheetCount_:{type:Number,computed:"computeSheetCount_("+"settings.pages.*, settings.duplex.*, settings.copies.*)"},firstLoad_:{type:Boolean,value:true},isInAppKioskMode_:{type:Boolean,value:false},settingsExpandedByUser_:{type:Boolean,value:false},shouldShowMoreSettings_:{type:Boolean,computed:"computeShouldShowMoreSettings_(settings.pages.available, "+"settings.copies.available, settings.layout.available, "+"settings.color.available, settings.mediaSize.available, "+"settings.dpi.available, settings.margins.available, "+"settings.pagesPerSheet.available, settings.scaling.available, "+"settings.duplex.available, settings.otherOptions.available, "+"settings.vendorItems.available)"},isPinValid_:{type:Boolean,value:true}}}init(appKioskMode,defaultPrinter,serializedDestinationSelectionRulesStr,pdfPrinterDisabled,isDriveMounted){this.isInAppKioskMode_=appKioskMode;pdfPrinterDisabled=this.isInAppKioskMode_||pdfPrinterDisabled;const saveToDriveDisabled=pdfPrinterDisabled||!isDriveMounted;this.$.destinationSettings.init(defaultPrinter,pdfPrinterDisabled,saveToDriveDisabled,serializedDestinationSelectionRulesStr)}computeControlsDisabled_(){return this.state!==State.READY}computeSheetCount_(){let sheets=this.getSettingValue("pages").length;if(this.getSettingValue("duplex")){sheets=Math.ceil(sheets/2)}return sheets*this.getSettingValue("copies")}computeShouldShowMoreSettings_(){const keys=["pages","copies","layout","color","mediaSize","margins","color","pagesPerSheet","scaling","dpi","duplex","otherOptions","vendorItems"];return keys.reduce(((count,setting)=>this.getSetting(setting).available?count+1:count),1)>MAX_SECTIONS_TO_SHOW}shouldExpandSettings_(){if(this.settingsExpandedByUser_===undefined||this.shouldShowMoreSettings_===undefined){return false}return this.settingsExpandedByUser_||!this.shouldShowMoreSettings_}onPrintButtonFocused_(){this.firstLoad_=false}onStateChanged_(){if(this.state!==State.PRINTING){return}if(this.shouldShowMoreSettings_){MetricsContext.printSettingsUi().record(this.settingsExpandedByUser_?PrintSettingsUiBucket.PRINT_WITH_SETTINGS_EXPANDED:PrintSettingsUiBucket.PRINT_WITH_SETTINGS_COLLAPSED)}}printerExistsInDisplayedDestinations(){return this.$.destinationSettings.printerExistsInDisplayedDestinations()}hideSetting_(settingAvailable,allowedManagedPrintOptionsApplied){return!settingAvailable&&!allowedManagedPrintOptionsApplied}}customElements.define(PrintPreviewSidebarElement.is,PrintPreviewSidebarElement);
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function hasKeyModifiers(e){return!!(e.altKey||e.ctrlKey||e.metaKey||e.shiftKey)}function getTemplate$c(){return html$1`<!--_html_template_start_--><style>:host{display:flex;height:100%;user-select:none}@media (prefers-color-scheme:dark){:host{background:var(--google-grey-900)}}print-preview-sidebar{flex:none;width:var(--print-preview-sidebar-width)}#preview-area-container{align-items:center;background-color:var(--preview-area-background-color);flex:1}</style>
<print-preview-state id="state" state="{{state}}" error="{{error_}}">
</print-preview-state>
<print-preview-model id="model" settings="{{settings}}"
    settings-managed="{{settingsManaged_}}" destination="[[destination_]]"
    document-settings="[[documentSettings_]]"
    margins="[[margins_]]" page-size="[[pageSize_]]"
    max-sheets="{{maxSheets_}}"
    on-preview-setting-changed="onPreviewSettingChanged_"
    on-sticky-setting-changed="onStickySettingChanged_"
    on-setting-valid-changed="onSettingValidChanged_">
</print-preview-model>
<print-preview-document-info id="documentInfo"
    document-settings="{{documentSettings_}}" margins="{{margins_}}"
    page-size="{{pageSize_}}">
</print-preview-document-info>
<div id="preview-area-container">
  <print-preview-preview-area id="previewArea" settings="[[settings]]"
      destination="[[destination_]]" error="{{error_}}"
      document-modifiable="[[documentSettings_.isModifiable]]"
      margins="[[margins_]]" page-size="[[pageSize_]]" state="[[state]]"
      measurement-system="[[measurementSystem_]]"
      preview-state="{{previewState_}}" on-preview-start="onPreviewStart_">
  </print-preview-preview-area>
</div>
<print-preview-sidebar id="sidebar"
    destination-state="{{destinationState_}}"
    controls-managed="[[controlsManaged_]]" destination="{{destination_}}"
    error="{{error_}}" is-pdf="[[!documentSettings_.isModifiable]]"
    page-count="[[documentSettings_.pageCount]]"
    settings="[[settings]]" state="[[state]]"
    max-sheets="[[maxSheets_]]" on-focus="onSidebarFocus_"


    on-print-requested="onPrintRequested_"
    on-cancel-requested="onCancelRequested_">
</print-preview-sidebar>
<!--_html_template_end_-->`}
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class CrLazyRenderElement extends PolymerElement{static get is(){return"cr-lazy-render"}static get template(){return html$1`<slot></slot>`}child_=null;instance_=null;get(){if(!this.child_){this.render_()}assert(this.child_);return this.child_}getIfExists(){return this.child_}render_(){const template=this.shadowRoot.querySelector("slot").assignedNodes({flatten:true}).filter((n=>n.nodeType===Node.ELEMENT_NODE))[0];const TemplateClass=templatize(template,this,{mutableData:false,forwardHostProp:this._forwardHostPropV2});const parentNode=this.parentNode;if(parentNode&&!this.child_){this.instance_=new TemplateClass;this.child_=this.instance_.root.firstElementChild;parentNode.insertBefore(this.instance_.root,this)}}_forwardHostPropV2(prop,value){if(this.instance_){this.instance_.forwardHostProp(prop,value)}}}customElements.define(CrLazyRenderElement.is,CrLazyRenderElement);const styleMod$4=document.createElement("dom-module");styleMod$4.appendChild(html$1`
  <template>
    <style>
.throbber{background:url(chrome://resources/images/throbber_small.svg) no-repeat;display:inline-block;height:var(--throbber-size);width:var(--throbber-size)}
    </style>
  </template>
`.content);styleMod$4.register("throbber");const styleMod$3=document.createElement("dom-module");styleMod$3.appendChild(html$1`
  <template>
    <style include="print-preview-shared cr-hidden-style throbber">
:host-context([dir=rtl]) #manageIcon{transform:scaleX(-1)}#dialog::part(dialog){height:calc(100vh - 2 * var(--print-preview-dialog-margin));max-width:640px;width:calc(100vw - 2 * var(--print-preview-dialog-margin))}#dialog::part(wrapper){height:calc(100vh - 2 * var(--print-preview-dialog-margin))}#dialog::part(body-container){flex:1}print-preview-search-box{margin-bottom:16px;margin-top:6px}cr-dialog [slot=body]{display:flex;flex-direction:column;height:100%}div[slot='button-container']{justify-content:space-between}cr-button{font-size:calc(12 / 13 * 1em)}.cancel-button{margin-inline-end:0}cr-button cr-icon{--iron-icon-fill-color:currentColor;margin-inline-start:8px}#warning-message{color:var(--cr-primary-text-color)}
    </style>
  </template>
`.content);styleMod$3.register("destination-dialog-style");
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/var KEY_IDENTIFIER={"U+0008":"backspace","U+0009":"tab","U+001B":"esc","U+0020":"space","U+007F":"del"};var KEY_CODE={8:"backspace",9:"tab",13:"enter",27:"esc",33:"pageup",34:"pagedown",35:"end",36:"home",32:"space",37:"left",38:"up",39:"right",40:"down",46:"del",106:"*"};var MODIFIER_KEYS={shift:"shiftKey",ctrl:"ctrlKey",alt:"altKey",meta:"metaKey"};var KEY_CHAR=/[a-z0-9*]/;var IDENT_CHAR=/U\+/;var ARROW_KEY=/^arrow/;var SPACE_KEY=/^space(bar)?/;var ESC_KEY=/^escape$/;function transformKey(key,noSpecialChars){var validKey="";if(key){var lKey=key.toLowerCase();if(lKey===" "||SPACE_KEY.test(lKey)){validKey="space"}else if(ESC_KEY.test(lKey)){validKey="esc"}else if(lKey.length==1){if(!noSpecialChars||KEY_CHAR.test(lKey)){validKey=lKey}}else if(ARROW_KEY.test(lKey)){validKey=lKey.replace("arrow","")}else if(lKey=="multiply"){validKey="*"}else{validKey=lKey}}return validKey}function transformKeyIdentifier(keyIdent){var validKey="";if(keyIdent){if(keyIdent in KEY_IDENTIFIER){validKey=KEY_IDENTIFIER[keyIdent]}else if(IDENT_CHAR.test(keyIdent)){keyIdent=parseInt(keyIdent.replace("U+","0x"),16);validKey=String.fromCharCode(keyIdent).toLowerCase()}else{validKey=keyIdent.toLowerCase()}}return validKey}function transformKeyCode(keyCode){var validKey="";if(Number(keyCode)){if(keyCode>=65&&keyCode<=90){validKey=String.fromCharCode(32+keyCode)}else if(keyCode>=112&&keyCode<=123){validKey="f"+(keyCode-112+1)}else if(keyCode>=48&&keyCode<=57){validKey=String(keyCode-48)}else if(keyCode>=96&&keyCode<=105){validKey=String(keyCode-96)}else{validKey=KEY_CODE[keyCode]}}return validKey}function normalizedKeyForEvent(keyEvent,noSpecialChars){if(keyEvent.key){return transformKey(keyEvent.key,noSpecialChars)}if(keyEvent.detail&&keyEvent.detail.key){return transformKey(keyEvent.detail.key,noSpecialChars)}return transformKeyIdentifier(keyEvent.keyIdentifier)||transformKeyCode(keyEvent.keyCode)||""}function keyComboMatchesEvent(keyCombo,event){var keyEvent=normalizedKeyForEvent(event,keyCombo.hasModifiers);return keyEvent===keyCombo.key&&(!keyCombo.hasModifiers||!!event.shiftKey===!!keyCombo.shiftKey&&!!event.ctrlKey===!!keyCombo.ctrlKey&&!!event.altKey===!!keyCombo.altKey&&!!event.metaKey===!!keyCombo.metaKey)}function parseKeyComboString(keyComboString){if(keyComboString.length===1){return{combo:keyComboString,key:keyComboString,event:"keydown"}}return keyComboString.split("+").reduce((function(parsedKeyCombo,keyComboPart){var eventParts=keyComboPart.split(":");var keyName=eventParts[0];var event=eventParts[1];if(keyName in MODIFIER_KEYS){parsedKeyCombo[MODIFIER_KEYS[keyName]]=true;parsedKeyCombo.hasModifiers=true}else{parsedKeyCombo.key=keyName;parsedKeyCombo.event=event||"keydown"}return parsedKeyCombo}),{combo:keyComboString.split(":").shift()})}function parseEventString(eventString){return eventString.trim().split(" ").map((function(keyComboString){return parseKeyComboString(keyComboString)}))}const IronA11yKeysBehavior={properties:{keyEventTarget:{type:Object,value:function(){return this}},stopKeyboardEventPropagation:{type:Boolean,value:false},_boundKeyHandlers:{type:Array,value:function(){return[]}},_imperativeKeyBindings:{type:Object,value:function(){return{}}}},observers:["_resetKeyEventListeners(keyEventTarget, _boundKeyHandlers)"],keyBindings:{},registered:function(){this._prepKeyBindings()},attached:function(){this._listenKeyEventListeners()},detached:function(){this._unlistenKeyEventListeners()},addOwnKeyBinding:function(eventString,handlerName){this._imperativeKeyBindings[eventString]=handlerName;this._prepKeyBindings();this._resetKeyEventListeners()},removeOwnKeyBindings:function(){this._imperativeKeyBindings={};this._prepKeyBindings();this._resetKeyEventListeners()},keyboardEventMatchesKeys:function(event,eventString){var keyCombos=parseEventString(eventString);for(var i=0;i<keyCombos.length;++i){if(keyComboMatchesEvent(keyCombos[i],event)){return true}}return false},_collectKeyBindings:function(){var keyBindings=this.behaviors.map((function(behavior){return behavior.keyBindings}));if(keyBindings.indexOf(this.keyBindings)===-1){keyBindings.push(this.keyBindings)}return keyBindings},_prepKeyBindings:function(){this._keyBindings={};this._collectKeyBindings().forEach((function(keyBindings){for(var eventString in keyBindings){this._addKeyBinding(eventString,keyBindings[eventString])}}),this);for(var eventString in this._imperativeKeyBindings){this._addKeyBinding(eventString,this._imperativeKeyBindings[eventString])}for(var eventName in this._keyBindings){this._keyBindings[eventName].sort((function(kb1,kb2){var b1=kb1[0].hasModifiers;var b2=kb2[0].hasModifiers;return b1===b2?0:b1?-1:1}))}},_addKeyBinding:function(eventString,handlerName){parseEventString(eventString).forEach((function(keyCombo){this._keyBindings[keyCombo.event]=this._keyBindings[keyCombo.event]||[];this._keyBindings[keyCombo.event].push([keyCombo,handlerName])}),this)},_resetKeyEventListeners:function(){this._unlistenKeyEventListeners();if(this.isAttached){this._listenKeyEventListeners()}},_listenKeyEventListeners:function(){if(!this.keyEventTarget){return}Object.keys(this._keyBindings).forEach((function(eventName){var keyBindings=this._keyBindings[eventName];var boundKeyHandler=this._onKeyBindingEvent.bind(this,keyBindings);this._boundKeyHandlers.push([this.keyEventTarget,eventName,boundKeyHandler]);this.keyEventTarget.addEventListener(eventName,boundKeyHandler)}),this)},_unlistenKeyEventListeners:function(){var keyHandlerTuple;var keyEventTarget;var eventName;var boundKeyHandler;while(this._boundKeyHandlers.length){keyHandlerTuple=this._boundKeyHandlers.pop();keyEventTarget=keyHandlerTuple[0];eventName=keyHandlerTuple[1];boundKeyHandler=keyHandlerTuple[2];keyEventTarget.removeEventListener(eventName,boundKeyHandler)}},_onKeyBindingEvent:function(keyBindings,event){if(this.stopKeyboardEventPropagation){event.stopPropagation()}if(event.defaultPrevented){return}for(var i=0;i<keyBindings.length;i++){var keyCombo=keyBindings[i][0];var handlerName=keyBindings[i][1];if(keyComboMatchesEvent(keyCombo,event)){this._triggerKeyHandler(keyCombo,handlerName,event);if(event.defaultPrevented){return}}}},_triggerKeyHandler:function(keyCombo,handlerName,keyboardEvent){var detail=Object.create(keyCombo);detail.keyboardEvent=keyboardEvent;var event=new CustomEvent(keyCombo.event,{detail:detail,cancelable:true});this[handlerName].call(this,event);if(event.defaultPrevented){keyboardEvent.preventDefault()}}};
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/var ORPHANS=new Set;const IronResizableBehavior={properties:{_parentResizable:{type:Object,observer:"_parentResizableChanged"},_notifyingDescendant:{type:Boolean,value:false}},listeners:{"iron-request-resize-notifications":"_onIronRequestResizeNotifications"},created:function(){this._interestedResizables=[];this._boundNotifyResize=this.notifyResize.bind(this);this._boundOnDescendantIronResize=this._onDescendantIronResize.bind(this)},attached:function(){this._requestResizeNotifications()},detached:function(){if(this._parentResizable){this._parentResizable.stopResizeNotificationsFor(this)}else{ORPHANS.delete(this);window.removeEventListener("resize",this._boundNotifyResize)}this._parentResizable=null},notifyResize:function(){if(!this.isAttached){return}this._interestedResizables.forEach((function(resizable){if(this.resizerShouldNotify(resizable)){this._notifyDescendant(resizable)}}),this);this._fireResize()},assignParentResizable:function(parentResizable){if(this._parentResizable){this._parentResizable.stopResizeNotificationsFor(this)}this._parentResizable=parentResizable;if(parentResizable&&parentResizable._interestedResizables.indexOf(this)===-1){parentResizable._interestedResizables.push(this);parentResizable._subscribeIronResize(this)}},stopResizeNotificationsFor:function(target){var index=this._interestedResizables.indexOf(target);if(index>-1){this._interestedResizables.splice(index,1);this._unsubscribeIronResize(target)}},_subscribeIronResize:function(target){target.addEventListener("iron-resize",this._boundOnDescendantIronResize)},_unsubscribeIronResize:function(target){target.removeEventListener("iron-resize",this._boundOnDescendantIronResize)},resizerShouldNotify:function(element){return true},_onDescendantIronResize:function(event){if(this._notifyingDescendant){event.stopPropagation();return}if(!useShadow){this._fireResize()}},_fireResize:function(){this.fire("iron-resize",null,{node:this,bubbles:false})},_onIronRequestResizeNotifications:function(event){var target=dom(event).rootTarget;if(target===this){return}target.assignParentResizable(this);this._notifyDescendant(target);event.stopPropagation()},_parentResizableChanged:function(parentResizable){if(parentResizable){window.removeEventListener("resize",this._boundNotifyResize)}},_notifyDescendant:function(descendant){if(!this.isAttached){return}this._notifyingDescendant=true;descendant.notifyResize();this._notifyingDescendant=false},_requestResizeNotifications:function(){if(!this.isAttached){return}if(document.readyState==="loading"){var _requestResizeNotifications=this._requestResizeNotifications.bind(this);document.addEventListener("readystatechange",(function readystatechanged(){document.removeEventListener("readystatechange",readystatechanged);_requestResizeNotifications()}))}else{this._findParent();if(!this._parentResizable){ORPHANS.forEach((function(orphan){if(orphan!==this){orphan._findParent()}}),this);window.addEventListener("resize",this._boundNotifyResize);this.notifyResize()}else{this._parentResizable._interestedResizables.forEach((function(resizable){if(resizable!==this){resizable._findParent()}}),this)}}},_findParent:function(){this.assignParentResizable(null);this.fire("iron-request-resize-notifications",null,{node:this,bubbles:true,cancelable:true});if(!this._parentResizable){ORPHANS.add(this)}else{ORPHANS.delete(this)}}};
/**
@license
Copyright (c) 2016 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/const IronScrollTargetBehavior={properties:{scrollTarget:{type:HTMLElement,value:function(){return this._defaultScrollTarget}}},observers:["_scrollTargetChanged(scrollTarget, isAttached)"],_shouldHaveListener:true,_scrollTargetChanged:function(scrollTarget,isAttached){if(this._oldScrollTarget){this._toggleScrollListener(false,this._oldScrollTarget);this._oldScrollTarget=null}if(!isAttached){return}if(scrollTarget==="document"){this.scrollTarget=this._doc}else if(typeof scrollTarget==="string"){var domHost=this.domHost;this.scrollTarget=domHost&&domHost.$?domHost.$[scrollTarget]:dom(this.ownerDocument).querySelector("#"+scrollTarget)}else if(this._isValidScrollTarget()){this._oldScrollTarget=scrollTarget;this._toggleScrollListener(this._shouldHaveListener,scrollTarget)}},_scrollHandler:function scrollHandler(){},get _defaultScrollTarget(){return this._doc},get _doc(){return this.ownerDocument.documentElement},get _scrollTop(){if(this._isValidScrollTarget()){return this.scrollTarget===this._doc?window.pageYOffset:this.scrollTarget.scrollTop}return 0},get _scrollLeft(){if(this._isValidScrollTarget()){return this.scrollTarget===this._doc?window.pageXOffset:this.scrollTarget.scrollLeft}return 0},set _scrollTop(top){if(this.scrollTarget===this._doc){window.scrollTo(window.pageXOffset,top)}else if(this._isValidScrollTarget()){this.scrollTarget.scrollTop=top}},set _scrollLeft(left){if(this.scrollTarget===this._doc){window.scrollTo(left,window.pageYOffset)}else if(this._isValidScrollTarget()){this.scrollTarget.scrollLeft=left}},scroll:function(leftOrOptions,top){var left;if(typeof leftOrOptions==="object"){left=leftOrOptions.left;top=leftOrOptions.top}else{left=leftOrOptions}left=left||0;top=top||0;if(this.scrollTarget===this._doc){window.scrollTo(left,top)}else if(this._isValidScrollTarget()){this.scrollTarget.scrollLeft=left;this.scrollTarget.scrollTop=top}},get _scrollTargetWidth(){if(this._isValidScrollTarget()){return this.scrollTarget===this._doc?window.innerWidth:this.scrollTarget.offsetWidth}return 0},get _scrollTargetHeight(){if(this._isValidScrollTarget()){return this.scrollTarget===this._doc?window.innerHeight:this.scrollTarget.offsetHeight}return 0},_isValidScrollTarget:function(){return this.scrollTarget instanceof HTMLElement},_toggleScrollListener:function(yes,scrollTarget){var eventTarget=scrollTarget===this._doc?window:scrollTarget;if(yes){if(!this._boundScrollHandler){this._boundScrollHandler=this._scrollHandler.bind(this);eventTarget.addEventListener("scroll",this._boundScrollHandler)}}else{if(this._boundScrollHandler){eventTarget.removeEventListener("scroll",this._boundScrollHandler);this._boundScrollHandler=null}}},toggleScrollListener:function(yes){this._shouldHaveListener=yes;this._toggleScrollListener(yes,this.scrollTarget)}};
/**
@license
Copyright (c) 2016 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/var IOS=navigator.userAgent.match(/iP(?:hone|ad;(?: U;)? CPU) OS (\d+)/);var IOS_TOUCH_SCROLLING=IOS&&IOS[1]>=8;var DEFAULT_PHYSICAL_COUNT=3;var HIDDEN_Y="-10000px";var SECRET_TABINDEX=-100;Polymer({_template:html$1`
    <style>
      :host {
        display: block;
      }

      @media only screen and (-webkit-max-device-pixel-ratio: 1) {
        :host {
          will-change: transform;
        }
      }

      #items {
        position: relative;
      }

      :host(:not([grid])) #items > ::slotted(*) {
        width: 100%;
      }

      #items > ::slotted(*) {
        box-sizing: border-box;
        margin: 0;
        position: absolute;
        top: 0;
        will-change: transform;
      }
    </style>

    <array-selector id="selector" items="{{items}}" selected="{{selectedItems}}" selected-item="{{selectedItem}}"></array-selector>

    <div id="items">
      <slot></slot>
    </div>
`,is:"iron-list",properties:{items:{type:Array},as:{type:String,value:"item"},indexAs:{type:String,value:"index"},selectedAs:{type:String,value:"selected"},grid:{type:Boolean,value:false,reflectToAttribute:true,observer:"_gridChanged"},selectionEnabled:{type:Boolean,value:false},selectedItem:{type:Object,notify:true},selectedItems:{type:Object,notify:true},multiSelection:{type:Boolean,value:false},scrollOffset:{type:Number,value:0},preserveFocus:{type:Boolean,value:false}},observers:["_itemsChanged(items.*)","_selectionEnabledChanged(selectionEnabled)","_multiSelectionChanged(multiSelection)","_setOverflow(scrollTarget, scrollOffset)"],behaviors:[Templatizer,IronResizableBehavior,IronScrollTargetBehavior,OptionalMutableDataBehavior],_ratio:.5,_scrollerPaddingTop:0,_scrollPosition:0,_physicalSize:0,_physicalAverage:0,_physicalAverageCount:0,_physicalTop:0,_virtualCount:0,_estScrollHeight:0,_scrollHeight:0,_viewportHeight:0,_viewportWidth:0,_physicalItems:null,_physicalSizes:null,_firstVisibleIndexVal:null,_lastVisibleIndexVal:null,_maxPages:2,_focusedItem:null,_focusedVirtualIndex:-1,_focusedPhysicalIndex:-1,_offscreenFocusedItem:null,_focusBackfillItem:null,_itemsPerRow:1,_itemWidth:0,_rowHeight:0,_templateCost:0,_parentModel:true,get _physicalBottom(){return this._physicalTop+this._physicalSize},get _scrollBottom(){return this._scrollPosition+this._viewportHeight},get _virtualEnd(){return this._virtualStart+this._physicalCount-1},get _hiddenContentSize(){var size=this.grid?this._physicalRows*this._rowHeight:this._physicalSize;return size-this._viewportHeight},get _itemsParent(){return dom(dom(this._userTemplate).parentNode)},get _maxScrollTop(){return this._estScrollHeight-this._viewportHeight+this._scrollOffset},get _maxVirtualStart(){var virtualCount=this._convertIndexToCompleteRow(this._virtualCount);return Math.max(0,virtualCount-this._physicalCount)},set _virtualStart(val){val=this._clamp(val,0,this._maxVirtualStart);if(this.grid){val=val-val%this._itemsPerRow}this._virtualStartVal=val},get _virtualStart(){return this._virtualStartVal||0},set _physicalStart(val){val=val%this._physicalCount;if(val<0){val=this._physicalCount+val}if(this.grid){val=val-val%this._itemsPerRow}this._physicalStartVal=val},get _physicalStart(){return this._physicalStartVal||0},get _physicalEnd(){return(this._physicalStart+this._physicalCount-1)%this._physicalCount},set _physicalCount(val){this._physicalCountVal=val},get _physicalCount(){return this._physicalCountVal||0},get _optPhysicalSize(){return this._viewportHeight===0?Infinity:this._viewportHeight*this._maxPages},get _isVisible(){return Boolean(this.offsetWidth||this.offsetHeight)},get firstVisibleIndex(){var idx=this._firstVisibleIndexVal;if(idx==null){var physicalOffset=this._physicalTop+this._scrollOffset;idx=this._iterateItems((function(pidx,vidx){physicalOffset+=this._getPhysicalSizeIncrement(pidx);if(physicalOffset>this._scrollPosition){return this.grid?vidx-vidx%this._itemsPerRow:vidx}if(this.grid&&this._virtualCount-1===vidx){return vidx-vidx%this._itemsPerRow}}))||0;this._firstVisibleIndexVal=idx}return idx},get lastVisibleIndex(){var idx=this._lastVisibleIndexVal;if(idx==null){if(this.grid){idx=Math.min(this._virtualCount,this.firstVisibleIndex+this._estRowsInView*this._itemsPerRow-1)}else{var physicalOffset=this._physicalTop+this._scrollOffset;this._iterateItems((function(pidx,vidx){if(physicalOffset<this._scrollBottom){idx=vidx}physicalOffset+=this._getPhysicalSizeIncrement(pidx)}))}this._lastVisibleIndexVal=idx}return idx},get _defaultScrollTarget(){return this},get _virtualRowCount(){return Math.ceil(this._virtualCount/this._itemsPerRow)},get _estRowsInView(){return Math.ceil(this._viewportHeight/this._rowHeight)},get _physicalRows(){return Math.ceil(this._physicalCount/this._itemsPerRow)},get _scrollOffset(){return this._scrollerPaddingTop+this.scrollOffset},ready:function(){this.addEventListener("focus",this._didFocus.bind(this),true)},attached:function(){this._debounce("_render",this._render,animationFrame);this.listen(this,"iron-resize","_resizeHandler");this.listen(this,"keydown","_keydownHandler")},detached:function(){this.unlisten(this,"iron-resize","_resizeHandler");this.unlisten(this,"keydown","_keydownHandler")},_setOverflow:function(scrollTarget){this.style.webkitOverflowScrolling=scrollTarget===this?"touch":"";this.style.overflowY=scrollTarget===this?"auto":"";this._lastVisibleIndexVal=null;this._firstVisibleIndexVal=null;this._debounce("_render",this._render,animationFrame)},updateViewportBoundaries:function(){var styles=window.getComputedStyle(this);this._scrollerPaddingTop=this.scrollTarget===this?0:parseInt(styles["padding-top"],10);this._isRTL=Boolean(styles.direction==="rtl");this._viewportWidth=this.$.items.offsetWidth;this._viewportHeight=this._scrollTargetHeight;this.grid&&this._updateGridMetrics()},_scrollHandler:function(){var scrollTop=Math.max(0,Math.min(this._maxScrollTop,this._scrollTop));var delta=scrollTop-this._scrollPosition;var isScrollingDown=delta>=0;this._scrollPosition=scrollTop;this._firstVisibleIndexVal=null;this._lastVisibleIndexVal=null;if(Math.abs(delta)>this._physicalSize&&this._physicalSize>0){delta=delta-this._scrollOffset;var idxAdjustment=Math.round(delta/this._physicalAverage)*this._itemsPerRow;this._virtualStart=this._virtualStart+idxAdjustment;this._physicalStart=this._physicalStart+idxAdjustment;this._physicalTop=Math.min(Math.floor(this._virtualStart/this._itemsPerRow)*this._physicalAverage,this._scrollPosition);this._update()}else if(this._physicalCount>0){var reusables=this._getReusables(isScrollingDown);if(isScrollingDown){this._physicalTop=reusables.physicalTop;this._virtualStart=this._virtualStart+reusables.indexes.length;this._physicalStart=this._physicalStart+reusables.indexes.length}else{this._virtualStart=this._virtualStart-reusables.indexes.length;this._physicalStart=this._physicalStart-reusables.indexes.length}this._update(reusables.indexes,isScrollingDown?null:reusables.indexes);this._debounce("_increasePoolIfNeeded",this._increasePoolIfNeeded.bind(this,0),microTask)}},_getReusables:function(fromTop){var ith,offsetContent,physicalItemHeight;var idxs=[];var protectedOffsetContent=this._hiddenContentSize*this._ratio;var virtualStart=this._virtualStart;var virtualEnd=this._virtualEnd;var physicalCount=this._physicalCount;var top=this._physicalTop+this._scrollOffset;var bottom=this._physicalBottom+this._scrollOffset;var scrollTop=this._scrollPosition;var scrollBottom=this._scrollBottom;if(fromTop){ith=this._physicalStart;this._physicalEnd;offsetContent=scrollTop-top}else{ith=this._physicalEnd;this._physicalStart;offsetContent=bottom-scrollBottom}while(true){physicalItemHeight=this._getPhysicalSizeIncrement(ith);offsetContent=offsetContent-physicalItemHeight;if(idxs.length>=physicalCount||offsetContent<=protectedOffsetContent){break}if(fromTop){if(virtualEnd+idxs.length+1>=this._virtualCount){break}if(top+physicalItemHeight>=scrollTop-this._scrollOffset){break}idxs.push(ith);top=top+physicalItemHeight;ith=(ith+1)%physicalCount}else{if(virtualStart-idxs.length<=0){break}if(top+this._physicalSize-physicalItemHeight<=scrollBottom){break}idxs.push(ith);top=top-physicalItemHeight;ith=ith===0?physicalCount-1:ith-1}}return{indexes:idxs,physicalTop:top-this._scrollOffset}},_update:function(itemSet,movingUp){if(itemSet&&itemSet.length===0||this._physicalCount===0){return}this._manageFocus();this._assignModels(itemSet);this._updateMetrics(itemSet);if(movingUp){while(movingUp.length){var idx=movingUp.pop();this._physicalTop-=this._getPhysicalSizeIncrement(idx)}}this._positionItems();this._updateScrollerSize()},_createPool:function(size){this._ensureTemplatized();var i,inst;var physicalItems=new Array(size);for(i=0;i<size;i++){inst=this.stamp(null);physicalItems[i]=inst.root.querySelector("*");this._itemsParent.appendChild(inst.root)}return physicalItems},_isClientFull:function(){return this._scrollBottom!=0&&this._physicalBottom-1>=this._scrollBottom&&this._physicalTop<=this._scrollPosition},_increasePoolIfNeeded:function(count){var nextPhysicalCount=this._clamp(this._physicalCount+count,DEFAULT_PHYSICAL_COUNT,this._virtualCount-this._virtualStart);nextPhysicalCount=this._convertIndexToCompleteRow(nextPhysicalCount);if(this.grid){var correction=nextPhysicalCount%this._itemsPerRow;if(correction&&nextPhysicalCount-correction<=this._physicalCount){nextPhysicalCount+=this._itemsPerRow}nextPhysicalCount-=correction}var delta=nextPhysicalCount-this._physicalCount;var nextIncrease=Math.round(this._physicalCount*.5);if(delta<0){return}if(delta>0){var ts=window.performance.now();[].push.apply(this._physicalItems,this._createPool(delta));for(var i=0;i<delta;i++){this._physicalSizes.push(0)}this._physicalCount=this._physicalCount+delta;if(this._physicalStart>this._physicalEnd&&this._isIndexRendered(this._focusedVirtualIndex)&&this._getPhysicalIndex(this._focusedVirtualIndex)<this._physicalEnd){this._physicalStart=this._physicalStart+delta}this._update();this._templateCost=(window.performance.now()-ts)/delta;nextIncrease=Math.round(this._physicalCount*.5)}if(this._virtualEnd>=this._virtualCount-1||nextIncrease===0);else if(!this._isClientFull()){this._debounce("_increasePoolIfNeeded",this._increasePoolIfNeeded.bind(this,nextIncrease),microTask)}else if(this._physicalSize<this._optPhysicalSize){this._debounce("_increasePoolIfNeeded",this._increasePoolIfNeeded.bind(this,this._clamp(Math.round(50/this._templateCost),1,nextIncrease)),idlePeriod)}},_render:function(){if(!this.isAttached||!this._isVisible){return}if(this._physicalCount!==0){var reusables=this._getReusables(true);this._physicalTop=reusables.physicalTop;this._virtualStart=this._virtualStart+reusables.indexes.length;this._physicalStart=this._physicalStart+reusables.indexes.length;this._update(reusables.indexes);this._update();this._increasePoolIfNeeded(0)}else if(this._virtualCount>0){this.updateViewportBoundaries();this._increasePoolIfNeeded(DEFAULT_PHYSICAL_COUNT)}},_ensureTemplatized:function(){if(this.ctor){return}this._userTemplate=this.queryEffectiveChildren("template");if(!this._userTemplate){console.warn("iron-list requires a template to be provided in light-dom")}var instanceProps={};instanceProps.__key__=true;instanceProps[this.as]=true;instanceProps[this.indexAs]=true;instanceProps[this.selectedAs]=true;instanceProps.tabIndex=true;this._instanceProps=instanceProps;this.templatize(this._userTemplate,this.mutableData)},_gridChanged:function(newGrid,oldGrid){if(typeof oldGrid==="undefined")return;this.notifyResize();flush();newGrid&&this._updateGridMetrics()},_getFocusedElement:function(){function doSearch(node,query){let result=null;let type=node.nodeType;if(type==Node.ELEMENT_NODE||type==Node.DOCUMENT_FRAGMENT_NODE)result=node.querySelector(query);if(result)return result;let child=node.firstChild;while(child!==null&&result===null){result=doSearch(child,query);child=child.nextSibling}if(result)return result;const shadowRoot=node.shadowRoot;return shadowRoot?doSearch(shadowRoot,query):null}const focusWithin=doSearch(this,":focus-within");return focusWithin?doSearch(focusWithin,":focus"):null},_itemsChanged:function(change){var rendering=/^items(\.splices){0,1}$/.test(change.path);var lastFocusedIndex,focusedElement;if(rendering&&this.preserveFocus){lastFocusedIndex=this._focusedVirtualIndex;focusedElement=this._getFocusedElement()}var preservingFocus=rendering&&this.preserveFocus&&focusedElement;if(change.path==="items"){this._virtualStart=0;this._physicalTop=0;this._virtualCount=this.items?this.items.length:0;this._physicalIndexForKey={};this._firstVisibleIndexVal=null;this._lastVisibleIndexVal=null;this._physicalCount=this._physicalCount||0;this._physicalItems=this._physicalItems||[];this._physicalSizes=this._physicalSizes||[];this._physicalStart=0;if(this._scrollTop>this._scrollOffset&&!preservingFocus){this._resetScrollPosition(0)}this._removeFocusedItem();this._debounce("_render",this._render,animationFrame)}else if(change.path==="items.splices"){this._adjustVirtualIndex(change.value.indexSplices);this._virtualCount=this.items?this.items.length:0;var itemAddedOrRemoved=change.value.indexSplices.some((function(splice){return splice.addedCount>0||splice.removed.length>0}));if(itemAddedOrRemoved){var activeElement=this._getActiveElement();if(this.contains(activeElement)){activeElement.blur()}}var affectedIndexRendered=change.value.indexSplices.some((function(splice){return splice.index+splice.addedCount>=this._virtualStart&&splice.index<=this._virtualEnd}),this);if(!this._isClientFull()||affectedIndexRendered){this._debounce("_render",this._render,animationFrame)}}else if(change.path!=="items.length"){this._forwardItemPath(change.path,change.value)}if(preservingFocus){flush();focusedElement.blur();this._focusPhysicalItem(Math.min(this.items.length-1,lastFocusedIndex));if(!this._isIndexVisible(this._focusedVirtualIndex)){this.scrollToIndex(this._focusedVirtualIndex)}}},_forwardItemPath:function(path,value){path=path.slice(6);var dot=path.indexOf(".");if(dot===-1){dot=path.length}var isIndexRendered;var pidx;var inst;var offscreenInstance=this.modelForElement(this._offscreenFocusedItem);var vidx=parseInt(path.substring(0,dot),10);isIndexRendered=this._isIndexRendered(vidx);if(isIndexRendered){pidx=this._getPhysicalIndex(vidx);inst=this.modelForElement(this._physicalItems[pidx])}else if(offscreenInstance){inst=offscreenInstance}if(!inst||inst[this.indexAs]!==vidx){return}path=path.substring(dot+1);path=this.as+(path?"."+path:"");inst._setPendingPropertyOrPath(path,value,false,true);inst._flushProperties&&inst._flushProperties();if(isIndexRendered){this._updateMetrics([pidx]);this._positionItems();this._updateScrollerSize()}},_adjustVirtualIndex:function(splices){splices.forEach((function(splice){splice.removed.forEach(this._removeItem,this);if(splice.index<this._virtualStart){var delta=Math.max(splice.addedCount-splice.removed.length,splice.index-this._virtualStart);this._virtualStart=this._virtualStart+delta;if(this._focusedVirtualIndex>=0){this._focusedVirtualIndex=this._focusedVirtualIndex+delta}}}),this)},_removeItem:function(item){this.$.selector.deselect(item);if(this._focusedItem&&this.modelForElement(this._focusedItem)[this.as]===item){this._removeFocusedItem()}},_iterateItems:function(fn,itemSet){var pidx,vidx,rtn,i;if(arguments.length===2&&itemSet){for(i=0;i<itemSet.length;i++){pidx=itemSet[i];vidx=this._computeVidx(pidx);if((rtn=fn.call(this,pidx,vidx))!=null){return rtn}}}else{pidx=this._physicalStart;vidx=this._virtualStart;for(;pidx<this._physicalCount;pidx++,vidx++){if((rtn=fn.call(this,pidx,vidx))!=null){return rtn}}for(pidx=0;pidx<this._physicalStart;pidx++,vidx++){if((rtn=fn.call(this,pidx,vidx))!=null){return rtn}}}},_computeVidx:function(pidx){if(pidx>=this._physicalStart){return this._virtualStart+(pidx-this._physicalStart)}return this._virtualStart+(this._physicalCount-this._physicalStart)+pidx},_assignModels:function(itemSet){this._iterateItems((function(pidx,vidx){var el=this._physicalItems[pidx];var item=this.items&&this.items[vidx];if(item!=null){var inst=this.modelForElement(el);inst.__key__=null;this._forwardProperty(inst,this.as,item);this._forwardProperty(inst,this.selectedAs,this.$.selector.isSelected(item));this._forwardProperty(inst,this.indexAs,vidx);this._forwardProperty(inst,"tabIndex",this._focusedVirtualIndex===vidx?0:-1);this._physicalIndexForKey[inst.__key__]=pidx;inst._flushProperties&&inst._flushProperties(true);el.removeAttribute("hidden")}else{el.setAttribute("hidden","")}}),itemSet)},_updateMetrics:function(itemSet){flush();var newPhysicalSize=0;var oldPhysicalSize=0;var prevAvgCount=this._physicalAverageCount;var prevPhysicalAvg=this._physicalAverage;this._iterateItems((function(pidx,vidx){oldPhysicalSize+=this._physicalSizes[pidx];this._physicalSizes[pidx]=this._physicalItems[pidx].offsetHeight;newPhysicalSize+=this._physicalSizes[pidx];this._physicalAverageCount+=this._physicalSizes[pidx]?1:0}),itemSet);if(this.grid){this._updateGridMetrics();this._physicalSize=Math.ceil(this._physicalCount/this._itemsPerRow)*this._rowHeight}else{oldPhysicalSize=this._itemsPerRow===1?oldPhysicalSize:Math.ceil(this._physicalCount/this._itemsPerRow)*this._rowHeight;this._physicalSize=this._physicalSize+newPhysicalSize-oldPhysicalSize;this._itemsPerRow=1}if(this._physicalAverageCount!==prevAvgCount){this._physicalAverage=Math.round((prevPhysicalAvg*prevAvgCount+newPhysicalSize)/this._physicalAverageCount)}},_updateGridMetrics:function(){this._itemWidth=this._physicalCount>0?this._physicalItems[0].getBoundingClientRect().width:200;this._rowHeight=this._physicalCount>0?this._physicalItems[0].offsetHeight:200;this._itemsPerRow=this._itemWidth?Math.floor(this._viewportWidth/this._itemWidth):this._itemsPerRow},_positionItems:function(){this._adjustScrollPosition();var y=this._physicalTop;if(this.grid){var totalItemWidth=this._itemsPerRow*this._itemWidth;var rowOffset=(this._viewportWidth-totalItemWidth)/2;this._iterateItems((function(pidx,vidx){var modulus=vidx%this._itemsPerRow;var x=Math.floor(modulus*this._itemWidth+rowOffset);if(this._isRTL){x=x*-1}this.translate3d(x+"px",y+"px",0,this._physicalItems[pidx]);if(this._shouldRenderNextRow(vidx)){y+=this._rowHeight}}))}else{const order=[];this._iterateItems((function(pidx,vidx){const item=this._physicalItems[pidx];this.translate3d(0,y+"px",0,item);y+=this._physicalSizes[pidx];const itemId=item.id;if(itemId){order.push(itemId)}}));if(order.length){this.setAttribute("aria-owns",order.join(" "))}}},_getPhysicalSizeIncrement:function(pidx){if(!this.grid){return this._physicalSizes[pidx]}if(this._computeVidx(pidx)%this._itemsPerRow!==this._itemsPerRow-1){return 0}return this._rowHeight},_shouldRenderNextRow:function(vidx){return vidx%this._itemsPerRow===this._itemsPerRow-1},_adjustScrollPosition:function(){var deltaHeight=this._virtualStart===0?this._physicalTop:Math.min(this._scrollPosition+this._physicalTop,0);if(deltaHeight!==0){this._physicalTop=this._physicalTop-deltaHeight;var scrollTop=this._scrollPosition;if(!IOS_TOUCH_SCROLLING&&scrollTop>0){this._resetScrollPosition(scrollTop-deltaHeight)}}},_resetScrollPosition:function(pos){if(this.scrollTarget&&pos>=0){this._scrollTop=pos;this._scrollPosition=this._scrollTop}},_updateScrollerSize:function(forceUpdate){if(this.grid){this._estScrollHeight=this._virtualRowCount*this._rowHeight}else{this._estScrollHeight=this._physicalBottom+Math.max(this._virtualCount-this._physicalCount-this._virtualStart,0)*this._physicalAverage}forceUpdate=forceUpdate||this._scrollHeight===0;forceUpdate=forceUpdate||this._scrollPosition>=this._estScrollHeight-this._physicalSize;forceUpdate=forceUpdate||this.grid&&this.$.items.style.height<this._estScrollHeight;if(forceUpdate||Math.abs(this._estScrollHeight-this._scrollHeight)>=this._viewportHeight){this.$.items.style.height=this._estScrollHeight+"px";this._scrollHeight=this._estScrollHeight}},scrollToItem:function(item){return this.scrollToIndex(this.items.indexOf(item))},scrollToIndex:function(idx){if(typeof idx!=="number"||idx<0||idx>this.items.length-1){return}flush();if(this._physicalCount===0){return}idx=this._clamp(idx,0,this._virtualCount-1);if(!this._isIndexRendered(idx)||idx>=this._maxVirtualStart){this._virtualStart=this.grid?idx-this._itemsPerRow*2:idx-1}this._manageFocus();this._assignModels();this._updateMetrics();this._physicalTop=Math.floor(this._virtualStart/this._itemsPerRow)*this._physicalAverage;var currentTopItem=this._physicalStart;var currentVirtualItem=this._virtualStart;var targetOffsetTop=0;var hiddenContentSize=this._hiddenContentSize;while(currentVirtualItem<idx&&targetOffsetTop<=hiddenContentSize){targetOffsetTop=targetOffsetTop+this._getPhysicalSizeIncrement(currentTopItem);currentTopItem=(currentTopItem+1)%this._physicalCount;currentVirtualItem++}this._updateScrollerSize(true);this._positionItems();this._resetScrollPosition(this._physicalTop+this._scrollOffset+targetOffsetTop);this._increasePoolIfNeeded(0);this._firstVisibleIndexVal=null;this._lastVisibleIndexVal=null},_resetAverage:function(){this._physicalAverage=0;this._physicalAverageCount=0},_resizeHandler:function(){this._debounce("_render",(function(){this._firstVisibleIndexVal=null;this._lastVisibleIndexVal=null;if(this._isVisible){this.updateViewportBoundaries();this.toggleScrollListener(true);this._resetAverage();this._render()}else{this.toggleScrollListener(false)}}),animationFrame)},selectItem:function(item){return this.selectIndex(this.items.indexOf(item))},selectIndex:function(index){if(index<0||index>=this._virtualCount){return}if(!this.multiSelection&&this.selectedItem){this.clearSelection()}if(this._isIndexRendered(index)){var model=this.modelForElement(this._physicalItems[this._getPhysicalIndex(index)]);if(model){model[this.selectedAs]=true}this.updateSizeForIndex(index)}this.$.selector.selectIndex(index)},deselectItem:function(item){return this.deselectIndex(this.items.indexOf(item))},deselectIndex:function(index){if(index<0||index>=this._virtualCount){return}if(this._isIndexRendered(index)){var model=this.modelForElement(this._physicalItems[this._getPhysicalIndex(index)]);model[this.selectedAs]=false;this.updateSizeForIndex(index)}this.$.selector.deselectIndex(index)},toggleSelectionForItem:function(item){return this.toggleSelectionForIndex(this.items.indexOf(item))},toggleSelectionForIndex:function(index){var isSelected=this.$.selector.isIndexSelected?this.$.selector.isIndexSelected(index):this.$.selector.isSelected(this.items[index]);isSelected?this.deselectIndex(index):this.selectIndex(index)},clearSelection:function(){this._iterateItems((function(pidx,vidx){this.modelForElement(this._physicalItems[pidx])[this.selectedAs]=false}));this.$.selector.clearSelection()},_selectionEnabledChanged:function(selectionEnabled){var handler=selectionEnabled?this.listen:this.unlisten;handler.call(this,this,"tap","_selectionHandler")},_selectionHandler:function(e){var model=this.modelForElement(e.target);if(!model){return}var modelTabIndex,activeElTabIndex;var target=dom(e).path[0];var activeEl=this._getActiveElement();var physicalItem=this._physicalItems[this._getPhysicalIndex(model[this.indexAs])];if(target.localName==="input"||target.localName==="button"||target.localName==="select"){return}modelTabIndex=model.tabIndex;model.tabIndex=SECRET_TABINDEX;activeElTabIndex=activeEl?activeEl.tabIndex:-1;model.tabIndex=modelTabIndex;if(activeEl&&physicalItem!==activeEl&&physicalItem.contains(activeEl)&&activeElTabIndex!==SECRET_TABINDEX){return}this.toggleSelectionForItem(model[this.as])},_multiSelectionChanged:function(multiSelection){this.clearSelection();this.$.selector.multi=multiSelection},updateSizeForItem:function(item){return this.updateSizeForIndex(this.items.indexOf(item))},updateSizeForIndex:function(index){if(!this._isIndexRendered(index)){return null}this._updateMetrics([this._getPhysicalIndex(index)]);this._positionItems();return null},_manageFocus:function(){var fidx=this._focusedVirtualIndex;if(fidx>=0&&fidx<this._virtualCount){if(this._isIndexRendered(fidx)){this._restoreFocusedItem()}else{this._createFocusBackfillItem()}}else if(this._virtualCount>0&&this._physicalCount>0){this._focusedPhysicalIndex=this._physicalStart;this._focusedVirtualIndex=this._virtualStart;this._focusedItem=this._physicalItems[this._physicalStart]}},_convertIndexToCompleteRow:function(idx){this._itemsPerRow=this._itemsPerRow||1;return this.grid?Math.ceil(idx/this._itemsPerRow)*this._itemsPerRow:idx},_isIndexRendered:function(idx){return idx>=this._virtualStart&&idx<=this._virtualEnd},_isIndexVisible:function(idx){return idx>=this.firstVisibleIndex&&idx<=this.lastVisibleIndex},_getPhysicalIndex:function(vidx){return(this._physicalStart+(vidx-this._virtualStart))%this._physicalCount},focusItem:function(idx){this._focusPhysicalItem(idx)},_focusPhysicalItem:function(idx){if(idx<0||idx>=this._virtualCount){return}this._restoreFocusedItem();if(!this._isIndexRendered(idx)){this.scrollToIndex(idx)}var physicalItem=this._physicalItems[this._getPhysicalIndex(idx)];var model=this.modelForElement(physicalItem);var focusable;model.tabIndex=SECRET_TABINDEX;if(physicalItem.tabIndex===SECRET_TABINDEX){focusable=physicalItem}if(!focusable){focusable=dom(physicalItem).querySelector('[tabindex="'+SECRET_TABINDEX+'"]')}model.tabIndex=0;this._focusedVirtualIndex=idx;focusable&&focusable.focus()},_removeFocusedItem:function(){if(this._offscreenFocusedItem){this._itemsParent.removeChild(this._offscreenFocusedItem)}this._offscreenFocusedItem=null;this._focusBackfillItem=null;this._focusedItem=null;this._focusedVirtualIndex=-1;this._focusedPhysicalIndex=-1},_createFocusBackfillItem:function(){var fpidx=this._focusedPhysicalIndex;if(this._offscreenFocusedItem||this._focusedVirtualIndex<0){return}if(!this._focusBackfillItem){var inst=this.stamp(null);this._focusBackfillItem=inst.root.querySelector("*");this._itemsParent.appendChild(inst.root)}this._offscreenFocusedItem=this._physicalItems[fpidx];this.modelForElement(this._offscreenFocusedItem).tabIndex=0;this._physicalItems[fpidx]=this._focusBackfillItem;this._focusedPhysicalIndex=fpidx;this.translate3d(0,HIDDEN_Y,0,this._offscreenFocusedItem)},_restoreFocusedItem:function(){if(!this._offscreenFocusedItem||this._focusedVirtualIndex<0){return}this._assignModels();var fpidx=this._focusedPhysicalIndex=this._getPhysicalIndex(this._focusedVirtualIndex);var onScreenItem=this._physicalItems[fpidx];if(!onScreenItem){return}var onScreenInstance=this.modelForElement(onScreenItem);var offScreenInstance=this.modelForElement(this._offscreenFocusedItem);if(onScreenInstance[this.as]===offScreenInstance[this.as]){this._focusBackfillItem=onScreenItem;onScreenInstance.tabIndex=-1;this._physicalItems[fpidx]=this._offscreenFocusedItem;this.translate3d(0,HIDDEN_Y,0,this._focusBackfillItem)}else{this._removeFocusedItem();this._focusBackfillItem=null}this._offscreenFocusedItem=null},_didFocus:function(e){var targetModel=this.modelForElement(e.target);var focusedModel=this.modelForElement(this._focusedItem);var hasOffscreenFocusedItem=this._offscreenFocusedItem!==null;var fidx=this._focusedVirtualIndex;if(!targetModel){return}if(focusedModel!==targetModel){this._restoreFocusedItem();if(focusedModel){focusedModel.tabIndex=-1}targetModel.tabIndex=0;fidx=targetModel[this.indexAs];this._focusedVirtualIndex=fidx;this._focusedPhysicalIndex=this._getPhysicalIndex(fidx);this._focusedItem=this._physicalItems[this._focusedPhysicalIndex];if(hasOffscreenFocusedItem&&!this._offscreenFocusedItem){this._update()}}},_keydownHandler:function(e){switch(e.keyCode){case 40:if(this._focusedVirtualIndex<this._virtualCount-1)e.preventDefault();this._focusPhysicalItem(this._focusedVirtualIndex+(this.grid?this._itemsPerRow:1));break;case 39:if(this.grid)this._focusPhysicalItem(this._focusedVirtualIndex+(this._isRTL?-1:1));break;case 38:if(this._focusedVirtualIndex>0)e.preventDefault();this._focusPhysicalItem(this._focusedVirtualIndex-(this.grid?this._itemsPerRow:1));break;case 37:if(this.grid)this._focusPhysicalItem(this._focusedVirtualIndex+(this._isRTL?1:-1));break;case 13:this._focusPhysicalItem(this._focusedVirtualIndex);if(this.selectionEnabled)this._selectionHandler(e);break}},_clamp:function(v,min,max){return Math.min(max,Math.max(min,v))},_debounce:function(name,cb,asyncModule){this._debouncers=this._debouncers||{};this._debouncers[name]=Debouncer.debounce(this._debouncers[name],asyncModule,cb.bind(this));enqueueDebouncer(this._debouncers[name])},_forwardProperty:function(inst,name,value){inst._setPendingProperty(name,value)},_forwardHostPropV2:function(prop,value){(this._physicalItems||[]).concat([this._offscreenFocusedItem,this._focusBackfillItem]).forEach((function(item){if(item){this.modelForElement(item).forwardHostProp(prop,value)}}),this)},_notifyInstancePropV2:function(inst,prop,value){if(matches$1(this.as,prop)){var idx=inst[this.indexAs];if(prop==this.as){this.items[idx]=value}this.notifyPath(translate(this.as,"items."+idx,prop),value)}},_getStampedChildren:function(){return this._physicalItems},_forwardInstancePath:function(inst,path,value){if(path.indexOf(this.as+".")===0){this.notifyPath("items."+inst.__key__+"."+path.slice(this.as.length+1),value)}},_forwardParentPath:function(path,value){(this._physicalItems||[]).concat([this._offscreenFocusedItem,this._focusBackfillItem]).forEach((function(item){if(item){this.modelForElement(item).notifyPath(path,value)}}),this)},_forwardParentProp:function(prop,value){(this._physicalItems||[]).concat([this._offscreenFocusedItem,this._focusBackfillItem]).forEach((function(item){if(item){this.modelForElement(item)[prop]=value}}),this)},_getActiveElement:function(){var itemsHost=this._itemsParent.node.domHost;return dom(itemsHost?itemsHost.root:document).activeElement}});
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/Polymer({is:"iron-media-query",properties:{queryMatches:{type:Boolean,value:false,readOnly:true,notify:true},query:{type:String,observer:"queryChanged"},full:{type:Boolean,value:false},_boundMQHandler:{value:function(){return this.queryHandler.bind(this)}},_mq:{value:null}},attached:function(){this.style.display="none";this.queryChanged()},detached:function(){this._remove()},_add:function(){if(this._mq){this._mq.addListener(this._boundMQHandler)}},_remove:function(){if(this._mq){this._mq.removeListener(this._boundMQHandler)}this._mq=null},queryChanged:function(){this._remove();var query=this.query;if(!query){return}if(!this.full&&query[0]!=="("){query="("+query+")"}this._mq=window.matchMedia(query);this._add();this.queryHandler(this._mq)},queryHandler:function(mq){this._setQueryMatches(mq.matches)}});const styleMod$2=document.createElement("dom-module");styleMod$2.appendChild(html$1`
  <template>
    <style include="cr-hidden-style">
:host{align-items:center;cursor:default;display:flex;font-size:calc(12/13 * 1em);min-height:var(--destination-item-height);opacity:.87;padding-inline-end:2px;padding-inline-start:0;vertical-align:middle}:host>*{align-items:center;color:var(--cr-secondary-text-color);font-size:calc(10/12 * 1em);overflow:hidden;text-overflow:ellipsis;vertical-align:middle;white-space:nowrap}:host>span{margin-inline-start:1em}cr-icon{--icon-margin:calc((var(--search-icon-size) - var(--iron-icon-width))/2);fill:var(--google-grey-600);flex:0;height:var(--iron-icon-height);margin-inline-end:var(--icon-margin);margin-inline-start:var(--icon-margin);min-width:var(--iron-icon-width);transition:opacity 150ms}@media (prefers-color-scheme:dark){cr-icon{fill:var(--google-grey-500)}}:host .name{color:var(--cr-primary-text-color);font-size:1em;margin-inline-start:0;padding-inline-start:8px}.extension-controlled-indicator{display:flex;flex:1;justify-content:flex-end;min-width:150px;padding-inline-end:8px}.extension-icon{height:24px;margin-inline-start:1em;width:24px}
    </style>
  </template>
`.content);styleMod$2.register("destination-list-item-style");function getTemplate$b(){return html$1`<!--_html_template_start_--><style include="destination-list-item-style">.configuring-failed-text{color:var(--google-red-600);font-style:italic}:host([is-destination-cros-local_]) .connection-status,:host([is-destination-cros-local_]) .connection-status.status-red{color:var(--error-status-alert)}:host([is-destination-cros-local_]) .connection-status.status-orange{color:var(--error-status-warning)}</style>
<iron-media-query query="(prefers-color-scheme: dark)"
    query-matches="{{isDarkModeActive_}}">
</iron-media-query>
<cr-icon icon="[[destinationIcon_]]"></cr-icon>
<span class="name searchable">[[destination.displayName]]</span>
<span class="search-hint searchable" hidden="[[!searchHint_]]">
  [[searchHint_]]
</span>
<span class$="[[computeStatusClass_(destination.printerStatusReason)]]"
    hidden="[[!statusText_]]">
  [[statusText_]]
</span>
<span class="extension-controlled-indicator"
    hidden$="[[!destination.isExtension]]">
  <span class="extension-name searchable">
    [[destination.extensionName]]
  </span>
  <span class="extension-icon" role="button" tabindex="0"
      title="[[getExtensionPrinterTooltip_(destination)]]"></span>
</span>
<span class="configuring-in-progress-text"
  hidden$="[[!checkConfigurationStatus_(statusEnum_.IN_PROGRESS,
                                        configurationStatus_)]]">
  $i18n{configuringInProgressText}
  <span class="configuring-text-jumping-dots">
    <span>.</span><span>.</span><span>.</span>
  </span>
</span>
<span class="configuring-failed-text"
  hidden$="[[!checkConfigurationStatus_(statusEnum_.FAILED,
                                        configurationStatus_)]]">
  $i18n{configuringFailedText}
</span>
<!--_html_template_end_-->`}
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var DestinationConfigStatus;(function(DestinationConfigStatus){DestinationConfigStatus[DestinationConfigStatus["IDLE"]=0]="IDLE";DestinationConfigStatus[DestinationConfigStatus["IN_PROGRESS"]=1]="IN_PROGRESS";DestinationConfigStatus[DestinationConfigStatus["FAILED"]=2]="FAILED"})(DestinationConfigStatus||(DestinationConfigStatus={}));const PrintPreviewDestinationListItemElementBase=I18nMixin(PolymerElement);class PrintPreviewDestinationListItemElement extends PrintPreviewDestinationListItemElementBase{constructor(){super(...arguments);this.highlights_=[]}static get is(){return"print-preview-destination-list-item"}static get template(){return getTemplate$b()}static get properties(){return{destination:Object,searchQuery:Object,searchHint_:String,destinationIcon_:{type:String,computed:"computeDestinationIcon_(destination, "+"destination.printerStatusReason)"},statusText_:{type:String,computed:"computeStatusText_(destination, destination.printerStatusReason,"+"configurationStatus_)"},isDarkModeActive_:Boolean,isDestinationCrosLocal_:{type:Boolean,computed:"computeIsDestinationCrosLocal_(destination)",reflectToAttribute:true},configurationStatus_:{type:Number,value:DestinationConfigStatus.IDLE},statusEnum_:{type:Object,value:DestinationConfigStatus}}}static get observers(){return["onDestinationPropertiesChange_("+"destination.displayName, destination.isExtension)","updateHighlightsAndHint_(destination, searchQuery)","requestPrinterStatus_(destination.key)"]}onDestinationPropertiesChange_(){this.title=this.destination.displayName;if(this.destination.isExtension){const icon=this.shadowRoot.querySelector(".extension-icon");assert(icon);icon.style.backgroundImage="image-set("+"url(chrome://extension-icon/"+this.destination.extensionId+"/24/1) 1x,"+"url(chrome://extension-icon/"+this.destination.extensionId+"/48/1) 2x)"}}updateHighlightsAndHint_(){this.updateSearchHint_();removeHighlights(this.highlights_);this.highlights_=updateHighlights(this,this.searchQuery,new Map)}updateSearchHint_(){const matches=!this.searchQuery?[]:this.destination.extraPropertiesToMatch.filter((p=>p.match(this.searchQuery)));this.searchHint_=matches.length===0?this.destination.extraPropertiesToMatch.find((p=>!!p))||"":matches.join(" ")}getExtensionPrinterTooltip_(){if(!this.destination.isExtension){return""}return loadTimeData.getStringF("extensionDestinationIconTooltip",this.destination.extensionName)}onConfigureRequestAccepted(){assert(this.destination.origin===DestinationOrigin.CROS&&!this.destination.capabilities);this.configurationStatus_=DestinationConfigStatus.IN_PROGRESS}onConfigureComplete(success){this.configurationStatus_=success?DestinationConfigStatus.IDLE:DestinationConfigStatus.FAILED}checkConfigurationStatus_(status){return this.configurationStatus_===status}computeStatusText_(){if(!this.destination||this.destination.origin!==DestinationOrigin.CROS){return""}if(this.configurationStatus_!==DestinationConfigStatus.IDLE){return""}const printerStatusReason=this.destination.printerStatusReason;if(printerStatusReason===null||printerStatusReason===PrinterStatusReason.NO_ERROR||printerStatusReason===PrinterStatusReason.UNKNOWN_REASON){return""}const errorStringKey=ERROR_STRING_KEY_MAP.get(printerStatusReason);return errorStringKey?this.i18n(errorStringKey):""}computeDestinationIcon_(){if(!this.destination){return""}if(this.destination.origin===DestinationOrigin.CROS){return getPrinterStatusIcon(this.destination.printerStatusReason,this.destination.isEnterprisePrinter,this.isDarkModeActive_)}return this.destination.icon}computeStatusClass_(){const statusClass="connection-status";if(!this.destination||this.destination.printerStatusReason===null){return statusClass}return`${statusClass} ${getStatusTextColorClass(this.destination.printerStatusReason)}`}computeIsDestinationCrosLocal_(){return this.destination&&this.destination.origin===DestinationOrigin.CROS}requestPrinterStatus_(){if(this.destination.origin!==DestinationOrigin.CROS){return}this.destination.requestPrinterStatus().then((destinationKey=>this.onPrinterStatusReceived_(destinationKey)))}onPrinterStatusReceived_(destinationKey){if(this.destination.key===destinationKey){this.notifyPath(`destination.printerStatusReason`)}}}customElements.define(PrintPreviewDestinationListItemElement.is,PrintPreviewDestinationListItemElement);
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const ListPropertyUpdateMixin=dedupingMixin((superClass=>{class ListPropertyUpdateMixin extends superClass{updateList(propertyPath,identityGetter,updatedList,identityBasedUpdate=false){const list=this.get(propertyPath);const splices=calculateSplices(updatedList.map((item=>identityGetter(item))),list.map(identityGetter));splices.forEach((splice=>{const index=splice.index;const deleteCount=splice.removed.length;splice.removed=list.slice(index,index+deleteCount);splice.object=list;splice.type="splice";const added=updatedList.slice(index,index+splice.addedCount);const spliceParams=[index,deleteCount].concat(added);list.splice.apply(list,spliceParams)}));let updated=splices.length>0;if(!identityBasedUpdate){list.forEach(((item,index)=>{const updatedItem=updatedList[index];if(JSON.stringify(item)!==JSON.stringify(updatedItem)){this.set([propertyPath,index],updatedItem);updated=true}}))}if(splices.length>0){this.notifySplices(propertyPath,splices)}return updated}}return ListPropertyUpdateMixin}));function getTemplate$a(){return html$1`<!--_html_template_start_--><style include="cr-hidden-style throbber">:host{display:flex;flex-direction:column;height:100%;overflow:hidden;user-select:none}#list{min-height:var(--destination-item-height)}.throbber-container{display:flex;margin-inline-start:calc((var(--search-icon-size) - var(--throbber-size))/2);min-height:var(--destination-item-height)}.throbber{align-self:center}.no-destinations-message{padding-bottom:8px;padding-inline-start:18px;padding-top:8px}:not(.moving).list-item{transition:background-color 150ms}.list-item:hover,.list-item:focus{background-color:rgb(228,236,247)}@media (prefers-color-scheme:dark){.list-item:-webkit-any(:hover,:focus){background-color:var(--cr-menu-background-focus-color)}}.list-item:focus{outline:none}</style>
<div class="no-destinations-message" hidden$="[[hasDestinations_]]">
  $i18n{noDestinationsMessage}
</div>
<iron-list id="list" items="[[matchingDestinations_]]" role="grid"
    aria-rowcount$="[[matchingDestinations_.length]]"
    aria-label="$i18n{printDestinationsTitle}" hidden$="[[hideList_]]">
  <template>
    <div role="row" id$="destination_[[index]]"
        aria-rowindex$="[[getAriaRowindex_(index)]]">
      <print-preview-destination-list-item class="list-item"
          search-query="[[searchQuery]]" destination="[[item]]"
          on-click="onDestinationSelected_" on-keydown="onKeydown_"
          role="gridcell" tabindex$="[[tabIndex]]"
          iron-list-tab-index="[[tabIndex]]">
      </print-preview-destination-list-item>
    </div>
  </template>
</iron-list>
<div class="throbber-container" hidden$="[[throbberHidden_]]">
  <div class="throbber"></div>
</div>
<!--_html_template_end_-->`}
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const DESTINATION_ITEM_HEIGHT=32;const PrintPreviewDestinationListElementBase=ListPropertyUpdateMixin(PolymerElement);class PrintPreviewDestinationListElement extends PrintPreviewDestinationListElementBase{constructor(){super(...arguments);this.boundUpdateHeight_=null}static get is(){return"print-preview-destination-list"}static get template(){return getTemplate$a()}static get properties(){return{destinations:Array,searchQuery:Object,loadingDestinations:{type:Boolean,value:false},matchingDestinations_:{type:Array,value:()=>[]},hasDestinations_:{type:Boolean,value:true},throbberHidden_:{type:Boolean,value:false},hideList_:{type:Boolean,value:false}}}static get observers(){return["updateMatchingDestinations_("+"destinations.*, searchQuery, loadingDestinations)"]}connectedCallback(){super.connectedCallback();this.boundUpdateHeight_=()=>this.updateHeight_();window.addEventListener("resize",this.boundUpdateHeight_)}disconnectedCallback(){super.disconnectedCallback();window.removeEventListener("resize",this.boundUpdateHeight_);this.boundUpdateHeight_=null}forceIronResize_(){this.$.list.fire("iron-resize")}updateHeight_(numDestinations){const count=numDestinations===undefined?this.matchingDestinations_.length:numDestinations;const maxDisplayedItems=this.offsetHeight/DESTINATION_ITEM_HEIGHT;const isListFullHeight=maxDisplayedItems<=count;this.hasDestinations_=count>0||this.loadingDestinations;this.throbberHidden_=!this.loadingDestinations||isListFullHeight||!this.hasDestinations_;this.hideList_=count===0;if(this.hideList_){return}const listHeight=isListFullHeight?this.offsetHeight:count*DESTINATION_ITEM_HEIGHT;this.$.list.style.height=listHeight>DESTINATION_ITEM_HEIGHT?`${listHeight}px`:`${DESTINATION_ITEM_HEIGHT}px`}updateMatchingDestinations_(){if(this.destinations===undefined){return}const matchingDestinations=this.searchQuery?this.destinations.filter((d=>d.matches(this.searchQuery))):this.destinations.slice();this.updateHeight_(matchingDestinations.length);this.updateList("matchingDestinations_",(destination=>destination.key),matchingDestinations);this.forceIronResize_()}onKeydown_(e){if(e.key==="Enter"){this.onDestinationSelected_(e);e.stopPropagation()}}onDestinationSelected_(e){if(e.composedPath()[0].tagName==="A"){return}this.dispatchEvent(new CustomEvent("destination-selected",{bubbles:true,composed:true,detail:e.target}))}getAriaRowindex_(index){return index+1}updatePrinterStatusIcon(destinationKey){const index=this.matchingDestinations_.findIndex((destination=>destination.key===destinationKey));if(index===-1){return}this.notifyPath(`matchingDestinations_.${index}.printerStatusReason`)}}customElements.define(PrintPreviewDestinationListElement.is,PrintPreviewDestinationListElement);function getTemplate$9(){return html$1`<!--_html_template_start_--><style include="print-preview-shared">.container{align-items:center;display:flex;flex-direction:column;gap:16px;justify-content:center;margin-block:16px 0;margin-inline:auto;text-align:center;max-width:368px}.message-container{color:var(--google-grey-700);display:flex;flex-direction:column;gap:8px}.message-detail{font:var(--cros-body-1-font);margin-block:0}.message-heading{font:var(--cros-display-7-font);margin-block:0}cr-button{font:var(--cros-button-2-font)}cr-icon{--cros-sys-illo-base:#FFFFFF;--cros-sys-illo-color1-2:#DBE1FF;--cros-sys-illo-color3:#EE9829;--cros-sys-illo-color4:#FF5449;--cros-sys-illo-color5:#C6A0BF;--cros-sys-illo-secondary:#E2E1EC;--iron-icon-height:200px;--iron-icon-width:268px}@media (prefers-color-scheme:dark){.message-container{color:var(--google-grey-400)}cr-icon{--cros-sys-illo-base:#000000;--cros-sys-illo-color1-2:#414659;--cros-sys-illo-color3:#FFB866;--cros-sys-illo-color4:#FF5449;--cros-sys-illo-color5:#745470;--cros-sys-illo-secondary:#5D5E67}}</style>
<div class="container">
  <cr-icon icon="print-preview:no-printer-available"
      hidden$="[[!showIllustration]]">
  </cr-icon>
  <div class="message-container">
    <h2 class="message-heading">[[getMessageHeading(messageType)]]</h2>
    <p class="message-detail">[[getMessageDetail(messageType)]]</p>
  </div>
  <cr-button class="action-button" on-click="onManagePrintersClicked"
      hidden$="[[!showManagePrintersButton]]">
    $i18n{managePrintersLabel}
  </cr-button>
</div>
<!--_html_template_end_-->`}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PrintPreviewPrinterSetupInfoCrosElementBase=I18nMixin(PolymerElement);const MIN_SHOW_ILLUSTRATION_HEIGHT=400;const MIN_SHOW_ILLUSTRATION_WIDTH=250;var PrinterSetupInfoInitiator;(function(PrinterSetupInfoInitiator){PrinterSetupInfoInitiator[PrinterSetupInfoInitiator["PREVIEW_AREA"]=0]="PREVIEW_AREA";PrinterSetupInfoInitiator[PrinterSetupInfoInitiator["DESTINATION_DIALOG_CROS"]=1]="DESTINATION_DIALOG_CROS"})(PrinterSetupInfoInitiator||(PrinterSetupInfoInitiator={}));var PrinterSetupInfoMessageType;(function(PrinterSetupInfoMessageType){PrinterSetupInfoMessageType[PrinterSetupInfoMessageType["NO_PRINTERS"]=0]="NO_PRINTERS";PrinterSetupInfoMessageType[PrinterSetupInfoMessageType["PRINTER_OFFLINE"]=1]="PRINTER_OFFLINE"})(PrinterSetupInfoMessageType||(PrinterSetupInfoMessageType={}));const MESSAGE_TYPE_LOCALIZED_STRINGS_MAP=new Map([[PrinterSetupInfoMessageType.NO_PRINTERS,{headingKey:"printerSetupInfoMessageHeadingNoPrintersText",detailKey:"printerSetupInfoMessageDetailNoPrintersText"}],[PrinterSetupInfoMessageType.PRINTER_OFFLINE,{headingKey:"printerSetupInfoMessageHeadingPrinterOfflineText",detailKey:"printerSetupInfoMessageDetailPrinterOfflineText"}]]);class PrintPreviewPrinterSetupInfoCrosElement extends PrintPreviewPrinterSetupInfoCrosElementBase{constructor(){super(...arguments);this.showManagePrintersButton=false;this.showIllustration=true}static get is(){return"print-preview-printer-setup-info-cros"}static get template(){return getTemplate$9()}static get properties(){return{messageType:{type:Number,value:PrinterSetupInfoMessageType.NO_PRINTERS},initiator:Number,showManagePrintersButton:Boolean,showIllustration:Boolean}}connectedCallback(){super.connectedCallback();this.nativeLayer=NativeLayerImpl.getInstance();this.metricsContext=MetricsContext.getLaunchPrinterSettingsMetricsContextCros();NativeLayerCrosImpl.getInstance().getShowManagePrinters().then((show=>{this.showManagePrintersButton=show}));if(this.initiator===PrinterSetupInfoInitiator.PREVIEW_AREA){this.startResizeObserver()}}disconnectedCallback(){super.disconnectedCallback();if(this.initiator===PrinterSetupInfoInitiator.PREVIEW_AREA){this.resizeObserver.disconnect()}}getMessageDetail(){const messageData=MESSAGE_TYPE_LOCALIZED_STRINGS_MAP.get(this.messageType);assert(messageData);return this.i18n(messageData.detailKey)}getMessageHeading(){const messageData=MESSAGE_TYPE_LOCALIZED_STRINGS_MAP.get(this.messageType);assert(messageData);return this.i18n(messageData.headingKey)}onManagePrintersClicked(){this.nativeLayer.managePrinters();switch(this.initiator){case PrinterSetupInfoInitiator.PREVIEW_AREA:this.metricsContext.record(PrintPreviewLaunchSourceBucket.PREVIEW_AREA_CONNECTION_ERROR);break;case PrinterSetupInfoInitiator.DESTINATION_DIALOG_CROS:this.metricsContext.record(PrintPreviewLaunchSourceBucket.DESTINATION_DIALOG_CROS_NO_PRINTERS);break;default:assertNotReached()}}setShowIllustration(){assert(this.initiator===PrinterSetupInfoInitiator.PREVIEW_AREA);const parentDiv=this.getPreviewAreaParentDiv();this.showIllustration=parentDiv.offsetHeight>=MIN_SHOW_ILLUSTRATION_HEIGHT&&parentDiv.offsetWidth>=MIN_SHOW_ILLUSTRATION_WIDTH}getPreviewAreaParentDiv(){assert(this.initiator===PrinterSetupInfoInitiator.PREVIEW_AREA);const parentShadowRoot=this.shadowRoot.host.getRootNode();assert(parentShadowRoot);const previewContainer=parentShadowRoot.querySelector(".preview-area-message");assert(previewContainer);return previewContainer}startResizeObserver(){this.resizeObserver=new ResizeObserver((()=>setTimeout((()=>this.setShowIllustration()),0)));this.resizeObserver.observe(this.getPreviewAreaParentDiv())}setInitiatorForTesting(initiator,startResizeObserver){this.initiator=initiator;if(this.initiator===PrinterSetupInfoInitiator.PREVIEW_AREA){if(startResizeObserver){this.startResizeObserver()}else{this.resizeObserver=new ResizeObserver((()=>{}))}}}}customElements.define(PrintPreviewPrinterSetupInfoCrosElement.is,PrintPreviewPrinterSetupInfoCrosElement);function getTemplate$8(){return html$1`<!--_html_template_start_--><style include="print-preview-shared cr-hidden-style throbber">#dialog::part(dialog){height:-webkit-fit-content;max-height:calc(100vh - 4 * var(--print-preview-dialog-margin));max-width:calc(100vw - 4 * var(--print-preview-dialog-margin))}.throbber-placeholder{height:16px;margin:4px;width:16px}.message{line-height:calc(20/13 * 1em);margin:0;padding-bottom:12px;padding-top:8px}.extension-desc{display:flex}.extension-icon{background-position:center;background-repeat:none;height:24px;width:24px}.extension-name{color:var(--cr-primary-text-color);display:flex;flex:1;flex-direction:column;justify-content:center;line-height:20px;margin-inline-start:1em;overflow-wrap:break-word}#dialog #buttons{box-shadow:none}</style>
<cr-dialog id="dialog" on-close="onCancel_">
  <div slot="title">$i18n{resolveExtensionUSBDialogTitle}</div>
  <div slot="body">
    <p class="message">
      [[getPermissionMessage_(state_, destination_.extensionName)]]
    </p>
    <div class="extension-desc" hidden="[[isInErrorState_(state_)]]">
      <div class$="throbber-placeholder [[getThrobberClass_(state_)]]"
          role="img" alt=""></div>
      <div class="extension-icon" role="img" alt=""></div>
      <div class="extension-name">
        [[destination_.extensionName]]
      </div>
    </div>
  </div>
  <div slot="button-container" id="buttons">
    <cr-button class="cancel-button" on-click="onCancelClick_">
      $i18n{goBackButton}
    </cr-button>
    <cr-button class="action-button"
        hidden="[[isInErrorState_(state_)]]"
        disabled="[[!isInActiveState_(state_)]]"
        on-click="startResolveDestination_">
      $i18n{selectButton}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var ResolverState;(function(ResolverState){ResolverState["INITIAL"]="INITIAL";ResolverState["ACTIVE"]="ACTIVE";ResolverState["GRANTING_PERMISSION"]="GRANTING_PERMISSION";ResolverState["ERROR"]="ERROR";ResolverState["DONE"]="DONE"})(ResolverState||(ResolverState={}));const PrintPreviewProvisionalDestinationResolverElementBase=I18nMixin(PolymerElement);class PrintPreviewProvisionalDestinationResolverElement extends PrintPreviewProvisionalDestinationResolverElementBase{constructor(){super(...arguments);this.promiseResolver_=null}static get is(){return"print-preview-provisional-destination-resolver"}static get template(){return getTemplate$8()}static get properties(){return{destinationStore:Object,destination_:{type:Object,value:null},state_:{type:String,value:ResolverState.INITIAL}}}ready(){super.ready();this.addEventListener("keydown",(e=>this.onKeydown_(e)))}resolveDestination(destination){this.state_=ResolverState.ACTIVE;this.destination_=destination;this.$.dialog.showModal();const icon=this.shadowRoot.querySelector(".extension-icon");assert(icon);icon.style.backgroundImage="image-set("+"url(chrome://extension-icon/"+this.destination_.extensionId+"/24/1) 1x,"+"url(chrome://extension-icon/"+this.destination_.extensionId+"/48/1) 2x)";this.promiseResolver_=new PromiseResolver;return this.promiseResolver_.promise}startResolveDestination_(){assert(this.state_===ResolverState.ACTIVE,"Invalid state in request grant permission");this.state_=ResolverState.GRANTING_PERMISSION;const destination=this.destination_;this.destinationStore.resolveProvisionalDestination(destination).then((resolvedDestination=>{if(this.state_!==ResolverState.GRANTING_PERMISSION){return}if(destination.id!==this.destination_.id){return}if(resolvedDestination){this.state_=ResolverState.DONE;this.promiseResolver_.resolve(resolvedDestination);this.promiseResolver_=null;this.$.dialog.close()}else{this.state_=ResolverState.ERROR}}))}onKeydown_(e){e.stopPropagation();if(e.key==="Escape"){this.$.dialog.cancel();e.preventDefault()}}onCancelClick_(){this.$.dialog.cancel()}onCancel_(){this.promiseResolver_.reject();this.state_=ResolverState.INITIAL}getPermissionMessage_(){return this.state_===ResolverState.ERROR?this.i18n("resolveExtensionUSBErrorMessage",this.destination_.extensionName):this.i18n("resolveExtensionUSBPermissionMessage")}isInErrorState_(){return this.state_===ResolverState.ERROR}isInActiveState_(){return this.state_===ResolverState.ACTIVE}getThrobberClass_(){return this.state_===ResolverState.GRANTING_PERMISSION?"throbber":""}}customElements.define(PrintPreviewProvisionalDestinationResolverElement.is,PrintPreviewProvisionalDestinationResolverElement);
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/const IronControlState={properties:{focused:{type:Boolean,value:false,notify:true,readOnly:true,reflectToAttribute:true},disabled:{type:Boolean,value:false,notify:true,observer:"_disabledChanged",reflectToAttribute:true},_oldTabIndex:{type:String},_boundFocusBlurHandler:{type:Function,value:function(){return this._focusBlurHandler.bind(this)}}},observers:["_changedControlState(focused, disabled)"],ready:function(){this.addEventListener("focus",this._boundFocusBlurHandler,true);this.addEventListener("blur",this._boundFocusBlurHandler,true)},_focusBlurHandler:function(event){this._setFocused(event.type==="focus");return},_disabledChanged:function(disabled,old){this.setAttribute("aria-disabled",disabled?"true":"false");this.style.pointerEvents=disabled?"none":"";if(disabled){this._oldTabIndex=this.getAttribute("tabindex");this._setFocused(false);this.tabIndex=-1;this.blur()}else if(this._oldTabIndex!==undefined){if(this._oldTabIndex===null){this.removeAttribute("tabindex")}else{this.setAttribute("tabindex",this._oldTabIndex)}}},_changedControlState:function(){if(this._controlStateChanged){this._controlStateChanged()}}};
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/const IronFitBehavior={properties:{sizingTarget:{type:Object,value:function(){return this}},fitInto:{type:Object,value:window},noOverlap:{type:Boolean},positionTarget:{type:Element},horizontalAlign:{type:String},verticalAlign:{type:String},dynamicAlign:{type:Boolean},horizontalOffset:{type:Number,value:0,notify:true},verticalOffset:{type:Number,value:0,notify:true},autoFitOnAttach:{type:Boolean,value:false},_fitInfo:{type:Object}},get _fitWidth(){var fitWidth;if(this.fitInto===window){fitWidth=this.fitInto.innerWidth}else{fitWidth=this.fitInto.getBoundingClientRect().width}return fitWidth},get _fitHeight(){var fitHeight;if(this.fitInto===window){fitHeight=this.fitInto.innerHeight}else{fitHeight=this.fitInto.getBoundingClientRect().height}return fitHeight},get _fitLeft(){var fitLeft;if(this.fitInto===window){fitLeft=0}else{fitLeft=this.fitInto.getBoundingClientRect().left}return fitLeft},get _fitTop(){var fitTop;if(this.fitInto===window){fitTop=0}else{fitTop=this.fitInto.getBoundingClientRect().top}return fitTop},get _defaultPositionTarget(){var parent=dom(this).parentNode;if(parent&&parent.nodeType===Node.DOCUMENT_FRAGMENT_NODE){parent=parent.host}return parent},get _localeHorizontalAlign(){if(this._isRTL){if(this.horizontalAlign==="right"){return"left"}if(this.horizontalAlign==="left"){return"right"}}return this.horizontalAlign},get __shouldPosition(){return(this.horizontalAlign||this.verticalAlign)&&this.positionTarget},attached:function(){if(typeof this._isRTL==="undefined"){this._isRTL=window.getComputedStyle(this).direction=="rtl"}this.positionTarget=this.positionTarget||this._defaultPositionTarget;if(this.autoFitOnAttach){if(window.getComputedStyle(this).display==="none"){setTimeout(function(){this.fit()}.bind(this))}else{window.ShadyDOM&&ShadyDOM.flush();this.fit()}}},detached:function(){if(this.__deferredFit){clearTimeout(this.__deferredFit);this.__deferredFit=null}},fit:function(){this.position();this.constrain();this.center()},_discoverInfo:function(){if(this._fitInfo){return}var target=window.getComputedStyle(this);var sizer=window.getComputedStyle(this.sizingTarget);this._fitInfo={inlineStyle:{top:this.style.top||"",left:this.style.left||"",position:this.style.position||""},sizerInlineStyle:{maxWidth:this.sizingTarget.style.maxWidth||"",maxHeight:this.sizingTarget.style.maxHeight||"",boxSizing:this.sizingTarget.style.boxSizing||""},positionedBy:{vertically:target.top!=="auto"?"top":target.bottom!=="auto"?"bottom":null,horizontally:target.left!=="auto"?"left":target.right!=="auto"?"right":null},sizedBy:{height:sizer.maxHeight!=="none",width:sizer.maxWidth!=="none",minWidth:parseInt(sizer.minWidth,10)||0,minHeight:parseInt(sizer.minHeight,10)||0},margin:{top:parseInt(target.marginTop,10)||0,right:parseInt(target.marginRight,10)||0,bottom:parseInt(target.marginBottom,10)||0,left:parseInt(target.marginLeft,10)||0}}},resetFit:function(){var info=this._fitInfo||{};for(var property in info.sizerInlineStyle){this.sizingTarget.style[property]=info.sizerInlineStyle[property]}for(var property in info.inlineStyle){this.style[property]=info.inlineStyle[property]}this._fitInfo=null},refit:function(){var scrollLeft=this.sizingTarget.scrollLeft;var scrollTop=this.sizingTarget.scrollTop;this.resetFit();this.fit();this.sizingTarget.scrollLeft=scrollLeft;this.sizingTarget.scrollTop=scrollTop},position:function(){if(!this.__shouldPosition){return}this._discoverInfo();this.style.position="fixed";this.sizingTarget.style.boxSizing="border-box";this.style.left="0px";this.style.top="0px";var rect=this.getBoundingClientRect();var positionRect=this.__getNormalizedRect(this.positionTarget);var fitRect=this.__getNormalizedRect(this.fitInto);var margin=this._fitInfo.margin;var size={width:rect.width+margin.left+margin.right,height:rect.height+margin.top+margin.bottom};var position=this.__getPosition(this._localeHorizontalAlign,this.verticalAlign,size,rect,positionRect,fitRect);var left=position.left+margin.left;var top=position.top+margin.top;var right=Math.min(fitRect.right-margin.right,left+rect.width);var bottom=Math.min(fitRect.bottom-margin.bottom,top+rect.height);left=Math.max(fitRect.left+margin.left,Math.min(left,right-this._fitInfo.sizedBy.minWidth));top=Math.max(fitRect.top+margin.top,Math.min(top,bottom-this._fitInfo.sizedBy.minHeight));this.sizingTarget.style.maxWidth=Math.max(right-left,this._fitInfo.sizedBy.minWidth)+"px";this.sizingTarget.style.maxHeight=Math.max(bottom-top,this._fitInfo.sizedBy.minHeight)+"px";this.style.left=left-rect.left+"px";this.style.top=top-rect.top+"px"},constrain:function(){if(this.__shouldPosition){return}this._discoverInfo();var info=this._fitInfo;if(!info.positionedBy.vertically){this.style.position="fixed";this.style.top="0px"}if(!info.positionedBy.horizontally){this.style.position="fixed";this.style.left="0px"}this.sizingTarget.style.boxSizing="border-box";var rect=this.getBoundingClientRect();if(!info.sizedBy.height){this.__sizeDimension(rect,info.positionedBy.vertically,"top","bottom","Height")}if(!info.sizedBy.width){this.__sizeDimension(rect,info.positionedBy.horizontally,"left","right","Width")}},_sizeDimension:function(rect,positionedBy,start,end,extent){this.__sizeDimension(rect,positionedBy,start,end,extent)},__sizeDimension:function(rect,positionedBy,start,end,extent){var info=this._fitInfo;var fitRect=this.__getNormalizedRect(this.fitInto);var max=extent==="Width"?fitRect.width:fitRect.height;var flip=positionedBy===end;var offset=flip?max-rect[end]:rect[start];var margin=info.margin[flip?start:end];var offsetExtent="offset"+extent;var sizingOffset=this[offsetExtent]-this.sizingTarget[offsetExtent];this.sizingTarget.style["max"+extent]=max-margin-offset-sizingOffset+"px"},center:function(){if(this.__shouldPosition){return}this._discoverInfo();var positionedBy=this._fitInfo.positionedBy;if(positionedBy.vertically&&positionedBy.horizontally){return}this.style.position="fixed";if(!positionedBy.vertically){this.style.top="0px"}if(!positionedBy.horizontally){this.style.left="0px"}var rect=this.getBoundingClientRect();var fitRect=this.__getNormalizedRect(this.fitInto);if(!positionedBy.vertically){var top=fitRect.top-rect.top+(fitRect.height-rect.height)/2;this.style.top=top+"px"}if(!positionedBy.horizontally){var left=fitRect.left-rect.left+(fitRect.width-rect.width)/2;this.style.left=left+"px"}},__getNormalizedRect:function(target){if(target===document.documentElement||target===window){return{top:0,left:0,width:window.innerWidth,height:window.innerHeight,right:window.innerWidth,bottom:window.innerHeight}}return target.getBoundingClientRect()},__getOffscreenArea:function(position,size,fitRect){var verticalCrop=Math.min(0,position.top)+Math.min(0,fitRect.bottom-(position.top+size.height));var horizontalCrop=Math.min(0,position.left)+Math.min(0,fitRect.right-(position.left+size.width));return Math.abs(verticalCrop)*size.width+Math.abs(horizontalCrop)*size.height},__getPosition:function(hAlign,vAlign,size,sizeNoMargins,positionRect,fitRect){var positions=[{verticalAlign:"top",horizontalAlign:"left",top:positionRect.top+this.verticalOffset,left:positionRect.left+this.horizontalOffset},{verticalAlign:"top",horizontalAlign:"right",top:positionRect.top+this.verticalOffset,left:positionRect.right-size.width-this.horizontalOffset},{verticalAlign:"bottom",horizontalAlign:"left",top:positionRect.bottom-size.height-this.verticalOffset,left:positionRect.left+this.horizontalOffset},{verticalAlign:"bottom",horizontalAlign:"right",top:positionRect.bottom-size.height-this.verticalOffset,left:positionRect.right-size.width-this.horizontalOffset}];if(this.noOverlap){for(var i=0,l=positions.length;i<l;i++){var copy={};for(var key in positions[i]){copy[key]=positions[i][key]}positions.push(copy)}positions[0].top=positions[1].top+=positionRect.height;positions[2].top=positions[3].top-=positionRect.height;positions[4].left=positions[6].left+=positionRect.width;positions[5].left=positions[7].left-=positionRect.width}vAlign=vAlign==="auto"?null:vAlign;hAlign=hAlign==="auto"?null:hAlign;if(!hAlign||hAlign==="center"){positions.push({verticalAlign:"top",horizontalAlign:"center",top:positionRect.top+this.verticalOffset+(this.noOverlap?positionRect.height:0),left:positionRect.left-sizeNoMargins.width/2+positionRect.width/2+this.horizontalOffset});positions.push({verticalAlign:"bottom",horizontalAlign:"center",top:positionRect.bottom-size.height-this.verticalOffset-(this.noOverlap?positionRect.height:0),left:positionRect.left-sizeNoMargins.width/2+positionRect.width/2+this.horizontalOffset})}if(!vAlign||vAlign==="middle"){positions.push({verticalAlign:"middle",horizontalAlign:"left",top:positionRect.top-sizeNoMargins.height/2+positionRect.height/2+this.verticalOffset,left:positionRect.left+this.horizontalOffset+(this.noOverlap?positionRect.width:0)});positions.push({verticalAlign:"middle",horizontalAlign:"right",top:positionRect.top-sizeNoMargins.height/2+positionRect.height/2+this.verticalOffset,left:positionRect.right-size.width-this.horizontalOffset-(this.noOverlap?positionRect.width:0)})}if(vAlign==="middle"&&hAlign==="center"){positions.push({verticalAlign:"middle",horizontalAlign:"center",top:positionRect.top-sizeNoMargins.height/2+positionRect.height/2+this.verticalOffset,left:positionRect.left-sizeNoMargins.width/2+positionRect.width/2+this.horizontalOffset})}var position;for(var i=0;i<positions.length;i++){var candidate=positions[i];var vAlignOk=candidate.verticalAlign===vAlign;var hAlignOk=candidate.horizontalAlign===hAlign;if(!this.dynamicAlign&&!this.noOverlap&&vAlignOk&&hAlignOk){position=candidate;break}var alignOk=(!vAlign||vAlignOk)&&(!hAlign||hAlignOk);if(!this.dynamicAlign&&!alignOk){continue}candidate.offscreenArea=this.__getOffscreenArea(candidate,size,fitRect);if(candidate.offscreenArea===0&&alignOk){position=candidate;break}position=position||candidate;var diff=candidate.offscreenArea-position.offscreenArea;if(diff<0||diff===0&&(vAlignOk||hAlignOk)){position=candidate}}return position}};
/**
@license
Copyright (c) 2016 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/var p=Element.prototype;var matches=p.matches||p.matchesSelector||p.mozMatchesSelector||p.msMatchesSelector||p.oMatchesSelector||p.webkitMatchesSelector;const IronFocusablesHelper={getTabbableNodes:function(node){var result=[];var needsSortByTabIndex=this._collectTabbableNodes(node,result);if(needsSortByTabIndex){return this._sortByTabIndex(result)}return result},isFocusable:function(element){if(matches.call(element,"input, select, textarea, button, object")){return matches.call(element,":not([disabled])")}return matches.call(element,"a[href], area[href], iframe, [tabindex], [contentEditable]")},isTabbable:function(element){return this.isFocusable(element)&&matches.call(element,':not([tabindex="-1"])')&&this._isVisible(element)},_normalizedTabIndex:function(element){if(this.isFocusable(element)){var tabIndex=element.getAttribute("tabindex")||0;return Number(tabIndex)}return-1},_collectTabbableNodes:function(node,result){if(node.nodeType!==Node.ELEMENT_NODE||!this._isVisible(node)){return false}var element=node;var tabIndex=this._normalizedTabIndex(element);var needsSort=tabIndex>0;if(tabIndex>=0){result.push(element)}var children;if(element.localName==="content"||element.localName==="slot"){children=dom(element).getDistributedNodes()}else{children=dom(element.root||element).children}for(var i=0;i<children.length;i++){needsSort=this._collectTabbableNodes(children[i],result)||needsSort}return needsSort},_isVisible:function(element){var style=element.style;if(style.visibility!=="hidden"&&style.display!=="none"){style=window.getComputedStyle(element);return style.visibility!=="hidden"&&style.display!=="none"}return false},_sortByTabIndex:function(tabbables){var len=tabbables.length;if(len<2){return tabbables}var pivot=Math.ceil(len/2);var left=this._sortByTabIndex(tabbables.slice(0,pivot));var right=this._sortByTabIndex(tabbables.slice(pivot));return this._mergeSortByTabIndex(left,right)},_mergeSortByTabIndex:function(left,right){var result=[];while(left.length>0&&right.length>0){if(this._hasLowerTabOrder(left[0],right[0])){result.push(right.shift())}else{result.push(left.shift())}}return result.concat(left,right)},_hasLowerTabOrder:function(a,b){var ati=Math.max(a.tabIndex,0);var bti=Math.max(b.tabIndex,0);return ati===0||bti===0?bti>ati:ati>bti}};
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/Polymer({_template:html$1`
    <style>
      :host {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: var(--iron-overlay-backdrop-background-color, #000);
        opacity: 0;
        transition: opacity 0.2s;
        pointer-events: none;
      }

      :host(.opened) {
        opacity: var(--iron-overlay-backdrop-opacity, 0.6);
        pointer-events: auto;
      }
    </style>

    <slot></slot>
`,is:"iron-overlay-backdrop",properties:{opened:{reflectToAttribute:true,type:Boolean,value:false,observer:"_openedChanged"}},listeners:{transitionend:"_onTransitionend"},created:function(){this.__openedRaf=null},attached:function(){this.opened&&this._openedChanged(this.opened)},prepare:function(){if(this.opened&&!this.parentNode){dom(document.body).appendChild(this)}},open:function(){this.opened=true},close:function(){this.opened=false},complete:function(){if(!this.opened&&this.parentNode===document.body){dom(this.parentNode).removeChild(this)}},_onTransitionend:function(event){if(event&&event.target===this){this.complete()}},_openedChanged:function(opened){if(opened){this.prepare()}else{var cs=window.getComputedStyle(this);if(cs.transitionDuration==="0s"||cs.opacity==0){this.complete()}}if(!this.isAttached){return}if(this.__openedRaf){window.cancelAnimationFrame(this.__openedRaf);this.__openedRaf=null}this.scrollTop=this.scrollTop;this.__openedRaf=window.requestAnimationFrame(function(){this.__openedRaf=null;this.toggleClass("opened",this.opened)}.bind(this))}});
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/const IronOverlayManagerClass=function(){this._overlays=[];this._minimumZ=101;this._backdropElement=null;gestures.add(document.documentElement,"tap",(function(){}));document.addEventListener("tap",this._onCaptureClick.bind(this),true);document.addEventListener("focus",this._onCaptureFocus.bind(this),true);document.addEventListener("keydown",this._onCaptureKeyDown.bind(this),true)};IronOverlayManagerClass.prototype={constructor:IronOverlayManagerClass,get backdropElement(){if(!this._backdropElement){this._backdropElement=document.createElement("iron-overlay-backdrop")}return this._backdropElement},get deepActiveElement(){var active=document.activeElement;if(!active||active instanceof Element===false){active=document.body}while(active.root&&dom(active.root).activeElement){active=dom(active.root).activeElement}return active},_bringOverlayAtIndexToFront:function(i){var overlay=this._overlays[i];if(!overlay){return}var lastI=this._overlays.length-1;var currentOverlay=this._overlays[lastI];if(currentOverlay&&this._shouldBeBehindOverlay(overlay,currentOverlay)){lastI--}if(i>=lastI){return}var minimumZ=Math.max(this.currentOverlayZ(),this._minimumZ);if(this._getZ(overlay)<=minimumZ){this._applyOverlayZ(overlay,minimumZ)}while(i<lastI){this._overlays[i]=this._overlays[i+1];i++}this._overlays[lastI]=overlay},addOrRemoveOverlay:function(overlay){if(overlay.opened){this.addOverlay(overlay)}else{this.removeOverlay(overlay)}},addOverlay:function(overlay){var i=this._overlays.indexOf(overlay);if(i>=0){this._bringOverlayAtIndexToFront(i);this.trackBackdrop();return}var insertionIndex=this._overlays.length;var currentOverlay=this._overlays[insertionIndex-1];var minimumZ=Math.max(this._getZ(currentOverlay),this._minimumZ);var newZ=this._getZ(overlay);if(currentOverlay&&this._shouldBeBehindOverlay(overlay,currentOverlay)){this._applyOverlayZ(currentOverlay,minimumZ);insertionIndex--;var previousOverlay=this._overlays[insertionIndex-1];minimumZ=Math.max(this._getZ(previousOverlay),this._minimumZ)}if(newZ<=minimumZ){this._applyOverlayZ(overlay,minimumZ)}this._overlays.splice(insertionIndex,0,overlay);this.trackBackdrop()},removeOverlay:function(overlay){var i=this._overlays.indexOf(overlay);if(i===-1){return}this._overlays.splice(i,1);this.trackBackdrop()},currentOverlay:function(){var i=this._overlays.length-1;return this._overlays[i]},currentOverlayZ:function(){return this._getZ(this.currentOverlay())},ensureMinimumZ:function(minimumZ){this._minimumZ=Math.max(this._minimumZ,minimumZ)},focusOverlay:function(){var current=this.currentOverlay();if(current){current._applyFocus()}},trackBackdrop:function(){var overlay=this._overlayWithBackdrop();if(!overlay&&!this._backdropElement){return}this.backdropElement.style.zIndex=this._getZ(overlay)-1;this.backdropElement.opened=!!overlay;this.backdropElement.prepare()},getBackdrops:function(){var backdrops=[];for(var i=0;i<this._overlays.length;i++){if(this._overlays[i].withBackdrop){backdrops.push(this._overlays[i])}}return backdrops},backdropZ:function(){return this._getZ(this._overlayWithBackdrop())-1},_overlayWithBackdrop:function(){for(var i=this._overlays.length-1;i>=0;i--){if(this._overlays[i].withBackdrop){return this._overlays[i]}}},_getZ:function(overlay){var z=this._minimumZ;if(overlay){var z1=Number(overlay.style.zIndex||window.getComputedStyle(overlay).zIndex);if(z1===z1){z=z1}}return z},_setZ:function(element,z){element.style.zIndex=z},_applyOverlayZ:function(overlay,aboveZ){this._setZ(overlay,aboveZ+2)},_overlayInPath:function(path){path=path||[];for(var i=0;i<path.length;i++){if(path[i]._manager===this){return path[i]}}},_onCaptureClick:function(event){var i=this._overlays.length-1;if(i===-1)return;var path=dom(event).path;var overlay;while((overlay=this._overlays[i])&&this._overlayInPath(path)!==overlay){overlay._onCaptureClick(event);if(overlay.allowClickThrough){i--}else{break}}},_onCaptureFocus:function(event){var overlay=this.currentOverlay();if(overlay){overlay._onCaptureFocus(event)}},_onCaptureKeyDown:function(event){var overlay=this.currentOverlay();if(overlay){if(IronA11yKeysBehavior.keyboardEventMatchesKeys(event,"esc")){overlay._onCaptureEsc(event)}else if(IronA11yKeysBehavior.keyboardEventMatchesKeys(event,"tab")){overlay._onCaptureTab(event)}}},_shouldBeBehindOverlay:function(overlay1,overlay2){return!overlay1.alwaysOnTop&&overlay2.alwaysOnTop}};const IronOverlayManager=new IronOverlayManagerClass;
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/var lastTouchPosition={pageX:0,pageY:0};var lastRootTarget=null;var lastScrollableNodes=[];var scrollEvents=["wheel","mousewheel","DOMMouseScroll","touchstart","touchmove"];var _boundScrollHandler;var currentLockingElement;function pushScrollLock(element){if(_lockingElements.indexOf(element)>=0){return}if(_lockingElements.length===0){_lockScrollInteractions()}_lockingElements.push(element);currentLockingElement=_lockingElements[_lockingElements.length-1]}function removeScrollLock(element){var index=_lockingElements.indexOf(element);if(index===-1){return}_lockingElements.splice(index,1);currentLockingElement=_lockingElements[_lockingElements.length-1];if(_lockingElements.length===0){_unlockScrollInteractions()}}const _lockingElements=[];function _scrollInteractionHandler(event){if(event.cancelable&&_shouldPreventScrolling(event)){event.preventDefault()}if(event.targetTouches){var touch=event.targetTouches[0];lastTouchPosition.pageX=touch.pageX;lastTouchPosition.pageY=touch.pageY}}function _lockScrollInteractions(){_boundScrollHandler=_boundScrollHandler||_scrollInteractionHandler.bind(undefined);for(var i=0,l=scrollEvents.length;i<l;i++){document.addEventListener(scrollEvents[i],_boundScrollHandler,{capture:true,passive:false})}}function _unlockScrollInteractions(){for(var i=0,l=scrollEvents.length;i<l;i++){document.removeEventListener(scrollEvents[i],_boundScrollHandler,{capture:true,passive:false})}}function _shouldPreventScrolling(event){var target=dom(event).rootTarget;if(event.type!=="touchmove"&&lastRootTarget!==target){lastRootTarget=target;lastScrollableNodes=_getScrollableNodes(dom(event).path)}if(!lastScrollableNodes.length){return true}if(event.type==="touchstart"){return false}var info=_getScrollInfo(event);return!_getScrollingNode(lastScrollableNodes,info.deltaX,info.deltaY)}function _getScrollableNodes(nodes){var scrollables=[];var lockingIndex=nodes.indexOf(currentLockingElement);for(var i=0;i<=lockingIndex;i++){if(nodes[i].nodeType!==Node.ELEMENT_NODE){continue}var node=nodes[i];var style=node.style;if(style.overflow!=="scroll"&&style.overflow!=="auto"){style=window.getComputedStyle(node)}if(style.overflow==="scroll"||style.overflow==="auto"){scrollables.push(node)}}return scrollables}function _getScrollingNode(nodes,deltaX,deltaY){if(!deltaX&&!deltaY){return}var verticalScroll=Math.abs(deltaY)>=Math.abs(deltaX);for(var i=0;i<nodes.length;i++){var node=nodes[i];var canScroll=false;if(verticalScroll){canScroll=deltaY<0?node.scrollTop>0:node.scrollTop<node.scrollHeight-node.clientHeight}else{canScroll=deltaX<0?node.scrollLeft>0:node.scrollLeft<node.scrollWidth-node.clientWidth}if(canScroll){return node}}}function _getScrollInfo(event){var info={deltaX:event.deltaX,deltaY:event.deltaY};if("deltaX"in event);else if("wheelDeltaX"in event&&"wheelDeltaY"in event){info.deltaX=-event.wheelDeltaX;info.deltaY=-event.wheelDeltaY}else if("wheelDelta"in event){info.deltaX=0;info.deltaY=-event.wheelDelta}else if("axis"in event){info.deltaX=event.axis===1?event.detail:0;info.deltaY=event.axis===2?event.detail:0}else if(event.targetTouches){var touch=event.targetTouches[0];info.deltaX=lastTouchPosition.pageX-touch.pageX;info.deltaY=lastTouchPosition.pageY-touch.pageY}return info}
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/const IronOverlayBehaviorImpl={properties:{opened:{observer:"_openedChanged",type:Boolean,value:false,notify:true},canceled:{observer:"_canceledChanged",readOnly:true,type:Boolean,value:false},withBackdrop:{observer:"_withBackdropChanged",type:Boolean},noAutoFocus:{type:Boolean,value:false},noCancelOnEscKey:{type:Boolean,value:false},noCancelOnOutsideClick:{type:Boolean,value:false},closingReason:{type:Object},restoreFocusOnClose:{type:Boolean,value:false},allowClickThrough:{type:Boolean},alwaysOnTop:{type:Boolean},scrollAction:{type:String},_manager:{type:Object,value:IronOverlayManager},_focusedChild:{type:Object}},listeners:{"iron-resize":"_onIronResize"},observers:["__updateScrollObservers(isAttached, opened, scrollAction)"],get backdropElement(){return this._manager.backdropElement},get _focusNode(){return this._focusedChild||dom(this).querySelector("[autofocus]")||this},get _focusableNodes(){return IronFocusablesHelper.getTabbableNodes(this)},ready:function(){this.__isAnimating=false;this.__shouldRemoveTabIndex=false;this.__firstFocusableNode=this.__lastFocusableNode=null;this.__rafs={};this.__restoreFocusNode=null;this.__scrollTop=this.__scrollLeft=null;this.__onCaptureScroll=this.__onCaptureScroll.bind(this);this.__rootNodes=null;this._ensureSetup()},attached:function(){if(this.opened){this._openedChanged(this.opened)}this._observer=dom(this).observeNodes(this._onNodesChange)},detached:function(){dom(this).unobserveNodes(this._observer);this._observer=null;for(var cb in this.__rafs){if(this.__rafs[cb]!==null){cancelAnimationFrame(this.__rafs[cb])}}this.__rafs={};this._manager.removeOverlay(this);if(this.__isAnimating){if(this.opened){this._finishRenderOpened()}else{this._applyFocus();this._finishRenderClosed()}}},toggle:function(){this._setCanceled(false);this.opened=!this.opened},open:function(){this._setCanceled(false);this.opened=true},close:function(){this._setCanceled(false);this.opened=false},cancel:function(event){var cancelEvent=this.fire("iron-overlay-canceled",event,{cancelable:true});if(cancelEvent.defaultPrevented){return}this._setCanceled(true);this.opened=false},invalidateTabbables:function(){this.__firstFocusableNode=this.__lastFocusableNode=null},_ensureSetup:function(){if(this._overlaySetup){return}this._overlaySetup=true;this.style.outline="none";this.style.display="none"},_openedChanged:function(opened){if(opened){this.removeAttribute("aria-hidden")}else{this.setAttribute("aria-hidden","true")}if(!this.isAttached){return}this.__isAnimating=true;this.__deraf("__openedChanged",this.__openedChanged)},_canceledChanged:function(){this.closingReason=this.closingReason||{};this.closingReason.canceled=this.canceled},_withBackdropChanged:function(){if(this.withBackdrop&&!this.hasAttribute("tabindex")){this.setAttribute("tabindex","-1");this.__shouldRemoveTabIndex=true}else if(this.__shouldRemoveTabIndex){this.removeAttribute("tabindex");this.__shouldRemoveTabIndex=false}if(this.opened&&this.isAttached){this._manager.trackBackdrop()}},_prepareRenderOpened:function(){this.__restoreFocusNode=this._manager.deepActiveElement;this._preparePositioning();this.refit();this._finishPositioning();if(this.noAutoFocus&&document.activeElement===this._focusNode){this._focusNode.blur();this.__restoreFocusNode.focus()}},_renderOpened:function(){this._finishRenderOpened()},_renderClosed:function(){this._finishRenderClosed()},_finishRenderOpened:function(){this.notifyResize();this.__isAnimating=false;this.fire("iron-overlay-opened")},_finishRenderClosed:function(){this.style.display="none";this.style.zIndex="";this.notifyResize();this.__isAnimating=false;this.fire("iron-overlay-closed",this.closingReason)},_preparePositioning:function(){this.style.transition=this.style.webkitTransition="none";this.style.transform=this.style.webkitTransform="none";this.style.display=""},_finishPositioning:function(){this.style.display="none";this.scrollTop=this.scrollTop;this.style.transition=this.style.webkitTransition="";this.style.transform=this.style.webkitTransform="";this.style.display="";this.scrollTop=this.scrollTop},_applyFocus:function(){if(this.opened){if(!this.noAutoFocus){this._focusNode.focus()}}else{if(this.restoreFocusOnClose&&this.__restoreFocusNode){var activeElement=this._manager.deepActiveElement;if(activeElement===document.body||dom(this).deepContains(activeElement)){this.__restoreFocusNode.focus()}}this.__restoreFocusNode=null;this._focusNode.blur();this._focusedChild=null}},_onCaptureClick:function(event){if(!this.noCancelOnOutsideClick){this.cancel(event)}},_onCaptureFocus:function(event){if(!this.withBackdrop){return}var path=dom(event).path;if(path.indexOf(this)===-1){event.stopPropagation();this._applyFocus()}else{this._focusedChild=path[0]}},_onCaptureEsc:function(event){if(!this.noCancelOnEscKey){this.cancel(event)}},_onCaptureTab:function(event){if(!this.withBackdrop){return}this.__ensureFirstLastFocusables();var shift=event.shiftKey;var nodeToCheck=shift?this.__firstFocusableNode:this.__lastFocusableNode;var nodeToSet=shift?this.__lastFocusableNode:this.__firstFocusableNode;var shouldWrap=false;if(nodeToCheck===nodeToSet){shouldWrap=true}else{var focusedNode=this._manager.deepActiveElement;shouldWrap=focusedNode===nodeToCheck||focusedNode===this}if(shouldWrap){event.preventDefault();this._focusedChild=nodeToSet;this._applyFocus()}},_onIronResize:function(){if(this.opened&&!this.__isAnimating){this.__deraf("refit",this.refit)}},_onNodesChange:function(){if(this.opened&&!this.__isAnimating){this.invalidateTabbables();this.notifyResize()}},__ensureFirstLastFocusables:function(){var focusableNodes=this._focusableNodes;this.__firstFocusableNode=focusableNodes[0];this.__lastFocusableNode=focusableNodes[focusableNodes.length-1]},__openedChanged:function(){if(this.opened){this._prepareRenderOpened();this._manager.addOverlay(this);this._applyFocus();this._renderOpened()}else{this._manager.removeOverlay(this);this._applyFocus();this._renderClosed()}},__deraf:function(jobname,callback){var rafs=this.__rafs;if(rafs[jobname]!==null){cancelAnimationFrame(rafs[jobname])}rafs[jobname]=requestAnimationFrame(function nextAnimationFrame(){rafs[jobname]=null;callback.call(this)}.bind(this))},__updateScrollObservers:function(isAttached,opened,scrollAction){if(!isAttached||!opened||!this.__isValidScrollAction(scrollAction)){removeScrollLock(this);this.__removeScrollListeners()}else{if(scrollAction==="lock"){this.__saveScrollPosition();pushScrollLock(this)}this.__addScrollListeners()}},__addScrollListeners:function(){if(!this.__rootNodes){this.__rootNodes=[];if(useShadow){var node=this;while(node){if(node.nodeType===Node.DOCUMENT_FRAGMENT_NODE&&node.host){this.__rootNodes.push(node)}node=node.host||node.assignedSlot||node.parentNode}}this.__rootNodes.push(document)}this.__rootNodes.forEach((function(el){el.addEventListener("scroll",this.__onCaptureScroll,{capture:true,passive:true})}),this)},__removeScrollListeners:function(){if(this.__rootNodes){this.__rootNodes.forEach((function(el){el.removeEventListener("scroll",this.__onCaptureScroll,{capture:true,passive:true})}),this)}if(!this.isAttached){this.__rootNodes=null}},__isValidScrollAction:function(scrollAction){return scrollAction==="lock"||scrollAction==="refit"||scrollAction==="cancel"},__onCaptureScroll:function(event){if(this.__isAnimating){return}if(dom(event).path.indexOf(this)>=0){return}switch(this.scrollAction){case"lock":this.__restoreScrollPosition();break;case"refit":this.__deraf("refit",this.refit);break;case"cancel":this.cancel(event);break}},__saveScrollPosition:function(){if(document.scrollingElement){this.__scrollTop=document.scrollingElement.scrollTop;this.__scrollLeft=document.scrollingElement.scrollLeft}else{this.__scrollTop=Math.max(document.documentElement.scrollTop,document.body.scrollTop);this.__scrollLeft=Math.max(document.documentElement.scrollLeft,document.body.scrollLeft)}},__restoreScrollPosition:function(){if(document.scrollingElement){document.scrollingElement.scrollTop=this.__scrollTop;document.scrollingElement.scrollLeft=this.__scrollLeft}else{document.documentElement.scrollTop=document.body.scrollTop=this.__scrollTop;document.documentElement.scrollLeft=document.body.scrollLeft=this.__scrollLeft}}};const IronOverlayBehavior=[IronFitBehavior,IronResizableBehavior,IronOverlayBehaviorImpl];
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/const NeonAnimatableBehavior={properties:{animationConfig:{type:Object},entryAnimation:{observer:"_entryAnimationChanged",type:String},exitAnimation:{observer:"_exitAnimationChanged",type:String}},_entryAnimationChanged:function(){this.animationConfig=this.animationConfig||{};this.animationConfig["entry"]=[{name:this.entryAnimation,node:this}]},_exitAnimationChanged:function(){this.animationConfig=this.animationConfig||{};this.animationConfig["exit"]=[{name:this.exitAnimation,node:this}]},_copyProperties:function(config1,config2){for(var property in config2){config1[property]=config2[property]}},_cloneConfig:function(config){var clone={isClone:true};this._copyProperties(clone,config);return clone},_getAnimationConfigRecursive:function(type,map,allConfigs){if(!this.animationConfig){return}if(this.animationConfig.value&&typeof this.animationConfig.value==="function"){this._warn(this._logf("playAnimation","Please put 'animationConfig' inside of your components 'properties' object instead of outside of it."));return}var thisConfig;if(type){thisConfig=this.animationConfig[type]}else{thisConfig=this.animationConfig}if(!Array.isArray(thisConfig)){thisConfig=[thisConfig]}if(thisConfig){for(var config,index=0;config=thisConfig[index];index++){if(config.animatable){config.animatable._getAnimationConfigRecursive(config.type||type,map,allConfigs)}else{if(config.id){var cachedConfig=map[config.id];if(cachedConfig){if(!cachedConfig.isClone){map[config.id]=this._cloneConfig(cachedConfig);cachedConfig=map[config.id]}this._copyProperties(cachedConfig,config)}else{map[config.id]=config}}else{allConfigs.push(config)}}}}},getAnimationConfig:function(type){var map={};var allConfigs=[];this._getAnimationConfigRecursive(type,map,allConfigs);for(var key in map){allConfigs.push(map[key])}return allConfigs}};
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/const NeonAnimationRunnerBehaviorImpl={_configureAnimations:function(configs){var results=[];var resultsToPlay=[];if(configs.length>0){for(let config,index=0;config=configs[index];index++){let neonAnimation=document.createElement(config.name);if(neonAnimation.isNeonAnimation){let result=null;if(!neonAnimation.configure){neonAnimation.configure=function(config){return null}}result=neonAnimation.configure(config);resultsToPlay.push({result:result,config:config,neonAnimation:neonAnimation})}else{console.warn(this.is+":",config.name,"not found!")}}}for(var i=0;i<resultsToPlay.length;i++){let result=resultsToPlay[i].result;let config=resultsToPlay[i].config;let neonAnimation=resultsToPlay[i].neonAnimation;try{if(typeof result.cancel!="function"){result=document.timeline.play(result)}}catch(e){result=null;console.warn("Couldnt play","(",config.name,").",e)}if(result){results.push({neonAnimation:neonAnimation,config:config,animation:result})}}return results},_shouldComplete:function(activeEntries){var finished=true;for(var i=0;i<activeEntries.length;i++){if(activeEntries[i].animation.playState!="finished"){finished=false;break}}return finished},_complete:function(activeEntries){for(var i=0;i<activeEntries.length;i++){activeEntries[i].neonAnimation.complete(activeEntries[i].config)}for(var i=0;i<activeEntries.length;i++){activeEntries[i].animation.cancel()}},playAnimation:function(type,cookie){var configs=this.getAnimationConfig(type);if(!configs){return}this._active=this._active||{};if(this._active[type]){this._complete(this._active[type]);delete this._active[type]}var activeEntries=this._configureAnimations(configs);if(activeEntries.length==0){this.fire("neon-animation-finish",cookie,{bubbles:false});return}this._active[type]=activeEntries;for(var i=0;i<activeEntries.length;i++){activeEntries[i].animation.onfinish=function(){if(this._shouldComplete(activeEntries)){this._complete(activeEntries);delete this._active[type];this.fire("neon-animation-finish",cookie,{bubbles:false})}}.bind(this)}},cancelAnimation:function(){for(var k in this._active){var entries=this._active[k];for(var j in entries){entries[j].animation.cancel()}}this._active={}}};const NeonAnimationRunnerBehavior=[NeonAnimatableBehavior,NeonAnimationRunnerBehaviorImpl];
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/Polymer({_template:html$1`
    <style>
      :host {
        position: fixed;
      }

      #contentWrapper ::slotted(*) {
        overflow: auto;
      }

      #contentWrapper.animating ::slotted(*) {
        overflow: hidden;
        pointer-events: none;
      }
    </style>

    <div id="contentWrapper">
      <slot id="content" name="dropdown-content"></slot>
    </div>
`,is:"iron-dropdown",behaviors:[IronControlState,IronA11yKeysBehavior,IronOverlayBehavior,NeonAnimationRunnerBehavior],properties:{horizontalAlign:{type:String,value:"left",reflectToAttribute:true},verticalAlign:{type:String,value:"top",reflectToAttribute:true},openAnimationConfig:{type:Object},closeAnimationConfig:{type:Object},focusTarget:{type:Object},noAnimations:{type:Boolean,value:false},allowOutsideScroll:{type:Boolean,value:false,observer:"_allowOutsideScrollChanged"}},listeners:{"neon-animation-finish":"_onNeonAnimationFinish"},observers:["_updateOverlayPosition(positionTarget, verticalAlign, horizontalAlign, verticalOffset, horizontalOffset)"],get containedElement(){var nodes=dom(this.$.content).getDistributedNodes();for(var i=0,l=nodes.length;i<l;i++){if(nodes[i].nodeType===Node.ELEMENT_NODE){return nodes[i]}}},ready:function(){if(!this.scrollAction){this.scrollAction=this.allowOutsideScroll?"refit":"lock"}this._readied=true},attached:function(){if(!this.sizingTarget||this.sizingTarget===this){this.sizingTarget=this.containedElement||this}},detached:function(){this.cancelAnimation()},_openedChanged:function(){if(this.opened&&this.disabled){this.cancel()}else{this.cancelAnimation();this._updateAnimationConfig();IronOverlayBehaviorImpl._openedChanged.apply(this,arguments)}},_renderOpened:function(){if(!this.noAnimations&&this.animationConfig.open){this.$.contentWrapper.classList.add("animating");this.playAnimation("open")}else{IronOverlayBehaviorImpl._renderOpened.apply(this,arguments)}},_renderClosed:function(){if(!this.noAnimations&&this.animationConfig.close){this.$.contentWrapper.classList.add("animating");this.playAnimation("close")}else{IronOverlayBehaviorImpl._renderClosed.apply(this,arguments)}},_onNeonAnimationFinish:function(){this.$.contentWrapper.classList.remove("animating");if(this.opened){this._finishRenderOpened()}else{this._finishRenderClosed()}},_updateAnimationConfig:function(){var animationNode=this.containedElement;var animations=[].concat(this.openAnimationConfig||[]).concat(this.closeAnimationConfig||[]);for(var i=0;i<animations.length;i++){animations[i].node=animationNode}this.animationConfig={open:this.openAnimationConfig,close:this.closeAnimationConfig}},_updateOverlayPosition:function(){if(this.isAttached){this.notifyResize()}},_allowOutsideScrollChanged:function(allowOutsideScroll){if(!this._readied){return}if(!allowOutsideScroll){this.scrollAction="lock"}else if(!this.scrollAction||this.scrollAction==="lock"){this.scrollAction="refit"}},_applyFocus:function(){var focusTarget=this.focusTarget||this.containedElement;if(focusTarget&&this.opened&&!this.noAutoFocus){focusTarget.focus()}else{IronOverlayBehaviorImpl._applyFocus.apply(this,arguments)}}});
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/const template$1=html$1`<dom-module id="paper-spinner-styles">
  <template>
    <style>
      /*
      /**************************/
      /* STYLES FOR THE SPINNER */
      /**************************/

      /*
       * Constants:
       *      ARCSIZE     = 270 degrees (amount of circle the arc takes up)
       *      ARCTIME     = 1333ms (time it takes to expand and contract arc)
       *      ARCSTARTROT = 216 degrees (how much the start location of the arc
       *                                should rotate each time, 216 gives us a
       *                                5 pointed star shape (it's 360/5 * 3).
       *                                For a 7 pointed star, we might do
       *                                360/7 * 3 = 154.286)
       *      SHRINK_TIME = 400ms
       */

      :host {
        display: inline-block;
        position: relative;
        width: 28px;
        height: 28px;

        /* 360 * ARCTIME / (ARCSTARTROT + (360-ARCSIZE)) */
        --paper-spinner-container-rotation-duration: 1568ms;

        /* ARCTIME */
        --paper-spinner-expand-contract-duration: 1333ms;

        /* 4 * ARCTIME */
        --paper-spinner-full-cycle-duration: 5332ms;

        /* SHRINK_TIME */
        --paper-spinner-cooldown-duration: 400ms;

        /* Colors */
        --google-red-500: #db4437;
        --google-blue-500: #4285f4;
        --google-green-500: #0f9d58;
        --google-yellow-500: #f4b400;
      }

      #spinnerContainer {
        width: 100%;
        height: 100%;

        /* The spinner does not have any contents that would have to be
         * flipped if the direction changes. Always use ltr so that the
         * style works out correctly in both cases. */
        direction: ltr;
      }

      #spinnerContainer.active {
        animation: container-rotate var(--paper-spinner-container-rotation-duration) linear infinite;
      }

      @-webkit-keyframes container-rotate {
        to { -webkit-transform: rotate(360deg) }
      }

      @keyframes container-rotate {
        to { transform: rotate(360deg) }
      }

      .spinner-layer {
        position: absolute;
        width: 100%;
        height: 100%;
        opacity: 0;
        white-space: nowrap;
        color: var(--paper-spinner-color, var(--google-blue-500));
      }

      .layer-1 {
        color: var(--paper-spinner-layer-1-color, var(--google-blue-500));
      }

      .layer-2 {
        color: var(--paper-spinner-layer-2-color, var(--google-red-500));
      }

      .layer-3 {
        color: var(--paper-spinner-layer-3-color, var(--google-yellow-500));
      }

      .layer-4 {
        color: var(--paper-spinner-layer-4-color, var(--google-green-500));
      }

      /**
       * IMPORTANT NOTE ABOUT CSS ANIMATION PROPERTIES (keanulee):
       *
       * iOS Safari (tested on iOS 8.1) does not handle animation-delay very well - it doesn't
       * guarantee that the animation will start _exactly_ after that value. So we avoid using
       * animation-delay and instead set custom keyframes for each color (as layer-2undant as it
       * seems).
       */
      .active .spinner-layer {
        animation-name: fill-unfill-rotate;
        animation-duration: var(--paper-spinner-full-cycle-duration);
        animation-timing-function: cubic-bezier(0.4, 0.0, 0.2, 1);
        animation-iteration-count: infinite;
        opacity: 1;
      }

      .active .spinner-layer.layer-1 {
        animation-name: fill-unfill-rotate, layer-1-fade-in-out;
      }

      .active .spinner-layer.layer-2 {
        animation-name: fill-unfill-rotate, layer-2-fade-in-out;
      }

      .active .spinner-layer.layer-3 {
        animation-name: fill-unfill-rotate, layer-3-fade-in-out;
      }

      .active .spinner-layer.layer-4 {
        animation-name: fill-unfill-rotate, layer-4-fade-in-out;
      }

      @-webkit-keyframes fill-unfill-rotate {
        12.5% { -webkit-transform: rotate(135deg) } /* 0.5 * ARCSIZE */
        25%   { -webkit-transform: rotate(270deg) } /* 1   * ARCSIZE */
        37.5% { -webkit-transform: rotate(405deg) } /* 1.5 * ARCSIZE */
        50%   { -webkit-transform: rotate(540deg) } /* 2   * ARCSIZE */
        62.5% { -webkit-transform: rotate(675deg) } /* 2.5 * ARCSIZE */
        75%   { -webkit-transform: rotate(810deg) } /* 3   * ARCSIZE */
        87.5% { -webkit-transform: rotate(945deg) } /* 3.5 * ARCSIZE */
        to    { -webkit-transform: rotate(1080deg) } /* 4   * ARCSIZE */
      }

      @keyframes fill-unfill-rotate {
        12.5% { transform: rotate(135deg) } /* 0.5 * ARCSIZE */
        25%   { transform: rotate(270deg) } /* 1   * ARCSIZE */
        37.5% { transform: rotate(405deg) } /* 1.5 * ARCSIZE */
        50%   { transform: rotate(540deg) } /* 2   * ARCSIZE */
        62.5% { transform: rotate(675deg) } /* 2.5 * ARCSIZE */
        75%   { transform: rotate(810deg) } /* 3   * ARCSIZE */
        87.5% { transform: rotate(945deg) } /* 3.5 * ARCSIZE */
        to    { transform: rotate(1080deg) } /* 4   * ARCSIZE */
      }

      @-webkit-keyframes layer-1-fade-in-out {
        0% { opacity: 1 }
        25% { opacity: 1 }
        26% { opacity: 0 }
        89% { opacity: 0 }
        90% { opacity: 1 }
        to { opacity: 1 }
      }

      @keyframes layer-1-fade-in-out {
        0% { opacity: 1 }
        25% { opacity: 1 }
        26% { opacity: 0 }
        89% { opacity: 0 }
        90% { opacity: 1 }
        to { opacity: 1 }
      }

      @-webkit-keyframes layer-2-fade-in-out {
        0% { opacity: 0 }
        15% { opacity: 0 }
        25% { opacity: 1 }
        50% { opacity: 1 }
        51% { opacity: 0 }
        to { opacity: 0 }
      }

      @keyframes layer-2-fade-in-out {
        0% { opacity: 0 }
        15% { opacity: 0 }
        25% { opacity: 1 }
        50% { opacity: 1 }
        51% { opacity: 0 }
        to { opacity: 0 }
      }

      @-webkit-keyframes layer-3-fade-in-out {
        0% { opacity: 0 }
        40% { opacity: 0 }
        50% { opacity: 1 }
        75% { opacity: 1 }
        76% { opacity: 0 }
        to { opacity: 0 }
      }

      @keyframes layer-3-fade-in-out {
        0% { opacity: 0 }
        40% { opacity: 0 }
        50% { opacity: 1 }
        75% { opacity: 1 }
        76% { opacity: 0 }
        to { opacity: 0 }
      }

      @-webkit-keyframes layer-4-fade-in-out {
        0% { opacity: 0 }
        65% { opacity: 0 }
        75% { opacity: 1 }
        90% { opacity: 1 }
        to { opacity: 0 }
      }

      @keyframes layer-4-fade-in-out {
        0% { opacity: 0 }
        65% { opacity: 0 }
        75% { opacity: 1 }
        90% { opacity: 1 }
        to { opacity: 0 }
      }

      .circle-clipper {
        display: inline-block;
        position: relative;
        width: 50%;
        height: 100%;
        overflow: hidden;
      }

      /**
       * Patch the gap that appear between the two adjacent div.circle-clipper while the
       * spinner is rotating (appears on Chrome 50, Safari 9.1.1, and Edge).
       */
      .spinner-layer::after {
        content: '';
        left: 45%;
        width: 10%;
        border-top-style: solid;
      }

      .spinner-layer::after,
      .circle-clipper .circle {
        box-sizing: border-box;
        position: absolute;
        top: 0;
        border-width: var(--paper-spinner-stroke-width, 3px);
        border-radius: 50%;
      }

      .circle-clipper .circle {
        bottom: 0;
        width: 200%;
        border-style: solid;
        border-bottom-color: transparent !important;
      }

      .circle-clipper.left .circle {
        left: 0;
        border-right-color: transparent !important;
        transform: rotate(129deg);
      }

      .circle-clipper.right .circle {
        left: -100%;
        border-left-color: transparent !important;
        transform: rotate(-129deg);
      }

      .active .gap-patch::after,
      .active .circle-clipper .circle {
        animation-duration: var(--paper-spinner-expand-contract-duration);
        animation-timing-function: cubic-bezier(0.4, 0.0, 0.2, 1);
        animation-iteration-count: infinite;
      }

      .active .circle-clipper.left .circle {
        animation-name: left-spin;
      }

      .active .circle-clipper.right .circle {
        animation-name: right-spin;
      }

      @-webkit-keyframes left-spin {
        0% { -webkit-transform: rotate(130deg) }
        50% { -webkit-transform: rotate(-5deg) }
        to { -webkit-transform: rotate(130deg) }
      }

      @keyframes left-spin {
        0% { transform: rotate(130deg) }
        50% { transform: rotate(-5deg) }
        to { transform: rotate(130deg) }
      }

      @-webkit-keyframes right-spin {
        0% { -webkit-transform: rotate(-130deg) }
        50% { -webkit-transform: rotate(5deg) }
        to { -webkit-transform: rotate(-130deg) }
      }

      @keyframes right-spin {
        0% { transform: rotate(-130deg) }
        50% { transform: rotate(5deg) }
        to { transform: rotate(-130deg) }
      }

      #spinnerContainer.cooldown {
        animation: container-rotate var(--paper-spinner-container-rotation-duration) linear infinite, fade-out var(--paper-spinner-cooldown-duration) cubic-bezier(0.4, 0.0, 0.2, 1);
      }

      @-webkit-keyframes fade-out {
        0% { opacity: 1 }
        to { opacity: 0 }
      }

      @keyframes fade-out {
        0% { opacity: 1 }
        to { opacity: 0 }
      }
    </style>
  </template>
</dom-module>`;document.head.appendChild(template$1.content);
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/const PaperSpinnerBehavior={properties:{active:{type:Boolean,value:false,reflectToAttribute:true,observer:"__activeChanged"},alt:{type:String,value:"loading",observer:"__altChanged"},__coolingDown:{type:Boolean,value:false}},__computeContainerClasses:function(active,coolingDown){return[active||coolingDown?"active":"",coolingDown?"cooldown":""].join(" ")},__activeChanged:function(active,old){this.__setAriaHidden(!active);this.__coolingDown=!active&&old},__altChanged:function(alt){if(alt==="loading"){this.alt=this.getAttribute("aria-label")||alt}else{this.__setAriaHidden(alt==="");this.setAttribute("aria-label",alt)}},__setAriaHidden:function(hidden){var attr="aria-hidden";if(hidden){this.setAttribute(attr,"true")}else{this.removeAttribute(attr)}},__reset:function(){this.active=false;this.__coolingDown=false}};
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/const template=html$1`
  <style include="paper-spinner-styles"></style>

  <div id="spinnerContainer" class-name="[[__computeContainerClasses(active, __coolingDown)]]" on-animationend="__reset" on-webkit-animation-end="__reset">
    <div class="spinner-layer">
      <div class="circle-clipper left">
        <div class="circle"></div>
      </div>
      <div class="circle-clipper right">
        <div class="circle"></div>
      </div>
    </div>
  </div>
`;template.setAttribute("strip-whitespace","");Polymer({_template:template,is:"paper-spinner-lite",behaviors:[PaperSpinnerBehavior]});function getTemplate$7(){return html$1`<!--_html_template_start_-->    <style include="cr-shared-style cr-hidden-style">:host(:not([error-message-allowed])) cr-input{--cr-input-error-display:none}:host([opened_]) cr-input{--cr-input-border-radius:4px 4px 0 0}iron-dropdown,cr-input{width:var(--cr-searchable-drop-down-width,472px)}cr-input{--cr-input-padding-start:8px;isolation:auto}iron-dropdown{max-height:270px}iron-dropdown [slot='dropdown-content']{background-color:var(--cr-searchable-drop-down-bg-color,white);border-radius:0 0 4px 4px;box-shadow:var(--cr-searchable-drop-down-shadow,0 2px 6px #9e9e9e);min-width:128px;padding:8px 0}#input-overlay{border-radius:4px;height:100%;left:0;overflow:hidden;pointer-events:none;position:absolute;top:0;width:100%}#dropdown-icon{--iron-icon-height:20px;--iron-icon-width:20px;margin-top:-10px;padding-inline-end:6px;position:absolute;right:0;top:50%}:host-context([dir='rtl']) #dropdown-icon{left:0;right:unset}cr-input:focus-within #dropdown-icon{--iron-icon-fill-color:var(--cr-searchable-drop-down-icon-color-focus,var(--google-blue-600))}#input-box{height:100%;left:0;pointer-events:none;top:0;width:100%}#dropdown-box{pointer-events:initial;width:100%}#loading-box{align-items:center;box-sizing:border-box;display:flex;height:32px;padding:0 8px;text-align:start;width:100%}#loading-box div{font-size:12px;padding:0 16px}#loading-box paper-spinner-lite{--paper-spinner-color:var(--cr-searchable-drop-down-spinner-color,var(--google-blue-600));--paper-spinner-stroke-width:2px;height:16px;width:16px}.list-item{background:none;border:none;box-sizing:border-box;color:var(--cr-searchable-drop-down-list-item-color,#212121);font:inherit;min-height:32px;padding:0 8px;text-align:start;width:100%}.list-item[selected_]{background-color:var(--cr-searchable-drop-down-list-bg-color-selected,rgba(0,0,0,.04));outline:none}.list-item:active{background-color:var(--cr-searchable-drop-down-list-bg-color-active,rgba(0,0,0,.12));outline:none}
    </style>
    <!-- |value| is one-way binding on purpose so that it doesn't change
      immediately as the user types unless the update-value-on-input flag is
      explicitly used. -->
    <cr-input part="input" label="[[label]]" on-focus="onFocus_" on-keydown="onKeyDown_"
        value="[[value]]"
        on-input="onInput_" id="search" autofocus="[[autofocus]]"
        placeholder="[[placeholder]]" readonly="[[readonly]]"
        error-message="[[getErrorMessage_(errorMessage, errorMessageAllowed)]]"
        invalid="[[shouldShowErrorMessage_(errorMessage, errorMessageAllowed)]]"
        on-blur="onBlur_">
      <div id="input-overlay" slot="suffix">
        <div id="input-box">
          <cr-icon id="dropdown-icon" icon="cr:arrow-drop-down"></cr-icon>
        </div>
        <div id="dropdown-box">
          <iron-dropdown id="dropdown" horizontal-align="left"
              vertical-align="top" vertical-offset="0"
              no-cancel-on-outside-click no-cancel-on-esc-key>
            <div slot="dropdown-content">
              <div id="loading-box" hidden="[[!showLoading]]">
                <paper-spinner-lite active></paper-spinner-lite>
                <div class="cr-secondary-text">[[loadingMessage]]</div>
              </div>
              <template is="dom-repeat" items="[[items]]"
                  filter="[[filterItems_(searchTerm_)]]">
                <button class="list-item" on-click="onSelect_" tabindex="-1">
                  [[item]]
                </button>
              </template>
            </div>
          </iron-dropdown>
        </div>
      </div>
    </cr-input>
<!--_html_template_end_-->`}
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class SearchableDropDownCrosElement extends PolymerElement{constructor(){super(...arguments);this.openDropdownTimeoutId_=0;this.resizeObserver_=null}static get is(){return"searchable-drop-down-cros"}static get template(){return getTemplate$7()}static get properties(){return{autofocus:{type:Boolean,value:false,reflectToAttribute:true},readonly:{type:Boolean,reflectToAttribute:true},errorMessageAllowed:{type:Boolean,value:false,reflectToAttribute:true},errorMessage:String,loadingMessage:String,placeholder:String,invalid:{type:Boolean,value:false,notify:true},items:{type:Array,observer:"onItemsChanged_"},value:{type:String,notify:true,observer:"updateInvalid_"},label:{type:String,value:""},updateValueOnInput:Boolean,showLoading:{type:Boolean,value:false},searchTerm_:String,dropdownRefitPending_:Boolean,opened_:{type:Boolean,value:false,reflectToAttribute:true}}}connectedCallback(){super.connectedCallback();this.pointerDownListener_=this.onPointerDown_.bind(this);document.addEventListener("pointerdown",this.pointerDownListener_);this.resizeObserver_=new ResizeObserver((()=>{this.resizeDropdown_()}));this.resizeObserver_.observe(this.$.search)}ready(){super.ready();this.addEventListener("mousemove",this.onMouseMove_.bind(this))}disconnectedCallback(){super.disconnectedCallback();document.removeEventListener("pointerdown",this.pointerDownListener_);this.resizeObserver_.unobserve(this.$.search)}enqueueDropdownRefit_(){const dropdown=this.$.dropdown;if(!this.dropdownRefitPending_&&dropdown.opened){this.dropdownRefitPending_=true;setTimeout((()=>{dropdown.refit();this.dropdownRefitPending_=false}),0)}}resizeDropdown_(){const dropdown=this.$.dropdown.containedElement;const dropdownWidth=Math.max(dropdown.offsetWidth,this.$.search.offsetWidth);dropdown.style.width=`${dropdownWidth}px`;this.enqueueDropdownRefit_()}openDropdown_(){this.$.dropdown.open();this.opened_=true}closeDropdown_(){if(this.openDropdownTimeoutId_){clearTimeout(this.openDropdownTimeoutId_)}this.$.dropdown.close();this.opened_=false}enqueueOpenDropdown_(){if(this.opened_){return}if(this.openDropdownTimeoutId_){clearTimeout(this.openDropdownTimeoutId_)}this.openDropdownTimeoutId_=setTimeout(this.openDropdown_.bind(this))}onItemsChanged_(){this.enqueueDropdownRefit_()}onFocus_(){if(this.readonly){return}this.openDropdown_()}onMouseMove_(event){const item=event.composedPath().find((elm=>{const element=elm;return element.classList&&element.classList.contains("list-item")}));if(!item){return}const selectedItem=this.findSelectedItem_();if(item===selectedItem){return}if(selectedItem){selectedItem.removeAttribute("selected_")}item.setAttribute("selected_","")}onPointerDown_(event){if(this.readonly){return}const paths=event.composedPath();const searchInput=this.$.search.inputElement;if(paths.includes(this.$.dropdown)){searchInput.focus();event.preventDefault()}else if(paths.includes(searchInput)){this.enqueueOpenDropdown_()}else{this.closeDropdown_()}}onKeyDown_(event){const dropdown=this.$.dropdown;if(!dropdown.opened){if(this.readonly){return}if(event.key==="Enter"){this.openDropdown_();event.preventDefault()}return}event.stopPropagation();switch(event.key){case"Tab":this.closeDropdown_();break;case"ArrowUp":case"ArrowDown":{const selected=this.findSelectedItemIndex_();const items=dropdown.querySelectorAll(".list-item");if(items.length===0){break}this.updateSelected_(items,selected,event.key==="ArrowDown");break}case"Enter":{const selected=this.findSelectedItem_();if(!selected){break}selected.removeAttribute("selected_");this.value=dropdown.querySelector("dom-repeat").modelForElement(selected).item;this.searchTerm_="";this.closeDropdown_();event.preventDefault();break}}}findSelectedItem_(){const items=Array.from(this.$.dropdown.querySelectorAll(".list-item"));return items.find((item=>item.hasAttribute("selected_")))}findSelectedItemIndex_(){const items=Array.from(this.$.dropdown.querySelectorAll(".list-item"));return items.findIndex((item=>item.hasAttribute("selected_")))}updateSelected_(items,currentIndex,moveDown){const numItems=items.length;let nextIndex=0;if(currentIndex===-1){nextIndex=moveDown?0:numItems-1}else{const delta=moveDown?1:-1;nextIndex=(numItems+currentIndex+delta)%numItems;items[currentIndex].removeAttribute("selected_")}items[nextIndex].setAttribute("selected_","");items[nextIndex].scrollIntoViewIfNeeded()}onInput_(){this.searchTerm_=this.$.search.value;if(this.updateValueOnInput){this.value=this.$.search.value}this.openDropdown_();this.enqueueDropdownRefit_();this.updateInvalid_()}onSelect_(event){this.closeDropdown_();this.value=event.model.item;this.searchTerm_="";const selected=this.findSelectedItem_();if(selected){selected.removeAttribute("selected_")}}filterItems_(searchTerm){if(!searchTerm){return null}return function(item){return item.toLowerCase().includes(searchTerm.toLowerCase())}}shouldShowErrorMessage_(errorMessage,errorMessageAllowed){return!!this.getErrorMessage_(errorMessage,errorMessageAllowed)}getErrorMessage_(errorMessage,errorMessageAllowed){if(!errorMessageAllowed){return""}return errorMessage}onBlur_(){if(!this.updateValueOnInput){this.$.search.value=this.value}this.updateInvalid_()}updateInvalid_(){this.invalid=!this.updateValueOnInput&&this.value!==this.$.search.value}}customElements.define(SearchableDropDownCrosElement.is,SearchableDropDownCrosElement);function getTemplate$6(){return html$1`<!--_html_template_start_--><style include="destination-dialog-style">:host(:not([show-manage-printers-button])) div[slot=button-container]{justify-content:flex-end}.form-row{align-items:center;column-gap:18px;display:flex;line-height:calc(20 / 15 * 1em);margin-bottom:14px}.server-search-box-input{--cr-searchable-drop-down-width:100%;display:inline-block;flex-grow:1;width:100%}.server-search-box-container{width:100%}.throbber{align-self:center}.throbber-container{display:flex;margin-inline-start:calc((var(--search-icon-size) - var(--throbber-size))/2);min-height:var(--destination-item-height)}</style>
<cr-dialog id="dialog" on-close="onCloseOrCancel_">
  <div slot="title" id="header">$i18n{destinationSearchTitle}</div>
  <div slot="body">
    <div class="form-row">
      <div class="server-search-box-container">
        <!-- TODO(crbug.com/1013408): Uses deprecated iron-dropdown. -->
        <searchable-drop-down-cros class="server-search-box-input"
            hidden$="[[!isSingleServerFetchingMode_]]"
            placeholder="$i18n{serverSearchBoxPlaceholder}"
            value="{{printServerSelected_}}"
            items="[[printServerNames_]]">
        </searchable-drop-down-cros>
      </div>
    </div>
    <div class="throbber-container" hidden$="[[!shouldShowUi_(
        uiStateEnum_.THROBBER, uiState_)]]">
      <div class="throbber"></div>
    </div>
    <print-preview-search-box id="searchBox"
        hidden$="[[!shouldShowUi_(uiStateEnum_.DESTINATION_LIST, uiState_)]]"
        label="$i18n{searchBoxPlaceholder}" search-query="{{searchQuery_}}"
        autofocus>
    </print-preview-search-box>
    <print-preview-destination-list id="printList"
        destinations="[[destinations_]]"
        hidden$="[[!shouldShowUi_(uiStateEnum_.DESTINATION_LIST, uiState_)]]"
        loading-destinations="[[loadingDestinations_]]"
        search-query="[[searchQuery_]]"
        on-destination-selected="onDestinationSelected_">
    </print-preview-destination-list>
    <print-preview-printer-setup-info-cros
        hidden$="[[!shouldShowUi_(uiStateEnum_.PRINTER_SETUP_ASSISTANCE,
            uiState_)]]"
        message-type="[[printerSetupInfoMessageTypeEnum_.NO_PRINTERS]]"
        initiator="[[printerSetupInfoInitiatorEnum_.DESTINATION_DIALOG_CROS]]">
    </print-preview-printer-setup-info-cros>
    <print-preview-provisional-destination-resolver id="provisionalResolver"
        destination-store="[[destinationStore]]">
    </print-preview-provisional-destination-resolver>
  </div>
  <div slot="button-container">
    <cr-button on-click="onManageButtonClick_" id="managePrinters"
        hidden$="[[!showManagePrintersButton]]">
      $i18n{manage}
      <cr-icon icon="cr:open-in-new" id="manageIcon"></cr-icon>
    </cr-button>
    <cr-button class="cancel-button" on-click="onCancelButtonClick_">
      $i18n{cancel}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var UiState;(function(UiState){UiState[UiState["THROBBER"]=0]="THROBBER";UiState[UiState["DESTINATION_LIST"]=1]="DESTINATION_LIST";UiState[UiState["PRINTER_SETUP_ASSISTANCE"]=2]="PRINTER_SETUP_ASSISTANCE"})(UiState||(UiState={}));const DESTINATION_DIALOG_CROS_LOADING_TIMER_IN_MS=2e3;const PrintPreviewDestinationDialogCrosElementBase=ListPropertyUpdateMixin(WebUiListenerMixin(PolymerElement));class PrintPreviewDestinationDialogCrosElement extends PrintPreviewDestinationDialogCrosElementBase{constructor(){super(...arguments);this.tracker_=new EventTracker;this.destinationInConfiguring_=null;this.initialized_=false;this.printServerStore_=null;this.showManagePrinters=false;this.timerDelay_=0;this.minLoadingTimeElapsed_=false;this.uiState_=UiState.THROBBER}static get is(){return"print-preview-destination-dialog-cros"}static get template(){return getTemplate$6()}static get properties(){return{destinationStore:{type:Object,observer:"onDestinationStoreSet_"},printServerSelected_:{type:String,value:"",observer:"onPrintServerSelected_"},destinations_:{type:Array,value:()=>[]},loadingDestinations_:{type:Boolean,value:false},searchQuery_:{type:Object,value:null},isSingleServerFetchingMode_:{type:Boolean,value:false},printServerNames_:{type:Array,value(){return[""]}},loadingServerPrinters_:{type:Boolean,value:false},loadingAnyDestinations_:{type:Boolean,computed:"computeLoadingDestinations_("+"loadingDestinations_, loadingServerPrinters_)"},showManagePrintersButton:{type:Boolean,reflectToAttribute:true},showManagePrinters:Boolean,printerSetupInfoMessageTypeEnum_:{type:Number,value:PrinterSetupInfoMessageType,readOnly:true},printerSetupInfoInitiatorEnum_:{type:Number,value:PrinterSetupInfoInitiator,readOnly:true},minLoadingTimeElapsed_:Boolean,uiState_:{type:Number,value:UiState.THROBBER},uiStateEnum_:{type:Object,value:UiState}}}static get observers(){return["computeUiState_(minLoadingTimeElapsed_, loadingAnyDestinations_, "+"destinations_.*)"]}disconnectedCallback(){super.disconnectedCallback();this.tracker_.removeAll()}ready(){super.ready();this.addEventListener("keydown",(e=>this.onKeydown_(e)));this.printServerStore_=new PrintServerStore(((eventName,callback)=>this.addWebUiListener(eventName,callback)));this.tracker_.add(this.printServerStore_,PrintServerStoreEventType.PRINT_SERVERS_CHANGED,this.onPrintServersChanged_.bind(this));this.tracker_.add(this.printServerStore_,PrintServerStoreEventType.SERVER_PRINTERS_LOADING,this.onServerPrintersLoading_.bind(this));this.printServerStore_.getPrintServersConfig().then((config=>{this.printServerNames_=config.printServers.map((printServer=>printServer.name));this.isSingleServerFetchingMode_=config.isSingleServerFetchingMode}));if(this.destinationStore){this.printServerStore_.setDestinationStore(this.destinationStore)}this.metricsContext_=MetricsContext.getLaunchPrinterSettingsMetricsContextCros();NativeLayerCrosImpl.getInstance().getShowManagePrinters().then((show=>{this.showManagePrinters=show}))}onKeydown_(e){e.stopPropagation();const searchInput=this.$.searchBox.getSearchInput();if(e.key==="Escape"&&(e.composedPath()[0]!==searchInput||!searchInput.value.trim())){this.$.dialog.cancel();e.preventDefault()}}onDestinationStoreSet_(){assert(this.destinations_.length===0);this.tracker_.add(this.destinationStore,DestinationStoreEventType.DESTINATIONS_INSERTED,this.updateDestinations_.bind(this));this.tracker_.add(this.destinationStore,DestinationStoreEventType.DESTINATION_SEARCH_DONE,this.updateDestinations_.bind(this));this.tracker_.add(this.destinationStore,DestinationStoreEventType.DESTINATION_PRINTER_STATUS_UPDATE,this.onPrinterStatusUpdate_.bind(this));this.initialized_=true;if(this.printServerStore_){this.printServerStore_.setDestinationStore(this.destinationStore)}}updateDestinations_(){if(this.destinationStore===undefined||!this.initialized_){return}this.updateList("destinations_",(destination=>destination.key),this.getDestinationList_());this.loadingDestinations_=this.destinationStore.isPrintDestinationSearchInProgress;if(this.uiState_===UiState.DESTINATION_LIST){window.dispatchEvent(new CustomEvent("resize"))}}getDestinationList_(){return this.destinationStore.destinations().filter((destination=>destination.id!==GooglePromotedDestinationId.SAVE_TO_DRIVE_CROS))}onCloseOrCancel_(){if(this.searchQuery_){this.$.searchBox.setValue("")}this.clearThrobberTimer_()}onCancelButtonClick_(){this.$.dialog.cancel();this.clearThrobberTimer_()}onDestinationSelected_(e){const listItem=e.detail;const destination=listItem.destination;if(destination.readyForSelection){this.selectDestination_(destination);return}if(destination.isProvisional){this.$.provisionalResolver.resolveDestination(destination).then(this.selectDestination_.bind(this)).catch((function(){console.warn("Failed to resolve provisional destination: "+destination.id)})).then((()=>{if(this.$.dialog.open&&listItem&&!listItem.hidden){listItem.focus()}}));return}if(this.destinationInConfiguring_){return}listItem.onConfigureRequestAccepted();this.destinationInConfiguring_=destination;this.destinationStore.resolveCrosDestination(destination).then((response=>{this.destinationInConfiguring_=null;listItem.onConfigureComplete(true);destination.capabilities=response.capabilities;if(loadTimeData.getBoolean("isUseManagedPrintJobOptionsInPrintPreviewEnabled")){destination.applyAllowedManagedPrintOptions()}this.selectDestination_(destination);this.destinationStore.fetchEulaUrl(destination.id)}),(()=>{this.destinationInConfiguring_=null;listItem.onConfigureComplete(false)}))}selectDestination_(destination){this.destinationStore.selectDestination(destination);this.$.dialog.close()}show(){this.updateDestinations_();this.$.dialog.showModal();if(this.uiState_===UiState.DESTINATION_LIST){window.dispatchEvent(new CustomEvent("resize"))}if(!this.minLoadingTimeElapsed_){this.timerDelay_=timeOut.run((()=>{this.minLoadingTimeElapsed_=true}),DESTINATION_DIALOG_CROS_LOADING_TIMER_IN_MS)}}isOpen(){return this.$.dialog.hasAttribute("open")}onPrintServerSelected_(printServerName){if(!this.printServerStore_){return}this.printServerStore_.choosePrintServers(printServerName)}onPrintServersChanged_(e){this.isSingleServerFetchingMode_=e.detail.isSingleServerFetchingMode;this.printServerNames_=e.detail.printServerNames}onServerPrintersLoading_(e){this.loadingServerPrinters_=e.detail}computeLoadingDestinations_(){return this.loadingDestinations_||this.loadingServerPrinters_}onManageButtonClick_(){NativeLayerImpl.getInstance().managePrinters();this.metricsContext_.record(PrintPreviewLaunchSourceBucket.DESTINATION_DIALOG_CROS_HAS_PRINTERS)}printerDestinationExists(){return this.destinations_.some((destination=>destination.id!==GooglePromotedDestinationId.SAVE_AS_PDF))}clearThrobberTimer_(){if(!this.minLoadingTimeElapsed_){timeOut.cancel(this.timerDelay_)}}onPrinterStatusUpdate_(e){const destinationKey=e.detail;const destinationList=this.shadowRoot.querySelector("print-preview-destination-list");assert(destinationList);destinationList.updatePrinterStatusIcon(destinationKey)}computeUiState_(){if(!this.minLoadingTimeElapsed_){this.uiState_=UiState.THROBBER}else if(this.printerDestinationExists()){this.uiState_=UiState.DESTINATION_LIST;window.dispatchEvent(new CustomEvent("resize"));this.$.searchBox.focus()}else if(this.loadingAnyDestinations_){this.uiState_=UiState.THROBBER}else{this.uiState_=UiState.PRINTER_SETUP_ASSISTANCE}this.showManagePrintersButton=this.showManagePrinters&&this.uiState_!==UiState.PRINTER_SETUP_ASSISTANCE}shouldShowUi_(uiState){return this.uiState_===uiState}}customElements.define(PrintPreviewDestinationDialogCrosElement.is,PrintPreviewDestinationDialogCrosElement);function getTemplate$5(){return html$1`<!--_html_template_start_--><style include="cr-shared-style cr-hidden-style">:host{--dropdown-bg-color:var(--google-grey-100);--dropdown-focus-shadow-color:rgba(var(--google-blue-600-rgb),.4);--dropdown-option-bg-color:white}@media (prefers-color-scheme:dark){:host{--dropdown-bg-color:rgba(0,0,0,0.3);--dropdown-focus-shadow-color:rgba(var(--google-blue-300-rgb),.4);--dropdown-option-bg-color:var(--google-grey-900-white-4-percent)}}#destinationDropdown{outline:none;position:relative}#destinationDropdown:focus{border-radius:4px;box-shadow:0 0 0 2px var(--dropdown-focus-shadow-color)}#destinationDropdown,iron-dropdown{width:var(--print-preview-dropdown-width)}iron-dropdown{border:0.5px solid rgba(0,0,0,0.5);max-height:270px}iron-dropdown [slot='dropdown-content']{background-color:var(--dropdown-option-bg-color);box-shadow:var(--cr-menu-shadow);padding:8px 0}#dropdown-icon{--iron-icon-height:24px;--iron-icon-width:44px;align-items:center;left:2px;margin-inline-start:-4px;top:50%}:host-context([dir='rtl']) #dropdown-icon{right:2px}#dropdown-box{border-radius:4px;height:100%;left:0;margin-top:24px;overflow:hidden;pointer-events:initial;position:absolute;top:0;width:100%}.list-item{background:none;border:none;box-sizing:border-box;cursor:pointer;font:inherit;min-height:32px;padding:0 8px;text-align:start;width:100%}.list-item:focus{outline:none}.list-item.highlighted{background-color:var(--google-blue-100)}@media (prefers-color-scheme:dark){.list-item.highlighted{--iron-icon-fill-color:currentColor;background-color:var(--google-blue-200);color:var(--google-grey-900)}}#destination-icon-box,.printer-display-name{padding-inline-start:8px}#destination-display-container{align-items:center;background-color:var(--dropdown-bg-color);border-radius:4px;cursor:pointer;display:flex;width:100%}:host([disabled]) #destination-display-container{cursor:default;opacity:var(--cr-disabled-opacity)}#destination-display{box-sizing:border-box;overflow:hidden;padding-inline-start:8px;text-overflow:ellipsis;white-space:nowrap;width:100%}</style>
<iron-media-query query="(prefers-color-scheme: dark)"
    query-matches="{{isDarkModeActive_}}">
</iron-media-query>
<div id="destinationDropdown" on-keydown="onKeyDown_" tabindex="0"
    on-blur="onBlur_" on-click="onClick_" role="button" aria-haspopup="true"
    aria-label="$i18n{destinationLabel} [[value.displayName]]"
    aria-description$="[[getAriaDescription_(destinationStatusText)]]"
    aria-expanded="[[opened_]]" aria-setsize$="[[dropdownLength_]]">
  <div id="destination-display-container">
    <div id="destination-icon-box">
      <cr-icon icon="[[destinationIcon]]"></cr-icon>
    </div>
    <div id="destination-display" title="[[value.displayName]]">
      [[value.displayName]]
    </div>
    <cr-icon id="dropdown-icon" icon="cr:arrow-drop-down"></cr-icon>
  </div>
  <div id="dropdown-box">
    <iron-dropdown horizontal-align="left" vertical-align="top"
        vertical-offset="0" no-cancel-on-outside-click
        no-cancel-on-esc-key>
      <div slot="dropdown-content">
        <template is="dom-repeat" items="[[itemList]]">
          <button id="[[item.key]]" tabindex="-1" value="[[item.key]]"
              on-click="onSelect_" on-blur="onBlur_" role="menuitem"
              aria-setsize$="[[dropdownLength_]]"
              class$="list-item [[getHighlightedClass_(item.key,
                  highlightedIndex_)]]"
              aria-description$="[[getPrinterStatusErrorString_(
                  item.printerStatusReason)]]"
              aria-posinset$="[[getPrinterPosinset_(index)]]">
            <cr-icon icon="[[getPrinterStatusIcon_(
                item.printerStatusReason, item.isEnterprisePrinter,
                isDarkModeActive_)]]">
            </cr-icon>
            <span class="printer-display-name">[[item.displayName]]</span>
          </button>
        </template>
        <button on-click="onSelect_" tabindex="-1" value="[[pdfDestinationKey]]"
          hidden$="[[pdfPrinterDisabled]]" on-blur="onBlur_" role="menuitem"
          aria-setsize$="[[dropdownLength_]]"
          aria-posinset$="[[pdfPosinset]]"
          class$="list-item [[getHighlightedClass_(pdfDestinationKey,
              highlightedIndex_)]]">
          $i18n{printToPDF}
        </button>
        <button on-click="onSelect_" tabindex="-1" on-blur="onBlur_"
          value="[[driveDestinationKey]]" hidden$="[[!driveDestinationKey]]"
          role="menuitem" aria-setsize$="[[dropdownLength_]]"
          aria-posinset$="[[drivePosinset]]"
          class$="list-item [[getHighlightedClass_(driveDestinationKey,
              highlightedIndex_)]]">
          $i18n{printToGoogleDrive}
        </button>
        <button on-click="onSelect_" tabindex="-1" value="noDestinations"
          hidden$="[[!noDestinations]]" on-blur="onBlur_" role="menuitem"
          aria-setsize$="[[dropdownLength_]]" aria-posinset$="1"
          class$="list-item [[getHighlightedClass_('noDestinations',
              highlightedIndex_)]]">
          $i18n{noDestinationsMessage}
        </button>
        <button on-click="onSelect_" tabindex="-1" value="seeMore"
          aria-label="$i18n{seeMoreDestinationsLabel}" on-blur="onBlur_"
          aria-posinset$="[[seeMorePosinset]]"
          role="menuitem" aria-setsize$="[[dropdownLength_]]"
          class$="list-item [[getHighlightedClass_('seeMore',
              highlightedIndex_)]]">
          $i18n{seeMore}
        </button>
      </div>
    </iron-dropdown>
  </div>
</div>
<!--_html_template_end_-->`}
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PrintPreviewDestinationDropdownCrosElementBase=I18nMixin(PolymerElement);class PrintPreviewDestinationDropdownCrosElement extends PrintPreviewDestinationDropdownCrosElementBase{constructor(){super(...arguments);this.opened_=false;this.dropdownRefitPending_=false}static get is(){return"print-preview-destination-dropdown-cros"}static get template(){return getTemplate$5()}static get properties(){return{value:Object,itemList:{type:Array,observer:"enqueueDropdownRefit_"},disabled:{type:Boolean,value:false,observer:"updateTabIndex_",reflectToAttribute:true},driveDestinationKey:String,noDestinations:Boolean,pdfPrinterDisabled:Boolean,pdfDestinationKey:String,destinationIcon:String,isDarkModeActive_:Boolean,highlightedIndex_:Number,dropdownLength_:{type:Number,computed:"computeDropdownLength_(itemList, pdfPrinterDisabled, "+"driveDestinationKey, noDestinations)"},destinationStatusText:String,pdfPosinset:Number,drivePosinset:Number,seeMorePosinset:Number}}static get observers(){return["updateAriaPosinset(itemList, pdfPrinterDisabled, driveDestinationKey)"]}ready(){super.ready();this.addEventListener("mousemove",(e=>this.onMouseMove_(e)))}connectedCallback(){super.connectedCallback();this.updateTabIndex_()}focus(){this.$.destinationDropdown.focus()}getAriaDescription_(){return this.destinationStatusText.toString()}fireDropdownValueSelected_(element){this.dispatchEvent(new CustomEvent("dropdown-value-selected",{bubbles:true,composed:true,detail:element}))}enqueueDropdownRefit_(){const dropdown=this.shadowRoot.querySelector("iron-dropdown");if(!this.dropdownRefitPending_&&dropdown.opened){this.dropdownRefitPending_=true;setTimeout((()=>{dropdown.refit();this.dropdownRefitPending_=false}),0)}}openDropdown_(){if(this.disabled){return}this.highlightedIndex_=this.getButtonListFromDropdown_().findIndex((item=>item.value===this.value.key));this.shadowRoot.querySelector("iron-dropdown").open();this.opened_=true}closeDropdown_(){this.shadowRoot.querySelector("iron-dropdown").close();this.opened_=false;this.highlightedIndex_=-1}onMouseMove_(event){const item=event.composedPath().find((elm=>elm.classList&&elm.classList.contains("list-item")));if(!item){return}this.highlightedIndex_=this.getButtonListFromDropdown_().indexOf(item)}onClick_(event){const dropdown=this.shadowRoot.querySelector("iron-dropdown");if(event.composedPath().includes(dropdown)){return}if(dropdown.opened){this.closeDropdown_();return}this.openDropdown_()}onSelect_(event){this.dropdownValueSelected_(event.currentTarget)}onKeyDown_(event){event.stopPropagation();const dropdown=this.shadowRoot.querySelector("iron-dropdown");switch(event.key){case"ArrowUp":case"ArrowDown":this.onArrowKeyPress_(event.key);break;case"Enter":{if(dropdown.opened){this.dropdownValueSelected_(this.getButtonListFromDropdown_()[this.highlightedIndex_]);break}this.openDropdown_();break}case"Escape":{if(dropdown.opened){this.closeDropdown_();event.preventDefault()}break}}}onArrowKeyPress_(eventKey){const dropdown=this.shadowRoot.querySelector("iron-dropdown");const items=this.getButtonListFromDropdown_();if(items.length===0){return}if(dropdown.opened){const nextIndex=this.getNextItemIndexInList_(eventKey,this.highlightedIndex_,items.length);if(nextIndex===-1){return}this.highlightedIndex_=nextIndex;items[this.highlightedIndex_].focus();return}const currentIndex=items.findIndex((item=>item.value===this.value.key));const nextIndex=this.getNextItemIndexInList_(eventKey,currentIndex,items.length);if(nextIndex===-1){return}this.fireDropdownValueSelected_(items[nextIndex])}getNextItemIndexInList_(eventKey,currentIndex,numItems){const nextIndex=eventKey==="ArrowDown"?currentIndex+1:currentIndex-1;return nextIndex>=0&&nextIndex<numItems?nextIndex:-1}dropdownValueSelected_(dropdownItem){this.closeDropdown_();if(dropdownItem){this.fireDropdownValueSelected_(dropdownItem)}this.$.destinationDropdown.focus()}getButtonListFromDropdown_(){if(!this.shadowRoot){return[]}const dropdown=this.shadowRoot.querySelector("iron-dropdown");return Array.from(dropdown.querySelectorAll(".list-item")).filter((item=>!item.hidden))}updateTabIndex_(){this.$.destinationDropdown.setAttribute("tabindex",this.disabled?"-1":"0")}getHighlightedClass_(itemValue){const itemToHighlight=this.getButtonListFromDropdown_()[this.highlightedIndex_];return itemToHighlight&&itemValue===itemToHighlight.value?"highlighted":""}onBlur_(event){if(!this.getButtonListFromDropdown_().includes(event.relatedTarget)){this.closeDropdown_()}}computeDropdownLength_(){if(this.noDestinations){return 1}if(!this.itemList){return 0}let length=this.itemList.length+1;if(!this.pdfPrinterDisabled){length++}if(this.driveDestinationKey){length++}return length}getPrinterStatusErrorString_(printerStatusReason){const errorStringKey=ERROR_STRING_KEY_MAP.get(printerStatusReason);return errorStringKey?this.i18n(errorStringKey):""}getPrinterStatusIcon_(printerStatusReason,isEnterprisePrinter){return getPrinterStatusIcon(printerStatusReason,isEnterprisePrinter,this.isDarkModeActive_)}getPrinterPosinset_(index){return index+1}updateAriaPosinset(){let currentPosition=this.itemList?this.itemList.length+1:1;if(!this.pdfPrinterDisabled){this.pdfPosinset=currentPosition++}if(this.driveDestinationKey){this.drivePosinset=currentPosition++}this.seeMorePosinset=currentPosition++}}customElements.define(PrintPreviewDestinationDropdownCrosElement.is,PrintPreviewDestinationDropdownCrosElement);const styleMod$1=document.createElement("dom-module");styleMod$1.appendChild(html$1`
  <template>
    <style include="cr-shared-style">
:host{--printer-icon-side-padding:4px;--printer-icon-size:20px}select.md-select{background-position:var(--printer-icon-side-padding) center,calc(100% - var(--md-select-side-padding)) center;background-size:var(--printer-icon-size),var(--md-arrow-width);padding-inline-start:32px}:host-context([dir=rtl]) .md-select{background-position-x:calc(100% - var(--printer-icon-side-padding)),var(--md-select-side-padding)}.throbber-container{align-items:center;display:flex;overflow:hidden}.destination-additional-info,.destination-additional-info div{height:100%;min-height:0}.destination-status{color:var(--cr-secondary-text-color);font-size:calc(12/13 * 1em);padding:4px 0}
    </style>
  </template>
`.content);styleMod$1.register("destination-select-style");function getTemplate$4(){return html$1`<!--_html_template_start_--><style include="print-preview-shared throbber destination-select-style cr-hidden-style">:host([is-current-destination-cros-local_]) #statusText{color:var(--google-red-600);font-size:calc(10 / 13 * 1em);overflow:hidden;padding:0;text-overflow:ellipsis;white-space:nowrap}:host([is-current-destination-cros-local_]) #statusText.status-orange{color:var(--error-status-warning)}:host([is-current-destination-cros-local_]) #statusText.status-red{color:var(--error-status-alert)}@media (prefers-color-scheme:dark){:host([is-current-destination-cros-local_]) #statusText{color:var(--google-red-300)}}a[href]{color:var(--google-blue-600);text-decoration:none}@media (prefers-color-scheme:dark){a[href]{color:var(--cr-link-color)}}</style>
<iron-media-query query="(prefers-color-scheme: dark)"
    query-matches="{{isDarkModeActive_}}">
</iron-media-query>
<print-preview-settings-section>
  <span slot="title">$i18n{destinationLabel}</span>
  <div slot="controls">
    <div class="throbber-container" hidden$="[[loaded]]">
      <div class="throbber"></div>
    </div>
    <print-preview-destination-dropdown-cros id="dropdown"
        value="[[destination]]" hidden$="[[!loaded]]"
        item-list="[[recentDestinationList]]"
        pdf-destination-key="[[pdfDestinationKey_]]"
        drive-destination-key="[[driveDestinationKey]]"
        no-destinations="[[noDestinations]]"
        pdf-printer-disabled="[[pdfPrinterDisabled]]"
        destination-icon="[[destinationIcon_]]" disabled="[[disabled]]"
        on-dropdown-value-selected="onDropdownValueSelected_"
        destination-status-text="[[statusText_]]">
    </print-preview-destination-dropdown-cros>
  </div>
</print-preview-settings-section>
<print-preview-settings-section class="destination-additional-info"
    hidden$="[[hideDestinationAdditionalInfo_(statusText_)]]">
  <div slot="title"></div>
  <div slot="controls">
    <div id="statusText"
        class$="[[computeStatusClass_(destination.printerStatusReason)]]"
        title="[[statusText_]]"
        aria-hidden="[[isCurrentDestinationCrosLocal_]]"
        inner-h-t-m-l="[[statusText_]]">
    </div>
  </div>
</print-preview-settings-section>
<print-preview-settings-section class="destination-additional-info"
    id="destinationEulaWrapper"
    hidden$="[[!destination.eulaUrl]]">
  <div slot="title"></div>
  <div slot="controls">
    <a class="destination-status" href="[[destination.eulaUrl]]"
        target="_blank">
     $i18n{printerEulaURL}
    </a>
  </div>
</print-preview-settings-section>
<!--_html_template_end_-->`}const styleMod=document.createElement("dom-module");styleMod.appendChild(html$1`
  <template>
    <style>
:host{--cr-input-background-color:var(--color-textfield-filled-background,var(--cr-fallback-color-surface-variant));--cr-input-border-bottom:1px solid var(--color-textfield-filled-underline,var(--cr-fallback-color-outline));--cr-input-border-radius:8px 8px 0 0;--cr-input-color:var(--cr-primary-text-color);--cr-input-error-color:var(--color-textfield-filled-error,var(--cr-fallback-color-error));--cr-input-focus-color:var(--color-textfield-filled-underline-focused,var(--cr-fallback-color-primary));--cr-input-hover-background-color:var(--cr-hover-background-color);--cr-input-label-color:var(--color-textfield-foreground-label,var(--cr-fallback-color-on-surface-subtle));--cr-input-padding-bottom:10px;--cr-input-padding-end:10px;--cr-input-padding-start:10px;--cr-input-padding-top:10px;--cr-input-placeholder-color:var(--color-textfield-foreground-placeholder,var(--cr-fallback-on-surface-subtle));display:block;isolation:isolate;outline:none}:host([readonly]){--cr-input-border-radius:8px 8px}#label{color:var(--cr-input-label-color);font-size:11px;line-height:16px}:host([focused_]:not([readonly]):not([invalid])) #label{color:var(--cr-input-focus-label-color,var(--cr-input-label-color))}#input-container{border-radius:var(--cr-input-border-radius,4px);overflow:hidden;position:relative;width:var(--cr-input-width,100%)}:host([focused_]) #input-container{outline:var(--cr-input-focus-outline,none)}#inner-input-container{background-color:var(--cr-input-background-color);box-sizing:border-box;padding:0}#inner-input-content ::slotted(*){--cr-icon-button-fill-color:var(--color-textfield-foreground-icon,var(--cr-fallback-color-on-surface-subtle));--cr-icon-button-icon-size:16px;--cr-icon-button-size:24px;--cr-icon-button-margin-start:0;--cr-icon-color:var(--color-textfield-foreground-icon,var(--cr-fallback-color-on-surface-subtle))}#inner-input-content ::slotted([slot='inline-prefix']){--cr-icon-button-margin-start:-8px}#inner-input-content ::slotted([slot='inline-suffix']){--cr-icon-button-margin-end:-4px}:host([invalid]) #inner-input-content ::slotted(*){--cr-icon-color:var(--cr-input-error-color);--cr-icon-button-fill-color:var(--cr-input-error-color)}#hover-layer{background-color:var(--cr-input-hover-background-color);display:none;inset:0;pointer-events:none;position:absolute;z-index:0}:host(:not([readonly]):not([disabled])) #input-container:hover #hover-layer{display:block}#input{-webkit-appearance:none;background-color:transparent;border:none;box-sizing:border-box;caret-color:var(--cr-input-focus-color);color:var(--cr-input-color);font-family:inherit;font-size:var(--cr-input-font-size,12px);font-weight:inherit;line-height:16px;min-height:var(--cr-input-min-height,auto);outline:none;padding:0;text-align:inherit;text-overflow:ellipsis;width:100%}#inner-input-content{padding-bottom:var(--cr-input-padding-bottom);padding-inline-end:var(--cr-input-padding-end);padding-inline-start:var(--cr-input-padding-start);padding-top:var(--cr-input-padding-top)}#underline{border-bottom:2px solid var(--cr-input-focus-color);border-radius:var(--cr-input-underline-border-radius,0);bottom:0;box-sizing:border-box;display:var(--cr-input-underline-display);height:var(--cr-input-underline-height,0);left:0;margin:auto;opacity:0;position:absolute;right:0;transition:opacity 120ms ease-out,width 0s linear 180ms;width:0}:host([invalid]) #underline,:host([force-underline]) #underline,:host([focused_]) #underline{opacity:1;transition:opacity 120ms ease-in,width 180ms ease-out;width:100%}#underline-base{display:none}:host([readonly]) #underline{display:none}:host(:not([readonly])) #underline-base{border-bottom:var(--cr-input-border-bottom);bottom:0;display:block;left:0;position:absolute;right:0}:host([disabled]){color:var(--color-textfield-foreground-disabled,var(--cr-fallback-color-disabled-foreground));--cr-input-border-bottom:1px solid currentColor;--cr-input-placeholder-color:currentColor;--cr-input-color:currentColor;--cr-input-background-color:var(--color-textfield-background-disabled,var(--cr-fallback-color-disabled-background))}:host([disabled]) #inner-input-content ::slotted(*){--cr-icon-color:currentColor;--cr-icon-button-fill-color:currentColor}:host(.stroked){--cr-input-background-color:transparent;--cr-input-border:1px solid var(--color-side-panel-textfield-border,var(--cr-fallback-color-neutral-outline));--cr-input-border-bottom:none;--cr-input-border-radius:8px;--cr-input-padding-bottom:9px;--cr-input-padding-end:9px;--cr-input-padding-start:9px;--cr-input-padding-top:9px;--cr-input-underline-display:none;--cr-input-min-height:36px;line-height:16px}:host(.stroked[focused_]){--cr-input-border:2px solid var(--cr-focus-outline-color);--cr-input-padding-bottom:8px;--cr-input-padding-end:8px;--cr-input-padding-start:8px;--cr-input-padding-top:8px}:host(.stroked[invalid]){--cr-input-border:1px solid var(--cr-input-error-color)}:host(.stroked[focused_][invalid]){--cr-input-border:2px solid var(--cr-input-error-color)}
    </style>
  </template>
`.content);styleMod.register("cr-input-style");function getTemplate$3(){return html$1`<!--_html_template_start_--><style include="cr-input-style">:host{display:block;position:absolute;transition:opacity 150ms linear}:host([invisible]){opacity:0}:host([disabled]),:host([invisible]){pointer-events:none}:host([side=top]) #lineContainer,:host([side=bottom]) #lineContainer{cursor:ns-resize;padding:8px 0;width:100%}:host([side=left]) #lineContainer,:host([side=right]) #lineContainer{cursor:ew-resize;height:100%;padding:0 8px}#line{border:1px dashed var(--google-blue-500)}@media (prefers-color-scheme:dark){#line{border-color:var(--google-blue-300)}}:host([side=top]) #line,:host([side=bottom]) #line{width:100%}:host([side=left]) #line,:host([side=right]) #line{height:100%}#row-container{border-radius:4px;font-size:0.8rem;min-height:25px;overflow:hidden;padding:1px;position:absolute}@media (prefers-color-scheme:light){#row-container{--cr-input-background-color:var(--cr-primary-text-color);--cr-input-color:white;background-color:var(--cr-primary-text-color);color:white}}@media (prefers-color-scheme:dark){#row-container{--cr-input-background-color:rgb(27,28,30);--cr-input-color:var(--cr-primary-text-color);background-color:rgb(27,28,30);color:var(--cr-primary-text-color)}}:host([side=top]) #row-container{left:50%;top:9px}:host([side=right]) #row-container{right:9px;top:50%}:host([side=bottom]) #row-container{bottom:9px;right:50%}:host([side=left]) #row-container{bottom:50%;left:9px}:host([disabled]) #row-container{opacity:var(--cr-disabled-opacity)}:host([invalid]) #input{caret-color:var(--cr-input-error-color)}:host([invalid]) #underline{border-color:var(--cr-input-error-color)}#row-container,#input-container{align-items:center;display:flex}#input-container{position:relative}#input{padding-inline-end:0;text-align:end;width:44px}#unit{padding-inline-end:8px}</style>
  <div id="lineContainer">
    <div id="line"></div>
  </div>
  <div id="row-container">
    <div id="input-container">
      <input id="input" disabled="[[disabled]]" aria-label$="[[i18n(side)]]"
          aria-hidden$="[[getAriaHidden_(invisible)]]"
          on-focus="onFocus_" on-blur="onBlur_" data-timeout-delay="1000">
      <span id="unit">[[measurementSystem.unitSymbol]]</span>
    </div>
    <div id="underline"></div>
  </div>
</div>
<!--_html_template_end_-->`}
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const RADIUS_PX=9;const PrintPreviewMarginControlElementBase=I18nMixin(WebUiListenerMixin(InputMixin(PolymerElement)));class PrintPreviewMarginControlElement extends PrintPreviewMarginControlElementBase{static get is(){return"print-preview-margin-control"}static get template(){return getTemplate$3()}static get properties(){return{disabled:{type:Boolean,reflectToAttribute:true,observer:"onDisabledChange_"},side:{type:String,reflectToAttribute:true},invalid:{type:Boolean,reflectToAttribute:true},invisible:{type:Boolean,reflectToAttribute:true,observer:"onClipSizeChange_"},measurementSystem:Object,focused_:{type:Boolean,reflectToAttribute:true,value:false},positionInPts_:{type:Number,notify:true,value:0},scaleTransform:{type:Number,notify:true},translateTransform:{type:Object,notify:true},pageSize:{type:Object,notify:true},clipSize:{type:Object,notify:true,observer:"onClipSizeChange_"}}}static get observers(){return["updatePosition_(positionInPts_, scaleTransform, translateTransform, "+"pageSize, side)"]}ready(){super.ready();this.addEventListener("input-change",(e=>this.onInputChange_(e)))}getInput(){return this.$.input}setTextboxValue(valueInPts){const textbox=this.$.input;const pts=textbox.value?this.parseValueToPts_(textbox.value):null;if(pts!==null&&valueInPts===Math.round(pts)){return}textbox.value=this.serializeValueFromPts_(valueInPts);this.resetString()}getPositionInPts(){return this.positionInPts_}setPositionInPts(position){this.positionInPts_=position}getAriaHidden_(){return this.invisible.toString()}convertPixelsToPts(pixels){let pts;const Orientation=CustomMarginsOrientation;if(this.side===Orientation.TOP){pts=pixels-this.translateTransform.y+RADIUS_PX;pts/=this.scaleTransform}else if(this.side===Orientation.RIGHT){pts=pixels-this.translateTransform.x+RADIUS_PX;pts/=this.scaleTransform;pts=this.pageSize.width-pts}else if(this.side===Orientation.BOTTOM){pts=pixels-this.translateTransform.y+RADIUS_PX;pts/=this.scaleTransform;pts=this.pageSize.height-pts}else{assert(this.side===Orientation.LEFT);pts=pixels-this.translateTransform.x+RADIUS_PX;pts/=this.scaleTransform}return pts}shouldDrag(event){return!this.disabled&&event.button===0&&(event.composedPath()[0]===this.$.lineContainer||event.composedPath()[0]===this.$.line)}onDisabledChange_(){if(this.disabled){this.focused_=false}}parseValueToPts_(value){value=value.trim();if(value.length===0){return null}assert(this.measurementSystem);const decimal=this.measurementSystem.decimalDelimiter;const thousands=this.measurementSystem.thousandsDelimiter;const whole=`(?:0|[1-9]\\d*|[1-9]\\d{0,2}(?:[${thousands}]\\d{3})*)`;const fractional=`(?:[${decimal}]\\d+)`;const wholeDecimal=`(?:${whole}[${decimal}])`;const validationRegex=new RegExp(`^-?(?:${whole}${fractional}?|${fractional}|${wholeDecimal})$`);if(validationRegex.test(value)){value=value.replace(new RegExp(`\\${thousands}`,"g"),"").replace(decimal,".");return this.measurementSystem.convertToPoints(parseFloat(value))}return null}serializeValueFromPts_(value){assert(this.measurementSystem);value=this.measurementSystem.convertFromPoints(value);value=this.measurementSystem.roundValue(value);return value.toString().replace(".",this.measurementSystem.decimalDelimiter)}fire_(eventName,detail){this.dispatchEvent(new CustomEvent(eventName,{bubbles:true,composed:true,detail:detail}))}onInputChange_(e){if(e.detail===""){return}const value=this.parseValueToPts_(e.detail);if(value===null){this.invalid=true;return}this.fire_("text-change",value)}onBlur_(){this.focused_=false;this.resetAndUpdate();this.fire_("text-blur",this.invalid||!this.$.input.value)}onFocus_(){this.focused_=true;this.fire_("text-focus")}updatePosition_(){if(!observerDepsDefined(Array.from(arguments))){return}const Orientation=CustomMarginsOrientation;let x=this.translateTransform.x;let y=this.translateTransform.y;let width=null;let height=null;if(this.side===Orientation.TOP){y=this.scaleTransform*this.positionInPts_+this.translateTransform.y-RADIUS_PX;width=this.scaleTransform*this.pageSize.width}else if(this.side===Orientation.RIGHT){x=this.scaleTransform*(this.pageSize.width-this.positionInPts_)+this.translateTransform.x-RADIUS_PX;height=this.scaleTransform*this.pageSize.height}else if(this.side===Orientation.BOTTOM){y=this.scaleTransform*(this.pageSize.height-this.positionInPts_)+this.translateTransform.y-RADIUS_PX;width=this.scaleTransform*this.pageSize.width}else{x=this.scaleTransform*this.positionInPts_+this.translateTransform.x-RADIUS_PX;height=this.scaleTransform*this.pageSize.height}window.requestAnimationFrame((()=>{this.style.left=Math.round(x)+"px";this.style.top=Math.round(y)+"px";if(width!==null){this.style.width=Math.round(width)+"px"}if(height!==null){this.style.height=Math.round(height)+"px"}}));this.onClipSizeChange_()}onClipSizeChange_(){if(!this.clipSize){return}window.requestAnimationFrame((()=>{const offsetLeft=this.offsetLeft;const offsetTop=this.offsetTop;this.style.clip="rect("+-offsetTop+"px, "+(this.clipSize.width-offsetLeft)+"px, "+(this.clipSize.height-offsetTop)+"px, "+-offsetLeft+"px)"}))}}customElements.define(PrintPreviewMarginControlElement.is,PrintPreviewMarginControlElement);function getTemplate$2(){return html$1`<!--_html_template_start_--><style>:host{display:block;left:0;position:absolute;top:0}:host([dragging_=dragging-vertical]){cursor:ns-resize}:host([dragging_=dragging-horizontal]){cursor:ew-resize}</style>
<template is="dom-repeat" items="[[marginSides_]]">
  <print-preview-margin-control side="[[item]]" invisible="[[invisible_]]"
      disabled="[[controlsDisabled_(state, invisible_)]]"
      translate-transform="[[translateTransform_]]"
      clip-size="[[clipSize_]]"
      measurement-system="[[measurementSystem]]"
      scale-transform="[[scaleTransform_]]"
      page-size="[[pageSize]]"
      on-pointerdown="onPointerDown_"
      on-text-change="onTextChange_" on-text-blur="onTextBlur_"
      on-text-focus="onTextFocus_" on-transition-end="onTransitionEnd_">
  </print-preview-margin-control>
</template>
<!--_html_template_end_-->`}
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const MARGIN_KEY_MAP=new Map([[CustomMarginsOrientation.TOP,"marginTop"],[CustomMarginsOrientation.RIGHT,"marginRight"],[CustomMarginsOrientation.BOTTOM,"marginBottom"],[CustomMarginsOrientation.LEFT,"marginLeft"]]);const MINIMUM_DISTANCE=72;const PrintPreviewMarginControlContainerElementBase=SettingsMixin(PolymerElement);class PrintPreviewMarginControlContainerElement extends PrintPreviewMarginControlContainerElementBase{constructor(){super(...arguments);this.pointerStartPositionInPixels_=new Coordinate2d(0,0);this.marginStartPositionInPixels_=null;this.resetMargins_=null;this.eventTracker_=new EventTracker;this.textboxFocused_=false}static get is(){return"print-preview-margin-control-container"}static get template(){return getTemplate$2()}static get properties(){return{pageSize:{type:Object,notify:true},documentMargins:{type:Object,notify:true},previewLoaded:Boolean,measurementSystem:Object,state:{type:Number,observer:"onStateChanged_"},scaleTransform_:{type:Number,notify:true,value:0},translateTransform_:{type:Object,notify:true,value:new Coordinate2d(0,0)},clipSize_:{type:Object,notify:true,value:null},available_:{type:Boolean,notify:true,computed:"computeAvailable_(previewLoaded, settings.margins.value)",observer:"onAvailableChange_"},invisible_:{type:Boolean,reflectToAttribute:true,value:true},marginSides_:{type:Array,notify:true,value:[CustomMarginsOrientation.TOP,CustomMarginsOrientation.RIGHT,CustomMarginsOrientation.BOTTOM,CustomMarginsOrientation.LEFT]},dragging_:{type:String,reflectToAttribute:true,value:""}}}static get observers(){return["onMarginSettingsChange_(settings.customMargins.value)","onMediaSizeOrLayoutChange_("+"settings.mediaSize.value, settings.layout.value)"]}computeAvailable_(){return this.previewLoaded&&!!this.clipSize_&&this.getSettingValue("margins")===MarginsType.CUSTOM&&!!this.pageSize}onAvailableChange_(){if(this.available_&&this.resetMargins_){const newMargins={};for(const side of Object.values(CustomMarginsOrientation)){const key=MARGIN_KEY_MAP.get(side);newMargins[key]=this.documentMargins.get(side)}this.setSetting("customMargins",newMargins);this.resetMargins_=false}this.invisible_=!this.available_}onMarginSettingsChange_(){const margins=this.getSettingValue("customMargins");if(!margins||margins.marginTop===undefined){return}this.shadowRoot.querySelectorAll("print-preview-margin-control").forEach((control=>{const key=MARGIN_KEY_MAP.get(control.side);const newValue=margins[key]||0;control.setPositionInPts(newValue);control.setTextboxValue(newValue)}))}onMediaSizeOrLayoutChange_(){if(this.resetMargins_===null){return}this.resetMargins_=true;this.setSetting("customMargins",{})}onStateChanged_(){if(this.state===State.READY&&this.resetMargins_===null){const margins=this.getSettingValue("customMargins");this.resetMargins_=!margins||margins.marginTop===undefined}}controlsDisabled_(){return this.state!==State.READY||this.invisible_}isTopOrBottom_(orientation){return orientation===CustomMarginsOrientation.TOP||orientation===CustomMarginsOrientation.BOTTOM}posInPixelsToPts_(control,posInPixels){const side=control.side;return this.clipAndRoundValue_(side,control.convertPixelsToPts(this.isTopOrBottom_(side)?posInPixels.y:posInPixels.x))}moveControlWithConstraints_(control,posInPts){control.setPositionInPts(posInPts);control.setTextboxValue(posInPts)}translatePointerToPositionInPixels(pointerPosition){return new Coordinate2d(pointerPosition.x-this.pointerStartPositionInPixels_.x+this.marginStartPositionInPixels_.x,pointerPosition.y-this.pointerStartPositionInPixels_.y+this.marginStartPositionInPixels_.y)}onPointerMove_(event){const control=event.target;const posInPts=this.posInPixelsToPts_(control,this.translatePointerToPositionInPixels(new Coordinate2d(event.x,event.y)));this.moveControlWithConstraints_(control,posInPts)}onPointerUp_(event){const control=event.target;this.dragging_="";const posInPixels=this.translatePointerToPositionInPixels(new Coordinate2d(event.x,event.y));const posInPts=this.posInPixelsToPts_(control,posInPixels);this.moveControlWithConstraints_(control,posInPts);this.setMargin_(control.side,posInPts);this.updateClippingMask(this.clipSize_);this.eventTracker_.remove(control,"pointercancel");this.eventTracker_.remove(control,"pointerup");this.eventTracker_.remove(control,"pointermove");this.fireDragChanged_(false)}setInvisible(invisible){if(!this.available_){return}if(invisible&&(this.dragging_!==""||this.textboxFocused_)){return}this.invisible_=invisible}onTextFocus_(e){this.textboxFocused_=true;const control=e.target;const x=control.offsetLeft;const y=control.offsetTop;const isTopOrBottom=this.isTopOrBottom_(control.side);const position={};const padding=Math.min(Math.min(this.clipSize_.width/2,this.clipSize_.height/2),50);if(isTopOrBottom){position.x=Math.min(x+control.offsetWidth/2-padding,0);position.x=Math.max(x+control.offsetWidth/2+padding-this.clipSize_.width,position.x);position.y=Math.min(y-padding,0);position.y=Math.max(y-this.clipSize_.height+padding,position.y)}else{position.x=Math.min(x-padding,0);position.x=Math.max(x-this.clipSize_.width+padding,position.x);position.y=Math.min(y+control.offsetHeight/2-padding,0);position.y=Math.max(y+control.offsetHeight/2+padding-this.clipSize_.height,position.y)}this.dispatchEvent(new CustomEvent("text-focus-position",{bubbles:true,composed:true,detail:position}))}setMargin_(marginSide,marginValue){const oldMargins=this.getSettingValue("customMargins");const key=MARGIN_KEY_MAP.get(marginSide);if(oldMargins[key]===marginValue){return}const newMargins=Object.assign({},oldMargins);newMargins[key]=marginValue;this.setSetting("customMargins",newMargins)}clipAndRoundValue_(marginSide,value){if(value<0){return 0}const Orientation=CustomMarginsOrientation;let limit=0;const margins=this.getSettingValue("customMargins");if(marginSide===Orientation.TOP){limit=this.pageSize.height-margins.marginBottom-MINIMUM_DISTANCE}else if(marginSide===Orientation.RIGHT){limit=this.pageSize.width-margins.marginLeft-MINIMUM_DISTANCE}else if(marginSide===Orientation.BOTTOM){limit=this.pageSize.height-margins.marginTop-MINIMUM_DISTANCE}else{assert(marginSide===Orientation.LEFT);limit=this.pageSize.width-margins.marginRight-MINIMUM_DISTANCE}return Math.round(Math.min(value,limit))}onTextChange_(e){const control=e.target;control.invalid=false;const clippedValue=this.clipAndRoundValue_(control.side,e.detail);control.setPositionInPts(clippedValue);this.setMargin_(control.side,clippedValue)}onTextBlur_(e){const control=e.target;control.setTextboxValue(control.getPositionInPts());if(e.detail){control.invalid=false}this.textboxFocused_=false}onPointerDown_(e){const control=e.target;if(!control.shouldDrag(e)){return}this.pointerStartPositionInPixels_=new Coordinate2d(e.x,e.y);this.marginStartPositionInPixels_=new Coordinate2d(control.offsetLeft,control.offsetTop);this.dragging_=this.isTopOrBottom_(control.side)?"dragging-vertical":"dragging-horizontal";this.eventTracker_.add(control,"pointercancel",(e=>this.onPointerUp_(e)));this.eventTracker_.add(control,"pointerup",(e=>this.onPointerUp_(e)));this.eventTracker_.add(control,"pointermove",(e=>this.onPointerMove_(e)));control.setPointerCapture(e.pointerId);this.fireDragChanged_(true)}fireDragChanged_(dragChanged){this.dispatchEvent(new CustomEvent("margin-drag-changed",{bubbles:true,composed:true,detail:dragChanged}))}onTransitionEnd_(){if(this.invisible_){this.style.display="none"}}updateTranslationTransform(translateTransform){if(!translateTransform.equals(this.translateTransform_)){this.translateTransform_=translateTransform}}updateScaleTransform(scaleTransform){if(scaleTransform!==this.scaleTransform_){this.scaleTransform_=scaleTransform}}updateClippingMask(clipSize){if(!clipSize){return}this.clipSize_=clipSize;this.notifyPath("clipSize_")}}customElements.define(PrintPreviewMarginControlContainerElement.is,PrintPreviewMarginControlContainerElement);
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class PluginProxyImpl{constructor(){this.plugin_=null}pluginReady(){return!!this.plugin_}createPlugin(previewUid,index){assert(!this.plugin_);const srcUrl=this.getPreviewUrl_(previewUid,index);this.plugin_=pdfCreateOutOfProcessPlugin(srcUrl,"chrome://print/pdf/index_print.html");this.plugin_.classList.add("preview-area-plugin");this.plugin_.setAttribute("id","pdf-viewer");return this.plugin_}getPreviewUrl_(previewUid,index){return`chrome-untrusted://print/${previewUid}/${index}/print.pdf`}resetPrintPreviewMode(previewUid,index,color,pages,modifiable){this.plugin_.resetPrintPreviewMode(this.getPreviewUrl_(previewUid,index),color,pages,modifiable)}scrollPosition(scrollX,scrollY){this.plugin_.scrollPosition(scrollX,scrollY)}sendKeyEvent(e){this.plugin_.sendKeyEvent(e)}hideToolbar(){this.plugin_.hideToolbar()}setPointerEvents(eventsEnabled){this.plugin_.style.pointerEvents=eventsEnabled?"auto":"none"}loadPreviewPage(previewUid,pageIndex,index){this.plugin_.loadPreviewPage(this.getPreviewUrl_(previewUid,pageIndex),index)}setKeyEventCallback(keyEventCallback){this.plugin_.setKeyEventCallback(keyEventCallback)}setLoadCompleteCallback(loadCompleteCallback){this.plugin_.setLoadCompleteCallback(loadCompleteCallback)}setViewportChangedCallback(viewportChangedCallback){this.plugin_.setViewportChangedCallback(viewportChangedCallback)}darkModeChanged(darkMode){this.plugin_.darkModeChanged(darkMode)}static setInstance(obj){instance=obj}static getInstance(){return instance||(instance=new PluginProxyImpl)}}let instance=null;function getTemplate$1(){return html$1`<!--_html_template_start_--><style include="cr-hidden-style">@keyframes dancing-dots-jump{0%{top:0}55%{top:0}60%{top:-10px}80%{top:3px}90%{top:-2px}95%{top:1px}100%{top:0}}:host([show-cros-printer-setup-info_]) .preview-area-message{background:rgb(255,255,255);border-radius:16px;display:flex;flex-direction:column;height:100%;justify-content:center;margin:16px}@media (prefers-color-scheme:dark){:host([show-cros-printer-setup-info_]) .preview-area-message{background:rgb(40,41,44)}}span.jumping-dots>span{animation:dancing-dots-jump 1800ms infinite;padding:1px;position:relative}span.jumping-dots>span:nth-child(2){animation-delay:100ms}span.jumping-dots>span:nth-child(3){animation-delay:300ms}:host{display:block;height:100%;overflow:hidden;position:relative;user-select:none}.preview-area-plugin-wrapper{height:100%}.preview-area-plugin{border:none;cursor:inherit;height:100%;opacity:1;transition:opacity 200ms linear;transition-delay:100ms;width:100%}.preview-area-overlay-layer{background:var(--preview-area-background-color);display:flex;flex-direction:column;height:100%;justify-content:center;margin:0;opacity:1;position:absolute;transition:opacity 200ms linear;transition-delay:350ms;user-select:none;width:100%;z-index:1}.preview-area-overlay-layer.invisible{opacity:0;pointer-events:none;transition:opacity 100ms linear}.preview-area-message{color:var(--cr-primary-text-color);line-height:20px;margin:0 10px;position:relative;text-align:center}</style>
<div class$="preview-area-overlay-layer [[getInvisible_(previewState)]]"
    aria-hidden$="[[getAriaHidden_(previewState)]]">
  <div class="preview-area-message">
    <div>
      <span
          hidden$="[[showCrosPrinterSetupInfo_]]"
          inner-h-t-m-l="[[currentMessage_(previewState)]]">
      </span>
      <span class$="preview-area-loading-message-jumping-dots
                    [[getJumpingDots_(previewState)]]"
          hidden$="[[!isPreviewLoading_(previewState)]]">
          <span>.</span><span>.</span><span>.</span>
      </span>
    </div>
    
      <print-preview-printer-setup-info-cros
          hidden$="[[!showCrosPrinterSetupInfo_]]"
          message-type="[[printerSetupInfoMessageTypeEnum_.PRINTER_OFFLINE]]"
          initiator="[[printerSetupInfoInitiatorEnum_.PREVIEW_AREA]]">
      </print-preview-printer-setup-info-cros>
    
  </div>
</div>
<div class="preview-area-plugin-wrapper"></div>
<print-preview-margin-control-container id="marginControlContainer"
    page-size="[[pageSize]]" settings="[[settings]]"
    document-margins="[[margins]]"
    measurement-system="[[measurementSystem]]" state="[[state]]"
    preview-loaded="[[previewLoaded_]]"
    on-text-focus-position="onTextFocusPosition_"
    on-margin-drag-changed="onMarginDragChanged_">
</print-preview-margin-control-container>
<!--_html_template_end_-->`}
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var PreviewAreaState;(function(PreviewAreaState){PreviewAreaState["LOADING"]="loading";PreviewAreaState["DISPLAY_PREVIEW"]="display-preview";PreviewAreaState["OPEN_IN_PREVIEW_LOADING"]="open-in-preview-loading";PreviewAreaState["OPEN_IN_PREVIEW_LOADED"]="open-in-preview-loaded";PreviewAreaState["ERROR"]="error"})(PreviewAreaState||(PreviewAreaState={}));function shouldShowCrosPrinterSetupError(state,error){return state===State.ERROR&&error===Error$1.INVALID_PRINTER}const PrintPreviewPreviewAreaElementBase=WebUiListenerMixin(I18nMixin(SettingsMixin(DarkModeMixin(PolymerElement))));class PrintPreviewPreviewAreaElement extends PrintPreviewPreviewAreaElementBase{constructor(){super(...arguments);this.showCrosPrinterSetupInfo_=false;this.nativeLayer_=null;this.lastTicket_=null;this.inFlightRequestId_=-1;this.pluginProxy_=PluginProxyImpl.getInstance();this.keyEventCallback_=null}static get is(){return"print-preview-preview-area"}static get template(){return getTemplate$1()}static get properties(){return{destination:Object,documentModifiable:Boolean,error:{type:Number,notify:true},margins:Object,measurementSystem:Object,pageSize:Object,previewState:{type:String,notify:true,value:PreviewAreaState.LOADING},state:Number,pluginLoadComplete_:{type:Boolean,value:false},documentReady_:{type:Boolean,value:false},previewLoaded_:{type:Boolean,notify:true,computed:"computePreviewLoaded_(documentReady_, pluginLoadComplete_)"},printerSetupInfoMessageTypeEnum_:{type:Number,value:PrinterSetupInfoMessageType,readOnly:true},printerSetupInfoInitiatorEnum_:{type:Number,value:PrinterSetupInfoInitiator,readOnly:true},showCrosPrinterSetupInfo_:{type:Boolean,computed:"computeShowCrosPrinterSetupInfo(state, error)",reflectToAttribute:true}}}static get observers(){return["onDarkModeChanged_(inDarkMode)","pluginOrDocumentStatusChanged_(pluginLoadComplete_, documentReady_)","onStateOrErrorChange_(state, error)"]}connectedCallback(){super.connectedCallback();this.nativeLayer_=NativeLayerImpl.getInstance();this.addWebUiListener("page-preview-ready",this.onPagePreviewReady_.bind(this))}computePreviewLoaded_(){return this.documentReady_&&this.pluginLoadComplete_}getLastTicketForTest(){return this.lastTicket_}previewLoaded(){return this.previewLoaded_}onPointerOver_(event){const marginControlContainer=this.$.marginControlContainer;let fromElement=event.relatedTarget;while(fromElement!==null){if(fromElement===marginControlContainer){return}fromElement=fromElement.parentElement}marginControlContainer.setInvisible(false)}onPointerOut_(event){const marginControlContainer=this.$.marginControlContainer;let toElement=event.relatedTarget;while(toElement!==null){if(toElement===marginControlContainer){return}toElement=toElement.parentElement}marginControlContainer.setInvisible(true)}pluginOrDocumentStatusChanged_(){if(!this.pluginLoadComplete_||!this.documentReady_||this.previewState===PreviewAreaState.ERROR){return}this.previewState=this.previewState===PreviewAreaState.OPEN_IN_PREVIEW_LOADING?PreviewAreaState.OPEN_IN_PREVIEW_LOADED:PreviewAreaState.DISPLAY_PREVIEW}getInvisible_(){return this.isInDisplayPreviewState_()?"invisible":""}getAriaHidden_(){return this.isInDisplayPreviewState_().toString()}isInDisplayPreviewState_(){return this.previewState===PreviewAreaState.DISPLAY_PREVIEW}isPreviewLoading_(){return this.previewState===PreviewAreaState.LOADING}getJumpingDots_(){return this.isPreviewLoading_()?"jumping-dots":""}currentMessage_(){switch(this.previewState){case PreviewAreaState.LOADING:return this.i18nAdvanced("loading");case PreviewAreaState.DISPLAY_PREVIEW:return window.trustedTypes.emptyHTML;case PreviewAreaState.ERROR:return this.getErrorMessage_();default:return window.trustedTypes.emptyHTML}}startPreview(forceUpdate){if(!this.hasTicketChanged_()&&!forceUpdate&&this.previewState!==PreviewAreaState.ERROR){return}this.previewState=PreviewAreaState.LOADING;this.documentReady_=false;this.getPreview_().then((previewUid=>{if(!this.documentModifiable){this.onPreviewStart_(previewUid,-1)}this.documentReady_=true}),(type=>{if(type==="SETTINGS_INVALID"){this.error=Error$1.INVALID_PRINTER;this.previewState=PreviewAreaState.ERROR}else if(type!=="CANCELLED"){console.warn("Preview failed in getPreview(): "+type);this.error=Error$1.PREVIEW_FAILED;this.previewState=PreviewAreaState.ERROR}}))}onPreviewStart_(previewUid,index){if(!this.pluginProxy_.pluginReady()){const plugin=this.pluginProxy_.createPlugin(previewUid,index);this.pluginProxy_.setKeyEventCallback(this.keyEventCallback_);this.shadowRoot.querySelector(".preview-area-plugin-wrapper").appendChild(plugin);this.pluginProxy_.setLoadCompleteCallback(this.onPluginLoadComplete_.bind(this));this.pluginProxy_.setViewportChangedCallback(this.onPreviewVisualStateChange_.bind(this))}this.pluginLoadComplete_=false;if(this.inDarkMode){this.pluginProxy_.darkModeChanged(true)}this.pluginProxy_.resetPrintPreviewMode(previewUid,index,!this.getSettingValue("color"),this.getSettingValue("pages"),this.documentModifiable)}onPluginLoadComplete_(success){if(success){this.pluginLoadComplete_=true}else{console.warn("Preview failed in onPluginLoadComplete_()");this.error=Error$1.PREVIEW_FAILED;this.previewState=PreviewAreaState.ERROR}}onPreviewVisualStateChange_(pageX,pageY,pageWidth,viewportWidth,viewportHeight){const tabindex=viewportWidth<300||viewportHeight<200?"-1":"0";this.shadowRoot.querySelector(".preview-area-plugin").setAttribute("tabindex",tabindex);this.$.marginControlContainer.updateTranslationTransform(new Coordinate2d(pageX,pageY));this.$.marginControlContainer.updateScaleTransform(pageWidth/this.pageSize.width);this.$.marginControlContainer.updateClippingMask(new Size(viewportWidth,viewportHeight));const previewDocument=this.shadowRoot.querySelector(".preview-area-plugin").contentDocument;if(previewDocument&&previewDocument.documentElement){this.$.marginControlContainer.style.left=previewDocument.documentElement.offsetLeft+"px"}}onPagePreviewReady_(pageIndex,previewUid,previewResponseId){if(this.inFlightRequestId_!==previewResponseId){return}const pageNumber=pageIndex+1;let index=this.getSettingValue("pages").indexOf(pageNumber);const pagesPerSheet=this.getSettingValue("pagesPerSheet");if(pagesPerSheet>1){index=pageIndex}if(index===0){this.onPreviewStart_(previewUid,pageIndex)}if(index!==-1){this.pluginProxy_.loadPreviewPage(previewUid,pageIndex,index)}}onDarkModeChanged_(){if(this.pluginProxy_.pluginReady()){this.pluginProxy_.darkModeChanged(this.inDarkMode)}if(this.previewState===PreviewAreaState.DISPLAY_PREVIEW){this.startPreview(true)}}handleDirectionalKeyEvent(e){if(!this.pluginProxy_.pluginReady()||!["PageUp","PageDown","ArrowLeft","ArrowRight","ArrowUp","ArrowDown"].includes(e.key)||hasKeyModifiers(e)){return}const tagName=e.composedPath()[0].tagName;if(["INPUT","SELECT","EMBED"].includes(tagName)){return}const isEventHorizontal=["ArrowLeft","ArrowRight"].includes(e.key);for(let i=0;i<e.composedPath().length;i++){const element=e.composedPath()[i];if(element.scrollHeight>element.clientHeight&&!isEventHorizontal||element.scrollWidth>element.clientWidth&&isEventHorizontal){return}}this.pluginProxy_.sendKeyEvent(e);e.preventDefault()}hideToolbar(){if(!this.pluginProxy_.pluginReady()){return}this.pluginProxy_.hideToolbar()}setPluginKeyEventCallback(callback){this.keyEventCallback_=callback}onMarginDragChanged_(e){if(!this.pluginProxy_.pluginReady()){return}this.pluginProxy_.setPointerEvents(!e.detail)}onTextFocusPosition_(e){this.scrollTop=0;this.scrollLeft=0;const position=e.detail;if(position.x===0&&position.y===0){return}this.pluginProxy_.scrollPosition(position.x,position.y)}marginsValid_(){const type=this.getSettingValue("margins");if(!Object.values(MarginsType).includes(type)){return false}if(type!==MarginsType.CUSTOM){return true}const customMargins=this.getSettingValue("customMargins");return customMargins.marginTop!==undefined&&customMargins.marginLeft!==undefined&&customMargins.marginBottom!==undefined&&customMargins.marginRight!==undefined}hasTicketChanged_(){if(!this.marginsValid_()){return false}if(!this.lastTicket_){return true}const lastTicket=this.lastTicket_;const newMarginsType=this.getSettingValue("margins");if(newMarginsType!==lastTicket.marginsType&&newMarginsType!==MarginsType.CUSTOM){return true}if(newMarginsType===MarginsType.CUSTOM){const customMargins=this.getSettingValue("customMargins");if(!!lastTicket.marginsCustom&&(lastTicket.marginsCustom.marginTop!==customMargins.marginTop||lastTicket.marginsCustom.marginLeft!==customMargins.marginLeft||lastTicket.marginsCustom.marginRight!==customMargins.marginRight||lastTicket.marginsCustom.marginBottom!==customMargins.marginBottom)){return true}if(!this.margins){return false}const customMarginsChanged=Object.values(CustomMarginsOrientation).some((side=>this.margins.get(side)!==customMargins[MARGIN_KEY_MAP.get(side)]));if(customMarginsChanged){return true}}if(!areRangesEqual(this.getSettingValue("ranges"),lastTicket.pageRange)||this.getSettingValue("layout")!==lastTicket.landscape||this.getColorForTicket_()!==lastTicket.color||this.getSettingValue("headerFooter")!==lastTicket.headerFooterEnabled||this.getSettingValue("cssBackground")!==lastTicket.shouldPrintBackgrounds||this.getSettingValue("selectionOnly")!==lastTicket.shouldPrintSelectionOnly||this.getSettingValue("rasterize")!==lastTicket.rasterizePDF||this.isScalingChanged_(lastTicket)){return true}if(this.getSettingValue("pagesPerSheet")!==lastTicket.pagesPerSheet&&this.getSettingValue("margins")===MarginsType.DEFAULT){return true}const newValue=this.getSettingValue("mediaSize");if(newValue.height_microns!==lastTicket.mediaSize.height_microns||newValue.width_microns!==lastTicket.mediaSize.width_microns||newValue.imageable_area_left_microns!==lastTicket.mediaSize.imageable_area_left_microns||newValue.imageable_area_bottom_microns!==lastTicket.mediaSize.imageable_area_bottom_microns||newValue.imageable_area_right_microns!==lastTicket.mediaSize.imageable_area_right_microns||newValue.imageable_area_top_microns!==lastTicket.mediaSize.imageable_area_top_microns||this.destination.id!==lastTicket.deviceName&&this.getSettingValue("margins")===MarginsType.MINIMUM){return true}if(this.destination.type!==lastTicket.printerType){return true}return false}getColorForTicket_(){return this.destination.getNativeColorModel(this.getSettingValue("color"))}getScaleFactorForTicket_(){return this.getSettingValue(this.getScalingSettingKey_())===ScalingType.CUSTOM?parseInt(this.getSettingValue("scaling"),10):100}getScalingSettingKey_(){return this.getSetting("scalingTypePdf").available?"scalingTypePdf":"scalingType"}isScalingChanged_(lastTicket){if(this.getScaleFactorForTicket_()!==lastTicket.scaleFactor){return true}const scalingType=this.getSettingValue(this.getScalingSettingKey_());if(scalingType===lastTicket.scalingType){return false}const defaultToCustom=scalingType===ScalingType.DEFAULT&&lastTicket.scalingType===ScalingType.CUSTOM;const customToDefault=scalingType===ScalingType.CUSTOM&&lastTicket.scalingType===ScalingType.DEFAULT;return!defaultToCustom&&!customToDefault}getDpiForTicket_(dpiField){const dpi=this.getSettingValue("dpi");const value=dpi&&dpiField in dpi?dpi[dpiField]:0;return value}getPreview_(){this.inFlightRequestId_++;const ticket={pageRange:this.getSettingValue("ranges"),mediaSize:this.getSettingValue("mediaSize"),landscape:this.getSettingValue("layout"),color:this.getColorForTicket_(),headerFooterEnabled:this.getSettingValue("headerFooter"),marginsType:this.getSettingValue("margins"),pagesPerSheet:this.getSettingValue("pagesPerSheet"),isFirstRequest:this.inFlightRequestId_===0,requestID:this.inFlightRequestId_,previewModifiable:this.documentModifiable,scaleFactor:this.getScaleFactorForTicket_(),scalingType:this.getSettingValue(this.getScalingSettingKey_()),shouldPrintBackgrounds:this.getSettingValue("cssBackground"),shouldPrintSelectionOnly:this.getSettingValue("selectionOnly"),collate:true,copies:1,deviceName:this.destination.id,dpiHorizontal:this.getDpiForTicket_("horizontal_dpi"),dpiVertical:this.getDpiForTicket_("vertical_dpi"),duplex:this.getSettingValue("duplex")?DuplexMode.LONG_EDGE:DuplexMode.SIMPLEX,printerType:this.destination.type,rasterizePDF:this.getSettingValue("rasterize")};if(this.getSettingValue("margins")===MarginsType.CUSTOM){ticket.marginsCustom=this.getSettingValue("customMargins")}this.lastTicket_=ticket;this.dispatchEvent(new CustomEvent("preview-start",{bubbles:true,composed:true,detail:this.inFlightRequestId_}));return this.nativeLayer_.getPreview(JSON.stringify(ticket))}onStateOrErrorChange_(){if((this.state===State.ERROR||this.state===State.FATAL_ERROR)&&this.getErrorMessage_().toString()!==""){this.previewState=PreviewAreaState.ERROR}}getErrorMessage_(){switch(this.error){case Error$1.INVALID_PRINTER:return this.i18nAdvanced("invalidPrinterSettings",{substitutions:[],tags:["BR"]});case Error$1.NO_DESTINATIONS:return this.i18nAdvanced("noDestinationsMessage");case Error$1.PREVIEW_FAILED:return this.i18nAdvanced("previewFailed");default:return window.trustedTypes.emptyHTML}}computeShowCrosPrinterSetupInfo(){return shouldShowCrosPrinterSetupError(this.state,this.error)}}customElements.define(PrintPreviewPreviewAreaElement.is,PrintPreviewPreviewAreaElement);
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PrintPreviewDestinationSelectCrosElementBase=I18nMixin(SelectMixin(PolymerElement));class PrintPreviewDestinationSelectCrosElement extends PrintPreviewDestinationSelectCrosElementBase{static get is(){return"print-preview-destination-select-cros"}static get template(){return getTemplate$4()}static get properties(){return{activeUser:String,dark:Boolean,destination:Object,disabled:Boolean,driveDestinationKey:String,loaded:Boolean,noDestinations:Boolean,pdfPrinterDisabled:Boolean,recentDestinationList:{type:Array,observer:"onRecentDestinationListChanged_"},pdfDestinationKey_:{type:String,value:PDF_DESTINATION_KEY},statusText_:{type:String,computed:"computeStatusText_(destination, "+"destination.printerStatusReason, state, error)"},destinationIcon_:{type:String,computed:"computeDestinationIcon_("+"selectedValue, destination, destination.printerStatusReason,"+"isDarkModeActive_, state, error)"},isCurrentDestinationCrosLocal_:{type:Boolean,computed:"computeIsCurrentDestinationCrosLocal_(destination)",reflectToAttribute:true},isDarkModeActive_:Boolean,state:Number,error:Number}}focus(){this.shadowRoot.querySelector("print-preview-destination-dropdown-cros").focus()}updateDestination(){this.selectedValue=this.destination.key}computeDestinationIcon_(){if(!this.selectedValue){return""}if(this.destination&&this.destination.key===this.selectedValue){if(this.isCurrentDestinationCrosLocal_){if(shouldShowCrosPrinterSetupError(this.state,this.error)){return getPrinterStatusIcon(PrinterStatusReason.PRINTER_UNREACHABLE,this.destination.isEnterprisePrinter,this.isDarkModeActive_)}return getPrinterStatusIcon(this.destination.printerStatusReason,this.destination.isEnterprisePrinter,this.isDarkModeActive_)}return this.destination.icon}const keyParams=this.selectedValue.split("/");if(keyParams[0]===GooglePromotedDestinationId.SAVE_TO_DRIVE_CROS){return"print-preview:save-to-drive"}if(keyParams[0]===GooglePromotedDestinationId.SAVE_AS_PDF){return"cr:insert-drive-file"}const recent=this.recentDestinationList.find((d=>d.key===this.selectedValue));if(recent&&recent.icon){return recent.icon}return"print-preview:print"}hideDestinationAdditionalInfo_(){return this.statusText_===window.trustedTypes.emptyHTML}fireSelectedOptionChange_(value){this.dispatchEvent(new CustomEvent("selected-option-change",{bubbles:true,composed:true,detail:value}))}onProcessSelectChange(value){this.fireSelectedOptionChange_(value)}onDropdownValueSelected_(e){const selectedItem=e.detail;if(!selectedItem||selectedItem.value===this.destination.key){return}this.fireSelectedOptionChange_(selectedItem.value)}onRecentDestinationListChanged_(){for(const destination of this.recentDestinationList){if(!destination||destination.origin!==DestinationOrigin.CROS){continue}destination.requestPrinterStatus().then((destinationKey=>this.onPrinterStatusReceived_(destinationKey)))}}onPrinterStatusReceived_(destinationKey){const indexFound=this.recentDestinationList.findIndex((destination=>destination.key===destinationKey));if(indexFound===-1){return}this.notifyPath(`recentDestinationList.${indexFound}.printerStatusReason`);if(this.destination&&this.destination.key===destinationKey){this.notifyPath(`destination.printerStatusReason`)}}computeStatusText_(){if(!this.destination){return window.trustedTypes.emptyHTML}if(this.destination.origin!==DestinationOrigin.CROS){return window.trustedTypes.emptyHTML}if(shouldShowCrosPrinterSetupError(this.state,this.error)){return this.getErrorString_(PrinterStatusReason.PRINTER_UNREACHABLE)}const printerStatusReason=this.destination.printerStatusReason;if(printerStatusReason===null||printerStatusReason===PrinterStatusReason.NO_ERROR||printerStatusReason===PrinterStatusReason.UNKNOWN_REASON){return window.trustedTypes.emptyHTML}return this.getErrorString_(printerStatusReason)}getErrorString_(printerStatusReason){const errorStringKey=ERROR_STRING_KEY_MAP.get(printerStatusReason);return errorStringKey?this.i18nAdvanced(errorStringKey):window.trustedTypes.emptyHTML}computeIsCurrentDestinationCrosLocal_(){return this.destination&&this.destination.origin===DestinationOrigin.CROS}computeStatusClass_(){const statusClass="destination-status";if(!this.destination){return statusClass}const printerStatusReason=this.destination.printerStatusReason;if(printerStatusReason===null||printerStatusReason===PrinterStatusReason.NO_ERROR||printerStatusReason===PrinterStatusReason.UNKNOWN_REASON){return statusClass}return`${statusClass} ${getStatusTextColorClass(printerStatusReason)}`}getVisibleItemsForTest(){return this.shadowRoot.querySelector("#dropdown").shadowRoot.querySelectorAll(".list-item:not([hidden])")}}customElements.define(PrintPreviewDestinationSelectCrosElement.is,PrintPreviewDestinationSelectCrosElement);function getTemplate(){return html$1`<!--_html_template_start_--><style include="print-preview-shared">:host([has-pin-setting_]){margin-bottom:0 !important}
</style>


  <print-preview-destination-select-cros id="destinationSelect"
      active-user="[[activeUser_]]" dark="[[dark]]"
      destination="[[destination]]"
      disabled="[[shouldDisableDropdown_(
                      destinationState, state, disabled)]]"
      drive-destination-key="[[driveDestinationKey_]]"
      loaded="[[loaded_]]"
      no-destinations="[[noDestinations_]]"
      pdf-printer-disabled="[[pdfPrinterDisabled_]]"
      recent-destination-list="[[displayedDestinations_]]"
      on-selected-option-change="onSelectedDestinationOptionChange_"
      state="[[state]]" error="[[error]]">
  </print-preview-destination-select-cros>
  <cr-lazy-render id="destinationDialog">
    <template>
      <print-preview-destination-dialog-cros
          destination-store="[[destinationStore_]]"
          recent-destination-list="[[recentDestinationList_]]"
          on-close="onDialogClose_">
      </print-preview-destination-dialog-cros>
    </template>
  </cr-lazy-render>

<!--_html_template_end_-->`}
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var DestinationState;(function(DestinationState){DestinationState[DestinationState["INIT"]=0]="INIT";DestinationState[DestinationState["SET"]=1]="SET";DestinationState[DestinationState["UPDATED"]=2]="UPDATED";DestinationState[DestinationState["ERROR"]=3]="ERROR"})(DestinationState||(DestinationState={}));const NUM_PERSISTED_DESTINATIONS=10;const NUM_UNPINNED_DESTINATIONS=3;const PrintPreviewDestinationSettingsElementBase=I18nMixin(WebUiListenerMixin(SettingsMixin(PolymerElement)));class PrintPreviewDestinationSettingsElement extends PrintPreviewDestinationSettingsElementBase{constructor(){super(...arguments);this.lastUser_="";this.tracker_=new EventTracker}static get is(){return"print-preview-destination-settings"}static get template(){return getTemplate()}static get properties(){return{dark:Boolean,destination:{type:Object,notify:true,value:null},destinationState:{type:Number,notify:true,value:DestinationState.INIT,observer:"updateDestinationSelect_"},disabled:Boolean,error:{type:Number,notify:true,observer:"onErrorChanged_"},firstLoad:Boolean,state:Number,destinationStore_:{type:Object,value:null},displayedDestinations_:Array,driveDestinationKey_:{type:String,value:""},hasPinSetting_:{type:Boolean,computed:"computeHasPinSetting_(settings.pin.available)",reflectToAttribute:true},isDialogOpen_:{type:Boolean,value:false},noDestinations_:{type:Boolean,value:false},pdfPrinterDisabled_:Boolean,loaded_:{type:Boolean,computed:"computeLoaded_(destinationState, destination)"}}}connectedCallback(){super.connectedCallback();this.destinationStore_=new DestinationStore(this.addWebUiListener.bind(this));this.tracker_.add(this.destinationStore_,DestinationStoreEventType.DESTINATION_SELECT,this.onDestinationSelect_.bind(this));this.tracker_.add(this.destinationStore_,DestinationStoreEventType.SELECTED_DESTINATION_CAPABILITIES_READY,this.onDestinationCapabilitiesReady_.bind(this));this.tracker_.add(this.destinationStore_,DestinationStoreEventType.ERROR,this.onDestinationError_.bind(this));this.tracker_.add(this.destinationStore_,DestinationStoreEventType.DESTINATIONS_INSERTED,this.updateDropdownDestinations_.bind(this));this.tracker_.add(this.destinationStore_,DestinationStoreEventType.DESTINATION_EULA_READY,this.updateDestinationEulaUrl_.bind(this));this.tracker_.add(this.destinationStore_,DestinationStoreEventType.DESTINATION_PRINTER_STATUS_UPDATE,this.onPrinterStatusUpdate_.bind(this))}disconnectedCallback(){super.disconnectedCallback();this.destinationStore_.resetTracker();this.tracker_.removeAll()}init(defaultPrinter,pdfPrinterDisabled,saveToDriveDisabled,serializedDefaultDestinationRulesStr){this.pdfPrinterDisabled_=pdfPrinterDisabled;let recentDestinations=this.getSettingValue("recentDestinations");this.driveDestinationKey_=saveToDriveDisabled?"":SAVE_TO_DRIVE_CROS_DESTINATION_KEY;recentDestinations=recentDestinations.slice(0,this.getRecentDestinationsDisplayCount_(recentDestinations));this.destinationStore_.init(this.pdfPrinterDisabled_,saveToDriveDisabled,defaultPrinter,serializedDefaultDestinationRulesStr,recentDestinations)}getRecentDestinationsDisplayCount_(recentDestinations){let numDestinationsToDisplay=NUM_UNPINNED_DESTINATIONS;for(let i=0;i<recentDestinations.length;i++){if(i>numDestinationsToDisplay){return numDestinationsToDisplay}if(isPdfPrinter(recentDestinations[i].id)){numDestinationsToDisplay++}}return Math.min(recentDestinations.length,numDestinationsToDisplay)}onDestinationSelect_(){if(this.state===State.FATAL_ERROR){return}const destination=this.destinationStore_.selectedDestination;this.destinationState=DestinationState.SET;this.destination=destination;this.updateRecentDestinations_()}onDestinationCapabilitiesReady_(){this.notifyPath("destination.capabilities");this.notifyPath("destination.allowedManagedPrintOptionsApplied.mediaSize");this.notifyPath("destination.allowedManagedPrintOptionsApplied.mediaType");this.notifyPath("destination.allowedManagedPrintOptionsApplied.duplex");this.notifyPath("destination.allowedManagedPrintOptionsApplied.color");this.notifyPath("destination.allowedManagedPrintOptionsApplied.dpi");this.notifyPath("destination.allowedManagedPrintOptionsApplied.quality");this.updateRecentDestinations_();if(this.destinationState===DestinationState.SET){this.destinationState=DestinationState.UPDATED}}onDestinationError_(e){let errorType=Error$1.NONE;switch(e.detail){case DestinationErrorType.INVALID:errorType=Error$1.INVALID_PRINTER;break;case DestinationErrorType.NO_DESTINATIONS:errorType=Error$1.NO_DESTINATIONS;this.noDestinations_=true;break}this.error=errorType}onErrorChanged_(){if(this.error===Error$1.INVALID_PRINTER||this.error===Error$1.NO_DESTINATIONS){this.destinationState=DestinationState.ERROR}}updateRecentDestinations_(){if(!this.destination){return}const newDestination=makeRecentDestination(this.destination);const recentDestinations=this.getSettingValue("recentDestinations");let indexFound=-1;let isVisible=false;let numUnpinnedChecked=0;for(let index=0;index<recentDestinations.length;index++){const recent=recentDestinations[index];if(recent.id===newDestination.id&&recent.origin===newDestination.origin){indexFound=index;isVisible=numUnpinnedChecked<NUM_UNPINNED_DESTINATIONS;break}if(!isPdfPrinter(recent.id)){numUnpinnedChecked++}}if(indexFound===0&&recentDestinations[0].capabilities===newDestination.capabilities){return}const isNew=indexFound===-1;if(isNew&&recentDestinations.length===NUM_PERSISTED_DESTINATIONS){indexFound=NUM_PERSISTED_DESTINATIONS-1}if(indexFound!==-1){this.setSettingSplice("recentDestinations",indexFound,1,null)}this.setSettingSplice("recentDestinations",0,0,newDestination);if(!isPdfPrinter(newDestination.id)&&(isNew||!isVisible)){this.updateDropdownDestinations_()}}updateDropdownDestinations_(){const recentDestinations=this.getSettingValue("recentDestinations");const updatedDestinations=[];let numDestinationsChecked=0;for(const recent of recentDestinations){if(isPdfPrinter(recent.id)){continue}numDestinationsChecked++;const key=createRecentDestinationKey(recent);const destination=this.destinationStore_.getDestinationByKey(key);if(destination){updatedDestinations.push(destination)}if(numDestinationsChecked===NUM_UNPINNED_DESTINATIONS){break}}this.displayedDestinations_=updatedDestinations}shouldDisableDropdown_(){return this.state===State.FATAL_ERROR||this.destinationState===DestinationState.UPDATED&&this.disabled&&this.state!==State.NOT_READY}computeLoaded_(){return this.destinationState===DestinationState.ERROR||this.destinationState===DestinationState.UPDATED||this.destinationState===DestinationState.SET&&!!this.destination&&(!!this.destination.capabilities||this.destination.type===PrinterType.PDF_PRINTER)}computeHasPinSetting_(){return this.getSetting("pin").available}onSelectedDestinationOptionChange_(e){const value=e.detail;if(value==="seeMore"){this.destinationStore_.startLoadAllDestinations();this.$.destinationDialog.get().show();this.isDialogOpen_=true}else{this.destinationStore_.selectDestinationByKey(value)}}onDialogClose_(){this.updateDestinationSelect_();this.isDialogOpen_=false}updateDestinationSelect_(){if(this.destinationState===DestinationState.ERROR&&!this.destination){return}if(this.destinationState===DestinationState.INIT){return}const shouldFocus=this.destinationState!==DestinationState.SET&&!this.firstLoad;beforeNextRender(this.$.destinationSelect,(()=>{this.$.destinationSelect.updateDestination();if(shouldFocus){this.$.destinationSelect.focus()}}))}getDestinationStoreForTest(){assert(this.destinationStore_);return this.destinationStore_}updateDestinationEulaUrl_(e){if(!this.destination){return}this.destination.eulaUrl=e.detail;this.notifyPath("destination.eulaUrl")}printerExistsInDisplayedDestinations(){return this.displayedDestinations_.some((destination=>destination.type!==PrinterType.PDF_PRINTER))}onPrinterStatusUpdate_(e){const destinationKey=e.detail.destinationKey;if(this.destination&&this.destination.key===destinationKey){this.notifyPath(`destination.printerStatusReason`);if(e.detail.nowOnline){this.destinationStore_.selectDestination(this.destination,true)}}const index=this.displayedDestinations_.findIndex((destination=>destination.key===destinationKey));if(index!==-1){this.notifyPath(`displayedDestinations_.${index}.printerStatusReason`)}}}customElements.define(PrintPreviewDestinationSettingsElement.is,PrintPreviewDestinationSettingsElement);
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PrintPreviewAppElementBase=WebUiListenerMixin(SettingsMixin(PolymerElement));class PrintPreviewAppElement extends PrintPreviewAppElementBase{static get is(){return"print-preview-app"}static get template(){return getTemplate$c()}static get properties(){return{state:{type:Number,observer:"onStateChanged_"},controlsManaged_:{type:Boolean,computed:"computeControlsManaged_(destinationsManaged_, "+"settingsManaged_, maxSheets_)"},destination_:Object,destinationsManaged_:{type:Boolean,value:false},destinationState_:{type:Number,observer:"onDestinationStateChange_"},documentSettings_:Object,error_:{type:Number,observer:"onErrorChange_"},margins_:Object,pageSize_:Object,previewState_:{type:String,observer:"onPreviewStateChange_"},printableArea_:Object,settingsManaged_:{type:Boolean,value:false},measurementSystem_:{type:Object,value:null},maxSheets_:Number}}constructor(){super();this.nativeLayer_=null;this.tracker_=new EventTracker;this.cancelled_=false;this.printRequested_=false;this.startPreviewWhenReady_=false;this.showSystemDialogBeforePrint_=false;this.openPdfInPreview_=false;this.isInKioskAutoPrintMode_=false;this.whenReady_=null;this.openDialogs_=[];const CANONICAL_PATH_REGEX=/(^\/)([\/-\w]+)(\/$)/;const path=location.pathname.replace(CANONICAL_PATH_REGEX,"$1$2");if(path!=="/"){window.history.replaceState(undefined,"","/")}}ready(){super.ready();FocusOutlineManager.forDocument(document)}connectedCallback(){super.connectedCallback();document.documentElement.classList.remove("loading");this.nativeLayer_=NativeLayerImpl.getInstance();this.addWebUiListener("cr-dialog-open",this.onCrDialogOpen_.bind(this));this.addWebUiListener("close",this.onCrDialogClose_.bind(this));this.addWebUiListener("print-preset-options",this.onPrintPresetOptions_.bind(this));this.tracker_.add(window,"keydown",this.onKeyDown_.bind(this));this.$.previewArea.setPluginKeyEventCallback(this.onKeyDown_.bind(this));this.whenReady_=whenReady();this.nativeLayer_.getInitialSettings().then(this.onInitialSettingsSet_.bind(this))}disconnectedCallback(){super.disconnectedCallback();this.tracker_.removeAll();this.whenReady_=null}onSidebarFocus_(){this.$.previewArea.hideToolbar()}onKeyDown_(e){if(e.key==="Escape"&&!hasKeyModifiers(e)){if(this.openDialogs_.length!==0){const dialogToClose=this.openDialogs_[this.openDialogs_.length-1];dialogToClose.cancel();e.preventDefault();return}if(isMac){this.close_();e.preventDefault()}this.recordCancelMetricCros_();return}if(isMac&&e.key==="."&&e.metaKey){this.close_();e.preventDefault();return}if((e.key==="Enter"||e.key==="NumpadEnter")&&this.state===State.READY&&this.openDialogs_.length===0){const activeElementTag=e.composedPath()[0].tagName;if(["CR-BUTTON","BUTTON","SELECT","A","CR-CHECKBOX"].includes(activeElementTag)){return}this.onPrintRequested_();e.preventDefault();return}this.$.previewArea.handleDirectionalKeyEvent(e)}onCrDialogOpen_(e){this.openDialogs_.push(e.composedPath()[0])}onCrDialogClose_(e){if(e.composedPath()[0].nodeName==="CR-DIALOG"){this.openDialogs_.pop()}}onInitialSettingsSet_(settings){if(!this.whenReady_){return}this.whenReady_.then((()=>{this.$.documentInfo.init(settings.previewModifiable,settings.previewIsFromArc,settings.documentTitle,settings.documentHasSelection);this.$.model.setStickySettings(settings.serializedAppStateStr);this.$.model.setPolicySettings(settings.policies);this.measurementSystem_=new MeasurementSystem(settings.thousandsDelimiter,settings.decimalDelimiter,settings.unitType);this.setSetting("selectionOnly",settings.shouldPrintSelectionOnly);this.$.sidebar.init(settings.isInAppKioskMode,settings.printerName,settings.serializedDefaultDestinationSelectionRulesStr,settings.pdfPrinterDisabled,settings.isDriveMounted||false);this.destinationsManaged_=settings.destinationsManaged;this.isInKioskAutoPrintMode_=settings.isInKioskAutoPrintMode;let title=document.head.querySelector("title");if(!title){title=document.createElement("title");document.head.appendChild(title)}title.textContent=settings.documentTitle}))}computeControlsManaged_(){return this.destinationsManaged_||this.settingsManaged_||this.maxSheets_>0}onDestinationStateChange_(){switch(this.destinationState_){case DestinationState.SET:if(this.state!==State.NOT_READY&&this.state!==State.FATAL_ERROR){this.$.state.transitTo(State.NOT_READY)}break;case DestinationState.UPDATED:if(!this.$.model.initialized()){this.$.model.applyStickySettings()}this.$.model.applyDestinationSpecificPolicies();this.startPreviewWhenReady_=true;if(this.state===State.NOT_READY&&this.destination_.type!==PrinterType.PDF_PRINTER){this.nativeLayer_.recordBooleanHistogram("PrintPreview.TransitionedToReadyState",true)}this.$.state.transitTo(State.READY);break;case DestinationState.ERROR:let newState=State.ERROR;if(this.error_===Error$1.NO_DESTINATIONS){newState=State.FATAL_ERROR}if(this.state===State.NOT_READY&&this.destination_.type!==PrinterType.PDF_PRINTER){this.nativeLayer_.recordBooleanHistogram("PrintPreview.TransitionedToReadyState",false)}this.$.state.transitTo(newState);break}}onStickySettingChanged_(e){this.nativeLayer_.saveAppState(e.detail)}onPreviewSettingChanged_(){if(this.state===State.READY){this.$.previewArea.startPreview(false);this.startPreviewWhenReady_=false}else{this.startPreviewWhenReady_=true}}onStateChanged_(){if(this.state===State.READY){if(this.startPreviewWhenReady_){this.$.previewArea.startPreview(false);this.startPreviewWhenReady_=false}if(this.isInKioskAutoPrintMode_||this.printRequested_){this.onPrintRequested_();this.printRequested_=false}}else if(this.state===State.CLOSING){this.remove();this.nativeLayer_.dialogClose(this.cancelled_)}else if(this.state===State.PRINT_PENDING){if(this.destination_.type!==PrinterType.PDF_PRINTER){this.nativeLayer_.hidePreview();this.$.state.transitTo(State.HIDDEN)}}else if(this.state===State.PRINTING){if(this.destination_.type===PrinterType.PDF_PRINTER){NativeLayerCrosImpl.getInstance().recordPrintAttemptOutcome(PrintAttemptOutcome.PDF_PRINT_ATTEMPTED)}const whenPrintDone=this.nativeLayer_.doPrint(this.$.model.createPrintTicket(this.destination_,this.openPdfInPreview_,this.showSystemDialogBeforePrint_));const onError=this.destination_.type===PrinterType.PDF_PRINTER?this.onFileSelectionCancel_.bind(this):this.onPrintFailed_.bind(this);whenPrintDone.then(this.close_.bind(this),onError)}}onErrorChange_(){if(this.error_!==Error$1.NONE){this.nativeLayer_.recordInHistogram("PrintPreview.StateError",this.error_,Error$1.MAX_BUCKET)}}onPrintRequested_(){if(this.state===State.NOT_READY){this.printRequested_=true;return}this.$.state.transitTo(this.$.previewArea.previewLoaded()?State.PRINTING:State.PRINT_PENDING)}onCancelRequested_(){this.recordCancelMetricCros_();this.cancelled_=true;this.$.state.transitTo(State.CLOSING)}recordCancelMetricCros_(){let printAttemptOutcome=null;if(this.state!==State.READY){printAttemptOutcome=PrintAttemptOutcome.CANCELLED_PRINT_BUTTON_DISABLED}else if(!this.$.sidebar.printerExistsInDisplayedDestinations()){printAttemptOutcome=PrintAttemptOutcome.CANCELLED_NO_PRINTERS_AVAILABLE}else if(this.destination_.origin===DestinationOrigin.CROS){switch(computePrinterState(this.destination_.printerStatusReason)){case PrinterState.GOOD:printAttemptOutcome=PrintAttemptOutcome.CANCELLED_PRINTER_GOOD_STATUS;break;case PrinterState.ERROR:printAttemptOutcome=PrintAttemptOutcome.CANCELLED_PRINTER_ERROR_STATUS;break;case PrinterState.UNKNOWN:printAttemptOutcome=PrintAttemptOutcome.CANCELLED_PRINTER_UNKNOWN_STATUS;break}}else{printAttemptOutcome=PrintAttemptOutcome.CANCELLED_OTHER_PRINTERS_AVAILABLE}if(printAttemptOutcome!==null){NativeLayerCrosImpl.getInstance().recordPrintAttemptOutcome(printAttemptOutcome)}}onSettingValidChanged_(e){if(e.detail){this.$.state.transitTo(State.READY)}else{this.error_=Error$1.INVALID_TICKET;this.$.state.transitTo(State.ERROR)}}onFileSelectionCancel_(){this.$.state.transitTo(State.READY)}onPrintFailed_(httpError){console.warn("Printing failed with error code "+httpError);this.error_=Error$1.PRINT_FAILED;this.$.state.transitTo(State.FATAL_ERROR)}onPreviewStateChange_(){switch(this.previewState_){case PreviewAreaState.DISPLAY_PREVIEW:case PreviewAreaState.OPEN_IN_PREVIEW_LOADED:if(this.state===State.PRINT_PENDING||this.state===State.HIDDEN){this.$.state.transitTo(State.PRINTING)}break;case PreviewAreaState.ERROR:if(this.state!==State.ERROR&&this.state!==State.FATAL_ERROR){this.$.state.transitTo(this.error_===Error$1.INVALID_PRINTER?State.ERROR:State.FATAL_ERROR)}break}}onPrintPresetOptions_(disableScaling,copies,duplex){if(disableScaling){this.$.documentInfo.updateIsScalingDisabled(true)}if(copies>0&&this.getSetting("copies").available){this.setSetting("copies",copies,true)}if(duplex===DuplexMode.UNKNOWN_DUPLEX_MODE){return}if(this.getSetting("duplex").available){this.setSetting("duplex",duplex===DuplexMode.LONG_EDGE||duplex===DuplexMode.SHORT_EDGE,true)}if(duplex!==DuplexMode.SIMPLEX&&this.getSetting("duplexShortEdge").available){this.setSetting("duplexShortEdge",duplex===DuplexMode.SHORT_EDGE,true)}}onPreviewStart_(e){this.$.documentInfo.inFlightRequestId=e.detail}close_(){this.$.state.transitTo(State.CLOSING)}}customElements.define(PrintPreviewAppElement.is,PrintPreviewAppElement);export{BackgroundGraphicsModeRestriction,ColorMode,ColorModeRestriction,CrButtonElement,CrCheckboxElement,CrIconButtonElement,CrInputElement,CustomMarginsOrientation,DEFAULT_MAX_COPIES,DESTINATION_DIALOG_CROS_LOADING_TIMER_IN_MS,Destination,DestinationErrorType,DestinationOrigin,DestinationState,DestinationStore,DestinationStoreEventType,DuplexMode,DuplexModeRestriction,DuplexType,Error$1 as Error,GooglePromotedDestinationId,IPP_PRINT_QUALITY,IconsetMap,ManagedPrintOptionsDuplexType,ManagedPrintOptionsQualityType,Margins,MarginsType,MeasurementSystem,MeasurementSystemUnitType,NUM_PERSISTED_DESTINATIONS,NativeLayerCrosImpl,NativeLayerImpl,PDF_DESTINATION_KEY,PagesValue,PinModeRestriction,PluginProxyImpl,PreviewAreaState,PrintPreviewAdvancedSettingsDialogElement,PrintPreviewAdvancedSettingsItemElement,PrintPreviewAppElement,PrintPreviewButtonStripElement,PrintPreviewColorSettingsElement,PrintPreviewCopiesSettingsElement,PrintPreviewDestinationDialogCrosElement,PrintPreviewDestinationDropdownCrosElement,PrintPreviewDestinationListElement,PrintPreviewDestinationListItemElement,PrintPreviewDestinationSelectCrosElement,PrintPreviewDestinationSettingsElement,PrintPreviewDpiSettingsElement,PrintPreviewDuplexSettingsElement,PrintPreviewHeaderElement,PrintPreviewLayoutSettingsElement,PrintPreviewMarginControlContainerElement,PrintPreviewMarginControlElement,PrintPreviewMarginsSettingsElement,PrintPreviewMediaSizeSettingsElement,PrintPreviewMediaTypeSettingsElement,PrintPreviewModelElement,PrintPreviewNumberSettingsSectionElement,PrintPreviewOtherOptionsSettingsElement,PrintPreviewPagesPerSheetSettingsElement,PrintPreviewPagesSettingsElement,PrintPreviewPinSettingsElement,PluralStringProxyImpl as PrintPreviewPluralStringProxyImpl,PrintPreviewPreviewAreaElement,PrintPreviewPrinterSetupInfoCrosElement,PrintPreviewScalingSettingsElement,PrintPreviewSearchBoxElement,PrintPreviewSettingsSelectElement,PrintPreviewSidebarElement,PrintServerStore,PrintServerStoreEventType,PrinterSetupInfoInitiator,PrinterSetupInfoMessageType,PrinterState,PrinterStatusReason,PrinterStatusSeverity,PrinterType,SAVE_TO_DRIVE_CROS_DESTINATION_KEY,ScalingType,SearchableDropDownCrosElement,SelectMixin,Size,State,VendorCapabilityValueType,createDestinationKey,getInstance$1 as getInstance,getSelectDropdownBackground,getTrustedHTML,makeRecentDestination,whenReady};