// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { DuplexType, QualityIppValue } from './cdd.js';
export var ManagedPrintOptionsDuplexType;
(function (ManagedPrintOptionsDuplexType) {
    ManagedPrintOptionsDuplexType[ManagedPrintOptionsDuplexType["UNKNOWN_DUPLEX"] = 0] = "UNKNOWN_DUPLEX";
    ManagedPrintOptionsDuplexType[ManagedPrintOptionsDuplexType["ONE_SIDED"] = 1] = "ONE_SIDED";
    ManagedPrintOptionsDuplexType[ManagedPrintOptionsDuplexType["SHORT_EDGE"] = 2] = "SHORT_EDGE";
    ManagedPrintOptionsDuplexType[ManagedPrintOptionsDuplexType["LONG_EDGE"] = 3] = "LONG_EDGE";
})(ManagedPrintOptionsDuplexType || (ManagedPrintOptionsDuplexType = {}));
export var ManagedPrintOptionsQualityType;
(function (ManagedPrintOptionsQualityType) {
    ManagedPrintOptionsQualityType[ManagedPrintOptionsQualityType["UNKNOWN_QUALITY"] = 0] = "UNKNOWN_QUALITY";
    ManagedPrintOptionsQualityType[ManagedPrintOptionsQualityType["DRAFT"] = 1] = "DRAFT";
    ManagedPrintOptionsQualityType[ManagedPrintOptionsQualityType["NORMAL"] = 2] = "NORMAL";
    ManagedPrintOptionsQualityType[ManagedPrintOptionsQualityType["HIGH"] = 3] = "HIGH";
})(ManagedPrintOptionsQualityType || (ManagedPrintOptionsQualityType = {}));
// Name of the IPP attribute that corresponds to the "quality" field in the
// managed print options.
export const IPP_PRINT_QUALITY = 'print-quality';
/**
 * Converts a ManagedPrintOptionsDuplexType value to a DuplexType value used in
 * CDD. Returns null if conversion is not possible.
 */
export function managedPrintOptionsDuplexToCdd(managedPrintOptionsDuplex) {
    switch (managedPrintOptionsDuplex) {
        case ManagedPrintOptionsDuplexType.ONE_SIDED:
            return DuplexType.NO_DUPLEX;
        case ManagedPrintOptionsDuplexType.LONG_EDGE:
            return DuplexType.LONG_EDGE;
        case ManagedPrintOptionsDuplexType.SHORT_EDGE:
            return DuplexType.SHORT_EDGE;
        default:
            return null;
    }
}
/**
 * Converts a ManagedPrintOptionsQualityType value to a common IPP value
 * represented by the QualityIppValue. Returns null if conversion is not
 * possible.
 */
export function managedPrintOptionsQualityToIpp(managedPrintOptionsQuality) {
    switch (managedPrintOptionsQuality) {
        case ManagedPrintOptionsQualityType.DRAFT:
            return QualityIppValue.DRAFT;
        case ManagedPrintOptionsQualityType.NORMAL:
            return QualityIppValue.NORMAL;
        case ManagedPrintOptionsQualityType.HIGH:
            return QualityIppValue.HIGH;
        default:
            return null;
    }
}
