import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="destination-dialog-style">:host(:not([show-manage-printers-button])) div[slot=button-container]{justify-content:flex-end}.form-row{align-items:center;column-gap:18px;display:flex;line-height:calc(20 / 15 * 1em);margin-bottom:14px}.server-search-box-input{--cr-searchable-drop-down-width:100%;display:inline-block;flex-grow:1;width:100%}.server-search-box-container{width:100%}.throbber{align-self:center}.throbber-container{display:flex;margin-inline-start:calc((var(--search-icon-size) - var(--throbber-size))/2);min-height:var(--destination-item-height)}</style>
<cr-dialog id="dialog" on-close="onCloseOrCancel_">
  <div slot="title" id="header">$i18n{destinationSearchTitle}</div>
  <div slot="body">
    <div class="form-row">
      <div class="server-search-box-container">
        <!-- TODO(crbug.com/1013408): Uses deprecated iron-dropdown. -->
        <searchable-drop-down-cros class="server-search-box-input"
            hidden$="[[!isSingleServerFetchingMode_]]"
            placeholder="$i18n{serverSearchBoxPlaceholder}"
            value="{{printServerSelected_}}"
            items="[[printServerNames_]]">
        </searchable-drop-down-cros>
      </div>
    </div>
    <div class="throbber-container" hidden$="[[!shouldShowUi_(
        uiStateEnum_.THROBBER, uiState_)]]">
      <div class="throbber"></div>
    </div>
    <print-preview-search-box id="searchBox"
        hidden$="[[!shouldShowUi_(uiStateEnum_.DESTINATION_LIST, uiState_)]]"
        label="$i18n{searchBoxPlaceholder}" search-query="{{searchQuery_}}"
        autofocus>
    </print-preview-search-box>
    <print-preview-destination-list id="printList"
        destinations="[[destinations_]]"
        hidden$="[[!shouldShowUi_(uiStateEnum_.DESTINATION_LIST, uiState_)]]"
        loading-destinations="[[loadingDestinations_]]"
        search-query="[[searchQuery_]]"
        on-destination-selected="onDestinationSelected_">
    </print-preview-destination-list>
    <print-preview-printer-setup-info-cros
        hidden$="[[!shouldShowUi_(uiStateEnum_.PRINTER_SETUP_ASSISTANCE,
            uiState_)]]"
        message-type="[[printerSetupInfoMessageTypeEnum_.NO_PRINTERS]]"
        initiator="[[printerSetupInfoInitiatorEnum_.DESTINATION_DIALOG_CROS]]">
    </print-preview-printer-setup-info-cros>
    <print-preview-provisional-destination-resolver id="provisionalResolver"
        destination-store="[[destinationStore]]">
    </print-preview-provisional-destination-resolver>
  </div>
  <div slot="button-container">
    <cr-button on-click="onManageButtonClick_" id="managePrinters"
        hidden$="[[!showManagePrintersButton]]">
      $i18n{manage}
      <cr-icon icon="cr:open-in-new" id="manageIcon"></cr-icon>
    </cr-button>
    <cr-button class="cancel-button" on-click="onCancelButtonClick_">
      $i18n{cancel}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
