import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="print-preview-shared md-select">:host([error-state_='0']) #pageSettingsCustomInput,:host([error-state_='3']) #pageSettingsCustomInput{--cr-input-error-display:none}:host([error-state_='1']) #customInputWrapper,:host([error-state_='2']) #customInputWrapper{margin-bottom:8px}#pageSettingsCustomInput{cursor:default;--cr-form-field-label-height:100%}:host #title{align-self:baseline}</style>
<print-preview-settings-section>
  <span slot="title" id="pages-label">$i18n{pagesLabel}</span>
  <div slot="controls">
    <select class="md-select" aria-labelledby="pages-label"
        disabled$="[[controlsDisabled_]]" value="[[selectedValue]]"
        on-change="onSelectChange" on-blur="onSelectBlur_">
      <option value="[[pagesValueEnum_.ALL]]" selected>
        $i18n{optionAllPages}
      </option>
      <option value="[[pagesValueEnum_.ODDS]]"
          hidden$="[[isSinglePage_(pageCount)]]">
        $i18n{optionOddPages}
      </option>
      <option value="[[pagesValueEnum_.EVENS]]"
          hidden$="[[isSinglePage_(pageCount)]]">
        $i18n{optionEvenPages}
      </option>
      <option value="[[pagesValueEnum_.CUSTOM]]">
        $i18n{optionCustomPages}
      </option>
    </select>
  </div>
</print-preview-settings-section>
<cr-collapse opened="[[shouldShowInput_(selection_)]]"
  on-transitionend="onCollapseChanged_">
  <print-preview-settings-section id="customInputWrapper">
    <div slot="title"></div>
    <div slot="controls">
      <cr-input id="pageSettingsCustomInput" class="stroked" type="text"
          data-timeout-delay="500" invalid="[[hasError_]]"
          disabled$="[[inputDisabled_(controlsDisabled_, selection_)]]"
          spellcheck="false" placeholder="$i18n{examplePageRangeText}"
          error-message="[[getHintMessage_(errorState_, pageCount)]]"
          on-blur="onCustomInputBlur_">
      </cr-input>
    </div>
  </print-preview-settings-section>
</cr-collapse>
<!--_html_template_end_-->`;
}
