import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-hidden-style">@keyframes dancing-dots-jump{0%{top:0}55%{top:0}60%{top:-10px}80%{top:3px}90%{top:-2px}95%{top:1px}100%{top:0}}:host([show-cros-printer-setup-info_]) .preview-area-message{background:rgb(255,255,255);border-radius:16px;display:flex;flex-direction:column;height:100%;justify-content:center;margin:16px}@media (prefers-color-scheme:dark){:host([show-cros-printer-setup-info_]) .preview-area-message{background:rgb(40,41,44)}}span.jumping-dots>span{animation:dancing-dots-jump 1800ms infinite;padding:1px;position:relative}span.jumping-dots>span:nth-child(2){animation-delay:100ms}span.jumping-dots>span:nth-child(3){animation-delay:300ms}:host{display:block;height:100%;overflow:hidden;position:relative;user-select:none}.preview-area-plugin-wrapper{height:100%}.preview-area-plugin{border:none;cursor:inherit;height:100%;opacity:1;transition:opacity 200ms linear;transition-delay:100ms;width:100%}.preview-area-overlay-layer{background:var(--preview-area-background-color);display:flex;flex-direction:column;height:100%;justify-content:center;margin:0;opacity:1;position:absolute;transition:opacity 200ms linear;transition-delay:350ms;user-select:none;width:100%;z-index:1}.preview-area-overlay-layer.invisible{opacity:0;pointer-events:none;transition:opacity 100ms linear}.preview-area-message{color:var(--cr-primary-text-color);line-height:20px;margin:0 10px;position:relative;text-align:center}</style>
<div class$="preview-area-overlay-layer [[getInvisible_(previewState)]]"
    aria-hidden$="[[getAriaHidden_(previewState)]]">
  <div class="preview-area-message">
    <div>
      <span
          hidden$="[[showCrosPrinterSetupInfo_]]"
          inner-h-t-m-l="[[currentMessage_(previewState)]]">
      </span>
      <span class$="preview-area-loading-message-jumping-dots
                    [[getJumpingDots_(previewState)]]"
          hidden$="[[!isPreviewLoading_(previewState)]]">
          <span>.</span><span>.</span><span>.</span>
      </span>
    </div>
    
      <print-preview-printer-setup-info-cros
          hidden$="[[!showCrosPrinterSetupInfo_]]"
          message-type="[[printerSetupInfoMessageTypeEnum_.PRINTER_OFFLINE]]"
          initiator="[[printerSetupInfoInitiatorEnum_.PREVIEW_AREA]]">
      </print-preview-printer-setup-info-cros>
    
  </div>
</div>
<div class="preview-area-plugin-wrapper"></div>
<print-preview-margin-control-container id="marginControlContainer"
    page-size="[[pageSize]]" settings="[[settings]]"
    document-margins="[[margins]]"
    measurement-system="[[measurementSystem]]" state="[[state]]"
    preview-loaded="[[previewLoaded_]]"
    on-text-focus-position="onTextFocusPosition_"
    on-margin-drag-changed="onMarginDragChanged_">
</print-preview-margin-control-container>
<!--_html_template_end_-->`;
}
