import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="print-preview-shared md-select"></style>
<print-preview-settings-section>
  <span slot="title" id="scaling-label">$i18n{scalingLabel}</span>
  <div slot="controls">
    <select class="md-select" aria-labelledby="scaling-label"
        disabled$="[[dropdownDisabled_]]" value="[[selectedValue]]"
        on-change="onSelectChange">
      <option value="[[scalingTypeEnum_.DEFAULT]]">
        $i18n{optionDefaultScaling}
      </option>
      <option value="[[scalingTypeEnum_.FIT_TO_PAGE]]" hidden$="[[!isPdf]]"
          disabled$="[[!isPdf]]">
        $i18n{optionFitToPage}
      </option>
      <option value="[[scalingTypeEnum_.FIT_TO_PAPER]]" hidden$="[[!isPdf]]"
          disabled$="[[!isPdf]]">
        $i18n{optionFitToPaper}
      </option>
      <option value="[[scalingTypeEnum_.CUSTOM]]">
        $i18n{optionCustomScaling}
      </option>
    </select>
  </div>
</print-preview-settings-section>
<cr-collapse opened="[[customSelected_]]"
    on-transitionend="onCollapseChanged_">
  <print-preview-number-settings-section
      max-value="200" min-value="10" default-value="100"
      disabled$="[[inputDisabled_(dropdownDisabled_, customSelected_)]]"
      current-value="{{currentValue_}}" input-valid="{{inputValid_}}"
      hint-message="$i18n{scalingInstruction}">
  </print-preview-number-settings-section>
</cr-collapse>
<!--_html_template_end_-->`;
}
