import { Debouncer, dedupingMixin, timeOut } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export const SelectMixin = dedupingMixin((superClass) => {
    class SelectMixin extends superClass {
        constructor() {
            super(...arguments);
            this.debouncer_ = null;
        }
        static get properties() {
            return {
                selectedValue: { type: String },
            };
        }
        onSelectChange(e) {
            const newValue = e.target.value;
            this.debouncer_ = Debouncer.debounce(this.debouncer_, timeOut.after(100), () => this.callProcessSelectChange_(newValue));
        }
        callProcessSelectChange_(newValue) {
            if (!this.isConnected || newValue === this.selectedValue) {
                return;
            }
            this.selectedValue = newValue;
            this.onProcessSelectChange(newValue);
            // For testing only
            this.dispatchEvent(new CustomEvent('process-select-change', { bubbles: true, composed: true }));
        }
        onProcessSelectChange(_value) { }
    }
    return SelectMixin;
});
