import 'chrome://os-settings/strings.m.js';
import { D as DeepLinkingMixin, R as RouteOriginMixin, P as PrefsMixin, S as Setting, r as routes, C as CrostiniBrowserProxyImpl, a as Router, c as castExists, b as recordSettingChange, d as assertNotReached, e as RouteObserverMixin, W as WebUiListenerMixin, I as I18nMixin, f as CrPolicyIndicatorType, V as VmType, g as cast, h as DEFAULT_CROSTINI_GUEST_ID, i as DEFAULT_CROSTINI_VM, j as DEFAULT_BAGUETTE_GUEST_ID, k as DEFAULT_CROSTINI_CONTAINER, l as VM_DEVICE_MICROPHONE, m as assert, n as PortState, M as MIN_VALID_PORT_NUMBER, o as MAX_VALID_PORT_NUMBER, p as DEFAULT_CROSTINI_VM_TYPE, G as GuestOsBrowserProxyImpl, q as assertExists, s as getVMNameForGuestOsType, t as CrToggleElement, T as TERMINA_VM_TYPE, u as GeolocationAccessLevel, L as LOCATION_PERMISSION_CHANGE_FROM_DIALOG_HISTOGRAM_NAME, v as DateTimeBrowserProxy, w as isChild, A as AudioEffectType, x as getCrosAudioConfig, y as AudioSystemPropertiesObserverReceiver, z as DevicePageBrowserProxyImpl, B as MuteState, E as AudioEffectState, F as FakeCrosAudioConfig, H as AudioDeviceType, J as strictQuery, K as SettingsRadioGroupElement, N as PolicyStatus$1, O as getInputDeviceSettingsProvider, Q as MetaKey$2, U as getInstance, X as MouseButtonConfig$1, Y as GraphicsTabletButtonConfig$1, Z as getDisplayApi, _ as IronResizableBehavior, $ as getDisplaySettingsProvider, a0 as PrivacyHubBrowserProxyImpl, a1 as DisplaySettingsType, a2 as TabletModeObserverReceiver, a3 as DisplayBrightnessSettingsObserverReceiver, a4 as AmbientLightSensorObserverReceiver, a5 as DisplayConfigurationObserverReceiver, a6 as isDisplayBrightnessControlInSettingsEnabled, a7 as DisplaySettingsOrientationOption, a8 as focusWithoutInk$1, a9 as CrSliderElement, aa as BatteryType, ab as CompanionAppState$1, ac as CrLinkRowElement, ad as PersonalizationHubBrowserProxyImpl, ae as KeyboardBrightnessObserverReceiver, af as KeyboardAmbientLightSensorObserverReceiver, ag as LidStateObserverReceiver, ah as SixPackShortcutModifier$1, ai as ModifierKey$2, aj as Fkey, ak as ExtendedFkeysModifier$1, al as TopRowActionKey$1, am as SixPackKey, an as CustomizationRestriction$1, ao as SimulateRightClickModifier$1, ap as FakeInputDeviceSettingsProvider, aq as MouseSettingsObserverReceiver, ar as assertExhaustive, as as OptimizedChargingStrategy, at as CrPolicyPrefMixin, au as isBatteryChargeLimitAvailable, av as LidClosedBehavior, aw as IdleBehavior, ax as isExternalStorageEnabled, ay as isSkyVaultEnabled, az as isCrostiniSupported, aA as StorageSpaceState, aB as castExists$1, aC as isRTL$1, aD as I18nBehavior, aE as CrPolicyNetworkBehaviorMojo, aF as OncMojo, aG as assert$1, aH as FAKE_CREDENTIAL, aI as isActiveSim, aJ as NetworkListenerBehavior, aK as InternetPageBrowserProxyImpl, aL as processDeviceState, aM as isCarrierLockedActiveSim, aN as getApnDisplayName, aO as shouldDisallowNetworkModifications, aP as assertInstanceof, aQ as getESimProfileProperties, aR as CellularSetupPageName, aS as CrPolicyIndicatorType$1, aT as CrScrollableMixin, aU as ESimManagerListenerMixin, aV as MultiDeviceBrowserProxyImpl, aW as getEuicc, aX as getSimSlotCount, aY as MultiDeviceFeatureState, aZ as BrowserProxy, a_ as getImage, a$ as MultiDeviceFeatureMixin, b0 as MultiDeviceFeature, b1 as PhoneHubPermissionsSetupFeatureCombination, b2 as sanitizeInnerHtml, b3 as SyncBrowserProxyImpl, b4 as MultiDeviceSettingsMode, b5 as PhoneHubFeatureAccessProhibitedReason, b6 as ChromeVoxSubpageBrowserProxyImpl, b7 as __decorate, b8 as mixinDelegatesAria, b9 as redispatchEvent, ba as EventTracker$1, bb as FaceGazeSubpageBrowserProxyImpl, bc as getShortcutInputProvider, bd as SettingsToggleButtonElement, be as FindShortcutMixin, bf as SelectToSpeakSubpageBrowserProxyImpl, bg as LanguagesBrowserProxyImpl, bh as SwitchAccessSubpageBrowserProxyImpl, bi as TextToSpeechSubpageBrowserProxyImpl, bj as TtsVoiceSubpageBrowserProxyImpl, bk as BrowserChannel, bl as AboutPageBrowserProxyImpl, bm as isTargetChannelMoreStable, bn as DeviceNameBrowserProxyImpl, bo as SetDeviceNameResult, bp as browserChannelToI18nId, bq as DeviceNameState, br as AndroidAppsBrowserProxyImpl, bs as PromiseResolver, bt as AppManagementStoreMixin, bu as AppManagementBrowserProxy, bv as recordAppManagementUserAction, bw as AppManagementUserAction, bx as getSubAppsOfSelectedApp, by as getParentApp, bz as openAppDetailPage, bA as PrivacyHubMixin, bB as MediaDevicesProxy, bC as isSensorAvailable, bD as getPermission, bE as getPermissionValueBool, bF as isBoolValue, bG as getBoolPermissionValue, bH as isTriStateValue, bI as getTriStatePermissionValue, bJ as createBoolPermission, bK as createTriStatePermission, bL as getPermissionDescriptionString, bM as getSelectedApp, bN as AppLanguageSelectionDialogEntryPoint, bO as PluginVmBrowserProxyImpl, bP as updateSelectedAppId, bQ as openMainPage, bR as AppManagementEntryPointsHistogramName, bS as AppManagementEntryPoint, bT as getAppIcon, bU as AppManagementStore, bV as alphabeticalSort$1, bW as getAppNotificationProvider, bX as isPermissionEnabled, bY as createBoolPermissionValue, bZ as createTriStatePermissionValue, b_ as AppNotificationsObserverReceiver, b$ as isAppInstalled, c0 as getAppParentalControlsProvider, c1 as AppParentalControlsObserverReceiver, c2 as getDeviceNameUnsafe, c3 as hasTrueWirelessImages, c4 as getBatteryPercentage, c5 as hasDefaultImage, c6 as hasAnyDetailedBatteryInfo, c7 as OsBluetoothDevicesSubpageBrowserProxyImpl, c8 as recordBluetoothUiSurfaceMetrics, c9 as BluetoothUiSurface, ca as recordSavedDevicesUiEventMetrics, cb as FastPairSavedDevicesUiEvent, cc as FocusRowMixin, cd as FastPairSavedDevicesOptInStatus, ce as GoogleDriveBrowserProxy, cf as Stage, cg as OneDriveBrowserProxy, ch as GlobalScrollTargetMixin, ci as OsSettingsSubpageElement, cj as ACCESSIBILITY_COMMON_IME_ID, ck as IronA11yKeysBehavior, cl as AcceleratorActionSpec$1, cm as StandardAcceleratorPropertiesSpec, cn as MetaKeySpec$1, co as AcceleratorAction$1, cp as LifetimeBrowserProxyImpl, cq as fireAuthTokenInvalidEvent, cr as LockStateMixin, cs as assertInstanceof$1, ct as CrInputElement, cu as CrButtonElement, cv as CrDialogElement, cw as CrIconButtonElement, cx as CrActionMenuElement, cy as recordLockScreenProgress, cz as LockScreenProgress, cA as PageStatus, cB as SignedInState, cC as StatusAction, cD as PrinterSetupResult, cE as PrintServerResult, cF as CupsPrintersBrowserProxyImpl, cG as getAppPermissionProvider, cH as AppPermissionsObserverReceiver, cI as CAMERA_SUBPAGE_USER_ACTION_HISTOGRAM_NAME, cJ as PrivacyHubSensorSubpageUserAction, cK as NUMBER_OF_POSSIBLE_USER_ACTIONS, cL as isSecondaryUser, cM as MICROPHONE_SUBPAGE_USER_ACTION_HISTOGRAM_NAME, cN as StaticShortcutAction$1, cO as ButtonPressObserverReceiver, cP as AcceleratorKeyState } from './shared.rollup.js';
export { dh as AccountManagerBrowserProxyImpl, c$ as ApnSubpageElement, cS as AppLanguageSelectionDialogElement, cT as AppLanguageSelectionItemElement, d3 as AppManagementSupportedLinksItemElement, d4 as AppManagementSupportedLinksOverlappingAppsDialogElement, d5 as AppManagementUninstallButtonElement, d6 as AppSetupPinDialogElement, d7 as AppSetupPinKeyboardElement, d8 as AppVerifyPinDialogElement, cZ as CROSTINI_TYPE, cU as CrostiniPortProtocol, cV as CrostiniSettingsCardElement, cW as DateTimeSettingsCardElement, de as FilesSettingsCardElement, di as GraduationSettingsCardElement, df as LanguageSettingsCardElement, d1 as NearbyShareReceiveDialogElement, dr as OsResetBrowserProxyImpl, dq as OsSettingsPowerwashDialogElement, ds as OsSettingsSanitizeDialogElement, c_ as PLUGIN_VM_TYPE, d9 as ParentalControlsDialogAction, da as ParentalControlsPinDialogError, dj as PrintingSettingsCardElement, dt as ResetSettingsCardElement, dp as SecureDnsInputElement, dm as SecureDnsResolverType, db as SettingsBluetoothDevicesSubpageElement, dg as SettingsLanguagesElement, d0 as SettingsMultideviceFeatureToggleElement, d2 as SettingsNearbyShareSubpageElement, dc as SettingsPairedBluetoothListElement, dd as SettingsPairedBluetoothListItemElement, dk as SettingsPrivacyHubGeolocationSubpage, dl as SettingsPrivacyHubSubpage, dn as SettingsSecureDnsElement, cQ as SmbBrowserProxyImpl, cR as SmbMountResult, cX as TimezoneSelectorElement, cY as setShortcutInputProviderForTesting } from './shared.rollup.js';
import { loadTimeData } from 'chrome://resources/js/load_time_data.js';
import { html, PolymerElement, microTask, dedupingMixin, mixinBehaviors, flush, afterNextRender, calculateSplices, templatize, Polymer } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { DeviceType, AudioOutputCapability, DeviceConnectionState } from 'chrome://resources/mojo/chromeos/ash/services/bluetooth_config/public/mojom/cros_bluetooth_config.mojom-webui.js';
import { sendWithPromise, addWebUiListener, removeWebUiListener } from 'chrome://resources/js/cr.js';
import { css, LitElement, html as html$1, nothing, classMap, styleMap, customElement, property, isServer, query } from 'chrome://resources/mwc/lit/index.js';
import { getHotspotConfig } from 'chrome://resources/ash/common/hotspot/cros_hotspot_config.js';
import { HotspotState, HotspotAllowStatus, SetHotspotConfigResult } from 'chrome://resources/ash/common/hotspot/cros_hotspot_config.mojom-webui.js';
import { loadTimeData as loadTimeData$1 } from 'chrome://resources/ash/common/load_time_data.m.js';
import { OncSource, PolicySource, ConnectionStateType, NetworkType, IPConfigType, PortalState, DeviceStateType } from 'chrome://resources/mojo/chromeos/services/network_config/public/mojom/network_types.mojom-webui.js';
import { ApnState, ApnAuthenticationType, ApnIpType, ApnType, ApnSource, NO_ROUTING_PREFIX, FilterType, NO_LIMIT, HiddenSsidMode, VpnType, ActivationStateType, SecurityType, MatchType, InhibitReason, AlwaysOnVpnMode } from 'chrome://resources/mojo/chromeos/services/network_config/public/mojom/cros_network_config.mojom-webui.js';
import { MojoInterfaceProviderImpl } from 'chrome://resources/ash/common/network/mojo_interface_provider.js';
import { MojoConnectivityProvider } from 'chrome://resources/ash/common/connectivity/mojo_connectivity_provider.js';
import { PasspointEventsListenerReceiver } from 'chrome://resources/ash/common/connectivity/passpoint.mojom-webui.js';
import { ProfileInstallResult, ProfileState } from 'chrome://resources/mojo/chromeos/ash/services/cellular_setup/public/mojom/esim_manager.mojom-webui.js';
import { AppType, InstallReason, InstallSource, PermissionType, TriState } from 'chrome://resources/cr_components/app_management/app_management.mojom-webui.js';
import { mojo } from 'chrome://resources/mojo/mojo/public/js/bindings.js';
import { getBluetoothConfig } from 'chrome://resources/ash/common/bluetooth/cros_bluetooth_config.js';
import { ConfigureResult, PasswordFactorEditor, PasswordComplexity, FactorObserverReceiver, AuthFactorConfig, AuthFactor, PinFactorEditor, ManagementType } from 'chrome://resources/mojo/chromeos/ash/services/auth_factor_config/public/mojom/auth_factor_config.mojom-webui.js';
import 'chrome://resources/ash/common/cellular_setup/mojo_interface_provider.js';
import 'chrome://resources/mojo/chromeos/ash/services/nearby/public/mojom/nearby_share_settings.mojom-webui.js';
import 'chrome://resources/mojo/chromeos/ash/services/nearby/public/mojom/nearby_share_target_types.mojom-webui.js';
import 'chrome://resources/ash/common/bluetooth/hid_preserving_bluetooth_state_controller.js';
import 'chrome://resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js';
import 'chrome://resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';

function getTemplate$3s() {
    return html `<!--_html_template_start_--><style include="settings-shared"></style>
<cr-dialog id="dialog" show-on-attach close-text="$i18n{close}"
    on-cancel="onDialogCancel_" on-close="onDialogClose_">
  <!-- Pass through the "body" slot. -->
  <div slot="body"><slot name="body"></slot></div>
  <div slot="button-container">
    <cr-button class="cancel-button" on-click="onCancelClick_">
      [[cancelButtonText]]
    </cr-button>
    <cr-button class="action-button" on-click="onAcceptClick_">
      [[acceptButtonText]]
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-guest-os-confirmation-dialog' is a wrapper of
 * <cr-dialog> which
 *
 * - shows an accept button and a cancel button (you can customize the label via
 *   props);
 * - The close event has a boolean `e.detail.accepted` indicating whether the
 *   dialog is accepted or not.
 * - The dialog shows itself automatically when it is attached.
 */
class SettingsGuestOsConfirmationDialogElement extends PolymerElement {
    static get is() {
        return 'settings-guest-os-confirmation-dialog';
    }
    static get template() {
        return getTemplate$3s();
    }
    static get properties() {
        return {
            acceptButtonText: String,
            cancelButtonText: {
                type: String,
                value: loadTimeData.getString('cancel'),
            },
        };
    }
    constructor() {
        super();
        this.accepted_ = true;
    }
    onCancelClick_() {
        this.$.dialog.cancel();
    }
    onAcceptClick_() {
        this.$.dialog.close();
    }
    onDialogCancel_() {
        this.accepted_ = false;
    }
    onDialogClose_(e) {
        e.stopPropagation();
        const closeEvent = new CustomEvent('close', { bubbles: true, composed: true, detail: { accepted: this.accepted_ } });
        this.dispatchEvent(closeEvent);
    }
}
customElements.define(SettingsGuestOsConfirmationDialogElement.is, SettingsGuestOsConfirmationDialogElement);

function getTemplate$3r() {
    return html `<!--_html_template_start_--><style include="settings-shared"></style>
<cr-link-row
    class="hr"
    label="$i18n{guestOsSharedUsbDevicesLabel}"
    id="bruschettaSharedUsbDevicesRow"
    on-click="onSharedUsbDevicesClick_"
    role-description="$i18n{subpageArrowRoleDescription}">
</cr-link-row>

<cr-link-row
    class="hr"
    label="$i18n{guestOsSharedPaths}"
    id="bruschettaSharedPathsRow"
    on-click="onSharedPathsClick_"
    role-description="$i18n{subpageArrowRoleDescription}">
</cr-link-row>

<settings-toggle-button
    class="hr"
    id="bruschetta-mic-permission-toggle"
    pref="{{prefs.bruschetta.mic_allowed}}"
    no-set-pref
    label="$i18n{bruschettaMicTitle}"
    on-settings-boolean-control-change="onMicPermissionChange_"
    deep-link-focus-id$="[[Setting.kBruschettaMicAccess]]">
</settings-toggle-button>
<template is="dom-if" if="[[showBruschettaMicPermissionDialog_]]" restamp>
  <settings-guest-os-confirmation-dialog
      id="bruschetta-mic-permission-dialog"
      accept-button-text="$i18n{bruschettaMicDialogShutdownButton}"
      on-close="onBruschettaMicPermissionDialogClose_">
    <div slot="body">$i18n{bruschettaMicDialogLabel}</div>
  </settings-guest-os-confirmation-dialog>
</template>
<div id="remove" class="settings-box">
  <div id="removeBruschettaLabel" class="start" aria-hidden="true">
    $i18n{bruschettaRemove}
  </div>
  <cr-button on-click="onRemoveClick_"
      aria-label="$i18n{bruschettaRemoveButton}"
      aria-describedby="removeBruschettaLabel">
    $i18n{bruschettaRemoveButton}
  </cr-button>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'bruschetta-subpage' is the settings subpage for managing Bruschetta
 * (third-party VMs).
 */
const BruschettaSubpageElementBase = DeepLinkingMixin(RouteOriginMixin(PrefsMixin(PolymerElement)));
class BruschettaSubpageElement extends BruschettaSubpageElementBase {
    static get is() {
        return 'settings-bruschetta-subpage';
    }
    static get template() {
        return getTemplate$3r();
    }
    static get properties() {
        return {
            showBruschettaMicPermissionDialog_: {
                type: Boolean,
                value: false,
            },
        };
    }
    static get observers() {
        return [
            'onInstalledChanged_(prefs.bruschetta.installed.value)',
        ];
    }
    constructor() {
        super();
        // DeepLinkingMixin override
        this.supportedSettingIds = new Set([
            Setting.kBruschettaMicAccess,
        ]);
        /** RouteOriginMixin override */
        this.route = routes.BRUSCHETTA_DETAILS;
        // For now we reuse the Crostini browser proxy, we're both part of
        // crostini_page. At some point we may want to split them apart (or make
        // something for all guest OSs).
        this.browserProxy_ = CrostiniBrowserProxyImpl.getInstance();
    }
    ready() {
        super.ready();
        this.addFocusConfig(routes.BRUSCHETTA_SHARED_USB_DEVICES, '#bruschettaSharedUsbDevicesRow');
        this.addFocusConfig(routes.BRUSCHETTA_SHARED_PATHS, '#bruschettaSharedPathsRow');
    }
    onSharedUsbDevicesClick_() {
        Router.getInstance().navigateTo(routes.BRUSCHETTA_SHARED_USB_DEVICES);
    }
    onSharedPathsClick_() {
        Router.getInstance().navigateTo(routes.BRUSCHETTA_SHARED_PATHS);
    }
    onRemoveClick_() {
        this.browserProxy_.requestBruschettaUninstallerView();
    }
    onInstalledChanged_(installed) {
        if (!installed &&
            Router.getInstance().currentRoute === routes.BRUSCHETTA_DETAILS) {
            Router.getInstance().navigateToPreviousRoute();
        }
    }
    getMicToggle_() {
        return castExists(this.shadowRoot.querySelector('#bruschetta-mic-permission-toggle'));
    }
    /**
     * If a change to the mic settings requires Bruschetta to be restarted, a
     * dialog is shown.
     */
    async onMicPermissionChange_() {
        if (await this.browserProxy_.checkBruschettaIsRunning()) {
            this.showBruschettaMicPermissionDialog_ = true;
        }
        else {
            this.getMicToggle_().sendPrefChange();
        }
    }
    onBruschettaMicPermissionDialogClose_(e) {
        const toggle = this.getMicToggle_();
        if (e.detail.accepted) {
            toggle.sendPrefChange();
            this.browserProxy_.shutdownBruschetta();
        }
        else {
            toggle.resetToPrefValue();
        }
        this.showBruschettaMicPermissionDialog_ = false;
    }
}
customElements.define(BruschettaSubpageElement.is, BruschettaSubpageElement);

function getTemplate$3q() {
    return html `<!--_html_template_start_--><style include="settings-shared"></style>
<cr-dialog id="dialog" close-text="$i18n{close}">
  <div slot="title" hidden="[[!isEnabling_(action)]]">
    $i18n{crostiniArcAdbConfirmationTitleEnable}
  </div>
  <div slot="title" hidden="[[!isDisabling_(action)]]">
    $i18n{crostiniArcAdbConfirmationTitleDisable}
  </div>
  <div slot="body" hidden="[[!isEnabling_(action)]]">
    $i18n{crostiniArcAdbConfirmationMessageEnable}
  </div>
  <div slot="body" hidden="[[!isDisabling_(action)]]">
    $i18n{crostiniArcAdbConfirmationMessageDisable}
  </div>
  <div slot="button-container">
    <cr-button id="cancel" class="cancel-button" on-click="onCancelClick_">
      $i18n{cancel}
    </cr-button>
    <cr-button id="continue" class="action-button" on-click="onRestartClick_">
      $i18n{crostiniArcAdbRestartButton}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-crostini-arc-adb-confirmation-dialog' is a component
 * to confirm for enabling or disabling adb sideloading. After the confirmation,
 * reboot will happens.
 */
class SettingsCrostiniArcAdbConfirmationDialogElement extends PolymerElement {
    static get is() {
        return 'settings-crostini-arc-adb-confirmation-dialog';
    }
    static get template() {
        return getTemplate$3q();
    }
    static get properties() {
        return {
            /** An attribute that indicates the action for the confirmation */
            action: {
                type: String,
            },
        };
    }
    constructor() {
        super();
        this.browserProxy_ = CrostiniBrowserProxyImpl.getInstance();
    }
    connectedCallback() {
        super.connectedCallback();
        this.$.dialog.showModal();
    }
    isEnabling_() {
        return this.action === 'enable';
    }
    isDisabling_() {
        return this.action === 'disable';
    }
    onCancelClick_() {
        this.$.dialog.close();
    }
    onRestartClick_() {
        if (this.isEnabling_()) {
            this.browserProxy_.enableArcAdbSideload();
            recordSettingChange(Setting.kCrostiniAdbDebugging, { boolValue: true });
        }
        else if (this.isDisabling_()) {
            this.browserProxy_.disableArcAdbSideload();
            recordSettingChange(Setting.kCrostiniAdbDebugging, { boolValue: false });
        }
        else {
            assertNotReached();
        }
    }
}
customElements.define(SettingsCrostiniArcAdbConfirmationDialogElement.is, SettingsCrostiniArcAdbConfirmationDialogElement);

function getTemplate$3p() {
    return html `<!--_html_template_start_--><style include="settings-shared">cr-policy-indicator{padding:0 var(--cr-controlled-by-spacing)}</style>
<div class="settings-box first">
  <div class="settings-box-text">
    $i18n{crostiniArcAdbDescription}
  </div>
</div>
<div class="settings-box continuation">
  <div id="enableArcAdbLabel" class="start">
    $i18n{crostiniArcAdbLabel}
    <div class="secondary" hidden="[[!arcAdbNeedPowerwash_]]">
      <localized-link
          localized-string="[[i18nAdvanced(
            'crostiniArcAdbPowerwashRequiredSublabel')]]">
      </localized-link>
    </div>
  </div>
  <cr-policy-indicator indicator-type="[[getPolicyIndicatorType_(
      isOwnerProfile_, isEnterpriseManaged_, canChangeAdbSideloading_)]]">
  </cr-policy-indicator>
  <cr-toggle id="arcAdbEnabledButton" aria-labelledby="enableArcAdbLabel"
      checked$="[[arcAdbEnabled_]]"
      disabled="[[shouldDisable_(canChangeAdbSideloading_,
                  arcAdbNeedPowerwash_)]]"
      on-change="onArcAdbToggleChanged_"
      deep-link-focus-id$="[[Setting.kCrostiniAdbDebugging]]">
  </cr-toggle>
</div>

<template is="dom-if" if="[[showConfirmationDialog_]]" restamp>
  <settings-crostini-arc-adb-confirmation-dialog
      action="[[getToggleAction_(arcAdbEnabled_)]]"
      on-close="onConfirmationDialogClose_">
  </settings-crostini-arc-adb-confirmation-dialog>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'crostini-arc-adb' is the ARC adb sideloading subpage for Crostini.
 */
const SettingsCrostiniArcAdbElementBase = DeepLinkingMixin(RouteObserverMixin(WebUiListenerMixin(I18nMixin(PolymerElement))));
class SettingsCrostiniArcAdbElement extends SettingsCrostiniArcAdbElementBase {
    static get is() {
        return 'settings-crostini-arc-adb';
    }
    static get template() {
        return getTemplate$3p();
    }
    static get properties() {
        return {
            prefs: {
                type: Object,
                notify: true,
            },
            arcAdbEnabled_: {
                type: Boolean,
                value: false,
            },
            /**
             * Whether the device requires a powerwash first (to define nvram for boot
             * lockbox). This happens to devices initialized through OOBE flow before
             * M74.
             */
            arcAdbNeedPowerwash_: {
                type: Boolean,
                value: false,
            },
            isOwnerProfile_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('isOwnerProfile');
                },
            },
            isEnterpriseManaged_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('isEnterpriseManaged');
                },
            },
            canChangeAdbSideloading_: {
                type: Boolean,
                value: false,
            },
            showConfirmationDialog_: {
                type: Boolean,
                value: false,
            },
        };
    }
    constructor() {
        super();
        // DeepLinkingMixin override
        this.supportedSettingIds = new Set([
            Setting.kCrostiniAdbDebugging,
        ]);
        this.browserProxy_ = CrostiniBrowserProxyImpl.getInstance();
    }
    connectedCallback() {
        super.connectedCallback();
        this.addWebUiListener('crostini-arc-adb-sideload-status-changed', (enabled, needPowerwash) => {
            this.arcAdbEnabled_ = enabled;
            this.arcAdbNeedPowerwash_ = needPowerwash;
        });
        this.addWebUiListener('crostini-can-change-arc-adb-sideload-changed', (canChangeArcAdbSideloading) => {
            this.canChangeAdbSideloading_ = canChangeArcAdbSideloading;
        });
        this.browserProxy_.requestArcAdbSideloadStatus();
        this.browserProxy_.getCanChangeArcAdbSideloading();
    }
    currentRouteChanged(route) {
        // Does not apply to this page.
        if (route !== routes.CROSTINI_ANDROID_ADB) {
            return;
        }
        this.attemptDeepLink();
    }
    /**
     * Returns whether the toggle is changeable by the user. See
     * CrostiniFeatures::CanChangeAdbSideloading(). Note that the actual
     * guard should be in the browser, otherwise a user may bypass this check by
     * inspecting Settings with developer tools.
     * @return Whether the control should be disabled.
     */
    shouldDisable_() {
        return !this.canChangeAdbSideloading_ || this.arcAdbNeedPowerwash_;
    }
    /**
     * @return Which policy indicator to show (if any).
     */
    getPolicyIndicatorType_() {
        if (this.isEnterpriseManaged_) {
            if (this.canChangeAdbSideloading_) {
                return CrPolicyIndicatorType.NONE;
            }
            else {
                return CrPolicyIndicatorType.DEVICE_POLICY;
            }
        }
        else if (!this.isOwnerProfile_) {
            return CrPolicyIndicatorType.OWNER;
        }
        else {
            return CrPolicyIndicatorType.NONE;
        }
    }
    /**
     * @return Which action to perform when the toggle is changed.
     */
    getToggleAction_() {
        return this.arcAdbEnabled_ ? 'disable' : 'enable';
    }
    onArcAdbToggleChanged_() {
        this.showConfirmationDialog_ = true;
    }
    onConfirmationDialogClose_() {
        this.showConfirmationDialog_ = false;
        this.$.arcAdbEnabledButton.checked = this.arcAdbEnabled_;
    }
}
customElements.define(SettingsCrostiniArcAdbElement.is, SettingsCrostiniArcAdbElement);

function getTemplate$3o() {
    return html `<!--_html_template_start_--><style include="settings-shared"></style>
<cr-dialog id="dialog" close-text="$i18n{close}">
  <div slot="title">$i18n{crostiniImportConfirmationDialogTitle}</div>
  <div slot="body">$i18n{crostiniImportConfirmationDialogMessage}</div>
  <div slot="button-container">
    <cr-button id="cancel" class="cancel-button"
        on-click="onCancelClick_">$i18n{cancel}</cr-button>
    <cr-button id="continue" class="action-button"
        on-click="onContinueClick_">
      $i18n{crostiniImportConfirmationDialogConfirmationButton}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-crostini-import-confirmation-dialog' is a component
 * warning the user that importing a container overrides the existing container.
 * By clicking 'Continue', the user agrees to start the import.
 */
class SettingsCrostiniImportConfirmationDialogElement extends PolymerElement {
    static get is() {
        return 'settings-crostini-import-confirmation-dialog';
    }
    static get template() {
        return getTemplate$3o();
    }
    static get properties() {
        return {
            importContainerId: {
                type: Object,
            },
        };
    }
    constructor() {
        super();
        this.browserProxy_ = CrostiniBrowserProxyImpl.getInstance();
    }
    connectedCallback() {
        super.connectedCallback();
        this.$.dialog.showModal();
    }
    onCancelClick_() {
        this.$.dialog.close();
    }
    onContinueClick_() {
        if (this.importContainerId.vm_type === VmType.BAGUETTE) {
            this.browserProxy_.importDiskImage(this.importContainerId);
        }
        else {
            this.browserProxy_.importCrostiniContainer(this.importContainerId);
        }
        recordSettingChange(Setting.kRestoreLinuxAppsAndFiles);
        this.$.dialog.close();
    }
}
customElements.define(SettingsCrostiniImportConfirmationDialogElement.is, SettingsCrostiniImportConfirmationDialogElement);

function getTemplate$3n() {
    return html `<!--_html_template_start_--><style include="settings-shared md-select"></style>
<label class="cr-form-field-label">Container</label>
<select id="selectContainer"
    class="md-select"
    value="containerLabel_(containerId)"
    on-change="onSelectContainer_">
    <template is="dom-repeat" items="[[containers]]">
      <option value="[[item.id]]">
        [[containerLabel_(item.id)]]
      </option>
    </template>
</select>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-guest-os-container-select' is a component enabling a
 * user to select a target container from a list stored in prefs.
 */
function equalContainerId(first, second) {
    return first.vm_name === second.vm_name &&
        first.container_name === second.container_name &&
        first.vm_type === second.vm_type;
}
function containerLabel(id, defaultVmName) {
    if (defaultVmName !== null && id.vm_name === defaultVmName) {
        return id.container_name;
    }
    return id.vm_name + ':' + id.container_name;
}
class ContainerSelectElement extends PolymerElement {
    static get is() {
        return 'settings-guest-os-container-select';
    }
    static get template() {
        return getTemplate$3n();
    }
    static get properties() {
        return {
            selectedContainerId: {
                type: Object,
                notify: true,
            },
            defaultVmName: {
                type: String,
                value: null,
            },
            /**
             * List of containers that are already stored in the settings.
             */
            containers: {
                type: Array,
                value() {
                    return [];
                },
            },
        };
    }
    onSelectContainer_(e) {
        const index = cast(e.target, HTMLSelectElement).selectedIndex;
        if (index >= 0 && index < this.containers.length) {
            this.selectedContainerId = this.containers[index].id;
        }
    }
    containerLabel_(id) {
        return containerLabel(id, this.defaultVmName);
    }
}
customElements.define(ContainerSelectElement.is, ContainerSelectElement);

function getTemplate$3m() {
    return html `<!--_html_template_start_--><style include="settings-shared">.container-select{padding:0 8px}.two-line-settings-box{min-height:80px}#secondaryText{padding:3px 0}</style>
<div id="export"
  class$="settings-box first [[getSettingsBoxClass_(allContainers_)]]">
  <div id="exportCrostiniLabel" class="start">
    $i18n{crostiniExportLabel}
    <template is="dom-if" if="[[showContainerSelect_]]" restamp>
      <div class="secondary" id="secondaryText">
        Container to backup
        <settings-guest-os-container-select
          class="container-select"
          id="exportContainerSelect"
          containers="[[allContainers_]]"
          selected-container-id="{{exportContainerId_}}"
          default-vm-name="[[defaultVmName_]]">
        </settings-guest-os-container-select>
      </div>
    </template>
  </div>
  <cr-button on-click="onExportClick_" disabled="[[!enableButtons_]]"
      aria-labelledby="exportCrostiniLabel"
      deep-link-focus-id$="[[Setting.kBackupLinuxAppsAndFiles]]">
    $i18n{crostiniExport}
  </cr-button>
</div>
<div id="import" class$="settings-box [[getSettingsBoxClass_(allContainers_)]]">
  <div id="importCrostiniLabel" class="start">
    $i18n{crostiniImportLabel}
    <template is="dom-if" if="[[showContainerSelect_]]" restamp>
      <div class="secondary" id="secondaryText">
        Container to restore
        <settings-guest-os-container-select
          class="container-select"
          id="importContainerSelect"
          containers="[[allContainers_]]"
          selected-container-id="{{importContainerId_}}"
          default-vm-name="[[defaultVmName_]]">
        </settings-guest-os-container-select>
      </div>
    </template>
  </div>
  <cr-button on-click="onImportClick_" disabled="[[!enableButtons_]]"
      aria-labelledby="importCrostiniLabel"
      deep-link-focus-id$="[[Setting.kRestoreLinuxAppsAndFiles]]">
    $i18n{crostiniImport}
  </cr-button>
</div>
<template is="dom-if" if="[[showImportConfirmationDialog_]]" restamp>
  <settings-crostini-import-confirmation-dialog
      on-close="onImportConfirmationDialogClose_"
      import-container-id="{{importContainerId_}}">
  </settings-crostini-import-confirmation-dialog>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'crostini-export-import' is the settings backup and restore subpage for
 * Crostini.
 */
const SettingsCrostiniExportImportElementBase = DeepLinkingMixin(RouteObserverMixin(WebUiListenerMixin(PolymerElement)));
class SettingsCrostiniExportImportElement extends SettingsCrostiniExportImportElementBase {
    static get is() {
        return 'settings-crostini-export-import';
    }
    static get template() {
        return getTemplate$3m();
    }
    static get properties() {
        return {
            prefs: {
                type: Object,
                notify: true,
            },
            showImportConfirmationDialog_: {
                type: Boolean,
                value: false,
            },
            /**
             * Whether the export import buttons should be enabled. Initially false
             * until status has been confirmed.
             */
            enableButtons_: {
                type: Boolean,
                computed: 'isEnabledButtons_(installerShowing_, exportImportInProgress_)',
            },
            /**
             * Whether the container select element is displayed.
             */
            showContainerSelect_: {
                type: Boolean,
                computed: 'isMultiContainer_(allContainers_)',
            },
            installerShowing_: {
                type: Boolean,
                value: false,
            },
            exportImportInProgress_: {
                type: Boolean,
                value: false,
            },
            /**
             * The known containers for display in the UI.
             */
            allContainers_: {
                type: Array,
                notify: true,
                value() {
                    return [];
                },
            },
            /**
             * The GuestId of the container to be exported.
             */
            exportContainerId_: {
                type: Object,
                value() {
                    return DEFAULT_CROSTINI_GUEST_ID;
                },
            },
            /**
             * The GuestId of the container to be overwritten by an imported
             * container file.
             */
            importContainerId_: {
                type: Object,
                value() {
                    return DEFAULT_CROSTINI_GUEST_ID;
                },
            },
            defaultVmName_: {
                type: String,
                value: DEFAULT_CROSTINI_VM,
            },
        };
    }
    constructor() {
        super();
        // DeepLinkingMixin override
        this.supportedSettingIds = new Set([
            Setting.kBackupLinuxAppsAndFiles,
            Setting.kRestoreLinuxAppsAndFiles,
        ]);
        this.browserProxy_ = CrostiniBrowserProxyImpl.getInstance();
    }
    connectedCallback() {
        super.connectedCallback();
        this.addWebUiListener('crostini-export-import-operation-status-changed', (inProgress) => {
            this.exportImportInProgress_ = inProgress;
        });
        this.addWebUiListener('crostini-installer-status-changed', (installerShowing) => {
            this.installerShowing_ = installerShowing;
        });
        this.addWebUiListener('crostini-container-info', (infos) => this.onContainerInfo_(infos));
        this.browserProxy_.requestCrostiniExportImportOperationStatus();
        this.browserProxy_.requestCrostiniInstallerStatus();
        this.browserProxy_.requestContainerInfo();
    }
    currentRouteChanged(route) {
        // Does not apply to this page.
        if (route !== routes.CROSTINI_EXPORT_IMPORT) {
            return;
        }
        this.attemptDeepLink();
    }
    onContainerInfo_(containerInfos) {
        this.allContainers_ = containerInfos;
        if (!this.isMultiContainer_(containerInfos)) {
            if (containerInfos[0].id.vm_type === VmType.BAGUETTE) {
                this.exportContainerId_ = DEFAULT_BAGUETTE_GUEST_ID;
                this.importContainerId_ = DEFAULT_BAGUETTE_GUEST_ID;
            }
            else {
                this.exportContainerId_ = DEFAULT_CROSTINI_GUEST_ID;
                this.importContainerId_ = DEFAULT_CROSTINI_GUEST_ID;
            }
        }
    }
    onExportClick_() {
        this.browserProxy_.exportDiskImage(this.exportContainerId_);
        recordSettingChange(Setting.kBackupLinuxAppsAndFiles);
    }
    onImportClick_() {
        this.showImportConfirmationDialog_ = true;
    }
    onImportConfirmationDialogClose_() {
        this.showImportConfirmationDialog_ = false;
    }
    isEnabledButtons_(installerShowing, exportImportInProgress) {
        return !(installerShowing || exportImportInProgress);
    }
    isMultiContainer_(allContainers) {
        return allContainers.length !== 1;
    }
    getSettingsBoxClass_(allContainers) {
        return this.isMultiContainer_(allContainers) ? 'two-line-settings-box' : '';
    }
}
customElements.define(SettingsCrostiniExportImportElement.is, SettingsCrostiniExportImportElement);

function getTemplate$3l() {
    return html `<!--_html_template_start_--><style include="settings-shared md-select">.custom-button-container{float:right}.input-container{display:flex;flex-direction:row;justify-content:space-between}.advanced-section{display:flex;flex-direction:column;justify-content:space-between;padding-bottom:12px;padding-inline-start:20px}.custom-body{padding-bottom:20px}#advancedToggle{--ink-color:var(--cros-text-color-primary);background:none;border:none;box-shadow:none;color:var(--cros-text-color-primary);font-weight:400;margin-bottom:12px;min-height:32px;padding-inline-start:0}#containerFileField{display:flex;flex-direction:row}#containerFileInput{width:100%}</style>
<cr-dialog id="dialog" close-text="$i18n{close}">
  <div slot="title">$i18n{crostiniExtraContainersCreateDialogTitle}</div>
  <div slot="body">
    <div class="input-container">
      <cr-input id="containerNameInput"
          label="$i18n{crostiniExtraContainersContainerNameLabel}"
          aria-disabled="false"
          on-input="validateNames_"
          invalid="[[!validContainerName_]]"
          error-message="[[containerNameError_]]">
      </cr-input>
      <cr-input id="vmNameInput"
          label="$i18n{crostiniExtraContainersVmNameLabel}"
          aria-disabled="false"
          on-input="validateNames_">
      </cr-input>
    </div>

    <cr-button id="advancedToggle" on-click="advancedToggleClicked_"
        aria-expanded$="[[boolToString_(advancedToggleExpanded_)]]">
      <span>$i18n{advancedPageTitle}</span>
      <iron-icon
        icon="[[getArrowIcon_(advancedToggleExpanded_)]]"
        slot="suffix-icon">
      </iron-icon>
    </cr-button>
    <div class="advanced-section" hidden="[[!advancedToggleExpanded_]]">
      <cr-input id="imageServerInput"
        label="$i18n{crostiniExtraContainersCreateDialogImageServer}"
        aria-disabled="false">
      </cr-input>
      <cr-input id="imageAliasInput"
        label="$i18n{crostiniExtraContainersCreateDialogImageAlias}"
        aria-disabled="false">
      </cr-input>
      <div id="containerFileField">
        <cr-input id="containerFileInput"
          label="$i18n{crostiniExtraContainersCreateDialogAddContainerFile}"
          aria-disabled="true"
          readonly>
          <cr-button id="uploadButton"
            slot="suffix"
            on-click="onSelectContainerFileClick_"
            aria-labelledby="containerFileInput">
            $i18n{crostiniExtraContainersCreateDialogAddContainerButtonLabel}
          </cr-button>
        </cr-input>
      </div>
    </div>
  </div>

  <div slot="body" class="custom-body">
    <div slot="button-container" class="custom-button-container">
      <cr-button id="cancel" class="cancel-button" on-click="onCancelClick_">
        $i18n{cancel}
      </cr-button>
      <cr-button id="create" class="action-button" on-click="onCreateClick_"
          disabled="[[disableCreateButton_]]">
        $i18n{crostiniExtraContainersCreate}
      </cr-button>
    </div>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-crostini-create-container-dialog' is a component
 * enabling a user to create a new container.
 */
class ExtraContainersCreateDialog extends PolymerElement {
    static get is() {
        return 'settings-crostini-create-container-dialog';
    }
    static get template() {
        return getTemplate$3l();
    }
    static get properties() {
        return {
            /**
             * List of container properties that are already stored in settings.
             */
            allContainers: {
                type: Array,
                value: [],
            },
            containerFile_: {
                type: String,
                value: '',
            },
            inputVmName_: {
                type: String,
                value: DEFAULT_CROSTINI_VM,
            },
            inputContainerName_: {
                type: String,
                value: '',
            },
            inputImageServer_: {
                type: String,
                value: '',
            },
            inputImageAlias_: {
                type: String,
                value: '',
            },
            advancedToggleExpanded_: {
                type: Boolean,
                value: false,
            },
            disableCreateButton_: {
                type: Boolean,
                value: true,
            },
            validContainerName_: {
                type: Boolean,
                value: true,
            },
            containerNameError_: {
                type: String,
                value: '',
            },
        };
    }
    constructor() {
        super();
        this.browserProxy_ = CrostiniBrowserProxyImpl.getInstance();
    }
    connectedCallback() {
        super.connectedCallback();
        this.$.dialog.showModal();
        this.$.vmNameInput.value = this.inputVmName_;
        this.$.containerNameInput.value = this.inputContainerName_;
        this.$.imageServerInput.value = this.inputImageServer_;
        this.$.imageAliasInput.value = this.inputImageAlias_;
        this.$.containerNameInput.focus();
    }
    /**
     * @param input The vm name to verify.
     * @return if the input string is a valid vm name.
     */
    isValidVmName(_input) {
        // TODO(crbug:1261319) Allowing non a non-default VM based on policy (TBD).
        return true;
    }
    validateNames_() {
        this.inputVmName_ = this.$.vmNameInput.value.length === 0 ?
            DEFAULT_CROSTINI_VM :
            this.$.vmNameInput.value;
        this.inputContainerName_ = this.$.containerNameInput.value;
        this.containerNameError_ = '';
        if (this.inputContainerName_.length === 0) {
            this.containerNameError_ = loadTimeData.getString('crostiniExtraContainersCreateDialogEmptyContainerNameError');
        }
        else if (this.inputContainerName_ === DEFAULT_CROSTINI_CONTAINER ||
            this.allContainers.find(e => e.id.vm_name === this.inputVmName_ &&
                e.id.container_name === this.inputContainerName_)) {
            this.containerNameError_ = loadTimeData.getString('crostiniExtraContainersCreateDialogContainerExistsError');
        }
        this.validContainerName_ = this.containerNameError_.length === 0;
        this.disableCreateButton_ =
            !this.validContainerName_ || !this.isValidVmName(this.inputVmName_);
    }
    onCancelClick_() {
        this.$.dialog.close();
    }
    onCreateClick_() {
        if (this.advancedToggleExpanded_) {
            // These elements are part of a dom-if on |advancedToggleExpanded_|
            this.inputImageServer_ = this.$.imageServerInput.value;
            this.inputImageAlias_ = this.$.imageAliasInput.value;
            this.containerFile_ = this.$.containerFileInput.value;
        }
        this.browserProxy_.createContainer({
            vm_name: this.inputVmName_,
            container_name: this.inputContainerName_,
            vm_type: VmType.TERMINA,
        }, this.inputImageServer_, this.inputImageAlias_, this.containerFile_);
        this.$.dialog.close();
    }
    async onSelectContainerFileClick_() {
        this.$.containerFileInput.value =
            await this.browserProxy_.openContainerFileSelector();
    }
    advancedToggleClicked_() {
        this.advancedToggleExpanded_ = !this.advancedToggleExpanded_;
        // Force repaint.
        this.$.dialog.getBoundingClientRect();
    }
    /**
     * @param opened Whether the menu is expanded.
     * @return Icon name.
     */
    getArrowIcon_(opened) {
        return opened ? 'cr:arrow-drop-up' : 'cr:arrow-drop-down';
    }
    boolToString_(bool) {
        return bool.toString();
    }
}
customElements.define(ExtraContainersCreateDialog.is, ExtraContainersCreateDialog);

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Converts an SkColor object to a string in the form
 * "rgba(<red>, <green>, <blue>, <alpha>)".
 * @param skColor The input color.
 * @return The rgba string.
 */
/**
 * Converts a string of the form "#rrggbb" to an SkColor object.
 * @param hexColor The color string.
 * @return The SkColor object,
 */
function hexColorToSkColor(hexColor) {
    if (!/^#[0-9a-f]{6}$/.test(hexColor)) {
        return { value: 0 };
    }
    const r = parseInt(hexColor.substring(1, 3), 16);
    const g = parseInt(hexColor.substring(3, 5), 16);
    const b = parseInt(hexColor.substring(5, 7), 16);
    return { value: 0xff000000 + (r << 16) + (g << 8) + b };
}

function getTemplate$3k() {
    return html `<!--_html_template_start_--><style include="settings-shared">.container-details-list{padding-inline-start:var(--cr-section-indent-padding)}.detail-content{color:var(--cros-text-color-primary);flex:auto}.detail-heading{color:var(--cr-secondary-text-color);flex:auto}.vm-column{flex:1;flex-grow:3;word-break:break-all}#createExtraContainer{padding-top:10px}cr-expand-button{--cr-section-vertical-padding:0;flex:auto}</style>
<div class="settings-box first">
  <div id="extraContainersDescription" class="start">
    $i18n{crostiniExtraContainersDescription}
  </div>
</div>
<div class="settings-box first">
  <div id="extraContainersTableTitle" class="start"
      aria-hidden="true">
    $i18n{crostiniExtraContainersTableTitle}
  </div>
  <cr-button id="create" on-click="onCreateClick_" disabled="[[!enableButtons_]]">
    $i18n{crostiniExtraContainersCreate}
  </cr-button>
</div>

<template is="dom-repeat"
    items="[[allVms_]]" as="vmName" index-as="vmIndex"
    sort="byVmName_" mutable-data>
  <div class="settings-box hr">
    <div class="detail-heading">
      $i18n{crostiniExtraContainersVmNameLabel}:
      <span class="detail-content">[[vmName]]</span>
    </div>
  </div>
  <div class="list-frame vertical-list">
    <template is="dom-repeat" items="[[allContainers_]]"
        filter="[[infoHasVmName_(vmName)]]" sort="byGuestId_" mutable-data>
      <div class="list-item">
      <cr-expand-button
          class="list-item secondary"
          id="expand-button-[[item.id.vm_name]]-[[item.id.container_name]]"
          expanded="{{item.detailsExpanded}}"
          data-container-id="[[item.id]]">
        <div class="detail-heading">
          $i18n{crostiniExtraContainersContainerNameLabel}:
          <span class="detail-content">[[item.id.container_name]]</span>
        </div>
      </cr-expand-button>
      <div class="separator"></div>
      <cr-icon-button id="showContainerMenu[[index]]"
          class="icon-more-vert"
          title="$i18n{moreActions}"
          data-container-id="[[item.id]]"
          on-click="onContainerMenuClick_">
      </cr-icon-button>
      </div>
      <iron-collapse
          id="collapse-[[item.id.vm_name]]-[[item.id.container_name]]"
          opened="[[item.detailsExpanded]]">
        <div class="container-details-list"
            id="details-[[item.id.vm_name]]-[[item.id.container_name]]">
          <div class="list-item">
            <div class="detail-heading" aria-hidden="true">
              $i18n{crostiniExtraContainersAppBadgeColor}
            </div>
            <input type="color"
                data-container-id="[[item.id]]"
                value="[[item.badge_color]]"
                on-change="onContainerColorChange_">
          </div>
          <div class="list-item">
            <div class="detail-heading" aria-hidden="true">
              $i18n{crostiniExtraContainersShareMicrophone}
            </div>
            <cr-toggle
                id="microphone-[[item.id.vm_name]]-[[item.id.container_name]]"
                data-container-id="[[item.id]]"
                checked="[[isMicrophoneShared_(item.id)]]"
                on-change="onMicrophoneSharingChanged_">
            </cr-toggle>
          </div>
          <div class="list-item"
              hidden="[[!showIp_(item)]]"
              id="ip-[[item.id.vm_name]]-[[item.id.container_name]]">
            <div class="detail-heading" aria-hidden="true">
              $i18n{crostiniExtraContainersContainerIpLabel}
            </div>
            <div class="vm-column">
              [[item.ipv4]]
            </div>
          </div>
        </div>
      </iron-collapse>
    </template>
  </div>
</template>

<template is="dom-if" if="[[showCreateContainerDialog_]]" restamp>
  <settings-crostini-create-container-dialog
      on-close="onCreateContainerDialogClose_"
      all-containers="[[allContainers_]]">
  </settings-crostini-create-container-dialog>
</template>
<cr-lazy-render id="containerMenu">
  <template>
    <cr-action-menu class="complex" role-description="$i18n{menu}">
      <button id="stopContainerButton"
          class="dropdown-item"
          role="menuitem"
          disabled="[[shouldDisableStopContainer_(lastMenuContainerInfo_)]]"
          on-click="onStopContainerClick_">
        $i18n{crostiniExtraContainersStop}
      </button>
      <button id="deleteContainerButton"
          class="dropdown-item"
          role="menuitem"
          disabled="[[shouldDisableDeleteContainer_(lastMenuContainerInfo_)]]"
          on-click="onDeleteContainerClick_">
        $i18n{crostiniExtraContainersDelete}
      </button>
      <button id="exportContainerButton"
          class="dropdown-item"
          role="menuitem"
          on-click="onExportContainerClick_"
          disabled="[[!enableButtons_]]">
        $i18n{crostiniExport}
      </button>
      <button id="importContainerButton"
          class="dropdown-item"
          role="menuitem"
          on-click="onImportContainerClick_"
          disabled="[[!enableButtons_]]">
        $i18n{crostiniImport}
      </button>
    </cr-action-menu>
  </template>
</cr-lazy-render>

<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'crostini-extra-containers' is the settings extras containers subpage for
 * Crostini.
 */
const ExtraContainersElementBase = WebUiListenerMixin(PolymerElement);
class ExtraContainersElement extends ExtraContainersElementBase {
    static get is() {
        return 'settings-crostini-extra-containers';
    }
    static get template() {
        return getTemplate$3k();
    }
    static get properties() {
        return {
            prefs: {
                type: Object,
                notify: true,
            },
            showCreateContainerDialog_: {
                type: Boolean,
                value: false,
            },
            allContainers_: {
                type: Array,
                notify: true,
                value() {
                    return [];
                },
            },
            allSharedVmDevices_: {
                type: Array,
                value() {
                    return [];
                },
            },
            allVms_: {
                type: Array,
                value() {
                    return [];
                },
            },
            lastMenuContainerInfo_: {
                type: Object,
            },
            /**
             * Whether the export import buttons should be enabled. Initially false
             * until status has been confirmed.
             */
            enableButtons_: {
                type: Boolean,
                computed: 'isEnabledButtons_(installerShowing_, exportImportInProgress_)',
            },
            installerShowing_: {
                type: Boolean,
                value: false,
            },
            // TODO(b/231890242): Disable delete and stop buttons when a container is
            // being exported or imported.
            exportImportInProgress_: {
                type: Boolean,
                value: false,
            },
        };
    }
    constructor() {
        super();
        /**
         * Tracks the last container that was selected for delete.
         */
        this.lastMenuContainerInfo_ = null;
        this.browserProxy_ = CrostiniBrowserProxyImpl.getInstance();
    }
    ready() {
        super.ready();
        this.addWebUiListener('crostini-container-info', (infos) => this.onContainerInfo_(infos));
        this.addWebUiListener('crostini-shared-vmdevices', (sharedVmDevices) => this.onSharedVmDevices_(sharedVmDevices));
        this.browserProxy_.requestContainerInfo();
        this.browserProxy_.requestSharedVmDevices();
    }
    connectedCallback() {
        super.connectedCallback();
        this.addWebUiListener('crostini-export-import-operation-status-changed', (inProgress) => {
            this.exportImportInProgress_ = inProgress;
        });
        this.addWebUiListener('crostini-installer-status-changed', (installerShowing) => {
            this.installerShowing_ = installerShowing;
        });
        this.browserProxy_.requestCrostiniExportImportOperationStatus();
        this.browserProxy_.requestCrostiniInstallerStatus();
    }
    setMicrophoneToggle_(id, checked) {
        const crToggle = this.shadowRoot.querySelector(`#microphone-${id.vm_name}-${id.container_name}`);
        if (!crToggle) {
            // The toggles may not yet have been added to the DOM.
            return;
        }
        if (crToggle.checked !== checked) {
            crToggle.set('checked', checked);
        }
    }
    onSharedVmDevices_(sharedVmDevices) {
        this.set('allSharedVmDevices_', sharedVmDevices);
        for (const sharing of sharedVmDevices) {
            this.setMicrophoneToggle_(sharing.id, sharing.vmDevices[VM_DEVICE_MICROPHONE]);
        }
    }
    async updateSharedVmDevices_(id) {
        let idx = this.allSharedVmDevices_.findIndex(sharing => equalContainerId(sharing.id, id));
        if (idx < 0) {
            idx = this.allSharedVmDevices_.push({ id: id, vmDevices: { [VM_DEVICE_MICROPHONE]: false } }) -
                1;
        }
        const result = await this.browserProxy_.isVmDeviceShared(id, VM_DEVICE_MICROPHONE);
        this.allSharedVmDevices_[idx].vmDevices[VM_DEVICE_MICROPHONE] = result;
        this.setMicrophoneToggle_(id, result);
    }
    onContainerInfo_(containerInfos) {
        const vmNames = new Set();
        const crostiniContainerInfos = containerInfos;
        for (const info of crostiniContainerInfos) {
            vmNames.add(info.id.vm_name);
            const oldContainerInfo = this.allContainers_.find(container => equalContainerId(container.id, info.id));
            info.detailsExpanded = (oldContainerInfo !== undefined) ?
                oldContainerInfo.detailsExpanded :
                false;
        }
        this.set('allVms_', Array.from(vmNames.values()));
        this.set('allContainers_', crostiniContainerInfos);
    }
    onCreateClick_() {
        this.showCreateContainerDialog_ = true;
    }
    onCreateContainerDialogClose_() {
        this.showCreateContainerDialog_ = false;
    }
    onContainerMenuClick_(event) {
        const target = event.currentTarget;
        const containerId = target['dataContainerId'];
        this.lastMenuContainerInfo_ =
            this.allContainers_.find(e => e.id.vm_name === containerId.vm_name &&
                e.id.container_name === containerId.container_name) ||
                null;
        this.getContainerMenu_().showAt(target);
    }
    onDeleteContainerClick_() {
        if (this.lastMenuContainerInfo_) {
            this.browserProxy_.deleteContainer(this.lastMenuContainerInfo_.id);
        }
        this.closeContainerMenu_();
    }
    onStopContainerClick_() {
        if (this.lastMenuContainerInfo_) {
            this.browserProxy_.stopContainer(this.lastMenuContainerInfo_.id);
        }
        this.closeContainerMenu_();
    }
    onExportContainerClick_() {
        if (this.lastMenuContainerInfo_) {
            this.browserProxy_.exportCrostiniContainer(this.lastMenuContainerInfo_.id);
        }
        this.closeContainerMenu_();
    }
    onImportContainerClick_() {
        if (this.lastMenuContainerInfo_) {
            this.browserProxy_.importCrostiniContainer(this.lastMenuContainerInfo_.id);
        }
        this.closeContainerMenu_();
    }
    onContainerColorChange_(event) {
        const target = event.currentTarget;
        const containerId = target['dataContainerId'];
        const hexColor = target.value;
        this.browserProxy_.setContainerBadgeColor(containerId, hexColorToSkColor(hexColor));
    }
    shouldDisableDeleteContainer_(info) {
        return info && info.id.vm_name === DEFAULT_CROSTINI_VM &&
            info.id.container_name === DEFAULT_CROSTINI_CONTAINER;
    }
    shouldDisableStopContainer_(info) {
        return !info || !info.ipv4;
    }
    getContainerMenu_() {
        return this.$.containerMenu.get();
    }
    closeContainerMenu_() {
        const menu = this.getContainerMenu_();
        assert(menu.open && this.lastMenuContainerInfo_);
        menu.close();
        this.lastMenuContainerInfo_ = null;
    }
    isEnabledButtons_(installerShowing, exportImportInProgress) {
        return !(installerShowing || exportImportInProgress);
    }
    byNameWithDefault_(name1, name2, defaultName) {
        if (name1 === name2) {
            return 0;
        }
        // defaultName sorts first.
        if (name1 === defaultName) {
            return -1;
        }
        if (name2 === defaultName) {
            return 1;
        }
        return name1 < name2 ? -1 : 1;
    }
    byVmName_(name1, name2) {
        return this.byNameWithDefault_(name1, name2, DEFAULT_CROSTINI_VM);
    }
    byGuestId_(id1, id2) {
        const result = this.byVmName_(id1.vm_name, id2.vm_name);
        if (result !== 0) {
            return result;
        }
        return this.byNameWithDefault_(id1.container_name, id2.container_name, DEFAULT_CROSTINI_CONTAINER);
    }
    infoHasVmName_(vmName) {
        return info => vmName === info.id.vm_name;
    }
    isMicrophoneShared_(id) {
        const deviceSharing = this.allSharedVmDevices_.find((sharing) => equalContainerId(sharing.id, id));
        if (!deviceSharing) {
            return false;
        }
        return deviceSharing.vmDevices[VM_DEVICE_MICROPHONE];
    }
    async onMicrophoneSharingChanged_(event) {
        const target = event.currentTarget;
        const id = target['dataContainerId'];
        const shared = target.checked;
        await this.browserProxy_.setVmDeviceShared(id, VM_DEVICE_MICROPHONE, shared);
        await this.updateSharedVmDevices_(id);
    }
    showIp_(info) {
        return !!info.ipv4 && info.ipv4.length > 0;
    }
}
customElements.define(ExtraContainersElement.is, ExtraContainersElement);

function getTemplate$3j() {
    return html `<!--_html_template_start_--><style include="settings-shared md-select">#portNumberInput{padding-inline-end:20px;width:376px}#portLabelInput{padding-top:20px;width:472px}#selectProtocol{max-width:96px}.custom-body{padding-bottom:20px}.custom-button-container{float:right}.input-container{display:flex;flex-direction:row;justify-content:space-between}.placeholder-label{visibility:hidden}</style>
<cr-dialog id="dialog" close-text="$i18n{close}">
  <div slot="title">$i18n{crostiniPortForwardingAddPortDialogTitle}</div>
  <div slot="body">
    <div class="input-container">
      <cr-input id="portNumberInput"
          label="$i18n{crostiniPortForwardingAddPortDialogPortNumberLabel}"
          aria-disabled="false"
          error-message="[[portState_]]"
          type="number"
          min="1024"
          max="65535"
          on-blur="onBlur_">
      </cr-input>
      <div>
        <div id="label" class="cr-form-field-label placeholder-label"
            aria-hidden="true">
            ""
        </div>
        <select id="selectProtocol"
            class="md-select"
            value="$i18n{crostiniPortForwardingTCP}"
            on-change="onSelectProtocol_">
          <option value="$i18n{crostiniPortForwardingTCP}">
            $i18n{crostiniPortForwardingTCP}
          </option>
          <option value="$i18n{crostiniPortForwardingUDP}">
            $i18n{crostiniPortForwardingUDP}
          </option>
        </select>
      </div>
    </div>
    <template is="dom-if" if="[[showContainerSelect_(allContainers)]]" restamp>
      <settings-guest-os-container-select
          containers="[[allContainers]]"
          selected-container-id="{{containerId_}}"
          default-vm-name="[[defaultVmName_]]">
      </settings-guest-os-container-select>
    </template>
    <div slot="body">
      <cr-input id="portLabelInput"
          label="$i18n{crostiniPortForwardingAddPortDialogLabelLabel}"
          aria-disabled="false"
          maxlength="50">
      </cr-input>
    </div>
  </div>
  <div slot="body" class="custom-body">
    <div slot="button-container" class="custom-button-container">
      <cr-button id="cancel" class="cancel-button"
          on-click="onCancelClick_">$i18n{cancel}</cr-button>
      <cr-button id="continue" class="action-button"
          on-click="onAddClick_">
          $i18n{add}
      </cr-button>
    </div>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-crostini-add-port-dialog' is a component enabling a
 * user to start forwarding a different port by filling in the appropriate
 * fields and clicking add.
 */
class CrostiniPortForwardingAddPortDialog extends PolymerElement {
    static get is() {
        return 'settings-crostini-add-port-dialog';
    }
    static get template() {
        return getTemplate$3j();
    }
    static get properties() {
        return {
            inputPortNumber_: {
                type: Number,
                value: null,
            },
            inputPortLabel_: {
                type: String,
                value: '',
            },
            inputProtocolIndex_: {
                type: Number,
                value: 0, // Default: TCP
            },
            portState_: {
                type: String,
                value: PortState.VALID,
            },
            containerId_: {
                type: Object,
                value() {
                    return DEFAULT_CROSTINI_GUEST_ID;
                },
            },
            defaultVmName_: {
                type: String,
                value: DEFAULT_CROSTINI_VM,
            },
            /**
             * List of ports that are already stored in the settings.
             */
            allPorts: {
                type: Array,
                value() {
                    return [];
                },
            },
            /**
             * List of containers that are already stored in the settings.
             */
            allContainers: {
                type: Array,
                value: [],
            },
        };
    }
    static get observers() {
        return [
            'onPortStateChanged_(portState_)',
        ];
    }
    constructor() {
        super();
        this.browserProxy_ = CrostiniBrowserProxyImpl.getInstance();
    }
    connectedCallback() {
        super.connectedCallback();
        this.$.dialog.showModal();
        microTask.run(() => {
            this.$.portNumberInput.focus();
        });
    }
    resetInputs_() {
        this.inputPortLabel_ = '';
        this.inputPortNumber_ = null;
        this.inputProtocolIndex_ = 0;
        this.portState_ = PortState.VALID;
    }
    get portNumberInput() {
        return this.$.portNumberInput;
    }
    get portLabelInput() {
        return this.$.portLabelInput;
    }
    /**
     * @param input The port input to verify.
     * @return if the input string is a valid port number.
     */
    isValidPortNumber(input) {
        const numberRegex = /^[0-9]+$/;
        return Boolean(input.match(numberRegex)) &&
            Number(input) >= MIN_VALID_PORT_NUMBER &&
            Number(input) <= MAX_VALID_PORT_NUMBER;
    }
    computePortState_() {
        if (!this.isValidPortNumber(this.$.portNumberInput.value)) {
            return PortState.INVALID;
        }
        if (this.allPorts.find(portSetting => portSetting.port_number ===
            Number(this.$.portNumberInput.value) &&
            portSetting.protocol_type === this.inputProtocolIndex_)) {
            return PortState.DUPLICATE;
        }
        return PortState.VALID;
    }
    onSelectProtocol_(e) {
        this.inputProtocolIndex_ = cast(e.target, HTMLSelectElement).selectedIndex;
        this.portState_ = this.computePortState_();
    }
    onCancelClick_() {
        this.$.dialog.close();
        this.resetInputs_();
    }
    onAddClick_() {
        this.portState_ = this.computePortState_();
        if (this.portState_ !== PortState.VALID) {
            return;
        }
        const portNumber = +this.$.portNumberInput.value;
        const portLabel = this.$.portLabelInput.value;
        this.browserProxy_
            .addCrostiniPortForward(this.containerId_, portNumber, this.inputProtocolIndex_, portLabel)
            .then((_result) => {
            // TODO(crbug.com/41391957): Error handling for result
            this.$.dialog.close();
        });
        this.resetInputs_();
    }
    onBlur_() {
        this.portState_ = this.computePortState_();
    }
    onPortStateChanged_() {
        if (this.portState_ === PortState.VALID) {
            this.$.portNumberInput.invalid = false;
            this.$.continue.disabled = false;
            return;
        }
        this.$.portNumberInput.invalid = true;
        this.$.continue.disabled = true;
    }
    showContainerSelect_(allContainers) {
        return allContainers.length > 1;
    }
}
customElements.define(CrostiniPortForwardingAddPortDialog.is, CrostiniPortForwardingAddPortDialog);

function getTemplate$3i() {
    return html `<!--_html_template_start_--><style include="settings-shared">:host{--cr-toggle-margin-inline-start:16px;--cr-toggle-width:34px}cr-toggle{margin-inline-start:var(--cr-toggle-margin-inline-start);width:var(--cr-toggle-width)}.column-title{color:var(--cr-secondary-text-color)}.label-column{align-items:center;display:flex;flex:1;flex-grow:3}.label-text{flex-grow:3;word-break:break-all}.no-ports-text{padding-inline-start:24px}.interface-ip{padding-inline-start:24px}#addPort{padding-top:10px}#errorIcon{display:inline-block;margin-inline-end:8px}#protocolText{color:var(--cros-text-color-disabled);margin-inline-start:8px}#portForwardingListContainerId{border-top:var(--cr-separator-line)}#portForwardingDescription{flex-grow:3}
</style>
<div id="addPort" class="settings-box first">
  <div
      id="portForwardingDescription">
    $i18n{crostiniPortForwardingDescription}
  </div>
  <cr-button on-click="onAddPortClick_"
      aria-label="$i18n{crostiniPortForwardingAddPortButtonDescription}"
      aria-describedby="i18n{portForwardingDescription}">
    $i18n{crostiniPortForwardingAddPortButton}
  </cr-button>
  <template is="dom-if" if="[[allPorts_.length]]" restamp>
    <cr-icon-button id="showRemoveAllPortsMenu"
      class="icon-more-vert"
      title="$i18n{moreActions}"
      on-click="onShowRemoveAllPortsMenuClick_"
      aria-label="$i18n{moreActions}">
    </cr-icon-button>
  </template>
</div>
<template is="dom-if" if="[[activeInterface_]]" restamp>
    <div id="interface-ip" class="settings-box continuation">
        [[activeInterface_]]: [[activeIpAddress_]]
    </div>
</template>
<template is="dom-if" if="[[!allPorts_.length]]" restamp>
  <div id="no-ports-text"
      class="settings-box continuation">
    $i18n{crostiniPortForwardingNoPorts}
  </div>
</template>
<template is="dom-if" if="[[allPorts_.length]]" restamp>
  <template is="dom-repeat" items="[[allContainers_]]"
      as="containerInfo" index-as="cidx" mutable-data>
    <template is="dom-if"
        if="[[hasContainerPorts_(allPorts_, containerInfo.id)]]" restamp>
      <h2 id="portForwardingListContainerId"
          hidden="[[!showContainerId_(allPorts_, containerInfo.id)]]"
          class="settings-box first">
          [[containerLabel_(containerInfo.id)]]
      </h2>
      <div class="list-frame vertical-list" id="portForwardingListCard">
        <div class="list-item">
          <div id="portForwardingListPortNumber"
              class="start column-title"
              aria-hidden="true">
            $i18n{crostiniPortForwardingListPortNumber}
          </div>
          <div id="portForwardingListPortLabel"
              class="column-title label-column"
              aria-hidden="true">
            $i18n{crostiniPortForwardingListLabel}
          </div>
        </div>
        <template is="dom-repeat" items="[[allPorts_]]"
            filter="[[byContainerId_(containerInfo.id)]]" mutable-data>
          <div class="list-item">
            <div id="crostiniPort[[cidx]]-[[index]]"
                class="start"
                aria-hidden="true">
              [[item.port_number]]
              <span id="protocolText">
                <template is="dom-if" if="[[!item.protocol_type]]" restamp>
                  $i18n{crostiniPortForwardingTCP}
                </template>
                <template is="dom-if" if="[[item.protocol_type]]" restamp>
                  $i18n{crostiniPortForwardingUDP}
                </template>
              </span>
            </div>
            <div class="label-column" aria-hidden="true">
              <div id="crostiniPortLabel[[cidx]]-[[index]]"
                  class="label-text"
                  aria-hidden="true">
                [[item.label]]
              </div>
              <cr-toggle
                  id="toggleActivationButton[[cidx]]-[[index]]"
                  checked="[[item.is_active]]"
                  data-port-number$="[[item.port_number]]"
                  data-protocol-type$="[[item.protocol_type]]"
                  data-container-id="[[item.container_id]]"
                  on-change="onPortActivationChange_"
                  aria-label="$i18n{crostiniPortForwardingToggleAriaLabel}"
                  aria-describedby$="crostiniPort[[cidx]]-[[index]]
                      crostiniPortLabel[[cidx]]-[[index]]"
                  disabled="[[!containerInfo.ipv4]]">
              </cr-toggle>
              <cr-icon-button
                  id="removeSinglePortButton[[cidx]]-[[index]]"
                  class="icon-clear"
                  title="$i18n{moreActions}"
                  on-click="onRemoveSinglePortClick_"
                  data-port-number$="[[item.port_number]]"
                  data-protocol-type$="[[item.protocol_type]]"
                  data-container-id="[[item.container_id]]"
                  aria-label=
                      "$i18n{crostiniPortForwardingShowMoreActionsAriaLabel}"
                  aria-describedby$="crostiniPort[[cidx]]-[[index]]
                      crostiniPortLabel[[cidx]]-[[index]]">
              </cr-icon-button>
            </div>
          </div>
        </template>
      </div>
    </template>
  </template>
</template>
<template is="dom-if" if="[[showAddPortDialog_]]" restamp>
  <settings-crostini-add-port-dialog
      on-close="onAddPortDialogClose_"
      all-ports="[[allPorts_]]"
      all-containers="[[allContainers_]]">
  </settings-crostini-add-port-dialog>
</template>
<cr-lazy-render id="removeAllPortsMenu">
  <template>
    <cr-action-menu class="complex" role-description="$i18n{menu}">
      <button id="removeAllPortsButton"
          class="dropdown-item"
          role="menuitem"
          on-click="onRemoveAllPortsClick_"
          aria-label="$i18n{crostiniPortForwardingRemoveAllPortsAriaLabel}">
        $i18n{crostiniPortForwardingRemoveAllPorts}
      </button>
    </cr-action-menu>
  </template>
</cr-lazy-render>
<cr-toast id="errorToast" duration="3000">
  <div class="error-message" id="errorMessage">
    <iron-icon id="errorIcon" icon="cr:error-outline"></iron-icon>
    $i18n{crostiniPortForwardingActivatePortError}
  </div>
</cr-toast>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'crostini-port-forwarding' is the settings port forwarding subpage for
 * Crostini.
 */
const CrostiniPortForwardingBase = PrefsMixin(WebUiListenerMixin(PolymerElement));
class CrostiniPortForwardingElement extends CrostiniPortForwardingBase {
    static get is() {
        return 'settings-crostini-port-forwarding';
    }
    static get template() {
        return getTemplate$3i();
    }
    static get properties() {
        return {
            showAddPortDialog_: {
                type: Boolean,
                value: false,
            },
            /**
             * The forwarded ports for display in the UI.
             */
            allPorts_: {
                type: Array,
                notify: true,
                value() {
                    return [];
                },
            },
            /**
             * The known ContainerIds for display in the UI.
             */
            allContainers_: {
                type: Array,
                notify: true,
                value() {
                    return [];
                },
            },
            /**
             * Current active network interface to be displayed.
             */
            activeInterface_: {
                type: String,
                value: '',
            },
            /**
             * Current active network IP to be displayed.
             */
            activeIpAddress_: {
                type: String,
                value: '',
            },
        };
    }
    static get observers() {
        return [
            'onCrostiniPortsChanged_(prefs.crostini.port_forwarding.ports.value)',
        ];
    }
    constructor() {
        super();
        /**
         * List of ports are currently being forwarded.
         */
        this.activePorts_ = [];
        /**
         * Tracks the last port that was selected for removal.
         */
        this.lastMenuOpenedPort_ = null;
        this.browserProxy_ = CrostiniBrowserProxyImpl.getInstance();
    }
    connectedCallback() {
        super.connectedCallback();
        this.addWebUiListener('crostini-port-forwarder-active-ports-changed', (ports) => this.onCrostiniPortsActiveStateChanged_(ports));
        this.addWebUiListener('crostini-container-info', (infos) => this.onContainerInfo_(infos));
        this.addWebUiListener('crostini-active-network-info', (iface, ipAddress) => this.onCrostiniActiveNetworkInfo_([iface, ipAddress]));
        this.browserProxy_.getCrostiniActivePorts().then((ports) => this.onCrostiniPortsActiveStateChanged_(ports));
        this.browserProxy_.getCrostiniActiveNetworkInfo().then((networkInfo) => this.onCrostiniActiveNetworkInfo_(networkInfo));
        this.browserProxy_.requestContainerInfo();
    }
    onCrostiniActiveNetworkInfo_(networkInfo) {
        this.set('activeInterface_', networkInfo[0]);
        this.set('activeIpAddress_', networkInfo[1]);
    }
    onContainerInfo_(containerInfos) {
        this.set('allContainers_', containerInfos);
    }
    onCrostiniPortsChanged_(ports) {
        this.splice('allPorts_', 0, this.allPorts_.length);
        for (const port of ports) {
            port.is_active = this.activePorts_.some(activePort => activePort.port_number === port.port_number &&
                activePort.protocol_type === port.protocol_type);
            port.container_id = port.container_id || {
                vm_name: port['vm_name'] || DEFAULT_CROSTINI_VM,
                container_name: port['container_name'] || DEFAULT_CROSTINI_CONTAINER,
                vm_type: DEFAULT_CROSTINI_VM_TYPE,
            };
            this.push('allPorts_', port);
        }
        this.notifyPath('allContainers_');
    }
    onCrostiniPortsActiveStateChanged_(ports) {
        this.activePorts_ = ports;
        for (let i = 0; i < this.allPorts_.length; i++) {
            this.set(`allPorts_.${i}.${'is_active'}`, this.activePorts_.some(activePort => activePort.port_number === this.allPorts_[i].port_number &&
                activePort.protocol_type ===
                    this.allPorts_[i].protocol_type));
        }
    }
    onAddPortClick_() {
        this.showAddPortDialog_ = true;
    }
    onAddPortDialogClose_() {
        this.showAddPortDialog_ = false;
    }
    onShowRemoveAllPortsMenuClick_(event) {
        const menu = this.$.removeAllPortsMenu.get();
        menu.showAt(event.target);
    }
    onRemoveSinglePortClick_(event) {
        const target = event.currentTarget;
        const containerId = target['dataContainerId'];
        const portNumber = Number(target.dataset['portNumber']);
        const protocolType = Number(target.dataset['protocolType']);
        this.browserProxy_
            .removeCrostiniPortForward(containerId, portNumber, protocolType)
            .then((_result) => {
            // TODO(crbug.com/41391957): Error handling for result
        });
    }
    onRemoveAllPortsClick_() {
        const menu = this.$.removeAllPortsMenu.get();
        assert(menu.open);
        for (const container of this.allContainers_) {
            this.browserProxy_.removeAllCrostiniPortForwards(container.id);
        }
        menu.close();
    }
    onPortActivationChange_(event) {
        const target = event.currentTarget;
        const containerId = target['dataContainerId'];
        const portNumber = Number(target.dataset['portNumber']);
        const protocolType = Number(target.dataset['protocolType']);
        if (target.checked) {
            target.checked = false;
            this.browserProxy_
                .activateCrostiniPortForward(containerId, portNumber, protocolType)
                .then(result => {
                if (!result) {
                    this.$.errorToast.show();
                }
                // TODO(crbug.com/41391957): Elaborate on error handling for result
            });
        }
        else {
            this.browserProxy_
                .deactivateCrostiniPortForward(containerId, portNumber, protocolType)
                .then((_result) => {
                // TODO(crbug.com/41391957): Error handling for result
            });
        }
    }
    showContainerId_(allPorts, id) {
        return allPorts.some(port => equalContainerId(port.container_id, id)) &&
            allPorts.some(port => !equalContainerId(port.container_id, DEFAULT_CROSTINI_GUEST_ID));
    }
    containerLabel_(id) {
        return containerLabel(id, DEFAULT_CROSTINI_VM);
    }
    hasContainerPorts_(allPorts, id) {
        return allPorts.some(port => equalContainerId(port.container_id, id));
    }
    byContainerId_(id) {
        return port => equalContainerId(port.container_id, id);
    }
}
customElements.define(CrostiniPortForwardingElement.is, CrostiniPortForwardingElement);

function getTemplate$3h() {
    return html `<!--_html_template_start_--><style include="settings-shared md-select">#selectDevice{width:100%}.custom-body{padding-bottom:20px}.custom-button-container{float:right}.input-container{padding-bottom:10px}</style>
<cr-dialog id="dialog" close-text="$i18n{close}">
  <div slot="title">$i18n{guestOsSharedUsbDevicesAddTitle}</div>
  <div slot="body">
    <div class="input-container">
      <label class="cr-form-field-label">Device</label>
      <select id="selectDevice" class="md-select"
          disabled="[[!sharedUsbDevices.length]]">
        <template is="dom-if" if="[[!sharedUsbDevices.length]]" restamp>
          <option>$i18n{guestOsSharedUsbDevicesListEmptyMessage}</option>
        </template>
        <template is="dom-repeat" items="[[sharedUsbDevices]]">
          <option value="[[item.device.guid]]">
            [[item.device.label]]
            [[[item.device.vendorId]]:[[item.device.productId]]]
          </option>
        </template>
      </select>
    </div>
    <template is="dom-if" if="[[showContainerSelect_(allContainers)]]" restamp>
      <settings-guest-os-container-select
          containers="[[allContainers]]"
          selected-container-id="{{guestId_}}"
          default-vm-name="[[defaultGuestId.vm_name]]">
      </settings-guest-os-container-select>
    </template>
  </div>
  <div slot="body" class="custom-body">
    <div slot="button-container" class="custom-button-container">
      <cr-button id="cancel" class="cancel-button" on-click="onCancelClick_">
        $i18n{cancel}
      </cr-button>
      <cr-button id="continue" class="action-button"
          disabled="[[!sharedUsbDevices.length]]" on-click="onAddClick_">
        $i18n{add}
      </cr-button>
    </div>
  </div>
</cr-dialog>
<template is="dom-if" if="[[reassignDevice_]]" restamp>
  <cr-dialog id="reassignDialog" close-text="$i18n{close}"
      on-cancel="onReassignCancel_" show-on-attach>
    <div slot="title">
      $i18n{guestOsSharedUsbDevicesInUse}
    </div>
    <div slot="body">
      [[getReassignDialogText_(reassignDevice_)]]
    </div>
    <div slot="button-container">
      <cr-button id="cancel" class="cancel-button" on-click="onReassignCancel_">
        $i18n{cancel}
      </cr-button>
      <cr-button id="continue" class="action-button"
          on-click="onReassignContinueClick_">
        $i18n{continue}
      </cr-button>
    </div>
  </cr-dialog>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-guest-os-shared-usb-devices-add-dialog' is a
 * component enabling a user to add a USB device by filling in the appropriate
 * fields and clicking add.
 */
const GuestOsSharedUsbDevicesAddDialogElementBase = I18nMixin(PolymerElement);
class GuestOsSharedUsbDevicesAddDialog extends GuestOsSharedUsbDevicesAddDialogElementBase {
    static get is() {
        return 'settings-guest-os-shared-usb-devices-add-dialog';
    }
    static get template() {
        return getTemplate$3h();
    }
    static get properties() {
        return {
            /**
             * The USB Devices available for connection to a VM.
             */
            sharedUsbDevices: Array,
            defaultGuestId: {
                type: Object,
                value() {
                    return {
                        vm_name: '',
                        container_name: '',
                    };
                },
            },
            guestId_: Object,
            /**
             * List of containers that are already stored in the settings.
             */
            allContainers: {
                type: Array,
                value: [],
            },
            /**
             * The USB device which was toggled to be shared, but is already shared
             * with another VM. When non-null the reassign dialog is shown.
             */
            reassignDevice_: {
                type: Object,
                value: null,
            },
        };
    }
    constructor() {
        super();
        this.browserProxy_ = GuestOsBrowserProxyImpl.getInstance();
    }
    connectedCallback() {
        super.connectedCallback();
        this.$.dialog.showModal();
        microTask.run(() => {
            this.$.selectDevice.focus();
        });
    }
    onCancelClick_() {
        this.$.dialog.close();
    }
    onAddClick_() {
        const sharedUsbDevice = this.sharedUsbDevices.find(({ device }) => device.guid === this.$.selectDevice.value);
        const { device } = castExists(sharedUsbDevice);
        if (device.promptBeforeSharing) {
            this.reassignDevice_ = device;
            return;
        }
        const guestId = this.guestId_ || this.defaultGuestId;
        this.browserProxy_.setGuestOsUsbDeviceShared(guestId.vm_name, guestId.container_name, device.guid, true);
        this.$.dialog.close();
    }
    onReassignCancel_() {
        this.reassignDevice_ = null;
    }
    onReassignContinueClick_() {
        assertExists(this.reassignDevice_);
        const guestId = this.guestId_ || this.defaultGuestId;
        this.browserProxy_.setGuestOsUsbDeviceShared(guestId.vm_name, guestId.container_name, this.reassignDevice_.guid, true);
        this.reassignDevice_ = null;
        this.$.dialog.close();
    }
    /**
     * @param device USB device.
     * @return Confirmation prompt text.
     */
    getReassignDialogText_(device) {
        return this.i18n('guestOsSharedUsbDevicesReassign', device.label);
    }
    showContainerSelect_(allContainers) {
        return allContainers.length > 1;
    }
}
customElements.define(GuestOsSharedUsbDevicesAddDialog.is, GuestOsSharedUsbDevicesAddDialog);

function getTemplate$3g() {
    return html `<!--_html_template_start_--><style include="settings-shared md-select">.toggle-container{display:flex;flex-direction:row;flex-wrap:nowrap;justify-content:space-between}#selectDevice{width:100%}</style>
<settings-toggle-button
    id="guestShowUsbNotificationToggle"
    pref="{{prefs.guest_os.usb_notification_enabled}}"
    no-set-pref
    label="$i18n{guestOsSharedUsbDevicesNotificationsLabel}"
    on-settings-boolean-control-change="onGuestUsbNotificationChange_"
    deep-link-focus-id$="[[Setting.kGuestUsbNotification]]">
</settings-toggle-button>
<settings-toggle-button
    id="guestUsbPersistentPassthroughToggle"
    pref="{{prefs.guest_os.usb_persistent_passthrough_enabled}}"
    no-set-pref
    label="$i18n{guestOsSharedUsbPersistentPassthroughLabel}"
    on-settings-boolean-control-change="onGuestUsbPersistentPassthroughChange_"
    deep-link-focus-id$="[[Setting.kGuestUsbPersistentPassthrough]]">
</settings-toggle-button>
<div class="settings-box first">
  <div class="settings-box-text">
    [[getDescriptionText_()]]
    <div class="secondary" id="secondaryText">
      $i18n{guestOsSharedUsbDevicesExtraDescription}
    </div>
  </div>
</div>
<template is="dom-if" if="[[!hasContainers]]" restamp>
  <div class="settings-box secondary continuation"
      hidden="[[sharedUsbDevices_.length]]">
     $i18n{guestOsSharedUsbDevicesListEmptyMessage}
  </div>
  <template is="dom-if" if="[[sharedUsbDevices_.length]]" restamp>
    <div class="list-frame vertical-list">
      <template is="dom-repeat" items="[[sharedUsbDevices_]]">
        <div class="list-item toggle-container">
          <div class="label">[[item.device.label]]</div>
          <cr-toggle class="toggle" checked="[[item.shared]]"
              on-change="onDeviceSharedChange_"
              aria-label$="[[item.device.label]]">
          </cr-toggle>
        </div>
      </template>
    </div>
  </template>
</template>

<template is="dom-if" if="[[hasContainers]]" restamp>
  <div id="addUsb" class="settings-box first">
    <div id="usbTableTitle" class="start"
        aria-hidden="true">
      $i18n{guestOsSharedUsbDevicesTableTitle}
    </div>
    <cr-button id="addUsbBtn" on-click="onAddUsbClick_"
        aria-label="$i18n{guestOsSharedUsbDevicesAddTitle}"
        aria-describedby="addUsb">
      $i18n{add}
    </cr-button>
  </div>
  <template is="dom-if" if="[[sharedUsbDevices_.length]]" restamp>
    <template is="dom-repeat" items="[[allContainers_]]"
        as="containerInfo" index-as="cidx" mutable-data>
      <template is="dom-if"
          if="[[showGuestId_(sharedUsbDevices_, containerInfo.id)]]" restamp>
        <h2 id="usbListContainerId[[cidx]]"
            hidden="[[!showGuestId_(sharedUsbDevices_, containerInfo.id)]]"
            class="settings-box usb-list-guest-id">
            [[guestLabel_(containerInfo.id)]]
        </h2>
        <div class="list-frame vertical-list usb-list-card"
            id="usbListCard[[cidx]]">
          <template is="dom-repeat" items="[[sharedUsbDevices_]]"
              filter="[[byGuestId_(containerInfo.id)]]" mutable-data>
            <div class="list-item">
              <div id="usbLabel[[cidx]]-[[index]]"
                  class="start usb-list-card-label" aria-hidden="true">
                [[item.device.label]]
              </div>
              <cr-icon-button id="removeUsb[[cidx]]-[[index]]"
                  class="icon-clear usb-list-card-remove" title="$i18n{remove}"
                  on-click="onRemoveUsbClick_" data-guid$="[[item.device.guid]]"
                  aria-label="$i18n{remove}"
                  aria-describedby$="usbLabel[[cidx]]-[[index]]">
              </cr-icon-button>
            </div>
          </template>
        </div>
      </template>
    </template>
  </template>
  <template is="dom-if"
      if="[[!hasSharedDevices_(sharedUsbDevices_, allContainers_)]]" restamp>
    <div class="settings-box secondary">
      $i18n{guestOsSharedUsbDevicesNoneAttached}
    </div>
  </template>
</template>
<template is="dom-if" if="[[showAddUsbDialog_]]" restamp>
  <settings-guest-os-shared-usb-devices-add-dialog
      on-close="onAddUsbDialogClose_"
      shared-usb-devices="[[sharedUsbDevices_]]"
      all-containers="[[allContainers_]]"
      default-guest-id="[[defaultGuestId]]">
  </settings-guest-os-shared-usb-devices-add-dialog>
</template>
<template is="dom-if" if="[[reassignDevice_]]" restamp>
  <cr-dialog id="reassignDialog" close-text="$i18n{close}"
      on-cancel="onReassignCancel_" show-on-attach>
    <div slot="title">
      $i18n{guestOsSharedUsbDevicesInUse}
    </div>
    <div slot="body">
      [[getReassignDialogText_(reassignDevice_)]]
    </div>
    <div slot="button-container">
      <cr-button id="cancel" class="cancel-button"
          on-click="onReassignCancel_">
        $i18n{cancel}
      </cr-button>
      <cr-button id="continue" class="action-button"
          on-click="onReassignContinueClick_">
        $i18n{continue}
      </cr-button>
    </div>
  </cr-dialog>
</template>
<template is="dom-if" if="[[showGuestUsbNotificationDialog_]]" restamp>
  <settings-guest-os-confirmation-dialog
      id="guestShowUsbNotificationDialog"
      accept-button-text="$i18n{guestOsSharedUsbDevicesNotificationDialogAccept}"
      on-close="onGuestUsbNotificationDialogClose_">
    <div slot="body">
      [[getNotificationDialogText_()]]
    </div>
  </settings-guest-os-confirmation-dialog>
</template>
<template is="dom-if" if="[[showGuestUsbPersistentPassthroughDialog_]]" restamp>
  <settings-guest-os-confirmation-dialog
      id="guestShowUsbPersistentPassthroughDialog"
      accept-button-text="$i18n{guestOsSharedUsbDevicesNotificationDialogAccept}"
      on-close="onGuestUsbPersistentPassthroughDialogClose_">
    <div slot="body">
      [[getGuestUsbPersistentPassthroughDialogText_()]]
    </div>
  </settings-guest-os-confirmation-dialog>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'guest-os-shared-usb-devices' is the settings shared usb devices subpage for
 * guest OSes.
 */
const SettingsGuestOsSharedUsbDevicesElementBase = RouteObserverMixin(DeepLinkingMixin(I18nMixin(WebUiListenerMixin(PrefsMixin(PolymerElement)))));
class SettingsGuestOsSharedUsbDevicesElement extends SettingsGuestOsSharedUsbDevicesElementBase {
    static get is() {
        return 'settings-guest-os-shared-usb-devices';
    }
    static get template() {
        return getTemplate$3g();
    }
    static get properties() {
        return {
            showGuestUsbNotificationDialog_: {
                type: Boolean,
                value: false,
            },
            showGuestUsbPersistentPassthroughDialog_: {
                type: Boolean,
                value: false,
            },
            /**
             * The type of Guest OS to share with. Should be 'crostini' or 'pluginVm'.
             */
            guestOsType: {
                type: String,
                value: '',
            },
            /**
             * The USB Devices available for connection to a VM.
             */
            sharedUsbDevices_: {
                type: Array,
                value() {
                    return [];
                },
            },
            defaultGuestId: {
                type: Object,
                value() {
                    return {
                        vm_name: '',
                        container_name: '',
                    };
                },
            },
            /**
             * The USB device which was toggled to be shared, but is already shared
             * with another VM. When non-null the reassign dialog is shown.
             */
            reassignDevice_: {
                type: Object,
                value: null,
            },
            /**
             * Whether the guest OS hosts multiple containers.
             */
            hasContainers: {
                type: Boolean,
                value() {
                    return false;
                },
            },
            showAddUsbDialog_: {
                type: Boolean,
                value: false,
            },
            /**
             * The known ContainerIds for display in the UI.
             */
            allContainers_: {
                type: Array,
                notify: true,
                value() {
                    return [];
                },
            },
        };
    }
    constructor() {
        super();
        // DeepLinkingMixin override
        this.supportedSettingIds = new Set([
            Setting.kGuestUsbNotification,
            Setting.kGuestUsbPersistentPassthrough,
        ]);
        this.browserProxy_ = GuestOsBrowserProxyImpl.getInstance();
    }
    ready() {
        super.ready();
        this.addWebUiListener('guest-os-shared-usb-devices-changed', this.onGuestOsSharedUsbDevicesChanged_.bind(this));
        this.browserProxy_.notifyGuestOsSharedUsbDevicesPageReady();
    }
    currentRouteChanged(newRoute) {
        if (newRoute !== routes.CROSTINI_SHARED_USB_DEVICES) {
            return;
        }
        this.attemptDeepLink();
    }
    onContainerInfo_(containerInfos) {
        this.set('allContainers_', containerInfos);
    }
    showGuestId_(sharedUsbDevices, id) {
        return sharedUsbDevices.some(this.byGuestId_(id));
    }
    hasSharedDevices_(sharedUsbDevices, containerInfos) {
        return sharedUsbDevices.some(dev => containerInfos.some(info => dev.device.guestId &&
            equalContainerId(dev.device.guestId, info.id)));
    }
    onGuestOsSharedUsbDevicesChanged_(devices) {
        this.sharedUsbDevices_ = devices.map((device) => {
            return {
                shared: !!device.guestId && device.guestId.vm_name === this.vmName_(),
                device: device,
            };
        });
    }
    onDeviceSharedChange_(event) {
        const device = event.model.item.device;
        // Show reassign dialog if device is already shared with another VM.
        const target = cast(event.target, CrToggleElement);
        if (target.checked && device.promptBeforeSharing) {
            target.checked = false;
            this.reassignDevice_ = device;
            return;
        }
        const persistentPassthroughEnabled = this.get('prefs.guest_os.usb_persistent_passthrough_enabled.value');
        if (!target.checked && persistentPassthroughEnabled) {
            const deviceIdentifier = `${parseInt(device.vendorId, 16)}:${parseInt(device.productId, 16)}:${device.serialNumber}`;
            // Return value of deletion is agnostic to presence of key existence, so
            // nothing to return/check here.
            this.deletePrefDictEntry('guest_os.usb_persistent_passthrough_devices', deviceIdentifier);
        }
        this.browserProxy_.setGuestOsUsbDeviceShared(this.vmName_(), this.defaultGuestId.container_name, device.guid, target.checked);
    }
    onReassignCancel_() {
        this.reassignDevice_ = null;
    }
    onReassignContinueClick_() {
        assertExists(this.reassignDevice_);
        this.browserProxy_.setGuestOsUsbDeviceShared(this.vmName_(), this.defaultGuestId.container_name, this.reassignDevice_.guid, true);
        this.reassignDevice_ = null;
    }
    vmName_() {
        return getVMNameForGuestOsType(this.guestOsType);
    }
    getDescriptionText_() {
        return this.i18n(this.guestOsType + 'SharedUsbDevicesDescription');
    }
    getReassignDialogText_(device) {
        return this.i18n('guestOsSharedUsbDevicesReassign', device.label);
    }
    byGuestId_(id) {
        return (dev) => (!!dev.device.guestId &&
            equalContainerId(dev.device.guestId, id));
    }
    onAddUsbClick_() {
        this.showAddUsbDialog_ = true;
    }
    onAddUsbDialogClose_() {
        this.showAddUsbDialog_ = false;
    }
    guestLabel_(id) {
        return containerLabel(id, this.vmName_());
    }
    onRemoveUsbClick_(event) {
        const device = event.model.item.device;
        if (device.guestId) {
            this.browserProxy_.setGuestOsUsbDeviceShared(device.guestId.vm_name, '', device.guid, false);
        }
    }
    getGuestUsbNotificationToggle_() {
        return castExists(this.shadowRoot.querySelector('#guestShowUsbNotificationToggle'));
    }
    getNotificationDialogText_() {
        const toggle = this.getGuestUsbNotificationToggle_();
        // `checked` state here is the *new* desired state
        return toggle.checked ?
            this.i18n('guestOsSharedUsbDevicesNotificationDialogTitleEnable') :
            this.i18n('guestOsSharedUsbDevicesNotificationDialogTitleDisable');
    }
    onGuestUsbNotificationChange_() {
        this.showGuestUsbNotificationDialog_ = true;
    }
    onGuestUsbNotificationDialogClose_(e) {
        const toggle = this.getGuestUsbNotificationToggle_();
        if (e.detail.accepted) {
            toggle.sendPrefChange();
        }
        else {
            toggle.resetToPrefValue();
        }
        this.showGuestUsbNotificationDialog_ = false;
    }
    getGuestUsbPersistentPassthroughToggle_() {
        return castExists(this.shadowRoot.querySelector('#guestUsbPersistentPassthroughToggle'));
    }
    getGuestUsbPersistentPassthroughDialogText_() {
        const toggle = this.getGuestUsbPersistentPassthroughToggle_();
        // `checked` state here is the *new* desired state
        return toggle.checked ?
            this.i18n('guestOsSharedUsbPersistentPassthroughDialogTitleEnable') :
            this.i18n('guestOsSharedUsbPersistentPassthroughDialogTitleDisable');
    }
    onGuestUsbPersistentPassthroughChange_() {
        this.showGuestUsbPersistentPassthroughDialog_ = true;
    }
    onGuestUsbPersistentPassthroughDialogClose_(e) {
        const toggle = this.getGuestUsbPersistentPassthroughToggle_();
        if (e.detail.accepted) {
            toggle.sendPrefChange();
            if (!toggle.checked) {
                // Persistent passthrough has been turned off, reset list of devices.
                this.setPrefValue('guest_os.usb_persistent_passthrough_devices', {});
            }
        }
        else {
            toggle.resetToPrefValue();
        }
        this.showGuestUsbPersistentPassthroughDialog_ = false;
    }
}
customElements.define(SettingsGuestOsSharedUsbDevicesElement.is, SettingsGuestOsSharedUsbDevicesElement);

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-crostini-shared-usb-devices' is a variant of the
 * shared usb devices subpage for Crostini.
 */
class CrostiniSharedUsbDevicesElement extends SettingsGuestOsSharedUsbDevicesElement {
    static get is() {
        return 'settings-crostini-shared-usb-devices';
    }
    static get properties() {
        return {
            ...SettingsGuestOsSharedUsbDevicesElement.properties,
            guestOsType: {
                type: String,
                value: 'crostini',
            },
            defaultGuestId: {
                type: Object,
                value() {
                    return DEFAULT_CROSTINI_GUEST_ID;
                },
            },
            /**
             * Whether the guest OS hosts multiple containers.
             */
            hasContainers: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('showCrostiniExtraContainers');
                },
            },
        };
    }
    ready() {
        super.ready();
        this.addWebUiListener('crostini-container-info', (infos) => this.onContainerInfo_(infos));
        CrostiniBrowserProxyImpl.getInstance().requestContainerInfo();
    }
}
customElements.define(CrostiniSharedUsbDevicesElement.is, CrostiniSharedUsbDevicesElement);

function getTemplate$3f() {
    return html `<!--_html_template_start_--><style include="settings-shared">#disk-labels{display:flex;justify-content:space-between}#resize-block{align-items:stretch;margin-inline-end:10px;margin-inline-start:10px}.error{color:var(--cros-text-color-alert)}#errorIcon{--iron-icon-fill-color:var(--cros-icon-color-alert);display:inline-block}#warningIcon{--iron-icon-fill-color:var(--cros-icon-color-warning)}#message{margin-inline-end:auto}
</style>
<cr-dialog id="diskResizeDialog" close-text="$i18n{close}">
  <!-- The title gets read out multiple times. This was a deliberate
       tradeoff made by cr-dialog so for now that's what we're stuck with:
       https://chromium-review.googlesource.com/c/chromium/src/+/1906254
  -->
  <div slot="title">$i18n{crostiniDiskResizeTitle}</div>
  <div slot="body">
    <template is="dom-if" if="[[eq_(displayState_, DisplayStateEnum_.RESIZE)]]">
      <div>
        <div hidden="[[isLowSpaceAvailable_]]" id="recommended-size">
          $i18n{crostiniDiskResizeRecommended}
        </div>
        <div hidden="[[!isLowSpaceAvailable_]]"
            id="recommended-size-warning">
          <iron-icon id="warningIcon" icon="cr:warning"></iron-icon>
          $i18n{crostiniDiskResizeRecommendedWarning}
        </div>
      </div>
      <div id="resize-block">
        <cr-slider id="diskSlider" pin="true"
            value="[[defaultDiskSizeTick_]]" ticks="[[diskSizeTicks_]]"
            disabled="[[resizing_]]" max="[[maxDiskSizeTick_]]">
        </cr-slider>
        <div id="disk-labels" aria-hidden="true">
          <div id="label-begin">[[minDiskSize_]]</div>
          <div id="label-end">[[maxDiskSize_]]</div>
        </div>
      </div>
    </template>
    <template is="dom-if"
        if="[[eq_(displayState_, DisplayStateEnum_.UNSUPPORTED)]]">
      <div id="unsupported">
        $i18n{crostiniDiskResizeUnsupported}
      </div>
    </template>
    <template is="dom-if" if="[[eq_(displayState_, DisplayStateEnum_.LOADING)]]">
      <div id="loading">
        $i18n{crostiniDiskResizeLoading}
      </div>
    </template>
    <template is="dom-if" if="[[eq_(displayState_, DisplayStateEnum_.ERROR)]]">
      <span id="error" aria-hidden="true">
        $i18n{crostiniDiskResizeError}
      </span>
      <cr-button id="retry" on-click="onRetryClick_"
          aria-describedby="error">
        $i18n{crostiniDiskResizeErrorRetry}
      </cr-button>
    </template>
  </div>
  <div slot="button-container">
    <div id="message" aria-live="assertive">
      <span id="resizing"
          hidden="[[!eq_(resizeState_, ResizeStateEnum_.RESIZING)]]">
        $i18n{crostiniDiskResizeInProgress}
      </span>
      <template is="dom-if" if="[[eq_(resizeState_, ResizeStateEnum_.ERROR)]]">
        <span id="resize-error" class="error">
          <iron-icon id="errorIcon" icon="cr:error-outline"></iron-icon>
          $i18n{crostiniDiskResizeResizingError}
        </span>
      </template>
      <span id="done" hidden="[[!eq_(resizeState_, ResizeStateEnum_.DONE)]]">
        $i18n{crostiniDiskResizeDone}
      </span>
    </div>
    <cr-button id="cancel" class="cancel-button"
        disabled="[[eq_(resizeState_, ResizeStateEnum_.RESIZING)]]"
        on-click="onCancelClick_">
      $i18n{crostiniDiskResizeCancel}
    </cr-button>
    <cr-button id="resize" class="action-button"
        disabled="[[resizeDisabled_(displayState_, resizeState_)]]"
        on-click="onResizeClick_">
      $i18n{crostiniDiskResizeGoButton}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'crostini-disk-resize' is a dialog for disk management e.g.
 * resizing their disk or converting it from sparse to preallocated.
 */
/**
 * Which overall dialogue view should be shown e.g. loading, unsupported.
 */
var DisplayState;
(function (DisplayState) {
    DisplayState["LOADING"] = "loading";
    DisplayState["UNSUPPORTED"] = "unsupported";
    DisplayState["ERROR"] = "error";
    DisplayState["RESIZE"] = "resize";
})(DisplayState || (DisplayState = {}));
/**
 * The current resizing state.
 */
var ResizeState;
(function (ResizeState) {
    ResizeState["INITIAL"] = "initial";
    ResizeState["RESIZING"] = "resizing";
    ResizeState["ERROR"] = "error";
    ResizeState["DONE"] = "done";
})(ResizeState || (ResizeState = {}));
class SettingsCrostiniDiskResizeDialogElement extends PolymerElement {
    static get is() {
        return 'settings-crostini-disk-resize-dialog';
    }
    static get template() {
        return getTemplate$3f();
    }
    static get properties() {
        return {
            minDiskSize_: {
                type: String,
            },
            maxDiskSize_: {
                type: String,
            },
            diskSizeTicks_: {
                type: Array,
            },
            defaultDiskSizeTick_: {
                type: Number,
            },
            maxDiskSizeTick_: {
                type: Number,
            },
            isLowSpaceAvailable_: {
                type: Boolean,
                value: false,
            },
            displayState_: {
                type: String,
                value: DisplayState.LOADING,
            },
            resizeState_: {
                type: String,
                value: ResizeState.INITIAL,
            },
            /**
             * Enable the html template to use DisplayState.
             */
            DisplayStateEnum_: {
                type: Object,
                value: DisplayState,
            },
            /**
             * Enable the html template to use ResizeState.
             */
            ResizeStateEnum_: {
                type: Object,
                value: ResizeState,
            },
        };
    }
    constructor() {
        super();
        this.browserProxy_ = CrostiniBrowserProxyImpl.getInstance();
    }
    connectedCallback() {
        super.connectedCallback();
        this.displayState_ = DisplayState.LOADING;
        this.$.diskResizeDialog.showModal();
        this.loadDiskInfo_();
    }
    /**
     * Requests info for the current VM disk, then populates the disk info and
     * current state once the call completes.
     */
    loadDiskInfo_() {
        this.browserProxy_
            .getCrostiniDiskInfo(TERMINA_VM_TYPE, /*requestFullInfo=*/ true)
            .then(diskInfo => {
            if (!diskInfo.succeeded) {
                this.displayState_ = DisplayState.ERROR;
            }
            else if (!diskInfo.canResize) {
                this.displayState_ = DisplayState.UNSUPPORTED;
            }
            else {
                this.displayState_ = DisplayState.RESIZE;
                this.maxDiskSizeTick_ = diskInfo.ticks.length - 1;
                this.defaultDiskSizeTick_ = diskInfo.defaultIndex;
                this.diskSizeTicks_ = diskInfo.ticks;
                this.minDiskSize_ = diskInfo.ticks[0].label;
                this.maxDiskSize_ =
                    diskInfo.ticks[diskInfo.ticks.length - 1].label;
                this.isLowSpaceAvailable_ = diskInfo.isLowSpaceAvailable;
            }
        }, reason => {
            console.warn(`Unable to get info: ${reason}`);
            this.displayState_ = DisplayState.ERROR;
        });
    }
    onCancelClick_() {
        this.$.diskResizeDialog.close();
    }
    onRetryClick_() {
        this.displayState_ = DisplayState.LOADING;
        this.loadDiskInfo_();
    }
    onResizeClick_() {
        const slider = castExists(this.shadowRoot.querySelector('#diskSlider'));
        const selectedIndex = slider.value;
        const size = this.diskSizeTicks_[selectedIndex].value;
        this.resizeState_ = ResizeState.RESIZING;
        this.browserProxy_.resizeCrostiniDisk('termina', size)
            .then(succeeded => {
            if (succeeded) {
                this.resizeState_ = ResizeState.DONE;
                recordSettingChange(Setting.kCrostiniDiskResize);
                this.$.diskResizeDialog.close();
            }
            else {
                this.resizeState_ = ResizeState.ERROR;
            }
        }, (reason) => {
            console.warn(`Unable to resize disk: ${reason}`);
            this.resizeState_ = ResizeState.ERROR;
        });
    }
    eq_(a, b) {
        return a === b;
    }
    resizeDisabled_(displayState, resizeState) {
        return displayState !== DisplayState.RESIZE ||
            resizeState === ResizeState.RESIZING;
    }
}
customElements.define(SettingsCrostiniDiskResizeDialogElement.is, SettingsCrostiniDiskResizeDialogElement);

function getTemplate$3e() {
    return html `<!--_html_template_start_--><style include="settings-shared"></style>
<cr-dialog id="dialog" close-text="$i18n{close}">
  <div slot="title">$i18n{crostiniDiskResizeConfirmationDialogTitle}</div>
  <div slot="body">$i18n{crostiniDiskResizeConfirmationDialogMessage}</div>
  <div slot="button-container">
    <cr-button id="cancel" class="cancel-button"
        on-click="onCancelClick_">$i18n{cancel}</cr-button>
    <cr-button id="continue" class="action-button"
        on-click="onReserveSizeClick_">
        $i18n{crostiniDiskResizeConfirmationDialogButton}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-crostini-disk-resize-confirmation-dialog' is a
 * component warning the user that resizing a sparse disk cannot be undone.
 * By clicking 'Reserve size', the user agrees to start the operation.
 */
class SettingsCrostiniDiskResizeConfirmationDialogElement extends PolymerElement {
    static get is() {
        return 'settings-crostini-disk-resize-confirmation-dialog';
    }
    static get template() {
        return getTemplate$3e();
    }
    connectedCallback() {
        super.connectedCallback();
        this.getDialog_().showModal();
    }
    onCancelClick_() {
        this.getDialog_().cancel();
    }
    onReserveSizeClick_() {
        this.getDialog_().close();
    }
    getDialog_() {
        return this.$.dialog;
    }
}
customElements.define(SettingsCrostiniDiskResizeConfirmationDialogElement.is, SettingsCrostiniDiskResizeConfirmationDialogElement);

function getTemplate$3d() {
    return html `<!--_html_template_start_--><style include="settings-shared"></style>
<template is="dom-if" if="[[showCrostiniContainerUpgrade_]]">
  <div id="container-upgrade" class="settings-box first">
    <iron-icon icon="cr:file-download"></iron-icon>
    <div class="middle settings-box-text" aria-hidden="true">
      <div id="containerUpgradeLabel">
        $i18n{crostiniContainerUpgrade}
      </div>
      <div class="secondary" id="containerUpgradeDescription">
        $i18n{crostiniContainerUpgradeSubtext}
      </div>
    </div>
    <cr-button id="containerUpgradeButton"
        on-click="onContainerUpgradeClick_"
        aria-labelledby="containerUpgradeLabel containerUpgradeButton"
        aria-describedby="containerUpgradeDescription"
        disabled="[[disableUpgradeButton_]]"
        deep-link-focus-id$="[[Setting.kCrostiniContainerUpgrade]]">
      $i18n{crostiniContainerUpgradeButton}
    </cr-button>
  </div>
</template>
<cr-link-row
    id="crostiniSharedPathsRow"
    class="hr"
    label="$i18n{guestOsSharedPaths}"
    on-click="onSharedPathsClick_"
    role-description="$i18n{subpageArrowRoleDescription}">
</cr-link-row>
<cr-link-row
    id="crostiniSharedUsbDevicesRow"
    class="hr"
    label="$i18n{guestOsSharedUsbDevicesLabel}"
    on-click="onSharedUsbDevicesClick_"
    role-description="$i18n{subpageArrowRoleDescription}">
</cr-link-row>
<template is="dom-if" if="[[showCrostiniExtraContainers_]]">
  <cr-link-row
      id="crostiniExtraContainersRow"
      class="hr"
      label="$i18n{crostiniExtraContainersLabel}"
      on-click="onExtraContainersClick_"
      role-description="$i18n{subpageArrowRoleDescription}">
  </cr-link-row>
</template>
<template is="dom-if" if="[[showCrostiniExportImport_]]">
  <cr-link-row
      id="crostiniExportImportRow"
      class="hr"
      label="$i18n{crostiniExportImportTitle}"
      on-click="onExportImportClick_"
      role-description="$i18n{subpageArrowRoleDescription}">
  </cr-link-row>
</template>
<template is="dom-if" if="[[showArcAdbSideloading_]]">
  <cr-link-row
      id="crostiniEnableArcAdbRow"
      class="hr"
      label="$i18n{crostiniArcAdbTitle}"
      on-click="onEnableArcAdbClick_"
      role-description="$i18n{subpageArrowRoleDescription}">
  </cr-link-row>
</template>
<template is="dom-if" if="[[showCrostiniPortForwarding_]]">
  <cr-link-row
      id="crostiniPortForwardingRow"
      class="hr"
      label="$i18n{crostiniPortForwarding}"
      on-click="onPortForwardingClick_"
      role-description="$i18n{subpageArrowRoleDescription}">
  </cr-link-row>
</template>
<div class="settings-box hr" id="crostiniDiskResizeRow">
  <div class="start">
    <div>
      $i18n{crostiniDiskResizeLabel}
    </div>
    <div class="secondary" id="diskSizeDescription">
      [[diskSizeLabel_]]
    </div>
  </div>
  <cr-button on-click="onDiskResizeClick_" hidden="[[!canDiskResize_]]"
      aria-label="[[diskResizeButtonAriaLabel_]]"
      aria-describedby="diskSizeDescription" id="showDiskResizeButton"
      deep-link-focus-id$="[[Setting.kCrostiniDiskResize]]">
    [[diskResizeButtonLabel_]]
  </cr-button>
</div>
<template is="dom-if" if="[[showDiskResizeDialog_]]" restamp>
  <settings-crostini-disk-resize-dialog on-close="onDiskResizeDialogClose_">
  </settings-crostini-disk-resize-dialog>
</template>
<template is="dom-if" if="[[showDiskResizeConfirmationDialog_]]" restamp>
  <settings-crostini-disk-resize-confirmation-dialog
      on-close="onDiskResizeConfirmationDialogClose_"
      on-cancel="onDiskResizeConfirmationDialogCancel_">
  </settings-crostini-disk-resize-confirmation-dialog>
</template>
<settings-toggle-button
    class="hr"
    id="crostini-mic-permission-toggle"
    pref="{{prefs.crostini.mic_allowed}}"
    no-set-pref
    label="$i18n{crostiniMicTitle}"
    on-settings-boolean-control-change="onMicPermissionChange_"
    deep-link-focus-id$="[[Setting.kCrostiniMicAccess]]">
</settings-toggle-button>
<template is="dom-if" if="[[showCrostiniMicPermissionDialog_]]" restamp>
  <settings-guest-os-confirmation-dialog
      id="crostini-mic-permission-dialog"
      accept-button-text="$i18n{crostiniMicDialogShutdownButton}"
      on-close="onCrostiniMicPermissionDialogClose_">
    <div slot="body">$i18n{crostiniMicDialogLabel}</div>
  </settings-guest-os-confirmation-dialog>
</template>
<template is="dom-if" if="[[!hideCrostiniUninstall_]]">
  <div id="remove" class="settings-box">
    <div id="removeCrostiniLabel" class="start" aria-hidden="true">
      $i18n{crostiniRemove}
    </div>
    <cr-button on-click="onRemoveClick_"
        aria-label="$i18n{crostiniRemoveButton}"
        aria-describedby="removeCrostiniLabel"
        deep-link-focus-id$="[[Setting.kUninstallCrostini]]">
      $i18n{crostiniRemoveButton}
    </cr-button>
  </div>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'crostini-subpage' is the settings subpage for managing Crostini.
 */
/**
 * The current confirmation state.
 */
var ConfirmationState;
(function (ConfirmationState) {
    ConfirmationState["NOT_CONFIRMED"] = "notConfirmed";
    ConfirmationState["CONFIRMED"] = "confirmed";
})(ConfirmationState || (ConfirmationState = {}));
const SettingsCrostiniSubpageElementBase = DeepLinkingMixin(RouteOriginMixin(PrefsMixin(WebUiListenerMixin(PolymerElement))));
class SettingsCrostiniSubpageElement extends SettingsCrostiniSubpageElementBase {
    static get is() {
        return 'settings-crostini-subpage';
    }
    static get template() {
        return getTemplate$3d();
    }
    static get properties() {
        return {
            /**
             * Whether export / import UI should be displayed.
             */
            showCrostiniExportImport_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('showCrostiniExportImport');
                },
            },
            showArcAdbSideloading_: {
                type: Boolean,
                computed: 'and_(isArcAdbSideloadingSupported_, isAndroidEnabled_)',
            },
            isArcAdbSideloadingSupported_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('arcAdbSideloadingSupported');
                },
            },
            /**
             * Whether port-forwarding UI should be displayed.
             * Determined by policy setting and if current termina guest is of
             * baguette type.
             */
            showCrostiniPortForwarding_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('showCrostiniPortForwarding') &&
                        !loadTimeData.getBoolean('isBaguette');
                },
            },
            showCrostiniExtraContainers_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('showCrostiniExtraContainers');
                },
            },
            isAndroidEnabled_: {
                type: Boolean,
            },
            /**
             * Whether the uninstall options should be displayed.
             */
            hideCrostiniUninstall_: {
                type: Boolean,
                computed: 'or_(installerShowing_, upgraderDialogShowing_)',
            },
            /**
             * Whether the button to launch the Crostini container upgrade flow should
             * be shown.
             */
            showCrostiniContainerUpgrade_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('showCrostiniContainerUpgrade');
                },
            },
            showDiskResizeConfirmationDialog_: {
                type: Boolean,
                value: false,
            },
            installerShowing_: {
                type: Boolean,
            },
            upgraderDialogShowing_: {
                type: Boolean,
            },
            /**
             * Whether the button to launch the Crostini container upgrade flow should
             * be disabled.
             */
            disableUpgradeButton_: {
                type: Boolean,
                computed: 'or_(installerShowing_, upgraderDialogShowing_)',
            },
            /**
             * Whether the disk resizing dialog is visible or not
             */
            showDiskResizeDialog_: {
                type: Boolean,
                value: false,
            },
            showCrostiniMicPermissionDialog_: {
                type: Boolean,
                value: false,
            },
            diskSizeLabel_: {
                type: String,
                value: loadTimeData.getString('crostiniDiskSizeCalculating'),
            },
            diskResizeButtonLabel_: {
                type: String,
                value: loadTimeData.getString('crostiniDiskResizeShowButton'),
            },
            diskResizeButtonAriaLabel_: {
                type: String,
                value: loadTimeData.getString('crostiniDiskResizeShowButtonAriaLabel'),
            },
            canDiskResize_: {
                type: Boolean,
                value: false,
            },
        };
    }
    static get observers() {
        return [
            'onCrostiniEnabledChanged_(prefs.crostini.enabled.value)',
            'onArcEnabledChanged_(prefs.arc.enabled.value)',
        ];
    }
    constructor() {
        super();
        // DeepLinkingMixin override
        this.supportedSettingIds = new Set([
            Setting.kUninstallCrostini,
            Setting.kCrostiniDiskResize,
            Setting.kCrostiniMicAccess,
            Setting.kCrostiniContainerUpgrade,
        ]);
        /** RouteOriginMixin override */
        this.route = routes.CROSTINI_DETAILS;
        this.isDiskUserChosenSize_ = false;
        this.diskResizeConfirmationState_ = ConfirmationState.NOT_CONFIRMED;
        this.browserProxy_ = CrostiniBrowserProxyImpl.getInstance();
    }
    connectedCallback() {
        super.connectedCallback();
        this.addWebUiListener('crostini-installer-status-changed', (status) => {
            this.installerShowing_ = status;
        });
        this.addWebUiListener('crostini-upgrader-status-changed', (status) => {
            this.upgraderDialogShowing_ = status;
        });
        this.addWebUiListener('crostini-container-upgrade-available-changed', (canUpgrade) => {
            this.showCrostiniContainerUpgrade_ = canUpgrade;
        });
        this.browserProxy_.requestCrostiniInstallerStatus();
        this.browserProxy_.requestCrostiniUpgraderDialogStatus();
        this.browserProxy_.requestCrostiniContainerUpgradeAvailable();
        this.loadDiskInfo_();
    }
    ready() {
        super.ready();
        const r = routes;
        this.addFocusConfig(r.CROSTINI_SHARED_PATHS, '#crostiniSharedPathsRow');
        this.addFocusConfig(r.CROSTINI_SHARED_USB_DEVICES, '#crostiniSharedUsbDevicesRow');
        this.addFocusConfig(r.CROSTINI_EXPORT_IMPORT, '#crostiniExportImportRow');
        this.addFocusConfig(r.CROSTINI_ANDROID_ADB, '#crostiniEnableArcAdbRow');
        this.addFocusConfig(r.CROSTINI_PORT_FORWARDING, '#crostiniPortForwardingRow');
        this.addFocusConfig(r.CROSTINI_EXTRA_CONTAINERS, '#crostiniExtraContainersRow');
    }
    currentRouteChanged(newRoute, oldRoute) {
        super.currentRouteChanged(newRoute, oldRoute);
        // Does not apply to this page.
        if (newRoute !== this.route) {
            return;
        }
        this.attemptDeepLink();
    }
    onCrostiniEnabledChanged_(enabled) {
        if (!enabled &&
            Router.getInstance().currentRoute === routes.CROSTINI_DETAILS) {
            Router.getInstance().navigateToPreviousRoute();
        }
        if (enabled) {
            // The disk size or type could have changed due to the user reinstalling
            // Crostini, update our info.
            this.loadDiskInfo_();
        }
    }
    onArcEnabledChanged_(enabled) {
        this.isAndroidEnabled_ = enabled;
    }
    onExportImportClick_() {
        Router.getInstance().navigateTo(routes.CROSTINI_EXPORT_IMPORT);
    }
    onEnableArcAdbClick_() {
        Router.getInstance().navigateTo(routes.CROSTINI_ANDROID_ADB);
    }
    loadDiskInfo_() {
        this.browserProxy_
            .getCrostiniDiskInfo(TERMINA_VM_TYPE, /*requestFullInfo=*/ false)
            .then(diskInfo => {
            if (diskInfo.succeeded) {
                this.setResizeLabels_(diskInfo);
            }
        }, reason => {
            console.warn(`Unable to get info: ${reason}`);
        });
    }
    setResizeLabels_(diskInfo) {
        this.canDiskResize_ = diskInfo.canResize;
        if (!this.canDiskResize_) {
            this.diskSizeLabel_ =
                loadTimeData.getString('crostiniDiskResizeNotSupportedSubtext');
            return;
        }
        this.isDiskUserChosenSize_ = diskInfo.isUserChosenSize;
        if (this.isDiskUserChosenSize_) {
            if (diskInfo.ticks) {
                this.diskSizeLabel_ = diskInfo.ticks[diskInfo.defaultIndex].label;
            }
            this.diskResizeButtonLabel_ =
                loadTimeData.getString('crostiniDiskResizeShowButton');
            this.diskResizeButtonAriaLabel_ =
                loadTimeData.getString('crostiniDiskResizeShowButtonAriaLabel');
        }
        else {
            this.diskSizeLabel_ = loadTimeData.getString('crostiniDiskResizeDynamicallyAllocatedSubtext');
            this.diskResizeButtonLabel_ =
                loadTimeData.getString('crostiniDiskReserveSizeButton');
            this.diskResizeButtonAriaLabel_ =
                loadTimeData.getString('crostiniDiskReserveSizeButtonAriaLabel');
        }
    }
    onDiskResizeClick_() {
        if (!this.isDiskUserChosenSize_ &&
            this.diskResizeConfirmationState_ !== ConfirmationState.CONFIRMED) {
            this.showDiskResizeConfirmationDialog_ = true;
            return;
        }
        this.showDiskResizeDialog_ = true;
    }
    onDiskResizeDialogClose_() {
        this.showDiskResizeDialog_ = false;
        this.diskResizeConfirmationState_ = ConfirmationState.NOT_CONFIRMED;
        // DiskInfo could have changed.
        this.loadDiskInfo_();
    }
    onDiskResizeConfirmationDialogClose_() {
        // The on_cancel is followed by on_close, so check cancel didn't happen
        // first.
        if (this.showDiskResizeConfirmationDialog_) {
            this.diskResizeConfirmationState_ = ConfirmationState.CONFIRMED;
            this.showDiskResizeConfirmationDialog_ = false;
            this.showDiskResizeDialog_ = true;
        }
    }
    onDiskResizeConfirmationDialogCancel_() {
        this.showDiskResizeConfirmationDialog_ = false;
    }
    /**
     * Shows a confirmation dialog when removing crostini.
     */
    onRemoveClick_() {
        this.browserProxy_.requestRemoveCrostini();
        recordSettingChange(Setting.kUninstallCrostini);
    }
    /**
     * Shows the upgrade flow dialog.
     */
    onContainerUpgradeClick_() {
        this.browserProxy_.requestCrostiniContainerUpgradeView();
        recordSettingChange(Setting.kCrostiniContainerUpgrade);
    }
    onSharedPathsClick_() {
        Router.getInstance().navigateTo(routes.CROSTINI_SHARED_PATHS);
    }
    onSharedUsbDevicesClick_() {
        Router.getInstance().navigateTo(routes.CROSTINI_SHARED_USB_DEVICES);
    }
    onPortForwardingClick_() {
        Router.getInstance().navigateTo(routes.CROSTINI_PORT_FORWARDING);
    }
    onExtraContainersClick_() {
        Router.getInstance().navigateTo(routes.CROSTINI_EXTRA_CONTAINERS);
    }
    getMicToggle_() {
        return castExists(this.shadowRoot.querySelector('#crostini-mic-permission-toggle'));
    }
    /**
     * If a change to the mic settings requires Crostini to be restarted, a
     * dialog is shown.
     */
    async onMicPermissionChange_() {
        if (await this.browserProxy_.checkCrostiniIsRunning()) {
            this.showCrostiniMicPermissionDialog_ = true;
        }
        else {
            this.getMicToggle_().sendPrefChange();
        }
    }
    onCrostiniMicPermissionDialogClose_(e) {
        const toggle = this.getMicToggle_();
        if (e.detail.accepted) {
            toggle.sendPrefChange();
            this.browserProxy_.shutdownCrostini();
        }
        else {
            toggle.resetToPrefValue();
        }
        this.showCrostiniMicPermissionDialog_ = false;
    }
    and_(a, b) {
        return a && b;
    }
    or_(a, b) {
        return a || b;
    }
}
customElements.define(SettingsCrostiniSubpageElement.is, SettingsCrostiniSubpageElement);

function getTemplate$3c() {
    return html `<!--_html_template_start_--><style include="settings-shared">#paragraph1{margin-block-start:0px}#dialogBody{padding-top:10px}cr-dialog::part(dialog){width:370px}</style>

<cr-dialog id="systemGeolocationDialog" show-on-attach>
  <div slot="title">
    $i18n{systemGeolocationDialogTitle}
  </div>
  <div slot="body" id="dialogBody">
    <p id="paragraph1">$i18n{systemGeolocationDialogBodyParagraph1}</p>
    <localized-link
        aria-describedby="paragraph1"
        localized-string="$i18n{systemGeolocationDialogBodyParagraph2}"
        link-url="$i18n{geolocationAccuracyLearnMoreUrl}">
    </localized-link>
  </div>
  <div slot="button-container">
    <cr-button id="cancelButton"
        class="cancel-button"
        on-click="onCancelClicked_">
      $i18n{systemGeolocationDialogCancelButton}
    </cr-button>
    <cr-button id="confirmButton"
        class="action-button"
        on-click="onEnableClicked_">
      $i18n{systemGeolocationDialogConfirmButton}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview This dialog explains and asks users to enable system location
 * permission to allow precise timezone resolution.
 */
const PrivacyHubGeolocationDialogBase = PrefsMixin(PolymerElement);
class PrivacyHubGeolocationDialog extends PrivacyHubGeolocationDialogBase {
    static get is() {
        return 'settings-privacy-hub-geolocation-dialog';
    }
    static get template() {
        return getTemplate$3c();
    }
    /**
     * Enables geolocation usage for system services.
     */
    onEnableClicked_() {
        // Send the new state immediately, this will also toggle the underlying
        // `setting-dropdown-menu` setting associated with this pref.
        this.setPrefValue('ash.user.geolocation_access_level', GeolocationAccessLevel.ONLY_ALLOWED_FOR_SYSTEM);
        chrome.metricsPrivate.recordEnumerationValue(LOCATION_PERMISSION_CHANGE_FROM_DIALOG_HISTOGRAM_NAME, GeolocationAccessLevel.ONLY_ALLOWED_FOR_SYSTEM, GeolocationAccessLevel.MAX_VALUE + 1);
        this.getDialog_().close();
    }
    onCancelClicked_() {
        this.getDialog_().close();
    }
    getDialog_() {
        return castExists(this.shadowRoot.querySelector('#systemGeolocationDialog'));
    }
}
customElements.define(PrivacyHubGeolocationDialog.is, PrivacyHubGeolocationDialog);

function getTemplate$3b() {
    return html `<!--_html_template_start_--><style include="settings-shared">#container{display:inline-flex;width:inherit;margin-top:5px;text-align:left}#warningIcon{margin-right:5px}</style>
<div id="container">
  <iron-icon id="warningIcon" icon="cr20:warning"></iron-icon>
  <localized-link
      on-link-clicked="launchGeolocationDialog_"
      localized-string="[[warningTextWithAnchor]]">
  </localized-link>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class PrivacyHubGeolocationWarningText extends PolymerElement {
    static get is() {
        return 'settings-privacy-hub-geolocation-warning-text';
    }
    static get template() {
        return getTemplate$3b();
    }
    static get properties() {
        return {
            warningTextWithAnchor: {
                type: String,
                reflectToAttribute: true,
            },
        };
    }
    launchGeolocationDialog_(e) {
        // A place holder href with the value "#" is used to have a compliant link.
        // This prevents the browser from navigating the window to "#".
        e.detail.event.preventDefault();
        e.stopPropagation();
        this.dispatchEvent(new CustomEvent('link-clicked', { bubbles: false }));
    }
}
customElements.define(PrivacyHubGeolocationWarningText.is, PrivacyHubGeolocationWarningText);

// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Describes values of
 * prefs.generated.resolve_timezone_by_geolocation_method_short. Must be kept
 * in sync with TimeZoneResolverManager::TimeZoneResolveMethod enum.
 */
var TimeZoneAutoDetectMethod;
(function (TimeZoneAutoDetectMethod) {
    TimeZoneAutoDetectMethod[TimeZoneAutoDetectMethod["DISABLED"] = 0] = "DISABLED";
    TimeZoneAutoDetectMethod[TimeZoneAutoDetectMethod["IP_ONLY"] = 1] = "IP_ONLY";
    TimeZoneAutoDetectMethod[TimeZoneAutoDetectMethod["SEND_WIFI_ACCESS_POINTS"] = 2] = "SEND_WIFI_ACCESS_POINTS";
    TimeZoneAutoDetectMethod[TimeZoneAutoDetectMethod["SEND_ALL_LOCATION_INFO"] = 3] = "SEND_ALL_LOCATION_INFO";
})(TimeZoneAutoDetectMethod || (TimeZoneAutoDetectMethod = {}));

function getTemplate$3a() {
    return html `<!--_html_template_start_--><style include="settings-shared">#timezoneRadioContainer{padding-bottom:var(--cr-section-padding)}settings-dropdown-menu{--md-select-width:425px;--settings-dropdown-menu-policy-order:1}#timeZoneResolveMethodDropdown,#timezoneSelector{padding-inline-start:28px}#warningText{width:425px;padding-inline-start:28px}
</style>
<div id="timezoneRadioContainer" class="settings-box first">
  <settings-radio-group id="timeZoneRadioGroup"
      pref="{{prefs.generated.resolve_timezone_by_geolocation_on_off}}"
      deep-link-focus-id$="[[Setting.kChangeTimeZone]]"
      disabled="[[!canSetSystemTimezone_]]">
    <controlled-radio-button
        id="timeZoneAutoDetectOn"
        name="true"
        pref="[[prefs.generated.resolve_timezone_by_geolocation_on_off]]"
        label="$i18n{setTimeZoneAutomaticallyOn}"
        no-extension-indicator>
    </controlled-radio-button>
    <settings-dropdown-menu id="timeZoneResolveMethodDropdown"
        pref="{{prefs.generated.resolve_timezone_by_geolocation_method_short}}"
        label="$i18n{selectTimeZoneResolveMethod}"
        disabled="[[!prefs.generated.resolve_timezone_by_geolocation_on_off.value]]"
        menu-options="[[getTimeZoneResolveMethodsList_(
            prefs.generated.resolve_timezone_by_geolocation_method_short)]]">
    </settings-dropdown-menu>
    <template is="dom-if" if="[[shouldShowGeolocationWarningText_]]"
        restamp>
      <settings-privacy-hub-geolocation-warning-text
          id="warningText"
          warning-text-with-anchor="[[geolocationWarningText_]]"
          on-link-clicked="openGeolocationDialog_">
      </settings-privacy-hub-geolocation-warning-text>
    </template>
    <controlled-radio-button
        id="timeZoneAutoDetectOff"
        name="false"
        pref="[[prefs.generated.resolve_timezone_by_geolocation_on_off]]"
        label="$i18n{setTimeZoneAutomaticallyOff}"
        no-extension-indicator>
    </controlled-radio-button>
    <timezone-selector id="timezoneSelector" prefs="{{prefs}}"
        active-time-zone-display-name="{{activeTimeZoneDisplayName}}">
    </timezone-selector>
  </settings-radio-group>
</div>

<template is="dom-if" if="[[showEnableSystemGeolocationDialog_]]" restamp>
  <settings-privacy-hub-geolocation-dialog id="geolocationDialog"
      on-close="onGeolocationDialogClose_"
      prefs="{{prefs}}">
  </settings-privacy-hub-geolocation-dialog>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'timezone-subpage' is the collapsible section containing
 * time zone settings.
 */
const TimezoneSubpageElementBase = DeepLinkingMixin(RouteObserverMixin(I18nMixin(PrefsMixin(PolymerElement))));
class TimezoneSubpageElement extends TimezoneSubpageElementBase {
    static get is() {
        return 'timezone-subpage';
    }
    static get template() {
        return getTemplate$3a();
    }
    static get properties() {
        return {
            /**
             * This is <timezone-selector> parameter.
             */
            activeTimeZoneDisplayName: {
                type: String,
                notify: true,
            },
            canSetSystemTimezone_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('canSetSystemTimezone');
                },
            },
            geolocationWarningText_: {
                type: String,
                computed: 'computedGeolocationWarningText(activeTimeZoneDisplayName,' +
                    'prefs.ash.user.geolocation_access_level.enforcement)',
            },
            shouldShowGeolocationWarningText_: {
                type: Boolean,
                computed: 'computeShouldShowGeolocationWarningText_(' +
                    'prefs.generated.resolve_timezone_by_geolocation_on_off.value,' +
                    'prefs.ash.user.geolocation_access_level.value)',
            },
            showEnableSystemGeolocationDialog_: {
                type: Boolean,
                value: false,
            },
        };
    }
    /**
     * Returns the browser proxy page handler (to invoke functions).
     */
    get pageHandler() {
        return this.browserProxy_.handler;
    }
    /**
     * Returns the browser proxy callback router (to receive async messages).
     */
    get callbackRouter() {
        return this.browserProxy_.observer;
    }
    constructor() {
        super();
        // DeepLinkingMixin override
        this.supportedSettingIds = new Set([
            Setting.kChangeTimeZone,
        ]);
        this.browserProxy_ = DateTimeBrowserProxy.getInstance();
    }
    connectedCallback() {
        super.connectedCallback();
        this.callbackRouter.onParentAccessValidationComplete.addListener(this.enableTimeZoneSetting_.bind(this));
    }
    /**
     * RouteObserverMixin
     * Called when the timezone subpage is hit. Child accounts need parental
     * approval to modify their timezone, this method starts this process on the
     * C++ side, and timezone setting will be disable. Once it is complete the
     * 'access-code-validation-complete' event is triggered which invokes
     * enableTimeZoneSetting_.
     */
    currentRouteChanged(newRoute, _oldRoute) {
        if (newRoute !== routes.DATETIME_TIMEZONE_SUBPAGE) {
            return;
        }
        // Check if should ask for parent access code.
        if (isChild()) {
            this.disableTimeZoneSetting_();
            this.pageHandler.showParentAccessForTimezone();
        }
        this.attemptDeepLink();
    }
    computedGeolocationWarningText() {
        if (!this.prefs) {
            return '';
        }
        if (this.prefs.ash.user.geolocation_access_level.enforcement ===
            chrome.settingsPrivate.Enforcement.ENFORCED) {
            return loadTimeData.getStringF('timeZoneGeolocationManagedWarningText', this.activeTimeZoneDisplayName);
        }
        else {
            return loadTimeData.getStringF('timeZoneGeolocationWarningText', this.activeTimeZoneDisplayName);
        }
    }
    computeShouldShowGeolocationWarningText_() {
        return (this.prefs.generated.resolve_timezone_by_geolocation_on_off.value ===
            true &&
            this.prefs.ash.user.geolocation_access_level.value ===
                GeolocationAccessLevel.DISALLOWED);
    }
    /**
     * Returns value list for timeZoneResolveMethodDropdown menu.
     */
    getTimeZoneResolveMethodsList_() {
        const result = [];
        const pref = this.getPref('generated.resolve_timezone_by_geolocation_method_short');
        // Make sure current value is in the list, even if it is not
        // user-selectable.
        if (pref.value === TimeZoneAutoDetectMethod.DISABLED) {
            // If disabled by policy, show the 'Automatic timezone disabled' label.
            // Otherwise, just show the default string, since the control will be
            // disabled as well.
            const label = pref.controlledBy ?
                loadTimeData.getString('setTimeZoneAutomaticallyDisabled') :
                loadTimeData.getString('setTimeZoneAutomaticallyIpOnlyDefault');
            result.push({ value: TimeZoneAutoDetectMethod.DISABLED, name: label });
        }
        result.push({
            value: TimeZoneAutoDetectMethod.IP_ONLY,
            name: loadTimeData.getString('setTimeZoneAutomaticallyIpOnlyDefault'),
        });
        if (pref.value === TimeZoneAutoDetectMethod.SEND_WIFI_ACCESS_POINTS) {
            result.push({
                value: TimeZoneAutoDetectMethod.SEND_WIFI_ACCESS_POINTS,
                name: loadTimeData.getString('setTimeZoneAutomaticallyWithWiFiAccessPointsData'),
            });
        }
        result.push({
            value: TimeZoneAutoDetectMethod.SEND_ALL_LOCATION_INFO,
            name: loadTimeData.getString('setTimeZoneAutomaticallyWithAllLocationInfo'),
        });
        return result;
    }
    /**
     * Enables all dropdowns and radio buttons.
     */
    enableTimeZoneSetting_() {
        const radios = this.shadowRoot.querySelectorAll('controlled-radio-button');
        for (const radio of radios) {
            radio.disabled = false;
        }
        this.$.timezoneSelector.shouldDisableTimeZoneGeoSelector = false;
        const pref = this.getPref('generated.resolve_timezone_by_geolocation_method_short');
        if (pref.value !== TimeZoneAutoDetectMethod.DISABLED) {
            this.$.timeZoneResolveMethodDropdown.disabled = false;
        }
    }
    /**
     * Disables all dropdowns and radio buttons.
     */
    disableTimeZoneSetting_() {
        this.$.timeZoneResolveMethodDropdown.disabled = true;
        this.$.timezoneSelector.shouldDisableTimeZoneGeoSelector = true;
        const radios = this.shadowRoot.querySelectorAll('controlled-radio-button');
        for (const radio of radios) {
            radio.disabled = true;
        }
    }
    openGeolocationDialog_() {
        this.showEnableSystemGeolocationDialog_ = true;
    }
    onGeolocationDialogClose_() {
        this.showEnableSystemGeolocationDialog_ = false;
    }
}
customElements.define(TimezoneSubpageElement.is, TimezoneSubpageElement);

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
let instance$b = null;
class AudioAndCaptionsPageBrowserProxyImpl {
    static getInstance() {
        return instance$b || (instance$b = new AudioAndCaptionsPageBrowserProxyImpl());
    }
    static setInstanceForTesting(obj) {
        instance$b = obj;
    }
    setStartupSoundEnabled(enabled) {
        chrome.send('setStartupSoundEnabled', [enabled]);
    }
    audioAndCaptionsPageReady() {
        chrome.send('manageA11yPageReady');
    }
    getStartupSoundEnabled() {
        chrome.send('getStartupSoundEnabled');
    }
    previewFlashNotification() {
        chrome.send('previewFlashNotification');
    }
}

function getTemplate$39() {
    return html `<!--_html_template_start_--><style include="settings-shared md-select">.audio-mute-button{margin-inline-end:8px}.audio-mute-button[disabled]{background-color:transparent;pointer-events:auto}.audio-options-container{align-items:center;display:flex;flex-direction:row}.audio-slider{margin-inline-end:16px;padding:0;width:142px}h2{padding-inline-start:var(--cr-section-padding)}.settings-box:first-of-type{border-top:none}.subsection{padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-indent-padding)}.subsection>.settings-box,.subsection>settings-toggle-button{padding-inline-end:0;padding-inline-start:0}.sub-item{padding-inline-start:var(--cr-section-indent-width);margin-bottom:8px}.audio-info-icon{margin-inline-end:4px;--iron-icon-fill-color:var(--cros-color-prominent)}:host([is-output-muted_]) #outputVolumeSlider{--cr-slider-active-color:var(--cros-slider-color-inactive);--cr-slider-container-color:var(--cros-slider-track-color-inactive);--cr-slider-knob-color-rgb:var(--cros-color-primary-rgb)}:host([is-output-muted_]) #audioOutputMuteButton{--cr-icon-button-fill-color:var(--cros-color-secondary)}:host(:not([is-output-muted_])) #audioOutputMuteButton{--cr-icon-button-fill-color:var(--cros-color-prominent)}:host([is-input-muted_]) #audioInputGainVolumeSlider{--cr-slider-active-color:var(--cros-slider-color-inactive);--cr-slider-container-color:var(--cros-slider-track-color-inactive);--cr-slider-knob-color-rgb:var(--cros-color-primary-rgb)}:host([is-input-muted_]) #audioInputGainMuteButton{--cr-icon-button-fill-color:var(--cros-color-secondary)}:host(:not([is-input-muted_])) #audioInputGainMuteButton{--cr-icon-button-fill-color:var(--cros-color-prominent)}paper-tooltip{--paper-tooltip-min-width:max-content}</style>

<!-- Output section -->
<div id="output"
    hidden="[[getOutputHidden_(audioSystemProperties_.outputDevices)]]">
  <h2 id="audioOutputTitle">$i18n{audioOutputTitle}</h2>
  <div id="audioOutputSubsection" class="subsection">
    <div id="outputDeviceSubsection" class="settings-box">
      <div class="start settings-box-text" id="audioOutputDeviceLabel">
        $i18n{audioOutputDeviceTitle}
      </div>
      <select id="audioOutputDeviceDropdown" class="md-select"
          on-change="onOutputDeviceChanged"
          aria-labelledby="audioOutputTitle audioOutputDeviceLabel">
        <template is="dom-repeat"
            items="[[audioSystemProperties_.outputDevices]]">
          <option value="[[item.id]]" selected="[[item.isActive]]">
            [[getDeviceName_(item)]]
          </option>
        </template>
      </select>
    </div>
    <div id="outputVolumeSubsection" class="settings-box">
      <div class="start settings-box-text" id="audioOutputVolumeLabel">
        $i18n{audioVolumeTitle}
      </div>
      <div class="audio-options-container">
        <template is="dom-if" if="[[isOutputMutedByPolicy_(
              audioSystemProperties_.outputMuteState
            )]]">
          <cr-policy-indicator id="audioOutputMuteByPolicyIndicator"
              indicator-type="userPolicy">
          </cr-policy-indicator>
        </template>
        <cr-icon-button class="audio-mute-button"
            id="audioOutputMuteButton"
            iron-icon="[[getOutputIcon_(isOutputMuted_, outputVolume_)]]"
            on-click="onOutputMuteButtonClicked"
            disabled="[[isOutputMutedByPolicy_(
                audioSystemProperties_.outputMuteState
              )]]"
            aria-description="[[getOutputMuteButtonAriaLabel(
                isOutputMuted_
              )]]"
            aria-labelledby="audioOutputVolumeLabel"
            aria-pressed="[[isOutputMuted_]]">
        </cr-icon-button>
        <paper-tooltip id="audioOutputMuteButtonTooltip" aria-hidden="true"
            for="audioOutputMuteButton">
          [[getMuteTooltip_(audioSystemProperties_.outputMuteState)]]
        </paper-tooltip>
        <cr-slider class="audio-slider"
            id ="outputVolumeSlider"
            min="0"
            max="100"
            key-press-slider-increment="10"
            disabled="[[isOutputMutedByPolicy_(
                audioSystemProperties_.outputMuteState
              )]]"
            value="[[audioSystemProperties_.outputVolumePercent]]"
            on-cr-slider-value-changed="onOutputVolumeSliderChanged_"
            aria-labelledby="audioOutputTitle audioOutputVolumeLabel">
        </cr-slider>
      </div>
    </div>
    <div id="audioOutputSpatialAudioSubsection" class="settings-box"
      hidden="[[!showSpatialAudio]]"
      on-click="onSpatialAudioRowClicked_" actionable-row>
      <div id="audioOutputSpatialAudioLabel" class="settings-box-text start">
        $i18n{audioOutputSpatialAudioTitle}
      </div>
      <cr-toggle id="audioOutputSpatialAudioToggle"
          checked="{{isSpatialAudioEnabled_}}"
          aria-labelledby="audioOutputSpatialAudioLabel"
          on-change="toggleSpatialAudioEnabled_">
      </cr-toggle>
    </div>
  </div>
</div>
<!--TODO(b/260277007): Replace placeholder text when localization strings
  available. Add styling. -->
<div id="input"
    hidden="[[getInputHidden_(audioSystemProperties_.inputDevices)]]">
  <h2 id="audioInputTitle">$i18n{audioInputTitle}</h2>
  <div id="audioInputSection" class="subsection">
    <div id="audioInputDeviceSubsection" class="settings-box">
      <div id="audioInputDeviceLabel" class="start settings-box-text">
        $i18n{audioInputDeviceTitle}
      </div>
      <select id="audioInputDeviceDropdown" on-change="onInputDeviceChanged"
          class="md-select"
          aria-labelledby="audioInputTitle audioInputDeviceLabel">
        <template is="dom-repeat"
            items="[[audioSystemProperties_.inputDevices]]">
          <option value="[[item.id]]" selected="[[item.isActive]]">
            [[getDeviceName_(item)]]
          </option>
        </template>
      </select>
    </div>
    <div id="audioInputDeviceSubsection" class="settings-box">
      <div id="audioInputGainLabel" class="start settings-box-text">
        $i18n{audioInputGainTitle}
      </div>
      <div class="audio-options-container">
        <cr-icon-button id="audioInputGainMuteButton"
            iron-icon="[[getInputIcon_(isInputMuted_)]]"
            on-click="onInputMuteClicked"
            class="audio-mute-button"
            disabled="[[shouldDisableInputGainControls(isInputMuted_)]]"
            aria-description$="[[getInputMuteButtonAriaLabel(
                audioSystemProperties_.inputMuteState,
                isInputMuted_
              )]]"
            aria-labelledby="audioInputGainLabel"
            aria-pressed="[[isInputMuted_]]">
        </cr-icon-button>
        <paper-tooltip id="audioInputMuteButtonTooltip" aria-hidden="true"
            for="audioInputGainMuteButton">
          [[getMuteTooltip_(audioSystemProperties_.inputMuteState)]]
        </paper-tooltip>
        <cr-slider id="audioInputGainVolumeSlider" min="0" max="100"
            key-press-slider-increment="10"
            iron-icon="[[getInputIcon_(isInputMuted_)]]"
            value="[[audioSystemProperties_.inputGainPercent]]"
            on-cr-slider-value-changed="onInputVolumeSliderChanged"
            class="audio-slider"
            aria-labelledby="audioInputTitle audioInputGainLabel"
            disabled="[[shouldDisableInputGainControls(isInputMuted_)]]">
        </cr-slider>
      </div>
    </div>
    <settings-toggle-button id="audioInputVoiceIsolationToggleSection"
        hidden="[[!showVoiceIsolationSubsection_]]"
        pref="{{prefs.ash.input_voice_isolation_enabled}}"
        label="[[getVoiceIsolationToggleTitle_(audioSystemProperties_.voiceIsolationUiAppearance)]]"
        sub-label="[[getVoiceIsolationToggleDescription_(audioSystemProperties_.voiceIsolationUiAppearance)]]"
        learn-more-url="$i18n{voiceIsolationLearnMoreLink}"
        on-change="onVoiceIsolationRowClicked_">
    </settings-toggle-button>
    <template is="dom-if" if="[[shouldShowVoiceIsolationEffectModeOptions_(
          audioSystemProperties_.voiceIsolationUiAppearance.effectModeOptions,
          prefs.ash.input_voice_isolation_enabled.value
        )]]">
      <div class="sub-item">
        <span>
          $i18n{audioInputEffectMode}
        </span>
        <settings-radio-group id="voiceIsolationEffectModeOptions"
            pref="{{prefs.ash.input_voice_isolation_preferred_effect}}"
            on-change="onVoiceIsolationEffectModeChanged_">
          <controlled-radio-button
              id="voiceIsolationEffectModeStyleTransfer"
              name="[[voiceIsolationEffectModePrefValues_.STYLE_TRANSFER]]"
              pref="[[prefs.ash.input_voice_isolation_preferred_effect]]"
              label="$i18n{audioInputEffectModeStyleTransferTitle}"
              aria-description="$i18n{audioInputEffectModeStyleTransferDescription}">
            <div class="cr-secondary-text">
              <span>$i18n{audioInputEffectModeStyleTransferDescription}</span>
            </div>
          </controlled-radio-button>
          <controlled-radio-button
              id="voiceIsolationEffectModeBeamforming"
              name="[[voiceIsolationEffectModePrefValues_.BEAMFORMING]]"
              pref="[[prefs.ash.input_voice_isolation_preferred_effect]]"
              label="$i18n{audioInputBeamformingTitle}"
              aria-description="$i18n{audioInputBeamformingDescription}">
            <div class="cr-secondary-text">
              <span>$i18n{audioInputBeamformingDescription}</span>
            </div>
          </controlled-radio-button>
        </settings-radio-group>
      </div>
    </template>
    <div id="voiceIsolationEffectFallbackMessageSection" class="sub-item"
        hidden="[[!shouldShowVoiceIsolationFallbackMessage_(
          audioSystemProperties_.voiceIsolationUiAppearance.showEffectFallbackMessage,
          prefs.ash.input_voice_isolation_enabled.value
        )]]">
      <iron-icon class="audio-info-icon" tabindex="0" icon="cr:info-outline"
          aria-labelledby="voiceIsolationEffectFallbackMessage">
      </iron-icon>
      <span id="voiceIsolationEffectFallbackMessage">
        $i18n{audioInputVoiceIsolationEffectFallbackMessage}
      </span>
    </div>
    <div id="audioInputAllowAGCSubsection" class="settings-box"
        hidden="[[!showAllowAGC]]">
      <div id="audioInputAllowAGCLabel" class="settings-box-text start">
        $i18n{audioInputAllowAGCTitle}
      </div>
      <cr-toggle id="audioInputAllowAGCToggle"
          checked="{{isAllowAGCEnabled}}"
          on-change="toggleAllowAgcEnabled_">
      </cr-toggle>
    </div>
    <div id="audioInputHfpMicSrSubsection" class="settings-box"
        hidden="[[!isHfpMicSrSupported]]">
      <div id="audioInputHfpMicSrLabel"
          class="settings-box-text start" aria-hidden="true">
        $i18n{audioHfpMicSrTitle}
        <div class="secondary">
          $i18n{audioHfpMicSrDescription}
        </div>
      </div>
      <cr-toggle id="audioInputHfpMicSrToggle"
          checked="{{isHfpMicSrEnabled}}"
          aria-labelledby="audioInputHfpMicSrLabel"
          on-change="toggleHfpMicSrEnabled_">
      </cr-toggle>
    </div>
  </div>
</div>

<div id="deviceSounds">
  <h2>$i18n{deviceSoundsTitle}</h2>
  <div id="deviceSoundsSection" class="subsection">
    <settings-toggle-button id="lowBatterySoundToggle"
        pref="{{prefs.ash.low_battery_sound.enabled}}"
        label="$i18n{lowBatterySoundLabel}"
        deep-link-focus-id$="[[Setting.kLowBatterySound]]"
        hidden$="[[powerSoundsHidden_]]">
    </settings-toggle-button>
    <settings-toggle-button id="chargingSoundsToggle"
        pref="{{prefs.ash.charging_sounds.enabled}}"
        label="$i18n{chargingSoundsLabel}"
        deep-link-focus-id$="[[Setting.kChargingSounds]]"
        hidden$="[[powerSoundsHidden_]]">
    </settings-toggle-button>
    <div class="settings-box start-padding continuation"
        on-click="onDeviceStartupSoundRowClicked_" actionable-row>
      <div id="deviceStartupSoundEnabledLabel"
          class="start settings-box-text">
        $i18n{deviceStartupSoundLabel}
      </div>
      <cr-toggle id="deviceStartupSoundToggle"
          checked="[[startupSoundEnabled_]]"
          on-change="toggleStartupSoundEnabled_">
      </cr-toggle>
    </div>
  </div>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'audio-settings' allow users to configure their audio settings in system
 * settings.
 */
/** Utility for keeping percent in inclusive range of [0,100].  */
function clampPercent(percent) {
    return Math.max(0, Math.min(percent, 100));
}
const SettingsAudioElementBase = WebUiListenerMixin(DeepLinkingMixin(PrefsMixin(RouteObserverMixin(I18nMixin(PolymerElement)))));
const VOLUME_ICON_OFF_LEVEL = 0;
// TODO(b/271871947): Match volume icon logic to QS revamp sliders.
// Matches level calculated in unified_volume_view.cc.
const VOLUME_ICON_LOUD_LEVEL = 34;
class SettingsAudioElement extends SettingsAudioElementBase {
    static get is() {
        return 'settings-audio';
    }
    static get template() {
        return getTemplate$39();
    }
    static get properties() {
        return {
            crosAudioConfig_: {
                type: Object,
            },
            audioSystemProperties_: {
                type: Object,
            },
            isOutputMuted_: {
                type: Boolean,
                reflectToAttribute: true,
            },
            isInputMuted_: {
                type: Boolean,
                reflectToAttribute: true,
            },
            showVoiceIsolationSubsection_: {
                type: Boolean,
            },
            /**
             * Enum values for the
             * 'ash.input_voice_isolation_preferred_effect' preference. These
             * values map to cras::AudioEffectType, and are written to prefs.
             */
            voiceIsolationEffectModePrefValues_: {
                readOnly: true,
                type: Object,
                value: {
                    STYLE_TRANSFER: AudioEffectType.kStyleTransfer,
                    BEAMFORMING: AudioEffectType.kBeamforming,
                },
            },
            outputVolume_: {
                type: Number,
            },
            powerSoundsHidden_: {
                type: Boolean,
                computed: 'computePowerSoundsHidden_(batteryStatus_)',
            },
            startupSoundEnabled_: {
                type: Boolean,
                value: false,
            },
            showAllowAGC: {
                type: Boolean,
                value: loadTimeData.getBoolean('enableForceRespectUiGainsToggle'),
                readonly: true,
            },
            isAllowAGCEnabled: {
                type: Boolean,
                value: true,
            },
            isHfpMicSrEnabled: {
                type: Boolean,
            },
            showSpatialAudio: {
                type: Boolean,
            },
            isSpatialAudioEnabled_: {
                type: Boolean,
                value: true,
            },
        };
    }
    constructor() {
        super();
        // DeepLinkingMixin override
        this.supportedSettingIds = new Set([
            Setting.kChargingSounds,
            Setting.kLowBatterySound,
        ]);
        this.crosAudioConfig_ = getCrosAudioConfig();
        this.audioSystemPropertiesObserverReceiver_ =
            new AudioSystemPropertiesObserverReceiver(this);
        this.audioAndCaptionsBrowserProxy_ =
            AudioAndCaptionsPageBrowserProxyImpl.getInstance();
        this.devicePageBrowserProxy_ = DevicePageBrowserProxyImpl.getInstance();
    }
    ready() {
        super.ready();
        this.observeAudioSystemProperties_();
        this.addWebUiListener('startup-sound-setting-retrieved', (startupSoundEnabled) => {
            this.startupSoundEnabled_ = startupSoundEnabled;
        });
        this.addWebUiListener('battery-status-changed', this.set.bind(this, 'batteryStatus_'));
        // Manually call updatePowerStatus to ensure batteryStatus_ is initialized
        // and up to date.
        this.devicePageBrowserProxy_.updatePowerStatus();
    }
    /**
     * AudioSystemPropertiesObserverInterface override
     */
    onPropertiesUpdated(properties) {
        this.audioSystemProperties_ = properties;
        this.isOutputMuted_ =
            this.audioSystemProperties_.outputMuteState !== MuteState.kNotMuted;
        this.isInputMuted_ =
            this.audioSystemProperties_.inputMuteState !== MuteState.kNotMuted;
        const activeInputDevice = this.audioSystemProperties_.inputDevices.find((device) => device.isActive);
        const toggleType = this.audioSystemProperties_.voiceIsolationUiAppearance.toggleType;
        this.showVoiceIsolationSubsection_ = toggleType !== AudioEffectType.kNone;
        this.isAllowAGCEnabled =
            (activeInputDevice?.forceRespectUiGainsState ===
                AudioEffectState.kNotEnabled);
        this.outputVolume_ = this.audioSystemProperties_.outputVolumePercent;
        this.isHfpMicSrEnabled =
            (activeInputDevice?.hfpMicSrState === AudioEffectState.kEnabled);
        this.isHfpMicSrSupported = activeInputDevice !== undefined &&
            activeInputDevice?.hfpMicSrState !== AudioEffectState.kNotSupported;
        const activeOutputDevice = this.audioSystemProperties_.outputDevices.find((device) => device.isActive);
        this.isSpatialAudioEnabled_ = activeOutputDevice !== undefined &&
            activeOutputDevice?.spatialAudioState === AudioEffectState.kEnabled;
        this.isSpatialAudioSupported_ = activeOutputDevice !== undefined &&
            activeOutputDevice?.spatialAudioState !==
                AudioEffectState.kNotSupported;
        this.showSpatialAudio =
            (this.isSpatialAudioSupported_ &&
                loadTimeData.getBoolean('enableSpatialAudioToggle'));
    }
    getIsOutputMutedForTest() {
        return this.isOutputMuted_;
    }
    getIsInputMutedForTest() {
        return this.isInputMuted_;
    }
    observeAudioSystemProperties_() {
        // Use fake observer implementation to access additional properties not
        // available on mojo interface.
        if (this.crosAudioConfig_ instanceof FakeCrosAudioConfig) {
            this.crosAudioConfig_.observeAudioSystemProperties(this);
            return;
        }
        this.crosAudioConfig_.observeAudioSystemProperties(this.audioSystemPropertiesObserverReceiver_.$
            .bindNewPipeAndPassRemote());
    }
    /** Determines if audio output is muted by policy. */
    isOutputMutedByPolicy_() {
        return this.audioSystemProperties_.outputMuteState ===
            MuteState.kMutedByPolicy;
    }
    onInputMuteClicked() {
        this.crosAudioConfig_.setInputMuted(!this.isInputMuted_);
    }
    /** Handles updating active input device. */
    onInputDeviceChanged() {
        const inputDeviceSelect = this.shadowRoot.querySelector('#audioInputDeviceDropdown');
        assert(!!inputDeviceSelect);
        this.crosAudioConfig_.setActiveDevice(BigInt(inputDeviceSelect.value));
    }
    /**
     * Handles the event where the input volume slider is being changed.
     */
    onInputVolumeSliderChanged() {
        const sliderValue = this.shadowRoot
            .querySelector('#audioInputGainVolumeSlider').value;
        this.crosAudioConfig_.setInputGainPercent(clampPercent(sliderValue));
    }
    /**
     * Handles the event where the output volume slider is being changed.
     */
    onOutputVolumeSliderChanged_() {
        const sliderValue = this.shadowRoot.querySelector('#outputVolumeSlider').value;
        this.crosAudioConfig_.setOutputVolumePercent(clampPercent(sliderValue));
    }
    /** Handles updating active output device. */
    onOutputDeviceChanged() {
        const outputDeviceSelect = this.shadowRoot.querySelector('#audioOutputDeviceDropdown');
        assert(!!outputDeviceSelect);
        this.crosAudioConfig_.setActiveDevice(BigInt(outputDeviceSelect.value));
    }
    /** Handles updating outputMuteState. */
    onOutputMuteButtonClicked() {
        this.crosAudioConfig_.setOutputMuted(!this.isOutputMuted_);
    }
    currentRouteChanged(route) {
        // Does not apply to this page.
        // TODO(crbug.com/1092970): Add DeepLinkingMixin and attempt deep link.
        if (route !== routes.AUDIO) {
            return;
        }
        this.audioAndCaptionsBrowserProxy_.getStartupSoundEnabled();
    }
    /** Handles updating the mic icon depending on the input mute state. */
    getInputIcon_() {
        return this.isInputMuted_ ? 'os-settings:mic-off' : 'cr:mic';
    }
    /**
     * Handles updating the output icon depending on the output mute state and
     * volume.
     */
    getOutputIcon_() {
        if (this.isOutputMuted_) {
            return 'os-settings:volume-up-off';
        }
        if (this.outputVolume_ === VOLUME_ICON_OFF_LEVEL) {
            return 'os-settings:volume-zero';
        }
        if (this.outputVolume_ < VOLUME_ICON_LOUD_LEVEL) {
            return 'os-settings:volume-down';
        }
        return 'os-settings:volume-up';
    }
    /**
     * Handles the case when there are no output devices. The output section
     * should be hidden in this case.
     */
    getOutputHidden_() {
        return this.audioSystemProperties_.outputDevices.length === 0;
    }
    /**
     * Handles the case when there are no input devices. The input section should
     * be hidden in this case.
     */
    getInputHidden_() {
        return this.audioSystemProperties_.inputDevices.length === 0;
    }
    /**
     * Returns true if input is muted by physical switch; otherwise, return false.
     */
    shouldDisableInputGainControls() {
        return this.audioSystemProperties_.inputMuteState ===
            MuteState.kMutedExternally;
    }
    /** Translates the device name if applicable. */
    getDeviceName_(audioDevice) {
        switch (audioDevice.deviceType) {
            case AudioDeviceType.kHeadphone:
                return this.i18n('audioDeviceHeadphoneLabel');
            case AudioDeviceType.kMic:
                return this.i18n('audioDeviceMicJackLabel');
            case AudioDeviceType.kUsb:
                return this.i18n('audioDeviceUsbLabel', audioDevice.displayName);
            case AudioDeviceType.kBluetooth:
            case AudioDeviceType.kBluetoothNbMic:
                return this.i18n('audioDeviceBluetoothLabel', audioDevice.displayName);
            case AudioDeviceType.kHdmi:
                return this.i18n('audioDeviceHdmiLabel', audioDevice.displayName);
            case AudioDeviceType.kInternalSpeaker:
                return this.i18n('audioDeviceInternalSpeakersLabel');
            case AudioDeviceType.kInternalMic:
                return this.i18n('audioDeviceInternalMicLabel');
            case AudioDeviceType.kFrontMic:
                return this.i18n('audioDeviceFrontMicLabel');
            case AudioDeviceType.kRearMic:
                return this.i18n('audioDeviceRearMicLabel');
            default:
                return audioDevice.displayName;
        }
    }
    /**
     * Returns the appropriate tooltip for output and input device mute buttons
     * based on `muteState`.
     */
    getMuteTooltip_(muteState) {
        switch (muteState) {
            case MuteState.kNotMuted:
                return this.i18n('audioToggleToMuteTooltip');
            case MuteState.kMutedByUser:
                return this.i18n('audioToggleToUnmuteTooltip');
            case MuteState.kMutedByPolicy:
                return this.i18n('audioMutedByPolicyTooltip');
            case MuteState.kMutedExternally:
                return this.i18n('audioMutedExternallyTooltip');
            default:
                return '';
        }
    }
    /** Returns the appropriate aria-label for input mute button. */
    getInputMuteButtonAriaLabel() {
        if (this.audioSystemProperties_.inputMuteState ===
            MuteState.kMutedExternally) {
            return this.i18n('audioInputMuteButtonAriaLabelMutedByHardwareSwitch');
        }
        return this.isInputMuted_ ?
            this.i18n('audioInputMuteButtonAriaLabelMuted') :
            this.i18n('audioInputMuteButtonAriaLabelNotMuted');
    }
    /** Returns the appropriate aria-label for output mute button. */
    getOutputMuteButtonAriaLabel() {
        return this.isOutputMuted_ ?
            this.i18n('audioOutputMuteButtonAriaLabelMuted') :
            this.i18n('audioOutputMuteButtonAriaLabelNotMuted');
    }
    getVoiceIsolationToggleTitle_(voiceIsolationUIAppearance) {
        if (voiceIsolationUIAppearance === undefined) {
            return '';
        }
        switch (voiceIsolationUIAppearance.toggleType) {
            case AudioEffectType.kNoiseCancellation:
                return this.i18n('audioInputNoiseCancellationTitle');
            case AudioEffectType.kStyleTransfer:
                return this.i18n('audioInputStyleTransferTitle');
            case AudioEffectType.kBeamforming:
                return this.i18n('audioInputBeamformingTitle');
            default:
                return '';
        }
    }
    getVoiceIsolationToggleDescription_(voiceIsolationUIAppearance) {
        if (voiceIsolationUIAppearance === undefined) {
            return '';
        }
        switch (voiceIsolationUIAppearance.toggleType) {
            case AudioEffectType.kStyleTransfer:
                return this.i18n('audioInputStyleTransferDescription');
            case AudioEffectType.kBeamforming:
                return this.i18n('audioInputBeamformingDescription');
            default:
                return '';
        }
    }
    shouldShowVoiceIsolationEffectModeOptions_(effectModeOptions, voiceIsolationEnabled) {
        return effectModeOptions !== 0 && voiceIsolationEnabled;
    }
    shouldShowVoiceIsolationFallbackMessage_(crasShowEffectFallbackMessage, voiceIsolationEnabled) {
        return crasShowEffectFallbackMessage && voiceIsolationEnabled;
    }
    toggleHfpMicSrEnabled_(e) {
        this.crosAudioConfig_.setHfpMicSrEnabled(e.detail);
    }
    toggleStartupSoundEnabled_(e) {
        this.audioAndCaptionsBrowserProxy_.setStartupSoundEnabled(e.detail);
    }
    toggleAllowAgcEnabled_(e) {
        this.crosAudioConfig_.setForceRespectUiGainsEnabled(!e.detail);
    }
    toggleSpatialAudioEnabled_(e) {
        this.crosAudioConfig_.setSpatialAudioEnabled(e.detail);
    }
    computePowerSoundsHidden_() {
        return !this.batteryStatus_?.present;
    }
    onDeviceStartupSoundRowClicked_() {
        this.startupSoundEnabled_ = !this.startupSoundEnabled_;
        this.audioAndCaptionsBrowserProxy_.setStartupSoundEnabled(this.startupSoundEnabled_);
    }
    onVoiceIsolationRowClicked_() {
        // The pref change will be handled by
        // CrasAudioHandler::OnVoiceIsolationPrefChanged().
        // See also AudioDevicesPrefHandlerImpl::InitializePrefObservers().
        this.crosAudioConfig_.recordVoiceIsolationEnabledChange();
    }
    onVoiceIsolationEffectModeChanged_() {
        // The pref change will be handled by
        // CrasAudioHandler::OnVoiceIsolationPrefChanged().
        // See also AudioDevicesPrefHandlerImpl::InitializePrefObservers().
        // The pref value might not be updated yet, so only getting
        // the UI value here to record to UMA.
        const voiceIsolationEffectModes = strictQuery('#voiceIsolationEffectModeOptions', this.shadowRoot, SettingsRadioGroupElement);
        const selected = +voiceIsolationEffectModes.selected;
        this.crosAudioConfig_.recordVoiceIsolationPreferredEffectChange(selected);
    }
    onSpatialAudioRowClicked_() {
        const spatialAudioToggle = strictQuery('#audioOutputSpatialAudioToggle', this.shadowRoot, CrToggleElement);
        this.crosAudioConfig_.setSpatialAudioEnabled(!spatialAudioToggle.checked);
    }
}
customElements.define(SettingsAudioElement.is, SettingsAudioElement);

const styleMod$3 = document.createElement('dom-module');
styleMod$3.appendChild(html `
  <template>
    <style>
:host(:not([is-last-device])) .bottom-divider{border-bottom:var(--cr-separator-line)}.subsection{margin-bottom:8px;padding-inline-start:var(--cr-section-indent-width)}.subsection>*{padding-inline-start:0}.subsection-header{color:var(--cros-sys-primary);height:24px;padding-bottom:6px;padding-inline-start:var(--cr-section-padding);padding-top:12px}.key-container{align-items:center;border-radius:12px;box-sizing:border-box;color:var(--cros-text-color-secondary);display:flex;height:28px;justify-content:center;margin-inline-end:8px;min-width:28px;padding:6px}#keyLabel{padding-inline:6px}cr-dialog [slot='button-container']{display:flex;justify-content:space-between;padding:0 32px 28px 32px}cr-dialog [slot='body']{padding:24px 32px}cr-dialog [slot='title']{padding:32px 32px 0 32px}cr-dialog #cancelButton,cr-dialog #editButton{background-color:var(--cros-bg-color);border:solid 1px var(--cros-button-stroke-color-secondary)}.subpage-description{align-items:center;display:flex;justify-content:center}.subpage-description>span{color:var(--cros-text-color-secondary);font-family:var(--cros-body-2-font-family);line-height:20px;padding:14px 0}.subpage-description>iron-icon{margin:6px;--iron-icon-height:20px;--iron-icon-width:20px;--iron-icon-fill-color:var(--cros-text-color-secondary)}
    </style>
  </template>
`.content);
styleMod$3.register('input-device-settings-shared');

function getTemplate$38() {
    return html `<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">#mouseSwapToggleButton{border-bottom:var(--cr-separator-line)}#helpSection{align-items:center;background-color:var(--cros-sys-app_base_shaded);border-radius:12px;display:flex;margin:8px;padding:16px 12px}#helpIconSection{--iron-icon-height:48px;--iron-icon-width:48px;flex-basis:48px}#helpSectionText{flex:1;margin-inline-start:12px}.help-title{color:var(--cros-text-color-primary);font:var(--cros-button-1-font);margin-bottom:5px}.secondary{font:var(--cros-body-2-font)}#buttonsSection{border-top:var(--cr-separator-line)}</style>
<settings-toggle-button id="mouseSwapToggleButton"
    aria-describedby="description"
    label="$i18n{mouseSwapButtonsLabel}"
    pref="{{primaryRightPref_}}">
</settings-toggle-button>
<div id="helpSection">
  <div id="helpIconSection">
    <iron-icon icon="os-settings:mouse-banner"></iron-icon>
  </div>
  <div id="helpSectionText">
    <div class="help-title">
      [[getcustomizeMouseButtonsNudgeHeader_(selectedMouse.*)]]
    </div>
    <div class="secondary">
      [[getDescription_(selectedMouse.*)]]
    </div>
  </div>
</div>
<div id="buttonsSection">
  <customize-buttons-subsection
    button-remapping-list="{{selectedMouse.settings.buttonRemappings}}"
    action-list$="[[buttonActionList_]]"
    meta-key="[[metaKey_]]">
  </customize-buttons-subsection>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function objectsAreEqual(obj1, obj2) {
    const keys1 = Object.keys(obj1);
    const keys2 = Object.keys(obj2);
    if (keys1.length !== keys2.length) {
        return false;
    }
    for (let i = 0; i < keys1.length; i++) {
        const key = keys1[i];
        const val1 = obj1[key];
        const val2 = obj2[key];
        if (val1 instanceof Object || val2 instanceof Object) {
            if (!(val1 instanceof Object) || !(val2 instanceof Object) ||
                !objectsAreEqual(val1, val2)) {
                return false;
            }
        }
        else if (val1 !== val2) {
            return false;
        }
    }
    return true;
}
function deviceInList(deviceId, deviceList) {
    for (const device of deviceList) {
        if (device.id === deviceId) {
            return true;
        }
    }
    return false;
}
function settingsAreEqual(settings1, settings2) {
    return objectsAreEqual(settings1, settings2);
}
function buttonsAreEqual(button1, button2) {
    return objectsAreEqual(button1, button2);
}
function keyEventsAreEqual(keyEvent1, keyEvent2) {
    return objectsAreEqual(keyEvent1, keyEvent2);
}
function getPrefPolicyFields$1(policy) {
    if (policy) {
        const enforcement = policy.policyStatus === PolicyStatus$1.kManaged ?
            chrome.settingsPrivate.Enforcement.ENFORCED :
            chrome.settingsPrivate.Enforcement.RECOMMENDED;
        return {
            controlledBy: chrome.settingsPrivate.ControlledBy.USER_POLICY,
            enforcement,
            recommendedValue: policy.value,
        };
    }
    // These fields must be set back to undefined so the html badge is properly
    // removed from the UI.
    return {
        controlledBy: undefined,
        enforcement: undefined,
        recommendedValue: undefined,
    };
}
function getDeviceStateChangesToAnnounce(newDeviceList, prevDeviceList) {
    let msgId;
    let devices;
    if (newDeviceList.length > prevDeviceList.length) {
        devices = newDeviceList.filter((device) => !deviceInList(device.id, prevDeviceList));
        msgId = 'deviceConnectedA11yLabel';
    }
    else {
        msgId = 'deviceDisconnectedA11yLabel';
        devices = prevDeviceList.filter((device) => !deviceInList(device.id, newDeviceList));
    }
    return { msgId, deviceNames: devices.map(device => device.name) };
}
function createBluetoothDeviceProperties(id, publicName, batteryPercentage) {
    return {
        id: id,
        address: id,
        publicName: publicName,
        deviceType: DeviceType.kMouse,
        audioCapability: AudioOutputCapability.kNotCapableOfAudioOutput,
        connectionState: DeviceConnectionState.kConnected,
        isBlockedByPolicy: false,
        batteryInfo: {
            defaultProperties: { batteryPercentage },
            leftBudInfo: null,
            rightBudInfo: null,
            caseInfo: null,
        },
        imageInfo: null,
    };
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'settings-customize-mouse-buttons-subpage' displays the customized buttons
 * and allow users to configure their buttons for each mouse.
 */
const SettingsCustomizeMouseButtonsSubpageElementBase = RouteObserverMixin(I18nMixin(PolymerElement));
class SettingsCustomizeMouseButtonsSubpageElement extends SettingsCustomizeMouseButtonsSubpageElementBase {
    constructor() {
        super(...arguments);
        this.inputDeviceSettingsProvider_ = getInputDeviceSettingsProvider();
        this.previousRoute_ = null;
        this.isInitialized_ = false;
        this.metaKey_ = MetaKey$2.kSearch;
    }
    static get is() {
        return 'settings-customize-mouse-buttons-subpage';
    }
    static get template() {
        return getTemplate$38();
    }
    static get properties() {
        return {
            selectedMouse: {
                type: Object,
            },
            mouseList: {
                type: Array,
            },
            buttonActionList_: {
                type: Array,
            },
            mousePolicies: {
                type: Object,
            },
            primaryRightPref_: {
                type: Object,
                value() {
                    return {
                        key: 'fakePrimaryRightPref',
                        type: chrome.settingsPrivate.PrefType.BOOLEAN,
                        value: false,
                    };
                },
            },
            /**
             * Use metaKey to decide which meta key icon to display.
             */
            metaKey_: Object,
        };
    }
    static get observers() {
        return [
            'onMouseListUpdated(mouseList.*)',
            'onPoliciesChanged(mousePolicies)',
            'onSettingsChanged(primaryRightPref_.value)',
        ];
    }
    async connectedCallback() {
        super.connectedCallback();
        this.addEventListener('button-remapping-changed', this.onSettingsChanged);
        this.metaKey_ =
            (await this.inputDeviceSettingsProvider_.getMetaKeyToDisplay())
                ?.metaKey;
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        this.removeEventListener('button-remapping-changed', this.onSettingsChanged);
    }
    async currentRouteChanged(route) {
        // Does not apply to this page.
        if (route !== routes.CUSTOMIZE_MOUSE_BUTTONS) {
            if (this.previousRoute_ === routes.CUSTOMIZE_MOUSE_BUTTONS) {
                this.inputDeviceSettingsProvider_.stopObserving();
            }
            this.previousRoute_ = route;
            return;
        }
        this.previousRoute_ = route;
        if (!this.hasMice()) {
            return;
        }
        if (!this.selectedMouse ||
            this.selectedMouse.id !== this.getMouseIdFromUrl()) {
            await this.initializeMouse();
        }
        this.inputDeviceSettingsProvider_.startObserving(this.selectedMouse.id);
        getInstance().announce(this.getcustomizeMouseButtonsNudgeHeader_() + ' ' +
            this.getDescription_());
    }
    /**
     * Get the mouse to display according to the mouseId in the url query,
     * initializing the page and pref with the mouse data.
     */
    async initializeMouse() {
        this.isInitialized_ = false;
        const mouseId = this.getMouseIdFromUrl();
        const searchedMouse = this.mouseList.find((mouse) => mouse.id === mouseId);
        this.selectedMouse = castExists(searchedMouse);
        this.set('primaryRightPref_.value', this.selectedMouse.settings.swapRight);
        this.buttonActionList_ = (await this.inputDeviceSettingsProvider_
            .getActionsForMouseButtonCustomization())
            ?.options;
        this.isInitialized_ = true;
    }
    onPoliciesChanged() {
        this.primaryRightPref_ = {
            ...this.primaryRightPref_,
            ...getPrefPolicyFields$1(this.mousePolicies.swapRightPolicy),
        };
    }
    getMouseIdFromUrl() {
        return Number(Router.getInstance().getQueryParameters().get('mouseId'));
    }
    hasMice() {
        return this.mouseList?.length > 0;
    }
    isMouseConnected(id) {
        return !!this.mouseList.find(mouse => mouse.id === id);
    }
    async onMouseListUpdated() {
        if (Router.getInstance().currentRoute !== routes.CUSTOMIZE_MOUSE_BUTTONS) {
            return;
        }
        if (!this.hasMice()) {
            Router.getInstance().navigateTo(routes.DEVICE);
            return;
        }
        if (!this.isMouseConnected(this.getMouseIdFromUrl())) {
            Router.getInstance().navigateTo(routes.PER_DEVICE_MOUSE);
            return;
        }
        await this.initializeMouse();
        this.inputDeviceSettingsProvider_.startObserving(this.selectedMouse.id);
    }
    onSettingsChanged() {
        if (!this.isInitialized_) {
            return;
        }
        this.selectedMouse.settings.swapRight = this.primaryRightPref_.value;
        this.inputDeviceSettingsProvider_.setMouseSettings(this.selectedMouse.id, this.selectedMouse.settings);
    }
    getDescription_() {
        if (!this.selectedMouse?.name) {
            return '';
        }
        return this.i18n('customizeButtonSubpageDescription', this.selectedMouse.name);
    }
    getcustomizeMouseButtonsNudgeHeader_() {
        if (this.selectedMouse?.mouseButtonConfig !== MouseButtonConfig$1.kNoConfig) {
            return this.i18n('customizeMouseButtonsNudgeHeaderWithMetadata');
        }
        else {
            return this.i18n('customizeMouseButtonsNudgeHeaderWithoutMetadata');
        }
    }
}
customElements.define(SettingsCustomizeMouseButtonsSubpageElement.is, SettingsCustomizeMouseButtonsSubpageElement);

function getTemplate$37() {
    return html `<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">#helpSection{align-items:center;background-color:var(--cros-sys-app_base_shaded);border-radius:12px;display:flex;margin:8px;padding:16px 12px}#helpIconSection{--iron-icon-height:48px;--iron-icon-width:48px;flex-basis:48px}#helpSectionText{flex:1;margin-inline-start:12px}.help-title{color:var(--cros-text-color-primary);font:var(--cros-button-1-font);margin-bottom:5px}.secondary{font:var(--cros-body-2-font)}#buttonsSection{border-top:var(--cr-separator-line)}</style>
<div id="helpSection">
  <div id="helpIconSection">
    <iron-icon icon="os-settings:pen-buttons-banner"></iron-icon>
  </div>
  <div id="helpSectionText">
    <div class="help-title">
      [[getcustomizePenButtonsNudgeHeader_(selectedTablet.*)]]
    </div>
    <div class="secondary">
      [[getDescription_(selectedTablet.*)]]
    </div>
  </div>
</div>
<div id="buttonsSection">
  <customize-buttons-subsection
      button-remapping-list="{{selectedTablet.settings.penButtonRemappings}}"
      action-list$="[[buttonActionList_]]"
      meta-key="[[metaKey_]]">
  </customize-buttons-subsection>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'customize-pen-buttons-subpage' displays the customized pen buttons on
 * the graphics tablets, and allow users to configure the pen buttons for
 * each graphics tablet.
 */
const SettingsCustomizePenButtonsSubpageElementBase = RouteObserverMixin(I18nMixin(PolymerElement));
class SettingsCustomizePenButtonsSubpageElement extends SettingsCustomizePenButtonsSubpageElementBase {
    constructor() {
        super(...arguments);
        this.inputDeviceSettingsProvider_ = getInputDeviceSettingsProvider();
        this.previousRoute_ = null;
        this.isInitialized_ = false;
        this.metaKey_ = MetaKey$2.kSearch;
    }
    static get is() {
        return 'settings-customize-pen-buttons-subpage';
    }
    static get template() {
        return getTemplate$37();
    }
    static get properties() {
        return {
            selectedTablet: {
                type: Object,
            },
            graphicsTablets: {
                type: Array,
            },
            /**
             * Use metaKey to decide which meta key icon to display.
             */
            metaKey_: Object,
        };
    }
    static get observers() {
        return [
            'onGraphicsTabletListUpdated(graphicsTablets.*)',
        ];
    }
    async connectedCallback() {
        super.connectedCallback();
        this.addEventListener('button-remapping-changed', this.onSettingsChanged);
        this.metaKey_ =
            (await this.inputDeviceSettingsProvider_.getMetaKeyToDisplay())
                ?.metaKey;
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        this.removeEventListener('button-remapping-changed', this.onSettingsChanged);
    }
    async currentRouteChanged(route) {
        // Does not apply to this page.
        if (route !== routes.CUSTOMIZE_PEN_BUTTONS) {
            if (this.previousRoute_ === routes.CUSTOMIZE_PEN_BUTTONS) {
                this.inputDeviceSettingsProvider_.stopObserving();
            }
            this.previousRoute_ = route;
            return;
        }
        this.previousRoute_ = route;
        if (!this.hasGraphicsTablets()) {
            return;
        }
        if (!this.selectedTablet ||
            this.selectedTablet.id !== this.getGraphicsTabletIdFromUrl()) {
            await this.initializePen();
        }
        this.inputDeviceSettingsProvider_.startObserving(this.selectedTablet.id);
        getInstance().announce(this.getcustomizePenButtonsNudgeHeader_() + ' ' +
            this.getDescription_());
    }
    /**
     * Get the pen to display according to the graphicsTabletId in the url
     * query, initializing the page and pref with the graphics tablet data.
     */
    async initializePen() {
        this.isInitialized_ = false;
        const tabletId = this.getGraphicsTabletIdFromUrl();
        const searchedGraphicsTablet = this.graphicsTablets.find((graphicsTablet) => graphicsTablet.id === tabletId);
        this.selectedTablet = castExists(searchedGraphicsTablet);
        this.buttonActionList_ =
            (await this.inputDeviceSettingsProvider_
                .getActionsForGraphicsTabletButtonCustomization())
                ?.options;
        this.isInitialized_ = true;
    }
    getGraphicsTabletIdFromUrl() {
        return Number(Router.getInstance().getQueryParameters().get('graphicsTabletId'));
    }
    hasGraphicsTablets() {
        return this.graphicsTablets?.length > 0;
    }
    isTabletConnected(id) {
        return !!this.graphicsTablets.find(tablet => tablet.id === id);
    }
    async onGraphicsTabletListUpdated() {
        if (Router.getInstance().currentRoute !== routes.CUSTOMIZE_PEN_BUTTONS) {
            return;
        }
        if (!this.hasGraphicsTablets()) {
            Router.getInstance().navigateTo(routes.DEVICE);
            return;
        }
        if (!this.isTabletConnected(this.getGraphicsTabletIdFromUrl())) {
            Router.getInstance().navigateTo(routes.GRAPHICS_TABLET);
            return;
        }
        await this.initializePen();
        this.inputDeviceSettingsProvider_.startObserving(this.selectedTablet.id);
    }
    onSettingsChanged() {
        if (!this.isInitialized_) {
            return;
        }
        this.inputDeviceSettingsProvider_.setGraphicsTabletSettings(this.selectedTablet.id, this.selectedTablet.settings);
    }
    getDescription_() {
        if (!this.selectedTablet?.name) {
            return '';
        }
        return this.i18n('customizeTabletButtonSubpageDescription', this.selectedTablet.name);
    }
    getcustomizePenButtonsNudgeHeader_() {
        if (this.selectedTablet?.graphicsTabletButtonConfig !==
            GraphicsTabletButtonConfig$1.kNoConfig) {
            return this.i18n('customizePenButtonsNudgeHeaderWithMetadata');
        }
        else {
            return this.i18n('customizePenButtonsNudgeHeaderWithoutMetadata');
        }
    }
}
customElements.define(SettingsCustomizePenButtonsSubpageElement.is, SettingsCustomizePenButtonsSubpageElement);

function getTemplate$36() {
    return html `<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">#helpSection{align-items:center;background-color:var(--cros-sys-app_base_shaded);border-radius:12px;display:flex;margin:8px;padding:16px 12px}#helpIconSection{--iron-icon-height:48px;--iron-icon-width:48px;flex-basis:48px}#helpSectionText{flex:1;margin-inline-start:12px}.help-title{color:var(--cros-text-color-primary);font:var(--cros-button-1-font);margin-bottom:5px}.secondary{font:var(--cros-body-2-font)}#buttonsSection{border-top:var(--cr-separator-line)}</style>
<div id="helpSection">
  <div id="helpIconSection">
    <iron-icon icon="os-settings:tablet-buttons-banner"></iron-icon>
  </div>
  <div id="helpSectionText">
    <div class="help-title">
      [[getcustomizeTabletButtonsNudgeHeader_(selectedTablet.*)]]
    </div>
    <div class="secondary">
      [[getDescription_(selectedTablet.*)]]
    </div>
  </div>
</div>
<div id="buttonsSection">
  <customize-buttons-subsection
      button-remapping-list="{{selectedTablet.settings.tabletButtonRemappings}}"
      action-list$="[[buttonActionList_]]"
      meta-key="[[metaKey_]]">
  </customize-buttons-subsection>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'customize-tablet-buttons-subpage' displays the customized tablet buttons
 * and allow users to configure their tablet buttons for each graphics tablet.
 */
const SettingsCustomizeTabletButtonsSubpageElementBase = RouteObserverMixin(I18nMixin(PolymerElement));
class SettingsCustomizeTabletButtonsSubpageElement extends SettingsCustomizeTabletButtonsSubpageElementBase {
    constructor() {
        super(...arguments);
        this.inputDeviceSettingsProvider_ = getInputDeviceSettingsProvider();
        this.previousRoute_ = null;
        this.isInitialized_ = false;
        this.metaKey_ = MetaKey$2.kSearch;
    }
    static get is() {
        return 'settings-customize-tablet-buttons-subpage';
    }
    static get template() {
        return getTemplate$36();
    }
    static get properties() {
        return {
            selectedTablet: {
                type: Object,
            },
            graphicsTablets: {
                type: Array,
            },
            /**
             * Use metaKey to decide which meta key icon to display.
             */
            metaKey_: Object,
        };
    }
    static get observers() {
        return [
            'onGraphicsTabletListUpdated(graphicsTablets.*)',
        ];
    }
    async connectedCallback() {
        super.connectedCallback();
        this.addEventListener('button-remapping-changed', this.onSettingsChanged);
        this.metaKey_ =
            (await this.inputDeviceSettingsProvider_.getMetaKeyToDisplay())
                ?.metaKey;
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        this.removeEventListener('button-remapping-changed', this.onSettingsChanged);
    }
    async currentRouteChanged(route) {
        // Does not apply to this page.
        if (route !== routes.CUSTOMIZE_TABLET_BUTTONS) {
            if (this.previousRoute_ === routes.CUSTOMIZE_TABLET_BUTTONS) {
                this.inputDeviceSettingsProvider_.stopObserving();
            }
            this.previousRoute_ = route;
            return;
        }
        this.previousRoute_ = route;
        if (!this.hasGraphicsTablets()) {
            return;
        }
        if (!this.selectedTablet ||
            this.selectedTablet.id !== this.getGraphicsTabletIdFromUrl()) {
            await this.initializeTablet();
        }
        this.inputDeviceSettingsProvider_.startObserving(this.selectedTablet.id);
        getInstance().announce(this.getcustomizeTabletButtonsNudgeHeader_() + ' ' +
            this.getDescription_());
    }
    /**
     * Get the tablet to display according to the graphicsTabletId in the url
     * query, initializing the page and pref with the tablet data.
     */
    async initializeTablet() {
        this.isInitialized_ = false;
        const tabletId = this.getGraphicsTabletIdFromUrl();
        const searchedGraphicsTablet = this.graphicsTablets.find((graphicsTablet) => graphicsTablet.id === tabletId);
        this.selectedTablet = castExists(searchedGraphicsTablet);
        this.buttonActionList_ =
            (await this.inputDeviceSettingsProvider_
                .getActionsForGraphicsTabletButtonCustomization())
                ?.options;
        this.isInitialized_ = true;
    }
    getGraphicsTabletIdFromUrl() {
        return Number(Router.getInstance().getQueryParameters().get('graphicsTabletId'));
    }
    hasGraphicsTablets() {
        return this.graphicsTablets?.length > 0;
    }
    isTabletConnected(id) {
        return !!this.graphicsTablets.find(tablet => tablet.id === id);
    }
    async onGraphicsTabletListUpdated() {
        if (Router.getInstance().currentRoute !== routes.CUSTOMIZE_TABLET_BUTTONS) {
            return;
        }
        if (!this.hasGraphicsTablets()) {
            Router.getInstance().navigateTo(routes.DEVICE);
            return;
        }
        if (!this.isTabletConnected(this.getGraphicsTabletIdFromUrl())) {
            Router.getInstance().navigateTo(routes.GRAPHICS_TABLET);
            return;
        }
        await this.initializeTablet();
        this.inputDeviceSettingsProvider_.startObserving(this.selectedTablet.id);
    }
    onSettingsChanged() {
        if (!this.isInitialized_) {
            return;
        }
        this.inputDeviceSettingsProvider_.setGraphicsTabletSettings(this.selectedTablet.id, this.selectedTablet.settings);
    }
    getDescription_() {
        if (!this.selectedTablet?.name) {
            return '';
        }
        return this.i18n('customizeTabletButtonSubpageDescription', this.selectedTablet.name);
    }
    getcustomizeTabletButtonsNudgeHeader_() {
        if (this.selectedTablet?.graphicsTabletButtonConfig !==
            GraphicsTabletButtonConfig$1.kNoConfig) {
            return this.i18n('customizeTabletButtonsNudgeHeaderWithMetadata');
        }
        else {
            return this.i18n('customizeTabletButtonsNudgeHeaderWithoutMetadata');
        }
    }
}
customElements.define(SettingsCustomizeTabletButtonsSubpageElement.is, SettingsCustomizeTabletButtonsSubpageElement);

function getTemplate$35() {
    return html `<!--_html_template_start_--><style include="cr-hidden-style">:host{--cr-tabs-selected-color:var(--cros-sys-primary);cursor:pointer;display:flex;flex-direction:row;font-size:var(--cr-tabs-font-size,14px);font-weight:500;height:var(--cr-tabs-height,48px);user-select:none}.tab{align-items:center;color:var(--cr-secondary-text-color);display:flex;flex:var(--cr-tabs-flex,auto);height:100%;justify-content:center;opacity:.8;outline:none;padding:0 var(--cr-tabs-tab-inline-padding,0);position:relative;transition:opacity 100ms cubic-bezier(.4,0,1,1)}:host-context([chrome-refresh-2023]) .tab{opacity:1}:host-context(.focus-outline-visible) .tab:focus{outline:var(--cr-tabs-focus-outline,auto);outline-offset:var(--cr-tabs-focus-outline-offset,0)}.selected{color:var(--cr-tabs-selected-color);opacity:1}.tab-icon{-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:var(--cr-tabs-icon-size,var(--cr-icon-size));background-color:var(--cr-secondary-text-color);display:none;height:var(--cr-tabs-icon-size,var(--cr-icon-size));margin-inline-end:var(--cr-tabs-icon-margin-end,var(--cr-icon-size));width:var(--cr-tabs-icon-size,var(--cr-icon-size))}.selected .tab-icon{background-color:var(--cr-tabs-selected-color)}.tab-indicator{background:var(--cr-tabs-unselected-color);border-top-left-radius:var(--cr-tabs-selection-bar-radius,var(--cr-tabs-selection-bar-width,2px));border-top-right-radius:var(--cr-tabs-selection-bar-radius,var(--cr-tabs-selection-bar-width,2px));bottom:0;height:var(--cr-tabs-selection-bar-width,2px);left:var(--cr-tabs-tab-inline-padding,0);opacity:var(--cr-tabs-selection-bar-unselected-opacity,0);position:absolute;right:var(--cr-tabs-tab-inline-padding,0);transform-origin:left center;transition:transform}.selected .tab-indicator{background:var(--cr-tabs-selected-color);opacity:1}.tab-indicator.expand{transition-duration:150ms;transition-timing-function:cubic-bezier(.4,0,1,1)}.tab-indicator.contract{transition-duration:180ms;transition-timing-function:cubic-bezier(0,0,.2,1)}@media (forced-colors:active){.tab-indicator{background:SelectedItem}}</style>
<template is="dom-repeat" items="[[tabNames]]">
  <div
      role="tab"
      class$="tab [[getSelectedClass_(index, selected)]]"
      on-click="onTabClick_"
      aria-selected$="[[getAriaSelected_(index, selected)]]"
      tabindex$="[[getTabindex_(index, selected)]]">
    <div class="tab-icon" style$="[[getIconStyle_(index)]]">
    </div>
    [[item]]
    <div class="tab-indicator"></div>
  </div>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'cr-tabs' is a control used for selecting different sections or
 * tabs. cr-tabs was created to replace paper-tabs and paper-tab. cr-tabs
 * displays the name of each tab provided by |tabs|. A 'selected-changed' event
 * is fired any time |selected| is changed.
 *
 * cr-tabs takes its #selectionBar animation from paper-tabs.
 *
 * Keyboard behavior
 *   - Home, End, ArrowLeft and ArrowRight changes the tab selection
 *
 * Known limitations
 *   - no "disabled" state for the cr-tabs as a whole or individual tabs
 *   - cr-tabs does not accept any <slot> (not necessary as of this writing)
 *   - no horizontal scrolling, it is assumed that tabs always fit in the
 *     available space
 *
 * Forked from ui/webui/resources/cr_elements/cr_tabs/cr_tabs.ts
 */
class CrTabsElement extends PolymerElement {
    constructor() {
        super(...arguments);
        this.isRtl_ = false;
        this.lastSelected_ = null;
    }
    static get is() {
        return 'cr-tabs';
    }
    static get template() {
        return getTemplate$35();
    }
    static get properties() {
        return {
            // Optional icon urls displayed in each tab.
            tabIcons: {
                type: Array,
                value: () => [],
            },
            // Tab names displayed in each tab.
            tabNames: {
                type: Array,
                value: () => [],
            },
            /** Index of the selected tab. */
            selected: {
                type: Number,
                notify: true,
                observer: 'onSelectedChanged_',
            },
        };
    }
    connectedCallback() {
        super.connectedCallback();
        this.isRtl_ = this.matches(':host-context([dir=rtl]) cr-tabs');
    }
    ready() {
        super.ready();
        this.setAttribute('role', 'tablist');
        this.addEventListener('keydown', this.onKeyDown_.bind(this));
    }
    getAriaSelected_(index) {
        return index === this.selected ? 'true' : 'false';
    }
    getIconStyle_(index) {
        const icon = this.tabIcons[index];
        return icon ? `-webkit-mask-image: url(${icon}); display: block;` : '';
    }
    getTabindex_(index) {
        return index === this.selected ? '0' : '-1';
    }
    getSelectedClass_(index) {
        return index === this.selected ? 'selected' : '';
    }
    onSelectedChanged_(newSelected, oldSelected) {
        const tabs = this.shadowRoot.querySelectorAll('.tab');
        if (tabs.length === 0 || oldSelected === undefined ||
            tabs.length <= newSelected || tabs.length <= oldSelected) {
            // Tabs are not fully rendered yet.
            return;
        }
        const oldTabRect = tabs[oldSelected].getBoundingClientRect();
        const newTabRect = tabs[newSelected].getBoundingClientRect();
        const newIndicator = tabs[newSelected].querySelector('.tab-indicator');
        newIndicator.classList.remove('expand', 'contract');
        // Make new indicator look like it is the old indicator.
        this.updateIndicator_(newIndicator, newTabRect, oldTabRect.left, oldTabRect.width);
        newIndicator.getBoundingClientRect(); // Force repaint.
        // Expand to cover both the previous selected tab, the newly selected tab,
        // and everything in between.
        newIndicator.classList.add('expand');
        newIndicator.addEventListener('transitionend', e => this.onIndicatorTransitionEnd_(e), { once: true });
        const leftmostEdge = Math.min(oldTabRect.left, newTabRect.left);
        const fullWidth = newTabRect.left > oldTabRect.left ?
            newTabRect.right - oldTabRect.left :
            oldTabRect.right - newTabRect.left;
        this.updateIndicator_(newIndicator, newTabRect, leftmostEdge, fullWidth);
    }
    onKeyDown_(e) {
        const count = this.tabNames.length;
        let newSelection;
        if (e.key === 'Home') {
            newSelection = 0;
        }
        else if (e.key === 'End') {
            newSelection = count - 1;
        }
        else if (e.key === 'ArrowLeft' || e.key === 'ArrowRight') {
            const delta = e.key === 'ArrowLeft' ? (this.isRtl_ ? 1 : -1) :
                (this.isRtl_ ? -1 : 1);
            newSelection = (count + this.selected + delta) % count;
        }
        else {
            return;
        }
        e.preventDefault();
        e.stopPropagation();
        this.selected = newSelection;
        this.shadowRoot.querySelector('.tab.selected').focus();
    }
    onIndicatorTransitionEnd_(event) {
        const indicator = event.target;
        indicator.classList.replace('expand', 'contract');
        indicator.style.transform = `translateX(0) scaleX(1)`;
    }
    onTabClick_(e) {
        this.selected = e.model.index;
    }
    updateIndicator_(indicator, originRect, newLeft, newWidth) {
        const leftDiff = 100 * (newLeft - originRect.left) / originRect.width;
        const widthRatio = newWidth / originRect.width;
        const transform = `translateX(${leftDiff}%) scaleX(${widthRatio})`;
        indicator.style.transform = transform;
    }
}
customElements.define(CrTabsElement.is, CrTabsElement);

function getTemplate$34() {
    return html `<!--_html_template_start_--><style include="settings-shared">#displayArea{height:100%;overflow:hidden;position:relative;width:100%}.display{align-items:center;background:var(--cros-textfield-background-color);color:var(--cros-text-color-secondary);cursor:default;display:flex;font-size:100%;font-weight:500;justify-content:center;margin:4px;padding:3px;position:absolute;text-align:center}.display[selected]{border:var(--cros-icon-color-prominent) solid 1px}.display.mirror{border:var(--cros-icon-color-prominent) solid 1px}.highlight-left{border-left:var(--cros-icon-color-prominent) solid 1px}.highlight-right{border-right:var(--cros-icon-color-prominent) solid 1px}.highlight-top{border-top:var(--cros-icon-color-prominent) solid 1px}.highlight-bottom{border-bottom:var(--cros-icon-color-prominent) solid 1px}.display.elevate{box-shadow:var(--cr-elevation-3)}</style>
<div id="displayArea" on-iron-resize="calculateVisualScale_">
  <template is="dom-repeat" items="[[mirroringDestinationIds_]]">
    <div id="_mirror_[[item]]" class="display mirror"
        hidden$="[[!mirroring]]"
        style$="[[getMirrorDivStyle_(index, mirroringDestinationIds_.length,
                                     displays, visualScale)]]">
    </div>
  </template>
  <template is="dom-repeat" items="[[displays]]">
    <div id="_[[item.id]]" class="display elevate"
        draggable="[[dragEnabled]]" on-focus="onFocus_"
        on-click="onSelectDisplayClick_"
        style$="[[getDivStyle_(item.id, item.bounds, visualScale)]]"
        selected$="[[isSelected_(item, selectedDisplay)]]"
        tabindex="0">
    </div>
  </template>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Behavior for handling dragging elements in a container.
 *     Draggable elements must have the 'draggable' attribute set.
 */
/**
 * Type of an ongoing drag.
 */
var DragType;
(function (DragType) {
    DragType[DragType["NONE"] = 0] = "NONE";
    DragType[DragType["CURSOR"] = 1] = "CURSOR";
    DragType[DragType["KEYBOARD"] = 2] = "KEYBOARD";
})(DragType || (DragType = {}));
const DragMixin = dedupingMixin((baseClass) => {
    class DragMixinInternal extends baseClass {
        constructor() {
            super(...arguments);
            /**
             * The id of the element being dragged, or empty if not dragging.
             */
            this.dragId = '';
            /**
             * The type of the currently ongoing drag.  If a keyboard drag is
             * ongoing and the user initiates a cursor drag, the keyboard drag
             * should end before the cursor drag starts.  If a cursor drag is
             * onging, keyboard dragging should be ignored.
             */
            this.dragType_ = DragType.NONE;
            this.dragStartLocation_ = { x: 0, y: 0 };
            /**
             * Used to ignore unnecessary drag events.
             */
            this.lastTouchLocation_ = null;
            this.mouseDownListener_ = this.onMouseDown_.bind(this);
            this.mouseMoveListener_ = this.onMouseMove_.bind(this);
            this.touchStartListener_ = this.onTouchStart_.bind(this);
            this.touchMoveListener_ = this.onTouchMove_.bind(this);
            this.keyDownListener_ = this.onKeyDown_.bind(this);
            this.endDragListener_ = this.endCursorDrag_.bind(this);
        }
        static get properties() {
            return {
                /** Whether or not drag is enabled (e.g. not mirrored). */
                dragEnabled: Boolean,
                /**
                 * Whether or not to allow keyboard dragging.  If set to false,
                 * all keystrokes will be ignored by this element.
                 */
                keyboardDragEnabled: {
                    type: Boolean,
                    value: false,
                },
                /**
                 * The number of pixels to drag on each keypress.
                 */
                keyboardDragStepSize: {
                    type: Number,
                    value: 20,
                },
            };
        }
        initializeDrag(enabled, container, callback) {
            this.dragEnabled = enabled;
            if (!enabled) {
                this.removeListeners_();
                return;
            }
            if (container) {
                this.container_ = container;
            }
            if (callback) {
                this.callback_ = callback;
            }
            this.addListeners_();
        }
        addListeners_() {
            const container = this.container_;
            if (!container) {
                return;
            }
            container.addEventListener('mousedown', this.mouseDownListener_);
            container.addEventListener('mousemove', this.mouseMoveListener_);
            container.addEventListener('touchstart', this.touchStartListener_);
            container.addEventListener('touchmove', this.touchMoveListener_);
            container.addEventListener('keydown', this.keyDownListener_);
            container.addEventListener('touchend', this.endDragListener_);
            window.addEventListener('mouseup', this.endDragListener_);
        }
        removeListeners_() {
            const container = this.container_;
            if (!container || !this.mouseDownListener_) {
                return;
            }
            container.removeEventListener('mousedown', this.mouseDownListener_);
            container.removeEventListener('mousemove', this.mouseMoveListener_);
            container.removeEventListener('touchstart', this.touchStartListener_);
            container.removeEventListener('touchmove', this.touchMoveListener_);
            container.removeEventListener('keydown', this.keyDownListener_);
            container.removeEventListener('touchend', this.endDragListener_);
            window.removeEventListener('mouseup', this.endDragListener_);
        }
        onMouseDown_(e) {
            const target = cast(e.target, HTMLElement);
            if (e.button !== 0 || !target.getAttribute('draggable')) {
                return true;
            }
            e.preventDefault();
            return this.startCursorDrag_(target, { x: e.pageX, y: e.pageY });
        }
        onMouseMove_(e) {
            e.preventDefault();
            return this.processCursorDrag_({ x: e.pageX, y: e.pageY });
        }
        onTouchStart_(e) {
            if (e.touches.length !== 1) {
                return false;
            }
            e.preventDefault();
            const target = cast(e.target, HTMLElement);
            const touch = e.touches[0];
            this.lastTouchLocation_ = { x: touch.pageX, y: touch.pageY };
            return this.startCursorDrag_(target, this.lastTouchLocation_);
        }
        onTouchMove_(e) {
            if (e.touches.length !== 1) {
                return true;
            }
            const touchLocation = { x: e.touches[0].pageX, y: e.touches[0].pageY };
            // Touch move events can happen even if the touch location doesn't
            // change and on small unintentional finger movements. Ignore these
            // small changes.
            if (this.lastTouchLocation_) {
                const IGNORABLE_TOUCH_MOVE_PX = 1;
                const xDiff = Math.abs(touchLocation.x - this.lastTouchLocation_.x);
                const yDiff = Math.abs(touchLocation.y - this.lastTouchLocation_.y);
                if (xDiff <= IGNORABLE_TOUCH_MOVE_PX &&
                    yDiff <= IGNORABLE_TOUCH_MOVE_PX) {
                    return true;
                }
            }
            this.lastTouchLocation_ = touchLocation;
            e.preventDefault();
            return this.processCursorDrag_(touchLocation);
        }
        onKeyDown_(e) {
            // Ignore keystrokes if keyboard dragging is disabled.
            if (this.keyboardDragEnabled === false) {
                return true;
            }
            // Ignore keystrokes if the event target is not draggable.
            const target = cast(e.target, HTMLElement);
            if (!target.getAttribute('draggable')) {
                return true;
            }
            // Keyboard drags should not interrupt cursor drags.
            if (this.dragType_ === DragType.CURSOR) {
                return true;
            }
            let delta;
            switch (e.key) {
                case 'ArrowUp':
                    delta = { x: 0, y: -this.keyboardDragStepSize };
                    break;
                case 'ArrowDown':
                    delta = { x: 0, y: this.keyboardDragStepSize };
                    break;
                case 'ArrowLeft':
                    delta = { x: -this.keyboardDragStepSize, y: 0 };
                    break;
                case 'ArrowRight':
                    delta = { x: this.keyboardDragStepSize, y: 0 };
                    break;
                case 'Enter':
                    e.preventDefault();
                    this.endKeyboardDrag_();
                    return false;
                default:
                    return true;
            }
            e.preventDefault();
            if (this.dragType_ === DragType.NONE) {
                // Start drag
                this.startKeyboardDrag_(target);
            }
            this.dragOffset_.x += delta.x;
            this.dragOffset_.y += delta.y;
            this.processKeyboardDrag_(this.dragOffset_);
            return false;
        }
        startCursorDrag_(target, eventLocation) {
            assert(this.dragEnabled);
            if (this.dragType_ === DragType.KEYBOARD) {
                this.endKeyboardDrag_();
            }
            this.dragId = target.id;
            this.dragStartLocation_ = eventLocation;
            this.dragType_ = DragType.CURSOR;
            return false;
        }
        endCursorDrag_() {
            assert(this.dragEnabled);
            if (this.dragType_ === DragType.CURSOR && this.callback_) {
                this.callback_(this.dragId, null);
            }
            this.cleanupDrag_();
            return false;
        }
        processCursorDrag_(eventLocation) {
            assert(this.dragEnabled);
            if (this.dragType_ !== DragType.CURSOR) {
                return true;
            }
            this.executeCallback_(eventLocation);
            return false;
        }
        startKeyboardDrag_(target) {
            assert(this.dragEnabled);
            if (this.dragType_ === DragType.CURSOR) {
                this.endCursorDrag_();
            }
            this.dragId = target.id;
            this.dragStartLocation_ = { x: 0, y: 0 };
            this.dragOffset_ = { x: 0, y: 0 };
            this.dragType_ = DragType.KEYBOARD;
        }
        endKeyboardDrag_() {
            assert(this.dragEnabled);
            if (this.dragType_ === DragType.KEYBOARD && this.callback_) {
                this.callback_(this.dragId, null);
            }
            this.cleanupDrag_();
        }
        processKeyboardDrag_(dragPosition) {
            assert(this.dragEnabled);
            if (this.dragType_ !== DragType.KEYBOARD) {
                return true;
            }
            this.executeCallback_(dragPosition);
            return false;
        }
        /**
         * Cleans up state for all currently ongoing drags.
         */
        cleanupDrag_() {
            this.dragId = '';
            this.dragStartLocation_ = { x: 0, y: 0 };
            this.lastTouchLocation_ = null;
            this.dragType_ = DragType.NONE;
        }
        executeCallback_(dragPosition) {
            if (this.callback_) {
                const delta = {
                    x: dragPosition.x - this.dragStartLocation_.x,
                    y: dragPosition.y - this.dragStartLocation_.y,
                };
                this.callback_(this.dragId, delta);
            }
        }
    }
    return DragMixinInternal;
});

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Behavior for handling display layout, specifically
 *     edge snapping and collisions.
 */
var LayoutPosition = chrome.system.display.LayoutPosition;
const LayoutMixin = dedupingMixin((superClass) => {
    const superClassBase = DragMixin(superClass);
    class LayoutMixinInternal extends superClassBase {
        constructor() {
            super(...arguments);
            /**
             * The calculated bounds used for generating the div bounds.
             */
            this.calculatedBoundsMap_ = new Map();
            this.displayBoundsMap_ = new Map();
            this.displayLayoutMap_ = new Map();
            this.dragBounds_ = undefined;
            this.dragLayoutId_ = '';
            this.dragLayoutPosition_ = undefined;
            this.dragParentId_ = '';
        }
        static get properties() {
            return {
                layouts: Array,
                mirroring: {
                    type: Boolean,
                    value: false,
                },
            };
        }
        getDisplayLayoutMapForTesting() {
            return this.displayLayoutMap_;
        }
        initializeDisplayLayout(displays, layouts) {
            this.dragLayoutId_ = '';
            this.dragParentId_ = '';
            this.mirroring =
                displays.length > 0 && !!displays[0].mirroringSourceId;
            this.displayBoundsMap_.clear();
            for (const display of displays) {
                this.displayBoundsMap_.set(display.id, display.bounds);
            }
            this.displayLayoutMap_.clear();
            for (const layout of layouts) {
                this.displayLayoutMap_.set(layout.id, layout);
            }
            this.calculatedBoundsMap_.clear();
            for (const display of displays) {
                if (!this.calculatedBoundsMap_.has(display.id)) {
                    const bounds = display.bounds;
                    this.calculateBounds_(display.id, bounds.width, bounds.height);
                }
            }
        }
        updateDisplayBounds(id, newBounds) {
            this.dragLayoutId_ = id;
            // Find the closest parent.
            const closestId = this.findClosest_(id, newBounds);
            assert(closestId);
            // Find the closest edge.
            const closestBounds = this.getCalculatedDisplayBounds(closestId);
            const layoutPosition = this.getLayoutPositionForBounds_(newBounds, closestBounds);
            // Snap to the closest edge.
            const snapPos = this.snapBounds_(newBounds, closestId, layoutPosition);
            newBounds.left = snapPos.x;
            newBounds.top = snapPos.y;
            // Calculate the new bounds and delta.
            const oldBounds = this.dragBounds_ || this.getCalculatedDisplayBounds(id);
            const deltaPos = {
                x: newBounds.left - oldBounds.left,
                y: newBounds.top - oldBounds.top,
            };
            // Check for collisions after snapping. This should not collide with
            // the closest parent.
            this.collideAndModifyDelta_(id, oldBounds, deltaPos);
            // If the edge changed, update and highlight it.
            if (layoutPosition !== this.dragLayoutPosition_ ||
                closestId !== this.dragParentId_) {
                this.dragLayoutPosition_ = layoutPosition;
                this.dragParentId_ = closestId;
                this.highlightEdge_(closestId, layoutPosition);
            }
            newBounds.left = oldBounds.left + deltaPos.x;
            newBounds.top = oldBounds.top + deltaPos.y;
            this.dragBounds_ = newBounds;
            return newBounds;
        }
        finishUpdateDisplayBounds(id) {
            this.highlightEdge_('', undefined); // Remove any highlights.
            if (id !== this.dragLayoutId_ || !this.dragBounds_ ||
                !this.dragLayoutPosition_) {
                return;
            }
            const layout = this.displayLayoutMap_.get(id);
            let orphanIds;
            if (!layout || layout.parentId === '') {
                // Primary display. Set the calculated position to |dragBounds_|.
                this.setCalculatedDisplayBounds_(id, this.dragBounds_);
                // We cannot re-parent the primary display, so instead make all
                // other displays orphans and clear their calculated bounds.
                orphanIds = this.findChildren_(id, /* recurse= */ true);
                // Re-parent |dragParentId_|. It will be forced to parent to the
                // dragged display since it is the only non-orphan.
                this.reparentOrphan_(this.dragParentId_, orphanIds);
                orphanIds.splice(orphanIds.indexOf(this.dragParentId_), 1);
            }
            else {
                // All immediate children of |layout| will need to be re-parented.
                orphanIds = this.findChildren_(id, false /* do not recurse */);
                // When re-parenting to a descendant, also parent any immediate
                // child to drag display's current parent.
                let topLayout = this.displayLayoutMap_.get(this.dragParentId_);
                while (topLayout && topLayout.parentId !== '') {
                    if (topLayout.parentId === id) {
                        topLayout.parentId = layout.parentId;
                        break;
                    }
                    topLayout = this.displayLayoutMap_.get(topLayout.parentId);
                }
                // Re-parent the dragged display.
                layout.parentId = this.dragParentId_;
                this.updateOffsetAndPosition_(this.dragBounds_, this.dragLayoutPosition_, layout);
            }
            // Update any orphaned children. This may cause the dragged display to
            // be re-attached if it was attached to a child.
            this.updateOrphans_(orphanIds);
            // Send the updated layouts.
            getDisplayApi().setDisplayLayout(this.layouts).then(() => {
                if (chrome.runtime.lastError) {
                    console.error('setDisplayLayout Error: ' +
                        chrome.runtime.lastError.message);
                }
            });
        }
        getCalculatedDisplayBounds(displayId, notest) {
            const bounds = this.calculatedBoundsMap_.get(displayId);
            assert(notest || bounds);
            return bounds;
        }
        setCalculatedDisplayBounds_(displayId, bounds) {
            assert(bounds);
            this.calculatedBoundsMap_.set(displayId, { ...bounds });
        }
        /**
         * Re-parents all entries in |orphanIds| and any children.
         * @param orphanIds The list of ids affected by the move.
         */
        updateOrphans_(orphanIds) {
            const orphans = orphanIds.slice();
            for (let i = 0; i < orphanIds.length; ++i) {
                const orphan = orphanIds[i];
                const newOrphans = this.findChildren_(orphan, true /* recurse */);
                // If the dragged display was re-parented to one of its children,
                // there may be duplicates so merge the lists.
                for (let j = 0; j < newOrphans.length; ++j) {
                    const o = newOrphans[j];
                    if (!orphans.includes(o)) {
                        orphans.push(o);
                    }
                }
            }
            // Remove each orphan from the list as it is re-parented so that
            // subsequent orphans can be parented to it.
            while (orphans.length) {
                const orphanId = orphans.shift();
                this.reparentOrphan_(orphanId, orphans);
            }
        }
        /**
         * Re-parents the orphan to a layout that is not a member of
         * |otherOrphanIds|.
         * @param orphanId The id of the orphan to re-parent.
         * @param otherOrphanIds The list of ids of other orphans
         *     to ignore when re-parenting.
         */
        reparentOrphan_(orphanId, otherOrphanIds) {
            const layout = this.displayLayoutMap_.get(orphanId);
            assert(layout);
            if (orphanId === this.dragId && layout.parentId !== '') {
                this.setCalculatedDisplayBounds_(orphanId, this.dragBounds_);
                return;
            }
            const bounds = this.getCalculatedDisplayBounds(orphanId);
            // Find the closest parent.
            const newParentId = this.findClosest_(orphanId, bounds, otherOrphanIds);
            assert(newParentId !== '');
            layout.parentId = newParentId;
            // Find the closest edge.
            const parentBounds = this.getCalculatedDisplayBounds(newParentId);
            const layoutPosition = this.getLayoutPositionForBounds_(bounds, parentBounds);
            // Move from the nearest corner to the desired location and get the
            // delta.
            const cornerBounds = this.getCornerBounds_(bounds, parentBounds);
            const desiredPos = this.snapBounds_(bounds, newParentId, layoutPosition);
            const deltaPos = {
                x: desiredPos.x - cornerBounds.left,
                y: desiredPos.y - cornerBounds.top,
            };
            // Check for collisions.
            this.collideAndModifyDelta_(orphanId, cornerBounds, deltaPos);
            const desiredBounds = {
                left: cornerBounds.left + deltaPos.x,
                top: cornerBounds.top + deltaPos.y,
                width: bounds.width,
                height: bounds.height,
            };
            this.updateOffsetAndPosition_(desiredBounds, layoutPosition, layout);
        }
        /**
         * @param recurse Whether or not to include descendants of children.
         */
        findChildren_(parentId, recurse) {
            let children = [];
            this.displayLayoutMap_.forEach((value, key) => {
                const childId = key;
                if (childId !== parentId && value.parentId === parentId) {
                    // Insert immediate children at the front of the array.
                    children.unshift(childId);
                    if (recurse) {
                        // Descendants get added to the end of the list.
                        children = children.concat(this.findChildren_(childId, true));
                    }
                }
            });
            return children;
        }
        /**
         * Recursively calculates the absolute bounds of a display.
         * Caches the display bounds so that parent bounds are only calculated
         * once.
         */
        calculateBounds_(id, width, height) {
            let left;
            let top;
            const layout = this.displayLayoutMap_.get(id);
            if (this.mirroring || !layout || !layout.parentId) {
                left = -width / 2;
                top = -height / 2;
            }
            else {
                if (!this.calculatedBoundsMap_.has(layout.parentId)) {
                    const pbounds = this.displayBoundsMap_.get(layout.parentId);
                    this.calculateBounds_(layout.parentId, pbounds.width, pbounds.height);
                }
                const parentBounds = this.getCalculatedDisplayBounds(layout.parentId);
                left = parentBounds.left;
                top = parentBounds.top;
                switch (layout.position) {
                    case LayoutPosition.TOP:
                        left += layout.offset;
                        top -= height;
                        break;
                    case LayoutPosition.RIGHT:
                        left += parentBounds.width;
                        top += layout.offset;
                        break;
                    case LayoutPosition.BOTTOM:
                        left += layout.offset;
                        top += parentBounds.height;
                        break;
                    case LayoutPosition.LEFT:
                        left -= width;
                        top += layout.offset;
                        break;
                }
            }
            const result = {
                left,
                top,
                width,
                height,
            };
            this.setCalculatedDisplayBounds_(id, result);
        }
        /**
         * Finds the display closest to |bounds| ignoring |ignoreIds|.
         */
        findClosest_(displayId, bounds, ignoreIds) {
            const x = bounds.left + bounds.width / 2;
            const y = bounds.top + bounds.height / 2;
            let closestId = '';
            let closestDelta2 = 0;
            const keys = this.calculatedBoundsMap_.keys();
            for (let iter = keys.next(); !iter.done; iter = keys.next()) {
                const otherId = iter.value;
                if (otherId === displayId) {
                    continue;
                }
                if (ignoreIds && ignoreIds.includes(otherId)) {
                    continue;
                }
                const { left, top, width, height } = this.getCalculatedDisplayBounds(otherId);
                if (x >= left && x < left + width && y >= top && y < top + height) {
                    return otherId;
                } // point is inside rect
                let dx;
                let dy;
                if (x < left) {
                    dx = left - x;
                }
                else if (x > left + width) {
                    dx = x - (left + width);
                }
                else {
                    dx = 0;
                }
                if (y < top) {
                    dy = top - y;
                }
                else if (y > top + height) {
                    dy = y - (top + height);
                }
                else {
                    dy = 0;
                }
                const delta2 = dx * dx + dy * dy;
                if (closestId === '' || delta2 < closestDelta2) {
                    closestId = otherId;
                    closestDelta2 = delta2;
                }
            }
            return closestId;
        }
        /**
         * Calculates the LayoutPosition for |bounds| relative to |parentId|.
         */
        getLayoutPositionForBounds_(bounds, parentBounds) {
            // Translate bounds from top-left to center.
            const x = bounds.left + bounds.width / 2;
            const y = bounds.top + bounds.height / 2;
            // Determine the distance from the new bounds to both of the near
            // edges.
            const { left, top, width, height } = parentBounds;
            // Signed deltas to the center.
            const dx = x - (left + width / 2);
            const dy = y - (top + height / 2);
            // Unsigned distance to each edge.
            const distx = Math.abs(dx) - width / 2;
            const disty = Math.abs(dy) - height / 2;
            if (distx > disty) {
                if (dx < 0) {
                    return LayoutPosition.LEFT;
                }
                return LayoutPosition.RIGHT;
            }
            else {
                if (dy < 0) {
                    return LayoutPosition.TOP;
                }
                return LayoutPosition.BOTTOM;
            }
        }
        /**
         * Modifies |bounds| to the position closest to it along the edge of
         * |parentId| specified by |layoutPosition|.
         */
        snapBounds_(bounds, parentId, layoutPosition) {
            const parentBounds = this.getCalculatedDisplayBounds(parentId);
            let x;
            if (layoutPosition === LayoutPosition.LEFT) {
                x = parentBounds.left - bounds.width;
            }
            else if (layoutPosition === LayoutPosition.RIGHT) {
                x = parentBounds.left + parentBounds.width;
            }
            else {
                x = this.snapToX_(bounds, parentBounds);
            }
            let y;
            if (layoutPosition === LayoutPosition.TOP) {
                y = parentBounds.top - bounds.height;
            }
            else if (layoutPosition === LayoutPosition.BOTTOM) {
                y = parentBounds.top + parentBounds.height;
            }
            else {
                y = this.snapToY_(bounds, parentBounds);
            }
            return { x, y };
        }
        /**
         * Snaps a horizontal value, see snapToEdge.
         * @param snapDistance Optionally provide to override the snap distance.
         *     0 means snap from any distance.
         */
        snapToX_(newBounds, parentBounds, snapDistance) {
            return this.snapToEdge_(newBounds.left, newBounds.width, parentBounds.left, parentBounds.width, snapDistance);
        }
        /**
         * Snaps a vertical value, see snapToEdge.
         * @param snapDistance Optionally provide to override the snap distance.
         *     0 means snap from any distance.
         */
        snapToY_(newBounds, parentBounds, snapDistance) {
            return this.snapToEdge_(newBounds.top, newBounds.height, parentBounds.top, parentBounds.height, snapDistance);
        }
        /**
         * Snaps the region [point, width] to [basePoint, baseWidth] if
         * the [point, width] is close enough to the base's edge.
         * @param snapDistance Provide to override the snap distance.
         *     0 means snap at any distance.
         * @return The moved point. Returns the point itself if it doesn't
         *     need to snap to the edge.
         */
        snapToEdge_(point, width, basePoint, baseWidth, snapDistance) {
            // If the edge of the region is smaller than this, it will snap to the
            // base's edge.
            const SNAP_DISTANCE_PX = 16;
            const snapDist = (snapDistance !== undefined) ? snapDistance : SNAP_DISTANCE_PX;
            const startDiff = Math.abs(point - basePoint);
            const endDiff = Math.abs(point + width - (basePoint + baseWidth));
            // Prefer the closer one if both edges are close enough.
            if ((!snapDist || startDiff < snapDist) && startDiff < endDiff) {
                return basePoint;
            }
            else if (!snapDist || endDiff < snapDist) {
                return basePoint + baseWidth - width;
            }
            return point;
        }
        /**
         * Intersects |layout| with each other layout and reduces |deltaPos| to
         * avoid any collisions (or sets it to [0,0] if the display can not be
         * moved in the direction of |deltaPos|). Note: this assumes that
         * deltaPos is already 'snapped' to the parent edge, and therefore will
         * not collide with the parent, i.e. this is to prevent overlapping with
         * displays other than the parent.
         */
        collideAndModifyDelta_(id, bounds, deltaPos) {
            const keys = this.calculatedBoundsMap_.keys();
            const others = new Set(keys);
            others.delete(id);
            let checkCollisions = true;
            while (checkCollisions) {
                checkCollisions = false;
                const othersValues = others.values();
                for (let iter = othersValues.next(); !iter.done; iter = othersValues.next()) {
                    const otherId = iter.value;
                    const otherBounds = this.getCalculatedDisplayBounds(otherId);
                    if (this.collideWithBoundsAndModifyDelta_(bounds, otherBounds, deltaPos)) {
                        if (deltaPos.x === 0 && deltaPos.y === 0) {
                            return;
                        }
                        others.delete(otherId);
                        checkCollisions = true;
                        break;
                    }
                }
            }
        }
        /**
         * Intersects |bounds| with |otherBounds|. If there is a collision,
         * modifies |deltaPos| to limit movement to a single axis and avoid the
         * collision and returns true. See note for |collideAndModifyDelta_|.
         */
        collideWithBoundsAndModifyDelta_(bounds, otherBounds, deltaPos) {
            const newX = bounds.left + deltaPos.x;
            const newY = bounds.top + deltaPos.y;
            if ((newX + bounds.width <= otherBounds.left) ||
                (newX >= otherBounds.left + otherBounds.width) ||
                (newY + bounds.height <= otherBounds.top) ||
                (newY >= otherBounds.top + otherBounds.height)) {
                return false;
            }
            // |deltaPos| should already be restricted to X or Y. This shortens
            // the delta to stay outside the bounds, however it does not change
            // the sign of the delta, i.e. it does not "push" the point outside
            // the bounds if the point is already inside.
            if (Math.abs(deltaPos.x) > Math.abs(deltaPos.y)) {
                deltaPos.y = 0;
                let snapDeltaX;
                if (deltaPos.x > 0) {
                    snapDeltaX =
                        Math.max(0, (otherBounds.left - bounds.width) - bounds.left);
                }
                else {
                    snapDeltaX = Math.min(0, (otherBounds.left + otherBounds.width) - bounds.left);
                }
                deltaPos.x = snapDeltaX;
            }
            else {
                deltaPos.x = 0;
                let snapDeltaY;
                if (deltaPos.y > 0) {
                    snapDeltaY =
                        Math.min(0, (otherBounds.top - bounds.height) - bounds.top);
                }
                else if (deltaPos.y < 0) {
                    snapDeltaY = Math.max(0, (otherBounds.top + otherBounds.height) - bounds.top);
                }
                else {
                    snapDeltaY = 0;
                }
                deltaPos.y = snapDeltaY;
            }
            return true;
        }
        /**
         * Updates the offset for |layout| from |bounds|.
         */
        updateOffsetAndPosition_(bounds, position, layout) {
            layout.position = position;
            if (!layout.parentId) {
                layout.offset = 0;
                return;
            }
            // Offset is calculated from top or left edge.
            const parentBounds = this.getCalculatedDisplayBounds(layout.parentId);
            let offset;
            let minOffset;
            let maxOffset;
            if (position === LayoutPosition.LEFT ||
                position === LayoutPosition.RIGHT) {
                offset = bounds.top - parentBounds.top;
                minOffset = -bounds.height;
                maxOffset = parentBounds.height;
            }
            else {
                offset = bounds.left - parentBounds.left;
                minOffset = -bounds.width;
                maxOffset = parentBounds.width;
            }
            const MIN_OFFSET_OVERLAP = 50;
            minOffset += MIN_OFFSET_OVERLAP;
            maxOffset -= MIN_OFFSET_OVERLAP;
            layout.offset = Math.max(minOffset, Math.min(offset, maxOffset));
            // Update the calculated bounds to match the new offset.
            this.calculateBounds_(layout.id, bounds.width, bounds.height);
        }
        /**
         * Returns |bounds| translated to touch the closest corner of
         * |parentBounds|.
         */
        getCornerBounds_(bounds, parentBounds) {
            let x;
            if (bounds.left > parentBounds.left + parentBounds.width / 2) {
                x = parentBounds.left + parentBounds.width;
            }
            else {
                x = parentBounds.left - bounds.width;
            }
            let y;
            if (bounds.top > parentBounds.top + parentBounds.height / 2) {
                y = parentBounds.top + parentBounds.height;
            }
            else {
                y = parentBounds.top - bounds.height;
            }
            return {
                left: x,
                top: y,
                width: bounds.width,
                height: bounds.height,
            };
        }
        /**
         * Highlights the edge of the div associated with |id| based on
         * |layoutPosition| and removes any other highlights. If
         * |layoutPosition| is undefined, removes all highlights.
         */
        highlightEdge_(id, layoutPosition) {
            for (let i = 0; i < this.layouts.length; ++i) {
                const layout = this.layouts[i];
                const highlight = (layout.id === id || layout.parentId === id) ?
                    layoutPosition :
                    undefined;
                const div = id ? this.shadowRoot.getElementById(`_${id}`) :
                    this.shadowRoot.getElementById(`_${layout.id}`);
                assert(div);
                div.classList.toggle('highlight-right', highlight === LayoutPosition.RIGHT);
                div.classList.toggle('highlight-left', highlight === LayoutPosition.LEFT);
                div.classList.toggle('highlight-top', highlight === LayoutPosition.TOP);
                div.classList.toggle('highlight-bottom', highlight === LayoutPosition.BOTTOM);
            }
        }
    }
    return LayoutMixinInternal;
});

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'display-layout' presents a visual representation of the layout of one or
 * more displays and allows them to be arranged.
 */
const MIN_VISUAL_SCALE = .01;
const DisplayLayoutElementBase = mixinBehaviors([IronResizableBehavior], LayoutMixin(I18nMixin(PolymerElement)));
class DisplayLayoutElement extends DisplayLayoutElementBase {
    static get is() {
        return 'display-layout';
    }
    static get template() {
        return getTemplate$34();
    }
    static get properties() {
        return {
            /**
             * Array of displays.
             */
            displays: Array,
            selectedDisplay: Object,
            /**
             * The ratio of the display area div (in px) to DisplayUnitInfo.bounds.
             */
            visualScale: {
                type: Number,
                value: 1,
            },
            /**
             * Ids for mirroring destination displays.
             */
            mirroringDestinationIds_: Array,
        };
    }
    constructor() {
        super();
        this.visualOffset_ = { left: 0, top: 0 };
        /**
         * Stores the previous coordinates of a display once dragging starts. Used
         * to calculate the delta during each step of the drag. Null when there is
         * no drag in progress.
         */
        this.lastDragCoordinates_ = null;
        this.browserProxy_ = DevicePageBrowserProxyImpl.getInstance();
        this.allowDisplayAlignmentApi_ =
            loadTimeData.getBoolean('allowDisplayAlignmentApi');
        this.invalidDisplayId_ = loadTimeData.getString('invalidDisplayId');
        this.hasDragStarted_ = false;
        this.mirroringDestinationIds_ = [];
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        this.initializeDrag(false);
    }
    /**
     * Called explicitly when |this.displays| and their associated |this.layouts|
     * have been fetched from chrome.
     */
    updateDisplays(displays, layouts, mirroringDestinationIds) {
        this.displays = displays;
        this.layouts = layouts;
        this.mirroringDestinationIds_ = mirroringDestinationIds;
        this.initializeDisplayLayout(displays, layouts);
        const self = this;
        const retry = 100; // ms
        function tryCalcVisualScale() {
            if (!self.calculateVisualScale_()) {
                setTimeout(tryCalcVisualScale, retry);
            }
        }
        tryCalcVisualScale();
        // Enable keyboard dragging before initialization.
        this.keyboardDragEnabled = true;
        this.initializeDrag(!this.mirroring, this.$.displayArea, (id, amount) => this.onDrag_(id, amount));
    }
    /**
     * Calculates the visual offset and scale for the display area
     * (i.e. the ratio of the display area div size to the area required to
     * contain the DisplayUnitInfo bounding boxes).
     * @return Whether the calculation was successful.
     */
    calculateVisualScale_() {
        const displayAreaDiv = this.$.displayArea;
        if (!displayAreaDiv || !displayAreaDiv.offsetWidth || !this.displays ||
            !this.displays.length) {
            return false;
        }
        let display = this.displays[0];
        let bounds = this.getCalculatedDisplayBounds(display.id);
        const boundsBoundingBox = {
            left: bounds.left,
            right: bounds.left + bounds.width,
            top: bounds.top,
            bottom: bounds.top + bounds.height,
        };
        let maxWidth = bounds.width;
        let maxHeight = bounds.height;
        for (let i = 1; i < this.displays.length; ++i) {
            display = this.displays[i];
            bounds = this.getCalculatedDisplayBounds(display.id);
            boundsBoundingBox.left = Math.min(boundsBoundingBox.left, bounds.left);
            boundsBoundingBox.right =
                Math.max(boundsBoundingBox.right, bounds.left + bounds.width);
            boundsBoundingBox.top = Math.min(boundsBoundingBox.top, bounds.top);
            boundsBoundingBox.bottom =
                Math.max(boundsBoundingBox.bottom, bounds.top + bounds.height);
            maxWidth = Math.max(maxWidth, bounds.width);
            maxHeight = Math.max(maxHeight, bounds.height);
        }
        // Create a margin around the bounding box equal to the size of the
        // largest displays.
        const boundsWidth = boundsBoundingBox.right - boundsBoundingBox.left;
        const boundsHeight = boundsBoundingBox.bottom - boundsBoundingBox.top;
        // Calculate the scale.
        const horizontalScale = displayAreaDiv.offsetWidth / (boundsWidth + maxWidth * 2);
        const verticalScale = displayAreaDiv.offsetHeight / (boundsHeight + maxHeight * 2);
        const scale = Math.min(horizontalScale, verticalScale);
        // Calculate the offset.
        this.visualOffset_.left =
            ((displayAreaDiv.offsetWidth - (boundsWidth * scale)) / 2) -
                boundsBoundingBox.left * scale;
        this.visualOffset_.top =
            ((displayAreaDiv.offsetHeight - (boundsHeight * scale)) / 2) -
                boundsBoundingBox.top * scale;
        // Update the scale which will trigger calls to getDivStyle_.
        this.visualScale = Math.max(MIN_VISUAL_SCALE, scale);
        return true;
    }
    getDivStyle_(id, _displayBounds, _visualScale, offset) {
        // This matches the size of the box-shadow or border in CSS.
        const BORDER = 1;
        const MARGIN = 4;
        const OFFSET = offset || 0;
        const PADDING = 3;
        const bounds = this.getCalculatedDisplayBounds(id, /* notest */ true);
        if (!bounds) {
            return '';
        }
        const height = Math.round(bounds.height * this.visualScale) - BORDER * 2 -
            MARGIN * 2 - PADDING * 2;
        const width = Math.round(bounds.width * this.visualScale) - BORDER * 2 -
            MARGIN * 2 - PADDING * 2;
        const left = OFFSET +
            Math.round(this.visualOffset_.left + (bounds.left * this.visualScale));
        const top = OFFSET +
            Math.round(this.visualOffset_.top + (bounds.top * this.visualScale));
        return 'height: ' + height + 'px; width: ' + width + 'px;' +
            ' left: ' + left + 'px; top: ' + top + 'px';
    }
    getMirrorDivStyle_(mirroringDestinationIndex, mirroringDestinationDisplayNum, displays, visualScale) {
        // All destination displays have the same bounds as the mirroring source
        // display, but we add a little offset to each destination display's bounds
        // so that they can be distinguished from each other in the layout.
        return this.getDivStyle_(displays[0].id, displays[0].bounds, visualScale, (mirroringDestinationDisplayNum - mirroringDestinationIndex) * -4);
    }
    isSelected_(display, selectedDisplay) {
        return display.id === selectedDisplay.id;
    }
    dispatchSelectDisplayEvent_(displayId) {
        const selectDisplayEvent = new CustomEvent('select-display', { composed: true, detail: displayId });
        this.dispatchEvent(selectDisplayEvent);
    }
    onSelectDisplayClick_(e) {
        this.dispatchSelectDisplayEvent_(e.model.item.id);
        // Keep focused display in-sync with clicked display
        e.target.focus();
    }
    onFocus_(e) {
        this.dispatchSelectDisplayEvent_(e.model.item.id);
        e.target.focus();
    }
    // Gets the display window position change announcement for a11y.
    getPositionChangeAnnouncement_(deltaX, deltaY) {
        let description = '';
        // Position was moved in both X and Y direction.
        if (deltaX !== 0 && deltaY !== 0) {
            if (deltaY > 0 && deltaX > 0) {
                description = 'displayPositionDownAndRight';
            }
            else if (deltaY > 0 && deltaX < 0) {
                description = 'displayPositionDownAndLeft';
            }
            else if (deltaY < 0 && deltaX > 0) {
                description = 'displayPositionUpAndRight';
            }
            else if (deltaY < 0 && deltaX < 0) {
                description = 'displayPositionUpAndLeft';
            }
        }
        else {
            // Position was moved in only one direction, either X or Y.
            if (deltaY > 0) {
                description = 'displayPositionDown';
            }
            else if (deltaY < 0) {
                description = 'displayPositionUp';
            }
            else if (deltaX > 0) {
                description = 'displayPositionRight';
            }
            else if (deltaX < 0) {
                description = 'displayPositionLeft';
            }
        }
        return this.i18n(description);
    }
    onDrag_(id, amount) {
        id = id.substr(1); // Skip prefix
        let newBounds;
        if (!amount) {
            this.finishUpdateDisplayBounds(id);
            newBounds = this.getCalculatedDisplayBounds(id);
            this.lastDragCoordinates_ = null;
            // When the drag stops, remove the highlight around the display.
            this.browserProxy_.highlightDisplay(this.invalidDisplayId_);
        }
        else {
            this.browserProxy_.highlightDisplay(id);
            // Make sure the dragged display is also selected.
            if (id !== this.selectedDisplay.id) {
                this.dispatchSelectDisplayEvent_(id);
            }
            const calculatedBounds = this.getCalculatedDisplayBounds(id);
            newBounds = { ...calculatedBounds };
            newBounds.left += Math.round(amount.x / this.visualScale);
            newBounds.top += Math.round(amount.y / this.visualScale);
            if (this.displays.length >= 2) {
                newBounds = this.updateDisplayBounds(id, newBounds);
            }
            if (!this.lastDragCoordinates_) {
                this.hasDragStarted_ = true;
                this.lastDragCoordinates_ = {
                    x: calculatedBounds.left,
                    y: calculatedBounds.top,
                };
            }
            const deltaX = newBounds.left - this.lastDragCoordinates_.x;
            const deltaY = newBounds.top - this.lastDragCoordinates_.y;
            this.lastDragCoordinates_.x = newBounds.left;
            this.lastDragCoordinates_.y = newBounds.top;
            // Only call dragDisplayDelta() when there is a change in position.
            if (deltaX !== 0 || deltaY !== 0) {
                if (this.allowDisplayAlignmentApi_) {
                    this.browserProxy_.dragDisplayDelta(id, Math.round(deltaX), Math.round(deltaY));
                }
                // Add ChromeVox announcement.
                const announcer = getInstance(this.$.displayArea);
                // Remove "role = alert" to avoid chromevox announcing "alert" before
                // message.
                strictQuery('#messages', announcer.shadowRoot, HTMLDivElement)
                    .removeAttribute('role');
                // Announce the messages.
                announcer.announce(this.getPositionChangeAnnouncement_(deltaX, deltaY));
            }
        }
        const left = this.visualOffset_.left + Math.round(newBounds.left * this.visualScale);
        const top = this.visualOffset_.top + Math.round(newBounds.top * this.visualScale);
        const div = castExists(this.shadowRoot.getElementById(`_${id}`));
        div.style.left = '' + left + 'px';
        div.style.top = '' + top + 'px';
        div.focus();
    }
}
customElements.define(DisplayLayoutElement.is, DisplayLayoutElement);

function getTemplate$33() {
    return html `<!--_html_template_start_--><style include="settings-shared iron-flex iron-flex-alignment">.subtitle{color:var(--cros-text-color-secondary);margin-top:10px}.instructions{color:var(--cros-text-color-secondary);margin-top:4px}.details{margin:40px}.label{margin-top:15px}iron-icon{--iron-icon-fill-color:var(--cros-icon-color-primary);--iron-icon-height:18px;--iron-icon-width:18px;background:var(--cros-bg-color-dropped-elevation-2);border-radius:2px;margin:5px;padding:4px}#move{align-items:center;display:flex;flex-direction:row}#move>div{color:var(--cros-text-color-secondary);flex:0 0 auto}#move>div:not(:first-child){margin-inline-start:8px}#move>div:not(:last-child){margin-inline-end:8px}#move>div.shift{background:var(--cros-bg-color-dropped-elevation-2);border-radius:2px;color:var(--cros-text-color-primary);font-size:100%;padding:7px 8px}</style>
<cr-dialog id="dialog" on-close="close"
    close-text="$i18n{close}">
  <div slot="title">$i18n{displayOverscanPageTitle}</div>
  <div slot="body">
    <div class="subtitle" >$i18n{displayOverscanSubtitle}</div>
    <div class="details layout horizontal around-justified self-stretch">
      <div class="layout vertical center">
        <div class="layout horizontal">
          <iron-icon icon="cr:expand-less"></iron-icon>
        </div>
        <div class="layout horizontal">
          <iron-icon icon="os-settings:chevron-left"></iron-icon>
          <iron-icon icon="cr:expand-more"></iron-icon>
          <iron-icon icon="cr:chevron-right"></iron-icon>
        </div>
        <div class="label" >$i18n{displayOverscanResize}</div>
      </div>
      <div class="layout vertical center">
        <div class="layout vertical center-justified flex">
          <div id="move" class="layout horizontal">
            <!-- TODO(stevenjb): Localize 'shift' for other keyboards -->
            <!-- crbug.com/614827 -->
            <div>(</div><div>+</div><div class="shift">shift</div><div>)</div>
          </div>
        </div>
        <div class="label">$i18n{displayOverscanPosition}</div>
      </div>
    </div>
  </div>
  <div slot="button-container">
    <cr-button id="reset" class="cancel-button" on-click="onResetClick_">
      $i18n{displayOverscanReset}
    </cr-button>
    <cr-button class="action-button" on-click="onSaveClick_">
      $i18n{ok}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'settings-display-overscan-dialog' is the dialog for display overscan
 * adjustments.
 */
class SettingsDisplayOverscanDialogElement extends PolymerElement {
    static get is() {
        return 'settings-display-overscan-dialog';
    }
    static get template() {
        return getTemplate$33();
    }
    static get properties() {
        return {
            /** Id of the display for which overscan is being applied (or empty). */
            displayId: {
                type: String,
                notify: true,
                observer: 'displayIdChanged_',
            },
            /**
               Set to true once changes are saved to avoid a reset/cancel on close.
             */
            committed_: Boolean,
        };
    }
    constructor() {
        super();
        /**
         * Keyboard event handler for overscan adjustments.
         */
        this.keyHandler_ = this.handleKeyEvent_.bind(this);
    }
    open() {
        // We need to attach the event listener to |window|, not |this| so that
        // changing focus does not prevent key events from occurring.
        window.addEventListener('keydown', this.keyHandler_);
        this.committed_ = false;
        this.$.dialog.showModal();
        // Don't focus 'reset' by default. 'Tab' will focus 'OK'.
        this.shadowRoot.getElementById('reset').blur();
    }
    close() {
        window.removeEventListener('keydown', this.keyHandler_);
        this.displayId = ''; // Will trigger displayIdChanged_.
        if (this.$.dialog.open) {
            this.$.dialog.close();
        }
    }
    displayIdChanged_(newValue, oldValue) {
        if (oldValue && !this.committed_) {
            getDisplayApi().overscanCalibrationReset(oldValue);
            getDisplayApi().overscanCalibrationComplete(oldValue);
        }
        if (!newValue) {
            return;
        }
        this.committed_ = false;
        getDisplayApi().overscanCalibrationStart(newValue);
    }
    onResetClick_() {
        getDisplayApi().overscanCalibrationReset(this.displayId);
    }
    onSaveClick_() {
        getDisplayApi().overscanCalibrationComplete(this.displayId);
        this.committed_ = true;
        this.close();
    }
    handleKeyEvent_(event) {
        if (event.altKey || event.ctrlKey || event.metaKey) {
            return;
        }
        switch (event.keyCode) {
            case 37: // left arrow
                if (event.shiftKey) {
                    this.move_(-1, 0);
                }
                else {
                    this.resize_(1, 0);
                }
                break;
            case 38: // up arrow
                if (event.shiftKey) {
                    this.move_(0, -1);
                }
                else {
                    this.resize_(0, -1);
                }
                break;
            case 39: // right arrow
                if (event.shiftKey) {
                    this.move_(1, 0);
                }
                else {
                    this.resize_(-1, 0);
                }
                break;
            case 40: // down arrow
                if (event.shiftKey) {
                    this.move_(0, 1);
                }
                else {
                    this.resize_(0, 1);
                }
                break;
            default:
                // Allow unhandled key events to propagate.
                return;
        }
        event.preventDefault();
    }
    move_(x, y) {
        const delta = {
            left: x,
            top: y,
            right: x ? -x : 0, // negating 0 will produce a double.
            bottom: y ? -y : 0,
        };
        getDisplayApi().overscanCalibrationAdjust(this.displayId, delta);
    }
    resize_(x, y) {
        const delta = {
            left: x,
            top: y,
            right: x,
            bottom: y,
        };
        getDisplayApi().overscanCalibrationAdjust(this.displayId, delta);
    }
}
customElements.define(SettingsDisplayOverscanDialogElement.is, SettingsDisplayOverscanDialogElement);

function getTemplate$32() {
    return html `<!--_html_template_start_--><style include="cr-shared-style settings-shared iron-flex
  iron-flex-alignment">.indented{align-self:stretch;margin-inline-start:var(--cr-section-indent-padding);padding:0}#nightLightTemperatureDiv[disabled]{opacity:0.38;pointer-events:none}.text-area{margin:10px 0}#nightLightSlider{flex-grow:1;margin-top:20px}#nightLightDropDownDiv{width:200px;text-align:right;margin-top:8px}iron-collapse{width:100%}</style>

<settings-toggle-button
    id="nightLightToggleButton"
    class="settings-box first"
    label="$i18n{displayNightLightLabel}"
    pref="{{prefs.ash.night_light.enabled}}"
    sub-label="$i18n{displayNightLightText}"
    deep-link-focus-id$="[[Setting.kNightLight]]">
</settings-toggle-button>

<div id="nightLightSettingsDiv"
    class="settings-box continuation start layout vertical">
  <!-- Color temperature slider -->
  <div id="nightLightTemperatureDiv"
      class="settings-box indented continuation"
      hidden$="[[!prefs.ash.night_light.enabled.value]]">
    <div class="start text-area" id="colorTemperatureLabel">
      $i18n{displayNightLightTemperatureLabel}
    </div>
    <settings-slider id="colorTemperatureSlider"
        aria-labelledby="colorTemperatureLabel" min="0" max="100"
        scale="100" label-min="$i18n{displayNightLightTempSliderMinLabel}"
        label-max="$i18n{displayNightLightTempSliderMaxLabel}"
        pref="{{prefs.ash.night_light.color_temperature}}"
        deep-link-focus-id$="[[Setting.kNightLightColorTemperature]]">
    </settings-slider>
  </div>
  <!-- Schedule settings -->
  <div class="settings-box indented">
    <div id="NightLightLabelDiv" class="start text-area" aria-hidden="true">
      <div id="nightLightScheduleLabel" class="label">
        $i18n{displayNightLightScheduleLabel}
      </div>
      <div id="nightLightScheduleSubLabel" class="secondary label"
          hidden$="[[!nightLightScheduleSubLabel_]]">
        [[nightLightScheduleSubLabel_]]
      </div>
    </div>
    <div id="nightLightDropDownDiv"
        class="cr-row-gap">
      <settings-dropdown-menu
          id="nightLightScheduleTypeDropDown"
          label="$i18n{displayNightLightScheduleLabel}"
          aria-describedby="nightLightScheduleSubLabel"
          pref="{{prefs.ash.night_light.schedule_type}}"
          menu-options="[[scheduleTypesList_]]">
      </settings-dropdown-menu>
      <template is="dom-if" if="[[shouldShowGeolocationWarningText_]]"
          restamp>
        <settings-privacy-hub-geolocation-warning-text
            id="warningText"
            warning-text-with-anchor=
                "[[geolocationWarningText_]]"
            on-link-clicked="openGeolocationDialog_">
        </settings-privacy-hub-geolocation-warning-text>
      </template>
    </div>
  </div>
  <!-- Custom schedule slider -->
  <iron-collapse id="nightLightCustomScheduleCollapse"
      opened="[[shouldOpenCustomScheduleCollapse_]]">
    <div class="settings-box indented continuation">
      <div class="start text-area layout vertical">
        <div class="settings-box continuation self-stretch">
          <settings-scheduler-slider id="nightLightSlider" prefs="{{prefs}}"
              pref-start-time="{{prefs.ash.night_light.custom_start_time}}"
              pref-end-time="{{prefs.ash.night_light.custom_end_time}}">
          </settings-scheduler-slider>
        </div>
      </div>
    </div>
  </iron-collapse>
</div>

<!-- System geolocation dialog, letting users enable location permission -->
<template is="dom-if" if="[[shouldShowGeolocationDialog_]]" restamp>
  <settings-privacy-hub-geolocation-dialog id="geolocationDialog"
      on-close="onGeolocationDialogClose_"
      prefs="{{prefs}}">
  </settings-privacy-hub-geolocation-dialog>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'settings-display-night-light' is the section on the display subpage
 * for display night light preferences' adjustments.
 */
/**
 * The types of Night Light automatic schedule. The values of the enum values
 * are synced with the pref "prefs.ash.night_light.schedule_type".
 */
var NightLightScheduleType;
(function (NightLightScheduleType) {
    NightLightScheduleType[NightLightScheduleType["NEVER"] = 0] = "NEVER";
    NightLightScheduleType[NightLightScheduleType["SUNSET_TO_SUNRISE"] = 1] = "SUNSET_TO_SUNRISE";
    NightLightScheduleType[NightLightScheduleType["CUSTOM"] = 2] = "CUSTOM";
})(NightLightScheduleType || (NightLightScheduleType = {}));
const SettingsDisplayNightLightElementBase = DeepLinkingMixin(PrefsMixin(I18nMixin(PolymerElement)));
class SettingsDisplayNightLightElement extends SettingsDisplayNightLightElementBase {
    static get is() {
        return 'settings-display-night-light';
    }
    static get template() {
        return getTemplate$32();
    }
    static get properties() {
        return {
            scheduleTypesList_: {
                type: Array,
                value() {
                    return [
                        {
                            name: loadTimeData.getString('displayNightLightScheduleNever'),
                            value: NightLightScheduleType.NEVER,
                        },
                        {
                            name: loadTimeData.getString('displayNightLightScheduleSunsetToSunRise'),
                            value: NightLightScheduleType.SUNSET_TO_SUNRISE,
                        },
                        {
                            name: loadTimeData.getString('displayNightLightScheduleCustom'),
                            value: NightLightScheduleType.CUSTOM,
                        },
                    ];
                },
            },
            shouldOpenCustomScheduleCollapse_: {
                type: Boolean,
                value: false,
            },
            nightLightScheduleSubLabel_: String,
            shouldShowGeolocationWarningText_: {
                type: Boolean,
                computed: 'computeShouldShowGeolocationWarningText_(' +
                    'prefs.ash.night_light.schedule_type.value, ' +
                    'prefs.ash.user.geolocation_access_level.value),',
            },
            sunriseTime_: {
                type: String,
                value() {
                    return loadTimeData.getString('privacyHubSystemServicesInitSunRiseTime');
                },
            },
            sunsetTime_: {
                type: String,
                value() {
                    return loadTimeData.getString('privacyHubSystemServicesInitSunSetTime');
                },
            },
            geolocationWarningText_: {
                type: String,
                computed: 'computeGeolocationWarningText_(' +
                    'prefs.ash.user.geolocation_access_level.*,' +
                    'sunriseTime_, sunsetTime_)',
            },
            shouldShowEnableGeolocationDialog_: {
                type: Boolean,
                value: false,
            },
            isInternalDisplay: Boolean,
            /**
             * Current status of night light setting.
             */
            currentNightLightStatus: Boolean,
            /**
             * Current selected night light schedule type.
             */
            currentScheduleType: NightLightScheduleType,
        };
    }
    static get observers() {
        return [
            'updateNightLightScheduleSettings_(prefs.ash.night_light.schedule_type.*,' +
                ' prefs.ash.night_light.enabled.*),',
            'onTimeZoneChanged_(prefs.cros.system.timezone.value)',
        ];
    }
    constructor() {
        super();
        // DeepLinkingMixin override
        this.supportedSettingIds = new Set([
            Setting.kNightLight,
            Setting.kNightLightColorTemperature,
        ]);
        this.displaySettingsProvider = getDisplaySettingsProvider();
        this.privacyHubBrowserProxy_ = PrivacyHubBrowserProxyImpl.getInstance();
    }
    /**
     * Invoked when the status of Night Light or its schedule type are changed,
     * in order to update the schedule settings, such as whether to show the
     * custom schedule slider, and the schedule sub label.
     */
    updateNightLightScheduleSettings_() {
        const scheduleType = this.getPref('ash.night_light.schedule_type').value;
        this.shouldOpenCustomScheduleCollapse_ =
            scheduleType === NightLightScheduleType.CUSTOM;
        const nightLightStatus = this.getPref('ash.night_light.enabled').value;
        if (scheduleType === NightLightScheduleType.SUNSET_TO_SUNRISE) {
            this.nightLightScheduleSubLabel_ = nightLightStatus ?
                this.i18n('displayNightLightOffAtSunrise') :
                this.i18n('displayNightLightOnAtSunset');
        }
        else {
            this.nightLightScheduleSubLabel_ = '';
        }
        // Records metrics when schedule type or night light status have changed. Do
        // not record when the page just loads and the current value is still
        // undefined.
        if (this.currentScheduleType !== scheduleType &&
            this.currentScheduleType !== undefined) {
            this.recordChangingNightLightSchedule(this.isInternalDisplay, scheduleType);
        }
        if (this.currentNightLightStatus !== nightLightStatus &&
            this.currentNightLightStatus !== undefined) {
            this.recordTogglingNightLightStatus(this.isInternalDisplay, nightLightStatus);
        }
        // Updates current schedule type and night light status.
        this.currentScheduleType = scheduleType;
        this.currentNightLightStatus = nightLightStatus;
    }
    // Records metrics when users change the night light schedule.
    recordChangingNightLightSchedule(isInternalDisplay, nightLightSchedule) {
        this.displaySettingsProvider.recordChangingDisplaySettings(DisplaySettingsType.kNightLightSchedule, {
            isInternalDisplay,
            nightLightSchedule,
            displayId: null,
            orientation: null,
            nightLightStatus: null,
            mirrorModeStatus: null,
            unifiedModeStatus: null,
        });
    }
    // Records metrics when users toggle the night light status.
    recordTogglingNightLightStatus(isInternalDisplay, nightLightStatus) {
        this.displaySettingsProvider.recordChangingDisplaySettings(DisplaySettingsType.kNightLight, {
            isInternalDisplay,
            nightLightStatus,
            displayId: null,
            orientation: null,
            nightLightSchedule: null,
            mirrorModeStatus: null,
            unifiedModeStatus: null,
        });
    }
    computeShouldShowGeolocationWarningText_() {
        const scheduleType = this.prefs.ash.night_light.schedule_type.value;
        const geolocationAccessLevel = this.prefs.ash.user.geolocation_access_level.value;
        return (scheduleType === NightLightScheduleType.SUNSET_TO_SUNRISE &&
            geolocationAccessLevel === GeolocationAccessLevel.DISALLOWED);
    }
    computeGeolocationWarningText_() {
        if (!this.prefs) {
            return '';
        }
        if (this.prefs.ash.user.geolocation_access_level.enforcement ===
            chrome.settingsPrivate.Enforcement.ENFORCED) {
            return loadTimeData.getStringF('displayNightLightGeolocationManagedWarningText', this.sunriseTime_, this.sunsetTime_);
        }
        else {
            return loadTimeData.getStringF('displayNightLightGeolocationWarningText', this.sunriseTime_, this.sunsetTime_);
        }
    }
    openGeolocationDialog_() {
        this.shouldShowGeolocationDialog_ = true;
    }
    onGeolocationDialogClose_() {
        this.shouldShowGeolocationDialog_ = false;
    }
    onTimeZoneChanged_() {
        this.privacyHubBrowserProxy_.getCurrentSunriseTime().then((time) => {
            this.sunriseTime_ = time;
        });
        this.privacyHubBrowserProxy_.getCurrentSunsetTime().then((time) => {
            this.sunsetTime_ = time;
        });
    }
}
customElements.define(SettingsDisplayNightLightElement.is, SettingsDisplayNightLightElement);

function getTemplate$31() {
    return html `<!--_html_template_start_--><style include="cr-shared-style settings-shared md-select iron-flex
  iron-flex-alignment">#arrangement-section{border-top:none}#arrangement-section-main{padding:0 var(--cr-section-padding)}.indented{align-self:stretch;margin-inline-start:var(--cr-section-indent-padding);padding:0}.display-tabs{width:100%}display-layout{align-self:stretch;flex:1 1 auto;height:300px;margin:10px;min-height:300px}.text-area{margin:10px 0}.settings-box>cr-button:first-child{padding-inline-start:0}.settings-box>cr-policy-pref-indicator{margin-inline-end:var(--cr-controlled-by-spacing)}.underbar{border-bottom:var(--cr-separator-line)}#controlsDiv>.settings-box:first-of-type{border-top:none}#mirrorDisplayToggleButton{align-self:stretch;border-top:none;display:flex}#brightnessSliderWrapper{min-width:200px;display:flex;flex-direction:column}</style>

<!-- Display Shiny Performance Mode Controller -->
<div id="displayPerformanceModeSubsection" class="settings-box"
    hidden="[[!isDisplayPerformanceSupported_]]">
  <div id="displayPerformanceModeLabel"
      class="start text-area" aria-hidden="true">
      <!-- TODO(b/326270858): Translate the label -->
      $i18n{displayShinyPerformanceLabel}
  </div>
  <cr-toggle id="displayPerformanceModeToggle"
      aria-labelledby="displayPerformanceModeLabel"
      on-change="toggleDisplayPerformanceEnabled_">
  </cr-toggle>
</div>

<!-- Arrangement section -->
<template is="dom-if"
    if="[[shouldShowArrangementSection(displays)]]" restamp>
  <div class="underbar" id="arrangement-section">
    <div class="layout vertical self-stretch" id="arrangement-section-main">
      <h2 class="layout self-start">
        $i18n{displayArrangementTitle}
      </h2>
      <div class="secondary layout self-start"
          hidden="[[isMirrored(displays)]]">
        $i18n{displayArrangementText}
      </div>
      <display-layout id="displayLayout"
          selected-display="[[selectedDisplay]]"
          on-select-display="onSelectDisplay_"
          deep-link-focus-id$="[[Setting.kDisplayArrangement]]">
      </display-layout>
    </div>

    <template is="dom-if"
        if="[[showMirror(unifiedDesktopMode_, displays)]]" restamp>
      <!-- Mirror display toggle button -->
      <div id="mirrorDisplayToggleButton" class="settings-box"
          on-click="onMirroredClick_" actionable-row>
        <div id="mirrorDisplayToggleLabel" class="start">
          [[getDisplayMirrorText_(displays, primaryDisplay)]]
        </div>
        <cr-toggle id="mirrorDisplayToggle"
            checked="[[isMirrored(displays)]]"
            on-change="onMirroredClick_"
            aria-label="[[getDisplayMirrorText_(displays)]]"
            deep-link-focus-id$="[[Setting.kDisplayMirroring]]">
        </cr-toggle>
      </div>
    </template>

  </div>
</template>

<!-- Display tabs -->
<div hidden="[[!hasMultipleDisplays_(displays)]]"
    class="settings-box first">
  <cr-tabs selected="[[selectedTab_]]" class="display-tabs"
      on-selected-changed="onSelectDisplayTab_"
      tab-names="[[displayTabNames_]]"></cr-tabs>
</div>

<div id="controlsDiv" class="settings-box layout vertical first">
  <h2>[[selectedDisplay.name]]</h2>
  <template is="dom-if" if="[[showUnifiedDesktop(unifiedDesktopAvailable_,
      unifiedDesktopMode_, displays, isTabletMode_)]]" restamp>
    <div class="settings-box indented two-line"
         on-click="onUnifiedDesktopClick_" actionable-row>
      <div class="start">
        <div id="displayUnifiedDesktopCheckboxLabel">
          $i18n{displayUnifiedDesktop}
        </div>
        <div class="secondary">
          [[getUnifiedDesktopText_(unifiedDesktopMode_)]]
        </div>
      </div>
      <cr-toggle id="displayUnifiedDesktopToggle"
          checked="[[unifiedDesktopMode_]]"
          on-change="onUnifiedDesktopClick_"
          aria-labelledby="displayUnifiedDesktopCheckboxLabel"
          deep-link-focus-id$="[[Setting.kAllowWindowsToSpanDisplays]]">
      </cr-toggle>
    </div>
  </template>

  <template is="dom-if" restamp
      if="[[showDisplaySelectMenu_(displays, selectedDisplay)]]">
    <div class="settings-box indented">
      <div id="displayScreenTitle" class="start" aria-hidden="true">
        $i18n{displayScreenTitle}
      </div>
      <select id="primaryDisplaySelect"
          class="md-select"
          on-change="updatePrimaryDisplay_"
          aria-labelledby="displayScreenTitle"
          value="[[getDisplaySelectMenuIndex_(
              selectedDisplay, primaryDisplayId)]]">
        <option value="0">$i18n{displayScreenPrimary}</option>
        <option value="1">$i18n{displayScreenExtended}</option>
      </select>
    </div>
  </template>

  <!-- Display brightness controls -->
  <template is="dom-if" restamp
      if="[[showBrightnessControls_(selectedDisplay)]]">
    <template is="dom-if" restamp
        if="[[showAutoBrightnessToggle_(hasAmbientLightSensor_)]]">
      <div class="settings-box indented" id="autoBrightnessToggleRow"
          on-click="onAutoBrightnessToggleRowClicked_" actionable-row>
        <div class="start settings-box-text">
          <div id="autoBrightnessToggleLabel" class="start" aria-hidden="true">
              $i18n{displayAutoBrightnessToggleLabel}
          </div>
          <div id="autoBrightnessToggleSubtitle" class="secondary"
              aria-hidden="true">
            $i18n{displayAutoBrightnessToggleSubtitle}
          </div>
        </div>
        <cr-toggle id="autoBrightnessToggle"
            checked="[[isAmbientLightSensorEnabled_]]"
            on-change="onAutoBrightnessToggleChange_"
            aria-labelledby="autoBrightnessToggleLabel"
            aria-describedby="autoBrightnessToggleSubtitle">
        </cr-toggle>
      </div>
    </template>
    <div class="settings-box indented">
      <div id="brightnessControlsTitle" class="start" aria-hidden="true">
        $i18n{displayBrightnessLabel}
      </div>
      <div id="brightnessSliderWrapper">
        <cr-slider id="brightnessSlider" min="[[brightnessSliderMin_]]"
            max="[[brightnessSliderMax_]]" key-press-slider-increment="10"
            value="[[currentInternalScreenBrightness_]]"
            on-cr-slider-value-changed="onDisplayBrightnessSliderChanged_"
            aria-labelledby="brightnessControlsTitle">
        </cr-slider>
      </div>
    </div>
  </template>

  <!-- Display zoom selection slider -->
  <div class="settings-box indented two-line">
    <div class="start text-area layout vertical">
      <div id="displayZoomLabel" aria-hidden="true">
        $i18n{displayZoomLabel}
      </div>
      <div id="displayZoomDescription" class="secondary self-start"
          aria-hidden="true">
        $i18n{displayZoomDescription}
      </div>
      <div id="logicalResolutionText" class="secondary self-start"
          hidden$="[[!logicalResolutionText_]]" aria-hidden="true">
        [[logicalResolutionText_]]
      </div>
    </div>
    <template is="dom-if" if="[[isDisplayScaleManagedByPolicy_(
        selectedDisplay, prefs.cros.device_display_resolution)]]">
      <cr-policy-pref-indicator
          pref="[[prefs.cros.device_display_resolution]]"
          icon-aria-label="$i18n{displayZoomLabel}">
      </cr-policy-pref-indicator>
    </template>
    <settings-slider id="displaySizeSlider"
        ticks="[[zoomValues_]]" pref="{{selectedZoomPref_}}"
        label-aria="$i18n{displayZoomLabel}"
        label-min="$i18n{displaySizeSliderMinLabel}"
        label-max="$i18n{displaySizeSliderMaxLabel}"
        disabled="[[isDisplayScaleMandatory_(
            selectedDisplay,
            prefs.cros.device_display_resolution)]]"
        on-cr-slider-value-changed="onDisplaySizeSliderDrag_"
        aria-describedby="displayZoomSublabel logicalResolutionText"
        deep-link-focus-id$="[[Setting.kDisplaySize]]">
    </settings-slider>
  </div>

  <!-- Drop down select menu for resolution -->
  <template is="dom-if"
      if="[[showDropDownResolutionSetting_(selectedDisplay)]]" restamp>
    <div class="settings-box indented two-line">
      <div class="start text-area layout vertical" aria-hidden="true">
        <div>$i18n{displayResolutionTitle}</div>
        <div class="secondary self-start" id="displayResolutionSublabel">
          $i18n{displayResolutionSublabel}
        </div>
      </div>
      <template is="dom-if" if="[[isDisplayResolutionManagedByPolicy_(
          prefs.cros.device_display_resolution)]]">
        <cr-policy-pref-indicator
            pref="[[prefs.cros.device_display_resolution]]"
            icon-aria-label="$i18n{displayResolutionTitle}">
        </cr-policy-pref-indicator>
      </template>
      <settings-dropdown-menu id="displayModeSelector"
          pref="{{selectedParentModePref_}}"
          disabled="[[isDisplayResolutionMandatory_(
              prefs.cros.device_display_resolution)]]"
          label="$i18n{displayResolutionTitle}"
          aria-describedby="displayResolutionSublabel"
          menu-options="[[displayModeList_]]"
          deep-link-focus-id$="[[Setting.kDisplayResolution]]">
      </settings-dropdown-menu>
    </div>
  </template>

  <!-- Drop down select menu for refresh rate -->
  <template is="dom-if" if="[[showRefreshRateSetting_(selectedDisplay)]]"
      restamp>
    <div class="settings-box indented two-line">
      <div class="start text-area layout vertical" aria-hidden="true">
        <div>$i18n{displayRefreshRateTitle}</div>
        <div class="secondary self-start" id="displayRefreshRateSublabel">
          $i18n{displayRefreshRateSublabel}
        </div>
      </div>
      <template is="dom-if" if="[[isDisplayResolutionManagedByPolicy_(
          prefs.cros.device_display_resolution)]]">
        <cr-policy-pref-indicator
            pref="[[prefs.cros.device_display_resolution]]"
            icon-aria-label="$i18n{displayResolutionText}">
        </cr-policy-pref-indicator>
      </template>
      <settings-dropdown-menu id="refreshRateSelector"
          pref="{{selectedModePref_}}"
          disabled="[[isDisplayResolutionMandatory_(
              prefs.cros.device_display_resolution)]]"
          label="Refresh Rate Menu"
          aria-describedby="displayRefreshRateSublabel"
          menu-options="[[refreshRateList_]]"
          deep-link-focus-id$="[[Setting.kDisplayRefreshRate]]">
      </settings-dropdown-menu>
    </div>
  </template>


  <template is="dom-if" if="[[!unifiedDesktopMode_]]" restamp>
    <div class="settings-box indented">
      <div id="displayOrientation" class="start text-area"
          aria-hidden="true">
        $i18n{displayOrientation}
      </div>
      <template is="dom-if" if="[[isDevicePolicyEnabled_(
          prefs.cros.display_rotation_default)]]">
        <cr-policy-pref-indicator
            pref="[[prefs.cros.display_rotation_default]]"
            icon-aria-label="$i18n{displayOrientation}">
        </cr-policy-pref-indicator>
      </template>
      <select id="orientationSelect"
          class="md-select"
          value="[[selectedDisplay.rotation]]"
          aria-labelledby="displayOrientation"
          on-change="onOrientationChange_"
          deep-link-focus-id$="[[Setting.kDisplayOrientation]]">
        <option value="-1"
            hidden$="[[!showAutoRotateOption_(selectedDisplay)]]">
          $i18n{displayOrientationAutoRotate}
        </option>
        <option value="0">$i18n{displayOrientationStandard}</option>
        <option value="90">90&deg;</option>
        <option value="180">180&deg;</option>
        <option value="270">270&deg;</option>
      </select>
    </div>
  </template>

  <template is="dom-if" if="[[showAmbientColorSetting(
      ambientColorAvailable_, selectedDisplay)]]">
    <settings-toggle-button id="ambientColor"
        class="indented hr"
        pref="{{prefs.ash.ambient_color.enabled}}"
        label="$i18n{displayAmbientColorTitle}"
        sub-label="$i18n{displayAmbientColorSubtitle}"
        deep-link-focus-id$="[[Setting.kAmbientColors]]">
    </settings-toggle-button>
  </template>

  <cr-link-row class="indented hr" id="overscan"
      label="$i18n{displayOverscanPageTitle}"
      sub-label="$i18n{displayOverscanPageText}" on-click="onOverscanClick_"
      hidden$="[[!showOverscanSetting_(selectedDisplay)]]" embedded
      deep-link-focus-id$="[[Setting.kDisplayOverscan]]">
  </cr-link-row>

  <settings-display-overscan-dialog id="displayOverscan"
      display-id="{{overscanDisplayId}}"
      on-close="onCloseOverscanDialog_">
  </settings-display-overscan-dialog>

  <!-- Link row to touch calibration -->
  <cr-link-row class="indented hr" id="touchCalibration"
      label="$i18n{displayTouchCalibrationTitle}"
      sub-label="$i18n{displayTouchCalibrationText}"
      on-click="onTouchCalibrationClick_"
      hidden$="[[!showTouchCalibrationSetting_(selectedDisplay)]]" embedded
      deep-link-focus-id$="[[Setting.kTouchscreenCalibration]]">
  </cr-link-row>


  <template is="dom-if"
      if="[[showExcludeInMirror_(unifiedDesktopMode_,
      excludeDisplayInMirrorModeEnabled_,
      prefs.settings.display.allow_exclude_display_in_mirror_mode.value,
      displays, selectedDisplay)]]" restamp>
    <div id="excludeDisplayToggleRow"
        class="settings-box indented hr two-line">
      <div class="start text-area">
        <div id="excludeDisplayInMirrorLabel" class="start">
          $i18n{displayExcludeInMirrorModeLabel}
        </div>
        <div id="excludeDisplayInMirrorSublabel" class="secondary self-start"
            aria-hidden="true">
          $i18n{displayExcludeInMirrorModeSublabel}
        </div>
      </div>
      <cr-toggle id="excludeDisplayToggle"
          checked="[[shouldExcludeInMirror_(selectedDisplay)]]"
          on-change="onExcludeInMirrorClick_"
          aria-label="$i18n{displayExcludeInMirrorModeLabel}">
      </cr-toggle>
    </div>
  </template>
</div>

<!-- Night Light Settings -->
<div class="hr"></div>
<settings-display-night-light prefs="{{prefs}}"
    is-internal-display="[[selectedDisplay.isInternal]]">
</settings-display-night-light>

<!-- Touchscreen Mapping Experience -->
<template is="dom-if" if="[[showTouchRemappingExperience_()]]" restamp>
  <div class="settings-box continuation start layout vertical">
    <cr-link-row class="hr" id="touchMapping"
      label="$i18n{displayTouchMappingTitle}"
      sub-label="$i18n{displayTouchMappingText}"
      on-click="onTouchMappingClick_" embedded>
    </cr-link-row>
  </div>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'settings-display' is the settings subpage for display settings.
 */
var MirrorMode = chrome.system.display.MirrorMode;
function createDisplayValue(overrides) {
    const empty = {
        isInternalDisplay: null,
        displayId: null,
        orientation: null,
        nightLightStatus: null,
        nightLightSchedule: null,
        mirrorModeStatus: null,
        unifiedModeStatus: null,
    };
    return Object.assign(empty, overrides);
}
const SettingsDisplayElementBase = DeepLinkingMixin(PrefsMixin(RouteObserverMixin(I18nMixin(PolymerElement))));
// Set the MIN_VISIBLE_PERCENT to 10%. The lowest brightness that the slider can
// go is 5%, so the slider appears the same at 0% and 5%. Therefore, the minimum
// visible percent should be greater than 5%.
const MIN_VISIBLE_PERCENT$1 = 10;
class SettingsDisplayElement extends SettingsDisplayElementBase {
    static get is() {
        return 'settings-display';
    }
    static get template() {
        return getTemplate$31();
    }
    static get properties() {
        return {
            selectedModePref_: {
                type: Object,
                value() {
                    return {
                        key: 'fakeDisplaySliderPref',
                        type: chrome.settingsPrivate.PrefType.NUMBER,
                        value: 0,
                    };
                },
            },
            selectedZoomPref_: {
                type: Object,
                value() {
                    return {
                        key: 'fakeDisplaySliderZoomPref',
                        type: chrome.settingsPrivate.PrefType.NUMBER,
                        value: 0,
                    };
                },
            },
            displays: Array,
            layouts: Array,
            /**
             * String listing the ids in displays. Used to observe changes to the
             * display configuration (i.e. when a display is added or removed).
             */
            displayIds: { type: String, observer: 'onDisplayIdsChanged_' },
            /** Primary display id */
            primaryDisplayId: String,
            primaryDisplay: Object,
            selectedDisplay: Object,
            /** Id passed to the overscan dialog. */
            overscanDisplayId: {
                type: String,
                notify: true,
            },
            /** Ids for mirroring destination displays. */
            mirroringDestinationIds: Array,
            /** Mode index values for slider. */
            modeValues_: Array,
            /**
             * Display zoom slider tick values.
             */
            zoomValues_: Array,
            displayModeList_: {
                type: Array,
                value: [],
            },
            refreshRateList_: {
                type: Array,
                value: [],
            },
            unifiedDesktopAvailable_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('unifiedDesktopAvailable');
                },
            },
            isDisplayPerformanceSupported_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('isDisplayPerformanceSupported');
                },
            },
            ambientColorAvailable_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('deviceSupportsAmbientColor');
                },
            },
            listAllDisplayModes_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('listAllDisplayModes');
                },
            },
            excludeDisplayInMirrorModeEnabled_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('excludeDisplayInMirrorModeEnabled');
                },
            },
            opsDisplayScaleFactorEnabled_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('opsDisplayScaleFactorEnabled');
                },
            },
            unifiedDesktopMode_: {
                type: Boolean,
                value: false,
            },
            isTabletMode_: {
                type: Boolean,
                value: false,
            },
            currentInternalScreenBrightness_: { type: Number, value: 0 },
            isAmbientLightSensorEnabled_: {
                type: Boolean,
                value: true,
            },
            hasAmbientLightSensor_: {
                type: Boolean,
                value: false,
            },
            brightnessSliderMin_: {
                type: Number,
                value: 5,
            },
            brightnessSliderMax_: {
                type: Number,
                value: 100,
            },
            isDisplayPerformanceEnabled_: {
                type: Boolean,
                value: false,
            },
            selectedParentModePref_: {
                type: Object,
                value: function () {
                    return {
                        key: 'fakeDisplayParentModePref',
                        type: chrome.settingsPrivate.PrefType.NUMBER,
                        value: 0,
                    };
                },
            },
            logicalResolutionText_: String,
            displayTabNames_: Array,
            selectedTab_: Number,
            /**
             * Contains the settingId of any deep link that wasn't able to be shown,
             * null otherwise.
             */
            pendingSettingId_: {
                type: Number,
                value: null,
            },
        };
    }
    static get observers() {
        return [
            'onSelectedModeChange_(selectedModePref_.value)',
            'onSelectedParentModeChange_(selectedParentModePref_.value)',
            'onSelectedZoomChange_(selectedZoomPref_.value)',
            'onDisplaysChanged_(displays.*)',
        ];
    }
    constructor() {
        super();
        // DeepLinkingMixin override
        this.supportedSettingIds = new Set([
            Setting.kDisplaySize,
            Setting.kDisplayOrientation,
            Setting.kDisplayArrangement,
            Setting.kDisplayResolution,
            Setting.kDisplayRefreshRate,
            Setting.kDisplayMirroring,
            Setting.kAllowWindowsToSpanDisplays,
            Setting.kAmbientColors,
            Setting.kTouchscreenCalibration,
            Setting.kDisplayOverscan,
        ]);
        /**
         * This represents the index of the mode with the highest refresh rate at
         * the current resolution.
         */
        this.currentSelectedParentModeIndex_ = -1;
        /**
         * This is the index of the currently selected mode.
         * Selected mode index received from chrome.
         */
        this.currentSelectedModeIndex_ = -1;
        /**
         * Listener for chrome.system.display.onDisplayChanged events.
         */
        this.displayChangedListener_ = null;
        this.invalidDisplayId_ = loadTimeData.getString('invalidDisplayId');
        this.mirroringExcludedId_ = this.invalidDisplayId_;
        this.currentRoute_ = null;
        this.browserProxy_ = DevicePageBrowserProxyImpl.getInstance();
        /**
         * Maps a parentModeIndex to the list of possible refresh rates.
         * All modes have a modeIndex corresponding to the index in the selected
         * display's mode list. Parent mode indexes represent the mode with the
         * highest refresh rate at a given resolution. There is 1 and only 1
         * parentModeIndex for each possible resolution .
         */
        this.parentModeToRefreshRateMap_ = new Map();
        /**
         * Map containing an entry for each display mode mapping its modeIndex to
         * the corresponding parentModeIndex value.
         * Mode index values for slider.
         */
        this.modeToParentModeMap_ = new Map();
        // Provider of display settings mojo API.
        this.displaySettingsProvider = getDisplaySettingsProvider();
    }
    async connectedCallback() {
        super.connectedCallback();
        this.displayChangedListener_ =
            this.displayChangedListener_ || this.getDisplayInfo_.bind(this);
        getDisplayApi().onDisplayChanged.addListener(this.displayChangedListener_);
        this.getDisplayInfo_();
        this.$.displaySizeSlider.updateValueInstantly = false;
        const { isTabletMode } = await this.displaySettingsProvider.observeTabletMode(new TabletModeObserverReceiver(this).$.bindNewPipeAndPassRemote());
        this.isTabletMode_ = isTabletMode;
        const { brightnessPercent } = await this.displaySettingsProvider.observeDisplayBrightnessSettings(new DisplayBrightnessSettingsObserverReceiver(this)
            .$.bindNewPipeAndPassRemote());
        this.currentInternalScreenBrightness_ = brightnessPercent;
        const { isAmbientLightSensorEnabled } = await this.displaySettingsProvider.observeAmbientLightSensor(new AmbientLightSensorObserverReceiver(this)
            .$.bindNewPipeAndPassRemote());
        this.isAmbientLightSensorEnabled_ = isAmbientLightSensorEnabled;
        const { hasAmbientLightSensor } = await this.displaySettingsProvider.hasAmbientLightSensor();
        this.hasAmbientLightSensor_ = hasAmbientLightSensor;
        this.displaySettingsProvider.observeDisplayConfiguration(new DisplayConfigurationObserverReceiver(this)
            .$.bindNewPipeAndPassRemote());
        // Record metrics that user has opened the display settings page.
        this.displaySettingsProvider.recordChangingDisplaySettings(DisplaySettingsType.kDisplayPage, /*value=*/ createDisplayValue({}));
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        getDisplayApi().onDisplayChanged.removeListener(castExists(this.displayChangedListener_));
        this.currentSelectedModeIndex_ = -1;
        this.currentSelectedParentModeIndex_ = -1;
    }
    /**
     * Implements TabletModeObserver.OnTabletModeChanged.
     */
    onTabletModeChanged(isTabletMode) {
        this.isTabletMode_ = isTabletMode;
    }
    /**
     * Implements DisplayConfigurationObserver.OnDisplayConfigurationChanged.
     */
    onDisplayConfigurationChanged() {
        // Sync active display settings to avoid UI inconsistency.
        this.getDisplayInfo_();
    }
    /**
     * Implements DisplayBrightnessSettingsObserver.OnDisplayBrightnessChanged.
     */
    onDisplayBrightnessChanged(brightnessPercent, triggeredByAls) {
        if (triggeredByAls && brightnessPercent > 0 &&
            brightnessPercent < MIN_VISIBLE_PERCENT$1) {
            // When auto-brightness is enabled, it's likely that the automated
            // brightness percentage will fall between 0% and 10%. To avoid confusion
            // where the user cannot distinguish between the screen being off (0%)
            // and low brightness levels, set the slider to a minimum visible
            // percentage (10%).
            this.currentInternalScreenBrightness_ = MIN_VISIBLE_PERCENT$1;
            return;
        }
        this.currentInternalScreenBrightness_ = brightnessPercent;
    }
    /**
     * Implements AmbientLightSensorObserver.OnAmbientLightSensorEnabledChanged.
     */
    onAmbientLightSensorEnabledChanged(isAmbientLightSensorEnabled) {
        this.isAmbientLightSensorEnabled_ = isAmbientLightSensorEnabled;
    }
    beforeDeepLinkAttempt(_settingId) {
        if (!this.displays) {
            // On initial page load, displays will not be loaded and deep link
            // attempt will fail. Suppress warnings by exiting early and try again
            // in updateDisplayInfo_.
            return false;
        }
        // Continue with deep link attempt.
        return true;
    }
    currentRouteChanged(newRoute, oldRoute) {
        this.currentRoute_ = newRoute;
        // When navigating away from the page, deselect any selected display.
        if (newRoute !== routes.DISPLAY && oldRoute === routes.DISPLAY) {
            this.browserProxy_.highlightDisplay(this.invalidDisplayId_);
            return;
        }
        // Does not apply to this page.
        if (newRoute !== routes.DISPLAY) {
            this.pendingSettingId_ = null;
            return;
        }
        this.attemptDeepLink().then(result => {
            if (!result.deepLinkShown && result.pendingSettingId) {
                // Store any deep link settingId that wasn't shown so we can try again
                // in updateDisplayInfo_.
                this.pendingSettingId_ = result.pendingSettingId;
            }
        });
    }
    /**
     * Shows or hides the overscan dialog.
     */
    showOverscanDialog_(showOverscan) {
        if (showOverscan) {
            this.$.displayOverscan.open();
            this.$.displayOverscan.focus();
        }
        else {
            this.$.displayOverscan.close();
        }
    }
    onDisplayIdsChanged_() {
        // Close any overscan dialog (which will cancel any overscan operation)
        // if displayIds changes.
        this.showOverscanDialog_(false);
    }
    getDisplayInfo_() {
        const flags = {
            singleUnified: true,
        };
        getDisplayApi().getInfo(flags).then((displays) => this.displayInfoFetched_(displays));
    }
    displayInfoFetched_(displays) {
        if (!displays.length) {
            return;
        }
        getDisplayApi().getDisplayLayout().then((layouts) => this.displayLayoutFetched_(displays, layouts));
        if (this.isMirrored(displays)) {
            this.mirroringDestinationIds = displays[0].mirroringDestinationIds;
            // If the display length is not 1, it means we are in mixed mirror mode,
            // so we need to update mirroringExcludedId_.
            if (displays.length !== 1) {
                const mirroringSourceId = displays[0].mirroringSourceId;
                this.mirroringExcludedId_ =
                    this.displays
                        .filter(display => !this.mirroringDestinationIds.includes(display.id) &&
                        display.id !== mirroringSourceId)[0]
                        .id;
            }
            else {
                this.mirroringExcludedId_ = this.invalidDisplayId_;
            }
        }
        else {
            this.mirroringDestinationIds = [];
        }
    }
    displayLayoutFetched_(displays, layouts) {
        this.layouts = layouts;
        this.displays = displays;
        this.displayTabNames_ = displays.map(({ name }) => name);
        this.updateDisplayInfo_();
    }
    /**
     * @return The index of the currently selected mode of the
     * |selectedDisplay|. If the display has no modes, returns 0.
     */
    getSelectedModeIndex_(selectedDisplay) {
        for (let i = 0; i < selectedDisplay.modes.length; ++i) {
            if (selectedDisplay.modes[i].isSelected) {
                return i;
            }
        }
        return 0;
    }
    isDevicePolicyEnabled_(policyPref) {
        return policyPref !== undefined && policyPref.value !== null;
    }
    isDisplayResolutionManagedByPolicy_(resolutionPref) {
        return this.isDevicePolicyEnabled_(resolutionPref) &&
            (resolutionPref.value.external_use_native !== undefined ||
                (resolutionPref.value.external_width !== undefined &&
                    resolutionPref.value.external_height !== undefined));
    }
    /**
     * Checks if display resolution is managed by policy and the policy
     * is mandatory.
     */
    isDisplayResolutionMandatory_(resolutionPref) {
        return this.isDisplayResolutionManagedByPolicy_(resolutionPref) &&
            !resolutionPref.value.recommended;
    }
    /**
     * Checks if display scale factor is managed by device policy.
     */
    isDisplayScaleManagedByPolicy_(selectedDisplay, resolutionPref) {
        if (!this.isDevicePolicyEnabled_(resolutionPref) || !selectedDisplay) {
            return false;
        }
        if (selectedDisplay.isInternal) {
            return resolutionPref.value.internal_scale_percentage !== undefined;
        }
        return resolutionPref.value.external_scale_percentage !== undefined;
    }
    /**
     * Checks if display scale factor is managed by policy and the policy
     * is mandatory.
     */
    isDisplayScaleMandatory_(selectedDisplay, resolutionPref) {
        return this.isDisplayScaleManagedByPolicy_(selectedDisplay, resolutionPref) &&
            !resolutionPref.value.recommended;
    }
    /**
     * Parses the display modes for |selectedDisplay|. |displayModeList_| will
     * contain entries representing a combined resolution + refresh rate.
     * Only one parse*DisplayModes_ method must be called, depending on the
     * state of |listAllDisplayModes_|.
     */
    parseCompoundDisplayModes_(selectedDisplay) {
        assert(!this.listAllDisplayModes_);
        const optionList = [];
        for (let i = 0; i < selectedDisplay.modes.length; ++i) {
            const mode = selectedDisplay.modes[i];
            const id = 'displayResolutionMenuItem';
            const refreshRate = Math.round(mode.refreshRate * 100) / 100;
            const resolution = this.i18n(id, mode.widthInNativePixels.toString(), mode.heightInNativePixels.toString(), refreshRate.toString());
            optionList.push({
                name: resolution,
                value: i,
            });
        }
        this.displayModeList_ = optionList;
    }
    /**
     * Uses the modes of |selectedDisplay| to build a nested map of width =>
     * height => refreshRate => modeIndex. modeIndex is the index of the
     * resolution + refreshRate combination in |selectedDisplay|'s mode list.
     * This is used to traverse all possible display modes in ascending order.
     */
    createModeMap_(selectedDisplay) {
        const modes = new Map();
        for (let i = 0; i < selectedDisplay.modes.length; ++i) {
            const mode = selectedDisplay.modes[i];
            if (!modes.has(mode.widthInNativePixels)) {
                modes.set(mode.widthInNativePixels, new Map());
            }
            if (!modes.get(mode.widthInNativePixels).has(mode.heightInNativePixels)) {
                modes.get(mode.widthInNativePixels)
                    .set(mode.heightInNativePixels, new Map());
            }
            // Prefer the first native mode we find, for consistency.
            if (modes.get(mode.widthInNativePixels)
                .get(mode.heightInNativePixels)
                .has(mode.refreshRate)) {
                const existingModeIndex = modes.get(mode.widthInNativePixels)
                    .get(mode.heightInNativePixels)
                    .get(mode.refreshRate);
                const existingMode = selectedDisplay.modes[existingModeIndex];
                if (existingMode.isNative || !mode.isNative) {
                    continue;
                }
            }
            modes.get(mode.widthInNativePixels)
                .get(mode.heightInNativePixels)
                .set(mode.refreshRate, i);
        }
        return modes;
    }
    /**
     * Parses the display modes for |selectedDisplay|. |displayModeList_| will
     * contain entries representing only resolution options.
     * The 'parentMode' for a resolution is the highest refresh rate. This
     * method goes through the mode list for a given display creating data
     * structures so that given a resolution, the default refresh rate is
     * selected, and other possible refresh rates at that resolution are shown
     * in a dropdown. Only one parse*DisplayModes_ method must be called,
     * depending on the state of |listAllDisplayModes_|.
     */
    parseSplitDisplayModes_(selectedDisplay) {
        assert(this.listAllDisplayModes_);
        // Clear the mappings before recalculating.
        this.modeToParentModeMap_ = new Map();
        this.parentModeToRefreshRateMap_ = new Map();
        this.displayModeList_ = [];
        // Build the modes into a nested map of width => height => refresh rate.
        const modes = this.createModeMap_(selectedDisplay);
        // Traverse the modes ordered by width (asc), height (asc),
        // refresh rate (desc).
        const widthsArr = Array.from(modes.keys()).sort();
        for (let i = 0; i < widthsArr.length; i++) {
            const width = widthsArr[i];
            const heightsMap = modes.get(width);
            const heightArr = Array.from(heightsMap.keys());
            for (let j = 0; j < heightArr.length; j++) {
                // The highest/first refresh rate for each width/height pair
                // (resolution) is the default and therefore the "parent" mode.
                const height = heightArr[j];
                const refreshRates = heightsMap.get(height);
                const parentModeIndex = this.getParentModeIndex_(refreshRates);
                this.addResolution_(parentModeIndex, width, height);
                // For each of the refresh rates at a given resolution, add an entry
                // to |parentModeToRefreshRateMap_|. This allows us to retrieve a
                // list of all the possible refresh rates given a resolution's
                // parentModeIndex.
                const refreshRatesArr = Array.from(refreshRates.keys());
                for (let k = 0; k < refreshRatesArr.length; k++) {
                    const rate = refreshRatesArr[k];
                    const modeIndex = refreshRates.get(rate);
                    const isInterlaced = selectedDisplay.modes[modeIndex].isInterlaced;
                    this.addRefreshRate_(parentModeIndex, modeIndex, rate, isInterlaced);
                }
            }
        }
        // Construct mode->parentMode map so we can get parent modes later.
        for (let i = 0; i < selectedDisplay.modes.length; i++) {
            const mode = selectedDisplay.modes[i];
            const parentModeIndex = this.getParentModeIndex_(modes.get(mode.widthInNativePixels).get(mode.heightInNativePixels));
            this.modeToParentModeMap_.set(i, parentModeIndex);
        }
        assert(this.modeToParentModeMap_.size === selectedDisplay.modes.length);
        // Use the new sort order.
        this.sortResolutionList_();
    }
    /**
     * Picks the appropriate parent mode from a refresh rate -> mode index map.
     * Currently this chooses the mode with the highest refresh rate.
     * @param refreshRates each possible refresh rate
     *   mapped to the corresponding mode index.
     */
    getParentModeIndex_(refreshRates) {
        const maxRefreshRate = Math.max(...refreshRates.keys());
        // maxRefreshRate always exists as a key
        return refreshRates.get(maxRefreshRate);
    }
    /**
     * Adds a an entry in |displayModeList_| for the resolution represented by
     * |width| and |height| and possible |refreshRates|.
     */
    addResolution_(parentModeIndex, width, height) {
        assert(this.listAllDisplayModes_);
        // Add an entry in the outer map for |parentModeIndex|. The inner
        // array (the value at |parentModeIndex|) will be populated with all
        // possible refresh rates for the given resolution.
        this.parentModeToRefreshRateMap_.set(parentModeIndex, []);
        const resolutionOption = this.i18n('displayResolutionOnlyMenuItem', width, height);
        // Only store one entry in the |resolutionList| per resolution,
        // mapping it to the parentModeIndex for that resolution.
        this.push('displayModeList_', {
            name: resolutionOption,
            value: parentModeIndex,
        });
    }
    /**
     * Adds a an entry in |parentModeToRefreshRateMap_| for the refresh rate
     * represented by |rate|.
     */
    addRefreshRate_(parentModeIndex, modeIndex, rate, isInterlaced) {
        assert(this.listAllDisplayModes_);
        // Truncate at two decimal places for display. If the refresh rate
        // is a whole number, remove the mantissa.
        let refreshRate = Number(rate).toFixed(2);
        if (refreshRate.endsWith('.00')) {
            refreshRate = refreshRate.substring(0, refreshRate.length - 3);
        }
        const id = isInterlaced ? 'displayRefreshRateInterlacedMenuItem' :
            'displayRefreshRateMenuItem';
        const refreshRateOption = this.i18n(id, refreshRate.toString());
        this.parentModeToRefreshRateMap_.get(parentModeIndex).push({
            name: refreshRateOption,
            value: modeIndex,
        });
    }
    /**
     * Sorts |displayModeList_| in descending order. First order sort is width,
     * second order sort is height.
     */
    sortResolutionList_() {
        const getWidthFromResolutionString = (str) => {
            return Number(str.substr(0, str.indexOf(' ')));
        };
        this.displayModeList_ =
            this.displayModeList_
                .sort((first, second) => {
                return getWidthFromResolutionString(first.name) -
                    getWidthFromResolutionString(second.name);
            })
                .reverse();
    }
    /**
     * Parses display modes for |selectedDisplay|. A 'mode' is a resolution +
     * refresh rate combo. If |listAllDisplayModes_| is on, resolution and
     * refresh rate are parsed into separate dropdowns and
     * |parentModeToRefreshRateMap_| + |modeToParentModeMap_| are populated.
     */
    updateDisplayModeStructures_(selectedDisplay) {
        if (this.listAllDisplayModes_) {
            this.parseSplitDisplayModes_(selectedDisplay);
        }
        else {
            this.parseCompoundDisplayModes_(selectedDisplay);
        }
    }
    /**
     * Returns a value from |zoomValues_| that is closest to the display zoom
     * percentage currently selected for the |selectedDisplay|.
     */
    getSelectedDisplayZoom_(selectedDisplay) {
        const selectedZoom = selectedDisplay.displayZoomFactor;
        let closestMatch = this.zoomValues_[0].value;
        let minimumDiff = Math.abs(closestMatch - selectedZoom);
        for (let i = 0; i < this.zoomValues_.length; i++) {
            const currentDiff = Math.abs(this.zoomValues_[i].value - selectedZoom);
            if (currentDiff < minimumDiff) {
                closestMatch = this.zoomValues_[i].value;
                minimumDiff = currentDiff;
            }
        }
        return closestMatch;
    }
    /**
     * Given the display with the current display mode, this function lists all
     * the display zoom values and their labels to be used by the slider.
     */
    getZoomValues_(selectedDisplay) {
        return selectedDisplay.availableDisplayZoomFactors.map(value => {
            const ariaValue = Math.round(value * 100);
            return {
                value,
                ariaValue,
                label: this.i18n('displayZoomValue', ariaValue.toString()),
            };
        });
    }
    /**
     * We need to call this explicitly rather than relying on change events
     * so that we can control the update order.
     */
    setSelectedDisplay_(selectedDisplay) {
        // |modeValues_| controls the resolution slider's tick values. Changing it
        // might trigger a change in the |selectedModePref_.value| if the number
        // of modes differs and the current mode index is out of range of the new
        // modes indices. Thus, we need to set |currentSelectedModeIndex_| to -1
        // to indicate that the |selectedDisplay| and |selectedModePref_.value|
        // are out of sync, and therefore getResolutionText_() and
        // onSelectedModeChange_() will be no-ops.
        this.currentSelectedModeIndex_ = -1;
        this.currentSelectedParentModeIndex_ = -1;
        const numModes = selectedDisplay.modes.length;
        this.modeValues_ = numModes === 0 ? [] : Array.from(Array(numModes).keys());
        // Note that the display zoom values has the same number of ticks for all
        // displays, so the above problem doesn't apply here.
        this.zoomValues_ = this.getZoomValues_(selectedDisplay);
        this.set('selectedZoomPref_.value', this.getSelectedDisplayZoom_(selectedDisplay));
        this.updateDisplayModeStructures_(selectedDisplay);
        // Set |selectedDisplay| first since only the resolution slider depends
        // on |selectedModePref_|.
        this.selectedDisplay = selectedDisplay;
        this.selectedTab_ = this.displays.indexOf(this.selectedDisplay);
        const currentModeIndex = this.getSelectedModeIndex_(selectedDisplay);
        this.currentSelectedModeIndex_ = currentModeIndex;
        // This will also cause the parent mode to be updated.
        this.set('selectedModePref_.value', this.currentSelectedModeIndex_);
        if (this.listAllDisplayModes_) {
            // Now that everything is in sync, set the selected mode to its correct
            // value right before updating the pref.
            this.currentSelectedParentModeIndex_ =
                this.modeToParentModeMap_.get(currentModeIndex);
            this.refreshRateList_ = this.parentModeToRefreshRateMap_.get(this.currentSelectedParentModeIndex_);
        }
        else {
            this.currentSelectedParentModeIndex_ = currentModeIndex;
        }
        this.set('selectedParentModePref_.value', this.currentSelectedParentModeIndex_);
        this.updateLogicalResolutionText_(this.selectedZoomPref_.value);
    }
    /**
     * Returns true if the resolution setting needs to be displayed.
     */
    showDropDownResolutionSetting_(display) {
        return !display.isInternal;
    }
    /**
     * Returns true if the refresh rate setting needs to be displayed.
     */
    showRefreshRateSetting_(display) {
        return this.listAllDisplayModes_ &&
            this.showDropDownResolutionSetting_(display);
    }
    /**
     * Returns true if external touch devices are connected and the current
     * display is not an internal display. If the feature is not enabled via the
     * switch, this will return false.
     * @param display Display being checked for touch support.
     */
    showTouchCalibrationSetting_(display) {
        return !display.isInternal &&
            loadTimeData.getBoolean('enableTouchCalibrationSetting');
    }
    /**
     * Returns true if external touch devices are connected a
     */
    showTouchRemappingExperience_() {
        return loadTimeData.getBoolean('enableTouchscreenMappingExperience');
    }
    /**
     * Returns true if the overscan setting should be shown for |display|.
     */
    showOverscanSetting_(display) {
        return !display.isInternal;
    }
    /**
     * Returns true if display brightness controls should be shown for |display|.
     */
    showBrightnessControls_(display) {
        return isDisplayBrightnessControlInSettingsEnabled() && display.isInternal;
    }
    /**
     * Returns true if the auto-brightness toggle should be shown.
     */
    showAutoBrightnessToggle_() {
        return isDisplayBrightnessControlInSettingsEnabled() &&
            this.hasAmbientLightSensor_;
    }
    /**
     * Returns true if the ambient color setting should be shown for |display|.
     */
    showAmbientColorSetting(ambientColorAvailable, display) {
        return ambientColorAvailable && display && display.isInternal;
    }
    hasMultipleDisplays_() {
        return this.displays.length > 1;
    }
    /**
     * Returns false if the display select menu has to be hidden.
     */
    showDisplaySelectMenu_(displays, selectedDisplay) {
        if (selectedDisplay) {
            return displays.length > 1 && !selectedDisplay.isPrimary;
        }
        return false;
    }
    /**
     * Returns the select menu index indicating whether the display currently is
     * primary or extended.
     * @return Returns 0 if the display is primary else returns 1.
     */
    getDisplaySelectMenuIndex_(selectedDisplay, primaryDisplayId) {
        if (selectedDisplay && selectedDisplay.id === primaryDisplayId) {
            return 0;
        }
        return 1;
    }
    /**
     * Returns the i18n string for the text to be used for mirroring settings.
     * @return i18n string for mirroring settings text.
     */
    getDisplayMirrorText_(displays, primaryDisplay) {
        if (primaryDisplay) {
            return this.i18n('displayMirror', primaryDisplay.name);
        }
        return this.i18n('displayMirror', displays[0].name);
    }
    showUnifiedDesktop(unifiedDesktopAvailable, unifiedDesktopMode, displays, isTabletMode) {
        if (displays === undefined) {
            return false;
        }
        // Unified desktop is not supported in tablet mode.
        return unifiedDesktopMode ||
            (unifiedDesktopAvailable && displays.length > 1 &&
                !this.isMirrored(displays) && !isTabletMode);
    }
    getUnifiedDesktopText_(unifiedDesktopMode) {
        return this.i18n(unifiedDesktopMode ? 'displayUnifiedDesktopOn' :
            'displayUnifiedDesktopOff');
    }
    showMirror(unifiedDesktopMode, displays) {
        if (displays === undefined) {
            return false;
        }
        return this.isMirrored(displays) ||
            (!unifiedDesktopMode && displays.length > 1);
    }
    isMirrored(displays) {
        return displays !== undefined && displays.length > 0 &&
            !!displays[0].mirroringSourceId;
    }
    showExcludeInMirror_(unifiedDesktopMode, excludeDisplayInMirrorModeEnabled, allowExcludeDisplayInMirrorModePref, displays, selectedDisplay) {
        if (!selectedDisplay) {
            return false;
        }
        if (this.isMirrored(displays)) {
            return selectedDisplay.id === this.mirroringExcludedId_;
        }
        if (!excludeDisplayInMirrorModeEnabled &&
            !allowExcludeDisplayInMirrorModePref) {
            return false;
        }
        if (displays.length < 3) {
            return false;
        }
        return this.showMirror(unifiedDesktopMode, displays);
    }
    isSelected_(display, selectedDisplay) {
        return display.id === selectedDisplay.id;
    }
    enableSetResolution_(selectedDisplay) {
        return selectedDisplay.modes.length > 1;
    }
    enableDisplayZoomSlider_(selectedDisplay) {
        return selectedDisplay.availableDisplayZoomFactors.length > 1;
    }
    /**
     * Returns true if the given mode is the best mode for the
     * |selectedDisplay|.
     */
    isBestMode_(selectedDisplay, mode) {
        if (!selectedDisplay.isInternal) {
            return mode.isNative;
        }
        // Things work differently for full HD devices(1080p). The best mode is
        // the one with 1.25 device scale factor and 0.8 ui scale.
        if (mode.heightInNativePixels === 1080) {
            return Math.abs(mode.uiScale - 0.8) < 0.001 &&
                Math.abs(mode.deviceScaleFactor - 1.25) < 0.001;
        }
        return mode.uiScale === 1.0;
    }
    getResolutionText_() {
        assertExists(this.selectedDisplay);
        if (this.selectedDisplay.modes.length === 0 ||
            this.currentSelectedModeIndex_ === -1) {
            // If currentSelectedModeIndex_ is -1, selectedDisplay and
            // |selectedModePref_.value| are not in sync.
            return this.i18n('displayResolutionText', this.selectedDisplay.bounds.width.toString(), this.selectedDisplay.bounds.height.toString());
        }
        const mode = castExists(this.selectedDisplay.modes[this.selectedModePref_.value]);
        const widthStr = mode.widthInNativePixels.toString();
        const heightStr = mode.heightInNativePixels.toString();
        if (this.isBestMode_(this.selectedDisplay, mode)) {
            return this.i18n('displayResolutionTextBest', widthStr, heightStr);
        }
        else if (mode.isNative) {
            return this.i18n('displayResolutionTextNative', widthStr, heightStr);
        }
        return this.i18n('displayResolutionText', widthStr, heightStr);
    }
    /**
     * Updates the logical resolution text to be used for the display size
     * section
     * @param zoomFactor Current zoom factor applied on the selected display.
     */
    updateLogicalResolutionText_(zoomFactor) {
        assertExists(this.selectedDisplay);
        if (!this.selectedDisplay.isInternal &&
            !this.opsDisplayScaleFactorEnabled_) {
            this.logicalResolutionText_ = '';
            return;
        }
        const mode = this.selectedDisplay.modes[this.currentSelectedModeIndex_];
        const deviceScaleFactor = mode.deviceScaleFactor;
        const inverseZoomFactor = 1.0 / zoomFactor;
        let logicalResolutionStrId = 'displayZoomLogicalResolutionText';
        if (Math.abs(deviceScaleFactor - inverseZoomFactor) < 0.001) {
            logicalResolutionStrId = 'displayZoomNativeLogicalResolutionNativeText';
        }
        else if (Math.abs(inverseZoomFactor - 1.0) < 0.001) {
            logicalResolutionStrId = 'displayZoomLogicalResolutionDefaultText';
        }
        let widthStr = Math.round(mode.widthInNativePixels / (deviceScaleFactor * zoomFactor))
            .toString();
        let heightStr = Math.round(mode.heightInNativePixels / (deviceScaleFactor * zoomFactor))
            .toString();
        if (this.shouldSwapLogicalResolutionText_()) {
            const temp = widthStr;
            widthStr = heightStr;
            heightStr = temp;
        }
        this.logicalResolutionText_ =
            this.i18n(logicalResolutionStrId, widthStr, heightStr);
    }
    /**
     * Determines whether width and height should be swapped in the
     * Logical Resolution Text. Returns true if the longer edge of the
     * display's native pixels is different than the longer edge of the
     * display's current bounds.
     */
    shouldSwapLogicalResolutionText_() {
        assertExists(this.selectedDisplay);
        const mode = this.selectedDisplay.modes[this.currentSelectedModeIndex_];
        const bounds = this.selectedDisplay.bounds;
        return bounds.width > bounds.height !==
            mode.widthInNativePixels > mode.heightInNativePixels;
    }
    /**
     * Handles the event where the display size slider is being dragged, i.e.
     * the mouse or tap has not been released.
     */
    onDisplaySizeSliderDrag_() {
        if (!this.selectedDisplay) {
            return;
        }
        const slider = castExists(this.$.displaySizeSlider.shadowRoot.querySelector('#slider'));
        const zoomFactor = this.$.displaySizeSlider.ticks[slider.value].value;
        this.updateLogicalResolutionText_(zoomFactor);
    }
    /**
     * @param e |e.detail| is the id of the selected display.
     */
    onSelectDisplay_(e) {
        const id = e.detail;
        for (let i = 0; i < this.displays.length; ++i) {
            const display = this.displays[i];
            if (id === display.id) {
                if (this.selectedDisplay !== display) {
                    this.setSelectedDisplay_(display);
                }
                return;
            }
        }
    }
    onSelectDisplayTab_() {
        const { selected } = castExists(this.shadowRoot.querySelector('cr-tabs'));
        if (this.selectedTab_ !== selected) {
            this.setSelectedDisplay_(this.displays[selected]);
        }
    }
    /**
     * Handles event when a touch calibration option is selected.
     */
    onTouchCalibrationClick_() {
        getDisplayApi().showNativeTouchCalibration(this.selectedDisplay.id);
    }
    onTouchMappingClick_() {
        this.displaySettingsProvider.startNativeTouchscreenMappingExperience();
    }
    /**
     * Handles the event when an option from display select menu is selected.
     */
    updatePrimaryDisplay_(e) {
        if (!this.selectedDisplay) {
            return;
        }
        if (this.selectedDisplay.id === this.primaryDisplayId) {
            return;
        }
        if (!e.target.value) {
            return;
        }
        const properties = {
            isPrimary: true,
        };
        getDisplayApi()
            .setDisplayProperties(this.selectedDisplay.id, properties)
            .then(() => this.setPropertiesCallback_());
        this.displaySettingsProvider.recordChangingDisplaySettings(DisplaySettingsType.kPrimaryDisplay, createDisplayValue({}));
    }
    /**
     * Handles the event when the display brightness slider changes value.
     */
    onDisplayBrightnessSliderChanged_() {
        if (!isDisplayBrightnessControlInSettingsEnabled()) {
            return;
        }
        const brightnessSliderValue = strictQuery('#brightnessSlider', this.shadowRoot, CrSliderElement)
            .value;
        // Clamp the brightness value between 5 and 100 inclusive.
        const newBrightness = Math.max(this.brightnessSliderMin_, Math.min(brightnessSliderValue, this.brightnessSliderMax_));
        this.displaySettingsProvider.setInternalDisplayScreenBrightness(newBrightness);
    }
    /**
     * Handles the event when the auto-brightness toggle changes value.
     */
    onAutoBrightnessToggleChange_() {
        if (!isDisplayBrightnessControlInSettingsEnabled()) {
            return;
        }
        const isAutoBrightnessToggleChecked = strictQuery('#autoBrightnessToggle', this.shadowRoot, CrToggleElement)
            .checked;
        this.displaySettingsProvider.setInternalDisplayAmbientLightSensorEnabled(isAutoBrightnessToggleChecked);
    }
    onAutoBrightnessToggleRowClicked_() {
        const autoBrightnessToggle = strictQuery('#autoBrightnessToggle', this.shadowRoot, CrToggleElement);
        autoBrightnessToggle.checked = !autoBrightnessToggle.checked;
        this.onAutoBrightnessToggleChange_();
    }
    /**
     * Handles a change in the |selectedParentModePref| value triggered via the
     * observer.
     */
    onSelectedParentModeChange_(newModeIndex) {
        if (this.currentSelectedParentModeIndex_ === newModeIndex) {
            return;
        }
        if (!this.hasNewParentModeBeenSet()) {
            // Don't change the selected display mode until we have received an
            // update from Chrome and the mode differs from the current mode.
            return;
        }
        // Reset |selectedModePref| to the parentMode.
        this.set('selectedModePref_.value', this.selectedParentModePref_.value);
    }
    /**
     * Returns True if a new parentMode has been set and we have received an
     * update from Chrome.
     */
    hasNewParentModeBeenSet() {
        if (this.currentSelectedParentModeIndex_ === -1) {
            return false;
        }
        return this.currentSelectedParentModeIndex_ !==
            this.selectedParentModePref_.value;
    }
    /**
     * Returns True if a new mode has been set and we have received an update
     * from Chrome.
     */
    hasNewModeBeenSet() {
        if (this.currentSelectedModeIndex_ === -1) {
            return false;
        }
        if (this.currentSelectedParentModeIndex_ !==
            this.selectedParentModePref_.value) {
            return true;
        }
        return this.currentSelectedModeIndex_ !== this.selectedModePref_.value;
    }
    /**
     * Handles a change in |selectedModePref| triggered via the observer.
     */
    onSelectedModeChange_(newModeIndex) {
        // We want to ignore all value changes to the pref due to the slider being
        // dragged. See http://crbug/845712 for more info.
        if (this.currentSelectedModeIndex_ === newModeIndex) {
            return;
        }
        if (!this.hasNewModeBeenSet()) {
            // Don't change the selected display mode until we have received an
            // update from Chrome and the mode differs from the current mode.
            return;
        }
        assertExists(this.selectedDisplay);
        const properties = {
            displayMode: this.selectedDisplay.modes[this.selectedModePref_.value],
        };
        this.refreshRateList_ = castExists(this.parentModeToRefreshRateMap_.get(this.selectedParentModePref_.value));
        getDisplayApi()
            .setDisplayProperties(this.selectedDisplay.id, properties)
            .then(() => this.setPropertiesCallback_());
        // Compare new mode and current mode to find out if user has changed the
        // resolution or just the refresh rate.
        const currentMode = this.selectedDisplay.modes[this.currentSelectedModeIndex_];
        const newMode = this.selectedDisplay.modes[this.selectedModePref_.value];
        const displaySettingsType = (currentMode.heightInNativePixels === newMode.heightInNativePixels &&
            currentMode.widthInNativePixels === newMode.widthInNativePixels) ?
            DisplaySettingsType.kRefreshRate :
            DisplaySettingsType.kResolution;
        this.displaySettingsProvider.recordChangingDisplaySettings(displaySettingsType, createDisplayValue({
            isInternalDisplay: this.selectedDisplay.isInternal,
            displayId: BigInt(this.selectedDisplay.id),
        }));
    }
    /**
     * Triggerend when the display size slider changes its value. This only
     * occurs when the value is committed (i.e. not while the slider is being
     * dragged).
     */
    onSelectedZoomChange_() {
        if (this.currentSelectedModeIndex_ === -1 || !this.selectedDisplay) {
            return;
        }
        const properties = {
            displayZoomFactor: this.selectedZoomPref_.value,
        };
        getDisplayApi()
            .setDisplayProperties(this.selectedDisplay.id, properties)
            .then(() => this.setPropertiesCallback_());
        this.displaySettingsProvider.recordChangingDisplaySettings(DisplaySettingsType.kScaling, createDisplayValue({
            isInternalDisplay: this.selectedDisplay.isInternal,
            displayId: BigInt(this.selectedDisplay.id),
        }));
    }
    /**
     * Returns whether the option "Auto-rotate" is one of the shown options in
     * the rotation drop-down menu.
     */
    showAutoRotateOption_(selectedDisplay) {
        return selectedDisplay.isAutoRotationAllowed;
    }
    onOrientationChange_(event) {
        const select = cast(event.target, HTMLSelectElement);
        const value = parseInt(select.value, 10);
        assertExists(this.selectedDisplay);
        assert(value !== -1 || this.selectedDisplay.isAutoRotationAllowed);
        const properties = {
            rotation: value,
        };
        getDisplayApi()
            .setDisplayProperties(this.selectedDisplay.id, properties)
            .then(() => this.setPropertiesCallback_());
        let orientation = DisplaySettingsOrientationOption.k0Degree;
        if (value === -1) {
            orientation = DisplaySettingsOrientationOption.kAuto;
        }
        else if (value === 90) {
            orientation = DisplaySettingsOrientationOption.k90Degree;
        }
        else if (value === 180) {
            orientation = DisplaySettingsOrientationOption.k180Degree;
        }
        else if (value === 270) {
            orientation = DisplaySettingsOrientationOption.k270Degree;
        }
        this.displaySettingsProvider.recordChangingDisplaySettings(DisplaySettingsType.kOrientation, createDisplayValue({ isInternalDisplay: this.selectedDisplay.isInternal, orientation }));
    }
    onMirroredClick_(event) {
        // Blur the control so that when the transition animation completes and
        // the UI is focused, the control does not receive focus. crbug.com/785070
        event.currentTarget.blur();
        const mirrorModeInfo = {
            mode: this.isMirrored(this.displays) ? MirrorMode.OFF :
                this.mirroringExcludedId_ === this.invalidDisplayId_ ?
                    MirrorMode.NORMAL :
                    MirrorMode.MIXED,
        };
        if (mirrorModeInfo.mode === MirrorMode.MIXED) {
            const mirroredDisplay = this.displayIds.split(',').filter(display => (display !== this.mirroringExcludedId_));
            mirrorModeInfo.mirroringSourceId = mirroredDisplay[0];
            mirrorModeInfo.mirroringDestinationIds = mirroredDisplay.slice(1);
        }
        this.setMirrorMode(mirrorModeInfo);
    }
    shouldExcludeInMirror_(selectedDisplay) {
        return this.mirroringExcludedId_ === selectedDisplay.id;
    }
    onExcludeInMirrorClick_(event) {
        event.currentTarget.blur();
        assertExists(this.selectedDisplay);
        if (this.mirroringExcludedId_ === this.selectedDisplay.id) {
            this.mirroringExcludedId_ = this.invalidDisplayId_;
        }
        else {
            this.mirroringExcludedId_ = this.selectedDisplay.id;
        }
        if (this.isMirrored(this.displays)) {
            const mirrorModeInfo = {
                mode: MirrorMode.NORMAL,
            };
            this.setMirrorMode(mirrorModeInfo);
        }
    }
    setMirrorMode(mirrorModeInfo) {
        getDisplayApi().setMirrorMode(mirrorModeInfo).then(() => {
            const error = chrome.runtime.lastError;
            if (error) {
                console.error('setMirrorMode Error: ' + error.message);
            }
        });
        this.displaySettingsProvider.recordChangingDisplaySettings(DisplaySettingsType.kMirrorMode, /*value=*/ createDisplayValue({
            mirrorModeStatus: mirrorModeInfo.mode !== MirrorMode.OFF,
        }));
    }
    onUnifiedDesktopClick_() {
        const properties = {
            isUnified: !this.unifiedDesktopMode_,
        };
        getDisplayApi()
            .setDisplayProperties(this.primaryDisplayId, properties)
            .then(() => this.setPropertiesCallback_());
        const unified = properties.isUnified === undefined ? null : properties.isUnified;
        this.displaySettingsProvider.recordChangingDisplaySettings(DisplaySettingsType.kUnifiedMode, createDisplayValue({ unifiedModeStatus: unified }));
    }
    onOverscanClick_(e) {
        e.preventDefault();
        assert(this.selectedDisplay);
        this.overscanDisplayId = this.selectedDisplay.id;
        this.showOverscanDialog_(true);
        this.displaySettingsProvider.recordChangingDisplaySettings(DisplaySettingsType.kOverscan, createDisplayValue({ isInternalDisplay: this.selectedDisplay.isInternal }));
    }
    onCloseOverscanDialog_() {
        focusWithoutInk$1(castExists(this.shadowRoot.getElementById('overscan')));
    }
    updateDisplayInfo_() {
        let displayIds = '';
        let primaryDisplay = undefined;
        let selectedDisplay = undefined;
        for (let i = 0; i < this.displays.length; ++i) {
            const display = this.displays[i];
            if (displayIds) {
                displayIds += ',';
            }
            displayIds += display.id;
            if (display.isPrimary && !primaryDisplay) {
                primaryDisplay = display;
            }
            if (this.selectedDisplay && display.id === this.selectedDisplay.id) {
                selectedDisplay = display;
            }
        }
        this.displayIds = displayIds;
        this.primaryDisplay = primaryDisplay;
        this.primaryDisplayId = (primaryDisplay && primaryDisplay.id) || '';
        selectedDisplay = selectedDisplay || primaryDisplay ||
            (this.displays && this.displays[0]);
        this.setSelectedDisplay_(selectedDisplay);
        this.unifiedDesktopMode_ = !!primaryDisplay && primaryDisplay.isUnified;
        // Check if we have yet to focus a deep-linked element.
        if (!this.pendingSettingId_) {
            return;
        }
        this.showDeepLink(this.pendingSettingId_).then(result => {
            if (result.deepLinkShown) {
                this.pendingSettingId_ = null;
            }
        });
    }
    setPropertiesCallback_() {
        if (chrome.runtime.lastError) {
            console.error('setDisplayProperties Error: ' + chrome.runtime.lastError.message);
        }
    }
    shouldShowArrangementSection() {
        if (!this.displays) {
            return false;
        }
        return this.hasMultipleDisplays_() || this.isMirrored(this.displays);
    }
    onDisplaysChanged_() {
        flush();
        const displayLayout = this.shadowRoot.querySelector('display-layout');
        if (displayLayout) {
            displayLayout.updateDisplays(this.displays, this.layouts, this.mirroringDestinationIds);
        }
    }
    toggleDisplayPerformanceEnabled_() {
        this.isDisplayPerformanceEnabled_ = !this.isDisplayPerformanceEnabled_;
        this.displaySettingsProvider.setShinyPerformance(this.isDisplayPerformanceEnabled_);
    }
    getInvalidDisplayId() {
        return this.invalidDisplayId_;
    }
    getRefreshRateList() {
        return this.refreshRateList_;
    }
    getModeToParentModeMap() {
        return this.modeToParentModeMap_;
    }
    getParentModeToRefreshRateMap() {
        return this.parentModeToRefreshRateMap_;
    }
    getSelectedZoomPref() {
        return this.selectedZoomPref_;
    }
}
customElements.define(SettingsDisplayElement.is, SettingsDisplayElement);

function getTemplate$30() {
    return html `<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">#appIcon{order:-1;padding-inline-end:12px;padding-left:0px}#openApp{padding-inline-start:0px}</style>
<cr-link-row
    id="openApp"
    class="hr"
    on-click="onCompanionAppRowClick"
    label="[[openAppLabel]]"
    external>
    <img
        id="appIcon"
        is="cr-auto-img"
        width="32"
        height="32"
        alt=""
        auto-src="[[appInfo.iconUrl]]">
</cr-link-row>
<!--_html_template_end_-->`;
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'per-device-app-installed-row' is responsible for displaying companion app
 * information for an installed app.
 */
const PerDeviceAppInstalledRowElementBase = I18nMixin(PolymerElement);
class PerDeviceAppInstalledRowElement extends PerDeviceAppInstalledRowElementBase {
    constructor() {
        super(...arguments);
        this.inputDeviceSettingsProvider = getInputDeviceSettingsProvider();
    }
    static get is() {
        return 'per-device-app-installed-row';
    }
    static get template() {
        return getTemplate$30();
    }
    static get properties() {
        return {
            appInfo: {
                type: Object,
            },
            openAppLabel: {
                type: String,
                computed: 'computeOpenAppLabel(appInfo.*)',
            },
        };
    }
    computeOpenAppLabel() {
        return this.i18n('openAppLabel', this.appInfo.appName);
    }
    onCompanionAppRowClick() {
        this.inputDeviceSettingsProvider.launchCompanionApp(this.appInfo.packageId);
    }
}
customElements.define(PerDeviceAppInstalledRowElement.is, PerDeviceAppInstalledRowElement);

function getTemplate$2$() {
    return html `<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">.app-info-container{align-items:center;display:flex;justify-content:space-between;padding:var(--cr-section-vertical-padding) var(--cr-section-padding)}.app-details{align-items:center;box-sizing:border-box;display:flex;gap:12px}
</style>
<div class="app-info-container bottom-divider">
  <div class="app-info">
    <div class="app-details" aria-hidden="true">
      <img
          id="app-icon"
          is="cr-auto-img"
          alt=""
          width="32"
          height="32"
          auto-src="[[appInfo.iconUrl]]">
      <span id="appName">[[installAppLabel]]</span>
    </div>
  </div>
  <cr-button
      role="button"
      id="installButton"
      on-click="onInstallCompanionAppButtonClicked"
      aria-labelledby="appName">
    $i18n{installAppButton}
  </cr-button>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'per-device-install-row' is responsible for displaying companion app
 * information and initiating the app installation flow.
 */
const PerDeviceInstallRowElementBase = I18nMixin(PolymerElement);
class PerDeviceInstallRowElement extends PerDeviceInstallRowElementBase {
    static get is() {
        return 'per-device-install-row';
    }
    static get template() {
        return getTemplate$2$();
    }
    static get properties() {
        return {
            appInfo: {
                type: Object,
            },
            installAppLabel: {
                type: String,
                value: '',
                computed: 'computeInstallAppLabel(appInfo.*)',
            },
        };
    }
    onInstallCompanionAppButtonClicked() {
        window.open(this.appInfo.actionLink);
    }
    computeInstallAppLabel() {
        return this.i18n('installAppLabel', this.appInfo.appName);
    }
}
customElements.define(PerDeviceInstallRowElement.is, PerDeviceInstallRowElement);

function getTemplate$2_() {
    return html `<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">.device-details{align-items:flex-start;display:flex;flex-direction:column}.device-info{align-items:center;box-sizing:border-box;display:flex;gap:16px;padding-bottom:var(--cr-section-vertical-padding);padding-inline-start:18px;padding-top:var(--cr-section-vertical-padding)}.device-image{border-radius:20px;height:32px;width:32px}#deviceIcon{--iron-icon-fill-color:var(--cros-sys-primary)}.icon-container{background-color:var(--cros-sys-primary_container);border-radius:50%;height:20px;padding:8px;width:20px}.device-details{display:flex;flex-direction:column}</style>
<div role="region" aria-label="[[getAriaLabel(name, batteryInfo.*)]]">
  <h2 aria-hidden="true" class="subsection-header bottom-divider"
      id="deviceName">
    [[name]]
  </h2>
  <template is="dom-if" if="[[isWelcomeExperienceEnabled]]">
    <div aria-hidden="true" class="device-info bottom-divider">
      <template is="dom-if" if="[[shouldShowPlaceholder(deviceDisplayState)]]">
        <div class="icon-container"></div>
      </template>
      <template is="dom-if"
          if="[[shouldShowDeviceIcon(deviceDisplayState)]]" restamp>
        <iron-icon icon="[[icon]]" class="icon-container" id="deviceIcon">
        </iron-icon>
      </template>
      <img
          class="device-image"
          src="[[deviceImageDataUrl]]"
          hidden="[[!deviceImageDataUrl]]"
          alt="">
      <div class="device-details">
        <div class="device-info-header" id="deviceInfoName">
          [[name]]
        </div>
        <template is="dom-if" if="[[showBatteryInfo(batteryInfo.*)]]">
          <bluetooth-battery-icon-percentage
              id="batteryIcon"
              device="[[bluetoothDevice]]"
              battery-type="[[getDefaultBatteryType()]]">
          </bluetooth-battery-icon-percentage>
        </template>
      </div>
    </div>
  </template>
</div><!--_html_template_end_-->`;
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'per-device-subsection-header' displays information about a device, with
 * conditional layout based on the 'isWelcomeExperienceEnabled' flag.
 * - When enabled: Shows device image (if available), name, and optional battery
 * info.
 * - When disabled: Shows device name only.
 */
// Defines the possible states for a device's display.
var DeviceDisplayState;
(function (DeviceDisplayState) {
    DeviceDisplayState[DeviceDisplayState["FETCHING_IMAGE"] = 0] = "FETCHING_IMAGE";
    DeviceDisplayState[DeviceDisplayState["IMAGE_AVAILABLE"] = 1] = "IMAGE_AVAILABLE";
    DeviceDisplayState[DeviceDisplayState["IMAGE_UNAVAILABLE"] = 2] = "IMAGE_UNAVAILABLE";
})(DeviceDisplayState || (DeviceDisplayState = {}));
const PerDeviceSubsectionHeaderElementBase = I18nMixin(PolymerElement);
class PerDeviceSubsectionHeaderElement extends PerDeviceSubsectionHeaderElementBase {
    constructor() {
        super(...arguments);
        this.deviceImageDataUrl = null;
        this.inputDeviceSettingsProvider = getInputDeviceSettingsProvider();
    }
    static get is() {
        return 'per-device-subsection-header';
    }
    static get template() {
        return getTemplate$2_();
    }
    static get properties() {
        return {
            isWelcomeExperienceEnabled: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('enableWelcomeExperience');
                },
                readOnly: true,
            },
            deviceImageDataUrl: {
                type: String,
                value: '',
            },
            batteryInfo: {
                type: Object,
            },
            bluetoothDevice: {
                type: Object,
                computed: 'computeBluetoothDeviceProperties(batteryInfo.*)',
            },
            deviceKey: {
                type: String,
            },
            name: {
                type: String,
            },
            icon: {
                type: String,
            },
            deviceDisplayState: {
                type: Number,
                value: DeviceDisplayState.FETCHING_IMAGE,
            },
        };
    }
    static get observers() {
        return [
            'handleDeviceKeyChange(deviceKey)',
        ];
    }
    showBatteryInfo() {
        return !!this.batteryInfo;
    }
    getDefaultBatteryType() {
        return BatteryType.DEFAULT;
    }
    computeBluetoothDeviceProperties() {
        if (!this.batteryInfo) {
            return null;
        }
        return createBluetoothDeviceProperties(this.deviceKey, this.name, this?.batteryInfo.batteryPercentage);
    }
    async handleDeviceKeyChange() {
        if (this.isWelcomeExperienceEnabled) {
            this.deviceDisplayState = DeviceDisplayState.FETCHING_IMAGE;
            this.deviceImageDataUrl =
                (await this.inputDeviceSettingsProvider.getDeviceIconImage(this.deviceKey))
                    ?.dataUrl;
            this.deviceDisplayState = this.deviceImageDataUrl ?
                DeviceDisplayState.IMAGE_AVAILABLE :
                DeviceDisplayState.IMAGE_UNAVAILABLE;
        }
    }
    shouldShowPlaceholder() {
        return this.deviceDisplayState === DeviceDisplayState.FETCHING_IMAGE;
    }
    shouldShowDeviceIcon() {
        return this.deviceDisplayState === DeviceDisplayState.IMAGE_UNAVAILABLE;
    }
    getAriaLabel() {
        let label = `${this.i18n('deviceNameLabel')} ${this.name}`;
        if (this.batteryInfo?.batteryPercentage) {
            label += ` ${this.i18n('deviceBatteryLabel', this?.batteryInfo.batteryPercentage)}`;
        }
        return label;
    }
}
customElements.define(PerDeviceSubsectionHeaderElement.is, PerDeviceSubsectionHeaderElement);

function getTemplate$2Z() {
    return html `<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">#header{display:flex;height:24px;padding:12px 0}.subsection{margin-bottom:0;margin-top:8px}#description{color:var(--cr-secondary-text-color);margin-inline-start:20px}</style>
<template is="dom-repeat" items="[[graphicsTablets]]"
    as="graphicsTablet" index-as="index" restamp>
    <div class="device" data-evdev-id$="[[graphicsTablet.id]]">
      <per-device-subsection-header
          device-key="[[graphicsTablet.deviceKey]]"
          name="[[graphicsTablet.name]]"
          battery-info="[[graphicsTablet.batteryInfo]]"
          icon="os-settings:device-tablet">
      </per-device-subsection-header>
      <div class="subsection">
        <template is="dom-if"
            if="[[showInstallAppRow(graphicsTablet.appInfo)]]">
          <per-device-install-row app-info="[[graphicsTablet.appInfo]]">
          </per-device-install-row>
        </template>
        <template is="dom-if"
            if="[[showCustomizeTabletButtonsRow(graphicsTablet)]]">
          <cr-link-row id="customizeTabletButtons"
              class="bottom-divider" on-click="onCustomizeTabletButtonsClick"
              aria-describedby="graphicsTabletName"
              label="$i18n{customizeTabletButtonsLabel}">
          </cr-link-row>
        </template>
        <cr-link-row id="customizePenButtons"
            class="hr bottom-divider" on-click="onCustomizePenButtonsClick"
            aria-describedby="graphicsTabletName"
            label="$i18n{customizePenButtonsLabel}">
        </cr-link-row>
      </div>
    </div>
    <template is="dom-if"
        if="[[isCompanionAppInstalled(graphicsTablet.appInfo)]]">
      <per-device-app-installed-row app-info="[[graphicsTablet.appInfo]]">
      </per-device-app-installed-row>
    </template>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'settings-graphics-tablet-subpage' allow users to configure their graphics
 * tablet settings for each device in system settings.
 */
const SettingsGraphicsTabletSubpageElementBase = RouteObserverMixin(I18nMixin(PolymerElement));
class SettingsGraphicsTabletSubpageElement extends SettingsGraphicsTabletSubpageElementBase {
    constructor() {
        super(...arguments);
        this.inputDeviceSettingsProvider = getInputDeviceSettingsProvider();
    }
    static get is() {
        return 'settings-graphics-tablet-subpage';
    }
    static get template() {
        return getTemplate$2Z();
    }
    static get properties() {
        return {
            prefs: {
                type: Object,
                notify: true,
            },
            graphicsTablets: {
                type: Array,
                observer: 'onGraphicsTabletListUpdated',
            },
            /**
               Used to track if the pen customize button row is clicked.
             */
            currentPenChanged: {
                type: Boolean,
            },
            /**
               Used to track if the tablet customize button row is clicked.
             */
            currentTabletChanged: {
                type: Boolean,
            },
            /**
               Used to track which graphics tablet navigates to the customization
               subpage.
             */
            deviceId: {
                type: Number,
            },
        };
    }
    currentRouteChanged(route) {
        // Avoid override deviceId, currentPenChanged, currentTabletChanged when on
        // the customization subpage.
        if (route === routes.CUSTOMIZE_PEN_BUTTONS ||
            route === routes.CUSTOMIZE_TABLET_BUTTONS) {
            return;
        }
        // Does not apply to this page.
        if (route !== routes.GRAPHICS_TABLET) {
            // Reset all values when on other pages.
            this.deviceId = -1;
            this.currentPenChanged = false;
            this.currentTabletChanged = false;
            return;
        }
        // Don't attempt to focus any item unless the last navigation was a
        // 'pop' (backwards) navigation.
        if (!Router.getInstance().lastRouteChangeWasPopstate()) {
            return;
        }
        else {
            // Loop through the graphics tablets and refocus on the
            // cr-link-row with the same device ID when navigating back to the
            // graphics tablet subpage.
            const graphicsTablets = this.shadowRoot.querySelectorAll('.device');
            for (const graphicsTablet of graphicsTablets) {
                if (Number(graphicsTablet.getAttribute('data-evdev-id')) ===
                    this.deviceId) {
                    if (this.currentPenChanged) {
                        graphicsTablet
                            .querySelector('#customizePenButtons').focus();
                    }
                    else if (this.currentTabletChanged) {
                        graphicsTablet
                            .querySelector('#customizeTabletButtons').focus();
                    }
                }
            }
        }
        this.deviceId = -1;
        this.currentPenChanged = false;
        this.currentTabletChanged = false;
    }
    onGraphicsTabletListUpdated(newGraphicsTabletList, oldGraphicsTabletList) {
        if (!oldGraphicsTabletList) {
            return;
        }
        const { msgId, deviceNames } = getDeviceStateChangesToAnnounce(newGraphicsTabletList, oldGraphicsTabletList);
        for (const deviceName of deviceNames) {
            getInstance().announce(this.i18n(msgId, deviceName));
        }
    }
    onCustomizeTabletButtonsClick(e) {
        Router.getInstance().navigateTo(routes.CUSTOMIZE_TABLET_BUTTONS, 
        /* dynamicParams= */ this.getSelectedGraphicsTabletUrl(e), 
        /* removeSearch= */ true);
        this.currentTabletChanged = true;
    }
    showInstallAppRow(appInfo) {
        return appInfo?.state === CompanionAppState$1.kAvailable;
    }
    onCustomizePenButtonsClick(e) {
        Router.getInstance().navigateTo(routes.CUSTOMIZE_PEN_BUTTONS, 
        /* dynamicParams= */ this.getSelectedGraphicsTabletUrl(e), 
        /* removeSearch= */ true);
        this.currentPenChanged = true;
    }
    showCustomizeTabletButtonsRow(graphicsTablet) {
        // Hide the graphics tablet button page when there are no buttons
        // due to having metadata about the device.
        return (graphicsTablet.graphicsTabletButtonConfig ===
            GraphicsTabletButtonConfig$1.kNoConfig) ||
            (graphicsTablet.settings.tabletButtonRemappings.length !== 0);
    }
    getSelectedGraphicsTabletUrl(e) {
        const customizeTabletButton = cast(e.target, CrLinkRowElement);
        const closestTablet = castExists(customizeTabletButton.closest('.device'));
        const graphicsTabletId = closestTablet.getAttribute('data-evdev-id');
        this.deviceId = Number(graphicsTabletId);
        return new URLSearchParams({
            graphicsTabletId: encodeURIComponent(graphicsTabletId),
        });
    }
    isCompanionAppInstalled(appInfo) {
        return appInfo?.state === CompanionAppState$1.kInstalled;
    }
}
customElements.define(SettingsGraphicsTabletSubpageElement.is, SettingsGraphicsTabletSubpageElement);

function getTemplate$2Y() {
    return html `<!--_html_template_start_--><style include="settings-shared">h2{padding-inline-start:var(--cr-section-padding)}.subsection{padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-indent-padding)}.subsection>cr-link-row,.subsection>settings-toggle-button{padding-inline-end:0;padding-inline-start:0}</style>
<template is="dom-if" if="[[hasLauncherKey_]]">
  <div class="settings-box first" id="launcherKey">
    <div class="start" aria-hidden="true">$i18n{keyboardKeySearch}</div>
    <settings-dropdown-menu label="$i18n{keyboardKeySearch}"
        pref="{{prefs.settings.language.xkb_remap_search_key_to}}"
        menu-options="[[keyMapTargets_]]">
    </settings-dropdown-menu>
  </div>
</template>
<div class="settings-box">
  <div class="start" aria-hidden="true">$i18n{keyboardKeyCtrl}</div>
  <settings-dropdown-menu label="$i18n{keyboardKeyCtrl}"
      pref="{{prefs.settings.language.xkb_remap_control_key_to}}"
      menu-options="[[keyMapTargets_]]">
  </settings-dropdown-menu>
</div>
<div class="settings-box">
  <div class="start" aria-hidden="true">$i18n{keyboardKeyAlt}</div>
  <settings-dropdown-menu label="$i18n{keyboardKeyAlt}"
      pref="{{prefs.settings.language.xkb_remap_alt_key_to}}"
      menu-options="[[keyMapTargets_]]">
  </settings-dropdown-menu>
</div>
<div class="settings-box">
  <div class="start" aria-hidden="true">$i18n{keyboardKeyEscape}</div>
  <settings-dropdown-menu label="$i18n{keyboardKeyEscape}"
      pref="{{prefs.settings.language.remap_escape_key_to}}"
      menu-options="[[keyMapTargets_]]">
  </settings-dropdown-menu>
</div>
<div class="settings-box">
  <div class="start" aria-hidden="true">$i18n{keyboardKeyBackspace}</div>
  <settings-dropdown-menu label="$i18n{keyboardKeyBackspace}"
      pref="{{prefs.settings.language.remap_backspace_key_to}}"
      menu-options="[[keyMapTargets_]]">
  </settings-dropdown-menu>
</div>
<template is="dom-if" if="[[hasAssistantKey_]]">
  <div class="settings-box" id="assistantKey">
    <div class="start" aria-hidden="true">$i18n{keyboardKeyAssistant}</div>
    <settings-dropdown-menu label="$i18n{keyboardKeyAssistant}"
        pref="{{prefs.settings.language.xkb_remap_assistant_key_to}}"
        menu-options="[[keyMapTargets_]]">
    </settings-dropdown-menu>
  </div>
</template>
<template is="dom-if" if="[[showCapsLock_]]">
  <div class="settings-box" id="capsLockKey">
    <div class="start" aria-hidden="true">$i18n{keyboardKeyCapsLock}</div>
    <settings-dropdown-menu label="$i18n{keyboardKeyCapsLock}"
        pref="{{prefs.settings.language.remap_caps_lock_key_to}}"
        menu-options="[[keyMapTargets_]]">
    </settings-dropdown-menu>
  </div>
</template>
<template is="dom-if" if="[[showExternalMetaKey_]]">
  <div class="settings-box" id="externalMetaKey">
    <div class="start" aria-hidden="true">
      [[getExternalMetaKeyLabel_(hasLauncherKey_)]]
    </div>
    <settings-dropdown-menu
        label="[[getExternalMetaKeyLabel_(hasLauncherKey_)]]"
        pref="{{prefs.settings.language.remap_external_meta_key_to}}"
        menu-options="[[keyMapTargets_]]">
    </settings-dropdown-menu>
  </div>
</template>
<template is="dom-if" if="[[showAppleCommandKey_]]">
  <div class="settings-box" id="externalCommandKey">
    <div class="start" aria-hidden="true">
      [[getExternalCommandKeyLabel_(hasLauncherKey_)]]
    </div>
    <settings-dropdown-menu
        label="[[getExternalCommandKeyLabel_(hasLauncherKey_)]]"
        pref="{{prefs.settings.language.remap_external_command_key_to}}"
        menu-options="[[keyMapTargets_]]">
    </settings-dropdown-menu>
  </div>
</template>
<settings-toggle-button
    class="hr"
    pref="{{prefs.settings.language.send_function_keys}}"
    label="$i18n{keyboardSendFunctionKeys}"
    sub-label="$i18n{keyboardSendFunctionKeysDescription}"
    deep-link-focus-id$="[[Setting.kKeyboardFunctionKeys]]">
</settings-toggle-button>
<h2>$i18n{keyboardHoldingKeys}</h2>
<div class="subsection">
  <settings-toggle-button
      class="hr continuation"
      pref="{{prefs.settings.language.physical_keyboard_enable_diacritics_on_longpress}}"
      label="$i18n{keyboardAccentMarks}"
      sub-label="$i18n{keyboardAccentMarksSubLabel}"
      deep-link-focus-id$="[[Setting.kShowDiacritic]]">
  </settings-toggle-button>
  <settings-toggle-button
      class="hr continuation"
      pref="{{prefs.settings.language.xkb_auto_repeat_enabled_r2}}"
      label="$i18n{keyboardEnableAutoRepeat}"
      sub-label="$i18n{keyboardEnableAutoRepeatSubLabel}"
      deep-link-focus-id$="[[Setting.kKeyboardAutoRepeat]]">
  </settings-toggle-button>
  <iron-collapse
      opened="[[prefs.settings.language.xkb_auto_repeat_enabled_r2.value]]">
    <div class="settings-box continuation embedded">
      <div class="start" id="repeatDelayLabel" aria-hidden="true">
        $i18n{keyRepeatDelay}
      </div>
      <settings-slider id="delaySlider"
          pref="{{prefs.settings.language.xkb_auto_repeat_delay_r2}}"
          ticks="[[autoRepeatDelays_]]"
          disabled="[[
              !prefs.settings.language.xkb_auto_repeat_enabled_r2.value]]"
          label-aria="$i18n{keyRepeatDelay}"
          label-min="$i18n{keyRepeatDelayLong}"
          label-max="$i18n{keyRepeatDelayShort}">
      </settings-slider>
    </div>
    <div class="settings-box continuation embedded">
      <div class="start" id="repeatRateLabel" aria-hidden="true">
        $i18n{keyRepeatRate}
      </div>
      <settings-slider id="repeatRateSlider"
          pref="{{
              prefs.settings.language.xkb_auto_repeat_interval_r2}}"
          ticks="[[autoRepeatIntervals_]]"
          disabled="[[
              !prefs.settings.language.xkb_auto_repeat_enabled_r2.value]]"
          label-aria="$i18n{keyRepeatRate}"
          label-min="$i18n{keyRepeatRateSlow}"
          label-max="$i18n{keyRepeatRateFast}">
      </settings-slider>
    </div>
  </iron-collapse>
</div>
<cr-link-row id="shortcutCustomizationApp" class="hr"
    on-click="onShowShortcutCustomizationAppClick_"
    label="$i18n{showShortcutCustomizationApp}"
    external
    deep-link-focus-id$="[[Setting.kKeyboardShortcuts]]">
</cr-link-row>
<cr-link-row id="inputRow"
    class="hr" on-click="onShowInputSettingsClick_"
    label="$i18n{keyboardShowInputSettings}"
    role-description="$i18n{subpageArrowRoleDescription}">
</cr-link-row>
<cr-link-row id="a11yKeyboardRow"
    class="hr" on-click="onShowA11yKeyboardSettingsClick_"
    label="$i18n{keyboardShowA11yKeyboardSettings}"
    role-description="$i18n{subpageArrowRoleDescription}">
</cr-link-row>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'settings-keyboard' is the settings subpage for keyboard settings.
 */
/**
 * Modifier key IDs corresponding to the ModifierKey enumerators in
 * /ui/base/ime/ash/ime_keyboard.h.
 */
var ModifierKey$1;
(function (ModifierKey) {
    ModifierKey[ModifierKey["SEARCH_KEY"] = 0] = "SEARCH_KEY";
    ModifierKey[ModifierKey["CONTROL_KEY"] = 1] = "CONTROL_KEY";
    ModifierKey[ModifierKey["ALT_KEY"] = 2] = "ALT_KEY";
    ModifierKey[ModifierKey["VOID_KEY"] = 3] = "VOID_KEY";
    ModifierKey[ModifierKey["CAPS_LOCK_KEY"] = 4] = "CAPS_LOCK_KEY";
    ModifierKey[ModifierKey["ESCAPE_KEY"] = 5] = "ESCAPE_KEY";
    ModifierKey[ModifierKey["BACKSPACE_KEY"] = 6] = "BACKSPACE_KEY";
    ModifierKey[ModifierKey["ASSISTANT_KEY"] = 7] = "ASSISTANT_KEY";
})(ModifierKey$1 || (ModifierKey$1 = {}));
const SettingsKeyboardElementBase = DeepLinkingMixin(RouteOriginMixin(WebUiListenerMixin(PolymerElement)));
class SettingsKeyboardElement extends SettingsKeyboardElementBase {
    static get is() {
        return 'settings-keyboard';
    }
    static get template() {
        return getTemplate$2Y();
    }
    static get properties() {
        return {
            /** Preferences state. */
            prefs: {
                type: Object,
                notify: true,
            },
            /** Whether to show Caps Lock options. */
            showCapsLock_: Boolean,
            /**
             * Whether this device has a ChromeOS launcher key. Applies only to
             * ChromeOS keyboards, internal or external.
             */
            hasLauncherKey_: Boolean,
            /** Whether this device has an Assistant key on keyboard. */
            hasAssistantKey_: Boolean,
            /**
             * Whether to show a remapping option for external keyboard's Meta key
             * (Search/Windows keys). This is true only when there's an external
             * keyboard connected that is a non-Apple keyboard.
             */
            showExternalMetaKey_: Boolean,
            /**
             * Whether to show a remapping option for the Command key. This is true
             * when one of the connected keyboards is an Apple keyboard.
             */
            showAppleCommandKey_: Boolean,
            /** Menu items for key mapping. */
            keyMapTargets_: Object,
            /**
             * Auto-repeat delays (in ms) for the corresponding slider values, from
             * long to short. The values were chosen to provide a large range while
             * giving several options near the defaults.
             */
            autoRepeatDelays_: {
                type: Array,
                value: [2000, 1500, 1000, 500, 300, 200, 150],
                readOnly: true,
            },
            /**
             * Auto-repeat intervals (in ms) for the corresponding slider values, from
             * long to short. The slider itself is labeled "rate", the inverse of
             * interval, and goes from slow (long interval) to fast (short interval).
             */
            autoRepeatIntervals_: {
                type: Array,
                value: [2000, 1000, 500, 300, 200, 100, 50, 30, 20],
                readOnly: true,
            },
        };
    }
    constructor() {
        super();
        // DeepLinkingMixin override
        this.supportedSettingIds = new Set([
            Setting.kKeyboardFunctionKeys,
            Setting.kKeyboardAutoRepeat,
            Setting.kKeyboardShortcuts,
            Setting.kShowDiacritic,
        ]);
        /** RouteOriginMixin override */
        this.route = routes.KEYBOARD;
        this.browserProxy_ = DevicePageBrowserProxyImpl.getInstance();
    }
    ready() {
        super.ready();
        this.addWebUiListener('show-keys-changed', this.onShowKeysChange_.bind(this));
        this.browserProxy_.initializeKeyboard();
        this.setUpKeyMapTargets_();
        this.addFocusConfig(routes.OS_LANGUAGES_INPUT, '#inputRow');
    }
    currentRouteChanged(newRoute, oldRoute) {
        super.currentRouteChanged(newRoute, oldRoute);
        // Does not apply to this page.
        if (newRoute !== this.route) {
            return;
        }
        if (Router.getInstance().currentRoute === this.route) {
            // Call setCurrentRoute function to go to the per device keyboard subpage
            // when the feature flag is turned on. We don't use navigateTo function
            // since we don't want to navigate back to the previous keyboard subpage.
            setTimeout(() => {
                Router.getInstance().setCurrentRoute(routes.PER_DEVICE_KEYBOARD, new URLSearchParams(), false);
            });
        }
        this.attemptDeepLink();
    }
    /**
     * Initializes the dropdown menu options for remapping keys.
     */
    setUpKeyMapTargets_() {
        // Ordering is according to UX, but values match ModifierKey.
        this.keyMapTargets_ = [
            {
                value: ModifierKey$1.SEARCH_KEY,
                name: loadTimeData.getString('keyboardKeySearch'),
            },
            {
                value: ModifierKey$1.CONTROL_KEY,
                name: loadTimeData.getString('keyboardKeyCtrl'),
            },
            {
                value: ModifierKey$1.ALT_KEY,
                name: loadTimeData.getString('keyboardKeyAlt'),
            },
            {
                value: ModifierKey$1.CAPS_LOCK_KEY,
                name: loadTimeData.getString('keyboardKeyCapsLock'),
            },
            {
                value: ModifierKey$1.ESCAPE_KEY,
                name: loadTimeData.getString('keyboardKeyEscape'),
            },
            {
                value: ModifierKey$1.BACKSPACE_KEY,
                name: loadTimeData.getString('keyboardKeyBackspace'),
            },
            {
                value: ModifierKey$1.ASSISTANT_KEY,
                name: loadTimeData.getString('keyboardKeyAssistant'),
            },
            {
                value: ModifierKey$1.VOID_KEY,
                name: loadTimeData.getString('keyboardKeyDisabled'),
            },
        ];
    }
    /**
     * Handler for updating which keys to show.
     */
    onShowKeysChange_(keyboardParams) {
        this.hasLauncherKey_ = keyboardParams['hasLauncherKey'];
        this.hasAssistantKey_ = keyboardParams['hasAssistantKey'];
        this.showCapsLock_ = keyboardParams['showCapsLock'];
        this.showExternalMetaKey_ = keyboardParams['showExternalMetaKey'];
        this.showAppleCommandKey_ = keyboardParams['showAppleCommandKey'];
    }
    onShowShortcutCustomizationAppClick_() {
        this.browserProxy_.showShortcutCustomizationApp();
    }
    onShowInputSettingsClick_() {
        Router.getInstance().navigateTo(routes.OS_LANGUAGES_INPUT, 
        /*dynamicParams=*/ undefined, /*removeSearch=*/ true);
    }
    onShowA11yKeyboardSettingsClick_() {
        Router.getInstance().navigateTo(routes.A11Y_KEYBOARD_AND_TEXT_INPUT, 
        /*dynamicParams=*/ undefined, /*removeSearch=*/ true);
    }
    getExternalMetaKeyLabel_(hasLauncherKey) {
        return loadTimeData.getString(hasLauncherKey ? 'keyboardKeyExternalMeta' : 'keyboardKeyMeta');
    }
    getExternalCommandKeyLabel_(hasLauncherKey) {
        return loadTimeData.getString(hasLauncherKey ? 'keyboardKeyExternalCommand' : 'keyboardKeyCommand');
    }
}
customElements.define(SettingsKeyboardElement.is, SettingsKeyboardElement);

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview A helper object used to get a pluralized string.
 */
// clang-format off
class PluralStringProxyImpl {
    getPluralString(messageName, itemCount) {
        return sendWithPromise('getPluralString', messageName, itemCount);
    }
    getPluralStringTupleWithComma(messageName1, itemCount1, messageName2, itemCount2) {
        return sendWithPromise('getPluralStringTupleWithComma', messageName1, itemCount1, messageName2, itemCount2);
    }
    getPluralStringTupleWithPeriods(messageName1, itemCount1, messageName2, itemCount2) {
        return sendWithPromise('getPluralStringTupleWithPeriods', messageName1, itemCount1, messageName2, itemCount2);
    }
    static getInstance() {
        return instance$a || (instance$a = new PluralStringProxyImpl());
    }
    static setInstance(obj) {
        instance$a = obj;
    }
}
let instance$a = null;

function getTemplate$2X() {
    return html `<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">.settings-box{border-top:none;border-bottom:var(--cr-separator-line)}#keyboardAutoBrightnessToggle,#rgbKeyboardControlLink{border-bottom:var(--cr-separator-line)}</style>
<template is="dom-if"
    if="[[showKeyboardSettings(keyboard, isLidOpen)]]" restamp>
  <per-device-subsection-header
      id="subsectionHeader"
      device-key="[[keyboard.deviceKey]]"
      name="[[getKeyboardName(keyboard.name)]]"
      battery-info="[[keyboard.batteryInfo]]"
      icon="os-settings:device-keyboard">
  </per-device-subsection-header>
  <div class="subsection">
    <template is="dom-if" if="[[showInstallAppRow(keyboard.appInfo)]]">
      <per-device-install-row app-info="[[keyboard.appInfo]]">
      </per-device-install-row>
    </template>
    <template is="dom-if" if="[[!isChromeOsKeyboard(keyboard)]]" restamp>
      <settings-toggle-button
          inverted="true"
          id="externalTopRowAreFunctionKeysButton"
          pref="{{topRowAreFunctionKeysPref}}"
          aria-describedby="keyboardName"
          label="$i18n{keyboardSendInvertedFunctionKeys}"
          sub-label="$i18n{keyboardSendInvertedFunctionKeysDescription}"
          deep-link-focus-id$="[[Setting.kKeyboardFunctionKeys]]">
      </settings-toggle-button>
      <settings-toggle-button
          inverted="true"
          class="hr" id="blockMetaFunctionKeyRewritesButton"
          pref="{{blockMetaFunctionKeyRewritesPref}}"
          aria-describedby="keyboardName"
          label="$i18n{keyboardBlockMetaFunctionKeyRewrites}"
          sub-label="$i18n{keyboardBlockMetaFunctionKeyRewritesDescription}"
          deep-link-focus-id$="[[Setting.kKeyboardBlockMetaFkeyRewrites]]">
      </settings-toggle-button>
    </template>
    <template is="dom-if" if="[[isChromeOsKeyboard(keyboard)]]" restamp>
      <template is="dom-if" if="[[hasKeyboardBacklight]]">
        <settings-toggle-button id="keyboardAutoBrightnessToggle"
            pref="{{keyboardAutoBrightnessPref}}"
            on-settings-boolean-control-change=
                "onKeyboardAutoBrightnessToggleChanged"
            label="$i18n{keyboardEnableAutoBrightnessLabel}"
            sub-label="$i18n{keyboardEnableAutoBrightnessSubLabel}"
            hidden="[[!hasAmbientLightSensor]]">
        </settings-toggle-button>
        <div class="settings-box">
          <div class="start" id="keyboardBrightnessPercentLabel"
              aria-hidden="true">
            $i18n{keyboardBrightnessLabel}
          </div>
          <settings-slider id="keyboardBrightnessSlider"
              pref="{{keyboardBrightnessPercentPref}}"
              label-aria="$i18n{keyboardBrightnessLabel}"
              on-pointerup="onPointerup"
              on-keyup="onKeyup"
              on-cr-slider-value-changed="onKeyboardBrightnessSliderChanged">
          </settings-slider>
        </div>
      </template>
      <cr-link-row id="rgbKeyboardControlLink" label="$i18n{keyboardColors}"
        hidden="[[!isRgbKeyboardSupported]]" on-click="openPersonalizationHub"
        external>
      </cr-link-row>
      <settings-toggle-button
          id="internalTopRowAreFunctionKeysButton"
          pref="{{topRowAreFunctionKeysPref}}"
          aria-describedby="keyboardName"
          label="$i18n{keyboardSendFunctionKeys}"
          sub-label="[[showSendFunctionKeyDescription(keyboard)]]"
          deep-link-focus-id$="[[Setting.kKeyboardFunctionKeys]]">
      </settings-toggle-button>
    </template>
    <cr-link-row id="remapKeyboardKeys"
        class$="[[getRemapKeyboardKeysClass(keyboard)]]"
        on-click="onRemapKeyboardKeysClick"
        aria-describedby="keyboardName"
        label="$i18n{remapKeyboardKeysRowLabel}"
        sub-label="[[remapKeyboardKeysSublabel]]"
        deep-link-focus-id$="[[Setting.kKeyboardRemapKeys]]">
    </cr-link-row>
    <template is="dom-if" if="[[isCompanionAppInstalled(keyboard.appInfo)]]">
      <per-device-app-installed-row app-info="[[keyboard.appInfo]]">
      </per-device-app-installed-row>
    </template>
  </div>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'per-device-keyboard-subsection' allow users to configure their
 * per-device-keyboard subsection settings in system settings.
 */
const SettingsPerDeviceKeyboardSubsectionElementBase = DeepLinkingMixin(I18nMixin(RouteObserverMixin(PolymerElement)));
const MIN_VISIBLE_PERCENT = 5;
class SettingsPerDeviceKeyboardSubsectionElement extends SettingsPerDeviceKeyboardSubsectionElementBase {
    constructor() {
        super(...arguments);
        // DeepLinkingMixin override
        this.supportedSettingIds = new Set([
            Setting.kKeyboardFunctionKeys,
            Setting.kKeyboardRemapKeys,
        ]);
        this.isInitialized = false;
        this.inputDeviceSettingsProvider = getInputDeviceSettingsProvider();
        this.personalizationHubBrowserProxy = PersonalizationHubBrowserProxyImpl.getInstance();
    }
    static get is() {
        return 'settings-per-device-keyboard-subsection';
    }
    static get template() {
        return getTemplate$2X();
    }
    static get properties() {
        return {
            topRowAreFunctionKeysPref: {
                type: Object,
                value() {
                    return {
                        key: 'fakeTopRowAreFunctionKeysPref',
                        type: chrome.settingsPrivate.PrefType.BOOLEAN,
                        value: false,
                    };
                },
            },
            blockMetaFunctionKeyRewritesPref: {
                type: Object,
                value() {
                    return {
                        key: 'fakeBlockMetaFunctionKeyRewritesPref',
                        type: chrome.settingsPrivate.PrefType.BOOLEAN,
                        value: false,
                    };
                },
            },
            keyboardBrightnessPercentPref: {
                type: Object,
                value() {
                    return {
                        key: 'fakekeyboardBrightnessPercentPref',
                        type: chrome.settingsPrivate.PrefType.NUMBER,
                        value: 40,
                    };
                },
            },
            keyboardAutoBrightnessPref: {
                type: Object,
                value() {
                    return {
                        key: 'fakekeyboardAutoBrightnessPref',
                        type: chrome.settingsPrivate.PrefType.BOOLEAN,
                        value: false,
                    };
                },
            },
            keyboard: {
                type: Object,
            },
            keyboardPolicies: {
                type: Object,
            },
            remapKeyboardKeysSublabel: {
                type: String,
                value: '',
            },
            keyboardIndex: {
                type: Number,
            },
            isLastDevice: {
                type: Boolean,
                reflectToAttribute: true,
            },
            isRgbKeyboardSupported: {
                type: Boolean,
                value: false,
            },
            hasKeyboardBacklight: {
                type: Boolean,
                value: false,
            },
            hasAmbientLightSensor: {
                type: Boolean,
                value: false,
            },
            isLidOpen: {
                type: Boolean,
                value: true,
            },
        };
    }
    static get observers() {
        return [
            'onSettingsChanged(topRowAreFunctionKeysPref.value,' +
                'blockMetaFunctionKeyRewritesPref.value,' +
                'enableAutoRepeatPref.value,' +
                'autoRepeatDelaysPref.value,' +
                'autoRepeatIntervalsPref.value)',
            'onPoliciesChanged(keyboardPolicies)',
            'onKeyboardRemappingsChanged(keyboard.*)',
            'updateSettingsToCurrentPrefs(keyboard)',
        ];
    }
    currentRouteChanged(newRoute) {
        // Does not apply to this page.
        if (newRoute !== routes.PER_DEVICE_KEYBOARD) {
            return;
        }
        if (this.keyboard.isExternal) {
            this.supportedSettingIds.add(Setting.kKeyboardBlockMetaFkeyRewrites);
        }
        // If multiple keyboards are available, focus on the first one.
        if (this.keyboardIndex === 0) {
            this.attemptDeepLink();
        }
    }
    async connectedCallback() {
        super.connectedCallback();
        // Add keyboardBrightnessChange observer.
        this.keyboardBrightnessObserverReceiver =
            new KeyboardBrightnessObserverReceiver(this);
        this.inputDeviceSettingsProvider.observeKeyboardBrightness(this.keyboardBrightnessObserverReceiver.$.bindNewPipeAndPassRemote());
        // Add keyboardAmbientLightSensorChange observer.
        this.keyboardAmbientLightSensorObserverReceiver =
            new KeyboardAmbientLightSensorObserverReceiver(this);
        this.inputDeviceSettingsProvider.observeKeyboardAmbientLightSensor(this.keyboardAmbientLightSensorObserverReceiver.$
            .bindNewPipeAndPassRemote());
        // Add LidState Observer.
        this.lidStateObserverReceiver = new LidStateObserverReceiver(this);
        this.inputDeviceSettingsProvider
            .observeLidState(this.lidStateObserverReceiver.$.bindNewPipeAndPassRemote())
            .then(({ isLidOpen }) => {
            this.onLidStateChanged(isLidOpen);
        });
        this.isRgbKeyboardSupported =
            (await this.inputDeviceSettingsProvider.isRgbKeyboardSupported())
                ?.isRgbKeyboardSupported;
        this.hasKeyboardBacklight =
            (await this.inputDeviceSettingsProvider.hasKeyboardBacklight())
                ?.hasKeyboardBacklight;
        this.hasAmbientLightSensor =
            (await this.inputDeviceSettingsProvider.hasAmbientLightSensor())
                ?.hasAmbientLightSensor;
        if (this.hasKeyboardBacklight && this.isChromeOsKeyboard()) {
            const crSlider = this.shadowRoot.querySelector('#keyboardBrightnessSlider')
                ?.shadowRoot.querySelector('cr-slider');
            if (crSlider) {
                // Set key press increment value to be 10.
                crSlider.setAttribute('key-press-slider-increment', '10');
            }
        }
    }
    showInstallAppRow() {
        return this.keyboard.appInfo?.state === CompanionAppState$1.kAvailable;
    }
    updateSettingsToCurrentPrefs() {
        // `updateSettingsToCurrentPrefs` gets called when the `keyboard` object
        // gets updated. This subsection element can be reused multiple times so we
        // need to reset `isInitialized` so we do not make unneeded API calls.
        this.isInitialized = false;
        this.set('topRowAreFunctionKeysPref.value', this.keyboard.settings.topRowAreFkeys);
        this.set('blockMetaFunctionKeyRewritesPref.value', this.keyboard.settings.suppressMetaFkeyRewrites);
        this.isInitialized = true;
    }
    onPoliciesChanged() {
        this.topRowAreFunctionKeysPref = {
            ...this.topRowAreFunctionKeysPref,
            ...getPrefPolicyFields$1(this.keyboardPolicies.topRowAreFkeysPolicy),
        };
        this.blockMetaFunctionKeyRewritesPref = {
            ...this.blockMetaFunctionKeyRewritesPref,
            ...getPrefPolicyFields$1(this.keyboardPolicies.enableMetaFkeyRewritesPolicy),
        };
    }
    onLearnMoreLinkClicked_(event) {
        const path = event.composedPath();
        if (!Array.isArray(path) || !path.length) {
            return;
        }
        if (path[0].tagName === 'A') {
            // Do not toggle reverse scrolling if the contained link is clicked.
            event.stopPropagation();
        }
    }
    onKeyboardBrightnessSliderChanged() {
        this.inputDeviceSettingsProvider.setKeyboardBrightness(this.getKeyboardBrightnessFromSlider());
    }
    onKeyup(event) {
        // Record updated brightness if adjusted via arrow keys.
        if (['ArrowRight', 'ArrowDown', 'ArrowLeft', 'ArrowUp'].includes(event.key)) {
            this.inputDeviceSettingsProvider.recordKeyboardBrightnessChangeFromSlider(this.getKeyboardBrightnessFromSlider());
        }
    }
    onPointerup() {
        // Record brightness after slider adjustment is completed.
        this.inputDeviceSettingsProvider.recordKeyboardBrightnessChangeFromSlider(this.getKeyboardBrightnessFromSlider());
    }
    onKeyboardAutoBrightnessToggleChanged(e) {
        const toggle = e.target;
        this.inputDeviceSettingsProvider.setKeyboardAmbientLightSensorEnabled(toggle.checked);
    }
    onSettingsChanged() {
        if (!this.isInitialized) {
            return;
        }
        const newSettings = {
            ...this.keyboard.settings,
            topRowAreFkeys: this.topRowAreFunctionKeysPref.value,
            suppressMetaFkeyRewrites: this.blockMetaFunctionKeyRewritesPref.value,
        };
        if (settingsAreEqual(newSettings, this.keyboard.settings)) {
            return;
        }
        this.keyboard.settings = newSettings;
        this.inputDeviceSettingsProvider.setKeyboardSettings(this.keyboard.id, this.keyboard.settings);
    }
    onKeyboardBrightnessChanged(keyboardBrightnessPercent) {
        if (keyboardBrightnessPercent > 0 &&
            keyboardBrightnessPercent < MIN_VISIBLE_PERCENT) {
            // When auto-brightness is enabled, it's likely that the automated
            // brightness percentage will fall between 0% and 5%. To avoid confusion
            // where the user cannot distinguish between the keyboard being off (0%)
            // and low brightness levels, set the slider to a minimum visible
            // percentage (5%).
            this.set('keyboardBrightnessPercentPref.value', MIN_VISIBLE_PERCENT);
            return;
        }
        this.set('keyboardBrightnessPercentPref.value', keyboardBrightnessPercent);
    }
    onKeyboardAmbientLightSensorEnabledChanged(keyboardAmbientLightSensorEnabled) {
        this.set('keyboardAutoBrightnessPref.value', keyboardAmbientLightSensorEnabled);
    }
    onLidStateChanged(isLidOpen) {
        this.isLidOpen = isLidOpen;
    }
    getNumRemappedSixPackKeys() {
        if (!this.keyboard.settings.sixPackKeyRemappings) {
            return 0;
        }
        return Object.values(this.keyboard.settings.sixPackKeyRemappings)
            .filter((modifier) => modifier !== SixPackShortcutModifier$1.kSearch)
            .length;
    }
    async onKeyboardRemappingsChanged() {
        let numRemappedKeys = Object.keys(this.keyboard.settings.modifierRemappings).length;
        if (loadTimeData.getBoolean('enableAltClickAndSixPackCustomization')) {
            numRemappedKeys += this.getNumRemappedSixPackKeys();
        }
        this.remapKeyboardKeysSublabel =
            await PluralStringProxyImpl.getInstance().getPluralString('remapKeyboardKeysRowSubLabel', numRemappedKeys);
    }
    onRemapKeyboardKeysClick() {
        const url = new URLSearchParams('keyboardId=' + encodeURIComponent(this.keyboard.id));
        Router.getInstance().navigateTo(routes.PER_DEVICE_KEYBOARD_REMAP_KEYS, 
        /* dynamicParams= */ url, /* removeSearch= */ true);
    }
    getKeyboardName() {
        return this.keyboard.isExternal ? this.keyboard.name :
            this.i18n('builtInKeyboardName');
    }
    showKeyboardSettings() {
        return this.keyboard.isExternal ||
            (!this.keyboard.isExternal && this.isLidOpen);
    }
    isChromeOsKeyboard() {
        return this.keyboard.metaKey === MetaKey$2.kLauncher ||
            this.keyboard.metaKey === MetaKey$2.kSearch ||
            this.keyboard.metaKey === MetaKey$2.kLauncherRefresh;
    }
    openPersonalizationHub() {
        this.inputDeviceSettingsProvider.recordKeyboardColorLinkClicked();
        this.personalizationHubBrowserProxy.openPersonalizationHub();
    }
    getKeyboardBrightnessFromSlider() {
        const slider = this.shadowRoot.querySelector('#keyboardBrightnessSlider');
        return slider.pref.value;
    }
    getRemapKeyboardKeysClass() {
        return `hr bottom-divider ${this.keyboard.isExternal ? '' : 'remap-keyboard-keys-row-internal'}`;
    }
    showSendFunctionKeyDescription() {
        const hasFunctionKey = this.keyboard.modifierKeys.includes(ModifierKey$2.kFunction);
        if (hasFunctionKey) {
            return this.i18n('splitModifierKeyboardSendFunctionKeysDescription');
        }
        else {
            return this.i18n('keyboardSendFunctionKeysDescription');
        }
    }
    isCompanionAppInstalled() {
        return this.keyboard.appInfo?.state === CompanionAppState$1.kInstalled;
    }
}
customElements.define(SettingsPerDeviceKeyboardSubsectionElement.is, SettingsPerDeviceKeyboardSubsectionElement);

function getTemplate$2W() {
    return html `<!--_html_template_start_--><style include="settings-shared input-device-settings-shared"></style>
<template is="dom-if" if="[[!hasKeyboards(keyboards.length)]]">
  <div id="noKeyboardsConnectedContainer" class="settings-box start first">
    <h2 id="noKeyboardsConnectedMessage">
      $i18n{noKeyboardsConnected}
    </h2>
  </div>
</template>
<template is="dom-if" if="[[hasKeyboards(keyboards.length)]]">
  <template is="dom-repeat" items="[[keyboards]]"
      as="keyboard" index-as="index" restamp>
    <settings-per-device-keyboard-subsection
        keyboard="[[keyboard]]"
        keyboard-policies="[[keyboardPolicies]]"
        keyboard-index="[[index]]"
        is-last-device="[[computeIsLastDevice(index, keyboards.length)]]">
    </settings-per-device-keyboard-subsection>
  </template>
</template>

<h2 class="subsection-header">$i18n{keyboardHoldingKeys}</h2>
<div class="subsection">
    <settings-toggle-button
        class="hr continuation"
        pref="{{prefs.settings.language.physical_keyboard_enable_diacritics_on_longpress}}"
        label="$i18n{keyboardAccentMarks}"
        sub-label="$i18n{keyboardAccentMarksSubLabel}"
        deep-link-focus-id$="[[Setting.kShowDiacritic]]">
    </settings-toggle-button>
  <settings-toggle-button
      class="hr continuation"
      pref="{{prefs.settings.language.xkb_auto_repeat_enabled_r2}}"
      label="$i18n{keyboardEnableAutoRepeat}"
      sub-label="$i18n{keyboardEnableAutoRepeatSubLabel}"
      deep-link-focus-id$="[[Setting.kKeyboardAutoRepeat]]">
  </settings-toggle-button>
  <iron-collapse
      opened="[[prefs.settings.language.xkb_auto_repeat_enabled_r2.value]]">
    <div class="settings-box">
      <div class="start" id="repeatDelayLabel" aria-hidden="true">
        $i18n{keyRepeatDelay}
      </div>
      <settings-slider id="delaySlider"
          pref="{{prefs.settings.language.xkb_auto_repeat_delay_r2}}"
          ticks="[[autoRepeatDelays]]"
          disabled="[[
              !prefs.settings.language.xkb_auto_repeat_enabled_r2.value]]"
          label-aria="$i18n{keyRepeatDelay}"
          label-min="$i18n{keyRepeatDelayShort}"
          label-max="$i18n{keyRepeatDelayLong}">
      </settings-slider>
    </div>
    <div class="settings-box">
      <div class="start" id="repeatRateLabel" aria-hidden="true">
        $i18n{keyRepeatRate}
      </div>
      <settings-slider id="repeatRateSlider"
          pref="{{
              prefs.settings.language.xkb_auto_repeat_interval_r2}}"
          ticks="[[autoRepeatIntervals]]"
          disabled="[[
              !prefs.settings.language.xkb_auto_repeat_enabled_r2.value]]"
          label-aria="$i18n{keyRepeatRate}"
          label-min="$i18n{keyRepeatRateSlow}"
          label-max="$i18n{keyRepeatRateFast}">
      </settings-slider>
    </div>
  </iron-collapse>
</div>
<cr-link-row id="shortcutCustomizationApp" class="hr"
    on-click="onShowShortcutCustomizationAppClick"
    label="$i18n{showShortcutCustomizationApp}"
    external
    deep-link-focus-id$="[[Setting.kKeyboardShortcuts]]">
</cr-link-row>
<cr-link-row id="inputRow"
    class="hr" on-click="onShowInputSettingsClick"
    label="$i18n{keyboardShowInputSettings}"
    role-description="$i18n{subpageArrowRoleDescription}">
</cr-link-row>
<cr-link-row id="a11yKeyboardRow"
    class="hr" on-click="onShowA11yKeyboardSettingsClick"
    label="$i18n{keyboardShowA11yKeyboardSettings}"
    role-description="$i18n{subpageArrowRoleDescription}">
</cr-link-row>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'per-device-keyboard-settings' allow users to configure their keyboard
 * settings for each device in system settings.
 */
const SettingsPerDeviceKeyboardElementBase = DeepLinkingMixin(RouteObserverMixin(I18nMixin(PolymerElement)));
class SettingsPerDeviceKeyboardElement extends SettingsPerDeviceKeyboardElementBase {
    constructor() {
        super(...arguments);
        // DeepLinkingMixin override
        this.supportedSettingIds = new Set([
            Setting.kKeyboardAutoRepeat,
            Setting.kKeyboardShortcuts,
        ]);
        this.browserProxy = DevicePageBrowserProxyImpl.getInstance();
    }
    static get is() {
        return 'settings-per-device-keyboard';
    }
    static get template() {
        return getTemplate$2W();
    }
    static get properties() {
        return {
            /** Preferences state. Used for auto repeat settings. */
            prefs: {
                type: Object,
                notify: true,
            },
            keyboards: {
                type: Array,
                observer: 'onKeyboardListUpdated',
            },
            keyboardPolicies: {
                type: Object,
            },
            /**
             * Auto-repeat delays (in ms) for the corresponding slider values, from
             * long to short. The values were chosen to provide a large range while
             * giving several options near the defaults.
             */
            autoRepeatDelays: {
                type: Array,
                value() {
                    return [150, 200, 300, 500, 1000, 1500, 2000];
                },
                readOnly: true,
            },
            /**
             * Auto-repeat intervals (in ms) for the corresponding slider values, from
             * long to short. The slider itself is labeled "rate", the inverse of
             * interval, and goes from slow (long interval) to fast (short interval).
             */
            autoRepeatIntervals: {
                type: Array,
                value: [2000, 1000, 500, 300, 200, 100, 50, 30, 20],
                readOnly: true,
            },
        };
    }
    connectedCallback() {
        super.connectedCallback();
        this.browserProxy.initializeKeyboard();
    }
    currentRouteChanged(route) {
        // Does not apply to this page.
        if (route !== routes.PER_DEVICE_KEYBOARD) {
            return;
        }
        this.attemptDeepLink();
    }
    onKeyboardListUpdated(newKeyboardList, oldKeyboardList) {
        if (!oldKeyboardList) {
            return;
        }
        const { msgId, deviceNames } = getDeviceStateChangesToAnnounce(newKeyboardList, oldKeyboardList);
        for (const deviceName of deviceNames) {
            getInstance().announce(this.i18n(msgId, deviceName));
        }
    }
    onShowShortcutCustomizationAppClick() {
        this.browserProxy.showShortcutCustomizationApp();
    }
    onShowInputSettingsClick() {
        Router.getInstance().navigateTo(routes.OS_LANGUAGES_INPUT, 
        /*dynamicParams=*/ undefined, /*removeSearch=*/ true);
    }
    onShowA11yKeyboardSettingsClick() {
        Router.getInstance().navigateTo(routes.A11Y_KEYBOARD_AND_TEXT_INPUT, 
        /*dynamicParams=*/ undefined, /*removeSearch=*/ true);
    }
    hasKeyboards() {
        return this.keyboards.length > 0;
    }
    computeIsLastDevice(index) {
        return index === this.keyboards.length - 1;
    }
}
customElements.define(SettingsPerDeviceKeyboardElement.is, SettingsPerDeviceKeyboardElement);

function getTemplate$2V() {
    return html `<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">.settings-box{justify-content:space-between;padding-inline-start:0}</style>

<div class="settings-box" id="fkeyRow">
  <div>
    <div class="start key-container">
      <div id="keyLabel" aria-hidden="true">[[keyLabel]]</div>
    </div>
  </div>
  <settings-dropdown-menu id="keyDropdown"
      label="[[keyLabel]]"
      pref="{{pref}}"
      menu-options="[[shortcutOptions]]">
  </settings-dropdown-menu>
</div><!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'fkey-row' displays an fKey alongside a dropdown menu that allows users to
 * set a shortcut for remapping key events to F11/F12.
 */
function getTopRowActionKeyString(topRowActionKey) {
    switch (topRowActionKey) {
        case TopRowActionKey$1.kBack:
            return loadTimeData.getString('backKeyLabel');
        case TopRowActionKey$1.kForward:
            return loadTimeData.getString('forwardKeyLabel');
        case TopRowActionKey$1.kRefresh:
            return loadTimeData.getString('refreshKeyLabel');
        case TopRowActionKey$1.kFullscreen:
            return loadTimeData.getString('fullscreenKeyLabel');
        case TopRowActionKey$1.kOverview:
            return loadTimeData.getString('overviewKeyLabel');
        case TopRowActionKey$1.kScreenshot:
            return loadTimeData.getString('screenshotKeyLabel');
        case TopRowActionKey$1.kScreenBrightnessDown:
            return loadTimeData.getString('screenBrightnessDownKeyLabel');
        case TopRowActionKey$1.kScreenBrightnessUp:
            return loadTimeData.getString('screenBrightnessUpKeyLabel');
        case TopRowActionKey$1.kMicrophoneMute:
            return loadTimeData.getString('microphoneMuteKeyLabel');
        case TopRowActionKey$1.kVolumeMute:
            return loadTimeData.getString('muteKeyLabel');
        case TopRowActionKey$1.kVolumeDown:
            return loadTimeData.getString('volumeDownKeyLabel');
        case TopRowActionKey$1.kVolumeUp:
            return loadTimeData.getString('volumeUpKeyLabel');
        case TopRowActionKey$1.kKeyboardBacklightToggle:
            return loadTimeData.getString('backlightToggleKeyLabel');
        case TopRowActionKey$1.kKeyboardBacklightDown:
            return loadTimeData.getString('backlightDownKeyLabel');
        case TopRowActionKey$1.kKeyboardBacklightUp:
            return loadTimeData.getString('backlightUpKeyLabel');
        case TopRowActionKey$1.kNextTrack:
            return loadTimeData.getString('trackNextKeyLabel');
        case TopRowActionKey$1.kPreviousTrack:
            return loadTimeData.getString('trackPreviousKeyLabel');
        case TopRowActionKey$1.kPlayPause:
            return loadTimeData.getString('playPauseKeyLabel');
        case TopRowActionKey$1.kAllApplications:
            return loadTimeData.getString('allApplicationsKeyLabel');
        case TopRowActionKey$1.kEmojiPicker:
            return loadTimeData.getString('emojiPickerKeyLabel');
        case TopRowActionKey$1.kDictation:
            return loadTimeData.getString('dicationKeyLabel');
        case TopRowActionKey$1.kPrivacyScreenToggle:
            return loadTimeData.getString('privacyScreenToggleKeyLabel');
        case TopRowActionKey$1.kNone:
        case TopRowActionKey$1.kUnknown:
            return '';
        default:
            assertNotReached();
    }
}
const fKeyLabels = {
    [Fkey.F11]: loadTimeData.getString('f11KeyLabel'),
    [Fkey.F12]: loadTimeData.getString('f12KeyLabel'),
};
const FkeyRowElementBase = RouteObserverMixin(I18nMixin(PolymerElement));
class FkeyRowElement extends FkeyRowElementBase {
    static get is() {
        return 'fkey-row';
    }
    static get template() {
        return getTemplate$2V();
    }
    static get properties() {
        return {
            key: { type: String },
            keyLabel: {
                type: String,
                computed: 'computeKeyLabel(key)',
            },
            pref: {
                type: Object,
            },
            keyboard: {
                type: Object,
            },
            shortcutOptions: {
                type: Array,
            },
        };
    }
    currentRouteChanged(route) {
        // Does not apply to this page.
        if (route !== routes.PER_DEVICE_KEYBOARD_REMAP_KEYS) {
            return;
        }
        this.shortcutOptions = this.getMenuOptions();
    }
    getTopRowKeyLabel() {
        // F11 shortcuts include the key in the F1 position which corresponds
        // to the 1st entry in our `topRowActionKeys` array.
        const fkeyIndex = this.key === Fkey.F11 ? 0 : 1;
        assert(this.keyboard.topRowActionKeys);
        return getTopRowActionKeyString(this.keyboard.topRowActionKeys[fkeyIndex]);
    }
    computeKeyLabel() {
        assert(this.key in fKeyLabels);
        return fKeyLabels[this.key];
    }
    getFkeyShortcutOptions() {
        const topRowKeyLabel = this.getTopRowKeyLabel();
        const messageIdSuffix = this.keyboard.settings.topRowAreFkeys ? '' : 'Search';
        return [
            {
                value: ExtendedFkeysModifier$1.kShift,
                name: this.i18n(`fKeyShiftOption${messageIdSuffix}`, topRowKeyLabel),
            },
            {
                value: ExtendedFkeysModifier$1.kCtrlShift,
                name: this.i18n(`fKeyCtrlShiftOption${messageIdSuffix}`, topRowKeyLabel),
            },
            {
                value: ExtendedFkeysModifier$1.kAlt,
                name: this.i18n(`fKeyAltOption${messageIdSuffix}`, topRowKeyLabel),
            },
        ];
    }
    getMenuOptions() {
        return [
            {
                value: ExtendedFkeysModifier$1.kDisabled,
                name: this.i18n('perDeviceKeyboardKeyDisabled'),
            },
            ...this.getFkeyShortcutOptions(),
        ];
    }
}
customElements.define(FkeyRowElement.is, FkeyRowElement);

const template$3 = html`<!-- TODO(dpad): Collapse with keyboard and shortcut customization app icons -->
<iron-iconset-svg name="shortcut-input-keys" size="24">
  <svg>
    <defs>
      <g id="accessibility" viewBox="0 0 20 20">
        <path
          d="M10 5.458a1.8 1.8 0 0 1-1.292-.52 1.787 1.787 0 0 1-.541-1.313c0-.5.18-.924.541-1.27A1.763 1.763 0 0 1 10 1.812c.5 0 .93.18 1.292.541.36.347.541.778.541 1.292 0 .5-.18.93-.541 1.292a1.8 1.8 0 0 1-1.292.52ZM7.417 17.812V8.376H3V6.708h14v1.667h-4.417v9.438h-1.646l-.187-4.646H9.27l-.207 4.646H7.417Z">
        </path>
      </g>
      <g id="arrow-down">
        <path d="M7.41 7.84L12 12.42l4.59-4.58L18 9.25l-6 6-6-6z">
      </g>
      <g id="arrow-left">
        <path d="M15.41 16.09l-4.58-4.59 4.58-4.59L14 5.5l-6 6 6 6z">
      </g>
      <g id="arrow-right">
        <path d="M8.59 16.34l4.58-4.59-4.58-4.59L10 5.75l6 6-6 6z">
      </g>
      <g id="arrow-up">
        <path d="M7.41 15.41L12 10.83l4.59 4.58L18 14l-6-6-6 6z">
      </g>
      <g id="assistant" viewBox="0 0 20 20">
        <path
          d="M6.36364 3C8.77382 3 10.7273 4.95418 10.7273 7.36364C10.7273 9.77309 8.77382 11.7273 6.36364 11.7273C3.95345 11.7273 2 9.77309 2 7.36364C2 4.95418 3.95345 3 6.36364 3Z">
        </path>
        <path
          d="M18 6.99997C18 7.60215 17.5113 8.09088 16.9091 8.09088C16.3069 8.09088 15.8182 7.60215 15.8182 6.99997C15.8182 6.39778 16.3069 5.90906 16.9091 5.90906C17.5113 5.90906 18 6.39778 18 6.99997Z">
        </path>
        <path
          d="M15.8182 9.54547C15.8182 10.7506 14.8414 11.7273 13.6363 11.7273C12.4313 11.7273 11.4545 10.7506 11.4545 9.54547C11.4545 8.34037 12.4313 7.36365 13.6363 7.36365C14.8414 7.36365 15.8182 8.34037 15.8182 9.54547Z">
        </path>
        <path
          d="M13.6363 17.5455C15.0422 17.5455 16.1818 16.4059 16.1818 15C16.1818 13.5942 15.0422 12.4546 13.6363 12.4546C12.2305 12.4546 11.0909 13.5942 11.0909 15C11.0909 16.4059 12.2305 17.5455 13.6363 17.5455Z">
        </path>
      </g>
      <g id="back">
        <path d="M20 11H7.83l5.59-5.59L12 4l-8 8 8 8 1.41-1.41L7.83 13H20v-2z">
      </g>
      <g id="brightness-up-refresh" viewBox="0 0 20 20">
        <g clip-path="url(#a)">
          <path d="m10 18.688 2.52-2.521h3.647V12.52l2.52-2.52-2.52-2.52V3.832H12.52L10 1.313l-2.52 2.52H3.832V7.48L1.313 10l2.52 2.52v3.647H7.48l2.52 2.52Zm0-4.75c-1.097 0-2.028-.382-2.792-1.146-.764-.778-1.146-1.709-1.146-2.792 0-1.097.39-2.028 1.167-2.792.764-.764 1.688-1.146 2.771-1.146 1.097 0 2.028.39 2.792 1.167.764.764 1.146 1.688 1.146 2.771 0 1.097-.382 2.028-1.146 2.792-.778.764-1.709 1.146-2.792 1.146Zm0 2.312-1.813-1.813H5.563v-2.624L3.75 10l1.813-1.813V5.563h2.625L10 3.75l1.813 1.813h2.624v2.625L16.25 10l-1.813 1.813v2.624h-2.624L10 16.25Z"></path>
        </g>
        <defs>
          <clipPath id="a">
            <path d="M20 0H0v20h20z"></path>
          </clipPath>
        </defs>
      </g>
      <g id="camera-access-toggle" viewBox="0 0 20 20">
        <path d="M18 13.9792L15 10.9792V12.8542L13.5 11.3542V5.5H7.625L6.125 4H13.5C13.9167 4 14.2708 4.14583 14.5625 4.4375C14.8542 4.72917 15 5.08333 15 5.5V8.97917L18 5.97917V13.9792ZM16.7292 18.8125L1.16667 3.27083L2.22917 2.20833L17.7917 17.75L16.7292 18.8125ZM4.04167 4.04167L5.5 5.47917H4.5V14.5H13.5V13.4583L15 14.9583C14.8889 15.2361 14.7153 15.4792 14.4792 15.6875C14.2431 15.8958 13.9167 16 13.5 16H4.5C4.09722 16 3.74306 15.8542 3.4375 15.5625C3.14583 15.2708 3 14.9167 3 14.5V5.47917C3 5.11805 3.09722 4.8125 3.29167 4.5625C3.5 4.3125 3.75 4.13889 4.04167 4.04167Z"></path>
      </g>
      <g id="do-not-disturb" viewbox="0 0 20 20">
        <path d="M6 10.875h8v-1.75H6v1.75Zm4 7.292a8.205 8.205 0 0 1-3.188-.625 8.59 8.59 0 0 1-2.604-1.75 8.589 8.589 0 0 1-1.75-2.604A8.204 8.204 0 0 1 1.833 10c0-1.139.209-2.201.625-3.188a8.327 8.327 0 0 1 1.75-2.583 8.112 8.112 0 0 1 2.604-1.75c1-.43 2.063-.646 3.188-.646 1.139 0 2.201.216 3.188.646a7.88 7.88 0 0 1 2.583 1.75 7.82 7.82 0 0 1 1.75 2.604c.43.986.646 2.042.646 3.167a7.974 7.974 0 0 1-.646 3.188c-.417.986-1 1.854-1.75 2.604a8.262 8.262 0 0 1-2.604 1.75 8.053 8.053 0 0 1-3.167.625Zm0-1.73c1.792 0 3.313-.625 4.563-1.875 1.25-1.25 1.874-2.77 1.874-4.562 0-1.792-.625-3.313-1.875-4.563-1.25-1.25-2.77-1.875-4.562-1.875-1.792 0-3.313.626-4.563 1.876-1.25 1.25-1.875 2.77-1.875 4.562 0 1.792.626 3.313 1.876 4.563 1.25 1.25 2.77 1.874 4.562 1.874Z"></path>
      </g>
      <g id="display-brightness-down" viewbox="0 0 20 20">
        <path fill-rule="evenodd"
          d="M9.99982 4.13281L11.7889 5.87499H14.1285V8.15322L15.7799 9.76139L14.1285 11.5036V13.7818H11.7889L9.99982 15.39L8.34836 13.7818H6.00878V11.5036L4.21973 9.76139L6.00878 8.15322V5.87499H8.34836L9.99982 4.13281ZM9.99982 6.41105L8.89883 7.48315H7.66025V8.68928L6.5593 9.76139L7.66025 10.9675V12.0396H8.89883L9.99982 13.2457L11.2384 12.0396H12.3394V10.9675L13.5779 9.76139L12.3394 8.68928V7.48315H11.2384L9.99982 6.41105Z">
      </g>
      <g id="display-brightness-up" viewbox="0 0 20 20">
        <path fill-rule="evenodd"
          d="M10.0686 2.64844L12.2706 4.92667H15.2982V7.87497L17.5002 10.0192L15.2982 12.1634V15.2457H12.2706L10.0686 17.3899L7.72908 15.2457H4.70145V12.1634L2.49951 10.0192L4.70145 7.87497V4.92667H7.72908L10.0686 2.64844ZM10.0686 4.92667L8.2796 6.53484H6.4905V8.27701L4.70145 10.0192L6.4905 11.7614V13.5035H8.2796L10.0686 15.2457L11.7201 13.5035H13.5092V11.7614L15.2982 10.0192L13.5092 8.27701V6.53484H11.7201L10.0686 4.92667Z">
      </g>
      <g id="electronic-privacy-screen" viewbox="0 0 20 20">
        <path fill-rule="evenodd"
          d="M18 3V17H2V3H18ZM16 15H5.07314L15.0731 5H16V15ZM4 10.8284V13.2447L12.2447 5H9.82838L4 10.8284ZM6.99995 5L4 7.99995V5H6.99995Z">
      </g>
      <g id="forward">
        <path d="M12 4l-1.41 1.41L16.17 11H4v2h12.17l-5.58 5.59L12 20l8-8z">
      </g>
      <g id="fullscreen">
        <path d="M7 14H5v5h5v-2H7v-3zm-2-4h2V7h3V5H5v5zm12 7h-3v2h5v-5h-2v3zM14 5v2h3v3h2V5h-5z">
      </g>
      <g id="last-track" viewbox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M16 15L8 10L16 5V15Z"></path>
        <path d="M4 5H6V15H4V5Z"></path>
      </g>
      <g id="keyboard-brightness-down" viewbox="0 0 20 20">
        <path fill-rule="evenodd"
          d="M6.95442 14H13.0455C13.2262 14 13.3915 14.107 13.4723 14.2764L13.9495 15.2764C14.0674 15.5234 13.9718 15.8237 13.7361 15.9472C13.6698 15.9819 13.5968 16 13.5227 16H6.47721C6.21365 16 6 15.7761 6 15.5C6 15.4224 6.01725 15.3458 6.05038 15.2764L6.52759 14.2764C6.60842 14.107 6.77366 14 6.95442 14ZM6 8.37845L4.7111 9.55653L3.08636 8.06095L4.36619 6.88287L6 8.37845ZM3.45455 12V14H1V12H3.45455ZM11 5V7.22176H9V5H11ZM16.9136 8.06463L15.2838 9.56488L14 8.38312L15.6298 6.88287L16.9136 8.06463ZM16.5454 12H19V14H16.5454V12Z">
      </g>
      <g id="keyboard-brightness-toggle" viewbox="0 0 20 20">
        <path d="M 9.15049 2 L 10.8508 2 L 10.8508 7.03443 L 9.15049 7.03443 Z"></path>
        <path d="M 5.74972 12.0689 L 0.649957 12.0689 L 0.649957 10.3903 L 5.74972 10.3903 Z"></path>
        <path d="M 19.3501 12.0689 L 14.2503 12.0689 L 14.2503 10.3903 L 19.3501 10.3903 Z"></path>
        <path d="M 16.1818 3.7734 L 17.3838 4.95997 L 14.0176 8.28251 L 12.8156 7.09593 Z"></path>
        <path
          d="M 13.2192 15.6192 L 14.2571 16.6571 L 15.1208 17.5207 L 15.5999 18 L 16.7468 16.8545 L 11.9673 12.0698 L 12.5323 12.0698 L 12.5323 10.3913 L 10.2887 10.3899 L 3.28479 3.38476 L 2.138 4.52385 L 2.13032 4.53029 Z">
        </path>
      </g>
      <g id="keyboard-brightness-up" viewbox="0 0 20 20">
        <path fill-rule="evenodd"
          d="M6.95442 14H13.0455C13.2262 14 13.3915 14.107 13.4723 14.2764L13.9495 15.2764C14.0674 15.5234 13.9718 15.8237 13.7361 15.9472C13.6698 15.9819 13.5968 16 13.5227 16H6.47721C6.21365 16 6 15.7761 6 15.5C6 15.4224 6.01725 15.3458 6.05038 15.2764L6.52759 14.2764C6.60842 14.107 6.77366 14 6.95442 14ZM6 8.37845L4.7111 9.55653L1.08636 6.06095L2.36619 4.88287L6 8.37845ZM3.45455 12V14H0V12H3.45455ZM11 2V7.22176H9V2H11ZM18.9136 6.06463L15.2838 9.56488L14 8.38312L17.6298 4.88287L18.9136 6.06463ZM16.5454 12H20V14H16.5454V12Z">
      </g>
      <g id="launcher" viewbox="0 0 20 20">
        <path
          d="M10 15C12.7614 15 15 12.7614 15 10C15 7.23858 12.7614 5 10 5C7.23858 5 5 7.23858 5 10C5 12.7614 7.23858 15 10 15Z">
        </path>
        <path fill-rule="evenodd"
          d="M10 18.5C14.6944 18.5 18.5 14.6944 18.5 10C18.5 5.30558 14.6944 1.5 10 1.5C5.30558 1.5 1.5 5.30558 1.5 10C1.5 14.6944 5.30558 18.5 10 18.5ZM17 10C17 13.866 13.866 17 10 17C6.13401 17 3 13.866 3 10C3 6.13401 6.13401 3 10 3C13.866 3 17 6.13401 17 10Z">
        </path>
      </g>
      <g id="launcher-refresh" viewBox="0 0 20 20">
        <g clip-path="url(#a)">
          <path
            d="M10 16.517c-.9 0-1.75-.167-2.55-.5a6.662 6.662 0 0 1-2.067-1.4 6.662 6.662 0 0 1-1.4-2.067 6.57 6.57 0 0 1-.5-2.55c0-.9.167-1.744.5-2.533a6.662 6.662 0 0 1 1.4-2.067A6.3 6.3 0 0 1 7.45 4 6.38 6.38 0 0 1 10 3.483c.822 0 1.6.15 2.333.45.745.29 1.423.7 2.034 1.234l-1.85 1.8a3.886 3.886 0 0 0-1.167-.7A3.443 3.443 0 0 0 10 6c-1.089 0-2.017.394-2.783 1.183A3.932 3.932 0 0 0 6.083 10c0 1.1.378 2.039 1.134 2.817.766.777 1.694 1.166 2.783 1.166.922 0 1.711-.255 2.367-.766a3.11 3.11 0 0 0 1.216-1.984H10V8.817h6.117c.055.233.094.46.116.683.023.211.034.428.034.65 0 1.922-.578 3.467-1.734 4.633-1.144 1.156-2.655 1.734-4.533 1.734Z"></path>
        </g>
        <defs>
          <clipPath id="a">
            <path d="M0 0h20v20H0z"></path>
          </clipPath>
        </defs>
      </g>
      <g id="microphone-mute" viewbox="0 0 20 20">
        <path
          d="M 15.4894 8.94314 L 13.9775 8.94314 C 13.9775 9.69794 13.8293 10.3021 13.5269 10.9057 L 14.5823 11.9623 C 15.187 11.2075 15.4894 10.1509 15.4894 8.94314 Z M 2.96096 2.6036 L 1.90551 3.66019 L 10.9595 12.7171 C 10.6572 12.7171 10.3548 12.8682 10.2065 12.8682 C 8.08988 12.8682 6.28133 11.0569 6.28133 8.94314 L 4.76949 8.94314 C 4.76949 11.6605 6.73206 13.9249 9.4477 14.3773 L 9.4477 16.7928 L 10.9595 16.7928 L 10.9595 14.3773 C 11.4102 14.3773 11.8666 14.2266 12.169 14.0754 L 16.0942 18 L 17.1496 16.9434 Z M 12.4714 8.94314 L 12.4714 4.26379 C 12.4714 2.9054 11.4102 2 10.2065 2 C 8.84865 2 7.94154 3.05659 7.94154 4.26379 L 7.94154 5.16975 L 12.4714 9.69794 C 12.3173 9.5473 12.4714 9.24551 12.4714 8.94314 Z">
        </path>
      </g>
      <g id="next-track" viewbox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M4 15L12 10L4 5V15Z"></path>
        <path d="M16 5H14V15H16V5Z"></path>
      </g>
      <g id="overview" width="20" height="20" viewbox="0 0 20 20">
        <path fill-rule="evenodd"
          d="M0.164062 15.3381H13.1281V4.65625H0.164062V15.3381ZM1.80029 6.28995H11.4919V13.7044H1.80029V6.28995ZM14.803 15.3381H16.4806V4.65625H14.803V15.3381ZM18.1583 4.65625H19.8359V15.3255H18.1583V4.65625Z">
      </g>
      <g id="overview-refresh" viewBox="0 0 20 20">
        <path d="M19.167 9V2.833H9V9h10.167Zm0 8.167V11H13v6.167h6.167ZM7 9V2.833H.834V9H7Zm4 8.167V11H.834v6.167H11Zm6.438-9.896H10.73V4.563h6.708V7.27Zm-12.167 0H2.563V4.563H5.27V7.27Zm4 8.167H2.563v-2.709H9.27v2.709Zm8.167 0H14.73v-2.709h2.708v2.709Z"></path>
      </g>
      <g id="play-pause" viewbox="0 0 20 20">
        <path fill-rule="evenodd" d="M3.53027 13.9683L10.1413 10.0017L3.53027 6.03516V13.9683Z"></path>
        <rect x="11.521" y="5.67969" width="2" height="8.28929"></rect>
        <rect x="14.5444" y="5.67969" width="2" height="8.28929"></rect>
      </g>
      <g id="power">
        <path
          d="M13 3h-2v10h2V3zm4.83 2.17l-1.42 1.42C17.99 7.86 19 9.81 19 12c0 3.87-3.13 7-7 7s-7-3.13-7-7c0-2.19 1.01-4.14 2.58-5.42L6.17 5.17C4.23 6.82 3 9.26 3 12c0 4.97 4.03 9 9 9s9-4.03 9-9c0-2.74-1.23-5.18-3.17-6.83z">
      </g>
      <g id="refresh">
        <path
          d="M17.65 6.35C16.2 4.9 14.21 4 12 4c-4.42 0-7.99 3.58-7.99 8s3.57 8 7.99 8c3.73 0 6.84-2.55 7.73-6h-2.08c-.82 2.33-3.04 4-5.65 4-3.31 0-6-2.69-6-6s2.69-6 6-6c1.66 0 3.14.69 4.22 1.78L13 11h7V4l-2.35 2.35z">
      </g>
      <g id="quick-insert" viewBox="0 0 20 20">
        <g clip-path="url(#a)">
          <path
            d="M9.167 13.042h1.666v-2.209h2.209V9.167h-2.209V6.958H9.167v2.209H6.958v1.666h2.209v2.209ZM10 18.167a1.68 1.68 0 0 1-.667-.125 1.992 1.992 0 0 1-.562-.375l-6.438-6.438a1.815 1.815 0 0 1-.396-.562A1.977 1.977 0 0 1 1.833 10c0-.25.035-.472.105-.667.083-.194.215-.375.395-.541l6.438-6.459c.18-.18.368-.305.562-.375.195-.083.417-.125.667-.125.25 0 .472.042.667.125.194.07.375.195.541.375l6.459 6.438c.18.18.305.368.375.562.083.195.125.417.125.667 0 .25-.042.472-.125.667-.07.194-.195.382-.375.562l-6.459 6.438a1.732 1.732 0 0 1-.541.375 1.68 1.68 0 0 1-.667.125Zm0-1.73L16.438 10 10 3.562 3.562 10 10 16.438Z"></path>
        </g>
        <defs>
          <clipPath id="a">
            <path d="M0 0h20v20H0z"></path>
          </clipPath>
        </defs>
      </g>
      <g id="screen-mirror" viewbox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M17.1327 12.0716H15.0166V10.5716H16.6327V5.28516H9.57471V5.97091H8.07471V4.78516C8.07471 4.23287 8.52242 3.78516 9.07471 3.78516H17.1327C17.685 3.78516 18.1327 4.23287 18.1327 4.78516V11.0716C18.1327 11.6239 17.685 12.0716 17.1327 12.0716ZM14.228 15.0129H13.5443V7.49229C13.5443 7.30349 13.4678 7.13257 13.344 7.00884C13.2203 6.88512 13.0494 6.80859 12.8606 6.80859H3.28888C2.91128 6.80859 2.60518 7.11469 2.60518 7.49229V15.0129H1.92149C1.54389 15.0129 1.23779 15.319 1.23779 15.6966C1.23779 16.0742 1.54389 16.3803 1.92149 16.3803H14.228C14.6056 16.3803 14.9117 16.0742 14.9117 15.6966C14.9117 15.319 14.6056 15.0129 14.228 15.0129ZM12.1769 8.17598V12.9618H3.97257V8.17598H12.1769ZM6.70735 15.0129V14.3292H9.44213V15.0129H6.70735Z">
        </path>
      </g>
      <g id="screenshot" viewBox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M7.96487 7.55109C8.52146 7.18893 9.17585 6.99562 9.84526 6.99562C10.7429 6.99562 11.6038 7.34288 12.2385 7.96098C12.8732 8.57908 13.2299 9.41741 13.2299 10.2915C13.2299 10.9434 13.0314 11.5806 12.6595 12.1226C12.2876 12.6646 11.759 13.0871 11.1405 13.3366C10.5221 13.586 9.8415 13.6513 9.18495 13.5241C8.52841 13.3969 7.92534 13.083 7.45199 12.6221C6.97865 12.1612 6.65632 11.5739 6.52572 10.9345C6.39513 10.2952 6.46214 9.6325 6.71831 9.03025C6.97448 8.428 7.40828 7.91325 7.96487 7.55109ZM11.1507 9.02033C10.8045 8.68318 10.3349 8.49376 9.84526 8.49376C9.35563 8.49376 8.88608 8.68318 8.53986 9.02033C8.19365 9.35747 7.99915 9.81474 7.99915 10.2915C7.99915 10.7683 8.19365 11.2256 8.53986 11.5627C8.88608 11.8999 9.35563 12.0893 9.84526 12.0893C10.3349 12.0893 10.8045 11.8999 11.1507 11.5627C11.4969 11.2256 11.6914 10.7683 11.6914 10.2915C11.6914 9.81474 11.4969 9.35747 11.1507 9.02033Z">
        </path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M2 4H18V16.7342H2V4ZM16 14.7866V5.94758H4.00002V14.7866H16Z">
        </path>
      </g>
      <g id="volume-down">
        <path d="M18.5 12c0-1.77-1.02-3.29-2.5-4.03v8.05c1.48-.73 2.5-2.25 2.5-4.02zM5 9v6h4l5 5V4L9 9H5z">
      </g>
      <g id="volume-mute">
        <path
          d="M16.5 12c0-1.77-1.02-3.29-2.5-4.03v2.21l2.45 2.45c.03-.2.05-.41.05-.63zm2.5 0c0 .94-.2 1.82-.54 2.64l1.51 1.51C20.63 14.91 21 13.5 21 12c0-4.28-2.99-7.86-7-8.77v2.06c2.89.86 5 3.54 5 6.71zM4.27 3L3 4.27 7.73 9H3v6h4l5 5v-6.73l4.25 4.25c-.67.52-1.42.93-2.25 1.18v2.06c1.38-.31 2.63-.95 3.69-1.81L19.73 21 21 19.73l-9-9L4.27 3zM12 4L9.91 6.09 12 8.18V4z">
      </g>
      <g id="volume-up">
        <path
          d="M3 9v6h4l5 5V4L7 9H3zm13.5 3c0-1.77-1.02-3.29-2.5-4.03v8.05c1.48-.73 2.5-2.25 2.5-4.02zM14 3.23v2.06c2.89.86 5 3.54 5 6.71s-2.11 5.85-5 6.71v2.06c4.01-.91 7-4.49 7-8.77s-2.99-7.86-7-8.77z">
      </g>
      <g id="plus" viewbox="0 0 16 16">
        <path d="M9 4H7V7H4V9H7V12H9V9H12V7H9V4Z"></path>
      </g>
      <g id="emoji-picker" viewBox="0 0 20 20">
        <path fill-rule="evenodd"
          d="M9.992 2C5.576 2 2 5.584 2 10C2 14.416 5.576 18 9.992 18C14.416 18 18 14.416 18 10C18 5.584 14.416 2 9.992 2ZM10 16.5C6.40875 16.5 3.5 13.5912 3.5 10C3.5 6.40875 6.40875 3.5 10 3.5C13.5912 3.5 16.5 6.40875 16.5 10C16.5 13.5912 13.5912 16.5 10 16.5ZM12.8 9.20005C13.464 9.20005 14 8.66405 14 8.00005C14 7.33605 13.464 6.80005 12.8 6.80005C12.136 6.80005 11.6 7.33605 11.6 8.00005C11.6 8.66405 12.136 9.20005 12.8 9.20005ZM7.2 9.20005C7.864 9.20005 8.4 8.66405 8.4 8.00005C8.4 7.33605 7.864 6.80005 7.2 6.80005C6.536 6.80005 6 7.33605 6 8.00005C6 8.66405 6.536 9.20005 7.2 9.20005ZM9.99999 14C11.864 14 13.448 12.7486 14.088 11H5.91199C6.55199 12.7486 8.13599 14 9.99999 14Z">
        </path>
      </g>
      <g id="dictation-toggle" viewBox="0 0 20 20">
        <path
          d="M5.75 8.02c.403 0 .757-.152 1.063-.457.305-.306.458-.66.458-1.063v-3c0-.417-.153-.77-.458-1.063-.306-.305-.66-.458-1.063-.458-.417 0-.77.153-1.063.458A1.414 1.414 0 0 0 4.23 3.5v3c0 .403.153.757.458 1.063.292.305.646.458 1.063.458Zm9.667 10.21c.514 0 .944-.181 1.291-.543.348-.36.521-.791.521-1.291V3.5c0-.472-.166-.875-.5-1.208A1.681 1.681 0 0 0 15.5 1.77H9V3.5h6.5v13H6.625v-1.438h-1.75v1.334c0 .5.18.93.542 1.291.347.362.77.542 1.27.542h8.73ZM14 15.061V13.5H8.396v1.563H14Zm0-2.562V11h-4v1.5h4Zm-9.125 1.125h1.75v-2.688a3.994 3.994 0 0 0 2.333-1.395A3.864 3.864 0 0 0 9.875 7H8.229c0 .68-.243 1.257-.729 1.73a2.461 2.461 0 0 1-1.75.687c-.694 0-1.278-.23-1.75-.688A2.319 2.319 0 0 1 3.27 7H1.626c0 .958.306 1.806.917 2.542.597.736 1.375 1.201 2.333 1.396v2.687Z">
        </path>
      </g>
      <g id="settings-icon" viewBox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M11.6629 19H8.33386C7.66807 19 7.11024 18.5256 7.02926 17.8843L6.78633 16.224C6.54341 16.101 6.30948 15.9693 6.07555 15.8199L4.45604 16.4524C3.82623 16.6808 3.13344 16.4261 2.82754 15.8814L1.18103 13.0966C0.86613 12.5168 1.00109 11.8316 1.50494 11.4451L2.88152 10.3997C2.87252 10.2679 2.86352 10.1362 2.86352 9.99561C2.86352 9.86384 2.87252 9.72328 2.88152 9.59151L1.51393 8.54612C0.983095 8.15081 0.848136 7.43924 1.18103 6.89458L2.84553 4.09224C3.15144 3.54758 3.84423 3.30161 4.45604 3.5388L6.08455 4.18009C6.31848 4.03075 6.5524 3.89897 6.78633 3.77599L7.02926 2.0981C7.11024 1.48316 7.66807 1 8.32487 1H11.6539C12.3197 1 12.8775 1.47438 12.9585 2.11567L13.2014 3.77599C13.4443 3.89897 13.6782 4.03075 13.9122 4.18009L15.5317 3.54758C16.1705 3.31918 16.8633 3.57394 17.1692 4.11859L18.8247 6.91215C19.1486 7.49195 19.0046 8.17716 18.5008 8.56369L17.1332 9.60908C17.1422 9.74085 17.1512 9.87262 17.1512 10.0132C17.1512 10.1537 17.1422 10.2855 17.1332 10.4173L18.5008 11.4627C19.0046 11.858 19.1486 12.5432 18.8337 13.0966L17.1602 15.9253C16.8543 16.47 16.1615 16.716 15.5407 16.4788L13.9212 15.8463C13.6872 15.9956 13.4533 16.1274 13.2194 16.2504L12.9765 17.9283C12.8865 18.5256 12.3287 19 11.6629 19ZM8.81541 16.75H11.1932L11.512 14.6636L11.9686 14.4836C12.3476 14.3364 12.7267 14.1236 13.123 13.8455L13.5107 13.5673L15.5611 14.3527L16.75 12.3891L15.0011 11.0964L15.0614 10.6382C15.0873 10.4255 15.1131 10.2209 15.1131 10C15.1131 9.77909 15.0873 9.56636 15.0614 9.36182L15.0011 8.90364L16.75 7.61091L15.5525 5.64727L13.4935 6.43273L13.1058 6.14636C12.7439 5.88455 12.3563 5.67182 11.96 5.51636L11.512 5.33636L11.1932 3.25H8.81541L8.49665 5.33636L8.04004 5.50818C7.66098 5.66364 7.28191 5.86818 6.88561 6.15455L6.49793 6.42455L4.44751 5.64727L3.25 7.60273L4.99888 8.89545L4.93858 9.35364C4.91273 9.56636 4.88689 9.78727 4.88689 10C4.88689 10.2127 4.90412 10.4336 4.93858 10.6382L4.99888 11.0964L3.25 12.3891L4.4389 14.3527L6.49793 13.5673L6.88561 13.8536C7.25606 14.1236 7.62652 14.3282 8.03143 14.4836L8.48803 14.6636L8.81541 16.75ZM10 12.8125C11.5533 12.8125 12.8125 11.5533 12.8125 10C12.8125 8.4467 11.5533 7.1875 10 7.1875C8.4467 7.1875 7.1875 8.4467 7.1875 10C7.1875 11.5533 8.4467 12.8125 10 12.8125Z">
        </path>
      </g>
      <g id="search" viewBox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M17.49 16L13.76 12.27C14.53 11.2 15 9.91 15 8.5C15 4.91 12.09 2 8.5 2C4.91 2 2 4.91 2 8.5C2 12.09 4.91 15 8.5 15C9.91 15 11.2 14.53 12.27 13.76L16 17.49L17.49 16ZM4 8.5C4 6.01 6.01 4 8.5 4C10.99 4 13 6.01 13 8.5C13 10.99 10.99 13 8.5 13C6.01 13 4 10.99 4 8.5Z">
        </path>
      </g>
      <g id="browser-search" viewBox="0 0 20 20">
        <path
          d="M9.82803 18.9771C8.6051 18.9465 7.4586 18.6943 6.38853 18.2204C5.31847 17.7465 4.37834 17.1045 3.56815 16.2943C2.77325 15.4688 2.1465 14.521 1.6879 13.451C1.2293 12.3656 1 11.2115 1 9.98853C1 8.73503 1.2293 7.5656 1.6879 6.48025C2.16178 5.3949 2.81146 4.44713 3.63694 3.63694C4.46242 2.81146 5.41783 2.16943 6.50318 1.71083C7.58853 1.23694 8.75032 1 9.98853 1C12.2204 1 14.1465 1.69554 15.7669 3.08662C17.4025 4.47771 18.4191 6.22802 18.8166 8.33758H16.8675C16.6229 7.23694 16.1338 6.2586 15.4 5.40255C14.6662 4.5465 13.772 3.90446 12.7172 3.47643V3.98089C12.7172 4.43949 12.5567 4.8293 12.2357 5.15032C11.9147 5.45605 11.5325 5.60892 11.0892 5.60892H8.8879V6.70955C8.8879 7.01529 8.78089 7.27516 8.56688 7.48917C8.36815 7.6879 8.11592 7.78726 7.81019 7.78726H6.70955V9.98853H7.78726V12.1439H6.70955L3.06369 8.49809C3.01783 8.74267 2.97962 8.98726 2.94904 9.23185C2.91847 9.47643 2.90318 9.72866 2.90318 9.98853C2.90318 11.9299 3.5758 13.5885 4.92102 14.9643C6.26624 16.3248 7.90191 17.028 9.82803 17.0739V18.9771ZM17.6471 18.4726L14.8268 15.6293C14.521 15.8127 14.2 15.958 13.8637 16.065C13.5427 16.1567 13.1987 16.2025 12.8318 16.2025C11.7312 16.2025 10.7987 15.8204 10.0344 15.056C9.27006 14.2917 8.8879 13.3669 8.8879 12.2815C8.8879 11.1809 9.27006 10.2484 10.0344 9.48408C10.7987 8.71974 11.7312 8.33758 12.8318 8.33758C13.9172 8.33758 14.842 8.71974 15.6064 9.48408C16.3707 10.2484 16.7529 11.1732 16.7529 12.2586C16.7529 12.6408 16.6994 13 16.5924 13.3363C16.5006 13.6726 16.3631 13.986 16.1796 14.2764L19 17.1197L17.6471 18.4726ZM12.8089 14.2994C13.3745 14.2994 13.8561 14.1083 14.2535 13.7261C14.651 13.3287 14.8497 12.8471 14.8497 12.2815C14.8497 11.7159 14.651 11.2344 14.2535 10.8369C13.8713 10.4395 13.3975 10.2408 12.8318 10.2408C12.2662 10.2408 11.7847 10.4395 11.3873 10.8369C10.9898 11.2191 10.7911 11.693 10.7911 12.2586C10.7911 12.8242 10.9822 13.3057 11.3643 13.7032C11.7618 14.1006 12.2433 14.2994 12.8089 14.2994Z">
        </path>
      </g>
      <g id="globe" viewBox="0 0 20 20">
        <path
          d="M9.99987 16.7167C9.07765 16.7167 8.20543 16.5444 7.3832 16.2C6.57209 15.8444 5.86098 15.3611 5.24987 14.75C4.63876 14.1389 4.15543 13.4278 3.79987 12.6167C3.45543 11.7944 3.2832 10.9222 3.2832 9.99999C3.2832 9.07777 3.45543 8.2111 3.79987 7.39999C4.15543 6.57777 4.63876 5.8611 5.24987 5.24999C5.86098 4.63888 6.57209 4.1611 7.3832 3.81666C8.20543 3.4611 9.07765 3.28333 9.99987 3.28333C10.9221 3.28333 11.7888 3.4611 12.5999 3.81666C13.4221 4.1611 14.1388 4.63888 14.7499 5.24999C15.361 5.8611 15.8388 6.57777 16.1832 7.39999C16.5388 8.2111 16.7165 9.07777 16.7165 9.99999C16.7165 10.9222 16.5388 11.7944 16.1832 12.6167C15.8388 13.4278 15.361 14.1389 14.7499 14.75C14.1388 15.3611 13.4221 15.8444 12.5999 16.2C11.7888 16.5444 10.9221 16.7167 9.99987 16.7167ZM9.9832 15.05C10.1499 14.8722 10.3276 14.5278 10.5165 14.0167C10.7054 13.4944 10.8499 12.9389 10.9499 12.35H9.04987C9.14987 12.9389 9.28876 13.4944 9.46654 14.0167C9.64431 14.5278 9.81654 14.8722 9.9832 15.05ZM8.51654 14.8833C8.34987 14.5611 8.21098 14.1833 8.09987 13.75C7.99987 13.3167 7.91098 12.85 7.8332 12.35H5.49987C5.81098 12.9611 6.22765 13.4889 6.74987 13.9333C7.27209 14.3778 7.86098 14.6944 8.51654 14.8833ZM11.4665 14.8833C12.111 14.6944 12.6999 14.3778 13.2332 13.9333C13.7665 13.4889 14.1832 12.9611 14.4832 12.35H12.1665C12.0888 12.85 11.9943 13.3167 11.8832 13.75C11.7721 14.1833 11.6332 14.5611 11.4665 14.8833ZM12.4832 11.1667H15.0999C15.1554 10.9555 15.1943 10.7555 15.2165 10.5667C15.2388 10.3778 15.2499 10.1889 15.2499 9.99999C15.2499 9.79999 15.2388 9.60555 15.2165 9.41666C15.1943 9.22777 15.1554 9.03333 15.0999 8.83333H12.4832C12.5054 9.03333 12.5165 9.23333 12.5165 9.43332C12.5276 9.63332 12.5332 9.83333 12.5332 10.0333C12.5332 10.2222 12.5276 10.4167 12.5165 10.6167C12.5165 10.8055 12.5054 10.9889 12.4832 11.1667ZM8.89987 11.1667H11.0999C11.1221 10.9444 11.1276 10.7389 11.1165 10.55C11.1165 10.3611 11.1165 10.1778 11.1165 9.99999C11.1165 9.8111 11.1165 9.62221 11.1165 9.43332C11.1276 9.24444 11.1221 9.04444 11.0999 8.83333H8.89987C8.87765 9.04444 8.86098 9.24444 8.84987 9.43332C8.84987 9.62221 8.84987 9.8111 8.84987 9.99999C8.84987 10.1778 8.84987 10.3667 8.84987 10.5667C8.86098 10.7555 8.87765 10.9555 8.89987 11.1667ZM4.89987 11.1667H7.49987C7.47765 10.9667 7.46098 10.7667 7.44987 10.5667C7.44987 10.3555 7.44987 10.1555 7.44987 9.96666C7.44987 9.76666 7.44987 9.57221 7.44987 9.38333C7.46098 9.19444 7.47765 9.0111 7.49987 8.83333H4.89987C4.8332 9.04444 4.7832 9.24444 4.74987 9.43332C4.72765 9.6111 4.71654 9.79999 4.71654 9.99999C4.71654 10.1889 4.72765 10.3778 4.74987 10.5667C4.7832 10.7555 4.8332 10.9555 4.89987 11.1667ZM12.1665 7.64999H14.4832C14.1832 7.02777 13.7665 6.49999 13.2332 6.06666C12.6999 5.62221 12.111 5.30555 11.4665 5.11666C11.6332 5.43888 11.7721 5.81666 11.8832 6.24999C11.9943 6.68333 12.0888 7.14999 12.1665 7.64999ZM9.04987 7.64999H10.9499C10.8499 7.04999 10.7054 6.49444 10.5165 5.98333C10.3276 5.47221 10.1499 5.12777 9.9832 4.94999C9.81654 5.12777 9.64431 5.47221 9.46654 5.98333C9.28876 6.49444 9.14987 7.04999 9.04987 7.64999ZM5.49987 7.64999H7.8332C7.91098 7.14999 7.99987 6.68333 8.09987 6.24999C8.21098 5.81666 8.34987 5.43888 8.51654 5.11666C7.86098 5.30555 7.27209 5.62221 6.74987 6.06666C6.22765 6.49999 5.81098 7.02777 5.49987 7.64999Z">
        </path>
      </g>
      <g id="play" viewBox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M6 16L16 10L6 4V16Z"></path>
      </g>
      <g id="pause" viewBox="0 0 20 20">
        <path d="M9 5H6V15H9V5Z"></path>
        <path d="M14 5H11V15H14V5Z"></path>
      </g>
      <g id="fast-forward" viewBox="0 0 20 20">
        <path d="M10 10L4 14V6L10 10Z"></path>
        <path d="M10 10V14L16 10L10 6V10Z"></path>
      </g>
      <g id="calculator" viewBox="0 0 20 20">
        <path
          d="M17 1H3C1.9 1 1 1.9 1 3V17C1 18.1 1.9 19 3 19H17C18.1 19 19 18.1 19 17V3C19 1.9 18.1 1 17 1ZM17 17H3V3H17V17Z">
        </path>
        <path d="M9.25 5.72H4.25V7.22H9.25V5.72Z"></path>
        <path d="M16 13.75H11V15.25H16V13.75Z"></path>
        <path d="M16 11.25H11V12.75H16V11.25Z"></path>
        <path d="M6 16H7.5V14H9.5V12.5H7.5V10.5H6V12.5H4V14H6V16Z"></path>
        <path
          d="M12.09 8.95L13.5 7.54L14.91 8.95L15.97 7.89L14.56 6.47L15.97 5.06L14.91 4L13.5 5.41L12.09 4L11.03 5.06L12.44 6.47L11.03 7.89L12.09 8.95Z">
        </path>
      </g>
      <g id="view-all-apps" viewBox="0 0 20 20" fill="none">
        <!-- Include a <style> to set the stroke color dynamically based on color scheme (light or dark mode) -->
        <style>
          path {
            stroke: var(--cros-text-color-secondary);
            stroke-width: 1.5;
          }
        </style>
        <path
          d="M1.75 3.75H5.41427V7.41427H1.75V3.75ZM8.16787 3.75H11.8321V7.41427H8.16787V3.75ZM14.5857 3.75H18.25V7.41427H14.5857V3.75ZM14.5857 12.5857H18.25V16.25H14.5857V12.5857ZM8.16787 12.5857H11.8321V16.25H8.16787V12.5857ZM1.75 12.5857H5.41427V16.25H1.75V12.5857Z">
        </path>
      </g>
      <g id="lock" viewBox="0 0 20 20">
        <path
          d="M11.75 12.5C11.75 13.4665 10.9665 14.25 10 14.25C9.0335 14.25 8.25 13.4665 8.25 12.5C8.25 11.5335 9.0335 10.75 10 10.75C10.9665 10.75 11.75 11.5335 11.75 12.5Z">
        </path>
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M14 7H13.5V5C13.5 3.34315 11.6569 2 10 2C8.34315 2 6.5 3.34315 6.5 5V7H6C4.89543 7 4 7.89543 4 9V16C4 17.1046 4.89543 18 6 18H14C15.1046 18 16 17.1046 16 16V9C16 7.89543 15.1046 7 14 7ZM12 5.5V7H8V5.5C8 5 8.5 3.5 10 3.5C11.5 3.5 12 5 12 5.5ZM6 9V16H14V9H6Z">
        </path>
      </g>
      <g id="menu" viewBox="0 0 20 20">
        <path
          d="M7 7.5H13V6H7V7.5ZM7 14H13V12.5H7V14ZM7 10.75H13V9.25H7V10.75ZM4.5 17C4.08333 17 3.72917 16.8542 3.4375 16.5625C3.14583 16.2708 3 15.9167 3 15.5V4.5C3 4.08333 3.14583 3.72917 3.4375 3.4375C3.72917 3.14583 4.08333 3 4.5 3H15.5C15.9167 3 16.2708 3.14583 16.5625 3.4375C16.8542 3.72917 17 4.08333 17 4.5V15.5C17 15.9167 16.8542 16.2708 16.5625 16.5625C16.2708 16.8542 15.9167 17 15.5 17H4.5ZM4.5 15.5H15.5V4.5H4.5V15.5Z">
        </path>
      </g>
      <g id="launch-mail" viewBox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M16 4H4C2.9 4 2 4.9 2 6V14C2 15.1 2.9 16 4 16H16C17.1 16 18 15.1 18 14V6C18 4.9 17.1 4 16 4ZM15.5 6L10 9.5L4.5 6H15.5ZM4 14V8L10 12L16 8V14H4Z">
        </path>
      </g>
      <g id="browser-home" viewBox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M10 2L17 8V17H3V8L10 2ZM12 15V11H8V15H5V8.91987L10 4.63416L15 8.91987V15H12Z">
        </path>
      </g>
    </defs>
  </svg>
</iron-iconset-svg>
`;
document.head.appendChild(template$3.content);

function getTemplate$2U() {
    return html `<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">#header{display:flex}:host([key-state='default-remapping']) .key-container{background-color:var(--cros-bg-color-dropped-elevation-1);border:none;box-shadow:0 1px 1px var(--cros-bg-color-dropped-elevation-1)}:host([key-state='modifier-remapped']) .key-container{background-color:var(--cros-sys-highlight_shape);border:none;box-shadow:0 1px 1px var(--cros-sys-highlight_shape)}.settings-box{justify-content:space-between;padding-inline-start:0}iron-icon{--iron-icon-fill-color:var(--cros-icon-color-secondary);--iron-icon-height:20px;--iron-icon-width:20px;align-self:center;justify-self:center}:host([remove-top-border]) .settings-box{border-top:none}</style>
<div class="settings-box">
  <div>
    <div id="keyLabelContainer" class="start key-container">
      <template is="dom-if" if="[[!keyIcon]]" restamp>
        <div id="keyLabel"
            aria-hidden="true">[[keyLabel]]</div>
      </template>
      <template is="dom-if" if="[[keyIcon]]" restamp>
        <iron-icon icon="[[keyIcon]]"></iron-icon>
      </template>
    </div>
  </div>
  <settings-dropdown-menu id="keyDropdown"
      label="[[keyLabel]]"
      pref="{{pref}}"
      menu-options="[[keyMapTargets]]">
  </settings-dropdown-menu>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'keyboard-remap-key-row' contains a key with icon label and dropdown menu to
 * allow users to customize the remapped key.
 */
/**
 * Refers to the state of an 'remap-key' icon.
 */
var KeyState;
(function (KeyState) {
    KeyState["DEFAULT_REMAPPING"] = "default-remapping";
    KeyState["MODIFIER_REMAPPED"] = "modifier-remapped";
})(KeyState || (KeyState = {}));
const KeyboardRemapModifierKeyRowElementBase = I18nMixin(PolymerElement);
class KeyboardRemapModifierKeyRowElement extends KeyboardRemapModifierKeyRowElementBase {
    static get is() {
        return 'keyboard-remap-modifier-key-row';
    }
    static get properties() {
        return {
            keyLabel: {
                type: String,
                value: '',
                computed: 'getKeyLabel(metaKey)',
            },
            metaKeyLabel: {
                type: String,
                value: '',
                computed: 'getMetaKeyLabel(metaKey)',
            },
            keyState: {
                type: String,
                value: KeyState.DEFAULT_REMAPPING,
                reflectToAttribute: true,
                computed: 'computeKeyState(pref.value, defaultRemappings.*)',
            },
            pref: {
                type: Object,
            },
            metaKey: {
                type: Number,
            },
            key: {
                type: Number,
            },
            defaultRemappings: {
                type: Object,
            },
            keyMapTargets: {
                type: Object,
            },
            keyIcon: {
                type: String,
                value: '',
                computed: 'getKeyIcon(key, metaKey)',
            },
            removeTopBorder: {
                type: Boolean,
                reflectToAttribute: true,
            },
            hasFunctionKey: {
                type: Boolean,
                value: false,
            },
        };
    }
    ready() {
        super.ready();
        this.setUpKeyMapTargets();
    }
    static get template() {
        return getTemplate$2U();
    }
    /**
     * Whenever the key remapping is changed, update the keyState to change
     * the icon color between default and highlighted.
     */
    computeKeyState() {
        return this.defaultRemappings[this.key] === this.pref.value ?
            KeyState.DEFAULT_REMAPPING :
            KeyState.MODIFIER_REMAPPED;
    }
    /**
     * Populate the metaKey label according to metaKey.
     */
    getMetaKeyLabel() {
        switch (this.metaKey) {
            case MetaKey$2.kCommand: {
                return this.i18n('perDeviceKeyboardKeyCommand');
            }
            case MetaKey$2.kExternalMeta: {
                return this.i18n('perDeviceKeyboardKeyMeta');
            }
            // Launcher and Search key will display icon instead of text.
            case MetaKey$2.kLauncher:
            case MetaKey$2.kSearch:
            case MetaKey$2.kLauncherRefresh:
                return this.i18n('perDeviceKeyboardKeySearch');
            default:
                assertNotReached();
        }
    }
    /**
     * Populate the key label inside the keyboard key icon.
     */
    getKeyLabel() {
        switch (this.key) {
            case ModifierKey$2.kAlt: {
                return this.i18n('perDeviceKeyboardKeyAlt');
            }
            case ModifierKey$2.kAssistant: {
                return this.i18n('perDeviceKeyboardKeyAssistant');
            }
            case ModifierKey$2.kBackspace: {
                return this.i18n('perDeviceKeyboardKeyBackspace');
            }
            case ModifierKey$2.kCapsLock: {
                return this.i18n('perDeviceKeyboardKeyCapsLock');
            }
            case ModifierKey$2.kControl: {
                return this.i18n('perDeviceKeyboardKeyCtrl');
            }
            case ModifierKey$2.kEscape: {
                return this.i18n('perDeviceKeyboardKeyEscape');
            }
            case ModifierKey$2.kMeta: {
                return this.getMetaKeyLabel();
            }
            case ModifierKey$2.kQuickInsert: {
                return this.i18n('perDeviceKeyboardKeyQuickInsert');
            }
            case ModifierKey$2.kFunction: {
                return this.i18n('perDeviceKeyboardKeyFunction');
            }
            default:
                assertNotReached('Invalid modifier key: ' + this.key);
        }
    }
    setUpKeyMapTargets() {
        // Ordering is according to UX, but values match ModifierKey.
        this.keyMapTargets = (() => {
            const keyMapTargets = [
                {
                    value: ModifierKey$2.kMeta,
                    name: this.i18n('perDeviceKeyboardKeySearch'),
                },
                {
                    value: ModifierKey$2.kControl,
                    name: this.i18n('perDeviceKeyboardKeyCtrl'),
                },
                {
                    value: ModifierKey$2.kAlt,
                    name: this.i18n('perDeviceKeyboardKeyAlt'),
                },
                {
                    value: ModifierKey$2.kCapsLock,
                    name: this.i18n('perDeviceKeyboardKeyCapsLock'),
                },
                {
                    value: ModifierKey$2.kEscape,
                    name: this.i18n('perDeviceKeyboardKeyEscape'),
                },
                {
                    value: ModifierKey$2.kBackspace,
                    name: this.i18n('perDeviceKeyboardKeyBackspace'),
                },
                {
                    value: ModifierKey$2.kAssistant,
                    name: this.i18n('perDeviceKeyboardKeyAssistant'),
                },
            ];
            if (loadTimeData.getBoolean('enableModifierSplit')) {
                keyMapTargets.push({
                    value: ModifierKey$2.kQuickInsert,
                    name: this.i18n('perDeviceKeyboardKeyQuickInsert'),
                });
            }
            if (this.hasFunctionKey) {
                keyMapTargets.push({
                    value: ModifierKey$2.kFunction,
                    name: this.i18n('perDeviceKeyboardKeyFunction'),
                });
            }
            // Push void last so that right alt is added before it.
            keyMapTargets.push({
                value: ModifierKey$2.kVoid,
                name: this.i18n('perDeviceKeyboardKeyDisabled'),
            });
            return keyMapTargets;
        })();
    }
    getKeyIcon() {
        if (this.key === ModifierKey$2.kMeta) {
            if (this.metaKey === MetaKey$2.kSearch) {
                return 'cr:search';
            }
            if (this.metaKey === MetaKey$2.kLauncher) {
                return 'os-settings:launcher';
            }
            if (this.metaKey === MetaKey$2.kLauncherRefresh) {
                return 'shortcut-input-keys:launcher-refresh';
            }
        }
        else if (this.key === ModifierKey$2.kAssistant) {
            return 'os-settings:assistant';
        }
        else if (this.key === ModifierKey$2.kQuickInsert) {
            return 'shortcut-input-keys:quick-insert';
        }
        return '';
    }
}
customElements.define(KeyboardRemapModifierKeyRowElement.is, KeyboardRemapModifierKeyRowElement);

function getTemplate$2T() {
    return html `<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">.settings-box{justify-content:space-between;padding-inline-start:0}</style>
<div class="settings-box" id="sixPackKeyRow">
  <div>
    <div class="start key-container">
      <div id="keyLabel" aria-hidden="true">[[keyLabel]]</div>
    </div>
  </div>
  <settings-dropdown-menu id="keyDropdown"
    label="[[keyLabel]]"
    pref="{{pref}}"
    menu-options="[[computeMenuOptions(key)]]">
  </settings-dropdown-menu>
</div><!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'keyboard-six-pack-key-row' displays a six pack key alongside a dropdown
 * menu that allows users to set the shortcut that triggers the corresponding
 * six pack key action.
 */
const disabledMenuOption = {
    value: SixPackShortcutModifier$1.kNone,
    name: loadTimeData.getString('sixPackKeyDisabled'),
};
const sixPackKeyProperties = {
    [SixPackKey.DELETE]: {
        menuOptions: [
            {
                value: SixPackShortcutModifier$1.kAlt,
                name: loadTimeData.getString('sixPackKeyDeleteAlt'),
            },
            {
                value: SixPackShortcutModifier$1.kSearch,
                name: loadTimeData.getString('sixPackKeyDeleteSearch'),
            },
            disabledMenuOption,
        ],
        label: loadTimeData.getString('sixPackKeyLabelDelete'),
    },
    [SixPackKey.HOME]: {
        menuOptions: [
            {
                value: SixPackShortcutModifier$1.kAlt,
                name: loadTimeData.getString('sixPackKeyHomeAlt'),
            },
            {
                value: SixPackShortcutModifier$1.kSearch,
                name: loadTimeData.getString('sixPackKeyHomeSearch'),
            },
            disabledMenuOption,
        ],
        label: loadTimeData.getString('sixPackKeyLabelHome'),
    },
    [SixPackKey.END]: {
        menuOptions: [
            {
                value: SixPackShortcutModifier$1.kAlt,
                name: loadTimeData.getString('sixPackKeyEndAlt'),
            },
            {
                value: SixPackShortcutModifier$1.kSearch,
                name: loadTimeData.getString('sixPackKeyEndSearch'),
            },
            disabledMenuOption,
        ],
        label: loadTimeData.getString('sixPackKeyLabelEnd'),
    },
    [SixPackKey.INSERT]: {
        menuOptions: [
            {
                value: SixPackShortcutModifier$1.kSearch,
                name: loadTimeData.getString('sixPackKeyInsertSearch'),
            },
            disabledMenuOption,
        ],
        label: loadTimeData.getString('sixPackKeyLabelInsert'),
    },
    [SixPackKey.PAGE_DOWN]: {
        menuOptions: [
            {
                value: SixPackShortcutModifier$1.kAlt,
                name: loadTimeData.getString('sixPackKeyPageDownAlt'),
            },
            {
                value: SixPackShortcutModifier$1.kSearch,
                name: loadTimeData.getString('sixPackKeyPageDownSearch'),
            },
            disabledMenuOption,
        ],
        label: loadTimeData.getString('sixPackKeyLabelPageDown'),
    },
    [SixPackKey.PAGE_UP]: {
        menuOptions: [
            {
                value: SixPackShortcutModifier$1.kAlt,
                name: loadTimeData.getString('sixPackKeyPageUpAlt'),
            },
            {
                value: SixPackShortcutModifier$1.kSearch,
                name: loadTimeData.getString('sixPackKeyPageUpSearch'),
            },
            disabledMenuOption,
        ],
        label: loadTimeData.getString('sixPackKeyLabelPageUp'),
    },
};
class KeyboardSixPackKeyRowElement extends PolymerElement {
    static get is() {
        return 'keyboard-six-pack-key-row';
    }
    static get template() {
        return getTemplate$2T();
    }
    static get properties() {
        return {
            key: {
                type: String,
            },
            modifier: { type: Number },
            pref: {
                type: Object,
            },
            keyLabel: {
                type: String,
                computed: 'computeKeyLabel(key)',
            },
        };
    }
    computeMenuOptions() {
        assert(this.key in sixPackKeyProperties);
        return sixPackKeyProperties[this.key].menuOptions;
    }
    computeKeyLabel() {
        assert(this.key in sixPackKeyProperties);
        return sixPackKeyProperties[this.key].label;
    }
}
customElements.define(KeyboardSixPackKeyRowElement.is, KeyboardSixPackKeyRowElement);

function getTemplate$2S() {
    return html `<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">#header{display:flex;height:24px;margin-top:12px}.subsection{margin-bottom:0}#description{color:var(--cr-secondary-text-color);font:var(--cros-button-2-font);margin-inline-start:20px}.subsection-header{color:var(--cr-secondary-text-color);font:var(--cros-body-2-font);height:24px;margin:12px 0;padding-inline-start:0}#modifierKeysHeader{margin-bottom:0}</style>
<div id="header">
  <div id="description">[[computeKeyboardKeysDescription(keyboard.*)]]</div>
</div>
<div class="subsection">
  <template is="dom-if" if="[[!isAltClickAndSixPackCustomizationEnabled]]">
    <keyboard-remap-modifier-key-row
        has-function-key="[[hasFunctionKey]]"
        default-remappings="[[defaultRemappings]]"
        key="[[modifierKey.kMeta]]" id="metaKey"
        meta-key="[[keyboard.metaKey]]"
        aria-label="[[getActionRowLabel('perDeviceKeyboardKeySearch')]]"
        pref="{{fakeMetaPref}}"
        remove-top-border>
    </keyboard-remap-modifier-key-row>
    <keyboard-remap-modifier-key-row
        has-function-key="[[hasFunctionKey]]"
        default-remappings="[[defaultRemappings]]"
        key="[[modifierKey.kControl]]" id="ctrlKey"
        meta-key="[[keyboard.metaKey]]"
        aria-label="[[getActionRowLabel('perDeviceKeyboardKeyCtrl')]]"
        pref="{{fakeCtrlPref}}">
    </keyboard-remap-modifier-key-row>
    <keyboard-remap-modifier-key-row
        has-function-key="[[hasFunctionKey]]"
        default-remappings="[[defaultRemappings]]"
        key="[[modifierKey.kAlt]]" id="altKey"
        meta-key="[[keyboard.metaKey]]"
        aria-label="[[getActionRowLabel('perDeviceKeyboardKeyAlt')]]"
        pref="{{fakeAltPref}}">
    </keyboard-remap-modifier-key-row>
    <keyboard-remap-modifier-key-row
        has-function-key="[[hasFunctionKey]]"
        default-remappings="[[defaultRemappings]]"
        key="[[modifierKey.kEscape]]" id="escapeKey"
        meta-key="[[keyboard.metaKey]]"
        aria-label="[[getActionRowLabel('perDeviceKeyboardKeyEscape')]]"
        pref="{{fakeEscPref}}">
    </keyboard-remap-modifier-key-row>
    <keyboard-remap-modifier-key-row
        has-function-key="[[hasFunctionKey]]"
        default-remappings="[[defaultRemappings]]"
        key="[[modifierKey.kBackspace]]" id="backspaceKey"
        meta-key="[[keyboard.metaKey]]"
        aria-label="[[getActionRowLabel('perDeviceKeyboardKeyBackspace')]]"
        pref="{{fakeBackspacePref}}">
    </keyboard-remap-modifier-key-row>
    <template is="dom-if" if="[[hasAssistantKey]]" restamp>
      <keyboard-remap-modifier-key-row
          has-function-key="[[hasFunctionKey]]"
          default-remappings="[[defaultRemappings]]"
          key="[[modifierKey.kAssistant]]" id="assistantKey"
          meta-key="[[keyboard.metaKey]]"
          aria-label="[[getActionRowLabel('perDeviceKeyboardKeyAssistant')]]"
          pref="{{fakeAssistantPref}}">
      </keyboard-remap-modifier-key-row>
    </template>
    <template is="dom-if" if="[[hasCapsLockKey]]" restamp>
      <keyboard-remap-modifier-key-row
          has-function-key="[[hasFunctionKey]]"
          default-remappings="[[defaultRemappings]]"
          key="[[modifierKey.kCapsLock]]" id="capsLockKey"
          meta-key="[[keyboard.metaKey]]"
          aria-label="[[getActionRowLabel('perDeviceKeyboardKeyCapsLock')]]"
          pref="{{fakeCapsLockPref}}">
      </keyboard-remap-modifier-key-row>
    </template>
  </template>
  <template is="dom-if" if="[[isAltClickAndSixPackCustomizationEnabled]]">
    <h2 class="subsection-header" id="modifierKeysHeader">
      $i18n{modifierKeysLabel}
    </h2>
    <div class="subsection">
      <keyboard-remap-modifier-key-row
          has-function-key="[[hasFunctionKey]]"
          default-remappings="[[defaultRemappings]]"
          key="[[modifierKey.kMeta]]" id="metaKey"
          meta-key="[[keyboard.metaKey]]"
          aria-label="[[getActionRowLabel('perDeviceKeyboardKeySearch')]]"
          pref="{{fakeMetaPref}}"
          remove-top-border>
      </keyboard-remap-modifier-key-row>
      <keyboard-remap-modifier-key-row
          has-function-key="[[hasFunctionKey]]"
          default-remappings="[[defaultRemappings]]"
          key="[[modifierKey.kControl]]" id="ctrlKey"
          meta-key="[[keyboard.metaKey]]"
          aria-label="[[getActionRowLabel('perDeviceKeyboardKeyCtrl')]]"
          pref="{{fakeCtrlPref}}">
      </keyboard-remap-modifier-key-row>
      <keyboard-remap-modifier-key-row
          has-function-key="[[hasFunctionKey]]"
          default-remappings="[[defaultRemappings]]"
          key="[[modifierKey.kAlt]]" id="altKey"
          meta-key="[[keyboard.metaKey]]"
          aria-label="[[getActionRowLabel('perDeviceKeyboardKeyAlt')]]"
          pref="{{fakeAltPref}}">
      </keyboard-remap-modifier-key-row>
      <keyboard-remap-modifier-key-row
          has-function-key="[[hasFunctionKey]]"
          default-remappings="[[defaultRemappings]]"
          key="[[modifierKey.kEscape]]" id="escapeKey"
          meta-key="[[keyboard.metaKey]]"
          aria-label="[[getActionRowLabel('perDeviceKeyboardKeyEscape')]]"
          pref="{{fakeEscPref}}">
      </keyboard-remap-modifier-key-row>
      <keyboard-remap-modifier-key-row
          has-function-key="[[hasFunctionKey]]"
          default-remappings="[[defaultRemappings]]"
          key="[[modifierKey.kBackspace]]" id="backspaceKey"
          meta-key="[[keyboard.metaKey]]"
          aria-label="[[getActionRowLabel('perDeviceKeyboardKeyBackspace')]]"
          pref="{{fakeBackspacePref}}">
      </keyboard-remap-modifier-key-row>
      <template is="dom-if" if="[[hasAssistantKey]]" restamp>
        <keyboard-remap-modifier-key-row
            has-function-key="[[hasFunctionKey]]"
            default-remappings="[[defaultRemappings]]"
            key="[[modifierKey.kAssistant]]" id="assistantKey"
            meta-key="[[keyboard.metaKey]]"
            aria-label="[[getActionRowLabel('perDeviceKeyboardKeyAssistant')]]"
            pref="{{fakeAssistantPref}}">
        </keyboard-remap-modifier-key-row>
      </template>
      <template is="dom-if" if="[[hasQuickInsertKey]]" restamp>
        <keyboard-remap-modifier-key-row
            has-function-key="[[hasFunctionKey]]"
            default-remappings="[[defaultRemappings]]"
            key="[[modifierKey.kQuickInsert]]" id="quickInsertKey"
            meta-key="[[keyboard.metaKey]]"
            aria-label=
                "[[getActionRowLabel('perDeviceKeyboardKeyQuickInsert')]]"
            pref="{{fakeQuickInsertPref}}">
        </keyboard-remap-modifier-key-row>
      </template>
      <template is="dom-if" if="[[hasFunctionKey]]" restamp>
        <keyboard-remap-modifier-key-row
            has-function-key="[[hasFunctionKey]]"
            default-remappings="[[defaultRemappings]]"
            key="[[modifierKey.kFunction]]" id="functionKey"
            meta-key="[[keyboard.metaKey]]"
            aria-label="[[getActionRowLabel('perDeviceKeyboardKeyFunction')]]"
            pref="{{fakeFunctionPref}}">
        </keyboard-remap-modifier-key-row>
      </template>
      <template is="dom-if" if="[[hasCapsLockKey]]" restamp>
        <keyboard-remap-modifier-key-row
            has-function-key="[[hasFunctionKey]]"
            default-remappings="[[defaultRemappings]]"
            key="[[modifierKey.kCapsLock]]" id="capsLockKey"
            meta-key="[[keyboard.metaKey]]"
            aria-label="[[getActionRowLabel('perDeviceKeyboardKeyCapsLock')]]"
            pref="{{fakeCapsLockPref}}">
        </keyboard-remap-modifier-key-row>
      </template>
    </div>
    <template is="dom-if" if="[[!hasFunctionKey]]">
      <h2 class="subsection-header" id="otherKeysHeader">
        $i18n{otherKeysLabel}
      </h2>
    </template>
    <div class="subsection">
      <template is="dom-if" if="[[!hasFunctionKey]]">
        <keyboard-six-pack-key-row id="del"
            modifier="[[keyboard.sixPackKeyRemappings.del]]"
            key="del"
            pref="{{deletePref}}"
            aria-label="[[getShortcutRowLabel('sixPackKeyLabelDelete')]]">
        </keyboard-six-pack-key-row>
        <keyboard-six-pack-key-row id="pageDown"
            modifier="[[keyboard.sixPackKeyRemappings.pageDown]]"
            key="pageDown"
            pref="{{pageDownPref}}"
            aria-label="[[getShortcutRowLabel('sixPackKeyLabelPageDown')]]">
        </keyboard-six-pack-key-row>
        <keyboard-six-pack-key-row id="pageUp"
            modifier="[[keyboard.sixPackKeyRemappings.pageUp]]"
            key="pageUp"
            pref="{{pageUpPref}}"
            aria-label="[[getShortcutRowLabel('sixPackKeyLabelPageUp')]]">
        </keyboard-six-pack-key-row>
        <keyboard-six-pack-key-row id="end"
            modifier="[[keyboard.sixPackKeyRemappings.end]]"
            key="end"
            pref="{{endPref}}"
            aria-label="[[getShortcutRowLabel('sixPackKeyLabelEnd')]]">
        </keyboard-six-pack-key-row>
        <keyboard-six-pack-key-row id="home"
            modifier="[[keyboard.sixPackKeyRemappings.home]]"
            key="home"
            pref="{{homePref}}"
            aria-label="[[getShortcutRowLabel('sixPackKeyLabelHome')]]">
        </keyboard-six-pack-key-row>
        <keyboard-six-pack-key-row id="insert"
            modifier="[[keyboard.sixPackKeyRemappings.insert]]"
            key="insert"
            pref="{{insertPref}}"
            aria-label="[[getShortcutRowLabel('sixPackKeyLabelInsert')]]">
        </keyboard-six-pack-key-row>
      </template>
      <template is="dom-if"
          if="[[shouldShowFkeys(keyboard.*, hasFunctionKey)]]">
        <fkey-row key="f11"
            aria-label="[[getShortcutRowLabel('f11KeyLabel')]]" id="f11"
            pref="{{f11KeyPref}}" keyboard="[[keyboard]]">
        </fkey-row>
        <fkey-row key="f12"
            aria-label="[[getShortcutRowLabel('f12KeyLabel')]]" id="f12"
            pref="{{f12KeyPref}}" keyboard="[[keyboard]]">
        </fkey-row>
      </template>
    </div>
  </template>
</div><!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'per-device-keyboard-settings-remap-keys' displays the remapped keys and
 * allow users to configure their keyboard remapped keys for each keyboard.
 */
function getPrefPolicyFields(policy) {
    if (policy) {
        const enforcement = policy.policyStatus === PolicyStatus$1.kManaged ?
            chrome.settingsPrivate.Enforcement.ENFORCED :
            chrome.settingsPrivate.Enforcement.RECOMMENDED;
        return {
            controlledBy: chrome.settingsPrivate.ControlledBy.USER_POLICY,
            enforcement,
            recommendedValue: policy.value,
        };
    }
    // These fields must be set back to undefined so the html badge is properly
    // removed from the UI.
    return {
        controlledBy: undefined,
        enforcement: undefined,
        recommendedValue: undefined,
    };
}
const SettingsPerDeviceKeyboardRemapKeysElementBase = RouteObserverMixin(I18nMixin(PolymerElement));
class SettingsPerDeviceKeyboardRemapKeysElement extends SettingsPerDeviceKeyboardRemapKeysElementBase {
    constructor() {
        super(...arguments);
        this.defaultRemappings = {
            [ModifierKey$2.kMeta]: ModifierKey$2.kMeta,
            [ModifierKey$2.kControl]: ModifierKey$2.kControl,
            [ModifierKey$2.kAlt]: ModifierKey$2.kAlt,
            [ModifierKey$2.kEscape]: ModifierKey$2.kEscape,
            [ModifierKey$2.kBackspace]: ModifierKey$2.kBackspace,
            [ModifierKey$2.kAssistant]: ModifierKey$2.kAssistant,
            [ModifierKey$2.kCapsLock]: ModifierKey$2.kCapsLock,
            [ModifierKey$2.kQuickInsert]: ModifierKey$2.kQuickInsert,
            [ModifierKey$2.kFunction]: ModifierKey$2.kFunction,
        };
        this.inputDeviceSettingsProvider = getInputDeviceSettingsProvider();
    }
    static get is() {
        return 'settings-per-device-keyboard-remap-keys';
    }
    static get template() {
        return getTemplate$2S();
    }
    static get properties() {
        return {
            fakeMetaPref: {
                type: Object,
                value() {
                    return {
                        key: 'fakeMetaKeyRemapPref',
                        type: chrome.settingsPrivate.PrefType.NUMBER,
                        value: ModifierKey$2.kMeta,
                    };
                },
            },
            fakeCtrlPref: {
                type: Object,
                value() {
                    return {
                        key: 'fakeCtrlKeyRemapPref',
                        type: chrome.settingsPrivate.PrefType.NUMBER,
                        value: ModifierKey$2.kControl,
                    };
                },
            },
            fakeAltPref: {
                type: Object,
                value() {
                    return {
                        key: 'fakeAltKeyRemapPref',
                        type: chrome.settingsPrivate.PrefType.NUMBER,
                        value: ModifierKey$2.kAlt,
                    };
                },
            },
            fakeEscPref: {
                type: Object,
                value() {
                    return {
                        key: 'fakeEscKeyRemapPref',
                        type: chrome.settingsPrivate.PrefType.NUMBER,
                        value: ModifierKey$2.kEscape,
                    };
                },
            },
            fakeBackspacePref: {
                type: Object,
                value() {
                    return {
                        key: 'fakeBackspaceKeyRemapPref',
                        type: chrome.settingsPrivate.PrefType.NUMBER,
                        value: ModifierKey$2.kBackspace,
                    };
                },
            },
            fakeAssistantPref: {
                type: Object,
                value() {
                    return {
                        key: 'fakeAssistantKeyRemapPref',
                        type: chrome.settingsPrivate.PrefType.NUMBER,
                        value: ModifierKey$2.kAssistant,
                    };
                },
            },
            fakeCapsLockPref: {
                type: Object,
                value() {
                    return {
                        key: 'fakeCapsLockKeyRemapPref',
                        type: chrome.settingsPrivate.PrefType.NUMBER,
                        value: ModifierKey$2.kCapsLock,
                    };
                },
            },
            fakeQuickInsertPref: {
                type: Object,
                value() {
                    return {
                        key: 'fakeQuickInsertKeyRemapPref',
                        type: chrome.settingsPrivate.PrefType.NUMBER,
                        value: ModifierKey$2.kQuickInsert,
                    };
                },
            },
            fakeFunctionPref: {
                type: Object,
                value() {
                    return {
                        key: 'fakeFunctionKeyRemapPref',
                        type: chrome.settingsPrivate.PrefType.NUMBER,
                        value: ModifierKey$2.kFunction,
                    };
                },
            },
            insertPref: {
                type: Object,
                value() {
                    return {
                        key: 'insertPref',
                        type: chrome.settingsPrivate.PrefType.NUMBER,
                        value: SixPackShortcutModifier$1.kSearch,
                    };
                },
            },
            deletePref: {
                type: Object,
                value() {
                    return {
                        key: 'deletePref',
                        type: chrome.settingsPrivate.PrefType.NUMBER,
                        value: SixPackShortcutModifier$1.kSearch,
                    };
                },
            },
            homePref: {
                type: Object,
                value() {
                    return {
                        key: 'homePref',
                        type: chrome.settingsPrivate.PrefType.NUMBER,
                        value: SixPackShortcutModifier$1.kSearch,
                    };
                },
            },
            endPref: {
                type: Object,
                value() {
                    return {
                        key: 'endPref',
                        type: chrome.settingsPrivate.PrefType.NUMBER,
                        value: SixPackShortcutModifier$1.kSearch,
                    };
                },
            },
            pageUpPref: {
                type: Object,
                value() {
                    return {
                        key: 'pageUpPref',
                        type: chrome.settingsPrivate.PrefType.NUMBER,
                        value: SixPackShortcutModifier$1.kSearch,
                    };
                },
            },
            pageDownPref: {
                type: Object,
                value() {
                    return {
                        key: 'pageDownPref',
                        type: chrome.settingsPrivate.PrefType.NUMBER,
                        value: SixPackShortcutModifier$1.kSearch,
                    };
                },
            },
            f11KeyPref: {
                type: Object,
                value() {
                    return {
                        key: 'f11KeyPref',
                        type: chrome.settingsPrivate.PrefType.NUMBER,
                        value: ExtendedFkeysModifier$1.kDisabled,
                    };
                },
            },
            f12KeyPref: {
                type: Object,
                value() {
                    return {
                        key: 'f12KeyPref',
                        type: chrome.settingsPrivate.PrefType.NUMBER,
                        value: ExtendedFkeysModifier$1.kDisabled,
                    };
                },
            },
            hasAssistantKey: {
                type: Boolean,
                value: false,
            },
            hasCapsLockKey: {
                type: Boolean,
                value: false,
            },
            hasQuickInsertKey: {
                type: Boolean,
                value: false,
            },
            hasFunctionKey: {
                type: Boolean,
                value: false,
            },
            keyboard: {
                type: Object,
            },
            keyboards: {
                type: Array,
                // Prevents the `onKeyboardListUpdated` observer from firing
                // when the page is first initialized.
                value: undefined,
            },
            metaKeyLabel: {
                type: String,
            },
            defaultRemappings: {
                type: Object,
            },
            /**
             * Set it to false when the page is initializing and prefs are being
             * synced to match those in the keyboard's settings from the provider.
             * onSettingsChanged function shouldn't be called during the
             * initialization process.
             */
            isInitialized: {
                type: Boolean,
                value: false,
            },
            keyboardId: {
                type: Number,
                value: -1,
            },
            isAltClickAndSixPackCustomizationEnabled: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('enableAltClickAndSixPackCustomization');
                },
                readOnly: true,
            },
            areF11andF12KeyShortcutsEnabled: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('enableF11AndF12KeyShortcuts');
                },
                readOnly: true,
            },
            keyboardPolicies: {
                type: Object,
            },
        };
    }
    static get observers() {
        return [
            'onSettingsChanged(fakeMetaPref.value,' +
                'fakeCtrlPref.value,' +
                'fakeAltPref.value,' +
                'fakeEscPref.value,' +
                'fakeBackspacePref.value,' +
                'fakeAssistantPref.value,' +
                'insertPref.value,' +
                'pageUpPref.value,' +
                'pageDownPref.value,' +
                'endPref.value,' +
                'deletePref.value,' +
                'homePref.value,' +
                'f11KeyPref.value,' +
                'f12KeyPref.value,' +
                'fakeQuickInsertPref.value,' +
                'fakeFunctionPref.value,' +
                'fakeCapsLockPref.value)',
            'onKeyboardListUpdated(keyboards.*)',
            'onPoliciesChanged(keyboardPolicies)',
        ];
    }
    get modifierKey() {
        return ModifierKey$2;
    }
    currentRouteChanged(route) {
        // Does not apply to this page.
        if (route !== routes.PER_DEVICE_KEYBOARD_REMAP_KEYS) {
            return;
        }
        if (this.hasKeyboards() &&
            this.keyboardId !== this.getKeyboardIdFromUrl()) {
            this.initializeKeyboard();
        }
    }
    computeModifierRemappings() {
        const modifierRemappings = new Map();
        for (const modifier of Object.keys(this.keyboard.settings.modifierRemappings)) {
            const from = Number(modifier);
            const to = this.keyboard.settings.modifierRemappings[from];
            if (to === undefined) {
                continue;
            }
            modifierRemappings.set(from, to);
        }
        return modifierRemappings;
    }
    /**
     * Get the keyboard to display according to the keyboardId in the url query,
     * initializing the page and pref with the keyboard data.
     */
    initializeKeyboard() {
        // Set isInitialized to false to prevent calling update keyboard settings
        // api while the prefs are initializing.
        this.isInitialized = false;
        this.keyboardId = this.getKeyboardIdFromUrl();
        const searchedKeyboard = this.keyboards.find((keyboard) => keyboard.id === this.keyboardId);
        assert(!!searchedKeyboard);
        this.keyboard = searchedKeyboard;
        this.updateDefaultRemapping();
        this.initializePrefsToIdentity();
        // Assistant key and caps lock key are optional. Their values depend on
        // keyboard modifierKeys.
        this.hasAssistantKey =
            searchedKeyboard.modifierKeys.includes(ModifierKey$2.kAssistant);
        this.hasCapsLockKey =
            searchedKeyboard.modifierKeys.includes(ModifierKey$2.kCapsLock);
        this.hasQuickInsertKey =
            searchedKeyboard.modifierKeys.includes(ModifierKey$2.kQuickInsert);
        this.hasFunctionKey =
            searchedKeyboard.modifierKeys.includes(ModifierKey$2.kFunction);
        // Update Prefs according to keyboard modifierRemappings.
        Array.from(this.computeModifierRemappings().keys())
            .forEach((originalKey) => {
            this.setRemappedKey(originalKey);
        });
        if (this.isAltClickAndSixPackCustomizationEnabled) {
            this.setSixPackKeyRemappings();
            // Potentially overrides some/all "six pack" settings based on
            // the keyboard policies.
            this.setSixPackKeyRemappingsForPolicies();
        }
        if (this.shouldShowFkeys()) {
            this.set('f11KeyPref.value', searchedKeyboard.settings?.f11);
            this.set('f12KeyPref.value', searchedKeyboard.settings?.f12);
            this.f11KeyPref = {
                ...this.f11KeyPref,
                ...getPrefPolicyFields(this.keyboardPolicies?.f11KeyPolicy),
            };
            this.f12KeyPref = {
                ...this.f12KeyPref,
                ...getPrefPolicyFields(this.keyboardPolicies?.f12KeyPolicy),
            };
        }
        this.isInitialized = true;
    }
    keyboardWasDisconnected(id) {
        return !this.keyboards.find(keyboard => keyboard.id === id);
    }
    onKeyboardListUpdated() {
        if (Router.getInstance().currentRoute !==
            routes.PER_DEVICE_KEYBOARD_REMAP_KEYS) {
            return;
        }
        if (!this.hasKeyboards() ||
            this.keyboardWasDisconnected(this.getKeyboardIdFromUrl())) {
            this.keyboardId = -1;
            Router.getInstance().navigateTo(routes.PER_DEVICE_KEYBOARD);
            return;
        }
        this.initializeKeyboard();
    }
    setSixPackKeyRemappingsForPolicies() {
        const homeAndEndPrefPolicyFields = getPrefPolicyFields(this.keyboardPolicies?.homeAndEndKeysPolicy);
        this.homePref = { ...this.homePref, ...homeAndEndPrefPolicyFields };
        this.endPref = { ...this.endPref, ...homeAndEndPrefPolicyFields };
        const pageUpAndPageDownPrefPolicyFields = getPrefPolicyFields(this.keyboardPolicies?.pageUpAndPageDownKeysPolicy);
        this.pageUpPref = {
            ...this.pageUpPref,
            ...pageUpAndPageDownPrefPolicyFields,
        };
        this.pageDownPref = {
            ...this.pageDownPref,
            ...pageUpAndPageDownPrefPolicyFields,
        };
        this.deletePref = {
            ...this.deletePref,
            ...getPrefPolicyFields(this.keyboardPolicies?.deleteKeyPolicy),
        };
        this.insertPref = {
            ...this.insertPref,
            ...getPrefPolicyFields(this.keyboardPolicies?.insertKeyPolicy),
        };
    }
    /**
     * Sets all prefs to the "identity" value which so they can be updated by the
     * values in the remappings map.
     */
    initializePrefsToIdentity() {
        this.set('fakeAltPref.value', ModifierKey$2.kAlt);
        this.set('fakeAssitantPref.value', ModifierKey$2.kAssistant);
        this.set('fakeBackspacePref.value', ModifierKey$2.kBackspace);
        this.set('fakeCtrlPref.value', ModifierKey$2.kControl);
        this.set('fakeCapsLockPref.value', ModifierKey$2.kCapsLock);
        this.set('fakeEscPref.value', ModifierKey$2.kEscape);
        this.set('fakeMetaPref.value', ModifierKey$2.kMeta);
        if (loadTimeData.getBoolean('enableModifierSplit')) {
            this.set('fakeQuickInsertPref.value', ModifierKey$2.kQuickInsert);
        }
        if (this.hasFunctionKey) {
            this.set('fakeFunctionPref.value', ModifierKey$2.kFunction);
        }
    }
    restoreDefaults() {
        this.inputDeviceSettingsProvider.restoreDefaultKeyboardRemappings(this.keyboardId);
    }
    setRemappedKey(originalKey) {
        const targetKey = this.computeModifierRemappings().get(originalKey);
        switch (originalKey) {
            case ModifierKey$2.kAlt: {
                this.set('fakeAltPref.value', targetKey);
                break;
            }
            case ModifierKey$2.kAssistant: {
                this.set('fakeAssistantPref.value', targetKey);
                break;
            }
            case ModifierKey$2.kBackspace: {
                this.set('fakeBackspacePref.value', targetKey);
                break;
            }
            case ModifierKey$2.kCapsLock: {
                this.set('fakeCapsLockPref.value', targetKey);
                break;
            }
            case ModifierKey$2.kControl: {
                this.set('fakeCtrlPref.value', targetKey);
                break;
            }
            case ModifierKey$2.kEscape: {
                this.set('fakeEscPref.value', targetKey);
                break;
            }
            case ModifierKey$2.kMeta: {
                this.set('fakeMetaPref.value', targetKey);
                break;
            }
            case ModifierKey$2.kQuickInsert: {
                this.set('fakeQuickInsertPref.value', targetKey);
                break;
            }
            case ModifierKey$2.kFunction: {
                this.set('fakeFunctionPref.value', targetKey);
                break;
            }
        }
    }
    /**
     * Update keyboard settings when the prefs change.
     */
    onSettingsChanged() {
        if (!this.isInitialized) {
            return;
        }
        this.keyboard.settings = {
            ...this.keyboard.settings,
            modifierRemappings: this.getUpdatedRemappings(),
        };
        if (this.isAltClickAndSixPackCustomizationEnabled) {
            this.keyboard.settings = {
                ...this.keyboard.settings,
                sixPackKeyRemappings: this.getSixPackKeyRemappings(),
            };
        }
        if (this.shouldShowFkeys()) {
            this.keyboard.settings = {
                ...this.keyboard.settings,
                f11: this.f11KeyPref.value,
                f12: this.f12KeyPref.value,
            };
        }
        this.inputDeviceSettingsProvider.setKeyboardSettings(this.keyboard.id, this.keyboard.settings);
    }
    /**
     * Get the modifier remappings with updated pref values.
     */
    getUpdatedRemappings() {
        const updatedRemappings = {};
        if (ModifierKey$2.kAlt !== this.fakeAltPref.value) {
            updatedRemappings[ModifierKey$2.kAlt] = this.fakeAltPref.value;
        }
        if (ModifierKey$2.kAssistant !== this.fakeAssistantPref.value) {
            updatedRemappings[ModifierKey$2.kAssistant] = this.fakeAssistantPref.value;
        }
        if (ModifierKey$2.kBackspace !== this.fakeBackspacePref.value) {
            updatedRemappings[ModifierKey$2.kBackspace] = this.fakeBackspacePref.value;
        }
        if (ModifierKey$2.kCapsLock !== this.fakeCapsLockPref.value) {
            updatedRemappings[ModifierKey$2.kCapsLock] = this.fakeCapsLockPref.value;
        }
        if (ModifierKey$2.kControl !== this.fakeCtrlPref.value) {
            updatedRemappings[ModifierKey$2.kControl] = this.fakeCtrlPref.value;
        }
        if (ModifierKey$2.kEscape !== this.fakeEscPref.value) {
            updatedRemappings[ModifierKey$2.kEscape] = this.fakeEscPref.value;
        }
        if (ModifierKey$2.kMeta !== this.fakeMetaPref.value) {
            updatedRemappings[ModifierKey$2.kMeta] = this.fakeMetaPref.value;
        }
        if (loadTimeData.getBoolean('enableModifierSplit')) {
            if (ModifierKey$2.kQuickInsert !== this.fakeQuickInsertPref.value) {
                updatedRemappings[ModifierKey$2.kQuickInsert] =
                    this.fakeQuickInsertPref.value;
            }
        }
        if (this.hasFunctionKey) {
            if (ModifierKey$2.kFunction !== this.fakeFunctionPref.value) {
                updatedRemappings[ModifierKey$2.kFunction] = this.fakeFunctionPref.value;
            }
        }
        return updatedRemappings;
    }
    updateDefaultRemapping() {
        this.defaultRemappings = {
            ...this.defaultRemappings,
            [ModifierKey$2.kMeta]: this.keyboard.metaKey === MetaKey$2.kCommand ? ModifierKey$2.kControl :
                ModifierKey$2.kMeta,
            [ModifierKey$2.kControl]: this.keyboard.metaKey === MetaKey$2.kCommand ? ModifierKey$2.kMeta :
                ModifierKey$2.kControl,
        };
    }
    getKeyboardIdFromUrl() {
        return Number(Router.getInstance().getQueryParameters().get('keyboardId'));
    }
    hasKeyboards() {
        return this.keyboards?.length > 0;
    }
    computeKeyboardKeysDescription() {
        if (!this.keyboard?.name) {
            return '';
        }
        const keyboardName = this.keyboard.isExternal ?
            this.keyboard.name :
            this.i18n('builtInKeyboardName');
        if (this.isAltClickAndSixPackCustomizationEnabled) {
            return keyboardName;
        }
        return this.i18n('remapKeyboardKeysDescription', keyboardName);
    }
    setSixPackKeyRemappings() {
        const sixPackKeyRemappings = this.keyboard.settings?.sixPackKeyRemappings;
        if (!sixPackKeyRemappings) {
            return;
        }
        Object.entries(sixPackKeyRemappings).forEach(([key, modifier]) => {
            switch (key) {
                case SixPackKey.DELETE:
                    this.set('deletePref.value', modifier);
                    break;
                case SixPackKey.INSERT:
                    this.set('insertPref.value', modifier);
                    break;
                case SixPackKey.HOME:
                    this.set('homePref.value', modifier);
                    break;
                case SixPackKey.END:
                    this.set('endPref.value', modifier);
                    break;
                case SixPackKey.PAGE_UP:
                    this.set('pageUpPref.value', modifier);
                    break;
                case SixPackKey.PAGE_DOWN:
                    this.set('pageDownPref.value', modifier);
                    break;
            }
        });
    }
    getSixPackKeyRemappings() {
        return {
            home: this.homePref.value,
            pageUp: this.pageUpPref.value,
            pageDown: this.pageDownPref.value,
            del: this.deletePref.value,
            insert: this.insertPref.value,
            end: this.endPref.value,
        };
    }
    shouldShowFkeys() {
        return this.areF11andF12KeyShortcutsEnabled &&
            (this.keyboard?.settings?.f11 != null &&
                this.keyboard?.settings?.f12 != null) &&
            !this.hasFunctionKey;
    }
    getShortcutRowLabel(name) {
        return this.i18n('keyboardShortcutRowDescription', this.i18n(name));
    }
    getActionRowLabel(name) {
        return this.i18n('keyboardActionRowDescription', this.i18n(name));
    }
    onPoliciesChanged() {
        if (this.shouldShowFkeys()) {
            this.f11KeyPref = {
                ...this.f11KeyPref,
                ...getPrefPolicyFields(this.keyboardPolicies?.f11KeyPolicy),
            };
            this.f12KeyPref = {
                ...this.f12KeyPref,
                ...getPrefPolicyFields(this.keyboardPolicies?.f12KeyPolicy),
            };
        }
        this.setSixPackKeyRemappingsForPolicies();
    }
}
customElements.define(SettingsPerDeviceKeyboardRemapKeysElement.is, SettingsPerDeviceKeyboardRemapKeysElement);

function getTemplate$2R() {
    return html `<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">.settings-box:first-of-type{border-top:none}.settings-box,#mouseAcceleration,#mouseControlledScrolling{margin-left:var(--cr-section-indent-width)}#mouseReverseScrollRow{border-top:none}.subsection-subtitle{padding-top:15px}</style>
<div id="mouse">
  <per-device-subsection-header
    id="subsectionHeader"
    device-key="[[mouse.deviceKey]]"
    name="[[mouse.name]]"
    battery-info="[[mouse.batteryInfo]]"
    icon="os-settings:device-mouse">
  </per-device-subsection-header>
  <template is="dom-if" if="[[showSwapToggleButton(
      customizationRestriction, isPeripheralCustomizationEnabled_)]]">
    <settings-toggle-button id="mouseSwapToggleButton"
        label="$i18n{mouseSwapButtonsLabel}" pref="{{primaryRightPref}}">
    </settings-toggle-button>
  </template>
  <template is="dom-if" if="[[showInstallAppRow(mouse.appInfo)]]">
    <per-device-install-row app-info="[[mouse.appInfo]]">
    </per-device-install-row>
  </template>
  <div class="subsection">
    <h2 class="subsection-subtitle">$i18n{mouseCursor}</h2>
    <template is="dom-if" if="[[!isPeripheralCustomizationEnabled_]]">
      <div class="settings-box">
        <div class="start settings-box-text" id="mouseSwapButtonLabel">
          $i18n{mouseSwapButtonsLabel}
        </div>
        <settings-dropdown-menu id="mouseSwapButtonDropdown"
            aria-describedby="mouseName"
            label="$i18n{mouseSwapButtonsLabel}"
            pref="{{primaryRightPref}}"
            menu-options="[[swapPrimaryOptions_]]"
            deep-link-focus-id$="[[Setting.kMouseSwapPrimaryButtons]]">
        </settings-dropdown-menu>
      </div>
    </template>
    <settings-toggle-button id="mouseAcceleration"
        class="hr"
        pref="{{accelerationPref}}"
        label="[[getCursorAccelerationString()]]"
        sub-label="$i18n{mouseAccelerationDescription}"
        aria-describedby="mouseName"
        deep-link-focus-id$="[[Setting.kMouseAcceleration]]">
    </settings-toggle-button>
    <div class="settings-box">
      <div class="start" id="mouseSpeedLabel" aria-hidden="true">
        [[getCursorSpeedString()]]
      </div>
      <settings-slider id="mouseSpeedSlider"
          pref="{{sensitivityPref}}"
          ticks="[[sensitivityValues_]]"
          aria-describedby="mouseName"
          label-aria="[[getCursorSpeedString()]]"
          label-min="$i18n{pointerSlow}"
          label-max="$i18n{pointerFast}"
          deep-link-focus-id$="[[Setting.kMouseSpeed]]">
      </settings-slider>
    </div>
    <h2 class="hr">$i18n{mouseScrolling}</h2>
    <div class="settings-box bottom-divider" id="mouseReverseScrollRow"
          on-click="onMouseReverseScrollRowClicked_" actionable-row>
      <div class="start settings-box-text">
        <localized-link
            aria-describedby="mouseName"
            on-click="onLearnMoreLinkClicked_"
            id="enableMouseReverseScrollingLabel"
            localized-string="$i18n{mouseReverseScrollLabel}"
            link-url="$i18n{naturalScrollLearnMoreLink}">
        </localized-link>
        <div class="secondary">
          $i18n{mouseReverseScrollDescription}
        </div>
      </div>
      <cr-toggle id="mouseReverseScroll"
          checked="{{reverseScrollValue}}"
          aria-describedby="mouseName"
          aria-label=
              "[[getLabelWithoutLearnMore('mouseReverseScrollLabel')]]"
          deep-link-focus-id$="[[Setting.kMouseReverseScrolling]]">
      </cr-toggle>
    </div>
    <div class="settings-box bottom-divider" id="mouseControlledScrollingRow"
         on-click="onMouseControlledScrollingRowClicked_" actionable-row>
      <div class="start settings-box-text">
        <localized-link
          aria-describedby="mouseName"
          on-click="onLearnMoreLinkClicked_"
          id="enableMouseControlledScrollingLabel"
          localized-string="$i18n{mouseControlledScrollingLabel}"
          link-url="$i18n{controlledScrollingLearnMoreLink}">
        </localized-link>
      </div>
      <cr-toggle id="mouseControlledScrolling"
                 checked="{{!scrollAccelerationValue}}"
                 aria-describedby="mouseName"
                 aria-label=
                 "[[getLabelWithoutLearnMore('mouseControlledScrollingLabel')]]"
                 deep-link-focus-id$="[[Setting.kMouseScrollAcceleration]]">
      </cr-toggle>
    </div>
    <div class="settings-box">
      <div class="start" id="mouseScrollSpeedLabel" aria-hidden="true">
        $i18n{mouseScrollSpeed}
      </div>
      <settings-slider id="mouseScrollSpeedSlider"
                       pref="{{scrollSensitivityPref}}"
                       ticks="[[sensitivityValues_]]"
                       aria-describedby="mouseName"
                       label-aria="$i18n{mouseScrollSpeed}"
                       label-min="$i18n{pointerSlow}"
                       label-max="$i18n{pointerFast}"
                       disabled="[[mouse.settings.scrollAcceleration]]"
                       aria-disabled="[[mouse.settings.scrollAcceleration]]">
      </settings-slider>
    </div>
    <template is="dom-if" if="[[showCustomizeButtonRow(
        customizationRestriction,isPeripheralCustomizationEnabled_)]]">
      <cr-link-row id="customizeMouseButtons"
        class="hr bottom-divider" on-click="onCustomizeButtonsClick"
        aria-describedby="mouseName"
        label="$i18n{customizeMouseButtonsTitle}">
      </cr-link-row>
    </template>
    <template is="dom-if" if="[[isCompanionAppInstalled(mouse.appInfo)]]">
      <per-device-app-installed-row id="AppInstalledRow"
          app-info="[[mouse.appInfo]]">
      </per-device-app-installed-row>
    </template>
  </div>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'per-device-mouse-subsection' allow users to configure their per-device-mouse
 * subsection settings in system settings.
 */
const SettingsPerDeviceMouseSubsectionElementBase = DeepLinkingMixin(RouteObserverMixin(I18nMixin(PolymerElement)));
class SettingsPerDeviceMouseSubsectionElement extends SettingsPerDeviceMouseSubsectionElementBase {
    constructor() {
        super(...arguments);
        // DeepLinkingMixin override
        this.supportedSettingIds = new Set([
            Setting.kMouseSwapPrimaryButtons,
            Setting.kMouseReverseScrolling,
            Setting.kMouseAcceleration,
            Setting.kMouseScrollAcceleration,
            Setting.kMouseSpeed,
        ]);
        this.isInitialized = false;
        this.inputDeviceSettingsProvider = getInputDeviceSettingsProvider();
    }
    static get is() {
        return 'settings-per-device-mouse-subsection';
    }
    static get template() {
        return getTemplate$2R();
    }
    static get properties() {
        return {
            isPeripheralCustomizationEnabled_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('enablePeripheralCustomization');
                },
                readOnly: true,
            },
            primaryRightPref: {
                type: Object,
                value() {
                    return {
                        key: 'fakePrimaryRightPref',
                        type: chrome.settingsPrivate.PrefType.BOOLEAN,
                        value: false,
                    };
                },
            },
            accelerationPref: {
                type: Object,
                value() {
                    return {
                        key: 'fakeAccelerationPref',
                        type: chrome.settingsPrivate.PrefType.BOOLEAN,
                        value: true,
                    };
                },
            },
            sensitivityPref: {
                type: Object,
                value() {
                    return {
                        key: 'fakeSensitivityPref',
                        type: chrome.settingsPrivate.PrefType.NUMBER,
                        value: 3,
                    };
                },
            },
            scrollSensitivityPref: {
                type: Object,
                value() {
                    return {
                        key: 'fakeScrollSensitivityPref',
                        type: chrome.settingsPrivate.PrefType.NUMBER,
                        value: 3,
                    };
                },
            },
            reverseScrollValue: {
                type: Boolean,
                value: false,
            },
            scrollAccelerationValue: {
                type: Boolean,
                value: true,
            },
            swapPrimaryOptions_: {
                readOnly: true,
                type: Array,
                value() {
                    return [
                        {
                            value: false,
                            name: loadTimeData.getString('primaryMouseButtonLeft'),
                        },
                        {
                            value: true,
                            name: loadTimeData.getString('primaryMouseButtonRight'),
                        },
                    ];
                },
            },
            /**
             * TODO(michaelpg): settings-slider should optionally take a min and max
             * so we don't have to generate a simple range of natural numbers
             * ourselves. These values match the TouchpadSensitivity enum in
             * enums.xml.
             */
            sensitivityValues_: {
                type: Array,
                value: [1, 2, 3, 4, 5],
                readOnly: true,
            },
            mouse: {
                type: Object,
            },
            mousePolicies: {
                type: Object,
            },
            mouseIndex: {
                type: Number,
            },
            isLastDevice: {
                type: Boolean,
                reflectToAttribute: true,
            },
            customizationRestriction: {
                type: Object,
            },
            /**
               Used to track if the customize button row is clicked.
             */
            currentMouseChanged: {
                type: Boolean,
            },
            isWelcomeExperienceEnabled: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('enableWelcomeExperience');
                },
                readOnly: true,
            },
        };
    }
    static get observers() {
        return [
            'onSettingsChanged(primaryRightPref.value,' +
                'accelerationPref.value,' +
                'sensitivityPref.value,' +
                'scrollSensitivityPref.value,' +
                'reverseScrollValue,' +
                'scrollAccelerationValue)',
            'onPoliciesChanged(mousePolicies)',
            'updateSettingsToCurrentPrefs(mouse)',
        ];
    }
    currentRouteChanged(route) {
        // Avoid override currentMouseChanged when on the customization subpage.
        if (route === routes.CUSTOMIZE_MOUSE_BUTTONS) {
            return;
        }
        // Does not apply to this page.
        if (route !== routes.PER_DEVICE_MOUSE) {
            // Reset the boolean when on other pages.
            this.currentMouseChanged = false;
            return;
        }
        // If multiple mice are available, focus on the first one.
        if (this.mouseIndex === 0) {
            this.attemptDeepLink();
        }
        // Don't attempt to focus any item unless the last navigation was a
        // 'pop' (backwards) navigation.
        if (!Router.getInstance().lastRouteChangeWasPopstate()) {
            return;
        }
        else if (this.currentMouseChanged) {
            this.shadowRoot
                .querySelector('#customizeMouseButtons').focus();
        }
        this.currentMouseChanged = false;
    }
    showCustomizeButtonRow() {
        return (this.customizationRestriction !==
            CustomizationRestriction$1.kDisallowCustomizations) &&
            this.isPeripheralCustomizationEnabled_;
    }
    showSwapToggleButton() {
        return this.customizationRestriction ===
            CustomizationRestriction$1.kDisallowCustomizations &&
            this.isPeripheralCustomizationEnabled_;
    }
    showInstallAppRow() {
        return this.mouse.appInfo?.state === CompanionAppState$1.kAvailable;
    }
    onInstallCompanionAppButtonClicked() {
        window.open(this.mouse.appInfo?.actionLink);
    }
    updateSettingsToCurrentPrefs() {
        // `updateSettingsToCurrentPrefs` gets called when the `keyboard` object
        // gets updated. This subsection element can be reused multiple times so we
        // need to reset `isInitialized` so we do not make unneeded API calls.
        this.isInitialized = false;
        this.set('primaryRightPref.value', this.mouse.settings.swapRight);
        this.set('accelerationPref.value', this.mouse.settings.accelerationEnabled);
        this.set('sensitivityPref.value', this.mouse.settings.sensitivity);
        this.set('scrollSensitivityPref.value', this.mouse.settings.scrollSensitivity);
        this.reverseScrollValue = this.mouse.settings.reverseScrolling;
        this.scrollAccelerationValue = this.mouse.settings.scrollAcceleration;
        this.customizationRestriction = this.mouse.customizationRestriction;
        this.isInitialized = true;
    }
    onPoliciesChanged() {
        this.primaryRightPref = {
            ...this.primaryRightPref,
            ...getPrefPolicyFields$1(this.mousePolicies.swapRightPolicy),
        };
    }
    onLearnMoreLinkClicked_(event) {
        const path = event.composedPath();
        if (!Array.isArray(path) || !path.length) {
            return;
        }
        if (path[0].tagName === 'A') {
            // Do not toggle reverse scrolling if the contained link is clicked.
            event.stopPropagation();
        }
    }
    onMouseReverseScrollRowClicked_() {
        this.reverseScrollValue = !this.reverseScrollValue;
    }
    onMouseControlledScrollingRowClicked_() {
        this.scrollAccelerationValue = !this.scrollAccelerationValue;
    }
    onSettingsChanged() {
        if (!this.isInitialized) {
            return;
        }
        const newSettings = {
            ...this.mouse.settings,
            swapRight: this.primaryRightPref.value,
            accelerationEnabled: this.accelerationPref.value,
            sensitivity: this.sensitivityPref.value,
            scrollSensitivity: this.scrollSensitivityPref.value,
            reverseScrolling: this.reverseScrollValue,
            scrollAcceleration: this.scrollAccelerationValue,
        };
        if (settingsAreEqual(newSettings, this.mouse.settings)) {
            return;
        }
        this.mouse.settings = newSettings;
        this.inputDeviceSettingsProvider.setMouseSettings(this.mouse.id, this.mouse.settings);
    }
    getLabelWithoutLearnMore(stringName) {
        const tempEl = document.createElement('div');
        const localizedString = this.i18nAdvanced(stringName);
        tempEl.innerHTML = localizedString;
        const nodesToDelete = [];
        tempEl.childNodes.forEach((node) => {
            // Remove elements with the <a> tag
            if (node.nodeType === Node.ELEMENT_NODE && node.nodeName === 'A') {
                nodesToDelete.push(node);
                return;
            }
        });
        nodesToDelete.forEach((node) => {
            tempEl.removeChild(node);
        });
        return tempEl.innerHTML;
    }
    getCursorSpeedString() {
        return this.i18nAdvanced('cursorSpeed');
    }
    getCursorAccelerationString() {
        return this.i18nAdvanced('cursorAccelerationLabel');
    }
    onCustomizeButtonsClick() {
        const url = new URLSearchParams(`mouseId=${encodeURIComponent(this.mouse.id)}`);
        Router.getInstance().navigateTo(routes.CUSTOMIZE_MOUSE_BUTTONS, 
        /* dynamicParams= */ url, /* removeSearch= */ true);
        this.currentMouseChanged = true;
    }
    isCompanionAppInstalled() {
        return this.mouse.appInfo?.state === CompanionAppState$1.kInstalled;
    }
    onCompanionAppRowClick() {
        assert(this.mouse.appInfo);
        this.inputDeviceSettingsProvider.launchCompanionApp(this.mouse.appInfo.packageId || '');
    }
}
customElements.define(SettingsPerDeviceMouseSubsectionElement.is, SettingsPerDeviceMouseSubsectionElement);

function getTemplate$2Q() {
    return html `<!--_html_template_start_--><template is="dom-repeat" items="[[mice]]"
    as="mouse" index-as="index" restamp>
  <settings-per-device-mouse-subsection mouse="[[mouse]]"
      mouse-policies="[[mousePolicies]]"
      mouse-index="[[index]]"
      is-last-device="[[computeIsLastDevice(index, mice.length)]]">
  </settings-per-device-mouse-subsection>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'mouse-settings' allow users to configure their mouse settings in system
 * settings.
 */
const SettingsPerDeviceMouseElementBase = RouteObserverMixin(I18nMixin(PolymerElement));
class SettingsPerDeviceMouseElement extends SettingsPerDeviceMouseElementBase {
    static get is() {
        return 'settings-per-device-mouse';
    }
    static get template() {
        return getTemplate$2Q();
    }
    static get properties() {
        return {
            mice: {
                type: Array,
                observer: 'onMouseListUpdated',
            },
            mousePolicies: {
                type: Object,
            },
        };
    }
    currentRouteChanged(route) {
        // Does not apply to this page.
        if (route !== routes.PER_DEVICE_MOUSE) {
            return;
        }
    }
    onMouseListUpdated(newMouseList, oldMouseList) {
        if (!oldMouseList) {
            return;
        }
        const { msgId, deviceNames } = getDeviceStateChangesToAnnounce(newMouseList, oldMouseList);
        for (const deviceName of deviceNames) {
            getInstance().announce(this.i18n(msgId, deviceName));
        }
    }
    computeIsLastDevice(index) {
        return index === this.mice.length - 1;
    }
}
customElements.define(SettingsPerDeviceMouseElement.is, SettingsPerDeviceMouseElement);

function getTemplate$2P() {
    return html `<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">.settings-box:first-of-type{border-top:none}</style>
<div id="pointingStick">
  <per-device-subsection-header
      id="subsectionHeader"
      device-key="[[pointingStick.deviceKey]]"
      name="[[getPointingStickName(pointingStick.name)]]"
      icon="os-settings:device-pointing-stick">
  </per-device-subsection-header>
  <div class="subsection">
    <div class="settings-box">
      <div class="start settings-box-text"
          id="pointingStickSwapButtonLabel">
        $i18n{pointingStickPrimaryButton}
      </div>
      <settings-dropdown-menu id="pointingStickSwapButtonDropdown"
          aria-describedby="pointingStickName"
          label="$i18n{pointingStickPrimaryButton}"
          pref="{{primaryRightPref}}"
          menu-options="[[swapPrimaryOptions]]"
          deep-link-focus-id$=
              "[[Setting.kPointingStickSwapPrimaryButtons]]">
      </settings-dropdown-menu>
      </div>
      <settings-toggle-button id="pointingStickAcceleration"
          aria-describedby="pointingStickName"
          class="hr"
          pref="{{accelerationPref}}"
          label="$i18n{pointingStickAccelerationLabel}"
          deep-link-focus-id$="[[Setting.kPointingStickAcceleration]]">
      </settings-toggle-button>
      <div class="settings-box bottom-divider">
      <div class="start" id="pointingStickSpeedLabel" aria-hidden="true">
        $i18n{pointingStickSpeed}
      </div>
      <settings-slider id="pointingStickSpeedSlider"
          pref="{{sensitivityPref}}"
          ticks="[[sensitivityValues]]"
          aria-describedby="pointingStickName"
          label-aria="$i18n{pointingStickSpeed}"
          label-min="$i18n{pointerSlow}"
          label-max="$i18n{pointerFast}"
          deep-link-focus-id$="[[Setting.kPointingStickSpeed]]">
      </settings-slider>
    </div>
  </div>
</div><!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'per-device-pointing-stick-subsection' allow users to configure their
 * per-device-pointing-stick subsection settings in system settings.
 */
const SettingsPerDevicePointingStickSubsectionElementBase = DeepLinkingMixin(RouteObserverMixin(I18nMixin(PolymerElement)));
class SettingsPerDevicePointingStickSubsectionElement extends SettingsPerDevicePointingStickSubsectionElementBase {
    constructor() {
        super(...arguments);
        // DeepLinkingMixin override
        this.supportedSettingIds = new Set([
            Setting.kPointingStickAcceleration,
            Setting.kPointingStickSpeed,
            Setting.kPointingStickSwapPrimaryButtons,
        ]);
        this.isInitialized = false;
        this.inputDeviceSettingsProvider = getInputDeviceSettingsProvider();
    }
    static get is() {
        return 'settings-per-device-pointing-stick-subsection';
    }
    static get template() {
        return getTemplate$2P();
    }
    static get properties() {
        return {
            primaryRightPref: {
                type: Object,
                value() {
                    return {
                        key: 'fakePrimaryRightPref',
                        type: chrome.settingsPrivate.PrefType.BOOLEAN,
                        value: false,
                    };
                },
            },
            accelerationPref: {
                type: Object,
                value() {
                    return {
                        key: 'fakeAccelerationPref',
                        type: chrome.settingsPrivate.PrefType.BOOLEAN,
                        value: true,
                    };
                },
            },
            sensitivityPref: {
                type: Object,
                value() {
                    return {
                        key: 'fakeSensitivityPref',
                        type: chrome.settingsPrivate.PrefType.NUMBER,
                        value: 3,
                    };
                },
            },
            swapPrimaryOptions: {
                readOnly: true,
                type: Array,
                value() {
                    return [
                        {
                            value: false,
                            name: loadTimeData.getString('primaryMouseButtonLeft'),
                        },
                        {
                            value: true,
                            name: loadTimeData.getString('primaryMouseButtonRight'),
                        },
                    ];
                },
            },
            /**
             * TODO(michaelpg): settings-slider should optionally take a min and max
             * so we don't have to generate a simple range of natural numbers
             * ourselves. These values match the TouchpadSensitivity enum in
             * enums.xml.
             */
            sensitivityValues: {
                type: Array,
                value: [1, 2, 3, 4, 5],
                readOnly: true,
            },
            pointingStick: { type: Object },
            pointingStickIndex: {
                type: Number,
            },
            isLastDevice: {
                type: Boolean,
                reflectToAttribute: true,
            },
        };
    }
    static get observers() {
        return [
            'onSettingsChanged(primaryRightPref.value,' +
                'accelerationPref.value,' +
                'sensitivityPref.value)',
            'updateSettingsToCurrentPrefs(pointingStick)',
        ];
    }
    currentRouteChanged(route) {
        // Does not apply to this page.
        if (route !== routes.PER_DEVICE_POINTING_STICK) {
            return;
        }
        // If multiple pointing sticks are available, focus on the first one.
        if (this.pointingStickIndex === 0) {
            this.attemptDeepLink();
        }
    }
    updateSettingsToCurrentPrefs() {
        // `updateSettingsToCurrentPrefs` gets called when the `keyboard` object
        // gets updated. This subsection element can be reused multiple times so we
        // need to reset `isInitialized` so we do not make unneeded API calls.
        this.isInitialized = false;
        this.set('primaryRightPref.value', this.pointingStick.settings.swapRight);
        this.set('accelerationPref.value', this.pointingStick.settings.accelerationEnabled);
        this.set('sensitivityPref.value', this.pointingStick.settings.sensitivity);
        this.isInitialized = true;
    }
    onLearnMoreLinkClicked_(event) {
        const path = event.composedPath();
        if (!Array.isArray(path) || !path.length) {
            return;
        }
        if (path[0].tagName === 'A') {
            // Do not toggle reverse scrolling if the contained link is clicked.
            event.stopPropagation();
        }
    }
    onSettingsChanged() {
        if (!this.isInitialized) {
            return;
        }
        const newSettings = {
            ...this.pointingStick.settings,
            swapRight: this.primaryRightPref.value,
            accelerationEnabled: this.accelerationPref.value,
            sensitivity: this.sensitivityPref.value,
        };
        if (settingsAreEqual(newSettings, this.pointingStick.settings)) {
            return;
        }
        this.pointingStick.settings = newSettings;
        this.inputDeviceSettingsProvider.setPointingStickSettings(this.pointingStick.id, this.pointingStick.settings);
    }
    getPointingStickName() {
        return this.pointingStick.isExternal ?
            this.pointingStick.name :
            this.i18n('builtInPointingStickName');
    }
}
customElements.define(SettingsPerDevicePointingStickSubsectionElement.is, SettingsPerDevicePointingStickSubsectionElement);

function getTemplate$2O() {
    return html `<!--_html_template_start_--><template is="dom-repeat" items="[[pointingSticks]]"
    as="pointingStick" index-as="index" restamp>
  <settings-per-device-pointing-stick-subsection
      pointing-stick="[[pointingStick]]"
      pointing-stick-index="[[index]]"
      is-last-device="[[computeIsLastDevice(index, pointingSticks.length)]]">
  </settings-per-device-pointing-stick-subsection>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'pointing-stick-settings' allow users to configure their pointing stick
 * settings in system settings.
 */
const SettingsPerDevicePointingStickElementBase = RouteObserverMixin(I18nMixin(PolymerElement));
class SettingsPerDevicePointingStickElement extends SettingsPerDevicePointingStickElementBase {
    static get is() {
        return 'settings-per-device-pointing-stick';
    }
    static get template() {
        return getTemplate$2O();
    }
    static get properties() {
        return {
            pointingSticks: {
                type: Array,
                observer: 'onPointingStickListUpdated',
            },
        };
    }
    currentRouteChanged(route) {
        // Does not apply to this page.
        if (route !== routes.PER_DEVICE_POINTING_STICK) {
            return;
        }
    }
    onPointingStickListUpdated(newPointingStickList, oldPointingStickList) {
        if (!oldPointingStickList) {
            return;
        }
        const { msgId, deviceNames } = getDeviceStateChangesToAnnounce(newPointingStickList, oldPointingStickList);
        for (const deviceName of deviceNames) {
            getInstance().announce(this.i18n(msgId, deviceName));
        }
    }
    computeIsLastDevice(index) {
        return index === this.pointingSticks.length - 1;
    }
}
customElements.define(SettingsPerDevicePointingStickElement.is, SettingsPerDevicePointingStickElement);

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Enumeration of the different disabled modes of the internal touchpad.
// Ensure this enum stays in sync with the enum in
// ash/public/cpp/accessibility_controller_enums.h
var DisableTouchpadMode;
(function (DisableTouchpadMode) {
    DisableTouchpadMode[DisableTouchpadMode["NEVER"] = 0] = "NEVER";
    DisableTouchpadMode[DisableTouchpadMode["ALWAYS"] = 1] = "ALWAYS";
    DisableTouchpadMode[DisableTouchpadMode["ON_MOUSE_CONNECTED"] = 2] = "ON_MOUSE_CONNECTED";
})(DisableTouchpadMode || (DisableTouchpadMode = {}));

function getTemplate$2N() {
    return html `<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">cr-link-row{padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-padding)}</style>
<div id="touchpad">
  <template is="dom-if" if="[[isBuiltInTrackpadDisabled_(
        prefs.settings.a11y.disable_trackpad_mode.value, mice
      )]]" restamp>
    <div id="disabledTouchpadHeader">
      <h2 aria-hidden="true" class="subsection-header bottom-divider"
          id="deviceName">
        [[getTouchpadName(touchpad.name)]]
      </h2>
      <cr-link-row id="cursorTouchpadSubpageButton" class="hr"
          label="$i18n{builtInTouchpadDisabled}"
          on-click="onDisabledTouchpadSettingsClick_"
          role-description="$i18n{subpageArrowRoleDescription}" embedded>
      </cr-link-row>
    </div>
  </template>
  <template is="dom-if" if="[[!isBuiltInTrackpadDisabled_(
        prefs.settings.a11y.disable_trackpad_mode.value, mice
      )]]" restamp>
    <div id="touchpadSettings">
      <per-device-subsection-header
          device-key="[[touchpad.deviceKey]]"
          name="[[getTouchpadName(touchpad.name)]]"
          battery-info="[[touchpad.batteryInfo]]"
          icon="os-settings:device-touchpad">
      </per-device-subsection-header>
      <div class="subsection">
        <template is="dom-if" if="[[showInstallAppRow(touchpad.appInfo)]]">
          <per-device-install-row app-info="[[touchpad.appInfo]]">
          </per-device-install-row>
        </template>
        <settings-toggle-button id="enableTapToClick"
            pref="{{enableTapToClickPref}}"
            label="$i18n{touchpadTapToClickEnabledLabel}"
            sub-label="$i18n{touchpadTapToClickDescription}"
            aria-describedby="touchpadName"
            deep-link-focus-id$="[[Setting.kTouchpadTapToClick]]">
        </settings-toggle-button>
        <template is="dom-if"
            if="[[isAltClickAndSixPackCustomizationEnabled]]">
          <div id="simulateRightClickContainer" class="settings-box">
            <div id="simulateRightClickLabel" aria-hidden="true"
                class="start settings-box-text">
            $i18n{touchpadSimulateRightClickLabel}
            </div>
            <settings-dropdown-menu id="simulateRightClickDropdown"
                label="$i18n{touchpadSimulateRightClickLabel}"
                pref="{{simulateRightClickPref}}"
                aria-describedby="touchpadName"
                menu-options="[[simulateRightClickOptions_]]"
                deep-link-focus-id$="[[Setting.kTouchpadSimulateRightClick]]">
            </settings-dropdown-menu>
          </div>
        </template>
        <settings-toggle-button id="enableTapDragging"
            class="hr"
            pref="{{enableTapDraggingPref}}"
            label="$i18n{tapDraggingLabel}"
            sub-label="$i18n{tapDraggingDescription}"
            aria-describedby="touchpadName"
            deep-link-focus-id$="[[Setting.kTouchpadTapDragging]]">
        </settings-toggle-button>
        <settings-toggle-button id="touchpadAcceleration"
            class="hr"
            pref="{{accelerationPref}}"
            label="$i18n{touchpadAccelerationLabel}"
            sub-label="$i18n{touchpadAccelerationDescription}"
            aria-describedby="touchpadName"
            deep-link-focus-id$="[[Setting.kTouchpadAcceleration]]">
        </settings-toggle-button>
        <div class="settings-box">
          <div class="start" id="touchpadSpeedLabel" aria-hidden="true">
          $i18n{touchpadSpeed}
          </div>
          <settings-slider id="touchpadSensitivity"
              pref="{{sensitivityPref}}"
              ticks="[[sensitivityValues_]]"
              aria-describedby="touchpadName"
              label-aria="$i18n{touchpadSpeed}"
              label-min="$i18n{pointerSlow}"
              label-max="$i18n{pointerFast}"
              deep-link-focus-id$="[[Setting.kTouchpadSpeed]]">
          </settings-slider>
        </div>
        <template is="dom-if" if="[[touchpad.isHaptic]]" restamp>
          <div class="settings-box">
            <div class="start" id="touchpadHapticClickSensitivityLabel"
                aria-hidden="true">
            $i18n{touchpadHapticClickSensitivityLabel}
            </div>
            <settings-slider id="touchpadHapticClickSensitivity"
                pref="{{hapticClickSensitivityPref}}"
                ticks="[[hapticClickSensitivityValues_]]"
                aria-describedby="touchpadName"
                label-aria="$i18n{touchpadHapticClickSensitivityLabel}"
                label-min="$i18n{touchpadHapticLightClickLabel}"
                label-max="$i18n{touchpadHapticFirmClickLabel}"
                deep-link-focus-id$=
                "[[Setting.kTouchpadHapticClickSensitivity]]">
            </settings-slider>
          </div>
          <div class="settings-box two-line" id="touchpadHapticFeedbackRow"
              on-click="onTouchpadHapticFeedbackRowClicked_" actionable-row>
            <div class="start settings-box-text">
              <div>$i18n{touchpadHapticFeedbackTitle}</div>
              <div class="secondary">
                <localized-link
                    aria-describedby="touchpadName"
                    on-click="onLearnMoreLinkClicked_"
                    id="touchpadHapticFeedbackSecondary"
                    localized-string=
                        "$i18n{touchpadHapticFeedbackSecondaryText}"
                    link-url="$i18n{hapticFeedbackLearnMoreLink}">
                </localized-link>
              </div>
            </div>
            <cr-toggle id="touchpadHapticFeedbackToggle"
                checked="{{hapticFeedbackValue}}"
                aria-describedby="touchpadName"
                aria-label=
                    "[[getLabelWithoutLearnMore(
                      'touchpadHapticFeedbackTitle'
                    )]]"
                deep-link-focus-id$="[[Setting.kTouchpadHapticFeedback]]">
            </cr-toggle>
          </div>
        </template>
        <div class="settings-box bottom-divider" id="reverseScrollRow"
            on-click="onTouchpadReverseScrollRowClicked_" actionable-row>
          <div class="start settings-box-text">
            <localized-link
                aria-describedby="touchpadName"
                on-click="onLearnMoreLinkClicked_"
                id="enableReverseScrollingLabel"
                localized-string="$i18n{touchpadScrollLabel}"
                link-url="$i18n{naturalScrollLearnMoreLink}">
            </localized-link>
            <div class="secondary">
              $i18n{touchpadScrollDescription}
            </div>
          </div>
          <cr-toggle id="enableReverseScrollingToggle"
              checked="{{reverseScrollValue}}"
              aria-describedby="touchpadName"
              aria-label=
                  "[[getLabelWithoutLearnMore('touchpadScrollLabel')]]"
              deep-link-focus-id$="[[Setting.kTouchpadReverseScrolling]]">
          </cr-toggle>
          <template is="dom-if" if="[[isCompanionAppInstalled(
                touchpad.appInfo
              )]]">
            <per-device-app-installed-row app-info="[[touchpad.appInfo]]">
            </per-device-app-installed-row>
          </template>
        </div>
      </div>
    </div>
  </template>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'per-device-touchpad-subsection' allow users to configure their
 * per-device-touchpad subsection settings in system settings.
 */
const SettingsPerDeviceTouchpadSubsectionElementBase = RouteObserverMixin(DeepLinkingMixin(RouteObserverMixin(PrefsMixin(I18nMixin(PolymerElement)))));
class SettingsPerDeviceTouchpadSubsectionElement extends SettingsPerDeviceTouchpadSubsectionElementBase {
    static get is() {
        return 'settings-per-device-touchpad-subsection';
    }
    static get template() {
        return getTemplate$2N();
    }
    static get properties() {
        return {
            enableTapToClickPref: {
                type: Object,
                value() {
                    return {
                        key: 'fakeEnableTapToClickPref',
                        type: chrome.settingsPrivate.PrefType.BOOLEAN,
                        value: true,
                    };
                },
            },
            enableTapDraggingPref: {
                type: Object,
                value() {
                    return {
                        key: 'fakeEnableTapDraggingPref',
                        type: chrome.settingsPrivate.PrefType.BOOLEAN,
                        value: false,
                    };
                },
            },
            accelerationPref: {
                type: Object,
                value() {
                    return {
                        key: 'fakeAccelerationPref',
                        type: chrome.settingsPrivate.PrefType.BOOLEAN,
                        value: true,
                    };
                },
            },
            sensitivityPref: {
                type: Object,
                value() {
                    return {
                        key: 'fakeSensitivityPref',
                        type: chrome.settingsPrivate.PrefType.NUMBER,
                        value: 3,
                    };
                },
            },
            hapticClickSensitivityPref: {
                type: Object,
                value() {
                    return {
                        key: 'fakeHapticClickSensitivityPref',
                        type: chrome.settingsPrivate.PrefType.NUMBER,
                        value: 3,
                    };
                },
            },
            simulateRightClickPref: {
                type: Object,
                value() {
                    return {
                        key: 'fakeSimulateRightClickPref',
                        type: chrome.settingsPrivate.PrefType.NUMBER,
                        value: SimulateRightClickModifier$1.kNone,
                    };
                },
            },
            simulateRightClickOptions_: {
                readOnly: true,
                type: Array,
                value() {
                    return [
                        {
                            value: SimulateRightClickModifier$1.kNone,
                            name: loadTimeData.getString('touchpadSimulateRightClickOptionDisabled'),
                        },
                        {
                            value: SimulateRightClickModifier$1.kSearch,
                            name: loadTimeData.getString('touchpadSimulateRightClickOptionSearch'),
                        },
                        {
                            value: SimulateRightClickModifier$1.kAlt,
                            name: loadTimeData.getString('touchpadSimulateRightClickOptionAlt'),
                        },
                    ];
                },
            },
            /**
             * TODO(michaelpg): settings-slider should optionally take a min and max
             * so we don't have to generate a simple range of natural numbers
             * ourselves. These values match the TouchpadSensitivity enum in
             * enums.xml.
             */
            sensitivityValues_: {
                type: Array,
                value: [1, 2, 3, 4, 5],
                readOnly: true,
            },
            /**
             * The click sensitivity values from prefs are [1,3,5] but ChromeVox needs
             * to announce them as [1,2,3].
             */
            hapticClickSensitivityValues_: {
                type: Array,
                value() {
                    return [
                        { value: 1, ariaValue: 1 },
                        { value: 3, ariaValue: 2 },
                        { value: 5, ariaValue: 3 },
                    ];
                },
                readOnly: true,
            },
            reverseScrollValue: {
                type: Boolean,
                value: false,
            },
            hapticFeedbackValue: {
                type: Boolean,
                value: true,
            },
            touchpad: { type: Object },
            touchpadIndex: {
                type: Number,
            },
            isLastDevice: {
                type: Boolean,
                reflectToAttribute: true,
            },
            isAltClickAndSixPackCustomizationEnabled: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('enableAltClickAndSixPackCustomization');
                },
                readOnly: true,
            },
            mice: {
                type: Array,
            },
        };
    }
    static get observers() {
        return [
            'onSettingsChanged(enableTapToClickPref.value,' +
                'enableTapDraggingPref.value,' +
                'accelerationPref.value,' +
                'sensitivityPref.value,' +
                'hapticClickSensitivityPref.value,' +
                'simulateRightClickPref.value,' +
                'reverseScrollValue,' +
                'hapticFeedbackValue)',
            'updateSettingsToCurrentPrefs(touchpad)',
        ];
    }
    currentRouteChanged(route) {
        // Does not apply to this page.
        if (route !== routes.PER_DEVICE_TOUCHPAD) {
            return;
        }
        // If multiple touchpads are available, focus on the first one.
        if (this.touchpadIndex === 0) {
            this.attemptDeepLink();
        }
    }
    constructor() {
        super();
        // DeepLinkingMixin override
        this.supportedSettingIds = new Set([
            Setting.kTouchpadTapToClick,
            Setting.kTouchpadTapDragging,
            Setting.kTouchpadReverseScrolling,
            Setting.kTouchpadAcceleration,
            Setting.kTouchpadScrollAcceleration,
            Setting.kTouchpadSpeed,
            Setting.kTouchpadHapticFeedback,
            Setting.kTouchpadHapticClickSensitivity,
            Setting.kTouchpadSimulateRightClick,
        ]);
        this.isInitialized = false;
        this.inputDeviceSettingsProvider = getInputDeviceSettingsProvider();
        this.observeMouseSettings();
    }
    showInstallAppRow() {
        return this.touchpad.appInfo?.state === CompanionAppState$1.kAvailable;
    }
    updateSettingsToCurrentPrefs() {
        // `updateSettingsToCurrentPrefs` gets called when the `keyboard` object
        // gets updated. This subsection element can be reused multiple times so we
        // need to reset `isInitialized` so we do not make unneeded API calls.
        this.isInitialized = false;
        this.set('enableTapToClickPref.value', this.touchpad.settings.tapToClickEnabled);
        this.set('simulateRightClickPref.value', this.touchpad.settings.simulateRightClick);
        this.set('enableTapDraggingPref.value', this.touchpad.settings.tapDraggingEnabled);
        this.set('accelerationPref.value', this.touchpad.settings.accelerationEnabled);
        this.set('sensitivityPref.value', this.touchpad.settings.sensitivity);
        this.set('hapticClickSensitivityPref.value', this.touchpad.settings.hapticSensitivity);
        this.reverseScrollValue = this.touchpad.settings.reverseScrolling;
        this.hapticFeedbackValue = this.touchpad.settings.hapticEnabled;
        this.isInitialized = true;
    }
    onLearnMoreLinkClicked_(event) {
        const path = event.composedPath();
        if (!Array.isArray(path) || !path.length) {
            return;
        }
        if (path[0].tagName === 'A') {
            // Do not toggle reverse scrolling if the contained link is clicked.
            event.stopPropagation();
        }
    }
    onTouchpadReverseScrollRowClicked_() {
        this.reverseScrollValue = !this.reverseScrollValue;
    }
    onTouchpadHapticFeedbackRowClicked_() {
        this.hapticFeedbackValue = !this.hapticFeedbackValue;
    }
    onMouseListUpdated(mice) {
        this.mice = mice;
    }
    onMousePoliciesUpdated(_mousePolicies) { }
    observeMouseSettings() {
        if (this.inputDeviceSettingsProvider instanceof
            FakeInputDeviceSettingsProvider) {
            this.inputDeviceSettingsProvider.observeMouseSettings(this);
            return;
        }
        this.mouseSettingsObserverReceiver =
            new MouseSettingsObserverReceiver(this);
        this.inputDeviceSettingsProvider.observeMouseSettings(this.mouseSettingsObserverReceiver.$.bindNewPipeAndPassRemote());
    }
    onSettingsChanged() {
        if (!this.isInitialized) {
            return;
        }
        const newSettings = {
            ...this.touchpad.settings,
            tapToClickEnabled: this.enableTapToClickPref.value,
            tapDraggingEnabled: this.enableTapDraggingPref.value,
            accelerationEnabled: this.accelerationPref.value,
            sensitivity: this.sensitivityPref.value,
            hapticSensitivity: this.hapticClickSensitivityPref.value,
            simulateRightClick: this.simulateRightClickPref.value,
            reverseScrolling: this.reverseScrollValue,
            hapticEnabled: this.hapticFeedbackValue,
        };
        if (settingsAreEqual(newSettings, this.touchpad.settings)) {
            return;
        }
        this.touchpad.settings = newSettings;
        this.inputDeviceSettingsProvider.setTouchpadSettings(this.touchpad.id, this.touchpad.settings);
    }
    getTouchpadName() {
        return this.touchpad.isExternal ? this.touchpad.name :
            this.i18n('builtInTouchpadName');
    }
    getLabelWithoutLearnMore(stringName) {
        const tempEl = document.createElement('div');
        const localizedString = this.i18nAdvanced(stringName);
        tempEl.innerHTML = localizedString;
        const nodesToDelete = [];
        tempEl.childNodes.forEach((node) => {
            // Remove elements with the <a> tag
            if (node.nodeType === Node.ELEMENT_NODE && node.nodeName === 'A') {
                nodesToDelete.push(node);
                return;
            }
        });
        nodesToDelete.forEach((node) => {
            tempEl.removeChild(node);
        });
        return tempEl.innerHTML;
    }
    isCompanionAppInstalled() {
        return this.touchpad.appInfo?.state === CompanionAppState$1.kInstalled;
    }
    isBuiltInTrackpadDisabled_(trackpadMode) {
        return !this.touchpad.isExternal &&
            (trackpadMode === DisableTouchpadMode.ALWAYS ||
                (trackpadMode === DisableTouchpadMode.ON_MOUSE_CONNECTED &&
                    this.isMouseConnected_()));
    }
    onDisabledTouchpadSettingsClick_() {
        const urlParams = new URLSearchParams({ settingId: Setting.kDisableTouchpad.toString() });
        Router.getInstance().navigateTo(routes.A11Y_CURSOR_AND_TOUCHPAD, 
        /* dynamicParams */ urlParams);
    }
    isMouseConnected_() {
        return this.mice && this.mice.length !== 0;
    }
}
customElements.define(SettingsPerDeviceTouchpadSubsectionElement.is, SettingsPerDeviceTouchpadSubsectionElement);

function getTemplate$2M() {
    return html `<!--_html_template_start_--><template is="dom-repeat" items="[[touchpads]]"
    as="touchpad" index-as="index" restamp>
  <settings-per-device-touchpad-subsection
      touchpad="[[touchpad]]" touchpad-index="[[index]]"
      is-last-device="[[computeIsLastDevice(index, touchpads.length)]]"
      prefs="{{prefs}}">
  </settings-per-device-touchpad-subsection>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'touchpad-settings' allow users to configure their touchpad settings in
 * system settings.
 */
const SettingsPerDeviceTouchpadElementBase = PrefsMixin(RouteObserverMixin(I18nMixin(PolymerElement)));
class SettingsPerDeviceTouchpadElement extends SettingsPerDeviceTouchpadElementBase {
    static get is() {
        return 'settings-per-device-touchpad';
    }
    static get template() {
        return getTemplate$2M();
    }
    static get properties() {
        return {
            touchpads: {
                type: Array,
                observer: 'onTouchpadListUpdated',
            },
        };
    }
    currentRouteChanged(route) {
        // Does not apply to this page.
        if (route !== routes.PER_DEVICE_TOUCHPAD) {
            return;
        }
    }
    onTouchpadListUpdated(newTouchpadList, oldTouchpadList) {
        if (!oldTouchpadList) {
            return;
        }
        const { msgId, deviceNames } = getDeviceStateChangesToAnnounce(newTouchpadList, oldTouchpadList);
        for (const deviceName of deviceNames) {
            getInstance().announce(this.i18n(msgId, deviceName));
        }
    }
    computeIsLastDevice(index) {
        return index === this.touchpads.length - 1;
    }
}
customElements.define(SettingsPerDeviceTouchpadElement.is, SettingsPerDeviceTouchpadElement);

function getTemplate$2L() {
    return html `<!--_html_template_start_--><style include="settings-shared">h2{padding-inline-start:var(--cr-section-padding)}.subsection{padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-indent-padding)}.subsection>settings-toggle-button,.subsection>.settings-box{padding-inline-end:0;padding-inline-start:0}#enableReverseScrollingToggle{border-top:none;padding-inline-end:0}</style>
<div id="mouse" hidden$="[[!hasMouse]]">
  <!-- Subsection title only appears if multiple sections are visible. -->
  <h2 hidden$="[[!showHeadings_]]">$i18n{mouseTitle}</h2>
  <div class$="[[subsectionClass_]]">
    <div class="settings-box">
      <div class="start settings-box-text" id="mouseSwapButtonLabel">
        $i18n{mouseSwapButtonsLabel}
      </div>
      <settings-dropdown-menu id="mouseSwapButtonDropdown"
          aria-labelledby="mouseSwapButtonLabel"
          pref="{{prefs.settings.mouse.primary_right}}"
          menu-options="[[swapPrimaryOptions_]]"
          deep-link-focus-id$="[[Setting.kMouseSwapPrimaryButtons]]">
      </settings-dropdown-menu>
    </div>
    <settings-toggle-button id="mouseAcceleration"
        class="hr"
        pref="{{prefs.settings.mouse.acceleration}}"
        label="[[getCursorAccelerationString()]]"
        deep-link-focus-id$="[[Setting.kMouseAcceleration]]">
    </settings-toggle-button>
    <div class="settings-box">
      <div class="start" id="mouseSpeedLabel" aria-hidden="true">
        [[getCursorSpeedString()]]
      </div>
      <settings-slider id="mouseSpeedSlider"
          pref="{{prefs.settings.mouse.sensitivity2}}"
          ticks="[[sensitivityValues_]]"
          label-aria="[[getCursorSpeedString()]]"
          label-min="$i18n{pointerSlow}"
          label-max="$i18n{pointerFast}"
          deep-link-focus-id$="[[Setting.kMouseSpeed]]">
      </settings-slider>
    </div>
    <div class="settings-box" id="mouseReverseScrollRow"
         on-click="onMouseReverseScrollRowClicked_">
      <div class="start settings-box-text">
        <localized-link
            on-click="onLearnMoreLinkClicked_"
            id="enableMouseReverseScrollingLabel"
            localized-string="$i18n{mouseReverseScrollLabel}"
            link-url="$i18n{naturalScrollLearnMoreLink}">
        </localized-link>
      </div>
      <cr-toggle id="mouseReverseScroll"
          checked="{{prefs.settings.mouse.reverse_scroll.value}}"
          aria-labelledby="enableMouseReverseScrollingLabel"
          deep-link-focus-id$="[[Setting.kMouseReverseScrolling]]">
      </cr-toggle>
    </div>
  </div>
</div>
<div id="pointingStick" hidden$="[[!hasPointingStick]]">
  <!-- Subsection title only appears if multiple sections are visible. -->
  <h2 hidden$="[[!showHeadings_]]">$i18n{pointingStickTitle}</h2>
  <div class$="[[subsectionClass_]]">
    <div class="settings-box">
      <div class="start settings-box-text"
          id="pointingStickSwapButtonLabel">
        $i18n{pointingStickPrimaryButton}
      </div>
      <settings-dropdown-menu id="pointingStickSwapButtonDropdown"
          aria-labelledby="pointingStickSwapButtonLabel"
          pref="{{prefs.settings.pointing_stick.primary_right}}"
          menu-options="[[swapPrimaryOptions_]]"
          deep-link-focus-id$=
              "[[Setting.kPointingStickSwapPrimaryButtons]]">
      </settings-dropdown-menu>
    </div>
    <settings-toggle-button id="pointingStickAcceleration"
        class="hr"
        pref="{{prefs.settings.pointing_stick.acceleration}}"
        label="$i18n{pointingStickAccelerationLabel}"
        deep-link-focus-id$="[[Setting.kPointingStickAcceleration]]">
    </settings-toggle-button>
    <div class="settings-box">
      <div class="start" id="pointingStickSpeedLabel" aria-hidden="true">
        $i18n{pointingStickSpeed}
      </div>
      <settings-slider id="pointingStickSpeedSlider"
          pref="{{prefs.settings.pointing_stick.sensitivity}}"
          ticks="[[sensitivityValues_]]"
          label-aria="$i18n{pointingStickSpeed}"
          label-min="$i18n{pointerSlow}"
          label-max="$i18n{pointerFast}"
          deep-link-focus-id$="[[Setting.kPointingStickSpeed]]">
      </settings-slider>
    </div>
  </div>
</div>
<div id="touchpad" hidden$="[[!hasTouchpad]]">
  <!-- Subsection title only appears if multiple sections are visible. -->
  <h2 hidden$="[[!showHeadings_]]">$i18n{touchpadTitle}</h2>
  <div class$="[[subsectionClass_]]">
    <settings-toggle-button id="enableTapToClick"
        pref="{{prefs.settings.touchpad.enable_tap_to_click}}"
        label="$i18n{touchpadTapToClickEnabledLabel}"
        deep-link-focus-id$="[[Setting.kTouchpadTapToClick]]">
    </settings-toggle-button>
    <settings-toggle-button id="enableTapDragging"
        class="hr"
        pref="{{prefs.settings.touchpad.enable_tap_dragging}}"
        label="$i18n{tapDraggingLabel}"
        deep-link-focus-id$="[[Setting.kTouchpadTapDragging]]">
    </settings-toggle-button>
    <settings-toggle-button id="touchpadAcceleration"
        class="hr"
        pref="{{prefs.settings.touchpad.acceleration}}"
        label="$i18n{touchpadAccelerationLabel}"
        deep-link-focus-id$="[[Setting.kTouchpadAcceleration]]">
    </settings-toggle-button>
    <div class="settings-box">
      <div class="start" id="touchpadSpeedLabel" aria-hidden="true">
        $i18n{touchpadSpeed}
      </div>
        <settings-slider id="touchpadSensitivity"
            pref="{{prefs.settings.touchpad.sensitivity2}}"
            ticks="[[sensitivityValues_]]"
            label-aria="$i18n{touchpadSpeed}"
            label-min="$i18n{pointerSlow}"
            label-max="$i18n{pointerFast}"
            deep-link-focus-id$="[[Setting.kTouchpadSpeed]]">
        </settings-slider>
    </div>
    <template is="dom-if" if="[[hasHapticTouchpad]]">
      <div class="settings-box">
        <div class="start" id="touchpadHapticClickSensitivityLabel"
            aria-hidden="true">
          $i18n{touchpadHapticClickSensitivityLabel}
        </div>
        <settings-slider id="touchpadHapticClickSensitivity"
            pref="{{prefs.settings.touchpad.haptic_click_sensitivity}}"
            ticks="[[hapticClickSensitivityValues_]]"
            label-aria="$i18n{touchpadHapticClickSensitivityLabel}"
            label-min="$i18n{touchpadHapticLightClickLabel}"
            label-max="$i18n{touchpadHapticFirmClickLabel}"
            deep-link-focus-id$=
              "[[Setting.kTouchpadHapticClickSensitivity]]">
        </settings-slider>
      </div>
      <div class="settings-box two-line" id="touchpadHapticFeedbackRow"
          on-click="onTouchpadHapticFeedbackRowClicked_">
        <div class="start settings-box-text">
          <div>$i18n{touchpadHapticFeedbackTitle}</div>
          <div class="secondary">
            <localized-link
              on-click="onLearnMoreLinkClicked_"
              id="touchpadHapticFeedbackSecondary"
              localized-string="$i18n{touchpadHapticFeedbackSecondaryText}"
              link-url="$i18n{hapticFeedbackLearnMoreLink}">
            </localized-link>
          </div>
        </div>
        <cr-toggle id="touchpadHapticFeedbackToggle"
            checked="{{prefs.settings.touchpad.haptic_feedback.value}}"
            aria-labelledby="touchpadHapticFeedbackRow"
            deep-link-focus-id$="[[Setting.kTouchpadHapticFeedback]]">
        </cr-toggle>
      </div>
    </template>
    <div class="settings-box" id="reverseScrollRow"
         on-click="onTouchpadReverseScrollRowClicked_">
      <div class="start settings-box-text">
        <localized-link
            on-click="onLearnMoreLinkClicked_"
            id="enableReverseScrollingLabel"
            localized-string="$i18n{touchpadScrollLabel}"
            link-url="$i18n{naturalScrollLearnMoreLink}">
        </localized-link>
      </div>
      <cr-toggle id="enableReverseScrollingToggle"
          checked="{{prefs.settings.touchpad.natural_scroll.value}}"
          aria-labelledby="enableReverseScrollingLabel"
          deep-link-focus-id$="[[Setting.kTouchpadReverseScrolling]]">
      </cr-toggle>
    </div>
  </div>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'settings-pointers' is the settings subpage with mouse and touchpad settings.
 */
const SettingsPointersElementBase = DeepLinkingMixin(RouteObserverMixin(PrefsMixin(I18nMixin(PolymerElement))));
class SettingsPointersElement extends SettingsPointersElementBase {
    constructor() {
        super(...arguments);
        // DeepLinkingMixin override
        this.supportedSettingIds = new Set([
            Setting.kTouchpadTapToClick,
            Setting.kTouchpadTapDragging,
            Setting.kTouchpadReverseScrolling,
            Setting.kTouchpadAcceleration,
            Setting.kTouchpadSpeed,
            Setting.kTouchpadHapticFeedback,
            Setting.kTouchpadHapticClickSensitivity,
            Setting.kPointingStickAcceleration,
            Setting.kPointingStickSpeed,
            Setting.kPointingStickSwapPrimaryButtons,
            Setting.kMouseSwapPrimaryButtons,
            Setting.kMouseReverseScrolling,
            Setting.kMouseAcceleration,
            Setting.kMouseSpeed,
        ]);
    }
    static get is() {
        return 'settings-pointers';
    }
    static get template() {
        return getTemplate$2L();
    }
    static get properties() {
        return {
            hasMouse: Boolean,
            hasPointingStick: Boolean,
            hasTouchpad: Boolean,
            hasHapticTouchpad: Boolean,
            swapPrimaryOptions_: {
                readOnly: true,
                type: Array,
                value() {
                    return [
                        {
                            value: false,
                            name: loadTimeData.getString('primaryMouseButtonLeft'),
                        },
                        {
                            value: true,
                            name: loadTimeData.getString('primaryMouseButtonRight'),
                        },
                    ];
                },
            },
            showHeadings_: {
                type: Boolean,
                computed: 'computeShowHeadings_(hasMouse, hasPointingStick, hasTouchpad)',
            },
            subsectionClass_: {
                type: String,
                computed: 'computeSubsectionClass_(hasMouse, hasPointingStick, ' +
                    'hasTouchpad)',
            },
            /**
             * TODO(michaelpg): settings-slider should optionally take a min and max
             * so we don't have to generate a simple range of natural numbers
             * ourselves. These values match the TouchpadSensitivity enum in
             * enums.xml.
             */
            sensitivityValues_: {
                type: Array,
                value: [1, 2, 3, 4, 5],
                readOnly: true,
            },
            /**
             * The click sensitivity values from prefs are [1,3,5] but ChromeVox needs
             * to announce them as [1,2,3].
             */
            hapticClickSensitivityValues_: {
                type: Array,
                value() {
                    return [
                        { value: 1, ariaValue: 1 },
                        { value: 3, ariaValue: 2 },
                        { value: 5, ariaValue: 3 },
                    ];
                },
                readOnly: true,
            },
        };
    }
    /**
     * Headings should only be visible if more than one subsection is present.
     */
    computeShowHeadings_(hasMouse, hasPointingStick, hasTouchpad) {
        const sectionVisibilities = [hasMouse, hasPointingStick, hasTouchpad];
        // Count the number of true values in sectionVisibilities.
        const numVisibleSections = sectionVisibilities.filter(x => x).length;
        return numVisibleSections > 1;
    }
    /**
     * Mouse, pointing stick, and touchpad sections are only subsections if more
     * than one is present.
     */
    computeSubsectionClass_(hasMouse, hasPointingStick, hasTouchpad) {
        const subsections = this.computeShowHeadings_(hasMouse, hasPointingStick, hasTouchpad);
        return subsections ? 'subsection' : '';
    }
    getCursorSpeedString() {
        return this.i18nAdvanced('cursorSpeed');
    }
    getCursorAccelerationString() {
        return this.i18nAdvanced('cursorAccelerationLabel');
    }
    currentRouteChanged(route) {
        // Does not apply to this page.
        if (route !== routes.POINTERS) {
            return;
        }
        if (Router.getInstance().currentRoute === routes.POINTERS) {
            // Call setCurrentRoute function to go to the device page when
            // the feature flag is turned on. We don't use navigateTo function since
            // we don't want to navigate back to the previous point page.
            setTimeout(() => {
                Router.getInstance().setCurrentRoute(routes.DEVICE, new URLSearchParams(), false);
            });
        }
        this.attemptDeepLink();
    }
    onLearnMoreLinkClicked_(event) {
        const path = event.composedPath();
        if (!Array.isArray(path) || !path.length) {
            return;
        }
        if (path[0].tagName === 'A') {
            // Do not toggle reverse scrolling if the contained link is clicked.
            event.stopPropagation();
        }
    }
    onMouseReverseScrollRowClicked_() {
        this.setPrefValue('settings.mouse.reverse_scroll', !this.getPref('settings.mouse.reverse_scroll').value);
    }
    onTouchpadReverseScrollRowClicked_() {
        this.setPrefValue('settings.touchpad.natural_scroll', !this.getPref('settings.touchpad.natural_scroll').value);
    }
    onTouchpadHapticFeedbackRowClicked_() {
        this.setPrefValue('settings.touchpad.haptic_feedback', !this.getPref('settings.touchpad.haptic_feedback').value);
    }
}
customElements.define(SettingsPointersElement.is, SettingsPointersElement);

function getTemplate$2K() {
    return html `<!--_html_template_start_--><style include="settings-shared">:host{--cr-dialog-width:512px;--cr-dialog-height:400px;--cr-dialog-title-slot-padding-top:32px;--cr-dialog-title-slot-padding-start:32px;--cr-dialog-title-slot-padding-end:32px;--cr-dialog-body-padding-horizontal:32px;--cr-radio-button-disc-margin-block-start:2px;--cr-dialog-button-container-padding-horizontal:32px;--cr-dialog-button-container-padding-bottom:32px}#dialogTitleIcon{fill:var(--cros-sys-primary);width:24px;height:24px;padding-left:8px;padding-right:8px;margin-bottom:20px}#dialogTitle{font-size:18px}.link{color:var(--cr-link-color)}cr-radio-button{align-items:start;padding-top:12px}cr-radio-button:not(:last-child){padding-bottom:16px}cr-radio-button:not(:first-child){padding-top:16px}cr-radio-button>div.cr-radio-button-title-text{color:var(--cr-primary-text-color)}cr-radio-button[checked]>div.cr-radio-button-title-text{font-weight:500}cr-radio-button:not([checked])>div.cr-radio-button-title-text{font-weight:400}
</style>
<cr-dialog id="dialog" show-on-attach>
  <div slot="title">
    <iron-icon id="dialogTitleIcon" icon="os-settings:battery-charging-80">
    </iron-icon>
    <div id="dialogTitle" class="title">
      $i18n{powerOptimizedChargingLabel}
    </div>
  </div>
  <div slot="body">
    <cr-radio-group id="radioGroup" selected="{{selectedOption_}}">
      <cr-radio-button id="adaptiveCharging" name="adaptive-charging">
        <div class="cr-radio-button-title-text">
          $i18n{powerAdaptiveChargingLabel}
        </div>
        <div class="cr-secondary-text flex">
          $i18n{powerAdaptiveChargingSubtext}
          <a id="learn-more" href="$i18n{powerAdaptiveChargingLearnMoreUrl}"
              aria-label="$i18n{powerAdaptiveChargingLearnMoreAriaLabel}"
              target="_blank"
              aria-description="$i18n{opensInNewTab}">
            $i18n{learnMore}
          </a>
        </div>
      </cr-radio-button>
      <cr-radio-button id="chargeLimit" name="charge-limit">
        <div class="cr-radio-button-title-text">
          $i18n{powerBatteryChargeLimitLabel}
        </div>
        <div class="cr-secondary-text flex">
          $i18n{powerBatteryChargeLimitSubtext}
        </div>
      </cr-radio-button>
    </cr-radio-group>
  </div>
  <div slot="button-container">
    <cr-button class="cancel-button" id="cancel" on-click="onCancelClick_">
        $i18n{powerOptimizedChargingDialogCancelLabel}
    </cr-button>
    <cr-button class="action-button" id="done" on-click="onDoneClick_">
        $i18n{powerOptimizedChargingDialogDoneLabel}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Names of the radio buttons which allow the user to choose their optimized
 * charging strategy.
 */
var OptimizedChargingButtons;
(function (OptimizedChargingButtons) {
    OptimizedChargingButtons["ADAPTIVE_CHARGING"] = "adaptive-charging";
    OptimizedChargingButtons["CHARGE_LIMIT"] = "charge-limit";
})(OptimizedChargingButtons || (OptimizedChargingButtons = {}));
const PowerOptimizedChargingDialogElementBase = PrefsMixin(PolymerElement);
class PowerOptimizedChargingDialogElement extends PowerOptimizedChargingDialogElementBase {
    static get is() {
        return 'power-optimized-charging-dialog';
    }
    static get template() {
        return getTemplate$2K();
    }
    static get properties() {
        return {
            previousStrategy: { type: Number, computed: `getPreviousPrefValue_()` },
            selectedOption_: {
                type: String,
                computed: 'computeButtonName_(previousStrategy)',
            },
        };
    }
    constructor() {
        super();
        this.browserProxy_ = DevicePageBrowserProxyImpl.getInstance();
    }
    onDoneClick_() {
        const uiSelectedButton = this.$.radioGroup.selected;
        const newlySelectedStrategy = this.convertRadioNameToStrategyEnum_(uiSelectedButton);
        if (this.previousStrategy !== newlySelectedStrategy) {
            this.setPrefValue(SettingsPowerElement.OPTIMIZED_CHARGING_STRATEGY_PREF_NAME, newlySelectedStrategy);
        }
        this.$.dialog.close();
    }
    onCancelClick_() {
        this.$.dialog.cancel();
    }
    computeButtonName_(strategy) {
        switch (strategy) {
            case OptimizedChargingStrategy.STRATEGY_ADAPTIVE_CHARGING:
                return OptimizedChargingButtons.ADAPTIVE_CHARGING;
            case OptimizedChargingStrategy.STRATEGY_CHARGE_LIMIT:
                return OptimizedChargingButtons.CHARGE_LIMIT;
            default:
                assertExhaustive(strategy);
        }
    }
    getPreviousPrefValue_() {
        return this.getPref(SettingsPowerElement.OPTIMIZED_CHARGING_STRATEGY_PREF_NAME)
            .value;
    }
    convertRadioNameToStrategyEnum_(radioButtonName) {
        switch (radioButtonName) {
            case OptimizedChargingButtons.ADAPTIVE_CHARGING:
                return OptimizedChargingStrategy.STRATEGY_ADAPTIVE_CHARGING;
            case OptimizedChargingButtons.CHARGE_LIMIT:
                return OptimizedChargingStrategy.STRATEGY_CHARGE_LIMIT;
            default:
                assertExhaustive(radioButtonName);
        }
    }
}
customElements.define(PowerOptimizedChargingDialogElement.is, PowerOptimizedChargingDialogElement);

function getTemplate$2J() {
    return html `<!--_html_template_start_--><style include="iron-flex cr-shared-style settings-shared md-select">.indented{margin-inline-start:var(--cr-section-indent-padding);padding-inline-start:0}cr-policy-indicator{padding-inline-end:8px}.dropdown-row{--cr-section-min-height:64px}#optimizedChargingManagedIndicator{margin:0 16px}</style>
<div id="powerSourceRow" class="cr-row first"
    hidden$="[[!batteryStatus_.present]]">
  <div class="flex cr-padded-text" aria-hidden="true">
    <div id="powerSourceLabel">[[powerSourceLabel_]]</div>
    <div id="batteryStatus" class="secondary">[[batteryStatus_.statusText]]</div>
  </div>
  <select id="powerSource" class="md-select"
      hidden$="[[!showPowerSourceDropdown_]]"
      aria-labelledby="powerSourceLabel"
      aria-describedby="batteryStatus"
      on-change="onPowerSourceChange_"
      deep-link-focus-id$="[[Setting.kPowerSource]]">
    <option value="" selected="[[isEqual_('', selectedPowerSourceId_)]]">
      $i18n{powerSourceBattery}
    </option>
    <template is="dom-repeat" items="[[powerSources_]]">
      <option value="[[item.id]]"
          selected="[[isEqual_(item.id, selectedPowerSourceId_)]]">
        [[item.description]]
      </option>
    </template>
  </select>
  <div hidden$="[[showPowerSourceDropdown_]]"
      aria-labelledby="powerSourceLabel"
      aria-describedby="batteryStatus">
    [[powerSourceName_]]
  </div>
</div>

<!-- optimizedCharging -->
<template is="dom-if" if="[[!optimizedChargingHidden_]]" restamp>
  <div id="optimizedChargingSettingsRow"
      class$="[[getClassForRow_(batteryStatus_.present, 'optimizedCharging')]]">
    <div class="flex layout horizontal center">
      <div class="flex settings-box-text">
        <div id="optimizedChargingLabel">
          $i18n{powerOptimizedChargingLabel}
        </div>
        <div id="optimizedChargingSublabel" class="cr-secondary-text sub-label"
            hidden$="[[adaptiveChargingManaged_]]">
          <span class="sub-label-text">[[optimizedChargingSublabel_]]</span>
        </div>
      </div>
    </div>
    <template is="dom-if" if="[[adaptiveChargingManaged_]]">
      <cr-policy-pref-indicator id="optimizedChargingManagedIndicator"
          pref="[[adaptiveChargingPref_]]"
          icon-aria-label="$i18n{powerOptimizedChargingLabel}">
      </cr-policy-pref-indicator>
    </template>
    <cr-button id="optimizedChargingChangeButton"
        aria-label="$i18n{powerOptimizedChargingChangeAriaLabel}"
        on-click="makeOptimizedChargingDialogVisible_"
        disabled="[[adaptiveChargingManaged_]]"
        deep-link-focus-id$="[[Setting.kAdaptiveCharging]]
            [[Setting.kChargeLimit]]">
      $i18n{powerOptimizedChargingChangeLabel}
    </cr-button>
    <div class="separator"></div>
    <settings-toggle-v2 id="optimizedChargingToggle"
        aria-labelledby="optimizedChargingSublabel"
        checked="[[optimizedChargingEnabled_]]"
        on-change="onOptimizedChargingToggleChange_"
        disabled="[[adaptiveChargingManaged_]]"
        deep-link-focus-id$="[[Setting.kOptimizedCharging]]">
    </settings-toggle-v2>
  </div>
</template>


<!-- batterySaver -->
<settings-toggle-button id="batterySaverToggle"
    class$="[[getClassForRow_(batteryStatus_.present, 'batterySaver')]]"
    hidden$="[[batterySaverHidden_]]"
    pref="{{prefs.power.cros_battery_saver_active}}"
    label="$i18n{powerBatterySaverLabel}"
    sub-label="$i18n{powerBatterySaverSubtext}"
    learn-more-url="$i18n{powerBatterySaverLearnMoreUrl}"
    disabled="[[isExternalPowerAC_]]"
    deep-link-focus-id$="[[Setting.kBatterySaver]]">
</settings-toggle-button>

<!-- adaptiveCharging -->
<template is="dom-if" if="[[!batteryChargeLimitAvailable_]]" restamp>
  <settings-toggle-button id="adaptiveChargingToggle"
      class$="[[getClassForRow_(batteryStatus_.present, 'adaptiveCharging')]]"
      hidden$="[[!adaptiveChargingSupported_]]"
      pref="[[adaptiveChargingPref_]]"
      label="$i18n{powerAdaptiveChargingLabel}"
      sub-label="$i18n{powerAdaptiveChargingSubtext}"
      learn-more-url="$i18n{powerAdaptiveChargingLearnMoreUrl}"
      on-settings-boolean-control-change="onAdaptiveChargingToggleChange_"
      deep-link-focus-id$="[[Setting.kAdaptiveCharging]]"
      no-set-pref>
  </settings-toggle-button>
</template>

<!-- idle -->
<template is="dom-if" if="[[!batteryStatus_.present]]" restamp>
  <div class$="[[getClassForRow_(batteryStatus_.present, 'idle')]]">
    <div id="powerIdleLabel" class="flex" aria-label="true">
      $i18n{powerIdleLabel}
    </div>

    <template is="dom-if" if="[[acIdleManaged_]]" restamp>
      <cr-policy-indicator id="noBatteryAcIdleManagedIndicator"
          indicator-type="devicePolicy"
          icon-aria-label="$i18n{powerIdleWhileChargingAriaLabel}">
      </cr-policy-indicator>
    </template>
    <select id="noBatteryAcIdleSelect"
        class="md-select"
        on-change="onAcIdleSelectChange_"
        disabled="[[shouldAcIdleSelectBeDisabled_]]"
        aria-label="$i18n{powerIdleWhileChargingAriaLabel}"
        deep-link-focus-id$="[[Setting.kPowerIdleBehaviorWhileCharging]]">
      <template is="dom-repeat" items="[[acIdleOptions_]]">
        <option value="[[item.value]]" selected="[[item.selected]]">
          [[item.name]]
        </option>
      </template>
    </select>
  </div>
</template>

<!-- acIdle -->
<template is="dom-if" if="[[batteryStatus_.present]]" restamp>
  <div id="acIdleSettingBox"
      class$="[[getClassForRow_(batteryStatus_.present, 'acIdle')]]">
    <div class="flex" aria-hidden="true">
      $i18n{powerInactiveWhilePluggedInLabel}
    </div>
    <template is="dom-if" if="[[acIdleManaged_]]" restamp>
      <cr-policy-indicator id="acIdleManagedIndicator"
          indicator-type="devicePolicy"
          icon-aria-label="$i18n{powerIdleWhileChargingAriaLabel}">
      </cr-policy-indicator>
    </template>
    <select id="acIdleSelect" class="md-select"
        on-change="onAcIdleSelectChange_"
        disabled="[[shouldAcIdleSelectBeDisabled_]]"
        aria-label="$i18n{powerIdleWhileChargingAriaLabel}"
        deep-link-focus-id$="[[Setting.kPowerIdleBehaviorWhileCharging]]">
      <template is="dom-repeat" items="[[acIdleOptions_]]">
        <option value="[[item.value]]" selected="[[item.selected]]">
          [[item.name]]
        </option>
      </template>
    </select>
  </div>

  <div id="batteryIdleSettingBox"
      class$="[[getClassForRow_(batteryStatus_.present, 'batteryIdle')]]">
    <div class="flex" aria-hidden="true">
      $i18n{powerInactiveWhileOnBatteryLabel}
    </div>
    <template is="dom-if" if="[[batteryIdleManaged_]]" restamp>
      <cr-policy-indicator id="batteryIdleManagedIndicator"
          indicator-type="devicePolicy"
          icon-aria-label="$i18n{powerIdleWhileOnBatteryAriaLabel}">
      </cr-policy-indicator>
    </template>
    <select id="batteryIdleSelect" class="md-select"
        on-change="onBatteryIdleSelectChange_"
        disabled="[[shouldBatteryIdleSelectBeDisabled_]]"
        aria-label="$i18n{powerIdleWhileOnBatteryAriaLabel}"
        deep-link-focus-id$="[[Setting.kPowerIdleBehaviorWhileOnBattery]]">
      <template is="dom-repeat" items="[[batteryIdleOptions_]]">
        <option value="[[item.value]]" selected="[[item.selected]]">
          [[item.name]]
        </option>
      </template>
    </select>
  </div>
</template>

<settings-toggle-button id="lidClosedToggle"
  class$="[[getClassForRow_(batteryStatus_.present, 'lidClosed')]]"
  hidden$="[[!hasLid_]]" pref="[[lidClosedPref_]]" label="[[lidClosedLabel_]]"
  on-settings-boolean-control-change="onLidClosedToggleChange_" no-set-pref
  deep-link-focus-id$="[[Setting.kSleepWhenLaptopLidClosed]]">
</settings-toggle-button>

<template is="dom-if" if="[[optimizedChargingDialogVisible_]]" restamp>
  <power-optimized-charging-dialog
      id="optimizedChargingDialog"
      prefs="{{prefs}}"
      on-close="onOptimizedChargingDialogClose_">
  </power-optimized-charging-dialog>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'settings-power' is the settings subpage for power settings.
 */
const SettingsPowerElementBase = CrPolicyPrefMixin(DeepLinkingMixin(RouteObserverMixin(PrefsMixin(WebUiListenerMixin(I18nMixin(PolymerElement))))));
class SettingsPowerElement extends SettingsPowerElementBase {
    static { this.OPTIMIZED_CHARGING_STRATEGY_PREF_NAME = 'power.optimized_charging_strategy'; }
    static { this.ADAPTIVE_CHARGING_ENABLED_PREF_NAME = 'power.adaptive_charging_enabled'; }
    static { this.CHARGE_LIMIT_ENABLED_PREF_NAME = 'power.charge_limit_enabled'; }
    static get is() {
        return 'settings-power';
    }
    static get template() {
        return getTemplate$2J();
    }
    static get properties() {
        return {
            /**
             * ID of the selected power source, or ''.
             */
            selectedPowerSourceId_: String,
            batteryStatus_: Object,
            /**
             * Whether a low-power (USB) charger is being used.
             */
            isExternalPowerUSB_: Boolean,
            /**
             * Whether an AC charger is being used.
             */
            isExternalPowerAC_: Boolean,
            /**
             *  Whether the AC idle behavior is managed by policy.
             */
            acIdleManaged_: Boolean,
            /**
             * Whether the battery idle behavior is managed by policy.
             */
            batteryIdleManaged_: Boolean,
            /**
             * Text for label describing the lid-closed behavior.
             */
            lidClosedLabel_: String,
            /**
             * Whether the system possesses a lid.
             */
            hasLid_: Boolean,
            /**
             * List of available dual-role power sources.
             */
            powerSources_: Array,
            powerSourceLabel_: {
                type: String,
                computed: 'computePowerSourceLabel_(powerSources_, batteryStatus_.calculating)',
            },
            showPowerSourceDropdown_: {
                type: Boolean,
                computed: 'computeShowPowerSourceDropdown_(powerSources_)',
                value: false,
            },
            /**
             * The name of the dedicated charging device being used, if present.
             */
            powerSourceName_: {
                type: String,
                computed: 'computePowerSourceName_(powerSources_, isExternalPowerUSB_)',
            },
            acIdleOptions_: {
                type: Array,
                value() {
                    return [];
                },
            },
            batteryIdleOptions_: {
                type: Array,
                value() {
                    return [];
                },
            },
            shouldAcIdleSelectBeDisabled_: {
                type: Boolean,
                computed: 'hasSingleOption_(acIdleOptions_)',
            },
            shouldBatteryIdleSelectBeDisabled_: {
                type: Boolean,
                computed: 'hasSingleOption_(batteryIdleOptions_)',
            },
            adaptiveChargingSupported_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('isAdaptiveChargingSupported');
                },
            },
            /** Whether adaptive charging is managed by policy. */
            adaptiveChargingManaged_: Boolean,
            lidClosedPref_: {
                type: Object,
                value() {
                    return {};
                },
            },
            adaptiveChargingPref_: {
                type: Object,
                value() {
                    return {};
                },
            },
            chargeLimitPref_: {
                type: Object,
                value() {
                    return {};
                },
            },
            batteryChargeLimitAvailable_: {
                type: Boolean,
                value() {
                    return isBatteryChargeLimitAvailable();
                },
            },
            optimizedChargingDialogVisible_: {
                type: Boolean,
                value: false,
            },
            batterySaverFeatureEnabled_: Boolean,
            batterySaverHidden_: {
                type: Boolean,
                computed: 'computeBatterySaverHidden_(batteryStatus_, batterySaverFeatureEnabled_)',
            },
            optimizedChargingSublabel_: {
                type: String,
                computed: 'computeOptimizedChargingSublabel_(selectedOptimizedChargingStrategy_)',
            },
            optimizedChargingHidden_: {
                type: Boolean,
                computed: 'computeOptimizedChargingHidden_(adaptiveChargingSupported_, batteryChargeLimitAvailable_)',
            },
            optimizedChargingEnabled_: {
                type: Boolean,
                computed: 'computeOptimizedChargingToggleState_(adaptiveChargingPref_.value, chargeLimitPref_.value)',
            },
            selectedOptimizedChargingStrategy_: {
                type: Number,
                value: OptimizedChargingStrategy.STRATEGY_ADAPTIVE_CHARGING,
            },
        };
    }
    constructor() {
        super();
        // DeepLinkingMixin override
        this.supportedSettingIds = new Set([
            Setting.kPowerIdleBehaviorWhileCharging,
            Setting.kPowerSource,
            Setting.kSleepWhenLaptopLidClosed,
            Setting.kPowerIdleBehaviorWhileOnBattery,
            Setting.kAdaptiveCharging,
            Setting.kBatterySaver,
            Setting.kOptimizedCharging,
            Setting.kChargeLimit,
        ]);
        this.browserProxy_ = DevicePageBrowserProxyImpl.getInstance();
    }
    connectedCallback() {
        super.connectedCallback();
        this.addWebUiListener('battery-status-changed', this.set.bind(this, 'batteryStatus_'));
        this.addWebUiListener('power-sources-changed', this.powerSourcesChanged_.bind(this));
        this.browserProxy_.updatePowerStatus();
        this.addWebUiListener('power-management-settings-changed', this.powerManagementSettingsChanged_.bind(this));
        this.browserProxy_.requestPowerManagementSettings();
    }
    /**
     * Overridden from DeepLinkingMixin.
     */
    beforeDeepLinkAttempt(settingId) {
        if (settingId === Setting.kPowerSource && this.$.powerSource.hidden) {
            // If there is only 1 power source, there is no dropdown to focus.
            // Stop the deep link attempt in this case.
            return false;
        }
        // Continue with deep link attempt.
        return true;
    }
    currentRouteChanged(route) {
        // Does not apply to this page.
        if (route !== routes.POWER) {
            return;
        }
        this.attemptDeepLink();
    }
    /**
     * @return The primary label for the power source row.
     */
    computePowerSourceLabel_(powerSources, calculating) {
        return this.i18n(calculating ? 'calculatingPower' :
            powerSources && powerSources.length ? 'powerSourceLabel' :
                'powerSourceBattery');
    }
    /**
     * @return True if at least one power source is attached and all of
     *     them are dual-role (no dedicated chargers).
     */
    computeShowPowerSourceDropdown_(powerSources) {
        return powerSources.length > 0 &&
            powerSources.every((source) => !source.is_dedicated_charger);
    }
    /**
     * @return Description of the power source.
     */
    computePowerSourceName_(powerSources, lowPowerCharger) {
        if (lowPowerCharger) {
            return this.i18n('powerSourceLowPowerCharger');
        }
        if (powerSources.length) {
            return this.i18n('powerSourceAcAdapter');
        }
        return '';
    }
    computeBatterySaverHidden_(batteryStatus, featureEnabled) {
        if (batteryStatus === undefined) {
            return true;
        }
        return !featureEnabled || !batteryStatus.present;
    }
    computeOptimizedChargingSublabel_(strategy) {
        switch (strategy) {
            case OptimizedChargingStrategy.STRATEGY_ADAPTIVE_CHARGING:
                return this.i18n('powerAdaptiveChargingLabel');
            case OptimizedChargingStrategy.STRATEGY_CHARGE_LIMIT:
                return this.i18n('powerBatteryChargeLimitLabel');
            default:
                // Return empty string if no policy is selected.
                return '';
        }
    }
    computeOptimizedChargingHidden_(adaptiveChargingSupported, batteryChargeLimitAvailable) {
        // Hidden if adaptive charging is not supported, or if the feature flag is
        // not enabled.
        return !adaptiveChargingSupported || !batteryChargeLimitAvailable;
    }
    computeOptimizedChargingToggleState_(adaptiveChargingEnabled, chargeLimitEnabled) {
        return (adaptiveChargingEnabled ?? false) || (chargeLimitEnabled ?? false);
    }
    onPowerSourceChange_() {
        this.browserProxy_.setPowerSource(this.$.powerSource.value);
    }
    /**
     * Used to disable Battery/AC idle select dropdowns.
     */
    hasSingleOption_(idleOptions) {
        return idleOptions.length === 1;
    }
    onAcIdleSelectChange_(event) {
        const behavior = parseInt(event.target.value, 10);
        this.browserProxy_.setIdleBehavior(behavior, /* whenOnAc */ true);
        recordSettingChange(Setting.kPowerIdleBehaviorWhileCharging, { intValue: behavior });
    }
    onBatteryIdleSelectChange_(event) {
        const behavior = parseInt(event.target.value, 10);
        this.browserProxy_.setIdleBehavior(behavior, /* whenOnAc */ false);
        recordSettingChange(Setting.kPowerIdleBehaviorWhileOnBattery, { intValue: behavior });
    }
    onLidClosedToggleChange_() {
        // Other behaviors are only displayed when the setting is controlled, in
        // which case the toggle can't be changed by the user.
        const enabled = this.$.lidClosedToggle.checked;
        this.browserProxy_.setLidClosedBehavior(enabled ? LidClosedBehavior.SUSPEND : LidClosedBehavior.DO_NOTHING);
        recordSettingChange(Setting.kSleepWhenLaptopLidClosed, { boolValue: enabled });
    }
    onAdaptiveChargingToggleChange_() {
        const adaptiveChargingToggle = this.shadowRoot.querySelector('#adaptiveChargingToggle');
        assertExists(adaptiveChargingToggle);
        const enabled = adaptiveChargingToggle.checked;
        this.browserProxy_.setAdaptiveCharging(enabled);
        recordSettingChange(Setting.kAdaptiveCharging, { boolValue: enabled });
    }
    onOptimizedChargingToggleChange_(event) {
        if (event.composed) {
            // Change is called twice with one being a composed event. Ignore it to
            // dedupe the calls here.
            return;
        }
        const enabled = event.detail;
        this.toggleOptimizedChargingWithSelectedStrategy(enabled);
        recordSettingChange(Setting.kOptimizedCharging, { boolValue: enabled });
    }
    makeOptimizedChargingDialogVisible_(e) {
        e.preventDefault();
        this.optimizedChargingDialogVisible_ = true;
    }
    onOptimizedChargingDialogClose_() {
        this.optimizedChargingDialogVisible_ = false;
        const optimizedChargingChangeButton = this.shadowRoot.querySelector('#optimizedChargingChangeButton');
        assertExists(optimizedChargingChangeButton);
        focusWithoutInk$1(optimizedChargingChangeButton);
    }
    toggleOptimizedChargingWithSelectedStrategy(enabled) {
        // Apply the boolean value only to the selected strategy.
        //
        // Note: Set the pref we are disabling first to false, then apply the
        // potentially enabled value. Otherwise, power_prefs.cc can detect that both
        // prefs are true at the same time, and revert one of them. This happens on
        // the C++ side.
        this.browserProxy_.setOptimizedCharging(this.selectedOptimizedChargingStrategy_, enabled);
    }
    /**
     * @param sources External power sources.
     * @param selectedId The ID of the currently used power source.
     * @param isExternalPowerUSB Whether the currently used power source is a
     *     low-powered USB charger.
     * @param isExternalPowerAC Whether the currently used power source is an AC
     *     charged connected to mains power.
     */
    powerSourcesChanged_(sources, selectedId, isExternalPowerUSB, isExternalPowerAC) {
        this.powerSources_ = sources;
        this.selectedPowerSourceId_ = selectedId;
        this.isExternalPowerUSB_ = isExternalPowerUSB;
        this.isExternalPowerAC_ = isExternalPowerAC;
    }
    /**
     * @param behavior Current behavior.
     * @param isControlled Whether the underlying pref is controlled.
     */
    updateLidClosedLabelAndPref_(behavior, isControlled) {
        const pref = {
            key: '',
            type: chrome.settingsPrivate.PrefType.BOOLEAN,
            // Most behaviors get a dedicated label and appear as checked.
            value: true,
        };
        switch (behavior) {
            case LidClosedBehavior.SUSPEND:
            case LidClosedBehavior.DO_NOTHING:
                // "Suspend" and "do nothing" share the "sleep" label and communicate
                // their state via the toggle state.
                this.lidClosedLabel_ = loadTimeData.getString('powerLidSleepLabel');
                pref.value = behavior === LidClosedBehavior.SUSPEND;
                break;
            case LidClosedBehavior.STOP_SESSION:
                this.lidClosedLabel_ = loadTimeData.getString('powerLidSignOutLabel');
                break;
            case LidClosedBehavior.SHUT_DOWN:
                this.lidClosedLabel_ = loadTimeData.getString('powerLidShutDownLabel');
                break;
        }
        if (isControlled) {
            pref.enforcement = chrome.settingsPrivate.Enforcement.ENFORCED;
            pref.controlledBy = chrome.settingsPrivate.ControlledBy.USER_POLICY;
        }
        this.lidClosedPref_ = pref;
    }
    /**
     * @return Idle option object that maps to idleBehavior.
     */
    getIdleOption_(idleBehavior, currIdleBehavior) {
        const selected = idleBehavior === currIdleBehavior;
        switch (idleBehavior) {
            case IdleBehavior.DISPLAY_OFF_SLEEP:
                return {
                    value: idleBehavior,
                    name: loadTimeData.getString('powerIdleDisplayOffSleep'),
                    selected: selected,
                };
            case IdleBehavior.DISPLAY_OFF:
                return {
                    value: idleBehavior,
                    name: loadTimeData.getString('powerIdleDisplayOff'),
                    selected: selected,
                };
            case IdleBehavior.DISPLAY_ON:
                return {
                    value: idleBehavior,
                    name: loadTimeData.getString('powerIdleDisplayOn'),
                    selected: selected,
                };
            case IdleBehavior.SHUT_DOWN:
                return {
                    value: idleBehavior,
                    name: loadTimeData.getString('powerIdleDisplayShutDown'),
                    selected: selected,
                };
            case IdleBehavior.STOP_SESSION:
                return {
                    value: idleBehavior,
                    name: loadTimeData.getString('powerIdleDisplayStopSession'),
                    selected: selected,
                };
            default:
                assertNotReached('Unknown IdleBehavior type');
        }
    }
    updateIdleOptions_(acIdleBehaviors, batteryIdleBehaviors, currAcIdleBehavior, currBatteryIdleBehavior) {
        this.acIdleOptions_ = acIdleBehaviors.map((idleBehavior) => {
            return this.getIdleOption_(idleBehavior, currAcIdleBehavior);
        });
        this.batteryIdleOptions_ = batteryIdleBehaviors.map((idleBehavior) => {
            return this.getIdleOption_(idleBehavior, currBatteryIdleBehavior);
        });
    }
    /**
     * Called when a new power status is received from powerd.
     *
     * This is used to update the UI by setting certain state based on the
     * currently available information. Since updating UI when working with powerd
     * requires a high level of precision, can't rely on `prefs` or PrefsMixin to
     * get the state, since the async nature of setting/getting prefs can cause
     * the UI to fall out of sync with the backend.
     *
     * @param powerManagementSettings Current power management settings.
     */
    powerManagementSettingsChanged_(powerManagementSettings) {
        this.updateIdleOptions_(powerManagementSettings.possibleAcIdleBehaviors || [], powerManagementSettings.possibleBatteryIdleBehaviors || [], powerManagementSettings.currentAcIdleBehavior, powerManagementSettings.currentBatteryIdleBehavior);
        this.acIdleManaged_ = powerManagementSettings.acIdleManaged;
        this.batteryIdleManaged_ = powerManagementSettings.batteryIdleManaged;
        this.hasLid_ = powerManagementSettings.hasLid;
        this.updateLidClosedLabelAndPref_(powerManagementSettings.lidClosedBehavior, powerManagementSettings.lidClosedControlled);
        this.adaptiveChargingManaged_ =
            powerManagementSettings.adaptiveChargingManaged;
        // Use an atomic assign to trigger UI change.
        const adaptiveChargingPref = {
            key: '',
            type: chrome.settingsPrivate.PrefType.BOOLEAN,
            value: powerManagementSettings.adaptiveCharging,
        };
        const chargeLimitPref = {
            key: '',
            type: chrome.settingsPrivate.PrefType.BOOLEAN,
            value: powerManagementSettings.chargeLimit,
        };
        // When adaptive charging is managed, charge limit is also managed.
        if (this.adaptiveChargingManaged_) {
            adaptiveChargingPref.enforcement =
                chrome.settingsPrivate.Enforcement.ENFORCED;
            adaptiveChargingPref.controlledBy =
                chrome.settingsPrivate.ControlledBy.DEVICE_POLICY;
            chargeLimitPref.enforcement = chrome.settingsPrivate.Enforcement.ENFORCED;
            chargeLimitPref.controlledBy =
                chrome.settingsPrivate.ControlledBy.DEVICE_POLICY;
        }
        this.adaptiveChargingPref_ = adaptiveChargingPref;
        this.chargeLimitPref_ = chargeLimitPref;
        this.batterySaverFeatureEnabled_ =
            powerManagementSettings.batterySaverFeatureEnabled;
        // New Strategy Received:
        if (this.selectedOptimizedChargingStrategy_ !==
            powerManagementSettings.optimizedChargingStrategy) {
            this.selectedOptimizedChargingStrategy_ =
                powerManagementSettings.optimizedChargingStrategy;
            // If the optimized charging toggle is already enabled, hotswap the
            // strategy.
            if (adaptiveChargingPref.value || chargeLimitPref.value) {
                this.toggleOptimizedChargingWithSelectedStrategy(true);
            }
        }
    }
    /**
     * Returns the row class for the given settings row
     * @param batteryPresent if battery is present
     * @param element the name of the row being queried
     * @return the class for the given row
     */
    getClassForRow_(batteryPresent, element) {
        const classes = ['cr-row'];
        switch (element) {
            case 'optimizedCharging':
                if (!batteryPresent) {
                    classes.push('first');
                }
                break;
            case 'batterySaver':
                if (!batteryPresent && this.optimizedChargingHidden_) {
                    classes.push('first');
                }
                break;
            case 'adaptiveCharging':
                if (!batteryPresent && this.optimizedChargingHidden_ &&
                    this.batterySaverHidden_) {
                    classes.push('first');
                }
                break;
            case 'idle':
                if (!batteryPresent && this.optimizedChargingHidden_ &&
                    this.batterySaverHidden_ && !this.adaptiveChargingSupported_) {
                    classes.push('first');
                }
                break;
            case 'acIdle':
                if (!batteryPresent && this.optimizedChargingHidden_ &&
                    this.batterySaverHidden_ && !this.adaptiveChargingSupported_) {
                    classes.push('first');
                }
                classes.push('dropdown-row');
                break;
            case 'batteryIdle':
                classes.push('dropdown-row');
                break;
            case 'lidClosed':
                classes.push('dropdown-row');
                break;
        }
        return classes.join(' ');
    }
    isEqual_(lhs, rhs) {
        return lhs === rhs;
    }
}
customElements.define(SettingsPowerElement.is, SettingsPowerElement);

function getTemplate$2I() {
    return html `<!--_html_template_start_--><style include="settings-shared">settings-toggle-button{margin-inline-end:var(--cr-section-padding);margin-inline-start:var(--cr-section-indent-padding);padding-inline-end:0;padding-inline-start:0}</style>
<settings-toggle-button class="hr"
    pref="{{visiblePref_}}"
    label="[[label]]"
    on-settings-boolean-control-change="onVisibleChange_">
</settings-toggle-button>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'storage-external-entry' is the polymer element for showing a certain
 * external storage device with a toggle switch. When the switch is ON,
 * the storage's uuid will be saved to a preference.
 */
const StorageExternalEntryElementBase = PrefsMixin(WebUiListenerMixin(PolymerElement));
class StorageExternalEntryElement extends StorageExternalEntryElementBase {
    static get is() {
        return 'storage-external-entry';
    }
    static get template() {
        return getTemplate$2I();
    }
    static get properties() {
        return {
            /**
             * FileSystem UUID of an external storage.
             */
            uuid: String,
            /**
             * Label of an external storage.
             */
            label: String,
            visiblePref_: {
                type: Object,
                value() {
                    return {};
                },
            },
        };
    }
    static get observers() {
        return [
            'updateVisible_(prefs.arc.visible_external_storages.*)',
        ];
    }
    /**
     * Handler for when the toggle button for this entry is clicked by a user.
     */
    onVisibleChange_(event) {
        const isVisible = !!event.target.checked;
        if (isVisible) {
            this.appendPrefListItem('arc.visible_external_storages', this.uuid);
        }
        else {
            this.deletePrefListItem('arc.visible_external_storages', this.uuid);
        }
    }
    /**
     * Updates |visiblePref_| by reading the preference and check if it contains
     * UUID of this storage.
     */
    updateVisible_() {
        const uuids = this.getPref('arc.visible_external_storages').value;
        const isVisible = uuids.some((id) => id === this.uuid);
        const pref = {
            key: '',
            type: chrome.settingsPrivate.PrefType.BOOLEAN,
            value: isVisible,
        };
        this.visiblePref_ = pref;
    }
}
customElements.define(StorageExternalEntryElement.is, StorageExternalEntryElement);

function getTemplate$2H() {
    return html `<!--_html_template_start_--><style include="settings-shared">h2{padding-inline-start:var(--cr-section-padding)}#androidAppsExternalDrivesNoteContainer{padding-top:10px;padding-bottom:10px}</style>

<div id="androidAppsExternalDrivesNoteContainer" class="settings-box first">
  <localized-link
      localized-string=
          "[[i18nAdvanced('storageAndroidAppsExternalDrivesNote')]]">
  </localized-link>
</div>
<h2>[[computeStorageListHeader_(externalStorages_)]]</h2>
<iron-list id="removableDevices" preserve-focus
    items="[[externalStorages_]]">
  <template>
    <storage-external-entry uuid="[[item.uuid]]" label="[[item.label]]"
        prefs="{{prefs}}">
    </storage-external-entry>
  </template>
</iron-list>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'settings-storage-external' is the settings subpage for external storage
 * settings.
 */
const SettingsStorageExternalElementBase = WebUiListenerMixin(I18nMixin(PolymerElement));
class SettingsStorageExternalElement extends SettingsStorageExternalElementBase {
    static get is() {
        return 'settings-storage-external';
    }
    static get template() {
        return getTemplate$2H();
    }
    static get properties() {
        return {
            prefs: {
                type: Object,
                notify: true,
            },
            /**
             * List of the plugged-in external storages.
             */
            externalStorages_: {
                type: Array,
                value() {
                    return [];
                },
            },
        };
    }
    constructor() {
        super();
        this.browserProxy_ = DevicePageBrowserProxyImpl.getInstance();
    }
    connectedCallback() {
        super.connectedCallback();
        this.browserProxy_.setExternalStoragesUpdatedCallback(this.handleExternalStoragesUpdated_.bind(this));
        this.browserProxy_.updateExternalStorages();
    }
    handleExternalStoragesUpdated_(storages) {
        this.externalStorages_ = storages;
    }
    computeStorageListHeader_(externalStorages) {
        return this.i18n(!externalStorages || externalStorages.length === 0 ?
            'storageExternalStorageEmptyListHeader' :
            'storageExternalStorageListHeader');
    }
}
customElements.define(SettingsStorageExternalElement.is, SettingsStorageExternalElement);

function getTemplate$2G() {
    return html `<!--_html_template_start_--><style include="settings-shared">progress{-webkit-appearance:none;display:block;height:28px;width:100%}progress::-webkit-progress-bar{background-color:var(--cros-tab-slider-track-color);border-radius:2px}progress::-webkit-progress-value{background-color:var(--cros-icon-color-prominent);border-radius:2px}progress.space-low::-webkit-progress-value{background-color:var(--cros-icon-color-warning)}progress.space-critically-low::-webkit-progress-value{background-color:var(--cros-icon-color-alert)}iron-icon{--iron-icon-fill-color:var(--cros-icon-color-warning);--iron-icon-height:32px;--iron-icon-width:32px}#criticallyLowMessage iron-icon{--iron-icon-fill-color:var(--cros-icon-color-alert)}.storage-size{color:var(--cr-secondary-text-color)}.message-area{background-color:var(--cros-textfield-background-color);border-radius:2px;display:flex;margin:14px 0 16px;padding-bottom:12px;padding-inline-end:48px;padding-inline-start:16px;padding-top:16px;width:100%}.message-area>iron-icon{flex:none;padding-inline-end:16px}.message-title{color:var(--cros-text-color-primary);font-size:115%}.message-description{color:var(--cros-text-color-secondary);font-size:92%;line-height:1.6em;margin:1em 0}#barArea{display:flex;flex-direction:column;margin:24px 0 54px;width:100%}#barLabels{display:flex}.bar-label{display:flex;flex-direction:column}.bar-label .vertical-line{align-self:center;background-color:var(--cros-separator-color);height:8px;margin-bottom:4px;width:1px}.bar-label .wrapper{color:var(--cros-text-color-primary);text-align:center;white-space:nowrap}.end-aligned .wrapper{direction:rtl}:host-context([dir=rtl]) .end-aligned .wrapper{direction:ltr}.end-aligned .wrapper span{direction:initial;unicode-bidi:embed}</style>
<template is="dom-if" if="[[isSpaceLow_(sizeStat_.spaceState)]]">
  <div class="settings-box first">
    <div id="lowMessage" class="message-area">
      <iron-icon icon="cr:warning"></iron-icon>
      <div class="message">
        <div class="message-title">$i18n{storageSpaceLowMessageTitle}</div>
        <div class="message-description">
          <span>$i18n{storageSpaceLowMessageLine1}</span>
          <span>&nbsp;$i18n{storageSpaceLowMessageLine2}</span>
        </div>
      </div>
    </div>
  </div>
</template>
<template is="dom-if" if="[[isSpaceCriticallyLow_(sizeStat_.spaceState)]]">
  <div class="settings-box first">
    <div id="criticallyLowMessage" class="message-area">
      <iron-icon icon="cr:warning"></iron-icon>
      <div class="message">
        <div class="message-title">
          $i18n{storageSpaceCriticallyLowMessageTitle}
        </div>
        <div class="message-description">
          <span>$i18n{storageSpaceCriticallyLowMessageLine1}</span>
          <span>&nbsp;$i18n{storageSpaceCriticallyLowMessageLine2}</span>
        </div>
      </div>
    </div>
  </div>
</template>
<div class="settings-box first">
  <div id="barArea">
    <progress id="bar" class$="[[getBarClass_(sizeStat_.spaceState)]]"
        value="[[roundTo2DecimalPoints_(sizeStat_.usedRatio)]]"
        aria-label="$i18n{storageOverviewAriaLabel}"
        aria-valuetext$="[[sizeStat_.usedSize]]"
        aria-describedby="barLabels">
    </progress>
    <div id="barLabels" aria-hidden="true">
      <div id="inUseLabelArea" class="bar-label">
        <div class="vertical-line"></div>
        <div class="wrapper"><span>$i18n{storageItemInUse}</span></div>
        <div class="wrapper">
          <span class="storage-size">[[sizeStat_.usedSize]]</span>
        </div>
      </div>
      <div id="availableLabelArea" class="bar-label end-aligned">
        <div class="vertical-line"></div>
        <div class="wrapper"><span>$i18n{storageItemAvailable}</span></div>
        <div class="wrapper">
          <span class="storage-size">[[sizeStat_.availableSize]]</span>
        </div>
      </div>
    </div>
  </div>
</div>

<template is="dom-if" if="[[localUserFilesAllowed_(prefs.filebrowser.local_user_files_allowed.value)]]">
  <cr-link-row id="myFilesSizeLink" class="hr" on-click="onMyFilesClick_"
      label="$i18n{storageItemMyFiles}"
      sub-label="[[myFilesSizeSubLabel_]]"
      external>
  </cr-link-row>
</template>
<template is="dom-if" if="[[!localUserFilesAllowed_(prefs.filebrowser.local_user_files_allowed.value)]]">
  <div id="myFilesSizeDiv"
      class="settings-box two-line single-column"
      aria-describedby="myFilesSizeLabel"
      aria-labelledby="myFilesSizeLabel">
    <div id="myFilesSizeLabel" class="label" aria-hidden="true">
      $i18n{storageItemMyFiles}
    </div>
    <div id="myFilesSizeSubLabel" class="secondary label" aria-hidden="true">
      [[myFilesSizeSubLabel_]]
    </div>
  </div>
</template>

<cr-link-row id="browsingDataSize" class="hr" on-click="onBrowsingDataClick_"
    label="$i18n{storageItemBrowsingData}"
    sub-label="$i18n{storageSizeComputing}"
    external>
</cr-link-row>
<cr-link-row id="appsSize" class="hr" on-click="onAppsClick_"
    label="$i18n{storageItemApps}"
    sub-label="$i18n{storageSizeComputing}"
    external>
</cr-link-row>
<template is="dom-if" if="[[shouldShowOfflineFilesRow_(isDriveEnabled_)]]">
  <cr-link-row id="driveOfflineSize" class="hr"
      on-click="onDriveOfflineClick_"
      label="$i18n{storageItemOffline}"
      sub-label="$i18n{storageSizeComputing}"
      role-description="$i18n{subpageArrowRoleDescription}">
  </cr-link-row>
</template>
<template is="dom-if" if="[[showCrostiniStorage_]]">
  <cr-link-row id="crostiniSize" class="hr" on-click="onCrostiniClick_"
      label="$i18n{storageItemCrostini}"
      sub-label="$i18n{storageSizeComputing}"
      role-description="$i18n{subpageArrowRoleDescription}">
  </cr-link-row>
</template>
<template is="dom-if" if="[[showOtherUsers_]]">
  <cr-link-row id="otherUsersSize" class="hr" on-click="onOtherUsersClick_"
      label="$i18n{storageItemOtherUsers}"
      sub-label="$i18n{storageSizeComputing}"
      role-description="$i18n{subpageArrowRoleDescription}">
  </cr-link-row>
</template>
<template is="dom-if" if="[[!isEphemeralUser_]]">
  <div id="systemSize"
      class="settings-box two-line single-column stretch settings-box-text"
      aria-describedby="systemSizeSubLabel"
      aria-labelledby="systemSizeLabel">
    <div id="systemSizeLabel" class="label" aria-hidden="true">
      $i18n{storageItemSystem}
    </div>
    <div id="systemSizeSubLabel" class="secondary label" aria-hidden="true">
      $i18n{storageSizeComputing}
    </div>
  </div>
</template>
<template is="dom-if" if="[[!isEphemeralUser_]]">
  <div id="systemEncryption"
      class="settings-box two-line single-column stretch settings-box-text"
      aria-describedby="systemEncryptionSubLabel"
      aria-labelledby="systemEncryptionLabel">
    <div id="systemEncryptionLabel" class="label" aria-hidden="true">
      $i18n{storageItemEncryption}
    </div>
    <div id="systemEncryptionSubLabel"
        class="secondary label" aria-hidden="true">
      [[storageEncryptionSubLabel_]]
    </div>
  </div>
</template>
<template is="dom-if" if="[[isExternalStorageEnabled_]]">
  <cr-link-row id="externalStoragePreferences" class="hr"
      on-click="onExternalStoragePreferencesClick_"
      label="$i18n{storageExternal}"
      role-description="$i18n{subpageArrowRoleDescription}">
  </cr-link-row>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsStorageElementBase = I18nMixin(PrefsMixin(RouteOriginMixin(WebUiListenerMixin(PolymerElement))));
class SettingsStorageElement extends SettingsStorageElementBase {
    static get is() {
        return 'settings-storage';
    }
    static get template() {
        return getTemplate$2G();
    }
    static get properties() {
        return {
            showCrostiniStorage_: {
                type: Boolean,
                value: false,
            },
            isDriveEnabled_: {
                type: Boolean,
                value: true,
            },
            isEphemeralUser_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('isCryptohomeDataEphemeral');
                },
            },
            isExternalStorageEnabled_: {
                type: Boolean,
                value: () => {
                    return isExternalStorageEnabled();
                },
            },
            showOtherUsers_: {
                type: Boolean,
                // Initialize showOtherUsers_ to false if the user is ephemeral.
                value() {
                    return !loadTimeData.getBoolean('isCryptohomeDataEphemeral');
                },
            },
            isSkyVaultEnabled_: {
                type: Boolean,
                value() {
                    return isSkyVaultEnabled();
                },
            },
            /**
             * Sublabel for the MyFiles section, later it will be updated with the
             * calculated size.
             */
            myFilesSizeSubLabel_: {
                type: String,
                value() {
                    return this.i18n('storageSizeComputing');
                },
            },
            /**
             * Sublabel for storage encryption label.
             */
            storageEncryptionSubLabel_: {
                type: String,
                value() {
                    return this.i18n('storageSizeComputing');
                },
            },
            sizeStat_: Object,
        };
    }
    static get observers() {
        return [
            'handleCrostiniEnabledChanged_(prefs.crostini.enabled.value)',
            'handleDriveDisabledChanged_(prefs.gdata.disabled.value)',
        ];
    }
    constructor() {
        super();
        /** RouteOriginMixin override */
        this.route = routes.STORAGE;
        /**
         * Timer ID for periodic update.
         */
        this.updateTimerId_ = -1;
        this.browserProxy_ = DevicePageBrowserProxyImpl.getInstance();
    }
    connectedCallback() {
        super.connectedCallback();
        this.addWebUiListener('storage-size-stat-changed', (sizeStat) => this.handleSizeStatChanged_(sizeStat));
        this.addWebUiListener('storage-my-files-size-changed', (size) => this.handleMyFilesSizeChanged_(size));
        this.addWebUiListener('storage-browsing-data-size-changed', (size) => this.handleBrowsingDataSizeChanged_(size));
        this.addWebUiListener('storage-apps-size-changed', (size) => this.handleAppsSizeChanged_(size));
        this.addWebUiListener('storage-drive-offline-size-changed', (size) => this.handleDriveOfflineSizeChanged_(size));
        this.addWebUiListener('storage-crostini-size-changed', (size) => this.handleCrostiniSizeChanged_(size));
        if (this.showOtherUsers_) {
            this.addWebUiListener('storage-other-users-size-changed', (size, noOtherUsers) => this.handleOtherUsersSizeChanged_(size, noOtherUsers));
            this.addWebUiListener('storage-system-size-changed', (size) => this.handleSystemSizeChanged_(size));
        }
        if (!this.isEphemeralUser_) {
            this.browserProxy_.getStorageEncryptionInfo().then(encryptionInfo => {
                this.storageEncryptionSubLabel_ = encryptionInfo;
            }, reason => {
                console.warn(`Unable to get info: ${reason}`);
            });
        }
    }
    ready() {
        super.ready();
        const r = routes;
        this.addFocusConfig(r.CROSTINI_DETAILS, '#crostiniSize');
        this.addFocusConfig(r.ACCOUNTS, '#otherUsersSize');
        this.addFocusConfig(r.EXTERNAL_STORAGE_PREFERENCES, '#externalStoragePreferences');
        this.addFocusConfig(r.APP_MANAGEMENT, '#appsSize');
    }
    currentRouteChanged(newRoute, oldRoute) {
        super.currentRouteChanged(newRoute, oldRoute);
        if (newRoute !== this.route) {
            return;
        }
        this.onPageShown_();
    }
    onPageShown_() {
        // Updating storage information can be expensive (e.g. computing directory
        // sizes recursively), so we delay this operation until the page is shown.
        this.browserProxy_.updateStorageInfo();
        // We update the storage usage periodically when the overlay is visible.
        this.startPeriodicUpdate_();
    }
    /**
     * Handler for tapping the MyFiles item.
     */
    onMyFilesClick_() {
        if (this.localUserFilesAllowed_(this.getPref('filebrowser.local_user_files_allowed').value)) {
            this.browserProxy_.openMyFiles();
        }
    }
    /**
     * Handler for tapping the "Browsing data" item.
     */
    onBrowsingDataClick_() {
        this.browserProxy_.openBrowsingDataSettings();
    }
    /**
     * Handler for tapping the "Apps and Extensions" item.
     */
    onAppsClick_() {
        Router.getInstance().navigateTo(routes.APP_MANAGEMENT, 
        /* dynamicParams= */ undefined, /* removeSearch= */ true);
    }
    /**
     * Handler for tapping the "Offline files" item.
     */
    onDriveOfflineClick_() {
        Router.getInstance().navigateTo(routes.GOOGLE_DRIVE, 
        /* dynamicParams= */ undefined, /* removeSearch= */ true);
    }
    /**
     * Handler for tapping the "Linux storage" item.
     */
    onCrostiniClick_() {
        Router.getInstance().navigateTo(routes.CROSTINI_DETAILS, /* dynamicParams= */ undefined, 
        /* removeSearch= */ true);
    }
    /**
     * Handler for tapping the "Other users" item.
     */
    onOtherUsersClick_() {
        Router.getInstance().navigateTo(routes.ACCOUNTS, 
        /* dynamicParams= */ undefined, /* removeSearch= */ true);
    }
    /**
     * Handler for tapping the "External storage preferences" item.
     */
    onExternalStoragePreferencesClick_() {
        Router.getInstance().navigateTo(routes.EXTERNAL_STORAGE_PREFERENCES);
    }
    handleSizeStatChanged_(sizeStat) {
        this.sizeStat_ = sizeStat;
        this.$.inUseLabelArea.style.width = (sizeStat.usedRatio * 100) + '%';
        this.$.availableLabelArea.style.width =
            ((1 - sizeStat.usedRatio) * 100) + '%';
    }
    /**
     * @param size Formatted string representing the size of MyFiles.
     */
    handleMyFilesSizeChanged_(size) {
        this.myFilesSizeSubLabel_ = size;
    }
    /**
     * @param size Formatted string representing the size of Browsing data.
     */
    handleBrowsingDataSizeChanged_(size) {
        this.$.browsingDataSize.subLabel = size;
    }
    /**
     * @param size Formatted string representing the size of Apps and
     *     extensions storage.
     */
    handleAppsSizeChanged_(size) {
        this.shadowRoot.querySelector('#appsSize').subLabel =
            size;
    }
    /**
     * @param size Formatted string representing the size of pinned files in
     *     Google Drive.
     */
    handleDriveOfflineSizeChanged_(size) {
        if (!this.shouldShowOfflineFilesRow_()) {
            return;
        }
        this.shadowRoot.querySelector('#driveOfflineSize').subLabel = size;
    }
    /**
     * @param size Formatted string representing the size of Crostini storage.
     */
    handleCrostiniSizeChanged_(size) {
        if (this.showCrostiniStorage_) {
            this.shadowRoot.querySelector('#crostiniSize').subLabel = size;
        }
    }
    /**
     * @param size Formatted string representing the size of Other users.
     * @param noOtherUsers True if there is no other registered users
     *     on the device.
     */
    handleOtherUsersSizeChanged_(size, noOtherUsers) {
        if (this.isEphemeralUser_ || noOtherUsers) {
            this.showOtherUsers_ = false;
            return;
        }
        this.showOtherUsers_ = true;
        this.shadowRoot.querySelector('#otherUsersSize').subLabel = size;
    }
    /**
     * @param size Formatted string representing the System size.
     */
    handleSystemSizeChanged_(size) {
        this.shadowRoot.getElementById('systemSizeSubLabel').innerText = size;
    }
    /**
     * @param enabled True if Crostini is enabled.
     */
    handleCrostiniEnabledChanged_(enabled) {
        this.showCrostiniStorage_ = enabled && isCrostiniSupported();
    }
    /**
     * Handles showing or hiding the Offline files row if Drive is disabled.
     */
    handleDriveDisabledChanged_(disabled) {
        this.isDriveEnabled_ = !disabled;
    }
    /**
     * Whether to show the Offline files row or not.
     */
    shouldShowOfflineFilesRow_() {
        return this.isDriveEnabled_;
    }
    /**
     * Starts periodic update for storage usage.
     */
    startPeriodicUpdate_() {
        // We update the storage usage every 5 seconds.
        if (this.updateTimerId_ === -1) {
            this.updateTimerId_ = window.setInterval(() => {
                if (Router.getInstance().currentRoute !== routes.STORAGE) {
                    this.stopPeriodicUpdate_();
                    return;
                }
                this.browserProxy_.updateStorageInfo();
            }, 5000);
        }
    }
    /**
     * Stops periodic update for storage usage.
     */
    stopPeriodicUpdate_() {
        if (this.updateTimerId_ !== -1) {
            window.clearInterval(this.updateTimerId_);
            this.updateTimerId_ = -1;
        }
    }
    /**
     * Returns true if the remaining space is low, but not critically low.
     * @param spaceState Status about the remaining space.
     */
    isSpaceLow_(spaceState) {
        return spaceState === StorageSpaceState.LOW;
    }
    /**
     * Returns true if the remaining space is critically low.
     * @param spaceState Status about the remaining space.
     */
    isSpaceCriticallyLow_(spaceState) {
        return spaceState === StorageSpaceState.CRITICALLY_LOW;
    }
    /**
     * Computes class name of the bar based on the remaining space size.
     * @param spaceState Status about the remaining space.
     */
    getBarClass_(spaceState) {
        switch (spaceState) {
            case StorageSpaceState.LOW:
                return 'space-low';
            case StorageSpaceState.CRITICALLY_LOW:
                return 'space-critically-low';
            default:
                return '';
        }
    }
    roundTo2DecimalPoints_(n) {
        return n.toFixed(2);
    }
    /**
     * Checks feature flags and pref values to determine whether storing user
     * files locally is allowed.
     * @param prefValue The value of the local_user_files_allowed pref. Ignored if
     *     feature flags are disabled.
     * @returns Whether local user files are allowed.
     */
    localUserFilesAllowed_(prefValue) {
        // If SkyVault is disabled, we don't care about the pref value.
        return !this.isSkyVaultEnabled_ || prefValue;
    }
}
customElements.define(SettingsStorageElement.is, SettingsStorageElement);

function getTemplate$2F() {
    return html `<!--_html_template_start_--><style include="settings-shared md-select">.settings-box>.secondary{align-items:center;display:flex;margin-top:0}paper-spinner-lite{height:var(--cr-icon-size);margin-inline-start:12px;width:var(--cr-icon-size)}cr-policy-indicator{padding:0 var(--cr-controlled-by-spacing)}#selectApp{width:400px}</style>

<settings-toggle-button id="enableStylusToolsToggle"
    pref="{{prefs.settings.enable_stylus_tools}}"
    label="$i18n{stylusEnableStylusTools}"
    deep-link-focus-id$="[[Setting.kStylusToolsInShelf]]">
</settings-toggle-button>

<template is="dom-if" if="[[hasInternalStylus_]]">
  <settings-toggle-button
      id ="launchPaletteOnEjectEventToggle"
      class="hr"
      pref="{{prefs.settings.launch_palette_on_eject_event}}"
      label="$i18n{stylusAutoOpenStylusTools}"
      disabled="[[!prefs.settings.enable_stylus_tools.value]]">
  </settings-toggle-button>
</template>

<div class="settings-box">
  <div id="stylusNoteTakingAppLabel" class="start">
    $i18n{stylusNoteTakingApp}
  </div>

  <div id="no-apps" class="secondary"
      hidden$="[[!showNoApps_(appChoices_, waitingForAndroid_)]]">
    $i18n{stylusNoteTakingAppNoneAvailable}
  </div>

  <div id="waiting" class="secondary" hidden$="[[!waitingForAndroid_]]">
    $i18n{stylusNoteTakingAppWaitingForAndroid}
    <paper-spinner-lite active></paper-spinner-lite>
  </div>

  <select id="selectApp" class="md-select"
      on-change="onSelectedAppChanged_"
      aria-labelledby="stylusNoteTakingAppLabel"
      hidden$="[[!showApps_(appChoices_, waitingForAndroid_)]]"
      deep-link-focus-id$="[[Setting.kStylusNoteTakingApp]]">
    <template is="dom-repeat" items="[[appChoices_]]">
      <option value="[[item.value]]" selected="[[item.preferred]]">
        [[item.name]]
      </option>
    </template>
  </select>
</div>

<cr-link-row id="findMoreAppsLink" class="hr" on-click="onFindAppsClick_"
    hidden$="[[!prefs.arc.enabled.value]]"
    label="$i18n{stylusFindMoreAppsPrimary}"
    sub-label="$i18n{stylusFindMoreAppsSecondary}"
    external>
</cr-link-row>
<!--_html_template_end_-->`;
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'settings-stylus' is the settings subpage with stylus-specific settings.
 */
const FIND_MORE_APPS_URL = 'https://play.google.com/store/apps/' +
    'collection/promotion_30023cb_stylus_apps';
const SettingsStylusElementBase = DeepLinkingMixin(RouteObserverMixin(PolymerElement));
class SettingsStylusElement extends SettingsStylusElementBase {
    static get is() {
        return 'settings-stylus';
    }
    static get template() {
        return getTemplate$2F();
    }
    static get properties() {
        return {
            /** Preferences state. */
            prefs: {
                type: Object,
                notify: true,
            },
            /**
             * Note taking apps the user can pick between.
             */
            appChoices_: {
                type: Array,
                value() {
                    return [];
                },
            },
            /**
             * True if the device has an internal stylus.
             */
            hasInternalStylus_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('hasInternalStylus');
                },
                readOnly: true,
            },
            /**
             * Currently selected note taking app.
             */
            selectedApp_: {
                type: Object,
                value: null,
            },
            /**
             * True if the ARC container has not finished starting yet.
             */
            waitingForAndroid_: {
                type: Boolean,
                value: false,
            },
        };
    }
    constructor() {
        super();
        // DeepLinkingMixin override
        this.supportedSettingIds = new Set([
            Setting.kStylusToolsInShelf,
            Setting.kStylusNoteTakingApp,
        ]);
        this.browserProxy_ = DevicePageBrowserProxyImpl.getInstance();
    }
    ready() {
        super.ready();
        this.browserProxy_.setNoteTakingAppsUpdatedCallback(this.onNoteAppsUpdated_.bind(this));
        this.browserProxy_.requestNoteTakingApps();
    }
    currentRouteChanged(route) {
        // Does not apply to this page.
        if (route !== routes.STYLUS) {
            return;
        }
        this.attemptDeepLink();
    }
    /**
     * Finds note app info with the provided app id.
     */
    findApp_(id) {
        return this.appChoices_.find((app) => app.value === id) || null;
    }
    onSelectedAppChanged_() {
        const app = this.findApp_(this.$.selectApp.value);
        this.selectedApp_ = app;
        if (app && !app.preferred) {
            this.browserProxy_.setPreferredNoteTakingApp(app.value);
            recordSettingChange(Setting.kStylusNoteTakingApp);
        }
    }
    onNoteAppsUpdated_(apps, waitingForAndroid) {
        this.waitingForAndroid_ = waitingForAndroid;
        this.appChoices_ = apps;
        // Wait until app selection UI is updated before setting the selected app.
        microTask.run(this.onSelectedAppChanged_.bind(this));
    }
    showNoApps_(apps, waitingForAndroid) {
        return apps.length === 0 && !waitingForAndroid;
    }
    showApps_(apps, waitingForAndroid) {
        return apps.length > 0 && !waitingForAndroid;
    }
    onFindAppsClick_() {
        this.browserProxy_.showPlayStore(FIND_MORE_APPS_URL);
    }
}
customElements.define(SettingsStylusElement.is, SettingsStylusElement);

function getTemplate$2E() {
    return html `<!--_html_template_start_--><style include="settings-shared"></style>
<div class="settings-box first">
  <div role="text">
    [[getDescriptionText_()]]
    <span id="guestOsInstructionsRemove" hidden="[[!sharedPaths_.length]]">
      $i18n{guestOsSharedPathsInstructionsRemove}
    </span>
  </div>
</div>
<div id="guestOsListEmpty" class="settings-box secondary continuation"
    hidden="[[sharedPaths_.length]]" >
   $i18n{guestOsSharedPathsListEmptyMessage}
</div>
<div id="guestOsList" hidden="[[!sharedPaths_.length]]">
  <div class="settings-box continuation">
    <h2 id="guestOsListHeading" class="start">
      $i18n{guestOsSharedPathsListHeading}
    </h2>
  </div>
  <iron-list class="list-frame vertical-list" role="list"
      aria-labelledby="guestOsListHeading" items="[[sharedPaths_]]">
    <template>
      <div class="list-item" role="listitem">
        <div class="start" aria-hidden="true"
            id="[[generatePathDisplayTextId_(index)]]">
          [[item.pathDisplayText]]
        </div>
        <cr-icon-button class="icon-clear" tabindex$="[[tabIndex]]"
            on-click="onRemoveSharedPathClick_"
            title="$i18n{guestOsSharedPathsStopSharing}"
            aria-labelledby$="[[generatePathDisplayTextId_(index)]]">
        </cr-icon-button>
      </div>
    </template>
  </iron-list>
</div>
<template is="dom-if" if="[[sharedPathWhichFailedRemoval_]]" restamp>
  <cr-dialog id="removeSharedPathFailedDialog" close-text="$i18n{close}"
      show-on-attach>
    <div slot="title">
      $i18n{guestOsSharedPathsRemoveFailureDialogTitle}
    </div>
    <div slot="body">
      [[getRemoveFailureMessage_()]]
    </div>
    <div slot="button-container">
      <cr-button id="cancel" class="cancel-button"
          on-click="onRemoveFailedDismissClick_">
        $i18n{ok}
      </cr-button>
      <cr-button id="retry" class="action-button"
          on-click="onRemoveFailedRetryClick_">
        $i18n{guestOsSharedPathsRemoveFailureTryAgain}
      </cr-button>
    </div>
  </cr-dialog>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'guest-os-shared-paths' is the settings shared paths subpage for guest OSes.
 */
const SettingsGuestOsSharedPathsElementBase = I18nMixin(PolymerElement);
class SettingsGuestOsSharedPathsElement extends SettingsGuestOsSharedPathsElementBase {
    static get is() {
        return 'settings-guest-os-shared-paths';
    }
    static get template() {
        return getTemplate$2E();
    }
    static get properties() {
        return {
            /**
             * The type of Guest OS to share with. Should be 'crostini', 'pluginVm' or
             * 'bruschetta'.
             */
            guestOsType: String,
            /** Preferences state. */
            prefs: {
                type: Object,
                notify: true,
            },
            /**
             * The shared path string suitable for display in the UI.
             */
            sharedPaths_: Array,
            /**
             * The shared path which failed to be removed in the most recent attempt
             * to remove a path. Null indicates that removal succeeded. When non-null,
             * the failure dialog is shown.
             */
            sharedPathWhichFailedRemoval_: {
                type: String,
                value: null,
            },
        };
    }
    static get observers() {
        return [
            'onGuestOsSharedPathsChanged_(prefs.guest_os.paths_shared_to_vms.value)',
        ];
    }
    constructor() {
        super();
        this.browserProxy_ = GuestOsBrowserProxyImpl.getInstance();
    }
    onGuestOsSharedPathsChanged_(paths) {
        const vmPaths = [];
        for (const path in paths) {
            const vms = paths[path];
            if (vms.includes(this.vmName_())) {
                vmPaths.push(path);
            }
        }
        this.browserProxy_.getGuestOsSharedPathsDisplayText(vmPaths).then(text => {
            this.sharedPaths_ =
                vmPaths.map((path, i) => ({ path: path, pathDisplayText: text[i] }));
        });
    }
    removeSharedPath_(path) {
        this.sharedPathWhichFailedRemoval_ = null;
        this.browserProxy_.removeGuestOsSharedPath(this.vmName_(), path)
            .then(success => {
            if (!success) {
                this.sharedPathWhichFailedRemoval_ = path;
            }
        });
    }
    onRemoveSharedPathClick_(event) {
        this.removeSharedPath_(event.model.item.path);
    }
    onRemoveFailedRetryClick_() {
        this.removeSharedPath_(castExists(this.sharedPathWhichFailedRemoval_));
    }
    onRemoveFailedDismissClick_() {
        this.sharedPathWhichFailedRemoval_ = null;
    }
    /**
     * @return The name of the VM to share devices with.
     */
    vmName_() {
        return getVMNameForGuestOsType(this.guestOsType);
    }
    /**
     * @return Description for the page.
     */
    getDescriptionText_() {
        return this.i18n(this.guestOsType + 'SharedPathsInstructionsLocate') +
            '\n' + this.i18n(this.guestOsType + 'SharedPathsInstructionsAdd');
    }
    /**
     * @return Message to display when removing a shared path fails.
     */
    getRemoveFailureMessage_() {
        return this.i18n(this.guestOsType + 'SharedPathsRemoveFailureDialogMessage');
    }
    generatePathDisplayTextId_(index) {
        return 'path-display-text-' + index;
    }
}
customElements.define(SettingsGuestOsSharedPathsElement.is, SettingsGuestOsSharedPathsElement);

/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
// The name of the anchor to use for the CSS Anchor Positioning API.
const ANCHOR_NAME = css `--tooltip-anchor`;
// Attribute names set for when the tooltip label should be shifted to remain
// on-screen.
const ATTR_SHIFT_INLINE_END = 'shift-inline-end';
const ATTR_SHIFT_INLINE_START = 'shift-inline-start';
// The attribute names here are used in the CSS below. For security reasons, the
// constants above cannot be substituted into the CSS, hence the duplicated
// literals here.
const ATTR_SHIFT_INLINE_END_CSS = css `shift-inline-end`;
const ATTR_SHIFT_INLINE_START_CSS = css `shift-inline-start`;
// The amount of time to wait before closing the tooltip, after the user stopped
// focusing/hovering the anchor or label.
const BLUR_OR_UNFOCUS_TIMEOUT_DURATION = 200;
/** A cros-compliant tooltip component. */
class Tooltip extends LitElement {
    /** @nocollapse */
    static { this.styles = css `
    /* Remove default CSS Popover API styles. */
    :host {
      border: 0;
      margin: 0;
      padding: 0;
    }

    :host(:not(:popover-open)) {
      opacity: 0;
      transition: all 200ms allow-discrete;
    }

    :host(:popover-open) {
      opacity: 1;
      transition: all 200ms allow-discrete;
    }

    @starting-style {
      :host(:popover-open) {
        opacity: 0;
      }
    }

    #tooltip-anchor-overlay {
      anchor-name: ${ANCHOR_NAME};
      opacity: 0;
      pointer-events: none;
      position: fixed;
    }

    #label {
      background-color: var(--cros-sys-inverse_surface);
      border-radius: 6px;
      color: var(--cros-sys-surface);
      font: var(--cros-annotation-1-font);
      inset-block-start: var(--cros-tooltip-vertical-offset, 4px);
      max-width: 296px;
      padding: 5px 8px;
      position-anchor: ${ANCHOR_NAME};
      position-area: block-end span-all;
      position: fixed;
      text-align: center;
      text-wrap: wrap;
    }

    #label[${ATTR_SHIFT_INLINE_END_CSS}] {
      position-area: block-end span-inline-end;
      text-align: start;
    }

    #label[${ATTR_SHIFT_INLINE_START_CSS}] {
      position-area: block-end span-inline-start;
      text-align: start;
    }

    :host([truncate]) #label-inner {
      display: -webkit-box;
      -webkit-box-orient: vertical;
      -webkit-line-clamp: 3;
      overflow: hidden;
    }
  `; }
    /** @nocollapse */
    static { this.properties = {
        anchor: { type: String },
        label: { type: String },
        truncate: { type: Boolean, reflect: true },
        followAnchorOnScroll: { type: Boolean, reflect: true, attribute: 'follow-anchor' },
    }; }
    constructor() {
        super();
        this.currentAnchorElement = null;
        this.isAnchorOrLabelFocused = false;
        this.blurOrUnfocusTimeout = null;
        /**
         * The event listener for the document scroll event, bound to this element.
         */
        this.onDocumentScrollBound = null;
        this.anchorElement = null;
        this.anchor = '';
        this.label = '';
        this.truncate = true;
        this.followAnchorOnScroll = false;
        this.anchorOrLabelFocused = this.anchorOrLabelFocused.bind(this);
        this.anchorOrLabelBlurred = this.anchorOrLabelBlurred.bind(this);
    }
    /** @export */
    get anchorElement() {
        if (this.anchor) {
            return this.getRootNode()
                .querySelector(`#${this.anchor}`);
        }
        return this.currentAnchorElement;
    }
    /** @export */
    set anchorElement(element) {
        this.currentAnchorElement = element;
        this.requestUpdate('anchorElement');
    }
    connectedCallback() {
        super.connectedCallback();
        this.onDocumentScrollBound = this.onDocumentScroll.bind(this);
    }
    firstUpdated() {
        // Adds needed popover properties to cros-tooltip.
        this.setAttribute('popover', 'auto');
        this.setAttribute('id', 'tooltip');
        // Sets anchor to this element's ID & adds listeners on hover.
        if (this.anchorElement) {
            this.anchorElement.addEventListener('mouseover', this.anchorOrLabelFocused);
            this.anchorElement.addEventListener('focusin', this.anchorOrLabelFocused);
            this.anchorElement.addEventListener('mouseout', this.anchorOrLabelBlurred);
            this.anchorElement.addEventListener('focusout', this.anchorOrLabelBlurred);
            if (this.onDocumentScrollBound) {
                document.addEventListener('scroll', this.onDocumentScrollBound);
            }
        }
    }
    disconnectedCallback() {
        if (this.anchorElement) {
            this.anchorElement.removeEventListener('mouseover', this.anchorOrLabelFocused);
            this.anchorElement.removeEventListener('focus', this.anchorOrLabelFocused);
            this.anchorElement.removeEventListener('mouseout', this.anchorOrLabelBlurred);
            this.anchorElement.removeEventListener('blur', this.anchorOrLabelBlurred);
        }
        if (this.onDocumentScrollBound) {
            document.removeEventListener('scroll', this.onDocumentScrollBound);
        }
        super.disconnectedCallback();
    }
    get labelElement() {
        return this.shadowRoot.querySelector('#label');
    }
    updated(changedProperties) {
        if (changedProperties.has('label') && !!this.anchorElement) {
            this.anchorElement.ariaDescription = this.label;
        }
    }
    openPopover() {
        // When the popover opens, move the tooltip to the anchor.
        this.updateAnchorPosition();
        const tooltip = this;
        tooltip.showPopover();
    }
    closePopover() {
        const tooltip = this;
        tooltip.hidePopover();
    }
    anchorOrLabelFocused(e) {
        // Touch events should not trigger tooltips. Note: Sometimes, touch long
        // presses can have `sourceCapabilities` set as undefined.
        const { sourceCapabilities } = e;
        if (!sourceCapabilities || sourceCapabilities.firesTouchEvents) {
            return;
        }
        this.isAnchorOrLabelFocused = true;
        this.openPopover();
    }
    anchorOrLabelBlurred() {
        // After a mouseout event, the anchor may still have keyboard focus, and the
        // tooltip should not close if the keyboard is still focused on the anchor.
        const anchorStillHasKeyboardFocus = this.anchorElement?.matches(':focus');
        if (!anchorStillHasKeyboardFocus) {
            this.isAnchorOrLabelFocused = false;
            this.maybeCloseTooltipAfterTimeout();
        }
    }
    maybeCloseTooltipAfterTimeout() {
        // Restart the timeout if one already exists.
        if (this.blurOrUnfocusTimeout) {
            clearTimeout(this.blurOrUnfocusTimeout);
        }
        // Close the tooltip after a set amount of time, but don't close the tooltip
        // if the user is still focusing the label or the anchor.
        this.blurOrUnfocusTimeout = setTimeout(() => {
            if (!this.isAnchorOrLabelFocused) {
                this.closePopover();
            }
        }, BLUR_OR_UNFOCUS_TIMEOUT_DURATION);
    }
    // The CSS Anchor Positioning API does not yet allow elements in a shadow DOM
    // to see anchor names defined in the outer tree scope. To work around this,
    // there is an internal anchor point (#tooltip-anchor-overlay) that we
    // position to overlap exactly with the actual anchor element. From there, we
    // can use the CSS Anchor Positioning API to position the tooltip. See
    // https://github.com/w3c/csswg-drafts/issues/9408#issuecomment-2105453734 for
    // more context.
    updateAnchorPosition() {
        if (!this.anchorElement)
            return;
        const anchorOverlay = this.shadowRoot.getElementById('tooltip-anchor-overlay');
        const anchorRect = this.anchorElement.getBoundingClientRect();
        // Move the anchor overlay so that it overlaps the anchor element.
        anchorOverlay.style.top = `${anchorRect.top}px`;
        anchorOverlay.style.left = `${anchorRect.left}px`;
        anchorOverlay.style.width = `${anchorRect.width}px`;
        anchorOverlay.style.height = `${anchorRect.height}px`;
        // After the tooltip has been opened, test different alignments
        // (start/center/end) to determine which alignment allows for the largest
        // tooltip width.
        requestAnimationFrame(() => {
            const label = this.labelElement;
            // Move the label back to its normal position, centered under the anchor
            // element, and get its width + check if it's offscreen.
            label.removeAttribute(ATTR_SHIFT_INLINE_START);
            label.removeAttribute(ATTR_SHIFT_INLINE_END);
            const boundingClientRectWhenCentered = label.getBoundingClientRect();
            const widthWhenInCenter = boundingClientRectWhenCentered.width;
            const isOffscreenWhenInCenter = boundingClientRectWhenCentered.x + widthWhenInCenter >
                document.body.clientWidth ||
                boundingClientRectWhenCentered.x < 0;
            // Shift the label to the inline-end (i.e. right for ltr languages), and
            // get its width.
            label.setAttribute(ATTR_SHIFT_INLINE_END, '');
            const widthWhenShiftedToEnd = label.getBoundingClientRect().width;
            // Shift the label to the inline-start (i.e. left for ltr languages), and
            // get its width.
            label.removeAttribute(ATTR_SHIFT_INLINE_END);
            label.setAttribute(ATTR_SHIFT_INLINE_START, '');
            const widthWhenShiftedToStart = label.getBoundingClientRect().width;
            // Reset the label back to the center before applying the final
            // adjustments.
            label.removeAttribute(ATTR_SHIFT_INLINE_END);
            label.removeAttribute(ATTR_SHIFT_INLINE_START);
            if (!isOffscreenWhenInCenter &&
                widthWhenInCenter >= widthWhenShiftedToStart &&
                widthWhenInCenter >= widthWhenShiftedToEnd) {
                // Keep the element in the center.
                label.removeAttribute(ATTR_SHIFT_INLINE_START);
                label.removeAttribute(ATTR_SHIFT_INLINE_END);
            }
            else if (widthWhenShiftedToStart > widthWhenShiftedToEnd) {
                // Shift the element to the start.
                label.setAttribute(ATTR_SHIFT_INLINE_START, '');
            }
            else {
                // Shift the element to the end.
                label.setAttribute(ATTR_SHIFT_INLINE_END, '');
            }
        });
    }
    onDocumentScroll() {
        if (this.followAnchorOnScroll) {
            this.updateAnchorPosition();
        }
    }
    render() {
        return html$1 `
      <div id="tooltip-anchor-overlay">
      </div>
      <div id="label"
          aria-hidden="true"
          role="tooltip"
          @mouseover=${this.anchorOrLabelFocused}
          @mouseout=${this.anchorOrLabelBlurred}
          @focus=${this.anchorOrLabelFocused}
          @blur=${this.anchorOrLabelBlurred}>
        <div id="label-inner">${this.label}</div>
    </div>
    `;
    }
}
customElements.define('cros-tooltip', Tooltip);

/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/** Check if an `Element` is a sidenav or not. */
function isSidenav(element) {
    return element instanceof Element && element.tagName === 'CROS-SIDENAV';
}
/** Check if an `Element` is a sidenav item or not. */
function isSidenavItem(element) {
    return element instanceof Element && element.tagName === 'CROS-SIDENAV-ITEM';
}
/** Returns the active element, if it's a SidenavItem, or null. */
function shadowPiercingActiveItem() {
    let activeElement = document.activeElement;
    while (activeElement && !isSidenavItem(activeElement)) {
        activeElement = activeElement.shadowRoot ?
            activeElement.shadowRoot.activeElement :
            null;
    }
    return activeElement;
}

/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/** The number of pixels to indent per level. */
const TREE_ITEM_INDENT_PX = 20;
/** The width and height of the expand and label icons. */
const ICON_SIZE$1 = css `20px`;
/**
 * Spacing between items in the a row (in LTR):
 *
 * In flat Sidenavs:
 *
 *   1. [ICON_LEADING_MARGIN]
 *      <icon>
 *      [ICON_LABEL_GAP]
 *      <label>
 *      [LABEL_TRAILING_MARGIN]
 *
 *   2. [LABEL_ONLY_MARGIN]
 *      <label>
 *      [LABEL_TRAILING_MARGIN]
 *
 * In layered sidenavs:
 * (the expand icon takes space even when a layered item has no children)
 *
 *   3. [EXPAND_LEADING_MARGIN]
 *      <expand icon>
 *      <icon>
 *      [ICON_LABEL_GAP]
 *      <label>
 *      [LABEL_TRAILING_MARGIN]
 *
 *   4. [EXPAND_LEADING_MARGIN]
 *      <expand icon>
 *      [EXPAND_LABEL_GAP]
 *      <label>
 *      [LABEL_TRAILING_MARGIN]
 */
const ICON_LABEL_GAP = css `8px`;
const EXPAND_LABEL_GAP = css `4px`;
const ICON_LEADING_MARGIN = css `28px`;
const EXPAND_LEADING_MARGIN = css `8px`;
const LABEL_ONLY_MARGIN = css `24px`;
const LABEL_TRAILING_MARGIN = css `12px`;
const ITEM_GAP = css `8px`;
/** Selects a host that is in a layered Sidenav. */
const LAYERED_SELECTOR = css `:host(:is([inLayered], [mayHaveChildren]))`;
// The #tree-item blocks clicks from reaching the host, to prevent clicks on
// empty space between children from triggering the item.
function stopPropagation(e) {
    e.stopPropagation();
}
/** An item for a ChromeOS compliant sidenav element. */
class SidenavItem extends LitElement {
    /** @nocollapse */
    static { this.styles = css `
    :host {
      display: block;
      margin-top: ${ITEM_GAP};
    }

    li {
      display: block;
      font: var(--cros-button-2-font);
    }

    :host([separator])::before {
      border-top: 1px solid var(--cros-separator-color);
      content: '';
      display: block;
      padding-bottom: 8px;
      width: 100%;
    }

    #tree-row {
      align-items: center;
      background: none;
      border: none;
      border-inline-start-width: 0 !important;
      border-radius: 20px;
      box-sizing: border-box;
      color: var(--cros-sys-on_surface);
      cursor: pointer;
      display: flex;
      font: var(--cros-button-2-font);
      height: 40px;
      padding-inline-end: ${LABEL_TRAILING_MARGIN};
      position: relative;
      text-align: start;
      user-select: none;
      white-space: nowrap;
      width: 100%;
    }

    #tree-row:focus-visible {
      outline: none;
    }

    md-focus-ring {
      animation-duration: 0s;
      --md-focus-ring-color: var(--cros-sys-focus_ring);
      --md-focus-ring-shape: 20px;
      --md-focus-ring-width: 2px;
    }

    :host([enabled]) #tree-row {
      background-color: var(--cros-sys-primary);
      color: var(--cros-sys-on_primary);
    }

    :host([disabled]) #tree-row {
      color: var(--cros-sys-disabled);
      pointer-events: none;
    }

    :host([error]) #tree-row {
      background-color: var(--cros-sys-error_container);
      color: var(--cros-sys-on_error_container);
    }

    :host-context(.pointer-active) #tree-row:not(:active) {
      cursor: default;
    }

    .expand-icon {
      display: none;
      fill: currentcolor;
      flex: none;
      height: ${ICON_SIZE$1};
      -webkit-mask-position: center;
      -webkit-mask-repeat: no-repeat;
      position: relative;
      transform: rotate(-90deg);
      transition: all 150ms;
      visibility: hidden;
      width: ${ICON_SIZE$1};
    }

    ${LAYERED_SELECTOR} .expand-icon {
      display: unset;
    }


    [aria-expanded] .expand-icon {
      visibility: visible;
    }

    .expand-icon,
    slot[name="icon"]::slotted(*) {
      width: 20px;
      height: 20px;
      align-items: center;
    }

    :host-context([dir=rtl]) .expand-icon {
      transform: rotate(90deg);
    }

    :host([expanded]) .expand-icon {
      transform: rotate(0);
    }

    slot[name="icon"]::slotted(*) {
      color: var(--cros-sys-on_surface);
      flex: none;
      height: ${ICON_SIZE$1};
      margin-inline-start: ${ICON_LEADING_MARGIN};
      width: ${ICON_SIZE$1};
    }

    :host([enabled]) slot[name="icon"]::slotted(*) {
      color: var(--cros-sys-on_primary)
    }

    :host([disabled]) slot[name="icon"]::slotted(*) {
      color: var(--cros-sys-disabled);
    }

    :host([error]) slot[name="icon"]::slotted(*) {
      color: var(--cros-sys-on_error_container);
    }

    .tree-label {
      display: block;
      flex: auto;
      margin-inline-start: ${LABEL_ONLY_MARGIN};
      overflow: hidden;
      text-overflow: ellipsis;
      white-space: pre;
    }

    ${LAYERED_SELECTOR} .expand-icon {
      margin-inline-start: ${EXPAND_LEADING_MARGIN}
    }

    ${LAYERED_SELECTOR} slot[name="icon"]::slotted(*) {
      margin-inline-start: 0px;
      margin-inline-end: 0px;
    }

    ${LAYERED_SELECTOR} .tree-label {
      margin-inline-start: ${EXPAND_LABEL_GAP};
    }

    ${LAYERED_SELECTOR} .has-icon .tree-label,
    :host([expanded]) .tree-label,
    .has-icon + .tree-label, {
      margin-inline-start: ${ICON_LABEL_GAP};
    }

    .rename {
      background-color: var(--cros-sys-app_base);
      border: none;
      border-radius: 4px;
      color: var(--cros-sys-on_surface);
      height: 20px;
      margin-inline-start: ${LABEL_ONLY_MARGIN};
      outline: 2px solid var(--cros-sys-focus_ring);
      overflow: hidden;
      font: var(--cros-button-2-font);
    }

    .has-icon :is(.tree-label, .rename) {
      margin-inline-start: ${ICON_LABEL_GAP};
    }

    ${LAYERED_SELECTOR} .rename {
      margin-inline-start: ${EXPAND_LABEL_GAP};
    }

    ${LAYERED_SELECTOR} .has-icon :is(.tree-label, .rename) {
      margin-inline-start: ${ICON_LABEL_GAP};
    }

    /* We need to ensure that even empty labels take up space */
    #tree-label:empty::after {
      content: ' ';
      white-space: pre;
    }

    ul.tree-children {
      height: 0px;
      list-style: none;
      margin: 0;
      outline: none;
      overflow: hidden;
      padding: 0;
    }

    :host([expanded]) ul.tree-children {
      display: block;
      height: auto;
      margin: 0;
      overflow: visible;
    }

    :host([enabled]) .rename {
      outline: 2px solid var(--cros-sys-inverse_primary);
    }

    .rename::selection {
      background-color: var(--cros-sys-highlight_text)
    }

    md-ripple {
      border-radius: 20px;
    }

    :host(:not([renaming])) md-ripple {
      color: var(--cros-sys-ripple_primary);
      --md-ripple-hover-color: var(--cros-sys-hover_on_subtle);
      --md-ripple-hover-opacity: 100%;
      --md-ripple-pressed-color: var(--cros-sys-ripple_primary);
      --md-ripple-pressed-opacity: 100%;
    }
  `; }
    /** @nocollapse */
    static { this.shadowRootOptions = {
        ...LitElement.shadowRootOptions,
        delegatesFocus: true
    }; }
    /** @nocollapse */
    static { this.properties = {
        separator: { type: Boolean, reflect: true },
        disabled: { type: Boolean, reflect: true },
        enabled: { type: Boolean, reflect: true },
        expanded: { type: Boolean, reflect: true },
        renaming: { type: Boolean, reflect: true },
        error: { type: Boolean, reflect: true },
        mayHaveChildren: { type: Boolean, reflect: true },
        label: { type: String, reflect: true },
        tabIndex: { attribute: false },
        layer: { type: Number, reflect: true },
        inLayered: { type: Boolean, reflect: true },
        ignoreLayer: { type: Boolean },
        hasIcon: { type: Boolean, reflect: true },
        // Aria properties are forwarded to the `li` element and should not be
        // reflected on `cros-sidenav-item`.
        ariaSetSize: { type: String },
        ariaPosInSet: { type: String },
    }; }
    /** @nocollapse */
    static get events() {
        return {
            /** Triggers when a sidenav item has been expanded. */
            SIDENAV_ITEM_EXPANDED: 'cros-sidenav-item-expanded',
            /** Triggers when a sidenav item has been collapsed. */
            SIDENAV_ITEM_COLLAPSED: 'cros-sidenav-item-collapsed',
            /** Triggers when a sidenav item's label has been renamed. */
            SIDENAV_ITEM_RENAMED: 'cros-sidenav-item-renamed',
            /** Triggers when a sidenav item's changed status changed. */
            SIDENAV_ITEM_ENABLED_CHANGED: 'cros-sidenav-item-enabled-changed',
            /** Triggers when a sidenav item is clicked or equivalent. */
            SIDENAV_ITEM_TRIGGERED: 'cros-sidenav-item-triggered',
        };
    }
    get treeRowElement() {
        return castExists$1(this.shadowRoot.getElementById('tree-row'));
    }
    get renameInputElement() {
        return castExists$1(this.renderRoot.querySelector('.rename'));
    }
    get childrenSlotElement() {
        return castExists$1(this.renderRoot.querySelector('slot:not([name])'));
    }
    get iconSlotElement() {
        return castExists$1(this.renderRoot.querySelector('slot[name="icon"]'));
    }
    constructor() {
        super();
        /** The tree items that are direct children of this. */
        this.items = [];
        /** Indicate if we should commit the rename on input blur or not. */
        this.shouldRenameOnBlur = true;
        this.separator = false;
        this.disabled = false;
        this.enabled = false;
        this.expanded = false;
        this.renaming = false;
        this.error = false;
        this.mayHaveChildren = false;
        this.label = '';
        this.tabIndex = -1;
        this.layer = 0;
        this.ignoreLayer = false;
        this.hasIcon = false;
        this.inLayered = false;
    }
    /** The child tree items which can be tabbed to. */
    get selectableItems() {
        return this.items.filter(item => !item.disabled);
    }
    hasChildren() {
        return this.mayHaveChildren || this.items.length > 0;
    }
    /**
     * Return the parent SidenavItem, if there is one. For top level SidenavItems
     * with no parent, return null.
     */
    get parentItem() {
        let p = this.parentElement;
        while (p) {
            if (isSidenavItem(p)) {
                return p;
            }
            if (isSidenav(p)) {
                return null;
            }
            p = p.parentElement;
        }
        return p;
    }
    /** Expands all parent items. */
    reveal() {
        let pi = this.parentItem;
        while (pi) {
            pi.expanded = true;
            pi = pi.parentItem;
        }
    }
    render() {
        const showExpandIcon = this.hasChildren();
        const effectiveLayer = this.ignoreLayer ? 0 : this.layer;
        const treeRowStyles = {
            /** @export */
            'paddingInlineStart': `max(0px, calc(${TREE_ITEM_INDENT_PX} * ${effectiveLayer}px))`,
        };
        const treeRowClasses = { 'has-icon': this.hasIcon };
        return html$1 `
      <li
          id="tree-item"
          role="none"
          @click=${stopPropagation}>
        <!-- TODO: b/302435119 - Use cros-tooltip instead of title. -->
        <div
            id="tree-row"
            role="treeitem"
            aria-current=${this.enabled ? 'page' : nothing}
            aria-setsize=${this.ariaSetSize ?? nothing}
            aria-posinset=${this.ariaPosInSet ?? nothing}
            aria-level=${this.layer + 1}
            aria-labelledby="tree-label"
            aria-expanded=${showExpandIcon ? this.expanded : nothing}
            aria-disabled=${this.disabled}
            tabindex=${this.tabIndex}
            @click=${this.onRowClicked}
            @keydown=${this.onKeyDown}
            class=${classMap(treeRowClasses)}
            style=${styleMap(treeRowStyles)}>
          <md-ripple
              for="tree-row"
              ?disabled=${this.disabled}>
          </md-ripple>
          <md-focus-ring
              for="tree-row"
              ?disabled=${this.disabled}>
          </md-focus-ring>
          <!-- TODO: b/231672472 - Implement icon from spec -->
          <span
              class="expand-icon"
              aria-hidden="true"
              @click=${this.onExpandIconClicked}>
            <svg xmlns="http://www.w3.org/2000/svg"
                width="20"
                height="20"
                viewBox="0 0 20 20">
              <polyline points="6 8 10 12 14 8 6 8"/>
            </svg>
          </span>
          <slot
              name="icon"
              class=${this.hasIcon ? 'has-icon' : ''}
              aria-hidden="true"
              @slotchange=${this.onIconSlotChanged}>
          </slot>
          ${this.renderTreeLabel()}
        </div>
        <ul
            aria-hidden=${!this.expanded}
            class="tree-children"
            role="group">
          <slot @slotchange=${this.onSlotChanged}></slot>
        </ul>
        ${this.renderTooltip()}
       </li>
     `;
    }
    firstUpdated() {
        // This is needed in addition to a listener on #tree-row, so that we can
        // react to clicks on a slotted icon.
        this.addEventListener('click', this.onRowClicked);
    }
    updated(changedProperties) {
        super.updated(changedProperties);
        if (changedProperties.has('expanded')) {
            this.onExpandChanged();
        }
        if (changedProperties.has('enabled')) {
            this.onEnabledChanged();
        }
        if (changedProperties.has('renaming')) {
            this.onRenamingChanged();
        }
        if (changedProperties.has('layer')) {
            for (const item of this.items) {
                item.layer = this.layer + 1;
            }
        }
    }
    renderTreeLabel() {
        if (this.renaming) {
            // Stop propagation of some events to prevent them being captured by
            // tree when the tree item is in renaming mode.
            const interceptPropagation = (e) => {
                e.stopPropagation();
            };
            return html$1 `
        <input
          class="rename"
          type="text"
          spellcheck="false"
          .value=${this.label}
          @click=${interceptPropagation}
          @dblclick=${interceptPropagation}
          @mouseup=${interceptPropagation}
          @mousedown=${interceptPropagation}
          @blur=${this.onRenameInputBlur}
          @keydown=${this.onRenameInputKeydown}
        />
      `;
        }
        return html$1 `
    <span
      class="tree-label"
      id="tree-label"
    >${this.label || ''}</span>`;
    }
    /**
     * Renders a tooltip if the label is truncated.
     */
    renderTooltip() {
        return html$1 `
        <cros-tooltip
          ?hidden=${!this.isLabelTruncated()}
          anchor="tree-row"
          label=${this.label}
          follow-anchor>
        </cros-tooltip>
      `;
    }
    onIconSlotChanged() {
        this.hasIcon = this.iconSlotElement.assignedElements().length > 0;
        this.iconSlotElement.assignedElements().forEach(icon => {
            icon.setAttribute('tabIndex', '-1');
        });
    }
    // TODO: b/302632527 - Refactor this to avoid storing a copy of children.
    onSlotChanged() {
        // Whether the old set of children contained the enabled item.
        const oldItemsContainEnabledItem = this.items.some((item) => item.enabled);
        // Update `items` every time when the children slot changes (e.g.
        // add/remove).
        this.items =
            this.childrenSlotElement.assignedElements().filter(isSidenavItem);
        let updateScheduled = false;
        // If an expanded item's last children is deleted, update expanded property.
        if (this.items.length === 0 && this.expanded) {
            this.expanded = false;
            updateScheduled = true;
        }
        if (oldItemsContainEnabledItem &&
            !this.items.some((item) => item.enabled)) {
            // If the currently enabled item was in the old set of children but not in
            // the new set, it means it's being removed from the children slot. The
            // parent becomes the enabled item.
            this.enabled = true;
            updateScheduled = true;
        }
        this.items.forEach((item, i) => {
            item.layer = this.layer + 1;
            item.ariaSetSize = `${this.items.length}`;
            item.ariaPosInSet = `${i + 1}`;
        });
        // Explicitly trigger an update because render() relies on hasChildren().
        if (!updateScheduled) {
            this.requestUpdate();
        }
    }
    onExpandChanged() {
        if (this.expanded) {
            const expandedEvent = new CustomEvent(SidenavItem.events.SIDENAV_ITEM_EXPANDED, {
                bubbles: true,
                composed: true,
                detail: { item: this },
            });
            this.dispatchEvent(expandedEvent);
        }
        else {
            const collapseEvent = new CustomEvent(SidenavItem.events.SIDENAV_ITEM_COLLAPSED, {
                bubbles: true,
                composed: true,
                detail: { item: this },
            });
            this.dispatchEvent(collapseEvent);
        }
    }
    onEnabledChanged() {
        const event = new CustomEvent(SidenavItem.events.SIDENAV_ITEM_ENABLED_CHANGED, {
            bubbles: true,
            composed: true,
            detail: { item: this, enabled: this.enabled },
        });
        this.dispatchEvent(event);
    }
    onExpandIconClicked(e) {
        e.stopPropagation();
        if (this.disabled)
            return;
        this.expanded = !this.expanded;
    }
    onRowClicked(e) {
        // Prevent the parent `SidenavItem` from acting on this event.
        e.stopPropagation();
        if (this.disabled)
            return;
        this.enabled = true;
        this.dispatchEvent(new CustomEvent(SidenavItem.events.SIDENAV_ITEM_TRIGGERED, {
            bubbles: false,
            detail: { item: this },
        }));
    }
    onKeyDown(e) {
        if (this.renaming)
            return;
        switch (e.key) {
            case 'Enter':
            case ' ':
                if (this.disabled)
                    break;
                this.enabled = true;
                this.dispatchEvent(new CustomEvent(SidenavItem.events.SIDENAV_ITEM_TRIGGERED, {
                    bubbles: false,
                    detail: { item: this },
                }));
                break;
        }
    }
    onRenamingChanged() {
        if (this.renaming) {
            this.renameInputElement?.focus();
            this.renameInputElement?.select();
        }
    }
    onRenameInputKeydown(e) {
        // Make sure that the tree does not handle the key.
        e.stopPropagation();
        if (e.repeat) {
            return;
        }
        // Calling this.focus() blurs the input which will make the tree item
        // non editable.
        switch (e.key) {
            case 'Escape':
                // By default blur() will trigger the rename, but when ESC is pressed
                // we don't want the blur() (triggered by treeRowElement.focus() below)
                // to commit the rename.
                this.shouldRenameOnBlur = false;
                this.treeRowElement.focus();
                e.preventDefault();
                break;
            case 'Enter':
                // treeRowElement.focus() will trigger blur() for the rename input
                // which will commit the rename.
                this.treeRowElement.focus();
                e.preventDefault();
                break;
        }
    }
    onRenameInputBlur() {
        // Renaming is already false then the rename input element is not available
        // and castExists will throw an error. This can occur in tests which
        // programmatically call blur() on the input element.
        if (!this.renaming) {
            return;
        }
        this.renaming = false;
        if (this.shouldRenameOnBlur) {
            this.commitRename(this.renameInputElement?.value || '');
        }
        else {
            this.shouldRenameOnBlur = true;
        }
    }
    commitRename(newName) {
        const isEmpty = newName.trim() === '';
        const isChanged = newName !== this.label;
        if (isEmpty || !isChanged) {
            return;
        }
        const oldLabel = this.label;
        this.label = newName;
        const renameEvent = new CustomEvent(SidenavItem.events.SIDENAV_ITEM_RENAMED, {
            bubbles: true,
            composed: true,
            detail: { item: this, oldLabel, newLabel: newName },
        });
        this.dispatchEvent(renameEvent);
    }
    isLabelTruncated() {
        const treeLabel = this.shadowRoot?.querySelector('.tree-label');
        if (!treeLabel) {
            return false;
        }
        return treeLabel.scrollWidth > treeLabel.clientWidth;
    }
}
customElements.define('cros-sidenav-item', SidenavItem);

/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
const CHILDREN_OBSERVER_CONFIG = {
    attributes: true,
    childList: true,
    subtree: true,
    attributeFilter: ['mayHaveChildren', 'mayhavechildren']
};
/**
 * True iff `item` is not disabled and every parent of it allows children to be
 * selected.
 */
function isSelectable(item) {
    if (item.disabled)
        return false;
    let parent = item.parentItem;
    while (parent) {
        if (!parent.expanded || parent.disabled)
            return false;
        parent = parent.parentItem;
    }
    return true;
}
/**
 * True iff the user has navigated to `item` or has not navigated and `item`
 * is enabled.
 */
function isSelected(item) {
    return item.tabIndex === 0;
}
/**
 * <cros-sidenav> is the container of the <cros-sidenav-item> elements. An
 * example DOM structure is like this:
 *
 * <cros-sidenav>
 *   <cros-sidenav-item>
 *     <cros-sidenav-item></cros-sidenav-item>
 *   </cros-sidenav-item>
 *   <cros-sidenav-item></cros-sidenav-item>
 * </cros-sidenav>
 *
 * The enabling and focus of <cros-sidenav-item> is controlled in
 * <cros-sidenav>, this is because we need to make sure only one item is being
 * enabled or focused.
 */
class Sidenav extends LitElement {
    /** @nocollapse */
    static { this.styles = css `
      :host {
        display: block;
      }

      ul {
        list-style: none;
        margin: 0;
        padding: 0;
      }

      slot::slotted(cros-sidenav-item:first-child) {
        margin-top: 0;
      }
  `; }
    /** @nocollapse */
    static { this.properties = {
        allowNoEnabled: { type: Boolean, reflect: true },
        ariaSetSize: { type: String, attribute: 'aria-setsize' },
        doubleclickExpands: { type: Boolean, reflect: true },
        role: { type: String, reflect: true },
    }; }
    /** @nocollapse */
    static get events() {
        return {
            /** Triggers when a tree item has been enabled. */
            SIDENAV_ENABLED_CHANGED: 'cros-sidenav-enabled-changed',
        };
    }
    /**
     * Return the enabled tree item. If there are items, an enabled item always
     * exists, unless `allowNoEnabled` is true.
     */
    get enabledItem() {
        return this.items.find(item => item.enabled) || null;
    }
    /** Setting this to null is a noop, unless `allowNoEnabled` is true. */
    set enabledItem(item) {
        if (!item && !this.allowNoEnabled) {
            throw new Error('Setting enabledItem to null is disallowed.');
        }
        this.enableItem(item);
    }
    /**
     * Get all the SidenavItems in the Sidenav. The items are in the order that
     * they are shown, top to bottom.
     */
    get items() {
        return this.childrenSlot.assignedElements()
            .filter(isSidenavItem)
            .flatMap(
        // The Sidenav's slot contains the declarations of all SidenavItems,
        // regardless of how nested. However, `assignedElements()` returns
        // an array of the top elements, so we have to expand each one
        // individually.
        e => [e].concat(Array.from(e.querySelectorAll('cros-sidenav-item'))));
    }
    /**
     * The child tree items which can be selected, e.g. using the arrow keys.
     * This set always includes the selected item, even if it is not selectable.
     * For example, this could happen if the item was selected before being
     * disabled.
     */
    get selectableItems() {
        return this.items.filter(e => isSelectable(e) || isSelected(e));
    }
    /** The default unnamed slot to let consumer pass children tree items. */
    get childrenSlot() {
        return castExists$1(this.renderRoot.querySelector('slot'));
    }
    /**
     * The `selectedItem` is the item that the user navigated to. If the user
     * hasn't navigated, this is the enabled item. The `selectedItem` is the item
     * that should receive focus when the sidenav receives focus. There should
     * always be an item to focus, unless there are no items.
     */
    get selectedItem() {
        return this.items.find(isSelected) || null;
    }
    constructor() {
        super();
        /**
         * Listens for changes on sidenav children and recalculates the sidenav's
         * state if necessary.
         */
        this.itemAttributeObserver = new MutationObserver((mutationList) => {
            for (const mutation of mutationList) {
                if (mutation.type === 'attributes' &&
                    mutation.target.tagName === 'CROS-SIDENAV-ITEM' &&
                    mutation.attributeName?.toLowerCase() === 'mayhavechildren') {
                    this.updateLayered();
                    return;
                }
                if (mutation.type === 'childList') {
                    this.updateLayered();
                    if (!this.hasAttribute('aria-setsize')) {
                        // Detect aria-setsize, if it hasn't been overriden by the client.
                        this.ariaSetSize = `${this.items.length}`;
                    }
                    return;
                }
            }
        });
        this.doubleclickExpands = false;
        this.allowNoEnabled = false;
        this.role = 'navigation';
    }
    render() {
        return html$1 `
      <ul
          class="tree"
          role="tree"
          aria-setsize="${this.ariaSetSize ?? 0}"
          @dblclick=${this.onTreeDblClicked}
          @keydown=${this.onTreeKeyDown}
          @cros-sidenav-item-expanded=${this.onSidenavItemExpanded}
          @cros-sidenav-item-collapsed=${this.onSidenavItemCollapsed}
          @cros-sidenav-item-enabled-changed=${this.onSidenavItemEnabledChanged}>
        <slot @slotchange=${this.onSlotChanged}></slot>
      </ul>
    `;
    }
    connectedCallback() {
        super.connectedCallback();
        // Listen for changes to children, to update the Sidenav's state if
        // necessary.
        this.itemAttributeObserver.observe(this, CHILDREN_OBSERVER_CONFIG);
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        this.itemAttributeObserver.disconnect();
    }
    firstUpdated() {
        if (!this.hasAttribute('aria-setsize')) {
            this.ariaSetSize = `${this.items.length}`;
        }
    }
    /**
     * If the sidenav receives focus, proxy focus down to the selected sidenav
     * item.
     */
    focus() {
        // If there are items, there's always a selected item.
        if (this.selectedItem) {
            this.selectedItem.focus();
        }
    }
    /**
     * When the children change, make sure the sidenav state is passed on to the
     * new tree structure.
     */
    onSlotChanged() {
        const rootChildren = this.childrenSlot.assignedElements().filter(isSidenavItem);
        rootChildren.forEach((child, i) => {
            child.layer = 0;
            child.ariaSetSize = `${rootChildren.length}`;
            child.ariaPosInSet = `${i + 1}`;
        });
        // The sidenav must always have a selected item, unless `allowNoEnabled`.
        if (!this.items.some(item => item.enabled) &&
            this.selectableItems.length > 0 && !this.allowNoEnabled) {
            // Enabling an item also makes it the selected item.
            this.enableItem(castExists$1(this.selectableItems[0]));
        }
        // The sidenav must always have a selected item.
        if (!this.selectedItem && this.selectableItems.length > 0) {
            this.selectItem(castExists$1(this.selectableItems[0]));
        }
        this.updateLayered();
    }
    async getUpdateComplete() {
        await Promise.all(this.items.map(item => item.updateComplete));
        return super.getUpdateComplete();
    }
    /**
     * Infers whether this sidenav has nested children (i.e. is layered), and
     * sets `inLayered` on all the children.
     */
    updateLayered() {
        const layered = this.querySelectorAll('cros-sidenav-item cros-sidenav-item, ' +
            'cros-sidenav-item[mayHaveChildren]')
            .length > 0;
        for (const item of this.querySelectorAll('cros-sidenav-item')) {
            item.inLayered = layered;
        }
    }
    /** Handles the expanded event of the tree item. */
    onSidenavItemExpanded(e) {
        const treeItem = e.detail.item;
        treeItem.scrollIntoViewIfNeeded(false);
    }
    /** Handles the collapse event of the tree item. */
    onSidenavItemCollapsed(e) {
        const collapsedItem = e.detail.item;
        // If the currently selected tree item (`oldSelectedItem`) is a descent of
        // another tree item (`treeItem`) which is going to be collapsed, we need to
        // mark the ancestor tree item (`this`) as selected.
        if (this.selectedItem !== collapsedItem) {
            const oldSelectedItem = this.selectedItem;
            if (oldSelectedItem && collapsedItem.contains(oldSelectedItem)) {
                this.selectItem(collapsedItem);
            }
        }
    }
    /** Handles when that enabled status of an item has changed. */
    onSidenavItemEnabledChanged(e) {
        const item = e.detail.item;
        if (item.enabled) {
            item.reveal();
            this.enableItem(item);
        }
    }
    /** Called when the user double clicks on a tree item. */
    async onTreeDblClicked(e) {
        if (!this.doubleclickExpands)
            return;
        // Stop if the the click target is not a tree item.
        const treeItem = e.target;
        if (treeItem && !isSidenavItem(treeItem)) {
            return;
        }
        if (treeItem.disabled) {
            e.stopImmediatePropagation();
            e.preventDefault();
            return;
        }
        // Use composed path to know which element inside the shadow root
        // has been clicked.
        const innerClickTarget = e.composedPath()[0];
        if (innerClickTarget.className !== 'expand-icon' &&
            treeItem.hasChildren()) {
            treeItem.expanded = !treeItem.expanded;
        }
    }
    /**
     * Handle the keydown within the tree, this mainly handles the navigation
     * and the selection with the keyboard.
     */
    onTreeKeyDown(e) {
        const selectedItem = this.selectedItem;
        const selectableItems = this.selectableItems;
        const currentIndex = selectableItems.findIndex(i => i === selectedItem);
        if (e.ctrlKey) {
            return;
        }
        if (!selectedItem || currentIndex === -1) {
            return;
        }
        let itemToSelect = null;
        switch (e.key) {
            case 'ArrowUp':
                if (currentIndex > 0) {
                    itemToSelect = selectableItems[currentIndex - 1];
                }
                break;
            case 'ArrowDown':
                if (currentIndex < selectableItems.length - 1) {
                    itemToSelect = selectableItems[currentIndex + 1];
                }
                break;
            case 'ArrowLeft':
            case 'ArrowRight':
                // Don't let back/forward keyboard shortcuts be used.
                if (e.altKey) {
                    break;
                }
                const expandKey = isRTL$1(this) ? 'ArrowLeft' : 'ArrowRight';
                if (e.key === expandKey) {
                    if (selectedItem.hasChildren() && !selectedItem.expanded) {
                        selectedItem.expanded = true;
                    }
                    else {
                        itemToSelect = selectedItem.selectableItems[0];
                    }
                }
                else {
                    if (selectedItem.expanded) {
                        selectedItem.expanded = false;
                    }
                    else {
                        itemToSelect = selectedItem.parentItem;
                    }
                }
                break;
            case 'Home':
                itemToSelect = this.selectableItems[0];
                break;
            case 'End':
                itemToSelect = this.selectableItems[this.selectableItems.length - 1];
                break;
            case '*':
                for (const item of this.selectableItems) {
                    if (item.parentItem === selectedItem.parentItem) {
                        item.expanded = true;
                    }
                }
                break;
        }
        // Select the next item whose label starts with the pressed key.
        if (e.key.match('^[A-Za-z]$')) {
            // Search after the current item, then continue searching from the
            // beginning of the items list.
            for (let searchIndex = (currentIndex + 1) % selectableItems.length; searchIndex !== currentIndex; searchIndex = (searchIndex + 1) % selectableItems.length) {
                const searchItem = selectableItems[searchIndex];
                if (searchItem.label.toLowerCase().startsWith(e.key.toLowerCase())) {
                    itemToSelect = searchItem;
                    break;
                }
            }
        }
        if (itemToSelect) {
            this.selectItem(itemToSelect);
            e.preventDefault();
        }
    }
    /**
     * Make `itemToEnable` become the enabled item in the tree, this will
     * also un-enable the previously enabled tree item to make sure at most
     * one tree item is enabled in the tree.
     */
    enableItem(itemToEnable) {
        const previousEnabledItem = this.items.find(item => item.enabled && item !== itemToEnable) || null;
        if (previousEnabledItem) {
            previousEnabledItem.enabled = false;
        }
        if (itemToEnable) {
            itemToEnable.enabled = true;
            this.selectItem(itemToEnable);
            itemToEnable
                .scrollIntoViewIfNeeded(false);
        }
        const enabledChangeEvent = new CustomEvent(Sidenav.events.SIDENAV_ENABLED_CHANGED, {
            bubbles: true,
            composed: true,
            detail: {
                previousEnabledItem,
                enabledItem: itemToEnable,
            },
        });
        this.dispatchEvent(enabledChangeEvent);
    }
    /**
     * Make `itemToSelect` become the selected item in the tree. The previously
     * selected item is unselected. The selected item is the only tabbable item,
     * so that if the user tabs away and returns, they return to the last selected
     * item.
     */
    selectItem(itemToSelect) {
        const oldSelectedItem = this.items.find(item => isSelected(item) && item !== itemToSelect);
        if (oldSelectedItem)
            oldSelectedItem.tabIndex = -1;
        itemToSelect.tabIndex = 0;
        // If the sidenav has focus, move focus to the newly selected item.
        if (this.contains(shadowPiercingActiveItem())) {
            if (oldSelectedItem)
                oldSelectedItem.blur();
            // Schedule the focusing, because we may need to wait for the item to
            // become visible, so that it can receive focus.
            itemToSelect.updateComplete.then(() => {
                itemToSelect.focus();
            });
        }
    }
}
customElements.define('cros-sidenav', Sidenav);

const styleMod$2 = document.createElement('dom-module');
styleMod$2.appendChild(html `
  <template>
    <style include="cros-color-overrides">
h2{font:var(--cros-title-1-font)}code{background-color:var(--cros-sys-app_base_shaded);border-radius:10px;display:block;margin-top:10px;padding:10px}settings-row,settings-dropdown-row,settings-slider-row{background-color:var(--cros-sys-surface1);margin-bottom:8px}
    </style>
  </template>
`.content);
styleMod$2.register('storybook-styles');

function getTemplate$2D() {
    return html `<!--_html_template_start_--><style include="storybook-styles"></style>

<h2>Basic</h2>
<settings-dropdown-row
    label="Lorem ipsum"
    sublabel="Lorem ipsum dolor sit amet"
    icon="os-settings:display"
    learn-more-url="https://google.com"
    value="[[basicDropdownValue_]]"
    options="[[dropdownOptions_]]"
    on-change="onBasicDropdownChange_"
    disabled="[[basicDropdownDisabled_]]">
</settings-dropdown-row>

<cr-checkbox checked="{{basicDropdownDisabled_}}">Disabled</cr-checkbox>

<code>
  <div>Value: [[basicDropdownValue_]]</div>
</code>

<h2>Managed (via pref)</h2>
<settings-dropdown-row
    pref="[[virtualManagedPref_]]"
    label="Lorem ipsum"
    sublabel="Lorem ipsum dolor sit amet"
    icon="os-settings:display"
    learn-more-url="https://google.com"
    options="[[dropdownOptions_]]">
</settings-dropdown-row>
<!--_html_template_end_-->`;
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class SettingsDropdownRowStorybook extends PolymerElement {
    static get is() {
        return 'settings-dropdown-row-storybook';
    }
    static get template() {
        return getTemplate$2D();
    }
    static get properties() {
        return {
            basicDropdownValue_: {
                type: Number,
                value: 2,
            },
            basicDropdownDisabled_: {
                type: Boolean,
                value: false,
            },
            dropdownOptions_: {
                type: Array,
                value: () => {
                    return [
                        { label: 'Lion', value: 1 },
                        { label: 'Tiger', value: 2 },
                        { label: 'Bear', value: 3 },
                        { label: 'Dragon', value: 4 },
                    ];
                },
            },
            virtualManagedPref_: {
                type: Object,
                value: {
                    key: 'virtual_managed_pref',
                    type: chrome.settingsPrivate.PrefType.NUMBER,
                    value: 2,
                    enforcement: chrome.settingsPrivate.Enforcement.ENFORCED,
                    controlledBy: chrome.settingsPrivate.ControlledBy.DEVICE_POLICY,
                },
            },
        };
    }
    onBasicDropdownChange_(event) {
        this.basicDropdownValue_ = event.detail;
    }
}
customElements.define(SettingsDropdownRowStorybook.is, SettingsDropdownRowStorybook);

function getTemplate$2C() {
    return html `<!--_html_template_start_--><style include="storybook-styles"></style>

<h2>Basic</h2>
<settings-dropdown-v2
    value="[[basicDropdownValue_]]"
    options="[[dropdownOptions_]]"
    on-change="onBasicDropdownChange_"
    disabled="[[basicDropdownDisabled_]]"
    aria-label="A11y label"
    aria-description="A11y description">
</settings-dropdown-v2>

<cr-checkbox checked="{{basicDropdownDisabled_}}">Disabled</cr-checkbox>

<code>
  <div>Value: [[basicDropdownValue_]]</div>
</code>

<h2>Managed (via pref)</h2>
<settings-dropdown-v2
    pref="[[virtualManagedPref_]]"
    options="[[dropdownOptions_]]">
</settings-dropdown-v2>
<!--_html_template_end_-->`;
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class SettingsDropdownV2Storybook extends PolymerElement {
    static get is() {
        return 'settings-dropdown-v2-storybook';
    }
    static get template() {
        return getTemplate$2C();
    }
    static get properties() {
        return {
            basicDropdownValue_: {
                type: Number,
                value: 2,
            },
            basicDropdownDisabled_: {
                type: Boolean,
                value: false,
            },
            dropdownOptions_: {
                type: Array,
                value: () => {
                    return [
                        { label: 'Lion', value: 1 },
                        { label: 'Tiger', value: 2 },
                        { label: 'Bear', value: 3 },
                        { label: 'Dragon', value: 4 },
                    ];
                },
            },
            virtualManagedPref_: {
                type: Object,
                value: {
                    key: 'virtual_managed_pref',
                    type: chrome.settingsPrivate.PrefType.NUMBER,
                    value: 2,
                    enforcement: chrome.settingsPrivate.Enforcement.ENFORCED,
                    controlledBy: chrome.settingsPrivate.ControlledBy.DEVICE_POLICY,
                },
            },
        };
    }
    onBasicDropdownChange_(event) {
        this.basicDropdownValue_ = event.detail;
    }
}
customElements.define(SettingsDropdownV2Storybook.is, SettingsDropdownV2Storybook);

function getTemplate$2B() {
    return html `<!--_html_template_start_--><style include="storybook-styles"></style>

<h2>Simple</h2>
<settings-row label="Lorem ipsum" sublabel="">
</settings-row>

<h2>With optional sublabel</h2>
<settings-row label="Lorem ipsum" sublabel="Lorem ipsum dolor sit amet">
</settings-row>

<h2>With optional leading icon</h2>
<settings-row label="Lorem ipsum"
    sublabel="Lorem ipsum dolor sit amet"
    icon="os-settings:display">
</settings-row>

<h2>With optional slotted icon</h2>
<settings-row label="Lorem ipsum"
    sublabel="Lorem ipsum dolor sit amet">
  <img src="chrome://resources/images/extension.svg"
      width="20" height="20"
      slot="icon">
  </img>
</settings-row>

<h2>With optional learn more link</h2>
<settings-row label="Lorem ipsum"
    sublabel="Lorem ipsum dolor sit amet"
    learn-more-url="https://google.com">
</settings-row>

<h2>With optional slotted control element</h2>
<settings-row label="Lorem ipsum"
    sublabel="Lorem ipsum dolor sit amet"
    learn-more-url="https://google.com">
  <settings-toggle-v2 slot="control"></settings-toggle-v2>
</settings-row>

<h2>"Kitchen sink"</h2>
<settings-row label="Lorem ipsum"
    sublabel="Lorem ipsum dolor sit amet"
    learn-more-url="https://google.com"
    icon="os-settings:display">
  <settings-toggle-v2 slot="control"></settings-toggle-v2>
</settings-row>
<!--_html_template_end_-->`;
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class SettingsRowStorybook extends PolymerElement {
    static get is() {
        return 'settings-row-storybook';
    }
    static get template() {
        return getTemplate$2B();
    }
}
customElements.define(SettingsRowStorybook.is, SettingsRowStorybook);

function getTemplate$2A() {
    return html `<!--_html_template_start_--><style include="storybook-styles"></style>

<h2>Slider with ticks</h2>
<settings-slider-row label="Lorem ipsum" sublabel="Lorem ipsum dolor sit amet"
    icon="os-settings:display" ticks="[[ticks_]]" value="5"
    aria-label="A11y label" aria-description="A11y description"
    disabled="[[disabled_]]">
</settings-slider-row>
<cr-checkbox checked="{{disabled_}}">Disabled</cr-checkbox>

<h2>Slider with ticks, hide markers</h2>
<settings-slider-row label="Lorem ipsum" sublabel="Lorem ipsum dolor sit amet"
    icon="os-settings:display" ticks="[[ticks_]]" value="5" hide-markers>
</settings-slider-row>

<h2>Mananged</h2>
<settings-slider-row label="Lorem ipsum" ticks="[[ticks_]]"
    pref="[[virtualManagedPref_]]">
</settings-slider-row>

<h2>Slider with scale</h2>
<settings-slider-row label="Lorem ipsum" sublabel="Lorem ipsum dolor sit amet"
    icon="os-settings:display" min="0" max="10" scale="10" min-label="min"
    max-label="max" hide-label="[[hideLabel_]]"
    value="[[sliderValueWithScale_]]"
    on-change="onScaleSliderChange_"
    update-value-instantly="[[updateValueInstantly_]]">
</settings-slider-row>
<cr-checkbox checked="{{hideLabel_}}">Hide labels</cr-checkbox>
<cr-checkbox checked="{{updateValueInstantly_}}">
  Update value instantly
</cr-checkbox>
<code>
  <div>Slider value: [[sliderValueWithScale_]]</div>
</code>
<!--_html_template_end_-->`;
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class SettingsSliderRowStorybook extends PolymerElement {
    static get is() {
        return 'settings-slider-row-storybook';
    }
    static get template() {
        return getTemplate$2A();
    }
    static get properties() {
        return {
            sliderValueWithScale_: {
                type: Number,
                value: 0.5,
            },
            virtualManagedPref_: {
                type: Object,
                value: {
                    key: 'virtual_managed_pref',
                    type: chrome.settingsPrivate.PrefType.NUMBER,
                    value: 5,
                    enforcement: chrome.settingsPrivate.Enforcement.ENFORCED,
                    controlledBy: chrome.settingsPrivate.ControlledBy.DEVICE_POLICY,
                },
            },
            ticks_: {
                type: Array,
                value: () => {
                    return [
                        { label: '0', value: 0 },
                        { label: '5', value: 5 },
                        { label: '10', value: 10 },
                        { label: '15', value: 15 },
                        { label: '20', value: 20 },
                    ];
                },
            },
            hideLabel_: {
                type: Boolean,
                value: false,
            },
            updateValueInstantly_: {
                type: Boolean,
                value: false,
            },
            disabled_: {
                type: Boolean,
                value: false,
            },
        };
    }
    onScaleSliderChange_(event) {
        this.sliderValueWithScale_ = event.detail;
    }
}
customElements.define(SettingsSliderRowStorybook.is, SettingsSliderRowStorybook);

function getTemplate$2z() {
    return html `<!--_html_template_start_--><style include="storybook-styles"></style>

<h2>With ticks</h2>
<settings-slider-v2
    value="[[sliderValueWithTicks_]]"
    ticks="[[ticks_]]"
    on-change="onTicksSliderChange_"
    disabled="[[disabled_]]"
    aria-label="A11y label"
    aria-description="A11y description">
</settings-slider-v2>
<cr-checkbox checked="{{disabled_}}">Disabled</cr-checkbox>
<code>
  <div>Value: [[sliderValueWithTicks_]]</div>
</code>

<h2>With ticks, hide markers</h2>
<settings-slider-v2
    value="[[sliderValueWithTicks_]]"
    ticks="[[ticks_]]"
    hide-markers
    on-change="onTicksSliderChange_">
</settings-slider-v2>
<code>
  <div>Value: [[sliderValueWithTicks_]]</div>
</code>

<h2>With scale</h2>
<settings-slider-v2
    value="[[sliderValueWithScale_]]"
    scale="10"
    min="0"
    max="10"
    min-label="min"
    max-label="max"
    hide-label="[[hideLabel_]]"
    on-change="onScaleSliderChange_">
</settings-slider-v2>
<cr-checkbox checked="{{hideLabel_}}">Hide labels</cr-checkbox>
<code>
  <div>Value: [[sliderValueWithScale_]]</div>
</code>

<h2>Managed (via pref)</h2>
<settings-slider-v2
    pref="[[virtualManagedPref_]]"
    ticks="[[ticks_]]">
</settings-slider-v2>
<!--_html_template_end_-->`;
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class SettingsSliderV2Storybook extends PolymerElement {
    static get is() {
        return 'settings-slider-v2-storybook';
    }
    static get template() {
        return getTemplate$2z();
    }
    static get properties() {
        return {
            sliderValueWithTicks_: {
                type: Number,
                value: 5,
            },
            sliderValueWithScale_: {
                type: Number,
                value: 0.5,
            },
            hideLabel_: {
                type: Boolean,
                value: false,
            },
            virtualManagedPref_: {
                type: Object,
                value: {
                    key: 'virtual_managed_pref',
                    type: chrome.settingsPrivate.PrefType.NUMBER,
                    value: 5,
                    enforcement: chrome.settingsPrivate.Enforcement.ENFORCED,
                    controlledBy: chrome.settingsPrivate.ControlledBy.DEVICE_POLICY,
                },
            },
            disabled_: {
                type: Boolean,
                value: false,
            },
            ticks_: {
                type: Array,
                value: () => {
                    return [
                        { label: '0', value: 0 },
                        { label: '5', value: 5 },
                        { label: '10', value: 10 },
                        { label: '15', value: 15 },
                        { label: '20', value: 20 },
                    ];
                },
            },
        };
    }
    onTicksSliderChange_(event) {
        this.sliderValueWithTicks_ = event.detail;
    }
    onScaleSliderChange_(event) {
        this.sliderValueWithScale_ = event.detail;
    }
}
customElements.define(SettingsSliderV2Storybook.is, SettingsSliderV2Storybook);

function getTemplate$2y() {
    return html `<!--_html_template_start_--><style include="storybook-styles"></style>

<h2>Basic</h2>
<settings-toggle-v2
    checked="[[checkedValue_]]"
    disabled="[[basicToggleDisabled_]]"
    on-change="onCheckedValueChange_">
</settings-toggle-v2>
<cr-checkbox checked="{{basicToggleDisabled_}}">Disabled</cr-checkbox>
<code>
  <div>Value: [[checkedValue_]]</div>
</code>

<h2>Managed (via pref)</h2>
<settings-toggle-v2
    pref="[[virtualManagedPref_]]">
</settings-toggle-v2>

<h2>Inverted (used with pref)</h2>
<settings-toggle-v2
    pref="[[virtualPref_]]"
    on-change="onInvertedToggleChanged_"
    inverted>
</settings-toggle-v2>
<code>
  <div>pref value: [[virtualPref_.value]]</div>
</code>

<h2>noSetPref (used with pref)</h2>
<settings-toggle-v2
    id="noSetPrefToggle"
    checked="[[prefCheckedValue_]]"
    pref="[[virtualPref_]]"
    on-change="enableDialog_"
    on-user-action-setting-pref-change="handlePrefChange_"
    no-set-pref>
</settings-toggle-v2>
<code>
  <div>pref value: [[virtualPref_.value]]</div>
</code>

<template is="dom-if" if="[[showBasicDialog_]]" restamp>
  <cr-dialog id="dialog" show-on-attach>
    <div slot="title">
      Basic Dialog
    </div>
    <div slot="body">
      <div id="secureDnsDialogDescription">
        <div>
          If cancel is clicked, the dialog will close and the value of the
          toggle resets to the original value (pref's value).
        </div>
        <div>
          If confirm is clicked, the dialog will close and the value of the
          toggle switches. The pref's value will sync to the toggle's value.
        </div>
      </div>
    </div>
    <div slot="button-container">
      <cr-button on-click="onCancelButtonClicked_">
        Cancel
      </cr-button>
      <cr-button on-click="onConfirmButtonClicked_">
        Confirm
      </cr-button>
    </div>
  </cr-dialog>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class SettingsToggleV2Storybook extends PolymerElement {
    static get is() {
        return 'settings-toggle-v2-storybook';
    }
    static get template() {
        return getTemplate$2y();
    }
    static get properties() {
        return {
            checkedValue_: {
                type: Boolean,
                value: true,
            },
            basicToggleDisabled_: {
                type: Boolean,
                value: false,
            },
            prefCheckedValue_: {
                type: Boolean,
                value: true,
            },
            showBasicDialog_: {
                type: Boolean,
                value: false,
            },
            virtualManagedPref_: {
                type: Object,
                value: {
                    key: 'virtual_managed_pref',
                    type: chrome.settingsPrivate.PrefType.BOOLEAN,
                    value: true,
                    enforcement: chrome.settingsPrivate.Enforcement.ENFORCED,
                    controlledBy: chrome.settingsPrivate.ControlledBy.DEVICE_POLICY,
                },
            },
            virtualPref_: {
                type: Boolean,
                value: {
                    key: 'virtual_pref',
                    type: chrome.settingsPrivate.PrefType.BOOLEAN,
                    value: true,
                },
            },
        };
    }
    onCheckedValueChange_(event) {
        this.checkedValue_ = event.detail;
    }
    onInvertedToggleChanged_(event) {
        this.set('virtualPref_.value', !event.detail);
    }
    handlePrefChange_(event) {
        this.set('virtualPref_.value', event.detail.value);
    }
    enableDialog_() {
        this.showBasicDialog_ = true;
    }
    getToggle_() {
        const toggle = this.shadowRoot.querySelector('#noSetPrefToggle');
        assert(toggle);
        return toggle;
    }
    closeDialog_() {
        const dialog = this.shadowRoot.querySelector('cr-dialog');
        assert(dialog);
        dialog.close();
        this.showBasicDialog_ = false;
    }
    onCancelButtonClicked_() {
        this.closeDialog_();
        const toggle = this.getToggle_();
        toggle.resetToPrefValue();
    }
    onConfirmButtonClicked_() {
        this.closeDialog_();
        const toggle = this.getToggle_();
        toggle.commitPrefChange();
    }
}
customElements.define(SettingsToggleV2Storybook.is, SettingsToggleV2Storybook);

function getTemplate$2x() {
    return html `<!--_html_template_start_--><style>#container{display:flex;flex-direction:row;min-height:400px}#sidenav{background-color:var(--cros-sys-app_base_shaded);box-sizing:border-box;padding:10px;width:200px}#pageContainer{flex-grow:1;padding:20px}</style>

<div id="container">
  <cros-sidenav id="sidenav"
      on-cros-sidenav-item-enabled-changed="onSidenavSelect_">
    <cros-sidenav-item id="0" label="settings-toggle-v2"></cros-sidenav-item>
    <cros-sidenav-item id="1" label="settings-slider-v2"></cros-sidenav-item>
    <cros-sidenav-item id="2" label="settings-dropdown-v2"></cros-sidenav-item>
    <cros-sidenav-item id="3" label="settings-row"></cros-sidenav-item>
    <cros-sidenav-item id="4" label="settings-dropdown-row"></cros-sidenav-item>
    <cros-sidenav-item id="5" label="settings-slider-row"></cros-sidenav-item>
  </cros-sidenav>

  <iron-pages id="pageContainer" selected="[[selectedIndex_]]">
    <settings-toggle-v2-storybook></settings-toggle-v2-storybook>
    <settings-slider-v2-storybook></settings-slider-v2-storybook>
    <settings-dropdown-v2-storybook></settings-dropdown-v2-storybook>
    <settings-row-storybook></settings-row-storybook>
    <settings-dropdown-row-storybook></settings-dropdown-row-storybook>
    <settings-slider-row-storybook></settings-slider-row-storybook>
  </iron-pages>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class SettingsStorybookSubpage extends PolymerElement {
    static get is() {
        return 'settings-storybook-subpage';
    }
    static get template() {
        return getTemplate$2x();
    }
    static get properties() {
        return {
            /**
             * The index of the selected page.
             */
            selectedIndex_: {
                type: Number,
                value: 0,
            },
        };
    }
    ready() {
        super.ready();
        // Hide left menu.
        const uiElement = castExists(document.body.querySelector('os-settings-ui'));
        uiElement.shadowRoot.querySelector('#left').hidden = true;
    }
    onSidenavSelect_(event) {
        if (event.detail.enabled) {
            this.selectedIndex_ = parseInt(event.detail.item.id, 10);
        }
    }
}
customElements.define(SettingsStorybookSubpage.is, SettingsStorybookSubpage);

function getTemplate$2w() {
    return html `<!--_html_template_start_--><style include="settings-shared">.separator-line{border-top:var(--cr-separator-line);padding:0}#hotspotToggleText{font-weight:500}#hotspotToggleText[on]{color:var(--cros-text-color-prominent)}#hotspotToggleText:not([on]){color:var(--cros-text-color-secondary)}</style>
<div class="settings-box first">
  <div id="hotspotToggleText" class="start" on$="[[isHotspotToggleOn_]]">
     [[getOnOffString_(hotspotInfo.state)]]
  </div>
  <cr-toggle id="enableHotspotToggle"
      checked="{{isHotspotToggleOn_}}"
      disabled="[[isToggleDisabled_(hotspotInfo.allowStatus,
          hotspotInfo.state)]]"
      on-change="onHotspotToggleChange_"
      aria-label="$i18n{hotspotToggleA11yLabel}"
      deep-link-focus-id$="[[Setting.kHotspotOnOff]]">
  </cr-toggle>
</div>
<div id="hotspotConfigurationRow" class="settings-box two-line">
  <div class="link-wrapper">
    <div id="hotspotSSIDLabel" class="settings-box-text">
        $i18n{hotspotNameLabel}
      <div id="hotspotSSID" class="secondary">
          [[getHotspotConfigSsid_(hotspotInfo.config.ssid)]]
      </div>
    </div>
  </div>
  <cr-button id="configureButton"
      hidden$="[[!showHotspotAutoDisableToggle_(hotspotInfo)]]"
      on-click="onHotspotConfigureClick_">
    $i18n{hotspotConfigureButton}
  </cr-button>
</div>
<template is="dom-if" if="[[showHotspotAutoDisableToggle_(hotspotInfo)]]"
    restamp>
  <settings-toggle-button id="hotspotAutoDisableToggle" class="hr"
      label="$i18n{hotspotAutoDisableLabel}"
      sub-label="$i18n{hotspotAutoDisableSublabel}"
      pref="{{autoDisableVirtualPref_}}"
      on-change="onAutoDisableChange_"
      deep-link-focus-id$="[[Setting.kHotspotAutoDisabled]]">
  </settings-toggle-button>
</template>
<div id="connectedDeviceCountRow"
    class="settings-box settings-box-text two-line single-column stretch"
    hidden$="[[hideConnectedDeviceCount_(hotspotInfo)]]">
  <div id="connectedDeviceCountLabel">
      $i18n{hotspotConnectedDeviceCountLabel}
  </div>
  <div id="connectedDeviceCount" class="secondary">
      [[getHotspotConnectedDeviceCount_(hotspotInfo.clientCount)]]
  </div>
</div>
<div class="separator-line"></div>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * Settings subpage for managing and configuring Hotspot.
 */
const SettingsHotspotSubpageElementBase = DeepLinkingMixin(RouteObserverMixin(PrefsMixin(I18nMixin(PolymerElement))));
class SettingsHotspotSubpageElement extends SettingsHotspotSubpageElementBase {
    constructor() {
        super(...arguments);
        // DeepLinkingMixin override
        this.supportedSettingIds = new Set([
            Setting.kHotspotOnOff,
            Setting.kHotspotAutoDisabled,
        ]);
    }
    static get is() {
        return 'settings-hotspot-subpage';
    }
    static get template() {
        return getTemplate$2w();
    }
    static get properties() {
        return {
            hotspotInfo: {
                type: Object,
                observer: 'onHotspotInfoChanged_',
            },
            /**
             * Reflects the current state of the toggle button. This will be set when
             * the |HotspotInfo| state changes or when the user presses the toggle.
             */
            isHotspotToggleOn_: {
                type: Boolean,
                value: false,
            },
            /**
             * Hotspot auto disabled state.
             */
            autoDisableVirtualPref_: {
                type: Object,
                value() {
                    return {
                        key: 'fakeAutoDisablePref',
                        type: chrome.settingsPrivate.PrefType.BOOLEAN,
                        value: false,
                    };
                },
            },
        };
    }
    currentRouteChanged(route, _oldRoute) {
        // Does not apply to this page.
        if (route !== routes.HOTSPOT_DETAIL) {
            return;
        }
        this.attemptDeepLink();
    }
    onHotspotInfoChanged_(newValue, _oldValue) {
        this.isHotspotToggleOn_ = newValue.state === HotspotState.kEnabled ||
            newValue.state === HotspotState.kEnabling;
        this.updateAutoDisablePref_();
    }
    updateAutoDisablePref_() {
        if (!this.hotspotInfo?.config) {
            return;
        }
        const newPrefValue = {
            key: 'fakeAutoDisablePref',
            value: this.hotspotInfo.config.autoDisable,
            type: chrome.settingsPrivate.PrefType.BOOLEAN,
        };
        this.autoDisableVirtualPref_ = newPrefValue;
    }
    isToggleDisabled_() {
        if (!this.hotspotInfo) {
            return true;
        }
        if (this.hotspotInfo.state === HotspotState.kDisabling) {
            return true;
        }
        if (this.hotspotInfo.state === HotspotState.kEnabling ||
            this.hotspotInfo.state === HotspotState.kEnabled) {
            return false;
        }
        return this.hotspotInfo.allowStatus !== HotspotAllowStatus.kAllowed;
    }
    getOnOffString_() {
        if (!this.hotspotInfo) {
            return this.i18n('hotspotSummaryStateOff');
        }
        if (this.hotspotInfo.state === HotspotState.kEnabling) {
            return this.i18n('hotspotSummaryStateTurningOn');
        }
        if (this.hotspotInfo.state === HotspotState.kEnabled) {
            return this.i18n('hotspotSummaryStateOn');
        }
        if (this.hotspotInfo.state === HotspotState.kDisabling) {
            return this.i18n('hotspotSummaryStateTurningOff');
        }
        return this.i18n('hotspotSummaryStateOff');
    }
    setHotspotEnabledState_(enabled) {
        if (enabled) {
            getHotspotConfig().enableHotspot();
            return;
        }
        getHotspotConfig().disableHotspot();
    }
    onHotspotToggleChange_() {
        this.setHotspotEnabledState_(this.isHotspotToggleOn_);
        getInstance().announce(this.isHotspotToggleOn_ ? this.i18n('hotspotEnabledA11yLabel') :
            this.i18n('hotspotDisabledA11yLabel'));
    }
    getHotspotConfigSsid_(ssid) {
        return ssid || '';
    }
    hideConnectedDeviceCount_() {
        return this.hotspotInfo?.state !== HotspotState.kEnabled &&
            this.hotspotInfo?.state !== HotspotState.kDisabling;
    }
    getHotspotConnectedDeviceCount_(clientCount) {
        return clientCount || 0;
    }
    showHotspotAutoDisableToggle_(hotspotInfo) {
        return !!hotspotInfo?.config;
    }
    onHotspotConfigureClick_() {
        const event = new CustomEvent('show-hotspot-config-dialog', {
            bubbles: true,
            composed: true,
        });
        this.dispatchEvent(event);
    }
    async onAutoDisableChange_() {
        const configToSet = castExists(this.hotspotInfo.config);
        configToSet.autoDisable = this.autoDisableVirtualPref_.value;
        const response = await getHotspotConfig().setHotspotConfig(configToSet);
        if (response.result !== SetHotspotConfigResult.kSuccess) {
            // Flip back the toggle if not set successfully.
            const newPrefValue = {
                key: 'fakeEnabledPref',
                value: !configToSet.autoDisable,
                type: chrome.settingsPrivate.PrefType.BOOLEAN,
            };
            this.autoDisableVirtualPref_ = newPrefValue;
        }
    }
}
customElements.define(SettingsHotspotSubpageElement.is, SettingsHotspotSubpageElement);

function getTemplate$2v() {
  return html`<!--_html_template_start_--><style include="cr-shared-style network-shared iron-flex">
  /* Property lists are embedded; remove the padding. */
  .property-box {
    padding: 0;
    width: var(--cr-property-box-width, inherit);
  }

  cr-input[readonly] {
    --cr-input-background-color: transparent;
  }

  cr-policy-network-indicator-mojo {
    margin-inline-start: var(--settings-controlled-by-spacing);
  }

  .secure {
    -webkit-text-security: disc;
  }
</style>
<template is="dom-repeat" items="[[fields]]"
    filter="[[computeFilter_(prefix, editFieldTypes, propertyDict)]]">
  <div class="property-box single-column two-line stretch">
    <!-- Property label -->
    <div class="layout horizontal center">
      <div>[[getPropertyLabel_(item, prefix)]]</div>
      <template is="dom-if" restamp
          if="[[isEditType_(item, editFieldTypes)]]">
        <cr-policy-network-indicator-mojo
            property="[[getIndicatorProperty_(item, propertyDict)]]">
        </cr-policy-network-indicator-mojo>
      </template>
    </div>
    <!-- Uneditable property value -->
    <template is="dom-if" restamp
        if="[[!showEditable_(item, editFieldTypes, propertyDict)]]">
      <div id="[[item]]"
          class$="[[getPropertyValueCssClasses_(item, prefix, propertyDict)]]"
          data-key$="[[item]]">
        [[getPropertyValue_(item, prefix, propertyDict)]]
      </div>
    </template>
    <!-- Editable property value -->
    <template is="dom-if" restamp
        if="[[showEditable_(item, editFieldTypes, propertyDict)]]">
      <cr-input id="[[item]]"
          readonly="[[!isEditable_(item, editFieldTypes, propertyDict)]]"
          value="[[getPropertyValue_(item, prefix, propertyDict)]]"
          on-change="onValueChange_"
          type="[[getEditInputType_(item, editFieldTypes)]]"
          on-focus="onInputFocused_"
          edited="false"
          disabled="[[disabled]]">
      </cr-input>
    </template>
  </div>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.


/**
 * @constructor
 * @extends {PolymerElement}
 * @implements {I18nBehaviorInterface}
 * @implements {CrPolicyNetworkBehaviorMojoInterface}
 */
const NetworkPropertyListMojoElementBase =
    mixinBehaviors([I18nBehavior, CrPolicyNetworkBehaviorMojo], PolymerElement);

/** @polymer */
class NetworkPropertyListMojoElement extends
    NetworkPropertyListMojoElementBase {
  static get is() {
    return 'network-property-list-mojo';
  }

  static get template() {
    return getTemplate$2v();
  }

  static get properties() {
    return {
      /**
       * The dictionary containing the properties to display.
       * @type {!Object|undefined}
       */
      propertyDict: {
        type: Object,
        observer: 'onPropertyDictChanged_',
      },

      /**
       * Fields to display.
       * @type {!Array<string>}
       */
      fields: {
        type: Array,
        value() {
          return [];
        },
      },

      /**
       * Edit type of editable fields. May contain a property for any field in
       * |fields|. Other properties will be ignored. Property values can be:
       *   'String' - A text input will be displayed.
       *   'StringArray' - A text input will be displayed that expects a comma
       *       separated list of strings.
       *   'Password' - A string with input type = password.
       * When a field changes, the 'property-change' event will be fired with
       * the field name and the new value provided in the event detail.
       * @type {!Object<string>}
       */
      editFieldTypes: {
        type: Object,
        value() {
          return {};
        },
      },

      /** Prefix used to look up property key translations. */
      prefix: {
        type: String,
        value: '',
      },

      /**
       * Whether all CrInputs are automatically read-only, and none are
       * editable by the user.
       */
      allFieldsReadOnly: {
        type: Boolean,
        value: true,
        readonly: true,
        observer: 'onAllFieldsReadOnlyChanged_',
      },

      disabled: {
        type: Boolean,
        value: false,
      },

      /**
       * Whether any of the CrInputElements have been visibly focused since
       * |allFieldsReadOnly| becoming true.
       * @private
       */
      hasAnyInputFocused_: {
        type: Boolean,
        value: false,
      },
    };
  }

  /** @private */
  onAllFieldsReadOnlyChanged_() {
    if (this.allFieldsReadOnly) {
      return;
    }

    this.hasAnyInputFocused_ = false;

    // If this focus attempt fails (e.g. when other updates affect focus), the
    // call in onPropertyDictChanged_ will set the focus.
    setTimeout(() => {
      this.attemptToFocusFirstEditableCrInput_();
    });
  }

  /**
   * Since |this.propertyDict| may change multiple times after the
   * user |this.allFieldsReadOnly| becomes false (while editing the
   * properties of a connected network), the first CrInputElement should be
   * ready before it's focused.
   * @private
   */
  onPropertyDictChanged_() {
    // Do not proceed if the user has not opted for manual edit, or has
    // already made an edit.
    if (this.allFieldsReadOnly || this.hasAnyInputFocused_) {
      return;
    }

    this.attemptToFocusFirstEditableCrInput_();
  }

  /**
   * Attempts to focus the first non read-only CrInputElement.
   * @private
   */
  attemptToFocusFirstEditableCrInput_() {
    flush();

    const crInput = /** @type {?HTMLElement} */
        (this.shadowRoot.querySelector('cr-input:not([readonly])'));
    if (!crInput) {
      return;
    }

    // Note that |this.hasAnyInputFocused_| should not change here because a
    // CrInputElement's focus event may not properly fire before
    // |this.propertyDict| reaches steady state.
    /** @type {{focusInput: function():void}} */ (crInput).focusInput();
  }

  /**
   * Select the text contents of the input if
   * |this.allFieldsReadOnly| is true and the the CrInputElement
   * has not been focused before.
   * @param {!Event} e The input focus event.
   * @private
   */
  onInputFocused_(e) {
    if (this.allFieldsReadOnly) {
      return;
    }

    const crInput = /** @type {!HTMLElement} */ (e.target);
    // Subsequent focuses to the same CrInputElement after the first will not
    // select the entire text.
    if (crInput.getAttribute('edited') === 'true') {
      return;
    }

    // Set |edited| attribute to true so that the next time the user focuses
    // on the CrInputElement while |this.allFieldsReadOnly| is
    // still true, the entire contents are not selected.
    crInput.setAttribute('edited', true);
    crInput.select();
    this.hasAnyInputFocused_ = true;
  }

  /**
   * Event triggered when an input field changes. Fires a 'property-change'
   * event with the field (property) name set to the target id, and the value
   * set to the target input value.
   * @param {!Event} event The input change event.
   * @private
   */
  onValueChange_(event) {
    if (!this.propertyDict) {
      return;
    }
    const key = event.target.id;
    let curValue = this.getProperty_(key);
    if (typeof curValue === 'object' && !Array.isArray(curValue)) {
      // Extract the property from an ONC managed dictionary.
      curValue = OncMojo.getActiveValue(
          /** @type{!OncMojo.ManagedProperty} */ (curValue));
    }
    const newValue = this.getValueFromEditField_(key, event.target.value);
    if (newValue === curValue) {
      return;
    }
    this.dispatchEvent(new CustomEvent('property-change', {
      bubbles: true,
      composed: true,
      detail: {field: key, value: newValue}
    }));
  }

  /**
   * Converts mojo keys to ONC keys. TODO(stevenjb): Remove this and update
   * string ids once everything is converted to mojo.
   * @param {string} key
   * @param {string=} opt_prefix
   * @return {string}
   * @private
   */
  getOncKey_(key, opt_prefix) {
    if (opt_prefix) {
      key = opt_prefix + key.charAt(0).toUpperCase() + key.slice(1);
    }
    let result = '';
    const subKeys = key.split('.');
    subKeys.forEach(subKey => {
      // Check for exceptions to CamelCase vs camelCase naming conventions.
      if (subKey === 'ipv4' || subKey === 'ipv6') {
        result += subKey;
      } else if (subKey === 'apn') {
        result += 'APN';
      } else if (subKey === 'ipAddress') {
        result += 'IPAddress';
      } else if (subKey === 'ipSec') {
        result += 'IPSec';
      } else if (subKey === 'l2tp') {
        result += 'L2TP';
      } else if (subKey === 'modelId') {
        result += 'ModelID';
      } else if (subKey === 'openVpn') {
        result += 'OpenVPN';
      } else if (subKey === 'otp') {
        result += 'OTP';
      } else if (subKey === 'ssid') {
        result += 'SSID';
      } else if (subKey === 'bssid') {
        result += 'BSSID';
      } else if (subKey === 'serverCa') {
        result += 'ServerCA';
      } else if (subKey === 'vpn') {
        result += 'VPN';
      } else if (subKey === 'wifi') {
        result += 'WiFi';
      } else if (subKey === 'iccid') {
        result += 'ICCID';
      } else if (subKey === 'imei') {
        result += 'IMEI';
      } else {
        result += subKey.charAt(0).toUpperCase() + subKey.slice(1);
      }
      result += '-';
    });
    return 'Onc' + result.slice(0, result.length - 1);
  }

  /**
   * @param {string} key The property key.
   * @return {string} The text to display for the property label.
   * @private
   */
  getPropertyLabel_(key) {
    const oncKey = this.getOncKey_(key, this.prefix);
    if (this.i18nExists(oncKey)) {
      return this.i18n(oncKey);
    }
    // We do not provide translations for every possible network property key.
    // For keys specific to a type, strip the type prefix.
    const result = this.prefix + key;
    for (const type of ['cellular', 'ethernet', 'tether', 'vpn', 'wifi']) {
      if (result.startsWith(type + '.')) {
        return result.substr(type.length + 1);
      }
    }
    return result;
  }

  /**
   * Generates a filter function dependent on propertyDict and editFieldTypes.
   * @return {!Object} A filter used by dom-repeat.
   * @private
   */
  computeFilter_() {
    return key => {
      if (this.editFieldTypes.hasOwnProperty(key)) {
        return true;
      }
      const value = this.getPropertyValue_(key);
      return value !== '';
    };
  }

  /**
   * @param {string} key The property key.
   * @return {boolean}
   * @private
   */
  isPropertyEditable_(key) {
    if (!this.propertyDict) {
      return false;
    }
    const property = this.getProperty_(key);
    if (property === undefined || property === null) {
      // Unspecified properties in policy configurations are not user
      // modifiable. https://crbug.com/819837.
      const source = this.propertyDict.source;
      return source !== OncSource.kUserPolicy &&
          source !== OncSource.kDevicePolicy;
    }
    return !this.isNetworkPolicyEnforced(property);
  }

  /**
   * @param {string} key The property key.
   * @return {boolean} True if the edit type for the key is a valid type.
   * @private
   */
  isEditType_(key) {
    const editType = this.editFieldTypes[key];
    return editType === 'String' || editType === 'StringArray' ||
        editType === 'Password';
  }

  /**
   * @param {string} key The property key.
   * @return {boolean}
   * @private
   */
  isEditable_(key) {
    return this.isEditType_(key) && this.isPropertyEditable_(key);
  }

  /**
   * @param {string} key The property key.
   * @return {boolean}
   * @private
   */
  showEditable_(key) {
    return this.isEditable_(key);
  }

  /**
   * @param {string} key The property key.
   * @return {string}
   * @private
   */
  getEditInputType_(key) {
    return this.editFieldTypes[key] === 'Password' ? 'password' : 'text';
  }

  /**
   * @param {string} key The property key.
   * @return {!OncMojo.ManagedProperty|undefined}
   * @private
   */
  getProperty_(key) {
    if (!this.propertyDict) {
      return undefined;
    }
    key = OncMojo.getManagedPropertyKey(key);
    const property = this.get(key, this.propertyDict);
    if (property === null || property === undefined) {
      return undefined;
    }
    return /** @type{!OncMojo.ManagedProperty}*/ (property);
  }

  /**
   * @param {string} key The property key.
   * @return {*} The managed property dictionary associated with |key|.
   * @private
   */
  getIndicatorProperty_(key) {
    if (!this.propertyDict) {
      return undefined;
    }
    const property = this.getProperty_(key);
    if ((property === undefined || property === null) &&
        this.propertyDict.source) {
      const policySource = OncMojo.getEnforcedPolicySourceFromOncSource(
          this.propertyDict.source);
      if (policySource !== PolicySource.kNone) {
        // If the dictionary is policy controlled, provide an empty property
        // object with the network policy source. See https://crbug.com/819837
        // for more info.
        return /** @type{!OncMojo.ManagedProperty} */ ({
          activeValue: '',
          policySource: policySource,
        });
      }
      // Otherwise just return undefined.
    }
    return property;
  }

  /**
   * @param {string} key The property key.
   * @return {string} The text to display for the property value.
   * @private
   */
  getPropertyValue_(key) {
    let value = this.getProperty_(key);
    if (value === undefined || value === null) {
      return '';
    }
    if (typeof value === 'object' && !Array.isArray(value)) {
      // Extract the property from an ONC managed dictionary
      value = OncMojo.getActiveValue(
          /** @type {!OncMojo.ManagedProperty} */ (value));
    }

    if (key === 'wifi.eap.subjectAltNameMatch') {
      return OncMojo.serializeSubjectAltNameMatch(
          /** @type {!Array<!SubjectAltName>} */ (value));
    }

    if (key === 'wifi.eap.domainSuffixMatch') {
      return OncMojo.serializeDomainSuffixMatch(
          /** @type {!Array<string>} */ (value));
    }

    if (Array.isArray(value)) {
      return value.join(', ');
    }

    const customValue = this.getCustomPropertyValue_(key, value);
    if (customValue) {
      return customValue;
    }
    if (typeof value === 'boolean') {
      return value.toString();
    }

    let valueStr;
    if (typeof value === 'number') {
      // Special case typed managed properties.
      if (key === 'cellular.activationState') {
        valueStr = OncMojo.getActivationStateTypeString(
            /** @type {!ActivationStateType}*/ (value));
      } else if (key === 'portalState') {
        valueStr = OncMojo.getPortalStateString(
            /** @type {!PortalState}*/ (value));
      } else if (key === 'vpn.type') {
        valueStr = OncMojo.getVpnTypeString(
            /** @type {!VpnType}*/ (value));
      } else if (key === 'wifi.security') {
        valueStr = OncMojo.getSecurityTypeString(
            /** @type {!SecurityType}*/ (value));
      } else {
        return value.toString();
      }
    } else {
      assert$1(typeof value === 'string');
      valueStr = /** @type {string} */ (value);
    }
    const oncKey = this.getOncKey_(key, this.prefix) + '_' + valueStr;
    if (this.i18nExists(oncKey)) {
      return this.i18n(oncKey);
    }
    return valueStr;
  }

  /**
   * @param {string} key The property key.
   * @return {string} CSS classes to apply to the property value container.
   * @private
   */
  getPropertyValueCssClasses_(key) {
    const classes = ['cr-secondary-text'];
    if (this.getPropertyValue_(key) === FAKE_CREDENTIAL) {
      classes.push('secure');
    }
    return classes.join(' ');
  }

  /**
   * Converts edit field values to the correct edit type.
   * @param {string} key The property key.
   * @param {*} fieldValue The value from the field.
   * @return {*}
   * @private
   */
  getValueFromEditField_(key, fieldValue) {
    const editType = this.editFieldTypes[key];
    if (editType === 'StringArray') {
      return fieldValue.toString().split(/, */);
    }
    return fieldValue;
  }

  /**
   * @param {string} key The property key.
   * @param {*} value The property value.
   * @return {string} The text to display for the property value. If the key
   *     does not correspond to a custom property, an empty string is returned.
   */
  getCustomPropertyValue_(key, value) {
    if (key === 'tether.batteryPercentage') {
      assert$1(typeof value === 'number');
      return this.i18n('OncTether-BatteryPercentage_Value', value.toString());
    }

    if (key === 'tether.signalStrength') {
      assert$1(typeof value === 'number');
      // Possible |signalStrength| values should be from 0 to 100. Add <=
      // checks for robustness.
      if (value === 0) {
        return this.i18n('OncTether-SignalStrength_None');
      }
      if (value <= 25) {
        return this.i18n('OncTether-SignalStrength_Low');
      }
      if (value <= 50) {
        return this.i18n('OncTether-SignalStrength_Medium');
      }
      return this.i18n('OncTether-SignalStrength_Strong');
    }

    if (key === 'tether.carrier') {
      assert$1(typeof value === 'string');
      return (!value || value === 'unknown-carrier') ?
          this.i18n('OncTether-Carrier_Unknown') :
          value;
    }

    return '';
  }
}

customElements.define(
    NetworkPropertyListMojoElement.is, NetworkPropertyListMojoElement);

function getTemplate$2u() {
  return html`<!--_html_template_start_--><style include="network-shared md-select">
  :host {
    --cr-property-box-width: 200px;
  }

  cr-button {
    margin: 4px 0;
  }

  #attachApnPropertyRow {
    display: flex;
    min-height: 0;
    padding-bottom: 20px;
    padding-top: 8px;
    width: var(--cr-property-box-width);
  }

  #attachApnDescription {
    display: flex;
  }

  #attachApnTooltip {
    --cr-icon-size: 16px;
    margin-inline-start: 6px;
  }
</style>
<div class="property-box">
  <div class="start">[[i18n('networkAccessPoint')]]</div>
  <select id="selectApn" class="md-select" on-change="onSelectApnChange_"
      value="[[selectedApn_]]"
      disabled="[[isDisabled_(disabled, selectedApn_)]]"
      aria-label="[[i18n('networkAccessPoint')]]">
    <template is="dom-repeat" items="[[apnSelectList_]]">
      <option value="[[item.name]]">
        [[apnDesc_(item)]]
      </option>
    </template>
  </select>
</div>

<template is="dom-if" if="[[showOtherApn_(selectedApn_)]]">
  <div id="otherApnProperties" class="property-box single-column indented">
    <network-property-list-mojo on-property-change="onOtherApnChange_"
        fields="[[otherApnFields_]]" property-dict="[[otherApn_]]"
        edit-field-types="[[otherApnEditTypes_]]" prefix="cellular.apn."
        disabled="[[disabled]]">
    </network-property-list-mojo>
    <div id="attachApnPropertyRow" class="property-box horizontal center">
      <div id="attachApnDescription" class="start" aria-hidden="true">
        <span id="attachApnTitle">[[i18n('OncCellular-APN-Attach')]]</span>
        <cr-tooltip-icon id="attachApnTooltip" tooltip-position="right"
            icon-class="cr:help-outline"
            tooltip-text="[[i18n('OncCellular-APN-Attach_TooltipText')]]">
        </cr-tooltip-icon>
      </div>
      <cr-toggle id="attachApnControl" aria-labelledby="attachApnTitle"
          aria-describedby="attachApnTooltip"
          checked="{{isAttachApnToggleEnabled_}}"
          disabled="[[disabled]]">
      </cr-toggle>
    </div>
    <cr-button id="saveButton" class="action-button"
        on-click="onSaveOtherTap_" disabled="[[disabled]]">
      [[i18n('save')]]
    </cr-button>
  </div>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const kDefaultAccessPointName = 'NONE';
const kOtherAccessPointName = 'Other';
const USE_ATTACH_APN_ON_SAVE_METRIC_NAME = 'Network.Cellular.Apn.UseAttachApnOnSave';
const NetworkApnListElementBase = I18nMixin(PolymerElement);
class NetworkApnListElement extends NetworkApnListElementBase {
    static get is() {
        return 'network-apnlist';
    }
    static get template() {
        return getTemplate$2u();
    }
    static get properties() {
        return {
            disabled: {
                type: Boolean,
                value: false,
            },
            managedProperties: {
                type: Object,
                observer: 'managedPropertiesChanged',
            },
            /**
             * The name property of the selected APN. If a name property is empty, the
             * accessPointName property will be used. We use 'name' so that multiple
             * APNs with the same accessPointName can be supported, so long as they
             * have a unique 'name' property. This is necessary to allow custom
             * 'other' entries (which are always named 'Other') that match an existing
             * accessPointName but provide a different username/password.
             */
            selectedApn_: {
                type: String,
                value: '',
            },
            /**
             * Selectable list of APN dictionaries for the UI. Includes an entry
             * corresponding to |otherApn| (see below).
             */
            apnSelectList_: {
                type: Array,
                value() {
                    return [];
                },
            },
            /**
             * The user settable properties for a new ('other') APN. The values are
             * set to default and will be set to the currently active APN if it does
             * not match an existing list entry.
             */
            otherApn_: {
                type: Object,
                value() {
                    return {
                        accessPointName: kDefaultAccessPointName,
                        name: kOtherAccessPointName,
                        state: ApnState.kEnabled,
                        authentication: ApnAuthenticationType.kAutomatic,
                        ipType: ApnIpType.kAutomatic,
                        apnTypes: [ApnType.kDefault],
                        source: ApnSource.kUi,
                    };
                },
            },
            /**
             * Array of property names to pass to the Other APN property list.
             */
            otherApnFields_: {
                type: Array,
                value() {
                    return ['accessPointName', 'username', 'password'];
                },
                readOnly: true,
            },
            /**
             * Edit types to pass to the Other APN property list.
             */
            otherApnEditTypes_: {
                type: Object,
                value() {
                    return {
                        'accessPointName': 'String',
                        'username': 'String',
                        'password': 'Password',
                    };
                },
                readOnly: true,
            },
            isAttachApnToggleEnabled_: {
                type: Boolean,
                value: false,
            },
        };
    }
    /*
     * Returns the select APN SelectElement.
     */
    getApnSelect() {
        return this.shadowRoot.querySelector('#selectApn');
    }
    getApnFromManaged(apn) {
        return {
            // authentication and language are ignored in this UI.
            accessPointName: OncMojo.getActiveString(apn.accessPointName),
            localizedName: OncMojo.getActiveString(apn.localizedName),
            name: OncMojo.getActiveString(apn.name),
            password: OncMojo.getActiveString(apn.password),
            username: OncMojo.getActiveString(apn.username),
            authentication: ApnAuthenticationType.kAutomatic,
            // Because this UI is for kApnRevamp=false, these are all default
            // values for fields to pass compilation. None of these fields
            // should be used by CrosNetworkConfig.
            state: ApnState.kEnabled,
            ipType: ApnIpType.kAutomatic,
            apnTypes: [ApnType.kDefault],
            source: ApnSource.kModem,
            id: null,
            language: null,
            attach: null,
        };
    }
    getActiveApnFromProperties(managedProperties) {
        const cellular = managedProperties.typeProperties.cellular;
        assert(cellular);
        let activeApn;
        // We show selectedAPN as the active entry in the select list but it may
        // not correspond to the currently "active" APN which is represented by
        // lastGoodApn.
        if (cellular.selectedApn) {
            activeApn = this.getApnFromManaged(cellular.selectedApn);
        }
        else if (cellular.lastGoodApn && cellular.lastGoodApn.accessPointName) {
            activeApn = cellular.lastGoodApn;
        }
        if (activeApn && !activeApn.accessPointName) {
            activeApn = undefined;
        }
        return activeApn;
    }
    shouldUpdateSelectList(oldManagedProperties) {
        if (!oldManagedProperties) {
            return true;
        }
        const newActiveApn = this.getActiveApnFromProperties(this.managedProperties);
        const oldActiveApn = this.getActiveApnFromProperties(oldManagedProperties);
        if ((newActiveApn && oldActiveApn &&
            !OncMojo.apnMatch(newActiveApn, oldActiveApn)) ||
            (newActiveApn && !oldActiveApn) || (!newActiveApn && oldActiveApn)) {
            return true;
        }
        assert(this.managedProperties);
        const newApnList = this.managedProperties.typeProperties.cellular.apnList;
        const oldApnList = oldManagedProperties.typeProperties.cellular.apnList;
        if (!OncMojo.apnListMatch(oldApnList?.activeValue, newApnList?.activeValue)) {
            return true;
        }
        const newCustomApnList = this.managedProperties.typeProperties.cellular.customApnList;
        const oldCustomApnList = oldManagedProperties.typeProperties.cellular.customApnList;
        if (!OncMojo.apnListMatch(oldCustomApnList, newCustomApnList)) {
            return true;
        }
        return false;
    }
    managedPropertiesChanged(managedProperties, oldManagedProperties) {
        if (!this.shouldUpdateSelectList(oldManagedProperties)) {
            return;
        }
        this.setApnSelectList(this.getActiveApnFromProperties(managedProperties));
    }
    /**
     * Sets the list of selectable APNs for the UI. Appends an 'Other' entry
     * (see comments for |otherApn_| above).
     */
    setApnSelectList(activeApn) {
        const apnList = this.generateApnList();
        if (apnList === undefined || apnList.length === 0) {
            // Show other APN when no APN list property is available.
            this.apnSelectList_ = [this.otherApn_];
            this.set('selectedApn_', kOtherAccessPointName);
            return;
        }
        // Get the list entry for activeApn if it exists. It will have 'name' set.
        let activeApnInList;
        if (activeApn) {
            activeApnInList = apnList.find(a => a.name === activeApn.name);
        }
        assert(this.managedProperties);
        assert(this.managedProperties.typeProperties.cellular);
        const customApnList = this.managedProperties.typeProperties.cellular.customApnList;
        let otherApn = this.otherApn_;
        if (customApnList && customApnList.length) {
            // If custom apn list exists, then use it's first entry as otherApn.
            otherApn = customApnList[0];
        }
        else if (!activeApnInList && activeApn && activeApn.accessPointName) {
            // If the active APN is not in the list, copy it to otherApn.
            otherApn = activeApn;
        }
        this.isAttachApnToggleEnabled_ =
            otherApn.attach === OncMojo.USE_ATTACH_APN_NAME;
        this.otherApn_ = {
            accessPointName: otherApn.accessPointName,
            name: otherApn.name,
            username: otherApn.username,
            password: otherApn.password,
            authentication: ApnAuthenticationType.kAutomatic,
            // Because this UI is for kApnRevamp=false, these are all default
            // values for fields to pass compilation. None of these fields
            // should be used by CrosNetworkConfig.
            state: ApnState.kEnabled,
            ipType: ApnIpType.kAutomatic,
            apnTypes: [ApnType.kDefault],
            source: ApnSource.kUi,
            id: otherApn.id,
            language: otherApn.language,
            localizedName: otherApn.localizedName,
            attach: otherApn.attach,
        };
        apnList.push(this.otherApn_);
        this.apnSelectList_ = apnList;
        const selectedApn = activeApnInList ? activeApnInList.name : kOtherAccessPointName;
        assert(selectedApn);
        this.set('selectedApn_', selectedApn);
        // Wait for the dom-repeat to populate the <option> entries then explicitly
        // set the selected value.
        this.setSelectedApn();
    }
    async setSelectedApn() {
        this.getApnSelect().value = this.selectedApn_;
    }
    /**
     * Returns a modified copy of the APN properties or undefined if the
     * property is not set. All entries in the returned copy will have nonempty
     * name and accessPointName properties.
     */
    generateApnList() {
        if (!this.managedProperties) {
            return undefined;
        }
        assert(this.managedProperties.typeProperties.cellular);
        const apnList = this.managedProperties.typeProperties.cellular.apnList;
        if (!apnList) {
            return undefined;
        }
        return apnList.activeValue.filter(apn => !!apn.accessPointName).map(apn => {
            return {
                accessPointName: apn.accessPointName,
                localizedName: apn.localizedName,
                name: apn.name || apn.accessPointName,
                username: apn.username,
                password: apn.password,
                id: apn.id,
                authentication: apn.authentication,
                language: apn.language,
                attach: apn.attach,
                state: apn.state,
                ipType: apn.ipType,
                apnTypes: apn.apnTypes,
                source: apn.source,
            };
        });
    }
    /**
     * Event triggered when the selectApn selection changes.
     */
    onSelectApnChange_(event) {
        const target = (event.target);
        const name = target.value;
        // When selecting 'Other', don't send a change event unless a valid
        // non-default value has been set for Other.
        if (name === kOtherAccessPointName &&
            (!this.otherApn_.accessPointName ||
                this.otherApn_.accessPointName === kDefaultAccessPointName)) {
            this.selectedApn_ = name;
            return;
        }
        // The change will generate an update which will update selectedApn_ and
        // refresh the UI.
        this.sendApnChange(name);
    }
    /**
     * Event triggered when any 'Other' APN network property changes.
     */
    onOtherApnChange_(event) {
        // TODO(benchan/stevenjb): Move the toUpperCase logic to shill or
        // onc_translator_onc_to_shill.cc.
        const value = (event.detail.field === 'accessPointName') ?
            event.detail.value.toUpperCase() :
            event.detail.value;
        this.set('otherApn_.' + event.detail.field, value);
        // Don't send a change event for 'Other' until the 'Save' button is tapped.
    }
    /**
     * Event triggered when the Other APN 'Save' button is tapped.
     */
    onSaveOtherTap_() {
        if (this.sendApnChange(this.selectedApn_)) {
            chrome.metricsPrivate.recordBoolean(USE_ATTACH_APN_ON_SAVE_METRIC_NAME, this.isAttachApnToggleEnabled_);
        }
    }
    /**
     * Attempts to send the apn-change event. Returns true if it succeeds.
     * @param name The APN name property.
     */
    sendApnChange(name) {
        let apn;
        if (name === kOtherAccessPointName) {
            if (!this.otherApn_.accessPointName ||
                this.otherApn_.accessPointName === kDefaultAccessPointName) {
                // No valid APN set, do nothing.
                return false;
            }
            apn = {
                accessPointName: this.otherApn_.accessPointName,
                username: this.otherApn_.username,
                password: this.otherApn_.password,
                attach: this.isAttachApnToggleEnabled_ ? OncMojo.USE_ATTACH_APN_NAME :
                    '',
                id: null,
                authentication: ApnAuthenticationType.kAutomatic,
                language: null,
                localizedName: null,
                name: null,
                state: ApnState.kEnabled,
                ipType: ApnIpType.kAutomatic,
                apnTypes: [ApnType.kDefault],
                source: ApnSource.kUi,
            };
        }
        else {
            apn = this.apnSelectList_.find(a => a.name === name);
            if (apn === undefined) {
                // Potential edge case if an update is received before this is invoked.
                console.error('Selected APN not in list');
                return false;
            }
        }
        // Add required field with a default value since it's unused when
        // kApnRevamp=false.
        apn.apnTypes = [ApnType.kDefault];
        this.dispatchEvent(new CustomEvent('apn-change', { detail: apn }));
        return true;
    }
    isDisabled_() {
        return this.disabled || this.selectedApn_ === '';
    }
    showOtherApn_() {
        return this.selectedApn_ === kOtherAccessPointName;
    }
    apnDesc_(apn) {
        assert(apn.name);
        return apn.localizedName || apn.name;
    }
    isApnItemSelected(item) {
        return item.accessPointName === this.selectedApn_;
    }
}
customElements.define(NetworkApnListElement.is, NetworkApnListElement);

function getTemplate$2t() {
  return html`<!--_html_template_start_--><style include="cr-shared-style network-shared md-select iron-flex">
  /* Leave some space between button and select. */
  select {
    margin-inline-start: 8px;
  }
</style>
<div class="property-box first two-line">
  <div class="flex layout vertical">
    <div>[[i18n('networkChooseMobile')]]</div>
    <div class="cr-secondary-text">
      [[getSecondaryText_(managedProperties, deviceState)]]
    </div>
  </div>
  <cr-button on-click="onScanTap_"
      disabled="[[!getEnableScanButton_(managedProperties,
          deviceState, disabled)]]">
    [[i18n('networkCellularScan')]]
  </cr-button>
  <select class="md-select" on-change="onChange_"
      value="[[selectedMobileNetworkId_]]"
      disabled="[[!getEnableSelectNetwork_(managedProperties,
          deviceState, disabled)]]"
      aria-label="[[i18n('networkChooseMobile')]]">
    <template is="dom-repeat" items="[[mobileNetworkList_]]">
      <option value="[[item.networkId]]"
          disabled="[[getMobileNetworkIsDisabled_(item)]]">
        [[getName_(item)]]
      </option>
    </template>
  </select>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Polymer element for displaying and modifying a list of cellular
 * mobile networks.
 */
const NetworkChooseMobileElementBase = I18nMixin(PolymerElement);
class NetworkChooseMobileElement extends NetworkChooseMobileElementBase {
    constructor() {
        super(...arguments);
        this.networkConfig_ = null;
        this.scanRequested_ = false;
    }
    static get is() {
        return 'network-choose-mobile';
    }
    static get template() {
        return getTemplate$2t();
    }
    static get properties() {
        return {
            deviceState: {
                type: Object,
                value: null,
            },
            disabled: {
                type: Boolean,
                value: false,
            },
            managedProperties: {
                type: Object,
                observer: 'managedPropertiesChanged_',
            },
            /**
             * The mojom.FoundNetworkProperties.networkId of the selected mobile
             * network.
             */
            selectedMobileNetworkId_: {
                type: String,
                value: '',
            },
            /**
             * Selectable list of mojom.FoundNetworkProperties dictionaries for the
             * UI.
             */
            mobileNetworkList_: {
                type: Array,
                value() {
                    return [];
                },
            },
        };
    }
    connectedCallback() {
        super.connectedCallback();
        this.scanRequested_ = false;
    }
    getNetworkConfig_() {
        if (!this.networkConfig_) {
            this.networkConfig_ =
                MojoInterfaceProviderImpl.getInstance().getMojoServiceRemote();
        }
        return this.networkConfig_;
    }
    managedPropertiesChanged_() {
        assert(this.managedProperties);
        const cellular = this.managedProperties.typeProperties.cellular;
        assert(cellular);
        this.mobileNetworkList_ = cellular.foundNetworks || [];
        if (!this.mobileNetworkList_.length) {
            this.mobileNetworkList_ = [{
                    status: '',
                    networkId: 'none',
                    technology: '',
                    longName: this.i18n('networkCellularNoNetworks'),
                    shortName: null,
                }];
        }
        // Set selectedMobileNetworkId_ after the dom-repeat has been stamped.
        microTask.run(() => {
            let selected = this.mobileNetworkList_.find((mobileNetwork) => {
                return mobileNetwork.status === 'current';
            });
            if (!selected) {
                selected = this.mobileNetworkList_[0];
            }
            this.selectedMobileNetworkId_ = selected.networkId;
        });
    }
    getMobileNetworkIsDisabled_(foundNetwork) {
        return foundNetwork.status !== 'available' &&
            foundNetwork.status !== 'current';
    }
    getEnableScanButton_(properties) {
        return !this.disabled &&
            properties.connectionState === ConnectionStateType.kNotConnected &&
            !!this.deviceState && !this.deviceState.scanning;
    }
    getEnableSelectNetwork_(properties) {
        assert(properties.typeProperties.cellular);
        return (!this.disabled && !!this.deviceState && !this.deviceState.scanning &&
            properties.connectionState === ConnectionStateType.kNotConnected &&
            !!properties.typeProperties.cellular.foundNetworks &&
            properties.typeProperties.cellular.foundNetworks.length > 0);
    }
    getSecondaryText_(properties) {
        if (!properties) {
            return '';
        }
        if (this.deviceState?.scanning) {
            return this.i18n('networkCellularScanning');
        }
        if (this.scanRequested_) {
            return this.i18n('networkCellularScanCompleted');
        }
        if (properties.connectionState !== ConnectionStateType.kNotConnected) {
            return this.i18n('networkCellularScanConnectedHelp');
        }
        return '';
    }
    getName_(foundNetwork) {
        return foundNetwork.longName || foundNetwork.shortName ||
            foundNetwork.networkId;
    }
    /**
     * Request a Cellular scan to populate the list of networks. This will trigger
     * a change to managedProperties when completed (if Cellular.FoundNetworks
     * changes).
     */
    onScanTap_() {
        this.scanRequested_ = true;
        this.getNetworkConfig_().requestNetworkScan(NetworkType.kCellular);
    }
    onChange_(event) {
        const target = event.target;
        assert(target instanceof HTMLSelectElement);
        if (!target.value || target.value === 'none') {
            return;
        }
        assert(this.managedProperties);
        this.getNetworkConfig_().selectCellularMobileNetwork(this.managedProperties.guid, target.value);
    }
}
customElements.define(NetworkChooseMobileElement.is, NetworkChooseMobileElement);

function getTemplate$2s() {
  return html`<!--_html_template_start_--><style include="network-shared iron-flex">
  cr-toggle {
    margin-inline-start: var(--settings-control-label-spacing);
  }
</style>
<template is="dom-if" if="[[shouldShowAutoIpConfigToggle_]]" restamp>
  <div id="autoConfig" class="property-box">
    <div id="autoIPConfigLabel" class="start">
      [[i18n('networkIPConfigAuto')]]
    </div>
    <cr-policy-indicator indicator-type="[[getPolicyIndicatorType(
        managedProperties.ipAddressConfigType)]]">
    </cr-policy-indicator>
    <cr-toggle id="autoConfigIpToggle" checked="{{automatic_}}"
        disabled="[[!canChangeIPConfigType_(managedProperties, disabled)]]"
        on-change="onAutomaticChange_"
        aria-labelledby="autoIPConfigLabel">
    </cr-toggle>
  </div>
</template>
<template is="dom-if" if="[[hasIpConfigFields_(ipConfig_, ipConfig_.*)]]">
  <div class$="[[getFieldsClassList_(shouldShowAutoIpConfigToggle_)]]">
    <network-property-list-mojo fields="[[ipConfigFields_]]"
        all-fields-read-only="[[automatic_]]"
        property-dict="[[ipConfig_]]"
        edit-field-types="[[getIPEditFields_(automatic_,
            managedProperties)]]"
        on-property-change="onIPChange_"
        disabled="[[disabled]]">
    </network-property-list-mojo>
  </div>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Polymer element for displaying the IP Config properties for
 * a network state.
 */
/**
 * Returns the routing prefix as a string for a given prefix length. If
 * |prefixLength| is invalid, returns undefined.
 * @param prefixLength The ONC routing prefix length.
 */
const getRoutingPrefixAsNetmask = function (prefixLength) {
    // Return the empty string for invalid inputs.
    if (prefixLength <= 0 || prefixLength > 32) {
        return null;
    }
    let netmask = '';
    for (let i = 0; i < 4; ++i) {
        let remainder = 8;
        if (prefixLength >= 8) {
            prefixLength -= 8;
        }
        else {
            remainder = prefixLength;
            prefixLength = 0;
        }
        if (i > 0) {
            netmask += '.';
        }
        let value = 0;
        if (remainder !== 0) {
            value = ((2 << (remainder - 1)) - 1) << (8 - remainder);
        }
        netmask += value.toString();
    }
    return netmask;
};
/**
 * Returns the routing prefix length as a number from the netmask string.
 * @param netmask The netmask string, e.g. 255.255.255.0.
 */
const getRoutingPrefixAsLength = function (netmask) {
    if (!netmask) {
        return NO_ROUTING_PREFIX;
    }
    const tokens = netmask.split('.');
    if (tokens.length !== 4) {
        return NO_ROUTING_PREFIX;
    }
    let prefixLength = 0;
    for (let i = 0; i < tokens.length; ++i) {
        const token = tokens[i];
        // If we already found the last mask and the current one is not
        // '0' then the netmask is invalid. For example, 255.224.255.0
        if (prefixLength / 8 !== i) {
            if (token !== '0') {
                return NO_ROUTING_PREFIX;
            }
        }
        else if (token === '255') {
            prefixLength += 8;
        }
        else if (token === '254') {
            prefixLength += 7;
        }
        else if (token === '252') {
            prefixLength += 6;
        }
        else if (token === '248') {
            prefixLength += 5;
        }
        else if (token === '240') {
            prefixLength += 4;
        }
        else if (token === '224') {
            prefixLength += 3;
        }
        else if (token === '192') {
            prefixLength += 2;
        }
        else if (token === '128') {
            prefixLength += 1;
        }
        else if (token === '0') {
            prefixLength += 0;
        }
        else {
            // mask is not a valid number.
            return NO_ROUTING_PREFIX;
        }
    }
    return prefixLength;
};
const NetworkIpConfigElementBase = mixinBehaviors([CrPolicyNetworkBehaviorMojo], I18nMixin(PolymerElement));
class NetworkIpConfigElement extends NetworkIpConfigElementBase {
    static get is() {
        return 'network-ip-config';
    }
    static get template() {
        return getTemplate$2s();
    }
    static get properties() {
        return {
            disabled: {
                type: Boolean,
                value: false,
            },
            managedProperties: {
                type: Object,
                observer: 'managedPropertiesChanged_',
            },
            /**
             * State of 'Configure IP Addresses Automatically'.
             */
            automatic_: {
                type: Boolean,
                value: true,
            },
            /**
             * The currently visible IP Config property dictionary.
             */
            ipConfig_: Object,
            /**
             * Array of properties to pass to the property list.
             */
            ipConfigFields_: {
                type: Array,
                value() {
                    return [
                        'ipv4.ipAddress',
                        'ipv4.netmask',
                        'ipv4.gateway',
                        'ipv6.ipAddress',
                    ];
                },
                readOnly: true,
            },
            /**
             * True if automatically-configured IP address toggle should be visible.
             */
            shouldShowAutoIpConfigToggle_: {
                type: Boolean,
                value: true,
                computed: 'computeShouldShowAutoIpConfigToggle_(managedProperties)',
            },
        };
    }
    constructor() {
        super();
        /**
         * Saved static IP configuration properties when switching to 'automatic'.
         */
        this.savedStaticIp_ = undefined;
    }
    /**
     * Returns the automatically configure IP CrToggleElement.
     */
    getAutoConfigIpToggle() {
        return this.shadowRoot.querySelector('#autoConfigIpToggle');
    }
    managedPropertiesChanged_(newValue, oldValue) {
        if (!this.managedProperties) {
            return;
        }
        const properties = this.managedProperties;
        if (newValue && newValue.guid !== (oldValue && oldValue.guid)) {
            this.savedStaticIp_ = undefined;
        }
        // Update the 'automatic' property.
        const ipConfigType = OncMojo.getActiveValue(properties.ipAddressConfigType);
        this.automatic_ = ipConfigType !== 'Static';
        if (properties.ipConfigs || properties.staticIpConfig) {
            if (this.automatic_ || !oldValue ||
                (newValue && newValue.guid !== (oldValue && oldValue.guid)) ||
                !OncMojo.connectionStateIsConnected(properties.connectionState)) {
                // Update the 'ipConfig' property.
                const ipv4 = this.getIPConfigUIProperties_(OncMojo.getIPConfigForType(properties, IPConfigType.kIPv4));
                let ipv6 = this.getIPConfigUIProperties_(OncMojo.getIPConfigForType(properties, IPConfigType.kIPv6));
                // If connected and the IP address is automatic and set, show message if
                // the ipv6 address is not set.
                if (OncMojo.connectionStateIsConnected(properties.connectionState) &&
                    this.automatic_ && ipv4 && ipv4.ipAddress) {
                    ipv6 = ipv6 || {
                        type: IPConfigType.kIPv6,
                        gateway: null,
                        ipAddress: null,
                        nameServers: null,
                        netmask: null,
                        webProxyAutoDiscoveryUrl: null,
                    };
                    if (ipv6) {
                        ipv6.ipAddress =
                            ipv6.ipAddress || this.i18n('ipAddressNotAvailable');
                    }
                }
                this.ipConfig_ = { ipv4: ipv4, ipv6: ipv6 };
            }
        }
        else {
            this.ipConfig_ = undefined;
        }
    }
    /**
     * Checks whether IP address config type can be changed.
     */
    canChangeIPConfigType_(managedProperties) {
        if (this.disabled || !managedProperties) {
            return false;
        }
        if (managedProperties.type === NetworkType.kCellular) {
            // Cellular IP config properties can not be changed.
            return false;
        }
        const ipConfigType = managedProperties.ipAddressConfigType;
        return !ipConfigType || !this.isNetworkPolicyEnforced(ipConfigType);
    }
    /**
     * Overrides null values of this.ipConfig_.ipv4 with defaults so that
     * this.ipConfig_.ipv4 passes validation after being converted to ONC
     * StaticIPConfig.
     * TODO(https://crbug.com/1148841): Setting defaults here is strange, find
     * some better way.
     */
    setIpv4Defaults_() {
        if (!this.ipConfig_ || !this.ipConfig_.ipv4) {
            return;
        }
        if (!this.ipConfig_.ipv4.gateway) {
            this.set('ipConfig_.ipv4.gateway', '192.168.1.1');
        }
        if (!this.ipConfig_.ipv4.ipAddress) {
            this.set('ipConfig_.ipv4.ipAddress', '192.168.1.1');
        }
        if (!this.ipConfig_.ipv4.netmask) {
            this.set('ipConfig_.ipv4.netmask', '255.255.255.0');
        }
    }
    onAutomaticChange_() {
        if (!this.automatic_) {
            if (!this.ipConfig_) {
                this.ipConfig_ = { ipv4: undefined, ipv6: undefined };
            }
            if (this.savedStaticIp_) {
                this.ipConfig_.ipv4 = this.savedStaticIp_;
            }
            if (!this.ipConfig_.ipv4) {
                this.ipConfig_.ipv4 = {
                    type: IPConfigType.kIPv4,
                    gateway: null,
                    ipAddress: null,
                    nameServers: null,
                    netmask: null,
                    webProxyAutoDiscoveryUrl: null,
                };
            }
            this.setIpv4Defaults_();
            this.sendStaticIpConfig_();
            return;
        }
        // Save the static IP configuration when switching to automatic.
        if (this.ipConfig_) {
            this.savedStaticIp_ = this.ipConfig_.ipv4;
        }
        this.dispatchEvent(new CustomEvent('ip-change', {
            bubbles: true,
            composed: true,
            detail: { field: 'ipAddressConfigType', value: 'DHCP' },
        }));
    }
    /**
     * Returns a new IPConfigUIProperties object with routingPrefix expressed as a
     * netmask string instead of a prefix length. Returns undefined if
     * |ipconfig| is not defined.
     *
     */
    getIPConfigUIProperties_(ipconfig) {
        if (!ipconfig) {
            return undefined;
        }
        // Copy |ipconfig| properties into |ipconfigUI|.
        const ipconfigUI = {
            gateway: ipconfig.gateway,
            ipAddress: ipconfig.ipAddress,
            nameServers: ipconfig.nameServers,
            type: ipconfig.type,
            webProxyAutoDiscoveryUrl: ipconfig.webProxyAutoDiscoveryUrl,
            netmask: ipconfig.routingPrefix !== NO_ROUTING_PREFIX ?
                getRoutingPrefixAsNetmask(ipconfig.routingPrefix) :
                null,
        };
        return ipconfigUI;
    }
    /**
     * Returns a new IPConfigProperties object with netmask expressed as a
     * prefix length.
     */
    getIPConfigProperties_(ipconfigUI) {
        const ipconfig = {
            gateway: ipconfigUI.gateway,
            ipAddress: ipconfigUI.ipAddress,
            nameServers: ipconfigUI.nameServers,
            routingPrefix: getRoutingPrefixAsLength(ipconfigUI.netmask),
            type: ipconfigUI.type,
            webProxyAutoDiscoveryUrl: ipconfigUI.webProxyAutoDiscoveryUrl,
            excludedRoutes: null,
            includedRoutes: null,
            searchDomains: null,
        };
        return ipconfig;
    }
    hasIpConfigFields_() {
        if (!this.ipConfig_) {
            return false;
        }
        for (let i = 0; i < this.ipConfigFields_.length; ++i) {
            const key = this.ipConfigFields_[i];
            const value = this.get(key, this.ipConfig_);
            if (value !== undefined && value !== '') {
                return true;
            }
        }
        return false;
    }
    /**
     * Returns an edit type to be used in network-property-list.
     */
    getIPFieldEditType_(property) {
        return this.isNetworkPolicyEnforced(property) ? undefined : 'String';
    }
    /**
     * Returns an object with the edit type for each editable field.
     */
    getIPEditFields_() {
        const staticIpConfig = this.managedProperties && this.managedProperties.staticIpConfig;
        if (this.automatic_ || !staticIpConfig) {
            return {};
        }
        return {
            'ipv4.ipAddress': this.getIPFieldEditType_(staticIpConfig.ipAddress),
            // Use routingPrefix instead of netmask because getIPFieldEditType_
            // expects a ManagedProperty and routingPrefix has the same type as
            // netmask.
            'ipv4.netmask': this.getIPFieldEditType_(staticIpConfig.routingPrefix),
            'ipv4.gateway': this.getIPFieldEditType_(staticIpConfig.gateway),
        };
    }
    /**
     * Event triggered when the network property list changes.
     */
    onIPChange_(event) {
        if (!this.ipConfig_) {
            return;
        }
        const field = event.detail.field;
        const value = event.detail.value;
        // Note: |field| includes the 'ipv4.' prefix.
        this.set('ipConfig_.' + field, value);
        this.sendStaticIpConfig_();
    }
    sendStaticIpConfig_() {
        // This will also set IPAddressConfigType to STATIC.
        this.dispatchEvent(new CustomEvent('ip-change', {
            bubbles: true,
            composed: true,
            detail: {
                field: 'staticIpConfig',
                value: this.ipConfig_ && this.ipConfig_.ipv4 ?
                    this.getIPConfigProperties_(this.ipConfig_.ipv4) :
                    {},
            },
        }));
    }
    computeShouldShowAutoIpConfigToggle_() {
        if (this.managedProperties &&
            this.managedProperties.type === NetworkType.kCellular) {
            return false;
        }
        return true;
    }
    getFieldsClassList_() {
        let classes = 'property-box single-column stretch';
        if (this.shouldShowAutoIpConfigToggle_) {
            classes += ' indented';
        }
        return classes;
    }
}
customElements.define(NetworkIpConfigElement.is, NetworkIpConfigElement);

function getTemplate$2r() {
  return html`<!--_html_template_start_--><style include="network-shared md-select iron-flex">
  a {
    margin-inline-start: 4px;
  }

  cr-input {
    margin-bottom: 4px;
    /* Aligns with the start of cr-radio-button's text. */
    margin-inline-start: 38px;
  }

  cr-radio-group {
    --cr-radio-group-item-padding: 12px;
    width: 100%;
  }

  .nameservers {
    /* Aligns with the start of cr-radio-button's text. */
    margin-inline-start: 38px;
    padding-bottom: 0;
    padding-top: 0;
  }

  .nameservers:not([changeable]) {
    opacity: var(--cr-disabled-opacity);
  }

  #radioGroupDiv {
    align-items: center;
    display: block;
    padding-inline-end: var(--cr-section-padding);
    padding-inline-start: var(--cr-section-padding);
  }

  cr-policy-indicator {
    /* Aligns with the other policy indicators. */
    margin-inline-end: calc(var(--settings-control-label-spacing) + 34px);
  }
</style>

<div class="property-box">
  <div class="start">
    [[i18n('networkNameservers')]]
  </div>
  <cr-policy-indicator indicator-type="[[getPolicyIndicatorType(
      managedProperties.nameServersConfigType)]]">
  </cr-policy-indicator>
</div>
<div id="radioGroupDiv">
  <cr-radio-group id="nameserverType" class="layout vertical"
      selected="[[nameserversType_]]"
      on-selected-changed="onTypeChange_"
      aria-label="[[i18n('networkNameservers')]]"
      disabled="[[disabled]]">
    <!-- Automatic nameservers -->
    <cr-radio-button name="[[nameserversTypeEnum_.AUTOMATIC]]"
      disabled="[[!canChangeConfigType_]]">
      [[i18n('networkNameserversAutomatic')]]
    </cr-radio-button>
    <template is="dom-if" if="[[showNameservers_(nameserversType_,
        nameserversTypeEnum_.AUTOMATIC, nameservers_)]]">
      <div class="nameservers" changeable$="[[canChangeConfigType_]]">
        [[getNameserversString_(nameservers_)]]
      </div>
    </template>

    <!-- Google nameservers -->
    <cr-radio-button name="[[nameserversTypeEnum_.GOOGLE]]"
      disabled="[[!canChangeConfigType_]]">
      [[i18n('networkNameserversGoogle')]]
      <template is="dom-if"
          if="[[i18nExists('networkGoogleNameserversLearnMoreUrl')]]">
        <a href="[[i18n('networkGoogleNameserversLearnMoreUrl')]]"
            target="_blank" on-click="doNothing_">
          [[i18n('networkNameserversLearnMore')]]
        </a>
      </template>
    </cr-radio-button>
    <template is="dom-if" if="[[showNameservers_(nameserversType_,
        nameserversTypeEnum_.GOOGLE, nameservers_)]]">
      <div class="nameservers" changeable$="[[canChangeConfigType_]]">
        [[getNameserversString_(nameservers_)]]
      </div>
    </template>

    <!-- Custom nameservers -->
    <cr-radio-button name="[[nameserversTypeEnum_.CUSTOM]]"
      disabled="[[!canChangeConfigType_]]">
      [[i18n('networkNameserversCustom')]]
    </cr-radio-button>
    <template is="dom-if" if="[[showNameservers_(nameserversType_,
        nameserversTypeEnum_.CUSTOM)]]">
      <div class="property-box single-column two-line">
        <template is="dom-repeat" items="[[nameservers_]]">
          <cr-input id="nameserver[[index]]" value="{{item}}"
              aria-label="[[getCustomNameServerInputA11yLabel_(index)]]"
              on-change="onValueChange_"
              disabled="[[!canEditCustomNameServers_(nameserversType_,
                  managedProperties)]]">
          </cr-input>
        </template>
      </div>
    </template>
  </cr-radio-group>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Polymer element for displaying network nameserver options.
 */
/**
 * UI configuration options for nameservers.
 */
var NameserversType;
(function (NameserversType) {
    NameserversType["AUTOMATIC"] = "automatic";
    NameserversType["CUSTOM"] = "custom";
    NameserversType["GOOGLE"] = "google";
})(NameserversType || (NameserversType = {}));
const GOOGLE_NAMESERVERS = [
    '8.8.4.4',
    '8.8.8.8',
];
const EMPTY_NAMESERVER = '0.0.0.0';
const MAX_NAMESERVERS = 4;
const NetworkNameserversElementBase = mixinBehaviors([CrPolicyNetworkBehaviorMojo], I18nMixin(PolymerElement));
class NetworkNameserversElement extends NetworkNameserversElementBase {
    constructor() {
        super(...arguments);
        // Saved nameservers from the NameserversType.CUSTOM tab. If this is empty, it
        // that the user has not entered any custom nameservers yet.
        this.nameservers_ = [];
        this.nameserversType_ = NameserversType.AUTOMATIC;
        this.googleNameserversText_ = this.i18nAdvanced('networkNameserversGoogle', { substitutions: [], tags: ['a'] })
            .toString();
        this.savedCustomNameservers_ = [];
        // The last manually performed selection of the nameserver type. If this is
        // null, no explicit selection has been done for this network yet.
        this.savedNameserversType_ = null;
    }
    static get is() {
        return 'network-nameservers';
    }
    static get template() {
        return getTemplate$2r();
    }
    static get properties() {
        return {
            disabled: {
                type: Boolean,
                value: false,
            },
            managedProperties: {
                type: Object,
                observer: 'managedPropertiesChanged_',
            },
            /**
             * Array of nameserver addresses stored as strings.
             */
            nameservers_: {
                type: Array,
            },
            /**
             * The selected nameserver type.
             */
            nameserversType_: {
                type: String,
            },
            /**
             * Enum values for |nameserversType_|.
             */
            nameserversTypeEnum_: {
                readOnly: true,
                type: Object,
                value: NameserversType,
            },
            googleNameserversText_: {
                type: String,
            },
            canChangeConfigType_: {
                type: Boolean,
                computed: 'computeCanChangeConfigType_(managedProperties)',
            },
        };
    }
    /*
     * Returns the nameserver type CrRadioGroupElement.
     */
    getNameserverRadioButtons() {
        return this.shadowRoot.querySelector('#nameserverType');
    }
    /**
     * Returns true if the nameservers in |nameservers1| match the nameservers in
     * |nameservers2|, ignoring order and empty / 0.0.0.0 entries.
     */
    nameserversMatch_(nameservers1, nameservers2) {
        const nonEmptySortedNameservers1 = this.clearEmptyNameServers_(nameservers1).sort();
        const nonEmptySortedNameservers2 = this.clearEmptyNameServers_(nameservers2).sort();
        if (nonEmptySortedNameservers1.length !==
            nonEmptySortedNameservers2.length) {
            return false;
        }
        for (let i = 0; i < nonEmptySortedNameservers1.length; i++) {
            if (nonEmptySortedNameservers1[i] !== nonEmptySortedNameservers2[i]) {
                return false;
            }
        }
        return true;
    }
    /**
     * Returns true if |nameservers| contains any all google nameserver entries
     * and only google nameserver entries or empty entries.
     */
    isGoogleNameservers_(nameservers) {
        return this.nameserversMatch_(nameservers, GOOGLE_NAMESERVERS);
    }
    /**
     * Returns the nameservers enforced by policy. If nameservers are not being
     * enforced, returns null.
     */
    getPolicyEnforcedNameservers_() {
        const staticIpConfig = this.managedProperties && this.managedProperties.staticIpConfig;
        if (!staticIpConfig || !staticIpConfig.nameServers) {
            return null;
        }
        return this.getEnforcedPolicyValue(staticIpConfig.nameServers);
    }
    /**
     * Returns the nameservers recommended by policy. If nameservers are not being
     * recommended, returns null. Note: also returns null if nameservers are being
     * enforced by policy.
     */
    getPolicyRecommendedNameservers_() {
        const staticIpConfig = this.managedProperties && this.managedProperties.staticIpConfig;
        if (!staticIpConfig || !staticIpConfig.nameServers) {
            return null;
        }
        return this.getRecommendedPolicyValue(staticIpConfig.nameServers);
    }
    managedPropertiesChanged_(newValue, oldValue) {
        if (!this.managedProperties) {
            return;
        }
        if (!oldValue || newValue.guid !== oldValue.guid) {
            this.savedCustomNameservers_ = [];
            this.savedNameserversType_ = null;
        }
        // Update the 'nameservers' property.
        let nameservers = [];
        const ipv4 = OncMojo.getIPConfigForType(this.managedProperties, IPConfigType.kIPv4);
        if (ipv4 && ipv4.nameServers) {
            nameservers = ipv4.nameServers.slice();
        }
        // Update the 'nameserversType' property.
        const configType = OncMojo.getActiveValue(this.managedProperties.nameServersConfigType);
        let nameserversType;
        if (configType === 'Static') {
            if (this.isGoogleNameservers_(nameservers) &&
                this.savedNameserversType_ !== NameserversType.CUSTOM) {
                nameserversType = NameserversType.GOOGLE;
                nameservers = GOOGLE_NAMESERVERS; // Use consistent order.
            }
            else {
                nameserversType = NameserversType.CUSTOM;
            }
        }
        else {
            nameserversType = NameserversType.AUTOMATIC;
            nameservers = this.clearEmptyNameServers_(nameservers);
        }
        // When a network is connected, we receive connection strength updates and
        // that prevents users from making any custom updates to network
        // nameservers. These below conditions allow connection strength updates to
        // be applied only if network is not connected or if nameservers type is set
        // to auto or if we are receiving the update for the first time.
        if (nameserversType !== NameserversType.CUSTOM || !oldValue ||
            newValue.guid !== (oldValue && oldValue.guid) ||
            !OncMojo.connectionStateIsConnected(this.managedProperties.connectionState)) {
            this.setNameservers_(nameserversType, nameservers, false /* send */);
        }
    }
    /**
     * @param sendNameservers If true, send the nameservers once they have been
     *     set in the UI.
     */
    setNameservers_(nameserversType, nameservers, sendNameservers) {
        if (nameserversType === NameserversType.CUSTOM) {
            // Add empty entries for unset custom nameservers.
            for (let i = nameservers.length; i < MAX_NAMESERVERS; ++i) {
                nameservers[i] = EMPTY_NAMESERVER;
            }
        }
        else {
            nameservers = this.clearEmptyNameServers_(nameservers);
        }
        this.nameservers_ = nameservers;
        this.nameserversType_ = nameserversType;
        if (sendNameservers) {
            this.sendNameServers_();
        }
    }
    /**
     * @return True if the nameservers config type type can be changed.
     */
    computeCanChangeConfigType_(managedProperties) {
        if (!managedProperties) {
            return false;
        }
        if (this.isNetworkPolicyEnforced(managedProperties.nameServersConfigType)) {
            return false;
        }
        return true;
    }
    /**
     * @return True if the nameservers are editable.
     */
    canEditCustomNameServers_(nameserversType, managedProperties) {
        if (!managedProperties) {
            return false;
        }
        if (nameserversType !== NameserversType.CUSTOM) {
            return false;
        }
        if (this.isNetworkPolicyEnforced(managedProperties.nameServersConfigType)) {
            return false;
        }
        if (managedProperties.staticIpConfig &&
            managedProperties.staticIpConfig.nameServers &&
            this.isNetworkPolicyEnforced(managedProperties.staticIpConfig.nameServers)) {
            return false;
        }
        return true;
    }
    showNameservers_(nameserversType, buttonNameserverstype, nameservers) {
        if (nameserversType !== buttonNameserverstype) {
            return false;
        }
        return buttonNameserverstype === NameserversType.CUSTOM ||
            nameservers.length > 0;
    }
    getNameserversString_(nameservers) {
        return nameservers.join(', ');
    }
    /**
     * Returns currently configured custom nameservers, to be used when toggling
     * to 'custom' from 'automatic' or 'google', prefer nameservers in the
     * following priority:
     *
     * 1) policy-enforced nameservers,
     * 2) previously manually entered nameservers (|savedCustomNameservers_|),
     * 3) policy-recommended nameservers,
     * 4) active nameservers (e.g. from DHCP).
     */
    getCustomNameServers_() {
        const policyEnforcedNameservers = this.getPolicyEnforcedNameservers_();
        if (policyEnforcedNameservers !== null) {
            return policyEnforcedNameservers.slice();
        }
        if (this.savedCustomNameservers_.length > 0) {
            return this.savedCustomNameservers_;
        }
        const policyRecommendedNameservers = this.getPolicyRecommendedNameservers_();
        if (policyRecommendedNameservers !== null) {
            return policyRecommendedNameservers.slice();
        }
        return this.nameservers_;
    }
    /**
     * Event triggered when the selected type changes. Updates nameservers and
     * sends the change value if necessary.
     */
    onTypeChange_() {
        const el = this.shadowRoot.querySelector('#nameserverType');
        assert(el);
        const nameserversType = el.selected;
        this.nameserversType_ = nameserversType;
        this.savedNameserversType_ = nameserversType;
        if (nameserversType === NameserversType.CUSTOM) {
            this.setNameservers_(nameserversType, this.getCustomNameServers_(), true /* send */);
            return;
        }
        this.sendNameServers_();
    }
    /**
     * Event triggered when a |nameservers_| value changes through the custom
     * namservers UI.
     * This gets called after data-binding updates a |nameservers_[i]| entry.
     * This saves the custom nameservers and reflects that change to the backend
     * (sending the custom nameservers).
     */
    onValueChange_() {
        this.savedCustomNameservers_ = this.nameservers_.slice();
        this.sendNameServers_();
    }
    /**
     * Sends the current nameservers type (for automatic) or value.
     */
    sendNameServers_() {
        let eventField;
        let eventValue;
        const nameserversType = this.nameserversType_;
        if (nameserversType === NameserversType.CUSTOM) {
            eventField = 'nameServers';
            eventValue = this.nameservers_;
        }
        else if (nameserversType === NameserversType.GOOGLE) {
            this.nameservers_ = GOOGLE_NAMESERVERS;
            eventField = 'nameServers';
            eventValue = GOOGLE_NAMESERVERS;
        }
        else { // nameserversType === NameserversType.AUTOMATIC
            // If not connected, properties will clear. Otherwise they may or may not
            // change so leave them as-is.
            assert(this.managedProperties);
            if (!OncMojo.connectionStateIsConnected(this.managedProperties.connectionState)) {
                this.nameservers_ = [];
            }
            else {
                this.nameservers_ = this.clearEmptyNameServers_(this.nameservers_);
            }
            eventField = 'nameServersConfigType';
            eventValue = 'DHCP';
        }
        const event = new CustomEvent('nameservers-change', {
            bubbles: true,
            composed: true,
            detail: {
                field: eventField,
                value: eventValue,
            },
        });
        this.dispatchEvent(event);
    }
    clearEmptyNameServers_(nameservers) {
        return nameservers.filter((nameserver) => (!!nameserver && nameserver !== EMPTY_NAMESERVER));
    }
    doNothing_(event) {
        event.stopPropagation();
    }
    /**
     * @return Accessibility label for nameserver input with given index.
     */
    getCustomNameServerInputA11yLabel_(index) {
        return this.i18n('networkNameserversCustomInputA11yLabel', index + 1);
    }
}
customElements.define(NetworkNameserversElement.is, NetworkNameserversElement);

function getTemplate$2q() {
  return html`<!--_html_template_start_--><style include="network-shared iron-flex">
  :host {
    cursor: default
  }

  iron-icon {
    margin-inline-end: 10px;
  }

  cr-policy-indicator {
    margin-inline-end: var(--cr-button-edge-spacing);
  }

  cr-toggle {
    margin-inline-start: var(--cr-button-edge-spacing);
  }

  .separator {
    border-inline-start: var(--cr-separator-line);
    flex-shrink: 0;
    height: calc(var(--cr-section-min-height) - 9px);
    margin-inline-end: var(--cr-section-padding);
    margin-inline-start: var(--cr-section-padding);
  }

  .pin-required-subtext {
    color: var(--cros-text-color-secondary);
  }
</style>

<!-- SIM locked -->
<template is="dom-if" if="[[eq_(State.SIM_LOCKED, state_)]]" restamp>
  <template is="dom-if" if="[[!isSimCarrierLocked_(isActiveSim_,
      deviceState)]]" restamp>
    <div id="simLocked" class="property-box two-line">
      <cr-button id="unlockPinButton"
          on-click="onUnlockPinPressed_"
          disabled="[[disabled]]">
        [[i18n('networkSimUnlock')]]
      </cr-button>
    </div>
  </template>
</template>

<!-- SIM unlocked -->
<template is="dom-if" if="[[eq_(State.SIM_UNLOCKED, state_)]]" restamp>
  <div class="property-box two-line">
    <div class="flex layout vertical"  aria-hidden="true">
      <div id="pinRequiredLabel">
        [[i18n('networkSimLockEnable')]]
      </div>
      <div id="pinRequiredSublabel" class="pin-required-subtext">
        [[i18n('networkSimLockEnableSublabel')]]
      </div>
    </div>
    <cr-button id="changePinButton" on-click="onChangePinPressed_"
        hidden$="[[!showChangePinButton_(deviceState, isActiveSim_,
            isSimPinLockRestricted_)]]"
        disabled="[[disabled]]">
      [[i18n('networkSimChangePin')]]
    </cr-button>
    <template is="dom-if" if="[[!isActiveSim_]]" restamp>
      <iron-icon id="help-icon" tabindex="0" icon="cr:help-outline"
          aria-labelledby="pinRequiredLabel pinRequiredSublabel inActiveSimLockTooltip">
      </iron-icon>
      <paper-tooltip id="inActiveSimLockTooltip" for="help-icon" position="bottom"
          aria-hidden="true" fit-to-visible-bounds>
          [[i18n('networkSimLockedTooltip')]]
      </paper-tooltip>
      <div class="separator"></div>
    </template>
    <template is="dom-if" if="[[shouldShowPolicyIndicator_(isActiveSim_,
        isSimPinLockRestricted_)]]" restamp>
      <cr-policy-indicator id="simLockPolicyIcon" indicator-type="devicePolicy">
      </cr-policy-indicator>
    </template>
    <cr-toggle id="simLockButton"
        disabled="[[isSimLockButtonDisabled_(disabled, isActiveSim_,
            isSimPinLockRestricted_, lockEnabled_)]]"
        on-change="onSimLockEnabledChange_" checked="{{lockEnabled_}}"
        aria-labelledby="pinRequiredLabel pinRequiredSublabel">
    </cr-toggle>
  </div>
</template>

<template is="dom-if" if="[[isDialogOpen_]]" restamp>
  <sim-lock-dialogs
      global-policy="[[globalPolicy]]"
      show-change-pin="[[showChangePin_]]"
      is-dialog-open="{{isDialogOpen_}}"
      device-state="[[deviceState]]">
  </sim-lock-dialogs>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Polymer element for displaying and modifying cellular sim info.
 */
const TOGGLE_DEBOUNCE_MS = 500;
/**
 * State of the element. <network-siminfo> shows 1 of 2 modes:
 *   SIM_LOCKED: Shows an alert that the SIM is locked and provides an "Unlock"
 *       button which allows the user to unlock the SIM.
 *   SIM_UNLOCKED: Provides an option to lock the SIM if desired. If SIM-lock is
 *       on, this UI also allows the user to update the PIN used.
 */
var State;
(function (State) {
    State[State["SIM_LOCKED"] = 0] = "SIM_LOCKED";
    State[State["SIM_UNLOCKED"] = 1] = "SIM_UNLOCKED";
})(State || (State = {}));
const NetworkSiminfoElementBase = I18nMixin(PolymerElement);
class NetworkSiminfoElement extends NetworkSiminfoElementBase {
    static get is() {
        return 'network-siminfo';
    }
    static get template() {
        return getTemplate$2q();
    }
    static get properties() {
        return {
            deviceState: {
                type: Object,
                value: null,
                observer: 'deviceStateChanged_',
            },
            networkState: {
                type: Object,
                value: null,
            },
            globalPolicy: Object,
            disabled: {
                type: Boolean,
                value: false,
            },
            /** Used to reference the State enum in HTML. */
            State: {
                type: Object,
                value: State,
            },
            /**
             * Reflects deviceState.simLockStatus.lockEnabled for the
             * toggle button.
             */
            lockEnabled_: {
                type: Boolean,
                value: false,
            },
            isDialogOpen_: {
                type: Boolean,
                value: false,
                observer: 'onDialogOpenChanged_',
            },
            /**
             * If set to true, shows the Change PIN dialog if the device is unlocked.
             */
            showChangePin_: {
                type: Boolean,
                value: false,
            },
            /**
             * Indicates that the current network is on the active sim slot.
             */
            isActiveSim_: {
                type: Boolean,
                value: false,
                computed: 'computeIsActiveSim_(networkState, deviceState)',
            },
            state_: {
                type: Number,
                value: State.SIM_UNLOCKED,
                computed: 'computeState_(networkState, deviceState, deviceState.*,' +
                    'isActiveSim_)',
            },
            isSimPinLockRestricted_: {
                type: Boolean,
                value: false,
                computed: 'computeIsSimPinLockRestricted_(globalPolicy,' +
                    'globalPolicy.*, lockEnabled_)',
            },
        };
    }
    getSimLockToggle() {
        const el = this.shadowRoot.querySelector('#simLockButton');
        assert(!!el);
        return el;
    }
    getUnlockButton() {
        const el = this.shadowRoot.querySelector('#unlockPinButton');
        assert(!!el);
        return el;
    }
    onDialogOpenChanged_() {
        if (this.isDialogOpen_) {
            return;
        }
        this.delayUpdateLockEnabled_();
        this.updateFocus_();
    }
    /**
     * Sets default focus when dialog is closed.
     */
    updateFocus_() {
        const state = this.computeState_();
        switch (state) {
            case State.SIM_LOCKED:
                const unlockPinButton = this.shadowRoot.querySelector('#unlockPinButton');
                if (unlockPinButton) {
                    unlockPinButton.focus();
                }
                break;
            case State.SIM_UNLOCKED:
                const simLockButton = this.shadowRoot.querySelector('#simLockButton');
                if (simLockButton) {
                    simLockButton.focus();
                }
                break;
        }
    }
    deviceStateChanged_() {
        if (!this.deviceState) {
            return;
        }
        const simLockStatus = this.deviceState.simLockStatus;
        if (!simLockStatus) {
            return;
        }
        const lockEnabled = this.isActiveSim_ && simLockStatus.lockEnabled;
        if (lockEnabled !== this.lockEnabled_) {
            this.setLockEnabled_ = lockEnabled;
            this.updateLockEnabled_();
        }
        else {
            this.setLockEnabled_ = undefined;
        }
    }
    /**
     * Wrapper method to prevent changing |lockEnabled_| while a dialog is open
     * to avoid confusion while a SIM operation is in progress. This must be
     * called after closing any dialog (and not opening another) to set the
     * correct state.
     */
    updateLockEnabled_() {
        if (this.setLockEnabled_ === undefined || this.isDialogOpen_) {
            return;
        }
        this.lockEnabled_ = this.setLockEnabled_;
        this.setLockEnabled_ = undefined;
    }
    delayUpdateLockEnabled_() {
        setTimeout(() => {
            this.updateLockEnabled_();
        }, TOGGLE_DEBOUNCE_MS);
    }
    /**
     * Opens the pin dialog when the sim lock enabled state changes.
     */
    onSimLockEnabledChange_(_event) {
        if (!this.deviceState) {
            return;
        }
        // Do not change the toggle state after toggle is clicked. The toggle
        // should only be updated when the device state changes or dialog has been
        // closed. Changing the UI toggle before the device state changes or dialog
        // is closed can be confusing to the user, as it indicates the action was
        // successful.
        this.lockEnabled_ = !this.lockEnabled_;
        this.showSimLockDialog_(/*showChangePin=*/ false);
    }
    /**
     * Opens the Change PIN dialog.
     */
    onChangePinPressed_(event) {
        event.stopPropagation();
        if (!this.deviceState) {
            return;
        }
        this.showSimLockDialog_(true);
    }
    /**
     * Opens the Unlock PIN / PUK dialog.
     */
    onUnlockPinPressed_(event) {
        event.stopPropagation();
        this.showSimLockDialog_(true);
    }
    showSimLockDialog_(showChangePin) {
        this.showChangePin_ = showChangePin;
        this.isDialogOpen_ = true;
    }
    computeIsActiveSim_() {
        return isActiveSim(this.networkState, this.deviceState);
    }
    showChangePinButton_() {
        if (this.isSimPinLockRestricted_) {
            return false;
        }
        if (!this.deviceState || !this.deviceState.simLockStatus) {
            return false;
        }
        return this.deviceState.simLockStatus.lockEnabled && this.isActiveSim_;
    }
    isSimLockButtonDisabled_() {
        // If SIM PIN locking is restricted by admin, and the SIM does not have SIM
        // PIN lock enabled, users should not be able to enable PIN locking.
        if (this.isSimPinLockRestricted_ && !this.lockEnabled_) {
            return true;
        }
        return this.disabled || !this.isActiveSim_;
    }
    computeState_() {
        const simLockStatus = this.deviceState && this.deviceState.simLockStatus;
        // If a lock is set and the network in question is the active SIM, show the
        // "locked SIM" UI. Note that we can only detect the locked state of the
        // active SIM, so it is possible that we fall through to the SIM_UNLOCKED
        // case below even for a locked SIM if that SIM is not the active one.
        if (this.isActiveSim_ && simLockStatus && !!simLockStatus.lockType) {
            return State.SIM_LOCKED;
        }
        // Note that if this is not the active SIM, we cannot read to lock state, so
        // we default to showing the "unlocked" UI unless we know otherwise.
        return State.SIM_UNLOCKED;
    }
    isSimCarrierLocked_() {
        const simLockStatus = this.deviceState && this.deviceState.simLockStatus;
        if (this.isActiveSim_ && simLockStatus &&
            simLockStatus.lockType === 'network-pin') {
            return true;
        }
        return false;
    }
    shouldShowPolicyIndicator_() {
        return this.isSimPinLockRestricted_ && this.isActiveSim_;
    }
    computeIsSimPinLockRestricted_() {
        return !!this.globalPolicy && !this.globalPolicy.allowCellularSimLock;
    }
    eq_(state1, state2) {
        return state1 === state2;
    }
}
customElements.define(NetworkSiminfoElement.is, NetworkSiminfoElement);

function getTemplate$2p() {
    return html `<!--_html_template_start_--><style include="settings-shared">#cellularRoamingToggle{display:flex;justify-content:center;min-height:var(--cr-section-two-line-min-height)}#cellularRoamingToggle:not([disabled]):hover{background-color:var(--cr-hover-background-color)}#cellularRoamingToggle:not([disabled]):active{background-color:var(--cr-active-background-color)}</style>
<template is="dom-if"
    if="[[showPerNetworkAllowRoamingToggle_(isRoamingAllowedForNetwork_)]]">
    <network-config-toggle id="cellularRoamingToggle" class="settings-box" policy-on-left
        property="[[managedProperties.typeProperties.cellular.allowRoaming]]"
        label="$i18n{networkAllowDataRoaming}"
        sub-label="[[getRoamingDetails_(managedProperties.typeProperties.cellular.allowRoaming.*, prefs.cros.signed.data_roaming_enabled)]]"
        checked="{{isRoamingAllowedForNetwork_}}"
        disabled="[[isPerNetworkToggleDisabled_(managedProperties.typeProperties.cellular.allowRoaming.*, disabled, prefs.cros.signed.data_roaming_enabled)]]">
    </network-config-toggle>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'cellular-roaming-toggle-button' is responsible for encapsulating the
 * cellular roaming configuration logic, and in particular the details behind
 * the transition to a more granular approach to roaming configuration.
 */
const CellularRoamingToggleButtonElementBase = PrefsMixin(I18nMixin(PolymerElement));
class CellularRoamingToggleButtonElement extends CellularRoamingToggleButtonElementBase {
    static get is() {
        return 'cellular-roaming-toggle-button';
    }
    static get template() {
        return getTemplate$2p();
    }
    static get properties() {
        return {
            disabled: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
            },
            managedProperties: {
                type: Object,
            },
            isRoamingAllowedForNetwork_: {
                type: Boolean,
                observer: 'isRoamingAllowedForNetworkChanged_',
                notify: true,
            },
        };
    }
    static get observers() {
        return [
            `managedPropertiesChanged_(
          prefs.cros.signed.data_roaming_enabled.*,
          managedProperties.*)`,
        ];
    }
    constructor() {
        super();
        this.networkConfig_ =
            MojoInterfaceProviderImpl.getInstance().getMojoServiceRemote();
    }
    /**
     * Returns the child element responsible for controlling cellular roaming.
     */
    getCellularRoamingToggle() {
        return this.shadowRoot.querySelector('#cellularRoamingToggle');
    }
    isRoamingAllowedForNetworkChanged_() {
        assert(this.networkConfig_);
        if (!this.managedProperties ||
            !this.managedProperties.typeProperties.cellular.allowRoaming) {
            return;
        }
        const config = OncMojo.getDefaultConfigProperties(this.managedProperties.type);
        config.typeConfig.cellular = {
            roaming: {
                allowRoaming: this.isRoamingAllowedForNetwork_,
            },
            apn: null,
            textMessageAllowState: null,
        };
        this.networkConfig_.setProperties(this.managedProperties.guid, config)
            .then(response => {
            if (response.success) {
                recordSettingChange(Setting.kCellularRoaming, { boolValue: this.isRoamingAllowedForNetwork_ });
            }
            else {
                console.warn('Unable to set properties: ' + JSON.stringify(config));
            }
        });
    }
    /**
     * @return The value derived from the network state reported by
     * managed properties and whether we are under policy enforcement.
     */
    getRoamingAllowedForNetwork_() {
        return !!OncMojo.getActiveValue(this.managedProperties.typeProperties.cellular.allowRoaming) &&
            !this.isRoamingProhibitedByPolicy_();
    }
    getRoamingDetails_() {
        if (this.managedProperties.typeProperties.cellular.roamingState ===
            'Required') {
            return this.i18n('networkAllowDataRoamingRequired');
        }
        if (!this.getRoamingAllowedForNetwork_()) {
            return this.i18n('networkAllowDataRoamingDisabled');
        }
        return this.managedProperties.typeProperties.cellular.roamingState ===
            'Roaming' ?
            this.i18n('networkAllowDataRoamingEnabledRoaming') :
            this.i18n('networkAllowDataRoamingEnabledHome');
    }
    managedPropertiesChanged_() {
        if (!this.managedProperties ||
            !this.managedProperties.typeProperties.cellular.allowRoaming) {
            return;
        }
        // We override the enforcement of the managed property here so that we can
        // have the toggle show the policy enforcement icon when the global policy
        // prohibits roaming.
        if (this.isRoamingProhibitedByPolicy_()) {
            this.set('managedProperties.typeProperties.cellular.allowRoaming.policySource', PolicySource.kDevicePolicyEnforced);
        }
        this.isRoamingAllowedForNetwork_ = this.getRoamingAllowedForNetwork_();
    }
    onCellularRoamingRowClicked_(event) {
        event.stopPropagation();
        if (this.isPerNetworkToggleDisabled_()) {
            return;
        }
        this.isRoamingAllowedForNetwork_ = !this.isRoamingAllowedForNetwork_;
    }
    isRoamingProhibitedByPolicy_() {
        const dataRoamingEnabled = this.getPref('cros.signed.data_roaming_enabled');
        return !dataRoamingEnabled.value &&
            dataRoamingEnabled.controlledBy ===
                chrome.settingsPrivate.ControlledBy.DEVICE_POLICY;
    }
    isPerNetworkToggleDisabled_() {
        return this.disabled || this.isRoamingProhibitedByPolicy_() ||
            CrPolicyNetworkBehaviorMojo.isNetworkPolicyEnforced(this.managedProperties.typeProperties.cellular.allowRoaming);
    }
    showPerNetworkAllowRoamingToggle_() {
        return this.isRoamingAllowedForNetwork_ !== undefined;
    }
}
customElements.define(CellularRoamingToggleButtonElement.is, CellularRoamingToggleButtonElement);

function getTemplate$2o() {
  return html`<!--_html_template_start_--><style include="network-shared cr-hidden-style iron-flex">
  #container {
    align-self: stretch;
    border: 1px solid lightgrey;
    height: 100px;
    margin-top: 10px;
    overflow-y: auto;
    padding: 5px;
  }

  cr-icon-button {
    --cr-icon-button-margin-end: 0;
  }
</style>
<div id="container">
  <template is="dom-repeat" items="[[exclusions]]">
    <div class="layout horizontal center">
      <div class="flex">[[item]]</div>
      <cr-icon-button class="icon-clear" hidden="[[!editable]]"
          title="[[i18n('networkProxyExceptionRemoveA11yLabel', item)]]"
          on-click="onRemoveTap_">
      </cr-icon-button>
    </div>
  </template>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Polymer element for displaying a list of proxy exclusions.
 * Includes UI for adding, changing, and removing entries.
 */
const NetworkProxyExclusionsElementBase = I18nMixin(PolymerElement);
class NetworkProxyExclusionsElement extends NetworkProxyExclusionsElementBase {
    static get is() {
        return 'network-proxy-exclusions';
    }
    static get template() {
        return getTemplate$2o();
    }
    static get properties() {
        return {
            /** Whether or not the proxy values can be edited. */
            editable: {
                type: Boolean,
                value: false,
            },
            /**
             * The list of exclusions.
             */
            exclusions: {
                type: Array,
                value() {
                    return [];
                },
                notify: true,
            },
        };
    }
    onRemoveTap_(event) {
        const index = event.model.index;
        this.splice('exclusions', index, 1);
        this.dispatchEvent(new CustomEvent('proxy-exclusions-change', { bubbles: true, composed: true }));
    }
}
customElements.define(NetworkProxyExclusionsElement.is, NetworkProxyExclusionsElement);

function getTemplate$2n() {
  return html`<!--_html_template_start_--><style include="network-shared">
  cr-input {
    margin: 0 var(--cr-button-edge-spacing);
  }

  #container {
    align-items: center;
    display: flex;
    flex: 0 1 auto;
    flex-direction: row;
  }

  #label {
    flex: 1;
  }

  #host {
    width: 200px;
  }

  #port {
    width: 50px;
  }
</style>
<div id="container">
  <div id="label">[[label]]</div>
  <cr-input id="host" readonly="[[!editable]]"
      aria-label="[[i18n('networkProxyHostInputA11yLabel', label)]]"
      value="{{value.host.activeValue}}" on-change="onValueChange_">
  </cr-input>
  <div>[[i18n('networkProxyPort')]]</div>
  <cr-input id="port" readonly="[[!editable]]"
      aria-label="[[i18n('networkProxyPortInputA11yLabel', label)]]"
      value="{{value.port.activeValue}}" on-change="onValueChange_">
  </cr-input>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Polymer element for displaying and editing a single
 * network proxy value. When the URL or port changes, a 'proxy-input-change'
 * event is fired with the combined url and port values passed as a single
 * string, url:port.
 */
const NetworkProxyInputElementBase = I18nMixin(PolymerElement);
class NetworkProxyInputElement extends NetworkProxyInputElementBase {
    static get is() {
        return 'network-proxy-input';
    }
    static get template() {
        return getTemplate$2n();
    }
    static get properties() {
        return {
            /**
             * Whether or not the proxy value can be edited.
             */
            editable: {
                type: Boolean,
                value: false,
            },
            /**
             * A label for the proxy value.
             */
            label: {
                type: String,
                value: 'Proxy',
            },
            /**
             * The proxy object.
             */
            value: {
                type: Object,
                value() {
                    return {
                        host: OncMojo.createManagedString(''),
                        port: OncMojo.createManagedInt(80),
                    };
                },
                notify: true,
            },
        };
    }
    focus() {
        const crInput = this.shadowRoot.querySelector('cr-input');
        assert(!!crInput);
        crInput.focus();
    }
    /**
     * Event triggered when an input value changes.
     */
    onValueChange_() {
        let port = parseInt(this.value.port.activeValue.toString(), 10);
        if (isNaN(port)) {
            port = 80;
        }
        this.value.port.activeValue = port;
        this.dispatchEvent(new CustomEvent('proxy-input-change', { bubbles: true, composed: true, detail: this.value }));
    }
}
customElements.define(NetworkProxyInputElement.is, NetworkProxyInputElement);

function getTemplate$2m() {
  return html`<!--_html_template_start_--><style include="network-shared cr-hidden-style iron-flex iron-flex-alignment md-select">
  network-proxy-input {
    margin-bottom: 10px;
  }

  network-proxy-exclusions {
    margin: 10px 0;
  }

  #addException {
    margin-top: 10px;
  }

  #manualProxy {
    padding-inline-start: var(--cr-section-padding);
  }

  #proxyType  {
    width: 320px;
  }

</style>

<!-- Proxy type dropdown -->
<div class="property-box">
  <div class="start">[[i18n('networkProxyConnectionType')]]</div>
  <select id="proxyType" class="md-select" on-change="onTypeChange_"
      value="[[proxy_.type.activeValue]]"
      disabled="[[!isEditable_('type', managedProperties, editable,
          useSharedProxies)]]"
      aria-label="[[i18n('networkProxyConnectionType')]]">
    <template is="dom-repeat" items="[[proxyTypes_]]">
      <option value="[[item]]">[[getProxyTypeDesc_(item)]]</option>
    </template>
  </select>
</div>

<!-- Autoconfiguration (PAC) -->
<div class="property-box indented"
    hidden$="[[!matches_(proxy_.type.activeValue, 'PAC')]]">
  <cr-input id="pacInput" class="flex"
      label="[[i18n('networkProxyAutoConfig')]]"
      value="{{proxy_.pac.activeValue}}" on-change="onPacChange_"
      disabled="[[!isEditable_('pac', managedProperties, editable,
          useSharedProxies)]]">
  </cr-input>
</div>

<!-- Web Proxy Auto Discovery (WPAD) -->
<div class="property-box indented"
    hidden$="[[!matches_(proxy_.type.activeValue, 'WPAD')]]">
  <div>[[i18n('networkProxyWpad')]]</div>
  <div class="middle">[[wpad_]]</div>
</div>

<!-- Manual -->
<div class="property-box indented"
    hidden$="[[!matches_(proxy_.type.activeValue, 'Manual')]]">
  <div id="networkProxyToggleLabel" class="flex">
    [[i18n('networkProxyUseSame')]]
  </div>
  <cr-toggle checked="{{useSameProxy_}}"
      disabled="[[!isEditable_('type', managedProperties, editable,
          useSharedProxies)]]"
      aria-labelledby="networkProxyToggleLabel">
  </cr-toggle>
</div>

<div id="manualProxy" class="layout vertical start"
    hidden$="[[!matches_(proxy_.type.activeValue, 'Manual')]]">
  <div hidden$="[[!useSameProxy_]]" class="layout vertical">
    <network-proxy-input
        id="sameProxyInput"
        on-proxy-input-change="onProxyInputChange_"
        editable="[[isEditable_('manual.httpProxy.host', managedProperties,
            editable, useSharedProxies)]]"
        value="{{proxy_.manual.httpProxy}}"
        label="[[i18n('networkProxy')]]">
    </network-proxy-input>
  </div>
  <div hidden$="[[useSameProxy_]]" class="layout vertical">
    <network-proxy-input
      id="httpProxyInput"
        on-proxy-input-change="onProxyInputChange_"
        editable="[[isEditable_('manual.httpProxy.host', managedProperties,
            editable, useSharedProxies)]]"
        value="{{proxy_.manual.httpProxy}}"
        label="[[i18n('networkProxyHttp')]]">
    </network-proxy-input>
    <network-proxy-input
        id="secureHttpProxyInput"
        on-proxy-input-change="onProxyInputChange_"
        editable="[[isEditable_('manual.secureHttpProxy.host',
            managedProperties, editable, useSharedProxies)]]"
        value="{{proxy_.manual.secureHttpProxy}}"
        label="[[i18n('networkProxyShttp')]]">
    </network-proxy-input>
    <network-proxy-input
        id="socksProxyInput"
        on-proxy-input-change="onProxyInputChange_"
        editable="[[isEditable_('manual.socks.host', managedProperties,
            editable, useSharedProxies)]]"
        value="{{proxy_.manual.socks}}"
        label="[[i18n('networkProxySocks')]]">
    </network-proxy-input>
  </div>

  <div hidden="[[!isEditable_('type', managedProperties, editable,
      useSharedProxies)]]">
    <div>[[i18n('networkProxyExceptionList')]]</div>
    <network-proxy-exclusions
        on-proxy-exclusions-change="onProxyExclusionsChange_"
        exclusions="{{proxy_.excludeDomains.activeValue}}"
        editable="[[isEditable_('excludeDomains', managedProperties,
            editable, useSharedProxies)]]">
    </network-proxy-exclusions>
    <div id="addException" class="layout horizontal center">
      <cr-input id="proxyExclusion" class="flex"
          value="{{proxyExclusionInputValue_}}"
          aria-label="[[i18n('networkProxyExceptionInputA11yLabel')]]"
          on-keypress="onAddProxyExclusionKeypress_">
        <cr-button id="proxyExclusionButton"
            on-click="onAddProxyExclusionClicked_"
            slot="suffix"
            disabled="[[shouldProxyExclusionButtonBeDisabled_(
                proxyExclusionInputValue_)]]">
          [[i18n('networkProxyAddException')]]
        </cr-button>
      </cr-input>
    </div>
  </div>

  <cr-button id="saveManualProxy"
      on-click="onSaveProxyClicked_" class="action-button"
      disabled="[[!isSaveManualProxyEnabled_(managedProperties,
          proxyIsUserModified_, proxy_.*)]]">
    [[i18n('save')]]
  </cr-button>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Polymer element for displaying and editing network proxy
 * values.
 */
function createDefaultProxySettings() {
    return {
        type: OncMojo.createManagedString('Direct'),
        manual: null,
        excludeDomains: null,
        pac: null,
    };
}
const NetworkProxyElementBase = mixinBehaviors([CrPolicyNetworkBehaviorMojo], I18nMixin(PolymerElement));
class NetworkProxyElement extends NetworkProxyElementBase {
    constructor() {
        super(...arguments);
        /**
         * Saved ExcludeDomains properties so that switching to a non-Manual type
         * does not loose any set exclusions while the UI is open.
         */
        this.savedManual_ = undefined;
        /**
         * Saved Manual properties so that switching to another type does not loose
         * any set properties while the UI is open.
         */
        this.savedExcludeDomains_ = undefined;
    }
    static get is() {
        return 'network-proxy';
    }
    static get template() {
        return getTemplate$2m();
    }
    static get properties() {
        return {
            /** Whether or not the proxy values can be edited. */
            editable: {
                type: Boolean,
                value: false,
            },
            managedProperties: {
                type: Object,
                observer: 'managedPropertiesChanged_',
            },
            /** Whether shared proxies are allowed. */
            useSharedProxies: {
                type: Boolean,
                value: false,
                observer: 'updateProxy_',
            },
            /**
             * UI visible / edited proxy configuration.
             */
            proxy_: {
                type: Object,
                value() {
                    return createDefaultProxySettings();
                },
            },
            /**
             * The Web Proxy Auto Discovery URL extracted from managedProperties.
             */
            wpad_: {
                type: String,
                value: '',
            },
            /**
             * Whether or not to use the same manual proxy for all protocols.
             */
            useSameProxy_: {
                type: Boolean,
                value: false,
                observer: 'useSameProxyChanged_',
            },
            /**
             * Array of proxy configuration types.
             */
            proxyTypes_: {
                type: Array,
                value: ['Direct', 'PAC', 'WPAD', 'Manual'],
                readOnly: true,
            },
            /**
             * The current value of the proxy exclusion input.
             */
            proxyExclusionInputValue_: {
                type: String,
                value: '',
            },
            /**
             * Set to true while modifying proxy values so that an update does not
             * override the edited values.
             */
            proxyIsUserModified_: {
                type: Boolean,
                value: false,
            },
        };
    }
    connectedCallback() {
        super.connectedCallback();
        this.reset();
    }
    /**
     * Called any time the page is refreshed or navigated to so that the proxy
     * is updated correctly.
     */
    reset() {
        this.proxyIsUserModified_ = false;
        this.updateProxy_();
    }
    managedPropertiesChanged_(newValue, oldValue) {
        if ((newValue && newValue.guid) !== (oldValue && oldValue.guid)) {
            // Clear saved manual properties and exclude domains if we're updating
            // to show a different network.
            this.savedManual_ = undefined;
            this.savedExcludeDomains_ = undefined;
        }
        if (this.proxyIsUserModified_ || this.isInputEditInProgress_()) {
            // Ignore updates if any fields have been modified by user or if any
            // input elements are currently being edited.
            return;
        }
        this.updateProxy_();
    }
    isInputEditInProgress_() {
        if (!this.editable) {
            return false;
        }
        const activeElement = this.shadowRoot.activeElement;
        if (!activeElement) {
            return false;
        }
        // Find property name for current active element.
        let property = null;
        switch (activeElement.id) {
            case 'sameProxyInput':
            case 'httpProxyInput':
                property = 'manual.httpProxy.host';
                break;
            case 'secureHttpProxyInput':
                property = 'manual.secureHttpProxy.host';
                break;
            case 'socksProxyInput':
                property = 'manual.socks.host';
                break;
            case 'pacInput':
                property = 'pac';
                break;
        }
        if (!property) {
            return false;
        }
        // Input should be considered active only when the property editable.
        return this.isEditable_(property);
    }
    proxyMatches_(a, b) {
        return !!a && !!b && a.host.activeValue === b.host.activeValue &&
            a.port.activeValue === b.port.activeValue;
    }
    createDefaultProxyLocation_(port) {
        return {
            host: OncMojo.createManagedString(''),
            port: OncMojo.createManagedInt(port),
        };
    }
    /**
     * Returns a copy of |inputProxy| with all required properties set correctly.
     */
    validateProxy_(inputProxy) {
        const proxy = { ...inputProxy };
        const type = proxy.type.activeValue;
        if (type === 'PAC') {
            if (!proxy.pac) {
                proxy.pac = OncMojo.createManagedString('');
            }
        }
        else if (type === 'Manual') {
            proxy.manual = proxy.manual || this.savedManual_ || {
                httpProxy: null,
                secureHttpProxy: null,
                ftpProxy: null,
                socks: null,
            };
            assert(proxy.manual);
            if (!proxy.manual.httpProxy) {
                proxy.manual.httpProxy = this.createDefaultProxyLocation_(80);
            }
            if (!proxy.manual.secureHttpProxy) {
                proxy.manual.secureHttpProxy = this.createDefaultProxyLocation_(80);
            }
            if (!proxy.manual.socks) {
                proxy.manual.socks = this.createDefaultProxyLocation_(1080);
            }
            proxy.excludeDomains =
                proxy.excludeDomains || this.savedExcludeDomains_ || {
                    activeValue: [],
                    policySource: PolicySource.kNone,
                    policyValue: null,
                };
        }
        return proxy;
    }
    updateProxy_() {
        if (!this.managedProperties) {
            return;
        }
        let proxySettings = this.managedProperties.proxySettings;
        // For shared networks with unmanaged proxy settings, ignore any saved proxy
        // settings and use the default value.
        if (this.isShared_() && proxySettings &&
            !this.isControlled(proxySettings.type) && !this.useSharedProxies) {
            proxySettings = null; // Ignore proxy settings.
        }
        const proxy = proxySettings ? this.validateProxy_(proxySettings) :
            createDefaultProxySettings();
        if (proxy.type.activeValue === 'WPAD') {
            // Set the Web Proxy Auto Discovery URL for display purposes.
            const ipv4 = this.managedProperties ?
                OncMojo.getIPConfigForType(this.managedProperties, IPConfigType.kIPv4) :
                null;
            this.wpad_ = (ipv4 && ipv4.webProxyAutoDiscoveryUrl) ||
                this.i18n('networkProxyWpadNone');
        }
        // Set this.proxy_ after dom-repeat has been stamped.
        microTask.run(() => this.setProxy_(proxy));
    }
    setProxy_(proxy) {
        this.proxy_ = proxy;
        if (proxy.manual) {
            const manual = proxy.manual;
            const httpProxy = manual.httpProxy;
            if (this.proxyMatches_(httpProxy, manual.secureHttpProxy) &&
                this.proxyMatches_(httpProxy, manual.socks)) {
                // If all four proxies match, enable the 'use same proxy' toggle.
                this.useSameProxy_ = true;
            }
            else if (!manual.secureHttpProxy?.host?.activeValue &&
                !manual.socks?.host?.activeValue) {
                // Otherwise if no proxies other than http have a host value, also
                // enable the 'use same proxy' toggle.
                this.useSameProxy_ = true;
            }
        }
        this.proxyIsUserModified_ = false;
    }
    useSameProxyChanged_() {
        this.proxyIsUserModified_ = true;
    }
    getProxyLocation_(location) {
        if (!location) {
            return null;
        }
        return {
            host: location.host.activeValue,
            port: location.port.activeValue,
        };
    }
    /**
     * Called when the proxy changes in the UI.
     */
    sendProxyChange_() {
        const proxyType = OncMojo.getActiveString(this.proxy_.type);
        if (!proxyType || (proxyType === 'PAC' && !this.proxy_.pac)) {
            return;
        }
        const proxy = {
            type: proxyType,
            excludeDomains: OncMojo.getActiveValue(this.proxy_.excludeDomains) ||
                null,
            manual: null,
            pac: null,
        };
        if (proxyType === 'Manual') {
            let manual = {
                httpProxy: null,
                secureHttpProxy: null,
                ftpProxy: null,
                socks: null,
            };
            if (this.proxy_.manual) {
                this.savedManual_ = { ...this.proxy_.manual };
                manual = {
                    httpProxy: this.getProxyLocation_(this.proxy_.manual.httpProxy),
                    secureHttpProxy: this.getProxyLocation_(this.proxy_.manual.secureHttpProxy),
                    ftpProxy: null,
                    socks: this.getProxyLocation_(this.proxy_.manual.socks),
                };
            }
            if (this.proxy_.excludeDomains) {
                this.savedExcludeDomains_ = { ...this.proxy_.excludeDomains };
            }
            const defaultProxy = manual.httpProxy || { host: '', port: 80 };
            if (this.useSameProxy_) {
                manual.secureHttpProxy = { ...defaultProxy };
                manual.socks = { ...defaultProxy };
            }
            else {
                // Remove properties with empty hosts to unset them.
                if (manual.httpProxy && !manual.httpProxy.host) {
                    manual.httpProxy = null;
                }
                if (manual.secureHttpProxy && !manual.secureHttpProxy.host) {
                    manual.secureHttpProxy = null;
                }
                if (manual.socks && !manual.socks.host) {
                    manual.socks = null;
                }
            }
            proxy.manual = manual;
        }
        else if (proxyType === 'PAC') {
            proxy.pac = OncMojo.getActiveString(this.proxy_.pac);
        }
        this.dispatchEvent(new CustomEvent('proxy-change', {
            bubbles: true,
            composed: true,
            detail: proxy,
        }));
        this.proxyIsUserModified_ = false;
    }
    /**
     * Event triggered when the selected proxy type changes.
     */
    onTypeChange_(event) {
        if (!this.proxy_ || !this.proxy_.type) {
            return;
        }
        const target = event.target;
        const type = target.value;
        this.proxy_.type.activeValue = type;
        this.set('proxy_', this.validateProxy_(this.proxy_));
        let proxyTypeChangeIsReady;
        let elementToFocus;
        switch (type) {
            case 'Direct':
            case 'WPAD':
                // No addtional values are required, send the type change.
                proxyTypeChangeIsReady = true;
                break;
            case 'PAC':
                elementToFocus = this.shadowRoot.querySelector('#pacInput');
                // If a PAC is already set, send the type change now, otherwise wait
                // until the user provides a PAC value.
                proxyTypeChangeIsReady = !!OncMojo.getActiveString(this.proxy_.pac);
                break;
            case 'Manual':
                // Manual proxy configuration includes multiple input fields, so wait
                // until the 'send' button is clicked.
                proxyTypeChangeIsReady = false;
                elementToFocus =
                    this.shadowRoot.querySelector('#manualProxy network-proxy-input');
                break;
        }
        // If the new proxy type is fully configured, send it, otherwise set
        // |proxyIsUserModified_| to true so that property updates do not
        // overwrite user changes.
        if (proxyTypeChangeIsReady) {
            this.sendProxyChange_();
        }
        else {
            this.proxyIsUserModified_ = true;
        }
        if (elementToFocus) {
            microTask.run(() => elementToFocus.focus());
        }
    }
    onPacChange_() {
        this.sendProxyChange_();
    }
    onProxyInputChange_() {
        this.proxyIsUserModified_ = true;
    }
    onAddProxyExclusionClicked_() {
        assert(this.proxyExclusionInputValue_);
        this.push('proxy_.excludeDomains.activeValue', this.proxyExclusionInputValue_);
        // Clear input.
        this.proxyExclusionInputValue_ = '';
        this.proxyIsUserModified_ = true;
    }
    onAddProxyExclusionKeypress_(event) {
        if (event.key !== 'Enter') {
            return;
        }
        event.stopPropagation();
        this.onAddProxyExclusionClicked_();
    }
    shouldProxyExclusionButtonBeDisabled_(proxyExclusionInputValue) {
        return !proxyExclusionInputValue;
    }
    /**
     * Event triggered when the proxy exclusion list changes.
     */
    onProxyExclusionsChange_() {
        this.proxyIsUserModified_ = true;
    }
    onSaveProxyClicked_() {
        this.sendProxyChange_();
    }
    getProxyTypeDesc_(proxyType) {
        if (proxyType === 'Manual') {
            return this.i18n('networkProxyTypeManual');
        }
        if (proxyType === 'PAC') {
            return this.i18n('networkProxyTypePac');
        }
        if (proxyType === 'WPAD') {
            return this.i18n('networkProxyTypeWpad');
        }
        return this.i18n('networkProxyTypeDirect');
    }
    isEditable_(propertyName) {
        if (!this.editable || (this.isShared_() && !this.useSharedProxies)) {
            return false;
        }
        const property = this.get('proxySettings.' + propertyName, this.managedProperties);
        if (!property) {
            return true; // Default to editable if property is not defined.
        }
        return this.isPropertyEditable_(property);
    }
    isPropertyEditable_(property) {
        return !!property && !this.isNetworkPolicyEnforced(property) &&
            !this.isExtensionControlled(property);
    }
    isShared_() {
        if (!this.managedProperties) {
            return false;
        }
        const source = this.managedProperties.source;
        return source === OncSource.kDevice || source === OncSource.kDevicePolicy;
    }
    isSaveManualProxyEnabled_() {
        if (!this.proxyIsUserModified_) {
            return false;
        }
        const manual = this.proxy_.manual;
        const httpHost = this.get('httpProxy.host.activeValue', manual);
        if (this.useSameProxy_) {
            return !!httpHost;
        }
        return !!httpHost ||
            !!this.get('secureHttpProxy.host.activeValue', manual) ||
            !!this.get('socks.host.activeValue', manual);
    }
    matches_(property, value) {
        return property === value;
    }
}
customElements.define(NetworkProxyElement.is, NetworkProxyElement);

function getTemplate$2l() {
    return html `<!--_html_template_start_--><style include="internet-shared cr-hidden-style iron-flex
    iron-flex-alignment">cr-policy-network-indicator-mojo{margin-inline-end:10px}extension-controlled-indicator{margin-inline-start:0;width:100%}.settings-box:first-of-type{border-top:none}</style>

<!-- Policy indicator. Only one dom-if below will be shown. -->
<template is="dom-if"
    if="[[shouldShowNetworkPolicyIndicator_(managedProperties)]]">
  <div class="settings-box">
    <div class="layout horizontal center">
      <cr-policy-network-indicator-mojo
          property="[[managedProperties.proxySettings.type]]"
          no-extension-indicator>
      </cr-policy-network-indicator-mojo>
      <div>$i18n{networkProxyEnforcedPolicy}</div>
    </div>
  </div>
</template>

<template is="dom-if" if="[[isProxySetByExtension_(managedProperties)]]">
  <div class="settings-box">
    <extension-controlled-indicator
        extension-id="[[extensionInfo_.id]]"
        extension-name="[[extensionInfo_.name]]"
        extension-can-be-disabled="[[extensionInfo_.canBeDisabled]]">
    </extension-controlled-indicator>
  </div>
</template>

<!-- Allow shared proxies -->
<settings-toggle-button id="allowShared" class="indented"
    hidden$="[[!shouldShowAllowShared_(managedProperties.source)]]"
    pref="{{prefs.settings.use_shared_proxies}}"
    label="$i18n{networkProxyAllowShared}"
    on-settings-boolean-control-change="onAllowSharedProxiesChange_"
    no-set-pref
    disabled="[[disabled]]">
</settings-toggle-button>

<div class="settings-box single-column stretch continuation indented">
  <network-proxy editable="[[!disabled]]"
      managed-properties="[[managedProperties]]"
      use-shared-proxies="[[useSharedProxies_]]">
  </network-proxy>
</div>

<!-- Confirm Allow shared proxies dialog -->
<cr-dialog id="confirmAllowSharedDialog"
    close-text="$i18n{close}" on-cancel="onAllowSharedDialogCancel_"
    on-close="onAllowSharedDialogClose_">
  <div slot="title">
    [[getAllowSharedDialogTitle_(prefs.settings.use_shared_proxies.value)]]
  </div>
  <div slot="body">
    $i18n{networkProxyAllowSharedWarningMessage}
  </div>
  <div slot="button-container">
    <cr-button class="cancel-button"
        on-click="onAllowSharedDialogCancel_">
      $i18n{cancel}
    </cr-button>
    <cr-button class="action-button"
        on-click="onAllowSharedDialogConfirm_">
      $i18n{confirm}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Polymer element hosting <network-proxy> in the internet
 * detail page. This element is responsible for setting 'Allow proxies for
 * shared networks'.
 */
const NetworkProxySectionElementBase = mixinBehaviors([
    CrPolicyNetworkBehaviorMojo,
], PrefsMixin(RouteObserverMixin(I18nMixin(PolymerElement))));
class NetworkProxySectionElement extends NetworkProxySectionElementBase {
    static get is() {
        return 'network-proxy-section';
    }
    static get template() {
        return getTemplate$2l();
    }
    static get properties() {
        return {
            disabled: {
                type: Boolean,
                value: false,
            },
            managedProperties: Object,
            /**
             * Reflects prefs.settings.use_shared_proxies for data binding.
             */
            useSharedProxies_: Boolean,
            /**
             * Information about the extension controlling the proxy. Can be null if
             * the proxy is not controlled by an extension.
             */
            extensionInfo_: Object,
        };
    }
    static get observers() {
        return [
            'useSharedProxiesChanged_(prefs.settings.use_shared_proxies.value)',
        ];
    }
    /**
     * Returns the allow shared CrToggleElement.
     */
    getAllowSharedToggle() {
        return this.shadowRoot.querySelector('#allowShared');
    }
    currentRouteChanged(newRoute) {
        if (newRoute === routes.NETWORK_DETAIL) {
            this.shadowRoot.querySelector('network-proxy').reset();
        }
    }
    useSharedProxiesChanged_() {
        const pref = this.getPref('settings.use_shared_proxies');
        this.useSharedProxies_ = !!pref && !!pref.value;
    }
    /**
     * Return true if the proxy is controlled by an extension.
     */
    isProxySetByExtension_() {
        const property = this.getProxySettingsTypeProperty_();
        if (!property || !this.isExtensionControlled(property) ||
            !this.prefs.proxy.controlledByName) {
            return false;
        }
        this.extensionInfo_ = {
            id: this.prefs.proxy.extensionId,
            name: this.prefs.proxy.controlledByName,
            canBeDisabled: this.prefs.proxy.extensionCanBeDisabled,
        };
        return true;
    }
    isShared_() {
        return this.managedProperties.source === OncSource.kDevice ||
            this.managedProperties.source === OncSource.kDevicePolicy;
    }
    getProxySettingsTypeProperty_() {
        if (!this.managedProperties) {
            return undefined;
        }
        const proxySettings = this.managedProperties.proxySettings;
        return proxySettings ? proxySettings.type : undefined;
    }
    getAllowSharedDialogTitle_(allowShared) {
        if (allowShared) {
            return this.i18n('networkProxyAllowSharedDisableWarningTitle');
        }
        return this.i18n('networkProxyAllowSharedEnableWarningTitle');
    }
    shouldShowNetworkPolicyIndicator_() {
        const property = this.getProxySettingsTypeProperty_();
        return !!property && !this.isProxySetByExtension_() &&
            this.isNetworkPolicyEnforced(property);
    }
    shouldShowAllowShared_(_property) {
        if (!this.isShared_()) {
            return false;
        }
        // We currently do not accurately determine the source if the policy
        // controlling the proxy setting, so always show the 'allow shared'
        // toggle for shared networks. http://crbug.com/662529.
        return true;
    }
    /**
     * Handles the change event for the shared proxy checkbox. Shows a
     * confirmation dialog.
     */
    onAllowSharedProxiesChange_() {
        this.$.confirmAllowSharedDialog.showModal();
    }
    /**
     * Handles the shared proxy confirmation dialog 'Confirm' button.
     */
    onAllowSharedDialogConfirm_() {
        this.$.allowShared.sendPrefChange();
        this.$.confirmAllowSharedDialog.close();
    }
    /**
     * Handles the shared proxy confirmation dialog 'Cancel' button or a cancel
     * event.
     */
    onAllowSharedDialogCancel_() {
        this.$.allowShared.resetToPrefValue();
        this.$.confirmAllowSharedDialog.close();
    }
    onAllowSharedDialogClose_() {
        this.$.allowShared.focus();
    }
}
customElements.define(NetworkProxySectionElement.is, NetworkProxySectionElement);

function getTemplate$2k() {
    return html `<!--_html_template_start_--><style include="settings-shared">#description{margin-bottom:var(--cr-section-vertical-margin)}</style>
<cr-dialog id="dialog" close-text="$i18n{close}">
  <div slot="title">
    $i18n{networkSectionPasspointGoToSubscriptionTitle}
  </div>
  <div slot="body">
    <span id="information">
      $i18n{networkSectionPasspointGoToSubscriptionInformation}
      <a href="$i18nRaw{wifiPasspointLearnMoreUrl}" target="_blank"
          aria-label="$i18n{passpointLearnMoreA11yLabel}">
        $i18n{learnMoreLabel}
      </a>
    </span>
  </div>
  <div slot="button-container">
    <cr-button id="cancelButton" class="cancel-button"
        aria-label="$i18n{passpointRemoveCancelA11yLabel}"
        on-click="onCancelClick_">
      $i18n{cancel}
    </cr-button>
    <cr-button id="confirmButton" class="action-button"
        aria-label="$i18n{passpointRemoveGoToSubscriptionButtonA11yLabel}"
        on-click="onConfirmClick_">
      $i18n{networkSectionPasspointGoToSubscriptionButtonLabel}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PasspointRemoveDialogElementBase = I18nMixin(PolymerElement);
class PasspointRemoveDialogElement extends PasspointRemoveDialogElementBase {
    static get is() {
        return 'passpoint-remove-dialog';
    }
    static get template() {
        return getTemplate$2k();
    }
    static get properties() {
        return {};
    }
    constructor() {
        super();
    }
    open() {
        const dialog = this.getDialog_();
        if (!dialog.open) {
            dialog.showModal();
        }
        this.shadowRoot.querySelector('#confirmButton').focus();
    }
    close() {
        const dialog = this.getDialog_();
        if (dialog.open) {
            dialog.close();
        }
    }
    getDialog_() {
        return castExists(this.shadowRoot.querySelector('#dialog'));
    }
    onCancelClick_() {
        this.getDialog_().cancel();
    }
    onConfirmClick_() {
        const event = new CustomEvent('confirm', { bubbles: true, composed: true });
        this.dispatchEvent(event);
    }
}
customElements.define(PasspointRemoveDialogElement.is, PasspointRemoveDialogElement);

function getTemplate$2j() {
  return html`<!--_html_template_start_--><style include="network-shared"></style>
<h2>[[i18n('TrafficCountersTrafficCounters')]]</h2>
<div class="button-group">
  <cr-button id="requestButton" on-click="onRequestTrafficCountersClick_">
    [[i18n('TrafficCountersRequestTrafficCounters')]]
  </cr-button>
</div>
<template is="dom-repeat" items="[[networks_]]" as="network">
  <network-health-container
      label="[[getNetworkTypeString_(network.type)]]"
      expanded="[[getTypeExpanded_(network.type, typeExpanded_.*)]]"
      on-toggle-expanded="onToggleExpanded_">
    <span slot="header">
      <img class="type-icon" src="[[getNetworkTypeIcon_(network.type)]]">
    </span>
    <div id="name" class="network-attribute-container">
      <div class="network-attribute-label">[[i18n('OncName')]]</div>
      <span class="network-attribute-value">[[network.name]]</span>
    </div>
    <div id="guid" class="network-attribute-container">
      <div class="network-attribute-label">[[i18n('TrafficCountersGuid')]]</div>
      <span class="network-attribute-value">[[network.guid]]</span>
    </div>
    <div id="counters" class="network-attribute-container">
      <div class="network-attribute-label">
        [[i18n('TrafficCountersTrafficCounters')]]
      </div>
      <span class="network-attribute-value">
        [[countersToString_(network.counters)]]
      </span>
    </div>
    <div id="time" class="network-attribute-container">
      <div class="network-attribute-label">
        [[i18n('TrafficCountersLastResetTime')]]
      </div>
      <span class="network-attribute-value">
        [[lastResetTimeString_(network)]]
      </span>
    </div>
    <div id="reset" class="network-attribute-container">
      <div class="button-group">
        <cr-button id="resetButton" on-click="onResetTrafficCountersClick_">
          [[i18n('TrafficCountersResetTrafficCounters')]]
        </cr-button>
      </div>
    </div>
  </network-health-container>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/** Default traffic counter reset day. */
const kDefaultResetDay = 1;
/**
 * Helper function to create a Network object.
 */
function createNetwork$1(guid, name, type, counters, lastResetTime, friendlyDate, userSpecifiedResetDay) {
    return {
        guid: guid,
        name: name,
        type: type,
        counters: counters,
        lastResetTime: lastResetTime,
        friendlyDate: friendlyDate,
        userSpecifiedResetDay: userSpecifiedResetDay,
    };
}
class TrafficCountersAdapter {
    constructor() {
        /**
         * Network Config mojo remote.
         */
        this.networkConfig_ =
            MojoInterfaceProviderImpl.getInstance().getMojoServiceRemote();
    }
    /**
     * Requests traffic counters for active networks.
     */
    async requestTrafficCountersForActiveNetworks() {
        const filter = {
            filter: FilterType.kActive,
            networkType: NetworkType.kAll,
            limit: NO_LIMIT,
        };
        const networks = [];
        const networkStateList = await this.networkConfig_.getNetworkStateList(filter);
        for (const networkState of networkStateList.result) {
            const trafficCounters = await this.requestTrafficCountersForNetwork(networkState.guid);
            const lastResetTime = await this.requestLastResetTimeForNetwork(networkState.guid);
            const friendlyDate = await this.requestFriendlyDateForNetwork(networkState.guid);
            const userSpecifiedResetDay = await this.requestUserSpecifiedResetDayForNetwork(networkState.guid);
            networks.push(createNetwork$1(networkState.guid, networkState.name, networkState.type, trafficCounters, lastResetTime, friendlyDate, userSpecifiedResetDay));
        }
        return networks;
    }
    /**
     * Resets traffic counters for the given network.
     */
    async resetTrafficCountersForNetwork(guid) {
        await this.networkConfig_.resetTrafficCounters(guid);
    }
    /**
     * Requests traffic counters for the given network.
     */
    async requestTrafficCountersForNetwork(guid) {
        const trafficCountersObj = await this.networkConfig_.requestTrafficCounters(guid);
        return trafficCountersObj.trafficCounters;
    }
    /**
     * Requests last reset time for the given network.
     */
    async requestLastResetTimeForNetwork(guid) {
        const managedPropertiesPromise = await this.networkConfig_.getManagedProperties(guid);
        if (!managedPropertiesPromise || !managedPropertiesPromise.result) {
            return null;
        }
        const trafficCounterProperties = managedPropertiesPromise.result.trafficCounterProperties;
        if (!trafficCounterProperties) {
            return null;
        }
        return trafficCounterProperties.lastResetTime || null;
    }
    /**
     * Requests a reader friendly date, corresponding to the last reset time,
     * for the given network.
     */
    async requestFriendlyDateForNetwork(guid) {
        const managedPropertiesPromise = await this.networkConfig_.getManagedProperties(guid);
        if (!managedPropertiesPromise || !managedPropertiesPromise.result) {
            return null;
        }
        const trafficCounterProperties = managedPropertiesPromise.result.trafficCounterProperties;
        if (!trafficCounterProperties) {
            return null;
        }
        return trafficCounterProperties.friendlyDate || null;
    }
    /**
     * Requests user specified reset day for the given network.
     */
    async requestUserSpecifiedResetDayForNetwork(guid) {
        const managedPropertiesPromise = await this.networkConfig_.getManagedProperties(guid);
        if (!managedPropertiesPromise || !managedPropertiesPromise.result) {
            return kDefaultResetDay;
        }
        const trafficCounterProperties = managedPropertiesPromise.result.trafficCounterProperties;
        if (!trafficCounterProperties) {
            return kDefaultResetDay;
        }
        return trafficCounterProperties.userSpecifiedResetDay;
    }
    /**
     * Sets values for auto reset.
     */
    async setTrafficCountersResetDayForNetwork(guid, resetDay) {
        await this.networkConfig_.setTrafficCountersResetDay(guid, resetDay);
    }
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Polymer element for a container used in displaying network
 * traffic information.
 */
/**
 * Image file name corresponding to network type.
 */
var TechnologyIcons;
(function (TechnologyIcons) {
    TechnologyIcons["CELLULAR"] = "cellular_0.svg";
    TechnologyIcons["ETHERNET"] = "ethernet.svg";
    TechnologyIcons["VPN"] = "vpn.svg";
    TechnologyIcons["WIFI"] = "wifi_0.svg";
})(TechnologyIcons || (TechnologyIcons = {}));
/**
 * Helper function to create a Network object.
 */
function createNetwork(guid, name, type, counters, lastResetTime) {
    return {
        guid: guid,
        name: name,
        type: type,
        counters: counters,
        lastResetTime: lastResetTime,
    };
}
/**
 * Replacer function used to handle the bigint type.
 */
function replacer(_key, value) {
    return typeof value === 'bigint' ? value.toString() : value;
}
/**
 * Converts a mojo time to JS. TODO(b/200327630)
 */
function convertMojoTimeToJS(mojoTime) {
    // The JS Date() is based off of the number of milliseconds since the
    // UNIX epoch (1970-01-01 00::00:00 UTC), while |internalValue| of the
    // base::Time (represented in mojom.Time) represents the number of
    // microseconds since the Windows FILETIME epoch (1601-01-01 00:00:00 UTC).
    // This computes the final JS time by computing the epoch delta and the
    // conversion from microseconds to milliseconds.
    const windowsEpoch = Date.UTC(1601, 0, 1, 0, 0, 0, 0);
    const unixEpoch = Date.UTC(1970, 0, 1, 0, 0, 0, 0);
    // |epochDeltaInMs| equals to base::Time::kTimeToMicrosecondsOffset.
    const epochDeltaInMs = unixEpoch - windowsEpoch;
    const timeInMs = Number(mojoTime.internalValue) / 1000;
    return new Date(timeInMs - epochDeltaInMs);
}
const TrafficCountersElementBase = I18nMixin(PolymerElement);
class TrafficCountersElement extends TrafficCountersElementBase {
    static get is() {
        return 'traffic-counters';
    }
    static get template() {
        return getTemplate$2j();
    }
    static get properties() {
        return {
            /**
             * Information about networks.
             */
            networks_: { type: Array, value: [] },
            /**
             * Expanded state per network type.
             */
            typeExpanded_: { type: Array, value: [] },
        };
    }
    constructor() {
        super();
        /**
         * Adapter to access traffic counters functionality.
         */
        this.trafficCountersAdapter_ = new TrafficCountersAdapter();
    }
    /**
     * Handles requests to request traffic counters.
     */
    async onRequestTrafficCountersClick_() {
        await this.fetchTrafficCountersForActiveNetworks_();
    }
    /**
     * Handles requests to reset traffic counters.
     */
    async onResetTrafficCountersClick_(event) {
        const network = event.model.network;
        await this.trafficCountersAdapter_.resetTrafficCountersForNetwork(network.guid);
        const trafficCounters = await this.trafficCountersAdapter_.requestTrafficCountersForNetwork(network.guid);
        const lastResetTime = await this.trafficCountersAdapter_.requestLastResetTimeForNetwork(network.guid);
        const foundIdx = this.networks_.findIndex(n => n.guid === network.guid);
        if (foundIdx === -1) {
            return;
        }
        this.splice('networks_', foundIdx, 1, createNetwork(network.guid, network.name, network.type, trafficCounters, lastResetTime));
    }
    /**
     * Requests traffic counters for networks.
     */
    async fetchTrafficCountersForActiveNetworks_() {
        const networks = await this.trafficCountersAdapter_
            .requestTrafficCountersForActiveNetworks();
        this.networks_ = networks;
        return this.networks_;
    }
    getNetworkTypeString_(type) {
        return this.i18n('OncType' + OncMojo.getNetworkTypeString(type));
    }
    getNetworkTypeIcon_(type) {
        switch (type) {
            case NetworkType.kEthernet:
                return TechnologyIcons.ETHERNET;
            case NetworkType.kWiFi:
                return TechnologyIcons.WIFI;
            case NetworkType.kVPN:
                return TechnologyIcons.VPN;
            case NetworkType.kTether:
            case NetworkType.kMobile:
            case NetworkType.kCellular:
                return TechnologyIcons.CELLULAR;
            default:
                return '';
        }
    }
    getTypeExpanded_(type) {
        if (this.typeExpanded_[type] === undefined) {
            this.set('typeExpanded_.' + type, false);
            return false;
        }
        return this.typeExpanded_[type];
    }
    /**
     * Helper function to toggle the expanded properties when the network
     * container is toggled.
     */
    onToggleExpanded_(event) {
        const type = event.model.network.type;
        this.set('typeExpanded_.' + type, !this.typeExpanded_[type]);
    }
    countersToString_(counters) {
        // '4' describes the number of white space characters to use as white space
        // while forming the JSON string.
        return JSON.stringify(counters, replacer, 4);
    }
    lastResetTimeString_(network) {
        if (network.lastResetTime === null || network.lastResetTime === undefined) {
            return '';
        }
        return convertMojoTimeToJS(network.lastResetTime).toLocaleString();
    }
}
customElements.define(TrafficCountersElement.is, TrafficCountersElement);

function getTemplate$2i() {
    return html `<!--_html_template_start_--><style include="internet-shared settings-shared iron-flex md-select">#data-usage-wrapper{align-items:center;display:flex}#resetDayHelpTooltip{margin-inline-end:15px}</style>
<div class="settings-box single-column stretch first">
  [[i18n('TrafficCountersDataUsageDifferentFromProviderLabel')]]
</div>
<div class="settings-box single-column stretch indented first">
  <div id="data-usage-wrapper">
    <div class="start settings-box-text">
      <div id="dataUsageLabel" class="label">
        [[date_]]
      </div>
      <div id="dataUsageSubLabel" class="secondary label">
        [[value_]]
      </div>
    </div>
    <cr-button id="resetDataUsageButton"
      aria-labelledby="dataUsageLabel"
      aria-describedby="dataUsageSubLabel"
      aria-roledescription="$i18n{TrafficCountersDataUsageResetLabel}"
      on-click="onResetDataUsageClick_">
      [[i18n('TrafficCountersDataUsageResetButtonLabel')]]
    </cr-button>
  </div>
  <div id="data-usage-wrapper">
    <div class="start settings-box-text">
      <div id="daySelectionLabel" class="label">
        [[i18n('TrafficCountersDataUsageAutoResetDayOfMonthLabel')]]
      </div>
      <div id="daySelectionSubLabel" class="secondary label">
        [[i18n('TrafficCountersDataUsageAutoResetDayOfMonthSubLabel')]]
      </div>
    </div>
    <cr-tooltip-icon id="resetDayHelpTooltip"
      icon-aria-label="$i18n{TrafficCountersDataUsageResetDayTooltipA11yLabel}"
      icon-class="cr:help-outline"
      tooltip-text="[[i18n('TrafficCountersDataUsageResetDayTooltipText')]]">
    </cr-tooltip-icon>
    <select class="md-select" id="resetDayList"
      aria-labelledby="daySelectionLabel"
      aria-describedby="daySelectionSubLabel"
      on-change="onResetDaySelected_">
      <template is="dom-repeat" items="[[getDaysList_()]]" as="day">
        <option value="[[day]]" selected$="[[isSelected_(day, resetDay_)]]">
          [[day]]
        </option>
      </template>
    </select>
  </div>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Polymer element to show traffic counters information in
 * Settings UI.
 */
/**
 * Default day of the month, e.g., First of January, during
 * which traffic counters are reset.
 */
const DEFAULT_RESET_DAY = 1;
const KB = 1000;
const MB = KB * 1000;
const GB = MB * 1000;
const TB = GB * 1000;
const PB = TB * 1000;
/**
 * Returns a formatted string with the appropriate unit label and data size
 * fixed to two decimal values.
 */
function getDataInfoString(totalBytes) {
    let unit = 'B';
    let dividend = 1;
    if (totalBytes >= PB) {
        unit = 'PB';
        dividend = PB;
    }
    else if (totalBytes >= TB) {
        unit = 'TB';
        dividend = TB;
    }
    else if (totalBytes >= GB) {
        unit = 'GB';
        dividend = GB;
    }
    else if (totalBytes >= MB) {
        unit = 'MB';
        dividend = MB;
    }
    else if (totalBytes >= KB) {
        unit = 'KB';
        dividend = KB;
    }
    const numBytes = (Number(totalBytes) / dividend).toFixed(2);
    return `${numBytes} ${unit}`;
}
const SettingsTrafficCountersElementBase = I18nMixin(PolymerElement);
class SettingsTrafficCountersElement extends SettingsTrafficCountersElementBase {
    static get is() {
        return 'settings-traffic-counters';
    }
    static get template() {
        return getTemplate$2i();
    }
    static get properties() {
        return {
            /** The network GUID to display details for. */
            guid: {
                type: String,
                value: '',
                observer: 'load',
            },
            /**
             * Tracks the managed properties of the network. Used to handle network
             * network state changes.
             * */
            managedProperties: {
                type: Object,
                observer: 'managedPropertiesChanged_',
            },
            /** Tracks the last reset time information. */
            date_: {
                type: String,
                value: '',
            },
            /** Tracks the traffic counter information. */
            value_: {
                type: String,
                value: '',
            },
            /** Tracks the user specified day of reset. Default is 1. */
            resetDay_: {
                type: Number,
                value: DEFAULT_RESET_DAY,
            },
        };
    }
    constructor() {
        super();
        /**
         * Adapter to collect network related information.
         */
        this.trafficCountersAdapter_ = new TrafficCountersAdapter();
    }
    /**
     * Loads all the values needed to populate the HTML.
     */
    load() {
        this.populateDate_();
        this.populateDataUsageValue_();
        this.populateUserSpecifiedResetDay_();
    }
    managedPropertiesChanged_() {
        this.load();
    }
    /**
     * Handles reset requests.
     */
    async onResetDataUsageClick_() {
        await this.trafficCountersAdapter_.resetTrafficCountersForNetwork(this.guid);
        this.load();
        getInstance().announce(this.i18n('TrafficCountersDataUsageResetButtonPressedA11yMessage'));
    }
    /**
     * Returns the network matching |this.guid| if it can be successfully
     * requested. Returns null otherwise.
     */
    async getNetworkIfAvailable_() {
        const networks = await this.trafficCountersAdapter_
            .requestTrafficCountersForActiveNetworks();
        const network = networks.find(n => n.guid === this.guid);
        return network || null;
    }
    /**
     * Determines the last reset time of the data usage.
     */
    async populateDate_() {
        const result = await this.populateDateHelper_();
        this.date_ = result;
    }
    /**
     * Gathers last reset time information.
     */
    async populateDateHelper_() {
        const network = await this.getNetworkIfAvailable_();
        if (network === null || network.friendlyDate === null) {
            return this.i18n('TrafficCountersDataUsageLastResetDateUnavailableLabel');
        }
        return this.i18n('TrafficCountersDataUsageSinceLabel', network.friendlyDate);
    }
    /**
     * Determines the data usage value.
     */
    async populateDataUsageValue_() {
        const result = await this.populateDataUsageValueHelper_();
        this.value_ = result;
    }
    /**
     * Gathers the data usage value information.
     */
    async populateDataUsageValueHelper_() {
        const network = await this.getNetworkIfAvailable_();
        if (network === null) {
            return getDataInfoString(BigInt(0));
        }
        let totalBytes = BigInt(0);
        for (const sourceDict of network.counters) {
            totalBytes += BigInt(sourceDict.rxBytes) + BigInt(sourceDict.txBytes);
        }
        return getDataInfoString(totalBytes);
    }
    /**
     * Determines the reset day.
     */
    async populateUserSpecifiedResetDay_() {
        const result = await this.populateUserSpecifiedResetDayHelper_();
        this.resetDay_ = result;
    }
    /**
     * Gathers the reset day information (helper).
     */
    async populateUserSpecifiedResetDayHelper_() {
        const network = await this.getNetworkIfAvailable_();
        return network ? network.userSpecifiedResetDay : DEFAULT_RESET_DAY;
    }
    /**
     * Handles day of reset changes.
     */
    onResetDaySelected_() {
        this.resetDay_ = Number(this.$.resetDayList.value);
        this.trafficCountersAdapter_.setTrafficCountersResetDayForNetwork(this.guid, { value: this.resetDay_ });
    }
    /**
     * Tracks the list of options available in the reset day dropdown.
     */
    getDaysList_() {
        return Array.from({ length: 31 }, (_, i) => i + 1);
    }
    /**
     * Determines if the given day should be marked as selected in the dropdown.
     *
     * @param item - The day number from the dropdown options to check
     *     against the selected day.
     * @param selectedDay - The day currently set as selected in the
     *     component's state.
     */
    isSelected_(item, selectedDay) {
        return item === selectedDay;
    }
}
customElements.define(SettingsTrafficCountersElement.is, SettingsTrafficCountersElement);

function getTemplate$2h() {
    return html `<!--_html_template_start_--><style include="settings-shared iron-flex">:host{--section-padding:24px;--bottom-padding:20px;--cr-dialog-title-slot-padding-top:var(--section-padding);--cr-dialog-title-slot-padding-bottom:var(--section-padding);--cr-dialog-title-slot-padding-start:var(--section-padding);--cr-dialog-title-slot-padding-end:var(--section-padding);--cr-dialog-button-container-padding-horizontal:var(--section-padding);--cr-dialog-button-container-padding-bottom:var(--bottom-padding)}[slot=body]>*{margin-inline-start:5px}iron-icon{--iron-icon-fill-color:var(--cros-icon-color-prominent)}#host-device-text-container{display:flex;flex-direction:column;margin-inline-start:18px}#availability-title{color:var(--cros-text-color-secondary);margin-top:5px}#host-device-container{align-items:center;display:flex;margin-top:12px;min-height:46px}#tether-explanation,#tether-carrier-warning,#tether-description-title{margin-top:var(--cr-section-vertical-margin)}#tether-carrier-warning{font-weight:600}#tether-description-list{padding-inline-start:16px}#host-device-lost-container{color:var(--cros-text-color-alert);font-weight:500}#host-device-lost-container iron-icon{--iron-icon-fill-color:var(--cros-icon-color-alert)}</style>
<cr-dialog id="dialog" close-text="$i18n{close}">
  <div slot="title">$i18n{tetherConnectionDialogTitle}</div>
  <div slot="body">
    <span id="availability-title">
      $i18n{tetherConnectionAvailableDeviceTitle}
    </span>
    <div id="host-device-container">
      <iron-icon id="host-device-signal-strength-icon"
          icon="[[getSignalStrengthIconName_(managedProperties)]]"
          aria-label$="[[getSignalStrengthLabel_(managedProperties)]]">
      </iron-icon>
      <div id="host-device-text-container">
        <span id="host-device-text-name"
            aria-describedby="host-device-signal-strength-icon
            hostDeviceTextBattery">
          [[getDeviceName_(managedProperties)]]
        </span>
        <span id="hostDeviceTextBattery" class="secondary"
            aria-hidden="true">
          [[getBatteryPercentageString_(managedProperties)]]
        </span>
      </div>
      <div class="flex"></div>
      <div id="host-device-lost-container" hidden$="[[!outOfRange]]">
        <iron-icon icon="os-settings:alert-device-out-of-range">
        </iron-icon>
        $i18n{tetherPhoneOutOfRange}
      </div>
    </div>
    <div id="tether-explanation">
      [[getExplanation_(managedProperties)]]
    </div>
    <div id="tether-carrier-warning">
      $i18n{tetherConnectionCarrierWarning}
    </div>
    <div id="tether-description-title">
      [[getDescriptionTitle_(managedProperties)]]
    </div>
    <ul id="tether-description-list">
      <li>$i18n{tetherConnectionDescriptionMobileData}</li>
      <li>[[getBatteryDescription_(managedProperties)]]</li>
      <li hidden$="[[!shouldShowDisconnectFromWifi_(managedProperties)]]">
        $i18n{tetherConnectionDescriptionWiFi}
      </li>
    </ul>
  </div>
  <div slot="button-container">
    <cr-button class="cancel-button" on-click="onNotNowClick_">
      $i18n{tetherConnectionNotNowButton}
    </cr-button>
    <cr-button id="connectButton" class="action-button"
        on-click="onConnectClick_" disabled="[[outOfRange]]">
      $i18n{tetherConnectionConnectButton}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Maps signal strength from [0, 100] to [0, 4] which represents the number
 * of bars in the signal icon displayed to the user. This is used to select
 * the correct icon.
 * @param strength The signal strength from [0 - 100].
 * @return The number of signal bars from [0, 4] as an integer
 */
function signalStrengthToBarCount(strength) {
    if (strength > 75) {
        return 4;
    }
    if (strength > 50) {
        return 3;
    }
    if (strength > 25) {
        return 2;
    }
    if (strength > 0) {
        return 1;
    }
    return 0;
}
const TetherConnectionDialogElementBase = I18nMixin(PolymerElement);
class TetherConnectionDialogElement extends TetherConnectionDialogElementBase {
    static get is() {
        return 'tether-connection-dialog';
    }
    static get template() {
        return getTemplate$2h();
    }
    static get properties() {
        return {
            managedProperties: Object,
            /**
             * Whether the network has been lost (e.g., has gone out of range).
             */
            outOfRange: Boolean,
        };
    }
    open() {
        const dialog = this.getDialog_();
        if (!dialog.open) {
            dialog.showModal();
        }
        this.shadowRoot.querySelector('#connectButton').focus();
    }
    close() {
        const dialog = this.getDialog_();
        if (dialog.open) {
            dialog.close();
        }
    }
    getDialog_() {
        return castExists(this.shadowRoot.querySelector('#dialog'));
    }
    onNotNowClick_() {
        this.getDialog_().cancel();
    }
    onConnectClick_() {
        const event = new CustomEvent('tether-connect', { bubbles: true, composed: true });
        this.dispatchEvent(event);
    }
    shouldShowDisconnectFromWifi_(_managedProperties) {
        // TODO(khorimoto): Pipe through a new network property which describes
        // whether the tether host is currently connected to a Wi-Fi network. Return
        // whether it is here.
        return true;
    }
    /**
     * @return The battery percentage integer value converted to a
     *     string. Note that this will not return a string with a "%" suffix.
     */
    getBatteryPercentageAsString_(managedProperties) {
        return managedProperties ?
            managedProperties.typeProperties.tether.batteryPercentage.toString() :
            '0';
    }
    /**
     * Retrieves an image that corresponds to signal strength of the tether host.
     * Custom icons are used here instead of a <network-icon> because this
     * dialog uses a special color scheme.
     */
    getSignalStrengthIconName_(managedProperties) {
        const signalStrength = managedProperties ?
            managedProperties.typeProperties.tether.signalStrength :
            0;
        const barCount = signalStrengthToBarCount(signalStrength);
        return `os-settings:signal-cellular-${barCount}-bar`;
    }
    /**
     * Retrieves a localized accessibility label for the signal strength.
     */
    getSignalStrengthLabel_(managedProperties) {
        const signalStrength = managedProperties ?
            managedProperties.typeProperties.tether.signalStrength :
            0;
        const networkTypeString = this.i18n('OncTypeTether');
        return this.i18n('networkIconLabelSignalStrength', networkTypeString, signalStrength);
    }
    getDeviceName_(managedProperties) {
        return managedProperties ? OncMojo.getNetworkNameUnsafe(managedProperties) :
            '';
    }
    getBatteryPercentageString_(managedProperties) {
        return managedProperties ?
            this.i18n('tetherConnectionBatteryPercentage', this.getBatteryPercentageAsString_(managedProperties)) :
            '';
    }
    getExplanation_(managedProperties) {
        return managedProperties ?
            loadTimeData.getStringF('tetherConnectionExplanation', OncMojo.getNetworkNameUnsafe(managedProperties)) :
            '';
    }
    getDescriptionTitle_(managedProperties) {
        return managedProperties ?
            loadTimeData.getStringF('tetherConnectionDescriptionTitle', OncMojo.getNetworkNameUnsafe(managedProperties)) :
            '';
    }
    getBatteryDescription_(managedProperties) {
        return managedProperties ?
            this.i18n('tetherConnectionDescriptionBattery', this.getBatteryPercentageAsString_(managedProperties)) :
            '';
    }
}
customElements.define(TetherConnectionDialogElement.is, TetherConnectionDialogElement);

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
let instance$9 = null;
class OsSyncBrowserProxyImpl {
    static getInstance() {
        return instance$9 || (instance$9 = new OsSyncBrowserProxyImpl());
    }
    static setInstanceForTesting(obj) {
        instance$9 = obj;
    }
    didNavigateToOsSyncPage() {
        chrome.send('DidNavigateToOsSyncPage');
    }
    didNavigateAwayFromOsSyncPage() {
        chrome.send('DidNavigateAwayFromOsSyncPage');
    }
    sendOsSyncPrefsChanged() {
        chrome.send('OsSyncPrefsDispatch');
    }
    setOsSyncDatatypes(osSyncPrefs) {
        chrome.send('SetOsSyncDatatypes', [osSyncPrefs]);
    }
}

function getTemplate$2g() {
    return html `<!--_html_template_start_--><style include="internet-shared settings-shared iron-flex">:host{padding-bottom:40px}iron-icon{margin-inline-end:10px}cr-policy-indicator{margin-inline-start:var(--cr-controlled-by-spacing)}cr-policy-network-indicator-mojo{margin:0 var(--cr-controlled-by-spacing)}#networkState[connected]{color:var(--cros-text-color-positive)}#networkState[warning]{color:var(--cros-text-color-warning)}#networkState[error]{color:var(--cros-text-color-alert)}#preferNetworkToggleContainer:hover{background-color:var(--cr-hover-background-color)}#preferNetworkToggleContainer:active{background-color:var(--cr-active-background-color)}paper-spinner-lite{height:var(--cr-icon-size);width:var(--cr-icon-size)}.warning{color:var(--cr-secondary-text-color);margin-inline-start:var(--cr-controlled-by-spacing)}#signinButton>iron-icon{margin-inline-end:0}#mac-address-container{border-top:none}#hiddenToggle{margin-inline-start:var(--cr-section-padding)}cr-link-row:not([warning]){--cr-secondary-text-color:var(--cros-text-color-positive)}#apnSubpageButton{height:var(--cr-section-two-line-min-height)}</style>
<!-- Title section: Icon + name + connection state. -->
<div id="titleDiv" class="settings-box first">
  <div class="start layout horizontal center">
    <network-icon
        show-technology-badge="[[showTechnologyBadge_]]"
        network-state="[[getNetworkState_(managedProperties_)]]">
    </network-icon>
    <div id="networkState" class="title settings-box-text"
        connected$="[[showConnectedState_(managedProperties_)]]"
        warning$="[[showRestrictedConnectivity_(managedProperties_,
                           deviceState_)]]"
        error$="[[isOutOfRangeOrNotEnabled_(outOfRange_, deviceState_)]]">
      [[getStateText_(managedProperties_, propertiesReceived_,
          outOfRange_, deviceState_)]]
    </div>
    <template is="dom-if"
        if="[[isPolicySource(managedProperties_.source))]]">
      <cr-policy-indicator
          indicator-type="[[getIndicatorTypeForSource(
              managedProperties_.source)]]">
      </cr-policy-indicator>
    </template>
  </div>
  <cr-button id="signinButton" on-click="onSigninClick_"
      hidden$="[[!showSignin_(managedProperties_)]]"
      disabled="[[disableSignin_(managedProperties_, disabled_)]]">
    <iron-icon icon="cr:open-in-new" slot="prefix-icon"></iron-icon>
    $i18n{networkButtonSignin}
  </cr-button>
  <cr-button id="forgetButton" on-click="onForgetClick_"
      hidden$="[[!showForget_(managedProperties_)]]"
      disabled="[[disableForget_(managedProperties_,
          prefs.vpn_config_allowed, disabled_)]]">
    $i18n{networkButtonForget}
  </cr-button>
  <cr-button id="viewAccountButton"
      on-click="onViewAccountClick_"
      hidden$="[[!showViewAccount_(managedProperties_)]]"
      disabled="[[disabled_]]">
    $i18n{networkButtonViewAccount}
  </cr-button>
  <cr-button id="activateButton"
      on-click="onActivateClick_"
      hidden$="[[!showActivate_(managedProperties_)]]"
      disabled="[[disabled_]]">
    $i18n{networkButtonActivate}
  </cr-button>
  <cr-button id="configureButton" on-click="onConfigureClick_"
      hidden$="[[!showConfigure_(managedProperties_, globalPolicy,
          managedNetworkAvailable)]]"
      disabled="[[disableConfigure_(managedProperties_,
          prefs.vpn_config_allowed, disabled_)]]"
      deep-link-focus-id$="[[Setting.kConfigureEthernet]]">
    $i18n{networkButtonConfigure}
  </cr-button>
  <!-- Use policy properties from vpn_config_allowed to indicate when that
      pref disables buttons in this row. -->
  <controlled-button id="connectDisconnect" class="action-button"
      on-click="onConnectDisconnectClick_"
      hidden$="[[shouldConnectDisconnectButtonBeHidden_(
          managedProperties_, globalPolicy, managedNetworkAvailable,
          deviceState_)]]"
      disabled="[[shouldConnectDisconnectButtonBeDisabled_(
          managedProperties_, defaultNetwork, propertiesReceived_,
          outOfRange_, globalPolicy, managedNetworkAvailable,
          deviceState_, disabled_)]]"
      label="[[getConnectDisconnectButtonLabel_(managedProperties_,
          globalPolicy,managedNetworkAvailable, deviceState_)]]"
      pref="[[getFakeVpnConfigPrefForEnforcement_(managedProperties_,
          prefs.vpn_config_allowed)]]"
      deep-link-focus-id$="[[Setting.kDisconnectWifiNetwork]]
          [[Setting.kDisconnectCellularNetwork]]
          [[Setting.kDisconnectTetherNetwork]]">
  </controlled-button>
</div>


<!-- Start of NOTICES section. -->
<!-- If row ordering changes, messagesDividerClass_() must be updated. -->
<template is="dom-if" if="[[isBlockedByPolicy_(managedProperties_,
                            globalPolicy, managedNetworkAvailable)]]">
  <!-- Disabled by policy -->
  <div class="settings-box continuation">
    <iron-icon class="policy" icon="cr20:domain"></iron-icon>
    <div class="settings-box-text">$i18n{networkConnectNotAllowed}</div>
  </div>
</template>

<template is="dom-if" if="[[isSecondaryUser_]]">
  <!-- Non primary users. -->
  <div class$="settings-box single-column
              [[messagesDividerClass_('secondary', managedProperties_,
                  globalPolicy, managedNetworkAvailable,
                  isSecondaryUser_, isWifiSyncEnabled_, deviceState_)]]">
    <div class="layout horizontal center">
      <iron-icon class="policy" icon="cr:group"></iron-icon>
      <div class="settings-box-text">
        [[i18n('networkPrimaryUserControlled', primaryUserEmail_)]]
      </div>
    </div>
  </div>
</template>


<template is="dom-if"
    if="[[showShared_(managedProperties_, globalPolicy,
        managedNetworkAvailable, deviceState_)]]">
  <!-- Shared network. -->
  <div class$="settings-box settings-box-text
              [[messagesDividerClass_('shared', managedProperties_,
                  globalPolicy, managedNetworkAvailable,
                  isSecondaryUser_, isWifiSyncEnabled_, deviceState_)]]">
      [[sharedString_(managedProperties_)]]
  </div>
</template>
<template is="dom-if"
    if="[[showSynced_(managedProperties_, globalPolicy,
        managedNetworkAvailable, isWifiSyncEnabled_)]]">
  <!-- Synced network. -->
  <div class$="settings-box settings-box-text
              [[messagesDividerClass_('synced', managedProperties_,
                  globalPolicy, managedNetworkAvailable,
                  isSecondaryUser_, isWifiSyncEnabled_, deviceState_)]]">
      <localized-link
          localized-string="[[syncedString_(managedProperties_)]]">
      </localized-link>
  </div>
</template>
<template is="dom-if"
    if="[[isCarrierLockedActiveSim_(managedProperties_, deviceState_)]]">
  <!-- Carrier locked network. -->
  <div class$="settings-box settings-box-text
      [[messagesDividerClass_('carrierlocked', managedProperties_,
          globalPolicy, managedNetworkAvailable,
          isSecondaryUser_, isWifiSyncEnabled_, deviceState_)]]">
    <localized-link id="carrierLockedNoticeLink"
        localized-string="[[i18nAdvanced('networkCarrierLocked')]]">
    </localized-link>
  </div>
</template>
<!-- End of NOTICES section -->

<template is="dom-if" if="[[!isSecondaryUser_]]">
  <template is="dom-if" if="[[showConfigurableSections_]]"  restamp>
    <!-- Prefer this network. -->
    <template is="dom-if"
        if="[[showPreferNetwork_(managedProperties_, globalPolicy,
            managedNetworkAvailable)]]">
      <div id="preferNetworkToggleContainer" class="settings-box"
          on-click="onPreferNetworkRowClicked_"
          actionable$="[[!isNetworkPolicyEnforced(
              managedProperties_.priority)]]">
        <div id="preferNetworkToggleLabel" class="start settings-box-text">
          $i18n{networkPrefer}
          <div class="secondary">
            $i18n{networkPreferDescription}
          </div>
        </div>
        <cr-policy-network-indicator-mojo
            property="[[managedProperties_.priority]]">
        </cr-policy-network-indicator-mojo>
        <cr-toggle id="preferNetworkToggle" checked="{{preferNetwork_}}"
            disabled="[[shouldPreferNetworkToggleBeDisabled_(
                managedProperties_.priority, disabled_)]]"
            aria-labelledby="preferNetworkToggleLabel"
            deep-link-focus-id$="[[Setting.kPreferWifiNetwork]]">
        </cr-toggle>
      </div>
    </template>
    <!-- Autoconnect. -->
    <template is="dom-if"
        if="[[showAutoConnect_(managedProperties_, globalPolicy,
            managedNetworkAvailable)]]">
      <settings-toggle-button id="autoConnectToggle" class="hr"
          pref="{{autoConnectPref_}}"
          label="[[getAutoConnectToggleLabel_(managedProperties_)]]"
          deep-link-focus-id$="[[Setting.kWifiAutoConnectToNetwork]]
              [[Setting.kCellularAutoConnectToNetwork]]"
          disabled="[[disabled_]]">
      </settings-toggle-button>
      <!-- Hidden Network Warning -->
      <template is="dom-if"
          if="[[showHiddenNetworkWarning_(autoConnectPref_.*,
              managedProperties_)]]"
          restamp>
        <div class="warning">
          <iron-icon icon="cr:warning"></iron-icon>
          [[i18n('hiddenNetworkWarning')]]
        </div>
      </template>
    </template>
    <!-- Always-on VPN. -->
    <template is="dom-if"
        if="[[showAlwaysOnVpn_(managedProperties_)]]">
      <settings-toggle-button id="alwaysOnVpnToggle" class="hr"
          pref="{{alwaysOnVpn_}}"
          label="$i18n{networkAlwaysOnVpn}"
          disabled="[[disabled_]]">
      </settings-toggle-button>
    </template>
    <!-- Data roaming (Cellular only). -->
    <template is="dom-if" if="[[isCellular_(managedProperties_)]]">
      <cellular-roaming-toggle-button
        disabled="[[disabled_]]"
        managed-properties="[[managedProperties_]]"
        prefs="{{prefs}}">
      </cellular-roaming-toggle-button>
    </template>
    <!-- Public Key (WireGuard VPN only). -->
    <template is="dom-if" if="[[isWireGuard_(managedProperties_)]]">
      <div id="wgPublicKeyField"
          class="settings-box two-line single-column stretch settings-box-text">
        <div aria-hidden="true" id="wgPublicKeyLabel">
          $i18n{OncVPN-WireGuard-PublicKey}
        </div>
        <div class="secondary" aria-labelledby="wgPublicKeyLabel">
          [[managedProperties_.typeProperties.vpn.wireguard.publicKey.activeValue]]
        </div>
      </div>
    </template>
    <!-- IP Address. -->
    <div
      class="settings-box two-line single-column stretch settings-box-text"
      hidden$="[[!showIpAddress_(ipAddress_, managedProperties_)]]">
      <div>$i18n{networkIPAddress}</div>
      <div class="secondary">[[ipAddress_]]</div>
    </div>
    <!-- Properties to always show if present. -->
    <template is="dom-if" if="[[hasInfoFields_(managedProperties_)]]">
      <div class="settings-box single-column stretch">
        <network-property-list-mojo id="infoFields"
            fields="[[getInfoFields_(managedProperties_)]]"
            edit-field-types="[[getInfoEditFieldTypes_(
              managedProperties_)]]"
            property-dict="[[managedProperties_]]"
            on-property-change="onNetworkPropertyChange_"
            disabled="[[disabled_]]">
        </network-property-list-mojo>
      </div>
    </template>
  </template>

  <!-- APN row item -->
  <template is="dom-if" if="[[showConfigurableSections_]]" restamp>
    <template is="dom-if" if="[[shouldShowApnRow_(managedProperties_,
        isApnRevampEnabled_)]]">
      <cr-link-row
          id="apnSubpageButton"
          class="hr"
          label="$i18n{internetApnPageTitle}"
          sub-label="[[getApnRowSubLabel_(managedProperties_)]]"
          on-click="onApnRowClicked_"
          role-description="$i18n{subpageArrowRoleDescription}"
          warning$="[[showRestrictedConnectivity_(managedProperties_,
              deviceState_)]]"
          disabled="[[disabled_]]">
        <template is="dom-if" if="[[isApnManaged_(globalPolicy)]]">
          <cr-policy-indicator id="apnManagedIcon"
              indicator-type="devicePolicy"
              icon-aria-label="$i18n{internetApnPageTitle}">
          </cr-policy-indicator>
        </template>
      </cr-link-row>
    </template>
  </template>

  <!-- Passpoint provider link -->
  <template is="dom-if" if="[[shouldShowPasspointProviderRow_(
        managedProperties_)]]">
    <div id="passpointProviderRow" class="settings-box two-line"
        on-click="onPasspointRowClicked_">
      <div class="flex settings-box-text">
        <div>$i18n{passpointProviderLabel}</div>
        <div class="secondary">
          [[getPasspointSubscriptionName_(passpointSubscription_)]]
        </div>
      </div>
      <cr-icon-button class="subpage-arrow"
          aria-roledescription="$i18n{subpageArrowRoleDescription}">
      </cr-icon-button>
    </div>
  </template>

  <template is="dom-if" if="[[hasAdvancedSection_(managedProperties_,
                              propertiesReceived_, deviceState_)]]">
    <!-- Advanced toggle. -->
    <cr-expand-button
        id="advancedSectionToggle"
        aria-label="$i18n{networkSectionAdvancedA11yLabel}"
        class="settings-box"
        expanded="{{advancedExpanded_}}">
      $i18n{networkSectionAdvanced}
    </cr-expand-button>

    <!-- Advanced section -->
    <iron-collapse opened="[[advancedExpanded_]]">
      <div class="settings-box single-column stretch indented first">
          <!-- SIM Info (Cellular only). -->
        <template is="dom-if"
            if="[[showCellularSimUpdatedUi_(managedProperties_)]]" restamp>
          <div class="single-column stretch">
            <network-siminfo id="cellularSimInfoAdvanced"
                network-state="[[getNetworkState_(managedProperties_)]]"
                device-state="[[deviceState_]]"
                global-policy="[[globalPolicy]]"
                disabled="[[disabled_]]">
            </network-siminfo>
          </div>
        </template>

        <!-- Suppress Text Messages (Cellular only). -->
        <template is="dom-if"
            if="[[shouldShowSuppressTextMessagesToggle_(managedProperties_,
                  deviceState_)]]" restamp>
          <div class="single-column stretch">
            <network-config-toggle id="suppressTextMessagesToggle" policy-on-left
                property="[[managedProperties_.typeProperties.cellular.allowTextMessages]]"
                label="$i18n{networkSuppressTextMessages}"
                checked="{{suppressTextMessagesOverride_}}"
                on-checked-changed="suppressTextMessagesChanged_"
                disabled="[[disabled_]]">
            </network-config-toggle>
          </div>
        </template>

        <!-- Metered (WiFi and Cellular only). -->
        <template is="dom-if"
            if="[[showMetered_(managedProperties_)]]">
          <network-config-toggle id="meteredToggle" policy-on-left
              property="[[managedProperties_.metered]]"
              label="$i18n{networkMetered}"
              sub-label="$i18n{networkMeteredDesc}"
              checked="{{meteredOverride_}}"
              on-checked-changed="meteredChanged_"
              deep-link-focus-id$="[[Setting.kWifiMetered]]
                  [[Setting.kCellularMetered]]"
              disabled="[[disabled_]]">
          </network-config-toggle>
        </template>
        <!-- Advanced properties -->
        <template is="dom-if"
            if="[[hasAdvancedFields_(managedProperties_)]]">
          <network-property-list-mojo id="advancedFields"
              fields="[[getAdvancedFields_(managedProperties_)]]"
              property-dict="[[managedProperties_]]"
              disabled="[[disabled_]]">
          </network-property-list-mojo>
        </template>
        <!-- Device properties -->
        <template is="dom-if"
            if="[[hasDeviceFields_(managedProperties_, deviceState_)]]">
          <network-property-list-mojo id="deviceFields"
              fields="[[getDeviceFields_(managedProperties_,
                  deviceState_)]]"
              property-dict="[[managedProperties_]]"
              disabled="[[disabled_]]">
          </network-property-list-mojo>
        </template>
      </div>
    </iron-collapse>
  </template>

  <template is="dom-if" if="[[showDataUsage_(managedProperties_,
      trafficCountersAvailable_)]]">
    <!-- Data usage toggle. -->
    <cr-expand-button
        aria-label="$i18n{TrafficCountersDataUsageLabel}"
        class="settings-box"
        expanded="{{dataUsageExpanded_}}">
      $i18n{TrafficCountersDataUsageLabel}
    </cr-expand-button>

    <!-- Data usage section -->
    <iron-collapse opened="[[dataUsageExpanded_]]">
      <settings-traffic-counters id="settingsTrafficCounters"
          guid="[[guid]]"
          managed-properties="[[managedProperties_]]"
          on-reset-day-changed="computeTrafficCountersAvailable_"
          on-reset-data-usage-button-clicked="computeTrafficCountersAvailable_">
      </settings-traffic-counters>
    </iron-collapse>
  </template>

  <template is="dom-if" if="[[showConfigurableSections_]]"  restamp>
    <template is="dom-if" if="[[hasNetworkSection_(managedProperties_,
        globalPolicy, managedNetworkAvailable)]]">
      <!-- Network toggle -->
      <cr-expand-button
          id="configurableSections"
          aria-label="$i18n{networkSectionNetworkExpandA11yLabel}"
          class="settings-box"
          expanded="{{networkExpanded_}}">
        <div class="settings-row">
          <div class="start">
            $i18n{networkSectionNetwork}
          </div>
          <template is="dom-if" if="[[showScanningSpinner_(
              managedProperties_, deviceState_)]]">
            <paper-spinner-lite active
                title="$i18n{mobileNetworkScanningLabel}">
            </paper-spinner-lite>
          </template>
        </div>
      </cr-expand-button>

      <iron-collapse opened="[[networkExpanded_]]">
        <div class="settings-box single-column stretch indented first">
          <!-- Choose Mobile Network (Cellular only). -->
          <template is="dom-if"
              if="[[showCellularChooseNetwork_(managedProperties_)]]">
            <network-choose-mobile device-state="[[deviceState_]]"
                managed-properties="[[managedProperties_]]"
                disabled="[[disabled_]]">
            </network-choose-mobile>
          </template>

          <!-- APN -->
          <template is="dom-if" if="[[shouldShowApnList_(managedProperties_,
              isApnRevampEnabled_)]]">
            <network-apnlist on-apn-change="onApnChange_"
                managed-properties="[[managedProperties_]]"
                disabled="[[disabled_]]">
            </network-apnlist>
          </template>

          <!-- IP Config, Nameservers -->
          <template is="dom-if"
              if="[[isRememberedOrConnected_(managedProperties_)]]">
            <network-ip-config on-ip-change="onIpConfigChange_"
                managed-properties="[[managedProperties_]]"
                disabled="[[disabled_]]">
            </network-ip-config>
            <network-nameservers on-nameservers-change="onIpConfigChange_"
                managed-properties="[[managedProperties_]]"
                disabled="[[disabled_]]">
            </network-nameservers>
          </template>
        </div>

        <!-- MAC Address. -->
        <div class="settings-box two-line single-column stretch indented"
            id="mac-address-container"
            hidden$="[[!shouldShowMacAddress_(deviceState_)]]">
          <div>$i18n{OncMacAddress}</div>
          <div class="secondary">[[getMacAddress_(deviceState_)]]</div>
        </div>

        <!-- Hidden. -->
        <template is="dom-if"
            if="[[showHiddenNetworkToggle_(
                    globalPolicy,
                    managedNetworkAvailable,
                    managedProperties_)]]">
          <settings-toggle-button id="hiddenToggle"
              pref="{{hiddenPref_}}"
              label="$i18n{networkHidden}"
              sub-label="$i18n{networkHiddenSublabel}"
              sub-label-icon="cr20:warning"
              learn-more-url="$i18n{wifiHiddenNetworkLearnMoreUrl}"
              deep-link-focus-id$="[[Setting.kWifiHidden]]">
          </settings-toggle-button>
        </template>
      </iron-collapse>
    </template>

    <template is="dom-if" if="[[hasProxySection_(managedProperties_,
        globalPolicy, managedNetworkAvailable)]]">
      <!-- Proxy toggle -->
      <cr-expand-button
          id="proxySectionToggle"
          aria-label="$i18n{networkSectionProxyExpandA11yLabel}"
          class="settings-box"
          expanded="{{proxyExpanded_}}">
        $i18n{networkSectionProxy}
      </cr-expand-button>

      <iron-collapse opened="[[proxyExpanded_]]">
        <network-proxy-section prefs="{{prefs}}"
            on-proxy-change="onProxyChange_"
            managed-properties="[[managedProperties_]]"
            disabled="[[disabled_]]">
        </network-proxy-section>
      </iron-collapse>
    </template>
  </template>
</template>
<template is="dom-if" if="[[isTether_(managedProperties_)]]" restamp>
  <tether-connection-dialog id="tetherDialog"
      managed-properties="[[managedProperties_]]"
      on-tether-connect="onTetherConnect_"
      out-of-range="[[outOfRange_]]">
  </tether-connection-dialog>
</template>
<template is="dom-if" if="[[isPasspointWifi_(managedProperties_)]]" restamp>
  <!-- Passpoint subscription removal confirmation dialog -->
  <passpoint-remove-dialog id="passpointRemovalDialog"
      on-confirm="onPasspointRemovalDialogConfirm_">
  </passpoint-remove-dialog>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'settings-internet-detail' is the settings subpage containing details
 * for a network.
 */
const SettingsInternetDetailPageElementBase = mixinBehaviors([
    NetworkListenerBehavior,
    CrPolicyNetworkBehaviorMojo,
], DeepLinkingMixin(PrefsMixin(RouteObserverMixin(WebUiListenerMixin(I18nMixin(PolymerElement))))));
class SettingsInternetDetailPageElement extends SettingsInternetDetailPageElementBase {
    static get is() {
        return 'settings-internet-detail-subpage';
    }
    static get template() {
        return getTemplate$2g();
    }
    static get properties() {
        return {
            /** The network GUID to display details for. */
            guid: String,
            /**
             * Whether network configuration properties sections should be shown. The
             * advanced section is not controlled by this property.
             */
            showConfigurableSections_: {
                type: Boolean,
                value: true,
                computed: 'computeShowConfigurableSections_(deviceState_, managedProperties_)',
            },
            isWifiSyncEnabled_: Boolean,
            managedProperties_: {
                type: Object,
                observer: 'managedPropertiesChanged_',
            },
            deviceState_: {
                type: Object,
                value: null,
            },
            isSecondaryUser_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('isSecondaryUser');
                },
                readOnly: true,
            },
            primaryUserEmail_: {
                type: String,
                value() {
                    return loadTimeData.getBoolean('isSecondaryUser') ?
                        loadTimeData.getString('primaryUserEmail') :
                        '';
                },
                readOnly: true,
            },
            /**
             * Whether the network has been lost (e.g., has gone out of range). A
             * network is considered to be lost when a OnNetworkStateListChanged
             * is signaled and the new network list does not contain the GUID of the
             * current network.
             */
            outOfRange_: {
                type: Boolean,
                value: false,
            },
            /**
             * Highest priority connected network or null.
             */
            defaultNetwork: {
                type: Object,
                value: null,
            },
            globalPolicy: Object,
            /**
             * Whether a managed network is available in the visible network list.
             */
            managedNetworkAvailable: {
                type: Boolean,
                value: false,
            },
            /**
             * The network AutoConnect state as a fake preference object.
             */
            autoConnectPref_: {
                type: Object,
                observer: 'autoConnectPrefChanged_',
                value() {
                    return {
                        key: 'fakeAutoConnectPref',
                        type: chrome.settingsPrivate.PrefType.BOOLEAN,
                        value: false,
                    };
                },
            },
            /**
             * The network hidden state as a fake preference object.
             */
            hiddenPref_: {
                type: Object,
                observer: 'hiddenPrefChanged_',
                value() {
                    return {
                        key: 'fakeHiddenPref',
                        type: chrome.settingsPrivate.PrefType.BOOLEAN,
                        value: false,
                    };
                },
            },
            /**
             * The always-on VPN state as a fake preference object.
             */
            alwaysOnVpn_: {
                type: Object,
                observer: 'alwaysOnVpnChanged_',
                value() {
                    return {
                        key: 'fakeAlwaysOnPref',
                        type: chrome.settingsPrivate.PrefType.BOOLEAN,
                        value: false,
                    };
                },
            },
            /**
             * This gets initialized to managedProperties_.metered.activeValue.
             * When this is changed from the UI, a change event will update the
             * property and setMojoNetworkProperties will be called.
             */
            meteredOverride_: {
                type: Boolean,
                value: false,
            },
            /**
             * The network preferred state.
             */
            preferNetwork_: {
                type: Boolean,
                value: false,
                observer: 'preferNetworkChanged_',
            },
            /**
             * The network IP Address.
             */
            ipAddress_: {
                type: String,
                value: '',
            },
            /**
             * Whether to show technology badge on mobile network icons.
             */
            showTechnologyBadge_: {
                type: Boolean,
                value() {
                    return loadTimeData.valueExists('showTechnologyBadge') &&
                        loadTimeData.getBoolean('showTechnologyBadge');
                },
            },
            /**
             * Whether to show the Hidden toggle on configured wifi networks (flag).
             */
            showHiddenToggle_: {
                type: Boolean,
                value() {
                    return loadTimeData.valueExists('showHiddenToggle') &&
                        loadTimeData.getBoolean('showHiddenToggle');
                },
            },
            isTrafficCountersEnabled_: {
                type: Boolean,
                value() {
                    return loadTimeData.valueExists('trafficCountersEnabled') &&
                        loadTimeData.getBoolean('trafficCountersEnabled');
                },
            },
            isTrafficCountersForWifiTestingEnabled_: {
                type: Boolean,
                value() {
                    return loadTimeData.valueExists('trafficCountersForWifiTesting') &&
                        loadTimeData.getBoolean('trafficCountersForWifiTesting');
                },
            },
            /**
             * Tracks whether traffic counter info should be shown.
             */
            trafficCountersAvailable_: {
                type: Boolean,
                value: false,
            },
            /**
             * When true, all inputs that allow state to be changed (e.g., toggles,
             * inputs) are disabled.
             */
            disabled_: {
                type: Boolean,
                value: false,
                computed: 'computeDisabled_(deviceState_.*)',
            },
            isApnRevampEnabled_: {
                type: Boolean,
                value() {
                    return loadTimeData.valueExists('isApnRevampEnabled') &&
                        loadTimeData.getBoolean('isApnRevampEnabled');
                },
            },
            isApnRevampAndAllowApnModificationPolicyEnabled_: {
                type: Boolean,
                value() {
                    return loadTimeData.valueExists('isApnRevampAndAllowApnModificationPolicyEnabled') &&
                        loadTimeData.getBoolean('isApnRevampAndAllowApnModificationPolicyEnabled');
                },
            },
            passpointSubscription_: {
                type: Object,
                notify: true,
            },
            advancedExpanded_: Boolean,
            networkExpanded_: Boolean,
            proxyExpanded_: Boolean,
            dataUsageExpanded_: Boolean,
        };
    }
    static get observers() {
        return [
            'updateAlwaysOnVpnPrefValue_(prefs.arc.vpn.always_on.*)',
            'updateAlwaysOnVpnPrefEnforcement_(managedProperties_,' +
                'prefs.vpn_config_allowed.*)',
            'updateAutoConnectPref_(globalPolicy)',
            'autoConnectPrefChanged_(autoConnectPref_.*)',
            'alwaysOnVpnChanged_(alwaysOnVpn_.*)',
            'hiddenPrefChanged_(hiddenPref_.*)',
        ];
    }
    constructor() {
        super();
        // DeepLinkingMixin override
        this.supportedSettingIds = new Set([
            Setting.kConfigureEthernet,
            Setting.kEthernetAutoConfigureIp,
            Setting.kEthernetDns,
            Setting.kEthernetProxy,
            Setting.kDisconnectWifiNetwork,
            Setting.kPreferWifiNetwork,
            Setting.kForgetWifiNetwork,
            Setting.kWifiAutoConfigureIp,
            Setting.kWifiDns,
            Setting.kWifiHidden,
            Setting.kWifiProxy,
            Setting.kWifiAutoConnectToNetwork,
            Setting.kCellularSimLock,
            Setting.kCellularRoaming,
            Setting.kCellularApn,
            Setting.kDisconnectCellularNetwork,
            Setting.kCellularAutoConfigureIp,
            Setting.kCellularDns,
            Setting.kCellularProxy,
            Setting.kCellularAutoConnectToNetwork,
            Setting.kDisconnectTetherNetwork,
            Setting.kWifiMetered,
            Setting.kCellularMetered,
        ]);
        this.CR_EXPAND_BUTTON_TAG = 'CR-EXPAND-BUTTON';
        this.didSetFocus_ = false;
        /**
         * Set to true to once the initial properties have been received. This
         * prevents setProperties from being called when setting default properties.
         */
        this.propertiesReceived_ = false;
        /**
         * Set in currentRouteChanged() if the showConfigure URL query
         * parameter is set to true. The dialog cannot be shown until the
         * network properties have been fetched in managedPropertiesChanged_().
         */
        this.shouldShowConfigureWhenNetworkLoaded_ = false;
        /**
         * Prevents re-saving incoming changes.
         */
        this.applyingChanges_ = false;
        /**
         * Flag, if true, indicating that the next deviceState_ update
         * should call deepLinkToSimLockElement_().
         */
        this.pendingSimLockDeepLink_ = false;
        this.browserProxy_ = InternetPageBrowserProxyImpl.getInstance();
        this.networkConfig_ =
            MojoInterfaceProviderImpl.getInstance().getMojoServiceRemote();
        this.passpointService_ =
            MojoConnectivityProvider.getInstance().getPasspointService();
        this.osSyncBrowserProxy_ = OsSyncBrowserProxyImpl.getInstance();
        this.trafficCountersAdapter_ = new TrafficCountersAdapter();
    }
    connectedCallback() {
        super.connectedCallback();
        this.addWebUiListener('os-sync-prefs-changed', this.handleOsSyncPrefsChanged_.bind(this));
        this.osSyncBrowserProxy_.sendOsSyncPrefsChanged();
        this.computeTrafficCountersAvailable_();
    }
    afterRenderShowDeepLink_(settingId, elementCallback) {
        // Wait for element to load.
        afterNextRender(this, () => {
            const deepLinkElement = elementCallback();
            if (!deepLinkElement || deepLinkElement.hidden) {
                console.warn(`Element with deep link id ${settingId} not focusable.`);
                return;
            }
            this.showDeepLinkElement(deepLinkElement);
        });
    }
    /**
     * Overridden from DeepLinkingMixin.
     */
    beforeDeepLinkAttempt(settingId) {
        // Manually show the deep links for settings in shared elements.
        if (settingId === Setting.kCellularRoaming) {
            this.afterRenderShowDeepLink_(settingId, () => this.shadowRoot.querySelector('cellular-roaming-toggle-button')
                .getCellularRoamingToggle());
            // Stop deep link attempt since we completed it manually.
            return false;
        }
        if (settingId === Setting.kCellularApn) {
            this.networkExpanded_ = true;
            this.afterRenderShowDeepLink_(settingId, () => this.shadowRoot.querySelector('network-apnlist').getApnSelect());
            return false;
        }
        if (settingId === Setting.kEthernetAutoConfigureIp ||
            settingId === Setting.kWifiAutoConfigureIp ||
            settingId === Setting.kCellularAutoConfigureIp) {
            this.networkExpanded_ = true;
            this.afterRenderShowDeepLink_(settingId, () => this.shadowRoot.querySelector('network-ip-config')
                .getAutoConfigIpToggle());
            return false;
        }
        if (settingId === Setting.kEthernetDns || settingId === Setting.kWifiDns ||
            settingId === Setting.kCellularDns) {
            this.networkExpanded_ = true;
            this.afterRenderShowDeepLink_(settingId, () => this.shadowRoot.querySelector('network-nameservers')
                .getNameserverRadioButtons());
            return false;
        }
        if (settingId === Setting.kEthernetProxy ||
            settingId === Setting.kWifiProxy ||
            settingId === Setting.kCellularProxy) {
            this.proxyExpanded_ = true;
            this.afterRenderShowDeepLink_(settingId, () => this.shadowRoot.querySelector('network-proxy-section')
                .getAllowSharedToggle());
            return false;
        }
        if (settingId === Setting.kWifiMetered ||
            settingId === Setting.kCellularMetered) {
            this.advancedExpanded_ = true;
            // Continue with automatically showing these deep links.
            return true;
        }
        if (settingId === Setting.kForgetWifiNetwork) {
            this.afterRenderShowDeepLink_(settingId, () => {
                const forgetButton = this.shadowRoot.getElementById('forgetButton');
                if (forgetButton && !forgetButton.hidden) {
                    return forgetButton;
                }
                // If forget button is hidden, show disconnect button instead.
                return this.shadowRoot.getElementById('connectDisconnect');
            });
            return false;
        }
        if (settingId === Setting.kCellularSimLock) {
            this.advancedExpanded_ = true;
            // If the page just loaded, deviceState_ will not be fully initialized
            // yet, so we won't know which SIM info element to focus. Set
            // pendingSimLockDeepLink_ to indicate that a SIM info element should be
            // focused next deviceState_ update.
            this.pendingSimLockDeepLink_ = true;
            return false;
        }
        // Otherwise, should continue with deep link attempt.
        return true;
    }
    /**
     * RouteObserverMixin override
     */
    currentRouteChanged(route, oldRoute) {
        if (route !== routes.NETWORK_DETAIL) {
            return;
        }
        const queryParams = Router.getInstance().getQueryParameters();
        const guid = queryParams.get('guid') || '';
        if (!guid) {
            console.warn('No guid specified for page:' + route);
            this.close();
        }
        this.shouldShowConfigureWhenNetworkLoaded_ =
            queryParams.get('showConfigure') === 'true';
        const type = queryParams.get('type') || 'WiFi';
        const name = queryParams.get('name') || type;
        this.init(guid, type, name);
        // If we are getting back from APN subpage set focus to the APN subpage
        // row.
        if (oldRoute === routes.APN &&
            Router.getInstance().lastRouteChangeWasPopstate()) {
            this.didSetFocus_ = true;
            afterNextRender(this, () => {
                const element = this.shadowRoot.getElementById('apnSubpageButton');
                if (element) {
                    element.focus();
                }
            });
        }
        this.attemptDeepLink();
    }
    /**
     * Handler for when os sync preferences are updated.
     */
    handleOsSyncPrefsChanged_(osSyncPrefs) {
        this.isWifiSyncEnabled_ =
            !!osSyncPrefs && osSyncPrefs.osWifiConfigurationsSynced;
    }
    init(guid, type, name) {
        this.guid = guid;
        // Set default properties until they are loaded.
        this.propertiesReceived_ = false;
        this.deviceState_ = null;
        this.managedProperties_ = OncMojo.getDefaultManagedProperties(OncMojo.getNetworkTypeFromString(type), this.guid, name);
        this.didSetFocus_ = false;
        this.getNetworkDetails_();
    }
    close() {
        // If the page is already closed, return early to avoid navigating backward
        // erroneously.
        if (!this.guid) {
            return;
        }
        this.guid = '';
        // Delay navigating to allow other subpages to load first.
        requestAnimationFrame(() => {
            // Clear network properties before navigating away to ensure that a future
            // navigation back to the details page does not show a flicker of
            // incorrect text. See https://crbug.com/905986.
            this.managedProperties_ = undefined;
            this.propertiesReceived_ = false;
            if (Router.getInstance().currentRoute === routes.NETWORK_DETAIL) {
                Router.getInstance().navigateToPreviousRoute();
            }
        });
    }
    /** CrosNetworkConfigObserver impl */
    onActiveNetworksChanged(networks) {
        if (!this.guid || !this.managedProperties_) {
            return;
        }
        // If the network was or is active, request an update.
        if (this.managedProperties_.connectionState !==
            ConnectionStateType.kNotConnected ||
            networks.find(network => network.guid === this.guid)) {
            this.getNetworkDetails_();
        }
    }
    /** CrosNetworkConfigObserver impl */
    onNetworkStateChanged(network) {
        if (!this.guid || !this.managedProperties_) {
            return;
        }
        if (network.guid === this.guid) {
            this.getNetworkDetails_();
        }
    }
    /** CrosNetworkConfigObserver impl */
    onNetworkStateListChanged() {
        if (!this.guid || !this.managedProperties_) {
            return;
        }
        this.checkNetworkExists_();
    }
    /** CrosNetworkConfigObserver impl */
    onDeviceStateListChanged() {
        if (!this.guid || !this.managedProperties_) {
            return;
        }
        this.getDeviceState_();
    }
    managedPropertiesChanged_() {
        if (!this.managedProperties_) {
            return;
        }
        this.updateAutoConnectPref_();
        this.updateHiddenPref_();
        if (this.isCellular_(this.managedProperties_) &&
            this.managedProperties_.typeProperties.cellular.allowTextMessages) {
            this.suppressTextMessagesOverride_ = !!OncMojo.getActiveValue(this.managedProperties_.typeProperties.cellular.allowTextMessages);
        }
        const metered = this.managedProperties_.metered;
        if (metered && metered.activeValue !== this.meteredOverride_) {
            this.meteredOverride_ = metered.activeValue;
        }
        const priority = this.managedProperties_.priority;
        if (priority) {
            const preferNetwork = priority.activeValue > 0;
            if (preferNetwork !== this.preferNetwork_) {
                this.preferNetwork_ = preferNetwork;
            }
        }
        // Set the IPAddress property to the IPv4 Address.
        const ipv4 = OncMojo.getIPConfigForType(this.managedProperties_, IPConfigType.kIPv4);
        this.ipAddress_ = (ipv4 && ipv4.ipAddress) || '';
        // Update the detail page title.
        const networkName = OncMojo.getNetworkNameUnsafe(this.managedProperties_);
        this.parentNode.pageTitle = networkName;
        flush();
        if (!this.didSetFocus_ &&
            !Router.getInstance().getQueryParameters().has('search') &&
            !this.getDeepLinkSettingId()) {
            // Unless the page was navigated to via search or has a deep linked
            // setting, focus a button once the initial state is set.
            this.didSetFocus_ = true;
            const button = this.shadowRoot.querySelector('#titleDiv .action-button:not([hidden])');
            if (button) {
                afterNextRender(this, () => button.focus());
            }
        }
        if (this.shouldShowConfigureWhenNetworkLoaded_ &&
            this.managedProperties_.type === NetworkType.kTether) {
            // Set |this.shouldShowConfigureWhenNetworkLoaded_| back to false to
            // ensure that the Tether dialog is only shown once.
            this.shouldShowConfigureWhenNetworkLoaded_ = false;
            // Async call to ensure dialog is stamped.
            setTimeout(() => this.showTetherDialog_());
        }
    }
    async getDeviceState_() {
        if (!this.managedProperties_) {
            return;
        }
        const type = this.managedProperties_.type;
        const response = await this.networkConfig_.getDeviceStateList();
        // If there is no GUID, the page was closed between requesting the device
        // state and receiving it. If this occurs, there is no need to process the
        // response. Note that if this subpage is reopened later, we'll request
        // this data again.
        if (!this.guid) {
            return;
        }
        const { deviceState, shouldGetNetworkDetails } = processDeviceState(type, response.result, this.deviceState_);
        this.deviceState_ = deviceState;
        if (shouldGetNetworkDetails) {
            this.getNetworkDetails_();
        }
        if (this.pendingSimLockDeepLink_) {
            this.pendingSimLockDeepLink_ = false;
            this.deepLinkToSimLockElement_();
        }
    }
    deepLinkToSimLockElement_() {
        const settingId = Setting.kCellularSimLock;
        const simLockStatus = this.deviceState_.simLockStatus;
        // In this rare case, element not focusable until after a second wait.
        // This is slightly preferable to requestAnimationFrame used within
        // network-siminfo to focus elements since it can be reproduced in
        // testing.
        afterNextRender(this, () => {
            if (simLockStatus && !!simLockStatus.lockType) {
                this.afterRenderShowDeepLink_(settingId, () => this.shadowRoot.querySelector('network-siminfo').getUnlockButton());
                return;
            }
            this.afterRenderShowDeepLink_(settingId, () => this.shadowRoot.querySelector('network-siminfo').getSimLockToggle());
        });
    }
    autoConnectPrefChanged_() {
        if (!this.propertiesReceived_) {
            return;
        }
        const config = this.getDefaultConfigProperties_();
        config.autoConnect = { value: !!this.autoConnectPref_.value };
        this.setMojoNetworkProperties_(config);
    }
    hiddenPrefChanged_() {
        if (!this.propertiesReceived_) {
            return;
        }
        recordSettingChange(Setting.kWifiHidden, { boolValue: !!this.hiddenPref_.value });
        const config = this.getDefaultConfigProperties_();
        config.typeConfig.wifi.hiddenSsid = this.hiddenPref_.value ?
            HiddenSsidMode.kEnabled :
            HiddenSsidMode.kDisabled;
        this.setMojoNetworkProperties_(config);
    }
    getPolicyEnforcement_(policySource) {
        switch (policySource) {
            case PolicySource.kUserPolicyEnforced:
            case PolicySource.kDevicePolicyEnforced:
                return chrome.settingsPrivate.Enforcement.ENFORCED;
            case PolicySource.kUserPolicyRecommended:
            case PolicySource.kDevicePolicyRecommended:
                return chrome.settingsPrivate.Enforcement.RECOMMENDED;
            default:
                return undefined;
        }
    }
    getPolicyController_(policySource) {
        switch (policySource) {
            case PolicySource.kDevicePolicyEnforced:
            case PolicySource.kDevicePolicyRecommended:
                return chrome.settingsPrivate.ControlledBy.DEVICE_POLICY;
            case PolicySource.kUserPolicyEnforced:
            case PolicySource.kUserPolicyRecommended:
                return chrome.settingsPrivate.ControlledBy.USER_POLICY;
            default:
                return undefined;
        }
    }
    /**
     * Updates auto-connect pref value.
     */
    updateAutoConnectPref_() {
        if (!this.managedProperties_) {
            return;
        }
        const autoConnect = OncMojo.getManagedAutoConnect(this.managedProperties_);
        if (!autoConnect) {
            return;
        }
        let enforcement;
        let controlledBy;
        if (this.globalPolicy &&
            this.globalPolicy.allowOnlyPolicyNetworksToAutoconnect) {
            enforcement = chrome.settingsPrivate.Enforcement.ENFORCED;
            controlledBy = chrome.settingsPrivate.ControlledBy.DEVICE_POLICY;
        }
        else {
            enforcement = this.getPolicyEnforcement_(autoConnect.policySource);
            controlledBy = this.getPolicyController_(autoConnect.policySource);
        }
        if (this.autoConnectPref_.value === autoConnect.activeValue &&
            enforcement === this.autoConnectPref_.enforcement &&
            controlledBy === this.autoConnectPref_.controlledBy) {
            return;
        }
        const newPrefValue = {
            key: 'fakeAutoConnectPref',
            value: autoConnect.activeValue,
            type: chrome.settingsPrivate.PrefType.BOOLEAN,
        };
        if (enforcement) {
            newPrefValue.enforcement = enforcement;
            newPrefValue.controlledBy = controlledBy;
        }
        this.autoConnectPref_ = newPrefValue;
    }
    updateHiddenPref_() {
        if (!this.managedProperties_) {
            return;
        }
        if (this.managedProperties_.type !== NetworkType.kWiFi) {
            return;
        }
        const hidden = this.managedProperties_.typeProperties.wifi.hiddenSsid;
        if (!hidden) {
            return;
        }
        const enforcement = this.getPolicyEnforcement_(hidden.policySource);
        const controlledBy = this.getPolicyController_(hidden.policySource);
        if (this.hiddenPref_.value === hidden.activeValue &&
            enforcement === this.hiddenPref_.enforcement &&
            controlledBy === this.hiddenPref_.controlledBy) {
            return;
        }
        const newPrefValue = {
            key: 'fakeHiddenPref',
            value: hidden.activeValue,
            type: chrome.settingsPrivate.PrefType.BOOLEAN,
        };
        if (enforcement) {
            newPrefValue.enforcement = enforcement;
            newPrefValue.controlledBy = controlledBy;
        }
        this.hiddenPref_ = newPrefValue;
    }
    suppressTextMessagesChanged_(e) {
        if (!this.propertiesReceived_ ||
            !this.isCellular_(this.managedProperties_) ||
            !this.managedProperties_.typeProperties.cellular.allowTextMessages) {
            return;
        }
        const config = OncMojo.getDefaultConfigProperties(this.managedProperties_.type);
        config.typeConfig.cellular = {
            textMessageAllowState: {
                allowTextMessages: e.detail.value,
            },
            roaming: null,
            apn: null,
        };
        this.networkConfig_.setProperties(this.guid, config).then(response => {
            if (!response.success) {
                console.warn('Unable to set properties: ' + JSON.stringify(config));
            }
        });
    }
    meteredChanged_(e) {
        if (!this.propertiesReceived_) {
            return;
        }
        const config = this.getDefaultConfigProperties_();
        config.metered = { value: e.detail.value };
        this.setMojoNetworkProperties_(config);
    }
    preferNetworkChanged_() {
        if (!this.propertiesReceived_) {
            return;
        }
        const config = this.getDefaultConfigProperties_();
        config.priority = { value: this.preferNetwork_ ? 1 : 0 };
        this.setMojoNetworkProperties_(config);
    }
    async checkNetworkExists_() {
        const response = await this.networkConfig_.getNetworkState(this.guid);
        if (response.result) {
            // Don't update the state, a change event will trigger the update.
            return;
        }
        this.outOfRange_ = true;
        if (this.managedProperties_) {
            // Set the connection state since we won't receive an update for a non
            // existent network.
            this.managedProperties_.connectionState =
                ConnectionStateType.kNotConnected;
        }
    }
    checkWifiOutOfRange_(networkState) {
        if (!networkState) {
            return;
        }
        if (networkState.type !== NetworkType.kWiFi) {
            this.outOfRange_ = false;
            return;
        }
        // A hidden network should always have the connect button regardless of
        // whether it's visible or not.
        this.outOfRange_ = !networkState.typeState.wifi.hiddenSsid &&
            !networkState.typeState.wifi.visible;
    }
    async getNetworkDetails_() {
        assertExists(this.guid);
        const networkStateResponse = await this.networkConfig_.getNetworkState(this.guid);
        this.checkWifiOutOfRange_(networkStateResponse.result);
        if (this.isSecondaryUser_) {
            this.getStateCallback_(networkStateResponse.result);
            return;
        }
        const response = await this.networkConfig_.getManagedProperties(this.guid);
        this.getPropertiesCallback_(response.result);
        if (this.isPasspointWifi_(this.managedProperties_)) {
            const response = await this.passpointService_.getPasspointSubscription(this.managedProperties_.typeProperties.wifi.passpointId);
            this.passpointSubscription_ = response.result;
        }
    }
    getPropertiesCallback_(properties) {
        // Details page was closed while request was in progress, ignore the result.
        if (!this.guid) {
            return;
        }
        if (!properties) {
            // Close the page if the network was removed and no longer exists.
            this.close();
            return;
        }
        this.updateManagedProperties_(properties);
        // Detail page should not be shown when Arc VPN is not connected.
        if (this.isArcVpn_(this.managedProperties_) &&
            !this.isConnectedState_(this.managedProperties_)) {
            this.guid = '';
            this.close();
        }
        this.propertiesReceived_ = true;
        if (!this.deviceState_) {
            this.getDeviceState_();
        }
    }
    updateManagedProperties_(properties) {
        this.applyingChanges_ = true;
        if (this.managedProperties_ &&
            this.managedProperties_.type === NetworkType.kCellular &&
            this.deviceState_ && this.deviceState_.scanning) {
            // Cellular properties may be invalid while scanning, so keep the existing
            // properties instead.
            properties.typeProperties.cellular =
                this.managedProperties_.typeProperties.cellular;
        }
        this.managedProperties_ = properties;
        afterNextRender(this, () => {
            this.applyingChanges_ = false;
        });
    }
    getStateCallback_(networkState) {
        if (!networkState) {
            // Edge case, may occur when disabling. Close this.
            this.close();
            return;
        }
        const managedProperties = OncMojo.getDefaultManagedProperties(networkState.type, networkState.guid, networkState.name);
        managedProperties.connectable = networkState.connectable;
        managedProperties.connectionState = networkState.connectionState;
        switch (networkState.type) {
            case NetworkType.kCellular:
                managedProperties.typeProperties.cellular.signalStrength =
                    networkState.typeState.cellular.signalStrength;
                managedProperties.typeProperties.cellular.simLocked =
                    networkState.typeState.cellular.simLocked;
                break;
            case NetworkType.kTether:
                managedProperties.typeProperties.tether.signalStrength =
                    networkState.typeState.tether.signalStrength;
                break;
            case NetworkType.kWiFi:
                managedProperties.typeProperties.wifi.signalStrength =
                    networkState.typeState.wifi.signalStrength;
                break;
        }
        this.updateManagedProperties_(managedProperties);
        this.propertiesReceived_ = true;
    }
    getNetworkState_(properties) {
        if (!properties) {
            return undefined;
        }
        return OncMojo.managedPropertiesToNetworkState(properties);
    }
    getDefaultConfigProperties_() {
        return OncMojo.getDefaultConfigProperties(this.managedProperties_.type);
    }
    async setMojoNetworkProperties_(config) {
        if (!this.propertiesReceived_ || !this.guid || this.applyingChanges_) {
            return;
        }
        // TODO(b/282233232) recordSettingChange() for updating network properties.
        const response = await this.networkConfig_.setProperties(this.guid, config);
        if (!response.success) {
            console.warn('Unable to set properties: ' + JSON.stringify(config));
            // An error typically indicates invalid input; request the properties
            // to update any invalid fields.
            this.getNetworkDetails_();
        }
    }
    getStateText_(managedProperties, propertiesReceived, outOfRange, deviceState) {
        if (!managedProperties || !propertiesReceived) {
            return '';
        }
        if (this.isOutOfRangeOrNotEnabled_(outOfRange, deviceState)) {
            return managedProperties.type === NetworkType.kTether ?
                this.i18n('tetherPhoneOutOfRange') :
                this.i18n('networkOutOfRange');
        }
        if (OncMojo.connectionStateIsConnected(managedProperties.connectionState)) {
            if (this.isPortalState_(managedProperties.portalState)) {
                if (managedProperties.type === NetworkType.kCellular) {
                    return this.i18n('networkListItemCellularSignIn');
                }
                return this.i18n('networkListItemSignIn');
            }
            if (managedProperties.portalState === PortalState.kNoInternet) {
                return this.i18n('networkListItemConnectedNoConnectivity');
            }
        }
        if (isCarrierLockedActiveSim(managedProperties, deviceState)) {
            return this.i18n('networkMobileProviderLocked');
        }
        return this.i18n(OncMojo.getConnectionStateString(managedProperties.connectionState));
    }
    getAutoConnectToggleLabel_(managedProperties) {
        return this.isCellular_(managedProperties) ?
            this.i18n('networkAutoConnectCellular') :
            this.i18n('networkAutoConnect');
    }
    isConnectedState_(managedProperties) {
        return !!managedProperties &&
            OncMojo.connectionStateIsConnected(managedProperties.connectionState);
    }
    isRestrictedConnectivity_(managedProperties) {
        return !!managedProperties &&
            OncMojo.isRestrictedConnectivity(managedProperties.portalState);
    }
    showConnectedState_(managedProperties) {
        return this.isConnectedState_(managedProperties) &&
            !this.isRestrictedConnectivity_(managedProperties);
    }
    showRestrictedConnectivity_(managedProperties, deviceState) {
        if (!managedProperties) {
            return false;
        }
        // Display carrier locked network as warning
        if (isCarrierLockedActiveSim(managedProperties, deviceState)) {
            return true;
        }
        // State must be connected and restricted.
        return this.isConnectedState_(managedProperties) &&
            this.isRestrictedConnectivity_(managedProperties);
    }
    isRemembered_(managedProperties) {
        return !!managedProperties && managedProperties.source !== OncSource.kNone;
    }
    isRememberedOrConnected_(managedProperties) {
        return this.isRemembered_(managedProperties) ||
            this.isConnectedState_(managedProperties);
    }
    isCellular_(managedProperties) {
        return !!managedProperties &&
            managedProperties.type === NetworkType.kCellular;
    }
    isTether_(managedProperties) {
        return !!managedProperties &&
            managedProperties.type === NetworkType.kTether;
    }
    isWiFi_(managedProperties) {
        return !!managedProperties && managedProperties.type === NetworkType.kWiFi;
    }
    isWireGuard_(managedProperties) {
        if (!managedProperties) {
            return false;
        }
        if (managedProperties.type !== NetworkType.kVPN) {
            return false;
        }
        if (!managedProperties.typeProperties.vpn) {
            return false;
        }
        return managedProperties.typeProperties.vpn.type === VpnType.kWireGuard;
    }
    isBlockedByPolicy_(managedProperties, globalPolicy, managedNetworkAvailable) {
        if (!managedProperties || !globalPolicy ||
            this.isPolicySource(managedProperties.source)) {
            return false;
        }
        if (managedProperties.type === NetworkType.kCellular &&
            !!globalPolicy.allowOnlyPolicyCellularNetworks) {
            return true;
        }
        if (managedProperties.type !== NetworkType.kWiFi) {
            return false;
        }
        const hexSsid = OncMojo.getActiveString(managedProperties.typeProperties.wifi.hexSsid);
        return !!globalPolicy.allowOnlyPolicyWifiNetworksToConnect ||
            (!!globalPolicy.allowOnlyPolicyWifiNetworksToConnectIfAvailable &&
                !!managedNetworkAvailable) ||
            (!!hexSsid && !!globalPolicy.blockedHexSsids &&
                globalPolicy.blockedHexSsids.includes(hexSsid));
    }
    shouldShowApnRow_() {
        return this.isApnRevampEnabled_ &&
            this.isCellular_(this.managedProperties_);
    }
    isApnManaged_(globalPolicy) {
        if (!this.isApnRevampAndAllowApnModificationPolicyEnabled_) {
            return false;
        }
        if (!globalPolicy) {
            return false;
        }
        return !globalPolicy.allowApnModification;
    }
    shouldShowApnList_() {
        return !this.isApnRevampEnabled_ &&
            this.isCellular_(this.managedProperties_);
    }
    shouldShowSuppressTextMessagesToggle_() {
        if (!this.managedProperties_ || !this.deviceState_) {
            return false;
        }
        const networkState = this.getNetworkState_(this.managedProperties_);
        if (!networkState) {
            return false;
        }
        // Only show the toggle for the active SIM with the flag enabled.
        return this.isCellular_(this.managedProperties_) &&
            isActiveSim(networkState, this.deviceState_);
    }
    showConnect_(managedProperties, globalPolicy, managedNetworkAvailable, deviceState) {
        if (!managedProperties) {
            return false;
        }
        if (this.isBlockedByPolicy_(managedProperties, globalPolicy, managedNetworkAvailable)) {
            return false;
        }
        // TODO(lgcheng@) support connect Arc VPN from UI once Android support API
        // to initiate a VPN session.
        if (this.isArcVpn_(managedProperties)) {
            return false;
        }
        if (managedProperties.connectionState !==
            ConnectionStateType.kNotConnected) {
            return false;
        }
        if (deviceState && deviceState.deviceState !== DeviceStateType.kEnabled) {
            return false;
        }
        const isEthernet = managedProperties.type === NetworkType.kEthernet;
        // Note: Ethernet networks do not have an explicit "Connect" button in the
        // UI.
        return OncMojo.isNetworkConnectable(managedProperties) && !isEthernet;
    }
    showDisconnect_(managedProperties) {
        if (!managedProperties ||
            managedProperties.type === NetworkType.kEthernet) {
            return false;
        }
        return managedProperties.connectionState !==
            ConnectionStateType.kNotConnected;
    }
    showSignin_(managedProperties) {
        if (!managedProperties) {
            return false;
        }
        if (OncMojo.connectionStateIsConnected(managedProperties.connectionState) &&
            this.isPortalState_(managedProperties.portalState)) {
            return true;
        }
        return false;
    }
    showForget_(managedProperties) {
        if (!managedProperties || this.isSecondaryUser_) {
            return false;
        }
        const type = managedProperties.type;
        if (type !== NetworkType.kWiFi && type !== NetworkType.kVPN) {
            return false;
        }
        if (this.isArcVpn_(managedProperties)) {
            return false;
        }
        return !this.isPolicySource(managedProperties.source) &&
            this.isRemembered_(managedProperties);
    }
    showActivate_(managedProperties) {
        if (!managedProperties || this.isSecondaryUser_) {
            return false;
        }
        if (!this.isCellular_(managedProperties)) {
            return false;
        }
        // Only show the Activate button for unactivated pSIM networks.
        if (managedProperties.typeProperties.cellular.eid) {
            return false;
        }
        const activation = managedProperties.typeProperties.cellular.activationState;
        return activation === ActivationStateType.kNotActivated ||
            activation === ActivationStateType.kPartiallyActivated;
    }
    showConfigure_(managedProperties, globalPolicy, managedNetworkAvailable) {
        if (!managedProperties || this.isSecondaryUser_) {
            return false;
        }
        if (this.isBlockedByPolicy_(managedProperties, globalPolicy, managedNetworkAvailable)) {
            return false;
        }
        const type = managedProperties.type;
        if (type === NetworkType.kCellular || type === NetworkType.kTether) {
            return false;
        }
        if (type === NetworkType.kWiFi &&
            managedProperties.typeProperties.wifi.security ===
                SecurityType.kNone) {
            return false;
        }
        if (type === NetworkType.kWiFi &&
            (managedProperties.connectionState !==
                ConnectionStateType.kNotConnected)) {
            return false;
        }
        if (this.isPasspointWifi_(managedProperties)) {
            // Passpoint networks are automatically configured using Passpoint
            // subscriptions. We don't want the user to change the configuration
            // (b/282114074).
            return false;
        }
        if (this.isArcVpn_(managedProperties) &&
            !this.isConnectedState_(managedProperties)) {
            return false;
        }
        return true;
    }
    disableSignin_(managedProperties) {
        if (this.disabled_ || !managedProperties) {
            return true;
        }
        if (!OncMojo.connectionStateIsConnected(managedProperties.connectionState)) {
            return true;
        }
        return !this.isPortalState_(managedProperties.portalState);
    }
    disableForget_(managedProperties, vpnConfigAllowed) {
        if (this.disabled_ || !managedProperties) {
            return true;
        }
        return managedProperties.type === NetworkType.kVPN && vpnConfigAllowed &&
            !vpnConfigAllowed.value;
    }
    disableConfigure_(managedProperties, vpnConfigAllowed) {
        if (this.disabled_ || !managedProperties) {
            return true;
        }
        if (managedProperties.type === NetworkType.kVPN && vpnConfigAllowed &&
            !vpnConfigAllowed.value) {
            return true;
        }
        return this.isPolicySource(managedProperties.source) &&
            !this.hasRecommendedFields_(managedProperties);
    }
    hasRecommendedFields_(managedProperties) {
        if (!managedProperties) {
            return false;
        }
        for (const value of Object.values(managedProperties)) {
            if (typeof value !== 'object' || value === null) {
                continue;
            }
            if ('activeValue' in value) {
                if (this.isNetworkPolicyRecommended(value)) {
                    return true;
                }
            }
            else if (this.hasRecommendedFields_(value)) {
                return true;
            }
        }
        return false;
    }
    showViewAccount_(managedProperties) {
        if (!managedProperties || this.isSecondaryUser_) {
            return false;
        }
        // Show either the 'Activate' or the 'View Account' button (Cellular only).
        if (!this.isCellular_(managedProperties) ||
            this.showActivate_(managedProperties)) {
            return false;
        }
        // If the network is eSIM, don't show.
        if (managedProperties.typeProperties.cellular.eid) {
            return false;
        }
        const paymentPortal = managedProperties.typeProperties.cellular.paymentPortal;
        if (!paymentPortal || !paymentPortal.url) {
            return false;
        }
        // Only show for connected networks or LTE networks with a valid MDN.
        if (!this.isConnectedState_(managedProperties)) {
            const technology = managedProperties.typeProperties.cellular.networkTechnology;
            if (technology !== 'LTE' && technology !== 'LTEAdvanced') {
                return false;
            }
            if (!managedProperties.typeProperties.cellular.mdn) {
                return false;
            }
        }
        return true;
    }
    enableConnect_(managedProperties, defaultNetwork, propertiesReceived, outOfRange, globalPolicy, managedNetworkAvailable, deviceState) {
        if (!this.showConnect_(managedProperties, globalPolicy, managedNetworkAvailable, deviceState)) {
            return false;
        }
        if (!propertiesReceived || outOfRange) {
            return false;
        }
        assertExists(managedProperties);
        if (managedProperties.type === NetworkType.kVPN && !defaultNetwork) {
            return false;
        }
        // Cannot connect to a network which is SIM locked; the user must first
        // unlock the SIM before attempting a connection.
        if (managedProperties.type === NetworkType.kCellular &&
            managedProperties.typeProperties.cellular.simLocked) {
            return false;
        }
        return true;
    }
    updateAlwaysOnVpnPrefValue_() {
        this.alwaysOnVpn_.value = this.prefs.arc && this.prefs.arc.vpn &&
            this.prefs.arc.vpn.always_on && this.prefs.arc.vpn.always_on.lockdown &&
            this.prefs.arc.vpn.always_on.lockdown.value;
    }
    getFakeVpnConfigPrefForEnforcement_() {
        const fakeAlwaysOnVpnEnforcementPref = {
            key: 'fakeAlwaysOnPref',
            type: chrome.settingsPrivate.PrefType.BOOLEAN,
            value: false,
        };
        // Only mark VPN networks as enforced. This fake pref also controls the
        // policy indicator on the connect/disconnect buttons, so it shouldn't be
        // shown on non-VPN networks.
        if (this.managedProperties_ &&
            this.managedProperties_.type === NetworkType.kVPN && this.prefs &&
            this.prefs.vpn_config_allowed && !this.prefs.vpn_config_allowed.value) {
            fakeAlwaysOnVpnEnforcementPref.enforcement =
                chrome.settingsPrivate.Enforcement.ENFORCED;
            fakeAlwaysOnVpnEnforcementPref.controlledBy =
                this.prefs.vpn_config_allowed.controlledBy;
        }
        return fakeAlwaysOnVpnEnforcementPref;
    }
    updateAlwaysOnVpnPrefEnforcement_() {
        const prefForEnforcement = this.getFakeVpnConfigPrefForEnforcement_();
        this.alwaysOnVpn_.enforcement = prefForEnforcement.enforcement;
        this.alwaysOnVpn_.controlledBy = prefForEnforcement.controlledBy;
    }
    getTetherDialog_() {
        return castExists(this.shadowRoot.querySelector('#tetherDialog'));
    }
    getPasspointRemovalDialog_() {
        return castExists(this.shadowRoot.querySelector('#passpointRemovalDialog'));
    }
    handleConnectClick_() {
        assertExists(this.managedProperties_);
        if (this.managedProperties_.type === NetworkType.kTether &&
            (!this.managedProperties_.typeProperties.tether.hasConnectedToHost)) {
            this.showTetherDialog_();
            return;
        }
        this.fireNetworkConnect_(/*bypassDialog=*/ false);
    }
    onTetherConnect_() {
        this.getTetherDialog_().close();
        this.fireNetworkConnect_(/*bypassDialog=*/ true);
    }
    fireNetworkConnect_(bypassDialog) {
        assertExists(this.managedProperties_);
        const networkState = OncMojo.managedPropertiesToNetworkState(this.managedProperties_);
        const networkConnectEvent = new CustomEvent('network-connect', {
            bubbles: true,
            composed: true,
            detail: { networkState: networkState, bypassConnectionDialog: bypassDialog },
        });
        this.dispatchEvent(networkConnectEvent);
        // TODO(b/282233232) recordSettingChange() for connecting to network.
    }
    async handleDisconnectClick_() {
        const response = await this.networkConfig_.startDisconnect(this.guid);
        if (response.success) {
            recordSettingChange(Setting.kDisconnectWifiNetwork);
        }
        else {
            console.warn('Disconnect failed for: ' + this.guid);
        }
    }
    onConnectDisconnectClick_() {
        if (this.enableConnect_(this.managedProperties_, this.defaultNetwork, this.propertiesReceived_, this.outOfRange_, this.globalPolicy, this.managedNetworkAvailable, this.deviceState_)) {
            this.handleConnectClick_();
            return;
        }
        if (this.showDisconnect_(this.managedProperties_)) {
            this.handleDisconnectClick_();
            return;
        }
    }
    shouldConnectDisconnectButtonBeHidden_() {
        return !this.showConnect_(this.managedProperties_, this.globalPolicy, this.managedNetworkAvailable, this.deviceState_) &&
            !this.showDisconnect_(this.managedProperties_);
    }
    shouldConnectDisconnectButtonBeDisabled_() {
        if (this.disabled_) {
            return true;
        }
        if (this.enableConnect_(this.managedProperties_, this.defaultNetwork, this.propertiesReceived_, this.outOfRange_, this.globalPolicy, this.managedNetworkAvailable, this.deviceState_)) {
            return false;
        }
        if (this.showDisconnect_(this.managedProperties_)) {
            return false;
        }
        return true;
    }
    getConnectDisconnectButtonLabel_() {
        if (this.showConnect_(this.managedProperties_, this.globalPolicy, this.managedNetworkAvailable, this.deviceState_)) {
            return this.i18n('networkButtonConnect');
        }
        if (this.showDisconnect_(this.managedProperties_)) {
            return this.i18n('networkButtonDisconnect');
        }
        return '';
    }
    async onForgetClick_() {
        if (this.isPasspointWifi_(this.managedProperties_)) {
            // Ask user confirmation before removing a Passpoint Wi-Fi and the
            // associated subscription.
            this.getPasspointRemovalDialog_().open();
            return;
        }
        return this.forgetNetwork_();
    }
    async forgetNetwork_() {
        if (this.managedProperties_.type === NetworkType.kWiFi) {
            recordSettingChange(Setting.kForgetWifiNetwork);
        }
        const response = await this.networkConfig_.forgetNetwork(this.guid);
        if (!response.success) {
            console.warn('Forget network failed for: ' + this.guid);
        }
        // A forgotten network no longer has a valid GUID, close the subpage.
        this.close();
    }
    onSigninClick_() {
        this.browserProxy_.showPortalSignin(this.guid);
    }
    onActivateClick_() {
        this.browserProxy_.showCellularSetupUi(this.guid);
    }
    onConfigureClick_() {
        if (this.managedProperties_ &&
            (this.isThirdPartyVpn_(this.managedProperties_) ||
                this.isArcVpn_(this.managedProperties_))) {
            this.browserProxy_.configureThirdPartyVpn(this.guid);
            // TODO(b/282233232) recordSettingChange() for third party VPN configure.
            return;
        }
        assertExists(this.managedProperties_);
        const showConfigEvent = new CustomEvent('show-config', {
            bubbles: true,
            composed: true,
            detail: {
                guid: this.guid,
                type: OncMojo.getNetworkTypeString(this.managedProperties_.type),
                name: OncMojo.getNetworkNameUnsafe(this.managedProperties_),
            },
        });
        this.dispatchEvent(showConfigEvent);
    }
    onViewAccountClick_() {
        this.browserProxy_.showCarrierAccountDetail(this.guid);
    }
    showTetherDialog_() {
        this.getTetherDialog_().open();
    }
    showHiddenNetworkWarning_() {
        return loadTimeData.getBoolean('showHiddenNetworkWarning') &&
            !!this.autoConnectPref_.value && !!this.managedProperties_ &&
            this.managedProperties_.type === NetworkType.kWiFi &&
            !!OncMojo.getActiveValue(this.managedProperties_.typeProperties.wifi.hiddenSsid);
    }
    /**
     * Event triggered for elements associated with network properties.
     */
    onNetworkPropertyChange_(e) {
        if (!this.propertiesReceived_) {
            return;
        }
        const field = e.detail.field;
        const value = e.detail.value;
        const config = this.getDefaultConfigProperties_();
        const valueType = typeof value;
        if (valueType !== 'string' && valueType !== 'number' &&
            valueType !== 'boolean' && !Array.isArray(value)) {
            console.warn('Unexpected property change event, Key: ' + field +
                ' Value: ' + JSON.stringify(value));
            return;
        }
        OncMojo.setConfigProperty(config, field, value);
        // Ensure that any required configuration properties for partial
        // configurations are set.
        const vpnConfig = config.typeConfig.vpn;
        if (vpnConfig) {
            if (vpnConfig.openVpn &&
                vpnConfig.openVpn.saveCredentials === undefined) {
                vpnConfig.openVpn.saveCredentials = false;
            }
            if (vpnConfig.l2tp && vpnConfig.l2tp.saveCredentials === undefined) {
                vpnConfig.l2tp.saveCredentials = false;
            }
        }
        this.setMojoNetworkProperties_(config);
    }
    onApnChange_(event) {
        if (!this.propertiesReceived_) {
            return;
        }
        const config = this.getDefaultConfigProperties_();
        const apn = event.detail;
        config.typeConfig
            .cellular = { apn, roaming: null, textMessageAllowState: null };
        this.setMojoNetworkProperties_(config);
    }
    getApnRowSubLabel_() {
        if (!this.isCellular_(this.managedProperties_) ||
            !this.managedProperties_.typeProperties.cellular.connectedApn) {
            return '';
        }
        return getApnDisplayName(this.i18n.bind(this), this.managedProperties_.typeProperties.cellular.connectedApn);
    }
    onApnRowClicked_() {
        if (this.disabled_) {
            return;
        }
        if (!this.isCellular_(this.managedProperties_)) {
            console.error('APN row should only be visible when cellular is available.');
            return;
        }
        const params = new URLSearchParams();
        params.append('guid', this.guid);
        Router.getInstance().navigateTo(routes.APN, params);
    }
    /**
     * Event triggered when the IP Config or NameServers element changes.
     */
    onIpConfigChange_(event) {
        if (!this.managedProperties_) {
            return;
        }
        const config = OncMojo.getUpdatedIPConfigProperties(this.managedProperties_, event.detail.field, event.detail.value);
        if (config) {
            this.setMojoNetworkProperties_(config);
        }
    }
    /**
     * Event triggered when the Proxy configuration element changes.
     */
    onProxyChange_(event) {
        if (!this.propertiesReceived_) {
            return;
        }
        const config = this.getDefaultConfigProperties_();
        config.proxySettings = event.detail;
        this.setMojoNetworkProperties_(config);
    }
    propertiesMissingOrBlockedByPolicy_() {
        return !this.managedProperties_ ||
            this.isBlockedByPolicy_(this.managedProperties_, this.globalPolicy, this.managedNetworkAvailable);
    }
    sharedString_(managedProperties) {
        if (!managedProperties.typeProperties.wifi) {
            return this.i18n('networkShared');
        }
        else if (managedProperties.typeProperties.wifi.isConfiguredByActiveUser) {
            return this.i18n('networkSharedOwner');
        }
        else {
            return this.i18n('networkSharedNotOwner');
        }
    }
    syncedString_(managedProperties) {
        if (!managedProperties.typeProperties.wifi) {
            return '';
        }
        else if (!managedProperties.typeProperties.wifi.isSyncable) {
            return this.i18nAdvanced('networkNotSynced').toString();
        }
        else if (managedProperties.source === OncSource.kUser) {
            return this.i18nAdvanced('networkSyncedUser').toString();
        }
        else {
            return this.i18nAdvanced('networkSyncedDevice').toString();
        }
    }
    /**
     * @return Returns 'continuation' class for shared networks.
     */
    messagesDividerClass_(name, managedProperties, globalPolicy, managedNetworkAvailable, isSecondaryUser, isWifiSyncEnabled, deviceState) {
        let first = '';
        if (this.isBlockedByPolicy_(managedProperties, globalPolicy, managedNetworkAvailable)) {
            first = 'policy';
        }
        else if (isSecondaryUser) {
            first = 'secondary';
        }
        else if (this.showShared_(managedProperties, globalPolicy, managedNetworkAvailable, deviceState)) {
            first = 'shared';
        }
        else if (this.showSynced_(managedProperties, globalPolicy, managedNetworkAvailable, isWifiSyncEnabled)) {
            first = 'synced';
        }
        else if (isCarrierLockedActiveSim(managedProperties, deviceState)) {
            first = 'carrierlocked';
        }
        return first === name ? 'continuation' : '';
    }
    showSynced_(managedProperties, _globalPolicy, _managedNetworkAvailable, isWifiSyncEnabled) {
        return !this.propertiesMissingOrBlockedByPolicy_() && isWifiSyncEnabled &&
            !!managedProperties.typeProperties.wifi;
    }
    showShared_(managedProperties, _globalPolicy, _managedNetworkAvailable, deviceState) {
        if (isCarrierLockedActiveSim(managedProperties, deviceState)) {
            return false;
        }
        return !this.propertiesMissingOrBlockedByPolicy_() &&
            (managedProperties.source === OncSource.kDevice ||
                managedProperties.source === OncSource.kDevicePolicy);
    }
    isCarrierLockedActiveSim_(managedProperties, deviceState) {
        return isCarrierLockedActiveSim(managedProperties, deviceState);
    }
    showAutoConnect_(managedProperties, globalPolicy, managedNetworkAvailable) {
        return !!managedProperties &&
            managedProperties.type !== NetworkType.kEthernet &&
            this.isRemembered_(managedProperties) &&
            !this.isArcVpn_(managedProperties) &&
            !this.isBlockedByPolicy_(managedProperties, globalPolicy, managedNetworkAvailable);
    }
    showHiddenNetworkToggle_() {
        if (!this.showHiddenToggle_) {
            return false;
        }
        if (!this.managedProperties_) {
            return false;
        }
        if (this.managedProperties_.type !== NetworkType.kWiFi) {
            return false;
        }
        if (!this.isRemembered_(this.managedProperties_)) {
            return false;
        }
        if (this.isBlockedByPolicy_(this.managedProperties_, this.globalPolicy, this.managedNetworkAvailable)) {
            return false;
        }
        return true;
    }
    showMetered_() {
        const managedProperties = this.managedProperties_;
        return !!managedProperties && this.isRemembered_(managedProperties) &&
            (managedProperties.type === NetworkType.kCellular ||
                managedProperties.type === NetworkType.kWiFi);
    }
    showAlwaysOnVpn_(managedProperties) {
        return this.isArcVpn_(managedProperties) && this.prefs.arc &&
            this.prefs.arc.vpn && this.prefs.arc.vpn.always_on &&
            this.prefs.arc.vpn.always_on.vpn_package &&
            OncMojo.getActiveValue(managedProperties.typeProperties.vpn.host) ===
                this.prefs.arc.vpn.always_on.vpn_package.value;
    }
    alwaysOnVpnChanged_() {
        if (this.prefs && this.prefs.arc && this.prefs.arc.vpn &&
            this.prefs.arc.vpn.always_on && this.prefs.arc.vpn.always_on.lockdown) {
            this.set('prefs.arc.vpn.always_on.lockdown.value', this.alwaysOnVpn_.value);
        }
    }
    showPreferNetwork_(managedProperties, globalPolicy, managedNetworkAvailable) {
        if (!managedProperties) {
            return false;
        }
        const type = managedProperties.type;
        if (type === NetworkType.kEthernet || type === NetworkType.kCellular ||
            this.isArcVpn_(managedProperties)) {
            return false;
        }
        return this.isRemembered_(managedProperties) &&
            !this.isBlockedByPolicy_(managedProperties, globalPolicy, managedNetworkAvailable);
    }
    shouldPreferNetworkToggleBeDisabled_() {
        return this.disabled_ ||
            this.isNetworkPolicyEnforced(this.managedProperties_.priority);
    }
    onPreferNetworkRowClicked_(event) {
        // Stop propagation because the toggle and policy indicator handle clicks
        // themselves.
        event.stopPropagation();
        const preferNetworkToggle = this.shadowRoot.querySelector('#preferNetworkToggle');
        if (!preferNetworkToggle || preferNetworkToggle.disabled) {
            return;
        }
        this.preferNetwork_ = !this.preferNetwork_;
    }
    hasVisibleFields_(fields) {
        for (let i = 0; i < fields.length; ++i) {
            const key = OncMojo.getManagedPropertyKey(fields[i]);
            const value = this.get(key, this.managedProperties_);
            if (value !== undefined && value !== null && value !== '') {
                return true;
            }
        }
        return false;
    }
    hasInfoFields_() {
        const editFieldTypes = this.getInfoEditFieldTypes_();
        const infoFields = this.getInfoFields_();
        return Object.keys(editFieldTypes).length > 0 ||
            this.hasVisibleFields_(infoFields);
    }
    getInfoFields_() {
        if (!this.managedProperties_) {
            return [];
        }
        const fields = [];
        switch (this.managedProperties_.type) {
            case NetworkType.kCellular:
                fields.push('cellular.servingOperator.name');
                break;
            case NetworkType.kTether:
                fields.push('tether.batteryPercentage', 'tether.signalStrength', 'tether.carrier');
                break;
            case NetworkType.kVPN:
                const vpnType = this.managedProperties_.typeProperties.vpn.type;
                switch (vpnType) {
                    case VpnType.kExtension:
                        fields.push('vpn.providerName');
                        break;
                    case VpnType.kArc:
                        fields.push('vpn.type');
                        fields.push('vpn.providerName');
                        break;
                    case VpnType.kOpenVPN:
                        fields.push('vpn.type', 'vpn.host', 'vpn.openVpn.username', 'vpn.openVpn.extraHosts');
                        break;
                    case VpnType.kL2TPIPsec:
                        fields.push('vpn.type', 'vpn.host', 'vpn.l2tp.username');
                        break;
                }
                break;
            case NetworkType.kWiFi:
                break;
        }
        if (OncMojo.isRestrictedConnectivity(this.managedProperties_.portalState)) {
            fields.push('portalState');
        }
        return fields;
    }
    /**
     * Provides the list of editable fields to <network-property-list>.
     * NOTE: Entries added to this list must be reflected in ConfigProperties in
     * chromeos.network_config.mojom and handled in the service implementation.
     * @return A dictionary of editable fields in the info section.
     */
    getInfoEditFieldTypes_() {
        if (!this.managedProperties_) {
            return {};
        }
        const editFields = {};
        const type = this.managedProperties_.type;
        if (type === NetworkType.kVPN) {
            const vpnType = this.managedProperties_.typeProperties.vpn.type;
            if (vpnType !== VpnType.kExtension) {
                editFields['vpn.host'] = 'String';
            }
            if (vpnType === VpnType.kOpenVPN) {
                editFields['vpn.openVpn.username'] = 'String';
                editFields['vpn.openVpn.extraHosts'] = 'StringArray';
            }
        }
        return editFields;
    }
    getAdvancedFields_() {
        if (!this.managedProperties_) {
            return [];
        }
        const fields = [];
        const type = this.managedProperties_.type;
        switch (type) {
            case NetworkType.kCellular:
                fields.push('cellular.activationState', 'cellular.networkTechnology');
                break;
            case NetworkType.kWiFi:
                fields.push('wifi.ssid', 'wifi.bssid', 'wifi.signalStrength', 'wifi.security', 'wifi.eap.outer', 'wifi.eap.inner', 'wifi.eap.domainSuffixMatch', 'wifi.eap.subjectAltNameMatch', 'wifi.eap.subjectMatch', 'wifi.eap.identity', 'wifi.eap.anonymousIdentity', 'wifi.frequency');
                break;
            case NetworkType.kVPN:
                const vpnType = this.managedProperties_.typeProperties.vpn.type;
                switch (vpnType) {
                    case VpnType.kOpenVPN:
                        if (this.isManagedByPolicy_()) {
                            fields.push('vpn.openVpn.auth', 'vpn.openVpn.cipher', 'vpn.openVpn.compressionAlgorithm', 'vpn.openVpn.tlsAuthContents', 'vpn.openVpn.keyDirection');
                        }
                        break;
                }
                break;
        }
        return fields;
    }
    getDeviceFields_() {
        if (!this.managedProperties_ ||
            this.managedProperties_.type !== NetworkType.kCellular) {
            return [];
        }
        const fields = [];
        const networkState = OncMojo.managedPropertiesToNetworkState(this.managedProperties_);
        if (isActiveSim(networkState, this.deviceState_)) {
            // These fields are only known for the SIM in the active slot.
            fields.push('cellular.homeProvider.name', 'cellular.homeProvider.country');
        }
        fields.push('cellular.firmwareRevision', 'cellular.hardwareRevision', 'cellular.esn', 'cellular.iccid', 'cellular.imei', 'cellular.meid', 'cellular.min');
        return fields;
    }
    async computeTrafficCountersAvailable_() {
        const networks = await this.trafficCountersAdapter_
            .requestTrafficCountersForActiveNetworks();
        this.trafficCountersAvailable_ = networks.some(n => n.guid === this.guid);
    }
    showDataUsage_(managedProperties, trafficCountersAvailable) {
        if (!this.isTrafficCountersEnabled_) {
            return false;
        }
        if (!managedProperties || this.guid === '') {
            return false;
        }
        if (!this.isCellular_(managedProperties) &&
            !(this.isWiFi_(managedProperties) &&
                this.isTrafficCountersForWifiTestingEnabled_)) {
            return false;
        }
        if (!this.isConnectedState_(managedProperties)) {
            return false;
        }
        return trafficCountersAvailable;
    }
    hasAdvancedSection_() {
        if (!this.managedProperties_ || !this.propertiesReceived_) {
            return false;
        }
        if (this.showMetered_()) {
            return true;
        }
        if (this.managedProperties_.type === NetworkType.kTether) {
            // These properties apply to the underlying WiFi network, not the Tether
            // network.
            return false;
        }
        return this.hasAdvancedFields_() || this.hasDeviceFields_();
    }
    hasAdvancedFields_() {
        return this.hasVisibleFields_(this.getAdvancedFields_());
    }
    hasDeviceFields_() {
        return this.hasVisibleFields_(this.getDeviceFields_());
    }
    hasNetworkSection_(managedProperties, globalPolicy, managedNetworkAvailable) {
        if (!managedProperties || managedProperties.type === NetworkType.kTether) {
            // These settings apply to the underlying WiFi network, not the Tether
            // network.
            return false;
        }
        if (this.isBlockedByPolicy_(managedProperties, globalPolicy, managedNetworkAvailable)) {
            return false;
        }
        if (managedProperties.type === NetworkType.kCellular) {
            return true;
        }
        return this.isRememberedOrConnected_(managedProperties);
    }
    hasProxySection_(managedProperties, globalPolicy, managedNetworkAvailable) {
        if (!managedProperties || managedProperties.type === NetworkType.kTether) {
            // Proxy settings apply to the underlying WiFi network, not the Tether
            // network.
            return false;
        }
        if (this.isBlockedByPolicy_(managedProperties, globalPolicy, managedNetworkAvailable)) {
            return false;
        }
        return this.isRememberedOrConnected_(managedProperties);
    }
    isPasspointWifi_(managedProperties) {
        return !!managedProperties &&
            managedProperties.type === NetworkType.kWiFi &&
            managedProperties.typeProperties.wifi.passpointId !== '' &&
            managedProperties.typeProperties.wifi.passpointMatchType !==
                MatchType.kNoMatch;
    }
    shouldShowPasspointProviderRow_(managedProperties) {
        return this.isPasspointWifi_(managedProperties);
    }
    getPasspointSubscriptionName_(subscription) {
        if (!subscription) {
            return '';
        }
        if (subscription.friendlyName && subscription.friendlyName !== '') {
            return subscription.friendlyName;
        }
        return subscription.domains[0];
    }
    onPasspointRowClicked_() {
        const showPasspointEvent = new CustomEvent('show-passpoint-detail', { bubbles: true, composed: true, detail: this.passpointSubscription_ });
        this.dispatchEvent(showPasspointEvent);
    }
    onPasspointRemovalDialogConfirm_() {
        this.getPasspointRemovalDialog_().close();
        // The removal dialog leads the user to the subscription page.
        this.onPasspointRowClicked_();
    }
    showCellularChooseNetwork_(managedProperties) {
        return !!managedProperties &&
            managedProperties.type === NetworkType.kCellular &&
            managedProperties.typeProperties.cellular.supportNetworkScan;
    }
    showScanningSpinner_() {
        if (!this.managedProperties_ ||
            this.managedProperties_.type !== NetworkType.kCellular) {
            return false;
        }
        return !!this.deviceState_ && this.deviceState_.scanning;
    }
    showCellularSimUpdatedUi_(managedProperties) {
        return !!managedProperties &&
            managedProperties.type === NetworkType.kCellular &&
            managedProperties.typeProperties.cellular.family !== 'CDMA';
    }
    isArcVpn_(managedProperties) {
        return !!managedProperties && managedProperties.type === NetworkType.kVPN &&
            managedProperties.typeProperties.vpn.type === VpnType.kArc;
    }
    isThirdPartyVpn_(managedProperties) {
        return !!managedProperties && managedProperties.type === NetworkType.kVPN &&
            managedProperties.typeProperties.vpn.type === VpnType.kExtension;
    }
    showIpAddress_(ipAddress, managedProperties) {
        // Arc Vpn does not currently pass IP configuration to ChromeOS. IP address
        // property holds an internal IP address Android uses to talk to ChromeOS.
        // TODO(lgcheng@) Show correct IP address when we implement IP configuration
        // correctly.
        if (this.isArcVpn_(managedProperties)) {
            return false;
        }
        // Cellular IP addresses are shown under the network details section.
        if (this.isCellular_(managedProperties)) {
            return false;
        }
        return !!ipAddress && this.isConnectedState_(managedProperties);
    }
    isOutOfRangeOrNotEnabled_(outOfRange, deviceState) {
        return outOfRange ||
            (!!deviceState && deviceState.deviceState !== DeviceStateType.kEnabled);
    }
    computeShowConfigurableSections_() {
        if (!this.managedProperties_ || !this.deviceState_) {
            return true;
        }
        const networkState = OncMojo.managedPropertiesToNetworkState(this.managedProperties_);
        assertExists(networkState);
        if (networkState.type !== NetworkType.kCellular) {
            return true;
        }
        return isActiveSim(networkState, this.deviceState_);
    }
    computeDisabled_() {
        return shouldDisallowNetworkModifications(this.deviceState_, this.managedProperties_);
    }
    shouldShowMacAddress_() {
        return !!this.getMacAddress_();
    }
    getMacAddress_() {
        if (!this.deviceState_) {
            return '';
        }
        // 00:00:00:00:00:00 is provided when device MAC address cannot be
        // retrieved.
        const MISSING_MAC_ADDRESS = '00:00:00:00:00:00';
        if (this.deviceState_ && this.deviceState_.macAddress &&
            this.deviceState_.macAddress !== MISSING_MAC_ADDRESS) {
            return this.deviceState_.macAddress;
        }
        return '';
    }
    isManagedByPolicy_() {
        return this.managedProperties_.source === OncSource.kUserPolicy ||
            this.managedProperties_.source === OncSource.kDevicePolicy;
    }
    isPortalState_(portalState) {
        return portalState === PortalState.kPortal ||
            portalState === PortalState.kPortalSuspected;
    }
}
customElements.define(SettingsInternetDetailPageElement.is, SettingsInternetDetailPageElement);

function getTemplate$2f() {
    return html `<!--_html_template_start_--><style include="internet-shared iron-flex">cr-policy-indicator{margin-inline-start:var(--cr-controlled-by-spacing)}</style>

<div class="settings-box first">
  <div class="settings-box-text">$i18n{knownNetworksMessage}</div>
</div>

<h2 class="settings-box">$i18n{knownNetworksPreferred}</h2>
<div class="list-frame vertical-list"
    hidden$="[[havePreferred_(networkStateList_)]]">
  <div class="list-item settings-box-text">
    $i18n{internetNoNetworks}
  </div>
</div>
<div id="preferredNetworkList" class="list-frame vertical-list"
    hidden$="[[!havePreferred_(networkStateList_)]]">
  <template is="dom-repeat" items="[[networkStateList_]]"
      filter="networkIsPreferred_">
    <div class="list-item">
      <cr-link-row embedded label="[[getNetworkDisplayName_(item)]]"
          on-click="fireShowDetails_"
          role-description="$i18n{subpageArrowRoleDescription}"
          deep-link-focus-id$="[[Setting.kForgetWifiNetwork]]">
        <template is="dom-if" if="[[isPolicySource(item.source))]]">
          <cr-policy-indicator on-click="doNothing_"
              indicator-type="[[getIndicatorTypeForSource(item.source)]]"
              icon-aria-label="[[getEnterpriseIconAriaLabel_(item)]]">
          </cr-policy-indicator>
        </template>
      </cr-link-row>
      <div class="separator"></div>
      <cr-icon-button class="icon-more-vert" tabindex$="[[tabindex]]"
          on-click="onMenuButtonClick_" title="[[getMenuButtonTitle_(item)]]">
      </cr-icon-button>
    </div>
  </template>
</div>

<h2 class="settings-box">$i18n{knownNetworksAll}</h2>
<div id="notPreferredNetworkList" class="list-frame vertical-list"
    hidden$="[[!haveNotPreferred_(networkStateList_)]]">
  <template is="dom-repeat" items="[[networkStateList_]]"
      filter="networkIsNotPreferred_">
    <div class="list-item">
      <cr-link-row embedded label="[[getNetworkDisplayName_(item)]]"
          on-click="fireShowDetails_"
          role-description="$i18n{subpageArrowRoleDescription}"
          deep-link-focus-id$="[[Setting.kPreferWifiNetwork]]
              [[Setting.kForgetWifiNetwork]]">
        <template is="dom-if" if="[[isPolicySource(item.source))]]">
          <cr-policy-indicator on-click="doNothing_"
              indicator-type="[[getIndicatorTypeForSource(item.source)]]"
              icon-aria-label="[[getEnterpriseIconAriaLabel_(item)]]">
          </cr-policy-indicator>
        </template>
      </cr-link-row>
      <div class="separator"></div>
      <cr-icon-button class="icon-more-vert" tabindex$="[[tabindex]]"
          on-click="onMenuButtonClick_" title="[[getMenuButtonTitle_(item)]]">
      </cr-icon-button>
    </div>
  </template>
</div>

<template is="dom-if"
    if="[[shouldShowPasspointSection_(passpointSubscriptionsList_)]]">
  <h2 class="settings-box">$i18n{passpointSectionLabel}</h2>
  <div id="passpointSubscriptionList" class="list-frame vertical-list">
    <template is="dom-repeat" items="[[passpointSubscriptionsList_]]">
      <div class="list-item">
        <cr-link-row id="subscriptionItem" embedded
            label="[[getSubscriptionDisplayName_(item)]]"
            on-click="onSubscriptionListItemClick_"
            role-description="$i18n{subpageArrowRoleDescription}">
        </cr-link-row>
        <div class="separator"></div>
        <cr-icon-button id="subscriptionMoreButton" class="icon-more-vert"
            tabindex$="[[tabindex]]" on-click="onSubscriptionMenuButtonClick_"
            title="[[getSubscriptionMenuButtonTitle_(item)]]">
        </cr-icon-button>
      </div>
    </template>
  </div>
</template>

<cr-action-menu id="dotsMenu" role-description="$i18n{menu}">
  <button class="dropdown-item" hidden="[[!showAddPreferred_]]"
      on-click="onAddPreferredClick_">
    $i18n{knownNetworksMenuAddPreferred}
  </button>
  <button class="dropdown-item"
      hidden="[[!showRemovePreferred_]]" on-click="onRemovePreferredClick_">
    $i18n{knownNetworksMenuRemovePreferred}
  </button>
  <button class="dropdown-item" disabled="[[!enableForget_]]"
      on-click="onForgetClick_">
    $i18n{knownNetworksMenuForget}
  </button>
</cr-action-menu>

<cr-action-menu id="subscriptionDotsMenu" role-description="$i18n{menu}">
  <button id="subscriptionForget" class="dropdown-item"
      on-click="onSubscriptionForgetClick_">
    $i18n{knownNetworksMenuForget}
  </button>
</cr-action-menu>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Mixin to be used by Polymer elements that want to listen for
 * Passpoint subscription events.
 */
const PasspointListenerMixin = dedupingMixin((superClass) => {
    class PasspointListenerMixin extends superClass {
        constructor(...args) {
            super(...args);
            this.listener_ = null;
        }
        connectedCallback() {
            super.connectedCallback();
            this.listener_ = new PasspointEventsListenerReceiver(this);
            MojoConnectivityProvider.getInstance()
                .getPasspointService()
                .registerPasspointListener(this.listener_.$.bindNewPipeAndPassRemote());
        }
        disconnectedCallback() {
            super.disconnectedCallback();
            if (this.listener_) {
                this.listener_.$.close();
            }
        }
        onPasspointSubscriptionAdded(_) { }
        onPasspointSubscriptionRemoved(_) { }
    }
    return PasspointListenerMixin;
});

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'settings-internet-known-networks' is the settings subpage listing the
 * known networks for a type (currently always WiFi).
 */
const SettingsInternetKnownNetworksPageElementBase = mixinBehaviors([
    NetworkListenerBehavior,
    CrPolicyNetworkBehaviorMojo,
], PasspointListenerMixin(DeepLinkingMixin(RouteObserverMixin(I18nMixin(PolymerElement)))));
class SettingsInternetKnownNetworksPageElement extends SettingsInternetKnownNetworksPageElementBase {
    static get is() {
        return 'settings-internet-known-networks-subpage';
    }
    static get template() {
        return getTemplate$2f();
    }
    static get properties() {
        return {
            /**
             * The type of networks to list.
             */
            networkType: {
                type: Number,
                observer: 'networkTypeChanged_',
            },
            /**
             * List of all network state data for the network type.
             */
            networkStateList_: {
                type: Array,
                value() {
                    return [];
                },
            },
            /**
             * List of all the passpoint subscriptions available.
             */
            passpointSubscriptionsList_: {
                type: Array,
                notify: true,
                value() {
                    return [];
                },
            },
            showAddPreferred_: Boolean,
            showRemovePreferred_: Boolean,
            /**
             * We always show 'Forget' since we do not know whether or not to enable
             * it until we fetch the managed properties, and we do not want an empty
             * menu.
             */
            enableForget_: Boolean,
            /**
             * Contains the settingId of any deep link that wasn't able to be shown,
             * null otherwise.
             */
            pendingSettingId_: {
                type: Number,
                value: null,
            },
        };
    }
    constructor() {
        super();
        // DeepLinkingMixin override
        this.supportedSettingIds = new Set([
            Setting.kPreferWifiNetwork,
            Setting.kForgetWifiNetwork,
        ]);
        this.selectedGuid_ = '';
        this.selectedSubscriptionId_ = '';
        this.networkConfig_ =
            MojoInterfaceProviderImpl.getInstance().getMojoServiceRemote();
        this.passpointService_ =
            MojoConnectivityProvider.getInstance().getPasspointService();
    }
    /**
     * RouteObserverMixin override
     */
    currentRouteChanged(route) {
        // Does not apply to this page.
        if (route !== routes.KNOWN_NETWORKS) {
            return;
        }
        this.attemptDeepLink().then(result => {
            if (!result.deepLinkShown && result.pendingSettingId) {
                // Store any deep link settingId that wasn't shown so we can try again
                // in refreshNetworks.
                this.pendingSettingId_ = result.pendingSettingId;
            }
        });
        this.refreshSubscriptions_();
    }
    /** CrosNetworkConfigObserver impl */
    onNetworkStateListChanged() {
        this.refreshNetworks_();
    }
    /** CrosNetworkConfigObserver impl */
    onNetworkStateChanged(network) {
        // Force refresh the networks if we are missing the network state properties
        // or the signal strength is one (WiFi network signal strength is non-zero
        // by convention) since these could indicate the network is not active and
        // would not independently trigger a list update.
        if (!network ||
            (network.type === NetworkType.kWiFi &&
                (!network.typeState.wifi?.signalStrength ||
                    network.typeState.wifi?.signalStrength === 1))) {
            this.refreshNetworks_();
        }
    }
    networkTypeChanged_() {
        this.refreshNetworks_();
    }
    /**
     * Requests the list of network states from Chrome. Updates networkStates
     * once the results are returned from Chrome.
     */
    async refreshNetworks_() {
        if (this.networkType === undefined) {
            return;
        }
        const filter = {
            filter: FilterType.kConfigured,
            limit: NO_LIMIT,
            networkType: this.networkType,
        };
        const response = await this.networkConfig_.getNetworkStateList(filter);
        this.networkStateList_ = response.result;
        // Check if we have yet to focus a deep-linked element.
        if (!this.pendingSettingId_) {
            return;
        }
        const result = await this.showDeepLink(this.pendingSettingId_);
        if (result.deepLinkShown) {
            this.pendingSettingId_ = null;
        }
    }
    async refreshSubscriptions_() {
        if (this.networkType !== NetworkType.kWiFi) {
            this.passpointSubscriptionsList_ = [];
            return;
        }
        const response = await this.passpointService_.listPasspointSubscriptions();
        this.passpointSubscriptionsList_ = response.result;
    }
    networkIsPreferred_(networkState) {
        // Currently we treat NetworkStateProperties.Priority as a boolean.
        return networkState.priority > 0;
    }
    networkIsNotPreferred_(networkState) {
        return networkState.priority === 0;
    }
    havePreferred_() {
        return this.networkStateList_.find(state => this.networkIsPreferred_(state)) !== undefined;
    }
    haveNotPreferred_() {
        return this.networkStateList_.find(state => this.networkIsNotPreferred_(state)) !== undefined;
    }
    getNetworkDisplayName_(networkState) {
        return OncMojo.getNetworkStateDisplayNameUnsafe(networkState);
    }
    shouldShowPasspointSection_(subscriptionsList) {
        return this.networkType === NetworkType.kWiFi &&
            subscriptionsList.length > 0;
    }
    getSubscriptionDisplayName_(subscription) {
        if (subscription.friendlyName && subscription.friendlyName !== '') {
            return subscription.friendlyName;
        }
        return subscription.domains[0];
    }
    getEnterpriseIconAriaLabel_(networkState) {
        return loadTimeData.getStringF('networkA11yManagedByAdministrator', this.getNetworkDisplayName_(networkState));
    }
    async onMenuButtonClick_(event) {
        const button = event.target;
        const networkState = event.model.item;
        this.selectedGuid_ = networkState.guid;
        // We need to make a round trip to Chrome in order to retrieve the managed
        // properties for the network. The delay is not noticeable (~5ms) and is
        // preferable to initiating a query for every known network at load time.
        const response = await this.networkConfig_.getManagedProperties(this.selectedGuid_);
        const properties = response.result;
        if (!properties) {
            console.warn('Properties not found for: ' + this.selectedGuid_);
            return;
        }
        if (properties.priority &&
            this.isNetworkPolicyEnforced(properties.priority)) {
            this.showAddPreferred_ = false;
            this.showRemovePreferred_ = false;
        }
        else {
            const preferred = this.networkIsPreferred_(networkState);
            this.showAddPreferred_ = !preferred;
            this.showRemovePreferred_ = preferred;
        }
        this.enableForget_ = !this.isPolicySource(networkState.source);
        this.$.dotsMenu.showAt(button);
        event.stopPropagation();
    }
    getMenuButtonTitle_(networkState) {
        return loadTimeData.getStringF('knownNetworksMenuButtonTitle', this.getNetworkDisplayName_(networkState));
    }
    async setProperties_(config) {
        const response = await this.networkConfig_.setProperties(this.selectedGuid_, config);
        if (response.success) {
            recordSettingChange(Setting.kPreferWifiNetwork, { boolValue: config.priority?.value === 1 });
        }
        else {
            console.warn('Unable to set properties for: ' + this.selectedGuid_ + ': ' +
                JSON.stringify(config));
        }
    }
    onRemovePreferredClick_() {
        assertExists(this.networkType);
        const config = OncMojo.getDefaultConfigProperties(this.networkType);
        config.priority = { value: 0 };
        this.setProperties_(config);
        this.$.dotsMenu.close();
    }
    onAddPreferredClick_() {
        assertExists(this.networkType);
        const config = OncMojo.getDefaultConfigProperties(this.networkType);
        config.priority = { value: 1 };
        this.setProperties_(config);
        this.$.dotsMenu.close();
    }
    async onForgetClick_() {
        this.$.dotsMenu.close();
        const response = await this.networkConfig_.forgetNetwork(this.selectedGuid_);
        if (!response.success) {
            console.warn('Forget network failed for: ' + this.selectedGuid_);
            return;
        }
        if (this.networkType === NetworkType.kWiFi) {
            recordSettingChange(Setting.kForgetWifiNetwork);
        }
    }
    /**
     * Fires a 'show-detail' event with an item containing a |networkStateList_|
     * entry in the event model.
     */
    fireShowDetails_(event) {
        const networkState = event.model.item;
        const showDetailEvent = new CustomEvent('show-detail', { bubbles: true, composed: true, detail: networkState });
        this.dispatchEvent(showDetailEvent);
        event.stopPropagation();
    }
    onSubscriptionListItemClick_(event) {
        const showPasspointEvent = new CustomEvent('show-passpoint-detail', { bubbles: true, composed: true, detail: event.model.item });
        this.dispatchEvent(showPasspointEvent);
        event.stopPropagation();
    }
    /**
     * Make sure events in embedded components do not propagate to onDetailsClick_.
     */
    doNothing_(event) {
        event.stopPropagation();
    }
    onSubscriptionMenuButtonClick_(event) {
        const button = event.target;
        this.selectedSubscriptionId_ = event.model.item.id;
        this.$.subscriptionDotsMenu.showAt(button);
        event.stopPropagation();
    }
    getSubscriptionMenuButtonTitle_(subscription) {
        return this.i18n('knownNetworksMenuButtonTitle', this.getSubscriptionDisplayName_(subscription));
    }
    async onSubscriptionForgetClick_() {
        this.$.subscriptionDotsMenu.close();
        const response = await this.passpointService_.deletePasspointSubscription(this.selectedSubscriptionId_);
        if (!response.success) {
            console.warn('Forget subscription failed for: ' + this.selectedSubscriptionId_);
        }
        this.selectedSubscriptionId_ = '';
    }
    onPasspointSubscriptionAdded(subscription) {
        this.push('passpointSubscriptionsList_', subscription);
    }
    onPasspointSubscriptionRemoved(subscription) {
        const list = this.passpointSubscriptionsList_.filter((sub) => {
            return sub.id !== subscription.id;
        });
        this.passpointSubscriptionsList_ = list;
    }
}
customElements.define(SettingsInternetKnownNetworksPageElement.is, SettingsInternetKnownNetworksPageElement);

// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// clang-format on


let hideInk = false;

document.addEventListener('pointerdown', function() {
  hideInk = true;
}, true);

document.addEventListener('keydown', function() {
  hideInk = false;
}, true);

/**
 * Attempts to track whether focus outlines should be shown, and if they
 * shouldn't, removes the "ink" (ripple) from a control while focusing it.
 * This is helpful when a user is clicking/touching, because it's not super
 * helpful to show focus ripples in that case. This is Polymer-specific.
 * @param {!Element} toFocus
 */
const focusWithoutInk = function(toFocus) {
  // |toFocus| does not have a 'noink' property, so it's unclear whether the
  // element has "ink" and/or whether it can be suppressed. Just focus().
  if (!('noink' in toFocus) || !hideInk) {
    toFocus.focus();
    return;
  }

  // Make sure the element is in the document we're listening to events on.
  assert$1(document === toFocus.ownerDocument);
  const {noink} = toFocus;
  toFocus.noink = true;
  toFocus.focus();
  toFocus.noink = noink;
};

// Copyright 2011 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

/**
 * @fileoverview EventTracker is a simple class that manages the addition and
 * removal of DOM event listeners. In particular, it keeps track of all
 * listeners that have been added and makes it easy to remove some or all of
 * them without requiring all the information again. This is particularly handy
 * when the listener is a generated function such as a lambda or the result of
 * calling Function.bind.
 * Note: This file is deprecated in favor of the TypeScript version at
 * ui/webui/resources/js/event_tracker.ts. The TypeScript version should be used
 * in all TypeScript code, and can also be used by JavaScript code that is not
 * typechecked with closure compiler.
 */

class EventTracker {
  /**
   * Create an EventTracker to track a set of events.
   * EventTracker instances are typically tied 1:1 with other objects or
   * DOM elements whose listeners should be removed when the object is
   * disposed or the corresponding elements are removed from the DOM.
   */
  constructor() {
    /**
     * @type {Array<EventTrackerEntry>}
     * @private
     */
    this.listeners_ = [];
  }

  /**
   * Add an event listener - replacement for EventTarget.addEventListener.
   * @param {!EventTarget} target The DOM target to add a listener to.
   * @param {string} eventType The type of event to subscribe to.
   * @param {EventListener|Function} listener The listener to add.
   * @param {boolean=} capture Whether to invoke during the capture phase.
   */
  add(target, eventType, listener, capture = false) {
    const h = {
      target: target,
      eventType: eventType,
      listener: listener,
      capture: capture,
    };
    this.listeners_.push(h);
    target.addEventListener(eventType, listener, capture);
  }

  /**
   * Remove any specified event listeners added with this EventTracker.
   * @param {!EventTarget} target The DOM target to remove a listener from.
   * @param {?string} eventType The type of event to remove.
   */
  remove(target, eventType) {
    this.listeners_ = this.listeners_.filter(listener => {
      if (listener.target === target &&
          (!eventType || (listener.eventType === eventType))) {
        EventTracker.removeEventListener(listener);
        return false;
      }
      return true;
    });
  }

  /** Remove all event listeners added with this EventTracker. */
  removeAll() {
    this.listeners_.forEach(
        listener => EventTracker.removeEventListener(listener));
    this.listeners_ = [];
  }

  /**
   * Remove a single event listener given it's tracking entry. It's up to the
   * caller to ensure the entry is removed from listeners_.
   * @param {EventTrackerEntry} entry The entry describing the listener to
   * remove.
   */
  static removeEventListener(entry) {
    entry.target.removeEventListener(
        entry.eventType, entry.listener, entry.capture);
  }
}

// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.


/**
 * Check the directionality of the page.
 * @return {boolean} True if Chrome is running an RTL UI.
 */
function isRTL() {
  return document.documentElement.dir === 'rtl';
}

/**
 * @param {!Event} e
 * @return {boolean} Whether a modifier key was down when processing |e|.
 */
function hasKeyModifiers(e) {
  return !!(e.altKey || e.ctrlKey || e.metaKey || e.shiftKey);
}

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// clang-format on

  /**
   * A class to manage focus between given horizontally arranged elements.
   *
   * Pressing left cycles backward and pressing right cycles forward in item
   * order. Pressing Home goes to the beginning of the list and End goes to the
   * end of the list.
   *
   * If an item in this row is focused, it'll stay active (accessible via tab).
   * If no items in this row are focused, the row can stay active until focus
   * changes to a node inside |this.boundary_|. If |boundary| isn't specified,
   * any focus change deactivates the row.
   */
  class FocusRow {
    /**
     * @param {!Element} root The root of this focus row. Focus classes are
     *     applied to |root| and all added elements must live within |root|.
     * @param {?Element} boundary Focus events are ignored outside of this
     *     element.
     * @param {FocusRowDelegate=} delegate An optional event
     *     delegate.
     */
    constructor(root, boundary, delegate) {
      /** @type {!Element} */
      this.root = root;

      /** @private {!Element} */
      this.boundary_ = boundary || document.documentElement;

      /** @type {FocusRowDelegate|undefined} */
      this.delegate = delegate;

      /** @protected {!EventTracker} */
      this.eventTracker = new EventTracker();
    }

    /**
     * Whether it's possible that |element| can be focused.
     * @param {Element} element
     * @return {boolean} Whether the item is focusable.
     */
    static isFocusable(element) {
      if (!element || element.disabled) {
        return false;
      }

      // We don't check that element.tabIndex >= 0 here because inactive rows
      // set a tabIndex of -1.
      let current = element;
      while (true) {
        assertInstanceof(current, Element);

        const style = window.getComputedStyle(current);
        if (style.visibility === 'hidden' || style.display === 'none') {
          return false;
        }

        const parent = current.parentNode;
        if (!parent) {
          return false;
        }

        if (parent === current.ownerDocument ||
            parent instanceof DocumentFragment) {
          return true;
        }

        current = /** @type {Element} */ (parent);
      }
    }

    /**
     * A focus override is a function that returns an element that should gain
     * focus. The element may not be directly selectable for example the element
     * that can gain focus is in a shadow DOM. Allowing an override via a
     * function leaves the details of how the element is retrieved to the
     * component.
     * @param {!HTMLElement} element
     * @return {!HTMLElement}
     */
    static getFocusableElement(element) {
      if (element.getFocusableElement) {
        return element.getFocusableElement();
      }
      return element;
    }

    /**
     * Register a new type of focusable element (or add to an existing one).
     *
     * Example: an (X) button might be 'delete' or 'close'.
     *
     * When FocusRow is used within a FocusGrid, these types are used to
     * determine equivalent controls when Up/Down are pressed to change rows.
     *
     * Another example: mutually exclusive controls that hide each other on
     * activation (i.e. Play/Pause) could use the same type (i.e. 'play-pause')
     * to indicate they're equivalent.
     *
     * @param {string} type The type of element to track focus of.
     * @param {string|HTMLElement} selectorOrElement The selector of the element
     *    from this row's root, or the element itself.
     * @return {boolean} Whether a new item was added.
     */
    addItem(type, selectorOrElement) {
      assert$1(type);

      let element;
      if (typeof selectorOrElement === 'string') {
        element = this.root.querySelector(selectorOrElement);
      } else {
        element = selectorOrElement;
      }
      if (!element) {
        return false;
      }

      element.setAttribute('focus-type', type);
      element.tabIndex = this.isActive() ? 0 : -1;

      this.eventTracker.add(element, 'blur', this.onBlur_.bind(this));
      this.eventTracker.add(element, 'focus', this.onFocus_.bind(this));
      this.eventTracker.add(element, 'keydown', this.onKeydown_.bind(this));
      this.eventTracker.add(element, 'mousedown', this.onMousedown_.bind(this));
      return true;
    }

    /** Dereferences nodes and removes event handlers. */
    destroy() {
      this.eventTracker.removeAll();
    }

    /**
     * @param {!HTMLElement} sampleElement An element for to find an equivalent
     *     for.
     * @return {!HTMLElement} An equivalent element to focus for
     *     |sampleElement|.
     * @protected
     */
    getCustomEquivalent(sampleElement) {
      return /** @type {!HTMLElement} */ (assert$1(this.getFirstFocusable()));
    }

    /**
     * @return {!Array<!HTMLElement>} All registered elements (regardless of
     *     focusability).
     */
    getElements() {
      return Array.from(this.root.querySelectorAll('[focus-type]'))
          .map(FocusRow.getFocusableElement);
    }

    /**
     * Find the element that best matches |sampleElement|.
     * @param {!HTMLElement} sampleElement An element from a row of the same
     *     type which previously held focus.
     * @return {!HTMLElement} The element that best matches sampleElement.
     */
    getEquivalentElement(sampleElement) {
      if (this.getFocusableElements().indexOf(sampleElement) >= 0) {
        return sampleElement;
      }

      const sampleFocusType = this.getTypeForElement(sampleElement);
      if (sampleFocusType) {
        const sameType = this.getFirstFocusable(sampleFocusType);
        if (sameType) {
          return sameType;
        }
      }

      return this.getCustomEquivalent(sampleElement);
    }

    /**
     * @param {string=} opt_type An optional type to search for.
     * @return {?HTMLElement} The first focusable element with |type|.
     */
    getFirstFocusable(opt_type) {
      const element = this.getFocusableElements().find(
          el => !opt_type || el.getAttribute('focus-type') === opt_type);
      return element || null;
    }

    /** @return {!Array<!HTMLElement>} Registered, focusable elements. */
    getFocusableElements() {
      return this.getElements().filter(FocusRow.isFocusable);
    }

    /**
     * @param {!Element} element An element to determine a focus type for.
     * @return {string} The focus type for |element| or '' if none.
     */
    getTypeForElement(element) {
      return element.getAttribute('focus-type') || '';
    }

    /** @return {boolean} Whether this row is currently active. */
    isActive() {
      return this.root.classList.contains(FocusRow.ACTIVE_CLASS);
    }

    /**
     * Enables/disables the tabIndex of the focusable elements in the FocusRow.
     * tabIndex can be set properly.
     * @param {boolean} active True if tab is allowed for this row.
     */
    makeActive(active) {
      if (active === this.isActive()) {
        return;
      }

      this.getElements().forEach(function(element) {
        element.tabIndex = active ? 0 : -1;
      });

      this.root.classList.toggle(FocusRow.ACTIVE_CLASS, active);
    }

    /**
     * @param {!Event} e
     * @private
     */
    onBlur_(e) {
      if (!this.boundary_.contains(/** @type {Element} */ (e.relatedTarget))) {
        return;
      }

      const currentTarget = /** @type {!HTMLElement} */ (e.currentTarget);
      if (this.getFocusableElements().indexOf(currentTarget) >= 0) {
        this.makeActive(false);
      }
    }

    /**
     * @param {!Event} e
     * @private
     */
    onFocus_(e) {
      if (this.delegate) {
        this.delegate.onFocus(this, e);
      }
    }

    /**
     * @param {!Event} e A mousedown event.
     * @private
     */
    onMousedown_(e) {
      // Only accept left mouse clicks.
      if (e.button) {
        return;
      }

      // Allow the element under the mouse cursor to be focusable.
      if (!e.currentTarget.disabled) {
        e.currentTarget.tabIndex = 0;
      }
    }

    /**
     * @param {!Event} e The keydown event.
     * @private
     */
    onKeydown_(e) {
      const elements = this.getFocusableElements();
      const currentElement = FocusRow.getFocusableElement(
          /** @type {!HTMLElement} */ (e.currentTarget));
      const elementIndex = elements.indexOf(currentElement);
      assert$1(elementIndex >= 0);

      if (this.delegate && this.delegate.onKeydown(this, e)) {
        return;
      }

      const isShiftTab = !e.altKey && !e.ctrlKey && !e.metaKey && e.shiftKey &&
          e.key === 'Tab';

      if (hasKeyModifiers(e) && !isShiftTab) {
        return;
      }

      let index = -1;
      let shouldStopPropagation = true;

      if (isShiftTab) {
        // This always moves back one element, even in RTL.
        index = elementIndex - 1;
        if (index < 0) {
          // Bubble up to focus on the previous element outside the row.
          return;
        }
      } else if (e.key === 'ArrowLeft') {
        index = elementIndex + (isRTL() ? 1 : -1);
      } else if (e.key === 'ArrowRight') {
        index = elementIndex + (isRTL() ? -1 : 1);
      } else if (e.key === 'Home') {
        index = 0;
      } else if (e.key === 'End') {
        index = elements.length - 1;
      } else {
        shouldStopPropagation = false;
      }

      const elementToFocus = elements[index];
      if (elementToFocus) {
        this.getEquivalentElement(elementToFocus).focus();
        e.preventDefault();
      }
      if (shouldStopPropagation) {
        e.stopPropagation();
      }
    }
  }

  /** @const {string} */
  FocusRow.ACTIVE_CLASS = 'focus-row-active';

// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// clang-format on

  /** @implements {FocusRowDelegate} */
  class FocusRowBehaviorDelegate {
    /**
     * @param {{lastFocused: Object,
     *          overrideCustomEquivalent: boolean,
     *          getCustomEquivalent: (Function|undefined)}} listItem
     */
    constructor(listItem) {
      /** @private */
      this.listItem_ = listItem;
    }

    /**
     * This function gets called when the [focus-row-control] element receives
     * the focus event.
     * @override
     * @param {!FocusRow} row
     * @param {!Event} e
     */
    onFocus(row, e) {
      const element = /** @type {!HTMLElement} */ (e.composedPath()[0]);
      const focusableElement = FocusRow.getFocusableElement(element);
      if (element !== focusableElement) {
        focusableElement.focus();
      }
      this.listItem_.lastFocused = focusableElement;
    }

    /**
     * @override
     * @param {!FocusRow} row The row that detected a keydown.
     * @param {!Event} e
     * @return {boolean} Whether the event was handled.
     */
    onKeydown(row, e) {
      // Prevent iron-list from changing the focus on enter.
      if (e.key === 'Enter') {
        e.stopPropagation();
      }

      return false;
    }

    /** @override */
    getCustomEquivalent(sampleElement) {
      return this.listItem_.overrideCustomEquivalent ?
          this.listItem_.getCustomEquivalent(sampleElement) :
          null;
    }
  }

  /** @extends {FocusRow} */
  class VirtualFocusRow extends FocusRow {
    /**
     * @param {!Element} root
     * @param {FocusRowDelegate} delegate
     */
    constructor(root, delegate) {
      super(root, /* boundary */ null, delegate);
    }

    /** @override */
    getCustomEquivalent(sampleElement) {
      return this.delegate.getCustomEquivalent(sampleElement) ||
          super.getCustomEquivalent(sampleElement);
    }
  }

  /**
   * Any element that is being used as an iron-list row item can extend this
   * behavior, which encapsulates focus controls of mouse and keyboards.
   * To use this behavior:
   *    - The parent element should pass a "last-focused" attribute double-bound
   *      to the row items, to track the last-focused element across rows, and
   *      a "list-blurred" attribute double-bound to the row items, to track
   *      whether the list of row items has been blurred.
   *    - There must be a container in the extending element with the
   *      [focus-row-container] attribute that contains all focusable controls.
   *    - On each of the focusable controls, there must be a [focus-row-control]
   *      attribute, and a [focus-type=] attribute unique for each control.
   *
   * @polymerBehavior
   */
  const FocusRowBehavior = {
    properties: {
      /** @private {VirtualFocusRow} */
      row_: Object,

      /** @private {boolean} */
      mouseFocused_: Boolean,

      /** Will be updated when |index| is set, unless specified elsewhere. */
      id: {
        type: String,
        reflectToAttribute: true,
      },

      /** For notifying when the row is in focus. */
      isFocused: {
        type: Boolean,
        notify: true,
      },

      /** Should be bound to the index of the item from the iron-list */
      focusRowIndex: {
        type: Number,
        observer: 'focusRowIndexChanged',
      },

      /** @type {HTMLElement} */
      lastFocused: {
        type: Object,
        notify: true,
      },

      /**
       * This is different from tabIndex, since the template only does a one-way
       * binding on both attributes, and the behavior actually make use of this
       * fact. For example, when a control within a row is focused, it will have
       * tabIndex = -1 and ironListTabIndex = 0.
       * @type {number}
       */
      ironListTabIndex: {
        type: Number,
        observer: 'ironListTabIndexChanged_',
      },

      listBlurred: {
        type: Boolean,
        notify: true,
      },
    },

    /**
     * Returns an ID based on the index that was passed in.
     * @param {?number} index
     * @return {?string}
     */
    computeId_(index) {
      return index !== undefined ? `frb${index}` : undefined;
    },

    /**
     * Sets |id| if it hasn't been set elsewhere. Also sets |aria-rowindex|.
     * @param {number} newIndex
     * @param {number} oldIndex
     */
    focusRowIndexChanged(newIndex, oldIndex) {
      // focusRowIndex is 0-based where aria-rowindex is 1-based.
      this.setAttribute('aria-rowindex', newIndex + 1);

      // Only set ID if it matches what was previously set. This prevents
      // overriding the ID value if it's set elsewhere.
      if (this.id === this.computeId_(oldIndex)) {
        this.id = this.computeId_(newIndex);
      }
    },

    /** @private {?Element} */
    firstControl_: null,

    /** @private {!Array<!MutationObserver>} */
    controlObservers_: [],

    /** @override */
    attached() {
      this.classList.add('no-outline');

      afterNextRender(this, function() {
        const rowContainer = this.root.querySelector('[focus-row-container]');
        assert$1(rowContainer);
        this.row_ = new VirtualFocusRow(
            rowContainer, new FocusRowBehaviorDelegate(this));
        this.addItems_();

        // Adding listeners asynchronously to reduce blocking time, since this
        // behavior will be used by items in potentially long lists.
        this.listen(this, 'focus', 'onFocus_');
        this.listen(this, 'dom-change', 'addItems_');
        this.listen(this, 'mousedown', 'onMouseDown_');
        this.listen(this, 'blur', 'onBlur_');
      });
    },

    /** @override */
    detached() {
      this.unlisten(this, 'focus', 'onFocus_');
      this.unlisten(this, 'dom-change', 'addItems_');
      this.unlisten(this, 'mousedown', 'onMouseDown_');
      this.unlisten(this, 'blur', 'onBlur_');
      this.removeObservers_();
      if (this.firstControl_) {
        this.unlisten(this.firstControl_, 'keydown', 'onFirstControlKeydown_');
      }
      if (this.row_) {
        this.row_.destroy();
      }
    },

    /** @return {!FocusRow} */
    getFocusRow() {
      return assert$1(this.row_);
    },

    /** @private */
    updateFirstControl_() {
      const newFirstControl = this.row_.getFirstFocusable();
      if (newFirstControl === this.firstControl_) {
        return;
      }

      if (this.firstControl_) {
        this.unlisten(this.firstControl_, 'keydown', 'onFirstControlKeydown_');
      }
      this.firstControl_ = newFirstControl;
      if (this.firstControl_) {
        this.listen(
            /** @type {!Element} */ (this.firstControl_), 'keydown',
            'onFirstControlKeydown_');
      }
    },

    /** @private */
    removeObservers_() {
      if (this.controlObservers_.length > 0) {
        this.controlObservers_.forEach(observer => {
          observer.disconnect();
        });
      }
      this.controlObservers_ = [];
    },

    /** @private */
    addItems_() {
      this.ironListTabIndexChanged_();
      if (this.row_) {
        this.removeObservers_();
        this.row_.destroy();

        const controls = this.root.querySelectorAll('[focus-row-control]');

        controls.forEach(control => {
          this.row_.addItem(
              control.getAttribute('focus-type'),
              /** @type {!HTMLElement} */
              (FocusRow.getFocusableElement(control)));
          this.addMutationObservers_(assert$1(control));
        });
        this.updateFirstControl_();
      }
    },

    /**
     * @return {!MutationObserver}
     * @private
     */
    createObserver_() {
      return new MutationObserver(mutations => {
        const mutation = mutations[0];
        if (mutation.attributeName === 'style' && mutation.oldValue) {
          const newStyle = window.getComputedStyle(
              /** @type {!Element} */ (mutation.target));
          const oldDisplayValue = mutation.oldValue.match(/^display:(.*)(?=;)/);
          const oldVisibilityValue =
              mutation.oldValue.match(/^visibility:(.*)(?=;)/);
          // Return early if display and visibility have not changed.
          if (oldDisplayValue &&
              newStyle.display === oldDisplayValue[1].trim() &&
              oldVisibilityValue &&
              newStyle.visibility === oldVisibilityValue[1].trim()) {
            return;
          }
        }
        this.updateFirstControl_();
      });
    },

    /**
     * The first focusable control changes if hidden, disabled, or style.display
     * changes for the control or any of its ancestors. Add mutation observers
     * to watch for these changes in order to ensure the first control keydown
     * listener is always on the correct element.
     * @param {!Element} control
     * @private
     */
    addMutationObservers_(control) {
      let current = control;
      while (current && current !== this.root) {
        const currentObserver = this.createObserver_();
        currentObserver.observe(current, {
          attributes: true,
          attributeFilter: ['hidden', 'disabled', 'style'],
          attributeOldValue: true,
        });
        this.controlObservers_.push(currentObserver);
        current = current.parentNode;
      }
    },

    /**
     * This function gets called when the row itself receives the focus event.
     * @param {!Event} e The focus event
     * @private
     */
    onFocus_(e) {
      if (this.mouseFocused_) {
        this.mouseFocused_ = false;  // Consume and reset flag.
        return;
      }

      // If focus is being restored from outside the item and the event is fired
      // by the list item itself, focus the first control so that the user can
      // tab through all the controls. When the user shift-tabs back to the row,
      // or focus is restored to the row from a dropdown on the last item, the
      // last child item will be focused before the row itself. Since this is
      // the desired behavior, do not shift focus to the first item in these
      // cases.
      const restoreFocusToFirst =
          this.listBlurred && e.composedPath()[0] === this;

      if (this.lastFocused && !restoreFocusToFirst) {
        focusWithoutInk(this.row_.getEquivalentElement(this.lastFocused));
      } else {
        const firstFocusable = assert$1(this.firstControl_);
        focusWithoutInk(firstFocusable);
      }
      this.listBlurred = false;
      this.isFocused = true;
    },

    /** @param {!KeyboardEvent} e */
    onFirstControlKeydown_(e) {
      if (e.shiftKey && e.key === 'Tab') {
        this.focus();
      }
    },

    /** @private */
    ironListTabIndexChanged_() {
      if (this.row_) {
        this.row_.makeActive(this.ironListTabIndex === 0);
      }

      // If a new row is being focused, reset listBlurred. This means an item
      // has been removed and iron-list is about to focus the next item.
      if (this.ironListTabIndex === 0) {
        this.listBlurred = false;
      }
    },

    /** @private */
    onMouseDown_() {
      this.mouseFocused_ = true;  // Set flag to not do any control-focusing.
    },

    /**
     * @param {!Event} e
     * @private
     */
    onBlur_(e) {
      // Reset focused flags since it's not active anymore.
      this.mouseFocused_ = false;
      this.isFocused = false;

      const node =
          e.relatedTarget ? /** @type {!Node} */ (e.relatedTarget) : null;
      if (!this.parentNode.contains(node)) {
        this.listBlurred = true;
      }
    },
  };

function getTemplate$2e() {
  return html`<!--_html_template_start_--><style include="cr-shared-style internet-shared iron-flex">
  :host {
    display: inline-flex;
    outline: none;
    --network-list-item-disabled-opacity: 0.4;
  }

  #divOuter {
    height: var(--cr-network-row-height, 48px);
    overflow: auto;
    padding-inline-end: var(--cr-icon-ripple-padding);
  }

  :host([disabled_]) {
    cursor: auto;
    pointer-events: none;
  }

  :host([disabled_]) cr-policy-indicator,
  :host([disabled_]) #networkIconContainer,
  :host([disabled_]) #sublabel,
  :host([disabled_]) #divText,
  :host([is-e-sim-pending-profile_]) #divText,
  :host([is-e-sim-pending-profile_]) #divIcon,
  :host([is-p-sim-unactivated-network_]) #divText,
  :host([is-p-sim-unactivated-network_]) #networkIconContainer,
  :host([is-p-sim-activating-network_]) #divText,
  :host([is-p-sim-activating-network_]) #networkIconContainer,
  :host([is-blocked-network_]) #divText,
  :host([is-blocked-network_]) #networkIconContainer {
    opacity: var(--network-list-item-disabled-opacity);
  }

  :host(:not([is-e-sim-pending-profile_])
      :not([is-e-sim-installing-profile_])) #divIcon {
    height: 24px;
    width: 24px;
  }

  :host([is-e-sim-pending-profile_]) #divIcon,
  :host([is-e-sim-installing-profile_]) #divIcon {
    height: 20px;
    padding-inline-end: 20px;
    width: 20px;
  }

  #divDetail {
    display: flex;
    flex: 1 0 auto;
    flex-direction: row;
  }

  #divText {
    display: flex;
    flex: 1 0 auto;
    flex-direction: column;
    justify-content: center;
    margin-inline-start: 20px;
  }

  #sublabel {
    font-size: inherit;
  }

  #sublabel[active] {
    color: var(--cros-text-color-positive);
  }

  .warning {
    color: var(--cros-text-color-warning);
  }

  cr-policy-indicator {
    padding: 0 var(--cr-controlled-by-spacing);
  }

  #wrapper {
    height: 100%;
  }

  cr-button iron-icon {
    margin-inline-end: 8px;
  }

  :host(:not([disabled_])) cr-button iron-icon {
    --iron-icon-fill-color: var(--cros-tab-icon-color-active);
  }

  :host([disabled_]) cr-button iron-icon {
    --iron-icon-fill-color: var(--cros-icon-color-disabled);
  }

  paper-spinner-lite {
    height: 20px;
    margin-inline-end: 16px;
    width: 20px;
  }

  .separator {
    margin: 0 0 0 32px;
  }
</style>
<div id="wrapper" focus-row-container
      class="layout horizontal center flex">
  <div id="divOuter"
        class="layout horizontal center flex"
        actionable
        focus-row-control
        selectable
        aria-label$="[[rowLabel]]"
        aria-live="[[getLiveStatus_(isFocused)]]"
        focus-type="rowWrapper"
        on-keydown="onKeydown_"
        on-click="onSelected_">
    <div id="networkIconContainer">
      <template is="dom-if" if="[[networkState]]">
        <network-icon is-list-item
            show-technology-badge="[[showTechnologyBadge]]"
            network-state="[[networkState]]">
        </network-icon>
      </template>
    </div>
    <template is="dom-if" if="[[item.polymerIcon]]">
      <iron-icon id="divIcon" icon="[[item.polymerIcon]]"></iron-icon>
    </template>
    <div id="divText" class="layout horizontal flex">
      <div id="itemTitle" aria-hidden="true">
        [[itemTitle_]]
      </div>
      <div id="sublabel"
          class$="[[getSublabelClass_(networkState.*,
              isPSimUnavailableNetwork_, isESimUnactivatedProfile_)]]"
          hidden$="[[!isSublabelVisible_(networkState.*,
              isPSimUnavailableNetwork_, isUserLoggedIn_,
              isESimUnactivatedProfile_, isPSimPendingActivationNetwork_)]]"
          active$="[[isSublabelActive_(networkState.*,
              isUserLoggedIn_, isPSimPendingActivationNetwork_,
              activationUnavailable, isESimUnactivatedProfile_)]]">
        [[getSublabelText_(networkState.*, activationUnavailable,
            deviceState.*, isPSimUnavailableNetwork_,
            isPSimPendingActivationNetwork_, isUserLoggedIn_,
            isESimUnactivatedProfile_)]]
      </div>
    </div>
    <template is="dom-if" if="[[shouldShowPolicyIcon_(
        isBuiltInVpnManagementBlocked, networkState.source)]]">
      <cr-policy-indicator id="policyIcon" indicator-type="[[getPolicyIcon_(
          isBuiltInVpnManagementBlocked, networkState.source)]]">
      </cr-policy-indicator>
    </template>
    <template is="dom-if"
        if="[[shouldShowActivateButton_(isPSimPendingActivationNetwork_,
          showButtons, isUserLoggedIn_)]]" restamp>
      <cr-button id="activateButton"
          aria-label$="[[getActivateBtnA11yLabel_(item)]]"
          on-click="onActivateButtonClick_"
          disabled="[[disabled_]]">
        [[i18n('networkListItemActivate')]]
      </cr-button>
      <div class="separator"></div>
    </template>
    <template is="dom-if" if="[[isPSimActivatingNetwork_]]" restamp>
      <paper-spinner-lite id="activatingPSimSpinner" active>
      </paper-spinner-lite>
      [[i18n('networkListItemActivating')]]
      <div class="separator" hidden$="[[!showButtons]]"></div>
    </template>
    <template is="dom-if"
        if="[[isSubpageButtonVisible_(networkState, showButtons, disabled_,
          networkState.typeState.cellular.simLocked,
          isPSimPendingActivationNetwork_, isPSimActivatingNetwork_,
          isBuiltInVpnManagementBlocked)]]" restamp>
      <div>
        <cr-icon-button class="subpage-arrow"
            disabled="[[disabled_]]"
            id="subpageButton"
            on-click="onSubpageArrowClick_"
            tabindex$="[[tabindex]]"
            aria-label$="[[buttonLabel]]"
            focus-row-control
            focus-type="subpageButton">
        </cr-icon-button>
      </div>
    </template>
    <template is="dom-if" if="[[shouldShowUnlockButton_(networkState,
      networkState.typeState.cellular.simLocked, showButtons)]]" restamp>
      <cr-button id="unlockButton"
          aria-label$="[[getUnlockBtnA11yLabel_(item)]]"
          on-click="onUnlockButtonClick_"
          disabled="[[disabled_]]">
          [[i18n('networkListItemUnlock')]]
      </cr-button>
    </template>
    <template is="dom-if" if="[[shouldShowInstallButton_(
        isESimPendingProfile_, showButtons)]]" restamp>
      <cr-button id="installButton"
          aria-label$="[[getInstallBtnA11yLabel_(item)]]"
          on-click="onInstallButtonClick_"
          disabled="[[disabled_]]">
        <iron-icon icon="network:download"></iron-icon>
        [[i18n('networkListItemDownload')]]
      </cr-button>
    </template>
    <template is="dom-if" if="[[isESimInstallingProfile_]]" restamp>
      <paper-spinner-lite id="installingESimSpinner" active>
      </paper-spinner-lite>
      [[i18n('networkListItemAddingProfile')]]
    </template>
  </div>
</div>
<template is="dom-if" if="[[isCellularUnlockDialogOpen_]]" restamp>
  <sim-lock-dialogs
      global-policy="[[globalPolicy]]"
      is-dialog-open="{{isCellularUnlockDialogOpen_}}"
      device-state="[[deviceState]]">
  </sim-lock-dialogs>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.


const NetworkList = {};

/** @enum {number} */
NetworkList.CustomItemType = {
  OOBE: 1,
  ESIM_PENDING_PROFILE: 2,
  ESIM_INSTALLING_PROFILE: 3,
};

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.


/**
 * @constructor
 * @extends {PolymerElement}
 * @implements {CrPolicyNetworkBehaviorMojoInterface}
 * @implements {I18nBehaviorInterface}
 * @implements {FocusRowBehaviorInterface}
 */
const NetworkListItemElementBase = mixinBehaviors(
    [
      CrPolicyNetworkBehaviorMojo,
      I18nBehavior,
      FocusRowBehavior,
    ],
    PolymerElement);

/** @polymer */
class NetworkListItemElement extends NetworkListItemElementBase {
  static get is() {
    return 'network-list-item';
  }

  static get template() {
    return getTemplate$2e();
  }

  static get properties() {
    return {
      /**
       * Dims the UI, disables click and keyboard event handlers.
       * @private
       */
      disabled_: {
        type: Boolean,
        reflectToAttribute: true,
        observer: 'disabledChanged_',
        computed: 'computeDisabled_(deviceState, deviceState.inhibitReason,' +
            'disableItem, isUserLoggedIn_, isPSimPendingActivationNetwork_,' +
            'isBuiltInVpnManagementBlocked, networkState,' +
            'networkState.typeState.vpn, networkState.typeState.vpn.type)',
      },

      /**
       * Set by network-list to force disable this network item.
       * @type {boolean}
       */
      disableItem: Boolean,

      isBuiltInVpnManagementBlocked: {
        type: Boolean,
        value: false,
      },

      /** @type {!NetworkList.NetworkListItemType|undefined} */
      item: {
        type: Object,
        observer: 'itemChanged_',
      },

      /**
       * The ONC data properties used to display the list item.
       * @type {!OncMojo.NetworkStateProperties|undefined}
       */
      networkState: {
        type: Object,
        observer: 'networkStateChanged_',
      },

      /** Whether to show any buttons for network items. Defaults to false. */
      showButtons: {
        type: Boolean,
        reflectToAttribute: true,
      },

      /**
       * Reflect the element's tabindex attribute to a property so that embedded
       * elements (e.g. the show subpage button) can become keyboard focusable
       * when this element has keyboard focus.
       */
      tabindex: {
        type: Number,
        value: -1,
      },

      /**
       * Expose the itemName so it can be used as a label for a11y.  It will be
       * added as an attribute on this top-level network-list-item, and can
       * be used by any sub-element which applies it.
       */
      rowLabel: {
        type: String,
        notify: true,
        computed:
            'getRowLabel_(item, networkState, subtitle_, isPSimPendingActivationNetwork_)',
      },

      buttonLabel: {
        type: String,
        computed: 'getBut