import { html, Polymer, Base, dom, dedupingMixin, PolymerElement, afterNextRender, templatize, useShadow, Debouncer, microTask, mixinBehaviors, dashToCamelCase, FlattenedNodesObserver, DomIf, Templatizer, OptionalMutableDataBehavior, animationFrame, idlePeriod, flush, enqueueDebouncer, matches as matches$1, translate, beforeNextRender, gestures } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { mojo } from 'chrome://resources/mojo/mojo/public/js/bindings.js';
import { sendWithPromise as sendWithPromise$1, addWebUiListener, removeWebUiListener } from 'chrome://resources/js/cr.js';
import { loadTimeData } from 'chrome://resources/js/load_time_data.js';
import { ActivationStateType, InhibitReason, SecurityType, VpnType, ProxyMode, AuthenticationType, MatchType, HiddenSsidMode, SubjectAltName_Type, FilterType, NO_LIMIT, ApnType, ApnState, ApnAuthenticationType, ApnIpType, ApnSource, CrosNetworkConfigObserverReceiver, MAX_NUM_CUSTOM_APNS } from 'chrome://resources/mojo/chromeos/services/network_config/public/mojom/cros_network_config.mojom-webui.js';
import { PortalState, ConnectionStateType, DeviceStateType, NetworkType, OncSource, PolicySource, IPConfigType } from 'chrome://resources/mojo/chromeos/services/network_config/public/mojom/network_types.mojom-webui.js';
import { MojoInterfaceProviderImpl } from 'chrome://resources/ash/common/network/mojo_interface_provider.js';
import { HotspotState } from 'chrome://resources/ash/common/hotspot/cros_hotspot_config.mojom-webui.js';
import { loadTimeData as loadTimeData$1 } from 'chrome://resources/ash/common/load_time_data.m.js';
import { getESimManagerRemote, observeESimManager } from 'chrome://resources/ash/common/cellular_setup/mojo_interface_provider.js';
import { ContactManager, DownloadContactsObserverReceiver, Visibility, NearbyShareSettings, NearbyShareSettingsObserverReceiver, DeviceNameValidationResult, DataUsage, FastInitiationNotificationState } from 'chrome://resources/mojo/chromeos/ash/services/nearby/public/mojom/nearby_share_settings.mojom-webui.js';
import { isServer, property, state, query, LitElement, html as html$1, classMap, css, customElement, nothing } from 'chrome://resources/mwc/lit/index.js';
import { ShareTargetType, ShareTargetTypeSpec } from 'chrome://resources/mojo/chromeos/ash/services/nearby/public/mojom/nearby_share_target_types.mojom-webui.js';
import { TriState, AppTypeSpec, PermissionTypeSpec, PermissionSpec, PermissionType, AppType, PageCallbackRouter as PageCallbackRouter$4, PageHandlerRemote as PageHandlerRemote$5, PageHandlerFactory as PageHandlerFactory$4, WindowMode, InstallReason } from 'chrome://resources/cr_components/app_management/app_management.mojom-webui.js';
import { DeviceType, DeviceConnectionState, BluetoothSystemState } from 'chrome://resources/mojo/chromeos/ash/services/bluetooth_config/public/mojom/cros_bluetooth_config.mojom-webui.js';
import { getHidPreservingController } from 'chrome://resources/ash/common/bluetooth/hid_preserving_bluetooth_state_controller.js';
import { String16Spec } from 'chrome://resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js';
import { TimeTicksSpec } from 'chrome://resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import { PinFactorEditor, ConfigureResult, AuthFactorConfig, RecoveryFactorEditor } from 'chrome://resources/mojo/chromeos/ash/services/auth_factor_config/public/mojom/auth_factor_config.mojom-webui.js';
import { ProfileState } from 'chrome://resources/mojo/chromeos/ash/services/cellular_setup/public/mojom/esim_manager.mojom-webui.js';

const sheet$2 = new CSSStyleSheet();
sheet$2.replaceSync(`html{--google-blue-50-rgb:232,240,254;--google-blue-50:rgb(var(--google-blue-50-rgb));--google-blue-100-rgb:210,227,252;--google-blue-100:rgb(var(--google-blue-100-rgb));--google-blue-200-rgb:174,203,250;--google-blue-200:rgb(var(--google-blue-200-rgb));--google-blue-300-rgb:138,180,248;--google-blue-300:rgb(var(--google-blue-300-rgb));--google-blue-400-rgb:102,157,246;--google-blue-400:rgb(var(--google-blue-400-rgb));--google-blue-500-rgb:66,133,244;--google-blue-500:rgb(var(--google-blue-500-rgb));--google-blue-600-rgb:26,115,232;--google-blue-600:rgb(var(--google-blue-600-rgb));--google-blue-700-rgb:25,103,210;--google-blue-700:rgb(var(--google-blue-700-rgb));--google-blue-800-rgb:24,90,188;--google-blue-800:rgb(var(--google-blue-800-rgb));--google-blue-900-rgb:23,78,166;--google-blue-900:rgb(var(--google-blue-900-rgb));--google-green-50-rgb:230,244,234;--google-green-50:rgb(var(--google-green-50-rgb));--google-green-200-rgb:168,218,181;--google-green-200:rgb(var(--google-green-200-rgb));--google-green-300-rgb:129,201,149;--google-green-300:rgb(var(--google-green-300-rgb));--google-green-400-rgb:91,185,116;--google-green-400:rgb(var(--google-green-400-rgb));--google-green-500-rgb:52,168,83;--google-green-500:rgb(var(--google-green-500-rgb));--google-green-600-rgb:30,142,62;--google-green-600:rgb(var(--google-green-600-rgb));--google-green-700-rgb:24,128,56;--google-green-700:rgb(var(--google-green-700-rgb));--google-green-800-rgb:19,115,51;--google-green-800:rgb(var(--google-green-800-rgb));--google-green-900-rgb:13,101,45;--google-green-900:rgb(var(--google-green-900-rgb));--google-grey-50-rgb:248,249,250;--google-grey-50:rgb(var(--google-grey-50-rgb));--google-grey-100-rgb:241,243,244;--google-grey-100:rgb(var(--google-grey-100-rgb));--google-grey-200-rgb:232,234,237;--google-grey-200:rgb(var(--google-grey-200-rgb));--google-grey-300-rgb:218,220,224;--google-grey-300:rgb(var(--google-grey-300-rgb));--google-grey-400-rgb:189,193,198;--google-grey-400:rgb(var(--google-grey-400-rgb));--google-grey-500-rgb:154,160,166;--google-grey-500:rgb(var(--google-grey-500-rgb));--google-grey-600-rgb:128,134,139;--google-grey-600:rgb(var(--google-grey-600-rgb));--google-grey-700-rgb:95,99,104;--google-grey-700:rgb(var(--google-grey-700-rgb));--google-grey-800-rgb:60,64,67;--google-grey-800:rgb(var(--google-grey-800-rgb));--google-grey-900-rgb:32,33,36;--google-grey-900:rgb(var(--google-grey-900-rgb));--google-grey-900-white-4-percent:#292a2d;--google-purple-200-rgb:215,174,251;--google-purple-200:rgb(var(--google-purple-200-rgb));--google-purple-900-rgb:104,29,168;--google-purple-900:rgb(var(--google-purple-900-rgb));--google-red-300-rgb:242,139,130;--google-red-300:rgb(var(--google-red-300-rgb));--google-red-500-rgb:234,67,53;--google-red-500:rgb(var(--google-red-500-rgb));--google-red-600-rgb:217,48,37;--google-red-600:rgb(var(--google-red-600-rgb));--google-yellow-50-rgb:254,247,224;--google-yellow-50:rgb(var(--google-yellow-50-rgb));--google-yellow-100-rgb:254,239,195;--google-yellow-100:rgb(var(--google-yellow-100-rgb));--google-yellow-200-rgb:253,226,147;--google-yellow-200:rgb(var(--google-yellow-200-rgb));--google-yellow-300-rgb:253,214,51;--google-yellow-300:rgb(var(--google-yellow-300-rgb));--google-yellow-400-rgb:252,201,52;--google-yellow-400:rgb(var(--google-yellow-400-rgb));--google-yellow-500-rgb:251,188,4;--google-yellow-500:rgb(var(--google-yellow-500-rgb));--cr-primary-text-color:var(--google-grey-900);--cr-secondary-text-color:var(--google-grey-700);--cr-card-background-color:white;--cr-shadow-color:var(--google-grey-800);--cr-shadow-key-color_:color-mix(in srgb,var(--cr-shadow-color) 30%,transparent);--cr-shadow-ambient-color_:color-mix(in srgb,var(--cr-shadow-color) 15%,transparent);--cr-elevation-1:var(--cr-shadow-key-color_) 0 1px 2px 0,var(--cr-shadow-ambient-color_) 0 1px 3px 1px;--cr-elevation-2:var(--cr-shadow-key-color_) 0 1px 2px 0,var(--cr-shadow-ambient-color_) 0 2px 6px 2px;--cr-elevation-3:var(--cr-shadow-key-color_) 0 1px 3px 0,var(--cr-shadow-ambient-color_) 0 4px 8px 3px;--cr-elevation-4:var(--cr-shadow-key-color_) 0 2px 3px 0,var(--cr-shadow-ambient-color_) 0 6px 10px 4px;--cr-elevation-5:var(--cr-shadow-key-color_) 0 4px 4px 0,var(--cr-shadow-ambient-color_) 0 8px 12px 6px;--cr-card-shadow:var(--cr-elevation-2);--cr-checked-color:var(--google-blue-600);--cr-focused-item-color:var(--google-grey-300);--cr-form-field-label-color:var(--google-grey-700);--cr-hairline-rgb:0,0,0;--cr-iph-anchor-highlight-color:rgba(var(--google-blue-600-rgb),0.1);--cr-link-color:var(--google-blue-700);--cr-menu-background-color:white;--cr-menu-background-focus-color:var(--google-grey-400);--cr-menu-shadow:0 2px 6px var(--paper-grey-500);--cr-separator-color:rgba(0,0,0,.06);--cr-title-text-color:rgb(90,90,90);--cr-toolbar-background-color:white;--cr-hover-background-color:rgba(var(--google-grey-900-rgb),.1);--cr-active-background-color:rgba(var(--google-grey-900-rgb),.16);--cr-focus-outline-color:rgba(var(--google-blue-600-rgb),.4);--paper-grey-500:#9e9e9e}@media (prefers-color-scheme:dark){html{--cr-primary-text-color:var(--google-grey-200);--cr-secondary-text-color:var(--google-grey-500);--cr-card-background-color:var(--google-grey-900-white-4-percent);--cr-card-shadow-color-rgb:0,0,0;--cr-checked-color:var(--google-blue-300);--cr-focused-item-color:var(--google-grey-800);--cr-form-field-label-color:var(--dark-secondary-color);--cr-hairline-rgb:255,255,255;--cr-iph-anchor-highlight-color:rgba(var(--google-grey-100-rgb),0.1);--cr-link-color:var(--google-blue-300);--cr-menu-background-color:var(--google-grey-900);--cr-menu-background-focus-color:var(--google-grey-700);--cr-menu-background-sheen:rgba(255,255,255,.06);--cr-menu-shadow:rgba(0,0,0,.3) 0 1px 2px 0,rgba(0,0,0,.15) 0 3px 6px 2px;--cr-separator-color:rgba(255,255,255,.1);--cr-title-text-color:var(--cr-primary-text-color);--cr-toolbar-background-color:var(--google-grey-900-white-4-percent);--cr-hover-background-color:rgba(255,255,255,.1);--cr-active-background-color:rgba(var(--google-grey-200-rgb),.16);--cr-focus-outline-color:rgba(var(--google-blue-300-rgb),.4)}}@media (forced-colors:active){html{--cr-focus-outline-hcm:2px solid transparent;--cr-border-hcm:2px solid transparent}}html{--cr-button-edge-spacing:12px;--cr-button-height:32px;--cr-controlled-by-spacing:24px;--cr-default-input-max-width:264px;--cr-icon-ripple-size:36px;--cr-icon-ripple-padding:8px;--cr-icon-size:20px;--cr-icon-button-margin-start:16px;--cr-icon-ripple-margin:calc(var(--cr-icon-ripple-padding) * -1);--cr-section-min-height:48px;--cr-section-two-line-min-height:64px;--cr-section-padding:20px;--cr-section-vertical-padding:12px;--cr-section-indent-width:40px;--cr-section-indent-padding:calc(var(--cr-section-padding) + var(--cr-section-indent-width));--cr-section-vertical-margin:21px;--cr-centered-card-max-width:680px;--cr-centered-card-width-percentage:0.96;--cr-hairline:1px solid rgba(var(--cr-hairline-rgb),.14);--cr-separator-height:1px;--cr-separator-line:var(--cr-separator-height) solid var(--cr-separator-color);--cr-toolbar-overlay-animation-duration:150ms;--cr-toolbar-height:56px;--cr-container-shadow-height:6px;--cr-container-shadow-margin:calc(-1 * var(--cr-container-shadow-height));--cr-container-shadow-max-opacity:1;--cr-card-border-radius:8px;--cr-disabled-opacity:.38;--cr-form-field-bottom-spacing:16px;--cr-form-field-label-font-size:.625rem;--cr-form-field-label-height:1em;--cr-form-field-label-line-height:1}html[chrome-refresh-2023]{--cr-fallback-color-outline:rgb(116,119,117);--cr-fallback-color-primary:rgb(11,87,208);--cr-fallback-color-on-primary:rgb(255,255,255);--cr-fallback-color-primary-container:rgb(211,227,253);--cr-fallback-color-on-primary-container:rgb(4,30,73);--cr-fallback-color-secondary-container:rgb(194,231,255);--cr-fallback-color-on-secondary-container:rgb(0,29,53);--cr-fallback-color-neutral-container:rgb(242,242,242);--cr-fallback-color-neutral-outline:rgb(199,199,199);--cr-fallback-color-surface:rgb(255,255,255);--cr-fallback-color-on-surface-rgb:31,31,31;--cr-fallback-color-on-surface:rgb(var(--cr-fallback-color-on-surface-rgb));--cr-fallback-color-surface-variant:rgb(225,227,225);--cr-fallback-color-on-surface-variant:rgb(68,71,70);--cr-fallback-color-on-surface-subtle:rgb(71,71,71);--cr-fallback-color-inverse-primary:rgb(168,199,250);--cr-fallback-color-inverse-surface:rgb(48,48,48);--cr-fallback-color-inverse-on-surface:rgb(242,242,242);--cr-fallback-color-tonal-container:rgb(211,227,253);--cr-fallback-color-on-tonal-container:rgb(4,30,73);--cr-fallback-color-tonal-outline:rgb(168,199,250);--cr-fallback-color-error:rgb(179,38,30);--cr-fallback-color-divider:rgb(211,227,253);--cr-fallback-color-state-hover-on-prominent_:rgba(253,252,251,.1);--cr-fallback-color-state-on-subtle-rgb_:31,31,31;--cr-fallback-color-state-hover-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.06);--cr-fallback-color-state-ripple-neutral-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.08);--cr-fallback-color-state-ripple-primary-rgb_:124,172,248;--cr-fallback-color-state-ripple-primary_:rgba(var(--cr-fallback-color-state-ripple-primary-rgb_),0.32);--cr-fallback-color-base-container:rgba(105,145,214,.12);--cr-fallback-color-disabled-background:rgba(var(--cr-fallback-color-on-surface-rgb),.12);--cr-fallback-color-disabled-foreground:rgba(var(--cr-fallback-color-on-surface-rgb),var(--cr-disabled-opacity));--cr-hover-background-color:var(--color-sys-state-hover,rgba(var(--cr-fallback-color-on-surface-rgb),.08));--cr-hover-on-prominent-background-color:var(--color-sys-state-hover-on-prominent,var(--cr-fallback-color-state-hover-on-prominent_));--cr-hover-on-subtle-background-color:var(--color-sys-state-hover-on-subtle,var(--cr-fallback-color-state-hover-on-subtle_));--cr-active-background-color:var(--color-sys-state-pressed,rgba(var(--cr-fallback-color-on-surface-rgb),.12));--cr-active-on-primary-background-color:var(--color-sys-state-ripple-primary,var(--cr-fallback-color-state-ripple-primary_));--cr-active-neutral-on-subtle-background-color:var(--color-sys-state-ripple-neutral-on-subtle,var(--cr-fallback-color-state-ripple-neutral-on-subtle_));--cr-focus-outline-color:var(--color-sys-state-focus-ring,var(--cr-fallback-color-primary));--cr-primary-text-color:var(--color-primary-foreground,var(--cr-fallback-color-on-surface));--cr-secondary-text-color:var(--color-secondary-foreground,var(--cr-fallback-color-on-surface-variant));--cr-link-color:var(--color-link-foreground-default,var(--cr-fallback-color-primary));--cr-button-height:36px;--cr-shadow-color:var(--color-sys-shadow,rgb(0,0,0))}@media (prefers-color-scheme:dark){html[chrome-refresh-2023]{--cr-fallback-color-outline:rgb(142,145,143);--cr-fallback-color-primary:rgb(168,199,250);--cr-fallback-color-on-primary:rgb(6,46,111);--cr-fallback-color-primary-container:rgb(8,66,160);--cr-fallback-color-on-primary-container:rgb(211,227,253);--cr-fallback-color-secondary-container:rgb(0,74,119);--cr-fallback-color-on-secondary-container:rgb(194,231,255);--cr-fallback-color-neutral-container:rgb(42,42,42);--cr-fallback-color-neutral-outline:rgb(117,117,117);--cr-fallback-color-surface:rgb(26,27,30);--cr-fallback-color-on-surface-rgb:227,227,227;--cr-fallback-color-surface-variant:rgb(68,71,70);--cr-fallback-color-on-surface-variant:rgb(196,199,197);--cr-fallback-color-on-surface-subtle:rgb(199,199,199);--cr-fallback-color-inverse-primary:rgb(11,87,208);--cr-fallback-color-inverse-surface:rgb(227,227,227);--cr-fallback-color-inverse-on-surface:rgb(31,31,31);--cr-fallback-color-tonal-container:rgb(0,74,119);--cr-fallback-color-on-tonal-container:rgb(194,231,255);--cr-fallback-color-tonal-outline:rgb(0,99,155);--cr-fallback-color-error:rgb(242,184,181);--cr-fallback-color-divider:rgb(71,71,71);--cr-fallback-color-state-hover-on-prominent_:rgba(31,31,31,.06);--cr-fallback-color-state-on-subtle-rgb_:253,252,251;--cr-fallback-color-state-hover-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.10);--cr-fallback-color-state-ripple-neutral-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.16);--cr-fallback-color-state-ripple-primary-rgb_:76,141,246;--cr-fallback-color-base-container:rgba(40,40,40,1)}}@media (forced-colors:active){html[chrome-refresh-2023]{--cr-fallback-color-disabled-background:Canvas;--cr-fallback-color-disabled-foreground:GrayText}}`);
document.adoptedStyleSheets = [...document.adoptedStyleSheets, sheet$2];

const styleMod$e = document.createElement('dom-module');
styleMod$e.appendChild(html `
  <template>
    <style>
:host{align-items:center;align-self:stretch;display:flex;margin:0;outline:none}:host(:not([effectively-disabled_])){cursor:pointer}:host(:not([no-hover],[effectively-disabled_]):hover){background-color:var(--cr-hover-background-color)}:host(:not([no-hover],[effectively-disabled_]):active){background-color:var(--cr-active-background-color)}:host(:not([no-hover],[effectively-disabled_])) cr-icon-button{--cr-icon-button-hover-background-color:transparent;--cr-icon-button-active-background-color:transparent}
    </style>
  </template>
`.content);
styleMod$e.register('cr-actionable-row-style');

/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/

class IronMeta {
  /**
   * @param {{
   *   type: (string|null|undefined),
   *   key: (string|null|undefined),
   *   value: *,
   * }=} options
   */
  constructor(options) {
    IronMeta[' '](options);

    /** @type {string} */
    this.type = (options && options.type) || 'default';
    /** @type {string|null|undefined} */
    this.key = options && options.key;
    if (options && 'value' in options) {
      /** @type {*} */
      this.value = options.value;
    }
  }

  /** @return {*} */
  get value() {
    var type = this.type;
    var key = this.key;

    if (type && key) {
      return IronMeta.types[type] && IronMeta.types[type][key];
    }
  }

  /** @param {*} value */
  set value(value) {
    var type = this.type;
    var key = this.key;

    if (type && key) {
      type = IronMeta.types[type] = IronMeta.types[type] || {};
      if (value == null) {
        delete type[key];
      } else {
        type[key] = value;
      }
    }
  }

  /** @return {!Array<*>} */
  get list() {
    var type = this.type;

    if (type) {
      var items = IronMeta.types[this.type];
      if (!items) {
        return [];
      }

      return Object.keys(items).map(function(key) {
        return metaDatas[this.type][key];
      }, this);
    }
  }

  /**
   * @param {string} key
   * @return {*}
   */
  byKey(key) {
    this.key = key;
    return this.value;
  }
}
// This function is used to convince Closure not to remove constructor calls
// for instances that are not held anywhere. For example, when
// `new IronMeta({...})` is used only for the side effect of adding a value.
IronMeta[' '] = function() {};

IronMeta.types = {};

var metaDatas = IronMeta.types;

/**
`iron-meta` is a generic element you can use for sharing information across the
DOM tree. It uses [monostate pattern](http://c2.com/cgi/wiki?MonostatePattern)
such that any instance of iron-meta has access to the shared information. You
can use `iron-meta` to share whatever you want (or create an extension [like
x-meta] for enhancements).

The `iron-meta` instances containing your actual data can be loaded in an
import, or constructed in any way you see fit. The only requirement is that you
create them before you try to access them.

Examples:

If I create an instance like this:

    <iron-meta key="info" value="foo/bar"></iron-meta>

Note that value="foo/bar" is the metadata I've defined. I could define more
attributes or use child nodes to define additional metadata.

Now I can access that element (and it's metadata) from any iron-meta instance
via the byKey method, e.g.

    meta.byKey('info');

Pure imperative form would be like:

    document.createElement('iron-meta').byKey('info');

Or, in a Polymer element, you can include a meta in your template:

    <iron-meta id="meta"></iron-meta>
    ...
    this.$.meta.byKey('info');

@group Iron Elements
@demo demo/index.html
@element iron-meta
*/
Polymer({

  is: 'iron-meta',

  properties: {

    /**
     * The type of meta-data.  All meta-data of the same type is stored
     * together.
     * @type {string}
     */
    type: {
      type: String,
      value: 'default',
    },

    /**
     * The key used to store `value` under the `type` namespace.
     * @type {?string}
     */
    key: {
      type: String,
    },

    /**
     * The meta-data to store or retrieve.
     * @type {*}
     */
    value: {
      type: String,
      notify: true,
    },

    /**
     * If true, `value` is set to the iron-meta instance itself.
     */
    self: {type: Boolean, observer: '_selfChanged'},

    __meta: {type: Boolean, computed: '__computeMeta(type, key, value)'}
  },

  hostAttributes: {hidden: true},

  __computeMeta: function(type, key, value) {
    var meta = new IronMeta({type: type, key: key});

    if (value !== undefined && value !== meta.value) {
      meta.value = value;
    } else if (this.value !== meta.value) {
      this.value = meta.value;
    }

    return meta;
  },

  get list() {
    return this.__meta && this.__meta.list;
  },

  _selfChanged: function(self) {
    if (self) {
      this.value = this;
    }
  },

  /**
   * Retrieves meta data value by key.
   *
   * @method byKey
   * @param {string} key The key of the meta-data to be returned.
   * @return {*}
   */
  byKey: function(key) {
    return new IronMeta({type: this.type, key: key}).value;
  }
});

/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/

/**

The `iron-icon` element displays an icon. By default an icon renders as a 24px
square.

Example using src:

    <iron-icon src="star.png"></iron-icon>

Example setting size to 32px x 32px:

    <iron-icon class="big" src="big_star.png"></iron-icon>

    <style is="custom-style">
      .big {
        --iron-icon-height: 32px;
        --iron-icon-width: 32px;
      }
    </style>

The iron elements include several sets of icons. To use the default set of
icons, import `iron-icons.js` and use the `icon` attribute to specify an icon:

    <script type="module">
      import "../iron-icons/iron-icons.js";
    </script>

    <iron-icon icon="menu"></iron-icon>

To use a different built-in set of icons, import the specific
`iron-icons/<iconset>-icons.js`, and specify the icon as `<iconset>:<icon>`.
For example, to use a communication icon, you would use:

    <script type="module">
      import "../iron-icons/communication-icons.js";
    </script>

    <iron-icon icon="communication:email"></iron-icon>

You can also create custom icon sets of bitmap or SVG icons.

Example of using an icon named `cherry` from a custom iconset with the ID
`fruit`:

    <iron-icon icon="fruit:cherry"></iron-icon>

See `<iron-iconset>` and `<iron-iconset-svg>` for more information about how to
create a custom iconset.

See the `iron-icons` demo to see the icons available in the various iconsets.

### Styling

The following custom properties are available for styling:

Custom property | Description | Default
----------------|-------------|----------
`--iron-icon` | Mixin applied to the icon | {}
`--iron-icon-width` | Width of the icon | `24px`
`--iron-icon-height` | Height of the icon | `24px`
`--iron-icon-fill-color` | Fill color of the svg icon | `currentcolor`
`--iron-icon-stroke-color` | Stroke color of the svg icon | none

@group Iron Elements
@element iron-icon
@demo demo/index.html
@hero hero.svg
@homepage polymer.github.io
*/
Polymer({
  _template: html`
    <style>
      :host {
        align-items: center;
        display: inline-flex;
        justify-content: center;
        position: relative;

        vertical-align: middle;

        fill: var(--iron-icon-fill-color, currentcolor);
        stroke: var(--iron-icon-stroke-color, none);

        width: var(--iron-icon-width, 24px);
        height: var(--iron-icon-height, 24px);
      }

      :host([hidden]) {
        display: none;
      }
    </style>
`,

  is: 'iron-icon',

  properties: {

    /**
     * The name of the icon to use. The name should be of the form:
     * `iconset_name:icon_name`.
     */
    icon: {type: String},

    /**
     * The name of the theme to used, if one is specified by the
     * iconset.
     */
    theme: {type: String},

    /**
     * If using iron-icon without an iconset, you can set the src to be
     * the URL of an individual icon image file. Note that this will take
     * precedence over a given icon attribute.
     */
    src: {type: String},

    /**
     * @type {!IronMeta}
     */
    _meta: {value: Base.create('iron-meta', {type: 'iconset'})}

  },

  observers: [
    '_updateIcon(_meta, isAttached)',
    '_updateIcon(theme, isAttached)',
    '_srcChanged(src, isAttached)',
    '_iconChanged(icon, isAttached)'
  ],

  _DEFAULT_ICONSET: 'icons',

  _iconChanged: function(icon) {
    var parts = (icon || '').split(':');
    this._iconName = parts.pop();
    this._iconsetName = parts.pop() || this._DEFAULT_ICONSET;
    this._updateIcon();
  },

  _srcChanged: function(src) {
    this._updateIcon();
  },

  _usesIconset: function() {
    return this.icon || !this.src;
  },

  /** @suppress {visibility} */
  _updateIcon: function() {
    if (this._usesIconset()) {
      if (this._img && this._img.parentNode) {
        dom(this.root).removeChild(this._img);
      }
      if (this._iconName === '') {
        if (this._iconset) {
          this._iconset.removeIcon(this);
        }
      } else if (this._iconsetName && this._meta) {
        this._iconset = /** @type {?Polymer.Iconset} */ (
            this._meta.byKey(this._iconsetName));
        if (this._iconset) {
          this._iconset.applyIcon(this, this._iconName, this.theme);
          this.unlisten(window, 'iron-iconset-added', '_updateIcon');
        } else {
          this.listen(window, 'iron-iconset-added', '_updateIcon');
        }
      }
    } else {
      if (this._iconset) {
        this._iconset.removeIcon(this);
      }
      if (!this._img) {
        this._img = document.createElement('img');
        this._img.style.width = '100%';
        this._img.style.height = '100%';
        this._img.draggable = false;
      }
      this._img.src = this.src;
      dom(this.root).appendChild(this._img);
    }
  }
});

/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/

/**
 * Chrome uses an older version of DOM Level 3 Keyboard Events
 *
 * Most keys are labeled as text, but some are Unicode codepoints.
 * Values taken from:
 * http://www.w3.org/TR/2007/WD-DOM-Level-3-Events-20071221/keyset.html#KeySet-Set
 */
var KEY_IDENTIFIER = {
  'U+0008': 'backspace',
  'U+0009': 'tab',
  'U+001B': 'esc',
  'U+0020': 'space',
  'U+007F': 'del'
};

/**
 * Special table for KeyboardEvent.keyCode.
 * KeyboardEvent.keyIdentifier is better, and KeyBoardEvent.key is even better
 * than that.
 *
 * Values from:
 * https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent.keyCode#Value_of_keyCode
 */
var KEY_CODE = {
  8: 'backspace',
  9: 'tab',
  13: 'enter',
  27: 'esc',
  33: 'pageup',
  34: 'pagedown',
  35: 'end',
  36: 'home',
  32: 'space',
  37: 'left',
  38: 'up',
  39: 'right',
  40: 'down',
  46: 'del',
  106: '*'
};

/**
 * MODIFIER_KEYS maps the short name for modifier keys used in a key
 * combo string to the property name that references those same keys
 * in a KeyboardEvent instance.
 */
var MODIFIER_KEYS = {
  'shift': 'shiftKey',
  'ctrl': 'ctrlKey',
  'alt': 'altKey',
  'meta': 'metaKey'
};

/**
 * KeyboardEvent.key is mostly represented by printable character made by
 * the keyboard, with unprintable keys labeled nicely.
 *
 * However, on OS X, Alt+char can make a Unicode character that follows an
 * Apple-specific mapping. In this case, we fall back to .keyCode.
 */
var KEY_CHAR = /[a-z0-9*]/;

/**
 * Matches a keyIdentifier string.
 */
var IDENT_CHAR = /U\+/;

/**
 * Matches arrow keys in Gecko 27.0+
 */
var ARROW_KEY = /^arrow/;

/**
 * Matches space keys everywhere (notably including IE10's exceptional name
 * `spacebar`).
 */
var SPACE_KEY = /^space(bar)?/;

/**
 * Matches ESC key.
 *
 * Value from: http://w3c.github.io/uievents-key/#key-Escape
 */
var ESC_KEY = /^escape$/;

/**
 * Transforms the key.
 * @param {string} key The KeyBoardEvent.key
 * @param {Boolean} [noSpecialChars] Limits the transformation to
 * alpha-numeric characters.
 */
function transformKey(key, noSpecialChars) {
  var validKey = '';
  if (key) {
    var lKey = key.toLowerCase();
    if (lKey === ' ' || SPACE_KEY.test(lKey)) {
      validKey = 'space';
    } else if (ESC_KEY.test(lKey)) {
      validKey = 'esc';
    } else if (lKey.length == 1) {
      if (!noSpecialChars || KEY_CHAR.test(lKey)) {
        validKey = lKey;
      }
    } else if (ARROW_KEY.test(lKey)) {
      validKey = lKey.replace('arrow', '');
    } else if (lKey == 'multiply') {
      // numpad '*' can map to Multiply on IE/Windows
      validKey = '*';
    } else {
      validKey = lKey;
    }
  }
  return validKey;
}

function transformKeyIdentifier(keyIdent) {
  var validKey = '';
  if (keyIdent) {
    if (keyIdent in KEY_IDENTIFIER) {
      validKey = KEY_IDENTIFIER[keyIdent];
    } else if (IDENT_CHAR.test(keyIdent)) {
      keyIdent = parseInt(keyIdent.replace('U+', '0x'), 16);
      validKey = String.fromCharCode(keyIdent).toLowerCase();
    } else {
      validKey = keyIdent.toLowerCase();
    }
  }
  return validKey;
}

function transformKeyCode(keyCode) {
  var validKey = '';
  if (Number(keyCode)) {
    if (keyCode >= 65 && keyCode <= 90) {
      // ascii a-z
      // lowercase is 32 offset from uppercase
      validKey = String.fromCharCode(32 + keyCode);
    } else if (keyCode >= 112 && keyCode <= 123) {
      // function keys f1-f12
      validKey = 'f' + (keyCode - 112 + 1);
    } else if (keyCode >= 48 && keyCode <= 57) {
      // top 0-9 keys
      validKey = String(keyCode - 48);
    } else if (keyCode >= 96 && keyCode <= 105) {
      // num pad 0-9
      validKey = String(keyCode - 96);
    } else {
      validKey = KEY_CODE[keyCode];
    }
  }
  return validKey;
}

/**
 * Calculates the normalized key for a KeyboardEvent.
 * @param {KeyboardEvent} keyEvent
 * @param {Boolean} [noSpecialChars] Set to true to limit keyEvent.key
 * transformation to alpha-numeric chars. This is useful with key
 * combinations like shift + 2, which on FF for MacOS produces
 * keyEvent.key = @
 * To get 2 returned, set noSpecialChars = true
 * To get @ returned, set noSpecialChars = false
 */
function normalizedKeyForEvent(keyEvent, noSpecialChars) {
  // Fall back from .key, to .detail.key for artifical keyboard events,
  // and then to deprecated .keyIdentifier and .keyCode.
  if (keyEvent.key) {
    return transformKey(keyEvent.key, noSpecialChars);
  }
  if (keyEvent.detail && keyEvent.detail.key) {
    return transformKey(keyEvent.detail.key, noSpecialChars);
  }
  return transformKeyIdentifier(keyEvent.keyIdentifier) ||
      transformKeyCode(keyEvent.keyCode) || '';
}

function keyComboMatchesEvent(keyCombo, event) {
  // For combos with modifiers we support only alpha-numeric keys
  var keyEvent = normalizedKeyForEvent(event, keyCombo.hasModifiers);
  return keyEvent === keyCombo.key &&
      (!keyCombo.hasModifiers ||
       (!!event.shiftKey === !!keyCombo.shiftKey &&
        !!event.ctrlKey === !!keyCombo.ctrlKey &&
        !!event.altKey === !!keyCombo.altKey &&
        !!event.metaKey === !!keyCombo.metaKey));
}

function parseKeyComboString(keyComboString) {
  if (keyComboString.length === 1) {
    return {combo: keyComboString, key: keyComboString, event: 'keydown'};
  }
  return keyComboString.split('+')
      .reduce(function(parsedKeyCombo, keyComboPart) {
        var eventParts = keyComboPart.split(':');
        var keyName = eventParts[0];
        var event = eventParts[1];

        if (keyName in MODIFIER_KEYS) {
          parsedKeyCombo[MODIFIER_KEYS[keyName]] = true;
          parsedKeyCombo.hasModifiers = true;
        } else {
          parsedKeyCombo.key = keyName;
          parsedKeyCombo.event = event || 'keydown';
        }

        return parsedKeyCombo;
      }, {combo: keyComboString.split(':').shift()});
}

function parseEventString(eventString) {
  return eventString.trim().split(' ').map(function(keyComboString) {
    return parseKeyComboString(keyComboString);
  });
}

/**
 * `Polymer.IronA11yKeysBehavior` provides a normalized interface for processing
 * keyboard commands that pertain to [WAI-ARIA best
 * practices](http://www.w3.org/TR/wai-aria-practices/#kbd_general_binding). The
 * element takes care of browser differences with respect to Keyboard events and
 * uses an expressive syntax to filter key presses.
 *
 * Use the `keyBindings` prototype property to express what combination of keys
 * will trigger the callback. A key binding has the format
 * `"KEY+MODIFIER:EVENT": "callback"` (`"KEY": "callback"` or
 * `"KEY:EVENT": "callback"` are valid as well). Some examples:
 *
 *      keyBindings: {
 *        'space': '_onKeydown', // same as 'space:keydown'
 *        'shift+tab': '_onKeydown',
 *        'enter:keypress': '_onKeypress',
 *        'esc:keyup': '_onKeyup'
 *      }
 *
 * The callback will receive with an event containing the following information
 * in `event.detail`:
 *
 *      _onKeydown: function(event) {
 *        console.log(event.detail.combo); // KEY+MODIFIER, e.g. "shift+tab"
 *        console.log(event.detail.key); // KEY only, e.g. "tab"
 *        console.log(event.detail.event); // EVENT, e.g. "keydown"
 *        console.log(event.detail.keyboardEvent); // the original KeyboardEvent
 *      }
 *
 * Use the `keyEventTarget` attribute to set up event handlers on a specific
 * node.
 *
 * See the [demo source
 * code](https://github.com/PolymerElements/iron-a11y-keys-behavior/blob/master/demo/x-key-aware.html)
 * for an example.
 *
 * @demo demo/index.html
 * @polymerBehavior
 */
const IronA11yKeysBehavior = {
  properties: {
    /**
     * The EventTarget that will be firing relevant KeyboardEvents. Set it to
     * `null` to disable the listeners.
     * @type {?EventTarget}
     */
    keyEventTarget: {
      type: Object,
      value: function() {
        return this;
      }
    },

    /**
     * If true, this property will cause the implementing element to
     * automatically stop propagation on any handled KeyboardEvents.
     */
    stopKeyboardEventPropagation: {type: Boolean, value: false},

    _boundKeyHandlers: {
      type: Array,
      value: function() {
        return [];
      }
    },

    // We use this due to a limitation in IE10 where instances will have
    // own properties of everything on the "prototype".
    _imperativeKeyBindings: {
      type: Object,
      value: function() {
        return {};
      }
    }
  },

  observers: ['_resetKeyEventListeners(keyEventTarget, _boundKeyHandlers)'],


  /**
   * To be used to express what combination of keys  will trigger the relative
   * callback. e.g. `keyBindings: { 'esc': '_onEscPressed'}`
   * @type {!Object}
   */
  keyBindings: {},

  registered: function() {
    this._prepKeyBindings();
  },

  attached: function() {
    this._listenKeyEventListeners();
  },

  detached: function() {
    this._unlistenKeyEventListeners();
  },

  /**
   * Can be used to imperatively add a key binding to the implementing
   * element. This is the imperative equivalent of declaring a keybinding
   * in the `keyBindings` prototype property.
   *
   * @param {string} eventString
   * @param {string} handlerName
   */
  addOwnKeyBinding: function(eventString, handlerName) {
    this._imperativeKeyBindings[eventString] = handlerName;
    this._prepKeyBindings();
    this._resetKeyEventListeners();
  },

  /**
   * When called, will remove all imperatively-added key bindings.
   */
  removeOwnKeyBindings: function() {
    this._imperativeKeyBindings = {};
    this._prepKeyBindings();
    this._resetKeyEventListeners();
  },

  /**
   * Returns true if a keyboard event matches `eventString`.
   *
   * @param {KeyboardEvent} event
   * @param {string} eventString
   * @return {boolean}
   */
  keyboardEventMatchesKeys: function(event, eventString) {
    var keyCombos = parseEventString(eventString);
    for (var i = 0; i < keyCombos.length; ++i) {
      if (keyComboMatchesEvent(keyCombos[i], event)) {
        return true;
      }
    }
    return false;
  },

  _collectKeyBindings: function() {
    var keyBindings = this.behaviors.map(function(behavior) {
      return behavior.keyBindings;
    });

    if (keyBindings.indexOf(this.keyBindings) === -1) {
      keyBindings.push(this.keyBindings);
    }

    return keyBindings;
  },

  _prepKeyBindings: function() {
    this._keyBindings = {};

    this._collectKeyBindings().forEach(function(keyBindings) {
      for (var eventString in keyBindings) {
        this._addKeyBinding(eventString, keyBindings[eventString]);
      }
    }, this);

    for (var eventString in this._imperativeKeyBindings) {
      this._addKeyBinding(
          eventString, this._imperativeKeyBindings[eventString]);
    }

    // Give precedence to combos with modifiers to be checked first.
    for (var eventName in this._keyBindings) {
      this._keyBindings[eventName].sort(function(kb1, kb2) {
        var b1 = kb1[0].hasModifiers;
        var b2 = kb2[0].hasModifiers;
        return (b1 === b2) ? 0 : b1 ? -1 : 1;
      });
    }
  },

  _addKeyBinding: function(eventString, handlerName) {
    parseEventString(eventString).forEach(function(keyCombo) {
      this._keyBindings[keyCombo.event] =
          this._keyBindings[keyCombo.event] || [];

      this._keyBindings[keyCombo.event].push([keyCombo, handlerName]);
    }, this);
  },

  _resetKeyEventListeners: function() {
    this._unlistenKeyEventListeners();

    if (this.isAttached) {
      this._listenKeyEventListeners();
    }
  },

  _listenKeyEventListeners: function() {
    if (!this.keyEventTarget) {
      return;
    }
    Object.keys(this._keyBindings).forEach(function(eventName) {
      var keyBindings = this._keyBindings[eventName];
      var boundKeyHandler = this._onKeyBindingEvent.bind(this, keyBindings);

      this._boundKeyHandlers.push(
          [this.keyEventTarget, eventName, boundKeyHandler]);

      this.keyEventTarget.addEventListener(eventName, boundKeyHandler);
    }, this);
  },

  _unlistenKeyEventListeners: function() {
    var keyHandlerTuple;
    var keyEventTarget;
    var eventName;
    var boundKeyHandler;

    while (this._boundKeyHandlers.length) {
      // My kingdom for block-scope binding and destructuring assignment..
      keyHandlerTuple = this._boundKeyHandlers.pop();
      keyEventTarget = keyHandlerTuple[0];
      eventName = keyHandlerTuple[1];
      boundKeyHandler = keyHandlerTuple[2];

      keyEventTarget.removeEventListener(eventName, boundKeyHandler);
    }
  },

  _onKeyBindingEvent: function(keyBindings, event) {
    if (this.stopKeyboardEventPropagation) {
      event.stopPropagation();
    }

    // if event has been already prevented, don't do anything
    if (event.defaultPrevented) {
      return;
    }

    for (var i = 0; i < keyBindings.length; i++) {
      var keyCombo = keyBindings[i][0];
      var handlerName = keyBindings[i][1];
      if (keyComboMatchesEvent(keyCombo, event)) {
        this._triggerKeyHandler(keyCombo, handlerName, event);
        // exit the loop if eventDefault was prevented
        if (event.defaultPrevented) {
          return;
        }
      }
    }
  },

  _triggerKeyHandler: function(keyCombo, handlerName, keyboardEvent) {
    var detail = Object.create(keyCombo);
    detail.keyboardEvent = keyboardEvent;
    var event =
        new CustomEvent(keyCombo.event, {detail: detail, cancelable: true});
    this[handlerName].call(this, event);
    if (event.defaultPrevented) {
      keyboardEvent.preventDefault();
    }
  }
};

var MAX_RADIUS_PX = 300;
var MIN_DURATION_MS = 800;

/**
 * @param {number} x1
 * @param {number} y1
 * @param {number} x2
 * @param {number} y2
 * @return {number} The distance between (x1, y1) and (x2, y2).
 */
var distance = function(x1, y1, x2, y2) {
  var xDelta = x1 - x2;
  var yDelta = y1 - y2;
  return Math.sqrt(xDelta * xDelta + yDelta * yDelta);
};

Polymer({
  _template: html`
    <style>
      :host {
        bottom: 0;
        display: block;
        left: 0;
        overflow: hidden;
        pointer-events: none;
        position: absolute;
        right: 0;
        top: 0;
        /* For rounded corners: http://jsbin.com/temexa/4. */
        transform: translate3d(0, 0, 0);
      }

      .ripple {
        background-color: currentcolor;
        left: 0;
        opacity: var(--paper-ripple-opacity, 0.25);
        pointer-events: none;
        position: absolute;
        will-change: height, transform, width;
      }

      .ripple,
      :host(.circle) {
        border-radius: 50%;
      }
    </style>
`,

  is: 'paper-ripple',
  behaviors: [IronA11yKeysBehavior],

  properties: {
    center: {type: Boolean, value: false},
    holdDown: {type: Boolean, value: false, observer: '_holdDownChanged'},
    recenters: {type: Boolean, value: false},
    noink: {type: Boolean, value: false},
  },

  keyBindings: {
    'enter:keydown': '_onEnterKeydown',
    'space:keydown': '_onSpaceKeydown',
    'space:keyup': '_onSpaceKeyup',
  },

  /** @override */
  created: function() {
    /** @type {Array<!Element>} */
    this.ripples = [];
  },

  /** @override */
  attached: function() {
    this.keyEventTarget = this.parentNode.nodeType == 11 ?
        dom(this).getOwnerRoot().host : this.parentNode;
    this.keyEventTarget = /** @type {!EventTarget} */ (this.keyEventTarget);
    this.listen(this.keyEventTarget, 'up', 'uiUpAction');
    this.listen(this.keyEventTarget, 'down', 'uiDownAction');
  },

  /** @override */
  detached: function() {
    this.unlisten(this.keyEventTarget, 'up', 'uiUpAction');
    this.unlisten(this.keyEventTarget, 'down', 'uiDownAction');
    this.keyEventTarget = null;
  },

  simulatedRipple: function() {
    this.downAction();
    // Using a 1ms delay ensures a macro-task.
    this.async(function() { this.upAction(); }.bind(this), 1);
  },

  /** @param {Event=} e */
  uiDownAction: function(e) {
    if (!this.noink)
      this.downAction(e);
  },

  /** @param {Event=} e */
  downAction: function(e) {
    if (this.ripples.length && this.holdDown)
      return;
    // TODO(dbeam): some things (i.e. paper-icon-button-light) dynamically
    // create ripples on 'up', Ripples register an event listener on their
    // parent (or shadow DOM host) when attached().  This sometimes causes
    // duplicate events to fire on us.
    this.debounce('show ripple', function() { this.__showRipple(e); }, 1);
  },

  clear: function() {
    this.__hideRipple();
    this.holdDown = false;
  },

  showAndHoldDown: function() {
    this.ripples.forEach(ripple => {
      ripple.remove();
    });
    this.ripples = [];
    this.holdDown = true;
  },

  /**
   * @param {Event=} e
   * @private
   * @suppress {checkTypes}
   */
  __showRipple: function(e) {
    var rect = this.getBoundingClientRect();

    var roundedCenterX = function() { return Math.round(rect.width / 2); };
    var roundedCenterY = function() { return Math.round(rect.height / 2); };

    var centered = !e || this.center;
    if (centered) {
      var x = roundedCenterX();
      var y = roundedCenterY();
    } else {
      var sourceEvent = e.detail.sourceEvent;
      var x = Math.round(sourceEvent.clientX - rect.left);
      var y = Math.round(sourceEvent.clientY - rect.top);
    }

    var corners = [
      {x: 0, y: 0},
      {x: rect.width, y: 0},
      {x: 0, y: rect.height},
      {x: rect.width, y: rect.height},
    ];

    var cornerDistances = corners.map(function(corner) {
      return Math.round(distance(x, y, corner.x, corner.y));
    });

    var radius = Math.min(MAX_RADIUS_PX, Math.max.apply(Math, cornerDistances));

    var startTranslate = (x - radius) + 'px, ' + (y - radius) + 'px';
    if (this.recenters && !centered) {
      var endTranslate = (roundedCenterX() - radius) + 'px, ' +
                         (roundedCenterY() - radius) + 'px';
    } else {
      var endTranslate = startTranslate;
    }

    var ripple = document.createElement('div');
    ripple.classList.add('ripple');
    ripple.style.height = ripple.style.width = (2 * radius) + 'px';

    this.ripples.push(ripple);
    this.shadowRoot.appendChild(ripple);

    ripple.animate({
      // TODO(dbeam): scale to 90% of radius at .75 offset?
      transform: ['translate(' + startTranslate + ') scale(0)',
                  'translate(' + endTranslate + ') scale(1)'],
    }, {
      duration: Math.max(MIN_DURATION_MS, Math.log(radius) * radius) || 0,
      easing: 'cubic-bezier(.2, .9, .1, .9)',
      fill: 'forwards',
    });
  },

  /** @param {Event=} e */
  uiUpAction: function(e) {
    if (!this.noink)
      this.upAction();
  },

  /** @param {Event=} e */
  upAction: function(e) {
    if (!this.holdDown)
      this.debounce('hide ripple', function() { this.__hideRipple(); }, 1);
  },

  /**
   * @private
   * @suppress {checkTypes}
   */
  __hideRipple: function() {
    Promise.all(this.ripples.map(function(ripple) {
      return new Promise(function(resolve) {
        var removeRipple = function() {
          ripple.remove();
          resolve();
        };
        var opacity = getComputedStyle(ripple).opacity;
        if (!opacity.length) {
          removeRipple();
        } else {
          var animation = ripple.animate({
            opacity: [opacity, 0],
          }, {
            duration: 150,
            fill: 'forwards',
          });
          animation.addEventListener('finish', removeRipple);
          animation.addEventListener('cancel', removeRipple);
        }
      });
    })).then(function() { this.fire('transitionend'); }.bind(this));
    this.ripples = [];
  },

  /** @protected */
  _onEnterKeydown: function() {
    this.uiDownAction();
    this.async(this.uiUpAction, 1);
  },

  /** @protected */
  _onSpaceKeydown: function() {
    this.uiDownAction();
  },

  /** @protected */
  _onSpaceKeyup: function() {
    this.uiUpAction();
  },

  /** @protected */
  _holdDownChanged: function(newHoldDown, oldHoldDown) {
    if (oldHoldDown === undefined)
      return;
    if (newHoldDown)
      this.downAction();
    else
      this.upAction();
  },
});

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

/**
 * Note: This file is forked from Polymer's paper-ripple-behavior.js
 *
 * `PaperRippleMixin` dynamically implements a ripple when the element has
 * focus via pointer or keyboard.
 */

const PaperRippleMixin = dedupingMixin(superClass => {
  class PaperRippleMixin extends superClass {
    static get properties() {
      return {
        /**
         * If true, the element will not produce a ripple effect when interacted
         * with via the pointer.
         */
        noink: {type: Boolean, observer: '_noinkChanged'},

        /**
         * @type {Element|undefined}
         */
        _rippleContainer: Object,
      };
    }


    /**
     * Ensures this element contains a ripple effect. For startup efficiency
     * the ripple effect is dynamically on demand when needed.
     */
    ensureRipple() {
      if (this.hasRipple()) {
        return;
      }

      this._ripple = this._createRipple();
      this._ripple.noink = this.noink;
      var rippleContainer = this._rippleContainer || this.root;
      if (rippleContainer) {
        rippleContainer.appendChild(this._ripple);
      }
    }

    /**
     * Returns the `<paper-ripple>` element used by this element to create
     * ripple effects. The element's ripple is created on demand, when
     * necessary, and calling this method will force the
     * ripple to be created.
     */
    getRipple() {
      this.ensureRipple();
      return this._ripple;
    }

    /**
     * Returns true if this element currently contains a ripple effect.
     * @return {boolean}
     */
    hasRipple() {
      return Boolean(this._ripple);
    }

    /**
     * Create the element's ripple effect via creating a `<paper-ripple>`.
     * Override this method to customize the ripple element.
     * @return {!PaperRippleElement} Returns a `<paper-ripple>` element.
     */
    _createRipple() {
      var element = /** @type {!PaperRippleElement} */ (
          document.createElement('paper-ripple'));
      return element;
    }

    _noinkChanged(noink) {
      if (this.hasRipple()) {
        this._ripple.noink = noink;
      }
    }
  }

  return PaperRippleMixin;
});

function getTemplate$1N() {
    return html `<!--_html_template_start_--><style>:host{--cr-icon-button-fill-color:var(--google-grey-700);--cr-icon-button-icon-start-offset:0;--cr-icon-button-icon-size:20px;--cr-icon-button-size:36px;--cr-icon-button-height:var(--cr-icon-button-size);--cr-icon-button-transition:150ms ease-in-out;--cr-icon-button-width:var(--cr-icon-button-size);-webkit-tap-highlight-color:transparent;border-radius:50%;color:var(--cr-icon-button-stroke-color,var(--cr-icon-button-fill-color));cursor:pointer;display:inline-flex;flex-shrink:0;height:var(--cr-icon-button-height);margin-inline-end:var(--cr-icon-button-margin-end,var(--cr-icon-ripple-margin));margin-inline-start:var(--cr-icon-button-margin-start);outline:none;overflow:hidden;user-select:none;vertical-align:middle;width:var(--cr-icon-button-width)}:host-context([chrome-refresh-2023]):host{--cr-icon-button-fill-color:currentColor;--cr-icon-button-size:32px;position:relative}:host(:hover){background-color:var(--cr-icon-button-hover-background-color,var(--cr-hover-background-color))}:host(:focus-visible:focus){box-shadow:inset 0 0 0 2px var(--cr-icon-button-focus-outline-color,var(--cr-focus-outline-color))}@media (forced-colors:active){:host(:focus-visible:focus){outline:var(--cr-focus-outline-hcm)}}:host-context(html:not([chrome-refresh-2023])) :host(:active){background-color:var(--cr-icon-button-active-background-color,var(--cr-active-background-color))}paper-ripple{display:none}:host-context([chrome-refresh-2023]) paper-ripple{--paper-ripple-opacity:1;color:var(--cr-active-background-color);display:block}:host([disabled]){cursor:initial;opacity:var(--cr-disabled-opacity);pointer-events:none}:host(.no-overlap){--cr-icon-button-margin-end:0;--cr-icon-button-margin-start:0}:host-context([dir=rtl]):host(:not([dir=ltr]):not([multiple-icons_])){transform:scaleX(-1)}:host-context([dir=rtl]):host(:not([dir=ltr])[multiple-icons_]) iron-icon{transform:scaleX(-1)}:host(:not([iron-icon])) #maskedImage{-webkit-mask-image:var(--cr-icon-image);-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:var(--cr-icon-button-icon-size);-webkit-transform:var(--cr-icon-image-transform,none);background-color:var(--cr-icon-button-fill-color);height:100%;transition:background-color var(--cr-icon-button-transition);width:100%}@media (forced-colors:active){:host(:not([iron-icon])) #maskedImage{background-color:ButtonText}}#icon{align-items:center;border-radius:4px;display:flex;height:100%;justify-content:center;padding-inline-start:var(--cr-icon-button-icon-start-offset);position:relative;width:100%}iron-icon{--iron-icon-fill-color:var(--cr-icon-button-fill-color);--iron-icon-stroke-color:var(--cr-icon-button-stroke-color,none);--iron-icon-height:var(--cr-icon-button-icon-size);--iron-icon-width:var(--cr-icon-button-icon-size);transition:fill var(--cr-icon-button-transition),stroke var(--cr-icon-button-transition)}@media (prefers-color-scheme:dark){:host{--cr-icon-button-fill-color:var(--google-grey-500)}}</style>
<div id="icon">
  <div id="maskedImage"></div>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'cr-icon-button' is a button which displays an icon with a
 * ripple. It can be interacted with like a normal button using click as well as
 * space and enter to effectively click the button and fire a 'click' event.
 *
 * Forked from ui/webui/resources/cr_elements/cr_icon_button/cr_icon_button.ts
 *
 * There are two sources to icons, cr-icons and iron-iconset-svg. The cr-icon's
 * are defined as background images with a reference to a resource file
 * associated with a CSS class name. The iron-icon's are defined as inline SVG's
 * under a key that is stored in a global map that is accessible to the
 * iron-icon element.
 *
 * Example of using a cr-icon:
 * <link rel="import" href="chrome://resources/ash/common/cr_elements/cr_icons.css.html">
 * <dom-module id="module">
 *   <template>
 *     <style includes="cr-icons"></style>
 *     <cr-icon-button class="icon-class-name"></cr-icon-button>
 *   </template>
 * </dom-module>
 *
 * In general when an icon is specified using a class, the expectation is the
 * class will set an image to the --cr-icon-image variable.
 *
 * Example of using an iron-icon:
 * In the TS file:
 * import 'chrome://resources/ash/common/cr_elements/icons.html.js';
 *
 * In the HTML template file:
 * <cr-icon-button iron-icon="cr:icon-key"></cr-icon-button>
 *
 * The color of the icon can be overridden using CSS variables. When using
 * iron-icon both the fill and stroke can be overridden the variables:
 * --cr-icon-button-fill-color
 * --cr-icon-button-stroke-color
 *
 * When not using iron-icon (ie. specifying --cr-icon-image), the icons support
 * one color and the 'stroke' variables are ignored.
 *
 * When using iron-icon's, more than one icon can be specified by setting
 * the |ironIcon| property to a comma-delimited list of keys.
 */
const CrIconbuttonElementBase = PaperRippleMixin(PolymerElement);
class CrIconButtonElement extends CrIconbuttonElementBase {
    static get is() {
        return 'cr-icon-button';
    }
    static get template() {
        return getTemplate$1N();
    }
    static get properties() {
        return {
            disabled: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
                observer: 'disabledChanged_',
            },
            /**
             * Use this property in order to configure the "tabindex" attribute.
             */
            customTabIndex: {
                type: Number,
                observer: 'applyTabIndex_',
            },
            ironIcon: {
                type: String,
                observer: 'onIronIconChanged_',
                reflectToAttribute: true,
            },
            multipleIcons_: {
                type: Boolean,
                reflectToAttribute: true,
            },
        };
    }
    constructor() {
        super();
        /**
         * It is possible to activate a tab when the space key is pressed down. When
         * this element has focus, the keyup event for the space key should not
         * perform a 'click'. |spaceKeyDown_| tracks when a space pressed and
         * handled by this element. Space keyup will only result in a 'click' when
         * |spaceKeyDown_| is true. |spaceKeyDown_| is set to false when element
         * loses focus.
         */
        this.spaceKeyDown_ = false;
        this.addEventListener('blur', this.onBlur_.bind(this));
        this.addEventListener('click', this.onClick_.bind(this));
        this.addEventListener('keydown', this.onKeyDown_.bind(this));
        this.addEventListener('keyup', this.onKeyUp_.bind(this));
        if (document.documentElement.hasAttribute('chrome-refresh-2023')) {
            this.addEventListener('pointerdown', this.onPointerDown_.bind(this));
        }
    }
    ready() {
        super.ready();
        this.setAttribute('aria-disabled', this.disabled ? 'true' : 'false');
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'button');
        }
        if (!this.hasAttribute('tabindex')) {
            this.setAttribute('tabindex', '0');
        }
    }
    toggleClass(className) {
        this.classList.toggle(className);
    }
    disabledChanged_(newValue, oldValue) {
        if (!newValue && oldValue === undefined) {
            return;
        }
        if (this.disabled) {
            this.blur();
        }
        this.setAttribute('aria-disabled', this.disabled ? 'true' : 'false');
        this.applyTabIndex_();
    }
    /**
     * Updates the tabindex HTML attribute to the actual value.
     */
    applyTabIndex_() {
        let value = this.customTabIndex;
        if (value === undefined) {
            value = this.disabled ? -1 : 0;
        }
        this.setAttribute('tabindex', value.toString());
    }
    onBlur_() {
        this.spaceKeyDown_ = false;
    }
    onClick_(e) {
        if (this.disabled) {
            e.stopImmediatePropagation();
        }
    }
    onIronIconChanged_() {
        this.shadowRoot.querySelectorAll('iron-icon').forEach(el => el.remove());
        if (!this.ironIcon) {
            return;
        }
        const icons = (this.ironIcon || '').split(',');
        this.multipleIcons_ = icons.length > 1;
        icons.forEach(icon => {
            const ironIcon = document.createElement('iron-icon');
            ironIcon.icon = icon;
            this.$.icon.appendChild(ironIcon);
            if (ironIcon.shadowRoot) {
                ironIcon.shadowRoot.querySelectorAll('svg, img')
                    .forEach(child => child.setAttribute('role', 'none'));
            }
        });
    }
    onKeyDown_(e) {
        if (e.key !== ' ' && e.key !== 'Enter') {
            return;
        }
        e.preventDefault();
        e.stopPropagation();
        if (e.repeat) {
            return;
        }
        if (e.key === 'Enter') {
            this.click();
        }
        else if (e.key === ' ') {
            this.spaceKeyDown_ = true;
        }
    }
    onKeyUp_(e) {
        if (e.key === ' ' || e.key === 'Enter') {
            e.preventDefault();
            e.stopPropagation();
        }
        if (this.spaceKeyDown_ && e.key === ' ') {
            this.spaceKeyDown_ = false;
            this.click();
        }
    }
    onPointerDown_() {
        this.ensureRipple();
    }
}
customElements.define(CrIconButtonElement.is, CrIconButtonElement);

const styleMod$d = document.createElement('dom-module');
styleMod$d.appendChild(html `
  <template>
    <style>
[hidden],:host([hidden]){display:none !important}
    </style>
  </template>
`.content);
styleMod$d.register('cr-hidden-style');

/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
/**
 * The `iron-iconset-svg` element allows users to define their own icon sets
 * that contain svg icons. The svg icon elements should be children of the
 * `iron-iconset-svg` element. Multiple icons should be given distinct id's.
 *
 * Using svg elements to create icons has a few advantages over traditional
 * bitmap graphics like jpg or png. Icons that use svg are vector based so
 * they are resolution independent and should look good on any device. They
 * are stylable via css. Icons can be themed, colorized, and even animated.
 *
 * Example:
 *
 *     <iron-iconset-svg name="my-svg-icons" size="24">
 *       <svg>
 *         <defs>
 *           <g id="shape">
 *             <rect x="12" y="0" width="12" height="24" />
 *             <circle cx="12" cy="12" r="12" />
 *           </g>
 *         </defs>
 *       </svg>
 *     </iron-iconset-svg>
 *
 * This will automatically register the icon set "my-svg-icons" to the iconset
 * database.  To use these icons from within another element, make a
 * `iron-iconset` element and call the `byId` method
 * to retrieve a given iconset. To apply a particular icon inside an
 * element use the `applyIcon` method. For example:
 *
 *     iconset.applyIcon(iconNode, 'car');
 *
 * @element iron-iconset-svg
 * @demo demo/index.html
 * @implements {Polymer.Iconset}
 */
Polymer({
  is: 'iron-iconset-svg',

  properties: {

    /**
     * The name of the iconset.
     */
    name: {type: String, observer: '_nameChanged'},

    /**
     * The size of an individual icon. Note that icons must be square.
     */
    size: {type: Number, value: 24},

    /**
     * Set to true to enable mirroring of icons where specified when they are
     * stamped. Icons that should be mirrored should be decorated with a
     * `mirror-in-rtl` attribute.
     *
     * NOTE: For performance reasons, direction will be resolved once per
     * document per iconset, so moving icons in and out of RTL subtrees will
     * not cause their mirrored state to change.
     */
    rtlMirroring: {type: Boolean, value: false},

    /**
     * Set to true to measure RTL based on the dir attribute on the body or
     * html elements (measured on document.body or document.documentElement as
     * available).
     */
    useGlobalRtlAttribute: {type: Boolean, value: false}
  },

  created: function() {
    this._meta = new IronMeta({type: 'iconset', key: null, value: null});
  },

  attached: function() {
    this.style.display = 'none';
  },

  /**
   * Construct an array of all icon names in this iconset.
   *
   * @return {!Array} Array of icon names.
   */
  getIconNames: function() {
    this._icons = this._createIconMap();
    return Object.keys(this._icons).map(function(n) {
      return this.name + ':' + n;
    }, this);
  },

  /**
   * Applies an icon to the given element.
   *
   * An svg icon is prepended to the element's shadowRoot if it exists,
   * otherwise to the element itself.
   *
   * If RTL mirroring is enabled, and the icon is marked to be mirrored in
   * RTL, the element will be tested (once and only once ever for each
   * iconset) to determine the direction of the subtree the element is in.
   * This direction will apply to all future icon applications, although only
   * icons marked to be mirrored will be affected.
   *
   * @method applyIcon
   * @param {Element} element Element to which the icon is applied.
   * @param {string} iconName Name of the icon to apply.
   * @return {?Element} The svg element which renders the icon.
   */
  applyIcon: function(element, iconName) {
    // Remove old svg element
    this.removeIcon(element);
    // install new svg element
    var svg = this._cloneIcon(
        iconName, this.rtlMirroring && this._targetIsRTL(element));
    if (svg) {
      // insert svg element into shadow root, if it exists
      var pde = element.shadowRoot ?
          element.shadowRoot : dom(element.root || element);
      pde.insertBefore(svg, pde.childNodes[0]);
      return element._svgIcon = svg;
    }
    return null;
  },

  /**
   * Produce installable clone of the SVG element matching `id` in this
   * iconset, or `undefined` if there is no matching element.
   * @param {string} iconName Name of the icon to apply.
   * @param {boolean} targetIsRTL Whether the target element is RTL.
   * @return {Element} Returns an installable clone of the SVG element
   *     matching `id`.
   */
  createIcon: function(iconName, targetIsRTL) {
    return this._cloneIcon(iconName, this.rtlMirroring && targetIsRTL);
  },

  /**
   * Remove an icon from the given element by undoing the changes effected
   * by `applyIcon`.
   *
   * @param {Element} element The element from which the icon is removed.
   */
  removeIcon: function(element) {
    // Remove old svg element
    if (element._svgIcon) {
      var root = element.shadowRoot ?
          element.shadowRoot : dom(element.root || element);
      root.removeChild(element._svgIcon);
      element._svgIcon = null;
    }
  },

  /**
   * Measures and memoizes the direction of the element. Note that this
   * measurement is only done once and the result is memoized for future
   * invocations.
   */
  _targetIsRTL: function(target) {
    if (this.__targetIsRTL == null) {
      if (this.useGlobalRtlAttribute) {
        var globalElement =
            (document.body && document.body.hasAttribute('dir')) ?
            document.body :
            document.documentElement;

        this.__targetIsRTL = globalElement.getAttribute('dir') === 'rtl';
      } else {
        if (target && target.nodeType !== Node.ELEMENT_NODE) {
          target = target.host;
        }

        this.__targetIsRTL =
            target && window.getComputedStyle(target)['direction'] === 'rtl';
      }
    }

    return this.__targetIsRTL;
  },

  /**
   *
   * When name is changed, register iconset metadata
   *
   */
  _nameChanged: function() {
    this._meta.value = null;
    this._meta.key = this.name;
    this._meta.value = this;

    this.fire('iron-iconset-added', this, {node: window});
  },

  /**
   * Create a map of child SVG elements by id.
   *
   * @return {!Object} Map of id's to SVG elements.
   */
  _createIconMap: function() {
    // Objects chained to Object.prototype (`{}`) have members. Specifically,
    // on FF there is a `watch` method that confuses the icon map, so we
    // need to use a null-based object here.
    var icons = Object.create(null);
    dom(this).querySelectorAll('[id]').forEach(function(icon) {
      icons[icon.id] = icon;
    });
    return icons;
  },

  /**
   * Produce installable clone of the SVG element matching `id` in this
   * iconset, or `undefined` if there is no matching element.
   *
   * @return {Element} Returns an installable clone of the SVG element
   * matching `id`.
   */
  _cloneIcon: function(id, mirrorAllowed) {
    // create the icon map on-demand, since the iconset itself has no discrete
    // signal to know when it's children are fully parsed
    this._icons = this._icons || this._createIconMap();
    return this._prepareSvgClone(this._icons[id], this.size, mirrorAllowed);
  },

  /**
   * @param {Element} sourceSvg
   * @param {number} size
   * @param {Boolean} mirrorAllowed
   * @return {Element}
   */
  _prepareSvgClone: function(sourceSvg, size, mirrorAllowed) {
    if (sourceSvg) {
      var content = sourceSvg.cloneNode(true),
          svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg'),
          viewBox =
              content.getAttribute('viewBox') || '0 0 ' + size + ' ' + size,
          cssText =
              'pointer-events: none; display: block; width: 100%; height: 100%;';

      if (mirrorAllowed && content.hasAttribute('mirror-in-rtl')) {
        cssText +=
            '-webkit-transform:scale(-1,1);transform:scale(-1,1);transform-origin:center;';
      }

      svg.setAttribute('viewBox', viewBox);
      svg.setAttribute('preserveAspectRatio', 'xMidYMid meet');
      svg.setAttribute('focusable', 'false');
      // TODO(dfreedm): `pointer-events: none` works around
      // https://crbug.com/370136
      // TODO(sjmiles): inline style may not be ideal, but avoids requiring a
      // shadow-root
      svg.style.cssText = cssText;
      svg.appendChild(content).removeAttribute('id');
      return svg;
    }
    return null;
  }

});

const template$a = html `<!--
List commonly used icons here to prevent duplication.
Do not add rarely used icons here; place those in your application.
Note that 20px and 24px icons are specified separately (size="", below).

Icons are rendered at 20x20 px, but we don't have 20 px SVGs for everything.
The 24 px icons are used where 20 px icons are unavailable (which may appear
blurry at 20 px). Please use 20 px icons when available.
-->
<iron-iconset-svg name="cr20" size="20">
  <svg>
    <defs>
      <!--
      Keep these in sorted order by id="".
      -->
      <g id="block">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M10 0C4.48 0 0 4.48 0 10C0 15.52 4.48 20 10 20C15.52 20 20 15.52 20 10C20 4.48 15.52 0 10 0ZM2 10C2 5.58 5.58 2 10 2C11.85 2 13.55 2.63 14.9 3.69L3.69 14.9C2.63 13.55 2 11.85 2 10ZM5.1 16.31C6.45 17.37 8.15 18 10 18C14.42 18 18 14.42 18 10C18 8.15 17.37 6.45 16.31 5.1L5.1 16.31Z">
        </path>
      </g>
      <g id="cloud-off">
        <path
          d="M16 18.125L13.875 16H5C3.88889 16 2.94444 15.6111 2.16667 14.8333C1.38889 14.0556 1 13.1111 1 12C1 10.9444 1.36111 10.0347 2.08333 9.27083C2.80556 8.50694 3.6875 8.09028 4.72917 8.02083C4.77083 7.86805 4.8125 7.72222 4.85417 7.58333C4.90972 7.44444 4.97222 7.30555 5.04167 7.16667L1.875 4L2.9375 2.9375L17.0625 17.0625L16 18.125ZM5 14.5H12.375L6.20833 8.33333C6.15278 8.51389 6.09722 8.70139 6.04167 8.89583C6 9.07639 5.95139 9.25694 5.89583 9.4375L4.83333 9.52083C4.16667 9.57639 3.61111 9.84028 3.16667 10.3125C2.72222 10.7708 2.5 11.3333 2.5 12C2.5 12.6944 2.74306 13.2847 3.22917 13.7708C3.71528 14.2569 4.30556 14.5 5 14.5ZM17.5 15.375L16.3958 14.2917C16.7153 14.125 16.9792 13.8819 17.1875 13.5625C17.3958 13.2431 17.5 12.8889 17.5 12.5C17.5 11.9444 17.3056 11.4722 16.9167 11.0833C16.5278 10.6944 16.0556 10.5 15.5 10.5H14.125L14 9.14583C13.9028 8.11806 13.4722 7.25694 12.7083 6.5625C11.9444 5.85417 11.0417 5.5 10 5.5C9.65278 5.5 9.31944 5.54167 9 5.625C8.69444 5.70833 8.39583 5.82639 8.10417 5.97917L7.02083 4.89583C7.46528 4.61806 7.93056 4.40278 8.41667 4.25C8.91667 4.08333 9.44444 4 10 4C11.4306 4 12.6736 4.48611 13.7292 5.45833C14.7847 6.41667 15.375 7.59722 15.5 9C16.4722 9 17.2986 9.34028 17.9792 10.0208C18.6597 10.7014 19 11.5278 19 12.5C19 13.0972 18.8611 13.6458 18.5833 14.1458C18.3194 14.6458 17.9583 15.0556 17.5 15.375Z">
        </path>
      </g>
      <g id="domain">
        <path
          d="M2,3 L2,17 L11.8267655,17 L13.7904799,17 L18,17 L18,7 L12,7 L12,3 L2,3 Z M8,13 L10,13 L10,15 L8,15 L8,13 Z M4,13 L6,13 L6,15 L4,15 L4,13 Z M8,9 L10,9 L10,11 L8,11 L8,9 Z M4,9 L6,9 L6,11 L4,11 L4,9 Z M12,9 L16,9 L16,15 L12,15 L12,9 Z M12,11 L14,11 L14,13 L12,13 L12,11 Z M8,5 L10,5 L10,7 L8,7 L8,5 Z M4,5 L6,5 L6,7 L4,7 L4,5 Z">
        </path>
      </g>
      <g id="kite">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M4.6327 8.00094L10.3199 2L16 8.00094L10.1848 16.8673C10.0995 16.9873 10.0071 17.1074 9.90047 17.2199C9.42417 17.7225 8.79147 18 8.11611 18C7.44076 18 6.80806 17.7225 6.33175 17.2199C5.85545 16.7173 5.59242 16.0497 5.59242 15.3371C5.59242 14.977 5.46445 14.647 5.22275 14.3919C4.98104 14.1369 4.66825 14.0019 4.32701 14.0019H4V12.6667H4.32701C5.00237 12.6667 5.63507 12.9442 6.11137 13.4468C6.58768 13.9494 6.85071 14.617 6.85071 15.3296C6.85071 15.6896 6.97867 16.0197 7.22038 16.2747C7.46209 16.5298 7.77488 16.6648 8.11611 16.6648C8.45735 16.6648 8.77014 16.5223 9.01185 16.2747C9.02396 16.2601 9.03607 16.246 9.04808 16.2319C9.08541 16.1883 9.12176 16.1458 9.15403 16.0947L9.55213 15.4946L4.6327 8.00094ZM10.3199 13.9371L6.53802 8.17116L10.3199 4.1814L14.0963 8.17103L10.3199 13.9371Z">
        </path>
      </g>
      <g id="menu">
        <path d="M2 4h16v2H2zM2 9h16v2H2zM2 14h16v2H2z"></path>
      </g>
        <g id="banner-warning">
          <path fill-rule="evenodd" clip-rule="evenodd"
            d="M9.13177 1.50386C9.51566 0.832046 10.4844 0.832046 10.8683 1.50386L18.8683 15.5039C19.2492 16.1705 18.7678 17 18 17H2.00001C1.23219 17 0.750823 16.1705 1.13177 15.5039L9.13177 1.50386ZM10 4.01556L3.72321 15H16.2768L10 4.01556ZM9 11H11V7H9V11ZM11 14H9V12H11V14Z">
          </path>
        </g>
        <g id="warning">
          <path fill-rule="evenodd" clip-rule="evenodd"
            d="M9.13177 1.50386C9.51566 0.832046 10.4844 0.832046 10.8683 1.50386L18.8683 15.5039C19.2492 16.1705 18.7678 17 18 17H2.00001C1.23219 17 0.750823 16.1705 1.13177 15.5039L9.13177 1.50386ZM10 4.01556L3.72321 15H16.2768L10 4.01556ZM9 11H11V7H9V11ZM11 14H9V12H11V14Z">
          </path>
        </g>
  </svg>
</iron-iconset-svg>

<!-- NOTE: In the common case that the final icon will be 20x20, export the SVG
     at 20px and place it in the section above. -->
<iron-iconset-svg name="cr" size="24">
  <svg>
    <defs>
      <!--
      These icons are copied from Polymer's iron-icons and kept in sorted order.
      -->
      <g id="account-child-invert" viewBox="0 0 48 48">
        <path d="M24 4c3.31 0 6 2.69 6 6s-2.69 6-6 6-6-2.69-6-6 2.69-6 6-6z"></path>
        <path fill="none" d="M0 0h48v48H0V0z"></path>
        <circle fill="none" cx="24" cy="26" r="4"></circle>
        <path
          d="M24 18c-6.16 0-13 3.12-13 7.23v11.54c0 2.32 2.19 4.33 5.2 5.63 2.32 1 5.12 1.59 7.8 1.59.66 0 1.33-.06 2-.14v-5.2c-.67.08-1.34.14-2 .14-2.63 0-5.39-.57-7.68-1.55.67-2.12 4.34-3.65 7.68-3.65.86 0 1.75.11 2.6.29 2.79.62 5.2 2.15 5.2 4.04v4.47c3.01-1.31 5.2-3.31 5.2-5.63V25.23C37 21.12 30.16 18 24 18zm0 12c-2.21 0-4-1.79-4-4s1.79-4 4-4 4 1.79 4 4-1.79 4-4 4z">
        </path>
      </g>
      <g id="add">
        <path d="M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z" />
      </g>
      <g id="arrow-back">
        <path
          d="M20 11H7.83l5.59-5.59L12 4l-8 8 8 8 1.41-1.41L7.83 13H20v-2z">
        </path>
      </g>
      <g id="arrow-drop-up">
        <path d="M7 14l5-5 5 5z"></path>
      </g>
      <g id="arrow-drop-down">
        <path d="M7 10l5 5 5-5z"></path>
      </g>
      <g id="arrow-forward">
        <path
          d="M12 4l-1.41 1.41L16.17 11H4v2h12.17l-5.58 5.59L12 20l8-8z">
        </path>
      </g>
      <g id="arrow-right">
        <path d="M10 7l5 5-5 5z"></path>
      </g>
        <g id="bluetooth">
          <path
            d="M17.71 7.71L12 2h-1v7.59L6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 11 14.41V22h1l5.71-5.71-4.3-4.29 4.3-4.29zM13 5.83l1.88 1.88L13 9.59V5.83zm1.88 10.46L13 18.17v-3.76l1.88 1.88z">
          </path>
        </g>
        <g id="camera-alt">
          <circle cx="12" cy="12" r="3.2"></circle>
          <path
            d="M9 2L7.17 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2h-3.17L15 2H9zm3 15c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5z">
          </path>
        </g>
        <g id="work">
          <path
            d="M20 6h-4V4c0-1.11-.89-2-2-2h-4c-1.11 0-2 .89-2 2v2H4c-1.11 0-1.99.89-1.99 2L2 19c0 1.11.89 2 2 2h16c1.11 0 2-.89 2-2V8c0-1.11-.89-2-2-2zm-6 0h-4V4h4v2z">
          </path>
        </g>
      <g id="cancel">
        <path
          d="M12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.47 10-10S17.53 2 12 2zm5 13.59L15.59 17 12 13.41 8.41 17 7 15.59 10.59 12 7 8.41 8.41 7 12 10.59 15.59 7 17 8.41 13.41 12 17 15.59z">
        </path>
      </g>
      <g id="check">
        <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"></path>
      </g>
      <g id="check-circle">
        <path
          d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z">
        </path>
      </g>
      <g id="chevron-left">
        <path d="M15.41 7.41L14 6l-6 6 6 6 1.41-1.41L10.83 12z"></path>
      </g>
      <g id="chevron-right">
        <path d="M10 6L8.59 7.41 13.17 12l-4.58 4.59L10 18l6-6z"></path>
      </g>
      <g id="clear">
        <path
          d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z">
        </path>
      </g>
      <g id="close">
        <path
          d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z">
        </path>
      </g>
      <g id="computer">
        <path
          d="M20 18c1.1 0 1.99-.9 1.99-2L22 6c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2H0v2h24v-2h-4zM4 6h16v10H4V6z">
        </path>
      </g>
      <g id="create">
        <path
          d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04c.39-.39.39-1.02 0-1.41l-2.34-2.34c-.39-.39-1.02-.39-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z">
        </path>
      </g>
      <g id="delete">
        <path
          d="M6 19c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V7H6v12zM19 4h-3.5l-1-1h-5l-1 1H5v2h14V4z">
        </path>
      </g>
      <g id="domain">
        <path
          d="M12 7V3H2v18h20V7H12zM6 19H4v-2h2v2zm0-4H4v-2h2v2zm0-4H4V9h2v2zm0-4H4V5h2v2zm4 12H8v-2h2v2zm0-4H8v-2h2v2zm0-4H8V9h2v2zm0-4H8V5h2v2zm10 12h-8v-2h2v-2h-2v-2h2v-2h-2V9h8v10zm-2-8h-2v2h2v-2zm0 4h-2v2h2v-2z">
        </path>
      </g>
      <g id="error">
        <path
          d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z">
        </path>
      </g>
      <g id="error-outline">
        <path
          d="M11 15h2v2h-2zm0-8h2v6h-2zm.99-5C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z">
        </path>
      </g>
      <g id="expand-less">
        <path d="M12 8l-6 6 1.41 1.41L12 10.83l4.59 4.58L18 14z"></path>
      </g>
      <g id="expand-more">
        <path d="M16.59 8.59L12 13.17 7.41 8.59 6 10l6 6 6-6z"></path>
      </g>
      <g id="extension">
        <path
          d="M20.5 11H19V7c0-1.1-.9-2-2-2h-4V3.5C13 2.12 11.88 1 10.5 1S8 2.12 8 3.5V5H4c-1.1 0-1.99.9-1.99 2v3.8H3.5c1.49 0 2.7 1.21 2.7 2.7s-1.21 2.7-2.7 2.7H2V20c0 1.1.9 2 2 2h3.8v-1.5c0-1.49 1.21-2.7 2.7-2.7 1.49 0 2.7 1.21 2.7 2.7V22H17c1.1 0 2-.9 2-2v-4h1.5c1.38 0 2.5-1.12 2.5-2.5S21.88 11 20.5 11z">
        </path>
      </g>
      <g id="file-download">
        <path d="M19 9h-4V3H9v6H5l7 7 7-7zM5 18v2h14v-2H5z"></path>
      </g>
        <g id="folder-filled">
          <path
            d="M10 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2h-8l-2-2z">
          </path>
        </g>
      <g id="fullscreen">
        <path
          d="M7 14H5v5h5v-2H7v-3zm-2-4h2V7h3V5H5v5zm12 7h-3v2h5v-5h-2v3zM14 5v2h3v3h2V5h-5z">
        </path>
      </g>
      <g id="group">
        <path
          d="M16 11c1.66 0 2.99-1.34 2.99-3S17.66 5 16 5c-1.66 0-3 1.34-3 3s1.34 3 3 3zm-8 0c1.66 0 2.99-1.34 2.99-3S9.66 5 8 5C6.34 5 5 6.34 5 8s1.34 3 3 3zm0 2c-2.33 0-7 1.17-7 3.5V19h14v-2.5c0-2.33-4.67-3.5-7-3.5zm8 0c-.29 0-.62.02-.97.05 1.16.84 1.97 1.97 1.97 3.45V19h6v-2.5c0-2.33-4.67-3.5-7-3.5z">
        </path>
      </g>
      <g id="help-outline">
        <path
          d="M11 18h2v-2h-2v2zm1-16C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm0-14c-2.21 0-4 1.79-4 4h2c0-1.1.9-2 2-2s2 .9 2 2c0 2-3 1.75-3 5h2c0-2.25 3-2.5 3-5 0-2.21-1.79-4-4-4z">
        </path>
      </g>
      <g id="history">
        <path
          d="M12.945312 22.75 C 10.320312 22.75 8.074219 21.839844 6.207031 20.019531 C 4.335938 18.199219 3.359375 15.972656 3.269531 13.34375 L 5.089844 13.34375 C 5.175781 15.472656 5.972656 17.273438 7.480469 18.742188 C 8.988281 20.210938 10.808594 20.945312 12.945312 20.945312 C 15.179688 20.945312 17.070312 20.164062 18.621094 18.601562 C 20.167969 17.039062 20.945312 15.144531 20.945312 12.910156 C 20.945312 10.714844 20.164062 8.855469 18.601562 7.335938 C 17.039062 5.816406 15.15625 5.054688 12.945312 5.054688 C 11.710938 5.054688 10.554688 5.339844 9.480469 5.902344 C 8.402344 6.46875 7.476562 7.226562 6.699219 8.179688 L 9.585938 8.179688 L 9.585938 9.984375 L 3.648438 9.984375 L 3.648438 4.0625 L 5.453125 4.0625 L 5.453125 6.824219 C 6.386719 5.707031 7.503906 4.828125 8.804688 4.199219 C 10.109375 3.566406 11.488281 3.25 12.945312 3.25 C 14.300781 3.25 15.570312 3.503906 16.761719 4.011719 C 17.949219 4.519531 18.988281 5.214844 19.875 6.089844 C 20.761719 6.964844 21.464844 7.992188 21.976562 9.167969 C 22.492188 10.34375 22.75 11.609375 22.75 12.964844 C 22.75 14.316406 22.492188 15.589844 21.976562 16.777344 C 21.464844 17.964844 20.761719 19.003906 19.875 19.882812 C 18.988281 20.765625 17.949219 21.464844 16.761719 21.976562 C 15.570312 22.492188 14.300781 22.75 12.945312 22.75 Z M 16.269531 17.460938 L 12.117188 13.34375 L 12.117188 7.527344 L 13.921875 7.527344 L 13.921875 12.601562 L 17.550781 16.179688 Z M 16.269531 17.460938">
        </path>
      </g>
      <g id="info">
        <path
          d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-6h2v6zm0-8h-2V7h2v2z">
        </path>
      </g>
      <g id="info-outline">
        <path
          d="M11 17h2v-6h-2v6zm1-15C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zM11 9h2V7h-2v2z">
        </path>
      </g>
      <g id="insert-drive-file">
        <path
          d="M6 2c-1.1 0-1.99.9-1.99 2L4 20c0 1.1.89 2 1.99 2H18c1.1 0 2-.9 2-2V8l-6-6H6zm7 7V3.5L18.5 9H13z">
        </path>
      </g>
      <g id="location-on">
        <path
          d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z">
        </path>
      </g>
      <g id="mic">
        <path
          d="M12 14c1.66 0 2.99-1.34 2.99-3L15 5c0-1.66-1.34-3-3-3S9 3.34 9 5v6c0 1.66 1.34 3 3 3zm5.3-3c0 3-2.54 5.1-5.3 5.1S6.7 14 6.7 11H5c0 3.41 2.72 6.23 6 6.72V21h2v-3.28c3.28-.48 6-3.3 6-6.72h-1.7z">
        </path>
      </g>
      <g id="more-vert">
        <path
          d="M12 8c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm0 2c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0 6c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z">
        </path>
      </g>
      <g id="open-in-new">
        <path
          d="M19 19H5V5h7V3H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2v-7h-2v7zM14 3v2h3.59l-9.83 9.83 1.41 1.41L19 6.41V10h2V3h-7z">
        </path>
      </g>
      <g id="person">
        <path
          d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z">
        </path>
      </g>
      <g id="phonelink">
        <path
          d="M4 6h18V4H4c-1.1 0-2 .9-2 2v11H0v3h14v-3H4V6zm19 2h-6c-.55 0-1 .45-1 1v10c0 .55.45 1 1 1h6c.55 0 1-.45 1-1V9c0-.55-.45-1-1-1zm-1 9h-4v-7h4v7z">
        </path>
      </g>
      <g id="print">
        <path
          d="M19 8H5c-1.66 0-3 1.34-3 3v6h4v4h12v-4h4v-6c0-1.66-1.34-3-3-3zm-3 11H8v-5h8v5zm3-7c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm-1-9H6v4h12V3z">
        </path>
      </g>
      <g id="schedule">
        <path
          d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm.5-13H11v6l5.25 3.15.75-1.23-4.5-2.67z">
        </path>
      </g>
      <g id="search">
        <path
          d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z">
        </path>
      </g>
      <g id="security">
        <path
          d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4zm0 10.99h7c-.53 4.12-3.28 7.79-7 8.94V12H5V6.3l7-3.11v8.8z">
        </path>
      </g>
        <g id="sim-card-alert">
          <path
            d="M18 2h-8L4.02 8 4 20c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-5 15h-2v-2h2v2zm0-4h-2V8h2v5z">
          </path>
        </g>
        <g id="sim-lock">
          <path
            d="M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zm-6 9c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zm3.1-9H8.9V6c0-1.71 1.39-3.1 3.1-3.1 1.71 0 3.1 1.39 3.1 3.1v2z">
          </path>
        </g>
        <g id="sms-connect">
          <path
            d="M20,2C21.1,2 22,2.9 22,4L22,16C22,17.1 21.1,18 20,18L6,18L2,22L2.01,4C2.01,2.9 2.9,2 4,2L20,2ZM8,8L4,12L8,16L8,13L14,13L14,11L8,11L8,8ZM19.666,7.872L16.038,4.372L16.038,6.997L10,6.997L10,9L16.038,9L16.038,11.372L19.666,7.872Z">
          </path>
        </g>
      <!-- The <g> IDs are exposed as global variables in Vulcanized mode, which
        conflicts with the "settings" namespace of MD Settings. Using an "_icon"
        suffix prevents the naming conflict. -->
      <g id="settings_icon">
        <path
          d="M19.43 12.98c.04-.32.07-.64.07-.98s-.03-.66-.07-.98l2.11-1.65c.19-.15.24-.42.12-.64l-2-3.46c-.12-.22-.39-.3-.61-.22l-2.49 1c-.52-.4-1.08-.73-1.69-.98l-.38-2.65C14.46 2.18 14.25 2 14 2h-4c-.25 0-.46.18-.49.42l-.38 2.65c-.61.25-1.17.59-1.69.98l-2.49-1c-.23-.09-.49 0-.61.22l-2 3.46c-.13.22-.07.49.12.64l2.11 1.65c-.04.32-.07.65-.07.98s.03.66.07.98l-2.11 1.65c-.19.15-.24.42-.12.64l2 3.46c.12.22.39.3.61.22l2.49-1c.52.4 1.08.73 1.69.98l.38 2.65c.03.24.24.42.49.42h4c.25 0 .46-.18.49-.42l.38-2.65c.61-.25 1.17-.59 1.69-.98l2.49 1c.23.09.49 0 .61-.22l2-3.46c.12-.22.07-.49-.12-.64l-2.11-1.65zM12 15.5c-1.93 0-3.5-1.57-3.5-3.5s1.57-3.5 3.5-3.5 3.5 1.57 3.5 3.5-1.57 3.5-3.5 3.5z">
        </path>
      </g>
      <g id="star">
        <path
          d="M12 17.27L18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21z">
        </path>
      </g>
      <g id="sync">
        <path
          d="M12 4V1L8 5l4 4V6c3.31 0 6 2.69 6 6 0 1.01-.25 1.97-.7 2.8l1.46 1.46C19.54 15.03 20 13.57 20 12c0-4.42-3.58-8-8-8zm0 14c-3.31 0-6-2.69-6-6 0-1.01.25-1.97.7-2.8L5.24 7.74C4.46 8.97 4 10.43 4 12c0 4.42 3.58 8 8 8v3l4-4-4-4v3z">
        </path>
      </g>
      <g id="thumbs-down">
        <path
            d="M6 3h11v13l-7 7-1.25-1.25a1.454 1.454 0 0 1-.3-.475c-.067-.2-.1-.392-.1-.575v-.35L9.45 16H3c-.533 0-1-.2-1.4-.6-.4-.4-.6-.867-.6-1.4v-2c0-.117.017-.242.05-.375s.067-.258.1-.375l3-7.05c.15-.333.4-.617.75-.85C5.25 3.117 5.617 3 6 3Zm9 2H6l-3 7v2h9l-1.35 5.5L15 15.15V5Zm0 10.15V5v10.15Zm2 .85v-2h3V5h-3V3h5v13h-5Z">
        </path>
      </g>
      <g id="thumbs-down-filled">
        <path
            d="M6 3h10v13l-7 7-1.25-1.25a1.336 1.336 0 0 1-.29-.477 1.66 1.66 0 0 1-.108-.574v-.347L8.449 16H3c-.535 0-1-.2-1.398-.602C1.199 15 1 14.535 1 14v-2c0-.117.012-.242.04-.375.022-.133.062-.258.108-.375l3-7.05c.153-.333.403-.618.75-.848A1.957 1.957 0 0 1 6 3Zm12 13V3h4v13Zm0 0">
        </path>
      </g>
      <g id="thumbs-up">
        <path
            d="M18 21H7V8l7-7 1.25 1.25c.117.117.208.275.275.475.083.2.125.392.125.575v.35L14.55 8H21c.533 0 1 .2 1.4.6.4.4.6.867.6 1.4v2c0 .117-.017.242-.05.375s-.067.258-.1.375l-3 7.05c-.15.333-.4.617-.75.85-.35.233-.717.35-1.1.35Zm-9-2h9l3-7v-2h-9l1.35-5.5L9 8.85V19ZM9 8.85V19 8.85ZM7 8v2H4v9h3v2H2V8h5Z">
        </path>
      </g>
      <g id="thumbs-up-filled">
        <path
            d="M18 21H8V8l7-7 1.25 1.25c.117.117.21.273.29.477.073.199.108.39.108.574v.347L15.551 8H21c.535 0 1 .2 1.398.602C22.801 9 23 9.465 23 10v2c0 .117-.012.242-.04.375a1.897 1.897 0 0 1-.108.375l-3 7.05a2.037 2.037 0 0 1-.75.848A1.957 1.957 0 0 1 18 21ZM6 8v13H2V8Zm0 0">
      </g>
      <g id="videocam">
        <path
          d="M17 10.5V7c0-.55-.45-1-1-1H4c-.55 0-1 .45-1 1v10c0 .55.45 1 1 1h12c.55 0 1-.45 1-1v-3.5l4 4v-11l-4 4z">
        </path>
      </g>
      <g id="warning">
        <path d="M1 21h22L12 2 1 21zm12-3h-2v-2h2v2zm0-4h-2v-4h2v4z"></path>
      </g>
    </defs>
  </svg>
</iron-iconset-svg>
`;
document.head.appendChild(template$a.content);

const styleMod$c = document.createElement('dom-module');
styleMod$c.appendChild(html `
  <template>
    <style>
.icon-arrow-back{--cr-icon-image:url(chrome://resources/images/icon_arrow_back.svg)}.icon-arrow-dropdown{--cr-icon-image:url(chrome://resources/images/icon_arrow_dropdown.svg)}.icon-arrow-drop-down-cr23{--cr-icon-image:url(chrome://resources/images/icon_arrow_drop_down_cr23.svg)}.icon-arrow-drop-up-cr23{--cr-icon-image:url(chrome://resources/images/icon_arrow_drop_up_cr23.svg)}.icon-cancel{--cr-icon-image:url(chrome://resources/images/icon_cancel.svg)}.icon-clear{--cr-icon-image:url(chrome://resources/images/icon_clear.svg)}.icon-copy-content{--cr-icon-image:url(chrome://resources/images/icon_copy_content.svg)}.icon-delete-gray{--cr-icon-image:url(chrome://resources/images/icon_delete_gray.svg)}.icon-edit{--cr-icon-image:url(chrome://resources/images/icon_edit.svg)}.icon-file{--cr-icon-image:url(chrome://resources/images/icon_filetype_generic.svg)}.icon-folder-open{--cr-icon-image:url(chrome://resources/images/icon_folder_open.svg)}.icon-picture-delete{--cr-icon-image:url(chrome://resources/images/icon_picture_delete.svg)}.icon-expand-less{--cr-icon-image:url(chrome://resources/images/icon_expand_less.svg)}.icon-expand-more{--cr-icon-image:url(chrome://resources/images/icon_expand_more.svg)}.icon-external{--cr-icon-image:url(chrome://resources/images/open_in_new.svg)}.icon-more-vert{--cr-icon-image:url(chrome://resources/images/icon_more_vert.svg)}.icon-refresh{--cr-icon-image:url(chrome://resources/images/icon_refresh.svg)}.icon-search{--cr-icon-image:url(chrome://resources/images/icon_search.svg)}.icon-settings{--cr-icon-image:url(chrome://resources/images/icon_settings.svg)}.icon-visibility{--cr-icon-image:url(chrome://resources/images/icon_visibility.svg)}.icon-visibility-off{--cr-icon-image:url(chrome://resources/images/icon_visibility_off.svg)}.subpage-arrow{--cr-icon-image:url(chrome://resources/images/arrow_right.svg)}.cr-icon{-webkit-mask-image:var(--cr-icon-image);-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:var(--cr-icon-size);background-color:var(--cr-icon-color,var(--google-grey-700));flex-shrink:0;height:var(--cr-icon-ripple-size);margin-inline-end:var(--cr-icon-ripple-margin);margin-inline-start:var(--cr-icon-button-margin-start);user-select:none;width:var(--cr-icon-ripple-size)}:host-context([dir=rtl]) .cr-icon{transform:scaleX(-1)}.cr-icon.no-overlap{margin-inline-end:0;margin-inline-start:0}@media (prefers-color-scheme:dark){.cr-icon{background-color:var(--cr-icon-color,var(--google-grey-500))}}
    </style>
  </template>
`.content);
styleMod$c.register('cr-icons');

const styleMod$b = document.createElement('dom-module');
styleMod$b.appendChild(html `
  <template>
    <style include="cr-hidden-style cr-icons">
html,:host{--scrollable-border-color:var(--google-grey-300)}@media (prefers-color-scheme:dark){html,:host{--scrollable-border-color:var(--google-grey-700)}}[actionable]{cursor:pointer}.hr{border-top:var(--cr-separator-line)}iron-list.cr-separators>*:not([first]){border-top:var(--cr-separator-line)}[scrollable]{border-color:transparent;border-style:solid;border-width:1px 0;overflow-y:auto}[scrollable].is-scrolled{border-top-color:var(--scrollable-border-color)}[scrollable].can-scroll:not(.scrolled-to-bottom){border-bottom-color:var(--scrollable-border-color)}[scrollable] iron-list>:not(.no-outline):focus,[selectable]:focus,[selectable]>:focus{background-color:var(--cr-focused-item-color);outline:none}.scroll-container{display:flex;flex-direction:column;min-height:1px}[selectable]>*{cursor:pointer}.cr-centered-card-container{box-sizing:border-box;display:block;height:inherit;margin:0 auto;max-width:var(--cr-centered-card-max-width);min-width:550px;position:relative;width:calc(100% * var(--cr-centered-card-width-percentage))}.cr-container-shadow{box-shadow:inset 0 5px 6px -3px rgba(0,0,0,.4);height:var(--cr-container-shadow-height);left:0;margin:0 0 var(--cr-container-shadow-margin);opacity:0;pointer-events:none;position:relative;right:0;top:0;transition:opacity 500ms;z-index:1}#cr-container-shadow-bottom{margin-bottom:0;margin-top:var(--cr-container-shadow-margin);transform:scaleY(-1)}#cr-container-shadow-top.has-shadow,#cr-container-shadow-bottom.has-shadow{opacity:var(--cr-container-shadow-max-opacity)}.cr-row{align-items:center;border-top:var(--cr-separator-line);display:flex;min-height:var(--cr-section-min-height);padding:0 var(--cr-section-padding)}.cr-row.first,.cr-row.continuation{border-top:none}.cr-row-gap{padding-inline-start:16px}.cr-button-gap{margin-inline-start:8px}paper-tooltip::part(tooltip){border-radius:var(--paper-tooltip-border-radius,2px);font-size:92.31%;font-weight:500;max-width:330px;min-width:var(--paper-tooltip-min-width,200px);padding:var(--paper-tooltip-padding,10px 8px)}.cr-padded-text{padding-block-end:var(--cr-section-vertical-padding);padding-block-start:var(--cr-section-vertical-padding)}.cr-title-text{color:var(--cr-title-text-color);font-size:107.6923%;font-weight:500}.cr-secondary-text{color:var(--cr-secondary-text-color);font-weight:400}.cr-form-field-label{color:var(--cr-form-field-label-color);display:block;font-size:var(--cr-form-field-label-font-size);font-weight:500;letter-spacing:.4px;line-height:var(--cr-form-field-label-line-height);margin-bottom:8px}.cr-vertical-tab{align-items:center;display:flex}.cr-vertical-tab::before{border-radius:0 3px 3px 0;content:'';display:block;flex-shrink:0;height:var(--cr-vertical-tab-height,100%);width:4px}.cr-vertical-tab.selected::before{background:var(--cr-vertical-tab-selected-color,var(--cr-checked-color))}:host-context([dir=rtl]) .cr-vertical-tab::before{transform:scaleX(-1)}.iph-anchor-highlight{background-color:var(--cr-iph-anchor-highlight-color)}
    </style>
  </template>
`.content);
styleMod$b.register('cr-shared-style');

function getTemplate$1M() {
    return html `<!--_html_template_start_--><style include="cr-actionable-row-style cr-shared-style cr-hidden-style">:host{box-sizing:border-box;flex:1;font-family:inherit;font-size:100%;line-height:154%;min-height:var(--cr-section-min-height);padding:0}:host(:not([embedded])){padding:0 var(--cr-section-padding)}#startIcon{--iron-icon-fill-color:var(--cr-link-row-start-icon-color,var(--google-grey-700));display:flex;flex-shrink:0;padding-inline-end:var(--cr-icon-button-margin-start);width:var(--cr-link-row-icon-width,var(--cr-icon-size))}@media (prefers-color-scheme:dark){#startIcon{--iron-icon-fill-color:var(--cr-link-row-start-icon-color,var(--google-grey-500))}}#labelWrapper{flex:1;flex-basis:0.000000001px;padding-bottom:var(--cr-section-vertical-padding);padding-top:var(--cr-section-vertical-padding);text-align:start}#label,#subLabel{display:flex}#buttonAriaDescription{clip:rect(0,0,0,0);display:block;position:fixed}</style>
<iron-icon id="startIcon" icon="[[startIcon]]" hidden="[[!startIcon]]"
    aria-hidden="true">
</iron-icon>
<div id="labelWrapper" hidden="[[hideLabelWrapper_]]">
  <div id="label" aria-hidden="[[!ariaShowLabel]]">
    [[label]]
    <slot name="label"></slot>
  </div>
  <div id="subLabel" class="cr-secondary-text"
      aria-hidden="[[!ariaShowSublabel]]">
    [[subLabel]]
    <slot name="sub-label"></slot>
  </div>
</div>
<slot></slot>
<div id="buttonAriaDescription" aria-hidden="true">
  [[computeButtonAriaDescription_(external, buttonAriaDescription)]]
</div>
<cr-icon-button id="icon" iron-icon="[[getIcon_(external)]]" role="link"
    part="icon" aria-roledescription$="[[roleDescription]]"
    aria-describedby="buttonAriaDescription"
    aria-labelledby="label subLabel" disabled="[[disabled]]">
</cr-icon-button>
<!--_html_template_end_-->`;
}

// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * A link row is a UI element similar to a button, though usually wider than a
 * button (taking up the whole 'row'). The name link comes from the intended use
 * of this element to take the user to another page in the app or to an external
 * page (somewhat like an HTML link).
 * Forked from
 * ui/webui/resources/cr_elements/cr_link_row/cr_link_row.ts
 */
class CrLinkRowElement extends PolymerElement {
    static get is() {
        return 'cr-link-row';
    }
    static get template() {
        return getTemplate$1M();
    }
    static get properties() {
        return {
            ariaShowLabel: {
                type: Boolean,
                reflectToAttribute: true,
                value: false,
            },
            ariaShowSublabel: {
                type: Boolean,
                reflectToAttribute: true,
                value: false,
            },
            startIcon: {
                type: String,
                value: '',
            },
            label: {
                type: String,
                value: '',
            },
            subLabel: {
                type: String,
                /* Value used for noSubLabel attribute. */
                value: '',
            },
            disabled: {
                type: Boolean,
                reflectToAttribute: true,
            },
            external: {
                type: Boolean,
                value: false,
            },
            usingSlottedLabel: {
                type: Boolean,
                value: false,
            },
            roleDescription: String,
            buttonAriaDescription: String,
            hideLabelWrapper_: {
                type: Boolean,
                computed: 'computeHideLabelWrapper_(label, usingSlottedLabel)',
            },
        };
    }
    focus() {
        this.$.icon.focus();
    }
    computeHideLabelWrapper_() {
        return !(this.label || this.usingSlottedLabel);
    }
    getIcon_() {
        return this.external ? 'cr:open-in-new' : 'cr:arrow-right';
    }
    computeButtonAriaDescription_(external, buttonAriaDescription) {
        return buttonAriaDescription ??
            (external ? loadTimeData.getString('opensInNewTab') : '');
    }
}
customElements.define(CrLinkRowElement.is, CrLinkRowElement);

const styleMod$a = document.createElement('dom-module');
styleMod$a.appendChild(html `
  <template>
    <style>
.search-bubble{--search-bubble-color:#ffeb3b;position:absolute;z-index:1}.search-bubble-innards{align-items:center;background-color:var(--search-bubble-color);border-radius:2px;color:var(--google-grey-900);max-width:100px;min-width:64px;overflow:hidden;padding:4px 10px;text-align:center;text-overflow:ellipsis;white-space:nowrap}.search-bubble-innards::after{background-color:var(--search-bubble-color);content:'';height:10px;left:calc(50% - 5px);position:absolute;top:-5px;transform:rotate(-45deg);width:10px;z-index:-1}.search-bubble-innards.above::after{bottom:-5px;top:auto;transform:rotate(-135deg)}
    </style>
  </template>
`.content);
styleMod$a.register('search-highlight-style');

const sheet$1 = new CSSStyleSheet();
sheet$1.replaceSync(`html{--settings-error-color:var(--google-red-700);--iron-icon-fill-color:var(--google-grey-700);--iron-icon-height:var(--cr-icon-size);--iron-icon-width:var(--cr-icon-size);--cr-radio-group-item-padding:0;--settings-base-bg-color:var(--cros-sys-surface3);--settings-menu-padding-inline-end:16px;--settings-menu-padding-inline-start:16px;--settings-menu-padding-top:16px;--settings-menu-width:calc(var(--settings-menu-item-width) + var(--settings-menu-padding-inline-end) + var(--settings-menu-padding-inline-start));--settings-menu-item-border-width:2px;--settings-menu-item-width:256px;--settings-row-min-height:64px;--settings-toolbar-height:72px;--settings-toolbar-padding-inline-end:16px;--settings-toolbar-padding-inline-start:32px;--settings-toolbar-padding-inline-start-narrow:16px;--settings-toolbar-padding-top:0;--settings-toolbar-search-box-height:48px;--settings-toolbar-search-box-width:480px;--settings-toolbar-narrow-search-box-width:512px;--settings-toolbar-search-field-border-radius:24px}@media (prefers-color-scheme:dark){html{--iron-icon-fill-color:var(--google-grey-500);--settings-error-color:var(--google-red-300);--settings-base-bg-color:var(--cros-sys-app_base_shaded)}}`);
document.adoptedStyleSheets = [...document.adoptedStyleSheets, sheet$1];

const styleMod$9 = document.createElement('dom-module');
styleMod$9.appendChild(html `
  <template>
    <style>
:host-context([cros]) a:not(.item)[href]{color:var(--cros-link-color)}:host-context([cros]) cr-button[has-prefix-icon_],:host-context([cros]) cr-button[has-suffix-icon_]{--iron-icon-fill-color:currentColor}:host-context([cros]) cr-radio-button{--cr-radio-button-checked-color:var(--cros-radio-button-color);--cr-radio-button-checked-ripple-color:var(--cros-radio-button-ripple-color);--cr-radio-button-unchecked-color:var(--cros-radio-button-color-unchecked);--cr-radio-button-unchecked-ripple-color:var(--cros-radio-button-ripple-color-unchecked)}:host-context([cros]) cr-toggle{--cr-toggle-checked-bar-color:var(--cros-switch-track-color-active);--cr-toggle-checked-bar-opacity:100%;--cr-toggle-checked-button-color:var(--cros-switch-knob-color-active);--cr-toggle-checked-ripple-color:var(--cros-focus-aura-color);--cr-toggle-unchecked-bar-color:var(--cros-switch-track-color-inactive);--cr-toggle-unchecked-button-color:var(--cros-switch-knob-color-inactive);--cr-toggle-unchecked-ripple-color:var(--cros-ripple-color);--cr-toggle-box-shadow:var(--cros-elevation-1-shadow);--cr-toggle-ripple-diameter:32px}:host-context([cros]):host-context(.focus-outline-visible) cr-toggle:focus{--cr-toggle-ripple-ring:2px solid var(--cros-focus-ring-color)}:host-context([cros]) paper-spinner-lite{--paper-spinner-color:var(--cros-icon-color-prominent)}:host-context(body.jelly-enabled){--cros-button-label-color-primary:var(--cros-sys-on_primary);--cros-link-color:var(--cros-sys-primary);--cros-separator-color:var(--cros-sys-separator);--cros-tab-slider-track-color:var(--cros-sys-surface_variant,80%);--cr-form-field-label-color:var(--cros-sys-on_surface);--cr-link-color:var(--cros-sys-primary);--cr-primary-text-color:var(--cros-sys-on_surface);--cr-secondary-text-color:var(--cros-sys-on_surface_variant)}:host-context([cros][chrome-refresh-2023]){--cr-focus-outline-color:var(--cros-sys-focus_ring);--cr-disabled-opacity:var(--cros-disabled-opacity)}:host-context(body.jelly-enabled) cr-button{--text-color:var(--cros-sys-on_primary_container);--ink-color:var(--cros-sys-ripple_primary);--iron-icon-fill-color:currentColor;--hover-bg-color:var(--cros-sys-hover_on_subtle);--ripple-opacity:.1;--bg-action:var(--cros-sys-primary);--ink-color-action:var(--cros-sys-ripple_primary);--text-color-action:var(--cros-sys-on_primary);--hover-bg-action:var(--cros-sys-hover_on_prominent);--ripple-opacity-action:1;--disabled-bg:var(--cros-sys-disabled_container);--disabled-bg-action:var(--cros-sys-disabled_container);--disabled-text-color:var(--cros-sys-disabled);background-color:var(--cros-sys-primary_container);border:none}:host-context(body.jelly-enabled) cr-button:hover::part(hoverBackground){background-color:var(--hover-bg-color);display:block}:host-context(body.jelly-enabled) cr-button:active,:host-context(body.jelly-enabled) cr-button.action-button:not(:active):hover{box-shadow:none}:host-context(body.jelly-enabled) cr-button.action-button{background-color:var(--bg-action)}:host-context(body.jelly-enabled) cr-button.action-button:hover::part(hoverBackground){background-color:var(--hover-bg-action)}:host-context(body.jelly-enabled) cr-button[disabled]{background-color:var(--cros-sys-disabled_container)}:host-context(body.jelly-enabled):host-context(.focus-outline-visible) cr-button:focus{box-shadow:none;outline:2px solid var(--cros-sys-focus_ring)}:host-context(body.jelly-enabled) cr-checkbox{--cr-checkbox-checked-box-color:var(--cros-sys-primary);--cr-checkbox-ripple-checked-color:var(--cros-sys-ripple_primary);--cr-checkbox-checked-ripple-opacity:1;--cr-checkbox-mark-color:var(--cros-sys-inverse_on_surface);--cr-checkbox-ripple-unchecked-color:var(--cros-sys-ripple_primary);--cr-checkbox-unchecked-box-color:var(--cros-sys-on_surface);--cr-checkbox-unchecked-ripple-opacity:1}:host-context([cros][chrome-refresh-2023]) cr-checkbox{--cr-checkbox-focus-outline:none}:host-context([cros][chrome-refresh-2023]) cr-checkbox[disabled]{opacity:var(--cros-disabled-opacity)}:host-context([cros][chrome-refresh-2023]):host-context(.focus-outline-visible) cr-checkbox:focus{--cr-checkbox-ripple-ring:2px solid var(--cros-sys-focus_ring)}:host-context(body.jelly-enabled) cr-icon-button,:host-context(body.jelly-enabled) cr-link-row::part(icon),:host-context(body.jelly-enabled) cr-expand-button::part(icon){--cr-icon-button-fill-color:var(--cros-sys-secondary);--cr-icon-button-focus-outline-color:var(--cros-sys-focus_ring)}:host-context(body.jelly-enabled) cr-input,:host-context(body.jelly-enabled) cr-search-field::part(searchInput),:host-context(body.jelly-enabled) cr-searchable-drop-down::part(input),:host-context(body.jelly-enabled) cr-textarea{--cr-input-background-color:var(--cros-sys-input_field_on_base);--cr-input-error-color:var(--cros-sys-error);--cr-input-focus-color:var(--cros-sys-primary);--cr-input-placeholder-color:var(--cros-sys-secondary)}:host-context([cros][chrome-refresh-2023]) cr-input,:host-context([cros][chrome-refresh-2023]) cr-search-field::part(searchInput){--cr-input-background-color:var(--cros-sys-input_field_on_base);--cr-input-border:none;--cr-input-border-bottom:none;--cr-input-border-radius:8px;--cr-input-label-color:var(--cros-sys-on-surface);--cr-input-padding-start:16px;--cr-input-padding-end:16px;--cr-input-placeholder-color:var(--cros-sys-secondary);--cr-input-underline-display:none;font:var(--cros-body-2-font);--cr-input-focus-color:var(--cros-sys-primary);--cr-input-focus-label-color:var(--cros-sys-primary);--cr-input-focus-outline:2px solid var(--cros-sys-focus_ring);--cr-input-hover-background-color:transparent;--cr-input-error-color:var(--cros-sys-error)}:host-context([cros][chrome-refresh-2023]) cr-input[disabled]{color:currentColor;opacity:var(--cros-disabled-opacity)}:host-context([cros][chrome-refresh-2023]) cr-input[invalid]{--cr-input-focus-outline:2px solid var(--cros-sys-error)}:host-context([cros][chrome-refresh-2023]) cr-toolbar-search-field{--cr-toolbar-search-field-hover-background:none}:host-context([cros][chrome-refresh-2023]) .md-select{--md-arrow-width:7px;--md-select-bg-color:var(--cros-sys-input_field_on_base);--md-select-focus-shadow-color:transparent;--md-select-option-bg-color:var(--cros-sys-base_elevated);--md-select-side-padding:16px;--md-select-text-color:var(--cros-sys-on_surface);border:none;border-radius:8px;font:var(--cros-body-2-font);height:36px;line-height:36px}:host-context([cros][chrome-refresh-2023]) .md-select:hover{background-color:var(--md-select-bg-color)}:host-context([cros][chrome-refresh-2023]) .md-select[disabled]{background-color:var(--md-select-bg-color);border-color:transparent;color:var(--md-select-text-color);opacity:var(--cros-disabled-opacity)}:host-context(body.jelly-enabled),:host-context(body.jelly-enabled) cr-radio-button{--cr-radio-button-checked-color:var(--cros-sys-primary);--cr-radio-button-checked-ripple-color:var(--cros-sys-ripple_primary);--cr-radio-button-unchecked-color:var(--cros-sys-on_surface);--cr-radio-button-unchecked-ripple-color:var(--cros-sys-ripple_neutral_on_subtle)}:host-context([cros][chrome-refresh-2023]),:host-context([cros][chrome-refresh-2023]) cr-radio-button{--cr-radio-button-checked-color:var(--cros-sys-primary);--cr-radio-button-checked-ripple-color:var(--cros-sys-ripple_primary);--cr-radio-button-unchecked-color:var(--cros-sys-on_surface);--cr-radio-button-unchecked-ripple-color:var(--cros-sys-ripple_neutral_on_subtle);--cr-radio-button-ink-size:40px}:host-context([cros][chrome-refresh-2023]) cr-radio-button[disabled]{--cr-radio-button-checked-color:var(--cros-sys-disabled);--cr-radio-button-unchecked-color:var(--cros-sys-disabled)}:host-context(body.jelly-enabled) cr-card-radio-button{--cr-card-background-color:var(--cros-sys-app_base);--cr-checked-color:var(--cros-sys-primary);--cr-radio-button-checked-ripple-color:var(--cros-sys-ripple_primary);--hover-bg-color:var(--cros-sys-hover_on_subtle)}:host-context(body.jelly-enabled) cr-search-field{--cr-search-field-clear-icon-fill:var(--cros-sys-primary);--cr-search-field-clear-icon-margin-end:6px;--cr-search-field-input-border-bottom:none;--cr-search-field-input-padding-start:8px;--cr-search-field-input-underline-border-radius:4px;--cr-search-field-search-icon-display:none;--cr-search-field-search-icon-fill:var(--cros-sys-primary);--cr-search-field-search-icon-inline-display:block;--cr-search-field-search-icon-inline-margin-start:6px;border-radius:4px}:host-context([cros][chrome-refresh-2023]) cr-search-field{--cr-search-field-search-icon-fill:var(--cros-sys-secondary);--cr-search-field-search-icon-inline-margin-start:0;--cr-search-field-clear-icon-fill:var(--cros-sys-secondary);--cr-search-field-clear-icon-margin-end:6px;--cr-search-field-clear-icon-size:16px}:host-context([cros][chrome-refresh-2023]) cr-search-field::part(searchInput){--cr-input-padding-bottom:10px;--cr-input-padding-end:28px;--cr-input-padding-start:8px;--cr-input-padding-top:10px}:host-context(body.jelly-enabled) cr-slider{--cr-slider-active-color:var(--cros-sys-primary);--cr-slider-container-color:var(--cros-sys-primary_container);--cr-slider-container-disabled-color:var(--cros-sys-disabled_container);--cr-slider-disabled-color:var(--cros-sys-disabled);--cr-slider-knob-active-color:var(--cros-sys-primary);--cr-slider-knob-disabled-color:var(--cros-sys-disabled);--cr-slider-marker-active-color:var(--cros-sys-primary_container);--cr-slider-marker-color:var(--cros-sys-primary);--cr-slider-marker-disabled-color:var(--cros-sys-disabled);--cr-slider-ripple-color:var(--cros-sys-hover_on_prominent)}:host-context(body.jelly-enabled) cr-slider:not([disabled])::part(knob){background-color:var(--cros-sys-primary)}:host-context(body.jelly-enabled) cr-slider[disabled]::part(knob){border:none}:host-context(body.jelly-enabled) cr-slider::part(label){background:var(--cros-sys-primary);color:var(--cros-sys-on_primary)}:host-context(body.jelly-enabled) cr-toggle{--cr-toggle-checked-bar-color:var(--cros-sys-primary_container);--cr-toggle-checked-bar-opacity:100%;--cr-toggle-checked-button-color:var(--cros-sys-primary);--cr-toggle-checked-ripple-color:var(--cros-sys-hover_on_prominent);--cr-toggle-unchecked-bar-color:var(--cros-sys-secondary);--cr-toggle-unchecked-button-color:var(--cros-sys-surface_variant);--cr-toggle-unchecked-ripple-color:var(--cros-sys-hover_on_prominent);--cr-toggle-box-shadow:var(--cros-sys-app-elevation-1-shadow);--cr-toggle-ripple-diameter:32px}:host-context(body.jelly-enabled):host-context(.focus-outline-visible) cr-toggle:focus{--cr-toggle-ripple-ring:2px solid var(--cros-sys-focus_ring)}:host-context([cros][chrome-refresh-2023]) cr-toggle{--cr-toggle-bar-width:32px;--cr-toggle-knob-diameter:12px;--cr-toggle-bar-border:none;--cr-toggle-checked-bar-color:var(--cros-sys-primary);--cr-toggle-checked-button-color:var(--cros-sys-on_primary);--cr-toggle-unchecked-bar-color:var(--cros-sys-secondary);--cr-toggle-unchecked-button-color:var(--cros-sys-on_secondary);--color-toggle-button-thumb-on-hover:var(--cros-sys-on_primary);--cr-toggle-disabled-opacity:var(--cros-disabled-opacity)}:host-context([cros][chrome-refresh-2023]):host-context(.focus-outline-visible) cr-toggle:focus{--cr-toggle-ripple-ring:none}:host-context(body.jelly-enabled) paper-tooltip{--paper-tooltip-background:var(--cros-sys-on_surface);--paper-tooltip-border-radius:4px;--paper-tooltip-padding:5px 8px;--paper-tooltip-text-color:var(--cros-sys-inverse_on_surface)}:host-context(body.jelly-enabled) paper-tooltip::part(tooltip){font:var(--cros-annotation-1-font)}
    </style>
  </template>
`.content);
styleMod$9.register('cros-color-overrides');

const styleMod$8 = document.createElement('dom-module');
styleMod$8.appendChild(html `
  <template>
    <style include="cr-shared-style search-highlight-style cros-color-overrides">
a[is=action-link]{user-select:none}h2{align-items:center;align-self:flex-start;color:var(--cr-secondary-text-color);display:flex;font-size:inherit;font-weight:500;margin:0;padding-bottom:12px;padding-top:32px}iron-icon{flex-shrink:0}iron-icon.policy{margin-inline-end:var(--cr-controlled-by-spacing)}iron-list{user-select:none}iron-list[risk-selection]{user-select:text}.separator+cr-icon-button{margin-inline-start:var(--cr-icon-ripple-margin)}.settings-box settings-toggle-button cr-button:last-of-type{margin-inline-end:16px}.settings-box cr-button+cr-button,.settings-box cr-button+controlled-button,.settings-box controlled-button+controlled-button,.settings-box controlled-button+cr-button{margin-inline-start:8px}a[href]{color:var(--cr-link-color)}a[href]:focus{outline-color:var(--cros-sys-focus_ring)}.primary-toggle{color:var(--cros-sys-on_surface_variant);font:var(--cros-button-2-font)}.primary-toggle[on],.primary-toggle[checked]{color:var(--cros-sys-primary)}collapse-radio-button,controlled-radio-button,cr-radio-button{min-height:var(--cr-section-min-height)}cr-radio-group{width:100%}.text-elide{overflow:hidden;text-overflow:ellipsis;white-space:nowrap}.no-min-width{min-width:0}.link-wrapper{align-items:center;display:flex;flex-grow:1}.list-frame{display:block;padding-block-end:0;padding-block-start:0;padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-indent-padding)}.list-item{align-items:center;display:flex;min-height:var(--cr-section-min-height);padding:0}.list-item.underbar{border-bottom:var(--cr-separator-line)}.list-item.selected{font-weight:500}.list-item .middle{flex:1;margin:8px 16px}.list-item>.start{flex:1}.list-button[is='action-link']{align-items:center;display:flex;flex:1;font-weight:500;min-height:inherit}:host-context(html:not(.focus-outline-visible)) .list-button[is='action-link']{outline:none}.two-line{min-height:var(--cr-section-two-line-min-height)}.settings-box{align-items:center;border-top:var(--cr-separator-line);display:flex;min-height:var(--settings-row-min-height);padding:0 var(--cr-section-padding)}cr-link-row,settings-toggle-button{min-height:var(--settings-row-min-height)}.settings-box.no-padding{padding:0}.settings-box.no-padding .margin-matches-padding{margin:0 var(--cr-section-padding)}.settings-box.no-padding>.link-wrapper{padding:0 var(--cr-section-padding)}.settings-box.two-line{min-height:var(--cr-section-two-line-min-height)}.settings-box-text{box-sizing:border-box;padding-bottom:var(--cr-section-vertical-padding);padding-top:var(--cr-section-vertical-padding);padding-inline-end:20px}.settings-box.first,.settings-box.continuation{border-top:none}h2.first{padding-top:0}.settings-box.block{display:block}.single-column{align-items:flex-start;flex-direction:column;justify-content:center}.settings-box.line-only{min-height:0}.settings-box.embedded{padding-inline-start:var(--cr-section-indent-padding)}.secondary{color:var(--cr-secondary-text-color);font-weight:400}.secondary:empty{margin:0}.settings-box .middle{align-items:center;flex:auto;padding-inline-start:16px}.settings-box .middle.two-line,.settings-box .start.two-line{display:flex}.settings-box .start{align-items:center;flex:auto}.settings-box[actionable-row]{cursor:pointer}.settings-box[actionable-row]:hover{background-color:var(--cr-hover-background-color)}.settings-box[actionable-row]:active{background-color:var(--cr-active-background-color)}.settings-box[actionable-row] cr-icon-button{--cr-icon-button-hover-background-color:transparent;--cr-icon-button-active-background-color:transparent}.settings-row{align-items:center;display:flex;flex-direction:row;max-width:100%;min-width:0}.no-outline{background:none;outline:none}[scrollable],iron-list,.list-item{--cr-icon-button-margin-end:0}.vertical-list>*:not(:first-of-type){border-top:var(--cr-separator-line)}.separator{border-inline-start:var(--cr-separator-line);flex-shrink:0;height:32px;margin:0 16px}.settings-box.no-padding>.link-wrapper~.separator{margin:0}cr-toast .error-message{padding-bottom:15px;padding-top:15px;text-align:center;white-space:normal}cr-dialog>[slot='title']{font:var(--cros-title-1-font)}controlled-button,cr-button{font:var(--cros-button-2-font)}cr-link-row{--cr-link-row-start-icon-color:var(--cros-sys-primary)}
    </style>
  </template>
`.content);
styleMod$8.register('settings-shared');

// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * The class name to set on the document element.
 */
const CLASS_NAME = 'focus-outline-visible';
const docsToManager = new Map();
/**
 * This class sets a CSS class name on the HTML element of |doc| when the user
 * presses a key. It removes the class name when the user clicks anywhere.
 *
 * This allows you to write CSS like this:
 *
 * html.focus-outline-visible my-element:focus {
 *   outline: 5px auto -webkit-focus-ring-color;
 * }
 *
 * And the outline will only be shown if the user uses the keyboard to get to
 * it.
 *
 */
class FocusOutlineManager {
    // Whether focus change is triggered by a keyboard event.
    focusByKeyboard_ = true;
    classList_;
    /**
     * @param doc The document to attach the focus outline manager to.
     */
    constructor(doc) {
        this.classList_ = doc.documentElement.classList;
        doc.addEventListener('keydown', (e) => this.onEvent_(true, e), true);
        doc.addEventListener('mousedown', (e) => this.onEvent_(false, e), true);
        this.updateVisibility();
    }
    onEvent_(focusByKeyboard, e) {
        if (this.focusByKeyboard_ === focusByKeyboard) {
            return;
        }
        if (e instanceof KeyboardEvent && e.repeat) {
            // A repeated keydown should not trigger the focus state. For example,
            // there is a repeated ALT keydown if ALT+CLICK is used to open the
            // context menu and ALT is not released.
            return;
        }
        this.focusByKeyboard_ = focusByKeyboard;
        this.updateVisibility();
    }
    updateVisibility() {
        this.visible = this.focusByKeyboard_;
    }
    /**
     * Whether the focus outline should be visible.
     */
    set visible(visible) {
        this.classList_.toggle(CLASS_NAME, visible);
    }
    get visible() {
        return this.classList_.contains(CLASS_NAME);
    }
    /**
     * Gets a per document singleton focus outline manager.
     * @param doc The document to get the |FocusOutlineManager| for.
     * @return The per document singleton focus outline manager.
     */
    static forDocument(doc) {
        let manager = docsToManager.get(doc);
        if (!manager) {
            manager = new FocusOutlineManager(doc);
            docsToManager.set(doc, manager);
        }
        return manager;
    }
}

function getTemplate$1L() {
    return html `<!--_html_template_start_--><style include="cr-hidden-style">:host{--active-shadow-rgb:var(--google-grey-800-rgb);--active-shadow-action-rgb:var(--google-blue-500-rgb);--bg-action:var(--google-blue-600);--border-color:var(--google-grey-300);--disabled-bg-action:var(--google-grey-100);--disabled-bg:white;--disabled-border-color:var(--google-grey-100);--disabled-text-color:var(--google-grey-600);--focus-shadow-color:rgba(var(--google-blue-600-rgb),.4);--hover-bg-action:rgba(var(--google-blue-600-rgb),.9);--hover-bg-color:rgba(var(--google-blue-500-rgb),.04);--hover-border-color:var(--google-blue-100);--hover-shadow-action-rgb:var(--google-blue-500-rgb);--ink-color-action:white;--ink-color:var(--google-blue-600);--ripple-opacity-action:.32;--ripple-opacity:.1;--text-color-action:white;--text-color:var(--google-blue-600)}@media (prefers-color-scheme:dark){:host{--active-bg:black linear-gradient(rgba(255,255,255,.06),rgba(255,255,255,.06));--active-shadow-rgb:0,0,0;--active-shadow-action-rgb:var(--google-blue-500-rgb);--bg-action:var(--google-blue-300);--border-color:var(--google-grey-700);--disabled-bg-action:var(--google-grey-800);--disabled-bg:transparent;--disabled-border-color:var(--google-grey-800);--disabled-text-color:var(--google-grey-500);--focus-shadow-color:rgba(var(--google-blue-300-rgb),.5);--hover-bg-action:var(--bg-action) linear-gradient(rgba(0,0,0,.08),rgba(0,0,0,.08));--hover-bg-color:rgba(var(--google-blue-300-rgb),.08);--ink-color-action:black;--ink-color:var(--google-blue-300);--ripple-opacity-action:.16;--ripple-opacity:.16;--text-color-action:var(--google-grey-900);--text-color:var(--google-blue-300)}}:host{--paper-ripple-opacity:var(--ripple-opacity);-webkit-tap-highlight-color:transparent;align-items:center;border:1px solid var(--border-color);border-radius:4px;box-sizing:border-box;color:var(--text-color);cursor:pointer;display:inline-flex;flex-shrink:0;font-weight:500;height:var(--cr-button-height);justify-content:center;min-width:5.14em;outline-width:0;overflow:hidden;padding:8px 16px;position:relative;user-select:none}:host-context([chrome-refresh-2023]):host{--border-color:var(--color-button-border,var(--cr-fallback-color-tonal-outline));--text-color:var(--color-button-foreground,var(--cr-fallback-color-primary));--hover-bg-color:transparent;--hover-border-color:var(--border-color);--active-bg:transparent;--active-shadow:none;--ink-color:var(--cr-active-background-color);--ripple-opacity:1;--disabled-bg:transparent;--disabled-border-color:var(--color-button-border-disabled,var(--cr-fallback-color-disabled-background));--disabled-text-color:var(--color-button-foreground-disabled,var(--cr-fallback-color-disabled-foreground));--bg-action:var(--color-button-background-prominent,var(--cr-fallback-color-primary));--text-color-action:var(--color-button-foreground-prominent,var(--cr-fallback-color-on-primary));--hover-bg-action:var(--bg-action);--active-shadow-action:none;--ink-color-action:var(--cr-active-background-color);--ripple-opacity-action:1;--disabled-bg-action:var(--color-button-background-prominent-disabled,var(--cr-fallback-color-disabled-background));background:transparent;border-radius:100px;isolation:isolate;line-height:20px}:host([has-prefix-icon_]),:host([has-suffix-icon_]){--iron-icon-height:16px;--iron-icon-width:16px;gap:8px;padding:8px}:host-context([chrome-refresh-2023]):host([has-prefix-icon_]),:host-context([chrome-refresh-2023]):host([has-suffix-icon_]){--iron-icon-height:20px;--iron-icon-width:20px;--icon-block-padding-large:16px;--icon-block-padding-small:12px;padding-block-end:8px;padding-block-start:8px}:host-context([chrome-refresh-2023]):host([has-prefix-icon_]){padding-inline-end:var(--icon-block-padding-large);padding-inline-start:var(--icon-block-padding-small)}:host-context([chrome-refresh-2023]):host([has-suffix-icon_]){padding-inline-end:var(--icon-block-padding-small);padding-inline-start:var(--icon-block-padding-large)}:host-context(.focus-outline-visible):host(:focus){box-shadow:0 0 0 2px var(--focus-shadow-color)}@media (forced-colors:active){:host-context(.focus-outline-visible):host(:focus){outline:var(--cr-focus-outline-hcm)}:host-context([chrome-refresh-2023]):host{forced-color-adjust:none}}:host-context([chrome-refresh-2023].focus-outline-visible):host(:focus){box-shadow:none;outline:2px solid var(--cr-focus-outline-color);outline-offset:2px}:host(:active){background:var(--active-bg);box-shadow:var(--active-shadow,0 1px 2px 0 rgba(var(--active-shadow-rgb),.3),0 3px 6px 2px rgba(var(--active-shadow-rgb),.15))}:host(:hover){background-color:var(--hover-bg-color)}@media (prefers-color-scheme:light){:host(:hover){border-color:var(--hover-border-color)}}#background{border-radius:inherit;inset:0;pointer-events:none;position:absolute;z-index:0}:host-context([chrome-refresh-2023]):host(:hover) #background{background-color:var(--hover-bg-color)}:host-context([chrome-refresh-2023].focus-outline-visible):host(:focus) #background{background-clip:padding-box}:host-context([chrome-refresh-2023]):host(.action-button) #background{background-color:var(--bg-action)}:host-context([chrome-refresh-2023]):host([disabled]) #background{background-color:var(--disabled-bg)}:host-context([chrome-refresh-2023]):host(.action-button[disabled]) #background{background-color:var(--disabled-bg-action)}:host-context([chrome-refresh-2023]):host(.tonal-button) #background,:host-context([chrome-refresh-2023]):host(.floating-button) #background{background-color:var(--color-button-background-tonal,var(--cr-fallback-color-secondary-container))}:host-context([chrome-refresh-2023]):host([disabled].tonal-button) #background,:host-context([chrome-refresh-2023]):host([disabled].floating-button) #background{background-color:var(--color-button-background-tonal-disabled,var(--cr-fallback-color-disabled-background))}#content{display:contents}:host-context([chrome-refresh-2023]) #content{display:inline;z-index:2}:host-context([chrome-refresh-2023]) ::slotted(*){z-index:2}#hoverBackground{content:'';display:none;inset:0;pointer-events:none;position:absolute;z-index:1}:host-context([chrome-refresh-2023]):host(:hover) #hoverBackground{background:var(--cr-hover-background-color);display:block}:host-context([chrome-refresh-2023]):host(.action-button:hover) #hoverBackground{background:var(--cr-hover-on-prominent-background-color)}:host(.action-button){--ink-color:var(--ink-color-action);--paper-ripple-opacity:var(--ripple-opacity-action);background-color:var(--bg-action);border:none;color:var(--text-color-action)}:host-context([chrome-refresh-2023]):host(.action-button){--ink-color:var(--cr-active-on-primary-background-color);background-color:transparent}:host(.action-button:active){box-shadow:var(--active-shadow-action,0 1px 2px 0 rgba(var(--active-shadow-action-rgb),.3),0 3px 6px 2px rgba(var(--active-shadow-action-rgb),.15))}:host(.action-button:hover){background:var(--hover-bg-action)}@media (prefers-color-scheme:light){:host(.action-button:not(:active):hover){box-shadow:0 1px 2px 0 rgba(var(--hover-shadow-action-rgb),.3),0 1px 3px 1px rgba(var(--hover-shadow-action-rgb),.15)}:host-context([chrome-refresh-2023]):host(.action-button:not(:active):hover){box-shadow:none}}:host([disabled]){background-color:var(--disabled-bg);border-color:var(--disabled-border-color);color:var(--disabled-text-color);cursor:auto;pointer-events:none}:host(.action-button[disabled]){background-color:var(--disabled-bg-action);border-color:transparent}:host(.cancel-button){margin-inline-end:8px}:host(.action-button),:host(.cancel-button){line-height:154%}:host-context([chrome-refresh-2023]):host(.tonal-button),:host-context([chrome-refresh-2023]):host(.floating-button){border:none;color:var(--color-button-foreground-tonal,var(--cr-fallback-color-on-tonal-container))}:host-context([chrome-refresh-2023]):host(.tonal-button[disabled]),:host-context([chrome-refresh-2023]):host(.floating-button[disabled]){border:none;color:var(--disabled-text-color)}:host-context([chrome-refresh-2023]):host(.floating-button){border-radius:8px;height:40px;transition:box-shadow 80ms linear}:host-context([chrome-refresh-2023]):host(.floating-button:hover){box-shadow:var(--cr-elevation-3)}paper-ripple{color:var(--ink-color);height:var(--paper-ripple-height);left:var(--paper-ripple-left,0);top:var(--paper-ripple-top,0);width:var(--paper-ripple-width)}:host-context([chrome-refresh-2023]) paper-ripple{z-index:1}</style>

<div id="background"></div>
<slot id="prefixIcon" name="prefix-icon"
    on-slotchange="onPrefixIconSlotChanged_">
</slot>
<span id="content"><slot></slot></span>
<slot id="suffixIcon" name="suffix-icon"
    on-slotchange="onSuffixIconSlotChanged_">
</slot>
<div id="hoverBackground" part="hoverBackground"></div>
<!--_html_template_end_-->`;
}

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'cr-button' is a button which displays slotted elements. It can
 * be interacted with like a normal button using click as well as space and
 * enter to effectively click the button and fire a 'click' event. It can also
 * style an icon inside of the button with the [has-icon] attribute.
 *
 * Forked from ui/webui/resources/cr_elements/cr_button/cr_button.ts
 */
const CrButtonElementBase = PaperRippleMixin(PolymerElement);
class CrButtonElement extends CrButtonElementBase {
    static get is() {
        return 'cr-button';
    }
    static get template() {
        return getTemplate$1L();
    }
    static get properties() {
        return {
            disabled: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
                observer: 'disabledChanged_',
            },
            /**
             * Use this property in order to configure the "tabindex" attribute.
             */
            customTabIndex: {
                type: Number,
                observer: 'applyTabIndex_',
            },
            /**
             * Flag used for formatting ripples on circle shaped cr-buttons.
             * @private
             */
            circleRipple: {
                type: Boolean,
                value: false,
            },
            hasPrefixIcon_: {
                type: Boolean,
                reflectToAttribute: true,
                value: false,
            },
            hasSuffixIcon_: {
                type: Boolean,
                reflectToAttribute: true,
                value: false,
            },
        };
    }
    constructor() {
        super();
        /**
         * It is possible to activate a tab when the space key is pressed down. When
         * this element has focus, the keyup event for the space key should not
         * perform a 'click'. |spaceKeyDown_| tracks when a space pressed and
         * handled by this element. Space keyup will only result in a 'click' when
         * |spaceKeyDown_| is true. |spaceKeyDown_| is set to false when element
         * loses focus.
         */
        this.spaceKeyDown_ = false;
        this.timeoutIds_ = new Set();
        this.addEventListener('blur', this.onBlur_.bind(this));
        // Must be added in constructor so that stopImmediatePropagation() works as
        // expected.
        this.addEventListener('click', this.onClick_.bind(this));
        this.addEventListener('keydown', this.onKeyDown_.bind(this));
        this.addEventListener('keyup', this.onKeyUp_.bind(this));
        this.addEventListener('pointerdown', this.onPointerDown_.bind(this));
    }
    ready() {
        super.ready();
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'button');
        }
        if (!this.hasAttribute('tabindex')) {
            this.setAttribute('tabindex', '0');
        }
        if (!this.hasAttribute('aria-disabled')) {
            this.setAttribute('aria-disabled', this.disabled ? 'true' : 'false');
        }
        FocusOutlineManager.forDocument(document);
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        this.timeoutIds_.forEach(clearTimeout);
        this.timeoutIds_.clear();
    }
    setTimeout_(fn, delay) {
        if (!this.isConnected) {
            return;
        }
        const id = setTimeout(() => {
            this.timeoutIds_.delete(id);
            fn();
        }, delay);
        this.timeoutIds_.add(id);
    }
    disabledChanged_(newValue, oldValue) {
        if (!newValue && oldValue === undefined) {
            return;
        }
        if (this.disabled) {
            this.blur();
        }
        this.setAttribute('aria-disabled', this.disabled ? 'true' : 'false');
        this.applyTabIndex_();
    }
    /**
     * Updates the tabindex HTML attribute to the actual value.
     */
    applyTabIndex_() {
        let value = this.customTabIndex;
        if (value === undefined) {
            value = this.disabled ? -1 : 0;
        }
        this.setAttribute('tabindex', value.toString());
    }
    onBlur_() {
        this.spaceKeyDown_ = false;
        // If a keyup event is never fired (e.g. after keydown the focus is moved to
        // another element), we need to clear the ripple here. 100ms delay was
        // chosen manually as a good time period for the ripple to be visible.
        this.setTimeout_(() => this.getRipple().uiUpAction(), 100);
    }
    onClick_(e) {
        if (this.disabled) {
            e.stopImmediatePropagation();
        }
    }
    onPrefixIconSlotChanged_() {
        this.hasPrefixIcon_ = this.$.prefixIcon.assignedElements().length > 0;
    }
    onSuffixIconSlotChanged_() {
        this.hasSuffixIcon_ = this.$.suffixIcon.assignedElements().length > 0;
    }
    onKeyDown_(e) {
        if (e.key !== ' ' && e.key !== 'Enter') {
            return;
        }
        e.preventDefault();
        e.stopPropagation();
        if (e.repeat) {
            return;
        }
        this.getRipple().uiDownAction();
        if (e.key === 'Enter') {
            this.click();
            // Delay was chosen manually as a good time period for the ripple to be
            // visible.
            this.setTimeout_(() => this.getRipple().uiUpAction(), 100);
        }
        else if (e.key === ' ') {
            this.spaceKeyDown_ = true;
        }
    }
    onKeyUp_(e) {
        if (e.key !== ' ' && e.key !== 'Enter') {
            return;
        }
        e.preventDefault();
        e.stopPropagation();
        if (this.spaceKeyDown_ && e.key === ' ') {
            this.spaceKeyDown_ = false;
            this.click();
            this.getRipple().uiUpAction();
        }
    }
    onPointerDown_() {
        this.ensureRipple();
    }
    /**
     * Customize the element's ripple. Overriding the '_createRipple' function
     * from PaperRippleMixin.
     */
    /* eslint-disable-next-line @typescript-eslint/naming-convention */
    _createRipple() {
        const ripple = super._createRipple();
        if (this.circleRipple) {
            ripple.setAttribute('center', '');
            ripple.classList.add('circle');
        }
        return ripple;
    }
}
customElements.define(CrButtonElement.is, CrButtonElement);

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Verify |value| is truthy.
 * @param value A value to check for truthiness. Note that this
 *     may be used to test whether |value| is defined or not, and we don't want
 *     to force a cast to boolean.
 */
function assert$1(value, message) {
    if (value) {
        return;
    }
    throw new Error('Assertion failed' + (message ? `: ${message}` : ''));
}
function assertInstanceof$1(value, type, message) {
    if (value instanceof type) {
        return;
    }
    throw new Error(message || `Value ${value} is not of type ${type.name || typeof type}`);
}
/**
 * Call this from places in the code that should never be reached.
 *
 * For example, handling all the values of enum with a switch() like this:
 *
 *   function getValueFromEnum(enum) {
 *     switch (enum) {
 *       case ENUM_FIRST_OF_TWO:
 *         return first
 *       case ENUM_LAST_OF_TWO:
 *         return last;
 *     }
 *     assertNotReached();
 *   }
 *
 * This code should only be hit in the case of serious programmer error or
 * unexpected input.
 */
function assertNotReached$1(message = 'Unreachable code hit') {
    assert$1(false, message);
}

// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview CrContainerShadowMixin holds logic for showing a drop shadow
 * near the top of a container element, when the content has scrolled.
 *
 * Forked from ui/webui/resources/cr_elements/cr_container_shadow_mixin.ts
 *
 * Elements using this mixin are expected to define a #container element,
 * which is the element being scrolled. If the #container element has a
 * show-bottom-shadow attribute, a drop shadow will also be shown near the
 * bottom of the container element, when there is additional content to scroll
 * to. Examples:
 *
 * For both top and bottom shadows:
 * <div id="container" show-bottom-shadow>...</div>
 *
 * For top shadow only:
 * <div id="container">...</div>
 *
 * The mixin will take care of inserting an element with ID
 * 'cr-container-shadow-top' which holds the drop shadow effect, and,
 * optionally, an element with ID 'cr-container-shadow-bottom' which holds the
 * same effect. A 'has-shadow' CSS class is automatically added to/removed from
 * both elements while scrolling, as necessary. Note that the show-bottom-shadow
 * attribute is inspected only during attached(), and any changes to it that
 * occur after that point will not be respected.
 *
 * Clients should either use the existing shared styling in
 * cr_shared_style.css, '#cr-container-shadow-[top/bottom]' and
 * '#cr-container-shadow-[top/bottom].has-shadow', or define their own styles.
 */
var CrContainerShadowSide;
(function (CrContainerShadowSide) {
    CrContainerShadowSide["TOP"] = "top";
    CrContainerShadowSide["BOTTOM"] = "bottom";
})(CrContainerShadowSide || (CrContainerShadowSide = {}));
const CrContainerShadowMixin = dedupingMixin((superClass) => {
    class CrContainerShadowMixin extends superClass {
        constructor() {
            super(...arguments);
            this.intersectionObserver_ = null;
            this.dropShadows_ = new Map();
            this.intersectionProbes_ = new Map();
            this.sides_ = null;
        }
        connectedCallback() {
            super.connectedCallback();
            const hasBottomShadow = this.getContainer_().hasAttribute('show-bottom-shadow');
            this.sides_ = hasBottomShadow ?
                [CrContainerShadowSide.TOP, CrContainerShadowSide.BOTTOM] :
                [CrContainerShadowSide.TOP];
            this.sides_.forEach(side => {
                // The element holding the drop shadow effect to be shown.
                const shadow = document.createElement('div');
                shadow.id = `cr-container-shadow-${side}`;
                shadow.classList.add('cr-container-shadow');
                this.dropShadows_.set(side, shadow);
                this.intersectionProbes_.set(side, document.createElement('div'));
            });
            this.getContainer_().parentNode.insertBefore(this.dropShadows_.get(CrContainerShadowSide.TOP), this.getContainer_());
            this.getContainer_().prepend(this.intersectionProbes_.get(CrContainerShadowSide.TOP));
            if (hasBottomShadow) {
                this.getContainer_().parentNode.insertBefore(this.dropShadows_.get(CrContainerShadowSide.BOTTOM), this.getContainer_().nextSibling);
                this.getContainer_().append(this.intersectionProbes_.get(CrContainerShadowSide.BOTTOM));
            }
            this.enableShadowBehavior(true);
        }
        disconnectedCallback() {
            super.disconnectedCallback();
            this.enableShadowBehavior(false);
        }
        getContainer_() {
            return this.shadowRoot.querySelector('#container');
        }
        getIntersectionObserver_() {
            const callback = (entries) => {
                // In some rare cases, there could be more than one entry per
                // observed element, in which case the last entry's result
                // stands.
                for (const entry of entries) {
                    const target = entry.target;
                    this.sides_.forEach(side => {
                        if (target === this.intersectionProbes_.get(side)) {
                            this.dropShadows_.get(side).classList.toggle('has-shadow', entry.intersectionRatio === 0);
                        }
                    });
                }
            };
            return new IntersectionObserver(callback, { root: this.getContainer_(), threshold: 0 });
        }
        /**
         * @param enable Whether to enable the mixin or disable it.
         *     This function does nothing if the mixin is already in the
         *     requested state.
         */
        enableShadowBehavior(enable) {
            // Behavior is already enabled/disabled. Return early.
            if (enable === !!this.intersectionObserver_) {
                return;
            }
            if (!enable) {
                this.intersectionObserver_.disconnect();
                this.intersectionObserver_ = null;
                return;
            }
            this.intersectionObserver_ = this.getIntersectionObserver_();
            // Need to register the observer within a setTimeout() callback,
            // otherwise the drop shadow flashes once on startup, because of the
            // DOM modifications earlier in this function causing a relayout.
            window.setTimeout(() => {
                if (this.intersectionObserver_) {
                    // In case this is already detached.
                    this.intersectionProbes_.forEach(probe => {
                        this.intersectionObserver_.observe(probe);
                    });
                }
            });
        }
        /**
         * Shows the shadows. The shadow mixin must be disabled before
         * calling this method, otherwise the intersection observer might
         * show the shadows again.
         */
        showDropShadows() {
            assert$1(!this.intersectionObserver_);
            assert$1(this.sides_);
            for (const side of this.sides_) {
                this.dropShadows_.get(side).classList.toggle('has-shadow', true);
            }
        }
    }
    return CrContainerShadowMixin;
});

function getTemplate$1K() {
    return html `<!--_html_template_start_--><style include="cr-hidden-style cr-icons">dialog{--cr-dialog-background-color:var(--cros-sys-dialog_container);--cr-dialog-border-radius:20px;--cr-dialog-title-font:var(--cros-display-7-font);--scroll-border-color:#e0e0e0;--scroll-border:1px solid var(--scroll-border-color);background-color:var(--cr-dialog-background-color);border:0;border-radius:var(--cr-dialog-border-radius);bottom:50%;box-shadow:var(--cros-sys-app-elevation-3-shadow);color:inherit;max-height:initial;max-width:initial;overflow-y:hidden;padding:0;position:absolute;top:50%;width:var(--cr-dialog-width,512px)}@media (prefers-color-scheme:dark){dialog{--scroll-border-color:var(--google-grey-700)}}@media (forced-colors:active){dialog{border:var(--cr-border-hcm)}}dialog[open] #content-wrapper{display:flex;flex-direction:column;max-height:100vh;overflow:auto}.top-container,:host ::slotted([slot=button-container]),:host ::slotted([slot=footer]){flex-shrink:0}dialog::backdrop{background-color:rgba(0,0,0,0.6);bottom:0;left:0;position:fixed;right:0;top:0}:host ::slotted([slot=body]){color:var(--cr-secondary-text-color);padding:0 var(--cr-dialog-body-padding-horizontal,20px)}:host ::slotted([slot=title]){color:var(--cr-primary-text-color);flex:1;font:var(--cr-dialog-title-font);padding-bottom:var(--cr-dialog-title-slot-padding-bottom,16px);padding-inline-end:var(--cr-dialog-title-slot-padding-end,20px);padding-inline-start:var(--cr-dialog-title-slot-padding-start,20px);padding-top:var(--cr-dialog-title-slot-padding-top,20px)}:host ::slotted([slot=button-container]){display:flex;justify-content:flex-end;padding-bottom:var(--cr-dialog-button-container-padding-bottom,16px);padding-inline-end:var(--cr-dialog-button-container-padding-horizontal,16px);padding-inline-start:var(--cr-dialog-button-container-padding-horizontal,16px);padding-top:var(--cr-dialog-button-container-padding-top,16px)}:host ::slotted([slot=footer]){border-bottom-left-radius:inherit;border-bottom-right-radius:inherit;border-top:1px solid #dbdbdb;margin:0;padding:16px 20px}:host([hide-backdrop]) dialog::backdrop{opacity:0}@media (prefers-color-scheme:dark){:host ::slotted([slot=footer]){border-top-color:var(--cr-separator-color)}}.body-container{box-sizing:border-box;display:flex;flex-direction:column;min-height:1.375rem;overflow:auto}:host{--transparent-border:1px solid transparent}#cr-container-shadow-top{border-bottom:var(--cr-dialog-body-border-top,var(--transparent-border))}#cr-container-shadow-bottom{border-bottom:var(--cr-dialog-body-border-bottom,var(--transparent-border))}#cr-container-shadow-top.has-shadow,#cr-container-shadow-bottom.has-shadow{border-bottom:var(--scroll-border)}.top-container{align-items:flex-start;display:flex;min-height:var(--cr-dialog-top-container-min-height,31px)}.title-container{display:flex;flex:1;font-size:inherit;font-weight:inherit;margin:0;outline:none}#close{align-self:flex-start;margin-inline-end:4px;margin-top:4px}</style>
<dialog id="dialog" on-close="onNativeDialogClose_"
    on-cancel="onNativeDialogCancel_" part="dialog"
    aria-labelledby="title" aria-description$="[[ariaDescriptionText]]">
<!-- This wrapper is necessary, such that the "pulse" animation is not
    erroneously played when the user clicks on the outer-most scrollbar. -->
  <div id="content-wrapper" part="wrapper">
    <div class="top-container">
      <h2 id="title" class="title-container" tabindex="-1">
        <slot name="title"></slot>
      </h2>
      <cr-icon-button id="close" class="icon-clear"
          hidden$="[[!showCloseButton]]" aria-label$="[[closeText]]"
          on-click="cancel" on-keypress="onCloseKeypress_">
      </cr-icon-button>
    </div>
    <slot name="header"></slot>
    <div class="body-container" id="container" show-bottom-shadow
        part="body-container">
      <slot name="body"></slot>
    </div>
    <slot name="button-container"></slot>
    <slot name="footer"></slot>
  </div>
</dialog>
<!--_html_template_end_-->`;
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'cr-dialog' is a component for showing a modal dialog. If the
 * dialog is closed via close(), a 'close' event is fired. If the dialog is
 * canceled via cancel(), a 'cancel' event is fired followed by a 'close' event.
 *
 * Additionally clients can get a reference to the internal native <dialog> via
 * calling getNative() and inspecting the |returnValue| property inside
 * the 'close' event listener to determine whether it was canceled or just
 * closed, where a truthy value means success, and a falsy value means it was
 * canceled.
 *
 * Note that <cr-dialog> wrapper itself always has 0x0 dimensions, and
 * specifying width/height on <cr-dialog> directly will have no effect on the
 * internal native <dialog>. Instead use cr-dialog::part(dialog) to specify
 * width/height (as well as other available mixins to style other parts of the
 * dialog contents).
 *
 * Forked from ui/webui/resources/cr_elements/cr_dialog/cr_dialog.ts
 */
const CrDialogElementBase = CrContainerShadowMixin(PolymerElement);
class CrDialogElement extends CrDialogElementBase {
    constructor() {
        super(...arguments);
        this.intersectionObserver_ = null;
        this.mutationObserver_ = null;
        this.boundKeydown_ = null;
    }
    static get is() {
        return 'cr-dialog';
    }
    static get template() {
        return getTemplate$1K();
    }
    static get properties() {
        return {
            open: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
            },
            /**
             * Alt-text for the dialog close button.
             */
            closeText: String,
            /**
             * True if the dialog should remain open on 'popstate' events. This is
             * used for navigable dialogs that have their separate navigation handling
             * code.
             */
            ignorePopstate: {
                type: Boolean,
                value: false,
            },
            /**
             * True if the dialog should ignore 'Enter' keypresses.
             */
            ignoreEnterKey: {
                type: Boolean,
                value: false,
            },
            /**
             * True if the dialog should consume 'keydown' events. If ignoreEnterKey
             * is true, 'Enter' key won't be consumed.
             */
            consumeKeydownEvent: {
                type: Boolean,
                value: false,
            },
            /**
             * True if the dialog should not be able to be cancelled, which will
             * prevent 'Escape' key presses from closing the dialog.
             */
            noCancel: {
                type: Boolean,
                value: false,
            },
            // True if dialog should show the 'X' close button.
            showCloseButton: {
                type: Boolean,
                value: false,
            },
            showOnAttach: {
                type: Boolean,
                value: false,
            },
            /**
             * Text for the aria description.
             */
            ariaDescriptionText: String,
        };
    }
    ready() {
        super.ready();
        // If the active history entry changes (i.e. user clicks back button),
        // all open dialogs should be cancelled.
        window.addEventListener('popstate', () => {
            if (!this.ignorePopstate && this.$.dialog.open) {
                this.cancel();
            }
        });
        if (!this.ignoreEnterKey) {
            this.addEventListener('keypress', this.onKeypress_.bind(this));
        }
        this.addEventListener('pointerdown', e => this.onPointerdown_(e));
    }
    connectedCallback() {
        super.connectedCallback();
        const mutationObserverCallback = () => {
            if (this.$.dialog.open) {
                this.enableShadowBehavior(true);
                this.addKeydownListener_();
            }
            else {
                this.enableShadowBehavior(false);
                this.removeKeydownListener_();
            }
        };
        this.mutationObserver_ = new MutationObserver(mutationObserverCallback);
        this.mutationObserver_.observe(this.$.dialog, {
            attributes: true,
            attributeFilter: ['open'],
        });
        // In some cases dialog already has the 'open' attribute by this point.
        mutationObserverCallback();
        if (this.showOnAttach) {
            this.showModal();
        }
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        this.removeKeydownListener_();
        if (this.mutationObserver_) {
            this.mutationObserver_.disconnect();
            this.mutationObserver_ = null;
        }
    }
    addKeydownListener_() {
        if (!this.consumeKeydownEvent) {
            return;
        }
        this.boundKeydown_ = this.boundKeydown_ || this.onKeydown_.bind(this);
        this.addEventListener('keydown', this.boundKeydown_);
        // Sometimes <body> is key event's target and in that case the event
        // will bypass cr-dialog. We should consume those events too in order to
        // behave modally. This prevents accidentally triggering keyboard commands.
        document.body.addEventListener('keydown', this.boundKeydown_);
    }
    removeKeydownListener_() {
        if (!this.boundKeydown_) {
            return;
        }
        this.removeEventListener('keydown', this.boundKeydown_);
        document.body.removeEventListener('keydown', this.boundKeydown_);
        this.boundKeydown_ = null;
    }
    showModal() {
        this.$.dialog.showModal();
        assert$1(this.$.dialog.open);
        this.open = true;
        this.dispatchEvent(new CustomEvent('cr-dialog-open', { bubbles: true, composed: true }));
    }
    cancel() {
        this.dispatchEvent(new CustomEvent('cancel', { bubbles: true, composed: true }));
        this.$.dialog.close();
        assert$1(!this.$.dialog.open);
        this.open = false;
    }
    close() {
        this.$.dialog.close('success');
        assert$1(!this.$.dialog.open);
        this.open = false;
    }
    /**
     * Set the title of the dialog for a11y reader.
     * @param title Title of the dialog.
     */
    setTitleAriaLabel(title) {
        this.$.dialog.removeAttribute('aria-labelledby');
        this.$.dialog.setAttribute('aria-label', title);
    }
    onCloseKeypress_(e) {
        // Because the dialog may have a default Enter key handler, prevent
        // keypress events from bubbling up from this element.
        e.stopPropagation();
    }
    onNativeDialogClose_(e) {
        // Ignore any 'close' events not fired directly by the <dialog> element.
        if (e.target !== this.getNative()) {
            return;
        }
        // Catch and re-fire the 'close' event such that it bubbles across Shadow
        // DOM v1.
        this.dispatchEvent(new CustomEvent('close', { bubbles: true, composed: true }));
    }
    onNativeDialogCancel_(e) {
        // Ignore any 'cancel' events not fired directly by the <dialog> element.
        if (e.target !== this.getNative()) {
            return;
        }
        if (this.noCancel) {
            e.preventDefault();
            return;
        }
        // When the dialog is dismissed using the 'Esc' key, need to manually update
        // the |open| property (since close() is not called).
        this.open = false;
        // Catch and re-fire the native 'cancel' event such that it bubbles across
        // Shadow DOM v1.
        this.dispatchEvent(new CustomEvent('cancel', { bubbles: true, composed: true }));
    }
    /**
     * Expose the inner native <dialog> for some rare cases where it needs to be
     * directly accessed (for example to programmatically setheight/width, which
     * would not work on the wrapper).
     */
    getNative() {
        return this.$.dialog;
    }
    onKeypress_(e) {
        if (e.key !== 'Enter') {
            return;
        }
        // Accept Enter keys from either the dialog itself, or a child cr-input,
        // considering that the event may have been retargeted, for example if the
        // cr-input is nested inside another element. Also exclude inputs of type
        // 'search', since hitting 'Enter' on a search field most likely intends to
        // trigger searching.
        const accept = e.target === this ||
            e.composedPath().some(el => el.tagName === 'CR-INPUT' &&
                el.type !== 'search');
        if (!accept) {
            return;
        }
        const actionButton = this.querySelector('.action-button:not([disabled]):not([hidden])');
        if (actionButton) {
            actionButton.click();
            e.preventDefault();
        }
    }
    onKeydown_(e) {
        assert$1(this.consumeKeydownEvent);
        if (!this.getNative().open) {
            return;
        }
        if (this.ignoreEnterKey && e.key === 'Enter') {
            return;
        }
        // Stop propagation to behave modally.
        e.stopPropagation();
    }
    onPointerdown_(e) {
        // Only show pulse animation if user left-clicked outside of the dialog
        // contents.
        if (e.button !== 0 ||
            e.composedPath()[0].tagName !== 'DIALOG') {
            return;
        }
        this.$.dialog.animate([
            { transform: 'scale(1)', offset: 0 },
            { transform: 'scale(1.02)', offset: 0.4 },
            { transform: 'scale(1.02)', offset: 0.6 },
            { transform: 'scale(1)', offset: 1 },
        ], {
            duration: 180,
            easing: 'ease-in-out',
            iterations: 1,
        });
        // Prevent any text from being selected within the dialog when clicking in
        // the backdrop area.
        e.preventDefault();
    }
    focus() {
        const titleContainer = this.shadowRoot.querySelector('.title-container');
        assert$1(titleContainer);
        titleContainer.focus();
    }
}
customElements.define(CrDialogElement.is, CrDialogElement);

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Common prefs behavior.
 */
// clang-format off
const PrefsMixin = dedupingMixin((superClass) => {
    class PrefsMixin extends superClass {
        static get properties() {
            return {
                /** Preferences state. */
                prefs: {
                    type: Object,
                    notify: true,
                },
            };
        }
        /**
         * Gets the pref at the given prefPath. Throws if the pref is not found.
         */
        getPref(prefPath) {
            const pref = this.get(prefPath, this.prefs);
            assert$1(typeof pref !== 'undefined', 'Pref is missing: ' + prefPath);
            return pref;
        }
        /**
         * Sets the value of the pref at the given prefPath. Throws if the pref
         * is not found.
         */
        setPrefValue(prefPath, value) {
            this.getPref(prefPath); // Ensures we throw if the pref is not found.
            this.set('prefs.' + prefPath + '.value', value);
        }
        /**
         * Appends the item to the pref list at the given key if the item is not
         * already in the list. Asserts if the pref itself is not found or is
         * not an Array type.
         */
        appendPrefListItem(key, item) {
            const pref = this.getPref(key);
            assert$1(pref && pref.type === chrome.settingsPrivate.PrefType.LIST);
            if (pref.value.indexOf(item) === -1) {
                this.push('prefs.' + key + '.value', item);
            }
        }
        /**
         * Updates the item in the pref list to the new value. Asserts if the
         * pref itself is not found or is not an Array type.
         */
        updatePrefListItem(key, item, newItem) {
            const pref = this.getPref(key);
            assert$1(pref && pref.type === chrome.settingsPrivate.PrefType.LIST);
            const index = pref.value.indexOf(item);
            if (index !== -1) {
                this.set(`prefs.${key}.value.${index}`, newItem);
            }
        }
        /**
         * Deletes the given item from the pref at the given key if the item is
         * found. Asserts if the pref itself is not found or is not an Array
         * type.
         */
        deletePrefListItem(key, item) {
            assert$1(this.getPref(key).type === chrome.settingsPrivate.PrefType.LIST);
            const index = this.getPref(key).value.indexOf(item);
            if (index !== -1) {
                this.splice(`prefs.${key}.value`, index, 1);
            }
        }
        /**
         * Updates the entry in the pref dictionary to the new key value pair.
         * Asserts if the pref itself is not found or is not a dictionary type.
         */
        setPrefDictEntry(prefPath, key, value) {
            const pref = this.getPref(prefPath);
            assert$1(pref && pref.type === chrome.settingsPrivate.PrefType.DICTIONARY);
            pref.value[key] = value;
            this.set('prefs.' + prefPath + '.value', { ...pref.value });
        }
        /**
         * Deletes the given key from the pref dictionary if it is
         * found. Asserts if the pref itself is not found or is not a dictionary
         * type.
         */
        deletePrefDictEntry(prefPath, key) {
            const pref = this.getPref(prefPath);
            assert$1(pref && pref.type === chrome.settingsPrivate.PrefType.DICTIONARY);
            delete pref.value[key];
            this.set('prefs.' + prefPath + '.value', { ...pref.value });
        }
        /**
         * Helper to assign a pref as a computed property from a string
         * constant. Usage: computed: `computePref(prefs.${PREF_NAME})`,
         */
        computePref(pref) {
            return pref;
        }
    }
    return PrefsMixin;
});

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview TypeScript helper functions that aid in type assertions,
 * type narrowing, etc.
 */
/**
 * @param arg An argument to check for existence.
 * @throws If |arg| is undefined or null.
 */
function assertExists$2(arg, message = `Expected ${arg} to be defined.`) {
    assert$1(arg !== undefined && arg !== null, message);
}
/**
 * Ensures that `value` can't exist at both compile time and run time.
 *
 * This is useful for checking that all cases of a type are checked, such as
 * enums in switch statements:
 *
 * ```
 * declare const val: Enum.A|Enum.B;
 * switch (val) {
 *   case Enum.A:
 *   case Enum.B:
 *     break;
 *   default:
 *     assertExhaustive(val);
 * }
 * ```
 *
 * or with manual type checks:
 *
 * ```
 * declare const val: string|number;
 * if (typeof val === 'string') {
 *   // ...
 * } else if (typeof val === 'number') {
 *   // ...
 * } else {
 *   assertExhaustive(val);
 * }
 * ```
 *
 * @param value The value to be checked.
 * @param message An optional message to throw with the error.
 */
function assertExhaustive(value, message = `Unexpected value ${value}.`) {
    assertNotReached$1(message);
}
/**
 * @param arg A argument to check the type of.
 * @return |arg| with the type narrowed to |type|
 * @throws If |arg| is not an instance of |type|
 */
function cast(arg, type, message) {
    assertInstanceof$1(arg, type, message);
    return arg;
}
/**
 * @param arg A argument to check for existence.
 * @return |arg| with the type narrowed as non-nullable.
 * @throws If |arg| is undefined or null.
 */
function castExists$2(arg, message) {
    assertExists$2(arg, message);
    return arg;
}

// ash/webui/settings/public/constants/setting.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingSpec = { $: mojo.internal.Enum() };
var Setting;
(function (Setting) {
    Setting[Setting["MIN_VALUE"] = 0] = "MIN_VALUE";
    Setting[Setting["MAX_VALUE"] = 1900] = "MAX_VALUE";
    Setting[Setting["kConfigureEthernet"] = 0] = "kConfigureEthernet";
    Setting[Setting["kEthernetAutoConfigureIp"] = 1] = "kEthernetAutoConfigureIp";
    Setting[Setting["kEthernetDns"] = 2] = "kEthernetDns";
    Setting[Setting["kEthernetProxy"] = 3] = "kEthernetProxy";
    Setting[Setting["kWifiOnOff"] = 4] = "kWifiOnOff";
    Setting[Setting["kDisconnectWifiNetwork"] = 5] = "kDisconnectWifiNetwork";
    Setting[Setting["kPreferWifiNetwork"] = 6] = "kPreferWifiNetwork";
    Setting[Setting["kForgetWifiNetwork"] = 7] = "kForgetWifiNetwork";
    Setting[Setting["kWifiAddNetwork"] = 8] = "kWifiAddNetwork";
    Setting[Setting["kWifiAutoConfigureIp"] = 9] = "kWifiAutoConfigureIp";
    Setting[Setting["kWifiDns"] = 10] = "kWifiDns";
    Setting[Setting["kWifiProxy"] = 11] = "kWifiProxy";
    Setting[Setting["kWifiAutoConnectToNetwork"] = 12] = "kWifiAutoConnectToNetwork";
    Setting[Setting["kMobileOnOff"] = 13] = "kMobileOnOff";
    Setting[Setting["kCellularSimLock"] = 14] = "kCellularSimLock";
    Setting[Setting["kCellularRoaming"] = 15] = "kCellularRoaming";
    Setting[Setting["kCellularApn"] = 16] = "kCellularApn";
    Setting[Setting["kDisconnectCellularNetwork"] = 17] = "kDisconnectCellularNetwork";
    Setting[Setting["kCellularAutoConfigureIp"] = 18] = "kCellularAutoConfigureIp";
    Setting[Setting["kCellularDns"] = 19] = "kCellularDns";
    Setting[Setting["kCellularProxy"] = 20] = "kCellularProxy";
    Setting[Setting["kCellularAutoConnectToNetwork"] = 21] = "kCellularAutoConnectToNetwork";
    Setting[Setting["kInstantTetheringOnOff"] = 22] = "kInstantTetheringOnOff";
    Setting[Setting["kDisconnectTetherNetwork"] = 23] = "kDisconnectTetherNetwork";
    Setting[Setting["kWifiMetered"] = 24] = "kWifiMetered";
    Setting[Setting["kCellularMetered"] = 25] = "kCellularMetered";
    Setting[Setting["kAddESimNetwork"] = 26] = "kAddESimNetwork";
    Setting[Setting["kCellularRemoveESimNetwork"] = 27] = "kCellularRemoveESimNetwork";
    Setting[Setting["kCellularRenameESimNetwork"] = 28] = "kCellularRenameESimNetwork";
    Setting[Setting["kWifiHidden"] = 29] = "kWifiHidden";
    Setting[Setting["kHotspotOnOff"] = 30] = "kHotspotOnOff";
    Setting[Setting["kHotspotAutoDisabled"] = 31] = "kHotspotAutoDisabled";
    Setting[Setting["kCellularAddApn"] = 32] = "kCellularAddApn";
    Setting[Setting["kBluetoothOnOff"] = 100] = "kBluetoothOnOff";
    Setting[Setting["kBluetoothPairDevice"] = 103] = "kBluetoothPairDevice";
    Setting[Setting["kBluetoothUnpairDevice"] = 104] = "kBluetoothUnpairDevice";
    Setting[Setting["kFastPairOnOff"] = 105] = "kFastPairOnOff";
    Setting[Setting["kFastPairSavedDevices"] = 106] = "kFastPairSavedDevices";
    Setting[Setting["kSetUpMultiDevice"] = 200] = "kSetUpMultiDevice";
    Setting[Setting["kVerifyMultiDeviceSetup"] = 201] = "kVerifyMultiDeviceSetup";
    Setting[Setting["kMultiDeviceOnOff"] = 202] = "kMultiDeviceOnOff";
    Setting[Setting["kSmartLockOnOff"] = 203] = "kSmartLockOnOff";
    Setting[Setting["kForgetPhone"] = 207] = "kForgetPhone";
    Setting[Setting["kNearbyShareOnOff"] = 208] = "kNearbyShareOnOff";
    Setting[Setting["kPhoneHubOnOff"] = 209] = "kPhoneHubOnOff";
    Setting[Setting["kPhoneHubNotificationsOnOff"] = 210] = "kPhoneHubNotificationsOnOff";
    Setting[Setting["kPhoneHubTaskContinuationOnOff"] = 212] = "kPhoneHubTaskContinuationOnOff";
    Setting[Setting["kWifiSyncOnOff"] = 213] = "kWifiSyncOnOff";
    Setting[Setting["kNearbyShareDeviceName"] = 214] = "kNearbyShareDeviceName";
    Setting[Setting["kNearbyShareDeviceVisibility"] = 215] = "kNearbyShareDeviceVisibility";
    Setting[Setting["kNearbyShareContacts"] = 216] = "kNearbyShareContacts";
    Setting[Setting["kNearbyShareDataUsage"] = 217] = "kNearbyShareDataUsage";
    Setting[Setting["kPhoneHubAppsOnOff"] = 218] = "kPhoneHubAppsOnOff";
    Setting[Setting["kPhoneHubCameraRollOnOff"] = 219] = "kPhoneHubCameraRollOnOff";
    Setting[Setting["kDevicesNearbyAreSharingNotificationOnOff"] = 220] = "kDevicesNearbyAreSharingNotificationOnOff";
    Setting[Setting["kAddAccount"] = 300] = "kAddAccount";
    Setting[Setting["kRemoveAccount"] = 301] = "kRemoveAccount";
    Setting[Setting["kSplitSyncOnOff"] = 302] = "kSplitSyncOnOff";
    Setting[Setting["kSetUpParentalControls"] = 315] = "kSetUpParentalControls";
    Setting[Setting["kNonSplitSyncEncryptionOptions"] = 316] = "kNonSplitSyncEncryptionOptions";
    Setting[Setting["kImproveSearchSuggestions"] = 317] = "kImproveSearchSuggestions";
    Setting[Setting["kMakeSearchesAndBrowsingBetter"] = 318] = "kMakeSearchesAndBrowsingBetter";
    Setting[Setting["kGoogleDriveSearchSuggestions"] = 319] = "kGoogleDriveSearchSuggestions";
    Setting[Setting["kGraduation"] = 320] = "kGraduation";
    Setting[Setting["kTouchpadTapToClick"] = 400] = "kTouchpadTapToClick";
    Setting[Setting["kTouchpadTapDragging"] = 401] = "kTouchpadTapDragging";
    Setting[Setting["kTouchpadReverseScrolling"] = 402] = "kTouchpadReverseScrolling";
    Setting[Setting["kTouchpadAcceleration"] = 403] = "kTouchpadAcceleration";
    Setting[Setting["kTouchpadScrollAcceleration"] = 404] = "kTouchpadScrollAcceleration";
    Setting[Setting["kTouchpadSpeed"] = 405] = "kTouchpadSpeed";
    Setting[Setting["kMouseSwapPrimaryButtons"] = 406] = "kMouseSwapPrimaryButtons";
    Setting[Setting["kMouseReverseScrolling"] = 407] = "kMouseReverseScrolling";
    Setting[Setting["kMouseAcceleration"] = 408] = "kMouseAcceleration";
    Setting[Setting["kMouseScrollAcceleration"] = 409] = "kMouseScrollAcceleration";
    Setting[Setting["kMouseSpeed"] = 410] = "kMouseSpeed";
    Setting[Setting["kKeyboardFunctionKeys"] = 411] = "kKeyboardFunctionKeys";
    Setting[Setting["kKeyboardAutoRepeat"] = 412] = "kKeyboardAutoRepeat";
    Setting[Setting["kKeyboardShortcuts"] = 413] = "kKeyboardShortcuts";
    Setting[Setting["kDisplaySize"] = 414] = "kDisplaySize";
    Setting[Setting["kNightLight"] = 415] = "kNightLight";
    Setting[Setting["kStylusToolsInShelf"] = 416] = "kStylusToolsInShelf";
    Setting[Setting["kStylusNoteTakingApp"] = 417] = "kStylusNoteTakingApp";
    Setting[Setting["kDisplayOrientation"] = 420] = "kDisplayOrientation";
    Setting[Setting["kDisplayArrangement"] = 421] = "kDisplayArrangement";
    Setting[Setting["kPowerIdleBehaviorWhileCharging"] = 422] = "kPowerIdleBehaviorWhileCharging";
    Setting[Setting["kPowerSource"] = 423] = "kPowerSource";
    Setting[Setting["kSleepWhenLaptopLidClosed"] = 424] = "kSleepWhenLaptopLidClosed";
    Setting[Setting["kDisplayResolution"] = 425] = "kDisplayResolution";
    Setting[Setting["kDisplayRefreshRate"] = 426] = "kDisplayRefreshRate";
    Setting[Setting["kDisplayMirroring"] = 428] = "kDisplayMirroring";
    Setting[Setting["kAllowWindowsToSpanDisplays"] = 429] = "kAllowWindowsToSpanDisplays";
    Setting[Setting["kAmbientColors"] = 430] = "kAmbientColors";
    Setting[Setting["kTouchscreenCalibration"] = 431] = "kTouchscreenCalibration";
    Setting[Setting["kNightLightColorTemperature"] = 432] = "kNightLightColorTemperature";
    Setting[Setting["kPowerIdleBehaviorWhileOnBattery"] = 433] = "kPowerIdleBehaviorWhileOnBattery";
    Setting[Setting["kDisplayOverscan"] = 434] = "kDisplayOverscan";
    Setting[Setting["kPointingStickSpeed"] = 435] = "kPointingStickSpeed";
    Setting[Setting["kPointingStickAcceleration"] = 436] = "kPointingStickAcceleration";
    Setting[Setting["kPointingStickSwapPrimaryButtons"] = 437] = "kPointingStickSwapPrimaryButtons";
    Setting[Setting["kTouchpadHapticFeedback"] = 438] = "kTouchpadHapticFeedback";
    Setting[Setting["kTouchpadHapticClickSensitivity"] = 439] = "kTouchpadHapticClickSensitivity";
    Setting[Setting["kAdaptiveCharging"] = 440] = "kAdaptiveCharging";
    Setting[Setting["kKeyboardBlockMetaFkeyRewrites"] = 441] = "kKeyboardBlockMetaFkeyRewrites";
    Setting[Setting["kKeyboardRemapKeys"] = 442] = "kKeyboardRemapKeys";
    Setting[Setting["kChargingSounds"] = 443] = "kChargingSounds";
    Setting[Setting["kLowBatterySound"] = 444] = "kLowBatterySound";
    Setting[Setting["kBatterySaver"] = 445] = "kBatterySaver";
    Setting[Setting["kTouchpadSimulateRightClick"] = 446] = "kTouchpadSimulateRightClick";
    Setting[Setting["kOptimizedCharging"] = 447] = "kOptimizedCharging";
    Setting[Setting["kChargeLimit"] = 448] = "kChargeLimit";
    Setting[Setting["kOpenWallpaper"] = 500] = "kOpenWallpaper";
    Setting[Setting["kPreferredSearchEngine"] = 600] = "kPreferredSearchEngine";
    Setting[Setting["kQuickAnswersOnOff"] = 608] = "kQuickAnswersOnOff";
    Setting[Setting["kQuickAnswersDefinition"] = 609] = "kQuickAnswersDefinition";
    Setting[Setting["kQuickAnswersTranslation"] = 610] = "kQuickAnswersTranslation";
    Setting[Setting["kQuickAnswersUnitConversion"] = 611] = "kQuickAnswersUnitConversion";
    Setting[Setting["kMahiOnOff"] = 612] = "kMahiOnOff";
    Setting[Setting["kMagicBoostOnOff"] = 613] = "kMagicBoostOnOff";
    Setting[Setting["kLobsterOnOff"] = 614] = "kLobsterOnOff";
    Setting[Setting["kSunfishOnOff"] = 615] = "kSunfishOnOff";
    Setting[Setting["kScannerOnOff"] = 616] = "kScannerOnOff";
    Setting[Setting["kManageAndroidPreferences"] = 700] = "kManageAndroidPreferences";
    Setting[Setting["kRemovePlayStore"] = 701] = "kRemovePlayStore";
    Setting[Setting["kTurnOnPlayStore"] = 702] = "kTurnOnPlayStore";
    Setting[Setting["kRestoreAppsAndPages"] = 703] = "kRestoreAppsAndPages";
    Setting[Setting["kDoNotDisturbOnOff"] = 704] = "kDoNotDisturbOnOff";
    Setting[Setting["kAppBadgingOnOff"] = 705] = "kAppBadgingOnOff";
    Setting[Setting["kEnableIsolatedWebAppsOnOff"] = 706] = "kEnableIsolatedWebAppsOnOff";
    Setting[Setting["kAppNotificationOnOff"] = 707] = "kAppNotificationOnOff";
    Setting[Setting["kAppPinToShelfOnOff"] = 708] = "kAppPinToShelfOnOff";
    Setting[Setting["kAppResizeLockOnOff"] = 709] = "kAppResizeLockOnOff";
    Setting[Setting["kAppParentalControls"] = 710] = "kAppParentalControls";
    Setting[Setting["kSetUpCrostini"] = 800] = "kSetUpCrostini";
    Setting[Setting["kUninstallCrostini"] = 801] = "kUninstallCrostini";
    Setting[Setting["kBackupLinuxAppsAndFiles"] = 802] = "kBackupLinuxAppsAndFiles";
    Setting[Setting["kRestoreLinuxAppsAndFiles"] = 803] = "kRestoreLinuxAppsAndFiles";
    Setting[Setting["kCrostiniAdbDebugging"] = 804] = "kCrostiniAdbDebugging";
    Setting[Setting["kCrostiniDiskResize"] = 805] = "kCrostiniDiskResize";
    Setting[Setting["kCrostiniMicAccess"] = 806] = "kCrostiniMicAccess";
    Setting[Setting["kCrostiniContainerUpgrade"] = 807] = "kCrostiniContainerUpgrade";
    Setting[Setting["kBruschettaMicAccess"] = 808] = "kBruschettaMicAccess";
    Setting[Setting["kGuestUsbNotification"] = 809] = "kGuestUsbNotification";
    Setting[Setting["kGuestUsbPersistentPassthrough"] = 810] = "kGuestUsbPersistentPassthrough";
    Setting[Setting["k24HourClock"] = 1000] = "k24HourClock";
    Setting[Setting["kChangeTimeZone"] = 1001] = "kChangeTimeZone";
    Setting[Setting["kVerifiedAccess"] = 1101] = "kVerifiedAccess";
    Setting[Setting["kUsageStatsAndCrashReports"] = 1103] = "kUsageStatsAndCrashReports";
    Setting[Setting["kGuestBrowsingV2"] = 1104] = "kGuestBrowsingV2";
    Setting[Setting["kShowUsernamesAndPhotosAtSignInV2"] = 1105] = "kShowUsernamesAndPhotosAtSignInV2";
    Setting[Setting["kRestrictSignInV2"] = 1106] = "kRestrictSignInV2";
    Setting[Setting["kAddToUserAllowlistV2"] = 1107] = "kAddToUserAllowlistV2";
    Setting[Setting["kRemoveFromUserAllowlistV2"] = 1108] = "kRemoveFromUserAllowlistV2";
    Setting[Setting["kLockScreenV2"] = 1109] = "kLockScreenV2";
    Setting[Setting["kChangeAuthPinV2"] = 1110] = "kChangeAuthPinV2";
    Setting[Setting["kAddFingerprintV2"] = 1111] = "kAddFingerprintV2";
    Setting[Setting["kRemoveFingerprintV2"] = 1112] = "kRemoveFingerprintV2";
    Setting[Setting["kPeripheralDataAccessProtection"] = 1113] = "kPeripheralDataAccessProtection";
    Setting[Setting["kSnoopingProtection"] = 1114] = "kSnoopingProtection";
    Setting[Setting["kQuickDim"] = 1115] = "kQuickDim";
    Setting[Setting["kCameraOnOff"] = 1116] = "kCameraOnOff";
    Setting[Setting["kMicrophoneOnOff"] = 1117] = "kMicrophoneOnOff";
    Setting[Setting["kGeolocationOnOff"] = 1118] = "kGeolocationOnOff";
    Setting[Setting["kLockScreenNotification"] = 1119] = "kLockScreenNotification";
    Setting[Setting["kSpeakOnMuteDetectionOnOff"] = 1120] = "kSpeakOnMuteDetectionOnOff";
    Setting[Setting["kDataRecovery"] = 1121] = "kDataRecovery";
    Setting[Setting["kRevenEnableHwDataUsage"] = 1122] = "kRevenEnableHwDataUsage";
    Setting[Setting["kGeolocationAdvanced"] = 1123] = "kGeolocationAdvanced";
    Setting[Setting["kAddLanguage"] = 1200] = "kAddLanguage";
    Setting[Setting["kShowInputOptionsInShelf"] = 1201] = "kShowInputOptionsInShelf";
    Setting[Setting["kShowEmojiSuggestions"] = 1203] = "kShowEmojiSuggestions";
    Setting[Setting["kChangeDeviceLanguage"] = 1204] = "kChangeDeviceLanguage";
    Setting[Setting["kOfferTranslation"] = 1205] = "kOfferTranslation";
    Setting[Setting["kAddInputMethod"] = 1206] = "kAddInputMethod";
    Setting[Setting["kSpellCheckOnOff"] = 1207] = "kSpellCheckOnOff";
    Setting[Setting["kShowPKAutoCorrection"] = 1209] = "kShowPKAutoCorrection";
    Setting[Setting["kShowVKAutoCorrection"] = 1210] = "kShowVKAutoCorrection";
    Setting[Setting["kShowDiacritic"] = 1211] = "kShowDiacritic";
    Setting[Setting["kShowOrca"] = 1212] = "kShowOrca";
    Setting[Setting["kRemoveInputMethod"] = 1213] = "kRemoveInputMethod";
    Setting[Setting["kSetCurrentInputMethod"] = 1214] = "kSetCurrentInputMethod";
    Setting[Setting["kAddSpellCheckLanguage"] = 1215] = "kAddSpellCheckLanguage";
    Setting[Setting["kRemoveSpellCheckLanguage"] = 1216] = "kRemoveSpellCheckLanguage";
    Setting[Setting["kAddSpellCheckWord"] = 1217] = "kAddSpellCheckWord";
    Setting[Setting["kRemoveSpellCheckWord"] = 1218] = "kRemoveSpellCheckWord";
    Setting[Setting["kRemoveLanguage"] = 1219] = "kRemoveLanguage";
    Setting[Setting["kMoveLanguageToFront"] = 1220] = "kMoveLanguageToFront";
    Setting[Setting["kMoveLanguageUp"] = 1221] = "kMoveLanguageUp";
    Setting[Setting["kMoveLanguageDown"] = 1222] = "kMoveLanguageDown";
    Setting[Setting["kEnableTranslateLanguage"] = 1223] = "kEnableTranslateLanguage";
    Setting[Setting["kDisableTranslateLanguage"] = 1224] = "kDisableTranslateLanguage";
    Setting[Setting["kGoogleDriveConnection"] = 1300] = "kGoogleDriveConnection";
    Setting[Setting["kGoogleDriveRemoveAccess"] = 1301] = "kGoogleDriveRemoveAccess";
    Setting[Setting["kGoogleDriveFileSync"] = 1302] = "kGoogleDriveFileSync";
    Setting[Setting["kAddPrinter"] = 1400] = "kAddPrinter";
    Setting[Setting["kSavedPrinters"] = 1401] = "kSavedPrinters";
    Setting[Setting["kPrintJobs"] = 1402] = "kPrintJobs";
    Setting[Setting["kScanningApp"] = 1403] = "kScanningApp";
    Setting[Setting["kRemovePrinter"] = 1404] = "kRemovePrinter";
    Setting[Setting["kA11yQuickSettings"] = 1500] = "kA11yQuickSettings";
    Setting[Setting["kChromeVox"] = 1501] = "kChromeVox";
    Setting[Setting["kSelectToSpeak"] = 1502] = "kSelectToSpeak";
    Setting[Setting["kTextToSpeechRate"] = 1503] = "kTextToSpeechRate";
    Setting[Setting["kTextToSpeechPitch"] = 1504] = "kTextToSpeechPitch";
    Setting[Setting["kTextToSpeechVolume"] = 1505] = "kTextToSpeechVolume";
    Setting[Setting["kTextToSpeechVoice"] = 1506] = "kTextToSpeechVoice";
    Setting[Setting["kTextToSpeechEngines"] = 1507] = "kTextToSpeechEngines";
    Setting[Setting["kHighContrastMode"] = 1508] = "kHighContrastMode";
    Setting[Setting["kFullscreenMagnifier"] = 1509] = "kFullscreenMagnifier";
    Setting[Setting["kDockedMagnifier"] = 1510] = "kDockedMagnifier";
    Setting[Setting["kStickyKeys"] = 1511] = "kStickyKeys";
    Setting[Setting["kOnScreenKeyboard"] = 1512] = "kOnScreenKeyboard";
    Setting[Setting["kDictation"] = 1513] = "kDictation";
    Setting[Setting["kHighlightKeyboardFocus"] = 1514] = "kHighlightKeyboardFocus";
    Setting[Setting["kHighlightTextCaret"] = 1515] = "kHighlightTextCaret";
    Setting[Setting["kAutoClickWhenCursorStops"] = 1516] = "kAutoClickWhenCursorStops";
    Setting[Setting["kLargeCursor"] = 1517] = "kLargeCursor";
    Setting[Setting["kHighlightCursorWhileMoving"] = 1518] = "kHighlightCursorWhileMoving";
    Setting[Setting["kTabletNavigationButtons"] = 1519] = "kTabletNavigationButtons";
    Setting[Setting["kMonoAudio"] = 1520] = "kMonoAudio";
    Setting[Setting["kStartupSound"] = 1521] = "kStartupSound";
    Setting[Setting["kEnableSwitchAccess"] = 1522] = "kEnableSwitchAccess";
    Setting[Setting["kSwitchActionAssignment"] = 1523] = "kSwitchActionAssignment";
    Setting[Setting["kSwitchActionAutoScan"] = 1524] = "kSwitchActionAutoScan";
    Setting[Setting["kSwitchActionAutoScanKeyboard"] = 1525] = "kSwitchActionAutoScanKeyboard";
    Setting[Setting["kGetImageDescriptionsFromGoogle"] = 1526] = "kGetImageDescriptionsFromGoogle";
    Setting[Setting["kLiveCaption"] = 1527] = "kLiveCaption";
    Setting[Setting["kEnableCursorColor"] = 1528] = "kEnableCursorColor";
    Setting[Setting["kFullscreenMagnifierFocusFollowing"] = 1529] = "kFullscreenMagnifierFocusFollowing";
    Setting[Setting["kFullscreenMagnifierMouseFollowingMode"] = 1530] = "kFullscreenMagnifierMouseFollowingMode";
    Setting[Setting["kSelectToSpeakWordHighlight"] = 1531] = "kSelectToSpeakWordHighlight";
    Setting[Setting["kSelectToSpeakBackgroundShading"] = 1532] = "kSelectToSpeakBackgroundShading";
    Setting[Setting["kSelectToSpeakNavigationControls"] = 1533] = "kSelectToSpeakNavigationControls";
    Setting[Setting["kColorCorrectionEnabled"] = 1534] = "kColorCorrectionEnabled";
    Setting[Setting["kColorCorrectionFilterType"] = 1535] = "kColorCorrectionFilterType";
    Setting[Setting["kColorCorrectionFilterAmount"] = 1536] = "kColorCorrectionFilterAmount";
    Setting[Setting["kReducedAnimationsEnabled"] = 1537] = "kReducedAnimationsEnabled";
    Setting[Setting["kMouseKeysEnabled"] = 1538] = "kMouseKeysEnabled";
    Setting[Setting["kMouseKeysShortcutToPauseEnabled"] = 1539] = "kMouseKeysShortcutToPauseEnabled";
    Setting[Setting["kMouseKeysDisableInTextFields"] = 1540] = "kMouseKeysDisableInTextFields";
    Setting[Setting["kMouseKeysAcceleration"] = 1541] = "kMouseKeysAcceleration";
    Setting[Setting["kMouseKeysMaxSpeed"] = 1542] = "kMouseKeysMaxSpeed";
    Setting[Setting["kMouseKeysDominantHand"] = 1543] = "kMouseKeysDominantHand";
    Setting[Setting["kCaretBlinkInterval"] = 1544] = "kCaretBlinkInterval";
    Setting[Setting["kAccessibilityMagnifierFollowsSts"] = 1545] = "kAccessibilityMagnifierFollowsSts";
    Setting[Setting["kOverscrollEnabled"] = 1547] = "kOverscrollEnabled";
    Setting[Setting["kCaretBrowsing"] = 1548] = "kCaretBrowsing";
    Setting[Setting["kMagnifierFollowsChromeVox"] = 1549] = "kMagnifierFollowsChromeVox";
    Setting[Setting["kMainNodeAnnotationsEnabled"] = 1550] = "kMainNodeAnnotationsEnabled";
    Setting[Setting["kFlashNotifications"] = 1551] = "kFlashNotifications";
    Setting[Setting["kAlwaysShowScrollbarsEnabled"] = 1552] = "kAlwaysShowScrollbarsEnabled";
    Setting[Setting["kFaceGaze"] = 1553] = "kFaceGaze";
    Setting[Setting["kBounceKeys"] = 1554] = "kBounceKeys";
    Setting[Setting["kSlowKeys"] = 1555] = "kSlowKeys";
    Setting[Setting["kDisableTouchpad"] = 1556] = "kDisableTouchpad";
    Setting[Setting["kPowerwash"] = 1600] = "kPowerwash";
    Setting[Setting["kSanitizeCrosSettings"] = 1601] = "kSanitizeCrosSettings";
    Setting[Setting["kChangeChromeChannel"] = 1700] = "kChangeChromeChannel";
    Setting[Setting["kCopyDetailedBuildInfo"] = 1701] = "kCopyDetailedBuildInfo";
    Setting[Setting["kCheckForOsUpdate"] = 1702] = "kCheckForOsUpdate";
    Setting[Setting["kSeeWhatsNew"] = 1703] = "kSeeWhatsNew";
    Setting[Setting["kGetHelpWithChromeOs"] = 1704] = "kGetHelpWithChromeOs";
    Setting[Setting["kReportAnIssue"] = 1705] = "kReportAnIssue";
    Setting[Setting["kTermsOfService"] = 1706] = "kTermsOfService";
    Setting[Setting["kDiagnostics"] = 1707] = "kDiagnostics";
    Setting[Setting["kChangeDeviceName"] = 1708] = "kChangeDeviceName";
    Setting[Setting["kFirmwareUpdates"] = 1709] = "kFirmwareUpdates";
    Setting[Setting["kAddKerberosTicketV2"] = 1800] = "kAddKerberosTicketV2";
    Setting[Setting["kRemoveKerberosTicketV2"] = 1801] = "kRemoveKerberosTicketV2";
    Setting[Setting["kSetActiveKerberosTicketV2"] = 1802] = "kSetActiveKerberosTicketV2";
    Setting[Setting["kSnapWindowSuggestions"] = 1900] = "kSnapWindowSuggestions";
})(Setting || (Setting = {}));

var setting_mojomWebui = /*#__PURE__*/Object.freeze({
  __proto__: null,
  get Setting () { return Setting; },
  SettingSpec: SettingSpec
});

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * Getters for loadTimeData booleans used throughout CrOS Settings.
 * Export them as functions so they reload the values when overridden in tests.
 * Organize the getter functions by their respective pages.
 */
// General
function isGuest() {
    return loadTimeData.getBoolean('isGuest');
}
function isChild() {
    return loadTimeData.getBoolean('isChild');
}
function isSecondaryUser() {
    return loadTimeData.getBoolean('isSecondaryUser');
}
// Apps page
function androidAppsVisible() {
    return loadTimeData.getBoolean('androidAppsVisible');
}
function isArcVmEnabled() {
    return loadTimeData.getBoolean('isArcVmEnabled');
}
function isPlayStoreAvailable() {
    return loadTimeData.getBoolean('isPlayStoreAvailable');
}
function isPluginVmAvailable() {
    return loadTimeData.getBoolean('isPluginVmAvailable');
}
function isAppParentalControlsFeatureAvailable() {
    return loadTimeData.getBoolean('isAppParentalControlsFeatureAvailable');
}
// Crostini page
function isCrostiniAllowed() {
    return loadTimeData.getBoolean('isCrostiniAllowed');
}
function isCrostiniSupported() {
    return loadTimeData.getBoolean('isCrostiniSupported');
}
// Device page
function isExternalStorageEnabled() {
    return loadTimeData.getBoolean('isExternalStorageEnabled');
}
function isDisplayBrightnessControlInSettingsEnabled() {
    return loadTimeData.getBoolean('enableDisplayBrightnessControlInSettings');
}
function isSkyVaultEnabled() {
    return loadTimeData.getBoolean('enableSkyVault');
}
// Kerberos page
function isKerberosEnabled() {
    return loadTimeData.getBoolean('isKerberosEnabled');
}
// People page
function isAccountManagerEnabled() {
    return loadTimeData.getBoolean('isAccountManagerEnabled');
}
// Reset page
function isPowerwashAllowed() {
    return loadTimeData.getBoolean('allowPowerwash');
}
// Reset page
function isSanitizeAllowed() {
    return loadTimeData.getBoolean('allowSanitize');
}
// Search page
function isQuickAnswersSupported() {
    return loadTimeData.getBoolean('isQuickAnswersSupported');
}
function isMagicBoostFeatureEnabled() {
    return loadTimeData.getBoolean('isMagicBoostFeatureEnabled');
}
function isMagicBoostNoticeBannerVisible() {
    return loadTimeData.getBoolean('isMagicBoostNoticeBannerVisible');
}
function isLobsterSettingsToggleVisible() {
    return loadTimeData.getBoolean('isLobsterSettingsToggleVisible');
}
function isScannerSettingsToggleVisible() {
    return loadTimeData.getBoolean('isScannerSettingsToggleVisible');
}
// System preferences page
function shouldShowStartup() {
    return loadTimeData.getBoolean('shouldShowStartup');
}
// Power page
function isBatteryChargeLimitAvailable() {
    return loadTimeData.getBoolean('isBatteryChargeLimitAvailable');
}

// ash/webui/settings/public/constants/routes.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const NETWORK_SECTION_PATH = "internet";
const ETHERNET_DETAILS_SUBPAGE_PATH = "networkDetail";
const NETWORKS_SUBPAGE_BASE_PATH = "networks";
const WIFI_NETWORKS_SUBPAGE_PATH = "networks?type=WiFi";
const CELLULAR_NETWORKS_SUBPAGE_PATH = "networks?type=Cellular";
const MOBILE_DATA_NETWORKS_SUBPAGE_PATH = "networks?type=Tether";
const KNOWN_NETWORKS_SUBPAGE_PATH = "knownNetworks";
const WIFI_DETAILS_SUBPAGE_PATH = "networkDetail";
const CELLULAR_DETAILS_SUBPAGE_PATH = "networkDetail";
const TETHER_DETAILS_SUBPAGE_PATH = "networkDetail";
const VPN_DETAILS_SUBPAGE_PATH = "networkDetail";
const APN_SUBPAGE_PATH = "apn";
const HOTSPOT_SUBPAGE_PATH = "hotspotDetail";
const PASSPOINT_DETAIL_SUBPAGE_PATH = "passpointDetail";
const BLUETOOTH_SECTION_PATH = "bluetooth";
const BLUETOOTH_DEVICES_SUBPAGE_PATH = "bluetoothDevices";
const BLUETOOTH_DEVICE_DETAIL_SUBPAGE_PATH = "bluetoothDeviceDetail";
const BLUETOOTH_SAVED_DEVICES_SUBPAGE_PATH = "bluetoothSavedDevices";
const MULTI_DEVICE_SECTION_PATH = "multidevice";
const MULTI_DEVICE_FEATURES_SUBPAGE_PATH = "multidevice/features";
const NEARBY_SHARE_SUBPAGE_PATH = "multidevice/nearbyshare";
const PEOPLE_SECTION_PATH = "osPeople";
const SYNC_SETUP_SUBPAGE_PATH = "osSyncSetup";
const SYNC_CONTROLS_SUBPAGE_PATH = "osSync";
const SYNC_DEPRECATED_ADVANCED_SUBPAGE_PATH = "osSyncSetup/advanced";
const DEVICE_SECTION_PATH = "device";
const POINTERS_SUBPAGE_PATH = "pointer-overlay";
const PER_DEVICE_KEYBOARD_SUBPAGE_PATH = "per-device-keyboard";
const PER_DEVICE_KEYBOARD_REMAP_KEYS_SUBPAGE_PATH = "per-device-keyboard/remap-keys";
const PER_DEVICE_MOUSE_SUBPAGE_PATH = "per-device-mouse";
const CUSTOMIZE_MOUSE_BUTTONS_SUBPAGE_PATH = "per-device-mouse/customizeButtons";
const PER_DEVICE_POINTING_STICK_SUBPAGE_PATH = "per-device-pointing-stick";
const PER_DEVICE_TOUCHPAD_SUBPAGE_PATH = "per-device-touchpad";
const KEYBOARD_SUBPAGE_PATH = "keyboard-overlay";
const STYLUS_SUBPAGE_PATH = "stylus";
const DISPLAY_SUBPAGE_PATH = "display";
const AUDIO_SUBPAGE_PATH = "audio";
const STORAGE_SUBPAGE_PATH = "storage";
const EXTERNAL_STORAGE_SUBPAGE_PATH = "storage/externalStoragePreferences";
const POWER_SUBPAGE_PATH = "power";
const GRAPHICS_TABLET_SUBPAGE_PATH = "graphics-tablet";
const CUSTOMIZE_TABLET_BUTTONS_SUBPAGE_PATH = "graphics-tablet/customizeTabletButtons";
const CUSTOMIZE_PEN_BUTTONS_SUBPAGE_PATH = "graphics-tablet/customizePenButtons";
const PERSONALIZATION_SECTION_PATH = "personalization";
const SEARCH_SUBPAGE_PATH = "osSearch/search";
const APPS_SECTION_PATH = "apps";
const APP_MANAGEMENT_SUBPAGE_PATH = "app-management";
const APP_NOTIFICATIONS_SUBPAGE_PATH = "app-notifications";
const APP_NOTIFICATIONS_MANAGER_SUBPAGE_PATH = "app-notifications-manager";
const APP_DETAILS_SUBPAGE_PATH = "app-management/detail";
const GOOGLE_PLAY_STORE_SUBPAGE_PATH = "androidAppsDetails";
const PLUGIN_VM_SHARED_PATHS_SUBPAGE_PATH = "app-management/pluginVm/sharedPaths";
const PLUGIN_VM_USB_PREFERENCES_SUBPAGE_PATH = "app-management/pluginVm/sharedUsbDevices";
const ARC_VM_USB_PREFERENCES_SUBPAGE_PATH = "androidAppsDetails/sharedUsbDevices";
const MANAGE_ISOLATED_WEB_APPS_SUBPAGE_PATH = "manage-isolated-web-apps";
const APP_PARENTAL_CONTROLS_SUBPAGE_PATH = "app-parental-controls";
const CROSTINI_DETAILS_SUBPAGE_PATH = "crostini/details";
const CROSTINI_MANAGE_SHARED_FOLDERS_SUBPAGE_PATH = "crostini/sharedPaths";
const CROSTINI_USB_PREFERENCES_SUBPAGE_PATH = "crostini/sharedUsbDevices";
const CROSTINI_BACKUP_AND_RESTORE_SUBPAGE_PATH = "crostini/exportImport";
const CROSTINI_DEVELOP_ANDROID_APPS_SUBPAGE_PATH = "crostini/androidAdb";
const CROSTINI_PORT_FORWARDING_SUBPAGE_PATH = "crostini/portForwarding";
const CROSTINI_EXTRA_CONTAINERS_SUBPAGE_PATH = "crostini/extraContainers";
const BRUSCHETTA_DETAILS_SUBPAGE_PATH = "bruschetta/details";
const BRUSCHETTA_USB_PREFERENCES_SUBPAGE_PATH = "bruschetta/sharedUsbDevices";
const BRUSCHETTA_MANAGE_SHARED_FOLDERS_SUBPAGE_PATH = "bruschetta/sharedPaths";
const TIME_ZONE_SUBPAGE_PATH = "dateTime/timeZone";
const PRIVACY_AND_SECURITY_SECTION_PATH = "osPrivacy";
const MANAGE_OTHER_PEOPLE_SUBPAGE_PATH_V2 = "osPrivacy/accounts";
const SECURITY_AND_SIGN_IN_SUBPAGE_PATH_V2 = "osPrivacy/lockScreen";
const FINGERPRINT_SUBPAGE_PATH_V2 = "osPrivacy/lockScreen/fingerprint";
const SMART_PRIVACY_SUBPAGE_PATH = "osPrivacy/smartPrivacy";
const PRIVACY_HUB_SUBPAGE_PATH = "osPrivacy/privacyHub";
const PRIVACY_HUB_MICROPHONE_SUBPAGE_PATH = "osPrivacy/privacyHub/microphone";
const PRIVACY_HUB_CAMERA_SUBPAGE_PATH = "osPrivacy/privacyHub/camera";
const PRIVACY_HUB_GEOLOCATION_SUBPAGE_PATH = "osPrivacy/privacyHub/geolocation";
const PRIVACY_HUB_GEOLOCATION_ADVANCED_SUBPAGE_PATH = "osPrivacy/privacyHub/geolocation/advanced";
const INPUT_METHOD_OPTIONS_SUBPAGE_PATH = "osLanguages/inputMethodOptions";
const LANGUAGES_SUBPAGE_PATH = "osLanguages/languages";
const INPUT_SUBPAGE_PATH = "osLanguages/input";
const EDIT_DICTIONARY_SUBPAGE_PATH = "osLanguages/editDictionary";
const JAPANESE_MANAGE_USER_DICTIONARY_SUBPAGE_PATH = "osLanguages/japaneseManageUserDictionary";
const APP_LANGUAGES_SUBPAGE_PATH = "osLanguages/languages/appLanguages";
const GOOGLE_DRIVE_SUBPAGE_PATH = "googleDrive";
const ONE_DRIVE_SUBPAGE_PATH = "oneDrive";
const OFFICE_FILES_SUBPAGE_PATH = "officeFiles";
const NETWORK_FILE_SHARES_SUBPAGE_PATH = "smbShares";
const PRINTING_DETAILS_SUBPAGE_PATH = "cupsPrinters";
const ACCESSIBILITY_SECTION_PATH = "osAccessibility";
const MANAGE_ACCESSIBILITY_SUBPAGE_PATH = "manageAccessibility";
const TEXT_TO_SPEECH_PAGE_PATH = "textToSpeech";
const DISPLAY_AND_MAGNIFICATION_SUBPAGE_PATH = "displayAndMagnification";
const KEYBOARD_AND_TEXT_INPUT_SUBPAGE_PATH = "keyboardAndTextInput";
const CURSOR_AND_TOUCHPAD_SUBPAGE_PATH = "cursorAndTouchpad";
const SELECT_TO_SPEAK_SUBPAGE_PATH = "textToSpeech/selectToSpeak";
const CHROME_VOX_SUBPAGE_PATH = "textToSpeech/chromeVox";
const AUDIO_AND_CAPTIONS_SUBPAGE_PATH = "audioAndCaptions";
const TEXT_TO_SPEECH_SUBPAGE_PATH = "manageAccessibility/tts";
const SWITCH_ACCESS_OPTIONS_SUBPAGE_PATH = "manageAccessibility/switchAccess";
const FACE_GAZE_SETTINGS_SUBPAGE_PATH = "manageAccessibility/faceGaze";
const MOUSE_KEYS_SETTINGS_SUBPAGE_PATH = "manageAccessibility/mouseKeys";
const ABOUT_CHROME_OS_SECTION_PATH = "help";
const DETAILED_BUILD_INFO_SUBPAGE_PATH = "help/details";
const KERBEROS_SECTION_PATH = "kerberos";
const KERBEROS_ACCOUNTS_V2_SUBPAGE_PATH = "kerberos/kerberosAccounts";
const SYSTEM_PREFERENCES_SECTION_PATH = "systemPreferences";
const INTERNAL_STORYBOOK_SUBPAGE_PATH = "_internal/_storybook";
const SectionSpec = { $: mojo.internal.Enum() };
var Section;
(function (Section) {
    Section[Section["MIN_VALUE"] = 0] = "MIN_VALUE";
    Section[Section["MAX_VALUE"] = 19] = "MAX_VALUE";
    Section[Section["kNetwork"] = 0] = "kNetwork";
    Section[Section["kBluetooth"] = 1] = "kBluetooth";
    Section[Section["kMultiDevice"] = 2] = "kMultiDevice";
    Section[Section["kPeople"] = 3] = "kPeople";
    Section[Section["kDevice"] = 4] = "kDevice";
    Section[Section["kPersonalization"] = 5] = "kPersonalization";
    Section[Section["kApps"] = 7] = "kApps";
    Section[Section["kPrivacyAndSecurity"] = 11] = "kPrivacyAndSecurity";
    Section[Section["kAccessibility"] = 15] = "kAccessibility";
    Section[Section["kAboutChromeOs"] = 17] = "kAboutChromeOs";
    Section[Section["kKerberos"] = 18] = "kKerberos";
    Section[Section["kSystemPreferences"] = 19] = "kSystemPreferences";
})(Section || (Section = {}));
const SubpageSpec = { $: mojo.internal.Enum() };
var Subpage;
(function (Subpage) {
    Subpage[Subpage["MIN_VALUE"] = 0] = "MIN_VALUE";
    Subpage[Subpage["MAX_VALUE"] = 1800] = "MAX_VALUE";
    Subpage[Subpage["kEthernetDetails"] = 0] = "kEthernetDetails";
    Subpage[Subpage["kWifiNetworks"] = 1] = "kWifiNetworks";
    Subpage[Subpage["kWifiDetails"] = 2] = "kWifiDetails";
    Subpage[Subpage["kKnownNetworks"] = 3] = "kKnownNetworks";
    Subpage[Subpage["kMobileDataNetworks"] = 4] = "kMobileDataNetworks";
    Subpage[Subpage["kCellularDetails"] = 5] = "kCellularDetails";
    Subpage[Subpage["kTetherDetails"] = 6] = "kTetherDetails";
    Subpage[Subpage["kVpnDetails"] = 7] = "kVpnDetails";
    Subpage[Subpage["kApn"] = 8] = "kApn";
    Subpage[Subpage["kHotspotDetails"] = 9] = "kHotspotDetails";
    Subpage[Subpage["kPasspointDetails"] = 10] = "kPasspointDetails";
    Subpage[Subpage["kBluetoothDevices"] = 100] = "kBluetoothDevices";
    Subpage[Subpage["kBluetoothDeviceDetail"] = 101] = "kBluetoothDeviceDetail";
    Subpage[Subpage["kBluetoothSavedDevices"] = 102] = "kBluetoothSavedDevices";
    Subpage[Subpage["kMultiDeviceFeatures"] = 200] = "kMultiDeviceFeatures";
    Subpage[Subpage["kNearbyShare"] = 202] = "kNearbyShare";
    Subpage[Subpage["kSyncControls"] = 301] = "kSyncControls";
    Subpage[Subpage["kSyncSetup"] = 302] = "kSyncSetup";
    Subpage[Subpage["kSyncDeprecatedAdvanced"] = 303] = "kSyncDeprecatedAdvanced";
    Subpage[Subpage["kPointers"] = 400] = "kPointers";
    Subpage[Subpage["kKeyboard"] = 401] = "kKeyboard";
    Subpage[Subpage["kStylus"] = 402] = "kStylus";
    Subpage[Subpage["kDisplay"] = 403] = "kDisplay";
    Subpage[Subpage["kStorage"] = 404] = "kStorage";
    Subpage[Subpage["kExternalStorage"] = 405] = "kExternalStorage";
    Subpage[Subpage["kPower"] = 407] = "kPower";
    Subpage[Subpage["kAudio"] = 408] = "kAudio";
    Subpage[Subpage["kPerDeviceKeyboard"] = 409] = "kPerDeviceKeyboard";
    Subpage[Subpage["kPerDeviceMouse"] = 410] = "kPerDeviceMouse";
    Subpage[Subpage["kPerDeviceTouchpad"] = 411] = "kPerDeviceTouchpad";
    Subpage[Subpage["kPerDevicePointingStick"] = 412] = "kPerDevicePointingStick";
    Subpage[Subpage["kPerDeviceKeyboardRemapKeys"] = 413] = "kPerDeviceKeyboardRemapKeys";
    Subpage[Subpage["kGraphicsTablet"] = 414] = "kGraphicsTablet";
    Subpage[Subpage["kCustomizeMouseButtons"] = 415] = "kCustomizeMouseButtons";
    Subpage[Subpage["kCustomizeTabletButtons"] = 416] = "kCustomizeTabletButtons";
    Subpage[Subpage["kCustomizePenButtons"] = 417] = "kCustomizePenButtons";
    Subpage[Subpage["kSearch"] = 601] = "kSearch";
    Subpage[Subpage["kAppManagement"] = 700] = "kAppManagement";
    Subpage[Subpage["kAppDetails"] = 701] = "kAppDetails";
    Subpage[Subpage["kGooglePlayStore"] = 702] = "kGooglePlayStore";
    Subpage[Subpage["kPluginVmSharedPaths"] = 703] = "kPluginVmSharedPaths";
    Subpage[Subpage["kPluginVmUsbPreferences"] = 704] = "kPluginVmUsbPreferences";
    Subpage[Subpage["kAppNotifications"] = 706] = "kAppNotifications";
    Subpage[Subpage["kArcVmUsbPreferences"] = 707] = "kArcVmUsbPreferences";
    Subpage[Subpage["kManageIsolatedWebApps"] = 708] = "kManageIsolatedWebApps";
    Subpage[Subpage["kAppNotificationsManager"] = 709] = "kAppNotificationsManager";
    Subpage[Subpage["kAppParentalControls"] = 710] = "kAppParentalControls";
    Subpage[Subpage["kCrostiniDetails"] = 800] = "kCrostiniDetails";
    Subpage[Subpage["kCrostiniManageSharedFolders"] = 801] = "kCrostiniManageSharedFolders";
    Subpage[Subpage["kCrostiniUsbPreferences"] = 802] = "kCrostiniUsbPreferences";
    Subpage[Subpage["kCrostiniBackupAndRestore"] = 803] = "kCrostiniBackupAndRestore";
    Subpage[Subpage["kCrostiniDevelopAndroidApps"] = 804] = "kCrostiniDevelopAndroidApps";
    Subpage[Subpage["kCrostiniPortForwarding"] = 805] = "kCrostiniPortForwarding";
    Subpage[Subpage["kCrostiniExtraContainers"] = 806] = "kCrostiniExtraContainers";
    Subpage[Subpage["kBruschettaDetails"] = 850] = "kBruschettaDetails";
    Subpage[Subpage["kBruschettaUsbPreferences"] = 851] = "kBruschettaUsbPreferences";
    Subpage[Subpage["kBruschettaManageSharedFolders"] = 852] = "kBruschettaManageSharedFolders";
    Subpage[Subpage["kTimeZone"] = 1000] = "kTimeZone";
    Subpage[Subpage["kManageOtherPeopleV2"] = 1100] = "kManageOtherPeopleV2";
    Subpage[Subpage["kSecurityAndSignInV2"] = 1101] = "kSecurityAndSignInV2";
    Subpage[Subpage["kFingerprintV2"] = 1102] = "kFingerprintV2";
    Subpage[Subpage["kSmartPrivacy"] = 1103] = "kSmartPrivacy";
    Subpage[Subpage["kPrivacyHub"] = 1104] = "kPrivacyHub";
    Subpage[Subpage["kPrivacyHubMicrophone"] = 1105] = "kPrivacyHubMicrophone";
    Subpage[Subpage["kPrivacyHubCamera"] = 1106] = "kPrivacyHubCamera";
    Subpage[Subpage["kPrivacyHubGeolocation"] = 1107] = "kPrivacyHubGeolocation";
    Subpage[Subpage["kPrivacyHubGeolocationAdvanced"] = 1108] = "kPrivacyHubGeolocationAdvanced";
    Subpage[Subpage["kInputMethodOptions"] = 1203] = "kInputMethodOptions";
    Subpage[Subpage["kLanguages"] = 1204] = "kLanguages";
    Subpage[Subpage["kInput"] = 1205] = "kInput";
    Subpage[Subpage["kEditDictionary"] = 1206] = "kEditDictionary";
    Subpage[Subpage["kJapaneseManageUserDictionary"] = 1207] = "kJapaneseManageUserDictionary";
    Subpage[Subpage["kAppLanguages"] = 1208] = "kAppLanguages";
    Subpage[Subpage["kNetworkFileShares"] = 1300] = "kNetworkFileShares";
    Subpage[Subpage["kOfficeFiles"] = 1301] = "kOfficeFiles";
    Subpage[Subpage["kGoogleDrive"] = 1302] = "kGoogleDrive";
    Subpage[Subpage["kOneDrive"] = 1303] = "kOneDrive";
    Subpage[Subpage["kPrintingDetails"] = 1400] = "kPrintingDetails";
    Subpage[Subpage["kManageAccessibility"] = 1500] = "kManageAccessibility";
    Subpage[Subpage["kTextToSpeech"] = 1502] = "kTextToSpeech";
    Subpage[Subpage["kSwitchAccessOptions"] = 1503] = "kSwitchAccessOptions";
    Subpage[Subpage["kTextToSpeechPage"] = 1505] = "kTextToSpeechPage";
    Subpage[Subpage["kDisplayAndMagnification"] = 1506] = "kDisplayAndMagnification";
    Subpage[Subpage["kKeyboardAndTextInput"] = 1507] = "kKeyboardAndTextInput";
    Subpage[Subpage["kCursorAndTouchpad"] = 1508] = "kCursorAndTouchpad";
    Subpage[Subpage["kAudioAndCaptions"] = 1509] = "kAudioAndCaptions";
    Subpage[Subpage["kSelectToSpeak"] = 1510] = "kSelectToSpeak";
    Subpage[Subpage["kChromeVox"] = 1511] = "kChromeVox";
    Subpage[Subpage["kFaceGazeSettings"] = 1512] = "kFaceGazeSettings";
    Subpage[Subpage["kMouseKeysSettings"] = 1513] = "kMouseKeysSettings";
    Subpage[Subpage["kDetailedBuildInfo"] = 1701] = "kDetailedBuildInfo";
    Subpage[Subpage["kInternalStorybook"] = 1702] = "kInternalStorybook";
    Subpage[Subpage["kKerberosAccountsV2"] = 1800] = "kKerberosAccountsV2";
})(Subpage || (Subpage = {}));

var routesMojom = /*#__PURE__*/Object.freeze({
  __proto__: null,
  ABOUT_CHROME_OS_SECTION_PATH: ABOUT_CHROME_OS_SECTION_PATH,
  ACCESSIBILITY_SECTION_PATH: ACCESSIBILITY_SECTION_PATH,
  APN_SUBPAGE_PATH: APN_SUBPAGE_PATH,
  APPS_SECTION_PATH: APPS_SECTION_PATH,
  APP_DETAILS_SUBPAGE_PATH: APP_DETAILS_SUBPAGE_PATH,
  APP_LANGUAGES_SUBPAGE_PATH: APP_LANGUAGES_SUBPAGE_PATH,
  APP_MANAGEMENT_SUBPAGE_PATH: APP_MANAGEMENT_SUBPAGE_PATH,
  APP_NOTIFICATIONS_MANAGER_SUBPAGE_PATH: APP_NOTIFICATIONS_MANAGER_SUBPAGE_PATH,
  APP_NOTIFICATIONS_SUBPAGE_PATH: APP_NOTIFICATIONS_SUBPAGE_PATH,
  APP_PARENTAL_CONTROLS_SUBPAGE_PATH: APP_PARENTAL_CONTROLS_SUBPAGE_PATH,
  ARC_VM_USB_PREFERENCES_SUBPAGE_PATH: ARC_VM_USB_PREFERENCES_SUBPAGE_PATH,
  AUDIO_AND_CAPTIONS_SUBPAGE_PATH: AUDIO_AND_CAPTIONS_SUBPAGE_PATH,
  AUDIO_SUBPAGE_PATH: AUDIO_SUBPAGE_PATH,
  BLUETOOTH_DEVICES_SUBPAGE_PATH: BLUETOOTH_DEVICES_SUBPAGE_PATH,
  BLUETOOTH_DEVICE_DETAIL_SUBPAGE_PATH: BLUETOOTH_DEVICE_DETAIL_SUBPAGE_PATH,
  BLUETOOTH_SAVED_DEVICES_SUBPAGE_PATH: BLUETOOTH_SAVED_DEVICES_SUBPAGE_PATH,
  BLUETOOTH_SECTION_PATH: BLUETOOTH_SECTION_PATH,
  BRUSCHETTA_DETAILS_SUBPAGE_PATH: BRUSCHETTA_DETAILS_SUBPAGE_PATH,
  BRUSCHETTA_MANAGE_SHARED_FOLDERS_SUBPAGE_PATH: BRUSCHETTA_MANAGE_SHARED_FOLDERS_SUBPAGE_PATH,
  BRUSCHETTA_USB_PREFERENCES_SUBPAGE_PATH: BRUSCHETTA_USB_PREFERENCES_SUBPAGE_PATH,
  CELLULAR_DETAILS_SUBPAGE_PATH: CELLULAR_DETAILS_SUBPAGE_PATH,
  CELLULAR_NETWORKS_SUBPAGE_PATH: CELLULAR_NETWORKS_SUBPAGE_PATH,
  CHROME_VOX_SUBPAGE_PATH: CHROME_VOX_SUBPAGE_PATH,
  CROSTINI_BACKUP_AND_RESTORE_SUBPAGE_PATH: CROSTINI_BACKUP_AND_RESTORE_SUBPAGE_PATH,
  CROSTINI_DETAILS_SUBPAGE_PATH: CROSTINI_DETAILS_SUBPAGE_PATH,
  CROSTINI_DEVELOP_ANDROID_APPS_SUBPAGE_PATH: CROSTINI_DEVELOP_ANDROID_APPS_SUBPAGE_PATH,
  CROSTINI_EXTRA_CONTAINERS_SUBPAGE_PATH: CROSTINI_EXTRA_CONTAINERS_SUBPAGE_PATH,
  CROSTINI_MANAGE_SHARED_FOLDERS_SUBPAGE_PATH: CROSTINI_MANAGE_SHARED_FOLDERS_SUBPAGE_PATH,
  CROSTINI_PORT_FORWARDING_SUBPAGE_PATH: CROSTINI_PORT_FORWARDING_SUBPAGE_PATH,
  CROSTINI_USB_PREFERENCES_SUBPAGE_PATH: CROSTINI_USB_PREFERENCES_SUBPAGE_PATH,
  CURSOR_AND_TOUCHPAD_SUBPAGE_PATH: CURSOR_AND_TOUCHPAD_SUBPAGE_PATH,
  CUSTOMIZE_MOUSE_BUTTONS_SUBPAGE_PATH: CUSTOMIZE_MOUSE_BUTTONS_SUBPAGE_PATH,
  CUSTOMIZE_PEN_BUTTONS_SUBPAGE_PATH: CUSTOMIZE_PEN_BUTTONS_SUBPAGE_PATH,
  CUSTOMIZE_TABLET_BUTTONS_SUBPAGE_PATH: CUSTOMIZE_TABLET_BUTTONS_SUBPAGE_PATH,
  DETAILED_BUILD_INFO_SUBPAGE_PATH: DETAILED_BUILD_INFO_SUBPAGE_PATH,
  DEVICE_SECTION_PATH: DEVICE_SECTION_PATH,
  DISPLAY_AND_MAGNIFICATION_SUBPAGE_PATH: DISPLAY_AND_MAGNIFICATION_SUBPAGE_PATH,
  DISPLAY_SUBPAGE_PATH: DISPLAY_SUBPAGE_PATH,
  EDIT_DICTIONARY_SUBPAGE_PATH: EDIT_DICTIONARY_SUBPAGE_PATH,
  ETHERNET_DETAILS_SUBPAGE_PATH: ETHERNET_DETAILS_SUBPAGE_PATH,
  EXTERNAL_STORAGE_SUBPAGE_PATH: EXTERNAL_STORAGE_SUBPAGE_PATH,
  FACE_GAZE_SETTINGS_SUBPAGE_PATH: FACE_GAZE_SETTINGS_SUBPAGE_PATH,
  FINGERPRINT_SUBPAGE_PATH_V2: FINGERPRINT_SUBPAGE_PATH_V2,
  GOOGLE_DRIVE_SUBPAGE_PATH: GOOGLE_DRIVE_SUBPAGE_PATH,
  GOOGLE_PLAY_STORE_SUBPAGE_PATH: GOOGLE_PLAY_STORE_SUBPAGE_PATH,
  GRAPHICS_TABLET_SUBPAGE_PATH: GRAPHICS_TABLET_SUBPAGE_PATH,
  HOTSPOT_SUBPAGE_PATH: HOTSPOT_SUBPAGE_PATH,
  INPUT_METHOD_OPTIONS_SUBPAGE_PATH: INPUT_METHOD_OPTIONS_SUBPAGE_PATH,
  INPUT_SUBPAGE_PATH: INPUT_SUBPAGE_PATH,
  INTERNAL_STORYBOOK_SUBPAGE_PATH: INTERNAL_STORYBOOK_SUBPAGE_PATH,
  JAPANESE_MANAGE_USER_DICTIONARY_SUBPAGE_PATH: JAPANESE_MANAGE_USER_DICTIONARY_SUBPAGE_PATH,
  KERBEROS_ACCOUNTS_V2_SUBPAGE_PATH: KERBEROS_ACCOUNTS_V2_SUBPAGE_PATH,
  KERBEROS_SECTION_PATH: KERBEROS_SECTION_PATH,
  KEYBOARD_AND_TEXT_INPUT_SUBPAGE_PATH: KEYBOARD_AND_TEXT_INPUT_SUBPAGE_PATH,
  KEYBOARD_SUBPAGE_PATH: KEYBOARD_SUBPAGE_PATH,
  KNOWN_NETWORKS_SUBPAGE_PATH: KNOWN_NETWORKS_SUBPAGE_PATH,
  LANGUAGES_SUBPAGE_PATH: LANGUAGES_SUBPAGE_PATH,
  MANAGE_ACCESSIBILITY_SUBPAGE_PATH: MANAGE_ACCESSIBILITY_SUBPAGE_PATH,
  MANAGE_ISOLATED_WEB_APPS_SUBPAGE_PATH: MANAGE_ISOLATED_WEB_APPS_SUBPAGE_PATH,
  MANAGE_OTHER_PEOPLE_SUBPAGE_PATH_V2: MANAGE_OTHER_PEOPLE_SUBPAGE_PATH_V2,
  MOBILE_DATA_NETWORKS_SUBPAGE_PATH: MOBILE_DATA_NETWORKS_SUBPAGE_PATH,
  MOUSE_KEYS_SETTINGS_SUBPAGE_PATH: MOUSE_KEYS_SETTINGS_SUBPAGE_PATH,
  MULTI_DEVICE_FEATURES_SUBPAGE_PATH: MULTI_DEVICE_FEATURES_SUBPAGE_PATH,
  MULTI_DEVICE_SECTION_PATH: MULTI_DEVICE_SECTION_PATH,
  NEARBY_SHARE_SUBPAGE_PATH: NEARBY_SHARE_SUBPAGE_PATH,
  NETWORKS_SUBPAGE_BASE_PATH: NETWORKS_SUBPAGE_BASE_PATH,
  NETWORK_FILE_SHARES_SUBPAGE_PATH: NETWORK_FILE_SHARES_SUBPAGE_PATH,
  NETWORK_SECTION_PATH: NETWORK_SECTION_PATH,
  OFFICE_FILES_SUBPAGE_PATH: OFFICE_FILES_SUBPAGE_PATH,
  ONE_DRIVE_SUBPAGE_PATH: ONE_DRIVE_SUBPAGE_PATH,
  PASSPOINT_DETAIL_SUBPAGE_PATH: PASSPOINT_DETAIL_SUBPAGE_PATH,
  PEOPLE_SECTION_PATH: PEOPLE_SECTION_PATH,
  PERSONALIZATION_SECTION_PATH: PERSONALIZATION_SECTION_PATH,
  PER_DEVICE_KEYBOARD_REMAP_KEYS_SUBPAGE_PATH: PER_DEVICE_KEYBOARD_REMAP_KEYS_SUBPAGE_PATH,
  PER_DEVICE_KEYBOARD_SUBPAGE_PATH: PER_DEVICE_KEYBOARD_SUBPAGE_PATH,
  PER_DEVICE_MOUSE_SUBPAGE_PATH: PER_DEVICE_MOUSE_SUBPAGE_PATH,
  PER_DEVICE_POINTING_STICK_SUBPAGE_PATH: PER_DEVICE_POINTING_STICK_SUBPAGE_PATH,
  PER_DEVICE_TOUCHPAD_SUBPAGE_PATH: PER_DEVICE_TOUCHPAD_SUBPAGE_PATH,
  PLUGIN_VM_SHARED_PATHS_SUBPAGE_PATH: PLUGIN_VM_SHARED_PATHS_SUBPAGE_PATH,
  PLUGIN_VM_USB_PREFERENCES_SUBPAGE_PATH: PLUGIN_VM_USB_PREFERENCES_SUBPAGE_PATH,
  POINTERS_SUBPAGE_PATH: POINTERS_SUBPAGE_PATH,
  POWER_SUBPAGE_PATH: POWER_SUBPAGE_PATH,
  PRINTING_DETAILS_SUBPAGE_PATH: PRINTING_DETAILS_SUBPAGE_PATH,
  PRIVACY_AND_SECURITY_SECTION_PATH: PRIVACY_AND_SECURITY_SECTION_PATH,
  PRIVACY_HUB_CAMERA_SUBPAGE_PATH: PRIVACY_HUB_CAMERA_SUBPAGE_PATH,
  PRIVACY_HUB_GEOLOCATION_ADVANCED_SUBPAGE_PATH: PRIVACY_HUB_GEOLOCATION_ADVANCED_SUBPAGE_PATH,
  PRIVACY_HUB_GEOLOCATION_SUBPAGE_PATH: PRIVACY_HUB_GEOLOCATION_SUBPAGE_PATH,
  PRIVACY_HUB_MICROPHONE_SUBPAGE_PATH: PRIVACY_HUB_MICROPHONE_SUBPAGE_PATH,
  PRIVACY_HUB_SUBPAGE_PATH: PRIVACY_HUB_SUBPAGE_PATH,
  SEARCH_SUBPAGE_PATH: SEARCH_SUBPAGE_PATH,
  SECURITY_AND_SIGN_IN_SUBPAGE_PATH_V2: SECURITY_AND_SIGN_IN_SUBPAGE_PATH_V2,
  SELECT_TO_SPEAK_SUBPAGE_PATH: SELECT_TO_SPEAK_SUBPAGE_PATH,
  SMART_PRIVACY_SUBPAGE_PATH: SMART_PRIVACY_SUBPAGE_PATH,
  STORAGE_SUBPAGE_PATH: STORAGE_SUBPAGE_PATH,
  STYLUS_SUBPAGE_PATH: STYLUS_SUBPAGE_PATH,
  SWITCH_ACCESS_OPTIONS_SUBPAGE_PATH: SWITCH_ACCESS_OPTIONS_SUBPAGE_PATH,
  SYNC_CONTROLS_SUBPAGE_PATH: SYNC_CONTROLS_SUBPAGE_PATH,
  SYNC_DEPRECATED_ADVANCED_SUBPAGE_PATH: SYNC_DEPRECATED_ADVANCED_SUBPAGE_PATH,
  SYNC_SETUP_SUBPAGE_PATH: SYNC_SETUP_SUBPAGE_PATH,
  SYSTEM_PREFERENCES_SECTION_PATH: SYSTEM_PREFERENCES_SECTION_PATH,
  get Section () { return Section; },
  SectionSpec: SectionSpec,
  get Subpage () { return Subpage; },
  SubpageSpec: SubpageSpec,
  TETHER_DETAILS_SUBPAGE_PATH: TETHER_DETAILS_SUBPAGE_PATH,
  TEXT_TO_SPEECH_PAGE_PATH: TEXT_TO_SPEECH_PAGE_PATH,
  TEXT_TO_SPEECH_SUBPAGE_PATH: TEXT_TO_SPEECH_SUBPAGE_PATH,
  TIME_ZONE_SUBPAGE_PATH: TIME_ZONE_SUBPAGE_PATH,
  VPN_DETAILS_SUBPAGE_PATH: VPN_DETAILS_SUBPAGE_PATH,
  WIFI_DETAILS_SUBPAGE_PATH: WIFI_DETAILS_SUBPAGE_PATH,
  WIFI_NETWORKS_SUBPAGE_PATH: WIFI_NETWORKS_SUBPAGE_PATH
});

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * Defines the class for navigable routes. Also exports a function which
 * creates the set of routes available, based on loadTimeData, and is meant to
 * be used when initializing the Router instance. Routes should be derived from
 * the Router singleton instance, rather than imported from here.
 */
/**
 * Class for navigable routes. Routes are representing by a tree data structure.
 */
class Route {
    constructor(path, title) {
        assert$1(path.startsWith('/'));
        this.path = path;
        this.title = title;
        this.parent = null;
        this.depth = 0;
        this.isNavigableDialog = false;
        this.section = null;
    }
    /**
     * @returns A new Route instance that is a child of this route. If |path| does
     * not have a leading slash, then it extends this route's path. Else, the
     * given path is set.
     */
    createChild(path, title) {
        assert$1(path);
        const childPath = path.startsWith('/') ? path : `${this.path}/${path}`;
        const route = new Route(childPath, title);
        route.parent = this;
        route.section = this.section;
        route.depth = this.depth + 1;
        return route;
    }
    /**
     * Returns the absolute path string for this Route, assuming this function
     * has been called from within chrome://os-settings.
     */
    getAbsolutePath() {
        return window.location.origin + this.path;
    }
    /**
     * Returns true if this route matches, or is an ancestor of, the parameter.
     */
    contains(route) {
        for (let curr = route; curr !== null; curr = curr.parent) {
            if (this === curr) {
                return true;
            }
        }
        return false;
    }
    /**
     * Returns true if this route is a subpage of a section.
     */
    isSubpage() {
        return !this.isNavigableDialog && !!this.parent && this.section !== null &&
            this.parent.section === this.section;
    }
    /**
     * Returns the top-most ancestor Route for this route's `section`. If this
     * route has no `section` then returns null.
     */
    getSectionAncestor() {
        if (this.section === null) {
            return null;
        }
        let curr = this;
        while (curr.parent && curr.parent.section !== null) {
            curr = curr.parent;
        }
        return curr;
    }
}
function createSection(parent, path, section, title) {
    let route;
    if (parent) {
        route = parent.createChild(`/${path}`, title);
    }
    else {
        route = new Route(`/${path}`, title);
    }
    route.section = section;
    return route;
}
function createSubpage(parent, path, _subpage) {
    // TODO(khorimoto): Add |subpage| to the Route object.
    return parent.createChild('/' + path);
}
/**
 * Creates Route objects for each path corresponding to CrOS settings content.
 */
function createRoutes() {
    const r = {};
    const { Section, Subpage } = routesMojom;
    // Special routes:
    // BASIC is the main page which loads if no path is provided. AKA Root page.
    r.BASIC = new Route('/');
    // ADVANCED is a non-navigable route. It only serves as a parent to group
    // child routes under the advanced section and is never allowed direct
    // navigation.
    r.ADVANCED = new Route('/advanced');
    // Network section.
    r.INTERNET = createSection(r.BASIC, NETWORK_SECTION_PATH, Section.kNetwork);
    // Note: INTERNET_NETWORKS and NETWORK_DETAIL are special cases because they
    // includes several subpages, one per network type. Default to kWifiNetworks
    // and kWifiDetails subpages.
    r.INTERNET_NETWORKS = createSubpage(r.INTERNET, NETWORKS_SUBPAGE_BASE_PATH, Subpage.kWifiNetworks);
    r.NETWORK_DETAIL = createSubpage(r.INTERNET, WIFI_DETAILS_SUBPAGE_PATH, Subpage.kWifiDetails);
    r.KNOWN_NETWORKS = createSubpage(r.INTERNET, KNOWN_NETWORKS_SUBPAGE_PATH, Subpage.kKnownNetworks);
    r.HOTSPOT_DETAIL = createSubpage(r.INTERNET, HOTSPOT_SUBPAGE_PATH, Subpage.kHotspotDetails);
    if (loadTimeData.getBoolean('isApnRevampEnabled')) {
        r.APN =
            createSubpage(r.INTERNET, APN_SUBPAGE_PATH, Subpage.kApn);
    }
    r.PASSPOINT_DETAIL = createSubpage(r.INTERNET, PASSPOINT_DETAIL_SUBPAGE_PATH, Subpage.kPasspointDetails);
    // Bluetooth section.
    r.BLUETOOTH = createSection(r.BASIC, BLUETOOTH_SECTION_PATH, Section.kBluetooth);
    r.BLUETOOTH_DEVICES = createSubpage(r.BLUETOOTH, BLUETOOTH_DEVICES_SUBPAGE_PATH, Subpage.kBluetoothDevices);
    r.BLUETOOTH_DEVICE_DETAIL = createSubpage(r.BLUETOOTH, BLUETOOTH_DEVICE_DETAIL_SUBPAGE_PATH, Subpage.kBluetoothDeviceDetail);
    if (loadTimeData.getBoolean('enableSavedDevicesFlag') &&
        loadTimeData.getBoolean('isCrossDeviceFeatureSuiteEnabled')) {
        r.BLUETOOTH_SAVED_DEVICES = createSubpage(r.BLUETOOTH, BLUETOOTH_SAVED_DEVICES_SUBPAGE_PATH, Subpage.kBluetoothSavedDevices);
    }
    // MultiDevice section.
    if (!isGuest() &&
        loadTimeData.getBoolean('isCrossDeviceFeatureSuiteEnabled')) {
        r.MULTIDEVICE = createSection(r.BASIC, MULTI_DEVICE_SECTION_PATH, Section.kMultiDevice);
        r.MULTIDEVICE_FEATURES = createSubpage(r.MULTIDEVICE, MULTI_DEVICE_FEATURES_SUBPAGE_PATH, Subpage.kMultiDeviceFeatures);
        if (loadTimeData.getBoolean('isNearbyShareSupported')) {
            r.NEARBY_SHARE = createSubpage(r.MULTIDEVICE, NEARBY_SHARE_SUBPAGE_PATH, Subpage.kNearbyShare);
        }
    }
    // People section.
    if (!isGuest()) {
        r.OS_PEOPLE = createSection(r.BASIC, PEOPLE_SECTION_PATH, Section.kPeople);
    }
    // Kerberos section.
    if (isKerberosEnabled()) {
        r.KERBEROS = createSection(r.BASIC, KERBEROS_SECTION_PATH, Section.kKerberos);
        r.KERBEROS_ACCOUNTS_V2 = createSubpage(r.KERBEROS, KERBEROS_ACCOUNTS_V2_SUBPAGE_PATH, Subpage.kKerberosAccountsV2);
    }
    // Device section.
    r.DEVICE =
        createSection(r.BASIC, DEVICE_SECTION_PATH, Section.kDevice);
    r.POINTERS = createSubpage(r.DEVICE, POINTERS_SUBPAGE_PATH, Subpage.kPointers);
    r.KEYBOARD = createSubpage(r.DEVICE, KEYBOARD_SUBPAGE_PATH, Subpage.kKeyboard);
    r.STYLUS =
        createSubpage(r.DEVICE, STYLUS_SUBPAGE_PATH, Subpage.kStylus);
    r.DISPLAY = createSubpage(r.DEVICE, DISPLAY_SUBPAGE_PATH, Subpage.kDisplay);
    r.AUDIO =
        createSubpage(r.DEVICE, AUDIO_SUBPAGE_PATH, Subpage.kAudio);
    r.PER_DEVICE_KEYBOARD = createSubpage(r.DEVICE, PER_DEVICE_KEYBOARD_SUBPAGE_PATH, Subpage.kPerDeviceKeyboard);
    r.PER_DEVICE_MOUSE = createSubpage(r.DEVICE, PER_DEVICE_MOUSE_SUBPAGE_PATH, Subpage.kPerDeviceMouse);
    r.PER_DEVICE_POINTING_STICK = createSubpage(r.DEVICE, PER_DEVICE_POINTING_STICK_SUBPAGE_PATH, Subpage.kPerDevicePointingStick);
    r.PER_DEVICE_TOUCHPAD = createSubpage(r.DEVICE, PER_DEVICE_TOUCHPAD_SUBPAGE_PATH, Subpage.kPerDeviceTouchpad);
    r.PER_DEVICE_KEYBOARD_REMAP_KEYS = createSubpage(r.PER_DEVICE_KEYBOARD, PER_DEVICE_KEYBOARD_REMAP_KEYS_SUBPAGE_PATH, Subpage.kPerDeviceKeyboardRemapKeys);
    if (loadTimeData.getBoolean('enablePeripheralCustomization')) {
        r.GRAPHICS_TABLET = createSubpage(r.DEVICE, GRAPHICS_TABLET_SUBPAGE_PATH, Subpage.kGraphicsTablet);
        if (r.PER_DEVICE_MOUSE) {
            r.CUSTOMIZE_MOUSE_BUTTONS = createSubpage(r.PER_DEVICE_MOUSE, CUSTOMIZE_MOUSE_BUTTONS_SUBPAGE_PATH, Subpage.kCustomizeMouseButtons);
        }
        r.CUSTOMIZE_TABLET_BUTTONS = createSubpage(r.GRAPHICS_TABLET, CUSTOMIZE_TABLET_BUTTONS_SUBPAGE_PATH, Subpage.kCustomizeTabletButtons);
        r.CUSTOMIZE_PEN_BUTTONS = createSubpage(r.GRAPHICS_TABLET, CUSTOMIZE_PEN_BUTTONS_SUBPAGE_PATH, Subpage.kCustomizePenButtons);
    }
    // Personalization section.
    r.PERSONALIZATION = createSection(r.BASIC, PERSONALIZATION_SECTION_PATH, Section.kPersonalization);
    // Apps section.
    r.APPS = createSection(r.BASIC, APPS_SECTION_PATH, Section.kApps);
    r.APP_NOTIFICATIONS = createSubpage(r.APPS, APP_NOTIFICATIONS_SUBPAGE_PATH, Subpage.kAppNotifications);
    r.APP_NOTIFICATIONS_MANAGER = createSubpage(r.APP_NOTIFICATIONS, APP_NOTIFICATIONS_MANAGER_SUBPAGE_PATH, Subpage.kAppNotificationsManager);
    r.APP_MANAGEMENT = createSubpage(r.APPS, APP_MANAGEMENT_SUBPAGE_PATH, Subpage.kAppManagement);
    r.APP_MANAGEMENT_DETAIL = createSubpage(r.APP_MANAGEMENT, APP_DETAILS_SUBPAGE_PATH, Subpage.kAppDetails);
    if (androidAppsVisible()) {
        r.ANDROID_APPS_DETAILS = createSubpage(r.APPS, GOOGLE_PLAY_STORE_SUBPAGE_PATH, Subpage.kGooglePlayStore);
        if (isArcVmEnabled()) {
            r.ANDROID_APPS_DETAILS_ARC_VM_SHARED_USB_DEVICES = createSubpage(r.ANDROID_APPS_DETAILS, ARC_VM_USB_PREFERENCES_SUBPAGE_PATH, Subpage.kArcVmUsbPreferences);
        }
    }
    if (isPluginVmAvailable()) {
        r.APP_MANAGEMENT_PLUGIN_VM_SHARED_PATHS = createSubpage(r.APP_MANAGEMENT, PLUGIN_VM_SHARED_PATHS_SUBPAGE_PATH, Subpage.kPluginVmSharedPaths);
        r.APP_MANAGEMENT_PLUGIN_VM_SHARED_USB_DEVICES = createSubpage(r.APP_MANAGEMENT, PLUGIN_VM_USB_PREFERENCES_SUBPAGE_PATH, Subpage.kPluginVmUsbPreferences);
    }
    r.MANAGE_ISOLATED_WEB_APPS = createSubpage(r.APPS, MANAGE_ISOLATED_WEB_APPS_SUBPAGE_PATH, Subpage.kManageIsolatedWebApps);
    if (isAppParentalControlsFeatureAvailable()) {
        r.APP_PARENTAL_CONTROLS = createSubpage(r.APPS, APP_PARENTAL_CONTROLS_SUBPAGE_PATH, Subpage.kAppParentalControls);
    }
    // Accessibility section.
    r.OS_ACCESSIBILITY = createSection(r.BASIC, ACCESSIBILITY_SECTION_PATH, Section.kAccessibility);
    r.MANAGE_ACCESSIBILITY = createSubpage(r.OS_ACCESSIBILITY, MANAGE_ACCESSIBILITY_SUBPAGE_PATH, Subpage.kManageAccessibility);
    const a11yParentRoute = loadTimeData.getBoolean('isKioskModeActive') ?
        r.MANAGE_ACCESSIBILITY :
        r.OS_ACCESSIBILITY;
    r.A11Y_TEXT_TO_SPEECH = createSubpage(a11yParentRoute, TEXT_TO_SPEECH_PAGE_PATH, Subpage.kTextToSpeechPage);
    r.A11Y_DISPLAY_AND_MAGNIFICATION = createSubpage(a11yParentRoute, DISPLAY_AND_MAGNIFICATION_SUBPAGE_PATH, Subpage.kDisplayAndMagnification);
    r.A11Y_KEYBOARD_AND_TEXT_INPUT = createSubpage(a11yParentRoute, KEYBOARD_AND_TEXT_INPUT_SUBPAGE_PATH, Subpage.kKeyboardAndTextInput);
    r.A11Y_CURSOR_AND_TOUCHPAD = createSubpage(a11yParentRoute, CURSOR_AND_TOUCHPAD_SUBPAGE_PATH, Subpage.kCursorAndTouchpad);
    r.A11Y_AUDIO_AND_CAPTIONS = createSubpage(a11yParentRoute, AUDIO_AND_CAPTIONS_SUBPAGE_PATH, Subpage.kAudioAndCaptions);
    r.A11Y_CHROMEVOX = createSubpage(r.A11Y_TEXT_TO_SPEECH, CHROME_VOX_SUBPAGE_PATH, Subpage.kChromeVox);
    r.A11Y_SELECT_TO_SPEAK = createSubpage(r.A11Y_TEXT_TO_SPEECH, SELECT_TO_SPEAK_SUBPAGE_PATH, Subpage.kSelectToSpeak);
    r.MANAGE_TTS_SETTINGS = createSubpage(r.A11Y_TEXT_TO_SPEECH, TEXT_TO_SPEECH_SUBPAGE_PATH, Subpage.kTextToSpeech);
    r.MANAGE_SWITCH_ACCESS_SETTINGS = createSubpage(r.A11Y_KEYBOARD_AND_TEXT_INPUT, SWITCH_ACCESS_OPTIONS_SUBPAGE_PATH, Subpage.kSwitchAccessOptions);
    r.MANAGE_FACEGAZE_SETTINGS = createSubpage(r.A11Y_CURSOR_AND_TOUCHPAD, FACE_GAZE_SETTINGS_SUBPAGE_PATH, Subpage.kFaceGazeSettings);
    r.MANAGE_MOUSE_KEYS_SETTINGS = createSubpage(r.A11Y_CURSOR_AND_TOUCHPAD, MOUSE_KEYS_SETTINGS_SUBPAGE_PATH, Subpage.kMouseKeysSettings);
    // Privacy and Security section.
    r.OS_PRIVACY = createSection(r.BASIC, PRIVACY_AND_SECURITY_SECTION_PATH, Section.kPrivacyAndSecurity);
    r.LOCK_SCREEN = createSubpage(r.OS_PRIVACY, SECURITY_AND_SIGN_IN_SUBPAGE_PATH_V2, Subpage.kSecurityAndSignInV2);
    r.FINGERPRINT = createSubpage(r.LOCK_SCREEN, FINGERPRINT_SUBPAGE_PATH_V2, Subpage.kFingerprintV2);
    r.ACCOUNTS = createSubpage(r.OS_PRIVACY, MANAGE_OTHER_PEOPLE_SUBPAGE_PATH_V2, Subpage.kManageOtherPeopleV2);
    r.SMART_PRIVACY = createSubpage(r.OS_PRIVACY, SMART_PRIVACY_SUBPAGE_PATH, Subpage.kSmartPrivacy);
    r.PRIVACY_HUB = createSubpage(r.OS_PRIVACY, PRIVACY_HUB_SUBPAGE_PATH, Subpage.kPrivacyHub);
    r.PRIVACY_HUB_MICROPHONE = createSubpage(r.OS_PRIVACY, PRIVACY_HUB_MICROPHONE_SUBPAGE_PATH, Subpage.kPrivacyHubMicrophone);
    r.PRIVACY_HUB_GEOLOCATION = createSubpage(r.OS_PRIVACY, PRIVACY_HUB_GEOLOCATION_SUBPAGE_PATH, Subpage.kPrivacyHubGeolocation);
    r.PRIVACY_HUB_GEOLOCATION_ADVANCED = createSubpage(r.PRIVACY_HUB_GEOLOCATION, PRIVACY_HUB_GEOLOCATION_ADVANCED_SUBPAGE_PATH, Subpage.kPrivacyHubGeolocationAdvanced);
    r.PRIVACY_HUB_CAMERA = createSubpage(r.OS_PRIVACY, PRIVACY_HUB_CAMERA_SUBPAGE_PATH, Subpage.kPrivacyHubCamera);
    // About section.
    r.ABOUT = createSection(
    /*parent=*/ null, ABOUT_CHROME_OS_SECTION_PATH, Section.kAboutChromeOs);
    r.ABOUT_DETAILED_BUILD_INFO = createSubpage(r.ABOUT, DETAILED_BUILD_INFO_SUBPAGE_PATH, Subpage.kDetailedBuildInfo);
    // Internal pages (under About section).
    r.INTERNAL_STORYBOOK = createSubpage(r.ABOUT, INTERNAL_STORYBOOK_SUBPAGE_PATH, Subpage.kInternalStorybook);
    // Device section, Input subpages.
    r.OS_LANGUAGES_INPUT = createSubpage(r.PER_DEVICE_KEYBOARD, INPUT_SUBPAGE_PATH, Subpage.kInput);
    r.OS_LANGUAGES_INPUT_METHOD_OPTIONS = createSubpage(r.OS_LANGUAGES_INPUT, INPUT_METHOD_OPTIONS_SUBPAGE_PATH, Subpage.kInputMethodOptions);
    r.OS_LANGUAGES_EDIT_DICTIONARY = createSubpage(r.OS_LANGUAGES_INPUT, EDIT_DICTIONARY_SUBPAGE_PATH, Subpage.kEditDictionary);
    r.OS_LANGUAGES_JAPANESE_MANAGE_USER_DICTIONARY = createSubpage(r.OS_LANGUAGES_INPUT, JAPANESE_MANAGE_USER_DICTIONARY_SUBPAGE_PATH, Subpage.kJapaneseManageUserDictionary);
    // System Preferences section.
    r.SYSTEM_PREFERENCES = createSection(r.BASIC, SYSTEM_PREFERENCES_SECTION_PATH, Section.kSystemPreferences);
    // Date and Time subpages.
    r.DATETIME_TIMEZONE_SUBPAGE = createSubpage(r.SYSTEM_PREFERENCES, TIME_ZONE_SUBPAGE_PATH, Subpage.kTimeZone);
    // Files subpages.
    if (!isGuest()) {
        r.GOOGLE_DRIVE = createSubpage(r.SYSTEM_PREFERENCES, GOOGLE_DRIVE_SUBPAGE_PATH, Subpage.kGoogleDrive);
        if (loadTimeData.getBoolean('showOfficeSettings')) {
            r.OFFICE = createSubpage(r.SYSTEM_PREFERENCES, OFFICE_FILES_SUBPAGE_PATH, Subpage.kOfficeFiles);
        }
        if (loadTimeData.getBoolean('showOneDriveSettings')) {
            r.ONE_DRIVE = createSubpage(r.SYSTEM_PREFERENCES, ONE_DRIVE_SUBPAGE_PATH, Subpage.kOneDrive);
        }
        r.SMB_SHARES = createSubpage(r.SYSTEM_PREFERENCES, NETWORK_FILE_SHARES_SUBPAGE_PATH, Subpage.kNetworkFileShares);
    }
    // Language subpages.
    r.OS_LANGUAGES_LANGUAGES = createSubpage(r.SYSTEM_PREFERENCES, LANGUAGES_SUBPAGE_PATH, Subpage.kLanguages);
    if (loadTimeData.getBoolean('isPerAppLanguageEnabled')) {
        r.OS_LANGUAGES_APP_LANGUAGES = createSubpage(r.OS_LANGUAGES_LANGUAGES, APP_LANGUAGES_SUBPAGE_PATH, Subpage.kAppLanguages);
    }
    // Search subpages.
    r.SEARCH_SUBPAGE = createSubpage(r.SYSTEM_PREFERENCES, SEARCH_SUBPAGE_PATH, Subpage.kSearch);
    // Storage and power subpages.
    r.STORAGE = createSubpage(r.SYSTEM_PREFERENCES, STORAGE_SUBPAGE_PATH, Subpage.kStorage);
    r.EXTERNAL_STORAGE_PREFERENCES = createSubpage(r.STORAGE, EXTERNAL_STORAGE_SUBPAGE_PATH, Subpage.kExternalStorage);
    r.POWER = createSubpage(r.SYSTEM_PREFERENCES, POWER_SUBPAGE_PATH, Subpage.kPower);
    // Printing subpage.
    r.CUPS_PRINTERS = createSubpage(r.DEVICE, PRINTING_DETAILS_SUBPAGE_PATH, Subpage.kPrintingDetails);
    // Crostini subpages.
    if (isCrostiniSupported()) {
        r.CROSTINI_DETAILS = createSubpage(r.ABOUT, CROSTINI_DETAILS_SUBPAGE_PATH, Subpage.kCrostiniDetails);
        r.BRUSCHETTA_DETAILS = createSubpage(r.ABOUT, BRUSCHETTA_DETAILS_SUBPAGE_PATH, Subpage.kBruschettaDetails);
    }
    // Sync subpages.
    if (!isGuest()) {
        assert$1(r.OS_PRIVACY);
        r.OS_SYNC_SETUP = createSubpage(r.OS_PRIVACY, SYNC_SETUP_SUBPAGE_PATH, Subpage.kSyncSetup);
        r.OS_SYNC_CONTROLS = createSubpage(r.OS_SYNC_SETUP, SYNC_CONTROLS_SUBPAGE_PATH, Subpage.kSyncControls);
    }
    // Crostini details subpages.
    if (isCrostiniSupported()) {
        assert$1(r.CROSTINI_DETAILS);
        assert$1(r.BRUSCHETTA_DETAILS);
        r.CROSTINI_SHARED_PATHS = createSubpage(r.CROSTINI_DETAILS, CROSTINI_MANAGE_SHARED_FOLDERS_SUBPAGE_PATH, Subpage.kCrostiniManageSharedFolders);
        r.CROSTINI_SHARED_USB_DEVICES = createSubpage(r.CROSTINI_DETAILS, CROSTINI_USB_PREFERENCES_SUBPAGE_PATH, Subpage.kCrostiniUsbPreferences);
        if (loadTimeData.valueExists('showCrostiniExportImport') &&
            loadTimeData.getBoolean('showCrostiniExportImport')) {
            r.CROSTINI_EXPORT_IMPORT = createSubpage(r.CROSTINI_DETAILS, CROSTINI_BACKUP_AND_RESTORE_SUBPAGE_PATH, Subpage.kCrostiniBackupAndRestore);
        }
        if (loadTimeData.valueExists('showCrostiniExtraContainers') &&
            loadTimeData.getBoolean('showCrostiniExtraContainers')) {
            r.CROSTINI_EXTRA_CONTAINERS = createSubpage(r.CROSTINI_DETAILS, CROSTINI_EXTRA_CONTAINERS_SUBPAGE_PATH, Subpage.kCrostiniExtraContainers);
        }
        r.CROSTINI_ANDROID_ADB = createSubpage(r.CROSTINI_DETAILS, CROSTINI_DEVELOP_ANDROID_APPS_SUBPAGE_PATH, Subpage.kCrostiniDevelopAndroidApps);
        r.CROSTINI_PORT_FORWARDING = createSubpage(r.CROSTINI_DETAILS, CROSTINI_PORT_FORWARDING_SUBPAGE_PATH, Subpage.kCrostiniPortForwarding);
        r.BRUSCHETTA_SHARED_USB_DEVICES = createSubpage(r.BRUSCHETTA_DETAILS, BRUSCHETTA_USB_PREFERENCES_SUBPAGE_PATH, Subpage.kBruschettaUsbPreferences);
        r.BRUSCHETTA_SHARED_PATHS = createSubpage(r.BRUSCHETTA_DETAILS, BRUSCHETTA_MANAGE_SHARED_FOLDERS_SUBPAGE_PATH, Subpage.kBruschettaManageSharedFolders);
    }
    return r;
}
const PATH_REDIRECT_PAIRS = [
    // TODO(b/309808834) Remove this pair once the Bluetooth L1 page is revamped
    // with up-leveled content.
    [
        BLUETOOTH_SECTION_PATH,
        BLUETOOTH_DEVICES_SUBPAGE_PATH,
    ],
];
/**
 * An object of path redirects. The key represents a given path and the value
 * represents the resulting path that should be redirected to. Path strings
 * always include a leading slash.
 */
const PATH_REDIRECTS = Object.fromEntries(PATH_REDIRECT_PAIRS.map(([path, redirectPath]) => {
    return [`/${path}`, `/${redirectPath}`];
}));

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Regular expression that captures the leading slash, the content and the
 * trailing slash in three different groups.
 */
const CANONICAL_PATH_REGEX = /(^\/)([\/-\w]+)(\/$)/;
/** The Router singleton instance. */
let routerInstance = null;
/**
 * Represents the available set of routes for the Router singleton. This is
 * exported as a convenience to avoid always calling the more verbose way
 * `Router.getInstance().routes`.
 *
 * When the Router singleton is updated (i.e. from tests), this export should
 * also be updated to reflect the new set of routes.
 */
let routes;
class Router {
    static getInstance() {
        assert$1(routerInstance, 'Router instance has not been set yet.');
        return routerInstance;
    }
    static setInstance(instance) {
        assert$1(routerInstance === null, 'Router instance has already been set.');
        routerInstance = instance;
        routes = instance.routes;
    }
    static resetInstanceForTesting(instance) {
        if (routerInstance) {
            instance.routeObservers_ = routerInstance.routeObservers_;
        }
        routerInstance = instance;
        routes = instance.routes;
    }
    constructor(availableRoutes) {
        /**
         * List of available routes. This is populated taking into account current
         * state (like guest mode).
         */
        this.routes_ = availableRoutes;
        /**
         * The current active route. This updated is only by navigateTo() or
         * initializeRouteFromUrl().
         */
        this.currentRoute_ = this.routes_.BASIC;
        /**
         * The current query parameters. This is updated only by
         * settings.navigateTo or settings.initializeRouteFromUrl.
         */
        this.currentQueryParameters_ = new URLSearchParams();
        this.lastRouteChangeWasPopstate_ = false;
        this.initializeRouteFromUrlCalled_ = false;
        this.routeObservers_ = new Set();
    }
    // Convenience helper to index this.routes_ via bracket notation
    // e.g. this.routesMap_[routeName] // => Route
    get routesMap_() {
        return this.routes_;
    }
    get routes() {
        return this.routes_;
    }
    get currentRoute() {
        return this.currentRoute_;
    }
    addObserver(observer) {
        assert$1(!this.routeObservers_.has(observer));
        this.routeObservers_.add(observer);
    }
    removeObserver(observer) {
        assert$1(this.routeObservers_.delete(observer));
    }
    getRoute(route) {
        return this.routesMap_[route];
    }
    /**
     * Helper function to set the current route and notify all observers.
     */
    setCurrentRoute(route, queryParameters, isPopstate) {
        this.recordMetrics_(route.path);
        const prevRoute = this.currentRoute_;
        this.currentRoute_ = route;
        this.currentQueryParameters_ = queryParameters;
        this.lastRouteChangeWasPopstate_ = isPopstate;
        this.routeObservers_.forEach((observer) => {
            observer.currentRouteChanged(this.currentRoute_, prevRoute);
        });
        this.updateTitle_();
    }
    /**
     * Updates the page title to reflect the current route.
     */
    updateTitle_() {
        if (this.currentRoute_.title) {
            document.title = loadTimeData.getStringF('settingsAltPageTitle', this.currentRoute_.title);
        }
        else if (this.currentRoute_.isNavigableDialog &&
            this.currentRoute_.parent?.title) {
            document.title = loadTimeData.getStringF('settingsAltPageTitle', this.currentRoute_.parent.title);
        }
        else if (!this.currentRoute_.isSubpage() &&
            !this.routes_.ABOUT.contains(this.currentRoute_)) {
            document.title = loadTimeData.getString('settings');
        }
    }
    getQueryParameters() {
        return new URLSearchParams(this.currentQueryParameters_); // Defensive copy.
    }
    lastRouteChangeWasPopstate() {
        return this.lastRouteChangeWasPopstate_;
    }
    /**
     * @return a Route matching the |path| containing a leading "/",
     * or null if none matched.
     */
    getRouteForPath(path) {
        assert$1(path[0] === '/', 'Path must contain a leading slash.');
        // Remove any trailing slash.
        let canonicalPath = path.replace(CANONICAL_PATH_REGEX, '$1$2');
        // Handle redirects for paths (e.g. deprecated paths).
        canonicalPath = PATH_REDIRECTS[canonicalPath] || canonicalPath;
        const matchingRoute = Object.values(this.routes_).find(route => {
            return route.path === canonicalPath && isNavigableRoute(route);
        });
        return matchingRoute || null;
    }
    /**
     * Updates the URL parameters of the current route via exchanging the
     * window history state. This changes the Settings route path, but doesn't
     * change the route itself, hence does not push a new route history entry.
     * Notifies routeChangedObservers.
     */
    updateUrlParams(params) {
        let url = this.currentRoute_.path;
        const queryString = params.toString();
        if (queryString) {
            url += '?' + queryString;
        }
        window.history.replaceState(window.history.state, '', url);
        // We can't call |setCurrentRoute()| for the following, as it would also
        // update |oldRoute| and |currentRoute|, which should not happen when
        // only the URL parameters are updated.
        this.currentQueryParameters_ = params;
        this.routeObservers_.forEach((observer) => {
            observer.currentRouteChanged(this.currentRoute_, this.currentRoute_);
        });
    }
    /**
     * Navigates to a canonical route and pushes a new history entry.
     * @param dynamicParameters Navigations to the same URL parameters in a
     *     different order will still push to history.
     * @param removeSearch Whether to strip the 'search' URL parameter during
     *     navigation. Defaults to false.
     */
    navigateTo(route, dynamicParameters, removeSearch) {
        if (!isNavigableRoute(route)) {
            route = this.routes_.BASIC;
        }
        const params = dynamicParameters || new URLSearchParams();
        const oldSearchParam = this.getQueryParameters().get('search') || '';
        const newSearchParam = params.get('search') || '';
        if (!removeSearch && oldSearchParam && !newSearchParam) {
            params.append('search', oldSearchParam);
        }
        let url = route.path;
        const queryString = params.toString();
        if (queryString) {
            url += '?' + queryString;
        }
        // History serializes the state, so we don't push the actual route object.
        window.history.pushState(this.currentRoute_.path, '', url);
        this.setCurrentRoute(route, params, false);
    }
    /**
     * Navigates to the previous route if it has an equal or lesser depth.
     * If there is no previous route in history meeting those requirements,
     * this navigates to the immediate parent. This will never exit Settings.
     */
    navigateToPreviousRoute() {
        let previousRoute = null;
        if (window.history.state) {
            previousRoute = castExists$2(this.getRouteForPath(window.history.state));
        }
        if (previousRoute && previousRoute.depth <= this.currentRoute_.depth) {
            window.history.back();
        }
        else {
            this.navigateTo(this.currentRoute_.parent || this.routes_.BASIC);
        }
    }
    /**
     * Initialize the route and query params from the URL.
     */
    initializeRouteFromUrl() {
        assert$1(!this.initializeRouteFromUrlCalled_, 'initializeRouteFromUrl() can only be called once.');
        this.initializeRouteFromUrlCalled_ = true;
        const route = this.getRouteForPath(window.location.pathname);
        // Record all correct paths entered on the settings page, and
        // as all incorrect paths are routed to the main settings page,
        // record all incorrect paths as hitting the main settings page.
        this.recordMetrics_(route ? route.path : this.routes_.BASIC.path);
        if (route && isNavigableRoute(route)) {
            this.currentRoute_ = route;
            this.currentQueryParameters_ =
                new URLSearchParams(window.location.search);
        }
        else {
            window.history.replaceState(undefined, '', this.routes_.BASIC.path);
        }
        this.updateTitle_();
    }
    resetRouteForTesting() {
        this.initializeRouteFromUrlCalled_ = false;
        this.lastRouteChangeWasPopstate_ = false;
        this.currentRoute_ = this.routes_.BASIC;
        this.currentQueryParameters_ = new URLSearchParams();
    }
    /**
     * Make a UMA note about visiting this URL path.
     */
    recordMetrics_(urlPath) {
        assert$1(!urlPath.startsWith('chrome://'));
        assert$1(!urlPath.startsWith('os-settings'));
        assert$1(urlPath.startsWith('/'));
        assert$1(!urlPath.match(/\?/g)); // query params should not be included
        const METRIC_NAME = 'ChromeOS.Settings.PathVisited';
        chrome.metricsPrivate.recordSparseValueWithPersistentHash(METRIC_NAME, urlPath);
    }
}
/**
 * Creates a Router instance and returns it. Use `Router.setInstance()` with
 * this instance as an argument to set the singleton instance.
 *
 * Can be used from tests to re-create a Router with a new set of routes.
 */
function createRouter() {
    return new Router(createRoutes());
}
Router.setInstance(createRouter());
window.addEventListener('popstate', () => {
    // On pop state, do not push the state onto the window.history again.
    const router = Router.getInstance();
    router.setCurrentRoute(router.getRouteForPath(window.location.pathname) || routes.BASIC, new URLSearchParams(window.location.search), true);
});
/**
 * @returns true if |route| is able to be directly navigated to (ie. there
 * is a dedicated page or subpage that exists for the given route).
 */
function isNavigableRoute(route) {
    if (!route) {
        return false;
    }
    // The ADVANCED route is not navigable. It only serves as a parent to group
    // child routes.
    return route !== routes.ADVANCED;
}

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Utility function for retrieving the deep linked setting ID
 * from the Url parameter.
 */
const SETTING_ID_URL_PARAM_NAME = 'settingId';
/**
 * Retrieves the setting ID saved in the URL's query parameter. Returns null if
 * setting ID is unavailable.
 */
function getSettingIdParameter() {
    return Router.getInstance().getQueryParameters().get(SETTING_ID_URL_PARAM_NAME);
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Polymer mixin for scrolling/focusing/indicating
 * setting elements with deep links.
 */
const DEEP_LINK_FOCUS_ID = 'deep-link-focus-id';
const DeepLinkingMixin = dedupingMixin((superClass) => {
    class DeepLinkingMixinInternal extends superClass {
        constructor() {
            super(...arguments);
            /**
             * Set of setting IDs that could be deep linked to. Initialized as an
             * empty set, should be overridden with applicable setting IDs.
             */
            this.supportedSettingIds = new Set();
        }
        static get properties() {
            return {
                /**
                 * An object whose values are the kSetting mojom values. Defined
                 * as a property so that the Setting enum values can be used in
                 * the element's HTML template to define deep link ID attributes.
                 */
                Setting: {
                    type: Object,
                    value: Setting,
                },
            };
        }
        /**
         * Retrieves the settingId saved in the url's query parameter. Returns
         * null if deep linking is disabled or if no settingId is found.
         */
        getDeepLinkSettingId() {
            const settingIdStr = getSettingIdParameter();
            if (!settingIdStr) {
                return null;
            }
            const settingIdNum = Number(settingIdStr);
            if (isNaN(settingIdNum)) {
                return null;
            }
            return settingIdNum;
        }
        /**
         * Focuses the deep linked element referred to by |settingId|. Returns a
         * Promise for an object that reflects if the deep link was shown or
         * not. The object has a boolean |deepLinkShown| and any
         * |pendingSettingId| that couldn't be shown.
         */
        showDeepLink(settingId) {
            return new Promise(resolve => {
                afterNextRender(this, () => {
                    const elToFocus = this.shadowRoot.querySelector(`[${DEEP_LINK_FOCUS_ID}~="${settingId}"]`);
                    if (!elToFocus || elToFocus.hidden) {
                        console.warn(`Element with deep link id ${settingId} not focusable.`);
                        resolve({ deepLinkShown: false, pendingSettingId: settingId });
                        return;
                    }
                    this.showDeepLinkElement(elToFocus);
                    resolve({ deepLinkShown: true, pendingSettingId: settingId });
                });
            });
        }
        /**
         * Focuses the deep linked element |elem|. Returns whether the deep link
         * was shown or not.
         */
        showDeepLinkElement(elToFocus) {
            elToFocus.focus();
        }
        /**
         * Override this method to execute code after a supported settingId is
         * found and before the deep link is shown. Returns whether or not the
         * deep link attempt should continue. Default behavior is to no op and
         * then return true, continuing the deep link attempt.
         */
        beforeDeepLinkAttempt(_settingId) {
            return true;
        }
        /**
         * Checks if there are settingIds that can be linked to and attempts to
         * show the deep link. Returns a Promise for an object that reflects if
         * the deep link was shown or not. The object has a boolean
         * |deepLinkShown| and any |pendingSettingId| that couldn't be shown.
         */
        attemptDeepLink() {
            const settingId = this.getDeepLinkSettingId();
            // Explicitly check for null to handle settingId = 0.
            if (settingId === null || !this.supportedSettingIds.has(settingId)) {
                // No deep link was shown since the settingId was unsupported.
                return Promise.resolve({ deepLinkShown: false, pendingSettingId: null });
            }
            const shouldContinue = this.beforeDeepLinkAttempt(settingId);
            if (!shouldContinue) {
                // Don't continue the deep link attempt since it was presumably
                // handled manually in beforeDeepLinkAttempt().
                return Promise.resolve({ deepLinkShown: false, pendingSettingId: settingId });
            }
            return this.showDeepLink(settingId);
        }
    }
    return DeepLinkingMixinInternal;
});

// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
let hideInk = false;
document.addEventListener('pointerdown', function () {
    hideInk = true;
}, true);
document.addEventListener('keydown', function () {
    hideInk = false;
}, true);
/**
 * Attempts to track whether focus outlines should be shown, and if they
 * shouldn't, removes the "ink" (ripple) from a control while focusing it.
 * This is helpful when a user is clicking/touching, because it's not super
 * helpful to show focus ripples in that case. This is Polymer-specific.
 */
function focusWithoutInk(toFocus) {
    // |toFocus| does not have a 'noink' property, so it's unclear whether the
    // element has "ink" and/or whether it can be suppressed. Just focus().
    if (!('noink' in toFocus) || !hideInk) {
        toFocus.focus();
        return;
    }
    const toFocusWithNoInk = toFocus;
    // Make sure the element is in the document we're listening to events on.
    assert$1(document === toFocusWithNoInk.ownerDocument);
    const { noink } = toFocusWithNoInk;
    toFocusWithNoInk.noink = true;
    toFocusWithNoInk.focus();
    toFocusWithNoInk.noink = noink;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const RouteObserverMixin = dedupingMixin((superClass) => {
    class RouteObserverMixin extends superClass {
        connectedCallback() {
            super.connectedCallback();
            const routerInstance = Router.getInstance();
            routerInstance.addObserver(this);
            // Emulating Polymer data bindings, the observer is called when the
            // element starts observing the route.
            this.currentRouteChanged(routerInstance.currentRoute, undefined);
        }
        disconnectedCallback() {
            super.disconnectedCallback();
            Router.getInstance().removeObserver(this);
        }
        currentRouteChanged(_newRoute, _oldRoute) {
            assertNotReached$1('Element must implement currentRouteChanged().');
        }
    }
    return RouteObserverMixin;
});

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * Extends the RouteObserverMixin by adding focus configuration via a mapping
 * of Route path to element selector. When exiting a subpage via back
 * navigation, the element which triggers the subpage's route will be focused.
 *
 * Subscribing elements must specify their `route` instance variable and call
 * the `currentRouteChanged()` super method.
 */
const RouteOriginMixin = dedupingMixin((superClass) => {
    const superClassBase = RouteObserverMixin(superClass);
    class RouteOriginMixin extends superClassBase {
        constructor() {
            super(...arguments);
            /**
             * The route corresponding to this page.
             */
            this.route = undefined;
        }
        static get properties() {
            return {
                /**
                 * A Map specifying which element should be focused when exiting a
                 * subpage. The key of the map holds a Route object's path, and the
                 * value holds the configuration to find and focus the element. See
                 * addFocusConfig() for more details.
                 */
                focusConfig_: {
                    type: Object,
                    value: () => new Map(),
                },
            };
        }
        connectedCallback() {
            super.connectedCallback();
            // All elements using this mixin must specify their route.
            assertInstanceof$1(this.route, Route, `Route origin element "${this.tagName}" must specify its route.`);
        }
        currentRouteChanged(newRoute, prevRoute) {
            // Only attempt to focus an anchor element if the most recent
            // navigation was a 'pop' (backwards) navigation.
            if (!Router.getInstance().lastRouteChangeWasPopstate()) {
                return;
            }
            // Route change does not apply to the route for this page.
            if (newRoute !== this.route && newRoute !== routes.BASIC) {
                return;
            }
            if (prevRoute) {
                // Defer focusing trigger element until after next render
                afterNextRender(this, () => {
                    this.focusTriggerElement(prevRoute);
                });
            }
        }
        /**
         * Adds a route path to |this.focusConfig_| if the route exists.
         * Otherwise it does nothing.
         * @param value One of the following:
         *  1) A string representing a query selector for the element.
         *  2) A reference to the element.
         *  3) A function that returns the element, or returns null if the
         *     element will be focused manually.
         */
        addFocusConfig(route, value) {
            if (route) {
                this.focusConfig_.set(route.path, value);
            }
        }
        /**
         * Focuses the element for a given route by finding the associated
         * query selector or calling the configured function.
         */
        focusTriggerElement(route) {
            const config = this.focusConfig_.get(route.path);
            if (!config) {
                return;
            }
            let element = null;
            if (typeof config === 'function') {
                element = config();
            }
            else if (typeof config === 'string') {
                element = this.shadowRoot.querySelector(config);
            }
            else if (config instanceof HTMLElement) {
                element = config;
            }
            if (element) {
                focusWithoutInk(element);
            }
        }
    }
    return RouteOriginMixin;
});

const styleMod$7 = document.createElement('dom-module');
styleMod$7.appendChild(html `
  <template>
    <style>
:host{--cr-input-background-color:var(--google-grey-100);--cr-input-color:var(--cr-primary-text-color);--cr-input-error-color:var(--google-red-600);--cr-input-focus-color:var(--google-blue-600);display:block;outline:none}:host-context([chrome-refresh-2023]):host{--cr-input-background-color:var(--color-textfield-filled-background,var(--cr-fallback-color-surface-variant));--cr-input-border-bottom:1px solid var(--color-textfield-filled-underline,var(--cr-fallback-color-outline));--cr-input-border-radius:8px 8px 0 0;--cr-input-error-color:var(--color-textfield-filled-error,var(--cr-fallback-color-error));--cr-input-focus-color:var(--color-textfield-filled-underline-focused,var(--cr-fallback-color-primary));--cr-input-hover-background-color:var(--cr-hover-background-color);--cr-input-label-color:var(--color-textfield-foreground-label,var(--cr-fallback-color-on-surface-subtle));--cr-input-padding-bottom:10px;--cr-input-padding-end:10px;--cr-input-padding-start:10px;--cr-input-padding-top:10px;--cr-input-placeholder-color:var(--color-textfield-foreground-placeholder,var(--cr-fallback-on-surface-subtle));isolation:isolate}:host-context([chrome-refresh-2023]):host([readonly]){--cr-input-border-radius:8px 8px}@media (prefers-color-scheme:dark){:host{--cr-input-background-color:rgba(0,0,0,.3);--cr-input-error-color:var(--google-red-300);--cr-input-focus-color:var(--google-blue-300)}}:host-context(html:not([chrome-refresh-2023])):host([focused_]:not([readonly]):not([invalid])) #label{color:var(--cr-input-focus-color)}:host-context([chrome-refresh-2023]) #label{color:var(--cr-input-label-color);font-size:11px;line-height:16px}:host-context([chrome-refresh-2023]):host([focused_]:not([readonly]):not([invalid])) #label{color:var(--cr-input-focus-label-color,var(--cr-input-label-color))}#input-container{border-radius:var(--cr-input-border-radius,4px);overflow:hidden;position:relative;width:var(--cr-input-width,100%)}:host-context([chrome-refresh-2023]):host([focused_]) #input-container{outline:var(--cr-input-focus-outline,none)}#inner-input-container{background-color:var(--cr-input-background-color);box-sizing:border-box;padding:0}:host-context([chrome-refresh-2023]) #inner-input-content ::slotted(*){--cr-icon-button-fill-color:var(--color-textfield-foreground-icon,var(--cr-fallback-color-on-surface-subtle));--cr-icon-button-icon-size:16px;--cr-icon-button-size:24px;--cr-icon-button-margin-start:0;--cr-icon-color:var(--color-textfield-foreground-icon,var(--cr-fallback-color-on-surface-subtle))}:host-context([chrome-refresh-2023]) #inner-input-content ::slotted([slot='inline-prefix']){--cr-icon-button-margin-start:-8px}:host-context([chrome-refresh-2023]) #inner-input-content ::slotted([slot='inline-suffix']){--cr-icon-button-margin-end:-4px}:host-context([chrome-refresh-2023]):host([invalid]) #inner-input-content ::slotted(*){--cr-icon-color:var(--cr-input-error-color);--cr-icon-button-fill-color:var(--cr-input-error-color)}#hover-layer{display:none}:host-context([chrome-refresh-2023]) #hover-layer{background-color:var(--cr-input-hover-background-color);inset:0;pointer-events:none;position:absolute;z-index:0}:host-context([chrome-refresh-2023]):host(:not([readonly]):not([disabled])) #input-container:hover #hover-layer{display:block}#input{-webkit-appearance:none;background-color:transparent;border:none;box-sizing:border-box;caret-color:var(--cr-input-focus-color);color:var(--cr-input-color);font-family:inherit;font-size:inherit;font-weight:inherit;line-height:inherit;min-height:var(--cr-input-min-height,auto);outline:none;padding-bottom:var(--cr-input-padding-bottom,6px);padding-inline-end:var(--cr-input-padding-end,8px);padding-inline-start:var(--cr-input-padding-start,8px);padding-top:var(--cr-input-padding-top,6px);text-align:inherit;text-overflow:ellipsis;width:100%}:host-context([chrome-refresh-2023]) #input{font-size:12px;line-height:16px;padding:0}:host-context([chrome-refresh-2023]) #inner-input-content{padding-bottom:var(--cr-input-padding-bottom);padding-inline-end:var(--cr-input-padding-end);padding-inline-start:var(--cr-input-padding-start);padding-top:var(--cr-input-padding-top)}#underline{border-bottom:2px solid var(--cr-input-focus-color);border-radius:var(--cr-input-underline-border-radius,0);bottom:0;box-sizing:border-box;display:var(--cr-input-underline-display);height:var(--cr-input-underline-height,0);left:0;margin:auto;opacity:0;position:absolute;right:0;transition:opacity 120ms ease-out,width 0s linear 180ms;width:0}:host([invalid]) #underline,:host([force-underline]) #underline,:host([focused_]) #underline{opacity:1;transition:opacity 120ms ease-in,width 180ms ease-out;width:100%}#underline-base{display:none}:host-context([chrome-refresh-2023]):host([readonly]) #underline{display:none}:host-context([chrome-refresh-2023]):host(:not([readonly])) #underline-base{border-bottom:var(--cr-input-border-bottom);bottom:0;display:block;left:0;position:absolute;right:0}:host-context([chrome-refresh-2023]):host([disabled]){color:var(--color-textfield-foreground-disabled,var(--cr-fallback-color-disabled-foreground));--cr-input-border-bottom:1px solid currentColor;--cr-input-placeholder-color:currentColor;--cr-input-color:currentColor;--cr-input-background-color:var(--color-textfield-background-disabled,var(--cr-fallback-color-disabled-background))}:host-context([chrome-refresh-2023]):host([disabled]) #inner-input-content ::slotted(*){--cr-icon-color:currentColor;--cr-icon-button-fill-color:currentColor}
    </style>
  </template>
`.content);
styleMod$7.register('cr-input-style');

function getTemplate$1J() {
    return html `<!--_html_template_start_--><style include="cr-hidden-style cr-input-style cr-shared-style">
  /*
    A 'suffix' element will be outside the underlined space, while a
    'inline-prefix' and 'inline-suffix' elements will be inside the
    underlined space by default.

    Regarding cr-input's width:
    When there's no element in the 'inline-prefix', 'inline-suffix' or
    'suffix' slot, setting the width of cr-input as follows will work as
    expected:

      cr-input {
        width: 200px;
      }

    However, when there's an element in the 'suffix', 'inline-suffix' and/or
    'inline-prefix' slot, setting the 'width' will dictate the total width
    of the input field *plus* the 'inline-prefix', 'inline-suffix' and
    'suffix' elements. To set the width of the input field +
    'inline-prefix' + 'inline-suffix' when a 'suffix' is present,
    use --cr-input-width.

      cr-input {
        --cr-input-width: 200px;
      }
  */

  /* Disabled status should not impact suffix slot. */
  :host([disabled]) :-webkit-any(#label, #error, #input-container) {
    opacity: var(--cr-disabled-opacity);
    pointer-events: none;
  }

  :host-context([chrome-refresh-2023]):host([disabled])
      :is(#label, #error, #input-container) {
    opacity: 1;
  }

  /* Margin between <input> and <cr-button> in the 'suffix' slot */
  :host ::slotted(cr-button[slot=suffix]) {
    margin-inline-start: var(--cr-button-edge-spacing) !important;
  }

  :host([invalid]) #label {
    color: var(--cr-input-error-color);
  }

  #input {
    border-bottom: var(--cr-input-border-bottom, none);
    letter-spacing: var(--cr-input-letter-spacing);
  }

  #input::selection {
    background-color: var(--cros-sys-highlight_text);
  }

  :host-context([chrome-refresh-2023]) #input {
    border-bottom: none;
  }

  :host-context([chrome-refresh-2023]) #input-container {
    border: var(--cr-input-border, none);
  }

  #input::placeholder {
    color: var(--cr-input-placeholder-color, var(--cr-secondary-text-color));
    letter-spacing: var(--cr-input-placeholder-letter-spacing);
  }

  :host([invalid]) #input {
    caret-color: var(--cr-input-error-color);
  }

  :host([readonly]) #input {
    opacity: var(--cr-input-readonly-opacity, 0.6);
  }

  :host([invalid]) #underline {
    border-color: var(--cr-input-error-color);
  }

  /* Error styling below. */
  #error {
    /* Defaults to "display: block" and "visibility:hidden" to allocate
       space for error message, such that the page does not shift when
       error appears. For cr-inputs that can't be invalid, but are in a
       form with cr-inputs that can be invalid, this space is also desired
       in order to have consistent spacing.

       If spacing is not needed, apply "--cr-input-error-display: none".

       When grouping cr-inputs horizontally, it might be helpful to set
       --cr-input-error-white-space to "nowrap" and set a fixed width for
       each cr-input so that a long error label does not shift the inputs
       forward. */
    color: var(--cr-input-error-color);
    display: var(--cr-input-error-display, block);
    font-size: var(--cr-form-field-label-font-size);
    height: var(--cr-form-field-label-height);
    line-height: var(--cr-form-field-label-line-height);
    margin: 8px 0;
    visibility: hidden;
    white-space: var(--cr-input-error-white-space);
  }

  :host-context([chrome-refresh-2023]) #error {
    font-size: 11px;
    line-height: 16px;
    margin: 4px 10px;
  }

  :host([invalid]) #error {
    visibility: visible;
  }

  #row-container,
  #inner-input-content {
    align-items: center;
    display: flex;
    /* This will spread the input field and the suffix apart only if the
       host element width is intentionally set to something large. */
    justify-content: space-between;
    position: relative;
  }

  :host-context([chrome-refresh-2023]) #inner-input-content {
    gap: 4px;
    height: 16px;
    /* Ensures content sits above the hover layer */
    z-index: 1;
  }

  #input[type='search']::-webkit-search-cancel-button {
    display: none;
  }

  :host-context([dir=rtl]) #input[type=url] {
    text-align: right;  /* csschecker-disable-line left-right */
  }

  #input[type=url] {
    direction: ltr;
  }
</style>
<div id="label" class="cr-form-field-label" hidden="[[!label]]"
    aria-hidden="true">
  [[label]]
</div>
<div id="row-container" part="row-container">
  <div id="input-container">
    <div id="inner-input-container">
      <div id="hover-layer"></div>
      <div id="inner-input-content">
        <slot name="inline-prefix"></slot>
        <!-- Only attributes that are named inconsistently between html and js
            need to use attr$="", such as |readonly| vs .readOnly. -->
        <input id="input" disabled="[[disabled]]" autofocus="[[autofocus]]"
            value="{{value::input}}" tabindex$="[[inputTabindex]]"
            type="[[type]]"
            readonly$="[[readonly]]" maxlength$="[[maxlength]]"
            pattern$="[[pattern]]" required="[[required]]"
            minlength$="[[minlength]]" inputmode$="[[inputmode]]"
            aria-description$="[[ariaDescription]]"
            aria-label$="[[getAriaLabel_(ariaLabel, label, placeholder)]]"
            aria-invalid$="[[getAriaInvalid_(invalid)]]"
            max="[[max]]" min="[[min]]" on-focus="onInputFocus_"
            on-blur="onInputBlur_" on-change="onInputChange_"
            part="input"
            autocomplete="off">
        <slot name="inline-suffix"></slot>
      </div>
    </div>
    <div id="underline-base"></div>
    <div id="underline"></div>
  </div>
  <slot name="suffix"></slot>
</div>
<div id="error" aria-live="assertive">[[displayErrorMessage_]]</div>
<!--_html_template_end_-->`;
}

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Forked from ui/webui/resources/cr_elements/cr_input/cr_input.ts
/**
 * Input types supported by cr-input.
 */
const SUPPORTED_INPUT_TYPES = new Set([
    'email',
    'number',
    'password',
    'search',
    'text',
    'url',
]);
class CrInputElement extends PolymerElement {
    static get is() {
        return 'cr-input';
    }
    static get template() {
        return getTemplate$1J();
    }
    static get properties() {
        return {
            ariaDescription: {
                type: String,
            },
            ariaLabel: {
                type: String,
                value: '',
            },
            autofocus: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
            },
            autoValidate: Boolean,
            disabled: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
            },
            errorMessage: {
                type: String,
                value: '',
                observer: 'onInvalidOrErrorMessageChanged_',
            },
            displayErrorMessage_: {
                type: String,
                value: '',
            },
            /**
             * This is strictly used internally for styling, do not attempt to use
             * this to set focus.
             */
            focused_: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
            },
            invalid: {
                type: Boolean,
                value: false,
                notify: true,
                reflectToAttribute: true,
                observer: 'onInvalidOrErrorMessageChanged_',
            },
            max: {
                type: Number,
                reflectToAttribute: true,
            },
            min: {
                type: Number,
                reflectToAttribute: true,
            },
            maxlength: {
                type: Number,
                reflectToAttribute: true,
            },
            minlength: {
                type: Number,
                reflectToAttribute: true,
            },
            pattern: {
                type: String,
                reflectToAttribute: true,
            },
            inputmode: String,
            label: {
                type: String,
                value: '',
            },
            placeholder: {
                type: String,
                value: null,
                observer: 'placeholderChanged_',
            },
            readonly: {
                type: Boolean,
                reflectToAttribute: true,
            },
            required: {
                type: Boolean,
                reflectToAttribute: true,
            },
            inputTabindex: {
                type: Number,
                value: 0,
                observer: 'onInputTabindexChanged_',
            },
            type: {
                type: String,
                value: 'text',
                observer: 'onTypeChanged_',
            },
            value: {
                type: String,
                value: '',
                notify: true,
                observer: 'onValueChanged_',
            },
        };
    }
    ready() {
        super.ready();
        // Use inputTabindex instead.
        assert$1(!this.hasAttribute('tabindex'));
    }
    onInputTabindexChanged_() {
        // CrInput only supports 0 or -1 values for the input's tabindex to allow
        // having the input in tab order or not. Values greater than 0 will not work
        // as the shadow root encapsulates tabindices.
        assert$1(this.inputTabindex === 0 || this.inputTabindex === -1);
    }
    onTypeChanged_() {
        // Check that the 'type' is one of the supported types.
        assert$1(SUPPORTED_INPUT_TYPES.has(this.type));
    }
    get inputElement() {
        return this.$.input;
    }
    /**
     * Returns the aria label to be used with the input element.
     */
    getAriaLabel_(ariaLabel, label, placeholder) {
        return ariaLabel || label || placeholder;
    }
    /**
     * Returns 'true' or 'false' as a string for the aria-invalid attribute.
     */
    getAriaInvalid_(invalid) {
        return invalid ? 'true' : 'false';
    }
    onInvalidOrErrorMessageChanged_() {
        this.displayErrorMessage_ = this.invalid ? this.errorMessage : '';
        // On VoiceOver role="alert" is not consistently announced when its content
        // changes. Adding and removing the |role| attribute every time there
        // is an error, triggers VoiceOver to consistently announce.
        const ERROR_ID = 'error';
        const errorElement = this.shadowRoot.querySelector(`#${ERROR_ID}`);
        assert$1(errorElement);
        if (this.invalid) {
            errorElement.setAttribute('role', 'alert');
            this.inputElement.setAttribute('aria-errormessage', ERROR_ID);
        }
        else {
            errorElement.removeAttribute('role');
            this.inputElement.removeAttribute('aria-errormessage');
        }
    }
    /**
     * This is necessary instead of doing <input placeholder="[[placeholder]]">
     * because if this.placeholder is set to a truthy value then removed, it
     * would show "null" as placeholder.
     */
    placeholderChanged_() {
        if (this.placeholder || this.placeholder === '') {
            this.inputElement.setAttribute('placeholder', this.placeholder);
        }
        else {
            this.inputElement.removeAttribute('placeholder');
        }
    }
    focus() {
        this.focusInput();
    }
    /**
     * Focuses the input element.
     * TODO(crbug.com/40593040): Replace this with focus() after resolving the
     * text selection issue described in onFocus_().
     * @return Whether the <input> element was focused.
     */
    focusInput() {
        if (this.shadowRoot.activeElement === this.inputElement) {
            return false;
        }
        this.inputElement.focus();
        return true;
    }
    onValueChanged_(newValue, oldValue) {
        if (!newValue && !oldValue) {
            return;
        }
        if (this.autoValidate) {
            this.validate();
        }
    }
    /**
     * 'change' event fires when <input> value changes and user presses 'Enter'.
     * This function helps propagate it to host since change events don't
     * propagate across Shadow DOM boundary by default.
     */
    onInputChange_(e) {
        this.dispatchEvent(new CustomEvent('change', { bubbles: true, composed: true, detail: { sourceEvent: e } }));
    }
    onInputFocus_() {
        this.focused_ = true;
    }
    onInputBlur_() {
        this.focused_ = false;
    }
    /**
     * Selects the text within the input. If no parameters are passed, it will
     * select the entire string. Either no params or both params should be passed.
     * Publicly, this function should be used instead of inputElement.select() or
     * manipulating inputElement.selectionStart/selectionEnd because the order of
     * execution between focus() and select() is sensitive.
     */
    select(start, end) {
        this.inputElement.focus();
        if (start !== undefined && end !== undefined) {
            this.inputElement.setSelectionRange(start, end);
        }
        else {
            // Can't just pass one param.
            assert$1(start === undefined && end === undefined);
            this.inputElement.select();
        }
    }
    validate() {
        this.invalid = !this.inputElement.checkValidity();
        return !this.invalid;
    }
}
customElements.define(CrInputElement.is, CrInputElement);

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const ARC_VM_TYPE = 'arcvm';
const BAGUETTE_VM_TYPE = 'baguette';
const BRUSCHETTA_TYPE = 'bruschetta';
const CROSTINI_TYPE = 'crostini';
const PLUGIN_VM_TYPE = 'pluginVm';
const TERMINA_VM_TYPE = 'termina';
function getVMNameForGuestOsType(guestOs) {
    return {
        [CROSTINI_TYPE]: TERMINA_VM_TYPE,
        [PLUGIN_VM_TYPE]: 'PvmDefault',
        [ARC_VM_TYPE]: ARC_VM_TYPE,
        [BRUSCHETTA_TYPE]: 'bru',
        [BAGUETTE_VM_TYPE]: TERMINA_VM_TYPE,
    }[guestOs];
}
const VM_DEVICE_MICROPHONE = 'microphone';
let instance$C = null;
class GuestOsBrowserProxyImpl {
    static getInstance() {
        return instance$C || (instance$C = new GuestOsBrowserProxyImpl());
    }
    static setInstanceForTesting(obj) {
        instance$C = obj;
    }
    getGuestOsSharedPathsDisplayText(paths) {
        return sendWithPromise$1('getGuestOsSharedPathsDisplayText', paths);
    }
    removeGuestOsSharedPath(vmName, path) {
        return sendWithPromise$1('removeGuestOsSharedPath', vmName, path);
    }
    notifyGuestOsSharedUsbDevicesPageReady() {
        chrome.send('notifyGuestOsSharedUsbDevicesPageReady');
    }
    setGuestOsUsbDeviceShared(vmName, containerName, guid, shared) {
        chrome.send('setGuestOsUsbDeviceShared', [vmName, containerName, guid, shared]);
    }
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview A helper object used by the "Linux Apps" (Crostini) section
 * to install and uninstall Crostini.
 */
/**
 * Type of VM.
 * These values must be kept in sync with the VmType enum in
 * third_party/cros_system_api/dbus/vm_applications/apps.proto
 */
var VmType;
(function (VmType) {
    VmType[VmType["TERMINA"] = 0] = "TERMINA";
    VmType[VmType["PLUGIN_VM"] = 1] = "PLUGIN_VM";
    VmType[VmType["BOREALIS"] = 2] = "BOREALIS";
    VmType[VmType["BRUSCHETTA"] = 3] = "BRUSCHETTA";
    VmType[VmType["UNKNOWN"] = 4] = "UNKNOWN";
    VmType[VmType["ARCVM"] = 5] = "ARCVM";
    VmType[VmType["BAGUETTE"] = 6] = "BAGUETTE";
})(VmType || (VmType = {}));
// Identifiers for the default Crostini VM and container.
const DEFAULT_CROSTINI_VM = TERMINA_VM_TYPE;
const DEFAULT_CROSTINI_CONTAINER = 'penguin';
const DEFAULT_CROSTINI_VM_TYPE = VmType.TERMINA;
const DEFAULT_BAGUETTE_VM = TERMINA_VM_TYPE;
const DEFAULT_BAGUETTE_CONTAINER = 'penguin';
const DEFAULT_CROSTINI_GUEST_ID = {
    vm_name: DEFAULT_CROSTINI_VM,
    vm_type: VmType.TERMINA,
    container_name: DEFAULT_CROSTINI_CONTAINER,
};
const DEFAULT_BAGUETTE_GUEST_ID = {
    vm_name: DEFAULT_BAGUETTE_VM,
    vm_type: VmType.BAGUETTE,
    container_name: DEFAULT_BAGUETTE_CONTAINER,
};
/**
 * These values should remain consistent with their C++ counterpart
 * (chrome/browser/ash/crostini/crostini_port_forwarder.h).
 */
var CrostiniPortProtocol;
(function (CrostiniPortProtocol) {
    CrostiniPortProtocol[CrostiniPortProtocol["TCP"] = 0] = "TCP";
    CrostiniPortProtocol[CrostiniPortProtocol["UDP"] = 1] = "UDP";
})(CrostiniPortProtocol || (CrostiniPortProtocol = {}));
const PortState = {
    VALID: '',
    INVALID: loadTimeData.getString('crostiniPortForwardingAddError'),
    DUPLICATE: loadTimeData.getString('crostiniPortForwardingAddExisting'),
};
const MIN_VALID_PORT_NUMBER = 1024; // Minimum 16-bit integer value.
const MAX_VALID_PORT_NUMBER = 65535; // Maximum 16-bit integer value.
let instance$B = null;
class CrostiniBrowserProxyImpl {
    static getInstance() {
        return instance$B || (instance$B = new CrostiniBrowserProxyImpl());
    }
    static setInstanceForTesting(obj) {
        instance$B = obj;
    }
    requestCrostiniInstallerView() {
        chrome.send('requestCrostiniInstallerView');
    }
    requestRemoveCrostini() {
        chrome.send('requestRemoveCrostini');
    }
    requestCrostiniInstallerStatus() {
        chrome.send('requestCrostiniInstallerStatus');
    }
    requestCrostiniExportImportOperationStatus() {
        chrome.send('requestCrostiniExportImportOperationStatus');
    }
    exportCrostiniContainer(containerId) {
        chrome.send('exportCrostiniContainer', [containerId]);
    }
    importCrostiniContainer(containerId) {
        chrome.send('importCrostiniContainer', [containerId]);
    }
    exportDiskImage(containerId) {
        chrome.send('exportDiskImage', [containerId]);
    }
    importDiskImage(containerId) {
        chrome.send('importDiskImage', [containerId]);
    }
    requestArcAdbSideloadStatus() {
        chrome.send('requestArcAdbSideloadStatus');
    }
    getCanChangeArcAdbSideloading() {
        chrome.send('getCanChangeArcAdbSideloading');
    }
    enableArcAdbSideload() {
        chrome.send('enableArcAdbSideload');
    }
    disableArcAdbSideload() {
        chrome.send('disableArcAdbSideload');
    }
    requestCrostiniContainerUpgradeView() {
        chrome.send('requestCrostiniContainerUpgradeView');
    }
    requestCrostiniUpgraderDialogStatus() {
        chrome.send('requestCrostiniUpgraderDialogStatus');
    }
    requestCrostiniContainerUpgradeAvailable() {
        chrome.send('requestCrostiniContainerUpgradeAvailable');
    }
    getCrostiniDiskInfo(vmName, fullInfo) {
        return sendWithPromise$1('getCrostiniDiskInfo', vmName, fullInfo);
    }
    resizeCrostiniDisk(vmName, newSizeBytes) {
        return sendWithPromise$1('resizeCrostiniDisk', vmName, newSizeBytes);
    }
    checkCrostiniMicSharingStatus(proposedValue) {
        return sendWithPromise$1('checkCrostiniMicSharingStatus', proposedValue);
    }
    addCrostiniPortForward(containerId, portNumber, protocol, label) {
        return sendWithPromise$1('addCrostiniPortForward', containerId, portNumber, protocol, label);
    }
    removeCrostiniPortForward(containerId, portNumber, protocol) {
        return sendWithPromise$1('removeCrostiniPortForward', containerId, portNumber, protocol);
    }
    removeAllCrostiniPortForwards(containerId) {
        chrome.send('removeAllCrostiniPortForwards', [containerId]);
    }
    activateCrostiniPortForward(containerId, portNumber, protocol) {
        return sendWithPromise$1('activateCrostiniPortForward', containerId, portNumber, protocol);
    }
    deactivateCrostiniPortForward(containerId, portNumber, protocol) {
        return sendWithPromise$1('deactivateCrostiniPortForward', containerId, portNumber, protocol);
    }
    getCrostiniActivePorts() {
        return sendWithPromise$1('getCrostiniActivePorts');
    }
    getCrostiniActiveNetworkInfo() {
        return sendWithPromise$1('getCrostiniActiveNetworkInfo');
    }
    checkCrostiniIsRunning() {
        return sendWithPromise$1('checkCrostiniIsRunning');
    }
    checkBruschettaIsRunning() {
        return sendWithPromise$1('checkBruschettaIsRunning');
    }
    shutdownCrostini() {
        chrome.send('shutdownCrostini');
    }
    shutdownBruschetta() {
        chrome.send('shutdownBruschetta');
    }
    setCrostiniMicSharingEnabled(enabled) {
        chrome.send('setCrostiniMicSharingEnabled', [enabled]);
    }
    getCrostiniMicSharingEnabled() {
        return sendWithPromise$1('getCrostiniMicSharingEnabled');
    }
    createContainer(containerId, imageServer, imageAlias, containerFile) {
        chrome.send('createContainer', [containerId, imageServer, imageAlias, containerFile]);
    }
    deleteContainer(containerId) {
        chrome.send('deleteContainer', [containerId]);
    }
    requestContainerInfo() {
        chrome.send('requestContainerInfo');
    }
    setContainerBadgeColor(containerId, badgeColor) {
        chrome.send('setContainerBadgeColor', [containerId, badgeColor]);
    }
    stopContainer(containerId) {
        chrome.send('stopContainer', [containerId]);
    }
    openContainerFileSelector() {
        return sendWithPromise$1('openContainerFileSelector');
    }
    requestSharedVmDevices() {
        chrome.send('requestSharedVmDevices');
    }
    isVmDeviceShared(id, device) {
        return sendWithPromise$1('isVmDeviceShared', id, device);
    }
    setVmDeviceShared(id, device, shared) {
        return sendWithPromise$1('setVmDeviceShared', id, device, shared);
    }
    requestBruschettaInstallerView() {
        chrome.send('requestBruschettaInstallerView');
    }
    requestBruschettaUninstallerView() {
        chrome.send('requestBruschettaUninstallerView');
    }
}

function getTemplate$1I() {
    return html `<!--_html_template_start_--><style>:host{--cr-toggle-checked-bar-color:var(--google-blue-600);--cr-toggle-checked-button-color:var(--google-blue-600);--cr-toggle-checked-ripple-color:rgba(var(--google-blue-600-rgb),.2);--cr-toggle-ripple-diameter:40px;--cr-toggle-unchecked-bar-color:var(--google-grey-400);--cr-toggle-unchecked-button-color:white;--cr-toggle-unchecked-ripple-color:rgba(var(--google-grey-600-rgb),.15);-webkit-tap-highlight-color:transparent;cursor:pointer;display:block;min-width:34px;outline:none;position:relative;width:34px}:host-context([chrome-refresh-2023]):host{--cr-toggle-checked-bar-color:var(--color-toggle-button-track-on,var(--cr-fallback-color-primary));--cr-toggle-checked-button-color:var(--color-toggle-button-thumb-on,var(--cr-fallback-color-on-primary));--cr-toggle-unchecked-bar-color:var(--color-toggle-button-track-off,var(--cr-fallback-color-surface-variant));--cr-toggle-unchecked-button-color:var(--color-toggle-button-thumb-off,var(--cr-fallback-color-outline));--cr-toggle-disabled-opacity:1;--cr-toggle-checked-ripple-color:var(--cr-active-background-color);--cr-toggle-unchecked-ripple-color:var(--cr-active-background-color);--cr-toggle-ripple-diameter:20px;--cr-toggle-bar-border-color:var(--cr-toggle-unchecked-button-color);--cr-toggle-bar-border:1px solid var(--cr-toggle-bar-border-color);--cr-toggle-bar-width:26px;--cr-toggle-knob-diameter:8px;height:fit-content;isolation:isolate;min-width:initial;width:fit-content}@media (forced-colors:active){:host{forced-color-adjust:none}}@media (prefers-color-scheme:dark){:host{--cr-toggle-checked-bar-color:var(--google-blue-300);--cr-toggle-checked-button-color:var(--google-blue-300);--cr-toggle-checked-ripple-color:rgba(var(--google-blue-300-rgb),.4);--cr-toggle-unchecked-bar-color:var(--google-grey-500);--cr-toggle-unchecked-button-color:var(--google-grey-300);--cr-toggle-unchecked-ripple-color:rgba(var(--google-grey-300-rgb),.4)}}:host([dark]){--cr-toggle-checked-bar-color:var(--google-blue-300);--cr-toggle-checked-button-color:var(--google-blue-300);--cr-toggle-checked-ripple-color:rgba(var(--google-blue-300-rgb),.4);--cr-toggle-unchecked-bar-color:var(--google-grey-500);--cr-toggle-unchecked-button-color:var(--google-grey-300);--cr-toggle-unchecked-ripple-color:rgba(var(--google-grey-300-rgb),.4)}:host-context([chrome-refresh-2023]):host(:active){--cr-toggle-knob-diameter:10px}:host-context([chrome-refresh-2023]):host([checked]){--cr-toggle-bar-border-color:var(--cr-toggle-checked-bar-color);--cr-toggle-knob-diameter:12px}:host-context([chrome-refresh-2023]):host([checked]:active){--cr-toggle-knob-diameter:14px}:host([disabled]){cursor:initial;opacity:var(--cr-disabled-opacity);pointer-events:none}:host-context([chrome-refresh-2023]):host([disabled]){--cr-toggle-checked-bar-color:var(--color-toggle-button-track-on-disabled,var(--cr-fallback-color-disabled-background));--cr-toggle-checked-button-color:var(--color-toggle-button-thumb-on-disabled,var(--cr-fallback-color-surface));--cr-toggle-unchecked-bar-color:transparent;--cr-toggle-unchecked-button-color:var(--color-toggle-button-thumb-off-disabled,var(--cr-fallback-color-disabled-foreground));--cr-toggle-bar-border-color:var(--cr-toggle-unchecked-button-color);opacity:var(--cr-toggle-disabled-opacity)}:host-context([chrome-refresh-2023]):host([checked][disabled]){--cr-toggle-bar-border:none}#bar{background-color:var(--cr-toggle-unchecked-bar-color);border-radius:8px;height:12px;left:3px;position:absolute;top:2px;transition:background-color linear 80ms;width:28px;z-index:0}:host([checked]) #bar{background-color:var(--cr-toggle-checked-bar-color);opacity:var(--cr-toggle-checked-bar-opacity,0.5)}:host-context([chrome-refresh-2023]) #bar{border:var(--cr-toggle-bar-border);border-radius:50px;box-sizing:border-box;display:block;height:16px;opacity:1;position:initial;width:var(--cr-toggle-bar-width)}:host-context([chrome-refresh-2023]):host(:focus-visible) #bar{outline:2px solid var(--cr-toggle-checked-bar-color);outline-offset:2px}#knob{background-color:var(--cr-toggle-unchecked-button-color);border-radius:50%;box-shadow:var(--cr-toggle-box-shadow,0 1px 3px 0 rgba(0,0,0,.4));display:block;height:16px;position:relative;transition:transform linear 80ms,background-color linear 80ms;width:16px;z-index:1}:host([checked]) #knob{background-color:var(--cr-toggle-checked-button-color);transform:translate3d(18px,0,0)}:host-context([dir=rtl]):host([checked]) #knob{transform:translate3d(-18px,0,0)}:host-context([chrome-refresh-2023]) #knob{--cr-toggle-knob-center-edge-distance_:8px;--cr-toggle-knob-direction_:1;--cr-toggle-knob-travel-distance_:calc(0.5 * var(--cr-toggle-bar-width) - var(--cr-toggle-knob-center-edge-distance_));--cr-toggle-knob-position-center_:calc(0.5 * var(--cr-toggle-bar-width) + -50%);--cr-toggle-knob-position-start_:calc(var(--cr-toggle-knob-position-center_) - var(--cr-toggle-knob-direction_) * var(--cr-toggle-knob-travel-distance_));--cr-toggle-knob-position-end_:calc(var(--cr-toggle-knob-position-center_) + var(--cr-toggle-knob-direction_) * var(--cr-toggle-knob-travel-distance_));box-shadow:none;height:var(--cr-toggle-knob-diameter);position:absolute;top:50%;transform:translate(var(--cr-toggle-knob-position-start_),-50%);transition:transform linear 80ms,background-color linear 80ms,width linear 80ms,height linear 80ms;width:var(--cr-toggle-knob-diameter)}:host-context([dir=rtl][chrome-refresh-2023]) #knob{left:0;--cr-toggle-knob-direction_:-1}:host-context([chrome-refresh-2023]):host([checked]) #knob{transform:translate(var(--cr-toggle-knob-position-end_),-50%)}:host-context([chrome-refresh-2023]):host([checked]:active) #knob,:host-context([chrome-refresh-2023]):host([checked]:hover) #knob{--cr-toggle-checked-button-color:var(--color-toggle-button-thumb-on-hover,var(--cr-fallback-color-primary-container))}:host-context([chrome-refresh-2023]):host(:hover) #knob::before{background-color:var(--cr-hover-background-color);border-radius:50%;content:'';height:var(--cr-toggle-ripple-diameter);left:calc(var(--cr-toggle-knob-diameter) / 2);position:absolute;top:calc(var(--cr-toggle-knob-diameter) / 2);transform:translate(-50%,-50%);width:var(--cr-toggle-ripple-diameter)}paper-ripple{--paper-ripple-opacity:1;color:var(--cr-toggle-unchecked-ripple-color);height:var(--cr-toggle-ripple-diameter);left:50%;outline:var(--cr-toggle-ripple-ring,none);pointer-events:none;position:absolute;top:50%;transform:translate(-50%,-50%);transition:color linear 80ms;width:var(--cr-toggle-ripple-diameter)}:host([checked]) paper-ripple{color:var(--cr-toggle-checked-ripple-color)}:host-context([dir=rtl]) paper-ripple{left:auto;right:50%;transform:translate(50%,-50%)}</style>
<span id="bar"></span>
<span id="knob"></span>
<!--_html_template_end_-->`;
}

// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Number of pixels required to move to consider the pointermove event as
 * intentional.
 */
const MOVE_THRESHOLD_PX = 5;
const CrToggleElementBase = PaperRippleMixin(PolymerElement);
class CrToggleElement extends CrToggleElementBase {
    constructor() {
        super(...arguments);
        this.boundPointerMove_ = null;
        /**
         * Whether the state of the toggle has already taken into account by
         * |pointeremove| handlers. Used in the 'click' handler.
         */
        this.handledInPointerMove_ = false;
        this.pointerDownX_ = 0;
    }
    static get is() {
        return 'cr-toggle';
    }
    static get template() {
        return getTemplate$1I();
    }
    static get properties() {
        return {
            checked: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
                observer: 'checkedChanged_',
                notify: true,
            },
            dark: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
            },
            disabled: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
                observer: 'disabledChanged_',
            },
        };
    }
    ready() {
        super.ready();
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'button');
        }
        if (!this.hasAttribute('tabindex')) {
            this.setAttribute('tabindex', '0');
        }
        this.setAttribute('aria-pressed', this.checked ? 'true' : 'false');
        this.setAttribute('aria-disabled', this.disabled ? 'true' : 'false');
        if (!document.documentElement.hasAttribute('chrome-refresh-2023')) {
            this.addEventListener('blur', this.hideRipple_.bind(this));
            this.addEventListener('focus', this.onFocus_.bind(this));
        }
        this.addEventListener('click', this.onClick_.bind(this));
        this.addEventListener('keydown', this.onKeyDown_.bind(this));
        this.addEventListener('keyup', this.onKeyUp_.bind(this));
        this.addEventListener('pointerdown', this.onPointerDown_.bind(this));
        this.addEventListener('pointerup', this.onPointerUp_.bind(this));
    }
    connectedCallback() {
        super.connectedCallback();
        const direction = this.matches(':host-context([dir=rtl]) cr-toggle') ? -1 : 1;
        this.boundPointerMove_ = (e) => {
            // Prevent unwanted text selection to occur while moving the pointer, this
            // is important.
            e.preventDefault();
            const diff = e.clientX - this.pointerDownX_;
            if (Math.abs(diff) < MOVE_THRESHOLD_PX) {
                return;
            }
            this.handledInPointerMove_ = true;
            const shouldToggle = (diff * direction < 0 && this.checked) ||
                (diff * direction > 0 && !this.checked);
            if (shouldToggle) {
                this.toggleState_(/* fromKeyboard= */ false);
            }
        };
    }
    checkedChanged_() {
        this.setAttribute('aria-pressed', this.checked ? 'true' : 'false');
    }
    disabledChanged_() {
        this.setAttribute('tabindex', this.disabled ? '-1' : '0');
        this.setAttribute('aria-disabled', this.disabled ? 'true' : 'false');
    }
    onFocus_() {
        this.getRipple().showAndHoldDown();
    }
    hideRipple_() {
        this.getRipple().clear();
    }
    onPointerUp_() {
        assert$1(this.boundPointerMove_);
        this.removeEventListener('pointermove', this.boundPointerMove_);
        this.hideRipple_();
    }
    onPointerDown_(e) {
        // Don't do anything if this was not a primary button click or touch event.
        if (e.button !== 0) {
            return;
        }
        // This is necessary to have follow up pointer events fire on |this|, even
        // if they occur outside of its bounds.
        this.setPointerCapture(e.pointerId);
        this.pointerDownX_ = e.clientX;
        this.handledInPointerMove_ = false;
        assert$1(this.boundPointerMove_);
        this.addEventListener('pointermove', this.boundPointerMove_);
    }
    onClick_(e) {
        // Prevent |click| event from bubbling. It can cause parents of this
        // elements to erroneously re-toggle this control.
        e.stopPropagation();
        e.preventDefault();
        // User gesture has already been taken care of inside |pointermove|
        // handlers, Do nothing here.
        if (this.handledInPointerMove_) {
            return;
        }
        // If no pointermove event fired, then user just clicked on the
        // toggle button and therefore it should be toggled.
        this.toggleState_(/* fromKeyboard= */ false);
    }
    toggleState_(fromKeyboard) {
        // Ignore cases where the 'click' or 'keypress' handlers are triggered while
        // disabled.
        if (this.disabled) {
            return;
        }
        if (!fromKeyboard) {
            this.hideRipple_();
        }
        this.checked = !this.checked;
        this.dispatchEvent(new CustomEvent('change', { bubbles: true, composed: true, detail: this.checked }));
    }
    onKeyDown_(e) {
        if (e.key !== ' ' && e.key !== 'Enter') {
            return;
        }
        e.preventDefault();
        e.stopPropagation();
        if (e.repeat) {
            return;
        }
        if (e.key === 'Enter') {
            this.toggleState_(/* fromKeyboard= */ true);
        }
    }
    onKeyUp_(e) {
        if (e.key !== ' ' && e.key !== 'Enter') {
            return;
        }
        e.preventDefault();
        e.stopPropagation();
        if (e.key === ' ') {
            this.toggleState_(/* fromKeyboard= */ true);
        }
    }
    // Overridden from PaperRippleMixin
    /* eslint-disable-next-line @typescript-eslint/naming-convention */
    _createRipple() {
        this._rippleContainer = this.$.knob;
        const ripple = super._createRipple();
        ripple.id = 'ink';
        ripple.setAttribute('recenters', '');
        ripple.classList.add('circle');
        return ripple;
    }
}
customElements.define(CrToggleElement.is, CrToggleElement);

/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/

/**
Material design:
[Tooltips](https://www.google.com/design/spec/components/tooltips.html)
`<paper-tooltip>` is a label that appears on hover and focus when the user
hovers over an element with the cursor or with the keyboard. It will be centered
to an anchor element specified in the `for` attribute, or, if that doesn't
exist, centered to the parent node containing it.
Example:
    <div style="display:inline-block">
      <button>Click me!</button>
      <paper-tooltip>Tooltip text</paper-tooltip>
    </div>
    <div>
      <button id="btn">Click me!</button>
      <paper-tooltip for="btn">Tooltip text</paper-tooltip>
    </div>
The tooltip can be positioned on the top|bottom|left|right of the anchor using
the `position` attribute. The default position is bottom.
    <paper-tooltip for="btn" position="left">Tooltip text</paper-tooltip>
    <paper-tooltip for="btn" position="top">Tooltip text</paper-tooltip>

### Styling
The following custom properties and mixins are available for styling:
Custom property | Description | Default
----------------|-------------|----------
`--paper-tooltip-background` | The background color of the tooltip | `#616161`
`--paper-tooltip-opacity` | The opacity of the tooltip | `0.9`
`--paper-tooltip-text-color` | The text color of the tooltip | `white`
`--paper-tooltip-delay-in` | Delay before tooltip starts to fade in | `500`
`--paper-tooltip-delay-out` | Delay before tooltip starts to fade out | `0`
`--paper-tooltip-duration-in` | Timing for animation when showing tooltip | `500`
`--paper-tooltip-duration-out` | Timing for animation when hiding tooltip | `0`

Also prefer using the exposed CSS part as follows where possible
paper-tooltip::part(tooltip) {...}

@group Paper Elements
@element paper-tooltip
@demo demo/index.html
*/
Polymer({
  _template: html`
    <style>
      :host {
        display: block;
        position: absolute;
        outline: none;
        z-index: 1002;
        user-select: none;
        cursor: default;
      }

      #tooltip {
        display: block;
        outline: none;
        font-size: 10px;
        line-height: 1;
        background-color: var(--paper-tooltip-background, #616161);
        color: var(--paper-tooltip-text-color, white);
        padding: 8px;
        border-radius: 2px;
      }

      @keyframes keyFrameScaleUp {
        0% {
          transform: scale(0.0);
        }
        100% {
          transform: scale(1.0);
        }
      }

      @keyframes keyFrameScaleDown {
        0% {
          transform: scale(1.0);
        }
        100% {
          transform: scale(0.0);
        }
      }

      @keyframes keyFrameFadeInOpacity {
        0% {
          opacity: 0;
        }
        100% {
          opacity: var(--paper-tooltip-opacity, 0.9);
        }
      }

      @keyframes keyFrameFadeOutOpacity {
        0% {
          opacity: var(--paper-tooltip-opacity, 0.9);
        }
        100% {
          opacity: 0;
        }
      }

      @keyframes keyFrameSlideDownIn {
        0% {
          transform: translateY(-2000px);
          opacity: 0;
        }
        10% {
          opacity: 0.2;
        }
        100% {
          transform: translateY(0);
          opacity: var(--paper-tooltip-opacity, 0.9);
        }
      }

      @keyframes keyFrameSlideDownOut {
        0% {
          transform: translateY(0);
          opacity: var(--paper-tooltip-opacity, 0.9);
        }
        10% {
          opacity: 0.2;
        }
        100% {
          transform: translateY(-2000px);
          opacity: 0;
        }
      }

      .fade-in-animation {
        opacity: 0;
        animation-delay: var(--paper-tooltip-delay-in, 500ms);
        animation-name: keyFrameFadeInOpacity;
        animation-iteration-count: 1;
        animation-timing-function: ease-in;
        animation-duration: var(--paper-tooltip-duration-in, 500ms);
        animation-fill-mode: forwards;
      }

      .fade-out-animation {
        opacity: var(--paper-tooltip-opacity, 0.9);
        animation-delay: var(--paper-tooltip-delay-out, 0ms);
        animation-name: keyFrameFadeOutOpacity;
        animation-iteration-count: 1;
        animation-timing-function: ease-in;
        animation-duration: var(--paper-tooltip-duration-out, 500ms);
        animation-fill-mode: forwards;
      }

      .scale-up-animation {
        transform: scale(0);
        opacity: var(--paper-tooltip-opacity, 0.9);
        animation-delay: var(--paper-tooltip-delay-in, 500ms);
        animation-name: keyFrameScaleUp;
        animation-iteration-count: 1;
        animation-timing-function: ease-in;
        animation-duration: var(--paper-tooltip-duration-in, 500ms);
        animation-fill-mode: forwards;
      }

      .scale-down-animation {
        transform: scale(1);
        opacity: var(--paper-tooltip-opacity, 0.9);
        animation-delay: var(--paper-tooltip-delay-out, 500ms);
        animation-name: keyFrameScaleDown;
        animation-iteration-count: 1;
        animation-timing-function: ease-in;
        animation-duration: var(--paper-tooltip-duration-out, 500ms);
        animation-fill-mode: forwards;
      }

      .slide-down-animation {
        transform: translateY(-2000px);
        opacity: 0;
        animation-delay: var(--paper-tooltip-delay-out, 500ms);
        animation-name: keyFrameSlideDownIn;
        animation-iteration-count: 1;
        animation-timing-function: cubic-bezier(0.0, 0.0, 0.2, 1);
        animation-duration: var(--paper-tooltip-duration-out, 500ms);
        animation-fill-mode: forwards;
      }

      .slide-down-animation-out {
        transform: translateY(0);
        opacity: var(--paper-tooltip-opacity, 0.9);
        animation-delay: var(--paper-tooltip-delay-out, 500ms);
        animation-name: keyFrameSlideDownOut;
        animation-iteration-count: 1;
        animation-timing-function: cubic-bezier(0.4, 0.0, 1, 1);
        animation-duration: var(--paper-tooltip-duration-out, 500ms);
        animation-fill-mode: forwards;
      }

      .cancel-animation {
        animation-delay: -30s !important;
      }

      /* Thanks IE 10. */

      .hidden {
        display: none !important;
      }
    </style>

    <div id="tooltip" class="hidden" part="tooltip">
      <slot></slot>
    </div>
`,

  is: 'paper-tooltip',
  hostAttributes: {role: 'tooltip', tabindex: -1},

  properties: {
    /**
     * The id of the element that the tooltip is anchored to. This element
     * must be a sibling of the tooltip. If this property is not set,
     * then the tooltip will be centered to the parent node containing it.
     */
    for: {type: String, observer: '_findTarget'},
    /**
     * Set this to true if you want to manually control when the tooltip
     * is shown or hidden.
     */
    manualMode: {type: Boolean, value: false, observer: '_manualModeChanged'},
    /**
     * Positions the tooltip to the top, right, bottom, left of its content.
     */
    position: {type: String, value: 'bottom'},
    /**
     * If true, no parts of the tooltip will ever be shown offscreen.
     */
    fitToVisibleBounds: {type: Boolean, value: false},
    /**
     * The spacing between the top of the tooltip and the element it is
     * anchored to.
     */
    offset: {type: Number, value: 14},
    /**
     * This property is deprecated, but left over so that it doesn't
     * break exiting code. Please use `offset` instead. If both `offset` and
     * `marginTop` are provided, `marginTop` will be ignored.
     * @deprecated since version 1.0.3
     */
    marginTop: {type: Number, value: 14},
    /**
     * The delay that will be applied before the `entry` animation is
     * played when showing the tooltip.
     */
    animationDelay: {type: Number, value: 500, observer: '_delayChange'},
    /**
     * The animation that will be played on entry.  This replaces the
     * deprecated animationConfig.  Entries here will override the
     * animationConfig settings.  You can enter your own animation
     * by setting it to the css class name.
     */
    animationEntry: {type: String, value: ''},
    /**
     * The animation that will be played on exit.  This replaces the
     * deprecated animationConfig.  Entries here will override the
     * animationConfig settings.  You can enter your own animation
     * by setting it to the css class name.
     */
    animationExit: {type: String, value: ''},
    /**
     * This property is deprecated.
     * The entry and exit animations that will be played when showing
     * and hiding the tooltip. If you want to override this, you must ensure
     * that your animationConfig has the exact format below.
     * @deprecated since version
     *
     * The entry and exit animations that will be played when showing and
     * hiding the tooltip. If you want to override this, you must ensure
     * that your animationConfig has the exact format below.
     */
    animationConfig: {
      type: Object,
      value: function() {
        return {
          'entry':
              [{name: 'fade-in-animation', node: this, timing: {delay: 0}}],
              'exit': [{name: 'fade-out-animation', node: this}]
        }
      }
    },
    _showing: {type: Boolean, value: false}
  },

  listeners: {
    'webkitAnimationEnd': '_onAnimationEnd',
  },

  /**
   * Returns the target element that this tooltip is anchored to. It is
   * either the element given by the `for` attribute, the element manually
   * specified through the `target` attribute, or the immediate parent of
   * the tooltip.
   *
   * @type {Node}
   */
  get target() {
    if (this._manualTarget)
      return this._manualTarget;

    var parentNode = dom(this).parentNode;
    // If the parentNode is a document fragment, then we need to use the host.
    var ownerRoot = dom(this).getOwnerRoot();
    var target;
    if (this.for) {
      target = dom(ownerRoot).querySelector('#' + this.for);
    } else {
      target = parentNode.nodeType == Node.DOCUMENT_FRAGMENT_NODE ?
          ownerRoot.host :
          parentNode;
    }
    return target;
  },

  /**
   * Sets the target element that this tooltip will be anchored to.
   * @param {Node} target
   */
  set target(target) {
    this._manualTarget = target;
    this._findTarget();
  },

  /**
   * @return {void}
   */
  attached: function() {
    this._findTarget();
  },

  /**
   * @return {void}
   */
  detached: function() {
    if (!this.manualMode)
      this._removeListeners();
  },

  /**
   * Replaces Neon-Animation playAnimation - just calls show and hide.
   * @deprecated Use show and hide instead.
   * @param {string} type Either `entry` or `exit`
   */
  playAnimation: function(type) {
    if (type === 'entry') {
      this.show();
    } else if (type === 'exit') {
      this.hide();
    }
  },

  /**
   * Cancels the animation and either fully shows or fully hides tooltip
   */
  cancelAnimation: function() {
    // Short-cut and cancel all animations and hide
    this.$.tooltip.classList.add('cancel-animation');
  },

  /**
   * Shows the tooltip programatically
   * @return {void}
   */
  show: function() {
    // If the tooltip is already showing, there's nothing to do.
    if (this._showing)
      return;

    if (dom(this).textContent.trim() === '') {
      // Check if effective children are also empty
      var allChildrenEmpty = true;
      var effectiveChildren = dom(this).getEffectiveChildNodes();
      for (var i = 0; i < effectiveChildren.length; i++) {
        if (effectiveChildren[i].textContent.trim() !== '') {
          allChildrenEmpty = false;
          break;
        }
      }
      if (allChildrenEmpty) {
        return;
      }
    }

    this._showing = true;
    this.$.tooltip.classList.remove('hidden');
    this.$.tooltip.classList.remove('cancel-animation');
    this.$.tooltip.classList.remove(this._getAnimationType('exit'));
    this.updatePosition();
    this._animationPlaying = true;
    this.$.tooltip.classList.add(this._getAnimationType('entry'));
  },

  /**
   * Hides the tooltip programatically
   * @return {void}
   */
  hide: function() {
    // If the tooltip is already hidden, there's nothing to do.
    if (!this._showing) {
      return;
    }

    // If the entry animation is still playing, don't try to play the exit
    // animation since this will reset the opacity to 1. Just end the animation.
    if (this._animationPlaying) {
      this._showing = false;
      this._cancelAnimation();
      return;
    } else {
      // Play Exit Animation
      this._onAnimationFinish();
    }

    this._showing = false;
    this._animationPlaying = true;
  },

  /**
   * @return {void}
   */
  updatePosition: function() {
    if (!this._target)
      return;
    var offsetParent = this._composedOffsetParent();
    if (!offsetParent)
      return;
    var offset = this.offset;
    // If a marginTop has been provided by the user (pre 1.0.3), use it.
    if (this.marginTop != 14 && this.offset == 14)
      offset = this.marginTop;
    var parentRect = offsetParent.getBoundingClientRect();
    var targetRect = this._target.getBoundingClientRect();
    var thisRect = this.getBoundingClientRect();
    var horizontalCenterOffset = (targetRect.width - thisRect.width) / 2;
    var verticalCenterOffset = (targetRect.height - thisRect.height) / 2;
    var targetLeft = targetRect.left - parentRect.left;
    var targetTop = targetRect.top - parentRect.top;
    var tooltipLeft, tooltipTop;
    switch (this.position) {
      case 'top':
        tooltipLeft = targetLeft + horizontalCenterOffset;
        tooltipTop = targetTop - thisRect.height - offset;
        break;
      case 'bottom':
        tooltipLeft = targetLeft + horizontalCenterOffset;
        tooltipTop = targetTop + targetRect.height + offset;
        break;
      case 'left':
        tooltipLeft = targetLeft - thisRect.width - offset;
        tooltipTop = targetTop + verticalCenterOffset;
        break;
      case 'right':
        tooltipLeft = targetLeft + targetRect.width + offset;
        tooltipTop = targetTop + verticalCenterOffset;
        break;
    }
    // TODO(noms): This should use IronFitBehavior if possible.
    if (this.fitToVisibleBounds) {
      // Clip the left/right side
      if (parentRect.left + tooltipLeft + thisRect.width > window.innerWidth) {
        this.style.right = '0px';
        this.style.left = 'auto';
      } else {
        this.style.left = Math.max(0, tooltipLeft) + 'px';
        this.style.right = 'auto';
      }
      // Clip the top/bottom side.
      if (parentRect.top + tooltipTop + thisRect.height > window.innerHeight) {
        this.style.bottom = (parentRect.height - targetTop + offset) + 'px';
        this.style.top = 'auto';
      } else {
        this.style.top = Math.max(-parentRect.top, tooltipTop) + 'px';
        this.style.bottom = 'auto';
      }
    } else {
      this.style.left = tooltipLeft + 'px';
      this.style.top = tooltipTop + 'px';
    }
  },

  _addListeners: function() {
    if (this._target) {
      this.listen(this._target, 'mouseenter', 'show');
      this.listen(this._target, 'focus', 'show');
      this.listen(this._target, 'mouseleave', 'hide');
      this.listen(this._target, 'blur', 'hide');
      this.listen(this._target, 'tap', 'hide');
    }
    this.listen(this.$.tooltip, 'animationend', '_onAnimationEnd');
    this.listen(this, 'mouseenter', 'hide');
  },

  _findTarget: function() {
    if (!this.manualMode)
      this._removeListeners();
    this._target = this.target;
    if (!this.manualMode)
      this._addListeners();
  },

  _delayChange: function(newValue) {
    // Only Update delay if different value set
    if (newValue !== 500) {
      this.updateStyles({'--paper-tooltip-delay-in': newValue + 'ms'});
    }
  },

  _manualModeChanged: function() {
    if (this.manualMode)
      this._removeListeners();
    else
      this._addListeners();
  },

  _cancelAnimation: function() {
    // Short-cut and cancel all animations and hide
    this.$.tooltip.classList.remove(this._getAnimationType('entry'));
    this.$.tooltip.classList.remove(this._getAnimationType('exit'));
    this.$.tooltip.classList.remove('cancel-animation');
    this.$.tooltip.classList.add('hidden');
  },

  _onAnimationFinish: function() {
    if (this._showing) {
      this.$.tooltip.classList.remove(this._getAnimationType('entry'));
      this.$.tooltip.classList.remove('cancel-animation');
      this.$.tooltip.classList.add(this._getAnimationType('exit'));
    }
  },

  _onAnimationEnd: function() {
    // If no longer showing add class hidden to completely hide tooltip
    this._animationPlaying = false;
    if (!this._showing) {
      this.$.tooltip.classList.remove(this._getAnimationType('exit'));
      this.$.tooltip.classList.add('hidden');
    }
  },

  _getAnimationType: function(type) {
    // These properties have priority over animationConfig values
    if ((type === 'entry') && (this.animationEntry !== '')) {
      return this.animationEntry;
    }
    if ((type === 'exit') && (this.animationExit !== '')) {
      return this.animationExit;
    }
    // If no results then return the legacy value from animationConfig
    if (this.animationConfig[type] &&
        typeof this.animationConfig[type][0].name === 'string') {
      // Checking Timing and Update if necessary - Legacy for animationConfig
      if (this.animationConfig[type][0].timing &&
          this.animationConfig[type][0].timing.delay &&
          this.animationConfig[type][0].timing.delay !== 0) {
        var timingDelay = this.animationConfig[type][0].timing.delay;
        // Has Timing Change - Update CSS
        if (type === 'entry') {
          this.updateStyles({'--paper-tooltip-delay-in': timingDelay + 'ms'});
        } else if (type === 'exit') {
          this.updateStyles({'--paper-tooltip-delay-out': timingDelay + 'ms'});
        }
      }
      return this.animationConfig[type][0].name;
    }
  },

  _removeListeners: function() {
    if (this._target) {
      this.unlisten(this._target, 'mouseenter', 'show');
      this.unlisten(this._target, 'focus', 'show');
      this.unlisten(this._target, 'mouseleave', 'hide');
      this.unlisten(this._target, 'blur', 'hide');
      this.unlisten(this._target, 'tap', 'hide');
    }
    this.unlisten(this.$.tooltip, 'animationend', '_onAnimationEnd');
    this.unlisten(this, 'mouseenter', 'hide');
  },

  /**
   * Polyfills the old offsetParent behavior from before the spec was changed:
   * https://github.com/w3c/csswg-drafts/issues/159
   */
  _composedOffsetParent: function() {
    // Do an initial walk to check for display:none ancestors.
    for (let ancestor = this; ancestor; ancestor = flatTreeParent(ancestor)) {
      if (!(ancestor instanceof Element))
        continue;
      if (getComputedStyle(ancestor).display === 'none')
        return null;
    }

    for (let ancestor = flatTreeParent(this); ancestor; ancestor = flatTreeParent(ancestor)) {
      if (!(ancestor instanceof Element))
        continue;
      const style = getComputedStyle(ancestor);
      if (style.display === 'contents') {
        // display:contents nodes aren't in the layout tree so they should be skipped.
        continue;
      }
      if (style.position !== 'static') {
        return ancestor;
      }
      if (ancestor.tagName === 'BODY')
        return ancestor;
    }
    return null;

    function flatTreeParent(element) {
      if (element.assignedSlot) {
        return element.assignedSlot;
      }
      if (element.parentNode instanceof ShadowRoot) {
        return element.parentNode.host;
      }
      return element.parentNode;
    }
  }
});

function getTemplate$1H() {
    return html `<!--_html_template_start_--><style include="cr-shared-style">:host{--cr-link-color:var(--cros-tooltip-link-color);--cr-tooltip-icon-fill-color:var(--cros-sys-on_surface_variant);display:flex}iron-icon{--iron-icon-fill-color:var(--cr-tooltip-icon-fill-color);--iron-icon-height:var(--cr-icon-size);--iron-icon-width:var(--cr-icon-size)}#tooltip{--paper-tooltip-background:var(--cros-tooltip-background-color);--paper-tooltip-border-radius:4px;--paper-tooltip-padding:5px 8px;--paper-tooltip-text-color:var(--cros-tooltip-label-color);font:var(--cros-annotation-1-font)}</style>
<iron-icon id="indicator" tabindex="0" aria-label$="[[iconAriaLabel]]"
    aria-describedby="tooltip" icon="[[iconClass]]" role="img">
</iron-icon>
<paper-tooltip id="tooltip"
    for="indicator" position="[[tooltipPosition]]"
    fit-to-visible-bounds part="tooltip" aria-hidden="true">
  <slot name="tooltip-text">[[tooltipText]]</slot>
</paper-tooltip>
<!--_html_template_end_-->`;
}

// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Forked from ui/webui/resources/cr_elements/policy/cr_tooltip_icon.ts
class CrTooltipIconElement extends PolymerElement {
    static get is() {
        return 'cr-tooltip-icon';
    }
    static get template() {
        return getTemplate$1H();
    }
    static get properties() {
        return {
            iconAriaLabel: String,
            iconClass: String,
            tooltipText: String,
            /** Position of tooltip popup related to the icon. */
            tooltipPosition: {
                type: String,
                value: 'top',
            },
        };
    }
    getFocusableElement() {
        return this.$.indicator;
    }
}
customElements.define(CrTooltipIconElement.is, CrTooltipIconElement);

function getTemplate$1G() {
    return html `<!--_html_template_start_--><style include="cr-hidden-style"></style>
<cr-tooltip-icon hidden$="[[!indicatorVisible]]"
    tooltip-text="[[indicatorTooltip_]]" icon-class="[[indicatorIcon]]"
    icon-aria-label="[[iconAriaLabel]]">
</cr-tooltip-icon>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Mixin for policy controlled indicators.
 * TODO(michaelpg): Since extensions can also control settings and be indicated,
 * rework the "policy" naming scheme throughout this directory.
 * Forked from
 * ui/webui/resources/cr_elements/policy/cr_policy_indicator_mixin.ts
 */
/**
 * Possible policy indicators that can be shown in settings.
 */
var CrPolicyIndicatorType$1;
(function (CrPolicyIndicatorType) {
    CrPolicyIndicatorType["DEVICE_POLICY"] = "devicePolicy";
    CrPolicyIndicatorType["EXTENSION"] = "extension";
    CrPolicyIndicatorType["NONE"] = "none";
    CrPolicyIndicatorType["OWNER"] = "owner";
    CrPolicyIndicatorType["PRIMARY_USER"] = "primary_user";
    CrPolicyIndicatorType["RECOMMENDED"] = "recommended";
    CrPolicyIndicatorType["USER_POLICY"] = "userPolicy";
    CrPolicyIndicatorType["PARENT"] = "parent";
    CrPolicyIndicatorType["CHILD_RESTRICTION"] = "childRestriction";
})(CrPolicyIndicatorType$1 || (CrPolicyIndicatorType$1 = {}));
const CrPolicyIndicatorMixin = dedupingMixin((superClass) => {
    class CrPolicyIndicatorMixin extends superClass {
        // Properties exposed to all policy indicators.
        static get properties() {
            return {
                /**
                 * Which indicator type to show (or NONE).
                 */
                indicatorType: {
                    type: String,
                    value: CrPolicyIndicatorType$1.NONE,
                },
                /**
                 * The name associated with the policy source. See
                 * chrome.settingsPrivate.PrefObject.controlledByName.
                 */
                indicatorSourceName: {
                    type: String,
                    value: '',
                },
                // Computed properties based on indicatorType and
                // indicatorSourceName. Override to provide different values.
                indicatorVisible: {
                    type: Boolean,
                    computed: 'getIndicatorVisible_(indicatorType)',
                },
                indicatorIcon: {
                    type: String,
                    computed: 'getIndicatorIcon_(indicatorType)',
                },
            };
        }
        /**
         * @return True if the indicator should be shown.
         */
        getIndicatorVisible_(type) {
            return type !== CrPolicyIndicatorType$1.NONE;
        }
        /**
         * @return {string} The iron-icon icon name.
         */
        getIndicatorIcon_(type) {
            switch (type) {
                case CrPolicyIndicatorType$1.EXTENSION:
                    return 'cr:extension';
                case CrPolicyIndicatorType$1.NONE:
                    return '';
                case CrPolicyIndicatorType$1.PRIMARY_USER:
                    return 'cr:group';
                case CrPolicyIndicatorType$1.OWNER:
                    return 'cr:person';
                case CrPolicyIndicatorType$1.USER_POLICY:
                case CrPolicyIndicatorType$1.DEVICE_POLICY:
                case CrPolicyIndicatorType$1.RECOMMENDED:
                    return 'cr20:domain';
                case CrPolicyIndicatorType$1.PARENT:
                case CrPolicyIndicatorType$1.CHILD_RESTRICTION:
                    return 'cr20:kite';
                default:
                    assertNotReached$1();
            }
        }
        /**
         * @param name The name associated with the indicator. See
         *     chrome.settingsPrivate.PrefObject.controlledByName
         * @param matches For RECOMMENDED only, whether the indicator
         *     value matches the recommended value.
         * @return The tooltip text for |type|.
         */
        getIndicatorTooltip(type, name, matches) {
            if (!window.CrPolicyStrings) {
                return '';
            } // Tooltips may not be defined, e.g. in OOBE.
            const CrPolicyStrings = window.CrPolicyStrings;
            switch (type) {
                case CrPolicyIndicatorType$1.EXTENSION:
                    return name.length > 0 ?
                        CrPolicyStrings.controlledSettingExtension.replace('$1', name) :
                        CrPolicyStrings.controlledSettingExtensionWithoutName;
                case CrPolicyIndicatorType$1.PRIMARY_USER:
                    return CrPolicyStrings.controlledSettingShared.replace('$1', name);
                case CrPolicyIndicatorType$1.OWNER:
                    return name.length > 0 ?
                        CrPolicyStrings.controlledSettingWithOwner.replace('$1', name) :
                        CrPolicyStrings.controlledSettingNoOwner;
                case CrPolicyIndicatorType$1.USER_POLICY:
                case CrPolicyIndicatorType$1.DEVICE_POLICY:
                    return CrPolicyStrings.controlledSettingPolicy;
                case CrPolicyIndicatorType$1.RECOMMENDED:
                    return matches ?
                        CrPolicyStrings.controlledSettingRecommendedMatches :
                        CrPolicyStrings.controlledSettingRecommendedDiffers;
                case CrPolicyIndicatorType$1.PARENT:
                    return CrPolicyStrings.controlledSettingParent;
                case CrPolicyIndicatorType$1.CHILD_RESTRICTION:
                    return CrPolicyStrings.controlledSettingChildRestriction;
            }
            return '';
        }
    }
    return CrPolicyIndicatorMixin;
});

// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Polymer element for indicating policies by type.
 * Forked from
 * ui/webui/resources/cr_elements/policy/cr_policy_indicator.ts
 */
const CrPolicyIndicatorElementBase = CrPolicyIndicatorMixin(PolymerElement);
class CrPolicyIndicatorElement extends CrPolicyIndicatorElementBase {
    static get is() {
        return 'cr-policy-indicator';
    }
    static get template() {
        return getTemplate$1G();
    }
    static get properties() {
        return {
            iconAriaLabel: String,
            indicatorTooltip_: {
                type: String,
                computed: 'getIndicatorTooltip_(indicatorType, indicatorSourceName)',
            },
        };
    }
    /**
     * @param indicatorSourceName The name associated with the indicator.
     *     See chrome.settingsPrivate.PrefObject.controlledByName
     * @return The tooltip text for |type|.
     */
    getIndicatorTooltip_(indicatorType, indicatorSourceName) {
        return this.getIndicatorTooltip(indicatorType, indicatorSourceName);
    }
}
customElements.define(CrPolicyIndicatorElement.is, CrPolicyIndicatorElement);

// chrome/browser/ui/webui/ash/settings/search/mojom/user_action_recorder.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class UserActionRecorderPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.mojom.UserActionRecorder', scope);
    }
}
class UserActionRecorderRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(UserActionRecorderPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    recordPageFocus() {
        this.proxy.sendMessage(0, UserActionRecorder_RecordPageFocus_ParamsSpec.$, null, [], false);
    }
    recordPageBlur() {
        this.proxy.sendMessage(1, UserActionRecorder_RecordPageBlur_ParamsSpec.$, null, [], false);
    }
    recordClick() {
        this.proxy.sendMessage(2, UserActionRecorder_RecordClick_ParamsSpec.$, null, [], false);
    }
    recordNavigation() {
        this.proxy.sendMessage(3, UserActionRecorder_RecordNavigation_ParamsSpec.$, null, [], false);
    }
    recordSearch() {
        this.proxy.sendMessage(4, UserActionRecorder_RecordSearch_ParamsSpec.$, null, [], false);
    }
    recordSettingChange() {
        this.proxy.sendMessage(5, UserActionRecorder_RecordSettingChange_ParamsSpec.$, null, [], false);
    }
    recordSettingChangeWithDetails(setting, value) {
        this.proxy.sendMessage(6, UserActionRecorder_RecordSettingChangeWithDetails_ParamsSpec.$, null, [
            setting,
            value
        ], false);
    }
}
/**
 * An object which receives request messages for the UserActionRecorder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
class UserActionRecorderReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(UserActionRecorderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, UserActionRecorder_RecordPageFocus_ParamsSpec.$, null, impl.recordPageFocus.bind(impl), false);
        this.helper_internal_.registerHandler(1, UserActionRecorder_RecordPageBlur_ParamsSpec.$, null, impl.recordPageBlur.bind(impl), false);
        this.helper_internal_.registerHandler(2, UserActionRecorder_RecordClick_ParamsSpec.$, null, impl.recordClick.bind(impl), false);
        this.helper_internal_.registerHandler(3, UserActionRecorder_RecordNavigation_ParamsSpec.$, null, impl.recordNavigation.bind(impl), false);
        this.helper_internal_.registerHandler(4, UserActionRecorder_RecordSearch_ParamsSpec.$, null, impl.recordSearch.bind(impl), false);
        this.helper_internal_.registerHandler(5, UserActionRecorder_RecordSettingChange_ParamsSpec.$, null, impl.recordSettingChange.bind(impl), false);
        this.helper_internal_.registerHandler(6, UserActionRecorder_RecordSettingChangeWithDetails_ParamsSpec.$, null, impl.recordSettingChangeWithDetails.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
class UserActionRecorder {
    static get $interfaceName() {
        return "ash.settings.mojom.UserActionRecorder";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new UserActionRecorderRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the UserActionRecorder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
class UserActionRecorderCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(UserActionRecorderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.recordPageFocus =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, UserActionRecorder_RecordPageFocus_ParamsSpec.$, null, this.recordPageFocus.createReceiverHandler(false /* expectsResponse */), false);
        this.recordPageBlur =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, UserActionRecorder_RecordPageBlur_ParamsSpec.$, null, this.recordPageBlur.createReceiverHandler(false /* expectsResponse */), false);
        this.recordClick =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, UserActionRecorder_RecordClick_ParamsSpec.$, null, this.recordClick.createReceiverHandler(false /* expectsResponse */), false);
        this.recordNavigation =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, UserActionRecorder_RecordNavigation_ParamsSpec.$, null, this.recordNavigation.createReceiverHandler(false /* expectsResponse */), false);
        this.recordSearch =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, UserActionRecorder_RecordSearch_ParamsSpec.$, null, this.recordSearch.createReceiverHandler(false /* expectsResponse */), false);
        this.recordSettingChange =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, UserActionRecorder_RecordSettingChange_ParamsSpec.$, null, this.recordSettingChange.createReceiverHandler(false /* expectsResponse */), false);
        this.recordSettingChangeWithDetails =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, UserActionRecorder_RecordSettingChangeWithDetails_ParamsSpec.$, null, this.recordSettingChangeWithDetails.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
const UserActionRecorder_RecordPageFocus_ParamsSpec = { $: {} };
const UserActionRecorder_RecordPageBlur_ParamsSpec = { $: {} };
const UserActionRecorder_RecordClick_ParamsSpec = { $: {} };
const UserActionRecorder_RecordNavigation_ParamsSpec = { $: {} };
const UserActionRecorder_RecordSearch_ParamsSpec = { $: {} };
const UserActionRecorder_RecordSettingChange_ParamsSpec = { $: {} };
const UserActionRecorder_RecordSettingChangeWithDetails_ParamsSpec = { $: {} };
const SettingChangeValueSpec = { $: {} };
mojo.internal.Struct(UserActionRecorder_RecordPageFocus_ParamsSpec.$, 'UserActionRecorder_RecordPageFocus_Params', [], [[0, 8],]);
mojo.internal.Struct(UserActionRecorder_RecordPageBlur_ParamsSpec.$, 'UserActionRecorder_RecordPageBlur_Params', [], [[0, 8],]);
mojo.internal.Struct(UserActionRecorder_RecordClick_ParamsSpec.$, 'UserActionRecorder_RecordClick_Params', [], [[0, 8],]);
mojo.internal.Struct(UserActionRecorder_RecordNavigation_ParamsSpec.$, 'UserActionRecorder_RecordNavigation_Params', [], [[0, 8],]);
mojo.internal.Struct(UserActionRecorder_RecordSearch_ParamsSpec.$, 'UserActionRecorder_RecordSearch_Params', [], [[0, 8],]);
mojo.internal.Struct(UserActionRecorder_RecordSettingChange_ParamsSpec.$, 'UserActionRecorder_RecordSettingChange_Params', [], [[0, 8],]);
mojo.internal.Struct(UserActionRecorder_RecordSettingChangeWithDetails_ParamsSpec.$, 'UserActionRecorder_RecordSettingChangeWithDetails_Params', [
    mojo.internal.StructField('setting', 0, 0, SettingSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('value', 8, 0, SettingChangeValueSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Union(SettingChangeValueSpec.$, 'SettingChangeValue', {
    'boolValue': {
        'ordinal': 0,
        'type': mojo.internal.Bool,
    },
    'intValue': {
        'ordinal': 1,
        'type': mojo.internal.Int32,
    },
    'stringValue': {
        'ordinal': 2,
        'type': mojo.internal.String,
    },
});
var SettingChangeValueFieldTags;
(function (SettingChangeValueFieldTags) {
    SettingChangeValueFieldTags[SettingChangeValueFieldTags["BOOL_VALUE"] = 0] = "BOOL_VALUE";
    SettingChangeValueFieldTags[SettingChangeValueFieldTags["INT_VALUE"] = 1] = "INT_VALUE";
    SettingChangeValueFieldTags[SettingChangeValueFieldTags["STRING_VALUE"] = 2] = "STRING_VALUE";
})(SettingChangeValueFieldTags || (SettingChangeValueFieldTags = {}));
function whichSettingChangeValue(u) {
    if (u.boolValue !== null && u.boolValue !== undefined) {
        return SettingChangeValueFieldTags.BOOL_VALUE;
    }
    if (u.intValue !== null && u.intValue !== undefined) {
        return SettingChangeValueFieldTags.INT_VALUE;
    }
    if (u.stringValue !== null && u.stringValue !== undefined) {
        return SettingChangeValueFieldTags.STRING_VALUE;
    }
    throw new Error("no union field has been set, this is an illegal state");
}

var user_action_recorder_mojomWebui = /*#__PURE__*/Object.freeze({
  __proto__: null,
  get SettingChangeValueFieldTags () { return SettingChangeValueFieldTags; },
  SettingChangeValueSpec: SettingChangeValueSpec,
  UserActionRecorder: UserActionRecorder,
  UserActionRecorderCallbackRouter: UserActionRecorderCallbackRouter,
  UserActionRecorderPendingReceiver: UserActionRecorderPendingReceiver,
  UserActionRecorderReceiver: UserActionRecorderReceiver,
  UserActionRecorderRemote: UserActionRecorderRemote,
  UserActionRecorder_RecordClick_ParamsSpec: UserActionRecorder_RecordClick_ParamsSpec,
  UserActionRecorder_RecordNavigation_ParamsSpec: UserActionRecorder_RecordNavigation_ParamsSpec,
  UserActionRecorder_RecordPageBlur_ParamsSpec: UserActionRecorder_RecordPageBlur_ParamsSpec,
  UserActionRecorder_RecordPageFocus_ParamsSpec: UserActionRecorder_RecordPageFocus_ParamsSpec,
  UserActionRecorder_RecordSearch_ParamsSpec: UserActionRecorder_RecordSearch_ParamsSpec,
  UserActionRecorder_RecordSettingChangeWithDetails_ParamsSpec: UserActionRecorder_RecordSettingChangeWithDetails_ParamsSpec,
  UserActionRecorder_RecordSettingChange_ParamsSpec: UserActionRecorder_RecordSettingChange_ParamsSpec,
  whichSettingChangeValue: whichSettingChangeValue
});

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
let userActionRecorder = null;
function setUserActionRecorderForTesting(testRecorder) {
    userActionRecorder = testRecorder;
}
function getRecorder() {
    if (userActionRecorder) {
        return userActionRecorder;
    }
    userActionRecorder = UserActionRecorder.getRemote();
    return userActionRecorder;
}
function recordPageFocus() {
    getRecorder().recordPageFocus();
}
function recordPageBlur() {
    getRecorder().recordPageBlur();
}
function recordClick() {
    getRecorder().recordClick();
}
function recordNavigation() {
    getRecorder().recordNavigation();
}
function recordSearch() {
    getRecorder().recordSearch();
}
/**
 * This function is reserved only for pref-based setting changes that have no
 * corresponding entry in `metrics_utils.ts`. This function should not be used
 * in any new code.
 */
function recordSettingChangeForUnmappedPref() {
    getRecorder().recordSettingChange();
}
/**
 * Records when a `setting` is changed and, if applicable, its updated `value`.
 */
function recordSettingChange(setting, value) {
    getRecorder().recordSettingChangeWithDetails(setting, value || null);
}

// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Make a string safe for Polymer bindings that are inner-h-t-m-l or other
 * innerHTML use.
 * @param rawString The unsanitized string
 * @param opts Optional additional allowed tags and attributes.
 */
function sanitizeInnerHtmlInternal$1(rawString, opts) {
    opts = opts || {};
    const html = parseHtmlSubset$1(`<b>${rawString}</b>`, opts.tags, opts.attrs)
        .firstElementChild;
    return html.innerHTML;
}
// 
let sanitizedPolicy$1 = null;
/**
 * Same as |sanitizeInnerHtmlInternal|, but it passes through sanitizedPolicy
 * to create a TrustedHTML.
 */
function sanitizeInnerHtml$1(rawString, opts) {
    assert$1(window.trustedTypes);
    if (sanitizedPolicy$1 === null) {
        // Initialize |sanitizedPolicy| lazily.
        sanitizedPolicy$1 = window.trustedTypes.createPolicy('sanitize-inner-html', {
            createHTML: sanitizeInnerHtmlInternal$1,
            createScript: () => assertNotReached$1(),
            createScriptURL: () => assertNotReached$1(),
        });
    }
    return sanitizedPolicy$1.createHTML(rawString, opts);
}
const allowAttribute = (_node, _value) => true;
/** Allow-list of attributes in parseHtmlSubset. */
const allowedAttributes = new Map([
    [
        'href',
        (node, value) => {
            // Only allow a[href] starting with chrome:// or https:// or equaling
            // to #.
            return node.tagName === 'A' &&
                (value.startsWith('chrome://') || value.startsWith('https://') ||
                    value === '#');
        },
    ],
    [
        'target',
        (node, value) => {
            // Only allow a[target='_blank'].
            // TODO(dbeam): are there valid use cases for target !== '_blank'?
            return node.tagName === 'A' && value === '_blank';
        },
    ],
]);
/** Allow-list of optional attributes in parseHtmlSubset. */
const allowedOptionalAttributes = new Map([
    ['class', allowAttribute],
    ['id', allowAttribute],
    ['is', (_node, value) => value === 'action-link' || value === ''],
    ['role', (_node, value) => value === 'link'],
    [
        'src',
        (node, value) => {
            // Only allow img[src] starting with chrome://
            return node.tagName === 'IMG' &&
                value.startsWith('chrome://');
        },
    ],
    ['tabindex', allowAttribute],
    ['aria-description', allowAttribute],
    ['aria-hidden', allowAttribute],
    ['aria-label', allowAttribute],
    ['aria-labelledby', allowAttribute],
]);
/** Allow-list of tag names in parseHtmlSubset. */
const allowedTags = new Set(['A', 'B', 'I', 'BR', 'DIV', 'EM', 'KBD', 'P', 'PRE', 'SPAN', 'STRONG']);
/** Allow-list of optional tag names in parseHtmlSubset. */
const allowedOptionalTags = new Set(['IMG', 'LI', 'UL']);
/**
 * This policy maps a given string to a `TrustedHTML` object
 * without performing any validation. Callsites must ensure
 * that the resulting object will only be used in inert
 * documents. Initialized lazily.
 */
let unsanitizedPolicy;
/**
 * @param optTags an Array to merge.
 * @return Set of allowed tags.
 */
function mergeTags(optTags) {
    const clone = new Set(allowedTags);
    optTags.forEach(str => {
        const tag = str.toUpperCase();
        if (allowedOptionalTags.has(tag)) {
            clone.add(tag);
        }
    });
    return clone;
}
/**
 * @param optAttrs an Array to merge.
 * @return Map of allowed attributes.
 */
function mergeAttrs(optAttrs) {
    const clone = new Map(allowedAttributes);
    optAttrs.forEach(key => {
        if (allowedOptionalAttributes.has(key)) {
            clone.set(key, allowedOptionalAttributes.get(key));
        }
    });
    return clone;
}
function walk(n, f) {
    f(n);
    for (let i = 0; i < n.childNodes.length; i++) {
        walk(n.childNodes[i], f);
    }
}
function assertElement(tags, node) {
    if (!tags.has(node.tagName)) {
        throw Error(node.tagName + ' is not supported');
    }
}
function assertAttribute(attrs, attrNode, node) {
    const n = attrNode.nodeName;
    const v = attrNode.nodeValue || '';
    if (!attrs.has(n) || !attrs.get(n)(node, v)) {
        throw Error(node.tagName + '[' + n + '="' + v +
            '"] is not supported');
    }
}
/**
 * Parses a very small subset of HTML. This ensures that insecure HTML /
 * javascript cannot be injected into WebUI.
 * @param s The string to parse.
 * @param extraTags Optional extra allowed tags.
 * @param extraAttrs
 *     Optional extra allowed attributes (all tags are run through these).
 * @throws an Error in case of non supported markup.
 * @return A document fragment containing the DOM tree.
 */
function parseHtmlSubset$1(s, extraTags, extraAttrs) {
    const tags = extraTags ? mergeTags(extraTags) : allowedTags;
    const attrs = extraAttrs ? mergeAttrs(extraAttrs) : allowedAttributes;
    const doc = document.implementation.createHTMLDocument('');
    const r = doc.createRange();
    r.selectNode(doc.body);
    if (window.trustedTypes) {
        if (!unsanitizedPolicy) {
            unsanitizedPolicy =
                window.trustedTypes.createPolicy('parse-html-subset', {
                    createHTML: (untrustedHTML) => untrustedHTML,
                    createScript: () => assertNotReached$1(),
                    createScriptURL: () => assertNotReached$1(),
                });
        }
        s = unsanitizedPolicy.createHTML(s);
    }
    // This does not execute any scripts because the document has no view.
    const df = r.createContextualFragment(s);
    walk(df, function (node) {
        switch (node.nodeType) {
            case Node.ELEMENT_NODE:
                assertElement(tags, node);
                const nodeAttrs = node.attributes;
                for (let i = 0; i < nodeAttrs.length; ++i) {
                    assertAttribute(attrs, nodeAttrs[i], node);
                }
                break;
            case Node.COMMENT_NODE:
            case Node.DOCUMENT_FRAGMENT_NODE:
            case Node.TEXT_NODE:
                break;
            default:
                throw Error('Node type ' + node.nodeType + ' is not supported');
        }
    });
    return df;
}

function getTemplate$1F() {
    return html `<!--_html_template_start_--><style include="cr-shared-style">:host{--cr-localized-link-display:inline;display:block}:host([link-disabled]){cursor:pointer;opacity:var(--cr-disabled-opacity);pointer-events:none}a{display:var(--cr-localized-link-display)}a[href]{color:var(--cr-link-color)}a[href]:focus{outline-color:var(--cros-sys-focus_ring)}a[is=action-link]{user-select:none}#container{display:contents}</style>
<!-- innerHTML is set via setContainerInnerHtml_. -->
<div id="container"></div>
<!--_html_template_end_-->`;
}

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'localized-link' takes a localized string that
 * contains up to one anchor tag, and labels the string contained within the
 * anchor tag with the entire localized string. The string should not be bound
 * by element tags. The string should not contain any elements other than the
 * single anchor tagged element that will be aria-labelledby the entire string.
 *
 * Example: "lorem ipsum <a href="example.com">Learn More</a> dolor sit"
 *
 * The "Learn More" will be aria-labelledby like so: "lorem ipsum Learn More
 * dolor sit". Meanwhile, "Lorem ipsum" and "dolor sit" will be aria-hidden.
 *
 * This element also supports strings that do not contain anchor tags; in this
 * case, the element gracefully falls back to normal text. This can be useful
 * when the property is data-bound to a function which sometimes returns a
 * string with a link and sometimes returns a normal string.
 *
 * Forked from ui/webui/resources/ash/common/cr_elements/localized_link/localized_link.ts
 */
class LocalizedLinkElement extends PolymerElement {
    static get is() {
        return 'localized-link';
    }
    static get template() {
        return getTemplate$1F();
    }
    static get properties() {
        return {
            /**
             * The localized string that contains up to one anchor tag, the text
             * within which will be aria-labelledby the entire localizedString.
             */
            localizedString: String,
            /**
             * If provided, the URL that the anchor tag will point to. There is no
             * need to provide a linkUrl if the URL is embedded in the
             * localizedString.
             */
            linkUrl: {
                type: String,
                value: '',
            },
            /**
             * If true, localized link will be disabled.
             */
            linkDisabled: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
                observer: 'updateAnchorTagTabIndex_',
            },
            /**
             * localizedString, with aria attributes and the optionally provided link.
             */
            containerInnerHTML_: {
                type: String,
                value: '',
                computed: 'getAriaLabelledContent_(localizedString, linkUrl)',
                observer: 'setContainerInnerHtml_',
            },
        };
    }
    /**
     * Attaches aria attributes and optionally provided link to the provided
     * localizedString.
     * @return localizedString formatted with additional ids, spans, and an
     *     aria-labelledby tag
     */
    getAriaLabelledContent_(localizedString, linkUrl) {
        const tempEl = document.createElement('div');
        tempEl.innerHTML = sanitizeInnerHtml$1(localizedString, { attrs: ['id'] });
        const ariaLabelledByIds = [];
        tempEl.childNodes.forEach((node, index) => {
            // Text nodes should be aria-hidden and associated with an element id
            // that the anchor element can be aria-labelledby.
            if (node.nodeType === Node.TEXT_NODE) {
                const spanNode = document.createElement('span');
                spanNode.textContent = node.textContent;
                spanNode.id = `id${index}`;
                ariaLabelledByIds.push(spanNode.id);
                spanNode.setAttribute('aria-hidden', 'true');
                node.replaceWith(spanNode);
                return;
            }
            // The single element node with anchor tags should also be aria-labelledby
            // itself in-order with respect to the entire string.
            if (node.nodeType === Node.ELEMENT_NODE && node.nodeName === 'A') {
                const element = node;
                element.id = `id${index}`;
                ariaLabelledByIds.push(element.id);
                return;
            }
            // Only text and <a> nodes are allowed.
            assertNotReached$1('localized-link has invalid node types');
        });
        const anchorTags = tempEl.querySelectorAll('a');
        // In the event the provided localizedString contains only text nodes,
        // populate the contents with the provided localizedString.
        if (anchorTags.length === 0) {
            return localizedString;
        }
        assert$1(anchorTags.length === 1, 'localized-link should contain exactly one anchor tag');
        const anchorTag = anchorTags[0];
        anchorTag.setAttribute('aria-labelledby', ariaLabelledByIds.join(' '));
        anchorTag.tabIndex = this.linkDisabled ? -1 : 0;
        if (linkUrl !== '') {
            anchorTag.href = linkUrl;
            anchorTag.target = '_blank';
        }
        return tempEl.innerHTML;
    }
    setContainerInnerHtml_() {
        this.$.container.innerHTML = sanitizeInnerHtml$1(this.containerInnerHTML_, {
            attrs: [
                'aria-hidden',
                'aria-labelledby',
                'id',
                'tabindex',
            ],
        });
        const anchorTag = this.shadowRoot.querySelector('a');
        if (anchorTag) {
            anchorTag.addEventListener('click', (event) => this.onAnchorTagClick_(event));
            anchorTag.addEventListener('auxclick', (event) => {
                // trigger the click handler on middle-button clicks
                if (event.button === 1) {
                    this.onAnchorTagClick_(event);
                }
            });
        }
    }
    onAnchorTagClick_(event) {
        if (this.linkDisabled) {
            event.preventDefault();
            return;
        }
        this.dispatchEvent(new CustomEvent('link-clicked', { bubbles: true, composed: true, detail: { event } }));
        // Stop propagation of the event, since it has already been handled by
        // opening the link.
        event.stopPropagation();
    }
    /**
     *  Removes anchor tag from being targeted by chromeVox when link is
     *  disabled.
     */
    updateAnchorTagTabIndex_() {
        const anchorTag = this.shadowRoot.querySelector('a');
        if (!anchorTag) {
            return;
        }
        anchorTag.tabIndex = this.linkDisabled ? -1 : 0;
    }
}
customElements.define(LocalizedLinkElement.is, LocalizedLinkElement);

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'I18nMixin' is a Mixin offering loading of internationalization
 * strings. Typically it is used as [[i18n('someString')]] computed bindings or
 * for this.i18n('foo'). It is not needed for HTML $i18n{otherString}, which is
 * handled by a C++ templatizer.
 *
 * Forked from ui/webui/resources/cr_elements/i18n_mixin.ts
 */
const I18nMixin = dedupingMixin((superClass) => {
    class I18nMixin extends superClass {
        /**
         * Returns a translated string where $1 to $9 are replaced by the given
         * values.
         * @param id The ID of the string to translate.
         * @param varArgs Values to replace the placeholders $1 to $9 in the
         *     string.
         * @return A translated, substituted string.
         */
        i18nRaw_(id, ...varArgs) {
            return varArgs.length === 0 ? loadTimeData.getString(id) :
                loadTimeData.getStringF(id, ...varArgs);
        }
        /**
         * Returns a translated string where $1 to $9 are replaced by the given
         * values. Also sanitizes the output to filter out dangerous HTML/JS.
         * Use with Polymer bindings that are *not* inner-h-t-m-l.
         * NOTE: This is not related to $i18n{foo} in HTML, see file overview.
         * @param id The ID of the string to translate.
         * @param varArgs Values to replace the placeholders $1 to $9 in the
         *     string.
         * @return A translated, sanitized, substituted string.
         */
        i18n(id, ...varArgs) {
            const rawString = this.i18nRaw_(id, ...varArgs);
            return parseHtmlSubset$1(`<b>${rawString}</b>`).firstChild.textContent;
        }
        /**
         * Similar to 'i18n', returns a translated, sanitized, substituted
         * string. It receives the string ID and a dictionary containing the
         * substitutions as well as optional additional allowed tags and
         * attributes. Use with Polymer bindings that are inner-h-t-m-l, for
         * example.
         * @param id The ID of the string to translate.
         */
        i18nAdvanced(id, opts) {
            opts = opts || {};
            const rawString = this.i18nRaw_(id, ...(opts.substitutions || []));
            return sanitizeInnerHtml$1(rawString, opts);
        }
        /**
         * Similar to 'i18n', with an unused |locale| parameter used to trigger
         * updates when the locale changes.
         * @param locale The UI language used.
         * @param id The ID of the string to translate.
         * @param varArgs Values to replace the placeholders $1 to $9 in the
         *     string.
         * @return A translated, sanitized, substituted string.
         */
        i18nDynamic(_locale, id, ...varArgs) {
            return this.i18n(id, ...varArgs);
        }
        /**
         * Similar to 'i18nDynamic', but varArgs valus are interpreted as keys
         * in loadTimeData. This allows generation of strings that take other
         * localized strings as parameters.
         * @param locale The UI language used.
         * @param id The ID of the string to translate.
         * @param varArgs Values to replace the placeholders $1 to $9
         *     in the string. Values are interpreted as strings IDs if found in
         * the list of localized strings.
         * @return A translated, sanitized, substituted string.
         */
        i18nRecursive(locale, id, ...varArgs) {
            let args = varArgs;
            if (args.length > 0) {
                // Try to replace IDs with localized values.
                args = args.map(str => {
                    return this.i18nExists(str) ? loadTimeData.getString(str) : str;
                });
            }
            return this.i18nDynamic(locale, id, ...args);
        }
        /**
         * Returns true if a translation exists for |id|.
         */
        i18nExists(id) {
            return loadTimeData.valueExists(id);
        }
    }
    return I18nMixin;
});

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const WebUiListenerMixin = dedupingMixin((superClass) => {
    class WebUiListenerMixin extends superClass {
        constructor() {
            super(...arguments);
            /**
             * Holds WebUI listeners that need to be removed when this element is
             * destroyed.
             */
            this.webUiListeners_ = [];
        }
        /**
         * Adds a WebUI listener and registers it for automatic removal when
         * this element is detached. Note: Do not use this method if you intend
         * to remove this listener manually (use addWebUiListener directly
         * instead).
         *
         * @param eventName The event to listen to.
         * @param callback The callback run when the event is fired.
         */
        addWebUiListener(eventName, callback) {
            this.webUiListeners_.push(addWebUiListener(eventName, callback));
        }
        disconnectedCallback() {
            super.disconnectedCallback();
            while (this.webUiListeners_.length > 0) {
                removeWebUiListener(this.webUiListeners_.pop());
            }
        }
    }
    return WebUiListenerMixin;
});

const styleMod$6 = document.createElement('dom-module');
styleMod$6.appendChild(html `
  <template>
    <style>
.md-select{--md-arrow-width:10px;--md-select-bg-color:var(--cros-sys-input_field_on_base);--md-select-focus-shadow-color:var(--cros-sys-primary);--md-select-option-bg-color:var(--cros-sys-base_elevated);--md-select-side-padding:8px;--md-select-text-color:var(--cros-sys-on_surface);-webkit-appearance:none;background:url(//resources/images/arrow_down.svg) calc(100% - var(--md-select-side-padding)) center no-repeat;background-color:var(--md-select-bg-color);background-size:var(--md-arrow-width);border:none;border-radius:4px;color:var(--md-select-text-color);cursor:pointer;font-family:inherit;font-size:inherit;line-height:inherit;max-width:100%;outline:none;padding-bottom:6px;padding-inline-end:calc(var(--md-select-side-padding) + var(--md-arrow-width) + 3px);padding-inline-start:var(--md-select-side-padding);padding-top:6px;width:var(--md-select-width,200px)}@media (prefers-color-scheme:dark){.md-select{background-image:url(//resources/images/dark/arrow_down.svg)}}:host-context([chrome-refresh-2023]) .md-select{--md-select-bg-color:transparent;--md-arrow-width:7px;--md-select-side-padding:10px;--md-select-text-color:inherit;border:solid 1px var(--color-combobox-container-outline,var(--cr-fallback-color-neutral-outline));border-radius:8px;box-sizing:border-box;font-size:12px;height:36px;line-height:36px;padding-bottom:0;padding-top:0}:host-context([chrome-refresh-2023]) .md-select:hover{background-color:var(--color-comboxbox-ink-drop-hovered,var(--cr-hover-on-subtle-background-color))}.md-select :-webkit-any(option,optgroup){background-color:var(--md-select-option-bg-color)}.md-select[disabled]{opacity:var(--cr-disabled-opacity);pointer-events:none}:host-context([chrome-refresh-2023]) .md-select[disabled]{background-color:var(--color-combobox-background-disabled,var(--cr-fallback-color-disabled-background));border-color:transparent;color:var(--color-textfield-foreground-disabled,var(--cr-fallback-color-disabled-foreground));opacity:1}.md-select:focus{box-shadow:0 0 0 2px var(--md-select-focus-shadow-color)}:host-context([chrome-refresh-2023]) .md-select:focus{box-shadow:none;outline:solid 2px var(--cr-focus-outline-color);outline-offset:-1px}@media (forced-colors:active){.md-select:focus{outline:var(--cr-focus-outline-hcm)}}.md-select:active{box-shadow:none}:host-context([dir=rtl]) .md-select{background-position-x:var(--md-select-side-padding)}
    </style>
  </template>
`.content);
styleMod$6.register('md-select');

// Copyright 2011 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview EventTracker is a simple class that manages the addition and
 * removal of DOM event listeners. In particular, it keeps track of all
 * listeners that have been added and makes it easy to remove some or all of
 * them without requiring all the information again. This is particularly handy
 * when the listener is a generated function such as a lambda or the result of
 * calling Function.bind.
 */
class EventTracker {
    listeners_ = [];
    /**
     * Add an event listener - replacement for EventTarget.addEventListener.
     * @param target The DOM target to add a listener to.
     * @param eventType The type of event to subscribe to.
     * @param listener The listener to add.
     * @param capture Whether to invoke during the capture phase. Defaults to
     *     false.
     */
    add(target, eventType, listener, capture = false) {
        const h = {
            target: target,
            eventType: eventType,
            listener: listener,
            capture: capture,
        };
        this.listeners_.push(h);
        target.addEventListener(eventType, listener, capture);
    }
    /**
     * Remove any specified event listeners added with this EventTracker.
     * @param target The DOM target to remove a listener from.
     * @param eventType The type of event to remove.
     */
    remove(target, eventType) {
        this.listeners_ = this.listeners_.filter(listener => {
            if (listener.target === target &&
                (!eventType || (listener.eventType === eventType))) {
                EventTracker.removeEventListener(listener);
                return false;
            }
            return true;
        });
    }
    /** Remove all event listeners added with this EventTracker. */
    removeAll() {
        this.listeners_.forEach(listener => EventTracker.removeEventListener(listener));
        this.listeners_ = [];
    }
    /**
     * Remove a single event listener given it's tracking entry. It's up to the
     * caller to ensure the entry is removed from listeners_.
     * @param entry The entry describing the listener to
     * remove.
     */
    static removeEventListener(entry) {
        entry.target.removeEventListener(entry.eventType, entry.listener, entry.capture);
    }
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @return The currently focused element (including elements that are
 *     behind a shadow root), or null if nothing is focused.
 */
function getDeepActiveElement() {
    let a = document.activeElement;
    while (a && a.shadowRoot && a.shadowRoot.activeElement) {
        a = a.shadowRoot.activeElement;
    }
    return a;
}
/**
 * Check the directionality of the page.
 * @return True if Chrome is running an RTL UI.
 */
function isRTL$1() {
    return document.documentElement.dir === 'rtl';
}
/**
 * Replaces '&', '<', '>', '"', and ''' characters with their HTML encoding.
 * @param original The original string.
 * @return The string with all the characters mentioned above replaced.
 */
function htmlEscape(original) {
    return original.replace(/&/g, '&amp;')
        .replace(/</g, '&lt;')
        .replace(/>/g, '&gt;')
        .replace(/"/g, '&quot;')
        .replace(/'/g, '&#39;');
}
/**
 * Calls |callback| and stops listening the first time any event in |eventNames|
 * is triggered on |target|.
 * @param eventNames Array or space-delimited string of event names to listen to
 *     (e.g. 'click mousedown').
 * @param callback Called at most once. The optional return value is passed on
 *     by the listener.
 */
function listenOnce(target, eventNames, callback) {
    const eventNamesArray = Array.isArray(eventNames) ? eventNames : eventNames.split(/ +/);
    const removeAllAndCallCallback = function (event) {
        eventNamesArray.forEach(function (eventName) {
            target.removeEventListener(eventName, removeAllAndCallCallback, false);
        });
        return callback(event);
    };
    eventNamesArray.forEach(function (eventName) {
        target.addEventListener(eventName, removeAllAndCallCallback, false);
    });
}
/**
 * @return Whether a modifier key was down when processing |e|.
 */
function hasKeyModifiers(e) {
    return !!(e.altKey || e.ctrlKey || e.metaKey || e.shiftKey);
}

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// clang-format off
// clang-format on
const ACTIVE_CLASS = 'focus-row-active';
/**
 * A class to manage focus between given horizontally arranged elements.
 *
 * Pressing left cycles backward and pressing right cycles forward in item
 * order. Pressing Home goes to the beginning of the list and End goes to the
 * end of the list.
 *
 * If an item in this row is focused, it'll stay active (accessible via tab).
 * If no items in this row are focused, the row can stay active until focus
 * changes to a node inside |this.boundary_|. If |boundary| isn't specified,
 * any focus change deactivates the row.
 */
class FocusRow {
    root;
    delegate;
    eventTracker = new EventTracker();
    boundary_;
    /**
     * @param root The root of this focus row. Focus classes are
     *     applied to |root| and all added elements must live within |root|.
     * @param boundary Focus events are ignored outside of this element.
     * @param delegate An optional event delegate.
     */
    constructor(root, boundary, delegate) {
        this.root = root;
        this.boundary_ = boundary || document.documentElement;
        this.delegate = delegate;
    }
    /**
     * Whether it's possible that |element| can be focused.
     */
    static isFocusable(element) {
        if (!element || element.disabled) {
            return false;
        }
        // We don't check that element.tabIndex >= 0 here because inactive rows
        // set a tabIndex of -1.
        let current = element;
        while (true) {
            assertInstanceof$1(current, Element);
            const style = window.getComputedStyle(current);
            if (style.visibility === 'hidden' || style.display === 'none') {
                return false;
            }
            const parent = current.parentNode;
            if (!parent) {
                return false;
            }
            if (parent === current.ownerDocument ||
                parent instanceof DocumentFragment) {
                return true;
            }
            current = parent;
        }
    }
    /**
     * A focus override is a function that returns an element that should gain
     * focus. The element may not be directly selectable for example the element
     * that can gain focus is in a shadow DOM. Allowing an override via a
     * function leaves the details of how the element is retrieved to the
     * component.
     */
    static getFocusableElement(element) {
        const withFocusable = element;
        if (withFocusable.getFocusableElement) {
            return withFocusable.getFocusableElement();
        }
        return element;
    }
    /**
     * Register a new type of focusable element (or add to an existing one).
     *
     * Example: an (X) button might be 'delete' or 'close'.
     *
     * When FocusRow is used within a FocusGrid, these types are used to
     * determine equivalent controls when Up/Down are pressed to change rows.
     *
     * Another example: mutually exclusive controls that hide each other on
     * activation (i.e. Play/Pause) could use the same type (i.e. 'play-pause')
     * to indicate they're equivalent.
     *
     * @param type The type of element to track focus of.
     * @param selectorOrElement The selector of the element
     *    from this row's root, or the element itself.
     * @return Whether a new item was added.
     */
    addItem(type, selectorOrElement) {
        assert$1(type);
        let element;
        if (typeof selectorOrElement === 'string') {
            element = this.root.querySelector(selectorOrElement);
        }
        else {
            element = selectorOrElement;
        }
        if (!element) {
            return false;
        }
        element.setAttribute('focus-type', type);
        element.tabIndex = this.isActive() ? 0 : -1;
        this.eventTracker.add(element, 'blur', this.onBlur_.bind(this));
        this.eventTracker.add(element, 'focus', this.onFocus_.bind(this));
        this.eventTracker.add(element, 'keydown', this.onKeydown_.bind(this));
        this.eventTracker.add(element, 'mousedown', this.onMousedown_.bind(this));
        return true;
    }
    /** Dereferences nodes and removes event handlers. */
    destroy() {
        this.eventTracker.removeAll();
    }
    /**
     * @param sampleElement An element for to find an equivalent
     *     for.
     * @return An equivalent element to focus for
     *     |sampleElement|.
     */
    getCustomEquivalent(_sampleElement) {
        const focusable = this.getFirstFocusable();
        assert$1(focusable);
        return focusable;
    }
    /**
     * @return All registered elements (regardless of focusability).
     */
    getElements() {
        return Array.from(this.root.querySelectorAll('[focus-type]'))
            .map(FocusRow.getFocusableElement);
    }
    /**
     * Find the element that best matches |sampleElement|.
     * @param sampleElement An element from a row of the same
     *     type which previously held focus.
     * @return The element that best matches sampleElement.
     */
    getEquivalentElement(sampleElement) {
        if (this.getFocusableElements().indexOf(sampleElement) >= 0) {
            return sampleElement;
        }
        const sampleFocusType = this.getTypeForElement(sampleElement);
        if (sampleFocusType) {
            const sameType = this.getFirstFocusable(sampleFocusType);
            if (sameType) {
                return sameType;
            }
        }
        return this.getCustomEquivalent(sampleElement);
    }
    /**
     * @param type An optional type to search for.
     * @return The first focusable element with |type|.
     */
    getFirstFocusable(type) {
        const element = this.getFocusableElements().find(el => !type || el.getAttribute('focus-type') === type);
        return element || null;
    }
    /** @return Registered, focusable elements. */
    getFocusableElements() {
        return this.getElements().filter(FocusRow.isFocusable);
    }
    /**
     * @param element An element to determine a focus type for.
     * @return The focus type for |element| or '' if none.
     */
    getTypeForElement(element) {
        return element.getAttribute('focus-type') || '';
    }
    /** @return Whether this row is currently active. */
    isActive() {
        return this.root.classList.contains(ACTIVE_CLASS);
    }
    /**
     * Enables/disables the tabIndex of the focusable elements in the FocusRow.
     * tabIndex can be set properly.
     * @param active True if tab is allowed for this row.
     */
    makeActive(active) {
        if (active === this.isActive()) {
            return;
        }
        this.getElements().forEach(function (element) {
            element.tabIndex = active ? 0 : -1;
        });
        this.root.classList.toggle(ACTIVE_CLASS, active);
    }
    onBlur_(e) {
        if (!this.boundary_.contains(e.relatedTarget)) {
            return;
        }
        const currentTarget = e.currentTarget;
        if (this.getFocusableElements().indexOf(currentTarget) >= 0) {
            this.makeActive(false);
        }
    }
    onFocus_(e) {
        if (this.delegate) {
            this.delegate.onFocus(this, e);
        }
    }
    onMousedown_(e) {
        // Only accept left mouse clicks.
        if (e.button) {
            return;
        }
        // Allow the element under the mouse cursor to be focusable.
        const target = e.currentTarget;
        if (!target.disabled) {
            target.tabIndex = 0;
        }
    }
    onKeydown_(e) {
        const elements = this.getFocusableElements();
        const currentElement = FocusRow.getFocusableElement(e.currentTarget);
        const elementIndex = elements.indexOf(currentElement);
        assert$1(elementIndex >= 0);
        if (this.delegate && this.delegate.onKeydown(this, e)) {
            return;
        }
        const isShiftTab = !e.altKey && !e.ctrlKey && !e.metaKey && e.shiftKey &&
            e.key === 'Tab';
        if (hasKeyModifiers(e) && !isShiftTab) {
            return;
        }
        let index = -1;
        let shouldStopPropagation = true;
        if (isShiftTab) {
            // This always moves back one element, even in RTL.
            index = elementIndex - 1;
            if (index < 0) {
                // Bubble up to focus on the previous element outside the row.
                return;
            }
        }
        else if (e.key === 'ArrowLeft') {
            index = elementIndex + (isRTL$1() ? 1 : -1);
        }
        else if (e.key === 'ArrowRight') {
            index = elementIndex + (isRTL$1() ? -1 : 1);
        }
        else if (e.key === 'Home') {
            index = 0;
        }
        else if (e.key === 'End') {
            index = elements.length - 1;
        }
        else {
            shouldStopPropagation = false;
        }
        const elementToFocus = elements[index];
        if (elementToFocus) {
            this.getEquivalentElement(elementToFocus).focus();
            e.preventDefault();
        }
        if (shouldStopPropagation) {
            e.stopPropagation();
        }
    }
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/* @fileoverview Utilities for determining the current platform. */
/** Whether we are using a Mac or not. */
const isMac = /Mac/.test(navigator.platform);
/** Whether this is on the Windows platform or not. */
const isWindows = /Win/.test(navigator.platform);
/** Whether this is on Android. */
const isAndroid = /Android/.test(navigator.userAgent);
/** Whether this is on iOS. */
const isIOS = /CriOS/.test(navigator.userAgent);

function getTemplate$1E() {
    return html `<!--_html_template_start_--><style>:host{--cr-menu-background-color:var(--cros-sys-base_elevated);--cr-menu-background-focus-color:var(--cros-sys-hover_on_subtle)}:host dialog{background-color:var(--cr-menu-background-color);border:none;border-radius:var(--cr-menu-border-radius,4px);box-shadow:var(--cr-menu-shadow);margin:0;min-width:128px;outline:none;padding:0;position:absolute}@media (forced-colors:active){:host dialog{border:var(--cr-border-hcm)}}:host-context([chrome-refresh-2023]){--cr-hairline:1px solid var(--color-menu-separator,var(--cr-fallback-color-divider));--cr-action-menu-disabled-item-color:var(--color-menu-item-foreground-disabled,var(--cr-fallback-color-disabled-foreground));--cr-action-menu-disabled-item-opacity:1;--cr-menu-background-color:var(--color-menu-background,var(--cr-fallback-color-surface));--cr-menu-background-focus-color:var(--cr-hover-background-color);--cr-menu-shadow:var(--cr-elevation-2);--cr-primary-text-color:var(--color-menu-item-foreground,var(--cr-fallback-color-on-surface))}:host dialog::backdrop{background-color:transparent}:host ::slotted(.dropdown-item){-webkit-tap-highlight-color:transparent;background:none;border:none;border-radius:0;box-sizing:border-box;color:var(--cr-primary-text-color);font:inherit;min-height:32px;padding:8px 24px;text-align:start;user-select:none;width:100%}:host ::slotted(.dropdown-item:not([hidden])){align-items:center;display:flex}:host ::slotted(.dropdown-item[disabled]){color:var(--cr-action-menu-disabled-item-color,var(--cr-primary-text-color));opacity:var(--cr-action-menu-disabled-item-opacity,0.65)}:host ::slotted(.dropdown-item:not([disabled])){cursor:pointer}:host ::slotted(.dropdown-item:focus){background-color:var(--cr-menu-background-focus-color);outline:none}@media (forced-colors:active){:host ::slotted(.dropdown-item:focus){outline:var(--cr-focus-outline-hcm)}}.item-wrapper{background:var(--cr-menu-background-sheen);outline:none;padding:8px 0}:host-context([chrome-refresh-2023]) .item-wrapper{background:none}</style>
<dialog id="dialog" part="dialog" on-close="onNativeDialogClose_"
    role="application" aria-roledescription$="[[roleDescription]]">
  <div id="wrapper" class="item-wrapper" role="menu" tabindex="-1"
      aria-label$="[[accessibilityLabel]]">
    <slot id="contentNode" on-slotchange="onSlotchange_"></slot>
  </div>
</dialog>
<!--_html_template_end_-->`;
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Forked from ui/webui/resources/cr_elements/cr_action_menu/cr_action_menu.ts
var AnchorAlignment;
(function (AnchorAlignment) {
    AnchorAlignment[AnchorAlignment["BEFORE_START"] = -2] = "BEFORE_START";
    AnchorAlignment[AnchorAlignment["AFTER_START"] = -1] = "AFTER_START";
    AnchorAlignment[AnchorAlignment["CENTER"] = 0] = "CENTER";
    AnchorAlignment[AnchorAlignment["BEFORE_END"] = 1] = "BEFORE_END";
    AnchorAlignment[AnchorAlignment["AFTER_END"] = 2] = "AFTER_END";
})(AnchorAlignment || (AnchorAlignment = {}));
const DROPDOWN_ITEM_CLASS = 'dropdown-item';
const SELECTABLE_DROPDOWN_ITEM_QUERY = `.${DROPDOWN_ITEM_CLASS}:not([hidden]):not([disabled])`;
const AFTER_END_OFFSET = 10;
/**
 * Returns the point to start along the X or Y axis given a start and end
 * point to anchor to, the length of the target and the direction to anchor
 * in. If honoring the anchor would force the menu outside of min/max, this
 * will ignore the anchor position and try to keep the menu within min/max.
 */
function getStartPointWithAnchor(start, end, menuLength, anchorAlignment, min, max) {
    let startPoint = 0;
    switch (anchorAlignment) {
        case AnchorAlignment.BEFORE_START:
            startPoint = start - menuLength;
            break;
        case AnchorAlignment.AFTER_START:
            startPoint = start;
            break;
        case AnchorAlignment.CENTER:
            startPoint = (start + end - menuLength) / 2;
            break;
        case AnchorAlignment.BEFORE_END:
            startPoint = end - menuLength;
            break;
        case AnchorAlignment.AFTER_END:
            startPoint = end;
            break;
    }
    if (startPoint + menuLength > max) {
        startPoint = end - menuLength;
    }
    if (startPoint < min) {
        startPoint = start;
    }
    startPoint = Math.max(min, Math.min(startPoint, max - menuLength));
    return startPoint;
}
function getDefaultShowConfig() {
    return {
        top: 0,
        left: 0,
        height: 0,
        width: 0,
        anchorAlignmentX: AnchorAlignment.AFTER_START,
        anchorAlignmentY: AnchorAlignment.AFTER_START,
        minX: 0,
        minY: 0,
        maxX: 0,
        maxY: 0,
    };
}
class CrActionMenuElement extends PolymerElement {
    constructor() {
        super(...arguments);
        this.boundClose_ = null;
        this.resizeObserver_ = null;
        this.hasMousemoveListener_ = false;
        this.anchorElement_ = null;
        this.lastConfig_ = null;
    }
    static get is() {
        return 'cr-action-menu';
    }
    static get template() {
        return getTemplate$1E();
    }
    static get properties() {
        return {
            // Accessibility text of the menu. Should be something along the lines of
            // "actions", or "more actions".
            accessibilityLabel: String,
            // Setting this flag will make the menu listen for content size changes
            // and reposition to its anchor accordingly.
            autoReposition: {
                type: Boolean,
                value: false,
            },
            open: {
                type: Boolean,
                notify: true,
                value: false,
            },
            // Descriptor of the menu. Should be something along the lines of "menu"
            roleDescription: String,
        };
    }
    ready() {
        super.ready();
        this.addEventListener('keydown', this.onKeyDown_.bind(this));
        this.addEventListener('mouseover', this.onMouseover_);
        this.addEventListener('click', this.onClick_);
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        this.removeListeners_();
    }
    fire_(eventName, detail) {
        this.dispatchEvent(new CustomEvent(eventName, { bubbles: true, composed: true, detail }));
    }
    /**
     * Exposing internal <dialog> elements for tests.
     */
    getDialog() {
        return this.$.dialog;
    }
    removeListeners_() {
        window.removeEventListener('resize', this.boundClose_);
        window.removeEventListener('popstate', this.boundClose_);
        if (this.resizeObserver_) {
            this.resizeObserver_.disconnect();
            this.resizeObserver_ = null;
        }
    }
    onNativeDialogClose_(e) {
        // Ignore any 'close' events not fired directly by the <dialog> element.
        if (e.target !== this.$.dialog) {
            return;
        }
        // Catch and re-fire the 'close' event such that it bubbles across Shadow
        // DOM v1.
        this.fire_('close');
    }
    onClick_(e) {
        if (e.target === this) {
            this.close();
            e.stopPropagation();
        }
    }
    onKeyDown_(e) {
        e.stopPropagation();
        if (e.key === 'Tab' || e.key === 'Escape') {
            this.close();
            if (e.key === 'Tab') {
                this.fire_('tabkeyclose', { shiftKey: e.shiftKey });
            }
            e.preventDefault();
            return;
        }
        if (e.key !== 'Enter' && e.key !== 'ArrowUp' && e.key !== 'ArrowDown') {
            return;
        }
        const options = Array.from(this.querySelectorAll(SELECTABLE_DROPDOWN_ITEM_QUERY));
        if (options.length === 0) {
            return;
        }
        const focused = getDeepActiveElement();
        const index = options.findIndex(option => FocusRow.getFocusableElement(option) === focused);
        if (e.key === 'Enter') {
            // If a menu item has focus, don't change focus or close menu on 'Enter'.
            if (index !== -1) {
                return;
            }
            if (isWindows || isMac) {
                this.close();
                e.preventDefault();
                return;
            }
        }
        e.preventDefault();
        this.updateFocus_(options, index, e.key !== 'ArrowUp');
        if (!this.hasMousemoveListener_) {
            this.hasMousemoveListener_ = true;
            this.addEventListener('mousemove', e => {
                this.onMouseover_(e);
                this.hasMousemoveListener_ = false;
            }, { once: true });
        }
    }
    onMouseover_(e) {
        const item = e.composedPath()
            .find(el => el.matches && el.matches(SELECTABLE_DROPDOWN_ITEM_QUERY));
        (item || this.$.wrapper).focus();
    }
    updateFocus_(options, focusedIndex, next) {
        const numOptions = options.length;
        assert$1(numOptions > 0);
        let index;
        if (focusedIndex === -1) {
            index = next ? 0 : numOptions - 1;
        }
        else {
            const delta = next ? 1 : -1;
            index = (numOptions + focusedIndex + delta) % numOptions;
        }
        options[index].focus();
    }
    close() {
        // Removing 'resize' and 'popstate' listeners when dialog is closed.
        this.removeListeners_();
        this.$.dialog.close();
        this.open = false;
        if (this.anchorElement_) {
            assert$1(this.anchorElement_);
            focusWithoutInk(this.anchorElement_);
            this.anchorElement_ = null;
        }
        if (this.lastConfig_) {
            this.lastConfig_ = null;
        }
    }
    /**
     * Shows the menu anchored to the given element.
     */
    showAt(anchorElement, config) {
        this.anchorElement_ = anchorElement;
        // Scroll the anchor element into view so that the bounding rect will be
        // accurate for where the menu should be shown.
        this.anchorElement_.scrollIntoViewIfNeeded();
        const rect = this.anchorElement_.getBoundingClientRect();
        let height = rect.height;
        if (config && !config.noOffset &&
            config.anchorAlignmentY === AnchorAlignment.AFTER_END) {
            // When an action menu is positioned after the end of an element, the
            // action menu can appear too far away from the anchor element, typically
            // because anchors tend to have padding. So we offset the height a bit
            // so the menu shows up slightly closer to the content of anchor.
            height -= AFTER_END_OFFSET;
        }
        this.showAtPosition(Object.assign({
            top: rect.top,
            left: rect.left,
            height: height,
            width: rect.width,
            // Default to anchoring towards the left.
            anchorAlignmentX: AnchorAlignment.BEFORE_END,
        }, config));
        this.$.wrapper.focus();
    }
    /**
     * Shows the menu anchored to the given box. The anchor alignment is
     * specified as an X and Y alignment which represents a point in the anchor
     * where the menu will align to, which can have the menu either before or
     * after the given point in each axis. Center alignment places the center of
     * the menu in line with the center of the anchor. Coordinates are relative to
     * the top-left of the viewport.
     *
     *            y-start
     *         _____________
     *         |           |
     *         |           |
     *         |   CENTER  |
     * x-start |     x     | x-end
     *         |           |
     *         |anchor box |
     *         |___________|
     *
     *             y-end
     *
     * For example, aligning the menu to the inside of the top-right edge of
     * the anchor, extending towards the bottom-left would use a alignment of
     * (BEFORE_END, AFTER_START), whereas centering the menu below the bottom
     * edge of the anchor would use (CENTER, AFTER_END).
     */
    showAtPosition(config) {
        // Save the scroll position of the viewport.
        const doc = document.scrollingElement;
        const scrollLeft = doc.scrollLeft;
        const scrollTop = doc.scrollTop;
        // Reset position so that layout isn't affected by the previous position,
        // and so that the dialog is positioned at the top-start corner of the
        // document.
        this.resetStyle_();
        this.$.dialog.showModal();
        this.open = true;
        config.top += scrollTop;
        config.left += scrollLeft;
        this.positionDialog_(Object.assign({
            minX: scrollLeft,
            minY: scrollTop,
            maxX: scrollLeft + doc.clientWidth,
            maxY: scrollTop + doc.clientHeight,
        }, config));
        // Restore the scroll position.
        doc.scrollTop = scrollTop;
        doc.scrollLeft = scrollLeft;
        this.addListeners_();
        // Focus the first selectable item.
        const openedByKey = FocusOutlineManager.forDocument(document).visible;
        if (openedByKey) {
            const firstSelectableItem = this.querySelector(SELECTABLE_DROPDOWN_ITEM_QUERY);
            if (firstSelectableItem) {
                requestAnimationFrame(() => {
                    // Wait for the next animation frame for the dialog to become visible.
                    firstSelectableItem.focus();
                });
            }
        }
    }
    resetStyle_() {
        this.$.dialog.style.left = '';
        this.$.dialog.style.right = '';
        this.$.dialog.style.top = '0';
    }
    /**
     * Position the dialog using the coordinates in config. Coordinates are
     * relative to the top-left of the viewport when scrolled to (0, 0).
     */
    positionDialog_(config) {
        this.lastConfig_ = config;
        const c = Object.assign(getDefaultShowConfig(), config);
        const top = c.top;
        const left = c.left;
        const bottom = top + c.height;
        const right = left + c.width;
        // Flip the X anchor in RTL.
        const rtl = getComputedStyle(this).direction === 'rtl';
        if (rtl) {
            c.anchorAlignmentX *= -1;
        }
        const offsetWidth = this.$.dialog.offsetWidth;
        const menuLeft = getStartPointWithAnchor(left, right, offsetWidth, c.anchorAlignmentX, c.minX, c.maxX);
        if (rtl) {
            const menuRight = document.scrollingElement.clientWidth - menuLeft - offsetWidth;
            this.$.dialog.style.right = menuRight + 'px';
        }
        else {
            this.$.dialog.style.left = menuLeft + 'px';
        }
        const menuTop = getStartPointWithAnchor(top, bottom, this.$.dialog.offsetHeight, c.anchorAlignmentY, c.minY, c.maxY);
        this.$.dialog.style.top = menuTop + 'px';
    }
    onSlotchange_() {
        for (const node of this.$.contentNode.assignedElements({ flatten: true })) {
            if (node.classList.contains(DROPDOWN_ITEM_CLASS) &&
                !node.getAttribute('role')) {
                node.setAttribute('role', 'menuitem');
            }
        }
    }
    addListeners_() {
        this.boundClose_ = this.boundClose_ || (() => {
            if (this.$.dialog.open) {
                this.close();
            }
        });
        window.addEventListener('resize', this.boundClose_);
        window.addEventListener('popstate', this.boundClose_);
        if (this.autoReposition) {
            this.resizeObserver_ = new ResizeObserver(() => {
                if (this.lastConfig_) {
                    this.positionDialog_(this.lastConfig_);
                    this.fire_('cr-action-menu-repositioned'); // For easier testing.
                }
            });
            this.resizeObserver_.observe(this.$.dialog);
        }
    }
}
customElements.define(CrActionMenuElement.is, CrActionMenuElement);

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * cr-lazy-render is a simple variant of dom-if designed for lazy rendering
 * of elements that are accessed imperatively.
 * Usage:
 *   <cr-lazy-render id="menu">
 *     <template>
 *       <heavy-menu></heavy-menu>
 *     </template>
 *   </cr-lazy-render>
 *
 *   this.$.menu.get().show();
 *
 * Forked from
 * ui/webui/resources/cr_elements/cr_lazy_render/cr_lazy_render.ts
 */
class CrLazyRenderElement extends PolymerElement {
    constructor() {
        super(...arguments);
        this.child_ = null;
        this.instance_ = null;
    }
    static get is() {
        return 'cr-lazy-render';
    }
    static get template() {
        return html `<slot></slot>`;
    }
    /**
     * Stamp the template into the DOM tree synchronously
     * @return Child element which has been stamped into the DOM tree.
     */
    get() {
        if (!this.child_) {
            this.render_();
        }
        assert$1(this.child_);
        return this.child_;
    }
    /**
     * @return The element contained in the template, if it has
     *   already been stamped.
     */
    getIfExists() {
        return this.child_;
    }
    render_() {
        const template = (this.shadowRoot.querySelector('slot').assignedNodes({ flatten: true })
            .filter(n => n.nodeType === Node.ELEMENT_NODE)[0]);
        const TemplateClass = templatize(template, this, {
            mutableData: false,
            forwardHostProp: this._forwardHostPropV2,
        });
        const parentNode = this.parentNode;
        if (parentNode && !this.child_) {
            this.instance_ = new TemplateClass();
            this.child_ = this.instance_.root.firstElementChild;
            parentNode.insertBefore(this.instance_.root, this);
        }
    }
    /* eslint-disable-next-line @typescript-eslint/naming-convention */
    _forwardHostPropV2(prop, value) {
        if (this.instance_) {
            this.instance_.forwardHostProp(prop, value);
        }
    }
}
customElements.define(CrLazyRenderElement.is, CrLazyRenderElement);

/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/

// Contains all connected resizables that do not have a parent.
var ORPHANS = new Set();

/**
 * `IronResizableBehavior` is a behavior that can be used in Polymer elements to
 * coordinate the flow of resize events between "resizers" (elements that
 *control the size or hidden state of their children) and "resizables" (elements
 *that need to be notified when they are resized or un-hidden by their parents
 *in order to take action on their new measurements).
 *
 * Elements that perform measurement should add the `IronResizableBehavior`
 *behavior to their element definition and listen for the `iron-resize` event on
 *themselves. This event will be fired when they become showing after having
 *been hidden, when they are resized explicitly by another resizable, or when
 *the window has been resized.
 *
 * Note, the `iron-resize` event is non-bubbling.
 *
 * @polymerBehavior
 * @demo demo/index.html
 **/
const IronResizableBehavior = {
  properties: {
    /**
     * The closest ancestor element that implements `IronResizableBehavior`.
     */
    _parentResizable: {
      type: Object,
      observer: '_parentResizableChanged',
    },

    /**
     * True if this element is currently notifying its descendant elements of
     * resize.
     */
    _notifyingDescendant: {
      type: Boolean,
      value: false,
    }
  },

  listeners: {
    'iron-request-resize-notifications': '_onIronRequestResizeNotifications'
  },

  created: function() {
    // We don't really need property effects on these, and also we want them
    // to be created before the `_parentResizable` observer fires:
    this._interestedResizables = [];
    this._boundNotifyResize = this.notifyResize.bind(this);
    this._boundOnDescendantIronResize = this._onDescendantIronResize.bind(this);
  },

  attached: function() {
    this._requestResizeNotifications();
  },

  detached: function() {
    if (this._parentResizable) {
      this._parentResizable.stopResizeNotificationsFor(this);
    } else {
      ORPHANS.delete(this);
      window.removeEventListener('resize', this._boundNotifyResize);
    }

    this._parentResizable = null;
  },

  /**
   * Can be called to manually notify a resizable and its descendant
   * resizables of a resize change.
   */
  notifyResize: function() {
    if (!this.isAttached) {
      return;
    }

    this._interestedResizables.forEach(function(resizable) {
      if (this.resizerShouldNotify(resizable)) {
        this._notifyDescendant(resizable);
      }
    }, this);

    this._fireResize();
  },

  /**
   * Used to assign the closest resizable ancestor to this resizable
   * if the ancestor detects a request for notifications.
   */
  assignParentResizable: function(parentResizable) {
    if (this._parentResizable) {
      this._parentResizable.stopResizeNotificationsFor(this);
    }

    this._parentResizable = parentResizable;

    if (parentResizable &&
        parentResizable._interestedResizables.indexOf(this) === -1) {
      parentResizable._interestedResizables.push(this);
      parentResizable._subscribeIronResize(this);
    }
  },

  /**
   * Used to remove a resizable descendant from the list of descendants
   * that should be notified of a resize change.
   */
  stopResizeNotificationsFor: function(target) {
    var index = this._interestedResizables.indexOf(target);

    if (index > -1) {
      this._interestedResizables.splice(index, 1);
      this._unsubscribeIronResize(target);
    }
  },

  /**
   * Subscribe this element to listen to iron-resize events on the given target.
   *
   * Preferred over target.listen because the property renamer does not
   * understand to rename when the target is not specifically "this"
   *
   * @param {!HTMLElement} target Element to listen to for iron-resize events.
   */
  _subscribeIronResize: function(target) {
    target.addEventListener('iron-resize', this._boundOnDescendantIronResize);
  },

  /**
   * Unsubscribe this element from listening to to iron-resize events on the
   * given target.
   *
   * Preferred over target.unlisten because the property renamer does not
   * understand to rename when the target is not specifically "this"
   *
   * @param {!HTMLElement} target Element to listen to for iron-resize events.
   */
  _unsubscribeIronResize: function(target) {
    target.removeEventListener(
        'iron-resize', this._boundOnDescendantIronResize);
  },

  /**
   * This method can be overridden to filter nested elements that should or
   * should not be notified by the current element. Return true if an element
   * should be notified, or false if it should not be notified.
   *
   * @param {HTMLElement} element A candidate descendant element that
   * implements `IronResizableBehavior`.
   * @return {boolean} True if the `element` should be notified of resize.
   */
  resizerShouldNotify: function(element) {
    return true;
  },

  _onDescendantIronResize: function(event) {
    if (this._notifyingDescendant) {
      event.stopPropagation();
      return;
    }

    // no need to use this during shadow dom because of event retargeting
    if (!useShadow) {
      this._fireResize();
    }
  },

  _fireResize: function() {
    this.fire('iron-resize', null, {node: this, bubbles: false});
  },

  _onIronRequestResizeNotifications: function(event) {
    var target = /** @type {!EventTarget} */ (dom(event).rootTarget);
    if (target === this) {
      return;
    }

    target.assignParentResizable(this);
    this._notifyDescendant(target);

    event.stopPropagation();
  },

  _parentResizableChanged: function(parentResizable) {
    if (parentResizable) {
      window.removeEventListener('resize', this._boundNotifyResize);
    }
  },

  _notifyDescendant: function(descendant) {
    // NOTE(cdata): In IE10, attached is fired on children first, so it's
    // important not to notify them if the parent is not attached yet (or
    // else they will get redundantly notified when the parent attaches).
    if (!this.isAttached) {
      return;
    }

    this._notifyingDescendant = true;
    descendant.notifyResize();
    this._notifyingDescendant = false;
  },

  _requestResizeNotifications: function() {
    if (!this.isAttached) {
      return;
    }

    if (document.readyState === 'loading') {
      var _requestResizeNotifications =
          this._requestResizeNotifications.bind(this);
      document.addEventListener(
          'readystatechange', function readystatechanged() {
            document.removeEventListener('readystatechange', readystatechanged);
            _requestResizeNotifications();
          });
    } else {
      this._findParent();

      if (!this._parentResizable) {
        // If this resizable is an orphan, tell other orphans to try to find
        // their parent again, in case it's this resizable.
        ORPHANS.forEach(function(orphan) {
          if (orphan !== this) {
            orphan._findParent();
          }
        }, this);

        window.addEventListener('resize', this._boundNotifyResize);
        this.notifyResize();
      } else {
        // If this resizable has a parent, tell other child resizables of
        // that parent to try finding their parent again, in case it's this
        // resizable.
        this._parentResizable._interestedResizables
            .forEach(function(resizable) {
              if (resizable !== this) {
                resizable._findParent();
              }
            }, this);
      }
    }
  },

  _findParent: function() {
    this.assignParentResizable(null);
    this.fire(
        'iron-request-resize-notifications',
        null,
        {node: this, bubbles: true, cancelable: true});

    if (!this._parentResizable) {
      ORPHANS.add(this);
    } else {
      ORPHANS.delete(this);
    }
  }
};

/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/

/**
`iron-collapse` creates a collapsible block of content.  By default, the content
will be collapsed.  Use `opened` or `toggle()` to show/hide the content.

    <button on-click="toggle">toggle collapse</button>

    <iron-collapse id="collapse">
      <div>Content goes here...</div>
    </iron-collapse>

    ...

    toggle: function() {
      this.$.collapse.toggle();
    }

`iron-collapse` adjusts the max-height/max-width of the collapsible element to
show/hide the content.  So avoid putting padding/margin/border on the
collapsible directly, and instead put a div inside and style that.

    <style>
      .collapse-content {
        padding: 15px;
        border: 1px solid #dedede;
      }
    </style>

    <iron-collapse>
      <div class="collapse-content">
        <div>Content goes here...</div>
      </div>
    </iron-collapse>

### Styling

The following custom properties and mixins are available for styling:

Custom property | Description | Default
----------------|-------------|----------
`--iron-collapse-transition-duration` | Animation transition duration | `300ms`

@group Iron Elements
@hero hero.svg
@demo demo/index.html
@element iron-collapse
*/
Polymer({
  _template: html`
    <style>
      :host {
        display: block;
        transition-duration: var(--iron-collapse-transition-duration, 300ms);
        /* Safari 10 needs this property prefixed to correctly apply the custom property */
        overflow: visible;
      }

      :host(.iron-collapse-closed) {
        display: none;
      }

      :host(:not(.iron-collapse-opened)) {
        overflow: hidden;
      }
    </style>

    <slot></slot>
`,

  is: 'iron-collapse',
  behaviors: [IronResizableBehavior],

  properties: {

    /**
     * If true, the orientation is horizontal; otherwise is vertical.
     *
     * @attribute horizontal
     */
    horizontal: {type: Boolean, value: false, observer: '_horizontalChanged'},

    /**
     * Set opened to true to show the collapse element and to false to hide it.
     *
     * @attribute opened
     */
    opened:
        {type: Boolean, value: false, notify: true, observer: '_openedChanged'},

    /**
     * When true, the element is transitioning its opened state. When false,
     * the element has finished opening/closing.
     *
     * @attribute transitioning
     */
    transitioning: {type: Boolean, notify: true, readOnly: true},

    /**
     * Set noAnimation to true to disable animations.
     *
     * @attribute noAnimation
     */
    noAnimation: {type: Boolean},

    /**
     * Stores the desired size of the collapse body.
     * @private
     */
    _desiredSize: {type: String, value: ''}
  },

  get dimension() {
    return this.horizontal ? 'width' : 'height';
  },

  /**
   * `maxWidth` or `maxHeight`.
   * @private
   */
  get _dimensionMax() {
    return this.horizontal ? 'maxWidth' : 'maxHeight';
  },

  /**
   * `max-width` or `max-height`.
   * @private
   */
  get _dimensionMaxCss() {
    return this.horizontal ? 'max-width' : 'max-height';
  },

  hostAttributes: {
    role: 'group',
    'aria-hidden': 'true',
  },

  listeners: {transitionend: '_onTransitionEnd'},

  /**
   * Toggle the opened state.
   *
   * @method toggle
   */
  toggle: function() {
    this.opened = !this.opened;
  },

  show: function() {
    this.opened = true;
  },

  hide: function() {
    this.opened = false;
  },

  /**
   * Updates the size of the element.
   * @param {string} size The new value for `maxWidth`/`maxHeight` as css property value, usually `auto` or `0px`.
   * @param {boolean=} animated if `true` updates the size with an animation, otherwise without.
   */
  updateSize: function(size, animated) {
    // Consider 'auto' as '', to take full size.
    size = size === 'auto' ? '' : size;

    var willAnimate = animated && !this.noAnimation && this.isAttached &&
        this._desiredSize !== size;

    this._desiredSize = size;

    this._updateTransition(false);
    // If we can animate, must do some prep work.
    if (willAnimate) {
      // Animation will start at the current size.
      var startSize = this._calcSize();
      // For `auto` we must calculate what is the final size for the animation.
      // After the transition is done, _transitionEnd will set the size back to
      // `auto`.
      if (size === '') {
        this.style[this._dimensionMax] = '';
        size = this._calcSize();
      }
      // Go to startSize without animation.
      this.style[this._dimensionMax] = startSize;
      // Force layout to ensure transition will go. Set scrollTop to itself
      // so that compilers won't remove it.
      this.scrollTop = this.scrollTop;
      // Enable animation.
      this._updateTransition(true);
      // If final size is the same as startSize it will not animate.
      willAnimate = (size !== startSize);
    }
    // Set the final size.
    this.style[this._dimensionMax] = size;
    // If it won't animate, call transitionEnd to set correct classes.
    if (!willAnimate) {
      this._transitionEnd();
    }
  },

  /**
   * enableTransition() is deprecated, but left over so it doesn't break
   * existing code. Please use `noAnimation` property instead.
   *
   * @method enableTransition
   * @deprecated since version 1.0.4
   */
  enableTransition: function(enabled) {
    Base._warn(
        '`enableTransition()` is deprecated, use `noAnimation` instead.');
    this.noAnimation = !enabled;
  },

  _updateTransition: function(enabled) {
    this.style.transitionDuration = (enabled && !this.noAnimation) ? '' : '0s';
  },

  _horizontalChanged: function() {
    this.style.transitionProperty = this._dimensionMaxCss;
    var otherDimension =
        this._dimensionMax === 'maxWidth' ? 'maxHeight' : 'maxWidth';
    this.style[otherDimension] = '';
    this.updateSize(this.opened ? 'auto' : '0px', false);
  },

  _openedChanged: function() {
    this.setAttribute('aria-hidden', !this.opened);

    this._setTransitioning(true);
    this.toggleClass('iron-collapse-closed', false);
    this.toggleClass('iron-collapse-opened', false);
    this.updateSize(this.opened ? 'auto' : '0px', true);

    // Focus the current collapse.
    if (this.opened) {
      this.focus();
    }
  },

  _transitionEnd: function() {
    this.style[this._dimensionMax] = this._desiredSize;
    this.toggleClass('iron-collapse-closed', !this.opened);
    this.toggleClass('iron-collapse-opened', this.opened);
    this._updateTransition(false);
    this.notifyResize();
    this._setTransitioning(false);
  },

  _onTransitionEnd: function(event) {
    if (dom(event).rootTarget === this) {
      this._transitionEnd();
    }
  },

  _calcSize: function() {
    return this.getBoundingClientRect()[this.dimension] + 'px';
  }
});

function getTemplate$1D() {
    return html `<!--_html_template_start_--><style>
  :host {
    --cr-toast-background: var(--cros-toast-background-color);
    --cr-toast-button-color: var(--cros-toast-button-color);
    --cr-toast-text-color: var(--cros-toast-text-color);
    --iron-icon-fill-color: var(--cros-toast-icon-color);
  }

  :host {
    align-items: center;
    background: var(--cr-toast-background);
    border-radius: 4px;
    bottom: 0;
    box-shadow: 0 2px 4px 0 rgba(0, 0, 0, 0.28);
    box-sizing: border-box;
    display: flex;
    margin: 24px;
    max-width: 568px;
    min-height: 52px;
    min-width: 288px;
    opacity: 0;
    padding: 0 24px;
    position: fixed;
    transform: translateY(100px);
    transition: opacity 300ms, transform 300ms;
    visibility: hidden;
    z-index: 1;
  }

  :host-context([chrome-refresh-2023]):host {
    border-radius: 8px;
    line-height: 20px;
    padding: 0 16px;
  }

  :host-context([dir=ltr]) {
    left: 0;
  }

  :host-context([dir=rtl]) {
    right: 0;
  }

  :host([open]) {
    opacity: 1;
    transform: translateY(0);
    visibility: visible;
  }

  /* Note: this doesn't work on slotted text nodes. Something like
   * <cr-toast>hey!</cr-toast> wont get the right text color. */
  :host ::slotted(*) {
    color: var(--cr-toast-text-color);
  }

  :host ::slotted(cr-button) {
    background-color: transparent !important;
    border: none !important;
    color: var(--cr-toast-button-color) !important;
    margin-inline-start: 32px !important;
    min-width: 52px !important;
    padding: 8px !important;
  }

  :host ::slotted(cr-button:hover) {
    background-color: transparent !important;
  }

  :host-context([chrome-refresh-2023]) ::slotted(cr-button:last-of-type) {
    margin-inline-end: -8px;
  }
</style>
<slot></slot>
<!--_html_template_end_-->`;
}

// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview A lightweight toast.
 *
 * Forked from ui/webui/resources/cr_elements/cr_toast/cr_toast.ts
 */
class CrToastElement extends PolymerElement {
    constructor() {
        super(...arguments);
        this.hideTimeoutId_ = null;
    }
    static get is() {
        return 'cr-toast';
    }
    static get template() {
        return getTemplate$1D();
    }
    static get properties() {
        return {
            duration: {
                type: Number,
                value: 0,
            },
            open: {
                readOnly: true,
                type: Boolean,
                value: false,
                reflectToAttribute: true,
            },
        };
    }
    static get observers() {
        return ['resetAutoHide_(duration, open)'];
    }
    /**
     * Cancels existing auto-hide, and sets up new auto-hide.
     */
    resetAutoHide_() {
        if (this.hideTimeoutId_ !== null) {
            window.clearTimeout(this.hideTimeoutId_);
            this.hideTimeoutId_ = null;
        }
        if (this.open && this.duration !== 0) {
            this.hideTimeoutId_ = window.setTimeout(() => {
                this.hide();
            }, this.duration);
        }
    }
    /**
     * Shows the toast and auto-hides after |this.duration| milliseconds has
     * passed. If the toast is currently being shown, any preexisting auto-hide
     * is cancelled and replaced with a new auto-hide.
     */
    show() {
        // Force autohide to reset if calling show on an already shown toast.
        const shouldResetAutohide = this.open;
        // The role attribute is removed first so that screen readers to better
        // ensure that screen readers will read out the content inside the toast.
        // If the role is not removed and re-added back in, certain screen readers
        // do not read out the contents, especially if the text remains exactly
        // the same as a previous toast.
        this.removeAttribute('role');
        // Reset the aria-hidden attribute as screen readers need to access the
        // contents of an opened toast.
        this.removeAttribute('aria-hidden');
        this._setOpen(true);
        this.setAttribute('role', 'alert');
        if (shouldResetAutohide) {
            this.resetAutoHide_();
        }
    }
    /**
     * Hides the toast and ensures that screen readers cannot its contents while
     * hidden.
     */
    hide() {
        this.setAttribute('aria-hidden', 'true');
        this._setOpen(false);
    }
}
customElements.define(CrToastElement.is, CrToastElement);

const styleMod$5 = document.createElement('dom-module');
styleMod$5.appendChild(html `
  <template>
    <style>
[is='action-link']{cursor:pointer;display:inline-block;text-decoration:underline}[is='action-link'],[is='action-link']:active,[is='action-link']:hover,[is='action-link']:visited{color:var(--cr-link-color)}[is='action-link'][disabled]{color:#757575;cursor:default;opacity:0.65;pointer-events:none}[is='action-link'].no-outline{outline:none}
    </style>
  </template>
`.content);
styleMod$5.register('action-link');

function getTemplate$1C() {
    return html `<!--_html_template_start_--><style include="cr-hidden-style"></style>
<cr-tooltip-icon id="tooltipIcon" hidden$="[[!indicatorVisible]]"
    tooltip-text="[[indicatorTooltip]]" icon-class="[[indicatorIcon]]"
    icon-aria-label="[[iconAriaLabel]]" exportparts="tooltip">
</cr-tooltip-icon>
<!--_html_template_end_-->`;
}

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Polymer element for indicating policies that apply to an
 * element controlling a settings preference.
 * Forked from
 * ui/webui/resources/cr_elements/policy/cr_policy_pref_indicator.ts
 */
const CrPolicyPrefIndicatorElementBase = CrPolicyIndicatorMixin(PolymerElement);
class CrPolicyPrefIndicatorElement extends CrPolicyPrefIndicatorElementBase {
    static get is() {
        return 'cr-policy-pref-indicator';
    }
    static get template() {
        return getTemplate$1C();
    }
    static get properties() {
        return {
            iconAriaLabel: String,
            indicatorType: {
                type: String,
                value: CrPolicyIndicatorType$1.NONE,
                computed: 'getIndicatorTypeForPref_(pref.*, associatedValue)',
            },
            indicatorTooltip: {
                type: String,
                computed: 'getIndicatorTooltipForPref_(indicatorType, pref.*)',
            },
            /**
             * Optional preference object associated with the indicator. Initialized
             * to null so that computed functions will get called if this is never
             * set.
             */
            pref: Object,
            /**
             * Optional value for the preference value this indicator is associated
             * with. If this is set, no indicator will be shown if it is a member
             * of |pref.userSelectableValues| and is not |pref.recommendedValue|.
             */
            associatedValue: Object,
        };
    }
    /**
     * @return The indicator type based on |pref| and |associatedValue|.
     */
    getIndicatorTypeForPref_() {
        assert$1(this.pref);
        const { enforcement, userSelectableValues, controlledBy, recommendedValue } = this.pref;
        if (enforcement === chrome.settingsPrivate.Enforcement.RECOMMENDED) {
            if (this.associatedValue !== undefined &&
                this.associatedValue !== recommendedValue) {
                return CrPolicyIndicatorType$1.NONE;
            }
            return CrPolicyIndicatorType$1.RECOMMENDED;
        }
        if (enforcement === chrome.settingsPrivate.Enforcement.ENFORCED) {
            // An enforced preference may also have some values still available for
            // the user to select from.
            if (userSelectableValues !== undefined) {
                if (recommendedValue && this.associatedValue === recommendedValue) {
                    return CrPolicyIndicatorType$1.RECOMMENDED;
                }
                else if (userSelectableValues.includes(this.associatedValue)) {
                    return CrPolicyIndicatorType$1.NONE;
                }
            }
            switch (controlledBy) {
                case chrome.settingsPrivate.ControlledBy.EXTENSION:
                    return CrPolicyIndicatorType$1.EXTENSION;
                case chrome.settingsPrivate.ControlledBy.PRIMARY_USER:
                    return CrPolicyIndicatorType$1.PRIMARY_USER;
                case chrome.settingsPrivate.ControlledBy.OWNER:
                    return CrPolicyIndicatorType$1.OWNER;
                case chrome.settingsPrivate.ControlledBy.USER_POLICY:
                    return CrPolicyIndicatorType$1.USER_POLICY;
                case chrome.settingsPrivate.ControlledBy.DEVICE_POLICY:
                    return CrPolicyIndicatorType$1.DEVICE_POLICY;
                case chrome.settingsPrivate.ControlledBy.PARENT:
                    return CrPolicyIndicatorType$1.PARENT;
                case chrome.settingsPrivate.ControlledBy.CHILD_RESTRICTION:
                    return CrPolicyIndicatorType$1.CHILD_RESTRICTION;
            }
        }
        if (enforcement === chrome.settingsPrivate.Enforcement.PARENT_SUPERVISED) {
            return CrPolicyIndicatorType$1.PARENT;
        }
        return CrPolicyIndicatorType$1.NONE;
    }
    /**
     * @return The tooltip text for |indicatorType|.
     */
    getIndicatorTooltipForPref_() {
        if (!this.pref) {
            return '';
        }
        const matches = this.pref && this.pref.value === this.pref.recommendedValue;
        return this.getIndicatorTooltip(this.indicatorType, this.pref.controlledByName || '', matches);
    }
    getFocusableElement() {
        return this.$.tooltipIcon.getFocusableElement();
    }
}
customElements.define(CrPolicyPrefIndicatorElement.is, CrPolicyPrefIndicatorElement);

/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/

/*
A set of layout classes that let you specify layout properties directly in
markup. You must include this file in every element that needs to use them.

Sample use:

    import '../iron-flex-layout/iron-flex-layout-classes.js';

    const template = html`
      <style is="custom-style" include="iron-flex iron-flex-alignment"></style>
      <style>
        .test { width: 100px; }
      </style>
      <div class="layout horizontal center-center">
        <div class="test">horizontal layout center alignment</div>
      </div>
    `;
    document.body.appendChild(template.content);

The following imports are available:
 - iron-flex
 - iron-flex-reverse
 - iron-flex-alignment
 - iron-flex-factors
 - iron-positioning
*/

const template$9 = html`
/* Most common used flex styles*/
<dom-module id="iron-flex">
  <template>
    <style>
      .layout.horizontal,
      .layout.vertical {
        display: flex;
      }

      .layout.inline {
        display: inline-flex;
      }

      .layout.horizontal {
        flex-direction: row;
      }

      .layout.vertical {
        flex-direction: column;
      }

      .layout.wrap {
        flex-wrap: wrap;
      }

      .layout.no-wrap {
        flex-wrap: nowrap;
      }

      .layout.center,
      .layout.center-center {
        align-items: center;
      }

      .layout.center-justified,
      .layout.center-center {
        justify-content: center;
      }

      .flex {
        flex: 1;
        flex-basis: 0.000000001px;
      }

      .flex-auto {
        flex: 1 1 auto;
      }

      .flex-none {
        flex: none;
      }
    </style>
  </template>
</dom-module>
/* Basic flexbox reverse styles */
<dom-module id="iron-flex-reverse">
  <template>
    <style>
      .layout.horizontal-reverse,
      .layout.vertical-reverse {
        display: flex;
      }

      .layout.horizontal-reverse {
        flex-direction: row-reverse;
      }

      .layout.vertical-reverse {
        flex-direction: column-reverse;
      }

      .layout.wrap-reverse {
        flex-wrap: wrap-reverse;
      }
    </style>
  </template>
</dom-module>
/* Flexbox alignment */
<dom-module id="iron-flex-alignment">
  <template>
    <style>
      /**
       * Alignment in cross axis.
       */
      .layout.start {
        align-items: flex-start;
      }

      .layout.center,
      .layout.center-center {
        align-items: center;
      }

      .layout.end {
        align-items: flex-end;
      }

      .layout.baseline {
        align-items: baseline;
      }

      /**
       * Alignment in main axis.
       */
      .layout.start-justified {
        justify-content: flex-start;
      }

      .layout.center-justified,
      .layout.center-center {
        justify-content: center;
      }

      .layout.end-justified {
        justify-content: flex-end;
      }

      .layout.around-justified {
        justify-content: space-around;
      }

      .layout.justified {
        justify-content: space-between;
      }

      /**
       * Self alignment.
       */
      .self-start {
        align-self: flex-start;
      }

      .self-center {
        align-self: center;
      }

      .self-end {
        align-self: flex-end;
      }

      .self-stretch {
        align-self: stretch;
      }

      .self-baseline {
        align-self: baseline;
      }

      /**
       * multi-line alignment in main axis.
       */
      .layout.start-aligned {
        align-content: flex-start;
      }

      .layout.end-aligned {
        align-content: flex-end;
      }

      .layout.center-aligned {
        align-content: center;
      }

      .layout.between-aligned {
        align-content: space-between;
      }

      .layout.around-aligned {
        align-content: space-around;
      }
    </style>
  </template>
</dom-module>
/* Non-flexbox positioning helper styles */
<dom-module id="iron-flex-factors">
  <template>
    <style>
      .flex,
      .flex-1 {
        flex: 1;
        flex-basis: 0.000000001px;
      }

      .flex-2 {
        flex: 2;
      }

      .flex-3 {
        flex: 3;
      }

      .flex-4 {
        flex: 4;
      }

      .flex-5 {
        flex: 5;
      }

      .flex-6 {
        flex: 6;
      }

      .flex-7 {
        flex: 7;
      }

      .flex-8 {
        flex: 8;
      }

      .flex-9 {
        flex: 9;
      }

      .flex-10 {
        flex: 10;
      }

      .flex-11 {
        flex: 11;
      }

      .flex-12 {
        flex: 12;
      }
    </style>
  </template>
</dom-module>
<dom-module id="iron-positioning">
  <template>
    <style>
      .block {
        display: block;
      }

      [hidden] {
        display: none !important;
      }

      .invisible {
        visibility: hidden !important;
      }

      .relative {
        position: relative;
      }

      .fit {
        position: absolute;
        top: 0;
        right: 0;
        bottom: 0;
        left: 0;
      }

      body.fullbleed {
        margin: 0;
        height: 100vh;
      }

      .scroll {
        -webkit-overflow-scrolling: touch;
        overflow: auto;
      }

      /* fixed position */
      .fixed-bottom,
      .fixed-left,
      .fixed-right,
      .fixed-top {
        position: fixed;
      }

      .fixed-top {
        top: 0;
        left: 0;
        right: 0;
      }

      .fixed-right {
        top: 0;
        right: 0;
        bottom: 0;
      }

      .fixed-bottom {
        right: 0;
        bottom: 0;
        left: 0;
      }

      .fixed-left {
        top: 0;
        bottom: 0;
        left: 0;
      }
    </style>
  </template>
</dom-module>
`;
template$9.setAttribute('style', 'display: none;');
document.head.appendChild(template$9.content);

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CrPolicyPrefMixin = dedupingMixin((superClass) => {
    class CrPolicyPrefMixin extends superClass {
        static get properties() {
            return {
                /**
                 * Showing that an extension is controlling a pref is sometimes done
                 * with a different UI (e.g. extension-controlled-indicator). In
                 * those cases, avoid showing an (extra) indicator here.
                 */
                noExtensionIndicator: Boolean,
                pref: Object,
            };
        }
        /**
         * Is the |pref| controlled by something that prevents user control of
         * the preference.
         * @return True if |this.pref| is controlled by an enforced policy.
         */
        isPrefEnforced() {
            return !!this.pref &&
                this.pref.enforcement ===
                    chrome.settingsPrivate.Enforcement.ENFORCED;
        }
        /**
         * @return True if |this.pref| has a recommended or enforced policy.
         */
        hasPrefPolicyIndicator() {
            if (!this.pref) {
                return false;
            }
            if (this.noExtensionIndicator &&
                this.pref.controlledBy ===
                    chrome.settingsPrivate.ControlledBy.EXTENSION) {
                return false;
            }
            return this.isPrefEnforced() ||
                this.pref.enforcement ===
                    chrome.settingsPrivate.Enforcement.RECOMMENDED;
        }
    }
    return CrPolicyPrefMixin;
});

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview PromiseResolver is a helper class that allows creating a
 * Promise that will be fulfilled (resolved or rejected) some time later.
 *
 * Example:
 *  const resolver = new PromiseResolver();
 *  resolver.promise.then(function(result) {
 *    console.log('resolved with', result);
 *  });
 *  ...
 *  ...
 *  resolver.resolve({hello: 'world'});
 */
class PromiseResolver {
    resolve_ = () => { };
    reject_ = () => { };
    isFulfilled_ = false;
    promise_;
    constructor() {
        this.promise_ = new Promise((resolve, reject) => {
            this.resolve_ = (resolution) => {
                resolve(resolution);
                this.isFulfilled_ = true;
            };
            this.reject_ = (reason) => {
                reject(reason);
                this.isFulfilled_ = true;
            };
        });
    }
    /** Whether this resolver has been resolved or rejected. */
    get isFulfilled() {
        return this.isFulfilled_;
    }
    get promise() {
        return this.promise_;
    }
    get resolve() {
        return this.resolve_;
    }
    get reject() {
        return this.reject_;
    }
}

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Global state for prefs initialization status.
 */
class CrSettingsPrefsInternal {
    isInitialized = false;
    deferInitialization;
    initializedResolver_ = new PromiseResolver();
    constructor() {
        /**
         * Whether to defer initialization. Used in testing to prevent premature
         * initialization when intending to fake the settings API.
         */
        this.deferInitialization = false;
    }
    get initialized() {
        return this.initializedResolver_.promise;
    }
    /** Resolves the |initialized| promise. */
    setInitialized() {
        this.isInitialized = true;
        this.initializedResolver_.resolve();
    }
    /** Restores state for testing. */
    resetForTesting() {
        this.isInitialized = false;
        this.initializedResolver_ = new PromiseResolver();
    }
}
const CrSettingsPrefs = new CrSettingsPrefsInternal();

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Tracks the initialization of a specified preference and logs an error if the
 * pref is not defined after prefs have been fetched.
 */
const PrefControlMixin = dedupingMixin((superClass) => {
    class PrefControlMixin extends superClass {
        static get properties() {
            return {
                /** The Preference object being tracked. */
                pref: {
                    type: Object,
                    notify: true,
                    observer: 'validatePref_',
                },
            };
        }
        connectedCallback() {
            super.connectedCallback();
            this.validatePref_();
        }
        /**
         * Logs an error once prefs are initialized if the tracked pref is not
         * found.
         */
        validatePref_() {
            CrSettingsPrefs.initialized.then(() => {
                if (this.pref === undefined) {
                    console.error(this.getErrorInfo('not found'));
                }
                else if (typeof this.pref === 'string') {
                    console.error(this.getErrorInfo('incorrect type string'));
                }
                else if (this.pref.enforcement ===
                    chrome.settingsPrivate.Enforcement.PARENT_SUPERVISED) {
                    console.error('PARENT_SUPERVISED is not enforced by pref controls');
                }
            });
        }
        /**
         * Produce an error message with additional information about the
         * element and host causing the error.
         */
        getErrorInfo(message) {
            let error = `Pref error [${message}] for element ${this.tagName}`;
            if (this.id) {
                error += `#${this.id}`;
            }
            error += ` in ${this.getRootNode().host.tagName}`;
            return error;
        }
    }
    return PrefControlMixin;
});

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * A behavior to help controls that handle a boolean preference, such as
 * checkbox and toggle button.
 */
// clang-format off
// clang-format on
const DEFAULT_UNCHECKED_VALUE = 0;
const DEFAULT_CHECKED_VALUE = 1;
const SettingsBooleanControlMixin = dedupingMixin((superClass) => {
    const superClassBase = CrPolicyPrefMixin(PrefControlMixin(superClass));
    class SettingsBooleanControlMixin extends superClassBase {
        static get properties() {
            return {
                /** Whether the control should represent the inverted value. */
                inverted: {
                    type: Boolean,
                    value: false,
                },
                /** Whether the control is checked. */
                checked: {
                    type: Boolean,
                    value: false,
                    notify: true,
                    reflectToAttribute: true,
                },
                /** Disabled property for the element. */
                disabled: {
                    type: Boolean,
                    value: false,
                    notify: true,
                    reflectToAttribute: true,
                },
                /**
                 * If true, do not automatically set the preference value. This
                 * allows the container to confirm the change first then call either
                 * sendPrefChange or resetToPrefValue accordingly.
                 */
                noSetPref: {
                    type: Boolean,
                    value: false,
                },
                /** The main label. */
                label: {
                    type: String,
                    value: '',
                },
                /** Additional (optional) sub-label. */
                subLabel: {
                    type: String,
                    value: '',
                },
                /**
                 * For numeric prefs only. The integer values equivalent to the
                 * initial unchecked state. During initialization, the control is
                 * unchecked if and only if the pref value is equal to one of the
                 * values in the array. When sendPrefChange() is called the *first*
                 * value in this array will be sent to the backend.
                 */
                numericUncheckedValues: {
                    type: Array,
                    value: () => [DEFAULT_UNCHECKED_VALUE],
                },
                /**
                 * For numeric prefs only, the integer value equivalent to the
                 * checked state. This is the value sent to prefs if the user
                 * checked the control.
                 */
                numericCheckedValue: {
                    type: Number,
                    value: DEFAULT_CHECKED_VALUE,
                },
            };
        }
        static get observers() {
            return ['prefValueChanged_(pref.value)'];
        }
        notifyChangedByUserInteraction() {
            this.dispatchEvent(new CustomEvent('settings-boolean-control-change', { bubbles: true, composed: true }));
            if (!this.pref || this.noSetPref) {
                return;
            }
            this.sendPrefChange();
        }
        /** Reset the checked state to match the current pref value. */
        resetToPrefValue() {
            // Pref can be undefined, and will lead to console errors if accessed.
            if (this.pref === undefined) {
                this.checked = false;
                return;
            }
            this.checked = this.getNewValue_(this.pref.value);
        }
        /** Update the pref to the current |checked| value. */
        sendPrefChange() {
            // Ensure that newValue is the correct type for the pref type, either
            // a boolean or a number.
            if (this.pref.type === chrome.settingsPrivate.PrefType.NUMBER) {
                assert$1(!this.inverted);
                assert$1(this.numericUncheckedValues.length > 0);
                this.set('pref.value', this.checked ? this.numericCheckedValue :
                    this.numericUncheckedValues[0]);
                return;
            }
            this.set('pref.value', this.inverted ? !this.checked : this.checked);
        }
        prefValueChanged_(prefValue) {
            this.checked = this.getNewValue_(prefValue);
        }
        /**
         * @return The value as a boolean, inverted if |inverted| is true.
         */
        getNewValue_(value) {
            // For numeric prefs, the control is only false if the value is
            // a member of `numericUncheckedValues` value.
            if (this.pref.type === chrome.settingsPrivate.PrefType.NUMBER) {
                assert$1(!this.inverted);
                return !this.numericUncheckedValues.includes(value);
            }
            return this.inverted ? !value : !!value;
        }
        controlDisabled() {
            return this.disabled || this.isPrefEnforced() ||
                !!(this.pref && this.pref.userControlDisabled);
        }
    }
    return SettingsBooleanControlMixin;
});

function getTemplate$1B() {
    return html `<!--_html_template_start_--><style include="cr-shared-style cr-actionable-row-style iron-flex action-link cros-color-overrides">:host{--cr-icon-button-margin-end:20px;padding:0 var(--cr-section-padding)}:host([elide-label]),:host([elide-label]) #outerRow,:host([elide-label]) #outerRow>div.flex{min-width:0}:host([elide-label]) .label{overflow:hidden;text-overflow:ellipsis;white-space:nowrap}#outerRow{align-items:center;display:flex;min-height:var(--cr-section-two-line-min-height);width:100%}#outerRow[noSubLabel]{min-height:var(--cr-section-min-height)}#icon{margin-inline-end:var(--cr-icon-button-margin-end)}#labelWrapper{padding:var(--cr-section-vertical-padding) 0}#labelWrapper,::slotted([slot='more-actions']){margin-inline-end:20px !important}cr-policy-pref-indicator{margin-inline-end:var(--cr-controlled-by-spacing)}a{color:var(--cr-link-color)}</style>
<div id="outerRow" noSubLabel$="[[!subLabel]]">
  <template is="dom-if" if="[[icon]]">
    <span id="icon" aria-hidden="true">
      <iron-icon slot="icon" icon="[[icon]]">
      </iron-icon>
    </span>
  </template>
  <div class="flex" id="labelWrapper" hidden$="[[!label]]">
    <div class="label" aria-hidden="[[!ariaShowLabel]]">[[label]]</div>
    <div class="cr-secondary-text label" id="sub-label">
      <template is="dom-if" if="[[subLabelIcon]]">
        <span id="sub-label-icon" aria-hidden="true">
          <iron-icon slot="icon" icon="[[subLabelIcon]]">
          </iron-icon>
        </span>
      </template>
      <span id="sub-label-text" aria-hidden="[[!ariaShowSublabel]]">
        [[subLabel]]
      </span>
      <template is="dom-if" if="[[learnMoreUrl]]">
        <a id="learn-more" href="[[learnMoreUrl]]" target="_blank"
            aria-labelledby$="[[getLearnMoreAriaLabelledBy_(learnMoreAriaLabel)]]"
            aria-description="$i18n{opensInNewTab}"
            on-click="onLearnMoreClick_">
          $i18n{learnMore}
        </a>
        <span id="learn-more-aria-label" aria-hidden="true" hidden>
          [[learnMoreAriaLabel]]
        </span>
      </template>
      <template is="dom-if" if="[[subLabelWithLink]]">
        <div id="sub-label-text-with-link"
            inner-h-t-m-l="[[getSubLabelWithLinkContent_(subLabelWithLink)]]"
            on-click="onSubLabelTextWithLinkClick_">
        </div>
      </template>
    </div>
  </div>
  <slot name="more-actions"></slot>
  <template is="dom-if" if="[[hasPrefPolicyIndicator(pref.*)]]">
    <cr-policy-pref-indicator pref="[[pref]]" icon-aria-label="[[label]]">
    </cr-policy-pref-indicator>
  </template>
  <cr-toggle id="control" checked="{{checked}}"
      on-change="onChange_"
      aria-label$="[[getAriaLabel_(label, ariaLabel)]]"
      aria-describedby="sub-label-text"
      disabled="[[controlDisabled(disabled, pref)]]">
  </cr-toggle>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * `settings-toggle-button` is a toggle that controls a supplied preference.
 */
const SettingsToggleButtonElementBase = SettingsBooleanControlMixin(PolymerElement);
class SettingsToggleButtonElement extends SettingsToggleButtonElementBase {
    static get is() {
        return 'settings-toggle-button';
    }
    static get template() {
        return getTemplate$1B();
    }
    static get properties() {
        return {
            ariaLabel: {
                type: String,
                reflectToAttribute: false, // Handled by #control.
                observer: 'onAriaLabelSet_',
                value: '',
            },
            ariaShowLabel: {
                type: Boolean,
                reflectToAttribute: true,
                value: false,
            },
            ariaShowSublabel: {
                type: Boolean,
                reflectToAttribute: true,
                value: false,
            },
            elideLabel: {
                type: Boolean,
                reflectToAttribute: true,
            },
            learnMoreUrl: {
                type: String,
                reflectToAttribute: true,
            },
            subLabelWithLink: {
                type: String,
                reflectToAttribute: true,
            },
            learnMoreAriaLabel: {
                type: String,
                value: '',
            },
            icon: String,
            subLabelIcon: String,
        };
    }
    static get observers() {
        return [
            'onDisableOrPrefChange_(disabled, pref.*)',
        ];
    }
    ready() {
        super.ready();
        this.addEventListener('click', this.onHostClick_);
    }
    fire_(eventName, detail) {
        this.dispatchEvent(new CustomEvent(eventName, { detail, bubbles: true, composed: true }));
    }
    focus() {
        this.$.control.focus();
    }
    /**
     * Removes the aria-label attribute if it's added by $i18n{...}.
     */
    onAriaLabelSet_() {
        if (this.hasAttribute('aria-label')) {
            const ariaLabel = this.ariaLabel;
            this.removeAttribute('aria-label');
            this.ariaLabel = ariaLabel;
        }
    }
    getAriaLabel_() {
        return this.ariaLabel || this.label;
    }
    getLearnMoreAriaLabelledBy_() {
        return this.learnMoreAriaLabel ? 'learn-more-aria-label' :
            'sub-label-text learn-more';
    }
    getBubbleAnchor() {
        const anchor = this.shadowRoot.querySelector('#control');
        assert$1(anchor);
        return anchor;
    }
    onDisableOrPrefChange_() {
        this.toggleAttribute('effectively-disabled_', this.controlDisabled());
    }
    /**
     * Handles non cr-toggle button clicks (cr-toggle handles its own click events
     * which don't bubble).
     */
    onHostClick_(e) {
        e.stopPropagation();
        if (this.controlDisabled()) {
            return;
        }
        this.checked = !this.checked;
        this.notifyChangedByUserInteraction();
        this.fire_('change');
    }
    onLearnMoreClick_(e) {
        e.stopPropagation();
        this.fire_('learn-more-clicked');
    }
    /**
     * Set up the contents of sub label with link.
     */
    getSubLabelWithLinkContent_(contents) {
        return sanitizeInnerHtml$1(contents, {
            attrs: [
                'id',
                'is',
                'aria-hidden',
                'aria-label',
                'aria-labelledby',
                'tabindex',
            ],
        });
    }
    onSubLabelTextWithLinkClick_(e) {
        const target = e.target;
        if (target.tagName === 'A') {
            this.fire_('sub-label-link-clicked', target.id);
            e.preventDefault();
            e.stopPropagation();
        }
    }
    onChange_(e) {
        this.checked = e.detail;
        this.notifyChangedByUserInteraction();
    }
}
customElements.define(SettingsToggleButtonElement.is, SettingsToggleButtonElement);

function getTemplate$1A() {
    return html `<!--_html_template_start_--><style>:host{--settings-card-bg-color:var(--cros-sys-app_base);--settings-card-border-radius:16px;display:flex;flex-direction:column;margin-bottom:16px;outline:none;position:relative}@media (prefers-color-scheme:dark){:host{--settings-card-bg-color:var(--cros-sys-surface1)}}#header{margin:0;padding:8px}#headerText{color:var(--cros-sys-primary);font:var(--cros-button-2-font);margin:0;outline:none;padding:0}#card{background-color:var(--settings-card-bg-color);border-radius:var(--settings-card-border-radius);flex:1;overflow:hidden}</style>
<template is="dom-if" if="[[headerText]]" restamp>
  <div id="header">
    <h2 id="headerText" tabindex="-1">
      [[headerText]]
    </h2>
  </div>
</template>
<div id="card">
  <slot></slot>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'settings-card' shows a paper material themed card with an optional
 * header.
 *
 * Example:
 *    <settings-card header-text="[[headerText]]">
 *      <!-- Insert card content here -->
 *    </settings-card>
 */
class SettingsCardElement extends PolymerElement {
    static get is() {
        return 'settings-card';
    }
    static get template() {
        return getTemplate$1A();
    }
    static get properties() {
        return {
            headerText: {
                type: String,
                value: '',
            },
        };
    }
}
customElements.define(SettingsCardElement.is, SettingsCardElement);

function getTemplate$1z() {
    return html `<!--_html_template_start_--><style include="cr-hidden-style">:host{--cr-slider-active-color:var(--google-blue-600);--cr-slider-container-color:rgba(var(--google-blue-600-rgb),.24);--cr-slider-container-disabled-color:rgba(var(--google-grey-600-rgb),.24);--cr-slider-disabled-color:var(--google-grey-600);--cr-slider-knob-color-rgb:var(--google-blue-600-rgb);--cr-slider-knob-disabled-color:white;--cr-slider-marker-active-color:rgba(255,255,255,.54);--cr-slider-marker-color:rgba(26,115,232,.54);--cr-slider-marker-disabled-color:rgba(128,134,139,.54);--cr-slider-position-transition:80ms ease;--cr-slider-ripple-color:rgba(var(--cr-slider-knob-color-rgb),.25);-webkit-tap-highlight-color:rgba(0,0,0,0);cursor:default;height:32px;isolation:isolate;outline:none;padding:0 16px;user-select:none}@media (prefers-color-scheme:dark){:host{--cr-slider-active-color:var(--google-blue-300);--cr-slider-container-color:rgba(var(--google-blue-500-rgb),.48);--cr-slider-container-disabled-color:rgba(var(--google-grey-600-rgb),.48);--cr-slider-knob-color-rgb:var(--google-blue-300-rgb);--cr-slider-knob-disabled-color:var(--google-grey-900-white-4-percent);--cr-slider-marker-active-color:var(--google-blue-300);--cr-slider-marker-color:var(--google-blue-300);--cr-slider-marker-disabled-color:rgba(255,255,255,.54);--cr-slider-ripple-color:rgba(var(--cr-slider-knob-color-rgb),.4)}}:host,:host>#container{touch-action:none}#container,#bar{border-top-style:solid;border-top-width:2px}#container{border-top-color:var(--cr-slider-container-color);position:relative;top:16px}#container>div{position:absolute}#markers,#bar{top:-2px}#markers{display:flex;flex-direction:row;left:0;pointer-events:none;right:0}.active-marker,.inactive-marker{flex:1}#markers::before,#markers::after,.active-marker::after,.inactive-marker::after{border-radius:50%;content:'';display:block;height:2px;margin-inline-start:-1px;width:2px}#markers::before,.active-marker::after{background-color:var(--cr-slider-marker-active-color)}#markers::after,.inactive-marker::after{background-color:var(--cr-slider-marker-color)}#bar{border-top-color:var(--cr-slider-active-color)}:host([transiting_]) #bar{transition:width var(--cr-slider-position-transition)}#knobAndLabel{top:-1px}:host([transiting_]) #knobAndLabel{transition:margin-inline-start var(--cr-slider-position-transition)}#knob{background-color:rgb(var(--cr-slider-knob-color-rgb));border-radius:50%;box-shadow:0 1px 3px 0 rgba(0,0,0,.4);height:10px;outline:none;position:relative;transform:translate(-50%,-50%);width:10px}:host([is-rtl_]) #knob{transform:translate(50%,-50%)}#label{background:rgb(var(--cr-slider-knob-color-rgb));border-radius:.75em;bottom:22px;color:white;font-size:12px;line-height:1.5em;opacity:0;outline:1px transparent solid;padding:0 .67em;position:absolute;transform:translateX(-50%);transition:opacity 80ms ease-in-out;white-space:nowrap}:host([is-rtl_]) #label{transform:translateX(50%)}:host(:hover) #label,:host([show-label_]) #label{opacity:1}paper-ripple{--paper-ripple-opacity:var(--cr-slider-ripple-opacity,1);color:var(--cr-slider-ripple-color);height:var(--cr-slider-ripple-size,32px);pointer-events:none;transition:color linear 80ms;transform:translate(-50%,-50%);top:50%;left:50%;width:var(--cr-slider-ripple-size,32px);z-index:var(--cr-slider-ripple-z-index,auto)}:host([disabled_]){pointer-events:none}:host([disabled_]) #container{border-top-color:var(--cr-slider-container-disabled-color)}:host([disabled_]) #bar{border-top-color:var(--cr-slider-disabled-color)}:host([disabled_]) .inactive-marker::after,:host([disabled_]) #markers::after{background-color:var(--cr-slider-marker-disabled-color)}:host([disabled_]) #knob{background-color:var(--cr-slider-disabled-color);border:2px solid var(--cr-slider-knob-disabled-color);box-shadow:unset}</style>
<div id="container" hidden part="container">
  <div id="bar"></div>
  <div id="markers" hidden$="[[!markerCount]]">
    <template is="dom-repeat" items="[[getMarkers_(markerCount)]]">
      <div class$="[[getMarkerClass_(index, value, min, max,
                                     markerCount)]]"></div>
    </template>
  </div>
  <div id="knobAndLabel" on-transitionend="onTransitionEnd_">
    <div id="knob" part="knob"></div>
    <div id="label" part="label">[[label_]]</div>
  </div>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'cr-slider' is a slider component used to select a number from
 * a continuous or discrete range of numbers.
 *
 * Forked from ui/webui/resources/cr_elements/cr_slider/cr_slider.ts
 */
function clamp(min, max, value) {
    return Math.min(max, Math.max(min, value));
}
function getAriaValue(tick) {
    if (Number.isFinite(tick)) {
        return tick;
    }
    const sliderTick = tick;
    return sliderTick.ariaValue !== undefined ? sliderTick.ariaValue :
        sliderTick.value;
}
const CrSliderElementBase = PaperRippleMixin(PolymerElement);
class CrSliderElement extends CrSliderElementBase {
    constructor() {
        super(...arguments);
        this.deltaKeyMap_ = null;
        this.draggingEventTracker_ = null;
    }
    static get is() {
        return 'cr-slider';
    }
    static get template() {
        return getTemplate$1z();
    }
    static get properties() {
        return {
            disabled: {
                type: Boolean,
                value: false,
            },
            /**
             * Internal representation of disabled depending on |disabled| and
             * |ticks|.
             */
            disabled_: {
                type: Boolean,
                computed: 'computeDisabled_(disabled, ticks.*)',
                reflectToAttribute: true,
                observer: 'onDisabledChanged_',
            },
            dragging: {
                type: Boolean,
                value: false,
                notify: true,
            },
            updatingFromKey: {
                type: Boolean,
                value: false,
                notify: true,
            },
            /**
             * The amount the slider value increments by when pressing any of the keys
             * from `deltaKeyMap_`. Defaults to 1.
             */
            keyPressSliderIncrement: {
                type: Number,
                value: 1,
            },
            markerCount: {
                type: Number,
                value: 0,
            },
            max: {
                type: Number,
                value: 100,
            },
            min: {
                type: Number,
                value: 0,
            },
            /**
             * When set to false, the keybindings are not handled by this component,
             * for example when the owner of the component wants to set up its own
             * keybindings.
             */
            noKeybindings: {
                type: Boolean,
                value: false,
            },
            snaps: {
                type: Boolean,
                value: false,
            },
            /**
             * The data associated with each tick on the slider. Each element in the
             * array contains a value and the label corresponding to that value.
             */
            ticks: {
                type: Array,
                value: () => [],
            },
            value: Number,
            label_: {
                type: String,
                value: '',
            },
            showLabel_: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
            },
            isRtl_: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
            },
            /**
             * |transiting_| is set to true when bar is touched or clicked. This
             * triggers a single position transition effect to take place for the
             * knob, bar and label. When the transition is complete, |transiting_| is
             * set to false resulting in no transition effect during dragging, manual
             * value updates and keyboard events.
             */
            transiting_: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
            },
        };
    }
    static get observers() {
        return [
            'onTicksChanged_(ticks.*)',
            'updateUi_(ticks.*, value, min, max)',
            'onValueMinMaxChange_(value, min, max)',
            'buildDeltaKeyMap_(isRtl_, keyPressSliderIncrement)',
        ];
    }
    ready() {
        super.ready();
        this.setAttribute('role', 'slider');
        this.addEventListener('blur', this.hideRipple_);
        this.addEventListener('focus', this.showRipple_);
        this.addEventListener('keydown', this.onKeyDown_);
        this.addEventListener('keyup', this.onKeyUp_);
        this.addEventListener('pointerdown', this.onPointerDown_.bind(this));
    }
    connectedCallback() {
        super.connectedCallback();
        this.isRtl_ = window.getComputedStyle(this)['direction'] === 'rtl';
        this.draggingEventTracker_ = new EventTracker();
    }
    fire_(eventName, detail) {
        this.dispatchEvent(new CustomEvent(eventName, { bubbles: true, composed: true, detail }));
    }
    computeDisabled_() {
        return this.disabled || this.ticks.length === 1;
    }
    /**
     * When markers are displayed on the slider, they are evenly spaced across
     * the entire slider bar container and are rendered on top of the bar and
     * bar container. The location of the marks correspond to the discrete
     * values that the slider can have.
     * @return The array items have no type since this is used to
     *     create |markerCount| number of markers.
     */
    getMarkers_() {
        return new Array(Math.max(0, this.markerCount - 1));
    }
    getMarkerClass_(index) {
        const currentStep = (this.markerCount - 1) * this.getRatio();
        return index < currentStep ? 'active-marker' : 'inactive-marker';
    }
    /**
     * The ratio is a value from 0 to 1.0 corresponding to a location along the
     * slider bar where 0 is the minimum value and 1.0 is the maximum value.
     * This is a helper function used to calculate the bar width, knob location
     * and label location.
     */
    getRatio() {
        return (this.value - this.min) / (this.max - this.min);
    }
    /**
     * Removes all event listeners related to dragging, and cancels ripple.
     */
    stopDragging_(pointerId) {
        this.draggingEventTracker_.removeAll();
        this.releasePointerCapture(pointerId);
        this.dragging = false;
        this.hideRipple_();
    }
    hideRipple_() {
        if (this.noink) {
            return;
        }
        this.getRipple().clear();
        this.showLabel_ = false;
    }
    showRipple_() {
        if (this.noink) {
            return;
        }
        if (!this.getRipple().holdDown) {
            this.getRipple().showAndHoldDown();
        }
        this.showLabel_ = true;
    }
    onDisabledChanged_() {
        this.setAttribute('tabindex', this.disabled_ ? '-1' : '0');
        this.blur();
    }
    onKeyDown_(event) {
        if (this.disabled_ || this.noKeybindings) {
            return;
        }
        if (event.metaKey || event.shiftKey || event.altKey || event.ctrlKey) {
            return;
        }
        let newValue;
        if (event.key === 'Home') {
            newValue = this.min;
        }
        else if (event.key === 'End') {
            newValue = this.max;
        }
        else if (this.deltaKeyMap_.has(event.key)) {
            newValue = this.value + this.deltaKeyMap_.get(event.key);
        }
        if (newValue === undefined) {
            return;
        }
        this.updatingFromKey = true;
        if (this.updateValue_(newValue)) {
            this.fire_('cr-slider-value-changed');
        }
        event.preventDefault();
        event.stopPropagation();
        this.showRipple_();
    }
    onKeyUp_(event) {
        if (event.key === 'Home' || event.key === 'End' ||
            this.deltaKeyMap_.has(event.key)) {
            setTimeout(() => {
                this.updatingFromKey = false;
            });
        }
    }
    /**
     * When the left-mouse button is pressed, the knob location is updated and
     * dragging starts.
     */
    onPointerDown_(event) {
        if (this.disabled_ ||
            event.buttons !== 1 && event.pointerType === 'mouse') {
            return;
        }
        this.dragging = true;
        this.transiting_ = true;
        this.updateValueFromClientX_(event.clientX);
        this.showRipple_();
        this.setPointerCapture(event.pointerId);
        const stopDragging = this.stopDragging_.bind(this, event.pointerId);
        assert$1(!!this.draggingEventTracker_);
        this.draggingEventTracker_.add(this, 'pointermove', (e) => {
            // Prevent unwanted text selection to occur while moving the pointer,
            // this is important.
            e.preventDefault();
            // If the left-button on the mouse is pressed by itself, then update.
            // Otherwise stop capturing the mouse events because the drag operation
            // is complete.
            if (e.buttons !== 1 && e.pointerType === 'mouse') {
                stopDragging();
                return;
            }
            this.updateValueFromClientX_(e.clientX);
        });
        this.draggingEventTracker_.add(this, 'pointercancel', stopDragging);
        this.draggingEventTracker_.add(this, 'pointerdown', stopDragging);
        this.draggingEventTracker_.add(this, 'pointerup', stopDragging);
        this.draggingEventTracker_.add(this, 'keydown', (e) => {
            if (e.key === 'Escape' || e.key === 'Tab' || e.key === 'Home' ||
                e.key === 'End' || this.deltaKeyMap_.has(e.key)) {
                stopDragging();
            }
        });
    }
    onTicksChanged_() {
        if (this.ticks.length > 1) {
            this.snaps = true;
            this.max = this.ticks.length - 1;
            this.min = 0;
        }
        if (this.value !== undefined) {
            this.updateValue_(this.value);
        }
    }
    onTransitionEnd_() {
        this.transiting_ = false;
    }
    onValueMinMaxChange_() {
        this.debouncer_ = Debouncer.debounce(this.debouncer_, microTask, () => {
            if (this.value === undefined || this.min === undefined ||
                this.max === undefined) {
                return;
            }
            this.updateValue_(this.value);
        });
    }
    updateUi_() {
        const percent = `${this.getRatio() * 100}%`;
        this.$.bar.style.width = percent;
        this.$.knobAndLabel.style.marginInlineStart = percent;
        const ticks = this.ticks;
        const value = this.value;
        if (ticks && ticks.length > 0 && Number.isInteger(value) && value >= 0 &&
            value < ticks.length) {
            const tick = ticks[this.value];
            this.label_ = Number.isFinite(tick) ? '' : tick.label;
            const ariaValueNow = getAriaValue(tick);
            this.setAttribute('aria-valuetext', String(this.label_ || ariaValueNow));
            this.setAttribute('aria-valuenow', ariaValueNow.toString());
            this.setAttribute('aria-valuemin', getAriaValue(ticks[0]).toString());
            this.setAttribute('aria-valuemax', getAriaValue(ticks.slice(-1)[0]).toString());
        }
        else {
            this.setAttribute('aria-valuetext', value !== undefined ? value.toString() : '');
            this.setAttribute('aria-valuenow', value !== undefined ? value.toString() : '');
            this.setAttribute('aria-valuemin', this.min.toString());
            this.setAttribute('aria-valuemax', this.max.toString());
        }
    }
    updateValue_(value) {
        this.$.container.hidden = false;
        if (this.snaps) {
            // Skip update if |value| has not passed the next value .8 units away.
            // The value will update as the drag approaches the next value.
            if (Math.abs(this.value - value) < .8) {
                return false;
            }
            value = Math.round(value);
        }
        value = clamp(this.min, this.max, value);
        if (this.value === value) {
            return false;
        }
        this.value = value;
        return true;
    }
    updateValueFromClientX_(clientX) {
        const rect = this.$.container.getBoundingClientRect();
        let ratio = (clientX - rect.left) / rect.width;
        if (this.isRtl_) {
            ratio = 1 - ratio;
        }
        if (this.updateValue_(ratio * (this.max - this.min) + this.min)) {
            this.fire_('cr-slider-value-changed');
        }
    }
    buildDeltaKeyMap_() {
        const increment = this.keyPressSliderIncrement;
        const decrement = -this.keyPressSliderIncrement;
        this.deltaKeyMap_ = new Map([
            ['ArrowDown', decrement],
            ['ArrowUp', increment],
            ['PageDown', decrement],
            ['PageUp', increment],
            ['ArrowLeft', this.isRtl_ ? increment : decrement],
            ['ArrowRight', this.isRtl_ ? decrement : increment],
        ]);
    }
    // Overridden from PaperRippleMixin
    /* eslint-disable-next-line @typescript-eslint/naming-convention */
    _createRipple() {
        this._rippleContainer = this.$.knob;
        const ripple = super._createRipple();
        ripple.id = 'ink';
        ripple.setAttribute('recenters', '');
        ripple.classList.add('circle');
        return ripple;
    }
}
customElements.define(CrSliderElement.is, CrSliderElement);

const styleMod$4 = document.createElement('dom-module');
styleMod$4.appendChild(html `
  <template>
    <style>
:host{--cr-radio-button-checked-color:var(--google-blue-600);--cr-radio-button-checked-ripple-color:rgba(var(--google-blue-600-rgb),.2);--cr-radio-button-ink-size:40px;--cr-radio-button-size:16px;--cr-radio-button-unchecked-color:var(--google-grey-700);--cr-radio-button-unchecked-ripple-color:rgba(var(--google-grey-600-rgb),.15);--ink-to-circle:calc((var(--cr-radio-button-ink-size) - var(--cr-radio-button-size)) / 2);align-items:center;display:flex;flex-shrink:0;gap:var(--cr-radio-button-label-spacing,20px);outline:none}@media (prefers-color-scheme:dark){:host{--cr-radio-button-checked-color:var(--google-blue-300);--cr-radio-button-checked-ripple-color:rgba(var(--google-blue-300-rgb),.4);--cr-radio-button-unchecked-color:var(--google-grey-500);--cr-radio-button-unchecked-ripple-color:rgba(var(--google-grey-300-rgb),.4)}}:host-context([chrome-refresh-2023]):host{--cr-radio-button-ink-size:32px;--cr-radio-button-checked-color:var(--color-radio-button-foreground-checked,var(--cr-fallback-color-primary));--cr-radio-button-checked-ripple-color:var(--cr-active-background-color);--cr-radio-button-unchecked-color:var(--color-radio-button-foreground-unchecked,var(--cr-fallback-color-outline));--cr-radio-button-unchecked-ripple-color:var(--cr-active-background-color)}@media (forced-colors:active){:host{--cr-radio-button-checked-color:SelectedItem}}:host([disabled]){opacity:var(--cr-disabled-opacity);pointer-events:none}:host-context([chrome-refresh-2023]):host([disabled]){opacity:1;--cr-radio-button-checked-color:var(--color-radio-foreground-disabled,var(--cr-fallback-color-disabled-background));--cr-radio-button-unchecked-color:var(--color-radio-foreground-disabled,var(--cr-fallback-color-disabled-background))}:host(:not([disabled])){cursor:pointer}:host(.label-first){flex-direction:row-reverse}#labelWrapper{flex:1}:host-context([chrome-refresh-2023]):host([disabled]) #labelWrapper{opacity:var(--cr-disabled-opacity)}#label{color:inherit}:host([hide-label-text]) #label{clip:rect(0,0,0,0);display:block;position:fixed}.disc-border,.disc,.disc-wrapper,paper-ripple{border-radius:50%}.disc-wrapper{height:var(--cr-radio-button-size);margin-block-start:var(--cr-radio-button-disc-margin-block-start,0);position:relative;width:var(--cr-radio-button-size)}.disc-border,.disc{box-sizing:border-box;height:var(--cr-radio-button-size);width:var(--cr-radio-button-size)}.disc-border{border:2px solid var(--cr-radio-button-unchecked-color)}:host([checked]) .disc-border{border-color:var(--cr-radio-button-checked-color)}#button:focus{outline:none}.disc{background-color:transparent;position:absolute;top:0;transform:scale(0);transition:border-color 200ms,transform 200ms}:host([checked]) .disc{background-color:var(--cr-radio-button-checked-color);transform:scale(0.5)}:host-context([chrome-refresh-2023]) #overlay{border-radius:50%;box-sizing:border-box;display:none;height:var(--cr-radio-button-ink-size);left:50%;pointer-events:none;position:absolute;top:50%;transform:translate(-50%,-50%);width:var(--cr-radio-button-ink-size)}:host-context([chrome-refresh-2023]) #button:hover #overlay{background-color:var(--cr-hover-background-color);display:block}:host-context([chrome-refresh-2023]) #button:focus-visible #overlay{border:2px solid var(--cr-focus-outline-color);display:block}paper-ripple{--paper-ripple-opacity:1;color:var(--cr-radio-button-unchecked-ripple-color);height:var(--cr-radio-button-ink-size);left:calc(-1 * var(--ink-to-circle));pointer-events:none;position:absolute;top:calc(-1 * var(--ink-to-circle));transition:color linear 80ms;width:var(--cr-radio-button-ink-size)}:host-context([dir=rtl]) paper-ripple{left:auto;right:calc(-1 * var(--ink-to-circle))}:host([checked]) paper-ripple{color:var(--cr-radio-button-checked-ripple-color)}
    </style>
  </template>
`.content);
styleMod$4.register('cr-radio-button-style');

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CrRadioButtonMixin = dedupingMixin((superClass) => {
    class CrRadioButtonMixin extends superClass {
        static get properties() {
            return {
                checked: {
                    type: Boolean,
                    value: false,
                    reflectToAttribute: true,
                },
                disabled: {
                    type: Boolean,
                    value: false,
                    reflectToAttribute: true,
                    notify: true,
                },
                /**
                 * Whether the radio button should be focusable or not. Toggling
                 * this property sets the corresponding tabindex of the button
                 * itself as well as any links in the button description.
                 */
                focusable: {
                    type: Boolean,
                    value: false,
                    observer: 'onFocusableChanged_',
                },
                hideLabelText: {
                    type: Boolean,
                    value: false,
                    reflectToAttribute: true,
                },
                label: {
                    type: String,
                    value: '', // Allows hidden$= binding to run without being set.
                },
                name: {
                    type: String,
                    notify: true,
                    reflectToAttribute: true,
                },
                /**
                 * Holds the tabIndex for the radio button.
                 */
                buttonTabIndex_: {
                    type: Number,
                    computed: 'getTabIndex_(focusable)',
                },
            };
        }
        connectedCallback() {
            super.connectedCallback();
            this.addEventListener('blur', this.hideRipple_.bind(this));
            if (!document.documentElement.hasAttribute('chrome-refresh-2023')) {
                this.addEventListener('focus', this.onFocus_.bind(this));
            }
            this.addEventListener('up', this.hideRipple_.bind(this));
        }
        focus() {
            const button = this.shadowRoot.querySelector('#button');
            assert$1(button);
            button.focus();
        }
        getPaperRipple() {
            assertNotReached$1();
        }
        onFocus_() {
            this.getPaperRipple().showAndHoldDown();
        }
        hideRipple_() {
            this.getPaperRipple().clear();
        }
        onFocusableChanged_() {
            const links = this.querySelectorAll('a');
            links.forEach((link) => {
                // Remove the tab stop on any links when the row is unchecked.
                // Since the row is not tabbable, any links within the row
                // should not be either.
                link.tabIndex = this.checked ? 0 : -1;
            });
        }
        getAriaChecked_() {
            return this.checked ? 'true' : 'false';
        }
        getAriaDisabled_() {
            return this.disabled ? 'true' : 'false';
        }
        getTabIndex_() {
            return this.focusable ? 0 : -1;
        }
        /**
         * When shift-tab is pressed, first bring the focus to the host
         * element. This accomplishes 2 things:
         * 1) Host doesn't get focused when the browser moves the focus
         *    backward.
         * 2) focus now escaped the shadow-dom of this element, so that
         *    it'll correctly obey non-zero tabindex ordering of the
         *    containing document.
         */
        onInputKeydown_(e) {
            if (e.shiftKey && e.key === 'Tab') {
                this.focus();
            }
        }
    }
    return CrRadioButtonMixin;
});

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/** @fileoverview Utility functions to help use prefs in Polymer controls. */
/**
 * Converts a string value to a type corresponding to the given preference.
 */
function stringToPrefValue(value, pref) {
    switch (pref.type) {
        case chrome.settingsPrivate.PrefType.BOOLEAN:
            return value === 'true';
        case chrome.settingsPrivate.PrefType.NUMBER:
            const n = parseFloat(value);
            if (isNaN(n)) {
                console.error('Argument to stringToPrefValue for number pref ' +
                    'was unparsable: ' + value);
                return undefined;
            }
            return n;
        case chrome.settingsPrivate.PrefType.STRING:
        case chrome.settingsPrivate.PrefType.URL:
            return value;
        default:
            assertNotReached$1('No conversion from string to ' + pref.type + ' pref');
    }
}
/**
 * Returns the value of the pref as a string.
 */
function prefToString(pref) {
    switch (pref.type) {
        case chrome.settingsPrivate.PrefType.BOOLEAN:
        case chrome.settingsPrivate.PrefType.NUMBER:
            return pref.value.toString();
        case chrome.settingsPrivate.PrefType.STRING:
        case chrome.settingsPrivate.PrefType.URL:
            return pref.value;
        default:
            assertNotReached$1('No conversion from ' + pref.type + ' pref to string');
    }
}

function getTemplate$1y() {
    return html `<!--_html_template_start_--><style include="cr-radio-button-style cros-color-overrides">:host([disabled]){opacity:1}:host([disabled]) .disc-wrapper,:host([disabled]) #labelWrapper{opacity:var(--cr-disabled-opacity)}cr-policy-pref-indicator{margin-inline-start:var(--cr-controlled-by-spacing);pointer-events:all}</style>

<div
    aria-checked$="[[getAriaChecked_(checked)]]"
    aria-describedby="slotted-content"
    aria-disabled$="[[getAriaDisabled_(disabled)]]"
    aria-labelledby="label"
    class="disc-wrapper"
    id="button"
    role="radio"
    tabindex$="[[buttonTabIndex_]]"
    on-keydown="onInputKeydown_">
  <div class="disc-border"></div>
  <div class="disc"></div>
  <div id="overlay"></div>
</div>

<div id="labelWrapper" part="labelWrapper">
  <span id="label" hidden$="[[!label]]">[[label]]</span>
  <span id="slotted-content">
    <slot></slot>
  </span>
</div>

<template is="dom-if" if="[[showIndicator_(disabled, name, pref.*)]]">
  <cr-policy-pref-indicator pref="[[pref]]" on-click="onIndicatorClick_"
      icon-aria-label="[[label]]">
  </cr-policy-pref-indicator>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const ControlledRadioButtonElementBase = PaperRippleMixin(CrRadioButtonMixin(PrefControlMixin(PolymerElement)));
class ControlledRadioButtonElement extends ControlledRadioButtonElementBase {
    static get is() {
        return 'controlled-radio-button';
    }
    static get template() {
        return getTemplate$1y();
    }
    static get observers() {
        return [
            'updateDisabled_(pref.enforcement)',
        ];
    }
    // Overridden from CrRadioButtonMixin
    getPaperRipple() {
        return this.getRipple();
    }
    // Overridden from PaperRippleMixin
    /* eslint-disable-next-line @typescript-eslint/naming-convention */
    _createRipple() {
        this._rippleContainer = this.shadowRoot.querySelector('.disc-wrapper');
        const ripple = super._createRipple();
        ripple.id = 'ink';
        ripple.setAttribute('recenters', '');
        ripple.classList.add('circle');
        return ripple;
    }
    updateDisabled_() {
        this.disabled =
            this.pref.enforcement === chrome.settingsPrivate.Enforcement.ENFORCED;
    }
    showIndicator_() {
        if (!this.disabled) {
            return false;
        }
        assert$1(this.pref);
        return this.name === prefToString(this.pref);
    }
    onIndicatorClick_(e) {
        // Disallow <controlled-radio-button on-click="..."> when disabled.
        e.preventDefault();
        e.stopPropagation();
    }
}
customElements.define(ControlledRadioButtonElement.is, ControlledRadioButtonElement);

function getTemplate$1x() {
    return html `<!--_html_template_start_--><style include="md-select cros-color-overrides">:host{align-items:center;display:inline-flex}cr-policy-pref-indicator{height:var(--iron-icon-width,24px);margin:0 var(--cr-controlled-by-spacing);order:var(--settings-dropdown-menu-policy-order,0);width:var(--iron-icon-width,24px)}option:disabled{display:none}</style>
<template is="dom-if" if="[[pref.controlledBy]]" restamp>
  <cr-policy-pref-indicator pref="[[pref]]"></cr-policy-pref-indicator>
</template>
<select class="md-select" id="dropdownMenu" on-change="onChange_"
    aria-label$="[[label]]"
    disabled="[[shouldDisableMenu_(disabled, menuOptions.*, pref.*)]]">
  <template is="dom-repeat" items="[[menuOptions]]">
    <option value="[[item.value]]" hidden="[[item.hidden]]">
      [[item.name]]
    </option>
  </template>
  <option value="[[notFoundValue]]"
      disabled="[[!showNotFoundValue_(menuOptions, pref.value)]]"
      aria-hidden="[[!showNotFoundValue_(menuOptions, pref.value)]]">
    $i18n{custom}
  </option>
</select>
<!--_html_template_end_-->`;
}

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * 'settings-dropdown-menu' is a control for displaying options
 * in the settings.
 *
 * Example:
 *
 *   <settings-dropdown-menu pref="{{prefs.foo}}">
 *   </settings-dropdown-menu>
 */
const SettingsDropdownMenuElementBase = CrPolicyPrefMixin(PrefControlMixin(PolymerElement));
class SettingsDropdownMenuElement extends SettingsDropdownMenuElementBase {
    static get is() {
        return 'settings-dropdown-menu';
    }
    static get template() {
        return getTemplate$1x();
    }
    static get properties() {
        return {
            /**
             * List of options for the drop-down menu.
             */
            menuOptions: Array,
            /** Whether the dropdown menu should be disabled. */
            disabled: {
                type: Boolean,
                reflectToAttribute: true,
                value: false,
            },
            /**
               If this is a dictionary pref, this is the key for the item
                we are interested in.
             */
            prefKey: {
                type: String,
                value: null,
            },
            /**
             * The value of the "custom" item.
             */
            notFoundValue: {
                type: String,
                value: 'SETTINGS_DROPDOWN_NOT_FOUND_ITEM',
                readOnly: true,
            },
            /** Label for a11y purposes */
            label: String,
        };
    }
    static get observers() {
        return [
            'updateSelected_(menuOptions, pref.value.*, prefKey)',
        ];
    }
    focus() {
        this.$.dropdownMenu.focus();
    }
    /**
     * Pass the selection change to the pref value.
     */
    onChange_() {
        const selected = this.$.dropdownMenu.value;
        if (selected === this.notFoundValue) {
            return;
        }
        assert$1(this.pref);
        if (this.prefKey) {
            this.set(`pref.value.${this.prefKey}`, selected);
        }
        else {
            const prefValue = stringToPrefValue(selected, this.pref);
            if (prefValue !== undefined) {
                this.set('pref.value', prefValue);
            }
        }
        // settings-control-change only fires when the selection is changed to
        // a valid property.
        this.dispatchEvent(new CustomEvent('settings-control-change', { bubbles: true, composed: true }));
    }
    /**
     * Updates the selected item when the pref or menuOptions change.
     */
    updateSelected_() {
        if (this.menuOptions === undefined || this.pref === undefined ||
            this.prefKey === undefined) {
            return;
        }
        if (!this.menuOptions.length) {
            return;
        }
        const prefValue = this.prefStringValue_();
        const option = this.menuOptions.find(menuItem => {
            return menuItem.value.toString() === prefValue;
        });
        // Wait for the dom-repeat to populate the <select> before setting
        // <select>#value so the correct option gets selected.
        microTask.run(() => {
            this.$.dropdownMenu.value =
                option === undefined ? this.notFoundValue : prefValue;
        });
    }
    /**
     * Gets the current value of the preference as a string.
     */
    prefStringValue_() {
        if (this.prefKey) {
            // Dictionary pref, values are always strings.
            return this.pref.value[this.prefKey];
        }
        else {
            assert$1(this.pref);
            return prefToString(this.pref);
        }
    }
    showNotFoundValue_(menuOptions, prefValue) {
        if (menuOptions === undefined || prefValue === undefined) {
            return false;
        }
        // Don't show "Custom" before the options load.
        if (menuOptions === null || menuOptions.length === 0) {
            return false;
        }
        const option = menuOptions.find((menuItem) => {
            return menuItem.value.toString() === this.prefStringValue_();
        });
        return !option;
    }
    shouldDisableMenu_() {
        return this.disabled || this.isPrefEnforced() ||
            this.menuOptions === undefined || this.menuOptions.length === 0;
    }
}
customElements.define(SettingsDropdownMenuElement.is, SettingsDropdownMenuElement);

function getTemplate$1w() {
    return html `<!--_html_template_start_--><style include="cr-radio-button-style cr-hidden-style"></style>

<div aria-checked$="[[getAriaChecked_(checked)]]"
    aria-describedby="slotted-content"
    aria-disabled$="[[getAriaDisabled_(disabled)]]"
    aria-labelledby="label"
    class="disc-wrapper"
    id="button"
    role="radio"
    tabindex$="[[buttonTabIndex_]]"
    on-keydown="onInputKeydown_">
  <div class="disc-border"></div>
  <div class="disc"></div>
  <div id="overlay"></div>
</div>

<div id="labelWrapper">
  <span id="label" hidden$="[[!label]]" aria-hidden="true">[[label]]</span>
  <span id="slotted-content">
    <slot></slot>
  </span>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Forked from
// ui/webui/resources/cr_elements/cr_radio_button/cr_radio_button.ts
const CrRadioButtonElementBase = PaperRippleMixin(CrRadioButtonMixin(PolymerElement));
class CrRadioButtonElement extends CrRadioButtonElementBase {
    static get is() {
        return 'cr-radio-button';
    }
    static get template() {
        return getTemplate$1w();
    }
    // Overridden from CrRadioButtonMixin
    getPaperRipple() {
        return this.getRipple();
    }
    // Overridden from PaperRippleMixin
    /* eslint-disable-next-line @typescript-eslint/naming-convention */
    _createRipple() {
        this._rippleContainer = this.shadowRoot.querySelector('.disc-wrapper');
        const ripple = super._createRipple();
        ripple.id = 'ink';
        ripple.setAttribute('recenters', '');
        ripple.classList.add('circle');
        return ripple;
    }
}
customElements.define(CrRadioButtonElement.is, CrRadioButtonElement);

function getTemplate$1v() {
    return html `<!--_html_template_start_--><style>:host{display:inline-block}:host ::slotted(*){padding:var(--cr-radio-group-item-padding,12px)}:host([disabled]){cursor:initial;pointer-events:none;user-select:none}:host([disabled]) ::slotted(*){opacity:var(--cr-disabled-opacity)}</style>
<slot></slot>
<!--_html_template_end_-->`;
}

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Forked from
// ui/webui/resources/cr_elements/cr_radio_group/cr_radio_group.ts
function isEnabled(radio) {
    return radio.matches(':not([disabled]):not([hidden])') &&
        radio.style.display !== 'none' && radio.style.visibility !== 'hidden';
}
class CrRadioGroupElement extends PolymerElement {
    constructor() {
        super(...arguments);
        this.buttons_ = null;
        this.buttonEventTracker_ = new EventTracker();
        this.deltaKeyMap_ = null;
        this.isRtl_ = false;
        this.populateBound_ = null;
    }
    static get is() {
        return 'cr-radio-group';
    }
    static get template() {
        return getTemplate$1v();
    }
    static get properties() {
        return {
            disabled: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
                observer: 'update_',
            },
            selected: {
                type: String,
                notify: true,
                observer: 'update_',
            },
            selectableElements: {
                type: String,
                value: 'cr-radio-button, cr-card-radio-button, controlled-radio-button',
            },
            nestedSelectable: {
                type: Boolean,
                value: false,
                observer: 'populate_',
            },
            selectableRegExp_: {
                value: Object,
                computed: 'computeSelectableRegExp_(selectableElements)',
            },
        };
    }
    ready() {
        super.ready();
        this.addEventListener('keydown', e => this.onKeyDown_(/** @type {!KeyboardEvent} */ (e)));
        this.addEventListener('click', this.onClick_.bind(this));
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'radiogroup');
        }
        this.setAttribute('aria-disabled', 'false');
    }
    connectedCallback() {
        super.connectedCallback();
        this.isRtl_ = this.matches(':host-context([dir=rtl]) cr-radio-group');
        this.deltaKeyMap_ = new Map([
            ['ArrowDown', 1],
            ['ArrowLeft', this.isRtl_ ? 1 : -1],
            ['ArrowRight', this.isRtl_ ? -1 : 1],
            ['ArrowUp', -1],
            ['PageDown', 1],
            ['PageUp', -1],
        ]);
        this.populateBound_ = () => this.populate_();
        assert$1(this.populateBound_);
        this.shadowRoot.querySelector('slot').addEventListener('slotchange', this.populateBound_);
        this.populate_();
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        assert$1(this.populateBound_);
        this.shadowRoot.querySelector('slot').removeEventListener('slotchange', this.populateBound_);
        this.buttonEventTracker_.removeAll();
    }
    focus() {
        if (this.disabled || !this.buttons_) {
            return;
        }
        const radio = this.buttons_.find(radio => this.isButtonEnabledAndSelected_(radio));
        if (radio) {
            radio.focus();
        }
    }
    onKeyDown_(event) {
        if (this.disabled) {
            return;
        }
        if (event.ctrlKey || event.shiftKey || event.metaKey || event.altKey) {
            return;
        }
        const targetElement = event.target;
        if (!this.buttons_ || !this.buttons_.includes(targetElement)) {
            return;
        }
        if (event.key === ' ' || event.key === 'Enter') {
            event.preventDefault();
            this.select_(targetElement);
            return;
        }
        const enabledRadios = this.buttons_.filter(isEnabled);
        if (enabledRadios.length === 0) {
            return;
        }
        assert$1(this.deltaKeyMap_);
        let selectedIndex;
        const max = enabledRadios.length - 1;
        if (event.key === 'Home') {
            selectedIndex = 0;
        }
        else if (event.key === 'End') {
            selectedIndex = max;
        }
        else if (this.deltaKeyMap_.has(event.key)) {
            const delta = this.deltaKeyMap_.get(event.key);
            // If nothing selected, start from the first radio then add |delta|.
            const lastSelection = enabledRadios.findIndex(radio => radio.checked);
            selectedIndex = Math.max(0, lastSelection) + delta;
            // Wrap the selection, if needed.
            if (selectedIndex > max) {
                selectedIndex = 0;
            }
            else if (selectedIndex < 0) {
                selectedIndex = max;
            }
        }
        else {
            return;
        }
        const radio = enabledRadios[selectedIndex];
        const name = `${radio.name}`;
        if (this.selected !== name) {
            event.preventDefault();
            event.stopPropagation();
            this.selected = name;
            radio.focus();
        }
    }
    computeSelectableRegExp_() {
        const tags = this.selectableElements.split(', ').join('|');
        return new RegExp(`^(${tags})$`, 'i');
    }
    onClick_(event) {
        const path = event.composedPath();
        if (path.some(target => /^a$/i.test(target.tagName))) {
            return;
        }
        const target = path.find(n => this.selectableRegExp_.test(n.tagName));
        if (target && this.buttons_ && this.buttons_.includes(target)) {
            this.select_(target);
        }
    }
    populate_() {
        const nodes = this.shadowRoot.querySelector('slot').assignedNodes({ flatten: true });
        this.buttons_ = Array.from(nodes).flatMap(node => {
            if (node.nodeType !== Node.ELEMENT_NODE) {
                return [];
            }
            const el = node;
            let result = [];
            if (el.matches(this.selectableElements)) {
                result.push(el);
            }
            if (this.nestedSelectable) {
                result = result.concat(Array.from(el.querySelectorAll(this.selectableElements)));
            }
            return result;
        });
        this.buttonEventTracker_.removeAll();
        this.buttons_.forEach(el => {
            this.buttonEventTracker_.add(el, 'disabled-changed', () => this.populate_());
            this.buttonEventTracker_.add(el, 'name-changed', () => this.populate_());
        });
        this.update_();
    }
    select_(button) {
        if (!isEnabled(button)) {
            return;
        }
        const name = `${button.name}`;
        if (this.selected !== name) {
            this.selected = name;
        }
    }
    isButtonEnabledAndSelected_(button) {
        return !this.disabled && button.checked && isEnabled(button);
    }
    update_() {
        if (!this.buttons_) {
            return;
        }
        let noneMadeFocusable = true;
        this.buttons_.forEach(radio => {
            radio.checked =
                this.selected !== undefined && `${radio.name}` === `${this.selected}`;
            const disabled = this.disabled || !isEnabled(radio);
            const canBeFocused = radio.checked && !disabled;
            if (canBeFocused) {
                radio.focusable = true;
                noneMadeFocusable = false;
            }
            else {
                radio.focusable = false;
            }
            radio.setAttribute('aria-disabled', `${disabled}`);
        });
        this.setAttribute('aria-disabled', `${this.disabled}`);
        if (noneMadeFocusable && !this.disabled) {
            const radio = this.buttons_.find(isEnabled);
            if (radio) {
                radio.focusable = true;
            }
        }
    }
}
customElements.define(CrRadioGroupElement.is, CrRadioGroupElement);

function getTemplate$1u() {
    return html `<!--_html_template_start_--><style>cr-radio-group{width:100%}</style>
<cr-radio-group selected="[[selected]]"
    on-selected-changed="onSelectedChanged_"
    aria-label$="[[groupAriaLabel]]"
    selectable-elements="[[selectableElements]]"
    disabled="[[disabled]]">
  <slot></slot>
</cr-radio-group>
<!--_html_template_end_-->`;
}

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * `settings-radio-group` wraps cr-radio-group and set of radio-buttons that
 * control a supplied preference.
 *
 * Example:
 *      <settings-radio-group pref="{{prefs.settings.foo}}"
 *          label="Foo Options." buttons="{{fooOptionsList}}">
 *      </settings-radio-group>
 */
const SettingsRadioGroupElementBase = PrefControlMixin(PolymerElement);
class SettingsRadioGroupElement extends SettingsRadioGroupElementBase {
    static get is() {
        return 'settings-radio-group';
    }
    static get template() {
        return getTemplate$1u();
    }
    static get properties() {
        return {
            disabled: {
                type: Boolean,
                value: false,
            },
            groupAriaLabel: String,
            /**
             * If true, do not automatically set the preference value. This allows the
             * container to confirm the change first then call either sendPrefChange
             * or resetToPrefValue accordingly.
             */
            noSetPref: {
                type: Boolean,
                value: false,
            },
            selected: String,
            selectableElements: {
                type: String,
                value: ['cr-radio-button', 'controlled-radio-button'].join(', '),
            },
        };
    }
    static get observers() {
        return [
            'resetToPrefValue(pref.*)',
        ];
    }
    ready() {
        super.ready();
        this.setAttribute('role', 'none');
    }
    focus() {
        this.shadowRoot.querySelector('cr-radio-group').focus();
    }
    /** Reset the selected value to match the current pref value. */
    resetToPrefValue() {
        this.selected = prefToString(this.pref);
    }
    /** Update the pref to the current selected value. */
    sendPrefChange() {
        if (!this.pref) {
            return;
        }
        this.set('pref.value', stringToPrefValue(this.selected, this.pref));
    }
    onSelectedChanged_() {
        this.selected = this.shadowRoot.querySelector('cr-radio-group').selected;
        if (!this.noSetPref) {
            this.sendPrefChange();
        }
        this.dispatchEvent(new CustomEvent('change', { bubbles: true, composed: true }));
    }
}
customElements.define(SettingsRadioGroupElement.is, SettingsRadioGroupElement);

// chrome/browser/ui/webui/ash/settings/pages/date_time/mojom/date_time_handler.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
let PageHandlerFactoryPendingReceiver$3 = class PageHandlerFactoryPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.date_time.mojom.PageHandlerFactory', scope);
    }
};
let PageHandlerFactoryRemote$3 = class PageHandlerFactoryRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerFactoryPendingReceiver$3, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createPageHandler(page, handler) {
        this.proxy.sendMessage(0, PageHandlerFactory_CreatePageHandler_ParamsSpec$3.$, null, [
            page,
            handler
        ], false);
    }
};
let PageHandlerFactory$3 = class PageHandlerFactory {
    static get $interfaceName() {
        return "ash.settings.date_time.mojom.PageHandlerFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerFactoryRemote$3;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
};
let PageHandlerPendingReceiver$4 = class PageHandlerPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.date_time.mojom.PageHandler', scope);
    }
};
let PageHandlerRemote$4 = class PageHandlerRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver$4, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    showParentAccessForTimezone() {
        this.proxy.sendMessage(0, PageHandler_ShowParentAccessForTimezone_ParamsSpec.$, null, [], false);
    }
    getTimezones() {
        return this.proxy.sendMessage(1, PageHandler_GetTimezones_ParamsSpec.$, PageHandler_GetTimezones_ResponseParamsSpec.$, [], false);
    }
    showSetDateTimeUI() {
        this.proxy.sendMessage(2, PageHandler_ShowSetDateTimeUI_ParamsSpec.$, null, [], false);
    }
};
let PagePendingReceiver$3 = class PagePendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.date_time.mojom.Page', scope);
    }
};
let PageRemote$3 = class PageRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver$3, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onSystemClockCanSetTimeChanged(isAllowed) {
        this.proxy.sendMessage(0, Page_OnSystemClockCanSetTimeChanged_ParamsSpec.$, null, [
            isAllowed
        ], false);
    }
    onParentAccessValidationComplete(success) {
        this.proxy.sendMessage(1, Page_OnParentAccessValidationComplete_ParamsSpec.$, null, [
            success
        ], false);
    }
};
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
let PageCallbackRouter$3 = class PageCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote$3);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onSystemClockCanSetTimeChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, Page_OnSystemClockCanSetTimeChanged_ParamsSpec.$, null, this.onSystemClockCanSetTimeChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onParentAccessValidationComplete =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, Page_OnParentAccessValidationComplete_ParamsSpec.$, null, this.onParentAccessValidationComplete.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
};
const PageHandlerFactory_CreatePageHandler_ParamsSpec$3 = { $: {} };
const PageHandler_ShowParentAccessForTimezone_ParamsSpec = { $: {} };
const PageHandler_GetTimezones_ParamsSpec = { $: {} };
const PageHandler_GetTimezones_ResponseParamsSpec = { $: {} };
const PageHandler_ShowSetDateTimeUI_ParamsSpec = { $: {} };
const Page_OnSystemClockCanSetTimeChanged_ParamsSpec = { $: {} };
const Page_OnParentAccessValidationComplete_ParamsSpec = { $: {} };
mojo.internal.Struct(PageHandlerFactory_CreatePageHandler_ParamsSpec$3.$, 'PageHandlerFactory_CreatePageHandler_Params', [
    mojo.internal.StructField('page', 0, 0, mojo.internal.InterfaceProxy(PageRemote$3), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('handler', 8, 0, mojo.internal.InterfaceRequest(PageHandlerPendingReceiver$4), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_ShowParentAccessForTimezone_ParamsSpec.$, 'PageHandler_ShowParentAccessForTimezone_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetTimezones_ParamsSpec.$, 'PageHandler_GetTimezones_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetTimezones_ResponseParamsSpec.$, 'PageHandler_GetTimezones_ResponseParams', [
    mojo.internal.StructField('timezones', 0, 0, mojo.internal.Array(mojo.internal.Array(mojo.internal.String, false), false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_ShowSetDateTimeUI_ParamsSpec.$, 'PageHandler_ShowSetDateTimeUI_Params', [], [[0, 8],]);
mojo.internal.Struct(Page_OnSystemClockCanSetTimeChanged_ParamsSpec.$, 'Page_OnSystemClockCanSetTimeChanged_Params', [
    mojo.internal.StructField('isAllowed', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_OnParentAccessValidationComplete_ParamsSpec.$, 'Page_OnParentAccessValidationComplete_Params', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Communicates with the DateTimeHandler in the browser process.
class DateTimeBrowserProxy {
    constructor() {
        // Invoke methods from the browser process.
        this.handler = new PageHandlerRemote$4();
        // Receive updates from the browser process.
        this.observer = new PageCallbackRouter$3();
        const factory = PageHandlerFactory$3.getRemote();
        factory.createPageHandler(this.observer.$.bindNewPipeAndPassRemote(), this.handler.$.bindNewPipeAndPassReceiver());
    }
    static getInstance() {
        return instance$A || (instance$A = new DateTimeBrowserProxy());
    }
    static setInstanceForTesting(proxy) {
        instance$A = proxy;
    }
}
let instance$A = null;

function getTemplate$1t() {
    return html `<!--_html_template_start_--><style include="settings-shared">settings-dropdown-menu{--md-select-width:425px}#userTimeZoneSelector{--settings-dropdown-menu-policy-order:1}</style>
<template is="dom-if" restamp
    if="[[!prefs.cros.flags.per_user_timezone_enabled.value]]">
  <settings-dropdown-menu pref="{{prefs.cros.system.timezone}}"
      label="$i18n{timeZone}"
      menu-options="[[timeZoneList_]]"
      disabled="[[prefs.generated.resolve_timezone_by_geolocation_on_off.value ||
      shouldDisableTimeZoneGeoSelector]]">
  </settings-dropdown-menu>
</template>
<template is="dom-if" restamp
    if="[[prefs.cros.flags.per_user_timezone_enabled.value]]">
    <settings-dropdown-menu id="userTimeZoneSelector"
        pref="{{prefs.settings.timezone}}"
        label="$i18n{timeZone}"
        menu-options="[[timeZoneList_]]"
        disabled="[[shouldDisableUserTimezoneSelector_(
          prefs.generated.resolve_timezone_by_geolocation_on_off.value,
          shouldDisableTimeZoneGeoSelector)]]">
    </settings-dropdown-menu>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'timezone-selector' is the time zone selector dropdown.
 */
const TimezoneSelectorElementBase = PrefsMixin(PolymerElement);
class TimezoneSelectorElement extends TimezoneSelectorElementBase {
    static get is() {
        return 'timezone-selector';
    }
    static get template() {
        return getTemplate$1t();
    }
    static get properties() {
        return {
            /**
             * This stores active time zone display name to be used in other UI
             * via bi-directional binding.
             */
            activeTimeZoneDisplayName: {
                type: String,
                notify: true,
            },
            /**
             * True if the account is supervised and doesn't get parent access code
             * verification.
             */
            shouldDisableTimeZoneGeoSelector: {
                type: Boolean,
                notify: true,
                value: false,
            },
            /**
             * Initialized with the current time zone so the menu displays the
             * correct value. The full option list is fetched lazily if necessary by
             * maybeGetTimeZoneList_.
             */
            timeZoneList_: {
                type: Array,
                value() {
                    return [{
                            name: loadTimeData.getString('timeZoneName'),
                            value: loadTimeData.getString('timeZoneID'),
                        }];
                },
            },
        };
    }
    static get observers() {
        return [
            'maybeGetTimeZoneListPerUser_(' +
                'prefs.settings.timezone.value,' +
                'prefs.generated.resolve_timezone_by_geolocation_on_off.value)',
            'maybeGetTimeZoneListPerSystem_(' +
                'prefs.cros.system.timezone.value,' +
                'prefs.generated.resolve_timezone_by_geolocation_on_off.value)',
            'updateActiveTimeZoneName_(prefs.cros.system.timezone.value)',
        ];
    }
    /**
     * Returns the browser proxy page handler (to invoke functions).
     */
    get pageHandler() {
        return DateTimeBrowserProxy.getInstance().handler;
    }
    constructor() {
        super();
        /**
         * True if getTimeZones request was sent to Chrome, but result is not
         * yet received.
         */
        this.getTimeZonesRequestSent_ = false;
    }
    connectedCallback() {
        super.connectedCallback();
        this.maybeGetTimeZoneList_();
    }
    /**
     * Fetches the list of time zones if necessary.
     * @param perUserTimeZoneMode Expected value of per-user time zone.
     */
    async maybeGetTimeZoneList_(perUserTimeZoneMode) {
        if (typeof (perUserTimeZoneMode) !== 'undefined') {
            /* This method is called as observer. Skip if if current mode does not
             * match expected.
             */
            if (perUserTimeZoneMode !==
                this.getPref('cros.flags.per_user_timezone_enabled').value) {
                return;
            }
        }
        // Only fetch the list once.
        if (this.timeZoneList_.length > 1 || !CrSettingsPrefs.isInitialized) {
            return;
        }
        if (this.getTimeZonesRequestSent_) {
            return;
        }
        // If auto-detect is enabled, we only need the current time zone.
        if (this.getPref('generated.resolve_timezone_by_geolocation_on_off')
            .value) {
            const isPerUserTimezone = this.getPref('cros.flags.per_user_timezone_enabled').value;
            if (this.timeZoneList_[0].value ===
                (isPerUserTimezone ? this.getPref('settings.timezone').value :
                    this.getPref('cros.system.timezone').value)) {
                return;
            }
        }
        // Setting several preferences at once will trigger several
        // |maybeGetTimeZoneList_| calls, which we don't want.
        this.getTimeZonesRequestSent_ = true;
        try {
            const { timezones } = await this.pageHandler.getTimezones();
            this.setTimeZoneList_(timezones);
        }
        finally {
            this.getTimeZonesRequestSent_ = false;
        }
    }
    /**
     * Prefs observer for Per-user time zone enabled mode.
     */
    maybeGetTimeZoneListPerUser_() {
        this.maybeGetTimeZoneList_(true);
    }
    /**
     * Prefs observer for Per-user time zone disabled mode.
     */
    maybeGetTimeZoneListPerSystem_() {
        this.maybeGetTimeZoneList_(false);
    }
    /**
     * Converts the C++ response into an array of menu options.
     * @param timeZones C++ time zones response.
     */
    setTimeZoneList_(timeZones) {
        this.timeZoneList_ = timeZones.map((timeZonePair) => {
            return {
                name: timeZonePair[1],
                value: timeZonePair[0],
            };
        });
        this.updateActiveTimeZoneName_(this.getPref('cros.system.timezone').value);
    }
    /**
     * Updates active time zone display name when changed.
     * @param activeTimeZoneId value of cros.system.timezone preference.
     */
    updateActiveTimeZoneName_(activeTimeZoneId) {
        const activeTimeZone = this.timeZoneList_.find((timeZone) => timeZone.value.toString() === activeTimeZoneId);
        if (activeTimeZone) {
            this.activeTimeZoneDisplayName = activeTimeZone.name;
        }
    }
    /**
     * Computes whether user timezone selector should be disabled. Returns `true`
     * if auto detect is on or it's waiting for 'access-code-validation-complete'
     * for child account.
     */
    shouldDisableUserTimezoneSelector_() {
        return this.getPref('generated.resolve_timezone_by_geolocation_on_off')
            .value ||
            this.shouldDisableTimeZoneGeoSelector;
    }
}
customElements.define(TimezoneSelectorElement.is, TimezoneSelectorElement);

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function createPermission(permissionType, value, isManaged) {
    return {
        details: null,
        permissionType,
        value,
        isManaged,
    };
}
function createTriStatePermissionValue(value) {
    return { tristateValue: value };
}
function getTriStatePermissionValue(permissionValue) {
    assert$1(isTriStateValue(permissionValue));
    return permissionValue.tristateValue;
}
function createBoolPermissionValue(value) {
    return { boolValue: value };
}
function getBoolPermissionValue(permissionValue) {
    assert$1(isBoolValue(permissionValue));
    return permissionValue.boolValue;
}
function isTriStateValue(permissionValue) {
    return permissionValue['tristateValue'] !== undefined &&
        permissionValue['boolValue'] === undefined;
}
function isBoolValue(permissionValue) {
    return permissionValue['boolValue'] !== undefined &&
        permissionValue['tristateValue'] === undefined;
}
function createBoolPermission(permissionType, value, isManaged) {
    return createPermission(permissionType, createBoolPermissionValue(value), isManaged);
}
function createTriStatePermission(permissionType, value, isManaged) {
    return createPermission(permissionType, createTriStatePermissionValue(value), isManaged);
}
function isPermissionEnabled(permissionValue) {
    if (isBoolValue(permissionValue)) {
        return getBoolPermissionValue(permissionValue);
    }
    if (isTriStateValue(permissionValue)) {
        return getTriStatePermissionValue(permissionValue) === TriState.kAllow;
    }
    assertNotReached$1();
}

// chrome/browser/ui/webui/ash/settings/pages/privacy/mojom/app_permission_handler.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class AppPermissionsHandlerPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.app_permission.mojom.AppPermissionsHandler', scope);
    }
}
class AppPermissionsHandlerRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(AppPermissionsHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    addObserver(observer) {
        this.proxy.sendMessage(0, AppPermissionsHandler_AddObserver_ParamsSpec.$, null, [
            observer
        ], false);
    }
    getApps() {
        return this.proxy.sendMessage(1, AppPermissionsHandler_GetApps_ParamsSpec.$, AppPermissionsHandler_GetApps_ResponseParamsSpec.$, [], false);
    }
    getSystemAppsThatUseCamera() {
        return this.proxy.sendMessage(2, AppPermissionsHandler_GetSystemAppsThatUseCamera_ParamsSpec.$, AppPermissionsHandler_GetSystemAppsThatUseCamera_ResponseParamsSpec.$, [], false);
    }
    getSystemAppsThatUseMicrophone() {
        return this.proxy.sendMessage(3, AppPermissionsHandler_GetSystemAppsThatUseMicrophone_ParamsSpec.$, AppPermissionsHandler_GetSystemAppsThatUseMicrophone_ResponseParamsSpec.$, [], false);
    }
    openBrowserPermissionSettings(permissionType) {
        this.proxy.sendMessage(4, AppPermissionsHandler_OpenBrowserPermissionSettings_ParamsSpec.$, null, [
            permissionType
        ], false);
    }
    openNativeSettings(appId) {
        this.proxy.sendMessage(5, AppPermissionsHandler_OpenNativeSettings_ParamsSpec.$, null, [
            appId
        ], false);
    }
    setPermission(appId, permission) {
        this.proxy.sendMessage(6, AppPermissionsHandler_SetPermission_ParamsSpec.$, null, [
            appId,
            permission
        ], false);
    }
}
/**
 * An object which receives request messages for the AppPermissionsHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
class AppPermissionsHandlerReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AppPermissionsHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, AppPermissionsHandler_AddObserver_ParamsSpec.$, null, impl.addObserver.bind(impl), false);
        this.helper_internal_.registerHandler(1, AppPermissionsHandler_GetApps_ParamsSpec.$, AppPermissionsHandler_GetApps_ResponseParamsSpec.$, impl.getApps.bind(impl), false);
        this.helper_internal_.registerHandler(2, AppPermissionsHandler_GetSystemAppsThatUseCamera_ParamsSpec.$, AppPermissionsHandler_GetSystemAppsThatUseCamera_ResponseParamsSpec.$, impl.getSystemAppsThatUseCamera.bind(impl), false);
        this.helper_internal_.registerHandler(3, AppPermissionsHandler_GetSystemAppsThatUseMicrophone_ParamsSpec.$, AppPermissionsHandler_GetSystemAppsThatUseMicrophone_ResponseParamsSpec.$, impl.getSystemAppsThatUseMicrophone.bind(impl), false);
        this.helper_internal_.registerHandler(4, AppPermissionsHandler_OpenBrowserPermissionSettings_ParamsSpec.$, null, impl.openBrowserPermissionSettings.bind(impl), false);
        this.helper_internal_.registerHandler(5, AppPermissionsHandler_OpenNativeSettings_ParamsSpec.$, null, impl.openNativeSettings.bind(impl), false);
        this.helper_internal_.registerHandler(6, AppPermissionsHandler_SetPermission_ParamsSpec.$, null, impl.setPermission.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
class AppPermissionsHandler {
    static get $interfaceName() {
        return "ash.settings.app_permission.mojom.AppPermissionsHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new AppPermissionsHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the AppPermissionsHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
class AppPermissionsHandlerCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AppPermissionsHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.addObserver =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, AppPermissionsHandler_AddObserver_ParamsSpec.$, null, this.addObserver.createReceiverHandler(false /* expectsResponse */), false);
        this.getApps =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, AppPermissionsHandler_GetApps_ParamsSpec.$, AppPermissionsHandler_GetApps_ResponseParamsSpec.$, this.getApps.createReceiverHandler(true /* expectsResponse */), false);
        this.getSystemAppsThatUseCamera =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, AppPermissionsHandler_GetSystemAppsThatUseCamera_ParamsSpec.$, AppPermissionsHandler_GetSystemAppsThatUseCamera_ResponseParamsSpec.$, this.getSystemAppsThatUseCamera.createReceiverHandler(true /* expectsResponse */), false);
        this.getSystemAppsThatUseMicrophone =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, AppPermissionsHandler_GetSystemAppsThatUseMicrophone_ParamsSpec.$, AppPermissionsHandler_GetSystemAppsThatUseMicrophone_ResponseParamsSpec.$, this.getSystemAppsThatUseMicrophone.createReceiverHandler(true /* expectsResponse */), false);
        this.openBrowserPermissionSettings =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, AppPermissionsHandler_OpenBrowserPermissionSettings_ParamsSpec.$, null, this.openBrowserPermissionSettings.createReceiverHandler(false /* expectsResponse */), false);
        this.openNativeSettings =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, AppPermissionsHandler_OpenNativeSettings_ParamsSpec.$, null, this.openNativeSettings.createReceiverHandler(false /* expectsResponse */), false);
        this.setPermission =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, AppPermissionsHandler_SetPermission_ParamsSpec.$, null, this.setPermission.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
class AppPermissionsObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.app_permission.mojom.AppPermissionsObserver', scope);
    }
}
class AppPermissionsObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(AppPermissionsObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onAppRemoved(appId) {
        this.proxy.sendMessage(0, AppPermissionsObserver_OnAppRemoved_ParamsSpec.$, null, [
            appId
        ], false);
    }
    onAppUpdated(app) {
        this.proxy.sendMessage(1, AppPermissionsObserver_OnAppUpdated_ParamsSpec.$, null, [
            app
        ], false);
    }
}
/**
 * An object which receives request messages for the AppPermissionsObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
class AppPermissionsObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AppPermissionsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, AppPermissionsObserver_OnAppRemoved_ParamsSpec.$, null, impl.onAppRemoved.bind(impl), false);
        this.helper_internal_.registerHandler(1, AppPermissionsObserver_OnAppUpdated_ParamsSpec.$, null, impl.onAppUpdated.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
class AppPermissionsObserver {
    static get $interfaceName() {
        return "ash.settings.app_permission.mojom.AppPermissionsObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new AppPermissionsObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the AppPermissionsObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
class AppPermissionsObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AppPermissionsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onAppRemoved =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, AppPermissionsObserver_OnAppRemoved_ParamsSpec.$, null, this.onAppRemoved.createReceiverHandler(false /* expectsResponse */), false);
        this.onAppUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, AppPermissionsObserver_OnAppUpdated_ParamsSpec.$, null, this.onAppUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
const AppSpec$2 = { $: {} };
const AppPermissionsHandler_AddObserver_ParamsSpec = { $: {} };
const AppPermissionsHandler_GetApps_ParamsSpec = { $: {} };
const AppPermissionsHandler_GetApps_ResponseParamsSpec = { $: {} };
const AppPermissionsHandler_GetSystemAppsThatUseCamera_ParamsSpec = { $: {} };
const AppPermissionsHandler_GetSystemAppsThatUseCamera_ResponseParamsSpec = { $: {} };
const AppPermissionsHandler_GetSystemAppsThatUseMicrophone_ParamsSpec = { $: {} };
const AppPermissionsHandler_GetSystemAppsThatUseMicrophone_ResponseParamsSpec = { $: {} };
const AppPermissionsHandler_OpenBrowserPermissionSettings_ParamsSpec = { $: {} };
const AppPermissionsHandler_OpenNativeSettings_ParamsSpec = { $: {} };
const AppPermissionsHandler_SetPermission_ParamsSpec = { $: {} };
const AppPermissionsObserver_OnAppRemoved_ParamsSpec = { $: {} };
const AppPermissionsObserver_OnAppUpdated_ParamsSpec = { $: {} };
mojo.internal.Struct(AppSpec$2.$, 'App', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('name', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('type', 16, 0, AppTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('permissions', 24, 0, mojo.internal.Map(PermissionTypeSpec.$, PermissionSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(AppPermissionsHandler_AddObserver_ParamsSpec.$, 'AppPermissionsHandler_AddObserver_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(AppPermissionsObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AppPermissionsHandler_GetApps_ParamsSpec.$, 'AppPermissionsHandler_GetApps_Params', [], [[0, 8],]);
mojo.internal.Struct(AppPermissionsHandler_GetApps_ResponseParamsSpec.$, 'AppPermissionsHandler_GetApps_ResponseParams', [
    mojo.internal.StructField('apps', 0, 0, mojo.internal.Array(AppSpec$2.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AppPermissionsHandler_GetSystemAppsThatUseCamera_ParamsSpec.$, 'AppPermissionsHandler_GetSystemAppsThatUseCamera_Params', [], [[0, 8],]);
mojo.internal.Struct(AppPermissionsHandler_GetSystemAppsThatUseCamera_ResponseParamsSpec.$, 'AppPermissionsHandler_GetSystemAppsThatUseCamera_ResponseParams', [
    mojo.internal.StructField('apps', 0, 0, mojo.internal.Array(AppSpec$2.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AppPermissionsHandler_GetSystemAppsThatUseMicrophone_ParamsSpec.$, 'AppPermissionsHandler_GetSystemAppsThatUseMicrophone_Params', [], [[0, 8],]);
mojo.internal.Struct(AppPermissionsHandler_GetSystemAppsThatUseMicrophone_ResponseParamsSpec.$, 'AppPermissionsHandler_GetSystemAppsThatUseMicrophone_ResponseParams', [
    mojo.internal.StructField('apps', 0, 0, mojo.internal.Array(AppSpec$2.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AppPermissionsHandler_OpenBrowserPermissionSettings_ParamsSpec.$, 'AppPermissionsHandler_OpenBrowserPermissionSettings_Params', [
    mojo.internal.StructField('permissionType', 0, 0, PermissionTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AppPermissionsHandler_OpenNativeSettings_ParamsSpec.$, 'AppPermissionsHandler_OpenNativeSettings_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AppPermissionsHandler_SetPermission_ParamsSpec.$, 'AppPermissionsHandler_SetPermission_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('permission', 8, 0, PermissionSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(AppPermissionsObserver_OnAppRemoved_ParamsSpec.$, 'AppPermissionsObserver_OnAppRemoved_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AppPermissionsObserver_OnAppUpdated_ParamsSpec.$, 'AppPermissionsObserver_OnAppUpdated_Params', [
    mojo.internal.StructField('app', 0, 0, AppSpec$2.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);

var app_permission_handler_mojomWebui = /*#__PURE__*/Object.freeze({
  __proto__: null,
  AppPermissionsHandler: AppPermissionsHandler,
  AppPermissionsHandlerCallbackRouter: AppPermissionsHandlerCallbackRouter,
  AppPermissionsHandlerPendingReceiver: AppPermissionsHandlerPendingReceiver,
  AppPermissionsHandlerReceiver: AppPermissionsHandlerReceiver,
  AppPermissionsHandlerRemote: AppPermissionsHandlerRemote,
  AppPermissionsHandler_AddObserver_ParamsSpec: AppPermissionsHandler_AddObserver_ParamsSpec,
  AppPermissionsHandler_GetApps_ParamsSpec: AppPermissionsHandler_GetApps_ParamsSpec,
  AppPermissionsHandler_GetApps_ResponseParamsSpec: AppPermissionsHandler_GetApps_ResponseParamsSpec,
  AppPermissionsHandler_GetSystemAppsThatUseCamera_ParamsSpec: AppPermissionsHandler_GetSystemAppsThatUseCamera_ParamsSpec,
  AppPermissionsHandler_GetSystemAppsThatUseCamera_ResponseParamsSpec: AppPermissionsHandler_GetSystemAppsThatUseCamera_ResponseParamsSpec,
  AppPermissionsHandler_GetSystemAppsThatUseMicrophone_ParamsSpec: AppPermissionsHandler_GetSystemAppsThatUseMicrophone_ParamsSpec,
  AppPermissionsHandler_GetSystemAppsThatUseMicrophone_ResponseParamsSpec: AppPermissionsHandler_GetSystemAppsThatUseMicrophone_ResponseParamsSpec,
  AppPermissionsHandler_OpenBrowserPermissionSettings_ParamsSpec: AppPermissionsHandler_OpenBrowserPermissionSettings_ParamsSpec,
  AppPermissionsHandler_OpenNativeSettings_ParamsSpec: AppPermissionsHandler_OpenNativeSettings_ParamsSpec,
  AppPermissionsHandler_SetPermission_ParamsSpec: AppPermissionsHandler_SetPermission_ParamsSpec,
  AppPermissionsObserver: AppPermissionsObserver,
  AppPermissionsObserverCallbackRouter: AppPermissionsObserverCallbackRouter,
  AppPermissionsObserverPendingReceiver: AppPermissionsObserverPendingReceiver,
  AppPermissionsObserverReceiver: AppPermissionsObserverReceiver,
  AppPermissionsObserverRemote: AppPermissionsObserverRemote,
  AppPermissionsObserver_OnAppRemoved_ParamsSpec: AppPermissionsObserver_OnAppRemoved_ParamsSpec,
  AppPermissionsObserver_OnAppUpdated_ParamsSpec: AppPermissionsObserver_OnAppUpdated_ParamsSpec,
  AppSpec: AppSpec$2
});

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
let appPermissionProvider = null;
function setAppPermissionProviderForTesting(fakeProvider) {
    appPermissionProvider = fakeProvider;
}
function getAppPermissionProvider() {
    if (appPermissionProvider === null) {
        appPermissionProvider = AppPermissionsHandler.getRemote();
    }
    return appPermissionProvider;
}

function getTemplate$1s() {
    return html `<!--_html_template_start_--><style include="settings-shared">#container{align-items:center;display:flex;height:48px;width:100%}#container:hover[actionable]{background-color:var(--cr-hover-background-color)}#appData{align-items:center;display:flex;flex-direction:row;width:100%}#appIcon{height:32px;margin-inline-end:20px;width:32px}cr-icon-button,cr-policy-indicator{margin-inline-end:var(--cr-controlled-by-spacing)}</style>
<div id="container" actionable$="[[!isPermissionManaged_]]">
  <div id="appData">
    <img id="appIcon" src="chrome://app-icon/[[app.id]]/64"
        alt="[[app.name]] app icon." aria-hidden="true">
    <div id="appNameAndPermissionText">
      <div id="appName">[[app.name]]</div>
      <div id="permissionText" class="secondary">[[permissionText_]]</div>
    </div>
  </div>
  <template is="dom-if" if="[[isPermissionManaged_]]" restamp>
    <cr-policy-indicator
        indicator-type="devicePolicy"
        icon-aria-label="[[getAriaLabel_()]]"
        aria-description="[[ariaDescription_]]">
    </cr-policy-indicator>
  </template>
  <template is="dom-if" if="[[shouldRedirectToAndroidSettings_]]" restamp>
    <cr-icon-button
        iron-icon="cr:open-in-new"
        role="link"
        aria-label="[[getAriaLabel_()]]"
        aria-description="[[androidSettingsLinkAriaDescription_]]">
    </cr-icon-button>
  </template>
  <cr-toggle id="permissionToggle"
      checked="[[checked_]]"
      on-click="onToggleClick_"
      on-keydown="onKeydown_"
      on-keyup="onKeyup_"
      disabled="[[shouldDisableToggle_]]"
      aria-label="[[getAriaLabel_()]]"
      aria-description="[[ariaDescription_]]">
  </cr-toggle>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CAMERA_SUBPAGE_USER_ACTION_HISTOGRAM_NAME = 'ChromeOS.PrivacyHub.CameraSubpage.UserAction';
const MICROPHONE_SUBPAGE_USER_ACTION_HISTOGRAM_NAME = 'ChromeOS.PrivacyHub.MicrophoneSubpage.UserAction';
const LOCATION_PERMISSION_CHANGE_FROM_SETTINGS_HISTOGRAM_NAME = 'ChromeOS.PrivacyHub.Geolocation.AccessLevelChanged.SystemSettings';
const LOCATION_PERMISSION_CHANGE_FROM_DIALOG_HISTOGRAM_NAME = 'ChromeOS.PrivacyHub.Geolocation.AccessLevelChanged.GeolocationDialog';
/**
 * Enumeration of the user actions that can be taken on the Privacy Hub sensor
 * subpages.
 * This enum is tied directly to a UMA enum defined in
 * //tools/metrics/histograms/metadata/chromeos/enums.xml, and should always
 * reflect it (do not change one without changing the other).
 * These values are persisted to logs. Entries should not be renumbered and
 * numeric values should never be reused.
 */
var PrivacyHubSensorSubpageUserAction;
(function (PrivacyHubSensorSubpageUserAction) {
    PrivacyHubSensorSubpageUserAction[PrivacyHubSensorSubpageUserAction["SUBPAGE_OPENED"] = 0] = "SUBPAGE_OPENED";
    PrivacyHubSensorSubpageUserAction[PrivacyHubSensorSubpageUserAction["SYSTEM_ACCESS_CHANGED"] = 1] = "SYSTEM_ACCESS_CHANGED";
    PrivacyHubSensorSubpageUserAction[PrivacyHubSensorSubpageUserAction["APP_PERMISSION_CHANGED"] = 2] = "APP_PERMISSION_CHANGED";
    PrivacyHubSensorSubpageUserAction[PrivacyHubSensorSubpageUserAction["ANDROID_SETTINGS_LINK_CLICKED"] = 3] = "ANDROID_SETTINGS_LINK_CLICKED";
    PrivacyHubSensorSubpageUserAction[PrivacyHubSensorSubpageUserAction["WEBSITE_PERMISSION_LINK_CLICKED"] = 4] = "WEBSITE_PERMISSION_LINK_CLICKED";
})(PrivacyHubSensorSubpageUserAction || (PrivacyHubSensorSubpageUserAction = {}));
const NUMBER_OF_POSSIBLE_USER_ACTIONS = Object.keys(PrivacyHubSensorSubpageUserAction).length;

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'settings-privacy-hub-app-permission-row' is a custom row element
 * representing an app. This is used in the subpages of the OS Settings Privacy
 * controls page.
 */
function getPermissionValueAsTriState$1(permission) {
    if (isTriStateValue(permission.value)) {
        return castExists$2(permission.value.tristateValue);
    }
    return permission.value.boolValue ? TriState.kAllow : TriState.kBlock;
}
const SettingsPrivacyHubAppPermissionRowBase = I18nMixin(PolymerElement);
class SettingsPrivacyHubAppPermissionRow extends SettingsPrivacyHubAppPermissionRowBase {
    static get is() {
        return 'settings-privacy-hub-app-permission-row';
    }
    static get template() {
        return getTemplate$1s();
    }
    static get properties() {
        return {
            app: {
                type: Object,
            },
            /**
             * A string version of the permission type. Must be a value of the
             * permission type enum in appManagement.mojom.PermissionType.
             */
            permissionType: {
                type: String,
                reflectToAttribute: true,
            },
            /**
             * Boolean state indicator for the value of the permission of type
             * `this.permissionType`.
             *
             * `TriState.kAllow` maps to `true`.
             * `TriState.kAsk` and `TriState.kBlock` maps to `false`.
             */
            checked_: {
                type: Boolean,
                value: false,
            },
            /**
             * A text describing the permission value.
             */
            permissionText_: {
                type: String,
                value: '',
            },
            isPermissionManaged_: {
                type: Boolean,
                value: false,
            },
            shouldRedirectToAndroidSettings_: {
                type: Boolean,
                computed: 'computeShouldRedirectToAndroidSettings_(app.type, ' +
                    'isPermissionManaged_)',
            },
            shouldDisableToggle_: {
                type: Boolean,
                computed: 'computeShouldDisableToggle_(isPermissionManaged_, ' +
                    'shouldRedirectToAndroidSettings_)',
            },
            ariaDescription_: {
                type: String,
                computed: 'computeAriaDescription_(permissionText_)',
            },
            androidSettingsLinkAriaDescription_: {
                type: String,
                computed: 'computeAndroidSettingsLinkAriaDescription_(permissionText_)',
            },
        };
    }
    static get observers() {
        return ['onPermissionChange_(app.permissions.*)'];
    }
    constructor() {
        super();
        this.mojoInterfaceProvider_ = getAppPermissionProvider();
    }
    ready() {
        super.ready();
        this.addEventListener('click', this.onPermissionRowClick_.bind(this));
    }
    onPermissionChange_() {
        const permission = castExists$2(this.app.permissions[PermissionType[this.permissionType]]);
        this.checked_ = isPermissionEnabled(permission.value);
        this.isPermissionManaged_ = permission.isManaged;
        const value = getPermissionValueAsTriState$1(permission);
        if (value === TriState.kAllow && permission.details) {
            this.permissionText_ = this.i18n('privacyHubPermissionAllowedTextWithDetails', permission.details);
            return;
        }
        switch (value) {
            case TriState.kAllow:
                this.permissionText_ = this.i18n('privacyHubPermissionAllowedText');
                break;
            case TriState.kBlock:
                this.permissionText_ = this.i18n('privacyHubPermissionDeniedText');
                break;
            case TriState.kAsk:
                this.permissionText_ = this.i18n('privacyHubPermissionAskText');
                break;
        }
    }
    getUserActionHistogramName() {
        return `ChromeOS.PrivacyHub.${this.permissionType.substring(1)}Subpage.UserAction`;
    }
    togglePermissionState_() {
        const permission = castExists$2(this.app.permissions[PermissionType[this.permissionType]]);
        const permissionEnabled = isPermissionEnabled(permission.value);
        if (isBoolValue(permission.value)) {
            permission.value = createBoolPermissionValue(!permissionEnabled);
        }
        else if (isTriStateValue(permission.value)) {
            permission.value = createTriStatePermissionValue(permissionEnabled ? TriState.kBlock : TriState.kAllow);
        }
        this.mojoInterfaceProvider_.setPermission(this.app.id, permission);
        chrome.metricsPrivate.recordEnumerationValue(this.getUserActionHistogramName(), PrivacyHubSensorSubpageUserAction.APP_PERMISSION_CHANGED, NUMBER_OF_POSSIBLE_USER_ACTIONS);
    }
    onPermissionRowClick_() {
        if (this.isPermissionManaged_) {
            return;
        }
        if (this.shouldRedirectToAndroidSettings_) {
            this.mojoInterfaceProvider_.openNativeSettings(this.app.id);
            chrome.metricsPrivate.recordEnumerationValue(this.getUserActionHistogramName(), PrivacyHubSensorSubpageUserAction.ANDROID_SETTINGS_LINK_CLICKED, Object.keys(PrivacyHubSensorSubpageUserAction).length);
            return;
        }
        this.togglePermissionState_();
    }
    onToggleClick_(e) {
        e.stopImmediatePropagation();
        e.preventDefault();
        this.togglePermissionState_();
    }
    onKeyup_(e) {
        if (e.key !== ' ') {
            return;
        }
        e.stopImmediatePropagation();
        e.preventDefault();
        this.togglePermissionState_();
    }
    onKeydown_(e) {
        if (e.key !== 'Enter') {
            return;
        }
        e.stopImmediatePropagation();
        e.preventDefault();
        if (e.repeat) {
            return;
        }
        this.togglePermissionState_();
    }
    computeShouldRedirectToAndroidSettings_() {
        return !this.isPermissionManaged_ &&
            loadTimeData.getBoolean('isArcReadOnlyPermissionsEnabled') &&
            this.app.type === AppType.kArc;
    }
    computeShouldDisableToggle_() {
        return this.isPermissionManaged_ || this.shouldRedirectToAndroidSettings_;
    }
    getAriaLabel_() {
        switch (PermissionType[this.permissionType]) {
            case PermissionType.kCamera:
                return this.i18n('privacyHubCameraAppPermissionRowAriaLabel', this.app.name);
            case PermissionType.kLocation:
                return this.i18n('privacyHubLocationAppPermissionRowAriaLabel', this.app.name);
            case PermissionType.kMicrophone:
                return this.i18n('privacyHubMicrophoneAppPermissionRowAriaLabel', this.app.name);
            default:
                return '';
        }
    }
    computeAriaDescription_() {
        return this.i18n('privacyHubAppPermissionRowAriaDescription', this.permissionText_);
    }
    computeAndroidSettingsLinkAriaDescription_() {
        return this.i18n('privacyHubAppPermissionRowAndroidSettingsLinkAriaDescription', this.permissionText_);
    }
}
customElements.define(SettingsPrivacyHubAppPermissionRow.is, SettingsPrivacyHubAppPermissionRow);

function getTemplate$1r() {
    return html `<!--_html_template_start_--><style include="cros-color-overrides">:host{--justify-margin:8px;align-items:center;display:flex}:host([enforced_]){pointer-events:none}cr-policy-pref-indicator{pointer-events:all}:host(:not([end-justified])) cr-policy-pref-indicator{margin-inline-start:var(--cr-controlled-by-spacing)}:host([end-justified]) cr-policy-pref-indicator{margin-inline-end:var(--cr-controlled-by-spacing);margin-inline-start:calc(var(--cr-controlled-by-spacing) - var(--justify-margin));order:-1}</style>

<cr-button class$="[[actionClass_]]"
    disabled="[[!buttonEnabled_(enforced_, disabled)]]">
  [[label]]
</cr-button>

<template is="dom-if" if="[[hasPrefPolicyIndicator(pref.*)]]" restamp>
  <cr-policy-pref-indicator pref="[[pref]]" on-click="onIndicatorClick_"
      icon-aria-label="[[label]]">
  </cr-policy-pref-indicator>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const ControlledButtonElementBase = CrPolicyPrefMixin(PrefControlMixin(PolymerElement));
class ControlledButtonElement extends ControlledButtonElementBase {
    static get is() {
        return 'controlled-button';
    }
    static get template() {
        return getTemplate$1r();
    }
    static get properties() {
        return {
            endJustified: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
            },
            label: String,
            disabled: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
            },
            actionClass_: { type: String, value: '' },
            enforced_: {
                type: Boolean,
                computed: 'isPrefEnforced(pref.*)',
                reflectToAttribute: true,
            },
        };
    }
    connectedCallback() {
        super.connectedCallback();
        if (this.classList.contains('action-button')) {
            this.actionClass_ = 'action-button';
        }
    }
    /** Focus on the inner cr-button. */
    focus() {
        this.shadowRoot.querySelector('cr-button').focus();
    }
    onIndicatorClick_(e) {
        // Disallow <controlled-button on-click="..."> when controlled.
        e.preventDefault();
        e.stopPropagation();
    }
    buttonEnabled_(enforced, disabled) {
        return !enforced && !disabled;
    }
}
customElements.define(ControlledButtonElement.is, ControlledButtonElement);

const template$8 = html `<!--
<iron-icon> is used to render many SVG images that may or may not be icons
(e.g. illustrations, etc.). Include SVGs under the most appropriate
<iron-iconset-svg> below:
  - os-settings: icons, small square images
  - os-settings-illo: illustrations, larger images
-->

<!--
NOTE: Most icons should be exported at 20x20px. For icons that are not 20x20px,
ensure viewBox is specified.

Many legacy icons were exported at 24px and use viewBox to scale down to 20px.
These icons may appear blurry.
-->
<iron-iconset-svg name="os-settings" size="20">
  <svg>
    <defs>
      <!-- A11y page section -->
      <g id="accessibility" viewBox="0 0 20 20"><path d="M10.03 5.76A1.81 1.81 0 0 1 8.7 5.208 1.81 1.81 0 0 1 8.15 3.88c0-.518.184-.96.552-1.328A1.81 1.81 0 0 1 10.03 2c.518 0 .96.184 1.329.552.367.368.551.81.551 1.328s-.184.96-.551 1.328a1.81 1.81 0 0 1-1.329.552ZM7.372 18V8.62a16.886 16.886 0 0 1-2.187-.306A57.218 57.218 0 0 1 3 7.762l.47-1.675c1.09.3 2.18.524 3.27.674 1.103.15 2.2.225 3.29.225 1.09 0 2.186-.075 3.29-.225a25.937 25.937 0 0 0 3.31-.674l.429 1.675c-.763.191-1.499.368-2.207.532-.695.163-1.417.279-2.166.347V18h-1.819l-.184-4.659H9.396L9.192 18h-1.82Z"/></g>
      <g id="a11y-image-description" viewBox="0 0 20 20">
        <path fill-rule="evenodd" d="M5.417 14.063h9.166L11.5 9.896l-2.25 3-1.5-2-2.333 3.166Zm.146-3.5c1.388 0 2.569-.487 3.541-1.459.972-.972 1.459-2.153 1.459-3.541h-1.5c0 .972-.34 1.798-1.021 2.479-.68.68-1.507 1.02-2.48 1.02v1.5Zm0-3c.555 0 1.027-.195 1.416-.584.39-.389.583-.86.583-1.416h-2v2Zm-1 9.604c-.487 0-.896-.167-1.23-.5a1.716 1.716 0 0 1-.5-1.23V4.563c0-.473.167-.875.5-1.209.334-.347.743-.52 1.23-.52h10.875c.486 0 .895.173 1.229.52.333.333.5.736.5 1.209v10.875c0 .472-.167.881-.5 1.229-.334.333-.743.5-1.23.5H4.563Zm0-1.73h10.875V4.563H4.563v10.875Zm0 0V4.563v10.875Z"></path>
      </g>
      <g id="text-to-speech" viewBox="0 0 16 16">
        <path fill-rule="evenodd" d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0Zm-5.335-3.549a33.45 33.45 0 0 0-.762.79l.039.042c.696.775 1.467 1.633 1.413 2.738.068 1.127-.67 2.053-1.434 2.805.216.286.434.57.653.855 1.258-.839 2.037-2.313 1.937-3.812-.02-1.355-.798-2.58-1.846-3.418Zm3.772 5.35a6.562 6.562 0 0 1-2.562 3.566c-.233-.31-.458-.624-.678-.942l.205-.203c.524-.519 1.054-1.044 1.404-1.694.869-1.564.818-3.568-.099-5.102-.309-.514-.735-.943-1.158-1.37a31.85 31.85 0 0 1-.306-.311c.233-.306.467-.61.704-.914 2.263 1.469 3.192 4.445 2.49 6.97ZM6.768 1.68c-.11-.003-.225-.008-.345-.014-2.921.698-5.09 3.281-5.09 6.361 0 2.658 1.614 4.946 3.934 5.972a23.226 23.226 0 0 1 1.48-.387c.206-1.043.328-2.1.379-3.162-.481-.277-.981-.52-1.481-.763-.228-.11-.456-.221-.682-.335l.557-.104c.652-.12 1.305-.24 1.946-.416l.042-.633c.02-.295.038-.59.061-.886a61.936 61.936 0 0 1 1.548-.978 11.89 11.89 0 0 0-.812-1.77c-.203-.367-.39-.742-.576-1.117-.3-.6-.599-1.2-.96-1.767Z" clip-rule="evenodd"></path>
      </g>
      <g id="a11y-keyboard-and-text-input" viewBox="0 0 14 8">
        <path fill-rule="evenodd" d="M3 7.75v-1.5h8v1.5H3Zm-2.75-3v-1.5h1.5v1.5H.25Zm3 0v-1.5h1.5v1.5h-1.5Zm3 0v-1.5h1.5v1.5h-1.5Zm3 0v-1.5h1.5v1.5h-1.5Zm3 0v-1.5h1.5v1.5h-1.5Zm-12-3V.25h1.5v1.5H.25Zm3 0V.25h1.5v1.5h-1.5Zm3 0V.25h1.5v1.5h-1.5Zm3 0V.25h1.5v1.5h-1.5Zm3 0V.25h1.5v1.5h-1.5Z"></path>
      </g>
      <g id="a11y-hearing" viewBox="0 0 16 18">
        <path fill-rule="evenodd" d="M12.167 17.146c-.945 0-1.667-.292-2.167-.875a5.825 5.825 0 0 1-1.104-2.042 9.489 9.489 0 0 0-.667-1.604c-.222-.444-.666-.847-1.333-1.208A5.187 5.187 0 0 1 4.77 9.375 5.648 5.648 0 0 1 4 6.5c0-1.556.542-2.875 1.625-3.958C6.722 1.458 8.049.917 9.605.917c1.569 0 2.895.555 3.978 1.666 1.098 1.111 1.646 2.466 1.646 4.063H13.5c0-1.111-.382-2.056-1.146-2.833-.75-.778-1.66-1.167-2.729-1.167-1.083 0-2.007.375-2.77 1.125-.75.75-1.126 1.66-1.126 2.729 0 .722.188 1.396.563 2.02a3.83 3.83 0 0 0 1.52 1.418c.848.444 1.424.923 1.73 1.437.32.514.639 1.264.958 2.25.222.667.465 1.132.73 1.396.277.264.582.396.916.396.375 0 .694-.146.958-.438.264-.291.396-.646.396-1.062h1.73c0 .916-.3 1.687-.897 2.312a2.918 2.918 0 0 1-2.166.917ZM3.313 12.75a9.161 9.161 0 0 1-1.896-2.875A9.003 9.003 0 0 1 .77 6.521c0-1.14.215-2.25.646-3.333A9.096 9.096 0 0 1 3.313.292L4.5 1.52a7.644 7.644 0 0 0-1.48 2.333A7.068 7.068 0 0 0 2.5 6.52c0 .917.174 1.812.52 2.687a7.454 7.454 0 0 0 1.5 2.334L3.314 12.75Zm6.312-4.23a1.929 1.929 0 0 1-1.417-.582 1.929 1.929 0 0 1-.583-1.417c0-.556.194-1.028.583-1.417a1.929 1.929 0 0 1 1.417-.583c.556 0 1.028.194 1.417.583.389.39.583.861.583 1.417a1.93 1.93 0 0 1-.583 1.417 1.929 1.929 0 0 1-1.417.583Z"></path>
      </g>
      <g id="a11y-find-more" viewBox="0 0 19 17">
        <path fill-rule="evenodd" d="M8 3.708c-.5 0-.93-.173-1.292-.52a1.787 1.787 0 0 1-.541-1.313c0-.5.18-.924.541-1.27A1.763 1.763 0 0 1 8 .061c.5 0 .93.181 1.292.542.36.347.541.778.541 1.292 0 .5-.18.93-.541 1.292A1.8 1.8 0 0 1 8 3.707Zm5.104 9.313c.528 0 .972-.18 1.334-.542.374-.36.562-.805.562-1.333a1.78 1.78 0 0 0-.562-1.334 1.778 1.778 0 0 0-1.334-.562c-.528 0-.972.18-1.333.542a1.812 1.812 0 0 0-.542 1.333c0 .528.18.98.542 1.354.36.361.805.542 1.333.542Zm3.938 3.27-2.063-2.062c-.278.18-.576.313-.896.396-.32.083-.646.125-.979.125-1 0-1.854-.347-2.562-1.042C9.847 13 9.5 12.138 9.5 11.125c0-1 .347-1.847 1.042-2.542a3.492 3.492 0 0 1 2.562-1.062c1 0 1.854.354 2.563 1.062.708.695 1.062 1.542 1.062 2.542 0 .333-.048.667-.146 1-.083.32-.208.618-.375.896l2.063 2.041-1.23 1.23Zm-8.105-.229v-1.979c.209.32.452.604.73.854.291.25.597.473.916.667v.459H8.937Zm-3.52 0V6.459c-.764-.07-1.521-.18-2.271-.333a42.886 42.886 0 0 1-2.208-.562l.416-1.521c1.084.291 2.18.52 3.292.687a24.596 24.596 0 0 0 6.708 0 29.184 29.184 0 0 0 3.313-.687l.416 1.52c-.736.237-1.479.424-2.229.563-.75.125-1.507.23-2.27.313v.229A5.157 5.157 0 0 0 8.707 8.5C8.236 9.278 8 10.146 8 11.104v-.041c0-.028-.007-.05-.02-.063h-.918v5.063H5.418Z"></path>
      </g>
      <g id="chevron-left" viewBox="0 0 20 21">
        <path fill-rule="evenodd" d="m14 6.178-4.945 4.59L14 15.358l-1.522 1.41-6.478-6 6.478-6L14 6.178Z" clip-rule="evenodd"></path>
      </g>
      <g id="chevron-right" viewBox="0 0 20 21">
        <path fill-rule="evenodd" d="m6 6.178 4.945 4.59L6 15.358l1.522 1.41 6.478-6-6.478-6L6 6.178Z" clip-rule="evenodd"></path>
      </g>
      <g id="a11y-contact-support" viewBox="0 -960 960 960">
        <path fill-rule="evenodd" d="m480-80-10-120h-10q-142 0-241-99t-99-241q0-142 99-241t241-99q71 0 132.5 26.5t108 73q46.5 46.5 73 108T800-540q0 75-24.5 144t-67 128q-42.5 59-101 107T480-80Zm80-146q71-60 115.5-140.5T720-540q0-109-75.5-184.5T460-800q-109 0-184.5 75.5T200-540q0 109 75.5 184.5T460-280h100v54Zm-101-95q17 0 29-12t12-29q0-17-12-29t-29-12q-17 0-29 12t-12 29q0 17 12 29t29 12Zm-29-127h60q0-30 6-42t38-44q18-18 30-39t12-45q0-51-34.5-76.5T460-720q-44 0-74 24.5T344-636l56 22q5-17 19-33.5t41-16.5q27 0 40.5 15t13.5 33q0 17-10 30.5T480-558q-35 30-42.5 47.5T430-448Zm30-65Z"></path>
      </g>

      <!-- Apps page section -->
      <g id="apps-notifications" viewBox="0 0 18 18">
        <path fill-rule="evenodd" d="M.833 9c0-1.139.209-2.201.625-3.187a8.327 8.327 0 0 1 1.75-2.584 8.112 8.112 0 0 1 2.605-1.75c1-.43 2.062-.646 3.187-.646.361 0 .715.021 1.063.063.36.041.708.11 1.041.208a3.602 3.602 0 0 0-.583.708 4.43 4.43 0 0 0-.417.855 3.164 3.164 0 0 0-.541-.084A7.9 7.9 0 0 0 9 2.563c-1.792 0-3.312.624-4.562 1.874C3.188 5.688 2.563 7.209 2.563 9c0 1.792.624 3.313 1.874 4.563 1.25 1.25 2.771 1.874 4.563 1.874 1.792 0 3.313-.624 4.563-1.874 1.25-1.25 1.874-2.771 1.874-4.563 0-.18-.006-.368-.02-.562a3.16 3.16 0 0 0-.084-.542c.306-.111.59-.25.854-.417.264-.167.5-.36.709-.583.097.333.166.68.208 1.042.042.347.063.7.063 1.062a7.974 7.974 0 0 1-.646 3.188c-.417.986-1 1.854-1.75 2.604a8.328 8.328 0 0 1-2.584 1.75A8.106 8.106 0 0 1 9 17.167a8.205 8.205 0 0 1-3.187-.625 8.59 8.59 0 0 1-2.605-1.75 8.589 8.589 0 0 1-1.75-2.604A8.204 8.204 0 0 1 .833 9ZM14 6.625a2.53 2.53 0 0 1-1.854-.77A2.528 2.528 0 0 1 11.375 4c0-.722.257-1.34.77-1.854A2.528 2.528 0 0 1 14 1.375c.722 0 1.34.257 1.854.77.514.515.771 1.133.771 1.855s-.257 1.34-.77 1.854A2.528 2.528 0 0 1 14 6.625Z"></path>
      </g>
      <g id="google-play" viewBox="0 0 18 20">
        <path fill-rule="evenodd" d="M7.063 10.604a.836.836 0 0 0 .229-.583.734.734 0 0 0-.25-.563L2.354 4.771v10.604l4.709-4.77Zm1.145-2.312c.153.166.34.25.563.25.222 0 .41-.084.562-.25l1.75-1.75L4 2.458a1.06 1.06 0 0 0-.77-.125c-.279.042-.494.146-.647.313l5.625 5.646Zm-4.25 9.27 7.105-4.083-1.73-1.708a.765.765 0 0 0-.562-.23.836.836 0 0 0-.584.23l-5.583 5.604c.195.194.403.306.625.333.236.028.48-.02.73-.145Zm8.584-4.895L15.354 11a1.8 1.8 0 0 0 .438-.417.991.991 0 0 0 .166-.562.957.957 0 0 0-.166-.542 1.145 1.145 0 0 0-.438-.416l-2.791-1.667L10.5 9.479a.836.836 0 0 0-.23.584c0 .222.077.41.23.562l2.042 2.042Zm-9.146 6.666c-.778 0-1.43-.264-1.958-.791a2.647 2.647 0 0 1-.771-1.917V3.395c0-.75.257-1.388.77-1.916.529-.542 1.182-.812 1.96-.812.25 0 .493.034.729.104.236.07.465.166.688.292L16.23 7.646c.43.236.771.562 1.021.979.264.417.396.875.396 1.375s-.132.965-.396 1.396a2.73 2.73 0 0 1-1.062 1L4.77 18.958a2.48 2.48 0 0 1-.646.292 3.17 3.17 0 0 1-.73.083Z"></path>
      </g>
      <g id="apps-android-settings" viewBox="0 0 20 20">
        <path fill-rule="evenodd" d="M7.438 12.417a.862.862 0 0 1-.605-.23.823.823 0 0 1-.25-.604c0-.236.077-.437.23-.604a.823.823 0 0 1 .604-.25c.236 0 .444.084.625.25.18.153.27.354.27.604 0 .236-.09.438-.27.604a.862.862 0 0 1-.604.23Zm5.125 0a.94.94 0 0 1-.626-.23.823.823 0 0 1-.25-.604c0-.236.084-.437.25-.604a.848.848 0 0 1 .626-.25c.236 0 .437.084.604.25.166.167.25.368.25.604a.824.824 0 0 1-.25.604.862.862 0 0 1-.604.23Zm-9.355 3.875a1.53 1.53 0 0 1-1.125-.459 1.53 1.53 0 0 1-.458-1.125V5.292c0-.43.153-.799.458-1.104.306-.32.68-.48 1.125-.48h13.584c.43 0 .798.16 1.104.48.32.305.479.673.479 1.104v9.416c0 .445-.16.82-.48 1.125a1.505 1.505 0 0 1-1.103.459H3.208Zm.5-1.584h12.584v-1.146a5.763 5.763 0 0 0-.771-2.937 6.973 6.973 0 0 0-2-2.27L15 6.5a.481.481 0 0 0 .104-.417.535.535 0 0 0-.208-.396.666.666 0 0 0-.438-.104.471.471 0 0 0-.375.209l-1.562 2.02a5.298 5.298 0 0 0-1.23-.395A5.848 5.848 0 0 0 10 7.27a6.1 6.1 0 0 0-2.583.563L5.854 5.791a.535.535 0 0 0-.396-.209.59.59 0 0 0-.416.104.532.532 0 0 0-.23.375.502.502 0 0 0 .146.417l1.48 1.917a7.047 7.047 0 0 0-2 2.25 5.98 5.98 0 0 0-.73 2.916v1.146Z"></path>
      </g>
      <g id="apps-manage-isolated-web-apps" viewBox="0 0 20 20">
        <path fill-rule="evenodd" d="M3.646 16.396a2.02 2.02 0 0 1-1.458-.584 2.023 2.023 0 0 1-.584-1.458V5.625c0-.57.195-1.049.583-1.437a2.023 2.023 0 0 1 1.459-.584h12.708c.57 0 1.049.202 1.438.604.402.39.604.868.604 1.438v8.729a1.92 1.92 0 0 1-.604 1.438 1.953 1.953 0 0 1-1.438.583H3.646Zm0-2.042h8.208v-2.5H3.646v2.5Zm9.708 0h3v-6.5h-3v6.5Zm-9.708-4h8.208v-2.5H3.646v2.5Z"></path>
      </g>
      <g id="apps-parental-controls" viewBox="0 -960 960 960">
        <path fill-rule="evenodd" d="M480-48q-182.62 0-307.31-67T48-281.81Q48-350 112-406t176-86v75q-77 23-122.5 59.83T120-282.48Q120-217 227.5-168.5T480-120q145 0 252.5-48.73T840-282.44Q840-320 794.5-357T672-417v-75q111 29 175.5 85.69 64.5 56.7 64.5 124.73Q912-182 787.31-115 662.62-48 480-48ZM360-192v-408H192v-72h576v72H600v408h-72v-192h-96v192h-72Zm119.75-540q-34.75 0-59.25-24.75t-24.5-59.5q0-34.75 24.75-59.25t59.5-24.5q34.75 0 59.25 24.75t24.5 59.5q0 34.75-24.75 59.25t-59.5 24.5Z"></path>
      </g>

      <!-- About page section -->
      <g id="counter-1">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M2 10C2 5.584 5.584 2 10 2C14.416 2 18 5.584 18 10C18 14.416 14.416 18 10 18C5.584 18 2 14.416 2 10ZM9.59448 14H11.1467V6.16895H10.9802L7.74146 7.3291V8.59131L9.59448 8.0166V14Z"></path>
      </g>
      <g id="counter-2">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M2 10C2 5.584 5.584 2 10 2C14.416 2 18 5.584 18 10C18 14.416 14.416 18 10 18C5.584 18 2 14.416 2 10ZM7.37622 14H12.7366V12.7485H9.37427L11.1521 10.874C11.6391 10.3405 11.9828 9.87321 12.1833 9.47217C12.3839 9.07112 12.4841 8.67725 12.4841 8.29053C12.4841 7.58512 12.2612 7.03906 11.8154 6.65234C11.3696 6.26562 10.7439 6.07227 9.93823 6.07227C9.41186 6.07227 8.941 6.18416 8.52563 6.40796C8.11027 6.63176 7.7889 6.94059 7.56152 7.33447C7.33415 7.72835 7.22046 8.16341 7.22046 8.63965H8.77808C8.77808 8.24577 8.87923 7.92798 9.08154 7.68628C9.28385 7.44458 9.56046 7.32373 9.91138 7.32373C10.2372 7.32373 10.4879 7.42309 10.6633 7.62183C10.8388 7.82056 10.9265 8.09359 10.9265 8.44092C10.9265 8.69515 10.8433 8.9637 10.6768 9.24658C10.5103 9.52946 10.2533 9.86068 9.90601 10.2402L7.37622 12.9365V14Z"></path>
      </g>
      <g id="counter-3">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M2 10C2 5.584 5.584 2 10 2C14.416 2 18 5.584 18 10C18 14.416 14.416 18 10 18C5.584 18 2 14.416 2 10ZM9.78247 9.40234H8.95532V10.6162H9.7771C10.6365 10.6162 11.0662 11.0065 11.0662 11.7871C11.0662 12.1094 10.9614 12.3681 10.752 12.5632C10.5425 12.7584 10.2533 12.856 9.88452 12.856C9.56225 12.856 9.29102 12.7629 9.0708 12.5767C8.85058 12.3905 8.74048 12.1506 8.74048 11.8569H7.18823C7.18823 12.5337 7.4362 13.078 7.93213 13.4897C8.42806 13.9015 9.06632 14.1074 9.84692 14.1074C10.6812 14.1074 11.3517 13.898 11.8584 13.479C12.3651 13.0601 12.6184 12.5033 12.6184 11.8086C12.6184 11.3789 12.5101 11.0065 12.2935 10.6914C12.0768 10.3763 11.7483 10.14 11.3079 9.98242C11.6624 9.82129 11.9488 9.59033 12.1672 9.28955C12.3857 8.98877 12.4949 8.65934 12.4949 8.30127C12.4949 7.6066 12.2603 7.06144 11.7913 6.66577C11.3222 6.2701 10.6741 6.07227 9.84692 6.07227C9.37068 6.07227 8.93474 6.16357 8.53906 6.34619C8.14339 6.52881 7.83545 6.78214 7.61523 7.1062C7.39502 7.43026 7.28491 7.79638 7.28491 8.20459H8.83716C8.83716 7.9432 8.93742 7.73104 9.13794 7.56812C9.33846 7.40519 9.58732 7.32373 9.88452 7.32373C10.214 7.32373 10.4727 7.41146 10.6606 7.58691C10.8486 7.76237 10.9426 8.00765 10.9426 8.32275C10.9426 8.6486 10.8477 8.90999 10.658 9.10693C10.4682 9.30387 10.1764 9.40234 9.78247 9.40234Z"></path>
      </g>
      <g id="counter-4">
        <path d="M10.4163 11.0566H8.68677L10.3142 8.47314L10.4163 8.2959V11.0566Z"></path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M10 2C5.584 2 2 5.584 2 10C2 14.416 5.584 18 10 18C14.416 18 18 14.416 18 10C18 5.584 14.416 2 10 2ZM11.9685 11.0566H12.8547V12.3081H11.9685V14H10.4163V12.3081H7.20972L7.13989 11.3306L10.4001 6.17969H11.9685V11.0566Z"></path>
      </g>
      <g id="counter-5">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M2 10C2 5.584 5.584 2 10 2C14.416 2 18 5.584 18 10C18 14.416 14.416 18 10 18C5.584 18 2 14.416 2 10ZM8.05835 6.17969L7.60718 10.1543L8.84253 10.4604L8.99292 10.3208C9.22209 10.1274 9.52108 10.0308 9.88989 10.0308C10.2909 10.0308 10.6007 10.1489 10.8191 10.3853C11.0375 10.6216 11.1467 10.9617 11.1467 11.4058C11.1467 11.8677 11.0518 12.2249 10.8621 12.4773C10.6723 12.7297 10.4019 12.856 10.051 12.856C9.73592 12.856 9.4808 12.7655 9.28564 12.5847C9.09049 12.4039 8.97681 12.1506 8.94458 11.8247H7.40845C7.42277 12.2687 7.5472 12.6644 7.78174 13.0117C8.01628 13.3591 8.33585 13.6285 8.74048 13.8201C9.1451 14.0116 9.58374 14.1074 10.0564 14.1074C10.5971 14.1074 11.0662 13.9973 11.4636 13.7771C11.8611 13.5569 12.1663 13.2472 12.3794 12.8479C12.5924 12.4486 12.699 11.9966 12.699 11.4917C12.699 10.661 12.4877 10.0147 12.0652 9.55273C11.6427 9.09082 11.059 8.85986 10.3142 8.85986C9.89884 8.85986 9.50676 8.95833 9.13794 9.15527L9.3313 7.47412H12.4412V6.17969H8.05835Z"></path>
      </g>
      <g id="counter-6">
        <path d="M9.39038 10.2107C9.59448 10.08 9.82186 10.0146 10.0725 10.0146C10.4234 10.0146 10.7027 10.1453 10.9104 10.4067C11.1181 10.6681 11.2219 11.0119 11.2219 11.438C11.2219 11.8569 11.119 12.198 10.9131 12.4612C10.7072 12.7244 10.4377 12.856 10.1047 12.856C9.73592 12.856 9.44946 12.71 9.24536 12.4182C9.04126 12.1264 8.93921 11.7209 8.93921 11.2017V10.729C9.03589 10.5142 9.18628 10.3414 9.39038 10.2107Z"></path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M10 2C5.584 2 2 5.584 2 10C2 14.416 5.584 18 10 18C14.416 18 18 14.416 18 10C18 5.584 14.416 2 10 2ZM11.5872 6.09912V7.37744H11.4368C10.7349 7.38818 10.1701 7.5708 9.74219 7.92529C9.31429 8.27979 9.05737 8.77213 8.97144 9.40234C9.3868 8.97982 9.91137 8.76855 10.5452 8.76855C11.2255 8.76855 11.7662 9.01204 12.1672 9.49902C12.5683 9.986 12.7688 10.6269 12.7688 11.4219C12.7688 11.9303 12.6587 12.3905 12.4385 12.8022C12.2183 13.214 11.9067 13.5345 11.5039 13.7637C11.1011 13.9928 10.6454 14.1074 10.137 14.1074C9.31339 14.1074 8.64828 13.821 8.1416 13.248C7.63493 12.6751 7.38159 11.9106 7.38159 10.9546V10.396C7.38159 9.54736 7.54183 8.7981 7.8623 8.14819C8.18278 7.49829 8.6429 6.9952 9.24268 6.63892C9.84245 6.28263 10.538 6.1027 11.3293 6.09912H11.5872Z"></path>
      </g>
      <g id="counter-7">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M2 10C2 5.584 5.584 2 10 2C14.416 2 18 5.584 18 10C18 14.416 14.416 18 10 18C5.584 18 2 14.416 2 10ZM9.66968 14L12.6936 7.0498V6.17969H7.17212V7.43652H11.0608L8.03149 14H9.66968Z"></path>
      </g>
      <g id="counter-8">
        <path d="M11.0823 11.7441C11.0823 11.404 10.9838 11.1318 10.7869 10.9277C10.5899 10.7236 10.325 10.6216 9.99194 10.6216C9.66251 10.6216 9.39933 10.7227 9.20239 10.925C9.00545 11.1274 8.90698 11.4004 8.90698 11.7441C8.90698 12.0772 9.00366 12.3457 9.19702 12.5498C9.39038 12.7539 9.65893 12.856 10.0027 12.856C10.3393 12.856 10.6034 12.7575 10.7949 12.5605C10.9865 12.3636 11.0823 12.0915 11.0823 11.7441Z"></path>
        <path d="M10.6794 7.60034C10.8406 7.78475 10.9211 8.02913 10.9211 8.3335C10.9211 8.64502 10.8415 8.89567 10.6821 9.08545C10.5228 9.27523 10.2963 9.37012 10.0027 9.37012C9.70906 9.37012 9.48169 9.27523 9.32056 9.08545C9.15942 8.89567 9.07886 8.64502 9.07886 8.3335C9.07886 8.01839 9.15942 7.77132 9.32056 7.59229C9.48169 7.41325 9.70727 7.32373 9.99731 7.32373C10.2909 7.32373 10.5183 7.41593 10.6794 7.60034Z"></path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M2 10C2 5.584 5.584 2 10 2C14.416 2 18 5.584 18 10C18 14.416 14.416 18 10 18C5.584 18 2 14.416 2 10ZM12.1887 9.26807C12.3785 8.97445 12.4734 8.63786 12.4734 8.2583C12.4734 7.58512 12.2505 7.05249 11.8047 6.6604C11.3589 6.26831 10.7564 6.07227 9.99731 6.07227C9.23462 6.07227 8.63127 6.2701 8.18726 6.66577C7.74324 7.06144 7.52124 7.59228 7.52124 8.2583C7.52124 8.63786 7.61523 8.97445 7.80322 9.26807C7.99121 9.56169 8.25171 9.79622 8.58472 9.97168C8.20874 10.1507 7.90975 10.4014 7.68774 10.7236C7.46574 11.0459 7.35474 11.4237 7.35474 11.8569C7.35474 12.548 7.59285 13.0959 8.06909 13.5005C8.54533 13.9051 9.18986 14.1074 10.0027 14.1074C10.8155 14.1074 11.4583 13.906 11.9309 13.5032C12.4036 13.1003 12.6399 12.5516 12.6399 11.8569C12.6399 11.4237 12.5289 11.0468 12.3069 10.7263C12.0849 10.4058 11.7841 10.1543 11.4045 9.97168C11.7376 9.79622 11.9989 9.56169 12.1887 9.26807Z"></path>
      </g>
      <g id="counter-9">
        <path d="M10.6177 10.0898C10.4368 10.2188 10.2211 10.2832 9.97046 10.2832C9.61596 10.2832 9.34115 10.1462 9.146 9.87231C8.95085 9.59839 8.85327 9.24837 8.85327 8.82227C8.85327 8.39258 8.95353 8.0354 9.15405 7.75073C9.35457 7.46606 9.61059 7.32373 9.92212 7.32373C10.2587 7.32373 10.5273 7.46875 10.7278 7.75879C10.9283 8.04883 11.0286 8.45703 11.0286 8.9834V9.62256C10.9355 9.80518 10.7985 9.96094 10.6177 10.0898Z"></path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M10 2C5.584 2 2 5.584 2 10C2 14.416 5.584 18 10 18C14.416 18 18 14.416 18 10C18 5.584 14.416 2 10 2ZM11.0071 10.874C10.6025 11.2715 10.1298 11.4702 9.58911 11.4702C8.89803 11.4702 8.34481 11.233 7.92944 10.7585C7.51408 10.2841 7.3064 9.64405 7.3064 8.83838C7.3064 8.32633 7.41829 7.85637 7.64209 7.42847C7.86589 7.00057 8.1783 6.66756 8.57935 6.42944C8.98039 6.19132 9.43156 6.07227 9.93286 6.07227C10.4485 6.07227 10.9068 6.20117 11.3079 6.45898C11.7089 6.7168 12.0204 7.0874 12.2424 7.5708C12.4644 8.0542 12.5772 8.60742 12.5808 9.23047V9.80518C12.5808 11.1086 12.2568 12.1326 11.6086 12.8774C10.9605 13.6222 10.0421 14.0197 8.85327 14.0698L8.47192 14.0752V12.7808L8.81567 12.7754C10.1656 12.7145 10.8961 12.0807 11.0071 10.874Z"></path>
      </g>
      <g id="about-update-complete" viewBox="0 0 16 16">
        <path fill-rule="evenodd" d="M8 15.167a7.012 7.012 0 0 1-2.792-.563 7.165 7.165 0 0 1-2.27-1.52 7.731 7.731 0 0 1-1.542-2.292A7.012 7.012 0 0 1 .833 8c0-.986.188-1.917.563-2.792a7.46 7.46 0 0 1 1.542-2.27 6.996 6.996 0 0 1 2.27-1.542A7.012 7.012 0 0 1 8 .833c1.139 0 2.18.243 3.125.73A7.009 7.009 0 0 1 13.542 3.5V.875h1.583V6H10V4.417h2.083a4.944 4.944 0 0 0-1.791-1.354A5.314 5.314 0 0 0 8 2.563c-1.5 0-2.785.534-3.854 1.604C3.09 5.222 2.563 6.5 2.563 8s.527 2.785 1.583 3.854C5.216 12.91 6.5 13.438 8 13.438s2.778-.528 3.833-1.584c1.07-1.07 1.604-2.354 1.604-3.854h1.73c0 2-.695 3.694-2.084 5.083C11.694 14.473 10 15.167 8 15.167Zm2.042-4.292L7.208 8.042V4h1.584v3.375l2.375 2.375-1.125 1.125Z"></path>
      </g>
      <g id="about-update-warning" viewBox="0 0 20 20">
        <path fill-rule="evenodd" d="M.854 17.083 10 1.833l9.146 15.25H.854Zm2.917-1.645h12.458L10 5.063 3.77 15.438ZM10 14.479c.208 0 .389-.07.542-.208a.765.765 0 0 0 .229-.563.74.74 0 0 0-.23-.541.698.698 0 0 0-.541-.23.74.74 0 0 0-.542.23.698.698 0 0 0-.229.541c0 .209.07.39.209.542.152.153.34.23.562.23ZM9.25 12h1.5V8.063h-1.5V12Z"></path>
      </g>
      <g id="about-update-error" viewBox="0 0 20 20">
        <path fill-rule="evenodd" d="M10 14.167c.25 0 .458-.084.625-.25a.839.839 0 0 0 .27-.646c0-.25-.09-.459-.27-.625a.815.815 0 0 0-.625-.271c-.25 0-.465.09-.646.27a.848.848 0 0 0-.25.626c0 .25.084.465.25.646a.92.92 0 0 0 .646.25ZM9.125 11h1.75V5.896h-1.75V11ZM10 18.167a8.205 8.205 0 0 1-3.187-.625 8.59 8.59 0 0 1-2.605-1.75 8.589 8.589 0 0 1-1.75-2.604A8.204 8.204 0 0 1 1.833 10c0-1.139.209-2.201.625-3.187a8.327 8.327 0 0 1 1.75-2.584 8.112 8.112 0 0 1 2.605-1.75c1-.43 2.062-.646 3.187-.646 1.139 0 2.201.216 3.188.646.986.417 1.847 1 2.583 1.75a7.82 7.82 0 0 1 1.75 2.604c.43.986.646 2.042.646 3.167a7.974 7.974 0 0 1-.646 3.188c-.417.986-1 1.854-1.75 2.604a8.262 8.262 0 0 1-2.604 1.75 8.053 8.053 0 0 1-3.167.625Zm0-1.73c1.792 0 3.313-.625 4.563-1.875 1.25-1.25 1.874-2.77 1.874-4.562 0-1.792-.625-3.312-1.875-4.562-1.25-1.25-2.77-1.875-4.562-1.875-1.792 0-3.312.624-4.562 1.874C4.188 6.688 3.563 8.209 3.563 10c0 1.792.624 3.313 1.874 4.563 1.25 1.25 2.771 1.874 4.563 1.874Z"></path>
      </g>
      <g id="about-release-notes" viewBox="0 0 18 18">
        <path fill-rule="evenodd" d="m4.792 13.208 6.041-2.375 2.375-6.041-6.041 2.375-2.375 6.041ZM9 10a.896.896 0 0 1-.708-.27A1.035 1.035 0 0 1 8 9c0-.278.097-.514.292-.708A.964.964 0 0 1 9 8c.278 0 .514.097.708.292.195.194.292.43.292.708a.964.964 0 0 1-.292.708A.964.964 0 0 1 9 10Zm0 7.167a8.205 8.205 0 0 1-3.187-.625 8.59 8.59 0 0 1-2.605-1.75 8.589 8.589 0 0 1-1.75-2.604A8.204 8.204 0 0 1 .833 9c0-1.139.209-2.201.625-3.187a8.327 8.327 0 0 1 1.75-2.584 8.112 8.112 0 0 1 2.605-1.75c1-.43 2.062-.646 3.187-.646 1.139 0 2.201.216 3.188.646.986.417 1.847 1 2.583 1.75a7.82 7.82 0 0 1 1.75 2.604c.43.986.646 2.042.646 3.167a7.974 7.974 0 0 1-.646 3.188c-.417.986-1 1.854-1.75 2.604a8.262 8.262 0 0 1-2.604 1.75A8.053 8.053 0 0 1 9 17.167Zm0-1.73c1.792 0 3.313-.624 4.563-1.874 1.25-1.25 1.874-2.771 1.874-4.563 0-1.792-.624-3.312-1.874-4.562-1.25-1.25-2.771-1.875-4.563-1.875-1.792 0-3.312.624-4.562 1.874C3.188 5.688 2.563 7.209 2.563 9c0 1.792.624 3.313 1.874 4.563 1.25 1.25 2.771 1.874 4.563 1.874Z"></path>
      </g>
      <g id="about-help" viewBox="0 0 16 16">
        <path fill-rule="evenodd" d="M7.98 12.5a.897.897 0 0 0 .687-.292.964.964 0 0 0 .291-.708.921.921 0 0 0-.291-.708.931.931 0 0 0-.688-.271c-.278 0-.52.09-.729.27a.922.922 0 0 0-.292.709c0 .278.098.514.292.708a.99.99 0 0 0 .73.292Zm-.75-2.854h1.478c0-.472.042-.806.125-1 .084-.195.299-.452.646-.771.278-.264.521-.549.73-.854.222-.32.333-.708.333-1.167 0-.75-.257-1.326-.771-1.729-.5-.417-1.097-.625-1.792-.625-.68 0-1.25.201-1.708.604-.445.39-.757.833-.938 1.334L6.667 6c.097-.236.236-.48.416-.73.195-.263.493-.395.896-.395s.688.111.854.333c.18.209.271.438.271.688 0 .278-.104.535-.312.77-.209.223-.41.431-.604.626-.445.43-.716.77-.813 1.02-.097.25-.146.695-.146 1.334Zm-4.667 5.52c-.487 0-.896-.166-1.23-.5a1.671 1.671 0 0 1-.5-1.229V2.563c0-.487.167-.896.5-1.23a1.67 1.67 0 0 1 1.23-.5h10.875c.486 0 .895.167 1.229.5.333.334.5.743.5 1.23v10.875c0 .486-.167.895-.5 1.229-.334.333-.743.5-1.23.5H2.563Zm0-1.729h10.875V2.563H2.563v10.875Zm0-10.874v10.875V2.563Z"></path>
      </g>
      <g id="about-feedback" viewBox="0 0 18 18">
        <path fill-rule="evenodd" d="M9 11.5a.79.79 0 0 0 .583-.23.756.756 0 0 0 .25-.582.756.756 0 0 0-.25-.584.756.756 0 0 0-.583-.25.823.823 0 0 0-.604.25.765.765 0 0 0-.23.563c0 .236.077.437.23.604.166.153.368.229.604.229Zm-.792-2.458h1.584V3.5H8.208v5.542ZM.833 17.167V2.562c0-.486.167-.895.5-1.229a1.67 1.67 0 0 1 1.23-.5h12.875c.486 0 .895.167 1.229.5.333.334.5.743.5 1.23v9.875c0 .486-.167.895-.5 1.229-.334.333-.743.5-1.23.5H3.834l-3 3Zm2.375-4.73h12.23V2.563H2.563v10.52l.645-.646Zm-.646 0V2.563v9.875Z"></path>
      </g>
      <g id="about-diagnostics" viewBox="0 0 20 14">
        <path fill-rule="evenodd" d="M7.542 13.125a1.34 1.34 0 0 1-.792-.25 1.391 1.391 0 0 1-.48-.646L4.5 7.875H.875v-1.75h4.813l1.854 4.625 3.646-9a1.34 1.34 0 0 1 1.27-.875c.292 0 .549.083.771.25.236.167.403.382.5.646L15.5 6.125h3.625v1.75h-4.792L12.458 3.25l-3.645 9a1.36 1.36 0 0 1-.5.625 1.25 1.25 0 0 1-.771.25Z"></path>
      </g>
      <g id="about-firmware-updates" viewBox="0 0 18 14">
        <path fill-rule="evenodd" d="M2.563 13.167c-.487 0-.896-.167-1.23-.5a1.671 1.671 0 0 1-.5-1.23V2.563c0-.487.167-.896.5-1.23a1.67 1.67 0 0 1 1.23-.5h4.312v1.73H2.563v8.875h12.875V2.563h-4.313V.833h4.313c.486 0 .895.167 1.229.5.333.334.5.743.5 1.23v8.875c0 .486-.167.895-.5 1.229-.334.333-.743.5-1.23.5H2.563Zm6.437-3L4.833 6l1.23-1.208 2.062 2.062V.834h1.75v6.02l2.063-2.062L13.167 6 9 10.167Z"></path>
      </g>
      <g id="about-additional-details" viewBox="0 0 16 10">
        <path fill-rule="evenodd" d="M.833 9.833V8.125h5.25v1.708H.833Zm0-3.958v-1.73h9.292v1.73H.833Zm0-3.98V.168h14.334v1.729H.833Z"></path>
      </g>
      <g id="about-linux" viewBox="0 0 16 16">
        <path fill-rule="evenodd" d="M6.345 5.812c0 .47-.37.85-.828.85a.84.84 0 0 1-.827-.85c0-.47.37-.85.827-.85a.84.84 0 0 1 .828.85ZM10.483 6.662a.84.84 0 0 0 .827-.85.84.84 0 0 0-.827-.85.84.84 0 0 0-.828.85c0 .47.37.85.828.85ZM7.832 7.122a.384.384 0 0 1 .318 0l1.136.512a.398.398 0 0 1 .128.63L8.285 9.51a.386.386 0 0 1-.575 0L6.585 8.26a.4.4 0 0 1 .128-.629l1.12-.509Z"></path>
        <path fill-rule="evenodd" d="M8 15.22c-.068 0-.136.051-.203.102l-.076.055c-.03.325-.274.623-1.652.623-1.693 0-1.674-.352-1.65-.815.004-.058.007-.117.007-.177 0-.082.016-.156.047-.221-1.96-.815-3.215-2.462-3.258-5.33-.198.104-.422.121-.682.024-.741-.278-.575-1.206-.303-2.034.226-.685.995-1.186 1.372-1.29C2.478 2.704 4.536 0 8 0c3.506 0 5.577 2.592 6.43 6.166.385.122 1.12.614 1.34 1.281.272.828.438 1.756-.303 2.034-.26.097-.484.08-.682-.023-.039 2.887-1.296 4.525-3.256 5.334.03.064.045.136.045.216 0 .06.004.12.007.177.024.463.043.815-1.65.815-1.388 0-1.626-.302-1.652-.63-.023-.015-.046-.032-.068-.048-.07-.05-.14-.102-.211-.102Zm0-1.662c3.657 0 4.975-1.602 4.975-5.148 0-2.943-1.199-5.645-3.189-6.097-.324-.073-.598.296-.882.678-.275.37-.558.751-.904.751-.353 0-.657-.398-.946-.775-.285-.373-.555-.725-.84-.654-1.999.504-3.19 3.31-3.19 6.097 0 3.346 1.32 5.149 4.976 5.149Z" clip-rule="evenodd"></path>
      </g>
      <g id="about-manage-develop-environment" viewBox="0 0 18 16">
        <path fill-rule="evenodd" d="M.833 3.917V2.563c0-.487.167-.896.5-1.23.348-.333.757-.5 1.23-.5h12.875c.486 0 .895.167 1.229.5.333.334.5.743.5 1.23v1.354h-1.73V2.563H2.563v1.354H.833Zm5.084 11.25v-2H2.563c-.473 0-.882-.167-1.23-.5a1.671 1.671 0 0 1-.5-1.23v-1.354h1.73v1.354h12.875v-1.354h1.729v1.354c0 .487-.167.896-.5 1.23-.334.333-.743.5-1.23.5h-3.354v2H5.917ZM3.063 7 5 5.063 3.875 3.938.833 7l3.042 3.063L5 8.937 3.063 7Zm11.875 0L13 8.938l1.125 1.104L17.167 7l-3.042-3.062L13 5.062 14.938 7Z"></path>
      </g>

      <!-- Crostini Mascot icon for Settings drawer -->
      <g id="crostini-mascot" fill-rule="evenodd" viewBox="0 0 24 24">
        <rect width="24" height="24" fill="none"></rect>
        <path d="M6.70994751,22.1802367 C3.77039152,20.9576222 1.88689678,18.4876617 1.82270453,14.1866283 C1.52620735,14.3410271 1.18877909,14.3669908 0.800057996,14.221322 C-0.312414045,13.804436 -0.0624529958,12.4120387 0.345560769,11.1705211 C0.68346303,10.142341 1.83735671,9.39181671 2.40240955,9.23479478 C3.71763772,4.05541221 6.80346772,0 12,0 C17.2584272,0 20.3654882,3.88805047 21.6436562,9.24850027 C22.2231374,9.43172978 23.3254781,10.1695473 23.6544392,11.1705211 C24.062453,12.4120387 24.312414,13.804436 23.199942,14.221322 C22.8112853,14.3669667 22.4739044,14.3410357 22.1774428,14.186705 C22.1189307,18.5169382 20.2342349,20.9750038 17.2936622,22.1879533 C17.3379726,22.2841737 17.3614392,22.3916932 17.3614392,22.5115654 C17.3614392,23.3336051 17.750632,24 14.8965517,24 C12.813813,24 12.4581871,23.5470722 12.4180882,23.0543665 C12.2796354,22.9647547 12.14026,22.8305157 12,22.8305157 C11.8594243,22.8305157 11.7197425,22.9755283 11.5809922,23.0650454 C11.536581,23.553597 11.171131,24 9.10344828,24 C6.24936798,24 6.63856075,23.3336051 6.63856075,22.5115654 C6.63856075,22.3884786 6.66330281,22.278416 6.70994751,22.1802367 Z M12,20.3378361 C17.4851654,20.3378361 19.4630542,17.934489 19.4630542,12.6147346 C19.4630542,8.20063746 17.6641739,4.14700996 14.6790451,3.47027327 C13.7222433,3.25336374 13.052482,5.61336212 12,5.61336212 C10.947518,5.61336212 10.1820765,3.25336374 9.32095491,3.47027327 C6.32316904,4.22539115 4.53694581,8.43392639 4.53694581,12.6147346 C4.53694581,17.6346061 6.51483457,20.3378361 12,20.3378361 Z M8.27586207,9.99377535 C7.59026721,9.99377535 7.03448276,9.42257974 7.03448276,8.71797424 C7.03448276,8.01336875 7.59026721,7.44217314 8.27586207,7.44217314 C8.96145693,7.44217314 9.51724138,8.01336875 9.51724138,8.71797424 C9.51724138,9.42257974 8.96145693,9.99377535 8.27586207,9.99377535 Z M15.7241379,9.99377535 C15.0385431,9.99377535 14.4827586,9.42257974 14.4827586,8.71797424 C14.4827586,8.01336875 15.0385431,7.44217314 15.7241379,7.44217314 C16.4097328,7.44217314 16.9655172,8.01336875 16.9655172,8.71797424 C16.9655172,9.42257974 16.4097328,9.99377535 15.7241379,9.99377535 Z M12.224615,10.6827627 L13.9283449,11.4510541 C14.2234366,11.5841248 14.3564393,11.9349546 14.2254148,12.2346546 C14.1996198,12.293657 14.1645229,12.3479919 14.1215061,12.39552 L12.4275305,14.2671455 C12.2090286,14.5085621 11.8392003,14.5243719 11.6014958,14.3024578 C11.5890079,14.2907994 11.5770255,14.2785946 11.5655826,14.265878 L9.87720766,12.3895636 C9.65939502,12.1475054 9.67603268,11.771949 9.91436891,11.5507349 C9.9604013,11.5080095 10.012868,11.4730393 10.0697797,11.4471502 L11.7484004,10.6835476 C11.8998356,10.6146599 12.0729604,10.6143745 12.224615,10.6827627 Z"></path>
      </g>

      <!-- Developer Tags icon for Settings drawer -->
      <g id="developer-tags" viewBox="0 0 24 24">
        <rect width="24" height="24" fill="none"></rect>
        <path d="M0 0h24v24H0V0z" fill="none"></path><path d="M16 6l-1.41 1.41L19.17 12l-4.58 4.59L16 18l6-6zM8 18l1.41-1.41L4.83 12l4.58-4.59L8 6l-6 6z"></path>
      </g>

      <!-- Device section -->
      <g id="device-pointing-stick" viewBox="0 0 20 20">
        <path fill-rule="evenodd" d="M10 11.625c-.444 0-.826-.16-1.146-.48-.32-.319-.479-.7-.479-1.145 0-.444.16-.826.48-1.146.319-.32.7-.479 1.145-.479.444 0 .826.16 1.146.48.32.319.479.7.479 1.145 0 .444-.16.826-.48 1.146-.319.32-.7.479-1.145.479Zm-.875-4.75v-5.02h1.75v5.02h-1.75Zm0 11.27v-5.02h1.75v5.02h-1.75Zm4-7.27v-1.75h5.02v1.75h-5.02Zm-11.27 0v-1.75h5.02v1.75h-5.02Z"></path>
      </g>
      <g id="device-mouse" viewBox="0 0 20 20">
           <path fill-rule="evenodd" d="M10 18.167c-1.708 0-3.167-.598-4.375-1.792C4.431 15.167 3.833 13.708 3.833 12V8c0-1.708.598-3.16 1.792-4.354C6.833 2.438 8.292 1.833 10 1.833c1.708 0 3.16.605 4.354 1.813C15.563 4.84 16.167 6.292 16.167 8v4c0 1.708-.605 3.167-1.813 4.375-1.194 1.194-2.646 1.792-4.354 1.792ZM10.75 7.5h3.646a4.316 4.316 0 0 0-1.167-2.542c-.666-.708-1.493-1.146-2.479-1.312V7.5Zm-5.146 0H9.25V3.646a4.14 4.14 0 0 0-2.48 1.312A4.316 4.316 0 0 0 5.605 7.5ZM10 16.438c1.222 0 2.264-.431 3.125-1.292.875-.875 1.313-1.924 1.313-3.146V9H5.563v3c0 1.222.43 2.27 1.291 3.146.875.86 1.924 1.291 3.146 1.291Z"></path>
      </g>
      <g id="device-touchpad" viewBox="0 0 18 16">
        <path fill-rule="evenodd" d="M12.583 13.52c.82 0 1.514-.284 2.084-.853a2.88 2.88 0 0 0 .854-2.084V9.75H9.646v.833c0 .806.285 1.5.854 2.084a2.88 2.88 0 0 0 2.083.854ZM9.688 8.126h2.083V5.75a2.997 2.997 0 0 0-1.396.875 2.775 2.775 0 0 0-.687 1.5Zm3.708 0h2.083a2.906 2.906 0 0 0-.708-1.5 2.866 2.866 0 0 0-1.375-.875v2.375Zm-.813 7.042c-1.291 0-2.382-.438-3.27-1.313C8.437 12.965 8 11.875 8 10.584V8.645c0-1.292.438-2.375 1.313-3.25.888-.89 1.979-1.333 3.27-1.333 1.292 0 2.375.444 3.25 1.333.89.875 1.334 1.958 1.334 3.25v1.937c0 1.292-.445 2.382-1.334 3.271-.875.875-1.958 1.313-3.25 1.313Zm-10.02-3.73V2.563v8.874Zm0 1.73c-.487 0-.896-.167-1.23-.5a1.716 1.716 0 0 1-.5-1.23V2.563c0-.473.167-.876.5-1.209.334-.347.743-.52 1.23-.52h12.875c.486 0 .895.173 1.229.52.333.333.5.736.5 1.209v2.083a5.916 5.916 0 0 0-.813-.75 5.5 5.5 0 0 0-.916-.604v-.73H2.563v8.876h4c.027.305.083.604.166.895.083.292.195.57.333.834h-4.5Z"></path>
      </g>
      <g id="device-keyboard" viewBox="0 0 18 12">
        <path fill-rule="evenodd" d="M2.5 11.23c-.472 0-.882-.168-1.23-.5a1.716 1.716 0 0 1-.5-1.23v-7c0-.472.167-.875.5-1.208C1.619.944 2.029.77 2.5.77h13c.472 0 .875.173 1.208.52.348.334.521.737.521 1.209v7c0 .472-.173.882-.52 1.23-.334.332-.737.5-1.209.5h-13Zm0-1.73h13v-7h-13v7ZM6 9h6V7.5H6V9ZM4 6.5h1.5V5H4v1.5Zm2.125 0h1.5V5h-1.5v1.5Zm2.125 0h1.5V5h-1.5v1.5Zm2.125 0h1.5V5h-1.5v1.5Zm2.125 0H14V5h-1.5v1.5ZM4 4.5h1.5V3H4v1.5Zm2.125 0h1.5V3h-1.5v1.5Zm2.125 0h1.5V3h-1.5v1.5Zm2.125 0h1.5V3h-1.5v1.5Zm2.125 0H14V3h-1.5v1.5Zm-10 5v-7 7Z"></path>
      </g>
      <g id="device-stylus" viewBox="0 0 16 16">
        <path fill-rule="evenodd" d="M1.917 15.125a.83.83 0 0 1-.813-.23.952.952 0 0 1-.229-.832l.77-3.75 4.022 4.041-3.75.771Zm3.75-.77-4.021-4.043 8.958-8.937c.334-.333.736-.5 1.209-.5.472 0 .874.167 1.208.5l1.604 1.583c.333.334.5.743.5 1.23 0 .472-.167.875-.5 1.208l-8.958 8.958Zm6.146-11.75-8.021 8.04 1.562 1.563 8.042-8.02-1.584-1.584Z"></path>
      </g>
      <g id="device-tablet" viewBox="0 0 20 14">
        <path fill-rule="evenodd" d="M2.583 13.167a1.67 1.67 0 0 1-1.229-.5 1.716 1.716 0 0 1-.5-1.23V2.563c0-.487.167-.896.5-1.23a1.67 1.67 0 0 1 1.23-.5h14.833c.486 0 .895.174 1.229.521.333.333.5.736.5 1.209v8.875c0 .486-.167.895-.5 1.229a1.67 1.67 0 0 1-1.23.5H2.584Zm1-10.604h-1v8.875h1V2.563Zm1.5 8.875h9.834V2.563H5.083v8.875Zm11.334-8.875v8.875h1V2.563h-1Zm0 0h1-1Zm-12.834 0h-1 1Z"></path>
      </g>
      <g id="device-display" viewBox="0 0 18 16">
        <path fill-rule="evenodd" d="M5.917 15.167v-2H2.563c-.487 0-.896-.167-1.23-.5a1.671 1.671 0 0 1-.5-1.23V2.563c0-.487.167-.896.5-1.23a1.67 1.67 0 0 1 1.23-.5h12.875c.486 0 .895.167 1.229.5.333.334.5.743.5 1.23v8.875c0 .486-.167.895-.5 1.229-.334.333-.743.5-1.23.5h-3.354v2H5.917Zm-3.354-3.73h12.875V2.563H2.563v8.875Zm0 0V2.563v8.875Z"></path>
      </g>
      <g id="device-audio" viewBox="0 0 12 17">
        <path fill-rule="evenodd" d="M6 11.23c-.75 0-1.389-.258-1.917-.772a2.646 2.646 0 0 1-.77-1.916V3.583c0-.75.256-1.389.77-1.916A2.61 2.61 0 0 1 6 .875c.75 0 1.382.264 1.896.792a2.61 2.61 0 0 1 .792 1.916v4.959a2.61 2.61 0 0 1-.792 1.916c-.514.514-1.146.771-1.896.771Zm-.833 5.083v-2.084c-1.417-.194-2.59-.826-3.521-1.896C.716 11.25.25 9.986.25 8.542h1.646c0 1.139.396 2.11 1.187 2.916.806.792 1.778 1.188 2.917 1.188 1.139 0 2.104-.396 2.896-1.188.805-.805 1.208-1.777 1.208-2.916h1.646c0 1.444-.465 2.708-1.396 3.791-.93 1.07-2.104 1.702-3.52 1.896v2.084H5.166ZM6 9.5c.278 0 .507-.09.688-.27.18-.181.27-.41.27-.688V3.583a.931.931 0 0 0-.27-.687A.932.932 0 0 0 6 2.625a.932.932 0 0 0-.687.27.931.931 0 0 0-.271.688v4.959c0 .277.09.507.27.687.181.18.41.271.688.271Z"></path>
      </g>
      <g id="device-print" viewBox="0 0 18 16">
        <path fill-rule="evenodd" d="M14.167 3.833H3.833v-3h10.334v3Zm-.521 4.875c.222 0 .41-.076.562-.229a.756.756 0 0 0 .25-.583.79.79 0 0 0-.229-.583.757.757 0 0 0-.583-.25.823.823 0 0 0-.604.25.765.765 0 0 0-.23.562c0 .236.077.438.23.604.166.153.368.23.604.23Zm-1.209 4.855v-2.626H5.564v2.626h6.875Zm1.73 1.687H3.833v-3.104h-3V7c0-.597.209-1.104.625-1.52.417-.431.924-.647 1.521-.647h12.042c.597 0 1.104.216 1.52.646.417.417.626.924.626 1.521v5.146h-3v3.104Z"></path>
      </g>
      <g id="device-scan" viewBox="0 0 16 13">
        <path fill-rule="evenodd" d="M10.708 5.77 1.167 2.334 1.729.771l12.209 4.416c.43.14.756.382.979.73.236.333.354.701.354 1.104V10.5c0 .472-.174.882-.521 1.23-.333.332-.736.5-1.208.5H2.458c-.472 0-.882-.168-1.229-.5a1.716 1.716 0 0 1-.5-1.23v-3c0-.486.167-.896.5-1.23.347-.332.757-.5 1.23-.5h8.25Zm2.834 4.73v-3H2.458v3h11.084Zm-7.084-.75h6.084v-1.5H6.458v1.5Zm-2.25 0c.209 0 .382-.07.521-.208A.74.74 0 0 0 4.96 9a.707.707 0 0 0-.209-.52.698.698 0 0 0-.542-.23.74.74 0 0 0-.541.23.707.707 0 0 0-.209.52c0 .208.07.389.209.542a.779.779 0 0 0 .541.208Zm-1.75.75v-3 3Z"></path>
      </g>
      <g id="volume-down"><path fill-rule="evenodd" clip-rule="evenodd" d="M1 13H4.46667L8 16.5V3.5L4.46667 7H1V13ZM10 6.5V13.5C11.776 12.8652 12.5 11.0043 12.5 10C12.5 8.99565 11.776 7.14348 10 6.5Z"></path></g>
      <g id="volume-up"><path fill-rule="evenodd" clip-rule="evenodd" d="M1 13H4.46667L8 16.4V3.40002L4.46667 7.00002H1V13ZM10 6.40002V13.4C11.776 12.7652 12.5 10.9044 12.5 9.90002C12.5 8.89568 11.776 7.0435 10 6.40002ZM10 4.16171C12.4771 4.89717 14.5 7.18908 14.5 9.90002C14.5 12.611 12.4771 14.9029 10 15.6383V17.4C13.4371 16.6218 16 13.5602 16 9.90002C16 6.23982 13.4371 3.17825 10 2.40002V4.16171Z"></path></g>
      <g id="volume-up-off"><path fill-rule="evenodd" clip-rule="evenodd" d="M10 6.513V7.97617L12.4583 10.5528C12.6093 10.1206 12.5 7.42639 10 6.513ZM13.9946 12.3314L15.1797 13.4534C15.7487 12.3314 16 11.3267 16 9.9645C16 6.07761 13 3.12889 10 2.49896V4.2774C12.6423 5.05842 14.5 7.5 14.5 9.9645C14.5 10.8182 14.3055 11.5867 13.9946 12.3314ZM1 3.12889L4.71387 6.74969L4.5 7H1V13H4.5L8 16.5V10L12.5 14.3494C11.7872 14.8533 11.5515 15.2067 10 15.7357V17.4865C11.4697 17.2198 12.4473 16.5573 13.5598 15.6162L15.8711 18L17 16.8711L2.12889 2L1 3.12889ZM6.573 4.83173L8 6.16345V3.5L6.573 4.83173Z"></g>
      <g id="volume-zero"><path fill-rule="evenodd" clip-rule="evenodd" d="M1 13H4.46667L8 16.5V3.5L4.46667 7H1V13Z"></g>

      <!-- Files section -->
      <g id="folder-outline"><path d="M16 5h-4l-2-2H4c-1.1 0-1.99.9-1.99 2L2 15c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 10H4V7h12v8z"></path></g>
      <g id="folder-shared" viewBox="0 0 20 20">
        <path fill-rule="evenodd" d="M10 14h6v-.354c0-.403-.306-.764-.917-1.084-.61-.319-1.305-.479-2.083-.479-.792 0-1.493.16-2.104.48-.597.305-.896.666-.896 1.083V14Zm3-2.917c.417 0 .77-.146 1.063-.437.291-.292.437-.646.437-1.063 0-.416-.146-.77-.438-1.062A1.447 1.447 0 0 0 13 8.083c-.417 0-.77.153-1.063.459a1.446 1.446 0 0 0-.437 1.062c0 .403.146.75.438 1.042.291.291.645.437 1.062.437Zm-9.438 5.084c-.472 0-.881-.167-1.229-.5a1.716 1.716 0 0 1-.5-1.23V5.563c0-.487.167-.896.5-1.23.348-.333.757-.5 1.23-.5h4.354L10 5.896h6.438c.486 0 .895.173 1.229.52.333.334.5.737.5 1.209v6.813c0 .472-.167.881-.5 1.229-.334.333-.743.5-1.23.5H3.563Zm0-1.73h12.876V7.625H9.27L7.208 5.562H3.562v8.875Zm0 0V5.563v8.875Z"></path>
      </g>

      <!-- Graduation icons -->
      <g id="graduation" viewBox="0 -960 960 960">
        <path fill-rule="evenodd" d="M480-120 200-272v-240L40-600l440-240 440 240v320h-80v-276l-80 44v240L480-120Zm0-332 274-148-274-148-274 148 274 148Zm0 241 200-108v-151L480-360 280-470v151l200 108Zm0-241Zm0 90Zm0 0Z"></path>
      </g>

      <!-- Keyboard shortcut banner icons -->
      <g id="keyboard-shortcut" viewBox="0 0 48 48"><path d="M11 17h26v20H11V17Z" fill="var(--cros-sys-illo-color1-2)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M8 17a3 3 0 0 1 3-3h26a3 3 0 0 1 3 3v20a3 3 0 0 1-3 3H11a3 3 0 0 1-3-3V17Zm3 0v20h26V17H11Z" fill="var(--cros-sys-illo-color1-1)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M13.5 21a1 1 0 0 1 1-1h1a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1h-1a1 1 0 0 1-1-1v-1ZM18 33h12v2H18v-2Zm2.5-13a1 1 0 0 0-1 1v1a1 1 0 0 0 1 1h1a1 1 0 0 0 1-1v-1a1 1 0 0 0-1-1h-1Zm5 1a1 1 0 0 1 1-1h1a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1h-1a1 1 0 0 1-1-1v-1Zm7-1a1 1 0 0 0-1 1v1a1 1 0 0 0 1 1h1a1 1 0 0 0 1-1v-1a1 1 0 0 0-1-1h-1Zm-7 8a1 1 0 0 1 1-1h1a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1h-1a1 1 0 0 1-1-1v-1Zm7-1a1 1 0 0 0-1 1v1a1 1 0 0 0 1 1h1a1 1 0 0 0 1-1v-1a1 1 0 0 0-1-1h-1Zm-13 1a1 1 0 0 1 1-1h1a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1h-1a1 1 0 0 1-1-1v-1Zm-5-1a1 1 0 0 0-1 1v1a1 1 0 0 0 1 1h1a1 1 0 0 0 1-1v-1a1 1 0 0 0-1-1h-1Z" fill="var(--cros-sys-illo-color1-1)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M16 8a1 1 0 0 0-1 1v11.868h18V9a1 1 0 0 0-1-1H16Zm7.418 18.887L15 20.867h18l-8.418 6.019a1 1 0 0 1-1.164 0Z" fill="var(--cros-sys-illo-color1)"/><path d="m25 12 3 3-3 3" stroke="var(--cros-sys-illo-base)" stroke-width="2" stroke-linecap="square" stroke-linejoin="round"/><path d="M27 15h-6a1 1 0 0 0-1 1v3" stroke="var(--cros-sys-illo-base)" stroke-width="2" stroke-linejoin="round"/></g>

      <!-- Magic boost review terms banner icon -->
      <g id="magic-boost-banner-icon" viewBox="0 0 48 48">
        <path d="M37.9837 37.8347C37.9819 39.5828 36.5633 40.9985 34.8151 40.9968L11.5631 40.9729C10.6891 40.972 9.98121 40.2627 9.98211 39.3886L10.0137 8.55395C10.0146 7.67987 10.724 6.97202 11.598 6.97291L36.4327 6.99839C37.3068 6.99929 38.0146 7.7086 38.0137 8.58268L37.9837 37.8347Z" fill="var(--cros-sys-muted_variant)"></path>
        <path d="M7.70841 33.8329L32.4485 33.8573C30.967 36.4572 32.1091 40.6926 34.3314 40.9812L34.8151 40.9817C34.6489 41.0023 34.4875 41.0015 34.3314 40.9812L9.67945 40.9569C7.30585 40.5733 6.12291 36.6155 7.70841 33.8329Z" fill="var(--cros-sys-illo-color1-1)"></path>
        <path d="M14 17H34" stroke="var(--cros-sys-illo-color1-1)" stroke-width="2"></path>
        <path d="M14 22H34" stroke="var(--cros-sys-illo-color1-1)" stroke-width="2"></path>
        <path d="M14 27H30" stroke="var(--cros-sys-illo-color1-1)" stroke-width="2"></path>
        <path d="M37.5 19C41.6421 19 45 15.6421 45 11.5C45 7.35786 41.6421 4 37.5 4C33.3579 4 30 7.35786 30 11.5C30 15.6421 33.3579 19 37.5 19Z" fill="var(--cros-sys-illo-color1)"></path>
        <path d="M34 12.1401L35.9074 13.9129C36.0324 14.029 36.2361 14.029 36.3611 13.9129L41 9.625" stroke="var(--cros-sys-illo-base)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
        <rect x="14" y="10" width="3" height="3" rx="1" fill="var(--cros-sys-illo-color1-1)"></rect>
        <rect x="19" y="10" width="3" height="3" rx="1" fill="var(--cros-sys-illo-color1-1)"></rect>
      </g>

      <!-- Input customization banner icons -->
      <g id="mouse-banner" viewBox="0 0 48 48">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M24.5001 43.958C21.1667 43.958 18.3334 42.8052 16.0001 40.4997C13.6945 38.1663 12.5417 35.333 12.5417 31.9997V24.208H36.4584V31.9997C36.4584 35.333 35.2917 38.1663 32.9584 40.4997C30.6529 42.8052 27.8334 43.958 24.5001 43.958Z" fill="var(--cros-sys-illo-color1-2)"></path>
        <path d="M15.5417 13.4997C13.5417 15.7497 12.5417 18.4025 12.5417 21.458H23.1251V9.58301C20.0973 9.91634 17.5695 11.2219 15.5417 13.4997Z" fill="var(--cros-sys-illo-color1-1)"></path>
        <path d="M25.875 9.58301V21.458H36.4583C36.4583 18.4025 35.4444 15.7497 33.4167 13.4997C31.4167 11.2219 28.9028 9.91634 25.875 9.58301Z" fill="var(--cros-sys-illo-color1-1)"></path>
        <rect x="21" y="17" width="7" height="13" rx="3.5" fill="var(--cros-sys-illo-color1)" stroke="white" stroke-width="2"></rect>
        <path d="M32.2153 5.08339L33.3062 7.44452L29.7645 9.08091L28.6736 6.71978L32.2153 5.08339Z" fill="var(--cros-sys-illo-color1)"></path>
        <path d="M20.061 7.06444L19.1628 9.50542L15.504 8.15918L16.4023 5.71821L20.061 7.06444Z" fill="var(--cros-sys-illo-color1)"></path>
        <path d="M23.4954 4.81448L21.1342 5.90541L19.4979 2.36372L21.8591 1.27279L23.4954 4.81448Z" fill="var(--cros-sys-illo-color1)"></path>
        <path d="M26.4203 1.09042L28.8613 1.98859L27.5139 5.65006L25.0729 4.75189L26.4203 1.09042Z" fill="var(--cros-sys-illo-color1)"></path>
      </g>
      <g id="pen-buttons-banner" viewBox="0 0 48 48">
        <path
          d="M5.79167 37.6667C5.01389 37.6667 4.34722 37.4028 3.79167 36.875C3.26389 36.3194 3 35.6528 3 34.875V13.7917C3 13.0139 3.26389 12.3611 3.79167 11.8333C4.34722 11.2778 5.01389 11 5.79167 11H36.875C37.6528 11 38.3056 11.2778 38.8333 11.8333C39.3889 12.3611 39.6667 13.0139 39.6667 13.7917V34.875C39.6667 35.6528 39.3889 36.3194 38.8333 36.875C38.3056 37.4028 37.6528 37.6667 36.875 37.6667H5.79167ZM9.95833 33.875C9.95833 34.4273 10.406 34.875 10.9583 34.875H31.7083C32.2606 34.875 32.7083 34.4273 32.7083 33.875V14.7917C32.7083 14.2394 32.2606 13.7917 31.7083 13.7917H10.9583C10.406 13.7917 9.95833 14.2394 9.95833 14.7917V33.875Z"
          fill="var(--cros-sys-illo-color1-1)"></path>
        <rect x="9.5" y="13.5" width="27" height="22" rx="1.5" fill="var(--cros-sys-illo-base)"
          stroke="var(--cros-sys-illo-color1-2)"></rect>
        <circle cx="6" cy="24" r="1.5" stroke="var(--cros-sys-illo-base)"></circle>
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M5.5 28C5.22386 28 5 28.2239 5 28.5C5 28.7761 5.22386 29 5.5 29H6.5C6.77614 29 7 28.7761 7 28.5C7 28.2239 6.77614 28 6.5 28H5.5ZM5.5 31C5.22386 31 5 31.2239 5 31.5C5 31.7761 5.22386 32 5.5 32H6.5C6.77614 32 7 31.7761 7 31.5C7 31.2239 6.77614 31 6.5 31H5.5Z"
          fill="var(--cros-sys-illo-base)"></path>
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M5.5 16C5.22386 16 5 16.2239 5 16.5C5 16.7761 5.22386 17 5.5 17H6.5C6.77614 17 7 16.7761 7 16.5C7 16.2239 6.77614 16 6.5 16H5.5ZM5.5 19C5.22386 19 5 19.2239 5 19.5C5 19.7761 5.22386 20 5.5 20H6.5C6.77614 20 7 19.7761 7 19.5C7 19.2239 6.77614 19 6.5 19H5.5Z"
          fill="var(--cros-sys-illo-base)"></path>
        <rect x="46.8774" y="11" width="2.5" height="4" transform="rotate(75.7796 46.8774 11)"
          fill="var(--cros-sys-illo-color1)"></rect>
        <rect x="42.2493" y="6" width="2.5" height="4" transform="rotate(34.2165 42.2493 6)"
          fill="var(--cros-sys-illo-color1)"></rect>
        <rect x="35.839" y="5.5957" width="2.5" height="4" transform="rotate(-15.5352 35.839 5.5957)"
          fill="var(--cros-sys-illo-color1)"></rect>
        <path
          d="M25.2045 30.8705L21.8926 27.5586L21.732 29.9668C21.6918 30.5705 22.1927 31.0713 22.7963 31.0311L25.2045 30.8705Z"
          fill="var(--cros-sys-illo-color1-1)"></path>
        <rect x="36.0863" y="13.3652" width="4.68378" height="20.0733" transform="rotate(45 36.0863 13.3652)"
          fill="var(--cros-sys-illo-color1)"></rect>
        <path
          d="M36.7962 12.656C37.7107 11.7414 39.1935 11.7414 40.1081 12.656V12.656C41.0227 13.5705 41.0227 15.0533 40.1081 15.9679L39.8715 16.2045L36.5596 12.8925L36.7962 12.656Z"
          fill="var(--cros-sys-illo-color1)"></path>
      </g>
      <g id="tablet-buttons-banner" viewBox="0 0 48 48">
        <g clip-path="url(#clip0_2096_5820)">
          <path
            d="M8.79167 37.6667C8.01389 37.6667 7.34722 37.4028 6.79167 36.875C6.26389 36.3194 6 35.6528 6 34.875V13.7917C6 13.0139 6.26389 12.3611 6.79167 11.8333C7.34722 11.2778 8.01389 11 8.79167 11H39.875C40.6528 11 41.3056 11.2778 41.8333 11.8333C42.3889 12.3611 42.6667 13.0139 42.6667 13.7917V34.875C42.6667 35.6528 42.3889 36.3194 41.8333 36.875C41.3056 37.4028 40.6528 37.6667 39.875 37.6667H8.79167ZM12.9583 33.875C12.9583 34.4273 13.406 34.875 13.9583 34.875H34.7083C35.2606 34.875 35.7083 34.4273 35.7083 33.875V14.7917C35.7083 14.2394 35.2606 13.7917 34.7083 13.7917H13.9583C13.406 13.7917 12.9583 14.2394 12.9583 14.7917V33.875Z"
            fill="var(--cros-sys-illo-color1)"></path>
          <rect x="12.5" y="13.5" width="27" height="22" rx="1.5" fill="var(--cros-sys-illo-base)"
            stroke="var(--cros-sys-illo-color1-1)"></rect>
          <path fill-rule="evenodd" clip-rule="evenodd"
            d="M8 16.5C8 16.2239 8.22386 16 8.5 16H9.5C9.77614 16 10 16.2239 10 16.5C10 16.7761 9.77614 17 9.5 17H8.5C8.22386 17 8 16.7761 8 16.5ZM8 19.5C8 19.2239 8.22386 19 8.5 19H9.5C9.77614 19 10 19.2239 10 19.5C10 19.7761 9.77614 20 9.5 20H8.5C8.22386 20 8 19.7761 8 19.5ZM9 25C9.55228 25 10 24.5523 10 24C10 23.4477 9.55228 23 9 23C8.44772 23 8 23.4477 8 24C8 24.5523 8.44772 25 9 25ZM9 26C10.1046 26 11 25.1046 11 24C11 22.8954 10.1046 22 9 22C7.89543 22 7 22.8954 7 24C7 25.1046 7.89543 26 9 26ZM8.5 28C8.22386 28 8 28.2239 8 28.5C8 28.7761 8.22386 29 8.5 29H9.5C9.77614 29 10 28.7761 10 28.5C10 28.2239 9.77614 28 9.5 28H8.5ZM8.5 31C8.22386 31 8 31.2239 8 31.5C8 31.7761 8.22386 32 8.5 32H9.5C9.77614 32 10 31.7761 10 31.5C10 31.2239 9.77614 31 9.5 31H8.5Z"
            fill="var(--cros-sys-illo-color1-1)"></path>
          <rect x="19.4703" y="3.67383" width="2.5" height="4" transform="rotate(33.4841 19.4703 3.67383)"
            fill="var(--cros-sys-illo-color1)"></rect>
          <rect x="11.6138" y="2.86133" width="2.5" height="4" transform="rotate(-8.079 11.6138 2.86133)"
            fill="var(--cros-sys-illo-color1)"></rect>
          <rect x="0.358521" y="10.8125" width="2.5" height="4" transform="rotate(-56.5159 0.358521 10.8125)"
            fill="var(--cros-sys-illo-color1)"></rect>
          <path
            d="M32.7829 30.2604L29.7393 27.2168L29.5979 29.3375C29.5576 29.9412 30.0585 30.4421 30.6622 30.4018L32.7829 30.2604Z"
            fill="var(--cros-sys-illo-color1)"></path>
          <rect x="42.7832" y="14.1738" width="4.30434" height="18.4472" transform="rotate(45 42.7832 14.1738)"
            fill="var(--cros-sys-illo-color1-1)"></rect>
          <path
            d="M43.4355 13.5218C44.2759 12.6813 45.6386 12.6813 46.4791 13.5218C47.3196 14.3623 47.3196 15.725 46.4791 16.5654L46.2617 16.7828L43.2181 13.7392L43.4355 13.5218Z"
            fill="var(--cros-sys-illo-color1-1)"></path>
          <rect x="5.06213" y="5.54492" width="2.5" height="4" transform="rotate(-32.2748 5.06213 5.54492)"
            fill="var(--cros-sys-illo-color1)"></rect>
        </g>
        <defs>
          <clipPath id="clip0_2096_5820">
            <rect width="48" height="48" fill="var(--cros-sys-illo-base)"></rect>
          </clipPath>
        </defs>
      </g>

      <!-- Languages section -->
      <g id="language" viewBox="0 0 20 20"><path fill-rule="evenodd" d="m10.167 18.146 3.625-9.667h1.75l3.625 9.667H17.5l-.875-2.48h-3.896l-.896 2.48h-1.666Zm3.062-3.875h2.896l-1.417-4.021h-.083l-1.396 4.02Zm-9.833 1.333-1.063-1.083 4.084-4.042a18.19 18.19 0 0 1-1.438-1.666 11.185 11.185 0 0 1-1.125-1.896h1.73c.263.458.555.889.874 1.291.334.39.667.771 1 1.146A18.405 18.405 0 0 0 8.938 7.5a8.8 8.8 0 0 0 1.104-2.083H.833V3.875h5.854v-2.02H8.23v2.02h5.854v1.542h-2.416a10.189 10.189 0 0 1-1.313 2.708A18.938 18.938 0 0 1 8.5 10.479l1.938 1.917-.605 1.583-2.375-2.396-4.062 4.021Z"/></g>

      <!-- Offline -->
      <g id="offline"><path d="M11.91 6.244a.833.833 0 111.18 1.179l-3.334 3.333a.833.833 0 01-1.179 0L6.911 9.089a.833.833 0 011.178-1.178l1.078 1.077 2.744-2.744zM6.75 12a.75.75 0 000 1.5h6.5a.75.75 0 000-1.5h-6.5z"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-2 0a6 6 0 11-12 0 6 6 0 0112 0z"></path></g>

      <!-- MultiDevice Settings UI -->
      <g id="connected-devices-android-phone" viewBox="0 0 20 20">
        <path fill-rule="evenodd" d="M8.5 16.417h3v-1h-3v1Zm-2.917 2.729a1.67 1.67 0 0 1-1.229-.5 1.67 1.67 0 0 1-.5-1.23V2.584c0-.486.167-.896.5-1.229a1.67 1.67 0 0 1 1.23-.5h8.833c.486 0 .896.167 1.229.5.333.333.5.743.5 1.23v14.833c0 .486-.167.895-.5 1.229a1.67 1.67 0 0 1-1.23.5H5.584Zm0-4.73v3h8.834v-3H5.583Zm0-1.5h8.834V5.084H5.583v7.834Zm0-9.333h8.834v-1H5.583v1Zm0 10.834v3-3Zm0-10.834v-1 1Z"></path>
      </g>
      <g id="multidevice-wifi-sync" viewBox="0 0 24 24" transform="translate(1.000000, 3.000000)" fill-rule="nonzero">
        <path d="M17,13 C17,13.5522847 16.5522847,14 16,14 L13,14 C12.4477153,14 12,13.5522847 12,13 L12,7 C12,6.44771525 12.4477153,6 13,6 L16,6 C16.5522847,6 17,6.44771525 17,7 L17,13 Z M13,12.5 L13,13 L16,13 L16,12.5 L13,12.5 Z M16,7 L13,7 L13,7.5 L16,7.5 L16,7 Z M13,11.5 L16,11.5 L16,8.5 L13,8.5 L13,11.5 Z"></path>
        <path d="M17.1681,2.62915 C17.5337,2.88721 17.6103,3.40882 17.3327,3.76542 L16.594,4.71403 C16.0864,4.57451 15.5519,4.5 14.9999983,4.5 C11.6863,4.5 8.99999832,7.1863 8.99999832,10.5 C8.99999832,11.5774 9.284,12.5886 9.7812,13.4626 L9.5901,13.708 C9.2867,14.0975 8.71102,14.0975 8.40763,13.7072 L0.66733,3.76542 C0.38972,3.40882 0.46633,2.88721 0.83192,2.62915 C2.09858,1.7353 5.03466,0 8.99999832,0 C12.9661,0 15.9014,1.7353 17.1681,2.62915 Z" ></path>
      </g>
      <g id="multidevice-smart-lock" viewBox="0 0 24 24"><path d="M18,9 L17,9 L17,7 C17,4.24 14.76,2 12,2 C9.24,2 7,4.24 7,7 L7,9 L6,9 C4.9,9 4,9.9 4,11 L4,21 C4,22.1 4.9,23 6,23 L18,23 C19.1,23 20,22.1 20,21 L20,11 C20,9.9 19.1,9 18,9 Z M9,7 C9,5.34 10.34,4 12,4 C13.66,4 15,5.34 15,7 L15,9 L9,9 L9,7 Z M18,21 L6,21 L6,11 L18,11 L18,21 Z M12,18 C13.1,18 14,17.1 14,16 C14,14.9 13.1,14 12,14 C10.9,14 10,14.9 10,16 C10,17.1 10.9,18 12,18 Z"></path></g>
      <g id="nearby-share" viewBox="0 0 24 24">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M2.71638 8.86876C2.24237 9.31907 2.23052 10.0656 2.69268 10.5396L3.88956 11.7839L5.53674 10.0775L4.38727 8.89246C3.93696 8.41845 3.19039 8.4066 2.71638 8.86876ZM16.2612 15.7533L17.2566 14.7342L18.9157 13.0396L21.345 10.5511C21.5701 10.3141 21.6768 10.0178 21.6768 9.72155C21.6768 9.41344 21.5583 9.10534 21.3213 8.86833C20.8591 8.41802 20.1007 8.41802 19.6504 8.89203L17.2566 11.345L15.5976 13.0396L14.5666 14.0943C13.8911 14.7935 12.9905 15.1727 12.0188 15.1727C11.1537 15.1727 10.3479 14.8646 9.70802 14.2957L8.06083 15.9903C9.15105 16.9857 10.5375 17.5427 12.0188 17.5427C13.6304 17.5427 15.1354 16.9146 16.2612 15.7533Z"></path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M12.0188 8.53696C10.4072 8.53696 8.90219 9.16502 7.77641 10.3263L4.06729 14.1303L2.69266 15.5404C2.24235 16.0026 2.24235 16.761 2.71636 17.2113C3.17852 17.6616 3.93694 17.6616 4.38725 17.1876L6.78099 14.7346L8.44003 13.04L9.471 11.9854C10.1465 11.2862 11.0471 10.907 12.0188 10.907C12.8839 10.907 13.6778 11.2151 14.3296 11.7839L15.9768 10.0893C14.8866 9.09392 13.5001 8.53696 12.0188 8.53696ZM21.6768 16.3699C21.6768 16.0737 21.5701 15.7656 21.345 15.5404L20.1599 14.3199L18.5127 16.0263L19.6504 17.1995C20.1007 17.6735 20.8472 17.6853 21.3213 17.2232C21.5583 16.9862 21.6768 16.6781 21.6768 16.3699Z"></path>
      </g>
      <g id="failure-alert" width="26" height="26" viewBox="0 0 26 26">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M11.4002 13H14.6002V6.59995H11.4002V13ZM13.0002 0.199951C5.9346 0.199951 0.200195 5.93435 0.200195 13C0.200195 20.0655 5.9346 25.7999 13.0002 25.7999C20.0658 25.7999 25.8002 20.0655 25.8002 13C25.8002 5.93435 20.0658 0.199951 13.0002 0.199951ZM13.0002 22.5999C7.7082 22.5999 3.4002 18.292 3.4002 13C3.4002 7.70795 7.7082 3.39995 13.0002 3.39995C18.2922 3.39995 22.6002 7.70795 22.6002 13C22.6002 18.292 18.2922 22.5999 13.0002 22.5999ZM11.4002 19.4H14.6002V16.2H11.4002V19.4Z"></path>
      </g>
      <g id="multidevice-recent-photos" width="20" height="20" viewBox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M7.1249 1C6.02033 1 5.1249 1.89543 5.1249 3V13C5.1249 14.1046 6.02033 15 7.1249 15H17.1249C18.2295 15 19.1249 14.1046 19.1249 13V3C19.1249 1.89543 18.2295 1 17.1249 1H7.1249ZM17.1249 3H7.1249V13H17.1249V3ZM2.60539 5.52163L4.12492 5.30807V7.32773L2.88373 7.50217L4.27546 17.4048L14.1781 16.0131L14.1763 15.9999H16.1783C16.1861 16.9876 15.4612 17.8524 14.4565 17.9937L4.55381 19.3854C3.45999 19.5391 2.44865 18.777 2.29493 17.6832L0.903197 7.78051C0.74947 6.68669 1.51157 5.67536 2.60539 5.52163ZM8.13422 10.7979L11.1342 4.79785L13.1342 8.79785L14.1342 7.29785L16.1342 10.7979H8.13422Z"></path>
      </g>
      <g id="multidevice-notifications" width="20" height="20" viewBox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M18.1235 14V16H2.12347V14H4.12347V9.5C4.12347 6.42 5.76347 3.86 8.62347 3.18V2.5C8.62347 1.67 9.29347 1 10.1235 1C10.9535 1 11.6235 1.67 11.6235 2.5V3.18C14.4935 3.86 16.1235 6.43 16.1235 9.5V14H18.1235ZM14.1235 9.5C14.1235 7.02 12.6135 5 10.1235 5C7.63347 5 6.12347 7.02 6.12347 9.5V14H14.1235V9.5ZM10.1235 19C11.2235 19 12.1235 18.1 12.1235 17H8.12347C8.12347 18.1 9.02347 19 10.1235 19Z"></path>
      </g>
      <g id="multidevice-app-streaming" width="20" height="20" viewBox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M13.1235 1.01L5.12347 1C4.02347 1 3.12347 1.9 3.12347 3V17C3.12347 18.1 4.02347 19 5.12347 19H13.1235C14.2235 19 15.1235 18.1 15.1235 17V12.9765H13.1235V14H5.12347V6H13.1235V6.00338H15.1235V3C15.1235 1.9 14.2235 1.01 13.1235 1.01ZM13.1235 17H5.12347V16H13.1235V17ZM5.12347 4V3H13.1235V4H5.12347Z"></path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M10.6984 6.40161V13.3136L12.3596 12.3628H17.8731V6.40161H10.6984ZM16.3731 7.90161H12.1984V10.8628H16.3731V7.90161Z"></path>
      </g>
      <g id="multidevice-error" width="20" height="20" viewBox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M9 10H11V6H9V10ZM10 2C5.584 2 2 5.584 2 10C2 14.416 5.584 18 10 18C14.416 18 18 14.416 18 10C18 5.584 14.416 2 10 2ZM10 16C6.6925 16 4 13.3075 4 10C4 6.6925 6.6925 4 10 4C13.3075 4 16 6.6925 16 10C16 13.3075 13.3075 16 10 16ZM9 14H11V12H9V14Z"></path>
      </g>
      <g id="multidevice-caption-error" width="16" height="16" viewBox="0 0 16 16">
        <path d="M6.99888 4.60514H8.85603V7.91291H6.99888V4.60514Z"></path>
        <path d="M6.99888 9.18871H8.85603V11.0459H6.99888V9.18871Z"></path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM12.6429 8C12.6429 10.5642 10.5642 12.6429 8 12.6429C5.43582 12.6429 3.35714 10.5642 3.35714 8C3.35714 5.43582 5.43582 3.35714 8 3.35714C10.5642 3.35714 12.6429 5.43582 12.6429 8Z"></path>
      </g>

      <!-- Material icon from http://icons/ -->
      <g id="play-prism" viewBox="0 0 24 24"><path d="M20.18 10.88l-3.06-1.74L14.26 12l2.86 2.86 3.06-1.74c.55-.31.82-.71.82-1.12 0-.41-.27-.81-.82-1.12zM4.71 2.45l8.42 8.42 2.55-2.55-10.7-6.06c-.07-.04-.14-.07-.21-.1-.17-.07-.3.05-.15.21.03.02.06.05.09.08zm0 19.1l-.08.08c-.15.15-.02.28.15.21.07-.03.14-.06.21-.1l10.69-6.06-2.55-2.55s-7.2 7.21-8.42 8.42zM12 12L3.38 3.38c-.19-.19-.38-.07-.38.19v16.86c0 .26.19.38.38.19L12 12z"></path></g>

      <!-- Plugin VM icon for Settings drawer -->
      <g id="plugin-vm" viewBox="0 0 24 24"><path transform="scale(1.2)" d="M7 12v4H4V4a1 1 0 0 1 1-1h8a3 3 0 0 1 3 3v3a3 3 0 0 1-3 3H7zm0-6v3h5a1 1 0 0 0 1-1V7a1 1 0 0 0-1-1H7z"></path></g>

      <!-- Personalization section -->
      <g id="paint-brush"><path d="M4.5 11C3 11 2 12 2 13.3c0 1-1 1.6-1.6 1.6.7 1 2 1.5 3.3 1.5 1.7 0 3.2-1.4 3.2-3 0-1.4-1-2.4-2.4-2.4zM12.7 1a2 2 0 0 1 2.8 0L17 2.4c.8.8.8 2 0 2.8l-6.3 6.4a2 2 0 0 1-2.9 0l-1.4-1.4a2 2 0 0 1 0-2.8L12.7 1zM14 2.4L7.7 8.8l1.5 1.4 6.3-6.4-1.4-1.4z"></path></g>
      <g id="personalization-menu" viewBox="0 0 20 20"><path d="M5.051.808.81 5.05 5.05 9.293l1.414-1.414L3.637 5.05l1.414-1.414L6.465 5.05l-.707.707.707.707.708-.707.707.707L9.294 5.05 5.05.808ZM14.95 10.707l-1.413 1.414 1.414 1.415-.707.707.707.707.707-.707.707.707-1.414 1.414-2.829-2.829-1.414 1.415 4.243 4.242 4.242-4.242-4.242-4.243Z"/><path fill-rule="evenodd" clip-rule="evenodd" d="m17.411 3.935-1.35-1.35c-.78-.78-2.05-.78-2.83 0l-2.83 2.82-8.4 8.41v4.18h4.18l11.23-11.23c.79-.78.79-2.05 0-2.83Zm-13.41 12.06v-1.36l7.82-7.82 1.41 1.41-7.82 7.83-1.41-.06Z"/></g>
      <g id="personalization" viewBox="0 0 18 18">
        <path fill-rule="evenodd" d="M9 17.167a8.205 8.205 0 0 1-3.187-.625 8.59 8.59 0 0 1-2.605-1.75 8.589 8.589 0 0 1-1.75-2.604A8.204 8.204 0 0 1 .833 9c0-1.139.216-2.201.646-3.187A8.152 8.152 0 0 1 3.25 3.229a8.233 8.233 0 0 1 2.667-1.75A8.175 8.175 0 0 1 9.146.833c1.11 0 2.153.195 3.125.584a7.89 7.89 0 0 1 2.541 1.562 7.235 7.235 0 0 1 1.73 2.354 6.69 6.69 0 0 1 .625 2.875c0 1.348-.473 2.514-1.417 3.5-.93.973-2.083 1.459-3.458 1.459H11a.415.415 0 0 0-.27.104.28.28 0 0 0-.126.25c0 .194.09.347.271.458.194.097.292.438.292 1.021 0 .528-.209 1.02-.625 1.48-.403.457-.917.687-1.542.687ZM4.563 9.75c.347 0 .638-.118.875-.354.25-.25.375-.549.375-.896s-.125-.639-.375-.875a1.156 1.156 0 0 0-.875-.375c-.348 0-.646.125-.896.375a1.189 1.189 0 0 0-.354.875c0 .347.118.646.354.896.25.236.548.354.896.354ZM7.02 6.792c.347 0 .639-.118.875-.354.25-.25.375-.55.375-.896 0-.348-.125-.64-.375-.875a1.156 1.156 0 0 0-.875-.375c-.347 0-.646.125-.896.375a1.189 1.189 0 0 0-.354.875c0 .347.118.646.354.896.25.236.549.354.896.354Zm3.958 0c.347 0 .64-.118.875-.354.25-.25.375-.55.375-.896 0-.348-.125-.64-.375-.875a1.156 1.156 0 0 0-.875-.375c-.347 0-.646.125-.896.375a1.189 1.189 0 0 0-.354.875c0 .347.118.646.354.896.25.236.549.354.896.354Zm2.438 2.958c.347 0 .639-.118.875-.354.25-.25.375-.549.375-.896s-.125-.639-.375-.875a1.156 1.156 0 0 0-.875-.375c-.348 0-.646.125-.896.375a1.189 1.189 0 0 0-.354.875c0 .347.118.646.354.896.25.236.548.354.896.354Zm-4.438 5.688c.14 0 .25-.056.334-.167a.532.532 0 0 0 .124-.313c0-.222-.104-.41-.312-.562-.208-.153-.312-.486-.312-1 0-.542.187-1 .562-1.375a1.905 1.905 0 0 1 1.396-.584h1.52c.917 0 1.667-.312 2.25-.937a3.214 3.214 0 0 0 .896-2.27c0-1.598-.61-2.938-1.833-4.022-1.222-1.097-2.708-1.646-4.458-1.646-1.834 0-3.39.626-4.667 1.876C3.201 5.688 2.563 7.208 2.563 9c0 1.792.618 3.313 1.854 4.563 1.25 1.25 2.77 1.874 4.562 1.874Z"></path>
      </g>

      <!-- Printing section -->
      <g id="printer-status-illo-green">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.9999 3H4.99994V7H4C2.89543 7 2 7.89543 2 9V14H4.99994V17H10.8026C10.4513 16.3926 10.2033 15.7179 10.0829 15H6.99994V12H10.3414C11.165 9.66962 13.3875 8 15.9999 8C16.6542 8 17.284 8.10471 17.8734 8.29829C17.5892 7.53986 16.8577 7 16 7H14.9999V3ZM6.99994 5H12.9999V7H6.99994V5Z" fill="var(--cros-sys-on_primary_container)"></path>
        <circle cx="16" cy="14" r="3" fill="var(--cros-sys-positive)"></circle>
      </g>
      <g id="printer-status-illo-grey">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.9999 3H4.99994V7H4C2.89543 7 2 7.89543 2 9V14H4.99994V17H10.8026C10.4513 16.3926 10.2033 15.7179 10.0829 15H6.99994V12H10.3414C11.165 9.66962 13.3875 8 15.9999 8C16.6542 8 17.284 8.10471 17.8734 8.29829C17.5892 7.53986 16.8577 7 16 7H14.9999V3ZM6.99994 5H12.9999V7H6.99994V5Z" fill="var(--cros-sys-on_primary_container)"></path>
        <circle cx="16" cy="14" r="3" fill="var(--cros-sys-disabled_opaque)"></circle>
      </g>
      <g id="printer-status-illo-red">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.9999 3H4.99994V7H4C2.89543 7 2 7.89543 2 9V14H4.99994V17H10.8026C10.4513 16.3926 10.2033 15.7179 10.0829 15H6.99994V12H10.3414C11.165 9.66962 13.3875 8 15.9999 8C16.6542 8 17.284 8.10471 17.8734 8.29829C17.5892 7.53986 16.8577 7 16 7H14.9999V3ZM6.99994 5H12.9999V7H6.99994V5Z" fill="var(--cros-sys-on_primary_container)"></path>
        <circle cx="16" cy="14" r="3" fill="var(--cros-sys-error)"></circle>
      </g>
      <g id="printer-status-illo-orange">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.9999 3H4.99994V7H4C2.89543 7 2 7.89543 2 9V14H4.99994V17H10.8026C10.4513 16.3926 10.2033 15.7179 10.0829 15H6.99994V12H10.3414C11.165 9.66962 13.3875 8 15.9999 8C16.6542 8 17.284 8.10471 17.8734 8.29829C17.5892 7.53986 16.8577 7 16 7H14.9999V3ZM6.99994 5H12.9999V7H6.99994V5Z" fill="var(--cros-sys-on_primary_container)"></path>
        <circle cx="16" cy="14" r="3" fill="var(--cros-sys-warning)"></circle>
      </g>
      <g id="printer-plain">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M5 3H15V7H16C17.1046 7 18 7.89543 18 9V14H15V17H5V14H2V9C2 7.89543 2.89543 7 4 7H5V3ZM13 5H7V7H13V5ZM16 10C16 10.5523 15.5523 11 15 11C14.4477 11 14 10.5523 14 10C14 9.44772 14.4477 9 15 9C15.5523 9 16 9.44772 16 10ZM7 12H13V15H7V12Z" fill="var(--cros-sys-on_primary_container)"></path>
      </g>
      <g id="printer-setup" viewBox="0 0 48 48">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M9 19C7.89543 19 7 19.8954 7 21V34C7 35.1046 7.89543 36 9 36H39C40.1046 36 41 35.1046 41 34V21C41 19.8954 40.1046 19 39 19H9ZM35 29H13V33H35V29Z" fill="var(--cros-sys-illo-color1-1)"></path>
        <circle cx="11.5" cy="23.5" r="1.5" fill="var(--cros-sys-illo-color1)"></circle>
        <rect x="14" y="30" width="20" height="12" rx="1" fill="var(--cros-sys-illo-color1-2)"></rect>
        <path d="M14 9C14 8.44772 14.4477 8 15 8H33C33.5523 8 34 8.44772 34 9V18H14V9Z" fill="var(--cros-sys-illo-color1-2)"></path>
        <path d="M12 15C12 14.4477 12.4477 14 13 14H35C35.5523 14 36 14.4477 36 15V18H12V15Z" fill="var(--cros-sys-illo-color1-1)"></path>
        <line x1="17" y1="34.25" x2="31" y2="34.25" stroke="var(--cros-sys-illo-color1-1)" stroke-width="1.5"></line>
        <line x1="17" y1="38.25" x2="31" y2="38.25" stroke="var(--cros-sys-illo-color1-1)" stroke-width="1.5"></line>
        <circle cx="35" cy="15" r="9" fill="var(--cros-sys-illo-color1)" stroke="var(--cros-sys-illo-base)" stroke-width="2"></circle>
        <path d="M34.1209 16.7814V16.3209C34.1209 16.014 34.1628 15.7442 34.2465 15.5116C34.3302 15.2698 34.4651 15.0326 34.6512 14.8C34.8465 14.5674 35.0977 14.3163 35.4047 14.0465C35.5721 13.8977 35.7163 13.7581 35.8372 13.6279C35.9581 13.4977 36.0465 13.3628 36.1023 13.2233C36.1674 13.0837 36.2 12.9256 36.2 12.7488C36.2 12.4698 36.093 12.2279 35.8791 12.0233C35.6744 11.8186 35.3907 11.7163 35.0279 11.7163C34.7674 11.7163 34.5395 11.7721 34.3442 11.8837C34.1581 11.9953 34.0047 12.1395 33.8837 12.3163C33.7628 12.4837 33.6698 12.6651 33.6047 12.8605L32 12.1907C32.1023 11.8372 32.2791 11.493 32.5302 11.1581C32.7907 10.8233 33.1256 10.5488 33.5349 10.3349C33.9442 10.1116 34.4279 10 34.986 10C35.5814 10 36.1023 10.1163 36.5488 10.3488C37.0047 10.5814 37.3581 10.8977 37.6093 11.2977C37.8698 11.6977 38 12.1488 38 12.6512C38 13.0047 37.9442 13.3163 37.8326 13.586C37.7302 13.8558 37.586 14.1023 37.4 14.3256C37.214 14.5488 37.0093 14.7674 36.786 14.9814C36.5814 15.1767 36.4186 15.3535 36.2977 15.5116C36.1767 15.6605 36.0884 15.8186 36.0326 15.986C35.986 16.1442 35.9628 16.3349 35.9628 16.5581V16.7814H34.1209ZM35.0279 20.2977C34.693 20.2977 34.4047 20.1814 34.1628 19.9488C33.9302 19.707 33.814 19.4186 33.814 19.0837C33.814 18.7488 33.9302 18.4651 34.1628 18.2326C34.4047 18 34.693 17.8837 35.0279 17.8837C35.3628 17.8837 35.6465 18 35.8791 18.2326C36.1116 18.4651 36.2279 18.7488 36.2279 19.0837C36.2279 19.4186 36.1116 19.707 35.8791 19.9488C35.6465 20.1814 35.3628 20.2977 35.0279 20.2977Z" fill="var(--cros-sys-illo-base)"></path>
      </g>

      <!-- Privacy section -->
      <g id="privacy-controls" viewBox="0 0 15 20">
        <path fill-rule="evenodd" d="M6.896 9.792V1.625a.79.79 0 0 1 .229-.583.8.8 0 0 1 .583-.25c.236 0 .43.083.584.25a.79.79 0 0 1 .229.583v8.167H6.896Zm-3.021 0V2.646a.79.79 0 0 1 .23-.583.765.765 0 0 1 .562-.23.79.79 0 0 1 .583.23c.167.152.25.347.25.583v7.146H3.875ZM7.5 19.167c-1.847 0-3.424-.646-4.73-1.938C1.48 15.938.834 14.361.834 12.5V4.646a.79.79 0 0 1 .23-.583.79.79 0 0 1 .583-.23c.222 0 .41.077.562.23.167.152.25.347.25.583V12.5c0 1.403.486 2.597 1.459 3.583.986.973 2.18 1.459 3.583 1.459s2.59-.486 3.563-1.459c.986-.986 1.479-2.18 1.479-3.583V9.563H12.5a.906.906 0 0 0-.667.27.906.906 0 0 0-.27.667v3.188H8.75c-.458 0-.854.166-1.187.5-.334.319-.5.715-.5 1.187v.5H5.438v-.5c0-.93.319-1.715.958-2.354a3.21 3.21 0 0 1 2.354-.98h1.188V3.647a.79.79 0 0 1 .229-.583.79.79 0 0 1 .583-.23c.222 0 .41.077.563.23.166.152.25.347.25.583v4.479a1.61 1.61 0 0 1 .458-.146c.166-.028.326-.042.479-.042h1.667V12.5c0 1.861-.646 3.438-1.938 4.73-1.291 1.29-2.868 1.937-4.729 1.937Z"></path>
      </g>
      <g id="sync" viewBox="0 0 17 14">
        <path fill-rule="evenodd" d="M1.5 13.104v-1.583h1.396a6.354 6.354 0 0 1-1.48-2A5.912 5.912 0 0 1 .876 7c0-1.444.444-2.715 1.333-3.812a6.102 6.102 0 0 1 3.417-2.125v1.791a4.424 4.424 0 0 0-2.167 1.563c-.57.736-.854 1.597-.854 2.583 0 .653.132 1.25.396 1.792a4.708 4.708 0 0 0 1.02 1.396V9h1.584v4.104H1.5Zm8.875.167c-.68 0-1.257-.23-1.73-.688a2.364 2.364 0 0 1-.687-1.708c0-.667.223-1.23.667-1.687a2.321 2.321 0 0 1 1.646-.709 2.57 2.57 0 0 1 .958-1.083 2.639 2.639 0 0 1 1.48-.438c.708 0 1.319.223 1.833.667.514.43.805.965.875 1.604.514.042.951.257 1.312.646.361.375.542.833.542 1.375 0 .556-.202 1.035-.604 1.438a1.953 1.953 0 0 1-1.438.583h-4.854ZM11.292 6a3.932 3.932 0 0 0-.521-1.208 4.22 4.22 0 0 0-.792-.98V5H8.396V.896H12.5v1.583h-1.396c.5.458.917.986 1.25 1.584A5.96 5.96 0 0 1 13.042 6h-1.75Zm-.917 5.625h4.875a.366.366 0 0 0 .27-.104c.07-.07.105-.16.105-.271a.336.336 0 0 0-.125-.27.414.414 0 0 0-.27-.105h-1.418V9.729c0-.305-.11-.562-.333-.77a1.082 1.082 0 0 0-.791-.334.992.992 0 0 0-.75.333 1.048 1.048 0 0 0-.313.771v.396h-1.25a.733.733 0 0 0-.542.208.707.707 0 0 0-.208.521c0 .222.07.41.208.563.14.139.32.208.542.208Z"></path>
      </g>
      <g id="lock" viewBox="0 0 16 16">
        <path fill-rule="evenodd" d="M7.958 15.167v-1.73h5.48V2.563h-5.48V.833h5.48c.486 0 .895.167 1.229.5.333.334.5.743.5 1.23v10.875c0 .486-.167.895-.5 1.229-.334.333-.743.5-1.23.5H7.959Zm-1.646-3.438-1.229-1.208L6.73 8.875H.833v-1.75H6.73L5.083 5.479l1.23-1.208L10.042 8l-3.73 3.73Z"></path>
      </g>
      <g id="privacy-manage-people" viewBox="0 0 18 15">
        <path fill-rule="evenodd" d="M7 6.917c-.889 0-1.639-.306-2.25-.917a3.104 3.104 0 0 1-.917-2.25c0-.889.306-1.639.917-2.25S6.111.583 7 .583 8.639.89 9.25 1.5s.917 1.361.917 2.25c0 .875-.306 1.625-.917 2.25-.611.611-1.361.917-2.25.917ZM.833 13.25v-2.083c0-.417.098-.785.292-1.104.208-.32.465-.57.77-.75a10.094 10.094 0 0 1 2.46-1.021A9.588 9.588 0 0 1 7 7.917c.153 0 .306.007.458.02.167 0 .334.007.5.021a6.548 6.548 0 0 0-.27.834c-.07.32-.125.61-.167.875l-.5-.021a8.38 8.38 0 0 0-2.188.291 7.683 7.683 0 0 0-2.041.855.338.338 0 0 0-.167.146.477.477 0 0 0-.062.25v.333h5.166c.07.291.174.59.313.896.152.305.312.583.479.833H.833Zm11.563.917-.271-1.188a5.91 5.91 0 0 1-.52-.229 2.764 2.764 0 0 1-.46-.333l-1.166.375-.729-1.25.875-.854a1.9 1.9 0 0 1-.083-.563c.014-.208.041-.403.083-.583l-.875-.834.73-1.27 1.145.333c.139-.125.292-.236.458-.333.18-.112.361-.188.542-.23l.292-1.187h1.458l.27 1.187c.181.056.355.132.522.23.18.097.34.208.479.333l1.146-.313.729 1.25-.854.813c.041.194.055.396.041.604 0 .194-.02.382-.062.563l.875.833-.73 1.25-1.166-.354a2.768 2.768 0 0 1-.458.333 2.48 2.48 0 0 1-.521.23l-.292 1.187h-1.458Zm.75-2.604c.403 0 .743-.146 1.02-.438.292-.292.438-.639.438-1.042 0-.402-.146-.743-.437-1.02a1.423 1.423 0 0 0-1.042-.438c-.389 0-.73.146-1.02.438a1.422 1.422 0 0 0-.438 1.041c0 .39.146.73.437 1.021.292.292.64.438 1.042.438ZM7 5.187c.403 0 .743-.138 1.02-.416a1.43 1.43 0 0 0 .418-1.021c0-.403-.146-.743-.438-1.02a1.364 1.364 0 0 0-1-.417 1.35 1.35 0 0 0-1.02.437 1.364 1.364 0 0 0-.418 1c0 .403.14.743.417 1.02A1.43 1.43 0 0 0 7 5.188Z"></path>
      </g>
      <g id="privacy-smart-privacy" viewBox="0 0 20 20">
        <path fill-rule="evenodd" d="m3.563 8.208 2.645-2.645H3.563v2.645Zm0 5 7.645-7.645H8.667l-5.104 5.104v2.541Zm1.229 1.23h11.646V5.563h-2.771l-8.875 8.875Zm-1.23 1.729c-.486 0-.895-.167-1.229-.5a1.671 1.671 0 0 1-.5-1.23V5.563c0-.487.167-.896.5-1.23a1.67 1.67 0 0 1 1.23-.5h12.875c.486 0 .895.167 1.229.5.333.334.5.743.5 1.23v8.875c0 .486-.167.895-.5 1.229-.334.333-.743.5-1.23.5H3.563Z"></path>
      </g>
      <g id="content-recommend" viewBox="0 0 20 20">
        <path fill-rule="evenodd" d="M8 13.98h3.375a.948.948 0 0 0 .52-.147.935.935 0 0 0 .376-.396l1.625-3.229c.028-.07.048-.139.062-.208A.786.786 0 0 0 14 9.75V9.5a.964.964 0 0 0-.292-.708A.964.964 0 0 0 13 8.5h-2.5l.417-2.042a.832.832 0 0 0-.021-.416.886.886 0 0 0-.23-.375L10 5 7.208 8.73c-.07.096-.125.194-.166.29A1.133 1.133 0 0 0 7 9.334v3.646c0 .278.097.514.292.709.194.194.43.291.708.291Zm2 4.187a8.205 8.205 0 0 1-3.187-.625 8.59 8.59 0 0 1-2.605-1.75 8.589 8.589 0 0 1-1.75-2.604A8.204 8.204 0 0 1 1.833 10c0-1.139.209-2.201.625-3.187a8.327 8.327 0 0 1 1.75-2.584 8.112 8.112 0 0 1 2.605-1.75c1-.43 2.062-.646 3.187-.646 1.139 0 2.201.216 3.188.646a7.88 7.88 0 0 1 2.583 1.75 7.82 7.82 0 0 1 1.75 2.604c.43.986.646 2.042.646 3.167a7.974 7.974 0 0 1-.646 3.188c-.417.986-1 1.854-1.75 2.604a8.262 8.262 0 0 1-2.604 1.75 8.053 8.053 0 0 1-3.167.625Zm0-1.73c1.792 0 3.313-.625 4.563-1.875 1.25-1.25 1.874-2.77 1.874-4.562 0-1.792-.625-3.312-1.875-4.562-1.25-1.25-2.77-1.875-4.562-1.875-1.792 0-3.312.624-4.562 1.874C4.188 6.688 3.563 8.209 3.563 10c0 1.792.624 3.313 1.874 4.563 1.25 1.25 2.771 1.874 4.563 1.874Z"></path>
      </g>
      <g id="privacy-verified-access" viewBox="0 0 20 20">
        <path fill-rule="evenodd" d="M10 12.167 7.833 10 10 7.833 12.167 10 10 12.167Zm-1.792-5.5L6.104 4.563 10 .667l3.896 3.896-2.104 2.104L10 4.875 8.208 6.667Zm-3.645 7.229L.667 10l3.896-3.896 2.104 2.104L4.875 10l1.792 1.792-2.104 2.104Zm10.875 0-2.105-2.104L15.125 10l-1.792-1.792 2.105-2.104L19.333 10l-3.895 3.896ZM10 19.333l-3.896-3.895 2.104-2.105L10 15.125l1.792-1.792 2.104 2.105L10 19.333Z"></path>
      </g>
      <g id="privacy-data-access-protection" viewBox="0 0 14 18">
        <path fill-rule="evenodd" d="M5.75 11.542h2.5l-.458-2.709c.236-.125.416-.305.541-.541.14-.25.209-.514.209-.792 0-.43-.153-.792-.459-1.083A1.437 1.437 0 0 0 7 5.958c-.43 0-.799.153-1.104.459A1.471 1.471 0 0 0 5.458 7.5c0 .278.063.542.188.792.139.236.326.416.562.541l-.458 2.709ZM7 17.167c-1.93-.459-3.528-1.535-4.792-3.23C.958 12.23.333 10.34.333 8.272V3.375L7 .833l6.667 2.542v4.896c0 2.07-.632 3.958-1.896 5.666-1.25 1.695-2.84 2.771-4.771 3.23Zm0-1.792c1.417-.458 2.59-1.347 3.52-2.667a7.502 7.502 0 0 0 1.418-4.437V4.562L7 2.668 2.063 4.563V8.27a7.58 7.58 0 0 0 1.395 4.437c.945 1.32 2.125 2.209 3.542 2.667Z"></path>
      </g>
      <g id="privacy-secure-dns" viewBox="0 0 18 18">
        <path fill-rule="evenodd" d="M9 17.167a8.205 8.205 0 0 1-3.187-.625 8.59 8.59 0 0 1-2.605-1.75 8.589 8.589 0 0 1-1.75-2.604A8.204 8.204 0 0 1 .833 9c0-1.125.223-2.18.667-3.167A8.557 8.557 0 0 1 3.27 3.23a8.112 8.112 0 0 1 2.605-1.75c1-.43 2.042-.646 3.125-.646.306 0 .59.014.854.042.264.028.465.062.604.104V6a30.905 30.905 0 0 0-.708-1.98c-.264-.665-.514-1.13-.75-1.394-.306.292-.562.778-.77 1.458-.195.68-.348 1.327-.46 1.938h2.688v1.5H7.583c-.027.278-.048.535-.062.77V9.73c.014.235.035.485.062.75h2.834c.027-.279.041-.536.041-.772v-.646c0-.194-.007-.423-.02-.687 0-.278-.007-.549-.021-.812h1.52c0 .319.007.61.021.875a11.264 11.264 0 0 1 .001 1.333c0 .236-.008.472-.021.708h3.312A5.462 5.462 0 0 0 15.438 9c0-.236-.021-.48-.063-.73a5.358 5.358 0 0 0-.125-.707h1.792c.041.277.07.527.083.75.028.222.042.45.042.687a7.872 7.872 0 0 1-.646 3.146c-.417.986-1 1.854-1.75 2.604a8.556 8.556 0 0 1-2.604 1.77A7.826 7.826 0 0 1 9 17.168Zm-6.25-6.688h3.313c-.028-.264-.05-.52-.063-.77v-1.48c.014-.236.035-.472.063-.708H2.75A5.466 5.466 0 0 0 2.563 9c0 .236.013.472.041.708.028.236.077.493.146.771Zm4.375 4.688a6.246 6.246 0 0 1-.52-1.396 17.79 17.79 0 0 1-.355-1.792H3.313A6.394 6.394 0 0 0 4.896 14c.667.556 1.41.944 2.229 1.167ZM3.313 6.02H6.25c.097-.653.215-1.25.354-1.792a6.973 6.973 0 0 1 .542-1.396 5.87 5.87 0 0 0-2.25 1.188 6.164 6.164 0 0 0-1.583 2ZM9 15.375c.222-.222.451-.653.688-1.292.236-.652.416-1.354.541-2.104H7.771c.125.75.298 1.452.52 2.104.237.64.473 1.07.709 1.292Zm1.875-.208A5.849 5.849 0 0 0 13.083 14a6.266 6.266 0 0 0 1.604-2.02H11.73c-.083.652-.201 1.25-.354 1.79a7.053 7.053 0 0 1-.5 1.397Zm1.063-9.104V.832h5.229v5.23h-5.23Zm2.687-2.688h1.354V2.021h-1.354v1.354Z"></path>
      </g>

      <!-- System Preferences -->
      <g id="sanitize" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M4.5 17.167c-.458 0-.854-.16-1.188-.48-.319-.333-.479-.729-.479-1.187v-3.583a1.944 1.944 0 0 0 1.313-.584c.36-.375.542-.82.542-1.333 0-.514-.181-.951-.542-1.313a1.906 1.906 0 0 0-1.313-.604V4.5c0-.236.042-.451.125-.646.084-.208.202-.389.354-.542l1.25 1.25v2.271a3.247 3.247 0 0 1 1.355 1.313c.333.57.5 1.187.5 1.854 0 .68-.167 1.306-.5 1.875-.32.57-.771 1.007-1.354 1.313v2.25h2.25a3.382 3.382 0 0 1 1.333-1.355c.57-.333 1.187-.5 1.854-.5s1.285.167 1.854.5c.57.32 1.014.771 1.334 1.354h2.25l1.25 1.25c-.153.153-.334.271-.542.355-.195.083-.41.125-.646.125h-3.583a1.906 1.906 0 0 0-.604-1.313A1.788 1.788 0 0 0 10 15.313c-.514 0-.958.18-1.333.541a1.944 1.944 0 0 0-.584 1.313H4.5Zm12.667-2.292-1.73-1.73V10.5h1.542a.459.459 0 0 0 .334-.146.454.454 0 0 0 .166-.354.454.454 0 0 0-.166-.354.459.459 0 0 0-.334-.146h-1.541V4.562H10.5V3.022a.459.459 0 0 0-.146-.333A.454.454 0 0 0 10 2.52a.454.454 0 0 0-.354.167.459.459 0 0 0-.146.333v1.542H6.854l-1.729-1.73h2.73a2.17 2.17 0 0 1 .666-1.458C8.937.986 9.43.792 10 .792c.57 0 1.056.194 1.458.583.417.389.646.875.688 1.458H15.5c.458 0 .847.167 1.167.5.333.32.5.709.5 1.167v3.354c.583.042 1.07.271 1.458.688.389.402.583.889.583 1.458 0 .57-.194 1.063-.583 1.48a2.17 2.17 0 0 1-1.458.666v2.729Zm-.98 3.458L1.668 3.813 2.77 2.708 17.29 17.23l-1.104 1.104Z"></g>
      <g id="system-preferences" viewBox="0 0 20 20"><path fill-rule="evenodd" clip-rule="evenodd" d="M8.519 18h2.96c.59 0 1.087-.422 1.167-.953l.216-1.491a8.54 8.54 0 0 0 .623-.36l1.44.563c.552.21 1.168-.008 1.44-.492l1.487-2.514a1.127 1.127 0 0 0-.296-1.453l-1.215-.93c.008-.116.016-.233.016-.358 0-.125-.008-.242-.016-.36l1.215-.929a1.13 1.13 0 0 0 .288-1.468l-1.471-2.483c-.272-.484-.888-.71-1.456-.507l-1.44.562a7.26 7.26 0 0 0-.631-.36l-.216-1.475c-.072-.57-.568-.992-1.16-.992H8.511c-.584 0-1.08.43-1.152.976l-.216 1.492a8.51 8.51 0 0 0-.623.359l-1.448-.57c-.544-.211-1.16.008-1.432.492l-1.48 2.49a1.106 1.106 0 0 0 .297 1.469l1.215.929a5.394 5.394 0 0 0-.016.36c0 .124.008.241.016.358l-1.223.93c-.448.343-.568.952-.288 1.468l1.463 2.475c.272.484.888.71 1.448.508l1.44-.563c.208.133.415.25.631.36l.216 1.475c.072.57.568.992 1.16.992Zm2.542-2H8.947l-.291-1.854-.406-.16a4.35 4.35 0 0 1-1.018-.56l-.345-.255-1.83.698L4 12.124l1.555-1.15-.054-.407A3.476 3.476 0 0 1 5.455 10c0-.19.023-.385.046-.575l.054-.407L4 7.87l1.064-1.738 1.823.69.345-.24a4.91 4.91 0 0 1 1.026-.574l.406-.152L8.947 4h2.114l.283 1.855.398.16c.352.138.697.327 1.019.56l.344.254 1.83-.698L16 7.876l-1.555 1.15.054.407c.023.182.046.37.046.567 0 .19-.021.366-.044.548l-.002.02-.054.407L16 12.123l-1.057 1.745-1.822-.698-.345.247c-.352.248-.69.437-1.026.568l-.406.16L11.061 16ZM11 8a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm-1.5 5a.5.5 0 0 1-.5-.5V10a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5v2.5a.5.5 0 0 1-.5.5h-1Z"></path></g>
      <g id="storage" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M1.77 16.375v-3.292h16.46v3.292H1.77Zm1.73-.854h1.583v-1.584H3.5v1.584ZM1.77 6.917V3.625h16.46v3.292H1.77Zm1.73-.854h1.583V4.479H3.5v1.583Zm-1.73 5.583V8.354h16.46v3.292H1.77Zm1.73-.854h1.583V9.208H3.5v1.584Z"></path></g>
      <g id="clock" viewBox="0 0 24 24"><path d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm.5-13H11v6l5.25 3.15.75-1.23-4.5-2.67z"></path></g>
      <g id="24hour" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M9.063 16.462H4v-3.039a1 1 0 0 1 1-1h2.375v-.808H4V10h4.063a1 1 0 0 1 1 1v2.039a1 1 0 0 1-1 1H5.688v.807h3.375v1.616ZM16 16.462h-1.688v-1.616h-2.374a1 1 0 0 1-1-1V10h1.687v3.23h1.688V10H16v6.462Z"></path><path fill="none" stroke="var(--cros-sys-primary)" stroke-width="2" d="M18 10a8 8 0 0 0-16 0"></path></g>
      <g id="set-date-time" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M4.563 7.5h10.875V5.562H4.562V7.5Zm0 0V5.562 7.5Zm0 10.667c-.487 0-.896-.167-1.23-.5a1.671 1.671 0 0 1-.5-1.23V5.563c0-.472.167-.875.5-1.208.348-.347.757-.52 1.23-.52H6v-2h1.625v2h4.75v-2H14v2h1.438c.472 0 .874.173 1.208.52.347.333.52.736.52 1.208v4.355a3.444 3.444 0 0 0-.833-.271 6.34 6.34 0 0 0-.895-.146V9H4.562v7.438h5.209c.083.319.194.625.333.916.153.278.327.549.521.813H4.562Zm10.52.833c-1.11 0-2.055-.389-2.833-1.167-.778-.777-1.167-1.722-1.167-2.833 0-1.111.39-2.056 1.167-2.833A3.927 3.927 0 0 1 15.104 11c1.097 0 2.035.389 2.813 1.167.777.777 1.166 1.722 1.166 2.833 0 1.111-.389 2.056-1.166 2.833-.778.778-1.723 1.167-2.834 1.167Zm1.146-2.104.771-.75-1.375-1.375v-1.813h-1.063v2.271l1.667 1.667Z"></path></g>
      <g id="restore" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 11.583a1.53 1.53 0 0 1-1.125-.458A1.575 1.575 0 0 1 8.417 10c0-.43.152-.799.458-1.104.32-.32.694-.48 1.125-.48.43 0 .799.16 1.104.48.32.305.48.673.48 1.104 0 .444-.16.82-.48 1.125a1.505 1.505 0 0 1-1.104.458Zm0 5.584c-1.986 0-3.68-.695-5.083-2.084C3.514 13.694 2.819 12 2.833 10h1.73c.027 1.514.562 2.799 1.604 3.854C7.222 14.91 8.5 15.438 10 15.438c1.514 0 2.799-.528 3.854-1.584 1.056-1.055 1.584-2.34 1.584-3.854 0-1.514-.528-2.799-1.584-3.854C12.8 5.09 11.514 4.563 10 4.563c-.778 0-1.52.166-2.23.5-.707.319-1.326.77-1.853 1.354H8V8H2.875V2.875h1.583V5.5c.68-.847 1.5-1.5 2.459-1.958A6.882 6.882 0 0 1 10 2.833c.986 0 1.917.188 2.792.563a6.996 6.996 0 0 1 2.27 1.542 7.165 7.165 0 0 1 1.521 2.27c.39.861.584 1.792.584 2.792 0 1-.195 1.938-.584 2.813a7.49 7.49 0 0 1-1.52 2.27 7.165 7.165 0 0 1-2.271 1.521 7.012 7.012 0 0 1-2.792.563Z"></path></g>
      <g id="snap-window-suggestions" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M12.5 17q-.625 0-1.062-.437A1.45 1.45 0 0 1 11 15.5v-11q0-.604.438-1.042A1.41 1.41 0 0 1 12.5 3h3q.604 0 1.042.458Q17 3.896 17 4.5v11q0 .624-.458 1.063A1.42 1.42 0 0 1 15.5 17zm-8 0q-.625 0-1.062-.437A1.45 1.45 0 0 1 3 15.5v-11q0-.604.438-1.042A1.41 1.41 0 0 1 4.5 3h3q.604 0 1.042.458Q9 3.896 9 4.5v11q0 .624-.458 1.063A1.42 1.42 0 0 1 7.5 17zm0-12.5v11h3v-11zm3 11h-3z"></path></g>
      <g id="battery-charging-80" viewBox="0 0 24 24"><path fill-rule="evenodd" d="M8 22C7.71667 22 7.475 21.9083 7.275 21.725C7.09167 21.525 7 21.2833 7 21V5C7 4.71667 7.09167 4.48333 7.275 4.3C7.475 4.1 7.71667 4 8 4H10V2H14V4H16C16.2833 4 16.5167 4.1 16.7 4.3C16.9 4.48333 17 4.71667 17 5V12C15.3333 12.0167 13.9167 12.6083 12.75 13.775C11.5833 14.925 11 16.3333 11 18C11 18.7667 11.1333 19.4917 11.4 20.175C11.6667 20.8583 12.0417 21.4667 12.525 22H8ZM9 10H15V6H9V10ZM16.5 22V19H14L17.5 14V17H20L16.5 22Z"></path></g>

      <!-- General OS Settings icons -->
      <g id="account" viewBox="0 0 20 20"><path fill-rule="evenodd" clip-rule="evenodd" d="M7.6 9.8a1 1 0 1 0 0 2 1 1 0 0 0 0-2Zm4.8 0a1 1 0 1 0 0 2 1 1 0 0 0 0-2ZM10 2c-4.416 0-8 3.584-8 8s3.584 8 8 8 8-3.584 8-8-3.584-8-8-8Zm0 14.4A6.409 6.409 0 0 1 3.6 10c0-.232.016-.464.04-.688a8.05 8.05 0 0 0 4.168-4.296 7.98 7.98 0 0 0 8.328 3.176c.168.568.264 1.176.264 1.808 0 3.528-2.872 6.4-6.4 6.4Z"/></g>
      <g id="android"><path fill-rule="evenodd" clip-rule="evenodd" d="M7.15545 1.37568C7.05465 1.22183 6.84735 1.17314 6.6918 1.26969C6.54236 1.36576 6.49393 1.55821 6.57371 1.71244L7.41124 3.15992C6.02666 3.96928 5.12596 5.40608 5 7.00763H15C14.874 5.40607 13.9733 3.96926 12.5887 3.15991L13.4251 1.71451L13.4262 1.71238C13.5114 1.54737 13.4473 1.34438 13.2866 1.25867C13.1324 1.17889 12.9404 1.2266 12.8443 1.37604L11.9968 2.83646L11.9911 2.83895C11.9846 2.84172 11.9767 2.84511 11.9674 2.84906C10.7051 2.33473 9.29491 2.33473 8.03265 2.84904L8.00441 2.83702L8.00315 2.83647L7.15693 1.37795L7.15545 1.37568ZM8 5.5C8.27614 5.5 8.5 5.27614 8.5 5C8.5 4.72386 8.27614 4.5 8 4.5C7.72386 4.5 7.5 4.72386 7.5 5C7.5 5.27614 7.72386 5.5 8 5.5ZM12.5 5C12.5 5.27614 12.2761 5.5 12 5.5C11.7239 5.5 11.5 5.27614 11.5 5C11.5 4.72386 11.7239 4.5 12 4.5C12.2761 4.5 12.5 4.72386 12.5 5Z"></path><path d="M5 7.50378H15V14.5038C15 15.0561 14.5523 15.5038 14 15.5038H6C5.44772 15.5038 5 15.0561 5 14.5038V7.50378Z"></path><rect x="7" y="14.5038" width="2" height="4" rx="1"></rect><rect x="11" y="14.5038" width="2" height="4" rx="1"></rect><rect x="3" y="7.50378" width="1.5" height="6.5" rx="0.75"></rect><rect x="15.5" y="7.50378" width="1.5" height="6.5" rx="0.75"></rect></g>
      <g id="apps" viewBox="0 0 20 20"><path fill="none"/><path d="M15 7c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2ZM5 17c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2ZM15 17c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2ZM12 15c0 1.1-.9 2-2 2s-2-.9-2-2 .9-2 2-2 2 .9 2 2ZM7 5c0 1.1-.9 2-2 2s-2-.9-2-2 .9-2 2-2 2 .9 2 2ZM10 7c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2ZM17 10c0 1.1-.9 2-2 2s-2-.9-2-2 .9-2 2-2 2 .9 2 2ZM5 12c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2ZM12 10c0 1.1-.9 2-2 2s-2-.9-2-2 .9-2 2-2 2 .9 2 2Z"/></g>
      <g id="assistant"><path d="M6.36364 3C8.77382 3 10.7273 4.95418 10.7273 7.36364C10.7273 9.77309 8.77382 11.7273 6.36364 11.7273C3.95345 11.7273 2 9.77309 2 7.36364C2 4.95418 3.95345 3 6.36364 3Z"></path><path d="M18 6.99997C18 7.60215 17.5113 8.09088 16.9091 8.09088C16.3069 8.09088 15.8182 7.60215 15.8182 6.99997C15.8182 6.39778 16.3069 5.90906 16.9091 5.90906C17.5113 5.90906 18 6.39778 18 6.99997Z"></path><path d="M15.8182 9.54547C15.8182 10.7506 14.8414 11.7273 13.6363 11.7273C12.4313 11.7273 11.4545 10.7506 11.4545 9.54547C11.4545 8.34037 12.4313 7.36365 13.6363 7.36365C14.8414 7.36365 15.8182 8.34037 15.8182 9.54547Z"></path><path d="M13.6363 17.5455C15.0422 17.5455 16.1818 16.4059 16.1818 15C16.1818 13.5942 15.0422 12.4546 13.6363 12.4546C12.2305 12.4546 11.0909 13.5942 11.0909 15C11.0909 16.4059 12.2305 17.5455 13.6363 17.5455Z"></path></g>
      <g id="audio"><path fill-rule="evenodd" clip-rule="evenodd" d="M1 13H4.46667L8 16.4V3.40002L4.46667 7.00002H1V13ZM10 6.40002V13.4C11.776 12.7652 12.5 10.9044 12.5 9.90002C12.5 8.89568 11.776 7.0435 10 6.40002ZM10 4.16171C12.4771 4.89717 14.5 7.18908 14.5 9.90002C14.5 12.611 12.4771 14.9029 10 15.6383V17.4C13.4371 16.6218 16 13.5602 16 9.90002C16 6.23982 13.4371 3.17825 10 2.40002V4.16171Z"></path></g>
      <g id="auth-key"><path d="M6.364 5C3.956 5 2 7.018 2 9.5S3.956 14 6.364 14c1.898 0 3.512-1.252 4.11-3H13.5v3h3v-3H18V8h-7.527c-.597-1.747-2.21-3-4.11-3zm0 6c-.8 0-1.455-.675-1.455-1.5S5.563 8 6.363 8c.8 0 1.454.675 1.454 1.5S7.164 11 6.364 11z"></path></g>
      <g id="autoclick" viewBox="0 0 20 20"><path fill-rule="evenodd" clip-rule="evenodd" d="M7 10a3 3 0 1 0 6 0 3 3 0 0 0-6 0Zm4 0a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z" fill="var(--cros-sys-primary)"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M10 2c-4.416 0-8 3.584-8 8s3.584 8 8 8 8-3.584 8-8-3.584-8-8-8Zm0 14c-3.308 0-6-2.693-6-6 0-3.308 2.692-6 6-6 3.307 0 6 2.692 6 6 0 3.307-2.693 6-6 6Z" fill="var(--cros-sys-primary)"></path></g>
      <g id="camera"><path d="M10 13C11.3807 13 12.5 11.8807 12.5 10.5C12.5 9.11929 11.3807 8 10 8C8.61929 8 7.5 9.11929 7.5 10.5C7.5 11.8807 8.61929 13 10 13Z" fill="#1B1B1F"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M12 3H8L6 5H4C3.44772 5 3 5.44772 3 6V15C3 15.5523 3.44772 16 4 16H16C16.5523 16 17 15.5523 17 15V6C17 5.44772 16.5523 5 16 5H14L12 3ZM5 7H15V14H5V7Z" fill="#1B1B1F"></path></g>
      <g id="cellular"><path fill-rule="evenodd" clip-rule="evenodd" d="M15.002 15.002V7.41622L7.41622 15.002H15.002ZM16.002 17.002C16.5543 17.002 17.002 16.5543 17.002 16.002V5.002C17.002 4.1111 15.9249 3.66493 15.2949 4.2949L4.2949 15.2949C3.66493 15.9249 4.1111 17.002 5.002 17.002H16.002Z"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M13.5 16.002C13.5 16.5543 13.0523 17.002 12.5 17.002H5.002C4.1111 17.002 3.66493 15.9249 4.2949 15.2949L11.7929 7.79289C12.4229 7.16293 13.5 7.6091 13.5 8.5V16.002Z"></path></g>
      <g id="chrome" viewBox="0 0 20 20"><path d="M17.418 6.25h-7.417c-1.833 0-3.416 1.417-3.666 3.166l-2.75-4.75c1.5-1.833 3.833-3 6.416-3 3.25 0 6.084 1.834 7.417 4.584Z"/><path d="M6.751 11.833c.667 1.167 1.834 1.917 3.25 1.917.5 0 .917-.084 1.417-.25l-2.75 4.75c-4-.667-7-4.084-7-8.25 0-1.667.5-3.25 1.333-4.583l3.75 6.416Z"/><path d="M13.751 10c0 .666-.166 1.333-.5 1.833l-3.75 6.5h.5c4.584 0 8.334-3.75 8.334-8.333 0-1-.167-2-.5-2.917h-5.5c.833.667 1.416 1.75 1.416 2.917Z"/><path d="M12.918 10a2.917 2.917 0 1 1-5.833 0 2.917 2.917 0 0 1 5.833 0Z"/></g>
      <g id="cloud-off"><path d="M16.4732571,13.3443682 C16.8002856,12.9882746 17,12.5134184 17,11.9922 C17,10.8882 16.104,9.9922 15,9.9922 L13.494,9.9922 L13.494,9.0002 C13.494,7.0672 11.927,5.5002 9.994,5.5002 C9.5847901,5.5002 9.1930204,5.57089988 8.82954884,5.70065995 L7.33083687,4.20194798 C8.11843435,3.75577808 9.02717677,3.5002 10,3.5002 C12.71,3.5002 14.957,5.4612 15.411,8.0412 C17.424,8.2502 19,9.9312 19,12.0002 C19,13.0718701 18.5784721,14.0451601 17.8921876,14.7632987 L16.4732571,13.3443682 Z M17.8711111,17 L16.8711111,18 L14.8713111,16.0002 L6,16.0002 C3.239,16.0002 1,13.7622 1,11.0002 C1,8.58475294 2.71868905,6.59044755 4.99627833,6.12516722 L2,3.12888889 L3,2.12888889 L17.8711111,17 Z M6.86331111,7.9922 L6,7.9922 C4.343,7.9922 3,9.3352 3,10.9922 C3,12.6492 4.343,13.9922 6,13.9922 L12.8633111,13.9922 L6.86331111,7.9922 Z"></path></g>
      <g id="color-correction" viewBox="0 0 20 20"><path d="M1.19209e-07 14.0833V10.375L7.125 3.25L6 2.14583L7.0625 1.08333L8.5625 2.58333L10.8542 0.291665C11.0069 0.138887 11.1875 0.0624986 11.3958 0.0624986C11.6181 0.0624986 11.8056 0.138887 11.9583 0.291665L13.7708 2.125C13.9236 2.27778 14 2.46528 14 2.6875C14 2.89583 13.9236 3.07639 13.7708 3.22917L11.5 5.5L13 7.02083L11.9375 8.08333L10.8125 6.95833L3.70833 14.0833H1.19209e-07ZM1.5 12.5833H3.08333L9.75 5.91667L8.1875 4.33333L1.5 11V12.5833ZM10.3333 4.5625L12.2083 2.66667L11.4167 1.85417L9.52083 3.72917L10.3333 4.5625ZM10.3333 4.5625L9.52083 3.72917L10.3333 4.5625Z"></g>
      <g id="connected-devices" viewBox="0 0 20 20"><path d="M6.306 16.405h-2.37c-.553 0-1.014-.184-1.383-.553A1.919 1.919 0 0 1 2 14.469V5.936c0-.54.184-.994.553-1.363A1.884 1.884 0 0 1 3.936 4h12.326v1.936H3.936v8.533h2.37v1.936Zm1.422 0v-1.56a2.32 2.32 0 0 1-.79-.85 2.607 2.607 0 0 1-.257-1.146c0-.408.093-.79.277-1.145.184-.356.441-.646.77-.87v-1.58h2.845v1.56c.316.238.56.534.73.89.185.342.277.717.277 1.126 0 .395-.085.777-.257 1.145a2.038 2.038 0 0 1-.75.85v1.58H7.728Zm1.403-2.726c.25 0 .454-.079.612-.237A.836.836 0 0 0 10 12.83a.773.773 0 0 0-.257-.593.795.795 0 0 0-.612-.257.836.836 0 0 0-.612.257.773.773 0 0 0-.257.593c0 .237.085.44.257.612a.872.872 0 0 0 .612.237Zm7.862 2.726h-3.516a.993.993 0 0 1-.731-.296 1.057 1.057 0 0 1-.277-.751V8.879c0-.303.092-.553.277-.75a.993.993 0 0 1 .73-.297h3.517a.93.93 0 0 1 .71.296c.198.198.297.448.297.751v6.479c0 .303-.099.553-.296.75a.929.929 0 0 1-.711.297Zm-2.944-1.58h2.37V9.412h-2.37v5.413Z"/></g>
      <g id="contrast" viewBox="0 0 20 20"><path fill-rule="evenodd" clip-rule="evenodd" d="M18 10a8 8 0 1 1-16 0 8 8 0 0 1 16 0Zm-1.882 0A6.118 6.118 0 0 0 10 3.882v12.236A6.118 6.118 0 0 0 16.118 10Z"></path></g>
      <g id="cursor-click" viewBox="0 0 15 15"><path fill-rule="evenodd" d="M6.042 11.23c-1.459.013-2.702-.487-3.73-1.5C1.286 8.7.772 7.457.772 6c0-1.458.507-2.694 1.52-3.708C3.307 1.278 4.542.77 6 .77c1.458 0 2.694.514 3.708 1.542 1.028 1.027 1.535 2.27 1.521 3.729L9.563 5.5a3.436 3.436 0 0 0-1.209-2.187A3.463 3.463 0 0 0 6 2.417c-.986 0-1.833.354-2.542 1.062A3.434 3.434 0 0 0 2.417 6c0 .889.291 1.674.875 2.354A3.579 3.579 0 0 0 5.5 9.563l.542 1.666Zm7.125 3.416-3.5-3.5-1.125 2.979L6 6l8.125 2.542-2.98 1.104 3.5 3.52-1.478 1.48Z"></path></g>
      <g id="dictation" viewBox="0 0 20 20"><path fill-rule="evenodd" clip-rule="evenodd" d="m12.571 4.5-.008 5c0 1.383-1.14 2.5-2.563 2.5-1.423 0-2.571-1.117-2.571-2.5v-5C7.429 3.117 8.577 2 10 2c1.423 0 2.571 1.117 2.571 2.5Zm-2.524-1a1 1 0 0 0-1 .992l-.04 5a1 1 0 0 0 2 .016l.04-5a1 1 0 0 0-1-1.008ZM10 13.874c-2.366 0-4.543-1.769-4.543-4.295H4c0 2.88 2.331 5.246 5.143 5.659V18h1.714v-2.762C13.67 14.834 16 12.459 16 9.579h-1.457c0 2.526-2.177 4.295-4.543 4.295Z"></path></g>
      <g id="display"><path fill-rule="evenodd" clip-rule="evenodd" d="M17.5 3H2.5C1.6 3 1 3.7 1 4.55556V14.5C1 15.3556 1.6 16 2.5 16H7V18H13V16H17.5C18.4 16 19 15.3556 19 14.5V4.5C19 3.64444 18.4 3 17.5 3ZM17 14H3V5H17V14Z"></path></g>
      <g id="docked-magnifier" viewBox="0 0 20 20"><path d="M14 11V9h2V8h-2V6h-1v2h-2v1h2v2h1Z"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M17.5 3h-15C1.6 3 1 3.7 1 4.556V15.5c0 .856.6 1.5 1.5 1.5h15c.9 0 1.5-.644 1.5-1.5v-11c0-.856-.6-1.5-1.5-1.5Zm-.5 9H3V5h14v7Z"></path></g>
      <g id="reduced-animations" viewBox="0 -960 960 960"><path d="M360-80q-58 0-109-22t-89-60q-38-38-60-89T80-360q0-81 42-148t110-102q20-39 49.5-68.5T350-728q33-68 101-110t149-42q58 0 109 22t89 60q38 38 60 89t22 109q0 85-42 150T728-350q-20 39-49.5 68.5T610-232q-35 68-102 110T360-80Zm0-80q33 0 63.5-10t56.5-30q-58 0-109-22t-89-60q-38-38-60-89t-22-109q-20 26-30 56.5T160-360q0 42 16 78t43 63q27 27 63 43t78 16Zm120-120q33 0 64.5-10t57.5-30q-59 0-110-22.5T403-403q-38-38-60.5-89T320-602q-20 26-30 57.5T280-480q0 42 15.5 78t43.5 63q27 28 63 43.5t78 15.5Zm120-120q18 0 34.5-3t33.5-9q22-60 6.5-115.5T621-621q-38-38-93.5-53.5T412-668q-6 17-9 33.5t-3 34.5q0 42 15.5 78t43.5 63q27 28 63 43.5t78 15.5Zm160-78q20-26 30-57.5t10-64.5q0-42-15.5-78T741-741q-27-28-63-43.5T600-800q-35 0-65.5 10T478-760q59 0 110 22.5t89 60.5q38 38 60.5 89T760-478Z"></path></g>
      <g id="scroll-vertical" viewBox="0 0 8 18">
        <path fill="#1B1B1F" fill-rule="evenodd" clip-rule="evenodd"
          d="M3 3.29 1.128 5.245 0 4.09 4 0l4 4.09-1.128 1.155L5 3.37v11.34l1.872-1.956L8 13.91 4 18l-4-4.09 1.128-1.155L3 14.63V3.29Z">
        </path>
      </g>
      <g id="end-of-life-offer" viewBox="0 0 20 20"><path d="M7 20V18H17V20H7ZM11 16V7.825L8.4 10.4L7 9L12 4L17 9L15.6 10.4L13 7.825V16H11Z"></path></g>
      <g id="explore" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M9.854 18.167a8.144 8.144 0 0 1-3.125-.688 8.4 8.4 0 0 1-2.562-1.75 8.54 8.54 0 0 1-1.709-2.583A7.999 7.999 0 0 1 1.833 10c0-1.139.209-2.201.625-3.188A8.153 8.153 0 0 1 4.23 4.23a8.112 8.112 0 0 1 2.604-1.75A7.827 7.827 0 0 1 10 1.833c2.028 0 3.778.632 5.25 1.896 1.486 1.264 2.41 2.854 2.77 4.771h-1.77a6.056 6.056 0 0 0-1.333-2.667 6.267 6.267 0 0 0-2.438-1.75v.459A1.459 1.459 0 0 1 11 6.022H9.001v.999A.964.964 0 0 1 8.02 8h-1v2H8v1.958h-.98L3.709 8.646c-.041.222-.076.444-.104.666a5.54 5.54 0 0 0-.042.688c0 1.764.612 3.27 1.834 4.52 1.222 1.237 2.708 1.876 4.458 1.918v1.729Zm7.104-.459-2.562-2.583c-.278.167-.57.299-.875.396a3.396 3.396 0 0 1-.938.125c-1 0-1.847-.347-2.541-1.042A3.434 3.434 0 0 1 9 12.084c0-1 .347-1.848 1.042-2.542.694-.695 1.541-1.042 2.541-1.042.986 0 1.827.347 2.521 1.042a3.434 3.434 0 0 1 1.042 2.52c0 .348-.049.674-.146.98-.083.305-.208.59-.375.854l2.563 2.583-1.23 1.23Zm-4.395-3.791c.513 0 .95-.174 1.312-.521.361-.361.542-.799.542-1.313 0-.514-.18-.951-.542-1.312a1.72 1.72 0 0 0-1.292-.542c-.514 0-.951.18-1.312.542a1.72 1.72 0 0 0-.542 1.291c0 .514.174.952.521 1.313.361.361.799.542 1.313.542Z"></path></g>
      <g id="face-gaze"><path fill-rule="evenodd" clip-rule="evenodd" d="M7.875 16.125V14.375H10.4792L9.14583 12.2708C9.14583 12.2569 9.13889 12.25 9.125 12.25C9.125 12.2361 9.125 12.2222 9.125 12.2083V8.875H10.875V11.7708L12.2708 14.0417C12.3542 14.1528 12.4097 14.2708 12.4375 14.3958C12.4792 14.5069 12.5 14.6319 12.5 14.7708C12.5 15.1458 12.3611 15.4653 12.0833 15.7292C11.8194 15.9931 11.4931 16.125 11.1042 16.125H7.875ZM5.9375 12.0833C5.35417 12.0833 4.86111 11.8819 4.45833 11.4792C4.05556 11.0764 3.85417 10.5833 3.85417 10C3.85417 9.43056 4.05556 8.94444 4.45833 8.54167C4.86111 8.125 5.34722 7.91667 5.91667 7.91667C6.5 7.91667 6.99306 8.11806 7.39583 8.52083C7.79861 8.92361 8 9.41667 8 10C8 10.5694 7.79861 11.0625 7.39583 11.4792C6.99306 11.8819 6.50694 12.0833 5.9375 12.0833ZM14.0833 12.0833C13.5 12.0833 13.0069 11.8819 12.6042 11.4792C12.2014 11.0764 12 10.5833 12 10C12 9.43056 12.2014 8.94444 12.6042 8.54167C13.0069 8.125 13.4931 7.91667 14.0625 7.91667C14.6458 7.91667 15.1389 8.11806 15.5417 8.52083C15.9444 8.92361 16.1458 9.41667 16.1458 10C16.1458 10.5694 15.9444 11.0625 15.5417 11.4792C15.1389 11.8819 14.6528 12.0833 14.0833 12.0833ZM3.33333 6.52083L2.14583 5.3125C2.61806 4.88194 3.13889 4.54167 3.70833 4.29167C4.27778 4.04167 4.875 3.91667 5.5 3.91667C6.125 3.91667 6.72917 4.03472 7.3125 4.27083C7.89583 4.50694 8.40972 4.85417 8.85417 5.3125L7.66667 6.52083C7.36111 6.25694 7.02083 6.04861 6.64583 5.89583C6.28472 5.72917 5.90278 5.64583 5.5 5.64583C5.09722 5.64583 4.70833 5.72917 4.33333 5.89583C3.97222 6.0625 3.63889 6.27083 3.33333 6.52083ZM12.3333 6.52083L11.1458 5.3125C11.5903 4.85417 12.1042 4.50694 12.6875 4.27083C13.2708 4.03472 13.875 3.91667 14.5 3.91667C15.125 3.91667 15.7292 4.03472 16.3125 4.27083C16.8958 4.50694 17.4097 4.85417 17.8542 5.3125L16.6667 6.52083C16.3472 6.25694 16.0069 6.04861 15.6458 5.89583C15.2847 5.72917 14.9028 5.64583 14.5 5.64583C14.0972 5.64583 13.7153 5.72917 13.3542 5.89583C12.9931 6.04861 12.6528 6.25694 12.3333 6.52083Z"></path></g>
      <g id="fullscreen-magnifier" viewBox="0 0 20 20"><path d="M14 11V9h2V8h-2V6h-1v2h-2v1h2v2h1Z"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M17.5 3h-15C1.6 3 1 3.7 1 4.556V15.5c0 .856.6 1.5 1.5 1.5h15c.9 0 1.5-.644 1.5-1.5v-11c0-.856-.6-1.5-1.5-1.5ZM17 15H3V5h14v10Z"></path></g>
      <g id="geolocation"><path d="M12 8C12 9.10457 11.1046 10 10 10C8.89543 10 8 9.10457 8 8C8 6.89543 8.89543 6 10 6C11.1046 6 12 6.89543 12 8Z" fill="#1B1B1F"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M16 8C16 10.2091 14 13.5425 10 18C6 13.5425 4 10.2091 4 8C4 4.68629 6.68629 2 10 2C13.3137 2 16 4.68629 16 8ZM10 4C7.79086 4 6 5.79086 6 8C6 9.32543 7.318 11.7149 10 14.9435C12.682 11.7149 14 9.32543 14 8C14 5.79086 12.2091 4 10 4Z" fill="#1B1B1F"></path></g>
      <g id="google-drive" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M4.875 16.125h10.25l1.958-3.375-5.145-8.875H8.062L2.918 12.75l1.958 3.375Zm0 1.52c-.292 0-.556-.062-.792-.187a1.57 1.57 0 0 1-.541-.583L1.604 13.5a1.785 1.785 0 0 1-.208-.75c0-.278.07-.535.208-.77L6.73 3.124c.125-.236.306-.424.542-.563.25-.138.514-.208.792-.208h3.874c.264 0 .514.07.75.208.25.14.445.327.584.563l5.125 8.854c.11.236.166.493.166.771.014.264-.041.514-.166.75l-1.938 3.375c-.152.25-.347.444-.583.583a1.503 1.503 0 0 1-.75.188H4.875Zm1.292-3.624L5.604 13l3.667-6.417h1.458L14.396 13l-.563 1.02H6.167ZM7.646 12.5h4.708L10 8.396 7.646 12.5Z"></path></g>
      <g id="google-play"><path fill-rule="evenodd" clip-rule="evenodd" d="M16.8167 9.06658L14.2667 7.61658L11.8834 9.99991L14.2667 12.3832L16.8167 10.9332C17.275 10.6749 17.5 10.3416 17.5 9.99991C17.5 9.65824 17.275 9.32491 16.8167 9.06658ZM3.92498 2.04163C4.93332 3.04996 10.9417 9.05829 10.9417 9.05829L13.0666 6.93329L4.14998 1.88329C4.09165 1.84996 4.03332 1.82496 3.97498 1.79996C3.83332 1.74163 3.72498 1.84163 3.84998 1.97496C3.87498 1.99163 3.89998 2.01663 3.92498 2.04163ZM3.92501 17.9583C3.90001 17.9833 3.87501 18.0083 3.85834 18.025C3.73334 18.15 3.84168 18.2583 3.98334 18.2C4.04168 18.175 4.10001 18.15 4.15834 18.1166L13.0667 13.0667L10.9417 10.9417C10.9417 10.9417 4.94168 16.95 3.92501 17.9583ZM10 9.99995C10 9.99995 2.975 2.97495 2.81667 2.81662C2.65833 2.65828 2.5 2.75828 2.5 2.97495V17.025C2.5 17.2416 2.65833 17.3416 2.81667 17.1833C2.975 17.025 10 9.99995 10 9.99995Z"></path></g>
      <g id="hard-drive"><path d="M14 14C14 14.5523 13.5523 15 13 15C12.4477 15 12 14.5523 12 14C12 13.4477 12.4477 13 13 13C13.5523 13 14 13.4477 14 14Z"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M5 2C3.89543 2 3 2.89543 3 4V16C3 17.1046 3.89543 18 5 18H15C16.1046 18 17 17.1046 17 16V4C17 2.89543 16.1046 2 15 2H5ZM5 16H15V12H5V16ZM5 10H15V4H5V10Z"></path></g>
      <g id="help-me-read"><path fill-rule="evenodd" clip-rule="evenodd" d="M9.175 13.75V9.306h1.65v4.444h-1.65ZM10 8.406a.903.903 0 0 1-.637-.244.903.903 0 0 1-.244-.637.868.868 0 0 1 .881-.881c.25 0 .456.087.619.262a.808.808 0 0 1 .262.619.868.868 0 0 1-.881.881Zm5.662.863 1.557-1.556c.125.375.212.75.262 1.125.05.375.075.762.075 1.162 0 1.05-.2 2.031-.6 2.944a7.511 7.511 0 0 1-1.612 2.4 7.774 7.774 0 0 1-2.4 1.631 7.452 7.452 0 0 1-2.944.581 7.452 7.452 0 0 1-2.944-.581 7.774 7.774 0 0 1-2.4-1.631 7.774 7.774 0 0 1-1.631-2.4A7.452 7.452 0 0 1 2.444 10c0-1.063.194-2.044.581-2.944.4-.912.944-1.712 1.631-2.4a7.511 7.511 0 0 1 2.4-1.612 7.25 7.25 0 0 1 2.944-.6c.4 0 .787.025 1.162.075.375.05.75.137 1.125.262l-1.556 1.557-.375-.038A3.23 3.23 0 0 0 10 4.281c-1.6 0-2.956.557-4.069 1.669-1.1 1.1-1.65 2.45-1.65 4.05 0 1.6.55 2.956 1.65 4.069 1.113 1.1 2.469 1.65 4.069 1.65s2.95-.55 4.05-1.65c1.112-1.113 1.669-2.469 1.669-4.069 0-.125-.006-.244-.019-.356l-.037-.375Zm-1.612.918c0-1.175-.413-2.175-1.238-3-.824-.825-1.824-1.237-3-1.237 1.176 0 2.176-.413 3-1.237.825-.825 1.238-1.825 1.238-3 0 1.175.412 2.175 1.237 3 .825.824 1.825 1.237 3 1.237-1.174 0-2.174.412-3 1.237-.825.825-1.237 1.825-1.237 3Z"></path></g>
      <g id="help-me-write"><path fill-rule="evenodd" clip-rule="evenodd" d="M6.081 14.819h.956l6.3-6.3-.937-.957-6.319 6.32v.937Zm-1.837 1.837v-3.543l9.319-9.32a1.23 1.23 0 0 1 .487-.337c.188-.075.381-.112.581-.112.188 0 .369.037.544.112.188.063.369.169.544.319l1.406 1.387c.15.15.262.32.337.507a1.551 1.551 0 0 1 0 1.162 1.498 1.498 0 0 1-.337.506l-9.319 9.32H4.244ZM15.625 6.27l-.975-.994.975.994ZM12.869 8.03l-.469-.469.938.957-.47-.488ZM5.725 9.962c0-1.187-.412-2.187-1.237-3-.826-.824-1.832-1.237-3.02-1.237 1.188 0 2.195-.412 3.02-1.237.824-.826 1.237-1.832 1.237-3.02 0 1.188.406 2.195 1.219 3.02.825.824 1.831 1.237 3.019 1.237-1.188 0-2.194.413-3.02 1.238-.812.812-1.218 1.812-1.218 3Z"></path></g>
      <g id="hotspot"><path d="M2 10.5C2 5.84343 5.808 2 10.5 2C15.192 2 19 5.84343 19 10.5C19 13.7534 17.2915 16.5158 15 18L14 16.5C15.9315 15.3233 17.3 13.1185 17.5 10.5C17.3 6.78713 14.257 3.71582 10.5 3.5C6.743 3.71582 3.7 6.78713 3.5 10.5C3.7 13.1185 5.0685 15.3233 7 16.5L6 18C3.7085 16.5158 2 13.7534 2 10.5Z"></path><path d="M15.5 10.5C15.5 7.78374 13.2583 5.5 10.5 5.5C7.74167 5.5 5.5 7.78374 5.5 10.5C5.5 12.4786 6.50833 14.1171 8 15L9 13.5C7.84167 12.9285 7.16667 11.8503 7 10.5C7.16667 8.71761 8.65833 7.19794 10.5 7C12.3417 7.19794 13.8333 8.71761 14 10.5C13.8333 11.8503 13.1583 12.9285 12 13.5L13 15C14.4917 14.1171 15.5 12.4786 15.5 10.5Z"></path><path d="M10.5 12C11.3284 12 12 11.3284 12 10.5C12 9.67157 11.3284 9 10.5 9C9.67157 9 9 9.67157 9 10.5C9 11.3284 9.67157 12 10.5 12Z"></path></g>
      <g id="ic-checked-filled"><circle cx="10" cy="10" r="8" fill="#1967D2"></circle><path fill-rule="evenodd" clip-rule="evenodd" d="M8.33333 11.833L6.16667 9.66634L5 10.833L8.33333 14.1663L15 7.49967L13.8333 6.33301L8.33333 11.833Z" fill="white"></path></g>
      <g id="ic-checked-filled-dark"><circle cx="10" cy="10" r="8" fill="#AECBFA"></circle><path fill-rule="evenodd" clip-rule="evenodd" d="M8.33333 11.833L6.16667 9.66634L5 10.833L8.33333 14.1663L15 7.49967L13.8333 6.33301L8.33333 11.833Z" fill="#2A2A2D"></path></g>
      <g id="launcher" viewbox="0 0 20 20">
        <path d="M10 15C12.7614 15 15 12.7614 15 10C15 7.23858 12.7614 5 10 5C7.23858 5 5 7.23858 5 10C5 12.7614 7.23858 15 10 15Z"></path>
        <path fill-rule="evenodd" d="M10 18.5C14.6944 18.5 18.5 14.6944 18.5 10C18.5 5.30558 14.6944 1.5 10 1.5C5.30558 1.5 1.5 5.30558 1.5 10C1.5 14.6944 5.30558 18.5 10 18.5ZM17 10C17 13.866 13.866 17 10 17C6.13401 17 3 13.866 3 10C3 6.13401 6.13401 3 10 3C13.866 3 17 6.13401 17 10Z"></path>
      </g>
      <g id="lock"><path d="M11.75 12.5C11.75 13.4665 10.9665 14.25 10 14.25C9.0335 14.25 8.25 13.4665 8.25 12.5C8.25 11.5335 9.0335 10.75 10 10.75C10.9665 10.75 11.75 11.5335 11.75 12.5Z"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M14 7H13.5V5C13.5 3.34315 11.6569 2 10 2C8.34315 2 6.5 3.34315 6.5 5V7H6C4.89543 7 4 7.89543 4 9V16C4 17.1046 4.89543 18 6 18H14C15.1046 18 16 17.1046 16 16V9C16 7.89543 15.1046 7 14 7ZM12 5.5V7H8V5.5C8 5 8.5 3.5 10 3.5C11.5 3.5 12 5 12 5.5ZM6 9V16H14V9H6Z"></path></g>
      <g id="keyboard"><path fill-rule="evenodd" clip-rule="evenodd" d="M18 3H2C0.9 3 0.01 3.9 0.01 5L0 15C0 16.1 0.9 17 2 17H18C19.1 17 20 16.1 20 15V5C20 3.9 19.1 3 18 3ZM18 5V15H2V5H18ZM11 6H9V8H11V6ZM9 9H11V11H9V9ZM8 6H6V8H8V6ZM6 9H8V11H6V9ZM5 9H3V11H5V9ZM3 6H5V8H3V6ZM14 12H6V14H14V12ZM12 9H14V11H12V9ZM14 6H12V8H14V6ZM15 9H17V11H15V9ZM17 6H15V8H17V6Z"></path></g>
      <g id="magic-boost"><path fill-rule="evenodd" clip-rule="evenodd" d="M10 18.168c0-1.133-.21-2.191-.637-3.18a8.28 8.28 0 0 0-1.758-2.593 8.282 8.282 0 0 0-2.593-1.758A7.945 7.945 0 0 0 1.832 10c1.133 0 2.191-.21 3.18-.637A8.28 8.28 0 0 0 9.363 5C9.79 4.008 10 2.95 10 1.832c0 1.117.21 2.176.637 3.168A8.243 8.243 0 0 0 15 9.363c.992.426 2.05.637 3.168.637-1.117 0-2.176.21-3.168.637a8.28 8.28 0 0 0-4.363 4.352A7.95 7.95 0 0 0 10 18.168Z"></path></g>
      <g id="magic-tethering"><path d="M19 6.49212C14.5855 1.83596 6.42182 1.83596 2 6.49212L3.5 8C7.5 3.97898 13.5 3.97898 17.5 8L19 6.49212Z"></path><path d="M6.23521 11L4.5 9.33611C5.90378 7.99334 7.67283 7.21963 9.5 7L8.2038 9.73544C7.48803 10.0225 6.81737 10.4418 6.23521 11Z"></path><path d="M16.5 9.33645L14.7651 11C14.183 10.4419 13.5125 10.0227 12.7968 9.7357L11.5 7C13.3286 7.21876 15.0982 7.99231 16.5 9.33645Z"></path><path d="M6.5 12.9992L9.2496 11.7496L10.4992 9L11.7496 11.7496L14.5 12.9992L11.7496 14.2504L10.4992 17L9.2496 14.2504L6.5 12.9992Z"></path></g>
      <g id="mahi" viewbox="0 0 20 20"><g clip-path="url(#a)"><path fill-rule="evenodd" clip-rule="evenodd" d="M6.75 14c.208 0 .382-.07.52-.208a.74.74 0 0 0 .23-.542.675.675 0 0 0-.23-.52.675.675 0 0 0-.52-.23.74.74 0 0 0-.542.23.707.707 0 0 0-.208.52c0 .208.07.389.208.542A.779.779 0 0 0 6.75 14Zm0-3.25c.208 0 .382-.07.52-.208A.74.74 0 0 0 7.5 10a.675.675 0 0 0-.23-.52.675.675 0 0 0-.52-.23.74.74 0 0 0-.542.23A.707.707 0 0 0 6 10c0 .208.07.389.208.542a.779.779 0 0 0 .542.208Zm0-3.25c.208 0 .382-.07.52-.208a.74.74 0 0 0 .23-.542.675.675 0 0 0-.23-.52.675.675 0 0 0-.52-.23.74.74 0 0 0-.542.23.707.707 0 0 0-.208.52c0 .208.07.389.208.542a.779.779 0 0 0 .542.208ZM9 14h5v-1.5H9V14Zm0-3.25h4v-1.5H9v1.5ZM4.5 17c-.417 0-.77-.146-1.063-.438A1.492 1.492 0 0 1 3 15.5v-11c0-.403.146-.75.438-1.042A1.414 1.414 0 0 1 4.5 3H11v1.5H4.5v11h11V9H17v6.5c0 .403-.146.757-.438 1.063A1.446 1.446 0 0 1 15.5 17h-11Zm10-7c0-1.25-.438-2.313-1.313-3.188C12.313 5.938 11.25 5.5 10 5.5c1.25 0 2.313-.438 3.188-1.313C14.062 3.313 14.5 2.25 14.5 1c0 1.25.438 2.313 1.313 3.188C16.686 5.063 17.75 5.5 19 5.5c-1.25 0-2.313.438-3.188 1.313C14.938 7.688 14.5 8.75 14.5 10Z"></g><defs><clipPath id="a"><path fill-rule="evenodd" clip-rule="evenodd" d="M0 0h20v20H0z"></clipPath></defs></g>
      <g id="microphone"><path fill-rule="evenodd" clip-rule="evenodd" d="M10 12.1053C11.4229 12.1053 12.5629 10.9768 12.5629 9.57895L12.5714 4.52632C12.5714 3.12842 11.4229 2 10 2C8.57716 2 7.42859 3.12842 7.42859 4.52632V9.57895C7.42859 10.9768 8.57716 12.1053 10 12.1053ZM14.5429 9.57898C14.5429 12.1053 12.3657 13.8737 10 13.8737C7.63429 13.8737 5.45714 12.1053 5.45714 9.57898H4C4 12.459 6.33143 14.8253 9.14286 15.2379V18H10.8571V15.2379C13.6686 14.8337 16 12.459 16 9.57898H14.5429Z" fill="#1B1B1F"></path></g>
      <g id="move"><path d="M10.078 3.038a.1.1 0 0 0-.156 0L8.13 5.278a.1.1 0 0 0 .078.162h3.584a.1.1 0 0 0 .078-.163l-1.792-2.24ZM16 6.94H4v2h12v-2ZM16 10.5H4v2h12v-2ZM9.922 16.402a.1.1 0 0 0 .156 0l1.792-2.24a.1.1 0 0 0-.078-.162H8.208a.1.1 0 0 0-.078.162l1.792 2.24Z"></path></g>
      <g id="mouse"><path fill-rule="evenodd" clip-rule="evenodd" d="M10 2C6.68286 2 4 4.504 4 7.6V12.4C4 15.496 6.68286 18 10 18C13.3171 18 16 15.496 16 12.4V7.6C16 4.504 13.3171 2 10 2ZM14 7.5V8H11V4C13 4 14 6 14 7.5ZM9 4V8H6V7.6C6 6 7 4 9 4ZM10 16C7.63429 16 6 14.608 6 12.4V10H14V12.4C14 14.608 12.3657 16 10 16Z"></path></g>
      <g id="mouse-keys">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M15.1667 16.1042C14.5972 16.6736 13.9028 16.9583 13.0833 16.9583C12.2778 16.9583 11.5833 16.6736 11 16.1042C10.4306 15.5208 10.1458 14.8264 10.1458 14.0208V13.1875H16.0208V14.0208C16.0208 14.8264 15.7361 15.5208 15.1667 16.1042ZM12.2708 11.5625H10.1875C10.2708 10.9792 10.5 10.4792 10.875 10.0625C11.25 9.64583 11.7153 9.35417 12.2708 9.1875V11.5625ZM15.9792 11.5625H13.8958V9.1875C14.4514 9.35417 14.9097 9.64583 15.2708 10.0625C15.6458 10.4792 15.8819 10.9792 15.9792 11.5625ZM9.8125 17.2917C10.7014 18.1667 11.7917 18.6042 13.0833 18.6042C14.375 18.6042 15.4583 18.1667 16.3333 17.2917C17.2222 16.4028 17.6667 15.3125 17.6667 14.0208V12.0833C17.6667 10.7917 17.2222 9.70833 16.3333 8.83333C15.4583 7.94444 14.375 7.5 13.0833 7.5C11.7917 7.5 10.7014 7.94444 9.8125 8.83333C8.9375 9.70833 8.5 10.7917 8.5 12.0833V14.0208C8.5 15.3125 8.9375 16.4028 9.8125 17.2917Z"></path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M4 3C3.44772 3 3 3.44772 3 4V6C3 6.55228 3.44772 7 4 7H6C6.55228 7 7 6.55228 7 6V4C7 3.44772 6.55228 3 6 3H4ZM4 8C3.44772 8 3 8.44772 3 9V11C3 11.5523 3.44772 12 4 12H6C6.55228 12 7 11.5523 7 11V9C7 8.44772 6.55228 8 6 8H4ZM4 13C3.44772 13 3 13.4477 3 14V16C3 16.5523 3.44772 17 4 17H6C6.55228 17 7 16.5523 7 16V14C7 13.4477 6.55228 13 6 13H4ZM11.9966 6.08354C11.1522 6.22571 10.3676 6.54426 9.6822 7H9C8.44772 7 8 6.55228 8 6V4C8 3.44772 8.44772 3 9 3H11C11.5523 3 12 3.44772 12 4V6C12 6.02813 11.9988 6.05599 11.9966 6.08354ZM16.2641 6.96474C15.3247 6.35448 14.2037 6 13 6V4C13 3.44772 13.4477 3 14 3H16C16.5523 3 17 3.44772 17 4V6C17 6.46085 16.6883 6.84889 16.2641 6.96474Z"></path>
      </g>
      <g id="ms365" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M8.15 4.5v2.47a4.17 4.17 0 0 1 3.74 0l4.53 2.33c.61.342 1.148.8 1.58 1.35V7.31a3.37 3.37 0 0 0-1.76-3l-4.56-2.5a3.32 3.32 0 0 0-2.2-.36l-.14.06C8.61 1.91 8.15 3 8.15 4.5Zm9.42 8.24a4.63 4.63 0 0 0-1.83-2.1l-2.26-1.16v.25a4.19 4.19 0 0 1-2.2 3.68l-4.57 2.48a6.14 6.14 0 0 1-1.6.53l3.27 1.78a3.5 3.5 0 0 0 3.27 0l4.56-2.48a3.38 3.38 0 0 0 1.6-1.91 1.81 1.81 0 0 0-.24-1.07Zm-9.17.52L6 14.56a4.39 4.39 0 0 1-3.15.35A3.4 3.4 0 0 1 2 12.66V7.31a3.43 3.43 0 0 1 1.81-3.02l3.03-1.67a7.16 7.16 0 0 0-.24 1.86l-.003.255c-.011.89-.049 3.823.003 5.115a4.57 4.57 0 0 0 1.8 3.41Z" clip-rule="evenodd"></path></g>
      <g id="network-wifi"><path fill-rule="evenodd" clip-rule="evenodd" d="M10.5554 16.7289C10.2698 17.0905 9.72802 17.0905 9.44247 16.7281L2.15749 7.49646C1.89621 7.16533 1.96831 6.68099 2.31239 6.44135C3.50455 5.61135 6.26792 4 10 4C13.7328 4 16.4955 5.61135 17.6876 6.44135C18.0317 6.68099 18.1038 7.16533 17.8425 7.49646L10.5554 16.7289ZM5.46762 8.4626L4.61134 7.37751C5.85753 6.71277 7.72159 6 10 6C12.2788 6 14.1425 6.71268 15.3886 7.37739L14.5315 8.46329C13.348 7.94707 11.8035 7.5 9.99865 7.5C8.19498 7.5 6.65099 7.94668 5.46762 8.4626Z"></path></g>
      <g id="on-screen-keyboard" viewBox="0 0 20 20"><path fill-rule="evenodd" clip-rule="evenodd" d="M5 14V9h11v5H5Zm8-2H8v1h5v-1Zm-6-2h1v1H7v-1Zm3 0H9v1h1v-1Zm1 0h1v1h-1v-1Zm3 0h-1v1h1v-1Z"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M2 4.669C2 3.75 2.736 3 3.636 3h13.728c.9 0 1.636.75 1.636 1.669v10.68c0 .917-.736 1.651-1.636 1.651H3.636C2.736 17 2 16.266 2 15.348V4.668ZM4 5v10h13V5H4Z"></path></g>
      <g id="onedrive"><path d="m11.94 8.81 2.23-.94a7.4 7.4 0 0 1 1.18-.31 5.8 5.8 0 0 0-5.21-3.44 5.68 5.68 0 0 0-3.93 1.61 7.38 7.38 0 0 1 1.72.68l4.01 2.4Zm2.82.44-1.22.52 1.19.71 4.72 2.83a3.43 3.43 0 0 0 0-1.88 4.07 4.07 0 0 0-.22-.52l-.09-.19-.14-.24a4.68 4.68 0 0 0-.29-.37 3.88 3.88 0 0 0-1-.76l-.18-.07-.4-.16a3.82 3.82 0 0 0-.77-.12 4.39 4.39 0 0 0-1.6.25Zm-5.07.51.54-.23L7.16 7.7A5.21 5.21 0 0 0 4.84 7a4.44 4.44 0 0 0-4.41 4.5v.08a4.54 4.54 0 0 0 .48 1.88l8.78-3.7Zm2.13.73-10 4.2a4.41 4.41 0 0 0 3 1.17h11.3a3.4 3.4 0 0 0 2.62-1.22L15.93 13l-4.11-2.51Z"></path></g>
      <g id="print"><path fill-rule="evenodd" clip-rule="evenodd" d="M5 3H15V7H16C17.1046 7 18 7.89543 18 9V14H15V17H5V14H2V9C2 7.89543 2.89543 7 4 7H5V3ZM13 5H7V7H13V5ZM16 10C16 10.5523 15.5523 11 15 11C14.4477 11 14 10.5523 14 10C14 9.44772 14.4477 9 15 9C15.5523 9 16 9.44772 16 10ZM7 12H13V15H7V12Z"></path></g>
      <g id="printer-add"><path fill-opacity=".3" d="M17.8734304,8.29826826 C17.2839707,8.10470383 16.6542128,8 16,8 C13.3875623,8 11.1650842,9.66961525 10.3414114,12 L7,12 L7,15 L10.0829584,15 C10.2034032,15.7179235 10.4513404,16.3926158 10.8026932,17 L5,17 L5,14 L2,14 L2,9 C2,7.8954305 2.8954305,7 4,7 L5,7 L5,3 L15,3 L15,7 L16,7 C16.8576527,7 17.5892179,7.53984453 17.8734304,8.29826826 Z M7,5 L7,7 L13,7 L13,5 L7,5 Z"></path><polygon points="17 13 19 13 19 15 17 15 17 17 15 17 15 15 13 15 13 13 15 13 15 11 17 11"></polygon></g>
      <g id="refresh"><path fill-rule="evenodd" clip-rule="evenodd" d="M10 3C6.136 3 3 6.136 3 10C3 13.864 6.136 17 10 17C12.1865 17 14.1399 15.9959 15.4239 14.4239L13.9984 12.9984C13.0852 14.2129 11.6325 15 10 15C7.24375 15 5 12.7563 5 10C5 7.24375 7.24375 5 10 5C11.6318 5 13.0839 5.78641 13.9972 7H11V9H17V3H15V5.10253C13.7292 3.80529 11.9581 3 10 3Z"></path></g>
      <g id="scanner" viewBox="2 2 20 20"><path d="M11.0625 8.03125c-1.125 0-2.075.39375-2.85 1.18125-.7875.775-1.18125 1.725-1.18125 2.85 0-1.125-.3875-2.075-1.1625-2.85C5.08125 8.425 4.125 8.03125 3 8.03125c1.125 0 2.08125-.3875 2.86875-1.1625.775-.7875 1.1625-1.74375 1.1625-2.86875 0 1.125.39375 2.08125 1.18125 2.86875.775.775 1.725 1.1625 2.85 1.1625Zm8.675 3.25005H17.9V7.2625h-5.0187V5.425H17.9c.5125 0 .95.18125 1.3125.54375.35.35.525.78125.525 1.29375v4.0188Zm-8.4562 7.4562H6.2625c-.5125 0-.94375-.175-1.29375-.525-.3625-.3625-.54375-.8-.54375-1.3125v-3.0187h1.8375V16.9h5.0188v1.8375Z"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M13.6357 17.2985c1.018.9889 2.5432 1.1346 3.7105.4495l1.9844 1.9279 1.29-1.3279-2.031-1.9731c.5309-1.1546.3094-2.5665-.6541-3.5026-1.2222-1.1873-3.1756-1.159-4.363.0632-1.1873 1.2223-1.159 3.1756.0632 4.363Zm1.2898-1.328c.4888.4748 1.2701.4635 1.7451-.0253.4749-.489.4636-1.2703-.0252-1.7452-.489-.475-1.2703-.4637-1.7452.0253-.475.4888-.4637 1.2702.0253 1.7452Z"></path></g>
      <g id="select-to-speak" viewBox="0 0 20 20"><path fill-rule="evenodd" clip-rule="evenodd" d="M18 10a8 8 0 1 1-16 0 8 8 0 0 1 16 0ZM7.778 11.368H6V8.632h1.778L10 6.352v7.297l-2.222-2.28ZM12 10c0-.807-.453-1.5-1.111-1.838v3.671A2.046 2.046 0 0 0 12 10Zm-1.111-3.06V6C12.67 6.415 14 8.048 14 10s-1.329 3.585-3.111 4v-.94c1.284-.392 2.222-1.614 2.222-3.06s-.938-2.668-2.222-3.06ZM5 7V5h2v1H6v1H5Zm10 6v2h-2v-1h1v-1h1Z"></path></g>
      <g id="social-group"><path fill-rule="evenodd" clip-rule="evenodd" d="M7.5 3C9.425 3 11 4.575 11 6.5C11 8.425 9.425 10 7.5 10C5.575 10 4 8.425 4 6.5C4 4.575 5.575 3 7.5 3ZM7.5 5C6.67957 5 6 5.67957 6 6.5C6 7.32043 6.67957 8 7.5 8C8.32043 8 9 7.32043 9 6.5C9 5.67957 8.32043 5 7.5 5ZM13.9916 14.0859C13.7789 12.0336 9.60583 11 7.5 11C5.33875 11 1 12.0887 1 14.25V17H14V14.25L13.9916 14.0859ZM11.9947 14.3433C11.9867 14.3476 11.9693 14.3346 11.9329 14.3011L11.8432 14.2246C11.6159 14.0441 11.2636 13.85 10.8172 13.6713C9.79154 13.2607 8.42752 13 7.5 13C6.57248 13 5.20846 13.2607 4.18279 13.6713C3.73641 13.85 3.38414 14.0441 3.15679 14.2246L3.0671 14.3011C3.01855 14.3458 3.00384 14.3539 3 14.3335V15H12V14.3335L11.9947 14.3433ZM11.2717 9.77623C11.6543 9.92081 12.0683 10 12.5 10C14.425 10 16 8.425 16 6.5C16 4.575 14.425 3 12.5 3C12.0683 3 11.6543 3.07919 11.2717 3.22377C12.0361 4.10238 12.5 5.24886 12.5 6.5C12.5 7.75114 12.0361 8.89762 11.2717 9.77623ZM15.5 17H19V14.25L18.9916 14.0859C18.8063 12.2977 15.6141 11.2828 13.4026 11.0513C14.5583 11.7896 15.3634 12.7824 15.4896 14.0088L15.5 14.25V17Z"></path></g>
      <g id="stylus"><path fill-rule="evenodd" clip-rule="evenodd" d="M2 14.6662V18H5.32305L12.0225 11.3057L8.69053 7.97192L2 14.6662ZM15.6565 2.26452L17.7356 4.33592C18.0821 4.68263 18.091 5.2516 17.7445 5.59831L12.9732 10.3634L9.63234 7.02073L11.8803 4.77153L11.2317 4.12255L6.20266 9.15435L4.95874 7.90974L10.6186 2.25563C10.9651 1.90892 11.5426 1.91781 11.8803 2.26452L13.142 3.51803L14.4037 2.26452C14.7413 1.91781 15.31 1.91781 15.6565 2.26452Z"></path></g>
      <g id="switch-access" viewBox="0 0 20 20"><path fill-rule="evenodd" clip-rule="evenodd" d="M18 9v2h-1.17a3.001 3.001 0 1 1 0-2H18ZM6 7c.463 0 .902.105 1.293.292L10 4.586 11.414 6 8.708 8.707A3 3 0 1 1 3.17 11H2V9h1.17A3.001 3.001 0 0 1 6 7Zm0 4a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm8 0a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"></path></g>
      <g id="sync"><path fill-rule="evenodd" clip-rule="evenodd" d="M8.99977 3.07092L8.9991 5.1002C6.71731 5.56382 5 7.58136 5 10C5 11.8507 6.00553 13.4666 7.50008 14.3311L7.5 12H9V17H4V15.5L5.6705 15.5009C4.04414 14.2191 3 12.2315 3 10C3 6.55562 5.48772 3.69227 8.76441 3.1087L8.99977 3.07092ZM16 3V4.5L14.3315 4.5007C15.9567 5.78256 17 7.76944 17 10C17 13.5264 14.3924 16.4438 11.0002 16.9291L11.0009 14.8998C13.2827 14.4362 15 12.4186 15 10C15 8.14968 13.9949 6.5341 12.5009 5.66945L12.5 8H11V3H16Z"></path></g>
      <g id="wallpaper"><path fill-rule="evenodd" clip-rule="evenodd" d="M4 3H16C17.1046 3 18 3.89543 18 5V15C18 16.1046 17.1046 17 16 17H4C2.89543 17 2 16.1046 2 15V5C2 3.89543 2.89543 3 4 3ZM4 5V15H16V5H4ZM6 13L9 7L11 11L12 9.5L14 13H6Z"></path></g>
      <g id="zoom-in" viewBox="0 0 16 16"><path fill-rule="evenodd" d="m13.938 15.188-5.021-5.042a5.43 5.43 0 0 1-1.375.729 4.851 4.851 0 0 1-1.584.25c-1.416 0-2.625-.5-3.625-1.5C1.347 8.625.854 7.417.854 6c0-1.417.493-2.625 1.48-3.625 1-1 2.208-1.5 3.624-1.5 1.417 0 2.625.5 3.625 1.5s1.5 2.208 1.5 3.625a5.04 5.04 0 0 1-.25 1.604 5.05 5.05 0 0 1-.687 1.334l5 5.02-1.209 1.23Zm-7.98-5.813c.945 0 1.743-.326 2.396-.98.667-.652 1-1.45 1-2.395 0-.944-.333-1.743-1-2.396-.653-.653-1.451-.979-2.396-.979-.944 0-1.743.326-2.395.98-.653.652-.98 1.45-.98 2.395 0 .944.327 1.743.98 2.396.652.653 1.45.979 2.395.979Zm-.75-1.146V6.75H3.75v-1.5h1.458V3.77h1.5v1.48h1.48v1.5h-1.48v1.48h-1.5Z"></path></g>

      <!-- Switch Access Action Assignment Dialog icons -->
      <g id="add-assignment" fill-rule="evenodd"><path fill-rule="evenodd" clip-rule="evenodd" d="M14 9V11H11V14H9V11H6V9H9V6H11V9H14ZM10 2C5.576 2 2 5.576 2 10C2 14.424 5.576 18 10 18C14.424 18 18 14.424 18 10C18 5.576 14.424 2 10 2ZM10 16C6.6925 16 4 13.3075 4 10C4 6.6925 6.6925 4 10 4C13.3075 4 16 6.6925 16 10C16 13.3075 13.3075 16 10 16Z"></path></g>
      <g id="assigned"><path d="M13.7071 7.29289C13.3166 6.90237 12.6834 6.90237 12.2929 7.29289L9 10.5858L7.70711 9.29289C7.31658 8.90237 6.68342 8.90237 6.29289 9.29289C5.90237 9.68342 5.90237 10.3166 6.29289 10.7071L8.29289 12.7071C8.68342 13.0976 9.31658 13.0976 9.70711 12.7071L13.7071 8.70711C14.0976 8.31658 14.0976 7.68342 13.7071 7.29289Z"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M10 18C14.4183 18 18 14.4183 18 10C18 5.58172 14.4183 2 10 2C5.58172 2 2 5.58172 2 10C2 14.4183 5.58172 18 10 18ZM10 16C13.3137 16 16 13.3137 16 10C16 6.68629 13.3137 4 10 4C6.68629 4 4 6.68629 4 10C4 13.3137 6.68629 16 10 16Z"></path></g>
      <g id="error"><path fill-rule="evenodd" clip-rule="evenodd" d="M9 10H11V6H9V10ZM10 2C5.584 2 2 5.584 2 10C2 14.416 5.584 18 10 18C14.416 18 18 14.416 18 10C18 5.584 14.416 2 10 2ZM10 16C6.6925 16 4 13.3075 4 10C4 6.6925 6.6925 4 10 4C13.3075 4 16 6.6925 16 10C16 13.3075 13.3075 16 10 16ZM9 14H11V12H9V14Z"></path></g>
      <g id="remove-assignment" fill-rule="evenodd"><path fill-rule="evenodd" clip-rule="evenodd" d="M12.072 6.79999L9.99999 8.87199L7.92799 6.79999L6.79999 7.92799L8.87199 9.99999L6.79999 12.072L7.92799 13.2L9.99999 11.128L12.072 13.2L13.2 12.072L11.128 9.99999L13.2 7.92799L12.072 6.79999ZM10 2C5.576 2 2 5.576 2 10C2 14.424 5.576 18 10 18C14.424 18 18 14.424 18 10C18 5.576 14.424 2 10 2ZM10 16C6.6925 16 4 13.3075 4 10C4 6.6925 6.6925 4 10 4C13.3075 4 16 6.6925 16 10C16 13.3075 13.3075 16 10 16Z"></path></g>

      <!-- Keep alphabetized. -->

      <!--
      These icons are copied from Polymer's iron-icons and kept in sorted order.
      See http://goo.gl/Y1OdAq for instructions on adding additional icons.
      -->
      <g id="alert-device-out-of-range" viewBox="0 0 24 24"><path d="M8.167 11.5h1.666v1.667H8.167V11.5zm0-6.667h1.666v5H8.167v-5zM8.992.667C4.392.667.667 4.4.667 9s3.725 8.333 8.325 8.333c4.608 0 8.341-3.733 8.341-8.333S13.6.667 8.992.667zm.008 15A6.665 6.665 0 0 1 2.333 9 6.665 6.665 0 0 1 9 2.333 6.665 6.665 0 0 1 15.667 9 6.665 6.665 0 0 1 9 15.667z"></path></g>
      <g id="bluetooth" viewBox="0 0 24 24"><path d="M17.71 7.71L12 2h-1v7.59L6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 11 14.41V22h1l5.71-5.71-4.3-4.29 4.3-4.29zM13 5.83l1.88 1.88L13 9.59V5.83zm1.88 10.46L13 18.17v-3.76l1.88 1.88z"></path></g>
      <g id="bluetooth-connected" viewBox="0 0 24 24"><path d="M7 12l-2-2-2 2 2 2 2-2zm10.71-4.29L12 2h-1v7.59L6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 11 14.41V22h1l5.71-5.71-4.3-4.29 4.3-4.29zM13 5.83l1.88 1.88L13 9.59V5.83zm1.88 10.46L13 18.17v-3.76l1.88 1.88zM19 10l-2 2 2 2 2-2-2-2z"></path></g>
      <g id="bluetooth-disabled" viewBox="0 0 24 24"><path d="M13 5.83l1.88 1.88-1.6 1.6 1.41 1.41 3.02-3.02L12 2h-1v5.03l2 2v-3.2zM5.41 4L4 5.41 10.59 12 5 17.59 6.41 19 11 14.41V22h1l4.29-4.29 2.3 2.29L20 18.59 5.41 4zM13 18.17v-3.76l1.88 1.88L13 18.17z"></path></g>
      <g id="chevron-left" viewBox="0 0 24 24"><path d="M15.41 7.41L14 6l-6 6 6 6 1.41-1.41L10.83 12z"></path></g>
      <g id="edit" width="20" height="20" viewBox="0 0 20 20"><path fill-rule="evenodd" clip-rule="evenodd" d="M15.41 1.935L14.06 0.585C13.28 -0.195 12.01 -0.195 11.23 0.585L8.4 3.405L0 11.815V15.995H4.18L15.41 4.765C16.2 3.985 16.2 2.715 15.41 1.935ZM2 13.995V12.635L9.82 4.815L11.23 6.225L3.41 14.055L2 13.995Z"></path></g>
      <g id="end-of-life" viewBox="0 0 24 24"><path d="M4.574 2.916H4.55l.01.01.014-.01zM2.5 4.968v.023a.18.18 0 0 1 .01-.013l-.01-.01zm14.585 10.49v-.024l-.01.013.01.01zm.223 1.817l-.933-.95-4.106-4.11L8.026 7.99 3.675 3.635l-.942-.941-.712-.713L1 3.002l1.733 1.733A9.056 9.056 0 0 0 1.05 9.98c0 1.95.628 3.748 1.683 5.22.574.8 1.274 1.501 2.074 2.075a8.918 8.918 0 0 0 5.218 1.684 8.918 8.918 0 0 0 5.218-1.684L16.991 19l1.02-1.021-.703-.704zM15.243 2.684A8.922 8.922 0 0 0 10.025 1a8.922 8.922 0 0 0-5.218 1.684c-.005.003 4.135 4.16 4.135 4.16l1.083-1.814L15.042 11h-1.846l4.11 4.214a8.939 8.939 0 0 0 .011-10.456 9.021 9.021 0 0 0-2.074-2.074zM12 15H7.012v-3.989L4.5 11l2.227-1.876L12 14.6v.4z" fill-rule="evenodd"></path></g>
      <g id="feedback" viewBox="0 0 24 24"><path d="M20 2H4c-1.1 0-1.99.9-1.99 2L2 22l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 14H5.17l-.59.59-.58.58V4h16v12zm-9-4h2v2h-2zm0-6h2v4h-2z"></path></g>
      <g id="fingerprint" viewBox="0 0 24 24"><path d="M17.81 4.47c-.08 0-.16-.02-.23-.06C15.66 3.42 14 3 12.01 3c-1.98 0-3.86.47-5.57 1.41-.24.13-.54.04-.68-.2-.13-.24-.04-.55.2-.68C7.82 2.52 9.86 2 12.01 2c2.13 0 3.99.47 6.03 1.52.25.13.34.43.21.67-.09.18-.26.28-.44.28zM3.5 9.72c-.1 0-.2-.03-.29-.09-.23-.16-.28-.47-.12-.7.99-1.4 2.25-2.5 3.75-3.27C9.98 4.04 14 4.03 17.15 5.65c1.5.77 2.76 1.86 3.75 3.25.16.22.11.54-.12.7-.23.16-.54.11-.7-.12-.9-1.26-2.04-2.25-3.39-2.94-2.87-1.47-6.54-1.47-9.4.01-1.36.7-2.5 1.7-3.4 2.96-.08.14-.23.21-.39.21zm6.25 12.07c-.13 0-.26-.05-.35-.15-.87-.87-1.34-1.43-2.01-2.64-.69-1.23-1.05-2.73-1.05-4.34 0-2.97 2.54-5.39 5.66-5.39s5.66 2.42 5.66 5.39c0 .28-.22.5-.5.5s-.5-.22-.5-.5c0-2.42-2.09-4.39-4.66-4.39-2.57 0-4.66 1.97-4.66 4.39 0 1.44.32 2.77.93 3.85.64 1.15 1.08 1.64 1.85 2.42.19.2.19.51 0 .71-.11.1-.24.15-.37.15zm7.17-1.85c-1.19 0-2.24-.3-3.1-.89-1.49-1.01-2.38-2.65-2.38-4.39 0-.28.22-.5.5-.5s.5.22.5.5c0 1.41.72 2.74 1.94 3.56.71.48 1.54.71 2.54.71.24 0 .64-.03 1.04-.1.27-.05.53.13.58.41.05.27-.13.53-.41.58-.57.11-1.07.12-1.21.12zM14.91 22c-.04 0-.09-.01-.13-.02-1.59-.44-2.63-1.03-3.72-2.1-1.4-1.39-2.17-3.24-2.17-5.22 0-1.62 1.38-2.94 3.08-2.94 1.7 0 3.08 1.32 3.08 2.94 0 1.07.93 1.94 2.08 1.94s2.08-.87 2.08-1.94c0-3.77-3.25-6.83-7.25-6.83-2.84 0-5.44 1.58-6.61 4.03-.39.81-.59 1.76-.59 2.8 0 .78.07 2.01.67 3.61.1.26-.03.55-.29.64-.26.1-.55-.04-.64-.29-.49-1.31-.73-2.61-.73-3.96 0-1.2.23-2.29.68-3.24 1.33-2.79 4.28-4.6 7.51-4.6 4.55 0 8.25 3.51 8.25 7.83 0 1.62-1.38 2.94-3.08 2.94s-3.08-1.32-3.08-2.94c0-1.07-.93-1.94-2.08-1.94s-2.08.87-2.08 1.94c0 1.71.66 3.31 1.87 4.51.95.94 1.86 1.46 3.27 1.85.27.07.42.35.35.61-.05.23-.26.38-.47.38z"></path></g>
      <g id="gamepad" viewBox="0 0 24 24"><path d="M15 7.5V2H9v5.5l3 3 3-3zM7.5 9H2v6h5.5l3-3-3-3zM9 16.5V22h6v-5.5l-3-3-3 3zM16.5 9l-3 3 3 3H22V9h-5.5z"></path></g>
      <g id="headset" viewBox="0 0 24 24"><path d="M12 1c-4.97 0-9 4.03-9 9v7c0 1.66 1.34 3 3 3h3v-8H5v-2c0-3.87 3.13-7 7-7s7 3.13 7 7v2h-4v8h3c1.66 0 3-1.34 3-3v-7c0-4.97-4.03-9-9-9z"></path></g>
      <g id="hotspot-disabled"><path fill-rule="evenodd" clip-rule="evenodd" d="M3.18333 2L2 3.175L4.24167 5.41667C3.15833 6.825 2.50833 8.58333 2.50833 10.4917C2.50833 12.7917 3.44167 14.875 4.95 16.3833L6.13333 15.2C4.925 14 4.175 12.3333 4.175 10.4917C4.175 9.03333 4.65 7.7 5.43333 6.60833L6.625 7.8C6.13333 8.575 5.84167 9.5 5.84167 10.4917C5.84167 11.875 6.40833 13.1167 7.30833 14.025L8.49167 12.8417C7.88333 12.2417 7.50833 11.4167 7.50833 10.4917C7.50833 9.96666 7.63333 9.46667 7.85 9.025L9.19167 10.3667C9.19167 10.3875 9.1875 10.4083 9.18333 10.4292C9.17917 10.45 9.175 10.4708 9.175 10.4917C9.175 10.95 9.36667 11.3667 9.66667 11.6667C9.96667 11.9667 10.3833 12.1583 10.8417 12.1583C10.8773 12.1583 10.9128 12.1523 10.9536 12.1453L10.975 12.1417L17.325 18.4917L18.5 17.3167L3.18333 2ZM15.5917 12.05C15.75 11.5583 15.8417 11.0333 15.8417 10.4917C15.8417 7.73333 13.6 5.49167 10.8417 5.49167C10.3 5.49167 9.775 5.575 9.28333 5.74167L10.7083 7.16667C10.75 7.15833 10.8 7.15833 10.8417 7.15833C12.6833 7.15833 14.175 8.65 14.175 10.4917C14.175 10.5333 14.175 10.5833 14.1667 10.625L15.5917 12.05ZM17.5083 10.4917C17.5083 6.80833 14.525 3.825 10.8417 3.825C9.825 3.825 8.86667 4.05 8 4.45833L6.76667 3.225C7.975 2.54167 9.35833 2.15833 10.8417 2.15833C15.4417 2.15833 19.175 5.89167 19.175 10.4917C19.175 11.975 18.7833 13.3667 18.1083 14.5667L16.8667 13.325C17.2833 12.4667 17.5083 11.5083 17.5083 10.4917Z"></path></g>
      <g id="hotspot-enabled"><path d="M2 10.5C2 5.84343 5.808 2 10.5 2C15.192 2 19 5.84343 19 10.5C19 13.7534 17.2915 16.5158 15 18L14 16.5C15.9315 15.3233 17.3 13.1185 17.5 10.5C17.3 6.78713 14.257 3.71582 10.5 3.5C6.743 3.71582 3.7 6.78713 3.5 10.5C3.7 13.1185 5.0685 15.3233 7 16.5L6 18C3.7085 16.5158 2 13.7534 2 10.5Z"></path><path d="M15.5 10.5C15.5 7.78374 13.2583 5.5 10.5 5.5C7.74167 5.5 5.5 7.78374 5.5 10.5C5.5 12.4786 6.50833 14.1171 8 15L9 13.5C7.84167 12.9285 7.16667 11.8503 7 10.5C7.16667 8.71761 8.65833 7.19794 10.5 7C12.3417 7.19794 13.8333 8.71761 14 10.5C13.8333 11.8503 13.1583 12.9285 12 13.5L13 15C14.4917 14.1171 15.5 12.4786 15.5 10.5Z"></path><path d="M10.5 12C11.3284 12 12 11.3284 12 10.5C12 9.67157 11.3284 9 10.5 9C9.67157 9 9 9.67157 9 10.5C9 11.3284 9.67157 12 10.5 12Z"></path></g>
      <g id="info-outline" viewBox="0 0 24 24"><path d="M11 17h2v-6h-2v6zm1-15C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zM11 9h2V7h-2v2z"></path></g>
      <g id="laptop-chromebook" viewBox="0 0 24 24"><path d="M22 18V3H2v15H0v2h24v-2h-2zm-8 0h-4v-1h4v1zm6-3H4V5h16v10z"></path></g>
      <g id="mic-off" viewBox="0 0 24 24"><path d="M19,11h-2c0,0.91-0.25,1.76-0.68,2.49l1.45,1.45C18.54,13.82,19,12.47,19,11z M2.81,2.81L1.39,4.22l11.66,11.66 C12.71,15.96,12.36,16,12,16c-2.76,0-5-2.24-5-5H5c0,3.53,2.61,6.43,6,6.92V21h2v-3.08c0.57-0.08,1.12-0.24,1.64-0.45l5.14,5.14 l1.41-1.41L2.81,2.81z M15,11V5c0-1.66-1.34-3-3-3S9,3.34,9,5v1.17l5.81,5.81C14.92,11.67,15,11.35,15,11z"></path></g>
      <g id="power" viewBox="0 0 24 24"><path d="M16.01 7L16 3h-2v4h-4V3H8v4h-.01C7 6.99 6 7.99 6 8.99v5.49L9.5 18v3h5v-3l3.5-3.51v-5.5c0-1-1-2-1.99-1.99z"></path></g>
      <g id="settings-ethernet" viewBox="0 0 24 24"><path d="M7.77 6.76L6.23 5.48.82 12l5.41 6.52 1.54-1.28L3.42 12l4.35-5.24zM7 13h2v-2H7v2zm10-2h-2v2h2v-2zm-6 2h2v-2h-2v2zm6.77-7.52l-1.54 1.28L20.58 12l-4.35 5.24 1.54 1.28L23.18 12l-5.41-6.52z"></path></g>
      <g id="settings-general" viewBox="0 0 24 24"><path d="M19.43 12.98c.04-.32.07-.64.07-.98s-.03-.66-.07-.98l2.11-1.65c.19-.15.24-.42.12-.64l-2-3.46c-.12-.22-.39-.3-.61-.22l-2.49 1c-.52-.4-1.08-.73-1.69-.98l-.38-2.65C14.46 2.18 14.25 2 14 2h-4c-.25 0-.46.18-.49.42l-.38 2.65c-.61.25-1.17.59-1.69.98l-2.49-1c-.23-.09-.49 0-.61.22l-2 3.46c-.13.22-.07.49.12.64l2.11 1.65c-.04.32-.07.65-.07.98s.03.66.07.98l-2.11 1.65c-.19.15-.24.42-.12.64l2 3.46c.12.22.39.3.61.22l2.49-1c.52.4 1.08.73 1.69.98l.38 2.65c.03.24.24.42.49.42h4c.25 0 .46-.18.49-.42l.38-2.65c.61-.25 1.17-.59 1.69-.98l2.49 1c.23.09.49 0 .61-.22l2-3.46c.12-.22.07-.49-.12-.64l-2.11-1.65zM12 15.5c-1.93 0-3.5-1.57-3.5-3.5s1.57-3.5 3.5-3.5 3.5 1.57 3.5 3.5-1.57 3.5-3.5 3.5z"></path></g>
      <g id="signal-cellular-0-bar" viewBox="0 0 24 24"><path fill-opacity=".3" d="M2 22h20V2z"></path></g>
      <g id="signal-cellular-1-bar" viewBox="0 0 24 24"><path fill-opacity=".3" d="M2 22h20V2z"></path><path d="M12 12L2 22h10z"></path></g>
      <g id="signal-cellular-2-bar" viewBox="0 0 24 24"><path fill-opacity=".3" d="M2 22h20V2z"></path><path d="M14 10L2 22h12z"></path></g>
      <g id="signal-cellular-3-bar" viewBox="0 0 24 24"><path fill-opacity=".3" d="M2 22h20V2z"></path><path d="M17 7L2 22h15z"></path></g>
      <g id="signal-cellular-4-bar" viewBox="0 0 24 24"><path d="M2 22h20V2z"></path></g>
      <g id="smartphone" viewBox="0 0 24 24"><path d="M17 1.01L7 1c-1.1 0-2 .9-2 2v18c0 1.1.9 2 2 2h10c1.1 0 2-.9 2-2V3c0-1.1-.9-1.99-2-1.99zM17 19H7V5h10v14z"></path></g>
      <g id="startup" viewBox="0 0 24 24"><path d="M13 3h-2v10h2V3zm4.83 2.17l-1.42 1.42C17.99 7.86 19 9.81 19 12c0 3.87-3.13 7-7 7s-7-3.13-7-7c0-2.19 1.01-4.14 2.58-5.42L6.17 5.17C4.23 6.82 3 9.26 3 12c0 4.97 4.03 9 9 9s9-4.03 9-9c0-2.74-1.23-5.18-3.17-6.83z"></path></g>
      <g id="tablet" viewBox="0 0 24 24"><path d="M21 4H3c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h18c1.1 0 1.99-.9 1.99-2L23 6c0-1.1-.9-2-2-2zm-2 14H5V6h14v12z"></path></g>
      <!-- Keep alphabetized. -->
    </defs>
  </svg>
</iron-iconset-svg>

<!-- Include illustrations below -->
<iron-iconset-svg name="os-settings-illo" size="200">
  <svg>
    <defs>
      <!-- A11y section -->
      <!-- Switch access-->
      <g id="switch-access-setup-guide-assign-next" viewBox="0 0 216 216" fill="none">
        <path d="M137.85 46.05a6.1 6.1 0 0 1 1 8.4l-8.6 11a5.796 5.796 0 0 1-3.937 2.266 5.802 5.802 0 0 1-4.363-1.266 5.893 5.893 0 0 1-2.126-6.228 5.904 5.904 0 0 1 1.026-2.072l8.6-11a6 6 0 0 1 8.4-1.1Z" fill="var(--cros-sys-illo-color3)"/><path d="M60.85 67.95c4.5 2.5 9.3 6.3 10.6 11.8 1.9 8-4.8 13.5-2.8 21.2.9 3.5 3.6 7.7 11.3 11.6" stroke="var(--cros-sys-illo-color1-2)" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"/><path d="m93.072 73.505-5.764 10.979a2.8 2.8 0 0 0 1.178 3.78L99.58 94.09a2.8 2.8 0 0 0 3.78-1.178l5.764-10.979a2.8 2.8 0 0 0-1.177-3.78l-11.094-5.825a2.8 2.8 0 0 0-3.78 1.178Z" fill="var(--cros-sys-illo-color1-2)"/><path d="M105.35 45.95a8 8 0 1 0 0-16 8 8 0 0 0 0 16Z" fill="var(--cros-sys-illo-color5)"/><path d="M131.083 100.235v-9.8a.7.7 0 0 0-1-.6l-8.5 4.9a.694.694 0 0 0-.34.6.695.695 0 0 0 .34.6l8.5 4.9a.597.597 0 0 0 .735.093.597.597 0 0 0 .265-.693Z" fill="var(--cros-sys-illo-color2)"/><path d="M123.1 163.65H92.7a3.6 3.6 0 0 0-3.6 3.6v10.11a3.6 3.6 0 0 0 3.6 3.6h30.4a3.6 3.6 0 0 0 3.6-3.6v-10.11a3.6 3.6 0 0 0-3.6-3.6Z" fill="var(--cros-sys-illo-color1-1)"/><path d="M129.4 183.95H86.6c-2.3 0-4.1-1.4-4.1-3.1v-8.6c0-1.7 1.8-3.1 4.1-3.1s3.3 1 5.2 1.4c14.8 3.2 28.5 1 37.6-1.4a4.907 4.907 0 0 1 2.9.9 2.904 2.904 0 0 1 1.2 2.2v8.6c0 1.7-1.9 3.1-4.1 3.1Z" fill="var(--cros-sys-illo-base)"/><path d="M129.4 183.95H86.6c-2.3 0-4.1-1.4-4.1-3.1v-8.6c0-1.7 1.8-3.1 4.1-3.1s3.3 1 5.2 1.4c14.8 3.2 28.5 1 37.6-1.4a4.907 4.907 0 0 1 2.9.9 2.904 2.904 0 0 1 1.2 2.2v8.6c0 1.7-1.9 3.1-4.1 3.1Z" fill="var(--cros-sys-illo-color1-2)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M134.5 177.73v-5.506l-.001-.026a3.909 3.909 0 0 0-1.614-2.959l-.007-.005a5.905 5.905 0 0 0-3.492-1.084l-.123.002-.118.031c-9.017 2.378-22.545 4.544-37.134 1.39l-.005-.001c-.64-.135-1.136-.337-1.712-.571a32.296 32.296 0 0 0-.583-.233c-.841-.326-1.794-.618-3.111-.618-2.584 0-5.1 1.613-5.1 4.1v5.48h-2.15v7.07h-31.8a1.25 1.25 0 0 0 0 2.5h120.9a1.25 1.25 0 0 0 0-2.5h-31.8v-7.07h-2.15Zm-4.971-7.58c-9.183 2.409-22.995 4.608-37.938 1.378-.832-.175-1.54-.465-2.142-.711-.161-.065-.314-.128-.46-.184-.709-.275-1.406-.483-2.389-.483-2.016 0-3.1 1.187-3.1 2.1v5.48h49v-5.451a1.903 1.903 0 0 0-.781-1.415 3.897 3.897 0 0 0-2.19-.714Z" fill="var(--cros-sys-illo-color1)"/><rect x="89.824" y="112.55" width="36.353" height="36.353" rx="8" fill="var(--cros-sys-illo-color1-2)"/><path d="M111.682 122.64a1.94 1.94 0 0 0-2.771 2.717l3.424 3.494H99.299a1.94 1.94 0 1 0 0 3.881h12.643c-1.052 1.132-2.094 2.269-3.131 3.4l-.01.011a1.941 1.941 0 0 0 2.861 2.623c2.138-2.333 4.254-4.641 6.431-6.881a1.941 1.941 0 0 0-.006-2.711l-6.405-6.534Z" fill="var(--cros-sys-illo-color1)"/>
      </g>
      <g id="switch-access-setup-guide-assign-previous" viewBox="0 0 216 216" fill="none">
        <path d="M137.85 46.05a6.1 6.1 0 0 1 1 8.4l-8.6 11a5.796 5.796 0 0 1-3.937 2.266 5.802 5.802 0 0 1-4.363-1.266 5.893 5.893 0 0 1-2.126-6.228 5.904 5.904 0 0 1 1.026-2.072l8.6-11a6 6 0 0 1 8.4-1.1Z" fill="var(--cros-sys-illo-color3)"/><path d="M60.85 67.95c4.5 2.5 9.3 6.3 10.6 11.8 1.9 8-4.8 13.5-2.8 21.2.9 3.5 3.6 7.7 11.3 11.6" stroke="var(--cros-sys-illo-color1-2)" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"/><path d="m93.072 73.505-5.764 10.979a2.8 2.8 0 0 0 1.178 3.78L99.58 94.09a2.8 2.8 0 0 0 3.78-1.178l5.764-10.979a2.8 2.8 0 0 0-1.177-3.78l-11.094-5.825a2.8 2.8 0 0 0-3.78 1.178Z" fill="var(--cros-sys-illo-color1-2)"/><path d="M105.35 45.95a8 8 0 1 0 0-16 8 8 0 0 0 0 16Z" fill="var(--cros-sys-illo-color5)"/><path d="M131.083 100.235v-9.8a.7.7 0 0 0-1-.6l-8.5 4.9a.694.694 0 0 0-.34.6.695.695 0 0 0 .34.6l8.5 4.9a.597.597 0 0 0 .735.093.597.597 0 0 0 .265-.693Z" fill="var(--cros-sys-illo-color2)"/><path d="M123.1 163.65H92.7a3.6 3.6 0 0 0-3.6 3.6v10.11a3.6 3.6 0 0 0 3.6 3.6h30.4a3.6 3.6 0 0 0 3.6-3.6v-10.11a3.6 3.6 0 0 0-3.6-3.6Z" fill="var(--cros-sys-illo-color1-1)"/><path d="M129.4 183.95H86.6c-2.3 0-4.1-1.4-4.1-3.1v-8.6c0-1.7 1.8-3.1 4.1-3.1s3.3 1 5.2 1.4c14.8 3.2 28.5 1 37.6-1.4a4.907 4.907 0 0 1 2.9.9 2.904 2.904 0 0 1 1.2 2.2v8.6c0 1.7-1.9 3.1-4.1 3.1Z" fill="var(--cros-sys-illo-base)"/><path d="M129.4 183.95H86.6c-2.3 0-4.1-1.4-4.1-3.1v-8.6c0-1.7 1.8-3.1 4.1-3.1s3.3 1 5.2 1.4c14.8 3.2 28.5 1 37.6-1.4a4.907 4.907 0 0 1 2.9.9 2.904 2.904 0 0 1 1.2 2.2v8.6c0 1.7-1.9 3.1-4.1 3.1Z" fill="var(--cros-sys-illo-color1-2)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M134.5 177.73v-5.506l-.001-.026a3.909 3.909 0 0 0-1.614-2.959l-.007-.005a5.905 5.905 0 0 0-3.492-1.084l-.123.002-.118.031c-9.017 2.378-22.545 4.544-37.134 1.39l-.005-.001c-.64-.135-1.136-.337-1.712-.571a32.296 32.296 0 0 0-.583-.233c-.841-.326-1.794-.618-3.111-.618-2.584 0-5.1 1.613-5.1 4.1v5.48h-2.15v7.07h-31.8a1.25 1.25 0 0 0 0 2.5h120.9a1.25 1.25 0 0 0 0-2.5h-31.8v-7.07h-2.15Zm-4.971-7.58c-9.183 2.409-22.995 4.608-37.938 1.378-.832-.175-1.54-.465-2.142-.711-.161-.065-.314-.128-.46-.184-.709-.275-1.406-.483-2.389-.483-2.016 0-3.1 1.187-3.1 2.1v5.48h49v-5.451a1.903 1.903 0 0 0-.781-1.415 3.897 3.897 0 0 0-2.19-.714Z" fill="var(--cros-sys-illo-color1)"/><rect x="89.824" y="112.55" width="36.353" height="36.353" rx="8" fill="var(--cros-sys-illo-color1-2)"/><path d="M104.317 122.64a1.94 1.94 0 1 1 2.772 2.717l-3.424 3.494h13.036a1.94 1.94 0 1 1 0 3.881h-12.643c1.052 1.132 2.094 2.269 3.131 3.4l.01.011a1.94 1.94 0 0 1-2.861 2.623c-2.138-2.333-4.254-4.641-6.43-6.881a1.941 1.941 0 0 1 .005-2.711l6.404-6.534Z" fill="var(--cros-sys-illo-color1)"/>
      </g>
      <g id="switch-access-setup-guide-assign-select" viewBox="0 0 216 216" fill="none">
        <path d="M137.85 46.05a6.1 6.1 0 0 1 1 8.4l-8.6 11a5.796 5.796 0 0 1-3.937 2.266 5.802 5.802 0 0 1-4.363-1.266 5.893 5.893 0 0 1-2.126-6.228 5.904 5.904 0 0 1 1.026-2.072l8.6-11a6 6 0 0 1 8.4-1.1Z" fill="var(--cros-sys-illo-color3)"/><path d="M60.85 67.95c4.5 2.5 9.3 6.3 10.6 11.8 1.9 8-4.8 13.5-2.8 21.2.9 3.5 3.6 7.7 11.3 11.6" stroke="var(--cros-sys-illo-color1-2)" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"/><path d="m93.072 73.505-5.764 10.979a2.8 2.8 0 0 0 1.178 3.78L99.58 94.09a2.8 2.8 0 0 0 3.78-1.178l5.764-10.979a2.8 2.8 0 0 0-1.177-3.78l-11.094-5.825a2.8 2.8 0 0 0-3.78 1.178Z" fill="var(--cros-sys-illo-color1-2)"/><path d="M105.35 45.95a8 8 0 1 0 0-16 8 8 0 0 0 0 16Z" fill="var(--cros-sys-illo-color5)"/><path d="M131.083 100.235v-9.8a.7.7 0 0 0-1-.6l-8.5 4.9a.694.694 0 0 0-.34.6.695.695 0 0 0 .34.6l8.5 4.9a.597.597 0 0 0 .735.093.597.597 0 0 0 .265-.693Z" fill="var(--cros-sys-illo-color2)"/><path d="M123.1 163.65H92.7a3.6 3.6 0 0 0-3.6 3.6v10.11a3.6 3.6 0 0 0 3.6 3.6h30.4a3.6 3.6 0 0 0 3.6-3.6v-10.11a3.6 3.6 0 0 0-3.6-3.6Z" fill="var(--cros-sys-illo-color1-1)"/><path d="M129.4 183.95H86.6c-2.3 0-4.1-1.4-4.1-3.1v-8.6c0-1.7 1.8-3.1 4.1-3.1s3.3 1 5.2 1.4c14.8 3.2 28.5 1 37.6-1.4a4.907 4.907 0 0 1 2.9.9 2.904 2.904 0 0 1 1.2 2.2v8.6c0 1.7-1.9 3.1-4.1 3.1Z" fill="var(--cros-sys-illo-base)"/><path d="M129.4 183.95H86.6c-2.3 0-4.1-1.4-4.1-3.1v-8.6c0-1.7 1.8-3.1 4.1-3.1s3.3 1 5.2 1.4c14.8 3.2 28.5 1 37.6-1.4a4.907 4.907 0 0 1 2.9.9 2.904 2.904 0 0 1 1.2 2.2v8.6c0 1.7-1.9 3.1-4.1 3.1Z" fill="var(--cros-sys-illo-color1-2)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M134.5 177.73v-5.506l-.001-.026a3.909 3.909 0 0 0-1.614-2.959l-.007-.005a5.905 5.905 0 0 0-3.492-1.084l-.123.002-.118.031c-9.017 2.378-22.545 4.544-37.134 1.39l-.005-.001c-.64-.135-1.136-.337-1.712-.571a32.296 32.296 0 0 0-.583-.233c-.841-.326-1.794-.618-3.111-.618-2.584 0-5.1 1.613-5.1 4.1v5.48h-2.15v7.07h-31.8a1.25 1.25 0 0 0 0 2.5h120.9a1.25 1.25 0 0 0 0-2.5h-31.8v-7.07h-2.15Zm-4.971-7.58c-9.183 2.409-22.995 4.608-37.938 1.378-.832-.175-1.54-.465-2.142-.711-.161-.065-.314-.128-.46-.184-.709-.275-1.406-.483-2.389-.483-2.016 0-3.1 1.187-3.1 2.1v5.48h49v-5.451a1.903 1.903 0 0 0-.781-1.415 3.897 3.897 0 0 0-2.19-.714Z" fill="var(--cros-sys-illo-color1)"/><rect x="89.824" y="112.55" width="36.353" height="36.353" rx="8" fill="var(--cros-sys-illo-color1-2)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M100 130.727a8 8 0 0 1 8-8 8 8 0 1 1 0 16 8 8 0 0 1-8-8Zm8-4a4 4 0 1 0 0 8 4 4 0 0 0 0-8Z" fill="var(--cros-sys-illo-color1)"/>
      </g>
      <g id="switch-access-setup-guide-auto-scan" viewBox="0 0 217 216" fill="none">
        <g clip-path="url(#a)"><path d="M104.131 157.894 91.337 172.61a4.5 4.5 0 0 0 .444 6.349l14.536 12.636a4.502 4.502 0 0 0 6.349-.444l12.793-14.717a4.502 4.502 0 0 0-.444-6.349l-14.536-12.635a4.499 4.499 0 0 0-6.348.444Z" fill="var(--cros-sys-illo-color2)"/><path d="m31.205 128.6-11.8-11.8a2.398 2.398 0 0 1-.6-2.3l4.3-16.2a2.299 2.299 0 0 1 1.7-1.6l16.1-4.3a2.2 2.2 0 0 1 2.3.6l11.8 11.8a2.2 2.2 0 0 1 .6 2.3l-4.3 16.1a2.303 2.303 0 0 1-1.6 1.7l-16.2 4.3a2.406 2.406 0 0 1-2.3-.6Z" fill="var(--cros-sys-illo-color3)"/><path d="m164.386 172.227 20.439 14.741c3.135 2.261 7.505 1.56 9.76-1.567 2.255-3.126 1.541-7.494-1.594-9.756l-20.439-14.741c-3.136-2.261-7.506-1.56-9.761 1.567-2.255 3.127-1.541 7.494 1.595 9.756Z" fill="var(--cros-sys-illo-color1)"/><path d="M105.205 98.7c-.816 1.81-1.252 3.821-1.9 5.7a10.4 10.4 0 0 1-4.8 5.7c-3.1 1.7-6.7 2.6-8.2 6.2a9.502 9.502 0 0 0-.47 4.614c.437 2.993 2.323 5.713 5.055 7.042a8.908 8.908 0 0 0 3.696.895 8.964 8.964 0 0 0 6.819-2.951c1-1.2 1.8-2.6 2.7-3.8a9.495 9.495 0 0 1 2.848-2.811c2.066-1.315 4.492-1.508 6.852-1.889a9.178 9.178 0 0 0 2.8-.5 11.497 11.497 0 0 0 5.3-3.1c4.2-4.3 4.5-11.4.7-16.5s-12.9-7.1-18.3-2.5a12.998 12.998 0 0 0-3.1 3.9Z" fill="var(--cros-sys-illo-color1-1)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M23.213 161.417a18.902 18.902 0 0 0 23.129 24.635 18.9 18.9 0 0 0 10.78-8.329c.163-.269.133-.626-.17-.772l-32.998-15.9-.016-.008c-.339-.168-.613.07-.725.374Zm-.876-3.143a3.497 3.497 0 0 1 2.926.078l32.995 15.897a3.5 3.5 0 0 1 1.417 5.049 21.9 21.9 0 0 1-39.29-18.883 3.502 3.502 0 0 1 1.952-2.141Z" fill="var(--cros-sys-illo-color5)"/><path d="M190.005 32.2h-27a1.4 1.4 0 0 0-1.4 1.4v27.03a1.4 1.4 0 0 0 1.4 1.4h27a1.4 1.4 0 0 0 1.4-1.4V33.6a1.4 1.4 0 0 0-1.4-1.4Z" fill="var(--cros-sys-illo-color1-2)"/><path d="M38.105 66.1c10.052 0 18.2-8.148 18.2-18.2s-8.148-18.2-18.2-18.2-18.2 8.148-18.2 18.2 8.148 18.2 18.2 18.2Z" fill="var(--cros-sys-illo-color4)"/><path d="m125.605 46.6-27.5-15.9a.699.699 0 0 0-1.1.6V63a.7.7 0 0 0 1.1.6l27.5-15.8a.705.705 0 0 0 0-1.2Z" fill="var(--cros-sys-illo-color5)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M170.505 97.26c-7.684 3.898-10.754 13.283-6.859 20.961 3.895 7.677 13.282 10.743 20.966 6.845l.267-.136c7.685-3.898 10.754-13.283 6.859-20.961-3.895-7.678-13.281-10.743-20.966-6.845l-.267.136Zm-9.534 22.318c-4.646-9.157-.984-20.347 8.177-24.994l.267-.136c9.16-4.647 20.353-.993 24.998 8.164 4.646 9.157.984 20.346-8.176 24.994l-.268.135c-9.16 4.648-20.353.994-24.998-8.163Z" fill="var(--cros-sys-illo-color6)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M37.505 83.6c-14.857 0-26.9 12.044-26.9 26.9 0 14.857 12.043 26.9 26.9 26.9 14.856 0 26.9-12.043 26.9-26.9 0-14.856-12.044-26.9-26.9-26.9Zm-29.9 26.9c0-16.513 13.387-29.9 29.9-29.9 16.513 0 29.9 13.387 29.9 29.9 0 16.513-13.387 29.9-29.9 29.9-16.513 0-29.9-13.387-29.9-29.9Z" fill="var(--cros-sys-illo-color1-2)"/></g><defs><clipPath id="a"><path fill="var(--cros-sys-illo-base)" transform="translate(.305)" d="M0 0h216v216H0z"/></clipPath></defs>
      </g>
      <g id="switch-access-setup-guide-choose-1-switch" viewBox="0 0 217 216" fill="none">
        <path d="M125.305 51h-34c-9.776 0-17.7 7.925-17.7 17.7v34c0 9.775 7.924 17.7 17.7 17.7h34c9.775 0 17.7-7.925 17.7-17.7v-34c0-9.775-7.925-17.7-17.7-17.7Z" fill="var(--cros-sys-illo-color1-2)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M108.305 78.1a7.6 7.6 0 1 0 0 15.2 7.6 7.6 0 0 0 0-15.2Zm-13.6 7.6c0-7.511 6.089-13.6 13.6-13.6 7.511 0 13.6 6.089 13.6 13.6 0 7.511-6.089 13.6-13.6 13.6-7.511 0-13.6-6.089-13.6-13.6Z" fill="var(--cros-sys-illo-color1)"/><path d="M123.455 151.7h-30.4a3.6 3.6 0 0 0-3.6 3.6v10.11a3.6 3.6 0 0 0 3.6 3.6h30.4a3.6 3.6 0 0 0 3.6-3.6V155.3a3.6 3.6 0 0 0-3.6-3.6Z" fill="var(--cros-sys-illo-color1-1)"/><path d="M129.655 172h-42.8c-2.3 0-4.1-1.3-4.1-3.1v-8.6c0-1.7 1.8-3.1 4.1-3.1l5.2 1.4c14.8 3.3 28.5 1 37.6-1.4a4.895 4.895 0 0 1 2.9.9 3.103 3.103 0 0 1 1.2 2.2v8.6c0 1.8-1.8 3.1-4.1 3.1Z" fill="var(--cros-sys-illo-base)"/><path d="M129.655 172h-42.8c-2.3 0-4.1-1.3-4.1-3.1v-8.6c0-1.7 1.8-3.1 4.1-3.1l5.2 1.4c14.8 3.3 28.5 1 37.6-1.4a4.895 4.895 0 0 1 2.9.9 3.103 3.103 0 0 1 1.2 2.2v8.6c0 1.8-1.8 3.1-4.1 3.1Z" fill="var(--cros-sys-illo-color1-2)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M134.755 165v-4.742l-.004-.041a4.098 4.098 0 0 0-1.587-2.91l-.015-.012-.016-.011a5.898 5.898 0 0 0-3.492-1.084l-.123.002-.118.031c-9.019 2.379-22.533 4.64-37.106 1.396l-5.307-1.429h-.132c-2.584 0-5.1 1.613-5.1 4.1v4.7h-2.1v8.1h-75.5a1 1 0 0 0 0 2h208.3a1 1 0 0 0 0-2h-75.5V165h-2.2Zm-4.971-6.8c-9.177 2.408-22.996 4.71-37.947 1.376l-.021-.005-5.088-1.369c-1.934.048-2.973 1.204-2.973 2.098v4.7h49v-4.654a2.1 2.1 0 0 0-.795-1.442 3.901 3.901 0 0 0-2.176-.704Z" fill="var(--cros-sys-illo-color1)"/>
      </g>
      <g id="switch-access-setup-guide-choose-2-switches" viewBox="0 0 217 216" fill="none">
        <path d="M51.005 48.4h34c9.775 0 17.7 7.925 17.7 17.7v34c0 9.775-7.925 17.7-17.7 17.7h-34c-9.776 0-17.7-7.925-17.7-17.7v-34c0-9.775 7.925-17.7 17.7-17.7ZM135.305 48.4h34c9.775 0 17.7 7.925 17.7 17.7v34c0 9.775-7.925 17.7-17.7 17.7h-34c-9.775 0-17.7-7.925-17.7-17.7v-34c0-9.775 7.925-17.7 17.7-17.7Z" fill="var(--cros-sys-illo-color1-2)"/><path d="M71.702 68.76a3 3 0 0 1 4.242.037l11.6 11.8a3 3 0 0 1 .06 4.144l-11.7 12.6a3 3 0 0 1-4.397-4.082L78.06 86.2H53.705a3 3 0 0 1 0-6h25.036l-7.075-7.197a3 3 0 0 1 .036-4.243Z" fill="var(--cros-sys-illo-color1)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M152.305 69.5c-7.511 0-13.6 6.089-13.6 13.6 0 7.511 6.089 13.6 13.6 13.6 7.511 0 13.6-6.089 13.6-13.6 0-7.511-6.089-13.6-13.6-13.6Zm-7.6 13.6a7.6 7.6 0 1 1 15.2 0 7.6 7.6 0 0 1-15.2 0Z" fill="var(--cros-sys-illo-color1)"/><path d="M52.805 151.7h30.4a3.6 3.6 0 0 1 3.6 3.6v10.11a3.6 3.6 0 0 1-3.6 3.6h-30.4a3.6 3.6 0 0 1-3.6-3.6V155.3a3.6 3.6 0 0 1 3.6-3.6ZM137.105 151.7h30.4a3.6 3.6 0 0 1 3.6 3.6v10.11a3.6 3.6 0 0 1-3.6 3.6h-30.4a3.6 3.6 0 0 1-3.6-3.6V155.3a3.6 3.6 0 0 1 3.6-3.6Z" fill="var(--cros-sys-illo-color1-1)"/><path d="M46.605 172h42.8c2.3 0 4.1-1.3 4.1-3.1v-8.6a3.1 3.1 0 0 0-1.2-2.2 4.894 4.894 0 0 0-2.9-.9c-9.1 2.4-22.8 4.7-37.6 1.4l-5.2-1.4c-2.3 0-4.1 1.4-4.1 3.1v8.6c0 1.8 1.8 3.1 4.1 3.1ZM130.905 172h42.8c2.3 0 4.1-1.3 4.1-3.1v-8.6a3.099 3.099 0 0 0-1.2-2.2 4.893 4.893 0 0 0-2.9-.9c-9.1 2.4-22.8 4.7-37.6 1.4l-5.2-1.4c-2.3 0-4.1 1.4-4.1 3.1v8.6c0 1.8 1.8 3.1 4.1 3.1Z" fill="var(--cros-sys-illo-base)"/><path d="M46.605 172h42.8c2.3 0 4.1-1.3 4.1-3.1v-8.6a3.1 3.1 0 0 0-1.2-2.2 4.894 4.894 0 0 0-2.9-.9c-9.1 2.4-22.8 4.7-37.6 1.4l-5.2-1.4c-2.3 0-4.1 1.4-4.1 3.1v8.6c0 1.8 1.8 3.1 4.1 3.1ZM130.905 172h42.8c2.3 0 4.1-1.3 4.1-3.1v-8.6a3.099 3.099 0 0 0-1.2-2.2 4.893 4.893 0 0 0-2.9-.9c-9.1 2.4-22.8 4.7-37.6 1.4l-5.2-1.4c-2.3 0-4.1 1.4-4.1 3.1v8.6c0 1.8 1.8 3.1 4.1 3.1Z" fill="var(--cros-sys-illo-color1-2)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M41.505 160.3v4.7h-2.15v8.1h-35.2a1 1 0 0 0 0 2h208.3a1 1 0 0 0 0-2h-31.5V165h-2.15v-4.742l-.003-.041a4.092 4.092 0 0 0-1.588-2.91l-.015-.012-.016-.011a5.898 5.898 0 0 0-3.492-1.084l-.123.002-.118.031c-9.019 2.379-22.533 4.64-37.106 1.396l-5.307-1.429h-.132c-2.584 0-5.1 1.613-5.1 4.1v4.7h-2.15v8.1h-27V165h-2.15v-4.742l-.004-.041a4.102 4.102 0 0 0-1.587-2.91l-.015-.012-.016-.011a5.897 5.897 0 0 0-3.492-1.084l-.123.002-.118.031c-9.019 2.379-22.533 4.64-37.106 1.396l-5.307-1.429h-.132c-2.584 0-5.1 1.613-5.1 4.1Zm48.03-2.1c-9.178 2.408-22.997 4.71-37.948 1.376l-.021-.005-5.088-1.369c-1.934.048-2.973 1.204-2.973 2.098v4.7h49v-4.654a2.104 2.104 0 0 0-.795-1.442 3.902 3.902 0 0 0-2.176-.704Zm87.27 6.8h-49v-4.7c0-.894 1.039-2.05 2.974-2.098l5.087 1.369.021.005c14.951 3.334 28.77 1.032 37.947-1.376a3.901 3.901 0 0 1 2.176.704 2.1 2.1 0 0 1 .795 1.442V165Z" fill="var(--cros-sys-illo-color1)"/>
      </g>
      <g id="switch-access-setup-guide-choose-3-switches" viewBox="0 0 217 216" fill="none">
        <path d="M48.105 50.7h-23.6c-9.775 0-17.7 7.924-17.7 17.7v23.57c0 9.775 7.925 17.7 17.7 17.7h23.6c9.775 0 17.7-7.925 17.7-17.7V68.4c0-9.776-7.925-17.7-17.7-17.7ZM120.105 50.7h-23.6c-9.775 0-17.7 7.924-17.7 17.7v23.57c0 9.775 7.924 17.7 17.7 17.7h23.6c9.775 0 17.7-7.925 17.7-17.7V68.4c0-9.776-7.925-17.7-17.7-17.7ZM168.505 50.7h23.6c9.775 0 17.7 7.924 17.7 17.7v23.57c0 9.775-7.925 17.7-17.7 17.7h-23.6c-9.776 0-17.7-7.925-17.7-17.7V68.4c0-9.776 7.924-17.7 17.7-17.7Z" fill="var(--cros-sys-illo-color1-2)"/><path d="M123.699 151.7h-30.4a3.6 3.6 0 0 0-3.6 3.6v10.11a3.6 3.6 0 0 0 3.6 3.6h30.4a3.6 3.6 0 0 0 3.6-3.6V155.3a3.6 3.6 0 0 0-3.6-3.6ZM194.305 151.7h-30.4a3.6 3.6 0 0 0-3.6 3.6v10.11a3.6 3.6 0 0 0 3.6 3.6h30.4a3.6 3.6 0 0 0 3.6-3.6V155.3a3.6 3.6 0 0 0-3.6-3.6ZM22.205 151.7h30.4a3.6 3.6 0 0 1 3.6 3.6v10.11a3.6 3.6 0 0 1-3.6 3.6h-30.4a3.6 3.6 0 0 1-3.6-3.6V155.3a3.6 3.6 0 0 1 3.6-3.6Z" fill="var(--cros-sys-illo-color1-1)"/><path d="M34.847 71.9a3 3 0 0 0-4.285-4.2l-9.9 10.1a3 3 0 0 0-.049 4.148l10 10.7a3 3 0 1 0 4.384-4.096L30.089 83.3h19.616a3 3 0 1 0 0-6h-20.15l5.292-5.4ZM184.347 67.7a3 3 0 1 0-4.284 4.2l5.293 5.4h-20.151a3 3 0 1 0 0 6h19.544c-1.627 1.75-3.238 3.508-4.84 5.256l-.015.017a2.999 2.999 0 1 0 4.422 4.054c3.305-3.605 6.576-7.173 9.941-10.637a3 3 0 0 0-.01-4.19l-9.9-10.1Z" fill="var(--cros-sys-illo-color1)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M96.505 80.2c0-6.627 5.373-12 12-12s12 5.373 12 12-5.373 12-12 12-12-5.373-12-12Zm12-6a6 6 0 1 0 0 12 6 6 0 0 0 0-12Z" fill="var(--cros-sys-illo-color1)"/><path d="M16.105 172h42.8c2.2 0 4.1-1.4 4.1-3.1v-8.6a2.896 2.896 0 0 0-1.2-2.2 4.894 4.894 0 0 0-2.9-.9c-9.1 2.4-22.8 4.6-37.6 1.4-.736-.155-1.337-.4-1.93-.642-.94-.383-1.86-.758-3.27-.758-2.3 0-4.1 1.4-4.1 3.1v8.6c0 1.7 1.8 3.1 4.1 3.1ZM129.899 172h-42.8c-2.3 0-4.1-1.3-4.1-3.1v-8.6c0-1.7 1.8-3.1 4.1-3.1l5.2 1.4c14.8 3.3 28.5 1 37.6-1.4a4.895 4.895 0 0 1 2.9.9 3.103 3.103 0 0 1 1.2 2.2v8.6c0 1.8-1.8 3.1-4.1 3.1ZM200.605 172h-42.8c-2.3 0-4.1-1.4-4.1-3.1v-8.6c0-1.7 1.8-3.1 4.1-3.1 1.409 0 2.331.376 3.27.758.593.242 1.194.487 1.93.642 14.8 3.2 28.5 1 37.6-1.4a4.907 4.907 0 0 1 2.9.9 2.904 2.904 0 0 1 1.2 2.2v8.6c0 1.7-1.9 3.1-4.1 3.1Z" fill="var(--cros-sys-illo-base)"/><path d="M16.105 172h42.8c2.2 0 4.1-1.4 4.1-3.1v-8.6a2.896 2.896 0 0 0-1.2-2.2 4.894 4.894 0 0 0-2.9-.9c-9.1 2.4-22.8 4.6-37.6 1.4-.736-.155-1.337-.4-1.93-.642-.94-.383-1.86-.758-3.27-.758-2.3 0-4.1 1.4-4.1 3.1v8.6c0 1.7 1.8 3.1 4.1 3.1ZM129.899 172h-42.8c-2.3 0-4.1-1.3-4.1-3.1v-8.6c0-1.7 1.8-3.1 4.1-3.1l5.2 1.4c14.8 3.3 28.5 1 37.6-1.4a4.895 4.895 0 0 1 2.9.9 3.103 3.103 0 0 1 1.2 2.2v8.6c0 1.8-1.8 3.1-4.1 3.1ZM200.605 172h-42.8c-2.3 0-4.1-1.4-4.1-3.1v-8.6c0-1.7 1.8-3.1 4.1-3.1 1.409 0 2.331.376 3.27.758.593.242 1.194.487 1.93.642 14.8 3.2 28.5 1 37.6-1.4a4.907 4.907 0 0 1 2.9.9 2.904 2.904 0 0 1 1.2 2.2v8.6c0 1.7-1.9 3.1-4.1 3.1Z" fill="var(--cros-sys-illo-color1-2)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M64.005 165v-4.726l-.001-.027a3.898 3.898 0 0 0-1.614-2.958l-.007-.005a5.897 5.897 0 0 0-3.492-1.084l-.123.002-.118.031c-9.017 2.378-22.545 4.544-37.134 1.39l-.005-.002c-.64-.134-1.136-.336-1.712-.57a41.42 41.42 0 0 0-.583-.234c-.841-.325-1.794-.617-3.111-.617-2.584 0-5.1 1.613-5.1 4.1v4.7h-2.2v8.1H4.399a1 1 0 0 0 0 2h208.3a1 1 0 0 0 0-2h-4.894V165h-2.1v-4.726l-.001-.026a3.909 3.909 0 0 0-1.614-2.959l-.007-.005a5.905 5.905 0 0 0-3.492-1.084l-.123.002-.118.031c-9.017 2.378-22.545 4.544-37.134 1.39l-.005-.001c-.64-.135-1.136-.337-1.711-.571a33.947 33.947 0 0 0-.584-.233c-.841-.326-1.794-.618-3.111-.618-2.584 0-5.1 1.613-5.1 4.1v4.7h-2.2v8.1h-13.306V165h-2.2v-4.742l-.004-.041a4.098 4.098 0 0 0-1.587-2.91l-.015-.012-.016-.011a5.898 5.898 0 0 0-3.492-1.084l-.123.002-.118.031c-9.019 2.379-22.533 4.64-37.106 1.396L87.23 156.2H87.1c-2.584 0-5.1 1.613-5.1 4.1v4.7h-2.1v8.1H66.105V165h-2.1Zm-4.97-6.8c-9.184 2.409-22.996 4.608-37.939 1.378-.832-.176-1.54-.465-2.143-.711-.16-.065-.313-.128-.46-.184-.708-.275-1.405-.483-2.388-.483-2.016 0-3.1 1.187-3.1 2.1v4.7h49v-4.671a1.902 1.902 0 0 0-.782-1.415 3.894 3.894 0 0 0-2.189-.714Zm144.67 6.8h-49v-4.7c0-.913 1.084-2.1 3.1-2.1.983 0 1.68.208 2.389.483.146.056.299.119.459.184.603.246 1.311.536 2.143.711 14.942 3.23 28.755 1.031 37.938-1.378a3.899 3.899 0 0 1 2.189.714 1.902 1.902 0 0 1 .782 1.415V165Zm-73.677-6.8c-9.177 2.408-22.996 4.71-37.947 1.376l-.021-.005-5.088-1.369C85.038 158.25 84 159.406 84 160.3v4.7h49v-4.654a2.1 2.1 0 0 0-.795-1.442 3.901 3.901 0 0 0-2.176-.704Z" fill="var(--cros-sys-illo-color1)"/>
      </g>
      <g id="switch-access-setup-guide-closing" viewBox="0 0 217 216" fill="none">
        <path d="M165.023 79.312a75.104 75.104 0 0 0-94.711-24.448 75.1 75.1 0 1 0 108.211 67.448 74.812 74.812 0 0 0-13.5-43Z" fill="var(--cros-sys-illo-color1-2)"/><path d="m130.808 46.332 5.125-3.834a1.4 1.4 0 0 0 .282-1.96l-3.822-5.108a1.4 1.4 0 0 0-1.959-.283l-5.125 3.834a1.4 1.4 0 0 0-.282 1.96l3.821 5.108a1.4 1.4 0 0 0 1.96.283Z" fill="var(--cros-sys-illo-color4)"/><path d="m119.823 30.012 2.7-2.7a2.397 2.397 0 0 0 .6-2.3l-1-3.7a2.201 2.201 0 0 0-1.6-1.6l-3.7-1a2.402 2.402 0 0 0-2.3.6l-2.7 2.7a2.204 2.204 0 0 0-.6 2.3l.9 3.7a2.493 2.493 0 0 0 1.7 1.6l3.7 1a2.398 2.398 0 0 0 2.3-.6Z" fill="var(--cros-sys-illo-color5)"/><path d="m132.823 63.912-7.5 6a1.703 1.703 0 0 1-2.324-.239 1.69 1.69 0 0 1-.376-.761l-1.5-9.5a1.697 1.697 0 0 1 1.368-1.847c.277-.054.563-.038.832.047l9 3.4a1.81 1.81 0 0 1 1.002 1.32 1.796 1.796 0 0 1-.502 1.58ZM51.671 91.497a9.1 9.1 0 0 0-3.7-12.3l-18.8-10a9.1 9.1 0 0 0-12.3 3.7v0a9.098 9.098 0 0 0 3.8 12.3l18.7 10.1a9.1 9.1 0 0 0 12.3-3.8Z" stroke="var(--cros-sys-illo-base)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M51.671 91.497a9.1 9.1 0 0 0-3.7-12.3l-18.8-10a9.1 9.1 0 0 0-12.3 3.7v0a9.098 9.098 0 0 0 3.8 12.3l18.7 10.1a9.1 9.1 0 0 0 12.3-3.8Z" stroke="var(--cros-sys-illo-color3)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M107.123 75.912a3.995 3.995 0 0 1-1.6 2.8 3.302 3.302 0 0 1-3.8.3M126.623 123.312a28.303 28.303 0 0 0-.8 3.9c-.7 4.7.3 7.1.1 11.7a32.128 32.128 0 0 1-1 6.2M90.178 129.512c1.1 5.2 2.1 10.4 3.1 15.6" stroke="var(--cros-sys-illo-color1)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M160.723 80.112a14.482 14.482 0 0 0-3.2 3.7c-4.2 7.1 1 16.4 1.5 17.3" stroke="var(--cros-sys-illo-color1-1)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M160.723 80.112a32.915 32.915 0 0 0 6-5.6c4.4-4.9 5.9-9.3 8.6-9.1a2.837 2.837 0 0 1 2.2 1.3c1 1.7-.2 4.7-3.3 7.4" stroke="var(--cros-sys-illo-base)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M192.555 65.157c-.541-.81-1.251-1.307-2.08-1.459-.794-.146-1.563.049-2.214.345-1.275.58-2.419 1.694-3.096 2.515a26.207 26.207 0 0 1-8.153 6.065 10.465 10.465 0 0 0 1.316-2.19c.626-1.445.785-2.99.056-4.228a3.836 3.836 0 0 0-2.995-1.79c-.986-.072-1.824.292-2.547.858-.7.548-1.344 1.324-1.983 2.177-.369.493-.744 1.023-1.141 1.582-1.021 1.44-2.183 3.078-3.739 4.812a31.907 31.907 0 0 1-5.842 5.458 1 1 0 0 0 1.171 1.62 33.885 33.885 0 0 0 6.171-5.756c1.634-1.821 2.9-3.606 3.934-5.064.378-.533.725-1.022 1.048-1.454.624-.834 1.136-1.426 1.614-1.8.453-.355.814-.466 1.174-.439l.014.001c.56.034 1.101.35 1.405.822.265.463.319 1.265-.176 2.408-.489 1.13-1.458 2.44-2.926 3.718a.997.997 0 0 0-.342.798c-.778.24-1.571.43-2.374.57a.999.999 0 1 0 .345 1.97 21.503 21.503 0 0 0 5.329-1.668 28.204 28.204 0 0 0 10.172-7.182c.586-.715 1.506-1.58 2.392-1.982.434-.198.774-.245 1.026-.199.206.038.461.157.733.538.054.151.06.422-.088.874-.131.403-.327.788-.517 1.162l-.093.183c-1.172 1.866-3.79 3.847-6.693 5.596-2.875 1.732-5.858 3.138-7.537 3.879a1 1 0 0 0 .807 1.83c1.721-.76 4.788-2.204 7.763-3.996 2.789-1.68 6.113-3.787 7.713-6.743.115-.212.282-.39.486-.519a1.424 1.424 0 0 1 1.883.37c.264.493.286 1.065.101 1.729-.194.692-.596 1.409-1.062 2.062-3.631 5.063-9.006 8.16-15.258 9.92a1 1 0 1 0 .541 1.925c6.41-1.803 12.128-5.006 16.09-10.334a.992.992 0 0 0 .287-.299c.527-.841 1.781-.921 2.416-.174.182.361.198.826-.001 1.432-.212.646-.636 1.342-1.149 1.994l-.023.03c-3.525 4.86-8.896 7.864-15.065 9.626a1 1 0 1 0 .549 1.923c6.174-1.763 11.792-4.779 15.66-9.742.246.081.473.216.664.394.485.503.562 1.048.389 1.692-.19.71-.68 1.47-1.253 2.151l-.004.005c-4.233 5.099-11.823 9.304-18.364 10.967a.994.994 0 0 0-.388.188c-.743.59-.152 2.162-.04 2.845.198 1.217.472 2.984.771 5.174a1 1 0 1 0 1.981-.27 202.91 202.91 0 0 0-.947-6.237c6.644-1.88 14.157-6.128 18.524-11.387.646-.767 1.35-1.794 1.651-2.916.318-1.183.188-2.51-.904-3.625l-.019-.018-.006-.006a3.8 3.8 0 0 0-.862-.617c.299-.487.559-1.01.735-1.547.315-.96.395-2.078-.194-3.108a1.028 1.028 0 0 0-.076-.114 3.464 3.464 0 0 0-2.731-1.346l.014-.05c.285-1.02.314-2.186-.304-3.284a.956.956 0 0 0-.042-.07c-.758-1.122-2.101-1.65-3.373-1.448a2.55 2.55 0 0 0-.262-1.04.913.913 0 0 0-.062-.107Z" fill="var(--cros-sys-illo-color1-1)"/><path d="m134.728 100.112 61.277.202a1.929 1.929 0 0 1 2.047 1.679c.041.323-.001.652-.122.955l-13.363 41.295a2.001 2.001 0 0 1-1.996 1.869h-72.8a2 2 0 0 1 0-4h8.252l13.058-39.367a4.046 4.046 0 0 1 3.647-2.633Z" fill="var(--cros-sys-illo-color1)"/><path d="M144.292 146.627c1.7-2 5.16-5.042 6.96-7.042 2.761-3.068-.429-5.272-3.729-4.138-7.393 3.242-18.898 11.589-20.332 13.79-1.434 2.201 8.671 22.526 8.671 22.526 11.661-4.69 40.397-7.481 36.461-17.151 0-1.481 2.517-2.394 2.517-5.375-.172-1.189-1.201-2.382-1.295-3.555.861-1.938.632-3.199 0-4.495-.582-1.193-1.837-.899-2.926-1.893-.237-2.415 1.183-5.066-3.084-5.328-4.267-.262-9.133 6.765-11.839 7.684-2.706.918-11.404 4.977-11.404 4.977Z" fill="var(--cros-sys-illo-base)"/><path d="M144.292 146.627c1.7-2 5.16-5.042 6.96-7.042 2.761-3.068-.429-5.272-3.729-4.138-7.393 3.242-18.898 11.589-20.332 13.79-1.434 2.201 8.671 22.526 8.671 22.526 11.661-4.69 40.397-7.481 36.461-17.151 0-1.481 2.517-2.394 2.517-5.375-.172-1.189-1.201-2.382-1.295-3.555.861-1.938.632-3.199 0-4.495-.582-1.193-1.837-.899-2.926-1.893-.237-2.415 1.183-5.066-3.084-5.328-4.267-.262-9.133 6.765-11.839 7.684-2.706.918-11.404 4.977-11.404 4.977Z" fill="var(--cros-sys-illo-color1-2)"/><path d="M162.723 137.303a14.469 14.469 0 0 1 3.885-2.419c1.049-.24 2.067.084 2.638.64.283.276.443.594.48.926.037.329-.038.753-.37 1.262l-.022.035a10.297 10.297 0 0 1-1.744 2.204l-.014.014c-6.619 6.618-11.303 9.833-19.949 12.781a.914.914 0 1 0 .591 1.732c7.861-2.68 12.61-5.616 18.241-10.882a.915.915 0 0 0 .322-.159l2.589-1.992c.745-.537 1.673-.797 2.414-.698.36.048.659.177.89.379.227.198.437.508.559 1 .277 1.189-.487 2.565-1.731 3.713l-.015.014-.011.011c-1 .999-2.093 1.899-3.265 2.689l-.013.009a73.26 73.26 0 0 1-9.676 5.727c-1.311.631-2.679 1.169-4.087 1.705l-.712.27c-1.176.445-2.378.9-3.561 1.407a.914.914 0 1 0 .721 1.682c1.143-.49 2.301-.928 3.477-1.373l.726-.275c1.415-.539 2.846-1.101 4.234-1.769l.007-.003a75.2 75.2 0 0 0 9.914-5.867 23.95 23.95 0 0 0 3.072-2.463.901.901 0 0 0 .21.024c.491 0 .9.272 1.195.781.299.516.407 1.171.314 1.689a5.686 5.686 0 0 1-2.228 3.061l-.03.022c-4.493 3.369-9.292 5.079-14.966 7.101-1.225.437-2.491.887-3.803 1.373a.915.915 0 1 0 .635 1.716c1.261-.466 2.493-.905 3.7-1.334 5.07-1.804 9.676-3.442 13.968-6.289a.95.95 0 0 0 .025.181 3.98 3.98 0 0 1-1.293 3.978 12.49 12.49 0 0 1-4.557 2.323 1.048 1.048 0 0 0-.074.023c-8.135 2.965-10.915 3.574-15.475 4.574-2.021.443-4.392.963-7.733 1.798a.91.91 0 0 0-.101.032l-6.9 2.6a.915.915 0 1 0 .645 1.712l6.851-2.581a245.685 245.685 0 0 1 7.568-1.759c4.609-1.011 7.511-1.647 15.736-4.643a14.313 14.313 0 0 0 5.197-2.661l.016-.013a5.817 5.817 0 0 0 1.899-5.815.915.915 0 0 0-.54-.63l.285-.211a7.516 7.516 0 0 0 2.944-4.088.65.65 0 0 0 .019-.076c.195-.977.001-2.103-.518-3-.341-.59-.853-1.122-1.523-1.427.932-1.193 1.619-2.726 1.234-4.362l-.002-.009c-.201-.814-.589-1.47-1.134-1.946-.542-.473-1.191-.725-1.851-.814a4.593 4.593 0 0 0-1.282.018l.157-.257c.519-.803.734-1.64.644-2.446-.09-.808-.478-1.503-1.021-2.033-1.069-1.043-2.781-1.501-4.423-1.091a.849.849 0 0 0-.129.043 16.28 16.28 0 0 0-4.437 2.744 59.896 59.896 0 0 1-13.441 8.217l.319-.313.011-.011c1.267-1.242 2.551-2.501 3.463-3.463.96-1.013 1.551-2.358 1.389-3.63a2.912 2.912 0 0 0-.883-1.764c-.511-.485-1.197-.797-2.015-.937a5.424 5.424 0 0 0-2.766.241l-.009.004a24.642 24.642 0 0 0-3.736 1.763c-5.111 2.907-12.85 7.648-18.223 12.019a.915.915 0 1 0 1.155 1.419c5.252-4.272 12.887-8.955 17.976-11.849l.006-.004a22.808 22.808 0 0 1 3.456-1.632 3.588 3.588 0 0 1 1.828-.158l.004.001c.543.092.87.276 1.062.459.187.178.295.4.33.67.073.572-.197 1.395-.903 2.14-.885.934-2.146 2.171-3.426 3.426l-.011.01c-1.267 1.242-2.551 2.501-3.463 3.464a.915.915 0 0 0 1.1 1.434.938.938 0 0 0 .177-.045 61.739 61.739 0 0 0 17.788-10.069Z" fill="var(--cros-sys-illo-color1)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M87.887 72.614a11.15 11.15 0 0 1-6.664 2.198c-6.186 0-11.2-5.014-11.2-11.2 0-6.186 5.014-11.2 11.2-11.2 6.185 0 11.2 5.014 11.2 11.2 0 1.16-.177 2.279-.504 3.33a12.248 12.248 0 0 1 7.604-2.63c6.793 0 12.3 5.507 12.3 12.3 0 3.738-1.668 7.087-4.3 9.342l2.018 9.033c5.22.55 19.544 2.884 31.295 14.924a50.004 50.004 0 0 1 12.754 22.448.999.999 0 1 1-1.935.506 47.991 47.991 0 0 0-12.245-21.551l-.003-.004c-11.21-11.488-24.887-13.778-29.989-14.325a13.615 13.615 0 0 1-1.073 2.288c-.851 1.432-2.228 3.064-4.369 3.874-2.163.819-4.872.554-7.337-.591a12.906 12.906 0 0 1-5.82-5.438c-5.013 1.087-17.254 4.55-25.901 15.9-11.226 14.74-10.352 34.895-2.934 47.486l.002.003c11.556 19.742 43.435 28.482 72.969 13.24l-11.301-27.824-30.315.489a1 1 0 0 1-.032-2l31-.5a.999.999 0 0 1 .942.624l11.9 29.3a1 1 0 0 1-.457 1.259c-30.443 16.182-64.092 7.502-76.432-13.577-7.781-13.209-8.706-34.253 3.067-49.712 9.293-12.197 22.5-15.688 27.431-16.72a1.001 1.001 0 0 1 .31-.141l3.304-7.16c-4.22-1.95-7.15-6.22-7.15-11.173 0-1.4.234-2.744.665-3.998Zm1.394 5.102c.551 5.17 4.926 9.196 10.242 9.196 5.688 0 10.3-4.612 10.3-10.3 0-5.18-3.824-9.467-8.802-10.192a18.102 18.102 0 0 1-5.046 7.634c-2.096 1.88-4.11 2.984-6.694 3.662Zm8.2 23.026a10.902 10.902 0 0 1-4.832-4.45l3.582-7.761.024-.058c1.04.286 2.136.439 3.268.439 2.275 0 4.405-.618 6.233-1.695l1.931 8.647a11.758 11.758 0 0 1-1.062 2.387c-.723 1.218-1.797 2.436-3.356 3.026-1.537.581-3.678.446-5.788-.535Z" fill="var(--cros-sys-illo-color1)"/><path d="M160.16 79.165a14.476 14.476 0 0 0-3.569 4c-4.487 7.6.917 17.3 1.529 18.3a.916.916 0 0 0 .379.391c.894.487 1.926-.327 1.457-1.291-.612-.9-5.507-9.7-1.632-16.2a12.476 12.476 0 0 1 3.06-3.5l2.957-2.4-1.224-1.6-2.957 2.3Z" fill="var(--cros-sys-illo-color1)"/><path d="m34.032 93.55 4.864 2.627.008.004a10.1 10.1 0 0 0 13.65-4.215 10.1 10.1 0 0 0-4.108-13.649l-4.23-2.25a75.25 75.25 0 0 0-1.224 1.615l4.504 2.395.003.002a8.1 8.1 0 0 1 3.29 10.947l-.002.005a8.103 8.103 0 0 1-7.919 4.285 8.1 8.1 0 0 1-3.026-.9l-5.018-2.711a73.62 73.62 0 0 0-.792 1.845Z" fill="var(--cros-sys-illo-base)"/><path d="M166.175 49.216h-.139a.761.761 0 0 1-.763-.208l-6.655-5.2a1.04 1.04 0 1 1 1.247-1.664l5.824 4.645 7.696-10.469a12.064 12.064 0 0 0-16.362-.277l-.139.138a12.07 12.07 0 0 0-3.734 13.142 12.054 12.054 0 0 0 6.26 7.046 12.064 12.064 0 0 0 13.49-2.161l.139-.139a11.994 11.994 0 0 0 1.733-16.154L166.729 48.8c-.135.194-.33.34-.554.416Z" fill="var(--cros-sys-illo-color2)"/><path d="M177.476 32.507a1.108 1.108 0 0 0-1.456.208l-2.635 3.605.694.763.693.831 2.912-3.951a1.112 1.112 0 0 0-.208-1.456Z" fill="var(--cros-sys-illo-color1-1)"/>
      </g>
      <g id="switch-access-setup-guide-start-pairing" viewBox="0 0 217 216" fill="none">
        <path d="M4.105 149.598h208.4" stroke="var(--cros-sys-illo-color1)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round"/><path d="m135.605 76.898 3.8-1.1a1.996 1.996 0 0 0 1.4-1.4l.9-3.9a1.899 1.899 0 0 0-.5-1.9l-2.9-2.8a2 2 0 0 0-2-.4l-3.8 1.1a2.1 2.1 0 0 0-1.4 1.5l-.9 3.8a2 2 0 0 0 .6 1.9l2.9 2.8a1.9 1.9 0 0 0 1.9.4Z" fill="var(--cros-sys-illo-color6)"/><path d="M40.405 102.299a3.4 3.4 0 1 0-.001-6.801 3.4 3.4 0 0 0 0 6.801Z" fill="var(--cros-sys-illo-color5)"/><path d="M74.705 59.198a7.593 7.593 0 0 0-.9 1.8l-1 1.9a7.8 7.8 0 0 1-3.9 3.5c-2.4.9-4.9 1.2-6.3 3.6a6.3 6.3 0 0 0-.1 6.1l.2.3a6.101 6.101 0 0 0 9.2 1.2l2.2-2.4a7.3 7.3 0 0 1 5-2.3h4.2a9 9 0 0 0 4-1.8 8.7 8.7 0 0 0-10.1-14.1 9.5 9.5 0 0 0-2.5 2.2v0Z" stroke="var(--cros-sys-illo-color3)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M58.505 90.198c6.296 0 11.4-5.103 11.4-11.4 0-6.296-5.104-11.4-11.4-11.4s-11.4 5.104-11.4 11.4 5.104 11.4 11.4 11.4Z" fill="var(--cros-sys-illo-color2)"/><path d="M69.855 79.872a7.099 7.099 0 0 1-7.985-2.923l-.197-.296a1.01 1.01 0 0 1-.05-.085 7.3 7.3 0 0 1 .115-7.068l.003-.005a6.27 6.27 0 0 1 .989-1.288c.673.269 1.314.6 1.916.986-.46.337-.854.755-1.176 1.307a5.3 5.3 0 0 0-.104 5.087l.177.266a5.1 5.1 0 0 0 6.314 1.892 11.538 11.538 0 0 1-.002 2.127Z" fill="var(--cros-sys-illo-base)"/><path d="M198.905 82.698h-84.4a4.302 4.302 0 0 0-4.1 3.7l-5 60.1h91.9l5.1-60.1c.113-1.981-1.515-3.703-3.5-3.7Z" stroke="var(--cros-sys-illo-color1)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M195.105 149.598h-112.4c-.69 0-1.351-.364-1.838-1.012-.488-.648-.762-1.527-.762-2.444 0-.458.137-.897.38-1.221.245-.324.575-.507.92-.507h115c.345 0 .675.183.919.507s.381.763.381 1.221c0 .917-.274 1.796-.762 2.444-.487.648-1.148 1.012-1.838 1.012Z" fill="var(--cros-sys-illo-base)"/><path d="M198.122 87.335h-83.495c-.773-.055-1.506.516-1.562 1.301l-4.393 52.23h86.161l4.642-52.23c.069-.755-.615-1.363-1.353-1.3Z" fill="var(--cros-sys-illo-color1-2)"/><path d="M154.908 86.603a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z" fill="var(--cros-sys-illo-color1-1)"/><path d="M188.605 146.959a1 1 0 0 1 1-1h3.7a1 1 0 1 1 0 2h-3.7a1 1 0 0 1-1-1ZM187.714 146.959a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z" fill="var(--cros-sys-illo-color1)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M82.705 150.598c-1.061 0-1.999-.561-2.638-1.411-.634-.843-.962-1.941-.962-3.044 0-.646.19-1.304.582-1.823.395-.525 1-.905 1.718-.905h115c.717 0 1.323.38 1.718.905.391.519.582 1.177.582 1.823 0 1.103-.328 2.201-.962 3.044-.639.85-1.577 1.411-2.638 1.411h-112.4Zm113.439-2.613c-.336.447-.721.613-1.039.613h-27.3v-3a.996.996 0 0 0-.017-.183h28.615c.002 0 .008.002.017.007.02.011.059.039.105.1.097.128.18.35.18.621 0 .729-.22 1.389-.561 1.842Zm-30.322-2.57H81.407l-.004.001a.357.357 0 0 0-.119.106c-.096.128-.179.35-.179.621 0 .729.22 1.389.56 1.842.337.447.722.613 1.04.613h83.1v-3c0-.063.006-.124.017-.183Z" fill="var(--cros-sys-illo-color1)"/><path d="M164.674 116.502c1.778-6.728-1.932-13.543-8.286-15.221-6.355-1.68-12.947 2.414-14.724 9.142-1.778 6.728 1.932 13.543 8.286 15.222 6.354 1.678 12.947-2.415 14.724-9.143Z" fill="var(--cros-sys-illo-color1)"/><path d="M123.605 62.398a6 6 0 0 1-8.4 1.1l-11.1-8.4a5.998 5.998 0 0 1-1.1-8.4 5.898 5.898 0 0 1 8.3-1.1l11.1 8.4a6.014 6.014 0 0 1 2.34 3.952 6 6 0 0 1-1.14 4.448Z" fill="var(--cros-sys-illo-color5)"/><path d="m34.205 123.998 6.9.7a1.8 1.8 0 0 0 1.8-.8l4-5.3a1.9 1.9 0 0 0 .3-2l-2.8-6.1a2.108 2.108 0 0 0-1.6-1.1l-7-.7a2.003 2.003 0 0 0-1.8.7l-4 5.3a2.204 2.204 0 0 0-.2 2.1l2.8 6a2.003 2.003 0 0 0 1.6 1.2Z" stroke="var(--cros-sys-illo-color4)" stroke-width="2" stroke-miterlimit="10"/><path d="m146.205 110.598 4.6 5.9a.796.796 0 0 0 1.2.2l13.4-10.4" stroke="var(--cros-sys-illo-base)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="m149.109 97.8-.4-6a.992.992 0 0 0-1.016-.935.997.997 0 0 0-.484.135l-5 3.4a.997.997 0 0 0-.27 1.357.998.998 0 0 0 .37.343l5.4 2.6a.898.898 0 0 0 1.4-.9ZM50.318 131.104H25.913a2.89 2.89 0 0 0-2.89 2.89v8.116a2.89 2.89 0 0 0 2.89 2.89h24.405a2.89 2.89 0 0 0 2.89-2.89v-8.116a2.89 2.89 0 0 0-2.89-2.89Z" fill="var(--cros-sys-illo-color1-1)"/><path d="M55.376 147.4h-34.36c-1.846 0-3.291-1.124-3.291-2.489v-6.904c0-1.364 1.445-2.488 3.291-2.488 1.847 0 2.65.802 4.175 1.124 11.881 2.569 22.88.802 30.185-1.124a3.934 3.934 0 0 1 2.328.722 2.33 2.33 0 0 1 .963 1.766v6.904c0 1.365-1.525 2.489-3.291 2.489Z" fill="var(--cros-sys-illo-base)"/><path d="M55.376 147.4h-34.36c-1.846 0-3.291-1.124-3.291-2.489v-6.904c0-1.364 1.445-2.488 3.291-2.488 1.847 0 2.65.802 4.175 1.124 11.881 2.569 22.88.802 30.185-1.124a3.934 3.934 0 0 1 2.328.722 2.33 2.33 0 0 1 .963 1.766v6.904c0 1.365-1.525 2.489-3.291 2.489Z" fill="var(--cros-sys-illo-color1-2)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M16.922 142.406v-4.399c0-1.996 2.02-3.291 4.094-3.291 1.058 0 1.823.234 2.498.496.166.064.32.127.468.187.462.188.86.35 1.374.458l.004.001c11.712 2.532 22.572.794 29.811-1.115l.095-.026.098-.001a4.741 4.741 0 0 1 2.804.87l.005.004a3.131 3.131 0 0 1 1.296 2.375l.001.021v4.42h1.726v6.68h-46v-6.68h1.726Zm8.101-4.978c11.996 2.593 23.085.827 30.457-1.106.63.009 1.242.209 1.757.572a1.538 1.538 0 0 1 .627 1.137v4.375H18.528v-4.399c0-.733.87-1.685 2.488-1.685.79 0 1.349.167 1.918.387.117.045.24.095.37.148.483.198 1.051.43 1.72.571Z" fill="var(--cros-sys-illo-color1)"/>
      </g>

      <!-- Mouse Keys-->
      <g id="mouse-keys-primary-keyboard-cursor-control" viewBox="0 0 275 108" fill="none">
        <rect width="275" height="108" rx="4" fill="var(--cros-sys-illo-color1-2)"/><rect x="6" y="6" width="16" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="25" y="6" width="16" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="44" y="6" width="16" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="63" y="6" width="16" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="82" y="6" width="16" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="101" y="6" width="16" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="120" y="6" width="16" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="139" y="6" width="16" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="158" y="6" width="16" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="177" y="6" width="16" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="196" y="6" width="16" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="215" y="6" width="16" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="234" y="6" width="16" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="253" y="6" width="16" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="6" y="15" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="24" y="15" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="42" y="15" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="60" y="15" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="78" y="15" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="96" y="15" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="114" y="15" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="132" y="15" width="15" height="15" rx="1" fill="var(--cros-sys-illo-color1)"/><rect x="150" y="15" width="15" height="15" rx="1" fill="var(--cros-sys-illo-color1)"/><rect x="168" y="15" width="15" height="15" rx="1" fill="var(--cros-sys-illo-color1)"/><rect x="186" y="15" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="204" y="15" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="222" y="15" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="240" y="15" width="29" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><path fill-rule="evenodd" clip-rule="evenodd" d="m158.05 20.539 2.622 2.76.678-.702-3.85-3.949-3.85 3.95.679.695 2.621-2.754v5.81h1.1v-5.81ZM177.275 21.503l-.098 3.805.976-.016.069-5.514-5.514.07-.012.971 3.801-.093-4.108 4.108.778.777 4.108-4.108ZM138.503 20.725l3.805.097-.016-.975-5.514-.07.069 5.515.972.012-.094-3.801 4.108 4.108.778-.778-4.108-4.108Z" fill="var(--cros-sys-illo-base)"/><rect x="6" y="33" width="29" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="38" y="33" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="56" y="33" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="74" y="33" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="92" y="33" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="110" y="33" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="128" y="33" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="146" y="33" width="15" height="15" rx="1" fill="var(--cros-sys-illo-color1)"/><rect x="164" y="33" width="15" height="15" rx="1" fill="var(--cros-sys-illo-color1-1)"/><rect x="182" y="33" width="15" height="15" rx="1" fill="var(--cros-sys-illo-color1)"/><path fill-rule="evenodd" clip-rule="evenodd" d="m191.46 41.052-2.76 2.621.701.679 3.949-3.85-3.949-3.85-.696.678 2.755 2.622h-5.81v1.1h5.81ZM151.541 39.948l2.759-2.621-.701-.679-3.949 3.85 3.949 3.85.696-.678-2.754-2.622h5.809v-1.1h-5.809Z" fill="var(--cros-sys-illo-base)"/><rect x="200" y="33" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="218" y="33" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="236" y="33" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="254" y="33" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="6" y="51" width="39" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="48" y="51" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="66" y="51" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="84" y="51" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="102" y="51" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="120" y="51" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="138" y="51" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="156" y="51" width="15" height="15" rx="1" fill="var(--cros-sys-illo-color1)"/><rect x="174" y="51" width="15" height="15" rx="1" fill="var(--cros-sys-illo-color1)"/><rect x="192" y="51" width="15" height="15" rx="1" fill="var(--cros-sys-illo-color1)"/><rect x="210" y="51" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="228" y="51" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="246" y="51" width="23" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><path fill-rule="evenodd" clip-rule="evenodd" d="m161.726 59.497.097-3.805-.975.016-.07 5.514 5.514-.07.013-.971-3.802.094 4.108-4.108-.777-.778-4.108 4.108ZM200.497 60.275l-3.805-.097.016.975 5.515.07-.07-5.515-.972-.012.094 3.801-4.108-4.108-.778.778 4.108 4.108ZM180.95 60.461l-2.621-2.76-.679.702 3.85 3.949 3.85-3.95-.678-.695-2.622 2.754v-5.81h-1.1v5.81Z" fill="var(--cros-sys-illo-base)"/><rect x="6" y="69" width="48" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="57" y="69" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="75" y="69" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="93" y="69" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="111" y="69" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="129" y="69" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="147" y="69" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="165" y="69" width="15" height="15" rx="1" fill="var(--cros-sys-illo-color1-1)"/><rect x="183" y="69" width="15" height="15" rx="1" fill="var(--cros-sys-illo-color1-1)"/><rect x="201" y="69" width="15" height="15" rx="1" fill="var(--cros-sys-illo-color1-1)"/><rect x="219" y="69" width="15" height="15" rx="1" fill="var(--cros-sys-illo-color1-1)"/><rect x="237" y="69" width="32" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="6" y="87" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="24" y="87" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="42" y="87" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="60" y="87" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="78" y="87" width="103" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="184" y="87" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="202" y="87" width="15" height="15" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="220" y="96" width="15" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="237" y="87" width="15" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="237" y="96" width="15" height="6" rx="1" fill="var(--cros-sys-illo-base)"/><rect x="254" y="96" width="15" height="6" rx="1" fill="var(--cros-sys-illo-base)"/>
      </g>
      <g id="mouse-keys-primary-keyboard-press-mouse-button" viewBox="0 0 275 108" fill="none">
        <rect width="275" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="39" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="48" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="66" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="84" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="102" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="120" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="138" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="156" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="174" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="192" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="210" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="228" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="23" height="15" x="246" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="48" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="57" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="75" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="93" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="111" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="129" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="147" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="165" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="183" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="201" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="219" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="32" height="15" x="237" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/>
      </g>
      <g id="mouse-keys-primary-keyboard-change-mouse-button" viewBox="0 0 275 108" fill="none">
        <rect width="275" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="39" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="48" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="66" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="84" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="102" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="120" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="138" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="156" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="174" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="192" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="210" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="228" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="23" height="15" x="246" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="48" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="57" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="75" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="93" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="111" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="129" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="147" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="165" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="183" y="69" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="201" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="219" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="32" height="15" x="237" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/>
      </g>
      <g id="mouse-keys-primary-keyboard-double-click" viewBox="0 0 275 108" fill="none">
        <rect width="275" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="39" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="48" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="66" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="84" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="102" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="120" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="138" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="156" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="174" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="192" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="210" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="228" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="23" height="15" x="246" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="48" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="57" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="75" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="93" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="111" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="129" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="147" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="165" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="183" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="201" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="219" y="69" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="32" height="15" x="237" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/>
      </g>
      <g id="mouse-keys-primary-keyboard-hold-mouse-button" viewBox="0 0 275 108" fill="none">
        <rect width="275" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="39" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="48" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="66" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="84" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="102" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="120" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="138" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="156" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="174" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="192" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="210" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="228" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="23" height="15" x="246" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="48" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="57" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="75" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="93" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="111" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="129" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="147" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="165" y="69" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="183" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="201" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="219" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="32" height="15" x="237" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/>
      </g>
      <g id="mouse-keys-primary-keyboard-release-mouse-button" viewBox="0 0 275 108" fill="none">
        <rect width="275" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="39" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="48" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="66" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="84" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="102" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="120" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="138" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="156" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="174" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="192" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="210" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="228" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="23" height="15" x="246" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="48" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="57" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="75" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="93" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="111" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="129" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="147" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="165" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="183" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="201" y="69" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="219" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="32" height="15" x="237" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/>
      </g>
      <g id="mouse-keys-left-primary-keyboard-cursor-control" viewBox="0 0 275 108" fill="none">
        <rect width="275" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><path fill="var(--cros-sys-illo-base)" fill-rule="evenodd" d="m50.05 20.539 2.622 2.76.678-.702-3.85-3.949-3.85 3.95.679.695 2.621-2.754v5.81h1.1v-5.81ZM69.275 21.503l-.098 3.805.976-.016.07-5.514-5.515.07-.012.971 3.8-.093-4.107 4.108.778.777 4.108-4.108ZM30.503 20.725l3.805.097-.016-.975-5.514-.07.07 5.515.971.012-.093-3.801 4.108 4.108.777-.778-4.108-4.108Z" clip-rule="evenodd"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><path fill="var(--cros-sys-illo-base)" fill-rule="evenodd" d="m83.46 41.052-2.76 2.621.701.679 3.95-3.85-3.95-3.85-.696.678 2.755 2.622h-5.81v1.1h5.81ZM43.54 39.948l2.76-2.621-.701-.679-3.949 3.85 3.949 3.85.696-.678-2.754-2.622h5.81v-1.1h-5.81Z" clip-rule="evenodd"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="39" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="48" y="51" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="66" y="51" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="84" y="51" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="102" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="120" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="138" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="156" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="174" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="192" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="210" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="228" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="23" height="15" x="246" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><path fill="var(--cros-sys-illo-base)" fill-rule="evenodd" d="m53.726 59.497.097-3.805-.975.016-.07 5.514 5.514-.07.013-.971-3.802.094 4.108-4.108-.777-.778-4.108 4.108ZM92.497 60.275l-3.805-.097.016.975 5.514.07-.07-5.515-.971-.012.094 3.801-4.109-4.108-.777.778 4.108 4.108ZM72.95 60.461l-2.621-2.76-.679.702 3.85 3.949 3.85-3.95-.678-.695-2.622 2.754v-5.81h-1.1v5.81Z" clip-rule="evenodd"/><rect width="48" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="57" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="75" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="93" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="111" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="129" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="147" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="165" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="183" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="201" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="219" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="32" height="15" x="237" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/>
      </g>
      <g id="mouse-keys-left-primary-keyboard-press-mouse-button" viewBox="0 0 275 108" fill="none">
        <rect width="275" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="39" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="48" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="66" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="84" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="102" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="120" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="138" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="156" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="174" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="192" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="210" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="228" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="23" height="15" x="246" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="48" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="57" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="75" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="93" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="111" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="129" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="147" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="165" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="183" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="201" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="219" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="32" height="15" x="237" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/>
      </g>
      <g id="mouse-keys-left-primary-keyboard-change-mouse-button" viewBox="0 0 275 108" fill="none">
        <rect width="275" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="39" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="48" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="66" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="84" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="102" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="120" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="138" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="156" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="174" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="192" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="210" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="228" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="23" height="15" x="246" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="48" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="57" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="75" y="69" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="93" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="111" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="129" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="147" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="165" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="183" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="201" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="219" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="32" height="15" x="237" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/>
      </g>
      <g id="mouse-keys-left-primary-keyboard-double-click" viewBox="0 0 275 108" fill="none">
        <rect width="275" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="39" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="48" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="66" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="84" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="102" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="120" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="138" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="156" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="174" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="192" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="210" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="228" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="23" height="15" x="246" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="48" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="57" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="75" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="93" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="111" y="69" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="129" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="147" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="165" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="183" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="201" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="219" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="32" height="15" x="237" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/>
      </g>
      <g id="mouse-keys-left-primary-keyboard-hold-mouse-button" viewBox="0 0 275 108" fill="none">
        <rect width="275" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="39" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="48" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="66" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="84" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="102" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="120" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="138" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="156" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="174" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="192" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="210" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="228" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="23" height="15" x="246" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="48" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="57" y="69" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="75" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="93" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="111" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="129" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="147" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="165" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="183" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="201" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="219" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="32" height="15" x="237" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/>
      </g>
      <g id="mouse-keys-left-primary-keyboard-release-mouse-button" viewBox="0 0 275 108" fill="none">
        <rect width="275" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="39" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="48" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="66" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="84" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="102" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="120" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="138" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="156" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="174" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="192" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="210" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="228" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="23" height="15" x="246" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="48" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="57" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="75" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="93" y="69" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="111" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="129" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="147" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="165" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="183" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="201" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="219" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="32" height="15" x="237" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/>
      </g>
      <g id="mouse-keys-num-keypad-cursor-control" viewBox="0 0 352 108" fill="none">
       <rect width="352" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="31" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="40" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="58" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="76" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="94" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="112" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="130" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="148" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="166" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="220" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="31" height="15" x="238" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="40" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="49" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="67" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="85" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="103" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="121" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="139" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="157" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="175" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="193" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="211" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="40" height="15" x="229" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="277" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="295" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="331" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="277" y="33" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="295" y="33" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="313" y="33" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="33" x="331" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="277" y="51" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="295" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="51" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="277" y="69" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="295" y="69" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="313" y="69" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="33" x="331" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="33" height="15" x="277" y="87" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="87" fill="var(--cros-sys-illo-color1-1)" rx="1"/><path fill="var(--cros-sys-illo-base)" fill-rule="evenodd" d="m303.05 38.539 2.622 2.76.678-.702-3.85-3.949-3.85 3.95.679.695 2.621-2.754v5.81h1.1v-5.81ZM322.275 39.503l-.098 3.805.976-.016.069-5.514-5.514.07-.012.971 3.801-.094-4.108 4.108.778.778 4.108-4.108ZM283.503 38.725l3.805.097-.016-.975-5.514-.07.069 5.515.972.012-.094-3.801 4.108 4.108.778-.778-4.108-4.108ZM322.46 59.052l-2.76 2.621.701.679 3.949-3.85-3.949-3.85-.696.678 2.755 2.622h-5.81v1.1h5.81ZM282.54 57.948l2.76-2.621-.701-.679-3.949 3.85 3.949 3.85.696-.678-2.755-2.622h5.81v-1.1h-5.81ZM301.95 78.461l-2.621-2.76-.679.702 3.85 3.949 3.85-3.95-.678-.695-2.622 2.754v-5.81h-1.1v5.81ZM321.497 78.275l-3.805-.097.016.975 5.514.07-.069-5.515-.972-.012.094 3.801-4.108-4.108-.778.778 4.108 4.108ZM282.725 77.497l.098-3.805-.976.016-.069 5.514 5.514-.07.012-.971-3.801.094 4.108-4.109-.778-.777-4.108 4.108Z" clip-rule="evenodd"/>
      </g>
      <g id="mouse-keys-num-keypad-press-mouse-button" viewBox="0 0 352 108" fill="none">
        <rect width="352" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="31" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="40" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="58" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="76" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="94" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="112" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="130" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="148" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="166" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="220" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="31" height="15" x="238" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="40" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="49" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="67" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="85" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="103" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="121" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="139" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="157" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="175" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="193" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="211" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="40" height="15" x="229" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="277" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="295" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="331" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="277" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="295" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="33" x="331" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="277" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="295" y="51" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="313" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="277" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="295" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="33" x="331" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="33" height="15" x="277" y="87" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="87" fill="var(--cros-sys-illo-color1-1)" rx="1"/>
      </g>
      <g id="mouse-keys-num-keypad-change-mouse-button" viewBox="0 0 352 108" fill="none">
        <rect width="352" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="31" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="40" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="58" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="76" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="94" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="112" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="130" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="148" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="166" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="220" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="31" height="15" x="238" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="40" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="49" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="67" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="85" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="103" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="121" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="139" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="157" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="175" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="193" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="211" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="40" height="15" x="229" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="277" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="295" y="15" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="313" y="15" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="331" y="15" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="277" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="295" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="33" x="331" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="277" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="295" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="277" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="295" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="33" x="331" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="33" height="15" x="277" y="87" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="87" fill="var(--cros-sys-illo-color1-1)" rx="1"/>
      </g>
      <g id="mouse-keys-num-keypad-double-click" viewBox="0 0 352 108" fill="none">
        <rect width="352" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="31" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="40" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="58" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="76" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="94" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="112" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="130" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="148" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="166" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="220" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="31" height="15" x="238" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="40" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="49" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="67" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="85" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="103" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="121" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="139" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="157" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="175" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="193" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="211" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="40" height="15" x="229" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="277" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="295" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="331" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="277" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="295" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="33" x="331" y="33" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="277" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="295" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="277" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="295" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="33" x="331" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="33" height="15" x="277" y="87" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="87" fill="var(--cros-sys-illo-color1-1)" rx="1"/>
      </g>
      <g id="mouse-keys-num-keypad-hold-mouse-button" viewBox="0 0 352 108" fill="none">
        <rect width="352" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="31" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="40" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="58" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="76" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="94" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="112" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="130" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="148" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="166" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="220" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="31" height="15" x="238" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="40" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="49" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="67" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="85" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="103" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="121" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="139" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="157" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="175" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="193" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="211" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="40" height="15" x="229" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="277" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="295" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="331" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="277" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="295" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="33" x="331" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="277" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="295" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="277" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="295" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="33" x="331" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="33" height="15" x="277" y="87" fill="var(--cros-sys-illo-color1)" rx="1"/><rect width="15" height="15" x="313" y="87" fill="var(--cros-sys-illo-color1-1)" rx="1"/>
      </g>
      <g id="mouse-keys-num-keypad-release-mouse-button" viewBox="0 0 352 108" fill="none">
        <rect width="352" height="108" fill="var(--cros-sys-illo-color1-2)" rx="4"/><rect width="16" height="6" x="6" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="25" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="44" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="63" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="82" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="101" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="120" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="139" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="158" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="177" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="196" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="215" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="234" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="16" height="6" x="253" y="6" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="78" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="96" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="114" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="132" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="150" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="168" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="186" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="204" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="222" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="240" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="29" height="15" x="6" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="38" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="56" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="74" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="92" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="110" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="128" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="146" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="164" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="182" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="200" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="218" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="236" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="254" y="33" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="31" height="15" x="6" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="40" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="58" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="76" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="94" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="112" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="130" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="148" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="166" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="220" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="31" height="15" x="238" y="51" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="40" height="15" x="6" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="49" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="67" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="85" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="103" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="121" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="139" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="157" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="175" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="193" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="211" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="40" height="15" x="229" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="6" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="24" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="42" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="60" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="103" height="15" x="78" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="184" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="202" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="220" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="87" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="237" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="6" x="254" y="96" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="277" y="15" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="15" height="15" x="295" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="331" y="15" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="277" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="295" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="33" x="331" y="33" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="277" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="295" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="51" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="277" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="295" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="69" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="33" x="331" y="69" fill="var(--cros-sys-illo-base)" rx="1"/><rect width="33" height="15" x="277" y="87" fill="var(--cros-sys-illo-color1-1)" rx="1"/><rect width="15" height="15" x="313" y="87" fill="var(--cros-sys-illo-color1)" rx="1"/>
      </g>

      <!-- Privacy section -->
      <g id="smart-privacy" viewBox="0 0 246 268" fill="none">
        <path d="m175 123-19-1.662 2.841-2.276 5.327-3.062 3.996.438 4.084 3.324L175 123Z" fill="var(--cros-sys-illo-color1)"/><path d="M166.3 130.8c-.5.3-1.5.6-2.5.7-1 .1-2-.1-2.3-.4M154.6 206.2c-1.1.4-3.6-.1-3.7-1.3-.1-.9.3-1.8 1-2.4.7-.6 1.5-1 2.3-1.3 7.2-2.8 14.1-2.7 21.7-1.6" stroke="var(--cros-sys-illo-color1)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M176.1 195.3c-3.6-.4-7.1-.9-10.7-.8-3.6 0-7.3.6-10.6 2-1 .4-2 1-2.6 1.9-.6.9-.6 2.4.3 3" stroke="var(--cros-sys-illo-color1)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M152.3 197.9c-.3-.9-.2-1.9.3-2.8.6-1.1 1.5-1.7 2-2 5.3-2.9 18.6-2.1 18.6-2.1 4.5.3 8.2.5 11 .8M175.7 204.9c-8.7-1.2-19.9-2-21.2 1.4-.2.6-.2 1.4.1 2.1 1.2 2.6 6.4 1.3 14.4 2 4.3.4 3.6.8 7.9 1.3 4.8.5 10.1 1.1 15.4-.2M123.1 209.6c-8.3-8.3-11.4-22.1-7.9-35.3 3.7-14 14.5-26.9 27.2-33.3M195.952 170c1.316 3.482 2.631 7.066 4.048 10.548L183 187" stroke="var(--cros-sys-illo-color1)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M182.3 187.2c3.3 8.3 6.6 16.7 9.9 25 15.2-3 27.7-12.1 30.9-24.3 3.8-14.4-7-27-18.7-40.7-4.5-5.2-7.9-7.2-10.8-8.3-3.4-1.3-7.3-1.8-10-2.2-3-.4-5.5-.5-7.3-.6" stroke="var(--cros-sys-illo-color1)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M195.7 169.7c.1 2.3-.7 4.2-1.2 5.8-.1.4-.3 1.1-.4 1.9-.1.6 0 1.9 0 2.5 0 1.5-.6 2.4-1.4 2.4M173.4 133.4c1.1 1.9 2.3 3.8 3.4 5.8-.1.4-1.3 5.1-5.2 6.3-1.1.3-2.1.3-2.9.2" stroke="var(--cros-sys-illo-color1)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M186.1 176h-5c-2.3 0-4.2-1.9-4.2-4.2v-9.2h13.4v9.2c0 2.3-1.9 4.2-4.2 4.2Z" stroke="var(--cros-sys-illo-color1)" stroke-width="1.905" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M165.5 136c5.247 0 9.5-4.477 9.5-10s-4.253-10-9.5-10-9.5 4.477-9.5 10 4.253 10 9.5 10Z" stroke="var(--cros-sys-illo-color1)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M179.232 119.532c2.7-.4 6 1.1 8.2-.2 2.3-1.3 2.7-5 4.3-7 1.6-2.1 5-3.4 5.7-6 .7-2.5-1.6-5.3-1.9-8-.4-2.7 1.1-6-.2-8.2-1.3-2.3-5-2.7-7-4.3-2.1-1.6-3.4-5-6-5.7-2.5-.7-5.3 1.6-8 1.9-2.7.4-6-1.1-8.2.2-2.3 1.3-2.7 5-4.3 7-1.6 2.1-5 3.4-5.7 6-.7 2.5 1.6 5.3 1.9 8 .4 2.7-1.1 6 .2 8.2 1.3 2.3 5 2.7 7 4.3 2.1 1.6 3.4 5 6 5.7 2.4.7 5.2-1.6 8-1.9Z" fill="var(--cros-sys-illo-color1)"/><path d="M71.8 160.6h71.4c.7 0 1.3.6 1.3 1.2L149 210H75.1l-4.4-48.2c-.1-.6.4-1.2 1.1-1.2Z" fill="var(--cros-sys-illo-color1)" stroke="var(--cros-sys-illo-color1)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M79.4 211h82.5" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M149.4 149.6c-2.2 3.5-4.4 7-6.6 10.6M153.6 137.2c-4-4-5.8-8.4-5.4-11 .1-.9.6-2.4 1.6-3.9.7-1.1 1.2-1.3 1.6-1.4.7-.1 1.5.4 1.9 1 .9 1.4-.7 2.5-.3 4.8.3 1.8 1.5 3.1 2.9 4.5.3.3.9.9 3.1 2.5 1.6 1.1 2.6 1.5 4.5 3 2.4 2 4.6 4.5 5 7.6.5 3.2-.6 5.7-2.1 8.9-1.8 3.9-4.2 9.4-6.7 16.6" stroke="var(--cros-sys-illo-color1)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M149.3 121c-.4-.6-1.4-.8-2.1-.6-2 .6-2.3 5.1-2.3 6.1-.3 5.8 3.2 10.8 5.7 13.6" stroke="var(--cros-sys-illo-color1)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M145.4 122.8c-.5-.3-1.1-.3-1.6-.1-1.4.6-1.7 2.4-1.8 4-.1 5.6 2.2 10.7 5.7 15.2" stroke="var(--cros-sys-illo-color1)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M149.6 149.3c-4.5-4.6-8.5-11.8-9.5-18.1-.1-.9-.2-1.8 0-2.7.2-.6.6-1.1 1.1-1.5M145.2 165.7c5.6 2 11.1 4.1 16.7 6.1l-13.2 28.8" stroke="var(--cros-sys-illo-color1)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="m79.07 193.135-22.601.032c-4.601.046-8.257-3.698-8.302-8.298l-.033-22.602c-.045-4.601 3.698-8.257 8.3-8.303l22.701-.031c4.6-.045 8.257 3.698 8.302 8.299l.033 22.602c-.055 4.6-3.798 8.255-8.4 8.301Z" fill="var(--cros-sys-illo-color1-2)"/><path d="M76 150.5a8.5 8.5 0 0 0-17 0v4h-2v-4c0-5.799 4.701-10.5 10.5-10.5S78 144.701 78 150.5h-2Z" fill="var(--cros-sys-illo-color1)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M76 154v19.5a8.5 8.5 0 0 1-17 0V154h-2v19.5c0 5.799 4.701 10.5 10.5 10.5S78 179.299 78 173.5V154h-2Z" fill="var(--cros-sys-illo-base)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M69.32 167.028a3.7 3.7 0 1 0-3.134.049L65 173.1c-.3 1.1.5 2 1.6 2h2.6c1 0 1.8-1 1.5-2l-1.38-6.072Z" fill="var(--cros-sys-illo-color1)"/><path d="M66.9 213.5c24.08 0 43.6-19.52 43.6-43.6 0-24.08-19.52-43.6-43.6-43.6-24.08 0-43.6 19.52-43.6 43.6 0 24.08 19.52 43.6 43.6 43.6Z" stroke="var(--cros-sys-illo-color3)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="m87.5 122.1-.8-2.6c0-.1-.2-.3-.3-.3l-2.6-.6c-.1 0-.3 0-.4.1l-1.8 2c-.1.1-.1.3-.1.4l.8 2.6c0 .1.2.3.3.3l2.6.6c.1 0 .3 0 .4-.1l1.8-2c.1-.1.2-.2.1-.4Z" fill="var(--cros-sys-illo-color5)"/><path d="M52.148 100.506c3.5-1.4 7.4.2 8.9 3.6v.1c1.4 3.5-.2 7.4-3.6 8.9-3.5 1.4-7.4-.2-8.9-3.6v-.1c-1.5-3.5.2-7.5 3.6-8.9Z" stroke="var(--cros-sys-illo-color4)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M99.158 68.187c-.336.812-.523 1.649-.652 2.444l-.684 2.643c-.57 2.254-1.975 4.015-3.87 5.34-2.586 1.823-5.662 2.904-6.757 6.195-.832 2.619-.235 5.521 1.622 7.557.083.116.174.182.307.305 3.423 3.362 8.97 2.733 11.731-1.103.789-1.096 1.395-2.324 2.101-3.535 1.206-2.1 3.191-3.664 5.533-4.304l2.616-.748a9.622 9.622 0 0 0 2.45-.673 10.615 10.615 0 0 0 4.398-3.264c3.42-4.137 3.298-10.277-.276-14.275-4.263-4.773-11.564-4.94-16.007-.459-1.176 1.289-1.989 2.534-2.512 3.877Z" stroke="var(--cros-sys-illo-color1-1)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M98.95 99.234c1.284-7.904-4.082-15.353-11.987-16.638-7.904-1.284-15.353 4.083-16.638 11.987-1.284 7.905 4.083 15.354 11.987 16.638 7.905 1.284 15.354-4.083 16.638-11.987Z" fill="var(--cros-sys-illo-secondary)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M86.242 84.506c-.933 2.936-.275 6.196 1.807 8.502.133.168.3.313.367.372l.02.017c2.949 2.884 7.263 3.152 10.525 1.229a14.42 14.42 0 0 0-.488-2.067c-2.58 1.863-6.234 1.77-8.648-.601a6.3 6.3 0 0 0-.128-.117l-.002-.001-.061-.056-.011-.01a.996.996 0 0 0-.067-.082c-1.608-1.762-2.134-4.287-1.41-6.574a5.591 5.591 0 0 1 1.126-1.951 14.59 14.59 0 0 0-2.11-.537 7.544 7.544 0 0 0-.916 1.864l-.004.012Z" fill="var(--cros-sys-illo-base)"/><path d="M41.882 75.548c1.8-1.1 4.2-.5 5.2 1.4l4.6 7.7c1.1 1.8.5 4.2-1.4 5.2-1.8 1.1-4.2.5-5.2-1.4l-4.6-7.7c-1-1.8-.4-4.1 1.4-5.2Z" fill="var(--cros-sys-illo-secondary)"/><path d="M21.596 99.825c1.741 4.851 5.068 9.141 9.093 12.178 2.098 1.583 4.39 2.641 6.698 3.552 2.169.867 4.828 1.741 7.041 3.091" stroke="var(--cros-sys-illo-color1-2)" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
      </g>
    </defs>
  </svg>
</iron-iconset-svg>
`;
document.head.appendChild(template$8.content);

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class OpenWindowProxyImpl {
    openUrl(url) {
        window.open(url);
    }
    static getInstance() {
        return instance$z || (instance$z = new OpenWindowProxyImpl());
    }
    static setInstance(obj) {
        instance$z = obj;
    }
}
let instance$z = null;

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
let instance$y = null;
class PrivacyHubBrowserProxyImpl {
    getInitialMicrophoneHardwareToggleState() {
        return sendWithPromise$1('getInitialMicrophoneHardwareToggleState');
    }
    getInitialMicrophoneMutedBySecurityCurtainState() {
        return sendWithPromise$1('getInitialMicrophoneMutedBySecurityCurtainState');
    }
    getInitialCameraSwitchForceDisabledState() {
        return sendWithPromise$1('getInitialCameraSwitchForceDisabledState');
    }
    getInitialGeolocationAccessLevelState() {
        return sendWithPromise$1('getInitialGeolocationAccessLevelState');
    }
    getCameraLedFallbackState() {
        return sendWithPromise$1('getCameraLedFallbackState');
    }
    getCurrentTimeZoneName() {
        return sendWithPromise$1('getCurrentTimeZoneName');
    }
    getCurrentSunriseTime() {
        return sendWithPromise$1('getCurrentSunriseTime');
    }
    getCurrentSunsetTime() {
        return sendWithPromise$1('getCurrentSunsetTime');
    }
    static getInstance() {
        return instance$y || (instance$y = new PrivacyHubBrowserProxyImpl());
    }
    static setInstanceForTesting(obj) {
        instance$y = obj;
    }
}

function getTemplate$1q() {
    return html `<!--_html_template_start_--><style include="settings-shared">#geolocationModeDescriptionDiv{padding-bottom:var(--cr-section-vertical-padding);padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-padding)}#dialogTitleIcon{fill:var(--cros-sys-primary);height:32px;margin-bottom:var(--cr-section-vertical-padding);width:32px}#dialogTitle{font-size:18px}#changeAccessButton{margin-inline-start:var(--cr-icon-button-margin-start)}h2{padding-inline-start:var(--cr-section-padding)}.list-item:not(:last-of-type){border-bottom:var(--cr-separator-line)}.subsection{padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-indent-padding)}.subsection>cr-link-row{padding-inline-end:0;padding-inline-start:0}settings-dropdown-menu{--md-select-width:100%}controlled-radio-button{align-items:flex-start;padding-top:var(--cr-section-vertical-padding);padding-bottom:var(--cr-section-vertical-padding)}controlled-radio-button div{color:var(--cr-primary-text-color) !important}settings-privacy-hub-system-service-row{cursor:pointer}cr-dialog{--cr-dialog-body-padding-horizontal:32px;--cr-dialog-button-container-padding-bottom:32px;--cr-dialog-button-container-padding-horizontal:32px;--cr-dialog-title-slot-padding-end:32px;--cr-dialog-title-slot-padding-start:32px;--cr-dialog-title-slot-padding-top:32px}</style>


<div class="settings-box first">
  <div class="start settings-box-text">
    <div id="geolocationStatus" class="cr-primary-text">
      [[computeGeolocationAccessLevelText_(systemGeolocationAccessLevel_)]]
    </div>
    <div id="geolocationStatusDescription" class="cr-secondary-text">
      [[computeGeolocationAccessLevelDescriptionText_(systemGeolocationAccessLevel_)]]
    </div>
  </div>
  <template is="dom-if" if="[[isSecondaryUser_]]">
    <cr-tooltip-icon
        class="secondary-accounts-disabled-tooltip"
        icon-class="cr:group"
        tooltip-text="[[settingControlledByPrimaryUserText_()]]"
        icon-aria-label="[[settingControlledByPrimaryUserText_()]]">
    </cr-tooltip-icon>
  </template>
  <controlled-button
      id="changeAccessButton"
      class="action-button"
      label="$i18n{geolocationChangeAccessButtonText}"
      on-click="showManageGeolocationDialog_"
      disabled="[[!isGeolocationModifiable_(prefs.ash.user.geolocation_access_level.*)]]"
      pref="[[prefs.ash.user.geolocation_access_level]]">
  </controlled-button>
</div>

<div class="hr"></div>
<div id="appsSection">
  <h2 id="appsSectionTitle">$i18n{privacyHubAppsSectionTitle}</h2>
  <template is="dom-if" if="[[isGeolocationAllowedForApps_]]" restamp>
    <div class="list-frame">
      <template id="appList" is="dom-repeat" items="[[appList_]]" as="app"
          sort="alphabeticalSort_">
        <settings-privacy-hub-app-permission-row
            class="list-item"
            app="[[app]]"
            permission-type="kLocation">
        </settings-privacy-hub-app-permission-row>
      </template>
    </div>
  </template>
  <template is="dom-if" if="[[!isGeolocationAllowedForApps_]]" restamp>
    <div id="noAppHasAccessText" class="settings-box-text subsection">
      $i18n{noAppCanUseGeolocationText}
    </div>
  </template>
</div>

<div class="hr"></div>
<div id="websitesSection">
  <h2 id="websitesSectionTitle">$i18n{websitesSectionTitle}</h2>
  <div class="subsection">
    <template is="dom-if" if="[[isGeolocationAllowedForApps_]]" restamp>
      <cr-link-row
          id="managePermissionsInChromeRow"
          start-icon="os-settings:chrome"
          label="$i18n{manageLocationPermissionsInChromeText}"
          on-click="onManagePermissionsInChromeRowClick_"
          external>
      </cr-link-row>
    </template>
    <template is="dom-if" if="[[!isGeolocationAllowedForApps_]]" restamp>
      <div id="noWebsiteHasAccessText" class="settings-box-text">
        $i18n{noWebsiteCanUseLocationText}
      </div>
    </template>
  </div>
</div>

<div class="hr"></div>
<div id="systemServicesSection">
  <h2 id="systemServicesSectionTitle">
    $i18n{privacyHubSystemServicesSectionTitle}
  </h2>
  <div class="list-frame">
      <settings-privacy-hub-system-service-row
          class="list-item"
          on-click="onTimeZoneClick_"
          name="$i18n{privacyHubSystemServicesAutomaticTimeZoneName}"
          permission-state="[[automaticTimeZoneText_]]"
          icon-source="chrome://app-icon/$i18n{osSettingsAppId}/64">
      </settings-privacy-hub-system-service-row>
      <settings-privacy-hub-system-service-row
          class="list-item"
          on-click="onNightLightClick_"
          name="$i18n{privacyHubSystemServicesSunsetScheduleName}"
          permission-state="[[nightLightText_]]"
          icon-source="chrome://app-icon/$i18n{osSettingsAppId}/64">
      </settings-privacy-hub-system-service-row>
      <settings-privacy-hub-system-service-row
          class="list-item"
          on-click="onDarkThemeClick_"
          name="$i18n{privacyHubSystemServicesDarkThemeName}"
          permission-state="[[darkThemeText_]]"
          icon-source="chrome://app-icon/$i18n{osSettingsAppId}/64">
      </settings-privacy-hub-system-service-row>
      <settings-privacy-hub-system-service-row
          class="list-item"
          on-click="onLocalWeatherClick_"
          name="$i18n{privacyHubSystemServicesLocalWeatherName}"
          permission-state="[[localWeatherText_]]"
          icon-source="chrome://app-icon/$i18n{osSettingsAppId}/64">
      </settings-privacy-hub-system-service-row>
  </div>
</div>

<div class="hr"></div>
<cr-link-row
    id="geolocationAdvancedAreaLinkRow"
    on-click="onGeolocationAdvancedAreaClick_"
    deep-link-focus-id$="[[Setting.kGeolocationAdvanced]]"
    using-slotted-label>
  <div slot="label">$i18n{geolocationAdvancedAreaTitle}</div>
</cr-link-row>

<template is="dom-if" if="[[shouldShowManageGeolocationDialog_]]" restamp>
    <cr-dialog id="systemGeolocationDialog" show-on-attach>
      <div slot="title" id="dialogTitleDiv">
        <iron-icon id="dialogTitleIcon" icon="cr:location-on"></iron-icon>
        <div id="dialogTitle" class="title">$i18n{geolocationAreaTitle}</div>
      </div>
      <div slot="body">
        <settings-radio-group id="manageGeolocationRadioGroup"
              pref="{{prefs.ash.user.geolocation_access_level}}" no-set-pref>
            <controlled-radio-button
                id="systemGeolocationAccessAllowedForAll"
                name="[[geolocationAccessLevelPrefValues_.ALLOWED]]"
                pref="[[prefs.ash.user.geolocation_access_level]]">
              <div class="cr-title-text">
                $i18n{geolocationAccessLevelAllowed}
              </div>
              <localized-link class="cr-secondary-text"
                  localized-string="$i18n{geolocationDialogAllowedModeDescription}"
                  link-url="$i18n{systemGeolocationDialogLearnMoreUrl}">
              </localized-link>
            </controlled-radio-button>
            <controlled-radio-button
                id="systemGeolocationAccessOnlyAllowedForSystem"
                name="[[geolocationAccessLevelPrefValues_.ONLY_ALLOWED_FOR_SYSTEM]]"
                pref="[[prefs.ash.user.geolocation_access_level]]">
              <div class="cr-title-text">
                $i18n{geolocationAccessLevelOnlyAllowedForSystem}
              </div>
              <localized-link class="cr-secondary-text"
                  localized-string="$i18n{geolocationDialogOnlyAllowedForSystemModeDescription}"
                  link-url="$i18n{systemGeolocationDialogLearnMoreUrl}">
              </localized-link>
            </controlled-radio-button>
            <controlled-radio-button
                id="systemGeolocationAccessBlocked"
                name="[[geolocationAccessLevelPrefValues_.DISALLOWED]]"
                pref="[[prefs.ash.user.geolocation_access_level]]">
              <div class="cr-title-text">
                $i18n{geolocationAccessLevelDisallowed}
              </div>
              <localized-link class="cr-secondary-text"
                  localized-string="$i18n{geolocationDialogBlockedModeDescription}"
                  link-url="$i18n{systemGeolocationDialogLearnMoreUrl}">
              </localized-link>
            </controlled-radio-button>
          </settings-radio-group>
      </div>
      <div slot="button-container">
        <cr-button id="cancelButton"
            class="cancel-button"
            on-click="onCancelClicked_">
          $i18n{geolocationAccessLevelDialogCancelButton}
        </cr-button>
        <cr-button id="confirmButton"
            class="action-button"
            on-click="onConfirmClicked_">
          $i18n{geolocationAccessLevelDialogConfirmButton}
        </cr-button>
      </div>
    </cr-dialog>
  </div>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'settings-privacy-hub-geolocation-subpage' contains a detailed overview about
 * the state of the system geolocation access.
 */
/**
 * Geolocation access levels for the ChromeOS system.
 * This must be kept in sync with `GeolocationAccessLevel` in
 * ash/constants/geolocation_access_level.h
 */
var GeolocationAccessLevel;
(function (GeolocationAccessLevel) {
    GeolocationAccessLevel[GeolocationAccessLevel["DISALLOWED"] = 0] = "DISALLOWED";
    GeolocationAccessLevel[GeolocationAccessLevel["ALLOWED"] = 1] = "ALLOWED";
    GeolocationAccessLevel[GeolocationAccessLevel["ONLY_ALLOWED_FOR_SYSTEM"] = 2] = "ONLY_ALLOWED_FOR_SYSTEM";
    GeolocationAccessLevel[GeolocationAccessLevel["MAX_VALUE"] = 2] = "MAX_VALUE";
})(GeolocationAccessLevel || (GeolocationAccessLevel = {}));
var ScheduleType;
(function (ScheduleType) {
    ScheduleType[ScheduleType["NONE"] = 0] = "NONE";
    ScheduleType[ScheduleType["SUNSET_TO_SUNRISE"] = 1] = "SUNSET_TO_SUNRISE";
    ScheduleType[ScheduleType["CUSTOM"] = 2] = "CUSTOM";
})(ScheduleType || (ScheduleType = {}));
/**
 * Whether the app has location permission defined.
 */
function hasLocationPermission(app) {
    return app.permissions[PermissionType.kLocation] !== undefined;
}
const SettingsPrivacyHubGeolocationSubpageBase = RouteObserverMixin(DeepLinkingMixin(WebUiListenerMixin(PrefsMixin(I18nMixin(PolymerElement)))));
class SettingsPrivacyHubGeolocationSubpage extends SettingsPrivacyHubGeolocationSubpageBase {
    static get is() {
        return 'settings-privacy-hub-geolocation-subpage';
    }
    static get template() {
        return getTemplate$1q();
    }
    static get properties() {
        return {
            geolocationAccessLevelPrefValues_: {
                readOnly: true,
                type: Object,
                value: {
                    DISALLOWED: GeolocationAccessLevel.DISALLOWED,
                    ALLOWED: GeolocationAccessLevel.ALLOWED,
                    ONLY_ALLOWED_FOR_SYSTEM: GeolocationAccessLevel.ONLY_ALLOWED_FOR_SYSTEM,
                },
            },
            /**
             * Apps with location permission defined.
             */
            appList_: {
                type: Array,
                value: [],
            },
            automaticTimeZoneText_: {
                type: String,
                computed: 'computeAutomaticTimeZoneText_(' +
                    'systemGeolocationAccessLevel_,' +
                    'prefs.generated.resolve_timezone_by_geolocation_on_off.value,' +
                    'currentTimeZoneName_)',
            },
            isSecondaryUser_: {
                type: Boolean,
                value() {
                    return isSecondaryUser();
                },
                readOnly: true,
            },
            systemGeolocationAccessLevel_: {
                type: Number,
                value: GeolocationAccessLevel.DISALLOWED,
            },
            isGeolocationAllowedForApps_: {
                type: Boolean,
                computed: 'computedIsGeolocationAllowedForApps_(' +
                    'systemGeolocationAccessLevel_)',
            },
            currentTimeZoneName_: {
                type: String,
                notify: true,
            },
            currentSunRiseTime_: {
                type: String,
                notify: true,
            },
            currentSunSetTime_: {
                type: String,
                notify: true,
            },
            nightLightText_: {
                type: String,
                computed: 'computeNightLightText_(' +
                    'systemGeolocationAccessLevel_,' +
                    `prefs.ash.night_light.schedule_type.value,` +
                    'currentSunRiseTime_, currentSunSetTime_)',
            },
            darkThemeText_: {
                type: String,
                computed: 'computeDarkThemeText_(' +
                    'systemGeolocationAccessLevel_,' +
                    `prefs.ash.dark_mode.schedule_type.value,` +
                    'currentSunRiseTime_, currentSunSetTime_)',
            },
            localWeatherText_: {
                type: String,
                computed: 'computeLocalWeatherText_(' +
                    'systemGeolocationAccessLevel_,' +
                    'prefs.settings.ambient_mode.enabled.value)',
            },
        };
    }
    static get observers() {
        return [
            'onTimeZoneChanged_(prefs.cros.system.timezone.value)',
        ];
    }
    currentRouteChanged(route) {
        // Does not apply to this page.
        if (route !== routes.PRIVACY_HUB_GEOLOCATION_ADVANCED) {
            return;
        }
        this.attemptDeepLink();
    }
    constructor() {
        super();
        /**
         * Used by DeepLinkingMixin to focus this page's deep links.
         */
        this.supportedSettingIds = new Set([
            Setting.kGeolocationAdvanced,
        ]);
        this.mojoInterfaceProvider_ = getAppPermissionProvider();
        this.appPermissionsObserverReceiver_ = null;
        this.browserProxy_ = PrivacyHubBrowserProxyImpl.getInstance();
        // Assigning the initial time zone name.
        this.currentTimeZoneName_ = this.i18n('timeZoneName');
        this.currentSunRiseTime_ =
            this.i18n('privacyHubSystemServicesInitSunRiseTime');
        this.currentSunSetTime_ =
            this.i18n('privacyHubSystemServicesInitSunSetTime');
    }
    ready() {
        super.ready();
        this.addWebUiListener('system-geolocation-access-level-changed', (accessLevel) => {
            this.systemGeolocationAccessLevel_ = accessLevel;
        });
        this.browserProxy_.getInitialGeolocationAccessLevelState().then((accessLevel) => {
            this.systemGeolocationAccessLevel_ = accessLevel;
        });
    }
    connectedCallback() {
        super.connectedCallback();
        this.appPermissionsObserverReceiver_ =
            new AppPermissionsObserverReceiver(this);
        this.mojoInterfaceProvider_.addObserver(this.appPermissionsObserverReceiver_.$.bindNewPipeAndPassRemote());
        this.updateAppList_();
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        this.appPermissionsObserverReceiver_.$.close();
    }
    isGeolocationPrefEnforced_() {
        return this.getPref('ash.user.geolocation_access_level').enforcement ===
            chrome.settingsPrivate.Enforcement.ENFORCED;
    }
    isGeolocationModifiable_() {
        if (isSecondaryUser() || this.isGeolocationPrefEnforced_()) {
            return false;
        }
        return true;
    }
    showManageGeolocationDialog_() {
        if (this.isGeolocationModifiable_()) {
            this.shouldShowManageGeolocationDialog_ = true;
        }
    }
    onCancelClicked_() {
        const radioGroup = this.shadowRoot.querySelector('#manageGeolocationRadioGroup');
        radioGroup.resetToPrefValue();
        this.shouldShowManageGeolocationDialog_ = false;
    }
    onConfirmClicked_() {
        // Reflect user choice to the underlying pref.
        const radioGroup = this.shadowRoot.querySelector('#manageGeolocationRadioGroup');
        radioGroup.sendPrefChange();
        // Record metrics.
        this.recordMetric_();
        // Dismiss the dialog.
        this.shouldShowManageGeolocationDialog_ = false;
    }
    settingControlledByPrimaryUserText_() {
        return this.i18n('geolocationControlledByPrimaryUserText', loadTimeData.getString('primaryUserEmail'));
    }
    /**
     * The function is used for sorting app names alphabetically.
     */
    alphabeticalSort_(first, second) {
        return first.name.localeCompare(second.name);
    }
    async updateAppList_() {
        const apps = (await this.mojoInterfaceProvider_.getApps()).apps;
        this.appList_ = apps.filter(hasLocationPermission);
    }
    isLocationPermissionEnabled_(app) {
        const permission = castExists$2(app.permissions[PermissionType.kLocation]);
        return isPermissionEnabled(permission.value);
    }
    /** Implements AppPermissionsObserver.OnAppUpdated */
    onAppUpdated(updatedApp) {
        if (!hasLocationPermission(updatedApp)) {
            return;
        }
        const idx = this.appList_.findIndex(app => app.id === updatedApp.id);
        if (idx === -1) {
            // New app installed.
            this.push('appList_', updatedApp);
        }
        else {
            // An already installed app is updated.
            this.splice('appList_', idx, 1, updatedApp);
        }
    }
    /** Implements AppPermissionsObserver.OnAppRemoved */
    onAppRemoved(appId) {
        const idx = this.appList_.findIndex(app => app.id === appId);
        if (idx !== -1) {
            this.splice('appList_', idx, 1);
        }
    }
    computedIsGeolocationAllowedForApps_() {
        const accessLevel = this.systemGeolocationAccessLevel_;
        switch (accessLevel) {
            case GeolocationAccessLevel.ALLOWED:
                return true;
            case GeolocationAccessLevel.DISALLOWED:
            case GeolocationAccessLevel.ONLY_ALLOWED_FOR_SYSTEM:
                return false;
            default:
                assertExhaustive(accessLevel);
        }
    }
    isAutomaticTimeZoneConfigured_() {
        return this.getPref('generated.resolve_timezone_by_geolocation_on_off')
            .value;
    }
    computeAutomaticTimeZoneText_() {
        if (!this.prefs) {
            return '';
        }
        if (!this.isAutomaticTimeZoneConfigured_()) {
            return this.i18n('privacyHubSystemServicesGeolocationNotConfigured');
        }
        return this.geolocationAllowedForSystem_() ?
            this.i18n('privacyHubSystemServicesAllowedText') :
            this.i18n('privacyHubSystemServicesAutomaticTimeZoneBlockedText', this.currentTimeZoneName_);
    }
    isNightLightConfiguredToUseGeolocation_() {
        return this.getPref('ash.night_light.schedule_type').value ===
            ScheduleType.SUNSET_TO_SUNRISE;
    }
    computeNightLightText_() {
        if (!this.prefs) {
            return '';
        }
        if (!this.isNightLightConfiguredToUseGeolocation_()) {
            return this.i18n('privacyHubSystemServicesGeolocationNotConfigured');
        }
        return this.geolocationAllowedForSystem_() ?
            this.i18n('privacyHubSystemServicesAllowedText') :
            this.i18n('privacyHubSystemServicesSunsetScheduleBlockedText', this.currentSunRiseTime_, this.currentSunSetTime_);
    }
    onManagePermissionsInChromeRowClick_() {
        this.mojoInterfaceProvider_.openBrowserPermissionSettings(PermissionType.kLocation);
    }
    computeGeolocationAccessLevelText_() {
        const accessLevel = this.systemGeolocationAccessLevel_;
        switch (accessLevel) {
            case GeolocationAccessLevel.ALLOWED:
                return this.i18nAdvanced('geolocationAccessLevelAllowed');
            case GeolocationAccessLevel.ONLY_ALLOWED_FOR_SYSTEM:
                return this.i18nAdvanced('geolocationAccessLevelOnlyAllowedForSystem');
            case GeolocationAccessLevel.DISALLOWED:
                return this.i18nAdvanced('geolocationAccessLevelDisallowed');
            default:
                assertExhaustive(accessLevel);
        }
    }
    computeGeolocationAccessLevelDescriptionText_() {
        const accessLevel = this.systemGeolocationAccessLevel_;
        switch (accessLevel) {
            case GeolocationAccessLevel.ALLOWED:
                return this.i18nAdvanced('geolocationAllowedModeDescription');
            case GeolocationAccessLevel.ONLY_ALLOWED_FOR_SYSTEM:
                return this.i18nAdvanced('geolocationOnlyAllowedForSystemModeDescription');
            case GeolocationAccessLevel.DISALLOWED:
                return this.i18nAdvanced('geolocationBlockedModeDescription');
            default:
                assertExhaustive(accessLevel);
        }
    }
    recordMetric_() {
        const accessLevel = this.getPref('ash.user.geolocation_access_level')
            .value;
        chrome.metricsPrivate.recordEnumerationValue(LOCATION_PERMISSION_CHANGE_FROM_SETTINGS_HISTOGRAM_NAME, accessLevel, GeolocationAccessLevel.MAX_VALUE + 1);
    }
    geolocationAllowedForSystem_() {
        return this.systemGeolocationAccessLevel_ !==
            GeolocationAccessLevel.DISALLOWED;
    }
    isLocalWeatherConfiguredToUseGeolocation_() {
        return this.getPref('settings.ambient_mode.enabled').value;
    }
    computeLocalWeatherText_() {
        if (!this.prefs) {
            return '';
        }
        if (!this.isLocalWeatherConfiguredToUseGeolocation_()) {
            return this.i18n('privacyHubSystemServicesGeolocationNotConfigured');
        }
        return this.geolocationAllowedForSystem_() ?
            this.i18n('privacyHubSystemServicesAllowedText') :
            this.i18n('privacyHubSystemServicesBlockedText');
    }
    isDarkThemeConfiguredToUseGeolocation_() {
        return this.getPref('ash.dark_mode.schedule_type').value ===
            ScheduleType.SUNSET_TO_SUNRISE;
    }
    computeDarkThemeText_() {
        if (!this.prefs) {
            return '';
        }
        if (!this.isDarkThemeConfiguredToUseGeolocation_()) {
            return this.i18n('privacyHubSystemServicesGeolocationNotConfigured');
        }
        return this.geolocationAllowedForSystem_() ?
            this.i18n('privacyHubSystemServicesAllowedText') :
            this.i18n('privacyHubSystemServicesSunsetScheduleBlockedText', this.currentSunRiseTime_, this.currentSunSetTime_);
    }
    onTimeZoneChanged_() {
        this.browserProxy_.getCurrentTimeZoneName().then((timeZoneName) => {
            this.currentTimeZoneName_ = timeZoneName;
        });
        this.browserProxy_.getCurrentSunriseTime().then((time) => {
            this.currentSunRiseTime_ = time;
        });
        this.browserProxy_.getCurrentSunsetTime().then((time) => {
            this.currentSunSetTime_ = time;
        });
    }
    onTimeZoneClick_() {
        Router.getInstance().navigateTo(routes.DATETIME_TIMEZONE_SUBPAGE);
    }
    onNightLightClick_() {
        Router.getInstance().navigateTo(routes.DISPLAY);
    }
    onDarkThemeClick_() {
        OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString('personalizationAppUrl'));
    }
    onLocalWeatherClick_() {
        OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString('personalizationAppUrl') +
            loadTimeData.getString('ambientSubpageRelativeUrl'));
    }
    onGeolocationAdvancedAreaClick_() {
        Router.getInstance().navigateTo(routes.PRIVACY_HUB_GEOLOCATION_ADVANCED);
    }
}
customElements.define(SettingsPrivacyHubGeolocationSubpage.is, SettingsPrivacyHubGeolocationSubpage);

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Queries |selector| on |root| and returns the first matching element. Throws
 * exception if there is no resulting element or if element is not of type
 * |type|.
 */
function strictQuery(selector, root, type) {
    const element = root.querySelector(selector);
    assert$1(element, 'Queried element is not defined.');
    assert$1(element instanceof type, 'Queried element is not an instance of type T.');
    return element;
}

// chromeos/ash/components/audio/public/mojom/cros_audio_config.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const AudioDeviceTypeSpec = { $: mojo.internal.Enum() };
var AudioDeviceType;
(function (AudioDeviceType) {
    AudioDeviceType[AudioDeviceType["MIN_VALUE"] = 0] = "MIN_VALUE";
    AudioDeviceType[AudioDeviceType["MAX_VALUE"] = 16] = "MAX_VALUE";
    AudioDeviceType[AudioDeviceType["kHeadphone"] = 0] = "kHeadphone";
    AudioDeviceType[AudioDeviceType["kMic"] = 1] = "kMic";
    AudioDeviceType[AudioDeviceType["kUsb"] = 2] = "kUsb";
    AudioDeviceType[AudioDeviceType["kBluetooth"] = 3] = "kBluetooth";
    AudioDeviceType[AudioDeviceType["kBluetoothNbMic"] = 4] = "kBluetoothNbMic";
    AudioDeviceType[AudioDeviceType["kHdmi"] = 5] = "kHdmi";
    AudioDeviceType[AudioDeviceType["kInternalSpeaker"] = 6] = "kInternalSpeaker";
    AudioDeviceType[AudioDeviceType["kInternalMic"] = 7] = "kInternalMic";
    AudioDeviceType[AudioDeviceType["kFrontMic"] = 8] = "kFrontMic";
    AudioDeviceType[AudioDeviceType["kRearMic"] = 9] = "kRearMic";
    AudioDeviceType[AudioDeviceType["kKeyboardMic"] = 10] = "kKeyboardMic";
    AudioDeviceType[AudioDeviceType["kHotword"] = 11] = "kHotword";
    AudioDeviceType[AudioDeviceType["kPostDspLoopback"] = 12] = "kPostDspLoopback";
    AudioDeviceType[AudioDeviceType["kPostMixLoopback"] = 13] = "kPostMixLoopback";
    AudioDeviceType[AudioDeviceType["kLineout"] = 14] = "kLineout";
    AudioDeviceType[AudioDeviceType["kAlsaLoopback"] = 15] = "kAlsaLoopback";
    AudioDeviceType[AudioDeviceType["kOther"] = 16] = "kOther";
})(AudioDeviceType || (AudioDeviceType = {}));
const AudioEffectStateSpec = { $: mojo.internal.Enum() };
var AudioEffectState;
(function (AudioEffectState) {
    AudioEffectState[AudioEffectState["MIN_VALUE"] = 0] = "MIN_VALUE";
    AudioEffectState[AudioEffectState["MAX_VALUE"] = 2] = "MAX_VALUE";
    AudioEffectState[AudioEffectState["kNotSupported"] = 0] = "kNotSupported";
    AudioEffectState[AudioEffectState["kNotEnabled"] = 1] = "kNotEnabled";
    AudioEffectState[AudioEffectState["kEnabled"] = 2] = "kEnabled";
})(AudioEffectState || (AudioEffectState = {}));
const MuteStateSpec = { $: mojo.internal.Enum() };
var MuteState;
(function (MuteState) {
    MuteState[MuteState["MIN_VALUE"] = 0] = "MIN_VALUE";
    MuteState[MuteState["MAX_VALUE"] = 3] = "MAX_VALUE";
    MuteState[MuteState["kNotMuted"] = 0] = "kNotMuted";
    MuteState[MuteState["kMutedByUser"] = 1] = "kMutedByUser";
    MuteState[MuteState["kMutedByPolicy"] = 2] = "kMutedByPolicy";
    MuteState[MuteState["kMutedExternally"] = 3] = "kMutedExternally";
})(MuteState || (MuteState = {}));
const AudioEffectTypeSpec = { $: mojo.internal.Enum() };
var AudioEffectType;
(function (AudioEffectType) {
    AudioEffectType[AudioEffectType["MIN_VALUE"] = 0] = "MIN_VALUE";
    AudioEffectType[AudioEffectType["MAX_VALUE"] = 8] = "MAX_VALUE";
    AudioEffectType[AudioEffectType["kNone"] = 0] = "kNone";
    AudioEffectType[AudioEffectType["kNoiseCancellation"] = 1] = "kNoiseCancellation";
    AudioEffectType[AudioEffectType["kHfpMicSr"] = 2] = "kHfpMicSr";
    AudioEffectType[AudioEffectType["kStyleTransfer"] = 4] = "kStyleTransfer";
    AudioEffectType[AudioEffectType["kBeamforming"] = 8] = "kBeamforming";
})(AudioEffectType || (AudioEffectType = {}));
class AudioSystemPropertiesObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.audio_config.mojom.AudioSystemPropertiesObserver', scope);
    }
}
class AudioSystemPropertiesObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(AudioSystemPropertiesObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onPropertiesUpdated(properties) {
        this.proxy.sendMessage(0, AudioSystemPropertiesObserver_OnPropertiesUpdated_ParamsSpec.$, null, [
            properties
        ], false);
    }
}
/**
 * An object which receives request messages for the AudioSystemPropertiesObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
class AudioSystemPropertiesObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AudioSystemPropertiesObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, AudioSystemPropertiesObserver_OnPropertiesUpdated_ParamsSpec.$, null, impl.onPropertiesUpdated.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
class AudioSystemPropertiesObserver {
    static get $interfaceName() {
        return "ash.audio_config.mojom.AudioSystemPropertiesObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new AudioSystemPropertiesObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the AudioSystemPropertiesObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
class AudioSystemPropertiesObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AudioSystemPropertiesObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onPropertiesUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, AudioSystemPropertiesObserver_OnPropertiesUpdated_ParamsSpec.$, null, this.onPropertiesUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
class CrosAudioConfigPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.audio_config.mojom.CrosAudioConfig', scope);
    }
}
class CrosAudioConfigRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(CrosAudioConfigPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    observeAudioSystemProperties(observer) {
        this.proxy.sendMessage(0, CrosAudioConfig_ObserveAudioSystemProperties_ParamsSpec.$, null, [
            observer
        ], false);
    }
    setOutputMuted(muted) {
        this.proxy.sendMessage(1, CrosAudioConfig_SetOutputMuted_ParamsSpec.$, null, [
            muted
        ], false);
    }
    setOutputVolumePercent(volume) {
        this.proxy.sendMessage(2, CrosAudioConfig_SetOutputVolumePercent_ParamsSpec.$, null, [
            volume
        ], false);
    }
    setInputGainPercent(gain) {
        this.proxy.sendMessage(3, CrosAudioConfig_SetInputGainPercent_ParamsSpec.$, null, [
            gain
        ], false);
    }
    setActiveDevice(device) {
        this.proxy.sendMessage(4, CrosAudioConfig_SetActiveDevice_ParamsSpec.$, null, [
            device
        ], false);
    }
    setInputMuted(muted) {
        this.proxy.sendMessage(5, CrosAudioConfig_SetInputMuted_ParamsSpec.$, null, [
            muted
        ], false);
    }
    recordVoiceIsolationEnabledChange() {
        this.proxy.sendMessage(6, CrosAudioConfig_RecordVoiceIsolationEnabledChange_ParamsSpec.$, null, [], false);
    }
    recordVoiceIsolationPreferredEffectChange(preferredEffect) {
        this.proxy.sendMessage(7, CrosAudioConfig_RecordVoiceIsolationPreferredEffectChange_ParamsSpec.$, null, [
            preferredEffect
        ], false);
    }
    setNoiseCancellationEnabled(enabled) {
        this.proxy.sendMessage(8, CrosAudioConfig_SetNoiseCancellationEnabled_ParamsSpec.$, null, [
            enabled
        ], false);
    }
    setStyleTransferEnabled(enabled) {
        this.proxy.sendMessage(9, CrosAudioConfig_SetStyleTransferEnabled_ParamsSpec.$, null, [
            enabled
        ], false);
    }
    setForceRespectUiGainsEnabled(enabled) {
        this.proxy.sendMessage(10, CrosAudioConfig_SetForceRespectUiGainsEnabled_ParamsSpec.$, null, [
            enabled
        ], false);
    }
    setHfpMicSrEnabled(enabled) {
        this.proxy.sendMessage(11, CrosAudioConfig_SetHfpMicSrEnabled_ParamsSpec.$, null, [
            enabled
        ], false);
    }
    setSpatialAudioEnabled(enabled) {
        this.proxy.sendMessage(12, CrosAudioConfig_SetSpatialAudioEnabled_ParamsSpec.$, null, [
            enabled
        ], false);
    }
}
/**
 * An object which receives request messages for the CrosAudioConfig
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
class CrosAudioConfigReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CrosAudioConfigRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, CrosAudioConfig_ObserveAudioSystemProperties_ParamsSpec.$, null, impl.observeAudioSystemProperties.bind(impl), false);
        this.helper_internal_.registerHandler(1, CrosAudioConfig_SetOutputMuted_ParamsSpec.$, null, impl.setOutputMuted.bind(impl), false);
        this.helper_internal_.registerHandler(2, CrosAudioConfig_SetOutputVolumePercent_ParamsSpec.$, null, impl.setOutputVolumePercent.bind(impl), false);
        this.helper_internal_.registerHandler(3, CrosAudioConfig_SetInputGainPercent_ParamsSpec.$, null, impl.setInputGainPercent.bind(impl), false);
        this.helper_internal_.registerHandler(4, CrosAudioConfig_SetActiveDevice_ParamsSpec.$, null, impl.setActiveDevice.bind(impl), false);
        this.helper_internal_.registerHandler(5, CrosAudioConfig_SetInputMuted_ParamsSpec.$, null, impl.setInputMuted.bind(impl), false);
        this.helper_internal_.registerHandler(6, CrosAudioConfig_RecordVoiceIsolationEnabledChange_ParamsSpec.$, null, impl.recordVoiceIsolationEnabledChange.bind(impl), false);
        this.helper_internal_.registerHandler(7, CrosAudioConfig_RecordVoiceIsolationPreferredEffectChange_ParamsSpec.$, null, impl.recordVoiceIsolationPreferredEffectChange.bind(impl), false);
        this.helper_internal_.registerHandler(8, CrosAudioConfig_SetNoiseCancellationEnabled_ParamsSpec.$, null, impl.setNoiseCancellationEnabled.bind(impl), false);
        this.helper_internal_.registerHandler(9, CrosAudioConfig_SetStyleTransferEnabled_ParamsSpec.$, null, impl.setStyleTransferEnabled.bind(impl), false);
        this.helper_internal_.registerHandler(10, CrosAudioConfig_SetForceRespectUiGainsEnabled_ParamsSpec.$, null, impl.setForceRespectUiGainsEnabled.bind(impl), false);
        this.helper_internal_.registerHandler(11, CrosAudioConfig_SetHfpMicSrEnabled_ParamsSpec.$, null, impl.setHfpMicSrEnabled.bind(impl), false);
        this.helper_internal_.registerHandler(12, CrosAudioConfig_SetSpatialAudioEnabled_ParamsSpec.$, null, impl.setSpatialAudioEnabled.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
class CrosAudioConfig {
    static get $interfaceName() {
        return "ash.audio_config.mojom.CrosAudioConfig";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new CrosAudioConfigRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the CrosAudioConfig
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
class CrosAudioConfigCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CrosAudioConfigRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.observeAudioSystemProperties =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, CrosAudioConfig_ObserveAudioSystemProperties_ParamsSpec.$, null, this.observeAudioSystemProperties.createReceiverHandler(false /* expectsResponse */), false);
        this.setOutputMuted =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, CrosAudioConfig_SetOutputMuted_ParamsSpec.$, null, this.setOutputMuted.createReceiverHandler(false /* expectsResponse */), false);
        this.setOutputVolumePercent =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, CrosAudioConfig_SetOutputVolumePercent_ParamsSpec.$, null, this.setOutputVolumePercent.createReceiverHandler(false /* expectsResponse */), false);
        this.setInputGainPercent =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, CrosAudioConfig_SetInputGainPercent_ParamsSpec.$, null, this.setInputGainPercent.createReceiverHandler(false /* expectsResponse */), false);
        this.setActiveDevice =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, CrosAudioConfig_SetActiveDevice_ParamsSpec.$, null, this.setActiveDevice.createReceiverHandler(false /* expectsResponse */), false);
        this.setInputMuted =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, CrosAudioConfig_SetInputMuted_ParamsSpec.$, null, this.setInputMuted.createReceiverHandler(false /* expectsResponse */), false);
        this.recordVoiceIsolationEnabledChange =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, CrosAudioConfig_RecordVoiceIsolationEnabledChange_ParamsSpec.$, null, this.recordVoiceIsolationEnabledChange.createReceiverHandler(false /* expectsResponse */), false);
        this.recordVoiceIsolationPreferredEffectChange =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, CrosAudioConfig_RecordVoiceIsolationPreferredEffectChange_ParamsSpec.$, null, this.recordVoiceIsolationPreferredEffectChange.createReceiverHandler(false /* expectsResponse */), false);
        this.setNoiseCancellationEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, CrosAudioConfig_SetNoiseCancellationEnabled_ParamsSpec.$, null, this.setNoiseCancellationEnabled.createReceiverHandler(false /* expectsResponse */), false);
        this.setStyleTransferEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, CrosAudioConfig_SetStyleTransferEnabled_ParamsSpec.$, null, this.setStyleTransferEnabled.createReceiverHandler(false /* expectsResponse */), false);
        this.setForceRespectUiGainsEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, CrosAudioConfig_SetForceRespectUiGainsEnabled_ParamsSpec.$, null, this.setForceRespectUiGainsEnabled.createReceiverHandler(false /* expectsResponse */), false);
        this.setHfpMicSrEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, CrosAudioConfig_SetHfpMicSrEnabled_ParamsSpec.$, null, this.setHfpMicSrEnabled.createReceiverHandler(false /* expectsResponse */), false);
        this.setSpatialAudioEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(12, CrosAudioConfig_SetSpatialAudioEnabled_ParamsSpec.$, null, this.setSpatialAudioEnabled.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
const VoiceIsolationUIAppearanceSpec = { $: {} };
const AudioDeviceSpec = { $: {} };
const AudioSystemPropertiesSpec = { $: {} };
const AudioSystemPropertiesObserver_OnPropertiesUpdated_ParamsSpec = { $: {} };
const CrosAudioConfig_ObserveAudioSystemProperties_ParamsSpec = { $: {} };
const CrosAudioConfig_SetOutputMuted_ParamsSpec = { $: {} };
const CrosAudioConfig_SetOutputVolumePercent_ParamsSpec = { $: {} };
const CrosAudioConfig_SetInputGainPercent_ParamsSpec = { $: {} };
const CrosAudioConfig_SetActiveDevice_ParamsSpec = { $: {} };
const CrosAudioConfig_SetInputMuted_ParamsSpec = { $: {} };
const CrosAudioConfig_RecordVoiceIsolationEnabledChange_ParamsSpec = { $: {} };
const CrosAudioConfig_RecordVoiceIsolationPreferredEffectChange_ParamsSpec = { $: {} };
const CrosAudioConfig_SetNoiseCancellationEnabled_ParamsSpec = { $: {} };
const CrosAudioConfig_SetStyleTransferEnabled_ParamsSpec = { $: {} };
const CrosAudioConfig_SetForceRespectUiGainsEnabled_ParamsSpec = { $: {} };
const CrosAudioConfig_SetHfpMicSrEnabled_ParamsSpec = { $: {} };
const CrosAudioConfig_SetSpatialAudioEnabled_ParamsSpec = { $: {} };
mojo.internal.Struct(VoiceIsolationUIAppearanceSpec.$, 'VoiceIsolationUIAppearance', [
    mojo.internal.StructField('toggleType', 0, 0, AudioEffectTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('effectModeOptions', 4, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('showEffectFallbackMessage', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(AudioDeviceSpec.$, 'AudioDevice', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('displayName', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isActive', 16, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('deviceType', 20, 0, AudioDeviceTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('noiseCancellationState', 24, 0, AudioEffectStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('styleTransferState', 28, 0, AudioEffectStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('forceRespectUiGainsState', 32, 0, AudioEffectStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hfpMicSrState', 36, 0, AudioEffectStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('spatialAudioState', 40, 0, AudioEffectStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 56],]);
mojo.internal.Struct(AudioSystemPropertiesSpec.$, 'AudioSystemProperties', [
    mojo.internal.StructField('outputDevices', 0, 0, mojo.internal.Array(AudioDeviceSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('outputVolumePercent', 8, 0, mojo.internal.Uint8, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('inputGainPercent', 9, 0, mojo.internal.Uint8, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('outputMuteState', 12, 0, MuteStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('inputDevices', 16, 0, mojo.internal.Array(AudioDeviceSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('inputMuteState', 24, 0, MuteStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('voiceIsolationUiAppearance', 32, 0, VoiceIsolationUIAppearanceSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 48],]);
mojo.internal.Struct(AudioSystemPropertiesObserver_OnPropertiesUpdated_ParamsSpec.$, 'AudioSystemPropertiesObserver_OnPropertiesUpdated_Params', [
    mojo.internal.StructField('properties', 0, 0, AudioSystemPropertiesSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosAudioConfig_ObserveAudioSystemProperties_ParamsSpec.$, 'CrosAudioConfig_ObserveAudioSystemProperties_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(AudioSystemPropertiesObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosAudioConfig_SetOutputMuted_ParamsSpec.$, 'CrosAudioConfig_SetOutputMuted_Params', [
    mojo.internal.StructField('muted', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosAudioConfig_SetOutputVolumePercent_ParamsSpec.$, 'CrosAudioConfig_SetOutputVolumePercent_Params', [
    mojo.internal.StructField('volume', 0, 0, mojo.internal.Int8, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosAudioConfig_SetInputGainPercent_ParamsSpec.$, 'CrosAudioConfig_SetInputGainPercent_Params', [
    mojo.internal.StructField('gain', 0, 0, mojo.internal.Uint8, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosAudioConfig_SetActiveDevice_ParamsSpec.$, 'CrosAudioConfig_SetActiveDevice_Params', [
    mojo.internal.StructField('device', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosAudioConfig_SetInputMuted_ParamsSpec.$, 'CrosAudioConfig_SetInputMuted_Params', [
    mojo.internal.StructField('muted', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosAudioConfig_RecordVoiceIsolationEnabledChange_ParamsSpec.$, 'CrosAudioConfig_RecordVoiceIsolationEnabledChange_Params', [], [[0, 8],]);
mojo.internal.Struct(CrosAudioConfig_RecordVoiceIsolationPreferredEffectChange_ParamsSpec.$, 'CrosAudioConfig_RecordVoiceIsolationPreferredEffectChange_Params', [
    mojo.internal.StructField('preferredEffect', 0, 0, AudioEffectTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosAudioConfig_SetNoiseCancellationEnabled_ParamsSpec.$, 'CrosAudioConfig_SetNoiseCancellationEnabled_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosAudioConfig_SetStyleTransferEnabled_ParamsSpec.$, 'CrosAudioConfig_SetStyleTransferEnabled_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosAudioConfig_SetForceRespectUiGainsEnabled_ParamsSpec.$, 'CrosAudioConfig_SetForceRespectUiGainsEnabled_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosAudioConfig_SetHfpMicSrEnabled_ParamsSpec.$, 'CrosAudioConfig_SetHfpMicSrEnabled_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosAudioConfig_SetSpatialAudioEnabled_ParamsSpec.$, 'CrosAudioConfig_SetSpatialAudioEnabled_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);

var cros_audio_config_mojomWebui = /*#__PURE__*/Object.freeze({
  __proto__: null,
  AudioDeviceSpec: AudioDeviceSpec,
  get AudioDeviceType () { return AudioDeviceType; },
  AudioDeviceTypeSpec: AudioDeviceTypeSpec,
  get AudioEffectState () { return AudioEffectState; },
  AudioEffectStateSpec: AudioEffectStateSpec,
  get AudioEffectType () { return AudioEffectType; },
  AudioEffectTypeSpec: AudioEffectTypeSpec,
  AudioSystemPropertiesObserver: AudioSystemPropertiesObserver,
  AudioSystemPropertiesObserverCallbackRouter: AudioSystemPropertiesObserverCallbackRouter,
  AudioSystemPropertiesObserverPendingReceiver: AudioSystemPropertiesObserverPendingReceiver,
  AudioSystemPropertiesObserverReceiver: AudioSystemPropertiesObserverReceiver,
  AudioSystemPropertiesObserverRemote: AudioSystemPropertiesObserverRemote,
  AudioSystemPropertiesObserver_OnPropertiesUpdated_ParamsSpec: AudioSystemPropertiesObserver_OnPropertiesUpdated_ParamsSpec,
  AudioSystemPropertiesSpec: AudioSystemPropertiesSpec,
  CrosAudioConfig: CrosAudioConfig,
  CrosAudioConfigCallbackRouter: CrosAudioConfigCallbackRouter,
  CrosAudioConfigPendingReceiver: CrosAudioConfigPendingReceiver,
  CrosAudioConfigReceiver: CrosAudioConfigReceiver,
  CrosAudioConfigRemote: CrosAudioConfigRemote,
  CrosAudioConfig_ObserveAudioSystemProperties_ParamsSpec: CrosAudioConfig_ObserveAudioSystemProperties_ParamsSpec,
  CrosAudioConfig_RecordVoiceIsolationEnabledChange_ParamsSpec: CrosAudioConfig_RecordVoiceIsolationEnabledChange_ParamsSpec,
  CrosAudioConfig_RecordVoiceIsolationPreferredEffectChange_ParamsSpec: CrosAudioConfig_RecordVoiceIsolationPreferredEffectChange_ParamsSpec,
  CrosAudioConfig_SetActiveDevice_ParamsSpec: CrosAudioConfig_SetActiveDevice_ParamsSpec,
  CrosAudioConfig_SetForceRespectUiGainsEnabled_ParamsSpec: CrosAudioConfig_SetForceRespectUiGainsEnabled_ParamsSpec,
  CrosAudioConfig_SetHfpMicSrEnabled_ParamsSpec: CrosAudioConfig_SetHfpMicSrEnabled_ParamsSpec,
  CrosAudioConfig_SetInputGainPercent_ParamsSpec: CrosAudioConfig_SetInputGainPercent_ParamsSpec,
  CrosAudioConfig_SetInputMuted_ParamsSpec: CrosAudioConfig_SetInputMuted_ParamsSpec,
  CrosAudioConfig_SetNoiseCancellationEnabled_ParamsSpec: CrosAudioConfig_SetNoiseCancellationEnabled_ParamsSpec,
  CrosAudioConfig_SetOutputMuted_ParamsSpec: CrosAudioConfig_SetOutputMuted_ParamsSpec,
  CrosAudioConfig_SetOutputVolumePercent_ParamsSpec: CrosAudioConfig_SetOutputVolumePercent_ParamsSpec,
  CrosAudioConfig_SetSpatialAudioEnabled_ParamsSpec: CrosAudioConfig_SetSpatialAudioEnabled_ParamsSpec,
  CrosAudioConfig_SetStyleTransferEnabled_ParamsSpec: CrosAudioConfig_SetStyleTransferEnabled_ParamsSpec,
  get MuteState () { return MuteState; },
  MuteStateSpec: MuteStateSpec,
  VoiceIsolationUIAppearanceSpec: VoiceIsolationUIAppearanceSpec
});

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * Fake implementation of CrosAudioConfig for testing.
 */
const defaultFakeMicJack = {
    id: BigInt(1),
    displayName: 'Mic Jack',
    isActive: true,
    deviceType: AudioDeviceType.kInternalMic,
    noiseCancellationState: AudioEffectState.kNotSupported,
    styleTransferState: AudioEffectState.kNotSupported,
    forceRespectUiGainsState: AudioEffectState.kNotEnabled,
    hfpMicSrState: AudioEffectState.kNotSupported,
    spatialAudioState: AudioEffectState.kNotSupported,
};
const fakeSpeakerActive = {
    id: BigInt(2),
    displayName: 'Speaker',
    isActive: true,
    deviceType: AudioDeviceType.kInternalSpeaker,
    noiseCancellationState: AudioEffectState.kNotSupported,
    styleTransferState: AudioEffectState.kNotSupported,
    forceRespectUiGainsState: AudioEffectState.kNotSupported,
    hfpMicSrState: AudioEffectState.kNotSupported,
    spatialAudioState: AudioEffectState.kNotEnabled,
};
const fakeMicJackInactive = {
    id: BigInt(3),
    displayName: 'Mic Jack',
    isActive: false,
    deviceType: AudioDeviceType.kInternalSpeaker,
    noiseCancellationState: AudioEffectState.kNotSupported,
    styleTransferState: AudioEffectState.kNotSupported,
    forceRespectUiGainsState: AudioEffectState.kNotSupported,
    hfpMicSrState: AudioEffectState.kNotSupported,
    spatialAudioState: AudioEffectState.kNotSupported,
};
const defaultFakeSpeaker = {
    id: BigInt(4),
    displayName: 'Speaker',
    isActive: false,
    deviceType: AudioDeviceType.kInternalSpeaker,
    noiseCancellationState: AudioEffectState.kNotSupported,
    styleTransferState: AudioEffectState.kNotSupported,
    forceRespectUiGainsState: AudioEffectState.kNotSupported,
    hfpMicSrState: AudioEffectState.kNotSupported,
    spatialAudioState: AudioEffectState.kNotEnabled,
};
const fakeInternalFrontMic = {
    id: BigInt(5),
    displayName: 'FrontMic',
    isActive: true,
    deviceType: AudioDeviceType.kFrontMic,
    noiseCancellationState: AudioEffectState.kNotEnabled,
    styleTransferState: AudioEffectState.kNotSupported,
    forceRespectUiGainsState: AudioEffectState.kNotEnabled,
    hfpMicSrState: AudioEffectState.kNotSupported,
    spatialAudioState: AudioEffectState.kNotSupported,
};
const fakeBluetoothMic = {
    id: BigInt(6),
    displayName: 'Bluetooth Mic',
    isActive: false,
    deviceType: AudioDeviceType.kBluetoothNbMic,
    noiseCancellationState: AudioEffectState.kNotSupported,
    styleTransferState: AudioEffectState.kNotSupported,
    forceRespectUiGainsState: AudioEffectState.kNotEnabled,
    hfpMicSrState: AudioEffectState.kNotSupported,
    spatialAudioState: AudioEffectState.kNotSupported,
};
const fakeInternalMicActive = {
    id: BigInt(7),
    displayName: 'Internal Mic',
    isActive: true,
    deviceType: AudioDeviceType.kInternalMic,
    noiseCancellationState: AudioEffectState.kNotSupported,
    styleTransferState: AudioEffectState.kNotSupported,
    forceRespectUiGainsState: AudioEffectState.kNotEnabled,
    hfpMicSrState: AudioEffectState.kNotSupported,
    spatialAudioState: AudioEffectState.kNotSupported,
};
const fakeBluetoothNbMicActiveHfpMicSrNotEnabled = {
    id: BigInt(8),
    displayName: 'Bluetooth Nb Mic',
    isActive: true,
    deviceType: AudioDeviceType.kBluetoothNbMic,
    noiseCancellationState: AudioEffectState.kNotSupported,
    styleTransferState: AudioEffectState.kNotSupported,
    forceRespectUiGainsState: AudioEffectState.kNotEnabled,
    hfpMicSrState: AudioEffectState.kNotEnabled,
    spatialAudioState: AudioEffectState.kNotSupported,
};
const fakeInternalMicActiveWithStyleTransfer = {
    id: BigInt(9),
    displayName: 'Internal Mic',
    isActive: true,
    deviceType: AudioDeviceType.kInternalMic,
    noiseCancellationState: AudioEffectState.kNotSupported,
    styleTransferState: AudioEffectState.kNotEnabled,
    forceRespectUiGainsState: AudioEffectState.kNotEnabled,
    hfpMicSrState: AudioEffectState.kNotSupported,
    spatialAudioState: AudioEffectState.kNotSupported,
};
const fakeVoiceIsolationUIAppearance = {
    toggleType: AudioEffectType.kNone,
    effectModeOptions: 0,
    showEffectFallbackMessage: false,
};
const fakeVoiceIsolationUIAppearanceNC = {
    toggleType: AudioEffectType.kNoiseCancellation,
    effectModeOptions: 0,
    showEffectFallbackMessage: false,
};
const fakeVoiceIsolationUIAppearanceST = {
    toggleType: AudioEffectType.kStyleTransfer,
    effectModeOptions: 0,
    showEffectFallbackMessage: false,
};
const fakeVoiceIsolationUIAppearanceBF = {
    toggleType: AudioEffectType.kBeamforming,
    effectModeOptions: 0,
    showEffectFallbackMessage: false,
};
const fakeVoiceIsolationUIAppearanceEffectMode = {
    toggleType: AudioEffectType.kStyleTransfer,
    effectModeOptions: AudioEffectType.kStyleTransfer | AudioEffectType.kBeamforming,
    showEffectFallbackMessage: false,
};
const fakeVoiceIsolationUIAppearanceFallback = {
    toggleType: AudioEffectType.kStyleTransfer,
    effectModeOptions: 0,
    showEffectFallbackMessage: true,
};
const defaultFakeAudioSystemProperties = {
    outputDevices: [defaultFakeSpeaker, defaultFakeMicJack],
    outputVolumePercent: 75,
    inputGainPercent: 87,
    outputMuteState: MuteState.kNotMuted,
    inputDevices: [fakeInternalFrontMic, fakeBluetoothMic],
    inputMuteState: MuteState.kNotMuted,
    voiceIsolationUiAppearance: fakeVoiceIsolationUIAppearance,
};
/** Creates an audio device based on provided device and isActive override. */
function createAudioDevice(baseDevice, isActive) {
    assert$1(!!baseDevice);
    return ({ ...baseDevice, isActive });
}
class FakeCrosAudioConfig {
    constructor() {
        this.audioSystemProperties = defaultFakeAudioSystemProperties;
        this.observers = [];
    }
    observeAudioSystemProperties(observer) {
        this.observers.push(observer);
        this.notifyAudioSystemPropertiesUpdated();
    }
    /**
     * Sets the active output or input device and notifies observers.
     */
    setActiveDevice(deviceId) {
        const isOutputDevice = !!(this.audioSystemProperties.outputDevices.find((device) => device.id === deviceId));
        if (isOutputDevice) {
            const devices = this.audioSystemProperties.outputDevices.map((device) => createAudioDevice(device, device.id === deviceId));
            this.audioSystemProperties.outputDevices = devices;
        }
        else {
            // Device must be an input device otherwise an invalid device was
            // provided.
            assert$1(this.audioSystemProperties.inputDevices.find((device) => device.id === deviceId));
            const devices = this.audioSystemProperties.inputDevices.map((device) => createAudioDevice(device, device.id === deviceId));
            this.audioSystemProperties.inputDevices = devices;
        }
        this.notifyAudioSystemPropertiesUpdated();
    }
    /**
     * Sets `audioSystemProperties` to the desired properties and notifies
     * observers.
     */
    setAudioSystemProperties(properties) {
        this.audioSystemProperties = properties;
        this.notifyAudioSystemPropertiesUpdated();
    }
    /**
     * Gets `AudioDevice` for `deviceId` for testing purpose.
     */
    getDeviceByIdForTesting(deviceId) {
        const outputDevice = this.audioSystemProperties.outputDevices.find((device) => device.id === deviceId);
        if (outputDevice !== undefined) {
            return outputDevice;
        }
        return this.audioSystemProperties.inputDevices.find((device) => device.id === deviceId);
    }
    /** Handle recording voice isolation state change. */
    recordVoiceIsolationEnabledChange() { }
    recordVoiceIsolationPreferredEffectChange(_) { }
    /** Handle updating active input device noise cancellation state. */
    setNoiseCancellationEnabled(enabled) {
        if (!this.audioSystemProperties.inputDevices) {
            return;
        }
        const activeIndex = this.audioSystemProperties.inputDevices.findIndex((device) => device.isActive &&
            device.noiseCancellationState !== AudioEffectState.kNotSupported);
        if (activeIndex === -1) {
            return;
        }
        const nextState = enabled ? AudioEffectState.kEnabled : AudioEffectState.kNotEnabled;
        this.audioSystemProperties.inputDevices[activeIndex]
            .noiseCancellationState = nextState;
        this.notifyAudioSystemPropertiesUpdated();
    }
    /** Handle updating active input device style transfer state. */
    setStyleTransferEnabled(enabled) {
        if (!this.audioSystemProperties.inputDevices) {
            return;
        }
        const activeIndex = this.audioSystemProperties.inputDevices.findIndex((device) => device.isActive &&
            device.styleTransferState !== AudioEffectState.kNotSupported);
        if (activeIndex === -1) {
            return;
        }
        const nextState = enabled ? AudioEffectState.kEnabled : AudioEffectState.kNotEnabled;
        this.audioSystemProperties.inputDevices[activeIndex].styleTransferState =
            nextState;
        this.notifyAudioSystemPropertiesUpdated();
    }
    /** Handle updating active input device force respect ui gains state. */
    setForceRespectUiGainsEnabled(enabled) {
        if (!this.audioSystemProperties.inputDevices) {
            return;
        }
        const activeIndex = this.audioSystemProperties.inputDevices.findIndex((device) => device.isActive);
        if (activeIndex === -1) {
            return;
        }
        const nextState = enabled ? AudioEffectState.kEnabled : AudioEffectState.kNotEnabled;
        this.audioSystemProperties.inputDevices[activeIndex]
            .forceRespectUiGainsState = nextState;
        this.notifyAudioSystemPropertiesUpdated();
    }
    /** Handle updating hfp mic sr state. */
    setHfpMicSrEnabled(enabled) {
        if (!this.audioSystemProperties.inputDevices) {
            return;
        }
        const activeIndex = this.audioSystemProperties.inputDevices.findIndex((device) => device.isActive &&
            device.hfpMicSrState !== AudioEffectState.kNotSupported);
        if (activeIndex === -1) {
            return;
        }
        const nextState = enabled ? AudioEffectState.kEnabled : AudioEffectState.kNotEnabled;
        this.audioSystemProperties.inputDevices[activeIndex].hfpMicSrState =
            nextState;
        this.notifyAudioSystemPropertiesUpdated();
    }
    /** Handle updating active output device spatial audio state. */
    setSpatialAudioEnabled(enabled) {
        if (!this.audioSystemProperties.outputDevices) {
            return;
        }
        const activeIndex = this.audioSystemProperties.outputDevices.findIndex((device) => device.isActive);
        if (activeIndex === -1) {
            return;
        }
        const nextState = enabled ? AudioEffectState.kEnabled : AudioEffectState.kNotEnabled;
        this.audioSystemProperties.outputDevices[activeIndex].spatialAudioState =
            nextState;
        this.notifyAudioSystemPropertiesUpdated();
    }
    /**
     * Returns true if hfpMicSrState is enabled on the device with id `deviceId`.
     */
    isHfpMicSrEnabled(deviceId) {
        const device = this.audioSystemProperties.inputDevices.find((device) => device.id === deviceId);
        assert$1(device !== undefined);
        return device.hfpMicSrState === AudioEffectState.kEnabled;
    }
    /**
     * Sets the mute state based on provided value.
     */
    setOutputMuted(muted) {
        this.audioSystemProperties.outputMuteState =
            muted ? MuteState.kMutedByUser : MuteState.kNotMuted;
        this.notifyAudioSystemPropertiesUpdated();
    }
    /**
     * Sets the input device mute state to `kMutedByUser` when true and
     * `kNotMuted` when false.
     */
    setInputMuted(muted) {
        const muteState = muted ? MuteState.kMutedByUser : MuteState.kNotMuted;
        this.audioSystemProperties.inputMuteState = muteState;
        this.notifyAudioSystemPropertiesUpdated();
    }
    /**
     * Sets the `inputGainPercent` to the desired volume and notifies
     * observers.
     */
    setInputGainPercent(gain) {
        assert$1(gain >= 0 && gain <= 100);
        this.audioSystemProperties.inputGainPercent = Math.round(gain);
        this.notifyAudioSystemPropertiesUpdated();
    }
    /**
     * Sets the `outputVolumePercent` to the desired volume and notifies
     * observers.
     */
    setOutputVolumePercent(volume) {
        this.audioSystemProperties.outputVolumePercent = Math.round(volume);
        this.notifyAudioSystemPropertiesUpdated();
    }
    /** Notifies the observer list that `audioSystemProperties` has changed. */
    notifyAudioSystemPropertiesUpdated() {
        this.observers.forEach((observer) => {
            observer.onPropertiesUpdated(this.audioSystemProperties);
        });
    }
}

var fake_cros_audio_config = /*#__PURE__*/Object.freeze({
  __proto__: null,
  FakeCrosAudioConfig: FakeCrosAudioConfig,
  createAudioDevice: createAudioDevice,
  defaultFakeAudioSystemProperties: defaultFakeAudioSystemProperties,
  defaultFakeMicJack: defaultFakeMicJack,
  defaultFakeSpeaker: defaultFakeSpeaker,
  fakeBluetoothMic: fakeBluetoothMic,
  fakeBluetoothNbMicActiveHfpMicSrNotEnabled: fakeBluetoothNbMicActiveHfpMicSrNotEnabled,
  fakeInternalFrontMic: fakeInternalFrontMic,
  fakeInternalMicActive: fakeInternalMicActive,
  fakeInternalMicActiveWithStyleTransfer: fakeInternalMicActiveWithStyleTransfer,
  fakeMicJackInactive: fakeMicJackInactive,
  fakeSpeakerActive: fakeSpeakerActive,
  fakeVoiceIsolationUIAppearance: fakeVoiceIsolationUIAppearance,
  fakeVoiceIsolationUIAppearanceBF: fakeVoiceIsolationUIAppearanceBF,
  fakeVoiceIsolationUIAppearanceEffectMode: fakeVoiceIsolationUIAppearanceEffectMode,
  fakeVoiceIsolationUIAppearanceFallback: fakeVoiceIsolationUIAppearanceFallback,
  fakeVoiceIsolationUIAppearanceNC: fakeVoiceIsolationUIAppearanceNC,
  fakeVoiceIsolationUIAppearanceST: fakeVoiceIsolationUIAppearanceST
});

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
let crosAudioConfig = null;
/** Use FakeCrosAudioConfig implementation in `getCrosAudioConfig`. */
const useFakeMojo = false;
/**
 * The CrosAudioConfig implementation used for testing. Passing null reverses
 * the override.
 */
function setCrosAudioConfigForTesting(testCrosAudioConfig) {
    crosAudioConfig = testCrosAudioConfig;
}
function getCrosAudioConfig() {
    if (!crosAudioConfig && useFakeMojo) {
        crosAudioConfig = new FakeCrosAudioConfig();
    }
    if (!crosAudioConfig) {
        crosAudioConfig = CrosAudioConfig.getRemote();
    }
    // Base case returns a fake CrosAudioConfig used for testing.
    return crosAudioConfig;
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Enumeration for device state about remaining space.
 * These values must be kept in sync with
 * StorageManagerHandler::StorageSpaceState in C++ code.
 */
var StorageSpaceState;
(function (StorageSpaceState) {
    StorageSpaceState[StorageSpaceState["NORMAL"] = 0] = "NORMAL";
    StorageSpaceState[StorageSpaceState["LOW"] = 1] = "LOW";
    StorageSpaceState[StorageSpaceState["CRITICALLY_LOW"] = 2] = "CRITICALLY_LOW";
})(StorageSpaceState || (StorageSpaceState = {}));
let systemDisplayApi = null;
function setDisplayApiForTesting(testDisplayApi) {
    systemDisplayApi = testDisplayApi;
}
function getDisplayApi() {
    if (!systemDisplayApi) {
        systemDisplayApi = chrome.system.display;
    }
    return systemDisplayApi;
}
/**
 * Mirrors ash::settings::PowerHandler::IdleBehavior.
 */
var IdleBehavior;
(function (IdleBehavior) {
    IdleBehavior[IdleBehavior["DISPLAY_OFF_SLEEP"] = 0] = "DISPLAY_OFF_SLEEP";
    IdleBehavior[IdleBehavior["DISPLAY_OFF"] = 1] = "DISPLAY_OFF";
    IdleBehavior[IdleBehavior["DISPLAY_ON"] = 2] = "DISPLAY_ON";
    IdleBehavior[IdleBehavior["SHUT_DOWN"] = 3] = "SHUT_DOWN";
    IdleBehavior[IdleBehavior["STOP_SESSION"] = 4] = "STOP_SESSION";
})(IdleBehavior || (IdleBehavior = {}));
/**
 * Mirrors chromeos::PowerPolicyController::Action.
 */
var LidClosedBehavior;
(function (LidClosedBehavior) {
    LidClosedBehavior[LidClosedBehavior["SUSPEND"] = 0] = "SUSPEND";
    LidClosedBehavior[LidClosedBehavior["STOP_SESSION"] = 1] = "STOP_SESSION";
    LidClosedBehavior[LidClosedBehavior["SHUT_DOWN"] = 2] = "SHUT_DOWN";
    LidClosedBehavior[LidClosedBehavior["DO_NOTHING"] = 3] = "DO_NOTHING";
})(LidClosedBehavior || (LidClosedBehavior = {}));
/**
 * Mirrors chromeos::PowerPolicyController::OptimizedChargingStrategy
 */
var OptimizedChargingStrategy;
(function (OptimizedChargingStrategy) {
    OptimizedChargingStrategy[OptimizedChargingStrategy["STRATEGY_ADAPTIVE_CHARGING"] = 0] = "STRATEGY_ADAPTIVE_CHARGING";
    OptimizedChargingStrategy[OptimizedChargingStrategy["STRATEGY_CHARGE_LIMIT"] = 1] = "STRATEGY_CHARGE_LIMIT";
})(OptimizedChargingStrategy || (OptimizedChargingStrategy = {}));
let instance$x = null;
class DevicePageBrowserProxyImpl {
    static getInstance() {
        return instance$x || (instance$x = new DevicePageBrowserProxyImpl());
    }
    static setInstanceForTesting(obj) {
        instance$x = obj;
    }
    initializePointers() {
        chrome.send('initializePointerSettings');
    }
    initializeStylus() {
        chrome.send('initializeStylusSettings');
    }
    initializeKeyboard() {
        chrome.send('initializeKeyboardSettings');
    }
    showShortcutCustomizationApp() {
        chrome.send('showShortcutCustomizationApp');
    }
    initializeKeyboardWatcher() {
        chrome.send('initializeKeyboardWatcher');
    }
    updateAndroidEnabled() {
        chrome.send('updateAndroidEnabled');
    }
    updatePowerStatus() {
        chrome.send('updatePowerStatus');
    }
    setPowerSource(powerSourceId) {
        chrome.send('setPowerSource', [powerSourceId]);
    }
    requestPowerManagementSettings() {
        chrome.send('requestPowerManagementSettings');
    }
    setIdleBehavior(behavior, whenOnAc) {
        chrome.send('setIdleBehavior', [behavior, whenOnAc]);
    }
    setAdaptiveCharging(enabled) {
        chrome.send('setAdaptiveCharging', [enabled]);
    }
    setOptimizedCharging(strategy, enabled) {
        chrome.send('setOptimizedCharging', [strategy, enabled]);
    }
    setLidClosedBehavior(behavior) {
        chrome.send('setLidClosedBehavior', [behavior]);
    }
    setNoteTakingAppsUpdatedCallback(callback) {
        addWebUiListener('onNoteTakingAppsUpdated', callback);
    }
    showPlayStore(url) {
        chrome.send('showPlayStoreApps', [url]);
    }
    requestNoteTakingApps() {
        chrome.send('requestNoteTakingApps');
    }
    setPreferredNoteTakingApp(appId) {
        chrome.send('setPreferredNoteTakingApp', [appId]);
    }
    updateExternalStorages() {
        chrome.send('updateExternalStorages');
    }
    setExternalStoragesUpdatedCallback(callback) {
        addWebUiListener('onExternalStoragesUpdated', callback);
    }
    highlightDisplay(id) {
        chrome.send('highlightDisplay', [id]);
    }
    dragDisplayDelta(displayId, deltaX, deltaY) {
        chrome.send('dragDisplayDelta', [displayId, deltaX, deltaY]);
    }
    updateStorageInfo() {
        chrome.send('updateStorageInfo');
    }
    getStorageEncryptionInfo() {
        return sendWithPromise$1('getStorageEncryptionInfo');
    }
    openMyFiles() {
        chrome.send('openMyFiles');
    }
    openBrowsingDataSettings() {
        chrome.send('openBrowsingDataSettings');
    }
}

function getTemplate$1p() {
    return html `<!--_html_template_start_--><style>:host{clip:rect(0 0 0 0);height:1px;overflow:hidden;position:fixed;width:1px}</style>

<div id="messages" role="alert" aria-live="polite" aria-relevant="additions">
</div>
<!--_html_template_end_-->`;
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * 150ms seems to be around the minimum time required for screen readers to
 * read out consecutively queued messages.
 */
const TIMEOUT_MS = 150;
/**
 * A map of an HTML element to its corresponding CrA11yAnnouncerElement. There
 * may be multiple CrA11yAnnouncerElements on a page, especially for cases in
 * which the DocumentElement's CrA11yAnnouncerElement becomes hidden or
 * deactivated (eg. when a modal dialog causes the CrA11yAnnouncerElement to
 * become inaccessible).
 */
const instances = new Map();
function getInstance(container = document.body) {
    if (instances.has(container)) {
        return instances.get(container);
    }
    assert$1(container.isConnected);
    const instance = new CrA11yAnnouncerElement();
    container.appendChild(instance);
    instances.set(container, instance);
    return instance;
}
class CrA11yAnnouncerElement extends PolymerElement {
    constructor() {
        super(...arguments);
        this.currentTimeout_ = null;
        this.messages_ = [];
    }
    static get is() {
        return 'cr-a11y-announcer';
    }
    static get template() {
        return getTemplate$1p();
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        if (this.currentTimeout_ !== null) {
            clearTimeout(this.currentTimeout_);
            this.currentTimeout_ = null;
        }
        for (const [parent, instance] of instances) {
            if (instance === this) {
                instances.delete(parent);
                break;
            }
        }
    }
    announce(message) {
        if (this.currentTimeout_ !== null) {
            clearTimeout(this.currentTimeout_);
            this.currentTimeout_ = null;
        }
        this.messages_.push(message);
        this.currentTimeout_ = setTimeout(() => {
            const messagesDiv = this.shadowRoot.querySelector('#messages');
            messagesDiv.innerHTML = window.trustedTypes.emptyHTML;
            for (const message of this.messages_) {
                const div = document.createElement('div');
                div.textContent = message;
                messagesDiv.appendChild(div);
            }
            // Dispatch a custom event to allow consumers to know when certain alerts
            // have been sent to the screen reader.
            this.dispatchEvent(new CustomEvent('cr-a11y-announcer-messages-sent', { bubbles: true, detail: { messages: this.messages_.slice() } }));
            this.messages_.length = 0;
            this.currentTimeout_ = null;
        }, TIMEOUT_MS);
    }
}
customElements.define(CrA11yAnnouncerElement.is, CrA11yAnnouncerElement);

// ash/public/mojom/accelerator_actions.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const AcceleratorActionSpec = { $: mojo.internal.Enum() };
var AcceleratorAction$1;
(function (AcceleratorAction) {
    AcceleratorAction[AcceleratorAction["MIN_VALUE"] = 0] = "MIN_VALUE";
    AcceleratorAction[AcceleratorAction["MAX_VALUE"] = 9029] = "MAX_VALUE";
    AcceleratorAction[AcceleratorAction["kBrightnessDown"] = 0] = "kBrightnessDown";
    AcceleratorAction[AcceleratorAction["kBrightnessUp"] = 1] = "kBrightnessUp";
    AcceleratorAction[AcceleratorAction["kCycleBackwardMru"] = 2] = "kCycleBackwardMru";
    AcceleratorAction[AcceleratorAction["kCycleForwardMru"] = 3] = "kCycleForwardMru";
    AcceleratorAction[AcceleratorAction["kCycleSameAppWindowsBackward"] = 4] = "kCycleSameAppWindowsBackward";
    AcceleratorAction[AcceleratorAction["kCycleSameAppWindowsForward"] = 5] = "kCycleSameAppWindowsForward";
    AcceleratorAction[AcceleratorAction["kDesksActivateDeskLeft"] = 6] = "kDesksActivateDeskLeft";
    AcceleratorAction[AcceleratorAction["kDesksActivateDeskRight"] = 7] = "kDesksActivateDeskRight";
    AcceleratorAction[AcceleratorAction["kDesksMoveActiveItemLeft"] = 8] = "kDesksMoveActiveItemLeft";
    AcceleratorAction[AcceleratorAction["kDesksMoveActiveItemRight"] = 9] = "kDesksMoveActiveItemRight";
    AcceleratorAction[AcceleratorAction["kDesksNewDesk"] = 10] = "kDesksNewDesk";
    AcceleratorAction[AcceleratorAction["kDesksRemoveCurrentDesk"] = 11] = "kDesksRemoveCurrentDesk";
    AcceleratorAction[AcceleratorAction["kDesksActivate0"] = 12] = "kDesksActivate0";
    AcceleratorAction[AcceleratorAction["kDesksActivate1"] = 13] = "kDesksActivate1";
    AcceleratorAction[AcceleratorAction["kDesksActivate2"] = 14] = "kDesksActivate2";
    AcceleratorAction[AcceleratorAction["kDesksActivate3"] = 15] = "kDesksActivate3";
    AcceleratorAction[AcceleratorAction["kDesksActivate4"] = 16] = "kDesksActivate4";
    AcceleratorAction[AcceleratorAction["kDesksActivate5"] = 17] = "kDesksActivate5";
    AcceleratorAction[AcceleratorAction["kDesksActivate6"] = 18] = "kDesksActivate6";
    AcceleratorAction[AcceleratorAction["kDesksActivate7"] = 19] = "kDesksActivate7";
    AcceleratorAction[AcceleratorAction["kDesksToggleAssignToAllDesks"] = 20] = "kDesksToggleAssignToAllDesks";
    AcceleratorAction[AcceleratorAction["kDisableCapsLock"] = 21] = "kDisableCapsLock";
    AcceleratorAction[AcceleratorAction["kEnableOrToggleDictation"] = 22] = "kEnableOrToggleDictation";
    AcceleratorAction[AcceleratorAction["kExit"] = 23] = "kExit";
    AcceleratorAction[AcceleratorAction["kFocusCameraPreview"] = 24] = "kFocusCameraPreview";
    AcceleratorAction[AcceleratorAction["kFocusNextPane"] = 25] = "kFocusNextPane";
    AcceleratorAction[AcceleratorAction["kFocusPreviousPane"] = 26] = "kFocusPreviousPane";
    AcceleratorAction[AcceleratorAction["kFocusShelf"] = 27] = "kFocusShelf";
    AcceleratorAction[AcceleratorAction["kFocusPip"] = 28] = "kFocusPip";
    AcceleratorAction[AcceleratorAction["kKeyboardBacklightToggle"] = 29] = "kKeyboardBacklightToggle";
    AcceleratorAction[AcceleratorAction["kKeyboardBrightnessDown"] = 30] = "kKeyboardBrightnessDown";
    AcceleratorAction[AcceleratorAction["kKeyboardBrightnessUp"] = 31] = "kKeyboardBrightnessUp";
    AcceleratorAction[AcceleratorAction["kLaunchApp0"] = 32] = "kLaunchApp0";
    AcceleratorAction[AcceleratorAction["kLaunchApp1"] = 33] = "kLaunchApp1";
    AcceleratorAction[AcceleratorAction["kLaunchApp2"] = 34] = "kLaunchApp2";
    AcceleratorAction[AcceleratorAction["kLaunchApp3"] = 35] = "kLaunchApp3";
    AcceleratorAction[AcceleratorAction["kLaunchApp4"] = 36] = "kLaunchApp4";
    AcceleratorAction[AcceleratorAction["kLaunchApp5"] = 37] = "kLaunchApp5";
    AcceleratorAction[AcceleratorAction["kLaunchApp6"] = 38] = "kLaunchApp6";
    AcceleratorAction[AcceleratorAction["kLaunchApp7"] = 39] = "kLaunchApp7";
    AcceleratorAction[AcceleratorAction["kLaunchLastApp"] = 40] = "kLaunchLastApp";
    AcceleratorAction[AcceleratorAction["kLockPressed"] = 41] = "kLockPressed";
    AcceleratorAction[AcceleratorAction["kLockReleased"] = 42] = "kLockReleased";
    AcceleratorAction[AcceleratorAction["kLockScreen"] = 43] = "kLockScreen";
    AcceleratorAction[AcceleratorAction["kMagnifierZoomIn"] = 44] = "kMagnifierZoomIn";
    AcceleratorAction[AcceleratorAction["kMagnifierZoomOut"] = 45] = "kMagnifierZoomOut";
    AcceleratorAction[AcceleratorAction["kMediaFastForward"] = 46] = "kMediaFastForward";
    AcceleratorAction[AcceleratorAction["kMediaNextTrack"] = 47] = "kMediaNextTrack";
    AcceleratorAction[AcceleratorAction["kMediaPause"] = 48] = "kMediaPause";
    AcceleratorAction[AcceleratorAction["kMediaPlay"] = 49] = "kMediaPlay";
    AcceleratorAction[AcceleratorAction["kMediaPlayPause"] = 50] = "kMediaPlayPause";
    AcceleratorAction[AcceleratorAction["kMediaPrevTrack"] = 51] = "kMediaPrevTrack";
    AcceleratorAction[AcceleratorAction["kMediaRewind"] = 52] = "kMediaRewind";
    AcceleratorAction[AcceleratorAction["kMediaStop"] = 53] = "kMediaStop";
    AcceleratorAction[AcceleratorAction["kMicrophoneMuteToggle"] = 54] = "kMicrophoneMuteToggle";
    AcceleratorAction[AcceleratorAction["kMoveActiveWindowBetweenDisplays"] = 55] = "kMoveActiveWindowBetweenDisplays";
    AcceleratorAction[AcceleratorAction["kNewIncognitoWindow"] = 56] = "kNewIncognitoWindow";
    AcceleratorAction[AcceleratorAction["kNewTab"] = 57] = "kNewTab";
    AcceleratorAction[AcceleratorAction["kNewWindow"] = 58] = "kNewWindow";
    AcceleratorAction[AcceleratorAction["kOpenCalculator"] = 59] = "kOpenCalculator";
    AcceleratorAction[AcceleratorAction["kOpenCrosh"] = 60] = "kOpenCrosh";
    AcceleratorAction[AcceleratorAction["kOpenDiagnostics"] = 61] = "kOpenDiagnostics";
    AcceleratorAction[AcceleratorAction["kOpenFeedbackPage"] = 62] = "kOpenFeedbackPage";
    AcceleratorAction[AcceleratorAction["kOpenFileManager"] = 63] = "kOpenFileManager";
    AcceleratorAction[AcceleratorAction["kOpenGetHelp"] = 64] = "kOpenGetHelp";
    AcceleratorAction[AcceleratorAction["kPasteClipboardHistoryPlainText"] = 65] = "kPasteClipboardHistoryPlainText";
    AcceleratorAction[AcceleratorAction["kPowerPressed"] = 66] = "kPowerPressed";
    AcceleratorAction[AcceleratorAction["kPowerReleased"] = 67] = "kPowerReleased";
    AcceleratorAction[AcceleratorAction["kPrintUiHierarchies"] = 68] = "kPrintUiHierarchies";
    AcceleratorAction[AcceleratorAction["kPrivacyScreenToggle"] = 69] = "kPrivacyScreenToggle";
    AcceleratorAction[AcceleratorAction["kRestoreTab"] = 70] = "kRestoreTab";
    AcceleratorAction[AcceleratorAction["kRotateScreen"] = 71] = "kRotateScreen";
    AcceleratorAction[AcceleratorAction["kRotateWindow"] = 72] = "kRotateWindow";
    AcceleratorAction[AcceleratorAction["kScaleUiDown"] = 73] = "kScaleUiDown";
    AcceleratorAction[AcceleratorAction["kScaleUiReset"] = 74] = "kScaleUiReset";
    AcceleratorAction[AcceleratorAction["kScaleUiUp"] = 75] = "kScaleUiUp";
    AcceleratorAction[AcceleratorAction["kShowEmojiPicker"] = 76] = "kShowEmojiPicker";
    AcceleratorAction[AcceleratorAction["kToggleImeMenuBubble"] = 77] = "kToggleImeMenuBubble";
    AcceleratorAction[AcceleratorAction["kShowShortcutViewer"] = 78] = "kShowShortcutViewer";
    AcceleratorAction[AcceleratorAction["kShowTaskManager"] = 79] = "kShowTaskManager";
    AcceleratorAction[AcceleratorAction["kStartAssistant"] = 80] = "kStartAssistant";
    AcceleratorAction[AcceleratorAction["kStopScreenRecording"] = 81] = "kStopScreenRecording";
    AcceleratorAction[AcceleratorAction["kSuspend"] = 82] = "kSuspend";
    AcceleratorAction[AcceleratorAction["kSwapPrimaryDisplay"] = 83] = "kSwapPrimaryDisplay";
    AcceleratorAction[AcceleratorAction["kSwitchIme"] = 84] = "kSwitchIme";
    AcceleratorAction[AcceleratorAction["kSwitchToLastUsedIme"] = 85] = "kSwitchToLastUsedIme";
    AcceleratorAction[AcceleratorAction["kSwitchToNextIme"] = 86] = "kSwitchToNextIme";
    AcceleratorAction[AcceleratorAction["kSwitchToNextUser"] = 87] = "kSwitchToNextUser";
    AcceleratorAction[AcceleratorAction["kSwitchToPreviousUser"] = 88] = "kSwitchToPreviousUser";
    AcceleratorAction[AcceleratorAction["kTakePartialScreenshot"] = 89] = "kTakePartialScreenshot";
    AcceleratorAction[AcceleratorAction["kTakeScreenshot"] = 90] = "kTakeScreenshot";
    AcceleratorAction[AcceleratorAction["kTakeWindowScreenshot"] = 91] = "kTakeWindowScreenshot";
    AcceleratorAction[AcceleratorAction["kToggleAppList"] = 92] = "kToggleAppList";
    AcceleratorAction[AcceleratorAction["kToggleCalendar"] = 93] = "kToggleCalendar";
    AcceleratorAction[AcceleratorAction["kToggleCapsLock"] = 94] = "kToggleCapsLock";
    AcceleratorAction[AcceleratorAction["kToggleClipboardHistory"] = 95] = "kToggleClipboardHistory";
    AcceleratorAction[AcceleratorAction["kToggleDockedMagnifier"] = 96] = "kToggleDockedMagnifier";
    AcceleratorAction[AcceleratorAction["kToggleFloating"] = 97] = "kToggleFloating";
    AcceleratorAction[AcceleratorAction["kToggleFullscreen"] = 98] = "kToggleFullscreen";
    AcceleratorAction[AcceleratorAction["kToggleFullscreenMagnifier"] = 99] = "kToggleFullscreenMagnifier";
    AcceleratorAction[AcceleratorAction["kToggleGameDashboard"] = 100] = "kToggleGameDashboard";
    AcceleratorAction[AcceleratorAction["kToggleHighContrast"] = 101] = "kToggleHighContrast";
    AcceleratorAction[AcceleratorAction["kToggleMaximized"] = 102] = "kToggleMaximized";
    AcceleratorAction[AcceleratorAction["kToggleMessageCenterBubble"] = 103] = "kToggleMessageCenterBubble";
    AcceleratorAction[AcceleratorAction["kToggleMirrorMode"] = 104] = "kToggleMirrorMode";
    AcceleratorAction[AcceleratorAction["kToggleMultitaskMenu"] = 105] = "kToggleMultitaskMenu";
    AcceleratorAction[AcceleratorAction["kToggleOverview"] = 106] = "kToggleOverview";
    AcceleratorAction[AcceleratorAction["kToggleProjectorMarker"] = 107] = "kToggleProjectorMarker";
    AcceleratorAction[AcceleratorAction["kToggleResizeLockMenu"] = 108] = "kToggleResizeLockMenu";
    AcceleratorAction[AcceleratorAction["kToggleSnapGroup"] = 109] = "kToggleSnapGroup";
    AcceleratorAction[AcceleratorAction["kToggleSnapGroupWindowsMinimizeAndRestore"] = 110] = "kToggleSnapGroupWindowsMinimizeAndRestore";
    AcceleratorAction[AcceleratorAction["kToggleSpokenFeedback"] = 111] = "kToggleSpokenFeedback";
    AcceleratorAction[AcceleratorAction["kToggleStylusTools"] = 112] = "kToggleStylusTools";
    AcceleratorAction[AcceleratorAction["kToggleSystemTrayBubble"] = 113] = "kToggleSystemTrayBubble";
    AcceleratorAction[AcceleratorAction["kToggleWifi"] = 114] = "kToggleWifi";
    AcceleratorAction[AcceleratorAction["kTouchHudClear"] = 115] = "kTouchHudClear";
    AcceleratorAction[AcceleratorAction["kTouchHudModeChange"] = 116] = "kTouchHudModeChange";
    AcceleratorAction[AcceleratorAction["kTouchFingerprintSensor1"] = 117] = "kTouchFingerprintSensor1";
    AcceleratorAction[AcceleratorAction["kTouchFingerprintSensor2"] = 118] = "kTouchFingerprintSensor2";
    AcceleratorAction[AcceleratorAction["kTouchFingerprintSensor3"] = 119] = "kTouchFingerprintSensor3";
    AcceleratorAction[AcceleratorAction["kUnpin"] = 120] = "kUnpin";
    AcceleratorAction[AcceleratorAction["kVolumeDown"] = 121] = "kVolumeDown";
    AcceleratorAction[AcceleratorAction["kVolumeMute"] = 122] = "kVolumeMute";
    AcceleratorAction[AcceleratorAction["kVolumeUp"] = 123] = "kVolumeUp";
    AcceleratorAction[AcceleratorAction["kWindowCycleSnapLeft"] = 124] = "kWindowCycleSnapLeft";
    AcceleratorAction[AcceleratorAction["kWindowCycleSnapRight"] = 125] = "kWindowCycleSnapRight";
    AcceleratorAction[AcceleratorAction["kWindowMinimize"] = 126] = "kWindowMinimize";
    AcceleratorAction[AcceleratorAction["kMinimizeTopWindowOnBack"] = 127] = "kMinimizeTopWindowOnBack";
    AcceleratorAction[AcceleratorAction["kVolumeMuteToggle"] = 128] = "kVolumeMuteToggle";
    AcceleratorAction[AcceleratorAction["kToggleQuickInsert"] = 129] = "kToggleQuickInsert";
    AcceleratorAction[AcceleratorAction["kAccessibilityAction"] = 130] = "kAccessibilityAction";
    AcceleratorAction[AcceleratorAction["kEnableSelectToSpeak"] = 131] = "kEnableSelectToSpeak";
    AcceleratorAction[AcceleratorAction["kTilingWindowResizeLeft"] = 132] = "kTilingWindowResizeLeft";
    AcceleratorAction[AcceleratorAction["kTilingWindowResizeRight"] = 133] = "kTilingWindowResizeRight";
    AcceleratorAction[AcceleratorAction["kTilingWindowResizeUp"] = 134] = "kTilingWindowResizeUp";
    AcceleratorAction[AcceleratorAction["kTilingWindowResizeDown"] = 135] = "kTilingWindowResizeDown";
    AcceleratorAction[AcceleratorAction["kToggleMouseKeys"] = 136] = "kToggleMouseKeys";
    AcceleratorAction[AcceleratorAction["kResizePipWindow"] = 137] = "kResizePipWindow";
    AcceleratorAction[AcceleratorAction["kToggleGeminiApp"] = 138] = "kToggleGeminiApp";
    AcceleratorAction[AcceleratorAction["kToggleDoNotDisturb"] = 139] = "kToggleDoNotDisturb";
    AcceleratorAction[AcceleratorAction["kToggleCameraAllowed"] = 140] = "kToggleCameraAllowed";
    AcceleratorAction[AcceleratorAction["kStartSunfishSession"] = 141] = "kStartSunfishSession";
    AcceleratorAction[AcceleratorAction["kDebugClearUseKMeansPref"] = 9000] = "kDebugClearUseKMeansPref";
    AcceleratorAction[AcceleratorAction["kDebugKeyboardBacklightToggle"] = 9001] = "kDebugKeyboardBacklightToggle";
    AcceleratorAction[AcceleratorAction["kDebugMicrophoneMuteToggle"] = 9002] = "kDebugMicrophoneMuteToggle";
    AcceleratorAction[AcceleratorAction["kDebugPrintLayerHierarchy"] = 9003] = "kDebugPrintLayerHierarchy";
    AcceleratorAction[AcceleratorAction["kDebugPrintViewHierarchy"] = 9004] = "kDebugPrintViewHierarchy";
    AcceleratorAction[AcceleratorAction["kDebugPrintWindowHierarchy"] = 9005] = "kDebugPrintWindowHierarchy";
    AcceleratorAction[AcceleratorAction["kDebugShowInformedRestore"] = 9006] = "kDebugShowInformedRestore";
    AcceleratorAction[AcceleratorAction["kDebugShowToast"] = 9007] = "kDebugShowToast";
    AcceleratorAction[AcceleratorAction["kDebugShowSystemNudge"] = 9008] = "kDebugShowSystemNudge";
    AcceleratorAction[AcceleratorAction["kDebugSystemUiStyleViewer"] = 9009] = "kDebugSystemUiStyleViewer";
    AcceleratorAction[AcceleratorAction["kDebugToggleDarkMode"] = 9010] = "kDebugToggleDarkMode";
    AcceleratorAction[AcceleratorAction["kDebugToggleDynamicColor"] = 9011] = "kDebugToggleDynamicColor";
    AcceleratorAction[AcceleratorAction["kDebugTogglePowerButtonMenu"] = 9012] = "kDebugTogglePowerButtonMenu";
    AcceleratorAction[AcceleratorAction["kDebugToggleShowDebugBorders"] = 9013] = "kDebugToggleShowDebugBorders";
    AcceleratorAction[AcceleratorAction["kDebugToggleShowFpsCounter"] = 9014] = "kDebugToggleShowFpsCounter";
    AcceleratorAction[AcceleratorAction["kDebugToggleShowPaintRects"] = 9015] = "kDebugToggleShowPaintRects";
    AcceleratorAction[AcceleratorAction["kDebugToggleTouchPad"] = 9016] = "kDebugToggleTouchPad";
    AcceleratorAction[AcceleratorAction["kDebugToggleTouchScreen"] = 9017] = "kDebugToggleTouchScreen";
    AcceleratorAction[AcceleratorAction["kDebugToggleTabletMode"] = 9018] = "kDebugToggleTabletMode";
    AcceleratorAction[AcceleratorAction["kDebugToggleVideoConferenceCameraTrayIcon"] = 9019] = "kDebugToggleVideoConferenceCameraTrayIcon";
    AcceleratorAction[AcceleratorAction["kDebugToggleWallpaperMode"] = 9020] = "kDebugToggleWallpaperMode";
    AcceleratorAction[AcceleratorAction["kDebugTriggerCrash"] = 9021] = "kDebugTriggerCrash";
    AcceleratorAction[AcceleratorAction["kDebugToggleHudDisplay"] = 9022] = "kDebugToggleHudDisplay";
    AcceleratorAction[AcceleratorAction["kDebugToggleVirtualTrackpad"] = 9023] = "kDebugToggleVirtualTrackpad";
    AcceleratorAction[AcceleratorAction["kDevAddRemoveDisplay"] = 9024] = "kDevAddRemoveDisplay";
    AcceleratorAction[AcceleratorAction["kDevToggleAppList"] = 9025] = "kDevToggleAppList";
    AcceleratorAction[AcceleratorAction["kDevToggleUnifiedDesktop"] = 9026] = "kDevToggleUnifiedDesktop";
    AcceleratorAction[AcceleratorAction["kDebugToggleFocusModeState"] = 9027] = "kDebugToggleFocusModeState";
    AcceleratorAction[AcceleratorAction["kDebugStartSunfishSession"] = 9028] = "kDebugStartSunfishSession";
    AcceleratorAction[AcceleratorAction["kDebugShowTestWindow"] = 9029] = "kDebugShowTestWindow";
})(AcceleratorAction$1 || (AcceleratorAction$1 = {}));

// ash/public/mojom/accelerator_keys.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const VKeySpec = { $: mojo.internal.Enum() };
var VKey;
(function (VKey) {
    VKey[VKey["MIN_VALUE"] = 0] = "MIN_VALUE";
    VKey[VKey["MAX_VALUE"] = 65295] = "MAX_VALUE";
    VKey[VKey["kCancel"] = 3] = "kCancel";
    VKey[VKey["kBack"] = 8] = "kBack";
    VKey[VKey["kTab"] = 9] = "kTab";
    VKey[VKey["kBackTab"] = 10] = "kBackTab";
    VKey[VKey["kClear"] = 12] = "kClear";
    VKey[VKey["kReturn"] = 13] = "kReturn";
    VKey[VKey["kShift"] = 16] = "kShift";
    VKey[VKey["kControl"] = 17] = "kControl";
    VKey[VKey["kMenu"] = 18] = "kMenu";
    VKey[VKey["kPause"] = 19] = "kPause";
    VKey[VKey["kCapital"] = 20] = "kCapital";
    VKey[VKey["kKana"] = 21] = "kKana";
    VKey[VKey["kHangul"] = 21] = "kHangul";
    VKey[VKey["kPaste"] = 22] = "kPaste";
    VKey[VKey["kJunja"] = 23] = "kJunja";
    VKey[VKey["kFinal"] = 24] = "kFinal";
    VKey[VKey["kHanja"] = 25] = "kHanja";
    VKey[VKey["kKanji"] = 25] = "kKanji";
    VKey[VKey["kEscape"] = 27] = "kEscape";
    VKey[VKey["kConvert"] = 28] = "kConvert";
    VKey[VKey["kNonConvert"] = 29] = "kNonConvert";
    VKey[VKey["kAccept"] = 30] = "kAccept";
    VKey[VKey["kModeChange"] = 31] = "kModeChange";
    VKey[VKey["kSpace"] = 32] = "kSpace";
    VKey[VKey["kPrior"] = 33] = "kPrior";
    VKey[VKey["kNext"] = 34] = "kNext";
    VKey[VKey["kEnd"] = 35] = "kEnd";
    VKey[VKey["kHome"] = 36] = "kHome";
    VKey[VKey["kLeft"] = 37] = "kLeft";
    VKey[VKey["kUp"] = 38] = "kUp";
    VKey[VKey["kRight"] = 39] = "kRight";
    VKey[VKey["kDown"] = 40] = "kDown";
    VKey[VKey["kSelect"] = 41] = "kSelect";
    VKey[VKey["kPrint"] = 42] = "kPrint";
    VKey[VKey["kExecute"] = 43] = "kExecute";
    VKey[VKey["kSnapshot"] = 44] = "kSnapshot";
    VKey[VKey["kInsert"] = 45] = "kInsert";
    VKey[VKey["kDelete"] = 46] = "kDelete";
    VKey[VKey["kHelp"] = 47] = "kHelp";
    VKey[VKey["kNum0"] = 48] = "kNum0";
    VKey[VKey["kNum1"] = 49] = "kNum1";
    VKey[VKey["kNum2"] = 50] = "kNum2";
    VKey[VKey["kNum3"] = 51] = "kNum3";
    VKey[VKey["kNum4"] = 52] = "kNum4";
    VKey[VKey["kNum5"] = 53] = "kNum5";
    VKey[VKey["kNum6"] = 54] = "kNum6";
    VKey[VKey["kNum7"] = 55] = "kNum7";
    VKey[VKey["kNum8"] = 56] = "kNum8";
    VKey[VKey["kNum9"] = 57] = "kNum9";
    VKey[VKey["kKeyA"] = 65] = "kKeyA";
    VKey[VKey["kKeyB"] = 66] = "kKeyB";
    VKey[VKey["kKeyC"] = 67] = "kKeyC";
    VKey[VKey["kKeyD"] = 68] = "kKeyD";
    VKey[VKey["kKeyE"] = 69] = "kKeyE";
    VKey[VKey["kKeyF"] = 70] = "kKeyF";
    VKey[VKey["kKeyG"] = 71] = "kKeyG";
    VKey[VKey["kKeyH"] = 72] = "kKeyH";
    VKey[VKey["kKeyI"] = 73] = "kKeyI";
    VKey[VKey["kKeyJ"] = 74] = "kKeyJ";
    VKey[VKey["kKeyK"] = 75] = "kKeyK";
    VKey[VKey["kKeyL"] = 76] = "kKeyL";
    VKey[VKey["kKeyM"] = 77] = "kKeyM";
    VKey[VKey["kKeyN"] = 78] = "kKeyN";
    VKey[VKey["kKeyO"] = 79] = "kKeyO";
    VKey[VKey["kKeyP"] = 80] = "kKeyP";
    VKey[VKey["kKeyQ"] = 81] = "kKeyQ";
    VKey[VKey["kKeyR"] = 82] = "kKeyR";
    VKey[VKey["kKeyS"] = 83] = "kKeyS";
    VKey[VKey["kKeyT"] = 84] = "kKeyT";
    VKey[VKey["kKeyU"] = 85] = "kKeyU";
    VKey[VKey["kKeyV"] = 86] = "kKeyV";
    VKey[VKey["kKeyW"] = 87] = "kKeyW";
    VKey[VKey["kKeyX"] = 88] = "kKeyX";
    VKey[VKey["kKeyY"] = 89] = "kKeyY";
    VKey[VKey["kKeyZ"] = 90] = "kKeyZ";
    VKey[VKey["kLWin"] = 91] = "kLWin";
    VKey[VKey["kCommand"] = 91] = "kCommand";
    VKey[VKey["kRWin"] = 92] = "kRWin";
    VKey[VKey["kApps"] = 93] = "kApps";
    VKey[VKey["kSleep"] = 95] = "kSleep";
    VKey[VKey["kNumpad0"] = 96] = "kNumpad0";
    VKey[VKey["kNumpad1"] = 97] = "kNumpad1";
    VKey[VKey["kNumpad2"] = 98] = "kNumpad2";
    VKey[VKey["kNumpad3"] = 99] = "kNumpad3";
    VKey[VKey["kNumpad4"] = 100] = "kNumpad4";
    VKey[VKey["kNumpad5"] = 101] = "kNumpad5";
    VKey[VKey["kNumpad6"] = 102] = "kNumpad6";
    VKey[VKey["kNumpad7"] = 103] = "kNumpad7";
    VKey[VKey["kNumpad8"] = 104] = "kNumpad8";
    VKey[VKey["kNumpad9"] = 105] = "kNumpad9";
    VKey[VKey["kMultiply"] = 106] = "kMultiply";
    VKey[VKey["kAdd"] = 107] = "kAdd";
    VKey[VKey["kSeparator"] = 108] = "kSeparator";
    VKey[VKey["kSubtract"] = 109] = "kSubtract";
    VKey[VKey["kDecimal"] = 110] = "kDecimal";
    VKey[VKey["kDivide"] = 111] = "kDivide";
    VKey[VKey["kF1"] = 112] = "kF1";
    VKey[VKey["kF2"] = 113] = "kF2";
    VKey[VKey["kF3"] = 114] = "kF3";
    VKey[VKey["kF4"] = 115] = "kF4";
    VKey[VKey["kF5"] = 116] = "kF5";
    VKey[VKey["kF6"] = 117] = "kF6";
    VKey[VKey["kF7"] = 118] = "kF7";
    VKey[VKey["kF8"] = 119] = "kF8";
    VKey[VKey["kF9"] = 120] = "kF9";
    VKey[VKey["kF10"] = 121] = "kF10";
    VKey[VKey["kF11"] = 122] = "kF11";
    VKey[VKey["kF12"] = 123] = "kF12";
    VKey[VKey["kF13"] = 124] = "kF13";
    VKey[VKey["kF14"] = 125] = "kF14";
    VKey[VKey["kF15"] = 126] = "kF15";
    VKey[VKey["kF16"] = 127] = "kF16";
    VKey[VKey["kF17"] = 128] = "kF17";
    VKey[VKey["kF18"] = 129] = "kF18";
    VKey[VKey["kF19"] = 130] = "kF19";
    VKey[VKey["kF20"] = 131] = "kF20";
    VKey[VKey["kF21"] = 132] = "kF21";
    VKey[VKey["kF22"] = 133] = "kF22";
    VKey[VKey["kF23"] = 134] = "kF23";
    VKey[VKey["kF24"] = 135] = "kF24";
    VKey[VKey["kNumLock"] = 144] = "kNumLock";
    VKey[VKey["kScroll"] = 145] = "kScroll";
    VKey[VKey["kLShift"] = 160] = "kLShift";
    VKey[VKey["kRShift"] = 161] = "kRShift";
    VKey[VKey["kLControl"] = 162] = "kLControl";
    VKey[VKey["kRControl"] = 163] = "kRControl";
    VKey[VKey["kLMenu"] = 164] = "kLMenu";
    VKey[VKey["kRMenu"] = 165] = "kRMenu";
    VKey[VKey["kBrowserBack"] = 166] = "kBrowserBack";
    VKey[VKey["kBrowserForward"] = 167] = "kBrowserForward";
    VKey[VKey["kBrowserRefresh"] = 168] = "kBrowserRefresh";
    VKey[VKey["kBrowserStop"] = 169] = "kBrowserStop";
    VKey[VKey["kBrowserSearch"] = 170] = "kBrowserSearch";
    VKey[VKey["kBrowserFavorites"] = 171] = "kBrowserFavorites";
    VKey[VKey["kBrowserHome"] = 172] = "kBrowserHome";
    VKey[VKey["kVolumeMute"] = 173] = "kVolumeMute";
    VKey[VKey["kVolumeDown"] = 174] = "kVolumeDown";
    VKey[VKey["kVolumeUp"] = 175] = "kVolumeUp";
    VKey[VKey["kMediaNextTrack"] = 176] = "kMediaNextTrack";
    VKey[VKey["kMediaPrevTrack"] = 177] = "kMediaPrevTrack";
    VKey[VKey["kMediaStop"] = 178] = "kMediaStop";
    VKey[VKey["kMediaPlayPause"] = 179] = "kMediaPlayPause";
    VKey[VKey["kMediaLaunchMail"] = 180] = "kMediaLaunchMail";
    VKey[VKey["kMediaLaunchMediaSelect"] = 181] = "kMediaLaunchMediaSelect";
    VKey[VKey["kMediaLaunchApp1"] = 182] = "kMediaLaunchApp1";
    VKey[VKey["kMediaLaunchApp2"] = 183] = "kMediaLaunchApp2";
    VKey[VKey["kOem1"] = 186] = "kOem1";
    VKey[VKey["kOemPlus"] = 187] = "kOemPlus";
    VKey[VKey["kOemComma"] = 188] = "kOemComma";
    VKey[VKey["kOemMinus"] = 189] = "kOemMinus";
    VKey[VKey["kOemPeriod"] = 190] = "kOemPeriod";
    VKey[VKey["kOem2"] = 191] = "kOem2";
    VKey[VKey["kOem3"] = 192] = "kOem3";
    VKey[VKey["kOem4"] = 219] = "kOem4";
    VKey[VKey["kOem5"] = 220] = "kOem5";
    VKey[VKey["kOem6"] = 221] = "kOem6";
    VKey[VKey["kOem7"] = 222] = "kOem7";
    VKey[VKey["kOem8"] = 223] = "kOem8";
    VKey[VKey["kOem102"] = 226] = "kOem102";
    VKey[VKey["kOem103"] = 227] = "kOem103";
    VKey[VKey["kOem104"] = 228] = "kOem104";
    VKey[VKey["kProcessKey"] = 229] = "kProcessKey";
    VKey[VKey["kPacket"] = 231] = "kPacket";
    VKey[VKey["kOemAttn"] = 240] = "kOemAttn";
    VKey[VKey["kOemFinish"] = 241] = "kOemFinish";
    VKey[VKey["kOemCopy"] = 242] = "kOemCopy";
    VKey[VKey["kDbeSbcsChar"] = 243] = "kDbeSbcsChar";
    VKey[VKey["kDbeDbcsChar"] = 244] = "kDbeDbcsChar";
    VKey[VKey["kOemBacktab"] = 245] = "kOemBacktab";
    VKey[VKey["kAttn"] = 246] = "kAttn";
    VKey[VKey["kCrsel"] = 247] = "kCrsel";
    VKey[VKey["kExsel"] = 248] = "kExsel";
    VKey[VKey["kEreof"] = 249] = "kEreof";
    VKey[VKey["kPlay"] = 250] = "kPlay";
    VKey[VKey["kZoom"] = 251] = "kZoom";
    VKey[VKey["kNoName"] = 252] = "kNoName";
    VKey[VKey["kPA1"] = 253] = "kPA1";
    VKey[VKey["kOemClear"] = 254] = "kOemClear";
    VKey[VKey["kFunction"] = 255] = "kFunction";
    VKey[VKey["kQuickInsert"] = 256] = "kQuickInsert";
    VKey[VKey["kAccessibility"] = 257] = "kAccessibility";
    VKey[VKey["kDoNotDisturb"] = 258] = "kDoNotDisturb";
    VKey[VKey["kCameraAccessToggle"] = 259] = "kCameraAccessToggle";
    VKey[VKey["kUnknown"] = 0] = "kUnknown";
    VKey[VKey["kWlan"] = 151] = "kWlan";
    VKey[VKey["kPower"] = 152] = "kPower";
    VKey[VKey["kAssistant"] = 153] = "kAssistant";
    VKey[VKey["kSettings"] = 154] = "kSettings";
    VKey[VKey["kPrivacyScreenToggle"] = 155] = "kPrivacyScreenToggle";
    VKey[VKey["kMicrophoneMuteToggle"] = 159] = "kMicrophoneMuteToggle";
    VKey[VKey["kBrightnessDown"] = 216] = "kBrightnessDown";
    VKey[VKey["kBrightnessUp"] = 217] = "kBrightnessUp";
    VKey[VKey["kKbdBrightnessToggle"] = 184] = "kKbdBrightnessToggle";
    VKey[VKey["kKbdBrightnessDown"] = 218] = "kKbdBrightnessDown";
    VKey[VKey["kKbdBrightnessUp"] = 232] = "kKbdBrightnessUp";
    VKey[VKey["kAltGr"] = 225] = "kAltGr";
    VKey[VKey["kCompose"] = 230] = "kCompose";
    VKey[VKey["kMediaPlay"] = 233] = "kMediaPlay";
    VKey[VKey["kMediaPause"] = 234] = "kMediaPause";
    VKey[VKey["kNew"] = 235] = "kNew";
    VKey[VKey["kClose"] = 236] = "kClose";
    VKey[VKey["kEmojiPicker"] = 237] = "kEmojiPicker";
    VKey[VKey["kDictate"] = 238] = "kDictate";
    VKey[VKey["kAllApplications"] = 239] = "kAllApplications";
    VKey[VKey["kButton0"] = 65280] = "kButton0";
    VKey[VKey["kButton1"] = 65281] = "kButton1";
    VKey[VKey["kButton2"] = 65282] = "kButton2";
    VKey[VKey["kButton3"] = 65283] = "kButton3";
    VKey[VKey["kButton4"] = 65284] = "kButton4";
    VKey[VKey["kButton5"] = 65285] = "kButton5";
    VKey[VKey["kButton6"] = 65286] = "kButton6";
    VKey[VKey["kButton7"] = 65287] = "kButton7";
    VKey[VKey["kButton8"] = 65288] = "kButton8";
    VKey[VKey["kButton9"] = 65289] = "kButton9";
    VKey[VKey["kButtonA"] = 65290] = "kButtonA";
    VKey[VKey["kButtonB"] = 65291] = "kButtonB";
    VKey[VKey["kButtonC"] = 65292] = "kButtonC";
    VKey[VKey["kButtonX"] = 65293] = "kButtonX";
    VKey[VKey["kButtonY"] = 65294] = "kButtonY";
    VKey[VKey["kButtonZ"] = 65295] = "kButtonZ";
})(VKey || (VKey = {}));

// ui/events/ash/mojom/extended_fkeys_modifier.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const ExtendedFkeysModifierSpec = { $: mojo.internal.Enum() };
var ExtendedFkeysModifier$1;
(function (ExtendedFkeysModifier) {
    ExtendedFkeysModifier[ExtendedFkeysModifier["MIN_VALUE"] = 0] = "MIN_VALUE";
    ExtendedFkeysModifier[ExtendedFkeysModifier["MAX_VALUE"] = 3] = "MAX_VALUE";
    ExtendedFkeysModifier[ExtendedFkeysModifier["kDisabled"] = 0] = "kDisabled";
    ExtendedFkeysModifier[ExtendedFkeysModifier["kAlt"] = 1] = "kAlt";
    ExtendedFkeysModifier[ExtendedFkeysModifier["kShift"] = 2] = "kShift";
    ExtendedFkeysModifier[ExtendedFkeysModifier["kCtrlShift"] = 3] = "kCtrlShift";
})(ExtendedFkeysModifier$1 || (ExtendedFkeysModifier$1 = {}));

// ui/events/ash/mojom/meta_key.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const MetaKeySpec = { $: mojo.internal.Enum() };
var MetaKey$1;
(function (MetaKey) {
    MetaKey[MetaKey["MIN_VALUE"] = 0] = "MIN_VALUE";
    MetaKey[MetaKey["MAX_VALUE"] = 4] = "MAX_VALUE";
    MetaKey[MetaKey["kSearch"] = 0] = "kSearch";
    MetaKey[MetaKey["kLauncher"] = 1] = "kLauncher";
    MetaKey[MetaKey["kLauncherRefresh"] = 2] = "kLauncherRefresh";
    MetaKey[MetaKey["kExternalMeta"] = 3] = "kExternalMeta";
    MetaKey[MetaKey["kCommand"] = 4] = "kCommand";
})(MetaKey$1 || (MetaKey$1 = {}));

// ui/events/ash/mojom/modifier_key.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const ModifierKeySpec = { $: mojo.internal.Enum() };
var ModifierKey$1;
(function (ModifierKey) {
    ModifierKey[ModifierKey["MIN_VALUE"] = 0] = "MIN_VALUE";
    ModifierKey[ModifierKey["MAX_VALUE"] = 10] = "MAX_VALUE";
    ModifierKey[ModifierKey["kMeta"] = 0] = "kMeta";
    ModifierKey[ModifierKey["kControl"] = 1] = "kControl";
    ModifierKey[ModifierKey["kAlt"] = 2] = "kAlt";
    ModifierKey[ModifierKey["kVoid"] = 3] = "kVoid";
    ModifierKey[ModifierKey["kCapsLock"] = 4] = "kCapsLock";
    ModifierKey[ModifierKey["kEscape"] = 5] = "kEscape";
    ModifierKey[ModifierKey["kBackspace"] = 6] = "kBackspace";
    ModifierKey[ModifierKey["kAssistant"] = 7] = "kAssistant";
    ModifierKey[ModifierKey["kIsoLevel5ShiftMod3"] = 8] = "kIsoLevel5ShiftMod3";
    ModifierKey[ModifierKey["kFunction"] = 9] = "kFunction";
    ModifierKey[ModifierKey["kQuickInsert"] = 10] = "kQuickInsert";
})(ModifierKey$1 || (ModifierKey$1 = {}));

// ui/events/ash/mojom/simulate_right_click_modifier.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SimulateRightClickModifierSpec = { $: mojo.internal.Enum() };
var SimulateRightClickModifier$1;
(function (SimulateRightClickModifier) {
    SimulateRightClickModifier[SimulateRightClickModifier["MIN_VALUE"] = 0] = "MIN_VALUE";
    SimulateRightClickModifier[SimulateRightClickModifier["MAX_VALUE"] = 2] = "MAX_VALUE";
    SimulateRightClickModifier[SimulateRightClickModifier["kNone"] = 0] = "kNone";
    SimulateRightClickModifier[SimulateRightClickModifier["kAlt"] = 1] = "kAlt";
    SimulateRightClickModifier[SimulateRightClickModifier["kSearch"] = 2] = "kSearch";
})(SimulateRightClickModifier$1 || (SimulateRightClickModifier$1 = {}));

// ui/events/ash/mojom/six_pack_shortcut_modifier.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SixPackShortcutModifierSpec = { $: mojo.internal.Enum() };
var SixPackShortcutModifier$1;
(function (SixPackShortcutModifier) {
    SixPackShortcutModifier[SixPackShortcutModifier["MIN_VALUE"] = 0] = "MIN_VALUE";
    SixPackShortcutModifier[SixPackShortcutModifier["MAX_VALUE"] = 2] = "MAX_VALUE";
    SixPackShortcutModifier[SixPackShortcutModifier["kNone"] = 0] = "kNone";
    SixPackShortcutModifier[SixPackShortcutModifier["kAlt"] = 1] = "kAlt";
    SixPackShortcutModifier[SixPackShortcutModifier["kSearch"] = 2] = "kSearch";
})(SixPackShortcutModifier$1 || (SixPackShortcutModifier$1 = {}));

// ash/public/mojom/input_device_settings.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PolicyStatusSpec = { $: mojo.internal.Enum() };
var PolicyStatus$1;
(function (PolicyStatus) {
    PolicyStatus[PolicyStatus["MIN_VALUE"] = 0] = "MIN_VALUE";
    PolicyStatus[PolicyStatus["MAX_VALUE"] = 1] = "MAX_VALUE";
    PolicyStatus[PolicyStatus["kManaged"] = 0] = "kManaged";
    PolicyStatus[PolicyStatus["kRecommended"] = 1] = "kRecommended";
})(PolicyStatus$1 || (PolicyStatus$1 = {}));
const TopRowActionKeySpec = { $: mojo.internal.Enum() };
var TopRowActionKey$1;
(function (TopRowActionKey) {
    TopRowActionKey[TopRowActionKey["MIN_VALUE"] = 0] = "MIN_VALUE";
    TopRowActionKey[TopRowActionKey["MAX_VALUE"] = 25] = "MAX_VALUE";
    TopRowActionKey[TopRowActionKey["kNone"] = 0] = "kNone";
    TopRowActionKey[TopRowActionKey["kUnknown"] = 1] = "kUnknown";
    TopRowActionKey[TopRowActionKey["kBack"] = 2] = "kBack";
    TopRowActionKey[TopRowActionKey["kForward"] = 3] = "kForward";
    TopRowActionKey[TopRowActionKey["kRefresh"] = 4] = "kRefresh";
    TopRowActionKey[TopRowActionKey["kFullscreen"] = 5] = "kFullscreen";
    TopRowActionKey[TopRowActionKey["kOverview"] = 6] = "kOverview";
    TopRowActionKey[TopRowActionKey["kScreenshot"] = 7] = "kScreenshot";
    TopRowActionKey[TopRowActionKey["kScreenBrightnessDown"] = 8] = "kScreenBrightnessDown";
    TopRowActionKey[TopRowActionKey["kScreenBrightnessUp"] = 9] = "kScreenBrightnessUp";
    TopRowActionKey[TopRowActionKey["kMicrophoneMute"] = 10] = "kMicrophoneMute";
    TopRowActionKey[TopRowActionKey["kVolumeMute"] = 11] = "kVolumeMute";
    TopRowActionKey[TopRowActionKey["kVolumeDown"] = 12] = "kVolumeDown";
    TopRowActionKey[TopRowActionKey["kVolumeUp"] = 13] = "kVolumeUp";
    TopRowActionKey[TopRowActionKey["kKeyboardBacklightToggle"] = 14] = "kKeyboardBacklightToggle";
    TopRowActionKey[TopRowActionKey["kKeyboardBacklightDown"] = 15] = "kKeyboardBacklightDown";
    TopRowActionKey[TopRowActionKey["kKeyboardBacklightUp"] = 16] = "kKeyboardBacklightUp";
    TopRowActionKey[TopRowActionKey["kNextTrack"] = 17] = "kNextTrack";
    TopRowActionKey[TopRowActionKey["kPreviousTrack"] = 18] = "kPreviousTrack";
    TopRowActionKey[TopRowActionKey["kPlayPause"] = 19] = "kPlayPause";
    TopRowActionKey[TopRowActionKey["kAllApplications"] = 20] = "kAllApplications";
    TopRowActionKey[TopRowActionKey["kEmojiPicker"] = 21] = "kEmojiPicker";
    TopRowActionKey[TopRowActionKey["kDictation"] = 22] = "kDictation";
    TopRowActionKey[TopRowActionKey["kPrivacyScreenToggle"] = 23] = "kPrivacyScreenToggle";
    TopRowActionKey[TopRowActionKey["kAccessibility"] = 24] = "kAccessibility";
    TopRowActionKey[TopRowActionKey["kDoNotDisturb"] = 25] = "kDoNotDisturb";
})(TopRowActionKey$1 || (TopRowActionKey$1 = {}));
const ChargeStateSpec = { $: mojo.internal.Enum() };
var ChargeState$1;
(function (ChargeState) {
    ChargeState[ChargeState["MIN_VALUE"] = 0] = "MIN_VALUE";
    ChargeState[ChargeState["MAX_VALUE"] = 2] = "MAX_VALUE";
    ChargeState[ChargeState["kUnknown"] = 0] = "kUnknown";
    ChargeState[ChargeState["kCharging"] = 1] = "kCharging";
    ChargeState[ChargeState["kDischarging"] = 2] = "kDischarging";
})(ChargeState$1 || (ChargeState$1 = {}));
const CompanionAppStateSpec = { $: mojo.internal.Enum() };
var CompanionAppState$1;
(function (CompanionAppState) {
    CompanionAppState[CompanionAppState["MIN_VALUE"] = 0] = "MIN_VALUE";
    CompanionAppState[CompanionAppState["MAX_VALUE"] = 1] = "MAX_VALUE";
    CompanionAppState[CompanionAppState["kAvailable"] = 0] = "kAvailable";
    CompanionAppState[CompanionAppState["kInstalled"] = 1] = "kInstalled";
})(CompanionAppState$1 || (CompanionAppState$1 = {}));
const CustomizableButtonSpec = { $: mojo.internal.Enum() };
var CustomizableButton$1;
(function (CustomizableButton) {
    CustomizableButton[CustomizableButton["MIN_VALUE"] = 0] = "MIN_VALUE";
    CustomizableButton[CustomizableButton["MAX_VALUE"] = 8] = "MAX_VALUE";
    CustomizableButton[CustomizableButton["kLeft"] = 0] = "kLeft";
    CustomizableButton[CustomizableButton["kRight"] = 1] = "kRight";
    CustomizableButton[CustomizableButton["kMiddle"] = 2] = "kMiddle";
    CustomizableButton[CustomizableButton["kForward"] = 3] = "kForward";
    CustomizableButton[CustomizableButton["kBack"] = 4] = "kBack";
    CustomizableButton[CustomizableButton["kExtra"] = 5] = "kExtra";
    CustomizableButton[CustomizableButton["kSide"] = 6] = "kSide";
    CustomizableButton[CustomizableButton["kScrollLeft"] = 7] = "kScrollLeft";
    CustomizableButton[CustomizableButton["kScrollRight"] = 8] = "kScrollRight";
})(CustomizableButton$1 || (CustomizableButton$1 = {}));
const MouseButtonConfigSpec = { $: mojo.internal.Enum() };
var MouseButtonConfig$1;
(function (MouseButtonConfig) {
    MouseButtonConfig[MouseButtonConfig["MIN_VALUE"] = 0] = "MIN_VALUE";
    MouseButtonConfig[MouseButtonConfig["MAX_VALUE"] = 5] = "MAX_VALUE";
    MouseButtonConfig[MouseButtonConfig["kNoConfig"] = 0] = "kNoConfig";
    MouseButtonConfig[MouseButtonConfig["kFiveKey"] = 1] = "kFiveKey";
    MouseButtonConfig[MouseButtonConfig["kLogitechSixKey"] = 2] = "kLogitechSixKey";
    MouseButtonConfig[MouseButtonConfig["kLogitechSixKeyWithTab"] = 3] = "kLogitechSixKeyWithTab";
    MouseButtonConfig[MouseButtonConfig["kThreeKey"] = 4] = "kThreeKey";
    MouseButtonConfig[MouseButtonConfig["kFourKeyWithTopButton"] = 5] = "kFourKeyWithTopButton";
})(MouseButtonConfig$1 || (MouseButtonConfig$1 = {}));
const GraphicsTabletButtonConfigSpec = { $: mojo.internal.Enum() };
var GraphicsTabletButtonConfig$1;
(function (GraphicsTabletButtonConfig) {
    GraphicsTabletButtonConfig[GraphicsTabletButtonConfig["MIN_VALUE"] = 0] = "MIN_VALUE";
    GraphicsTabletButtonConfig[GraphicsTabletButtonConfig["MAX_VALUE"] = 3] = "MAX_VALUE";
    GraphicsTabletButtonConfig[GraphicsTabletButtonConfig["kNoConfig"] = 0] = "kNoConfig";
    GraphicsTabletButtonConfig[GraphicsTabletButtonConfig["kWacomStandardPenOnly"] = 1] = "kWacomStandardPenOnly";
    GraphicsTabletButtonConfig[GraphicsTabletButtonConfig["kWacomStandardFourButtons"] = 2] = "kWacomStandardFourButtons";
    GraphicsTabletButtonConfig[GraphicsTabletButtonConfig["kWacomStandardPenOnlyOneButton"] = 3] = "kWacomStandardPenOnlyOneButton";
})(GraphicsTabletButtonConfig$1 || (GraphicsTabletButtonConfig$1 = {}));
const StaticShortcutActionSpec = { $: mojo.internal.Enum() };
var StaticShortcutAction$1;
(function (StaticShortcutAction) {
    StaticShortcutAction[StaticShortcutAction["MIN_VALUE"] = 0] = "MIN_VALUE";
    StaticShortcutAction[StaticShortcutAction["MAX_VALUE"] = 11] = "MAX_VALUE";
    StaticShortcutAction[StaticShortcutAction["kDisable"] = 0] = "kDisable";
    StaticShortcutAction[StaticShortcutAction["kCopy"] = 1] = "kCopy";
    StaticShortcutAction[StaticShortcutAction["kPaste"] = 2] = "kPaste";
    StaticShortcutAction[StaticShortcutAction["kUndo"] = 3] = "kUndo";
    StaticShortcutAction[StaticShortcutAction["kRedo"] = 4] = "kRedo";
    StaticShortcutAction[StaticShortcutAction["kZoomIn"] = 5] = "kZoomIn";
    StaticShortcutAction[StaticShortcutAction["kZoomOut"] = 6] = "kZoomOut";
    StaticShortcutAction[StaticShortcutAction["kPreviousPage"] = 7] = "kPreviousPage";
    StaticShortcutAction[StaticShortcutAction["kNextPage"] = 8] = "kNextPage";
    StaticShortcutAction[StaticShortcutAction["kLeftClick"] = 9] = "kLeftClick";
    StaticShortcutAction[StaticShortcutAction["kRightClick"] = 10] = "kRightClick";
    StaticShortcutAction[StaticShortcutAction["kMiddleClick"] = 11] = "kMiddleClick";
})(StaticShortcutAction$1 || (StaticShortcutAction$1 = {}));
const CustomizationRestrictionSpec = { $: mojo.internal.Enum() };
var CustomizationRestriction$1;
(function (CustomizationRestriction) {
    CustomizationRestriction[CustomizationRestriction["MIN_VALUE"] = 0] = "MIN_VALUE";
    CustomizationRestriction[CustomizationRestriction["MAX_VALUE"] = 7] = "MAX_VALUE";
    CustomizationRestriction[CustomizationRestriction["kAllowCustomizations"] = 0] = "kAllowCustomizations";
    CustomizationRestriction[CustomizationRestriction["kDisallowCustomizations"] = 1] = "kDisallowCustomizations";
    CustomizationRestriction[CustomizationRestriction["kDisableKeyEventRewrites"] = 2] = "kDisableKeyEventRewrites";
    CustomizationRestriction[CustomizationRestriction["kAllowAlphabetKeyEventRewrites"] = 3] = "kAllowAlphabetKeyEventRewrites";
    CustomizationRestriction[CustomizationRestriction["kAllowAlphabetOrNumberKeyEventRewrites"] = 4] = "kAllowAlphabetOrNumberKeyEventRewrites";
    CustomizationRestriction[CustomizationRestriction["kAllowHorizontalScrollWheelRewrites"] = 5] = "kAllowHorizontalScrollWheelRewrites";
    CustomizationRestriction[CustomizationRestriction["kAllowTabEventRewrites"] = 6] = "kAllowTabEventRewrites";
    CustomizationRestriction[CustomizationRestriction["kAllowFKeyRewrites"] = 7] = "kAllowFKeyRewrites";
})(CustomizationRestriction$1 || (CustomizationRestriction$1 = {}));
const SixPackKeyInfoSpec = { $: {} };
const InputDeviceSettingsPolicySpec = { $: {} };
const InputDeviceSettingsFkeyPolicySpec = { $: {} };
const InputDeviceSettingsSixPackKeyPolicySpec = { $: {} };
const KeyboardPoliciesSpec = { $: {} };
const MousePoliciesSpec = { $: {} };
const BatteryInfoSpec = { $: {} };
const CompanionAppInfoSpec = { $: {} };
const KeyboardSpec = { $: {} };
const KeyboardSettingsSpec = { $: {} };
const MouseSpec = { $: {} };
const MouseSettingsSpec = { $: {} };
const TouchpadSpec = { $: {} };
const TouchpadSettingsSpec = { $: {} };
const PointingStickSpec = { $: {} };
const PointingStickSettingsSpec = { $: {} };
const StylusSpec = { $: {} };
const GraphicsTabletSpec = { $: {} };
const GraphicsTabletSettingsSpec = { $: {} };
const ButtonRemappingSpec = { $: {} };
const KeyEventSpec = { $: {} };
const RemappingActionSpec = { $: {} };
const ButtonSpec = { $: {} };
mojo.internal.Struct(SixPackKeyInfoSpec.$, 'SixPackKeyInfo', [
    mojo.internal.StructField('home', 0, 0, SixPackShortcutModifierSpec.$, SixPackShortcutModifier$1.kSearch, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pageUp', 4, 0, SixPackShortcutModifierSpec.$, SixPackShortcutModifier$1.kSearch, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pageDown', 8, 0, SixPackShortcutModifierSpec.$, SixPackShortcutModifier$1.kSearch, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('del', 12, 0, SixPackShortcutModifierSpec.$, SixPackShortcutModifier$1.kSearch, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('insert', 16, 0, SixPackShortcutModifierSpec.$, SixPackShortcutModifier$1.kSearch, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('end', 20, 0, SixPackShortcutModifierSpec.$, SixPackShortcutModifier$1.kSearch, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(InputDeviceSettingsPolicySpec.$, 'InputDeviceSettingsPolicy', [
    mojo.internal.StructField('policyStatus', 0, 0, PolicyStatusSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('value', 4, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDeviceSettingsFkeyPolicySpec.$, 'InputDeviceSettingsFkeyPolicy', [
    mojo.internal.StructField('policyStatus', 0, 0, PolicyStatusSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('value', 4, 0, ExtendedFkeysModifierSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDeviceSettingsSixPackKeyPolicySpec.$, 'InputDeviceSettingsSixPackKeyPolicy', [
    mojo.internal.StructField('policyStatus', 0, 0, PolicyStatusSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('value', 4, 0, SixPackShortcutModifierSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(KeyboardPoliciesSpec.$, 'KeyboardPolicies', [
    mojo.internal.StructField('topRowAreFkeysPolicy', 0, 0, InputDeviceSettingsPolicySpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('enableMetaFkeyRewritesPolicy', 8, 0, InputDeviceSettingsPolicySpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('f11KeyPolicy', 16, 0, InputDeviceSettingsFkeyPolicySpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('f12KeyPolicy', 24, 0, InputDeviceSettingsFkeyPolicySpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('homeAndEndKeysPolicy', 32, 0, InputDeviceSettingsSixPackKeyPolicySpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pageUpAndPageDownKeysPolicy', 40, 0, InputDeviceSettingsSixPackKeyPolicySpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('deleteKeyPolicy', 48, 0, InputDeviceSettingsSixPackKeyPolicySpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('insertKeyPolicy', 56, 0, InputDeviceSettingsSixPackKeyPolicySpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 72],]);
mojo.internal.Struct(MousePoliciesSpec.$, 'MousePolicies', [
    mojo.internal.StructField('swapRightPolicy', 0, 0, InputDeviceSettingsPolicySpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(BatteryInfoSpec.$, 'BatteryInfo', [
    mojo.internal.StructField('batteryPercentage', 0, 0, mojo.internal.Uint8, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('chargeState', 4, 0, ChargeStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CompanionAppInfoSpec.$, 'CompanionAppInfo', [
    mojo.internal.StructField('packageId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('appName', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('actionLink', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('iconUrl', 24, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('state', 32, 0, CompanionAppStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 48],]);
mojo.internal.Struct(KeyboardSpec.$, 'Keyboard', [
    mojo.internal.StructField('name', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isExternal', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('id', 12, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('deviceKey', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('metaKey', 24, 0, MetaKeySpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('modifierKeys', 32, 0, mojo.internal.Array(ModifierKeySpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('topRowActionKeys', 40, 0, mojo.internal.Array(TopRowActionKeySpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('settings', 48, 0, KeyboardSettingsSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('batteryInfo', 56, 0, BatteryInfoSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('appInfo', 64, 0, CompanionAppInfoSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 80],]);
mojo.internal.Struct(KeyboardSettingsSpec.$, 'KeyboardSettings', [
    mojo.internal.StructField('modifierRemappings', 0, 0, mojo.internal.Map(ModifierKeySpec.$, ModifierKeySpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('topRowAreFkeys', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('suppressMetaFkeyRewrites', 8, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('sixPackKeyRemappings', 16, 0, SixPackKeyInfoSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('f11_$flag', 8, 2, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "f11_$value",
        originalFieldName: "f11",
    }, undefined),
    mojo.internal.StructField('f11_$value', 12, 0, ExtendedFkeysModifierSpec.$, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "f11",
    }, undefined),
    mojo.internal.StructField('f12_$flag', 8, 3, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "f12_$value",
        originalFieldName: "f12",
    }, undefined),
    mojo.internal.StructField('f12_$value', 24, 0, ExtendedFkeysModifierSpec.$, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "f12",
    }, undefined),
], [[0, 40],]);
mojo.internal.Struct(MouseSpec.$, 'Mouse', [
    mojo.internal.StructField('name', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isExternal', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('id', 12, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('deviceKey', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('customizationRestriction', 24, 0, CustomizationRestrictionSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('mouseButtonConfig', 28, 0, MouseButtonConfigSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('settings', 32, 0, MouseSettingsSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('batteryInfo', 40, 0, BatteryInfoSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('appInfo', 48, 0, CompanionAppInfoSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 64],]);
mojo.internal.Struct(MouseSettingsSpec.$, 'MouseSettings', [
    mojo.internal.StructField('swapRight', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('sensitivity', 1, 0, mojo.internal.Uint8, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('reverseScrolling', 0, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('accelerationEnabled', 0, 2, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('scrollSensitivity', 2, 0, mojo.internal.Uint8, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('scrollAcceleration', 0, 3, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('buttonRemappings', 8, 0, mojo.internal.Array(ButtonRemappingSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(TouchpadSpec.$, 'Touchpad', [
    mojo.internal.StructField('name', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isExternal', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('id', 12, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('deviceKey', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isHaptic', 8, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('settings', 24, 0, TouchpadSettingsSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('batteryInfo', 32, 0, BatteryInfoSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('appInfo', 40, 0, CompanionAppInfoSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 56],]);
mojo.internal.Struct(TouchpadSettingsSpec.$, 'TouchpadSettings', [
    mojo.internal.StructField('sensitivity', 0, 0, mojo.internal.Uint8, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('reverseScrolling', 1, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('accelerationEnabled', 1, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('tapToClickEnabled', 1, 2, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('threeFingerClickEnabled', 1, 3, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('tapDraggingEnabled', 1, 4, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('scrollSensitivity', 2, 0, mojo.internal.Uint8, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('scrollAcceleration', 1, 5, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hapticSensitivity', 3, 0, mojo.internal.Uint8, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hapticEnabled', 1, 6, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('simulateRightClick', 4, 0, SimulateRightClickModifierSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PointingStickSpec.$, 'PointingStick', [
    mojo.internal.StructField('name', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isExternal', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('id', 12, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('deviceKey', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('settings', 24, 0, PointingStickSettingsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(PointingStickSettingsSpec.$, 'PointingStickSettings', [
    mojo.internal.StructField('swapRight', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('sensitivity', 1, 0, mojo.internal.Uint8, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('accelerationEnabled', 0, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(StylusSpec.$, 'Stylus', [], [[0, 8],]);
mojo.internal.Struct(GraphicsTabletSpec.$, 'GraphicsTablet', [
    mojo.internal.StructField('name', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('id', 8, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('deviceKey', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('customizationRestriction', 12, 0, CustomizationRestrictionSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('graphicsTabletButtonConfig', 24, 0, GraphicsTabletButtonConfigSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('settings', 32, 0, GraphicsTabletSettingsSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('batteryInfo', 40, 0, BatteryInfoSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('appInfo', 48, 0, CompanionAppInfoSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 64],]);
mojo.internal.Struct(GraphicsTabletSettingsSpec.$, 'GraphicsTabletSettings', [
    mojo.internal.StructField('tabletButtonRemappings', 0, 0, mojo.internal.Array(ButtonRemappingSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('penButtonRemappings', 8, 0, mojo.internal.Array(ButtonRemappingSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ButtonRemappingSpec.$, 'ButtonRemapping', [
    mojo.internal.StructField('name', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('button', 8, 0, ButtonSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('remappingAction', 24, 0, RemappingActionSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 48],]);
mojo.internal.Struct(KeyEventSpec.$, 'KeyEvent', [
    mojo.internal.StructField('vkey', 0, 0, VKeySpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('domCode', 4, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('domKey', 8, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('modifiers', 12, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('keyDisplay', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Union(RemappingActionSpec.$, 'RemappingAction', {
    'acceleratorAction': {
        'ordinal': 0,
        'type': AcceleratorActionSpec.$,
    },
    'keyEvent': {
        'ordinal': 1,
        'type': KeyEventSpec.$,
    },
    'staticShortcutAction': {
        'ordinal': 2,
        'type': StaticShortcutActionSpec.$,
    },
});
var RemappingActionFieldTags;
(function (RemappingActionFieldTags) {
    RemappingActionFieldTags[RemappingActionFieldTags["ACCELERATOR_ACTION"] = 0] = "ACCELERATOR_ACTION";
    RemappingActionFieldTags[RemappingActionFieldTags["KEY_EVENT"] = 1] = "KEY_EVENT";
    RemappingActionFieldTags[RemappingActionFieldTags["STATIC_SHORTCUT_ACTION"] = 2] = "STATIC_SHORTCUT_ACTION";
})(RemappingActionFieldTags || (RemappingActionFieldTags = {}));
mojo.internal.Union(ButtonSpec.$, 'Button', {
    'vkey': {
        'ordinal': 0,
        'type': VKeySpec.$,
    },
    'customizableButton': {
        'ordinal': 1,
        'type': CustomizableButtonSpec.$,
    },
});
var ButtonFieldTags;
(function (ButtonFieldTags) {
    ButtonFieldTags[ButtonFieldTags["VKEY"] = 0] = "VKEY";
    ButtonFieldTags[ButtonFieldTags["CUSTOMIZABLE_BUTTON"] = 1] = "CUSTOMIZABLE_BUTTON";
})(ButtonFieldTags || (ButtonFieldTags = {}));

// chrome/browser/ui/webui/ash/settings/pages/device/input_device_settings/input_device_settings_provider.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class KeyboardSettingsObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.mojom.KeyboardSettingsObserver', scope);
    }
}
class KeyboardSettingsObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(KeyboardSettingsObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onKeyboardListUpdated(keyboards) {
        this.proxy.sendMessage(0, KeyboardSettingsObserver_OnKeyboardListUpdated_ParamsSpec.$, null, [
            keyboards
        ], false);
    }
    onKeyboardPoliciesUpdated(policies) {
        this.proxy.sendMessage(1, KeyboardSettingsObserver_OnKeyboardPoliciesUpdated_ParamsSpec.$, null, [
            policies
        ], false);
    }
}
/**
 * An object which receives request messages for the KeyboardSettingsObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
class KeyboardSettingsObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(KeyboardSettingsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, KeyboardSettingsObserver_OnKeyboardListUpdated_ParamsSpec.$, null, impl.onKeyboardListUpdated.bind(impl), false);
        this.helper_internal_.registerHandler(1, KeyboardSettingsObserver_OnKeyboardPoliciesUpdated_ParamsSpec.$, null, impl.onKeyboardPoliciesUpdated.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
class TouchpadSettingsObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.mojom.TouchpadSettingsObserver', scope);
    }
}
class TouchpadSettingsObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(TouchpadSettingsObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onTouchpadListUpdated(touchpads) {
        this.proxy.sendMessage(0, TouchpadSettingsObserver_OnTouchpadListUpdated_ParamsSpec.$, null, [
            touchpads
        ], false);
    }
}
/**
 * An object which receives request messages for the TouchpadSettingsObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
class TouchpadSettingsObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(TouchpadSettingsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, TouchpadSettingsObserver_OnTouchpadListUpdated_ParamsSpec.$, null, impl.onTouchpadListUpdated.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
class PointingStickSettingsObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.mojom.PointingStickSettingsObserver', scope);
    }
}
class PointingStickSettingsObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PointingStickSettingsObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onPointingStickListUpdated(pointSticks) {
        this.proxy.sendMessage(0, PointingStickSettingsObserver_OnPointingStickListUpdated_ParamsSpec.$, null, [
            pointSticks
        ], false);
    }
}
/**
 * An object which receives request messages for the PointingStickSettingsObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
class PointingStickSettingsObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PointingStickSettingsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PointingStickSettingsObserver_OnPointingStickListUpdated_ParamsSpec.$, null, impl.onPointingStickListUpdated.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
class MouseSettingsObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.mojom.MouseSettingsObserver', scope);
    }
}
class MouseSettingsObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(MouseSettingsObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onMouseListUpdated(mice) {
        this.proxy.sendMessage(0, MouseSettingsObserver_OnMouseListUpdated_ParamsSpec.$, null, [
            mice
        ], false);
    }
    onMousePoliciesUpdated(policies) {
        this.proxy.sendMessage(1, MouseSettingsObserver_OnMousePoliciesUpdated_ParamsSpec.$, null, [
            policies
        ], false);
    }
}
/**
 * An object which receives request messages for the MouseSettingsObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
class MouseSettingsObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MouseSettingsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, MouseSettingsObserver_OnMouseListUpdated_ParamsSpec.$, null, impl.onMouseListUpdated.bind(impl), false);
        this.helper_internal_.registerHandler(1, MouseSettingsObserver_OnMousePoliciesUpdated_ParamsSpec.$, null, impl.onMousePoliciesUpdated.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
class ButtonPressObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.mojom.ButtonPressObserver', scope);
    }
}
class ButtonPressObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ButtonPressObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onButtonPressed(button) {
        this.proxy.sendMessage(0, ButtonPressObserver_OnButtonPressed_ParamsSpec.$, null, [
            button
        ], false);
    }
}
/**
 * An object which receives request messages for the ButtonPressObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
class ButtonPressObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ButtonPressObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ButtonPressObserver_OnButtonPressed_ParamsSpec.$, null, impl.onButtonPressed.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
class GraphicsTabletSettingsObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.mojom.GraphicsTabletSettingsObserver', scope);
    }
}
class GraphicsTabletSettingsObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(GraphicsTabletSettingsObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onGraphicsTabletListUpdated(graphicsTablets) {
        this.proxy.sendMessage(0, GraphicsTabletSettingsObserver_OnGraphicsTabletListUpdated_ParamsSpec.$, null, [
            graphicsTablets
        ], false);
    }
}
/**
 * An object which receives request messages for the GraphicsTabletSettingsObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
class GraphicsTabletSettingsObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(GraphicsTabletSettingsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, GraphicsTabletSettingsObserver_OnGraphicsTabletListUpdated_ParamsSpec.$, null, impl.onGraphicsTabletListUpdated.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
class KeyboardBrightnessObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.mojom.KeyboardBrightnessObserver', scope);
    }
}
class KeyboardBrightnessObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(KeyboardBrightnessObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onKeyboardBrightnessChanged(brightnessPercent) {
        this.proxy.sendMessage(0, KeyboardBrightnessObserver_OnKeyboardBrightnessChanged_ParamsSpec.$, null, [
            brightnessPercent
        ], false);
    }
}
/**
 * An object which receives request messages for the KeyboardBrightnessObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
class KeyboardBrightnessObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(KeyboardBrightnessObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, KeyboardBrightnessObserver_OnKeyboardBrightnessChanged_ParamsSpec.$, null, impl.onKeyboardBrightnessChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
class KeyboardAmbientLightSensorObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.mojom.KeyboardAmbientLightSensorObserver', scope);
    }
}
class KeyboardAmbientLightSensorObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(KeyboardAmbientLightSensorObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onKeyboardAmbientLightSensorEnabledChanged(keyboardAmbientLightSensorEnabled) {
        this.proxy.sendMessage(0, KeyboardAmbientLightSensorObserver_OnKeyboardAmbientLightSensorEnabledChanged_ParamsSpec.$, null, [
            keyboardAmbientLightSensorEnabled
        ], false);
    }
}
/**
 * An object which receives request messages for the KeyboardAmbientLightSensorObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
class KeyboardAmbientLightSensorObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(KeyboardAmbientLightSensorObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, KeyboardAmbientLightSensorObserver_OnKeyboardAmbientLightSensorEnabledChanged_ParamsSpec.$, null, impl.onKeyboardAmbientLightSensorEnabledChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
class LidStateObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.mojom.LidStateObserver', scope);
    }
}
class LidStateObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(LidStateObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onLidStateChanged(isLidOpen) {
        this.proxy.sendMessage(0, LidStateObserver_OnLidStateChanged_ParamsSpec.$, null, [
            isLidOpen
        ], false);
    }
}
/**
 * An object which receives request messages for the LidStateObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
class LidStateObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(LidStateObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, LidStateObserver_OnLidStateChanged_ParamsSpec.$, null, impl.onLidStateChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
class InputDeviceSettingsProviderPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.mojom.InputDeviceSettingsProvider', scope);
    }
}
class InputDeviceSettingsProviderRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(InputDeviceSettingsProviderPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    observeKeyboardSettings(observer) {
        this.proxy.sendMessage(0, InputDeviceSettingsProvider_ObserveKeyboardSettings_ParamsSpec.$, null, [
            observer
        ], false);
    }
    observeTouchpadSettings(observer) {
        this.proxy.sendMessage(1, InputDeviceSettingsProvider_ObserveTouchpadSettings_ParamsSpec.$, null, [
            observer
        ], false);
    }
    observePointingStickSettings(observer) {
        this.proxy.sendMessage(2, InputDeviceSettingsProvider_ObservePointingStickSettings_ParamsSpec.$, null, [
            observer
        ], false);
    }
    observeMouseSettings(observer) {
        this.proxy.sendMessage(3, InputDeviceSettingsProvider_ObserveMouseSettings_ParamsSpec.$, null, [
            observer
        ], false);
    }
    observeGraphicsTabletSettings(observer) {
        this.proxy.sendMessage(4, InputDeviceSettingsProvider_ObserveGraphicsTabletSettings_ParamsSpec.$, null, [
            observer
        ], false);
    }
    observeButtonPresses(observer) {
        this.proxy.sendMessage(5, InputDeviceSettingsProvider_ObserveButtonPresses_ParamsSpec.$, null, [
            observer
        ], false);
    }
    observeKeyboardBrightness(observer) {
        this.proxy.sendMessage(6, InputDeviceSettingsProvider_ObserveKeyboardBrightness_ParamsSpec.$, null, [
            observer
        ], false);
    }
    observeKeyboardAmbientLightSensor(observer) {
        this.proxy.sendMessage(7, InputDeviceSettingsProvider_ObserveKeyboardAmbientLightSensor_ParamsSpec.$, null, [
            observer
        ], false);
    }
    observeLidState(observer) {
        return this.proxy.sendMessage(8, InputDeviceSettingsProvider_Observe