import"chrome://os-settings/strings.m.js";import{D as DeepLinkingMixin,R as RouteOriginMixin,P as PrefsMixin,S as Setting,r as routes,C as CrostiniBrowserProxyImpl,a as Router,c as castExists,b as recordSettingChange,d as assertNotReached,e as RouteObserverMixin,W as WebUiListenerMixin,I as I18nMixin,f as CrPolicyIndicatorType,V as VmType,g as cast,h as DEFAULT_CROSTINI_GUEST_ID,i as DEFAULT_CROSTINI_VM,j as DEFAULT_BAGUETTE_GUEST_ID,k as DEFAULT_CROSTINI_CONTAINER,l as VM_DEVICE_MICROPHONE,m as assert,n as PortState,M as MIN_VALID_PORT_NUMBER,o as MAX_VALID_PORT_NUMBER,p as DEFAULT_CROSTINI_VM_TYPE,G as GuestOsBrowserProxyImpl,q as assertExists,s as getVMNameForGuestOsType,t as CrToggleElement,T as TERMINA_VM_TYPE,u as GeolocationAccessLevel,L as LOCATION_PERMISSION_CHANGE_FROM_DIALOG_HISTOGRAM_NAME,v as DateTimeBrowserProxy,w as isChild,A as AudioEffectType,x as getCrosAudioConfig,y as AudioSystemPropertiesObserverReceiver,z as DevicePageBrowserProxyImpl,B as MuteState,E as AudioEffectState,F as FakeCrosAudioConfig,H as AudioDeviceType,J as strictQuery,K as SettingsRadioGroupElement,N as PolicyStatus$1,O as getInputDeviceSettingsProvider,Q as MetaKey$2,U as getInstance,X as MouseButtonConfig$1,Y as GraphicsTabletButtonConfig$1,Z as getDisplayApi,_ as IronResizableBehavior,$ as getDisplaySettingsProvider,a0 as PrivacyHubBrowserProxyImpl,a1 as DisplaySettingsType,a2 as TabletModeObserverReceiver,a3 as DisplayBrightnessSettingsObserverReceiver,a4 as AmbientLightSensorObserverReceiver,a5 as DisplayConfigurationObserverReceiver,a6 as isDisplayBrightnessControlInSettingsEnabled,a7 as DisplaySettingsOrientationOption,a8 as focusWithoutInk$1,a9 as CrSliderElement,aa as BatteryType,ab as CompanionAppState$1,ac as CrLinkRowElement,ad as PersonalizationHubBrowserProxyImpl,ae as KeyboardBrightnessObserverReceiver,af as KeyboardAmbientLightSensorObserverReceiver,ag as LidStateObserverReceiver,ah as SixPackShortcutModifier$1,ai as ModifierKey$2,aj as Fkey,ak as ExtendedFkeysModifier$1,al as TopRowActionKey$1,am as SixPackKey,an as CustomizationRestriction$1,ao as SimulateRightClickModifier$1,ap as FakeInputDeviceSettingsProvider,aq as MouseSettingsObserverReceiver,ar as assertExhaustive,as as OptimizedChargingStrategy,at as CrPolicyPrefMixin,au as isBatteryChargeLimitAvailable,av as LidClosedBehavior,aw as IdleBehavior,ax as isExternalStorageEnabled,ay as isSkyVaultEnabled,az as isCrostiniSupported,aA as StorageSpaceState,aB as castExists$1,aC as isRTL$1,aD as I18nBehavior,aE as CrPolicyNetworkBehaviorMojo,aF as OncMojo,aG as assert$1,aH as FAKE_CREDENTIAL,aI as isActiveSim,aJ as NetworkListenerBehavior,aK as InternetPageBrowserProxyImpl,aL as processDeviceState,aM as isCarrierLockedActiveSim,aN as getApnDisplayName,aO as shouldDisallowNetworkModifications,aP as assertInstanceof,aQ as getESimProfileProperties,aR as CellularSetupPageName,aS as CrPolicyIndicatorType$1,aT as CrScrollableMixin,aU as ESimManagerListenerMixin,aV as MultiDeviceBrowserProxyImpl,aW as getEuicc,aX as getSimSlotCount,aY as MultiDeviceFeatureState,aZ as BrowserProxy,a_ as getImage,a$ as MultiDeviceFeatureMixin,b0 as MultiDeviceFeature,b1 as PhoneHubPermissionsSetupFeatureCombination,b2 as sanitizeInnerHtml,b3 as SyncBrowserProxyImpl,b4 as MultiDeviceSettingsMode,b5 as PhoneHubFeatureAccessProhibitedReason,b6 as ChromeVoxSubpageBrowserProxyImpl,b7 as __decorate,b8 as mixinDelegatesAria,b9 as redispatchEvent,ba as EventTracker$1,bb as FaceGazeSubpageBrowserProxyImpl,bc as getShortcutInputProvider,bd as SettingsToggleButtonElement,be as FindShortcutMixin,bf as SelectToSpeakSubpageBrowserProxyImpl,bg as LanguagesBrowserProxyImpl,bh as SwitchAccessSubpageBrowserProxyImpl,bi as TextToSpeechSubpageBrowserProxyImpl,bj as TtsVoiceSubpageBrowserProxyImpl,bk as BrowserChannel,bl as AboutPageBrowserProxyImpl,bm as isTargetChannelMoreStable,bn as DeviceNameBrowserProxyImpl,bo as SetDeviceNameResult,bp as browserChannelToI18nId,bq as DeviceNameState,br as AndroidAppsBrowserProxyImpl,bs as PromiseResolver,bt as AppManagementStoreMixin,bu as AppManagementBrowserProxy,bv as recordAppManagementUserAction,bw as AppManagementUserAction,bx as getSubAppsOfSelectedApp,by as getParentApp,bz as openAppDetailPage,bA as PrivacyHubMixin,bB as MediaDevicesProxy,bC as isSensorAvailable,bD as getPermission,bE as getPermissionValueBool,bF as isBoolValue,bG as getBoolPermissionValue,bH as isTriStateValue,bI as getTriStatePermissionValue,bJ as createBoolPermission,bK as createTriStatePermission,bL as getPermissionDescriptionString,bM as getSelectedApp,bN as AppLanguageSelectionDialogEntryPoint,bO as PluginVmBrowserProxyImpl,bP as updateSelectedAppId,bQ as openMainPage,bR as AppManagementEntryPointsHistogramName,bS as AppManagementEntryPoint,bT as getAppIcon,bU as AppManagementStore,bV as alphabeticalSort$1,bW as getAppNotificationProvider,bX as isPermissionEnabled,bY as createBoolPermissionValue,bZ as createTriStatePermissionValue,b_ as AppNotificationsObserverReceiver,b$ as isAppInstalled,c0 as getAppParentalControlsProvider,c1 as AppParentalControlsObserverReceiver,c2 as getDeviceNameUnsafe,c3 as hasTrueWirelessImages,c4 as getBatteryPercentage,c5 as hasDefaultImage,c6 as hasAnyDetailedBatteryInfo,c7 as OsBluetoothDevicesSubpageBrowserProxyImpl,c8 as recordBluetoothUiSurfaceMetrics,c9 as BluetoothUiSurface,ca as recordSavedDevicesUiEventMetrics,cb as FastPairSavedDevicesUiEvent,cc as FocusRowMixin,cd as FastPairSavedDevicesOptInStatus,ce as GoogleDriveBrowserProxy,cf as Stage,cg as OneDriveBrowserProxy,ch as GlobalScrollTargetMixin,ci as OsSettingsSubpageElement,cj as ACCESSIBILITY_COMMON_IME_ID,ck as IronA11yKeysBehavior,cl as AcceleratorActionSpec$1,cm as StandardAcceleratorPropertiesSpec,cn as MetaKeySpec$1,co as AcceleratorAction$1,cp as LifetimeBrowserProxyImpl,cq as fireAuthTokenInvalidEvent,cr as LockStateMixin,cs as assertInstanceof$1,ct as CrInputElement,cu as CrButtonElement,cv as CrDialogElement,cw as CrIconButtonElement,cx as CrActionMenuElement,cy as recordLockScreenProgress,cz as LockScreenProgress,cA as PageStatus,cB as SignedInState,cC as StatusAction,cD as PrinterSetupResult,cE as PrintServerResult,cF as CupsPrintersBrowserProxyImpl,cG as getAppPermissionProvider,cH as AppPermissionsObserverReceiver,cI as CAMERA_SUBPAGE_USER_ACTION_HISTOGRAM_NAME,cJ as PrivacyHubSensorSubpageUserAction,cK as NUMBER_OF_POSSIBLE_USER_ACTIONS,cL as isSecondaryUser,cM as MICROPHONE_SUBPAGE_USER_ACTION_HISTOGRAM_NAME,cN as StaticShortcutAction$1,cO as ButtonPressObserverReceiver,cP as AcceleratorKeyState}from"./shared.rollup.js";export{dh as AccountManagerBrowserProxyImpl,c$ as ApnSubpageElement,cS as AppLanguageSelectionDialogElement,cT as AppLanguageSelectionItemElement,d3 as AppManagementSupportedLinksItemElement,d4 as AppManagementSupportedLinksOverlappingAppsDialogElement,d5 as AppManagementUninstallButtonElement,d6 as AppSetupPinDialogElement,d7 as AppSetupPinKeyboardElement,d8 as AppVerifyPinDialogElement,cZ as CROSTINI_TYPE,cU as CrostiniPortProtocol,cV as CrostiniSettingsCardElement,cW as DateTimeSettingsCardElement,de as FilesSettingsCardElement,di as GraduationSettingsCardElement,df as LanguageSettingsCardElement,d1 as NearbyShareReceiveDialogElement,dr as OsResetBrowserProxyImpl,dq as OsSettingsPowerwashDialogElement,ds as OsSettingsSanitizeDialogElement,c_ as PLUGIN_VM_TYPE,d9 as ParentalControlsDialogAction,da as ParentalControlsPinDialogError,dj as PrintingSettingsCardElement,dt as ResetSettingsCardElement,dp as SecureDnsInputElement,dm as SecureDnsResolverType,db as SettingsBluetoothDevicesSubpageElement,dg as SettingsLanguagesElement,d0 as SettingsMultideviceFeatureToggleElement,d2 as SettingsNearbyShareSubpageElement,dc as SettingsPairedBluetoothListElement,dd as SettingsPairedBluetoothListItemElement,dk as SettingsPrivacyHubGeolocationSubpage,dl as SettingsPrivacyHubSubpage,dn as SettingsSecureDnsElement,cQ as SmbBrowserProxyImpl,cR as SmbMountResult,cX as TimezoneSelectorElement,cY as setShortcutInputProviderForTesting}from"./shared.rollup.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{html,PolymerElement,microTask,dedupingMixin,mixinBehaviors,flush,afterNextRender,calculateSplices,templatize,Polymer}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{DeviceType,AudioOutputCapability,DeviceConnectionState}from"chrome://resources/mojo/chromeos/ash/services/bluetooth_config/public/mojom/cros_bluetooth_config.mojom-webui.js";import{sendWithPromise,addWebUiListener,removeWebUiListener}from"chrome://resources/js/cr.js";import{css,LitElement,html as html$1,nothing,classMap,styleMap,customElement,property,isServer,query}from"chrome://resources/mwc/lit/index.js";import{getHotspotConfig}from"chrome://resources/ash/common/hotspot/cros_hotspot_config.js";import{HotspotState,HotspotAllowStatus,SetHotspotConfigResult}from"chrome://resources/ash/common/hotspot/cros_hotspot_config.mojom-webui.js";import{loadTimeData as loadTimeData$1}from"chrome://resources/ash/common/load_time_data.m.js";import{OncSource,PolicySource,ConnectionStateType,NetworkType,IPConfigType,PortalState,DeviceStateType}from"chrome://resources/mojo/chromeos/services/network_config/public/mojom/network_types.mojom-webui.js";import{ApnState,ApnAuthenticationType,ApnIpType,ApnType,ApnSource,NO_ROUTING_PREFIX,FilterType,NO_LIMIT,HiddenSsidMode,VpnType,ActivationStateType,SecurityType,MatchType,InhibitReason,AlwaysOnVpnMode}from"chrome://resources/mojo/chromeos/services/network_config/public/mojom/cros_network_config.mojom-webui.js";import{MojoInterfaceProviderImpl}from"chrome://resources/ash/common/network/mojo_interface_provider.js";import{MojoConnectivityProvider}from"chrome://resources/ash/common/connectivity/mojo_connectivity_provider.js";import{PasspointEventsListenerReceiver}from"chrome://resources/ash/common/connectivity/passpoint.mojom-webui.js";import{ProfileInstallResult,ProfileState}from"chrome://resources/mojo/chromeos/ash/services/cellular_setup/public/mojom/esim_manager.mojom-webui.js";import{AppType,InstallReason,InstallSource,PermissionType,TriState}from"chrome://resources/cr_components/app_management/app_management.mojom-webui.js";import{mojo}from"chrome://resources/mojo/mojo/public/js/bindings.js";import{getBluetoothConfig}from"chrome://resources/ash/common/bluetooth/cros_bluetooth_config.js";import{ConfigureResult,PasswordFactorEditor,PasswordComplexity,FactorObserverReceiver,AuthFactorConfig,AuthFactor,PinFactorEditor,ManagementType}from"chrome://resources/mojo/chromeos/ash/services/auth_factor_config/public/mojom/auth_factor_config.mojom-webui.js";import"chrome://resources/ash/common/cellular_setup/mojo_interface_provider.js";import"chrome://resources/mojo/chromeos/ash/services/nearby/public/mojom/nearby_share_settings.mojom-webui.js";import"chrome://resources/mojo/chromeos/ash/services/nearby/public/mojom/nearby_share_target_types.mojom-webui.js";import"chrome://resources/ash/common/bluetooth/hid_preserving_bluetooth_state_controller.js";import"chrome://resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js";import"chrome://resources/mojo/mojo/public/mojom/base/time.mojom-webui.js";function getTemplate$3s(){return html`<!--_html_template_start_--><style include="settings-shared"></style>
<cr-dialog id="dialog" show-on-attach close-text="$i18n{close}"
    on-cancel="onDialogCancel_" on-close="onDialogClose_">
  <!-- Pass through the "body" slot. -->
  <div slot="body"><slot name="body"></slot></div>
  <div slot="button-container">
    <cr-button class="cancel-button" on-click="onCancelClick_">
      [[cancelButtonText]]
    </cr-button>
    <cr-button class="action-button" on-click="onAcceptClick_">
      [[acceptButtonText]]
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class SettingsGuestOsConfirmationDialogElement extends PolymerElement{static get is(){return"settings-guest-os-confirmation-dialog"}static get template(){return getTemplate$3s()}static get properties(){return{acceptButtonText:String,cancelButtonText:{type:String,value:loadTimeData.getString("cancel")}}}constructor(){super();this.accepted_=true}onCancelClick_(){this.$.dialog.cancel()}onAcceptClick_(){this.$.dialog.close()}onDialogCancel_(){this.accepted_=false}onDialogClose_(e){e.stopPropagation();const closeEvent=new CustomEvent("close",{bubbles:true,composed:true,detail:{accepted:this.accepted_}});this.dispatchEvent(closeEvent)}}customElements.define(SettingsGuestOsConfirmationDialogElement.is,SettingsGuestOsConfirmationDialogElement);function getTemplate$3r(){return html`<!--_html_template_start_--><style include="settings-shared"></style>
<cr-link-row
    class="hr"
    label="$i18n{guestOsSharedUsbDevicesLabel}"
    id="bruschettaSharedUsbDevicesRow"
    on-click="onSharedUsbDevicesClick_"
    role-description="$i18n{subpageArrowRoleDescription}">
</cr-link-row>

<cr-link-row
    class="hr"
    label="$i18n{guestOsSharedPaths}"
    id="bruschettaSharedPathsRow"
    on-click="onSharedPathsClick_"
    role-description="$i18n{subpageArrowRoleDescription}">
</cr-link-row>

<settings-toggle-button
    class="hr"
    id="bruschetta-mic-permission-toggle"
    pref="{{prefs.bruschetta.mic_allowed}}"
    no-set-pref
    label="$i18n{bruschettaMicTitle}"
    on-settings-boolean-control-change="onMicPermissionChange_"
    deep-link-focus-id$="[[Setting.kBruschettaMicAccess]]">
</settings-toggle-button>
<template is="dom-if" if="[[showBruschettaMicPermissionDialog_]]" restamp>
  <settings-guest-os-confirmation-dialog
      id="bruschetta-mic-permission-dialog"
      accept-button-text="$i18n{bruschettaMicDialogShutdownButton}"
      on-close="onBruschettaMicPermissionDialogClose_">
    <div slot="body">$i18n{bruschettaMicDialogLabel}</div>
  </settings-guest-os-confirmation-dialog>
</template>
<div id="remove" class="settings-box">
  <div id="removeBruschettaLabel" class="start" aria-hidden="true">
    $i18n{bruschettaRemove}
  </div>
  <cr-button on-click="onRemoveClick_"
      aria-label="$i18n{bruschettaRemoveButton}"
      aria-describedby="removeBruschettaLabel">
    $i18n{bruschettaRemoveButton}
  </cr-button>
</div>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const BruschettaSubpageElementBase=DeepLinkingMixin(RouteOriginMixin(PrefsMixin(PolymerElement)));class BruschettaSubpageElement extends BruschettaSubpageElementBase{static get is(){return"settings-bruschetta-subpage"}static get template(){return getTemplate$3r()}static get properties(){return{showBruschettaMicPermissionDialog_:{type:Boolean,value:false}}}static get observers(){return["onInstalledChanged_(prefs.bruschetta.installed.value)"]}constructor(){super();this.supportedSettingIds=new Set([Setting.kBruschettaMicAccess]);this.route=routes.BRUSCHETTA_DETAILS;this.browserProxy_=CrostiniBrowserProxyImpl.getInstance()}ready(){super.ready();this.addFocusConfig(routes.BRUSCHETTA_SHARED_USB_DEVICES,"#bruschettaSharedUsbDevicesRow");this.addFocusConfig(routes.BRUSCHETTA_SHARED_PATHS,"#bruschettaSharedPathsRow")}onSharedUsbDevicesClick_(){Router.getInstance().navigateTo(routes.BRUSCHETTA_SHARED_USB_DEVICES)}onSharedPathsClick_(){Router.getInstance().navigateTo(routes.BRUSCHETTA_SHARED_PATHS)}onRemoveClick_(){this.browserProxy_.requestBruschettaUninstallerView()}onInstalledChanged_(installed){if(!installed&&Router.getInstance().currentRoute===routes.BRUSCHETTA_DETAILS){Router.getInstance().navigateToPreviousRoute()}}getMicToggle_(){return castExists(this.shadowRoot.querySelector("#bruschetta-mic-permission-toggle"))}async onMicPermissionChange_(){if(await this.browserProxy_.checkBruschettaIsRunning()){this.showBruschettaMicPermissionDialog_=true}else{this.getMicToggle_().sendPrefChange()}}onBruschettaMicPermissionDialogClose_(e){const toggle=this.getMicToggle_();if(e.detail.accepted){toggle.sendPrefChange();this.browserProxy_.shutdownBruschetta()}else{toggle.resetToPrefValue()}this.showBruschettaMicPermissionDialog_=false}}customElements.define(BruschettaSubpageElement.is,BruschettaSubpageElement);function getTemplate$3q(){return html`<!--_html_template_start_--><style include="settings-shared"></style>
<cr-dialog id="dialog" close-text="$i18n{close}">
  <div slot="title" hidden="[[!isEnabling_(action)]]">
    $i18n{crostiniArcAdbConfirmationTitleEnable}
  </div>
  <div slot="title" hidden="[[!isDisabling_(action)]]">
    $i18n{crostiniArcAdbConfirmationTitleDisable}
  </div>
  <div slot="body" hidden="[[!isEnabling_(action)]]">
    $i18n{crostiniArcAdbConfirmationMessageEnable}
  </div>
  <div slot="body" hidden="[[!isDisabling_(action)]]">
    $i18n{crostiniArcAdbConfirmationMessageDisable}
  </div>
  <div slot="button-container">
    <cr-button id="cancel" class="cancel-button" on-click="onCancelClick_">
      $i18n{cancel}
    </cr-button>
    <cr-button id="continue" class="action-button" on-click="onRestartClick_">
      $i18n{crostiniArcAdbRestartButton}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class SettingsCrostiniArcAdbConfirmationDialogElement extends PolymerElement{static get is(){return"settings-crostini-arc-adb-confirmation-dialog"}static get template(){return getTemplate$3q()}static get properties(){return{action:{type:String}}}constructor(){super();this.browserProxy_=CrostiniBrowserProxyImpl.getInstance()}connectedCallback(){super.connectedCallback();this.$.dialog.showModal()}isEnabling_(){return this.action==="enable"}isDisabling_(){return this.action==="disable"}onCancelClick_(){this.$.dialog.close()}onRestartClick_(){if(this.isEnabling_()){this.browserProxy_.enableArcAdbSideload();recordSettingChange(Setting.kCrostiniAdbDebugging,{boolValue:true})}else if(this.isDisabling_()){this.browserProxy_.disableArcAdbSideload();recordSettingChange(Setting.kCrostiniAdbDebugging,{boolValue:false})}else{assertNotReached()}}}customElements.define(SettingsCrostiniArcAdbConfirmationDialogElement.is,SettingsCrostiniArcAdbConfirmationDialogElement);function getTemplate$3p(){return html`<!--_html_template_start_--><style include="settings-shared">cr-policy-indicator{padding:0 var(--cr-controlled-by-spacing)}</style>
<div class="settings-box first">
  <div class="settings-box-text">
    $i18n{crostiniArcAdbDescription}
  </div>
</div>
<div class="settings-box continuation">
  <div id="enableArcAdbLabel" class="start">
    $i18n{crostiniArcAdbLabel}
    <div class="secondary" hidden="[[!arcAdbNeedPowerwash_]]">
      <localized-link
          localized-string="[[i18nAdvanced(
            'crostiniArcAdbPowerwashRequiredSublabel')]]">
      </localized-link>
    </div>
  </div>
  <cr-policy-indicator indicator-type="[[getPolicyIndicatorType_(
      isOwnerProfile_, isEnterpriseManaged_, canChangeAdbSideloading_)]]">
  </cr-policy-indicator>
  <cr-toggle id="arcAdbEnabledButton" aria-labelledby="enableArcAdbLabel"
      checked$="[[arcAdbEnabled_]]"
      disabled="[[shouldDisable_(canChangeAdbSideloading_,
                  arcAdbNeedPowerwash_)]]"
      on-change="onArcAdbToggleChanged_"
      deep-link-focus-id$="[[Setting.kCrostiniAdbDebugging]]">
  </cr-toggle>
</div>

<template is="dom-if" if="[[showConfirmationDialog_]]" restamp>
  <settings-crostini-arc-adb-confirmation-dialog
      action="[[getToggleAction_(arcAdbEnabled_)]]"
      on-close="onConfirmationDialogClose_">
  </settings-crostini-arc-adb-confirmation-dialog>
</template>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsCrostiniArcAdbElementBase=DeepLinkingMixin(RouteObserverMixin(WebUiListenerMixin(I18nMixin(PolymerElement))));class SettingsCrostiniArcAdbElement extends SettingsCrostiniArcAdbElementBase{static get is(){return"settings-crostini-arc-adb"}static get template(){return getTemplate$3p()}static get properties(){return{prefs:{type:Object,notify:true},arcAdbEnabled_:{type:Boolean,value:false},arcAdbNeedPowerwash_:{type:Boolean,value:false},isOwnerProfile_:{type:Boolean,value(){return loadTimeData.getBoolean("isOwnerProfile")}},isEnterpriseManaged_:{type:Boolean,value(){return loadTimeData.getBoolean("isEnterpriseManaged")}},canChangeAdbSideloading_:{type:Boolean,value:false},showConfirmationDialog_:{type:Boolean,value:false}}}constructor(){super();this.supportedSettingIds=new Set([Setting.kCrostiniAdbDebugging]);this.browserProxy_=CrostiniBrowserProxyImpl.getInstance()}connectedCallback(){super.connectedCallback();this.addWebUiListener("crostini-arc-adb-sideload-status-changed",((enabled,needPowerwash)=>{this.arcAdbEnabled_=enabled;this.arcAdbNeedPowerwash_=needPowerwash}));this.addWebUiListener("crostini-can-change-arc-adb-sideload-changed",(canChangeArcAdbSideloading=>{this.canChangeAdbSideloading_=canChangeArcAdbSideloading}));this.browserProxy_.requestArcAdbSideloadStatus();this.browserProxy_.getCanChangeArcAdbSideloading()}currentRouteChanged(route){if(route!==routes.CROSTINI_ANDROID_ADB){return}this.attemptDeepLink()}shouldDisable_(){return!this.canChangeAdbSideloading_||this.arcAdbNeedPowerwash_}getPolicyIndicatorType_(){if(this.isEnterpriseManaged_){if(this.canChangeAdbSideloading_){return CrPolicyIndicatorType.NONE}else{return CrPolicyIndicatorType.DEVICE_POLICY}}else if(!this.isOwnerProfile_){return CrPolicyIndicatorType.OWNER}else{return CrPolicyIndicatorType.NONE}}getToggleAction_(){return this.arcAdbEnabled_?"disable":"enable"}onArcAdbToggleChanged_(){this.showConfirmationDialog_=true}onConfirmationDialogClose_(){this.showConfirmationDialog_=false;this.$.arcAdbEnabledButton.checked=this.arcAdbEnabled_}}customElements.define(SettingsCrostiniArcAdbElement.is,SettingsCrostiniArcAdbElement);function getTemplate$3o(){return html`<!--_html_template_start_--><style include="settings-shared"></style>
<cr-dialog id="dialog" close-text="$i18n{close}">
  <div slot="title">$i18n{crostiniImportConfirmationDialogTitle}</div>
  <div slot="body">$i18n{crostiniImportConfirmationDialogMessage}</div>
  <div slot="button-container">
    <cr-button id="cancel" class="cancel-button"
        on-click="onCancelClick_">$i18n{cancel}</cr-button>
    <cr-button id="continue" class="action-button"
        on-click="onContinueClick_">
      $i18n{crostiniImportConfirmationDialogConfirmationButton}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class SettingsCrostiniImportConfirmationDialogElement extends PolymerElement{static get is(){return"settings-crostini-import-confirmation-dialog"}static get template(){return getTemplate$3o()}static get properties(){return{importContainerId:{type:Object}}}constructor(){super();this.browserProxy_=CrostiniBrowserProxyImpl.getInstance()}connectedCallback(){super.connectedCallback();this.$.dialog.showModal()}onCancelClick_(){this.$.dialog.close()}onContinueClick_(){if(this.importContainerId.vm_type===VmType.BAGUETTE){this.browserProxy_.importDiskImage(this.importContainerId)}else{this.browserProxy_.importCrostiniContainer(this.importContainerId)}recordSettingChange(Setting.kRestoreLinuxAppsAndFiles);this.$.dialog.close()}}customElements.define(SettingsCrostiniImportConfirmationDialogElement.is,SettingsCrostiniImportConfirmationDialogElement);function getTemplate$3n(){return html`<!--_html_template_start_--><style include="settings-shared md-select"></style>
<label class="cr-form-field-label">Container</label>
<select id="selectContainer"
    class="md-select"
    value="containerLabel_(containerId)"
    on-change="onSelectContainer_">
    <template is="dom-repeat" items="[[containers]]">
      <option value="[[item.id]]">
        [[containerLabel_(item.id)]]
      </option>
    </template>
</select>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function equalContainerId(first,second){return first.vm_name===second.vm_name&&first.container_name===second.container_name&&first.vm_type===second.vm_type}function containerLabel(id,defaultVmName){if(defaultVmName!==null&&id.vm_name===defaultVmName){return id.container_name}return id.vm_name+":"+id.container_name}class ContainerSelectElement extends PolymerElement{static get is(){return"settings-guest-os-container-select"}static get template(){return getTemplate$3n()}static get properties(){return{selectedContainerId:{type:Object,notify:true},defaultVmName:{type:String,value:null},containers:{type:Array,value(){return[]}}}}onSelectContainer_(e){const index=cast(e.target,HTMLSelectElement).selectedIndex;if(index>=0&&index<this.containers.length){this.selectedContainerId=this.containers[index].id}}containerLabel_(id){return containerLabel(id,this.defaultVmName)}}customElements.define(ContainerSelectElement.is,ContainerSelectElement);function getTemplate$3m(){return html`<!--_html_template_start_--><style include="settings-shared">.container-select{padding:0 8px}.two-line-settings-box{min-height:80px}#secondaryText{padding:3px 0}</style>
<div id="export"
  class$="settings-box first [[getSettingsBoxClass_(allContainers_)]]">
  <div id="exportCrostiniLabel" class="start">
    $i18n{crostiniExportLabel}
    <template is="dom-if" if="[[showContainerSelect_]]" restamp>
      <div class="secondary" id="secondaryText">
        Container to backup
        <settings-guest-os-container-select
          class="container-select"
          id="exportContainerSelect"
          containers="[[allContainers_]]"
          selected-container-id="{{exportContainerId_}}"
          default-vm-name="[[defaultVmName_]]">
        </settings-guest-os-container-select>
      </div>
    </template>
  </div>
  <cr-button on-click="onExportClick_" disabled="[[!enableButtons_]]"
      aria-labelledby="exportCrostiniLabel"
      deep-link-focus-id$="[[Setting.kBackupLinuxAppsAndFiles]]">
    $i18n{crostiniExport}
  </cr-button>
</div>
<div id="import" class$="settings-box [[getSettingsBoxClass_(allContainers_)]]">
  <div id="importCrostiniLabel" class="start">
    $i18n{crostiniImportLabel}
    <template is="dom-if" if="[[showContainerSelect_]]" restamp>
      <div class="secondary" id="secondaryText">
        Container to restore
        <settings-guest-os-container-select
          class="container-select"
          id="importContainerSelect"
          containers="[[allContainers_]]"
          selected-container-id="{{importContainerId_}}"
          default-vm-name="[[defaultVmName_]]">
        </settings-guest-os-container-select>
      </div>
    </template>
  </div>
  <cr-button on-click="onImportClick_" disabled="[[!enableButtons_]]"
      aria-labelledby="importCrostiniLabel"
      deep-link-focus-id$="[[Setting.kRestoreLinuxAppsAndFiles]]">
    $i18n{crostiniImport}
  </cr-button>
</div>
<template is="dom-if" if="[[showImportConfirmationDialog_]]" restamp>
  <settings-crostini-import-confirmation-dialog
      on-close="onImportConfirmationDialogClose_"
      import-container-id="{{importContainerId_}}">
  </settings-crostini-import-confirmation-dialog>
</template>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsCrostiniExportImportElementBase=DeepLinkingMixin(RouteObserverMixin(WebUiListenerMixin(PolymerElement)));class SettingsCrostiniExportImportElement extends SettingsCrostiniExportImportElementBase{static get is(){return"settings-crostini-export-import"}static get template(){return getTemplate$3m()}static get properties(){return{prefs:{type:Object,notify:true},showImportConfirmationDialog_:{type:Boolean,value:false},enableButtons_:{type:Boolean,computed:"isEnabledButtons_(installerShowing_, exportImportInProgress_)"},showContainerSelect_:{type:Boolean,computed:"isMultiContainer_(allContainers_)"},installerShowing_:{type:Boolean,value:false},exportImportInProgress_:{type:Boolean,value:false},allContainers_:{type:Array,notify:true,value(){return[]}},exportContainerId_:{type:Object,value(){return DEFAULT_CROSTINI_GUEST_ID}},importContainerId_:{type:Object,value(){return DEFAULT_CROSTINI_GUEST_ID}},defaultVmName_:{type:String,value:DEFAULT_CROSTINI_VM}}}constructor(){super();this.supportedSettingIds=new Set([Setting.kBackupLinuxAppsAndFiles,Setting.kRestoreLinuxAppsAndFiles]);this.browserProxy_=CrostiniBrowserProxyImpl.getInstance()}connectedCallback(){super.connectedCallback();this.addWebUiListener("crostini-export-import-operation-status-changed",(inProgress=>{this.exportImportInProgress_=inProgress}));this.addWebUiListener("crostini-installer-status-changed",(installerShowing=>{this.installerShowing_=installerShowing}));this.addWebUiListener("crostini-container-info",(infos=>this.onContainerInfo_(infos)));this.browserProxy_.requestCrostiniExportImportOperationStatus();this.browserProxy_.requestCrostiniInstallerStatus();this.browserProxy_.requestContainerInfo()}currentRouteChanged(route){if(route!==routes.CROSTINI_EXPORT_IMPORT){return}this.attemptDeepLink()}onContainerInfo_(containerInfos){this.allContainers_=containerInfos;if(!this.isMultiContainer_(containerInfos)){if(containerInfos[0].id.vm_type===VmType.BAGUETTE){this.exportContainerId_=DEFAULT_BAGUETTE_GUEST_ID;this.importContainerId_=DEFAULT_BAGUETTE_GUEST_ID}else{this.exportContainerId_=DEFAULT_CROSTINI_GUEST_ID;this.importContainerId_=DEFAULT_CROSTINI_GUEST_ID}}}onExportClick_(){this.browserProxy_.exportDiskImage(this.exportContainerId_);recordSettingChange(Setting.kBackupLinuxAppsAndFiles)}onImportClick_(){this.showImportConfirmationDialog_=true}onImportConfirmationDialogClose_(){this.showImportConfirmationDialog_=false}isEnabledButtons_(installerShowing,exportImportInProgress){return!(installerShowing||exportImportInProgress)}isMultiContainer_(allContainers){return allContainers.length!==1}getSettingsBoxClass_(allContainers){return this.isMultiContainer_(allContainers)?"two-line-settings-box":""}}customElements.define(SettingsCrostiniExportImportElement.is,SettingsCrostiniExportImportElement);function getTemplate$3l(){return html`<!--_html_template_start_--><style include="settings-shared md-select">.custom-button-container{float:right}.input-container{display:flex;flex-direction:row;justify-content:space-between}.advanced-section{display:flex;flex-direction:column;justify-content:space-between;padding-bottom:12px;padding-inline-start:20px}.custom-body{padding-bottom:20px}#advancedToggle{--ink-color:var(--cros-text-color-primary);background:none;border:none;box-shadow:none;color:var(--cros-text-color-primary);font-weight:400;margin-bottom:12px;min-height:32px;padding-inline-start:0}#containerFileField{display:flex;flex-direction:row}#containerFileInput{width:100%}</style>
<cr-dialog id="dialog" close-text="$i18n{close}">
  <div slot="title">$i18n{crostiniExtraContainersCreateDialogTitle}</div>
  <div slot="body">
    <div class="input-container">
      <cr-input id="containerNameInput"
          label="$i18n{crostiniExtraContainersContainerNameLabel}"
          aria-disabled="false"
          on-input="validateNames_"
          invalid="[[!validContainerName_]]"
          error-message="[[containerNameError_]]">
      </cr-input>
      <cr-input id="vmNameInput"
          label="$i18n{crostiniExtraContainersVmNameLabel}"
          aria-disabled="false"
          on-input="validateNames_">
      </cr-input>
    </div>

    <cr-button id="advancedToggle" on-click="advancedToggleClicked_"
        aria-expanded$="[[boolToString_(advancedToggleExpanded_)]]">
      <span>$i18n{advancedPageTitle}</span>
      <iron-icon
        icon="[[getArrowIcon_(advancedToggleExpanded_)]]"
        slot="suffix-icon">
      </iron-icon>
    </cr-button>
    <div class="advanced-section" hidden="[[!advancedToggleExpanded_]]">
      <cr-input id="imageServerInput"
        label="$i18n{crostiniExtraContainersCreateDialogImageServer}"
        aria-disabled="false">
      </cr-input>
      <cr-input id="imageAliasInput"
        label="$i18n{crostiniExtraContainersCreateDialogImageAlias}"
        aria-disabled="false">
      </cr-input>
      <div id="containerFileField">
        <cr-input id="containerFileInput"
          label="$i18n{crostiniExtraContainersCreateDialogAddContainerFile}"
          aria-disabled="true"
          readonly>
          <cr-button id="uploadButton"
            slot="suffix"
            on-click="onSelectContainerFileClick_"
            aria-labelledby="containerFileInput">
            $i18n{crostiniExtraContainersCreateDialogAddContainerButtonLabel}
          </cr-button>
        </cr-input>
      </div>
    </div>
  </div>

  <div slot="body" class="custom-body">
    <div slot="button-container" class="custom-button-container">
      <cr-button id="cancel" class="cancel-button" on-click="onCancelClick_">
        $i18n{cancel}
      </cr-button>
      <cr-button id="create" class="action-button" on-click="onCreateClick_"
          disabled="[[disableCreateButton_]]">
        $i18n{crostiniExtraContainersCreate}
      </cr-button>
    </div>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class ExtraContainersCreateDialog extends PolymerElement{static get is(){return"settings-crostini-create-container-dialog"}static get template(){return getTemplate$3l()}static get properties(){return{allContainers:{type:Array,value:[]},containerFile_:{type:String,value:""},inputVmName_:{type:String,value:DEFAULT_CROSTINI_VM},inputContainerName_:{type:String,value:""},inputImageServer_:{type:String,value:""},inputImageAlias_:{type:String,value:""},advancedToggleExpanded_:{type:Boolean,value:false},disableCreateButton_:{type:Boolean,value:true},validContainerName_:{type:Boolean,value:true},containerNameError_:{type:String,value:""}}}constructor(){super();this.browserProxy_=CrostiniBrowserProxyImpl.getInstance()}connectedCallback(){super.connectedCallback();this.$.dialog.showModal();this.$.vmNameInput.value=this.inputVmName_;this.$.containerNameInput.value=this.inputContainerName_;this.$.imageServerInput.value=this.inputImageServer_;this.$.imageAliasInput.value=this.inputImageAlias_;this.$.containerNameInput.focus()}isValidVmName(_input){return true}validateNames_(){this.inputVmName_=this.$.vmNameInput.value.length===0?DEFAULT_CROSTINI_VM:this.$.vmNameInput.value;this.inputContainerName_=this.$.containerNameInput.value;this.containerNameError_="";if(this.inputContainerName_.length===0){this.containerNameError_=loadTimeData.getString("crostiniExtraContainersCreateDialogEmptyContainerNameError")}else if(this.inputContainerName_===DEFAULT_CROSTINI_CONTAINER||this.allContainers.find((e=>e.id.vm_name===this.inputVmName_&&e.id.container_name===this.inputContainerName_))){this.containerNameError_=loadTimeData.getString("crostiniExtraContainersCreateDialogContainerExistsError")}this.validContainerName_=this.containerNameError_.length===0;this.disableCreateButton_=!this.validContainerName_||!this.isValidVmName(this.inputVmName_)}onCancelClick_(){this.$.dialog.close()}onCreateClick_(){if(this.advancedToggleExpanded_){this.inputImageServer_=this.$.imageServerInput.value;this.inputImageAlias_=this.$.imageAliasInput.value;this.containerFile_=this.$.containerFileInput.value}this.browserProxy_.createContainer({vm_name:this.inputVmName_,container_name:this.inputContainerName_,vm_type:VmType.TERMINA},this.inputImageServer_,this.inputImageAlias_,this.containerFile_);this.$.dialog.close()}async onSelectContainerFileClick_(){this.$.containerFileInput.value=await this.browserProxy_.openContainerFileSelector()}advancedToggleClicked_(){this.advancedToggleExpanded_=!this.advancedToggleExpanded_;this.$.dialog.getBoundingClientRect()}getArrowIcon_(opened){return opened?"cr:arrow-drop-up":"cr:arrow-drop-down"}boolToString_(bool){return bool.toString()}}customElements.define(ExtraContainersCreateDialog.is,ExtraContainersCreateDialog);
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function hexColorToSkColor(hexColor){if(!/^#[0-9a-f]{6}$/.test(hexColor)){return{value:0}}const r=parseInt(hexColor.substring(1,3),16);const g=parseInt(hexColor.substring(3,5),16);const b=parseInt(hexColor.substring(5,7),16);return{value:4278190080+(r<<16)+(g<<8)+b}}function getTemplate$3k(){return html`<!--_html_template_start_--><style include="settings-shared">.container-details-list{padding-inline-start:var(--cr-section-indent-padding)}.detail-content{color:var(--cros-text-color-primary);flex:auto}.detail-heading{color:var(--cr-secondary-text-color);flex:auto}.vm-column{flex:1;flex-grow:3;word-break:break-all}#createExtraContainer{padding-top:10px}cr-expand-button{--cr-section-vertical-padding:0;flex:auto}</style>
<div class="settings-box first">
  <div id="extraContainersDescription" class="start">
    $i18n{crostiniExtraContainersDescription}
  </div>
</div>
<div class="settings-box first">
  <div id="extraContainersTableTitle" class="start"
      aria-hidden="true">
    $i18n{crostiniExtraContainersTableTitle}
  </div>
  <cr-button id="create" on-click="onCreateClick_" disabled="[[!enableButtons_]]">
    $i18n{crostiniExtraContainersCreate}
  </cr-button>
</div>

<template is="dom-repeat"
    items="[[allVms_]]" as="vmName" index-as="vmIndex"
    sort="byVmName_" mutable-data>
  <div class="settings-box hr">
    <div class="detail-heading">
      $i18n{crostiniExtraContainersVmNameLabel}:
      <span class="detail-content">[[vmName]]</span>
    </div>
  </div>
  <div class="list-frame vertical-list">
    <template is="dom-repeat" items="[[allContainers_]]"
        filter="[[infoHasVmName_(vmName)]]" sort="byGuestId_" mutable-data>
      <div class="list-item">
      <cr-expand-button
          class="list-item secondary"
          id="expand-button-[[item.id.vm_name]]-[[item.id.container_name]]"
          expanded="{{item.detailsExpanded}}"
          data-container-id="[[item.id]]">
        <div class="detail-heading">
          $i18n{crostiniExtraContainersContainerNameLabel}:
          <span class="detail-content">[[item.id.container_name]]</span>
        </div>
      </cr-expand-button>
      <div class="separator"></div>
      <cr-icon-button id="showContainerMenu[[index]]"
          class="icon-more-vert"
          title="$i18n{moreActions}"
          data-container-id="[[item.id]]"
          on-click="onContainerMenuClick_">
      </cr-icon-button>
      </div>
      <iron-collapse
          id="collapse-[[item.id.vm_name]]-[[item.id.container_name]]"
          opened="[[item.detailsExpanded]]">
        <div class="container-details-list"
            id="details-[[item.id.vm_name]]-[[item.id.container_name]]">
          <div class="list-item">
            <div class="detail-heading" aria-hidden="true">
              $i18n{crostiniExtraContainersAppBadgeColor}
            </div>
            <input type="color"
                data-container-id="[[item.id]]"
                value="[[item.badge_color]]"
                on-change="onContainerColorChange_">
          </div>
          <div class="list-item">
            <div class="detail-heading" aria-hidden="true">
              $i18n{crostiniExtraContainersShareMicrophone}
            </div>
            <cr-toggle
                id="microphone-[[item.id.vm_name]]-[[item.id.container_name]]"
                data-container-id="[[item.id]]"
                checked="[[isMicrophoneShared_(item.id)]]"
                on-change="onMicrophoneSharingChanged_">
            </cr-toggle>
          </div>
          <div class="list-item"
              hidden="[[!showIp_(item)]]"
              id="ip-[[item.id.vm_name]]-[[item.id.container_name]]">
            <div class="detail-heading" aria-hidden="true">
              $i18n{crostiniExtraContainersContainerIpLabel}
            </div>
            <div class="vm-column">
              [[item.ipv4]]
            </div>
          </div>
        </div>
      </iron-collapse>
    </template>
  </div>
</template>

<template is="dom-if" if="[[showCreateContainerDialog_]]" restamp>
  <settings-crostini-create-container-dialog
      on-close="onCreateContainerDialogClose_"
      all-containers="[[allContainers_]]">
  </settings-crostini-create-container-dialog>
</template>
<cr-lazy-render id="containerMenu">
  <template>
    <cr-action-menu class="complex" role-description="$i18n{menu}">
      <button id="stopContainerButton"
          class="dropdown-item"
          role="menuitem"
          disabled="[[shouldDisableStopContainer_(lastMenuContainerInfo_)]]"
          on-click="onStopContainerClick_">
        $i18n{crostiniExtraContainersStop}
      </button>
      <button id="deleteContainerButton"
          class="dropdown-item"
          role="menuitem"
          disabled="[[shouldDisableDeleteContainer_(lastMenuContainerInfo_)]]"
          on-click="onDeleteContainerClick_">
        $i18n{crostiniExtraContainersDelete}
      </button>
      <button id="exportContainerButton"
          class="dropdown-item"
          role="menuitem"
          on-click="onExportContainerClick_"
          disabled="[[!enableButtons_]]">
        $i18n{crostiniExport}
      </button>
      <button id="importContainerButton"
          class="dropdown-item"
          role="menuitem"
          on-click="onImportContainerClick_"
          disabled="[[!enableButtons_]]">
        $i18n{crostiniImport}
      </button>
    </cr-action-menu>
  </template>
</cr-lazy-render>

<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const ExtraContainersElementBase=WebUiListenerMixin(PolymerElement);class ExtraContainersElement extends ExtraContainersElementBase{static get is(){return"settings-crostini-extra-containers"}static get template(){return getTemplate$3k()}static get properties(){return{prefs:{type:Object,notify:true},showCreateContainerDialog_:{type:Boolean,value:false},allContainers_:{type:Array,notify:true,value(){return[]}},allSharedVmDevices_:{type:Array,value(){return[]}},allVms_:{type:Array,value(){return[]}},lastMenuContainerInfo_:{type:Object},enableButtons_:{type:Boolean,computed:"isEnabledButtons_(installerShowing_, exportImportInProgress_)"},installerShowing_:{type:Boolean,value:false},exportImportInProgress_:{type:Boolean,value:false}}}constructor(){super();this.lastMenuContainerInfo_=null;this.browserProxy_=CrostiniBrowserProxyImpl.getInstance()}ready(){super.ready();this.addWebUiListener("crostini-container-info",(infos=>this.onContainerInfo_(infos)));this.addWebUiListener("crostini-shared-vmdevices",(sharedVmDevices=>this.onSharedVmDevices_(sharedVmDevices)));this.browserProxy_.requestContainerInfo();this.browserProxy_.requestSharedVmDevices()}connectedCallback(){super.connectedCallback();this.addWebUiListener("crostini-export-import-operation-status-changed",(inProgress=>{this.exportImportInProgress_=inProgress}));this.addWebUiListener("crostini-installer-status-changed",(installerShowing=>{this.installerShowing_=installerShowing}));this.browserProxy_.requestCrostiniExportImportOperationStatus();this.browserProxy_.requestCrostiniInstallerStatus()}setMicrophoneToggle_(id,checked){const crToggle=this.shadowRoot.querySelector(`#microphone-${id.vm_name}-${id.container_name}`);if(!crToggle){return}if(crToggle.checked!==checked){crToggle.set("checked",checked)}}onSharedVmDevices_(sharedVmDevices){this.set("allSharedVmDevices_",sharedVmDevices);for(const sharing of sharedVmDevices){this.setMicrophoneToggle_(sharing.id,sharing.vmDevices[VM_DEVICE_MICROPHONE])}}async updateSharedVmDevices_(id){let idx=this.allSharedVmDevices_.findIndex((sharing=>equalContainerId(sharing.id,id)));if(idx<0){idx=this.allSharedVmDevices_.push({id:id,vmDevices:{[VM_DEVICE_MICROPHONE]:false}})-1}const result=await this.browserProxy_.isVmDeviceShared(id,VM_DEVICE_MICROPHONE);this.allSharedVmDevices_[idx].vmDevices[VM_DEVICE_MICROPHONE]=result;this.setMicrophoneToggle_(id,result)}onContainerInfo_(containerInfos){const vmNames=new Set;const crostiniContainerInfos=containerInfos;for(const info of crostiniContainerInfos){vmNames.add(info.id.vm_name);const oldContainerInfo=this.allContainers_.find((container=>equalContainerId(container.id,info.id)));info.detailsExpanded=oldContainerInfo!==undefined?oldContainerInfo.detailsExpanded:false}this.set("allVms_",Array.from(vmNames.values()));this.set("allContainers_",crostiniContainerInfos)}onCreateClick_(){this.showCreateContainerDialog_=true}onCreateContainerDialogClose_(){this.showCreateContainerDialog_=false}onContainerMenuClick_(event){const target=event.currentTarget;const containerId=target["dataContainerId"];this.lastMenuContainerInfo_=this.allContainers_.find((e=>e.id.vm_name===containerId.vm_name&&e.id.container_name===containerId.container_name))||null;this.getContainerMenu_().showAt(target)}onDeleteContainerClick_(){if(this.lastMenuContainerInfo_){this.browserProxy_.deleteContainer(this.lastMenuContainerInfo_.id)}this.closeContainerMenu_()}onStopContainerClick_(){if(this.lastMenuContainerInfo_){this.browserProxy_.stopContainer(this.lastMenuContainerInfo_.id)}this.closeContainerMenu_()}onExportContainerClick_(){if(this.lastMenuContainerInfo_){this.browserProxy_.exportCrostiniContainer(this.lastMenuContainerInfo_.id)}this.closeContainerMenu_()}onImportContainerClick_(){if(this.lastMenuContainerInfo_){this.browserProxy_.importCrostiniContainer(this.lastMenuContainerInfo_.id)}this.closeContainerMenu_()}onContainerColorChange_(event){const target=event.currentTarget;const containerId=target["dataContainerId"];const hexColor=target.value;this.browserProxy_.setContainerBadgeColor(containerId,hexColorToSkColor(hexColor))}shouldDisableDeleteContainer_(info){return info&&info.id.vm_name===DEFAULT_CROSTINI_VM&&info.id.container_name===DEFAULT_CROSTINI_CONTAINER}shouldDisableStopContainer_(info){return!info||!info.ipv4}getContainerMenu_(){return this.$.containerMenu.get()}closeContainerMenu_(){const menu=this.getContainerMenu_();assert(menu.open&&this.lastMenuContainerInfo_);menu.close();this.lastMenuContainerInfo_=null}isEnabledButtons_(installerShowing,exportImportInProgress){return!(installerShowing||exportImportInProgress)}byNameWithDefault_(name1,name2,defaultName){if(name1===name2){return 0}if(name1===defaultName){return-1}if(name2===defaultName){return 1}return name1<name2?-1:1}byVmName_(name1,name2){return this.byNameWithDefault_(name1,name2,DEFAULT_CROSTINI_VM)}byGuestId_(id1,id2){const result=this.byVmName_(id1.vm_name,id2.vm_name);if(result!==0){return result}return this.byNameWithDefault_(id1.container_name,id2.container_name,DEFAULT_CROSTINI_CONTAINER)}infoHasVmName_(vmName){return info=>vmName===info.id.vm_name}isMicrophoneShared_(id){const deviceSharing=this.allSharedVmDevices_.find((sharing=>equalContainerId(sharing.id,id)));if(!deviceSharing){return false}return deviceSharing.vmDevices[VM_DEVICE_MICROPHONE]}async onMicrophoneSharingChanged_(event){const target=event.currentTarget;const id=target["dataContainerId"];const shared=target.checked;await this.browserProxy_.setVmDeviceShared(id,VM_DEVICE_MICROPHONE,shared);await this.updateSharedVmDevices_(id)}showIp_(info){return!!info.ipv4&&info.ipv4.length>0}}customElements.define(ExtraContainersElement.is,ExtraContainersElement);function getTemplate$3j(){return html`<!--_html_template_start_--><style include="settings-shared md-select">#portNumberInput{padding-inline-end:20px;width:376px}#portLabelInput{padding-top:20px;width:472px}#selectProtocol{max-width:96px}.custom-body{padding-bottom:20px}.custom-button-container{float:right}.input-container{display:flex;flex-direction:row;justify-content:space-between}.placeholder-label{visibility:hidden}</style>
<cr-dialog id="dialog" close-text="$i18n{close}">
  <div slot="title">$i18n{crostiniPortForwardingAddPortDialogTitle}</div>
  <div slot="body">
    <div class="input-container">
      <cr-input id="portNumberInput"
          label="$i18n{crostiniPortForwardingAddPortDialogPortNumberLabel}"
          aria-disabled="false"
          error-message="[[portState_]]"
          type="number"
          min="1024"
          max="65535"
          on-blur="onBlur_">
      </cr-input>
      <div>
        <div id="label" class="cr-form-field-label placeholder-label"
            aria-hidden="true">
            ""
        </div>
        <select id="selectProtocol"
            class="md-select"
            value="$i18n{crostiniPortForwardingTCP}"
            on-change="onSelectProtocol_">
          <option value="$i18n{crostiniPortForwardingTCP}">
            $i18n{crostiniPortForwardingTCP}
          </option>
          <option value="$i18n{crostiniPortForwardingUDP}">
            $i18n{crostiniPortForwardingUDP}
          </option>
        </select>
      </div>
    </div>
    <template is="dom-if" if="[[showContainerSelect_(allContainers)]]" restamp>
      <settings-guest-os-container-select
          containers="[[allContainers]]"
          selected-container-id="{{containerId_}}"
          default-vm-name="[[defaultVmName_]]">
      </settings-guest-os-container-select>
    </template>
    <div slot="body">
      <cr-input id="portLabelInput"
          label="$i18n{crostiniPortForwardingAddPortDialogLabelLabel}"
          aria-disabled="false"
          maxlength="50">
      </cr-input>
    </div>
  </div>
  <div slot="body" class="custom-body">
    <div slot="button-container" class="custom-button-container">
      <cr-button id="cancel" class="cancel-button"
          on-click="onCancelClick_">$i18n{cancel}</cr-button>
      <cr-button id="continue" class="action-button"
          on-click="onAddClick_">
          $i18n{add}
      </cr-button>
    </div>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class CrostiniPortForwardingAddPortDialog extends PolymerElement{static get is(){return"settings-crostini-add-port-dialog"}static get template(){return getTemplate$3j()}static get properties(){return{inputPortNumber_:{type:Number,value:null},inputPortLabel_:{type:String,value:""},inputProtocolIndex_:{type:Number,value:0},portState_:{type:String,value:PortState.VALID},containerId_:{type:Object,value(){return DEFAULT_CROSTINI_GUEST_ID}},defaultVmName_:{type:String,value:DEFAULT_CROSTINI_VM},allPorts:{type:Array,value(){return[]}},allContainers:{type:Array,value:[]}}}static get observers(){return["onPortStateChanged_(portState_)"]}constructor(){super();this.browserProxy_=CrostiniBrowserProxyImpl.getInstance()}connectedCallback(){super.connectedCallback();this.$.dialog.showModal();microTask.run((()=>{this.$.portNumberInput.focus()}))}resetInputs_(){this.inputPortLabel_="";this.inputPortNumber_=null;this.inputProtocolIndex_=0;this.portState_=PortState.VALID}get portNumberInput(){return this.$.portNumberInput}get portLabelInput(){return this.$.portLabelInput}isValidPortNumber(input){const numberRegex=/^[0-9]+$/;return Boolean(input.match(numberRegex))&&Number(input)>=MIN_VALID_PORT_NUMBER&&Number(input)<=MAX_VALID_PORT_NUMBER}computePortState_(){if(!this.isValidPortNumber(this.$.portNumberInput.value)){return PortState.INVALID}if(this.allPorts.find((portSetting=>portSetting.port_number===Number(this.$.portNumberInput.value)&&portSetting.protocol_type===this.inputProtocolIndex_))){return PortState.DUPLICATE}return PortState.VALID}onSelectProtocol_(e){this.inputProtocolIndex_=cast(e.target,HTMLSelectElement).selectedIndex;this.portState_=this.computePortState_()}onCancelClick_(){this.$.dialog.close();this.resetInputs_()}onAddClick_(){this.portState_=this.computePortState_();if(this.portState_!==PortState.VALID){return}const portNumber=+this.$.portNumberInput.value;const portLabel=this.$.portLabelInput.value;this.browserProxy_.addCrostiniPortForward(this.containerId_,portNumber,this.inputProtocolIndex_,portLabel).then((_result=>{this.$.dialog.close()}));this.resetInputs_()}onBlur_(){this.portState_=this.computePortState_()}onPortStateChanged_(){if(this.portState_===PortState.VALID){this.$.portNumberInput.invalid=false;this.$.continue.disabled=false;return}this.$.portNumberInput.invalid=true;this.$.continue.disabled=true}showContainerSelect_(allContainers){return allContainers.length>1}}customElements.define(CrostiniPortForwardingAddPortDialog.is,CrostiniPortForwardingAddPortDialog);function getTemplate$3i(){return html`<!--_html_template_start_--><style include="settings-shared">:host{--cr-toggle-margin-inline-start:16px;--cr-toggle-width:34px}cr-toggle{margin-inline-start:var(--cr-toggle-margin-inline-start);width:var(--cr-toggle-width)}.column-title{color:var(--cr-secondary-text-color)}.label-column{align-items:center;display:flex;flex:1;flex-grow:3}.label-text{flex-grow:3;word-break:break-all}.no-ports-text{padding-inline-start:24px}.interface-ip{padding-inline-start:24px}#addPort{padding-top:10px}#errorIcon{display:inline-block;margin-inline-end:8px}#protocolText{color:var(--cros-text-color-disabled);margin-inline-start:8px}#portForwardingListContainerId{border-top:var(--cr-separator-line)}#portForwardingDescription{flex-grow:3}
</style>
<div id="addPort" class="settings-box first">
  <div
      id="portForwardingDescription">
    $i18n{crostiniPortForwardingDescription}
  </div>
  <cr-button on-click="onAddPortClick_"
      aria-label="$i18n{crostiniPortForwardingAddPortButtonDescription}"
      aria-describedby="i18n{portForwardingDescription}">
    $i18n{crostiniPortForwardingAddPortButton}
  </cr-button>
  <template is="dom-if" if="[[allPorts_.length]]" restamp>
    <cr-icon-button id="showRemoveAllPortsMenu"
      class="icon-more-vert"
      title="$i18n{moreActions}"
      on-click="onShowRemoveAllPortsMenuClick_"
      aria-label="$i18n{moreActions}">
    </cr-icon-button>
  </template>
</div>
<template is="dom-if" if="[[activeInterface_]]" restamp>
    <div id="interface-ip" class="settings-box continuation">
        [[activeInterface_]]: [[activeIpAddress_]]
    </div>
</template>
<template is="dom-if" if="[[!allPorts_.length]]" restamp>
  <div id="no-ports-text"
      class="settings-box continuation">
    $i18n{crostiniPortForwardingNoPorts}
  </div>
</template>
<template is="dom-if" if="[[allPorts_.length]]" restamp>
  <template is="dom-repeat" items="[[allContainers_]]"
      as="containerInfo" index-as="cidx" mutable-data>
    <template is="dom-if"
        if="[[hasContainerPorts_(allPorts_, containerInfo.id)]]" restamp>
      <h2 id="portForwardingListContainerId"
          hidden="[[!showContainerId_(allPorts_, containerInfo.id)]]"
          class="settings-box first">
          [[containerLabel_(containerInfo.id)]]
      </h2>
      <div class="list-frame vertical-list" id="portForwardingListCard">
        <div class="list-item">
          <div id="portForwardingListPortNumber"
              class="start column-title"
              aria-hidden="true">
            $i18n{crostiniPortForwardingListPortNumber}
          </div>
          <div id="portForwardingListPortLabel"
              class="column-title label-column"
              aria-hidden="true">
            $i18n{crostiniPortForwardingListLabel}
          </div>
        </div>
        <template is="dom-repeat" items="[[allPorts_]]"
            filter="[[byContainerId_(containerInfo.id)]]" mutable-data>
          <div class="list-item">
            <div id="crostiniPort[[cidx]]-[[index]]"
                class="start"
                aria-hidden="true">
              [[item.port_number]]
              <span id="protocolText">
                <template is="dom-if" if="[[!item.protocol_type]]" restamp>
                  $i18n{crostiniPortForwardingTCP}
                </template>
                <template is="dom-if" if="[[item.protocol_type]]" restamp>
                  $i18n{crostiniPortForwardingUDP}
                </template>
              </span>
            </div>
            <div class="label-column" aria-hidden="true">
              <div id="crostiniPortLabel[[cidx]]-[[index]]"
                  class="label-text"
                  aria-hidden="true">
                [[item.label]]
              </div>
              <cr-toggle
                  id="toggleActivationButton[[cidx]]-[[index]]"
                  checked="[[item.is_active]]"
                  data-port-number$="[[item.port_number]]"
                  data-protocol-type$="[[item.protocol_type]]"
                  data-container-id="[[item.container_id]]"
                  on-change="onPortActivationChange_"
                  aria-label="$i18n{crostiniPortForwardingToggleAriaLabel}"
                  aria-describedby$="crostiniPort[[cidx]]-[[index]]
                      crostiniPortLabel[[cidx]]-[[index]]"
                  disabled="[[!containerInfo.ipv4]]">
              </cr-toggle>
              <cr-icon-button
                  id="removeSinglePortButton[[cidx]]-[[index]]"
                  class="icon-clear"
                  title="$i18n{moreActions}"
                  on-click="onRemoveSinglePortClick_"
                  data-port-number$="[[item.port_number]]"
                  data-protocol-type$="[[item.protocol_type]]"
                  data-container-id="[[item.container_id]]"
                  aria-label=
                      "$i18n{crostiniPortForwardingShowMoreActionsAriaLabel}"
                  aria-describedby$="crostiniPort[[cidx]]-[[index]]
                      crostiniPortLabel[[cidx]]-[[index]]">
              </cr-icon-button>
            </div>
          </div>
        </template>
      </div>
    </template>
  </template>
</template>
<template is="dom-if" if="[[showAddPortDialog_]]" restamp>
  <settings-crostini-add-port-dialog
      on-close="onAddPortDialogClose_"
      all-ports="[[allPorts_]]"
      all-containers="[[allContainers_]]">
  </settings-crostini-add-port-dialog>
</template>
<cr-lazy-render id="removeAllPortsMenu">
  <template>
    <cr-action-menu class="complex" role-description="$i18n{menu}">
      <button id="removeAllPortsButton"
          class="dropdown-item"
          role="menuitem"
          on-click="onRemoveAllPortsClick_"
          aria-label="$i18n{crostiniPortForwardingRemoveAllPortsAriaLabel}">
        $i18n{crostiniPortForwardingRemoveAllPorts}
      </button>
    </cr-action-menu>
  </template>
</cr-lazy-render>
<cr-toast id="errorToast" duration="3000">
  <div class="error-message" id="errorMessage">
    <iron-icon id="errorIcon" icon="cr:error-outline"></iron-icon>
    $i18n{crostiniPortForwardingActivatePortError}
  </div>
</cr-toast>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CrostiniPortForwardingBase=PrefsMixin(WebUiListenerMixin(PolymerElement));class CrostiniPortForwardingElement extends CrostiniPortForwardingBase{static get is(){return"settings-crostini-port-forwarding"}static get template(){return getTemplate$3i()}static get properties(){return{showAddPortDialog_:{type:Boolean,value:false},allPorts_:{type:Array,notify:true,value(){return[]}},allContainers_:{type:Array,notify:true,value(){return[]}},activeInterface_:{type:String,value:""},activeIpAddress_:{type:String,value:""}}}static get observers(){return["onCrostiniPortsChanged_(prefs.crostini.port_forwarding.ports.value)"]}constructor(){super();this.activePorts_=[];this.lastMenuOpenedPort_=null;this.browserProxy_=CrostiniBrowserProxyImpl.getInstance()}connectedCallback(){super.connectedCallback();this.addWebUiListener("crostini-port-forwarder-active-ports-changed",(ports=>this.onCrostiniPortsActiveStateChanged_(ports)));this.addWebUiListener("crostini-container-info",(infos=>this.onContainerInfo_(infos)));this.addWebUiListener("crostini-active-network-info",((iface,ipAddress)=>this.onCrostiniActiveNetworkInfo_([iface,ipAddress])));this.browserProxy_.getCrostiniActivePorts().then((ports=>this.onCrostiniPortsActiveStateChanged_(ports)));this.browserProxy_.getCrostiniActiveNetworkInfo().then((networkInfo=>this.onCrostiniActiveNetworkInfo_(networkInfo)));this.browserProxy_.requestContainerInfo()}onCrostiniActiveNetworkInfo_(networkInfo){this.set("activeInterface_",networkInfo[0]);this.set("activeIpAddress_",networkInfo[1])}onContainerInfo_(containerInfos){this.set("allContainers_",containerInfos)}onCrostiniPortsChanged_(ports){this.splice("allPorts_",0,this.allPorts_.length);for(const port of ports){port.is_active=this.activePorts_.some((activePort=>activePort.port_number===port.port_number&&activePort.protocol_type===port.protocol_type));port.container_id=port.container_id||{vm_name:port["vm_name"]||DEFAULT_CROSTINI_VM,container_name:port["container_name"]||DEFAULT_CROSTINI_CONTAINER,vm_type:DEFAULT_CROSTINI_VM_TYPE};this.push("allPorts_",port)}this.notifyPath("allContainers_")}onCrostiniPortsActiveStateChanged_(ports){this.activePorts_=ports;for(let i=0;i<this.allPorts_.length;i++){this.set(`allPorts_.${i}.${"is_active"}`,this.activePorts_.some((activePort=>activePort.port_number===this.allPorts_[i].port_number&&activePort.protocol_type===this.allPorts_[i].protocol_type)))}}onAddPortClick_(){this.showAddPortDialog_=true}onAddPortDialogClose_(){this.showAddPortDialog_=false}onShowRemoveAllPortsMenuClick_(event){const menu=this.$.removeAllPortsMenu.get();menu.showAt(event.target)}onRemoveSinglePortClick_(event){const target=event.currentTarget;const containerId=target["dataContainerId"];const portNumber=Number(target.dataset["portNumber"]);const protocolType=Number(target.dataset["protocolType"]);this.browserProxy_.removeCrostiniPortForward(containerId,portNumber,protocolType).then((_result=>{}))}onRemoveAllPortsClick_(){const menu=this.$.removeAllPortsMenu.get();assert(menu.open);for(const container of this.allContainers_){this.browserProxy_.removeAllCrostiniPortForwards(container.id)}menu.close()}onPortActivationChange_(event){const target=event.currentTarget;const containerId=target["dataContainerId"];const portNumber=Number(target.dataset["portNumber"]);const protocolType=Number(target.dataset["protocolType"]);if(target.checked){target.checked=false;this.browserProxy_.activateCrostiniPortForward(containerId,portNumber,protocolType).then((result=>{if(!result){this.$.errorToast.show()}}))}else{this.browserProxy_.deactivateCrostiniPortForward(containerId,portNumber,protocolType).then((_result=>{}))}}showContainerId_(allPorts,id){return allPorts.some((port=>equalContainerId(port.container_id,id)))&&allPorts.some((port=>!equalContainerId(port.container_id,DEFAULT_CROSTINI_GUEST_ID)))}containerLabel_(id){return containerLabel(id,DEFAULT_CROSTINI_VM)}hasContainerPorts_(allPorts,id){return allPorts.some((port=>equalContainerId(port.container_id,id)))}byContainerId_(id){return port=>equalContainerId(port.container_id,id)}}customElements.define(CrostiniPortForwardingElement.is,CrostiniPortForwardingElement);function getTemplate$3h(){return html`<!--_html_template_start_--><style include="settings-shared md-select">#selectDevice{width:100%}.custom-body{padding-bottom:20px}.custom-button-container{float:right}.input-container{padding-bottom:10px}</style>
<cr-dialog id="dialog" close-text="$i18n{close}">
  <div slot="title">$i18n{guestOsSharedUsbDevicesAddTitle}</div>
  <div slot="body">
    <div class="input-container">
      <label class="cr-form-field-label">Device</label>
      <select id="selectDevice" class="md-select"
          disabled="[[!sharedUsbDevices.length]]">
        <template is="dom-if" if="[[!sharedUsbDevices.length]]" restamp>
          <option>$i18n{guestOsSharedUsbDevicesListEmptyMessage}</option>
        </template>
        <template is="dom-repeat" items="[[sharedUsbDevices]]">
          <option value="[[item.device.guid]]">
            [[item.device.label]]
            [[[item.device.vendorId]]:[[item.device.productId]]]
          </option>
        </template>
      </select>
    </div>
    <template is="dom-if" if="[[showContainerSelect_(allContainers)]]" restamp>
      <settings-guest-os-container-select
          containers="[[allContainers]]"
          selected-container-id="{{guestId_}}"
          default-vm-name="[[defaultGuestId.vm_name]]">
      </settings-guest-os-container-select>
    </template>
  </div>
  <div slot="body" class="custom-body">
    <div slot="button-container" class="custom-button-container">
      <cr-button id="cancel" class="cancel-button" on-click="onCancelClick_">
        $i18n{cancel}
      </cr-button>
      <cr-button id="continue" class="action-button"
          disabled="[[!sharedUsbDevices.length]]" on-click="onAddClick_">
        $i18n{add}
      </cr-button>
    </div>
  </div>
</cr-dialog>
<template is="dom-if" if="[[reassignDevice_]]" restamp>
  <cr-dialog id="reassignDialog" close-text="$i18n{close}"
      on-cancel="onReassignCancel_" show-on-attach>
    <div slot="title">
      $i18n{guestOsSharedUsbDevicesInUse}
    </div>
    <div slot="body">
      [[getReassignDialogText_(reassignDevice_)]]
    </div>
    <div slot="button-container">
      <cr-button id="cancel" class="cancel-button" on-click="onReassignCancel_">
        $i18n{cancel}
      </cr-button>
      <cr-button id="continue" class="action-button"
          on-click="onReassignContinueClick_">
        $i18n{continue}
      </cr-button>
    </div>
  </cr-dialog>
</template>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const GuestOsSharedUsbDevicesAddDialogElementBase=I18nMixin(PolymerElement);class GuestOsSharedUsbDevicesAddDialog extends GuestOsSharedUsbDevicesAddDialogElementBase{static get is(){return"settings-guest-os-shared-usb-devices-add-dialog"}static get template(){return getTemplate$3h()}static get properties(){return{sharedUsbDevices:Array,defaultGuestId:{type:Object,value(){return{vm_name:"",container_name:""}}},guestId_:Object,allContainers:{type:Array,value:[]},reassignDevice_:{type:Object,value:null}}}constructor(){super();this.browserProxy_=GuestOsBrowserProxyImpl.getInstance()}connectedCallback(){super.connectedCallback();this.$.dialog.showModal();microTask.run((()=>{this.$.selectDevice.focus()}))}onCancelClick_(){this.$.dialog.close()}onAddClick_(){const sharedUsbDevice=this.sharedUsbDevices.find((({device:device})=>device.guid===this.$.selectDevice.value));const{device:device}=castExists(sharedUsbDevice);if(device.promptBeforeSharing){this.reassignDevice_=device;return}const guestId=this.guestId_||this.defaultGuestId;this.browserProxy_.setGuestOsUsbDeviceShared(guestId.vm_name,guestId.container_name,device.guid,true);this.$.dialog.close()}onReassignCancel_(){this.reassignDevice_=null}onReassignContinueClick_(){assertExists(this.reassignDevice_);const guestId=this.guestId_||this.defaultGuestId;this.browserProxy_.setGuestOsUsbDeviceShared(guestId.vm_name,guestId.container_name,this.reassignDevice_.guid,true);this.reassignDevice_=null;this.$.dialog.close()}getReassignDialogText_(device){return this.i18n("guestOsSharedUsbDevicesReassign",device.label)}showContainerSelect_(allContainers){return allContainers.length>1}}customElements.define(GuestOsSharedUsbDevicesAddDialog.is,GuestOsSharedUsbDevicesAddDialog);function getTemplate$3g(){return html`<!--_html_template_start_--><style include="settings-shared md-select">.toggle-container{display:flex;flex-direction:row;flex-wrap:nowrap;justify-content:space-between}#selectDevice{width:100%}</style>
<settings-toggle-button
    id="guestShowUsbNotificationToggle"
    pref="{{prefs.guest_os.usb_notification_enabled}}"
    no-set-pref
    label="$i18n{guestOsSharedUsbDevicesNotificationsLabel}"
    on-settings-boolean-control-change="onGuestUsbNotificationChange_"
    deep-link-focus-id$="[[Setting.kGuestUsbNotification]]">
</settings-toggle-button>
<settings-toggle-button
    id="guestUsbPersistentPassthroughToggle"
    pref="{{prefs.guest_os.usb_persistent_passthrough_enabled}}"
    no-set-pref
    label="$i18n{guestOsSharedUsbPersistentPassthroughLabel}"
    on-settings-boolean-control-change="onGuestUsbPersistentPassthroughChange_"
    deep-link-focus-id$="[[Setting.kGuestUsbPersistentPassthrough]]">
</settings-toggle-button>
<div class="settings-box first">
  <div class="settings-box-text">
    [[getDescriptionText_()]]
    <div class="secondary" id="secondaryText">
      $i18n{guestOsSharedUsbDevicesExtraDescription}
    </div>
  </div>
</div>
<template is="dom-if" if="[[!hasContainers]]" restamp>
  <div class="settings-box secondary continuation"
      hidden="[[sharedUsbDevices_.length]]">
     $i18n{guestOsSharedUsbDevicesListEmptyMessage}
  </div>
  <template is="dom-if" if="[[sharedUsbDevices_.length]]" restamp>
    <div class="list-frame vertical-list">
      <template is="dom-repeat" items="[[sharedUsbDevices_]]">
        <div class="list-item toggle-container">
          <div class="label">[[item.device.label]]</div>
          <cr-toggle class="toggle" checked="[[item.shared]]"
              on-change="onDeviceSharedChange_"
              aria-label$="[[item.device.label]]">
          </cr-toggle>
        </div>
      </template>
    </div>
  </template>
</template>

<template is="dom-if" if="[[hasContainers]]" restamp>
  <div id="addUsb" class="settings-box first">
    <div id="usbTableTitle" class="start"
        aria-hidden="true">
      $i18n{guestOsSharedUsbDevicesTableTitle}
    </div>
    <cr-button id="addUsbBtn" on-click="onAddUsbClick_"
        aria-label="$i18n{guestOsSharedUsbDevicesAddTitle}"
        aria-describedby="addUsb">
      $i18n{add}
    </cr-button>
  </div>
  <template is="dom-if" if="[[sharedUsbDevices_.length]]" restamp>
    <template is="dom-repeat" items="[[allContainers_]]"
        as="containerInfo" index-as="cidx" mutable-data>
      <template is="dom-if"
          if="[[showGuestId_(sharedUsbDevices_, containerInfo.id)]]" restamp>
        <h2 id="usbListContainerId[[cidx]]"
            hidden="[[!showGuestId_(sharedUsbDevices_, containerInfo.id)]]"
            class="settings-box usb-list-guest-id">
            [[guestLabel_(containerInfo.id)]]
        </h2>
        <div class="list-frame vertical-list usb-list-card"
            id="usbListCard[[cidx]]">
          <template is="dom-repeat" items="[[sharedUsbDevices_]]"
              filter="[[byGuestId_(containerInfo.id)]]" mutable-data>
            <div class="list-item">
              <div id="usbLabel[[cidx]]-[[index]]"
                  class="start usb-list-card-label" aria-hidden="true">
                [[item.device.label]]
              </div>
              <cr-icon-button id="removeUsb[[cidx]]-[[index]]"
                  class="icon-clear usb-list-card-remove" title="$i18n{remove}"
                  on-click="onRemoveUsbClick_" data-guid$="[[item.device.guid]]"
                  aria-label="$i18n{remove}"
                  aria-describedby$="usbLabel[[cidx]]-[[index]]">
              </cr-icon-button>
            </div>
          </template>
        </div>
      </template>
    </template>
  </template>
  <template is="dom-if"
      if="[[!hasSharedDevices_(sharedUsbDevices_, allContainers_)]]" restamp>
    <div class="settings-box secondary">
      $i18n{guestOsSharedUsbDevicesNoneAttached}
    </div>
  </template>
</template>
<template is="dom-if" if="[[showAddUsbDialog_]]" restamp>
  <settings-guest-os-shared-usb-devices-add-dialog
      on-close="onAddUsbDialogClose_"
      shared-usb-devices="[[sharedUsbDevices_]]"
      all-containers="[[allContainers_]]"
      default-guest-id="[[defaultGuestId]]">
  </settings-guest-os-shared-usb-devices-add-dialog>
</template>
<template is="dom-if" if="[[reassignDevice_]]" restamp>
  <cr-dialog id="reassignDialog" close-text="$i18n{close}"
      on-cancel="onReassignCancel_" show-on-attach>
    <div slot="title">
      $i18n{guestOsSharedUsbDevicesInUse}
    </div>
    <div slot="body">
      [[getReassignDialogText_(reassignDevice_)]]
    </div>
    <div slot="button-container">
      <cr-button id="cancel" class="cancel-button"
          on-click="onReassignCancel_">
        $i18n{cancel}
      </cr-button>
      <cr-button id="continue" class="action-button"
          on-click="onReassignContinueClick_">
        $i18n{continue}
      </cr-button>
    </div>
  </cr-dialog>
</template>
<template is="dom-if" if="[[showGuestUsbNotificationDialog_]]" restamp>
  <settings-guest-os-confirmation-dialog
      id="guestShowUsbNotificationDialog"
      accept-button-text="$i18n{guestOsSharedUsbDevicesNotificationDialogAccept}"
      on-close="onGuestUsbNotificationDialogClose_">
    <div slot="body">
      [[getNotificationDialogText_()]]
    </div>
  </settings-guest-os-confirmation-dialog>
</template>
<template is="dom-if" if="[[showGuestUsbPersistentPassthroughDialog_]]" restamp>
  <settings-guest-os-confirmation-dialog
      id="guestShowUsbPersistentPassthroughDialog"
      accept-button-text="$i18n{guestOsSharedUsbDevicesNotificationDialogAccept}"
      on-close="onGuestUsbPersistentPassthroughDialogClose_">
    <div slot="body">
      [[getGuestUsbPersistentPassthroughDialogText_()]]
    </div>
  </settings-guest-os-confirmation-dialog>
</template>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsGuestOsSharedUsbDevicesElementBase=RouteObserverMixin(DeepLinkingMixin(I18nMixin(WebUiListenerMixin(PrefsMixin(PolymerElement)))));class SettingsGuestOsSharedUsbDevicesElement extends SettingsGuestOsSharedUsbDevicesElementBase{static get is(){return"settings-guest-os-shared-usb-devices"}static get template(){return getTemplate$3g()}static get properties(){return{showGuestUsbNotificationDialog_:{type:Boolean,value:false},showGuestUsbPersistentPassthroughDialog_:{type:Boolean,value:false},guestOsType:{type:String,value:""},sharedUsbDevices_:{type:Array,value(){return[]}},defaultGuestId:{type:Object,value(){return{vm_name:"",container_name:""}}},reassignDevice_:{type:Object,value:null},hasContainers:{type:Boolean,value(){return false}},showAddUsbDialog_:{type:Boolean,value:false},allContainers_:{type:Array,notify:true,value(){return[]}}}}constructor(){super();this.supportedSettingIds=new Set([Setting.kGuestUsbNotification,Setting.kGuestUsbPersistentPassthrough]);this.browserProxy_=GuestOsBrowserProxyImpl.getInstance()}ready(){super.ready();this.addWebUiListener("guest-os-shared-usb-devices-changed",this.onGuestOsSharedUsbDevicesChanged_.bind(this));this.browserProxy_.notifyGuestOsSharedUsbDevicesPageReady()}currentRouteChanged(newRoute){if(newRoute!==routes.CROSTINI_SHARED_USB_DEVICES){return}this.attemptDeepLink()}onContainerInfo_(containerInfos){this.set("allContainers_",containerInfos)}showGuestId_(sharedUsbDevices,id){return sharedUsbDevices.some(this.byGuestId_(id))}hasSharedDevices_(sharedUsbDevices,containerInfos){return sharedUsbDevices.some((dev=>containerInfos.some((info=>dev.device.guestId&&equalContainerId(dev.device.guestId,info.id)))))}onGuestOsSharedUsbDevicesChanged_(devices){this.sharedUsbDevices_=devices.map((device=>({shared:!!device.guestId&&device.guestId.vm_name===this.vmName_(),device:device})))}onDeviceSharedChange_(event){const device=event.model.item.device;const target=cast(event.target,CrToggleElement);if(target.checked&&device.promptBeforeSharing){target.checked=false;this.reassignDevice_=device;return}const persistentPassthroughEnabled=this.get("prefs.guest_os.usb_persistent_passthrough_enabled.value");if(!target.checked&&persistentPassthroughEnabled){const deviceIdentifier=`${parseInt(device.vendorId,16)}:${parseInt(device.productId,16)}:${device.serialNumber}`;this.deletePrefDictEntry("guest_os.usb_persistent_passthrough_devices",deviceIdentifier)}this.browserProxy_.setGuestOsUsbDeviceShared(this.vmName_(),this.defaultGuestId.container_name,device.guid,target.checked)}onReassignCancel_(){this.reassignDevice_=null}onReassignContinueClick_(){assertExists(this.reassignDevice_);this.browserProxy_.setGuestOsUsbDeviceShared(this.vmName_(),this.defaultGuestId.container_name,this.reassignDevice_.guid,true);this.reassignDevice_=null}vmName_(){return getVMNameForGuestOsType(this.guestOsType)}getDescriptionText_(){return this.i18n(this.guestOsType+"SharedUsbDevicesDescription")}getReassignDialogText_(device){return this.i18n("guestOsSharedUsbDevicesReassign",device.label)}byGuestId_(id){return dev=>!!dev.device.guestId&&equalContainerId(dev.device.guestId,id)}onAddUsbClick_(){this.showAddUsbDialog_=true}onAddUsbDialogClose_(){this.showAddUsbDialog_=false}guestLabel_(id){return containerLabel(id,this.vmName_())}onRemoveUsbClick_(event){const device=event.model.item.device;if(device.guestId){this.browserProxy_.setGuestOsUsbDeviceShared(device.guestId.vm_name,"",device.guid,false)}}getGuestUsbNotificationToggle_(){return castExists(this.shadowRoot.querySelector("#guestShowUsbNotificationToggle"))}getNotificationDialogText_(){const toggle=this.getGuestUsbNotificationToggle_();return toggle.checked?this.i18n("guestOsSharedUsbDevicesNotificationDialogTitleEnable"):this.i18n("guestOsSharedUsbDevicesNotificationDialogTitleDisable")}onGuestUsbNotificationChange_(){this.showGuestUsbNotificationDialog_=true}onGuestUsbNotificationDialogClose_(e){const toggle=this.getGuestUsbNotificationToggle_();if(e.detail.accepted){toggle.sendPrefChange()}else{toggle.resetToPrefValue()}this.showGuestUsbNotificationDialog_=false}getGuestUsbPersistentPassthroughToggle_(){return castExists(this.shadowRoot.querySelector("#guestUsbPersistentPassthroughToggle"))}getGuestUsbPersistentPassthroughDialogText_(){const toggle=this.getGuestUsbPersistentPassthroughToggle_();return toggle.checked?this.i18n("guestOsSharedUsbPersistentPassthroughDialogTitleEnable"):this.i18n("guestOsSharedUsbPersistentPassthroughDialogTitleDisable")}onGuestUsbPersistentPassthroughChange_(){this.showGuestUsbPersistentPassthroughDialog_=true}onGuestUsbPersistentPassthroughDialogClose_(e){const toggle=this.getGuestUsbPersistentPassthroughToggle_();if(e.detail.accepted){toggle.sendPrefChange();if(!toggle.checked){this.setPrefValue("guest_os.usb_persistent_passthrough_devices",{})}}else{toggle.resetToPrefValue()}this.showGuestUsbPersistentPassthroughDialog_=false}}customElements.define(SettingsGuestOsSharedUsbDevicesElement.is,SettingsGuestOsSharedUsbDevicesElement);
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class CrostiniSharedUsbDevicesElement extends SettingsGuestOsSharedUsbDevicesElement{static get is(){return"settings-crostini-shared-usb-devices"}static get properties(){return{...SettingsGuestOsSharedUsbDevicesElement.properties,guestOsType:{type:String,value:"crostini"},defaultGuestId:{type:Object,value(){return DEFAULT_CROSTINI_GUEST_ID}},hasContainers:{type:Boolean,value(){return loadTimeData.getBoolean("showCrostiniExtraContainers")}}}}ready(){super.ready();this.addWebUiListener("crostini-container-info",(infos=>this.onContainerInfo_(infos)));CrostiniBrowserProxyImpl.getInstance().requestContainerInfo()}}customElements.define(CrostiniSharedUsbDevicesElement.is,CrostiniSharedUsbDevicesElement);function getTemplate$3f(){return html`<!--_html_template_start_--><style include="settings-shared">#disk-labels{display:flex;justify-content:space-between}#resize-block{align-items:stretch;margin-inline-end:10px;margin-inline-start:10px}.error{color:var(--cros-text-color-alert)}#errorIcon{--iron-icon-fill-color:var(--cros-icon-color-alert);display:inline-block}#warningIcon{--iron-icon-fill-color:var(--cros-icon-color-warning)}#message{margin-inline-end:auto}
</style>
<cr-dialog id="diskResizeDialog" close-text="$i18n{close}">
  <!-- The title gets read out multiple times. This was a deliberate
       tradeoff made by cr-dialog so for now that's what we're stuck with:
       https://chromium-review.googlesource.com/c/chromium/src/+/1906254
  -->
  <div slot="title">$i18n{crostiniDiskResizeTitle}</div>
  <div slot="body">
    <template is="dom-if" if="[[eq_(displayState_, DisplayStateEnum_.RESIZE)]]">
      <div>
        <div hidden="[[isLowSpaceAvailable_]]" id="recommended-size">
          $i18n{crostiniDiskResizeRecommended}
        </div>
        <div hidden="[[!isLowSpaceAvailable_]]"
            id="recommended-size-warning">
          <iron-icon id="warningIcon" icon="cr:warning"></iron-icon>
          $i18n{crostiniDiskResizeRecommendedWarning}
        </div>
      </div>
      <div id="resize-block">
        <cr-slider id="diskSlider" pin="true"
            value="[[defaultDiskSizeTick_]]" ticks="[[diskSizeTicks_]]"
            disabled="[[resizing_]]" max="[[maxDiskSizeTick_]]">
        </cr-slider>
        <div id="disk-labels" aria-hidden="true">
          <div id="label-begin">[[minDiskSize_]]</div>
          <div id="label-end">[[maxDiskSize_]]</div>
        </div>
      </div>
    </template>
    <template is="dom-if"
        if="[[eq_(displayState_, DisplayStateEnum_.UNSUPPORTED)]]">
      <div id="unsupported">
        $i18n{crostiniDiskResizeUnsupported}
      </div>
    </template>
    <template is="dom-if" if="[[eq_(displayState_, DisplayStateEnum_.LOADING)]]">
      <div id="loading">
        $i18n{crostiniDiskResizeLoading}
      </div>
    </template>
    <template is="dom-if" if="[[eq_(displayState_, DisplayStateEnum_.ERROR)]]">
      <span id="error" aria-hidden="true">
        $i18n{crostiniDiskResizeError}
      </span>
      <cr-button id="retry" on-click="onRetryClick_"
          aria-describedby="error">
        $i18n{crostiniDiskResizeErrorRetry}
      </cr-button>
    </template>
  </div>
  <div slot="button-container">
    <div id="message" aria-live="assertive">
      <span id="resizing"
          hidden="[[!eq_(resizeState_, ResizeStateEnum_.RESIZING)]]">
        $i18n{crostiniDiskResizeInProgress}
      </span>
      <template is="dom-if" if="[[eq_(resizeState_, ResizeStateEnum_.ERROR)]]">
        <span id="resize-error" class="error">
          <iron-icon id="errorIcon" icon="cr:error-outline"></iron-icon>
          $i18n{crostiniDiskResizeResizingError}
        </span>
      </template>
      <span id="done" hidden="[[!eq_(resizeState_, ResizeStateEnum_.DONE)]]">
        $i18n{crostiniDiskResizeDone}
      </span>
    </div>
    <cr-button id="cancel" class="cancel-button"
        disabled="[[eq_(resizeState_, ResizeStateEnum_.RESIZING)]]"
        on-click="onCancelClick_">
      $i18n{crostiniDiskResizeCancel}
    </cr-button>
    <cr-button id="resize" class="action-button"
        disabled="[[resizeDisabled_(displayState_, resizeState_)]]"
        on-click="onResizeClick_">
      $i18n{crostiniDiskResizeGoButton}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var DisplayState;(function(DisplayState){DisplayState["LOADING"]="loading";DisplayState["UNSUPPORTED"]="unsupported";DisplayState["ERROR"]="error";DisplayState["RESIZE"]="resize"})(DisplayState||(DisplayState={}));var ResizeState;(function(ResizeState){ResizeState["INITIAL"]="initial";ResizeState["RESIZING"]="resizing";ResizeState["ERROR"]="error";ResizeState["DONE"]="done"})(ResizeState||(ResizeState={}));class SettingsCrostiniDiskResizeDialogElement extends PolymerElement{static get is(){return"settings-crostini-disk-resize-dialog"}static get template(){return getTemplate$3f()}static get properties(){return{minDiskSize_:{type:String},maxDiskSize_:{type:String},diskSizeTicks_:{type:Array},defaultDiskSizeTick_:{type:Number},maxDiskSizeTick_:{type:Number},isLowSpaceAvailable_:{type:Boolean,value:false},displayState_:{type:String,value:DisplayState.LOADING},resizeState_:{type:String,value:ResizeState.INITIAL},DisplayStateEnum_:{type:Object,value:DisplayState},ResizeStateEnum_:{type:Object,value:ResizeState}}}constructor(){super();this.browserProxy_=CrostiniBrowserProxyImpl.getInstance()}connectedCallback(){super.connectedCallback();this.displayState_=DisplayState.LOADING;this.$.diskResizeDialog.showModal();this.loadDiskInfo_()}loadDiskInfo_(){this.browserProxy_.getCrostiniDiskInfo(TERMINA_VM_TYPE,true).then((diskInfo=>{if(!diskInfo.succeeded){this.displayState_=DisplayState.ERROR}else if(!diskInfo.canResize){this.displayState_=DisplayState.UNSUPPORTED}else{this.displayState_=DisplayState.RESIZE;this.maxDiskSizeTick_=diskInfo.ticks.length-1;this.defaultDiskSizeTick_=diskInfo.defaultIndex;this.diskSizeTicks_=diskInfo.ticks;this.minDiskSize_=diskInfo.ticks[0].label;this.maxDiskSize_=diskInfo.ticks[diskInfo.ticks.length-1].label;this.isLowSpaceAvailable_=diskInfo.isLowSpaceAvailable}}),(reason=>{console.warn(`Unable to get info: ${reason}`);this.displayState_=DisplayState.ERROR}))}onCancelClick_(){this.$.diskResizeDialog.close()}onRetryClick_(){this.displayState_=DisplayState.LOADING;this.loadDiskInfo_()}onResizeClick_(){const slider=castExists(this.shadowRoot.querySelector("#diskSlider"));const selectedIndex=slider.value;const size=this.diskSizeTicks_[selectedIndex].value;this.resizeState_=ResizeState.RESIZING;this.browserProxy_.resizeCrostiniDisk("termina",size).then((succeeded=>{if(succeeded){this.resizeState_=ResizeState.DONE;recordSettingChange(Setting.kCrostiniDiskResize);this.$.diskResizeDialog.close()}else{this.resizeState_=ResizeState.ERROR}}),(reason=>{console.warn(`Unable to resize disk: ${reason}`);this.resizeState_=ResizeState.ERROR}))}eq_(a,b){return a===b}resizeDisabled_(displayState,resizeState){return displayState!==DisplayState.RESIZE||resizeState===ResizeState.RESIZING}}customElements.define(SettingsCrostiniDiskResizeDialogElement.is,SettingsCrostiniDiskResizeDialogElement);function getTemplate$3e(){return html`<!--_html_template_start_--><style include="settings-shared"></style>
<cr-dialog id="dialog" close-text="$i18n{close}">
  <div slot="title">$i18n{crostiniDiskResizeConfirmationDialogTitle}</div>
  <div slot="body">$i18n{crostiniDiskResizeConfirmationDialogMessage}</div>
  <div slot="button-container">
    <cr-button id="cancel" class="cancel-button"
        on-click="onCancelClick_">$i18n{cancel}</cr-button>
    <cr-button id="continue" class="action-button"
        on-click="onReserveSizeClick_">
        $i18n{crostiniDiskResizeConfirmationDialogButton}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class SettingsCrostiniDiskResizeConfirmationDialogElement extends PolymerElement{static get is(){return"settings-crostini-disk-resize-confirmation-dialog"}static get template(){return getTemplate$3e()}connectedCallback(){super.connectedCallback();this.getDialog_().showModal()}onCancelClick_(){this.getDialog_().cancel()}onReserveSizeClick_(){this.getDialog_().close()}getDialog_(){return this.$.dialog}}customElements.define(SettingsCrostiniDiskResizeConfirmationDialogElement.is,SettingsCrostiniDiskResizeConfirmationDialogElement);function getTemplate$3d(){return html`<!--_html_template_start_--><style include="settings-shared"></style>
<template is="dom-if" if="[[showCrostiniContainerUpgrade_]]">
  <div id="container-upgrade" class="settings-box first">
    <iron-icon icon="cr:file-download"></iron-icon>
    <div class="middle settings-box-text" aria-hidden="true">
      <div id="containerUpgradeLabel">
        $i18n{crostiniContainerUpgrade}
      </div>
      <div class="secondary" id="containerUpgradeDescription">
        $i18n{crostiniContainerUpgradeSubtext}
      </div>
    </div>
    <cr-button id="containerUpgradeButton"
        on-click="onContainerUpgradeClick_"
        aria-labelledby="containerUpgradeLabel containerUpgradeButton"
        aria-describedby="containerUpgradeDescription"
        disabled="[[disableUpgradeButton_]]"
        deep-link-focus-id$="[[Setting.kCrostiniContainerUpgrade]]">
      $i18n{crostiniContainerUpgradeButton}
    </cr-button>
  </div>
</template>
<cr-link-row
    id="crostiniSharedPathsRow"
    class="hr"
    label="$i18n{guestOsSharedPaths}"
    on-click="onSharedPathsClick_"
    role-description="$i18n{subpageArrowRoleDescription}">
</cr-link-row>
<cr-link-row
    id="crostiniSharedUsbDevicesRow"
    class="hr"
    label="$i18n{guestOsSharedUsbDevicesLabel}"
    on-click="onSharedUsbDevicesClick_"
    role-description="$i18n{subpageArrowRoleDescription}">
</cr-link-row>
<template is="dom-if" if="[[showCrostiniExtraContainers_]]">
  <cr-link-row
      id="crostiniExtraContainersRow"
      class="hr"
      label="$i18n{crostiniExtraContainersLabel}"
      on-click="onExtraContainersClick_"
      role-description="$i18n{subpageArrowRoleDescription}">
  </cr-link-row>
</template>
<template is="dom-if" if="[[showCrostiniExportImport_]]">
  <cr-link-row
      id="crostiniExportImportRow"
      class="hr"
      label="$i18n{crostiniExportImportTitle}"
      on-click="onExportImportClick_"
      role-description="$i18n{subpageArrowRoleDescription}">
  </cr-link-row>
</template>
<template is="dom-if" if="[[showArcAdbSideloading_]]">
  <cr-link-row
      id="crostiniEnableArcAdbRow"
      class="hr"
      label="$i18n{crostiniArcAdbTitle}"
      on-click="onEnableArcAdbClick_"
      role-description="$i18n{subpageArrowRoleDescription}">
  </cr-link-row>
</template>
<template is="dom-if" if="[[showCrostiniPortForwarding_]]">
  <cr-link-row
      id="crostiniPortForwardingRow"
      class="hr"
      label="$i18n{crostiniPortForwarding}"
      on-click="onPortForwardingClick_"
      role-description="$i18n{subpageArrowRoleDescription}">
  </cr-link-row>
</template>
<div class="settings-box hr" id="crostiniDiskResizeRow">
  <div class="start">
    <div>
      $i18n{crostiniDiskResizeLabel}
    </div>
    <div class="secondary" id="diskSizeDescription">
      [[diskSizeLabel_]]
    </div>
  </div>
  <cr-button on-click="onDiskResizeClick_" hidden="[[!canDiskResize_]]"
      aria-label="[[diskResizeButtonAriaLabel_]]"
      aria-describedby="diskSizeDescription" id="showDiskResizeButton"
      deep-link-focus-id$="[[Setting.kCrostiniDiskResize]]">
    [[diskResizeButtonLabel_]]
  </cr-button>
</div>
<template is="dom-if" if="[[showDiskResizeDialog_]]" restamp>
  <settings-crostini-disk-resize-dialog on-close="onDiskResizeDialogClose_">
  </settings-crostini-disk-resize-dialog>
</template>
<template is="dom-if" if="[[showDiskResizeConfirmationDialog_]]" restamp>
  <settings-crostini-disk-resize-confirmation-dialog
      on-close="onDiskResizeConfirmationDialogClose_"
      on-cancel="onDiskResizeConfirmationDialogCancel_">
  </settings-crostini-disk-resize-confirmation-dialog>
</template>
<settings-toggle-button
    class="hr"
    id="crostini-mic-permission-toggle"
    pref="{{prefs.crostini.mic_allowed}}"
    no-set-pref
    label="$i18n{crostiniMicTitle}"
    on-settings-boolean-control-change="onMicPermissionChange_"
    deep-link-focus-id$="[[Setting.kCrostiniMicAccess]]">
</settings-toggle-button>
<template is="dom-if" if="[[showCrostiniMicPermissionDialog_]]" restamp>
  <settings-guest-os-confirmation-dialog
      id="crostini-mic-permission-dialog"
      accept-button-text="$i18n{crostiniMicDialogShutdownButton}"
      on-close="onCrostiniMicPermissionDialogClose_">
    <div slot="body">$i18n{crostiniMicDialogLabel}</div>
  </settings-guest-os-confirmation-dialog>
</template>
<template is="dom-if" if="[[!hideCrostiniUninstall_]]">
  <div id="remove" class="settings-box">
    <div id="removeCrostiniLabel" class="start" aria-hidden="true">
      $i18n{crostiniRemove}
    </div>
    <cr-button on-click="onRemoveClick_"
        aria-label="$i18n{crostiniRemoveButton}"
        aria-describedby="removeCrostiniLabel"
        deep-link-focus-id$="[[Setting.kUninstallCrostini]]">
      $i18n{crostiniRemoveButton}
    </cr-button>
  </div>
</template>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var ConfirmationState;(function(ConfirmationState){ConfirmationState["NOT_CONFIRMED"]="notConfirmed";ConfirmationState["CONFIRMED"]="confirmed"})(ConfirmationState||(ConfirmationState={}));const SettingsCrostiniSubpageElementBase=DeepLinkingMixin(RouteOriginMixin(PrefsMixin(WebUiListenerMixin(PolymerElement))));class SettingsCrostiniSubpageElement extends SettingsCrostiniSubpageElementBase{static get is(){return"settings-crostini-subpage"}static get template(){return getTemplate$3d()}static get properties(){return{showCrostiniExportImport_:{type:Boolean,value(){return loadTimeData.getBoolean("showCrostiniExportImport")}},showArcAdbSideloading_:{type:Boolean,computed:"and_(isArcAdbSideloadingSupported_, isAndroidEnabled_)"},isArcAdbSideloadingSupported_:{type:Boolean,value(){return loadTimeData.getBoolean("arcAdbSideloadingSupported")}},showCrostiniPortForwarding_:{type:Boolean,value(){return loadTimeData.getBoolean("showCrostiniPortForwarding")&&!loadTimeData.getBoolean("isBaguette")}},showCrostiniExtraContainers_:{type:Boolean,value(){return loadTimeData.getBoolean("showCrostiniExtraContainers")}},isAndroidEnabled_:{type:Boolean},hideCrostiniUninstall_:{type:Boolean,computed:"or_(installerShowing_, upgraderDialogShowing_)"},showCrostiniContainerUpgrade_:{type:Boolean,value(){return loadTimeData.getBoolean("showCrostiniContainerUpgrade")}},showDiskResizeConfirmationDialog_:{type:Boolean,value:false},installerShowing_:{type:Boolean},upgraderDialogShowing_:{type:Boolean},disableUpgradeButton_:{type:Boolean,computed:"or_(installerShowing_, upgraderDialogShowing_)"},showDiskResizeDialog_:{type:Boolean,value:false},showCrostiniMicPermissionDialog_:{type:Boolean,value:false},diskSizeLabel_:{type:String,value:loadTimeData.getString("crostiniDiskSizeCalculating")},diskResizeButtonLabel_:{type:String,value:loadTimeData.getString("crostiniDiskResizeShowButton")},diskResizeButtonAriaLabel_:{type:String,value:loadTimeData.getString("crostiniDiskResizeShowButtonAriaLabel")},canDiskResize_:{type:Boolean,value:false}}}static get observers(){return["onCrostiniEnabledChanged_(prefs.crostini.enabled.value)","onArcEnabledChanged_(prefs.arc.enabled.value)"]}constructor(){super();this.supportedSettingIds=new Set([Setting.kUninstallCrostini,Setting.kCrostiniDiskResize,Setting.kCrostiniMicAccess,Setting.kCrostiniContainerUpgrade]);this.route=routes.CROSTINI_DETAILS;this.isDiskUserChosenSize_=false;this.diskResizeConfirmationState_=ConfirmationState.NOT_CONFIRMED;this.browserProxy_=CrostiniBrowserProxyImpl.getInstance()}connectedCallback(){super.connectedCallback();this.addWebUiListener("crostini-installer-status-changed",(status=>{this.installerShowing_=status}));this.addWebUiListener("crostini-upgrader-status-changed",(status=>{this.upgraderDialogShowing_=status}));this.addWebUiListener("crostini-container-upgrade-available-changed",(canUpgrade=>{this.showCrostiniContainerUpgrade_=canUpgrade}));this.browserProxy_.requestCrostiniInstallerStatus();this.browserProxy_.requestCrostiniUpgraderDialogStatus();this.browserProxy_.requestCrostiniContainerUpgradeAvailable();this.loadDiskInfo_()}ready(){super.ready();const r=routes;this.addFocusConfig(r.CROSTINI_SHARED_PATHS,"#crostiniSharedPathsRow");this.addFocusConfig(r.CROSTINI_SHARED_USB_DEVICES,"#crostiniSharedUsbDevicesRow");this.addFocusConfig(r.CROSTINI_EXPORT_IMPORT,"#crostiniExportImportRow");this.addFocusConfig(r.CROSTINI_ANDROID_ADB,"#crostiniEnableArcAdbRow");this.addFocusConfig(r.CROSTINI_PORT_FORWARDING,"#crostiniPortForwardingRow");this.addFocusConfig(r.CROSTINI_EXTRA_CONTAINERS,"#crostiniExtraContainersRow")}currentRouteChanged(newRoute,oldRoute){super.currentRouteChanged(newRoute,oldRoute);if(newRoute!==this.route){return}this.attemptDeepLink()}onCrostiniEnabledChanged_(enabled){if(!enabled&&Router.getInstance().currentRoute===routes.CROSTINI_DETAILS){Router.getInstance().navigateToPreviousRoute()}if(enabled){this.loadDiskInfo_()}}onArcEnabledChanged_(enabled){this.isAndroidEnabled_=enabled}onExportImportClick_(){Router.getInstance().navigateTo(routes.CROSTINI_EXPORT_IMPORT)}onEnableArcAdbClick_(){Router.getInstance().navigateTo(routes.CROSTINI_ANDROID_ADB)}loadDiskInfo_(){this.browserProxy_.getCrostiniDiskInfo(TERMINA_VM_TYPE,false).then((diskInfo=>{if(diskInfo.succeeded){this.setResizeLabels_(diskInfo)}}),(reason=>{console.warn(`Unable to get info: ${reason}`)}))}setResizeLabels_(diskInfo){this.canDiskResize_=diskInfo.canResize;if(!this.canDiskResize_){this.diskSizeLabel_=loadTimeData.getString("crostiniDiskResizeNotSupportedSubtext");return}this.isDiskUserChosenSize_=diskInfo.isUserChosenSize;if(this.isDiskUserChosenSize_){if(diskInfo.ticks){this.diskSizeLabel_=diskInfo.ticks[diskInfo.defaultIndex].label}this.diskResizeButtonLabel_=loadTimeData.getString("crostiniDiskResizeShowButton");this.diskResizeButtonAriaLabel_=loadTimeData.getString("crostiniDiskResizeShowButtonAriaLabel")}else{this.diskSizeLabel_=loadTimeData.getString("crostiniDiskResizeDynamicallyAllocatedSubtext");this.diskResizeButtonLabel_=loadTimeData.getString("crostiniDiskReserveSizeButton");this.diskResizeButtonAriaLabel_=loadTimeData.getString("crostiniDiskReserveSizeButtonAriaLabel")}}onDiskResizeClick_(){if(!this.isDiskUserChosenSize_&&this.diskResizeConfirmationState_!==ConfirmationState.CONFIRMED){this.showDiskResizeConfirmationDialog_=true;return}this.showDiskResizeDialog_=true}onDiskResizeDialogClose_(){this.showDiskResizeDialog_=false;this.diskResizeConfirmationState_=ConfirmationState.NOT_CONFIRMED;this.loadDiskInfo_()}onDiskResizeConfirmationDialogClose_(){if(this.showDiskResizeConfirmationDialog_){this.diskResizeConfirmationState_=ConfirmationState.CONFIRMED;this.showDiskResizeConfirmationDialog_=false;this.showDiskResizeDialog_=true}}onDiskResizeConfirmationDialogCancel_(){this.showDiskResizeConfirmationDialog_=false}onRemoveClick_(){this.browserProxy_.requestRemoveCrostini();recordSettingChange(Setting.kUninstallCrostini)}onContainerUpgradeClick_(){this.browserProxy_.requestCrostiniContainerUpgradeView();recordSettingChange(Setting.kCrostiniContainerUpgrade)}onSharedPathsClick_(){Router.getInstance().navigateTo(routes.CROSTINI_SHARED_PATHS)}onSharedUsbDevicesClick_(){Router.getInstance().navigateTo(routes.CROSTINI_SHARED_USB_DEVICES)}onPortForwardingClick_(){Router.getInstance().navigateTo(routes.CROSTINI_PORT_FORWARDING)}onExtraContainersClick_(){Router.getInstance().navigateTo(routes.CROSTINI_EXTRA_CONTAINERS)}getMicToggle_(){return castExists(this.shadowRoot.querySelector("#crostini-mic-permission-toggle"))}async onMicPermissionChange_(){if(await this.browserProxy_.checkCrostiniIsRunning()){this.showCrostiniMicPermissionDialog_=true}else{this.getMicToggle_().sendPrefChange()}}onCrostiniMicPermissionDialogClose_(e){const toggle=this.getMicToggle_();if(e.detail.accepted){toggle.sendPrefChange();this.browserProxy_.shutdownCrostini()}else{toggle.resetToPrefValue()}this.showCrostiniMicPermissionDialog_=false}and_(a,b){return a&&b}or_(a,b){return a||b}}customElements.define(SettingsCrostiniSubpageElement.is,SettingsCrostiniSubpageElement);function getTemplate$3c(){return html`<!--_html_template_start_--><style include="settings-shared">#paragraph1{margin-block-start:0px}#dialogBody{padding-top:10px}cr-dialog::part(dialog){width:370px}</style>

<cr-dialog id="systemGeolocationDialog" show-on-attach>
  <div slot="title">
    $i18n{systemGeolocationDialogTitle}
  </div>
  <div slot="body" id="dialogBody">
    <p id="paragraph1">$i18n{systemGeolocationDialogBodyParagraph1}</p>
    <localized-link
        aria-describedby="paragraph1"
        localized-string="$i18n{systemGeolocationDialogBodyParagraph2}"
        link-url="$i18n{geolocationAccuracyLearnMoreUrl}">
    </localized-link>
  </div>
  <div slot="button-container">
    <cr-button id="cancelButton"
        class="cancel-button"
        on-click="onCancelClicked_">
      $i18n{systemGeolocationDialogCancelButton}
    </cr-button>
    <cr-button id="confirmButton"
        class="action-button"
        on-click="onEnableClicked_">
      $i18n{systemGeolocationDialogConfirmButton}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PrivacyHubGeolocationDialogBase=PrefsMixin(PolymerElement);class PrivacyHubGeolocationDialog extends PrivacyHubGeolocationDialogBase{static get is(){return"settings-privacy-hub-geolocation-dialog"}static get template(){return getTemplate$3c()}onEnableClicked_(){this.setPrefValue("ash.user.geolocation_access_level",GeolocationAccessLevel.ONLY_ALLOWED_FOR_SYSTEM);chrome.metricsPrivate.recordEnumerationValue(LOCATION_PERMISSION_CHANGE_FROM_DIALOG_HISTOGRAM_NAME,GeolocationAccessLevel.ONLY_ALLOWED_FOR_SYSTEM,GeolocationAccessLevel.MAX_VALUE+1);this.getDialog_().close()}onCancelClicked_(){this.getDialog_().close()}getDialog_(){return castExists(this.shadowRoot.querySelector("#systemGeolocationDialog"))}}customElements.define(PrivacyHubGeolocationDialog.is,PrivacyHubGeolocationDialog);function getTemplate$3b(){return html`<!--_html_template_start_--><style include="settings-shared">#container{display:inline-flex;width:inherit;margin-top:5px;text-align:left}#warningIcon{margin-right:5px}</style>
<div id="container">
  <iron-icon id="warningIcon" icon="cr20:warning"></iron-icon>
  <localized-link
      on-link-clicked="launchGeolocationDialog_"
      localized-string="[[warningTextWithAnchor]]">
  </localized-link>
</div>
<!--_html_template_end_-->`}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class PrivacyHubGeolocationWarningText extends PolymerElement{static get is(){return"settings-privacy-hub-geolocation-warning-text"}static get template(){return getTemplate$3b()}static get properties(){return{warningTextWithAnchor:{type:String,reflectToAttribute:true}}}launchGeolocationDialog_(e){e.detail.event.preventDefault();e.stopPropagation();this.dispatchEvent(new CustomEvent("link-clicked",{bubbles:false}))}}customElements.define(PrivacyHubGeolocationWarningText.is,PrivacyHubGeolocationWarningText);
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var TimeZoneAutoDetectMethod;(function(TimeZoneAutoDetectMethod){TimeZoneAutoDetectMethod[TimeZoneAutoDetectMethod["DISABLED"]=0]="DISABLED";TimeZoneAutoDetectMethod[TimeZoneAutoDetectMethod["IP_ONLY"]=1]="IP_ONLY";TimeZoneAutoDetectMethod[TimeZoneAutoDetectMethod["SEND_WIFI_ACCESS_POINTS"]=2]="SEND_WIFI_ACCESS_POINTS";TimeZoneAutoDetectMethod[TimeZoneAutoDetectMethod["SEND_ALL_LOCATION_INFO"]=3]="SEND_ALL_LOCATION_INFO"})(TimeZoneAutoDetectMethod||(TimeZoneAutoDetectMethod={}));function getTemplate$3a(){return html`<!--_html_template_start_--><style include="settings-shared">#timezoneRadioContainer{padding-bottom:var(--cr-section-padding)}settings-dropdown-menu{--md-select-width:425px;--settings-dropdown-menu-policy-order:1}#timeZoneResolveMethodDropdown,#timezoneSelector{padding-inline-start:28px}#warningText{width:425px;padding-inline-start:28px}
</style>
<div id="timezoneRadioContainer" class="settings-box first">
  <settings-radio-group id="timeZoneRadioGroup"
      pref="{{prefs.generated.resolve_timezone_by_geolocation_on_off}}"
      deep-link-focus-id$="[[Setting.kChangeTimeZone]]"
      disabled="[[!canSetSystemTimezone_]]">
    <controlled-radio-button
        id="timeZoneAutoDetectOn"
        name="true"
        pref="[[prefs.generated.resolve_timezone_by_geolocation_on_off]]"
        label="$i18n{setTimeZoneAutomaticallyOn}"
        no-extension-indicator>
    </controlled-radio-button>
    <settings-dropdown-menu id="timeZoneResolveMethodDropdown"
        pref="{{prefs.generated.resolve_timezone_by_geolocation_method_short}}"
        label="$i18n{selectTimeZoneResolveMethod}"
        disabled="[[!prefs.generated.resolve_timezone_by_geolocation_on_off.value]]"
        menu-options="[[getTimeZoneResolveMethodsList_(
            prefs.generated.resolve_timezone_by_geolocation_method_short)]]">
    </settings-dropdown-menu>
    <template is="dom-if" if="[[shouldShowGeolocationWarningText_]]"
        restamp>
      <settings-privacy-hub-geolocation-warning-text
          id="warningText"
          warning-text-with-anchor="[[geolocationWarningText_]]"
          on-link-clicked="openGeolocationDialog_">
      </settings-privacy-hub-geolocation-warning-text>
    </template>
    <controlled-radio-button
        id="timeZoneAutoDetectOff"
        name="false"
        pref="[[prefs.generated.resolve_timezone_by_geolocation_on_off]]"
        label="$i18n{setTimeZoneAutomaticallyOff}"
        no-extension-indicator>
    </controlled-radio-button>
    <timezone-selector id="timezoneSelector" prefs="{{prefs}}"
        active-time-zone-display-name="{{activeTimeZoneDisplayName}}">
    </timezone-selector>
  </settings-radio-group>
</div>

<template is="dom-if" if="[[showEnableSystemGeolocationDialog_]]" restamp>
  <settings-privacy-hub-geolocation-dialog id="geolocationDialog"
      on-close="onGeolocationDialogClose_"
      prefs="{{prefs}}">
  </settings-privacy-hub-geolocation-dialog>
</template>
<!--_html_template_end_-->`}
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const TimezoneSubpageElementBase=DeepLinkingMixin(RouteObserverMixin(I18nMixin(PrefsMixin(PolymerElement))));class TimezoneSubpageElement extends TimezoneSubpageElementBase{static get is(){return"timezone-subpage"}static get template(){return getTemplate$3a()}static get properties(){return{activeTimeZoneDisplayName:{type:String,notify:true},canSetSystemTimezone_:{type:Boolean,value(){return loadTimeData.getBoolean("canSetSystemTimezone")}},geolocationWarningText_:{type:String,computed:"computedGeolocationWarningText(activeTimeZoneDisplayName,"+"prefs.ash.user.geolocation_access_level.enforcement)"},shouldShowGeolocationWarningText_:{type:Boolean,computed:"computeShouldShowGeolocationWarningText_("+"prefs.generated.resolve_timezone_by_geolocation_on_off.value,"+"prefs.ash.user.geolocation_access_level.value)"},showEnableSystemGeolocationDialog_:{type:Boolean,value:false}}}get pageHandler(){return this.browserProxy_.handler}get callbackRouter(){return this.browserProxy_.observer}constructor(){super();this.supportedSettingIds=new Set([Setting.kChangeTimeZone]);this.browserProxy_=DateTimeBrowserProxy.getInstance()}connectedCallback(){super.connectedCallback();this.callbackRouter.onParentAccessValidationComplete.addListener(this.enableTimeZoneSetting_.bind(this))}currentRouteChanged(newRoute,_oldRoute){if(newRoute!==routes.DATETIME_TIMEZONE_SUBPAGE){return}if(isChild()){this.disableTimeZoneSetting_();this.pageHandler.showParentAccessForTimezone()}this.attemptDeepLink()}computedGeolocationWarningText(){if(!this.prefs){return""}if(this.prefs.ash.user.geolocation_access_level.enforcement===chrome.settingsPrivate.Enforcement.ENFORCED){return loadTimeData.getStringF("timeZoneGeolocationManagedWarningText",this.activeTimeZoneDisplayName)}else{return loadTimeData.getStringF("timeZoneGeolocationWarningText",this.activeTimeZoneDisplayName)}}computeShouldShowGeolocationWarningText_(){return this.prefs.generated.resolve_timezone_by_geolocation_on_off.value===true&&this.prefs.ash.user.geolocation_access_level.value===GeolocationAccessLevel.DISALLOWED}getTimeZoneResolveMethodsList_(){const result=[];const pref=this.getPref("generated.resolve_timezone_by_geolocation_method_short");if(pref.value===TimeZoneAutoDetectMethod.DISABLED){const label=pref.controlledBy?loadTimeData.getString("setTimeZoneAutomaticallyDisabled"):loadTimeData.getString("setTimeZoneAutomaticallyIpOnlyDefault");result.push({value:TimeZoneAutoDetectMethod.DISABLED,name:label})}result.push({value:TimeZoneAutoDetectMethod.IP_ONLY,name:loadTimeData.getString("setTimeZoneAutomaticallyIpOnlyDefault")});if(pref.value===TimeZoneAutoDetectMethod.SEND_WIFI_ACCESS_POINTS){result.push({value:TimeZoneAutoDetectMethod.SEND_WIFI_ACCESS_POINTS,name:loadTimeData.getString("setTimeZoneAutomaticallyWithWiFiAccessPointsData")})}result.push({value:TimeZoneAutoDetectMethod.SEND_ALL_LOCATION_INFO,name:loadTimeData.getString("setTimeZoneAutomaticallyWithAllLocationInfo")});return result}enableTimeZoneSetting_(){const radios=this.shadowRoot.querySelectorAll("controlled-radio-button");for(const radio of radios){radio.disabled=false}this.$.timezoneSelector.shouldDisableTimeZoneGeoSelector=false;const pref=this.getPref("generated.resolve_timezone_by_geolocation_method_short");if(pref.value!==TimeZoneAutoDetectMethod.DISABLED){this.$.timeZoneResolveMethodDropdown.disabled=false}}disableTimeZoneSetting_(){this.$.timeZoneResolveMethodDropdown.disabled=true;this.$.timezoneSelector.shouldDisableTimeZoneGeoSelector=true;const radios=this.shadowRoot.querySelectorAll("controlled-radio-button");for(const radio of radios){radio.disabled=true}}openGeolocationDialog_(){this.showEnableSystemGeolocationDialog_=true}onGeolocationDialogClose_(){this.showEnableSystemGeolocationDialog_=false}}customElements.define(TimezoneSubpageElement.is,TimezoneSubpageElement);
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
let instance$b=null;class AudioAndCaptionsPageBrowserProxyImpl{static getInstance(){return instance$b||(instance$b=new AudioAndCaptionsPageBrowserProxyImpl)}static setInstanceForTesting(obj){instance$b=obj}setStartupSoundEnabled(enabled){chrome.send("setStartupSoundEnabled",[enabled])}audioAndCaptionsPageReady(){chrome.send("manageA11yPageReady")}getStartupSoundEnabled(){chrome.send("getStartupSoundEnabled")}previewFlashNotification(){chrome.send("previewFlashNotification")}}function getTemplate$39(){return html`<!--_html_template_start_--><style include="settings-shared md-select">.audio-mute-button{margin-inline-end:8px}.audio-mute-button[disabled]{background-color:transparent;pointer-events:auto}.audio-options-container{align-items:center;display:flex;flex-direction:row}.audio-slider{margin-inline-end:16px;padding:0;width:142px}h2{padding-inline-start:var(--cr-section-padding)}.settings-box:first-of-type{border-top:none}.subsection{padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-indent-padding)}.subsection>.settings-box,.subsection>settings-toggle-button{padding-inline-end:0;padding-inline-start:0}.sub-item{padding-inline-start:var(--cr-section-indent-width);margin-bottom:8px}.audio-info-icon{margin-inline-end:4px;--iron-icon-fill-color:var(--cros-color-prominent)}:host([is-output-muted_]) #outputVolumeSlider{--cr-slider-active-color:var(--cros-slider-color-inactive);--cr-slider-container-color:var(--cros-slider-track-color-inactive);--cr-slider-knob-color-rgb:var(--cros-color-primary-rgb)}:host([is-output-muted_]) #audioOutputMuteButton{--cr-icon-button-fill-color:var(--cros-color-secondary)}:host(:not([is-output-muted_])) #audioOutputMuteButton{--cr-icon-button-fill-color:var(--cros-color-prominent)}:host([is-input-muted_]) #audioInputGainVolumeSlider{--cr-slider-active-color:var(--cros-slider-color-inactive);--cr-slider-container-color:var(--cros-slider-track-color-inactive);--cr-slider-knob-color-rgb:var(--cros-color-primary-rgb)}:host([is-input-muted_]) #audioInputGainMuteButton{--cr-icon-button-fill-color:var(--cros-color-secondary)}:host(:not([is-input-muted_])) #audioInputGainMuteButton{--cr-icon-button-fill-color:var(--cros-color-prominent)}paper-tooltip{--paper-tooltip-min-width:max-content}</style>

<!-- Output section -->
<div id="output"
    hidden="[[getOutputHidden_(audioSystemProperties_.outputDevices)]]">
  <h2 id="audioOutputTitle">$i18n{audioOutputTitle}</h2>
  <div id="audioOutputSubsection" class="subsection">
    <div id="outputDeviceSubsection" class="settings-box">
      <div class="start settings-box-text" id="audioOutputDeviceLabel">
        $i18n{audioOutputDeviceTitle}
      </div>
      <select id="audioOutputDeviceDropdown" class="md-select"
          on-change="onOutputDeviceChanged"
          aria-labelledby="audioOutputTitle audioOutputDeviceLabel">
        <template is="dom-repeat"
            items="[[audioSystemProperties_.outputDevices]]">
          <option value="[[item.id]]" selected="[[item.isActive]]">
            [[getDeviceName_(item)]]
          </option>
        </template>
      </select>
    </div>
    <div id="outputVolumeSubsection" class="settings-box">
      <div class="start settings-box-text" id="audioOutputVolumeLabel">
        $i18n{audioVolumeTitle}
      </div>
      <div class="audio-options-container">
        <template is="dom-if" if="[[isOutputMutedByPolicy_(
              audioSystemProperties_.outputMuteState
            )]]">
          <cr-policy-indicator id="audioOutputMuteByPolicyIndicator"
              indicator-type="userPolicy">
          </cr-policy-indicator>
        </template>
        <cr-icon-button class="audio-mute-button"
            id="audioOutputMuteButton"
            iron-icon="[[getOutputIcon_(isOutputMuted_, outputVolume_)]]"
            on-click="onOutputMuteButtonClicked"
            disabled="[[isOutputMutedByPolicy_(
                audioSystemProperties_.outputMuteState
              )]]"
            aria-description="[[getOutputMuteButtonAriaLabel(
                isOutputMuted_
              )]]"
            aria-labelledby="audioOutputVolumeLabel"
            aria-pressed="[[isOutputMuted_]]">
        </cr-icon-button>
        <paper-tooltip id="audioOutputMuteButtonTooltip" aria-hidden="true"
            for="audioOutputMuteButton">
          [[getMuteTooltip_(audioSystemProperties_.outputMuteState)]]
        </paper-tooltip>
        <cr-slider class="audio-slider"
            id ="outputVolumeSlider"
            min="0"
            max="100"
            key-press-slider-increment="10"
            disabled="[[isOutputMutedByPolicy_(
                audioSystemProperties_.outputMuteState
              )]]"
            value="[[audioSystemProperties_.outputVolumePercent]]"
            on-cr-slider-value-changed="onOutputVolumeSliderChanged_"
            aria-labelledby="audioOutputTitle audioOutputVolumeLabel">
        </cr-slider>
      </div>
    </div>
    <div id="audioOutputSpatialAudioSubsection" class="settings-box"
      hidden="[[!showSpatialAudio]]"
      on-click="onSpatialAudioRowClicked_" actionable-row>
      <div id="audioOutputSpatialAudioLabel" class="settings-box-text start">
        $i18n{audioOutputSpatialAudioTitle}
      </div>
      <cr-toggle id="audioOutputSpatialAudioToggle"
          checked="{{isSpatialAudioEnabled_}}"
          aria-labelledby="audioOutputSpatialAudioLabel"
          on-change="toggleSpatialAudioEnabled_">
      </cr-toggle>
    </div>
  </div>
</div>
<!--TODO(b/260277007): Replace placeholder text when localization strings
  available. Add styling. -->
<div id="input"
    hidden="[[getInputHidden_(audioSystemProperties_.inputDevices)]]">
  <h2 id="audioInputTitle">$i18n{audioInputTitle}</h2>
  <div id="audioInputSection" class="subsection">
    <div id="audioInputDeviceSubsection" class="settings-box">
      <div id="audioInputDeviceLabel" class="start settings-box-text">
        $i18n{audioInputDeviceTitle}
      </div>
      <select id="audioInputDeviceDropdown" on-change="onInputDeviceChanged"
          class="md-select"
          aria-labelledby="audioInputTitle audioInputDeviceLabel">
        <template is="dom-repeat"
            items="[[audioSystemProperties_.inputDevices]]">
          <option value="[[item.id]]" selected="[[item.isActive]]">
            [[getDeviceName_(item)]]
          </option>
        </template>
      </select>
    </div>
    <div id="audioInputDeviceSubsection" class="settings-box">
      <div id="audioInputGainLabel" class="start settings-box-text">
        $i18n{audioInputGainTitle}
      </div>
      <div class="audio-options-container">
        <cr-icon-button id="audioInputGainMuteButton"
            iron-icon="[[getInputIcon_(isInputMuted_)]]"
            on-click="onInputMuteClicked"
            class="audio-mute-button"
            disabled="[[shouldDisableInputGainControls(isInputMuted_)]]"
            aria-description$="[[getInputMuteButtonAriaLabel(
                audioSystemProperties_.inputMuteState,
                isInputMuted_
              )]]"
            aria-labelledby="audioInputGainLabel"
            aria-pressed="[[isInputMuted_]]">
        </cr-icon-button>
        <paper-tooltip id="audioInputMuteButtonTooltip" aria-hidden="true"
            for="audioInputGainMuteButton">
          [[getMuteTooltip_(audioSystemProperties_.inputMuteState)]]
        </paper-tooltip>
        <cr-slider id="audioInputGainVolumeSlider" min="0" max="100"
            key-press-slider-increment="10"
            iron-icon="[[getInputIcon_(isInputMuted_)]]"
            value="[[audioSystemProperties_.inputGainPercent]]"
            on-cr-slider-value-changed="onInputVolumeSliderChanged"
            class="audio-slider"
            aria-labelledby="audioInputTitle audioInputGainLabel"
            disabled="[[shouldDisableInputGainControls(isInputMuted_)]]">
        </cr-slider>
      </div>
    </div>
    <settings-toggle-button id="audioInputVoiceIsolationToggleSection"
        hidden="[[!showVoiceIsolationSubsection_]]"
        pref="{{prefs.ash.input_voice_isolation_enabled}}"
        label="[[getVoiceIsolationToggleTitle_(audioSystemProperties_.voiceIsolationUiAppearance)]]"
        sub-label="[[getVoiceIsolationToggleDescription_(audioSystemProperties_.voiceIsolationUiAppearance)]]"
        learn-more-url="$i18n{voiceIsolationLearnMoreLink}"
        on-change="onVoiceIsolationRowClicked_">
    </settings-toggle-button>
    <template is="dom-if" if="[[shouldShowVoiceIsolationEffectModeOptions_(
          audioSystemProperties_.voiceIsolationUiAppearance.effectModeOptions,
          prefs.ash.input_voice_isolation_enabled.value
        )]]">
      <div class="sub-item">
        <span>
          $i18n{audioInputEffectMode}
        </span>
        <settings-radio-group id="voiceIsolationEffectModeOptions"
            pref="{{prefs.ash.input_voice_isolation_preferred_effect}}"
            on-change="onVoiceIsolationEffectModeChanged_">
          <controlled-radio-button
              id="voiceIsolationEffectModeStyleTransfer"
              name="[[voiceIsolationEffectModePrefValues_.STYLE_TRANSFER]]"
              pref="[[prefs.ash.input_voice_isolation_preferred_effect]]"
              label="$i18n{audioInputEffectModeStyleTransferTitle}"
              aria-description="$i18n{audioInputEffectModeStyleTransferDescription}">
            <div class="cr-secondary-text">
              <span>$i18n{audioInputEffectModeStyleTransferDescription}</span>
            </div>
          </controlled-radio-button>
          <controlled-radio-button
              id="voiceIsolationEffectModeBeamforming"
              name="[[voiceIsolationEffectModePrefValues_.BEAMFORMING]]"
              pref="[[prefs.ash.input_voice_isolation_preferred_effect]]"
              label="$i18n{audioInputBeamformingTitle}"
              aria-description="$i18n{audioInputBeamformingDescription}">
            <div class="cr-secondary-text">
              <span>$i18n{audioInputBeamformingDescription}</span>
            </div>
          </controlled-radio-button>
        </settings-radio-group>
      </div>
    </template>
    <div id="voiceIsolationEffectFallbackMessageSection" class="sub-item"
        hidden="[[!shouldShowVoiceIsolationFallbackMessage_(
          audioSystemProperties_.voiceIsolationUiAppearance.showEffectFallbackMessage,
          prefs.ash.input_voice_isolation_enabled.value
        )]]">
      <iron-icon class="audio-info-icon" tabindex="0" icon="cr:info-outline"
          aria-labelledby="voiceIsolationEffectFallbackMessage">
      </iron-icon>
      <span id="voiceIsolationEffectFallbackMessage">
        $i18n{audioInputVoiceIsolationEffectFallbackMessage}
      </span>
    </div>
    <div id="audioInputAllowAGCSubsection" class="settings-box"
        hidden="[[!showAllowAGC]]">
      <div id="audioInputAllowAGCLabel" class="settings-box-text start">
        $i18n{audioInputAllowAGCTitle}
      </div>
      <cr-toggle id="audioInputAllowAGCToggle"
          checked="{{isAllowAGCEnabled}}"
          on-change="toggleAllowAgcEnabled_">
      </cr-toggle>
    </div>
    <div id="audioInputHfpMicSrSubsection" class="settings-box"
        hidden="[[!isHfpMicSrSupported]]">
      <div id="audioInputHfpMicSrLabel"
          class="settings-box-text start" aria-hidden="true">
        $i18n{audioHfpMicSrTitle}
        <div class="secondary">
          $i18n{audioHfpMicSrDescription}
        </div>
      </div>
      <cr-toggle id="audioInputHfpMicSrToggle"
          checked="{{isHfpMicSrEnabled}}"
          aria-labelledby="audioInputHfpMicSrLabel"
          on-change="toggleHfpMicSrEnabled_">
      </cr-toggle>
    </div>
  </div>
</div>

<div id="deviceSounds">
  <h2>$i18n{deviceSoundsTitle}</h2>
  <div id="deviceSoundsSection" class="subsection">
    <settings-toggle-button id="lowBatterySoundToggle"
        pref="{{prefs.ash.low_battery_sound.enabled}}"
        label="$i18n{lowBatterySoundLabel}"
        deep-link-focus-id$="[[Setting.kLowBatterySound]]"
        hidden$="[[powerSoundsHidden_]]">
    </settings-toggle-button>
    <settings-toggle-button id="chargingSoundsToggle"
        pref="{{prefs.ash.charging_sounds.enabled}}"
        label="$i18n{chargingSoundsLabel}"
        deep-link-focus-id$="[[Setting.kChargingSounds]]"
        hidden$="[[powerSoundsHidden_]]">
    </settings-toggle-button>
    <div class="settings-box start-padding continuation"
        on-click="onDeviceStartupSoundRowClicked_" actionable-row>
      <div id="deviceStartupSoundEnabledLabel"
          class="start settings-box-text">
        $i18n{deviceStartupSoundLabel}
      </div>
      <cr-toggle id="deviceStartupSoundToggle"
          checked="[[startupSoundEnabled_]]"
          on-change="toggleStartupSoundEnabled_">
      </cr-toggle>
    </div>
  </div>
</div>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function clampPercent(percent){return Math.max(0,Math.min(percent,100))}const SettingsAudioElementBase=WebUiListenerMixin(DeepLinkingMixin(PrefsMixin(RouteObserverMixin(I18nMixin(PolymerElement)))));const VOLUME_ICON_OFF_LEVEL=0;const VOLUME_ICON_LOUD_LEVEL=34;class SettingsAudioElement extends SettingsAudioElementBase{static get is(){return"settings-audio"}static get template(){return getTemplate$39()}static get properties(){return{crosAudioConfig_:{type:Object},audioSystemProperties_:{type:Object},isOutputMuted_:{type:Boolean,reflectToAttribute:true},isInputMuted_:{type:Boolean,reflectToAttribute:true},showVoiceIsolationSubsection_:{type:Boolean},voiceIsolationEffectModePrefValues_:{readOnly:true,type:Object,value:{STYLE_TRANSFER:AudioEffectType.kStyleTransfer,BEAMFORMING:AudioEffectType.kBeamforming}},outputVolume_:{type:Number},powerSoundsHidden_:{type:Boolean,computed:"computePowerSoundsHidden_(batteryStatus_)"},startupSoundEnabled_:{type:Boolean,value:false},showAllowAGC:{type:Boolean,value:loadTimeData.getBoolean("enableForceRespectUiGainsToggle"),readonly:true},isAllowAGCEnabled:{type:Boolean,value:true},isHfpMicSrEnabled:{type:Boolean},showSpatialAudio:{type:Boolean},isSpatialAudioEnabled_:{type:Boolean,value:true}}}constructor(){super();this.supportedSettingIds=new Set([Setting.kChargingSounds,Setting.kLowBatterySound]);this.crosAudioConfig_=getCrosAudioConfig();this.audioSystemPropertiesObserverReceiver_=new AudioSystemPropertiesObserverReceiver(this);this.audioAndCaptionsBrowserProxy_=AudioAndCaptionsPageBrowserProxyImpl.getInstance();this.devicePageBrowserProxy_=DevicePageBrowserProxyImpl.getInstance()}ready(){super.ready();this.observeAudioSystemProperties_();this.addWebUiListener("startup-sound-setting-retrieved",(startupSoundEnabled=>{this.startupSoundEnabled_=startupSoundEnabled}));this.addWebUiListener("battery-status-changed",this.set.bind(this,"batteryStatus_"));this.devicePageBrowserProxy_.updatePowerStatus()}onPropertiesUpdated(properties){this.audioSystemProperties_=properties;this.isOutputMuted_=this.audioSystemProperties_.outputMuteState!==MuteState.kNotMuted;this.isInputMuted_=this.audioSystemProperties_.inputMuteState!==MuteState.kNotMuted;const activeInputDevice=this.audioSystemProperties_.inputDevices.find((device=>device.isActive));const toggleType=this.audioSystemProperties_.voiceIsolationUiAppearance.toggleType;this.showVoiceIsolationSubsection_=toggleType!==AudioEffectType.kNone;this.isAllowAGCEnabled=activeInputDevice?.forceRespectUiGainsState===AudioEffectState.kNotEnabled;this.outputVolume_=this.audioSystemProperties_.outputVolumePercent;this.isHfpMicSrEnabled=activeInputDevice?.hfpMicSrState===AudioEffectState.kEnabled;this.isHfpMicSrSupported=activeInputDevice!==undefined&&activeInputDevice?.hfpMicSrState!==AudioEffectState.kNotSupported;const activeOutputDevice=this.audioSystemProperties_.outputDevices.find((device=>device.isActive));this.isSpatialAudioEnabled_=activeOutputDevice!==undefined&&activeOutputDevice?.spatialAudioState===AudioEffectState.kEnabled;this.isSpatialAudioSupported_=activeOutputDevice!==undefined&&activeOutputDevice?.spatialAudioState!==AudioEffectState.kNotSupported;this.showSpatialAudio=this.isSpatialAudioSupported_&&loadTimeData.getBoolean("enableSpatialAudioToggle")}getIsOutputMutedForTest(){return this.isOutputMuted_}getIsInputMutedForTest(){return this.isInputMuted_}observeAudioSystemProperties_(){if(this.crosAudioConfig_ instanceof FakeCrosAudioConfig){this.crosAudioConfig_.observeAudioSystemProperties(this);return}this.crosAudioConfig_.observeAudioSystemProperties(this.audioSystemPropertiesObserverReceiver_.$.bindNewPipeAndPassRemote())}isOutputMutedByPolicy_(){return this.audioSystemProperties_.outputMuteState===MuteState.kMutedByPolicy}onInputMuteClicked(){this.crosAudioConfig_.setInputMuted(!this.isInputMuted_)}onInputDeviceChanged(){const inputDeviceSelect=this.shadowRoot.querySelector("#audioInputDeviceDropdown");assert(!!inputDeviceSelect);this.crosAudioConfig_.setActiveDevice(BigInt(inputDeviceSelect.value))}onInputVolumeSliderChanged(){const sliderValue=this.shadowRoot.querySelector("#audioInputGainVolumeSlider").value;this.crosAudioConfig_.setInputGainPercent(clampPercent(sliderValue))}onOutputVolumeSliderChanged_(){const sliderValue=this.shadowRoot.querySelector("#outputVolumeSlider").value;this.crosAudioConfig_.setOutputVolumePercent(clampPercent(sliderValue))}onOutputDeviceChanged(){const outputDeviceSelect=this.shadowRoot.querySelector("#audioOutputDeviceDropdown");assert(!!outputDeviceSelect);this.crosAudioConfig_.setActiveDevice(BigInt(outputDeviceSelect.value))}onOutputMuteButtonClicked(){this.crosAudioConfig_.setOutputMuted(!this.isOutputMuted_)}currentRouteChanged(route){if(route!==routes.AUDIO){return}this.audioAndCaptionsBrowserProxy_.getStartupSoundEnabled()}getInputIcon_(){return this.isInputMuted_?"os-settings:mic-off":"cr:mic"}getOutputIcon_(){if(this.isOutputMuted_){return"os-settings:volume-up-off"}if(this.outputVolume_===VOLUME_ICON_OFF_LEVEL){return"os-settings:volume-zero"}if(this.outputVolume_<VOLUME_ICON_LOUD_LEVEL){return"os-settings:volume-down"}return"os-settings:volume-up"}getOutputHidden_(){return this.audioSystemProperties_.outputDevices.length===0}getInputHidden_(){return this.audioSystemProperties_.inputDevices.length===0}shouldDisableInputGainControls(){return this.audioSystemProperties_.inputMuteState===MuteState.kMutedExternally}getDeviceName_(audioDevice){switch(audioDevice.deviceType){case AudioDeviceType.kHeadphone:return this.i18n("audioDeviceHeadphoneLabel");case AudioDeviceType.kMic:return this.i18n("audioDeviceMicJackLabel");case AudioDeviceType.kUsb:return this.i18n("audioDeviceUsbLabel",audioDevice.displayName);case AudioDeviceType.kBluetooth:case AudioDeviceType.kBluetoothNbMic:return this.i18n("audioDeviceBluetoothLabel",audioDevice.displayName);case AudioDeviceType.kHdmi:return this.i18n("audioDeviceHdmiLabel",audioDevice.displayName);case AudioDeviceType.kInternalSpeaker:return this.i18n("audioDeviceInternalSpeakersLabel");case AudioDeviceType.kInternalMic:return this.i18n("audioDeviceInternalMicLabel");case AudioDeviceType.kFrontMic:return this.i18n("audioDeviceFrontMicLabel");case AudioDeviceType.kRearMic:return this.i18n("audioDeviceRearMicLabel");default:return audioDevice.displayName}}getMuteTooltip_(muteState){switch(muteState){case MuteState.kNotMuted:return this.i18n("audioToggleToMuteTooltip");case MuteState.kMutedByUser:return this.i18n("audioToggleToUnmuteTooltip");case MuteState.kMutedByPolicy:return this.i18n("audioMutedByPolicyTooltip");case MuteState.kMutedExternally:return this.i18n("audioMutedExternallyTooltip");default:return""}}getInputMuteButtonAriaLabel(){if(this.audioSystemProperties_.inputMuteState===MuteState.kMutedExternally){return this.i18n("audioInputMuteButtonAriaLabelMutedByHardwareSwitch")}return this.isInputMuted_?this.i18n("audioInputMuteButtonAriaLabelMuted"):this.i18n("audioInputMuteButtonAriaLabelNotMuted")}getOutputMuteButtonAriaLabel(){return this.isOutputMuted_?this.i18n("audioOutputMuteButtonAriaLabelMuted"):this.i18n("audioOutputMuteButtonAriaLabelNotMuted")}getVoiceIsolationToggleTitle_(voiceIsolationUIAppearance){if(voiceIsolationUIAppearance===undefined){return""}switch(voiceIsolationUIAppearance.toggleType){case AudioEffectType.kNoiseCancellation:return this.i18n("audioInputNoiseCancellationTitle");case AudioEffectType.kStyleTransfer:return this.i18n("audioInputStyleTransferTitle");case AudioEffectType.kBeamforming:return this.i18n("audioInputBeamformingTitle");default:return""}}getVoiceIsolationToggleDescription_(voiceIsolationUIAppearance){if(voiceIsolationUIAppearance===undefined){return""}switch(voiceIsolationUIAppearance.toggleType){case AudioEffectType.kStyleTransfer:return this.i18n("audioInputStyleTransferDescription");case AudioEffectType.kBeamforming:return this.i18n("audioInputBeamformingDescription");default:return""}}shouldShowVoiceIsolationEffectModeOptions_(effectModeOptions,voiceIsolationEnabled){return effectModeOptions!==0&&voiceIsolationEnabled}shouldShowVoiceIsolationFallbackMessage_(crasShowEffectFallbackMessage,voiceIsolationEnabled){return crasShowEffectFallbackMessage&&voiceIsolationEnabled}toggleHfpMicSrEnabled_(e){this.crosAudioConfig_.setHfpMicSrEnabled(e.detail)}toggleStartupSoundEnabled_(e){this.audioAndCaptionsBrowserProxy_.setStartupSoundEnabled(e.detail)}toggleAllowAgcEnabled_(e){this.crosAudioConfig_.setForceRespectUiGainsEnabled(!e.detail)}toggleSpatialAudioEnabled_(e){this.crosAudioConfig_.setSpatialAudioEnabled(e.detail)}computePowerSoundsHidden_(){return!this.batteryStatus_?.present}onDeviceStartupSoundRowClicked_(){this.startupSoundEnabled_=!this.startupSoundEnabled_;this.audioAndCaptionsBrowserProxy_.setStartupSoundEnabled(this.startupSoundEnabled_)}onVoiceIsolationRowClicked_(){this.crosAudioConfig_.recordVoiceIsolationEnabledChange()}onVoiceIsolationEffectModeChanged_(){const voiceIsolationEffectModes=strictQuery("#voiceIsolationEffectModeOptions",this.shadowRoot,SettingsRadioGroupElement);const selected=+voiceIsolationEffectModes.selected;this.crosAudioConfig_.recordVoiceIsolationPreferredEffectChange(selected)}onSpatialAudioRowClicked_(){const spatialAudioToggle=strictQuery("#audioOutputSpatialAudioToggle",this.shadowRoot,CrToggleElement);this.crosAudioConfig_.setSpatialAudioEnabled(!spatialAudioToggle.checked)}}customElements.define(SettingsAudioElement.is,SettingsAudioElement);const styleMod$3=document.createElement("dom-module");styleMod$3.appendChild(html`
  <template>
    <style>
:host(:not([is-last-device])) .bottom-divider{border-bottom:var(--cr-separator-line)}.subsection{margin-bottom:8px;padding-inline-start:var(--cr-section-indent-width)}.subsection>*{padding-inline-start:0}.subsection-header{color:var(--cros-sys-primary);height:24px;padding-bottom:6px;padding-inline-start:var(--cr-section-padding);padding-top:12px}.key-container{align-items:center;border-radius:12px;box-sizing:border-box;color:var(--cros-text-color-secondary);display:flex;height:28px;justify-content:center;margin-inline-end:8px;min-width:28px;padding:6px}#keyLabel{padding-inline:6px}cr-dialog [slot='button-container']{display:flex;justify-content:space-between;padding:0 32px 28px 32px}cr-dialog [slot='body']{padding:24px 32px}cr-dialog [slot='title']{padding:32px 32px 0 32px}cr-dialog #cancelButton,cr-dialog #editButton{background-color:var(--cros-bg-color);border:solid 1px var(--cros-button-stroke-color-secondary)}.subpage-description{align-items:center;display:flex;justify-content:center}.subpage-description>span{color:var(--cros-text-color-secondary);font-family:var(--cros-body-2-font-family);line-height:20px;padding:14px 0}.subpage-description>iron-icon{margin:6px;--iron-icon-height:20px;--iron-icon-width:20px;--iron-icon-fill-color:var(--cros-text-color-secondary)}
    </style>
  </template>
`.content);styleMod$3.register("input-device-settings-shared");function getTemplate$38(){return html`<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">#mouseSwapToggleButton{border-bottom:var(--cr-separator-line)}#helpSection{align-items:center;background-color:var(--cros-sys-app_base_shaded);border-radius:12px;display:flex;margin:8px;padding:16px 12px}#helpIconSection{--iron-icon-height:48px;--iron-icon-width:48px;flex-basis:48px}#helpSectionText{flex:1;margin-inline-start:12px}.help-title{color:var(--cros-text-color-primary);font:var(--cros-button-1-font);margin-bottom:5px}.secondary{font:var(--cros-body-2-font)}#buttonsSection{border-top:var(--cr-separator-line)}</style>
<settings-toggle-button id="mouseSwapToggleButton"
    aria-describedby="description"
    label="$i18n{mouseSwapButtonsLabel}"
    pref="{{primaryRightPref_}}">
</settings-toggle-button>
<div id="helpSection">
  <div id="helpIconSection">
    <iron-icon icon="os-settings:mouse-banner"></iron-icon>
  </div>
  <div id="helpSectionText">
    <div class="help-title">
      [[getcustomizeMouseButtonsNudgeHeader_(selectedMouse.*)]]
    </div>
    <div class="secondary">
      [[getDescription_(selectedMouse.*)]]
    </div>
  </div>
</div>
<div id="buttonsSection">
  <customize-buttons-subsection
    button-remapping-list="{{selectedMouse.settings.buttonRemappings}}"
    action-list$="[[buttonActionList_]]"
    meta-key="[[metaKey_]]">
  </customize-buttons-subsection>
</div>
<!--_html_template_end_-->`}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function objectsAreEqual(obj1,obj2){const keys1=Object.keys(obj1);const keys2=Object.keys(obj2);if(keys1.length!==keys2.length){return false}for(let i=0;i<keys1.length;i++){const key=keys1[i];const val1=obj1[key];const val2=obj2[key];if(val1 instanceof Object||val2 instanceof Object){if(!(val1 instanceof Object)||!(val2 instanceof Object)||!objectsAreEqual(val1,val2)){return false}}else if(val1!==val2){return false}}return true}function deviceInList(deviceId,deviceList){for(const device of deviceList){if(device.id===deviceId){return true}}return false}function settingsAreEqual(settings1,settings2){return objectsAreEqual(settings1,settings2)}function buttonsAreEqual(button1,button2){return objectsAreEqual(button1,button2)}function keyEventsAreEqual(keyEvent1,keyEvent2){return objectsAreEqual(keyEvent1,keyEvent2)}function getPrefPolicyFields$1(policy){if(policy){const enforcement=policy.policyStatus===PolicyStatus$1.kManaged?chrome.settingsPrivate.Enforcement.ENFORCED:chrome.settingsPrivate.Enforcement.RECOMMENDED;return{controlledBy:chrome.settingsPrivate.ControlledBy.USER_POLICY,enforcement:enforcement,recommendedValue:policy.value}}return{controlledBy:undefined,enforcement:undefined,recommendedValue:undefined}}function getDeviceStateChangesToAnnounce(newDeviceList,prevDeviceList){let msgId;let devices;if(newDeviceList.length>prevDeviceList.length){devices=newDeviceList.filter((device=>!deviceInList(device.id,prevDeviceList)));msgId="deviceConnectedA11yLabel"}else{msgId="deviceDisconnectedA11yLabel";devices=prevDeviceList.filter((device=>!deviceInList(device.id,newDeviceList)))}return{msgId:msgId,deviceNames:devices.map((device=>device.name))}}function createBluetoothDeviceProperties(id,publicName,batteryPercentage){return{id:id,address:id,publicName:publicName,deviceType:DeviceType.kMouse,audioCapability:AudioOutputCapability.kNotCapableOfAudioOutput,connectionState:DeviceConnectionState.kConnected,isBlockedByPolicy:false,batteryInfo:{defaultProperties:{batteryPercentage:batteryPercentage},leftBudInfo:null,rightBudInfo:null,caseInfo:null},imageInfo:null}}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsCustomizeMouseButtonsSubpageElementBase=RouteObserverMixin(I18nMixin(PolymerElement));class SettingsCustomizeMouseButtonsSubpageElement extends SettingsCustomizeMouseButtonsSubpageElementBase{constructor(){super(...arguments);this.inputDeviceSettingsProvider_=getInputDeviceSettingsProvider();this.previousRoute_=null;this.isInitialized_=false;this.metaKey_=MetaKey$2.kSearch}static get is(){return"settings-customize-mouse-buttons-subpage"}static get template(){return getTemplate$38()}static get properties(){return{selectedMouse:{type:Object},mouseList:{type:Array},buttonActionList_:{type:Array},mousePolicies:{type:Object},primaryRightPref_:{type:Object,value(){return{key:"fakePrimaryRightPref",type:chrome.settingsPrivate.PrefType.BOOLEAN,value:false}}},metaKey_:Object}}static get observers(){return["onMouseListUpdated(mouseList.*)","onPoliciesChanged(mousePolicies)","onSettingsChanged(primaryRightPref_.value)"]}async connectedCallback(){super.connectedCallback();this.addEventListener("button-remapping-changed",this.onSettingsChanged);this.metaKey_=(await this.inputDeviceSettingsProvider_.getMetaKeyToDisplay())?.metaKey}disconnectedCallback(){super.disconnectedCallback();this.removeEventListener("button-remapping-changed",this.onSettingsChanged)}async currentRouteChanged(route){if(route!==routes.CUSTOMIZE_MOUSE_BUTTONS){if(this.previousRoute_===routes.CUSTOMIZE_MOUSE_BUTTONS){this.inputDeviceSettingsProvider_.stopObserving()}this.previousRoute_=route;return}this.previousRoute_=route;if(!this.hasMice()){return}if(!this.selectedMouse||this.selectedMouse.id!==this.getMouseIdFromUrl()){await this.initializeMouse()}this.inputDeviceSettingsProvider_.startObserving(this.selectedMouse.id);getInstance().announce(this.getcustomizeMouseButtonsNudgeHeader_()+" "+this.getDescription_())}async initializeMouse(){this.isInitialized_=false;const mouseId=this.getMouseIdFromUrl();const searchedMouse=this.mouseList.find((mouse=>mouse.id===mouseId));this.selectedMouse=castExists(searchedMouse);this.set("primaryRightPref_.value",this.selectedMouse.settings.swapRight);this.buttonActionList_=(await this.inputDeviceSettingsProvider_.getActionsForMouseButtonCustomization())?.options;this.isInitialized_=true}onPoliciesChanged(){this.primaryRightPref_={...this.primaryRightPref_,...getPrefPolicyFields$1(this.mousePolicies.swapRightPolicy)}}getMouseIdFromUrl(){return Number(Router.getInstance().getQueryParameters().get("mouseId"))}hasMice(){return this.mouseList?.length>0}isMouseConnected(id){return!!this.mouseList.find((mouse=>mouse.id===id))}async onMouseListUpdated(){if(Router.getInstance().currentRoute!==routes.CUSTOMIZE_MOUSE_BUTTONS){return}if(!this.hasMice()){Router.getInstance().navigateTo(routes.DEVICE);return}if(!this.isMouseConnected(this.getMouseIdFromUrl())){Router.getInstance().navigateTo(routes.PER_DEVICE_MOUSE);return}await this.initializeMouse();this.inputDeviceSettingsProvider_.startObserving(this.selectedMouse.id)}onSettingsChanged(){if(!this.isInitialized_){return}this.selectedMouse.settings.swapRight=this.primaryRightPref_.value;this.inputDeviceSettingsProvider_.setMouseSettings(this.selectedMouse.id,this.selectedMouse.settings)}getDescription_(){if(!this.selectedMouse?.name){return""}return this.i18n("customizeButtonSubpageDescription",this.selectedMouse.name)}getcustomizeMouseButtonsNudgeHeader_(){if(this.selectedMouse?.mouseButtonConfig!==MouseButtonConfig$1.kNoConfig){return this.i18n("customizeMouseButtonsNudgeHeaderWithMetadata")}else{return this.i18n("customizeMouseButtonsNudgeHeaderWithoutMetadata")}}}customElements.define(SettingsCustomizeMouseButtonsSubpageElement.is,SettingsCustomizeMouseButtonsSubpageElement);function getTemplate$37(){return html`<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">#helpSection{align-items:center;background-color:var(--cros-sys-app_base_shaded);border-radius:12px;display:flex;margin:8px;padding:16px 12px}#helpIconSection{--iron-icon-height:48px;--iron-icon-width:48px;flex-basis:48px}#helpSectionText{flex:1;margin-inline-start:12px}.help-title{color:var(--cros-text-color-primary);font:var(--cros-button-1-font);margin-bottom:5px}.secondary{font:var(--cros-body-2-font)}#buttonsSection{border-top:var(--cr-separator-line)}</style>
<div id="helpSection">
  <div id="helpIconSection">
    <iron-icon icon="os-settings:pen-buttons-banner"></iron-icon>
  </div>
  <div id="helpSectionText">
    <div class="help-title">
      [[getcustomizePenButtonsNudgeHeader_(selectedTablet.*)]]
    </div>
    <div class="secondary">
      [[getDescription_(selectedTablet.*)]]
    </div>
  </div>
</div>
<div id="buttonsSection">
  <customize-buttons-subsection
      button-remapping-list="{{selectedTablet.settings.penButtonRemappings}}"
      action-list$="[[buttonActionList_]]"
      meta-key="[[metaKey_]]">
  </customize-buttons-subsection>
</div>
<!--_html_template_end_-->`}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsCustomizePenButtonsSubpageElementBase=RouteObserverMixin(I18nMixin(PolymerElement));class SettingsCustomizePenButtonsSubpageElement extends SettingsCustomizePenButtonsSubpageElementBase{constructor(){super(...arguments);this.inputDeviceSettingsProvider_=getInputDeviceSettingsProvider();this.previousRoute_=null;this.isInitialized_=false;this.metaKey_=MetaKey$2.kSearch}static get is(){return"settings-customize-pen-buttons-subpage"}static get template(){return getTemplate$37()}static get properties(){return{selectedTablet:{type:Object},graphicsTablets:{type:Array},metaKey_:Object}}static get observers(){return["onGraphicsTabletListUpdated(graphicsTablets.*)"]}async connectedCallback(){super.connectedCallback();this.addEventListener("button-remapping-changed",this.onSettingsChanged);this.metaKey_=(await this.inputDeviceSettingsProvider_.getMetaKeyToDisplay())?.metaKey}disconnectedCallback(){super.disconnectedCallback();this.removeEventListener("button-remapping-changed",this.onSettingsChanged)}async currentRouteChanged(route){if(route!==routes.CUSTOMIZE_PEN_BUTTONS){if(this.previousRoute_===routes.CUSTOMIZE_PEN_BUTTONS){this.inputDeviceSettingsProvider_.stopObserving()}this.previousRoute_=route;return}this.previousRoute_=route;if(!this.hasGraphicsTablets()){return}if(!this.selectedTablet||this.selectedTablet.id!==this.getGraphicsTabletIdFromUrl()){await this.initializePen()}this.inputDeviceSettingsProvider_.startObserving(this.selectedTablet.id);getInstance().announce(this.getcustomizePenButtonsNudgeHeader_()+" "+this.getDescription_())}async initializePen(){this.isInitialized_=false;const tabletId=this.getGraphicsTabletIdFromUrl();const searchedGraphicsTablet=this.graphicsTablets.find((graphicsTablet=>graphicsTablet.id===tabletId));this.selectedTablet=castExists(searchedGraphicsTablet);this.buttonActionList_=(await this.inputDeviceSettingsProvider_.getActionsForGraphicsTabletButtonCustomization())?.options;this.isInitialized_=true}getGraphicsTabletIdFromUrl(){return Number(Router.getInstance().getQueryParameters().get("graphicsTabletId"))}hasGraphicsTablets(){return this.graphicsTablets?.length>0}isTabletConnected(id){return!!this.graphicsTablets.find((tablet=>tablet.id===id))}async onGraphicsTabletListUpdated(){if(Router.getInstance().currentRoute!==routes.CUSTOMIZE_PEN_BUTTONS){return}if(!this.hasGraphicsTablets()){Router.getInstance().navigateTo(routes.DEVICE);return}if(!this.isTabletConnected(this.getGraphicsTabletIdFromUrl())){Router.getInstance().navigateTo(routes.GRAPHICS_TABLET);return}await this.initializePen();this.inputDeviceSettingsProvider_.startObserving(this.selectedTablet.id)}onSettingsChanged(){if(!this.isInitialized_){return}this.inputDeviceSettingsProvider_.setGraphicsTabletSettings(this.selectedTablet.id,this.selectedTablet.settings)}getDescription_(){if(!this.selectedTablet?.name){return""}return this.i18n("customizeTabletButtonSubpageDescription",this.selectedTablet.name)}getcustomizePenButtonsNudgeHeader_(){if(this.selectedTablet?.graphicsTabletButtonConfig!==GraphicsTabletButtonConfig$1.kNoConfig){return this.i18n("customizePenButtonsNudgeHeaderWithMetadata")}else{return this.i18n("customizePenButtonsNudgeHeaderWithoutMetadata")}}}customElements.define(SettingsCustomizePenButtonsSubpageElement.is,SettingsCustomizePenButtonsSubpageElement);function getTemplate$36(){return html`<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">#helpSection{align-items:center;background-color:var(--cros-sys-app_base_shaded);border-radius:12px;display:flex;margin:8px;padding:16px 12px}#helpIconSection{--iron-icon-height:48px;--iron-icon-width:48px;flex-basis:48px}#helpSectionText{flex:1;margin-inline-start:12px}.help-title{color:var(--cros-text-color-primary);font:var(--cros-button-1-font);margin-bottom:5px}.secondary{font:var(--cros-body-2-font)}#buttonsSection{border-top:var(--cr-separator-line)}</style>
<div id="helpSection">
  <div id="helpIconSection">
    <iron-icon icon="os-settings:tablet-buttons-banner"></iron-icon>
  </div>
  <div id="helpSectionText">
    <div class="help-title">
      [[getcustomizeTabletButtonsNudgeHeader_(selectedTablet.*)]]
    </div>
    <div class="secondary">
      [[getDescription_(selectedTablet.*)]]
    </div>
  </div>
</div>
<div id="buttonsSection">
  <customize-buttons-subsection
      button-remapping-list="{{selectedTablet.settings.tabletButtonRemappings}}"
      action-list$="[[buttonActionList_]]"
      meta-key="[[metaKey_]]">
  </customize-buttons-subsection>
</div>
<!--_html_template_end_-->`}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsCustomizeTabletButtonsSubpageElementBase=RouteObserverMixin(I18nMixin(PolymerElement));class SettingsCustomizeTabletButtonsSubpageElement extends SettingsCustomizeTabletButtonsSubpageElementBase{constructor(){super(...arguments);this.inputDeviceSettingsProvider_=getInputDeviceSettingsProvider();this.previousRoute_=null;this.isInitialized_=false;this.metaKey_=MetaKey$2.kSearch}static get is(){return"settings-customize-tablet-buttons-subpage"}static get template(){return getTemplate$36()}static get properties(){return{selectedTablet:{type:Object},graphicsTablets:{type:Array},metaKey_:Object}}static get observers(){return["onGraphicsTabletListUpdated(graphicsTablets.*)"]}async connectedCallback(){super.connectedCallback();this.addEventListener("button-remapping-changed",this.onSettingsChanged);this.metaKey_=(await this.inputDeviceSettingsProvider_.getMetaKeyToDisplay())?.metaKey}disconnectedCallback(){super.disconnectedCallback();this.removeEventListener("button-remapping-changed",this.onSettingsChanged)}async currentRouteChanged(route){if(route!==routes.CUSTOMIZE_TABLET_BUTTONS){if(this.previousRoute_===routes.CUSTOMIZE_TABLET_BUTTONS){this.inputDeviceSettingsProvider_.stopObserving()}this.previousRoute_=route;return}this.previousRoute_=route;if(!this.hasGraphicsTablets()){return}if(!this.selectedTablet||this.selectedTablet.id!==this.getGraphicsTabletIdFromUrl()){await this.initializeTablet()}this.inputDeviceSettingsProvider_.startObserving(this.selectedTablet.id);getInstance().announce(this.getcustomizeTabletButtonsNudgeHeader_()+" "+this.getDescription_())}async initializeTablet(){this.isInitialized_=false;const tabletId=this.getGraphicsTabletIdFromUrl();const searchedGraphicsTablet=this.graphicsTablets.find((graphicsTablet=>graphicsTablet.id===tabletId));this.selectedTablet=castExists(searchedGraphicsTablet);this.buttonActionList_=(await this.inputDeviceSettingsProvider_.getActionsForGraphicsTabletButtonCustomization())?.options;this.isInitialized_=true}getGraphicsTabletIdFromUrl(){return Number(Router.getInstance().getQueryParameters().get("graphicsTabletId"))}hasGraphicsTablets(){return this.graphicsTablets?.length>0}isTabletConnected(id){return!!this.graphicsTablets.find((tablet=>tablet.id===id))}async onGraphicsTabletListUpdated(){if(Router.getInstance().currentRoute!==routes.CUSTOMIZE_TABLET_BUTTONS){return}if(!this.hasGraphicsTablets()){Router.getInstance().navigateTo(routes.DEVICE);return}if(!this.isTabletConnected(this.getGraphicsTabletIdFromUrl())){Router.getInstance().navigateTo(routes.GRAPHICS_TABLET);return}await this.initializeTablet();this.inputDeviceSettingsProvider_.startObserving(this.selectedTablet.id)}onSettingsChanged(){if(!this.isInitialized_){return}this.inputDeviceSettingsProvider_.setGraphicsTabletSettings(this.selectedTablet.id,this.selectedTablet.settings)}getDescription_(){if(!this.selectedTablet?.name){return""}return this.i18n("customizeTabletButtonSubpageDescription",this.selectedTablet.name)}getcustomizeTabletButtonsNudgeHeader_(){if(this.selectedTablet?.graphicsTabletButtonConfig!==GraphicsTabletButtonConfig$1.kNoConfig){return this.i18n("customizeTabletButtonsNudgeHeaderWithMetadata")}else{return this.i18n("customizeTabletButtonsNudgeHeaderWithoutMetadata")}}}customElements.define(SettingsCustomizeTabletButtonsSubpageElement.is,SettingsCustomizeTabletButtonsSubpageElement);function getTemplate$35(){return html`<!--_html_template_start_--><style include="cr-hidden-style">:host{--cr-tabs-selected-color:var(--cros-sys-primary);cursor:pointer;display:flex;flex-direction:row;font-size:var(--cr-tabs-font-size,14px);font-weight:500;height:var(--cr-tabs-height,48px);user-select:none}.tab{align-items:center;color:var(--cr-secondary-text-color);display:flex;flex:var(--cr-tabs-flex,auto);height:100%;justify-content:center;opacity:.8;outline:none;padding:0 var(--cr-tabs-tab-inline-padding,0);position:relative;transition:opacity 100ms cubic-bezier(.4,0,1,1)}:host-context([chrome-refresh-2023]) .tab{opacity:1}:host-context(.focus-outline-visible) .tab:focus{outline:var(--cr-tabs-focus-outline,auto);outline-offset:var(--cr-tabs-focus-outline-offset,0)}.selected{color:var(--cr-tabs-selected-color);opacity:1}.tab-icon{-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:var(--cr-tabs-icon-size,var(--cr-icon-size));background-color:var(--cr-secondary-text-color);display:none;height:var(--cr-tabs-icon-size,var(--cr-icon-size));margin-inline-end:var(--cr-tabs-icon-margin-end,var(--cr-icon-size));width:var(--cr-tabs-icon-size,var(--cr-icon-size))}.selected .tab-icon{background-color:var(--cr-tabs-selected-color)}.tab-indicator{background:var(--cr-tabs-unselected-color);border-top-left-radius:var(--cr-tabs-selection-bar-radius,var(--cr-tabs-selection-bar-width,2px));border-top-right-radius:var(--cr-tabs-selection-bar-radius,var(--cr-tabs-selection-bar-width,2px));bottom:0;height:var(--cr-tabs-selection-bar-width,2px);left:var(--cr-tabs-tab-inline-padding,0);opacity:var(--cr-tabs-selection-bar-unselected-opacity,0);position:absolute;right:var(--cr-tabs-tab-inline-padding,0);transform-origin:left center;transition:transform}.selected .tab-indicator{background:var(--cr-tabs-selected-color);opacity:1}.tab-indicator.expand{transition-duration:150ms;transition-timing-function:cubic-bezier(.4,0,1,1)}.tab-indicator.contract{transition-duration:180ms;transition-timing-function:cubic-bezier(0,0,.2,1)}@media (forced-colors:active){.tab-indicator{background:SelectedItem}}</style>
<template is="dom-repeat" items="[[tabNames]]">
  <div
      role="tab"
      class$="tab [[getSelectedClass_(index, selected)]]"
      on-click="onTabClick_"
      aria-selected$="[[getAriaSelected_(index, selected)]]"
      tabindex$="[[getTabindex_(index, selected)]]">
    <div class="tab-icon" style$="[[getIconStyle_(index)]]">
    </div>
    [[item]]
    <div class="tab-indicator"></div>
  </div>
</template>
<!--_html_template_end_-->`}
// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class CrTabsElement extends PolymerElement{constructor(){super(...arguments);this.isRtl_=false;this.lastSelected_=null}static get is(){return"cr-tabs"}static get template(){return getTemplate$35()}static get properties(){return{tabIcons:{type:Array,value:()=>[]},tabNames:{type:Array,value:()=>[]},selected:{type:Number,notify:true,observer:"onSelectedChanged_"}}}connectedCallback(){super.connectedCallback();this.isRtl_=this.matches(":host-context([dir=rtl]) cr-tabs")}ready(){super.ready();this.setAttribute("role","tablist");this.addEventListener("keydown",this.onKeyDown_.bind(this))}getAriaSelected_(index){return index===this.selected?"true":"false"}getIconStyle_(index){const icon=this.tabIcons[index];return icon?`-webkit-mask-image: url(${icon}); display: block;`:""}getTabindex_(index){return index===this.selected?"0":"-1"}getSelectedClass_(index){return index===this.selected?"selected":""}onSelectedChanged_(newSelected,oldSelected){const tabs=this.shadowRoot.querySelectorAll(".tab");if(tabs.length===0||oldSelected===undefined||tabs.length<=newSelected||tabs.length<=oldSelected){return}const oldTabRect=tabs[oldSelected].getBoundingClientRect();const newTabRect=tabs[newSelected].getBoundingClientRect();const newIndicator=tabs[newSelected].querySelector(".tab-indicator");newIndicator.classList.remove("expand","contract");this.updateIndicator_(newIndicator,newTabRect,oldTabRect.left,oldTabRect.width);newIndicator.getBoundingClientRect();newIndicator.classList.add("expand");newIndicator.addEventListener("transitionend",(e=>this.onIndicatorTransitionEnd_(e)),{once:true});const leftmostEdge=Math.min(oldTabRect.left,newTabRect.left);const fullWidth=newTabRect.left>oldTabRect.left?newTabRect.right-oldTabRect.left:oldTabRect.right-newTabRect.left;this.updateIndicator_(newIndicator,newTabRect,leftmostEdge,fullWidth)}onKeyDown_(e){const count=this.tabNames.length;let newSelection;if(e.key==="Home"){newSelection=0}else if(e.key==="End"){newSelection=count-1}else if(e.key==="ArrowLeft"||e.key==="ArrowRight"){const delta=e.key==="ArrowLeft"?this.isRtl_?1:-1:this.isRtl_?-1:1;newSelection=(count+this.selected+delta)%count}else{return}e.preventDefault();e.stopPropagation();this.selected=newSelection;this.shadowRoot.querySelector(".tab.selected").focus()}onIndicatorTransitionEnd_(event){const indicator=event.target;indicator.classList.replace("expand","contract");indicator.style.transform=`translateX(0) scaleX(1)`}onTabClick_(e){this.selected=e.model.index}updateIndicator_(indicator,originRect,newLeft,newWidth){const leftDiff=100*(newLeft-originRect.left)/originRect.width;const widthRatio=newWidth/originRect.width;const transform=`translateX(${leftDiff}%) scaleX(${widthRatio})`;indicator.style.transform=transform}}customElements.define(CrTabsElement.is,CrTabsElement);function getTemplate$34(){return html`<!--_html_template_start_--><style include="settings-shared">#displayArea{height:100%;overflow:hidden;position:relative;width:100%}.display{align-items:center;background:var(--cros-textfield-background-color);color:var(--cros-text-color-secondary);cursor:default;display:flex;font-size:100%;font-weight:500;justify-content:center;margin:4px;padding:3px;position:absolute;text-align:center}.display[selected]{border:var(--cros-icon-color-prominent) solid 1px}.display.mirror{border:var(--cros-icon-color-prominent) solid 1px}.highlight-left{border-left:var(--cros-icon-color-prominent) solid 1px}.highlight-right{border-right:var(--cros-icon-color-prominent) solid 1px}.highlight-top{border-top:var(--cros-icon-color-prominent) solid 1px}.highlight-bottom{border-bottom:var(--cros-icon-color-prominent) solid 1px}.display.elevate{box-shadow:var(--cr-elevation-3)}</style>
<div id="displayArea" on-iron-resize="calculateVisualScale_">
  <template is="dom-repeat" items="[[mirroringDestinationIds_]]">
    <div id="_mirror_[[item]]" class="display mirror"
        hidden$="[[!mirroring]]"
        style$="[[getMirrorDivStyle_(index, mirroringDestinationIds_.length,
                                     displays, visualScale)]]">
    </div>
  </template>
  <template is="dom-repeat" items="[[displays]]">
    <div id="_[[item.id]]" class="display elevate"
        draggable="[[dragEnabled]]" on-focus="onFocus_"
        on-click="onSelectDisplayClick_"
        style$="[[getDivStyle_(item.id, item.bounds, visualScale)]]"
        selected$="[[isSelected_(item, selectedDisplay)]]"
        tabindex="0">
    </div>
  </template>
</div>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var DragType;(function(DragType){DragType[DragType["NONE"]=0]="NONE";DragType[DragType["CURSOR"]=1]="CURSOR";DragType[DragType["KEYBOARD"]=2]="KEYBOARD"})(DragType||(DragType={}));const DragMixin=dedupingMixin((baseClass=>{class DragMixinInternal extends baseClass{constructor(){super(...arguments);this.dragId="";this.dragType_=DragType.NONE;this.dragStartLocation_={x:0,y:0};this.lastTouchLocation_=null;this.mouseDownListener_=this.onMouseDown_.bind(this);this.mouseMoveListener_=this.onMouseMove_.bind(this);this.touchStartListener_=this.onTouchStart_.bind(this);this.touchMoveListener_=this.onTouchMove_.bind(this);this.keyDownListener_=this.onKeyDown_.bind(this);this.endDragListener_=this.endCursorDrag_.bind(this)}static get properties(){return{dragEnabled:Boolean,keyboardDragEnabled:{type:Boolean,value:false},keyboardDragStepSize:{type:Number,value:20}}}initializeDrag(enabled,container,callback){this.dragEnabled=enabled;if(!enabled){this.removeListeners_();return}if(container){this.container_=container}if(callback){this.callback_=callback}this.addListeners_()}addListeners_(){const container=this.container_;if(!container){return}container.addEventListener("mousedown",this.mouseDownListener_);container.addEventListener("mousemove",this.mouseMoveListener_);container.addEventListener("touchstart",this.touchStartListener_);container.addEventListener("touchmove",this.touchMoveListener_);container.addEventListener("keydown",this.keyDownListener_);container.addEventListener("touchend",this.endDragListener_);window.addEventListener("mouseup",this.endDragListener_)}removeListeners_(){const container=this.container_;if(!container||!this.mouseDownListener_){return}container.removeEventListener("mousedown",this.mouseDownListener_);container.removeEventListener("mousemove",this.mouseMoveListener_);container.removeEventListener("touchstart",this.touchStartListener_);container.removeEventListener("touchmove",this.touchMoveListener_);container.removeEventListener("keydown",this.keyDownListener_);container.removeEventListener("touchend",this.endDragListener_);window.removeEventListener("mouseup",this.endDragListener_)}onMouseDown_(e){const target=cast(e.target,HTMLElement);if(e.button!==0||!target.getAttribute("draggable")){return true}e.preventDefault();return this.startCursorDrag_(target,{x:e.pageX,y:e.pageY})}onMouseMove_(e){e.preventDefault();return this.processCursorDrag_({x:e.pageX,y:e.pageY})}onTouchStart_(e){if(e.touches.length!==1){return false}e.preventDefault();const target=cast(e.target,HTMLElement);const touch=e.touches[0];this.lastTouchLocation_={x:touch.pageX,y:touch.pageY};return this.startCursorDrag_(target,this.lastTouchLocation_)}onTouchMove_(e){if(e.touches.length!==1){return true}const touchLocation={x:e.touches[0].pageX,y:e.touches[0].pageY};if(this.lastTouchLocation_){const IGNORABLE_TOUCH_MOVE_PX=1;const xDiff=Math.abs(touchLocation.x-this.lastTouchLocation_.x);const yDiff=Math.abs(touchLocation.y-this.lastTouchLocation_.y);if(xDiff<=IGNORABLE_TOUCH_MOVE_PX&&yDiff<=IGNORABLE_TOUCH_MOVE_PX){return true}}this.lastTouchLocation_=touchLocation;e.preventDefault();return this.processCursorDrag_(touchLocation)}onKeyDown_(e){if(this.keyboardDragEnabled===false){return true}const target=cast(e.target,HTMLElement);if(!target.getAttribute("draggable")){return true}if(this.dragType_===DragType.CURSOR){return true}let delta;switch(e.key){case"ArrowUp":delta={x:0,y:-this.keyboardDragStepSize};break;case"ArrowDown":delta={x:0,y:this.keyboardDragStepSize};break;case"ArrowLeft":delta={x:-this.keyboardDragStepSize,y:0};break;case"ArrowRight":delta={x:this.keyboardDragStepSize,y:0};break;case"Enter":e.preventDefault();this.endKeyboardDrag_();return false;default:return true}e.preventDefault();if(this.dragType_===DragType.NONE){this.startKeyboardDrag_(target)}this.dragOffset_.x+=delta.x;this.dragOffset_.y+=delta.y;this.processKeyboardDrag_(this.dragOffset_);return false}startCursorDrag_(target,eventLocation){assert(this.dragEnabled);if(this.dragType_===DragType.KEYBOARD){this.endKeyboardDrag_()}this.dragId=target.id;this.dragStartLocation_=eventLocation;this.dragType_=DragType.CURSOR;return false}endCursorDrag_(){assert(this.dragEnabled);if(this.dragType_===DragType.CURSOR&&this.callback_){this.callback_(this.dragId,null)}this.cleanupDrag_();return false}processCursorDrag_(eventLocation){assert(this.dragEnabled);if(this.dragType_!==DragType.CURSOR){return true}this.executeCallback_(eventLocation);return false}startKeyboardDrag_(target){assert(this.dragEnabled);if(this.dragType_===DragType.CURSOR){this.endCursorDrag_()}this.dragId=target.id;this.dragStartLocation_={x:0,y:0};this.dragOffset_={x:0,y:0};this.dragType_=DragType.KEYBOARD}endKeyboardDrag_(){assert(this.dragEnabled);if(this.dragType_===DragType.KEYBOARD&&this.callback_){this.callback_(this.dragId,null)}this.cleanupDrag_()}processKeyboardDrag_(dragPosition){assert(this.dragEnabled);if(this.dragType_!==DragType.KEYBOARD){return true}this.executeCallback_(dragPosition);return false}cleanupDrag_(){this.dragId="";this.dragStartLocation_={x:0,y:0};this.lastTouchLocation_=null;this.dragType_=DragType.NONE}executeCallback_(dragPosition){if(this.callback_){const delta={x:dragPosition.x-this.dragStartLocation_.x,y:dragPosition.y-this.dragStartLocation_.y};this.callback_(this.dragId,delta)}}}return DragMixinInternal}));
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var LayoutPosition=chrome.system.display.LayoutPosition;const LayoutMixin=dedupingMixin((superClass=>{const superClassBase=DragMixin(superClass);class LayoutMixinInternal extends superClassBase{constructor(){super(...arguments);this.calculatedBoundsMap_=new Map;this.displayBoundsMap_=new Map;this.displayLayoutMap_=new Map;this.dragBounds_=undefined;this.dragLayoutId_="";this.dragLayoutPosition_=undefined;this.dragParentId_=""}static get properties(){return{layouts:Array,mirroring:{type:Boolean,value:false}}}getDisplayLayoutMapForTesting(){return this.displayLayoutMap_}initializeDisplayLayout(displays,layouts){this.dragLayoutId_="";this.dragParentId_="";this.mirroring=displays.length>0&&!!displays[0].mirroringSourceId;this.displayBoundsMap_.clear();for(const display of displays){this.displayBoundsMap_.set(display.id,display.bounds)}this.displayLayoutMap_.clear();for(const layout of layouts){this.displayLayoutMap_.set(layout.id,layout)}this.calculatedBoundsMap_.clear();for(const display of displays){if(!this.calculatedBoundsMap_.has(display.id)){const bounds=display.bounds;this.calculateBounds_(display.id,bounds.width,bounds.height)}}}updateDisplayBounds(id,newBounds){this.dragLayoutId_=id;const closestId=this.findClosest_(id,newBounds);assert(closestId);const closestBounds=this.getCalculatedDisplayBounds(closestId);const layoutPosition=this.getLayoutPositionForBounds_(newBounds,closestBounds);const snapPos=this.snapBounds_(newBounds,closestId,layoutPosition);newBounds.left=snapPos.x;newBounds.top=snapPos.y;const oldBounds=this.dragBounds_||this.getCalculatedDisplayBounds(id);const deltaPos={x:newBounds.left-oldBounds.left,y:newBounds.top-oldBounds.top};this.collideAndModifyDelta_(id,oldBounds,deltaPos);if(layoutPosition!==this.dragLayoutPosition_||closestId!==this.dragParentId_){this.dragLayoutPosition_=layoutPosition;this.dragParentId_=closestId;this.highlightEdge_(closestId,layoutPosition)}newBounds.left=oldBounds.left+deltaPos.x;newBounds.top=oldBounds.top+deltaPos.y;this.dragBounds_=newBounds;return newBounds}finishUpdateDisplayBounds(id){this.highlightEdge_("",undefined);if(id!==this.dragLayoutId_||!this.dragBounds_||!this.dragLayoutPosition_){return}const layout=this.displayLayoutMap_.get(id);let orphanIds;if(!layout||layout.parentId===""){this.setCalculatedDisplayBounds_(id,this.dragBounds_);orphanIds=this.findChildren_(id,true);this.reparentOrphan_(this.dragParentId_,orphanIds);orphanIds.splice(orphanIds.indexOf(this.dragParentId_),1)}else{orphanIds=this.findChildren_(id,false);let topLayout=this.displayLayoutMap_.get(this.dragParentId_);while(topLayout&&topLayout.parentId!==""){if(topLayout.parentId===id){topLayout.parentId=layout.parentId;break}topLayout=this.displayLayoutMap_.get(topLayout.parentId)}layout.parentId=this.dragParentId_;this.updateOffsetAndPosition_(this.dragBounds_,this.dragLayoutPosition_,layout)}this.updateOrphans_(orphanIds);getDisplayApi().setDisplayLayout(this.layouts).then((()=>{if(chrome.runtime.lastError){console.error("setDisplayLayout Error: "+chrome.runtime.lastError.message)}}))}getCalculatedDisplayBounds(displayId,notest){const bounds=this.calculatedBoundsMap_.get(displayId);assert(notest||bounds);return bounds}setCalculatedDisplayBounds_(displayId,bounds){assert(bounds);this.calculatedBoundsMap_.set(displayId,{...bounds})}updateOrphans_(orphanIds){const orphans=orphanIds.slice();for(let i=0;i<orphanIds.length;++i){const orphan=orphanIds[i];const newOrphans=this.findChildren_(orphan,true);for(let j=0;j<newOrphans.length;++j){const o=newOrphans[j];if(!orphans.includes(o)){orphans.push(o)}}}while(orphans.length){const orphanId=orphans.shift();this.reparentOrphan_(orphanId,orphans)}}reparentOrphan_(orphanId,otherOrphanIds){const layout=this.displayLayoutMap_.get(orphanId);assert(layout);if(orphanId===this.dragId&&layout.parentId!==""){this.setCalculatedDisplayBounds_(orphanId,this.dragBounds_);return}const bounds=this.getCalculatedDisplayBounds(orphanId);const newParentId=this.findClosest_(orphanId,bounds,otherOrphanIds);assert(newParentId!=="");layout.parentId=newParentId;const parentBounds=this.getCalculatedDisplayBounds(newParentId);const layoutPosition=this.getLayoutPositionForBounds_(bounds,parentBounds);const cornerBounds=this.getCornerBounds_(bounds,parentBounds);const desiredPos=this.snapBounds_(bounds,newParentId,layoutPosition);const deltaPos={x:desiredPos.x-cornerBounds.left,y:desiredPos.y-cornerBounds.top};this.collideAndModifyDelta_(orphanId,cornerBounds,deltaPos);const desiredBounds={left:cornerBounds.left+deltaPos.x,top:cornerBounds.top+deltaPos.y,width:bounds.width,height:bounds.height};this.updateOffsetAndPosition_(desiredBounds,layoutPosition,layout)}findChildren_(parentId,recurse){let children=[];this.displayLayoutMap_.forEach(((value,key)=>{const childId=key;if(childId!==parentId&&value.parentId===parentId){children.unshift(childId);if(recurse){children=children.concat(this.findChildren_(childId,true))}}}));return children}calculateBounds_(id,width,height){let left;let top;const layout=this.displayLayoutMap_.get(id);if(this.mirroring||!layout||!layout.parentId){left=-width/2;top=-height/2}else{if(!this.calculatedBoundsMap_.has(layout.parentId)){const pbounds=this.displayBoundsMap_.get(layout.parentId);this.calculateBounds_(layout.parentId,pbounds.width,pbounds.height)}const parentBounds=this.getCalculatedDisplayBounds(layout.parentId);left=parentBounds.left;top=parentBounds.top;switch(layout.position){case LayoutPosition.TOP:left+=layout.offset;top-=height;break;case LayoutPosition.RIGHT:left+=parentBounds.width;top+=layout.offset;break;case LayoutPosition.BOTTOM:left+=layout.offset;top+=parentBounds.height;break;case LayoutPosition.LEFT:left-=width;top+=layout.offset;break}}const result={left:left,top:top,width:width,height:height};this.setCalculatedDisplayBounds_(id,result)}findClosest_(displayId,bounds,ignoreIds){const x=bounds.left+bounds.width/2;const y=bounds.top+bounds.height/2;let closestId="";let closestDelta2=0;const keys=this.calculatedBoundsMap_.keys();for(let iter=keys.next();!iter.done;iter=keys.next()){const otherId=iter.value;if(otherId===displayId){continue}if(ignoreIds&&ignoreIds.includes(otherId)){continue}const{left:left,top:top,width:width,height:height}=this.getCalculatedDisplayBounds(otherId);if(x>=left&&x<left+width&&y>=top&&y<top+height){return otherId}let dx;let dy;if(x<left){dx=left-x}else if(x>left+width){dx=x-(left+width)}else{dx=0}if(y<top){dy=top-y}else if(y>top+height){dy=y-(top+height)}else{dy=0}const delta2=dx*dx+dy*dy;if(closestId===""||delta2<closestDelta2){closestId=otherId;closestDelta2=delta2}}return closestId}getLayoutPositionForBounds_(bounds,parentBounds){const x=bounds.left+bounds.width/2;const y=bounds.top+bounds.height/2;const{left:left,top:top,width:width,height:height}=parentBounds;const dx=x-(left+width/2);const dy=y-(top+height/2);const distx=Math.abs(dx)-width/2;const disty=Math.abs(dy)-height/2;if(distx>disty){if(dx<0){return LayoutPosition.LEFT}return LayoutPosition.RIGHT}else{if(dy<0){return LayoutPosition.TOP}return LayoutPosition.BOTTOM}}snapBounds_(bounds,parentId,layoutPosition){const parentBounds=this.getCalculatedDisplayBounds(parentId);let x;if(layoutPosition===LayoutPosition.LEFT){x=parentBounds.left-bounds.width}else if(layoutPosition===LayoutPosition.RIGHT){x=parentBounds.left+parentBounds.width}else{x=this.snapToX_(bounds,parentBounds)}let y;if(layoutPosition===LayoutPosition.TOP){y=parentBounds.top-bounds.height}else if(layoutPosition===LayoutPosition.BOTTOM){y=parentBounds.top+parentBounds.height}else{y=this.snapToY_(bounds,parentBounds)}return{x:x,y:y}}snapToX_(newBounds,parentBounds,snapDistance){return this.snapToEdge_(newBounds.left,newBounds.width,parentBounds.left,parentBounds.width,snapDistance)}snapToY_(newBounds,parentBounds,snapDistance){return this.snapToEdge_(newBounds.top,newBounds.height,parentBounds.top,parentBounds.height,snapDistance)}snapToEdge_(point,width,basePoint,baseWidth,snapDistance){const SNAP_DISTANCE_PX=16;const snapDist=snapDistance!==undefined?snapDistance:SNAP_DISTANCE_PX;const startDiff=Math.abs(point-basePoint);const endDiff=Math.abs(point+width-(basePoint+baseWidth));if((!snapDist||startDiff<snapDist)&&startDiff<endDiff){return basePoint}else if(!snapDist||endDiff<snapDist){return basePoint+baseWidth-width}return point}collideAndModifyDelta_(id,bounds,deltaPos){const keys=this.calculatedBoundsMap_.keys();const others=new Set(keys);others.delete(id);let checkCollisions=true;while(checkCollisions){checkCollisions=false;const othersValues=others.values();for(let iter=othersValues.next();!iter.done;iter=othersValues.next()){const otherId=iter.value;const otherBounds=this.getCalculatedDisplayBounds(otherId);if(this.collideWithBoundsAndModifyDelta_(bounds,otherBounds,deltaPos)){if(deltaPos.x===0&&deltaPos.y===0){return}others.delete(otherId);checkCollisions=true;break}}}}collideWithBoundsAndModifyDelta_(bounds,otherBounds,deltaPos){const newX=bounds.left+deltaPos.x;const newY=bounds.top+deltaPos.y;if(newX+bounds.width<=otherBounds.left||newX>=otherBounds.left+otherBounds.width||newY+bounds.height<=otherBounds.top||newY>=otherBounds.top+otherBounds.height){return false}if(Math.abs(deltaPos.x)>Math.abs(deltaPos.y)){deltaPos.y=0;let snapDeltaX;if(deltaPos.x>0){snapDeltaX=Math.max(0,otherBounds.left-bounds.width-bounds.left)}else{snapDeltaX=Math.min(0,otherBounds.left+otherBounds.width-bounds.left)}deltaPos.x=snapDeltaX}else{deltaPos.x=0;let snapDeltaY;if(deltaPos.y>0){snapDeltaY=Math.min(0,otherBounds.top-bounds.height-bounds.top)}else if(deltaPos.y<0){snapDeltaY=Math.max(0,otherBounds.top+otherBounds.height-bounds.top)}else{snapDeltaY=0}deltaPos.y=snapDeltaY}return true}updateOffsetAndPosition_(bounds,position,layout){layout.position=position;if(!layout.parentId){layout.offset=0;return}const parentBounds=this.getCalculatedDisplayBounds(layout.parentId);let offset;let minOffset;let maxOffset;if(position===LayoutPosition.LEFT||position===LayoutPosition.RIGHT){offset=bounds.top-parentBounds.top;minOffset=-bounds.height;maxOffset=parentBounds.height}else{offset=bounds.left-parentBounds.left;minOffset=-bounds.width;maxOffset=parentBounds.width}const MIN_OFFSET_OVERLAP=50;minOffset+=MIN_OFFSET_OVERLAP;maxOffset-=MIN_OFFSET_OVERLAP;layout.offset=Math.max(minOffset,Math.min(offset,maxOffset));this.calculateBounds_(layout.id,bounds.width,bounds.height)}getCornerBounds_(bounds,parentBounds){let x;if(bounds.left>parentBounds.left+parentBounds.width/2){x=parentBounds.left+parentBounds.width}else{x=parentBounds.left-bounds.width}let y;if(bounds.top>parentBounds.top+parentBounds.height/2){y=parentBounds.top+parentBounds.height}else{y=parentBounds.top-bounds.height}return{left:x,top:y,width:bounds.width,height:bounds.height}}highlightEdge_(id,layoutPosition){for(let i=0;i<this.layouts.length;++i){const layout=this.layouts[i];const highlight=layout.id===id||layout.parentId===id?layoutPosition:undefined;const div=id?this.shadowRoot.getElementById(`_${id}`):this.shadowRoot.getElementById(`_${layout.id}`);assert(div);div.classList.toggle("highlight-right",highlight===LayoutPosition.RIGHT);div.classList.toggle("highlight-left",highlight===LayoutPosition.LEFT);div.classList.toggle("highlight-top",highlight===LayoutPosition.TOP);div.classList.toggle("highlight-bottom",highlight===LayoutPosition.BOTTOM)}}}return LayoutMixinInternal}));
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const MIN_VISUAL_SCALE=.01;const DisplayLayoutElementBase=mixinBehaviors([IronResizableBehavior],LayoutMixin(I18nMixin(PolymerElement)));class DisplayLayoutElement extends DisplayLayoutElementBase{static get is(){return"display-layout"}static get template(){return getTemplate$34()}static get properties(){return{displays:Array,selectedDisplay:Object,visualScale:{type:Number,value:1},mirroringDestinationIds_:Array}}constructor(){super();this.visualOffset_={left:0,top:0};this.lastDragCoordinates_=null;this.browserProxy_=DevicePageBrowserProxyImpl.getInstance();this.allowDisplayAlignmentApi_=loadTimeData.getBoolean("allowDisplayAlignmentApi");this.invalidDisplayId_=loadTimeData.getString("invalidDisplayId");this.hasDragStarted_=false;this.mirroringDestinationIds_=[]}disconnectedCallback(){super.disconnectedCallback();this.initializeDrag(false)}updateDisplays(displays,layouts,mirroringDestinationIds){this.displays=displays;this.layouts=layouts;this.mirroringDestinationIds_=mirroringDestinationIds;this.initializeDisplayLayout(displays,layouts);const self=this;const retry=100;function tryCalcVisualScale(){if(!self.calculateVisualScale_()){setTimeout(tryCalcVisualScale,retry)}}tryCalcVisualScale();this.keyboardDragEnabled=true;this.initializeDrag(!this.mirroring,this.$.displayArea,((id,amount)=>this.onDrag_(id,amount)))}calculateVisualScale_(){const displayAreaDiv=this.$.displayArea;if(!displayAreaDiv||!displayAreaDiv.offsetWidth||!this.displays||!this.displays.length){return false}let display=this.displays[0];let bounds=this.getCalculatedDisplayBounds(display.id);const boundsBoundingBox={left:bounds.left,right:bounds.left+bounds.width,top:bounds.top,bottom:bounds.top+bounds.height};let maxWidth=bounds.width;let maxHeight=bounds.height;for(let i=1;i<this.displays.length;++i){display=this.displays[i];bounds=this.getCalculatedDisplayBounds(display.id);boundsBoundingBox.left=Math.min(boundsBoundingBox.left,bounds.left);boundsBoundingBox.right=Math.max(boundsBoundingBox.right,bounds.left+bounds.width);boundsBoundingBox.top=Math.min(boundsBoundingBox.top,bounds.top);boundsBoundingBox.bottom=Math.max(boundsBoundingBox.bottom,bounds.top+bounds.height);maxWidth=Math.max(maxWidth,bounds.width);maxHeight=Math.max(maxHeight,bounds.height)}const boundsWidth=boundsBoundingBox.right-boundsBoundingBox.left;const boundsHeight=boundsBoundingBox.bottom-boundsBoundingBox.top;const horizontalScale=displayAreaDiv.offsetWidth/(boundsWidth+maxWidth*2);const verticalScale=displayAreaDiv.offsetHeight/(boundsHeight+maxHeight*2);const scale=Math.min(horizontalScale,verticalScale);this.visualOffset_.left=(displayAreaDiv.offsetWidth-boundsWidth*scale)/2-boundsBoundingBox.left*scale;this.visualOffset_.top=(displayAreaDiv.offsetHeight-boundsHeight*scale)/2-boundsBoundingBox.top*scale;this.visualScale=Math.max(MIN_VISUAL_SCALE,scale);return true}getDivStyle_(id,_displayBounds,_visualScale,offset){const BORDER=1;const MARGIN=4;const OFFSET=offset||0;const PADDING=3;const bounds=this.getCalculatedDisplayBounds(id,true);if(!bounds){return""}const height=Math.round(bounds.height*this.visualScale)-BORDER*2-MARGIN*2-PADDING*2;const width=Math.round(bounds.width*this.visualScale)-BORDER*2-MARGIN*2-PADDING*2;const left=OFFSET+Math.round(this.visualOffset_.left+bounds.left*this.visualScale);const top=OFFSET+Math.round(this.visualOffset_.top+bounds.top*this.visualScale);return"height: "+height+"px; width: "+width+"px;"+" left: "+left+"px; top: "+top+"px"}getMirrorDivStyle_(mirroringDestinationIndex,mirroringDestinationDisplayNum,displays,visualScale){return this.getDivStyle_(displays[0].id,displays[0].bounds,visualScale,(mirroringDestinationDisplayNum-mirroringDestinationIndex)*-4)}isSelected_(display,selectedDisplay){return display.id===selectedDisplay.id}dispatchSelectDisplayEvent_(displayId){const selectDisplayEvent=new CustomEvent("select-display",{composed:true,detail:displayId});this.dispatchEvent(selectDisplayEvent)}onSelectDisplayClick_(e){this.dispatchSelectDisplayEvent_(e.model.item.id);e.target.focus()}onFocus_(e){this.dispatchSelectDisplayEvent_(e.model.item.id);e.target.focus()}getPositionChangeAnnouncement_(deltaX,deltaY){let description="";if(deltaX!==0&&deltaY!==0){if(deltaY>0&&deltaX>0){description="displayPositionDownAndRight"}else if(deltaY>0&&deltaX<0){description="displayPositionDownAndLeft"}else if(deltaY<0&&deltaX>0){description="displayPositionUpAndRight"}else if(deltaY<0&&deltaX<0){description="displayPositionUpAndLeft"}}else{if(deltaY>0){description="displayPositionDown"}else if(deltaY<0){description="displayPositionUp"}else if(deltaX>0){description="displayPositionRight"}else if(deltaX<0){description="displayPositionLeft"}}return this.i18n(description)}onDrag_(id,amount){id=id.substr(1);let newBounds;if(!amount){this.finishUpdateDisplayBounds(id);newBounds=this.getCalculatedDisplayBounds(id);this.lastDragCoordinates_=null;this.browserProxy_.highlightDisplay(this.invalidDisplayId_)}else{this.browserProxy_.highlightDisplay(id);if(id!==this.selectedDisplay.id){this.dispatchSelectDisplayEvent_(id)}const calculatedBounds=this.getCalculatedDisplayBounds(id);newBounds={...calculatedBounds};newBounds.left+=Math.round(amount.x/this.visualScale);newBounds.top+=Math.round(amount.y/this.visualScale);if(this.displays.length>=2){newBounds=this.updateDisplayBounds(id,newBounds)}if(!this.lastDragCoordinates_){this.hasDragStarted_=true;this.lastDragCoordinates_={x:calculatedBounds.left,y:calculatedBounds.top}}const deltaX=newBounds.left-this.lastDragCoordinates_.x;const deltaY=newBounds.top-this.lastDragCoordinates_.y;this.lastDragCoordinates_.x=newBounds.left;this.lastDragCoordinates_.y=newBounds.top;if(deltaX!==0||deltaY!==0){if(this.allowDisplayAlignmentApi_){this.browserProxy_.dragDisplayDelta(id,Math.round(deltaX),Math.round(deltaY))}const announcer=getInstance(this.$.displayArea);strictQuery("#messages",announcer.shadowRoot,HTMLDivElement).removeAttribute("role");announcer.announce(this.getPositionChangeAnnouncement_(deltaX,deltaY))}}const left=this.visualOffset_.left+Math.round(newBounds.left*this.visualScale);const top=this.visualOffset_.top+Math.round(newBounds.top*this.visualScale);const div=castExists(this.shadowRoot.getElementById(`_${id}`));div.style.left=""+left+"px";div.style.top=""+top+"px";div.focus()}}customElements.define(DisplayLayoutElement.is,DisplayLayoutElement);function getTemplate$33(){return html`<!--_html_template_start_--><style include="settings-shared iron-flex iron-flex-alignment">.subtitle{color:var(--cros-text-color-secondary);margin-top:10px}.instructions{color:var(--cros-text-color-secondary);margin-top:4px}.details{margin:40px}.label{margin-top:15px}iron-icon{--iron-icon-fill-color:var(--cros-icon-color-primary);--iron-icon-height:18px;--iron-icon-width:18px;background:var(--cros-bg-color-dropped-elevation-2);border-radius:2px;margin:5px;padding:4px}#move{align-items:center;display:flex;flex-direction:row}#move>div{color:var(--cros-text-color-secondary);flex:0 0 auto}#move>div:not(:first-child){margin-inline-start:8px}#move>div:not(:last-child){margin-inline-end:8px}#move>div.shift{background:var(--cros-bg-color-dropped-elevation-2);border-radius:2px;color:var(--cros-text-color-primary);font-size:100%;padding:7px 8px}</style>
<cr-dialog id="dialog" on-close="close"
    close-text="$i18n{close}">
  <div slot="title">$i18n{displayOverscanPageTitle}</div>
  <div slot="body">
    <div class="subtitle" >$i18n{displayOverscanSubtitle}</div>
    <div class="details layout horizontal around-justified self-stretch">
      <div class="layout vertical center">
        <div class="layout horizontal">
          <iron-icon icon="cr:expand-less"></iron-icon>
        </div>
        <div class="layout horizontal">
          <iron-icon icon="os-settings:chevron-left"></iron-icon>
          <iron-icon icon="cr:expand-more"></iron-icon>
          <iron-icon icon="cr:chevron-right"></iron-icon>
        </div>
        <div class="label" >$i18n{displayOverscanResize}</div>
      </div>
      <div class="layout vertical center">
        <div class="layout vertical center-justified flex">
          <div id="move" class="layout horizontal">
            <!-- TODO(stevenjb): Localize 'shift' for other keyboards -->
            <!-- crbug.com/614827 -->
            <div>(</div><div>+</div><div class="shift">shift</div><div>)</div>
          </div>
        </div>
        <div class="label">$i18n{displayOverscanPosition}</div>
      </div>
    </div>
  </div>
  <div slot="button-container">
    <cr-button id="reset" class="cancel-button" on-click="onResetClick_">
      $i18n{displayOverscanReset}
    </cr-button>
    <cr-button class="action-button" on-click="onSaveClick_">
      $i18n{ok}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class SettingsDisplayOverscanDialogElement extends PolymerElement{static get is(){return"settings-display-overscan-dialog"}static get template(){return getTemplate$33()}static get properties(){return{displayId:{type:String,notify:true,observer:"displayIdChanged_"},committed_:Boolean}}constructor(){super();this.keyHandler_=this.handleKeyEvent_.bind(this)}open(){window.addEventListener("keydown",this.keyHandler_);this.committed_=false;this.$.dialog.showModal();this.shadowRoot.getElementById("reset").blur()}close(){window.removeEventListener("keydown",this.keyHandler_);this.displayId="";if(this.$.dialog.open){this.$.dialog.close()}}displayIdChanged_(newValue,oldValue){if(oldValue&&!this.committed_){getDisplayApi().overscanCalibrationReset(oldValue);getDisplayApi().overscanCalibrationComplete(oldValue)}if(!newValue){return}this.committed_=false;getDisplayApi().overscanCalibrationStart(newValue)}onResetClick_(){getDisplayApi().overscanCalibrationReset(this.displayId)}onSaveClick_(){getDisplayApi().overscanCalibrationComplete(this.displayId);this.committed_=true;this.close()}handleKeyEvent_(event){if(event.altKey||event.ctrlKey||event.metaKey){return}switch(event.keyCode){case 37:if(event.shiftKey){this.move_(-1,0)}else{this.resize_(1,0)}break;case 38:if(event.shiftKey){this.move_(0,-1)}else{this.resize_(0,-1)}break;case 39:if(event.shiftKey){this.move_(1,0)}else{this.resize_(-1,0)}break;case 40:if(event.shiftKey){this.move_(0,1)}else{this.resize_(0,1)}break;default:return}event.preventDefault()}move_(x,y){const delta={left:x,top:y,right:x?-x:0,bottom:y?-y:0};getDisplayApi().overscanCalibrationAdjust(this.displayId,delta)}resize_(x,y){const delta={left:x,top:y,right:x,bottom:y};getDisplayApi().overscanCalibrationAdjust(this.displayId,delta)}}customElements.define(SettingsDisplayOverscanDialogElement.is,SettingsDisplayOverscanDialogElement);function getTemplate$32(){return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared iron-flex
  iron-flex-alignment">.indented{align-self:stretch;margin-inline-start:var(--cr-section-indent-padding);padding:0}#nightLightTemperatureDiv[disabled]{opacity:0.38;pointer-events:none}.text-area{margin:10px 0}#nightLightSlider{flex-grow:1;margin-top:20px}#nightLightDropDownDiv{width:200px;text-align:right;margin-top:8px}iron-collapse{width:100%}</style>

<settings-toggle-button
    id="nightLightToggleButton"
    class="settings-box first"
    label="$i18n{displayNightLightLabel}"
    pref="{{prefs.ash.night_light.enabled}}"
    sub-label="$i18n{displayNightLightText}"
    deep-link-focus-id$="[[Setting.kNightLight]]">
</settings-toggle-button>

<div id="nightLightSettingsDiv"
    class="settings-box continuation start layout vertical">
  <!-- Color temperature slider -->
  <div id="nightLightTemperatureDiv"
      class="settings-box indented continuation"
      hidden$="[[!prefs.ash.night_light.enabled.value]]">
    <div class="start text-area" id="colorTemperatureLabel">
      $i18n{displayNightLightTemperatureLabel}
    </div>
    <settings-slider id="colorTemperatureSlider"
        aria-labelledby="colorTemperatureLabel" min="0" max="100"
        scale="100" label-min="$i18n{displayNightLightTempSliderMinLabel}"
        label-max="$i18n{displayNightLightTempSliderMaxLabel}"
        pref="{{prefs.ash.night_light.color_temperature}}"
        deep-link-focus-id$="[[Setting.kNightLightColorTemperature]]">
    </settings-slider>
  </div>
  <!-- Schedule settings -->
  <div class="settings-box indented">
    <div id="NightLightLabelDiv" class="start text-area" aria-hidden="true">
      <div id="nightLightScheduleLabel" class="label">
        $i18n{displayNightLightScheduleLabel}
      </div>
      <div id="nightLightScheduleSubLabel" class="secondary label"
          hidden$="[[!nightLightScheduleSubLabel_]]">
        [[nightLightScheduleSubLabel_]]
      </div>
    </div>
    <div id="nightLightDropDownDiv"
        class="cr-row-gap">
      <settings-dropdown-menu
          id="nightLightScheduleTypeDropDown"
          label="$i18n{displayNightLightScheduleLabel}"
          aria-describedby="nightLightScheduleSubLabel"
          pref="{{prefs.ash.night_light.schedule_type}}"
          menu-options="[[scheduleTypesList_]]">
      </settings-dropdown-menu>
      <template is="dom-if" if="[[shouldShowGeolocationWarningText_]]"
          restamp>
        <settings-privacy-hub-geolocation-warning-text
            id="warningText"
            warning-text-with-anchor=
                "[[geolocationWarningText_]]"
            on-link-clicked="openGeolocationDialog_">
        </settings-privacy-hub-geolocation-warning-text>
      </template>
    </div>
  </div>
  <!-- Custom schedule slider -->
  <iron-collapse id="nightLightCustomScheduleCollapse"
      opened="[[shouldOpenCustomScheduleCollapse_]]">
    <div class="settings-box indented continuation">
      <div class="start text-area layout vertical">
        <div class="settings-box continuation self-stretch">
          <settings-scheduler-slider id="nightLightSlider" prefs="{{prefs}}"
              pref-start-time="{{prefs.ash.night_light.custom_start_time}}"
              pref-end-time="{{prefs.ash.night_light.custom_end_time}}">
          </settings-scheduler-slider>
        </div>
      </div>
    </div>
  </iron-collapse>
</div>

<!-- System geolocation dialog, letting users enable location permission -->
<template is="dom-if" if="[[shouldShowGeolocationDialog_]]" restamp>
  <settings-privacy-hub-geolocation-dialog id="geolocationDialog"
      on-close="onGeolocationDialogClose_"
      prefs="{{prefs}}">
  </settings-privacy-hub-geolocation-dialog>
</template>
<!--_html_template_end_-->`}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var NightLightScheduleType;(function(NightLightScheduleType){NightLightScheduleType[NightLightScheduleType["NEVER"]=0]="NEVER";NightLightScheduleType[NightLightScheduleType["SUNSET_TO_SUNRISE"]=1]="SUNSET_TO_SUNRISE";NightLightScheduleType[NightLightScheduleType["CUSTOM"]=2]="CUSTOM"})(NightLightScheduleType||(NightLightScheduleType={}));const SettingsDisplayNightLightElementBase=DeepLinkingMixin(PrefsMixin(I18nMixin(PolymerElement)));class SettingsDisplayNightLightElement extends SettingsDisplayNightLightElementBase{static get is(){return"settings-display-night-light"}static get template(){return getTemplate$32()}static get properties(){return{scheduleTypesList_:{type:Array,value(){return[{name:loadTimeData.getString("displayNightLightScheduleNever"),value:NightLightScheduleType.NEVER},{name:loadTimeData.getString("displayNightLightScheduleSunsetToSunRise"),value:NightLightScheduleType.SUNSET_TO_SUNRISE},{name:loadTimeData.getString("displayNightLightScheduleCustom"),value:NightLightScheduleType.CUSTOM}]}},shouldOpenCustomScheduleCollapse_:{type:Boolean,value:false},nightLightScheduleSubLabel_:String,shouldShowGeolocationWarningText_:{type:Boolean,computed:"computeShouldShowGeolocationWarningText_("+"prefs.ash.night_light.schedule_type.value, "+"prefs.ash.user.geolocation_access_level.value),"},sunriseTime_:{type:String,value(){return loadTimeData.getString("privacyHubSystemServicesInitSunRiseTime")}},sunsetTime_:{type:String,value(){return loadTimeData.getString("privacyHubSystemServicesInitSunSetTime")}},geolocationWarningText_:{type:String,computed:"computeGeolocationWarningText_("+"prefs.ash.user.geolocation_access_level.*,"+"sunriseTime_, sunsetTime_)"},shouldShowEnableGeolocationDialog_:{type:Boolean,value:false},isInternalDisplay:Boolean,currentNightLightStatus:Boolean,currentScheduleType:NightLightScheduleType}}static get observers(){return["updateNightLightScheduleSettings_(prefs.ash.night_light.schedule_type.*,"+" prefs.ash.night_light.enabled.*),","onTimeZoneChanged_(prefs.cros.system.timezone.value)"]}constructor(){super();this.supportedSettingIds=new Set([Setting.kNightLight,Setting.kNightLightColorTemperature]);this.displaySettingsProvider=getDisplaySettingsProvider();this.privacyHubBrowserProxy_=PrivacyHubBrowserProxyImpl.getInstance()}updateNightLightScheduleSettings_(){const scheduleType=this.getPref("ash.night_light.schedule_type").value;this.shouldOpenCustomScheduleCollapse_=scheduleType===NightLightScheduleType.CUSTOM;const nightLightStatus=this.getPref("ash.night_light.enabled").value;if(scheduleType===NightLightScheduleType.SUNSET_TO_SUNRISE){this.nightLightScheduleSubLabel_=nightLightStatus?this.i18n("displayNightLightOffAtSunrise"):this.i18n("displayNightLightOnAtSunset")}else{this.nightLightScheduleSubLabel_=""}if(this.currentScheduleType!==scheduleType&&this.currentScheduleType!==undefined){this.recordChangingNightLightSchedule(this.isInternalDisplay,scheduleType)}if(this.currentNightLightStatus!==nightLightStatus&&this.currentNightLightStatus!==undefined){this.recordTogglingNightLightStatus(this.isInternalDisplay,nightLightStatus)}this.currentScheduleType=scheduleType;this.currentNightLightStatus=nightLightStatus}recordChangingNightLightSchedule(isInternalDisplay,nightLightSchedule){this.displaySettingsProvider.recordChangingDisplaySettings(DisplaySettingsType.kNightLightSchedule,{isInternalDisplay:isInternalDisplay,nightLightSchedule:nightLightSchedule,displayId:null,orientation:null,nightLightStatus:null,mirrorModeStatus:null,unifiedModeStatus:null})}recordTogglingNightLightStatus(isInternalDisplay,nightLightStatus){this.displaySettingsProvider.recordChangingDisplaySettings(DisplaySettingsType.kNightLight,{isInternalDisplay:isInternalDisplay,nightLightStatus:nightLightStatus,displayId:null,orientation:null,nightLightSchedule:null,mirrorModeStatus:null,unifiedModeStatus:null})}computeShouldShowGeolocationWarningText_(){const scheduleType=this.prefs.ash.night_light.schedule_type.value;const geolocationAccessLevel=this.prefs.ash.user.geolocation_access_level.value;return scheduleType===NightLightScheduleType.SUNSET_TO_SUNRISE&&geolocationAccessLevel===GeolocationAccessLevel.DISALLOWED}computeGeolocationWarningText_(){if(!this.prefs){return""}if(this.prefs.ash.user.geolocation_access_level.enforcement===chrome.settingsPrivate.Enforcement.ENFORCED){return loadTimeData.getStringF("displayNightLightGeolocationManagedWarningText",this.sunriseTime_,this.sunsetTime_)}else{return loadTimeData.getStringF("displayNightLightGeolocationWarningText",this.sunriseTime_,this.sunsetTime_)}}openGeolocationDialog_(){this.shouldShowGeolocationDialog_=true}onGeolocationDialogClose_(){this.shouldShowGeolocationDialog_=false}onTimeZoneChanged_(){this.privacyHubBrowserProxy_.getCurrentSunriseTime().then((time=>{this.sunriseTime_=time}));this.privacyHubBrowserProxy_.getCurrentSunsetTime().then((time=>{this.sunsetTime_=time}))}}customElements.define(SettingsDisplayNightLightElement.is,SettingsDisplayNightLightElement);function getTemplate$31(){return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared md-select iron-flex
  iron-flex-alignment">#arrangement-section{border-top:none}#arrangement-section-main{padding:0 var(--cr-section-padding)}.indented{align-self:stretch;margin-inline-start:var(--cr-section-indent-padding);padding:0}.display-tabs{width:100%}display-layout{align-self:stretch;flex:1 1 auto;height:300px;margin:10px;min-height:300px}.text-area{margin:10px 0}.settings-box>cr-button:first-child{padding-inline-start:0}.settings-box>cr-policy-pref-indicator{margin-inline-end:var(--cr-controlled-by-spacing)}.underbar{border-bottom:var(--cr-separator-line)}#controlsDiv>.settings-box:first-of-type{border-top:none}#mirrorDisplayToggleButton{align-self:stretch;border-top:none;display:flex}#brightnessSliderWrapper{min-width:200px;display:flex;flex-direction:column}</style>

<!-- Display Shiny Performance Mode Controller -->
<div id="displayPerformanceModeSubsection" class="settings-box"
    hidden="[[!isDisplayPerformanceSupported_]]">
  <div id="displayPerformanceModeLabel"
      class="start text-area" aria-hidden="true">
      <!-- TODO(b/326270858): Translate the label -->
      $i18n{displayShinyPerformanceLabel}
  </div>
  <cr-toggle id="displayPerformanceModeToggle"
      aria-labelledby="displayPerformanceModeLabel"
      on-change="toggleDisplayPerformanceEnabled_">
  </cr-toggle>
</div>

<!-- Arrangement section -->
<template is="dom-if"
    if="[[shouldShowArrangementSection(displays)]]" restamp>
  <div class="underbar" id="arrangement-section">
    <div class="layout vertical self-stretch" id="arrangement-section-main">
      <h2 class="layout self-start">
        $i18n{displayArrangementTitle}
      </h2>
      <div class="secondary layout self-start"
          hidden="[[isMirrored(displays)]]">
        $i18n{displayArrangementText}
      </div>
      <display-layout id="displayLayout"
          selected-display="[[selectedDisplay]]"
          on-select-display="onSelectDisplay_"
          deep-link-focus-id$="[[Setting.kDisplayArrangement]]">
      </display-layout>
    </div>

    <template is="dom-if"
        if="[[showMirror(unifiedDesktopMode_, displays)]]" restamp>
      <!-- Mirror display toggle button -->
      <div id="mirrorDisplayToggleButton" class="settings-box"
          on-click="onMirroredClick_" actionable-row>
        <div id="mirrorDisplayToggleLabel" class="start">
          [[getDisplayMirrorText_(displays, primaryDisplay)]]
        </div>
        <cr-toggle id="mirrorDisplayToggle"
            checked="[[isMirrored(displays)]]"
            on-change="onMirroredClick_"
            aria-label="[[getDisplayMirrorText_(displays)]]"
            deep-link-focus-id$="[[Setting.kDisplayMirroring]]">
        </cr-toggle>
      </div>
    </template>

  </div>
</template>

<!-- Display tabs -->
<div hidden="[[!hasMultipleDisplays_(displays)]]"
    class="settings-box first">
  <cr-tabs selected="[[selectedTab_]]" class="display-tabs"
      on-selected-changed="onSelectDisplayTab_"
      tab-names="[[displayTabNames_]]"></cr-tabs>
</div>

<div id="controlsDiv" class="settings-box layout vertical first">
  <h2>[[selectedDisplay.name]]</h2>
  <template is="dom-if" if="[[showUnifiedDesktop(unifiedDesktopAvailable_,
      unifiedDesktopMode_, displays, isTabletMode_)]]" restamp>
    <div class="settings-box indented two-line"
         on-click="onUnifiedDesktopClick_" actionable-row>
      <div class="start">
        <div id="displayUnifiedDesktopCheckboxLabel">
          $i18n{displayUnifiedDesktop}
        </div>
        <div class="secondary">
          [[getUnifiedDesktopText_(unifiedDesktopMode_)]]
        </div>
      </div>
      <cr-toggle id="displayUnifiedDesktopToggle"
          checked="[[unifiedDesktopMode_]]"
          on-change="onUnifiedDesktopClick_"
          aria-labelledby="displayUnifiedDesktopCheckboxLabel"
          deep-link-focus-id$="[[Setting.kAllowWindowsToSpanDisplays]]">
      </cr-toggle>
    </div>
  </template>

  <template is="dom-if" restamp
      if="[[showDisplaySelectMenu_(displays, selectedDisplay)]]">
    <div class="settings-box indented">
      <div id="displayScreenTitle" class="start" aria-hidden="true">
        $i18n{displayScreenTitle}
      </div>
      <select id="primaryDisplaySelect"
          class="md-select"
          on-change="updatePrimaryDisplay_"
          aria-labelledby="displayScreenTitle"
          value="[[getDisplaySelectMenuIndex_(
              selectedDisplay, primaryDisplayId)]]">
        <option value="0">$i18n{displayScreenPrimary}</option>
        <option value="1">$i18n{displayScreenExtended}</option>
      </select>
    </div>
  </template>

  <!-- Display brightness controls -->
  <template is="dom-if" restamp
      if="[[showBrightnessControls_(selectedDisplay)]]">
    <template is="dom-if" restamp
        if="[[showAutoBrightnessToggle_(hasAmbientLightSensor_)]]">
      <div class="settings-box indented" id="autoBrightnessToggleRow"
          on-click="onAutoBrightnessToggleRowClicked_" actionable-row>
        <div class="start settings-box-text">
          <div id="autoBrightnessToggleLabel" class="start" aria-hidden="true">
              $i18n{displayAutoBrightnessToggleLabel}
          </div>
          <div id="autoBrightnessToggleSubtitle" class="secondary"
              aria-hidden="true">
            $i18n{displayAutoBrightnessToggleSubtitle}
          </div>
        </div>
        <cr-toggle id="autoBrightnessToggle"
            checked="[[isAmbientLightSensorEnabled_]]"
            on-change="onAutoBrightnessToggleChange_"
            aria-labelledby="autoBrightnessToggleLabel"
            aria-describedby="autoBrightnessToggleSubtitle">
        </cr-toggle>
      </div>
    </template>
    <div class="settings-box indented">
      <div id="brightnessControlsTitle" class="start" aria-hidden="true">
        $i18n{displayBrightnessLabel}
      </div>
      <div id="brightnessSliderWrapper">
        <cr-slider id="brightnessSlider" min="[[brightnessSliderMin_]]"
            max="[[brightnessSliderMax_]]" key-press-slider-increment="10"
            value="[[currentInternalScreenBrightness_]]"
            on-cr-slider-value-changed="onDisplayBrightnessSliderChanged_"
            aria-labelledby="brightnessControlsTitle">
        </cr-slider>
      </div>
    </div>
  </template>

  <!-- Display zoom selection slider -->
  <div class="settings-box indented two-line">
    <div class="start text-area layout vertical">
      <div id="displayZoomLabel" aria-hidden="true">
        $i18n{displayZoomLabel}
      </div>
      <div id="displayZoomDescription" class="secondary self-start"
          aria-hidden="true">
        $i18n{displayZoomDescription}
      </div>
      <div id="logicalResolutionText" class="secondary self-start"
          hidden$="[[!logicalResolutionText_]]" aria-hidden="true">
        [[logicalResolutionText_]]
      </div>
    </div>
    <template is="dom-if" if="[[isDisplayScaleManagedByPolicy_(
        selectedDisplay, prefs.cros.device_display_resolution)]]">
      <cr-policy-pref-indicator
          pref="[[prefs.cros.device_display_resolution]]"
          icon-aria-label="$i18n{displayZoomLabel}">
      </cr-policy-pref-indicator>
    </template>
    <settings-slider id="displaySizeSlider"
        ticks="[[zoomValues_]]" pref="{{selectedZoomPref_}}"
        label-aria="$i18n{displayZoomLabel}"
        label-min="$i18n{displaySizeSliderMinLabel}"
        label-max="$i18n{displaySizeSliderMaxLabel}"
        disabled="[[isDisplayScaleMandatory_(
            selectedDisplay,
            prefs.cros.device_display_resolution)]]"
        on-cr-slider-value-changed="onDisplaySizeSliderDrag_"
        aria-describedby="displayZoomSublabel logicalResolutionText"
        deep-link-focus-id$="[[Setting.kDisplaySize]]">
    </settings-slider>
  </div>

  <!-- Drop down select menu for resolution -->
  <template is="dom-if"
      if="[[showDropDownResolutionSetting_(selectedDisplay)]]" restamp>
    <div class="settings-box indented two-line">
      <div class="start text-area layout vertical" aria-hidden="true">
        <div>$i18n{displayResolutionTitle}</div>
        <div class="secondary self-start" id="displayResolutionSublabel">
          $i18n{displayResolutionSublabel}
        </div>
      </div>
      <template is="dom-if" if="[[isDisplayResolutionManagedByPolicy_(
          prefs.cros.device_display_resolution)]]">
        <cr-policy-pref-indicator
            pref="[[prefs.cros.device_display_resolution]]"
            icon-aria-label="$i18n{displayResolutionTitle}">
        </cr-policy-pref-indicator>
      </template>
      <settings-dropdown-menu id="displayModeSelector"
          pref="{{selectedParentModePref_}}"
          disabled="[[isDisplayResolutionMandatory_(
              prefs.cros.device_display_resolution)]]"
          label="$i18n{displayResolutionTitle}"
          aria-describedby="displayResolutionSublabel"
          menu-options="[[displayModeList_]]"
          deep-link-focus-id$="[[Setting.kDisplayResolution]]">
      </settings-dropdown-menu>
    </div>
  </template>

  <!-- Drop down select menu for refresh rate -->
  <template is="dom-if" if="[[showRefreshRateSetting_(selectedDisplay)]]"
      restamp>
    <div class="settings-box indented two-line">
      <div class="start text-area layout vertical" aria-hidden="true">
        <div>$i18n{displayRefreshRateTitle}</div>
        <div class="secondary self-start" id="displayRefreshRateSublabel">
          $i18n{displayRefreshRateSublabel}
        </div>
      </div>
      <template is="dom-if" if="[[isDisplayResolutionManagedByPolicy_(
          prefs.cros.device_display_resolution)]]">
        <cr-policy-pref-indicator
            pref="[[prefs.cros.device_display_resolution]]"
            icon-aria-label="$i18n{displayResolutionText}">
        </cr-policy-pref-indicator>
      </template>
      <settings-dropdown-menu id="refreshRateSelector"
          pref="{{selectedModePref_}}"
          disabled="[[isDisplayResolutionMandatory_(
              prefs.cros.device_display_resolution)]]"
          label="Refresh Rate Menu"
          aria-describedby="displayRefreshRateSublabel"
          menu-options="[[refreshRateList_]]"
          deep-link-focus-id$="[[Setting.kDisplayRefreshRate]]">
      </settings-dropdown-menu>
    </div>
  </template>


  <template is="dom-if" if="[[!unifiedDesktopMode_]]" restamp>
    <div class="settings-box indented">
      <div id="displayOrientation" class="start text-area"
          aria-hidden="true">
        $i18n{displayOrientation}
      </div>
      <template is="dom-if" if="[[isDevicePolicyEnabled_(
          prefs.cros.display_rotation_default)]]">
        <cr-policy-pref-indicator
            pref="[[prefs.cros.display_rotation_default]]"
            icon-aria-label="$i18n{displayOrientation}">
        </cr-policy-pref-indicator>
      </template>
      <select id="orientationSelect"
          class="md-select"
          value="[[selectedDisplay.rotation]]"
          aria-labelledby="displayOrientation"
          on-change="onOrientationChange_"
          deep-link-focus-id$="[[Setting.kDisplayOrientation]]">
        <option value="-1"
            hidden$="[[!showAutoRotateOption_(selectedDisplay)]]">
          $i18n{displayOrientationAutoRotate}
        </option>
        <option value="0">$i18n{displayOrientationStandard}</option>
        <option value="90">90&deg;</option>
        <option value="180">180&deg;</option>
        <option value="270">270&deg;</option>
      </select>
    </div>
  </template>

  <template is="dom-if" if="[[showAmbientColorSetting(
      ambientColorAvailable_, selectedDisplay)]]">
    <settings-toggle-button id="ambientColor"
        class="indented hr"
        pref="{{prefs.ash.ambient_color.enabled}}"
        label="$i18n{displayAmbientColorTitle}"
        sub-label="$i18n{displayAmbientColorSubtitle}"
        deep-link-focus-id$="[[Setting.kAmbientColors]]">
    </settings-toggle-button>
  </template>

  <cr-link-row class="indented hr" id="overscan"
      label="$i18n{displayOverscanPageTitle}"
      sub-label="$i18n{displayOverscanPageText}" on-click="onOverscanClick_"
      hidden$="[[!showOverscanSetting_(selectedDisplay)]]" embedded
      deep-link-focus-id$="[[Setting.kDisplayOverscan]]">
  </cr-link-row>

  <settings-display-overscan-dialog id="displayOverscan"
      display-id="{{overscanDisplayId}}"
      on-close="onCloseOverscanDialog_">
  </settings-display-overscan-dialog>

  <!-- Link row to touch calibration -->
  <cr-link-row class="indented hr" id="touchCalibration"
      label="$i18n{displayTouchCalibrationTitle}"
      sub-label="$i18n{displayTouchCalibrationText}"
      on-click="onTouchCalibrationClick_"
      hidden$="[[!showTouchCalibrationSetting_(selectedDisplay)]]" embedded
      deep-link-focus-id$="[[Setting.kTouchscreenCalibration]]">
  </cr-link-row>


  <template is="dom-if"
      if="[[showExcludeInMirror_(unifiedDesktopMode_,
      excludeDisplayInMirrorModeEnabled_,
      prefs.settings.display.allow_exclude_display_in_mirror_mode.value,
      displays, selectedDisplay)]]" restamp>
    <div id="excludeDisplayToggleRow"
        class="settings-box indented hr two-line">
      <div class="start text-area">
        <div id="excludeDisplayInMirrorLabel" class="start">
          $i18n{displayExcludeInMirrorModeLabel}
        </div>
        <div id="excludeDisplayInMirrorSublabel" class="secondary self-start"
            aria-hidden="true">
          $i18n{displayExcludeInMirrorModeSublabel}
        </div>
      </div>
      <cr-toggle id="excludeDisplayToggle"
          checked="[[shouldExcludeInMirror_(selectedDisplay)]]"
          on-change="onExcludeInMirrorClick_"
          aria-label="$i18n{displayExcludeInMirrorModeLabel}">
      </cr-toggle>
    </div>
  </template>
</div>

<!-- Night Light Settings -->
<div class="hr"></div>
<settings-display-night-light prefs="{{prefs}}"
    is-internal-display="[[selectedDisplay.isInternal]]">
</settings-display-night-light>

<!-- Touchscreen Mapping Experience -->
<template is="dom-if" if="[[showTouchRemappingExperience_()]]" restamp>
  <div class="settings-box continuation start layout vertical">
    <cr-link-row class="hr" id="touchMapping"
      label="$i18n{displayTouchMappingTitle}"
      sub-label="$i18n{displayTouchMappingText}"
      on-click="onTouchMappingClick_" embedded>
    </cr-link-row>
  </div>
</template>
<!--_html_template_end_-->`}
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var MirrorMode=chrome.system.display.MirrorMode;function createDisplayValue(overrides){const empty={isInternalDisplay:null,displayId:null,orientation:null,nightLightStatus:null,nightLightSchedule:null,mirrorModeStatus:null,unifiedModeStatus:null};return Object.assign(empty,overrides)}const SettingsDisplayElementBase=DeepLinkingMixin(PrefsMixin(RouteObserverMixin(I18nMixin(PolymerElement))));const MIN_VISIBLE_PERCENT$1=10;class SettingsDisplayElement extends SettingsDisplayElementBase{static get is(){return"settings-display"}static get template(){return getTemplate$31()}static get properties(){return{selectedModePref_:{type:Object,value(){return{key:"fakeDisplaySliderPref",type:chrome.settingsPrivate.PrefType.NUMBER,value:0}}},selectedZoomPref_:{type:Object,value(){return{key:"fakeDisplaySliderZoomPref",type:chrome.settingsPrivate.PrefType.NUMBER,value:0}}},displays:Array,layouts:Array,displayIds:{type:String,observer:"onDisplayIdsChanged_"},primaryDisplayId:String,primaryDisplay:Object,selectedDisplay:Object,overscanDisplayId:{type:String,notify:true},mirroringDestinationIds:Array,modeValues_:Array,zoomValues_:Array,displayModeList_:{type:Array,value:[]},refreshRateList_:{type:Array,value:[]},unifiedDesktopAvailable_:{type:Boolean,value(){return loadTimeData.getBoolean("unifiedDesktopAvailable")}},isDisplayPerformanceSupported_:{type:Boolean,value(){return loadTimeData.getBoolean("isDisplayPerformanceSupported")}},ambientColorAvailable_:{type:Boolean,value(){return loadTimeData.getBoolean("deviceSupportsAmbientColor")}},listAllDisplayModes_:{type:Boolean,value(){return loadTimeData.getBoolean("listAllDisplayModes")}},excludeDisplayInMirrorModeEnabled_:{type:Boolean,value(){return loadTimeData.getBoolean("excludeDisplayInMirrorModeEnabled")}},opsDisplayScaleFactorEnabled_:{type:Boolean,value(){return loadTimeData.getBoolean("opsDisplayScaleFactorEnabled")}},unifiedDesktopMode_:{type:Boolean,value:false},isTabletMode_:{type:Boolean,value:false},currentInternalScreenBrightness_:{type:Number,value:0},isAmbientLightSensorEnabled_:{type:Boolean,value:true},hasAmbientLightSensor_:{type:Boolean,value:false},brightnessSliderMin_:{type:Number,value:5},brightnessSliderMax_:{type:Number,value:100},isDisplayPerformanceEnabled_:{type:Boolean,value:false},selectedParentModePref_:{type:Object,value:function(){return{key:"fakeDisplayParentModePref",type:chrome.settingsPrivate.PrefType.NUMBER,value:0}}},logicalResolutionText_:String,displayTabNames_:Array,selectedTab_:Number,pendingSettingId_:{type:Number,value:null}}}static get observers(){return["onSelectedModeChange_(selectedModePref_.value)","onSelectedParentModeChange_(selectedParentModePref_.value)","onSelectedZoomChange_(selectedZoomPref_.value)","onDisplaysChanged_(displays.*)"]}constructor(){super();this.supportedSettingIds=new Set([Setting.kDisplaySize,Setting.kDisplayOrientation,Setting.kDisplayArrangement,Setting.kDisplayResolution,Setting.kDisplayRefreshRate,Setting.kDisplayMirroring,Setting.kAllowWindowsToSpanDisplays,Setting.kAmbientColors,Setting.kTouchscreenCalibration,Setting.kDisplayOverscan]);this.currentSelectedParentModeIndex_=-1;this.currentSelectedModeIndex_=-1;this.displayChangedListener_=null;this.invalidDisplayId_=loadTimeData.getString("invalidDisplayId");this.mirroringExcludedId_=this.invalidDisplayId_;this.currentRoute_=null;this.browserProxy_=DevicePageBrowserProxyImpl.getInstance();this.parentModeToRefreshRateMap_=new Map;this.modeToParentModeMap_=new Map;this.displaySettingsProvider=getDisplaySettingsProvider()}async connectedCallback(){super.connectedCallback();this.displayChangedListener_=this.displayChangedListener_||this.getDisplayInfo_.bind(this);getDisplayApi().onDisplayChanged.addListener(this.displayChangedListener_);this.getDisplayInfo_();this.$.displaySizeSlider.updateValueInstantly=false;const{isTabletMode:isTabletMode}=await this.displaySettingsProvider.observeTabletMode(new TabletModeObserverReceiver(this).$.bindNewPipeAndPassRemote());this.isTabletMode_=isTabletMode;const{brightnessPercent:brightnessPercent}=await this.displaySettingsProvider.observeDisplayBrightnessSettings(new DisplayBrightnessSettingsObserverReceiver(this).$.bindNewPipeAndPassRemote());this.currentInternalScreenBrightness_=brightnessPercent;const{isAmbientLightSensorEnabled:isAmbientLightSensorEnabled}=await this.displaySettingsProvider.observeAmbientLightSensor(new AmbientLightSensorObserverReceiver(this).$.bindNewPipeAndPassRemote());this.isAmbientLightSensorEnabled_=isAmbientLightSensorEnabled;const{hasAmbientLightSensor:hasAmbientLightSensor}=await this.displaySettingsProvider.hasAmbientLightSensor();this.hasAmbientLightSensor_=hasAmbientLightSensor;this.displaySettingsProvider.observeDisplayConfiguration(new DisplayConfigurationObserverReceiver(this).$.bindNewPipeAndPassRemote());this.displaySettingsProvider.recordChangingDisplaySettings(DisplaySettingsType.kDisplayPage,createDisplayValue({}))}disconnectedCallback(){super.disconnectedCallback();getDisplayApi().onDisplayChanged.removeListener(castExists(this.displayChangedListener_));this.currentSelectedModeIndex_=-1;this.currentSelectedParentModeIndex_=-1}onTabletModeChanged(isTabletMode){this.isTabletMode_=isTabletMode}onDisplayConfigurationChanged(){this.getDisplayInfo_()}onDisplayBrightnessChanged(brightnessPercent,triggeredByAls){if(triggeredByAls&&brightnessPercent>0&&brightnessPercent<MIN_VISIBLE_PERCENT$1){this.currentInternalScreenBrightness_=MIN_VISIBLE_PERCENT$1;return}this.currentInternalScreenBrightness_=brightnessPercent}onAmbientLightSensorEnabledChanged(isAmbientLightSensorEnabled){this.isAmbientLightSensorEnabled_=isAmbientLightSensorEnabled}beforeDeepLinkAttempt(_settingId){if(!this.displays){return false}return true}currentRouteChanged(newRoute,oldRoute){this.currentRoute_=newRoute;if(newRoute!==routes.DISPLAY&&oldRoute===routes.DISPLAY){this.browserProxy_.highlightDisplay(this.invalidDisplayId_);return}if(newRoute!==routes.DISPLAY){this.pendingSettingId_=null;return}this.attemptDeepLink().then((result=>{if(!result.deepLinkShown&&result.pendingSettingId){this.pendingSettingId_=result.pendingSettingId}}))}showOverscanDialog_(showOverscan){if(showOverscan){this.$.displayOverscan.open();this.$.displayOverscan.focus()}else{this.$.displayOverscan.close()}}onDisplayIdsChanged_(){this.showOverscanDialog_(false)}getDisplayInfo_(){const flags={singleUnified:true};getDisplayApi().getInfo(flags).then((displays=>this.displayInfoFetched_(displays)))}displayInfoFetched_(displays){if(!displays.length){return}getDisplayApi().getDisplayLayout().then((layouts=>this.displayLayoutFetched_(displays,layouts)));if(this.isMirrored(displays)){this.mirroringDestinationIds=displays[0].mirroringDestinationIds;if(displays.length!==1){const mirroringSourceId=displays[0].mirroringSourceId;this.mirroringExcludedId_=this.displays.filter((display=>!this.mirroringDestinationIds.includes(display.id)&&display.id!==mirroringSourceId))[0].id}else{this.mirroringExcludedId_=this.invalidDisplayId_}}else{this.mirroringDestinationIds=[]}}displayLayoutFetched_(displays,layouts){this.layouts=layouts;this.displays=displays;this.displayTabNames_=displays.map((({name:name})=>name));this.updateDisplayInfo_()}getSelectedModeIndex_(selectedDisplay){for(let i=0;i<selectedDisplay.modes.length;++i){if(selectedDisplay.modes[i].isSelected){return i}}return 0}isDevicePolicyEnabled_(policyPref){return policyPref!==undefined&&policyPref.value!==null}isDisplayResolutionManagedByPolicy_(resolutionPref){return this.isDevicePolicyEnabled_(resolutionPref)&&(resolutionPref.value.external_use_native!==undefined||resolutionPref.value.external_width!==undefined&&resolutionPref.value.external_height!==undefined)}isDisplayResolutionMandatory_(resolutionPref){return this.isDisplayResolutionManagedByPolicy_(resolutionPref)&&!resolutionPref.value.recommended}isDisplayScaleManagedByPolicy_(selectedDisplay,resolutionPref){if(!this.isDevicePolicyEnabled_(resolutionPref)||!selectedDisplay){return false}if(selectedDisplay.isInternal){return resolutionPref.value.internal_scale_percentage!==undefined}return resolutionPref.value.external_scale_percentage!==undefined}isDisplayScaleMandatory_(selectedDisplay,resolutionPref){return this.isDisplayScaleManagedByPolicy_(selectedDisplay,resolutionPref)&&!resolutionPref.value.recommended}parseCompoundDisplayModes_(selectedDisplay){assert(!this.listAllDisplayModes_);const optionList=[];for(let i=0;i<selectedDisplay.modes.length;++i){const mode=selectedDisplay.modes[i];const id="displayResolutionMenuItem";const refreshRate=Math.round(mode.refreshRate*100)/100;const resolution=this.i18n(id,mode.widthInNativePixels.toString(),mode.heightInNativePixels.toString(),refreshRate.toString());optionList.push({name:resolution,value:i})}this.displayModeList_=optionList}createModeMap_(selectedDisplay){const modes=new Map;for(let i=0;i<selectedDisplay.modes.length;++i){const mode=selectedDisplay.modes[i];if(!modes.has(mode.widthInNativePixels)){modes.set(mode.widthInNativePixels,new Map)}if(!modes.get(mode.widthInNativePixels).has(mode.heightInNativePixels)){modes.get(mode.widthInNativePixels).set(mode.heightInNativePixels,new Map)}if(modes.get(mode.widthInNativePixels).get(mode.heightInNativePixels).has(mode.refreshRate)){const existingModeIndex=modes.get(mode.widthInNativePixels).get(mode.heightInNativePixels).get(mode.refreshRate);const existingMode=selectedDisplay.modes[existingModeIndex];if(existingMode.isNative||!mode.isNative){continue}}modes.get(mode.widthInNativePixels).get(mode.heightInNativePixels).set(mode.refreshRate,i)}return modes}parseSplitDisplayModes_(selectedDisplay){assert(this.listAllDisplayModes_);this.modeToParentModeMap_=new Map;this.parentModeToRefreshRateMap_=new Map;this.displayModeList_=[];const modes=this.createModeMap_(selectedDisplay);const widthsArr=Array.from(modes.keys()).sort();for(let i=0;i<widthsArr.length;i++){const width=widthsArr[i];const heightsMap=modes.get(width);const heightArr=Array.from(heightsMap.keys());for(let j=0;j<heightArr.length;j++){const height=heightArr[j];const refreshRates=heightsMap.get(height);const parentModeIndex=this.getParentModeIndex_(refreshRates);this.addResolution_(parentModeIndex,width,height);const refreshRatesArr=Array.from(refreshRates.keys());for(let k=0;k<refreshRatesArr.length;k++){const rate=refreshRatesArr[k];const modeIndex=refreshRates.get(rate);const isInterlaced=selectedDisplay.modes[modeIndex].isInterlaced;this.addRefreshRate_(parentModeIndex,modeIndex,rate,isInterlaced)}}}for(let i=0;i<selectedDisplay.modes.length;i++){const mode=selectedDisplay.modes[i];const parentModeIndex=this.getParentModeIndex_(modes.get(mode.widthInNativePixels).get(mode.heightInNativePixels));this.modeToParentModeMap_.set(i,parentModeIndex)}assert(this.modeToParentModeMap_.size===selectedDisplay.modes.length);this.sortResolutionList_()}getParentModeIndex_(refreshRates){const maxRefreshRate=Math.max(...refreshRates.keys());return refreshRates.get(maxRefreshRate)}addResolution_(parentModeIndex,width,height){assert(this.listAllDisplayModes_);this.parentModeToRefreshRateMap_.set(parentModeIndex,[]);const resolutionOption=this.i18n("displayResolutionOnlyMenuItem",width,height);this.push("displayModeList_",{name:resolutionOption,value:parentModeIndex})}addRefreshRate_(parentModeIndex,modeIndex,rate,isInterlaced){assert(this.listAllDisplayModes_);let refreshRate=Number(rate).toFixed(2);if(refreshRate.endsWith(".00")){refreshRate=refreshRate.substring(0,refreshRate.length-3)}const id=isInterlaced?"displayRefreshRateInterlacedMenuItem":"displayRefreshRateMenuItem";const refreshRateOption=this.i18n(id,refreshRate.toString());this.parentModeToRefreshRateMap_.get(parentModeIndex).push({name:refreshRateOption,value:modeIndex})}sortResolutionList_(){const getWidthFromResolutionString=str=>Number(str.substr(0,str.indexOf(" ")));this.displayModeList_=this.displayModeList_.sort(((first,second)=>getWidthFromResolutionString(first.name)-getWidthFromResolutionString(second.name))).reverse()}updateDisplayModeStructures_(selectedDisplay){if(this.listAllDisplayModes_){this.parseSplitDisplayModes_(selectedDisplay)}else{this.parseCompoundDisplayModes_(selectedDisplay)}}getSelectedDisplayZoom_(selectedDisplay){const selectedZoom=selectedDisplay.displayZoomFactor;let closestMatch=this.zoomValues_[0].value;let minimumDiff=Math.abs(closestMatch-selectedZoom);for(let i=0;i<this.zoomValues_.length;i++){const currentDiff=Math.abs(this.zoomValues_[i].value-selectedZoom);if(currentDiff<minimumDiff){closestMatch=this.zoomValues_[i].value;minimumDiff=currentDiff}}return closestMatch}getZoomValues_(selectedDisplay){return selectedDisplay.availableDisplayZoomFactors.map((value=>{const ariaValue=Math.round(value*100);return{value:value,ariaValue:ariaValue,label:this.i18n("displayZoomValue",ariaValue.toString())}}))}setSelectedDisplay_(selectedDisplay){this.currentSelectedModeIndex_=-1;this.currentSelectedParentModeIndex_=-1;const numModes=selectedDisplay.modes.length;this.modeValues_=numModes===0?[]:Array.from(Array(numModes).keys());this.zoomValues_=this.getZoomValues_(selectedDisplay);this.set("selectedZoomPref_.value",this.getSelectedDisplayZoom_(selectedDisplay));this.updateDisplayModeStructures_(selectedDisplay);this.selectedDisplay=selectedDisplay;this.selectedTab_=this.displays.indexOf(this.selectedDisplay);const currentModeIndex=this.getSelectedModeIndex_(selectedDisplay);this.currentSelectedModeIndex_=currentModeIndex;this.set("selectedModePref_.value",this.currentSelectedModeIndex_);if(this.listAllDisplayModes_){this.currentSelectedParentModeIndex_=this.modeToParentModeMap_.get(currentModeIndex);this.refreshRateList_=this.parentModeToRefreshRateMap_.get(this.currentSelectedParentModeIndex_)}else{this.currentSelectedParentModeIndex_=currentModeIndex}this.set("selectedParentModePref_.value",this.currentSelectedParentModeIndex_);this.updateLogicalResolutionText_(this.selectedZoomPref_.value)}showDropDownResolutionSetting_(display){return!display.isInternal}showRefreshRateSetting_(display){return this.listAllDisplayModes_&&this.showDropDownResolutionSetting_(display)}showTouchCalibrationSetting_(display){return!display.isInternal&&loadTimeData.getBoolean("enableTouchCalibrationSetting")}showTouchRemappingExperience_(){return loadTimeData.getBoolean("enableTouchscreenMappingExperience")}showOverscanSetting_(display){return!display.isInternal}showBrightnessControls_(display){return isDisplayBrightnessControlInSettingsEnabled()&&display.isInternal}showAutoBrightnessToggle_(){return isDisplayBrightnessControlInSettingsEnabled()&&this.hasAmbientLightSensor_}showAmbientColorSetting(ambientColorAvailable,display){return ambientColorAvailable&&display&&display.isInternal}hasMultipleDisplays_(){return this.displays.length>1}showDisplaySelectMenu_(displays,selectedDisplay){if(selectedDisplay){return displays.length>1&&!selectedDisplay.isPrimary}return false}getDisplaySelectMenuIndex_(selectedDisplay,primaryDisplayId){if(selectedDisplay&&selectedDisplay.id===primaryDisplayId){return 0}return 1}getDisplayMirrorText_(displays,primaryDisplay){if(primaryDisplay){return this.i18n("displayMirror",primaryDisplay.name)}return this.i18n("displayMirror",displays[0].name)}showUnifiedDesktop(unifiedDesktopAvailable,unifiedDesktopMode,displays,isTabletMode){if(displays===undefined){return false}return unifiedDesktopMode||unifiedDesktopAvailable&&displays.length>1&&!this.isMirrored(displays)&&!isTabletMode}getUnifiedDesktopText_(unifiedDesktopMode){return this.i18n(unifiedDesktopMode?"displayUnifiedDesktopOn":"displayUnifiedDesktopOff")}showMirror(unifiedDesktopMode,displays){if(displays===undefined){return false}return this.isMirrored(displays)||!unifiedDesktopMode&&displays.length>1}isMirrored(displays){return displays!==undefined&&displays.length>0&&!!displays[0].mirroringSourceId}showExcludeInMirror_(unifiedDesktopMode,excludeDisplayInMirrorModeEnabled,allowExcludeDisplayInMirrorModePref,displays,selectedDisplay){if(!selectedDisplay){return false}if(this.isMirrored(displays)){return selectedDisplay.id===this.mirroringExcludedId_}if(!excludeDisplayInMirrorModeEnabled&&!allowExcludeDisplayInMirrorModePref){return false}if(displays.length<3){return false}return this.showMirror(unifiedDesktopMode,displays)}isSelected_(display,selectedDisplay){return display.id===selectedDisplay.id}enableSetResolution_(selectedDisplay){return selectedDisplay.modes.length>1}enableDisplayZoomSlider_(selectedDisplay){return selectedDisplay.availableDisplayZoomFactors.length>1}isBestMode_(selectedDisplay,mode){if(!selectedDisplay.isInternal){return mode.isNative}if(mode.heightInNativePixels===1080){return Math.abs(mode.uiScale-.8)<.001&&Math.abs(mode.deviceScaleFactor-1.25)<.001}return mode.uiScale===1}getResolutionText_(){assertExists(this.selectedDisplay);if(this.selectedDisplay.modes.length===0||this.currentSelectedModeIndex_===-1){return this.i18n("displayResolutionText",this.selectedDisplay.bounds.width.toString(),this.selectedDisplay.bounds.height.toString())}const mode=castExists(this.selectedDisplay.modes[this.selectedModePref_.value]);const widthStr=mode.widthInNativePixels.toString();const heightStr=mode.heightInNativePixels.toString();if(this.isBestMode_(this.selectedDisplay,mode)){return this.i18n("displayResolutionTextBest",widthStr,heightStr)}else if(mode.isNative){return this.i18n("displayResolutionTextNative",widthStr,heightStr)}return this.i18n("displayResolutionText",widthStr,heightStr)}updateLogicalResolutionText_(zoomFactor){assertExists(this.selectedDisplay);if(!this.selectedDisplay.isInternal&&!this.opsDisplayScaleFactorEnabled_){this.logicalResolutionText_="";return}const mode=this.selectedDisplay.modes[this.currentSelectedModeIndex_];const deviceScaleFactor=mode.deviceScaleFactor;const inverseZoomFactor=1/zoomFactor;let logicalResolutionStrId="displayZoomLogicalResolutionText";if(Math.abs(deviceScaleFactor-inverseZoomFactor)<.001){logicalResolutionStrId="displayZoomNativeLogicalResolutionNativeText"}else if(Math.abs(inverseZoomFactor-1)<.001){logicalResolutionStrId="displayZoomLogicalResolutionDefaultText"}let widthStr=Math.round(mode.widthInNativePixels/(deviceScaleFactor*zoomFactor)).toString();let heightStr=Math.round(mode.heightInNativePixels/(deviceScaleFactor*zoomFactor)).toString();if(this.shouldSwapLogicalResolutionText_()){const temp=widthStr;widthStr=heightStr;heightStr=temp}this.logicalResolutionText_=this.i18n(logicalResolutionStrId,widthStr,heightStr)}shouldSwapLogicalResolutionText_(){assertExists(this.selectedDisplay);const mode=this.selectedDisplay.modes[this.currentSelectedModeIndex_];const bounds=this.selectedDisplay.bounds;return bounds.width>bounds.height!==mode.widthInNativePixels>mode.heightInNativePixels}onDisplaySizeSliderDrag_(){if(!this.selectedDisplay){return}const slider=castExists(this.$.displaySizeSlider.shadowRoot.querySelector("#slider"));const zoomFactor=this.$.displaySizeSlider.ticks[slider.value].value;this.updateLogicalResolutionText_(zoomFactor)}onSelectDisplay_(e){const id=e.detail;for(let i=0;i<this.displays.length;++i){const display=this.displays[i];if(id===display.id){if(this.selectedDisplay!==display){this.setSelectedDisplay_(display)}return}}}onSelectDisplayTab_(){const{selected:selected}=castExists(this.shadowRoot.querySelector("cr-tabs"));if(this.selectedTab_!==selected){this.setSelectedDisplay_(this.displays[selected])}}onTouchCalibrationClick_(){getDisplayApi().showNativeTouchCalibration(this.selectedDisplay.id)}onTouchMappingClick_(){this.displaySettingsProvider.startNativeTouchscreenMappingExperience()}updatePrimaryDisplay_(e){if(!this.selectedDisplay){return}if(this.selectedDisplay.id===this.primaryDisplayId){return}if(!e.target.value){return}const properties={isPrimary:true};getDisplayApi().setDisplayProperties(this.selectedDisplay.id,properties).then((()=>this.setPropertiesCallback_()));this.displaySettingsProvider.recordChangingDisplaySettings(DisplaySettingsType.kPrimaryDisplay,createDisplayValue({}))}onDisplayBrightnessSliderChanged_(){if(!isDisplayBrightnessControlInSettingsEnabled()){return}const brightnessSliderValue=strictQuery("#brightnessSlider",this.shadowRoot,CrSliderElement).value;const newBrightness=Math.max(this.brightnessSliderMin_,Math.min(brightnessSliderValue,this.brightnessSliderMax_));this.displaySettingsProvider.setInternalDisplayScreenBrightness(newBrightness)}onAutoBrightnessToggleChange_(){if(!isDisplayBrightnessControlInSettingsEnabled()){return}const isAutoBrightnessToggleChecked=strictQuery("#autoBrightnessToggle",this.shadowRoot,CrToggleElement).checked;this.displaySettingsProvider.setInternalDisplayAmbientLightSensorEnabled(isAutoBrightnessToggleChecked)}onAutoBrightnessToggleRowClicked_(){const autoBrightnessToggle=strictQuery("#autoBrightnessToggle",this.shadowRoot,CrToggleElement);autoBrightnessToggle.checked=!autoBrightnessToggle.checked;this.onAutoBrightnessToggleChange_()}onSelectedParentModeChange_(newModeIndex){if(this.currentSelectedParentModeIndex_===newModeIndex){return}if(!this.hasNewParentModeBeenSet()){return}this.set("selectedModePref_.value",this.selectedParentModePref_.value)}hasNewParentModeBeenSet(){if(this.currentSelectedParentModeIndex_===-1){return false}return this.currentSelectedParentModeIndex_!==this.selectedParentModePref_.value}hasNewModeBeenSet(){if(this.currentSelectedModeIndex_===-1){return false}if(this.currentSelectedParentModeIndex_!==this.selectedParentModePref_.value){return true}return this.currentSelectedModeIndex_!==this.selectedModePref_.value}onSelectedModeChange_(newModeIndex){if(this.currentSelectedModeIndex_===newModeIndex){return}if(!this.hasNewModeBeenSet()){return}assertExists(this.selectedDisplay);const properties={displayMode:this.selectedDisplay.modes[this.selectedModePref_.value]};this.refreshRateList_=castExists(this.parentModeToRefreshRateMap_.get(this.selectedParentModePref_.value));getDisplayApi().setDisplayProperties(this.selectedDisplay.id,properties).then((()=>this.setPropertiesCallback_()));const currentMode=this.selectedDisplay.modes[this.currentSelectedModeIndex_];const newMode=this.selectedDisplay.modes[this.selectedModePref_.value];const displaySettingsType=currentMode.heightInNativePixels===newMode.heightInNativePixels&&currentMode.widthInNativePixels===newMode.widthInNativePixels?DisplaySettingsType.kRefreshRate:DisplaySettingsType.kResolution;this.displaySettingsProvider.recordChangingDisplaySettings(displaySettingsType,createDisplayValue({isInternalDisplay:this.selectedDisplay.isInternal,displayId:BigInt(this.selectedDisplay.id)}))}onSelectedZoomChange_(){if(this.currentSelectedModeIndex_===-1||!this.selectedDisplay){return}const properties={displayZoomFactor:this.selectedZoomPref_.value};getDisplayApi().setDisplayProperties(this.selectedDisplay.id,properties).then((()=>this.setPropertiesCallback_()));this.displaySettingsProvider.recordChangingDisplaySettings(DisplaySettingsType.kScaling,createDisplayValue({isInternalDisplay:this.selectedDisplay.isInternal,displayId:BigInt(this.selectedDisplay.id)}))}showAutoRotateOption_(selectedDisplay){return selectedDisplay.isAutoRotationAllowed}onOrientationChange_(event){const select=cast(event.target,HTMLSelectElement);const value=parseInt(select.value,10);assertExists(this.selectedDisplay);assert(value!==-1||this.selectedDisplay.isAutoRotationAllowed);const properties={rotation:value};getDisplayApi().setDisplayProperties(this.selectedDisplay.id,properties).then((()=>this.setPropertiesCallback_()));let orientation=DisplaySettingsOrientationOption.k0Degree;if(value===-1){orientation=DisplaySettingsOrientationOption.kAuto}else if(value===90){orientation=DisplaySettingsOrientationOption.k90Degree}else if(value===180){orientation=DisplaySettingsOrientationOption.k180Degree}else if(value===270){orientation=DisplaySettingsOrientationOption.k270Degree}this.displaySettingsProvider.recordChangingDisplaySettings(DisplaySettingsType.kOrientation,createDisplayValue({isInternalDisplay:this.selectedDisplay.isInternal,orientation:orientation}))}onMirroredClick_(event){event.currentTarget.blur();const mirrorModeInfo={mode:this.isMirrored(this.displays)?MirrorMode.OFF:this.mirroringExcludedId_===this.invalidDisplayId_?MirrorMode.NORMAL:MirrorMode.MIXED};if(mirrorModeInfo.mode===MirrorMode.MIXED){const mirroredDisplay=this.displayIds.split(",").filter((display=>display!==this.mirroringExcludedId_));mirrorModeInfo.mirroringSourceId=mirroredDisplay[0];mirrorModeInfo.mirroringDestinationIds=mirroredDisplay.slice(1)}this.setMirrorMode(mirrorModeInfo)}shouldExcludeInMirror_(selectedDisplay){return this.mirroringExcludedId_===selectedDisplay.id}onExcludeInMirrorClick_(event){event.currentTarget.blur();assertExists(this.selectedDisplay);if(this.mirroringExcludedId_===this.selectedDisplay.id){this.mirroringExcludedId_=this.invalidDisplayId_}else{this.mirroringExcludedId_=this.selectedDisplay.id}if(this.isMirrored(this.displays)){const mirrorModeInfo={mode:MirrorMode.NORMAL};this.setMirrorMode(mirrorModeInfo)}}setMirrorMode(mirrorModeInfo){getDisplayApi().setMirrorMode(mirrorModeInfo).then((()=>{const error=chrome.runtime.lastError;if(error){console.error("setMirrorMode Error: "+error.message)}}));this.displaySettingsProvider.recordChangingDisplaySettings(DisplaySettingsType.kMirrorMode,createDisplayValue({mirrorModeStatus:mirrorModeInfo.mode!==MirrorMode.OFF}))}onUnifiedDesktopClick_(){const properties={isUnified:!this.unifiedDesktopMode_};getDisplayApi().setDisplayProperties(this.primaryDisplayId,properties).then((()=>this.setPropertiesCallback_()));const unified=properties.isUnified===undefined?null:properties.isUnified;this.displaySettingsProvider.recordChangingDisplaySettings(DisplaySettingsType.kUnifiedMode,createDisplayValue({unifiedModeStatus:unified}))}onOverscanClick_(e){e.preventDefault();assert(this.selectedDisplay);this.overscanDisplayId=this.selectedDisplay.id;this.showOverscanDialog_(true);this.displaySettingsProvider.recordChangingDisplaySettings(DisplaySettingsType.kOverscan,createDisplayValue({isInternalDisplay:this.selectedDisplay.isInternal}))}onCloseOverscanDialog_(){focusWithoutInk$1(castExists(this.shadowRoot.getElementById("overscan")))}updateDisplayInfo_(){let displayIds="";let primaryDisplay=undefined;let selectedDisplay=undefined;for(let i=0;i<this.displays.length;++i){const display=this.displays[i];if(displayIds){displayIds+=","}displayIds+=display.id;if(display.isPrimary&&!primaryDisplay){primaryDisplay=display}if(this.selectedDisplay&&display.id===this.selectedDisplay.id){selectedDisplay=display}}this.displayIds=displayIds;this.primaryDisplay=primaryDisplay;this.primaryDisplayId=primaryDisplay&&primaryDisplay.id||"";selectedDisplay=selectedDisplay||primaryDisplay||this.displays&&this.displays[0];this.setSelectedDisplay_(selectedDisplay);this.unifiedDesktopMode_=!!primaryDisplay&&primaryDisplay.isUnified;if(!this.pendingSettingId_){return}this.showDeepLink(this.pendingSettingId_).then((result=>{if(result.deepLinkShown){this.pendingSettingId_=null}}))}setPropertiesCallback_(){if(chrome.runtime.lastError){console.error("setDisplayProperties Error: "+chrome.runtime.lastError.message)}}shouldShowArrangementSection(){if(!this.displays){return false}return this.hasMultipleDisplays_()||this.isMirrored(this.displays)}onDisplaysChanged_(){flush();const displayLayout=this.shadowRoot.querySelector("display-layout");if(displayLayout){displayLayout.updateDisplays(this.displays,this.layouts,this.mirroringDestinationIds)}}toggleDisplayPerformanceEnabled_(){this.isDisplayPerformanceEnabled_=!this.isDisplayPerformanceEnabled_;this.displaySettingsProvider.setShinyPerformance(this.isDisplayPerformanceEnabled_)}getInvalidDisplayId(){return this.invalidDisplayId_}getRefreshRateList(){return this.refreshRateList_}getModeToParentModeMap(){return this.modeToParentModeMap_}getParentModeToRefreshRateMap(){return this.parentModeToRefreshRateMap_}getSelectedZoomPref(){return this.selectedZoomPref_}}customElements.define(SettingsDisplayElement.is,SettingsDisplayElement);function getTemplate$30(){return html`<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">#appIcon{order:-1;padding-inline-end:12px;padding-left:0px}#openApp{padding-inline-start:0px}</style>
<cr-link-row
    id="openApp"
    class="hr"
    on-click="onCompanionAppRowClick"
    label="[[openAppLabel]]"
    external>
    <img
        id="appIcon"
        is="cr-auto-img"
        width="32"
        height="32"
        alt=""
        auto-src="[[appInfo.iconUrl]]">
</cr-link-row>
<!--_html_template_end_-->`}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PerDeviceAppInstalledRowElementBase=I18nMixin(PolymerElement);class PerDeviceAppInstalledRowElement extends PerDeviceAppInstalledRowElementBase{constructor(){super(...arguments);this.inputDeviceSettingsProvider=getInputDeviceSettingsProvider()}static get is(){return"per-device-app-installed-row"}static get template(){return getTemplate$30()}static get properties(){return{appInfo:{type:Object},openAppLabel:{type:String,computed:"computeOpenAppLabel(appInfo.*)"}}}computeOpenAppLabel(){return this.i18n("openAppLabel",this.appInfo.appName)}onCompanionAppRowClick(){this.inputDeviceSettingsProvider.launchCompanionApp(this.appInfo.packageId)}}customElements.define(PerDeviceAppInstalledRowElement.is,PerDeviceAppInstalledRowElement);function getTemplate$2$(){return html`<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">.app-info-container{align-items:center;display:flex;justify-content:space-between;padding:var(--cr-section-vertical-padding) var(--cr-section-padding)}.app-details{align-items:center;box-sizing:border-box;display:flex;gap:12px}
</style>
<div class="app-info-container bottom-divider">
  <div class="app-info">
    <div class="app-details" aria-hidden="true">
      <img
          id="app-icon"
          is="cr-auto-img"
          alt=""
          width="32"
          height="32"
          auto-src="[[appInfo.iconUrl]]">
      <span id="appName">[[installAppLabel]]</span>
    </div>
  </div>
  <cr-button
      role="button"
      id="installButton"
      on-click="onInstallCompanionAppButtonClicked"
      aria-labelledby="appName">
    $i18n{installAppButton}
  </cr-button>
</div>
<!--_html_template_end_-->`}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PerDeviceInstallRowElementBase=I18nMixin(PolymerElement);class PerDeviceInstallRowElement extends PerDeviceInstallRowElementBase{static get is(){return"per-device-install-row"}static get template(){return getTemplate$2$()}static get properties(){return{appInfo:{type:Object},installAppLabel:{type:String,value:"",computed:"computeInstallAppLabel(appInfo.*)"}}}onInstallCompanionAppButtonClicked(){window.open(this.appInfo.actionLink)}computeInstallAppLabel(){return this.i18n("installAppLabel",this.appInfo.appName)}}customElements.define(PerDeviceInstallRowElement.is,PerDeviceInstallRowElement);function getTemplate$2_(){return html`<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">.device-details{align-items:flex-start;display:flex;flex-direction:column}.device-info{align-items:center;box-sizing:border-box;display:flex;gap:16px;padding-bottom:var(--cr-section-vertical-padding);padding-inline-start:18px;padding-top:var(--cr-section-vertical-padding)}.device-image{border-radius:20px;height:32px;width:32px}#deviceIcon{--iron-icon-fill-color:var(--cros-sys-primary)}.icon-container{background-color:var(--cros-sys-primary_container);border-radius:50%;height:20px;padding:8px;width:20px}.device-details{display:flex;flex-direction:column}</style>
<div role="region" aria-label="[[getAriaLabel(name, batteryInfo.*)]]">
  <h2 aria-hidden="true" class="subsection-header bottom-divider"
      id="deviceName">
    [[name]]
  </h2>
  <template is="dom-if" if="[[isWelcomeExperienceEnabled]]">
    <div aria-hidden="true" class="device-info bottom-divider">
      <template is="dom-if" if="[[shouldShowPlaceholder(deviceDisplayState)]]">
        <div class="icon-container"></div>
      </template>
      <template is="dom-if"
          if="[[shouldShowDeviceIcon(deviceDisplayState)]]" restamp>
        <iron-icon icon="[[icon]]" class="icon-container" id="deviceIcon">
        </iron-icon>
      </template>
      <img
          class="device-image"
          src="[[deviceImageDataUrl]]"
          hidden="[[!deviceImageDataUrl]]"
          alt="">
      <div class="device-details">
        <div class="device-info-header" id="deviceInfoName">
          [[name]]
        </div>
        <template is="dom-if" if="[[showBatteryInfo(batteryInfo.*)]]">
          <bluetooth-battery-icon-percentage
              id="batteryIcon"
              device="[[bluetoothDevice]]"
              battery-type="[[getDefaultBatteryType()]]">
          </bluetooth-battery-icon-percentage>
        </template>
      </div>
    </div>
  </template>
</div><!--_html_template_end_-->`}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var DeviceDisplayState;(function(DeviceDisplayState){DeviceDisplayState[DeviceDisplayState["FETCHING_IMAGE"]=0]="FETCHING_IMAGE";DeviceDisplayState[DeviceDisplayState["IMAGE_AVAILABLE"]=1]="IMAGE_AVAILABLE";DeviceDisplayState[DeviceDisplayState["IMAGE_UNAVAILABLE"]=2]="IMAGE_UNAVAILABLE"})(DeviceDisplayState||(DeviceDisplayState={}));const PerDeviceSubsectionHeaderElementBase=I18nMixin(PolymerElement);class PerDeviceSubsectionHeaderElement extends PerDeviceSubsectionHeaderElementBase{constructor(){super(...arguments);this.deviceImageDataUrl=null;this.inputDeviceSettingsProvider=getInputDeviceSettingsProvider()}static get is(){return"per-device-subsection-header"}static get template(){return getTemplate$2_()}static get properties(){return{isWelcomeExperienceEnabled:{type:Boolean,value(){return loadTimeData.getBoolean("enableWelcomeExperience")},readOnly:true},deviceImageDataUrl:{type:String,value:""},batteryInfo:{type:Object},bluetoothDevice:{type:Object,computed:"computeBluetoothDeviceProperties(batteryInfo.*)"},deviceKey:{type:String},name:{type:String},icon:{type:String},deviceDisplayState:{type:Number,value:DeviceDisplayState.FETCHING_IMAGE}}}static get observers(){return["handleDeviceKeyChange(deviceKey)"]}showBatteryInfo(){return!!this.batteryInfo}getDefaultBatteryType(){return BatteryType.DEFAULT}computeBluetoothDeviceProperties(){if(!this.batteryInfo){return null}return createBluetoothDeviceProperties(this.deviceKey,this.name,this?.batteryInfo.batteryPercentage)}async handleDeviceKeyChange(){if(this.isWelcomeExperienceEnabled){this.deviceDisplayState=DeviceDisplayState.FETCHING_IMAGE;this.deviceImageDataUrl=(await this.inputDeviceSettingsProvider.getDeviceIconImage(this.deviceKey))?.dataUrl;this.deviceDisplayState=this.deviceImageDataUrl?DeviceDisplayState.IMAGE_AVAILABLE:DeviceDisplayState.IMAGE_UNAVAILABLE}}shouldShowPlaceholder(){return this.deviceDisplayState===DeviceDisplayState.FETCHING_IMAGE}shouldShowDeviceIcon(){return this.deviceDisplayState===DeviceDisplayState.IMAGE_UNAVAILABLE}getAriaLabel(){let label=`${this.i18n("deviceNameLabel")} ${this.name}`;if(this.batteryInfo?.batteryPercentage){label+=` ${this.i18n("deviceBatteryLabel",this?.batteryInfo.batteryPercentage)}`}return label}}customElements.define(PerDeviceSubsectionHeaderElement.is,PerDeviceSubsectionHeaderElement);function getTemplate$2Z(){return html`<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">#header{display:flex;height:24px;padding:12px 0}.subsection{margin-bottom:0;margin-top:8px}#description{color:var(--cr-secondary-text-color);margin-inline-start:20px}</style>
<template is="dom-repeat" items="[[graphicsTablets]]"
    as="graphicsTablet" index-as="index" restamp>
    <div class="device" data-evdev-id$="[[graphicsTablet.id]]">
      <per-device-subsection-header
          device-key="[[graphicsTablet.deviceKey]]"
          name="[[graphicsTablet.name]]"
          battery-info="[[graphicsTablet.batteryInfo]]"
          icon="os-settings:device-tablet">
      </per-device-subsection-header>
      <div class="subsection">
        <template is="dom-if"
            if="[[showInstallAppRow(graphicsTablet.appInfo)]]">
          <per-device-install-row app-info="[[graphicsTablet.appInfo]]">
          </per-device-install-row>
        </template>
        <template is="dom-if"
            if="[[showCustomizeTabletButtonsRow(graphicsTablet)]]">
          <cr-link-row id="customizeTabletButtons"
              class="bottom-divider" on-click="onCustomizeTabletButtonsClick"
              aria-describedby="graphicsTabletName"
              label="$i18n{customizeTabletButtonsLabel}">
          </cr-link-row>
        </template>
        <cr-link-row id="customizePenButtons"
            class="hr bottom-divider" on-click="onCustomizePenButtonsClick"
            aria-describedby="graphicsTabletName"
            label="$i18n{customizePenButtonsLabel}">
        </cr-link-row>
      </div>
    </div>
    <template is="dom-if"
        if="[[isCompanionAppInstalled(graphicsTablet.appInfo)]]">
      <per-device-app-installed-row app-info="[[graphicsTablet.appInfo]]">
      </per-device-app-installed-row>
    </template>
</template>
<!--_html_template_end_-->`}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsGraphicsTabletSubpageElementBase=RouteObserverMixin(I18nMixin(PolymerElement));class SettingsGraphicsTabletSubpageElement extends SettingsGraphicsTabletSubpageElementBase{constructor(){super(...arguments);this.inputDeviceSettingsProvider=getInputDeviceSettingsProvider()}static get is(){return"settings-graphics-tablet-subpage"}static get template(){return getTemplate$2Z()}static get properties(){return{prefs:{type:Object,notify:true},graphicsTablets:{type:Array,observer:"onGraphicsTabletListUpdated"},currentPenChanged:{type:Boolean},currentTabletChanged:{type:Boolean},deviceId:{type:Number}}}currentRouteChanged(route){if(route===routes.CUSTOMIZE_PEN_BUTTONS||route===routes.CUSTOMIZE_TABLET_BUTTONS){return}if(route!==routes.GRAPHICS_TABLET){this.deviceId=-1;this.currentPenChanged=false;this.currentTabletChanged=false;return}if(!Router.getInstance().lastRouteChangeWasPopstate()){return}else{const graphicsTablets=this.shadowRoot.querySelectorAll(".device");for(const graphicsTablet of graphicsTablets){if(Number(graphicsTablet.getAttribute("data-evdev-id"))===this.deviceId){if(this.currentPenChanged){graphicsTablet.querySelector("#customizePenButtons").focus()}else if(this.currentTabletChanged){graphicsTablet.querySelector("#customizeTabletButtons").focus()}}}}this.deviceId=-1;this.currentPenChanged=false;this.currentTabletChanged=false}onGraphicsTabletListUpdated(newGraphicsTabletList,oldGraphicsTabletList){if(!oldGraphicsTabletList){return}const{msgId:msgId,deviceNames:deviceNames}=getDeviceStateChangesToAnnounce(newGraphicsTabletList,oldGraphicsTabletList);for(const deviceName of deviceNames){getInstance().announce(this.i18n(msgId,deviceName))}}onCustomizeTabletButtonsClick(e){Router.getInstance().navigateTo(routes.CUSTOMIZE_TABLET_BUTTONS,this.getSelectedGraphicsTabletUrl(e),true);this.currentTabletChanged=true}showInstallAppRow(appInfo){return appInfo?.state===CompanionAppState$1.kAvailable}onCustomizePenButtonsClick(e){Router.getInstance().navigateTo(routes.CUSTOMIZE_PEN_BUTTONS,this.getSelectedGraphicsTabletUrl(e),true);this.currentPenChanged=true}showCustomizeTabletButtonsRow(graphicsTablet){return graphicsTablet.graphicsTabletButtonConfig===GraphicsTabletButtonConfig$1.kNoConfig||graphicsTablet.settings.tabletButtonRemappings.length!==0}getSelectedGraphicsTabletUrl(e){const customizeTabletButton=cast(e.target,CrLinkRowElement);const closestTablet=castExists(customizeTabletButton.closest(".device"));const graphicsTabletId=closestTablet.getAttribute("data-evdev-id");this.deviceId=Number(graphicsTabletId);return new URLSearchParams({graphicsTabletId:encodeURIComponent(graphicsTabletId)})}isCompanionAppInstalled(appInfo){return appInfo?.state===CompanionAppState$1.kInstalled}}customElements.define(SettingsGraphicsTabletSubpageElement.is,SettingsGraphicsTabletSubpageElement);function getTemplate$2Y(){return html`<!--_html_template_start_--><style include="settings-shared">h2{padding-inline-start:var(--cr-section-padding)}.subsection{padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-indent-padding)}.subsection>cr-link-row,.subsection>settings-toggle-button{padding-inline-end:0;padding-inline-start:0}</style>
<template is="dom-if" if="[[hasLauncherKey_]]">
  <div class="settings-box first" id="launcherKey">
    <div class="start" aria-hidden="true">$i18n{keyboardKeySearch}</div>
    <settings-dropdown-menu label="$i18n{keyboardKeySearch}"
        pref="{{prefs.settings.language.xkb_remap_search_key_to}}"
        menu-options="[[keyMapTargets_]]">
    </settings-dropdown-menu>
  </div>
</template>
<div class="settings-box">
  <div class="start" aria-hidden="true">$i18n{keyboardKeyCtrl}</div>
  <settings-dropdown-menu label="$i18n{keyboardKeyCtrl}"
      pref="{{prefs.settings.language.xkb_remap_control_key_to}}"
      menu-options="[[keyMapTargets_]]">
  </settings-dropdown-menu>
</div>
<div class="settings-box">
  <div class="start" aria-hidden="true">$i18n{keyboardKeyAlt}</div>
  <settings-dropdown-menu label="$i18n{keyboardKeyAlt}"
      pref="{{prefs.settings.language.xkb_remap_alt_key_to}}"
      menu-options="[[keyMapTargets_]]">
  </settings-dropdown-menu>
</div>
<div class="settings-box">
  <div class="start" aria-hidden="true">$i18n{keyboardKeyEscape}</div>
  <settings-dropdown-menu label="$i18n{keyboardKeyEscape}"
      pref="{{prefs.settings.language.remap_escape_key_to}}"
      menu-options="[[keyMapTargets_]]">
  </settings-dropdown-menu>
</div>
<div class="settings-box">
  <div class="start" aria-hidden="true">$i18n{keyboardKeyBackspace}</div>
  <settings-dropdown-menu label="$i18n{keyboardKeyBackspace}"
      pref="{{prefs.settings.language.remap_backspace_key_to}}"
      menu-options="[[keyMapTargets_]]">
  </settings-dropdown-menu>
</div>
<template is="dom-if" if="[[hasAssistantKey_]]">
  <div class="settings-box" id="assistantKey">
    <div class="start" aria-hidden="true">$i18n{keyboardKeyAssistant}</div>
    <settings-dropdown-menu label="$i18n{keyboardKeyAssistant}"
        pref="{{prefs.settings.language.xkb_remap_assistant_key_to}}"
        menu-options="[[keyMapTargets_]]">
    </settings-dropdown-menu>
  </div>
</template>
<template is="dom-if" if="[[showCapsLock_]]">
  <div class="settings-box" id="capsLockKey">
    <div class="start" aria-hidden="true">$i18n{keyboardKeyCapsLock}</div>
    <settings-dropdown-menu label="$i18n{keyboardKeyCapsLock}"
        pref="{{prefs.settings.language.remap_caps_lock_key_to}}"
        menu-options="[[keyMapTargets_]]">
    </settings-dropdown-menu>
  </div>
</template>
<template is="dom-if" if="[[showExternalMetaKey_]]">
  <div class="settings-box" id="externalMetaKey">
    <div class="start" aria-hidden="true">
      [[getExternalMetaKeyLabel_(hasLauncherKey_)]]
    </div>
    <settings-dropdown-menu
        label="[[getExternalMetaKeyLabel_(hasLauncherKey_)]]"
        pref="{{prefs.settings.language.remap_external_meta_key_to}}"
        menu-options="[[keyMapTargets_]]">
    </settings-dropdown-menu>
  </div>
</template>
<template is="dom-if" if="[[showAppleCommandKey_]]">
  <div class="settings-box" id="externalCommandKey">
    <div class="start" aria-hidden="true">
      [[getExternalCommandKeyLabel_(hasLauncherKey_)]]
    </div>
    <settings-dropdown-menu
        label="[[getExternalCommandKeyLabel_(hasLauncherKey_)]]"
        pref="{{prefs.settings.language.remap_external_command_key_to}}"
        menu-options="[[keyMapTargets_]]">
    </settings-dropdown-menu>
  </div>
</template>
<settings-toggle-button
    class="hr"
    pref="{{prefs.settings.language.send_function_keys}}"
    label="$i18n{keyboardSendFunctionKeys}"
    sub-label="$i18n{keyboardSendFunctionKeysDescription}"
    deep-link-focus-id$="[[Setting.kKeyboardFunctionKeys]]">
</settings-toggle-button>
<h2>$i18n{keyboardHoldingKeys}</h2>
<div class="subsection">
  <settings-toggle-button
      class="hr continuation"
      pref="{{prefs.settings.language.physical_keyboard_enable_diacritics_on_longpress}}"
      label="$i18n{keyboardAccentMarks}"
      sub-label="$i18n{keyboardAccentMarksSubLabel}"
      deep-link-focus-id$="[[Setting.kShowDiacritic]]">
  </settings-toggle-button>
  <settings-toggle-button
      class="hr continuation"
      pref="{{prefs.settings.language.xkb_auto_repeat_enabled_r2}}"
      label="$i18n{keyboardEnableAutoRepeat}"
      sub-label="$i18n{keyboardEnableAutoRepeatSubLabel}"
      deep-link-focus-id$="[[Setting.kKeyboardAutoRepeat]]">
  </settings-toggle-button>
  <iron-collapse
      opened="[[prefs.settings.language.xkb_auto_repeat_enabled_r2.value]]">
    <div class="settings-box continuation embedded">
      <div class="start" id="repeatDelayLabel" aria-hidden="true">
        $i18n{keyRepeatDelay}
      </div>
      <settings-slider id="delaySlider"
          pref="{{prefs.settings.language.xkb_auto_repeat_delay_r2}}"
          ticks="[[autoRepeatDelays_]]"
          disabled="[[
              !prefs.settings.language.xkb_auto_repeat_enabled_r2.value]]"
          label-aria="$i18n{keyRepeatDelay}"
          label-min="$i18n{keyRepeatDelayLong}"
          label-max="$i18n{keyRepeatDelayShort}">
      </settings-slider>
    </div>
    <div class="settings-box continuation embedded">
      <div class="start" id="repeatRateLabel" aria-hidden="true">
        $i18n{keyRepeatRate}
      </div>
      <settings-slider id="repeatRateSlider"
          pref="{{
              prefs.settings.language.xkb_auto_repeat_interval_r2}}"
          ticks="[[autoRepeatIntervals_]]"
          disabled="[[
              !prefs.settings.language.xkb_auto_repeat_enabled_r2.value]]"
          label-aria="$i18n{keyRepeatRate}"
          label-min="$i18n{keyRepeatRateSlow}"
          label-max="$i18n{keyRepeatRateFast}">
      </settings-slider>
    </div>
  </iron-collapse>
</div>
<cr-link-row id="shortcutCustomizationApp" class="hr"
    on-click="onShowShortcutCustomizationAppClick_"
    label="$i18n{showShortcutCustomizationApp}"
    external
    deep-link-focus-id$="[[Setting.kKeyboardShortcuts]]">
</cr-link-row>
<cr-link-row id="inputRow"
    class="hr" on-click="onShowInputSettingsClick_"
    label="$i18n{keyboardShowInputSettings}"
    role-description="$i18n{subpageArrowRoleDescription}">
</cr-link-row>
<cr-link-row id="a11yKeyboardRow"
    class="hr" on-click="onShowA11yKeyboardSettingsClick_"
    label="$i18n{keyboardShowA11yKeyboardSettings}"
    role-description="$i18n{subpageArrowRoleDescription}">
</cr-link-row>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var ModifierKey$1;(function(ModifierKey){ModifierKey[ModifierKey["SEARCH_KEY"]=0]="SEARCH_KEY";ModifierKey[ModifierKey["CONTROL_KEY"]=1]="CONTROL_KEY";ModifierKey[ModifierKey["ALT_KEY"]=2]="ALT_KEY";ModifierKey[ModifierKey["VOID_KEY"]=3]="VOID_KEY";ModifierKey[ModifierKey["CAPS_LOCK_KEY"]=4]="CAPS_LOCK_KEY";ModifierKey[ModifierKey["ESCAPE_KEY"]=5]="ESCAPE_KEY";ModifierKey[ModifierKey["BACKSPACE_KEY"]=6]="BACKSPACE_KEY";ModifierKey[ModifierKey["ASSISTANT_KEY"]=7]="ASSISTANT_KEY"})(ModifierKey$1||(ModifierKey$1={}));const SettingsKeyboardElementBase=DeepLinkingMixin(RouteOriginMixin(WebUiListenerMixin(PolymerElement)));class SettingsKeyboardElement extends SettingsKeyboardElementBase{static get is(){return"settings-keyboard"}static get template(){return getTemplate$2Y()}static get properties(){return{prefs:{type:Object,notify:true},showCapsLock_:Boolean,hasLauncherKey_:Boolean,hasAssistantKey_:Boolean,showExternalMetaKey_:Boolean,showAppleCommandKey_:Boolean,keyMapTargets_:Object,autoRepeatDelays_:{type:Array,value:[2e3,1500,1e3,500,300,200,150],readOnly:true},autoRepeatIntervals_:{type:Array,value:[2e3,1e3,500,300,200,100,50,30,20],readOnly:true}}}constructor(){super();this.supportedSettingIds=new Set([Setting.kKeyboardFunctionKeys,Setting.kKeyboardAutoRepeat,Setting.kKeyboardShortcuts,Setting.kShowDiacritic]);this.route=routes.KEYBOARD;this.browserProxy_=DevicePageBrowserProxyImpl.getInstance()}ready(){super.ready();this.addWebUiListener("show-keys-changed",this.onShowKeysChange_.bind(this));this.browserProxy_.initializeKeyboard();this.setUpKeyMapTargets_();this.addFocusConfig(routes.OS_LANGUAGES_INPUT,"#inputRow")}currentRouteChanged(newRoute,oldRoute){super.currentRouteChanged(newRoute,oldRoute);if(newRoute!==this.route){return}if(Router.getInstance().currentRoute===this.route){setTimeout((()=>{Router.getInstance().setCurrentRoute(routes.PER_DEVICE_KEYBOARD,new URLSearchParams,false)}))}this.attemptDeepLink()}setUpKeyMapTargets_(){this.keyMapTargets_=[{value:ModifierKey$1.SEARCH_KEY,name:loadTimeData.getString("keyboardKeySearch")},{value:ModifierKey$1.CONTROL_KEY,name:loadTimeData.getString("keyboardKeyCtrl")},{value:ModifierKey$1.ALT_KEY,name:loadTimeData.getString("keyboardKeyAlt")},{value:ModifierKey$1.CAPS_LOCK_KEY,name:loadTimeData.getString("keyboardKeyCapsLock")},{value:ModifierKey$1.ESCAPE_KEY,name:loadTimeData.getString("keyboardKeyEscape")},{value:ModifierKey$1.BACKSPACE_KEY,name:loadTimeData.getString("keyboardKeyBackspace")},{value:ModifierKey$1.ASSISTANT_KEY,name:loadTimeData.getString("keyboardKeyAssistant")},{value:ModifierKey$1.VOID_KEY,name:loadTimeData.getString("keyboardKeyDisabled")}]}onShowKeysChange_(keyboardParams){this.hasLauncherKey_=keyboardParams["hasLauncherKey"];this.hasAssistantKey_=keyboardParams["hasAssistantKey"];this.showCapsLock_=keyboardParams["showCapsLock"];this.showExternalMetaKey_=keyboardParams["showExternalMetaKey"];this.showAppleCommandKey_=keyboardParams["showAppleCommandKey"]}onShowShortcutCustomizationAppClick_(){this.browserProxy_.showShortcutCustomizationApp()}onShowInputSettingsClick_(){Router.getInstance().navigateTo(routes.OS_LANGUAGES_INPUT,undefined,true)}onShowA11yKeyboardSettingsClick_(){Router.getInstance().navigateTo(routes.A11Y_KEYBOARD_AND_TEXT_INPUT,undefined,true)}getExternalMetaKeyLabel_(hasLauncherKey){return loadTimeData.getString(hasLauncherKey?"keyboardKeyExternalMeta":"keyboardKeyMeta")}getExternalCommandKeyLabel_(hasLauncherKey){return loadTimeData.getString(hasLauncherKey?"keyboardKeyExternalCommand":"keyboardKeyCommand")}}customElements.define(SettingsKeyboardElement.is,SettingsKeyboardElement);
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class PluralStringProxyImpl{getPluralString(messageName,itemCount){return sendWithPromise("getPluralString",messageName,itemCount)}getPluralStringTupleWithComma(messageName1,itemCount1,messageName2,itemCount2){return sendWithPromise("getPluralStringTupleWithComma",messageName1,itemCount1,messageName2,itemCount2)}getPluralStringTupleWithPeriods(messageName1,itemCount1,messageName2,itemCount2){return sendWithPromise("getPluralStringTupleWithPeriods",messageName1,itemCount1,messageName2,itemCount2)}static getInstance(){return instance$a||(instance$a=new PluralStringProxyImpl)}static setInstance(obj){instance$a=obj}}let instance$a=null;function getTemplate$2X(){return html`<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">.settings-box{border-top:none;border-bottom:var(--cr-separator-line)}#keyboardAutoBrightnessToggle,#rgbKeyboardControlLink{border-bottom:var(--cr-separator-line)}</style>
<template is="dom-if"
    if="[[showKeyboardSettings(keyboard, isLidOpen)]]" restamp>
  <per-device-subsection-header
      id="subsectionHeader"
      device-key="[[keyboard.deviceKey]]"
      name="[[getKeyboardName(keyboard.name)]]"
      battery-info="[[keyboard.batteryInfo]]"
      icon="os-settings:device-keyboard">
  </per-device-subsection-header>
  <div class="subsection">
    <template is="dom-if" if="[[showInstallAppRow(keyboard.appInfo)]]">
      <per-device-install-row app-info="[[keyboard.appInfo]]">
      </per-device-install-row>
    </template>
    <template is="dom-if" if="[[!isChromeOsKeyboard(keyboard)]]" restamp>
      <settings-toggle-button
          inverted="true"
          id="externalTopRowAreFunctionKeysButton"
          pref="{{topRowAreFunctionKeysPref}}"
          aria-describedby="keyboardName"
          label="$i18n{keyboardSendInvertedFunctionKeys}"
          sub-label="$i18n{keyboardSendInvertedFunctionKeysDescription}"
          deep-link-focus-id$="[[Setting.kKeyboardFunctionKeys]]">
      </settings-toggle-button>
      <settings-toggle-button
          inverted="true"
          class="hr" id="blockMetaFunctionKeyRewritesButton"
          pref="{{blockMetaFunctionKeyRewritesPref}}"
          aria-describedby="keyboardName"
          label="$i18n{keyboardBlockMetaFunctionKeyRewrites}"
          sub-label="$i18n{keyboardBlockMetaFunctionKeyRewritesDescription}"
          deep-link-focus-id$="[[Setting.kKeyboardBlockMetaFkeyRewrites]]">
      </settings-toggle-button>
    </template>
    <template is="dom-if" if="[[isChromeOsKeyboard(keyboard)]]" restamp>
      <template is="dom-if" if="[[hasKeyboardBacklight]]">
        <settings-toggle-button id="keyboardAutoBrightnessToggle"
            pref="{{keyboardAutoBrightnessPref}}"
            on-settings-boolean-control-change=
                "onKeyboardAutoBrightnessToggleChanged"
            label="$i18n{keyboardEnableAutoBrightnessLabel}"
            sub-label="$i18n{keyboardEnableAutoBrightnessSubLabel}"
            hidden="[[!hasAmbientLightSensor]]">
        </settings-toggle-button>
        <div class="settings-box">
          <div class="start" id="keyboardBrightnessPercentLabel"
              aria-hidden="true">
            $i18n{keyboardBrightnessLabel}
          </div>
          <settings-slider id="keyboardBrightnessSlider"
              pref="{{keyboardBrightnessPercentPref}}"
              label-aria="$i18n{keyboardBrightnessLabel}"
              on-pointerup="onPointerup"
              on-keyup="onKeyup"
              on-cr-slider-value-changed="onKeyboardBrightnessSliderChanged">
          </settings-slider>
        </div>
      </template>
      <cr-link-row id="rgbKeyboardControlLink" label="$i18n{keyboardColors}"
        hidden="[[!isRgbKeyboardSupported]]" on-click="openPersonalizationHub"
        external>
      </cr-link-row>
      <settings-toggle-button
          id="internalTopRowAreFunctionKeysButton"
          pref="{{topRowAreFunctionKeysPref}}"
          aria-describedby="keyboardName"
          label="$i18n{keyboardSendFunctionKeys}"
          sub-label="[[showSendFunctionKeyDescription(keyboard)]]"
          deep-link-focus-id$="[[Setting.kKeyboardFunctionKeys]]">
      </settings-toggle-button>
    </template>
    <cr-link-row id="remapKeyboardKeys"
        class$="[[getRemapKeyboardKeysClass(keyboard)]]"
        on-click="onRemapKeyboardKeysClick"
        aria-describedby="keyboardName"
        label="$i18n{remapKeyboardKeysRowLabel}"
        sub-label="[[remapKeyboardKeysSublabel]]"
        deep-link-focus-id$="[[Setting.kKeyboardRemapKeys]]">
    </cr-link-row>
    <template is="dom-if" if="[[isCompanionAppInstalled(keyboard.appInfo)]]">
      <per-device-app-installed-row app-info="[[keyboard.appInfo]]">
      </per-device-app-installed-row>
    </template>
  </div>
</template>
<!--_html_template_end_-->`}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsPerDeviceKeyboardSubsectionElementBase=DeepLinkingMixin(I18nMixin(RouteObserverMixin(PolymerElement)));const MIN_VISIBLE_PERCENT=5;class SettingsPerDeviceKeyboardSubsectionElement extends SettingsPerDeviceKeyboardSubsectionElementBase{constructor(){super(...arguments);this.supportedSettingIds=new Set([Setting.kKeyboardFunctionKeys,Setting.kKeyboardRemapKeys]);this.isInitialized=false;this.inputDeviceSettingsProvider=getInputDeviceSettingsProvider();this.personalizationHubBrowserProxy=PersonalizationHubBrowserProxyImpl.getInstance()}static get is(){return"settings-per-device-keyboard-subsection"}static get template(){return getTemplate$2X()}static get properties(){return{topRowAreFunctionKeysPref:{type:Object,value(){return{key:"fakeTopRowAreFunctionKeysPref",type:chrome.settingsPrivate.PrefType.BOOLEAN,value:false}}},blockMetaFunctionKeyRewritesPref:{type:Object,value(){return{key:"fakeBlockMetaFunctionKeyRewritesPref",type:chrome.settingsPrivate.PrefType.BOOLEAN,value:false}}},keyboardBrightnessPercentPref:{type:Object,value(){return{key:"fakekeyboardBrightnessPercentPref",type:chrome.settingsPrivate.PrefType.NUMBER,value:40}}},keyboardAutoBrightnessPref:{type:Object,value(){return{key:"fakekeyboardAutoBrightnessPref",type:chrome.settingsPrivate.PrefType.BOOLEAN,value:false}}},keyboard:{type:Object},keyboardPolicies:{type:Object},remapKeyboardKeysSublabel:{type:String,value:""},keyboardIndex:{type:Number},isLastDevice:{type:Boolean,reflectToAttribute:true},isRgbKeyboardSupported:{type:Boolean,value:false},hasKeyboardBacklight:{type:Boolean,value:false},hasAmbientLightSensor:{type:Boolean,value:false},isLidOpen:{type:Boolean,value:true}}}static get observers(){return["onSettingsChanged(topRowAreFunctionKeysPref.value,"+"blockMetaFunctionKeyRewritesPref.value,"+"enableAutoRepeatPref.value,"+"autoRepeatDelaysPref.value,"+"autoRepeatIntervalsPref.value)","onPoliciesChanged(keyboardPolicies)","onKeyboardRemappingsChanged(keyboard.*)","updateSettingsToCurrentPrefs(keyboard)"]}currentRouteChanged(newRoute){if(newRoute!==routes.PER_DEVICE_KEYBOARD){return}if(this.keyboard.isExternal){this.supportedSettingIds.add(Setting.kKeyboardBlockMetaFkeyRewrites)}if(this.keyboardIndex===0){this.attemptDeepLink()}}async connectedCallback(){super.connectedCallback();this.keyboardBrightnessObserverReceiver=new KeyboardBrightnessObserverReceiver(this);this.inputDeviceSettingsProvider.observeKeyboardBrightness(this.keyboardBrightnessObserverReceiver.$.bindNewPipeAndPassRemote());this.keyboardAmbientLightSensorObserverReceiver=new KeyboardAmbientLightSensorObserverReceiver(this);this.inputDeviceSettingsProvider.observeKeyboardAmbientLightSensor(this.keyboardAmbientLightSensorObserverReceiver.$.bindNewPipeAndPassRemote());this.lidStateObserverReceiver=new LidStateObserverReceiver(this);this.inputDeviceSettingsProvider.observeLidState(this.lidStateObserverReceiver.$.bindNewPipeAndPassRemote()).then((({isLidOpen:isLidOpen})=>{this.onLidStateChanged(isLidOpen)}));this.isRgbKeyboardSupported=(await this.inputDeviceSettingsProvider.isRgbKeyboardSupported())?.isRgbKeyboardSupported;this.hasKeyboardBacklight=(await this.inputDeviceSettingsProvider.hasKeyboardBacklight())?.hasKeyboardBacklight;this.hasAmbientLightSensor=(await this.inputDeviceSettingsProvider.hasAmbientLightSensor())?.hasAmbientLightSensor;if(this.hasKeyboardBacklight&&this.isChromeOsKeyboard()){const crSlider=this.shadowRoot.querySelector("#keyboardBrightnessSlider")?.shadowRoot.querySelector("cr-slider");if(crSlider){crSlider.setAttribute("key-press-slider-increment","10")}}}showInstallAppRow(){return this.keyboard.appInfo?.state===CompanionAppState$1.kAvailable}updateSettingsToCurrentPrefs(){this.isInitialized=false;this.set("topRowAreFunctionKeysPref.value",this.keyboard.settings.topRowAreFkeys);this.set("blockMetaFunctionKeyRewritesPref.value",this.keyboard.settings.suppressMetaFkeyRewrites);this.isInitialized=true}onPoliciesChanged(){this.topRowAreFunctionKeysPref={...this.topRowAreFunctionKeysPref,...getPrefPolicyFields$1(this.keyboardPolicies.topRowAreFkeysPolicy)};this.blockMetaFunctionKeyRewritesPref={...this.blockMetaFunctionKeyRewritesPref,...getPrefPolicyFields$1(this.keyboardPolicies.enableMetaFkeyRewritesPolicy)}}onLearnMoreLinkClicked_(event){const path=event.composedPath();if(!Array.isArray(path)||!path.length){return}if(path[0].tagName==="A"){event.stopPropagation()}}onKeyboardBrightnessSliderChanged(){this.inputDeviceSettingsProvider.setKeyboardBrightness(this.getKeyboardBrightnessFromSlider())}onKeyup(event){if(["ArrowRight","ArrowDown","ArrowLeft","ArrowUp"].includes(event.key)){this.inputDeviceSettingsProvider.recordKeyboardBrightnessChangeFromSlider(this.getKeyboardBrightnessFromSlider())}}onPointerup(){this.inputDeviceSettingsProvider.recordKeyboardBrightnessChangeFromSlider(this.getKeyboardBrightnessFromSlider())}onKeyboardAutoBrightnessToggleChanged(e){const toggle=e.target;this.inputDeviceSettingsProvider.setKeyboardAmbientLightSensorEnabled(toggle.checked)}onSettingsChanged(){if(!this.isInitialized){return}const newSettings={...this.keyboard.settings,topRowAreFkeys:this.topRowAreFunctionKeysPref.value,suppressMetaFkeyRewrites:this.blockMetaFunctionKeyRewritesPref.value};if(settingsAreEqual(newSettings,this.keyboard.settings)){return}this.keyboard.settings=newSettings;this.inputDeviceSettingsProvider.setKeyboardSettings(this.keyboard.id,this.keyboard.settings)}onKeyboardBrightnessChanged(keyboardBrightnessPercent){if(keyboardBrightnessPercent>0&&keyboardBrightnessPercent<MIN_VISIBLE_PERCENT){this.set("keyboardBrightnessPercentPref.value",MIN_VISIBLE_PERCENT);return}this.set("keyboardBrightnessPercentPref.value",keyboardBrightnessPercent)}onKeyboardAmbientLightSensorEnabledChanged(keyboardAmbientLightSensorEnabled){this.set("keyboardAutoBrightnessPref.value",keyboardAmbientLightSensorEnabled)}onLidStateChanged(isLidOpen){this.isLidOpen=isLidOpen}getNumRemappedSixPackKeys(){if(!this.keyboard.settings.sixPackKeyRemappings){return 0}return Object.values(this.keyboard.settings.sixPackKeyRemappings).filter((modifier=>modifier!==SixPackShortcutModifier$1.kSearch)).length}async onKeyboardRemappingsChanged(){let numRemappedKeys=Object.keys(this.keyboard.settings.modifierRemappings).length;if(loadTimeData.getBoolean("enableAltClickAndSixPackCustomization")){numRemappedKeys+=this.getNumRemappedSixPackKeys()}this.remapKeyboardKeysSublabel=await PluralStringProxyImpl.getInstance().getPluralString("remapKeyboardKeysRowSubLabel",numRemappedKeys)}onRemapKeyboardKeysClick(){const url=new URLSearchParams("keyboardId="+encodeURIComponent(this.keyboard.id));Router.getInstance().navigateTo(routes.PER_DEVICE_KEYBOARD_REMAP_KEYS,url,true)}getKeyboardName(){return this.keyboard.isExternal?this.keyboard.name:this.i18n("builtInKeyboardName")}showKeyboardSettings(){return this.keyboard.isExternal||!this.keyboard.isExternal&&this.isLidOpen}isChromeOsKeyboard(){return this.keyboard.metaKey===MetaKey$2.kLauncher||this.keyboard.metaKey===MetaKey$2.kSearch||this.keyboard.metaKey===MetaKey$2.kLauncherRefresh}openPersonalizationHub(){this.inputDeviceSettingsProvider.recordKeyboardColorLinkClicked();this.personalizationHubBrowserProxy.openPersonalizationHub()}getKeyboardBrightnessFromSlider(){const slider=this.shadowRoot.querySelector("#keyboardBrightnessSlider");return slider.pref.value}getRemapKeyboardKeysClass(){return`hr bottom-divider ${this.keyboard.isExternal?"":"remap-keyboard-keys-row-internal"}`}showSendFunctionKeyDescription(){const hasFunctionKey=this.keyboard.modifierKeys.includes(ModifierKey$2.kFunction);if(hasFunctionKey){return this.i18n("splitModifierKeyboardSendFunctionKeysDescription")}else{return this.i18n("keyboardSendFunctionKeysDescription")}}isCompanionAppInstalled(){return this.keyboard.appInfo?.state===CompanionAppState$1.kInstalled}}customElements.define(SettingsPerDeviceKeyboardSubsectionElement.is,SettingsPerDeviceKeyboardSubsectionElement);function getTemplate$2W(){return html`<!--_html_template_start_--><style include="settings-shared input-device-settings-shared"></style>
<template is="dom-if" if="[[!hasKeyboards(keyboards.length)]]">
  <div id="noKeyboardsConnectedContainer" class="settings-box start first">
    <h2 id="noKeyboardsConnectedMessage">
      $i18n{noKeyboardsConnected}
    </h2>
  </div>
</template>
<template is="dom-if" if="[[hasKeyboards(keyboards.length)]]">
  <template is="dom-repeat" items="[[keyboards]]"
      as="keyboard" index-as="index" restamp>
    <settings-per-device-keyboard-subsection
        keyboard="[[keyboard]]"
        keyboard-policies="[[keyboardPolicies]]"
        keyboard-index="[[index]]"
        is-last-device="[[computeIsLastDevice(index, keyboards.length)]]">
    </settings-per-device-keyboard-subsection>
  </template>
</template>

<h2 class="subsection-header">$i18n{keyboardHoldingKeys}</h2>
<div class="subsection">
    <settings-toggle-button
        class="hr continuation"
        pref="{{prefs.settings.language.physical_keyboard_enable_diacritics_on_longpress}}"
        label="$i18n{keyboardAccentMarks}"
        sub-label="$i18n{keyboardAccentMarksSubLabel}"
        deep-link-focus-id$="[[Setting.kShowDiacritic]]">
    </settings-toggle-button>
  <settings-toggle-button
      class="hr continuation"
      pref="{{prefs.settings.language.xkb_auto_repeat_enabled_r2}}"
      label="$i18n{keyboardEnableAutoRepeat}"
      sub-label="$i18n{keyboardEnableAutoRepeatSubLabel}"
      deep-link-focus-id$="[[Setting.kKeyboardAutoRepeat]]">
  </settings-toggle-button>
  <iron-collapse
      opened="[[prefs.settings.language.xkb_auto_repeat_enabled_r2.value]]">
    <div class="settings-box">
      <div class="start" id="repeatDelayLabel" aria-hidden="true">
        $i18n{keyRepeatDelay}
      </div>
      <settings-slider id="delaySlider"
          pref="{{prefs.settings.language.xkb_auto_repeat_delay_r2}}"
          ticks="[[autoRepeatDelays]]"
          disabled="[[
              !prefs.settings.language.xkb_auto_repeat_enabled_r2.value]]"
          label-aria="$i18n{keyRepeatDelay}"
          label-min="$i18n{keyRepeatDelayShort}"
          label-max="$i18n{keyRepeatDelayLong}">
      </settings-slider>
    </div>
    <div class="settings-box">
      <div class="start" id="repeatRateLabel" aria-hidden="true">
        $i18n{keyRepeatRate}
      </div>
      <settings-slider id="repeatRateSlider"
          pref="{{
              prefs.settings.language.xkb_auto_repeat_interval_r2}}"
          ticks="[[autoRepeatIntervals]]"
          disabled="[[
              !prefs.settings.language.xkb_auto_repeat_enabled_r2.value]]"
          label-aria="$i18n{keyRepeatRate}"
          label-min="$i18n{keyRepeatRateSlow}"
          label-max="$i18n{keyRepeatRateFast}">
      </settings-slider>
    </div>
  </iron-collapse>
</div>
<cr-link-row id="shortcutCustomizationApp" class="hr"
    on-click="onShowShortcutCustomizationAppClick"
    label="$i18n{showShortcutCustomizationApp}"
    external
    deep-link-focus-id$="[[Setting.kKeyboardShortcuts]]">
</cr-link-row>
<cr-link-row id="inputRow"
    class="hr" on-click="onShowInputSettingsClick"
    label="$i18n{keyboardShowInputSettings}"
    role-description="$i18n{subpageArrowRoleDescription}">
</cr-link-row>
<cr-link-row id="a11yKeyboardRow"
    class="hr" on-click="onShowA11yKeyboardSettingsClick"
    label="$i18n{keyboardShowA11yKeyboardSettings}"
    role-description="$i18n{subpageArrowRoleDescription}">
</cr-link-row>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsPerDeviceKeyboardElementBase=DeepLinkingMixin(RouteObserverMixin(I18nMixin(PolymerElement)));class SettingsPerDeviceKeyboardElement extends SettingsPerDeviceKeyboardElementBase{constructor(){super(...arguments);this.supportedSettingIds=new Set([Setting.kKeyboardAutoRepeat,Setting.kKeyboardShortcuts]);this.browserProxy=DevicePageBrowserProxyImpl.getInstance()}static get is(){return"settings-per-device-keyboard"}static get template(){return getTemplate$2W()}static get properties(){return{prefs:{type:Object,notify:true},keyboards:{type:Array,observer:"onKeyboardListUpdated"},keyboardPolicies:{type:Object},autoRepeatDelays:{type:Array,value(){return[150,200,300,500,1e3,1500,2e3]},readOnly:true},autoRepeatIntervals:{type:Array,value:[2e3,1e3,500,300,200,100,50,30,20],readOnly:true}}}connectedCallback(){super.connectedCallback();this.browserProxy.initializeKeyboard()}currentRouteChanged(route){if(route!==routes.PER_DEVICE_KEYBOARD){return}this.attemptDeepLink()}onKeyboardListUpdated(newKeyboardList,oldKeyboardList){if(!oldKeyboardList){return}const{msgId:msgId,deviceNames:deviceNames}=getDeviceStateChangesToAnnounce(newKeyboardList,oldKeyboardList);for(const deviceName of deviceNames){getInstance().announce(this.i18n(msgId,deviceName))}}onShowShortcutCustomizationAppClick(){this.browserProxy.showShortcutCustomizationApp()}onShowInputSettingsClick(){Router.getInstance().navigateTo(routes.OS_LANGUAGES_INPUT,undefined,true)}onShowA11yKeyboardSettingsClick(){Router.getInstance().navigateTo(routes.A11Y_KEYBOARD_AND_TEXT_INPUT,undefined,true)}hasKeyboards(){return this.keyboards.length>0}computeIsLastDevice(index){return index===this.keyboards.length-1}}customElements.define(SettingsPerDeviceKeyboardElement.is,SettingsPerDeviceKeyboardElement);function getTemplate$2V(){return html`<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">.settings-box{justify-content:space-between;padding-inline-start:0}</style>

<div class="settings-box" id="fkeyRow">
  <div>
    <div class="start key-container">
      <div id="keyLabel" aria-hidden="true">[[keyLabel]]</div>
    </div>
  </div>
  <settings-dropdown-menu id="keyDropdown"
      label="[[keyLabel]]"
      pref="{{pref}}"
      menu-options="[[shortcutOptions]]">
  </settings-dropdown-menu>
</div><!--_html_template_end_-->`}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getTopRowActionKeyString(topRowActionKey){switch(topRowActionKey){case TopRowActionKey$1.kBack:return loadTimeData.getString("backKeyLabel");case TopRowActionKey$1.kForward:return loadTimeData.getString("forwardKeyLabel");case TopRowActionKey$1.kRefresh:return loadTimeData.getString("refreshKeyLabel");case TopRowActionKey$1.kFullscreen:return loadTimeData.getString("fullscreenKeyLabel");case TopRowActionKey$1.kOverview:return loadTimeData.getString("overviewKeyLabel");case TopRowActionKey$1.kScreenshot:return loadTimeData.getString("screenshotKeyLabel");case TopRowActionKey$1.kScreenBrightnessDown:return loadTimeData.getString("screenBrightnessDownKeyLabel");case TopRowActionKey$1.kScreenBrightnessUp:return loadTimeData.getString("screenBrightnessUpKeyLabel");case TopRowActionKey$1.kMicrophoneMute:return loadTimeData.getString("microphoneMuteKeyLabel");case TopRowActionKey$1.kVolumeMute:return loadTimeData.getString("muteKeyLabel");case TopRowActionKey$1.kVolumeDown:return loadTimeData.getString("volumeDownKeyLabel");case TopRowActionKey$1.kVolumeUp:return loadTimeData.getString("volumeUpKeyLabel");case TopRowActionKey$1.kKeyboardBacklightToggle:return loadTimeData.getString("backlightToggleKeyLabel");case TopRowActionKey$1.kKeyboardBacklightDown:return loadTimeData.getString("backlightDownKeyLabel");case TopRowActionKey$1.kKeyboardBacklightUp:return loadTimeData.getString("backlightUpKeyLabel");case TopRowActionKey$1.kNextTrack:return loadTimeData.getString("trackNextKeyLabel");case TopRowActionKey$1.kPreviousTrack:return loadTimeData.getString("trackPreviousKeyLabel");case TopRowActionKey$1.kPlayPause:return loadTimeData.getString("playPauseKeyLabel");case TopRowActionKey$1.kAllApplications:return loadTimeData.getString("allApplicationsKeyLabel");case TopRowActionKey$1.kEmojiPicker:return loadTimeData.getString("emojiPickerKeyLabel");case TopRowActionKey$1.kDictation:return loadTimeData.getString("dicationKeyLabel");case TopRowActionKey$1.kPrivacyScreenToggle:return loadTimeData.getString("privacyScreenToggleKeyLabel");case TopRowActionKey$1.kNone:case TopRowActionKey$1.kUnknown:return"";default:assertNotReached()}}const fKeyLabels={[Fkey.F11]:loadTimeData.getString("f11KeyLabel"),[Fkey.F12]:loadTimeData.getString("f12KeyLabel")};const FkeyRowElementBase=RouteObserverMixin(I18nMixin(PolymerElement));class FkeyRowElement extends FkeyRowElementBase{static get is(){return"fkey-row"}static get template(){return getTemplate$2V()}static get properties(){return{key:{type:String},keyLabel:{type:String,computed:"computeKeyLabel(key)"},pref:{type:Object},keyboard:{type:Object},shortcutOptions:{type:Array}}}currentRouteChanged(route){if(route!==routes.PER_DEVICE_KEYBOARD_REMAP_KEYS){return}this.shortcutOptions=this.getMenuOptions()}getTopRowKeyLabel(){const fkeyIndex=this.key===Fkey.F11?0:1;assert(this.keyboard.topRowActionKeys);return getTopRowActionKeyString(this.keyboard.topRowActionKeys[fkeyIndex])}computeKeyLabel(){assert(this.key in fKeyLabels);return fKeyLabels[this.key]}getFkeyShortcutOptions(){const topRowKeyLabel=this.getTopRowKeyLabel();const messageIdSuffix=this.keyboard.settings.topRowAreFkeys?"":"Search";return[{value:ExtendedFkeysModifier$1.kShift,name:this.i18n(`fKeyShiftOption${messageIdSuffix}`,topRowKeyLabel)},{value:ExtendedFkeysModifier$1.kCtrlShift,name:this.i18n(`fKeyCtrlShiftOption${messageIdSuffix}`,topRowKeyLabel)},{value:ExtendedFkeysModifier$1.kAlt,name:this.i18n(`fKeyAltOption${messageIdSuffix}`,topRowKeyLabel)}]}getMenuOptions(){return[{value:ExtendedFkeysModifier$1.kDisabled,name:this.i18n("perDeviceKeyboardKeyDisabled")},...this.getFkeyShortcutOptions()]}}customElements.define(FkeyRowElement.is,FkeyRowElement);const template$3=html`<!-- TODO(dpad): Collapse with keyboard and shortcut customization app icons -->
<iron-iconset-svg name="shortcut-input-keys" size="24">
  <svg>
    <defs>
      <g id="accessibility" viewBox="0 0 20 20">
        <path
          d="M10 5.458a1.8 1.8 0 0 1-1.292-.52 1.787 1.787 0 0 1-.541-1.313c0-.5.18-.924.541-1.27A1.763 1.763 0 0 1 10 1.812c.5 0 .93.18 1.292.541.36.347.541.778.541 1.292 0 .5-.18.93-.541 1.292a1.8 1.8 0 0 1-1.292.52ZM7.417 17.812V8.376H3V6.708h14v1.667h-4.417v9.438h-1.646l-.187-4.646H9.27l-.207 4.646H7.417Z">
        </path>
      </g>
      <g id="arrow-down">
        <path d="M7.41 7.84L12 12.42l4.59-4.58L18 9.25l-6 6-6-6z">
      </g>
      <g id="arrow-left">
        <path d="M15.41 16.09l-4.58-4.59 4.58-4.59L14 5.5l-6 6 6 6z">
      </g>
      <g id="arrow-right">
        <path d="M8.59 16.34l4.58-4.59-4.58-4.59L10 5.75l6 6-6 6z">
      </g>
      <g id="arrow-up">
        <path d="M7.41 15.41L12 10.83l4.59 4.58L18 14l-6-6-6 6z">
      </g>
      <g id="assistant" viewBox="0 0 20 20">
        <path
          d="M6.36364 3C8.77382 3 10.7273 4.95418 10.7273 7.36364C10.7273 9.77309 8.77382 11.7273 6.36364 11.7273C3.95345 11.7273 2 9.77309 2 7.36364C2 4.95418 3.95345 3 6.36364 3Z">
        </path>
        <path
          d="M18 6.99997C18 7.60215 17.5113 8.09088 16.9091 8.09088C16.3069 8.09088 15.8182 7.60215 15.8182 6.99997C15.8182 6.39778 16.3069 5.90906 16.9091 5.90906C17.5113 5.90906 18 6.39778 18 6.99997Z">
        </path>
        <path
          d="M15.8182 9.54547C15.8182 10.7506 14.8414 11.7273 13.6363 11.7273C12.4313 11.7273 11.4545 10.7506 11.4545 9.54547C11.4545 8.34037 12.4313 7.36365 13.6363 7.36365C14.8414 7.36365 15.8182 8.34037 15.8182 9.54547Z">
        </path>
        <path
          d="M13.6363 17.5455C15.0422 17.5455 16.1818 16.4059 16.1818 15C16.1818 13.5942 15.0422 12.4546 13.6363 12.4546C12.2305 12.4546 11.0909 13.5942 11.0909 15C11.0909 16.4059 12.2305 17.5455 13.6363 17.5455Z">
        </path>
      </g>
      <g id="back">
        <path d="M20 11H7.83l5.59-5.59L12 4l-8 8 8 8 1.41-1.41L7.83 13H20v-2z">
      </g>
      <g id="brightness-up-refresh" viewBox="0 0 20 20">
        <g clip-path="url(#a)">
          <path d="m10 18.688 2.52-2.521h3.647V12.52l2.52-2.52-2.52-2.52V3.832H12.52L10 1.313l-2.52 2.52H3.832V7.48L1.313 10l2.52 2.52v3.647H7.48l2.52 2.52Zm0-4.75c-1.097 0-2.028-.382-2.792-1.146-.764-.778-1.146-1.709-1.146-2.792 0-1.097.39-2.028 1.167-2.792.764-.764 1.688-1.146 2.771-1.146 1.097 0 2.028.39 2.792 1.167.764.764 1.146 1.688 1.146 2.771 0 1.097-.382 2.028-1.146 2.792-.778.764-1.709 1.146-2.792 1.146Zm0 2.312-1.813-1.813H5.563v-2.624L3.75 10l1.813-1.813V5.563h2.625L10 3.75l1.813 1.813h2.624v2.625L16.25 10l-1.813 1.813v2.624h-2.624L10 16.25Z"></path>
        </g>
        <defs>
          <clipPath id="a">
            <path d="M20 0H0v20h20z"></path>
          </clipPath>
        </defs>
      </g>
      <g id="camera-access-toggle" viewBox="0 0 20 20">
        <path d="M18 13.9792L15 10.9792V12.8542L13.5 11.3542V5.5H7.625L6.125 4H13.5C13.9167 4 14.2708 4.14583 14.5625 4.4375C14.8542 4.72917 15 5.08333 15 5.5V8.97917L18 5.97917V13.9792ZM16.7292 18.8125L1.16667 3.27083L2.22917 2.20833L17.7917 17.75L16.7292 18.8125ZM4.04167 4.04167L5.5 5.47917H4.5V14.5H13.5V13.4583L15 14.9583C14.8889 15.2361 14.7153 15.4792 14.4792 15.6875C14.2431 15.8958 13.9167 16 13.5 16H4.5C4.09722 16 3.74306 15.8542 3.4375 15.5625C3.14583 15.2708 3 14.9167 3 14.5V5.47917C3 5.11805 3.09722 4.8125 3.29167 4.5625C3.5 4.3125 3.75 4.13889 4.04167 4.04167Z"></path>
      </g>
      <g id="do-not-disturb" viewbox="0 0 20 20">
        <path d="M6 10.875h8v-1.75H6v1.75Zm4 7.292a8.205 8.205 0 0 1-3.188-.625 8.59 8.59 0 0 1-2.604-1.75 8.589 8.589 0 0 1-1.75-2.604A8.204 8.204 0 0 1 1.833 10c0-1.139.209-2.201.625-3.188a8.327 8.327 0 0 1 1.75-2.583 8.112 8.112 0 0 1 2.604-1.75c1-.43 2.063-.646 3.188-.646 1.139 0 2.201.216 3.188.646a7.88 7.88 0 0 1 2.583 1.75 7.82 7.82 0 0 1 1.75 2.604c.43.986.646 2.042.646 3.167a7.974 7.974 0 0 1-.646 3.188c-.417.986-1 1.854-1.75 2.604a8.262 8.262 0 0 1-2.604 1.75 8.053 8.053 0 0 1-3.167.625Zm0-1.73c1.792 0 3.313-.625 4.563-1.875 1.25-1.25 1.874-2.77 1.874-4.562 0-1.792-.625-3.313-1.875-4.563-1.25-1.25-2.77-1.875-4.562-1.875-1.792 0-3.313.626-4.563 1.876-1.25 1.25-1.875 2.77-1.875 4.562 0 1.792.626 3.313 1.876 4.563 1.25 1.25 2.77 1.874 4.562 1.874Z"></path>
      </g>
      <g id="display-brightness-down" viewbox="0 0 20 20">
        <path fill-rule="evenodd"
          d="M9.99982 4.13281L11.7889 5.87499H14.1285V8.15322L15.7799 9.76139L14.1285 11.5036V13.7818H11.7889L9.99982 15.39L8.34836 13.7818H6.00878V11.5036L4.21973 9.76139L6.00878 8.15322V5.87499H8.34836L9.99982 4.13281ZM9.99982 6.41105L8.89883 7.48315H7.66025V8.68928L6.5593 9.76139L7.66025 10.9675V12.0396H8.89883L9.99982 13.2457L11.2384 12.0396H12.3394V10.9675L13.5779 9.76139L12.3394 8.68928V7.48315H11.2384L9.99982 6.41105Z">
      </g>
      <g id="display-brightness-up" viewbox="0 0 20 20">
        <path fill-rule="evenodd"
          d="M10.0686 2.64844L12.2706 4.92667H15.2982V7.87497L17.5002 10.0192L15.2982 12.1634V15.2457H12.2706L10.0686 17.3899L7.72908 15.2457H4.70145V12.1634L2.49951 10.0192L4.70145 7.87497V4.92667H7.72908L10.0686 2.64844ZM10.0686 4.92667L8.2796 6.53484H6.4905V8.27701L4.70145 10.0192L6.4905 11.7614V13.5035H8.2796L10.0686 15.2457L11.7201 13.5035H13.5092V11.7614L15.2982 10.0192L13.5092 8.27701V6.53484H11.7201L10.0686 4.92667Z">
      </g>
      <g id="electronic-privacy-screen" viewbox="0 0 20 20">
        <path fill-rule="evenodd"
          d="M18 3V17H2V3H18ZM16 15H5.07314L15.0731 5H16V15ZM4 10.8284V13.2447L12.2447 5H9.82838L4 10.8284ZM6.99995 5L4 7.99995V5H6.99995Z">
      </g>
      <g id="forward">
        <path d="M12 4l-1.41 1.41L16.17 11H4v2h12.17l-5.58 5.59L12 20l8-8z">
      </g>
      <g id="fullscreen">
        <path d="M7 14H5v5h5v-2H7v-3zm-2-4h2V7h3V5H5v5zm12 7h-3v2h5v-5h-2v3zM14 5v2h3v3h2V5h-5z">
      </g>
      <g id="last-track" viewbox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M16 15L8 10L16 5V15Z"></path>
        <path d="M4 5H6V15H4V5Z"></path>
      </g>
      <g id="keyboard-brightness-down" viewbox="0 0 20 20">
        <path fill-rule="evenodd"
          d="M6.95442 14H13.0455C13.2262 14 13.3915 14.107 13.4723 14.2764L13.9495 15.2764C14.0674 15.5234 13.9718 15.8237 13.7361 15.9472C13.6698 15.9819 13.5968 16 13.5227 16H6.47721C6.21365 16 6 15.7761 6 15.5C6 15.4224 6.01725 15.3458 6.05038 15.2764L6.52759 14.2764C6.60842 14.107 6.77366 14 6.95442 14ZM6 8.37845L4.7111 9.55653L3.08636 8.06095L4.36619 6.88287L6 8.37845ZM3.45455 12V14H1V12H3.45455ZM11 5V7.22176H9V5H11ZM16.9136 8.06463L15.2838 9.56488L14 8.38312L15.6298 6.88287L16.9136 8.06463ZM16.5454 12H19V14H16.5454V12Z">
      </g>
      <g id="keyboard-brightness-toggle" viewbox="0 0 20 20">
        <path d="M 9.15049 2 L 10.8508 2 L 10.8508 7.03443 L 9.15049 7.03443 Z"></path>
        <path d="M 5.74972 12.0689 L 0.649957 12.0689 L 0.649957 10.3903 L 5.74972 10.3903 Z"></path>
        <path d="M 19.3501 12.0689 L 14.2503 12.0689 L 14.2503 10.3903 L 19.3501 10.3903 Z"></path>
        <path d="M 16.1818 3.7734 L 17.3838 4.95997 L 14.0176 8.28251 L 12.8156 7.09593 Z"></path>
        <path
          d="M 13.2192 15.6192 L 14.2571 16.6571 L 15.1208 17.5207 L 15.5999 18 L 16.7468 16.8545 L 11.9673 12.0698 L 12.5323 12.0698 L 12.5323 10.3913 L 10.2887 10.3899 L 3.28479 3.38476 L 2.138 4.52385 L 2.13032 4.53029 Z">
        </path>
      </g>
      <g id="keyboard-brightness-up" viewbox="0 0 20 20">
        <path fill-rule="evenodd"
          d="M6.95442 14H13.0455C13.2262 14 13.3915 14.107 13.4723 14.2764L13.9495 15.2764C14.0674 15.5234 13.9718 15.8237 13.7361 15.9472C13.6698 15.9819 13.5968 16 13.5227 16H6.47721C6.21365 16 6 15.7761 6 15.5C6 15.4224 6.01725 15.3458 6.05038 15.2764L6.52759 14.2764C6.60842 14.107 6.77366 14 6.95442 14ZM6 8.37845L4.7111 9.55653L1.08636 6.06095L2.36619 4.88287L6 8.37845ZM3.45455 12V14H0V12H3.45455ZM11 2V7.22176H9V2H11ZM18.9136 6.06463L15.2838 9.56488L14 8.38312L17.6298 4.88287L18.9136 6.06463ZM16.5454 12H20V14H16.5454V12Z">
      </g>
      <g id="launcher" viewbox="0 0 20 20">
        <path
          d="M10 15C12.7614 15 15 12.7614 15 10C15 7.23858 12.7614 5 10 5C7.23858 5 5 7.23858 5 10C5 12.7614 7.23858 15 10 15Z">
        </path>
        <path fill-rule="evenodd"
          d="M10 18.5C14.6944 18.5 18.5 14.6944 18.5 10C18.5 5.30558 14.6944 1.5 10 1.5C5.30558 1.5 1.5 5.30558 1.5 10C1.5 14.6944 5.30558 18.5 10 18.5ZM17 10C17 13.866 13.866 17 10 17C6.13401 17 3 13.866 3 10C3 6.13401 6.13401 3 10 3C13.866 3 17 6.13401 17 10Z">
        </path>
      </g>
      <g id="launcher-refresh" viewBox="0 0 20 20">
        <g clip-path="url(#a)">
          <path
            d="M10 16.517c-.9 0-1.75-.167-2.55-.5a6.662 6.662 0 0 1-2.067-1.4 6.662 6.662 0 0 1-1.4-2.067 6.57 6.57 0 0 1-.5-2.55c0-.9.167-1.744.5-2.533a6.662 6.662 0 0 1 1.4-2.067A6.3 6.3 0 0 1 7.45 4 6.38 6.38 0 0 1 10 3.483c.822 0 1.6.15 2.333.45.745.29 1.423.7 2.034 1.234l-1.85 1.8a3.886 3.886 0 0 0-1.167-.7A3.443 3.443 0 0 0 10 6c-1.089 0-2.017.394-2.783 1.183A3.932 3.932 0 0 0 6.083 10c0 1.1.378 2.039 1.134 2.817.766.777 1.694 1.166 2.783 1.166.922 0 1.711-.255 2.367-.766a3.11 3.11 0 0 0 1.216-1.984H10V8.817h6.117c.055.233.094.46.116.683.023.211.034.428.034.65 0 1.922-.578 3.467-1.734 4.633-1.144 1.156-2.655 1.734-4.533 1.734Z"></path>
        </g>
        <defs>
          <clipPath id="a">
            <path d="M0 0h20v20H0z"></path>
          </clipPath>
        </defs>
      </g>
      <g id="microphone-mute" viewbox="0 0 20 20">
        <path
          d="M 15.4894 8.94314 L 13.9775 8.94314 C 13.9775 9.69794 13.8293 10.3021 13.5269 10.9057 L 14.5823 11.9623 C 15.187 11.2075 15.4894 10.1509 15.4894 8.94314 Z M 2.96096 2.6036 L 1.90551 3.66019 L 10.9595 12.7171 C 10.6572 12.7171 10.3548 12.8682 10.2065 12.8682 C 8.08988 12.8682 6.28133 11.0569 6.28133 8.94314 L 4.76949 8.94314 C 4.76949 11.6605 6.73206 13.9249 9.4477 14.3773 L 9.4477 16.7928 L 10.9595 16.7928 L 10.9595 14.3773 C 11.4102 14.3773 11.8666 14.2266 12.169 14.0754 L 16.0942 18 L 17.1496 16.9434 Z M 12.4714 8.94314 L 12.4714 4.26379 C 12.4714 2.9054 11.4102 2 10.2065 2 C 8.84865 2 7.94154 3.05659 7.94154 4.26379 L 7.94154 5.16975 L 12.4714 9.69794 C 12.3173 9.5473 12.4714 9.24551 12.4714 8.94314 Z">
        </path>
      </g>
      <g id="next-track" viewbox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M4 15L12 10L4 5V15Z"></path>
        <path d="M16 5H14V15H16V5Z"></path>
      </g>
      <g id="overview" width="20" height="20" viewbox="0 0 20 20">
        <path fill-rule="evenodd"
          d="M0.164062 15.3381H13.1281V4.65625H0.164062V15.3381ZM1.80029 6.28995H11.4919V13.7044H1.80029V6.28995ZM14.803 15.3381H16.4806V4.65625H14.803V15.3381ZM18.1583 4.65625H19.8359V15.3255H18.1583V4.65625Z">
      </g>
      <g id="overview-refresh" viewBox="0 0 20 20">
        <path d="M19.167 9V2.833H9V9h10.167Zm0 8.167V11H13v6.167h6.167ZM7 9V2.833H.834V9H7Zm4 8.167V11H.834v6.167H11Zm6.438-9.896H10.73V4.563h6.708V7.27Zm-12.167 0H2.563V4.563H5.27V7.27Zm4 8.167H2.563v-2.709H9.27v2.709Zm8.167 0H14.73v-2.709h2.708v2.709Z"></path>
      </g>
      <g id="play-pause" viewbox="0 0 20 20">
        <path fill-rule="evenodd" d="M3.53027 13.9683L10.1413 10.0017L3.53027 6.03516V13.9683Z"></path>
        <rect x="11.521" y="5.67969" width="2" height="8.28929"></rect>
        <rect x="14.5444" y="5.67969" width="2" height="8.28929"></rect>
      </g>
      <g id="power">
        <path
          d="M13 3h-2v10h2V3zm4.83 2.17l-1.42 1.42C17.99 7.86 19 9.81 19 12c0 3.87-3.13 7-7 7s-7-3.13-7-7c0-2.19 1.01-4.14 2.58-5.42L6.17 5.17C4.23 6.82 3 9.26 3 12c0 4.97 4.03 9 9 9s9-4.03 9-9c0-2.74-1.23-5.18-3.17-6.83z">
      </g>
      <g id="refresh">
        <path
          d="M17.65 6.35C16.2 4.9 14.21 4 12 4c-4.42 0-7.99 3.58-7.99 8s3.57 8 7.99 8c3.73 0 6.84-2.55 7.73-6h-2.08c-.82 2.33-3.04 4-5.65 4-3.31 0-6-2.69-6-6s2.69-6 6-6c1.66 0 3.14.69 4.22 1.78L13 11h7V4l-2.35 2.35z">
      </g>
      <g id="quick-insert" viewBox="0 0 20 20">
        <g clip-path="url(#a)">
          <path
            d="M9.167 13.042h1.666v-2.209h2.209V9.167h-2.209V6.958H9.167v2.209H6.958v1.666h2.209v2.209ZM10 18.167a1.68 1.68 0 0 1-.667-.125 1.992 1.992 0 0 1-.562-.375l-6.438-6.438a1.815 1.815 0 0 1-.396-.562A1.977 1.977 0 0 1 1.833 10c0-.25.035-.472.105-.667.083-.194.215-.375.395-.541l6.438-6.459c.18-.18.368-.305.562-.375.195-.083.417-.125.667-.125.25 0 .472.042.667.125.194.07.375.195.541.375l6.459 6.438c.18.18.305.368.375.562.083.195.125.417.125.667 0 .25-.042.472-.125.667-.07.194-.195.382-.375.562l-6.459 6.438a1.732 1.732 0 0 1-.541.375 1.68 1.68 0 0 1-.667.125Zm0-1.73L16.438 10 10 3.562 3.562 10 10 16.438Z"></path>
        </g>
        <defs>
          <clipPath id="a">
            <path d="M0 0h20v20H0z"></path>
          </clipPath>
        </defs>
      </g>
      <g id="screen-mirror" viewbox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M17.1327 12.0716H15.0166V10.5716H16.6327V5.28516H9.57471V5.97091H8.07471V4.78516C8.07471 4.23287 8.52242 3.78516 9.07471 3.78516H17.1327C17.685 3.78516 18.1327 4.23287 18.1327 4.78516V11.0716C18.1327 11.6239 17.685 12.0716 17.1327 12.0716ZM14.228 15.0129H13.5443V7.49229C13.5443 7.30349 13.4678 7.13257 13.344 7.00884C13.2203 6.88512 13.0494 6.80859 12.8606 6.80859H3.28888C2.91128 6.80859 2.60518 7.11469 2.60518 7.49229V15.0129H1.92149C1.54389 15.0129 1.23779 15.319 1.23779 15.6966C1.23779 16.0742 1.54389 16.3803 1.92149 16.3803H14.228C14.6056 16.3803 14.9117 16.0742 14.9117 15.6966C14.9117 15.319 14.6056 15.0129 14.228 15.0129ZM12.1769 8.17598V12.9618H3.97257V8.17598H12.1769ZM6.70735 15.0129V14.3292H9.44213V15.0129H6.70735Z">
        </path>
      </g>
      <g id="screenshot" viewBox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M7.96487 7.55109C8.52146 7.18893 9.17585 6.99562 9.84526 6.99562C10.7429 6.99562 11.6038 7.34288 12.2385 7.96098C12.8732 8.57908 13.2299 9.41741 13.2299 10.2915C13.2299 10.9434 13.0314 11.5806 12.6595 12.1226C12.2876 12.6646 11.759 13.0871 11.1405 13.3366C10.5221 13.586 9.8415 13.6513 9.18495 13.5241C8.52841 13.3969 7.92534 13.083 7.45199 12.6221C6.97865 12.1612 6.65632 11.5739 6.52572 10.9345C6.39513 10.2952 6.46214 9.6325 6.71831 9.03025C6.97448 8.428 7.40828 7.91325 7.96487 7.55109ZM11.1507 9.02033C10.8045 8.68318 10.3349 8.49376 9.84526 8.49376C9.35563 8.49376 8.88608 8.68318 8.53986 9.02033C8.19365 9.35747 7.99915 9.81474 7.99915 10.2915C7.99915 10.7683 8.19365 11.2256 8.53986 11.5627C8.88608 11.8999 9.35563 12.0893 9.84526 12.0893C10.3349 12.0893 10.8045 11.8999 11.1507 11.5627C11.4969 11.2256 11.6914 10.7683 11.6914 10.2915C11.6914 9.81474 11.4969 9.35747 11.1507 9.02033Z">
        </path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M2 4H18V16.7342H2V4ZM16 14.7866V5.94758H4.00002V14.7866H16Z">
        </path>
      </g>
      <g id="volume-down">
        <path d="M18.5 12c0-1.77-1.02-3.29-2.5-4.03v8.05c1.48-.73 2.5-2.25 2.5-4.02zM5 9v6h4l5 5V4L9 9H5z">
      </g>
      <g id="volume-mute">
        <path
          d="M16.5 12c0-1.77-1.02-3.29-2.5-4.03v2.21l2.45 2.45c.03-.2.05-.41.05-.63zm2.5 0c0 .94-.2 1.82-.54 2.64l1.51 1.51C20.63 14.91 21 13.5 21 12c0-4.28-2.99-7.86-7-8.77v2.06c2.89.86 5 3.54 5 6.71zM4.27 3L3 4.27 7.73 9H3v6h4l5 5v-6.73l4.25 4.25c-.67.52-1.42.93-2.25 1.18v2.06c1.38-.31 2.63-.95 3.69-1.81L19.73 21 21 19.73l-9-9L4.27 3zM12 4L9.91 6.09 12 8.18V4z">
      </g>
      <g id="volume-up">
        <path
          d="M3 9v6h4l5 5V4L7 9H3zm13.5 3c0-1.77-1.02-3.29-2.5-4.03v8.05c1.48-.73 2.5-2.25 2.5-4.02zM14 3.23v2.06c2.89.86 5 3.54 5 6.71s-2.11 5.85-5 6.71v2.06c4.01-.91 7-4.49 7-8.77s-2.99-7.86-7-8.77z">
      </g>
      <g id="plus" viewbox="0 0 16 16">
        <path d="M9 4H7V7H4V9H7V12H9V9H12V7H9V4Z"></path>
      </g>
      <g id="emoji-picker" viewBox="0 0 20 20">
        <path fill-rule="evenodd"
          d="M9.992 2C5.576 2 2 5.584 2 10C2 14.416 5.576 18 9.992 18C14.416 18 18 14.416 18 10C18 5.584 14.416 2 9.992 2ZM10 16.5C6.40875 16.5 3.5 13.5912 3.5 10C3.5 6.40875 6.40875 3.5 10 3.5C13.5912 3.5 16.5 6.40875 16.5 10C16.5 13.5912 13.5912 16.5 10 16.5ZM12.8 9.20005C13.464 9.20005 14 8.66405 14 8.00005C14 7.33605 13.464 6.80005 12.8 6.80005C12.136 6.80005 11.6 7.33605 11.6 8.00005C11.6 8.66405 12.136 9.20005 12.8 9.20005ZM7.2 9.20005C7.864 9.20005 8.4 8.66405 8.4 8.00005C8.4 7.33605 7.864 6.80005 7.2 6.80005C6.536 6.80005 6 7.33605 6 8.00005C6 8.66405 6.536 9.20005 7.2 9.20005ZM9.99999 14C11.864 14 13.448 12.7486 14.088 11H5.91199C6.55199 12.7486 8.13599 14 9.99999 14Z">
        </path>
      </g>
      <g id="dictation-toggle" viewBox="0 0 20 20">
        <path
          d="M5.75 8.02c.403 0 .757-.152 1.063-.457.305-.306.458-.66.458-1.063v-3c0-.417-.153-.77-.458-1.063-.306-.305-.66-.458-1.063-.458-.417 0-.77.153-1.063.458A1.414 1.414 0 0 0 4.23 3.5v3c0 .403.153.757.458 1.063.292.305.646.458 1.063.458Zm9.667 10.21c.514 0 .944-.181 1.291-.543.348-.36.521-.791.521-1.291V3.5c0-.472-.166-.875-.5-1.208A1.681 1.681 0 0 0 15.5 1.77H9V3.5h6.5v13H6.625v-1.438h-1.75v1.334c0 .5.18.93.542 1.291.347.362.77.542 1.27.542h8.73ZM14 15.061V13.5H8.396v1.563H14Zm0-2.562V11h-4v1.5h4Zm-9.125 1.125h1.75v-2.688a3.994 3.994 0 0 0 2.333-1.395A3.864 3.864 0 0 0 9.875 7H8.229c0 .68-.243 1.257-.729 1.73a2.461 2.461 0 0 1-1.75.687c-.694 0-1.278-.23-1.75-.688A2.319 2.319 0 0 1 3.27 7H1.626c0 .958.306 1.806.917 2.542.597.736 1.375 1.201 2.333 1.396v2.687Z">
        </path>
      </g>
      <g id="settings-icon" viewBox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M11.6629 19H8.33386C7.66807 19 7.11024 18.5256 7.02926 17.8843L6.78633 16.224C6.54341 16.101 6.30948 15.9693 6.07555 15.8199L4.45604 16.4524C3.82623 16.6808 3.13344 16.4261 2.82754 15.8814L1.18103 13.0966C0.86613 12.5168 1.00109 11.8316 1.50494 11.4451L2.88152 10.3997C2.87252 10.2679 2.86352 10.1362 2.86352 9.99561C2.86352 9.86384 2.87252 9.72328 2.88152 9.59151L1.51393 8.54612C0.983095 8.15081 0.848136 7.43924 1.18103 6.89458L2.84553 4.09224C3.15144 3.54758 3.84423 3.30161 4.45604 3.5388L6.08455 4.18009C6.31848 4.03075 6.5524 3.89897 6.78633 3.77599L7.02926 2.0981C7.11024 1.48316 7.66807 1 8.32487 1H11.6539C12.3197 1 12.8775 1.47438 12.9585 2.11567L13.2014 3.77599C13.4443 3.89897 13.6782 4.03075 13.9122 4.18009L15.5317 3.54758C16.1705 3.31918 16.8633 3.57394 17.1692 4.11859L18.8247 6.91215C19.1486 7.49195 19.0046 8.17716 18.5008 8.56369L17.1332 9.60908C17.1422 9.74085 17.1512 9.87262 17.1512 10.0132C17.1512 10.1537 17.1422 10.2855 17.1332 10.4173L18.5008 11.4627C19.0046 11.858 19.1486 12.5432 18.8337 13.0966L17.1602 15.9253C16.8543 16.47 16.1615 16.716 15.5407 16.4788L13.9212 15.8463C13.6872 15.9956 13.4533 16.1274 13.2194 16.2504L12.9765 17.9283C12.8865 18.5256 12.3287 19 11.6629 19ZM8.81541 16.75H11.1932L11.512 14.6636L11.9686 14.4836C12.3476 14.3364 12.7267 14.1236 13.123 13.8455L13.5107 13.5673L15.5611 14.3527L16.75 12.3891L15.0011 11.0964L15.0614 10.6382C15.0873 10.4255 15.1131 10.2209 15.1131 10C15.1131 9.77909 15.0873 9.56636 15.0614 9.36182L15.0011 8.90364L16.75 7.61091L15.5525 5.64727L13.4935 6.43273L13.1058 6.14636C12.7439 5.88455 12.3563 5.67182 11.96 5.51636L11.512 5.33636L11.1932 3.25H8.81541L8.49665 5.33636L8.04004 5.50818C7.66098 5.66364 7.28191 5.86818 6.88561 6.15455L6.49793 6.42455L4.44751 5.64727L3.25 7.60273L4.99888 8.89545L4.93858 9.35364C4.91273 9.56636 4.88689 9.78727 4.88689 10C4.88689 10.2127 4.90412 10.4336 4.93858 10.6382L4.99888 11.0964L3.25 12.3891L4.4389 14.3527L6.49793 13.5673L6.88561 13.8536C7.25606 14.1236 7.62652 14.3282 8.03143 14.4836L8.48803 14.6636L8.81541 16.75ZM10 12.8125C11.5533 12.8125 12.8125 11.5533 12.8125 10C12.8125 8.4467 11.5533 7.1875 10 7.1875C8.4467 7.1875 7.1875 8.4467 7.1875 10C7.1875 11.5533 8.4467 12.8125 10 12.8125Z">
        </path>
      </g>
      <g id="search" viewBox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M17.49 16L13.76 12.27C14.53 11.2 15 9.91 15 8.5C15 4.91 12.09 2 8.5 2C4.91 2 2 4.91 2 8.5C2 12.09 4.91 15 8.5 15C9.91 15 11.2 14.53 12.27 13.76L16 17.49L17.49 16ZM4 8.5C4 6.01 6.01 4 8.5 4C10.99 4 13 6.01 13 8.5C13 10.99 10.99 13 8.5 13C6.01 13 4 10.99 4 8.5Z">
        </path>
      </g>
      <g id="browser-search" viewBox="0 0 20 20">
        <path
          d="M9.82803 18.9771C8.6051 18.9465 7.4586 18.6943 6.38853 18.2204C5.31847 17.7465 4.37834 17.1045 3.56815 16.2943C2.77325 15.4688 2.1465 14.521 1.6879 13.451C1.2293 12.3656 1 11.2115 1 9.98853C1 8.73503 1.2293 7.5656 1.6879 6.48025C2.16178 5.3949 2.81146 4.44713 3.63694 3.63694C4.46242 2.81146 5.41783 2.16943 6.50318 1.71083C7.58853 1.23694 8.75032 1 9.98853 1C12.2204 1 14.1465 1.69554 15.7669 3.08662C17.4025 4.47771 18.4191 6.22802 18.8166 8.33758H16.8675C16.6229 7.23694 16.1338 6.2586 15.4 5.40255C14.6662 4.5465 13.772 3.90446 12.7172 3.47643V3.98089C12.7172 4.43949 12.5567 4.8293 12.2357 5.15032C11.9147 5.45605 11.5325 5.60892 11.0892 5.60892H8.8879V6.70955C8.8879 7.01529 8.78089 7.27516 8.56688 7.48917C8.36815 7.6879 8.11592 7.78726 7.81019 7.78726H6.70955V9.98853H7.78726V12.1439H6.70955L3.06369 8.49809C3.01783 8.74267 2.97962 8.98726 2.94904 9.23185C2.91847 9.47643 2.90318 9.72866 2.90318 9.98853C2.90318 11.9299 3.5758 13.5885 4.92102 14.9643C6.26624 16.3248 7.90191 17.028 9.82803 17.0739V18.9771ZM17.6471 18.4726L14.8268 15.6293C14.521 15.8127 14.2 15.958 13.8637 16.065C13.5427 16.1567 13.1987 16.2025 12.8318 16.2025C11.7312 16.2025 10.7987 15.8204 10.0344 15.056C9.27006 14.2917 8.8879 13.3669 8.8879 12.2815C8.8879 11.1809 9.27006 10.2484 10.0344 9.48408C10.7987 8.71974 11.7312 8.33758 12.8318 8.33758C13.9172 8.33758 14.842 8.71974 15.6064 9.48408C16.3707 10.2484 16.7529 11.1732 16.7529 12.2586C16.7529 12.6408 16.6994 13 16.5924 13.3363C16.5006 13.6726 16.3631 13.986 16.1796 14.2764L19 17.1197L17.6471 18.4726ZM12.8089 14.2994C13.3745 14.2994 13.8561 14.1083 14.2535 13.7261C14.651 13.3287 14.8497 12.8471 14.8497 12.2815C14.8497 11.7159 14.651 11.2344 14.2535 10.8369C13.8713 10.4395 13.3975 10.2408 12.8318 10.2408C12.2662 10.2408 11.7847 10.4395 11.3873 10.8369C10.9898 11.2191 10.7911 11.693 10.7911 12.2586C10.7911 12.8242 10.9822 13.3057 11.3643 13.7032C11.7618 14.1006 12.2433 14.2994 12.8089 14.2994Z">
        </path>
      </g>
      <g id="globe" viewBox="0 0 20 20">
        <path
          d="M9.99987 16.7167C9.07765 16.7167 8.20543 16.5444 7.3832 16.2C6.57209 15.8444 5.86098 15.3611 5.24987 14.75C4.63876 14.1389 4.15543 13.4278 3.79987 12.6167C3.45543 11.7944 3.2832 10.9222 3.2832 9.99999C3.2832 9.07777 3.45543 8.2111 3.79987 7.39999C4.15543 6.57777 4.63876 5.8611 5.24987 5.24999C5.86098 4.63888 6.57209 4.1611 7.3832 3.81666C8.20543 3.4611 9.07765 3.28333 9.99987 3.28333C10.9221 3.28333 11.7888 3.4611 12.5999 3.81666C13.4221 4.1611 14.1388 4.63888 14.7499 5.24999C15.361 5.8611 15.8388 6.57777 16.1832 7.39999C16.5388 8.2111 16.7165 9.07777 16.7165 9.99999C16.7165 10.9222 16.5388 11.7944 16.1832 12.6167C15.8388 13.4278 15.361 14.1389 14.7499 14.75C14.1388 15.3611 13.4221 15.8444 12.5999 16.2C11.7888 16.5444 10.9221 16.7167 9.99987 16.7167ZM9.9832 15.05C10.1499 14.8722 10.3276 14.5278 10.5165 14.0167C10.7054 13.4944 10.8499 12.9389 10.9499 12.35H9.04987C9.14987 12.9389 9.28876 13.4944 9.46654 14.0167C9.64431 14.5278 9.81654 14.8722 9.9832 15.05ZM8.51654 14.8833C8.34987 14.5611 8.21098 14.1833 8.09987 13.75C7.99987 13.3167 7.91098 12.85 7.8332 12.35H5.49987C5.81098 12.9611 6.22765 13.4889 6.74987 13.9333C7.27209 14.3778 7.86098 14.6944 8.51654 14.8833ZM11.4665 14.8833C12.111 14.6944 12.6999 14.3778 13.2332 13.9333C13.7665 13.4889 14.1832 12.9611 14.4832 12.35H12.1665C12.0888 12.85 11.9943 13.3167 11.8832 13.75C11.7721 14.1833 11.6332 14.5611 11.4665 14.8833ZM12.4832 11.1667H15.0999C15.1554 10.9555 15.1943 10.7555 15.2165 10.5667C15.2388 10.3778 15.2499 10.1889 15.2499 9.99999C15.2499 9.79999 15.2388 9.60555 15.2165 9.41666C15.1943 9.22777 15.1554 9.03333 15.0999 8.83333H12.4832C12.5054 9.03333 12.5165 9.23333 12.5165 9.43332C12.5276 9.63332 12.5332 9.83333 12.5332 10.0333C12.5332 10.2222 12.5276 10.4167 12.5165 10.6167C12.5165 10.8055 12.5054 10.9889 12.4832 11.1667ZM8.89987 11.1667H11.0999C11.1221 10.9444 11.1276 10.7389 11.1165 10.55C11.1165 10.3611 11.1165 10.1778 11.1165 9.99999C11.1165 9.8111 11.1165 9.62221 11.1165 9.43332C11.1276 9.24444 11.1221 9.04444 11.0999 8.83333H8.89987C8.87765 9.04444 8.86098 9.24444 8.84987 9.43332C8.84987 9.62221 8.84987 9.8111 8.84987 9.99999C8.84987 10.1778 8.84987 10.3667 8.84987 10.5667C8.86098 10.7555 8.87765 10.9555 8.89987 11.1667ZM4.89987 11.1667H7.49987C7.47765 10.9667 7.46098 10.7667 7.44987 10.5667C7.44987 10.3555 7.44987 10.1555 7.44987 9.96666C7.44987 9.76666 7.44987 9.57221 7.44987 9.38333C7.46098 9.19444 7.47765 9.0111 7.49987 8.83333H4.89987C4.8332 9.04444 4.7832 9.24444 4.74987 9.43332C4.72765 9.6111 4.71654 9.79999 4.71654 9.99999C4.71654 10.1889 4.72765 10.3778 4.74987 10.5667C4.7832 10.7555 4.8332 10.9555 4.89987 11.1667ZM12.1665 7.64999H14.4832C14.1832 7.02777 13.7665 6.49999 13.2332 6.06666C12.6999 5.62221 12.111 5.30555 11.4665 5.11666C11.6332 5.43888 11.7721 5.81666 11.8832 6.24999C11.9943 6.68333 12.0888 7.14999 12.1665 7.64999ZM9.04987 7.64999H10.9499C10.8499 7.04999 10.7054 6.49444 10.5165 5.98333C10.3276 5.47221 10.1499 5.12777 9.9832 4.94999C9.81654 5.12777 9.64431 5.47221 9.46654 5.98333C9.28876 6.49444 9.14987 7.04999 9.04987 7.64999ZM5.49987 7.64999H7.8332C7.91098 7.14999 7.99987 6.68333 8.09987 6.24999C8.21098 5.81666 8.34987 5.43888 8.51654 5.11666C7.86098 5.30555 7.27209 5.62221 6.74987 6.06666C6.22765 6.49999 5.81098 7.02777 5.49987 7.64999Z">
        </path>
      </g>
      <g id="play" viewBox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M6 16L16 10L6 4V16Z"></path>
      </g>
      <g id="pause" viewBox="0 0 20 20">
        <path d="M9 5H6V15H9V5Z"></path>
        <path d="M14 5H11V15H14V5Z"></path>
      </g>
      <g id="fast-forward" viewBox="0 0 20 20">
        <path d="M10 10L4 14V6L10 10Z"></path>
        <path d="M10 10V14L16 10L10 6V10Z"></path>
      </g>
      <g id="calculator" viewBox="0 0 20 20">
        <path
          d="M17 1H3C1.9 1 1 1.9 1 3V17C1 18.1 1.9 19 3 19H17C18.1 19 19 18.1 19 17V3C19 1.9 18.1 1 17 1ZM17 17H3V3H17V17Z">
        </path>
        <path d="M9.25 5.72H4.25V7.22H9.25V5.72Z"></path>
        <path d="M16 13.75H11V15.25H16V13.75Z"></path>
        <path d="M16 11.25H11V12.75H16V11.25Z"></path>
        <path d="M6 16H7.5V14H9.5V12.5H7.5V10.5H6V12.5H4V14H6V16Z"></path>
        <path
          d="M12.09 8.95L13.5 7.54L14.91 8.95L15.97 7.89L14.56 6.47L15.97 5.06L14.91 4L13.5 5.41L12.09 4L11.03 5.06L12.44 6.47L11.03 7.89L12.09 8.95Z">
        </path>
      </g>
      <g id="view-all-apps" viewBox="0 0 20 20" fill="none">
        <!-- Include a <style> to set the stroke color dynamically based on color scheme (light or dark mode) -->
        <style>
          path {
            stroke: var(--cros-text-color-secondary);
            stroke-width: 1.5;
          }
        </style>
        <path
          d="M1.75 3.75H5.41427V7.41427H1.75V3.75ZM8.16787 3.75H11.8321V7.41427H8.16787V3.75ZM14.5857 3.75H18.25V7.41427H14.5857V3.75ZM14.5857 12.5857H18.25V16.25H14.5857V12.5857ZM8.16787 12.5857H11.8321V16.25H8.16787V12.5857ZM1.75 12.5857H5.41427V16.25H1.75V12.5857Z">
        </path>
      </g>
      <g id="lock" viewBox="0 0 20 20">
        <path
          d="M11.75 12.5C11.75 13.4665 10.9665 14.25 10 14.25C9.0335 14.25 8.25 13.4665 8.25 12.5C8.25 11.5335 9.0335 10.75 10 10.75C10.9665 10.75 11.75 11.5335 11.75 12.5Z">
        </path>
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M14 7H13.5V5C13.5 3.34315 11.6569 2 10 2C8.34315 2 6.5 3.34315 6.5 5V7H6C4.89543 7 4 7.89543 4 9V16C4 17.1046 4.89543 18 6 18H14C15.1046 18 16 17.1046 16 16V9C16 7.89543 15.1046 7 14 7ZM12 5.5V7H8V5.5C8 5 8.5 3.5 10 3.5C11.5 3.5 12 5 12 5.5ZM6 9V16H14V9H6Z">
        </path>
      </g>
      <g id="menu" viewBox="0 0 20 20">
        <path
          d="M7 7.5H13V6H7V7.5ZM7 14H13V12.5H7V14ZM7 10.75H13V9.25H7V10.75ZM4.5 17C4.08333 17 3.72917 16.8542 3.4375 16.5625C3.14583 16.2708 3 15.9167 3 15.5V4.5C3 4.08333 3.14583 3.72917 3.4375 3.4375C3.72917 3.14583 4.08333 3 4.5 3H15.5C15.9167 3 16.2708 3.14583 16.5625 3.4375C16.8542 3.72917 17 4.08333 17 4.5V15.5C17 15.9167 16.8542 16.2708 16.5625 16.5625C16.2708 16.8542 15.9167 17 15.5 17H4.5ZM4.5 15.5H15.5V4.5H4.5V15.5Z">
        </path>
      </g>
      <g id="launch-mail" viewBox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M16 4H4C2.9 4 2 4.9 2 6V14C2 15.1 2.9 16 4 16H16C17.1 16 18 15.1 18 14V6C18 4.9 17.1 4 16 4ZM15.5 6L10 9.5L4.5 6H15.5ZM4 14V8L10 12L16 8V14H4Z">
        </path>
      </g>
      <g id="browser-home" viewBox="0 0 20 20">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M10 2L17 8V17H3V8L10 2ZM12 15V11H8V15H5V8.91987L10 4.63416L15 8.91987V15H12Z">
        </path>
      </g>
    </defs>
  </svg>
</iron-iconset-svg>
`;document.head.appendChild(template$3.content);function getTemplate$2U(){return html`<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">#header{display:flex}:host([key-state='default-remapping']) .key-container{background-color:var(--cros-bg-color-dropped-elevation-1);border:none;box-shadow:0 1px 1px var(--cros-bg-color-dropped-elevation-1)}:host([key-state='modifier-remapped']) .key-container{background-color:var(--cros-sys-highlight_shape);border:none;box-shadow:0 1px 1px var(--cros-sys-highlight_shape)}.settings-box{justify-content:space-between;padding-inline-start:0}iron-icon{--iron-icon-fill-color:var(--cros-icon-color-secondary);--iron-icon-height:20px;--iron-icon-width:20px;align-self:center;justify-self:center}:host([remove-top-border]) .settings-box{border-top:none}</style>
<div class="settings-box">
  <div>
    <div id="keyLabelContainer" class="start key-container">
      <template is="dom-if" if="[[!keyIcon]]" restamp>
        <div id="keyLabel"
            aria-hidden="true">[[keyLabel]]</div>
      </template>
      <template is="dom-if" if="[[keyIcon]]" restamp>
        <iron-icon icon="[[keyIcon]]"></iron-icon>
      </template>
    </div>
  </div>
  <settings-dropdown-menu id="keyDropdown"
      label="[[keyLabel]]"
      pref="{{pref}}"
      menu-options="[[keyMapTargets]]">
  </settings-dropdown-menu>
</div>
<!--_html_template_end_-->`}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var KeyState;(function(KeyState){KeyState["DEFAULT_REMAPPING"]="default-remapping";KeyState["MODIFIER_REMAPPED"]="modifier-remapped"})(KeyState||(KeyState={}));const KeyboardRemapModifierKeyRowElementBase=I18nMixin(PolymerElement);class KeyboardRemapModifierKeyRowElement extends KeyboardRemapModifierKeyRowElementBase{static get is(){return"keyboard-remap-modifier-key-row"}static get properties(){return{keyLabel:{type:String,value:"",computed:"getKeyLabel(metaKey)"},metaKeyLabel:{type:String,value:"",computed:"getMetaKeyLabel(metaKey)"},keyState:{type:String,value:KeyState.DEFAULT_REMAPPING,reflectToAttribute:true,computed:"computeKeyState(pref.value, defaultRemappings.*)"},pref:{type:Object},metaKey:{type:Number},key:{type:Number},defaultRemappings:{type:Object},keyMapTargets:{type:Object},keyIcon:{type:String,value:"",computed:"getKeyIcon(key, metaKey)"},removeTopBorder:{type:Boolean,reflectToAttribute:true},hasFunctionKey:{type:Boolean,value:false}}}ready(){super.ready();this.setUpKeyMapTargets()}static get template(){return getTemplate$2U()}computeKeyState(){return this.defaultRemappings[this.key]===this.pref.value?KeyState.DEFAULT_REMAPPING:KeyState.MODIFIER_REMAPPED}getMetaKeyLabel(){switch(this.metaKey){case MetaKey$2.kCommand:{return this.i18n("perDeviceKeyboardKeyCommand")}case MetaKey$2.kExternalMeta:{return this.i18n("perDeviceKeyboardKeyMeta")}case MetaKey$2.kLauncher:case MetaKey$2.kSearch:case MetaKey$2.kLauncherRefresh:return this.i18n("perDeviceKeyboardKeySearch");default:assertNotReached()}}getKeyLabel(){switch(this.key){case ModifierKey$2.kAlt:{return this.i18n("perDeviceKeyboardKeyAlt")}case ModifierKey$2.kAssistant:{return this.i18n("perDeviceKeyboardKeyAssistant")}case ModifierKey$2.kBackspace:{return this.i18n("perDeviceKeyboardKeyBackspace")}case ModifierKey$2.kCapsLock:{return this.i18n("perDeviceKeyboardKeyCapsLock")}case ModifierKey$2.kControl:{return this.i18n("perDeviceKeyboardKeyCtrl")}case ModifierKey$2.kEscape:{return this.i18n("perDeviceKeyboardKeyEscape")}case ModifierKey$2.kMeta:{return this.getMetaKeyLabel()}case ModifierKey$2.kQuickInsert:{return this.i18n("perDeviceKeyboardKeyQuickInsert")}case ModifierKey$2.kFunction:{return this.i18n("perDeviceKeyboardKeyFunction")}default:assertNotReached("Invalid modifier key: "+this.key)}}setUpKeyMapTargets(){this.keyMapTargets=(()=>{const keyMapTargets=[{value:ModifierKey$2.kMeta,name:this.i18n("perDeviceKeyboardKeySearch")},{value:ModifierKey$2.kControl,name:this.i18n("perDeviceKeyboardKeyCtrl")},{value:ModifierKey$2.kAlt,name:this.i18n("perDeviceKeyboardKeyAlt")},{value:ModifierKey$2.kCapsLock,name:this.i18n("perDeviceKeyboardKeyCapsLock")},{value:ModifierKey$2.kEscape,name:this.i18n("perDeviceKeyboardKeyEscape")},{value:ModifierKey$2.kBackspace,name:this.i18n("perDeviceKeyboardKeyBackspace")},{value:ModifierKey$2.kAssistant,name:this.i18n("perDeviceKeyboardKeyAssistant")}];if(loadTimeData.getBoolean("enableModifierSplit")){keyMapTargets.push({value:ModifierKey$2.kQuickInsert,name:this.i18n("perDeviceKeyboardKeyQuickInsert")})}if(this.hasFunctionKey){keyMapTargets.push({value:ModifierKey$2.kFunction,name:this.i18n("perDeviceKeyboardKeyFunction")})}keyMapTargets.push({value:ModifierKey$2.kVoid,name:this.i18n("perDeviceKeyboardKeyDisabled")});return keyMapTargets})()}getKeyIcon(){if(this.key===ModifierKey$2.kMeta){if(this.metaKey===MetaKey$2.kSearch){return"cr:search"}if(this.metaKey===MetaKey$2.kLauncher){return"os-settings:launcher"}if(this.metaKey===MetaKey$2.kLauncherRefresh){return"shortcut-input-keys:launcher-refresh"}}else if(this.key===ModifierKey$2.kAssistant){return"os-settings:assistant"}else if(this.key===ModifierKey$2.kQuickInsert){return"shortcut-input-keys:quick-insert"}return""}}customElements.define(KeyboardRemapModifierKeyRowElement.is,KeyboardRemapModifierKeyRowElement);function getTemplate$2T(){return html`<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">.settings-box{justify-content:space-between;padding-inline-start:0}</style>
<div class="settings-box" id="sixPackKeyRow">
  <div>
    <div class="start key-container">
      <div id="keyLabel" aria-hidden="true">[[keyLabel]]</div>
    </div>
  </div>
  <settings-dropdown-menu id="keyDropdown"
    label="[[keyLabel]]"
    pref="{{pref}}"
    menu-options="[[computeMenuOptions(key)]]">
  </settings-dropdown-menu>
</div><!--_html_template_end_-->`}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const disabledMenuOption={value:SixPackShortcutModifier$1.kNone,name:loadTimeData.getString("sixPackKeyDisabled")};const sixPackKeyProperties={[SixPackKey.DELETE]:{menuOptions:[{value:SixPackShortcutModifier$1.kAlt,name:loadTimeData.getString("sixPackKeyDeleteAlt")},{value:SixPackShortcutModifier$1.kSearch,name:loadTimeData.getString("sixPackKeyDeleteSearch")},disabledMenuOption],label:loadTimeData.getString("sixPackKeyLabelDelete")},[SixPackKey.HOME]:{menuOptions:[{value:SixPackShortcutModifier$1.kAlt,name:loadTimeData.getString("sixPackKeyHomeAlt")},{value:SixPackShortcutModifier$1.kSearch,name:loadTimeData.getString("sixPackKeyHomeSearch")},disabledMenuOption],label:loadTimeData.getString("sixPackKeyLabelHome")},[SixPackKey.END]:{menuOptions:[{value:SixPackShortcutModifier$1.kAlt,name:loadTimeData.getString("sixPackKeyEndAlt")},{value:SixPackShortcutModifier$1.kSearch,name:loadTimeData.getString("sixPackKeyEndSearch")},disabledMenuOption],label:loadTimeData.getString("sixPackKeyLabelEnd")},[SixPackKey.INSERT]:{menuOptions:[{value:SixPackShortcutModifier$1.kSearch,name:loadTimeData.getString("sixPackKeyInsertSearch")},disabledMenuOption],label:loadTimeData.getString("sixPackKeyLabelInsert")},[SixPackKey.PAGE_DOWN]:{menuOptions:[{value:SixPackShortcutModifier$1.kAlt,name:loadTimeData.getString("sixPackKeyPageDownAlt")},{value:SixPackShortcutModifier$1.kSearch,name:loadTimeData.getString("sixPackKeyPageDownSearch")},disabledMenuOption],label:loadTimeData.getString("sixPackKeyLabelPageDown")},[SixPackKey.PAGE_UP]:{menuOptions:[{value:SixPackShortcutModifier$1.kAlt,name:loadTimeData.getString("sixPackKeyPageUpAlt")},{value:SixPackShortcutModifier$1.kSearch,name:loadTimeData.getString("sixPackKeyPageUpSearch")},disabledMenuOption],label:loadTimeData.getString("sixPackKeyLabelPageUp")}};class KeyboardSixPackKeyRowElement extends PolymerElement{static get is(){return"keyboard-six-pack-key-row"}static get template(){return getTemplate$2T()}static get properties(){return{key:{type:String},modifier:{type:Number},pref:{type:Object},keyLabel:{type:String,computed:"computeKeyLabel(key)"}}}computeMenuOptions(){assert(this.key in sixPackKeyProperties);return sixPackKeyProperties[this.key].menuOptions}computeKeyLabel(){assert(this.key in sixPackKeyProperties);return sixPackKeyProperties[this.key].label}}customElements.define(KeyboardSixPackKeyRowElement.is,KeyboardSixPackKeyRowElement);function getTemplate$2S(){return html`<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">#header{display:flex;height:24px;margin-top:12px}.subsection{margin-bottom:0}#description{color:var(--cr-secondary-text-color);font:var(--cros-button-2-font);margin-inline-start:20px}.subsection-header{color:var(--cr-secondary-text-color);font:var(--cros-body-2-font);height:24px;margin:12px 0;padding-inline-start:0}#modifierKeysHeader{margin-bottom:0}</style>
<div id="header">
  <div id="description">[[computeKeyboardKeysDescription(keyboard.*)]]</div>
</div>
<div class="subsection">
  <template is="dom-if" if="[[!isAltClickAndSixPackCustomizationEnabled]]">
    <keyboard-remap-modifier-key-row
        has-function-key="[[hasFunctionKey]]"
        default-remappings="[[defaultRemappings]]"
        key="[[modifierKey.kMeta]]" id="metaKey"
        meta-key="[[keyboard.metaKey]]"
        aria-label="[[getActionRowLabel('perDeviceKeyboardKeySearch')]]"
        pref="{{fakeMetaPref}}"
        remove-top-border>
    </keyboard-remap-modifier-key-row>
    <keyboard-remap-modifier-key-row
        has-function-key="[[hasFunctionKey]]"
        default-remappings="[[defaultRemappings]]"
        key="[[modifierKey.kControl]]" id="ctrlKey"
        meta-key="[[keyboard.metaKey]]"
        aria-label="[[getActionRowLabel('perDeviceKeyboardKeyCtrl')]]"
        pref="{{fakeCtrlPref}}">
    </keyboard-remap-modifier-key-row>
    <keyboard-remap-modifier-key-row
        has-function-key="[[hasFunctionKey]]"
        default-remappings="[[defaultRemappings]]"
        key="[[modifierKey.kAlt]]" id="altKey"
        meta-key="[[keyboard.metaKey]]"
        aria-label="[[getActionRowLabel('perDeviceKeyboardKeyAlt')]]"
        pref="{{fakeAltPref}}">
    </keyboard-remap-modifier-key-row>
    <keyboard-remap-modifier-key-row
        has-function-key="[[hasFunctionKey]]"
        default-remappings="[[defaultRemappings]]"
        key="[[modifierKey.kEscape]]" id="escapeKey"
        meta-key="[[keyboard.metaKey]]"
        aria-label="[[getActionRowLabel('perDeviceKeyboardKeyEscape')]]"
        pref="{{fakeEscPref}}">
    </keyboard-remap-modifier-key-row>
    <keyboard-remap-modifier-key-row
        has-function-key="[[hasFunctionKey]]"
        default-remappings="[[defaultRemappings]]"
        key="[[modifierKey.kBackspace]]" id="backspaceKey"
        meta-key="[[keyboard.metaKey]]"
        aria-label="[[getActionRowLabel('perDeviceKeyboardKeyBackspace')]]"
        pref="{{fakeBackspacePref}}">
    </keyboard-remap-modifier-key-row>
    <template is="dom-if" if="[[hasAssistantKey]]" restamp>
      <keyboard-remap-modifier-key-row
          has-function-key="[[hasFunctionKey]]"
          default-remappings="[[defaultRemappings]]"
          key="[[modifierKey.kAssistant]]" id="assistantKey"
          meta-key="[[keyboard.metaKey]]"
          aria-label="[[getActionRowLabel('perDeviceKeyboardKeyAssistant')]]"
          pref="{{fakeAssistantPref}}">
      </keyboard-remap-modifier-key-row>
    </template>
    <template is="dom-if" if="[[hasCapsLockKey]]" restamp>
      <keyboard-remap-modifier-key-row
          has-function-key="[[hasFunctionKey]]"
          default-remappings="[[defaultRemappings]]"
          key="[[modifierKey.kCapsLock]]" id="capsLockKey"
          meta-key="[[keyboard.metaKey]]"
          aria-label="[[getActionRowLabel('perDeviceKeyboardKeyCapsLock')]]"
          pref="{{fakeCapsLockPref}}">
      </keyboard-remap-modifier-key-row>
    </template>
  </template>
  <template is="dom-if" if="[[isAltClickAndSixPackCustomizationEnabled]]">
    <h2 class="subsection-header" id="modifierKeysHeader">
      $i18n{modifierKeysLabel}
    </h2>
    <div class="subsection">
      <keyboard-remap-modifier-key-row
          has-function-key="[[hasFunctionKey]]"
          default-remappings="[[defaultRemappings]]"
          key="[[modifierKey.kMeta]]" id="metaKey"
          meta-key="[[keyboard.metaKey]]"
          aria-label="[[getActionRowLabel('perDeviceKeyboardKeySearch')]]"
          pref="{{fakeMetaPref}}"
          remove-top-border>
      </keyboard-remap-modifier-key-row>
      <keyboard-remap-modifier-key-row
          has-function-key="[[hasFunctionKey]]"
          default-remappings="[[defaultRemappings]]"
          key="[[modifierKey.kControl]]" id="ctrlKey"
          meta-key="[[keyboard.metaKey]]"
          aria-label="[[getActionRowLabel('perDeviceKeyboardKeyCtrl')]]"
          pref="{{fakeCtrlPref}}">
      </keyboard-remap-modifier-key-row>
      <keyboard-remap-modifier-key-row
          has-function-key="[[hasFunctionKey]]"
          default-remappings="[[defaultRemappings]]"
          key="[[modifierKey.kAlt]]" id="altKey"
          meta-key="[[keyboard.metaKey]]"
          aria-label="[[getActionRowLabel('perDeviceKeyboardKeyAlt')]]"
          pref="{{fakeAltPref}}">
      </keyboard-remap-modifier-key-row>
      <keyboard-remap-modifier-key-row
          has-function-key="[[hasFunctionKey]]"
          default-remappings="[[defaultRemappings]]"
          key="[[modifierKey.kEscape]]" id="escapeKey"
          meta-key="[[keyboard.metaKey]]"
          aria-label="[[getActionRowLabel('perDeviceKeyboardKeyEscape')]]"
          pref="{{fakeEscPref}}">
      </keyboard-remap-modifier-key-row>
      <keyboard-remap-modifier-key-row
          has-function-key="[[hasFunctionKey]]"
          default-remappings="[[defaultRemappings]]"
          key="[[modifierKey.kBackspace]]" id="backspaceKey"
          meta-key="[[keyboard.metaKey]]"
          aria-label="[[getActionRowLabel('perDeviceKeyboardKeyBackspace')]]"
          pref="{{fakeBackspacePref}}">
      </keyboard-remap-modifier-key-row>
      <template is="dom-if" if="[[hasAssistantKey]]" restamp>
        <keyboard-remap-modifier-key-row
            has-function-key="[[hasFunctionKey]]"
            default-remappings="[[defaultRemappings]]"
            key="[[modifierKey.kAssistant]]" id="assistantKey"
            meta-key="[[keyboard.metaKey]]"
            aria-label="[[getActionRowLabel('perDeviceKeyboardKeyAssistant')]]"
            pref="{{fakeAssistantPref}}">
        </keyboard-remap-modifier-key-row>
      </template>
      <template is="dom-if" if="[[hasQuickInsertKey]]" restamp>
        <keyboard-remap-modifier-key-row
            has-function-key="[[hasFunctionKey]]"
            default-remappings="[[defaultRemappings]]"
            key="[[modifierKey.kQuickInsert]]" id="quickInsertKey"
            meta-key="[[keyboard.metaKey]]"
            aria-label=
                "[[getActionRowLabel('perDeviceKeyboardKeyQuickInsert')]]"
            pref="{{fakeQuickInsertPref}}">
        </keyboard-remap-modifier-key-row>
      </template>
      <template is="dom-if" if="[[hasFunctionKey]]" restamp>
        <keyboard-remap-modifier-key-row
            has-function-key="[[hasFunctionKey]]"
            default-remappings="[[defaultRemappings]]"
            key="[[modifierKey.kFunction]]" id="functionKey"
            meta-key="[[keyboard.metaKey]]"
            aria-label="[[getActionRowLabel('perDeviceKeyboardKeyFunction')]]"
            pref="{{fakeFunctionPref}}">
        </keyboard-remap-modifier-key-row>
      </template>
      <template is="dom-if" if="[[hasCapsLockKey]]" restamp>
        <keyboard-remap-modifier-key-row
            has-function-key="[[hasFunctionKey]]"
            default-remappings="[[defaultRemappings]]"
            key="[[modifierKey.kCapsLock]]" id="capsLockKey"
            meta-key="[[keyboard.metaKey]]"
            aria-label="[[getActionRowLabel('perDeviceKeyboardKeyCapsLock')]]"
            pref="{{fakeCapsLockPref}}">
        </keyboard-remap-modifier-key-row>
      </template>
    </div>
    <template is="dom-if" if="[[!hasFunctionKey]]">
      <h2 class="subsection-header" id="otherKeysHeader">
        $i18n{otherKeysLabel}
      </h2>
    </template>
    <div class="subsection">
      <template is="dom-if" if="[[!hasFunctionKey]]">
        <keyboard-six-pack-key-row id="del"
            modifier="[[keyboard.sixPackKeyRemappings.del]]"
            key="del"
            pref="{{deletePref}}"
            aria-label="[[getShortcutRowLabel('sixPackKeyLabelDelete')]]">
        </keyboard-six-pack-key-row>
        <keyboard-six-pack-key-row id="pageDown"
            modifier="[[keyboard.sixPackKeyRemappings.pageDown]]"
            key="pageDown"
            pref="{{pageDownPref}}"
            aria-label="[[getShortcutRowLabel('sixPackKeyLabelPageDown')]]">
        </keyboard-six-pack-key-row>
        <keyboard-six-pack-key-row id="pageUp"
            modifier="[[keyboard.sixPackKeyRemappings.pageUp]]"
            key="pageUp"
            pref="{{pageUpPref}}"
            aria-label="[[getShortcutRowLabel('sixPackKeyLabelPageUp')]]">
        </keyboard-six-pack-key-row>
        <keyboard-six-pack-key-row id="end"
            modifier="[[keyboard.sixPackKeyRemappings.end]]"
            key="end"
            pref="{{endPref}}"
            aria-label="[[getShortcutRowLabel('sixPackKeyLabelEnd')]]">
        </keyboard-six-pack-key-row>
        <keyboard-six-pack-key-row id="home"
            modifier="[[keyboard.sixPackKeyRemappings.home]]"
            key="home"
            pref="{{homePref}}"
            aria-label="[[getShortcutRowLabel('sixPackKeyLabelHome')]]">
        </keyboard-six-pack-key-row>
        <keyboard-six-pack-key-row id="insert"
            modifier="[[keyboard.sixPackKeyRemappings.insert]]"
            key="insert"
            pref="{{insertPref}}"
            aria-label="[[getShortcutRowLabel('sixPackKeyLabelInsert')]]">
        </keyboard-six-pack-key-row>
      </template>
      <template is="dom-if"
          if="[[shouldShowFkeys(keyboard.*, hasFunctionKey)]]">
        <fkey-row key="f11"
            aria-label="[[getShortcutRowLabel('f11KeyLabel')]]" id="f11"
            pref="{{f11KeyPref}}" keyboard="[[keyboard]]">
        </fkey-row>
        <fkey-row key="f12"
            aria-label="[[getShortcutRowLabel('f12KeyLabel')]]" id="f12"
            pref="{{f12KeyPref}}" keyboard="[[keyboard]]">
        </fkey-row>
      </template>
    </div>
  </template>
</div><!--_html_template_end_-->`}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getPrefPolicyFields(policy){if(policy){const enforcement=policy.policyStatus===PolicyStatus$1.kManaged?chrome.settingsPrivate.Enforcement.ENFORCED:chrome.settingsPrivate.Enforcement.RECOMMENDED;return{controlledBy:chrome.settingsPrivate.ControlledBy.USER_POLICY,enforcement:enforcement,recommendedValue:policy.value}}return{controlledBy:undefined,enforcement:undefined,recommendedValue:undefined}}const SettingsPerDeviceKeyboardRemapKeysElementBase=RouteObserverMixin(I18nMixin(PolymerElement));class SettingsPerDeviceKeyboardRemapKeysElement extends SettingsPerDeviceKeyboardRemapKeysElementBase{constructor(){super(...arguments);this.defaultRemappings={[ModifierKey$2.kMeta]:ModifierKey$2.kMeta,[ModifierKey$2.kControl]:ModifierKey$2.kControl,[ModifierKey$2.kAlt]:ModifierKey$2.kAlt,[ModifierKey$2.kEscape]:ModifierKey$2.kEscape,[ModifierKey$2.kBackspace]:ModifierKey$2.kBackspace,[ModifierKey$2.kAssistant]:ModifierKey$2.kAssistant,[ModifierKey$2.kCapsLock]:ModifierKey$2.kCapsLock,[ModifierKey$2.kQuickInsert]:ModifierKey$2.kQuickInsert,[ModifierKey$2.kFunction]:ModifierKey$2.kFunction};this.inputDeviceSettingsProvider=getInputDeviceSettingsProvider()}static get is(){return"settings-per-device-keyboard-remap-keys"}static get template(){return getTemplate$2S()}static get properties(){return{fakeMetaPref:{type:Object,value(){return{key:"fakeMetaKeyRemapPref",type:chrome.settingsPrivate.PrefType.NUMBER,value:ModifierKey$2.kMeta}}},fakeCtrlPref:{type:Object,value(){return{key:"fakeCtrlKeyRemapPref",type:chrome.settingsPrivate.PrefType.NUMBER,value:ModifierKey$2.kControl}}},fakeAltPref:{type:Object,value(){return{key:"fakeAltKeyRemapPref",type:chrome.settingsPrivate.PrefType.NUMBER,value:ModifierKey$2.kAlt}}},fakeEscPref:{type:Object,value(){return{key:"fakeEscKeyRemapPref",type:chrome.settingsPrivate.PrefType.NUMBER,value:ModifierKey$2.kEscape}}},fakeBackspacePref:{type:Object,value(){return{key:"fakeBackspaceKeyRemapPref",type:chrome.settingsPrivate.PrefType.NUMBER,value:ModifierKey$2.kBackspace}}},fakeAssistantPref:{type:Object,value(){return{key:"fakeAssistantKeyRemapPref",type:chrome.settingsPrivate.PrefType.NUMBER,value:ModifierKey$2.kAssistant}}},fakeCapsLockPref:{type:Object,value(){return{key:"fakeCapsLockKeyRemapPref",type:chrome.settingsPrivate.PrefType.NUMBER,value:ModifierKey$2.kCapsLock}}},fakeQuickInsertPref:{type:Object,value(){return{key:"fakeQuickInsertKeyRemapPref",type:chrome.settingsPrivate.PrefType.NUMBER,value:ModifierKey$2.kQuickInsert}}},fakeFunctionPref:{type:Object,value(){return{key:"fakeFunctionKeyRemapPref",type:chrome.settingsPrivate.PrefType.NUMBER,value:ModifierKey$2.kFunction}}},insertPref:{type:Object,value(){return{key:"insertPref",type:chrome.settingsPrivate.PrefType.NUMBER,value:SixPackShortcutModifier$1.kSearch}}},deletePref:{type:Object,value(){return{key:"deletePref",type:chrome.settingsPrivate.PrefType.NUMBER,value:SixPackShortcutModifier$1.kSearch}}},homePref:{type:Object,value(){return{key:"homePref",type:chrome.settingsPrivate.PrefType.NUMBER,value:SixPackShortcutModifier$1.kSearch}}},endPref:{type:Object,value(){return{key:"endPref",type:chrome.settingsPrivate.PrefType.NUMBER,value:SixPackShortcutModifier$1.kSearch}}},pageUpPref:{type:Object,value(){return{key:"pageUpPref",type:chrome.settingsPrivate.PrefType.NUMBER,value:SixPackShortcutModifier$1.kSearch}}},pageDownPref:{type:Object,value(){return{key:"pageDownPref",type:chrome.settingsPrivate.PrefType.NUMBER,value:SixPackShortcutModifier$1.kSearch}}},f11KeyPref:{type:Object,value(){return{key:"f11KeyPref",type:chrome.settingsPrivate.PrefType.NUMBER,value:ExtendedFkeysModifier$1.kDisabled}}},f12KeyPref:{type:Object,value(){return{key:"f12KeyPref",type:chrome.settingsPrivate.PrefType.NUMBER,value:ExtendedFkeysModifier$1.kDisabled}}},hasAssistantKey:{type:Boolean,value:false},hasCapsLockKey:{type:Boolean,value:false},hasQuickInsertKey:{type:Boolean,value:false},hasFunctionKey:{type:Boolean,value:false},keyboard:{type:Object},keyboards:{type:Array,value:undefined},metaKeyLabel:{type:String},defaultRemappings:{type:Object},isInitialized:{type:Boolean,value:false},keyboardId:{type:Number,value:-1},isAltClickAndSixPackCustomizationEnabled:{type:Boolean,value(){return loadTimeData.getBoolean("enableAltClickAndSixPackCustomization")},readOnly:true},areF11andF12KeyShortcutsEnabled:{type:Boolean,value(){return loadTimeData.getBoolean("enableF11AndF12KeyShortcuts")},readOnly:true},keyboardPolicies:{type:Object}}}static get observers(){return["onSettingsChanged(fakeMetaPref.value,"+"fakeCtrlPref.value,"+"fakeAltPref.value,"+"fakeEscPref.value,"+"fakeBackspacePref.value,"+"fakeAssistantPref.value,"+"insertPref.value,"+"pageUpPref.value,"+"pageDownPref.value,"+"endPref.value,"+"deletePref.value,"+"homePref.value,"+"f11KeyPref.value,"+"f12KeyPref.value,"+"fakeQuickInsertPref.value,"+"fakeFunctionPref.value,"+"fakeCapsLockPref.value)","onKeyboardListUpdated(keyboards.*)","onPoliciesChanged(keyboardPolicies)"]}get modifierKey(){return ModifierKey$2}currentRouteChanged(route){if(route!==routes.PER_DEVICE_KEYBOARD_REMAP_KEYS){return}if(this.hasKeyboards()&&this.keyboardId!==this.getKeyboardIdFromUrl()){this.initializeKeyboard()}}computeModifierRemappings(){const modifierRemappings=new Map;for(const modifier of Object.keys(this.keyboard.settings.modifierRemappings)){const from=Number(modifier);const to=this.keyboard.settings.modifierRemappings[from];if(to===undefined){continue}modifierRemappings.set(from,to)}return modifierRemappings}initializeKeyboard(){this.isInitialized=false;this.keyboardId=this.getKeyboardIdFromUrl();const searchedKeyboard=this.keyboards.find((keyboard=>keyboard.id===this.keyboardId));assert(!!searchedKeyboard);this.keyboard=searchedKeyboard;this.updateDefaultRemapping();this.initializePrefsToIdentity();this.hasAssistantKey=searchedKeyboard.modifierKeys.includes(ModifierKey$2.kAssistant);this.hasCapsLockKey=searchedKeyboard.modifierKeys.includes(ModifierKey$2.kCapsLock);this.hasQuickInsertKey=searchedKeyboard.modifierKeys.includes(ModifierKey$2.kQuickInsert);this.hasFunctionKey=searchedKeyboard.modifierKeys.includes(ModifierKey$2.kFunction);Array.from(this.computeModifierRemappings().keys()).forEach((originalKey=>{this.setRemappedKey(originalKey)}));if(this.isAltClickAndSixPackCustomizationEnabled){this.setSixPackKeyRemappings();this.setSixPackKeyRemappingsForPolicies()}if(this.shouldShowFkeys()){this.set("f11KeyPref.value",searchedKeyboard.settings?.f11);this.set("f12KeyPref.value",searchedKeyboard.settings?.f12);this.f11KeyPref={...this.f11KeyPref,...getPrefPolicyFields(this.keyboardPolicies?.f11KeyPolicy)};this.f12KeyPref={...this.f12KeyPref,...getPrefPolicyFields(this.keyboardPolicies?.f12KeyPolicy)}}this.isInitialized=true}keyboardWasDisconnected(id){return!this.keyboards.find((keyboard=>keyboard.id===id))}onKeyboardListUpdated(){if(Router.getInstance().currentRoute!==routes.PER_DEVICE_KEYBOARD_REMAP_KEYS){return}if(!this.hasKeyboards()||this.keyboardWasDisconnected(this.getKeyboardIdFromUrl())){this.keyboardId=-1;Router.getInstance().navigateTo(routes.PER_DEVICE_KEYBOARD);return}this.initializeKeyboard()}setSixPackKeyRemappingsForPolicies(){const homeAndEndPrefPolicyFields=getPrefPolicyFields(this.keyboardPolicies?.homeAndEndKeysPolicy);this.homePref={...this.homePref,...homeAndEndPrefPolicyFields};this.endPref={...this.endPref,...homeAndEndPrefPolicyFields};const pageUpAndPageDownPrefPolicyFields=getPrefPolicyFields(this.keyboardPolicies?.pageUpAndPageDownKeysPolicy);this.pageUpPref={...this.pageUpPref,...pageUpAndPageDownPrefPolicyFields};this.pageDownPref={...this.pageDownPref,...pageUpAndPageDownPrefPolicyFields};this.deletePref={...this.deletePref,...getPrefPolicyFields(this.keyboardPolicies?.deleteKeyPolicy)};this.insertPref={...this.insertPref,...getPrefPolicyFields(this.keyboardPolicies?.insertKeyPolicy)}}initializePrefsToIdentity(){this.set("fakeAltPref.value",ModifierKey$2.kAlt);this.set("fakeAssitantPref.value",ModifierKey$2.kAssistant);this.set("fakeBackspacePref.value",ModifierKey$2.kBackspace);this.set("fakeCtrlPref.value",ModifierKey$2.kControl);this.set("fakeCapsLockPref.value",ModifierKey$2.kCapsLock);this.set("fakeEscPref.value",ModifierKey$2.kEscape);this.set("fakeMetaPref.value",ModifierKey$2.kMeta);if(loadTimeData.getBoolean("enableModifierSplit")){this.set("fakeQuickInsertPref.value",ModifierKey$2.kQuickInsert)}if(this.hasFunctionKey){this.set("fakeFunctionPref.value",ModifierKey$2.kFunction)}}restoreDefaults(){this.inputDeviceSettingsProvider.restoreDefaultKeyboardRemappings(this.keyboardId)}setRemappedKey(originalKey){const targetKey=this.computeModifierRemappings().get(originalKey);switch(originalKey){case ModifierKey$2.kAlt:{this.set("fakeAltPref.value",targetKey);break}case ModifierKey$2.kAssistant:{this.set("fakeAssistantPref.value",targetKey);break}case ModifierKey$2.kBackspace:{this.set("fakeBackspacePref.value",targetKey);break}case ModifierKey$2.kCapsLock:{this.set("fakeCapsLockPref.value",targetKey);break}case ModifierKey$2.kControl:{this.set("fakeCtrlPref.value",targetKey);break}case ModifierKey$2.kEscape:{this.set("fakeEscPref.value",targetKey);break}case ModifierKey$2.kMeta:{this.set("fakeMetaPref.value",targetKey);break}case ModifierKey$2.kQuickInsert:{this.set("fakeQuickInsertPref.value",targetKey);break}case ModifierKey$2.kFunction:{this.set("fakeFunctionPref.value",targetKey);break}}}onSettingsChanged(){if(!this.isInitialized){return}this.keyboard.settings={...this.keyboard.settings,modifierRemappings:this.getUpdatedRemappings()};if(this.isAltClickAndSixPackCustomizationEnabled){this.keyboard.settings={...this.keyboard.settings,sixPackKeyRemappings:this.getSixPackKeyRemappings()}}if(this.shouldShowFkeys()){this.keyboard.settings={...this.keyboard.settings,f11:this.f11KeyPref.value,f12:this.f12KeyPref.value}}this.inputDeviceSettingsProvider.setKeyboardSettings(this.keyboard.id,this.keyboard.settings)}getUpdatedRemappings(){const updatedRemappings={};if(ModifierKey$2.kAlt!==this.fakeAltPref.value){updatedRemappings[ModifierKey$2.kAlt]=this.fakeAltPref.value}if(ModifierKey$2.kAssistant!==this.fakeAssistantPref.value){updatedRemappings[ModifierKey$2.kAssistant]=this.fakeAssistantPref.value}if(ModifierKey$2.kBackspace!==this.fakeBackspacePref.value){updatedRemappings[ModifierKey$2.kBackspace]=this.fakeBackspacePref.value}if(ModifierKey$2.kCapsLock!==this.fakeCapsLockPref.value){updatedRemappings[ModifierKey$2.kCapsLock]=this.fakeCapsLockPref.value}if(ModifierKey$2.kControl!==this.fakeCtrlPref.value){updatedRemappings[ModifierKey$2.kControl]=this.fakeCtrlPref.value}if(ModifierKey$2.kEscape!==this.fakeEscPref.value){updatedRemappings[ModifierKey$2.kEscape]=this.fakeEscPref.value}if(ModifierKey$2.kMeta!==this.fakeMetaPref.value){updatedRemappings[ModifierKey$2.kMeta]=this.fakeMetaPref.value}if(loadTimeData.getBoolean("enableModifierSplit")){if(ModifierKey$2.kQuickInsert!==this.fakeQuickInsertPref.value){updatedRemappings[ModifierKey$2.kQuickInsert]=this.fakeQuickInsertPref.value}}if(this.hasFunctionKey){if(ModifierKey$2.kFunction!==this.fakeFunctionPref.value){updatedRemappings[ModifierKey$2.kFunction]=this.fakeFunctionPref.value}}return updatedRemappings}updateDefaultRemapping(){this.defaultRemappings={...this.defaultRemappings,[ModifierKey$2.kMeta]:this.keyboard.metaKey===MetaKey$2.kCommand?ModifierKey$2.kControl:ModifierKey$2.kMeta,[ModifierKey$2.kControl]:this.keyboard.metaKey===MetaKey$2.kCommand?ModifierKey$2.kMeta:ModifierKey$2.kControl}}getKeyboardIdFromUrl(){return Number(Router.getInstance().getQueryParameters().get("keyboardId"))}hasKeyboards(){return this.keyboards?.length>0}computeKeyboardKeysDescription(){if(!this.keyboard?.name){return""}const keyboardName=this.keyboard.isExternal?this.keyboard.name:this.i18n("builtInKeyboardName");if(this.isAltClickAndSixPackCustomizationEnabled){return keyboardName}return this.i18n("remapKeyboardKeysDescription",keyboardName)}setSixPackKeyRemappings(){const sixPackKeyRemappings=this.keyboard.settings?.sixPackKeyRemappings;if(!sixPackKeyRemappings){return}Object.entries(sixPackKeyRemappings).forEach((([key,modifier])=>{switch(key){case SixPackKey.DELETE:this.set("deletePref.value",modifier);break;case SixPackKey.INSERT:this.set("insertPref.value",modifier);break;case SixPackKey.HOME:this.set("homePref.value",modifier);break;case SixPackKey.END:this.set("endPref.value",modifier);break;case SixPackKey.PAGE_UP:this.set("pageUpPref.value",modifier);break;case SixPackKey.PAGE_DOWN:this.set("pageDownPref.value",modifier);break}}))}getSixPackKeyRemappings(){return{home:this.homePref.value,pageUp:this.pageUpPref.value,pageDown:this.pageDownPref.value,del:this.deletePref.value,insert:this.insertPref.value,end:this.endPref.value}}shouldShowFkeys(){return this.areF11andF12KeyShortcutsEnabled&&(this.keyboard?.settings?.f11!=null&&this.keyboard?.settings?.f12!=null)&&!this.hasFunctionKey}getShortcutRowLabel(name){return this.i18n("keyboardShortcutRowDescription",this.i18n(name))}getActionRowLabel(name){return this.i18n("keyboardActionRowDescription",this.i18n(name))}onPoliciesChanged(){if(this.shouldShowFkeys()){this.f11KeyPref={...this.f11KeyPref,...getPrefPolicyFields(this.keyboardPolicies?.f11KeyPolicy)};this.f12KeyPref={...this.f12KeyPref,...getPrefPolicyFields(this.keyboardPolicies?.f12KeyPolicy)}}this.setSixPackKeyRemappingsForPolicies()}}customElements.define(SettingsPerDeviceKeyboardRemapKeysElement.is,SettingsPerDeviceKeyboardRemapKeysElement);function getTemplate$2R(){return html`<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">.settings-box:first-of-type{border-top:none}.settings-box,#mouseAcceleration,#mouseControlledScrolling{margin-left:var(--cr-section-indent-width)}#mouseReverseScrollRow{border-top:none}.subsection-subtitle{padding-top:15px}</style>
<div id="mouse">
  <per-device-subsection-header
    id="subsectionHeader"
    device-key="[[mouse.deviceKey]]"
    name="[[mouse.name]]"
    battery-info="[[mouse.batteryInfo]]"
    icon="os-settings:device-mouse">
  </per-device-subsection-header>
  <template is="dom-if" if="[[showSwapToggleButton(
      customizationRestriction, isPeripheralCustomizationEnabled_)]]">
    <settings-toggle-button id="mouseSwapToggleButton"
        label="$i18n{mouseSwapButtonsLabel}" pref="{{primaryRightPref}}">
    </settings-toggle-button>
  </template>
  <template is="dom-if" if="[[showInstallAppRow(mouse.appInfo)]]">
    <per-device-install-row app-info="[[mouse.appInfo]]">
    </per-device-install-row>
  </template>
  <div class="subsection">
    <h2 class="subsection-subtitle">$i18n{mouseCursor}</h2>
    <template is="dom-if" if="[[!isPeripheralCustomizationEnabled_]]">
      <div class="settings-box">
        <div class="start settings-box-text" id="mouseSwapButtonLabel">
          $i18n{mouseSwapButtonsLabel}
        </div>
        <settings-dropdown-menu id="mouseSwapButtonDropdown"
            aria-describedby="mouseName"
            label="$i18n{mouseSwapButtonsLabel}"
            pref="{{primaryRightPref}}"
            menu-options="[[swapPrimaryOptions_]]"
            deep-link-focus-id$="[[Setting.kMouseSwapPrimaryButtons]]">
        </settings-dropdown-menu>
      </div>
    </template>
    <settings-toggle-button id="mouseAcceleration"
        class="hr"
        pref="{{accelerationPref}}"
        label="[[getCursorAccelerationString()]]"
        sub-label="$i18n{mouseAccelerationDescription}"
        aria-describedby="mouseName"
        deep-link-focus-id$="[[Setting.kMouseAcceleration]]">
    </settings-toggle-button>
    <div class="settings-box">
      <div class="start" id="mouseSpeedLabel" aria-hidden="true">
        [[getCursorSpeedString()]]
      </div>
      <settings-slider id="mouseSpeedSlider"
          pref="{{sensitivityPref}}"
          ticks="[[sensitivityValues_]]"
          aria-describedby="mouseName"
          label-aria="[[getCursorSpeedString()]]"
          label-min="$i18n{pointerSlow}"
          label-max="$i18n{pointerFast}"
          deep-link-focus-id$="[[Setting.kMouseSpeed]]">
      </settings-slider>
    </div>
    <h2 class="hr">$i18n{mouseScrolling}</h2>
    <div class="settings-box bottom-divider" id="mouseReverseScrollRow"
          on-click="onMouseReverseScrollRowClicked_" actionable-row>
      <div class="start settings-box-text">
        <localized-link
            aria-describedby="mouseName"
            on-click="onLearnMoreLinkClicked_"
            id="enableMouseReverseScrollingLabel"
            localized-string="$i18n{mouseReverseScrollLabel}"
            link-url="$i18n{naturalScrollLearnMoreLink}">
        </localized-link>
        <div class="secondary">
          $i18n{mouseReverseScrollDescription}
        </div>
      </div>
      <cr-toggle id="mouseReverseScroll"
          checked="{{reverseScrollValue}}"
          aria-describedby="mouseName"
          aria-label=
              "[[getLabelWithoutLearnMore('mouseReverseScrollLabel')]]"
          deep-link-focus-id$="[[Setting.kMouseReverseScrolling]]">
      </cr-toggle>
    </div>
    <div class="settings-box bottom-divider" id="mouseControlledScrollingRow"
         on-click="onMouseControlledScrollingRowClicked_" actionable-row>
      <div class="start settings-box-text">
        <localized-link
          aria-describedby="mouseName"
          on-click="onLearnMoreLinkClicked_"
          id="enableMouseControlledScrollingLabel"
          localized-string="$i18n{mouseControlledScrollingLabel}"
          link-url="$i18n{controlledScrollingLearnMoreLink}">
        </localized-link>
      </div>
      <cr-toggle id="mouseControlledScrolling"
                 checked="{{!scrollAccelerationValue}}"
                 aria-describedby="mouseName"
                 aria-label=
                 "[[getLabelWithoutLearnMore('mouseControlledScrollingLabel')]]"
                 deep-link-focus-id$="[[Setting.kMouseScrollAcceleration]]">
      </cr-toggle>
    </div>
    <div class="settings-box">
      <div class="start" id="mouseScrollSpeedLabel" aria-hidden="true">
        $i18n{mouseScrollSpeed}
      </div>
      <settings-slider id="mouseScrollSpeedSlider"
                       pref="{{scrollSensitivityPref}}"
                       ticks="[[sensitivityValues_]]"
                       aria-describedby="mouseName"
                       label-aria="$i18n{mouseScrollSpeed}"
                       label-min="$i18n{pointerSlow}"
                       label-max="$i18n{pointerFast}"
                       disabled="[[mouse.settings.scrollAcceleration]]"
                       aria-disabled="[[mouse.settings.scrollAcceleration]]">
      </settings-slider>
    </div>
    <template is="dom-if" if="[[showCustomizeButtonRow(
        customizationRestriction,isPeripheralCustomizationEnabled_)]]">
      <cr-link-row id="customizeMouseButtons"
        class="hr bottom-divider" on-click="onCustomizeButtonsClick"
        aria-describedby="mouseName"
        label="$i18n{customizeMouseButtonsTitle}">
      </cr-link-row>
    </template>
    <template is="dom-if" if="[[isCompanionAppInstalled(mouse.appInfo)]]">
      <per-device-app-installed-row id="AppInstalledRow"
          app-info="[[mouse.appInfo]]">
      </per-device-app-installed-row>
    </template>
  </div>
</div>
<!--_html_template_end_-->`}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsPerDeviceMouseSubsectionElementBase=DeepLinkingMixin(RouteObserverMixin(I18nMixin(PolymerElement)));class SettingsPerDeviceMouseSubsectionElement extends SettingsPerDeviceMouseSubsectionElementBase{constructor(){super(...arguments);this.supportedSettingIds=new Set([Setting.kMouseSwapPrimaryButtons,Setting.kMouseReverseScrolling,Setting.kMouseAcceleration,Setting.kMouseScrollAcceleration,Setting.kMouseSpeed]);this.isInitialized=false;this.inputDeviceSettingsProvider=getInputDeviceSettingsProvider()}static get is(){return"settings-per-device-mouse-subsection"}static get template(){return getTemplate$2R()}static get properties(){return{isPeripheralCustomizationEnabled_:{type:Boolean,value(){return loadTimeData.getBoolean("enablePeripheralCustomization")},readOnly:true},primaryRightPref:{type:Object,value(){return{key:"fakePrimaryRightPref",type:chrome.settingsPrivate.PrefType.BOOLEAN,value:false}}},accelerationPref:{type:Object,value(){return{key:"fakeAccelerationPref",type:chrome.settingsPrivate.PrefType.BOOLEAN,value:true}}},sensitivityPref:{type:Object,value(){return{key:"fakeSensitivityPref",type:chrome.settingsPrivate.PrefType.NUMBER,value:3}}},scrollSensitivityPref:{type:Object,value(){return{key:"fakeScrollSensitivityPref",type:chrome.settingsPrivate.PrefType.NUMBER,value:3}}},reverseScrollValue:{type:Boolean,value:false},scrollAccelerationValue:{type:Boolean,value:true},swapPrimaryOptions_:{readOnly:true,type:Array,value(){return[{value:false,name:loadTimeData.getString("primaryMouseButtonLeft")},{value:true,name:loadTimeData.getString("primaryMouseButtonRight")}]}},sensitivityValues_:{type:Array,value:[1,2,3,4,5],readOnly:true},mouse:{type:Object},mousePolicies:{type:Object},mouseIndex:{type:Number},isLastDevice:{type:Boolean,reflectToAttribute:true},customizationRestriction:{type:Object},currentMouseChanged:{type:Boolean},isWelcomeExperienceEnabled:{type:Boolean,value(){return loadTimeData.getBoolean("enableWelcomeExperience")},readOnly:true}}}static get observers(){return["onSettingsChanged(primaryRightPref.value,"+"accelerationPref.value,"+"sensitivityPref.value,"+"scrollSensitivityPref.value,"+"reverseScrollValue,"+"scrollAccelerationValue)","onPoliciesChanged(mousePolicies)","updateSettingsToCurrentPrefs(mouse)"]}currentRouteChanged(route){if(route===routes.CUSTOMIZE_MOUSE_BUTTONS){return}if(route!==routes.PER_DEVICE_MOUSE){this.currentMouseChanged=false;return}if(this.mouseIndex===0){this.attemptDeepLink()}if(!Router.getInstance().lastRouteChangeWasPopstate()){return}else if(this.currentMouseChanged){this.shadowRoot.querySelector("#customizeMouseButtons").focus()}this.currentMouseChanged=false}showCustomizeButtonRow(){return this.customizationRestriction!==CustomizationRestriction$1.kDisallowCustomizations&&this.isPeripheralCustomizationEnabled_}showSwapToggleButton(){return this.customizationRestriction===CustomizationRestriction$1.kDisallowCustomizations&&this.isPeripheralCustomizationEnabled_}showInstallAppRow(){return this.mouse.appInfo?.state===CompanionAppState$1.kAvailable}onInstallCompanionAppButtonClicked(){window.open(this.mouse.appInfo?.actionLink)}updateSettingsToCurrentPrefs(){this.isInitialized=false;this.set("primaryRightPref.value",this.mouse.settings.swapRight);this.set("accelerationPref.value",this.mouse.settings.accelerationEnabled);this.set("sensitivityPref.value",this.mouse.settings.sensitivity);this.set("scrollSensitivityPref.value",this.mouse.settings.scrollSensitivity);this.reverseScrollValue=this.mouse.settings.reverseScrolling;this.scrollAccelerationValue=this.mouse.settings.scrollAcceleration;this.customizationRestriction=this.mouse.customizationRestriction;this.isInitialized=true}onPoliciesChanged(){this.primaryRightPref={...this.primaryRightPref,...getPrefPolicyFields$1(this.mousePolicies.swapRightPolicy)}}onLearnMoreLinkClicked_(event){const path=event.composedPath();if(!Array.isArray(path)||!path.length){return}if(path[0].tagName==="A"){event.stopPropagation()}}onMouseReverseScrollRowClicked_(){this.reverseScrollValue=!this.reverseScrollValue}onMouseControlledScrollingRowClicked_(){this.scrollAccelerationValue=!this.scrollAccelerationValue}onSettingsChanged(){if(!this.isInitialized){return}const newSettings={...this.mouse.settings,swapRight:this.primaryRightPref.value,accelerationEnabled:this.accelerationPref.value,sensitivity:this.sensitivityPref.value,scrollSensitivity:this.scrollSensitivityPref.value,reverseScrolling:this.reverseScrollValue,scrollAcceleration:this.scrollAccelerationValue};if(settingsAreEqual(newSettings,this.mouse.settings)){return}this.mouse.settings=newSettings;this.inputDeviceSettingsProvider.setMouseSettings(this.mouse.id,this.mouse.settings)}getLabelWithoutLearnMore(stringName){const tempEl=document.createElement("div");const localizedString=this.i18nAdvanced(stringName);tempEl.innerHTML=localizedString;const nodesToDelete=[];tempEl.childNodes.forEach((node=>{if(node.nodeType===Node.ELEMENT_NODE&&node.nodeName==="A"){nodesToDelete.push(node);return}}));nodesToDelete.forEach((node=>{tempEl.removeChild(node)}));return tempEl.innerHTML}getCursorSpeedString(){return this.i18nAdvanced("cursorSpeed")}getCursorAccelerationString(){return this.i18nAdvanced("cursorAccelerationLabel")}onCustomizeButtonsClick(){const url=new URLSearchParams(`mouseId=${encodeURIComponent(this.mouse.id)}`);Router.getInstance().navigateTo(routes.CUSTOMIZE_MOUSE_BUTTONS,url,true);this.currentMouseChanged=true}isCompanionAppInstalled(){return this.mouse.appInfo?.state===CompanionAppState$1.kInstalled}onCompanionAppRowClick(){assert(this.mouse.appInfo);this.inputDeviceSettingsProvider.launchCompanionApp(this.mouse.appInfo.packageId||"")}}customElements.define(SettingsPerDeviceMouseSubsectionElement.is,SettingsPerDeviceMouseSubsectionElement);function getTemplate$2Q(){return html`<!--_html_template_start_--><template is="dom-repeat" items="[[mice]]"
    as="mouse" index-as="index" restamp>
  <settings-per-device-mouse-subsection mouse="[[mouse]]"
      mouse-policies="[[mousePolicies]]"
      mouse-index="[[index]]"
      is-last-device="[[computeIsLastDevice(index, mice.length)]]">
  </settings-per-device-mouse-subsection>
</template>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsPerDeviceMouseElementBase=RouteObserverMixin(I18nMixin(PolymerElement));class SettingsPerDeviceMouseElement extends SettingsPerDeviceMouseElementBase{static get is(){return"settings-per-device-mouse"}static get template(){return getTemplate$2Q()}static get properties(){return{mice:{type:Array,observer:"onMouseListUpdated"},mousePolicies:{type:Object}}}currentRouteChanged(route){if(route!==routes.PER_DEVICE_MOUSE){return}}onMouseListUpdated(newMouseList,oldMouseList){if(!oldMouseList){return}const{msgId:msgId,deviceNames:deviceNames}=getDeviceStateChangesToAnnounce(newMouseList,oldMouseList);for(const deviceName of deviceNames){getInstance().announce(this.i18n(msgId,deviceName))}}computeIsLastDevice(index){return index===this.mice.length-1}}customElements.define(SettingsPerDeviceMouseElement.is,SettingsPerDeviceMouseElement);function getTemplate$2P(){return html`<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">.settings-box:first-of-type{border-top:none}</style>
<div id="pointingStick">
  <per-device-subsection-header
      id="subsectionHeader"
      device-key="[[pointingStick.deviceKey]]"
      name="[[getPointingStickName(pointingStick.name)]]"
      icon="os-settings:device-pointing-stick">
  </per-device-subsection-header>
  <div class="subsection">
    <div class="settings-box">
      <div class="start settings-box-text"
          id="pointingStickSwapButtonLabel">
        $i18n{pointingStickPrimaryButton}
      </div>
      <settings-dropdown-menu id="pointingStickSwapButtonDropdown"
          aria-describedby="pointingStickName"
          label="$i18n{pointingStickPrimaryButton}"
          pref="{{primaryRightPref}}"
          menu-options="[[swapPrimaryOptions]]"
          deep-link-focus-id$=
              "[[Setting.kPointingStickSwapPrimaryButtons]]">
      </settings-dropdown-menu>
      </div>
      <settings-toggle-button id="pointingStickAcceleration"
          aria-describedby="pointingStickName"
          class="hr"
          pref="{{accelerationPref}}"
          label="$i18n{pointingStickAccelerationLabel}"
          deep-link-focus-id$="[[Setting.kPointingStickAcceleration]]">
      </settings-toggle-button>
      <div class="settings-box bottom-divider">
      <div class="start" id="pointingStickSpeedLabel" aria-hidden="true">
        $i18n{pointingStickSpeed}
      </div>
      <settings-slider id="pointingStickSpeedSlider"
          pref="{{sensitivityPref}}"
          ticks="[[sensitivityValues]]"
          aria-describedby="pointingStickName"
          label-aria="$i18n{pointingStickSpeed}"
          label-min="$i18n{pointerSlow}"
          label-max="$i18n{pointerFast}"
          deep-link-focus-id$="[[Setting.kPointingStickSpeed]]">
      </settings-slider>
    </div>
  </div>
</div><!--_html_template_end_-->`}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsPerDevicePointingStickSubsectionElementBase=DeepLinkingMixin(RouteObserverMixin(I18nMixin(PolymerElement)));class SettingsPerDevicePointingStickSubsectionElement extends SettingsPerDevicePointingStickSubsectionElementBase{constructor(){super(...arguments);this.supportedSettingIds=new Set([Setting.kPointingStickAcceleration,Setting.kPointingStickSpeed,Setting.kPointingStickSwapPrimaryButtons]);this.isInitialized=false;this.inputDeviceSettingsProvider=getInputDeviceSettingsProvider()}static get is(){return"settings-per-device-pointing-stick-subsection"}static get template(){return getTemplate$2P()}static get properties(){return{primaryRightPref:{type:Object,value(){return{key:"fakePrimaryRightPref",type:chrome.settingsPrivate.PrefType.BOOLEAN,value:false}}},accelerationPref:{type:Object,value(){return{key:"fakeAccelerationPref",type:chrome.settingsPrivate.PrefType.BOOLEAN,value:true}}},sensitivityPref:{type:Object,value(){return{key:"fakeSensitivityPref",type:chrome.settingsPrivate.PrefType.NUMBER,value:3}}},swapPrimaryOptions:{readOnly:true,type:Array,value(){return[{value:false,name:loadTimeData.getString("primaryMouseButtonLeft")},{value:true,name:loadTimeData.getString("primaryMouseButtonRight")}]}},sensitivityValues:{type:Array,value:[1,2,3,4,5],readOnly:true},pointingStick:{type:Object},pointingStickIndex:{type:Number},isLastDevice:{type:Boolean,reflectToAttribute:true}}}static get observers(){return["onSettingsChanged(primaryRightPref.value,"+"accelerationPref.value,"+"sensitivityPref.value)","updateSettingsToCurrentPrefs(pointingStick)"]}currentRouteChanged(route){if(route!==routes.PER_DEVICE_POINTING_STICK){return}if(this.pointingStickIndex===0){this.attemptDeepLink()}}updateSettingsToCurrentPrefs(){this.isInitialized=false;this.set("primaryRightPref.value",this.pointingStick.settings.swapRight);this.set("accelerationPref.value",this.pointingStick.settings.accelerationEnabled);this.set("sensitivityPref.value",this.pointingStick.settings.sensitivity);this.isInitialized=true}onLearnMoreLinkClicked_(event){const path=event.composedPath();if(!Array.isArray(path)||!path.length){return}if(path[0].tagName==="A"){event.stopPropagation()}}onSettingsChanged(){if(!this.isInitialized){return}const newSettings={...this.pointingStick.settings,swapRight:this.primaryRightPref.value,accelerationEnabled:this.accelerationPref.value,sensitivity:this.sensitivityPref.value};if(settingsAreEqual(newSettings,this.pointingStick.settings)){return}this.pointingStick.settings=newSettings;this.inputDeviceSettingsProvider.setPointingStickSettings(this.pointingStick.id,this.pointingStick.settings)}getPointingStickName(){return this.pointingStick.isExternal?this.pointingStick.name:this.i18n("builtInPointingStickName")}}customElements.define(SettingsPerDevicePointingStickSubsectionElement.is,SettingsPerDevicePointingStickSubsectionElement);function getTemplate$2O(){return html`<!--_html_template_start_--><template is="dom-repeat" items="[[pointingSticks]]"
    as="pointingStick" index-as="index" restamp>
  <settings-per-device-pointing-stick-subsection
      pointing-stick="[[pointingStick]]"
      pointing-stick-index="[[index]]"
      is-last-device="[[computeIsLastDevice(index, pointingSticks.length)]]">
  </settings-per-device-pointing-stick-subsection>
</template>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsPerDevicePointingStickElementBase=RouteObserverMixin(I18nMixin(PolymerElement));class SettingsPerDevicePointingStickElement extends SettingsPerDevicePointingStickElementBase{static get is(){return"settings-per-device-pointing-stick"}static get template(){return getTemplate$2O()}static get properties(){return{pointingSticks:{type:Array,observer:"onPointingStickListUpdated"}}}currentRouteChanged(route){if(route!==routes.PER_DEVICE_POINTING_STICK){return}}onPointingStickListUpdated(newPointingStickList,oldPointingStickList){if(!oldPointingStickList){return}const{msgId:msgId,deviceNames:deviceNames}=getDeviceStateChangesToAnnounce(newPointingStickList,oldPointingStickList);for(const deviceName of deviceNames){getInstance().announce(this.i18n(msgId,deviceName))}}computeIsLastDevice(index){return index===this.pointingSticks.length-1}}customElements.define(SettingsPerDevicePointingStickElement.is,SettingsPerDevicePointingStickElement);
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var DisableTouchpadMode;(function(DisableTouchpadMode){DisableTouchpadMode[DisableTouchpadMode["NEVER"]=0]="NEVER";DisableTouchpadMode[DisableTouchpadMode["ALWAYS"]=1]="ALWAYS";DisableTouchpadMode[DisableTouchpadMode["ON_MOUSE_CONNECTED"]=2]="ON_MOUSE_CONNECTED"})(DisableTouchpadMode||(DisableTouchpadMode={}));function getTemplate$2N(){return html`<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">cr-link-row{padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-padding)}</style>
<div id="touchpad">
  <template is="dom-if" if="[[isBuiltInTrackpadDisabled_(
        prefs.settings.a11y.disable_trackpad_mode.value, mice
      )]]" restamp>
    <div id="disabledTouchpadHeader">
      <h2 aria-hidden="true" class="subsection-header bottom-divider"
          id="deviceName">
        [[getTouchpadName(touchpad.name)]]
      </h2>
      <cr-link-row id="cursorTouchpadSubpageButton" class="hr"
          label="$i18n{builtInTouchpadDisabled}"
          on-click="onDisabledTouchpadSettingsClick_"
          role-description="$i18n{subpageArrowRoleDescription}" embedded>
      </cr-link-row>
    </div>
  </template>
  <template is="dom-if" if="[[!isBuiltInTrackpadDisabled_(
        prefs.settings.a11y.disable_trackpad_mode.value, mice
      )]]" restamp>
    <div id="touchpadSettings">
      <per-device-subsection-header
          device-key="[[touchpad.deviceKey]]"
          name="[[getTouchpadName(touchpad.name)]]"
          battery-info="[[touchpad.batteryInfo]]"
          icon="os-settings:device-touchpad">
      </per-device-subsection-header>
      <div class="subsection">
        <template is="dom-if" if="[[showInstallAppRow(touchpad.appInfo)]]">
          <per-device-install-row app-info="[[touchpad.appInfo]]">
          </per-device-install-row>
        </template>
        <settings-toggle-button id="enableTapToClick"
            pref="{{enableTapToClickPref}}"
            label="$i18n{touchpadTapToClickEnabledLabel}"
            sub-label="$i18n{touchpadTapToClickDescription}"
            aria-describedby="touchpadName"
            deep-link-focus-id$="[[Setting.kTouchpadTapToClick]]">
        </settings-toggle-button>
        <template is="dom-if"
            if="[[isAltClickAndSixPackCustomizationEnabled]]">
          <div id="simulateRightClickContainer" class="settings-box">
            <div id="simulateRightClickLabel" aria-hidden="true"
                class="start settings-box-text">
            $i18n{touchpadSimulateRightClickLabel}
            </div>
            <settings-dropdown-menu id="simulateRightClickDropdown"
                label="$i18n{touchpadSimulateRightClickLabel}"
                pref="{{simulateRightClickPref}}"
                aria-describedby="touchpadName"
                menu-options="[[simulateRightClickOptions_]]"
                deep-link-focus-id$="[[Setting.kTouchpadSimulateRightClick]]">
            </settings-dropdown-menu>
          </div>
        </template>
        <settings-toggle-button id="enableTapDragging"
            class="hr"
            pref="{{enableTapDraggingPref}}"
            label="$i18n{tapDraggingLabel}"
            sub-label="$i18n{tapDraggingDescription}"
            aria-describedby="touchpadName"
            deep-link-focus-id$="[[Setting.kTouchpadTapDragging]]">
        </settings-toggle-button>
        <settings-toggle-button id="touchpadAcceleration"
            class="hr"
            pref="{{accelerationPref}}"
            label="$i18n{touchpadAccelerationLabel}"
            sub-label="$i18n{touchpadAccelerationDescription}"
            aria-describedby="touchpadName"
            deep-link-focus-id$="[[Setting.kTouchpadAcceleration]]">
        </settings-toggle-button>
        <div class="settings-box">
          <div class="start" id="touchpadSpeedLabel" aria-hidden="true">
          $i18n{touchpadSpeed}
          </div>
          <settings-slider id="touchpadSensitivity"
              pref="{{sensitivityPref}}"
              ticks="[[sensitivityValues_]]"
              aria-describedby="touchpadName"
              label-aria="$i18n{touchpadSpeed}"
              label-min="$i18n{pointerSlow}"
              label-max="$i18n{pointerFast}"
              deep-link-focus-id$="[[Setting.kTouchpadSpeed]]">
          </settings-slider>
        </div>
        <template is="dom-if" if="[[touchpad.isHaptic]]" restamp>
          <div class="settings-box">
            <div class="start" id="touchpadHapticClickSensitivityLabel"
                aria-hidden="true">
            $i18n{touchpadHapticClickSensitivityLabel}
            </div>
            <settings-slider id="touchpadHapticClickSensitivity"
                pref="{{hapticClickSensitivityPref}}"
                ticks="[[hapticClickSensitivityValues_]]"
                aria-describedby="touchpadName"
                label-aria="$i18n{touchpadHapticClickSensitivityLabel}"
                label-min="$i18n{touchpadHapticLightClickLabel}"
                label-max="$i18n{touchpadHapticFirmClickLabel}"
                deep-link-focus-id$=
                "[[Setting.kTouchpadHapticClickSensitivity]]">
            </settings-slider>
          </div>
          <div class="settings-box two-line" id="touchpadHapticFeedbackRow"
              on-click="onTouchpadHapticFeedbackRowClicked_" actionable-row>
            <div class="start settings-box-text">
              <div>$i18n{touchpadHapticFeedbackTitle}</div>
              <div class="secondary">
                <localized-link
                    aria-describedby="touchpadName"
                    on-click="onLearnMoreLinkClicked_"
                    id="touchpadHapticFeedbackSecondary"
                    localized-string=
                        "$i18n{touchpadHapticFeedbackSecondaryText}"
                    link-url="$i18n{hapticFeedbackLearnMoreLink}">
                </localized-link>
              </div>
            </div>
            <cr-toggle id="touchpadHapticFeedbackToggle"
                checked="{{hapticFeedbackValue}}"
                aria-describedby="touchpadName"
                aria-label=
                    "[[getLabelWithoutLearnMore(
                      'touchpadHapticFeedbackTitle'
                    )]]"
                deep-link-focus-id$="[[Setting.kTouchpadHapticFeedback]]">
            </cr-toggle>
          </div>
        </template>
        <div class="settings-box bottom-divider" id="reverseScrollRow"
            on-click="onTouchpadReverseScrollRowClicked_" actionable-row>
          <div class="start settings-box-text">
            <localized-link
                aria-describedby="touchpadName"
                on-click="onLearnMoreLinkClicked_"
                id="enableReverseScrollingLabel"
                localized-string="$i18n{touchpadScrollLabel}"
                link-url="$i18n{naturalScrollLearnMoreLink}">
            </localized-link>
            <div class="secondary">
              $i18n{touchpadScrollDescription}
            </div>
          </div>
          <cr-toggle id="enableReverseScrollingToggle"
              checked="{{reverseScrollValue}}"
              aria-describedby="touchpadName"
              aria-label=
                  "[[getLabelWithoutLearnMore('touchpadScrollLabel')]]"
              deep-link-focus-id$="[[Setting.kTouchpadReverseScrolling]]">
          </cr-toggle>
          <template is="dom-if" if="[[isCompanionAppInstalled(
                touchpad.appInfo
              )]]">
            <per-device-app-installed-row app-info="[[touchpad.appInfo]]">
            </per-device-app-installed-row>
          </template>
        </div>
      </div>
    </div>
  </template>
</div>
<!--_html_template_end_-->`}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsPerDeviceTouchpadSubsectionElementBase=RouteObserverMixin(DeepLinkingMixin(RouteObserverMixin(PrefsMixin(I18nMixin(PolymerElement)))));class SettingsPerDeviceTouchpadSubsectionElement extends SettingsPerDeviceTouchpadSubsectionElementBase{static get is(){return"settings-per-device-touchpad-subsection"}static get template(){return getTemplate$2N()}static get properties(){return{enableTapToClickPref:{type:Object,value(){return{key:"fakeEnableTapToClickPref",type:chrome.settingsPrivate.PrefType.BOOLEAN,value:true}}},enableTapDraggingPref:{type:Object,value(){return{key:"fakeEnableTapDraggingPref",type:chrome.settingsPrivate.PrefType.BOOLEAN,value:false}}},accelerationPref:{type:Object,value(){return{key:"fakeAccelerationPref",type:chrome.settingsPrivate.PrefType.BOOLEAN,value:true}}},sensitivityPref:{type:Object,value(){return{key:"fakeSensitivityPref",type:chrome.settingsPrivate.PrefType.NUMBER,value:3}}},hapticClickSensitivityPref:{type:Object,value(){return{key:"fakeHapticClickSensitivityPref",type:chrome.settingsPrivate.PrefType.NUMBER,value:3}}},simulateRightClickPref:{type:Object,value(){return{key:"fakeSimulateRightClickPref",type:chrome.settingsPrivate.PrefType.NUMBER,value:SimulateRightClickModifier$1.kNone}}},simulateRightClickOptions_:{readOnly:true,type:Array,value(){return[{value:SimulateRightClickModifier$1.kNone,name:loadTimeData.getString("touchpadSimulateRightClickOptionDisabled")},{value:SimulateRightClickModifier$1.kSearch,name:loadTimeData.getString("touchpadSimulateRightClickOptionSearch")},{value:SimulateRightClickModifier$1.kAlt,name:loadTimeData.getString("touchpadSimulateRightClickOptionAlt")}]}},sensitivityValues_:{type:Array,value:[1,2,3,4,5],readOnly:true},hapticClickSensitivityValues_:{type:Array,value(){return[{value:1,ariaValue:1},{value:3,ariaValue:2},{value:5,ariaValue:3}]},readOnly:true},reverseScrollValue:{type:Boolean,value:false},hapticFeedbackValue:{type:Boolean,value:true},touchpad:{type:Object},touchpadIndex:{type:Number},isLastDevice:{type:Boolean,reflectToAttribute:true},isAltClickAndSixPackCustomizationEnabled:{type:Boolean,value(){return loadTimeData.getBoolean("enableAltClickAndSixPackCustomization")},readOnly:true},mice:{type:Array}}}static get observers(){return["onSettingsChanged(enableTapToClickPref.value,"+"enableTapDraggingPref.value,"+"accelerationPref.value,"+"sensitivityPref.value,"+"hapticClickSensitivityPref.value,"+"simulateRightClickPref.value,"+"reverseScrollValue,"+"hapticFeedbackValue)","updateSettingsToCurrentPrefs(touchpad)"]}currentRouteChanged(route){if(route!==routes.PER_DEVICE_TOUCHPAD){return}if(this.touchpadIndex===0){this.attemptDeepLink()}}constructor(){super();this.supportedSettingIds=new Set([Setting.kTouchpadTapToClick,Setting.kTouchpadTapDragging,Setting.kTouchpadReverseScrolling,Setting.kTouchpadAcceleration,Setting.kTouchpadScrollAcceleration,Setting.kTouchpadSpeed,Setting.kTouchpadHapticFeedback,Setting.kTouchpadHapticClickSensitivity,Setting.kTouchpadSimulateRightClick]);this.isInitialized=false;this.inputDeviceSettingsProvider=getInputDeviceSettingsProvider();this.observeMouseSettings()}showInstallAppRow(){return this.touchpad.appInfo?.state===CompanionAppState$1.kAvailable}updateSettingsToCurrentPrefs(){this.isInitialized=false;this.set("enableTapToClickPref.value",this.touchpad.settings.tapToClickEnabled);this.set("simulateRightClickPref.value",this.touchpad.settings.simulateRightClick);this.set("enableTapDraggingPref.value",this.touchpad.settings.tapDraggingEnabled);this.set("accelerationPref.value",this.touchpad.settings.accelerationEnabled);this.set("sensitivityPref.value",this.touchpad.settings.sensitivity);this.set("hapticClickSensitivityPref.value",this.touchpad.settings.hapticSensitivity);this.reverseScrollValue=this.touchpad.settings.reverseScrolling;this.hapticFeedbackValue=this.touchpad.settings.hapticEnabled;this.isInitialized=true}onLearnMoreLinkClicked_(event){const path=event.composedPath();if(!Array.isArray(path)||!path.length){return}if(path[0].tagName==="A"){event.stopPropagation()}}onTouchpadReverseScrollRowClicked_(){this.reverseScrollValue=!this.reverseScrollValue}onTouchpadHapticFeedbackRowClicked_(){this.hapticFeedbackValue=!this.hapticFeedbackValue}onMouseListUpdated(mice){this.mice=mice}onMousePoliciesUpdated(_mousePolicies){}observeMouseSettings(){if(this.inputDeviceSettingsProvider instanceof FakeInputDeviceSettingsProvider){this.inputDeviceSettingsProvider.observeMouseSettings(this);return}this.mouseSettingsObserverReceiver=new MouseSettingsObserverReceiver(this);this.inputDeviceSettingsProvider.observeMouseSettings(this.mouseSettingsObserverReceiver.$.bindNewPipeAndPassRemote())}onSettingsChanged(){if(!this.isInitialized){return}const newSettings={...this.touchpad.settings,tapToClickEnabled:this.enableTapToClickPref.value,tapDraggingEnabled:this.enableTapDraggingPref.value,accelerationEnabled:this.accelerationPref.value,sensitivity:this.sensitivityPref.value,hapticSensitivity:this.hapticClickSensitivityPref.value,simulateRightClick:this.simulateRightClickPref.value,reverseScrolling:this.reverseScrollValue,hapticEnabled:this.hapticFeedbackValue};if(settingsAreEqual(newSettings,this.touchpad.settings)){return}this.touchpad.settings=newSettings;this.inputDeviceSettingsProvider.setTouchpadSettings(this.touchpad.id,this.touchpad.settings)}getTouchpadName(){return this.touchpad.isExternal?this.touchpad.name:this.i18n("builtInTouchpadName")}getLabelWithoutLearnMore(stringName){const tempEl=document.createElement("div");const localizedString=this.i18nAdvanced(stringName);tempEl.innerHTML=localizedString;const nodesToDelete=[];tempEl.childNodes.forEach((node=>{if(node.nodeType===Node.ELEMENT_NODE&&node.nodeName==="A"){nodesToDelete.push(node);return}}));nodesToDelete.forEach((node=>{tempEl.removeChild(node)}));return tempEl.innerHTML}isCompanionAppInstalled(){return this.touchpad.appInfo?.state===CompanionAppState$1.kInstalled}isBuiltInTrackpadDisabled_(trackpadMode){return!this.touchpad.isExternal&&(trackpadMode===DisableTouchpadMode.ALWAYS||trackpadMode===DisableTouchpadMode.ON_MOUSE_CONNECTED&&this.isMouseConnected_())}onDisabledTouchpadSettingsClick_(){const urlParams=new URLSearchParams({settingId:Setting.kDisableTouchpad.toString()});Router.getInstance().navigateTo(routes.A11Y_CURSOR_AND_TOUCHPAD,urlParams)}isMouseConnected_(){return this.mice&&this.mice.length!==0}}customElements.define(SettingsPerDeviceTouchpadSubsectionElement.is,SettingsPerDeviceTouchpadSubsectionElement);function getTemplate$2M(){return html`<!--_html_template_start_--><template is="dom-repeat" items="[[touchpads]]"
    as="touchpad" index-as="index" restamp>
  <settings-per-device-touchpad-subsection
      touchpad="[[touchpad]]" touchpad-index="[[index]]"
      is-last-device="[[computeIsLastDevice(index, touchpads.length)]]"
      prefs="{{prefs}}">
  </settings-per-device-touchpad-subsection>
</template>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsPerDeviceTouchpadElementBase=PrefsMixin(RouteObserverMixin(I18nMixin(PolymerElement)));class SettingsPerDeviceTouchpadElement extends SettingsPerDeviceTouchpadElementBase{static get is(){return"settings-per-device-touchpad"}static get template(){return getTemplate$2M()}static get properties(){return{touchpads:{type:Array,observer:"onTouchpadListUpdated"}}}currentRouteChanged(route){if(route!==routes.PER_DEVICE_TOUCHPAD){return}}onTouchpadListUpdated(newTouchpadList,oldTouchpadList){if(!oldTouchpadList){return}const{msgId:msgId,deviceNames:deviceNames}=getDeviceStateChangesToAnnounce(newTouchpadList,oldTouchpadList);for(const deviceName of deviceNames){getInstance().announce(this.i18n(msgId,deviceName))}}computeIsLastDevice(index){return index===this.touchpads.length-1}}customElements.define(SettingsPerDeviceTouchpadElement.is,SettingsPerDeviceTouchpadElement);function getTemplate$2L(){return html`<!--_html_template_start_--><style include="settings-shared">h2{padding-inline-start:var(--cr-section-padding)}.subsection{padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-indent-padding)}.subsection>settings-toggle-button,.subsection>.settings-box{padding-inline-end:0;padding-inline-start:0}#enableReverseScrollingToggle{border-top:none;padding-inline-end:0}</style>
<div id="mouse" hidden$="[[!hasMouse]]">
  <!-- Subsection title only appears if multiple sections are visible. -->
  <h2 hidden$="[[!showHeadings_]]">$i18n{mouseTitle}</h2>
  <div class$="[[subsectionClass_]]">
    <div class="settings-box">
      <div class="start settings-box-text" id="mouseSwapButtonLabel">
        $i18n{mouseSwapButtonsLabel}
      </div>
      <settings-dropdown-menu id="mouseSwapButtonDropdown"
          aria-labelledby="mouseSwapButtonLabel"
          pref="{{prefs.settings.mouse.primary_right}}"
          menu-options="[[swapPrimaryOptions_]]"
          deep-link-focus-id$="[[Setting.kMouseSwapPrimaryButtons]]">
      </settings-dropdown-menu>
    </div>
    <settings-toggle-button id="mouseAcceleration"
        class="hr"
        pref="{{prefs.settings.mouse.acceleration}}"
        label="[[getCursorAccelerationString()]]"
        deep-link-focus-id$="[[Setting.kMouseAcceleration]]">
    </settings-toggle-button>
    <div class="settings-box">
      <div class="start" id="mouseSpeedLabel" aria-hidden="true">
        [[getCursorSpeedString()]]
      </div>
      <settings-slider id="mouseSpeedSlider"
          pref="{{prefs.settings.mouse.sensitivity2}}"
          ticks="[[sensitivityValues_]]"
          label-aria="[[getCursorSpeedString()]]"
          label-min="$i18n{pointerSlow}"
          label-max="$i18n{pointerFast}"
          deep-link-focus-id$="[[Setting.kMouseSpeed]]">
      </settings-slider>
    </div>
    <div class="settings-box" id="mouseReverseScrollRow"
         on-click="onMouseReverseScrollRowClicked_">
      <div class="start settings-box-text">
        <localized-link
            on-click="onLearnMoreLinkClicked_"
            id="enableMouseReverseScrollingLabel"
            localized-string="$i18n{mouseReverseScrollLabel}"
            link-url="$i18n{naturalScrollLearnMoreLink}">
        </localized-link>
      </div>
      <cr-toggle id="mouseReverseScroll"
          checked="{{prefs.settings.mouse.reverse_scroll.value}}"
          aria-labelledby="enableMouseReverseScrollingLabel"
          deep-link-focus-id$="[[Setting.kMouseReverseScrolling]]">
      </cr-toggle>
    </div>
  </div>
</div>
<div id="pointingStick" hidden$="[[!hasPointingStick]]">
  <!-- Subsection title only appears if multiple sections are visible. -->
  <h2 hidden$="[[!showHeadings_]]">$i18n{pointingStickTitle}</h2>
  <div class$="[[subsectionClass_]]">
    <div class="settings-box">
      <div class="start settings-box-text"
          id="pointingStickSwapButtonLabel">
        $i18n{pointingStickPrimaryButton}
      </div>
      <settings-dropdown-menu id="pointingStickSwapButtonDropdown"
          aria-labelledby="pointingStickSwapButtonLabel"
          pref="{{prefs.settings.pointing_stick.primary_right}}"
          menu-options="[[swapPrimaryOptions_]]"
          deep-link-focus-id$=
              "[[Setting.kPointingStickSwapPrimaryButtons]]">
      </settings-dropdown-menu>
    </div>
    <settings-toggle-button id="pointingStickAcceleration"
        class="hr"
        pref="{{prefs.settings.pointing_stick.acceleration}}"
        label="$i18n{pointingStickAccelerationLabel}"
        deep-link-focus-id$="[[Setting.kPointingStickAcceleration]]">
    </settings-toggle-button>
    <div class="settings-box">
      <div class="start" id="pointingStickSpeedLabel" aria-hidden="true">
        $i18n{pointingStickSpeed}
      </div>
      <settings-slider id="pointingStickSpeedSlider"
          pref="{{prefs.settings.pointing_stick.sensitivity}}"
          ticks="[[sensitivityValues_]]"
          label-aria="$i18n{pointingStickSpeed}"
          label-min="$i18n{pointerSlow}"
          label-max="$i18n{pointerFast}"
          deep-link-focus-id$="[[Setting.kPointingStickSpeed]]">
      </settings-slider>
    </div>
  </div>
</div>
<div id="touchpad" hidden$="[[!hasTouchpad]]">
  <!-- Subsection title only appears if multiple sections are visible. -->
  <h2 hidden$="[[!showHeadings_]]">$i18n{touchpadTitle}</h2>
  <div class$="[[subsectionClass_]]">
    <settings-toggle-button id="enableTapToClick"
        pref="{{prefs.settings.touchpad.enable_tap_to_click}}"
        label="$i18n{touchpadTapToClickEnabledLabel}"
        deep-link-focus-id$="[[Setting.kTouchpadTapToClick]]">
    </settings-toggle-button>
    <settings-toggle-button id="enableTapDragging"
        class="hr"
        pref="{{prefs.settings.touchpad.enable_tap_dragging}}"
        label="$i18n{tapDraggingLabel}"
        deep-link-focus-id$="[[Setting.kTouchpadTapDragging]]">
    </settings-toggle-button>
    <settings-toggle-button id="touchpadAcceleration"
        class="hr"
        pref="{{prefs.settings.touchpad.acceleration}}"
        label="$i18n{touchpadAccelerationLabel}"
        deep-link-focus-id$="[[Setting.kTouchpadAcceleration]]">
    </settings-toggle-button>
    <div class="settings-box">
      <div class="start" id="touchpadSpeedLabel" aria-hidden="true">
        $i18n{touchpadSpeed}
      </div>
        <settings-slider id="touchpadSensitivity"
            pref="{{prefs.settings.touchpad.sensitivity2}}"
            ticks="[[sensitivityValues_]]"
            label-aria="$i18n{touchpadSpeed}"
            label-min="$i18n{pointerSlow}"
            label-max="$i18n{pointerFast}"
            deep-link-focus-id$="[[Setting.kTouchpadSpeed]]">
        </settings-slider>
    </div>
    <template is="dom-if" if="[[hasHapticTouchpad]]">
      <div class="settings-box">
        <div class="start" id="touchpadHapticClickSensitivityLabel"
            aria-hidden="true">
          $i18n{touchpadHapticClickSensitivityLabel}
        </div>
        <settings-slider id="touchpadHapticClickSensitivity"
            pref="{{prefs.settings.touchpad.haptic_click_sensitivity}}"
            ticks="[[hapticClickSensitivityValues_]]"
            label-aria="$i18n{touchpadHapticClickSensitivityLabel}"
            label-min="$i18n{touchpadHapticLightClickLabel}"
            label-max="$i18n{touchpadHapticFirmClickLabel}"
            deep-link-focus-id$=
              "[[Setting.kTouchpadHapticClickSensitivity]]">
        </settings-slider>
      </div>
      <div class="settings-box two-line" id="touchpadHapticFeedbackRow"
          on-click="onTouchpadHapticFeedbackRowClicked_">
        <div class="start settings-box-text">
          <div>$i18n{touchpadHapticFeedbackTitle}</div>
          <div class="secondary">
            <localized-link
              on-click="onLearnMoreLinkClicked_"
              id="touchpadHapticFeedbackSecondary"
              localized-string="$i18n{touchpadHapticFeedbackSecondaryText}"
              link-url="$i18n{hapticFeedbackLearnMoreLink}">
            </localized-link>
          </div>
        </div>
        <cr-toggle id="touchpadHapticFeedbackToggle"
            checked="{{prefs.settings.touchpad.haptic_feedback.value}}"
            aria-labelledby="touchpadHapticFeedbackRow"
            deep-link-focus-id$="[[Setting.kTouchpadHapticFeedback]]">
        </cr-toggle>
      </div>
    </template>
    <div class="settings-box" id="reverseScrollRow"
         on-click="onTouchpadReverseScrollRowClicked_">
      <div class="start settings-box-text">
        <localized-link
            on-click="onLearnMoreLinkClicked_"
            id="enableReverseScrollingLabel"
            localized-string="$i18n{touchpadScrollLabel}"
            link-url="$i18n{naturalScrollLearnMoreLink}">
        </localized-link>
      </div>
      <cr-toggle id="enableReverseScrollingToggle"
          checked="{{prefs.settings.touchpad.natural_scroll.value}}"
          aria-labelledby="enableReverseScrollingLabel"
          deep-link-focus-id$="[[Setting.kTouchpadReverseScrolling]]">
      </cr-toggle>
    </div>
  </div>
</div>
<!--_html_template_end_-->`}
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsPointersElementBase=DeepLinkingMixin(RouteObserverMixin(PrefsMixin(I18nMixin(PolymerElement))));class SettingsPointersElement extends SettingsPointersElementBase{constructor(){super(...arguments);this.supportedSettingIds=new Set([Setting.kTouchpadTapToClick,Setting.kTouchpadTapDragging,Setting.kTouchpadReverseScrolling,Setting.kTouchpadAcceleration,Setting.kTouchpadSpeed,Setting.kTouchpadHapticFeedback,Setting.kTouchpadHapticClickSensitivity,Setting.kPointingStickAcceleration,Setting.kPointingStickSpeed,Setting.kPointingStickSwapPrimaryButtons,Setting.kMouseSwapPrimaryButtons,Setting.kMouseReverseScrolling,Setting.kMouseAcceleration,Setting.kMouseSpeed])}static get is(){return"settings-pointers"}static get template(){return getTemplate$2L()}static get properties(){return{hasMouse:Boolean,hasPointingStick:Boolean,hasTouchpad:Boolean,hasHapticTouchpad:Boolean,swapPrimaryOptions_:{readOnly:true,type:Array,value(){return[{value:false,name:loadTimeData.getString("primaryMouseButtonLeft")},{value:true,name:loadTimeData.getString("primaryMouseButtonRight")}]}},showHeadings_:{type:Boolean,computed:"computeShowHeadings_(hasMouse, hasPointingStick, hasTouchpad)"},subsectionClass_:{type:String,computed:"computeSubsectionClass_(hasMouse, hasPointingStick, "+"hasTouchpad)"},sensitivityValues_:{type:Array,value:[1,2,3,4,5],readOnly:true},hapticClickSensitivityValues_:{type:Array,value(){return[{value:1,ariaValue:1},{value:3,ariaValue:2},{value:5,ariaValue:3}]},readOnly:true}}}computeShowHeadings_(hasMouse,hasPointingStick,hasTouchpad){const sectionVisibilities=[hasMouse,hasPointingStick,hasTouchpad];const numVisibleSections=sectionVisibilities.filter((x=>x)).length;return numVisibleSections>1}computeSubsectionClass_(hasMouse,hasPointingStick,hasTouchpad){const subsections=this.computeShowHeadings_(hasMouse,hasPointingStick,hasTouchpad);return subsections?"subsection":""}getCursorSpeedString(){return this.i18nAdvanced("cursorSpeed")}getCursorAccelerationString(){return this.i18nAdvanced("cursorAccelerationLabel")}currentRouteChanged(route){if(route!==routes.POINTERS){return}if(Router.getInstance().currentRoute===routes.POINTERS){setTimeout((()=>{Router.getInstance().setCurrentRoute(routes.DEVICE,new URLSearchParams,false)}))}this.attemptDeepLink()}onLearnMoreLinkClicked_(event){const path=event.composedPath();if(!Array.isArray(path)||!path.length){return}if(path[0].tagName==="A"){event.stopPropagation()}}onMouseReverseScrollRowClicked_(){this.setPrefValue("settings.mouse.reverse_scroll",!this.getPref("settings.mouse.reverse_scroll").value)}onTouchpadReverseScrollRowClicked_(){this.setPrefValue("settings.touchpad.natural_scroll",!this.getPref("settings.touchpad.natural_scroll").value)}onTouchpadHapticFeedbackRowClicked_(){this.setPrefValue("settings.touchpad.haptic_feedback",!this.getPref("settings.touchpad.haptic_feedback").value)}}customElements.define(SettingsPointersElement.is,SettingsPointersElement);function getTemplate$2K(){return html`<!--_html_template_start_--><style include="settings-shared">:host{--cr-dialog-width:512px;--cr-dialog-height:400px;--cr-dialog-title-slot-padding-top:32px;--cr-dialog-title-slot-padding-start:32px;--cr-dialog-title-slot-padding-end:32px;--cr-dialog-body-padding-horizontal:32px;--cr-radio-button-disc-margin-block-start:2px;--cr-dialog-button-container-padding-horizontal:32px;--cr-dialog-button-container-padding-bottom:32px}#dialogTitleIcon{fill:var(--cros-sys-primary);width:24px;height:24px;padding-left:8px;padding-right:8px;margin-bottom:20px}#dialogTitle{font-size:18px}.link{color:var(--cr-link-color)}cr-radio-button{align-items:start;padding-top:12px}cr-radio-button:not(:last-child){padding-bottom:16px}cr-radio-button:not(:first-child){padding-top:16px}cr-radio-button>div.cr-radio-button-title-text{color:var(--cr-primary-text-color)}cr-radio-button[checked]>div.cr-radio-button-title-text{font-weight:500}cr-radio-button:not([checked])>div.cr-radio-button-title-text{font-weight:400}
</style>
<cr-dialog id="dialog" show-on-attach>
  <div slot="title">
    <iron-icon id="dialogTitleIcon" icon="os-settings:battery-charging-80">
    </iron-icon>
    <div id="dialogTitle" class="title">
      $i18n{powerOptimizedChargingLabel}
    </div>
  </div>
  <div slot="body">
    <cr-radio-group id="radioGroup" selected="{{selectedOption_}}">
      <cr-radio-button id="adaptiveCharging" name="adaptive-charging">
        <div class="cr-radio-button-title-text">
          $i18n{powerAdaptiveChargingLabel}
        </div>
        <div class="cr-secondary-text flex">
          $i18n{powerAdaptiveChargingSubtext}
          <a id="learn-more" href="$i18n{powerAdaptiveChargingLearnMoreUrl}"
              aria-label="$i18n{powerAdaptiveChargingLearnMoreAriaLabel}"
              target="_blank"
              aria-description="$i18n{opensInNewTab}">
            $i18n{learnMore}
          </a>
        </div>
      </cr-radio-button>
      <cr-radio-button id="chargeLimit" name="charge-limit">
        <div class="cr-radio-button-title-text">
          $i18n{powerBatteryChargeLimitLabel}
        </div>
        <div class="cr-secondary-text flex">
          $i18n{powerBatteryChargeLimitSubtext}
        </div>
      </cr-radio-button>
    </cr-radio-group>
  </div>
  <div slot="button-container">
    <cr-button class="cancel-button" id="cancel" on-click="onCancelClick_">
        $i18n{powerOptimizedChargingDialogCancelLabel}
    </cr-button>
    <cr-button class="action-button" id="done" on-click="onDoneClick_">
        $i18n{powerOptimizedChargingDialogDoneLabel}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}
// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var OptimizedChargingButtons;(function(OptimizedChargingButtons){OptimizedChargingButtons["ADAPTIVE_CHARGING"]="adaptive-charging";OptimizedChargingButtons["CHARGE_LIMIT"]="charge-limit"})(OptimizedChargingButtons||(OptimizedChargingButtons={}));const PowerOptimizedChargingDialogElementBase=PrefsMixin(PolymerElement);class PowerOptimizedChargingDialogElement extends PowerOptimizedChargingDialogElementBase{static get is(){return"power-optimized-charging-dialog"}static get template(){return getTemplate$2K()}static get properties(){return{previousStrategy:{type:Number,computed:`getPreviousPrefValue_()`},selectedOption_:{type:String,computed:"computeButtonName_(previousStrategy)"}}}constructor(){super();this.browserProxy_=DevicePageBrowserProxyImpl.getInstance()}onDoneClick_(){const uiSelectedButton=this.$.radioGroup.selected;const newlySelectedStrategy=this.convertRadioNameToStrategyEnum_(uiSelectedButton);if(this.previousStrategy!==newlySelectedStrategy){this.setPrefValue(SettingsPowerElement.OPTIMIZED_CHARGING_STRATEGY_PREF_NAME,newlySelectedStrategy)}this.$.dialog.close()}onCancelClick_(){this.$.dialog.cancel()}computeButtonName_(strategy){switch(strategy){case OptimizedChargingStrategy.STRATEGY_ADAPTIVE_CHARGING:return OptimizedChargingButtons.ADAPTIVE_CHARGING;case OptimizedChargingStrategy.STRATEGY_CHARGE_LIMIT:return OptimizedChargingButtons.CHARGE_LIMIT;default:assertExhaustive(strategy)}}getPreviousPrefValue_(){return this.getPref(SettingsPowerElement.OPTIMIZED_CHARGING_STRATEGY_PREF_NAME).value}convertRadioNameToStrategyEnum_(radioButtonName){switch(radioButtonName){case OptimizedChargingButtons.ADAPTIVE_CHARGING:return OptimizedChargingStrategy.STRATEGY_ADAPTIVE_CHARGING;case OptimizedChargingButtons.CHARGE_LIMIT:return OptimizedChargingStrategy.STRATEGY_CHARGE_LIMIT;default:assertExhaustive(radioButtonName)}}}customElements.define(PowerOptimizedChargingDialogElement.is,PowerOptimizedChargingDialogElement);function getTemplate$2J(){return html`<!--_html_template_start_--><style include="iron-flex cr-shared-style settings-shared md-select">.indented{margin-inline-start:var(--cr-section-indent-padding);padding-inline-start:0}cr-policy-indicator{padding-inline-end:8px}.dropdown-row{--cr-section-min-height:64px}#optimizedChargingManagedIndicator{margin:0 16px}</style>
<div id="powerSourceRow" class="cr-row first"
    hidden$="[[!batteryStatus_.present]]">
  <div class="flex cr-padded-text" aria-hidden="true">
    <div id="powerSourceLabel">[[powerSourceLabel_]]</div>
    <div id="batteryStatus" class="secondary">[[batteryStatus_.statusText]]</div>
  </div>
  <select id="powerSource" class="md-select"
      hidden$="[[!showPowerSourceDropdown_]]"
      aria-labelledby="powerSourceLabel"
      aria-describedby="batteryStatus"
      on-change="onPowerSourceChange_"
      deep-link-focus-id$="[[Setting.kPowerSource]]">
    <option value="" selected="[[isEqual_('', selectedPowerSourceId_)]]">
      $i18n{powerSourceBattery}
    </option>
    <template is="dom-repeat" items="[[powerSources_]]">
      <option value="[[item.id]]"
          selected="[[isEqual_(item.id, selectedPowerSourceId_)]]">
        [[item.description]]
      </option>
    </template>
  </select>
  <div hidden$="[[showPowerSourceDropdown_]]"
      aria-labelledby="powerSourceLabel"
      aria-describedby="batteryStatus">
    [[powerSourceName_]]
  </div>
</div>

<!-- optimizedCharging -->
<template is="dom-if" if="[[!optimizedChargingHidden_]]" restamp>
  <div id="optimizedChargingSettingsRow"
      class$="[[getClassForRow_(batteryStatus_.present, 'optimizedCharging')]]">
    <div class="flex layout horizontal center">
      <div class="flex settings-box-text">
        <div id="optimizedChargingLabel">
          $i18n{powerOptimizedChargingLabel}
        </div>
        <div id="optimizedChargingSublabel" class="cr-secondary-text sub-label"
            hidden$="[[adaptiveChargingManaged_]]">
          <span class="sub-label-text">[[optimizedChargingSublabel_]]</span>
        </div>
      </div>
    </div>
    <template is="dom-if" if="[[adaptiveChargingManaged_]]">
      <cr-policy-pref-indicator id="optimizedChargingManagedIndicator"
          pref="[[adaptiveChargingPref_]]"
          icon-aria-label="$i18n{powerOptimizedChargingLabel}">
      </cr-policy-pref-indicator>
    </template>
    <cr-button id="optimizedChargingChangeButton"
        aria-label="$i18n{powerOptimizedChargingChangeAriaLabel}"
        on-click="makeOptimizedChargingDialogVisible_"
        disabled="[[adaptiveChargingManaged_]]"
        deep-link-focus-id$="[[Setting.kAdaptiveCharging]]
            [[Setting.kChargeLimit]]">
      $i18n{powerOptimizedChargingChangeLabel}
    </cr-button>
    <div class="separator"></div>
    <settings-toggle-v2 id="optimizedChargingToggle"
        aria-labelledby="optimizedChargingSublabel"
        checked="[[optimizedChargingEnabled_]]"
        on-change="onOptimizedChargingToggleChange_"
        disabled="[[adaptiveChargingManaged_]]"
        deep-link-focus-id$="[[Setting.kOptimizedCharging]]">
    </settings-toggle-v2>
  </div>
</template>


<!-- batterySaver -->
<settings-toggle-button id="batterySaverToggle"
    class$="[[getClassForRow_(batteryStatus_.present, 'batterySaver')]]"
    hidden$="[[batterySaverHidden_]]"
    pref="{{prefs.power.cros_battery_saver_active}}"
    label="$i18n{powerBatterySaverLabel}"
    sub-label="$i18n{powerBatterySaverSubtext}"
    learn-more-url="$i18n{powerBatterySaverLearnMoreUrl}"
    disabled="[[isExternalPowerAC_]]"
    deep-link-focus-id$="[[Setting.kBatterySaver]]">
</settings-toggle-button>

<!-- adaptiveCharging -->
<template is="dom-if" if="[[!batteryChargeLimitAvailable_]]" restamp>
  <settings-toggle-button id="adaptiveChargingToggle"
      class$="[[getClassForRow_(batteryStatus_.present, 'adaptiveCharging')]]"
      hidden$="[[!adaptiveChargingSupported_]]"
      pref="[[adaptiveChargingPref_]]"
      label="$i18n{powerAdaptiveChargingLabel}"
      sub-label="$i18n{powerAdaptiveChargingSubtext}"
      learn-more-url="$i18n{powerAdaptiveChargingLearnMoreUrl}"
      on-settings-boolean-control-change="onAdaptiveChargingToggleChange_"
      deep-link-focus-id$="[[Setting.kAdaptiveCharging]]"
      no-set-pref>
  </settings-toggle-button>
</template>

<!-- idle -->
<template is="dom-if" if="[[!batteryStatus_.present]]" restamp>
  <div class$="[[getClassForRow_(batteryStatus_.present, 'idle')]]">
    <div id="powerIdleLabel" class="flex" aria-label="true">
      $i18n{powerIdleLabel}
    </div>

    <template is="dom-if" if="[[acIdleManaged_]]" restamp>
      <cr-policy-indicator id="noBatteryAcIdleManagedIndicator"
          indicator-type="devicePolicy"
          icon-aria-label="$i18n{powerIdleWhileChargingAriaLabel}">
      </cr-policy-indicator>
    </template>
    <select id="noBatteryAcIdleSelect"
        class="md-select"
        on-change="onAcIdleSelectChange_"
        disabled="[[shouldAcIdleSelectBeDisabled_]]"
        aria-label="$i18n{powerIdleWhileChargingAriaLabel}"
        deep-link-focus-id$="[[Setting.kPowerIdleBehaviorWhileCharging]]">
      <template is="dom-repeat" items="[[acIdleOptions_]]">
        <option value="[[item.value]]" selected="[[item.selected]]">
          [[item.name]]
        </option>
      </template>
    </select>
  </div>
</template>

<!-- acIdle -->
<template is="dom-if" if="[[batteryStatus_.present]]" restamp>
  <div id="acIdleSettingBox"
      class$="[[getClassForRow_(batteryStatus_.present, 'acIdle')]]">
    <div class="flex" aria-hidden="true">
      $i18n{powerInactiveWhilePluggedInLabel}
    </div>
    <template is="dom-if" if="[[acIdleManaged_]]" restamp>
      <cr-policy-indicator id="acIdleManagedIndicator"
          indicator-type="devicePolicy"
          icon-aria-label="$i18n{powerIdleWhileChargingAriaLabel}">
      </cr-policy-indicator>
    </template>
    <select id="acIdleSelect" class="md-select"
        on-change="onAcIdleSelectChange_"
        disabled="[[shouldAcIdleSelectBeDisabled_]]"
        aria-label="$i18n{powerIdleWhileChargingAriaLabel}"
        deep-link-focus-id$="[[Setting.kPowerIdleBehaviorWhileCharging]]">
      <template is="dom-repeat" items="[[acIdleOptions_]]">
        <option value="[[item.value]]" selected="[[item.selected]]">
          [[item.name]]
        </option>
      </template>
    </select>
  </div>

  <div id="batteryIdleSettingBox"
      class$="[[getClassForRow_(batteryStatus_.present, 'batteryIdle')]]">
    <div class="flex" aria-hidden="true">
      $i18n{powerInactiveWhileOnBatteryLabel}
    </div>
    <template is="dom-if" if="[[batteryIdleManaged_]]" restamp>
      <cr-policy-indicator id="batteryIdleManagedIndicator"
          indicator-type="devicePolicy"
          icon-aria-label="$i18n{powerIdleWhileOnBatteryAriaLabel}">
      </cr-policy-indicator>
    </template>
    <select id="batteryIdleSelect" class="md-select"
        on-change="onBatteryIdleSelectChange_"
        disabled="[[shouldBatteryIdleSelectBeDisabled_]]"
        aria-label="$i18n{powerIdleWhileOnBatteryAriaLabel}"
        deep-link-focus-id$="[[Setting.kPowerIdleBehaviorWhileOnBattery]]">
      <template is="dom-repeat" items="[[batteryIdleOptions_]]">
        <option value="[[item.value]]" selected="[[item.selected]]">
          [[item.name]]
        </option>
      </template>
    </select>
  </div>
</template>

<settings-toggle-button id="lidClosedToggle"
  class$="[[getClassForRow_(batteryStatus_.present, 'lidClosed')]]"
  hidden$="[[!hasLid_]]" pref="[[lidClosedPref_]]" label="[[lidClosedLabel_]]"
  on-settings-boolean-control-change="onLidClosedToggleChange_" no-set-pref
  deep-link-focus-id$="[[Setting.kSleepWhenLaptopLidClosed]]">
</settings-toggle-button>

<template is="dom-if" if="[[optimizedChargingDialogVisible_]]" restamp>
  <power-optimized-charging-dialog
      id="optimizedChargingDialog"
      prefs="{{prefs}}"
      on-close="onOptimizedChargingDialogClose_">
  </power-optimized-charging-dialog>
</template>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsPowerElementBase=CrPolicyPrefMixin(DeepLinkingMixin(RouteObserverMixin(PrefsMixin(WebUiListenerMixin(I18nMixin(PolymerElement))))));class SettingsPowerElement extends SettingsPowerElementBase{static{this.OPTIMIZED_CHARGING_STRATEGY_PREF_NAME="power.optimized_charging_strategy"}static{this.ADAPTIVE_CHARGING_ENABLED_PREF_NAME="power.adaptive_charging_enabled"}static{this.CHARGE_LIMIT_ENABLED_PREF_NAME="power.charge_limit_enabled"}static get is(){return"settings-power"}static get template(){return getTemplate$2J()}static get properties(){return{selectedPowerSourceId_:String,batteryStatus_:Object,isExternalPowerUSB_:Boolean,isExternalPowerAC_:Boolean,acIdleManaged_:Boolean,batteryIdleManaged_:Boolean,lidClosedLabel_:String,hasLid_:Boolean,powerSources_:Array,powerSourceLabel_:{type:String,computed:"computePowerSourceLabel_(powerSources_, batteryStatus_.calculating)"},showPowerSourceDropdown_:{type:Boolean,computed:"computeShowPowerSourceDropdown_(powerSources_)",value:false},powerSourceName_:{type:String,computed:"computePowerSourceName_(powerSources_, isExternalPowerUSB_)"},acIdleOptions_:{type:Array,value(){return[]}},batteryIdleOptions_:{type:Array,value(){return[]}},shouldAcIdleSelectBeDisabled_:{type:Boolean,computed:"hasSingleOption_(acIdleOptions_)"},shouldBatteryIdleSelectBeDisabled_:{type:Boolean,computed:"hasSingleOption_(batteryIdleOptions_)"},adaptiveChargingSupported_:{type:Boolean,value(){return loadTimeData.getBoolean("isAdaptiveChargingSupported")}},adaptiveChargingManaged_:Boolean,lidClosedPref_:{type:Object,value(){return{}}},adaptiveChargingPref_:{type:Object,value(){return{}}},chargeLimitPref_:{type:Object,value(){return{}}},batteryChargeLimitAvailable_:{type:Boolean,value(){return isBatteryChargeLimitAvailable()}},optimizedChargingDialogVisible_:{type:Boolean,value:false},batterySaverFeatureEnabled_:Boolean,batterySaverHidden_:{type:Boolean,computed:"computeBatterySaverHidden_(batteryStatus_, batterySaverFeatureEnabled_)"},optimizedChargingSublabel_:{type:String,computed:"computeOptimizedChargingSublabel_(selectedOptimizedChargingStrategy_)"},optimizedChargingHidden_:{type:Boolean,computed:"computeOptimizedChargingHidden_(adaptiveChargingSupported_, batteryChargeLimitAvailable_)"},optimizedChargingEnabled_:{type:Boolean,computed:"computeOptimizedChargingToggleState_(adaptiveChargingPref_.value, chargeLimitPref_.value)"},selectedOptimizedChargingStrategy_:{type:Number,value:OptimizedChargingStrategy.STRATEGY_ADAPTIVE_CHARGING}}}constructor(){super();this.supportedSettingIds=new Set([Setting.kPowerIdleBehaviorWhileCharging,Setting.kPowerSource,Setting.kSleepWhenLaptopLidClosed,Setting.kPowerIdleBehaviorWhileOnBattery,Setting.kAdaptiveCharging,Setting.kBatterySaver,Setting.kOptimizedCharging,Setting.kChargeLimit]);this.browserProxy_=DevicePageBrowserProxyImpl.getInstance()}connectedCallback(){super.connectedCallback();this.addWebUiListener("battery-status-changed",this.set.bind(this,"batteryStatus_"));this.addWebUiListener("power-sources-changed",this.powerSourcesChanged_.bind(this));this.browserProxy_.updatePowerStatus();this.addWebUiListener("power-management-settings-changed",this.powerManagementSettingsChanged_.bind(this));this.browserProxy_.requestPowerManagementSettings()}beforeDeepLinkAttempt(settingId){if(settingId===Setting.kPowerSource&&this.$.powerSource.hidden){return false}return true}currentRouteChanged(route){if(route!==routes.POWER){return}this.attemptDeepLink()}computePowerSourceLabel_(powerSources,calculating){return this.i18n(calculating?"calculatingPower":powerSources&&powerSources.length?"powerSourceLabel":"powerSourceBattery")}computeShowPowerSourceDropdown_(powerSources){return powerSources.length>0&&powerSources.every((source=>!source.is_dedicated_charger))}computePowerSourceName_(powerSources,lowPowerCharger){if(lowPowerCharger){return this.i18n("powerSourceLowPowerCharger")}if(powerSources.length){return this.i18n("powerSourceAcAdapter")}return""}computeBatterySaverHidden_(batteryStatus,featureEnabled){if(batteryStatus===undefined){return true}return!featureEnabled||!batteryStatus.present}computeOptimizedChargingSublabel_(strategy){switch(strategy){case OptimizedChargingStrategy.STRATEGY_ADAPTIVE_CHARGING:return this.i18n("powerAdaptiveChargingLabel");case OptimizedChargingStrategy.STRATEGY_CHARGE_LIMIT:return this.i18n("powerBatteryChargeLimitLabel");default:return""}}computeOptimizedChargingHidden_(adaptiveChargingSupported,batteryChargeLimitAvailable){return!adaptiveChargingSupported||!batteryChargeLimitAvailable}computeOptimizedChargingToggleState_(adaptiveChargingEnabled,chargeLimitEnabled){return(adaptiveChargingEnabled??false)||(chargeLimitEnabled??false)}onPowerSourceChange_(){this.browserProxy_.setPowerSource(this.$.powerSource.value)}hasSingleOption_(idleOptions){return idleOptions.length===1}onAcIdleSelectChange_(event){const behavior=parseInt(event.target.value,10);this.browserProxy_.setIdleBehavior(behavior,true);recordSettingChange(Setting.kPowerIdleBehaviorWhileCharging,{intValue:behavior})}onBatteryIdleSelectChange_(event){const behavior=parseInt(event.target.value,10);this.browserProxy_.setIdleBehavior(behavior,false);recordSettingChange(Setting.kPowerIdleBehaviorWhileOnBattery,{intValue:behavior})}onLidClosedToggleChange_(){const enabled=this.$.lidClosedToggle.checked;this.browserProxy_.setLidClosedBehavior(enabled?LidClosedBehavior.SUSPEND:LidClosedBehavior.DO_NOTHING);recordSettingChange(Setting.kSleepWhenLaptopLidClosed,{boolValue:enabled})}onAdaptiveChargingToggleChange_(){const adaptiveChargingToggle=this.shadowRoot.querySelector("#adaptiveChargingToggle");assertExists(adaptiveChargingToggle);const enabled=adaptiveChargingToggle.checked;this.browserProxy_.setAdaptiveCharging(enabled);recordSettingChange(Setting.kAdaptiveCharging,{boolValue:enabled})}onOptimizedChargingToggleChange_(event){if(event.composed){return}const enabled=event.detail;this.toggleOptimizedChargingWithSelectedStrategy(enabled);recordSettingChange(Setting.kOptimizedCharging,{boolValue:enabled})}makeOptimizedChargingDialogVisible_(e){e.preventDefault();this.optimizedChargingDialogVisible_=true}onOptimizedChargingDialogClose_(){this.optimizedChargingDialogVisible_=false;const optimizedChargingChangeButton=this.shadowRoot.querySelector("#optimizedChargingChangeButton");assertExists(optimizedChargingChangeButton);focusWithoutInk$1(optimizedChargingChangeButton)}toggleOptimizedChargingWithSelectedStrategy(enabled){this.browserProxy_.setOptimizedCharging(this.selectedOptimizedChargingStrategy_,enabled)}powerSourcesChanged_(sources,selectedId,isExternalPowerUSB,isExternalPowerAC){this.powerSources_=sources;this.selectedPowerSourceId_=selectedId;this.isExternalPowerUSB_=isExternalPowerUSB;this.isExternalPowerAC_=isExternalPowerAC}updateLidClosedLabelAndPref_(behavior,isControlled){const pref={key:"",type:chrome.settingsPrivate.PrefType.BOOLEAN,value:true};switch(behavior){case LidClosedBehavior.SUSPEND:case LidClosedBehavior.DO_NOTHING:this.lidClosedLabel_=loadTimeData.getString("powerLidSleepLabel");pref.value=behavior===LidClosedBehavior.SUSPEND;break;case LidClosedBehavior.STOP_SESSION:this.lidClosedLabel_=loadTimeData.getString("powerLidSignOutLabel");break;case LidClosedBehavior.SHUT_DOWN:this.lidClosedLabel_=loadTimeData.getString("powerLidShutDownLabel");break}if(isControlled){pref.enforcement=chrome.settingsPrivate.Enforcement.ENFORCED;pref.controlledBy=chrome.settingsPrivate.ControlledBy.USER_POLICY}this.lidClosedPref_=pref}getIdleOption_(idleBehavior,currIdleBehavior){const selected=idleBehavior===currIdleBehavior;switch(idleBehavior){case IdleBehavior.DISPLAY_OFF_SLEEP:return{value:idleBehavior,name:loadTimeData.getString("powerIdleDisplayOffSleep"),selected:selected};case IdleBehavior.DISPLAY_OFF:return{value:idleBehavior,name:loadTimeData.getString("powerIdleDisplayOff"),selected:selected};case IdleBehavior.DISPLAY_ON:return{value:idleBehavior,name:loadTimeData.getString("powerIdleDisplayOn"),selected:selected};case IdleBehavior.SHUT_DOWN:return{value:idleBehavior,name:loadTimeData.getString("powerIdleDisplayShutDown"),selected:selected};case IdleBehavior.STOP_SESSION:return{value:idleBehavior,name:loadTimeData.getString("powerIdleDisplayStopSession"),selected:selected};default:assertNotReached("Unknown IdleBehavior type")}}updateIdleOptions_(acIdleBehaviors,batteryIdleBehaviors,currAcIdleBehavior,currBatteryIdleBehavior){this.acIdleOptions_=acIdleBehaviors.map((idleBehavior=>this.getIdleOption_(idleBehavior,currAcIdleBehavior)));this.batteryIdleOptions_=batteryIdleBehaviors.map((idleBehavior=>this.getIdleOption_(idleBehavior,currBatteryIdleBehavior)))}powerManagementSettingsChanged_(powerManagementSettings){this.updateIdleOptions_(powerManagementSettings.possibleAcIdleBehaviors||[],powerManagementSettings.possibleBatteryIdleBehaviors||[],powerManagementSettings.currentAcIdleBehavior,powerManagementSettings.currentBatteryIdleBehavior);this.acIdleManaged_=powerManagementSettings.acIdleManaged;this.batteryIdleManaged_=powerManagementSettings.batteryIdleManaged;this.hasLid_=powerManagementSettings.hasLid;this.updateLidClosedLabelAndPref_(powerManagementSettings.lidClosedBehavior,powerManagementSettings.lidClosedControlled);this.adaptiveChargingManaged_=powerManagementSettings.adaptiveChargingManaged;const adaptiveChargingPref={key:"",type:chrome.settingsPrivate.PrefType.BOOLEAN,value:powerManagementSettings.adaptiveCharging};const chargeLimitPref={key:"",type:chrome.settingsPrivate.PrefType.BOOLEAN,value:powerManagementSettings.chargeLimit};if(this.adaptiveChargingManaged_){adaptiveChargingPref.enforcement=chrome.settingsPrivate.Enforcement.ENFORCED;adaptiveChargingPref.controlledBy=chrome.settingsPrivate.ControlledBy.DEVICE_POLICY;chargeLimitPref.enforcement=chrome.settingsPrivate.Enforcement.ENFORCED;chargeLimitPref.controlledBy=chrome.settingsPrivate.ControlledBy.DEVICE_POLICY}this.adaptiveChargingPref_=adaptiveChargingPref;this.chargeLimitPref_=chargeLimitPref;this.batterySaverFeatureEnabled_=powerManagementSettings.batterySaverFeatureEnabled;if(this.selectedOptimizedChargingStrategy_!==powerManagementSettings.optimizedChargingStrategy){this.selectedOptimizedChargingStrategy_=powerManagementSettings.optimizedChargingStrategy;if(adaptiveChargingPref.value||chargeLimitPref.value){this.toggleOptimizedChargingWithSelectedStrategy(true)}}}getClassForRow_(batteryPresent,element){const classes=["cr-row"];switch(element){case"optimizedCharging":if(!batteryPresent){classes.push("first")}break;case"batterySaver":if(!batteryPresent&&this.optimizedChargingHidden_){classes.push("first")}break;case"adaptiveCharging":if(!batteryPresent&&this.optimizedChargingHidden_&&this.batterySaverHidden_){classes.push("first")}break;case"idle":if(!batteryPresent&&this.optimizedChargingHidden_&&this.batterySaverHidden_&&!this.adaptiveChargingSupported_){classes.push("first")}break;case"acIdle":if(!batteryPresent&&this.optimizedChargingHidden_&&this.batterySaverHidden_&&!this.adaptiveChargingSupported_){classes.push("first")}classes.push("dropdown-row");break;case"batteryIdle":classes.push("dropdown-row");break;case"lidClosed":classes.push("dropdown-row");break}return classes.join(" ")}isEqual_(lhs,rhs){return lhs===rhs}}customElements.define(SettingsPowerElement.is,SettingsPowerElement);function getTemplate$2I(){return html`<!--_html_template_start_--><style include="settings-shared">settings-toggle-button{margin-inline-end:var(--cr-section-padding);margin-inline-start:var(--cr-section-indent-padding);padding-inline-end:0;padding-inline-start:0}</style>
<settings-toggle-button class="hr"
    pref="{{visiblePref_}}"
    label="[[label]]"
    on-settings-boolean-control-change="onVisibleChange_">
</settings-toggle-button>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const StorageExternalEntryElementBase=PrefsMixin(WebUiListenerMixin(PolymerElement));class StorageExternalEntryElement extends StorageExternalEntryElementBase{static get is(){return"storage-external-entry"}static get template(){return getTemplate$2I()}static get properties(){return{uuid:String,label:String,visiblePref_:{type:Object,value(){return{}}}}}static get observers(){return["updateVisible_(prefs.arc.visible_external_storages.*)"]}onVisibleChange_(event){const isVisible=!!event.target.checked;if(isVisible){this.appendPrefListItem("arc.visible_external_storages",this.uuid)}else{this.deletePrefListItem("arc.visible_external_storages",this.uuid)}}updateVisible_(){const uuids=this.getPref("arc.visible_external_storages").value;const isVisible=uuids.some((id=>id===this.uuid));const pref={key:"",type:chrome.settingsPrivate.PrefType.BOOLEAN,value:isVisible};this.visiblePref_=pref}}customElements.define(StorageExternalEntryElement.is,StorageExternalEntryElement);function getTemplate$2H(){return html`<!--_html_template_start_--><style include="settings-shared">h2{padding-inline-start:var(--cr-section-padding)}#androidAppsExternalDrivesNoteContainer{padding-top:10px;padding-bottom:10px}</style>

<div id="androidAppsExternalDrivesNoteContainer" class="settings-box first">
  <localized-link
      localized-string=
          "[[i18nAdvanced('storageAndroidAppsExternalDrivesNote')]]">
  </localized-link>
</div>
<h2>[[computeStorageListHeader_(externalStorages_)]]</h2>
<iron-list id="removableDevices" preserve-focus
    items="[[externalStorages_]]">
  <template>
    <storage-external-entry uuid="[[item.uuid]]" label="[[item.label]]"
        prefs="{{prefs}}">
    </storage-external-entry>
  </template>
</iron-list>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsStorageExternalElementBase=WebUiListenerMixin(I18nMixin(PolymerElement));class SettingsStorageExternalElement extends SettingsStorageExternalElementBase{static get is(){return"settings-storage-external"}static get template(){return getTemplate$2H()}static get properties(){return{prefs:{type:Object,notify:true},externalStorages_:{type:Array,value(){return[]}}}}constructor(){super();this.browserProxy_=DevicePageBrowserProxyImpl.getInstance()}connectedCallback(){super.connectedCallback();this.browserProxy_.setExternalStoragesUpdatedCallback(this.handleExternalStoragesUpdated_.bind(this));this.browserProxy_.updateExternalStorages()}handleExternalStoragesUpdated_(storages){this.externalStorages_=storages}computeStorageListHeader_(externalStorages){return this.i18n(!externalStorages||externalStorages.length===0?"storageExternalStorageEmptyListHeader":"storageExternalStorageListHeader")}}customElements.define(SettingsStorageExternalElement.is,SettingsStorageExternalElement);function getTemplate$2G(){return html`<!--_html_template_start_--><style include="settings-shared">progress{-webkit-appearance:none;display:block;height:28px;width:100%}progress::-webkit-progress-bar{background-color:var(--cros-tab-slider-track-color);border-radius:2px}progress::-webkit-progress-value{background-color:var(--cros-icon-color-prominent);border-radius:2px}progress.space-low::-webkit-progress-value{background-color:var(--cros-icon-color-warning)}progress.space-critically-low::-webkit-progress-value{background-color:var(--cros-icon-color-alert)}iron-icon{--iron-icon-fill-color:var(--cros-icon-color-warning);--iron-icon-height:32px;--iron-icon-width:32px}#criticallyLowMessage iron-icon{--iron-icon-fill-color:var(--cros-icon-color-alert)}.storage-size{color:var(--cr-secondary-text-color)}.message-area{background-color:var(--cros-textfield-background-color);border-radius:2px;display:flex;margin:14px 0 16px;padding-bottom:12px;padding-inline-end:48px;padding-inline-start:16px;padding-top:16px;width:100%}.message-area>iron-icon{flex:none;padding-inline-end:16px}.message-title{color:var(--cros-text-color-primary);font-size:115%}.message-description{color:var(--cros-text-color-secondary);font-size:92%;line-height:1.6em;margin:1em 0}#barArea{display:flex;flex-direction:column;margin:24px 0 54px;width:100%}#barLabels{display:flex}.bar-label{display:flex;flex-direction:column}.bar-label .vertical-line{align-self:center;background-color:var(--cros-separator-color);height:8px;margin-bottom:4px;width:1px}.bar-label .wrapper{color:var(--cros-text-color-primary);text-align:center;white-space:nowrap}.end-aligned .wrapper{direction:rtl}:host-context([dir=rtl]) .end-aligned .wrapper{direction:ltr}.end-aligned .wrapper span{direction:initial;unicode-bidi:embed}</style>
<template is="dom-if" if="[[isSpaceLow_(sizeStat_.spaceState)]]">
  <div class="settings-box first">
    <div id="lowMessage" class="message-area">
      <iron-icon icon="cr:warning"></iron-icon>
      <div class="message">
        <div class="message-title">$i18n{storageSpaceLowMessageTitle}</div>
        <div class="message-description">
          <span>$i18n{storageSpaceLowMessageLine1}</span>
          <span>&nbsp;$i18n{storageSpaceLowMessageLine2}</span>
        </div>
      </div>
    </div>
  </div>
</template>
<template is="dom-if" if="[[isSpaceCriticallyLow_(sizeStat_.spaceState)]]">
  <div class="settings-box first">
    <div id="criticallyLowMessage" class="message-area">
      <iron-icon icon="cr:warning"></iron-icon>
      <div class="message">
        <div class="message-title">
          $i18n{storageSpaceCriticallyLowMessageTitle}
        </div>
        <div class="message-description">
          <span>$i18n{storageSpaceCriticallyLowMessageLine1}</span>
          <span>&nbsp;$i18n{storageSpaceCriticallyLowMessageLine2}</span>
        </div>
      </div>
    </div>
  </div>
</template>
<div class="settings-box first">
  <div id="barArea">
    <progress id="bar" class$="[[getBarClass_(sizeStat_.spaceState)]]"
        value="[[roundTo2DecimalPoints_(sizeStat_.usedRatio)]]"
        aria-label="$i18n{storageOverviewAriaLabel}"
        aria-valuetext$="[[sizeStat_.usedSize]]"
        aria-describedby="barLabels">
    </progress>
    <div id="barLabels" aria-hidden="true">
      <div id="inUseLabelArea" class="bar-label">
        <div class="vertical-line"></div>
        <div class="wrapper"><span>$i18n{storageItemInUse}</span></div>
        <div class="wrapper">
          <span class="storage-size">[[sizeStat_.usedSize]]</span>
        </div>
      </div>
      <div id="availableLabelArea" class="bar-label end-aligned">
        <div class="vertical-line"></div>
        <div class="wrapper"><span>$i18n{storageItemAvailable}</span></div>
        <div class="wrapper">
          <span class="storage-size">[[sizeStat_.availableSize]]</span>
        </div>
      </div>
    </div>
  </div>
</div>

<template is="dom-if" if="[[localUserFilesAllowed_(prefs.filebrowser.local_user_files_allowed.value)]]">
  <cr-link-row id="myFilesSizeLink" class="hr" on-click="onMyFilesClick_"
      label="$i18n{storageItemMyFiles}"
      sub-label="[[myFilesSizeSubLabel_]]"
      external>
  </cr-link-row>
</template>
<template is="dom-if" if="[[!localUserFilesAllowed_(prefs.filebrowser.local_user_files_allowed.value)]]">
  <div id="myFilesSizeDiv"
      class="settings-box two-line single-column"
      aria-describedby="myFilesSizeLabel"
      aria-labelledby="myFilesSizeLabel">
    <div id="myFilesSizeLabel" class="label" aria-hidden="true">
      $i18n{storageItemMyFiles}
    </div>
    <div id="myFilesSizeSubLabel" class="secondary label" aria-hidden="true">
      [[myFilesSizeSubLabel_]]
    </div>
  </div>
</template>

<cr-link-row id="browsingDataSize" class="hr" on-click="onBrowsingDataClick_"
    label="$i18n{storageItemBrowsingData}"
    sub-label="$i18n{storageSizeComputing}"
    external>
</cr-link-row>
<cr-link-row id="appsSize" class="hr" on-click="onAppsClick_"
    label="$i18n{storageItemApps}"
    sub-label="$i18n{storageSizeComputing}"
    external>
</cr-link-row>
<template is="dom-if" if="[[shouldShowOfflineFilesRow_(isDriveEnabled_)]]">
  <cr-link-row id="driveOfflineSize" class="hr"
      on-click="onDriveOfflineClick_"
      label="$i18n{storageItemOffline}"
      sub-label="$i18n{storageSizeComputing}"
      role-description="$i18n{subpageArrowRoleDescription}">
  </cr-link-row>
</template>
<template is="dom-if" if="[[showCrostiniStorage_]]">
  <cr-link-row id="crostiniSize" class="hr" on-click="onCrostiniClick_"
      label="$i18n{storageItemCrostini}"
      sub-label="$i18n{storageSizeComputing}"
      role-description="$i18n{subpageArrowRoleDescription}">
  </cr-link-row>
</template>
<template is="dom-if" if="[[showOtherUsers_]]">
  <cr-link-row id="otherUsersSize" class="hr" on-click="onOtherUsersClick_"
      label="$i18n{storageItemOtherUsers}"
      sub-label="$i18n{storageSizeComputing}"
      role-description="$i18n{subpageArrowRoleDescription}">
  </cr-link-row>
</template>
<template is="dom-if" if="[[!isEphemeralUser_]]">
  <div id="systemSize"
      class="settings-box two-line single-column stretch settings-box-text"
      aria-describedby="systemSizeSubLabel"
      aria-labelledby="systemSizeLabel">
    <div id="systemSizeLabel" class="label" aria-hidden="true">
      $i18n{storageItemSystem}
    </div>
    <div id="systemSizeSubLabel" class="secondary label" aria-hidden="true">
      $i18n{storageSizeComputing}
    </div>
  </div>
</template>
<template is="dom-if" if="[[!isEphemeralUser_]]">
  <div id="systemEncryption"
      class="settings-box two-line single-column stretch settings-box-text"
      aria-describedby="systemEncryptionSubLabel"
      aria-labelledby="systemEncryptionLabel">
    <div id="systemEncryptionLabel" class="label" aria-hidden="true">
      $i18n{storageItemEncryption}
    </div>
    <div id="systemEncryptionSubLabel"
        class="secondary label" aria-hidden="true">
      [[storageEncryptionSubLabel_]]
    </div>
  </div>
</template>
<template is="dom-if" if="[[isExternalStorageEnabled_]]">
  <cr-link-row id="externalStoragePreferences" class="hr"
      on-click="onExternalStoragePreferencesClick_"
      label="$i18n{storageExternal}"
      role-description="$i18n{subpageArrowRoleDescription}">
  </cr-link-row>
</template>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsStorageElementBase=I18nMixin(PrefsMixin(RouteOriginMixin(WebUiListenerMixin(PolymerElement))));class SettingsStorageElement extends SettingsStorageElementBase{static get is(){return"settings-storage"}static get template(){return getTemplate$2G()}static get properties(){return{showCrostiniStorage_:{type:Boolean,value:false},isDriveEnabled_:{type:Boolean,value:true},isEphemeralUser_:{type:Boolean,value(){return loadTimeData.getBoolean("isCryptohomeDataEphemeral")}},isExternalStorageEnabled_:{type:Boolean,value:()=>isExternalStorageEnabled()},showOtherUsers_:{type:Boolean,value(){return!loadTimeData.getBoolean("isCryptohomeDataEphemeral")}},isSkyVaultEnabled_:{type:Boolean,value(){return isSkyVaultEnabled()}},myFilesSizeSubLabel_:{type:String,value(){return this.i18n("storageSizeComputing")}},storageEncryptionSubLabel_:{type:String,value(){return this.i18n("storageSizeComputing")}},sizeStat_:Object}}static get observers(){return["handleCrostiniEnabledChanged_(prefs.crostini.enabled.value)","handleDriveDisabledChanged_(prefs.gdata.disabled.value)"]}constructor(){super();this.route=routes.STORAGE;this.updateTimerId_=-1;this.browserProxy_=DevicePageBrowserProxyImpl.getInstance()}connectedCallback(){super.connectedCallback();this.addWebUiListener("storage-size-stat-changed",(sizeStat=>this.handleSizeStatChanged_(sizeStat)));this.addWebUiListener("storage-my-files-size-changed",(size=>this.handleMyFilesSizeChanged_(size)));this.addWebUiListener("storage-browsing-data-size-changed",(size=>this.handleBrowsingDataSizeChanged_(size)));this.addWebUiListener("storage-apps-size-changed",(size=>this.handleAppsSizeChanged_(size)));this.addWebUiListener("storage-drive-offline-size-changed",(size=>this.handleDriveOfflineSizeChanged_(size)));this.addWebUiListener("storage-crostini-size-changed",(size=>this.handleCrostiniSizeChanged_(size)));if(this.showOtherUsers_){this.addWebUiListener("storage-other-users-size-changed",((size,noOtherUsers)=>this.handleOtherUsersSizeChanged_(size,noOtherUsers)));this.addWebUiListener("storage-system-size-changed",(size=>this.handleSystemSizeChanged_(size)))}if(!this.isEphemeralUser_){this.browserProxy_.getStorageEncryptionInfo().then((encryptionInfo=>{this.storageEncryptionSubLabel_=encryptionInfo}),(reason=>{console.warn(`Unable to get info: ${reason}`)}))}}ready(){super.ready();const r=routes;this.addFocusConfig(r.CROSTINI_DETAILS,"#crostiniSize");this.addFocusConfig(r.ACCOUNTS,"#otherUsersSize");this.addFocusConfig(r.EXTERNAL_STORAGE_PREFERENCES,"#externalStoragePreferences");this.addFocusConfig(r.APP_MANAGEMENT,"#appsSize")}currentRouteChanged(newRoute,oldRoute){super.currentRouteChanged(newRoute,oldRoute);if(newRoute!==this.route){return}this.onPageShown_()}onPageShown_(){this.browserProxy_.updateStorageInfo();this.startPeriodicUpdate_()}onMyFilesClick_(){if(this.localUserFilesAllowed_(this.getPref("filebrowser.local_user_files_allowed").value)){this.browserProxy_.openMyFiles()}}onBrowsingDataClick_(){this.browserProxy_.openBrowsingDataSettings()}onAppsClick_(){Router.getInstance().navigateTo(routes.APP_MANAGEMENT,undefined,true)}onDriveOfflineClick_(){Router.getInstance().navigateTo(routes.GOOGLE_DRIVE,undefined,true)}onCrostiniClick_(){Router.getInstance().navigateTo(routes.CROSTINI_DETAILS,undefined,true)}onOtherUsersClick_(){Router.getInstance().navigateTo(routes.ACCOUNTS,undefined,true)}onExternalStoragePreferencesClick_(){Router.getInstance().navigateTo(routes.EXTERNAL_STORAGE_PREFERENCES)}handleSizeStatChanged_(sizeStat){this.sizeStat_=sizeStat;this.$.inUseLabelArea.style.width=sizeStat.usedRatio*100+"%";this.$.availableLabelArea.style.width=(1-sizeStat.usedRatio)*100+"%"}handleMyFilesSizeChanged_(size){this.myFilesSizeSubLabel_=size}handleBrowsingDataSizeChanged_(size){this.$.browsingDataSize.subLabel=size}handleAppsSizeChanged_(size){this.shadowRoot.querySelector("#appsSize").subLabel=size}handleDriveOfflineSizeChanged_(size){if(!this.shouldShowOfflineFilesRow_()){return}this.shadowRoot.querySelector("#driveOfflineSize").subLabel=size}handleCrostiniSizeChanged_(size){if(this.showCrostiniStorage_){this.shadowRoot.querySelector("#crostiniSize").subLabel=size}}handleOtherUsersSizeChanged_(size,noOtherUsers){if(this.isEphemeralUser_||noOtherUsers){this.showOtherUsers_=false;return}this.showOtherUsers_=true;this.shadowRoot.querySelector("#otherUsersSize").subLabel=size}handleSystemSizeChanged_(size){this.shadowRoot.getElementById("systemSizeSubLabel").innerText=size}handleCrostiniEnabledChanged_(enabled){this.showCrostiniStorage_=enabled&&isCrostiniSupported()}handleDriveDisabledChanged_(disabled){this.isDriveEnabled_=!disabled}shouldShowOfflineFilesRow_(){return this.isDriveEnabled_}startPeriodicUpdate_(){if(this.updateTimerId_===-1){this.updateTimerId_=window.setInterval((()=>{if(Router.getInstance().currentRoute!==routes.STORAGE){this.stopPeriodicUpdate_();return}this.browserProxy_.updateStorageInfo()}),5e3)}}stopPeriodicUpdate_(){if(this.updateTimerId_!==-1){window.clearInterval(this.updateTimerId_);this.updateTimerId_=-1}}isSpaceLow_(spaceState){return spaceState===StorageSpaceState.LOW}isSpaceCriticallyLow_(spaceState){return spaceState===StorageSpaceState.CRITICALLY_LOW}getBarClass_(spaceState){switch(spaceState){case StorageSpaceState.LOW:return"space-low";case StorageSpaceState.CRITICALLY_LOW:return"space-critically-low";default:return""}}roundTo2DecimalPoints_(n){return n.toFixed(2)}localUserFilesAllowed_(prefValue){return!this.isSkyVaultEnabled_||prefValue}}customElements.define(SettingsStorageElement.is,SettingsStorageElement);function getTemplate$2F(){return html`<!--_html_template_start_--><style include="settings-shared md-select">.settings-box>.secondary{align-items:center;display:flex;margin-top:0}paper-spinner-lite{height:var(--cr-icon-size);margin-inline-start:12px;width:var(--cr-icon-size)}cr-policy-indicator{padding:0 var(--cr-controlled-by-spacing)}#selectApp{width:400px}</style>

<settings-toggle-button id="enableStylusToolsToggle"
    pref="{{prefs.settings.enable_stylus_tools}}"
    label="$i18n{stylusEnableStylusTools}"
    deep-link-focus-id$="[[Setting.kStylusToolsInShelf]]">
</settings-toggle-button>

<template is="dom-if" if="[[hasInternalStylus_]]">
  <settings-toggle-button
      id ="launchPaletteOnEjectEventToggle"
      class="hr"
      pref="{{prefs.settings.launch_palette_on_eject_event}}"
      label="$i18n{stylusAutoOpenStylusTools}"
      disabled="[[!prefs.settings.enable_stylus_tools.value]]">
  </settings-toggle-button>
</template>

<div class="settings-box">
  <div id="stylusNoteTakingAppLabel" class="start">
    $i18n{stylusNoteTakingApp}
  </div>

  <div id="no-apps" class="secondary"
      hidden$="[[!showNoApps_(appChoices_, waitingForAndroid_)]]">
    $i18n{stylusNoteTakingAppNoneAvailable}
  </div>

  <div id="waiting" class="secondary" hidden$="[[!waitingForAndroid_]]">
    $i18n{stylusNoteTakingAppWaitingForAndroid}
    <paper-spinner-lite active></paper-spinner-lite>
  </div>

  <select id="selectApp" class="md-select"
      on-change="onSelectedAppChanged_"
      aria-labelledby="stylusNoteTakingAppLabel"
      hidden$="[[!showApps_(appChoices_, waitingForAndroid_)]]"
      deep-link-focus-id$="[[Setting.kStylusNoteTakingApp]]">
    <template is="dom-repeat" items="[[appChoices_]]">
      <option value="[[item.value]]" selected="[[item.preferred]]">
        [[item.name]]
      </option>
    </template>
  </select>
</div>

<cr-link-row id="findMoreAppsLink" class="hr" on-click="onFindAppsClick_"
    hidden$="[[!prefs.arc.enabled.value]]"
    label="$i18n{stylusFindMoreAppsPrimary}"
    sub-label="$i18n{stylusFindMoreAppsSecondary}"
    external>
</cr-link-row>
<!--_html_template_end_-->`}
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const FIND_MORE_APPS_URL="https://play.google.com/store/apps/"+"collection/promotion_30023cb_stylus_apps";const SettingsStylusElementBase=DeepLinkingMixin(RouteObserverMixin(PolymerElement));class SettingsStylusElement extends SettingsStylusElementBase{static get is(){return"settings-stylus"}static get template(){return getTemplate$2F()}static get properties(){return{prefs:{type:Object,notify:true},appChoices_:{type:Array,value(){return[]}},hasInternalStylus_:{type:Boolean,value(){return loadTimeData.getBoolean("hasInternalStylus")},readOnly:true},selectedApp_:{type:Object,value:null},waitingForAndroid_:{type:Boolean,value:false}}}constructor(){super();this.supportedSettingIds=new Set([Setting.kStylusToolsInShelf,Setting.kStylusNoteTakingApp]);this.browserProxy_=DevicePageBrowserProxyImpl.getInstance()}ready(){super.ready();this.browserProxy_.setNoteTakingAppsUpdatedCallback(this.onNoteAppsUpdated_.bind(this));this.browserProxy_.requestNoteTakingApps()}currentRouteChanged(route){if(route!==routes.STYLUS){return}this.attemptDeepLink()}findApp_(id){return this.appChoices_.find((app=>app.value===id))||null}onSelectedAppChanged_(){const app=this.findApp_(this.$.selectApp.value);this.selectedApp_=app;if(app&&!app.preferred){this.browserProxy_.setPreferredNoteTakingApp(app.value);recordSettingChange(Setting.kStylusNoteTakingApp)}}onNoteAppsUpdated_(apps,waitingForAndroid){this.waitingForAndroid_=waitingForAndroid;this.appChoices_=apps;microTask.run(this.onSelectedAppChanged_.bind(this))}showNoApps_(apps,waitingForAndroid){return apps.length===0&&!waitingForAndroid}showApps_(apps,waitingForAndroid){return apps.length>0&&!waitingForAndroid}onFindAppsClick_(){this.browserProxy_.showPlayStore(FIND_MORE_APPS_URL)}}customElements.define(SettingsStylusElement.is,SettingsStylusElement);function getTemplate$2E(){return html`<!--_html_template_start_--><style include="settings-shared"></style>
<div class="settings-box first">
  <div role="text">
    [[getDescriptionText_()]]
    <span id="guestOsInstructionsRemove" hidden="[[!sharedPaths_.length]]">
      $i18n{guestOsSharedPathsInstructionsRemove}
    </span>
  </div>
</div>
<div id="guestOsListEmpty" class="settings-box secondary continuation"
    hidden="[[sharedPaths_.length]]" >
   $i18n{guestOsSharedPathsListEmptyMessage}
</div>
<div id="guestOsList" hidden="[[!sharedPaths_.length]]">
  <div class="settings-box continuation">
    <h2 id="guestOsListHeading" class="start">
      $i18n{guestOsSharedPathsListHeading}
    </h2>
  </div>
  <iron-list class="list-frame vertical-list" role="list"
      aria-labelledby="guestOsListHeading" items="[[sharedPaths_]]">
    <template>
      <div class="list-item" role="listitem">
        <div class="start" aria-hidden="true"
            id="[[generatePathDisplayTextId_(index)]]">
          [[item.pathDisplayText]]
        </div>
        <cr-icon-button class="icon-clear" tabindex$="[[tabIndex]]"
            on-click="onRemoveSharedPathClick_"
            title="$i18n{guestOsSharedPathsStopSharing}"
            aria-labelledby$="[[generatePathDisplayTextId_(index)]]">
        </cr-icon-button>
      </div>
    </template>
  </iron-list>
</div>
<template is="dom-if" if="[[sharedPathWhichFailedRemoval_]]" restamp>
  <cr-dialog id="removeSharedPathFailedDialog" close-text="$i18n{close}"
      show-on-attach>
    <div slot="title">
      $i18n{guestOsSharedPathsRemoveFailureDialogTitle}
    </div>
    <div slot="body">
      [[getRemoveFailureMessage_()]]
    </div>
    <div slot="button-container">
      <cr-button id="cancel" class="cancel-button"
          on-click="onRemoveFailedDismissClick_">
        $i18n{ok}
      </cr-button>
      <cr-button id="retry" class="action-button"
          on-click="onRemoveFailedRetryClick_">
        $i18n{guestOsSharedPathsRemoveFailureTryAgain}
      </cr-button>
    </div>
  </cr-dialog>
</template>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsGuestOsSharedPathsElementBase=I18nMixin(PolymerElement);class SettingsGuestOsSharedPathsElement extends SettingsGuestOsSharedPathsElementBase{static get is(){return"settings-guest-os-shared-paths"}static get template(){return getTemplate$2E()}static get properties(){return{guestOsType:String,prefs:{type:Object,notify:true},sharedPaths_:Array,sharedPathWhichFailedRemoval_:{type:String,value:null}}}static get observers(){return["onGuestOsSharedPathsChanged_(prefs.guest_os.paths_shared_to_vms.value)"]}constructor(){super();this.browserProxy_=GuestOsBrowserProxyImpl.getInstance()}onGuestOsSharedPathsChanged_(paths){const vmPaths=[];for(const path in paths){const vms=paths[path];if(vms.includes(this.vmName_())){vmPaths.push(path)}}this.browserProxy_.getGuestOsSharedPathsDisplayText(vmPaths).then((text=>{this.sharedPaths_=vmPaths.map(((path,i)=>({path:path,pathDisplayText:text[i]})))}))}removeSharedPath_(path){this.sharedPathWhichFailedRemoval_=null;this.browserProxy_.removeGuestOsSharedPath(this.vmName_(),path).then((success=>{if(!success){this.sharedPathWhichFailedRemoval_=path}}))}onRemoveSharedPathClick_(event){this.removeSharedPath_(event.model.item.path)}onRemoveFailedRetryClick_(){this.removeSharedPath_(castExists(this.sharedPathWhichFailedRemoval_))}onRemoveFailedDismissClick_(){this.sharedPathWhichFailedRemoval_=null}vmName_(){return getVMNameForGuestOsType(this.guestOsType)}getDescriptionText_(){return this.i18n(this.guestOsType+"SharedPathsInstructionsLocate")+"\n"+this.i18n(this.guestOsType+"SharedPathsInstructionsAdd")}getRemoveFailureMessage_(){return this.i18n(this.guestOsType+"SharedPathsRemoveFailureDialogMessage")}generatePathDisplayTextId_(index){return"path-display-text-"+index}}customElements.define(SettingsGuestOsSharedPathsElement.is,SettingsGuestOsSharedPathsElement);
/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */const ANCHOR_NAME=css`--tooltip-anchor`;const ATTR_SHIFT_INLINE_END="shift-inline-end";const ATTR_SHIFT_INLINE_START="shift-inline-start";const ATTR_SHIFT_INLINE_END_CSS=css`shift-inline-end`;const ATTR_SHIFT_INLINE_START_CSS=css`shift-inline-start`;const BLUR_OR_UNFOCUS_TIMEOUT_DURATION=200;class Tooltip extends LitElement{static{this.styles=css`
    /* Remove default CSS Popover API styles. */
    :host {
      border: 0;
      margin: 0;
      padding: 0;
    }

    :host(:not(:popover-open)) {
      opacity: 0;
      transition: all 200ms allow-discrete;
    }

    :host(:popover-open) {
      opacity: 1;
      transition: all 200ms allow-discrete;
    }

    @starting-style {
      :host(:popover-open) {
        opacity: 0;
      }
    }

    #tooltip-anchor-overlay {
      anchor-name: ${ANCHOR_NAME};
      opacity: 0;
      pointer-events: none;
      position: fixed;
    }

    #label {
      background-color: var(--cros-sys-inverse_surface);
      border-radius: 6px;
      color: var(--cros-sys-surface);
      font: var(--cros-annotation-1-font);
      inset-block-start: var(--cros-tooltip-vertical-offset, 4px);
      max-width: 296px;
      padding: 5px 8px;
      position-anchor: ${ANCHOR_NAME};
      position-area: block-end span-all;
      position: fixed;
      text-align: center;
      text-wrap: wrap;
    }

    #label[${ATTR_SHIFT_INLINE_END_CSS}] {
      position-area: block-end span-inline-end;
      text-align: start;
    }

    #label[${ATTR_SHIFT_INLINE_START_CSS}] {
      position-area: block-end span-inline-start;
      text-align: start;
    }

    :host([truncate]) #label-inner {
      display: -webkit-box;
      -webkit-box-orient: vertical;
      -webkit-line-clamp: 3;
      overflow: hidden;
    }
  `}static{this.properties={anchor:{type:String},label:{type:String},truncate:{type:Boolean,reflect:true},followAnchorOnScroll:{type:Boolean,reflect:true,attribute:"follow-anchor"}}}constructor(){super();this.currentAnchorElement=null;this.isAnchorOrLabelFocused=false;this.blurOrUnfocusTimeout=null;this.onDocumentScrollBound=null;this.anchorElement=null;this.anchor="";this.label="";this.truncate=true;this.followAnchorOnScroll=false;this.anchorOrLabelFocused=this.anchorOrLabelFocused.bind(this);this.anchorOrLabelBlurred=this.anchorOrLabelBlurred.bind(this)}get anchorElement(){if(this.anchor){return this.getRootNode().querySelector(`#${this.anchor}`)}return this.currentAnchorElement}set anchorElement(element){this.currentAnchorElement=element;this.requestUpdate("anchorElement")}connectedCallback(){super.connectedCallback();this.onDocumentScrollBound=this.onDocumentScroll.bind(this)}firstUpdated(){this.setAttribute("popover","auto");this.setAttribute("id","tooltip");if(this.anchorElement){this.anchorElement.addEventListener("mouseover",this.anchorOrLabelFocused);this.anchorElement.addEventListener("focusin",this.anchorOrLabelFocused);this.anchorElement.addEventListener("mouseout",this.anchorOrLabelBlurred);this.anchorElement.addEventListener("focusout",this.anchorOrLabelBlurred);if(this.onDocumentScrollBound){document.addEventListener("scroll",this.onDocumentScrollBound)}}}disconnectedCallback(){if(this.anchorElement){this.anchorElement.removeEventListener("mouseover",this.anchorOrLabelFocused);this.anchorElement.removeEventListener("focus",this.anchorOrLabelFocused);this.anchorElement.removeEventListener("mouseout",this.anchorOrLabelBlurred);this.anchorElement.removeEventListener("blur",this.anchorOrLabelBlurred)}if(this.onDocumentScrollBound){document.removeEventListener("scroll",this.onDocumentScrollBound)}super.disconnectedCallback()}get labelElement(){return this.shadowRoot.querySelector("#label")}updated(changedProperties){if(changedProperties.has("label")&&!!this.anchorElement){this.anchorElement.ariaDescription=this.label}}openPopover(){this.updateAnchorPosition();const tooltip=this;tooltip.showPopover()}closePopover(){const tooltip=this;tooltip.hidePopover()}anchorOrLabelFocused(e){const{sourceCapabilities:sourceCapabilities}=e;if(!sourceCapabilities||sourceCapabilities.firesTouchEvents){return}this.isAnchorOrLabelFocused=true;this.openPopover()}anchorOrLabelBlurred(){const anchorStillHasKeyboardFocus=this.anchorElement?.matches(":focus");if(!anchorStillHasKeyboardFocus){this.isAnchorOrLabelFocused=false;this.maybeCloseTooltipAfterTimeout()}}maybeCloseTooltipAfterTimeout(){if(this.blurOrUnfocusTimeout){clearTimeout(this.blurOrUnfocusTimeout)}this.blurOrUnfocusTimeout=setTimeout((()=>{if(!this.isAnchorOrLabelFocused){this.closePopover()}}),BLUR_OR_UNFOCUS_TIMEOUT_DURATION)}updateAnchorPosition(){if(!this.anchorElement)return;const anchorOverlay=this.shadowRoot.getElementById("tooltip-anchor-overlay");const anchorRect=this.anchorElement.getBoundingClientRect();anchorOverlay.style.top=`${anchorRect.top}px`;anchorOverlay.style.left=`${anchorRect.left}px`;anchorOverlay.style.width=`${anchorRect.width}px`;anchorOverlay.style.height=`${anchorRect.height}px`;requestAnimationFrame((()=>{const label=this.labelElement;label.removeAttribute(ATTR_SHIFT_INLINE_START);label.removeAttribute(ATTR_SHIFT_INLINE_END);const boundingClientRectWhenCentered=label.getBoundingClientRect();const widthWhenInCenter=boundingClientRectWhenCentered.width;const isOffscreenWhenInCenter=boundingClientRectWhenCentered.x+widthWhenInCenter>document.body.clientWidth||boundingClientRectWhenCentered.x<0;label.setAttribute(ATTR_SHIFT_INLINE_END,"");const widthWhenShiftedToEnd=label.getBoundingClientRect().width;label.removeAttribute(ATTR_SHIFT_INLINE_END);label.setAttribute(ATTR_SHIFT_INLINE_START,"");const widthWhenShiftedToStart=label.getBoundingClientRect().width;label.removeAttribute(ATTR_SHIFT_INLINE_END);label.removeAttribute(ATTR_SHIFT_INLINE_START);if(!isOffscreenWhenInCenter&&widthWhenInCenter>=widthWhenShiftedToStart&&widthWhenInCenter>=widthWhenShiftedToEnd){label.removeAttribute(ATTR_SHIFT_INLINE_START);label.removeAttribute(ATTR_SHIFT_INLINE_END)}else if(widthWhenShiftedToStart>widthWhenShiftedToEnd){label.setAttribute(ATTR_SHIFT_INLINE_START,"")}else{label.setAttribute(ATTR_SHIFT_INLINE_END,"")}}))}onDocumentScroll(){if(this.followAnchorOnScroll){this.updateAnchorPosition()}}render(){return html$1`
      <div id="tooltip-anchor-overlay">
      </div>
      <div id="label"
          aria-hidden="true"
          role="tooltip"
          @mouseover=${this.anchorOrLabelFocused}
          @mouseout=${this.anchorOrLabelBlurred}
          @focus=${this.anchorOrLabelFocused}
          @blur=${this.anchorOrLabelBlurred}>
        <div id="label-inner">${this.label}</div>
    </div>
    `}}customElements.define("cros-tooltip",Tooltip);
/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */function isSidenav(element){return element instanceof Element&&element.tagName==="CROS-SIDENAV"}function isSidenavItem(element){return element instanceof Element&&element.tagName==="CROS-SIDENAV-ITEM"}function shadowPiercingActiveItem(){let activeElement=document.activeElement;while(activeElement&&!isSidenavItem(activeElement)){activeElement=activeElement.shadowRoot?activeElement.shadowRoot.activeElement:null}return activeElement}
/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */const TREE_ITEM_INDENT_PX=20;const ICON_SIZE$1=css`20px`;const ICON_LABEL_GAP=css`8px`;const EXPAND_LABEL_GAP=css`4px`;const ICON_LEADING_MARGIN=css`28px`;const EXPAND_LEADING_MARGIN=css`8px`;const LABEL_ONLY_MARGIN=css`24px`;const LABEL_TRAILING_MARGIN=css`12px`;const ITEM_GAP=css`8px`;const LAYERED_SELECTOR=css`:host(:is([inLayered], [mayHaveChildren]))`;function stopPropagation(e){e.stopPropagation()}class SidenavItem extends LitElement{static{this.styles=css`
    :host {
      display: block;
      margin-top: ${ITEM_GAP};
    }

    li {
      display: block;
      font: var(--cros-button-2-font);
    }

    :host([separator])::before {
      border-top: 1px solid var(--cros-separator-color);
      content: '';
      display: block;
      padding-bottom: 8px;
      width: 100%;
    }

    #tree-row {
      align-items: center;
      background: none;
      border: none;
      border-inline-start-width: 0 !important;
      border-radius: 20px;
      box-sizing: border-box;
      color: var(--cros-sys-on_surface);
      cursor: pointer;
      display: flex;
      font: var(--cros-button-2-font);
      height: 40px;
      padding-inline-end: ${LABEL_TRAILING_MARGIN};
      position: relative;
      text-align: start;
      user-select: none;
      white-space: nowrap;
      width: 100%;
    }

    #tree-row:focus-visible {
      outline: none;
    }

    md-focus-ring {
      animation-duration: 0s;
      --md-focus-ring-color: var(--cros-sys-focus_ring);
      --md-focus-ring-shape: 20px;
      --md-focus-ring-width: 2px;
    }

    :host([enabled]) #tree-row {
      background-color: var(--cros-sys-primary);
      color: var(--cros-sys-on_primary);
    }

    :host([disabled]) #tree-row {
      color: var(--cros-sys-disabled);
      pointer-events: none;
    }

    :host([error]) #tree-row {
      background-color: var(--cros-sys-error_container);
      color: var(--cros-sys-on_error_container);
    }

    :host-context(.pointer-active) #tree-row:not(:active) {
      cursor: default;
    }

    .expand-icon {
      display: none;
      fill: currentcolor;
      flex: none;
      height: ${ICON_SIZE$1};
      -webkit-mask-position: center;
      -webkit-mask-repeat: no-repeat;
      position: relative;
      transform: rotate(-90deg);
      transition: all 150ms;
      visibility: hidden;
      width: ${ICON_SIZE$1};
    }

    ${LAYERED_SELECTOR} .expand-icon {
      display: unset;
    }


    [aria-expanded] .expand-icon {
      visibility: visible;
    }

    .expand-icon,
    slot[name="icon"]::slotted(*) {
      width: 20px;
      height: 20px;
      align-items: center;
    }

    :host-context([dir=rtl]) .expand-icon {
      transform: rotate(90deg);
    }

    :host([expanded]) .expand-icon {
      transform: rotate(0);
    }

    slot[name="icon"]::slotted(*) {
      color: var(--cros-sys-on_surface);
      flex: none;
      height: ${ICON_SIZE$1};
      margin-inline-start: ${ICON_LEADING_MARGIN};
      width: ${ICON_SIZE$1};
    }

    :host([enabled]) slot[name="icon"]::slotted(*) {
      color: var(--cros-sys-on_primary)
    }

    :host([disabled]) slot[name="icon"]::slotted(*) {
      color: var(--cros-sys-disabled);
    }

    :host([error]) slot[name="icon"]::slotted(*) {
      color: var(--cros-sys-on_error_container);
    }

    .tree-label {
      display: block;
      flex: auto;
      margin-inline-start: ${LABEL_ONLY_MARGIN};
      overflow: hidden;
      text-overflow: ellipsis;
      white-space: pre;
    }

    ${LAYERED_SELECTOR} .expand-icon {
      margin-inline-start: ${EXPAND_LEADING_MARGIN}
    }

    ${LAYERED_SELECTOR} slot[name="icon"]::slotted(*) {
      margin-inline-start: 0px;
      margin-inline-end: 0px;
    }

    ${LAYERED_SELECTOR} .tree-label {
      margin-inline-start: ${EXPAND_LABEL_GAP};
    }

    ${LAYERED_SELECTOR} .has-icon .tree-label,
    :host([expanded]) .tree-label,
    .has-icon + .tree-label, {
      margin-inline-start: ${ICON_LABEL_GAP};
    }

    .rename {
      background-color: var(--cros-sys-app_base);
      border: none;
      border-radius: 4px;
      color: var(--cros-sys-on_surface);
      height: 20px;
      margin-inline-start: ${LABEL_ONLY_MARGIN};
      outline: 2px solid var(--cros-sys-focus_ring);
      overflow: hidden;
      font: var(--cros-button-2-font);
    }

    .has-icon :is(.tree-label, .rename) {
      margin-inline-start: ${ICON_LABEL_GAP};
    }

    ${LAYERED_SELECTOR} .rename {
      margin-inline-start: ${EXPAND_LABEL_GAP};
    }

    ${LAYERED_SELECTOR} .has-icon :is(.tree-label, .rename) {
      margin-inline-start: ${ICON_LABEL_GAP};
    }

    /* We need to ensure that even empty labels take up space */
    #tree-label:empty::after {
      content: ' ';
      white-space: pre;
    }

    ul.tree-children {
      height: 0px;
      list-style: none;
      margin: 0;
      outline: none;
      overflow: hidden;
      padding: 0;
    }

    :host([expanded]) ul.tree-children {
      display: block;
      height: auto;
      margin: 0;
      overflow: visible;
    }

    :host([enabled]) .rename {
      outline: 2px solid var(--cros-sys-inverse_primary);
    }

    .rename::selection {
      background-color: var(--cros-sys-highlight_text)
    }

    md-ripple {
      border-radius: 20px;
    }

    :host(:not([renaming])) md-ripple {
      color: var(--cros-sys-ripple_primary);
      --md-ripple-hover-color: var(--cros-sys-hover_on_subtle);
      --md-ripple-hover-opacity: 100%;
      --md-ripple-pressed-color: var(--cros-sys-ripple_primary);
      --md-ripple-pressed-opacity: 100%;
    }
  `}static{this.shadowRootOptions={...LitElement.shadowRootOptions,delegatesFocus:true}}static{this.properties={separator:{type:Boolean,reflect:true},disabled:{type:Boolean,reflect:true},enabled:{type:Boolean,reflect:true},expanded:{type:Boolean,reflect:true},renaming:{type:Boolean,reflect:true},error:{type:Boolean,reflect:true},mayHaveChildren:{type:Boolean,reflect:true},label:{type:String,reflect:true},tabIndex:{attribute:false},layer:{type:Number,reflect:true},inLayered:{type:Boolean,reflect:true},ignoreLayer:{type:Boolean},hasIcon:{type:Boolean,reflect:true},ariaSetSize:{type:String},ariaPosInSet:{type:String}}}static get events(){return{SIDENAV_ITEM_EXPANDED:"cros-sidenav-item-expanded",SIDENAV_ITEM_COLLAPSED:"cros-sidenav-item-collapsed",SIDENAV_ITEM_RENAMED:"cros-sidenav-item-renamed",SIDENAV_ITEM_ENABLED_CHANGED:"cros-sidenav-item-enabled-changed",SIDENAV_ITEM_TRIGGERED:"cros-sidenav-item-triggered"}}get treeRowElement(){return castExists$1(this.shadowRoot.getElementById("tree-row"))}get renameInputElement(){return castExists$1(this.renderRoot.querySelector(".rename"))}get childrenSlotElement(){return castExists$1(this.renderRoot.querySelector("slot:not([name])"))}get iconSlotElement(){return castExists$1(this.renderRoot.querySelector('slot[name="icon"]'))}constructor(){super();this.items=[];this.shouldRenameOnBlur=true;this.separator=false;this.disabled=false;this.enabled=false;this.expanded=false;this.renaming=false;this.error=false;this.mayHaveChildren=false;this.label="";this.tabIndex=-1;this.layer=0;this.ignoreLayer=false;this.hasIcon=false;this.inLayered=false}get selectableItems(){return this.items.filter((item=>!item.disabled))}hasChildren(){return this.mayHaveChildren||this.items.length>0}get parentItem(){let p=this.parentElement;while(p){if(isSidenavItem(p)){return p}if(isSidenav(p)){return null}p=p.parentElement}return p}reveal(){let pi=this.parentItem;while(pi){pi.expanded=true;pi=pi.parentItem}}render(){const showExpandIcon=this.hasChildren();const effectiveLayer=this.ignoreLayer?0:this.layer;const treeRowStyles={paddingInlineStart:`max(0px, calc(${TREE_ITEM_INDENT_PX} * ${effectiveLayer}px))`};const treeRowClasses={"has-icon":this.hasIcon};return html$1`
      <li
          id="tree-item"
          role="none"
          @click=${stopPropagation}>
        <!-- TODO: b/302435119 - Use cros-tooltip instead of title. -->
        <div
            id="tree-row"
            role="treeitem"
            aria-current=${this.enabled?"page":nothing}
            aria-setsize=${this.ariaSetSize??nothing}
            aria-posinset=${this.ariaPosInSet??nothing}
            aria-level=${this.layer+1}
            aria-labelledby="tree-label"
            aria-expanded=${showExpandIcon?this.expanded:nothing}
            aria-disabled=${this.disabled}
            tabindex=${this.tabIndex}
            @click=${this.onRowClicked}
            @keydown=${this.onKeyDown}
            class=${classMap(treeRowClasses)}
            style=${styleMap(treeRowStyles)}>
          <md-ripple
              for="tree-row"
              ?disabled=${this.disabled}>
          </md-ripple>
          <md-focus-ring
              for="tree-row"
              ?disabled=${this.disabled}>
          </md-focus-ring>
          <!-- TODO: b/231672472 - Implement icon from spec -->
          <span
              class="expand-icon"
              aria-hidden="true"
              @click=${this.onExpandIconClicked}>
            <svg xmlns="http://www.w3.org/2000/svg"
                width="20"
                height="20"
                viewBox="0 0 20 20">
              <polyline points="6 8 10 12 14 8 6 8"/>
            </svg>
          </span>
          <slot
              name="icon"
              class=${this.hasIcon?"has-icon":""}
              aria-hidden="true"
              @slotchange=${this.onIconSlotChanged}>
          </slot>
          ${this.renderTreeLabel()}
        </div>
        <ul
            aria-hidden=${!this.expanded}
            class="tree-children"
            role="group">
          <slot @slotchange=${this.onSlotChanged}></slot>
        </ul>
        ${this.renderTooltip()}
       </li>
     `}firstUpdated(){this.addEventListener("click",this.onRowClicked)}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("expanded")){this.onExpandChanged()}if(changedProperties.has("enabled")){this.onEnabledChanged()}if(changedProperties.has("renaming")){this.onRenamingChanged()}if(changedProperties.has("layer")){for(const item of this.items){item.layer=this.layer+1}}}renderTreeLabel(){if(this.renaming){const interceptPropagation=e=>{e.stopPropagation()};return html$1`
        <input
          class="rename"
          type="text"
          spellcheck="false"
          .value=${this.label}
          @click=${interceptPropagation}
          @dblclick=${interceptPropagation}
          @mouseup=${interceptPropagation}
          @mousedown=${interceptPropagation}
          @blur=${this.onRenameInputBlur}
          @keydown=${this.onRenameInputKeydown}
        />
      `}return html$1`
    <span
      class="tree-label"
      id="tree-label"
    >${this.label||""}</span>`}renderTooltip(){return html$1`
        <cros-tooltip
          ?hidden=${!this.isLabelTruncated()}
          anchor="tree-row"
          label=${this.label}
          follow-anchor>
        </cros-tooltip>
      `}onIconSlotChanged(){this.hasIcon=this.iconSlotElement.assignedElements().length>0;this.iconSlotElement.assignedElements().forEach((icon=>{icon.setAttribute("tabIndex","-1")}))}onSlotChanged(){const oldItemsContainEnabledItem=this.items.some((item=>item.enabled));this.items=this.childrenSlotElement.assignedElements().filter(isSidenavItem);let updateScheduled=false;if(this.items.length===0&&this.expanded){this.expanded=false;updateScheduled=true}if(oldItemsContainEnabledItem&&!this.items.some((item=>item.enabled))){this.enabled=true;updateScheduled=true}this.items.forEach(((item,i)=>{item.layer=this.layer+1;item.ariaSetSize=`${this.items.length}`;item.ariaPosInSet=`${i+1}`}));if(!updateScheduled){this.requestUpdate()}}onExpandChanged(){if(this.expanded){const expandedEvent=new CustomEvent(SidenavItem.events.SIDENAV_ITEM_EXPANDED,{bubbles:true,composed:true,detail:{item:this}});this.dispatchEvent(expandedEvent)}else{const collapseEvent=new CustomEvent(SidenavItem.events.SIDENAV_ITEM_COLLAPSED,{bubbles:true,composed:true,detail:{item:this}});this.dispatchEvent(collapseEvent)}}onEnabledChanged(){const event=new CustomEvent(SidenavItem.events.SIDENAV_ITEM_ENABLED_CHANGED,{bubbles:true,composed:true,detail:{item:this,enabled:this.enabled}});this.dispatchEvent(event)}onExpandIconClicked(e){e.stopPropagation();if(this.disabled)return;this.expanded=!this.expanded}onRowClicked(e){e.stopPropagation();if(this.disabled)return;this.enabled=true;this.dispatchEvent(new CustomEvent(SidenavItem.events.SIDENAV_ITEM_TRIGGERED,{bubbles:false,detail:{item:this}}))}onKeyDown(e){if(this.renaming)return;switch(e.key){case"Enter":case" ":if(this.disabled)break;this.enabled=true;this.dispatchEvent(new CustomEvent(SidenavItem.events.SIDENAV_ITEM_TRIGGERED,{bubbles:false,detail:{item:this}}));break}}onRenamingChanged(){if(this.renaming){this.renameInputElement?.focus();this.renameInputElement?.select()}}onRenameInputKeydown(e){e.stopPropagation();if(e.repeat){return}switch(e.key){case"Escape":this.shouldRenameOnBlur=false;this.treeRowElement.focus();e.preventDefault();break;case"Enter":this.treeRowElement.focus();e.preventDefault();break}}onRenameInputBlur(){if(!this.renaming){return}this.renaming=false;if(this.shouldRenameOnBlur){this.commitRename(this.renameInputElement?.value||"")}else{this.shouldRenameOnBlur=true}}commitRename(newName){const isEmpty=newName.trim()==="";const isChanged=newName!==this.label;if(isEmpty||!isChanged){return}const oldLabel=this.label;this.label=newName;const renameEvent=new CustomEvent(SidenavItem.events.SIDENAV_ITEM_RENAMED,{bubbles:true,composed:true,detail:{item:this,oldLabel:oldLabel,newLabel:newName}});this.dispatchEvent(renameEvent)}isLabelTruncated(){const treeLabel=this.shadowRoot?.querySelector(".tree-label");if(!treeLabel){return false}return treeLabel.scrollWidth>treeLabel.clientWidth}}customElements.define("cros-sidenav-item",SidenavItem);
/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */const CHILDREN_OBSERVER_CONFIG={attributes:true,childList:true,subtree:true,attributeFilter:["mayHaveChildren","mayhavechildren"]};function isSelectable(item){if(item.disabled)return false;let parent=item.parentItem;while(parent){if(!parent.expanded||parent.disabled)return false;parent=parent.parentItem}return true}function isSelected(item){return item.tabIndex===0}class Sidenav extends LitElement{static{this.styles=css`
      :host {
        display: block;
      }

      ul {
        list-style: none;
        margin: 0;
        padding: 0;
      }

      slot::slotted(cros-sidenav-item:first-child) {
        margin-top: 0;
      }
  `}static{this.properties={allowNoEnabled:{type:Boolean,reflect:true},ariaSetSize:{type:String,attribute:"aria-setsize"},doubleclickExpands:{type:Boolean,reflect:true},role:{type:String,reflect:true}}}static get events(){return{SIDENAV_ENABLED_CHANGED:"cros-sidenav-enabled-changed"}}get enabledItem(){return this.items.find((item=>item.enabled))||null}set enabledItem(item){if(!item&&!this.allowNoEnabled){throw new Error("Setting enabledItem to null is disallowed.")}this.enableItem(item)}get items(){return this.childrenSlot.assignedElements().filter(isSidenavItem).flatMap((e=>[e].concat(Array.from(e.querySelectorAll("cros-sidenav-item")))))}get selectableItems(){return this.items.filter((e=>isSelectable(e)||isSelected(e)))}get childrenSlot(){return castExists$1(this.renderRoot.querySelector("slot"))}get selectedItem(){return this.items.find(isSelected)||null}constructor(){super();this.itemAttributeObserver=new MutationObserver((mutationList=>{for(const mutation of mutationList){if(mutation.type==="attributes"&&mutation.target.tagName==="CROS-SIDENAV-ITEM"&&mutation.attributeName?.toLowerCase()==="mayhavechildren"){this.updateLayered();return}if(mutation.type==="childList"){this.updateLayered();if(!this.hasAttribute("aria-setsize")){this.ariaSetSize=`${this.items.length}`}return}}}));this.doubleclickExpands=false;this.allowNoEnabled=false;this.role="navigation"}render(){return html$1`
      <ul
          class="tree"
          role="tree"
          aria-setsize="${this.ariaSetSize??0}"
          @dblclick=${this.onTreeDblClicked}
          @keydown=${this.onTreeKeyDown}
          @cros-sidenav-item-expanded=${this.onSidenavItemExpanded}
          @cros-sidenav-item-collapsed=${this.onSidenavItemCollapsed}
          @cros-sidenav-item-enabled-changed=${this.onSidenavItemEnabledChanged}>
        <slot @slotchange=${this.onSlotChanged}></slot>
      </ul>
    `}connectedCallback(){super.connectedCallback();this.itemAttributeObserver.observe(this,CHILDREN_OBSERVER_CONFIG)}disconnectedCallback(){super.disconnectedCallback();this.itemAttributeObserver.disconnect()}firstUpdated(){if(!this.hasAttribute("aria-setsize")){this.ariaSetSize=`${this.items.length}`}}focus(){if(this.selectedItem){this.selectedItem.focus()}}onSlotChanged(){const rootChildren=this.childrenSlot.assignedElements().filter(isSidenavItem);rootChildren.forEach(((child,i)=>{child.layer=0;child.ariaSetSize=`${rootChildren.length}`;child.ariaPosInSet=`${i+1}`}));if(!this.items.some((item=>item.enabled))&&this.selectableItems.length>0&&!this.allowNoEnabled){this.enableItem(castExists$1(this.selectableItems[0]))}if(!this.selectedItem&&this.selectableItems.length>0){this.selectItem(castExists$1(this.selectableItems[0]))}this.updateLayered()}async getUpdateComplete(){await Promise.all(this.items.map((item=>item.updateComplete)));return super.getUpdateComplete()}updateLayered(){const layered=this.querySelectorAll("cros-sidenav-item cros-sidenav-item, "+"cros-sidenav-item[mayHaveChildren]").length>0;for(const item of this.querySelectorAll("cros-sidenav-item")){item.inLayered=layered}}onSidenavItemExpanded(e){const treeItem=e.detail.item;treeItem.scrollIntoViewIfNeeded(false)}onSidenavItemCollapsed(e){const collapsedItem=e.detail.item;if(this.selectedItem!==collapsedItem){const oldSelectedItem=this.selectedItem;if(oldSelectedItem&&collapsedItem.contains(oldSelectedItem)){this.selectItem(collapsedItem)}}}onSidenavItemEnabledChanged(e){const item=e.detail.item;if(item.enabled){item.reveal();this.enableItem(item)}}async onTreeDblClicked(e){if(!this.doubleclickExpands)return;const treeItem=e.target;if(treeItem&&!isSidenavItem(treeItem)){return}if(treeItem.disabled){e.stopImmediatePropagation();e.preventDefault();return}const innerClickTarget=e.composedPath()[0];if(innerClickTarget.className!=="expand-icon"&&treeItem.hasChildren()){treeItem.expanded=!treeItem.expanded}}onTreeKeyDown(e){const selectedItem=this.selectedItem;const selectableItems=this.selectableItems;const currentIndex=selectableItems.findIndex((i=>i===selectedItem));if(e.ctrlKey){return}if(!selectedItem||currentIndex===-1){return}let itemToSelect=null;switch(e.key){case"ArrowUp":if(currentIndex>0){itemToSelect=selectableItems[currentIndex-1]}break;case"ArrowDown":if(currentIndex<selectableItems.length-1){itemToSelect=selectableItems[currentIndex+1]}break;case"ArrowLeft":case"ArrowRight":if(e.altKey){break}const expandKey=isRTL$1(this)?"ArrowLeft":"ArrowRight";if(e.key===expandKey){if(selectedItem.hasChildren()&&!selectedItem.expanded){selectedItem.expanded=true}else{itemToSelect=selectedItem.selectableItems[0]}}else{if(selectedItem.expanded){selectedItem.expanded=false}else{itemToSelect=selectedItem.parentItem}}break;case"Home":itemToSelect=this.selectableItems[0];break;case"End":itemToSelect=this.selectableItems[this.selectableItems.length-1];break;case"*":for(const item of this.selectableItems){if(item.parentItem===selectedItem.parentItem){item.expanded=true}}break}if(e.key.match("^[A-Za-z]$")){for(let searchIndex=(currentIndex+1)%selectableItems.length;searchIndex!==currentIndex;searchIndex=(searchIndex+1)%selectableItems.length){const searchItem=selectableItems[searchIndex];if(searchItem.label.toLowerCase().startsWith(e.key.toLowerCase())){itemToSelect=searchItem;break}}}if(itemToSelect){this.selectItem(itemToSelect);e.preventDefault()}}enableItem(itemToEnable){const previousEnabledItem=this.items.find((item=>item.enabled&&item!==itemToEnable))||null;if(previousEnabledItem){previousEnabledItem.enabled=false}if(itemToEnable){itemToEnable.enabled=true;this.selectItem(itemToEnable);itemToEnable.scrollIntoViewIfNeeded(false)}const enabledChangeEvent=new CustomEvent(Sidenav.events.SIDENAV_ENABLED_CHANGED,{bubbles:true,composed:true,detail:{previousEnabledItem:previousEnabledItem,enabledItem:itemToEnable}});this.dispatchEvent(enabledChangeEvent)}selectItem(itemToSelect){const oldSelectedItem=this.items.find((item=>isSelected(item)&&item!==itemToSelect));if(oldSelectedItem)oldSelectedItem.tabIndex=-1;itemToSelect.tabIndex=0;if(this.contains(shadowPiercingActiveItem())){if(oldSelectedItem)oldSelectedItem.blur();itemToSelect.updateComplete.then((()=>{itemToSelect.focus()}))}}}customElements.define("cros-sidenav",Sidenav);const styleMod$2=document.createElement("dom-module");styleMod$2.appendChild(html`
  <template>
    <style include="cros-color-overrides">
h2{font:var(--cros-title-1-font)}code{background-color:var(--cros-sys-app_base_shaded);border-radius:10px;display:block;margin-top:10px;padding:10px}settings-row,settings-dropdown-row,settings-slider-row{background-color:var(--cros-sys-surface1);margin-bottom:8px}
    </style>
  </template>
`.content);styleMod$2.register("storybook-styles");function getTemplate$2D(){return html`<!--_html_template_start_--><style include="storybook-styles"></style>

<h2>Basic</h2>
<settings-dropdown-row
    label="Lorem ipsum"
    sublabel="Lorem ipsum dolor sit amet"
    icon="os-settings:display"
    learn-more-url="https://google.com"
    value="[[basicDropdownValue_]]"
    options="[[dropdownOptions_]]"
    on-change="onBasicDropdownChange_"
    disabled="[[basicDropdownDisabled_]]">
</settings-dropdown-row>

<cr-checkbox checked="{{basicDropdownDisabled_}}">Disabled</cr-checkbox>

<code>
  <div>Value: [[basicDropdownValue_]]</div>
</code>

<h2>Managed (via pref)</h2>
<settings-dropdown-row
    pref="[[virtualManagedPref_]]"
    label="Lorem ipsum"
    sublabel="Lorem ipsum dolor sit amet"
    icon="os-settings:display"
    learn-more-url="https://google.com"
    options="[[dropdownOptions_]]">
</settings-dropdown-row>
<!--_html_template_end_-->`}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class SettingsDropdownRowStorybook extends PolymerElement{static get is(){return"settings-dropdown-row-storybook"}static get template(){return getTemplate$2D()}static get properties(){return{basicDropdownValue_:{type:Number,value:2},basicDropdownDisabled_:{type:Boolean,value:false},dropdownOptions_:{type:Array,value:()=>[{label:"Lion",value:1},{label:"Tiger",value:2},{label:"Bear",value:3},{label:"Dragon",value:4}]},virtualManagedPref_:{type:Object,value:{key:"virtual_managed_pref",type:chrome.settingsPrivate.PrefType.NUMBER,value:2,enforcement:chrome.settingsPrivate.Enforcement.ENFORCED,controlledBy:chrome.settingsPrivate.ControlledBy.DEVICE_POLICY}}}}onBasicDropdownChange_(event){this.basicDropdownValue_=event.detail}}customElements.define(SettingsDropdownRowStorybook.is,SettingsDropdownRowStorybook);function getTemplate$2C(){return html`<!--_html_template_start_--><style include="storybook-styles"></style>

<h2>Basic</h2>
<settings-dropdown-v2
    value="[[basicDropdownValue_]]"
    options="[[dropdownOptions_]]"
    on-change="onBasicDropdownChange_"
    disabled="[[basicDropdownDisabled_]]"
    aria-label="A11y label"
    aria-description="A11y description">
</settings-dropdown-v2>

<cr-checkbox checked="{{basicDropdownDisabled_}}">Disabled</cr-checkbox>

<code>
  <div>Value: [[basicDropdownValue_]]</div>
</code>

<h2>Managed (via pref)</h2>
<settings-dropdown-v2
    pref="[[virtualManagedPref_]]"
    options="[[dropdownOptions_]]">
</settings-dropdown-v2>
<!--_html_template_end_-->`}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class SettingsDropdownV2Storybook extends PolymerElement{static get is(){return"settings-dropdown-v2-storybook"}static get template(){return getTemplate$2C()}static get properties(){return{basicDropdownValue_:{type:Number,value:2},basicDropdownDisabled_:{type:Boolean,value:false},dropdownOptions_:{type:Array,value:()=>[{label:"Lion",value:1},{label:"Tiger",value:2},{label:"Bear",value:3},{label:"Dragon",value:4}]},virtualManagedPref_:{type:Object,value:{key:"virtual_managed_pref",type:chrome.settingsPrivate.PrefType.NUMBER,value:2,enforcement:chrome.settingsPrivate.Enforcement.ENFORCED,controlledBy:chrome.settingsPrivate.ControlledBy.DEVICE_POLICY}}}}onBasicDropdownChange_(event){this.basicDropdownValue_=event.detail}}customElements.define(SettingsDropdownV2Storybook.is,SettingsDropdownV2Storybook);function getTemplate$2B(){return html`<!--_html_template_start_--><style include="storybook-styles"></style>

<h2>Simple</h2>
<settings-row label="Lorem ipsum" sublabel="">
</settings-row>

<h2>With optional sublabel</h2>
<settings-row label="Lorem ipsum" sublabel="Lorem ipsum dolor sit amet">
</settings-row>

<h2>With optional leading icon</h2>
<settings-row label="Lorem ipsum"
    sublabel="Lorem ipsum dolor sit amet"
    icon="os-settings:display">
</settings-row>

<h2>With optional slotted icon</h2>
<settings-row label="Lorem ipsum"
    sublabel="Lorem ipsum dolor sit amet">
  <img src="chrome://resources/images/extension.svg"
      width="20" height="20"
      slot="icon">
  </img>
</settings-row>

<h2>With optional learn more link</h2>
<settings-row label="Lorem ipsum"
    sublabel="Lorem ipsum dolor sit amet"
    learn-more-url="https://google.com">
</settings-row>

<h2>With optional slotted control element</h2>
<settings-row label="Lorem ipsum"
    sublabel="Lorem ipsum dolor sit amet"
    learn-more-url="https://google.com">
  <settings-toggle-v2 slot="control"></settings-toggle-v2>
</settings-row>

<h2>"Kitchen sink"</h2>
<settings-row label="Lorem ipsum"
    sublabel="Lorem ipsum dolor sit amet"
    learn-more-url="https://google.com"
    icon="os-settings:display">
  <settings-toggle-v2 slot="control"></settings-toggle-v2>
</settings-row>
<!--_html_template_end_-->`}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class SettingsRowStorybook extends PolymerElement{static get is(){return"settings-row-storybook"}static get template(){return getTemplate$2B()}}customElements.define(SettingsRowStorybook.is,SettingsRowStorybook);function getTemplate$2A(){return html`<!--_html_template_start_--><style include="storybook-styles"></style>

<h2>Slider with ticks</h2>
<settings-slider-row label="Lorem ipsum" sublabel="Lorem ipsum dolor sit amet"
    icon="os-settings:display" ticks="[[ticks_]]" value="5"
    aria-label="A11y label" aria-description="A11y description"
    disabled="[[disabled_]]">
</settings-slider-row>
<cr-checkbox checked="{{disabled_}}">Disabled</cr-checkbox>

<h2>Slider with ticks, hide markers</h2>
<settings-slider-row label="Lorem ipsum" sublabel="Lorem ipsum dolor sit amet"
    icon="os-settings:display" ticks="[[ticks_]]" value="5" hide-markers>
</settings-slider-row>

<h2>Mananged</h2>
<settings-slider-row label="Lorem ipsum" ticks="[[ticks_]]"
    pref="[[virtualManagedPref_]]">
</settings-slider-row>

<h2>Slider with scale</h2>
<settings-slider-row label="Lorem ipsum" sublabel="Lorem ipsum dolor sit amet"
    icon="os-settings:display" min="0" max="10" scale="10" min-label="min"
    max-label="max" hide-label="[[hideLabel_]]"
    value="[[sliderValueWithScale_]]"
    on-change="onScaleSliderChange_"
    update-value-instantly="[[updateValueInstantly_]]">
</settings-slider-row>
<cr-checkbox checked="{{hideLabel_}}">Hide labels</cr-checkbox>
<cr-checkbox checked="{{updateValueInstantly_}}">
  Update value instantly
</cr-checkbox>
<code>
  <div>Slider value: [[sliderValueWithScale_]]</div>
</code>
<!--_html_template_end_-->`}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class SettingsSliderRowStorybook extends PolymerElement{static get is(){return"settings-slider-row-storybook"}static get template(){return getTemplate$2A()}static get properties(){return{sliderValueWithScale_:{type:Number,value:.5},virtualManagedPref_:{type:Object,value:{key:"virtual_managed_pref",type:chrome.settingsPrivate.PrefType.NUMBER,value:5,enforcement:chrome.settingsPrivate.Enforcement.ENFORCED,controlledBy:chrome.settingsPrivate.ControlledBy.DEVICE_POLICY}},ticks_:{type:Array,value:()=>[{label:"0",value:0},{label:"5",value:5},{label:"10",value:10},{label:"15",value:15},{label:"20",value:20}]},hideLabel_:{type:Boolean,value:false},updateValueInstantly_:{type:Boolean,value:false},disabled_:{type:Boolean,value:false}}}onScaleSliderChange_(event){this.sliderValueWithScale_=event.detail}}customElements.define(SettingsSliderRowStorybook.is,SettingsSliderRowStorybook);function getTemplate$2z(){return html`<!--_html_template_start_--><style include="storybook-styles"></style>

<h2>With ticks</h2>
<settings-slider-v2
    value="[[sliderValueWithTicks_]]"
    ticks="[[ticks_]]"
    on-change="onTicksSliderChange_"
    disabled="[[disabled_]]"
    aria-label="A11y label"
    aria-description="A11y description">
</settings-slider-v2>
<cr-checkbox checked="{{disabled_}}">Disabled</cr-checkbox>
<code>
  <div>Value: [[sliderValueWithTicks_]]</div>
</code>

<h2>With ticks, hide markers</h2>
<settings-slider-v2
    value="[[sliderValueWithTicks_]]"
    ticks="[[ticks_]]"
    hide-markers
    on-change="onTicksSliderChange_">
</settings-slider-v2>
<code>
  <div>Value: [[sliderValueWithTicks_]]</div>
</code>

<h2>With scale</h2>
<settings-slider-v2
    value="[[sliderValueWithScale_]]"
    scale="10"
    min="0"
    max="10"
    min-label="min"
    max-label="max"
    hide-label="[[hideLabel_]]"
    on-change="onScaleSliderChange_">
</settings-slider-v2>
<cr-checkbox checked="{{hideLabel_}}">Hide labels</cr-checkbox>
<code>
  <div>Value: [[sliderValueWithScale_]]</div>
</code>

<h2>Managed (via pref)</h2>
<settings-slider-v2
    pref="[[virtualManagedPref_]]"
    ticks="[[ticks_]]">
</settings-slider-v2>
<!--_html_template_end_-->`}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class SettingsSliderV2Storybook extends PolymerElement{static get is(){return"settings-slider-v2-storybook"}static get template(){return getTemplate$2z()}static get properties(){return{sliderValueWithTicks_:{type:Number,value:5},sliderValueWithScale_:{type:Number,value:.5},hideLabel_:{type:Boolean,value:false},virtualManagedPref_:{type:Object,value:{key:"virtual_managed_pref",type:chrome.settingsPrivate.PrefType.NUMBER,value:5,enforcement:chrome.settingsPrivate.Enforcement.ENFORCED,controlledBy:chrome.settingsPrivate.ControlledBy.DEVICE_POLICY}},disabled_:{type:Boolean,value:false},ticks_:{type:Array,value:()=>[{label:"0",value:0},{label:"5",value:5},{label:"10",value:10},{label:"15",value:15},{label:"20",value:20}]}}}onTicksSliderChange_(event){this.sliderValueWithTicks_=event.detail}onScaleSliderChange_(event){this.sliderValueWithScale_=event.detail}}customElements.define(SettingsSliderV2Storybook.is,SettingsSliderV2Storybook);function getTemplate$2y(){return html`<!--_html_template_start_--><style include="storybook-styles"></style>

<h2>Basic</h2>
<settings-toggle-v2
    checked="[[checkedValue_]]"
    disabled="[[basicToggleDisabled_]]"
    on-change="onCheckedValueChange_">
</settings-toggle-v2>
<cr-checkbox checked="{{basicToggleDisabled_}}">Disabled</cr-checkbox>
<code>
  <div>Value: [[checkedValue_]]</div>
</code>

<h2>Managed (via pref)</h2>
<settings-toggle-v2
    pref="[[virtualManagedPref_]]">
</settings-toggle-v2>

<h2>Inverted (used with pref)</h2>
<settings-toggle-v2
    pref="[[virtualPref_]]"
    on-change="onInvertedToggleChanged_"
    inverted>
</settings-toggle-v2>
<code>
  <div>pref value: [[virtualPref_.value]]</div>
</code>

<h2>noSetPref (used with pref)</h2>
<settings-toggle-v2
    id="noSetPrefToggle"
    checked="[[prefCheckedValue_]]"
    pref="[[virtualPref_]]"
    on-change="enableDialog_"
    on-user-action-setting-pref-change="handlePrefChange_"
    no-set-pref>
</settings-toggle-v2>
<code>
  <div>pref value: [[virtualPref_.value]]</div>
</code>

<template is="dom-if" if="[[showBasicDialog_]]" restamp>
  <cr-dialog id="dialog" show-on-attach>
    <div slot="title">
      Basic Dialog
    </div>
    <div slot="body">
      <div id="secureDnsDialogDescription">
        <div>
          If cancel is clicked, the dialog will close and the value of the
          toggle resets to the original value (pref's value).
        </div>
        <div>
          If confirm is clicked, the dialog will close and the value of the
          toggle switches. The pref's value will sync to the toggle's value.
        </div>
      </div>
    </div>
    <div slot="button-container">
      <cr-button on-click="onCancelButtonClicked_">
        Cancel
      </cr-button>
      <cr-button on-click="onConfirmButtonClicked_">
        Confirm
      </cr-button>
    </div>
  </cr-dialog>
</template>
<!--_html_template_end_-->`}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class SettingsToggleV2Storybook extends PolymerElement{static get is(){return"settings-toggle-v2-storybook"}static get template(){return getTemplate$2y()}static get properties(){return{checkedValue_:{type:Boolean,value:true},basicToggleDisabled_:{type:Boolean,value:false},prefCheckedValue_:{type:Boolean,value:true},showBasicDialog_:{type:Boolean,value:false},virtualManagedPref_:{type:Object,value:{key:"virtual_managed_pref",type:chrome.settingsPrivate.PrefType.BOOLEAN,value:true,enforcement:chrome.settingsPrivate.Enforcement.ENFORCED,controlledBy:chrome.settingsPrivate.ControlledBy.DEVICE_POLICY}},virtualPref_:{type:Boolean,value:{key:"virtual_pref",type:chrome.settingsPrivate.PrefType.BOOLEAN,value:true}}}}onCheckedValueChange_(event){this.checkedValue_=event.detail}onInvertedToggleChanged_(event){this.set("virtualPref_.value",!event.detail)}handlePrefChange_(event){this.set("virtualPref_.value",event.detail.value)}enableDialog_(){this.showBasicDialog_=true}getToggle_(){const toggle=this.shadowRoot.querySelector("#noSetPrefToggle");assert(toggle);return toggle}closeDialog_(){const dialog=this.shadowRoot.querySelector("cr-dialog");assert(dialog);dialog.close();this.showBasicDialog_=false}onCancelButtonClicked_(){this.closeDialog_();const toggle=this.getToggle_();toggle.resetToPrefValue()}onConfirmButtonClicked_(){this.closeDialog_();const toggle=this.getToggle_();toggle.commitPrefChange()}}customElements.define(SettingsToggleV2Storybook.is,SettingsToggleV2Storybook);function getTemplate$2x(){return html`<!--_html_template_start_--><style>#container{display:flex;flex-direction:row;min-height:400px}#sidenav{background-color:var(--cros-sys-app_base_shaded);box-sizing:border-box;padding:10px;width:200px}#pageContainer{flex-grow:1;padding:20px}</style>

<div id="container">
  <cros-sidenav id="sidenav"
      on-cros-sidenav-item-enabled-changed="onSidenavSelect_">
    <cros-sidenav-item id="0" label="settings-toggle-v2"></cros-sidenav-item>
    <cros-sidenav-item id="1" label="settings-slider-v2"></cros-sidenav-item>
    <cros-sidenav-item id="2" label="settings-dropdown-v2"></cros-sidenav-item>
    <cros-sidenav-item id="3" label="settings-row"></cros-sidenav-item>
    <cros-sidenav-item id="4" label="settings-dropdown-row"></cros-sidenav-item>
    <cros-sidenav-item id="5" label="settings-slider-row"></cros-sidenav-item>
  </cros-sidenav>

  <iron-pages id="pageContainer" selected="[[selectedIndex_]]">
    <settings-toggle-v2-storybook></settings-toggle-v2-storybook>
    <settings-slider-v2-storybook></settings-slider-v2-storybook>
    <settings-dropdown-v2-storybook></settings-dropdown-v2-storybook>
    <settings-row-storybook></settings-row-storybook>
    <settings-dropdown-row-storybook></settings-dropdown-row-storybook>
    <settings-slider-row-storybook></settings-slider-row-storybook>
  </iron-pages>
</div>
<!--_html_template_end_-->`}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class SettingsStorybookSubpage extends PolymerElement{static get is(){return"settings-storybook-subpage"}static get template(){return getTemplate$2x()}static get properties(){return{selectedIndex_:{type:Number,value:0}}}ready(){super.ready();const uiElement=castExists(document.body.querySelector("os-settings-ui"));uiElement.shadowRoot.querySelector("#left").hidden=true}onSidenavSelect_(event){if(event.detail.enabled){this.selectedIndex_=parseInt(event.detail.item.id,10)}}}customElements.define(SettingsStorybookSubpage.is,SettingsStorybookSubpage);function getTemplate$2w(){return html`<!--_html_template_start_--><style include="settings-shared">.separator-line{border-top:var(--cr-separator-line);padding:0}#hotspotToggleText{font-weight:500}#hotspotToggleText[on]{color:var(--cros-text-color-prominent)}#hotspotToggleText:not([on]){color:var(--cros-text-color-secondary)}</style>
<div class="settings-box first">
  <div id="hotspotToggleText" class="start" on$="[[isHotspotToggleOn_]]">
     [[getOnOffString_(hotspotInfo.state)]]
  </div>
  <cr-toggle id="enableHotspotToggle"
      checked="{{isHotspotToggleOn_}}"
      disabled="[[isToggleDisabled_(hotspotInfo.allowStatus,
          hotspotInfo.state)]]"
      on-change="onHotspotToggleChange_"
      aria-label="$i18n{hotspotToggleA11yLabel}"
      deep-link-focus-id$="[[Setting.kHotspotOnOff]]">
  </cr-toggle>
</div>
<div id="hotspotConfigurationRow" class="settings-box two-line">
  <div class="link-wrapper">
    <div id="hotspotSSIDLabel" class="settings-box-text">
        $i18n{hotspotNameLabel}
      <div id="hotspotSSID" class="secondary">
          [[getHotspotConfigSsid_(hotspotInfo.config.ssid)]]
      </div>
    </div>
  </div>
  <cr-button id="configureButton"
      hidden$="[[!showHotspotAutoDisableToggle_(hotspotInfo)]]"
      on-click="onHotspotConfigureClick_">
    $i18n{hotspotConfigureButton}
  </cr-button>
</div>
<template is="dom-if" if="[[showHotspotAutoDisableToggle_(hotspotInfo)]]"
    restamp>
  <settings-toggle-button id="hotspotAutoDisableToggle" class="hr"
      label="$i18n{hotspotAutoDisableLabel}"
      sub-label="$i18n{hotspotAutoDisableSublabel}"
      pref="{{autoDisableVirtualPref_}}"
      on-change="onAutoDisableChange_"
      deep-link-focus-id$="[[Setting.kHotspotAutoDisabled]]">
  </settings-toggle-button>
</template>
<div id="connectedDeviceCountRow"
    class="settings-box settings-box-text two-line single-column stretch"
    hidden$="[[hideConnectedDeviceCount_(hotspotInfo)]]">
  <div id="connectedDeviceCountLabel">
      $i18n{hotspotConnectedDeviceCountLabel}
  </div>
  <div id="connectedDeviceCount" class="secondary">
      [[getHotspotConnectedDeviceCount_(hotspotInfo.clientCount)]]
  </div>
</div>
<div class="separator-line"></div>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsHotspotSubpageElementBase=DeepLinkingMixin(RouteObserverMixin(PrefsMixin(I18nMixin(PolymerElement))));class SettingsHotspotSubpageElement extends SettingsHotspotSubpageElementBase{constructor(){super(...arguments);this.supportedSettingIds=new Set([Setting.kHotspotOnOff,Setting.kHotspotAutoDisabled])}static get is(){return"settings-hotspot-subpage"}static get template(){return getTemplate$2w()}static get properties(){return{hotspotInfo:{type:Object,observer:"onHotspotInfoChanged_"},isHotspotToggleOn_:{type:Boolean,value:false},autoDisableVirtualPref_:{type:Object,value(){return{key:"fakeAutoDisablePref",type:chrome.settingsPrivate.PrefType.BOOLEAN,value:false}}}}}currentRouteChanged(route,_oldRoute){if(route!==routes.HOTSPOT_DETAIL){return}this.attemptDeepLink()}onHotspotInfoChanged_(newValue,_oldValue){this.isHotspotToggleOn_=newValue.state===HotspotState.kEnabled||newValue.state===HotspotState.kEnabling;this.updateAutoDisablePref_()}updateAutoDisablePref_(){if(!this.hotspotInfo?.config){return}const newPrefValue={key:"fakeAutoDisablePref",value:this.hotspotInfo.config.autoDisable,type:chrome.settingsPrivate.PrefType.BOOLEAN};this.autoDisableVirtualPref_=newPrefValue}isToggleDisabled_(){if(!this.hotspotInfo){return true}if(this.hotspotInfo.state===HotspotState.kDisabling){return true}if(this.hotspotInfo.state===HotspotState.kEnabling||this.hotspotInfo.state===HotspotState.kEnabled){return false}return this.hotspotInfo.allowStatus!==HotspotAllowStatus.kAllowed}getOnOffString_(){if(!this.hotspotInfo){return this.i18n("hotspotSummaryStateOff")}if(this.hotspotInfo.state===HotspotState.kEnabling){return this.i18n("hotspotSummaryStateTurningOn")}if(this.hotspotInfo.state===HotspotState.kEnabled){return this.i18n("hotspotSummaryStateOn")}if(this.hotspotInfo.state===HotspotState.kDisabling){return this.i18n("hotspotSummaryStateTurningOff")}return this.i18n("hotspotSummaryStateOff")}setHotspotEnabledState_(enabled){if(enabled){getHotspotConfig().enableHotspot();return}getHotspotConfig().disableHotspot()}onHotspotToggleChange_(){this.setHotspotEnabledState_(this.isHotspotToggleOn_);getInstance().announce(this.isHotspotToggleOn_?this.i18n("hotspotEnabledA11yLabel"):this.i18n("hotspotDisabledA11yLabel"))}getHotspotConfigSsid_(ssid){return ssid||""}hideConnectedDeviceCount_(){return this.hotspotInfo?.state!==HotspotState.kEnabled&&this.hotspotInfo?.state!==HotspotState.kDisabling}getHotspotConnectedDeviceCount_(clientCount){return clientCount||0}showHotspotAutoDisableToggle_(hotspotInfo){return!!hotspotInfo?.config}onHotspotConfigureClick_(){const event=new CustomEvent("show-hotspot-config-dialog",{bubbles:true,composed:true});this.dispatchEvent(event)}async onAutoDisableChange_(){const configToSet=castExists(this.hotspotInfo.config);configToSet.autoDisable=this.autoDisableVirtualPref_.value;const response=await getHotspotConfig().setHotspotConfig(configToSet);if(response.result!==SetHotspotConfigResult.kSuccess){const newPrefValue={key:"fakeEnabledPref",value:!configToSet.autoDisable,type:chrome.settingsPrivate.PrefType.BOOLEAN};this.autoDisableVirtualPref_=newPrefValue}}}customElements.define(SettingsHotspotSubpageElement.is,SettingsHotspotSubpageElement);function getTemplate$2v(){return html`<!--_html_template_start_--><style include="cr-shared-style network-shared iron-flex">
  /* Property lists are embedded; remove the padding. */
  .property-box {
    padding: 0;
    width: var(--cr-property-box-width, inherit);
  }

  cr-input[readonly] {
    --cr-input-background-color: transparent;
  }

  cr-policy-network-indicator-mojo {
    margin-inline-start: var(--settings-controlled-by-spacing);
  }

  .secure {
    -webkit-text-security: disc;
  }
</style>
<template is="dom-repeat" items="[[fields]]"
    filter="[[computeFilter_(prefix, editFieldTypes, propertyDict)]]">
  <div class="property-box single-column two-line stretch">
    <!-- Property label -->
    <div class="layout horizontal center">
      <div>[[getPropertyLabel_(item, prefix)]]</div>
      <template is="dom-if" restamp
          if="[[isEditType_(item, editFieldTypes)]]">
        <cr-policy-network-indicator-mojo
            property="[[getIndicatorProperty_(item, propertyDict)]]">
        </cr-policy-network-indicator-mojo>
      </template>
    </div>
    <!-- Uneditable property value -->
    <template is="dom-if" restamp
        if="[[!showEditable_(item, editFieldTypes, propertyDict)]]">
      <div id="[[item]]"
          class$="[[getPropertyValueCssClasses_(item, prefix, propertyDict)]]"
          data-key$="[[item]]">
        [[getPropertyValue_(item, prefix, propertyDict)]]
      </div>
    </template>
    <!-- Editable property value -->
    <template is="dom-if" restamp
        if="[[showEditable_(item, editFieldTypes, propertyDict)]]">
      <cr-input id="[[item]]"
          readonly="[[!isEditable_(item, editFieldTypes, propertyDict)]]"
          value="[[getPropertyValue_(item, prefix, propertyDict)]]"
          on-change="onValueChange_"
          type="[[getEditInputType_(item, editFieldTypes)]]"
          on-focus="onInputFocused_"
          edited="false"
          disabled="[[disabled]]">
      </cr-input>
    </template>
  </div>
</template>
<!--_html_template_end_-->`}
// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const NetworkPropertyListMojoElementBase=mixinBehaviors([I18nBehavior,CrPolicyNetworkBehaviorMojo],PolymerElement);class NetworkPropertyListMojoElement extends NetworkPropertyListMojoElementBase{static get is(){return"network-property-list-mojo"}static get template(){return getTemplate$2v()}static get properties(){return{propertyDict:{type:Object,observer:"onPropertyDictChanged_"},fields:{type:Array,value(){return[]}},editFieldTypes:{type:Object,value(){return{}}},prefix:{type:String,value:""},allFieldsReadOnly:{type:Boolean,value:true,readonly:true,observer:"onAllFieldsReadOnlyChanged_"},disabled:{type:Boolean,value:false},hasAnyInputFocused_:{type:Boolean,value:false}}}onAllFieldsReadOnlyChanged_(){if(this.allFieldsReadOnly){return}this.hasAnyInputFocused_=false;setTimeout((()=>{this.attemptToFocusFirstEditableCrInput_()}))}onPropertyDictChanged_(){if(this.allFieldsReadOnly||this.hasAnyInputFocused_){return}this.attemptToFocusFirstEditableCrInput_()}attemptToFocusFirstEditableCrInput_(){flush();const crInput=this.shadowRoot.querySelector("cr-input:not([readonly])");if(!crInput){return}crInput.focusInput()}onInputFocused_(e){if(this.allFieldsReadOnly){return}const crInput=e.target;if(crInput.getAttribute("edited")==="true"){return}crInput.setAttribute("edited",true);crInput.select();this.hasAnyInputFocused_=true}onValueChange_(event){if(!this.propertyDict){return}const key=event.target.id;let curValue=this.getProperty_(key);if(typeof curValue==="object"&&!Array.isArray(curValue)){curValue=OncMojo.getActiveValue(curValue)}const newValue=this.getValueFromEditField_(key,event.target.value);if(newValue===curValue){return}this.dispatchEvent(new CustomEvent("property-change",{bubbles:true,composed:true,detail:{field:key,value:newValue}}))}getOncKey_(key,opt_prefix){if(opt_prefix){key=opt_prefix+key.charAt(0).toUpperCase()+key.slice(1)}let result="";const subKeys=key.split(".");subKeys.forEach((subKey=>{if(subKey==="ipv4"||subKey==="ipv6"){result+=subKey}else if(subKey==="apn"){result+="APN"}else if(subKey==="ipAddress"){result+="IPAddress"}else if(subKey==="ipSec"){result+="IPSec"}else if(subKey==="l2tp"){result+="L2TP"}else if(subKey==="modelId"){result+="ModelID"}else if(subKey==="openVpn"){result+="OpenVPN"}else if(subKey==="otp"){result+="OTP"}else if(subKey==="ssid"){result+="SSID"}else if(subKey==="bssid"){result+="BSSID"}else if(subKey==="serverCa"){result+="ServerCA"}else if(subKey==="vpn"){result+="VPN"}else if(subKey==="wifi"){result+="WiFi"}else if(subKey==="iccid"){result+="ICCID"}else if(subKey==="imei"){result+="IMEI"}else{result+=subKey.charAt(0).toUpperCase()+subKey.slice(1)}result+="-"}));return"Onc"+result.slice(0,result.length-1)}getPropertyLabel_(key){const oncKey=this.getOncKey_(key,this.prefix);if(this.i18nExists(oncKey)){return this.i18n(oncKey)}const result=this.prefix+key;for(const type of["cellular","ethernet","tether","vpn","wifi"]){if(result.startsWith(type+".")){return result.substr(type.length+1)}}return result}computeFilter_(){return key=>{if(this.editFieldTypes.hasOwnProperty(key)){return true}const value=this.getPropertyValue_(key);return value!==""}}isPropertyEditable_(key){if(!this.propertyDict){return false}const property=this.getProperty_(key);if(property===undefined||property===null){const source=this.propertyDict.source;return source!==OncSource.kUserPolicy&&source!==OncSource.kDevicePolicy}return!this.isNetworkPolicyEnforced(property)}isEditType_(key){const editType=this.editFieldTypes[key];return editType==="String"||editType==="StringArray"||editType==="Password"}isEditable_(key){return this.isEditType_(key)&&this.isPropertyEditable_(key)}showEditable_(key){return this.isEditable_(key)}getEditInputType_(key){return this.editFieldTypes[key]==="Password"?"password":"text"}getProperty_(key){if(!this.propertyDict){return undefined}key=OncMojo.getManagedPropertyKey(key);const property=this.get(key,this.propertyDict);if(property===null||property===undefined){return undefined}return property}getIndicatorProperty_(key){if(!this.propertyDict){return undefined}const property=this.getProperty_(key);if((property===undefined||property===null)&&this.propertyDict.source){const policySource=OncMojo.getEnforcedPolicySourceFromOncSource(this.propertyDict.source);if(policySource!==PolicySource.kNone){return{activeValue:"",policySource:policySource}}}return property}getPropertyValue_(key){let value=this.getProperty_(key);if(value===undefined||value===null){return""}if(typeof value==="object"&&!Array.isArray(value)){value=OncMojo.getActiveValue(value)}if(key==="wifi.eap.subjectAltNameMatch"){return OncMojo.serializeSubjectAltNameMatch(value)}if(key==="wifi.eap.domainSuffixMatch"){return OncMojo.serializeDomainSuffixMatch(value)}if(Array.isArray(value)){return value.join(", ")}const customValue=this.getCustomPropertyValue_(key,value);if(customValue){return customValue}if(typeof value==="boolean"){return value.toString()}let valueStr;if(typeof value==="number"){if(key==="cellular.activationState"){valueStr=OncMojo.getActivationStateTypeString(value)}else if(key==="portalState"){valueStr=OncMojo.getPortalStateString(value)}else if(key==="vpn.type"){valueStr=OncMojo.getVpnTypeString(value)}else if(key==="wifi.security"){valueStr=OncMojo.getSecurityTypeString(value)}else{return value.toString()}}else{assert$1(typeof value==="string");valueStr=value}const oncKey=this.getOncKey_(key,this.prefix)+"_"+valueStr;if(this.i18nExists(oncKey)){return this.i18n(oncKey)}return valueStr}getPropertyValueCssClasses_(key){const classes=["cr-secondary-text"];if(this.getPropertyValue_(key)===FAKE_CREDENTIAL){classes.push("secure")}return classes.join(" ")}getValueFromEditField_(key,fieldValue){const editType=this.editFieldTypes[key];if(editType==="StringArray"){return fieldValue.toString().split(/, */)}return fieldValue}getCustomPropertyValue_(key,value){if(key==="tether.batteryPercentage"){assert$1(typeof value==="number");return this.i18n("OncTether-BatteryPercentage_Value",value.toString())}if(key==="tether.signalStrength"){assert$1(typeof value==="number");if(value===0){return this.i18n("OncTether-SignalStrength_None")}if(value<=25){return this.i18n("OncTether-SignalStrength_Low")}if(value<=50){return this.i18n("OncTether-SignalStrength_Medium")}return this.i18n("OncTether-SignalStrength_Strong")}if(key==="tether.carrier"){assert$1(typeof value==="string");return!value||value==="unknown-carrier"?this.i18n("OncTether-Carrier_Unknown"):value}return""}}customElements.define(NetworkPropertyListMojoElement.is,NetworkPropertyListMojoElement);function getTemplate$2u(){return html`<!--_html_template_start_--><style include="network-shared md-select">
  :host {
    --cr-property-box-width: 200px;
  }

  cr-button {
    margin: 4px 0;
  }

  #attachApnPropertyRow {
    display: flex;
    min-height: 0;
    padding-bottom: 20px;
    padding-top: 8px;
    width: var(--cr-property-box-width);
  }

  #attachApnDescription {
    display: flex;
  }

  #attachApnTooltip {
    --cr-icon-size: 16px;
    margin-inline-start: 6px;
  }
</style>
<div class="property-box">
  <div class="start">[[i18n('networkAccessPoint')]]</div>
  <select id="selectApn" class="md-select" on-change="onSelectApnChange_"
      value="[[selectedApn_]]"
      disabled="[[isDisabled_(disabled, selectedApn_)]]"
      aria-label="[[i18n('networkAccessPoint')]]">
    <template is="dom-repeat" items="[[apnSelectList_]]">
      <option value="[[item.name]]">
        [[apnDesc_(item)]]
      </option>
    </template>
  </select>
</div>

<template is="dom-if" if="[[showOtherApn_(selectedApn_)]]">
  <div id="otherApnProperties" class="property-box single-column indented">
    <network-property-list-mojo on-property-change="onOtherApnChange_"
        fields="[[otherApnFields_]]" property-dict="[[otherApn_]]"
        edit-field-types="[[otherApnEditTypes_]]" prefix="cellular.apn."
        disabled="[[disabled]]">
    </network-property-list-mojo>
    <div id="attachApnPropertyRow" class="property-box horizontal center">
      <div id="attachApnDescription" class="start" aria-hidden="true">
        <span id="attachApnTitle">[[i18n('OncCellular-APN-Attach')]]</span>
        <cr-tooltip-icon id="attachApnTooltip" tooltip-position="right"
            icon-class="cr:help-outline"
            tooltip-text="[[i18n('OncCellular-APN-Attach_TooltipText')]]">
        </cr-tooltip-icon>
      </div>
      <cr-toggle id="attachApnControl" aria-labelledby="attachApnTitle"
          aria-describedby="attachApnTooltip"
          checked="{{isAttachApnToggleEnabled_}}"
          disabled="[[disabled]]">
      </cr-toggle>
    </div>
    <cr-button id="saveButton" class="action-button"
        on-click="onSaveOtherTap_" disabled="[[disabled]]">
      [[i18n('save')]]
    </cr-button>
  </div>
</template>
<!--_html_template_end_-->`}
// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const kDefaultAccessPointName="NONE";const kOtherAccessPointName="Other";const USE_ATTACH_APN_ON_SAVE_METRIC_NAME="Network.Cellular.Apn.UseAttachApnOnSave";const NetworkApnListElementBase=I18nMixin(PolymerElement);class NetworkApnListElement extends NetworkApnListElementBase{static get is(){return"network-apnlist"}static get template(){return getTemplate$2u()}static get properties(){return{disabled:{type:Boolean,value:false},managedProperties:{type:Object,observer:"managedPropertiesChanged"},selectedApn_:{type:String,value:""},apnSelectList_:{type:Array,value(){return[]}},otherApn_:{type:Object,value(){return{accessPointName:kDefaultAccessPointName,name:kOtherAccessPointName,state:ApnState.kEnabled,authentication:ApnAuthenticationType.kAutomatic,ipType:ApnIpType.kAutomatic,apnTypes:[ApnType.kDefault],source:ApnSource.kUi}}},otherApnFields_:{type:Array,value(){return["accessPointName","username","password"]},readOnly:true},otherApnEditTypes_:{type:Object,value(){return{accessPointName:"String",username:"String",password:"Password"}},readOnly:true},isAttachApnToggleEnabled_:{type:Boolean,value:false}}}getApnSelect(){return this.shadowRoot.querySelector("#selectApn")}getApnFromManaged(apn){return{accessPointName:OncMojo.getActiveString(apn.accessPointName),localizedName:OncMojo.getActiveString(apn.localizedName),name:OncMojo.getActiveString(apn.name),password:OncMojo.getActiveString(apn.password),username:OncMojo.getActiveString(apn.username),authentication:ApnAuthenticationType.kAutomatic,state:ApnState.kEnabled,ipType:ApnIpType.kAutomatic,apnTypes:[ApnType.kDefault],source:ApnSource.kModem,id:null,language:null,attach:null}}getActiveApnFromProperties(managedProperties){const cellular=managedProperties.typeProperties.cellular;assert(cellular);let activeApn;if(cellular.selectedApn){activeApn=this.getApnFromManaged(cellular.selectedApn)}else if(cellular.lastGoodApn&&cellular.lastGoodApn.accessPointName){activeApn=cellular.lastGoodApn}if(activeApn&&!activeApn.accessPointName){activeApn=undefined}return activeApn}shouldUpdateSelectList(oldManagedProperties){if(!oldManagedProperties){return true}const newActiveApn=this.getActiveApnFromProperties(this.managedProperties);const oldActiveApn=this.getActiveApnFromProperties(oldManagedProperties);if(newActiveApn&&oldActiveApn&&!OncMojo.apnMatch(newActiveApn,oldActiveApn)||newActiveApn&&!oldActiveApn||!newActiveApn&&oldActiveApn){return true}assert(this.managedProperties);const newApnList=this.managedProperties.typeProperties.cellular.apnList;const oldApnList=oldManagedProperties.typeProperties.cellular.apnList;if(!OncMojo.apnListMatch(oldApnList?.activeValue,newApnList?.activeValue)){return true}const newCustomApnList=this.managedProperties.typeProperties.cellular.customApnList;const oldCustomApnList=oldManagedProperties.typeProperties.cellular.customApnList;if(!OncMojo.apnListMatch(oldCustomApnList,newCustomApnList)){return true}return false}managedPropertiesChanged(managedProperties,oldManagedProperties){if(!this.shouldUpdateSelectList(oldManagedProperties)){return}this.setApnSelectList(this.getActiveApnFromProperties(managedProperties))}setApnSelectList(activeApn){const apnList=this.generateApnList();if(apnList===undefined||apnList.length===0){this.apnSelectList_=[this.otherApn_];this.set("selectedApn_",kOtherAccessPointName);return}let activeApnInList;if(activeApn){activeApnInList=apnList.find((a=>a.name===activeApn.name))}assert(this.managedProperties);assert(this.managedProperties.typeProperties.cellular);const customApnList=this.managedProperties.typeProperties.cellular.customApnList;let otherApn=this.otherApn_;if(customApnList&&customApnList.length){otherApn=customApnList[0]}else if(!activeApnInList&&activeApn&&activeApn.accessPointName){otherApn=activeApn}this.isAttachApnToggleEnabled_=otherApn.attach===OncMojo.USE_ATTACH_APN_NAME;this.otherApn_={accessPointName:otherApn.accessPointName,name:otherApn.name,username:otherApn.username,password:otherApn.password,authentication:ApnAuthenticationType.kAutomatic,state:ApnState.kEnabled,ipType:ApnIpType.kAutomatic,apnTypes:[ApnType.kDefault],source:ApnSource.kUi,id:otherApn.id,language:otherApn.language,localizedName:otherApn.localizedName,attach:otherApn.attach};apnList.push(this.otherApn_);this.apnSelectList_=apnList;const selectedApn=activeApnInList?activeApnInList.name:kOtherAccessPointName;assert(selectedApn);this.set("selectedApn_",selectedApn);this.setSelectedApn()}async setSelectedApn(){this.getApnSelect().value=this.selectedApn_}generateApnList(){if(!this.managedProperties){return undefined}assert(this.managedProperties.typeProperties.cellular);const apnList=this.managedProperties.typeProperties.cellular.apnList;if(!apnList){return undefined}return apnList.activeValue.filter((apn=>!!apn.accessPointName)).map((apn=>({accessPointName:apn.accessPointName,localizedName:apn.localizedName,name:apn.name||apn.accessPointName,username:apn.username,password:apn.password,id:apn.id,authentication:apn.authentication,language:apn.language,attach:apn.attach,state:apn.state,ipType:apn.ipType,apnTypes:apn.apnTypes,source:apn.source})))}onSelectApnChange_(event){const target=event.target;const name=target.value;if(name===kOtherAccessPointName&&(!this.otherApn_.accessPointName||this.otherApn_.accessPointName===kDefaultAccessPointName)){this.selectedApn_=name;return}this.sendApnChange(name)}onOtherApnChange_(event){const value=event.detail.field==="accessPointName"?event.detail.value.toUpperCase():event.detail.value;this.set("otherApn_."+event.detail.field,value)}onSaveOtherTap_(){if(this.sendApnChange(this.selectedApn_)){chrome.metricsPrivate.recordBoolean(USE_ATTACH_APN_ON_SAVE_METRIC_NAME,this.isAttachApnToggleEnabled_)}}sendApnChange(name){let apn;if(name===kOtherAccessPointName){if(!this.otherApn_.accessPointName||this.otherApn_.accessPointName===kDefaultAccessPointName){return false}apn={accessPointName:this.otherApn_.accessPointName,username:this.otherApn_.username,password:this.otherApn_.password,attach:this.isAttachApnToggleEnabled_?OncMojo.USE_ATTACH_APN_NAME:"",id:null,authentication:ApnAuthenticationType.kAutomatic,language:null,localizedName:null,name:null,state:ApnState.kEnabled,ipType:ApnIpType.kAutomatic,apnTypes:[ApnType.kDefault],source:ApnSource.kUi}}else{apn=this.apnSelectList_.find((a=>a.name===name));if(apn===undefined){console.error("Selected APN not in list");return false}}apn.apnTypes=[ApnType.kDefault];this.dispatchEvent(new CustomEvent("apn-change",{detail:apn}));return true}isDisabled_(){return this.disabled||this.selectedApn_===""}showOtherApn_(){return this.selectedApn_===kOtherAccessPointName}apnDesc_(apn){assert(apn.name);return apn.localizedName||apn.name}isApnItemSelected(item){return item.accessPointName===this.selectedApn_}}customElements.define(NetworkApnListElement.is,NetworkApnListElement);function getTemplate$2t(){return html`<!--_html_template_start_--><style include="cr-shared-style network-shared md-select iron-flex">
  /* Leave some space between button and select. */
  select {
    margin-inline-start: 8px;
  }
</style>
<div class="property-box first two-line">
  <div class="flex layout vertical">
    <div>[[i18n('networkChooseMobile')]]</div>
    <div class="cr-secondary-text">
      [[getSecondaryText_(managedProperties, deviceState)]]
    </div>
  </div>
  <cr-button on-click="onScanTap_"
      disabled="[[!getEnableScanButton_(managedProperties,
          deviceState, disabled)]]">
    [[i18n('networkCellularScan')]]
  </cr-button>
  <select class="md-select" on-change="onChange_"
      value="[[selectedMobileNetworkId_]]"
      disabled="[[!getEnableSelectNetwork_(managedProperties,
          deviceState, disabled)]]"
      aria-label="[[i18n('networkChooseMobile')]]">
    <template is="dom-repeat" items="[[mobileNetworkList_]]">
      <option value="[[item.networkId]]"
          disabled="[[getMobileNetworkIsDisabled_(item)]]">
        [[getName_(item)]]
      </option>
    </template>
  </select>
</div>
<!--_html_template_end_-->`}
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const NetworkChooseMobileElementBase=I18nMixin(PolymerElement);class NetworkChooseMobileElement extends NetworkChooseMobileElementBase{constructor(){super(...arguments);this.networkConfig_=null;this.scanRequested_=false}static get is(){return"network-choose-mobile"}static get template(){return getTemplate$2t()}static get properties(){return{deviceState:{type:Object,value:null},disabled:{type:Boolean,value:false},managedProperties:{type:Object,observer:"managedPropertiesChanged_"},selectedMobileNetworkId_:{type:String,value:""},mobileNetworkList_:{type:Array,value(){return[]}}}}connectedCallback(){super.connectedCallback();this.scanRequested_=false}getNetworkConfig_(){if(!this.networkConfig_){this.networkConfig_=MojoInterfaceProviderImpl.getInstance().getMojoServiceRemote()}return this.networkConfig_}managedPropertiesChanged_(){assert(this.managedProperties);const cellular=this.managedProperties.typeProperties.cellular;assert(cellular);this.mobileNetworkList_=cellular.foundNetworks||[];if(!this.mobileNetworkList_.length){this.mobileNetworkList_=[{status:"",networkId:"none",technology:"",longName:this.i18n("networkCellularNoNetworks"),shortName:null}]}microTask.run((()=>{let selected=this.mobileNetworkList_.find((mobileNetwork=>mobileNetwork.status==="current"));if(!selected){selected=this.mobileNetworkList_[0]}this.selectedMobileNetworkId_=selected.networkId}))}getMobileNetworkIsDisabled_(foundNetwork){return foundNetwork.status!=="available"&&foundNetwork.status!=="current"}getEnableScanButton_(properties){return!this.disabled&&properties.connectionState===ConnectionStateType.kNotConnected&&!!this.deviceState&&!this.deviceState.scanning}getEnableSelectNetwork_(properties){assert(properties.typeProperties.cellular);return!this.disabled&&!!this.deviceState&&!this.deviceState.scanning&&properties.connectionState===ConnectionStateType.kNotConnected&&!!properties.typeProperties.cellular.foundNetworks&&properties.typeProperties.cellular.foundNetworks.length>0}getSecondaryText_(properties){if(!properties){return""}if(this.deviceState?.scanning){return this.i18n("networkCellularScanning")}if(this.scanRequested_){return this.i18n("networkCellularScanCompleted")}if(properties.connectionState!==ConnectionStateType.kNotConnected){return this.i18n("networkCellularScanConnectedHelp")}return""}getName_(foundNetwork){return foundNetwork.longName||foundNetwork.shortName||foundNetwork.networkId}onScanTap_(){this.scanRequested_=true;this.getNetworkConfig_().requestNetworkScan(NetworkType.kCellular)}onChange_(event){const target=event.target;assert(target instanceof HTMLSelectElement);if(!target.value||target.value==="none"){return}assert(this.managedProperties);this.getNetworkConfig_().selectCellularMobileNetwork(this.managedProperties.guid,target.value)}}customElements.define(NetworkChooseMobileElement.is,NetworkChooseMobileElement);function getTemplate$2s(){return html`<!--_html_template_start_--><style include="network-shared iron-flex">
  cr-toggle {
    margin-inline-start: var(--settings-control-label-spacing);
  }
</style>
<template is="dom-if" if="[[shouldShowAutoIpConfigToggle_]]" restamp>
  <div id="autoConfig" class="property-box">
    <div id="autoIPConfigLabel" class="start">
      [[i18n('networkIPConfigAuto')]]
    </div>
    <cr-policy-indicator indicator-type="[[getPolicyIndicatorType(
        managedProperties.ipAddressConfigType)]]">
    </cr-policy-indicator>
    <cr-toggle id="autoConfigIpToggle" checked="{{automatic_}}"
        disabled="[[!canChangeIPConfigType_(managedProperties, disabled)]]"
        on-change="onAutomaticChange_"
        aria-labelledby="autoIPConfigLabel">
    </cr-toggle>
  </div>
</template>
<template is="dom-if" if="[[hasIpConfigFields_(ipConfig_, ipConfig_.*)]]">
  <div class$="[[getFieldsClassList_(shouldShowAutoIpConfigToggle_)]]">
    <network-property-list-mojo fields="[[ipConfigFields_]]"
        all-fields-read-only="[[automatic_]]"
        property-dict="[[ipConfig_]]"
        edit-field-types="[[getIPEditFields_(automatic_,
            managedProperties)]]"
        on-property-change="onIPChange_"
        disabled="[[disabled]]">
    </network-property-list-mojo>
  </div>
</template>
<!--_html_template_end_-->`}
// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const getRoutingPrefixAsNetmask=function(prefixLength){if(prefixLength<=0||prefixLength>32){return null}let netmask="";for(let i=0;i<4;++i){let remainder=8;if(prefixLength>=8){prefixLength-=8}else{remainder=prefixLength;prefixLength=0}if(i>0){netmask+="."}let value=0;if(remainder!==0){value=(2<<remainder-1)-1<<8-remainder}netmask+=value.toString()}return netmask};const getRoutingPrefixAsLength=function(netmask){if(!netmask){return NO_ROUTING_PREFIX}const tokens=netmask.split(".");if(tokens.length!==4){return NO_ROUTING_PREFIX}let prefixLength=0;for(let i=0;i<tokens.length;++i){const token=tokens[i];if(prefixLength/8!==i){if(token!=="0"){return NO_ROUTING_PREFIX}}else if(token==="255"){prefixLength+=8}else if(token==="254"){prefixLength+=7}else if(token==="252"){prefixLength+=6}else if(token==="248"){prefixLength+=5}else if(token==="240"){prefixLength+=4}else if(token==="224"){prefixLength+=3}else if(token==="192"){prefixLength+=2}else if(token==="128"){prefixLength+=1}else if(token==="0"){prefixLength+=0}else{return NO_ROUTING_PREFIX}}return prefixLength};const NetworkIpConfigElementBase=mixinBehaviors([CrPolicyNetworkBehaviorMojo],I18nMixin(PolymerElement));class NetworkIpConfigElement extends NetworkIpConfigElementBase{static get is(){return"network-ip-config"}static get template(){return getTemplate$2s()}static get properties(){return{disabled:{type:Boolean,value:false},managedProperties:{type:Object,observer:"managedPropertiesChanged_"},automatic_:{type:Boolean,value:true},ipConfig_:Object,ipConfigFields_:{type:Array,value(){return["ipv4.ipAddress","ipv4.netmask","ipv4.gateway","ipv6.ipAddress"]},readOnly:true},shouldShowAutoIpConfigToggle_:{type:Boolean,value:true,computed:"computeShouldShowAutoIpConfigToggle_(managedProperties)"}}}constructor(){super();this.savedStaticIp_=undefined}getAutoConfigIpToggle(){return this.shadowRoot.querySelector("#autoConfigIpToggle")}managedPropertiesChanged_(newValue,oldValue){if(!this.managedProperties){return}const properties=this.managedProperties;if(newValue&&newValue.guid!==(oldValue&&oldValue.guid)){this.savedStaticIp_=undefined}const ipConfigType=OncMojo.getActiveValue(properties.ipAddressConfigType);this.automatic_=ipConfigType!=="Static";if(properties.ipConfigs||properties.staticIpConfig){if(this.automatic_||!oldValue||newValue&&newValue.guid!==(oldValue&&oldValue.guid)||!OncMojo.connectionStateIsConnected(properties.connectionState)){const ipv4=this.getIPConfigUIProperties_(OncMojo.getIPConfigForType(properties,IPConfigType.kIPv4));let ipv6=this.getIPConfigUIProperties_(OncMojo.getIPConfigForType(properties,IPConfigType.kIPv6));if(OncMojo.connectionStateIsConnected(properties.connectionState)&&this.automatic_&&ipv4&&ipv4.ipAddress){ipv6=ipv6||{type:IPConfigType.kIPv6,gateway:null,ipAddress:null,nameServers:null,netmask:null,webProxyAutoDiscoveryUrl:null};if(ipv6){ipv6.ipAddress=ipv6.ipAddress||this.i18n("ipAddressNotAvailable")}}this.ipConfig_={ipv4:ipv4,ipv6:ipv6}}}else{this.ipConfig_=undefined}}canChangeIPConfigType_(managedProperties){if(this.disabled||!managedProperties){return false}if(managedProperties.type===NetworkType.kCellular){return false}const ipConfigType=managedProperties.ipAddressConfigType;return!ipConfigType||!this.isNetworkPolicyEnforced(ipConfigType)}setIpv4Defaults_(){if(!this.ipConfig_||!this.ipConfig_.ipv4){return}if(!this.ipConfig_.ipv4.gateway){this.set("ipConfig_.ipv4.gateway","192.168.1.1")}if(!this.ipConfig_.ipv4.ipAddress){this.set("ipConfig_.ipv4.ipAddress","192.168.1.1")}if(!this.ipConfig_.ipv4.netmask){this.set("ipConfig_.ipv4.netmask","255.255.255.0")}}onAutomaticChange_(){if(!this.automatic_){if(!this.ipConfig_){this.ipConfig_={ipv4:undefined,ipv6:undefined}}if(this.savedStaticIp_){this.ipConfig_.ipv4=this.savedStaticIp_}if(!this.ipConfig_.ipv4){this.ipConfig_.ipv4={type:IPConfigType.kIPv4,gateway:null,ipAddress:null,nameServers:null,netmask:null,webProxyAutoDiscoveryUrl:null}}this.setIpv4Defaults_();this.sendStaticIpConfig_();return}if(this.ipConfig_){this.savedStaticIp_=this.ipConfig_.ipv4}this.dispatchEvent(new CustomEvent("ip-change",{bubbles:true,composed:true,detail:{field:"ipAddressConfigType",value:"DHCP"}}))}getIPConfigUIProperties_(ipconfig){if(!ipconfig){return undefined}const ipconfigUI={gateway:ipconfig.gateway,ipAddress:ipconfig.ipAddress,nameServers:ipconfig.nameServers,type:ipconfig.type,webProxyAutoDiscoveryUrl:ipconfig.webProxyAutoDiscoveryUrl,netmask:ipconfig.routingPrefix!==NO_ROUTING_PREFIX?getRoutingPrefixAsNetmask(ipconfig.routingPrefix):null};return ipconfigUI}getIPConfigProperties_(ipconfigUI){const ipconfig={gateway:ipconfigUI.gateway,ipAddress:ipconfigUI.ipAddress,nameServers:ipconfigUI.nameServers,routingPrefix:getRoutingPrefixAsLength(ipconfigUI.netmask),type:ipconfigUI.type,webProxyAutoDiscoveryUrl:ipconfigUI.webProxyAutoDiscoveryUrl,excludedRoutes:null,includedRoutes:null,searchDomains:null};return ipconfig}hasIpConfigFields_(){if(!this.ipConfig_){return false}for(let i=0;i<this.ipConfigFields_.length;++i){const key=this.ipConfigFields_[i];const value=this.get(key,this.ipConfig_);if(value!==undefined&&value!==""){return true}}return false}getIPFieldEditType_(property){return this.isNetworkPolicyEnforced(property)?undefined:"String"}getIPEditFields_(){const staticIpConfig=this.managedProperties&&this.managedProperties.staticIpConfig;if(this.automatic_||!staticIpConfig){return{}}return{"ipv4.ipAddress":this.getIPFieldEditType_(staticIpConfig.ipAddress),"ipv4.netmask":this.getIPFieldEditType_(staticIpConfig.routingPrefix),"ipv4.gateway":this.getIPFieldEditType_(staticIpConfig.gateway)}}onIPChange_(event){if(!this.ipConfig_){return}const field=event.detail.field;const value=event.detail.value;this.set("ipConfig_."+field,value);this.sendStaticIpConfig_()}sendStaticIpConfig_(){this.dispatchEvent(new CustomEvent("ip-change",{bubbles:true,composed:true,detail:{field:"staticIpConfig",value:this.ipConfig_&&this.ipConfig_.ipv4?this.getIPConfigProperties_(this.ipConfig_.ipv4):{}}}))}computeShouldShowAutoIpConfigToggle_(){if(this.managedProperties&&this.managedProperties.type===NetworkType.kCellular){return false}return true}getFieldsClassList_(){let classes="property-box single-column stretch";if(this.shouldShowAutoIpConfigToggle_){classes+=" indented"}return classes}}customElements.define(NetworkIpConfigElement.is,NetworkIpConfigElement);function getTemplate$2r(){return html`<!--_html_template_start_--><style include="network-shared md-select iron-flex">
  a {
    margin-inline-start: 4px;
  }

  cr-input {
    margin-bottom: 4px;
    /* Aligns with the start of cr-radio-button's text. */
    margin-inline-start: 38px;
  }

  cr-radio-group {
    --cr-radio-group-item-padding: 12px;
    width: 100%;
  }

  .nameservers {
    /* Aligns with the start of cr-radio-button's text. */
    margin-inline-start: 38px;
    padding-bottom: 0;
    padding-top: 0;
  }

  .nameservers:not([changeable]) {
    opacity: var(--cr-disabled-opacity);
  }

  #radioGroupDiv {
    align-items: center;
    display: block;
    padding-inline-end: var(--cr-section-padding);
    padding-inline-start: var(--cr-section-padding);
  }

  cr-policy-indicator {
    /* Aligns with the other policy indicators. */
    margin-inline-end: calc(var(--settings-control-label-spacing) + 34px);
  }
</style>

<div class="property-box">
  <div class="start">
    [[i18n('networkNameservers')]]
  </div>
  <cr-policy-indicator indicator-type="[[getPolicyIndicatorType(
      managedProperties.nameServersConfigType)]]">
  </cr-policy-indicator>
</div>
<div id="radioGroupDiv">
  <cr-radio-group id="nameserverType" class="layout vertical"
      selected="[[nameserversType_]]"
      on-selected-changed="onTypeChange_"
      aria-label="[[i18n('networkNameservers')]]"
      disabled="[[disabled]]">
    <!-- Automatic nameservers -->
    <cr-radio-button name="[[nameserversTypeEnum_.AUTOMATIC]]"
      disabled="[[!canChangeConfigType_]]">
      [[i18n('networkNameserversAutomatic')]]
    </cr-radio-button>
    <template is="dom-if" if="[[showNameservers_(nameserversType_,
        nameserversTypeEnum_.AUTOMATIC, nameservers_)]]">
      <div class="nameservers" changeable$="[[canChangeConfigType_]]">
        [[getNameserversString_(nameservers_)]]
      </div>
    </template>

    <!-- Google nameservers -->
    <cr-radio-button name="[[nameserversTypeEnum_.GOOGLE]]"
      disabled="[[!canChangeConfigType_]]">
      [[i18n('networkNameserversGoogle')]]
      <template is="dom-if"
          if="[[i18nExists('networkGoogleNameserversLearnMoreUrl')]]">
        <a href="[[i18n('networkGoogleNameserversLearnMoreUrl')]]"
            target="_blank" on-click="doNothing_">
          [[i18n('networkNameserversLearnMore')]]
        </a>
      </template>
    </cr-radio-button>
    <template is="dom-if" if="[[showNameservers_(nameserversType_,
        nameserversTypeEnum_.GOOGLE, nameservers_)]]">
      <div class="nameservers" changeable$="[[canChangeConfigType_]]">
        [[getNameserversString_(nameservers_)]]
      </div>
    </template>

    <!-- Custom nameservers -->
    <cr-radio-button name="[[nameserversTypeEnum_.CUSTOM]]"
      disabled="[[!canChangeConfigType_]]">
      [[i18n('networkNameserversCustom')]]
    </cr-radio-button>
    <template is="dom-if" if="[[showNameservers_(nameserversType_,
        nameserversTypeEnum_.CUSTOM)]]">
      <div class="property-box single-column two-line">
        <template is="dom-repeat" items="[[nameservers_]]">
          <cr-input id="nameserver[[index]]" value="{{item}}"
              aria-label="[[getCustomNameServerInputA11yLabel_(index)]]"
              on-change="onValueChange_"
              disabled="[[!canEditCustomNameServers_(nameserversType_,
                  managedProperties)]]">
          </cr-input>
        </template>
      </div>
    </template>
  </cr-radio-group>
</div>
<!--_html_template_end_-->`}
// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var NameserversType;(function(NameserversType){NameserversType["AUTOMATIC"]="automatic";NameserversType["CUSTOM"]="custom";NameserversType["GOOGLE"]="google"})(NameserversType||(NameserversType={}));const GOOGLE_NAMESERVERS=["8.8.4.4","8.8.8.8"];const EMPTY_NAMESERVER="0.0.0.0";const MAX_NAMESERVERS=4;const NetworkNameserversElementBase=mixinBehaviors([CrPolicyNetworkBehaviorMojo],I18nMixin(PolymerElement));class NetworkNameserversElement extends NetworkNameserversElementBase{constructor(){super(...arguments);this.nameservers_=[];this.nameserversType_=NameserversType.AUTOMATIC;this.googleNameserversText_=this.i18nAdvanced("networkNameserversGoogle",{substitutions:[],tags:["a"]}).toString();this.savedCustomNameservers_=[];this.savedNameserversType_=null}static get is(){return"network-nameservers"}static get template(){return getTemplate$2r()}static get properties(){return{disabled:{type:Boolean,value:false},managedProperties:{type:Object,observer:"managedPropertiesChanged_"},nameservers_:{type:Array},nameserversType_:{type:String},nameserversTypeEnum_:{readOnly:true,type:Object,value:NameserversType},googleNameserversText_:{type:String},canChangeConfigType_:{type:Boolean,computed:"computeCanChangeConfigType_(managedProperties)"}}}getNameserverRadioButtons(){return this.shadowRoot.querySelector("#nameserverType")}nameserversMatch_(nameservers1,nameservers2){const nonEmptySortedNameservers1=this.clearEmptyNameServers_(nameservers1).sort();const nonEmptySortedNameservers2=this.clearEmptyNameServers_(nameservers2).sort();if(nonEmptySortedNameservers1.length!==nonEmptySortedNameservers2.length){return false}for(let i=0;i<nonEmptySortedNameservers1.length;i++){if(nonEmptySortedNameservers1[i]!==nonEmptySortedNameservers2[i]){return false}}return true}isGoogleNameservers_(nameservers){return this.nameserversMatch_(nameservers,GOOGLE_NAMESERVERS)}getPolicyEnforcedNameservers_(){const staticIpConfig=this.managedProperties&&this.managedProperties.staticIpConfig;if(!staticIpConfig||!staticIpConfig.nameServers){return null}return this.getEnforcedPolicyValue(staticIpConfig.nameServers)}getPolicyRecommendedNameservers_(){const staticIpConfig=this.managedProperties&&this.managedProperties.staticIpConfig;if(!staticIpConfig||!staticIpConfig.nameServers){return null}return this.getRecommendedPolicyValue(staticIpConfig.nameServers)}managedPropertiesChanged_(newValue,oldValue){if(!this.managedProperties){return}if(!oldValue||newValue.guid!==oldValue.guid){this.savedCustomNameservers_=[];this.savedNameserversType_=null}let nameservers=[];const ipv4=OncMojo.getIPConfigForType(this.managedProperties,IPConfigType.kIPv4);if(ipv4&&ipv4.nameServers){nameservers=ipv4.nameServers.slice()}const configType=OncMojo.getActiveValue(this.managedProperties.nameServersConfigType);let nameserversType;if(configType==="Static"){if(this.isGoogleNameservers_(nameservers)&&this.savedNameserversType_!==NameserversType.CUSTOM){nameserversType=NameserversType.GOOGLE;nameservers=GOOGLE_NAMESERVERS}else{nameserversType=NameserversType.CUSTOM}}else{nameserversType=NameserversType.AUTOMATIC;nameservers=this.clearEmptyNameServers_(nameservers)}if(nameserversType!==NameserversType.CUSTOM||!oldValue||newValue.guid!==(oldValue&&oldValue.guid)||!OncMojo.connectionStateIsConnected(this.managedProperties.connectionState)){this.setNameservers_(nameserversType,nameservers,false)}}setNameservers_(nameserversType,nameservers,sendNameservers){if(nameserversType===NameserversType.CUSTOM){for(let i=nameservers.length;i<MAX_NAMESERVERS;++i){nameservers[i]=EMPTY_NAMESERVER}}else{nameservers=this.clearEmptyNameServers_(nameservers)}this.nameservers_=nameservers;this.nameserversType_=nameserversType;if(sendNameservers){this.sendNameServers_()}}computeCanChangeConfigType_(managedProperties){if(!managedProperties){return false}if(this.isNetworkPolicyEnforced(managedProperties.nameServersConfigType)){return false}return true}canEditCustomNameServers_(nameserversType,managedProperties){if(!managedProperties){return false}if(nameserversType!==NameserversType.CUSTOM){return false}if(this.isNetworkPolicyEnforced(managedProperties.nameServersConfigType)){return false}if(managedProperties.staticIpConfig&&managedProperties.staticIpConfig.nameServers&&this.isNetworkPolicyEnforced(managedProperties.staticIpConfig.nameServers)){return false}return true}showNameservers_(nameserversType,buttonNameserverstype,nameservers){if(nameserversType!==buttonNameserverstype){return false}return buttonNameserverstype===NameserversType.CUSTOM||nameservers.length>0}getNameserversString_(nameservers){return nameservers.join(", ")}getCustomNameServers_(){const policyEnforcedNameservers=this.getPolicyEnforcedNameservers_();if(policyEnforcedNameservers!==null){return policyEnforcedNameservers.slice()}if(this.savedCustomNameservers_.length>0){return this.savedCustomNameservers_}const policyRecommendedNameservers=this.getPolicyRecommendedNameservers_();if(policyRecommendedNameservers!==null){return policyRecommendedNameservers.slice()}return this.nameservers_}onTypeChange_(){const el=this.shadowRoot.querySelector("#nameserverType");assert(el);const nameserversType=el.selected;this.nameserversType_=nameserversType;this.savedNameserversType_=nameserversType;if(nameserversType===NameserversType.CUSTOM){this.setNameservers_(nameserversType,this.getCustomNameServers_(),true);return}this.sendNameServers_()}onValueChange_(){this.savedCustomNameservers_=this.nameservers_.slice();this.sendNameServers_()}sendNameServers_(){let eventField;let eventValue;const nameserversType=this.nameserversType_;if(nameserversType===NameserversType.CUSTOM){eventField="nameServers";eventValue=this.nameservers_}else if(nameserversType===NameserversType.GOOGLE){this.nameservers_=GOOGLE_NAMESERVERS;eventField="nameServers";eventValue=GOOGLE_NAMESERVERS}else{assert(this.managedProperties);if(!OncMojo.connectionStateIsConnected(this.managedProperties.connectionState)){this.nameservers_=[]}else{this.nameservers_=this.clearEmptyNameServers_(this.nameservers_)}eventField="nameServersConfigType";eventValue="DHCP"}const event=new CustomEvent("nameservers-change",{bubbles:true,composed:true,detail:{field:eventField,value:eventValue}});this.dispatchEvent(event)}clearEmptyNameServers_(nameservers){return nameservers.filter((nameserver=>!!nameserver&&nameserver!==EMPTY_NAMESERVER))}doNothing_(event){event.stopPropagation()}getCustomNameServerInputA11yLabel_(index){return this.i18n("networkNameserversCustomInputA11yLabel",index+1)}}customElements.define(NetworkNameserversElement.is,NetworkNameserversElement);function getTemplate$2q(){return html`<!--_html_template_start_--><style include="network-shared iron-flex">
  :host {
    cursor: default
  }

  iron-icon {
    margin-inline-end: 10px;
  }

  cr-policy-indicator {
    margin-inline-end: var(--cr-button-edge-spacing);
  }

  cr-toggle {
    margin-inline-start: var(--cr-button-edge-spacing);
  }

  .separator {
    border-inline-start: var(--cr-separator-line);
    flex-shrink: 0;
    height: calc(var(--cr-section-min-height) - 9px);
    margin-inline-end: var(--cr-section-padding);
    margin-inline-start: var(--cr-section-padding);
  }

  .pin-required-subtext {
    color: var(--cros-text-color-secondary);
  }
</style>

<!-- SIM locked -->
<template is="dom-if" if="[[eq_(State.SIM_LOCKED, state_)]]" restamp>
  <template is="dom-if" if="[[!isSimCarrierLocked_(isActiveSim_,
      deviceState)]]" restamp>
    <div id="simLocked" class="property-box two-line">
      <cr-button id="unlockPinButton"
          on-click="onUnlockPinPressed_"
          disabled="[[disabled]]">
        [[i18n('networkSimUnlock')]]
      </cr-button>
    </div>
  </template>
</template>

<!-- SIM unlocked -->
<template is="dom-if" if="[[eq_(State.SIM_UNLOCKED, state_)]]" restamp>
  <div class="property-box two-line">
    <div class="flex layout vertical"  aria-hidden="true">
      <div id="pinRequiredLabel">
        [[i18n('networkSimLockEnable')]]
      </div>
      <div id="pinRequiredSublabel" class="pin-required-subtext">
        [[i18n('networkSimLockEnableSublabel')]]
      </div>
    </div>
    <cr-button id="changePinButton" on-click="onChangePinPressed_"
        hidden$="[[!showChangePinButton_(deviceState, isActiveSim_,
            isSimPinLockRestricted_)]]"
        disabled="[[disabled]]">
      [[i18n('networkSimChangePin')]]
    </cr-button>
    <template is="dom-if" if="[[!isActiveSim_]]" restamp>
      <iron-icon id="help-icon" tabindex="0" icon="cr:help-outline"
          aria-labelledby="pinRequiredLabel pinRequiredSublabel inActiveSimLockTooltip">
      </iron-icon>
      <paper-tooltip id="inActiveSimLockTooltip" for="help-icon" position="bottom"
          aria-hidden="true" fit-to-visible-bounds>
          [[i18n('networkSimLockedTooltip')]]
      </paper-tooltip>
      <div class="separator"></div>
    </template>
    <template is="dom-if" if="[[shouldShowPolicyIndicator_(isActiveSim_,
        isSimPinLockRestricted_)]]" restamp>
      <cr-policy-indicator id="simLockPolicyIcon" indicator-type="devicePolicy">
      </cr-policy-indicator>
    </template>
    <cr-toggle id="simLockButton"
        disabled="[[isSimLockButtonDisabled_(disabled, isActiveSim_,
            isSimPinLockRestricted_, lockEnabled_)]]"
        on-change="onSimLockEnabledChange_" checked="{{lockEnabled_}}"
        aria-labelledby="pinRequiredLabel pinRequiredSublabel">
    </cr-toggle>
  </div>
</template>

<template is="dom-if" if="[[isDialogOpen_]]" restamp>
  <sim-lock-dialogs
      global-policy="[[globalPolicy]]"
      show-change-pin="[[showChangePin_]]"
      is-dialog-open="{{isDialogOpen_}}"
      device-state="[[deviceState]]">
  </sim-lock-dialogs>
</template>
<!--_html_template_end_-->`}
// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const TOGGLE_DEBOUNCE_MS=500;var State;(function(State){State[State["SIM_LOCKED"]=0]="SIM_LOCKED";State[State["SIM_UNLOCKED"]=1]="SIM_UNLOCKED"})(State||(State={}));const NetworkSiminfoElementBase=I18nMixin(PolymerElement);class NetworkSiminfoElement extends NetworkSiminfoElementBase{static get is(){return"network-siminfo"}static get template(){return getTemplate$2q()}static get properties(){return{deviceState:{type:Object,value:null,observer:"deviceStateChanged_"},networkState:{type:Object,value:null},globalPolicy:Object,disabled:{type:Boolean,value:false},State:{type:Object,value:State},lockEnabled_:{type:Boolean,value:false},isDialogOpen_:{type:Boolean,value:false,observer:"onDialogOpenChanged_"},showChangePin_:{type:Boolean,value:false},isActiveSim_:{type:Boolean,value:false,computed:"computeIsActiveSim_(networkState, deviceState)"},state_:{type:Number,value:State.SIM_UNLOCKED,computed:"computeState_(networkState, deviceState, deviceState.*,"+"isActiveSim_)"},isSimPinLockRestricted_:{type:Boolean,value:false,computed:"computeIsSimPinLockRestricted_(globalPolicy,"+"globalPolicy.*, lockEnabled_)"}}}getSimLockToggle(){const el=this.shadowRoot.querySelector("#simLockButton");assert(!!el);return el}getUnlockButton(){const el=this.shadowRoot.querySelector("#unlockPinButton");assert(!!el);return el}onDialogOpenChanged_(){if(this.isDialogOpen_){return}this.delayUpdateLockEnabled_();this.updateFocus_()}updateFocus_(){const state=this.computeState_();switch(state){case State.SIM_LOCKED:const unlockPinButton=this.shadowRoot.querySelector("#unlockPinButton");if(unlockPinButton){unlockPinButton.focus()}break;case State.SIM_UNLOCKED:const simLockButton=this.shadowRoot.querySelector("#simLockButton");if(simLockButton){simLockButton.focus()}break}}deviceStateChanged_(){if(!this.deviceState){return}const simLockStatus=this.deviceState.simLockStatus;if(!simLockStatus){return}const lockEnabled=this.isActiveSim_&&simLockStatus.lockEnabled;if(lockEnabled!==this.lockEnabled_){this.setLockEnabled_=lockEnabled;this.updateLockEnabled_()}else{this.setLockEnabled_=undefined}}updateLockEnabled_(){if(this.setLockEnabled_===undefined||this.isDialogOpen_){return}this.lockEnabled_=this.setLockEnabled_;this.setLockEnabled_=undefined}delayUpdateLockEnabled_(){setTimeout((()=>{this.updateLockEnabled_()}),TOGGLE_DEBOUNCE_MS)}onSimLockEnabledChange_(_event){if(!this.deviceState){return}this.lockEnabled_=!this.lockEnabled_;this.showSimLockDialog_(false)}onChangePinPressed_(event){event.stopPropagation();if(!this.deviceState){return}this.showSimLockDialog_(true)}onUnlockPinPressed_(event){event.stopPropagation();this.showSimLockDialog_(true)}showSimLockDialog_(showChangePin){this.showChangePin_=showChangePin;this.isDialogOpen_=true}computeIsActiveSim_(){return isActiveSim(this.networkState,this.deviceState)}showChangePinButton_(){if(this.isSimPinLockRestricted_){return false}if(!this.deviceState||!this.deviceState.simLockStatus){return false}return this.deviceState.simLockStatus.lockEnabled&&this.isActiveSim_}isSimLockButtonDisabled_(){if(this.isSimPinLockRestricted_&&!this.lockEnabled_){return true}return this.disabled||!this.isActiveSim_}computeState_(){const simLockStatus=this.deviceState&&this.deviceState.simLockStatus;if(this.isActiveSim_&&simLockStatus&&!!simLockStatus.lockType){return State.SIM_LOCKED}return State.SIM_UNLOCKED}isSimCarrierLocked_(){const simLockStatus=this.deviceState&&this.deviceState.simLockStatus;if(this.isActiveSim_&&simLockStatus&&simLockStatus.lockType==="network-pin"){return true}return false}shouldShowPolicyIndicator_(){return this.isSimPinLockRestricted_&&this.isActiveSim_}computeIsSimPinLockRestricted_(){return!!this.globalPolicy&&!this.globalPolicy.allowCellularSimLock}eq_(state1,state2){return state1===state2}}customElements.define(NetworkSiminfoElement.is,NetworkSiminfoElement);function getTemplate$2p(){return html`<!--_html_template_start_--><style include="settings-shared">#cellularRoamingToggle{display:flex;justify-content:center;min-height:var(--cr-section-two-line-min-height)}#cellularRoamingToggle:not([disabled]):hover{background-color:var(--cr-hover-background-color)}#cellularRoamingToggle:not([disabled]):active{background-color:var(--cr-active-background-color)}</style>
<template is="dom-if"
    if="[[showPerNetworkAllowRoamingToggle_(isRoamingAllowedForNetwork_)]]">
    <network-config-toggle id="cellularRoamingToggle" class="settings-box" policy-on-left
        property="[[managedProperties.typeProperties.cellular.allowRoaming]]"
        label="$i18n{networkAllowDataRoaming}"
        sub-label="[[getRoamingDetails_(managedProperties.typeProperties.cellular.allowRoaming.*, prefs.cros.signed.data_roaming_enabled)]]"
        checked="{{isRoamingAllowedForNetwork_}}"
        disabled="[[isPerNetworkToggleDisabled_(managedProperties.typeProperties.cellular.allowRoaming.*, disabled, prefs.cros.signed.data_roaming_enabled)]]">
    </network-config-toggle>
</template>
<!--_html_template_end_-->`}
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CellularRoamingToggleButtonElementBase=PrefsMixin(I18nMixin(PolymerElement));class CellularRoamingToggleButtonElement extends CellularRoamingToggleButtonElementBase{static get is(){return"cellular-roaming-toggle-button"}static get template(){return getTemplate$2p()}static get properties(){return{disabled:{type:Boolean,value:false,reflectToAttribute:true},managedProperties:{type:Object},isRoamingAllowedForNetwork_:{type:Boolean,observer:"isRoamingAllowedForNetworkChanged_",notify:true}}}static get observers(){return[`managedPropertiesChanged_(\n          prefs.cros.signed.data_roaming_enabled.*,\n          managedProperties.*)`]}constructor(){super();this.networkConfig_=MojoInterfaceProviderImpl.getInstance().getMojoServiceRemote()}getCellularRoamingToggle(){return this.shadowRoot.querySelector("#cellularRoamingToggle")}isRoamingAllowedForNetworkChanged_(){assert(this.networkConfig_);if(!this.managedProperties||!this.managedProperties.typeProperties.cellular.allowRoaming){return}const config=OncMojo.getDefaultConfigProperties(this.managedProperties.type);config.typeConfig.cellular={roaming:{allowRoaming:this.isRoamingAllowedForNetwork_},apn:null,textMessageAllowState:null};this.networkConfig_.setProperties(this.managedProperties.guid,config).then((response=>{if(response.success){recordSettingChange(Setting.kCellularRoaming,{boolValue:this.isRoamingAllowedForNetwork_})}else{console.warn("Unable to set properties: "+JSON.stringify(config))}}))}getRoamingAllowedForNetwork_(){return!!OncMojo.getActiveValue(this.managedProperties.typeProperties.cellular.allowRoaming)&&!this.isRoamingProhibitedByPolicy_()}getRoamingDetails_(){if(this.managedProperties.typeProperties.cellular.roamingState==="Required"){return this.i18n("networkAllowDataRoamingRequired")}if(!this.getRoamingAllowedForNetwork_()){return this.i18n("networkAllowDataRoamingDisabled")}return this.managedProperties.typeProperties.cellular.roamingState==="Roaming"?this.i18n("networkAllowDataRoamingEnabledRoaming"):this.i18n("networkAllowDataRoamingEnabledHome")}managedPropertiesChanged_(){if(!this.managedProperties||!this.managedProperties.typeProperties.cellular.allowRoaming){return}if(this.isRoamingProhibitedByPolicy_()){this.set("managedProperties.typeProperties.cellular.allowRoaming.policySource",PolicySource.kDevicePolicyEnforced)}this.isRoamingAllowedForNetwork_=this.getRoamingAllowedForNetwork_()}onCellularRoamingRowClicked_(event){event.stopPropagation();if(this.isPerNetworkToggleDisabled_()){return}this.isRoamingAllowedForNetwork_=!this.isRoamingAllowedForNetwork_}isRoamingProhibitedByPolicy_(){const dataRoamingEnabled=this.getPref("cros.signed.data_roaming_enabled");return!dataRoamingEnabled.value&&dataRoamingEnabled.controlledBy===chrome.settingsPrivate.ControlledBy.DEVICE_POLICY}isPerNetworkToggleDisabled_(){return this.disabled||this.isRoamingProhibitedByPolicy_()||CrPolicyNetworkBehaviorMojo.isNetworkPolicyEnforced(this.managedProperties.typeProperties.cellular.allowRoaming)}showPerNetworkAllowRoamingToggle_(){return this.isRoamingAllowedForNetwork_!==undefined}}customElements.define(CellularRoamingToggleButtonElement.is,CellularRoamingToggleButtonElement);function getTemplate$2o(){return html`<!--_html_template_start_--><style include="network-shared cr-hidden-style iron-flex">
  #container {
    align-self: stretch;
    border: 1px solid lightgrey;
    height: 100px;
    margin-top: 10px;
    overflow-y: auto;
    padding: 5px;
  }

  cr-icon-button {
    --cr-icon-button-margin-end: 0;
  }
</style>
<div id="container">
  <template is="dom-repeat" items="[[exclusions]]">
    <div class="layout horizontal center">
      <div class="flex">[[item]]</div>
      <cr-icon-button class="icon-clear" hidden="[[!editable]]"
          title="[[i18n('networkProxyExceptionRemoveA11yLabel', item)]]"
          on-click="onRemoveTap_">
      </cr-icon-button>
    </div>
  </template>
</div>
<!--_html_template_end_-->`}
// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const NetworkProxyExclusionsElementBase=I18nMixin(PolymerElement);class NetworkProxyExclusionsElement extends NetworkProxyExclusionsElementBase{static get is(){return"network-proxy-exclusions"}static get template(){return getTemplate$2o()}static get properties(){return{editable:{type:Boolean,value:false},exclusions:{type:Array,value(){return[]},notify:true}}}onRemoveTap_(event){const index=event.model.index;this.splice("exclusions",index,1);this.dispatchEvent(new CustomEvent("proxy-exclusions-change",{bubbles:true,composed:true}))}}customElements.define(NetworkProxyExclusionsElement.is,NetworkProxyExclusionsElement);function getTemplate$2n(){return html`<!--_html_template_start_--><style include="network-shared">
  cr-input {
    margin: 0 var(--cr-button-edge-spacing);
  }

  #container {
    align-items: center;
    display: flex;
    flex: 0 1 auto;
    flex-direction: row;
  }

  #label {
    flex: 1;
  }

  #host {
    width: 200px;
  }

  #port {
    width: 50px;
  }
</style>
<div id="container">
  <div id="label">[[label]]</div>
  <cr-input id="host" readonly="[[!editable]]"
      aria-label="[[i18n('networkProxyHostInputA11yLabel', label)]]"
      value="{{value.host.activeValue}}" on-change="onValueChange_">
  </cr-input>
  <div>[[i18n('networkProxyPort')]]</div>
  <cr-input id="port" readonly="[[!editable]]"
      aria-label="[[i18n('networkProxyPortInputA11yLabel', label)]]"
      value="{{value.port.activeValue}}" on-change="onValueChange_">
  </cr-input>
</div>
<!--_html_template_end_-->`}
// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const NetworkProxyInputElementBase=I18nMixin(PolymerElement);class NetworkProxyInputElement extends NetworkProxyInputElementBase{static get is(){return"network-proxy-input"}static get template(){return getTemplate$2n()}static get properties(){return{editable:{type:Boolean,value:false},label:{type:String,value:"Proxy"},value:{type:Object,value(){return{host:OncMojo.createManagedString(""),port:OncMojo.createManagedInt(80)}},notify:true}}}focus(){const crInput=this.shadowRoot.querySelector("cr-input");assert(!!crInput);crInput.focus()}onValueChange_(){let port=parseInt(this.value.port.activeValue.toString(),10);if(isNaN(port)){port=80}this.value.port.activeValue=port;this.dispatchEvent(new CustomEvent("proxy-input-change",{bubbles:true,composed:true,detail:this.value}))}}customElements.define(NetworkProxyInputElement.is,NetworkProxyInputElement);function getTemplate$2m(){return html`<!--_html_template_start_--><style include="network-shared cr-hidden-style iron-flex iron-flex-alignment md-select">
  network-proxy-input {
    margin-bottom: 10px;
  }

  network-proxy-exclusions {
    margin: 10px 0;
  }

  #addException {
    margin-top: 10px;
  }

  #manualProxy {
    padding-inline-start: var(--cr-section-padding);
  }

  #proxyType  {
    width: 320px;
  }

</style>

<!-- Proxy type dropdown -->
<div class="property-box">
  <div class="start">[[i18n('networkProxyConnectionType')]]</div>
  <select id="proxyType" class="md-select" on-change="onTypeChange_"
      value="[[proxy_.type.activeValue]]"
      disabled="[[!isEditable_('type', managedProperties, editable,
          useSharedProxies)]]"
      aria-label="[[i18n('networkProxyConnectionType')]]">
    <template is="dom-repeat" items="[[proxyTypes_]]">
      <option value="[[item]]">[[getProxyTypeDesc_(item)]]</option>
    </template>
  </select>
</div>

<!-- Autoconfiguration (PAC) -->
<div class="property-box indented"
    hidden$="[[!matches_(proxy_.type.activeValue, 'PAC')]]">
  <cr-input id="pacInput" class="flex"
      label="[[i18n('networkProxyAutoConfig')]]"
      value="{{proxy_.pac.activeValue}}" on-change="onPacChange_"
      disabled="[[!isEditable_('pac', managedProperties, editable,
          useSharedProxies)]]">
  </cr-input>
</div>

<!-- Web Proxy Auto Discovery (WPAD) -->
<div class="property-box indented"
    hidden$="[[!matches_(proxy_.type.activeValue, 'WPAD')]]">
  <div>[[i18n('networkProxyWpad')]]</div>
  <div class="middle">[[wpad_]]</div>
</div>

<!-- Manual -->
<div class="property-box indented"
    hidden$="[[!matches_(proxy_.type.activeValue, 'Manual')]]">
  <div id="networkProxyToggleLabel" class="flex">
    [[i18n('networkProxyUseSame')]]
  </div>
  <cr-toggle checked="{{useSameProxy_}}"
      disabled="[[!isEditable_('type', managedProperties, editable,
          useSharedProxies)]]"
      aria-labelledby="networkProxyToggleLabel">
  </cr-toggle>
</div>

<div id="manualProxy" class="layout vertical start"
    hidden$="[[!matches_(proxy_.type.activeValue, 'Manual')]]">
  <div hidden$="[[!useSameProxy_]]" class="layout vertical">
    <network-proxy-input
        id="sameProxyInput"
        on-proxy-input-change="onProxyInputChange_"
        editable="[[isEditable_('manual.httpProxy.host', managedProperties,
            editable, useSharedProxies)]]"
        value="{{proxy_.manual.httpProxy}}"
        label="[[i18n('networkProxy')]]">
    </network-proxy-input>
  </div>
  <div hidden$="[[useSameProxy_]]" class="layout vertical">
    <network-proxy-input
      id="httpProxyInput"
        on-proxy-input-change="onProxyInputChange_"
        editable="[[isEditable_('manual.httpProxy.host', managedProperties,
            editable, useSharedProxies)]]"
        value="{{proxy_.manual.httpProxy}}"
        label="[[i18n('networkProxyHttp')]]">
    </network-proxy-input>
    <network-proxy-input
        id="secureHttpProxyInput"
        on-proxy-input-change="onProxyInputChange_"
        editable="[[isEditable_('manual.secureHttpProxy.host',
            managedProperties, editable, useSharedProxies)]]"
        value="{{proxy_.manual.secureHttpProxy}}"
        label="[[i18n('networkProxyShttp')]]">
    </network-proxy-input>
    <network-proxy-input
        id="socksProxyInput"
        on-proxy-input-change="onProxyInputChange_"
        editable="[[isEditable_('manual.socks.host', managedProperties,
            editable, useSharedProxies)]]"
        value="{{proxy_.manual.socks}}"
        label="[[i18n('networkProxySocks')]]">
    </network-proxy-input>
  </div>

  <div hidden="[[!isEditable_('type', managedProperties, editable,
      useSharedProxies)]]">
    <div>[[i18n('networkProxyExceptionList')]]</div>
    <network-proxy-exclusions
        on-proxy-exclusions-change="onProxyExclusionsChange_"
        exclusions="{{proxy_.excludeDomains.activeValue}}"
        editable="[[isEditable_('excludeDomains', managedProperties,
            editable, useSharedProxies)]]">
    </network-proxy-exclusions>
    <div id="addException" class="layout horizontal center">
      <cr-input id="proxyExclusion" class="flex"
          value="{{proxyExclusionInputValue_}}"
          aria-label="[[i18n('networkProxyExceptionInputA11yLabel')]]"
          on-keypress="onAddProxyExclusionKeypress_">
        <cr-button id="proxyExclusionButton"
            on-click="onAddProxyExclusionClicked_"
            slot="suffix"
            disabled="[[shouldProxyExclusionButtonBeDisabled_(
                proxyExclusionInputValue_)]]">
          [[i18n('networkProxyAddException')]]
        </cr-button>
      </cr-input>
    </div>
  </div>

  <cr-button id="saveManualProxy"
      on-click="onSaveProxyClicked_" class="action-button"
      disabled="[[!isSaveManualProxyEnabled_(managedProperties,
          proxyIsUserModified_, proxy_.*)]]">
    [[i18n('save')]]
  </cr-button>
</div>
<!--_html_template_end_-->`}
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function createDefaultProxySettings(){return{type:OncMojo.createManagedString("Direct"),manual:null,excludeDomains:null,pac:null}}const NetworkProxyElementBase=mixinBehaviors([CrPolicyNetworkBehaviorMojo],I18nMixin(PolymerElement));class NetworkProxyElement extends NetworkProxyElementBase{constructor(){super(...arguments);this.savedManual_=undefined;this.savedExcludeDomains_=undefined}static get is(){return"network-proxy"}static get template(){return getTemplate$2m()}static get properties(){return{editable:{type:Boolean,value:false},managedProperties:{type:Object,observer:"managedPropertiesChanged_"},useSharedProxies:{type:Boolean,value:false,observer:"updateProxy_"},proxy_:{type:Object,value(){return createDefaultProxySettings()}},wpad_:{type:String,value:""},useSameProxy_:{type:Boolean,value:false,observer:"useSameProxyChanged_"},proxyTypes_:{type:Array,value:["Direct","PAC","WPAD","Manual"],readOnly:true},proxyExclusionInputValue_:{type:String,value:""},proxyIsUserModified_:{type:Boolean,value:false}}}connectedCallback(){super.connectedCallback();this.reset()}reset(){this.proxyIsUserModified_=false;this.updateProxy_()}managedPropertiesChanged_(newValue,oldValue){if((newValue&&newValue.guid)!==(oldValue&&oldValue.guid)){this.savedManual_=undefined;this.savedExcludeDomains_=undefined}if(this.proxyIsUserModified_||this.isInputEditInProgress_()){return}this.updateProxy_()}isInputEditInProgress_(){if(!this.editable){return false}const activeElement=this.shadowRoot.activeElement;if(!activeElement){return false}let property=null;switch(activeElement.id){case"sameProxyInput":case"httpProxyInput":property="manual.httpProxy.host";break;case"secureHttpProxyInput":property="manual.secureHttpProxy.host";break;case"socksProxyInput":property="manual.socks.host";break;case"pacInput":property="pac";break}if(!property){return false}return this.isEditable_(property)}proxyMatches_(a,b){return!!a&&!!b&&a.host.activeValue===b.host.activeValue&&a.port.activeValue===b.port.activeValue}createDefaultProxyLocation_(port){return{host:OncMojo.createManagedString(""),port:OncMojo.createManagedInt(port)}}validateProxy_(inputProxy){const proxy={...inputProxy};const type=proxy.type.activeValue;if(type==="PAC"){if(!proxy.pac){proxy.pac=OncMojo.createManagedString("")}}else if(type==="Manual"){proxy.manual=proxy.manual||this.savedManual_||{httpProxy:null,secureHttpProxy:null,ftpProxy:null,socks:null};assert(proxy.manual);if(!proxy.manual.httpProxy){proxy.manual.httpProxy=this.createDefaultProxyLocation_(80)}if(!proxy.manual.secureHttpProxy){proxy.manual.secureHttpProxy=this.createDefaultProxyLocation_(80)}if(!proxy.manual.socks){proxy.manual.socks=this.createDefaultProxyLocation_(1080)}proxy.excludeDomains=proxy.excludeDomains||this.savedExcludeDomains_||{activeValue:[],policySource:PolicySource.kNone,policyValue:null}}return proxy}updateProxy_(){if(!this.managedProperties){return}let proxySettings=this.managedProperties.proxySettings;if(this.isShared_()&&proxySettings&&!this.isControlled(proxySettings.type)&&!this.useSharedProxies){proxySettings=null}const proxy=proxySettings?this.validateProxy_(proxySettings):createDefaultProxySettings();if(proxy.type.activeValue==="WPAD"){const ipv4=this.managedProperties?OncMojo.getIPConfigForType(this.managedProperties,IPConfigType.kIPv4):null;this.wpad_=ipv4&&ipv4.webProxyAutoDiscoveryUrl||this.i18n("networkProxyWpadNone")}microTask.run((()=>this.setProxy_(proxy)))}setProxy_(proxy){this.proxy_=proxy;if(proxy.manual){const manual=proxy.manual;const httpProxy=manual.httpProxy;if(this.proxyMatches_(httpProxy,manual.secureHttpProxy)&&this.proxyMatches_(httpProxy,manual.socks)){this.useSameProxy_=true}else if(!manual.secureHttpProxy?.host?.activeValue&&!manual.socks?.host?.activeValue){this.useSameProxy_=true}}this.proxyIsUserModified_=false}useSameProxyChanged_(){this.proxyIsUserModified_=true}getProxyLocation_(location){if(!location){return null}return{host:location.host.activeValue,port:location.port.activeValue}}sendProxyChange_(){const proxyType=OncMojo.getActiveString(this.proxy_.type);if(!proxyType||proxyType==="PAC"&&!this.proxy_.pac){return}const proxy={type:proxyType,excludeDomains:OncMojo.getActiveValue(this.proxy_.excludeDomains)||null,manual:null,pac:null};if(proxyType==="Manual"){let manual={httpProxy:null,secureHttpProxy:null,ftpProxy:null,socks:null};if(this.proxy_.manual){this.savedManual_={...this.proxy_.manual};manual={httpProxy:this.getProxyLocation_(this.proxy_.manual.httpProxy),secureHttpProxy:this.getProxyLocation_(this.proxy_.manual.secureHttpProxy),ftpProxy:null,socks:this.getProxyLocation_(this.proxy_.manual.socks)}}if(this.proxy_.excludeDomains){this.savedExcludeDomains_={...this.proxy_.excludeDomains}}const defaultProxy=manual.httpProxy||{host:"",port:80};if(this.useSameProxy_){manual.secureHttpProxy={...defaultProxy};manual.socks={...defaultProxy}}else{if(manual.httpProxy&&!manual.httpProxy.host){manual.httpProxy=null}if(manual.secureHttpProxy&&!manual.secureHttpProxy.host){manual.secureHttpProxy=null}if(manual.socks&&!manual.socks.host){manual.socks=null}}proxy.manual=manual}else if(proxyType==="PAC"){proxy.pac=OncMojo.getActiveString(this.proxy_.pac)}this.dispatchEvent(new CustomEvent("proxy-change",{bubbles:true,composed:true,detail:proxy}));this.proxyIsUserModified_=false}onTypeChange_(event){if(!this.proxy_||!this.proxy_.type){return}const target=event.target;const type=target.value;this.proxy_.type.activeValue=type;this.set("proxy_",this.validateProxy_(this.proxy_));let proxyTypeChangeIsReady;let elementToFocus;switch(type){case"Direct":case"WPAD":proxyTypeChangeIsReady=true;break;case"PAC":elementToFocus=this.shadowRoot.querySelector("#pacInput");proxyTypeChangeIsReady=!!OncMojo.getActiveString(this.proxy_.pac);break;case"Manual":proxyTypeChangeIsReady=false;elementToFocus=this.shadowRoot.querySelector("#manualProxy network-proxy-input");break}if(proxyTypeChangeIsReady){this.sendProxyChange_()}else{this.proxyIsUserModified_=true}if(elementToFocus){microTask.run((()=>elementToFocus.focus()))}}onPacChange_(){this.sendProxyChange_()}onProxyInputChange_(){this.proxyIsUserModified_=true}onAddProxyExclusionClicked_(){assert(this.proxyExclusionInputValue_);this.push("proxy_.excludeDomains.activeValue",this.proxyExclusionInputValue_);this.proxyExclusionInputValue_="";this.proxyIsUserModified_=true}onAddProxyExclusionKeypress_(event){if(event.key!=="Enter"){return}event.stopPropagation();this.onAddProxyExclusionClicked_()}shouldProxyExclusionButtonBeDisabled_(proxyExclusionInputValue){return!proxyExclusionInputValue}onProxyExclusionsChange_(){this.proxyIsUserModified_=true}onSaveProxyClicked_(){this.sendProxyChange_()}getProxyTypeDesc_(proxyType){if(proxyType==="Manual"){return this.i18n("networkProxyTypeManual")}if(proxyType==="PAC"){return this.i18n("networkProxyTypePac")}if(proxyType==="WPAD"){return this.i18n("networkProxyTypeWpad")}return this.i18n("networkProxyTypeDirect")}isEditable_(propertyName){if(!this.editable||this.isShared_()&&!this.useSharedProxies){return false}const property=this.get("proxySettings."+propertyName,this.managedProperties);if(!property){return true}return this.isPropertyEditable_(property)}isPropertyEditable_(property){return!!property&&!this.isNetworkPolicyEnforced(property)&&!this.isExtensionControlled(property)}isShared_(){if(!this.managedProperties){return false}const source=this.managedProperties.source;return source===OncSource.kDevice||source===OncSource.kDevicePolicy}isSaveManualProxyEnabled_(){if(!this.proxyIsUserModified_){return false}const manual=this.proxy_.manual;const httpHost=this.get("httpProxy.host.activeValue",manual);if(this.useSameProxy_){return!!httpHost}return!!httpHost||!!this.get("secureHttpProxy.host.activeValue",manual)||!!this.get("socks.host.activeValue",manual)}matches_(property,value){return property===value}}customElements.define(NetworkProxyElement.is,NetworkProxyElement);function getTemplate$2l(){return html`<!--_html_template_start_--><style include="internet-shared cr-hidden-style iron-flex
    iron-flex-alignment">cr-policy-network-indicator-mojo{margin-inline-end:10px}extension-controlled-indicator{margin-inline-start:0;width:100%}.settings-box:first-of-type{border-top:none}</style>

<!-- Policy indicator. Only one dom-if below will be shown. -->
<template is="dom-if"
    if="[[shouldShowNetworkPolicyIndicator_(managedProperties)]]">
  <div class="settings-box">
    <div class="layout horizontal center">
      <cr-policy-network-indicator-mojo
          property="[[managedProperties.proxySettings.type]]"
          no-extension-indicator>
      </cr-policy-network-indicator-mojo>
      <div>$i18n{networkProxyEnforcedPolicy}</div>
    </div>
  </div>
</template>

<template is="dom-if" if="[[isProxySetByExtension_(managedProperties)]]">
  <div class="settings-box">
    <extension-controlled-indicator
        extension-id="[[extensionInfo_.id]]"
        extension-name="[[extensionInfo_.name]]"
        extension-can-be-disabled="[[extensionInfo_.canBeDisabled]]">
    </extension-controlled-indicator>
  </div>
</template>

<!-- Allow shared proxies -->
<settings-toggle-button id="allowShared" class="indented"
    hidden$="[[!shouldShowAllowShared_(managedProperties.source)]]"
    pref="{{prefs.settings.use_shared_proxies}}"
    label="$i18n{networkProxyAllowShared}"
    on-settings-boolean-control-change="onAllowSharedProxiesChange_"
    no-set-pref
    disabled="[[disabled]]">
</settings-toggle-button>

<div class="settings-box single-column stretch continuation indented">
  <network-proxy editable="[[!disabled]]"
      managed-properties="[[managedProperties]]"
      use-shared-proxies="[[useSharedProxies_]]">
  </network-proxy>
</div>

<!-- Confirm Allow shared proxies dialog -->
<cr-dialog id="confirmAllowSharedDialog"
    close-text="$i18n{close}" on-cancel="onAllowSharedDialogCancel_"
    on-close="onAllowSharedDialogClose_">
  <div slot="title">
    [[getAllowSharedDialogTitle_(prefs.settings.use_shared_proxies.value)]]
  </div>
  <div slot="body">
    $i18n{networkProxyAllowSharedWarningMessage}
  </div>
  <div slot="button-container">
    <cr-button class="cancel-button"
        on-click="onAllowSharedDialogCancel_">
      $i18n{cancel}
    </cr-button>
    <cr-button class="action-button"
        on-click="onAllowSharedDialogConfirm_">
      $i18n{confirm}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const NetworkProxySectionElementBase=mixinBehaviors([CrPolicyNetworkBehaviorMojo],PrefsMixin(RouteObserverMixin(I18nMixin(PolymerElement))));class NetworkProxySectionElement extends NetworkProxySectionElementBase{static get is(){return"network-proxy-section"}static get template(){return getTemplate$2l()}static get properties(){return{disabled:{type:Boolean,value:false},managedProperties:Object,useSharedProxies_:Boolean,extensionInfo_:Object}}static get observers(){return["useSharedProxiesChanged_(prefs.settings.use_shared_proxies.value)"]}getAllowSharedToggle(){return this.shadowRoot.querySelector("#allowShared")}currentRouteChanged(newRoute){if(newRoute===routes.NETWORK_DETAIL){this.shadowRoot.querySelector("network-proxy").reset()}}useSharedProxiesChanged_(){const pref=this.getPref("settings.use_shared_proxies");this.useSharedProxies_=!!pref&&!!pref.value}isProxySetByExtension_(){const property=this.getProxySettingsTypeProperty_();if(!property||!this.isExtensionControlled(property)||!this.prefs.proxy.controlledByName){return false}this.extensionInfo_={id:this.prefs.proxy.extensionId,name:this.prefs.proxy.controlledByName,canBeDisabled:this.prefs.proxy.extensionCanBeDisabled};return true}isShared_(){return this.managedProperties.source===OncSource.kDevice||this.managedProperties.source===OncSource.kDevicePolicy}getProxySettingsTypeProperty_(){if(!this.managedProperties){return undefined}const proxySettings=this.managedProperties.proxySettings;return proxySettings?proxySettings.type:undefined}getAllowSharedDialogTitle_(allowShared){if(allowShared){return this.i18n("networkProxyAllowSharedDisableWarningTitle")}return this.i18n("networkProxyAllowSharedEnableWarningTitle")}shouldShowNetworkPolicyIndicator_(){const property=this.getProxySettingsTypeProperty_();return!!property&&!this.isProxySetByExtension_()&&this.isNetworkPolicyEnforced(property)}shouldShowAllowShared_(_property){if(!this.isShared_()){return false}return true}onAllowSharedProxiesChange_(){this.$.confirmAllowSharedDialog.showModal()}onAllowSharedDialogConfirm_(){this.$.allowShared.sendPrefChange();this.$.confirmAllowSharedDialog.close()}onAllowSharedDialogCancel_(){this.$.allowShared.resetToPrefValue();this.$.confirmAllowSharedDialog.close()}onAllowSharedDialogClose_(){this.$.allowShared.focus()}}customElements.define(NetworkProxySectionElement.is,NetworkProxySectionElement);function getTemplate$2k(){return html`<!--_html_template_start_--><style include="settings-shared">#description{margin-bottom:var(--cr-section-vertical-margin)}</style>
<cr-dialog id="dialog" close-text="$i18n{close}">
  <div slot="title">
    $i18n{networkSectionPasspointGoToSubscriptionTitle}
  </div>
  <div slot="body">
    <span id="information">
      $i18n{networkSectionPasspointGoToSubscriptionInformation}
      <a href="$i18nRaw{wifiPasspointLearnMoreUrl}" target="_blank"
          aria-label="$i18n{passpointLearnMoreA11yLabel}">
        $i18n{learnMoreLabel}
      </a>
    </span>
  </div>
  <div slot="button-container">
    <cr-button id="cancelButton" class="cancel-button"
        aria-label="$i18n{passpointRemoveCancelA11yLabel}"
        on-click="onCancelClick_">
      $i18n{cancel}
    </cr-button>
    <cr-button id="confirmButton" class="action-button"
        aria-label="$i18n{passpointRemoveGoToSubscriptionButtonA11yLabel}"
        on-click="onConfirmClick_">
      $i18n{networkSectionPasspointGoToSubscriptionButtonLabel}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PasspointRemoveDialogElementBase=I18nMixin(PolymerElement);class PasspointRemoveDialogElement extends PasspointRemoveDialogElementBase{static get is(){return"passpoint-remove-dialog"}static get template(){return getTemplate$2k()}static get properties(){return{}}constructor(){super()}open(){const dialog=this.getDialog_();if(!dialog.open){dialog.showModal()}this.shadowRoot.querySelector("#confirmButton").focus()}close(){const dialog=this.getDialog_();if(dialog.open){dialog.close()}}getDialog_(){return castExists(this.shadowRoot.querySelector("#dialog"))}onCancelClick_(){this.getDialog_().cancel()}onConfirmClick_(){const event=new CustomEvent("confirm",{bubbles:true,composed:true});this.dispatchEvent(event)}}customElements.define(PasspointRemoveDialogElement.is,PasspointRemoveDialogElement);function getTemplate$2j(){return html`<!--_html_template_start_--><style include="network-shared"></style>
<h2>[[i18n('TrafficCountersTrafficCounters')]]</h2>
<div class="button-group">
  <cr-button id="requestButton" on-click="onRequestTrafficCountersClick_">
    [[i18n('TrafficCountersRequestTrafficCounters')]]
  </cr-button>
</div>
<template is="dom-repeat" items="[[networks_]]" as="network">
  <network-health-container
      label="[[getNetworkTypeString_(network.type)]]"
      expanded="[[getTypeExpanded_(network.type, typeExpanded_.*)]]"
      on-toggle-expanded="onToggleExpanded_">
    <span slot="header">
      <img class="type-icon" src="[[getNetworkTypeIcon_(network.type)]]">
    </span>
    <div id="name" class="network-attribute-container">
      <div class="network-attribute-label">[[i18n('OncName')]]</div>
      <span class="network-attribute-value">[[network.name]]</span>
    </div>
    <div id="guid" class="network-attribute-container">
      <div class="network-attribute-label">[[i18n('TrafficCountersGuid')]]</div>
      <span class="network-attribute-value">[[network.guid]]</span>
    </div>
    <div id="counters" class="network-attribute-container">
      <div class="network-attribute-label">
        [[i18n('TrafficCountersTrafficCounters')]]
      </div>
      <span class="network-attribute-value">
        [[countersToString_(network.counters)]]
      </span>
    </div>
    <div id="time" class="network-attribute-container">
      <div class="network-attribute-label">
        [[i18n('TrafficCountersLastResetTime')]]
      </div>
      <span class="network-attribute-value">
        [[lastResetTimeString_(network)]]
      </span>
    </div>
    <div id="reset" class="network-attribute-container">
      <div class="button-group">
        <cr-button id="resetButton" on-click="onResetTrafficCountersClick_">
          [[i18n('TrafficCountersResetTrafficCounters')]]
        </cr-button>
      </div>
    </div>
  </network-health-container>
</template>
<!--_html_template_end_-->`}
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const kDefaultResetDay=1;function createNetwork$1(guid,name,type,counters,lastResetTime,friendlyDate,userSpecifiedResetDay){return{guid:guid,name:name,type:type,counters:counters,lastResetTime:lastResetTime,friendlyDate:friendlyDate,userSpecifiedResetDay:userSpecifiedResetDay}}class TrafficCountersAdapter{constructor(){this.networkConfig_=MojoInterfaceProviderImpl.getInstance().getMojoServiceRemote()}async requestTrafficCountersForActiveNetworks(){const filter={filter:FilterType.kActive,networkType:NetworkType.kAll,limit:NO_LIMIT};const networks=[];const networkStateList=await this.networkConfig_.getNetworkStateList(filter);for(const networkState of networkStateList.result){const trafficCounters=await this.requestTrafficCountersForNetwork(networkState.guid);const lastResetTime=await this.requestLastResetTimeForNetwork(networkState.guid);const friendlyDate=await this.requestFriendlyDateForNetwork(networkState.guid);const userSpecifiedResetDay=await this.requestUserSpecifiedResetDayForNetwork(networkState.guid);networks.push(createNetwork$1(networkState.guid,networkState.name,networkState.type,trafficCounters,lastResetTime,friendlyDate,userSpecifiedResetDay))}return networks}async resetTrafficCountersForNetwork(guid){await this.networkConfig_.resetTrafficCounters(guid)}async requestTrafficCountersForNetwork(guid){const trafficCountersObj=await this.networkConfig_.requestTrafficCounters(guid);return trafficCountersObj.trafficCounters}async requestLastResetTimeForNetwork(guid){const managedPropertiesPromise=await this.networkConfig_.getManagedProperties(guid);if(!managedPropertiesPromise||!managedPropertiesPromise.result){return null}const trafficCounterProperties=managedPropertiesPromise.result.trafficCounterProperties;if(!trafficCounterProperties){return null}return trafficCounterProperties.lastResetTime||null}async requestFriendlyDateForNetwork(guid){const managedPropertiesPromise=await this.networkConfig_.getManagedProperties(guid);if(!managedPropertiesPromise||!managedPropertiesPromise.result){return null}const trafficCounterProperties=managedPropertiesPromise.result.trafficCounterProperties;if(!trafficCounterProperties){return null}return trafficCounterProperties.friendlyDate||null}async requestUserSpecifiedResetDayForNetwork(guid){const managedPropertiesPromise=await this.networkConfig_.getManagedProperties(guid);if(!managedPropertiesPromise||!managedPropertiesPromise.result){return kDefaultResetDay}const trafficCounterProperties=managedPropertiesPromise.result.trafficCounterProperties;if(!trafficCounterProperties){return kDefaultResetDay}return trafficCounterProperties.userSpecifiedResetDay}async setTrafficCountersResetDayForNetwork(guid,resetDay){await this.networkConfig_.setTrafficCountersResetDay(guid,resetDay)}}
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var TechnologyIcons;(function(TechnologyIcons){TechnologyIcons["CELLULAR"]="cellular_0.svg";TechnologyIcons["ETHERNET"]="ethernet.svg";TechnologyIcons["VPN"]="vpn.svg";TechnologyIcons["WIFI"]="wifi_0.svg"})(TechnologyIcons||(TechnologyIcons={}));function createNetwork(guid,name,type,counters,lastResetTime){return{guid:guid,name:name,type:type,counters:counters,lastResetTime:lastResetTime}}function replacer(_key,value){return typeof value==="bigint"?value.toString():value}function convertMojoTimeToJS(mojoTime){const windowsEpoch=Date.UTC(1601,0,1,0,0,0,0);const unixEpoch=Date.UTC(1970,0,1,0,0,0,0);const epochDeltaInMs=unixEpoch-windowsEpoch;const timeInMs=Number(mojoTime.internalValue)/1e3;return new Date(timeInMs-epochDeltaInMs)}const TrafficCountersElementBase=I18nMixin(PolymerElement);class TrafficCountersElement extends TrafficCountersElementBase{static get is(){return"traffic-counters"}static get template(){return getTemplate$2j()}static get properties(){return{networks_:{type:Array,value:[]},typeExpanded_:{type:Array,value:[]}}}constructor(){super();this.trafficCountersAdapter_=new TrafficCountersAdapter}async onRequestTrafficCountersClick_(){await this.fetchTrafficCountersForActiveNetworks_()}async onResetTrafficCountersClick_(event){const network=event.model.network;await this.trafficCountersAdapter_.resetTrafficCountersForNetwork(network.guid);const trafficCounters=await this.trafficCountersAdapter_.requestTrafficCountersForNetwork(network.guid);const lastResetTime=await this.trafficCountersAdapter_.requestLastResetTimeForNetwork(network.guid);const foundIdx=this.networks_.findIndex((n=>n.guid===network.guid));if(foundIdx===-1){return}this.splice("networks_",foundIdx,1,createNetwork(network.guid,network.name,network.type,trafficCounters,lastResetTime))}async fetchTrafficCountersForActiveNetworks_(){const networks=await this.trafficCountersAdapter_.requestTrafficCountersForActiveNetworks();this.networks_=networks;return this.networks_}getNetworkTypeString_(type){return this.i18n("OncType"+OncMojo.getNetworkTypeString(type))}getNetworkTypeIcon_(type){switch(type){case NetworkType.kEthernet:return TechnologyIcons.ETHERNET;case NetworkType.kWiFi:return TechnologyIcons.WIFI;case NetworkType.kVPN:return TechnologyIcons.VPN;case NetworkType.kTether:case NetworkType.kMobile:case NetworkType.kCellular:return TechnologyIcons.CELLULAR;default:return""}}getTypeExpanded_(type){if(this.typeExpanded_[type]===undefined){this.set("typeExpanded_."+type,false);return false}return this.typeExpanded_[type]}onToggleExpanded_(event){const type=event.model.network.type;this.set("typeExpanded_."+type,!this.typeExpanded_[type])}countersToString_(counters){return JSON.stringify(counters,replacer,4)}lastResetTimeString_(network){if(network.lastResetTime===null||network.lastResetTime===undefined){return""}return convertMojoTimeToJS(network.lastResetTime).toLocaleString()}}customElements.define(TrafficCountersElement.is,TrafficCountersElement);function getTemplate$2i(){return html`<!--_html_template_start_--><style include="internet-shared settings-shared iron-flex md-select">#data-usage-wrapper{align-items:center;display:flex}#resetDayHelpTooltip{margin-inline-end:15px}</style>
<div class="settings-box single-column stretch first">
  [[i18n('TrafficCountersDataUsageDifferentFromProviderLabel')]]
</div>
<div class="settings-box single-column stretch indented first">
  <div id="data-usage-wrapper">
    <div class="start settings-box-text">
      <div id="dataUsageLabel" class="label">
        [[date_]]
      </div>
      <div id="dataUsageSubLabel" class="secondary label">
        [[value_]]
      </div>
    </div>
    <cr-button id="resetDataUsageButton"
      aria-labelledby="dataUsageLabel"
      aria-describedby="dataUsageSubLabel"
      aria-roledescription="$i18n{TrafficCountersDataUsageResetLabel}"
      on-click="onResetDataUsageClick_">
      [[i18n('TrafficCountersDataUsageResetButtonLabel')]]
    </cr-button>
  </div>
  <div id="data-usage-wrapper">
    <div class="start settings-box-text">
      <div id="daySelectionLabel" class="label">
        [[i18n('TrafficCountersDataUsageAutoResetDayOfMonthLabel')]]
      </div>
      <div id="daySelectionSubLabel" class="secondary label">
        [[i18n('TrafficCountersDataUsageAutoResetDayOfMonthSubLabel')]]
      </div>
    </div>
    <cr-tooltip-icon id="resetDayHelpTooltip"
      icon-aria-label="$i18n{TrafficCountersDataUsageResetDayTooltipA11yLabel}"
      icon-class="cr:help-outline"
      tooltip-text="[[i18n('TrafficCountersDataUsageResetDayTooltipText')]]">
    </cr-tooltip-icon>
    <select class="md-select" id="resetDayList"
      aria-labelledby="daySelectionLabel"
      aria-describedby="daySelectionSubLabel"
      on-change="onResetDaySelected_">
      <template is="dom-repeat" items="[[getDaysList_()]]" as="day">
        <option value="[[day]]" selected$="[[isSelected_(day, resetDay_)]]">
          [[day]]
        </option>
      </template>
    </select>
  </div>
</div>
<!--_html_template_end_-->`}
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const DEFAULT_RESET_DAY=1;const KB=1e3;const MB=KB*1e3;const GB=MB*1e3;const TB=GB*1e3;const PB=TB*1e3;function getDataInfoString(totalBytes){let unit="B";let dividend=1;if(totalBytes>=PB){unit="PB";dividend=PB}else if(totalBytes>=TB){unit="TB";dividend=TB}else if(totalBytes>=GB){unit="GB";dividend=GB}else if(totalBytes>=MB){unit="MB";dividend=MB}else if(totalBytes>=KB){unit="KB";dividend=KB}const numBytes=(Number(totalBytes)/dividend).toFixed(2);return`${numBytes} ${unit}`}const SettingsTrafficCountersElementBase=I18nMixin(PolymerElement);class SettingsTrafficCountersElement extends SettingsTrafficCountersElementBase{static get is(){return"settings-traffic-counters"}static get template(){return getTemplate$2i()}static get properties(){return{guid:{type:String,value:"",observer:"load"},managedProperties:{type:Object,observer:"managedPropertiesChanged_"},date_:{type:String,value:""},value_:{type:String,value:""},resetDay_:{type:Number,value:DEFAULT_RESET_DAY}}}constructor(){super();this.trafficCountersAdapter_=new TrafficCountersAdapter}load(){this.populateDate_();this.populateDataUsageValue_();this.populateUserSpecifiedResetDay_()}managedPropertiesChanged_(){this.load()}async onResetDataUsageClick_(){await this.trafficCountersAdapter_.resetTrafficCountersForNetwork(this.guid);this.load();getInstance().announce(this.i18n("TrafficCountersDataUsageResetButtonPressedA11yMessage"))}async getNetworkIfAvailable_(){const networks=await this.trafficCountersAdapter_.requestTrafficCountersForActiveNetworks();const network=networks.find((n=>n.guid===this.guid));return network||null}async populateDate_(){const result=await this.populateDateHelper_();this.date_=result}async populateDateHelper_(){const network=await this.getNetworkIfAvailable_();if(network===null||network.friendlyDate===null){return this.i18n("TrafficCountersDataUsageLastResetDateUnavailableLabel")}return this.i18n("TrafficCountersDataUsageSinceLabel",network.friendlyDate)}async populateDataUsageValue_(){const result=await this.populateDataUsageValueHelper_();this.value_=result}async populateDataUsageValueHelper_(){const network=await this.getNetworkIfAvailable_();if(network===null){return getDataInfoString(BigInt(0))}let totalBytes=BigInt(0);for(const sourceDict of network.counters){totalBytes+=BigInt(sourceDict.rxBytes)+BigInt(sourceDict.txBytes)}return getDataInfoString(totalBytes)}async populateUserSpecifiedResetDay_(){const result=await this.populateUserSpecifiedResetDayHelper_();this.resetDay_=result}async populateUserSpecifiedResetDayHelper_(){const network=await this.getNetworkIfAvailable_();return network?network.userSpecifiedResetDay:DEFAULT_RESET_DAY}onResetDaySelected_(){this.resetDay_=Number(this.$.resetDayList.value);this.trafficCountersAdapter_.setTrafficCountersResetDayForNetwork(this.guid,{value:this.resetDay_})}getDaysList_(){return Array.from({length:31},((_,i)=>i+1))}isSelected_(item,selectedDay){return item===selectedDay}}customElements.define(SettingsTrafficCountersElement.is,SettingsTrafficCountersElement);function getTemplate$2h(){return html`<!--_html_template_start_--><style include="settings-shared iron-flex">:host{--section-padding:24px;--bottom-padding:20px;--cr-dialog-title-slot-padding-top:var(--section-padding);--cr-dialog-title-slot-padding-bottom:var(--section-padding);--cr-dialog-title-slot-padding-start:var(--section-padding);--cr-dialog-title-slot-padding-end:var(--section-padding);--cr-dialog-button-container-padding-horizontal:var(--section-padding);--cr-dialog-button-container-padding-bottom:var(--bottom-padding)}[slot=body]>*{margin-inline-start:5px}iron-icon{--iron-icon-fill-color:var(--cros-icon-color-prominent)}#host-device-text-container{display:flex;flex-direction:column;margin-inline-start:18px}#availability-title{color:var(--cros-text-color-secondary);margin-top:5px}#host-device-container{align-items:center;display:flex;margin-top:12px;min-height:46px}#tether-explanation,#tether-carrier-warning,#tether-description-title{margin-top:var(--cr-section-vertical-margin)}#tether-carrier-warning{font-weight:600}#tether-description-list{padding-inline-start:16px}#host-device-lost-container{color:var(--cros-text-color-alert);font-weight:500}#host-device-lost-container iron-icon{--iron-icon-fill-color:var(--cros-icon-color-alert)}</style>
<cr-dialog id="dialog" close-text="$i18n{close}">
  <div slot="title">$i18n{tetherConnectionDialogTitle}</div>
  <div slot="body">
    <span id="availability-title">
      $i18n{tetherConnectionAvailableDeviceTitle}
    </span>
    <div id="host-device-container">
      <iron-icon id="host-device-signal-strength-icon"
          icon="[[getSignalStrengthIconName_(managedProperties)]]"
          aria-label$="[[getSignalStrengthLabel_(managedProperties)]]">
      </iron-icon>
      <div id="host-device-text-container">
        <span id="host-device-text-name"
            aria-describedby="host-device-signal-strength-icon
            hostDeviceTextBattery">
          [[getDeviceName_(managedProperties)]]
        </span>
        <span id="hostDeviceTextBattery" class="secondary"
            aria-hidden="true">
          [[getBatteryPercentageString_(managedProperties)]]
        </span>
      </div>
      <div class="flex"></div>
      <div id="host-device-lost-container" hidden$="[[!outOfRange]]">
        <iron-icon icon="os-settings:alert-device-out-of-range">
        </iron-icon>
        $i18n{tetherPhoneOutOfRange}
      </div>
    </div>
    <div id="tether-explanation">
      [[getExplanation_(managedProperties)]]
    </div>
    <div id="tether-carrier-warning">
      $i18n{tetherConnectionCarrierWarning}
    </div>
    <div id="tether-description-title">
      [[getDescriptionTitle_(managedProperties)]]
    </div>
    <ul id="tether-description-list">
      <li>$i18n{tetherConnectionDescriptionMobileData}</li>
      <li>[[getBatteryDescription_(managedProperties)]]</li>
      <li hidden$="[[!shouldShowDisconnectFromWifi_(managedProperties)]]">
        $i18n{tetherConnectionDescriptionWiFi}
      </li>
    </ul>
  </div>
  <div slot="button-container">
    <cr-button class="cancel-button" on-click="onNotNowClick_">
      $i18n{tetherConnectionNotNowButton}
    </cr-button>
    <cr-button id="connectButton" class="action-button"
        on-click="onConnectClick_" disabled="[[outOfRange]]">
      $i18n{tetherConnectionConnectButton}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function signalStrengthToBarCount(strength){if(strength>75){return 4}if(strength>50){return 3}if(strength>25){return 2}if(strength>0){return 1}return 0}const TetherConnectionDialogElementBase=I18nMixin(PolymerElement);class TetherConnectionDialogElement extends TetherConnectionDialogElementBase{static get is(){return"tether-connection-dialog"}static get template(){return getTemplate$2h()}static get properties(){return{managedProperties:Object,outOfRange:Boolean}}open(){const dialog=this.getDialog_();if(!dialog.open){dialog.showModal()}this.shadowRoot.querySelector("#connectButton").focus()}close(){const dialog=this.getDialog_();if(dialog.open){dialog.close()}}getDialog_(){return castExists(this.shadowRoot.querySelector("#dialog"))}onNotNowClick_(){this.getDialog_().cancel()}onConnectClick_(){const event=new CustomEvent("tether-connect",{bubbles:true,composed:true});this.dispatchEvent(event)}shouldShowDisconnectFromWifi_(_managedProperties){return true}getBatteryPercentageAsString_(managedProperties){return managedProperties?managedProperties.typeProperties.tether.batteryPercentage.toString():"0"}getSignalStrengthIconName_(managedProperties){const signalStrength=managedProperties?managedProperties.typeProperties.tether.signalStrength:0;const barCount=signalStrengthToBarCount(signalStrength);return`os-settings:signal-cellular-${barCount}-bar`}getSignalStrengthLabel_(managedProperties){const signalStrength=managedProperties?managedProperties.typeProperties.tether.signalStrength:0;const networkTypeString=this.i18n("OncTypeTether");return this.i18n("networkIconLabelSignalStrength",networkTypeString,signalStrength)}getDeviceName_(managedProperties){return managedProperties?OncMojo.getNetworkNameUnsafe(managedProperties):""}getBatteryPercentageString_(managedProperties){return managedProperties?this.i18n("tetherConnectionBatteryPercentage",this.getBatteryPercentageAsString_(managedProperties)):""}getExplanation_(managedProperties){return managedProperties?loadTimeData.getStringF("tetherConnectionExplanation",OncMojo.getNetworkNameUnsafe(managedProperties)):""}getDescriptionTitle_(managedProperties){return managedProperties?loadTimeData.getStringF("tetherConnectionDescriptionTitle",OncMojo.getNetworkNameUnsafe(managedProperties)):""}getBatteryDescription_(managedProperties){return managedProperties?this.i18n("tetherConnectionDescriptionBattery",this.getBatteryPercentageAsString_(managedProperties)):""}}customElements.define(TetherConnectionDialogElement.is,TetherConnectionDialogElement);
// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
let instance$9=null;class OsSyncBrowserProxyImpl{static getInstance(){return instance$9||(instance$9=new OsSyncBrowserProxyImpl)}static setInstanceForTesting(obj){instance$9=obj}didNavigateToOsSyncPage(){chrome.send("DidNavigateToOsSyncPage")}didNavigateAwayFromOsSyncPage(){chrome.send("DidNavigateAwayFromOsSyncPage")}sendOsSyncPrefsChanged(){chrome.send("OsSyncPrefsDispatch")}setOsSyncDatatypes(osSyncPrefs){chrome.send("SetOsSyncDatatypes",[osSyncPrefs])}}function getTemplate$2g(){return html`<!--_html_template_start_--><style include="internet-shared settings-shared iron-flex">:host{padding-bottom:40px}iron-icon{margin-inline-end:10px}cr-policy-indicator{margin-inline-start:var(--cr-controlled-by-spacing)}cr-policy-network-indicator-mojo{margin:0 var(--cr-controlled-by-spacing)}#networkState[connected]{color:var(--cros-text-color-positive)}#networkState[warning]{color:var(--cros-text-color-warning)}#networkState[error]{color:var(--cros-text-color-alert)}#preferNetworkToggleContainer:hover{background-color:var(--cr-hover-background-color)}#preferNetworkToggleContainer:active{background-color:var(--cr-active-background-color)}paper-spinner-lite{height:var(--cr-icon-size);width:var(--cr-icon-size)}.warning{color:var(--cr-secondary-text-color);margin-inline-start:var(--cr-controlled-by-spacing)}#signinButton>iron-icon{margin-inline-end:0}#mac-address-container{border-top:none}#hiddenToggle{margin-inline-start:var(--cr-section-padding)}cr-link-row:not([warning]){--cr-secondary-text-color:var(--cros-text-color-positive)}#apnSubpageButton{height:var(--cr-section-two-line-min-height)}</style>
<!-- Title section: Icon + name + connection state. -->
<div id="titleDiv" class="settings-box first">
  <div class="start layout horizontal center">
    <network-icon
        show-technology-badge="[[showTechnologyBadge_]]"
        network-state="[[getNetworkState_(managedProperties_)]]">
    </network-icon>
    <div id="networkState" class="title settings-box-text"
        connected$="[[showConnectedState_(managedProperties_)]]"
        warning$="[[showRestrictedConnectivity_(managedProperties_,
                           deviceState_)]]"
        error$="[[isOutOfRangeOrNotEnabled_(outOfRange_, deviceState_)]]">
      [[getStateText_(managedProperties_, propertiesReceived_,
          outOfRange_, deviceState_)]]
    </div>
    <template is="dom-if"
        if="[[isPolicySource(managedProperties_.source))]]">
      <cr-policy-indicator
          indicator-type="[[getIndicatorTypeForSource(
              managedProperties_.source)]]">
      </cr-policy-indicator>
    </template>
  </div>
  <cr-button id="signinButton" on-click="onSigninClick_"
      hidden$="[[!showSignin_(managedProperties_)]]"
      disabled="[[disableSignin_(managedProperties_, disabled_)]]">
    <iron-icon icon="cr:open-in-new" slot="prefix-icon"></iron-icon>
    $i18n{networkButtonSignin}
  </cr-button>
  <cr-button id="forgetButton" on-click="onForgetClick_"
      hidden$="[[!showForget_(managedProperties_)]]"
      disabled="[[disableForget_(managedProperties_,
          prefs.vpn_config_allowed, disabled_)]]">
    $i18n{networkButtonForget}
  </cr-button>
  <cr-button id="viewAccountButton"
      on-click="onViewAccountClick_"
      hidden$="[[!showViewAccount_(managedProperties_)]]"
      disabled="[[disabled_]]">
    $i18n{networkButtonViewAccount}
  </cr-button>
  <cr-button id="activateButton"
      on-click="onActivateClick_"
      hidden$="[[!showActivate_(managedProperties_)]]"
      disabled="[[disabled_]]">
    $i18n{networkButtonActivate}
  </cr-button>
  <cr-button id="configureButton" on-click="onConfigureClick_"
      hidden$="[[!showConfigure_(managedProperties_, globalPolicy,
          managedNetworkAvailable)]]"
      disabled="[[disableConfigure_(managedProperties_,
          prefs.vpn_config_allowed, disabled_)]]"
      deep-link-focus-id$="[[Setting.kConfigureEthernet]]">
    $i18n{networkButtonConfigure}
  </cr-button>
  <!-- Use policy properties from vpn_config_allowed to indicate when that
      pref disables buttons in this row. -->
  <controlled-button id="connectDisconnect" class="action-button"
      on-click="onConnectDisconnectClick_"
      hidden$="[[shouldConnectDisconnectButtonBeHidden_(
          managedProperties_, globalPolicy, managedNetworkAvailable,
          deviceState_)]]"
      disabled="[[shouldConnectDisconnectButtonBeDisabled_(
          managedProperties_, defaultNetwork, propertiesReceived_,
          outOfRange_, globalPolicy, managedNetworkAvailable,
          deviceState_, disabled_)]]"
      label="[[getConnectDisconnectButtonLabel_(managedProperties_,
          globalPolicy,managedNetworkAvailable, deviceState_)]]"
      pref="[[getFakeVpnConfigPrefForEnforcement_(managedProperties_,
          prefs.vpn_config_allowed)]]"
      deep-link-focus-id$="[[Setting.kDisconnectWifiNetwork]]
          [[Setting.kDisconnectCellularNetwork]]
          [[Setting.kDisconnectTetherNetwork]]">
  </controlled-button>
</div>


<!-- Start of NOTICES section. -->
<!-- If row ordering changes, messagesDividerClass_() must be updated. -->
<template is="dom-if" if="[[isBlockedByPolicy_(managedProperties_,
                            globalPolicy, managedNetworkAvailable)]]">
  <!-- Disabled by policy -->
  <div class="settings-box continuation">
    <iron-icon class="policy" icon="cr20:domain"></iron-icon>
    <div class="settings-box-text">$i18n{networkConnectNotAllowed}</div>
  </div>
</template>

<template is="dom-if" if="[[isSecondaryUser_]]">
  <!-- Non primary users. -->
  <div class$="settings-box single-column
              [[messagesDividerClass_('secondary', managedProperties_,
                  globalPolicy, managedNetworkAvailable,
                  isSecondaryUser_, isWifiSyncEnabled_, deviceState_)]]">
    <div class="layout horizontal center">
      <iron-icon class="policy" icon="cr:group"></iron-icon>
      <div class="settings-box-text">
        [[i18n('networkPrimaryUserControlled', primaryUserEmail_)]]
      </div>
    </div>
  </div>
</template>


<template is="dom-if"
    if="[[showShared_(managedProperties_, globalPolicy,
        managedNetworkAvailable, deviceState_)]]">
  <!-- Shared network. -->
  <div class$="settings-box settings-box-text
              [[messagesDividerClass_('shared', managedProperties_,
                  globalPolicy, managedNetworkAvailable,
                  isSecondaryUser_, isWifiSyncEnabled_, deviceState_)]]">
      [[sharedString_(managedProperties_)]]
  </div>
</template>
<template is="dom-if"
    if="[[showSynced_(managedProperties_, globalPolicy,
        managedNetworkAvailable, isWifiSyncEnabled_)]]">
  <!-- Synced network. -->
  <div class$="settings-box settings-box-text
              [[messagesDividerClass_('synced', managedProperties_,
                  globalPolicy, managedNetworkAvailable,
                  isSecondaryUser_, isWifiSyncEnabled_, deviceState_)]]">
      <localized-link
          localized-string="[[syncedString_(managedProperties_)]]">
      </localized-link>
  </div>
</template>
<template is="dom-if"
    if="[[isCarrierLockedActiveSim_(managedProperties_, deviceState_)]]">
  <!-- Carrier locked network. -->
  <div class$="settings-box settings-box-text
      [[messagesDividerClass_('carrierlocked', managedProperties_,
          globalPolicy, managedNetworkAvailable,
          isSecondaryUser_, isWifiSyncEnabled_, deviceState_)]]">
    <localized-link id="carrierLockedNoticeLink"
        localized-string="[[i18nAdvanced('networkCarrierLocked')]]">
    </localized-link>
  </div>
</template>
<!-- End of NOTICES section -->

<template is="dom-if" if="[[!isSecondaryUser_]]">
  <template is="dom-if" if="[[showConfigurableSections_]]"  restamp>
    <!-- Prefer this network. -->
    <template is="dom-if"
        if="[[showPreferNetwork_(managedProperties_, globalPolicy,
            managedNetworkAvailable)]]">
      <div id="preferNetworkToggleContainer" class="settings-box"
          on-click="onPreferNetworkRowClicked_"
          actionable$="[[!isNetworkPolicyEnforced(
              managedProperties_.priority)]]">
        <div id="preferNetworkToggleLabel" class="start settings-box-text">
          $i18n{networkPrefer}
          <div class="secondary">
            $i18n{networkPreferDescription}
          </div>
        </div>
        <cr-policy-network-indicator-mojo
            property="[[managedProperties_.priority]]">
        </cr-policy-network-indicator-mojo>
        <cr-toggle id="preferNetworkToggle" checked="{{preferNetwork_}}"
            disabled="[[shouldPreferNetworkToggleBeDisabled_(
                managedProperties_.priority, disabled_)]]"
            aria-labelledby="preferNetworkToggleLabel"
            deep-link-focus-id$="[[Setting.kPreferWifiNetwork]]">
        </cr-toggle>
      </div>
    </template>
    <!-- Autoconnect. -->
    <template is="dom-if"
        if="[[showAutoConnect_(managedProperties_, globalPolicy,
            managedNetworkAvailable)]]">
      <settings-toggle-button id="autoConnectToggle" class="hr"
          pref="{{autoConnectPref_}}"
          label="[[getAutoConnectToggleLabel_(managedProperties_)]]"
          deep-link-focus-id$="[[Setting.kWifiAutoConnectToNetwork]]
              [[Setting.kCellularAutoConnectToNetwork]]"
          disabled="[[disabled_]]">
      </settings-toggle-button>
      <!-- Hidden Network Warning -->
      <template is="dom-if"
          if="[[showHiddenNetworkWarning_(autoConnectPref_.*,
              managedProperties_)]]"
          restamp>
        <div class="warning">
          <iron-icon icon="cr:warning"></iron-icon>
          [[i18n('hiddenNetworkWarning')]]
        </div>
      </template>
    </template>
    <!-- Always-on VPN. -->
    <template is="dom-if"
        if="[[showAlwaysOnVpn_(managedProperties_)]]">
      <settings-toggle-button id="alwaysOnVpnToggle" class="hr"
          pref="{{alwaysOnVpn_}}"
          label="$i18n{networkAlwaysOnVpn}"
          disabled="[[disabled_]]">
      </settings-toggle-button>
    </template>
    <!-- Data roaming (Cellular only). -->
    <template is="dom-if" if="[[isCellular_(managedProperties_)]]">
      <cellular-roaming-toggle-button
        disabled="[[disabled_]]"
        managed-properties="[[managedProperties_]]"
        prefs="{{prefs}}">
      </cellular-roaming-toggle-button>
    </template>
    <!-- Public Key (WireGuard VPN only). -->
    <template is="dom-if" if="[[isWireGuard_(managedProperties_)]]">
      <div id="wgPublicKeyField"
          class="settings-box two-line single-column stretch settings-box-text">
        <div aria-hidden="true" id="wgPublicKeyLabel">
          $i18n{OncVPN-WireGuard-PublicKey}
        </div>
        <div class="secondary" aria-labelledby="wgPublicKeyLabel">
          [[managedProperties_.typeProperties.vpn.wireguard.publicKey.activeValue]]
        </div>
      </div>
    </template>
    <!-- IP Address. -->
    <div
      class="settings-box two-line single-column stretch settings-box-text"
      hidden$="[[!showIpAddress_(ipAddress_, managedProperties_)]]">
      <div>$i18n{networkIPAddress}</div>
      <div class="secondary">[[ipAddress_]]</div>
    </div>
    <!-- Properties to always show if present. -->
    <template is="dom-if" if="[[hasInfoFields_(managedProperties_)]]">
      <div class="settings-box single-column stretch">
        <network-property-list-mojo id="infoFields"
            fields="[[getInfoFields_(managedProperties_)]]"
            edit-field-types="[[getInfoEditFieldTypes_(
              managedProperties_)]]"
            property-dict="[[managedProperties_]]"
            on-property-change="onNetworkPropertyChange_"
            disabled="[[disabled_]]">
        </network-property-list-mojo>
      </div>
    </template>
  </template>

  <!-- APN row item -->
  <template is="dom-if" if="[[showConfigurableSections_]]" restamp>
    <template is="dom-if" if="[[shouldShowApnRow_(managedProperties_,
        isApnRevampEnabled_)]]">
      <cr-link-row
          id="apnSubpageButton"
          class="hr"
          label="$i18n{internetApnPageTitle}"
          sub-label="[[getApnRowSubLabel_(managedProperties_)]]"
          on-click="onApnRowClicked_"
          role-description="$i18n{subpageArrowRoleDescription}"
          warning$="[[showRestrictedConnectivity_(managedProperties_,
              deviceState_)]]"
          disabled="[[disabled_]]">
        <template is="dom-if" if="[[isApnManaged_(globalPolicy)]]">
          <cr-policy-indicator id="apnManagedIcon"
              indicator-type="devicePolicy"
              icon-aria-label="$i18n{internetApnPageTitle}">
          </cr-policy-indicator>
        </template>
      </cr-link-row>
    </template>
  </template>

  <!-- Passpoint provider link -->
  <template is="dom-if" if="[[shouldShowPasspointProviderRow_(
        managedProperties_)]]">
    <div id="passpointProviderRow" class="settings-box two-line"
        on-click="onPasspointRowClicked_">
      <div class="flex settings-box-text">
        <div>$i18n{passpointProviderLabel}</div>
        <div class="secondary">
          [[getPasspointSubscriptionName_(passpointSubscription_)]]
        </div>
      </div>
      <cr-icon-button class="subpage-arrow"
          aria-roledescription="$i18n{subpageArrowRoleDescription}">
      </cr-icon-button>
    </div>
  </template>

  <template is="dom-if" if="[[hasAdvancedSection_(managedProperties_,
                              propertiesReceived_, deviceState_)]]">
    <!-- Advanced toggle. -->
    <cr-expand-button
        id="advancedSectionToggle"
        aria-label="$i18n{networkSectionAdvancedA11yLabel}"
        class="settings-box"
        expanded="{{advancedExpanded_}}">
      $i18n{networkSectionAdvanced}
    </cr-expand-button>

    <!-- Advanced section -->
    <iron-collapse opened="[[advancedExpanded_]]">
      <div class="settings-box single-column stretch indented first">
          <!-- SIM Info (Cellular only). -->
        <template is="dom-if"
            if="[[showCellularSimUpdatedUi_(managedProperties_)]]" restamp>
          <div class="single-column stretch">
            <network-siminfo id="cellularSimInfoAdvanced"
                network-state="[[getNetworkState_(managedProperties_)]]"
                device-state="[[deviceState_]]"
                global-policy="[[globalPolicy]]"
                disabled="[[disabled_]]">
            </network-siminfo>
          </div>
        </template>

        <!-- Suppress Text Messages (Cellular only). -->
        <template is="dom-if"
            if="[[shouldShowSuppressTextMessagesToggle_(managedProperties_,
                  deviceState_)]]" restamp>
          <div class="single-column stretch">
            <network-config-toggle id="suppressTextMessagesToggle" policy-on-left
                property="[[managedProperties_.typeProperties.cellular.allowTextMessages]]"
                label="$i18n{networkSuppressTextMessages}"
                checked="{{suppressTextMessagesOverride_}}"
                on-checked-changed="suppressTextMessagesChanged_"
                disabled="[[disabled_]]">
            </network-config-toggle>
          </div>
        </template>

        <!-- Metered (WiFi and Cellular only). -->
        <template is="dom-if"
            if="[[showMetered_(managedProperties_)]]">
          <network-config-toggle id="meteredToggle" policy-on-left
              property="[[managedProperties_.metered]]"
              label="$i18n{networkMetered}"
              sub-label="$i18n{networkMeteredDesc}"
              checked="{{meteredOverride_}}"
              on-checked-changed="meteredChanged_"
              deep-link-focus-id$="[[Setting.kWifiMetered]]
                  [[Setting.kCellularMetered]]"
              disabled="[[disabled_]]">
          </network-config-toggle>
        </template>
        <!-- Advanced properties -->
        <template is="dom-if"
            if="[[hasAdvancedFields_(managedProperties_)]]">
          <network-property-list-mojo id="advancedFields"
              fields="[[getAdvancedFields_(managedProperties_)]]"
              property-dict="[[managedProperties_]]"
              disabled="[[disabled_]]">
          </network-property-list-mojo>
        </template>
        <!-- Device properties -->
        <template is="dom-if"
            if="[[hasDeviceFields_(managedProperties_, deviceState_)]]">
          <network-property-list-mojo id="deviceFields"
              fields="[[getDeviceFields_(managedProperties_,
                  deviceState_)]]"
              property-dict="[[managedProperties_]]"
              disabled="[[disabled_]]">
          </network-property-list-mojo>
        </template>
      </div>
    </iron-collapse>
  </template>

  <template is="dom-if" if="[[showDataUsage_(managedProperties_,
      trafficCountersAvailable_)]]">
    <!-- Data usage toggle. -->
    <cr-expand-button
        aria-label="$i18n{TrafficCountersDataUsageLabel}"
        class="settings-box"
        expanded="{{dataUsageExpanded_}}">
      $i18n{TrafficCountersDataUsageLabel}
    </cr-expand-button>

    <!-- Data usage section -->
    <iron-collapse opened="[[dataUsageExpanded_]]">
      <settings-traffic-counters id="settingsTrafficCounters"
          guid="[[guid]]"
          managed-properties="[[managedProperties_]]"
          on-reset-day-changed="computeTrafficCountersAvailable_"
          on-reset-data-usage-button-clicked="computeTrafficCountersAvailable_">
      </settings-traffic-counters>
    </iron-collapse>
  </template>

  <template is="dom-if" if="[[showConfigurableSections_]]"  restamp>
    <template is="dom-if" if="[[hasNetworkSection_(managedProperties_,
        globalPolicy, managedNetworkAvailable)]]">
      <!-- Network toggle -->
      <cr-expand-button
          id="configurableSections"
          aria-label="$i18n{networkSectionNetworkExpandA11yLabel}"
          class="settings-box"
          expanded="{{networkExpanded_}}">
        <div class="settings-row">
          <div class="start">
            $i18n{networkSectionNetwork}
          </div>
          <template is="dom-if" if="[[showScanningSpinner_(
              managedProperties_, deviceState_)]]">
            <paper-spinner-lite active
                title="$i18n{mobileNetworkScanningLabel}">
            </paper-spinner-lite>
          </template>
        </div>
      </cr-expand-button>

      <iron-collapse opened="[[networkExpanded_]]">
        <div class="settings-box single-column stretch indented first">
          <!-- Choose Mobile Network (Cellular only). -->
          <template is="dom-if"
              if="[[showCellularChooseNetwork_(managedProperties_)]]">
            <network-choose-mobile device-state="[[deviceState_]]"
                managed-properties="[[managedProperties_]]"
                disabled="[[disabled_]]">
            </network-choose-mobile>
          </template>

          <!-- APN -->
          <template is="dom-if" if="[[shouldShowApnList_(managedProperties_,
              isApnRevampEnabled_)]]">
            <network-apnlist on-apn-change="onApnChange_"
                managed-properties="[[managedProperties_]]"
                disabled="[[disabled_]]">
            </network-apnlist>
          </template>

          <!-- IP Config, Nameservers -->
          <template is="dom-if"
              if="[[isRememberedOrConnected_(managedProperties_)]]">
            <network-ip-config on-ip-change="onIpConfigChange_"
                managed-properties="[[managedProperties_]]"
                disabled="[[disabled_]]">
            </network-ip-config>
            <network-nameservers on-nameservers-change="onIpConfigChange_"
                managed-properties="[[managedProperties_]]"
                disabled="[[disabled_]]">
            </network-nameservers>
          </template>
        </div>

        <!-- MAC Address. -->
        <div class="settings-box two-line single-column stretch indented"
            id="mac-address-container"
            hidden$="[[!shouldShowMacAddress_(deviceState_)]]">
          <div>$i18n{OncMacAddress}</div>
          <div class="secondary">[[getMacAddress_(deviceState_)]]</div>
        </div>

        <!-- Hidden. -->
        <template is="dom-if"
            if="[[showHiddenNetworkToggle_(
                    globalPolicy,
                    managedNetworkAvailable,
                    managedProperties_)]]">
          <settings-toggle-button id="hiddenToggle"
              pref="{{hiddenPref_}}"
              label="$i18n{networkHidden}"
              sub-label="$i18n{networkHiddenSublabel}"
              sub-label-icon="cr20:warning"
              learn-more-url="$i18n{wifiHiddenNetworkLearnMoreUrl}"
              deep-link-focus-id$="[[Setting.kWifiHidden]]">
          </settings-toggle-button>
        </template>
      </iron-collapse>
    </template>

    <template is="dom-if" if="[[hasProxySection_(managedProperties_,
        globalPolicy, managedNetworkAvailable)]]">
      <!-- Proxy toggle -->
      <cr-expand-button
          id="proxySectionToggle"
          aria-label="$i18n{networkSectionProxyExpandA11yLabel}"
          class="settings-box"
          expanded="{{proxyExpanded_}}">
        $i18n{networkSectionProxy}
      </cr-expand-button>

      <iron-collapse opened="[[proxyExpanded_]]">
        <network-proxy-section prefs="{{prefs}}"
            on-proxy-change="onProxyChange_"
            managed-properties="[[managedProperties_]]"
            disabled="[[disabled_]]">
        </network-proxy-section>
      </iron-collapse>
    </template>
  </template>
</template>
<template is="dom-if" if="[[isTether_(managedProperties_)]]" restamp>
  <tether-connection-dialog id="tetherDialog"
      managed-properties="[[managedProperties_]]"
      on-tether-connect="onTetherConnect_"
      out-of-range="[[outOfRange_]]">
  </tether-connection-dialog>
</template>
<template is="dom-if" if="[[isPasspointWifi_(managedProperties_)]]" restamp>
  <!-- Passpoint subscription removal confirmation dialog -->
  <passpoint-remove-dialog id="passpointRemovalDialog"
      on-confirm="onPasspointRemovalDialogConfirm_">
  </passpoint-remove-dialog>
</template>
<!--_html_template_end_-->`}
// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsInternetDetailPageElementBase=mixinBehaviors([NetworkListenerBehavior,CrPolicyNetworkBehaviorMojo],DeepLinkingMixin(PrefsMixin(RouteObserverMixin(WebUiListenerMixin(I18nMixin(PolymerElement))))));class SettingsInternetDetailPageElement extends SettingsInternetDetailPageElementBase{static get is(){return"settings-internet-detail-subpage"}static get template(){return getTemplate$2g()}static get properties(){return{guid:String,showConfigurableSections_:{type:Boolean,value:true,computed:"computeShowConfigurableSections_(deviceState_, managedProperties_)"},isWifiSyncEnabled_:Boolean,managedProperties_:{type:Object,observer:"managedPropertiesChanged_"},deviceState_:{type:Object,value:null},isSecondaryUser_:{type:Boolean,value(){return loadTimeData.getBoolean("isSecondaryUser")},readOnly:true},primaryUserEmail_:{type:String,value(){return loadTimeData.getBoolean("isSecondaryUser")?loadTimeData.getString("primaryUserEmail"):""},readOnly:true},outOfRange_:{type:Boolean,value:false},defaultNetwork:{type:Object,value:null},globalPolicy:Object,managedNetworkAvailable:{type:Boolean,value:false},autoConnectPref_:{type:Object,observer:"autoConnectPrefChanged_",value(){return{key:"fakeAutoConnectPref",type:chrome.settingsPrivate.PrefType.BOOLEAN,value:false}}},hiddenPref_:{type:Object,observer:"hiddenPrefChanged_",value(){return{key:"fakeHiddenPref",type:chrome.settingsPrivate.PrefType.BOOLEAN,value:false}}},alwaysOnVpn_:{type:Object,observer:"alwaysOnVpnChanged_",value(){return{key:"fakeAlwaysOnPref",type:chrome.settingsPrivate.PrefType.BOOLEAN,value:false}}},meteredOverride_:{type:Boolean,value:false},preferNetwork_:{type:Boolean,value:false,observer:"preferNetworkChanged_"},ipAddress_:{type:String,value:""},showTechnologyBadge_:{type:Boolean,value(){return loadTimeData.valueExists("showTechnologyBadge")&&loadTimeData.getBoolean("showTechnologyBadge")}},showHiddenToggle_:{type:Boolean,value(){return loadTimeData.valueExists("showHiddenToggle")&&loadTimeData.getBoolean("showHiddenToggle")}},isTrafficCountersEnabled_:{type:Boolean,value(){return loadTimeData.valueExists("trafficCountersEnabled")&&loadTimeData.getBoolean("trafficCountersEnabled")}},isTrafficCountersForWifiTestingEnabled_:{type:Boolean,value(){return loadTimeData.valueExists("trafficCountersForWifiTesting")&&loadTimeData.getBoolean("trafficCountersForWifiTesting")}},trafficCountersAvailable_:{type:Boolean,value:false},disabled_:{type:Boolean,value:false,computed:"computeDisabled_(deviceState_.*)"},isApnRevampEnabled_:{type:Boolean,value(){return loadTimeData.valueExists("isApnRevampEnabled")&&loadTimeData.getBoolean("isApnRevampEnabled")}},isApnRevampAndAllowApnModificationPolicyEnabled_:{type:Boolean,value(){return loadTimeData.valueExists("isApnRevampAndAllowApnModificationPolicyEnabled")&&loadTimeData.getBoolean("isApnRevampAndAllowApnModificationPolicyEnabled")}},passpointSubscription_:{type:Object,notify:true},advancedExpanded_:Boolean,networkExpanded_:Boolean,proxyExpanded_:Boolean,dataUsageExpanded_:Boolean}}static get observers(){return["updateAlwaysOnVpnPrefValue_(prefs.arc.vpn.always_on.*)","updateAlwaysOnVpnPrefEnforcement_(managedProperties_,"+"prefs.vpn_config_allowed.*)","updateAutoConnectPref_(globalPolicy)","autoConnectPrefChanged_(autoConnectPref_.*)","alwaysOnVpnChanged_(alwaysOnVpn_.*)","hiddenPrefChanged_(hiddenPref_.*)"]}constructor(){super();this.supportedSettingIds=new Set([Setting.kConfigureEthernet,Setting.kEthernetAutoConfigureIp,Setting.kEthernetDns,Setting.kEthernetProxy,Setting.kDisconnectWifiNetwork,Setting.kPreferWifiNetwork,Setting.kForgetWifiNetwork,Setting.kWifiAutoConfigureIp,Setting.kWifiDns,Setting.kWifiHidden,Setting.kWifiProxy,Setting.kWifiAutoConnectToNetwork,Setting.kCellularSimLock,Setting.kCellularRoaming,Setting.kCellularApn,Setting.kDisconnectCellularNetwork,Setting.kCellularAutoConfigureIp,Setting.kCellularDns,Setting.kCellularProxy,Setting.kCellularAutoConnectToNetwork,Setting.kDisconnectTetherNetwork,Setting.kWifiMetered,Setting.kCellularMetered]);this.CR_EXPAND_BUTTON_TAG="CR-EXPAND-BUTTON";this.didSetFocus_=false;this.propertiesReceived_=false;this.shouldShowConfigureWhenNetworkLoaded_=false;this.applyingChanges_=false;this.pendingSimLockDeepLink_=false;this.browserProxy_=InternetPageBrowserProxyImpl.getInstance();this.networkConfig_=MojoInterfaceProviderImpl.getInstance().getMojoServiceRemote();this.passpointService_=MojoConnectivityProvider.getInstance().getPasspointService();this.osSyncBrowserProxy_=OsSyncBrowserProxyImpl.getInstance();this.trafficCountersAdapter_=new TrafficCountersAdapter}connectedCallback(){super.connectedCallback();this.addWebUiListener("os-sync-prefs-changed",this.handleOsSyncPrefsChanged_.bind(this));this.osSyncBrowserProxy_.sendOsSyncPrefsChanged();this.computeTrafficCountersAvailable_()}afterRenderShowDeepLink_(settingId,elementCallback){afterNextRender(this,(()=>{const deepLinkElement=elementCallback();if(!deepLinkElement||deepLinkElement.hidden){console.warn(`Element with deep link id ${settingId} not focusable.`);return}this.showDeepLinkElement(deepLinkElement)}))}beforeDeepLinkAttempt(settingId){if(settingId===Setting.kCellularRoaming){this.afterRenderShowDeepLink_(settingId,(()=>this.shadowRoot.querySelector("cellular-roaming-toggle-button").getCellularRoamingToggle()));return false}if(settingId===Setting.kCellularApn){this.networkExpanded_=true;this.afterRenderShowDeepLink_(settingId,(()=>this.shadowRoot.querySelector("network-apnlist").getApnSelect()));return false}if(settingId===Setting.kEthernetAutoConfigureIp||settingId===Setting.kWifiAutoConfigureIp||settingId===Setting.kCellularAutoConfigureIp){this.networkExpanded_=true;this.afterRenderShowDeepLink_(settingId,(()=>this.shadowRoot.querySelector("network-ip-config").getAutoConfigIpToggle()));return false}if(settingId===Setting.kEthernetDns||settingId===Setting.kWifiDns||settingId===Setting.kCellularDns){this.networkExpanded_=true;this.afterRenderShowDeepLink_(settingId,(()=>this.shadowRoot.querySelector("network-nameservers").getNameserverRadioButtons()));return false}if(settingId===Setting.kEthernetProxy||settingId===Setting.kWifiProxy||settingId===Setting.kCellularProxy){this.proxyExpanded_=true;this.afterRenderShowDeepLink_(settingId,(()=>this.shadowRoot.querySelector("network-proxy-section").getAllowSharedToggle()));return false}if(settingId===Setting.kWifiMetered||settingId===Setting.kCellularMetered){this.advancedExpanded_=true;return true}if(settingId===Setting.kForgetWifiNetwork){this.afterRenderShowDeepLink_(settingId,(()=>{const forgetButton=this.shadowRoot.getElementById("forgetButton");if(forgetButton&&!forgetButton.hidden){return forgetButton}return this.shadowRoot.getElementById("connectDisconnect")}));return false}if(settingId===Setting.kCellularSimLock){this.advancedExpanded_=true;this.pendingSimLockDeepLink_=true;return false}return true}currentRouteChanged(route,oldRoute){if(route!==routes.NETWORK_DETAIL){return}const queryParams=Router.getInstance().getQueryParameters();const guid=queryParams.get("guid")||"";if(!guid){console.warn("No guid specified for page:"+route);this.close()}this.shouldShowConfigureWhenNetworkLoaded_=queryParams.get("showConfigure")==="true";const type=queryParams.get("type")||"WiFi";const name=queryParams.get("name")||type;this.init(guid,type,name);if(oldRoute===routes.APN&&Router.getInstance().lastRouteChangeWasPopstate()){this.didSetFocus_=true;afterNextRender(this,(()=>{const element=this.shadowRoot.getElementById("apnSubpageButton");if(element){element.focus()}}))}this.attemptDeepLink()}handleOsSyncPrefsChanged_(osSyncPrefs){this.isWifiSyncEnabled_=!!osSyncPrefs&&osSyncPrefs.osWifiConfigurationsSynced}init(guid,type,name){this.guid=guid;this.propertiesReceived_=false;this.deviceState_=null;this.managedProperties_=OncMojo.getDefaultManagedProperties(OncMojo.getNetworkTypeFromString(type),this.guid,name);this.didSetFocus_=false;this.getNetworkDetails_()}close(){if(!this.guid){return}this.guid="";requestAnimationFrame((()=>{this.managedProperties_=undefined;this.propertiesReceived_=false;if(Router.getInstance().currentRoute===routes.NETWORK_DETAIL){Router.getInstance().navigateToPreviousRoute()}}))}onActiveNetworksChanged(networks){if(!this.guid||!this.managedProperties_){return}if(this.managedProperties_.connectionState!==ConnectionStateType.kNotConnected||networks.find((network=>network.guid===this.guid))){this.getNetworkDetails_()}}onNetworkStateChanged(network){if(!this.guid||!this.managedProperties_){return}if(network.guid===this.guid){this.getNetworkDetails_()}}onNetworkStateListChanged(){if(!this.guid||!this.managedProperties_){return}this.checkNetworkExists_()}onDeviceStateListChanged(){if(!this.guid||!this.managedProperties_){return}this.getDeviceState_()}managedPropertiesChanged_(){if(!this.managedProperties_){return}this.updateAutoConnectPref_();this.updateHiddenPref_();if(this.isCellular_(this.managedProperties_)&&this.managedProperties_.typeProperties.cellular.allowTextMessages){this.suppressTextMessagesOverride_=!!OncMojo.getActiveValue(this.managedProperties_.typeProperties.cellular.allowTextMessages)}const metered=this.managedProperties_.metered;if(metered&&metered.activeValue!==this.meteredOverride_){this.meteredOverride_=metered.activeValue}const priority=this.managedProperties_.priority;if(priority){const preferNetwork=priority.activeValue>0;if(preferNetwork!==this.preferNetwork_){this.preferNetwork_=preferNetwork}}const ipv4=OncMojo.getIPConfigForType(this.managedProperties_,IPConfigType.kIPv4);this.ipAddress_=ipv4&&ipv4.ipAddress||"";const networkName=OncMojo.getNetworkNameUnsafe(this.managedProperties_);this.parentNode.pageTitle=networkName;flush();if(!this.didSetFocus_&&!Router.getInstance().getQueryParameters().has("search")&&!this.getDeepLinkSettingId()){this.didSetFocus_=true;const button=this.shadowRoot.querySelector("#titleDiv .action-button:not([hidden])");if(button){afterNextRender(this,(()=>button.focus()))}}if(this.shouldShowConfigureWhenNetworkLoaded_&&this.managedProperties_.type===NetworkType.kTether){this.shouldShowConfigureWhenNetworkLoaded_=false;setTimeout((()=>this.showTetherDialog_()))}}async getDeviceState_(){if(!this.managedProperties_){return}const type=this.managedProperties_.type;const response=await this.networkConfig_.getDeviceStateList();if(!this.guid){return}const{deviceState:deviceState,shouldGetNetworkDetails:shouldGetNetworkDetails}=processDeviceState(type,response.result,this.deviceState_);this.deviceState_=deviceState;if(shouldGetNetworkDetails){this.getNetworkDetails_()}if(this.pendingSimLockDeepLink_){this.pendingSimLockDeepLink_=false;this.deepLinkToSimLockElement_()}}deepLinkToSimLockElement_(){const settingId=Setting.kCellularSimLock;const simLockStatus=this.deviceState_.simLockStatus;afterNextRender(this,(()=>{if(simLockStatus&&!!simLockStatus.lockType){this.afterRenderShowDeepLink_(settingId,(()=>this.shadowRoot.querySelector("network-siminfo").getUnlockButton()));return}this.afterRenderShowDeepLink_(settingId,(()=>this.shadowRoot.querySelector("network-siminfo").getSimLockToggle()))}))}autoConnectPrefChanged_(){if(!this.propertiesReceived_){return}const config=this.getDefaultConfigProperties_();config.autoConnect={value:!!this.autoConnectPref_.value};this.setMojoNetworkProperties_(config)}hiddenPrefChanged_(){if(!this.propertiesReceived_){return}recordSettingChange(Setting.kWifiHidden,{boolValue:!!this.hiddenPref_.value});const config=this.getDefaultConfigProperties_();config.typeConfig.wifi.hiddenSsid=this.hiddenPref_.value?HiddenSsidMode.kEnabled:HiddenSsidMode.kDisabled;this.setMojoNetworkProperties_(config)}getPolicyEnforcement_(policySource){switch(policySource){case PolicySource.kUserPolicyEnforced:case PolicySource.kDevicePolicyEnforced:return chrome.settingsPrivate.Enforcement.ENFORCED;case PolicySource.kUserPolicyRecommended:case PolicySource.kDevicePolicyRecommended:return chrome.settingsPrivate.Enforcement.RECOMMENDED;default:return undefined}}getPolicyController_(policySource){switch(policySource){case PolicySource.kDevicePolicyEnforced:case PolicySource.kDevicePolicyRecommended:return chrome.settingsPrivate.ControlledBy.DEVICE_POLICY;case PolicySource.kUserPolicyEnforced:case PolicySource.kUserPolicyRecommended:return chrome.settingsPrivate.ControlledBy.USER_POLICY;default:return undefined}}updateAutoConnectPref_(){if(!this.managedProperties_){return}const autoConnect=OncMojo.getManagedAutoConnect(this.managedProperties_);if(!autoConnect){return}let enforcement;let controlledBy;if(this.globalPolicy&&this.globalPolicy.allowOnlyPolicyNetworksToAutoconnect){enforcement=chrome.settingsPrivate.Enforcement.ENFORCED;controlledBy=chrome.settingsPrivate.ControlledBy.DEVICE_POLICY}else{enforcement=this.getPolicyEnforcement_(autoConnect.policySource);controlledBy=this.getPolicyController_(autoConnect.policySource)}if(this.autoConnectPref_.value===autoConnect.activeValue&&enforcement===this.autoConnectPref_.enforcement&&controlledBy===this.autoConnectPref_.controlledBy){return}const newPrefValue={key:"fakeAutoConnectPref",value:autoConnect.activeValue,type:chrome.settingsPrivate.PrefType.BOOLEAN};if(enforcement){newPrefValue.enforcement=enforcement;newPrefValue.controlledBy=controlledBy}this.autoConnectPref_=newPrefValue}updateHiddenPref_(){if(!this.managedProperties_){return}if(this.managedProperties_.type!==NetworkType.kWiFi){return}const hidden=this.managedProperties_.typeProperties.wifi.hiddenSsid;if(!hidden){return}const enforcement=this.getPolicyEnforcement_(hidden.policySource);const controlledBy=this.getPolicyController_(hidden.policySource);if(this.hiddenPref_.value===hidden.activeValue&&enforcement===this.hiddenPref_.enforcement&&controlledBy===this.hiddenPref_.controlledBy){return}const newPrefValue={key:"fakeHiddenPref",value:hidden.activeValue,type:chrome.settingsPrivate.PrefType.BOOLEAN};if(enforcement){newPrefValue.enforcement=enforcement;newPrefValue.controlledBy=controlledBy}this.hiddenPref_=newPrefValue}suppressTextMessagesChanged_(e){if(!this.propertiesReceived_||!this.isCellular_(this.managedProperties_)||!this.managedProperties_.typeProperties.cellular.allowTextMessages){return}const config=OncMojo.getDefaultConfigProperties(this.managedProperties_.type);config.typeConfig.cellular={textMessageAllowState:{allowTextMessages:e.detail.value},roaming:null,apn:null};this.networkConfig_.setProperties(this.guid,config).then((response=>{if(!response.success){console.warn("Unable to set properties: "+JSON.stringify(config))}}))}meteredChanged_(e){if(!this.propertiesReceived_){return}const config=this.getDefaultConfigProperties_();config.metered={value:e.detail.value};this.setMojoNetworkProperties_(config)}preferNetworkChanged_(){if(!this.propertiesReceived_){return}const config=this.getDefaultConfigProperties_();config.priority={value:this.preferNetwork_?1:0};this.setMojoNetworkProperties_(config)}async checkNetworkExists_(){const response=await this.networkConfig_.getNetworkState(this.guid);if(response.result){return}this.outOfRange_=true;if(this.managedProperties_){this.managedProperties_.connectionState=ConnectionStateType.kNotConnected}}checkWifiOutOfRange_(networkState){if(!networkState){return}if(networkState.type!==NetworkType.kWiFi){this.outOfRange_=false;return}this.outOfRange_=!networkState.typeState.wifi.hiddenSsid&&!networkState.typeState.wifi.visible}async getNetworkDetails_(){assertExists(this.guid);const networkStateResponse=await this.networkConfig_.getNetworkState(this.guid);this.checkWifiOutOfRange_(networkStateResponse.result);if(this.isSecondaryUser_){this.getStateCallback_(networkStateResponse.result);return}const response=await this.networkConfig_.getManagedProperties(this.guid);this.getPropertiesCallback_(response.result);if(this.isPasspointWifi_(this.managedProperties_)){const response=await this.passpointService_.getPasspointSubscription(this.managedProperties_.typeProperties.wifi.passpointId);this.passpointSubscription_=response.result}}getPropertiesCallback_(properties){if(!this.guid){return}if(!properties){this.close();return}this.updateManagedProperties_(properties);if(this.isArcVpn_(this.managedProperties_)&&!this.isConnectedState_(this.managedProperties_)){this.guid="";this.close()}this.propertiesReceived_=true;if(!this.deviceState_){this.getDeviceState_()}}updateManagedProperties_(properties){this.applyingChanges_=true;if(this.managedProperties_&&this.managedProperties_.type===NetworkType.kCellular&&this.deviceState_&&this.deviceState_.scanning){properties.typeProperties.cellular=this.managedProperties_.typeProperties.cellular}this.managedProperties_=properties;afterNextRender(this,(()=>{this.applyingChanges_=false}))}getStateCallback_(networkState){if(!networkState){this.close();return}const managedProperties=OncMojo.getDefaultManagedProperties(networkState.type,networkState.guid,networkState.name);managedProperties.connectable=networkState.connectable;managedProperties.connectionState=networkState.connectionState;switch(networkState.type){case NetworkType.kCellular:managedProperties.typeProperties.cellular.signalStrength=networkState.typeState.cellular.signalStrength;managedProperties.typeProperties.cellular.simLocked=networkState.typeState.cellular.simLocked;break;case NetworkType.kTether:managedProperties.typeProperties.tether.signalStrength=networkState.typeState.tether.signalStrength;break;case NetworkType.kWiFi:managedProperties.typeProperties.wifi.signalStrength=networkState.typeState.wifi.signalStrength;break}this.updateManagedProperties_(managedProperties);this.propertiesReceived_=true}getNetworkState_(properties){if(!properties){return undefined}return OncMojo.managedPropertiesToNetworkState(properties)}getDefaultConfigProperties_(){return OncMojo.getDefaultConfigProperties(this.managedProperties_.type)}async setMojoNetworkProperties_(config){if(!this.propertiesReceived_||!this.guid||this.applyingChanges_){return}const response=await this.networkConfig_.setProperties(this.guid,config);if(!response.success){console.warn("Unable to set properties: "+JSON.stringify(config));this.getNetworkDetails_()}}getStateText_(managedProperties,propertiesReceived,outOfRange,deviceState){if(!managedProperties||!propertiesReceived){return""}if(this.isOutOfRangeOrNotEnabled_(outOfRange,deviceState)){return managedProperties.type===NetworkType.kTether?this.i18n("tetherPhoneOutOfRange"):this.i18n("networkOutOfRange")}if(OncMojo.connectionStateIsConnected(managedProperties.connectionState)){if(this.isPortalState_(managedProperties.portalState)){if(managedProperties.type===NetworkType.kCellular){return this.i18n("networkListItemCellularSignIn")}return this.i18n("networkListItemSignIn")}if(managedProperties.portalState===PortalState.kNoInternet){return this.i18n("networkListItemConnectedNoConnectivity")}}if(isCarrierLockedActiveSim(managedProperties,deviceState)){return this.i18n("networkMobileProviderLocked")}return this.i18n(OncMojo.getConnectionStateString(managedProperties.connectionState))}getAutoConnectToggleLabel_(managedProperties){return this.isCellular_(managedProperties)?this.i18n("networkAutoConnectCellular"):this.i18n("networkAutoConnect")}isConnectedState_(managedProperties){return!!managedProperties&&OncMojo.connectionStateIsConnected(managedProperties.connectionState)}isRestrictedConnectivity_(managedProperties){return!!managedProperties&&OncMojo.isRestrictedConnectivity(managedProperties.portalState)}showConnectedState_(managedProperties){return this.isConnectedState_(managedProperties)&&!this.isRestrictedConnectivity_(managedProperties)}showRestrictedConnectivity_(managedProperties,deviceState){if(!managedProperties){return false}if(isCarrierLockedActiveSim(managedProperties,deviceState)){return true}return this.isConnectedState_(managedProperties)&&this.isRestrictedConnectivity_(managedProperties)}isRemembered_(managedProperties){return!!managedProperties&&managedProperties.source!==OncSource.kNone}isRememberedOrConnected_(managedProperties){return this.isRemembered_(managedProperties)||this.isConnectedState_(managedProperties)}isCellular_(managedProperties){return!!managedProperties&&managedProperties.type===NetworkType.kCellular}isTether_(managedProperties){return!!managedProperties&&managedProperties.type===NetworkType.kTether}isWiFi_(managedProperties){return!!managedProperties&&managedProperties.type===NetworkType.kWiFi}isWireGuard_(managedProperties){if(!managedProperties){return false}if(managedProperties.type!==NetworkType.kVPN){return false}if(!managedProperties.typeProperties.vpn){return false}return managedProperties.typeProperties.vpn.type===VpnType.kWireGuard}isBlockedByPolicy_(managedProperties,globalPolicy,managedNetworkAvailable){if(!managedProperties||!globalPolicy||this.isPolicySource(managedProperties.source)){return false}if(managedProperties.type===NetworkType.kCellular&&!!globalPolicy.allowOnlyPolicyCellularNetworks){return true}if(managedProperties.type!==NetworkType.kWiFi){return false}const hexSsid=OncMojo.getActiveString(managedProperties.typeProperties.wifi.hexSsid);return!!globalPolicy.allowOnlyPolicyWifiNetworksToConnect||!!globalPolicy.allowOnlyPolicyWifiNetworksToConnectIfAvailable&&!!managedNetworkAvailable||!!hexSsid&&!!globalPolicy.blockedHexSsids&&globalPolicy.blockedHexSsids.includes(hexSsid)}shouldShowApnRow_(){return this.isApnRevampEnabled_&&this.isCellular_(this.managedProperties_)}isApnManaged_(globalPolicy){if(!this.isApnRevampAndAllowApnModificationPolicyEnabled_){return false}if(!globalPolicy){return false}return!globalPolicy.allowApnModification}shouldShowApnList_(){return!this.isApnRevampEnabled_&&this.isCellular_(this.managedProperties_)}shouldShowSuppressTextMessagesToggle_(){if(!this.managedProperties_||!this.deviceState_){return false}const networkState=this.getNetworkState_(this.managedProperties_);if(!networkState){return false}return this.isCellular_(this.managedProperties_)&&isActiveSim(networkState,this.deviceState_)}showConnect_(managedProperties,globalPolicy,managedNetworkAvailable,deviceState){if(!managedProperties){return false}if(this.isBlockedByPolicy_(managedProperties,globalPolicy,managedNetworkAvailable)){return false}if(this.isArcVpn_(managedProperties)){return false}if(managedProperties.connectionState!==ConnectionStateType.kNotConnected){return false}if(deviceState&&deviceState.deviceState!==DeviceStateType.kEnabled){return false}const isEthernet=managedProperties.type===NetworkType.kEthernet;return OncMojo.isNetworkConnectable(managedProperties)&&!isEthernet}showDisconnect_(managedProperties){if(!managedProperties||managedProperties.type===NetworkType.kEthernet){return false}return managedProperties.connectionState!==ConnectionStateType.kNotConnected}showSignin_(managedProperties){if(!managedProperties){return false}if(OncMojo.connectionStateIsConnected(managedProperties.connectionState)&&this.isPortalState_(managedProperties.portalState)){return true}return false}showForget_(managedProperties){if(!managedProperties||this.isSecondaryUser_){return false}const type=managedProperties.type;if(type!==NetworkType.kWiFi&&type!==NetworkType.kVPN){return false}if(this.isArcVpn_(managedProperties)){return false}return!this.isPolicySource(managedProperties.source)&&this.isRemembered_(managedProperties)}showActivate_(managedProperties){if(!managedProperties||this.isSecondaryUser_){return false}if(!this.isCellular_(managedProperties)){return false}if(managedProperties.typeProperties.cellular.eid){return false}const activation=managedProperties.typeProperties.cellular.activationState;return activation===ActivationStateType.kNotActivated||activation===ActivationStateType.kPartiallyActivated}showConfigure_(managedProperties,globalPolicy,managedNetworkAvailable){if(!managedProperties||this.isSecondaryUser_){return false}if(this.isBlockedByPolicy_(managedProperties,globalPolicy,managedNetworkAvailable)){return false}const type=managedProperties.type;if(type===NetworkType.kCellular||type===NetworkType.kTether){return false}if(type===NetworkType.kWiFi&&managedProperties.typeProperties.wifi.security===SecurityType.kNone){return false}if(type===NetworkType.kWiFi&&managedProperties.connectionState!==ConnectionStateType.kNotConnected){return false}if(this.isPasspointWifi_(managedProperties)){return false}if(this.isArcVpn_(managedProperties)&&!this.isConnectedState_(managedProperties)){return false}return true}disableSignin_(managedProperties){if(this.disabled_||!managedProperties){return true}if(!OncMojo.connectionStateIsConnected(managedProperties.connectionState)){return true}return!this.isPortalState_(managedProperties.portalState)}disableForget_(managedProperties,vpnConfigAllowed){if(this.disabled_||!managedProperties){return true}return managedProperties.type===NetworkType.kVPN&&vpnConfigAllowed&&!vpnConfigAllowed.value}disableConfigure_(managedProperties,vpnConfigAllowed){if(this.disabled_||!managedProperties){return true}if(managedProperties.type===NetworkType.kVPN&&vpnConfigAllowed&&!vpnConfigAllowed.value){return true}return this.isPolicySource(managedProperties.source)&&!this.hasRecommendedFields_(managedProperties)}hasRecommendedFields_(managedProperties){if(!managedProperties){return false}for(const value of Object.values(managedProperties)){if(typeof value!=="object"||value===null){continue}if("activeValue"in value){if(this.isNetworkPolicyRecommended(value)){return true}}else if(this.hasRecommendedFields_(value)){return true}}return false}showViewAccount_(managedProperties){if(!managedProperties||this.isSecondaryUser_){return false}if(!this.isCellular_(managedProperties)||this.showActivate_(managedProperties)){return false}if(managedProperties.typeProperties.cellular.eid){return false}const paymentPortal=managedProperties.typeProperties.cellular.paymentPortal;if(!paymentPortal||!paymentPortal.url){return false}if(!this.isConnectedState_(managedProperties)){const technology=managedProperties.typeProperties.cellular.networkTechnology;if(technology!=="LTE"&&technology!=="LTEAdvanced"){return false}if(!managedProperties.typeProperties.cellular.mdn){return false}}return true}enableConnect_(managedProperties,defaultNetwork,propertiesReceived,outOfRange,globalPolicy,managedNetworkAvailable,deviceState){if(!this.showConnect_(managedProperties,globalPolicy,managedNetworkAvailable,deviceState)){return false}if(!propertiesReceived||outOfRange){return false}assertExists(managedProperties);if(managedProperties.type===NetworkType.kVPN&&!defaultNetwork){return false}if(managedProperties.type===NetworkType.kCellular&&managedProperties.typeProperties.cellular.simLocked){return false}return true}updateAlwaysOnVpnPrefValue_(){this.alwaysOnVpn_.value=this.prefs.arc&&this.prefs.arc.vpn&&this.prefs.arc.vpn.always_on&&this.prefs.arc.vpn.always_on.lockdown&&this.prefs.arc.vpn.always_on.lockdown.value}getFakeVpnConfigPrefForEnforcement_(){const fakeAlwaysOnVpnEnforcementPref={key:"fakeAlwaysOnPref",type:chrome.settingsPrivate.PrefType.BOOLEAN,value:false};if(this.managedProperties_&&this.managedProperties_.type===NetworkType.kVPN&&this.prefs&&this.prefs.vpn_config_allowed&&!this.prefs.vpn_config_allowed.value){fakeAlwaysOnVpnEnforcementPref.enforcement=chrome.settingsPrivate.Enforcement.ENFORCED;fakeAlwaysOnVpnEnforcementPref.controlledBy=this.prefs.vpn_config_allowed.controlledBy}return fakeAlwaysOnVpnEnforcementPref}updateAlwaysOnVpnPrefEnforcement_(){const prefForEnforcement=this.getFakeVpnConfigPrefForEnforcement_();this.alwaysOnVpn_.enforcement=prefForEnforcement.enforcement;this.alwaysOnVpn_.controlledBy=prefForEnforcement.controlledBy}getTetherDialog_(){return castExists(this.shadowRoot.querySelector("#tetherDialog"))}getPasspointRemovalDialog_(){return castExists(this.shadowRoot.querySelector("#passpointRemovalDialog"))}handleConnectClick_(){assertExists(this.managedProperties_);if(this.managedProperties_.type===NetworkType.kTether&&!this.managedProperties_.typeProperties.tether.hasConnectedToHost){this.showTetherDialog_();return}this.fireNetworkConnect_(false)}onTetherConnect_(){this.getTetherDialog_().close();this.fireNetworkConnect_(true)}fireNetworkConnect_(bypassDialog){assertExists(this.managedProperties_);const networkState=OncMojo.managedPropertiesToNetworkState(this.managedProperties_);const networkConnectEvent=new CustomEvent("network-connect",{bubbles:true,composed:true,detail:{networkState:networkState,bypassConnectionDialog:bypassDialog}});this.dispatchEvent(networkConnectEvent)}async handleDisconnectClick_(){const response=await this.networkConfig_.startDisconnect(this.guid);if(response.success){recordSettingChange(Setting.kDisconnectWifiNetwork)}else{console.warn("Disconnect failed for: "+this.guid)}}onConnectDisconnectClick_(){if(this.enableConnect_(this.managedProperties_,this.defaultNetwork,this.propertiesReceived_,this.outOfRange_,this.globalPolicy,this.managedNetworkAvailable,this.deviceState_)){this.handleConnectClick_();return}if(this.showDisconnect_(this.managedProperties_)){this.handleDisconnectClick_();return}}shouldConnectDisconnectButtonBeHidden_(){return!this.showConnect_(this.managedProperties_,this.globalPolicy,this.managedNetworkAvailable,this.deviceState_)&&!this.showDisconnect_(this.managedProperties_)}shouldConnectDisconnectButtonBeDisabled_(){if(this.disabled_){return true}if(this.enableConnect_(this.managedProperties_,this.defaultNetwork,this.propertiesReceived_,this.outOfRange_,this.globalPolicy,this.managedNetworkAvailable,this.deviceState_)){return false}if(this.showDisconnect_(this.managedProperties_)){return false}return true}getConnectDisconnectButtonLabel_(){if(this.showConnect_(this.managedProperties_,this.globalPolicy,this.managedNetworkAvailable,this.deviceState_)){return this.i18n("networkButtonConnect")}if(this.showDisconnect_(this.managedProperties_)){return this.i18n("networkButtonDisconnect")}return""}async onForgetClick_(){if(this.isPasspointWifi_(this.managedProperties_)){this.getPasspointRemovalDialog_().open();return}return this.forgetNetwork_()}async forgetNetwork_(){if(this.managedProperties_.type===NetworkType.kWiFi){recordSettingChange(Setting.kForgetWifiNetwork)}const response=await this.networkConfig_.forgetNetwork(this.guid);if(!response.success){console.warn("Forget network failed for: "+this.guid)}this.close()}onSigninClick_(){this.browserProxy_.showPortalSignin(this.guid)}onActivateClick_(){this.browserProxy_.showCellularSetupUi(this.guid)}onConfigureClick_(){if(this.managedProperties_&&(this.isThirdPartyVpn_(this.managedProperties_)||this.isArcVpn_(this.managedProperties_))){this.browserProxy_.configureThirdPartyVpn(this.guid);return}assertExists(this.managedProperties_);const showConfigEvent=new CustomEvent("show-config",{bubbles:true,composed:true,detail:{guid:this.guid,type:OncMojo.getNetworkTypeString(this.managedProperties_.type),name:OncMojo.getNetworkNameUnsafe(this.managedProperties_)}});this.dispatchEvent(showConfigEvent)}onViewAccountClick_(){this.browserProxy_.showCarrierAccountDetail(this.guid)}showTetherDialog_(){this.getTetherDialog_().open()}showHiddenNetworkWarning_(){return loadTimeData.getBoolean("showHiddenNetworkWarning")&&!!this.autoConnectPref_.value&&!!this.managedProperties_&&this.managedProperties_.type===NetworkType.kWiFi&&!!OncMojo.getActiveValue(this.managedProperties_.typeProperties.wifi.hiddenSsid)}onNetworkPropertyChange_(e){if(!this.propertiesReceived_){return}const field=e.detail.field;const value=e.detail.value;const config=this.getDefaultConfigProperties_();const valueType=typeof value;if(valueType!=="string"&&valueType!=="number"&&valueType!=="boolean"&&!Array.isArray(value)){console.warn("Unexpected property change event, Key: "+field+" Value: "+JSON.stringify(value));return}OncMojo.setConfigProperty(config,field,value);const vpnConfig=config.typeConfig.vpn;if(vpnConfig){if(vpnConfig.openVpn&&vpnConfig.openVpn.saveCredentials===undefined){vpnConfig.openVpn.saveCredentials=false}if(vpnConfig.l2tp&&vpnConfig.l2tp.saveCredentials===undefined){vpnConfig.l2tp.saveCredentials=false}}this.setMojoNetworkProperties_(config)}onApnChange_(event){if(!this.propertiesReceived_){return}const config=this.getDefaultConfigProperties_();const apn=event.detail;config.typeConfig.cellular={apn:apn,roaming:null,textMessageAllowState:null};this.setMojoNetworkProperties_(config)}getApnRowSubLabel_(){if(!this.isCellular_(this.managedProperties_)||!this.managedProperties_.typeProperties.cellular.connectedApn){return""}return getApnDisplayName(this.i18n.bind(this),this.managedProperties_.typeProperties.cellular.connectedApn)}onApnRowClicked_(){if(this.disabled_){return}if(!this.isCellular_(this.managedProperties_)){console.error("APN row should only be visible when cellular is available.");return}const params=new URLSearchParams;params.append("guid",this.guid);Router.getInstance().navigateTo(routes.APN,params)}onIpConfigChange_(event){if(!this.managedProperties_){return}const config=OncMojo.getUpdatedIPConfigProperties(this.managedProperties_,event.detail.field,event.detail.value);if(config){this.setMojoNetworkProperties_(config)}}onProxyChange_(event){if(!this.propertiesReceived_){return}const config=this.getDefaultConfigProperties_();config.proxySettings=event.detail;this.setMojoNetworkProperties_(config)}propertiesMissingOrBlockedByPolicy_(){return!this.managedProperties_||this.isBlockedByPolicy_(this.managedProperties_,this.globalPolicy,this.managedNetworkAvailable)}sharedString_(managedProperties){if(!managedProperties.typeProperties.wifi){return this.i18n("networkShared")}else if(managedProperties.typeProperties.wifi.isConfiguredByActiveUser){return this.i18n("networkSharedOwner")}else{return this.i18n("networkSharedNotOwner")}}syncedString_(managedProperties){if(!managedProperties.typeProperties.wifi){return""}else if(!managedProperties.typeProperties.wifi.isSyncable){return this.i18nAdvanced("networkNotSynced").toString()}else if(managedProperties.source===OncSource.kUser){return this.i18nAdvanced("networkSyncedUser").toString()}else{return this.i18nAdvanced("networkSyncedDevice").toString()}}messagesDividerClass_(name,managedProperties,globalPolicy,managedNetworkAvailable,isSecondaryUser,isWifiSyncEnabled,deviceState){let first="";if(this.isBlockedByPolicy_(managedProperties,globalPolicy,managedNetworkAvailable)){first="policy"}else if(isSecondaryUser){first="secondary"}else if(this.showShared_(managedProperties,globalPolicy,managedNetworkAvailable,deviceState)){first="shared"}else if(this.showSynced_(managedProperties,globalPolicy,managedNetworkAvailable,isWifiSyncEnabled)){first="synced"}else if(isCarrierLockedActiveSim(managedProperties,deviceState)){first="carrierlocked"}return first===name?"continuation":""}showSynced_(managedProperties,_globalPolicy,_managedNetworkAvailable,isWifiSyncEnabled){return!this.propertiesMissingOrBlockedByPolicy_()&&isWifiSyncEnabled&&!!managedProperties.typeProperties.wifi}showShared_(managedProperties,_globalPolicy,_managedNetworkAvailable,deviceState){if(isCarrierLockedActiveSim(managedProperties,deviceState)){return false}return!this.propertiesMissingOrBlockedByPolicy_()&&(managedProperties.source===OncSource.kDevice||managedProperties.source===OncSource.kDevicePolicy)}isCarrierLockedActiveSim_(managedProperties,deviceState){return isCarrierLockedActiveSim(managedProperties,deviceState)}showAutoConnect_(managedProperties,globalPolicy,managedNetworkAvailable){return!!managedProperties&&managedProperties.type!==NetworkType.kEthernet&&this.isRemembered_(managedProperties)&&!this.isArcVpn_(managedProperties)&&!this.isBlockedByPolicy_(managedProperties,globalPolicy,managedNetworkAvailable)}showHiddenNetworkToggle_(){if(!this.showHiddenToggle_){return false}if(!this.managedProperties_){return false}if(this.managedProperties_.type!==NetworkType.kWiFi){return false}if(!this.isRemembered_(this.managedProperties_)){return false}if(this.isBlockedByPolicy_(this.managedProperties_,this.globalPolicy,this.managedNetworkAvailable)){return false}return true}showMetered_(){const managedProperties=this.managedProperties_;return!!managedProperties&&this.isRemembered_(managedProperties)&&(managedProperties.type===NetworkType.kCellular||managedProperties.type===NetworkType.kWiFi)}showAlwaysOnVpn_(managedProperties){return this.isArcVpn_(managedProperties)&&this.prefs.arc&&this.prefs.arc.vpn&&this.prefs.arc.vpn.always_on&&this.prefs.arc.vpn.always_on.vpn_package&&OncMojo.getActiveValue(managedProperties.typeProperties.vpn.host)===this.prefs.arc.vpn.always_on.vpn_package.value}alwaysOnVpnChanged_(){if(this.prefs&&this.prefs.arc&&this.prefs.arc.vpn&&this.prefs.arc.vpn.always_on&&this.prefs.arc.vpn.always_on.lockdown){this.set("prefs.arc.vpn.always_on.lockdown.value",this.alwaysOnVpn_.value)}}showPreferNetwork_(managedProperties,globalPolicy,managedNetworkAvailable){if(!managedProperties){return false}const type=managedProperties.type;if(type===NetworkType.kEthernet||type===NetworkType.kCellular||this.isArcVpn_(managedProperties)){return false}return this.isRemembered_(managedProperties)&&!this.isBlockedByPolicy_(managedProperties,globalPolicy,managedNetworkAvailable)}shouldPreferNetworkToggleBeDisabled_(){return this.disabled_||this.isNetworkPolicyEnforced(this.managedProperties_.priority)}onPreferNetworkRowClicked_(event){event.stopPropagation();const preferNetworkToggle=this.shadowRoot.querySelector("#preferNetworkToggle");if(!preferNetworkToggle||preferNetworkToggle.disabled){return}this.preferNetwork_=!this.preferNetwork_}hasVisibleFields_(fields){for(let i=0;i<fields.length;++i){const key=OncMojo.getManagedPropertyKey(fields[i]);const value=this.get(key,this.managedProperties_);if(value!==undefined&&value!==null&&value!==""){return true}}return false}hasInfoFields_(){const editFieldTypes=this.getInfoEditFieldTypes_();const infoFields=this.getInfoFields_();return Object.keys(editFieldTypes).length>0||this.hasVisibleFields_(infoFields)}getInfoFields_(){if(!this.managedProperties_){return[]}const fields=[];switch(this.managedProperties_.type){case NetworkType.kCellular:fields.push("cellular.servingOperator.name");break;case NetworkType.kTether:fields.push("tether.batteryPercentage","tether.signalStrength","tether.carrier");break;case NetworkType.kVPN:const vpnType=this.managedProperties_.typeProperties.vpn.type;switch(vpnType){case VpnType.kExtension:fields.push("vpn.providerName");break;case VpnType.kArc:fields.push("vpn.type");fields.push("vpn.providerName");break;case VpnType.kOpenVPN:fields.push("vpn.type","vpn.host","vpn.openVpn.username","vpn.openVpn.extraHosts");break;case VpnType.kL2TPIPsec:fields.push("vpn.type","vpn.host","vpn.l2tp.username");break}break;case NetworkType.kWiFi:break}if(OncMojo.isRestrictedConnectivity(this.managedProperties_.portalState)){fields.push("portalState")}return fields}getInfoEditFieldTypes_(){if(!this.managedProperties_){return{}}const editFields={};const type=this.managedProperties_.type;if(type===NetworkType.kVPN){const vpnType=this.managedProperties_.typeProperties.vpn.type;if(vpnType!==VpnType.kExtension){editFields["vpn.host"]="String"}if(vpnType===VpnType.kOpenVPN){editFields["vpn.openVpn.username"]="String";editFields["vpn.openVpn.extraHosts"]="StringArray"}}return editFields}getAdvancedFields_(){if(!this.managedProperties_){return[]}const fields=[];const type=this.managedProperties_.type;switch(type){case NetworkType.kCellular:fields.push("cellular.activationState","cellular.networkTechnology");break;case NetworkType.kWiFi:fields.push("wifi.ssid","wifi.bssid","wifi.signalStrength","wifi.security","wifi.eap.outer","wifi.eap.inner","wifi.eap.domainSuffixMatch","wifi.eap.subjectAltNameMatch","wifi.eap.subjectMatch","wifi.eap.identity","wifi.eap.anonymousIdentity","wifi.frequency");break;case NetworkType.kVPN:const vpnType=this.managedProperties_.typeProperties.vpn.type;switch(vpnType){case VpnType.kOpenVPN:if(this.isManagedByPolicy_()){fields.push("vpn.openVpn.auth","vpn.openVpn.cipher","vpn.openVpn.compressionAlgorithm","vpn.openVpn.tlsAuthContents","vpn.openVpn.keyDirection")}break}break}return fields}getDeviceFields_(){if(!this.managedProperties_||this.managedProperties_.type!==NetworkType.kCellular){return[]}const fields=[];const networkState=OncMojo.managedPropertiesToNetworkState(this.managedProperties_);if(isActiveSim(networkState,this.deviceState_)){fields.push("cellular.homeProvider.name","cellular.homeProvider.country")}fields.push("cellular.firmwareRevision","cellular.hardwareRevision","cellular.esn","cellular.iccid","cellular.imei","cellular.meid","cellular.min");return fields}async computeTrafficCountersAvailable_(){const networks=await this.trafficCountersAdapter_.requestTrafficCountersForActiveNetworks();this.trafficCountersAvailable_=networks.some((n=>n.guid===this.guid))}showDataUsage_(managedProperties,trafficCountersAvailable){if(!this.isTrafficCountersEnabled_){return false}if(!managedProperties||this.guid===""){return false}if(!this.isCellular_(managedProperties)&&!(this.isWiFi_(managedProperties)&&this.isTrafficCountersForWifiTestingEnabled_)){return false}if(!this.isConnectedState_(managedProperties)){return false}return trafficCountersAvailable}hasAdvancedSection_(){if(!this.managedProperties_||!this.propertiesReceived_){return false}if(this.showMetered_()){return true}if(this.managedProperties_.type===NetworkType.kTether){return false}return this.hasAdvancedFields_()||this.hasDeviceFields_()}hasAdvancedFields_(){return this.hasVisibleFields_(this.getAdvancedFields_())}hasDeviceFields_(){return this.hasVisibleFields_(this.getDeviceFields_())}hasNetworkSection_(managedProperties,globalPolicy,managedNetworkAvailable){if(!managedProperties||managedProperties.type===NetworkType.kTether){return false}if(this.isBlockedByPolicy_(managedProperties,globalPolicy,managedNetworkAvailable)){return false}if(managedProperties.type===NetworkType.kCellular){return true}return this.isRememberedOrConnected_(managedProperties)}hasProxySection_(managedProperties,globalPolicy,managedNetworkAvailable){if(!managedProperties||managedProperties.type===NetworkType.kTether){return false}if(this.isBlockedByPolicy_(managedProperties,globalPolicy,managedNetworkAvailable)){return false}return this.isRememberedOrConnected_(managedProperties)}isPasspointWifi_(managedProperties){return!!managedProperties&&managedProperties.type===NetworkType.kWiFi&&managedProperties.typeProperties.wifi.passpointId!==""&&managedProperties.typeProperties.wifi.passpointMatchType!==MatchType.kNoMatch}shouldShowPasspointProviderRow_(managedProperties){return this.isPasspointWifi_(managedProperties)}getPasspointSubscriptionName_(subscription){if(!subscription){return""}if(subscription.friendlyName&&subscription.friendlyName!==""){return subscription.friendlyName}return subscription.domains[0]}onPasspointRowClicked_(){const showPasspointEvent=new CustomEvent("show-passpoint-detail",{bubbles:true,composed:true,detail:this.passpointSubscription_});this.dispatchEvent(showPasspointEvent)}onPasspointRemovalDialogConfirm_(){this.getPasspointRemovalDialog_().close();this.onPasspointRowClicked_()}showCellularChooseNetwork_(managedProperties){return!!managedProperties&&managedProperties.type===NetworkType.kCellular&&managedProperties.typeProperties.cellular.supportNetworkScan}showScanningSpinner_(){if(!this.managedProperties_||this.managedProperties_.type!==NetworkType.kCellular){return false}return!!this.deviceState_&&this.deviceState_.scanning}showCellularSimUpdatedUi_(managedProperties){return!!managedProperties&&managedProperties.type===NetworkType.kCellular&&managedProperties.typeProperties.cellular.family!=="CDMA"}isArcVpn_(managedProperties){return!!managedProperties&&managedProperties.type===NetworkType.kVPN&&managedProperties.typeProperties.vpn.type===VpnType.kArc}isThirdPartyVpn_(managedProperties){return!!managedProperties&&managedProperties.type===NetworkType.kVPN&&managedProperties.typeProperties.vpn.type===VpnType.kExtension}showIpAddress_(ipAddress,managedProperties){if(this.isArcVpn_(managedProperties)){return false}if(this.isCellular_(managedProperties)){return false}return!!ipAddress&&this.isConnectedState_(managedProperties)}isOutOfRangeOrNotEnabled_(outOfRange,deviceState){return outOfRange||!!deviceState&&deviceState.deviceState!==DeviceStateType.kEnabled}computeShowConfigurableSections_(){if(!this.managedProperties_||!this.deviceState_){return true}const networkState=OncMojo.managedPropertiesToNetworkState(this.managedProperties_);assertExists(networkState);if(networkState.type!==NetworkType.kCellular){return true}return isActiveSim(networkState,this.deviceState_)}computeDisabled_(){return shouldDisallowNetworkModifications(this.deviceState_,this.managedProperties_)}shouldShowMacAddress_(){return!!this.getMacAddress_()}getMacAddress_(){if(!this.deviceState_){return""}const MISSING_MAC_ADDRESS="00:00:00:00:00:00";if(this.deviceState_&&this.deviceState_.macAddress&&this.deviceState_.macAddress!==MISSING_MAC_ADDRESS){return this.deviceState_.macAddress}return""}isManagedByPolicy_(){return this.managedProperties_.source===OncSource.kUserPolicy||this.managedProperties_.source===OncSource.kDevicePolicy}isPortalState_(portalState){return portalState===PortalState.kPortal||portalState===PortalState.kPortalSuspected}}customElements.define(SettingsInternetDetailPageElement.is,SettingsInternetDetailPageElement);function getTemplate$2f(){return html`<!--_html_template_start_--><style include="internet-shared iron-flex">cr-policy-indicator{margin-inline-start:var(--cr-controlled-by-spacing)}</style>

<div class="settings-box first">
  <div class="settings-box-text">$i18n{knownNetworksMessage}</div>
</div>

<h2 class="settings-box">$i18n{knownNetworksPreferred}</h2>
<div class="list-frame vertical-list"
    hidden$="[[havePreferred_(networkStateList_)]]">
  <div class="list-item settings-box-text">
    $i18n{internetNoNetworks}
  </div>
</div>
<div id="preferredNetworkList" class="list-frame vertical-list"
    hidden$="[[!havePreferred_(networkStateList_)]]">
  <template is="dom-repeat" items="[[networkStateList_]]"
      filter="networkIsPreferred_">
    <div class="list-item">
      <cr-link-row embedded label="[[getNetworkDisplayName_(item)]]"
          on-click="fireShowDetails_"
          role-description="$i18n{subpageArrowRoleDescription}"
          deep-link-focus-id$="[[Setting.kForgetWifiNetwork]]">
        <template is="dom-if" if="[[isPolicySource(item.source))]]">
          <cr-policy-indicator on-click="doNothing_"
              indicator-type="[[getIndicatorTypeForSource(item.source)]]"
              icon-aria-label="[[getEnterpriseIconAriaLabel_(item)]]">
          </cr-policy-indicator>
        </template>
      </cr-link-row>
      <div class="separator"></div>
      <cr-icon-button class="icon-more-vert" tabindex$="[[tabindex]]"
          on-click="onMenuButtonClick_" title="[[getMenuButtonTitle_(item)]]">
      </cr-icon-button>
    </div>
  </template>
</div>

<h2 class="settings-box">$i18n{knownNetworksAll}</h2>
<div id="notPreferredNetworkList" class="list-frame vertical-list"
    hidden$="[[!haveNotPreferred_(networkStateList_)]]">
  <template is="dom-repeat" items="[[networkStateList_]]"
      filter="networkIsNotPreferred_">
    <div class="list-item">
      <cr-link-row embedded label="[[getNetworkDisplayName_(item)]]"
          on-click="fireShowDetails_"
          role-description="$i18n{subpageArrowRoleDescription}"
          deep-link-focus-id$="[[Setting.kPreferWifiNetwork]]
              [[Setting.kForgetWifiNetwork]]">
        <template is="dom-if" if="[[isPolicySource(item.source))]]">
          <cr-policy-indicator on-click="doNothing_"
              indicator-type="[[getIndicatorTypeForSource(item.source)]]"
              icon-aria-label="[[getEnterpriseIconAriaLabel_(item)]]">
          </cr-policy-indicator>
        </template>
      </cr-link-row>
      <div class="separator"></div>
      <cr-icon-button class="icon-more-vert" tabindex$="[[tabindex]]"
          on-click="onMenuButtonClick_" title="[[getMenuButtonTitle_(item)]]">
      </cr-icon-button>
    </div>
  </template>
</div>

<template is="dom-if"
    if="[[shouldShowPasspointSection_(passpointSubscriptionsList_)]]">
  <h2 class="settings-box">$i18n{passpointSectionLabel}</h2>
  <div id="passpointSubscriptionList" class="list-frame vertical-list">
    <template is="dom-repeat" items="[[passpointSubscriptionsList_]]">
      <div class="list-item">
        <cr-link-row id="subscriptionItem" embedded
            label="[[getSubscriptionDisplayName_(item)]]"
            on-click="onSubscriptionListItemClick_"
            role-description="$i18n{subpageArrowRoleDescription}">
        </cr-link-row>
        <div class="separator"></div>
        <cr-icon-button id="subscriptionMoreButton" class="icon-more-vert"
            tabindex$="[[tabindex]]" on-click="onSubscriptionMenuButtonClick_"
            title="[[getSubscriptionMenuButtonTitle_(item)]]">
        </cr-icon-button>
      </div>
    </template>
  </div>
</template>

<cr-action-menu id="dotsMenu" role-description="$i18n{menu}">
  <button class="dropdown-item" hidden="[[!showAddPreferred_]]"
      on-click="onAddPreferredClick_">
    $i18n{knownNetworksMenuAddPreferred}
  </button>
  <button class="dropdown-item"
      hidden="[[!showRemovePreferred_]]" on-click="onRemovePreferredClick_">
    $i18n{knownNetworksMenuRemovePreferred}
  </button>
  <button class="dropdown-item" disabled="[[!enableForget_]]"
      on-click="onForgetClick_">
    $i18n{knownNetworksMenuForget}
  </button>
</cr-action-menu>

<cr-action-menu id="subscriptionDotsMenu" role-description="$i18n{menu}">
  <button id="subscriptionForget" class="dropdown-item"
      on-click="onSubscriptionForgetClick_">
    $i18n{knownNetworksMenuForget}
  </button>
</cr-action-menu>
<!--_html_template_end_-->`}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PasspointListenerMixin=dedupingMixin((superClass=>{class PasspointListenerMixin extends superClass{constructor(...args){super(...args);this.listener_=null}connectedCallback(){super.connectedCallback();this.listener_=new PasspointEventsListenerReceiver(this);MojoConnectivityProvider.getInstance().getPasspointService().registerPasspointListener(this.listener_.$.bindNewPipeAndPassRemote())}disconnectedCallback(){super.disconnectedCallback();if(this.listener_){this.listener_.$.close()}}onPasspointSubscriptionAdded(_){}onPasspointSubscriptionRemoved(_){}}return PasspointListenerMixin}));
// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsInternetKnownNetworksPageElementBase=mixinBehaviors([NetworkListenerBehavior,CrPolicyNetworkBehaviorMojo],PasspointListenerMixin(DeepLinkingMixin(RouteObserverMixin(I18nMixin(PolymerElement)))));class SettingsInternetKnownNetworksPageElement extends SettingsInternetKnownNetworksPageElementBase{static get is(){return"settings-internet-known-networks-subpage"}static get template(){return getTemplate$2f()}static get properties(){return{networkType:{type:Number,observer:"networkTypeChanged_"},networkStateList_:{type:Array,value(){return[]}},passpointSubscriptionsList_:{type:Array,notify:true,value(){return[]}},showAddPreferred_:Boolean,showRemovePreferred_:Boolean,enableForget_:Boolean,pendingSettingId_:{type:Number,value:null}}}constructor(){super();this.supportedSettingIds=new Set([Setting.kPreferWifiNetwork,Setting.kForgetWifiNetwork]);this.selectedGuid_="";this.selectedSubscriptionId_="";this.networkConfig_=MojoInterfaceProviderImpl.getInstance().getMojoServiceRemote();this.passpointService_=MojoConnectivityProvider.getInstance().getPasspointService()}currentRouteChanged(route){if(route!==routes.KNOWN_NETWORKS){return}this.attemptDeepLink().then((result=>{if(!result.deepLinkShown&&result.pendingSettingId){this.pendingSettingId_=result.pendingSettingId}}));this.refreshSubscriptions_()}onNetworkStateListChanged(){this.refreshNetworks_()}onNetworkStateChanged(network){if(!network||network.type===NetworkType.kWiFi&&(!network.typeState.wifi?.signalStrength||network.typeState.wifi?.signalStrength===1)){this.refreshNetworks_()}}networkTypeChanged_(){this.refreshNetworks_()}async refreshNetworks_(){if(this.networkType===undefined){return}const filter={filter:FilterType.kConfigured,limit:NO_LIMIT,networkType:this.networkType};const response=await this.networkConfig_.getNetworkStateList(filter);this.networkStateList_=response.result;if(!this.pendingSettingId_){return}const result=await this.showDeepLink(this.pendingSettingId_);if(result.deepLinkShown){this.pendingSettingId_=null}}async refreshSubscriptions_(){if(this.networkType!==NetworkType.kWiFi){this.passpointSubscriptionsList_=[];return}const response=await this.passpointService_.listPasspointSubscriptions();this.passpointSubscriptionsList_=response.result}networkIsPreferred_(networkState){return networkState.priority>0}networkIsNotPreferred_(networkState){return networkState.priority===0}havePreferred_(){return this.networkStateList_.find((state=>this.networkIsPreferred_(state)))!==undefined}haveNotPreferred_(){return this.networkStateList_.find((state=>this.networkIsNotPreferred_(state)))!==undefined}getNetworkDisplayName_(networkState){return OncMojo.getNetworkStateDisplayNameUnsafe(networkState)}shouldShowPasspointSection_(subscriptionsList){return this.networkType===NetworkType.kWiFi&&subscriptionsList.length>0}getSubscriptionDisplayName_(subscription){if(subscription.friendlyName&&subscription.friendlyName!==""){return subscription.friendlyName}return subscription.domains[0]}getEnterpriseIconAriaLabel_(networkState){return loadTimeData.getStringF("networkA11yManagedByAdministrator",this.getNetworkDisplayName_(networkState))}async onMenuButtonClick_(event){const button=event.target;const networkState=event.model.item;this.selectedGuid_=networkState.guid;const response=await this.networkConfig_.getManagedProperties(this.selectedGuid_);const properties=response.result;if(!properties){console.warn("Properties not found for: "+this.selectedGuid_);return}if(properties.priority&&this.isNetworkPolicyEnforced(properties.priority)){this.showAddPreferred_=false;this.showRemovePreferred_=false}else{const preferred=this.networkIsPreferred_(networkState);this.showAddPreferred_=!preferred;this.showRemovePreferred_=preferred}this.enableForget_=!this.isPolicySource(networkState.source);this.$.dotsMenu.showAt(button);event.stopPropagation()}getMenuButtonTitle_(networkState){return loadTimeData.getStringF("knownNetworksMenuButtonTitle",this.getNetworkDisplayName_(networkState))}async setProperties_(config){const response=await this.networkConfig_.setProperties(this.selectedGuid_,config);if(response.success){recordSettingChange(Setting.kPreferWifiNetwork,{boolValue:config.priority?.value===1})}else{console.warn("Unable to set properties for: "+this.selectedGuid_+": "+JSON.stringify(config))}}onRemovePreferredClick_(){assertExists(this.networkType);const config=OncMojo.getDefaultConfigProperties(this.networkType);config.priority={value:0};this.setProperties_(config);this.$.dotsMenu.close()}onAddPreferredClick_(){assertExists(this.networkType);const config=OncMojo.getDefaultConfigProperties(this.networkType);config.priority={value:1};this.setProperties_(config);this.$.dotsMenu.close()}async onForgetClick_(){this.$.dotsMenu.close();const response=await this.networkConfig_.forgetNetwork(this.selectedGuid_);if(!response.success){console.warn("Forget network failed for: "+this.selectedGuid_);return}if(this.networkType===NetworkType.kWiFi){recordSettingChange(Setting.kForgetWifiNetwork)}}fireShowDetails_(event){const networkState=event.model.item;const showDetailEvent=new CustomEvent("show-detail",{bubbles:true,composed:true,detail:networkState});this.dispatchEvent(showDetailEvent);event.stopPropagation()}onSubscriptionListItemClick_(event){const showPasspointEvent=new CustomEvent("show-passpoint-detail",{bubbles:true,composed:true,detail:event.model.item});this.dispatchEvent(showPasspointEvent);event.stopPropagation()}doNothing_(event){event.stopPropagation()}onSubscriptionMenuButtonClick_(event){const button=event.target;this.selectedSubscriptionId_=event.model.item.id;this.$.subscriptionDotsMenu.showAt(button);event.stopPropagation()}getSubscriptionMenuButtonTitle_(subscription){return this.i18n("knownNetworksMenuButtonTitle",this.getSubscriptionDisplayName_(subscription))}async onSubscriptionForgetClick_(){this.$.subscriptionDotsMenu.close();const response=await this.passpointService_.deletePasspointSubscription(this.selectedSubscriptionId_);if(!response.success){console.warn("Forget subscription failed for: "+this.selectedSubscriptionId_)}this.selectedSubscriptionId_=""}onPasspointSubscriptionAdded(subscription){this.push("passpointSubscriptionsList_",subscription)}onPasspointSubscriptionRemoved(subscription){const list=this.passpointSubscriptionsList_.filter((sub=>sub.id!==subscription.id));this.passpointSubscriptionsList_=list}}customElements.define(SettingsInternetKnownNetworksPageElement.is,SettingsInternetKnownNetworksPageElement);
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
let hideInk=false;document.addEventListener("pointerdown",(function(){hideInk=true}),true);document.addEventListener("keydown",(function(){hideInk=false}),true);const focusWithoutInk=function(toFocus){if(!("noink"in toFocus)||!hideInk){toFocus.focus();return}assert$1(document===toFocus.ownerDocument);const{noink:noink}=toFocus;toFocus.noink=true;toFocus.focus();toFocus.noink=noink};
// Copyright 2011 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class EventTracker{constructor(){this.listeners_=[]}add(target,eventType,listener,capture=false){const h={target:target,eventType:eventType,listener:listener,capture:capture};this.listeners_.push(h);target.addEventListener(eventType,listener,capture)}remove(target,eventType){this.listeners_=this.listeners_.filter((listener=>{if(listener.target===target&&(!eventType||listener.eventType===eventType)){EventTracker.removeEventListener(listener);return false}return true}))}removeAll(){this.listeners_.forEach((listener=>EventTracker.removeEventListener(listener)));this.listeners_=[]}static removeEventListener(entry){entry.target.removeEventListener(entry.eventType,entry.listener,entry.capture)}}
// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function isRTL(){return document.documentElement.dir==="rtl"}function hasKeyModifiers(e){return!!(e.altKey||e.ctrlKey||e.metaKey||e.shiftKey)}
// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class FocusRow{constructor(root,boundary,delegate){this.root=root;this.boundary_=boundary||document.documentElement;this.delegate=delegate;this.eventTracker=new EventTracker}static isFocusable(element){if(!element||element.disabled){return false}let current=element;while(true){assertInstanceof(current,Element);const style=window.getComputedStyle(current);if(style.visibility==="hidden"||style.display==="none"){return false}const parent=current.parentNode;if(!parent){return false}if(parent===current.ownerDocument||parent instanceof DocumentFragment){return true}current=parent}}static getFocusableElement(element){if(element.getFocusableElement){return element.getFocusableElement()}return element}addItem(type,selectorOrElement){assert$1(type);let element;if(typeof selectorOrElement==="string"){element=this.root.querySelector(selectorOrElement)}else{element=selectorOrElement}if(!element){return false}element.setAttribute("focus-type",type);element.tabIndex=this.isActive()?0:-1;this.eventTracker.add(element,"blur",this.onBlur_.bind(this));this.eventTracker.add(element,"focus",this.onFocus_.bind(this));this.eventTracker.add(element,"keydown",this.onKeydown_.bind(this));this.eventTracker.add(element,"mousedown",this.onMousedown_.bind(this));return true}destroy(){this.eventTracker.removeAll()}getCustomEquivalent(sampleElement){return assert$1(this.getFirstFocusable())}getElements(){return Array.from(this.root.querySelectorAll("[focus-type]")).map(FocusRow.getFocusableElement)}getEquivalentElement(sampleElement){if(this.getFocusableElements().indexOf(sampleElement)>=0){return sampleElement}const sampleFocusType=this.getTypeForElement(sampleElement);if(sampleFocusType){const sameType=this.getFirstFocusable(sampleFocusType);if(sameType){return sameType}}return this.getCustomEquivalent(sampleElement)}getFirstFocusable(opt_type){const element=this.getFocusableElements().find((el=>!opt_type||el.getAttribute("focus-type")===opt_type));return element||null}getFocusableElements(){return this.getElements().filter(FocusRow.isFocusable)}getTypeForElement(element){return element.getAttribute("focus-type")||""}isActive(){return this.root.classList.contains(FocusRow.ACTIVE_CLASS)}makeActive(active){if(active===this.isActive()){return}this.getElements().forEach((function(element){element.tabIndex=active?0:-1}));this.root.classList.toggle(FocusRow.ACTIVE_CLASS,active)}onBlur_(e){if(!this.boundary_.contains(e.relatedTarget)){return}const currentTarget=e.currentTarget;if(this.getFocusableElements().indexOf(currentTarget)>=0){this.makeActive(false)}}onFocus_(e){if(this.delegate){this.delegate.onFocus(this,e)}}onMousedown_(e){if(e.button){return}if(!e.currentTarget.disabled){e.currentTarget.tabIndex=0}}onKeydown_(e){const elements=this.getFocusableElements();const currentElement=FocusRow.getFocusableElement(e.currentTarget);const elementIndex=elements.indexOf(currentElement);assert$1(elementIndex>=0);if(this.delegate&&this.delegate.onKeydown(this,e)){return}const isShiftTab=!e.altKey&&!e.ctrlKey&&!e.metaKey&&e.shiftKey&&e.key==="Tab";if(hasKeyModifiers(e)&&!isShiftTab){return}let index=-1;let shouldStopPropagation=true;if(isShiftTab){index=elementIndex-1;if(index<0){return}}else if(e.key==="ArrowLeft"){index=elementIndex+(isRTL()?1:-1)}else if(e.key==="ArrowRight"){index=elementIndex+(isRTL()?-1:1)}else if(e.key==="Home"){index=0}else if(e.key==="End"){index=elements.length-1}else{shouldStopPropagation=false}const elementToFocus=elements[index];if(elementToFocus){this.getEquivalentElement(elementToFocus).focus();e.preventDefault()}if(shouldStopPropagation){e.stopPropagation()}}}FocusRow.ACTIVE_CLASS="focus-row-active";
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class FocusRowBehaviorDelegate{constructor(listItem){this.listItem_=listItem}onFocus(row,e){const element=e.composedPath()[0];const focusableElement=FocusRow.getFocusableElement(element);if(element!==focusableElement){focusableElement.focus()}this.listItem_.lastFocused=focusableElement}onKeydown(row,e){if(e.key==="Enter"){e.stopPropagation()}return false}getCustomEquivalent(sampleElement){return this.listItem_.overrideCustomEquivalent?this.listItem_.getCustomEquivalent(sampleElement):null}}class VirtualFocusRow extends FocusRow{constructor(root,delegate){super(root,null,delegate)}getCustomEquivalent(sampleElement){return this.delegate.getCustomEquivalent(sampleElement)||super.getCustomEquivalent(sampleElement)}}const FocusRowBehavior={properties:{row_:Object,mouseFocused_:Boolean,id:{type:String,reflectToAttribute:true},isFocused:{type:Boolean,notify:true},focusRowIndex:{type:Number,observer:"focusRowIndexChanged"},lastFocused:{type:Object,notify:true},ironListTabIndex:{type:Number,observer:"ironListTabIndexChanged_"},listBlurred:{type:Boolean,notify:true}},computeId_(index){return index!==undefined?`frb${index}`:undefined},focusRowIndexChanged(newIndex,oldIndex){this.setAttribute("aria-rowindex",newIndex+1);if(this.id===this.computeId_(oldIndex)){this.id=this.computeId_(newIndex)}},firstControl_:null,controlObservers_:[],attached(){this.classList.add("no-outline");afterNextRender(this,(function(){const rowContainer=this.root.querySelector("[focus-row-container]");assert$1(rowContainer);this.row_=new VirtualFocusRow(rowContainer,new FocusRowBehaviorDelegate(this));this.addItems_();this.listen(this,"focus","onFocus_");this.listen(this,"dom-change","addItems_");this.listen(this,"mousedown","onMouseDown_");this.listen(this,"blur","onBlur_")}))},detached(){this.unlisten(this,"focus","onFocus_");this.unlisten(this,"dom-change","addItems_");this.unlisten(this,"mousedown","onMouseDown_");this.unlisten(this,"blur","onBlur_");this.removeObservers_();if(this.firstControl_){this.unlisten(this.firstControl_,"keydown","onFirstControlKeydown_")}if(this.row_){this.row_.destroy()}},getFocusRow(){return assert$1(this.row_)},updateFirstControl_(){const newFirstControl=this.row_.getFirstFocusable();if(newFirstControl===this.firstControl_){return}if(this.firstControl_){this.unlisten(this.firstControl_,"keydown","onFirstControlKeydown_")}this.firstControl_=newFirstControl;if(this.firstControl_){this.listen(this.firstControl_,"keydown","onFirstControlKeydown_")}},removeObservers_(){if(this.controlObservers_.length>0){this.controlObservers_.forEach((observer=>{observer.disconnect()}))}this.controlObservers_=[]},addItems_(){this.ironListTabIndexChanged_();if(this.row_){this.removeObservers_();this.row_.destroy();const controls=this.root.querySelectorAll("[focus-row-control]");controls.forEach((control=>{this.row_.addItem(control.getAttribute("focus-type"),FocusRow.getFocusableElement(control));this.addMutationObservers_(assert$1(control))}));this.updateFirstControl_()}},createObserver_(){return new MutationObserver((mutations=>{const mutation=mutations[0];if(mutation.attributeName==="style"&&mutation.oldValue){const newStyle=window.getComputedStyle(mutation.target);const oldDisplayValue=mutation.oldValue.match(/^display:(.*)(?=;)/);const oldVisibilityValue=mutation.oldValue.match(/^visibility:(.*)(?=;)/);if(oldDisplayValue&&newStyle.display===oldDisplayValue[1].trim()&&oldVisibilityValue&&newStyle.visibility===oldVisibilityValue[1].trim()){return}}this.updateFirstControl_()}))},addMutationObservers_(control){let current=control;while(current&&current!==this.root){const currentObserver=this.createObserver_();currentObserver.observe(current,{attributes:true,attributeFilter:["hidden","disabled","style"],attributeOldValue:true});this.controlObservers_.push(currentObserver);current=current.parentNode}},onFocus_(e){if(this.mouseFocused_){this.mouseFocused_=false;return}const restoreFocusToFirst=this.listBlurred&&e.composedPath()[0]===this;if(this.lastFocused&&!restoreFocusToFirst){focusWithoutInk(this.row_.getEquivalentElement(this.lastFocused))}else{const firstFocusable=assert$1(this.firstControl_);focusWithoutInk(firstFocusable)}this.listBlurred=false;this.isFocused=true},onFirstControlKeydown_(e){if(e.shiftKey&&e.key==="Tab"){this.focus()}},ironListTabIndexChanged_(){if(this.row_){this.row_.makeActive(this.ironListTabIndex===0)}if(this.ironListTabIndex===0){this.listBlurred=false}},onMouseDown_(){this.mouseFocused_=true},onBlur_(e){this.mouseFocused_=false;this.isFocused=false;const node=e.relatedTarget?e.relatedTarget:null;if(!this.parentNode.contains(node)){this.listBlurred=true}}};function getTemplate$2e(){return html`<!--_html_template_start_--><style include="cr-shared-style internet-shared iron-flex">
  :host {
    display: inline-flex;
    outline: none;
    --network-list-item-disabled-opacity: 0.4;
  }

  #divOuter {
    height: var(--cr-network-row-height, 48px);
    overflow: auto;
    padding-inline-end: var(--cr-icon-ripple-padding);
  }

  :host([disabled_]) {
    cursor: auto;
    pointer-events: none;
  }

  :host([disabled_]) cr-policy-indicator,
  :host([disabled_]) #networkIconContainer,
  :host([disabled_]) #sublabel,
  :host([disabled_]) #divText,
  :host([is-e-sim-pending-profile_]) #divText,
  :host([is-e-sim-pending-profile_]) #divIcon,
  :host([is-p-sim-unactivated-network_]) #divText,
  :host([is-p-sim-unactivated-network_]) #networkIconContainer,
  :host([is-p-sim-activating-network_]) #divText,
  :host([is-p-sim-activating-network_]) #networkIconContainer,
  :host([is-blocked-network_]) #divText,
  :host([is-blocked-network_]) #networkIconContainer {
    opacity: var(--network-list-item-disabled-opacity);
  }

  :host(:not([is-e-sim-pending-profile_])
      :not([is-e-sim-installing-profile_])) #divIcon {
    height: 24px;
    width: 24px;
  }

  :host([is-e-sim-pending-profile_]) #divIcon,
  :host([is-e-sim-installing-profile_]) #divIcon {
    height: 20px;
    padding-inline-end: 20px;
    width: 20px;
  }

  #divDetail {
    display: flex;
    flex: 1 0 auto;
    flex-direction: row;
  }

  #divText {
    display: flex;
    flex: 1 0 auto;
    flex-direction: column;
    justify-content: center;
    margin-inline-start: 20px;
  }

  #sublabel {
    font-size: inherit;
  }

  #sublabel[active] {
    color: var(--cros-text-color-positive);
  }

  .warning {
    color: var(--cros-text-color-warning);
  }

  cr-policy-indicator {
    padding: 0 var(--cr-controlled-by-spacing);
  }

  #wrapper {
    height: 100%;
  }

  cr-button iron-icon {
    margin-inline-end: 8px;
  }

  :host(:not([disabled_])) cr-button iron-icon {
    --iron-icon-fill-color: var(--cros-tab-icon-color-active);
  }

  :host([disabled_]) cr-button iron-icon {
    --iron-icon-fill-color: var(--cros-icon-color-disabled);
  }

  paper-spinner-lite {
    height: 20px;
    margin-inline-end: 16px;
    width: 20px;
  }

  .separator {
    margin: 0 0 0 32px;
  }
</style>
<div id="wrapper" focus-row-container
      class="layout horizontal center flex">
  <div id="divOuter"
        class="layout horizontal center flex"
        actionable
        focus-row-control
        selectable
        aria-label$="[[rowLabel]]"
        aria-live="[[getLiveStatus_(isFocused)]]"
        focus-type="rowWrapper"
        on-keydown="onKeydown_"
        on-click="onSelected_">
    <div id="networkIconContainer">
      <template is="dom-if" if="[[networkState]]">
        <network-icon is-list-item
            show-technology-badge="[[showTechnologyBadge]]"
            network-state="[[networkState]]">
        </network-icon>
      </template>
    </div>
    <template is="dom-if" if="[[item.polymerIcon]]">
      <iron-icon id="divIcon" icon="[[item.polymerIcon]]"></iron-icon>
    </template>
    <div id="divText" class="layout horizontal flex">
      <div id="itemTitle" aria-hidden="true">
        [[itemTitle_]]
      </div>
      <div id="sublabel"
          class$="[[getSublabelClass_(networkState.*,
              isPSimUnavailableNetwork_, isESimUnactivatedProfile_)]]"
          hidden$="[[!isSublabelVisible_(networkState.*,
              isPSimUnavailableNetwork_, isUserLoggedIn_,
              isESimUnactivatedProfile_, isPSimPendingActivationNetwork_)]]"
          active$="[[isSublabelActive_(networkState.*,
              isUserLoggedIn_, isPSimPendingActivationNetwork_,
              activationUnavailable, isESimUnactivatedProfile_)]]">
        [[getSublabelText_(networkState.*, activationUnavailable,
            deviceState.*, isPSimUnavailableNetwork_,
            isPSimPendingActivationNetwork_, isUserLoggedIn_,
            isESimUnactivatedProfile_)]]
      </div>
    </div>
    <template is="dom-if" if="[[shouldShowPolicyIcon_(
        isBuiltInVpnManagementBlocked, networkState.source)]]">
      <cr-policy-indicator id="policyIcon" indicator-type="[[getPolicyIcon_(
          isBuiltInVpnManagementBlocked, networkState.source)]]">
      </cr-policy-indicator>
    </template>
    <template is="dom-if"
        if="[[shouldShowActivateButton_(isPSimPendingActivationNetwork_,
          showButtons, isUserLoggedIn_)]]" restamp>
      <cr-button id="activateButton"
          aria-label$="[[getActivateBtnA11yLabel_(item)]]"
          on-click="onActivateButtonClick_"
          disabled="[[disabled_]]">
        [[i18n('networkListItemActivate')]]
      </cr-button>
      <div class="separator"></div>
    </template>
    <template is="dom-if" if="[[isPSimActivatingNetwork_]]" restamp>
      <paper-spinner-lite id="activatingPSimSpinner" active>
      </paper-spinner-lite>
      [[i18n('networkListItemActivating')]]
      <div class="separator" hidden$="[[!showButtons]]"></div>
    </template>
    <template is="dom-if"
        if="[[isSubpageButtonVisible_(networkState, showButtons, disabled_,
          networkState.typeState.cellular.simLocked,
          isPSimPendingActivationNetwork_, isPSimActivatingNetwork_,
          isBuiltInVpnManagementBlocked)]]" restamp>
      <div>
        <cr-icon-button class="subpage-arrow"
            disabled="[[disabled_]]"
            id="subpageButton"
            on-click="onSubpageArrowClick_"
            tabindex$="[[tabindex]]"
            aria-label$="[[buttonLabel]]"
            focus-row-control
            focus-type="subpageButton">
        </cr-icon-button>
      </div>
    </template>
    <template is="dom-if" if="[[shouldShowUnlockButton_(networkState,
      networkState.typeState.cellular.simLocked, showButtons)]]" restamp>
      <cr-button id="unlockButton"
          aria-label$="[[getUnlockBtnA11yLabel_(item)]]"
          on-click="onUnlockButtonClick_"
          disabled="[[disabled_]]">
          [[i18n('networkListItemUnlock')]]
      </cr-button>
    </template>
    <template is="dom-if" if="[[shouldShowInstallButton_(
        isESimPendingProfile_, showButtons)]]" restamp>
      <cr-button id="installButton"
          aria-label$="[[getInstallBtnA11yLabel_(item)]]"
          on-click="onInstallButtonClick_"
          disabled="[[disabled_]]">
        <iron-icon icon="network:download"></iron-icon>
        [[i18n('networkListItemDownload')]]
      </cr-button>
    </template>
    <template is="dom-if" if="[[isESimInstallingProfile_]]" restamp>
      <paper-spinner-lite id="installingESimSpinner" active>
      </paper-spinner-lite>
      [[i18n('networkListItemAddingProfile')]]
    </template>
  </div>
</div>
<template is="dom-if" if="[[isCellularUnlockDialogOpen_]]" restamp>
  <sim-lock-dialogs
      global-policy="[[globalPolicy]]"
      is-dialog-open="{{isCellularUnlockDialogOpen_}}"
      device-state="[[deviceState]]">
  </sim-lock-dialogs>
</template>
<!--_html_template_end_-->`}
// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const NetworkList={};NetworkList.CustomItemType={OOBE:1,ESIM_PENDING_PROFILE:2,ESIM_INSTALLING_PROFILE:3};
// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const NetworkListItemElementBase=mixinBehaviors([CrPolicyNetworkBehaviorMojo,I18nBehavior,FocusRowBehavior],PolymerElement);class NetworkListItemElement extends NetworkListItemElementBase{static get is(){return"network-list-item"}static get template(){return getTemplate$2e()}static get properties(){return{disabled_:{type:Boolean,reflectToAttribute:true,observer:"disabledChanged_",computed:"computeDisabled_(deviceState, deviceState.inhibitReason,"+"disableItem, isUserLoggedIn_, isPSimPendingActivationNetwork_,"+"isBuiltInVpnManagementBlocked, networkState,"+"networkState.typeState.vpn, networkState.typeState.vpn.type)"},disableItem:Boolean,isBuiltInVpnManagementBlocked:{type:Boolean,value:false},item:{type:Object,observer:"itemChanged_"},networkState:{type:Object,observer:"networkStateChanged_"},showButtons:{type:Boolean,reflectToAttribute:true},tabindex:{type:Number,value:-1},rowLabel:{type:String,notify:true,computed:"getRowLabel_(item, networkState, subtitle_, isPSimPendingActivationNetwork_)"},buttonLabel:{type:String,computed:"getButtonLabel_(item)"},connectionState_:Number,showTechnologyBadge:{type:Boolean,value:true},activationUnavailable:{type:Boolean,value:false},deviceState:Object,globalPolicy:Object,itemTitle_:{type:String,value:""},subtitle_:{type:String,value:""},isPSimPendingActivationNetwork_:{type:Boolean,reflectToAttribute:true,value:false,computed:"computeIsPSimPendingActivationNetwork_(networkState.*)"},isPSimUnavailableNetwork_:{type:Boolean,reflectToAttribute:true,value:false,computed:"computeIsPSimUnavailableNetwork_(networkState.*)"},isPSimActivatingNetwork_:{type:Boolean,reflectToAttribute:true,value:false,computed:"computeIsPSimActivatingNetwork_(networkState.*)"},isESimPendingProfile_:{type:Boolean,reflectToAttribute:true,value:false,computed:"computeIsESimPendingProfile_(item, item.customItemType)"},isESimInstallingProfile_:{type:Boolean,reflectToAttribute:true,value:false,computed:"computeIsESimInstallingProfile_(item, item.customItemType)"},isESimUnactivatedProfile_:{type:Boolean,value:false,computed:"computeIsESimUnactivatedProfile_(networkState.*)"},isBlockedNetwork_:{type:Boolean,reflectToAttribute:true,value:false,computed:"computeIsBlockedNetwork_(item, globalPolicy)"},isCellularUnlockDialogOpen_:{type:Boolean,value:false},isUserLoggedIn_:{type:Boolean,value(){return loadTimeData$1.valueExists("isUserLoggedIn")&&loadTimeData$1.getBoolean("isUserLoggedIn")}}}}constructor(){super();this.networkConfig_=MojoInterfaceProviderImpl.getInstance().getMojoServiceRemote();this.focusRequested_=false}connectedCallback(){super.connectedCallback();this.addEventListener("keydown",this.onKeydown_.bind(this))}disconnectedCallback(){super.disconnectedCallback();this.removeEventListener("keydown",this.onKeydown_.bind(this))}isESimNetwork_(){return!!this.networkState&&this.networkState.type===NetworkType.kCellular&&!!this.networkState.typeState.cellular&&!!this.networkState.typeState.cellular.eid&&!!this.networkState.typeState.cellular.iccid}isPSimNetwork_(){return!!this.networkState&&this.networkState.type===NetworkType.kCellular&&!!this.networkState.typeState.cellular&&!this.networkState.typeState.cellular.eid&&!!this.networkState.typeState.cellular.iccid}isBuiltInVpn_(){if(!this.networkState||this.networkState.type!==NetworkType.kVPN){return false}const vpnType=this.networkState.typeState.vpn.type;return vpnType===VpnType.kL2TPIPsec||vpnType===VpnType.kOpenVPN}async itemChanged_(){if(this.item&&!this.item.hasOwnProperty("customItemType")){this.networkState=this.item}else{this.networkState=undefined}await this.setSubtitle_();this.setItemTitle_()}async setSubtitle_(){if(this.item.hasOwnProperty("customItemSubtitle")&&this.item.customItemSubtitle){const item=this.item;this.subtitle_=item.customItemSubtitle;return}this.subtitle_="";if(!this.isESimNetwork_()){return}const properties=await getESimProfileProperties(this.networkState.typeState.cellular.iccid);if(!properties){return}if(!this.networkState||!this.networkState.typeState.cellular||this.networkState.typeState.cellular.iccid!==properties.iccid){return}this.subtitle_=properties.serviceProvider}networkStateChanged_(){if(!this.networkState){return}const connectionState=this.networkState.connectionState;if(connectionState===this.connectionState_){return}this.connectionState_=connectionState;this.dispatchEvent(new CustomEvent("network-connect-changed",{bubbles:true,composed:true,detail:this.networkState}))}setItemTitle_(){const itemName=this.getItemName_();const subtitle=this.getSubtitle();if(!subtitle||this.isESimNetwork_()&&itemName===subtitle){this.itemTitle_=itemName;return}this.itemTitle_=loadTimeData$1.getStringF("networkListItemTitle",itemName,subtitle)}getItemName_(){if(this.item.hasOwnProperty("customItemName")){const item=this.item;return this.i18nExists(item.customItemName)?this.i18n(item.customItemName):item.customItemName}return OncMojo.getNetworkStateDisplayNameUnsafe(this.item)}getButtonLabel_(){return loadTimeData$1.getStringF("networkListItemSubpageButtonLabel",this.getItemName_())}computeDisabled_(){if(this.disableItem){return true}if(this.isBuiltInVpn_()&&this.isBuiltInVpnManagementBlocked){return true}if(!this.deviceState){return false}if(this.isPsimPendingActivationWhileLoggedOut_()){return true}return OncMojo.deviceIsInhibited(this.deviceState)}getRowLabel_(){if(!this.item){return""}const sublabel=this.getSublabelText_();const isManaged=this.item.source===OncSource.kDevicePolicy||this.item.source===OncSource.kUserPolicy;let index;let total;if(this.parentElement.items){index=this.parentElement.items.indexOf(this.item)+1;total=this.parentElement.items.length}else{index=0;total=1}switch(this.item.type){case NetworkType.kCellular:if(isManaged){if(sublabel){if(this.subtitle_){if(this.isPsimPendingActivationWhileLoggedOut_()){return loadTimeData$1.getStringF("networkListItemLabelManagedActivateAfterSetupWithProviderName",index,total,this.getItemName_(),this.subtitle_)}return loadTimeData$1.getStringF("networkListItemLabelCellularManagedWithConnectionStatusAndProviderName",index,total,this.getItemName_(),this.subtitle_,sublabel,this.item.typeState.cellular.signalStrength)}if(this.isPsimPendingActivationWhileLoggedOut_()){return loadTimeData$1.getStringF("networkListItemLabelManagedActivateAfterSetup",index,total,this.getItemName_())}return loadTimeData$1.getStringF("networkListItemLabelCellularManagedWithConnectionStatus",index,total,this.getItemName_(),sublabel,this.item.typeState.cellular.signalStrength)}if(this.subtitle_){return loadTimeData$1.getStringF("networkListItemLabelCellularManagedWithProviderName",index,total,this.getItemName_(),this.subtitle_,this.item.typeState.cellular.signalStrength)}return loadTimeData$1.getStringF("networkListItemLabelCellularManaged",index,total,this.getItemName_(),this.item.typeState.cellular.signalStrength)}if(sublabel){if(this.subtitle_){if(this.isPsimPendingActivationWhileLoggedOut_()){return loadTimeData$1.getStringF("networkListItemLabelActivateAfterSetupWithProviderName",index,total,this.getItemName_(),this.subtitle_)}return loadTimeData$1.getStringF("networkListItemLabelCellularWithConnectionStatusAndProviderName",index,total,this.getItemName_(),this.subtitle_,sublabel,this.item.typeState.cellular.signalStrength)}if(this.isPsimPendingActivationWhileLoggedOut_()){return loadTimeData$1.getStringF("networkListItemLabelActivateAfterSetup",index,total,this.getItemName_())}if(this.isPSimPendingActivationNetwork_){return loadTimeData$1.getStringF("networkListItemLabelCellularUnactivatedWithConnectionStatus",index,total,this.getItemName_(),sublabel,this.item.typeState.cellular.signalStrength)}if(this.isBlockedNetwork_){return loadTimeData$1.getStringF("networkListItemCellularBlockedWithConnectionStatusA11yLabel",index,total,this.getItemName_(),sublabel,this.item.typeState.cellular.signalStrength)}return loadTimeData$1.getStringF("networkListItemLabelCellularWithConnectionStatus",index,total,this.getItemName_(),sublabel,this.item.typeState.cellular.signalStrength)}if(this.isPSimPendingActivationNetwork_){return loadTimeData$1.getStringF("networkListItemLabelCellularUnactivated",index,total,this.getItemName_(),this.item.typeState.cellular.signalStrength)}if(this.isBlockedNetwork_){return loadTimeData$1.getStringF("networkListItemCellularBlockedA11yLabel",index,total,this.getItemName_(),this.item.typeState.cellular.signalStrength)}if(this.subtitle_){return loadTimeData$1.getStringF("networkListItemLabelCellularWithProviderName",index,total,this.getItemName_(),this.subtitle_,this.item.typeState.cellular.signalStrength)}return loadTimeData$1.getStringF("networkListItemLabelCellular",index,total,this.getItemName_(),this.item.typeState.cellular.signalStrength);case NetworkType.kEthernet:if(isManaged){if(sublabel){return loadTimeData$1.getStringF("networkListItemLabelCellularManagedWithConnectionStatus",index,total,this.getItemName_(),sublabel)}return loadTimeData$1.getStringF("networkListItemLabelEthernetManaged",index,total,this.getItemName_())}if(sublabel){return loadTimeData$1.getStringF("networkListItemLabelEthernetWithConnectionStatus",index,total,this.getItemName_(),sublabel)}return loadTimeData$1.getStringF("networkListItemLabel",index,total,this.getItemName_());case NetworkType.kTether:if(sublabel){if(this.subtitle_){return loadTimeData$1.getStringF("networkListItemLabelTetherWithConnectionStatusAndProviderName",index,total,this.getItemName_(),this.subtitle_,sublabel,this.item.typeState.tether.signalStrength,this.item.typeState.tether.batteryPercentage)}return loadTimeData$1.getStringF("networkListItemLabelTetherWithConnectionStatus",index,total,this.getItemName_(),sublabel,this.item.typeState.tether.signalStrength,this.item.typeState.tether.batteryPercentage)}if(this.subtitle_){return loadTimeData$1.getStringF("networkListItemLabelTetherWithProviderName",index,total,this.getItemName_(),this.subtitle_,this.item.typeState.tether.signalStrength,this.item.typeState.tether.batteryPercentage)}return loadTimeData$1.getStringF("networkListItemLabelTether",index,total,this.getItemName_(),this.item.typeState.tether.signalStrength,this.item.typeState.tether.batteryPercentage);case NetworkType.kWiFi:const secured=this.item.typeState.wifi.security===SecurityType.kNone?this.i18n("wifiNetworkStatusUnsecured"):this.i18n("wifiNetworkStatusSecured");if(isManaged){if(sublabel){return loadTimeData$1.getStringF("networkListItemLabelWifiManagedWithConnectionStatus",index,total,this.getItemName_(),secured,sublabel,this.item.typeState.wifi.signalStrength)}return loadTimeData$1.getStringF("networkListItemLabelWifiManaged",index,total,this.getItemName_(),secured,this.item.typeState.wifi.signalStrength)}if(sublabel){if(this.isBlockedNetwork_){return loadTimeData$1.getStringF("networkListItemWiFiBlockedWithConnectionStatusA11yLabel",index,total,this.getItemName_(),secured,sublabel,this.item.typeState.wifi.signalStrength)}return loadTimeData$1.getStringF("networkListItemLabelWifiWithConnectionStatus",index,total,this.getItemName_(),secured,sublabel,this.item.typeState.wifi.signalStrength)}if(this.isBlockedNetwork_){return loadTimeData$1.getStringF("networkListItemWiFiBlockedA11yLabel",index,total,this.getItemName_(),secured,this.item.typeState.wifi.signalStrength)}return loadTimeData$1.getStringF("networkListItemLabelWifi",index,total,this.getItemName_(),secured,this.item.typeState.wifi.signalStrength);default:if(this.isESimPendingProfile_){if(this.subtitle_){return loadTimeData$1.getStringF("networkListItemLabelESimPendingProfileWithProviderName",index,total,this.getItemName_(),this.subtitle_)}return loadTimeData$1.getStringF("networkListItemLabelESimPendingProfile",index,total,this.getItemName_())}else if(this.isESimInstallingProfile_){if(this.subtitle_){return loadTimeData$1.getStringF("networkListItemLabelESimPendingProfileWithProviderNameInstalling",index,total,this.getItemName_(),this.subtitle_)}return loadTimeData$1.getStringF("networkListItemLabelESimPendingProfileInstalling",index,total,this.getItemName_())}return loadTimeData$1.getStringF("networkListItemLabel",index,total,this.getItemName_())}}isSublabelVisible_(){return!!this.networkState&&!!this.getSublabelText_()}getSublabelText_(){if(!this.networkState){return""}if(this.networkState.type===NetworkType.kCellular){if(this.networkState.typeState.cellular.simLocked){if(this.networkState.typeState.cellular.simLockType==="network-pin"){return this.i18n("networkListItemUpdatedCellularSimCardCarrierLocked")}return this.i18n("networkListItemUpdatedCellularSimCardLocked")}if(this.isPsimPendingActivationWhileLoggedOut_()){return this.i18n("networkListItemActivateAfterDeviceSetup")}if(this.isPSimUnavailableNetwork_||this.isESimUnactivatedProfile_){return this.i18n("networkListItemUnavailableSimNetwork")}}const connectionState=this.networkState.connectionState;if(OncMojo.connectionStateIsConnected(connectionState)){if(this.isPortalState_(this.networkState.portalState)){if(this.networkState.type===NetworkType.kCellular){return this.i18n("networkListItemCellularSignIn")}return this.i18n("networkListItemSignIn")}if(this.networkState.portalState===PortalState.kNoInternet){return this.i18n("networkListItemConnectedNoConnectivity")}return this.i18n("networkListItemConnected")}if(connectionState===ConnectionStateType.kConnecting){return this.i18n("networkListItemConnecting")}return""}getSublabelClass_(){if(this.shouldShowWarningState_()){return"warning"}return"cr-secondary-text"}shouldShowWarningState_(){if(this.networkState&&this.networkState.type===NetworkType.kCellular&&this.networkState.typeState.cellular.simLocked){return true}if(this.isPSimUnavailableNetwork_||this.isESimUnactivatedProfile_){return true}if(this.isPsimPendingActivationWhileLoggedOut_()){return true}if(this.networkState&&OncMojo.isRestrictedConnectivity(this.networkState.portalState)){return true}return false}getSubtitle(){return this.subtitle_?this.subtitle_:""}isSubpageButtonVisible_(networkState,showButtons,disabled_){if(!this.showButtons){return false}if(this.isPSimPendingActivationNetwork_||this.isPSimActivatingNetwork_){return true}if(this.isBuiltInVpn_()&&this.isBuiltInVpnManagementBlocked){return true}return!!networkState&&!disabled_&&!this.shouldShowUnlockButton_()}isSublabelActive_(){if(!this.networkState){return false}if(this.shouldShowNotAvailableText_()){return false}if(this.isPsimPendingActivationWhileLoggedOut_()){return false}if(this.isESimUnactivatedProfile_){return false}if(OncMojo.isRestrictedConnectivity(this.networkState.portalState)){return false}return OncMojo.connectionStateIsConnected(this.networkState.connectionState)}onKeydown_(event){if(event.key!=="Enter"&&event.key!==" "){return}this.onSelected_(event);event.preventDefault()}onSelected_(event){if(this.disabled_){event.stopImmediatePropagation();return}if(this.isSubpageButtonVisible_(this.networkState,this.showButtons,this.disabled_)&&this.shadowRoot.querySelector("#subpageButton")===this.shadowRoot.activeElement){this.fireShowDetails_(event)}else if(this.shouldShowInstallButton_()){this.onInstallButtonClick_(event)}else if(this.shouldShowUnlockButton_()){this.onUnlockButtonClick_()}else if(this.item&&this.item.hasOwnProperty("customItemName")){this.dispatchEvent(new CustomEvent("custom-item-selected",{bubbles:true,composed:true,detail:this.item}))}else if(this.shouldShowActivateButton_()){this.fireShowDetails_(event)}else if(this.showButtons&&(this.isPSimUnavailableNetwork_||this.isPSimActivatingNetwork_||this.isESimUnactivatedProfile_)){this.fireShowDetails_(event)}else{this.dispatchEvent(new CustomEvent("selected",{bubbles:true,composed:true,detail:this.item}));this.focusRequested_=true}}onSubpageArrowClick_(event){this.fireShowDetails_(event)}fireShowDetails_(event){assert$1(this.networkState);this.dispatchEvent(new CustomEvent("show-detail",{bubbles:true,composed:true,detail:this.networkState}));event.stopPropagation()}shouldShowNotAvailableText_(){if(!this.networkState||!this.activationUnavailable){return false}return this.networkState.type===NetworkType.kCellular&&this.networkState.typeState.cellular.activationState!==ActivationStateType.kActivated}getLiveStatus_(isFocused){return this.isFocused?"polite":"off"}onInstallButtonClick_(event){if(this.disabled_){return}this.dispatchEvent(new CustomEvent("install-profile",{bubbles:true,composed:true,detail:{iccid:this.item.customData.iccid}}));event.stopPropagation()}computeIsESimPendingProfile_(){return!!this.item&&this.item.hasOwnProperty("customItemType")&&this.item.customItemType===NetworkList.CustomItemType.ESIM_PENDING_PROFILE}computeIsESimInstallingProfile_(){return!!this.item&&this.item.hasOwnProperty("customItemType")&&this.item.customItemType===NetworkList.CustomItemType.ESIM_INSTALLING_PROFILE}computeIsESimUnactivatedProfile_(){if(!this.isESimNetwork_()){return false}return this.networkState.typeState.cellular.activationState===ActivationStateType.kNotActivated}isUnactivatedPSimNetwork_(){if(!this.isPSimNetwork_()){return false}return this.networkState.typeState.cellular.activationState===ActivationStateType.kNotActivated}hasPaymentPortalInfo_(){if(!this.networkState||!this.networkState.typeState.cellular){return false}return!!this.networkState.typeState.cellular.paymentPortal&&!!this.networkState.typeState.cellular.paymentPortal.url}computeIsPSimPendingActivationNetwork_(){return this.isUnactivatedPSimNetwork_()&&this.hasPaymentPortalInfo_()}shouldShowActivateButton_(){if(!this.showButtons){return false}if(!this.isUserLoggedIn_){return false}return this.isPSimPendingActivationNetwork_}getActivateBtnA11yLabel_(){return loadTimeData$1.getStringF("networkListItemActivateA11yLabel",this.getItemName_())}onActivateButtonClick_(event){this.dispatchEvent(new CustomEvent("show-cellular-setup",{bubbles:true,composed:true,detail:{pageName:CellularSetupPageName.PSIM_FLOW_UI}}));event.stopPropagation()}computeIsPSimUnavailableNetwork_(){return this.isUnactivatedPSimNetwork_()&&!this.hasPaymentPortalInfo_()}computeIsPSimActivatingNetwork_(){if(!this.isPSimNetwork_()){return false}return this.networkState.typeState.cellular.activationState===ActivationStateType.kActivating}isBlockedWifiNetwork_(){if(!this.item){return false}if(this.item.type!==NetworkType.kWiFi){return false}if(!this.globalPolicy||this.isPolicySource(this.item.source)){return false}if(this.globalPolicy.allowOnlyPolicyWifiNetworksToConnect){return true}if(!!this.globalPolicy.allowOnlyPolicyWifiNetworksToConnectIfAvailable&&!!this.deviceState&&!!this.deviceState.managedNetworkAvailable){return true}return!!this.globalPolicy.blockedHexSsids&&this.globalPolicy.blockedHexSsids.includes(this.item.typeState.wifi.hexSsid)}computeIsBlockedNetwork_(){if(!this.item){return false}if(this.item.type!==NetworkType.kCellular&&this.item.type!==NetworkType.kWiFi){return false}if(!this.globalPolicy||this.isPolicySource(this.item.source)){return false}if(this.item.type===NetworkType.kCellular){return!!this.globalPolicy.allowOnlyPolicyCellularNetworks}return this.isBlockedWifiNetwork_()}shouldShowPolicyIcon_(){if(this.isBuiltInVpn_()&&this.isBuiltInVpnManagementBlocked){return true}return!!this.networkState&&this.isPolicySource(this.networkState.source)}getPolicyIcon_(){if(this.isBuiltInVpn_()&&this.isBuiltInVpnManagementBlocked){return CrPolicyIndicatorType$1.USER_POLICY}return this.getIndicatorTypeForSource(this.networkState.source)}isCellularNetworkScanning_(){if(!this.deviceState||!this.deviceState.scanning){return false}const iccid=this.networkState&&this.networkState.typeState.cellular&&this.networkState.typeState.cellular.iccid;if(!iccid){return false}return this.deviceState.simInfos.some((simInfo=>simInfo.iccid===iccid&&simInfo.isPrimary))}onUnlockButtonClick_(){this.isCellularUnlockDialogOpen_=true}shouldShowUnlockButton_(){if(!this.showButtons){return false}if(!this.networkState||!this.networkState.typeState.cellular){return false}if(this.networkState.typeState.cellular.simLocked&&this.networkState.typeState.cellular.simLockType==="network-pin"){return false}return this.networkState.typeState.cellular.simLocked}getUnlockBtnA11yLabel_(){return loadTimeData$1.getStringF("networkListItemUnlockA11YLabel",this.getItemName_())}shouldShowInstallButton_(){if(!this.showButtons){return false}return this.isESimPendingProfile_}getInstallBtnA11yLabel_(){return loadTimeData$1.getStringF("networkListItemDownloadA11yLabel",this.getItemName_())}disabledChanged_(newValue,oldValue){if(!newValue&&oldValue===undefined){return}if(this.disabled_){this.blur()}this.setAttribute("aria-disabled",!!this.disabled_)}isPortalState_(portalState){return portalState===PortalState.kPortal||portalState===PortalState.kPortalSuspected}isPsimPendingActivationWhileLoggedOut_(){return!this.isUserLoggedIn_&&this.isPSimPendingActivationNetwork_}}customElements.define(NetworkListItemElement.is,NetworkListItemElement);
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const ListPropertyUpdateMixin=dedupingMixin((superClass=>{class ListPropertyUpdateMixin extends superClass{updateList(propertyPath,identityGetter,updatedList,identityBasedUpdate=false){const list=this.get(propertyPath);const splices=calculateSplices(updatedList.map((item=>identityGetter(item))),list.map(identityGetter));splices.forEach((splice=>{const index=splice.index;const deleteCount=splice.removed.length;splice.removed=list.slice(index,index+deleteCount);splice.object=list;splice.type="splice";const added=updatedList.slice(index,index+splice.addedCount);const spliceParams=[index,deleteCount].concat(added);list.splice.apply(list,spliceParams)}));let updated=splices.length>0;if(!identityBasedUpdate){list.forEach(((item,index)=>{const updatedItem=updatedList[index];if(JSON.stringify(item)!==JSON.stringify(updatedItem)){this.set([propertyPath,index],updatedItem);updated=true}}))}if(splices.length>0){this.notifySplices(propertyPath,splices)}return updated}}return ListPropertyUpdateMixin}));function getTemplate$2d(){return html`<!--_html_template_start_--><style include="cr-shared-style iron-flex">

  network-list-item {
    align-items: center;
  }

  #container {
    overflow-x: hidden;
    overflow-y: auto;
  }

  #networkList {
    height: 100%;
  }

  /* Override scrollable border-bottom-color */
  #container[no-bottom-scroll-border] {
    border-bottom-color: transparent;
  }

  iron-list > *:not(:first-of-type) {
    border-top: var(--cr-separator-line);
  }

</style>
<div id="container" class="layout vertical flex" scrollable
    no-bottom-scroll-border$="[[noBottomScrollBorder]]">
  <iron-list id="networkList" items="[[listItems_]]"
      scroll-target="container" preserve-focus>
    <template>
      <network-list-item item="[[item]]"
          show-technology-badge="[[showTechnologyBadge]]"
          show-buttons="[[showButtons]]"
          tabindex$="[[tabIndex]]"
          focus-row-index="[[index]]"
          iron-list-tab-index="[[tabIndex]]"
          activation-unavailable="[[activationUnavailable]]"
          last-focused="{{lastFocused_}}"
          list-blurred="{{listBlurred_}}"
          device-state="[[deviceState]]"
          global-policy="[[globalPolicy]]"
          disable-item="[[disabled]]"
          is-built-in-vpn-management-blocked=
              "[[isBuiltInVpnManagementBlocked]]">
      </network-list-item>
    </template>
  </iron-list>
</div>
<!--_html_template_end_-->`}
// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const NetworkListElementBase=I18nMixin(CrScrollableMixin(ListPropertyUpdateMixin(PolymerElement)));class NetworkListElement extends NetworkListElementBase{static get is(){return"network-list"}static get template(){return getTemplate$2d()}static get properties(){return{networks:{type:Array,value(){return[]}},customItems:{type:Array,value(){return[]}},showButtons:{type:Boolean,value:false,reflectToAttribute:true},showTechnologyBadge:{type:Boolean,value:true},selectedItem:{type:Object,observer:"selectedItemChanged_"},activationUnavailable:Boolean,deviceState:Object,globalPolicy:Object,isBuiltInVpnManagementBlocked:{type:Boolean,value:false},listItems_:{type:Array,value(){return[]}},lastFocused_:Object,listBlurred_:Boolean,disabled:Boolean}}static get observers(){return["updateListItems_(networks, customItems)"]}constructor(){super();this.resizeObserver_=null;this.focusRequested_=false}connectedCallback(){super.connectedCallback();this.resizeObserver_=new ResizeObserver((_entries=>{const networkList=this.shadowRoot.querySelector("#networkList");if(networkList){networkList.notifyResize()}}));this.resizeObserver_.observe(this)}disconnectedCallback(){super.disconnectedCallback();if(this.resizeObserver_){this.resizeObserver_.disconnect()}}focus(){this.focusRequested_=true;this.focusFirstItem_()}updateListItems_(){const beforeNetworks=this.customItems.filter((n=>"showBeforeNetworksList"in n&&n.showBeforeNetworksList===true));const afterNetworks=this.customItems.filter((n=>!("showBeforeNetworksList"in n&&n.showBeforeNetworksList===true)));const newList=beforeNetworks.concat(this.networks,afterNetworks);this.updateList("listItems_",(item=>"guid"in item?item.guid:""),newList);if(this.resizeObserver_){this.updateScrollableContents()}if(this.focusRequested_){microTask.run((()=>{this.focusFirstItem_()}))}}focusFirstItem_(){const item=this.shadowRoot.querySelector("network-list-item");if(!item){return}item.focus();this.focusRequested_=false}}customElements.define(NetworkListElement.is,NetworkListElement);function getTemplate$2c(){return html`<!--_html_template_start_--><!-- TODO(b/281904820): Remove me. -->
<style include="settings-shared iron-flex iron-positioning">:host{--cr-dialog-width:372px}paper-spinner-lite{height:20px;position:absolute;right:16px;top:6px;width:20px}#confirmationCodeMessage{margin-bottom:30px}#cancel{margin-inline-end:8px}</style>
<cr-dialog id="installErrorDialog" show-on-attach>
  <div slot="title">$i18n{eSimInstallErrorDialogTitle}</div>
  <div slot="body">
    <div id="genericErrorContainer"
        hidden$="[[isConfirmationCodeError_(errorCode)]]">
      $i18n{eSimInstallErrorDialogGenericErrorMessage}
    </div>
    <template is="dom-if" if="[[isConfirmationCodeError_(errorCode)]]" restamp>
      <div id="confirmationCodeErrorContainer">
        <div id="confirmationCodeMessage">
          $i18n{eSimInstallErrorDialogConfirmationCodeMessage}
        </div>
        <div class="relative">
          <cr-input id="confirmationCode"
              value="{{confirmationCode_}}"
              spellcheck="false"
              disabled="[[isInstallInProgress_]]"
              error-message="$i18n{eSimInstallErrorDialogConfirmationCodeError}"
              invalid="[[isConfirmationCodeInvalid_]]">
          </cr-input>
          <paper-spinner-lite active
              hidden$="[[!isInstallInProgress_]]">
          </paper-spinner-lite>
        </div>
      </div>
    </template>
  </div>
  <div slot="button-container">
    <cr-button id="cancel"
        on-click="onCancelClicked_"
        class="cancel-button"
        hidden$="[[!isConfirmationCodeError_(errorCode)]]">
      $i18n{eSimRenameProfileDialogCancel}
    </cr-button>
    <cr-button id="done"
        on-click="onDoneClicked_"
        disabled="[[isDoneButtonDisabled_(errorCode, confirmationCode_, isInstallInProgress_)]]"
        class="action-button">
      $i18n{eSimRenameProfileDialogDone}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const EsimInstallErrorDialogElementBase=I18nMixin(PolymerElement);class EsimInstallErrorDialogElement extends EsimInstallErrorDialogElementBase{static get is(){return"esim-install-error-dialog"}static get template(){return getTemplate$2c()}static get properties(){return{errorCode:{type:Object,value:null},profile:{type:Object,value:null},confirmationCode_:{type:String,value:"",observer:"onConfirmationCodeChanged_"},isConfirmationCodeInvalid_:{type:Boolean,value:false},isInstallInProgress_:{type:Boolean,value:false}}}onConfirmationCodeChanged_(){this.isConfirmationCodeInvalid_=false}onDoneClicked_(){if(!this.isConfirmationCodeError_()){this.$.installErrorDialog.close();return}this.isInstallInProgress_=true;this.isConfirmationCodeInvalid_=false;this.profile.installProfile(this.confirmationCode_).then((response=>{this.isInstallInProgress_=false;if(response.result===ProfileInstallResult.kSuccess){this.$.installErrorDialog.close();return}this.isConfirmationCodeInvalid_=true}))}onCancelClicked_(){this.$.installErrorDialog.close()}isConfirmationCodeError_(){return this.errorCode===ProfileInstallResult.kErrorNeedsConfirmationCode}isDoneButtonDisabled_(){return this.isConfirmationCodeError_()&&(!this.confirmationCode_||this.isInstallInProgress_)}}customElements.define(EsimInstallErrorDialogElement.is,EsimInstallErrorDialogElement);function getTemplate$2b(){return html`<!--_html_template_start_--><style include="cr-shared-style os-settings-icons settings-shared iron-flex">:host>div{padding-inline-end:calc(var(--cr-section-padding) - var(--cr-icon-ripple-padding));padding-inline-start:var(--cr-section-padding)}.cellular-network-list-separator{border-top:var(--cr-separator-line);padding:0}.cellular-network-list-header{align-items:center;display:flex;height:72px}.esim-list-title{align-self:center}.cellular-network-content{margin-inline-start:32px}.cellular-not-setup{color:var(--cr-secondary-text-color);font-size:small;margin-bottom:16px}.flex{display:flex}.flex-column{display:flex;flex-direction:column}#eidPopupButton{--cr-icon-button-size:18px;cursor:pointer;margin-inline-start:4px}:host-context([dir='rtl']) #addESimButton{transform:scaleX(1)}#alignEnd{align-items:center;display:flex;margin-inline-end:12px;margin-inline-start:auto}#inhibitedSubtext{color:var(--cr-secondary-text-color)}paper-spinner-lite{height:20px;width:20px}cr-policy-indicator{margin-inline-start:24px}.separator{margin-inline-end:0;margin-inline-start:24px}</style>
<template is="dom-if" if="[[shouldShowEsimSection_(euicc_,
    cellularDeviceState, cellularDeviceState.*)]]" restamp>
  <div class="cellular-network-list-separator"></div>
    <div class="cellular-network-list-header flex settings-box-text">
      <div class="flex-column">
        <div class="flex header-row">
          $i18n{cellularNetworkEsimLabel}
        </div>
        <div id="inhibitedSubtext" class="header-row secondary-box-text"
            hidden="[[!isDeviceInhibited_]]" aria-live="assertive">
          [[getInhibitedSubtextMessage_(isDeviceInhibited_,
              cellularDeviceState.*)]]
        </div>
      </div>
      <div id="alignEnd">
        <template is="dom-if" if="[[canShowSpinner]]" restamp>
          <paper-spinner-lite id="inhibitedSpinner"
              active="[[isDeviceInhibited_]]">
          </paper-spinner-lite>
        </template>
        <template is="dom-if" if="[[shouldShowAddEsimButton_(
            cellularDeviceState)]]" restamp>
          <cr-policy-indicator indicator-type="devicePolicy"
              hidden="[[!shouldShowAddEsimPolicyIcon_(globalPolicy)]]"
              icon-aria-label="$i18n{internetAddCellular}">
          </cr-policy-indicator>
          <cr-icon-button class="icon-add-cellular add-button"
              aria-label="$i18n{internetAddCellular}" id="addESimButton"
              disabled="[[isAddEsimButtonDisabled_(cellularDeviceState,
                  globalPolicy)]]"
              on-click="onAddEsimButtonClick_">
          </cr-icon-button>
        </template>
      </div>
    </div>
  </div>
  <template is="dom-if" if="[[shouldShowNetworkSublist_(eSimNetworks_,
      eSimPendingProfileItems_)]]" restamp>
    <div class="cellular-network-content">
      <network-list id="esimNetworkList" show-buttons
          show-technology-badge="[[showTechnologyBadge]]"
          networks="[[eSimNetworks_]]"
          custom-items="[[eSimPendingProfileItems_]]"
          device-state="[[cellularDeviceState]]"
          global-policy="[[globalPolicy]]">
      </network-list>
    </div>
  </template>
  <div class="cellular-network-content cellular-not-setup flex">
    <div id="noEsimNetworksMessage"
        hidden="[[!shouldShowNoEsimNetworksMessageWithoutLink_(
            cellularDeviceState,
            cellularDeviceState.inhibitReason,
            eSimNetworks_,
            eSimPendingProfileItems_,
            globalPolicy.allowOnlyPolicyCellularNetworks)]]">
      $i18n{eSimNetworkNotSetup}
    </div>
    <localized-link
        id="noEsimNetworksMessageWithLink"
        link-disabled="[[isDeviceInhibited_]]"
        on-link-clicked="onAddEsimLinkClicked_"
        localized-string="$i18n{eSimNetworkNotSetupWithDownloadLink}"
        hidden="[[!shouldShowAddEsimMessageWithLink(
            cellularDeviceState,
            cellularDeviceState.inhibitReason,
            eSimNetworks_,
            eSimPendingProfileItems_,
            globalPolicy.allowOnlyPolicyCellularNetworks)]]">
    </localized-link>
  </div>
</template>
<template is="dom-if"
    if="[[shouldShowPsimSection_(pSimNetworks_, cellularDeviceState,
      cellularDeviceState.*)]]" restamp>
  <div class="cellular-network-list-separator"></div>
  <div id="pSimLabel" class="cellular-network-list-header settings-box-text">
    $i18n{cellularNetworkPsimLabel}
  </div>
  <template
      is="dom-if"
      if="[[shouldShowNetworkSublist_(pSimNetworks_)]]" restamp>
    <div class="cellular-network-content">
      <network-list
          id="psimNetworkList" show-buttons
          show-technology-badge="[[showTechnologyBadge]]"
          networks="[[pSimNetworks_]]"
          device-state="[[cellularDeviceState]]"
          global-policy="[[globalPolicy]]">
      </network-list>
    </div>
  </template>
  <template
      is="dom-if"
      if="[[!shouldShowNetworkSublist_(pSimNetworks_)]]" restamp>
    <div id="pSimNoNetworkFound"
        class="cellular-network-content cellular-not-setup">
      $i18n{pSimNotInsertedLabel}
    </div>
  </template>
</template>
<template is="dom-if"
    if="[[shouldShowTetherSection_(multiDevicePageContentData_)]]" restamp>
  <div class="cellular-network-list-separator"></div>
  <div class="cellular-network-list-header settings-box-text">
    $i18n{cellularNetworkTetherLabel}
  </div>
  <template is="dom-if"
      if="[[shouldShowNetworkSublist_(tetherNetworks_)]]" restamp>
    <div class="cellular-network-content">
      <network-list
          id="tetherNetworkList" show-buttons
          show-technology-badge="[[showTechnologyBadge]]"
          networks="[[tetherNetworks_]]"
          device-state="[[tetherDeviceState]]">
      </network-list>
    </div>
  </template>
  <template is="dom-if"
      if="[[!shouldShowNetworkSublist_(tetherNetworks_)]]" restamp>
    <div id="tetherNetworksNotSetup"
        class="cellular-network-content cellular-not-setup">
      <localized-link
          localized-string="[[i18nAdvanced('tetherNetworkNotSetup')]]">
      </localized-link>
    </div>
  </template>
</template>

<template is="dom-if" if="[[shouldShowInstallErrorDialog_]]" restamp>
  <esim-install-error-dialog id="installErrorDialog"
      on-close="onCloseInstallErrorDialog_"
      error-code="[[eSimProfileInstallError_]]"
      profile="[[installingESimProfile_]]">
  </esim-install-error-dialog>
</template>
<!--_html_template_end_-->`}
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CellularNetworksListElementBase=ESimManagerListenerMixin(WebUiListenerMixin(I18nMixin(PolymerElement)));class CellularNetworksListElement extends CellularNetworksListElementBase{static get is(){return"cellular-networks-list"}static get template(){return getTemplate$2b()}static get properties(){return{networks:{type:Array,value(){return[]},observer:"onNetworksListChanged_"},showTechnologyBadge:Boolean,cellularDeviceState:Object,isConnectedToNonCellularNetwork:{type:Boolean},canShowSpinner:{type:Boolean},tetherDeviceState:Object,globalPolicy:Object,eSimNetworks_:{type:Array,value(){return[]}},profilesMap_:{type:Object,value(){return new Map}},eSimPendingProfileItems_:{type:Array,value(){return[]}},pSimNetworks_:{type:Array,value(){return[]}},tetherNetworks_:{type:Array,value(){return[]}},shouldShowEidDialog_:{type:Boolean,value:false},shouldShowInstallErrorDialog_:{type:Boolean,value:false},euicc_:{type:Object,value:null},installingESimProfile_:{type:Object,value:null},eSimProfileInstallError_:{type:Object,value:null},multiDevicePageContentData_:{type:Object,value:null},isDeviceInhibited_:{type:Boolean,computed:"computeIsDeviceInhibited_(cellularDeviceState,"+"cellularDeviceState.inhibitReason)"},isInstantHotspotRebrandEnabled_:{type:Boolean,value(){return loadTimeData$1.valueExists("isInstantHotspotRebrandEnabled")&&loadTimeData$1.getBoolean("isInstantHotspotRebrandEnabled")}},isMultiDevicePageAvailable_:{type:Boolean,value(){return!!routes.MULTIDEVICE}}}}constructor(){super();this.networkConfig_=MojoInterfaceProviderImpl.getInstance().getMojoServiceRemote();this.fetchEuiccAndEsimPendingProfileList_()}ready(){super.ready();this.addEventListener("install-profile",this.installProfile_);if(this.isMultiDevicePageAvailable_){this.addWebUiListener("settings.updateMultidevicePageContentData",this.onMultiDevicePageContentDataChanged_.bind(this));MultiDeviceBrowserProxyImpl.getInstance().getPageContentData().then(this.onMultiDevicePageContentDataChanged_.bind(this))}}onAvailableEuiccListChanged(){this.fetchEuiccAndEsimPendingProfileList_()}fetchEuiccAndEsimPendingProfileList_(){getEuicc().then((euicc=>{if(!euicc){return}this.euicc_=euicc}))}shouldShowEsimSection_(){if(!this.cellularDeviceState){return false}const{eSimSlots:eSimSlots}=getSimSlotCount(this.cellularDeviceState);return!!this.euicc_&&eSimSlots>0}async processEsimPendingProfiles_(profiles){this.profilesMap_=new Map;const eSimPendingProfilePromises=profiles.map(this.createEsimPendingProfilePromise_.bind(this));const eSimPendingProfileItems=await Promise.all(eSimPendingProfilePromises);this.eSimPendingProfileItems_=eSimPendingProfileItems}async createEsimPendingProfilePromise_(profile){const response=await profile.getProperties();this.profilesMap_.set(response.properties.iccid,profile);return this.createEsimPendingProfileItem_(response.properties)}createEsimPendingProfileItem_(properties){return{customItemType:properties.state===ProfileState.kInstalling?NetworkList.CustomItemType.ESIM_INSTALLING_PROFILE:NetworkList.CustomItemType.ESIM_PENDING_PROFILE,customItemName:properties.name,customItemSubtitle:properties.serviceProvider,polymerIcon:"network:cellular-0",showBeforeNetworksList:false,customData:{iccid:properties.iccid}}}onNetworksListChanged_(){const pSimNetworks=[];const eSimNetworks=[];const tetherNetworks=[];for(const network of this.networks){if(network.type===NetworkType.kTether){tetherNetworks.push(network);continue}if(network.typeState.cellular&&network.typeState.cellular.eid){eSimNetworks.push(network)}else{pSimNetworks.push(network)}}this.eSimNetworks_=eSimNetworks;this.pSimNetworks_=pSimNetworks;this.tetherNetworks_=tetherNetworks}shouldShowNetworkSublist_(...lists){const totalListLength=lists.reduce(((accumulator,currentList)=>accumulator+currentList.length),0);return totalListLength>0}shouldShowPsimSection_(pSimNetworks,cellularDeviceState){const{pSimSlots:pSimSlots}=getSimSlotCount(cellularDeviceState);if(pSimSlots>0){return true}return this.shouldShowNetworkSublist_(pSimNetworks)}onMultiDevicePageContentDataChanged_(newData){assert(this.isMultiDevicePageAvailable_);this.multiDevicePageContentData_=newData}shouldShowTetherSection_(pageContentData){if(!pageContentData){return false}if(this.isInstantHotspotRebrandEnabled_){return false}return pageContentData.instantTetheringState===MultiDeviceFeatureState.ENABLED_BY_USER}onAddEsimLinkClicked_(event){event.detail.event.preventDefault();event.stopPropagation();const showCellularSetupEvent=new CustomEvent("show-cellular-setup",{bubbles:true,composed:true,detail:{pageName:CellularSetupPageName.ESIM_FLOW_UI}});this.dispatchEvent(showCellularSetupEvent)}onEsimDotsClick_(e){const menu=this.shadowRoot.querySelector("#menu").get();menu.showAt(e.target)}onShowEidDialogClick_(){const actionMenu=castExists(this.shadowRoot.querySelector("cr-action-menu"));actionMenu.close();this.shouldShowEidDialog_=true}onCloseEidDialog_(){this.shouldShowEidDialog_=false}installProfile_(event){if(!this.isConnectedToNonCellularNetwork){const event=new CustomEvent("show-error-toast",{bubbles:true,composed:true,detail:this.i18n("eSimNoConnectionErrorToast")});this.dispatchEvent(event);return}this.installingESimProfile_=castExists(this.profilesMap_.get(event.detail.iccid));this.installingESimProfile_.installProfile("").then((response=>{if(response.result===ProfileInstallResult.kSuccess){this.eSimProfileInstallError_=null;this.installingESimProfile_=null}else{this.eSimProfileInstallError_=response.result;this.showInstallErrorDialog_()}}))}showInstallErrorDialog_(){this.shouldShowInstallErrorDialog_=true}onCloseInstallErrorDialog_(){this.shouldShowInstallErrorDialog_=false}shouldShowAddEsimButton_(cellularDeviceState){assert(this.euicc_);return this.deviceIsEnabled_(cellularDeviceState)}isAddEsimButtonDisabled_(cellularDeviceState,globalPolicy){if(this.isDeviceInhibited_){return true}if(!this.deviceIsEnabled_(cellularDeviceState)){return true}if(!globalPolicy){return false}return globalPolicy.allowOnlyPolicyCellularNetworks}shouldShowAddEsimPolicyIcon_(globalPolicy){return globalPolicy&&globalPolicy.allowOnlyPolicyCellularNetworks}deviceIsEnabled_(cellularDeviceState){return!!cellularDeviceState&&cellularDeviceState.deviceState===DeviceStateType.kEnabled}computeIsDeviceInhibited_(){if(!this.cellularDeviceState){return false}return OncMojo.deviceIsInhibited(this.cellularDeviceState)}onAddEsimButtonClick_(){const event=new CustomEvent("show-cellular-setup",{bubbles:true,composed:true,detail:{pageName:CellularSetupPageName.ESIM_FLOW_UI}});this.dispatchEvent(event)}getAddEsimButton(){return this.shadowRoot.querySelector("#addESimButton")}getInhibitedSubtextMessage_(){if(!this.cellularDeviceState){return""}const inhibitReason=this.cellularDeviceState.inhibitReason;switch(inhibitReason){case InhibitReason.kInstallingProfile:return this.i18n("cellularNetworkInstallingProfile");case InhibitReason.kRenamingProfile:return this.i18n("cellularNetworkRenamingProfile");case InhibitReason.kRemovingProfile:return this.i18n("cellularNetworkRemovingProfile");case InhibitReason.kConnectingToProfile:return this.i18n("cellularNetworkConnectingToProfile");case InhibitReason.kRefreshingProfileList:return this.i18n("cellularNetworRefreshingProfileListProfile");case InhibitReason.kResettingEuiccMemory:return this.i18n("cellularNetworkResettingESim");case InhibitReason.kRequestingAvailableProfiles:return this.i18n("cellularNetworkRequestingAvailableProfiles")}return""}isInhibitedOrAffectedByPolicy_(){if(this.cellularDeviceState&&this.cellularDeviceState.inhibitReason!==undefined&&this.cellularDeviceState.inhibitReason!==InhibitReason.kNotInhibited){return true}return!!this.globalPolicy&&this.globalPolicy.allowOnlyPolicyCellularNetworks}shouldShowNoEsimNetworksMessage_(){if(this.cellularDeviceState&&this.cellularDeviceState.inhibitReason!==undefined){const inhibitReason=this.cellularDeviceState.inhibitReason;if(inhibitReason===InhibitReason.kInstallingProfile||inhibitReason===InhibitReason.kRefreshingProfileList||inhibitReason===InhibitReason.kRequestingAvailableProfiles){return false}}return!this.shouldShowNetworkSublist_(this.eSimNetworks_,this.eSimPendingProfileItems_)}shouldShowNoEsimNetworksMessageWithoutLink_(){return this.shouldShowNoEsimNetworksMessage_()&&this.isInhibitedOrAffectedByPolicy_()}shouldShowAddEsimMessageWithLink(){return this.shouldShowNoEsimNetworksMessage_()&&!this.isInhibitedOrAffectedByPolicy_()}}customElements.define(CellularNetworksListElement.is,CellularNetworksListElement);function getTemplate$2a(){return html`<!--_html_template_start_--><style include="settings-shared network-shared md-select">#lockdown{border-top:var(--cr-separator-line)}</style>
<!-- Always-on VPN enable/disable toggle -->
<div class="property-box">
  <div class="start text-area" aria-hidden="true">
    <div class="label" id="alwaysOnVpnEnableLabel">
      $i18n{networkAlwaysOnVpnEnableLabel}
    </div>
    <div class="secondary" id="alwaysOnVpnEnableSublabel">
      $i18n{networkAlwaysOnVpnEnableSublabel}
    </div>
  </div>
  <cr-toggle id="alwaysOnVpnEnableToggle"
      disabled="[[shouldDisableAlwaysOnVpn_(networks)]]"
      checked="[[computeAlwaysOnVpnEnabled_(mode, networks)]]"
      on-change="onAlwaysOnEnableChanged_"
      aria-labelledby="alwaysOnVpnEnableLabel"
      aria-describedby="alwaysOnVpnEnableSublabel">
  </cr-toggle>
</div>
<!-- Always-on VPN options -->
<template is="dom-if" if="[[shouldShowAlwaysOnVpnOptions_(
        mode, networks)]]">
  <!-- Service selector -->
  <div class="property-box indented two-line">
    <div class="start text-area" aria-hidden="true">
      <div class="label" id="alwaysOnVpnServiceLabel">
        $i18n{networkAlwaysOnVpnService}
      </div>
    </div>
    <select id="alwaysOnVpnServiceSelect"
        class="md-select"
        on-change="onAlwaysOnVpnServiceChanged_"
        aria-labelledby="alwaysOnVpnServiceLabel">
      <template is="dom-repeat" items="[[getAlwaysOnVpnListOptions_(
                service, networks)]]">
        <option value="[[item.value]]" selected="[[item.selected]]">
          [[item.name]]
        </option>
      </template>
    </select>
  </div>
  <!-- Lockdown toggle -->
  <div id="lockdown" class="property-box indented two-line">
    <div class="start text-area" aria-hidden="true">
      <div class="label" id="alwaysOnVpnLockdownLabel">
        $i18n{networkAlwaysOnVpnLockdownLabel}
      </div>
      <div class="secondary" id="alwaysOnVpnLockdownSublabel">
        $i18n{networkAlwaysOnVpnLockdownSublabel}
      </div>
    </div>
    <cr-toggle id="alwaysOnVpnLockdownToggle"
        checked="[[computeAlwaysOnVpnLockdown_(mode)]]"
        on-change="onAlwaysOnVpnLockdownChanged_"
        aria-labelledby="alwaysOnVpnLockdownLabel"
        aria-describedby="alwaysOnVpnLockdownSublabel">
    </cr-toggle>
  </div>
</template>
<!--_html_template_end_-->`}
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const NetworkAlwaysOnVpnElementBase=I18nMixin(PolymerElement);class NetworkAlwaysOnVpnElement extends NetworkAlwaysOnVpnElementBase{static get is(){return"network-always-on-vpn"}static get template(){return getTemplate$2a()}static get properties(){return{networks:Array,mode:{type:Number,notify:true},service:{type:String,notify:true}}}shouldDisableAlwaysOnVpn_(){return this.networks.length===0}shouldShowAlwaysOnVpnOptions_(){return!this.shouldDisableAlwaysOnVpn_()&&this.mode!==AlwaysOnVpnMode.kOff}computeAlwaysOnVpnEnabled_(){return!this.shouldDisableAlwaysOnVpn_()&&this.mode!==AlwaysOnVpnMode.kOff}onAlwaysOnEnableChanged_(event){const toggleEl=cast(event.target,CrToggleElement);if(!toggleEl.checked){this.mode=AlwaysOnVpnMode.kOff;return}this.mode=AlwaysOnVpnMode.kBestEffort}computeAlwaysOnVpnLockdown_(){return this.mode===AlwaysOnVpnMode.kStrict}onAlwaysOnVpnLockdownChanged_(event){if(this.mode===AlwaysOnVpnMode.kOff){return}const toggleEl=cast(event.target,CrToggleElement);this.mode=toggleEl.checked?AlwaysOnVpnMode.kStrict:AlwaysOnVpnMode.kBestEffort}getAlwaysOnVpnListOptions_(){const options=[];const currentService=this.service;let serviceIsInList=false;if(!this.networks){return options}this.networks.forEach((state=>{options.push({name:state.name,value:state.guid,selected:currentService===state.guid});serviceIsInList=serviceIsInList||currentService===state.guid}));if(!serviceIsInList){options.unshift({name:"",value:"",selected:true})}return options}onAlwaysOnVpnServiceChanged_(event){const selectEl=cast(event.target,HTMLSelectElement);this.service=selectEl.value}}customElements.define(NetworkAlwaysOnVpnElement.is,NetworkAlwaysOnVpnElement);function getTemplate$29(){return html`<!--_html_template_start_--><style include="settings-shared iron-flex">:host{--cr-dialog-body-padding-horizontal:24px;--cr-dialog-button-container-padding-bottom:20px;--cr-dialog-button-container-padding-horizontal:24px;--cr-dialog-width:416px;--cr-dialog-title-slot-padding-bottom:12px;--cr-dialog-title-slot-padding-end:24px;--cr-dialog-title-slot-padding-start:24px;--cr-dialog-title-font-size:calc(16 / 13 * 100%)}#qrCodeCanvas{background-color:white;display:block;margin:20px auto 20px auto;max-width:calc(var(--cr-dialog-width) - var(--cr-dialog-title-slot-padding-start) - var(--cr-dialog-title-slot-padding-end))}.info-container{padding-top:16px}#eidContainer{border-bottom:var(--cr-separator-line)}.info-label{font-weight:bold}.info-value{color:var(--cr-primary-text-color)}</style>
<cr-dialog id="deviceInfoDialog" show-on-attach>
  <div slot="title">$i18n{mobileDeviceInfoPopupTitle}</div>
  <div slot="body" id="body" aria-label="[[getA11yLabel_(deviceState, eid_)]]">
    <div id="dialogDescription" aria-hidden="true">
      $i18n{mobileDeviceInfoPopupDescription}
    </div>
    <template is="dom-if" if="[[shouldShowEidAndQrCode_(eid_)]]">
      <div class="info-container" id="eidContainer">
        <div class="info-label" aria-hidden="true">
          $i18n{deviceInfoPopupEidLabel}
        </div>
        <div class="info-value" id="eid" aria-hidden="true">[[eid_]]</div>
        <canvas id="qrCodeCanvas"
            width="[[canvasSize_]]"
            height="[[canvasSize_]]">
        </canvas>
      </div>
    </template>
    <template is="dom-if" if="[[shouldShowImei_(deviceState)]]">
      <div class="info-container">
        <div class="info-label" aria-hidden="true">
          $i18n{deviceInfoPopupImeiLabel}
        </div>
        <div id="imei" class="info-value" aria-hidden="true">
          [[deviceState.imei]]
        </div>
      </div>
    </template>
    <template is="dom-if" if="[[shouldShowSerial_(deviceState)]]">
      <div class="info-container">
        <div class="info-label" aria-hidden="true">
          $i18n{deviceInfoPopupSerialLabel}
        </div>
        <div id="serialLabel" class="info-value" aria-hidden="true">
          [[deviceState.serial]]
        </div>
      </div>
    </template>
  </div>
  <div slot="button-container">
    <cr-button id="done" class="action-button"
        on-click="onDonePressed_">
      $i18n{done}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const QR_CODE_TILE_SIZE=5;const QUIET_ZONE_OFFSET=4;const QR_CODE_FILL_STYLE="#000000";class NetworkDeviceInfoDialogElement extends(I18nMixin(PolymerElement)){static get is(){return"network-device-info-dialog"}static get template(){return getTemplate$29()}static get properties(){return{euicc:Object,deviceState:Object,canvasSize_:Number,eid_:String}}ready(){super.ready();if(this.euicc){this.fetchEid_(this.euicc);return}requestAnimationFrame((()=>{this.$.done.focus()}))}onDonePressed_(){this.$.deviceInfoDialog.close()}async fetchEid_(euicc){const[qrCodeResponse,euiccPropertiesResponse]=await Promise.all([euicc.getEidQRCode(),euicc.getProperties()]);this.updateEid_(euiccPropertiesResponse?.properties);this.renderQrCode_(qrCodeResponse?.qrCode)}renderQrCode_(qrCode){if(!qrCode){return}this.canvasSize_=qrCode.size*QR_CODE_TILE_SIZE+2*QUIET_ZONE_OFFSET*QR_CODE_TILE_SIZE;flush();const context=this.getCanvasContext_();if(!context){return}context.clearRect(0,0,this.canvasSize_,this.canvasSize_);context.fillStyle=QR_CODE_FILL_STYLE;let index=0;for(let x=QUIET_ZONE_OFFSET;x<qrCode.size+QUIET_ZONE_OFFSET;x++){for(let y=QUIET_ZONE_OFFSET;y<qrCode.size+QUIET_ZONE_OFFSET;y++){if(qrCode.data[index]){context.fillRect(x*QR_CODE_TILE_SIZE,y*QR_CODE_TILE_SIZE,QR_CODE_TILE_SIZE,QR_CODE_TILE_SIZE)}index++}}}updateEid_(euiccProperties){if(!euiccProperties){return}this.eid_=euiccProperties.eid}getCanvasContext_(){if(this.canvasContext_){return this.canvasContext_}const canvas=this.shadowRoot.querySelector("#qrCodeCanvas");return canvas.getContext("2d")}shouldShowEidAndQrCode_(){return!!this.eid_}shouldShowImei_(){return!!this.deviceState?.imei}shouldShowSerial_(){return!!this.deviceState?.serial}setCanvasContextForTest(canvasContext){this.canvasContext_=canvasContext}getA11yLabel_(){if(this.eid_&&this.deviceState?.imei&&this.deviceState?.serial){return this.i18n("deviceInfoPopupA11yEidImeiAndSerial",this.eid_,this.deviceState.imei,this.deviceState.serial)}if(this.eid_){if(this.deviceState?.imei){return this.i18n("deviceInfoPopupA11yEidAndImei",this.eid_,this.deviceState.imei)}if(this.deviceState?.serial){return this.i18n("deviceInfoPopupA11yEidAndSerial",this.eid_,this.deviceState.serial)}return this.i18n("deviceInfoPopupA11yEid",this.eid_)}if(this.deviceState?.imei){if(this.deviceState?.serial){return this.i18n("deviceInfoPopupA11yImeiAndSerial",this.deviceState.imei,this.deviceState.serial)}return this.i18n("deviceInfoPopupA11yImei",this.deviceState.imei)}if(this.deviceState?.serial){return this.i18n("deviceInfoPopupA11ySerial",this.deviceState.serial)}return""}}customElements.define(NetworkDeviceInfoDialogElement.is,NetworkDeviceInfoDialogElement);function getTemplate$28(){return html`<!--_html_template_start_--><style include="settings-shared"></style>
<template is="dom-if"
    if="[[shouldShowDotsMenuButton_(deviceState)]]" restamp>
  <cr-icon-button id="moreNetworkMenuButton"
      class="icon-more-vert"
      title="$i18n{moreActions}"
      on-click="onDotsClick_">
  </cr-icon-button>
</template>
<cr-lazy-render id="menu">
  <template>
    <cr-action-menu>
      <button id="deviceInfoMenuItem"
          class="dropdown-item"
          on-click="onShowDeviceInfoClick_"
          role="menuitem">
        $i18n{deviceInfoPopupMenuItemTitle}
      </button>
    </cr-action-menu>
  </template>
</cr-lazy-render>
<template is="dom-if" if="[[showDeviceNetworkInfoDialog_]]" restamp>
  <network-device-info-dialog
      on-close="onCloseDeviceNetworkInfoDialog_"
      euicc="[[euicc_]]"
      device-state="[[deviceState]]">
  </network-device-info-dialog>
</template><!--_html_template_end_-->`}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsInternetSubpageMenuElementBase=ESimManagerListenerMixin(WebUiListenerMixin(PolymerElement));class SettingsInternetSubpageMenuElement extends SettingsInternetSubpageMenuElementBase{static get is(){return"settings-internet-subpage-menu"}static get template(){return getTemplate$28()}static get properties(){return{deviceState:Object,showDeviceNetworkInfoDialog_:{type:Boolean,value:false}}}constructor(){super();this.fetchEuicc_()}onAvailableEuiccListChanged(){this.fetchEuicc_()}async fetchEuicc_(){const euicc=await getEuicc();this.euicc_=euicc}shouldShowDotsMenuButton_(){const isCellularSubpage=this.deviceState?.type===NetworkType.kCellular;return isCellularSubpage&&(!!this.euicc_||!!this.deviceState?.imei)}onShowDeviceInfoClick_(){this.closeMenu_();this.showDeviceNetworkInfoDialog_=true}onCloseDeviceNetworkInfoDialog_(){this.showDeviceNetworkInfoDialog_=false}closeMenu_(){const actionMenu=castExists(this.shadowRoot.querySelector("cr-action-menu"));actionMenu.close()}onDotsClick_(e){const menu=this.shadowRoot.querySelector("#menu").get();menu.showAt(e.target)}}customElements.define(SettingsInternetSubpageMenuElement.is,SettingsInternetSubpageMenuElement);function getTemplate$27(){return html`<!--_html_template_start_--><style include="cr-shared-style os-settings-icons settings-shared iron-flex">#networkListDiv{min-height:var(--cr-section-two-line-min-height)}:host(:not([is-showing-vpn_],[is-showing-tether_])) #networkListDiv{margin-top:var(--cr-section-vertical-margin)}#cellularNetworkList{margin-top:calc(-1*var(--cr-section-vertical-margin))}#instant-tether-notifications-toggle{border-bottom:var(--cr-separator-line);min-height:var(--cr-section-min-height)}#your-device-hotspots-header{color:var(--cros-text-color-primary);font:var(--cros-button-1-font);margin-bottom:5px}#networkListDiv>*{padding-inline-end:calc(var(--cr-section-padding) - var(--cr-icon-ripple-padding));padding-inline-start:var(--cr-section-padding)}.add-button{margin-inline-end:20px}.vpn-header{margin-bottom:8px;margin-inline-end:12px;margin-inline-start:4px;margin-top:8px}.no-networks{min-height:var(--cr-section-two-line-min-height)}network-list{flex:1}network-always-on-vpn{width:100%}#gmscore-notifications-container{border-top:var(--cr-separator-line);margin:10px 0;padding-bottom:var(--cr-section-padding);padding-top:var(--cr-section-padding)}#gmscore-notifications-container[no-networks-text-below]{border-bottom:var(--cr-separator-line);margin-top:0}#gmscore-notifications-device-string{margin-top:5px}#gmscore-notifications-instructions{margin:0;padding-inline-start:15px}#cellularNetworkList{padding-inline-end:0;padding-inline-start:0}</style>

<template is="dom-if" if="[[shouldShowBluetoothDisabledTetherErrorMessage_(deviceState)]]">
  <div id="networkListDiv" class="layout horizontal center">
    <localized-link
      localized-string="[[getBluetoothDisabledErrorMessageForTether_()]]">
    </localized-link>
  </div>
</template>

<template is="dom-if" if="[[enableToggleIsVisible_(deviceState)]]">
  <div class="settings-box first">
    <div class="primary-toggle start" on$="[[deviceIsEnabled_(deviceState)]]"
        aria-hidden="true">
      [[getOffOnString_(deviceState,
        '$i18nPolymer{deviceOn}', '$i18nPolymer{deviceOff}')]]
    </div>
    <!-- The add button in this row is only shown for WiFi networks. -->
    <cr-icon-button class="icon-add-wifi add-button" id="addWifiButton"
        hidden$="[[!showAddWifiButton_(deviceState, globalPolicy)]]"
        aria-label="$i18n{internetAddWiFi}" on-click="onAddWifiButtonClick_"
        tabindex$="[[tabindex]]"
        deep-link-focus-id$="[[Setting.kWifiAddNetwork]]">
    </cr-icon-button>
    <cr-toggle id="deviceEnabledButton"
        aria-label$="[[getToggleA11yString_(deviceState)]]"
        checked="[[deviceIsEnabled_(deviceState)]]"
        disabled="[[!enableToggleIsEnabled_(deviceState,
          deviceState.inhibitReason)]]"
        on-change="onDeviceEnabledChange_"
        deep-link-focus-id$="[[Setting.kWifiOnOff]]
            [[Setting.kMobileOnOff]]">
    </cr-toggle>
  </div>
</template>

<template is="dom-if" if="[[knownNetworksIsVisible_(deviceState)]]">
  <cr-link-row
      id="knownNetworksSubpageButton"
      class="hr"
      label="$i18n{knownNetworksButton}"
      on-click="onKnownNetworksClick_"
      role-description="$i18n{subpageArrowRoleDescription}">
  </cr-link-row>
</template>


<template is="dom-if" if="[[shouldShowTetherNotificationControl_(deviceState)]]">
  <settings-toggle-button
     id="instant-tether-notifications-toggle"
     label="$i18n{internetTetherNotificationControlTitle}"
     sub-label="$i18n{internetTetherNotificationControlDescription}"
     pref="{{prefs.tether.notifications_enabled}}">
  </settings-toggle-button>
</template>

<template is="dom-if" if="[[deviceIsEnabled_(deviceState)]]">
  <div id="networkListDiv" class="layout vertical flex">
    <!-- VPN only header for built-in VPNs. -->
    <template is="dom-if" if="[[isShowingVpn_]]">
      <div class="vpn-header layout horizontal center">
        <div class="flex settings-box-text">$i18n{networkVpnBuiltin}</div>
        <template is="dom-if" if="[[isBuiltInVpnManagementBlocked]]">
          <cr-policy-indicator indicator-type="devicePolicy">
          </cr-policy-indicator>
        </template>
        <cr-icon-button class="icon-add-circle"
            id="addBuiltInVpnButton"
            disabled="[[isBuiltInVpnManagementBlocked]]"
            aria-label="$i18n{internetAddVPN}"
            on-click="onAddVpnButtonClick_"
            tabindex$="[[tabindex]]">
        </cr-icon-button>
      </div>
    </template>

    <!-- List of networks (empty if no networks exist). -->
    <template is="dom-if"
        if="[[shouldShowNetworkList_(networkStateList_, deviceState)]]">
      <template is="dom-if" if="[[shouldShowTetherDeviceListHeader_(deviceState)]]">
          <div id="your-device-hotspots-title">$i18n{internetYourDeviceHotspots}</div>
      </template>
      <network-list id="networkList" show-buttons
          class="layout horizontal center"
          is-built-in-vpn-management-blocked="[[isBuiltInVpnManagementBlocked]]"
          show-technology-badge="[[showTechnologyBadge_]]"
          networks="[[networkStateList_]]"
          global-policy="[[globalPolicy]]"
          on-selected="onNetworkSelected_"
          device-state="[[deviceState]]">
      </network-list>
    </template>

    <!-- List of cellular and instant tethering networks -->
    <template is="dom-if"
        if="[[shouldShowCellularNetworkList_(networkStateList_,
                                              deviceState)]]">
      <cellular-networks-list id="cellularNetworkList"
          networks="[[networkStateList_]]"
          show-technology-badge="[[showTechnologyBadge_]]"
          on-selected="onNetworkSelected_"
          cellular-device-state="[[deviceState]]"
          tether-device-state="[[tetherDeviceState]]"
          global-policy="[[globalPolicy]]"
          is-connected-to-non-cellular-network="[[isConnectedToNonCellularNetwork]]"
          can-show-spinner="[[!isCellularSetupActive]]">
      </cellular-networks-list>
    </template>

    <!-- Instructions for how to enable "Google Play Services" notifications
        (needed for Instant Tethering). -->
    <template is="dom-if" if="[[showGmsCoreNotificationsSection_(
        notificationsDisabledDeviceNames_)]]">
      <div id="gmscore-notifications-container"
          no-networks-text-below$="[[!networkStateList_.length]]">
        <div>$i18n{gmscoreNotificationsTitle}</div>
        <div id="gmscore-notifications-device-string"
            class="cr-secondary-text">
          [[getGmsCoreNotificationsDevicesString_(
              notificationsDisabledDeviceNames_)]]
        </div>
        <ol id="gmscore-notifications-instructions"
            class="cr-secondary-text">
          <li>$i18n{gmscoreNotificationsFirstStep}</li>
          <li>$i18n{gmscoreNotificationsSecondStep}</li>
          <li>$i18n{gmscoreNotificationsThirdStep}</li>
          <li>$i18n{gmscoreNotificationsFourthStep}</li>
        </ol>
      </div>
    </template>

    <!-- Text shown if no networks exist. -->
    <template is="dom-if" if="[[!hideNoNetworksMessage_(networkStateList_, deviceState)]]">
      <div class="layout horizontal center no-networks">
        <localized-link
          localized-string="[[getNoNetworksInnerHtml_(deviceState, tetherDeviceState)]]">
        </localized-link>
      </div>
    </template>

    <template is="dom-if" if="[[isShowingVpn_]]">
      <!-- Third party VPNs. -->
      <template is="dom-repeat"
          items="[[getVpnProviders_(vpnProviders, thirdPartyVpns_)]]">
        <div id="[[item.providerName]]"
            class="vpn-header layout horizontal center">
          <div class="flex settings-box-text">[[item.providerName]]</div>
          <cr-icon-button class="icon-external"
              aria-label$="[[getAddThirdPartyVpnA11yString_(item)]]"
              on-click="onAddThirdPartyVpnClick_" tabindex$="[[tabindex]]">
          </cr-icon-button>
        </div>
        <network-list show-buttons
            hidden$="[[!haveThirdPartyVpnNetwork_(thirdPartyVpns_, item)]]"
            networks="[[getThirdPartyVpnNetworks_(thirdPartyVpns_, item)]]"
            on-selected="onNetworkSelected_">
        </network-list>
      </template>
    </template>
  </div>

  <template is="dom-if"
      if="[[shouldShowVpnPreferences_(isManaged_, isShowingVpn_)]]">
    <div class="settings-box first">
      <h2>$i18n{networkVpnPreferences}</h2>
    </div>
    <div class="settings-box first">
      <network-always-on-vpn id="alwaysOnVpnSelector"
          networks="[[getAlwaysOnVpnNetworks_(deviceState,
            networkStateList_, thirdPartyVpns_)]]"
          mode="{{alwaysOnVpnMode_}}"
          service="{{alwaysOnVpnService_}}">
      </network-always-on-vpn>
    </div>
  </template>
</template>
<!--_html_template_end_-->`}
// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsInternetSubpageElementBase=mixinBehaviors([NetworkListenerBehavior,CrPolicyNetworkBehaviorMojo],DeepLinkingMixin(PrefsMixin(RouteOriginMixin(I18nMixin(PolymerElement)))));class SettingsInternetSubpageElement extends SettingsInternetSubpageElementBase{static get is(){return"settings-internet-subpage"}static get template(){return getTemplate$27()}static get properties(){return{defaultNetwork:Object,deviceState:Object,tetherDeviceState:Object,globalPolicy:Object,vpnProviders:Array,isBuiltInVpnManagementBlocked:{type:Boolean,value:false},showSpinner:{type:Boolean,notify:true,value:false},isConnectedToNonCellularNetwork:{type:Boolean},isCellularSetupActive:{type:Boolean},networkStateList_:{type:Array,value(){return[]}},thirdPartyVpns_:{type:Object,value(){return{}}},isInstantHotspotRebrandEnabled_:{type:Boolean,value(){return loadTimeData.valueExists("isInstantHotspotRebrandEnabled")&&loadTimeData.getBoolean("isInstantHotspotRebrandEnabled")}},isShowingVpn_:{type:Boolean,computed:"computeIsShowingVpn_(deviceState)",reflectToAttribute:true},isShowingTether_:{type:Boolean,computed:"computeIsShowingTether_(deviceState)",reflectToAttribute:true},isManaged_:{type:Boolean,value(){return loadTimeData.getBoolean("isManaged")}},alwaysOnVpnMode_:Number,alwaysOnVpnService_:String,notificationsDisabledDeviceNames_:{type:Array,value(){return[]}},showTechnologyBadge_:{type:Boolean,value(){return loadTimeData.valueExists("showTechnologyBadge")&&loadTimeData.getBoolean("showTechnologyBadge")}},hasCompletedScanSinceLastEnabled_:{type:Boolean,value:false},vpnIsEnabled_:{type:Boolean,value:false},pendingSettingId_:{type:Number,value:null}}}static get observers(){return["deviceStateChanged_(deviceState)","onAlwaysOnVpnChanged_(alwaysOnVpnMode_, alwaysOnVpnService_)"]}constructor(){super();this.supportedSettingIds=new Set([Setting.kWifiOnOff,Setting.kWifiAddNetwork,Setting.kMobileOnOff,Setting.kInstantTetheringOnOff,Setting.kAddESimNetwork]);this.route=routes.INTERNET_NETWORKS;this.scanIntervalId_=null;this.browserProxy_=InternetPageBrowserProxyImpl.getInstance();this.networkConfig_=MojoInterfaceProviderImpl.getInstance().getMojoServiceRemote()}ready(){super.ready();this.browserProxy_.setGmsCoreNotificationsDisabledDeviceNamesCallback((notificationsDisabledDeviceNames=>{this.notificationsDisabledDeviceNames_=notificationsDisabledDeviceNames}));this.browserProxy_.requestGmsCoreNotificationsDisabledDeviceNames();this.addFocusConfig(routes.KNOWN_NETWORKS,"#knownNetworksSubpageButton")}disconnectedCallback(){super.disconnectedCallback();this.stopScanning_()}beforeDeepLinkAttempt(settingId){if(settingId===Setting.kAddESimNetwork){afterNextRender(this,(()=>{const deepLinkElement=this.shadowRoot.querySelector("cellular-networks-list").getAddEsimButton();if(!deepLinkElement||deepLinkElement.hidden){console.warn(`Element with deep link id ${settingId} not focusable.`);return}this.showDeepLinkElement(deepLinkElement)}));return false}if(settingId===Setting.kInstantTetheringOnOff){afterNextRender(this,(()=>{const tetherEnabled=this.shadowRoot.querySelector("#tetherEnabledButton");if(tetherEnabled){this.showDeepLinkElement(tetherEnabled);return}const deviceEnabled=this.shadowRoot.querySelector("#deviceEnabledButton");if(deviceEnabled){this.showDeepLinkElement(deviceEnabled);return}console.warn(`Element with deep link id ${settingId} not focusable.`)}));return false}return true}currentRouteChanged(newRoute,oldRoute){if(newRoute!==this.route){this.stopScanning_();return}this.init();super.currentRouteChanged(newRoute,oldRoute);this.attemptDeepLink().then((result=>{if(!result.deepLinkShown&&result.pendingSettingId){this.pendingSettingId_=result.pendingSettingId}}))}init(){this.networkStateList_=[];this.thirdPartyVpns_={};this.hasCompletedScanSinceLastEnabled_=false;this.showSpinner=false;this.getNetworkStateList_();this.updateScanning_();this.updateAlwaysOnVpnPreferences_()}onActiveNetworksChanged(){this.getNetworkStateList_()}onNetworkStateListChanged(){this.getNetworkStateList_();this.updateAlwaysOnVpnPreferences_()}onVpnProvidersChanged(){if(this.deviceState.type!==NetworkType.kVPN){return}this.getNetworkStateList_()}deviceStateChanged_(){if(this.deviceState){if(this.deviceState.type===NetworkType.kVPN){this.vpnIsEnabled_=this.deviceState.deviceState===DeviceStateType.kEnabled}this.hasCompletedScanSinceLastEnabled_=this.showSpinner&&!this.deviceState.scanning&&this.deviceState.deviceState===DeviceStateType.kEnabled;if(this.shouldShowCellularNetworkList_()&&this.isDeviceInhibited_()){this.showSpinner=false}else{this.showSpinner=!!this.deviceState.scanning}}if(Router.getInstance().currentRoute!==routes.INTERNET_NETWORKS){this.stopScanning_();return}this.getNetworkStateList_();this.updateScanning_()}updateScanning_(){if(!this.deviceState){return}if(this.shouldStartScan_()){this.startScanning_();return}}shouldStartScan_(){assert(this.deviceState);if(this.deviceState.type===NetworkType.kWiFi){return true}return this.deviceState.type===NetworkType.kTether||this.deviceState.type===NetworkType.kCellular&&!!this.tetherDeviceState&&!this.isInstantHotspotRebrandEnabled_}startScanning_(){if(this.scanIntervalId_!==null){return}const INTERVAL_MS=10*1e3;let type=this.deviceState.type;if(!this.isInstantHotspotRebrandEnabled_&&type===NetworkType.kCellular&&this.tetherDeviceState){type=NetworkType.kTether}this.networkConfig_.requestNetworkScan(type);this.scanIntervalId_=window.setInterval((()=>{this.networkConfig_.requestNetworkScan(type)}),INTERVAL_MS)}stopScanning_(){if(this.scanIntervalId_===null){return}window.clearInterval(this.scanIntervalId_);this.scanIntervalId_=null}async getNetworkStateList_(){if(!this.deviceState){return}const filter={filter:FilterType.kVisible,limit:NO_LIMIT,networkType:this.deviceState.type};const response=await this.networkConfig_.getNetworkStateList(filter);await this.onGetNetworks_(response.result);if(!this.pendingSettingId_){return}const result=await this.showDeepLink(this.pendingSettingId_);if(result.deepLinkShown){this.pendingSettingId_=null}}async onGetNetworks_(networkStates){if(!this.deviceState){return}if(!this.isInstantHotspotRebrandEnabled_&&this.deviceState.type===NetworkType.kCellular&&this.tetherDeviceState){const filter={filter:FilterType.kVisible,limit:NO_LIMIT,networkType:NetworkType.kTether};const response=await this.networkConfig_.getNetworkStateList(filter);this.set("networkStateList_",networkStates.concat(response.result));return}if(this.deviceState.type===NetworkType.kVPN){const builtinNetworkStates=[];const thirdPartyVpns={};networkStates.forEach((state=>{assert(state.type===NetworkType.kVPN&&state.typeState.vpn);switch(state.typeState.vpn.type){case VpnType.kIKEv2:case VpnType.kL2TPIPsec:case VpnType.kOpenVPN:case VpnType.kWireGuard:builtinNetworkStates.push(state);break;case VpnType.kArc:if(!OncMojo.connectionStateIsConnected(state.connectionState)){break}case VpnType.kExtension:const providerId=state.typeState.vpn.providerId;thirdPartyVpns[providerId]=thirdPartyVpns[providerId]||[];thirdPartyVpns[providerId].push(state);break}}));networkStates=builtinNetworkStates;this.thirdPartyVpns_=thirdPartyVpns}this.set("networkStateList_",networkStates)}getVpnProviders_(vpnProviders,thirdPartyVpns){const configuredProviders=[];for(const vpnList of Object.values(thirdPartyVpns)){assert(vpnList.length>0);const vpn=castExists(vpnList[0].typeState.vpn);const provider={type:vpn.type,providerId:vpn.providerId,providerName:vpn.providerName||vpn.providerId,appId:"",lastLaunchTime:{internalValue:BigInt(0)}};configuredProviders.push(provider)}const unconfiguredProviders=[];for(const provider of vpnProviders){const idx=configuredProviders.findIndex((p=>p.providerId===provider.providerId));if(idx>=0){configuredProviders[idx]=provider}else{unconfiguredProviders.push(provider)}}return configuredProviders.concat(unconfiguredProviders)}deviceIsEnabled_(deviceState){if(OncMojo.deviceIsFlashing(deviceState)){return false}return!!deviceState&&(deviceState.type===NetworkType.kVPN||deviceState.deviceState===DeviceStateType.kEnabled)}getOffOnString_(deviceState,onstr,offstr){return this.deviceIsEnabled_(deviceState)?onstr:offstr}enableToggleIsVisible_(deviceState){return!!deviceState&&deviceState.type!==NetworkType.kEthernet&&deviceState.type!==NetworkType.kVPN&&(!this.isInstantHotspotRebrandEnabled_||deviceState.type!==NetworkType.kTether)}enableToggleIsEnabled_(deviceState){if(!deviceState){return false}if(deviceState.deviceState===DeviceStateType.kProhibited){return false}if(OncMojo.deviceStateIsIntermediate(deviceState.deviceState)){return false}if(OncMojo.deviceIsFlashing(deviceState)){return false}return!this.isDeviceInhibited_()}isDeviceInhibited_(){if(!this.deviceState){return false}return OncMojo.deviceIsInhibited(this.deviceState)}getToggleA11yString_(deviceState){if(!this.enableToggleIsVisible_(deviceState)){return""}switch(deviceState.type){case NetworkType.kTether:return this.i18n("internetToggleTetherA11yLabel");case NetworkType.kCellular:return this.i18n("internetToggleMobileA11yLabel");case NetworkType.kWiFi:return this.i18n("internetToggleWiFiA11yLabel")}assertNotReached()}getAddThirdPartyVpnA11yString_(provider){return this.i18n("internetAddThirdPartyVPN",provider.providerName||"")}allowAddConnection_(deviceState,globalPolicy){if(!this.deviceIsEnabled_(deviceState)){return false}return globalPolicy&&!globalPolicy.allowOnlyPolicyWifiNetworksToConnect}showAddWifiButton_(deviceState,globalPolicy){if(!deviceState||deviceState.type!==NetworkType.kWiFi){return false}return this.allowAddConnection_(deviceState,globalPolicy)}dispatchShowConfigEvent_(type){const event=new CustomEvent("show-config",{bubbles:true,composed:true,detail:{type:type}});this.dispatchEvent(event)}onAddWifiButtonClick_(){assert(this.deviceState,"Device state is falsey - Wifi expected.");const type=this.deviceState.type;assert(type===NetworkType.kWiFi,"Wifi type expected.");this.dispatchShowConfigEvent_(OncMojo.getNetworkTypeString(type))}onAddVpnButtonClick_(){assert(this.deviceState,"Device state is falsey - VPN expected.");const type=this.deviceState.type;assert(type===NetworkType.kVPN,"VPN type expected.");this.dispatchShowConfigEvent_(OncMojo.getNetworkTypeString(type))}onAddThirdPartyVpnClick_(event){const provider=event.model.item;this.browserProxy_.addThirdPartyVpn(provider.appId)}knownNetworksIsVisible_(deviceState){return!!deviceState&&deviceState.type===NetworkType.kWiFi}onKnownNetworksClick_(){assert(this.deviceState?.type===NetworkType.kWiFi);const showKnownNetworksEvent=new CustomEvent("show-known-networks",{bubbles:true,composed:true,detail:this.deviceState.type});this.dispatchEvent(showKnownNetworksEvent)}onDeviceEnabledChange_(){assert(this.deviceState);const deviceEnabledToggledEvent=new CustomEvent("device-enabled-toggled",{bubbles:true,composed:true,detail:{enabled:!this.deviceIsEnabled_(this.deviceState),type:this.deviceState.type}});this.dispatchEvent(deviceEnabledToggledEvent)}getThirdPartyVpnNetworks_(thirdPartyVpns,provider){return thirdPartyVpns[provider.providerId]||[]}haveThirdPartyVpnNetwork_(thirdPartyVpns,provider){const list=this.getThirdPartyVpnNetworks_(thirdPartyVpns,provider);return!!list.length}onNetworkSelected_(e){assert(this.globalPolicy);assert(this.defaultNetwork!==undefined);const networkState=e.detail;e.target.blur();if(this.canAttemptConnection_(networkState)){const networkConnectEvent=new CustomEvent("network-connect",{bubbles:true,composed:true,detail:{networkState:networkState}});this.dispatchEvent(networkConnectEvent);return}const showDetailEvent=new CustomEvent("show-detail",{bubbles:true,composed:true,detail:networkState});this.dispatchEvent(showDetailEvent)}isBlockedByPolicy_(state){if(state.type!==NetworkType.kWiFi&&state.type!==NetworkType.kCellular){return false}if(this.isPolicySource(state.source)||!this.globalPolicy){return false}if(state.type===NetworkType.kCellular){return!!this.globalPolicy.allowOnlyPolicyCellularNetworks}return!!this.globalPolicy.allowOnlyPolicyWifiNetworksToConnect||!!this.globalPolicy.allowOnlyPolicyWifiNetworksToConnectIfAvailable&&!!this.deviceState&&!!this.deviceState.managedNetworkAvailable||!!this.globalPolicy.blockedHexSsids&&this.globalPolicy.blockedHexSsids.includes(state.typeState.wifi.hexSsid)}canAttemptConnection_(state){if(state.connectionState!==ConnectionStateType.kNotConnected){return false}if(this.isBlockedByPolicy_(state)){return false}if(state.type===NetworkType.kVPN&&(!this.defaultNetwork||!OncMojo.connectionStateIsConnected(this.defaultNetwork.connectionState))){return false}if(state.type===NetworkType.kCellular&&state.typeState.cellular.simLocked){return false}return true}matchesType_(typeString,device){return!!device&&device.type===OncMojo.getNetworkTypeFromString(typeString)}shouldShowNetworkList_(networkStateList){if(this.shouldShowCellularNetworkList_()){return false}if(!!this.deviceState&&this.deviceState.type===NetworkType.kVPN){return this.shouldShowVpnList_()}return networkStateList.length>0}shouldShowVpnList_(){return this.vpnIsEnabled_&&this.networkStateList_.length>0}shouldShowCellularNetworkList_(){return!!this.deviceState&&this.deviceState.type===NetworkType.kCellular}shouldShowBluetoothDisabledTetherErrorMessage_(deviceState){return this.isInstantHotspotRebrandEnabled_&&!!deviceState&&deviceState.type===NetworkType.kTether&&deviceState.deviceState===DeviceStateType.kUninitialized}hideNoNetworksMessage_(networkStateList){return this.shouldShowCellularNetworkList_()||this.shouldShowNetworkList_(networkStateList)}getNoNetworksInnerHtml_(deviceState,_tetherDeviceState){const type=deviceState.type;if(type===NetworkType.kTether&&this.isInstantHotspotRebrandEnabled_){return this.i18n("internetNoTetherHosts")}if(!this.isInstantHotspotRebrandEnabled_&&(type===NetworkType.kCellular&&this.tetherDeviceState||type===NetworkType.kTether)){return this.i18nAdvanced("internetNoNetworksMobileData").toString()}if(type===NetworkType.kVPN){return this.i18n("internetNoNetworks")}return this.hasCompletedScanSinceLastEnabled_?this.i18n("internetNoNetworks"):this.i18n("networkScanningLabel")}getBluetoothDisabledErrorMessageForTether_(){return this.i18n("tetherEnableBluetooth")}showGmsCoreNotificationsSection_(notificationsDisabledDeviceNames){return notificationsDisabledDeviceNames.length>0}getGmsCoreNotificationsDevicesString_(notificationsDisabledDeviceNames){if(notificationsDisabledDeviceNames.length===1){return this.i18n("gmscoreNotificationsOneDeviceSubtitle",notificationsDisabledDeviceNames[0])}if(notificationsDisabledDeviceNames.length===2){return this.i18n("gmscoreNotificationsTwoDevicesSubtitle",notificationsDisabledDeviceNames[0],notificationsDisabledDeviceNames[1])}return this.i18n("gmscoreNotificationsManyDevicesSubtitle")}computeIsShowingVpn_(){if(!this.deviceState){return false}return this.matchesType_(OncMojo.getNetworkTypeString(NetworkType.kVPN),this.deviceState)}computeIsShowingTether_(){return!!this.deviceState&&this.matchesType_(OncMojo.getNetworkTypeString(NetworkType.kTether),this.deviceState)}shouldShowVpnPreferences_(){if(!this.deviceState){return false}return!this.isManaged_&&this.isShowingVpn_}shouldShowTetherNotificationControl_(deviceState){return!!deviceState&&deviceState.type===NetworkType.kTether&&this.isInstantHotspotRebrandEnabled_}shouldShowTetherDeviceListHeader_(deviceState){return!!deviceState&&deviceState.type===NetworkType.kTether&&this.isInstantHotspotRebrandEnabled_}getAlwaysOnVpnNetworks_(){if(!this.deviceState||this.deviceState.type!==NetworkType.kVPN){return[]}const alwaysOnVpnList=this.networkStateList_.slice();for(const vpnList of Object.values(this.thirdPartyVpns_)){assert(vpnList.length>0);if(vpnList[0].typeState.vpn.type===VpnType.kArc||vpnList[0].typeState.vpn.type===VpnType.kExtension){continue}alwaysOnVpnList.push(...vpnList)}return alwaysOnVpnList}async updateAlwaysOnVpnPreferences_(){if(!this.deviceState||this.deviceState.type!==NetworkType.kVPN){return}const result=await this.networkConfig_.getAlwaysOnVpn();this.alwaysOnVpnMode_=result.properties.mode;this.alwaysOnVpnService_=result.properties.serviceGuid}onAlwaysOnVpnChanged_(){if(this.alwaysOnVpnMode_===undefined||this.alwaysOnVpnService_===undefined){return}const properties={mode:this.alwaysOnVpnMode_,serviceGuid:this.alwaysOnVpnService_};this.networkConfig_.setAlwaysOnVpn(properties)}}customElements.define(SettingsInternetSubpageElement.is,SettingsInternetSubpageElement);function getTemplate$26(){return html`<!--_html_template_start_--><style include="settings-shared network-shared">#headlineLink{margin-inline-start:36px}</style>
<div class="settings-box first two-line">
  <localized-link id="headlineLink" class="secondary"
      localized-string="$i18n{passpointHeadlineText}"
      link-url="$i18nRaw{wifiPasspointLearnMoreUrl}">
  </localized-link>
  <cr-button id="removeButton" on-click="onForgetClick_">
    $i18n{passpointRemoveButton}
  </cr-button>
</div>
<template is="dom-if" if="[[hasExpirationDate_(subscription_)]]">
  <div class="settings-box first two-line single-column">
    <div id="passpointExpirationLabel">
      $i18n{passpointSubscriptionExpirationLabel}
    </div>
    <div id="passpointExpirationDate" class="secondary">
      [[getExpirationDate_(subscription_)]]
    </div>
  </div>
</template>
<div class="settings-box two-line single-column">
  <div id="passpointSourceLabel">
    $i18n{passpointSourceLabel}
  </div>
  <div id="passpointSourceText" class="secondary">
    [[providerName_]]
  </div>
</div>
<div class="settings-box two-line single-column">
  <div id="passpointTrustedCALabel">
    $i18n{passpointTrustedCALabel}
  </div>
  <div id="passpointCertificateName" class="secondary">
    [[certificateAuthorityName_]]
  </div>
</div>
<template is="dom-if" if="[[hasNetworks_(networks_)]]">
  <h2 class="settings-box">$i18n{passpointAssociatedWifiNetworks}</h2>
  <div id="passpointNetworksList" class="list-frame vertical-list">
    <template is="dom-repeat" items="[[networks_]]">
      <div class="list-item">
        <cr-link-row embedded label="[[getNetworkDisplayName_(item)]]"
            on-click="onAssociatedNetworkClicked_"
            role-description="$i18n{subpageArrowRoleDescription}">
        </cr-link-row>
      </div>
    </template>
  </div>
</template>
<cr-expand-button aria-label="$i18n{passpointDomainsA11yLabel}"
    class="settings-box" expanded="{{domainsExpanded_}}">
  $i18n{passpointDomainsLabel}
</cr-expand-button>
<div id="passpointDomainsList" class="list-frame vertical-list">
  <iron-collapse opened="[[domainsExpanded_]]">
    <template is="dom-repeat"
        items="[[getPasspointDomainsList_(subscription_)]]">
      <div id="domainName" class="list-item secondary">
        [[item]]
      </div>
    </template>
  </iron-collapse>
</div>
<!-- Removal dialog triggered by the "forget" button -->
<template is="dom-if" if="[[showForgetDialog_]]" restamp>
  <cr-dialog id="removalDialog" close-text="$i18n{close}" show-on-attach>
    <div slot="title">
      $i18nPolymer{passpointRemovalTitle}
    </div>
    <div slot="body">
      <localized-link
          localized-string="[[getRemovalDialogDescription_(subscription_)]]"
          link-url="$i18nRaw{wifiPasspointLearnMoreUrl}">
      </localized-link>
    </div>
    <div slot="button-container">
      <cr-button id="removalCancelButton" class="cancel-button"
          on-click="onRemovalDialogCancel_">
        $i18n{cancel}
      </cr-button>
      <cr-button id="removalConfirmButton" class="action-button"
          on-click="onRemovalDialogConfirm_">
        $i18n{confirm}
      </cr-button>
    </div>
  </cr-dialog>
</template>
<!--_html_template_end_-->`}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class SettingsPasspointSubpageElement extends(PasspointListenerMixin(RouteObserverMixin(I18nMixin(PolymerElement)))){static get is(){return"settings-passpoint-subpage"}static get template(){return getTemplate$26()}static get properties(){return{id_:String,subscription_:Object,app_:Object,certs_:Array,certificateAuthorityName_:{type:String,computed:"getCertificateAuthorityName_(certs_)"},providerName_:{type:String,computed:"getProviderName_(subscription_, app_)"},networks_:{type:Array,value(){return[]}},showForgetDialog_:Boolean,domainsExpanded_:Boolean}}constructor(){super();this.networkConfig_=MojoInterfaceProviderImpl.getInstance().getMojoServiceRemote();this.passpointService_=MojoConnectivityProvider.getInstance().getPasspointService();this.appHandler_=BrowserProxy.getInstance().handler}close(){if(!this.id_){return}this.id_="";Router.getInstance().navigateToPreviousRoute()}currentRouteChanged(route){if(route!==routes.PASSPOINT_DETAIL){return}const queryParams=Router.getInstance().getQueryParameters();const id=queryParams.get("id")||"";if(!id){console.warn("No Passpoint subscription ID specified for page:"+route);this.close();return}this.id_=id;this.refresh_()}async refresh_(){const response=await this.passpointService_.getPasspointSubscription(this.id_);if(!response.result){console.warn("No subscription found for id "+this.id_);this.close();return}this.subscription_=response.result;this.refreshCertificates_();this.refreshApp_(this.subscription_);this.refreshNetworks_(this.subscription_)}async refreshCertificates_(){const certs=await this.networkConfig_.getNetworkCertificates();this.certs_=certs.serverCas}async refreshApp_(subscription){const response=await this.appHandler_.getApps();for(const app of response.apps){if(app.type===AppType.kArc&&app.publisherId===subscription.provisioningSource){this.app_=app;return}}}async refreshNetworks_(subscription){const filter={filter:FilterType.kConfigured,limit:NO_LIMIT,networkType:NetworkType.kWiFi};const response=await this.networkConfig_.getNetworkStateList(filter);this.networks_=response.result.filter((network=>network.typeState.wifi.passpointId===subscription.id))}getCertificateAuthorityName_(){for(const cert of this.certs_){if(cert.pemOrId===this.subscription_.trustedCa){return cert.issuedTo}}return this.i18n("passpointSystemCALabel")}hasExpirationDate_(){return this.subscription_.expirationEpochMs>0n}getExpirationDate_(subscription){const date=new Date(Number(subscription.expirationEpochMs));return date.toLocaleDateString()}getProviderName_(){if(this.app_&&this.app_.title!==undefined){return this.app_.title}return this.subscription_.provisioningSource}getPasspointDomainsList_(){return this.subscription_.domains}getNetworkDisplayName_(networkState){return OncMojo.getNetworkStateDisplayNameUnsafe(networkState)}hasNetworks_(){return this.networks_.length>0}onAssociatedNetworkClicked_(event){const networkState=event.model.item;const showDetailEvent=new CustomEvent("show-detail",{bubbles:true,composed:true,detail:networkState});this.dispatchEvent(showDetailEvent);event.stopPropagation()}getRemovalDialogDescription_(){return this.i18nAdvanced("passpointRemovalDescription",{substitutions:[this.subscription_.friendlyName]})}getRemovalDialog_(){return castExists(this.shadowRoot.querySelector("#removalDialog"))}onForgetClick_(){this.showForgetDialog_=true}async onRemovalDialogConfirm_(){this.showForgetDialog_=false;const response=await this.passpointService_.deletePasspointSubscription(this.id_);if(response.success){this.close();return}}onRemovalDialogCancel_(){this.showForgetDialog_=false}onPasspointSubscriptionRemoved(subscription){if(this.id_===subscription.id){this.close()}}}customElements.define(SettingsPasspointSubpageElement.is,SettingsPasspointSubpageElement);
// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var KerberosErrorType;(function(KerberosErrorType){KerberosErrorType[KerberosErrorType["NONE"]=0]="NONE";KerberosErrorType[KerberosErrorType["UNKNOWN"]=1]="UNKNOWN";KerberosErrorType[KerberosErrorType["D_BUS_FAILURE"]=2]="D_BUS_FAILURE";KerberosErrorType[KerberosErrorType["NETWORK_PROBLEM"]=3]="NETWORK_PROBLEM";KerberosErrorType[KerberosErrorType["UNKNOWN_KRB5_ERROR"]=4]="UNKNOWN_KRB5_ERROR";KerberosErrorType[KerberosErrorType["BAD_PRINCIPAL"]=5]="BAD_PRINCIPAL";KerberosErrorType[KerberosErrorType["BAD_PASSWORD"]=6]="BAD_PASSWORD";KerberosErrorType[KerberosErrorType["PASSWORD_EXPIRED"]=7]="PASSWORD_EXPIRED";KerberosErrorType[KerberosErrorType["PASSWORD_REJECTED"]=8]="PASSWORD_REJECTED";KerberosErrorType[KerberosErrorType["NO_CREDENTIALS_CACHE_FOUND"]=9]="NO_CREDENTIALS_CACHE_FOUND";KerberosErrorType[KerberosErrorType["KERBEROS_TICKET_EXPIRED"]=10]="KERBEROS_TICKET_EXPIRED";KerberosErrorType[KerberosErrorType["KDC_DOES_NOT_SUPPORT_ENCRYPTION_TYPE"]=11]="KDC_DOES_NOT_SUPPORT_ENCRYPTION_TYPE";KerberosErrorType[KerberosErrorType["CONTACTING_KDC_FAILED"]=12]="CONTACTING_KDC_FAILED";KerberosErrorType[KerberosErrorType["PARSE_REQUEST_FAILED"]=13]="PARSE_REQUEST_FAILED";KerberosErrorType[KerberosErrorType["LOCAL_IO"]=14]="LOCAL_IO";KerberosErrorType[KerberosErrorType["UNKNOWN_PRINCIPAL_NAME"]=15]="UNKNOWN_PRINCIPAL_NAME";KerberosErrorType[KerberosErrorType["DUPLICATE_PRINCIPAL_NAME"]=16]="DUPLICATE_PRINCIPAL_NAME";KerberosErrorType[KerberosErrorType["IN_PROGRESS"]=17]="IN_PROGRESS";KerberosErrorType[KerberosErrorType["PARSE_PRINCIPAL_FAILED"]=18]="PARSE_PRINCIPAL_FAILED";KerberosErrorType[KerberosErrorType["BAD_CONFIG"]=19]="BAD_CONFIG";KerberosErrorType[KerberosErrorType["JAIL_FAILURE"]=20]="JAIL_FAILURE";KerberosErrorType[KerberosErrorType["KERBEROS_DISABLED"]=21]="KERBEROS_DISABLED"})(KerberosErrorType||(KerberosErrorType={}));var KerberosConfigErrorCode;(function(KerberosConfigErrorCode){KerberosConfigErrorCode[KerberosConfigErrorCode["NONE"]=0]="NONE";KerberosConfigErrorCode[KerberosConfigErrorCode["SECTION_NESTED_IN_GROUP"]=1]="SECTION_NESTED_IN_GROUP";KerberosConfigErrorCode[KerberosConfigErrorCode["SECTION_SYNTAX"]=2]="SECTION_SYNTAX";KerberosConfigErrorCode[KerberosConfigErrorCode["EXPECTED_OPENING_CURLY_BRACE"]=3]="EXPECTED_OPENING_CURLY_BRACE";KerberosConfigErrorCode[KerberosConfigErrorCode["EXTRA_CURLY_BRACE"]=4]="EXTRA_CURLY_BRACE";KerberosConfigErrorCode[KerberosConfigErrorCode["RELATION_SYNTAX"]=5]="RELATION_SYNTAX";KerberosConfigErrorCode[KerberosConfigErrorCode["KEY_NOT_SUPPORTED"]=6]="KEY_NOT_SUPPORTED";KerberosConfigErrorCode[KerberosConfigErrorCode["SECTION_NOT_SUPPORTED"]=7]="SECTION_NOT_SUPPORTED";KerberosConfigErrorCode[KerberosConfigErrorCode["KRB5_FAILED_TO_PARSE"]=8]="KRB5_FAILED_TO_PARSE";KerberosConfigErrorCode[KerberosConfigErrorCode["TOO_MANY_NESTED_GROUPS"]=9]="TOO_MANY_NESTED_GROUPS";KerberosConfigErrorCode[KerberosConfigErrorCode["LINE_TOO_LONG"]=10]="LINE_TOO_LONG"})(KerberosConfigErrorCode||(KerberosConfigErrorCode={}));let instance$8=null;class KerberosAccountsBrowserProxyImpl{static getInstance(){return instance$8||(instance$8=new KerberosAccountsBrowserProxyImpl)}static setInstanceForTesting(obj){instance$8=obj}getAccounts(){return sendWithPromise("getKerberosAccounts")}addAccount(principalName,password,rememberPassword,config,allowExisting){return sendWithPromise("addKerberosAccount",principalName,password,rememberPassword,config,allowExisting)}removeAccount(account){return sendWithPromise("removeKerberosAccount",account.principalName)}validateConfig(krb5conf){return sendWithPromise("validateKerberosConfig",krb5conf)}setAsActiveAccount(account){chrome.send("setAsActiveKerberosAccount",[account.principalName])}}function getTemplate$25(){return html`<!--_html_template_start_--><style include="settings-shared action-link">#advancedConfigDesc{align-items:center;display:flex}#advancedConfigPolicyIndicator{margin-inline-start:1em}#credentials{margin-top:16px}#credentials>*:not(:last-child){margin-bottom:var(--cr-form-field-bottom-spacing)}#general-error-container{display:flex;height:56px}#config-error-container{display:flex;height:40px;margin-top:16px}#general-error-message,#config-error-message{color:var(--settings-error-color)}iron-icon[icon='cr:error']{fill:var(--settings-error-color);margin-inline-end:8px}#rememberPasswordContainer{align-items:center;display:flex;margin-bottom:32px}#rememberPassword{margin-inline-end:1em}#kerberosDomain{color:var(--cros-text-color-primary);padding-inline-end:8px;white-space:nowrap}h3{font-size:inherit;font-weight:500;margin-block-end:12px;margin-block-start:0}</style>

<cr-dialog id="addDialog" hidden="[[showAdvancedConfig_]]">
  <div slot="title">[[title_]]</div>

  <div slot="body" spellcheck="false">
    <h3 class="start first">
      $i18n{addKerberosAccountDescription}
    </h3>

    <div id="general-error-container"
        hidden="[[!showError_(generalErrorText_)]]">
      <iron-icon id="error-icon" icon="cr:error"></iron-icon>
      <div id="general-error-message">[[generalErrorText_]]</div>
    </div>

    <div id="credentials">
      <cr-input id="username" label="$i18n{kerberosUsername}"
          value="{{username_}}" invalid="[[showError_(usernameErrorText_)]]"
          placeholder="[[computePlaceholder_(prefillDomain_)]]"
          error-message="[[usernameErrorText_]]">
          <span id ="kerberosDomain" slot="inline-suffix">
            [[computeDomain_(username_, prefillDomain_)]]
          </span>
      </cr-input>

      <cr-input id="password" type="password"
          label="$i18n{kerberosPassword}" value="{{password_}}"
          invalid="[[showError_(passwordErrorText_)]]"
          error-message="[[passwordErrorText_]]"
          on-input="onPasswordInput_">
      </cr-input>

      <div id="rememberPasswordContainer" hidden="[[isGuestMode_]]">
        <cr-checkbox id="rememberPassword"
            checked="{{rememberPasswordChecked_}}"
            disabled="[[!rememberPasswordEnabledByPolicy_]]">
          $i18n{addKerberosAccountRememberPassword}
        </cr-checkbox>
        <template is="dom-if" if="[[!rememberPasswordEnabledByPolicy_]]">
          <cr-policy-indicator id="rememberPasswordPolicyIndicator"
              indicator-type="userPolicy">
          </cr-policy-indicator>
        </template>
      </div>

      <a is="action-link" id="advancedConfigButton"
          on-click="onAdvancedConfigClick_">
        $i18n{kerberosAccountsAdvancedConfigLabel}
      </a>
    </div>
  </div>

  <div slot="button-container">
    <cr-button class="cancel-button" on-click="onCancel_" id="cancel">
      $i18n{cancel}
    </cr-button>
    <cr-button class="action-button" on-click="onAdd_"
        disabled="[[inProgress_]]">
      [[actionButtonLabel_]]
    </cr-button>
  </div>
</cr-dialog>

<template is="dom-if" if="[[showAdvancedConfig_]]" restamp>
  <cr-dialog id="advancedConfigDialog" on-close="onAdvancedConfigClose_">
    <div slot="title">$i18n{kerberosAdvancedConfigTitle}</div>

    <div slot="body">
      <h3 class="first" id="advancedConfigDesc">
        $i18n{kerberosAdvancedConfigDesc}
        <template is="dom-if" if="[[isManaged_]]">
          <cr-policy-indicator id="advancedConfigPolicyIndicator"
              indicator-type="userPolicy">
          </cr-policy-indicator>
        </template>
      </h3>

      <cr-textarea id="config" value="{{editableConfig_}}" rows=12
          spellcheck="false" disabled="[[isManaged_]]">
      </cr-textarea>

      <div id="config-error-container"
          hidden="[[!showError_(configErrorText_)]]">
        <iron-icon id="error-icon" icon="cr:error"></iron-icon>
        <div id="config-error-message">[[configErrorText_]]</div>
      </div>
    </div>

    <div slot="button-container">
      <cr-button class="cancel-button"
          on-click="onAdvancedConfigCancel_">
        $i18n{cancel}
      </cr-button>
      <cr-button class="action-button" on-click="onAdvancedConfigSave_"
          disabled="[[inProgress_]]">
        $i18n{save}
      </cr-button>
    </div>
  </cr-dialog>
</template>
<!--_html_template_end_-->`}
// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const DEFAULT_USERNAME_PLACEHOLDER="user@example.com";const KerberosAddAccountDialogElementBase=I18nMixin(PolymerElement);class KerberosAddAccountDialogElement extends KerberosAddAccountDialogElementBase{static get is(){return"kerberos-add-account-dialog"}static get template(){return getTemplate$25()}static get properties(){return{presetAccount:Object,accountWasRefreshed:{type:Boolean,value:false},username_:{type:String,value:""},password_:{type:String,value:""},editableConfig_:{type:String,value:""},generalErrorText_:{type:String,value:""},usernameErrorText_:{type:String,value:""},passwordErrorText_:{type:String,value:""},configErrorText_:{type:String,value:""},inProgress_:{type:Boolean,value:false},isManaged_:{type:Boolean,value:false},showAdvancedConfig_:{type:Boolean,value:false},rememberPasswordByDefault_:{type:Boolean,value(){return loadTimeData.getBoolean("kerberosRememberPasswordByDefault")}},rememberPasswordEnabledByPolicy_:{type:Boolean,value(){return loadTimeData.getBoolean("kerberosRememberPasswordEnabled")}},prefillDomain_:{type:String,value:""},isGuestMode_:{type:Boolean,value(){return loadTimeData.getBoolean("isGuest")}}}}constructor(){super();this.useStoredPassword_=false;this.rememberPasswordChecked_=this.rememberPasswordByDefault_&&this.rememberPasswordEnabledByPolicy_&&!this.isGuestMode_;this.config_="";this.title_="";this.actionButtonLabel_="";this.browserProxy_=KerberosAccountsBrowserProxyImpl.getInstance()}connectedCallback(){super.connectedCallback();this.$.addDialog.showModal();if(this.presetAccount){this.title_=this.i18n("refreshKerberosAccount");this.actionButtonLabel_=this.i18n("addKerberosAccountRefreshButtonLabel");this.username_=this.presetAccount.principalName;this.isManaged_=this.presetAccount.isManaged;this.$.username.readonly=true;this.$.password.focus();if(this.presetAccount.passwordWasRemembered&&this.rememberPasswordEnabledByPolicy_){const FAKE_PASSWORD="xxxxxxxx";this.password_=FAKE_PASSWORD;this.rememberPasswordChecked_=true;this.useStoredPassword_=true}this.config_=this.presetAccount.config}else{this.title_=this.i18n("addKerberosAccount");this.actionButtonLabel_=this.i18n("add");const domain=loadTimeData.getString("kerberosDomainAutocomplete");if(domain&&domain.indexOf("@")===-1){this.prefillDomain_="@"+domain}this.config_=loadTimeData.getString("defaultKerberosConfig")}}onCancel_(){this.$.addDialog.cancel()}onAdd_(){assert(!this.inProgress_);this.inProgress_=true;this.usernameErrorText_="";this.passwordErrorText_="";const passwordToSubmit=this.useStoredPassword_?"":this.password_;const allowExisting=!!this.presetAccount;this.browserProxy_.addAccount(this.computeUsername_(this.username_,this.prefillDomain_),passwordToSubmit,this.rememberPasswordChecked_,this.config_,allowExisting).then((error=>{this.inProgress_=false;if(error===KerberosErrorType.NONE){this.accountWasRefreshed=this.presetAccount!=null;this.$.addDialog.close();recordSettingChange(Setting.kAddKerberosTicketV2);return}this.updateErrorMessages_(error)}))}onPasswordInput_(){this.useStoredPassword_=false}getAdvancedConfigDialog(){return castExists(this.shadowRoot.querySelector("#advancedConfigDialog"))}onAdvancedConfigClick_(){this.browserProxy_.validateConfig(this.config_).then((result=>{if(result.error===KerberosErrorType.NONE){this.configErrorText_="";return}this.updateConfigErrorMessage_(result)}));this.editableConfig_=this.config_;this.showAdvancedConfig_=true;flush();this.getAdvancedConfigDialog().showModal()}onAdvancedConfigCancel_(){this.configErrorText_="";this.showAdvancedConfig_=false;this.getAdvancedConfigDialog().cancel()}onAdvancedConfigSave_(){assert(!this.inProgress_);this.inProgress_=true;this.browserProxy_.validateConfig(this.editableConfig_).then((result=>{this.inProgress_=false;if(result.error===KerberosErrorType.NONE){this.showAdvancedConfig_=false;this.config_=this.editableConfig_;this.configErrorText_="";this.getAdvancedConfigDialog().close();return}this.updateConfigErrorMessage_(result)}))}onAdvancedConfigClose_(event){this.showAdvancedConfig_=false;event.stopPropagation()}updateErrorMessages_(error){this.generalErrorText_="";this.usernameErrorText_="";this.passwordErrorText_="";switch(error){case KerberosErrorType.NONE:break;case KerberosErrorType.NETWORK_PROBLEM:this.generalErrorText_=this.i18n("kerberosErrorNetworkProblem");break;case KerberosErrorType.PARSE_PRINCIPAL_FAILED:this.usernameErrorText_=this.i18n("kerberosErrorUsernameInvalid");break;case KerberosErrorType.BAD_PRINCIPAL:this.usernameErrorText_=this.i18n("kerberosErrorUsernameUnknown");break;case KerberosErrorType.DUPLICATE_PRINCIPAL_NAME:this.usernameErrorText_=this.i18n("kerberosErrorDuplicatePrincipalName");break;case KerberosErrorType.CONTACTING_KDC_FAILED:this.usernameErrorText_=this.i18n("kerberosErrorContactingServer");break;case KerberosErrorType.BAD_PASSWORD:this.passwordErrorText_=this.i18n("kerberosErrorPasswordInvalid");break;case KerberosErrorType.PASSWORD_EXPIRED:this.passwordErrorText_=this.i18n("kerberosErrorPasswordExpired");break;case KerberosErrorType.KDC_DOES_NOT_SUPPORT_ENCRYPTION_TYPE:this.generalErrorText_=this.i18n("kerberosErrorKdcEncType");break;default:this.generalErrorText_=this.i18n("kerberosErrorGeneral",error.toString())}}updateConfigErrorMessage_(result){assert(result.error!==KerberosErrorType.NONE);if(result.error!==KerberosErrorType.BAD_CONFIG){this.configErrorText_=this.i18n("kerberosErrorGeneral",result.error.toString());return}let errorLine="";if(result.errorInfo.lineIndex!==undefined){const textArea=castExists(this.shadowRoot.querySelector("#config").shadowRoot.querySelector("#input"));errorLine=this.selectAndScrollTo_(textArea,result.errorInfo.lineIndex)}assert(result.errorInfo.code!==KerberosConfigErrorCode.NONE);this.configErrorText_=this.getConfigErrorString_(result.errorInfo.code,errorLine)}getConfigErrorString_(code,errorLine){switch(code){case KerberosConfigErrorCode.SECTION_NESTED_IN_GROUP:return this.i18n("kerberosConfigErrorSectionNestedInGroup",errorLine);case KerberosConfigErrorCode.SECTION_SYNTAX:return this.i18n("kerberosConfigErrorSectionSyntax",errorLine);case KerberosConfigErrorCode.EXPECTED_OPENING_CURLY_BRACE:return this.i18n("kerberosConfigErrorExpectedOpeningCurlyBrace",errorLine);case KerberosConfigErrorCode.EXTRA_CURLY_BRACE:return this.i18n("kerberosConfigErrorExtraCurlyBrace",errorLine);case KerberosConfigErrorCode.RELATION_SYNTAX:return this.i18n("kerberosConfigErrorRelationSyntax",errorLine);case KerberosConfigErrorCode.KEY_NOT_SUPPORTED:return this.i18n("kerberosConfigErrorKeyNotSupported",errorLine);case KerberosConfigErrorCode.SECTION_NOT_SUPPORTED:return this.i18n("kerberosConfigErrorSectionNotSupported",errorLine);case KerberosConfigErrorCode.KRB5_FAILED_TO_PARSE:return this.i18n("kerberosConfigErrorKrb5FailedToParse");case KerberosConfigErrorCode.TOO_MANY_NESTED_GROUPS:return this.i18n("kerberosConfigErrorTooManyNestedGroups",errorLine);case KerberosConfigErrorCode.LINE_TOO_LONG:return this.i18n("kerberosConfigErrorLineTooLong",errorLine);default:assertNotReached()}}selectAndScrollTo_(textArea,lineIndex){const lines=textArea.value.split("\n");assert(lineIndex>=0&&lineIndex<lines.length);let startPos=0;for(let i=0;i<lineIndex;i++){startPos+=lines[i].length+1}const trimmedLine=lines[lineIndex].trim();startPos+=lines[lineIndex].indexOf(trimmedLine);const endPos=startPos+trimmedLine.length;textArea.focus();textArea.setSelectionRange(startPos,endPos);const lineHeight=textArea.clientHeight/textArea.rows;const firstLine=Math.max(0,lineIndex-textArea.rows/2);textArea.scrollTop=lineHeight*firstLine;return lines[lineIndex]}showError_(errorText){return!!errorText}computeDomain_(username,domain){if(username&&username.indexOf("@")!==-1){return""}return domain}computeUsername_(username,domain){if(username&&username.indexOf("@")===-1){return username+domain}return username}computePlaceholder_(prefillDomain){if(prefillDomain){return""}return DEFAULT_USERNAME_PLACEHOLDER}}customElements.define(KerberosAddAccountDialogElement.is,KerberosAddAccountDialogElement);function getTemplate$24(){return html`<!--_html_template_start_--><style include="settings-shared iron-flex iron-flex-alignment">.account-icon{background:center no-repeat;border-radius:20px;flex-shrink:0;height:40px;width:40px}#outer{margin-inline-end:var(--cr-section-padding);margin-inline-start:60px}#account-list-header{padding-bottom:1em}.account-toolbar,#remove-account-policy-indicator{margin-inline-start:1em}#add-account-policy-indicator{margin-inline-end:1em}#addAccountIcon{-webkit-mask-image:url(chrome://resources/images/add.svg);background-color:currentColor;height:24px;width:24px}#remove-account-container{align-items:center;display:flex}.error-badge{left:60%;position:relative;top:60%}.warning{color:var(--cros-text-color-alert)}:host-context([dir='rtl']) .error-badge{left:auto;right:60%}</style>

<iron-media-query query="(prefers-color-scheme: dark)"
  query-matches="{{isDarkModeActive_}}">
</iron-media-query>

<div class="settings-box first">
  <h2 class="first">
    <!-- Inner div needed to get spacing right in front of 'Learn more'. -->
    <div inner-h-t-m-l="[[i18nAdvanced('kerberosAccountsDescription')]]">
    </div>
  </h2>
</div>

<div class="settings-box first">
  <div id="account-list-header" class="flex">
    <h2>$i18n{kerberosAccountsListHeader}</h2>
  </div>
  <template is="dom-if" if="[[!addAccountsAllowed_]]">
    <cr-policy-indicator id="add-account-policy-indicator"
        indicator-type="userPolicy">
    </cr-policy-indicator>
  </template>
  <cr-button id="add-account-button" on-click="onAddAccountClick_"
      disabled="[[!addAccountsAllowed_]]"
      deep-link-focus-id$="[[Setting.kAddKerberosTicketV2]]">
    <div id="addAccountIcon" slot="prefix-icon"></div>
    $i18n{kerberosAccountsAddAccountLabel}
  </cr-button>
</div>

<div id="outer" class="layout vertical nowrap">
  <template is="dom-repeat" id="account-list" items="[[accounts_]]">
    <div class="settings-box account-list-item">

      <div class="account-icon"
          style="background-image: [[getIconImageSet_(item.pic)]]">
        <img class="error-badge" hidden$="[[item.isSignedIn]]"
            src="[[getErrorBadgeIcon_(isDarkModeActive_)]]">
      </div>

      <div class="middle two-line no-min-width">
        <div class="flex text-elide">
          <span>[[item.principalName]]</span>

          <div class="secondary signed-in" hidden$="[[!item.isSignedIn]]">
            [[i18n('kerberosAccountsSignedIn', item.validForDuration)]]
          </div>
          <div class="secondary warning signed-out"
              hidden$="[[item.isSignedIn]]">
            $i18n{kerberosAccountsSignedOut}
          </div>
        </div>
      </div>

      <div class="secondary account-toolbar active-indicator"
          hidden$="[[!item.isActive]]">
        $i18n{kerberosAccountsTicketActive}
      </div>

      <cr-button class="account-toolbar reauth-button"
          hidden$="[[item.isSignedIn]]"
          on-click="onReauthenticationClick_">
        $i18n{kerberosAccountsReauthenticationLabel}
      </cr-button>

      <template is="dom-if" if="[[item.isManaged]]">
        <cr-policy-indicator indicator-type="userPolicy"
            class="account-toolbar account-policy-indicator">
        </cr-policy-indicator>
      </template>

      <!-- Hamburger menu -->
      <cr-icon-button class="icon-more-vert more-actions"
          title="$i18n{moreActions}"
          on-click="onAccountActionsMenuButtonClick_"
          deep-link-focus-id$="[[Setting.kRemoveKerberosTicketV2]]
              [[Setting.kSetActiveKerberosTicketV2]]">
      </cr-icon-button>
    </div>
  </template>

  <div class="clear settings-box"></div>

  <cr-action-menu role-description="$i18n{menu}">
  <button class="dropdown-item" on-click="onRefreshNowClick_">
    $i18n{kerberosAccountsRefreshNowLabel}
  </button>
  <button class="dropdown-item" on-click="onSetAsActiveAccountClick_">
    $i18n{kerberosAccountsSetAsActiveAccountLabel}
  </button>
  <button class="dropdown-item" on-click="onRemoveAccountClick_"
      disabled="[[selectedAccount_.isManaged]]">
    <div id="remove-account-container">
      $i18n{kerberosAccountsRemoveAccountLabel}
      <template is="dom-if" if="[[selectedAccount_.isManaged]]">
        <cr-policy-indicator id="remove-account-policy-indicator"
            indicator-type="userPolicy">
        </cr-policy-indicator>
      </template>
    </div>
  </button>
  </cr-action-menu>
</div>

<cr-toast id="account-toast" duration="3000">
  <!-- Gets displayed with black font without div and id :-/ -->
  <div id="account-toast-label">[[accountToastText_]]</div>
</cr-toast>

<template is="dom-if" if="[[showAddAccountDialog_]]" restamp>
  <kerberos-add-account-dialog preset-account="[[selectedAccount_]]"
    on-close="onAddAccountDialogClosed_">
  </kerberos-add-account-dialog>
</template>
<!--_html_template_end_-->`}
// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsKerberosAccountsSubpageElementBase=DeepLinkingMixin(RouteObserverMixin(WebUiListenerMixin(I18nMixin(PolymerElement))));class SettingsKerberosAccountsSubpageElement extends SettingsKerberosAccountsSubpageElementBase{static get is(){return"settings-kerberos-accounts-subpage"}static get template(){return getTemplate$24()}static get properties(){return{accounts_:{type:Array,value(){return[]}},isDarkModeActive_:{type:Boolean,value:false},selectedAccount_:Object,showAddAccountDialog_:Boolean,addAccountsAllowed_:{type:Boolean,value(){return loadTimeData.getBoolean("kerberosAddAccountsAllowed")}},accountToastText_:{type:String,value:""}}}constructor(){super();this.supportedSettingIds=new Set([Setting.kAddKerberosTicketV2,Setting.kRemoveKerberosTicketV2,Setting.kSetActiveKerberosTicketV2]);this.browserProxy_=KerberosAccountsBrowserProxyImpl.getInstance()}connectedCallback(){super.connectedCallback();this.addWebUiListener("kerberos-accounts-changed",this.refreshAccounts_.bind(this))}ready(){super.ready();this.refreshAccounts_().then((()=>{const queryParams=Router.getInstance().getQueryParameters();const reauthPrincipal=queryParams.get("kerberos_reauth");const reauthAccount=this.accounts_.find((account=>account.principalName===reauthPrincipal));if(reauthAccount){this.selectedAccount_=reauthAccount;this.showAddAccountDialog_=true}}))}currentRouteChanged(route){if(route!==routes.KERBEROS_ACCOUNTS_V2){return}this.attemptDeepLink()}getErrorBadgeIcon_(){return this.isDarkModeActive_?"chrome://os-settings/images/error_badge_dark.svg":"chrome://os-settings/images/error_badge.svg"}getIconImageSet_(iconUrl){return getImage(iconUrl)}onAddAccountClick_(){this.selectedAccount_=null;this.showAddAccountDialog_=true}onReauthenticationClick_(event){this.selectedAccount_=event.model.item;this.showAddAccountDialog_=true}onAddAccountDialogClosed_(){if(this.shadowRoot.querySelector("kerberos-add-account-dialog").accountWasRefreshed){this.showToast_("kerberosAccountsAccountRefreshedTip")}this.showAddAccountDialog_=false;this.closeActionMenu_()}refreshAccounts_(){return this.browserProxy_.getAccounts().then((accounts=>{this.accounts_=accounts}))}onAccountActionsMenuButtonClick_(event){this.selectedAccount_=event.model.item;const target=cast(event.target,HTMLElement);this.shadowRoot.querySelector("cr-action-menu").showAt(target)}closeActionMenu_(){this.shadowRoot.querySelector("cr-action-menu").close();this.selectedAccount_=null}onRemoveAccountClick_(){this.browserProxy_.removeAccount(castExists(this.selectedAccount_)).then((error=>{if(error===KerberosErrorType.NONE){this.showToast_("kerberosAccountsAccountRemovedTip");recordSettingChange(Setting.kRemoveKerberosTicketV2)}else{console.error("Unexpected error removing account: "+error)}}));this.closeActionMenu_()}onSetAsActiveAccountClick_(){this.browserProxy_.setAsActiveAccount(castExists(this.selectedAccount_));recordSettingChange(Setting.kSetActiveKerberosTicketV2);this.closeActionMenu_()}onRefreshNowClick_(){this.showAddAccountDialog_=true}showToast_(label){this.accountToastText_=this.i18n(label);this.shadowRoot.querySelector("#account-toast").show()}}customElements.define(SettingsKerberosAccountsSubpageElement.is,SettingsKerberosAccountsSubpageElement);function getTemplate$23(){return html`<!--_html_template_start_--><style include="settings-shared">:host([is-sub-feature]) #feature-icon{display:none}:host([is-sub-feature]) .settings-box .middle{padding-inline-start:64px}#card{border-top:var(--cr-separator-line);border-top-style:var(--feature-item-border-top-style,solid);padding:var(--cr-section-vertical-padding) 0}#feature-icon{padding:2px}cr-policy-indicator{padding:0 var(--cr-controlled-by-spacing)}#help-icon:active{pointer-events:none}</style>
<div id="card" class="settings-box no-padding">
  <div id="linkWrapper" class="link-wrapper"
        actionable$="[[isRowClickable_(
            feature, pageContentData, subpageRoute)]]"
        on-click="handleItemClick_">
    <template is="dom-if" if="[[!isFeatureIconHidden]]">
      <slot name="icon">
        <iron-icon id="feature-icon" icon="[[getIconName(feature)]]"
            aria-hidden="true">
        </iron-icon>
      </slot>
    </template>
    <div id="item-text-container"
      class$="[[getItemTextContainerClassName_(isFeatureIconHidden)]]"
      aria-hidden="true">
      <slot name="feature-name">
        <div id="featureName">[[getFeatureName(feature)]]</div>
      </slot>
      <slot name="feature-summary">
        <localized-link
            class="secondary"
            id="featureSecondary"
            localized-string="[[getFeatureSummaryHtml(feature)]]">
        </localized-link>
      </slot>
    </div>
    <template is="dom-if"
        if="[[hasSubpageClickHandler_(feature, pageContentData,
                  subpageRoute)]]"
              restamp>
      <cr-icon-button id="subpageButton" class="subpage-arrow"
          aria-labelledby="featureName" aria-describedby="featureSecondary"
          aria-roledescription="$i18n{subpageArrowRoleDescription}">
      </cr-icon-button>
    </template>
    <template is="dom-if" if="[[iconTooltip]]" restamp>
      <iron-icon id="help-icon" tabindex="0" icon="[[icon]]"
          aria-labelledby="tooltip" aria-disabled="true">
      </iron-icon>
      <paper-tooltip id="tooltip" for="help-icon" position="top"
          aria-hidden="true" fit-to-visible-bounds>
        [[iconTooltip]]
      </paper-tooltip>
    </template>
  </div>
  <template is="dom-if"
      if="[[shouldShowSeparator_(
                feature, pageContentData, subpageRoute)]]"
            restamp>
    <div class="separator"></div>
  </template>

  <template is="dom-if"
      if="[[!isFeatureAllowedByPolicy(feature, pageContentData)]]"
      restamp>
    <cr-policy-indicator indicator-type="userPolicy"></cr-policy-indicator>
  </template>
  <div class="margin-matches-padding" aria-labelledby="featureName"
      aria-describedby="featureSecondary">
    <!-- The aria-labelledby and aria-describedby are used by custom slotted
    content, without which ChromeVox will not announce the #featureName
    or #featureSummary. Note that the default slotted content still needs
    their own aria-labelledby and aria-describedby attributes. -->
    <slot name="feature-controller">
      <!-- This settings-multidevice-feature-toggle is the default
      controller. If an element with slot="feature-controller" is attached,
      it will replace this one. -->
      <settings-multidevice-feature-toggle
          aria-labelledby="featureName"
          aria-describedby="featureSecondary"
          feature="[[feature]]"
          page-content-data="[[pageContentData]]">
      </settings-multidevice-feature-toggle>
    </slot>
  </div>
</div>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var SmartLockToggleLocation;(function(SmartLockToggleLocation){SmartLockToggleLocation[SmartLockToggleLocation["MULTIDEVICE_PAGE"]=0]="MULTIDEVICE_PAGE";SmartLockToggleLocation[SmartLockToggleLocation["LOCK_SCREEN_SETTINGS"]=1]="LOCK_SCREEN_SETTINGS"})(SmartLockToggleLocation||(SmartLockToggleLocation={}));var SmartLockToggle;(function(SmartLockToggle){SmartLockToggle[SmartLockToggle["ENABLED_ON_MULTIDEVICE_PAGE"]=0]="ENABLED_ON_MULTIDEVICE_PAGE";SmartLockToggle[SmartLockToggle["DISABLED_ON_MULTIDEVICE_PAGE"]=1]="DISABLED_ON_MULTIDEVICE_PAGE";SmartLockToggle[SmartLockToggle["ENABLED_ON_LOCK_SCREEN_SETTINGS"]=2]="ENABLED_ON_LOCK_SCREEN_SETTINGS";SmartLockToggle[SmartLockToggle["DISABLED_ON_LOCK_SCREEN_SETTINGS"]=3]="DISABLED_ON_LOCK_SCREEN_SETTINGS";SmartLockToggle[SmartLockToggle["MAX"]=4]="MAX"})(SmartLockToggle||(SmartLockToggle={}));const SMART_LOCK_TOGGLE_HISTOGRAM_NAME="SmartLock.Toggle";function recordSmartLockToggleMetric(smartLockToggleLocation,enabled){chrome.send("metricsHandler:recordInHistogram",[SMART_LOCK_TOGGLE_HISTOGRAM_NAME,getSmartLockToggleValue(smartLockToggleLocation,enabled),SmartLockToggle.MAX])}function getSmartLockToggleValue(smartLockToggleLocation,enabled){switch(smartLockToggleLocation){case SmartLockToggleLocation.MULTIDEVICE_PAGE:return enabled?SmartLockToggle.ENABLED_ON_MULTIDEVICE_PAGE:SmartLockToggle.DISABLED_ON_MULTIDEVICE_PAGE;case SmartLockToggleLocation.LOCK_SCREEN_SETTINGS:return enabled?SmartLockToggle.ENABLED_ON_LOCK_SCREEN_SETTINGS:SmartLockToggle.DISABLED_ON_LOCK_SCREEN_SETTINGS;default:assertNotReached("Invalid smartLockToggleLocation")}}
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsMultideviceFeatureItemElementBase=MultiDeviceFeatureMixin(RouteOriginMixin(PolymerElement));class SettingsMultideviceFeatureItemElement extends SettingsMultideviceFeatureItemElementBase{static get is(){return"settings-multidevice-feature-item"}static get template(){return getTemplate$23()}static get properties(){return{feature:Number,subpageRoute:Object,iconTooltip:String,icon:{type:String,value:"cr:info-outline"},subpageRouteUrlSearchParams:Object,isSubFeature:{type:Boolean,value:false,reflectToAttribute:true},isFeatureIconHidden:{type:Boolean,value:false}}}constructor(){super();this.route=routes.MULTIDEVICE_FEATURES}ready(){super.ready();this.addEventListener("feature-toggle-clicked",this.onFeatureToggleClicked_);this.addFocusConfig(this.subpageRoute,"#subpageButton")}focus(){const slot=castExists(this.shadowRoot.querySelector('slot[name="feature-controller"]'));const elems=slot.assignedElements({flatten:true});assert(elems.length>0);elems[0].focus()}isRowClickable_(){return this.hasSubpageClickHandler_()||this.isFeatureStateEditable(this.feature)}hasSubpageClickHandler_(){return!!this.subpageRoute&&this.isFeatureAllowedByPolicy(this.feature)}shouldShowSeparator_(){return this.hasSubpageClickHandler_()||!!this.iconTooltip}handleItemClick_(event){if(event.composedPath()[0].tagName==="A"){event.stopPropagation();return}if(!this.hasSubpageClickHandler_()){if(this.isFeatureStateEditable(this.feature)){const toggleButton=castExists(this.shadowRoot.querySelector("settings-multidevice-feature-toggle"));toggleButton.toggleFeature()}return}assert(this.subpageRoute);Router.getInstance().navigateTo(this.subpageRoute,this.subpageRouteUrlSearchParams,true)}getItemTextContainerClassName_(isFeatureIconHidden){return isFeatureIconHidden?"start":"middle"}onFeatureToggleClicked_(event){const feature=event.detail.feature;const enabled=event.detail.enabled;if(feature===MultiDeviceFeature.SMART_LOCK){const toggleLocation=Router.getInstance().currentRoute.contains(routes.LOCK_SCREEN)?SmartLockToggleLocation.LOCK_SCREEN_SETTINGS:SmartLockToggleLocation.MULTIDEVICE_PAGE;recordSmartLockToggleMetric(toggleLocation,enabled)}}}customElements.define(SettingsMultideviceFeatureItemElement.is,SettingsMultideviceFeatureItemElement);function getTemplate$22(){return html`<!--_html_template_start_--><style include="settings-shared">cr-button{white-space:nowrap}</style>
<settings-multidevice-feature-item id="phoneHubCombinedSetupItem"
    page-content-data="[[pageContentData]]" is-sub-feature>
  <div id="featureName" slot="feature-name">
    [[setupName_]]
  </div>
  <localized-link
      class="secondary"
      id="featureSecondary"
      slot="feature-summary"
      localized-string="[[setupSummary_]]">
  </localized-link>
  <cr-button
      slot="feature-controller"
      on-click="handlePhoneHubSetupClick_"
      aria-labelledby="featureName"
      aria-describedby="featureSecondary"
      disabled="[[getButtonDisabledState_(pageContentData)]]">
    $i18n{multideviceSetupButton}
  </cr-button>
</settings-multidevice-feature-item>
<!--_html_template_end_-->`}
// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsMultideviceCombinedSetupItemElementBase=MultiDeviceFeatureMixin(PolymerElement);class SettingsMultideviceCombinedSetupItemElement extends SettingsMultideviceCombinedSetupItemElementBase{static get is(){return"settings-multidevice-combined-setup-item"}static get template(){return getTemplate$22()}static get properties(){return{cameraRoll:{type:Boolean,value:false},notifications:{type:Boolean,value:false},appStreaming:{type:Boolean,value:false},setupName_:{type:String,computed:"getSetupName_(cameraRoll, notifications, appStreaming)",reflectToAttribute:true},setupSummary_:{type:String,computed:"getSetupSummary_(cameraRoll, notifications, appStreaming)",reflectToAttribute:true}}}constructor(){super();this.browserProxy_=MultiDeviceBrowserProxyImpl.getInstance()}getSetupName_(){if(this.cameraRoll&&this.notifications&&this.appStreaming){return this.i18n("multidevicePhoneHubCameraRollNotificationsAndAppsItemTitle")}if(this.cameraRoll&&this.notifications){return this.i18n("multidevicePhoneHubCameraRollAndNotificationsItemTitle")}if(this.cameraRoll&&this.appStreaming){return this.i18n("multidevicePhoneHubCameraRollAndAppsItemTitle")}if(this.notifications&&this.appStreaming){return this.i18n("multidevicePhoneHubAppsAndNotificationsItemTitle")}return""}getSetupSummary_(){if(this.cameraRoll&&this.notifications&&this.appStreaming){return this.i18n("multidevicePhoneHubCameraRollNotificationsAndAppsItemSummary")}if(this.cameraRoll&&this.notifications){return this.i18n("multidevicePhoneHubCameraRollAndNotificationsItemSummary")}if(this.cameraRoll&&this.appStreaming){return this.i18n("multidevicePhoneHubCameraRollAndAppsItemSummary")}if(this.notifications&&this.appStreaming){return this.i18n("multidevicePhoneHubAppsAndNotificationsItemSummary")}return""}handlePhoneHubSetupClick_(){const permissionSetupRequiredEvent=new CustomEvent("permission-setup-requested",{bubbles:true,composed:true});this.dispatchEvent(permissionSetupRequiredEvent);let setupMode=PhoneHubPermissionsSetupFeatureCombination.NONE;if(this.cameraRoll&&this.notifications&&this.appStreaming){setupMode=PhoneHubPermissionsSetupFeatureCombination.ALL_PERMISSONS}if(this.cameraRoll&&this.notifications){setupMode=PhoneHubPermissionsSetupFeatureCombination.NOTIFICATION_AND_CAMERA_ROLL}if(this.cameraRoll&&this.appStreaming){setupMode=PhoneHubPermissionsSetupFeatureCombination.MESSAGING_APP_AND_CAMERA_ROLL}if(this.notifications&&this.appStreaming){setupMode=PhoneHubPermissionsSetupFeatureCombination.NOTIFICATION_AND_MESSAGING_APP}this.browserProxy_.logPhoneHubPermissionSetUpButtonClicked(setupMode)}getButtonDisabledState_(){return!this.isSuiteOn()||!this.isPhoneHubOn()}}customElements.define(SettingsMultideviceCombinedSetupItemElement.is,SettingsMultideviceCombinedSetupItemElement);function getTemplate$21(){return html`<!--_html_template_start_--><style include="settings-shared"></style>
<div id="container"
    inner-h-t-m-l="[[getAriaLabelledContent_()]]">
</div>
<!--_html_template_end_-->`}
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsMultideviceTaskContinuationDisabledLinkElementBase=I18nMixin(PolymerElement);class SettingsMultideviceTaskContinuationDisabledLinkElement extends SettingsMultideviceTaskContinuationDisabledLinkElementBase{static get is(){return"settings-multidevice-task-continuation-disabled-link"}static get template(){return getTemplate$21()}constructor(){super();this.browserProxy_=MultiDeviceBrowserProxyImpl.getInstance()}connectedCallback(){super.connectedCallback();const chromeSyncLink=this.shadowRoot.querySelector("#chromeSyncLink");if(chromeSyncLink){chromeSyncLink.addEventListener("click",this.onChromeSyncLinkClick_.bind(this))}}getAriaLabelledContent_(){const tempEl=document.createElement("div");tempEl.innerHTML=this.i18nAdvanced("multidevicePhoneHubTaskContinuationDisabledSummary",{attrs:["id"]});tempEl.childNodes.forEach(((node,index)=>{if(node.nodeType===Node.TEXT_NODE){const spanNode=document.createElement("span");spanNode.textContent=node.textContent;spanNode.id=`id${index}`;spanNode.setAttribute("aria-hidden","true");node.replaceWith(spanNode)}}));const chromeSyncLink=castExists(tempEl.querySelector("#chromeSyncLink"));const learnMoreLink=castExists(tempEl.querySelector("#learnMoreLink"));chromeSyncLink.setAttribute("aria-label",this.i18n("multidevicePhoneHubTaskContinuationSyncLabel"));learnMoreLink.setAttribute("aria-label",this.i18n("multidevicePhoneHubLearnMoreLabel"));chromeSyncLink.href="#";return sanitizeInnerHtml(tempEl.innerHTML,{tags:["span","a"],attrs:["id","aria-hidden","aria-label","href","target"]})}onChromeSyncLinkClick_(event){event.preventDefault();this.browserProxy_.showBrowserSyncSettings();const openedBrowserAdvancedSyncSettingsEvent=new CustomEvent("opened-browser-advanced-sync-settings",{bubbles:true,composed:true});this.dispatchEvent(openedBrowserAdvancedSyncSettingsEvent)}}customElements.define(SettingsMultideviceTaskContinuationDisabledLinkElement.is,SettingsMultideviceTaskContinuationDisabledLinkElement);function getTemplate$20(){return html`<!--_html_template_start_--><style include="settings-shared"></style>
<settings-multidevice-feature-item id="phoneHubTaskContinuationItem"
    feature="[[MultiDeviceFeature.PHONE_HUB_TASK_CONTINUATION]]"
    page-content-data="[[pageContentData]]" is-sub-feature>
  <template is="dom-if" if="[[!isChromeTabsSyncEnabled_]]" restamp>
    <settings-multidevice-task-continuation-disabled-link
        class="secondary"
        id="featureSecondary"
        slot="feature-summary">
    </settings-multidevice-task-continuation-disabled-link>
    <!-- Replace the standard feature-controller with an always disabled and
      off cr-toggle when Chrome Sync Open Tabs is disabled. When Chrome Sync
      is enabled the standard feature-controller is used. -->
    <cr-toggle disabled slot="feature-controller">
    </cr-toggle>
  </template>
</settings-multidevice-feature-item>
<!--_html_template_end_-->`}
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsMultideviceTaskContinuationItemElementBase=MultiDeviceFeatureMixin(WebUiListenerMixin(PolymerElement));class SettingsMultideviceTaskContinuationItemElement extends SettingsMultideviceTaskContinuationItemElementBase{static get is(){return"settings-multidevice-task-continuation-item"}static get template(){return getTemplate$20()}static get properties(){return{isChromeTabsSyncEnabled_:{type:Boolean,value:false}}}constructor(){super();this.syncBrowserProxy_=SyncBrowserProxyImpl.getInstance()}connectedCallback(){super.connectedCallback();this.addWebUiListener("sync-prefs-changed",this.handleSyncPrefsChanged_.bind(this));this.syncBrowserProxy_.sendSyncPrefsChanged()}focus(){if(!this.isChromeTabsSyncEnabled_){this.shadowRoot.querySelector("cr-toggle").focus()}else{this.$.phoneHubTaskContinuationItem.focus()}}handleSyncPrefsChanged_(syncPrefs){this.isChromeTabsSyncEnabled_=!!syncPrefs&&syncPrefs.tabsSynced}}customElements.define(SettingsMultideviceTaskContinuationItemElement.is,SettingsMultideviceTaskContinuationItemElement);function getTemplate$1$(){return html`<!--_html_template_start_--><style include="settings-shared"></style>
<settings-multidevice-feature-item page-content-data="[[pageContentData]]"
    feature="[[MultiDeviceFeature.INSTANT_TETHERING]]"
    subpage-route="[[routesEnum_.INTERNET_NETWORKS]]"
    subpage-route-url-search-params=
        "[[getTetherNetworkUrlSearchParams_()]]">
    <network-icon slot="icon"
        aria-hidden="true"
        show-technology-badge="[[showTechnologyBadge_]]"
        network-state="[[activeNetworkState_]]"
        device-state="[[deviceState_]]">
    </network-icon>
    <div id="instantTetheringSummary"
        class="secondary"
        slot="feature-summary">
      [[getInstantTetheringDescription_(deviceState_, activeNetworkState_)]]
    </div>
</settings-multidevice-feature-item>
<!--_html_template_end_-->`}
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsMultideviceTetherItemElementBase=mixinBehaviors([NetworkListenerBehavior],MultiDeviceFeatureMixin(PolymerElement));class SettingsMultideviceTetherItemElement extends SettingsMultideviceTetherItemElementBase{static get is(){return"settings-multidevice-tether-item"}static get template(){return getTemplate$1$()}static get properties(){return{deviceState_:Object,activeNetworkState_:Object,routesEnum_:{type:Object,value:routes,readonly:true},showTechnologyBadge_:{type:Boolean,value(){return loadTimeData.valueExists("showTechnologyBadge")&&loadTimeData.getBoolean("showTechnologyBadge")}}}}constructor(){super();this.networkConfig_=MojoInterfaceProviderImpl.getInstance().getMojoServiceRemote()}connectedCallback(){super.connectedCallback();this.updateTetherDeviceState_();this.updateTetherNetworkState_()}focus(){this.shadowRoot.querySelector("settings-multidevice-feature-item").focus()}onActiveNetworksChanged(networks){const guid=this.activeNetworkState_.guid;if(!networks.find((network=>network.guid===guid))){return}this.networkConfig_.getNetworkState(guid).then((response=>{if(response.result){this.activeNetworkState_=response.result}}))}onNetworkStateListChanged(){this.updateTetherNetworkState_()}onDeviceStateListChanged(){this.updateTetherDeviceState_()}updateTetherDeviceState_(){this.networkConfig_.getDeviceStateList().then((response=>{const kTether=NetworkType.kTether;const deviceStates=response.result;const deviceState=deviceStates.find((deviceState=>deviceState.type===kTether));this.deviceState_=deviceState||{deviceState:DeviceStateType.kDisabled,inhibitReason:InhibitReason.kNotInhibited,managedNetworkAvailable:false,scanning:false,simAbsent:false,type:kTether}}))}updateTetherNetworkState_(){const kTether=NetworkType.kTether;const filter={filter:FilterType.kVisible,limit:1,networkType:kTether};this.networkConfig_.getNetworkStateList(filter).then((response=>{const networks=response.result;this.activeNetworkState_=networks[0]||OncMojo.getDefaultNetworkState(kTether)}))}getNetworkStateList_(){return this.activeNetworkState_.guid?[castExists(this.activeNetworkState_)]:[]}getTetherNetworkUrlSearchParams_(){return new URLSearchParams("type=Tether")}getInstantTetheringDescription_(){const deviceState=this.deviceState_;if(deviceState&&deviceState.deviceState===DeviceStateType.kEnabled){assert(deviceState.type===NetworkType.kTether);if(this.activeNetworkState_){const connectionState=this.activeNetworkState_.connectionState;const deviceName=this.pageContentData.hostDeviceName||"";if(OncMojo.connectionStateIsConnected(connectionState)){return this.i18n("multideviceInstantTetheringItemConnectedDescription",deviceName)}if(connectionState===ConnectionStateType.kConnecting){return this.i18n("multideviceInstantTetheringItemConnectingDescription",deviceName)}if(connectionState===ConnectionStateType.kNotConnected){return this.i18n("multideviceInstantTetheringItemNoNetworkDescription",deviceName)}}}return this.i18n("multideviceInstantTetheringItemDisabledDescription")}}customElements.define(SettingsMultideviceTetherItemElement.is,SettingsMultideviceTetherItemElement);function getTemplate$1_(){return html`<!--_html_template_start_--><style include="settings-shared">:host{--cr-subsequent-anchors-of-span-margin:0}</style>
<div id="container"
    inner-h-t-m-l="[[getAriaLabelledContent_()]]">
</div>
<!--_html_template_end_-->`}
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsMultideviceWifiSyncDisabledLinkElementBase=MultiDeviceFeatureMixin(PolymerElement);class SettingsMultideviceWifiSyncDisabledLinkElement extends SettingsMultideviceWifiSyncDisabledLinkElementBase{static get is(){return"settings-multidevice-wifi-sync-disabled-link"}static get template(){return getTemplate$1_()}getAriaLabelledContent_(){const tempEl=document.createElement("div");tempEl.innerHTML=this.i18nAdvanced("multideviceEnableWifiSyncV1ItemSummary",{attrs:["id"]});tempEl.childNodes.forEach(((node,index)=>{if(node.nodeType===Node.TEXT_NODE){const spanNode=document.createElement("span");spanNode.textContent=node.textContent;spanNode.id=`id${index}`;spanNode.setAttribute("aria-hidden","true");node.replaceWith(spanNode)}}));const chromeSyncLink=castExists(tempEl.querySelector("#chromeSyncLink"));const learnMoreLink=castExists(tempEl.querySelector("#learnMoreLink"));chromeSyncLink.setAttribute("aria-label",this.i18n("multideviceWifiSyncChromeSyncLabel"));learnMoreLink.setAttribute("aria-label",this.i18n("multideviceWifiSyncLearnMoreLabel"));chromeSyncLink.href="#";return sanitizeInnerHtml(tempEl.innerHTML,{tags:["span","a"],attrs:["id","aria-label","aria-hidden","target","href"]})}connectedCallback(){super.connectedCallback();const chromeSyncLink=this.shadowRoot.querySelector("#chromeSyncLink");if(chromeSyncLink){chromeSyncLink.addEventListener("click",this.onChromeSyncLinkClick_.bind(this))}}onChromeSyncLinkClick_(event){event.preventDefault();Router.getInstance().navigateTo(routes.OS_SYNC_CONTROLS)}}customElements.define(SettingsMultideviceWifiSyncDisabledLinkElement.is,SettingsMultideviceWifiSyncDisabledLinkElement);function getTemplate$1Z(){return html`<!--_html_template_start_--><style include="settings-shared"></style>
<settings-multidevice-feature-item id="wifiSyncItem"
    feature="[[MultiDeviceFeature.WIFI_SYNC]]"
    page-content-data="[[pageContentData]]">
  <template is="dom-if" if="[[!isWifiSyncV1Enabled_]]" restamp>
    <settings-multidevice-wifi-sync-disabled-link
        class="secondary"
        id="featureSecondary"
        slot="feature-summary">
    </settings-multidevice-wifi-sync-disabled-link>
    <!-- Replace the standard feature-controller with an always disabled
      cr-toggle when Chrome Sync is disabled. When Chrome Sync is enabled
      the standard feature-controller is used. This is done to avoid adding
      extra logic in the standard feature-controller to keep the toggle
      unchecked when Chrome Sync is on but Wifi Sync host is enabled on the
      backend -->
    <cr-toggle disabled="true"
        slot="feature-controller">
    </cr-toggle>
  </template>
</settings-multidevice-feature-item>
<!--_html_template_end_-->`}
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsMultideviceWifiSyncItemElementBase=MultiDeviceFeatureMixin(WebUiListenerMixin(PolymerElement));class SettingsMultideviceWifiSyncItemElement extends SettingsMultideviceWifiSyncItemElementBase{static get is(){return"settings-multidevice-wifi-sync-item"}static get template(){return getTemplate$1Z()}static get properties(){return{isWifiSyncV1Enabled_:Boolean}}constructor(){super();this.osSyncBrowserProxy_=OsSyncBrowserProxyImpl.getInstance()}connectedCallback(){super.connectedCallback();this.addWebUiListener("os-sync-prefs-changed",this.handleOsSyncPrefsChanged_.bind(this));this.osSyncBrowserProxy_.sendOsSyncPrefsChanged()}handleOsSyncPrefsChanged_(osSyncPrefs){this.isWifiSyncV1Enabled_=!!osSyncPrefs&&osSyncPrefs.osWifiConfigurationsSynced}focus(){this.shadowRoot.querySelector("settings-multidevice-feature-item").focus()}}customElements.define(SettingsMultideviceWifiSyncItemElement.is,SettingsMultideviceWifiSyncItemElement);function getTemplate$1Y(){return html`<!--_html_template_start_--><style include="settings-shared iron-flex">settings-multidevice-feature-item,settings-multidevice-tether-item{--feature-item-row-padding:0}settings-multidevice-feature-item:first-of-type{--feature-item-border-top-style:none}cr-button{white-space:nowrap}#feature-items-container{padding-inline-start:var(--cr-section-indent-padding)}</style>
<div class="settings-box first">
  <div id="status-text-container"
      class="start"
      enabled$="[[isSuiteOn(pageContentData)]]"
      inner-h-t-m-l="[[getStatusInnerHtml_(pageContentData)]]">
  </div>
    <template is="dom-if" if="[[shouldShowVerifyButton_(pageContentData)]]"
        restamp>
      <cr-button
        aria-label="$i18n{multideviceVerifyButtonA11yLabel}"
        on-click="handleVerifyButtonClick_">
        $i18n{multideviceVerifyButton}
      </cr-button>
    </template>
    <template is="dom-if" if="[[shouldShowSuiteToggle_(pageContentData)]]"
        restamp>
      <settings-multidevice-feature-toggle
          toggle-aria-label="$i18n{multideviceSuiteToggleA11yLabel}"
          feature="[[MultiDeviceFeature.BETTER_TOGETHER_SUITE]]"
          page-content-data="[[pageContentData]]"
          deep-link-focus-id$="[[Setting.kMultiDeviceOnOff]]">
      </settings-multidevice-feature-toggle>
    </template>
</div>
<template is="dom-if"
    if="[[shouldShowIndividualFeatures_(pageContentData)]]"
    restamp>
  <div id="feature-items-container">
    <template is="dom-if"
        if="[[isFeatureSupported(
            MultiDeviceFeature.SMART_LOCK, pageContentData)]]"
        restamp>
      <settings-multidevice-feature-item id="smartLockItem"
          feature="[[MultiDeviceFeature.SMART_LOCK]]"
          page-content-data="[[pageContentData]]"
          deep-link-focus-id$="[[Setting.kSmartLockOnOff]]">
      </settings-multidevice-feature-item>
    </template>
    <template is="dom-if"
        if="[[isFeatureSupported(
            MultiDeviceFeature.INSTANT_TETHERING, pageContentData)]]"
        restamp>
      <settings-multidevice-tether-item id="instantTetheringItem"
          page-content-data="[[pageContentData]]"
          deep-link-focus-id$="[[Setting.kInstantTetheringOnOff]]">
      </settings-multidevice-tether-item>
    </template>
    <template is="dom-if"
        if="[[isFeatureSupported(
            MultiDeviceFeature.PHONE_HUB, pageContentData)]]"
        restamp>
      <settings-multidevice-feature-item id="phoneHubItem"
          feature="[[MultiDeviceFeature.PHONE_HUB]]"
          page-content-data="[[pageContentData]]"
          deep-link-focus-id$="[[Setting.kPhoneHubOnOff]]">
      </settings-multidevice-feature-item>
    </template>
    <template is="dom-if"
        if="[[isFeatureSupported(
            MultiDeviceFeature.PHONE_HUB_TASK_CONTINUATION,
            pageContentData)]]"
        restamp>
      <settings-multidevice-task-continuation-item
          id="phoneHubTaskContinuationItem"
          page-content-data="[[pageContentData]]"
          deep-link-focus-id$="[[Setting.kPhoneHubTaskContinuationOnOff]]">
      </settings-multidevice-task-continuation-item>
    </template>
    <template is="dom-if"
        if="[[shouldShowPhoneHubCameraRollItem_(pageContentData)]]"
        restamp>
      <settings-multidevice-feature-item id="phoneHubCameraRollItem"
          feature="[[MultiDeviceFeature.PHONE_HUB_CAMERA_ROLL]]"
          page-content-data="[[pageContentData]]" is-sub-feature
          deep-link-focus-id$="[[Setting.kPhoneHubCameraRollOnOff]]">
        <template is="dom-if"
            if="[[isPhoneHubCameraRollSetupRequired(pageContentData)]]"
            restamp>
          <cr-button on-click="handleCameraRollSetupClicked_"
              slot="feature-controller"
              disabled="[[isPhoneHubDisabled_(pageContentData)]]">
            $i18n{multideviceSetupButton}
          </cr-button>
        </template>
      </settings-multidevice-feature-item>
    </template>
    <template is="dom-if"
        if="[[shouldShowPhoneHubNotificationsItem_(pageContentData)]]"
        restamp>
      <settings-multidevice-feature-item id="phoneHubNotificationsItem"
          feature="[[MultiDeviceFeature.PHONE_HUB_NOTIFICATIONS]]"
          icon-tooltip="[[getPhoneHubNotificationsTooltip_(
                              pageContentData)]]"
          icon="cr:domain"
          page-content-data="[[pageContentData]]" is-sub-feature
          deep-link-focus-id$="[[Setting.kPhoneHubNotificationsOnOff]]">
        <template is="dom-if"
            if="[[isPhoneHubNotificationsSetupRequired(pageContentData)]]"
            restamp>
          <cr-button on-click="handleNotificationSetupClicked_"
              slot="feature-controller"
              disabled="[[isPhoneHubDisabled_(pageContentData)]]">
            $i18n{multideviceSetupButton}
          </cr-button>
        </template>
      </settings-multidevice-feature-item>
    </template>
    <template is="dom-if"
        if="[[shouldShowPhoneHubAppsItem_(pageContentData)]]"
        restamp>
      <settings-multidevice-feature-item id="phoneHubAppsItem"
          feature="[[MultiDeviceFeature.ECHE]]"
          icon-tooltip="[[getPhoneHubAppsTooltip_(
                              pageContentData)]]"
          icon="cr:domain"
          page-content-data="[[pageContentData]]" is-sub-feature
          deep-link-focus-id$="[[Setting.kPhoneHubAppsOnOff]]">
        <template is="dom-if"
            if="[[isPhoneHubAppsSetupRequired(pageContentData)]]"
            restamp>
          <cr-button on-click="handleMessagingAppSetupClicked_"
              slot="feature-controller"
              disabled="[[isPhoneHubDisabled_(pageContentData)]]">
            $i18n{multideviceSetupButton}
          </cr-button>
        </template>
      </settings-multidevice-feature-item>
    </template>
    <template is="dom-if"
        if="[[shouldShowPhoneHubCombinedSetupItem_(pageContentData)]]"
        restamp>
      <settings-multidevice-combined-setup-item
          id="phoneHubCombinedSetupItem"
          camera-roll="[[isPhoneHubCameraRollSetupRequired(
                            pageContentData)]]"
          notifications="[[isPhoneHubNotificationsSetupRequired(
                            pageContentData)]]"
          app-streaming="[[isPhoneHubAppsSetupRequired(pageContentData)]]"
          page-content-data="[[pageContentData]]">
      </settings-multidevice-combined-setup-item>
    </template>
    <template is="dom-if"
        if="[[isFeatureSupported(
            MultiDeviceFeature.WIFI_SYNC, pageContentData)]]"
        restamp>
      <settings-multidevice-wifi-sync-item id="wifiSyncItem"
          page-content-data="[[pageContentData]]"
          deep-link-focus-id$="[[Setting.kWifiSyncOnOff]]">
      </settings-multidevice-wifi-sync-item>
    </template>
  </div>
</template>
<!--_html_template_end_-->`}
// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsMultideviceSubpageElementBase=MultiDeviceFeatureMixin(DeepLinkingMixin(RouteObserverMixin(PolymerElement)));class SettingsMultideviceSubpageElement extends SettingsMultideviceSubpageElementBase{static get is(){return"settings-multidevice-subpage"}static get template(){return getTemplate$1Y()}constructor(){super();this.supportedSettingIds=new Set([Setting.kInstantTetheringOnOff,Setting.kMultiDeviceOnOff,Setting.kSmartLockOnOff,Setting.kForgetPhone,Setting.kPhoneHubOnOff,Setting.kPhoneHubCameraRollOnOff,Setting.kPhoneHubNotificationsOnOff,Setting.kPhoneHubTaskContinuationOnOff,Setting.kWifiSyncOnOff,Setting.kPhoneHubAppsOnOff]);this.browserProxy_=MultiDeviceBrowserProxyImpl.getInstance()}currentRouteChanged(route){if(route!==routes.MULTIDEVICE_FEATURES){return}this.attemptDeepLink()}handleVerifyButtonClick_(){this.browserProxy_.retryPendingHostSetup()}shouldShowIndividualFeatures_(){return this.pageContentData.mode===MultiDeviceSettingsMode.HOST_SET_VERIFIED}shouldShowVerifyButton_(){return[MultiDeviceSettingsMode.HOST_SET_WAITING_FOR_SERVER,MultiDeviceSettingsMode.HOST_SET_WAITING_FOR_VERIFICATION].includes(this.pageContentData.mode)}shouldShowSuiteToggle_(){return this.pageContentData.mode===MultiDeviceSettingsMode.HOST_SET_VERIFIED}getStatusInnerHtml_(){if([MultiDeviceSettingsMode.HOST_SET_WAITING_FOR_SERVER,MultiDeviceSettingsMode.HOST_SET_WAITING_FOR_VERIFICATION].includes(this.pageContentData.mode)){return this.i18nAdvanced("multideviceVerificationText")}return this.i18nAdvanced("multideviceSuiteToggleLabel")}getPhoneHubNotificationsTooltip_(){if(!this.isFeatureAllowedByPolicy(MultiDeviceFeature.PHONE_HUB_NOTIFICATIONS)){return""}if(!this.isPhoneHubNotificationAccessProhibited()){return""}switch(this.pageContentData.notificationAccessProhibitedReason){case PhoneHubFeatureAccessProhibitedReason.UNKNOWN:return this.i18n("multideviceNotificationAccessProhibitedTooltip");case PhoneHubFeatureAccessProhibitedReason.WORK_PROFILE:return this.i18n("multideviceNotificationAccessProhibitedTooltip");case PhoneHubFeatureAccessProhibitedReason.DISABLED_BY_PHONE_POLICY:return this.i18n("multideviceItemDisabledByPhoneAdminTooltip");default:return this.i18n("multideviceNotificationAccessProhibitedTooltip")}}getPhoneHubAppsTooltip_(){if(!this.isFeatureAllowedByPolicy(MultiDeviceFeature.ECHE)){return""}if(!this.isPhoneHubAppsAccessProhibited()){return""}return this.i18n("multideviceItemDisabledByPhoneAdminTooltip")}shouldShowPhoneHubCameraRollItem_(){return this.isFeatureSupported(MultiDeviceFeature.PHONE_HUB_CAMERA_ROLL)&&(!this.isPhoneHubCameraRollSetupRequired()||!this.shouldShowPhoneHubCombinedSetupItem_())}shouldShowPhoneHubNotificationsItem_(){return this.isFeatureSupported(MultiDeviceFeature.PHONE_HUB_NOTIFICATIONS)&&(!this.isPhoneHubNotificationsSetupRequired()||!this.shouldShowPhoneHubCombinedSetupItem_())}shouldShowPhoneHubAppsItem_(){return this.isFeatureSupported(MultiDeviceFeature.ECHE)&&(!this.isPhoneHubAppsSetupRequired()||!this.shouldShowPhoneHubCombinedSetupItem_())}shouldShowPhoneHubCombinedSetupItem_(){let numFeaturesSetupRequired=0;if(this.isPhoneHubCameraRollSetupRequired()){numFeaturesSetupRequired++}if(this.isPhoneHubNotificationsSetupRequired()){numFeaturesSetupRequired++}if(this.isPhoneHubAppsSetupRequired()){numFeaturesSetupRequired++}return numFeaturesSetupRequired>=2}handleNotificationSetupClicked_(){this.handlePhoneHubSetupClick(PhoneHubPermissionsSetupFeatureCombination.NOTIFICATION)}handleCameraRollSetupClicked_(){this.handlePhoneHubSetupClick(PhoneHubPermissionsSetupFeatureCombination.CAMERA_ROLL)}handleMessagingAppSetupClicked_(){this.handlePhoneHubSetupClick(PhoneHubPermissionsSetupFeatureCombination.MESSAGING_APP)}handlePhoneHubSetupClick(setupMode){const permissionSetupRequestedEvent=new CustomEvent("permission-setup-requested",{bubbles:true,composed:true});this.dispatchEvent(permissionSetupRequestedEvent);this.browserProxy_.logPhoneHubPermissionSetUpButtonClicked(setupMode)}isPhoneHubDisabled_(){return!this.isSuiteOn()||!this.isPhoneHubOn()}}customElements.define(SettingsMultideviceSubpageElement.is,SettingsMultideviceSubpageElement);
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var ScreenAiInstallStatus$1;(function(ScreenAiInstallStatus){ScreenAiInstallStatus[ScreenAiInstallStatus["NOT_DOWNLOADED"]=0]="NOT_DOWNLOADED";ScreenAiInstallStatus[ScreenAiInstallStatus["DOWNLOADING"]=1]="DOWNLOADING";ScreenAiInstallStatus[ScreenAiInstallStatus["DOWNLOAD_FAILED"]=2]="DOWNLOAD_FAILED";ScreenAiInstallStatus[ScreenAiInstallStatus["DOWNLOADED"]=3]="DOWNLOADED"})(ScreenAiInstallStatus$1||(ScreenAiInstallStatus$1={}));let instance$7=null;class AxAnnotationsBrowserProxyImpl{static getInstance(){return instance$7||(instance$7=new AxAnnotationsBrowserProxyImpl)}static setInstanceForTesting(obj){instance$7=obj}getScreenAiInstallState(){return sendWithPromise("getScreenAiInstallState")}}function getTemplate$1X(){return html`<!--_html_template_start_--><style include="settings-shared">#mainNodeAnnotationsToggle{padding-inline-end:var(--cr-section-padding);padding-inline-start:0}</style>
<settings-toggle-button id="mainNodeAnnotationsToggle"
    pref="{{prefs.settings.a11y.enable_main_node_annotations}}"
    label="$i18n{mainNodeAnnotationsTitle}"
    sub-label="[[getMainNodeAnnotationsToggleSublabel_(
        screenAIStatus_, screenAIProgress_)]]">
</settings-toggle-button>
<!--_html_template_end_-->`}
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsAxAnnotationsSectionBaseElement=PrefsMixin(WebUiListenerMixin(I18nMixin(PolymerElement)));class SettingsAxAnnotationsSectionElement extends SettingsAxAnnotationsSectionBaseElement{constructor(){super(...arguments);this.browserProxy_=AxAnnotationsBrowserProxyImpl.getInstance()}static get is(){return"settings-ax-annotations-section"}static get template(){return getTemplate$1X()}static get properties(){return{screenAIProgress_:Number,screenAIStatus_:Number}}connectedCallback(){super.connectedCallback();assert(loadTimeData.getBoolean("mainNodeAnnotationsEnabled"));const updateScreenAIState=screenAIState=>{this.screenAIStatus_=screenAIState};this.browserProxy_.getScreenAiInstallState().then(updateScreenAIState);this.addWebUiListener("screen-ai-state-changed",updateScreenAIState);this.addWebUiListener("screen-ai-downloading-progress-changed",(progress=>{this.screenAIProgress_=progress}))}getMainNodeAnnotationsToggleSublabel_(){switch(this.screenAIStatus_){case ScreenAiInstallStatus$1.DOWNLOADING:return this.screenAIProgress_>0&&this.screenAIProgress_<100?this.i18n("mainNodeAnnotationsDownloadProgressLabel",this.screenAIProgress_):this.i18n("mainNodeAnnotationsDownloadingLabel");case ScreenAiInstallStatus$1.DOWNLOAD_FAILED:return this.i18n("mainNodeAnnotationsDownloadErrorLabel");case ScreenAiInstallStatus$1.DOWNLOADED:case ScreenAiInstallStatus$1.NOT_DOWNLOADED:return this.i18n("mainNodeAnnotationsSubtitle");default:assertNotReached()}}}customElements.define(SettingsAxAnnotationsSectionElement.is,SettingsAxAnnotationsSectionElement);
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class BluetoothBrailleDisplayManager{constructor(){this.displayNamePrefixes_=["Actilino ALO","Activator AC4","Active Braille AB","Active Star AS","ALVA BC","APEX","APH Chameleon","APH Mantis","Basic Braille BB","Basic Braille Plus BP","BAUM Conny","Baum PocketVario","Baum SuperVario","Baum SVario","BrailleConnect","BrailleEDGE","BrailleMe","BMpk","BMsmart","BM32","BrailleNote Touch","BrailleSense","Braille Star","Braillex","Brailliant BI","Brailliant 14","Brailliant 80","Braillino BL","B2G","Conny","DotPad","Easy Braille EBR","EL12-","Esys-","Focus","Humanware BrailleOne","HWG Brailliant","MB248","NLS eReader","Orbit Reader","Pronto!","Refreshabraille","SmartBeetle","SuperVario","TSM","VarioConnect","VarioUltra"];this.listeners_=[];this.chromeVoxSubpageBrowserProxy_=ChromeVoxSubpageBrowserProxyImpl.getInstance();this.onDeviceAddedListener_=device=>this.handleDevicesChanged(device);this.onDeviceChangedListener_=device=>this.handleDevicesChanged(device);this.onDeviceRemovedListener_=device=>this.handleDevicesChanged(device);this.onPairingListener_=pairingEvent=>this.handlePairing(pairingEvent);chrome.settingsPrivate.getPref("settings.a11y.chromevox.preferred_braille_display_address").then((pref=>{this.preferredDisplayAddress_=pref.value}))}addListener(listener){this.listeners_.push(listener)}start(){this.chromeVoxSubpageBrowserProxy_.addDeviceAddedListener(this.onDeviceAddedListener_);this.chromeVoxSubpageBrowserProxy_.addDeviceChangedListener(this.onDeviceChangedListener_);this.chromeVoxSubpageBrowserProxy_.addDeviceRemovedListener(this.onDeviceRemovedListener_);this.chromeVoxSubpageBrowserProxy_.addPairingListener(this.onPairingListener_);this.chromeVoxSubpageBrowserProxy_.startDiscovery();this.handleDevicesChanged()}stop(){this.chromeVoxSubpageBrowserProxy_.stopDiscovery();this.chromeVoxSubpageBrowserProxy_.removeDeviceAddedListener(this.onDeviceAddedListener_);this.chromeVoxSubpageBrowserProxy_.removeDeviceChangedListener(this.onDeviceChangedListener_);this.chromeVoxSubpageBrowserProxy_.removeDeviceRemovedListener(this.onDeviceRemovedListener_);this.chromeVoxSubpageBrowserProxy_.removePairingListener(this.onPairingListener_)}async connect(display){if(this.preferredDisplayAddress_===display.address||!this.preferredDisplayAddress_){this.connectInternal(display)}else{try{await chrome.bluetoothPrivate.disconnectAll(this.preferredDisplayAddress_)}catch(error){console.error(`Error disconnecting previous display: ${error}`)}this.connectInternal(display)}}async connectInternal(display){this.preferredDisplayAddress_=display.address;chrome.settingsPrivate.setPref("settings.a11y.chromevox.preferred_braille_display_address",display.address);if(!display.paired){chrome.bluetoothPrivate.pair(display.address)}if(!display.connected){await chrome.bluetoothPrivate.connect(display.address)}}async disconnect(display){try{await chrome.bluetoothPrivate.disconnectAll(display.address)}catch(error){console.error(`Error disconnecting previous display: ${error}`)}this.chromeVoxSubpageBrowserProxy_.updateBluetoothBrailleDisplayAddress("")}async forget(display){try{await chrome.bluetoothPrivate.forgetDevice(display.address)}catch(error){console.error(`Error forgetting previous display: ${error}`)}this.chromeVoxSubpageBrowserProxy_.updateBluetoothBrailleDisplayAddress("")}finishPairing(display,pincode){chrome.bluetoothPrivate.setPairingResponse({response:chrome.bluetoothPrivate.PairingResponse.CONFIRM,device:display,pincode:pincode})}async handleDevicesChanged(device){const devices=await chrome.bluetooth.getDevices();const displayList=devices.filter((device=>this.displayNamePrefixes_.some((name=>device.name&&device.name.startsWith(name)))));if(displayList.length===0){return}if(device&&!displayList.find((i=>i.name===device.name))){return}displayList.forEach((display=>{if(this.preferredDisplayAddress_===display.address){this.handlePreferredDisplayConnectionStateChanged(display)}}));this.listeners_.forEach((listener=>listener.onDisplayListChanged(displayList)))}handlePairing(pairingEvent){if(pairingEvent.pairing===chrome.bluetoothPrivate.PairingEventType.REQUEST_PINCODE){this.listeners_.forEach((listener=>listener.onPincodeRequested(pairingEvent.device)))}}handlePreferredDisplayConnectionStateChanged(display){if(display.connected===this.preferredDisplayConnected_){return}this.preferredDisplayConnected_=display.connected;if(display.connected){this.chromeVoxSubpageBrowserProxy_.updateBluetoothBrailleDisplayAddress(display.address)}}}function getTemplate$1W(){return html`<!--_html_template_start_--><style include="settings-shared">settings-dropdown-menu{--md-select-width:100%}.container{align-items:center;display:flex;flex:1;justify-content:space-between;margin-inline-end:var(--cr-section-padding);min-height:var(--cr-section-min-height)}#pinContainer{align-items:baseline;display:flex;height:32px}#pinLabel{margin-inline-end:var(--cr-section-padding)}.controls{align-items:center;display:flex;flex:1}.menu{flex:1}.menu,.button{margin-inline-start:16px}
</style>

<div class="container">
  <span class="label">$i18n{chromeVoxBluetoothBrailleDisplaySelectLabel}</span>
  <template is="dom-if" if="[[inPinMode_]]">
    <div id="pinContainer">
      <div id="pinLabel" class="controls">
        $i18n{chromeVoxBluetoothBrailleDisplayPincodeLabel}
      </div>
      <cr-input
          id="pinCode"
          aria-label="$i18n{chromeVoxBluetoothBrailleDisplayPincodeLabel}"
          type="text"
          on-change="onPincodeChanged_">
      </cr-input>
    </div>
  </template>
  <template is="dom-if" if="[[!inPinMode_]]">
    <div id="controls" class="controls">
      <settings-dropdown-menu
          id="displaySelect"
          class="menu"
          label="$i18n{chromeVoxBluetoothBrailleDisplaySelectLabel}"
          pref="{{brailleDisplayAddressPref_}}"
          menu-options="[[brailleDisplayMenuOptions_]]">
      </settings-dropdown-menu>
      <cr-button id="connectOrDisconnect" class="button">
        $i18n{chromeVoxBluetoothBrailleDisplayConnect}
      </cr-button>
      <cr-button id="forget" class="button">
        $i18n{chromeVoxBluetoothBrailleDisplayForget}
      </cr-button>
    </div>
  </template>
</div>
<!--_html_template_end_-->`}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CONNECTED_METRIC_NAME="Accessibility.ChromeVox.BluetoothBrailleDisplayConnectedButtonClick";const PINCODE_TIMEOUT_MS=6e4;const BLANK_BRAILLE_DISPLAY_MENU_ITEM={value:"",name:""};const BluetoothBrailleDisplayUiElementBase=DeepLinkingMixin(PrefsMixin(WebUiListenerMixin(I18nMixin(PolymerElement))));class BluetoothBrailleDisplayUiElement extends BluetoothBrailleDisplayUiElementBase{static get is(){return"bluetooth-braille-display-ui"}static get template(){return getTemplate$1W()}static get properties(){return{brailleDisplayAddressPref_:{type:Object,observer:"updateControls_",notify:true,value(){return{key:"BrailleDisplayAddressPref",type:chrome.settingsPrivate.PrefType.STRING,value:""}}},brailleDisplayMenuOptions_:{type:Array,value:[BLANK_BRAILLE_DISPLAY_MENU_ITEM]}}}static get observers(){return["updateControls_(brailleDisplayMenuOptions_)","updateControls_(brailleDisplayAddressPref_.*)"]}constructor(){super();this.inPinMode_=false;this.manager_=new BluetoothBrailleDisplayManager;this.manager_.addListener(this)}ready(){super.ready();this.manager_.start()}disconnectedCallback(){super.disconnectedCallback();this.manager_.stop()}onDisplayListChanged(displays){if(displays.length===0){this.brailleDisplayMenuOptions_=[BLANK_BRAILLE_DISPLAY_MENU_ITEM]}else{this.brailleDisplayMenuOptions_=displays.map((display=>({value:display.address,name:display.name})));if(this.brailleDisplayAddressPref_.value===""){this.set("brailleDisplayAddressPref_.value",this.selectedAndConnectedDisplayAddress_||displays[0].address)}}this.updateControls_()}onPincodeChanged_(event){if(this.pincodeTimeoutId_){clearTimeout(this.pincodeTimeoutId_)}const pincodeInput=event.target;if(pincodeInput.value){this.manager_.finishPairing(this.pincodeRequestedDisplay_,pincodeInput.value)}this.inPinMode_=false}onPincodeRequested(display){this.inPinMode_=true;this.pincodeRequestedDisplay_=display;this.pincodeTimeoutId_=setTimeout((()=>{this.inPinMode_=false}),PINCODE_TIMEOUT_MS);afterNextRender(this,(()=>{this.shadowRoot.querySelector("#pinCode").focus()}))}async updateControls_(){const selectedDisplayAddress=this.brailleDisplayAddressPref_.value;if(!selectedDisplayAddress){this.selectedAndConnectedDisplayAddress_=undefined;return}const display=await chrome.bluetooth.getDevice(selectedDisplayAddress);this.selectedDisplay_=display;if(display.connected){if(this.selectedAndConnectedDisplayAddress_!==selectedDisplayAddress){this.selectedAndConnectedDisplayAddress_=selectedDisplayAddress;chrome.metricsPrivate.recordUserAction(CONNECTED_METRIC_NAME)}}else{if(this.selectedAndConnectedDisplayAddress_===selectedDisplayAddress){this.selectedAndConnectedDisplayAddress_=undefined}}const connectOrDisconnect=castExists(this.shadowRoot.querySelector("#connectOrDisconnect"));const displaySelect=castExists(this.shadowRoot.querySelector("#displaySelect"));connectOrDisconnect.disabled=display.connecting;displaySelect.disabled=display.connecting;connectOrDisconnect.textContent=loadTimeData.getString(display.connecting?"chromeVoxBluetoothBrailleDisplayConnecting":display.connected?"chromeVoxBluetoothBrailleDisplayDisconnect":"chromeVoxBluetoothBrailleDisplayConnect");connectOrDisconnect.onclick=()=>{chrome.metricsPrivate.recordBoolean("ChromeOS.Settings.Accessibility.ConnectBrailleDisplay",!display.connected);if(display.connected){this.manager_.disconnect(display)}else{this.manager_.connect(display)}};const forget=castExists(this.shadowRoot.querySelector("#forget"));forget.disabled=!display.paired||display.connecting;forget.onclick=()=>this.manager_.forget(display)}}customElements.define(BluetoothBrailleDisplayUiElement.is,BluetoothBrailleDisplayUiElement);function getTemplate$1V(){return html`<!--_html_template_start_--><!--
Copyright 2023 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style include="settings-shared md-select">:host{--cr-section-indent-width:60px}h2{padding-inline-start:var(--cr-section-padding)}.sub-item{padding-inline-start:var(--cr-section-indent-width)}.indented{margin-inline-start:32px}.settings-box{justify-content:space-between;margin-inline-end:var(--cr-section-padding);padding-inline-end:0;padding-inline-start:0}settings-dropdown-menu{--md-select-width:100%}settings-dropdown-menu+settings-dropdown-menu{padding-inline-start:16px}settings-toggle-button,cr-link-row{padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-padding)}.text-row{min-height:var(--cr-section-min-height);padding-bottom:8px;padding-top:14px}cr-input{--cr-input-error-display:none;width:80px}cr-expand-button{margin-top:20px}#developerOptionsExpandButton{min-height:var(--cr-section-min-height);padding-inline-end:var(--cr-section-padding)}#developerOptionsHeading{padding-bottom:0;padding-top:0}</style>

<h2>$i18n{chromeVoxGeneralLabel}</h2>
<div class="sub-item">
  <settings-toggle-button
      id="useVerboseModeToggle"
      class="settings-box continuation"
      pref="{{prefs.settings.a11y.chromevox.use_verbose_mode}}"
      label="$i18n{chromeVoxUseVerboseMode}">
  </settings-toggle-button>
  <settings-toggle-button
      id="autoReadToggle"
      class="settings-box"
      pref="{{prefs.settings.a11y.chromevox.auto_read}}"
      label="$i18n{chromeVoxAutoRead}">
  </settings-toggle-button>
  <settings-toggle-button
      id="speakTextUnderMouseToggle"
      class="settings-box"
      pref="{{prefs.settings.a11y.chromevox.speak_text_under_mouse}}"
      label="$i18n{chromeVoxSpeakTextUnderMouse}">
  </settings-toggle-button>
  <settings-toggle-button
      id="announceRichTextAttributesToggle"
      class="settings-box"
      pref="{{prefs.settings.a11y.chromevox.announce_rich_text_attributes}}"
      label="$i18n{chromeVoxAnnounceRichTextAttributes}">
  </settings-toggle-button>
  <settings-toggle-button
      id="usePitchChangesToggle"
      class="settings-box"
      pref="{{prefs.settings.a11y.chromevox.use_pitch_changes}}"
      label="$i18n{chromeVoxUsePitchChanges}"
      on-change="onUsePitchChangesToggled_">
  </settings-toggle-button>
  <div class="settings-box">
    <div class="start settings-box-text" aria-hidden="true">
      $i18n{chromeVoxCapitalStrategy}
    </div>
    <settings-dropdown-menu id="capitalStrategyDropdown"
        label="$i18n{chromeVoxCapitalStrategy}"
        pref="{{prefs.settings.a11y.chromevox.capital_strategy}}"
        menu-options="[[capitalStrategyOptions_]]">
    </settings-dropdown-menu>
  </div>
  <div class="settings-box">
    <div class="start settings-box-text" aria-hidden="true">
      $i18n{chromeVoxNumberReadingStyle}
    </div>
    <settings-dropdown-menu id="numberReadingStyleDropdown"
        label="$i18n{chromeVoxNumberReadingStyle}"
        pref="{{prefs.settings.a11y.chromevox.number_reading_style}}"
        menu-options="[[numberReadingStyleOptions_]]">
    </settings-dropdown-menu>
  </div>
  <div class="settings-box">
    <div class="start settings-box-text" aria-hidden="true">
      $i18n{chromeVoxPunctuationEcho}
    </div>
    <settings-dropdown-menu id="punctuationEchoDropdown"
        label="$i18n{chromeVoxPunctuationEcho}"
        pref="{{prefs.settings.a11y.chromevox.punctuation_echo}}"
        menu-options="[[punctuationEchoOptions_]]">
    </settings-dropdown-menu>
  </div>
  <settings-toggle-button
      id="announceDownloadNotificationsToggle"
      class="settings-box"
      pref="{{prefs.settings.a11y.chromevox.announce_download_notifications}}"
      label="$i18n{chromeVoxAnnounceDownloadNotifications}">
  </settings-toggle-button>
  <settings-toggle-button
      id="smartStickyModeToggle"
      class="settings-box"
      pref="{{prefs.settings.a11y.chromevox.smart_sticky_mode}}"
      label="$i18n{chromeVoxSmartStickyMode}">
  </settings-toggle-button>
  <div class="settings-box">
    <div class="start settings-box-text" aria-hidden="true">
      $i18n{chromeVoxAudioStrategy}
    </div>
    <settings-dropdown-menu id="audioStrategyDropdown"
        label="$i18n{chromeVoxAudioStrategy}"
        pref="{{prefs.settings.a11y.chromevox.audio_strategy}}"
        menu-options="[[audioStrategyOptions_]]">
    </settings-dropdown-menu>
  </div>
  <template is="dom-if" if="[[mainNodeAnnotationsFeatureEnabled_]]">
    <settings-ax-annotations-section
        id="AxAnnotationsSection"
        prefs="{{prefs}}">
    </settings-ax-annotations-section>
  </template>
</div>
<h2>$i18n{chromeVoxVoicesLabel}</h2>
<div class="sub-item">
  <div class="settings-box continuation">
    <div class="start settings-box-text" aria-hidden="true">
      $i18n{chromeVoxVoice}
    </div>
    <settings-dropdown-menu id="voiceDropdown"
        label="$i18n{chromeVoxVoice}"
        pref="{{prefs.settings.a11y.chromevox.voice_name}}"
        menu-options="[[voiceOptions_]]">
    </settings-dropdown-menu>
  </div>
  <settings-toggle-button
      id="languageSwitchingToggle"
      class="settings-box"
      pref="{{prefs.settings.a11y.chromevox.language_switching}}"
      label="$i18n{chromeVoxLanguageSwitching}">
  </settings-toggle-button>
  <cr-link-row class="settings-box"
      label="$i18n{chromeVoxTtsSettingsLink}"
      sub-label="$i18n{chromeVoxTtsSettingsDescription}"
      on-click="onTtsSettingsClick_"
      external
      embedded>
  </cr-link-row>
</div>
<h2>$i18n{chromeVoxBrailleLabel}</h2>
<div class="sub-item">
  <div class="settings-box continuation">
    <div class="start settings-box-text">
      $i18n{chromeVoxBrailleTableDescription}
    </div>
    <settings-dropdown-menu id="brailleTableTypeDropdown"
        pref="{{prefs.settings.a11y.chromevox.braille_table_type}}"
        menu-options="[[brailleTableTypeOptions_]]">
    </settings-dropdown-menu>
    <settings-dropdown-menu id="brailleTableDropdown"
        pref="{{prefs.settings.a11y.chromevox.braille_table}}"
        menu-options="[[brailleTableOptions_]]">
    </settings-dropdown-menu>
  </div>
  <settings-toggle-button
      id="brailleWordWrapToggle"
      class="settings-box"
      pref="{{prefs.settings.a11y.chromevox.braille_word_wrap}}"
      label="$i18n{chromeVoxBrailleWordWrap}">
  </settings-toggle-button>
  <settings-toggle-button
      id="menuBrailleCommandsToggle"
      class="settings-box"
      pref="{{prefs.settings.a11y.chromevox.menu_braille_commands}}"
      label="$i18n{chromeVoxMenuBrailleCommands}">
  </settings-toggle-button>
  <div class="hr">
    <bluetooth-braille-display-ui></bluetooth-braille-display-ui>
  </div>
  <div class="text-row hr">
    <div>$i18n{chromeVoxVirtualBrailleDisplay}</div>
    <div class="secondary">$i18n{chromeVoxVirtualBrailleDisplayDetails}</div>
  </div>
  <div class="settings-box indented continuation">
    $i18n{chromeVoxVirtualBrailleDisplayRows}
    <cr-input id="virtualBrailleDisplayRowsInput" type="number" min="1" max="99"
        value="[[prefs.settings.a11y.chromevox.virtual_braille_rows.value]]"
        on-input="onBrailleRowsInput_" on-focusout="onBrailleRowsFocusout_">
    </cr-input>
  </div>
  <div class="settings-box indented">
    $i18n{chromeVoxVirtualBrailleDisplayColumns}
    <cr-input id="virtualBrailleDisplayColumnsInput" type="number" min="1" max="99"
        value="[[prefs.settings.a11y.chromevox.virtual_braille_columns.value]]"
        on-input="onBrailleColumnsInput_" on-focusout="onBrailleColumnsFocusout_">
    </cr-input>
  </div>
  <div class="settings-box indented">
    <div class="start settings-box-text" aria-hidden="true">
      $i18n{chromeVoxVirtualBrailleDisplayStyleLabel}
    </div>
    <settings-dropdown-menu id="virtualBrailleDisplayStyleDropdown"
        label="$i18n{chromeVoxVirtualBrailleDisplayStyleLabel}"
        pref="{{prefs.settings.a11y.chromevox.braille_side_by_side}}"
        menu-options="[[virtualBrailleDisplayStyleOptions_]]">
    </settings-dropdown-menu>
  </div>
</div>
<cr-expand-button id="developerOptionsExpandButton" class="hr"
    expanded="{{developerOptionsExpanded_}}">
  <h2 id="developerOptionsHeading">$i18n{chromeVoxDeveloperOptionsLabel}</h2>
</cr-expand-button>
<iron-collapse opened="[[developerOptionsExpanded_]]">
  <div class="sub-item">
    <cr-link-row class="settings-box continuation"
        label="$i18n{chromeVoxEventLogLink}"
        sub-label="$i18n{chromeVoxEventLogDescription}"
        on-click="onEventLogClick_"
        external
        embedded>
    </cr-link-row>
    <settings-toggle-button
        id="enableSpeechLoggingToggle"
        class="settings-box"
        pref="{{prefs.settings.a11y.chromevox.enable_speech_logging}}"
        label="$i18n{chromeVoxEnableSpeechLogging}">
    </settings-toggle-button>
    <settings-toggle-button
        id="enableEarconLoggingToggle"
        class="settings-box"
        pref="{{prefs.settings.a11y.chromevox.enable_earcon_logging}}"
        label="$i18n{chromeVoxEnableEarconLogging}">
    </settings-toggle-button>
    <settings-toggle-button
        id="enableBrailleLoggingToggle"
        class="settings-box"
        pref="{{prefs.settings.a11y.chromevox.enable_braille_logging}}"
        label="$i18n{chromeVoxEnableBrailleLogging}">
    </settings-toggle-button>
    <settings-toggle-button
        id="enableEventStreamLoggingToggle"
        class="settings-box"
        pref="{{prefs.settings.a11y.chromevox.enable_event_stream_logging}}"
        label="$i18n{chromeVoxEnableEventStreamLogging}">
    </settings-toggle-button>
    <template is="dom-if" if="[[prefs.settings.a11y.chromevox.enable_event_stream_logging.value]]">
      <div class="indented">
        <template is="dom-repeat" items="[[eventStreamFilters_]]">
          <settings-toggle-button
              id="[[item]]"
              class="settings-box"
              pref="[[getEventStreamFilterPref_(item, prefs.settings.a11y.chromevox.event_stream_filters)]]"
              label="[[item]]"
              on-settings-boolean-control-change="onEventStreamFilterPrefChanged_"
              no-set-pref>
          </settings-toggle-button>
        </template>
      </div>
    </template>
  </div>
</iron-collapse>
<!--_html_template_end_-->`}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SYSTEM_VOICE$1="chromeos_system_voice";const CHROMEVOX_EXTENSION_ID="mndnfokpggljbaajbnioimlmbfngpief";const GOOGLE_TTS_EXTENSION_ID="gjjabgpgjpampikjhjpfhneeoapjbjaf";const ESPEAK_TTS_EXTENSION_ID="dakbfdmgjiabojdgbiljlhgjbokobjpg";const EVENT_STREAM_FILTERS_PREF_KEY="settings.a11y.chromevox.event_stream_filters";const BRAILLE_TABLE_PREF_KEY="settings.a11y.chromevox.braille_table";const BRAILLE_TABLE_6_PREF_KEY="settings.a11y.chromevox.braille_table_6";const BRAILLE_TABLE_8_PREF_KEY="settings.a11y.chromevox.braille_table_8";const BRAILLE_TABLE_TYPE_PREF_KEY="settings.a11y.chromevox.braille_table_type";const VIRTUAL_BRAILLE_ROWS_PREF_KEY="settings.a11y.chromevox.virtual_braille_rows";const VIRTUAL_BRAILLE_COLUMNS_PREF_KEY="settings.a11y.chromevox.virtual_braille_columns";const MIN_BRAILLE_ROWS=1;const MAX_BRAILLE_ROWS=99;const MIN_BRAILLE_COLUMNS=1;const MAX_BRAILLE_COLUMNS=99;var BrailleTableType;(function(BrailleTableType){BrailleTableType["BRAILLE_TABLE_6"]="brailleTable6";BrailleTableType["BRAILLE_TABLE_8"]="brailleTable8"})(BrailleTableType||(BrailleTableType={}));const SettingsChromeVoxSubpageElementBase=DeepLinkingMixin(RouteOriginMixin(PrefsMixin(WebUiListenerMixin(I18nMixin(PolymerElement)))));class SettingsChromeVoxSubpageElement extends SettingsChromeVoxSubpageElementBase{static get is(){return"settings-chromevox-subpage"}static get template(){return getTemplate$1V()}static get properties(){return{capitalStrategyOptions_:{readOnly:true,type:Array,value(){return[{value:"announceCapitals",name:loadTimeData.getString("chromeVoxAnnounceCapitals")},{value:"increasePitch",name:loadTimeData.getString("chromeVoxIncreasePitch")}]}},numberReadingStyleOptions_:{readOnly:true,type:Array,value(){return[{value:"asWords",name:loadTimeData.getString("chromeVoxAsWords")},{value:"asDigits",name:loadTimeData.getString("chromeVoxAsDigits")}]}},punctuationEchoOptions_:{readOnly:true,type:Array,value(){return[{value:0,name:loadTimeData.getString("chromeVoxNone")},{value:1,name:loadTimeData.getString("chromeVoxSome")},{value:2,name:loadTimeData.getString("chromeVoxAll")}]}},audioStrategyOptions_:{readOnly:true,type:Array,value(){return[{value:"audioNormal",name:loadTimeData.getString("chromeVoxAudioNormal")},{value:"audioDuck",name:loadTimeData.getString("chromeVoxAudioDuck")},{value:"audioSuspend",name:loadTimeData.getString("chromeVoxAudioSuspend")}]}},brailleTableTypeOptions_:{readOnly:true,type:Array,value(){return[{value:"brailleTable6",name:loadTimeData.getString("chromeVoxBrailleTable6Dot")},{value:"brailleTable8",name:loadTimeData.getString("chromeVoxBrailleTable8Dot")}]}},brailleTableOptions_:{type:Array,value:[]},virtualBrailleDisplayStyleOptions_:{readOnly:true,type:Array,value(){return[{value:false,name:loadTimeData.getString("chromeVoxVirtualBrailleDisplayStyleInterleave")},{value:true,name:loadTimeData.getString("chromeVoxVirtualBrailleDisplayStyleSideBySide")}]}},voiceOptions_:{type:Array,value:[]},developerOptionsExpanded_:{type:Boolean,value:false},eventStreamFilters_:{readOnly:true,type:Array,value(){return["activedescendantchanged","alert","ariaAttributeChangedDeprecated","autocorrectionOccured","blur","checkedStateChanged","childrenChanged","clicked","documentSelectionChanged","documentTitleChanged","expandedChanged","focus","focusContext","hide","hitTestResult","hover","imageFrameUpdated","invalidStatusChanged","layoutComplete","liveRegionChanged","liveRegionCreated","loadComplete","locationChanged","mediaStartedPlaying","mediaStoppedPlaying","menuEnd","menuItemSelected","menuListValueChangedDeprecated","menuPopupEnd","menuPopupStart","menuStart","mouseCanceled","mouseDragged","mouseMoved","mousePressed","mouseReleased","rowCollapsed","rowCountChanged","rowExpanded","scrollPositionChanged","scrolledToAnchor","selectedChildrenChanged","selection","selectionAdd","selectionRemove","show","stateChanged","textChanged","textSelectionChanged","treeChanged","valueInTextFieldChanged"]}},mainNodeAnnotationsFeatureEnabled_:{type:String,value:loadTimeData.getBoolean("mainNodeAnnotationsEnabled"),readOnly:true}}}static get observers(){return["populateBrailleTableList_("+`prefs.${BRAILLE_TABLE_TYPE_PREF_KEY}.value,`+`prefs.${BRAILLE_TABLE_PREF_KEY}.value, brailleTables_)`,"onBrailleTableTypeChanged_("+`prefs.${BRAILLE_TABLE_TYPE_PREF_KEY}.value)`,`onBrailleTableChanged_(prefs.${BRAILLE_TABLE_PREF_KEY}.value)`]}constructor(){super();this.omitLocalSpeakerName_=/-x-.*-local/;this.omitNetworkSpeakerName_=/-x-.*-network/;this.localSpeakerNameReplacement_="-x-local";this.networkSpeakerNameReplacement_="-x-network";this.chromeVoxBrowserProxy_=ChromeVoxSubpageBrowserProxyImpl.getInstance();this.route=routes.A11Y_CHROMEVOX}ready(){super.ready();this.addWebUiListener("all-voice-data-updated",(voices=>this.populateVoiceList_(voices)));this.chromeVoxBrowserProxy_.getAllTtsVoiceData();this.chromeVoxBrowserProxy_.refreshTtsVoices();this.fetchBrailleTables_()}currentRouteChanged(newRoute,prevRoute){super.currentRouteChanged(newRoute,prevRoute);if(newRoute!==this.route){return}this.attemptDeepLink()}onUsePitchChangesToggled_(event){const usePitchChanges=event.target.checked;if(!usePitchChanges){this.$.capitalStrategyDropdown.disabled=true;const capitalStrategy=this.getPref("settings.a11y.chromevox.capital_strategy").value;this.setPrefValue("settings.a11y.chromevox.capital_strategy_backup",capitalStrategy);this.setPrefValue("settings.a11y.chromevox.capital_strategy","announceCapitals");return}this.$.capitalStrategyDropdown.disabled=false;const capitalStrategyBackup=this.getPref("settings.a11y.chromevox.capital_strategy_backup").value;this.setPrefValue("settings.a11y.chromevox.capital_strategy",capitalStrategyBackup)}populateVoiceListForTesting(voices){this.populateVoiceList_(voices)}populateVoiceList_(voices){voices.forEach((voice=>{voice.name=voice.name||"";voice.displayName=voice.displayName||voice.name;if(this.omitLocalSpeakerName_.test(voice.displayName)){voice.displayName=voice.displayName.replace(this.omitLocalSpeakerName_,this.localSpeakerNameReplacement_)}else if(this.omitNetworkSpeakerName_.test(voice.displayName)){voice.displayName=voice.displayName.replace(this.omitNetworkSpeakerName_,this.networkSpeakerNameReplacement_)}}));voices.sort(((a,b)=>{function score(voice){if(voice.extensionId===GOOGLE_TTS_EXTENSION_ID){return 4}if(voice.extensionId===ESPEAK_TTS_EXTENSION_ID){return 2}if(!voice.remote){return 1}return 0}return score(b)-score(a)}));this.voiceOptions_=[{value:SYSTEM_VOICE$1,name:this.i18n("chromeVoxSystemVoice")},...voices.map((({name:name,displayName:displayName})=>({name:displayName,value:name})))]}fetchBrailleTables_(){const needsDisambiguation=new Map;function preprocess(tables){tables.forEach((table=>{const key=table.locale+table.grade;if(!needsDisambiguation.has(key)){needsDisambiguation.set(key,[])}const entry=needsDisambiguation.get(key);entry.push(table)}));for(const entry of needsDisambiguation.values()){if(entry.length>1){entry.forEach((table=>table.alwaysUseEnDisplayName=true))}}return tables}const xhr=new XMLHttpRequest;xhr.open("GET","static/liblouis/tables.json",true);xhr.onreadystatechange=()=>{if(xhr.readyState===XMLHttpRequest.DONE&&xhr.status===200){const tables=JSON.parse(xhr.responseText);this.set("brailleTables_",preprocess(tables))}};xhr.send()}async getBrailleTableDisplayName_(table){const[applicationLocale,localeName]=await Promise.all([this.chromeVoxBrowserProxy_.getApplicationLocale(),this.chromeVoxBrowserProxy_.getDisplayNameForLocale(table.locale)]);const enDisplayName=table.enDisplayName;if(!localeName&&!enDisplayName){return}let baseName;if(enDisplayName&&(table.alwaysUseEnDisplayName||applicationLocale.toLowerCase().startsWith("en")||!localeName)){baseName=enDisplayName}else{baseName=localeName}if(!table.grade&&!table.variant){return baseName}if(table.grade&&!table.variant){return this.i18n("chromeVoxBrailleTableNameWithGrade",baseName,table.grade)}if(!table.grade&&table.variant){return this.i18n("chromeVoxBrailleTableNameWithVariant",baseName,table.variant)}return this.i18n("chromeVoxBrailleTableNameWithVariantAndGrade",baseName,table.variant,table.grade)}async populateBrailleTableList_(){if(!this.brailleTables_){return}const dots=this.getPref(BRAILLE_TABLE_TYPE_PREF_KEY).value.at(-1);const items=[];for(const table of this.brailleTables_){if(table.dots!==dots){continue}const displayName=await this.getBrailleTableDisplayName_(table);if(displayName){items.push({id:table.id,name:displayName})}}items.sort(((a,b)=>a.id.localeCompare(b.id)));this.brailleTableOptions_=items.map((({id:id,name:name})=>({value:id,name:name})))}onTtsSettingsClick_(){Router.getInstance().navigateTo(routes.MANAGE_TTS_SETTINGS,undefined,true)}onBrailleRowsInput_(e){const inputBox=e.target;if(inputBox.value===""){return}const numericalValue=parseInt(inputBox.value,10);if(numericalValue<MIN_BRAILLE_ROWS||numericalValue>MAX_BRAILLE_ROWS){inputBox.value=String(this.getPref(VIRTUAL_BRAILLE_ROWS_PREF_KEY).value)}else{this.setPrefValue(VIRTUAL_BRAILLE_ROWS_PREF_KEY,numericalValue)}}onBrailleRowsFocusout_(e){const inputBox=e.target;if(inputBox.value===""){inputBox.value=String(this.getPref(VIRTUAL_BRAILLE_ROWS_PREF_KEY).value)}}onBrailleColumnsInput_(e){const inputBox=e.target;if(inputBox.value===""){return}const numericalValue=parseInt(inputBox.value,10);if(numericalValue<MIN_BRAILLE_COLUMNS||numericalValue>MAX_BRAILLE_COLUMNS){inputBox.value=String(this.getPref(VIRTUAL_BRAILLE_COLUMNS_PREF_KEY).value)}else{this.setPrefValue(VIRTUAL_BRAILLE_COLUMNS_PREF_KEY,numericalValue)}}onBrailleColumnsFocusout_(e){const inputBox=e.target;if(inputBox.value===""){inputBox.value=String(this.getPref(VIRTUAL_BRAILLE_COLUMNS_PREF_KEY).value)}}onEventLogClick_(){window.open("chrome-extension://"+CHROMEVOX_EXTENSION_ID+"/chromevox/log_page/log.html")}getEventStreamFilterPref_(eventStreamFilter){return{key:"",type:chrome.settingsPrivate.PrefType.BOOLEAN,value:Boolean(this.prefs)&&this.getPref(EVENT_STREAM_FILTERS_PREF_KEY).value[eventStreamFilter]}}onEventStreamFilterPrefChanged_(e){const filter=e.target;const eventStreamFilters={...this.getPref(EVENT_STREAM_FILTERS_PREF_KEY).value,[filter.id]:filter.checked};this.setPrefValue(EVENT_STREAM_FILTERS_PREF_KEY,eventStreamFilters)}onBrailleTableTypeChanged_(){const brailleTableType=this.getPref(BRAILLE_TABLE_TYPE_PREF_KEY).value;let brailleTable;switch(brailleTableType){case BrailleTableType.BRAILLE_TABLE_6:brailleTable=this.getPref(BRAILLE_TABLE_6_PREF_KEY).value;break;case BrailleTableType.BRAILLE_TABLE_8:brailleTable=this.getPref(BRAILLE_TABLE_8_PREF_KEY).value;break;default:assertExhaustive(brailleTableType)}this.setPrefValue(BRAILLE_TABLE_PREF_KEY,brailleTable)}onBrailleTableChanged_(){const brailleTable=this.getPref(BRAILLE_TABLE_PREF_KEY).value;const brailleTableType=this.getPref(BRAILLE_TABLE_TYPE_PREF_KEY).value;switch(brailleTableType){case BrailleTableType.BRAILLE_TABLE_6:this.setPrefValue(BRAILLE_TABLE_6_PREF_KEY,brailleTable);break;case BrailleTableType.BRAILLE_TABLE_8:this.setPrefValue(BRAILLE_TABLE_8_PREF_KEY,brailleTable);break;default:assertExhaustive(brailleTableType)}}}customElements.define(SettingsChromeVoxSubpageElement.is,SettingsChromeVoxSubpageElement);function getTemplate$1U(){return html`<!--_html_template_start_--><style include="settings-shared cr-icons">:host{--cr-section-indent-width:60px}.sub-item{padding-inline-start:var(--cr-section-indent-width)}.settings-box{padding-inline-start:0}#details{align-items:center;display:flex;flex:auto}.start-padding{padding-inline-start:var(--cr-section-padding)}.mouse-keys-icon{--iron-icon-fill-color:var(--cros-sys-primary);padding-inline-end:var(--cr-icon-button-margin-start)}#mouseKeysSettingsRow:hover{background-color:var(--cr-hover-background-color);cursor:pointer}settings-toggle-button,cr-link-row{padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-padding)}</style>

<settings-toggle-button
    id="autoClickToggle"
    pref="{{prefs.settings.a11y.autoclick}}"
    icon="os-settings:autoclick"
    label="$i18n{clickOnStopLabel}"
    sub-label="$i18n{clickOnStopDescription}"
    deep-link-focus-id$="[[Setting.kAutoClickWhenCursorStops]]">
</settings-toggle-button>
<div class="sub-item" hidden$="[[!prefs.settings.a11y.autoclick.value]]">
  <div class="settings-box">
    <div class="start settings-box-text" aria-hidden="true">
      $i18n{delayBeforeClickLabel}
    </div>
    <settings-dropdown-menu id="delayBeforeClickDropdown"
        label="$i18n{delayBeforeClickLabel}"
        pref="{{prefs.settings.a11y.autoclick_delay_ms}}"
        menu-options="[[autoClickDelayOptions_]]"
        disabled="[[!prefs.settings.a11y.autoclick.value]]">
    </settings-dropdown-menu>
  </div>
  <settings-toggle-button id="autoClickStabilizePositionToggle"
      class="settings-box hr"
      pref="{{prefs.settings.a11y.autoclick_stabilize_position}}"
      label="$i18n{autoclickStabilizeCursorPosition}">
  </settings-toggle-button>
  <div class="settings-box">
    <div class="start settings-box-text" aria-hidden="true">
      $i18n{autoclickMovementThresholdLabel}
    </div>
    <settings-dropdown-menu id="autoclickMovementThresholdDropdown"
        label="$i18n{autoclickMovementThresholdLabel}"
        pref="{{prefs.settings.a11y.autoclick_movement_threshold}}"
        menu-options="[[autoClickMovementThresholdOptions_]]"
        disabled="[[!prefs.settings.a11y.autoclick.value]]">
    </settings-dropdown-menu>
  </div>
  <settings-toggle-button id="autoClickRevertToLeftClickToggle"
      class="settings-box hr"
      pref="{{prefs.settings.a11y.autoclick_revert_to_left_click}}"
      label="$i18n{autoclickRevertToLeftClick}">
  </settings-toggle-button>
</div>
<template is="dom-if" if="[[isAccessibilityMouseKeysEnabled_]]">
  <div class="settings-box no-padding">
    <div id="mouseKeysSettingsRow"
        class="flex layout horizontal center link-wrapper"
        on-click="onMouseKeysRowClicked_">
      <iron-icon icon="os-settings:mouse-keys"
          class="mouse-keys-icon">
      </iron-icon>
      <div id="details" aria-hidden="true">
        <div class="flex settings-box-text">
          <div id="mouseKeysTitleText">
            $i18n{mouseKeysLabel}
          </div>
          <div id="mouseKeysSublabel" class="cr-secondary-text sub-label">
            <span class="sub-label-text">$i18n{mouseKeysDescription}</span>
          </div>
        </div>
      </div>
      <cr-icon-button id="mouseKeysRowArrowIcon"
          class="subpage-arrow"
          aria-labelledby="mouseKeysTitleText"
          aria-describedby="mouseKeysSublabel"
          aria-roledescription="$i18n{subpageArrowRoleDescription}"
          on-click="onMouseKeysRowClicked_">
      </cr-icon-button>
    </div>
    <div class="separator"></div>
    <cr-toggle id="mouseKeysToggle"
        class="margin-matches-padding"
        aria-label="$i18n{mouseKeysLabel}"
        aria-describedby="mouseKeysSublabel"
        checked="[[prefs.settings.a11y.mouse_keys.enabled.value]]"
        on-change="onMouseKeysToggleClicked_">
    </cr-toggle>
  </div>
</template>
<template is="dom-if" if="[[showFaceGazeRow_]]" restamp>
  <cr-link-row
      id="faceGazePageRow"
      class="hr"
      start-icon="os-settings:face-gaze"
      label="$i18n{accessibilityFaceGazeLabel}"
      on-click="onFaceGazeSettingsClick_"
      role-description="$i18n{subpageArrowRoleDescription}">
    <localized-link id="faceGazeSubLabel"
        slot="sub-label"
        localized-string="$i18n{accessibilityFaceGazeDescription}"
        link-url="$i18n{faceGazeLearnMoreUrl}">
    </localized-link>
  </cr-link-row>
</template>
<settings-toggle-button
    id="largeCursorEnabledControl"
    class="hr"
    pref="{{prefs.settings.a11y.large_cursor_enabled}}"
    label="$i18n{largeMouseCursorLabel}"
    deep-link-focus-id$="[[Setting.kLargeCursor]]">
</settings-toggle-button>
<div class="sub-item">
  <div class="settings-box"
      hidden$="[[!prefs.settings.a11y.large_cursor_enabled.value]]">
    <div class="start settings-box-text" aria-hidden="true">
      $i18n{largeMouseCursorSizeLabel}
    </div>
    <settings-slider
        id="largeCursorSizeSlider"
        pref="{{prefs.settings.a11y.large_cursor_dip_size}}"
        min="25" max="128"
        label-aria="$i18n{largeMouseCursorSizeLabel}"
        label-min="$i18n{largeMouseCursorSizeDefaultLabel}"
        label-max="$i18n{largeMouseCursorSizeLargeLabel}">
    </settings-slider>
  </div>
</div>
<div class="settings-box start-padding">
  <div class="start settings-box-text" id="cursorColorOptionsLabel">
    $i18n{cursorColorOptionsLabel}
  </div>
  <settings-dropdown-menu id="cursorColorDropdown"
      aria-labelledby="cursorColorOptionsLabel"
      pref="{{prefs.settings.a11y.cursor_color}}"
      menu-options="[[cursorColorOptions_]]"
      on-settings-control-change="onA11yCursorColorChange_"
      deep-link-focus-id$="[[Setting.kEnableCursorColor]]">
  </settings-dropdown-menu>
</div>
<settings-toggle-button id="cursorHighlightToggle"
    class="hr"
    pref="{{prefs.settings.a11y.cursor_highlight}}"
    label="$i18n{cursorHighlightLabel}"
    deep-link-focus-id$="[[Setting.kHighlightCursorWhileMoving]]">
</settings-toggle-button>
<settings-toggle-button id="overscrollToggle"
    class="hr"
    pref="{{prefs.settings.a11y.overscroll_history_navigation}}"
    label="$i18n{overscrollHistoryNavigationTitle}"
    deep-link-focus-id$="[[Setting.kOverscrollEnabled]]">
</settings-toggle-button>
<template is="dom-if" if="[[isAccessibilityDisableTouchpadEnabled_]]">
  <div class="settings-box start-padding">
    <div class="flex start settings-box-text">
      <div id="disableInternalTouchpadLabel">
          $i18n{disableTouchpadLabel}
      </div>
      <template is="dom-if" if="[[showTouchpadEnableMessage_(
            prefs.settings.a11y.disable_trackpad_mode.value
          )]]">
        <div class="cr-secondary-text sub-label" id="reEnableTouchpadLabel" >
           <span class="sub-label-text">$i18n{reEnableTouchpadLabel}</span>
        </div>
      </template>
    </div>
    <settings-dropdown-menu id="disableInternalTouchpadDropdown"
          aria-labelledby="disableInternalTouchpadLabel"
          pref="{{prefs.settings.a11y.disable_trackpad_mode}}"
          menu-options="[[disableTouchpadOptions_]]"
          deep-link-focus-id$="[[Setting.kDisableTouchpad]]"
          >
    </settings-dropdown-menu>
  </div>
</template>
<template is="dom-if" if="[[showShelfNavigationButtonsSettings_]]" restamp>
  <!-- If shelf navigation buttons are implicitly enabled by other a11y
      settings (e.g. by spoken feedback), the toggle control should be
      disabled, and toggled regardless of the actual backing pref value. To
      handle effective pref value changes, wrap the backing pref in a
      private property, which changes to a stub pref object when the setting
      is implicitly enabled. -->
  <settings-toggle-button
      id="shelfNavigationButtonsEnabledControl"
      class="hr"
      disabled="[[shelfNavigationButtonsImplicitlyEnabled_]]"
      pref="[[shelfNavigationButtonsPref_]]"
      no-set-pref
      on-settings-boolean-control-change=
          "updateShelfNavigationButtonsEnabledPref_"
      label="$i18n{tabletModeShelfNavigationButtonsSettingLabel}"
      sub-label="$i18n{tabletModeShelfNavigationButtonsSettingDescription}"
      learn-more-url="$i18n{tabletModeShelfNavigationButtonsLearnMoreUrl}"
      on-learn-more-clicked="onShelfNavigationButtonsLearnMoreClicked_"
      deep-link-focus-id$="[[Setting.kTabletNavigationButtons]]">
  </settings-toggle-button>
</template>
<cr-link-row id="pointerSubpageButton" class="hr"
    label="$i18n{mouseSettingsTitle}" on-click="onNavigateToSubpageClick"
    role-description="$i18n{subpageArrowRoleDescription}" embedded>
</cr-link-row>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
let instance$6=null;class CursorAndTouchpadPageBrowserProxyImpl{static getInstance(){return instance$6||(instance$6=new CursorAndTouchpadPageBrowserProxyImpl)}static setInstanceForTesting(obj){instance$6=obj}recordSelectedShowShelfNavigationButtonValue(enabled){chrome.send("recordSelectedShowShelfNavigationButtonValue",[enabled])}}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const DEFAULT_BLACK_CURSOR_COLOR=0;const SettingsCursorAndTouchpadPageElementBase=DeepLinkingMixin(RouteOriginMixin(PrefsMixin(WebUiListenerMixin(I18nMixin(PolymerElement)))));class SettingsCursorAndTouchpadPageElement extends SettingsCursorAndTouchpadPageElementBase{static get is(){return"settings-cursor-and-touchpad-page"}static get template(){return getTemplate$1U()}static get properties(){return{autoClickDelayOptions_:{readOnly:true,type:Array,value(){return[{value:600,name:loadTimeData.getString("delayBeforeClickExtremelyShort")},{value:800,name:loadTimeData.getString("delayBeforeClickVeryShort")},{value:1e3,name:loadTimeData.getString("delayBeforeClickShort")},{value:2e3,name:loadTimeData.getString("delayBeforeClickLong")},{value:4e3,name:loadTimeData.getString("delayBeforeClickVeryLong")}]}},autoClickMovementThresholdOptions_:{readOnly:true,type:Array,value(){return[{value:5,name:loadTimeData.getString("autoclickMovementThresholdExtraSmall")},{value:10,name:loadTimeData.getString("autoclickMovementThresholdSmall")},{value:20,name:loadTimeData.getString("autoclickMovementThresholdDefault")},{value:30,name:loadTimeData.getString("autoclickMovementThresholdLarge")},{value:40,name:loadTimeData.getString("autoclickMovementThresholdExtraLarge")}]}},cursorColorOptions_:{readOnly:true,type:Array,value(){return[{value:DEFAULT_BLACK_CURSOR_COLOR,name:loadTimeData.getString("cursorColorBlack")},{value:14233637,name:loadTimeData.getString("cursorColorRed")},{value:15898880,name:loadTimeData.getString("cursorColorYellow")},{value:2002494,name:loadTimeData.getString("cursorColorGreen")},{value:243390,name:loadTimeData.getString("cursorColorCyan")},{value:1733608,name:loadTimeData.getString("cursorColorBlue")},{value:12983001,name:loadTimeData.getString("cursorColorMagenta")},{value:16056407,name:loadTimeData.getString("cursorColorPink")}]}},disableTouchpadOptions_:{readOnly:true,type:Array,value(){return[{value:0,name:loadTimeData.getString("disableTouchpadNever")},{value:1,name:loadTimeData.getString("disableTouchpadAlways")},{value:2,name:loadTimeData.getString("disableTouchpadMouseConnected")}]}},isKioskModeActive_:{type:Boolean,value(){return loadTimeData.getBoolean("isKioskModeActive")}},showShelfNavigationButtonsSettings_:{type:Boolean,computed:"computeShowShelfNavigationButtonsSettings_(isKioskModeActive_)"},showFaceGazeRow_:{type:Boolean,computed:"computeShowFaceGazeRow_(isKioskModeActive_)"},shelfNavigationButtonsImplicitlyEnabled_:{type:Boolean,computed:"computeShelfNavigationButtonsImplicitlyEnabled_("+"prefs.settings.accessibility.value,"+"prefs.settings.a11y.autoclick.value,"+"prefs.settings.a11y.switch_access.enabled.value)"},shelfNavigationButtonsPref_:{type:Object,computed:"getShelfNavigationButtonsEnabledPref_("+"shelfNavigationButtonsImplicitlyEnabled_,"+"prefs.settings.a11y.tablet_mode_shelf_nav_buttons_enabled)"},isAccessibilityDisableTouchpadEnabled_:{type:Boolean,value(){return loadTimeData.getBoolean("isAccessibilityDisableTouchpadEnabled")}},isAccessibilityMouseKeysEnabled_:{type:Boolean,value(){return loadTimeData.getBoolean("isAccessibilityMouseKeysEnabled")}},hasMouse_:{type:Boolean},hasTouchpad_:{type:Boolean},hasPointingStick_:{type:Boolean}}}static get observers(){return["pointersChanged(hasMouse_, hasPointingStick_, hasTouchpad_, "+"isKioskModeActive_)"]}constructor(){super();this.supportedSettingIds=new Set([Setting.kAutoClickWhenCursorStops,Setting.kDisableTouchpad,Setting.kEnableCursorColor,Setting.kHighlightCursorWhileMoving,Setting.kLargeCursor,Setting.kMouseKeysEnabled,Setting.kOverscrollEnabled,Setting.kTabletNavigationButtons]);this.route=routes.A11Y_CURSOR_AND_TOUCHPAD;this.cursorAndTouchpadBrowserProxy_=CursorAndTouchpadPageBrowserProxyImpl.getInstance();this.deviceBrowserProxy_=DevicePageBrowserProxyImpl.getInstance()}connectedCallback(){super.connectedCallback();this.addWebUiListener("has-mouse-changed",(exists=>this.set("hasMouse_",exists)));this.addWebUiListener("has-pointing-stick-changed",(exists=>this.set("hasPointingStick_",exists)));this.addWebUiListener("has-touchpad-changed",(exists=>this.set("hasTouchpad_",exists)));this.deviceBrowserProxy_.initializePointers()}ready(){super.ready();this.addFocusConfig(routes.DEVICE,"#pointerSubpageButton");this.addFocusConfig(routes.PER_DEVICE_TOUCHPAD,"#pointerSubpageButton");this.addFocusConfig(routes.PER_DEVICE_MOUSE,"#pointerSubpageButton");this.addFocusConfig(routes.PER_DEVICE_POINTING_STICK,"#pointerSubpageButton");this.addFocusConfig(routes.MANAGE_FACEGAZE_SETTINGS,"#faceGazeSubpageButton")}currentRouteChanged(newRoute,prevRoute){super.currentRouteChanged(newRoute,prevRoute);if(newRoute!==this.route){return}this.attemptDeepLink()}onFaceGazeSettingsClick_(){Router.getInstance().navigateTo(routes.MANAGE_FACEGAZE_SETTINGS)}pointersChanged(hasMouse,hasTouchpad,hasPointingStick,isKioskModeActive){this.$.pointerSubpageButton.hidden=!hasMouse&&!hasPointingStick&&!hasTouchpad||isKioskModeActive}onNavigateToSubpageClick(){if(this.hasMouse_&&!this.hasTouchpad_&&!this.hasPointingStick_){Router.getInstance().navigateTo(routes.PER_DEVICE_MOUSE,undefined,true)}else if(!this.hasMouse_&&this.hasTouchpad_&&!this.hasPointingStick_){Router.getInstance().navigateTo(routes.PER_DEVICE_TOUCHPAD,undefined,true)}else if(!this.hasMouse_&&!this.hasTouchpad_&&this.hasPointingStick_){Router.getInstance().navigateTo(routes.PER_DEVICE_POINTING_STICK,undefined,true)}else{Router.getInstance().navigateTo(routes.DEVICE,undefined,true)}}computeShowShelfNavigationButtonsSettings_(){return!this.isKioskModeActive_&&loadTimeData.getBoolean("showTabletModeShelfNavigationButtonsSettings")}computeShowFaceGazeRow_(){return!this.isKioskModeActive_}computeShelfNavigationButtonsImplicitlyEnabled_(){const getBoolPrefValue=key=>{const pref=this.getPref(key);return pref&&!!pref.value};return getBoolPrefValue("settings.accessibility")||getBoolPrefValue("settings.a11y.autoclick")||getBoolPrefValue("settings.a11y.switch_access.enabled")}getShelfNavigationButtonsEnabledPref_(){if(this.shelfNavigationButtonsImplicitlyEnabled_){return{value:true,type:chrome.settingsPrivate.PrefType.BOOLEAN,key:""}}return this.getPref("settings.a11y.tablet_mode_shelf_nav_buttons_enabled")}onShelfNavigationButtonsLearnMoreClicked_(){chrome.metricsPrivate.recordUserAction("Settings_A11y_ShelfNavigationButtonsLearnMoreClicked")}updateShelfNavigationButtonsEnabledPref_(){if(this.shelfNavigationButtonsImplicitlyEnabled_){return}const enabled=this.shadowRoot.querySelector("#shelfNavigationButtonsEnabledControl").checked;this.setPrefValue("settings.a11y.tablet_mode_shelf_nav_buttons_enabled",enabled);this.cursorAndTouchpadBrowserProxy_.recordSelectedShowShelfNavigationButtonValue(enabled)}onA11yCursorColorChange_(){const a11yCursorColorOn=this.getPref("settings.a11y.cursor_color").value!==DEFAULT_BLACK_CURSOR_COLOR;this.set("prefs.settings.a11y.cursor_color_enabled.value",a11yCursorColorOn)}showTouchpadEnableMessage_(trackpadMode){return trackpadMode!==DisableTouchpadMode.NEVER}onMouseKeysRowClicked_(){Router.getInstance().navigateTo(routes.MANAGE_MOUSE_KEYS_SETTINGS)}onMouseKeysToggleClicked_(){const enabled=this.shadowRoot.querySelector("#mouseKeysToggle").checked;this.setPrefValue("settings.a11y.mouse_keys.enabled",enabled)}}customElements.define(SettingsCursorAndTouchpadPageElement.is,SettingsCursorAndTouchpadPageElement);function getTemplate$1T(){return html`<!--_html_template_start_--><style include="settings-shared">:host{--cr-section-indent-width:60px}.sub-item{padding-inline-start:var(--cr-section-indent-width)}.settings-box{padding-inline-start:0}settings-toggle-button,cr-link-row{padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-padding)}.settings-box.indented,settings-toggle-button.indented{margin-inline-start:calc(var(--cr-section-indent-padding) + var(--cr-section-indent-width))}#screenMagnifierZoomHintLabel{white-space:pre-line}#colorFilteringDeficiencyTypeDropdown{--md-select-width:300px}.color-item>.settings-box{border-top:none}.color-preview-holder{border:1px solid var(--cros-separator-color);border-radius:8px;gap:16px;margin-bottom:16px;margin-inline-end:20px;padding:16px 0;text-align:center}.color-preview-holder table{border-collapse:collapse;border-spacing:0;margin:0 auto}.color-preview-holder th{font-weight:normal;padding-bottom:4px;padding-top:16px}.color-preview-holder td{margin:0;padding:0}.color-preview{height:92px;width:calc(524px / 8)}.color-preview.red{background:linear-gradient(180deg,var(--cros-color-preview-red),transparent)}.color-preview.orange{background:linear-gradient(180deg,var(--cros-color-preview-orange),transparent)}.color-preview.yellow{background:linear-gradient(180deg,var(--cros-color-preview-yellow),transparent)}.color-preview.green{background:linear-gradient(180deg,var(--cros-color-preview-green),transparent)}.color-preview.cyan{background:linear-gradient(180deg,var(--cros-color-preview-cyan),transparent)}.color-preview.blue{background:linear-gradient(180deg,var(--cros-color-preview-blue),transparent)}.color-preview.purple{background:linear-gradient(180deg,var(--cros-color-preview-purple),transparent)}.color-preview.gray{background:linear-gradient(180deg,var(--cros-color-preview-grey),transparent)}</style>
<settings-toggle-button
  id="enableColorFiltering"
  icon="os-settings:color-correction"
  pref="{{prefs.settings.a11y.color_filtering.enabled}}"
  label="$i18n{colorFilteringLabel}"
  sub-label="$i18n{colorFilteringDescription}"
  deep-link-focus-id$="[[Setting.kColorCorrectionEnabled]]">
</settings-toggle-button>
<template is="dom-if"
    if="[[prefs.settings.a11y.color_filtering.enabled.value]]">
  <div class="sub-item color-item">
    <div class="settings-box">
      <div class="start settings-box-text">
        <div class="label" aria-hidden="true">
          $i18n{colorVisionDeficiencyTypeLabel}
        </div>
      </div>
      <settings-dropdown-menu
          id="colorFilteringDeficiencyTypeDropdown"
          label="$i18n{colorVisionDeficiencyTypeLabel}"
          pref="{{prefs.settings.a11y.color_filtering.color_vision_deficiency_type}}"
          menu-options="[[colorVisionDeficiencyTypeOptions_]]"
          deep-link-focus-id$="[[Setting.kColorCorrectionFilterType]]">
      </settings-dropdown-menu>
    </div>
    <div class="settings-box">
      <div class="start settings-box-text" aria-hidden="true">
        $i18n{colorVisionFilterIntensityLabel}
      </div>
      <settings-slider
        id="colorFilteringIntensitySlider"
        pref="{{prefs.settings.a11y.color_filtering.color_vision_correction_amount}}"
        min="0" max="100"
        label-aria="$i18n{colorVisionFilterIntensityLabel}"
        label-min="$i18n{colorFilterMinLabel}"
        label-max="$i18n{colorFilterMaxLabel}"
        deep-link-focus-id$="[[Setting.kColorCorrectionFilterAmount]]">
      </settings-slider>
    </div>
    <div class="color-preview-holder">
      <div>$i18n{colorFilteringPreviewInstructions}</div>
      <table>
        <tr>
          <th>$i18n{colorFilteringPreviewColorRed}</th>
          <th>$i18n{colorFilteringPreviewColorOrange}</th>
          <th>$i18n{colorFilteringPreviewColorYellow}</th>
          <th>$i18n{colorFilteringPreviewColorGreen}</th>
          <th>$i18n{colorFilteringPreviewColorCyan}</th>
          <th>$i18n{colorFilteringPreviewColorBlue}</th>
          <th>$i18n{colorFilteringPreviewColorPurple}</th>
          <th>$i18n{colorFilteringPreviewColorGray}</th>
        </tr>
        <tr>
          <td><div class="color-preview red"></div></td>
          <td><div class="color-preview orange"></div></td>
          <td><div class="color-preview yellow"></div></td>
          <td><div class="color-preview green"></div></td>
          <td><div class="color-preview cyan"></div></td>
          <td><div class="color-preview blue"></div></td>
          <td><div class="color-preview purple"></div></td>
          <td><div class="color-preview gray"></div></td>
        </tr>
      </table>
    </div>
  </div>
</template>
<settings-toggle-button
    icon="os-settings:contrast"
    pref="{{prefs.settings.a11y.high_contrast_enabled}}"
    label="$i18n{highContrastLabel}"
    sub-label="$i18n{highContrastDescription}"
    deep-link-focus-id$="[[Setting.kHighContrastMode]]"
    class="hr">
</settings-toggle-button>
<settings-toggle-button
    class="hr"
    id="fullScreenMagnifierToggle"
    icon="os-settings:fullscreen-magnifier"
    pref="{{prefs.settings.a11y.screen_magnifier}}"
    label="$i18n{screenMagnifierLabel}"
    sub-label="[[getScreenMagnifierDescription_(
        prefs.settings.a11y.screen_magnifier.value)]]"
    disabled="[[prefs.ash.docked_magnifier.enabled.value]]"
    deep-link-focus-id$="[[Setting.kFullscreenMagnifier]]">
</settings-toggle-button>
<template is="dom-if" if="[[prefs.settings.a11y.screen_magnifier.value]]">
  <div class="sub-item">
    <div class="hr">
      <settings-radio-group id="screenMagnifierMouseFollowingModeRadioGroup"
          pref="{{prefs.settings.a11y.screen_magnifier_mouse_following_mode}}">
        <controlled-radio-button
            id="screenMagnifierMouseFollowingModeContinuous"
            name="[[screenMagnifierMouseFollowingModePrefValues_.CONTINUOUS]]"
            pref="[[prefs.settings.a11y.screen_magnifier_mouse_following_mode]]"
            label="$i18n{screenMagnifierMouseFollowingModeContinuous}">
        </controlled-radio-button>
        <controlled-radio-button
            id="screenMagnifierMouseFollowingModeCentered"
            name="[[screenMagnifierMouseFollowingModePrefValues_.CENTERED]]"
            pref="[[prefs.settings.a11y.screen_magnifier_mouse_following_mode]]"
            label="$i18n{screenMagnifierMouseFollowingModeCentered}">
        </controlled-radio-button>
        <controlled-radio-button
            id="screenMagnifierMouseFollowingModeEdge"
            name="[[screenMagnifierMouseFollowingModePrefValues_.EDGE]]"
            pref="[[prefs.settings.a11y.screen_magnifier_mouse_following_mode]]"
            label="$i18n{screenMagnifierMouseFollowingModeEdge}">
        </controlled-radio-button>
      </settings-radio-group>
    </div>
    <settings-toggle-button
        class="settings-box hr"
        pref="{{prefs.settings.a11y.screen_magnifier_focus_following}}"
        label="$i18n{screenMagnifierFocusFollowingLabel}"
        deep-link-focus-id$=
            "[[Setting.kFullscreenMagnifierFocusFollowing]]">
    </settings-toggle-button>
    <settings-toggle-button
        id="fullScreenMagnifierFollowsStsToggle"
        class="settings-box hr"
        pref="{{prefs.settings.a11y.screen_magnifier_select_to_speak_focus_following}}"
        label="$i18n{screenMagnifierSelectToSpeakFocusFollowingLabel}"
        deep-link-focus-id$="[[Setting.kAccessibilityMagnifierFollowsSts]]">
    </settings-toggle-button>
    <template is="dom-if" if="[[isAccessibilityMagnifierFollowsChromeVoxEnabled_]]">
      <settings-toggle-button
          id="fullScreenMagnifierFollowsChromeVoxToggle"
          class="settings-box hr"
          pref="{{prefs.settings.a11y.screen_magnifier_chromevox_focus_following}}"
          label="$i18n{screenMagnifierChromeVoxFocusFollowingLabel}"
          deep-link-focus-id$="[[Setting.kMagnifierFollowsChromeVox]]">
      </settings-toggle-button>
    </template>
    <div class="settings-box">
      <div class="flex start settings-box-text" id="labelWrapper">
        <div class="label" aria-hidden="true">
          $i18n{screenMagnifierZoomLabel}
        </div>
        <!-- Next line long because screenMagnifierZoomHintLabel uses pre-line -->
        <div id="screenMagnifierZoomHintLabel" class="secondary label">$i18n{screenMagnifierZoomHintLabel}</div>
      </div>
      <settings-dropdown-menu label="$i18n{screenMagnifierZoomLabel}"
          pref="{{prefs.settings.a11y.screen_magnifier_scale}}"
          menu-options="[[screenMagnifierZoomOptions_]]"
          disabled="[[!prefs.settings.a11y.screen_magnifier.value]]">
      </settings-dropdown-menu>
    </div>
  </div>
</template>
<settings-toggle-button
    class="hr"
    id="dockedMagnifierToggle"
    icon="os-settings:docked-magnifier"
    pref="{{prefs.ash.docked_magnifier.enabled}}"
    label="$i18n{dockedMagnifierLabel}"
    sub-label="$i18n{dockedMagnifierDescription}"
    disabled="[[prefs.settings.a11y.screen_magnifier.value]]"
    deep-link-focus-id$="[[Setting.kDockedMagnifier]]">
</settings-toggle-button>
<template is="dom-if" if="[[prefs.ash.docked_magnifier.enabled.value]]">
  <div class="sub-item">
    <div class="settings-box">
      <div class="start settings-box-text" aria-hidden="true">
        $i18n{dockedMagnifierZoomLabel}
      </div>
      <settings-dropdown-menu label="$i18n{dockedMagnifierZoomLabel}"
          pref="{{prefs.ash.docked_magnifier.scale}}"
          menu-options="[[screenMagnifierZoomOptions_]]"
          disabled="[[!prefs.ash.docked_magnifier.enabled.value]]">
      </settings-dropdown-menu>
    </div>
    <settings-toggle-button
        id="dockedMagnifierFollowsStsToggle"
        class="settings-box hr"
        pref="{{prefs.settings.a11y.screen_magnifier_select_to_speak_focus_following}}"
        label="$i18n{screenMagnifierSelectToSpeakFocusFollowingLabel}"
        deep-link-focus-id$="[[Setting.kAccessibilityMagnifierFollowsSts]]" >
    </settings-toggle-button>
    <template is="dom-if" if="[[isAccessibilityMagnifierFollowsChromeVoxEnabled_]]">
      <settings-toggle-button
          id="dockedMagnifierFollowsChromeVoxToggle"
          class="settings-box hr"
          pref="{{prefs.settings.a11y.screen_magnifier_chromevox_focus_following}}"
          label="$i18n{screenMagnifierChromeVoxFocusFollowingLabel}"
          deep-link-focus-id$="[[Setting.kMagnifierFollowsChromeVox]]" >
      </settings-toggle-button>
    </template>
  </div>
</template>
<template is="dom-if" if="[[isAccessibilityReducedAnimationsEnabled_]]">
  <settings-toggle-button
    class="hr"
    id="enableReducedAnimations"
    icon="os-settings:reduced-animations"
    pref="{{prefs.settings.a11y.reduced_animations.enabled}}"
    label="$i18n{reducedAnimationsLabel}"
    sub-label="$i18n{reducedAnimationsDescription}"
    deep-link-focus-id$="[[Setting.kReducedAnimationsEnabled]]">
  </settings-toggle-button>
</template>
<settings-toggle-button class="hr" id="enableAlwaysShowScrollbars" icon="os-settings:scroll-vertical"
  pref="{{prefs.settings.a11y.overlay_scrollbar.enabled}}" label="$i18n{alwaysShowScrollbarsLabel}"
  deep-link-focus-id$="[[Setting.kAlwaysShowScrollbarsEnabled]]">
</settings-toggle-button>
<template is="dom-if" if="[[!isKioskModeActive_]]">
  <cr-link-row id="displaySubpageButton" class="hr"
      label="$i18n{displaySettingsTitle}" on-click="onDisplayClick_"
      sub-label="$i18n{displaySettingsDescription}"
      role-description="$i18n{subpageArrowRoleDescription}" embedded>
  </cr-link-row>
  <cr-link-row id="appearanceSubpageButton" class="hr"
      label="$i18n{appearanceSettingsTitle}" on-click="onAppearanceClick_"
      sub-label="$i18n{appearanceSettingsDescription}"
      external
      embedded>
  </cr-link-row>
</template>
<!--_html_template_end_-->`}
// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsDisplayAndMagnificationSubpageElementBase=DeepLinkingMixin(RouteOriginMixin(PrefsMixin(WebUiListenerMixin(I18nMixin(PolymerElement)))));class SettingsDisplayAndMagnificationSubpageElement extends SettingsDisplayAndMagnificationSubpageElementBase{static get is(){return"settings-display-and-magnification-subpage"}static get template(){return getTemplate$1T()}static get properties(){return{screenMagnifierMouseFollowingModePrefValues_:{readOnly:true,type:Object,value:{CONTINUOUS:0,CENTERED:1,EDGE:2}},screenMagnifierZoomOptions_:{readOnly:true,type:Array,value(){return[{value:2,name:loadTimeData.getString("screenMagnifierZoom2x")},{value:4,name:loadTimeData.getString("screenMagnifierZoom4x")},{value:6,name:loadTimeData.getString("screenMagnifierZoom6x")},{value:8,name:loadTimeData.getString("screenMagnifierZoom8x")},{value:10,name:loadTimeData.getString("screenMagnifierZoom10x")},{value:12,name:loadTimeData.getString("screenMagnifierZoom12x")},{value:14,name:loadTimeData.getString("screenMagnifierZoom14x")},{value:16,name:loadTimeData.getString("screenMagnifierZoom16x")},{value:18,name:loadTimeData.getString("screenMagnifierZoom18x")},{value:20,name:loadTimeData.getString("screenMagnifierZoom20x")}]}},isAccessibilityReducedAnimationsEnabled_:{type:Boolean,value(){return loadTimeData.getBoolean("isAccessibilityReducedAnimationsEnabled")}},isAccessibilityMagnifierFollowsChromeVoxEnabled_:{type:Boolean,value(){return loadTimeData.getBoolean("isAccessibilityMagnifierFollowsChromeVoxEnabled")}},colorVisionDeficiencyTypeOptions_:{readOnly:true,type:Array,value(){return[{value:1,name:loadTimeData.getString("deuteranomalyFilter")},{value:0,name:loadTimeData.getString("protanomalyFilter")},{value:2,name:loadTimeData.getString("tritanomalyFilter")},{value:3,name:loadTimeData.getString("greyscaleLabel")}]}},isKioskModeActive_:{type:Boolean,value(){return loadTimeData.getBoolean("isKioskModeActive")}}}}constructor(){super();this.supportedSettingIds=new Set([Setting.kAccessibilityMagnifierFollowsSts,Setting.kColorCorrectionEnabled,Setting.kColorCorrectionFilterType,Setting.kColorCorrectionFilterAmount,Setting.kDockedMagnifier,Setting.kFullscreenMagnifier,Setting.kFullscreenMagnifierMouseFollowingMode,Setting.kFullscreenMagnifierFocusFollowing,Setting.kMagnifierFollowsChromeVox,Setting.kReducedAnimationsEnabled,Setting.kAlwaysShowScrollbarsEnabled]);this.route=routes.A11Y_DISPLAY_AND_MAGNIFICATION}ready(){super.ready();this.addFocusConfig(routes.DISPLAY,"#displaySubpageButton")}currentRouteChanged(newRoute,prevRoute){super.currentRouteChanged(newRoute,prevRoute);if(newRoute!==this.route){return}this.attemptDeepLink()}getScreenMagnifierDescription_(enabled){return this.i18n(enabled?"screenMagnifierDescriptionOn":"screenMagnifierDescriptionOff")}onDisplayClick_(){Router.getInstance().navigateTo(routes.DISPLAY,undefined,true)}onAppearanceClick_(){chrome.send("showBrowserAppearanceSettings")}}customElements.define(SettingsDisplayAndMagnificationSubpageElement.is,SettingsDisplayAndMagnificationSubpageElement);
/**
 * @license
 * Copyright 2024 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */const styles$7=css`.elevated{--md-elevation-level: var(--_elevated-container-elevation);--md-elevation-shadow-color: var(--_elevated-container-shadow-color)}.elevated::before{background:var(--_elevated-container-color)}.elevated:hover{--md-elevation-level: var(--_elevated-hover-container-elevation)}.elevated:focus-within{--md-elevation-level: var(--_elevated-focus-container-elevation)}.elevated:active{--md-elevation-level: var(--_elevated-pressed-container-elevation)}.elevated.disabled{--md-elevation-level: var(--_elevated-disabled-container-elevation)}.elevated.disabled::before{background:var(--_elevated-disabled-container-color);opacity:var(--_elevated-disabled-container-opacity)}@media(forced-colors: active){.elevated md-elevation{border:1px solid CanvasText}.elevated.disabled md-elevation{border-color:GrayText}}
`
/**
 * @license
 * Copyright 2022 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */;class Elevation extends LitElement{connectedCallback(){super.connectedCallback();this.setAttribute("aria-hidden","true")}render(){return html$1`<span class="shadow"></span>`}}
/**
 * @license
 * Copyright 2024 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */const styles$6=css`:host,.shadow,.shadow::before,.shadow::after{border-radius:inherit;inset:0;position:absolute;transition-duration:inherit;transition-property:inherit;transition-timing-function:inherit}:host{display:flex;pointer-events:none;transition-property:box-shadow,opacity}.shadow::before,.shadow::after{content:"";transition-property:box-shadow,opacity;--_level: var(--md-elevation-level, 0);--_shadow-color: var(--md-elevation-shadow-color, var(--md-sys-color-shadow, #000))}.shadow::before{box-shadow:0px calc(1px*(clamp(0,var(--_level),1) + clamp(0,var(--_level) - 3,1) + 2*clamp(0,var(--_level) - 4,1))) calc(1px*(2*clamp(0,var(--_level),1) + clamp(0,var(--_level) - 2,1) + clamp(0,var(--_level) - 4,1))) 0px var(--_shadow-color);opacity:.3}.shadow::after{box-shadow:0px calc(1px*(clamp(0,var(--_level),1) + clamp(0,var(--_level) - 1,1) + 2*clamp(0,var(--_level) - 2,3))) calc(1px*(3*clamp(0,var(--_level),2) + 2*clamp(0,var(--_level) - 2,3))) calc(1px*(clamp(0,var(--_level),4) + 2*clamp(0,var(--_level) - 4,1))) var(--_shadow-color);opacity:.15}
`
/**
 * @license
 * Copyright 2022 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */;let MdElevation=class MdElevation extends Elevation{};MdElevation.styles=[styles$6];MdElevation=__decorate([customElement("md-elevation")],MdElevation);
/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */const chipBaseClass=mixinDelegatesAria(LitElement);let Chip$1=class Chip extends chipBaseClass{get rippleDisabled(){return this.disabled||this.softDisabled}constructor(){super();this.disabled=false;this.softDisabled=false;this.alwaysFocusable=false;this.label="";this.hasIcon=false;if(!isServer){this.addEventListener("click",this.handleClick.bind(this))}}focus(options){if(this.disabled&&!this.alwaysFocusable){return}super.focus(options)}render(){return html$1`
      <div class="container ${classMap(this.getContainerClasses())}">
        ${this.renderContainerContent()}
      </div>
    `}updated(changed){if(changed.has("disabled")&&changed.get("disabled")!==undefined){this.dispatchEvent(new Event("update-focus",{bubbles:true}))}}getContainerClasses(){return{disabled:this.disabled||this.softDisabled,"has-icon":this.hasIcon}}renderContainerContent(){return html$1`
      ${this.renderOutline()}
      <md-focus-ring part="focus-ring" for=${this.primaryId}></md-focus-ring>
      <md-ripple
        for=${this.primaryId}
        ?disabled=${this.rippleDisabled}></md-ripple>
      ${this.renderPrimaryAction(this.renderPrimaryContent())}
    `}renderOutline(){return html$1`<span class="outline"></span>`}renderLeadingIcon(){return html$1`<slot name="icon" @slotchange=${this.handleIconChange}></slot>`}renderPrimaryContent(){return html$1`
      <span class="leading icon" aria-hidden="true">
        ${this.renderLeadingIcon()}
      </span>
      <span class="label">
        <span class="label-text" id="label">
          ${this.label?this.label:html$1`<slot></slot>`}
        </span>
      </span>
      <span class="touch"></span>
    `}handleIconChange(event){const slot=event.target;this.hasIcon=slot.assignedElements({flatten:true}).length>0}handleClick(event){if(this.softDisabled||this.disabled&&this.alwaysFocusable){event.stopImmediatePropagation();event.preventDefault();return}}};Chip$1.shadowRootOptions={...LitElement.shadowRootOptions,delegatesFocus:true};__decorate([property({type:Boolean,reflect:true})],Chip$1.prototype,"disabled",void 0);__decorate([property({type:Boolean,attribute:"soft-disabled",reflect:true})],Chip$1.prototype,"softDisabled",void 0);__decorate([property({type:Boolean,attribute:"always-focusable"})],Chip$1.prototype,"alwaysFocusable",void 0);__decorate([property()],Chip$1.prototype,"label",void 0);__decorate([property({type:Boolean,reflect:true,attribute:"has-icon"})],Chip$1.prototype,"hasIcon",void 0);
/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */const ARIA_LABEL_REMOVE="aria-label-remove";class MultiActionChip extends Chip$1{get ariaLabelRemove(){if(this.hasAttribute(ARIA_LABEL_REMOVE)){return this.getAttribute(ARIA_LABEL_REMOVE)}const{ariaLabel:ariaLabel}=this;if(ariaLabel||this.label){return`Remove ${ariaLabel||this.label}`}return null}set ariaLabelRemove(ariaLabel){const prev=this.ariaLabelRemove;if(ariaLabel===prev){return}if(ariaLabel===null){this.removeAttribute(ARIA_LABEL_REMOVE)}else{this.setAttribute(ARIA_LABEL_REMOVE,ariaLabel)}this.requestUpdate()}constructor(){super();this.handleTrailingActionFocus=this.handleTrailingActionFocus.bind(this);if(!isServer){this.addEventListener("keydown",this.handleKeyDown.bind(this))}}focus(options){const isFocusable=this.alwaysFocusable||!this.disabled;if(isFocusable&&options?.trailing&&this.trailingAction){this.trailingAction.focus(options);return}super.focus(options)}renderContainerContent(){return html$1`
      ${super.renderContainerContent()}
      ${this.renderTrailingAction(this.handleTrailingActionFocus)}
    `}handleKeyDown(event){const isLeft=event.key==="ArrowLeft";const isRight=event.key==="ArrowRight";if(!isLeft&&!isRight){return}if(!this.primaryAction||!this.trailingAction){return}const isRtl=getComputedStyle(this).direction==="rtl";const forwards=isRtl?isLeft:isRight;const isPrimaryFocused=this.primaryAction?.matches(":focus-within");const isTrailingFocused=this.trailingAction?.matches(":focus-within");if(forwards&&isTrailingFocused||!forwards&&isPrimaryFocused){return}event.preventDefault();event.stopPropagation();const actionToFocus=forwards?this.trailingAction:this.primaryAction;actionToFocus.focus()}handleTrailingActionFocus(){const{primaryAction:primaryAction,trailingAction:trailingAction}=this;if(!primaryAction||!trailingAction){return}primaryAction.tabIndex=-1;trailingAction.addEventListener("focusout",(()=>{primaryAction.tabIndex=0}),{once:true})}}
/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */function renderRemoveButton({ariaLabel:ariaLabel,disabled:disabled,focusListener:focusListener,tabbable:tabbable=false}){return html$1`
    <span id="remove-label" hidden aria-hidden="true">Remove</span>
    <button
      class="trailing action"
      aria-label=${ariaLabel||nothing}
      aria-labelledby=${!ariaLabel?"remove-label label":nothing}
      tabindex=${!tabbable?-1:nothing}
      @click=${handleRemoveClick}
      @focus=${focusListener}>
      <md-focus-ring part="trailing-focus-ring"></md-focus-ring>
      <md-ripple ?disabled=${disabled}></md-ripple>
      <span class="trailing icon" aria-hidden="true">
        <slot name="remove-trailing-icon">
          <svg viewBox="0 96 960 960">
            <path
              d="m249 849-42-42 231-231-231-231 42-42 231 231 231-231 42 42-231 231 231 231-42 42-231-231-231 231Z" />
          </svg>
        </slot>
      </span>
      <span class="touch"></span>
    </button>
  `}function handleRemoveClick(event){if(this.disabled||this.softDisabled){return}event.stopPropagation();const preventDefault=!this.dispatchEvent(new Event("remove",{cancelable:true}));if(preventDefault){return}this.remove()}
/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */class FilterChip extends MultiActionChip{constructor(){super(...arguments);this.elevated=false;this.removable=false;this.selected=false;this.hasSelectedIcon=false}get primaryId(){return"button"}getContainerClasses(){return{...super.getContainerClasses(),elevated:this.elevated,selected:this.selected,"has-trailing":this.removable,"has-icon":this.hasIcon||this.selected}}renderPrimaryAction(content){const{ariaLabel:ariaLabel}=this;return html$1`
      <button
        class="primary action"
        id="button"
        aria-label=${ariaLabel||nothing}
        aria-pressed=${this.selected}
        aria-disabled=${this.softDisabled||nothing}
        ?disabled=${this.disabled&&!this.alwaysFocusable}
        @click=${this.handleClickOnChild}
        >${content}</button
      >
    `}renderLeadingIcon(){if(!this.selected){return super.renderLeadingIcon()}return html$1`
      <slot name="selected-icon">
        <svg class="checkmark" viewBox="0 0 18 18" aria-hidden="true">
          <path
            d="M6.75012 12.1274L3.62262 8.99988L2.55762 10.0574L6.75012 14.2499L15.7501 5.24988L14.6926 4.19238L6.75012 12.1274Z" />
        </svg>
      </slot>
    `}renderTrailingAction(focusListener){if(this.removable){return renderRemoveButton({focusListener:focusListener,ariaLabel:this.ariaLabelRemove,disabled:this.disabled||this.softDisabled})}return nothing}renderOutline(){if(this.elevated){return html$1`<md-elevation part="elevation"></md-elevation>`}return super.renderOutline()}handleClickOnChild(event){if(this.disabled||this.softDisabled){return}const prevValue=this.selected;this.selected=!this.selected;const preventDefault=!redispatchEvent(this,event);if(preventDefault){this.selected=prevValue;return}}}__decorate([property({type:Boolean})],FilterChip.prototype,"elevated",void 0);__decorate([property({type:Boolean})],FilterChip.prototype,"removable",void 0);__decorate([property({type:Boolean,reflect:true})],FilterChip.prototype,"selected",void 0);__decorate([property({type:Boolean,reflect:true,attribute:"has-selected-icon"})],FilterChip.prototype,"hasSelectedIcon",void 0);__decorate([query(".primary.action")],FilterChip.prototype,"primaryAction",void 0);__decorate([query(".trailing.action")],FilterChip.prototype,"trailingAction",void 0);
/**
 * @license
 * Copyright 2024 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */const styles$5=css`:host{--_container-height: var(--md-filter-chip-container-height, 32px);--_disabled-label-text-color: var(--md-filter-chip-disabled-label-text-color, var(--md-sys-color-on-surface, #1d1b20));--_disabled-label-text-opacity: var(--md-filter-chip-disabled-label-text-opacity, 0.38);--_elevated-container-elevation: var(--md-filter-chip-elevated-container-elevation, 1);--_elevated-container-shadow-color: var(--md-filter-chip-elevated-container-shadow-color, var(--md-sys-color-shadow, #000));--_elevated-disabled-container-color: var(--md-filter-chip-elevated-disabled-container-color, var(--md-sys-color-on-surface, #1d1b20));--_elevated-disabled-container-elevation: var(--md-filter-chip-elevated-disabled-container-elevation, 0);--_elevated-disabled-container-opacity: var(--md-filter-chip-elevated-disabled-container-opacity, 0.12);--_elevated-focus-container-elevation: var(--md-filter-chip-elevated-focus-container-elevation, 1);--_elevated-hover-container-elevation: var(--md-filter-chip-elevated-hover-container-elevation, 2);--_elevated-pressed-container-elevation: var(--md-filter-chip-elevated-pressed-container-elevation, 1);--_elevated-selected-container-color: var(--md-filter-chip-elevated-selected-container-color, var(--md-sys-color-secondary-container, #e8def8));--_label-text-font: var(--md-filter-chip-label-text-font, var(--md-sys-typescale-label-large-font, var(--md-ref-typeface-plain, Roboto)));--_label-text-line-height: var(--md-filter-chip-label-text-line-height, var(--md-sys-typescale-label-large-line-height, 1.25rem));--_label-text-size: var(--md-filter-chip-label-text-size, var(--md-sys-typescale-label-large-size, 0.875rem));--_label-text-weight: var(--md-filter-chip-label-text-weight, var(--md-sys-typescale-label-large-weight, var(--md-ref-typeface-weight-medium, 500)));--_selected-focus-label-text-color: var(--md-filter-chip-selected-focus-label-text-color, var(--md-sys-color-on-secondary-container, #1d192b));--_selected-hover-label-text-color: var(--md-filter-chip-selected-hover-label-text-color, var(--md-sys-color-on-secondary-container, #1d192b));--_selected-hover-state-layer-color: var(--md-filter-chip-selected-hover-state-layer-color, var(--md-sys-color-on-secondary-container, #1d192b));--_selected-hover-state-layer-opacity: var(--md-filter-chip-selected-hover-state-layer-opacity, 0.08);--_selected-label-text-color: var(--md-filter-chip-selected-label-text-color, var(--md-sys-color-on-secondary-container, #1d192b));--_selected-pressed-label-text-color: var(--md-filter-chip-selected-pressed-label-text-color, var(--md-sys-color-on-secondary-container, #1d192b));--_selected-pressed-state-layer-color: var(--md-filter-chip-selected-pressed-state-layer-color, var(--md-sys-color-on-surface-variant, #49454f));--_selected-pressed-state-layer-opacity: var(--md-filter-chip-selected-pressed-state-layer-opacity, 0.12);--_elevated-container-color: var(--md-filter-chip-elevated-container-color, var(--md-sys-color-surface-container-low, #f7f2fa));--_disabled-outline-color: var(--md-filter-chip-disabled-outline-color, var(--md-sys-color-on-surface, #1d1b20));--_disabled-outline-opacity: var(--md-filter-chip-disabled-outline-opacity, 0.12);--_disabled-selected-container-color: var(--md-filter-chip-disabled-selected-container-color, var(--md-sys-color-on-surface, #1d1b20));--_disabled-selected-container-opacity: var(--md-filter-chip-disabled-selected-container-opacity, 0.12);--_focus-outline-color: var(--md-filter-chip-focus-outline-color, var(--md-sys-color-on-surface-variant, #49454f));--_outline-color: var(--md-filter-chip-outline-color, var(--md-sys-color-outline, #79747e));--_outline-width: var(--md-filter-chip-outline-width, 1px);--_selected-container-color: var(--md-filter-chip-selected-container-color, var(--md-sys-color-secondary-container, #e8def8));--_selected-outline-width: var(--md-filter-chip-selected-outline-width, 0px);--_focus-label-text-color: var(--md-filter-chip-focus-label-text-color, var(--md-sys-color-on-surface-variant, #49454f));--_hover-label-text-color: var(--md-filter-chip-hover-label-text-color, var(--md-sys-color-on-surface-variant, #49454f));--_hover-state-layer-color: var(--md-filter-chip-hover-state-layer-color, var(--md-sys-color-on-surface-variant, #49454f));--_hover-state-layer-opacity: var(--md-filter-chip-hover-state-layer-opacity, 0.08);--_label-text-color: var(--md-filter-chip-label-text-color, var(--md-sys-color-on-surface-variant, #49454f));--_pressed-label-text-color: var(--md-filter-chip-pressed-label-text-color, var(--md-sys-color-on-surface-variant, #49454f));--_pressed-state-layer-color: var(--md-filter-chip-pressed-state-layer-color, var(--md-sys-color-on-secondary-container, #1d192b));--_pressed-state-layer-opacity: var(--md-filter-chip-pressed-state-layer-opacity, 0.12);--_icon-size: var(--md-filter-chip-icon-size, 18px);--_disabled-leading-icon-color: var(--md-filter-chip-disabled-leading-icon-color, var(--md-sys-color-on-surface, #1d1b20));--_disabled-leading-icon-opacity: var(--md-filter-chip-disabled-leading-icon-opacity, 0.38);--_selected-focus-leading-icon-color: var(--md-filter-chip-selected-focus-leading-icon-color, var(--md-sys-color-on-secondary-container, #1d192b));--_selected-hover-leading-icon-color: var(--md-filter-chip-selected-hover-leading-icon-color, var(--md-sys-color-on-secondary-container, #1d192b));--_selected-leading-icon-color: var(--md-filter-chip-selected-leading-icon-color, var(--md-sys-color-on-secondary-container, #1d192b));--_selected-pressed-leading-icon-color: var(--md-filter-chip-selected-pressed-leading-icon-color, var(--md-sys-color-on-secondary-container, #1d192b));--_focus-leading-icon-color: var(--md-filter-chip-focus-leading-icon-color, var(--md-sys-color-primary, #6750a4));--_hover-leading-icon-color: var(--md-filter-chip-hover-leading-icon-color, var(--md-sys-color-primary, #6750a4));--_leading-icon-color: var(--md-filter-chip-leading-icon-color, var(--md-sys-color-primary, #6750a4));--_pressed-leading-icon-color: var(--md-filter-chip-pressed-leading-icon-color, var(--md-sys-color-primary, #6750a4));--_disabled-trailing-icon-color: var(--md-filter-chip-disabled-trailing-icon-color, var(--md-sys-color-on-surface, #1d1b20));--_disabled-trailing-icon-opacity: var(--md-filter-chip-disabled-trailing-icon-opacity, 0.38);--_selected-focus-trailing-icon-color: var(--md-filter-chip-selected-focus-trailing-icon-color, var(--md-sys-color-on-secondary-container, #1d192b));--_selected-hover-trailing-icon-color: var(--md-filter-chip-selected-hover-trailing-icon-color, var(--md-sys-color-on-secondary-container, #1d192b));--_selected-pressed-trailing-icon-color: var(--md-filter-chip-selected-pressed-trailing-icon-color, var(--md-sys-color-on-secondary-container, #1d192b));--_selected-trailing-icon-color: var(--md-filter-chip-selected-trailing-icon-color, var(--md-sys-color-on-secondary-container, #1d192b));--_focus-trailing-icon-color: var(--md-filter-chip-focus-trailing-icon-color, var(--md-sys-color-on-surface-variant, #49454f));--_hover-trailing-icon-color: var(--md-filter-chip-hover-trailing-icon-color, var(--md-sys-color-on-surface-variant, #49454f));--_pressed-trailing-icon-color: var(--md-filter-chip-pressed-trailing-icon-color, var(--md-sys-color-on-surface-variant, #49454f));--_trailing-icon-color: var(--md-filter-chip-trailing-icon-color, var(--md-sys-color-on-surface-variant, #49454f));--_container-shape-start-start: var(--md-filter-chip-container-shape-start-start, var(--md-filter-chip-container-shape, var(--md-sys-shape-corner-small, 8px)));--_container-shape-start-end: var(--md-filter-chip-container-shape-start-end, var(--md-filter-chip-container-shape, var(--md-sys-shape-corner-small, 8px)));--_container-shape-end-end: var(--md-filter-chip-container-shape-end-end, var(--md-filter-chip-container-shape, var(--md-sys-shape-corner-small, 8px)));--_container-shape-end-start: var(--md-filter-chip-container-shape-end-start, var(--md-filter-chip-container-shape, var(--md-sys-shape-corner-small, 8px)));--_leading-space: var(--md-filter-chip-leading-space, 16px);--_trailing-space: var(--md-filter-chip-trailing-space, 16px);--_icon-label-space: var(--md-filter-chip-icon-label-space, 8px);--_with-leading-icon-leading-space: var(--md-filter-chip-with-leading-icon-leading-space, 8px);--_with-trailing-icon-trailing-space: var(--md-filter-chip-with-trailing-icon-trailing-space, 8px)}.selected.elevated::before{background:var(--_elevated-selected-container-color)}.checkmark{height:var(--_icon-size);width:var(--_icon-size)}.disabled .checkmark{opacity:var(--_disabled-leading-icon-opacity)}@media(forced-colors: active){.disabled .checkmark{opacity:1}}
`;
/**
 * @license
 * Copyright 2024 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */const styles$4=css`.selected{--md-ripple-hover-color: var(--_selected-hover-state-layer-color);--md-ripple-hover-opacity: var(--_selected-hover-state-layer-opacity);--md-ripple-pressed-color: var(--_selected-pressed-state-layer-color);--md-ripple-pressed-opacity: var(--_selected-pressed-state-layer-opacity)}:where(.selected)::before{background:var(--_selected-container-color)}:where(.selected) .outline{border-width:var(--_selected-outline-width)}:where(.selected.disabled)::before{background:var(--_disabled-selected-container-color);opacity:var(--_disabled-selected-container-opacity)}:where(.selected) .label{color:var(--_selected-label-text-color)}:where(.selected:hover) .label{color:var(--_selected-hover-label-text-color)}:where(.selected:focus) .label{color:var(--_selected-focus-label-text-color)}:where(.selected:active) .label{color:var(--_selected-pressed-label-text-color)}:where(.selected) .leading.icon{color:var(--_selected-leading-icon-color)}:where(.selected:hover) .leading.icon{color:var(--_selected-hover-leading-icon-color)}:where(.selected:focus) .leading.icon{color:var(--_selected-focus-leading-icon-color)}:where(.selected:active) .leading.icon{color:var(--_selected-pressed-leading-icon-color)}@media(forced-colors: active){:where(.selected:not(.elevated))::before{border:1px solid CanvasText}:where(.selected) .outline{border-width:1px}}
`;
/**
 * @license
 * Copyright 2024 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */const styles$3=css`:host{border-start-start-radius:var(--_container-shape-start-start);border-start-end-radius:var(--_container-shape-start-end);border-end-start-radius:var(--_container-shape-end-start);border-end-end-radius:var(--_container-shape-end-end);display:inline-flex;height:var(--_container-height);cursor:pointer;-webkit-tap-highlight-color:rgba(0,0,0,0);--md-ripple-hover-color: var(--_hover-state-layer-color);--md-ripple-hover-opacity: var(--_hover-state-layer-opacity);--md-ripple-pressed-color: var(--_pressed-state-layer-color);--md-ripple-pressed-opacity: var(--_pressed-state-layer-opacity)}:host(:is([disabled],[soft-disabled])){pointer-events:none}:host([touch-target=wrapper]){margin:max(0px,(48px - var(--_container-height))/2) 0}md-focus-ring{--md-focus-ring-shape-start-start: var(--_container-shape-start-start);--md-focus-ring-shape-start-end: var(--_container-shape-start-end);--md-focus-ring-shape-end-end: var(--_container-shape-end-end);--md-focus-ring-shape-end-start: var(--_container-shape-end-start)}.container{border-radius:inherit;box-sizing:border-box;display:flex;height:100%;position:relative;width:100%}.container::before{border-radius:inherit;content:"";inset:0;pointer-events:none;position:absolute}.container:not(.disabled){cursor:pointer}.container.disabled{pointer-events:none}.cell{display:flex}.action{align-items:baseline;appearance:none;background:none;border:none;border-radius:inherit;display:flex;outline:none;padding:0;position:relative;text-decoration:none}.primary.action{min-width:0;padding-inline-start:var(--_leading-space);padding-inline-end:var(--_trailing-space)}.has-icon .primary.action{padding-inline-start:var(--_with-leading-icon-leading-space)}.touch{height:48px;inset:50% 0 0;position:absolute;transform:translateY(-50%);width:100%}:host([touch-target=none]) .touch{display:none}.outline{border:var(--_outline-width) solid var(--_outline-color);border-radius:inherit;inset:0;pointer-events:none;position:absolute}:where(:focus) .outline{border-color:var(--_focus-outline-color)}:where(.disabled) .outline{border-color:var(--_disabled-outline-color);opacity:var(--_disabled-outline-opacity)}md-ripple{border-radius:inherit}.label,.icon,.touch{z-index:1}.label{align-items:center;color:var(--_label-text-color);display:flex;font-family:var(--_label-text-font);font-size:var(--_label-text-size);font-weight:var(--_label-text-weight);height:100%;line-height:var(--_label-text-line-height);overflow:hidden;user-select:none}.label-text{overflow:hidden;text-overflow:ellipsis;white-space:nowrap}:where(:hover) .label{color:var(--_hover-label-text-color)}:where(:focus) .label{color:var(--_focus-label-text-color)}:where(:active) .label{color:var(--_pressed-label-text-color)}:where(.disabled) .label{color:var(--_disabled-label-text-color);opacity:var(--_disabled-label-text-opacity)}.icon{align-self:center;display:flex;fill:currentColor;position:relative}.icon ::slotted(:first-child){font-size:var(--_icon-size);height:var(--_icon-size);width:var(--_icon-size)}.leading.icon{color:var(--_leading-icon-color)}.leading.icon ::slotted(*),.leading.icon svg{margin-inline-end:var(--_icon-label-space)}:where(:hover) .leading.icon{color:var(--_hover-leading-icon-color)}:where(:focus) .leading.icon{color:var(--_focus-leading-icon-color)}:where(:active) .leading.icon{color:var(--_pressed-leading-icon-color)}:where(.disabled) .leading.icon{color:var(--_disabled-leading-icon-color);opacity:var(--_disabled-leading-icon-opacity)}@media(forced-colors: active){:where(.disabled) :is(.label,.outline,.leading.icon){color:GrayText;opacity:1}}a,button{text-transform:inherit}a,button:not(:disabled,[aria-disabled=true]){cursor:inherit}
`;
/**
 * @license
 * Copyright 2024 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */const styles$2=css`.trailing.action{align-items:center;justify-content:center;padding-inline-start:var(--_icon-label-space);padding-inline-end:var(--_with-trailing-icon-trailing-space)}.trailing.action :is(md-ripple,md-focus-ring){border-radius:50%;height:calc(1.3333333333*var(--_icon-size));width:calc(1.3333333333*var(--_icon-size))}.trailing.action md-focus-ring{inset:unset}.has-trailing .primary.action{padding-inline-end:0}.trailing.icon{color:var(--_trailing-icon-color);height:var(--_icon-size);width:var(--_icon-size)}:where(:hover) .trailing.icon{color:var(--_hover-trailing-icon-color)}:where(:focus) .trailing.icon{color:var(--_focus-trailing-icon-color)}:where(:active) .trailing.icon{color:var(--_pressed-trailing-icon-color)}:where(.disabled) .trailing.icon{color:var(--_disabled-trailing-icon-color);opacity:var(--_disabled-trailing-icon-opacity)}:where(.selected) .trailing.icon{color:var(--_selected-trailing-icon-color)}:where(.selected:hover) .trailing.icon{color:var(--_selected-hover-trailing-icon-color)}:where(.selected:focus) .trailing.icon{color:var(--_selected-focus-trailing-icon-color)}:where(.selected:active) .trailing.icon{color:var(--_selected-pressed-trailing-icon-color)}@media(forced-colors: active){.trailing.icon{color:ButtonText}:where(.disabled) .trailing.icon{color:GrayText;opacity:1}}
`
/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */;let MdFilterChip=class MdFilterChip extends FilterChip{};MdFilterChip.styles=[styles$3,styles$7,styles$2,styles$4,styles$5];MdFilterChip=__decorate([customElement("md-filter-chip")],MdFilterChip);
/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */class InputChip extends MultiActionChip{constructor(){super(...arguments);this.avatar=false;this.href="";this.target="";this.removeOnly=false;this.selected=false}get primaryId(){if(this.href){return"link"}if(this.removeOnly){return""}return"button"}get rippleDisabled(){return!this.href&&(this.disabled||this.softDisabled)}get primaryAction(){if(this.removeOnly){return null}return this.renderRoot.querySelector(".primary.action")}getContainerClasses(){return{...super.getContainerClasses(),avatar:this.avatar,disabled:!this.href&&(this.disabled||this.softDisabled),link:!!this.href,selected:this.selected,"has-trailing":true}}renderPrimaryAction(content){const{ariaLabel:ariaLabel}=this;if(this.href){return html$1`
        <a
          class="primary action"
          id="link"
          aria-label=${ariaLabel||nothing}
          href=${this.href}
          target=${this.target||nothing}
          >${content}</a
        >
      `}if(this.removeOnly){return html$1`
        <span class="primary action" aria-label=${ariaLabel||nothing}>
          ${content}
        </span>
      `}return html$1`
      <button
        class="primary action"
        id="button"
        aria-label=${ariaLabel||nothing}
        aria-disabled=${this.softDisabled||nothing}
        ?disabled=${this.disabled&&!this.alwaysFocusable}
        type="button"
        >${content}</button
      >
    `}renderTrailingAction(focusListener){return renderRemoveButton({focusListener:focusListener,ariaLabel:this.ariaLabelRemove,disabled:!this.href&&(this.disabled||this.softDisabled),tabbable:this.removeOnly})}}__decorate([property({type:Boolean})],InputChip.prototype,"avatar",void 0);__decorate([property()],InputChip.prototype,"href",void 0);__decorate([property()],InputChip.prototype,"target",void 0);__decorate([property({type:Boolean,attribute:"remove-only"})],InputChip.prototype,"removeOnly",void 0);__decorate([property({type:Boolean,reflect:true})],InputChip.prototype,"selected",void 0);__decorate([query(".trailing.action")],InputChip.prototype,"trailingAction",void 0);
/**
 * @license
 * Copyright 2024 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */const styles$1=css`:host{--_container-height: var(--md-input-chip-container-height, 32px);--_disabled-label-text-color: var(--md-input-chip-disabled-label-text-color, var(--md-sys-color-on-surface, #1d1b20));--_disabled-label-text-opacity: var(--md-input-chip-disabled-label-text-opacity, 0.38);--_disabled-selected-container-color: var(--md-input-chip-disabled-selected-container-color, var(--md-sys-color-on-surface, #1d1b20));--_disabled-selected-container-opacity: var(--md-input-chip-disabled-selected-container-opacity, 0.12);--_label-text-font: var(--md-input-chip-label-text-font, var(--md-sys-typescale-label-large-font, var(--md-ref-typeface-plain, Roboto)));--_label-text-line-height: var(--md-input-chip-label-text-line-height, var(--md-sys-typescale-label-large-line-height, 1.25rem));--_label-text-size: var(--md-input-chip-label-text-size, var(--md-sys-typescale-label-large-size, 0.875rem));--_label-text-weight: var(--md-input-chip-label-text-weight, var(--md-sys-typescale-label-large-weight, var(--md-ref-typeface-weight-medium, 500)));--_selected-container-color: var(--md-input-chip-selected-container-color, var(--md-sys-color-secondary-container, #e8def8));--_selected-focus-label-text-color: var(--md-input-chip-selected-focus-label-text-color, var(--md-sys-color-on-secondary-container, #1d192b));--_selected-hover-label-text-color: var(--md-input-chip-selected-hover-label-text-color, var(--md-sys-color-on-secondary-container, #1d192b));--_selected-hover-state-layer-color: var(--md-input-chip-selected-hover-state-layer-color, var(--md-sys-color-on-secondary-container, #1d192b));--_selected-hover-state-layer-opacity: var(--md-input-chip-selected-hover-state-layer-opacity, 0.08);--_selected-label-text-color: var(--md-input-chip-selected-label-text-color, var(--md-sys-color-on-secondary-container, #1d192b));--_selected-outline-width: var(--md-input-chip-selected-outline-width, 0px);--_selected-pressed-label-text-color: var(--md-input-chip-selected-pressed-label-text-color, var(--md-sys-color-on-secondary-container, #1d192b));--_selected-pressed-state-layer-color: var(--md-input-chip-selected-pressed-state-layer-color, var(--md-sys-color-on-secondary-container, #1d192b));--_selected-pressed-state-layer-opacity: var(--md-input-chip-selected-pressed-state-layer-opacity, 0.12);--_disabled-outline-color: var(--md-input-chip-disabled-outline-color, var(--md-sys-color-on-surface, #1d1b20));--_disabled-outline-opacity: var(--md-input-chip-disabled-outline-opacity, 0.12);--_focus-label-text-color: var(--md-input-chip-focus-label-text-color, var(--md-sys-color-on-surface-variant, #49454f));--_focus-outline-color: var(--md-input-chip-focus-outline-color, var(--md-sys-color-on-surface-variant, #49454f));--_hover-label-text-color: var(--md-input-chip-hover-label-text-color, var(--md-sys-color-on-surface-variant, #49454f));--_hover-state-layer-color: var(--md-input-chip-hover-state-layer-color, var(--md-sys-color-on-surface-variant, #49454f));--_hover-state-layer-opacity: var(--md-input-chip-hover-state-layer-opacity, 0.08);--_label-text-color: var(--md-input-chip-label-text-color, var(--md-sys-color-on-surface-variant, #49454f));--_outline-color: var(--md-input-chip-outline-color, var(--md-sys-color-outline, #79747e));--_outline-width: var(--md-input-chip-outline-width, 1px);--_pressed-label-text-color: var(--md-input-chip-pressed-label-text-color, var(--md-sys-color-on-surface-variant, #49454f));--_pressed-state-layer-color: var(--md-input-chip-pressed-state-layer-color, var(--md-sys-color-on-surface-variant, #49454f));--_pressed-state-layer-opacity: var(--md-input-chip-pressed-state-layer-opacity, 0.12);--_avatar-shape: var(--md-input-chip-avatar-shape, var(--md-sys-shape-corner-full, 9999px));--_avatar-size: var(--md-input-chip-avatar-size, 24px);--_disabled-avatar-opacity: var(--md-input-chip-disabled-avatar-opacity, 0.38);--_disabled-leading-icon-color: var(--md-input-chip-disabled-leading-icon-color, var(--md-sys-color-on-surface, #1d1b20));--_disabled-leading-icon-opacity: var(--md-input-chip-disabled-leading-icon-opacity, 0.38);--_icon-size: var(--md-input-chip-icon-size, 18px);--_selected-focus-leading-icon-color: var(--md-input-chip-selected-focus-leading-icon-color, var(--md-sys-color-primary, #6750a4));--_selected-hover-leading-icon-color: var(--md-input-chip-selected-hover-leading-icon-color, var(--md-sys-color-primary, #6750a4));--_selected-leading-icon-color: var(--md-input-chip-selected-leading-icon-color, var(--md-sys-color-primary, #6750a4));--_selected-pressed-leading-icon-color: var(--md-input-chip-selected-pressed-leading-icon-color, var(--md-sys-color-primary, #6750a4));--_focus-leading-icon-color: var(--md-input-chip-focus-leading-icon-color, var(--md-sys-color-primary, #6750a4));--_hover-leading-icon-color: var(--md-input-chip-hover-leading-icon-color, var(--md-sys-color-primary, #6750a4));--_leading-icon-color: var(--md-input-chip-leading-icon-color, var(--md-sys-color-primary, #6750a4));--_pressed-leading-icon-color: var(--md-input-chip-pressed-leading-icon-color, var(--md-sys-color-primary, #6750a4));--_disabled-trailing-icon-color: var(--md-input-chip-disabled-trailing-icon-color, var(--md-sys-color-on-surface, #1d1b20));--_disabled-trailing-icon-opacity: var(--md-input-chip-disabled-trailing-icon-opacity, 0.38);--_selected-focus-trailing-icon-color: var(--md-input-chip-selected-focus-trailing-icon-color, var(--md-sys-color-on-secondary-container, #1d192b));--_selected-hover-trailing-icon-color: var(--md-input-chip-selected-hover-trailing-icon-color, var(--md-sys-color-on-secondary-container, #1d192b));--_selected-pressed-trailing-icon-color: var(--md-input-chip-selected-pressed-trailing-icon-color, var(--md-sys-color-on-secondary-container, #1d192b));--_selected-trailing-icon-color: var(--md-input-chip-selected-trailing-icon-color, var(--md-sys-color-on-secondary-container, #1d192b));--_focus-trailing-icon-color: var(--md-input-chip-focus-trailing-icon-color, var(--md-sys-color-on-surface-variant, #49454f));--_hover-trailing-icon-color: var(--md-input-chip-hover-trailing-icon-color, var(--md-sys-color-on-surface-variant, #49454f));--_pressed-trailing-icon-color: var(--md-input-chip-pressed-trailing-icon-color, var(--md-sys-color-on-surface-variant, #49454f));--_trailing-icon-color: var(--md-input-chip-trailing-icon-color, var(--md-sys-color-on-surface-variant, #49454f));--_container-shape-start-start: var(--md-input-chip-container-shape-start-start, var(--md-input-chip-container-shape, var(--md-sys-shape-corner-small, 8px)));--_container-shape-start-end: var(--md-input-chip-container-shape-start-end, var(--md-input-chip-container-shape, var(--md-sys-shape-corner-small, 8px)));--_container-shape-end-end: var(--md-input-chip-container-shape-end-end, var(--md-input-chip-container-shape, var(--md-sys-shape-corner-small, 8px)));--_container-shape-end-start: var(--md-input-chip-container-shape-end-start, var(--md-input-chip-container-shape, var(--md-sys-shape-corner-small, 8px)));--_leading-space: var(--md-input-chip-leading-space, 16px);--_trailing-space: var(--md-input-chip-trailing-space, 16px);--_icon-label-space: var(--md-input-chip-icon-label-space, 8px);--_with-leading-icon-leading-space: var(--md-input-chip-with-leading-icon-leading-space, 8px);--_with-trailing-icon-trailing-space: var(--md-input-chip-with-trailing-icon-trailing-space, 8px)}:host([avatar]){--_container-shape-start-start: var( --md-input-chip-container-shape-start-start, var(--md-input-chip-container-shape, calc(var(--_container-height) / 2)) );--_container-shape-start-end: var( --md-input-chip-container-shape-start-end, var(--md-input-chip-container-shape, calc(var(--_container-height) / 2)) );--_container-shape-end-end: var( --md-input-chip-container-shape-end-end, var(--md-input-chip-container-shape, calc(var(--_container-height) / 2)) );--_container-shape-end-start: var( --md-input-chip-container-shape-end-start, var(--md-input-chip-container-shape, calc(var(--_container-height) / 2)) )}.avatar .primary.action{padding-inline-start:4px}.avatar .leading.icon ::slotted(:first-child){border-radius:var(--_avatar-shape);height:var(--_avatar-size);width:var(--_avatar-size)}.disabled.avatar .leading.icon{opacity:var(--_disabled-avatar-opacity)}@media(forced-colors: active){.link .outline{border-color:ActiveText}.disabled.avatar .leading.icon{opacity:1}}
`
/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */;let MdInputChip=class MdInputChip extends InputChip{};MdInputChip.styles=[styles$3,styles$2,styles$4,styles$1];MdInputChip=__decorate([customElement("md-input-chip")],MdInputChip);
/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */class AssistChip extends Chip$1{constructor(){super(...arguments);this.elevated=false;this.href="";this.download="";this.target=""}get primaryId(){return this.href?"link":"button"}get rippleDisabled(){return!this.href&&(this.disabled||this.softDisabled)}getContainerClasses(){return{...super.getContainerClasses(),disabled:!this.href&&(this.disabled||this.softDisabled),elevated:this.elevated,link:!!this.href}}renderPrimaryAction(content){const{ariaLabel:ariaLabel}=this;if(this.href){return html$1`
        <a
          class="primary action"
          id="link"
          aria-label=${ariaLabel||nothing}
          href=${this.href}
          download=${this.download||nothing}
          target=${this.target||nothing}
          >${content}</a
        >
      `}return html$1`
      <button
        class="primary action"
        id="button"
        aria-label=${ariaLabel||nothing}
        aria-disabled=${this.softDisabled||nothing}
        ?disabled=${this.disabled&&!this.alwaysFocusable}
        type="button"
        >${content}</button
      >
    `}renderOutline(){if(this.elevated){return html$1`<md-elevation part="elevation"></md-elevation>`}return super.renderOutline()}}__decorate([property({type:Boolean})],AssistChip.prototype,"elevated",void 0);__decorate([property()],AssistChip.prototype,"href",void 0);__decorate([property()],AssistChip.prototype,"download",void 0);__decorate([property()],AssistChip.prototype,"target",void 0);
/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */class SuggestionChip extends AssistChip{}
/**
 * @license
 * Copyright 2024 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */const styles=css`:host{--_container-height: var(--md-suggestion-chip-container-height, 32px);--_disabled-label-text-color: var(--md-suggestion-chip-disabled-label-text-color, var(--md-sys-color-on-surface, #1d1b20));--_disabled-label-text-opacity: var(--md-suggestion-chip-disabled-label-text-opacity, 0.38);--_elevated-container-color: var(--md-suggestion-chip-elevated-container-color, var(--md-sys-color-surface-container-low, #f7f2fa));--_elevated-container-elevation: var(--md-suggestion-chip-elevated-container-elevation, 1);--_elevated-container-shadow-color: var(--md-suggestion-chip-elevated-container-shadow-color, var(--md-sys-color-shadow, #000));--_elevated-disabled-container-color: var(--md-suggestion-chip-elevated-disabled-container-color, var(--md-sys-color-on-surface, #1d1b20));--_elevated-disabled-container-elevation: var(--md-suggestion-chip-elevated-disabled-container-elevation, 0);--_elevated-disabled-container-opacity: var(--md-suggestion-chip-elevated-disabled-container-opacity, 0.12);--_elevated-focus-container-elevation: var(--md-suggestion-chip-elevated-focus-container-elevation, 1);--_elevated-hover-container-elevation: var(--md-suggestion-chip-elevated-hover-container-elevation, 2);--_elevated-pressed-container-elevation: var(--md-suggestion-chip-elevated-pressed-container-elevation, 1);--_focus-label-text-color: var(--md-suggestion-chip-focus-label-text-color, var(--md-sys-color-on-surface-variant, #49454f));--_hover-label-text-color: var(--md-suggestion-chip-hover-label-text-color, var(--md-sys-color-on-surface-variant, #49454f));--_hover-state-layer-color: var(--md-suggestion-chip-hover-state-layer-color, var(--md-sys-color-on-surface-variant, #49454f));--_hover-state-layer-opacity: var(--md-suggestion-chip-hover-state-layer-opacity, 0.08);--_label-text-color: var(--md-suggestion-chip-label-text-color, var(--md-sys-color-on-surface-variant, #49454f));--_label-text-font: var(--md-suggestion-chip-label-text-font, var(--md-sys-typescale-label-large-font, var(--md-ref-typeface-plain, Roboto)));--_label-text-line-height: var(--md-suggestion-chip-label-text-line-height, var(--md-sys-typescale-label-large-line-height, 1.25rem));--_label-text-size: var(--md-suggestion-chip-label-text-size, var(--md-sys-typescale-label-large-size, 0.875rem));--_label-text-weight: var(--md-suggestion-chip-label-text-weight, var(--md-sys-typescale-label-large-weight, var(--md-ref-typeface-weight-medium, 500)));--_pressed-label-text-color: var(--md-suggestion-chip-pressed-label-text-color, var(--md-sys-color-on-surface-variant, #49454f));--_pressed-state-layer-color: var(--md-suggestion-chip-pressed-state-layer-color, var(--md-sys-color-on-surface-variant, #49454f));--_pressed-state-layer-opacity: var(--md-suggestion-chip-pressed-state-layer-opacity, 0.12);--_disabled-outline-color: var(--md-suggestion-chip-disabled-outline-color, var(--md-sys-color-on-surface, #1d1b20));--_disabled-outline-opacity: var(--md-suggestion-chip-disabled-outline-opacity, 0.12);--_focus-outline-color: var(--md-suggestion-chip-focus-outline-color, var(--md-sys-color-on-surface-variant, #49454f));--_outline-color: var(--md-suggestion-chip-outline-color, var(--md-sys-color-outline, #79747e));--_outline-width: var(--md-suggestion-chip-outline-width, 1px);--_disabled-leading-icon-color: var(--md-suggestion-chip-disabled-leading-icon-color, var(--md-sys-color-on-surface, #1d1b20));--_disabled-leading-icon-opacity: var(--md-suggestion-chip-disabled-leading-icon-opacity, 0.38);--_focus-leading-icon-color: var(--md-suggestion-chip-focus-leading-icon-color, var(--md-sys-color-primary, #6750a4));--_hover-leading-icon-color: var(--md-suggestion-chip-hover-leading-icon-color, var(--md-sys-color-primary, #6750a4));--_leading-icon-color: var(--md-suggestion-chip-leading-icon-color, var(--md-sys-color-primary, #6750a4));--_pressed-leading-icon-color: var(--md-suggestion-chip-pressed-leading-icon-color, var(--md-sys-color-primary, #6750a4));--_icon-size: var(--md-suggestion-chip-icon-size, 18px);--_container-shape-start-start: var(--md-suggestion-chip-container-shape-start-start, var(--md-suggestion-chip-container-shape, var(--md-sys-shape-corner-small, 8px)));--_container-shape-start-end: var(--md-suggestion-chip-container-shape-start-end, var(--md-suggestion-chip-container-shape, var(--md-sys-shape-corner-small, 8px)));--_container-shape-end-end: var(--md-suggestion-chip-container-shape-end-end, var(--md-suggestion-chip-container-shape, var(--md-sys-shape-corner-small, 8px)));--_container-shape-end-start: var(--md-suggestion-chip-container-shape-end-start, var(--md-suggestion-chip-container-shape, var(--md-sys-shape-corner-small, 8px)));--_leading-space: var(--md-suggestion-chip-leading-space, 16px);--_trailing-space: var(--md-suggestion-chip-trailing-space, 16px);--_icon-label-space: var(--md-suggestion-chip-icon-label-space, 8px);--_with-leading-icon-leading-space: var(--md-suggestion-chip-with-leading-icon-leading-space, 8px)}@media(forced-colors: active){.link .outline{border-color:ActiveText}}
`
/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */;let MdSuggestionChip=class MdSuggestionChip extends SuggestionChip{};MdSuggestionChip.styles=[styles$3,styles$7,styles];MdSuggestionChip=__decorate([customElement("md-suggestion-chip")],MdSuggestionChip);
/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */const ICON_SIZE=css`20px`;const FOCUS_RING_WIDTH=css`2px`;const CHIP_PADDING=css`12px`;const RESIZE_OBSERVER_DEBOUNCE_TIMEOUT_MS=500;const closeIcon=html$1`
  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 -960 960 960" id="close-icon" slot='remove-trailing-icon'>
    <path d="M291-232.348 232.348-291l189-189-189-189L291-727.652l189 189 189-189L727.652-669l-189 189 189 189L669-232.348l-189-189-189 189Z"/>
  </svg>`;const checkedIcon=html$1`
  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 -960 960 960" id="checked-icon" slot="selected-icon">
    <path d="M395-277.348 218.348-455l57.891-57.891L395-395.131l288.761-287.76L741.652-624 395-277.348Z"/>
  </svg>`;class Chip extends LitElement{static{this.styles=css`
    :host {
      display: inline-block;
    }

    :host([disabled]) {
      pointer-events: none;
    }

    md-filter-chip {
      --md-filter-chip-disabled-label-text-color: var(--cros-sys-on_surface);
      --md-filter-chip-disabled-label-text-opacity: var(--cros-sys-opacity-disabled);
      --md-filter-chip-disabled-leading-icon-color: var(--cros-sys-disabled);
      --md-filter-chip-disabled-leading-icon-opacity: var(--cros-sys-opacity-disabled);
      --md-filter-chip-disabled-outline-color: var(--cros-sys-separator);
      --md-filter-chip-disabled-outline-opacity: var(--cros-sys-opacity-disabled);
      --md-filter-chip-disabled-selected-container-color: var(--cros-sys-disabled_container);
      --md-filter-chip-disabled-selected-container-opacity: 1;
      --md-filter-chip-disabled-trailing-icon-color: var(--cros-sys-disabled);
      --md-filter-chip-disabled-trailing-icon-opacity: var(--cros-sys-opacity-disabled);
      --md-filter-chip-focus-label-text-color: var(--cros-sys-on_surface);
      --md-filter-chip-focus-leading-icon-color: var(--cros-sys-on_surface);
      --md-filter-chip-focus-trailing-icon-color: var(--cros-sys-on_surface);
      --md-filter-chip-hover-label-text-color: var(--cros-sys-on_surface);
      --md-filter-chip-hover-leading-icon-color: var(--cros-sys-on_surface);
      --md-filter-chip-hover-trailing-icon-color: var(--cros-sys-on_surface);
      --md-filter-chip-hover-state-layer-color: var(--cros-sys-hover_on_subtle);
      --md-filter-chip-hover-state-layer-opacity: 1;
      --md-filter-chip-icon-size: ${ICON_SIZE};
      --md-filter-chip-label-text-font: var(--cros-button-1-font-family);
      --md-filter-chip-label-text-size: var(--cros-button-1-font-size);
      --md-filter-chip-label-text-line-height: var(--cros-button-1-line-height);
      --md-filter-chip-label-text-weight: var(--cros-button-1-font-weight);
      --md-filter-chip-label-text-color: var(--cros-sys-on_surface);
      --md-filter-chip-leading-icon-color: var(--cros-sys-on_surface);
      --md-filter-chip-leading-space:  ${CHIP_PADDING};
      --md-filter-chip-outline-color: var(--cros-sys-separator);
      --md-filter-chip-pressed-label-text-color: var(--cros-sys-on_surface);
      --md-filter-chip-pressed-leading-icon-color: var(--cros-sys-on_surface);
      --md-filter-chip-pressed-trailing-icon-color: var(--cros-sys-on_surface);
      --md-filter-chip-pressed-state-layer-color: var(--cros-sys-ripple_neutral_on_subtle);
      --md-filter-chip-pressed-state-layer-opacity: 1;
      --md-filter-chip-selected-container-color: var(--cros-sys-secondary_container);
      --md-filter-chip-selected-hover-label-text-color: var(--cros-sys-on_secondary_container);
      --md-filter-chip-selected-hover-state-layer-color: var(--cros-sys-hover_on_subtle);
      --md-filter-chip-selected-hover-state-layer-opacity: 1;
      --md-filter-chip-selected-label-text-color: var(--cros-sys-on_secondary_container);
      --md-filter-chip-selected-leading-icon-color: var(--cros-sys-on_secondary_container);
      --md-filter-chip-selected-outline-width: 1px;
      --md-filter-chip-selected-pressed-label-text-color: var(--cros-sys-on_secondary_container);
      --md-filter-chip-selected-pressed-state-layer-color: var(--cros-sys-ripple_neutral_on_subtle);
      --md-filter-chip-selected-pressed-state-layer-opacity: 1;
      --md-filter-chip-selected-trailing-icon-color: var(--cros-sys-on_secondary_container);
      --md-filter-chip-trailing-icon-color: var(--cros-sys-on_surface);
      --md-filter-chip-trailing-space: ${CHIP_PADDING};
      --md-focus-ring-duration: 0s;
    }

    md-suggestion-chip {
      --md-focus-ring-duration: 0s;
      --md-suggestion-chip-disabled-label-text-color: var(--cros-sys-on_surface);
      --md-suggestion-chip-disabled-label-text-opacity: var(--cros-sys-opacity-disabled);
      --md-suggestion-chip-disabled-leading-icon-color: var(--cros-sys-disabled);
      --md-suggestion-chip-disabled-leading-icon-opacity: var(--cros-sys-opacity-disabled);
      --md-suggestion-chip-disabled-outline-color: var(--cros-sys-separator);
      --md-suggestion-chip-disabled-outline-opacity: var(--cros-sys-opacity-disabled);
      --md-suggestion-chip-focus-label-text-color: var(--cros-sys-on_surface);
      --md-suggestion-chip-focus-leading-icon-color: var(--cros-sys-on_surface);
      --md-suggestion-chip-hover-label-text-color: var(--cros-sys-on_surface);
      --md-suggestion-chip-hover-leading-icon-color: var(--cros-sys-on_surface);
      --md-suggestion-chip-hover-state-layer-color: var(--cros-sys-hover_on_subtle);
      --md-suggestion-chip-hover-state-layer-opacity: 1;
      --md-suggestion-chip-icon-size: ${ICON_SIZE};
      --md-suggestion-chip-label-text-font: var(--cros-button-1-font-family);
      --md-suggestion-chip-label-text-size: var(--cros-button-1-font-size);
      --md-suggestion-chip-label-text-line-height: var(--cros-button-1-line-height);
      --md-suggestion-chip-label-text-weight: var(--cros-button-1-font-weight);
      --md-suggestion-chip-label-text-color: var(--cros-sys-on_surface);
      --md-suggestion-chip-leading-icon-color: var(--cros-sys-on_surface);
      --md-suggestion-chip-leading-space: ${CHIP_PADDING};
      --md-suggestion-chip-outline-color: var(--cros-sys-separator);
      --md-suggestion-chip-pressed-label-text-color: var(--cros-sys-on_surface);
      --md-suggestion-chip-pressed-leading-icon-color: var(--cros-sys-on_surface);
      --md-suggestion-chip-pressed-state-layer-color: var(--cros-sys-ripple_neutral_on_subtle);
      --md-suggestion-chip-pressed-state-layer-opacity: 1;
      --md-suggestion-chip-trailing-space: ${CHIP_PADDING};
    }

    md-input-chip {
      --md-focus-ring-duration: 0s;
      --md-input-chip-disabled-label-text-color: var(--cros-sys-on_surface);
      --md-input-chip-disabled-label-text-opacity: var(--cros-sys-opacity-disabled);
      --md-input-chip-disabled-leading-icon-color: var(--cros-sys-disabled);
      --md-input-chip-disabled-leading-icon-opacity: var(--cros-sys-opacity-disabled);
      --md-input-chip-disabled-outline-color: var(--cros-sys-separator);
      --md-input-chip-disabled-outline-opacity: var(--cros-sys-opacity-disabled);
      --md-input-chip-focus-label-text-color: var(--cros-sys-on_surface);
      --md-input-chip-focus-leading-icon-color: var(--cros-sys-on_surface);
      --md-input-chip-focus-trailing-icon-color: var(--cros-sys-on_surface);
      --md-input-chip-hover-label-text-color: var(--cros-sys-on_surface);
      --md-input-chip-hover-leading-icon-color: var(--cros-sys-on_surface);
      --md-input-chip-hover-state-layer-color: var(--cros-sys-hover_on_subtle);
      --md-input-chip-hover-state-layer-opacity: 1;
      --md-input-chip-hover-trailing-icon-color: var(--cros-sys-on_surface);
      --md-input-chip-icon-size: ${ICON_SIZE};
      --md-input-chip-label-text-font: var(--cros-button-1-font-family);
      --md-input-chip-label-text-size: var(--cros-button-1-font-size);
      --md-input-chip-label-text-line-height: var(--cros-button-1-line-height);
      --md-input-chip-label-text-weight: var(--cros-button-1-font-weight);
      --md-input-chip-label-text-color: var(--cros-sys-on_surface);
      --md-input-chip-leading-icon-color: var(--cros-sys-on_surface);
      --md-input-chip-leading-space: ${CHIP_PADDING};
      --md-input-chip-outline-color: var(--cros-sys-separator);
      --md-input-chip-pressed-label-text-color: var(--cros-sys-on_surface);
      --md-input-chip-pressed-leading-icon-color: var(--cros-sys-on_surface);
      --md-input-chip-pressed-state-layer-color: var(--cros-sys-ripple_neutral_on_subtle);
      --md-input-chip-pressed-state-layer-opacity: 1;
      --md-input-chip-pressed-trailing-icon-color: var(--cros-sys-on_surface);
      --md-input-chip-trailing-space: ${CHIP_PADDING};
    }

    md-filter-chip,
    md-suggestion-chip,
    md-input-chip {
      max-width: 100%;
    }

    :host([avatar]) md-input-chip {
      --md-input-chip-container-shape: 9999px;
    }

    md-filter-chip::part(focus-ring),
    md-filter-chip::part(trailing-focus-ring),
    md-suggestion-chip::part(focus-ring),
    md-input-chip::part(focus-ring),
    md-input-chip::part(trailing-focus-ring) {
      --md-focus-ring-color: var(--cros-sys-focus_ring);
      --md-focus-ring-width: ${FOCUS_RING_WIDTH};
    }
    #close-icon {
      fill: var(--cros-sys-on_surface);
      height: ${ICON_SIZE};
      width: ${ICON_SIZE};
    }
    #checked-icon {
      height: ${ICON_SIZE};
      width: ${ICON_SIZE};
    }
    :host([type="filter"]) #checked-icon {
      fill: var(--cros-sys-on_surface);
    }

    .label-wrapper {
      overflow: hidden;
      text-overflow: ellipsis;
      white-space: nowrap;
    }
  `}static{this.shadowRootOptions={mode:"open",delegatesFocus:true}}static{this.properties={disabled:{type:Boolean,reflect:true},selected:{type:Boolean},label:{type:String},type:{type:String},trailingIcon:{type:Boolean},avatar:{type:Boolean},showTooltipWhenTruncated:{type:Boolean,attribute:"show-tooltip-when-truncated"}}}set selected(value){if(this.type!=="filter"){return}this.updateComplete.then((()=>this.shadowRoot.querySelector("md-filter-chip").selected=value))}get selected(){return this.shadowRoot?.querySelector("md-filter-chip")?.selected??false}constructor(){super();this.resizeObserver=null;this.resizeObserverDebounceTimeout=-1;this.onClick=e=>{if(this.disabled){e.stopImmediatePropagation();e.preventDefault();return}};this.disabled=false;this.selected=false;this.type="filter";this.trailingIcon=false;this.label="";this.avatar=false;this.showTooltipWhenTruncated=false;this.addEventListener("click",this.onClick)}firstUpdated(){if(this.showTooltipWhenTruncated){this.resizeObserver=new ResizeObserver(this.onChipResized.bind(this));this.resizeObserver.observe(this)}}disconnectedCallback(){super.disconnectedCallback();if(this.resizeObserver){this.resizeObserver.disconnect()}clearTimeout(this.resizeObserverDebounceTimeout)}render(){if(this.type==="filter"){return this.renderWrapperWithMaybeTooltip(html$1`
        <md-filter-chip
            ?disabled=${this.disabled}
            ?selected=${this.selected}>
          <slot slot='icon' name='icon'></slot>
          ${this.renderLabel()}
          ${checkedIcon}
        </md-filter-chip>
        `)}if(this.trailingIcon||this.avatar){return this.renderWrapperWithMaybeTooltip(html$1`
        <md-input-chip
          ?disabled=${this.disabled}
          ?avatar=${this.avatar}>
            <slot slot='icon' name='icon'></slot>
            ${this.renderLabel()}
            ${closeIcon}
          </md-input-chip>
        `)}return this.renderWrapperWithMaybeTooltip(html$1`
      <md-suggestion-chip ?disabled=${this.disabled}>
        <slot slot='icon' name='icon'></slot>
        ${this.renderLabel()}
      </md-suggestion-chip>
      `)}renderWrapperWithMaybeTooltip(content){if(!this.showTooltipWhenTruncated){return content}return html$1`
      <div id="chip-wrapper">
        ${content}
        <cros-tooltip
            anchor="chip-wrapper"
            label=${this.label}
            ?hidden=${!this.isLabelTruncated()}>
        </cros-tooltip>
      </div>
      `}renderLabel(){return html$1`<div class="label-wrapper">${this.label}</div>`}onChipResized(){clearTimeout(this.resizeObserverDebounceTimeout);this.resizeObserverDebounceTimeout=setTimeout((()=>{this.requestUpdate()}),RESIZE_OBSERVER_DEBOUNCE_TIMEOUT_MS)}isLabelTruncated(){if(!this.renderRoot){return false}const labelWrapper=this.renderRoot.querySelector(".label-wrapper");if(!labelWrapper){return false}return labelWrapper.scrollWidth>labelWrapper.clientWidth}}customElements.define("cros-chip",Chip);function getTemplate$1S(){return html`<!--_html_template_start_--><style>
  :host {
    --key-alpha-numeric-selected-bg-color: var(--cros-bg-color-dropped-elevation-1);
    --key-container-height: 32px;
    --key-container-padding-bottom: 6px;
    --key-container-padding-top: 6px;
    --key-modifier-selected-bg-color: var(--cros-highlight-color);
    --key-modifier-selected-shadow-color: var(--cros-highlight-color);
  }

  :host-context(body.jelly-enabled) {
    --key-alpha-numeric-selected-bg-color: var(--cros-sys-surface_variant);
    --key-modifier-selected-bg-color: var(--cros-sys-highlight_shape);
    --key-modifier-selected-shadow-color: var(--cros-sys-highlight_shape);
  }

  .key-container {
    align-items: center;
    border-radius: 12px;
    box-sizing: border-box;
    display: inline-flex;
    font-weight: 500;
    height: var(--key-container-height);
    justify-content: center;
    margin-bottom: 2px;
    margin-inline-end: 8px;
    min-width: 32px;
    padding-bottom: var(--key-container-padding-bottom);
    padding-top: var(--key-container-padding-top);
    vertical-align: middle;
  }

  :host([narrow]) .key-container {
    margin-inline-end: 4px;
    padding-inline: 4px;
  }

  #key-text {
    color: var(--cros-text-color-secondary);
    font: var(--cros-button-2-font);
  }

  :host([key-state='not-selected']) .key-container {
    outline: 1px solid var(--cros-separator-color);
  }

  :host([key-state='not-selected']) #key-text {
    color: var(--cros-text-color-disabled);
  }

  :host([key-state='not-selected']) #key-icon{
    --iron-icon-fill-color: var(--cros-text-color-disabled);
  }

  :host([key-state='modifier-selected']) .key-container {
    background-color: var(--key-modifier-selected-bg-color);
    border: none;
    box-shadow: 0 1px 1px var(--key-modifier-selected-shadow-color);
    transition: all 300ms ease-in-out;
  }

  :host([key-state='modifier-selected']:not([key='meta']):not([key='Meta'])) .key-container {
    min-width: 44px;
    padding-inline: 12px;
  }

  :host([key-state='modifier-selected'][key='meta']) .key-container,
  :host([key-state='modifier-selected'][key='Meta']) .key-container {
    padding-inline: 6px;
  }

  :host([key-state='alpha-numeric-selected']) .key-container {
    background-color: var(--key-alpha-numeric-selected-bg-color);
    border: none;
    box-shadow: 0 1px 1px var(--cros-bg-color-dropped-elevation-1);
    transition: all 300ms ease-in-out;
  }

  :host([key-state='alpha-numeric-selected'][has-icon]) .key-container {
    padding-inline: 6px;
  }

  :host([key-state='alpha-numeric-selected']:not([has-icon])) .key-container {
    padding-inline: 11px;
  }

  :host([highlighted][key-state='modifier-selected']) div.key-container {
    background-color: var(--cros-color-prominent);
  }

  :host([highlighted][key-state='modifier-selected']) #key-text {
    color: var(--cros-button-label-color-primary);
  }

  :host([highlighted][key-state='alpha-numeric-selected']) div.key-container {
    background-color: var(--cros-bg-color);
  }

  :host([highlighted][key-state='modifier-selected']) #key-icon {
    --iron-icon-fill-color: var(--cros-button-label-color-primary);
  }

  :host([key-state='not-selected'][key='ctrl']) .key-container,
  :host([key-state='not-selected'][key='alt']) .key-container,
  :host([key-state='not-selected'][key='shift']) .key-container{
    min-width: 44px;
    padding-inline: 12px;
  }

  #key-icon {
    --iron-icon-height: 16px;
    --iron-icon-width: 16px;
    --iron-icon-fill-color: var(--cros-text-color-secondary);
  }
</style>

<div id="key" class="key-container">
  <template is="dom-if" if="[[getIconIdForKey(key)]]">
    <div id="keyIcon" aria-label="[[getAriaLabelForIcon(key)]]" role="img">
      <iron-icon icon="[[getIconIdForKey(key)]]" id="key-icon"></iron-icon>
    </div>
  </template>
  <template is="dom-if" if="[[!getIconIdForKey(key)]]">
    <span id="key-text">[[key]]</span>
  </template>
</div>
<!--_html_template_end_-->`}
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const MetaKeySpec={$:mojo.internal.Enum()};var MetaKey$1;(function(MetaKey){MetaKey[MetaKey["MIN_VALUE"]=0]="MIN_VALUE";MetaKey[MetaKey["MAX_VALUE"]=4]="MAX_VALUE";MetaKey[MetaKey["kSearch"]=0]="kSearch";MetaKey[MetaKey["kLauncher"]=1]="kLauncher";MetaKey[MetaKey["kLauncherRefresh"]=2]="kLauncherRefresh";MetaKey[MetaKey["kExternalMeta"]=3]="kExternalMeta";MetaKey[MetaKey["kCommand"]=4]="kCommand"})(MetaKey$1||(MetaKey$1={}));
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var KeyInputState;(function(KeyInputState){KeyInputState["NOT_SELECTED"]="not-selected";KeyInputState["MODIFIER_SELECTED"]="modifier-selected";KeyInputState["ALPHANUMERIC_SELECTED"]="alpha-numeric-selected"})(KeyInputState||(KeyInputState={}));var Modifier$1;(function(Modifier){Modifier[Modifier["NONE"]=0]="NONE";Modifier[Modifier["SHIFT"]=2]="SHIFT";Modifier[Modifier["CONTROL"]=4]="CONTROL";Modifier[Modifier["ALT"]=8]="ALT";Modifier[Modifier["COMMAND"]=16]="COMMAND";Modifier[Modifier["FN_KEY"]=32]="FN_KEY"})(Modifier$1||(Modifier$1={}));const Modifiers=[Modifier$1.SHIFT,Modifier$1.CONTROL,Modifier$1.ALT,Modifier$1.COMMAND,Modifier$1.FN_KEY];var AllowedModifierKeyCodes;(function(AllowedModifierKeyCodes){AllowedModifierKeyCodes[AllowedModifierKeyCodes["SHIFT"]=16]="SHIFT";AllowedModifierKeyCodes[AllowedModifierKeyCodes["CTRL"]=17]="CTRL";AllowedModifierKeyCodes[AllowedModifierKeyCodes["ALT"]=18]="ALT";AllowedModifierKeyCodes[AllowedModifierKeyCodes["META_LEFT"]=91]="META_LEFT";AllowedModifierKeyCodes[AllowedModifierKeyCodes["META_RIGHT"]=92]="META_RIGHT";AllowedModifierKeyCodes[AllowedModifierKeyCodes["FN_KEY"]=255]="FN_KEY"})(AllowedModifierKeyCodes||(AllowedModifierKeyCodes={}));const ModifierKeyCodes=[AllowedModifierKeyCodes.SHIFT,AllowedModifierKeyCodes.ALT,AllowedModifierKeyCodes.CTRL,AllowedModifierKeyCodes.META_LEFT,AllowedModifierKeyCodes.META_RIGHT,AllowedModifierKeyCodes.FN_KEY];const MetaKey=MetaKey$1;const getSortedModifiers=modifierStrings=>{const sortOrder=["meta","ctrl","alt","shift","fn"];if(modifierStrings.length<=1){return modifierStrings}return modifierStrings.sort(((a,b)=>sortOrder.indexOf(a)-sortOrder.indexOf(b)))};const KeyToIconNameMap={Accessibility:"accessibility",ArrowDown:"arrow-down",ArrowLeft:"arrow-left",ArrowRight:"arrow-right",ArrowUp:"arrow-up",AudioVolumeDown:"volume-down",AudioVolumeMute:"volume-mute",AudioVolumeUp:"volume-up",BrightnessDown:"display-brightness-down",BrightnessUp:"brightness-up-refresh",BrowserBack:"back",BrowserForward:"forward",BrowserHome:"browser-home",BrowserRefresh:"refresh",BrowserSearch:"browser-search",CameraAccessToggle:"camera-access-toggle",ContextMenu:"menu",DoNotDisturb:"do-not-disturb",EmojiPicker:"emoji-picker",EnableOrToggleDictation:"dictation-toggle",KeyboardBacklightToggle:"keyboard-brightness-toggle",KeyboardBrightnessUp:"keyboard-brightness-up",KeyboardBrightnessDown:"keyboard-brightness-down",LaunchApplication1:"overview-refresh",LaunchApplication2:"calculator",LaunchAssistant:"assistant",LaunchMail:"launch-mail",MediaFastForward:"fast-forward",MediaPause:"pause",MediaPlay:"play",MediaPlayPause:"play-pause",MediaTrackNext:"next-track",MediaTrackPrevious:"last-track",MicrophoneMuteToggle:"microphone-mute",ModeChange:"globe",ViewAllApps:"view-all-apps",Power:"power",PrintScreen:"screenshot",PrivacyScreenToggle:"electronic-privacy-screen",Settings:"settings-icon",Standby:"lock",ZoomToggle:"fullscreen",QuickInsert:"quick-insert"};const modifierBitMaskToString$1=new Map([[Modifier$1.CONTROL,"ctrl"],[Modifier$1.SHIFT,"shift"],[Modifier$1.ALT,"alt"],[Modifier$1.COMMAND,"command"]]);function createInputKeyParts(shortcutLabelProperties,useNarrowLayout=false){const inputKeys=[];const pressedModifiers=[];for(const[bitValue,modifierName]of modifierBitMaskToString$1){if((shortcutLabelProperties.accelerator.modifiers&bitValue)!==0){const key=document.createElement("shortcut-input-key");key.keyState=KeyInputState.MODIFIER_SELECTED;key.key=modifierName==="command"?"meta":modifierName;key.metaKey=shortcutLabelProperties.metaKey;key.narrow=useNarrowLayout;inputKeys.push(key);pressedModifiers.push(modifierName)}}const keyDisplay=shortcutLabelProperties.keyDisplay;if(!pressedModifiers.includes(keyDisplay.toLowerCase())){const key=document.createElement("shortcut-input-key");key.keyState=KeyInputState.ALPHANUMERIC_SELECTED;key.key=keyDisplay;key.narrow=useNarrowLayout;inputKeys.push(key)}return inputKeys}function createShortcutAppendedKeyLabel(shortcutLabelProperties,useNarrowLayout=false){const reminder=document.createElement("div");reminder.innerHTML=shortcutLabelProperties.shortcutLabelText;const keyCodes=document.createElement("span");keyCodes.append(...createInputKeyParts(shortcutLabelProperties,useNarrowLayout));reminder.firstElementChild.replaceWith(keyCodes);reminder.classList.add("reminder-label");return reminder}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const META_KEY="meta";const LWIN_KEY="Meta";const ShortcutInputKeyElementBase=I18nMixin(PolymerElement);class ShortcutInputKeyElement extends ShortcutInputKeyElementBase{constructor(){super(...arguments);this.metaKey=MetaKey.kSearch}static get is(){return"shortcut-input-key"}static get properties(){return{key:{type:String,value:"",reflectToAttribute:true,observer:ShortcutInputKeyElement.prototype.onKeyChanged},keyState:{type:String,value:KeyInputState.NOT_SELECTED,reflectToAttribute:true},narrow:{type:Boolean,value:false,reflectToAttribute:true},highlighted:{type:Boolean,value:false,reflectToAttribute:true},hasIcon:{type:Boolean,value:false,reflectToAttribute:true},metaKey:{type:Object,reflectToAttribute:true}}}connectedCallback(){super.connectedCallback()}static get template(){return getTemplate$1S()}getIconIdForKey(){if(this.key===LWIN_KEY){this.keyState=KeyInputState.MODIFIER_SELECTED}if(this.key===META_KEY||this.key===LWIN_KEY){switch(this.metaKey){case MetaKey.kLauncherRefresh:return"shortcut-input-keys:launcher-refresh";case MetaKey.kSearch:return"shortcut-input-keys:search";case MetaKey.kLauncher:default:return"shortcut-input-keys:launcher"}}const iconName=KeyToIconNameMap[this.key];if(iconName){return`shortcut-input-keys:${iconName}`}return null}static getAriaLabelStringId(key,metaKey){if(key===META_KEY||key===LWIN_KEY){switch(metaKey){case MetaKey.kLauncherRefresh:return"iconLabelOpenLauncher";case MetaKey.kSearch:return"iconLabelOpenSearch";case MetaKey.kLauncher:default:return"iconLabelOpenLauncher"}}return`iconLabel${key}`}getAriaLabelForIcon(){const ariaLabelStringId=ShortcutInputKeyElement.getAriaLabelStringId(this.key,this.metaKey);assert(this.i18nExists(ariaLabelStringId),`String ID ${ariaLabelStringId} should exist, but it doesn't.`);return this.i18n(ariaLabelStringId)}onKeyChanged(){if(this.key in KeyToIconNameMap){this.hasIcon=true;return}this.hasIcon=false}}customElements.define(ShortcutInputKeyElement.is,ShortcutInputKeyElement);
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class FakeObservableState{constructor(){this.observers_=[];this.observations_=[];this.index_=-1;this.timerId_=-1}setObservableData(observations){this.observations_=observations;this.index_=0}addObserver(callback){this.observers_.push(callback)}startTriggerOnInterval(intervalMs){assert$1(this.index_>=0);if(this.timerId_!=-1){this.stopTriggerOnInterval()}assert$1(this.timerId_==-1);this.timerId_=setInterval(this.trigger.bind(this),intervalMs)}stopTriggerOnInterval(){if(this.timerId_!=-1){clearInterval(this.timerId_);this.timerId_=-1}}trigger(){assert$1(this.observations_.length>0);assert$1(this.index_>=0);assert$1(this.index_<this.observations_.length);const value=this.observations_[this.index_];this.index_=(this.index_+1)%this.observations_.length;for(const fn of this.observers_){if(Array.isArray(value)){fn.apply(null,value)}else{fn(value)}}}}class FakeObservables{constructor(){this.observables_=new Map;this.sharedObservables_=new Set}register(methodName){this.observables_.set(methodName,new FakeObservableState)}registerObservableWithArg(methodName){this.sharedObservables_.add(methodName)}observe(methodName,callback){this.getObservable_(methodName).addObserver(callback)}observeWithArg(methodName,arg,callback){this.getObservable_(this.lookupMethodWithArgName_(methodName,arg)).addObserver(callback)}setObservableData(methodName,observations){this.getObservable_(methodName).setObservableData(observations)}setObservableDataForArg(methodName,arg,observations){assert$1(this.sharedObservables_.has(methodName),`${methodName} not found in sharedObservables_`);const methodNameToRegister=this.createMethodWithArgName_(methodName,arg);const isMethodRegistered=!!this.observables_.get(methodNameToRegister);if(!isMethodRegistered){this.register(methodNameToRegister)}this.setObservableData(methodNameToRegister,observations)}startTriggerOnInterval(methodName,intervalMs){this.getObservable_(methodName).startTriggerOnInterval(intervalMs)}stopTriggerOnInterval(methodName){this.getObservable_(methodName).stopTriggerOnInterval()}startTriggerOnIntervalWithArg(methodName,arg,intervalMs){this.getObservable_(this.lookupMethodWithArgName_(methodName,arg)).startTriggerOnInterval(intervalMs)}stopTriggerOnIntervalWithArg(methodName,arg){this.getObservable_(this.lookupMethodWithArgName_(methodName,arg)).stopTriggerOnInterval()}stopAllTriggerIntervals(){for(const obs of this.observables_.values()){obs.stopTriggerOnInterval()}}trigger(methodName){this.getObservable_(methodName).trigger()}triggerWithArg(methodName,arg){this.getObservable_(this.lookupMethodWithArgName_(methodName,arg)).trigger()}getObservable_(methodName){const observable=this.observables_.get(methodName);assert$1(!!observable,`Observable '${methodName}' not found.`);return observable}createMethodWithArgName_(methodName,arg){return`${methodName}_${arg}`}lookupMethodWithArgName_(methodName,arg){const observableName=this.createMethodWithArgName_(methodName,arg);assert$1(!!this.observables_.get(observableName),`Observable '${observableName}' not found.`);return observableName}}
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class FakeShortcutInputProvider{constructor(){this.observables=new FakeObservables;this.registerObservables()}getPrerewrittenKeyEvent(){return this.prerewrittenKeyEvent}sendKeyPressEvent(prerewrittenKeyEvent,keyEvent){this.observables.setObservableData("ShortcutInputObserver_OnShortcutInputEventPressed",[{prerewrittenKeyEvent:prerewrittenKeyEvent,keyEvent:keyEvent}]);this.observables.trigger("ShortcutInputObserver_OnShortcutInputEventPressed")}sendKeyReleaseEvent(prerewrittenKeyEvent,keyEvent){this.observables.setObservableData("ShortcutInputObserver_OnShortcutInputEventReleased",[{prerewrittenKeyEvent:prerewrittenKeyEvent,keyEvent:keyEvent}]);this.observables.trigger("ShortcutInputObserver_OnShortcutInputEventReleased")}startObservingShortcutInput(observer){this.observables.observe("ShortcutInputObserver_OnShortcutInputEventPressed",(detail=>{observer.onShortcutInputEventPressed(detail.prerewrittenKeyEvent,detail.keyEvent);this.prerewrittenKeyEvent=detail.prerewrittenKeyEvent}));this.observables.observe("ShortcutInputObserver_OnShortcutInputEventReleased",(detail=>{observer.onShortcutInputEventReleased(detail.prerewrittenKeyEvent,detail.keyEvent);this.prerewrittenKeyEvent=detail.prerewrittenKeyEvent}))}stopObservingShortcutInput(){this.observables=new FakeObservables;this.registerObservables()}registerObservables(){this.observables.register("ShortcutInputObserver_OnShortcutInputEventPressed");this.observables.register("ShortcutInputObserver_OnShortcutInputEventReleased")}}function getTemplate$1R(){return html`<!--_html_template_start_--><style>
  .flex-row {
    display: flex;
    flex-direction: row;
    justify-content: center;
  }

  #confirmContainer {
    display: flex;
    flex-direction: row;
  }

  #container:focus {
    outline: none;
  }

  #keySeparator {
    align-items: center;
    display: flex;
    padding-inline-end: 8px;
  }
</style>

<div id="container" class="flex-row" tabindex="-1">
  <template is="dom-if" if="[[shouldShowConfirmView(isCapturing)]]">
    <div id="confirmContainer">
      <template is="dom-repeat" items="[[modifiers]]">
        <shortcut-input-key key="[[item]]" key-state="modifier-selected"
            meta-key="[[metaKey]]">
        </shortcut-input-key>
      </template>
      <template is="dom-if"
          if="[[shouldShowSeparator(showSeparator, modifiers)]]">
        <div id="keySeparator"> + </div>
      </template>
      <template is="dom-if"
          if="[[shouldShowSelectedKey(pendingKeyEvent.*,
                                      pendingPrerewrittenKeyEvent.*)]]">
        <shortcut-input-key id="confirmKey"
            key="[[getConfirmKey(pendingKeyEvent.*,
                                 pendingPrerewrittenKeyEvent.*)]]"
            key-state="[[getConfirmKeyState(pendingKeyEvent.*,
                                            pendingPrerewrittenKeyEvent.*)]]"
            meta-key="[[metaKey]]">
        </shortcut-input-key>
      </template>
    </div>
  </template>
  <template is="dom-if" if="[[shouldShowEditView(isCapturing)]]">
    <div id="editContainer" class="flex-row">
      <shortcut-input-key id="ctrlKey"
          key="ctrl"
          key-state="[[getCtrlState(pendingKeyEvent.*,
                                    pendingPrerewrittenKeyEvent.*)]]">
      </shortcut-input-key>
      <shortcut-input-key id="altKey"
          key="alt"
          key-state="[[getAltState(pendingKeyEvent.*,
                                   pendingPrerewrittenKeyEvent.*)]]">
      </shortcut-input-key>
      <shortcut-input-key id="shiftKey"
          key="shift"
          key-state="[[getShiftState(pendingKeyEvent.*,
                                    pendingPrerewrittenKeyEvent.*)]]">
      </shortcut-input-key>
      <shortcut-input-key id="searchKey"
          key="meta"
          key-state="[[getSearchState(pendingKeyEvent.*,
                                      pendingPrerewrittenKeyEvent.*)]]"
          meta-key="[[metaKey]]">
      </shortcut-input-key>
      <template is="dom-if" if="[[hasFunctionKey]]">
        <shortcut-input-key id="functionKey"
            key="fn"
            key-state="[[getFunctionState(pendingKeyEvent.*,
                                        pendingPrerewrittenKeyEvent.*)]]"
            meta-key="[[metaKey]]">
        </shortcut-input-key>
      </template>
      <div id="keySeparator"> + </div>
      <shortcut-input-key id="pendingKey"
          key="[[getKey(pendingKeyEvent.*, pendingPrerewrittenKeyEvent.*)]]"
          key-state="[[getKeyState(pendingKeyEvent.*,
                                   pendingPrerewrittenKeyEvent.*)]]"
          meta-key="[[metaKey]]">
      </shortcut-input-key>
    </div>
  </template>
</div>
<!--_html_template_end_-->`}
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const AcceleratorActionSpec={$:mojo.internal.Enum()};var AcceleratorAction;(function(AcceleratorAction){AcceleratorAction[AcceleratorAction["MIN_VALUE"]=0]="MIN_VALUE";AcceleratorAction[AcceleratorAction["MAX_VALUE"]=9029]="MAX_VALUE";AcceleratorAction[AcceleratorAction["kBrightnessDown"]=0]="kBrightnessDown";AcceleratorAction[AcceleratorAction["kBrightnessUp"]=1]="kBrightnessUp";AcceleratorAction[AcceleratorAction["kCycleBackwardMru"]=2]="kCycleBackwardMru";AcceleratorAction[AcceleratorAction["kCycleForwardMru"]=3]="kCycleForwardMru";AcceleratorAction[AcceleratorAction["kCycleSameAppWindowsBackward"]=4]="kCycleSameAppWindowsBackward";AcceleratorAction[AcceleratorAction["kCycleSameAppWindowsForward"]=5]="kCycleSameAppWindowsForward";AcceleratorAction[AcceleratorAction["kDesksActivateDeskLeft"]=6]="kDesksActivateDeskLeft";AcceleratorAction[AcceleratorAction["kDesksActivateDeskRight"]=7]="kDesksActivateDeskRight";AcceleratorAction[AcceleratorAction["kDesksMoveActiveItemLeft"]=8]="kDesksMoveActiveItemLeft";AcceleratorAction[AcceleratorAction["kDesksMoveActiveItemRight"]=9]="kDesksMoveActiveItemRight";AcceleratorAction[AcceleratorAction["kDesksNewDesk"]=10]="kDesksNewDesk";AcceleratorAction[AcceleratorAction["kDesksRemoveCurrentDesk"]=11]="kDesksRemoveCurrentDesk";AcceleratorAction[AcceleratorAction["kDesksActivate0"]=12]="kDesksActivate0";AcceleratorAction[AcceleratorAction["kDesksActivate1"]=13]="kDesksActivate1";AcceleratorAction[AcceleratorAction["kDesksActivate2"]=14]="kDesksActivate2";AcceleratorAction[AcceleratorAction["kDesksActivate3"]=15]="kDesksActivate3";AcceleratorAction[AcceleratorAction["kDesksActivate4"]=16]="kDesksActivate4";AcceleratorAction[AcceleratorAction["kDesksActivate5"]=17]="kDesksActivate5";AcceleratorAction[AcceleratorAction["kDesksActivate6"]=18]="kDesksActivate6";AcceleratorAction[AcceleratorAction["kDesksActivate7"]=19]="kDesksActivate7";AcceleratorAction[AcceleratorAction["kDesksToggleAssignToAllDesks"]=20]="kDesksToggleAssignToAllDesks";AcceleratorAction[AcceleratorAction["kDisableCapsLock"]=21]="kDisableCapsLock";AcceleratorAction[AcceleratorAction["kEnableOrToggleDictation"]=22]="kEnableOrToggleDictation";AcceleratorAction[AcceleratorAction["kExit"]=23]="kExit";AcceleratorAction[AcceleratorAction["kFocusCameraPreview"]=24]="kFocusCameraPreview";AcceleratorAction[AcceleratorAction["kFocusNextPane"]=25]="kFocusNextPane";AcceleratorAction[AcceleratorAction["kFocusPreviousPane"]=26]="kFocusPreviousPane";AcceleratorAction[AcceleratorAction["kFocusShelf"]=27]="kFocusShelf";AcceleratorAction[AcceleratorAction["kFocusPip"]=28]="kFocusPip";AcceleratorAction[AcceleratorAction["kKeyboardBacklightToggle"]=29]="kKeyboardBacklightToggle";AcceleratorAction[AcceleratorAction["kKeyboardBrightnessDown"]=30]="kKeyboardBrightnessDown";AcceleratorAction[AcceleratorAction["kKeyboardBrightnessUp"]=31]="kKeyboardBrightnessUp";AcceleratorAction[AcceleratorAction["kLaunchApp0"]=32]="kLaunchApp0";AcceleratorAction[AcceleratorAction["kLaunchApp1"]=33]="kLaunchApp1";AcceleratorAction[AcceleratorAction["kLaunchApp2"]=34]="kLaunchApp2";AcceleratorAction[AcceleratorAction["kLaunchApp3"]=35]="kLaunchApp3";AcceleratorAction[AcceleratorAction["kLaunchApp4"]=36]="kLaunchApp4";AcceleratorAction[AcceleratorAction["kLaunchApp5"]=37]="kLaunchApp5";AcceleratorAction[AcceleratorAction["kLaunchApp6"]=38]="kLaunchApp6";AcceleratorAction[AcceleratorAction["kLaunchApp7"]=39]="kLaunchApp7";AcceleratorAction[AcceleratorAction["kLaunchLastApp"]=40]="kLaunchLastApp";AcceleratorAction[AcceleratorAction["kLockPressed"]=41]="kLockPressed";AcceleratorAction[AcceleratorAction["kLockReleased"]=42]="kLockReleased";AcceleratorAction[AcceleratorAction["kLockScreen"]=43]="kLockScreen";AcceleratorAction[AcceleratorAction["kMagnifierZoomIn"]=44]="kMagnifierZoomIn";AcceleratorAction[AcceleratorAction["kMagnifierZoomOut"]=45]="kMagnifierZoomOut";AcceleratorAction[AcceleratorAction["kMediaFastForward"]=46]="kMediaFastForward";AcceleratorAction[AcceleratorAction["kMediaNextTrack"]=47]="kMediaNextTrack";AcceleratorAction[AcceleratorAction["kMediaPause"]=48]="kMediaPause";AcceleratorAction[AcceleratorAction["kMediaPlay"]=49]="kMediaPlay";AcceleratorAction[AcceleratorAction["kMediaPlayPause"]=50]="kMediaPlayPause";AcceleratorAction[AcceleratorAction["kMediaPrevTrack"]=51]="kMediaPrevTrack";AcceleratorAction[AcceleratorAction["kMediaRewind"]=52]="kMediaRewind";AcceleratorAction[AcceleratorAction["kMediaStop"]=53]="kMediaStop";AcceleratorAction[AcceleratorAction["kMicrophoneMuteToggle"]=54]="kMicrophoneMuteToggle";AcceleratorAction[AcceleratorAction["kMoveActiveWindowBetweenDisplays"]=55]="kMoveActiveWindowBetweenDisplays";AcceleratorAction[AcceleratorAction["kNewIncognitoWindow"]=56]="kNewIncognitoWindow";AcceleratorAction[AcceleratorAction["kNewTab"]=57]="kNewTab";AcceleratorAction[AcceleratorAction["kNewWindow"]=58]="kNewWindow";AcceleratorAction[AcceleratorAction["kOpenCalculator"]=59]="kOpenCalculator";AcceleratorAction[AcceleratorAction["kOpenCrosh"]=60]="kOpenCrosh";AcceleratorAction[AcceleratorAction["kOpenDiagnostics"]=61]="kOpenDiagnostics";AcceleratorAction[AcceleratorAction["kOpenFeedbackPage"]=62]="kOpenFeedbackPage";AcceleratorAction[AcceleratorAction["kOpenFileManager"]=63]="kOpenFileManager";AcceleratorAction[AcceleratorAction["kOpenGetHelp"]=64]="kOpenGetHelp";AcceleratorAction[AcceleratorAction["kPasteClipboardHistoryPlainText"]=65]="kPasteClipboardHistoryPlainText";AcceleratorAction[AcceleratorAction["kPowerPressed"]=66]="kPowerPressed";AcceleratorAction[AcceleratorAction["kPowerReleased"]=67]="kPowerReleased";AcceleratorAction[AcceleratorAction["kPrintUiHierarchies"]=68]="kPrintUiHierarchies";AcceleratorAction[AcceleratorAction["kPrivacyScreenToggle"]=69]="kPrivacyScreenToggle";AcceleratorAction[AcceleratorAction["kRestoreTab"]=70]="kRestoreTab";AcceleratorAction[AcceleratorAction["kRotateScreen"]=71]="kRotateScreen";AcceleratorAction[AcceleratorAction["kRotateWindow"]=72]="kRotateWindow";AcceleratorAction[AcceleratorAction["kScaleUiDown"]=73]="kScaleUiDown";AcceleratorAction[AcceleratorAction["kScaleUiReset"]=74]="kScaleUiReset";AcceleratorAction[AcceleratorAction["kScaleUiUp"]=75]="kScaleUiUp";AcceleratorAction[AcceleratorAction["kShowEmojiPicker"]=76]="kShowEmojiPicker";AcceleratorAction[AcceleratorAction["kToggleImeMenuBubble"]=77]="kToggleImeMenuBubble";AcceleratorAction[AcceleratorAction["kShowShortcutViewer"]=78]="kShowShortcutViewer";AcceleratorAction[AcceleratorAction["kShowTaskManager"]=79]="kShowTaskManager";AcceleratorAction[AcceleratorAction["kStartAssistant"]=80]="kStartAssistant";AcceleratorAction[AcceleratorAction["kStopScreenRecording"]=81]="kStopScreenRecording";AcceleratorAction[AcceleratorAction["kSuspend"]=82]="kSuspend";AcceleratorAction[AcceleratorAction["kSwapPrimaryDisplay"]=83]="kSwapPrimaryDisplay";AcceleratorAction[AcceleratorAction["kSwitchIme"]=84]="kSwitchIme";AcceleratorAction[AcceleratorAction["kSwitchToLastUsedIme"]=85]="kSwitchToLastUsedIme";AcceleratorAction[AcceleratorAction["kSwitchToNextIme"]=86]="kSwitchToNextIme";AcceleratorAction[AcceleratorAction["kSwitchToNextUser"]=87]="kSwitchToNextUser";AcceleratorAction[AcceleratorAction["kSwitchToPreviousUser"]=88]="kSwitchToPreviousUser";AcceleratorAction[AcceleratorAction["kTakePartialScreenshot"]=89]="kTakePartialScreenshot";AcceleratorAction[AcceleratorAction["kTakeScreenshot"]=90]="kTakeScreenshot";AcceleratorAction[AcceleratorAction["kTakeWindowScreenshot"]=91]="kTakeWindowScreenshot";AcceleratorAction[AcceleratorAction["kToggleAppList"]=92]="kToggleAppList";AcceleratorAction[AcceleratorAction["kToggleCalendar"]=93]="kToggleCalendar";AcceleratorAction[AcceleratorAction["kToggleCapsLock"]=94]="kToggleCapsLock";AcceleratorAction[AcceleratorAction["kToggleClipboardHistory"]=95]="kToggleClipboardHistory";AcceleratorAction[AcceleratorAction["kToggleDockedMagnifier"]=96]="kToggleDockedMagnifier";AcceleratorAction[AcceleratorAction["kToggleFloating"]=97]="kToggleFloating";AcceleratorAction[AcceleratorAction["kToggleFullscreen"]=98]="kToggleFullscreen";AcceleratorAction[AcceleratorAction["kToggleFullscreenMagnifier"]=99]="kToggleFullscreenMagnifier";AcceleratorAction[AcceleratorAction["kToggleGameDashboard"]=100]="kToggleGameDashboard";AcceleratorAction[AcceleratorAction["kToggleHighContrast"]=101]="kToggleHighContrast";AcceleratorAction[AcceleratorAction["kToggleMaximized"]=102]="kToggleMaximized";AcceleratorAction[AcceleratorAction["kToggleMessageCenterBubble"]=103]="kToggleMessageCenterBubble";AcceleratorAction[AcceleratorAction["kToggleMirrorMode"]=104]="kToggleMirrorMode";AcceleratorAction[AcceleratorAction["kToggleMultitaskMenu"]=105]="kToggleMultitaskMenu";AcceleratorAction[AcceleratorAction["kToggleOverview"]=106]="kToggleOverview";AcceleratorAction[AcceleratorAction["kToggleProjectorMarker"]=107]="kToggleProjectorMarker";AcceleratorAction[AcceleratorAction["kToggleResizeLockMenu"]=108]="kToggleResizeLockMenu";AcceleratorAction[AcceleratorAction["kToggleSnapGroup"]=109]="kToggleSnapGroup";AcceleratorAction[AcceleratorAction["kToggleSnapGroupWindowsMinimizeAndRestore"]=110]="kToggleSnapGroupWindowsMinimizeAndRestore";AcceleratorAction[AcceleratorAction["kToggleSpokenFeedback"]=111]="kToggleSpokenFeedback";AcceleratorAction[AcceleratorAction["kToggleStylusTools"]=112]="kToggleStylusTools";AcceleratorAction[AcceleratorAction["kToggleSystemTrayBubble"]=113]="kToggleSystemTrayBubble";AcceleratorAction[AcceleratorAction["kToggleWifi"]=114]="kToggleWifi";AcceleratorAction[AcceleratorAction["kTouchHudClear"]=115]="kTouchHudClear";AcceleratorAction[AcceleratorAction["kTouchHudModeChange"]=116]="kTouchHudModeChange";AcceleratorAction[AcceleratorAction["kTouchFingerprintSensor1"]=117]="kTouchFingerprintSensor1";AcceleratorAction[AcceleratorAction["kTouchFingerprintSensor2"]=118]="kTouchFingerprintSensor2";AcceleratorAction[AcceleratorAction["kTouchFingerprintSensor3"]=119]="kTouchFingerprintSensor3";AcceleratorAction[AcceleratorAction["kUnpin"]=120]="kUnpin";AcceleratorAction[AcceleratorAction["kVolumeDown"]=121]="kVolumeDown";AcceleratorAction[AcceleratorAction["kVolumeMute"]=122]="kVolumeMute";AcceleratorAction[AcceleratorAction["kVolumeUp"]=123]="kVolumeUp";AcceleratorAction[AcceleratorAction["kWindowCycleSnapLeft"]=124]="kWindowCycleSnapLeft";AcceleratorAction[AcceleratorAction["kWindowCycleSnapRight"]=125]="kWindowCycleSnapRight";AcceleratorAction[AcceleratorAction["kWindowMinimize"]=126]="kWindowMinimize";AcceleratorAction[AcceleratorAction["kMinimizeTopWindowOnBack"]=127]="kMinimizeTopWindowOnBack";AcceleratorAction[AcceleratorAction["kVolumeMuteToggle"]=128]="kVolumeMuteToggle";AcceleratorAction[AcceleratorAction["kToggleQuickInsert"]=129]="kToggleQuickInsert";AcceleratorAction[AcceleratorAction["kAccessibilityAction"]=130]="kAccessibilityAction";AcceleratorAction[AcceleratorAction["kEnableSelectToSpeak"]=131]="kEnableSelectToSpeak";AcceleratorAction[AcceleratorAction["kTilingWindowResizeLeft"]=132]="kTilingWindowResizeLeft";AcceleratorAction[AcceleratorAction["kTilingWindowResizeRight"]=133]="kTilingWindowResizeRight";AcceleratorAction[AcceleratorAction["kTilingWindowResizeUp"]=134]="kTilingWindowResizeUp";AcceleratorAction[AcceleratorAction["kTilingWindowResizeDown"]=135]="kTilingWindowResizeDown";AcceleratorAction[AcceleratorAction["kToggleMouseKeys"]=136]="kToggleMouseKeys";AcceleratorAction[AcceleratorAction["kResizePipWindow"]=137]="kResizePipWindow";AcceleratorAction[AcceleratorAction["kToggleGeminiApp"]=138]="kToggleGeminiApp";AcceleratorAction[AcceleratorAction["kToggleDoNotDisturb"]=139]="kToggleDoNotDisturb";AcceleratorAction[AcceleratorAction["kToggleCameraAllowed"]=140]="kToggleCameraAllowed";AcceleratorAction[AcceleratorAction["kStartSunfishSession"]=141]="kStartSunfishSession";AcceleratorAction[AcceleratorAction["kDebugClearUseKMeansPref"]=9e3]="kDebugClearUseKMeansPref";AcceleratorAction[AcceleratorAction["kDebugKeyboardBacklightToggle"]=9001]="kDebugKeyboardBacklightToggle";AcceleratorAction[AcceleratorAction["kDebugMicrophoneMuteToggle"]=9002]="kDebugMicrophoneMuteToggle";AcceleratorAction[AcceleratorAction["kDebugPrintLayerHierarchy"]=9003]="kDebugPrintLayerHierarchy";AcceleratorAction[AcceleratorAction["kDebugPrintViewHierarchy"]=9004]="kDebugPrintViewHierarchy";AcceleratorAction[AcceleratorAction["kDebugPrintWindowHierarchy"]=9005]="kDebugPrintWindowHierarchy";AcceleratorAction[AcceleratorAction["kDebugShowInformedRestore"]=9006]="kDebugShowInformedRestore";AcceleratorAction[AcceleratorAction["kDebugShowToast"]=9007]="kDebugShowToast";AcceleratorAction[AcceleratorAction["kDebugShowSystemNudge"]=9008]="kDebugShowSystemNudge";AcceleratorAction[AcceleratorAction["kDebugSystemUiStyleViewer"]=9009]="kDebugSystemUiStyleViewer";AcceleratorAction[AcceleratorAction["kDebugToggleDarkMode"]=9010]="kDebugToggleDarkMode";AcceleratorAction[AcceleratorAction["kDebugToggleDynamicColor"]=9011]="kDebugToggleDynamicColor";AcceleratorAction[AcceleratorAction["kDebugTogglePowerButtonMenu"]=9012]="kDebugTogglePowerButtonMenu";AcceleratorAction[AcceleratorAction["kDebugToggleShowDebugBorders"]=9013]="kDebugToggleShowDebugBorders";AcceleratorAction[AcceleratorAction["kDebugToggleShowFpsCounter"]=9014]="kDebugToggleShowFpsCounter";AcceleratorAction[AcceleratorAction["kDebugToggleShowPaintRects"]=9015]="kDebugToggleShowPaintRects";AcceleratorAction[AcceleratorAction["kDebugToggleTouchPad"]=9016]="kDebugToggleTouchPad";AcceleratorAction[AcceleratorAction["kDebugToggleTouchScreen"]=9017]="kDebugToggleTouchScreen";AcceleratorAction[AcceleratorAction["kDebugToggleTabletMode"]=9018]="kDebugToggleTabletMode";AcceleratorAction[AcceleratorAction["kDebugToggleVideoConferenceCameraTrayIcon"]=9019]="kDebugToggleVideoConferenceCameraTrayIcon";AcceleratorAction[AcceleratorAction["kDebugToggleWallpaperMode"]=9020]="kDebugToggleWallpaperMode";AcceleratorAction[AcceleratorAction["kDebugTriggerCrash"]=9021]="kDebugTriggerCrash";AcceleratorAction[AcceleratorAction["kDebugToggleHudDisplay"]=9022]="kDebugToggleHudDisplay";AcceleratorAction[AcceleratorAction["kDebugToggleVirtualTrackpad"]=9023]="kDebugToggleVirtualTrackpad";AcceleratorAction[AcceleratorAction["kDevAddRemoveDisplay"]=9024]="kDevAddRemoveDisplay";AcceleratorAction[AcceleratorAction["kDevToggleAppList"]=9025]="kDevToggleAppList";AcceleratorAction[AcceleratorAction["kDevToggleUnifiedDesktop"]=9026]="kDevToggleUnifiedDesktop";AcceleratorAction[AcceleratorAction["kDebugToggleFocusModeState"]=9027]="kDebugToggleFocusModeState";AcceleratorAction[AcceleratorAction["kDebugStartSunfishSession"]=9028]="kDebugStartSunfishSession";AcceleratorAction[AcceleratorAction["kDebugShowTestWindow"]=9029]="kDebugShowTestWindow"})(AcceleratorAction||(AcceleratorAction={}));
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const VKeySpec={$:mojo.internal.Enum()};var VKey;(function(VKey){VKey[VKey["MIN_VALUE"]=0]="MIN_VALUE";VKey[VKey["MAX_VALUE"]=65295]="MAX_VALUE";VKey[VKey["kCancel"]=3]="kCancel";VKey[VKey["kBack"]=8]="kBack";VKey[VKey["kTab"]=9]="kTab";VKey[VKey["kBackTab"]=10]="kBackTab";VKey[VKey["kClear"]=12]="kClear";VKey[VKey["kReturn"]=13]="kReturn";VKey[VKey["kShift"]=16]="kShift";VKey[VKey["kControl"]=17]="kControl";VKey[VKey["kMenu"]=18]="kMenu";VKey[VKey["kPause"]=19]="kPause";VKey[VKey["kCapital"]=20]="kCapital";VKey[VKey["kKana"]=21]="kKana";VKey[VKey["kHangul"]=21]="kHangul";VKey[VKey["kPaste"]=22]="kPaste";VKey[VKey["kJunja"]=23]="kJunja";VKey[VKey["kFinal"]=24]="kFinal";VKey[VKey["kHanja"]=25]="kHanja";VKey[VKey["kKanji"]=25]="kKanji";VKey[VKey["kEscape"]=27]="kEscape";VKey[VKey["kConvert"]=28]="kConvert";VKey[VKey["kNonConvert"]=29]="kNonConvert";VKey[VKey["kAccept"]=30]="kAccept";VKey[VKey["kModeChange"]=31]="kModeChange";VKey[VKey["kSpace"]=32]="kSpace";VKey[VKey["kPrior"]=33]="kPrior";VKey[VKey["kNext"]=34]="kNext";VKey[VKey["kEnd"]=35]="kEnd";VKey[VKey["kHome"]=36]="kHome";VKey[VKey["kLeft"]=37]="kLeft";VKey[VKey["kUp"]=38]="kUp";VKey[VKey["kRight"]=39]="kRight";VKey[VKey["kDown"]=40]="kDown";VKey[VKey["kSelect"]=41]="kSelect";VKey[VKey["kPrint"]=42]="kPrint";VKey[VKey["kExecute"]=43]="kExecute";VKey[VKey["kSnapshot"]=44]="kSnapshot";VKey[VKey["kInsert"]=45]="kInsert";VKey[VKey["kDelete"]=46]="kDelete";VKey[VKey["kHelp"]=47]="kHelp";VKey[VKey["kNum0"]=48]="kNum0";VKey[VKey["kNum1"]=49]="kNum1";VKey[VKey["kNum2"]=50]="kNum2";VKey[VKey["kNum3"]=51]="kNum3";VKey[VKey["kNum4"]=52]="kNum4";VKey[VKey["kNum5"]=53]="kNum5";VKey[VKey["kNum6"]=54]="kNum6";VKey[VKey["kNum7"]=55]="kNum7";VKey[VKey["kNum8"]=56]="kNum8";VKey[VKey["kNum9"]=57]="kNum9";VKey[VKey["kKeyA"]=65]="kKeyA";VKey[VKey["kKeyB"]=66]="kKeyB";VKey[VKey["kKeyC"]=67]="kKeyC";VKey[VKey["kKeyD"]=68]="kKeyD";VKey[VKey["kKeyE"]=69]="kKeyE";VKey[VKey["kKeyF"]=70]="kKeyF";VKey[VKey["kKeyG"]=71]="kKeyG";VKey[VKey["kKeyH"]=72]="kKeyH";VKey[VKey["kKeyI"]=73]="kKeyI";VKey[VKey["kKeyJ"]=74]="kKeyJ";VKey[VKey["kKeyK"]=75]="kKeyK";VKey[VKey["kKeyL"]=76]="kKeyL";VKey[VKey["kKeyM"]=77]="kKeyM";VKey[VKey["kKeyN"]=78]="kKeyN";VKey[VKey["kKeyO"]=79]="kKeyO";VKey[VKey["kKeyP"]=80]="kKeyP";VKey[VKey["kKeyQ"]=81]="kKeyQ";VKey[VKey["kKeyR"]=82]="kKeyR";VKey[VKey["kKeyS"]=83]="kKeyS";VKey[VKey["kKeyT"]=84]="kKeyT";VKey[VKey["kKeyU"]=85]="kKeyU";VKey[VKey["kKeyV"]=86]="kKeyV";VKey[VKey["kKeyW"]=87]="kKeyW";VKey[VKey["kKeyX"]=88]="kKeyX";VKey[VKey["kKeyY"]=89]="kKeyY";VKey[VKey["kKeyZ"]=90]="kKeyZ";VKey[VKey["kLWin"]=91]="kLWin";VKey[VKey["kCommand"]=91]="kCommand";VKey[VKey["kRWin"]=92]="kRWin";VKey[VKey["kApps"]=93]="kApps";VKey[VKey["kSleep"]=95]="kSleep";VKey[VKey["kNumpad0"]=96]="kNumpad0";VKey[VKey["kNumpad1"]=97]="kNumpad1";VKey[VKey["kNumpad2"]=98]="kNumpad2";VKey[VKey["kNumpad3"]=99]="kNumpad3";VKey[VKey["kNumpad4"]=100]="kNumpad4";VKey[VKey["kNumpad5"]=101]="kNumpad5";VKey[VKey["kNumpad6"]=102]="kNumpad6";VKey[VKey["kNumpad7"]=103]="kNumpad7";VKey[VKey["kNumpad8"]=104]="kNumpad8";VKey[VKey["kNumpad9"]=105]="kNumpad9";VKey[VKey["kMultiply"]=106]="kMultiply";VKey[VKey["kAdd"]=107]="kAdd";VKey[VKey["kSeparator"]=108]="kSeparator";VKey[VKey["kSubtract"]=109]="kSubtract";VKey[VKey["kDecimal"]=110]="kDecimal";VKey[VKey["kDivide"]=111]="kDivide";VKey[VKey["kF1"]=112]="kF1";VKey[VKey["kF2"]=113]="kF2";VKey[VKey["kF3"]=114]="kF3";VKey[VKey["kF4"]=115]="kF4";VKey[VKey["kF5"]=116]="kF5";VKey[VKey["kF6"]=117]="kF6";VKey[VKey["kF7"]=118]="kF7";VKey[VKey["kF8"]=119]="kF8";VKey[VKey["kF9"]=120]="kF9";VKey[VKey["kF10"]=121]="kF10";VKey[VKey["kF11"]=122]="kF11";VKey[VKey["kF12"]=123]="kF12";VKey[VKey["kF13"]=124]="kF13";VKey[VKey["kF14"]=125]="kF14";VKey[VKey["kF15"]=126]="kF15";VKey[VKey["kF16"]=127]="kF16";VKey[VKey["kF17"]=128]="kF17";VKey[VKey["kF18"]=129]="kF18";VKey[VKey["kF19"]=130]="kF19";VKey[VKey["kF20"]=131]="kF20";VKey[VKey["kF21"]=132]="kF21";VKey[VKey["kF22"]=133]="kF22";VKey[VKey["kF23"]=134]="kF23";VKey[VKey["kF24"]=135]="kF24";VKey[VKey["kNumLock"]=144]="kNumLock";VKey[VKey["kScroll"]=145]="kScroll";VKey[VKey["kLShift"]=160]="kLShift";VKey[VKey["kRShift"]=161]="kRShift";VKey[VKey["kLControl"]=162]="kLControl";VKey[VKey["kRControl"]=163]="kRControl";VKey[VKey["kLMenu"]=164]="kLMenu";VKey[VKey["kRMenu"]=165]="kRMenu";VKey[VKey["kBrowserBack"]=166]="kBrowserBack";VKey[VKey["kBrowserForward"]=167]="kBrowserForward";VKey[VKey["kBrowserRefresh"]=168]="kBrowserRefresh";VKey[VKey["kBrowserStop"]=169]="kBrowserStop";VKey[VKey["kBrowserSearch"]=170]="kBrowserSearch";VKey[VKey["kBrowserFavorites"]=171]="kBrowserFavorites";VKey[VKey["kBrowserHome"]=172]="kBrowserHome";VKey[VKey["kVolumeMute"]=173]="kVolumeMute";VKey[VKey["kVolumeDown"]=174]="kVolumeDown";VKey[VKey["kVolumeUp"]=175]="kVolumeUp";VKey[VKey["kMediaNextTrack"]=176]="kMediaNextTrack";VKey[VKey["kMediaPrevTrack"]=177]="kMediaPrevTrack";VKey[VKey["kMediaStop"]=178]="kMediaStop";VKey[VKey["kMediaPlayPause"]=179]="kMediaPlayPause";VKey[VKey["kMediaLaunchMail"]=180]="kMediaLaunchMail";VKey[VKey["kMediaLaunchMediaSelect"]=181]="kMediaLaunchMediaSelect";VKey[VKey["kMediaLaunchApp1"]=182]="kMediaLaunchApp1";VKey[VKey["kMediaLaunchApp2"]=183]="kMediaLaunchApp2";VKey[VKey["kOem1"]=186]="kOem1";VKey[VKey["kOemPlus"]=187]="kOemPlus";VKey[VKey["kOemComma"]=188]="kOemComma";VKey[VKey["kOemMinus"]=189]="kOemMinus";VKey[VKey["kOemPeriod"]=190]="kOemPeriod";VKey[VKey["kOem2"]=191]="kOem2";VKey[VKey["kOem3"]=192]="kOem3";VKey[VKey["kOem4"]=219]="kOem4";VKey[VKey["kOem5"]=220]="kOem5";VKey[VKey["kOem6"]=221]="kOem6";VKey[VKey["kOem7"]=222]="kOem7";VKey[VKey["kOem8"]=223]="kOem8";VKey[VKey["kOem102"]=226]="kOem102";VKey[VKey["kOem103"]=227]="kOem103";VKey[VKey["kOem104"]=228]="kOem104";VKey[VKey["kProcessKey"]=229]="kProcessKey";VKey[VKey["kPacket"]=231]="kPacket";VKey[VKey["kOemAttn"]=240]="kOemAttn";VKey[VKey["kOemFinish"]=241]="kOemFinish";VKey[VKey["kOemCopy"]=242]="kOemCopy";VKey[VKey["kDbeSbcsChar"]=243]="kDbeSbcsChar";VKey[VKey["kDbeDbcsChar"]=244]="kDbeDbcsChar";VKey[VKey["kOemBacktab"]=245]="kOemBacktab";VKey[VKey["kAttn"]=246]="kAttn";VKey[VKey["kCrsel"]=247]="kCrsel";VKey[VKey["kExsel"]=248]="kExsel";VKey[VKey["kEreof"]=249]="kEreof";VKey[VKey["kPlay"]=250]="kPlay";VKey[VKey["kZoom"]=251]="kZoom";VKey[VKey["kNoName"]=252]="kNoName";VKey[VKey["kPA1"]=253]="kPA1";VKey[VKey["kOemClear"]=254]="kOemClear";VKey[VKey["kFunction"]=255]="kFunction";VKey[VKey["kQuickInsert"]=256]="kQuickInsert";VKey[VKey["kAccessibility"]=257]="kAccessibility";VKey[VKey["kDoNotDisturb"]=258]="kDoNotDisturb";VKey[VKey["kCameraAccessToggle"]=259]="kCameraAccessToggle";VKey[VKey["kUnknown"]=0]="kUnknown";VKey[VKey["kWlan"]=151]="kWlan";VKey[VKey["kPower"]=152]="kPower";VKey[VKey["kAssistant"]=153]="kAssistant";VKey[VKey["kSettings"]=154]="kSettings";VKey[VKey["kPrivacyScreenToggle"]=155]="kPrivacyScreenToggle";VKey[VKey["kMicrophoneMuteToggle"]=159]="kMicrophoneMuteToggle";VKey[VKey["kBrightnessDown"]=216]="kBrightnessDown";VKey[VKey["kBrightnessUp"]=217]="kBrightnessUp";VKey[VKey["kKbdBrightnessToggle"]=184]="kKbdBrightnessToggle";VKey[VKey["kKbdBrightnessDown"]=218]="kKbdBrightnessDown";VKey[VKey["kKbdBrightnessUp"]=232]="kKbdBrightnessUp";VKey[VKey["kAltGr"]=225]="kAltGr";VKey[VKey["kCompose"]=230]="kCompose";VKey[VKey["kMediaPlay"]=233]="kMediaPlay";VKey[VKey["kMediaPause"]=234]="kMediaPause";VKey[VKey["kNew"]=235]="kNew";VKey[VKey["kClose"]=236]="kClose";VKey[VKey["kEmojiPicker"]=237]="kEmojiPicker";VKey[VKey["kDictate"]=238]="kDictate";VKey[VKey["kAllApplications"]=239]="kAllApplications";VKey[VKey["kButton0"]=65280]="kButton0";VKey[VKey["kButton1"]=65281]="kButton1";VKey[VKey["kButton2"]=65282]="kButton2";VKey[VKey["kButton3"]=65283]="kButton3";VKey[VKey["kButton4"]=65284]="kButton4";VKey[VKey["kButton5"]=65285]="kButton5";VKey[VKey["kButton6"]=65286]="kButton6";VKey[VKey["kButton7"]=65287]="kButton7";VKey[VKey["kButton8"]=65288]="kButton8";VKey[VKey["kButton9"]=65289]="kButton9";VKey[VKey["kButtonA"]=65290]="kButtonA";VKey[VKey["kButtonB"]=65291]="kButtonB";VKey[VKey["kButtonC"]=65292]="kButtonC";VKey[VKey["kButtonX"]=65293]="kButtonX";VKey[VKey["kButtonY"]=65294]="kButtonY";VKey[VKey["kButtonZ"]=65295]="kButtonZ"})(VKey||(VKey={}));
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const ExtendedFkeysModifierSpec={$:mojo.internal.Enum()};var ExtendedFkeysModifier;(function(ExtendedFkeysModifier){ExtendedFkeysModifier[ExtendedFkeysModifier["MIN_VALUE"]=0]="MIN_VALUE";ExtendedFkeysModifier[ExtendedFkeysModifier["MAX_VALUE"]=3]="MAX_VALUE";ExtendedFkeysModifier[ExtendedFkeysModifier["kDisabled"]=0]="kDisabled";ExtendedFkeysModifier[ExtendedFkeysModifier["kAlt"]=1]="kAlt";ExtendedFkeysModifier[ExtendedFkeysModifier["kShift"]=2]="kShift";ExtendedFkeysModifier[ExtendedFkeysModifier["kCtrlShift"]=3]="kCtrlShift"})(Extend