// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'app-language-selection-item' is part of app language picker
 * dialog to display language option in a single row.
 */
import 'chrome://resources/ash/common/cr_elements/cr_shared_style.css.js';
import '../../settings_shared.css.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { getTemplate } from './app_language_selection_item.html.js';
export class AppLanguageSelectionItemElement extends PolymerElement {
    static get is() {
        return 'app-language-selection-item';
    }
    static get template() {
        return getTemplate();
    }
    static get properties() {
        return {
            index: Number,
            item: Object,
            selected: {
                type: Boolean,
                value: false,
            },
        };
    }
    getDisplayText_() {
        let name = this.item.displayName;
        if (name === '') {
            // If displayName couldn't be translated, we'll display the localeTag
            // instead.
            return this.item.localeTag;
        }
        if (this.item.nativeDisplayName !== '' &&
            this.item.nativeDisplayName !== name) {
            name += ' - ' + this.item.nativeDisplayName;
        }
        return name;
    }
    getAriaSelected_() {
        return this.selected ? 'true' : 'false';
    }
}
customElements.define(AppLanguageSelectionItemElement.is, AppLanguageSelectionItemElement);
