// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * Getters for loadTimeData booleans used throughout CrOS Settings.
 * Export them as functions so they reload the values when overridden in tests.
 * Organize the getter functions by their respective pages.
 */
import { loadTimeData } from 'chrome://resources/js/load_time_data.js';
// General
export function isGuest() {
    return loadTimeData.getBoolean('isGuest');
}
export function isChild() {
    return loadTimeData.getBoolean('isChild');
}
export function isSecondaryUser() {
    return loadTimeData.getBoolean('isSecondaryUser');
}
// Apps page
export function androidAppsVisible() {
    return loadTimeData.getBoolean('androidAppsVisible');
}
export function isArcVmEnabled() {
    return loadTimeData.getBoolean('isArcVmEnabled');
}
export function isPlayStoreAvailable() {
    return loadTimeData.getBoolean('isPlayStoreAvailable');
}
export function isPluginVmAvailable() {
    return loadTimeData.getBoolean('isPluginVmAvailable');
}
export function isAppParentalControlsFeatureAvailable() {
    return loadTimeData.getBoolean('isAppParentalControlsFeatureAvailable');
}
// Crostini page
export function isCrostiniAllowed() {
    return loadTimeData.getBoolean('isCrostiniAllowed');
}
export function isCrostiniSupported() {
    return loadTimeData.getBoolean('isCrostiniSupported');
}
// Device page
export function isExternalStorageEnabled() {
    return loadTimeData.getBoolean('isExternalStorageEnabled');
}
export function isDisplayBrightnessControlInSettingsEnabled() {
    return loadTimeData.getBoolean('enableDisplayBrightnessControlInSettings');
}
export function isSkyVaultEnabled() {
    return loadTimeData.getBoolean('enableSkyVault');
}
// Kerberos page
export function isKerberosEnabled() {
    return loadTimeData.getBoolean('isKerberosEnabled');
}
// People page
export function isAccountManagerEnabled() {
    return loadTimeData.getBoolean('isAccountManagerEnabled');
}
// Reset page
export function isPowerwashAllowed() {
    return loadTimeData.getBoolean('allowPowerwash');
}
// Reset page
export function isSanitizeAllowed() {
    return loadTimeData.getBoolean('allowSanitize');
}
// Search page
export function isQuickAnswersSupported() {
    return loadTimeData.getBoolean('isQuickAnswersSupported');
}
export function isMagicBoostFeatureEnabled() {
    return loadTimeData.getBoolean('isMagicBoostFeatureEnabled');
}
export function isMagicBoostNoticeBannerVisible() {
    return loadTimeData.getBoolean('isMagicBoostNoticeBannerVisible');
}
export function isLobsterSettingsToggleVisible() {
    return loadTimeData.getBoolean('isLobsterSettingsToggleVisible');
}
export function isScannerSettingsToggleVisible() {
    return loadTimeData.getBoolean('isScannerSettingsToggleVisible');
}
// System preferences page
export function shouldShowStartup() {
    return loadTimeData.getBoolean('shouldShowStartup');
}
// Power page
export function isBatteryChargeLimitAvailable() {
    return loadTimeData.getBoolean('isBatteryChargeLimitAvailable');
}
