import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-shared-style cros-color-overrides">cr-dialog::part(dialog){width:320px}#passwordInput{margin-top:20px}</style>
<cr-dialog id="dialog" close-text="$i18n{close}">
  <div slot="title">$i18n{passwordPromptTitle}</div>
  <div slot="body">
    <div id="passwordPrompt" hidden="[[!passwordPromptText]]">
      [[passwordPromptText]]
    </div>
    <cr-input id="passwordInput" type="password"
        placeholder="$i18n{passwordPromptPasswordLabel}"
        invalid="[[passwordInvalid_]]"
        error-message="$i18n{passwordPromptInvalidPassword}"
        value="{{inputValue_}}"
        aria-disabled="false">
    </cr-input>
  </div>
  <div slot="button-container">
    <cr-button class="cancel-button" on-click="onCancelClick_">
      $i18n{cancel}
    </cr-button>

    <cr-button id="confirmButton" class="action-button"
        disabled$="[[!isConfirmEnabled_(inputValue_, passwordInvalid_,
            waitingForPasswordCheck_)]]"
        on-click="submitPassword_">
      $i18n{confirm}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
