import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared"></style>
<cr-link-row
    class="hr"
    label="$i18n{guestOsSharedUsbDevicesLabel}"
    id="bruschettaSharedUsbDevicesRow"
    on-click="onSharedUsbDevicesClick_"
    role-description="$i18n{subpageArrowRoleDescription}">
</cr-link-row>

<cr-link-row
    class="hr"
    label="$i18n{guestOsSharedPaths}"
    id="bruschettaSharedPathsRow"
    on-click="onSharedPathsClick_"
    role-description="$i18n{subpageArrowRoleDescription}">
</cr-link-row>

<settings-toggle-button
    class="hr"
    id="bruschetta-mic-permission-toggle"
    pref="{{prefs.bruschetta.mic_allowed}}"
    no-set-pref
    label="$i18n{bruschettaMicTitle}"
    on-settings-boolean-control-change="onMicPermissionChange_"
    deep-link-focus-id$="[[Setting.kBruschettaMicAccess]]">
</settings-toggle-button>
<template is="dom-if" if="[[showBruschettaMicPermissionDialog_]]" restamp>
  <settings-guest-os-confirmation-dialog
      id="bruschetta-mic-permission-dialog"
      accept-button-text="$i18n{bruschettaMicDialogShutdownButton}"
      on-close="onBruschettaMicPermissionDialogClose_">
    <div slot="body">$i18n{bruschettaMicDialogLabel}</div>
  </settings-guest-os-confirmation-dialog>
</template>
<div id="remove" class="settings-box">
  <div id="removeBruschettaLabel" class="start" aria-hidden="true">
    $i18n{bruschettaRemove}
  </div>
  <cr-button on-click="onRemoveClick_"
      aria-label="$i18n{bruschettaRemoveButton}"
      aria-describedby="removeBruschettaLabel">
    $i18n{bruschettaRemoveButton}
  </cr-button>
</div>
<!--_html_template_end_-->`;
}
