import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared md-select">.custom-button-container{float:right}.input-container{display:flex;flex-direction:row;justify-content:space-between}.advanced-section{display:flex;flex-direction:column;justify-content:space-between;padding-bottom:12px;padding-inline-start:20px}.custom-body{padding-bottom:20px}#advancedToggle{--ink-color:var(--cros-text-color-primary);background:none;border:none;box-shadow:none;color:var(--cros-text-color-primary);font-weight:400;margin-bottom:12px;min-height:32px;padding-inline-start:0}#containerFileField{display:flex;flex-direction:row}#containerFileInput{width:100%}</style>
<cr-dialog id="dialog" close-text="$i18n{close}">
  <div slot="title">$i18n{crostiniExtraContainersCreateDialogTitle}</div>
  <div slot="body">
    <div class="input-container">
      <cr-input id="containerNameInput"
          label="$i18n{crostiniExtraContainersContainerNameLabel}"
          aria-disabled="false"
          on-input="validateNames_"
          invalid="[[!validContainerName_]]"
          error-message="[[containerNameError_]]">
      </cr-input>
      <cr-input id="vmNameInput"
          label="$i18n{crostiniExtraContainersVmNameLabel}"
          aria-disabled="false"
          on-input="validateNames_">
      </cr-input>
    </div>

    <cr-button id="advancedToggle" on-click="advancedToggleClicked_"
        aria-expanded$="[[boolToString_(advancedToggleExpanded_)]]">
      <span>$i18n{advancedPageTitle}</span>
      <iron-icon
        icon="[[getArrowIcon_(advancedToggleExpanded_)]]"
        slot="suffix-icon">
      </iron-icon>
    </cr-button>
    <div class="advanced-section" hidden="[[!advancedToggleExpanded_]]">
      <cr-input id="imageServerInput"
        label="$i18n{crostiniExtraContainersCreateDialogImageServer}"
        aria-disabled="false">
      </cr-input>
      <cr-input id="imageAliasInput"
        label="$i18n{crostiniExtraContainersCreateDialogImageAlias}"
        aria-disabled="false">
      </cr-input>
      <div id="containerFileField">
        <cr-input id="containerFileInput"
          label="$i18n{crostiniExtraContainersCreateDialogAddContainerFile}"
          aria-disabled="true"
          readonly>
          <cr-button id="uploadButton"
            slot="suffix"
            on-click="onSelectContainerFileClick_"
            aria-labelledby="containerFileInput">
            $i18n{crostiniExtraContainersCreateDialogAddContainerButtonLabel}
          </cr-button>
        </cr-input>
      </div>
    </div>
  </div>

  <div slot="body" class="custom-body">
    <div slot="button-container" class="custom-button-container">
      <cr-button id="cancel" class="cancel-button" on-click="onCancelClick_">
        $i18n{cancel}
      </cr-button>
      <cr-button id="create" class="action-button" on-click="onCreateClick_"
          disabled="[[disableCreateButton_]]">
        $i18n{crostiniExtraContainersCreate}
      </cr-button>
    </div>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
