import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared md-select">#portNumberInput{padding-inline-end:20px;width:376px}#portLabelInput{padding-top:20px;width:472px}#selectProtocol{max-width:96px}.custom-body{padding-bottom:20px}.custom-button-container{float:right}.input-container{display:flex;flex-direction:row;justify-content:space-between}.placeholder-label{visibility:hidden}</style>
<cr-dialog id="dialog" close-text="$i18n{close}">
  <div slot="title">$i18n{crostiniPortForwardingAddPortDialogTitle}</div>
  <div slot="body">
    <div class="input-container">
      <cr-input id="portNumberInput"
          label="$i18n{crostiniPortForwardingAddPortDialogPortNumberLabel}"
          aria-disabled="false"
          error-message="[[portState_]]"
          type="number"
          min="1024"
          max="65535"
          on-blur="onBlur_">
      </cr-input>
      <div>
        <div id="label" class="cr-form-field-label placeholder-label"
            aria-hidden="true">
            ""
        </div>
        <select id="selectProtocol"
            class="md-select"
            value="$i18n{crostiniPortForwardingTCP}"
            on-change="onSelectProtocol_">
          <option value="$i18n{crostiniPortForwardingTCP}">
            $i18n{crostiniPortForwardingTCP}
          </option>
          <option value="$i18n{crostiniPortForwardingUDP}">
            $i18n{crostiniPortForwardingUDP}
          </option>
        </select>
      </div>
    </div>
    <template is="dom-if" if="[[showContainerSelect_(allContainers)]]" restamp>
      <settings-guest-os-container-select
          containers="[[allContainers]]"
          selected-container-id="{{containerId_}}"
          default-vm-name="[[defaultVmName_]]">
      </settings-guest-os-container-select>
    </template>
    <div slot="body">
      <cr-input id="portLabelInput"
          label="$i18n{crostiniPortForwardingAddPortDialogLabelLabel}"
          aria-disabled="false"
          maxlength="50">
      </cr-input>
    </div>
  </div>
  <div slot="body" class="custom-body">
    <div slot="button-container" class="custom-button-container">
      <cr-button id="cancel" class="cancel-button"
          on-click="onCancelClick_">$i18n{cancel}</cr-button>
      <cr-button id="continue" class="action-button"
          on-click="onAddClick_">
          $i18n{add}
      </cr-button>
    </div>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
