import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">#timezoneSelectorContainer{padding-block-end:var(--cr-section-vertical-padding);padding-inline-start:var(--cr-section-indent-padding)}settings-toggle-button{--cr-icon-button-margin-end:16px;--iron-icon-fill-color:var(--cros-sys-primary)}</style>
<settings-card header-text="$i18n{dateTimePageTitle}">
  <template is="dom-if"
      if="[[!prefs.cros.flags.fine_grained_time_zone_detection_enabled.value]]"
      restamp>
    <settings-toggle-button id="timeZoneAutoDetectToggle"
        label="$i18n{timeZoneGeolocation}"
        pref="{{prefs.generated.resolve_timezone_by_geolocation_on_off}}"
        deep-link-focus-id$="[[Setting.kChangeTimeZone]]">
    </settings-toggle-button>
    <div class="hr"></div>
  </template>
  <template is="dom-if"
      if="[[prefs.cros.flags.fine_grained_time_zone_detection_enabled.value]]"
      restamp>
    <cr-link-row id="timeZoneSettingsTrigger"
        start-icon="os-settings:clock"
        on-click="openTimeZoneSubpage_"
        label="$i18n{timeZoneButton}"
        sub-label="[[timeZoneSettingSublabel_]]"
        role-description="$i18n{subpageArrowRoleDescription}">
      <cr-policy-pref-indicator
          pref="[[prefs.generated.resolve_timezone_by_geolocation_on_off]]">
      </cr-policy-pref-indicator>
    </cr-link-row>
  </template>
  <div id="timezoneSelectorContainer"
      hidden="[[prefs.cros.flags.fine_grained_time_zone_detection_enabled.value]]">
    <timezone-selector prefs="{{prefs}}"
        active-time-zone-display-name="{{activeTimeZoneDisplayName}}">
    </timezone-selector>
  </div>
  <settings-toggle-button
      class="hr"
      icon="os-settings:24hour"
      pref="{{prefs.settings.clock.use_24hour_clock}}"
      label="$i18n{use24HourClock}"
      deep-link-focus-id$="[[Setting.k24HourClock]]">
  </settings-toggle-button>
  <cr-link-row class="hr" id="setDateTimeRow"
      start-icon="os-settings:set-date-time"
      on-click="onSetDateTimeClick_"
      label="$i18n{setDateTime}"
      hidden$="[[!canSetDateTime_]]">
    <template is="dom-if" if="[[shouldShowManagedByParentIcon_]]">
      <cr-policy-indicator indicator-type="parent"></cr-policy-indicator>
    </template>
  </cr-link-row>
</settings-card>
<!--_html_template_end_-->`;
}
