// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import 'chrome://resources/ash/common/cr_elements/md_select.css.js';
import './input_device_settings_shared.css.js';
import '../settings_shared.css.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { getTemplate } from './customize_button_dropdown_item.html.js';
export class CustomizeButtonDropdownItemElement extends PolymerElement {
    static get is() {
        return 'customize-button-dropdown-item';
    }
    static get template() {
        return getTemplate();
    }
    static get properties() {
        return {
            selected: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
            },
            option: {
                type: Object,
            },
        };
    }
    focus() {
        super.focus();
        this.$.container.focus();
    }
    onDropdownItemSelected_() {
        this.dispatchEvent(new CustomEvent('customize-button-dropdown-selected', {
            bubbles: true,
            composed: true,
            detail: {
                value: this.option.value,
            },
        }));
    }
}
customElements.define(CustomizeButtonDropdownItemElement.is, CustomizeButtonDropdownItemElement);
